       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP014.                                      
COB303 DATE-WRITTEN.     JULY 04,2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------*        
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --*        
      *----------------------------------------------------------------*        
      *--                         S U M M A R Y                      --*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                        MODIFICATION LOG                    --*        
      *--                                                            --*        
      *--  DATE          INITIALS    COMMENTS                        --*        
      *--  -----------   --------    ----------------------------------*        
A05268*--  07/04/2015    VK7L032     CONVERTED THE EAZYTRIVE PGM     --*        
ACT005*--                            PNC014 TO COBOL.                --*        
      *----------------------------------------------------------------*        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSPT33.                                                            
       COPY CSSPT331.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *  - FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
       COPY CFDPT33.                                                            
       COPY CFDPT331.                                                           
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP014'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_EQUIPMENT, EQ                                        *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_GAS_METER, GM                                        *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBGASMTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_GAS_METER_SIZE, M5                                   *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBGASMSZ                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_COMPANY, C7                                          *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCOMPNY                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_GAS_MTR_TEST, GT                                     *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBGMTEST                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_JOB_PARM, G6                                         *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * ABEND SWITCH COPYBOOK                                         *         
      *****************************************************************         
      *                                                                         
           COPY CWS00038.                                                       
      *                                                                         
      *****************************************************************         
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'                *         
      *****************************************************************         
      *                                                                         
           COPY FIOJC01.                                                        
      *                                                                         
      ***************************************************************           
      *                                                             *           
           COPY CWS09900.                                                       
      *                                                             *           
           COPY CWS00303.                                                       
      *                                                             *           
           COPY CWS00010.                                                       
      *                                                             *           
      ***************************************************************           
      *                                                                         
       01 WS-LITERALS.                                                  
           05 WS-PGRMNAME               PIC X(08) VALUE 'PCSRP014'.     
           05 WS-RPT1-TITLE-PGM         PIC X(09) VALUE 'PNC014-01'.    
           05 WS-RPT2-TITLE-PGM         PIC X(09) VALUE 'PNC014-02'.    
           05 WS-RPT1-METER-STATUS      PIC X(06) VALUE 'STATUS'.       
           05 WS-RPT2-METER-STATUS      PIC X(12) VALUE 'TEST RESULTS'. 
           05 WS-INVENTORY              PIC X(09) VALUE 'INVENTORY'.    
           05 WS-TEST-SHOP              PIC X(09) VALUE 'TEST SHOP'.    
           05 WS-PREMISE                PIC X(10) VALUE 'AT PREMISE'.   
           05 WS-RPT1-HEAD1             PIC X(19)                       
                                        VALUE 'NCUC SUMMARY REPORT'.    
           05 WS-RPT2-HEAD2             PIC X(22)                       
                                        VALUE 'NCUC METER TEST REPORT'. 
           05 WS-COMPANY-NO-TOT         PIC X(19)                       
                                        VALUE 'WS-COMPANY-NO TOTAL'.    
           05 WS-26                     PIC X(02) VALUE '26'.           
           05 WS-HDR-EXISTS             PIC X(01) VALUE 'Y'.            
           05 WS-Y                      PIC X(01) VALUE 'Y'.            
           05 WS-N                      PIC X(01) VALUE 'N'.            
           05 WS-COMMON-DATE.                                           
              10 WS-COMMON-CCYY         PIC X(04) VALUE SPACES.         
              10 FILLER                 PIC X(01).                      
              10 WS-COMMON-MM           PIC X(02) VALUE SPACES.         
      *                                                                         
       01 WS-MISC.                                                      
           05 WS-PRINT-REPORT1          PIC X(01) VALUE SPACES.         
           05 WS-PRINT-REPORT2          PIC X(01) VALUE SPACES.         
           05 WS-PAGE-NUM1              PIC 9(02) VALUE ZEROES.         
           05 WS-PAGE-NUM2              PIC 9(02) VALUE ZEROES.         
           05 WS-FCA331-STATUS          PIC X(02) VALUE SPACES.         
COB305     05 WS-ACCURACY-PCT        PIC S9(3)V9(2) USAGE COMP-3 
COB305       VALUE 0.    
           05 WS-PARM-COMP-NO           PIC X(02) VALUE SPACES.         
           05 WS-COMPANY-NO             PIC X(02) VALUE SPACES.         
           05 WS-CCF-CAP-PER-HR         PIC S9(9) USAGE COMP.           
           05 WS-PREV-MTR-STAT          PIC X(01) VALUE SPACES.         
           05 WS-DATA-FOUND             PIC X(01) VALUE SPACES.         
           05 WS-COMP-TOT-COUNT1        PIC 9(06) VALUE ZEROES.         
           05 WS-COMP-TOT-COUNT2        PIC 9(06) VALUE ZEROES.         
           05 WS-COMP-TOT-COUNT3        PIC 9(06) VALUE ZEROES.         
           05 WS-COMP-TOT               PIC 9(06) VALUE ZEROES.         
      *                                                                         
       01 WS-COUNTERS.                                                  
           05 WS-COUNT-1                PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT-2                PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT-3                PIC 9(06) VALUE ZEROES.         
           05 WS-TOTAL                  PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT-SLOW             PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT1-SLOW            PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT2-SLOW            PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT3-SLOW            PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT-DR               PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT1-DR              PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT2-DR              PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT3-DR              PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT-DPG              PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT1-DPG             PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT2-DPG             PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT3-DPG             PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT-FAST             PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT1-FAST            PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT2-FAST            PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT3-FAST            PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT-WITHIN           PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT1-WITHIN          PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT2-WITHIN          PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT3-WITHIN          PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT-NEW              PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT1-NEW             PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT2-NEW             PIC 9(06) VALUE ZEROES.         
           05 WS-COUNT3-NEW             PIC 9(06) VALUE ZEROES.         
           05 WS-TOTAL-SLOW             PIC 9(06) VALUE ZEROES.         
           05 WS-TOTAL-FAST             PIC 9(06) VALUE ZEROES.         
           05 WS-TOTAL-WITHIN           PIC 9(06) VALUE ZEROES.         
           05 WS-TOTAL-NEW              PIC 9(06) VALUE ZEROES.         
           05 WS-TOTAL-DR               PIC 9(06) VALUE ZEROES.         
           05 WS-TOTAL-DPG              PIC 9(06) VALUE ZEROES.         
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                    PIC 9(02).                      
           05  WS-MM                    PIC 9(02).                      
           05  WS-SS                    PIC 9(02).                      
           05  WS-TT                    PIC 9(02).                      
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-SS                 PIC X(02).                      
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                    PIC 9(04).                      
           05  WS-CM                    PIC 9(02).                      
           05  WS-CD                    PIC 9(02).                      
      *                                                                         
       01  WS-REPORT-DATE.                                              
           05  WS-RPT-MM                PIC 9(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RPT-CCYY              PIC 9(04).                      
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-DD                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-YY                 PIC X(02).                      
      *                                                                         
      ***************** PCSRP014 REPORT HEADERS ***********************         
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER               PIC X(02) VALUE SPACES.         
               10  P-RPT1-TITLE-PGM     PIC X(09) VALUE SPACES.         
               10  FILLER               PIC X(36) VALUE SPACES.         
               10  WS-HOLD-TITLE-1      PIC X(74) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE 'PAGE'.         
               10  FILLER               PIC X(05) VALUE SPACES.         
               10  P-RPT1-TITLE-PGNM    PIC Z(02) VALUE SPACES.         
               10  FILLER               PIC X(01) VALUE SPACES.         
      *                                                                         
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER               PIC X(02) VALUE SPACES.         
               10  FILLER               PIC X(13) VALUE 'REPORT DATE :'.
               10  P-RPT1-DATE          PIC X(07).                      
               10  FILLER               PIC X(20) VALUE SPACES.         
               10  P-RPT1-HEAD1         PIC X(72).                      
               10  FILLER               PIC X(10) VALUE 'RUN-DATE: '.   
               10  P-RPT1-RUN-DATE      PIC X(10).                      
               10  FILLER               PIC X(01) VALUE SPACES.         
      *                                                                         
           05  WS-RPT1-HEADER-3.                                        
               10  FILLER               PIC X(114) VALUE SPACES.        
               10  FILLER               PIC X(10) VALUE 'RUN-TIME: '.   
               10  P-RPT1-RUN-TIME      PIC X(08).                      
               10  FILLER               PIC X(01) VALUE SPACES.         
      *                                                                         
           05  WS-RPT1-HEADER-4.                                        
               10  FILLER               PIC X(132) VALUE SPACES.        
      *                                                                         
           05  WS-RPT1-HEADER-5.                                        
               10 FILLER                PIC X(12) VALUE SPACES.         
               10 P-METER-STATUS-RPT2   PIC X(12) VALUE SPACES.         
               10 FILLER                PIC X(11) VALUE SPACES.         
               10 P-COUNT1-RPT1         PIC X(07) VALUE 'GROUP 1'.      
               10 FILLER                PIC X(16) VALUE SPACES.         
               10 P-COUNT2-RPT1         PIC X(07) VALUE 'GROUP 3'.      
               10 FILLER                PIC X(18) VALUE SPACES.         
               10 P-COUNT3-RPT1         PIC X(07) VALUE 'GROUP 4'.      
               10 FILLER                PIC X(42) VALUE SPACES.         
      *                                                                         
           05  WS-RPT1-HEADER-6.                                        
               10 FILLER                PIC X(12) VALUE SPACES.         
               10 P-METER-STATUS-RPT1   PIC X(19) VALUE SPACES.         
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 P-COUNT1-RPT1C        PIC X(13) VALUE '(< 251 CF/HR)'.
               10 FILLER                PIC X(04) VALUE SPACES.         
               10 P-COUNT2-RPT1C        PIC X(26)                       
                                     VALUE '(>= 251 AND <= 1500 CF/HR)'.
               10 FILLER               PIC X(04) VALUE SPACES.          
               10 P-COUNT3-RPT1C       PIC X(14) VALUE '(> 1500 CF/HR)'.
               10 FILLER               PIC X(11) VALUE SPACES.          
               10 P-TOTAL-RPT1         PIC X(05) VALUE 'TOTAL'.         
               10 FILLER               PIC X(16) VALUE SPACES.          
      *                                                                         
       01  WS-DTL-REC.                                                  
           05  FILLER                  PIC X(02) VALUE SPACES.          
           05  WS-METER-STATUS         PIC X(30) VALUE SPACES.          
           05  FILLER                  PIC X(06) VALUE SPACES.          
           05  WS-COUNT1-RPT           PIC 9(06) VALUE ZEROES.          
           05  FILLER                  PIC X(15) VALUE SPACES.          
           05  WS-COUNT2-RPT           PIC 9(06) VALUE ZEROES.          
           05  FILLER                  PIC X(15) VALUE SPACES.          
           05  WS-COUNT3-RPT           PIC 9(06) VALUE ZEROES.          
           05  FILLER                  PIC X(15) VALUE SPACES.          
           05  WS-TOTAL-RPT            PIC 9(06) VALUE ZEROES.          
      *                                                                         
       01  WS-DTL-REC-EDITED.                                           
           05  FILLER                  PIC X(02) VALUE SPACES.          
           05  WS-METER-STATUS-E       PIC X(30) VALUE SPACES.          
           05  FILLER                  PIC X(06) VALUE SPACES.          
           05  WS-COUNT1-RPT-E         PIC Z(05)9.                      
           05  FILLER                  PIC X(15) VALUE SPACES.          
           05  WS-COUNT2-RPT-E         PIC Z(05)9.                      
           05  FILLER                  PIC X(15) VALUE SPACES.          
           05  WS-COUNT3-RPT-E         PIC Z(05)9.                      
           05  FILLER                  PIC X(15) VALUE SPACES.          
           05  WS-TOTAL-RPT-E          PIC Z(05)9.                      
      *                                                                         
       01  WS-END-DATA-LINE3.                                           
           05  FILLER                  PIC X(57) VALUE SPACES.          
           05  FILLER                  PIC X(21) VALUE                  
                     '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55) VALUE SPACES.          
      *                                                                         
       01  WS-NO-DATA.                                                  
           05  FILLER                  PIC X(55) VALUE SPACES.          
           05  FILLER                  PIC X(32) VALUE                  
                     '** NO DATA FOUND FOR THIS RUN **'.                
           05  FILLER                  PIC X(45) VALUE SPACES.          
      ******************************************************************        
      * MAIN CURSOR FOR RETRIEVING ROWS FOR METER STATS COMPANY WISE   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE MAIN_CSR CURSOR FOR                               
                 SELECT GM.METER_SIZE_ID                                
                       ,EQ.CODE_CRNT_LOC                                
                   FROM CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                  
                       ,CSS_GAS_METER GM WITH(READUNCOMMITTED)                  
                  WHERE EQ.CODE_UTIL_TYPE    = GM.CODE_UTIL_TYPE        
                    AND EQ.DEVICE_NO         = GM.METER_NO              
                    AND EQ.COMPANY_NO        = GM.COMPANY_NO            
                    AND EQ.COMPANY_NO        = :EQ-COMPANY-NO           
                    AND GM.COMPANY_NO        = :GM-COMPANY-NO           
                    AND EQ.CODE_UTIL_TYPE    = 'G'                      
                    AND EQ.CODE_CRNT_LOC     IN ('A', 'B' , 'J')        
                  ORDER BY EQ.CODE_CRNT_LOC                             
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MAIN_CSR CURSOR FOR                                       
MFA-TR*          SELECT GM.METER_SIZE_ID                                        
MFA-TR*                ,EQ.CODE_CRNT_LOC                                        
MFA-TR*            FROM CSS_EQUIPMENT EQ                                        
MFA-TR*                ,CSS_GAS_METER GM                                        
MFA-TR*           WHERE EQ.CODE_UTIL_TYPE    = GM.CODE_UTIL_TYPE                
MFA-TR*             AND EQ.DEVICE_NO         = GM.METER_NO                      
MFA-TR*             AND EQ.COMPANY_NO        = GM.COMPANY_NO                    
MFA-TR*             AND EQ.COMPANY_NO        = :EQ-COMPANY-NO                   
MFA-TR*             AND GM.COMPANY_NO        = :GM-COMPANY-NO                   
MFA-TR*             AND EQ.CODE_UTIL_TYPE    = 'G'                              
MFA-TR*             AND EQ.CODE_CRNT_LOC     IN ('A', 'B' , 'J')                
MFA-TR*           ORDER BY EQ.CODE_CRNT_LOC                                     
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      * CURSOR FOR RETRIEVING METER TEST STATISTICS                 *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                     
              DECLARE MTR_STAT CURSOR FOR                               
                 SELECT GM.METER_SIZE_ID                                
                       ,GT.CODE_REPAIR                                  
                       ,GT.CODE_TEST_TYPE                               
                       ,GT.IN_OPEN_RATE                                 
                       ,GT.IN_CHECK_RATE                                
                       ,GT.OUT_OPEN_RATE                                
                       ,GT.OUT_CHECK_RATE                               
                       ,GT.METER_NO                                     
                   FROM CSS_GAS_METER GM WITH(READUNCOMMITTED)                  
                       ,CSS_GAS_MTR_TEST GT WITH(READUNCOMMITTED)               
                  WHERE GM.CODE_UTIL_TYPE    = GT.CODE_UTIL_TYPE        
                    AND GM.CODE_UTIL_TYPE    = 'G'                      
                    AND GM.COMPANY_NO        = GT.COMPANY_NO            
                    AND GM.COMPANY_NO        = :GM-COMPANY-NO           
                    AND GM.METER_NO          = GT.METER_NO              
                    AND MONTH(GT.DATE_TEST)  = :WS-COMMON-MM            
                    AND YEAR(GT.DATE_TEST)   = :WS-COMMON-CCYY          
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MTR_STAT CURSOR FOR                                       
MFA-TR*          SELECT GM.METER_SIZE_ID                                        
MFA-TR*                ,GT.CODE_REPAIR                                          
MFA-TR*                ,GT.CODE_TEST_TYPE                                       
MFA-TR*                ,GT.IN_OPEN_RATE                                         
MFA-TR*                ,GT.IN_CHECK_RATE                                        
MFA-TR*                ,GT.OUT_OPEN_RATE                                        
MFA-TR*                ,GT.OUT_CHECK_RATE                                       
MFA-TR*                ,GT.METER_NO                                             
MFA-TR*            FROM CSS_GAS_METER GM                                        
MFA-TR*                ,CSS_GAS_MTR_TEST GT                                     
MFA-TR*           WHERE GM.CODE_UTIL_TYPE    = GT.CODE_UTIL_TYPE                
MFA-TR*             AND GM.CODE_UTIL_TYPE    = 'G'                              
MFA-TR*             AND GM.COMPANY_NO        = GT.COMPANY_NO                    
MFA-TR*             AND GM.COMPANY_NO        = :GM-COMPANY-NO                   
MFA-TR*             AND GM.METER_NO          = GT.METER_NO                      
MFA-TR*             AND MONTH(GT.DATE_TEST)  = :WS-COMMON-MM                    
MFA-TR*             AND YEAR(GT.DATE_TEST)   = :WS-COMMON-CCYY                  
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*         QUERYNO 7620                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-INPUT.                                                   
          05 PARM-LENGTH                PIC S9(04) COMP.                
          05 PARM-COMP-NO               PIC X(02).                      
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION USING PARM-INPUT.                             
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 1000-PROCESS-INPUT               THRU  1000-EXIT.    
           PERFORM 2000-PROCESS-MAIN-CSR            THRU  2000-EXIT.    
           PERFORM 2300-GET-MTR-STATS               THRU  2300-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                     TO WS-RT-HH.                  
           MOVE WS-MM                     TO WS-RT-MM.                  
           MOVE WS-SS                     TO WS-RT-SS.                  
           MOVE WS-RUN-TIME               TO P-RPT1-RUN-TIME.           
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE YYYYMMDD.                   
           MOVE WS-CY(3:2)                TO WS-RD-YY.                  
           MOVE WS-CM                     TO WS-RD-MM.                  
           MOVE WS-CD                     TO WS-RD-DD.                  
           MOVE WS-RUN-DATE               TO P-RPT1-RUN-DATE.           
                                                                        
           OPEN OUTPUT FCSPT33-FILE.                                    
                                                                        
           OPEN OUTPUT FCSPT331-FILE.                                   
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS-INPUT.                                          **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           IF PARM-LENGTH > 0                                           
              MOVE PARM-COMP-NO           TO WS-PARM-COMP-NO            
           ELSE                                                         
              MOVE WS-26                  TO WS-PARM-COMP-NO            
           END-IF.                                                      
           MOVE WS-PARM-COMP-NO           TO C7-COMPANY-NO              
                                             WS-COMPANY-NO              
                                             GM-COMPANY-NO              
                                             EQ-COMPANY-NO.             
           PERFORM 7000-GET-COMPANY-NAME            THRU 7000-EXIT.     
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE C7-COMPANY-NAME        TO WS-HOLD-TITLE-1            
           END-IF.                                                      
           PERFORM 1100-GET-COMMON-DATE             THRU 1100-EXIT.     
           MOVE WS-COMMON-CCYY            TO WS-RPT-CCYY.               
           MOVE WS-COMMON-MM              TO WS-RPT-MM.                 
           MOVE WS-REPORT-DATE            TO P-RPT1-DATE.               
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1100-GET-COMMON-DATE                                         **        
      ******************************************************************        
      *                                                                         
       1100-GET-COMMON-DATE.                                            
      *                                                                         
           MOVE SPACES                    TO WS-INPUT-DATA-BREAKDOWN.   
      **********CALLING THE COPYBOOK CPD00037 USING WS-PGRMNAME.                
           PERFORM 6251-GET-FJC01-DATE          THRU 6251-EXIT.         
           MOVE WS-INPUT-DATE(1:4)        TO WS-COMMON-CCYY.            
           MOVE WS-INPUT-DATE(6:2)        TO WS-COMMON-MM.              
      **********CALLING THE COPYBOOK CPD00037 USING COMMON.                     
           IF WS-OVERRIDE-DATE-SW = 'N'                                 
              MOVE SPACES                 TO WS-INPUT-DATA-BREAKDOWN    
              MOVE 'COMMON'               TO WS-PGRMNAME                
              PERFORM 6251-GET-FJC01-DATE       THRU 6251-EXIT          
              MOVE WS-INPUT-DATE(1:4)     TO WS-COMMON-CCYY             
              MOVE WS-INPUT-DATE(6:2)     TO WS-COMMON-MM               
           END-IF.                                                      
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-MAIN-CSR.                                       **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-MAIN-CSR.                                           
      *                                                                         
           PERFORM 7100-OPEN-MAIN-CSR               THRU 7100-EXIT.     
      *                                                                         
           PERFORM 7200-FETCH-MAIN-CSR              THRU 7200-EXIT.     
      *                                                                         
           MOVE WS-RPT1-HEAD1             TO P-RPT1-HEAD1.              
           MOVE WS-RPT1-TITLE-PGM         TO P-RPT1-TITLE-PGM.          
           MOVE WS-RPT1-METER-STATUS      TO P-METER-STATUS-RPT1.       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 2700-WRITE-HDR                THRU 2700-EXIT      
              MOVE WS-RPT1-HEADER-4          TO PRT33-RECORD            
              PERFORM 8100-WRITE-PRT33                 THRU 8100-EXIT   
              MOVE WS-NO-DATA             TO PRT33-RECORD               
              PERFORM 8100-WRITE-PRT33              THRU 8100-EXIT      
              MOVE WS-N                   TO WS-DATA-FOUND              
           END-IF.                                                      
      *                                                                         
           PERFORM 2200-SELECT-PARA                 THRU 2200-EXIT      
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
      *                                                                         
           IF WS-PRINT-REPORT1 = WS-Y                                   
              EVALUATE WS-PREV-MTR-STAT                                 
                 WHEN 'A'                                               
                    MOVE WS-INVENTORY     TO WS-METER-STATUS            
                 WHEN 'B'                                               
                    MOVE WS-TEST-SHOP     TO WS-METER-STATUS            
                 WHEN 'J'                                               
                    MOVE WS-PREMISE       TO WS-METER-STATUS            
              END-EVALUATE                                              
              MOVE WS-TOTAL               TO WS-TOTAL-RPT               
              COMPUTE WS-COMP-TOT =  WS-COMP-TOT + WS-TOTAL             
              PERFORM 2700-WRITE-HDR                THRU 2700-EXIT      
              PERFORM 2800-WRITE-DTL                THRU 2800-EXIT      
              PERFORM 2210-COMPANY-NO-TOTAL         THRU 2210-EXIT      
           END-IF.                                                      
           PERFORM 7300-CLOSE-MAIN-CSR              THRU 7300-EXIT.     
           IF WS-DATA-FOUND EQUAL WS-Y                                  
      **********PRINT THE COMPANY TOTAL                                         
              MOVE WS-COMPANY-NO-TOT      TO WS-METER-STATUS            
              PERFORM 2800-WRITE-DTL                THRU 2800-EXIT      
      **********PRINT THE TRAILER RECORD                                        
              PERFORM 2900-WRITE-TRLR               THRU 2900-EXIT      
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2200-SELECT-PARA.                                             *        
      ******************************************************************        
      *                                                                         
       2200-SELECT-PARA.                                                
      *                                                                         
           MOVE WS-Y                      TO WS-DATA-FOUND.             
      *                                                                         
           IF WS-PREV-MTR-STAT > SPACES                                 
              IF WS-PREV-MTR-STAT NOT EQUAL EQ-CODE-CRNT-LOC            
                 EVALUATE WS-PREV-MTR-STAT                              
                    WHEN 'A'                                            
                        MOVE WS-INVENTORY TO WS-METER-STATUS            
                    WHEN 'B'                                            
                        MOVE WS-TEST-SHOP TO WS-METER-STATUS            
                    WHEN 'J'                                            
                        MOVE WS-PREMISE   TO WS-METER-STATUS            
                 END-EVALUATE                                           
                 MOVE EQ-CODE-CRNT-LOC    TO WS-PREV-MTR-STAT           
                 MOVE WS-TOTAL            TO WS-TOTAL-RPT               
                 COMPUTE WS-COMP-TOT =  WS-COMP-TOT + WS-TOTAL          
                 PERFORM 2700-WRITE-HDR             THRU 2700-EXIT      
                 PERFORM 2800-WRITE-DTL             THRU 2800-EXIT      
                 PERFORM 2210-COMPANY-NO-TOTAL      THRU 2210-EXIT      
                 INITIALIZE WS-COUNTERS                                 
              END-IF                                                    
           ELSE                                                         
              MOVE EQ-CODE-CRNT-LOC       TO WS-PREV-MTR-STAT           
           END-IF.                                                      
      *                                                                         
           PERFORM 7400-GET-CAP-CSR                 THRU 7400-EXIT.     
      *                                                                         
           EVALUATE TRUE                                                
              WHEN WS-CCF-CAP-PER-HR < 251                              
                   COMPUTE WS-COUNT-1 = WS-COUNT-1 + 1                  
                   MOVE WS-COUNT-1        TO WS-COUNT1-RPT              
                   COMPUTE WS-TOTAL   = WS-TOTAL + 1                    
                   COMPUTE WS-COMP-TOT-COUNT1 =  WS-COMP-TOT-COUNT1 + 1 
              WHEN WS-CCF-CAP-PER-HR > 1500                             
                   COMPUTE WS-COUNT-3 = WS-COUNT-3 + 1                  
                   MOVE WS-COUNT-3        TO WS-COUNT3-RPT              
                   COMPUTE WS-TOTAL   = WS-TOTAL + 1                    
                   COMPUTE WS-COMP-TOT-COUNT3 =  WS-COMP-TOT-COUNT3 + 1 
              WHEN OTHER                                                
                   COMPUTE WS-COUNT-2 = WS-COUNT-2 + 1                  
                   MOVE WS-COUNT-2        TO WS-COUNT2-RPT              
                   COMPUTE WS-TOTAL   = WS-TOTAL + 1                    
                   COMPUTE WS-COMP-TOT-COUNT2 =  WS-COMP-TOT-COUNT2 + 1 
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 7200-FETCH-MAIN-CSR              THRU 7200-EXIT.     
           MOVE WS-Y                      TO WS-PRINT-REPORT1.          
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2210-COMPANY-NO-TOTAL                                         *        
      ******************************************************************        
      *                                                                         
       2210-COMPANY-NO-TOTAL.                                           
      *                                                                         
      ***WS-COMPANY-NO TOTAL                                                    
           MOVE WS-COMP-TOT-COUNT1        TO WS-COUNT1-RPT.             
           MOVE WS-COMP-TOT-COUNT2        TO WS-COUNT2-RPT.             
           MOVE WS-COMP-TOT-COUNT3        TO WS-COUNT3-RPT.             
           MOVE WS-COMP-TOT               TO WS-TOTAL-RPT.              
      *                                                                         
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2300-GET-MTR-STATS.                                           *        
      ******************************************************************        
      *                                                                         
       2300-GET-MTR-STATS.                                              
      *                                                                         
           MOVE WS-N                      TO WS-DATA-FOUND.             
           PERFORM 7500-OPEN-MTR-STAT               THRU 7500-EXIT.     
      *                                                                         
           PERFORM 7620-FETCH-MTR-STAT              THRU 7620-EXIT.     
      *                                                                         
           MOVE WS-RPT2-HEAD2             TO P-RPT1-HEAD1.              
           MOVE WS-RPT2-TITLE-PGM         TO P-RPT1-TITLE-PGM.          
           MOVE SPACES                    TO P-METER-STATUS-RPT1.       
           MOVE WS-RPT2-METER-STATUS      TO P-METER-STATUS-RPT1.       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 2710-WRITE-HDR                THRU 2710-EXIT      
              MOVE WS-RPT1-HEADER-4       TO PRT331-RECORD              
              PERFORM 8110-WRITE-PRT331             THRU 8110-EXIT      
              MOVE WS-NO-DATA             TO PRT331-RECORD              
              PERFORM 8210-WRITE-PRT331             THRU 8210-EXIT      
              MOVE WS-N                   TO WS-DATA-FOUND              
           END-IF.                                                      
      *                                                                         
           PERFORM 2400-PROCESS-MTR-STAT-CSR        THRU 2400-EXIT      
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
      *                                                                         
           IF WS-PRINT-REPORT2 = WS-Y                                   
              MOVE 'MORE THAN 2% SLOW'       TO WS-METER-STATUS         
              MOVE WS-COUNT1-SLOW            TO WS-COUNT1-RPT           
              MOVE WS-COUNT2-SLOW            TO WS-COUNT2-RPT           
              MOVE WS-COUNT3-SLOW            TO WS-COUNT3-RPT           
              COMPUTE WS-TOTAL-SLOW = WS-COUNT1-SLOW + WS-COUNT2-SLOW   
                                                     + WS-COUNT3-SLOW   
              MOVE WS-TOTAL-SLOW             TO WS-TOTAL-RPT            
              PERFORM 2710-WRITE-HDR                THRU 2710-EXIT      
              PERFORM 2810-WRITE-DTL                THRU 2810-EXIT      
      *                                                                         
              MOVE 'MORE THAN 2% FAST'       TO WS-METER-STATUS         
              MOVE WS-COUNT1-FAST            TO WS-COUNT1-RPT           
              MOVE WS-COUNT2-FAST            TO WS-COUNT2-RPT           
              MOVE WS-COUNT3-FAST            TO WS-COUNT3-RPT           
              COMPUTE WS-TOTAL-FAST = WS-COUNT1-FAST + WS-COUNT2-FAST   
                                                     + WS-COUNT3-FAST   
              MOVE WS-TOTAL-FAST             TO WS-TOTAL-RPT            
              PERFORM 2810-WRITE-DTL                THRU 2810-EXIT      
      *                                                                         
              MOVE 'WITHIN +2% OR -2%'       TO WS-METER-STATUS         
              MOVE WS-COUNT1-WITHIN          TO WS-COUNT1-RPT           
              MOVE WS-COUNT2-WITHIN          TO WS-COUNT2-RPT           
              MOVE WS-COUNT3-WITHIN          TO WS-COUNT3-RPT           
              COMPUTE WS-TOTAL-WITHIN = WS-COUNT1-WITHIN +              
                      WS-COUNT2-WITHIN + WS-COUNT3-WITHIN               
              MOVE WS-TOTAL-WITHIN           TO WS-TOTAL-RPT            
              PERFORM 2810-WRITE-DTL                THRU 2810-EXIT      
      *                                                                         
              MOVE 'DOES NOT REGISTER'       TO WS-METER-STATUS         
              MOVE WS-COUNT1-DR              TO WS-COUNT1-RPT           
              MOVE WS-COUNT2-DR              TO WS-COUNT2-RPT           
              MOVE WS-COUNT3-DR              TO WS-COUNT3-RPT           
              COMPUTE WS-TOTAL-DR = WS-COUNT1-DR + WS-COUNT2-DR         
                                                 + WS-COUNT3-DR         
              MOVE WS-TOTAL-DR               TO WS-TOTAL-RPT            
              PERFORM 2810-WRITE-DTL                THRU 2810-EXIT      
      *                                                                         
              MOVE 'DOES NOT PASS GAS'       TO WS-METER-STATUS         
              MOVE WS-COUNT1-DPG             TO WS-COUNT1-RPT           
              MOVE WS-COUNT2-DPG             TO WS-COUNT2-RPT           
              MOVE WS-COUNT3-DPG             TO WS-COUNT3-RPT           
              COMPUTE WS-TOTAL-DPG = WS-COUNT1-DPG + WS-COUNT2-DPG      
                                                   + WS-COUNT3-DPG      
              MOVE WS-TOTAL-DPG              TO WS-TOTAL-RPT            
              PERFORM 2810-WRITE-DTL                THRU 2810-EXIT      
      *                                                                         
              MOVE 'TOTAL FROM SERVICE'      TO WS-METER-STATUS         
              COMPUTE WS-COUNT1-RPT =  WS-COUNT1-SLOW + WS-COUNT1-FAST +
                      WS-COUNT1-WITHIN + WS-COUNT1-DR + WS-COUNT1-DPG   
              COMPUTE WS-COUNT2-RPT =  WS-COUNT2-SLOW + WS-COUNT2-FAST +
                      WS-COUNT2-WITHIN + WS-COUNT2-DR + WS-COUNT2-DPG   
              COMPUTE WS-COUNT3-RPT =  WS-COUNT3-SLOW + WS-COUNT3-FAST +
                      WS-COUNT3-WITHIN + WS-COUNT3-DR + WS-COUNT3-DPG   
              COMPUTE WS-TOTAL-RPT =   WS-TOTAL-SLOW  + WS-TOTAL-FAST  +
                      WS-TOTAL-WITHIN  + WS-TOTAL-DR  + WS-TOTAL-DPG    
              PERFORM 2810-WRITE-DTL                THRU 2810-EXIT      
      *                                                                         
              MOVE 'NEW METERS TESTED'       TO WS-METER-STATUS         
              MOVE WS-COUNT1-NEW             TO WS-COUNT1-RPT           
              MOVE WS-COUNT2-NEW             TO WS-COUNT2-RPT           
              MOVE WS-COUNT3-NEW             TO WS-COUNT3-RPT           
              COMPUTE WS-TOTAL-NEW = WS-COUNT1-NEW + WS-COUNT2-NEW      
                                                   + WS-COUNT3-NEW      
              MOVE WS-TOTAL-NEW              TO WS-TOTAL-RPT            
              PERFORM 2810-WRITE-DTL                THRU 2810-EXIT      
           END-IF.                                                      
           PERFORM 7700-CLOSE-MTR-STAT              THRU 7700-EXIT.     
      *****PRINT TRAILER RECORD                                                 
           IF WS-DATA-FOUND EQUAL WS-Y                                  
              PERFORM 2910-WRITE-TRLR               THRU 2910-EXIT      
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2400-PROCESS-MTR-STAT-CSR.                                    *        
      ******************************************************************        
      *                                                                         
       2400-PROCESS-MTR-STAT-CSR.                                       
      *                                                                         
           MOVE ZEROES                    TO WS-COUNT-DR                
                                             WS-COUNT-DPG               
                                             WS-COUNT-NEW               
                                             WS-COUNT-SLOW              
                                             WS-COUNT-FAST              
                                             WS-COUNT-WITHIN.           
           MOVE WS-Y                      TO WS-DATA-FOUND.             
           PERFORM 7400-GET-CAP-CSR                 THRU 7400-EXIT.     
           EVALUATE TRUE                                                
              WHEN WS-CCF-CAP-PER-HR < 251                              
                   PERFORM 2410-GT-CODE-REPAIR      THRU 2410-EXIT      
                   PERFORM 2410A-MOVE-COUNT1        THRU 2410A-EXIT     
              WHEN WS-CCF-CAP-PER-HR > 1500                             
                   PERFORM 2410-GT-CODE-REPAIR      THRU 2410-EXIT      
                   PERFORM 2410C-MOVE-COUNT3        THRU 2410C-EXIT     
              WHEN OTHER                                                
                   PERFORM 2410-GT-CODE-REPAIR      THRU 2410-EXIT      
                   PERFORM 2410B-MOVE-COUNT2        THRU 2410B-EXIT     
           END-EVALUATE.                                                
           MOVE WS-Y                      TO WS-PRINT-REPORT2.          
           PERFORM 7620-FETCH-MTR-STAT              THRU 7620-EXIT.     
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2410-GT-CODE-REPAIR.                                           *        
      ******************************************************************        
      *                                                                         
       2410-GT-CODE-REPAIR.                                             
      *                                                                         
           IF GT-CODE-REPAIR = 'O' OR                                   
              GT-CODE-REPAIR = '6' OR                                   
              GT-CODE-REPAIR = 'P' OR                                   
              GT-CODE-REPAIR = '8'                                      
              EVALUATE GT-CODE-REPAIR                                   
                 WHEN 'O'                                               
                 WHEN '6'                                               
                    MOVE 1                TO WS-COUNT-DR                
                 WHEN 'P'                                               
                 WHEN '8'                                               
                    MOVE 1                TO WS-COUNT-DPG               
              END-EVALUATE                                              
           ELSE                                                         
              IF GT-CODE-TEST-TYPE = 'A' OR GT-CODE-TEST-TYPE = 'E'     
                 COMPUTE WS-ACCURACY-PCT = (GT-OUT-OPEN-RATE +          
                                            GT-OUT-CHECK-RATE) / 2      
                 MOVE 1                   TO WS-COUNT-NEW               
              ELSE                                                      
                 COMPUTE WS-ACCURACY-PCT = (GT-IN-OPEN-RATE +           
                                            GT-IN-CHECK-RATE) / 2       
                 IF WS-ACCURACY-PCT NOT EQUAL 0                         
                 IF WS-ACCURACY-PCT < 98                                
                    MOVE 1                TO WS-COUNT-SLOW              
                 ELSE                                                   
                   IF WS-ACCURACY-PCT > 102                             
                      MOVE 1              TO WS-COUNT-FAST              
                   ELSE                                                 
                     IF WS-ACCURACY-PCT > 98 AND                        
                        WS-ACCURACY-PCT < 102                           
                        MOVE 1            TO WS-COUNT-WITHIN            
                     END-IF                                             
                   END-IF                                               
                 END-IF                                                 
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2410A-MOVE-COUNT1                                              *        
      ******************************************************************        
      *                                                                         
       2410A-MOVE-COUNT1.                                               
      *                                                                         
           ADD  WS-COUNT-DR               TO WS-COUNT1-DR.              
           ADD  WS-COUNT-DPG              TO WS-COUNT1-DPG.             
           ADD  WS-COUNT-NEW              TO WS-COUNT1-NEW.             
           ADD  WS-COUNT-SLOW             TO WS-COUNT1-SLOW.            
           ADD  WS-COUNT-FAST             TO WS-COUNT1-FAST.            
           ADD  WS-COUNT-WITHIN           TO WS-COUNT1-WITHIN.          
      *                                                                         
       2410A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2410B-MOVE-COUNT2                                              *        
      ******************************************************************        
      *                                                                         
       2410B-MOVE-COUNT2.                                               
      *                                                                         
           ADD  WS-COUNT-DR               TO WS-COUNT2-DR.              
           ADD  WS-COUNT-DPG              TO WS-COUNT2-DPG.             
           ADD  WS-COUNT-NEW              TO WS-COUNT2-NEW.             
           ADD  WS-COUNT-SLOW             TO WS-COUNT2-SLOW.            
           ADD  WS-COUNT-FAST             TO WS-COUNT2-FAST.            
           ADD  WS-COUNT-WITHIN           TO WS-COUNT2-WITHIN.          
      *                                                                         
       2410B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2410C-MOVE-COUNT3                                              *        
      ******************************************************************        
      *                                                                         
       2410C-MOVE-COUNT3.                                               
      *                                                                         
           ADD  WS-COUNT-DR               TO WS-COUNT3-DR.              
           ADD  WS-COUNT-DPG              TO WS-COUNT3-DPG.             
           ADD  WS-COUNT-NEW              TO WS-COUNT3-NEW.             
           ADD  WS-COUNT-SLOW             TO WS-COUNT3-SLOW.            
           ADD  WS-COUNT-FAST             TO WS-COUNT3-FAST.            
           ADD  WS-COUNT-WITHIN           TO WS-COUNT3-WITHIN.          
      *                                                                         
       2410C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2700-WRITE-HDR.                                                *        
      ******************************************************************        
      *                                                                         
       2700-WRITE-HDR.                                                  
      *                                                                         
           IF WS-HDR-EXISTS = WS-Y                                      
              ADD +1                         TO WS-PAGE-NUM1            
              MOVE WS-PAGE-NUM1              TO P-RPT1-TITLE-PGNM       
              MOVE WS-RPT1-HEADER-1          TO PRT33-RECORD            
              PERFORM 8000-WRITE-PRT33                 THRU 8000-EXIT   
              MOVE WS-RPT1-HEADER-2          TO PRT33-RECORD            
              PERFORM 8300-WRITE-PRT33                 THRU 8300-EXIT   
              MOVE WS-RPT1-HEADER-3          TO PRT33-RECORD            
              PERFORM 8300-WRITE-PRT33                 THRU 8300-EXIT   
              MOVE WS-RPT1-HEADER-4          TO PRT33-RECORD            
              PERFORM 8100-WRITE-PRT33                 THRU 8100-EXIT   
              MOVE WS-RPT1-HEADER-5          TO PRT33-RECORD            
              PERFORM 8300-WRITE-PRT33                 THRU 8300-EXIT   
              MOVE WS-RPT1-HEADER-6          TO PRT33-RECORD            
              PERFORM 8300-WRITE-PRT33                 THRU 8300-EXIT   
              MOVE WS-N                      TO WS-HDR-EXISTS           
           END-IF.                                                      
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2710-WRITE-HDR.                                                *        
      ******************************************************************        
      *                                                                         
       2710-WRITE-HDR.                                                  
      *                                                                         
           MOVE ZEROES                    TO WS-PAGE-NUM1.              
           ADD +1                         TO WS-PAGE-NUM1.              
           MOVE WS-PAGE-NUM1              TO P-RPT1-TITLE-PGNM.         
           MOVE WS-RPT1-HEADER-1          TO PRT331-RECORD.             
           PERFORM 8010-WRITE-PRT331                THRU 8010-EXIT.     
           MOVE WS-RPT1-HEADER-2          TO PRT331-RECORD.             
           PERFORM 8310-WRITE-PRT331                THRU 8310-EXIT      
           MOVE WS-RPT1-HEADER-3          TO PRT331-RECORD.             
           PERFORM 8310-WRITE-PRT331                THRU 8310-EXIT.     
           MOVE WS-RPT1-HEADER-4          TO PRT331-RECORD.             
           PERFORM 8110-WRITE-PRT331                THRU 8110-EXIT.     
           MOVE WS-RPT1-HEADER-5          TO PRT331-RECORD.             
           PERFORM 8310-WRITE-PRT331                THRU 8310-EXIT.     
           MOVE WS-RPT1-HEADER-6          TO PRT331-RECORD.             
           PERFORM 8310-WRITE-PRT331                THRU 8310-EXIT.     
      *                                                                         
       2710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2800-WRITE-DTL.                                              **        
      ******************************************************************        
      *                                                                         
       2800-WRITE-DTL.                                                  
      *                                                                         
           MOVE WS-METER-STATUS           TO WS-METER-STATUS-E.         
           MOVE WS-COUNT1-RPT             TO WS-COUNT1-RPT-E.           
           MOVE WS-COUNT2-RPT             TO WS-COUNT2-RPT-E.           
           MOVE WS-COUNT3-RPT             TO WS-COUNT3-RPT-E.           
           MOVE WS-TOTAL-RPT              TO WS-TOTAL-RPT-E.            
           MOVE WS-DTL-REC-EDITED         TO PRT33-RECORD.              
           PERFORM 8200-WRITE-PRT33                 THRU 8200-EXIT.     
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2810-WRITE-DTL.                                              **        
      ******************************************************************        
      *                                                                         
       2810-WRITE-DTL.                                                  
      *                                                                         
           MOVE WS-METER-STATUS           TO WS-METER-STATUS-E.         
           MOVE WS-COUNT1-RPT             TO WS-COUNT1-RPT-E.           
           MOVE WS-COUNT2-RPT             TO WS-COUNT2-RPT-E.           
           MOVE WS-COUNT3-RPT             TO WS-COUNT3-RPT-E.           
           MOVE WS-TOTAL-RPT              TO WS-TOTAL-RPT-E.            
           MOVE WS-DTL-REC-EDITED         TO PRT331-RECORD.             
           PERFORM 8210-WRITE-PRT331                THRU 8210-EXIT.     
      *                                                                         
       2810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2900-WRITE-TRLR.                                             **        
      ******************************************************************        
      *                                                                         
       2900-WRITE-TRLR.                                                 
      *                                                                         
           MOVE WS-END-DATA-LINE3         TO PRT33-RECORD.              
           PERFORM 8100-WRITE-PRT33                 THRU 8100-EXIT.     
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2910-WRITE-TRLR.                                             **        
      ******************************************************************        
      *                                                                         
       2910-WRITE-TRLR.                                                 
      *                                                                         
           MOVE WS-END-DATA-LINE3         TO PRT331-RECORD.             
           PERFORM 8210-WRITE-PRT331                THRU 8210-EXIT.     
      *                                                                         
       2910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 6251-GET-FJC01-DATE.                                         *          
      ****************************************************************          
       COPY CPD00037.                                                           
                                                                        
      ******************************************************************        
      ** 7000-GET-COMPANY-NAME                                        **        
      ******************************************************************        
      *                                                                         
       7000-GET-COMPANY-NAME.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  C7.COMPANY_NAME                                   
                INTO :C7-COMPANY-NAME                                   
                FROM CSS_COMPANY C7 WITH(READUNCOMMITTED)                       
               WHERE C7.COMPANY_NO = :C7-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  C7.COMPANY_NAME                                           
MFA-TR*         INTO :C7-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY C7                                             
MFA-TR*        WHERE C7.COMPANY_NO = :C7-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP014 ABORT *****'                   
              DISPLAY '**  7000-GET-COMPANY-NAME  **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  C7-COMPANY-NO = ' C7-COMPANY-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-OPEN-MAIN-CSR                                             *        
      ******************************************************************        
      *                                                                         
       7100-OPEN-MAIN-CSR.                                              
      *                                                                         
           EXEC SQL                                                     
              OPEN MAIN_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP014 ABORT ******'                  
              DISPLAY '**  7100-OPEN-MAIN-CSR      **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-FETCH-MAIN-CSR                                            *        
      ******************************************************************        
      *                                                                         
       7200-FETCH-MAIN-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              FETCH MAIN_CSR                                            
               INTO :GM-METER-SIZE-ID                                   
                   ,:EQ-CODE-CRNT-LOC                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP014 ABORT *****'                   
              DISPLAY '**  7200-FETCH-MAIN-CSR    **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  WS-PARM-COMP-NO = ' WS-PARM-COMP-NO          
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-CLOSE-MAIN-CSR                                            *        
      ******************************************************************        
      *                                                                         
       7300-CLOSE-MAIN-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE MAIN_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP014 ABORT *****'                   
              DISPLAY '**  7300-CLOSE-MAIN-CSR    **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7400-GET-CAP-CSR.                                            **        
      ******************************************************************        
      *                                                                         
       7400-GET-CAP-CSR.                                                
      *                                                                         
           EXEC SQL                                                     
              SELECT CCF_CAP_PER_HR                                     
                INTO :WS-CCF-CAP-PER-HR                                 
                FROM CSS_GAS_METER_SIZE GM WITH(READUNCOMMITTED)                
               WHERE COMPANY_NO    = :WS-COMPANY-NO                     
                 AND METER_SIZE_ID = :GM-METER-SIZE-ID                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CCF_CAP_PER_HR                                             
MFA-TR*         INTO :WS-CCF-CAP-PER-HR                                         
MFA-TR*         FROM CSS_GAS_METER_SIZE GM                                      
MFA-TR*        WHERE COMPANY_NO    = :WS-COMPANY-NO                             
MFA-TR*          AND METER_SIZE_ID = :GM-METER-SIZE-ID                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP014 ABORT *****'                   
              DISPLAY '**  7400-GET-CAP-CSR       **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  WS-COMPANY-NO = ' WS-COMPANY-NO              
              DISPLAY '**  GM-METER-SIZE-ID = ' GM-METER-SIZE-ID        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7500-OPEN-MTR-STAT.                                            *        
      ******************************************************************        
      *                                                                         
       7500-OPEN-MTR-STAT.                                              
      *                                                                         
           EXEC SQL                                                     
              OPEN MTR_STAT                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP014 ABORT ******'                  
              DISPLAY '**  7500-OPEN-MTR-STAT      **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * *                                                                       
      * 7600-START-FCSJC01                                           *          
      ****************************************************************          
                                                                        
            EXEC SQL                                                            
               INCLUDE CPD00038                                                 
            END-EXEC.                                                           
                                                                        
      *                                                                         
      ******************************************************************        
      * 7620-FETCH-MTR-STAT.                                           *        
      ******************************************************************        
      *                                                                         
       7620-FETCH-MTR-STAT.                                             
      *                                                                         
           EXEC SQL                                                     
              FETCH MTR_STAT                                            
               INTO :GM-METER-SIZE-ID                                   
                   ,:GT-CODE-REPAIR                                     
                   ,:GT-CODE-TEST-TYPE                                  
                   ,:GT-IN-OPEN-RATE                                    
                   ,:GT-IN-CHECK-RATE                                   
                   ,:GT-OUT-OPEN-RATE                                   
                   ,:GT-OUT-CHECK-RATE                                  
                   ,:GT-METER-NO                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP014 ABORT *****'                   
              DISPLAY '**  7620-FETCH-MTR-STAT    **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  WS-PARM-COMP-NO = ' WS-PARM-COMP-NO          
              DISPLAY '**  WS-COMMON-CCYY = ' WS-COMMON-CCYY            
              DISPLAY '**  WS-COMMON-MM = ' WS-COMMON-MM                
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7700-CLOSE-MTR-STAT                                            *        
      ******************************************************************        
      *                                                                         
       7700-CLOSE-MTR-STAT.                                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE MTR_STAT                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP014 ABORT *****'                   
              DISPLAY '**  7700-CLOSE-MTR-STAT    **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000-WRITE-PRT33                                             **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-PRT33.                                                
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8010-WRITE-PRT331                                            **        
      ******************************************************************        
      *                                                                         
       8010-WRITE-PRT331.                                               
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING PAGE.                    
      *                                                                         
       8010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100-WRITE-PRT33.                                            **        
      ******************************************************************        
      *                                                                         
       8100-WRITE-PRT33.                                                
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING 3 LINES.                  
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8110-WRITE-PRT331                                            **        
      ******************************************************************        
      *                                                                         
       8110-WRITE-PRT331.                                               
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING 3 LINES.                 
      *                                                                         
       8110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8200-WRITE-PRT33                                             **        
      ******************************************************************        
      *                                                                         
       8200-WRITE-PRT33.                                                
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING 2 LINES.                  
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8210-WRITE-PRT331                                            **        
      ******************************************************************        
      *                                                                         
       8210-WRITE-PRT331.                                               
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING 2 LINES.                 
      *                                                                         
       8210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8300-WRITE-PRT33                                             **        
      ******************************************************************        
      *                                                                         
       8300-WRITE-PRT33.                                                
      *                                                                         
           WRITE PRT33-RECORD.                                          
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8310-WRITE-PRT331                                            **        
      ******************************************************************        
      *                                                                         
       8310-WRITE-PRT331.                                               
      *                                                                         
           WRITE PRT331-RECORD.                                         
      *                                                                         
       8310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 9000-CLOSE-FILES.                                            *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
                                                                        
           CLOSE FCSPT331-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
