       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP013.                                      
       AUTHOR.       VISHAL VELUSAMY.                                   
COB303 DATE-WRITTEN.     JUL 29, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      ******************************************************************        
      ***       DISPLAY THE METERS IN THE TEST SHOP FOR              ***        
      ***                  MORE THAN 270 DAYS.                       ***        
      *----------------------------------------------------------------*        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
      ***  DATE          INITIALS    COMMENTS                        ***        
      ***  -----------   --------    --------------------------------***        
      ***  07/29/2015    VV7M728     EZY TO COBOL CONVERSION         ***        
      ***------------------------------------------------------------***        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSPT331.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
       COPY CFDPT331.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP013'.
MSQ017     COPY MFASQLM.
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_EQUIPMENT                                            *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_GAS_METER                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGASMTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_MTR_STORGE_FAC                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRFAC                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_GAS_METER_SIZE                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGASMSZ                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_MOVEMENT_HIST                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMVHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_MODEL_SQL                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_COMPANY                                                 *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCOMPNY                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_JOB_PARM                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'                *         
      *****************************************************************         
      *                                                                         
           COPY FIOJC01.                                                        
      *****************************************************************         
      * ABEND SWITCH COPYBOOK                                         *         
      *****************************************************************         
      *                                                                         
           COPY CWS00038.                                                       
      *                                                                         
      *****************************************************************         
      *                                                                         
      ******************************************************************        
      * COPYBOOKS                                                               
      ******************************************************************        
      *                                                                         
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS09900.                                                           
                                                                        
       COPY CWS00010.                                                           
      *                                                             *           
      ******************************************************************        
       01 WS-LITERALS.                                                  
           05 WS-PROGRAM-NAME           PIC X(08) VALUE 'PCSRP013'.     
      *                                                                         
       01 WS-RP013-OUT-REC.                                             
           05 FILLER                    PIC X(14) VALUE SPACES.         
           05 OUT-MTR-NO                PIC X(09) VALUE SPACES.         
           05 FILLER                    PIC X(11) VALUE SPACES.         
           05 OUT-SERIAL-NO             PIC X(11) VALUE SPACES.         
           05 FILLER                    PIC X(17) VALUE SPACES.         
           05 OUT-MTR-TYPE              PIC X(08) VALUE SPACES.         
           05 FILLER                    PIC X(10) VALUE SPACES.         
           05 OUT-MTR-TYPE-DESC         PIC X(25) VALUE SPACES.         
           05 FILLER                    PIC X(04) VALUE SPACES.         
           05 OUT-LAST-TEST-DATE        PIC X(10) VALUE SPACES.         
           05 FILLER                    PIC X(14) VALUE SPACES.         
                                                                        
       01 WS-RP013-HDR-REC-LN1.                                         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN1-NAME              PIC X(08) VALUE 'PNC01301'.     
           05 FILLER                    PIC X(48) VALUE SPACES.         
           05 HDR-LN1-COMPANY-NAME      PIC X(26) VALUE 'PSNC ENERGY'.  
           05 FILLER                    PIC X(38) VALUE SPACES.         
           05 HDR-LN1-PAGE              PIC X(05) VALUE 'PAGE '.        
           05 HDR-LN1-PAGE-NO           PIC Z(06) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE SPACES.         
                                                                        
       01 WS-RP013-HDR-REC-LN2.                                         
           05 FILLER                    PIC X(49) VALUE SPACES.         
           05 HDR-LN2-DETAILS           PIC X(21)                       
                        VALUE '270 DAY MTR INVENTORY'.                  
           05 FILLER                    PIC X(44) VALUE SPACES.         
           05 HDR-LN2-RUN-DATE          PIC X(10) VALUE 'RUN-DATE: '.   
           05 HDR-LN2-SYS-DATE          PIC X(08) VALUE SPACES.         
                                                                        
       01 WS-RP013-HDR-REC-LN3.                                         
           05 FILLER                    PIC X(114) VALUE SPACES.        
           05 HDR-LN3-RUN-DATE          PIC X(10) VALUE 'RUN-TIME: '.   
           05 HDR-LN3-SYS-TIME          PIC X(08) VALUE SPACES.         
                                                                        
       01 WS-RP013-HDR-REC-LN5.                                         
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR-LN5-DETAILS           PIC X(27)                       
                        VALUE  'METER STORAGE FACILITY :   '.           
           05 HDR-LN5-MTR-STR-FACI      PIC X(20) VALUE SPACES.         
           05 FILLER                    PIC X(82) VALUE SPACES.         
                                                                        
       01 WS-RP013-HDR-REC-LN6.                                         
           05 FILLER                    PIC X(133) VALUE SPACES.        
                                                                        
       01 WS-RP013-HDR-REC-LN7.                                         
           05 FILLER                    PIC X(13) VALUE SPACES.         
           05 HDR-LN5-DTL1              PIC X(12)                       
                                VALUE 'METER NUMBER'.                   
           05 FILLER                    PIC X(09) VALUE SPACES.         
           05 HDR-LN5-DTL2              PIC X(13)                       
                                VALUE 'SERIAL NUMBER'.                  
           05 FILLER                    PIC X(14) VALUE SPACES.         
           05 HDR-LN5-DTL3              PIC X(10)                       
                                VALUE 'METER TYPE'.                     
           05 FILLER                    PIC X(09) VALUE SPACES.         
           05 HDR-LN5-DTL4              PIC X(15)                       
                                VALUE 'METER TYPE DESC'.                
           05 FILLER                    PIC X(13) VALUE SPACES.         
           05 HDR-LN5-DTL5              PIC X(14)                       
                                VALUE 'LAST TEST DATE'.                 
           05 FILLER                    PIC X(11) VALUE SPACES.         
                                                                        
       01 WS-RP013-FTR-REC-LN1.                                         
           05 FILLER                    PIC X(133) VALUE SPACES.        
                                                                        
       01 WS-RP013-FTR-REC-LN2.                                         
           05 FILLER                    PIC X(02)  VALUE SPACES.        
           05 FTR-LN2-DETAILS           PIC X(16)                       
                                      VALUE 'TOTAL METERS IN '.         
           05 FTR-LN2-MTR-STR-FACI      PIC X(20)  VALUE SPACES.        
           05 FILLER                    PIC X(01)  VALUE ':'.           
           05 FTR-LN2-TOTAL-MTR         PIC Z(06)  VALUE ZEROS.         
           05 FILLER                    PIC X(88)  VALUE SPACES.        
                                                                        
       01 WS-RP013-FTR-REC-LNX.                                         
           05 FILLER                    PIC X(133) VALUE SPACES.        
                                                                        
       01 WS-RP013-FTR-REC-LN3.                                         
           05 FILLER                    PIC X(02)  VALUE SPACES.        
           05 FTR-LN3-DETAILS           PIC X(25)                       
                    VALUE 'TOTAL METERS IN REPORT : '.                  
           05 FTR-LN3-TOTAL-MTR         PIC Z(05)  VALUE ZEROS.         
           05 FILLER                    PIC X(102) VALUE SPACES.        
                                                                        
       01 WS-RP013-FTR-REC-LN4.                                         
           05 FILLER                    PIC X(30)  VALUE SPACES.        
           05 FTR-LN4-DETAILS           PIC X(21)                       
                    VALUE '*** END OF REPORT ***'.                      
           05 FILLER                    PIC X(82)  VALUE SPACES.        
                                                                        
       01 WS-RP013-FTR-NODATA.                                          
           05 FILLER                    PIC X(45)  VALUE SPACES.        
           05 FTR-LN4-DETAILS           PIC X(35)                       
                    VALUE '  ** NO DATA FOUND FOR THIS RUN**  '.        
           05 FILLER                    PIC X(53)  VALUE SPACES.        
      *                                                                         
       01 WS-FLAGS.                                                     
           05 WS-PARM-FOUND             PIC X(01) VALUE 'N'.            
           05 WS-ALL-ROWS-PROCESD       PIC X(01) VALUE 'N'.            
           05 WS-DATA-FOUND             PIC X(01) VALUE 'N'.            
                                                                        
       01  WS-SWITCH.                                                   
           05  WS-FCA331-STATUS         PIC X(02).                      
               88 FCA331-SUCCESSFUL               VALUE '00'.           
                                                                        
       01  WS-CHANGE-SWITCH.                                            
           05  WS-VALUE-DIFFER          PIC X(01) VALUE 'N'.            
           05  WS-FIRST-VALUE           PIC X(01) VALUE 'Y'.            
           05  WS-BEGIN-VALUE           PIC X(01) VALUE 'N'.            
                                                                        
       01  WS-COUNTERS.                                                 
           05  WS-LOCAL-COUNT           PIC 9(04) VALUE ZEROS.          
           05  WS-TOTAL-COUNT           PIC 9(06) VALUE ZEROS.          
           05  WS-PAGE-NO               PIC 9(06) VALUE ZEROS.          
      *                                                                         
       01 WS-MISC.                                                      
           05  WS-PARM26                PIC X(02) VALUE '26'.           
           05  WS-COMPANY-NAME          PIC X(26) VALUE SPACES.         
           05  WS-PARM-DATA             PIC X(80) VALUE SPACES.         
           05  WS-CMND-CD               PIC X(04) VALUE 'PARM'.         
           05  WS-PARM-COMP-NO          PIC X(02) VALUE SPACES.         
           05  WS-COMPANY-NO            PIC X(02) VALUE SPACES.         
           05  WS-NO-OF-DAYS-PARM       PIC X(15) VALUE SPACES.         
           05  WS-PARM-DAYS             PIC X(04) VALUE SPACES.         
           05  WS-DAYS                  PIC X(04) VALUE SPACES.         
           05  WS-PGRMNAME              PIC X(08) VALUE 'PCSRP013'.     
           05  WS-COMM-DATE-PARM        PIC X(09) VALUE SPACES.         
           05  WS-COMM-DATE             PIC X(10) VALUE SPACES.         
           05  WS-MTR-STG-DESC          PIC X(35) VALUE SPACES.         
           05  WS-TEMP-MTR              PIC X(35) VALUE SPACES.         
           05  WS-CUTOFF-DT             PIC X(10) VALUE SPACES.         
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                    PIC 9(02).                      
           05  WS-MM                    PIC 9(02).                      
           05  WS-SS                    PIC 9(02).                      
           05  WS-TT                    PIC 9(02).                      
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-SS                 PIC X(02).                      
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                    PIC 9(04).                      
           05  WS-CM                    PIC 9(02).                      
           05  WS-CD                    PIC 9(02).                      
      *                                                                         
       01  WS-REPORT-DATE.                                              
           05  WS-RPT-MM                PIC 9(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RPT-CCYY              PIC 9(04).                      
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-DD                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-YY                 PIC X(02).                      
                                                                        
       01  WS-COMMON-DATE.                                              
           05 WS-COMMON-CCYY            PIC X(04) VALUE SPACES.         
           05 FILLER                    PIC X(01).                      
           05 WS-COMMON-MM              PIC X(02) VALUE SPACES.         
      *                                                                         
      ***************************************************************           
      *CURSOR FOR RETRIEVING ROWS FOR METERS IN THE INVENTORY       *           
      ***************************************************************           
      *                                                                         
            EXEC SQL                                                    
             DECLARE MAIN_CSR   CURSOR FOR                              
                SELECT EQ.DEVICE_NO                                     
                      ,GM.DATE_LAST_TESTED                              
                      ,EQ.SERIAL_NO                                     
                      ,EQ.LOCAL_OFFICE                                  
                      ,EQ.CODE_CRNT_LOC                                 
                      ,EQ.DATE_LAST_MOVE                                
                      ,GM.METER_SIZE_ID                                 
                  FROM CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                   
                      ,CSS_GAS_METER GM WITH(READUNCOMMITTED)                   
                  WHERE EQ.CODE_UTIL_TYPE    = GM.CODE_UTIL_TYPE        
                    AND EQ.DEVICE_NO         = GM.METER_NO              
                    AND EQ.COMPANY_NO        = :WS-PARM-COMP-NO         
                    AND EQ.COMPANY_NO        = GM.COMPANY_NO            
                    AND EQ.CODE_CRNT_LOC     IN ('A', 'B')              
                    AND GM.DATE_LAST_TESTED <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CUTOFF-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CUTOFF-DT
              ) <> 0) OR (LEN(:WS-CUTOFF-DT) <> 10), CIS.CHAR2DATE(
                                                          :WS-CUTOFF-DT
              ), CONVERT(DATE, :WS-CUTOFF-DT) )            
                    ORDER BY EQ.LOCAL_OFFICE ASC                        
                            ,EQ.DEVICE_NO    ASC                        
                    FOR READ ONLY                               
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*      DECLARE MAIN_CSR   CURSOR FOR                                      
MFA-TR*         SELECT EQ.DEVICE_NO                                             
MFA-TR*               ,GM.DATE_LAST_TESTED                                      
MFA-TR*               ,EQ.SERIAL_NO                                             
MFA-TR*               ,EQ.LOCAL_OFFICE                                          
MFA-TR*               ,EQ.CODE_CRNT_LOC                                         
MFA-TR*               ,EQ.DATE_LAST_MOVE                                        
MFA-TR*               ,GM.METER_SIZE_ID                                         
MFA-TR*           FROM CSS_EQUIPMENT EQ                                         
MFA-TR*               ,CSS_GAS_METER GM                                         
MFA-TR*           WHERE EQ.CODE_UTIL_TYPE    = GM.CODE_UTIL_TYPE                
MFA-TR*             AND EQ.DEVICE_NO         = GM.METER_NO                      
MFA-TR*             AND EQ.COMPANY_NO        = :WS-PARM-COMP-NO                 
MFA-TR*             AND EQ.COMPANY_NO        = GM.COMPANY_NO                    
MFA-TR*             AND EQ.CODE_CRNT_LOC     IN ('A', 'B')                      
MFA-TR*             AND GM.DATE_LAST_TESTED <= :WS-CUTOFF-DT                    
MFA-TR*             ORDER BY EQ.LOCAL_OFFICE ASC                                
MFA-TR*                     ,EQ.DEVICE_NO    ASC                                
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*     END-EXEC.                                                           
      *                                                                         
      ************************************************************              
      *  CURSOR TO SELECT METER LOCATION FROM MOVEMENT HIST    ***              
      ************************************************************              
            EXEC SQL                                                    
             DECLARE MOVE_HIST   CURSOR FOR                             
                SELECT CODE_CRNT_LOC                                    
                  FROM CSS_MOVEMENT_HIST WITH(READUNCOMMITTED)                  
                  WHERE CODE_UTIL_TYPE = 'G'                            
                    AND DEVICE_NO      = :EQ-DEVICE-NO                  
                    AND DATE_MOVE     <= IIF(TRY_CONVERT(DATE, 
                                                     :EQ-DATE-LAST-MOVE
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-MOVE
              ) <> 0) OR (LEN(:EQ-DATE-LAST-MOVE
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-MOVE
              ), CONVERT(DATE, :EQ-DATE-LAST-MOVE) )             
                    AND COMPANY_NO     = :WS-PARM-COMP-NO               
                    ORDER BY MOVE_NO DESC                               
                    FOR READ ONLY                               
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*      DECLARE MOVE_HIST   CURSOR FOR                                     
MFA-TR*         SELECT CODE_CRNT_LOC                                            
MFA-TR*           FROM CSS_MOVEMENT_HIST                                        
MFA-TR*           WHERE CODE_UTIL_TYPE = 'G'                                    
MFA-TR*             AND DEVICE_NO      = :EQ-DEVICE-NO                          
MFA-TR*             AND DATE_MOVE     <= :EQ-DATE-LAST-MOVE                     
MFA-TR*             AND COMPANY_NO     = :WS-PARM-COMP-NO                       
MFA-TR*             ORDER BY MOVE_NO DESC                                       
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*     END-EXEC.                                                           
      ***************************************************************           
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-INPUT.                                                   
          05 PARM-LENGTH                PIC S9(04) COMP.                
          05 PARM-COMP-NO               PIC X(02).                      
      *                                                                         
      ***************************************************************           
       PROCEDURE DIVISION USING PARM-INPUT.                             
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 1000-GET-PARM-DATA               THRU  1000-EXIT.    
           PERFORM 2000-PROCESS-MAIN-CSR            THRU  2000-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100-INITIALIZE.                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                     TO WS-RT-HH.                  
           MOVE WS-MM                     TO WS-RT-MM.                  
           MOVE WS-SS                     TO WS-RT-SS.                  
           MOVE WS-RUN-TIME               TO HDR-LN3-SYS-TIME.          
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE YYYYMMDD.                   
           MOVE WS-CY(3:2)                TO WS-RD-YY.                  
           MOVE WS-CM                     TO WS-RD-MM.                  
           MOVE WS-CD                     TO WS-RD-DD.                  
           MOVE WS-RUN-DATE               TO HDR-LN2-SYS-DATE.          
      *                                                                         
           PERFORM 8000-OPEN-OUTFILE                THRU  8000-EXIT.    
           INITIALIZE PRT331-RECORD.                                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-GET-PARM-DATA.                                          **        
      ******************************************************************        
      *                                                                         
       1000-GET-PARM-DATA.                                              
      *                                                                         
           PERFORM 1100-GET-COMPANY-NO              THRU 1100-EXIT.     
           PERFORM 7000-GET-COMPANY-NAME            THRU 7000-EXIT.     
           PERFORM 1200-GET-NO-DAYS                 THRU 1200-EXIT.     
           PERFORM 7200-CUT-OFF-DATE                THRU 7200-EXIT.     
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1100-GET-COMPANY-NO.                                         **        
      ******************************************************************        
      *                                                                         
       1100-GET-COMPANY-NO.                                             
      *                                                                         
           IF PARM-LENGTH > 0                                           
              MOVE PARM-COMP-NO      TO WS-PARM-COMP-NO                 
           ELSE                                                         
              MOVE WS-PARM26         TO WS-PARM-COMP-NO                 
           END-IF.                                                      
                                                                        
              MOVE WS-PARM-COMP-NO   TO WS-COMPANY-NO.                  
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1200-GET-NO-DAYS.                                            **        
      ******************************************************************        
      *                                                                         
       1200-GET-NO-DAYS.                                                
                                                                        
              MOVE 'PCSRP013'             TO WS-PROGRAM-NAME            
              MOVE 'PARM'                 TO WS-CMND-CD                 
                                                                        
           PERFORM 7100-GET-JOB-PARM                THRU 7100-EXIT.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             MOVE WS-PARM-DATA(1:15)      TO WS-NO-OF-DAYS-PARM         
             MOVE WS-PARM-DATA(16:05)     TO WS-PARM-DAYS               
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
             MOVE 270                     TO WS-PARM-DAYS               
           END-IF.                                                      
                                                                        
              MOVE WS-PARM-DAYS           TO WS-DAYS.                   
              MOVE WS-COMPANY-NAME        TO HDR-LN1-COMPANY-NAME.      
      *                                                                         
              MOVE 'DATE'                 TO WS-CMND-CD                 
                                                                        
           PERFORM 7100-GET-JOB-PARM                 THRU 7100-EXIT.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             MOVE WS-PARM-DATA(01:09)     TO WS-COMM-DATE-PARM          
             MOVE WS-PARM-DATA(10:10)     TO WS-COMM-DATE               
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
             PERFORM 1300-GET-COMMON-DATE            THRU 1300-EXIT     
           END-IF.                                                      
                                                                        
           DISPLAY 'COMMON DATE = ' WS-INPUT-DATE.                      
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1300-GET-COMMON-DATE                                         **        
      ******************************************************************        
      *                                                                         
       1300-GET-COMMON-DATE.                                            
      *                                                                         
           MOVE SPACES                    TO WS-INPUT-DATA-BREAKDOWN.   
      **********CALLING THE COPYBOOK CPD00037 USING WS-PGRMNAME.                
           PERFORM 6251-GET-FJC01-DATE          THRU 6251-EXIT.         
           MOVE WS-INPUT-DATE(1:4)        TO WS-COMMON-CCYY.            
           MOVE WS-INPUT-DATE(6:2)        TO WS-COMMON-MM.              
      **********CALLING THE COPYBOOK CPD00037 USING COMMON.                     
           IF WS-OVERRIDE-DATE-SW = WS-N                                
              MOVE SPACES                 TO WS-INPUT-DATA-BREAKDOWN    
              MOVE 'COMMON'               TO WS-PGRMNAME                
              PERFORM 6251-GET-FJC01-DATE       THRU 6251-EXIT          
              MOVE WS-INPUT-DATE(1:4)     TO WS-COMMON-CCYY             
              MOVE WS-INPUT-DATE(6:2)     TO WS-COMMON-MM               
           END-IF.                                                      
           MOVE WS-COMMON-DATE            TO WS-COMM-DATE               
           .                                                            
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *1400-METER-INVENTORY-PROCESS.                                   *        
      ******************************************************************        
      *                                                                         
       1400-METER-INVENTORY-PROCESS.                                    
                                                                        
           IF EQ-LOCAL-OFFICE NOT = '202'                               
                                                                        
             PERFORM 7560-OPEN-MOVE-HIST            THRU  7560-EXIT     
             PERFORM 7570-FETCH-MOVE-HIST           THRU  7570-EXIT     
                IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   MOVE SPACES                 TO MV-CODE-CRNT-LOC      
                END-IF                                                  
             PERFORM 7580-CLOSE-MOVE-HIST           THRU  7580-EXIT     
                                                                        
            IF MV-CODE-CRNT-LOC > ' '                                   
                                                                        
              IF (EQ-CODE-CRNT-LOC = 'A' AND                            
                                         MV-CODE-CRNT-LOC NOT = 'J') OR 
                 (EQ-CODE-CRNT-LOC = 'B' AND MV-CODE-CRNT-LOC = 'A')    
                                                                        
                 MOVE WS-Y                     TO WS-DATA-FOUND         
                 PERFORM 7800-GET-MTR-STORAGE       THRU  7800-EXIT     
                                                                        
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    MOVE W9-MTR-STORAGE-FAC-TX TO WS-MTR-STG-DESC       
                 END-IF                                                 
                                                                        
                 IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
                    MOVE EQ-LOCAL-OFFICE       TO WS-MTR-STG-DESC       
                 END-IF                                                 
                                                                        
                 PERFORM 7900-GET-MTR-DESC          THRU  7900-EXIT     
                    IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
                       MOVE SPACES             TO M5-METER-SIZE-DESC    
                    END-IF                                              
                                                                        
                 IF WS-MTR-STG-DESC EQUAL WS-TEMP-MTR                   
                   MOVE WS-Y                   TO WS-VALUE-DIFFER       
                 ELSE                                                   
                   MOVE WS-N                   TO WS-VALUE-DIFFER       
                   MOVE 0                      TO WS-LOCAL-COUNT        
                  IF WS-FIRST-VALUE = WS-N                              
                   PERFORM 8300-WRITE-FOOTER-DETAILS  THRU  8300-EXIT   
                  END-IF                                                
                 END-IF                                                 
                                                                        
                 COMPUTE WS-TOTAL-COUNT       = WS-TOTAL-COUNT   + 1    
                 COMPUTE WS-LOCAL-COUNT       = WS-LOCAL-COUNT   + 1    
                 MOVE WS-TOTAL-COUNT           TO FTR-LN3-TOTAL-MTR     
                 MOVE WS-LOCAL-COUNT           TO FTR-LN2-TOTAL-MTR     
                 MOVE WS-N                     TO WS-FIRST-VALUE        
                                                                        
                 IF WS-LOCAL-COUNT = 1 OR 50                            
                   MOVE WS-Y                   TO WS-BEGIN-VALUE        
                 ELSE                                                   
                   MOVE WS-N                   TO WS-BEGIN-VALUE        
                 END-IF                                                 
                                                                        
                 MOVE EQ-DEVICE-NO             TO OUT-MTR-NO            
                 MOVE EQ-SERIAL-NO             TO OUT-SERIAL-NO         
                 MOVE GM-METER-SIZE-ID         TO OUT-MTR-TYPE          
                 MOVE M5-METER-SIZE-DESC       TO OUT-MTR-TYPE-DESC     
                 MOVE GM-DATE-LAST-TESTED      TO OUT-LAST-TEST-DATE    
                 MOVE WS-MTR-STG-DESC          TO HDR-LN5-MTR-STR-FACI  
                 MOVE WS-MTR-STG-DESC          TO FTR-LN2-MTR-STR-FACI  
                 MOVE WS-MTR-STG-DESC          TO WS-TEMP-MTR           
                 PERFORM 2500-WRITE-REPORT          THRU  2500-EXIT     
                                                                        
              END-IF                                                    
            END-IF                                                      
           END-IF.                                                      
                                                                        
           PERFORM 7500-FETCH-MAIN-CSR              THRU  7500-EXIT     
                                                                        
           IF WS-ALL-ROWS-PROCESD = WS-Y                                
              PERFORM 8300-WRITE-FOOTER-DETAILS     THRU  8300-EXIT     
              PERFORM 8400-WRITE-END-FOOTER-DETAILS THRU  8400-EXIT     
           END-IF.                                                      
      *                                                                         
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      *2000-PROCESS-MAIN-CSR.                                          *        
      ******************************************************************        
      *                                                                         
                                                                        
       2000-PROCESS-MAIN-CSR.                                           
                                                                        
           PERFORM 7400-OPEN-MAIN-CSR               THRU  7400-EXIT.    
      *                                                                         
           PERFORM 7500-FETCH-MAIN-CSR              THRU  7500-EXIT.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                                                        
              PERFORM 1400-METER-INVENTORY-PROCESS  THRU 1400-EXIT      
              UNTIL WS-ALL-ROWS-PROCESD = WS-Y                          
                                                                        
           END-IF.                                                      
                                                                        
           IF WS-DATA-FOUND = WS-N                                      
              PERFORM 8100-WRITE-OUTFILE-HEADER     THRU  8100-EXIT     
              PERFORM 8500-WRITE-NODATA-DETAILS     THRU  8500-EXIT     
           END-IF                                                       
                                                                        
           PERFORM 7550-CLOSE-MAIN-CSR              THRU  7550-EXIT.    
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 2500-WRITE-REPORT.                                           *          
      ****************************************************************          
      *                                                                         
        2500-WRITE-REPORT.                                              
                                                                        
           IF WS-VALUE-DIFFER = WS-N OR WS-LOCAL-COUNT = 50             
              COMPUTE WS-PAGE-NO        = WS-PAGE-NO       + 1          
              MOVE WS-PAGE-NO                 TO HDR-LN1-PAGE-NO        
              PERFORM 8100-WRITE-OUTFILE-HEADER     THRU  8100-EXIT     
           END-IF                                                       
                                                                        
             IF WS-BEGIN-VALUE = WS-Y                                   
              PERFORM 8205-WRITE-OUTFILE-DETAIL     THRU  8205-EXIT     
             ELSE                                                       
              PERFORM 8200-WRITE-OUTFILE-DETAILS    THRU  8200-EXIT     
             END-IF                                                     
           .                                                            
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 6251-GET-FJC01-DATE.                                         *          
      ****************************************************************          
       COPY CPD00037.                                                           
      *                                                                         
      ******************************************************************        
      ** 7000-GET-COMPANY-NAME.                                                 
      ******************************************************************        
      *                                                                         
       7000-GET-COMPANY-NAME.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  C7.COMPANY_NAME                                   
                INTO :WS-COMPANY-NAME                                   
                FROM CSS_COMPANY C7 WITH(READUNCOMMITTED)                       
               WHERE C7.COMPANY_NO = :WS-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  C7.COMPANY_NAME                                           
MFA-TR*         INTO :WS-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY C7                                             
MFA-TR*        WHERE C7.COMPANY_NO = :WS-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP013 ABORT *****'                   
              DISPLAY '**  7000-GET-COMPANY-NAME  **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  C7-COMPANY-NO = ' WS-COMPANY-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                 33591000
      ******************************************************************        
      **  7100-GET-JOB-PARM.                                          **        
      ** GET PARM DATA FROM JOB_PARM TABLE                            **        
      ******************************************************************        
      *                                                                         
       7100-GET-JOB-PARM.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :WS-PARM-DATA                                      
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
               WHERE PROGRAM_NAME = :WS-PROGRAM-NAME                    
                 AND STATUS       = 'A'                                 
                 AND COMPANY_NO   = :WS-COMPANY-NO                      
                 AND CMND_CODE    = :WS-CMND-CD                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PARM_DATA                                                  
MFA-TR*         INTO :WS-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE PROGRAM_NAME = :WS-PROGRAM-NAME                            
MFA-TR*          AND STATUS       = 'A'                                         
MFA-TR*          AND COMPANY_NO   = :WS-COMPANY-NO                              
MFA-TR*          AND CMND_CODE    = :WS-CMND-CD                                 
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
             CONTINUE                                                   
                                                                        
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP013 ABORT *****'                   
              DISPLAY '**PARM-DATA FETCH FAILED   **'                   
              DISPLAY '**7100-GET-JOB-PARM        **'                   
              DISPLAY '**PGM NAME    = ' WS-PROGRAM-NAME                
              DISPLAY '**COMPANY NO  = ' WS-COMPANY-NO                  
              DISPLAY '**CMND CODE   = ' WS-CMND-CD                     
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7200-CUT-OFF-DATE.                                          **        
      ** GET PARM DATE FROM JOB_PARM TABLE                            **        
      ******************************************************************        
      *                                                                         
       7200-CUT-OFF-DATE.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT (DATEADD(D, (CIS.DAYS(CAST(SYSDATETIMEOFFSET() 
           AS DATE)) - 270)-1, CAST('00010101' AS DATE)))                   
                INTO :WS-CUTOFF-DT                                      
                FROM CSS_MODEL_SQL WITH(READUNCOMMITTED)                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT (DATE(DAYS(CURRENT DATE) - 270))                           
MFA-TR*         INTO :WS-CUTOFF-DT                                              
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
             CONTINUE                                                   
           WHEN OTHER                                                   
              DISPLAY '******** PCSCA013 ABORT *****'                   
              DISPLAY '**CUT-OFF DT FETCH FAILED  **'                   
              DISPLAY '**7200-CUT-OFF-DATE        **'                   
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7400-OPEN-MAIN-CSR.                                          **        
      ******************************************************************        
      *                                                                         
       7400-OPEN-MAIN-CSR.                                              
      *                                                                         
           EXEC SQL                                                     
              OPEN MAIN_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP013 ABORT *****'                   
              DISPLAY '**OPEN MAIN CURSOR ERROR   **'                   
              DISPLAY '**7400-OPEN-MAIN-CSR       **'                   
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7500-FETCH-GET-MAIN                                          **        
      ******************************************************************        
      *                                                                         
       7500-FETCH-MAIN-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              FETCH MAIN_CSR                                            
               INTO :EQ-DEVICE-NO                                       
                   ,:GM-DATE-LAST-TESTED                                
                   ,:EQ-SERIAL-NO                                       
                   ,:EQ-LOCAL-OFFICE                                    
                   ,:EQ-CODE-CRNT-LOC                                   
                   ,:EQ-DATE-LAST-MOVE                                  
                   ,:GM-METER-SIZE-ID                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
              CONTINUE                                                  
           WHEN NOT-FOUND                                               
              MOVE WS-Y                   TO WS-ALL-ROWS-PROCESD        
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP013 ABORT *****'                   
              DISPLAY '**  MAIN CURSOR FETCH ERROR**'                   
              DISPLAY '**7500-FETCH-MAIN-CSR      **'                   
              DISPLAY '**EQ.COMPANY_NO        =' WS-PARM-COMP-NO        
              DISPLAY '**GM.DATE_LAST_TESTED <=' WS-CUTOFF-DT           
              DISPLAY '**RETURN CODE          =' WS-ACTIVE-RETURN-CODE  
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      ** 7550-CLOSE-MAIN-CSR                                          **        
      ******************************************************************        
      *                                                                         
       7550-CLOSE-MAIN-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE MAIN_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP013 ABORT *****'                   
              DISPLAY '**CLOSE MAIN   CURSOR ERROR**'                   
              DISPLAY '**7550-CLOSE-MAIN-CSR      **'                   
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7560-OPEN-MOVE-HIST.                                         **        
      ******************************************************************        
      *                                                                         
       7560-OPEN-MOVE-HIST.                                             
      *                                                                         
           EXEC SQL                                                     
              OPEN MOVE_HIST                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP013 ABORT *****'                   
              DISPLAY '**  OPEN HIST CURSOR ERROR **'                   
              DISPLAY '**7560-MOVE_HIST           **'                   
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
                                                                        
      *                                                                         
       7560-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7570-FETCH-MOVE-HIST.                                        **        
      ******************************************************************        
      *                                                                         
       7570-FETCH-MOVE-HIST.                                            
      *                                                                         
           EXEC SQL                                                     
              FETCH MOVE_HIST                                           
               INTO :MV-CODE-CRNT-LOC                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
              CONTINUE                                                  
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP013 ABORT *****'                   
              DISPLAY '**  HIST CURSOR FETCH ERROR**'                   
              DISPLAY '**7570-FETCH-MOVE-HIST     **'                   
              DISPLAY '**DEVICE_NO   = ' EQ-DEVICE-NO                   
              DISPLAY '**DATE_MOVE  <= ' EQ-DATE-LAST-MOVE              
              DISPLAY '**COMPANY_NO  = ' WS-PARM-COMP-NO                
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7570-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      ** 7580-CLOSE-MOVE-HIST.                                        **        
      ******************************************************************        
      *                                                                         
       7580-CLOSE-MOVE-HIST.                                            
      *                                                                         
           EXEC SQL                                                     
              CLOSE MOVE_HIST                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP013 ABORT *****'                   
              DISPLAY '**CLOSE HIST   CURSOR ERROR**'                   
              DISPLAY '**7580-CLOSE-MOVE-HIST     **'                   
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7580-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * *                                                                       
      * 7600-START-FCSJC01                                           *          
      ****************************************************************          
      *                                                                         
            EXEC SQL                                                            
               INCLUDE CPD00038                                                 
            END-EXEC.                                                           
                                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      ** 7800-GET-MTR-STORAGE.                                        **        
      ******************************************************************        
      *                                                                         
       7800-GET-MTR-STORAGE.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT MTR_STORAGE_FAC_TX                                 
                INTO :W9-MTR-STORAGE-FAC-TX                             
                FROM CSS_MTR_STORGE_FAC WITH(READUNCOMMITTED)                   
               WHERE MTR_STORAGE_FAC_CD = :EQ-LOCAL-OFFICE              
                 AND COMPANY_NO         = :WS-PARM-COMP-NO              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MTR_STORAGE_FAC_TX                                         
MFA-TR*         INTO :W9-MTR-STORAGE-FAC-TX                                     
MFA-TR*         FROM CSS_MTR_STORGE_FAC                                         
MFA-TR*        WHERE MTR_STORAGE_FAC_CD = :EQ-LOCAL-OFFICE                      
MFA-TR*          AND COMPANY_NO         = :WS-PARM-COMP-NO                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7800                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP013 ABORT *****'                   
              DISPLAY '**GET MTR STORAGE ERROR    **'                   
              DISPLAY '**7800-GET-MTR-STORAGE     **'                   
              DISPLAY '**RETURN CODE        =' WS-ACTIVE-RETURN-CODE    
              DISPLAY '**MTR_STORAGE_FAC_CD =' EQ-LOCAL-OFFICE          
              DISPLAY '**COMPANY_NO         =' WS-PARM-COMP-NO          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7900-GET-MTR-DESC.                                           **        
      ******************************************************************        
      *                                                                         
       7900-GET-MTR-DESC.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT METER_SIZE_DESC                                    
                INTO :M5-METER-SIZE-DESC                                
                FROM CSS_GAS_METER_SIZE WITH(READUNCOMMITTED)                   
               WHERE METER_SIZE_ID = :GM-METER-SIZE-ID                  
                 AND COMPANY_NO    = :WS-PARM-COMP-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT METER_SIZE_DESC                                            
MFA-TR*         INTO :M5-METER-SIZE-DESC                                        
MFA-TR*         FROM CSS_GAS_METER_SIZE                                         
MFA-TR*        WHERE METER_SIZE_ID = :GM-METER-SIZE-ID                          
MFA-TR*          AND COMPANY_NO    = :WS-PARM-COMP-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7900                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP013 ABORT *****'                   
              DISPLAY '**GET MTR DESC        ERROR**'                   
              DISPLAY '**7900-GET-MTR-DESC        **'                   
              DISPLAY '**METER_SIZE_ID =' GM-METER-SIZE-ID              
              DISPLAY '**COMPANY_NO    =' WS-PARM-COMP-NO               
              DISPLAY '**RETURN CODE   =' WS-ACTIVE-RETURN-CODE         
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8000-OPEN-OUTFILE.                                       **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8000-OPEN-OUTFILE.                                               
      *                                                                 08230000
           OPEN OUTPUT FCSPT331-FILE.                                   
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSPT331-FILE    **'          
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 08335000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8100-WRITE-OUTFILE-HEADER                                **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8100-WRITE-OUTFILE-HEADER.                                       
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP013-HDR-REC-LN1                
                  AFTER ADVANCING PAGE.                                 
           WRITE PRT331-RECORD FROM WS-RP013-HDR-REC-LN2.               
           WRITE PRT331-RECORD FROM WS-RP013-HDR-REC-LN3.               
           WRITE PRT331-RECORD FROM WS-RP013-HDR-REC-LN5.               
           WRITE PRT331-RECORD FROM WS-RP013-HDR-REC-LN6                
                  AFTER ADVANCING 3 LINES.                              
           WRITE PRT331-RECORD FROM WS-RP013-HDR-REC-LN7.               
      *                                                                 08335000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8200-WRITE-OUTFILE-DETAILS                               **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8200-WRITE-OUTFILE-DETAILS.                                      
      *                                                                 08230000
                                                                        
           WRITE PRT331-RECORD FROM WS-RP013-OUT-REC.                   
      *                                                                 08335000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8205-WRITE-OUTFILE-DETAIL                                **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8205-WRITE-OUTFILE-DETAIL.                                       
      *                                                                 08230000
                                                                        
           WRITE PRT331-RECORD FROM WS-RP013-OUT-REC                    
                  AFTER ADVANCING 2 LINES.                              
      *                                                                 08335000
       8205-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8300-WRITE-FOOTER-DETAILS                                **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8300-WRITE-FOOTER-DETAILS.                                       
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP013-FTR-REC-LN1.               
           WRITE PRT331-RECORD FROM WS-RP013-FTR-REC-LN2.               
      *                                                                 08335000
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08060000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8400-WRITE-END-FOOTER-DETAILS                            **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8400-WRITE-END-FOOTER-DETAILS.                                   
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP013-FTR-REC-LNX                
                  AFTER ADVANCING 2 LINES.                              
           WRITE PRT331-RECORD FROM WS-RP013-FTR-REC-LN3.               
           WRITE PRT331-RECORD FROM WS-RP013-FTR-REC-LN4.               
      *                                                                 08335000
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08060000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8500-WRITE-NODATA-DETAILS                                **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8500-WRITE-NODATA-DETAILS.                                       
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP013-FTR-NODATA.                
      *                                                                 08335000
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8900-CLOSE-OUTFILE                                       **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8900-CLOSE-OUTFILE.                                              
      *                                                                 08230000
           CLOSE FCSPT331-FILE.                                         
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR CLOSING FCSPT331-FILE    **'          
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 08335000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      *                                                                         
      ****************************************************************  08384100
      **                                                            **  08384200
      **   9000-TERMINATE                                           **  08384300
      **       CLOSES FILES AND TERMINATES THE PROGRAM              **  08384400
      **                                                            **  08384500
      ****************************************************************  08384600
      *                                                                 08384700
       9000-TERMINATE.                                                  
      *                                                                 08409300
           PERFORM 8900-CLOSE-OUTFILE               THRU  8900-EXIT.    
      *                                                                 08420000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08450000
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
