       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP008.                                      
COB303 DATE-WRITTEN.     SEP 21, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------*        
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --*        
      *----------------------------------------------------------------*        
      *--                         S U M M A R Y                      --*        
      *--THIS PROGRAM WILL GENERATE REPORTS FOR 12 MONTHS            --*        
      *--HISTORY BY LOCAL OFFICE, RATE PLANS AND USAGE THERMS        --*        
      *----------------------------------------------------------------*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                        MODIFICATION LOG                    --*        
      *--                                                            --*        
      *--  DATE          INITIALS    COMMENTS                        --*        
      *--  -----------   --------    ----------------------------------*        
A05268*--  10/21/2015    VK7L032     CONVERTED THE EAZYTRIVE PGM     --*        
ACT027*--                            PNC008 TO COBOL.                --*        
ACT232*--A05460-ACT232               FIRST ACCOUNT ON REPORT 3 TO BE --*        
ACT232*--A05460-ACT232               DROPPED.                        --*        
ACT232*--A05460-ACT232               EXPAND CONSUMPTION FIELDS TO    --*        
ACT232*--A05460-ACT232               PREVENT TRUNCATION              --*        
      *----------------------------------------------------------------*        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT SRTDA-FILE                                            
               ASSIGN TO UT-S-SRTDA                                     
               FILE STATUS IS WS-SRTDA-STATUS.                          
           SELECT SRTDB-FILE                                            
               ASSIGN TO UT-S-SRTDB                                     
               FILE STATUS IS WS-SRTDB-STATUS.                          
           SELECT SRTDC-FILE                                            
               ASSIGN TO UT-S-SRTDC                                     
               FILE STATUS IS WS-SRTDC-STATUS.                          
      *                                                                         
       COPY CSSPT33.                                                            
       COPY CSSPT331.                                                           
       COPY CSSPT332.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       FD  SRTDA-FILE                                                   
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      *                                                                         
       01 SRTDA-REC                    PIC X(350).                      
      *                                                                         
       FD  SRTDB-FILE                                                   
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      *                                                                         
       01 SRTDB-REC                    PIC X(350).                      
      *                                                                         
       FD  SRTDC-FILE                                                   
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      *                                                                         
       01 SRTDC-REC                    PIC X(350).                      
      *                                                                         
       COPY CFDPT33  REPLACING ==132==            BY ==159==.                   
       COPY CFDPT33  REPLACING ==PRT33-CC==       BY ==PRT331-CC==              
                               ==PRT33-DATA==     BY ==PRT331-DATA==            
                               ==PRT33-RECORD==   BY ==PRT331-RECORD==          
                               ==FCSPT33-FILE==   BY ==FCSPT331-FILE==          
                               ==132==            BY ==159==.                   
       COPY CFDPT33  REPLACING ==PRT33-CC==       BY ==PRT332-CC==              
                               ==PRT33-DATA==     BY ==PRT332-DATA==            
                               ==PRT33-RECORD==   BY ==PRT332-RECORD==          
                               ==FCSPT33-FILE==   BY ==FCSPT332-FILE==          
                               ==132==            BY ==159==.                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP008'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                             *           
       COPY FIOBW03.                                                            
      *                                                             *           
      ***************************************************************           
      *                                                                         
       01 WS-LITERALS.                                                  
           05 WS-PROGRAM                PIC X(08) VALUE 'PCSRP008'.     
           05 WS-RPT1-NAME              PIC X(09) VALUE 'PNC008-01'.    
           05 WS-RPT2-NAME              PIC X(09) VALUE 'PNC008-02'.    
           05 WS-RPT3-NAME              PIC X(09) VALUE 'PNC008-03'.    
           05 WS-RPT1-AVG               PIC X(37)                       
                      VALUE 'LINE 2 - AVERAGE DAILY CONSMPTION ***'.    
           05 WS-RPT2-AVG               PIC X(37)                       
                      VALUE 'LINE 3 - ACTUAL REVENUE DOLLARS   ***'.    
           05 WS-RPT1-REV               PIC X(35)                       
                      VALUE '*** LINE 3 - ACTUAL REVENUE DOLLARS'.      
           05 WS-RPT2-REV               PIC X(75) VALUE '*** '.         
           05 WS-FIRST-RPT1             PIC X(01) VALUE 'Y'.            
           05 WS-FIRST-RPT2             PIC X(01) VALUE 'Y'.            
           05 WS-FIRST-RPT3             PIC X(01) VALUE 'Y'.            
           05 WS-HDR-EXIST1             PIC X(01) VALUE 'Y'.            
           05 WS-HDR-EXIST2             PIC X(01) VALUE 'Y'.            
           05 WS-HDR-EXIST3             PIC X(01) VALUE 'Y'.            
           05 WS-TRLR-REC1              PIC X(01) VALUE 'N'.            
           05 WS-TRLR-REC2              PIC X(01) VALUE 'N'.            
           05 WS-YES                    PIC X(01) VALUE 'Y'.            
           05 WS-NO                     PIC X(01) VALUE 'N'.            
      *                                                                         
       01 WS-MISC.                                                      
           05 WS-RPT-NAME               PIC X(09) VALUE SPACES.         
           05 WS-RPT-AVG                PIC X(37) VALUE SPACES.         
           05 WS-RPT-REV                PIC X(75) VALUE SPACES.         
           05 WS-SUB                    PIC S9(04) COMP VALUE ZEROES.   
           05 WS-COUNTER                PIC S9(04) COMP VALUE ZEROES.   
           05 WS-PAGE-NUM1              PIC 9(06) VALUE ZEROES.         
           05 WS-PAGE-NUM2              PIC 9(06) VALUE ZEROES.         
           05 WS-PAGE-NUM3              PIC 9(06) VALUE ZEROES.         
           05 WS-LINE-COUNT1            PIC 9(03) VALUE ZEROES.         
           05 WS-LINE-COUNT2            PIC 9(03) VALUE ZEROES.         
           05 WS-LINE-COUNT3            PIC 9(03) VALUE ZEROES.         
           05 WS-TOTAL-USAGE-THERMS     PIC 9(11) VALUE ZEROES.         
           05 WS-TOTAL-REV-AMT          PIC 9(13) VALUE ZEROES.         
           05 WS-PREV-LOC-OFFICE1       PIC X(03) VALUE SPACES.         
           05 WS-PREV-LOC-OFFICE2       PIC X(03) VALUE SPACES.         
           05 WS-PREV-ACCOUNT-NO        PIC X(16) VALUE SPACES.         
           05 WS-SAVE-ACCT              PIC 9(13) VALUE ZEROES.         
           05 WS-SAVE-ACCOUNT1     REDEFINES WS-SAVE-ACCT.              
              10 WS-SAVE-ACCT1          PIC X(01).                      
              10 WS-SAVE-ACCT2          PIC X(04).                      
              10 WS-SAVE-ACCT3          PIC X(04).                      
              10 WS-SAVE-ACCT4          PIC X(04).                      
           05 WS-ACCT                   PIC X(13).                      
           05 WS-ACCOUNT1.                                              
              10 WS-ACCT1               PIC X(01) VALUE SPACES.         
              10 WS-ACCT1D              PIC X(01) VALUE '-'.            
              10 WS-ACCT2               PIC X(04) VALUE SPACES.         
              10 WS-ACCT2D              PIC X(01) VALUE '-'.            
              10 WS-ACCT3               PIC X(04) VALUE SPACES.         
              10 WS-ACCT3D              PIC X(01) VALUE '-'.            
              10 WS-ACCT4               PIC X(04) VALUE SPACES.         
      *                                                                         
           05 WS-REVENUE-MONTH.                                         
              10 WS-REV-CC              PIC 9(02) VALUE ZEROES.         
              10 WS-REV-YY              PIC 9(02) VALUE ZEROES.         
              10 WS-REV-MM              PIC 9(02) VALUE ZEROES.         
           05 WS-REV-MONTH.                                             
              10 WS-REV-MTH             PIC 9(02) VALUE ZEROES.         
              10 WS-REV-YEAR            PIC 9(02) VALUE ZEROES.         
           05 WS-MONTH-EDT.                                             
              10 WS-EDT-MTH             PIC X(02) VALUE ZEROES.         
              10 FILLER                 PIC X(01) VALUE '-'.            
              10 WS-EDT-YEAR            PIC X(02) VALUE ZEROES.         
           05 WS-MTH-TABLE.                                             
              10 WS-MONTH               PIC 9(05)                       
                                        VALUE ZEROES OCCURS 12 TIMES.   
           05 WS-MONTH-CONS.                                            
              10 WS-MTH-CONS            PIC 9(07)                       
                                        VALUE ZEROES OCCURS 12 TIMES.   
           05 WS-DLY-TABLE.                                             
              10 WS-DLY-CONS            PIC 9(06)                       
                                        VALUE ZEROES OCCURS 12 TIMES.   
           05 WS-REV-TABLE.                                             
              10 WS-REV-AMT             PIC 9(07)                       
                                        VALUE ZEROES OCCURS 12 TIMES.   
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                    PIC 9(04) VALUE ZEROES.         
           05  WS-CM                    PIC 9(02) VALUE ZEROES.         
           05  WS-CD                    PIC 9(02) VALUE ZEROES.         
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                    PIC 9(02) VALUE ZEROES.         
           05  WS-MM                    PIC 9(02) VALUE ZEROES.         
           05  WS-SS                    PIC 9(02) VALUE ZEROES.         
           05  WS-TT                    PIC 9(02) VALUE ZEROES.         
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                 PIC X(02) VALUE SPACES.         
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-DD                 PIC X(02) VALUE SPACES.         
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-YY                 PIC X(04) VALUE SPACES.         
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                 PIC X(02) VALUE SPACES.         
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-MM                 PIC X(02) VALUE SPACES.         
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-SS                 PIC X(02) VALUE SPACES.         
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-SRTDA-STATUS          PIC X(02) VALUE '00'.           
               88 SRTDA-SUCCESSFUL                VALUE '00'.           
               88 END-OF-REC1                     VALUE '10'.           
           05  WS-SRTDB-STATUS          PIC X(02) VALUE '00'.           
               88 SRTDB-SUCCESSFUL                VALUE '00'.           
               88 END-OF-REC2                     VALUE '10'.           
           05  WS-SRTDC-STATUS          PIC X(02) VALUE '00'.           
               88 SRTDC-SUCCESSFUL                VALUE '00'.           
               88 END-OF-REC3                     VALUE '10'.           
           05  WS-FCA331-STATUS         PIC X(02) VALUE SPACES.         
           05  WS-FCA332-STATUS         PIC X(02) VALUE SPACES.         
      *                                                                         
      ***************** PCSRP008 REPORT HEADERS ***********************         
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT-HEADER-1.                                         
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  RPT-NAME             PIC X(09) VALUE SPACES.         
               10  FILLER               PIC X(55) VALUE SPACES.         
               10  FILLER               PIC X(11) VALUE 'PSNC ENERGY'.  
               10  FILLER               PIC X(45) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE 'PAGE'.         
               10  RPT-PGNUM            PIC Z(06)9.                     
      *                                                                         
           05  WS-RPT-HEADER-2.                                         
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(07) VALUE 'DATE:  '.      
               10  RPT-DATE             PIC X(10) VALUE SPACES.         
               10  FILLER               PIC X(31) VALUE SPACES.         
               10  RPT-DESC1            PIC X(19) VALUE SPACES.         
               10  RPT-DESC2            PIC X(41) VALUE SPACES.         
               10  FILLER               PIC X(03) VALUE SPACES.         
               10  FILLER               PIC X(10) VALUE 'RUN DATE: '.   
               10  RPT-RUN-DATE         PIC X(10) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-3.                                         
               10  FILLER               PIC X(60) VALUE SPACES.         
               10  FILLER               PIC X(20)                       
                                        VALUE 'FOR LOCAL OFFICE:   '.   
               10  RPT-LOCAL-OFFICE     PIC X(03) VALUE SPACES.         
               10  FILLER               PIC X(29) VALUE SPACES.         
               10  FILLER               PIC X(09) VALUE 'RUN TIME:'.    
               10  FILLER               PIC X(03) VALUE SPACES.         
               10  RPT-RUN-TIME         PIC X(08) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-4.                                         
               10  FILLER               PIC X(133) VALUE SPACES.        
      *                                                                         
           05  WS-RPT-HEADER-5.                                         
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(14)                       
                                        VALUE 'ACCOUNT NUMBER'.         
               10  FILLER               PIC X(06) VALUE SPACES.         
               10  FILLER               PIC X(13)                       
                                        VALUE 'CUSTOMER NAME'.          
               10  FILLER               PIC X(12) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE '*** '.         
               10  FILLER               PIC X(30)                       
                              VALUE 'LINE 1 - ACTUAL DT CONSUMPTION'.   
               10  FILLER               PIC X(04) VALUE SPACES.         
               10  RPT-AVG              PIC X(37) VALUE SPACES.         
               10  FILLER               PIC X(31) VALUE SPACES.         
               10  FILLER               PIC X(06) VALUE 'TWELVE'.       
      *                                                                         
           05  WS-RPT-HEADER-6.                                         
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(05) VALUE 'RATE '.        
               10  FILLER               PIC X(07) VALUE 'CLASS  '.      
               10  FILLER               PIC X(06) VALUE 'ZIP   '.       
               10  FILLER               PIC X(18)                       
                                        VALUE 'STATE TAX EXMPT NO'.     
               10  FILLER               PIC X(09) VALUE SPACES.         
               10  RPT-REV              PIC X(72) VALUE SPACES.         
               10  FILLER               PIC X(34) VALUE '***     '.     
               10  FILLER               PIC X(06) VALUE 'MONTHS'.       
      *                                                                         
           05  WS-RPT-HEADER-7.                                         
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE 'SIC '.         
               10  FILLER               PIC X(08) VALUE 'STATUS  '.     
               10  FILLER               PIC X(08) VALUE 'AFC     '.     
               10  FILLER               PIC X(23)                       
                                        VALUE 'SERVICE ADDRESS      '.  
               10  RPT-MONTH1           PIC X(05) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE SPACES.         
               10  RPT-MONTH2           PIC X(05) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE SPACES.         
               10  RPT-MONTH3           PIC X(05) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE SPACES.         
               10  RPT-MONTH4           PIC X(05) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE SPACES.         
               10  RPT-MONTH5           PIC X(05) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE SPACES.         
               10  RPT-MONTH6           PIC X(05) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE SPACES.         
               10  RPT-MONTH7           PIC X(05) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE SPACES.         
               10  RPT-MONTH8           PIC X(05) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE SPACES.         
               10  RPT-MONTH9           PIC X(05) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE SPACES.         
               10  RPT-MONTH10          PIC X(05) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE SPACES.         
               10  RPT-MONTH11          PIC X(05) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE SPACES.         
               10  RPT-MONTH12          PIC X(05) VALUE SPACES.         
               10  FILLER               PIC X(05) VALUE SPACES.         
               10  FILLER               PIC X(05) VALUE 'TOTAL'.        
      *                                                                         
           05  WS-RPT-HEADER-8.                                         
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT-ACCOUNT-NO        PIC X(16) VALUE SPACES.         
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT-CUST-NAME         PIC X(20) VALUE SPACES.         
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT-LINE1             PIC X(01) VALUE '1'.            
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT-MTH-CONS1         PIC Z(07)9.                     
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT-MTH-CONS2         PIC Z(07)9.                     
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT-MTH-CONS3         PIC Z(07)9.                     
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT-MTH-CONS4         PIC Z(07)9.                     
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT-MTH-CONS5         PIC Z(07)9.                     
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT-MTH-CONS6         PIC Z(07)9.                     
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT-MTH-CONS7         PIC Z(07)9.                     
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT-MTH-CONS8         PIC Z(07)9.                     
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT-MTH-CONS9         PIC Z(07)9.                     
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT-MTH-CONS10        PIC Z(07)9.                     
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT-MTH-CONS11        PIC Z(07)9.                     
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT-MTH-CONS12        PIC Z(07)9.                     
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT-TOT-DT-CONS       PIC Z(08)9.                     
      *                                                                         
           05  WS-RPT-HEADER-9.                                         
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT-RATE-PLAN         PIC X(03) VALUE SPACES.         
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT-REV-CLASS         PIC X(03) VALUE SPACES.         
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT-ZIP-CODE          PIC X(05) VALUE SPACES.         
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT-STATE-TAX-EXMPT-NO PIC X(13) VALUE SPACES.        
               10 FILLER                PIC X(08) VALUE SPACES.         
               10 RPT-LINE2             PIC X(01) VALUE '2'.            
               10 FILLER                PIC X(03) VALUE SPACES.         
               10 RPT-DLY-CONS1         PIC Z(05)9.                     
               10 FILLER                PIC X(03) VALUE SPACES.         
               10 RPT-DLY-CONS2         PIC Z(05)9.                     
               10 FILLER                PIC X(03) VALUE SPACES.         
               10 RPT-DLY-CONS3         PIC Z(05)9.                     
               10 FILLER                PIC X(03) VALUE SPACES.         
               10 RPT-DLY-CONS4         PIC Z(05)9.                     
               10 FILLER                PIC X(03) VALUE SPACES.         
               10 RPT-DLY-CONS5         PIC Z(05)9.                     
               10 FILLER                PIC X(03) VALUE SPACES.         
               10 RPT-DLY-CONS6         PIC Z(05)9.                     
               10 FILLER                PIC X(03) VALUE SPACES.         
               10 RPT-DLY-CONS7         PIC Z(05)9.                     
               10 FILLER                PIC X(03) VALUE SPACES.         
               10 RPT-DLY-CONS8         PIC Z(05)9.                     
               10 FILLER                PIC X(03) VALUE SPACES.         
               10 RPT-DLY-CONS9         PIC Z(05)9.                     
               10 FILLER                PIC X(03) VALUE SPACES.         
               10 RPT-DLY-CONS10        PIC Z(05)9.                     
               10 FILLER                PIC X(03) VALUE SPACES.         
               10 RPT-DLY-CONS11        PIC Z(05)9.                     
               10 FILLER                PIC X(03) VALUE SPACES.         
               10 RPT-DLY-CONS12        PIC Z(05)9.                     
               10 FILLER                PIC X(01) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-10.                                        
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT-CODE-SIC          PIC X(04) VALUE SPACES.         
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT-CODE-STAT         PIC X(07) VALUE SPACES.         
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT-AFC               PIC X(01) VALUE SPACES.         
               10 FILLER                PIC X(03) VALUE SPACES.         
               10 RPT-SERV-ADDR         PIC X(20) VALUE SPACES.         
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT-LINE3             PIC X(01) VALUE '3'.            
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT-REV-AMT1          PIC Z(06)9.                     
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT-REV-AMT2          PIC Z(06)9.                     
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT-REV-AMT3          PIC Z(06)9.                     
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT-REV-AMT4          PIC Z(06)9.                     
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT-REV-AMT5          PIC Z(06)9.                     
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT-REV-AMT6          PIC Z(06)9.                     
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT-REV-AMT7          PIC Z(06)9.                     
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT-REV-AMT8          PIC Z(06)9.                     
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT-REV-AMT9          PIC Z(06)9.                     
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT-REV-AMT10         PIC Z(06)9.                     
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT-REV-AMT11         PIC Z(06)9.                     
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT-REV-AMT12         PIC Z(06)9.                     
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT-TOT-REV-AMT       PIC Z(07)9.                     
      *                                                                         
           05  WS-RPT-HEADER-11.                                        
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(35)                       
               VALUE '- - - - - - - - - - - - - - - - - -'.             
               10  FILLER               PIC X(35)                       
               VALUE ' - - - - - - - - - - - - - - - - - '.             
               10  FILLER               PIC X(35)                       
               VALUE '- - - - - - - - - - - - - - - - - -'.             
               10  FILLER               PIC X(27)                       
               VALUE ' - - - - - - - - - - - - - '.                     
      *                                                                         
           05  WS-RPT-HEADER-12.                                        
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT2-RATE-PLAN        PIC X(03) VALUE SPACES.         
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT2-REV-CLASS        PIC X(03) VALUE SPACES.         
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT2-ZIP-CODE         PIC X(05) VALUE SPACES.         
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT2-STATE-TAX-EXMPT-NO PIC X(13) VALUE SPACES.       
               10 FILLER                PIC X(08) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-13.                                        
               10 FILLER                PIC X(01) VALUE SPACES.         
               10 RPT3-RATE-PLAN        PIC X(03) VALUE SPACES.         
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT3-REV-CLASS        PIC X(03) VALUE SPACES.         
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT3-ZIP-CODE         PIC X(05) VALUE SPACES.         
               10 FILLER                PIC X(02) VALUE SPACES.         
               10 RPT3-STATE-TAX-EXMPT-NO PIC X(13) VALUE SPACES.       
               10 FILLER                PIC X(08) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-14.                                        
               10  FILLER               PIC X(60) VALUE SPACES.         
               10  FILLER               PIC X(34)                       
                   VALUE '(RATES 145, 150, 200, 201 AND 202)'.          
               10  FILLER               PIC X(18) VALUE SPACES.         
               10  FILLER               PIC X(09) VALUE 'RUN TIME:'.    
               10  FILLER               PIC X(03) VALUE SPACES.         
               10  RPT-RUN-TIME3        PIC X(08) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-TRAILER-1.                                        
               10  FILLER               PIC X(17) VALUE SPACES.         
               10  FILLER               PIC X(41)                       
                   VALUE '*** B-FUEL OIL  C-COAL  P-PROPANE  W-WOOD'.   
               10  FILLER               PIC X(21)                       
                   VALUE '  X-NO ALTERNATE FUEL'.                       
               10  FILLER               PIC X(35)                       
                   VALUE '  %-PARTIAL ALT FUEL CAPABILITY ***'.         
               10  FILLER               PIC X(19) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-TRAILER-2.                                        
               10  FILLER               PIC X(17) VALUE SPACES.         
               10  FILLER               PIC X(32)                       
                   VALUE '*** 2-#2 FUEL OIL  4-#4 FUEL OIL'.            
               10  FILLER               PIC X(32)                       
                   VALUE '  5-#5 FUEL OIL  6-#6 FUEL OIL  '.            
               10  FILLER               PIC X(33)                       
                   VALUE 'M-MTPL ALT FUEL CAPABILITY    ***'.           
               10  FILLER               PIC X(19) VALUE SPACES.         
      *                                                                         
       01  WS-END-DATA.                                                 
           05  FILLER                   PIC X(55) VALUE SPACES.         
           05  FILLER                   PIC X(22) VALUE                 
                     '*** END OF REPORT ***'.                           
           05  FILLER                   PIC X(55) VALUE SPACES.         
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE               THRU  0100-EXIT.       
           PERFORM 7000-READ-SRTDA               THRU  7000-EXIT.       
           PERFORM 2000-PROCESS-SRTDA            THRU  2000-EXIT        
                   UNTIL END-OF-REC1.                                   
           PERFORM 7100-READ-SRTDB               THRU  7100-EXIT.       
           PERFORM 2300-PROCESS-SRTDB            THRU  2300-EXIT        
                   UNTIL END-OF-REC2.                                   
           PERFORM 7200-READ-SRTDC               THRU  7200-EXIT.       
           PERFORM 2400-PROCESS-SRTDC            THRU  2400-EXIT        
                   UNTIL END-OF-REC3.                                   
           PERFORM 2500-END-OF-REPORT            THRU  2500-EXIT.       
                                                                        
           PERFORM 9000-TERMINATE                THRU  9000-EXIT.       
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE YYYYMMDD.                   
           MOVE WS-CY                     TO WS-RD-YY.                  
           MOVE WS-CM                     TO WS-RD-MM.                  
           MOVE WS-CD                     TO WS-RD-DD.                  
           MOVE WS-RUN-DATE               TO RPT-RUN-DATE               
                                             RPT-DATE.                  
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                     TO WS-RT-HH.                  
           MOVE WS-MM                     TO WS-RT-MM.                  
           MOVE WS-SS                     TO WS-RT-SS.                  
           MOVE WS-RUN-TIME               TO RPT-RUN-TIME               
                                             RPT-RUN-TIME3.             
      *                                                                         
           OPEN INPUT  SRTDA-FILE.                                      
           OPEN INPUT  SRTDB-FILE.                                      
           OPEN INPUT  SRTDC-FILE.                                      
           OPEN OUTPUT FCSPT33-FILE.                                    
           OPEN OUTPUT FCSPT331-FILE.                                   
           OPEN OUTPUT FCSPT332-FILE.                                   
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-SRTDA.                                          **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-SRTDA.                                              
      *                                                                         
           IF WS-FIRST-RPT1 EQUAL WS-YES                                
              MOVE SRTDA-REC              TO FIOBW03-BEGIN-REC          
              MOVE BW03-REV-DT-BREC       TO WS-REVENUE-MONTH           
              DISPLAY 'REVENUE MONTH = ' WS-REVENUE-MONTH               
      *                                                                         
              IF BW03-ACCTS-IND-BREC EQUAL WS-YES                       
                 MOVE 'FOR MAJOR ACCOUNTS ' TO RPT-DESC1                
              ELSE                                                      
                 MOVE 'FOR ALL  ACCOUNTS '  TO RPT-DESC1                
              END-IF                                                    
              MOVE 'IN CUSTOMER NAME ORDER' TO RPT-DESC2                
              PERFORM 2050-MTH-TABLE             THRU 2050-EXIT         
              MOVE WS-NO                  TO WS-FIRST-RPT1              
              PERFORM 7000-READ-SRTDA            THRU 7000-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE SRTDA-REC                 TO FIOBW03-REC.               
           MOVE WS-RPT1-NAME              TO WS-RPT-NAME.               
           MOVE WS-RPT1-AVG               TO WS-RPT-AVG.                
           MOVE WS-RPT1-REV               TO WS-RPT-REV.                
      *                                                                         
           PERFORM 2100-PROCESS-RECORDS          THRU 2100-EXIT.        
           PERFORM 2150A-WRITE-SRTDA-HEADER      THRU 2150A-EXIT.       
           PERFORM 2200A-WRITE-SRTDA-DETAIL      THRU 2200A-EXIT.       
           PERFORM 7000-READ-SRTDA               THRU 7000-EXIT.        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2050-MTH-TABLE                                               **        
      ******************************************************************        
      *                                                                         
       2050-MTH-TABLE.                                                  
      *                                                                         
           MOVE '12'                      TO WS-SUB.                    
           PERFORM UNTIL WS-SUB LESS THAN 1                             
              MOVE WS-REV-MM              TO WS-REV-MTH                 
                                             WS-EDT-MTH                 
              MOVE WS-REV-YY              TO WS-REV-YEAR                
                                             WS-EDT-YEAR                
              MOVE WS-MONTH-EDT           TO WS-MONTH(WS-SUB)           
              COMPUTE WS-REV-MM = WS-REV-MM - 1                         
              IF WS-REV-MM EQUAL ZEROES                                 
                 MOVE '12'                TO WS-REV-MM                  
                 COMPUTE WS-REV-YY = WS-REV-YY - 1                      
              END-IF                                                    
              COMPUTE WS-SUB = WS-SUB - 1                               
           END-PERFORM.                                                 
      *                                                                         
           MOVE WS-MONTH(1)               TO RPT-MONTH1.                
           MOVE WS-MONTH(2)               TO RPT-MONTH2.                
           MOVE WS-MONTH(3)               TO RPT-MONTH3.                
           MOVE WS-MONTH(4)               TO RPT-MONTH4.                
           MOVE WS-MONTH(5)               TO RPT-MONTH5.                
           MOVE WS-MONTH(6)               TO RPT-MONTH6.                
           MOVE WS-MONTH(7)               TO RPT-MONTH7.                
           MOVE WS-MONTH(8)               TO RPT-MONTH8.                
           MOVE WS-MONTH(9)               TO RPT-MONTH9.                
           MOVE WS-MONTH(10)              TO RPT-MONTH10.               
           MOVE WS-MONTH(11)              TO RPT-MONTH11.               
           MOVE WS-MONTH(12)              TO RPT-MONTH12.               
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************01922205
      *2100-PROCESS-RECORDS.                                           *01922305
      ******************************************************************01922405
      *                                                                         
       2100-PROCESS-RECORDS.                                            
      *                                                                         
            MOVE BW03-ACCOUNT-NO          TO WS-SAVE-ACCT.              
            MOVE WS-SAVE-ACCT1            TO WS-ACCT1.                  
            MOVE WS-SAVE-ACCT2            TO WS-ACCT2.                  
            MOVE WS-SAVE-ACCT3            TO WS-ACCT3.                  
            MOVE WS-SAVE-ACCT4            TO WS-ACCT4.                  
            MOVE WS-ACCOUNT1              TO RPT-ACCOUNT-NO.            
            MOVE BW03-LOCAL-OFFICE        TO RPT-LOCAL-OFFICE.          
            MOVE BW03-CUSTOMER-NAME       TO RPT-CUST-NAME.             
            MOVE BW03-TOTAL-USAGE-THERMS  TO WS-TOTAL-USAGE-THERMS.     
            MOVE WS-TOTAL-USAGE-THERMS    TO RPT-TOT-DT-CONS.           
            MOVE BW03-TOTAL-REV-AMT       TO WS-TOTAL-REV-AMT.          
            MOVE WS-TOTAL-REV-AMT         TO RPT-TOT-REV-AMT.           
            MOVE BW03-ZIP-CODE            TO RPT-ZIP-CODE.              
            MOVE BW03-SERVICE-ADDRESS     TO RPT-SERV-ADDR.             
            MOVE BW03-STATE-TAX-EXMPT-NO  TO RPT-STATE-TAX-EXMPT-NO.    
      *                                                                         
            EVALUATE BW03-CODE-ACCT-STAT                                
               WHEN 'A'                                                 
                    MOVE 'ACTIVE'         TO RPT-CODE-STAT              
               WHEN 'B'                                                 
                    MOVE 'FINALED'        TO RPT-CODE-STAT              
               WHEN 'J'                                                 
                    MOVE 'INACTIV'        TO RPT-CODE-STAT              
               WHEN 'P'                                                 
                    MOVE 'PENDING'        TO RPT-CODE-STAT              
               WHEN 'S'                                                 
                    MOVE 'WRT-OFF'        TO RPT-CODE-STAT              
               WHEN OTHER                                               
                    MOVE SPACES           TO RPT-CODE-STAT              
            END-EVALUATE.                                               
      *                                                                         
            MOVE BW03-CODE-SIC-NO         TO RPT-CODE-SIC.              
            MOVE BW03-ALTN-FUEL-CD        TO RPT-AFC.                   
            MOVE BW03-RATE-PLAN-NO(RATE-INDEX)                          
                                          TO RPT-RATE-PLAN.             
            MOVE BW03-CODE-REV-CLASS(RATE-INDEX)                        
                                          TO RPT-REV-CLASS.             
            MOVE WS-RPT-NAME              TO RPT-NAME.                  
            MOVE WS-RPT-AVG               TO RPT-AVG                    
            MOVE WS-RPT-REV               TO RPT-REV.                   
            MOVE '1'                      TO WS-COUNTER.                
      *                                                                         
            IF SRTDB-SUCCESSFUL                                         
               MOVE BW03-RATE-PLAN-NO(RATE-INDEX)                       
                                          TO RPT2-RATE-PLAN             
               MOVE BW03-CODE-REV-CLASS(RATE-INDEX)                     
                                          TO RPT2-REV-CLASS             
               MOVE BW03-ZIP-CODE         TO RPT2-ZIP-CODE              
               MOVE BW03-STATE-TAX-EXMPT-NO                             
                                          TO RPT2-STATE-TAX-EXMPT-NO    
            END-IF.                                                     
      *                                                                         
            IF SRTDC-SUCCESSFUL                                         
               MOVE BW03-RATE-PLAN-NO(RATE-INDEX)                       
                                          TO RPT3-RATE-PLAN             
               MOVE BW03-CODE-REV-CLASS(RATE-INDEX)                     
                                          TO RPT3-REV-CLASS             
               MOVE BW03-ZIP-CODE         TO RPT3-ZIP-CODE              
               MOVE BW03-STATE-TAX-EXMPT-NO                             
                                          TO RPT3-STATE-TAX-EXMPT-NO    
            END-IF.                                                     
                                                                        
            SET REV-MTH-INDEX  TO 1.                                    
            PERFORM VARYING REV-MTH-INDEX FROM 1 BY 1                   
                    UNTIL REV-MTH-INDEX GREATER THAN 12                 
               MOVE BW03-MTH-USAGE-THERMS(RATE-INDEX REV-MTH-INDEX)     
                                          TO WS-MTH-CONS(WS-COUNTER)    
               MOVE BW03-DAILY-AVG-THERMS(RATE-INDEX REV-MTH-INDEX)     
                                          TO WS-DLY-CONS(WS-COUNTER)    
               MOVE BW03-MTH-REV-AMOUNT(RATE-INDEX REV-MTH-INDEX)       
                                          TO WS-REV-AMT(WS-COUNTER)     
               COMPUTE WS-COUNTER =  WS-COUNTER + 1                     
            END-PERFORM.                                                
      *                                                                         
            MOVE WS-REV-AMT(1)            TO RPT-REV-AMT1.              
            MOVE WS-REV-AMT(2)            TO RPT-REV-AMT2.              
            MOVE WS-REV-AMT(3)            TO RPT-REV-AMT3.              
            MOVE WS-REV-AMT(4)            TO RPT-REV-AMT4.              
            MOVE WS-REV-AMT(5)            TO RPT-REV-AMT5.              
            MOVE WS-REV-AMT(6)            TO RPT-REV-AMT6.              
            MOVE WS-REV-AMT(7)            TO RPT-REV-AMT7.              
            MOVE WS-REV-AMT(8)            TO RPT-REV-AMT8.              
            MOVE WS-REV-AMT(9)            TO RPT-REV-AMT9.              
            MOVE WS-REV-AMT(10)           TO RPT-REV-AMT10.             
            MOVE WS-REV-AMT(11)           TO RPT-REV-AMT11.             
            MOVE WS-REV-AMT(12)           TO RPT-REV-AMT12.             
      *                                                                         
      *DAILY CONSUMPTION IS REQUIRED ONLY FOR RPT01.                            
            IF NOT END-OF-REC1                                          
               MOVE WS-DLY-CONS(1)        TO RPT-DLY-CONS1              
               MOVE WS-DLY-CONS(2)        TO RPT-DLY-CONS2              
               MOVE WS-DLY-CONS(3)        TO RPT-DLY-CONS3              
               MOVE WS-DLY-CONS(4)        TO RPT-DLY-CONS4              
               MOVE WS-DLY-CONS(5)        TO RPT-DLY-CONS5              
               MOVE WS-DLY-CONS(6)        TO RPT-DLY-CONS6              
               MOVE WS-DLY-CONS(7)        TO RPT-DLY-CONS7              
               MOVE WS-DLY-CONS(8)        TO RPT-DLY-CONS8              
               MOVE WS-DLY-CONS(9)        TO RPT-DLY-CONS9              
               MOVE WS-DLY-CONS(10)       TO RPT-DLY-CONS10             
               MOVE WS-DLY-CONS(11)       TO RPT-DLY-CONS11             
               MOVE WS-DLY-CONS(12)       TO RPT-DLY-CONS12             
            END-IF.                                                     
      *                                                                         
            MOVE WS-MTH-CONS(1)           TO RPT-MTH-CONS1.             
            MOVE WS-MTH-CONS(2)           TO RPT-MTH-CONS2.             
            MOVE WS-MTH-CONS(3)           TO RPT-MTH-CONS3.             
            MOVE WS-MTH-CONS(4)           TO RPT-MTH-CONS4.             
            MOVE WS-MTH-CONS(5)           TO RPT-MTH-CONS5.             
            MOVE WS-MTH-CONS(6)           TO RPT-MTH-CONS6.             
            MOVE WS-MTH-CONS(7)           TO RPT-MTH-CONS7.             
            MOVE WS-MTH-CONS(8)           TO RPT-MTH-CONS8.             
            MOVE WS-MTH-CONS(9)           TO RPT-MTH-CONS9.             
            MOVE WS-MTH-CONS(10)          TO RPT-MTH-CONS10.            
            MOVE WS-MTH-CONS(11)          TO RPT-MTH-CONS11.            
            MOVE WS-MTH-CONS(12)          TO RPT-MTH-CONS12.            
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2150A-WRITE-SRTDA-HEADER                                     **        
      ******************************************************************        
      *                                                                         
       2150A-WRITE-SRTDA-HEADER.                                        
      *                                                                         
           IF WS-HDR-EXIST1 EQUAL WS-YES      OR                        
              WS-LINE-COUNT1 GREATER THAN 48  OR                        
              WS-PREV-LOC-OFFICE1 NOT EQUAL BW03-LOCAL-OFFICE           
              MOVE ZEROES                 TO WS-LINE-COUNT1             
              IF WS-PREV-LOC-OFFICE1 NOT EQUAL BW03-LOCAL-OFFICE        
                 MOVE BW03-LOCAL-OFFICE   TO WS-PREV-LOC-OFFICE1        
                 MOVE WS-YES              TO WS-TRLR-REC1               
              END-IF                                                    
              IF WS-TRLR-REC1  EQUAL WS-YES AND                         
                 WS-HDR-EXIST1 EQUAL WS-NO                              
                 MOVE WS-RPT-TRAILER-1    TO PRT33-RECORD               
                 PERFORM 8000A-WRITE-PRT33       THRU 8000A-EXIT        
                 MOVE WS-RPT-TRAILER-2    TO PRT33-RECORD               
                 PERFORM 8000A-WRITE-PRT33       THRU 8000A-EXIT        
              END-IF                                                    
              MOVE WS-NO                  TO WS-TRLR-REC1               
              ADD +1                      TO WS-PAGE-NUM1               
              MOVE WS-PAGE-NUM1           TO RPT-PGNUM                  
              MOVE WS-NO                  TO WS-HDR-EXIST1              
              MOVE WS-RPT-HEADER-1        TO PRT33-RECORD               
              PERFORM 8100A-WRITE-PRT33          THRU 8100A-EXIT        
              MOVE WS-RPT-HEADER-2        TO PRT33-RECORD               
              PERFORM 8000A-WRITE-PRT33          THRU 8000A-EXIT        
              MOVE WS-RPT-HEADER-3        TO PRT33-RECORD               
              PERFORM 8000A-WRITE-PRT33          THRU 8000A-EXIT        
              MOVE WS-RPT-HEADER-4        TO PRT33-RECORD               
              PERFORM 8000A-WRITE-PRT33          THRU 8000A-EXIT        
              MOVE WS-RPT-HEADER-5        TO PRT33-RECORD               
              PERFORM 8000A-WRITE-PRT33          THRU 8000A-EXIT        
              MOVE WS-RPT-HEADER-6        TO PRT33-RECORD               
              PERFORM 8000A-WRITE-PRT33          THRU 8000A-EXIT        
              MOVE WS-RPT-HEADER-7        TO PRT33-RECORD               
              PERFORM 8000A-WRITE-PRT33          THRU 8000A-EXIT        
              MOVE WS-RPT-HEADER-4        TO PRT33-RECORD               
              PERFORM 8200A-WRITE-PRT33          THRU 8200A-EXIT        
           END-IF.                                                      
      *                                                                         
       2150A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2150B-WRITE-SRTDB-HEADER.                                    **        
      ******************************************************************        
      *                                                                         
       2150B-WRITE-SRTDB-HEADER.                                        
      *                                                                         
           IF WS-HDR-EXIST2 EQUAL WS-YES      OR                        
              WS-LINE-COUNT2 GREATER THAN 52  OR                        
              WS-PREV-LOC-OFFICE2 NOT EQUAL BW03-LOCAL-OFFICE           
              MOVE ZEROES                 TO WS-LINE-COUNT2             
              IF WS-PREV-LOC-OFFICE2 NOT EQUAL BW03-LOCAL-OFFICE        
                 MOVE BW03-LOCAL-OFFICE   TO WS-PREV-LOC-OFFICE2        
                 MOVE WS-YES              TO WS-TRLR-REC2               
              END-IF                                                    
              IF WS-TRLR-REC2  EQUAL WS-YES AND                         
                 WS-HDR-EXIST2 EQUAL WS-NO                              
                 MOVE WS-RPT-TRAILER-1    TO PRT331-RECORD              
                 PERFORM 8000B-WRITE-PRT331      THRU 8000B-EXIT        
                 MOVE WS-RPT-TRAILER-2    TO PRT331-RECORD              
                 PERFORM 8000B-WRITE-PRT331      THRU 8000B-EXIT        
              END-IF                                                    
              MOVE WS-NO                  TO WS-TRLR-REC2               
              ADD +1                      TO WS-PAGE-NUM2               
              MOVE WS-PAGE-NUM2           TO RPT-PGNUM                  
              MOVE WS-NO                  TO WS-HDR-EXIST2              
              MOVE WS-RPT-HEADER-1        TO PRT331-RECORD              
              PERFORM 8100B-WRITE-PRT331         THRU 8100B-EXIT        
              MOVE WS-RPT-HEADER-2        TO PRT331-RECORD              
              PERFORM 8000B-WRITE-PRT331         THRU 8000B-EXIT        
              MOVE WS-RPT-HEADER-3        TO PRT331-RECORD              
              PERFORM 8000B-WRITE-PRT331         THRU 8000B-EXIT        
              MOVE WS-RPT-HEADER-4        TO PRT331-RECORD              
              PERFORM 8000B-WRITE-PRT331         THRU 8000B-EXIT        
              MOVE WS-RPT-HEADER-5        TO PRT331-RECORD              
              PERFORM 8000B-WRITE-PRT331         THRU 8000B-EXIT        
              MOVE WS-RPT-HEADER-6        TO PRT331-RECORD              
              PERFORM 8000B-WRITE-PRT331         THRU 8000B-EXIT        
              MOVE WS-RPT-HEADER-7        TO PRT331-RECORD              
              PERFORM 8000B-WRITE-PRT331         THRU 8000B-EXIT        
              MOVE WS-RPT-HEADER-4        TO PRT331-RECORD              
              PERFORM 8200B-WRITE-PRT331         THRU 8200B-EXIT        
           END-IF.                                                      
      *                                                                         
       2150B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2150C-WRITE-SRTDC-HEADER.                                    **        
      ******************************************************************        
      *                                                                         
       2150C-WRITE-SRTDC-HEADER.                                        
      *                                                                         
           IF WS-HDR-EXIST3 EQUAL WS-YES     OR                         
              WS-LINE-COUNT3 GREATER THAN 48                            
              MOVE ZEROES                 TO WS-LINE-COUNT3             
              ADD +1                      TO WS-PAGE-NUM3               
              MOVE WS-PAGE-NUM3           TO RPT-PGNUM                  
              MOVE WS-NO                  TO WS-HDR-EXIST3              
              MOVE WS-RPT-HEADER-1        TO PRT332-RECORD              
              PERFORM 8100C-WRITE-PRT332         THRU 8100C-EXIT        
              MOVE WS-RPT-HEADER-2        TO PRT332-RECORD              
              PERFORM 8000C-WRITE-PRT332         THRU 8000C-EXIT        
              MOVE WS-RPT-HEADER-14       TO PRT332-RECORD              
              PERFORM 8000C-WRITE-PRT332         THRU 8000C-EXIT        
              MOVE WS-RPT-HEADER-4        TO PRT332-RECORD              
              PERFORM 8000C-WRITE-PRT332         THRU 8000C-EXIT        
              MOVE WS-RPT-HEADER-5        TO PRT332-RECORD              
              PERFORM 8000C-WRITE-PRT332         THRU 8000C-EXIT        
              MOVE WS-RPT-HEADER-6        TO PRT332-RECORD              
              PERFORM 8000C-WRITE-PRT332         THRU 8000C-EXIT        
              MOVE WS-RPT-HEADER-7        TO PRT332-RECORD              
              PERFORM 8000C-WRITE-PRT332         THRU 8000C-EXIT        
              MOVE WS-RPT-HEADER-4        TO PRT332-RECORD              
              PERFORM 8200C-WRITE-PRT332         THRU 8200C-EXIT        
           END-IF.                                                      
      *                                                                         
       2150C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2200A-WRITE-SRTDA-DETAIL.                                    **        
      ******************************************************************        
      *                                                                         
       2200A-WRITE-SRTDA-DETAIL.                                        
      *                                                                         
           MOVE WS-RPT-HEADER-8           TO PRT33-RECORD.              
           PERFORM 8000A-WRITE-PRT33             THRU 8000A-EXIT.       
           MOVE WS-RPT-HEADER-9           TO PRT33-RECORD.              
           PERFORM 8000A-WRITE-PRT33             THRU 8000A-EXIT.       
           MOVE WS-RPT-HEADER-10          TO PRT33-RECORD.              
           PERFORM 8000A-WRITE-PRT33             THRU 8000A-EXIT.       
           MOVE WS-RPT-HEADER-11          TO PRT33-RECORD.              
           PERFORM 8000A-WRITE-PRT33             THRU 8000A-EXIT.       
      *                                                                         
       2200A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2200B-WRITE-SRTDB-DETAIL.                                    **        
      ******************************************************************        
      *                                                                         
       2200B-WRITE-SRTDB-DETAIL.                                        
      *                                                                         
           IF RPT-ACCOUNT-NO NOT EQUAL WS-PREV-ACCOUNT-NO               
              MOVE RPT-ACCOUNT-NO         TO WS-PREV-ACCOUNT-NO         
           ELSE                                                         
              MOVE SPACES                 TO RPT-ACCOUNT-NO             
           END-IF.                                                      
           MOVE WS-RPT-HEADER-8           TO PRT331-RECORD.             
           PERFORM 8000B-WRITE-PRT331            THRU 8000B-EXIT.       
           MOVE WS-RPT-HEADER-12          TO PRT331-RECORD.             
           PERFORM 8000B-WRITE-PRT331            THRU 8000B-EXIT.       
           MOVE WS-RPT-HEADER-10          TO PRT331-RECORD.             
           PERFORM 8000B-WRITE-PRT331            THRU 8000B-EXIT.       
           MOVE WS-RPT-HEADER-11          TO PRT331-RECORD.             
           PERFORM 8000B-WRITE-PRT331            THRU 8000B-EXIT.       
      *                                                                         
       2200B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2200C-WRITE-SRTDC-DETAIL.                                    **        
      ******************************************************************        
      *                                                                         
       2200C-WRITE-SRTDC-DETAIL.                                        
      *                                                                         
           MOVE WS-RPT-HEADER-8           TO PRT332-RECORD.             
           PERFORM 8000C-WRITE-PRT332            THRU 8000C-EXIT.       
           MOVE WS-RPT-HEADER-13          TO PRT332-RECORD.             
           PERFORM 8000C-WRITE-PRT332            THRU 8000C-EXIT.       
           MOVE WS-RPT-HEADER-10          TO PRT332-RECORD.             
           PERFORM 8000C-WRITE-PRT332            THRU 8000C-EXIT.       
           MOVE WS-RPT-HEADER-11          TO PRT332-RECORD.             
           PERFORM 8000C-WRITE-PRT332            THRU 8000C-EXIT.       
      *                                                                         
       2200C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2300-PROCESS-SRTDB.                                          **        
      ******************************************************************        
      *                                                                         
       2300-PROCESS-SRTDB.                                              
      *                                                                         
           IF WS-FIRST-RPT2 EQUAL WS-YES                                
              MOVE SRTDB-REC              TO FIOBW03-BEGIN-REC          
              MOVE BW03-REV-DT-BREC       TO WS-REVENUE-MONTH           
              IF BW03-ACCTS-IND-BREC EQUAL WS-YES                       
                 MOVE 'FOR MAJOR ACCOUNTS '                             
                                          TO RPT-DESC1                  
              ELSE                                                      
                 MOVE 'FOR ALL  ACCOUNTS '                              
                                          TO RPT-DESC1                  
              END-IF                                                    
              MOVE 'IN DESCENDING USAGE ORDER'                          
                                          TO RPT-DESC2                  
              PERFORM 2050-MTH-TABLE             THRU 2050-EXIT         
              MOVE WS-NO                  TO WS-FIRST-RPT2              
              PERFORM 7100-READ-SRTDB            THRU 7100-EXIT         
           END-IF.                                                      
           MOVE SRTDB-REC                 TO FIOBW03-REC.               
           MOVE WS-RPT2-NAME              TO WS-RPT-NAME.               
           MOVE WS-RPT2-AVG               TO WS-RPT-AVG.                
           MOVE WS-RPT2-REV               TO WS-RPT-REV.                
           MOVE SPACES                    TO RPT-LINE2.                 
           PERFORM 2100-PROCESS-RECORDS          THRU 2100-EXIT.        
           PERFORM 2150B-WRITE-SRTDB-HEADER      THRU 2150B-EXIT.       
           PERFORM 2200B-WRITE-SRTDB-DETAIL      THRU 2200B-EXIT.       
           PERFORM 7100-READ-SRTDB               THRU 7100-EXIT.        
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2400-PROCESS-SRTDC.                                        **          
      ******************************************************************        
      *                                                                         
       2400-PROCESS-SRTDC.                                              
      *                                                                         
           IF WS-FIRST-RPT3 EQUAL WS-YES                                
              MOVE SRTDC-REC              TO FIOBW03-BEGIN-REC          
              MOVE BW03-REV-DT-BREC       TO WS-REVENUE-MONTH           
              IF BW03-ACCTS-IND-BREC EQUAL WS-YES                       
                 MOVE 'FOR MAJOR ACCOUNTS '                             
                                          TO RPT-DESC1                  
              ELSE                                                      
                 MOVE 'FOR ALL  ACCOUNTS '                              
                                          TO RPT-DESC1                  
              END-IF                                                    
              MOVE 'IN DESCENDING USAGE ORDER - TOTAL COMPANY'          
                                          TO RPT-DESC2                  
              MOVE WS-NO                  TO WS-FIRST-RPT3              
              PERFORM 7200-READ-SRTDC   THRU 7200-EXIT                  
           END-IF.                                                      
      *                                                                         
           MOVE SRTDC-REC                 TO FIOBW03-REC.               
      *                                                                         
           SET RATE-INDEX TO 1.                                         
           PERFORM VARYING RATE-INDEX FROM 1 BY 1                       
                     UNTIL RATE-INDEX GREATER THAN 1                    
           IF BW03-RATE-PLAN-NO(RATE-INDEX) EQUAL                       
              ('145' OR '150' OR '160' OR '175' OR '180' OR '200'       
                                                OR '201' OR '202')      
              MOVE WS-RPT3-NAME           TO WS-RPT-NAME                
              MOVE WS-RPT2-AVG            TO WS-RPT-AVG                 
              MOVE WS-RPT2-REV            TO WS-RPT-REV                 
              MOVE SPACES                 TO RPT-LINE2                  
              PERFORM 2100-PROCESS-RECORDS       THRU 2100-EXIT         
              IF BW03-RATE-PLAN-NO(RATE-INDEX) EQUAL ('145' OR '175')   
                 MOVE '145'               TO RPT3-RATE-PLAN             
              ELSE                                                      
                 IF BW03-RATE-PLAN-NO(RATE-INDEX) EQUAL                 
                              ('150' OR '160' OR '180')                 
                    MOVE '150'            TO RPT3-RATE-PLAN             
                 END-IF                                                 
              END-IF                                                    
              PERFORM 2150C-WRITE-SRTDC-HEADER   THRU 2150C-EXIT        
              PERFORM 2200C-WRITE-SRTDC-DETAIL   THRU 2200C-EXIT        
           END-IF                                                       
           END-PERFORM.                                                 
           PERFORM 7200-READ-SRTDC               THRU 7200-EXIT.        
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2500-END-OF-REPORT.                                        **          
      ******************************************************************        
      *                                                                         
       2500-END-OF-REPORT.                                              
      *                                                                         
           MOVE WS-RPT-TRAILER-1          TO PRT33-RECORD               
                                             PRT331-RECORD              
                                             PRT332-RECORD.             
           PERFORM 8000A-WRITE-PRT33             THRU 8000A-EXIT.       
           PERFORM 8000B-WRITE-PRT331            THRU 8000B-EXIT.       
           PERFORM 8000C-WRITE-PRT332            THRU 8000C-EXIT.       
      *                                                                         
           MOVE WS-RPT-TRAILER-2          TO PRT33-RECORD               
                                             PRT331-RECORD              
                                             PRT332-RECORD.             
           PERFORM 8000A-WRITE-PRT33             THRU 8000A-EXIT.       
           PERFORM 8000B-WRITE-PRT331            THRU 8000B-EXIT.       
           PERFORM 8000C-WRITE-PRT332            THRU 8000C-EXIT.       
      *                                                                         
           MOVE WS-RPT-HEADER-4           TO PRT33-RECORD               
                                             PRT331-RECORD              
                                             PRT332-RECORD.             
           PERFORM 8000A-WRITE-PRT33             THRU 8000A-EXIT.       
           PERFORM 8000B-WRITE-PRT331            THRU 8000B-EXIT.       
           PERFORM 8000C-WRITE-PRT332            THRU 8000C-EXIT.       
      *                                                                         
           MOVE WS-END-DATA               TO PRT33-RECORD               
                                             PRT331-RECORD              
                                             PRT332-RECORD.             
           PERFORM 8000A-WRITE-PRT33             THRU 8000A-EXIT.       
           PERFORM 8000B-WRITE-PRT331            THRU 8000B-EXIT.       
           PERFORM 8000C-WRITE-PRT332            THRU 8000C-EXIT.       
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  READ INFILE FILE FOR INPUT                                    *        
      *  7000-READ-SRTDA.                                              *        
      ******************************************************************        
      *                                                                         
       7000-READ-SRTDA.                                                 
      *                                                                         
           READ SRTDA-FILE.                                             
                                                                        
           IF SRTDA-SUCCESSFUL  OR  END-OF-REC1                         
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSRP008 ABORT *********'          
               DISPLAY '** ERROR IN READING SRTDA        ****'          
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS ' WS-SRTDA-STATUS             
               DISPLAY '**  PROCESSING TERMINATED          **'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7100-READ-SRTDB.                                            *          
      ******************************************************************        
      *                                                                         
       7100-READ-SRTDB.                                                 
      *                                                                         
           READ SRTDB-FILE.                                             
                                                                        
           IF SRTDB-SUCCESSFUL  OR  END-OF-REC2                         
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSRP008 ABORT *********'          
               DISPLAY '** ERROR IN READING SRTDB        ****'          
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS ' WS-SRTDB-STATUS             
               DISPLAY '**  PROCESSING TERMINATED          **'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  READ SRTDC FILE FOR INPUT                                     *        
      ******************************************************************        
      *                                                                         
       7200-READ-SRTDC.                                                 
      *                                                                         
           READ SRTDC-FILE.                                             
                                                                        
           IF SRTDC-SUCCESSFUL  OR  END-OF-REC3                         
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSRP008 ABORT *********'          
               DISPLAY '** ERROR IN READING SRTDC        ****'          
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS ' WS-SRTDC-STATUS             
               DISPLAY '**  PROCESSING TERMINATED          **'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000A-WRITE-PRT33                                            **        
      ******************************************************************        
      *                                                                         
       8000A-WRITE-PRT33.                                               
      *                                                                         
           WRITE PRT33-RECORD.                                          
           ADD +1                         TO WS-LINE-COUNT1.            
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100A-WRITE-PRT33.                                         **          
      ******************************************************************        
      *                                                                         
       8100A-WRITE-PRT33.                                               
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
           ADD +1                         TO WS-LINE-COUNT1.            
      *                                                                         
       8100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8200A-WRITE-PRT33                                            **        
      ******************************************************************        
      *                                                                         
       8200A-WRITE-PRT33.                                               
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING 3 LINES.                  
           ADD +1                         TO WS-LINE-COUNT1.            
      *                                                                         
       8200A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000B-WRITE-PRT331.                                          **        
      ******************************************************************        
      *                                                                         
       8000B-WRITE-PRT331.                                              
      *                                                                         
           WRITE PRT331-RECORD.                                         
           ADD +1                         TO WS-LINE-COUNT2.            
      *                                                                         
       8000B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100B-WRITE-PRT331.                                          **        
      ******************************************************************        
      *                                                                         
       8100B-WRITE-PRT331.                                              
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING PAGE.                    
           ADD +1                         TO WS-LINE-COUNT2.            
      *                                                                         
       8100B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8200B-WRITE-PRT331                                           **        
      ******************************************************************        
      *                                                                         
       8200B-WRITE-PRT331.                                              
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING 3 LINES.                 
           ADD +1                         TO WS-LINE-COUNT2.            
      *                                                                         
       8200B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000C-WRITE-PRT332                                           **        
      ******************************************************************        
      *                                                                         
       8000C-WRITE-PRT332.                                              
      *                                                                         
           WRITE PRT332-RECORD.                                         
           ADD +1                         TO WS-LINE-COUNT3.            
      *                                                                         
       8000C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100C-WRITE-PRT332.                                          **        
      ******************************************************************        
      *                                                                         
       8100C-WRITE-PRT332.                                              
      *                                                                         
           WRITE PRT332-RECORD AFTER ADVANCING PAGE.                    
           ADD +1                         TO WS-LINE-COUNT3.            
      *                                                                         
       8100C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8200C-WRITE-PRT332                                           **        
      ******************************************************************        
      *                                                                         
       8200C-WRITE-PRT332.                                              
      *                                                                         
           WRITE PRT332-RECORD AFTER ADVANCING 3 LINES.                 
           ADD +1                         TO WS-LINE-COUNT3.            
      *                                                                         
       8200C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 9000-CLOSE-FILES.                                            *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE SRTDA-FILE.                                            
           CLOSE SRTDB-FILE.                                            
           CLOSE SRTDC-FILE.                                            
           CLOSE FCSPT33-FILE.                                          
           CLOSE FCSPT331-FILE.                                         
           CLOSE FCSPT332-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
