       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP004.                                        
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  --------  --------     ----------------------------------  **         
      **  08/04/08  RV           INITIAL VERSION                                
A02034**  10/25/10  BD09555      CORRECT FACSIMILE FORM NUMBER                  
P00599**  09/10/12  SV           CIS MODERNIZATION CREDIT SIMPLIFICATION        
      *****************************************************************         
                                                                        
      *****************************************************************         
      **                     PCSRP004 NARRATIVE                      **         
      **                                                             **         
      **  THIS PROGRAM GENERATES THE CERTIFICATE OF MAILING FOR      **         
      **  FINAL NOTICES.                                             **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
P00599     COPY CSSKR150.                                                       
      *                                                                         
           COPY CSSPT33.                                                        
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
P00599    COPY CFDKR150.                                                        
P00599 01   EXTKR150                     PIC X(1375).                   
                                                                        
          COPY CFDPT33.                                                         
      *                                                                         
       WORKING-STORAGE SECTION.                                         
      *                                                                         
       01  WS-MISC.                                                     
P00599     05  WS-FCSKR150-STATUS            PIC X(02).                 
P00599         88  FKR150-SUCCESSFUL                   VALUE '00'.      
           05  WS-FCA32-STATUS               PIC XX    VALUE '00'.      
               88  FCA32-SUCCESSFUL                    VALUE '00'.      
           05  WS-HOLD-ACCOUNT-NBR.                                     
               10 WS-FIRST                   PIC X(1).                  
               10 WS-SECOND-FOUR             PIC X(4).                  
               10 WS-THIRD-FOUR              PIC X(4).                  
               10 WS-FOURTH-FOUR             PIC X(4).                  
                                                                        
           05  SUB1                          PIC S9(7) COMP-3 VALUE +0. 
                                                                        
           05  P-RUN-DATE                    PIC X(10).                 
                                                                        
           05  WS-RPT1-HEAD                  PIC X(50) VALUE            
               '             CERTIFICATE OF MAILING               '.    
           05  WS-RPT1-SCEG-TITLE            PIC X(50)     VALUE        
               '         SOUTH CAROLINA ELECTRIC AND GAS          '.    
           05  WS-RPT1-PSNC-TITLE            PIC X(50)     VALUE        
               '                   PSNC ENERGY                    '.    
           05  WS-RPT1-SEB-TITLE             PIC X(50)     VALUE        
               '                   SCANA ENERGY                   '.    
           05  WS-RPT1-SEBR-TITLE            PIC X(50)     VALUE        
               '          SCANA ENERGY REGULATED DIVISION         '.    
           05  WS-RPT1-TAIL1                 PIC X(33) VALUE            
               'TOTAL NUMBER OF NOTICES MAILED: '.                      
           05  WS-RPT1-TAIL2                 PIC X(60) VALUE            
A02034         'CERTIFICATE OF MAILING POST OFFICE FORM 3606 FACSIMILE'.
                                                                        
                                                                        
           05  WS-CURRENT-DATE.                                         
               10  WS-CURRENT-CCYY         PIC 9(04).                   
               10  WS-CURRENT-MM           PIC 9(02).                   
               10  WS-CURRENT-DD           PIC 9(02).                   
               10  WS-CURRENT-HH           PIC 9(02).                   
               10  WS-CURRENT-MS           PIC 9(02).                   
               10  WS-CURRENT-SS           PIC 9(02).                   
                                                                        
           05  WS-NOTICE-COUNT              PIC  9(06)        VALUE 0.  
           05  WS-PAGE-NO                   PIC  9(05)        VALUE 0.  
           05  WS-LINE-COUNT                PIC S9(03) COMP-3 VALUE +99.
                                                                        
           05  WS-FORMAT-DATE.                                          
               10  WS-FORMAT-MONTH           PIC XX.                    
               10  FILLER                    PIC X   VALUE '-'.         
               10  WS-FORMAT-DAY             PIC XX.                    
               10  FILLER                    PIC X   VALUE '-'.         
               10  WS-FORMAT-YEAR            PIC X(4).                  
                                                                        
           05  WS-TODAYS-DATE                PIC 9(08)    VALUE  0.     
           05  WS-TIME-OF-DAY                PIC 9(08)    VALUE  0.     
           05  WS-RUN-DATE                   PIC X(10).                 
           05  WS-SYS-DATE                   PIC 9(06) VALUE ZEROES.    
           05  FILLER                  REDEFINES                        
               WS-SYS-DATE.                                             
               10  WS-SYS-DATE-YY            PIC 9(02).                 
               10  WS-SYS-DATE-MM            PIC 9(02).                 
               10  WS-SYS-DATE-DD            PIC 9(02).                 
           05  WS-SYSTEM-DATE.                                          
               10  WS-SYST-YY                PIC 99.                    
               10  WS-SYST-MM                PIC 99.                    
               10  WS-SYST-DD                PIC 99.                    
               10  F                         PIC XX VALUE SPACES.       
           05  WS-SYSTEM-TIME.                                          
               10  WS-SYSTEM-HH              PIC 99.                    
               10  WS-SYSTEM-MM              PIC 99.                    
               10  WS-SYSTEM-SS              PIC 99.                    
               10  F                         PIC XX VALUE SPACES.       
           05  WS-RUN-TIME.                                             
               10  WS-RUN-HH                 PIC 99.                    
               10  F                         PIC X VALUE ':'.           
               10  WS-RUN-MM                 PIC 99.                    
               10  F                         PIC X VALUE ':'.           
               10  WS-RUN-SS                 PIC 99.                    
                                                                        
       01  WS-SWITCHES.                                                 
P00599     05  WS-END-OF-FKR150               PIC X VALUE 'N'.          
P00599         88  END-OF-FKR150              VALUE 'Y'.                
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME              PIC X(12)  VALUE 'PCSRP004-001'.
           05  WS-Y                     PIC X(01)  VALUE 'Y'.           
           05  WS-43-TBL.                                               
               10 WS-43          PIC X(01)  VALUE '_' OCCURS 43 TIMES.  
           05  WS-15-TBL.                                               
               10 WS-15          PIC X(01)  VALUE '_' OCCURS 15 TIMES.  
                                                                        
       01  P-HEADER-LINE-1.                                             
           05  FILLER                   PIC X(03)  VALUE SPACES.        
           05  FILLER                   PIC X(07)  VALUE 'DATE: '.      
           05  P-REPORT-DATE            PIC X(10).                      
           05  FILLER                   PIC X(03)  VALUE SPACES.        
           05  FILLER                   PIC X(11)  VALUE 'RUN TIME:  '. 
           05  P-RUN-TIME               PIC X(08).                      
           05  P-RPT1-TITLE             PIC X(50).                      
           05  FILLER                   PIC X(26)  VALUE SPACES.        
           05  FILLER                   PIC X(09)  VALUE 'PAGE:    '.   
           05  P-PAGE-NO                PIC ZZZZ9.                      
                                                                        
       01  P-HEADER-LINE-2.                                             
           05  FILLER                   PIC X(02)  VALUE SPACES.        
           05  P-RPT1-NAME              PIC X(12).                      
           05  FILLER                   PIC X(30) VALUE SPACES.         
           05  P-RPT1-HEAD              PIC X(50).                      
           05  FILLER                   PIC X(38) VALUE SPACES.         
                                                                        
       01  P-HEADER-LINE-3.                                             
           05  FILLER                     PIC X(44) VALUE SPACES.       
           05  FILLER                     PIC X(06) VALUE 'ZIP CD'.     
           05  FILLER                     PIC X(05) VALUE SPACES.       
           05  FILLER                     PIC X(11) VALUE 'ACCOUNT NBR'.
           05  FILLER                     PIC X(11) VALUE SPACES.       
           05  FILLER                     PIC X(07) VALUE 'ADDRESS'.    
           05  FILLER                     PIC X(49) VALUE SPACES.       
                                                                        
       01  P-DETAIL-LINE-1.                                             
           05  FILLER                      PIC X(44)   VALUE SPACE.     
           05  WS-ZIPCD                    PIC X(05).                   
           05  FILLER                      PIC X(03)  VALUE SPACE.      
           05  WS-ACCOUNT-NBR              PIC X(16).                   
           05  FILLER                      PIC X(04)  VALUE SPACES.     
           05  WS-ADDR-LINE1               PIC X(50).                   
           05  FILLER                      PIC X(10)  VALUE SPACES.     
                                                                        
       01  P-DETAIL-LINE-2N.                                            
           05  FILLER                      PIC X(72)  VALUE SPACES.     
           05  WS-ADDR-LINE2N              PIC X(50).                   
           05  FILLER                      PIC X(10)  VALUE SPACES.     
                                                                        
       01  P-FOOT-LINE-1.                                               
           05  WS-TAIL1-HEAD            PIC X(33).                      
           05  WS-TAIL1-COUNT           PIC Z,ZZ,ZZ9.                   
           05  FILLER                   PIC X(91)    VALUE SPACES.      
                                                                        
       01  P-FOOT-LINE-2.                                               
           05  WS-TAIL2-HEAD            PIC X(60).                      
           05  FILLER                   PIC X(72)    VALUE SPACES.      
                                                                        
       01  P-FOOT-LINE-3.                                               
           05  FILLER                   PIC X(10)    VALUE 'SIGNATURE:'.
           05  FILLER                   PIC X(1)     VALUE SPACES.      
           05  PR-43                    PIC X(43).                      
           05  FILLER                   PIC X(5)     VALUE SPACES.      
           05  FILLER                   PIC X(10)    VALUE 'RECEIVED: '.
           05  PR-15                    PIC X(15).                      
           05  FILLER                   PIC X(48)    VALUE SPACES.      
      *                                                                         
P00599 COPY FIOCOKEY.                                                           
P00599 COPY FIOCOINF.                                                           
P00599*                                                                         
       LINKAGE SECTION.                                                 
       01  PARM.                                                        
           05 LNGTH                        PIC S9(04) COMP.             
           05 WS-COMPANY                   PIC X(04).                   
      *                                                                         
       PROCEDURE DIVISION USING PARM.                                   
      *                                                                         
      ***************************************************************** 00065400
      *    0000-MAINLINE                                             ** 00065500
      *    PERFORM INITIALIZATION TO OPEN FILES/INIT CWS10000 ETC    ** 00065600
      ***************************************************************** 00065700
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION      THRU 0100-EXIT.             
           PERFORM 1000-PROCESSING          THRU 1000-EXIT              
P00599                                      UNTIL END-OF-FKR150.        
           PERFORM 9000-TERMINATE           THRU 9000-EXIT.             
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  GET DATES, TIMES, TITLES FOR REPORT HEADERS.                 *         
      *****************************************************************         
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE FUNCTION CURRENT-DATE(1:14)                             
                                       TO WS-CURRENT-DATE.              
           STRING    WS-CURRENT-MM                                      
                     '-'                                                
                     WS-CURRENT-DD                                      
                     '-'                                                
                     WS-CURRENT-CCYY                                    
                     DELIMITED BY SIZE                                  
                                       INTO P-RUN-DATE.                 
           MOVE P-RUN-DATE             TO P-REPORT-DATE.                
                                                                        
           STRING    WS-CURRENT-HH                                      
                     ':'                                                
                     WS-CURRENT-MS                                      
                     ':'                                                
                     WS-CURRENT-SS                                      
                     DELIMITED BY SIZE                                  
                                       INTO P-RUN-TIME.                 
      *                                                                         
           EVALUATE WS-COMPANY                                          
              WHEN 'SCEG'                                               
              MOVE WS-RPT1-SCEG-TITLE   TO P-RPT1-TITLE                 
              WHEN 'PSNC'                                               
              MOVE WS-RPT1-PSNC-TITLE   TO P-RPT1-TITLE                 
              WHEN 'SEB '                                               
              MOVE WS-RPT1-SEB-TITLE    TO P-RPT1-TITLE                 
              WHEN 'SEBR'                                               
              MOVE WS-RPT1-SEBR-TITLE   TO P-RPT1-TITLE                 
              WHEN OTHER                                                
              DISPLAY WS-COMPANY                                        
           END-EVALUATE.                                                
      *                                                                         
           MOVE WS-PGRMNAME           TO P-RPT1-NAME.                   
           MOVE WS-RPT1-HEAD          TO P-RPT1-HEAD.                   
           MOVE WS-RPT1-TAIL1         TO WS-TAIL1-HEAD.                 
           MOVE WS-RPT1-TAIL2         TO WS-TAIL2-HEAD.                 
           MOVE WS-43-TBL             TO PR-43.                         
           MOVE WS-15-TBL             TO PR-15.                         
      *                                                                         
P00599     OPEN INPUT  FCSKR150-FILE.                                   
P00599     IF WS-FCSKR150-STATUS NOT = '00'                             
               DISPLAY '**************************************'         
               DISPLAY '**   ERROR OPENING REGULAR FILE'                
P00599         DISPLAY '**   FILE STATUS = ' WS-FCSKR150-STATUS         
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
           IF NOT FCA32-SUCCESSFUL                                      
               DISPLAY '**************************************'         
               DISPLAY '**   ERROR OPENING REPORT FILE'                 
               DISPLAY '**   FILE STATUS = ' WS-FCA32-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * MAIN PROCESSING MODULE                                         *        
      ******************************************************************        
       1000-PROCESSING.                                                 
      *                                                                         
P00599     INITIALIZE EXTCOKEY                                          
P00599                WS-EXT-MAILING-DTL.                               
P00599     PERFORM 7000-READ-FCSKR150 THRU 7000-EXIT.                   
      *                                                                         
P00599     IF NOT END-OF-FKR150                                         
P00599        MOVE EXTKR150                       TO EXTCOKEY           
P00599        MOVE WS-EXT-CORR-DATA               TO WS-EXT-MAILING-DTL 
              ADD  +1                             TO WS-NOTICE-COUNT    
P00599        MOVE WS-EXT-BARCODE-ZIP (1:5)       TO WS-ZIPCD           
P00599        MOVE WS-EXT-KEY-ACCOUNT-NO          TO WS-HOLD-ACCOUNT-NBR
              STRING     WS-FIRST                                       
                         '-'                                            
                         WS-SECOND-FOUR                                 
                         '-'                                            
                         WS-THIRD-FOUR                                  
                         '-'                                            
                         WS-FOURTH-FOUR                                 
                         DELIMITED BY SIZE                              
                                                INTO WS-ACCOUNT-NBR     
P00599        MOVE WS-EXT-MAILING-ADDR(1)         TO WS-ADDR-LINE1      
              PERFORM 8100-WRITE-DETAIL-LINE1   THRU 8100-EXIT          
              PERFORM VARYING SUB1 FROM 2 BY 1 UNTIL SUB1 > 6           
P00599                IF WS-EXT-MAILING-ADDR(SUB1) > ' '                
P00599                   MOVE WS-EXT-MAILING-ADDR(SUB1)       TO        
                                                         WS-ADDR-LINE2N 
                      PERFORM 8200-WRITE-DETAIL-LINE2N  THRU 8200-EXIT  
                      END-IF                                            
              END-PERFORM                                               
           ELSE                                                         
              PERFORM 8300-WRITE-FOOTER        THRU 8300-EXIT           
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *  READS THE INPUT FILE.                                   *              
      ************************************************************              
P00599 7000-READ-FCSKR150.                                              
      *                                                                         
P00599     READ FCSKR150-FILE AT END                                    
P00599          MOVE WS-Y TO WS-END-OF-FKR150.                          
P00599     IF FKR150-SUCCESSFUL OR END-OF-FKR150                        
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP004 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING REGULAR FILE   **'       
P00599         DISPLAY '**     FILE STATUS = ' WS-FCSKR150-STATUS       
               DISPLAY '****************************************'       
               PERFORM 9000-TERMINATE THRU 9000-EXIT                    
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
     *****************************************************************          
     ** THIS ROUTINE PRINTS THE TOTAL HEADER ON EACH PHYSICAL PAGE  **          
     *****************************************************************          
       8000-WRITE-HEADER.                                               
      *                                                                         
           ADD   1                         TO WS-PAGE-NO                
           MOVE  WS-PAGE-NO                TO P-PAGE-NO.                
           WRITE PRT33-RECORD            FROM P-HEADER-LINE-1           
                                        AFTER ADVANCING PAGE.           
           WRITE PRT33-RECORD            FROM P-HEADER-LINE-2           
                                        AFTER ADVANCING 1 LINE.         
           WRITE PRT33-RECORD            FROM P-HEADER-LINE-3           
                                        AFTER ADVANCING 2 LINES.        
           MOVE  6                             TO WS-LINE-COUNT.        
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
     *****************************************************************          
     **THIS ROUTINE PRINTS ZIPCODE ACCOUNT NUMBER AND RECIPIENT NAME**          
     *****************************************************************          
       8100-WRITE-DETAIL-LINE1.                                         
      *                                                                         
           IF (WS-LINE-COUNT > 52)                                      
               PERFORM 8000-WRITE-HEADER     THRU 8000-EXIT             
           END-IF                                                       
           WRITE PRT33-RECORD                FROM P-DETAIL-LINE-1       
                                            AFTER ADVANCING 1 LINES.    
           ADD   +1                                TO WS-LINE-COUNT.    
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
     *****************************************************************          
     **THIS ROUTINE PRINTS THE ADDRESS WHERE SECOND NOTICES SHOULD  **          
     **BE DELIVERED.                                                **          
     *****************************************************************          
       8200-WRITE-DETAIL-LINE2N.                                        
      *                                                                         
           IF (WS-LINE-COUNT > 52)                                      
               PERFORM 8000-WRITE-HEADER     THRU 8000-EXIT             
           END-IF                                                       
           WRITE PRT33-RECORD                FROM P-DETAIL-LINE-2N      
                                            AFTER ADVANCING 1 LINES.    
           ADD   +1                            TO WS-LINE-COUNT.        
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
     *****************************************************************          
     **THIS ROUTINE PRINTS THE ADDRESS WHERE SECOND NOTICES SHOULD  **          
     **BE DELIVERED.                                                **          
     *****************************************************************          
       8300-WRITE-FOOTER.                                               
      *                                                                         
           MOVE  WS-NOTICE-COUNT               TO WS-TAIL1-COUNT.       
           WRITE PRT33-RECORD                FROM P-FOOT-LINE-1         
                                            AFTER ADVANCING 2 LINES.    
           WRITE PRT33-RECORD                FROM P-FOOT-LINE-2         
                                            AFTER ADVANCING 3 LINES.    
           WRITE PRT33-RECORD                FROM P-FOOT-LINE-3         
                                            AFTER ADVANCING 3 LINES.    
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************00300400
      *     9000-TERMINATE                                             *00300500
      *     CLOSE FILES                                                *00300600
      ******************************************************************00300700
       9000-TERMINATE.                                                  
      *                                                                         
P00599     CLOSE FCSKR150-FILE                                          
                 FCSPT33-FILE.                                          
           STOP RUN.                                                    
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
