       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP003.                                      
COB303 DATE-WRITTEN.     JUNE 22,2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------*        
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --*        
      *----------------------------------------------------------------*        
      *--                         S U M M A R Y                      --*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                        MODIFICATION LOG                    --*        
      *--                                                            --*        
      *--  DATE          INITIALS    COMMENTS                        --*        
      *--  -----------   --------    ----------------------------------*        
A05268*--  06/22/2015    VK7L032     ACTIVITY #004.CONVERTED THE EZT --*        
ACT004*--                            PGM CSR003 TO COBOL.            --*        
      *----------------------------------------------------------------*        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSPT33.                                                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *  CFDPT33 - FD SECTION & LAYOUT FOR REPORT OUTPUT FILE       *           
      ***************************************************************           
       COPY CFDPT33.                                                            
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP003'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_CUST_PREM_HIST, CH                                   *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_PREMISE, PR                                          *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_UTIL_ENVRNMT, UT                                     *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_MTRD_ENVRNMT, MN                                     *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_COMPANY, C7                                          *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCOMPNY                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                             *           
      ***************************************************************           
      *                                                                         
       01 WS-LITERALS.                                                  
           05 WS-PROGRAM                PIC X(08) VALUE 'PCSR0031'.     
           05 WS-ELECTRIC               PIC X(01) VALUE 'E'.            
           05 WS-INACTIVE               PIC X(01) VALUE 'J'.            
           05 WS-FIVE                   PIC 9(02) VALUE 05.             
           05 WS-NO                     PIC X(01) VALUE 'N'.            
           05 WS-YES                    PIC X(01) VALUE 'Y'.            
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-COUNT                   PIC 9(04) VALUE ZEROES.         
          05 WS-READ-ROUTE              PIC 9(05) VALUE ZEROES.         
          05 WS-PREV-COUNT              PIC 9(04) VALUE ZEROES.         
          05 WS-PREV-LOCAL-OFFICE       PIC X(03) VALUE SPACES.         
          05 WS-PREV-READ-CYCLE         PIC X(02) VALUE SPACES.         
          05 WS-PREV-READ-ROUTE         PIC 9(05) VALUE ZEROES.         
          05 WS-PREV-COMPANY-NO         PIC X(02) VALUE SPACES.         
          05 WS-PREV-CODE-UTIL-TYPE     PIC X(01) VALUE SPACES.         
          05 WS-PREV-CODE-METER-STATUS  PIC X(01) VALUE SPACES.         
          05 WS-COUNT1                  PIC S9(04) COMP VALUE ZEROES.   
          05 WS-COMPANY-NAME            PIC X(26) VALUE SPACES.         
          05 WS-COMPANY-NO              PIC X(02) VALUE SPACES.         
          05 WS-LINE-COUNT              PIC 9(02) VALUE ZEROES.         
          05 WS-PAGE-NUM                PIC 9(03) VALUE ZEROES.         
          05 WS-LINE-BRK                PIC X(01) VALUE SPACES.         
      *                                                                         
       01  WS-COUNTERS.                                                 
      **********RD-ROUTE-CNTRS                                                  
           05 WS-RD-ROUTE-CNTRS.                                        
              10 WS-RD-ROUTE-ACT-ELEC-CNTR PIC 9(06) VALUE ZEROES.      
              10 WS-RD-ROUTE-INA-ELEC-CNTR PIC 9(06) VALUE ZEROES.      
              10 WS-RD-ROUTE-ACT-GAS-CNTR  PIC 9(06) VALUE ZEROES.      
              10 WS-RD-ROUTE-INA-GAS-CNTR  PIC 9(06) VALUE ZEROES.      
      **********RD-CYCLE-CNTRS                                                  
           05 WS-RD-CYCLE-CNTRS.                                        
              10 WS-RD-CYCLE-ACT-ELEC-CNTR PIC 9(06) VALUE ZEROES.      
              10 WS-RD-CYCLE-INA-ELEC-CNTR PIC 9(06) VALUE ZEROES.      
              10 WS-RD-CYCLE-ACT-GAS-CNTR  PIC 9(06) VALUE ZEROES.      
              10 WS-RD-CYCLE-INA-GAS-CNTR  PIC 9(06) VALUE ZEROES.      
      **********LOC-OFF-CNTRS                                                   
           05 WS-LOC-OFF-CNTRS.                                         
              10 WS-LOC-OFF-ACT-ELEC-CNTR  PIC 9(06) VALUE ZEROES.      
              10 WS-LOC-OFF-INA-ELEC-CNTR  PIC 9(06) VALUE ZEROES.      
              10 WS-LOC-OFF-ACT-GAS-CNTR   PIC 9(06) VALUE ZEROES.      
              10 WS-LOC-OFF-INA-GAS-CNTR   PIC 9(06) VALUE ZEROES.      
      **********CMPNY-CNTRS                                                     
           05 WS-CMPNY-CNTRS.                                           
              10 WS-CMPNY-ACT-ELEC-CNTR    PIC 9(06) VALUE ZEROES.      
              10 WS-CMPNY-INA-ELEC-CNTR    PIC 9(06) VALUE ZEROES.      
              10 WS-CMPNY-ACT-GAS-CNTR     PIC 9(06) VALUE ZEROES.      
              10 WS-CMPNY-INA-GAS-CNTR     PIC 9(06) VALUE ZEROES.      
      *                                                                         
       01  WS-NEW-PAGE                  PIC X(01) VALUE 'Y'.            
           88  NEW-PAGE                           VALUE 'N'.            
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                    PIC 9(02).                      
           05  WS-MM                    PIC 9(02).                      
           05  WS-SS                    PIC 9(02).                      
           05  WS-TT                    PIC 9(02).                      
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-SS                 PIC X(02).                      
      *                                                                         
       01  WS-CURRENT-DATE1.                                            
           05  WS-CY                    PIC 9(04).                      
           05  WS-CM                    PIC 9(02).                      
           05  WS-CD                    PIC 9(02).                      
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-DD                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-YY                 PIC X(04).                      
      *                                                                         
      ***************** PCSRP003 REPORT HEADERS **********************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER               PIC X(02) VALUE SPACES.         
               10  P-RPT1-TITLE-PGM     PIC X(08).                      
               10  FILLER               PIC X(35) VALUE SPACES.         
               10  WS-HOLD-TITLE-1      PIC X(74).                      
               10  FILLER               PIC X(04) VALUE 'PAGE'.         
               10  FILLER               PIC X(05) VALUE SPACES.         
               10  P-RPT1-TITLE-PGNM    PIC ZZZ.                        
               10  FILLER               PIC X(01) VALUE SPACES.         
      *                                                                         
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER               PIC X(02) VALUE SPACES.         
               10  FILLER               PIC X(06) VALUE 'DATE: '.       
               10  P-RPT1-DATE          PIC X(10).                      
               10  FILLER               PIC X(19) VALUE SPACES.         
               10  P-RPT1-HEAD1         PIC X(74)                       
                           VALUE 'NUMBER OF METERS PER ROUTE REPORT'.   
               10  FILLER               PIC X(10) VALUE 'RUN DATE: '.   
               10  P-RPT1-RUN-DATE      PIC X(10).                      
               10  FILLER               PIC X(01) VALUE SPACES.         
      *                                                                         
           05  WS-RPT1-HEADER-3.                                        
               10  FILLER               PIC X(111) VALUE SPACES.        
               10  FILLER               PIC X(12) VALUE 'RUN TIME:   '. 
               10  P-RPT1-RUN-TIME      PIC X(08).                      
               10  FILLER               PIC X(01) VALUE SPACES.         
      *                                                                         
           05  WS-RPT1-HEADER-4.                                        
               10  FILLER               PIC X(132) VALUE SPACES.        
      *                                                                         
           05  WS-RPT1-HEADER-5.                                        
               10  FILLER               PIC X(12) VALUE 'LOCAL OFFICE'. 
               10  FILLER               PIC X(03) VALUE SPACES.         
               10  FILLER               PIC X(10) VALUE 'READ CYCLE'.   
               10  FILLER               PIC X(03) VALUE SPACES.         
               10  FILLER               PIC X(10) VALUE 'READ ROUTE'.   
               10  FILLER               PIC X(03) VALUE SPACES.         
               10  FILLER               PIC X(16)                       
                                        VALUE 'ACTIVE ELEC MTRS'.       
               10  FILLER               PIC X(03) VALUE SPACES.         
               10  FILLER               PIC X(18)                       
                                        VALUE 'INACTIVE ELEC MTRS'.     
               10  FILLER               PIC X(03) VALUE SPACES.         
               10  FILLER               PIC X(15)                       
                                        VALUE 'ACTIVE GAS MTRS'.        
               10  FILLER               PIC X(03) VALUE SPACES.         
               10  FILLER               PIC X(17)                       
                                        VALUE 'INACTIVE GAS MTRS'.      
      *                                                                         
       05  WS-RPT1-HEADER-6.                                            
           10  FILLER                   PIC X(06)  VALUE SPACES.        
           10  P-RPT1-READ-CYCLE        PIC X(18)                       
                                        VALUE 'READ CYCLE TOTAL :'.     
           10  FILLER                   PIC X(23)  VALUE SPACES.        
           10  WS-RD-CYCLE-ACT-ELEC-DTL PIC ZZZ,ZZZ.                    
           10  FILLER                   PIC X(13)  VALUE SPACES.        
           10  WS-RD-CYCLE-INA-ELEC-DTL PIC ZZZ,ZZZ.                    
           10  FILLER                   PIC X(13)  VALUE SPACES.        
           10  WS-RD-CYCLE-ACT-GAS-DTL  PIC ZZZ,ZZZ.                    
           10  FILLER                   PIC X(12)  VALUE SPACES.        
           10  WS-RD-CYCLE-INA-GAS-DTL  PIC ZZZ,ZZZ.                    
      *                                                                         
       05  WS-RPT1-HEADER-7.                                            
           10  FILLER                  PIC X(06)  VALUE SPACES.         
           10  P-RPT1-LOCAL-OFFICE     PIC X(15)                        
                                       VALUE 'LOC OFF TOTAL :'.         
           10  FILLER                  PIC X(28)  VALUE SPACES.         
           10  WS-LOC-OFF-ACT-ELEC-DTL PIC ZZZ,ZZZ.                     
           10  FILLER                  PIC X(12)  VALUE SPACES.         
           10  WS-LOC-OFF-INA-ELEC-DTL PIC ZZZ,ZZZ.                     
           10  FILLER                  PIC X(10)  VALUE SPACES.         
           10  WS-LOC-OFF-ACT-GAS-DTL  PIC ZZZ,ZZZ.                     
           10  FILLER                  PIC X(10)  VALUE SPACES.         
           10  WS-LOC-OFF-INA-GAS-DTL  PIC ZZZ,ZZZ.                     
      *                                                                         
       05  WS-RPT1-HEADER-8.                                            
           10  FILLER                  PIC X(06)  VALUE SPACES.         
           10  P-RPT1-LOCAL-OFFICE-E   PIC X(28)                        
                                      VALUE 'LOC OFF ELEC MTRS TOTAL :'.
           10  FILLER                  PIC X(15)  VALUE SPACES.         
           10  WS-LOC-OFF-ELEC-MTR-TOT PIC ZZZ,ZZZ.                     
      *                                                                         
       05  WS-RPT1-HEADER-9.                                            
           10  FILLER                  PIC X(06)  VALUE SPACES.         
           10  P-RPT1-LOCAL-OFFICE-G   PIC X(28)                        
                                       VALUE 'LOC OFF GAS MTRS TOTAL :'.
           10  FILLER                  PIC X(15)  VALUE SPACES.         
           10  WS-LOC-OFF-GAS-MTR-TOT  PIC ZZZ,ZZZ.                     
      *                                                                         
       05  WS-RPT1-HEADER-10.                                           
           10  FILLER                  PIC X(06)  VALUE SPACES.         
           10  P-RPT1-CMPNY-TOT        PIC X(15)                        
                                       VALUE 'COMPANY TOTAL :'.         
           10  FILLER                  PIC X(28)  VALUE SPACES.         
           10  WS-CMPNY-ACT-ELEC-DTL   PIC ZZZ,ZZZ.                     
           10  FILLER                  PIC X(12)  VALUE SPACES.         
           10  WS-CMPNY-INA-ELEC-DTL   PIC ZZZ,ZZZ.                     
           10  FILLER                  PIC X(10)  VALUE SPACES.         
           10  WS-CMPNY-ACT-GAS-DTL    PIC ZZZ,ZZZ.                     
           10  FILLER                  PIC X(10)  VALUE SPACES.         
           10  WS-CMPNY-INA-GAS-DTL    PIC ZZZ,ZZZ.                     
      *                                                                         
       01  WS-TEMP33-DATA               PIC X(132) VALUE SPACES.        
      *                                                                         
       01  WS-RD-ROUTE-DTL-REC.                                         
           05 FILLER                    PIC X(04) VALUE SPACES.         
           05 WS-LOCAL-OFFICE           PIC X(03) VALUE SPACES.         
           05 FILLER                    PIC X(12) VALUE SPACES.         
           05 WS-READ-CYCLE             PIC X(02) VALUE SPACES.         
           05 FILLER                    PIC X(09) VALUE SPACES.         
           05 WS-READ-ROUTE-E           PIC Z(05) VALUE ZEROES.         
           05 FILLER                    PIC X(13) VALUE SPACES.         
           05 WS-ACT-ELEC-MTR-E         PIC ZZZ,ZZZ VALUE ZEROES.       
           05 FILLER                    PIC X(13) VALUE SPACES.         
           05 WS-INA-ELEC-MTR-E         PIC ZZZ,ZZZ VALUE ZEROES.       
           05 FILLER                    PIC X(13) VALUE SPACES.         
           05 WS-ACT-GAS-MTR-E          PIC ZZZ,ZZZ VALUE ZEROES.       
           05 FILLER                    PIC X(12) VALUE SPACES.         
           05 WS-INA-GAS-MTR-E          PIC ZZZ,ZZZ VALUE ZEROES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                   PIC X(55) VALUE SPACES.         
           05  FILLER                   PIC X(22) VALUE                 
                     '*** END OF REPORT ***'.                           
           05  FILLER                   PIC X(55) VALUE SPACES.         
      *                                                                         
       01  WS-NO-DATA.                                                  
           05  FILLER                   PIC X(55) VALUE SPACES.         
           05  FILLER                   PIC X(25) VALUE                 
                     '*** NO DATA FOUND ***'.                           
           05  FILLER                   PIC X(52) VALUE SPACES.         
      *                                                                         
      ******************************************************************        
      * THIS IS THE DRIVING CURSOR OF THIS PROGRAM FETCHING DETAILS    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE DTLS_CSR CURSOR FOR                               
                (SELECT COUNT(*)                                        
                       ,PR.LOCAL_OFFICE                                 
                       ,UT.READ_CYCLE                                   
                       ,UT.READ_ROUTE                                   
                       ,UT.CODE_UTIL_TYPE                               
                       ,UT.COMPANY_NO                                   
                       ,MN.CODE_METER_STATUS                            
                   FROM CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)             
                       ,CSS_PREMISE        PR WITH(READUNCOMMITTED)             
                       ,CSS_MTRD_ENVRNMT   MN WITH(READUNCOMMITTED)             
                       ,CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)             
                  WHERE PR.PREMISE_NO     = UT.PREMISE_NO               
                    AND CH.PREMISE_NO     = PR.PREMISE_NO               
                    AND UT.ACCOUNT_NO     = MN.ACCOUNT_NO               
                    AND CH.ACCOUNT_NO     = UT.ACCOUNT_NO               
                    AND UT.IC_NO          = MN.IC_NO                    
                    AND UT.CODE_UTIL_TYPE = MN.CODE_UTIL_TYPE           
                    AND UT.CODE_UTIL_TYPE    <> 'U'                     
                    AND MN.CODE_METER_STATUS <> 'K'                     
                    AND CH.DATE_UTIL_SVC_STRT =                         
               ( SELECT MAX(DATE_UTIL_SVC_STRT)                         
                   FROM CSS_CUST_PREM_HIST WITH(READUNCOMMITTED)                
                  WHERE PREMISE_NO = UT.PREMISE_NO )                    
                  GROUP BY UT.COMPANY_NO                                
                          ,PR.LOCAL_OFFICE                              
                          ,UT.READ_CYCLE                                
                          ,UT.READ_ROUTE                                
                          ,UT.CODE_UTIL_TYPE                            
                          ,MN.CODE_METER_STATUS
MAN003            )                                 
                  ORDER BY UT.COMPANY_NO                                
                          ,PR.LOCAL_OFFICE                              
                          ,UT.READ_CYCLE                                
                          ,UT.READ_ROUTE                                
                          ,UT.CODE_UTIL_TYPE                            
MAN003*                   ,MN.CODE_METER_STATUS)                                
MAN003                    ,MN.CODE_METER_STATUS
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DTLS_CSR CURSOR FOR                                       
MFA-TR*         (SELECT COUNT(*)                                                
MFA-TR*                ,PR.LOCAL_OFFICE                                         
MFA-TR*                ,UT.READ_CYCLE                                           
MFA-TR*                ,UT.READ_ROUTE                                           
MFA-TR*                ,UT.CODE_UTIL_TYPE                                       
MFA-TR*                ,UT.COMPANY_NO                                           
MFA-TR*                ,MN.CODE_METER_STATUS                                    
MFA-TR*            FROM CSS_UTIL_ENVRNMT   UT                                   
MFA-TR*                ,CSS_PREMISE        PR                                   
MFA-TR*                ,CSS_MTRD_ENVRNMT   MN                                   
MFA-TR*                ,CSS_CUST_PREM_HIST CH                                   
MFA-TR*           WHERE PR.PREMISE_NO     = UT.PREMISE_NO                       
MFA-TR*             AND CH.PREMISE_NO     = PR.PREMISE_NO                       
MFA-TR*             AND UT.ACCOUNT_NO     = MN.ACCOUNT_NO                       
MFA-TR*             AND CH.ACCOUNT_NO     = UT.ACCOUNT_NO                       
MFA-TR*             AND UT.IC_NO          = MN.IC_NO                            
MFA-TR*             AND UT.CODE_UTIL_TYPE = MN.CODE_UTIL_TYPE                   
MFA-TR*             AND UT.CODE_UTIL_TYPE    <> 'U'                             
MFA-TR*             AND MN.CODE_METER_STATUS <> 'K'                             
MFA-TR*             AND CH.DATE_UTIL_SVC_STRT =                                 
MFA-TR*        ( SELECT MAX(DATE_UTIL_SVC_STRT)                                 
MFA-TR*            FROM CSS_CUST_PREM_HIST                                      
MFA-TR*           WHERE PREMISE_NO = UT.PREMISE_NO )                            
MFA-TR*           GROUP BY UT.COMPANY_NO                                        
MFA-TR*                   ,PR.LOCAL_OFFICE                                      
MFA-TR*                   ,UT.READ_CYCLE                                        
MFA-TR*                   ,UT.READ_ROUTE                                        
MFA-TR*                   ,UT.CODE_UTIL_TYPE                                    
MFA-TR*                   ,MN.CODE_METER_STATUS
MFA-TR*           )                                 
MFA-TR*           ORDER BY UT.COMPANY_NO                                        
MFA-TR*                   ,PR.LOCAL_OFFICE                                      
MFA-TR*                   ,UT.READ_CYCLE                                        
MFA-TR*                   ,UT.READ_ROUTE                                        
MFA-TR*                   ,UT.CODE_UTIL_TYPE                                    
MFA-TR*                   ,MN.CODE_METER_STATUS)                                
MFA-TR*                   ,MN.CODE_METER_STATUS
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 2000-PROCESS-DTLS                THRU  2000-EXIT.    
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                     TO WS-RT-HH.                  
           MOVE WS-MM                     TO WS-RT-MM.                  
           MOVE WS-SS                     TO WS-RT-SS.                  
           MOVE WS-RUN-TIME               TO P-RPT1-RUN-TIME.           
      *                                                                         
           ACCEPT WS-CURRENT-DATE1 FROM DATE YYYYMMDD.                  
           MOVE WS-CY                     TO WS-RD-YY.                  
           MOVE WS-CM                     TO WS-RD-MM.                  
           MOVE WS-CD                     TO WS-RD-DD.                  
           MOVE WS-RUN-DATE               TO P-RPT1-RUN-DATE            
                                             P-RPT1-DATE.               
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-DTLS.                                           **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-DTLS.                                               
      *                                                                         
           PERFORM 7000-OPEN-DTLS-CSR               THRU 7000-EXIT.     
      *                                                                         
           PERFORM 7100-FETCH-DTLS-CSR              THRU 7100-EXIT.     
      *                                                                         
           IF WS-LINE-COUNT = 0 OR                                      
              WS-COMPANY-NO NOT EQUAL UT-COMPANY-NO                     
              PERFORM 2700-WRITE-HDR-REC            THRU 2700-EXIT      
              MOVE WS-YES                 TO WS-LINE-BRK                
           END-IF.                                                      
      *********REPORT FOR NO DATA FOUND                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-NO-DATA             TO PRT33-DATA                 
              PERFORM 2910-WRITE-FCSPT33            THRU 2910-EXIT      
           END-IF.                                                      
      *********MOVED TO PREV FILEDS FOR FIRST SUCCESSFULL FETCH                 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-COUNT1              TO WS-COUNT                   
              MOVE WS-COUNT               TO WS-PREV-COUNT              
              MOVE PR-LOCAL-OFFICE        TO WS-PREV-LOCAL-OFFICE       
              MOVE UT-READ-CYCLE          TO WS-PREV-READ-CYCLE         
              MOVE UT-READ-ROUTE          TO WS-PREV-READ-ROUTE         
              MOVE UT-CODE-UTIL-TYPE      TO WS-PREV-CODE-UTIL-TYPE     
              MOVE UT-COMPANY-NO          TO WS-PREV-COMPANY-NO         
              MOVE MN-CODE-METER-STATUS   TO WS-PREV-CODE-METER-STATUS  
           END-IF.                                                      
      *                                                                         
           PERFORM 2200-PROCESS-ACCOUNT-DTLS        THRU 2200-EXIT      
               UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.             
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 2800-COMPANY-NO               THRU 2800-EXIT      
           END-IF.                                                      
           PERFORM 7200-CLOSE-DTLS-CSR              THRU 7200-EXIT.     
           PERFORM 2900-WRITE-TRLR                  THRU 2900-EXIT.     
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2200-PROCESS-ACCOUNT-DTLS.                                   **        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-ACCOUNT-DTLS.                                       
      *                                                                         
           IF WS-PREV-COMPANY-NO EQUAL UT-COMPANY-NO                    
              IF WS-PREV-LOCAL-OFFICE EQUAL PR-LOCAL-OFFICE             
                 IF WS-PREV-READ-CYCLE EQUAL UT-READ-CYCLE              
                    IF WS-PREV-READ-ROUTE EQUAL UT-READ-ROUTE           
                       PERFORM 2300-READ-ROUTE-CNTR      THRU 2300-EXIT 
                    ELSE                                                
                       PERFORM 2400-READ-ROUTE           THRU 2400-EXIT 
                       INITIALIZE WS-RD-ROUTE-CNTRS                     
                       PERFORM 2300-READ-ROUTE-CNTR      THRU 2300-EXIT 
                    END-IF                                              
                 ELSE                                                   
                    PERFORM 2500-READ-CYCLE              THRU 2500-EXIT 
                    INITIALIZE WS-RD-CYCLE-CNTRS                        
                    INITIALIZE WS-RD-ROUTE-CNTRS                        
                    PERFORM 2300-READ-ROUTE-CNTR         THRU 2300-EXIT 
                 END-IF                                                 
              ELSE                                                      
                 PERFORM 2600-LOCAL-OFFICE               THRU 2600-EXIT 
                 PERFORM 2700-WRITE-HDR-REC              THRU 2700-EXIT 
                 MOVE WS-YES              TO WS-LINE-BRK                
                 INITIALIZE WS-RD-ROUTE-CNTRS                           
                 INITIALIZE WS-RD-CYCLE-CNTRS                           
                 INITIALIZE WS-LOC-OFF-CNTRS                            
                 PERFORM 2300-READ-ROUTE-CNTR            THRU 2300-EXIT 
              END-IF                                                    
           ELSE                                                         
              PERFORM 2800-COMPANY-NO                    THRU 2800-EXIT 
              PERFORM 2700-WRITE-HDR-REC                 THRU 2700-EXIT 
              MOVE WS-YES                 TO WS-LINE-BRK                
              INITIALIZE WS-COUNTERS                                    
              PERFORM 2300-READ-ROUTE-CNTR               THRU 2300-EXIT 
           END-IF.                                                      
      *                                                                         
           MOVE WS-COUNT1                 TO WS-COUNT.                  
           MOVE WS-COUNT                  TO WS-PREV-COUNT.             
           MOVE PR-LOCAL-OFFICE           TO WS-PREV-LOCAL-OFFICE.      
           MOVE UT-READ-CYCLE             TO WS-PREV-READ-CYCLE.        
           MOVE UT-READ-ROUTE             TO WS-PREV-READ-ROUTE.        
           MOVE UT-CODE-UTIL-TYPE         TO WS-PREV-CODE-UTIL-TYPE.    
           MOVE UT-COMPANY-NO             TO WS-PREV-COMPANY-NO.        
           MOVE MN-CODE-METER-STATUS      TO WS-PREV-CODE-METER-STATUS. 
      *                                                                         
           PERFORM 7100-FETCH-DTLS-CSR                  THRU 7100-EXIT. 
           MOVE WS-COUNT1                 TO WS-COUNT.                  
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-READ-ROUTE-CNTR.                                          *        
      ******************************************************************        
      *                                                                         
       2300-READ-ROUTE-CNTR.                                            
      *                                                                         
           IF UT-CODE-UTIL-TYPE = WS-ELECTRIC                           
              IF MN-CODE-METER-STATUS = WS-INACTIVE                     
                 COMPUTE WS-RD-ROUTE-INA-ELEC-CNTR = WS-COUNT +         
                         WS-RD-ROUTE-INA-ELEC-CNTR                      
              ELSE                                                      
                 COMPUTE WS-RD-ROUTE-ACT-ELEC-CNTR = WS-COUNT +         
                         WS-RD-ROUTE-ACT-ELEC-CNTR                      
              END-IF                                                    
           ELSE                                                         
              IF MN-CODE-METER-STATUS = WS-INACTIVE                     
                 COMPUTE WS-RD-ROUTE-INA-GAS-CNTR = WS-COUNT +          
                         WS-RD-ROUTE-INA-GAS-CNTR                       
              ELSE                                                      
                 COMPUTE WS-RD-ROUTE-ACT-GAS-CNTR = WS-COUNT +          
                         WS-RD-ROUTE-ACT-GAS-CNTR                       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2400-READ-ROUTE                                                *        
      ******************************************************************        
      *                                                                         
       2400-READ-ROUTE.                                                 
      *                                                                         
           MOVE WS-PREV-LOCAL-OFFICE        TO WS-LOCAL-OFFICE.         
           MOVE WS-PREV-READ-CYCLE          TO WS-READ-CYCLE.           
           MOVE WS-PREV-READ-ROUTE          TO WS-READ-ROUTE.           
           MOVE WS-RD-ROUTE-INA-ELEC-CNTR   TO WS-INA-ELEC-MTR-E.       
           MOVE WS-RD-ROUTE-ACT-ELEC-CNTR   TO WS-ACT-ELEC-MTR-E.       
           MOVE WS-RD-ROUTE-INA-GAS-CNTR    TO WS-INA-GAS-MTR-E.        
           MOVE WS-RD-ROUTE-ACT-GAS-CNTR    TO WS-ACT-GAS-MTR-E.        
           PERFORM 2400A-WRITE-RD-ROUTE-DTL-REC      THRU 2400A-EXIT.   
           COMPUTE WS-RD-CYCLE-ACT-ELEC-CNTR = WS-RD-CYCLE-ACT-ELEC-CNTR
                                        +  WS-RD-ROUTE-ACT-ELEC-CNTR.   
           COMPUTE WS-RD-CYCLE-INA-ELEC-CNTR = WS-RD-CYCLE-INA-ELEC-CNTR
                                        +  WS-RD-ROUTE-INA-ELEC-CNTR.   
           COMPUTE WS-RD-CYCLE-ACT-GAS-CNTR = WS-RD-CYCLE-ACT-GAS-CNTR  
                                        +  WS-RD-ROUTE-ACT-GAS-CNTR.    
           COMPUTE WS-RD-CYCLE-INA-GAS-CNTR = WS-RD-CYCLE-INA-GAS-CNTR  
                                        +  WS-RD-ROUTE-INA-GAS-CNTR.    
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2400A-WRITE-RD-ROUTE-DTL-REC.                                 *         
      ******************************************************************        
      *                                                                         
       2400A-WRITE-RD-ROUTE-DTL-REC.                                    
      *                                                                         
      *****DETAIL RECORD                                                        
           MOVE WS-READ-ROUTE           TO WS-READ-ROUTE-E.             
           MOVE WS-RD-ROUTE-DTL-REC     TO PRT33-DATA.                  
           PERFORM 2910-WRITE-FCSPT33          THRU 2910-EXIT.          
           ADD +1                       TO WS-LINE-COUNT.               
           MOVE WS-RPT1-HEADER-4        TO PRT33-DATA.                  
           PERFORM 2910-WRITE-FCSPT33          THRU 2910-EXIT.          
           ADD +1                       TO WS-LINE-COUNT.               
      *                                                                         
       2400A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2500-READ-CYCLE.                                               *        
      ******************************************************************        
      *                                                                         
       2500-READ-CYCLE.                                                 
      *                                                                         
           PERFORM 2400-READ-ROUTE                      THRU 2400-EXIT. 
           MOVE WS-RD-CYCLE-INA-ELEC-CNTR   TO WS-RD-CYCLE-INA-ELEC-DTL.
           MOVE WS-RD-CYCLE-ACT-ELEC-CNTR   TO WS-RD-CYCLE-ACT-ELEC-DTL.
           MOVE WS-RD-CYCLE-INA-GAS-CNTR    TO WS-RD-CYCLE-INA-GAS-DTL. 
           MOVE WS-RD-CYCLE-ACT-GAS-CNTR    TO WS-RD-CYCLE-ACT-GAS-DTL. 
           IF PR-LOCAL-OFFICE NOT EQUAL WS-PREV-LOCAL-OFFICE            
              MOVE WS-NO                       TO WS-NEW-PAGE           
           END-IF.                                                      
           PERFORM 2500A-WRITE-RD-CYCLE-DTL-REC         THRU 2500A-EXIT.
           COMPUTE WS-LOC-OFF-ACT-ELEC-CNTR = WS-LOC-OFF-ACT-ELEC-CNTR  
                                        +  WS-RD-CYCLE-ACT-ELEC-CNTR.   
           COMPUTE WS-LOC-OFF-INA-ELEC-CNTR = WS-LOC-OFF-INA-ELEC-CNTR  
                                        +  WS-RD-CYCLE-INA-ELEC-CNTR.   
           COMPUTE WS-LOC-OFF-ACT-GAS-CNTR = WS-LOC-OFF-ACT-GAS-CNTR    
                                        +  WS-RD-CYCLE-ACT-GAS-CNTR.    
           COMPUTE WS-LOC-OFF-INA-GAS-CNTR = WS-LOC-OFF-INA-GAS-CNTR    
                                        +  WS-RD-CYCLE-INA-GAS-CNTR.    
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2500A-WRITE-RD-CYCLE-DTL-REC.                                  *        
      ******************************************************************        
      *                                                                         
       2500A-WRITE-RD-CYCLE-DTL-REC.                                    
      *                                                                         
           MOVE WS-RPT1-HEADER-4     TO PRT33-DATA.                     
           PERFORM 2910-WRITE-FCSPT33          THRU 2910-EXIT.          
           ADD +1                    TO WS-LINE-COUNT.                  
           MOVE WS-RPT1-HEADER-6     TO PRT33-DATA.                     
           PERFORM 2910-WRITE-FCSPT33          THRU 2910-EXIT.          
           ADD +1                    TO WS-LINE-COUNT.                  
           MOVE WS-RPT1-HEADER-4     TO PRT33-DATA.                     
           PERFORM 2910-WRITE-FCSPT33          THRU 2910-EXIT.          
           ADD +1                    TO WS-LINE-COUNT.                  
      *                                                                         
       2500A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2600-LOCAL-OFFICE                                              *        
      ******************************************************************        
      *                                                                         
       2600-LOCAL-OFFICE.                                               
      *                                                                         
           PERFORM 2500-READ-CYCLE                    THRU 2500-EXIT.   
           MOVE WS-NO                    TO WS-NEW-PAGE.                
           MOVE WS-LOC-OFF-ACT-ELEC-CNTR TO  WS-LOC-OFF-ACT-ELEC-DTL.   
           MOVE WS-LOC-OFF-INA-ELEC-CNTR TO  WS-LOC-OFF-INA-ELEC-DTL.   
           MOVE WS-LOC-OFF-ACT-GAS-CNTR  TO  WS-LOC-OFF-ACT-GAS-DTL.    
           MOVE WS-LOC-OFF-INA-GAS-CNTR  TO  WS-LOC-OFF-INA-GAS-DTL.    
           PERFORM 2600A-WRITE-LOC-OFF-DTL-REC        THRU 2600A-EXIT.  
           COMPUTE WS-LOC-OFF-ELEC-MTR-TOT = WS-LOC-OFF-ACT-ELEC-CNTR   
                                           + WS-LOC-OFF-INA-ELEC-CNTR.  
           PERFORM 2600B-WRITE-LOC-ELEC-TOT-DTL                         
                                                      THRU 2600B-EXIT.  
           COMPUTE WS-LOC-OFF-GAS-MTR-TOT = WS-LOC-OFF-ACT-GAS-CNTR     
                                           + WS-LOC-OFF-INA-GAS-CNTR.   
           PERFORM 2600C-WRITE-LOC-GAS-TOT-DTL                          
                                                      THRU 2600C-EXIT.  
           COMPUTE WS-CMPNY-ACT-ELEC-CNTR = WS-CMPNY-ACT-ELEC-CNTR +    
                   WS-LOC-OFF-ACT-ELEC-CNTR.                            
           COMPUTE WS-CMPNY-INA-ELEC-CNTR = WS-CMPNY-INA-ELEC-CNTR +    
                   WS-LOC-OFF-INA-ELEC-CNTR.                            
           COMPUTE WS-CMPNY-ACT-GAS-CNTR = WS-CMPNY-ACT-GAS-CNTR +      
                   WS-LOC-OFF-ACT-GAS-CNTR.                             
           COMPUTE WS-CMPNY-INA-GAS-CNTR = WS-CMPNY-INA-GAS-CNTR +      
                   WS-LOC-OFF-INA-GAS-CNTR.                             
           MOVE WS-YES              TO WS-NEW-PAGE.                     
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2600A-WRITE-LOC-OFF-DTL-REC.                                   *        
      ******************************************************************        
      *                                                                         
       2600A-WRITE-LOC-OFF-DTL-REC.                                     
      *                                                                         
           MOVE WS-RPT1-HEADER-4     TO PRT33-DATA.                     
           PERFORM 2910-WRITE-FCSPT33          THRU 2910-EXIT.          
           MOVE WS-RPT1-HEADER-7     TO PRT33-DATA.                     
           PERFORM 2910-WRITE-FCSPT33          THRU 2910-EXIT.          
           MOVE WS-RPT1-HEADER-4     TO PRT33-DATA.                     
           PERFORM 2910-WRITE-FCSPT33          THRU 2910-EXIT.          
      *                                                                         
       2600A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2600B-WRITE-LOC-OFF-ELEC-TOT-REC.                              *        
      ******************************************************************        
      *                                                                         
       2600B-WRITE-LOC-ELEC-TOT-DTL.                                    
      *                                                                         
           MOVE WS-RPT1-HEADER-8     TO PRT33-DATA.                     
           PERFORM 2910-WRITE-FCSPT33          THRU 2910-EXIT.          
           MOVE WS-RPT1-HEADER-4     TO PRT33-DATA.                     
           PERFORM 2910-WRITE-FCSPT33          THRU 2910-EXIT.          
      *                                                                         
       2600B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2600C-WRITE-LOC-GAS-TOT-DTL.                                   *        
      ******************************************************************        
      *                                                                         
       2600C-WRITE-LOC-GAS-TOT-DTL.                                     
      *                                                                         
           MOVE WS-RPT1-HEADER-9     TO PRT33-DATA.                     
           PERFORM 2910-WRITE-FCSPT33          THRU 2910-EXIT.          
           MOVE WS-RPT1-HEADER-4     TO PRT33-DATA.                     
           PERFORM 2910-WRITE-FCSPT33          THRU 2910-EXIT.          
      *                                                                         
       2600C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2700-WRITE-HDR-REC                                             *        
      ******************************************************************        
      *                                                                         
       2700-WRITE-HDR-REC.                                              
      *                                                                         
           MOVE WS-PROGRAM                TO P-RPT1-TITLE-PGM.          
           PERFORM 7300-GET-COMPANY-NAME       THRU 7300-EXIT.          
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE C7-COMPANY-NAME     TO WS-HOLD-TITLE-1               
           END-IF.                                                      
           ADD +1                      TO WS-PAGE-NUM.                  
           MOVE WS-PAGE-NUM            TO P-RPT1-TITLE-PGNM.            
           MOVE ZEROES                    TO WS-LINE-COUNT.             
           MOVE WS-RPT1-HEADER-1       TO PRT33-DATA.                   
           PERFORM 8100-WRITE-FCSPT33          THRU 8100-EXIT.          
           MOVE WS-RPT1-HEADER-2       TO PRT33-DATA.                   
           PERFORM 2910-WRITE-FCSPT33          THRU 2910-EXIT.          
           MOVE WS-RPT1-HEADER-3       TO PRT33-DATA.                   
           PERFORM 2910-WRITE-FCSPT33          THRU 2910-EXIT.          
           MOVE WS-RPT1-HEADER-4       TO PRT33-DATA.                   
           PERFORM 8200-WRITE-FCSPT33          THRU 8200-EXIT.          
           MOVE WS-RPT1-HEADER-5       TO PRT33-DATA.                   
           PERFORM 2910-WRITE-FCSPT33          THRU 2910-EXIT.          
           MOVE WS-FIVE                TO WS-LINE-COUNT.                
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2800-COMPANY-NO                                                *        
      ******************************************************************        
      *                                                                         
       2800-COMPANY-NO.                                                 
      *                                                                         
           PERFORM 2600-LOCAL-OFFICE              THRU 2600-EXIT.       
           MOVE WS-CMPNY-ACT-ELEC-CNTR    TO  WS-CMPNY-ACT-ELEC-DTL.    
           MOVE WS-CMPNY-INA-ELEC-CNTR    TO  WS-CMPNY-INA-ELEC-DTL.    
           MOVE WS-CMPNY-ACT-GAS-CNTR     TO  WS-CMPNY-ACT-GAS-DTL.     
           MOVE WS-CMPNY-INA-GAS-CNTR     TO  WS-CMPNY-INA-GAS-DTL.     
           PERFORM 2800A-WRITE-CMPNY-DETL-RECORDS THRU 2800A-EXIT.      
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2800A-WRITE-CMPNY-DETL-RECORDS.                                *        
      ******************************************************************        
      *                                                                         
       2800A-WRITE-CMPNY-DETL-RECORDS.                                  
      *                                                                         
           MOVE WS-RPT1-HEADER-4          TO PRT33-DATA.                
           PERFORM 2910-WRITE-FCSPT33             THRU 2910-EXIT.       
           MOVE WS-RPT1-HEADER-10         TO PRT33-DATA.                
           PERFORM 2910-WRITE-FCSPT33             THRU 2910-EXIT.       
           MOVE WS-RPT1-HEADER-4          TO PRT33-DATA.                
           PERFORM 2910-WRITE-FCSPT33             THRU 2910-EXIT.       
      *                                                                         
       2800A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2900-WRITE-TRLR.                                               *        
      ******************************************************************        
      *                                                                         
       2900-WRITE-TRLR.                                                 
      *                                                                         
      *****TRAILER RECORD                                                       
           MOVE WS-END-DATA-LINE          TO PRT33-DATA.                
           PERFORM 8000-WRITE-FCSPT33               THRU 8000-EXIT.     
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2910-WRITE-FCSPT33.                                            *        
      ******************************************************************        
      *                                                                         
       2910-WRITE-FCSPT33.                                              
      *                                                                         
           IF WS-LINE-COUNT GREATER THAN 54 AND WS-NEW-PAGE = WS-YES    
              MOVE PRT33-DATA             TO WS-TEMP33-DATA             
              PERFORM 2700-WRITE-HDR-REC               THRU 2700-EXIT   
              MOVE WS-TEMP33-DATA         TO PRT33-DATA                 
              PERFORM 8300-WRITE-FCSPT33               THRU 8300-EXIT   
           ELSE                                                         
              IF WS-LINE-BRK = WS-YES                                   
                 PERFORM 8300-WRITE-FCSPT33            THRU 8300-EXIT   
                 MOVE WS-NO               TO WS-LINE-BRK                
              ELSE                                                      
                 PERFORM 8000-WRITE-FCSPT33            THRU 8000-EXIT   
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7000-OPEN-DTLS-CSR                                             *        
      ******************************************************************        
      *                                                                         
       7000-OPEN-DTLS-CSR.                                              
      *                                                                         
           EXEC SQL                                                     
              OPEN DTLS_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP003 ABORT ******'                  
              DISPLAY '**  7000-OPEN-DTLS-CSR      **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-FETCH-DTLS-CSR                                            *        
      ******************************************************************        
      *                                                                         
       7100-FETCH-DTLS-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              FETCH DTLS_CSR                                            
               INTO :WS-COUNT1                                          
                   ,:PR-LOCAL-OFFICE                                    
                   ,:UT-READ-CYCLE                                      
                   ,:UT-READ-ROUTE                                      
                   ,:UT-CODE-UTIL-TYPE                                  
                   ,:UT-COMPANY-NO                                      
                   ,:MN-CODE-METER-STATUS                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP003 ABORT *****'                   
              DISPLAY '**  7100-FETCH-DTLS-CSR    **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  UT-ACCOUNT-NO = ' UT-ACCOUNT-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-CLOSE-DTLS-CSR                                            *        
      ******************************************************************        
      *                                                                         
       7200-CLOSE-DTLS-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE DTLS_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP003 ABORT *****'                   
              DISPLAY '**  7200-CLOSE-DTLS-CSR    **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7300-GET-COMPANY-NAME                                       **        
      ******************************************************************        
      *                                                                         
       7300-GET-COMPANY-NAME.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  C7.COMPANY_NAME                                   
                INTO :C7-COMPANY-NAME                                   
                FROM CSS_COMPANY C7 WITH(READUNCOMMITTED)                       
               WHERE C7.COMPANY_NO = :UT-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  C7.COMPANY_NAME                                           
MFA-TR*         INTO :C7-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY C7                                             
MFA-TR*        WHERE C7.COMPANY_NO = :UT-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP003 ABORT *****'                   
              DISPLAY '**  7300-GET-COMPANY-NAME  **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  COMPANY_NO  = ' UT-COMPANY-NO                
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000-WRITE-FCSTP33.                                          **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD.                                          
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100-WRITE-FCSTP33.                                          **        
      ******************************************************************        
      *                                                                         
       8100-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING PAGE.                                   
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8200-WRITE-FCSTP33.                                          **        
      ******************************************************************        
      *                                                                         
       8200-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 3 LINES.                                
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8300-WRITE-FCSTP33.                                          **        
      ******************************************************************        
      *                                                                         
       8300-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 2 LINES.                                
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  9000-TERMINATE.                                             **        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
           DISPLAY '9000-TERMINATE'.                                    
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
