       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP001.                                      
       AUTHOR.       VISHAL VELUSAMY.                                   
COB303 DATE-WRITTEN.     JUL 29, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      ******************************************************************        
      ***               CUSTOMER INFORMATION SYSTEM.                 ***        
      *** PRINT A LISTING OF ALL ACCOUNTS ADDED IN THE PAST MONTH    ***        
      *** WITH RATES ('102', '127', '227')                           ***        
      ***                                                            ***        
      *** IF USING DATE ON JOB_PARM TO RUN A SPECIAL RUN, YOU MUST   ***        
      *** SET THE DATES BACK TO WHAT IS NEEDED FOR THE NEXT          ***        
      *** SCHEDULED PRODUCTION RUN.   THE FROM DATE WOULD BE THE     ***        
      *** LAST RUN DATE AND THE THRU DATE WOULD BE AS BELOW.         ***        
      *** FROM 2003-07-01 THRU XXXX-XX-XX                            ***        
      *----------------------------------------------------------------*        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
      ***  DATE          INITIALS    COMMENTS                        ***        
      ***  -----------   --------    --------------------------------***        
ACT014***  08/15/2015    VV7M728     EZY TO COBOL CONVERSION         ***        
ACT155***  05/09/2016    MR7E794     REPLACE THE DELIMIT VALUE AS ';'***        
ACT155***                A05460      INSTEAD OF SPACES AND REMOVED   ***        
ACT155***                            THE UNUSED COPYBOOKS.           ***        
      ***------------------------------------------------------------***        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSPT182.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
       COPY CFDPT182.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP001'.
MSQ017     COPY MFASQLM.
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_JOB_PARM                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCOUNT                                                 *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_NAME                                                    *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ADDR_FORMATTED                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_SO_DATA                                                 *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_SO_UTL_CHG                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOUTG                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * ABEND SWITCH COPYBOOK                                         *         
      *****************************************************************         
      *                                                                         
           COPY CWS00038.                                                       
      *                                                                         
      *****************************************************************         
      *                                                                         
      ******************************************************************        
      * COPYBOOKS                                                               
      ******************************************************************        
      *                                                                         
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS09900.                                                           
                                                                        
       COPY CWS00010.                                                           
      *                                                             *           
      ******************************************************************        
       01 WS-LITERALS.                                                  
           05 WS-PROGRAM-NAME           PIC X(10) VALUE 'PCSRP001'.     
      *                                                                         
       01 WS-RP182-HDR-REC.                                             
           05 HDR-ACCOUNT               PIC X(13)                       
                  VALUE '  ACCOUNT NO '.                                
ACT155     05 HDR-DELIM-1               PIC X(01) VALUE ';'.            
           05 HDR-NAME-PRT              PIC X(45)                       
                  VALUE ' NAME                                        '.
ACT155     05 HDR-DELIM-2               PIC X(01) VALUE ';'.            
           05 HDR-NEW-RATE              PIC X(05)                       
                  VALUE 'RATE '.                                        
ACT155     05 HDR-DELIM-3               PIC X(01) VALUE ';'.            
           05 HDR-DATE-PRT              PIC X(10)                       
                  VALUE '   DATE   '.                                   
ACT155     05 HDR-DELIM-4               PIC X(01) VALUE ';'.            
           05 HDR-ADDR-PRT              PIC X(45)                       
                  VALUE ' ADDRESS                                     '.
ACT155     05 HDR-DELIM-5               PIC X(01) VALUE ';'.            
           05 HDR-CITY-STATE            PIC X(45)                       
                  VALUE ' CITY / STATE                                '.
ACT155     05 HDR-DELIM-6               PIC X(01) VALUE ';'.            
           05 HDR-PREMISE               PIC X(10)                       
                  VALUE ' PREMISE  '.                                   
ACT155     05 HDR-DELIM-7               PIC X(01) VALUE ';'.            
           05 HDR-STAT                  PIC X(01) VALUE 'S'.            
ACT155     05 HDR-DELIM-8               PIC X(01) VALUE ';'.            
      *                                                                         
      *                                                                         
       01 WS-RP182-OUT-REC.                                             
           05 OUT-ACCOUNT               PIC 9(13) VALUE ZEROES.         
ACT155     05 OUT-DELIM-1               PIC X(01) VALUE ';'.            
           05 OUT-NAME-PRT              PIC X(45) VALUE SPACES.         
ACT155     05 OUT-DELIM-2               PIC X(01) VALUE ';'.            
           05 OUT-NEW-RATE              PIC X(05) VALUE SPACES.         
ACT155     05 OUT-DELIM-3               PIC X(01) VALUE ';'.            
           05 OUT-DATE-PRT              PIC X(10) VALUE SPACES.         
ACT155     05 OUT-DELIM-4               PIC X(01) VALUE ';'.            
           05 OUT-ADDR-PRT              PIC X(45) VALUE SPACES.         
ACT155     05 OUT-DELIM-5               PIC X(01) VALUE ';'.            
           05 OUT-CITY-STATE            PIC X(45) VALUE SPACES.         
ACT155     05 OUT-DELIM-6               PIC X(01) VALUE ';'.            
           05 OUT-PREMISE               PIC X(10) VALUE SPACES.         
ACT155     05 OUT-DELIM-7               PIC X(01) VALUE ';'.            
           05 OUT-STAT                  PIC X(01) VALUE SPACES.         
ACT155     05 OUT-DELIM-8               PIC X(01) VALUE ';'.            
      *                                                                         
       01 WS-FLAGS.                                                     
           05 WS-PARM-FOUND             PIC X(01) VALUE 'N'.            
           05 WS-ALL-ROWS-PROCESD       PIC X(01) VALUE 'N'.            
           05 WS-DATA-FOUND             PIC X(01) VALUE 'N'.            
                                                                        
       01  WS-SWITCH.                                                   
           05  WS-FCA182-STATUS         PIC X(02).                      
               88 FCA182-SUCCESSFUL               VALUE '00'.           
                                                                        
       01  WS-COUNTERS.                                                 
           05  WS-LOCAL-COUNT           PIC 9(04) VALUE ZEROS.          
           05  WS-TOTAL-COUNT           PIC 9(06) VALUE ZEROS.          
      *                                                                         
       01 WS-MISC.                                                      
           05  WS-TIMESTAMP             PIC X(16)                       
                                          VALUE '-00.00.00.000000'.     
           05  WS-DATA-SW               PIC X(01) VALUE 'N'.            
           05  WS-DATE-XXX              PIC X(10) VALUE 'XXXX-XX-XX'.   
           05  WS-DATE-PRT1             PIC X(10) VALUE 'XXXX-XX-XX'.   
           05  WS-DATE-PRT              PIC X(10) VALUE SPACES.         
           05  WS-ACCOUNT               PIC 9(13) VALUE ZEROES.         
           05  WS-OLD-RATE              PIC X(03) VALUE SPACES.         
           05  WS-NEW-RATE              PIC X(03) VALUE SPACES.         
           05  WS-SOURCE                PIC X(01) VALUE SPACES.         
           05  WS-TRANS-DAY             PIC X(02) VALUE SPACES.         
           05  WS-END-DAY               PIC X(02) VALUE SPACES.         
           05  WS-NAME-PRT              PIC X(45) VALUE SPACES.         
           05  WS-ADDR-PRT              PIC X(45) VALUE SPACES.         
           05  WS-CITY-STATES           PIC X(45) VALUE SPACES.         
           05  WS-PARM-DATA             PIC X(80) VALUE SPACES.         
           05  WS-TRANS-TS              PIC X(26) VALUE SPACES.         
           05  WS-END-TS                PIC X(26) VALUE SPACES.         
           05  WS-SPACES                PIC X(01) VALUE ' '.            
           05  WS-SPACES17              PIC X(17) VALUE SPACES.         
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
      *                                                                         
       01 WS-TRANS-TIMESTAMP.                                           
           05  WS-TRANS-DATE            PIC X(10) VALUE SPACES.         
           05  WS-TRANS-TMS             PIC X(16) VALUE SPACES.         
      *                                                                         
       01 WS-END-TIMESTAMP.                                             
           05  WS-END-DATE              PIC X(10) VALUE SPACES.         
           05  WS-END-TMS               PIC X(16) VALUE SPACES.         
      *                                                                         
       01 WS-ADDR-LINE.                                                 
           05  WS-ADDR-HOUSE            PIC X(15) VALUE SPACES.         
           05  WS-ADDR-PREF1            PIC X(03) VALUE SPACES.         
           05  WS-ADDR-PREF2            PIC X(02) VALUE SPACES.         
           05  WS-ADDR-ST               PIC X(30) VALUE SPACES.         
           05  WS-ADDR-SUF              PIC X(04) VALUE SPACES.         
           05  WS-ADDR-TDIR             PIC X(02) VALUE SPACES.         
           05  WS-ADDR-APT              PIC X(04) VALUE SPACES.         
           05  WS-ADDR-APTNO            PIC X(11) VALUE SPACES.         
           05  FILLER                   PIC X(07) VALUE SPACES.         
      *                                                                         
       01  WS-CITY-STATE.                                               
           05  WS-TOWN                  PIC X(26) VALUE SPACES.         
           05  WS-STATE                 PIC X(02) VALUE SPACES.         
           05  FILLER                   PIC X(17) VALUE SPACES.         
      *                                                                         
       01  WS-NAME.                                                     
           05  WS-1ST-NAME              PIC X(15) VALUE SPACES.         
           05  WS-MIDDLE-NAME           PIC X(15) VALUE SPACES.         
           05  WS-LAST-NAME             PIC X(40) VALUE SPACES.         
           05  FILLER                   PIC X(02) VALUE SPACES.         
      *                                                                         
       01  WS-PARM-DATAS.                                               
           05  WS-PARM-FROM-LIT         PIC X(12) VALUE SPACES.         
           05  WS-PARM-FROM-DATE        PIC X(10) VALUE SPACES.         
           05  WS-PARM-FILL1            PIC X(01) VALUE SPACES.         
           05  WS-PARM-THUR-LIT         PIC X(12) VALUE SPACES.         
           05  WS-PARM-THRU-DATE        PIC X(10) VALUE SPACES.         
           05  WS-PARM-FILL2            PIC X(35) VALUE SPACES.         
      *                                                                         
      ***************************************************************           
      *SELECT ACCOUNTS CHANGED TO RATE 102 OR 127 AND ACCOUNTS      *           
      *ADDED AS AS RATE 102 OR 127 IN THE PAST MONTH                *           
      ***************************************************************           
      *                                                                         
            EXEC SQL                                                    
              DECLARE GET_ACCOUNTS CURSOR WITH HOLD FOR                 
                SELECT UT.RATE_PLAN_NO                                  
                      ,PR.PREM_CREATE_DT                                
                      ,AT.PREMISE_NO                                    
                  FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                      ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                      ,CSS_PREMISE PR WITH(READUNCOMMITTED)                     
                 WHERE UT.ACCOUNT_NO   = AT.ACCOUNT_NO                  
                   AND PR.PREMISE_NO   = AT.PREMISE_NO                  
                   AND AT.COMPANY_NO   = '26'                           
                   AND UT.RATE_PLAN_NO IN ('102', '127', '227')         
                FOR READ ONLY                                   
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*       DECLARE GET_ACCOUNTS CURSOR WITH HOLD FOR                         
MFA-TR*         SELECT UT.RATE_PLAN_NO                                          
MFA-TR*               ,PR.PREM_CREATE_DT                                        
MFA-TR*               ,AT.PREMISE_NO                                            
MFA-TR*           FROM CSS_ACCOUNT AT                                           
MFA-TR*               ,CSS_UTIL_ENVRNMT UT                                      
MFA-TR*               ,CSS_PREMISE PR                                           
MFA-TR*          WHERE UT.ACCOUNT_NO   = AT.ACCOUNT_NO                          
MFA-TR*            AND PR.PREMISE_NO   = AT.PREMISE_NO                          
MFA-TR*            AND AT.COMPANY_NO   = '26'                                   
MFA-TR*            AND UT.RATE_PLAN_NO IN ('102', '127', '227')                 
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*     END-EXEC.                                                           
      *                                                                         
      ***************************************************************           
       PROCEDURE DIVISION.                                              
      ***************************************************************           
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 1100-GET-PARM-DATA               THRU  1100-EXIT.    
           PERFORM 2000-PROCESS-MAIN-CSR            THRU  2000-EXIT.    
           PERFORM 1500-UPDATE-JOB-PARM             THRU  1500-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100-INITIALIZE.                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           PERFORM 8000-OPEN-OUTFILE                THRU  8000-EXIT     
                                                                        
           INITIALIZE PRT182-RECORD.                                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1100-GET-PARM-DATA.                                          **        
      ******************************************************************        
      *                                                                         
       1100-GET-PARM-DATA.                                              
                                                                        
           MOVE 'PCSRP001'                       TO WS-PROGRAM-NAME     
                                                                        
           PERFORM 7100-GET-JOB-PARM                THRU 7100-EXIT      
           MOVE WS-PARM-DATA                     TO WS-PARM-DATAS       
           MOVE WS-PARM-DATAS                    TO G6-PARM-DATA        
                                                                        
            DISPLAY 'WS-PARM   = ' WS-PARM-DATA                         
            DISPLAY 'FROM DATE = ' WS-PARM-FROM-DATE                    
            DISPLAY 'THRU DATE = ' WS-PARM-THRU-DATE                    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             MOVE WS-PARM-FROM-DATE              TO WS-TRANS-DATE       
                                                                        
             IF WS-PARM-THRU-DATE = 'XXXX-XX-XX'                        
               MOVE 'COMMONDATE'                 TO WS-PROGRAM-NAME     
               PERFORM 7100-GET-JOB-PARM           THRU 7100-EXIT       
                                                                        
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                  MOVE WS-PARM-DATA              TO WS-END-DATE         
                  MOVE '01'                      TO WS-TRANS-DAY        
                  MOVE WS-TRANS-DAY              TO WS-TRANS-DATE(9:2)  
                  MOVE '01'                      TO WS-END-DAY          
                  MOVE WS-END-DAY                TO WS-END-DATE(9:2)    
               END-IF                                                   
                                                                        
             ELSE                                                       
                MOVE WS-PARM-THRU-DATE           TO WS-END-DATE         
             END-IF                                                     
           END-IF.                                                      
                                                                        
           MOVE WS-TIMESTAMP                     TO WS-TRANS-TMS        
           MOVE WS-TRANS-TIMESTAMP               TO WS-TRANS-TS         
           MOVE WS-TIMESTAMP                     TO WS-END-TMS          
           MOVE WS-END-TIMESTAMP                 TO WS-END-TS           
                                                                        
           DISPLAY 'PNC004 BEGINNING DATE = ' WS-TRANS-TIMESTAMP        
           DISPLAY 'PNC004 ENDING    DATE = ' WS-END-TIMESTAMP.         
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      ** 1200-GET-ACCOUNT-DTL.                                        **        
      ******************************************************************        
      *                                                                         
       1200-GET-ACCOUNT-DTL.                                            
      *                                                                         
           PERFORM 7500-GET-TRANHIST                THRU  7500-EXIT     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-DATE-PRT1 > WS-DATE-PRT                             
                 MOVE WS-DATE-PRT1               TO WS-DATE-PRT         
                 MOVE ' '                        TO WS-DATE-PRT1        
              END-IF                                                    
                                                                        
              PERFORM 7600-GET-NAME-ADDR            THRU  7600-EXIT     
                                                                        
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    PERFORM 1300-PROCESS-NAME-ADDR  THRU  1300-EXIT     
                 END-IF                                                 
                                                                        
                 IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
                    MOVE SPACES                  TO DQ-NAME-FORMAT      
                    MOVE 'UNKNOWN'               TO WS-NAME             
                    MOVE 'UNKNOWN'               TO WS-ADDR-LINE        
                    MOVE 'UNKNOWN'               TO WS-CITY-STATE       
                    PERFORM 1300-PROCESS-NAME-ADDR  THRU 1300-EXIT      
                 END-IF                                                 
           END-IF.                                                      
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
             PERFORM 7700-GET-SERVICE-ORDER         THRU 7700-EXIT      
                                                                        
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    MOVE VO-ACCOUNT-NO           TO AT-ACCOUNT-NO       
                    PERFORM 1300-PROCESS-NAME-ADDR  THRU 1300-EXIT      
                 END-IF                                                 
                                                                        
           END-IF                                                       
                                                                        
           PERFORM 7300-FETCH-GET-ACCOUNTS          THRU  7300-EXIT.    
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *1300-PROCESS-NAME-ADDR                                          *        
      ******************************************************************        
      *                                                                         
       1300-PROCESS-NAME-ADDR.                                          
      *                                                                         
           MOVE UT-RATE-PLAN-NO                  TO WS-NEW-RATE         
                                                                        
                                                                        
           IF AT-ACCOUNT-NO NOT = WS-ACCOUNT                            
                                                                        
           IF DQ-NAME-FORMAT = 'B'                                      
              MOVE DQ-FULL-NAME                  TO WS-NAME             
              MOVE WS-NAME                       TO OUT-NAME-PRT        
           ELSE                                                         
             IF WS-MIDDLE-NAME = SPACES                                 
                                                                        
              STRING WS-1ST-NAME             DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-LAST-NAME            DELIMITED BY '  '          
                INTO WS-NAME-PRT                                        
                                                                        
             ELSE                                                       
              STRING WS-1ST-NAME             DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-MIDDLE-NAME          DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-LAST-NAME            DELIMITED BY '  '          
                INTO WS-NAME-PRT                                        
             END-IF                                                     
                                                                        
              MOVE WS-NAME-PRT                   TO OUT-NAME-PRT        
                                                                        
           END-IF                                                       
                                                                        
              STRING WS-TOWN                 DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-STATE                DELIMITED BY '  '          
                     WS-SPACES17             DELIMITED BY SIZE          
                INTO WS-CITY-STATES                                     
                                                                        
           IF WS-ADDR-TDIR  = SPACES                                    
                                                                        
           IF WS-ADDR-PREF1 = SPACES AND                                
              WS-ADDR-PREF2 = SPACES                                    
                                                                        
              STRING WS-ADDR-HOUSE           DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-ST              DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-SUF             DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APT             DELIMITED BY '  '          
      *              WS-SPACES               DELIMITED BY SIZE                  
                     WS-ADDR-APTNO           DELIMITED BY '  '          
                INTO WS-ADDR-PRT                                        
                                                                        
            IF WS-ADDR-PREF1 = SPACES AND                               
               WS-ADDR-PREF2 = SPACES AND                               
               WS-ADDR-SUF   = SPACES                                   
                                                                        
               STRING WS-ADDR-HOUSE           DELIMITED BY '  '         
                      WS-SPACES               DELIMITED BY SIZE         
                      WS-ADDR-ST              DELIMITED BY '  '         
                      WS-SPACES               DELIMITED BY SIZE         
                      WS-ADDR-APT             DELIMITED BY '  '         
                      WS-SPACES               DELIMITED BY SIZE         
                      WS-ADDR-APTNO           DELIMITED BY '  '         
                 INTO WS-ADDR-PRT                                       
            END-IF                                                      
                                                                        
           ELSE                                                         
                                                                        
             IF WS-ADDR-PREF1 = SPACES AND                              
                WS-ADDR-PREF2 NOT EQUAL SPACES                          
                                                                        
              STRING WS-ADDR-HOUSE           DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-PREF2           DELIMITED BY '  '          
                     WS-ADDR-ST              DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-SUF             DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APT             DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APTNO           DELIMITED BY '  '          
                INTO WS-ADDR-PRT                                        
                                                                        
              IF WS-ADDR-PREF1 = SPACES AND                             
                 WS-ADDR-PREF2 NOT EQUAL SPACES AND                     
                 WS-ADDR-SUF   = SPACES                                 
                                                                        
               STRING WS-ADDR-HOUSE           DELIMITED BY '  '         
                      WS-SPACES               DELIMITED BY SIZE         
                      WS-ADDR-PREF2           DELIMITED BY '  '         
                      WS-ADDR-ST              DELIMITED BY '  '         
                      WS-SPACES               DELIMITED BY SIZE         
                      WS-ADDR-APT             DELIMITED BY '  '         
                      WS-SPACES               DELIMITED BY SIZE         
                      WS-ADDR-APTNO           DELIMITED BY '  '         
                 INTO WS-ADDR-PRT                                       
              END-IF                                                    
             END-IF                                                     
                                                                        
             IF WS-ADDR-PREF1 NOT EQUAL SPACES AND                      
                WS-ADDR-PREF2 = SPACES                                  
                                                                        
              STRING WS-ADDR-HOUSE           DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-PREF1           DELIMITED BY '  '          
                     WS-ADDR-ST              DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-SUF             DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APT             DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APTNO           DELIMITED BY '  '          
                INTO WS-ADDR-PRT                                        
                                                                        
              IF WS-ADDR-PREF1 NOT EQUAL SPACES AND                     
                 WS-ADDR-PREF2 = SPACES AND                             
                 WS-ADDR-SUF   = SPACES                                 
                                                                        
              STRING WS-ADDR-HOUSE           DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-PREF1           DELIMITED BY '  '          
                     WS-ADDR-ST              DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APT             DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APTNO           DELIMITED BY '  '          
                INTO WS-ADDR-PRT                                        
              END-IF                                                    
                                                                        
             END-IF                                                     
                                                                        
             IF WS-ADDR-PREF1 NOT EQUAL SPACES AND                      
                WS-ADDR-PREF2 NOT EQUAL SPACES                          
                                                                        
              STRING WS-ADDR-HOUSE           DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-PREF1           DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-PREF2           DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-ST              DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-SUF             DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APT             DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APTNO           DELIMITED BY '  '          
                INTO WS-ADDR-PRT                                        
                                                                        
              IF WS-ADDR-PREF1 NOT EQUAL SPACES AND                     
                 WS-ADDR-PREF2 NOT EQUAL SPACES AND                     
                 WS-ADDR-SUF   = SPACES                                 
                                                                        
              STRING WS-ADDR-HOUSE           DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-PREF1           DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-PREF2           DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-ST              DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APT             DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APTNO           DELIMITED BY '  '          
                INTO WS-ADDR-PRT                                        
              END-IF                                                    
             END-IF                                                     
           END-IF                                                       
           ELSE                                                         
                                                                        
           IF WS-ADDR-PREF1 = SPACES AND                                
              WS-ADDR-PREF2 = SPACES                                    
                                                                        
              STRING WS-ADDR-HOUSE           DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-ST              DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-SUF             DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-TDIR            DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APT             DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APTNO           DELIMITED BY '  '          
                INTO WS-ADDR-PRT                                        
                                                                        
            IF WS-ADDR-PREF1 = SPACES AND                               
               WS-ADDR-PREF2 = SPACES AND                               
               WS-ADDR-SUF   = SPACES                                   
                                                                        
               STRING WS-ADDR-HOUSE           DELIMITED BY '  '         
                      WS-SPACES               DELIMITED BY SIZE         
                      WS-ADDR-ST              DELIMITED BY '  '         
                      WS-SPACES               DELIMITED BY SIZE         
                      WS-ADDR-TDIR            DELIMITED BY '  '         
                      WS-SPACES               DELIMITED BY SIZE         
                      WS-ADDR-APT             DELIMITED BY '  '         
                      WS-SPACES               DELIMITED BY SIZE         
                      WS-ADDR-APTNO           DELIMITED BY '  '         
                 INTO WS-ADDR-PRT                                       
            END-IF                                                      
                                                                        
           ELSE                                                         
                                                                        
             IF WS-ADDR-PREF1 = SPACES AND                              
                WS-ADDR-PREF2 NOT EQUAL SPACES                          
                                                                        
              STRING WS-ADDR-HOUSE           DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-PREF2           DELIMITED BY '  '          
                     WS-ADDR-ST              DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-SUF             DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-TDIR            DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APT             DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APTNO           DELIMITED BY '  '          
                INTO WS-ADDR-PRT                                        
                                                                        
              IF WS-ADDR-PREF1 = SPACES AND                             
                 WS-ADDR-PREF2 NOT EQUAL SPACES AND                     
                 WS-ADDR-SUF   = SPACES                                 
                                                                        
               STRING WS-ADDR-HOUSE           DELIMITED BY '  '         
                      WS-SPACES               DELIMITED BY SIZE         
                      WS-ADDR-PREF2           DELIMITED BY '  '         
                      WS-ADDR-ST              DELIMITED BY '  '         
                      WS-SPACES               DELIMITED BY SIZE         
                      WS-ADDR-TDIR            DELIMITED BY '  '         
                      WS-SPACES               DELIMITED BY SIZE         
                      WS-ADDR-APT             DELIMITED BY '  '         
                      WS-SPACES               DELIMITED BY SIZE         
                      WS-ADDR-APTNO           DELIMITED BY '  '         
                 INTO WS-ADDR-PRT                                       
              END-IF                                                    
             END-IF                                                     
                                                                        
             IF WS-ADDR-PREF1 NOT EQUAL SPACES AND                      
                WS-ADDR-PREF2 = SPACES                                  
                                                                        
              STRING WS-ADDR-HOUSE           DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-PREF1           DELIMITED BY '  '          
                     WS-ADDR-ST              DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-SUF             DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-TDIR            DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APT             DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APTNO           DELIMITED BY '  '          
                INTO WS-ADDR-PRT                                        
                                                                        
              IF WS-ADDR-PREF1 NOT EQUAL SPACES AND                     
                 WS-ADDR-PREF2 = SPACES AND                             
                 WS-ADDR-SUF   = SPACES                                 
                                                                        
              STRING WS-ADDR-HOUSE           DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-PREF1           DELIMITED BY '  '          
                     WS-ADDR-ST              DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-TDIR            DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APT             DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APTNO           DELIMITED BY '  '          
                INTO WS-ADDR-PRT                                        
              END-IF                                                    
                                                                        
             END-IF                                                     
                                                                        
             IF WS-ADDR-PREF1 NOT EQUAL SPACES AND                      
                WS-ADDR-PREF2 NOT EQUAL SPACES                          
                                                                        
              STRING WS-ADDR-HOUSE           DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-PREF1           DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-PREF2           DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-ST              DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-SUF             DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-TDIR            DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APT             DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APTNO           DELIMITED BY '  '          
                INTO WS-ADDR-PRT                                        
                                                                        
              IF WS-ADDR-PREF1 NOT EQUAL SPACES AND                     
                 WS-ADDR-PREF2 NOT EQUAL SPACES AND                     
                 WS-ADDR-SUF   = SPACES                                 
                                                                        
              STRING WS-ADDR-HOUSE           DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-PREF1           DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-PREF2           DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-ST              DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-TDIR            DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APT             DELIMITED BY '  '          
                     WS-SPACES               DELIMITED BY SIZE          
                     WS-ADDR-APTNO           DELIMITED BY '  '          
                INTO WS-ADDR-PRT                                        
              END-IF                                                    
             END-IF                                                     
           END-IF                                                       
           END-IF                                                       
                                                                        
              MOVE AT-ACCOUNT-NO                 TO WS-ACCOUNT          
              MOVE WS-ACCOUNT                    TO OUT-ACCOUNT         
              MOVE AT-CODE-ACCT-STAT             TO OUT-STAT            
              MOVE WS-NEW-RATE                   TO OUT-NEW-RATE        
              MOVE WS-DATE-PRT                   TO OUT-DATE-PRT        
              MOVE WS-ADDR-PRT                   TO OUT-ADDR-PRT        
              MOVE WS-CITY-STATES                TO OUT-CITY-STATE      
              MOVE AT-PREMISE-NO                 TO OUT-PREMISE         
                                                                        
              INITIALIZE WS-NAME-PRT                                    
              INITIALIZE WS-CITY-STATES                                 
              INITIALIZE WS-ADDR-PRT                                    
                                                                        
           PERFORM 8200-WRITE-OUTFILE-DETAILS         THRU 8200-EXIT    
                                                                        
              MOVE WS-Y                          TO WS-DATA-SW          
                                                                        
              MOVE ZEROES                        TO OUT-ACCOUNT         
                                                    OUT-PREMISE         
              MOVE SPACES                        TO OUT-STAT            
                                                    OUT-NAME-PRT        
                                                    OUT-NEW-RATE        
                                                    OUT-DATE-PRT        
                                                    OUT-ADDR-PRT        
                                                    OUT-CITY-STATE      
                                                                        
           END-IF.                                                      
                                                                        
              MOVE SPACES                        TO WS-ADDR-LINE        
                                                    WS-NAME             
                                                    WS-CITY-STATE       
           .                                                            
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *1500-UPDATE-JOB-PARM.                                           *        
      ******************************************************************        
      *                                                                         
       1500-UPDATE-JOB-PARM.                                            
                                                                        
              MOVE WS-END-DATE                   TO WS-PARM-FROM-DATE   
              MOVE WS-DATE-XXX                   TO WS-PARM-THRU-DATE   
              MOVE WS-PARM-DATAS                 TO G6-PARM-DATA        
                                                                        
              PERFORM 7800-UPDATE-JOB-PARM-TBL      THRU  7800-EXIT     
                                                                        
              IF WS-DATA-SW = WS-N                                      
                 MOVE 0                          TO HDR-ACCOUNT         
                 MOVE 'NO DATA TODAY '           TO HDR-ACCOUNT         
                 MOVE SPACES                     TO HDR-STAT            
                 MOVE SPACES                     TO HDR-NAME-PRT        
                 MOVE SPACES                     TO HDR-NEW-RATE        
                 MOVE WS-END-DATE                TO HDR-DATE-PRT        
                 MOVE SPACES                     TO HDR-ADDR-PRT        
                 MOVE SPACES                     TO HDR-CITY-STATE      
                 MOVE 0                          TO HDR-PREMISE         
                                                                        
                PERFORM 8300-WRITE-HDR-DETAILS      THRU  8300-EXIT     
              END-IF.                                                   
                                                                        
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2000-PROCESS-MAIN-CSR.                                          *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-MAIN-CSR.                                           
                                                                        
           MOVE 0                                TO WS-ACCOUNT          
           MOVE 0                                TO AT-ACCOUNT-NO       
                                                                        
           PERFORM 7200-OPEN-GET-ACCOUNTS           THRU  7200-EXIT     
                                                                        
           PERFORM 8300-WRITE-HDR-DETAILS           THRU  8300-EXIT.    
      *                                                                         
           PERFORM 7300-FETCH-GET-ACCOUNTS          THRU  7300-EXIT     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                                                        
              PERFORM 1200-GET-ACCOUNT-DTL          THRU  1200-EXIT     
              UNTIL WS-ALL-ROWS-PROCESD = WS-Y                          
                                                                        
           END-IF.                                                      
                                                                        
           PERFORM 7400-CLOSE-GET-ACCOUNTS          THRU  7400-EXIT.    
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7100-GET-JOB-PARM.                                          **        
      ** GET PARM DATA FROM JOB_PARM TABLE                            **        
      ******************************************************************        
      *                                                                         
       7100-GET-JOB-PARM.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :WS-PARM-DATA                                      
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
               WHERE PROGRAM_NAME = :WS-PROGRAM-NAME                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PARM_DATA                                                  
MFA-TR*         INTO :WS-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE PROGRAM_NAME = :WS-PROGRAM-NAME                            
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
             CONTINUE                                                   
                                                                        
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP001 ABORT *******'                 
              DISPLAY '**  PARM-DATA FETCH FAILED   **'                 
              DISPLAY '**  7100-GET-JOB-PARM        **'                 
              DISPLAY '**  PGM NAME    = ' WS-PROGRAM-NAME              
              DISPLAY '*** PROCESSING TERMINATED *****'                 
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7200-OPEN-GET-ACCOUNTS.                                      **        
      ******************************************************************        
      *                                                                         
       7200-OPEN-GET-ACCOUNTS.                                          
      *                                                                         
           EXEC SQL                                                     
              OPEN GET_ACCOUNTS                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP001 ABORT *******'                 
              DISPLAY '**  OPEN GET ACC CSR ERROR   **'                 
              DISPLAY '**  7200-OPEN-GET-ACCOUNTS   **'                 
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '*** PROCESSING TERMINATED *****'                 
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7300-FETCH-GET-ACCOUNTS                                      **        
      ******************************************************************        
      *                                                                         
       7300-FETCH-GET-ACCOUNTS.                                         
      *                                                                         
           EXEC SQL                                                     
              FETCH GET_ACCOUNTS                                        
               INTO :UT-RATE-PLAN-NO                                    
                   ,:WS-DATE-PRT                                        
                   ,:AT-PREMISE-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
              CONTINUE                                                  
           WHEN NOT-FOUND                                               
              MOVE WS-Y                     TO WS-ALL-ROWS-PROCESD      
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP001 ABORT ********'                
              DISPLAY '**  GET ACCOUNTS  FETCH ERROR **'                
              DISPLAY '**  7300-FETCH-GET-ACCOUNTS   **'                
              DISPLAY '**  UT-RATE-PLAN-NO      =' UT-RATE-PLAN-NO      
              DISPLAY '**  WS-DATE-PRT          =' WS-DATE-PRT          
              DISPLAY '**  AT-PREMISE-NO        =' AT-PREMISE-NO        
              DISPLAY '**  RETURN CODE          =' WS-ACTIVE-RETURN-CODE
              DISPLAY '*** PROCESSING TERMINATED ******'                
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7400-CLOSE-GET-ACCOUNTS                                      **        
      ******************************************************************        
      *                                                                         
       7400-CLOSE-GET-ACCOUNTS.                                         
      *                                                                         
           EXEC SQL                                                     
              CLOSE GET_ACCOUNTS                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP001 ABORT *******'                 
              DISPLAY '**  CLOSE GET ACCOUNTS ERROR **'                 
              DISPLAY '**  7400-CLOSE-GET-ACCOUNTS  **'                 
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '*** PROCESSING TERMINATED *****'                 
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7500-GET-TRANHIST.                                           **        
      ******************************************************************        
      *                                                                         
       7500-GET-TRANHIST.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) AT.ACCOUNT_NO,
              UT.RATE_PLAN_NO,
              MH.DATE_TRANS,
              AT.PREMISE_NO,
              AT.CODE_ACCT_STAT                                  
                INTO :AT-ACCOUNT-NO                                     
                    ,:UT-RATE-PLAN-NO                                   
                    ,:WS-DATE-PRT1                                      
                    ,:AT-PREMISE-NO                                     
                    ,:AT-CODE-ACCT-STAT                                 
                FROM CSS_ACCOUNT        AT WITH(READUNCOMMITTED)                
                    ,CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)                
                    ,CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)                
                    ,CSS_MT_TRN_HST_DET MI WITH(READUNCOMMITTED)                
               WHERE AT.PREMISE_NO        = :AT-PREMISE-NO              
                 AND UT.ACCOUNT_NO        =  AT.ACCOUNT_NO              
                 AND UT.RATE_PLAN_NO      IN ('102', '127', '227')      
                 AND MH.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                           :WS-TRANS-TS
              )               
                 AND MH.TRANS_HIST_SEQ_NO <  CIS.CHAR2TIMESTAMP(
                                                             :WS-END-TS
              )                 
                 AND MH.ACCOUNT_NO        =  AT.ACCOUNT_NO              
                 AND MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO        
                 AND MI.COLUMN_DESC       = 'RATE PLAN NO'              
                ORDER BY 3 DESC                                         
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.ACCOUNT_NO                                              
MFA-TR*             ,UT.RATE_PLAN_NO                                            
MFA-TR*             ,MH.DATE_TRANS                                              
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*         INTO :AT-ACCOUNT-NO                                             
MFA-TR*             ,:UT-RATE-PLAN-NO                                           
MFA-TR*             ,:WS-DATE-PRT1                                              
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*         FROM CSS_ACCOUNT        AT                                      
MFA-TR*             ,CSS_UTIL_ENVRNMT   UT                                      
MFA-TR*             ,CSS_MNT_TRANS_HIST MH                                      
MFA-TR*             ,CSS_MT_TRN_HST_DET MI                                      
MFA-TR*        WHERE AT.PREMISE_NO        = :AT-PREMISE-NO                      
MFA-TR*          AND UT.ACCOUNT_NO        =  AT.ACCOUNT_NO                      
MFA-TR*          AND UT.RATE_PLAN_NO      IN ('102', '127', '227')              
MFA-TR*          AND MH.TRANS_HIST_SEQ_NO >= :WS-TRANS-TS                       
MFA-TR*          AND MH.TRANS_HIST_SEQ_NO <  :WS-END-TS                         
MFA-TR*          AND MH.ACCOUNT_NO        =  AT.ACCOUNT_NO                      
MFA-TR*          AND MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO                
MFA-TR*          AND MI.COLUMN_DESC       = 'RATE PLAN NO'                      
MFA-TR*         ORDER BY 3 DESC                                                 
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP001 ABORT *****'                   
              DISPLAY '** GET TRANHIST ERROR      **'                   
              DISPLAY '** 7500-GET-TRANHIST       **'                   
              DISPLAY '** TRANS DATE  = ' WS-TRANS-TS                   
              DISPLAY '** END  DATE  = ' WS-END-TS                      
              DISPLAY '** PREMISE NO  = ' AT-PREMISE-NO                 
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** PROCESSING TERMINATED ****'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7600-GET-NAME-ADDR.                                          **        
      ******************************************************************        
      *                                                                         
       7600-GET-NAME-ADDR.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT DQ.NAME_FORMAT                                     
                    ,DQ.FIRST_NAME                                      
                    ,DQ.MIDDLE_NAME                                     
                    ,DQ.LAST_NAME                                       
                    ,DQ.FULL_NAME                                       
                    ,DY.HOUSE_NO                                        
                    ,DY.ADDR_PREFIX_1                                   
                    ,DY.ADDR_PREFIX_2                                   
                    ,DY.STREET_NAME                                     
                    ,DY.STREET_SUFFIX                                   
                    ,DY.ADDR_SUFFIX                                     
                    ,DY.STREET_LOCATION_1                               
                    ,DY.STREET_LOCATION_2                               
                    ,DY.ZIP_CODE                                        
                    ,A4.TOWN                                            
                    ,A4.STATE                                           
                INTO :DQ-NAME-FORMAT                                    
                    ,:WS-1ST-NAME                                       
                    ,:WS-MIDDLE-NAME                                    
                    ,:WS-LAST-NAME                                      
                    ,:DQ-FULL-NAME                                      
                    ,:WS-ADDR-HOUSE                                     
                    ,:WS-ADDR-PREF1                                     
                    ,:WS-ADDR-PREF2                                     
                    ,:WS-ADDR-ST                                        
                    ,:WS-ADDR-SUF                                       
                    ,:WS-ADDR-TDIR                                      
                    ,:WS-ADDR-APT                                       
                    ,:WS-ADDR-APTNO                                     
                    ,:DY-ZIP-CODE                                       
                    ,:WS-TOWN                                           
                    ,:WS-STATE                                          
                FROM CSS_ACCOUNT        AT WITH(READUNCOMMITTED)                
                    ,CSS_CUSTOMER       CU WITH(READUNCOMMITTED)                
                    ,CSS_NAME           DQ WITH(READUNCOMMITTED)                
                    ,CSS_PREMISE        PR WITH(READUNCOMMITTED)                
                    ,CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)                
                    ,CSS_ZIP_CODE       A4 WITH(READUNCOMMITTED)                
               WHERE AT.ACCOUNT_NO     = :AT-ACCOUNT-NO                 
                 AND CU.CUSTOMER_NO    = AT.CUSTOMER_NO                 
                 AND DQ.NAME_ID        = CU.NAME_ID                     
                 AND PR.PREMISE_NO     = AT.PREMISE_NO                  
                 AND DY.ADDRESS_ID     = PR.ADDRESS_ID                  
                 AND A4.ZIP_CODE       = DY.ZIP_CODE                    
                 AND A4.ZIP_CODE_TOKEN = DY.ZIP_CODE_TOKEN              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DQ.NAME_FORMAT                                             
MFA-TR*             ,DQ.FIRST_NAME                                              
MFA-TR*             ,DQ.MIDDLE_NAME                                             
MFA-TR*             ,DQ.LAST_NAME                                               
MFA-TR*             ,DQ.FULL_NAME                                               
MFA-TR*             ,DY.HOUSE_NO                                                
MFA-TR*             ,DY.ADDR_PREFIX_1                                           
MFA-TR*             ,DY.ADDR_PREFIX_2                                           
MFA-TR*             ,DY.STREET_NAME                                             
MFA-TR*             ,DY.STREET_SUFFIX                                           
MFA-TR*             ,DY.ADDR_SUFFIX                                             
MFA-TR*             ,DY.STREET_LOCATION_1                                       
MFA-TR*             ,DY.STREET_LOCATION_2                                       
MFA-TR*             ,DY.ZIP_CODE                                                
MFA-TR*             ,A4.TOWN                                                    
MFA-TR*             ,A4.STATE                                                   
MFA-TR*         INTO :DQ-NAME-FORMAT                                            
MFA-TR*             ,:WS-1ST-NAME                                               
MFA-TR*             ,:WS-MIDDLE-NAME                                            
MFA-TR*             ,:WS-LAST-NAME                                              
MFA-TR*             ,:DQ-FULL-NAME                                              
MFA-TR*             ,:WS-ADDR-HOUSE                                             
MFA-TR*             ,:WS-ADDR-PREF1                                             
MFA-TR*             ,:WS-ADDR-PREF2                                             
MFA-TR*             ,:WS-ADDR-ST                                                
MFA-TR*             ,:WS-ADDR-SUF                                               
MFA-TR*             ,:WS-ADDR-TDIR                                              
MFA-TR*             ,:WS-ADDR-APT                                               
MFA-TR*             ,:WS-ADDR-APTNO                                             
MFA-TR*             ,:DY-ZIP-CODE                                               
MFA-TR*             ,:WS-TOWN                                                   
MFA-TR*             ,:WS-STATE                                                  
MFA-TR*         FROM CSS_ACCOUNT        AT                                      
MFA-TR*             ,CSS_CUSTOMER       CU                                      
MFA-TR*             ,CSS_NAME           DQ                                      
MFA-TR*             ,CSS_PREMISE        PR                                      
MFA-TR*             ,CSS_ADDR_FORMATTED DY                                      
MFA-TR*             ,CSS_ZIP_CODE       A4                                      
MFA-TR*        WHERE AT.ACCOUNT_NO     = :AT-ACCOUNT-NO                         
MFA-TR*          AND CU.CUSTOMER_NO    = AT.CUSTOMER_NO                         
MFA-TR*          AND DQ.NAME_ID        = CU.NAME_ID                             
MFA-TR*          AND PR.PREMISE_NO     = AT.PREMISE_NO                          
MFA-TR*          AND DY.ADDRESS_ID     = PR.ADDRESS_ID                          
MFA-TR*          AND A4.ZIP_CODE       = DY.ZIP_CODE                            
MFA-TR*          AND A4.ZIP_CODE_TOKEN = DY.ZIP_CODE_TOKEN                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7800                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP001 ABORT *******'                 
              DISPLAY '**  GET NAME ADDR ERROR      **'                 
              DISPLAY '**  7600-GET-NAME-ADDR       **'                 
              DISPLAY '**  RETURN CODE        =' WS-ACTIVE-RETURN-CODE  
              DISPLAY '**  AT-ACCOUNT-NO      =' AT-ACCOUNT-NO          
              DISPLAY '*** PROCESSING TERMINATED *****'                 
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7700-GET-SERVICE-ORDER                                       **        
      ******************************************************************        
      *                                                                         
       7700-GET-SERVICE-ORDER.                                          
      *                                                                         
                                                                        
           EXEC SQL                                                     
              SELECT VO.ACCOUNT_NO                                      
                    ,VO.PREMISE_NO                                      
                    ,VO.SERV_ORDER_NO                                   
                    ,VO.ACCOUNT_NO_PRIOR                                
                    ,VE.RATE_PLAN_NO                                    
                INTO :VO-ACCOUNT-NO                                     
                    ,:VO-PREMISE-NO                                     
                    ,:VO-SERV-ORDER-NO                                  
                    ,:VO-ACCOUNT-NO-PRIOR                               
                    ,:VE-RATE-PLAN-NO                                   
                FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                       
                    ,CSS_SO_UTL_CHG VE WITH(READUNCOMMITTED)                    
               WHERE  VO.PREMISE_NO    = :AT-PREMISE-NO                 
                 AND  VO.SERV_ORDER_NO = VE.SERV_ORDER_NO               
                 AND  VO.COMPLETED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                           :WS-TRANS-TS
              )             
                 AND  VO.COMPLETED_DATETIME <  CIS.CHAR2TIMESTAMP(
                                                             :WS-END-TS
              )               
                 AND  VE.RATE_PLAN_NO IN ('102', '127', '227')          
                  AND NOT EXISTS ( SELECT 1                             
                 FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                WHERE UT.ACCOUNT_NO = VO.ACCOUNT_NO_PRIOR               
                 AND  UT.RATE_PLAN_NO IN ('102', '127', '227'))         
             UNION                                                      
              SELECT YV.ACCOUNT_NO                                      
                    ,YV.PREMISE_NO                                      
                    ,YV.SERV_ORDER_NO                                   
                    ,YV.ACCOUNT_NO_PRIOR                                
                    ,OM.RATE_PLAN_NO
            FROM HST_SO_DATA YV WITH(READUNCOMMITTED)                           
                    ,HST_SO_UTL_CHG OM WITH(READUNCOMMITTED)
            WHERE  YV.PREMISE_NO    = :AT-PREMISE-NO                
                  AND  YV.SERV_ORDER_NO = OM.SERV_ORDER_NO              
                  AND  YV.COMPLETED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                           :WS-TRANS-TS
              )            
                  AND  YV.COMPLETED_DATETIME <  CIS.CHAR2TIMESTAMP(
                                                             :WS-END-TS
              )              
                  AND  OM.RATE_PLAN_NO IN ('102', '127', '227')         
                   AND NOT EXISTS ( SELECT 1                            
                  FROM CSS_UTIL_ENVRNMT UT1 WITH(READUNCOMMITTED)               
                 WHERE UT1.ACCOUNT_NO = YV.ACCOUNT_NO_PRIOR             
                  AND  UT1.RATE_PLAN_NO IN ('102', '127', '227'))       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ052
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT VO.ACCOUNT_NO                                              
MFA-TR*             ,VO.PREMISE_NO                                              
MFA-TR*             ,VO.SERV_ORDER_NO                                           
MFA-TR*             ,VO.ACCOUNT_NO_PRIOR                                        
MFA-TR*             ,VE.RATE_PLAN_NO                                            
MFA-TR*         INTO :VO-ACCOUNT-NO                                             
MFA-TR*             ,:VO-PREMISE-NO                                             
MFA-TR*             ,:VO-SERV-ORDER-NO                                          
MFA-TR*             ,:VO-ACCOUNT-NO-PRIOR                                       
MFA-TR*             ,:VE-RATE-PLAN-NO                                           
MFA-TR*         FROM CSS_SO_DATA VO                                             
MFA-TR*             ,CSS_SO_UTL_CHG VE                                          
MFA-TR*        WHERE  VO.PREMISE_NO    = :AT-PREMISE-NO                         
MFA-TR*          AND  VO.SERV_ORDER_NO = VE.SERV_ORDER_NO                       
MFA-TR*          AND  VO.COMPLETED_DATETIME >= :WS-TRANS-TS                     
MFA-TR*          AND  VO.COMPLETED_DATETIME <  :WS-END-TS                       
MFA-TR*          AND  VE.RATE_PLAN_NO IN ('102', '127', '227')                  
MFA-TR*           AND NOT EXISTS ( SELECT 1                                     
MFA-TR*          FROM CSS_UTIL_ENVRNMT UT                                       
MFA-TR*         WHERE UT.ACCOUNT_NO = VO.ACCOUNT_NO_PRIOR                       
MFA-TR*          AND  UT.RATE_PLAN_NO IN ('102', '127', '227'))                 
MFA-TR*      UNION                                                              
MFA-TR*       SELECT YV.ACCOUNT_NO                                              
MFA-TR*             ,YV.PREMISE_NO                                              
MFA-TR*             ,YV.SERV_ORDER_NO                                           
MFA-TR*             ,YV.ACCOUNT_NO_PRIOR                                        
MFA-TR*             ,OM.RATE_PLAN_NO                                            
MFA-TR*         INTO :VO-ACCOUNT-NO                                             
MFA-TR*             ,:VO-PREMISE-NO                                             
MFA-TR*             ,:VO-SERV-ORDER-NO                                          
MFA-TR*             ,:VO-ACCOUNT-NO-PRIOR                                       
MFA-TR*             ,:VE-RATE-PLAN-NO                                           
MFA-TR*         FROM HST_SO_DATA YV                                             
MFA-TR*             ,HST_SO_UTL_CHG OM                                          
MFA-TR*         WHERE  YV.PREMISE_NO    = :AT-PREMISE-NO                        
MFA-TR*           AND  YV.SERV_ORDER_NO = OM.SERV_ORDER_NO                      
MFA-TR*           AND  YV.COMPLETED_DATETIME >= :WS-TRANS-TS                    
MFA-TR*           AND  YV.COMPLETED_DATETIME <  :WS-END-TS                      
MFA-TR*           AND  OM.RATE_PLAN_NO IN ('102', '127', '227')                 
MFA-TR*            AND NOT EXISTS ( SELECT 1                                    
MFA-TR*           FROM CSS_UTIL_ENVRNMT UT1                                     
MFA-TR*          WHERE UT1.ACCOUNT_NO = YV.ACCOUNT_NO_PRIOR                     
MFA-TR*           AND  UT1.RATE_PLAN_NO IN ('102', '127', '227'))               
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7900                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP001 ABORT *****'                   
              DISPLAY '** GET SERVICE ORDER ERROR **'                   
              DISPLAY '** 7700-GET-SERVICE-ORDER  **'                   
              DISPLAY '** AT-PREMISE-NO      =' AT-PREMISE-NO           
              DISPLAY '** WS-TRANS-TIMESTAMP =' WS-TRANS-TIMESTAMP      
              DISPLAY '** WS-END-TIMESTAMP   =' WS-END-TIMESTAMP        
              DISPLAY '** RETURN CODE        =' WS-ACTIVE-RETURN-CODE   
              DISPLAY '** PROCESSING TERMINATED ****'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08150000
      **                                                            **  08160000
      **   7800-UPDATE-JOB-PARM-TBL.                                **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       7800-UPDATE-JOB-PARM-TBL.                                        
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_JOB_PARM                                        
                  SET PARM_DATA  = :G6-PARM-DATA                        
                  WHERE PROGRAM_NAME = 'PCSRP001'                       
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
                CONTINUE                                                
                                                                        
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP001 ABORT ******'                  
              DISPLAY '**  JOB PARM UPDATE FAILED  **'                  
              DISPLAY '** 7800-UPDATE-JOB-PARM-TBL **'                  
              DISPLAY '** G6-PARM-DATA= ' G6-PARM-DATA                  
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** PROCESSING TERMINATED *****'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8000-OPEN-OUTFILE.                                       **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8000-OPEN-OUTFILE.                                               
      *                                                                 08230000
           OPEN OUTPUT FCSPT182-FILE.                                   
                                                                        
           IF NOT FCA182-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSPT182-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA182-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 08335000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8200-WRITE-OUTFILE-DETAILS                               **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8200-WRITE-OUTFILE-DETAILS.                                      
      *                                                                 08230000
                                                                        
           WRITE PRT182-RECORD FROM WS-RP182-OUT-REC.                   
      *                                                                 08335000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8300-WRITE-HDR-DETAILS                                   **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8300-WRITE-HDR-DETAILS.                                          
      *                                                                 08230000
           WRITE PRT182-RECORD FROM WS-RP182-HDR-REC.                   
      *                                                                 08335000
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8900-CLOSE-OUTFILE                                       **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8900-CLOSE-OUTFILE.                                              
      *                                                                 08230000
           CLOSE FCSPT182-FILE.                                         
                                                                        
           IF NOT FCA182-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR CLOSING FCSPT182-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA182-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 08335000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      *                                                                         
      ****************************************************************  08384100
      **                                                            **  08384200
      **   9000-TERMINATE                                           **  08384300
      **       CLOSES FILES AND TERMINATES THE PROGRAM              **  08384400
      **                                                            **  08384500
      ****************************************************************  08384600
      *                                                                 08384700
       9000-TERMINATE.                                                  
      *                                                                 08409300
           PERFORM 8900-CLOSE-OUTFILE               THRU  8900-EXIT.    
      *                                                                 08420000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08450000
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
