       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSMT659.                                        
       DATE-WRITTEN.   JULY 1997.                                       
      ***************************************************************** 00040000
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               ** 00050085
      **        SCE&G, COMPLETE BUSINESS SOLUTIONS INDIA LTD.        ** 00060085
      **                     MADRAS, INDIA                           ** 00070085
      ********            CUSTOMER SERVICE SYSTEM             ********* 00080000
      ********                      DB2                       ********* 00090000
      ***************************************************************** 00100000
      **                                                             ** 00110000
      **               PROGRAM  MODIFICATION  LOG                    ** 00120085
      **                                                             ** 00130000
      **    DATE     INITIALS                 REASON                 ** 00140085
      **  ________   ________   ___________________________________  ** 00150085
      **                                                             ** 00160085
T15090**    03/98      CBSI     CHANGES MADE WHILE TESTING ELECTRIC  ** 00170000
T15090**                        METER SAMPLE TEST PLAN               ** 00180000
T15090**                                                             ** 00190000
T21537**    01/00      SREENI   CHANGES MADE TO GENERATE A REPORT OF ** 00170000
T21537**                        ALL THE TEST RESULTS.                ** 00180000
T22243**11/27/2000     CBSI     CHANGES MADE TO IMPLEMENT MULTI-     **         
T22243**               MADRAS   COMPANY IN METER INVENTORY.          **         
C31091**07/14/2004     VD88125  SELECT MTR_TEST_GRP_TX FROM MTR_TEST_**         
C31091**                        HIST TABLE INSTEAD CSS_MTR_TEST_GROUP**         
C33235**10/03/2005     SG18894  CHANGES MADE TO ALL THE CALCULATIONS **         
C33235**                        TO ROUND CORRECTLY                   **         
T33287**11/16/2005     JC91900  CONVERT ALL COMPONENTS RELATED TO ELE**         
T33287**                        SUBSYSTEM TO ELC.                    **         
ACT116**06/05/2014     BD09555  INCREASE PRECISION ON TOTAL DEVIATION.*         
ACT116**A04880-ACT116           ADD ONE MORE DECIMAL PLACE ON LEFT   **         
ACT116**                        FOR PERCENTAGES PRINTED ON REPORT.   **         
A05136**07/31/2015     DB41297  REMOVE COMMENTED CODE.               **         
      ***************************************************************** 00161085
           REMARKS.                                                     
                              PCSMT659 NARRATIVE                        
      ******************************************************************00190085
      *                 ELECTRIC METER SAMPLING ANALYSIS               *00200099
      *         THIS PROGRAM ANALYZES THE RESULTS OF EACH SAMPLE TEST  *00201099
      *         GROUP. THE PROGRAM CAN BE RUN IN REPORT/UPDATE MODE.   *00210085
      *         WHEN THE PROGRAM IS RUN IN REPORT MODE, IT PRODUCES    *00220085
      *         A REPORT OF THE ANALYSIS RESULTS. WHEN THE PROGRAM IS  *00230085
      *         RUN IN UPDATE MODE, IT WILL UPDATE TABLES MTR_TEST_HIST*00240085
      *         MTR_TEST_STATS AND PRODUCES A REPORT.                  *00250085
      ******************************************************************00260085
      *                                                                 00270085
                     ---- BASIC BATCH SEQUENCE STRUCTURE ----           
                    0000 - 0000     MAIN CONTROL PATH                   
                    1000 - 1999     INITIALIZATION                      
                    2000 - 4999     MAJOR PROCESSING LOOP               
                    5000 - 5999     COMMON PROGRAM MODULES              
                    7000 - 7999     SQL MODULES                         
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
HPCCDM*EJECT                                                            00400000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
       SPECIAL-NAMES.      C01 IS NEW-PAGE.                             
      *                                                                 00460000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSMT06.                                                    00490006
       COPY CSSMT14.                                                    00500074
       COPY CSSPT33.                                                    00501086
       COPY CSSP232.                                                    00540099
T21537 COPY CSSP233.                                                    00550001
      *                                                                 00570000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDMT06.                                                    00600006
       COPY FIOMT06.                                                    00610006
       COPY CFDMT14.                                                    00620074
       COPY FIOMT14.                                                    00630074
       COPY CFDPT33.                                                    00631086
       COPY CFDP232.                                                    00640099
T21537 COPY CFDP233.                                                    00650001
      *                                                                 00760006
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSMT659'.
MSQ017     COPY MFASQLM.
       01  WS-START                            PIC X(40) VALUE          
           'WORKING STORAGE FOR PCSMT659 STARTS HERE'.                  
      *                                                                 00800000
T33287 COPY ELCHSAMP.                                                   00810029
       01  WS-B5-PERCENT-DEFECTIVE-TABLE.                               
           05  WS-B5-TABLE-ENTRY OCCURS 355 TIMES.                      
               15  WS-B5-QUALITY-INDEX         PIC 99V99.               
               15  WS-B5-EST-PCT-DEFEC OCCURS 16 TIMES                  
                                               PIC 99V999.              
      *                                                                 00870003
       01  WS-B5-SAMPLE-SIZE-TABLE.                                     
           05  WS-B5-SAMPLE-SIZE-DATA.                                  
               15  FILLER                      PIC 999   VALUE 3.       
               15  FILLER                      PIC 999   VALUE 4.       
               15  FILLER                      PIC 999   VALUE 5.       
               15  FILLER                      PIC 999   VALUE 7.       
               15  FILLER                      PIC 999   VALUE 10.      
               15  FILLER                      PIC 999   VALUE 15.      
               15  FILLER                      PIC 999   VALUE 20.      
               15  FILLER                      PIC 999   VALUE 25.      
               15  FILLER                      PIC 999   VALUE 30.      
               15  FILLER                      PIC 999   VALUE 35.      
               15  FILLER                      PIC 999   VALUE 40.      
               15  FILLER                      PIC 999   VALUE 50.      
               15  FILLER                      PIC 999   VALUE 75.      
               15  FILLER                      PIC 999   VALUE 100.     
               15  FILLER                      PIC 999   VALUE 150.     
               15  FILLER                      PIC 999   VALUE 200.     
           05  WS-B5-SAMPLE-SIZE-OCCURS REDEFINES                       
                                          WS-B5-SAMPLE-SIZE-DATA.       
               15  WS-B5-SAMPLE-SIZE-MAX OCCURS 16 TIMES                
                                               PIC 999.                 
      *                                                                 01100003
       01  WS-TEST-RESULT-TABLE.                                        
           05  WS-TEST-RESULT-ENTRY OCCURS 300 TIMES.                   
               15  WS-TEST-FULL-LOAD-ACCU-AF   PIC 999V999.             
               15  WS-TEST-IS-A-DOG-FLAG       PIC X        VALUE 'N'.  
                   88  WS-TEST-IS-A-DOG                     VALUE 'Y'.  
                   88  WS-TEST-IS-NOT-A-DOG                 VALUE 'N'.  
      *                                                                 01170003
       01  WS-TEST-VARIABLES.                                           
           05  WS-TEST-SUB                     PIC 9(3)     VALUE 0.    
           05  WS-SIZE-SUB                     PIC 9(3)     VALUE 0.    
           05  WS-METER-SUB                    PIC 9(3)     VALUE 0.    
           05  WS-QL-SUB                       PIC 9(3)     VALUE 0.    
           05  WS-NBR-TESTS                    PIC 9(3)     VALUE 0.    
           05  WS-NBR-TEST-RECS                PIC 9(5)     VALUE 0.    
           05  WS-UPPER-QUAL-LIMIT             PIC 9(3)     VALUE 0.    
           05  WS-LOWER-QUAL-LIMIT             PIC 9(3)     VALUE 0.    
           05  WS-NBR-TESTS-WO-DOGS            PIC 9(5)     VALUE 0.    
           05  WS-POPULATION-SIZE              PIC 9(7)     VALUE 0.    
           05  WS-MEAN-DOG-TEST                PIC 9(3)V999 VALUE 0.    
           05  WS-MEAN-DOG-LIMIT               PIC 9(5)V999 VALUE 0.    
T15090     05  WS-MEAN-DOG-LIMIT-U             PIC 9(5)V999 VALUE 0.    
T15090     05  WS-MEAN-DOG-LIMIT-L             PIC 9(5)V999 VALUE 0.    
T15090     05  WS-CORRECT-FACT                 PIC 9(9)V9(5) VALUE 0.   
ACT116     05  WS-TOTAL-DEVIATION              PIC 9(5)V9999 VALUE 0.   
           05  WS-TOT-EST-PCT-DEFEC            PIC 9(3)V999 VALUE 0.    
           05  WS-TOT-EST-PCT-DEFEC-E          PIC Z(2)9.999.           
           05  WS-SAMPL-MAX-PCT-DEFEC          PIC 9(2)V99  VALUE 0.    
           05  WS-SAMPL-MAX-PCT-DEFEC-E        PIC Z9.99.               
           05  WS-EST-PCT-DEFEC                PIC 9(2)V999 VALUE 0.    
           05  WS-QUALITY-INDEX                PIC S999V99  COMP-3      
               VALUE +0.                                                
           05  WS-PERFORMANCE-MESSAGE          PIC X(46)    VALUE       
               SPACES.                                                  
           05  WS-COMPARISON-LITERAL           PIC X(02)    VALUE       
               SPACES.                                                  
           05  WS-TOTAL-FULL-LOAD-ACCU-AF      PIC 9(5)V999 VALUE 0.    
      *                                                                 01410018
       01  WS-PARM-DATA.                                                
           05  FILLER                          PIC X(13)  VALUE SPACES. 
           05  WS-GRP-CD                       PIC X(02)  VALUE SPACES. 
           05  FILLER                          PIC X(65)  VALUE SPACES. 
      *                                                                 01460023
       01  WS-UPDATE-REPORT.                                            
           05  FILLER                          PIC X(11)  VALUE SPACES. 
           05  WS-RUNTYPE                      PIC X(06)  VALUE SPACES. 
           05  FILLER                          PIC X(63)  VALUE SPACES. 
      *                                                                 01510046
       01  WS-END-OF-DATA.                                              
           05  FILLER                          PIC X(57)  VALUE SPACES. 
           05  FILLER                          PIC X(20)  VALUE         
               '***END OF REPORT*** '.                                  
           05  FILLER                          PIC X(55)  VALUE SPACES. 
      *                                                                 01561085
T21537 01  WS-NO-DATA-LINE.                                             
T21537     05  FILLER                  PIC X(55)    VALUE SPACES.       
T21537     05  FILLER                  PIC X(22)    VALUE               
T21537               '***NO DATA THIS RUN***'.                          
T21537     05  FILLER                  PIC X(55)    VALUE SPACES.       
T21537*                                                                 02720000
       01  WS-LITERALS.                                                 
           05  WS-ONE                          PIC 9(02)  VALUE 1.      
           05  WS-A                            PIC X(01)  VALUE 'A'.    
           05  WS-N                            PIC X(01)  VALUE 'N'.    
           05  WS-Y                            PIC X(01)  VALUE 'Y'.    
           05  WS-P                            PIC X(01)  VALUE 'P'.    
           05  WS-R                            PIC X(01)  VALUE 'R'.    
           05  WS-E                            PIC X(01)  VALUE 'E'.    
           05  WS-F                            PIC X(01)  VALUE 'F'.    
           05  WS-G                            PIC X(01)  VALUE 'G'.    
T21537     05  WS-J                            PIC X(01)  VALUE 'J'.    
           05  WS-NO                           PIC X(01)  VALUE 'N'.    
           05  WS-YES                          PIC X(01)  VALUE 'Y'.    
           05  WS-COMP-NO                      PIC X(2)   VALUE '01'.   
T22243     05  WS-SYSIN-COMP-NO                PIC X(2)   VALUE SPACES. 
           05  WS-UPDATE                       PIC X(06)  VALUE         
               'UPDATE'.                                                
           05  WS-REPORT                       PIC X(06)  VALUE         
               'REPORT'.                                                
           05  WS-PGRMNAME                     PIC X(08)  VALUE         
               'PCSMT659'.                                              
      *                                                                 01780000
       01  WS-MISC.                                                     
           05  WS-SUB                          PIC 9(03)  VALUE ZEROES. 
           05  WS-SUB1                         PIC 9(03)  VALUE ZEROES. 
           05  WS-LINE-COUNT                   PIC 9(02)  VALUE 57.     
           05  WS-ERR-COUNT                    PIC 9(02)  VALUE 57.     
T21537     05  WS-DTL-COUNT                    PIC 9(02)  VALUE 57.     
           05  WS-PAGE-COUNT                   PIC 9(03)  VALUE ZEROES. 
           05  WS-ERR-PAGE-NO                  PIC 9(03)  VALUE ZEROES. 
T21537     05  WS-DTL-PAGE-NO                  PIC 9(03)  VALUE ZEROES. 
           05  WS-MAX-B5-ROWS                  PIC 9(03)  VALUE 355.    
T21537     05  WS-AVG-LOAD                     PIC 9(3)V9 VALUE 0.      
T15090     05  WS-ZERO-SAMPLE-MIN-QT           PIC X(01)  VALUE SPACES. 
T22243     05  WS-DATE-LAST-INDICATOR          PIC S9(04) COMP.         
      *                                                                 01860078
       01  WS-SWITCHES.                                                 
           05  WS-B5-FOUND                     PIC X(01)  VALUE 'N'.    
               88  B5-FOUND                               VALUE 'Y'.    
               88  B5-NOT-FOUND                           VALUE 'N'.    
           05  WS-B3-FOUND                     PIC X(01)  VALUE 'N'.    
               88  B3-FOUND                               VALUE 'Y'.    
               88  B3-NOT-FOUND                           VALUE 'N'.    
           05  WS-GROUP-CD-FOUND               PIC X(01)  VALUE 'N'.    
               88  GROUP-CD-FOUND                         VALUE 'Y'.    
               88  GROUP-CD-NOT-FOUND                     VALUE 'N'.    
           05  WS-FILE-FLAG                    PIC X(01)  VALUE 'Y'.    
               88  MORE-RECORDS                           VALUE 'Y'.    
               88  NO-MORE-RECORDS                        VALUE 'N'.    
           05  WS-UPDATE-FLAG                  PIC X(01)  VALUE 'N'.    
               88  UPDATE-FLAG                            VALUE 'Y'.    
           05  WS-FMT14-STATUS                 PIC X(02)  VALUE '00'.   
               88  FMT14-SUCCESS                          VALUE '00'.   
           05  WS-FMT06-STATUS                 PIC X(02)  VALUE '00'.   
               88  FMT06-SUCCESS                          VALUE '00'.   
T21537     05  WS-END-PROCESS                  PIC X(01)  VALUE 'N'.    
T21537         88  END-OF-PROCESS                         VALUE 'Y'.    
      *                                                                 02070078
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                           PIC 9(02).               
           05  WS-MM                           PIC 9(02).               
           05  WS-SS                           PIC 9(02).               
           05  WS-TT                           PIC 9(02).               
      *                                                                 02130000
       COPY CWS00303.                                                   02140000
       COPY CWS09900.                                                   02150000
      *                                                                 02160000
       COPY CWS00004.                                                   02170000
       COPY CWS00010.                                                   02180000
       COPY CWS00301.                                                   02190000
T21537 COPY FIOJC01.                                                            
T21537 COPY FIOCA00.                                                            
T21537 COPY CWS00038.                                                           
T21537 COPY CWS00039.                                                           
T21537 COPY CWS00074.                                                           
T21537 COPY CWS00011.                                                           
      *                                                                 02200000
T21537     EXEC SQL                                                             
T21537         INCLUDE CWS00099                                                 
T21537     END-EXEC.                                                            
      *                                                                 02200000
       01  WS-REPORT-AREA.                                              
           05  HEADER-01.                                               
               10  FILLER                      PIC X(01)  VALUE SPACES. 
               10  FILLER                      PIC X(09)  VALUE         
                   'PCSMT659-'.                                         
               10  HDR-01-SUFFIX               PIC X(02).               
               10  FILLER                      PIC X(40)  VALUE SPACES. 
               10  HDR-01-TITLE                PIC X(31)  VALUE         
                   'SOUTH CAROLINA ELECTRIC AND GAS'.                   
               10  FILLER                      PIC X(28)  VALUE SPACES. 
T21537         10  FILLER                      PIC X(09)  VALUE         
T21537             'RUN DATE:'.                                         
T21537         10  HDR-01-DATE                 PIC X(10).               
      *                                                                 02330000
           05  HEADER-02.                                               
               10  FILLER                      PIC X(46)  VALUE SPACES. 
               10  FILLER                      PIC X(36)  VALUE         
                   'ELECTRIC METERS SAMPLE ANALYSIS FOR '.              
               10  HDR-02-YEAR                 PIC X(04)  VALUE SPACES. 
               10  FILLER                      PIC X(25)  VALUE SPACES. 
               10  FILLER                      PIC X(11)  VALUE         
                   'RUN TIME:  '.                                       
               10  HDR-02-TIME.                                         
                   15 HDR-02-HH                PIC X(02)  VALUE SPACES. 
                   15 FILLER                   PIC X(01)  VALUE ':'.    
                   15 HDR-02-MM                PIC X(02)  VALUE SPACES. 
                   15 FILLER                   PIC X(01)  VALUE ':'.    
                   15 HDR-02-SS                PIC X(02)  VALUE SPACES. 
      *                                                                 02480000
           05  HEADER-02A.                                              
               10  FILLER                      PIC X(36)  VALUE SPACES. 
               10  FILLER                      PIC X(42)  VALUE         
                   'METERS WITH LAST TEST DATE > SELECTION DT,'.        
               10  FILLER                      PIC X(18)  VALUE         
                   ' BUT NO TEST FOUND'.                                
               10  FILLER                      PIC X(19)  VALUE SPACES. 
               10  FILLER                      PIC X(05)  VALUE 'PAGE:'.
               10  FILLER                      PIC X(04)  VALUE SPACES. 
               10  HDR-02A-PAGE                PIC ZZ,ZZ9.              
      *                                                                 02486099
           05  HEADER-03.                                               
               10  FILLER                      PIC X(115) VALUE SPACES. 
               10  FILLER                      PIC X(05)  VALUE 'PAGE:'.
               10  FILLER                      PIC X(04)  VALUE SPACES. 
               10  HDR-03-PAGE                 PIC ZZ,ZZ9.              
      *                                                                 02540000
           05  HEADER-04.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'GROUP TESTED.....................................:'.
               10  FILLER                      PIC X(05)  VALUE SPACES. 
               10  HDR-04-GRP-CD               PIC X(02)  VALUE SPACES. 
               10  FILLER                      PIC X(01)  VALUE SPACES. 
               10  HDR-04-GRP-DESC             PIC X(25)  VALUE SPACES. 
               10  FILLER                      PIC X(37)  VALUE SPACES. 
      *                                                                 02640002
           05  HEADER-05.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'SAMPLE SIZE......................................:'.
               10  FILLER                      PIC X(05)  VALUE SPACES. 
               10  HDR-05-SAMPL-SIZE           PIC ZZZ,ZZ9.             
               10  FILLER                      PIC X(58)  VALUE SPACES. 
      *                                                                 02720002
T15090     05  HEADER-05A.                                              
T15090         10  FILLER                      PIC X(10)  VALUE SPACES. 
T15090         10  HDR-05A-SAMPL-SIZE          PIC X(26)  VALUE SPACES. 
T15090*                                                                 02781006
           05  HEADER-06.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'STANDARD DEVIATION...............................:'.
               10  FILLER                      PIC X(05)  VALUE SPACES. 
               10  HDR-06-STAND-DEV            PIC ZZ9.99.              
               10  FILLER                      PIC X(59)  VALUE SPACES. 
      *                                                                 02800000
           05  HEADER-07.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'X BAR (MEAN).....................................:'.
               10  FILLER                      PIC X(05)  VALUE SPACES. 
               10  HDR-07-XBAR                 PIC ZZ9.99.              
               10  FILLER                      PIC X(59)  VALUE SPACES. 
      *                                                                 02880002
           05  HEADER-08.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'UPPER SPECIFICATION LIMIT U......................:'.
               10  FILLER                      PIC X(05)  VALUE SPACES. 
               10  HDR-08-UPPER-LIM            PIC ZZ9.99.              
               10  FILLER                      PIC X(59)  VALUE SPACES. 
      *                                                                 02960002
           05  HEADER-09.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'LOWER SPECIFICATION LIMIT L......................:'.
               10  FILLER                      PIC X(05)  VALUE SPACES. 
               10  HDR-09-LOWER-LIM            PIC ZZ9.99.              
               10  FILLER                      PIC X(59)  VALUE SPACES. 
      *                                                                 03040002
           05  HEADER-10.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'UPPER QUALITY INDEX..............................:'.
ACT116         10  FILLER                      PIC X(05)  VALUE SPACES. 
ACT116         10  HDR-10-UPPER-INDEX          PIC ZZ9.99.              
               10  FILLER                      PIC X(59)  VALUE SPACES. 
      *                                                                 03120002
           05  HEADER-11.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'LOWER QUALITY INDEX..............................:'.
ACT116         10  FILLER                      PIC X(05)  VALUE SPACES. 
ACT116         10  HDR-11-LOWER-INDEX          PIC ZZ9.99.              
               10  FILLER                      PIC X(59)  VALUE SPACES. 
      *                                                                 03200002
           05  HEADER-12.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'ESTIMATE OF PERCENT DEFECTIVE ABOVE U (TABLE B-5):'.
ACT116         10  FILLER                      PIC X(05)  VALUE SPACES. 
ACT116         10  HDR-12-ABOVE-U              PIC ZZ9.999.             
               10  FILLER                      PIC X(58)  VALUE SPACES. 
      *                                                                 03280002
           05  HEADER-13.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'ESTIMATE OF PERCENT DEFECTIVE BELOW L (TABLE B-5):'.
ACT116         10  FILLER                      PIC X(05)  VALUE SPACES. 
ACT116         10  HDR-13-BELOW-L              PIC ZZ9.999.             
               10  FILLER                      PIC X(58)  VALUE SPACES. 
      *                                                                 03360002
           05  HEADER-14.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'ESTIMATE OF PERCENT DOGS.........................:'.
ACT116         10  FILLER                      PIC X(05)  VALUE SPACES. 
ACT116         10  HDR-14-PER-DOGS             PIC ZZ9.99.              
               10  FILLER                      PIC X(59)  VALUE SPACES. 
      *                                                                 03440002
           05  HEADER-15.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'TOTAL EST. OF PERCENT DEFECTIVE IN GROUP.........:'.
               10  FILLER                      PIC X(05)  VALUE SPACES. 
               10  HDR-15-TOT-DEFEC            PIC ZZ9.999.             
               10  FILLER                      PIC X(58)  VALUE SPACES. 
      *                                                                 03520002
           05  HEADER-16.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'MAX ALLOWED PERCENT DEFEC (TABLE B-3)............:'.
               10  FILLER                      PIC X(05)  VALUE SPACES. 
               10  HDR-16-MAX-ALLOW            PIC ZZ9.999.             
               10  FILLER                      PIC X(58)  VALUE SPACES. 
      *                                                                 03600002
           05  HEADER-17.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(40)  VALUE         
                   'THE TESTED RESULT BASED ON TABLE B-5...:'.          
               10  FILLER                      PIC X(80)  VALUE SPACES. 
      *                                                                 03660002
           05  HEADER-18.                                               
               10  FILLER                      PIC X(20)  VALUE SPACES. 
               10  HDR-18-PER-MESG             PIC X(46)  VALUE SPACES. 
               10  FILLER                      PIC X(01)  VALUE SPACES. 
               10  HDR-18-PART1                PIC X(07).               
               10  FILLER                      PIC X(01)  VALUE SPACES. 
               10  HDR-18-COM-LIT              PIC X(02)  VALUE SPACES. 
               10  FILLER                      PIC X(01)  VALUE SPACES. 
               10  HDR-18-PART2                PIC X(05).               
               10  FILLER                      PIC X(47)  VALUE SPACES. 
      *                                                                 03761084
           05  HEADER-19.                                               
               10  FILLER                      PIC X(130) VALUE SPACES. 
      *                                                                 03770002
           05  ERROR-DETAIL.                                            
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  ERR-METER-NO                PIC X(09)  VALUE SPACES. 
               10  FILLER                      PIC X(05)  VALUE SPACES. 
               10  ERR-DESC                    PIC X(50)  VALUE SPACES. 
               10  FILLER                      PIC X(56)  VALUE SPACES. 
      *                                                                 03840006
T21537     05  WS-RPT3-HDR2.                                            
T21537         10  FILLER                      PIC X(45)  VALUE SPACES. 
T21537         10  FILLER                      PIC X(37)  VALUE         
T21537             'SAMPLE ELEC METER TEST PLAN FOR YEAR '.             
T21537         10  WS-RPT3-YEAR                PIC X(04)  VALUE SPACES. 
T21537         10  FILLER                      PIC X(25)  VALUE SPACES. 
T21537         10  FILLER                      PIC X(11)  VALUE         
T21537             'RUN TIME:  '.                                       
T21537         10  WS-RPT3-TIME.                                        
T21537             15 WS-RPT3-HH               PIC X(02)  VALUE SPACES. 
T21537             15 FILLER                   PIC X(01)  VALUE ':'.    
T21537             15 WS-RPT3-MM               PIC X(02)  VALUE SPACES. 
T21537             15 FILLER                   PIC X(01)  VALUE ':'.    
T21537             15 WS-RPT3-SS               PIC X(02)  VALUE SPACES. 
T21537*                                                                 03841501
T21537     05  WS-RPT3-HDR3.                                            
T21537         10  FILLER                      PIC X(52)  VALUE SPACES. 
T21537         10  FILLER                      PIC X(12)  VALUE         
T21537             'TEST GROUP: '.                                      
T21537         10  WS-RPT3-GRP-CD              PIC X(02)  VALUE SPACES. 
T21537         10  FILLER                      PIC X(01)  VALUE SPACES. 
T21537         10  WS-RPT3-GRP-DESC            PIC X(25)  VALUE SPACES. 
T21537         10  FILLER                      PIC X(23)  VALUE SPACES. 
T21537         10  FILLER                      PIC X(05)  VALUE 'PAGE:'.
T21537         10  FILLER                      PIC X(04)  VALUE SPACES. 
T21537         10  WS-RPT3-PAGE                PIC ZZ,ZZ9.              
T21537*                                                                 03844001
T21537     05  WS-RPT3-HDR4.                                            
T21537         10  FILLER                      PIC X(05).               
T21537         10  FILLER                      PIC X(05) VALUE          
T21537             'METER'.                                             
T21537         10  FILLER                      PIC X(10) VALUE SPACES.  
T21537         10  FILLER                      PIC X(04) VALUE          
T21537             'TEST'.                                              
T21537         10  FILLER                      PIC X(07) VALUE SPACES.  
T21537         10  FILLER                      PIC X(16) VALUE          
T21537             '-   AS FOUND   -'.                                  
T21537         10  FILLER                      PIC X(04) VALUE SPACES.  
T21537         10  FILLER                      PIC X(16) VALUE          
T21537             '-    AS LEFT   -'.                                  
T21537         10  FILLER                      PIC X(66) VALUE SPACES.  
T21537*                                                                 03847601
T21537     05  WS-RPT3-HDR5.                                            
T21537         10  FILLER                      PIC X(05).               
T21537         10  FILLER                      PIC X(06) VALUE          
T21537             'NUMBER'.                                            
T21537         10  FILLER                      PIC X(09) VALUE SPACES.  
T21537         10  FILLER                      PIC X(04) VALUE          
T21537             'DATE'.                                              
T21537         10  FILLER                      PIC X(07) VALUE SPACES.  
T21537         10  FILLER                      PIC X(16) VALUE          
T21537             'FULL LIGHT  AVG '.                                  
T21537         10  FILLER                      PIC X(04) VALUE SPACES.  
T21537         10  FILLER                      PIC X(16) VALUE          
T21537             'FULL LIGHT  AVG '.                                  
T21537         10  FILLER                      PIC X(06) VALUE SPACES.  
T21537         10  FILLER                      PIC X(07) VALUE          
T21537             'ADDRESS'.                                           
T21537         10  FILLER                      PIC X(52) VALUE SPACES.  
T21537*                                                                 03852901
T21537     05  WS-RPT3-DETAIL.                                          
T21537         10  FILLER                      PIC X(04).               
T21537         10  WS-RPT3-MTR-NO              PIC X(09).               
T21537         10  FILLER                      PIC X(04) VALUE SPACES.  
T21537         10  WS-RPT3-DATE-TEST           PIC X(10).               
T21537         10  FILLER                      PIC X(03) VALUE SPACES.  
T21537         10  WS-RPT3-AF-FULL             PIC Z(3).9.              
T21537         10  FILLER                      PIC X(01) VALUE SPACES.  
T21537         10  WS-RPT3-AF-LIGHT            PIC Z(3).9.              
T21537         10  FILLER                      PIC X(01) VALUE SPACES.  
T21537         10  WS-RPT3-AF-AVG              PIC Z(3).9.              
T21537         10  FILLER                      PIC X(03) VALUE SPACES.  
T21537         10  WS-RPT3-AL-FULL             PIC Z(3).9.              
T21537         10  FILLER                      PIC X(01) VALUE SPACES.  
T21537         10  WS-RPT3-AL-LIGHT            PIC Z(3).9.              
T21537         10  FILLER                      PIC X(01) VALUE SPACES.  
T21537         10  WS-RPT3-AL-AVG              PIC Z(3).9.              
T21537         10  FILLER                      PIC X(06) VALUE SPACES.  
T21537         10  WS-RPT3-ADDRESS             PIC X(59).               
      *                                                                 03856501
       01  WS-SYSTEM-DATE.                                              
           05  WS-SYSTEM-YY                    PIC 9(02).               
           05  WS-SYSTEM-MM                    PIC 9(02).               
           05  WS-SYSTEM-DD                    PIC 9(02).               
      *                                                                 03890000
       01  WS-FORMAT-DATE.                                              
           05  WS-FORMAT-MM                    PIC 9(02).               
           05  FILLER                          PIC X(01)  VALUE '/'.    
           05  WS-FORMAT-DD                    PIC 9(02).               
           05  FILLER                          PIC X(01)  VALUE '/'.    
T21537     05  WS-FORMAT-YY                    PIC 9(04).               
      *                                                                 03960000
       01  WS-CURRENT-DATE                     PIC X(10).               
       01  WS-CUR-DATE REDEFINES WS-CURRENT-DATE.                       
           10  WS-CURRENT-YEAR                 PIC 9(04).               
           10  FILLER                          PIC X(01).               
           10  WS-CURRENT-MM                   PIC 9(02).               
           10  FILLER                          PIC X(01).               
           10  WS-CURRENT-DD                   PIC 9(02).               
T21537*                                                                         
T21537 01  WS-TEST-DATE.                                                
T21537     10  WS-TEST-YEAR                    PIC 9(04).               
T21537     10  FILLER                          PIC X(01).               
T21537     10  WS-TEST-MM                      PIC 9(02).               
T21537     10  FILLER                          PIC X(01).               
T21537     10  WS-TEST-DD                      PIC 9(02).               
T15090 01  WS-CURRENT-TIMESTAMP                PIC X(26).               
T21537 01  PROGRAM-NAME                        PIC X(08) VALUE          
T21537     'PCSMT659'.                                                  
T21537 01  RS-RETURN-CODE                      PIC S9(9) VALUE +0 COMP. 
T21537 01  RS-RETURN-CODE-DISP                 PIC S9(9) VALUE +0 COMP. 
      *                                                                 04040000
       01  WS-END                              PIC X(40) VALUE          
           'WORKING STORAGE FOR PCSMT659 ENDS HERE  '.                  
HPCCDM*EJECT                                                            04070000
      *                                                                 04080000
           EXEC SQL                                                     04090000
               INCLUDE SQLCA                                            04100000
           END-EXEC.                                                    04110000
      *                                                                 04180000
      * TABLE DECLARATION FOR CSS_MTR_TEST_HIST****************         04190000
      *                                                                 04200000
           EXEC SQL                                                     04210000
               INCLUDE TBMTRTST                                         04220000
           END-EXEC.                                                    04230000
      *                                                                 04240000
      * TABLE DECLARATION FOR CSS_MTR_TEST_STATS***************         04250000
      *                                                                 04260000
           EXEC SQL                                                     04270000
               INCLUDE TBTSTATS                                         04280000
           END-EXEC.                                                    04290000
      *                                                                 04300000
      * TABLE DECLARATION FOR CSS_ELEC_MTR_TEST****************         04310000
      *                                                                 04320000
           EXEC SQL                                                     04330000
               INCLUDE TBEMTEST                                         04340000
           END-EXEC.                                                    04350000
      *                                                                 04360000
      * TABLE DECLARATION FOR CSS_ELEC_METER*******************         04370000
      *                                                                 04380000
           EXEC SQL                                                     04390000
               INCLUDE TBELMTR                                          04400000
           END-EXEC.                                                    04410000
      *                                                                 04420000
      * TABLE DECLARATION FOR CSS_JOB_PARM ********************         04430000
      *                                                                 04440000
           EXEC SQL                                                     04450000
               INCLUDE TBJBPARM                                         04460000
           END-EXEC.                                                    04470000
      *                                                                 04480000
           EXEC SQL                                                     04490000
T21537         INCLUDE TBEQUIP                                          02740000
T21537     END-EXEC.                                                    02750000
T21537*                                                                         
T21537     EXEC SQL                                                     02730000
T21537         INCLUDE TBACCT                                           02740000
T21537     END-EXEC.                                                    02750000
T21537*                                                                         
T21537     EXEC SQL                                                     02730000
T21537         INCLUDE TBADRFMT                                         02740000
T21537     END-EXEC.                                                    02750000
T21537*                                                                         
T21537     EXEC SQL                                                     02790000
T21537         INCLUDE TBZIPCD                                          02800000
T21537     END-EXEC.                                                    02810000
T21537*                                                                         
T21537     EXEC SQL                                                     02490000
T21537         INCLUDE TBNAME                                           02500000
T21537     END-EXEC.                                                    02510000
T21537*                                                                         
T21537     EXEC SQL                                                             
T21537         INCLUDE TBNMACTX                                                 
T21537     END-EXEC.                                                            
T21537*                                                                         
T21537     EXEC SQL                                                             
T21537         INCLUDE TBCSADRX                                                 
T21537     END-EXEC.                                                            
T21537*                                                                         
T21537     EXEC SQL                                                             
T21537         INCLUDE TBADRFRE                                                 
T21537     END-EXEC.                                                            
T21537*                                                                         
T21537     EXEC SQL                                                             
T21537         INCLUDE TBATMISC                                                 
T21537     END-EXEC.                                                            
T21537*                                                                         
           EXEC SQL                                                     04490000
               INCLUDE CWS00042                                         04500000
           END-EXEC.                                                    04510000
      *                                                                 04520000
      ******************************************************************04530006
      * CURSOR FOR SELECTING FROM CSS_JOB_PARM                        **04540079
      ******************************************************************04550065
           EXEC SQL                                                     
              DECLARE  JOB_PARM CURSOR FOR                              
               SELECT  SEQ_NO                                           
                      ,PARM_DATA                                        
                 FROM  CSS_JOB_PARM                                     
                WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                  
                  AND  COMPANY_NO   = :G6-COMPANY-NO                    
                  AND  CMND_CODE    = :G6-CMND-CODE                     
             ORDER BY  SEQ_NO                                           
           END-EXEC.                                                    
      *                                                                 04660006
      ******************************************************************04670076
      * CURSOR FOR SELECTING FROM CSS_MTR_TEST_HIST WHEN THERE ARE NO **04680076
      * ROWS IN CSS_JOB_PARM WITH TEST GROUP CODE.                    **04690079
      ******************************************************************04700076
           EXEC SQL                                                     
              DECLARE  TEST_GROUP CURSOR FOR                            
               SELECT  MQ.MTR_TEST_GRP_CD                               
                      ,MQ.MTR_TEST_GRP_TX                               
                      ,MQ.STATUS_CD                                     
                      ,MQ.SELECTED_QT                                   
                      ,MQ.SAMPLE_MIN_QT                                 
                      ,MQ.TESTED_QT                                     
                 FROM  CSS_MTR_TEST_HIST  MQ                            
                WHERE  MQ.CODE_UTIL_TYPE  = :MQ-CODE-UTIL-TYPE          
                  AND  MQ.TEST_YEAR       = :MQ-TEST-YEAR               
                  AND  MQ.TEST_SCHED_CD   = :MQ-TEST-SCHED-CD           
T22243            AND  MQ.COMPANY_NO      = :MQ-COMPANY-NO              
             ORDER BY  MQ.MTR_TEST_GRP_CD                               
           END-EXEC.                                                    
      *                                                                 04880006
      ******************************************************************04890076
      * CURSOR FOR SELECTING METERS FOR THE TEST GROUP WHICH HAVE      *04900076
      * BEEN TESTED.                                                   *04910099
      ******************************************************************04920076
           EXEC SQL                                                     
              DECLARE  ELEC_METER CURSOR FOR                            
               SELECT  METER_NO                                         
                      ,ELEC_MTR_CLASS_CD                                
                      ,ELEC_MTR_SPEC_CD                                 
                      ,METER_SIZE_ID                                    
                      ,LAST_TEST_SEL_DT                                 
T22243                ,DATE_LAST_TESTED                                 
                FROM  CSS_ELEC_METER                                    
                WHERE  CODE_UTIL_TYPE    = :EM-CODE-UTIL-TYPE           
                  AND  LAST_TEST_SEL_CD  = :EM-LAST-TEST-SEL-CD         
                  AND  DATE_LAST_TESTED >=  LAST_TEST_SEL_DT            
T22243            AND  COMPANY_NO        = :EM-COMPANY-NO               
           END-EXEC.                                                    
      *                                                                 05050006
      ******************************************************************05060076
      * CURSOR FOR GETTING THE FIRST TEST AFTER METER SELECTED FOR     *05070076
      * SAMPLE TESTING                                                 *05080076
      ******************************************************************05090076
           EXEC SQL                                                     
               DECLARE  METER_TEST CURSOR FOR                           
                SELECT  EQ_TESTER_ID                                    
                       ,TEST_BENCH_ID                                   
                       ,REPAIR_DESC                                     
                       ,LIGHT_LOAD_ACCU_AF                              
                       ,FULL_LOAD_ACCU_AF                               
                       ,POWER_FCTR_ACCU_AF                              
                       ,DATE_TEST                                       
T21537                 ,LIGHT_LOAD_ACCU_AL                              
T21537                 ,FULL_LOAD_ACCU_AL                               
                  FROM  CSS_ELEC_MTR_TEST                               
                 WHERE  CODE_UTIL_TYPE = :ET-CODE-UTIL-TYPE             
                   AND  METER_NO       = :ET-METER-NO                   
                   AND  DATE_TEST     >= IIF(TRY_CONVERT(DATE, 
                                                          :ET-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :ET-DATE-TEST
              ) <> 0) OR (LEN(:ET-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :ET-DATE-TEST
              ), CONVERT(DATE, :ET-DATE-TEST) )                  
T22243             AND  COMPANY_NO     = :ET-COMPANY-NO                 
              ORDER BY DATE_TEST                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05100053
MFA-TR*        DECLARE  METER_TEST CURSOR FOR                           05110083
MFA-TR*         SELECT  EQ_TESTER_ID                                    05120053
MFA-TR*                ,TEST_BENCH_ID                                   05130053
MFA-TR*                ,REPAIR_DESC                                     05140053
MFA-TR*                ,LIGHT_LOAD_ACCU_AF                              05150053
MFA-TR*                ,FULL_LOAD_ACCU_AF                               05160053
MFA-TR*                ,POWER_FCTR_ACCU_AF                              05170053
MFA-TR*                ,DATE_TEST                                       05180054
MFA-TR*                ,LIGHT_LOAD_ACCU_AL                              05150053
MFA-TR*                ,FULL_LOAD_ACCU_AL                               05160053
MFA-TR*           FROM  CSS_ELEC_MTR_TEST                               05190083
MFA-TR*          WHERE  CODE_UTIL_TYPE = :ET-CODE-UTIL-TYPE             05200083
MFA-TR*            AND  METER_NO       = :ET-METER-NO                   05210083
MFA-TR*            AND  DATE_TEST     >= :ET-DATE-TEST                  05220083
MFA-TR*            AND  COMPANY_NO     = :ET-COMPANY-NO                         
MFA-TR*       ORDER BY DATE_TEST                                        05230053
MFA-TR*    END-EXEC.                                                    05240053
      *                                                                 05250053
       LINKAGE SECTION.                                                 
HPCCDM*    EJECT                                                        05270000
       PROCEDURE DIVISION.                                              
      ******************************************************************05290000
      *   CONTROLS MAIN PATH OF PROGRAM                                *05300000
      ******************************************************************05310000
       0000-MAINLINE.                                                   
      *                                                                 05330007
           PERFORM 1000-INITIALIZATION THRU 1000-EXIT.                  
           PERFORM 2000-MAIN-PROCESS THRU 2000-EXIT.                    
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
      *                                                                 05380000
       0000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            05410000
      ******************************************************************05420000
      *   INITIALIZATION ROUTINE                                       *05430000
      ******************************************************************05440000
       1000-INITIALIZATION.                                             
      *                                                                 05460000
           MOVE 01                             TO WS-SUB, WS-SUB1.      
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
      *                                                                 00568500
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT        
               MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE               
           END-IF.                                                      
      *                                                                 05620000
T21537     MOVE WS-INPUT-DATE                  TO WS-TEST-DATE.         
T21537*                                                                         
           MOVE WS-PGRMNAME                    TO G6-PROGRAM-NAME.      
           MOVE WS-COMP-NO                     TO G6-COMPANY-NO.        
           MOVE WS-PARM                        TO G6-CMND-CODE.         
           MOVE 01                             TO G6-SEQ-NO.            
           PERFORM 7500-GET-CURRENT-DATE THRU 7500-EXIT.                
T15090*                                                                 05630000
T15090     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T15090        NEXT SENTENCE                                             
T15090     ELSE                                                         
T15090         DISPLAY '********************************************'   
T15090         DISPLAY '*** NO ROWS FOUND FOR PCSMT659 IN JOB PARM *'   
T15090         DISPLAY '********************************************'   
T15090         PERFORM 9900-ABEND THRU 9900-EXIT                        
T15090     END-IF.                                                      
T15090*                                                                 05720000
T21537     MOVE WS-TEST-YEAR                   TO HDR-02-YEAR           
T21537                                            WS-RPT3-YEAR.         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
      *                                                                 05550000
           MOVE WS-HH                          TO  HDR-02-HH            
T21537                                            WS-RPT3-HH.           
           MOVE WS-MM                          TO  HDR-02-MM            
T21537                                            WS-RPT3-MM.           
           MOVE WS-SS                          TO  HDR-02-SS            
T21537                                            WS-RPT3-SS.           
      *                                                                 05590000
T21537     MOVE WS-CURRENT-YEAR                TO  WS-FORMAT-YY.        
T21537     MOVE WS-CURRENT-MM                  TO  WS-FORMAT-MM.        
T21537     MOVE WS-CURRENT-DD                  TO  WS-FORMAT-DD.        
           MOVE WS-FORMAT-DATE                 TO  HDR-01-DATE.         
      *                                                                 05660000
           OPEN INPUT FCSMT14-FILE.                                     
      *                                                                 05680011
           IF  FMT14-SUCCESS                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY 'FCSMT14  FILE OPEN ERROR'                       
               DISPLAY 'FCSMT14  FILE STATUE IS ==>' WS-FMT14-STATUS    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 05760011
           OPEN OUTPUT FCSMT06-FILE.                                    
           IF  FMT06-SUCCESS                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY 'FCSMT06  FILE OPEN ERROR'                       
               DISPLAY 'FCSMT06  FILE STATUE IS ==>' WS-FMT06-STATUS    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 05850011
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                 05940011
           OPEN OUTPUT FCSP232-FILE.                                    
      *                                                                 06030011
T21537     OPEN OUTPUT FCSP233-FILE.                                    
T21537*                                                                 06032002
           PERFORM 1100-LOAD-B5-PARA THRU 1100-EXIT                     
                 UNTIL NO-MORE-RECORDS OR WS-SUB > WS-MAX-B5-ROWS.      
T22243     PERFORM 1200-ACCEPT-SYSIN-COMP-NO   THRU 1200-EXIT.          
      *                                                                 06060065
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06090000
      ******************************************************************06100083
      ** LOADS THE WORKING STORAGE TABLE WITH TABLE B5 DATA           **06110083
      ******************************************************************06120083
       1100-LOAD-B5-PARA.                                               
           READ FCSMT14-FILE                                            
           AT END                                                       
              SET NO-MORE-RECORDS TO TRUE                               
              GO TO 1100-EXIT                                           
           END-READ.                                                    
      *                                                                 06190083
           IF  FMT14-SUCCESS                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY 'FCSMT14  FILE READ ERROR'                       
               DISPLAY 'FCSMT14  FILE STATUE IS ==>' WS-FMT14-STATUS    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 06270039
           IF  E-FMT14-B5-QUAL-INDEX-FLAG                               
               MOVE E-FMT14-B5-QUALITY-INDEX   TO                       
                                    WS-B5-QUALITY-INDEX (WS-SUB)        
           ELSE                                                         
               PERFORM VARYING WS-SUB1 FROM 1 BY 1 UNTIL WS-SUB1 > 16   
                   MOVE E-FMT14-B5-EST-PCT-DEFEC (WS-SUB1)              
                                               TO                       
                           WS-B5-EST-PCT-DEFEC (WS-SUB, WS-SUB1)        
               END-PERFORM                                              
               ADD 1                           TO WS-SUB                
           END-IF.                                                      
      *                                                                 06380039
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06410039
T22243************************************************************              
T22243* ACCEPTS COMPANY NO FROM SYSIN                                           
T22243************************************************************              
T22243*                                                                         
T22243 1200-ACCEPT-SYSIN-COMP-NO.                                       
T22243     ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
T22243     IF  WS-SYSIN-COMP-NO EQUAL SPACES OR LOW-VALUES              
T22243         MOVE WS-COMP-NO         TO WS-SYSIN-COMP-NO              
T22243     END-IF.                                                      
T22243     MOVE WS-SYSIN-COMP-NO       TO WS-COMP-NO.                   
T22243     MOVE WS-COMP-NO             TO EM-COMPANY-NO                 
T22243                                    EQ-COMPANY-NO                 
T22243                                    ET-COMPANY-NO                 
T22243                                    MQ-COMPANY-NO                 
T22243                                    TS-COMPANY-NO.                
T22243     DISPLAY '*********************************'.                 
T22243     DISPLAY '* JOB IS RUNNING FOR COMPANY =', EM-COMPANY-NO      
T22243     DISPLAY '*********************************'.                 
T22243*                                                                         
T22243 1200-EXIT.                                                       
T22243     EXIT.                                                        
      *                                                                         
      ******************************************************************06420083
      ** FETCHES THE FIRST ROW WITH PGRM NAME PCSMT659, CHECKS FOR    **06430083
      ** RUN TYPE AND SETS UPDATE-FLAG ACCORDINGLY, AND IN THE SECOND **06440083
      ** FETCH, IT CHECKS FOR ROWS WITH TEST GROUP AND SETS GROUP-CD- **06450083
      ** FOUND OR GROUP-CD-NOT-FOUND FLAGS ACCORDINGLY                **06460083
      ******************************************************************06470083
       2000-MAIN-PROCESS.                                               
      *                                                                 06490007
           MOVE WS-PGRMNAME                    TO G6-PROGRAM-NAME.      
           MOVE WS-COMP-NO                     TO G6-COMPANY-NO.        
           MOVE WS-PARM                        TO G6-CMND-CODE.         
           PERFORM 7000-OPEN-JOB-PARM THRU 7000-EXIT.                   
           PERFORM 7010-FETCH-JOB-PARM THRU 7010-EXIT.                  
      *                                                                 06550007
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE G6-PARM-DATA               TO WS-UPDATE-REPORT      
               IF  WS-RUNTYPE EQUAL WS-UPDATE OR WS-REPORT              
                   NEXT SENTENCE                                        
               ELSE                                                     
                   DISPLAY '*******************************************'
                   DISPLAY '***PCSMT659 JOB PARM NOT = UPDATE/REPORT***'
                   DISPLAY '*******************************************'
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           ELSE                                                         
               DISPLAY '********************************************'   
               DISPLAY '*** NO ROWS FOUND FOR PCSMT659 IN JOB PARM *'   
               DISPLAY '********************************************'   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 06720007
           IF  WS-RUNTYPE EQUAL WS-UPDATE                               
               SET UPDATE-FLAG                 TO TRUE                  
           END-IF.                                                      
      *                                                                 06760021
           PERFORM 7010-FETCH-JOB-PARM THRU 7010-EXIT.                  
      *                                                                 06780007
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               SET GROUP-CD-FOUND              TO TRUE                  
           ELSE                                                         
               SET GROUP-CD-NOT-FOUND          TO TRUE                  
           END-IF.                                                      
      *                                                                 06840007
           PERFORM 2100-PARM-OR-TEST-GROUP THRU 2100-EXIT.              
      *                                                                 06860079
           PERFORM 7020-CLOSE-JOB-PARM THRU 7020-EXIT.                  
      *                                                                 06880067
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06910007
      ******************************************************************06920083
      ** BRANCHING OUT TO DIFFERENT PARAGRAPHS BASED ON THE FLAG      **06930083
      ** GROUP-CD-FOUND AND WRITING TRAILER RECORD ON FCSMT06         **06940083
      ******************************************************************06950083
       2100-PARM-OR-TEST-GROUP.                                         
      *                                                                 06970083
           IF  GROUP-CD-FOUND                                           
               PERFORM 2110-SELECT-JOB-PARM THRU 2110-EXIT              
                       UNTIL WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL
           ELSE                                                         
               PERFORM 2120-SELECT-TEST-GRP THRU 2120-EXIT              
           END-IF.                                                      
      *                                                                 07040083
T21537     IF  WS-LINE-COUNT EQUAL 57 AND WS-PAGE-COUNT EQUAL ZEROS     
T21537         ADD  1                          TO WS-PAGE-COUNT         
T21537         MOVE WS-PAGE-COUNT              TO HDR-03-PAGE           
T21537         MOVE '01'                       TO HDR-01-SUFFIX         
T21537         WRITE PRT33-RECORD FROM HEADER-01 AFTER NEW-PAGE         
T21537         WRITE PRT33-RECORD FROM HEADER-02 AFTER 1                
T21537         WRITE PRT33-RECORD FROM HEADER-03 AFTER 1                
T21537         WRITE PRT33-RECORD FROM WS-NO-DATA-LINE AFTER 2          
T21537         MOVE 05                         TO WS-LINE-COUNT         
T21537     ELSE                                                         
T21537         WRITE PRT33-RECORD FROM WS-END-OF-DATA AFTER 2           
T21537     END-IF.                                                      
T21537*                                                                         
T21537     IF  WS-ERR-COUNT EQUAL 57 AND WS-ERR-PAGE-NO EQUAL ZEROS     
T21537         MOVE WS-NO-DATA-LINE            TO ERROR-DETAIL          
T21537         PERFORM 8100-WRITE-ERROR-PARA THRU 8100-EXIT             
T21537     ELSE                                                         
T21537         WRITE PR232-RECORD FROM WS-END-OF-DATA AFTER 2           
T21537     END-IF.                                                      
T21537*                                                                         
T21537     IF  WS-DTL-COUNT EQUAL 57 AND WS-DTL-PAGE-NO EQUAL ZEROS     
T21537         MOVE WS-NO-DATA-LINE            TO WS-RPT3-DETAIL        
T21537         PERFORM 8110-WRITE-DETAIL-RPT THRU 8110-EXIT             
T21537     ELSE                                                         
T21537         WRITE PR233-RECORD FROM WS-END-OF-DATA AFTER 2           
T21537     END-IF.                                                      
      *                                                                 07070083
           IF  UPDATE-FLAG                                              
               MOVE SPACES                     TO                       
                                               E-FMT06-END-RECORD-ID    
               MOVE WS-NBR-TEST-RECS           TO                       
                                               E-FMT06-NBR-TEST-RECS    
               MOVE SPACES                     TO E-FMT06-FILLER01      
               PERFORM 8150-WRITE-FIOMT06 THRU 8150-EXIT                
           END-IF.                                                      
      *                                                                 07160083
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07190083
      ******************************************************************07200083
      ** CONTROL COMES TO THIS WHEN ROWS ARE PRESENT WITH GROUP CODE  **07210083
      ** IN CSS_JOB_PARM                                              **07220083
      ******************************************************************07230083
       2110-SELECT-JOB-PARM.                                            
      *                                                                 07250083
           MOVE G6-PARM-DATA                   TO WS-PARM-DATA.         
           MOVE WS-E                           TO MQ-CODE-UTIL-TYPE.    
T21537     MOVE WS-TEST-YEAR                   TO MQ-TEST-YEAR.         
           MOVE WS-R                           TO MQ-TEST-SCHED-CD.     
           MOVE WS-GRP-CD                      TO MQ-MTR-TEST-GRP-CD.   
           PERFORM 7050-SELECT-TEST-HIST THRU 7050-EXIT.                
           PERFORM 3000-EXTRACT-ANALYZE-TEST-GRP THRU 3000-EXIT.        
           PERFORM 7010-FETCH-JOB-PARM THRU 7010-EXIT.                  
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07360067
      ******************************************************************07370083
      ** CONTROL COMES TO THIS WHEN ROWS ARE NOT PRESENT WITH GROUP CD**07380083
      ** IN CSS_JOB_PARM                                              **07390083
      ******************************************************************07400083
       2120-SELECT-TEST-GRP.                                            
      *                                                                 07420022
           MOVE WS-E                           TO MQ-CODE-UTIL-TYPE.    
T21537     MOVE WS-TEST-YEAR                   TO MQ-TEST-YEAR.         
           MOVE WS-R                           TO MQ-TEST-SCHED-CD.     
           PERFORM 7060-OPEN-TEST-GROUP THRU 7060-EXIT.                 
           PERFORM 7070-FETCH-TEST-GROUP THRU 7070-EXIT.                
      *                                                                 07480022
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL    
T21537         MOVE 'N'                        TO  WS-END-PROCESS       
               PERFORM 3000-EXTRACT-ANALYZE-TEST-GRP THRU 3000-EXIT     
               PERFORM 7070-FETCH-TEST-GROUP THRU 7070-EXIT             
           END-PERFORM.                                                 
      *                                                                 07530022
           PERFORM 7080-CLOSE-TEST-GROUP THRU 7080-EXIT.                
      *                                                                 07550022
       2120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07580022
      ******************************************************************07590083
      ** GETTING FULL-LOAD-ACCU-AF AND OTHER DETAILS FROM DIFFERENT   **07600083
      ** TABLES AND CALCULATING MEAN, STANDARD DEVIATION WITH & WITHOUT*07610083
      ** DOGS FOR METERS TESTED AFTER SELECTING                       **07620083
      ******************************************************************07630083
       3000-EXTRACT-ANALYZE-TEST-GRP.                                   
           INITIALIZE WS-TEST-RESULT-TABLE.                             
           MOVE ZEROES                         TO WS-TEST-SUB           
                                                  WS-NBR-TESTS          
                                             WS-TOTAL-FULL-LOAD-ACCU-AF.
           MOVE WS-E                           TO EM-CODE-UTIL-TYPE.    
           MOVE MQ-MTR-TEST-GRP-CD             TO EM-LAST-TEST-SEL-CD.  
      *                                                                 07710023
           PERFORM 7110-OPEN-ELEC-METER THRU 7110-EXIT.                 
           PERFORM 7120-FETCH-ELEC-METER THRU 7120-EXIT.                
           PERFORM 3100-SELECT-METER-CURSOR THRU 3100-EXIT              
T21537               UNTIL ( WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL
T21537                OR END-OF-PROCESS ).                              
           PERFORM 7130-CLOSE-ELEC-METER THRU 7130-EXIT.                
      *                                                                 07770035
           IF  WS-NBR-TESTS NOT = MQ-TESTED-QT                          
               MOVE WS-NBR-TESTS               TO MQ-TESTED-QT          
           END-IF.                                                      
           MOVE WS-NBR-TESTS                   TO TS-ANALYSIS-QT.       
      *                                                                 07820077
      ****************************************************************  07830077
      * CALCULATE MEAN WITH DOGS FOR FULL LOAD ACCURACY TEST RESULTS *  07840077
      ****************************************************************  07850077
           IF  WS-NBR-TESTS > 0                                         
C33235         COMPUTE TS-MEAN-WITH-DOGS ROUNDED                        
                        = WS-TOTAL-FULL-LOAD-ACCU-AF / WS-NBR-TESTS     
           ELSE                                                         
               MOVE ZEROES                     TO TS-MEAN-WITH-DOGS     
           END-IF.                                                      
      *                                                                 07880077
      ****************************************************************  07890077
      * CALCULATE STANDARD DEVIATION WITH DOGS FOR FULL LOAD ACCURACY*  07900077
      * AS  FOUND                                                    *  07910077
      ****************************************************************  07920077
           MOVE ZEROES                         TO WS-TOTAL-DEVIATION.   
           PERFORM VARYING WS-METER-SUB FROM 1 BY 1 UNTIL               
                                     WS-METER-SUB > WS-NBR-TESTS        
C33235         COMPUTE WS-TOTAL-DEVIATION ROUNDED =                     
C33235                              WS-TOTAL-DEVIATION +                
               (WS-TEST-FULL-LOAD-ACCU-AF (WS-METER-SUB)                
                  - TS-MEAN-WITH-DOGS) ** 2                             
           END-PERFORM.                                                 
      *                                                                 08010077
T15090     IF MQ-SAMPLE-MIN-QT                 EQUAL ZERO               
T15090        MOVE WS-Y                        TO WS-ZERO-SAMPLE-MIN-QT 
T15090        MOVE 1                           TO MQ-SAMPLE-MIN-QT      
T15090     END-IF.                                                      
T15090*                                                                 08111006
T15090     IF MQ-TESTED-QT                     EQUAL ZERO               
T15090        MOVE 1                           TO MQ-TESTED-QT          
T15090     END-IF.                                                      
T15090*                                                                 08150000
C33235     COMPUTE WS-CORRECT-FACT ROUNDED =                            
T15090          WS-TOTAL-DEVIATION / MQ-TESTED-QT.                      
C33235     COMPUTE TS-STD-DEV-W-DOGS ROUNDED                            
T15090                           = WS-CORRECT-FACT ** 0.5.              
      *                                                                 08210000
           MOVE ZEROES                         TO WS-NBR-TESTS-WO-DOGS  
                                                  TS-NUMBER-OF-DOGS     
                                            WS-TOTAL-FULL-LOAD-ACCU-AF. 
C33235     COMPUTE WS-MEAN-DOG-LIMIT-U ROUNDED =                        
C33235             (TS-STD-DEV-W-DOGS * 4) + TS-MEAN-WITH-DOGS.         
C33235     COMPUTE WS-MEAN-DOG-LIMIT-L ROUNDED =                        
T15090             TS-MEAN-WITH-DOGS - (TS-STD-DEV-W-DOGS * 4)          
           PERFORM 3200-ACCUM-FULL-LOAD-ACCURACY THRU 3200-EXIT         
                   VARYING WS-METER-SUB FROM 1 BY 1 UNTIL               
                                     WS-METER-SUB > WS-NBR-TESTS.       
      *                                                                 08090077
      ******************************************************************08100077
      * CALCULATE MEAN WITHOUT DOGS FOR FULL LOAD ACCURACY TEST RESULTS*08110077
      ******************************************************************08120077
           IF  WS-NBR-TESTS-WO-DOGS > 0                                 
C33235         COMPUTE TS-MEAN-WITHOUT-DOGS ROUNDED =                   
                     WS-TOTAL-FULL-LOAD-ACCU-AF / WS-NBR-TESTS-WO-DOGS  
           ELSE                                                         
               MOVE ZEROES                     TO TS-MEAN-WITHOUT-DOGS  
           END-IF.                                                      
      *                                                                 08150077
      ****************************************************************  08160077
      * CALCULATE STANDARD DEVIATION WITHOUT DOGS FOR FULL LOAD      *  08170091
      * ACCURACY AS FOUND                                            *  08180077
      ****************************************************************  08190077
           MOVE ZEROES                         TO WS-TOTAL-DEVIATION.   
           PERFORM VARYING WS-METER-SUB FROM 1 BY 1 UNTIL               
                                     WS-METER-SUB > WS-NBR-TESTS        
               IF  WS-TEST-IS-NOT-A-DOG (WS-METER-SUB)                  
C33235             COMPUTE WS-TOTAL-DEVIATION ROUNDED                   
C33235                    = WS-TOTAL-DEVIATION +                        
                     (WS-TEST-FULL-LOAD-ACCU-AF (WS-METER-SUB)          
                        - TS-MEAN-WITHOUT-DOGS) ** 2                    
               END-IF                                                   
           END-PERFORM.                                                 
T15090*                                                                 08560000
T15090     IF WS-NBR-TESTS-WO-DOGS             EQUAL ZERO               
T15090        MOVE 1                           TO WS-NBR-TESTS-WO-DOGS  
T15090     END-IF.                                                      
T15090*                                                                 08600000
T15090     DISPLAY 'NBR TESTS WO DOGS' WS-NBR-TESTS-WO-DOGS             
C33235     COMPUTE WS-CORRECT-FACT ROUNDED =                            
T15090          WS-TOTAL-DEVIATION / WS-NBR-TESTS-WO-DOGS.              
C33235     COMPUTE TS-STD-DEV-WO-DOGS ROUNDED                           
T15090                           = WS-CORRECT-FACT ** 0.5.              
      *                                                                 08310077
      ******************************************************************08320077
      * DETERMINE THE ESTIMATED PERCENT DOGS                          **08330099
      ******************************************************************08340077
           IF  MQ-TESTED-QT > 0                                         
C33235         COMPUTE TS-EST-PCT-DOGS ROUNDED                          
C33235                = (TS-NUMBER-OF-DOGS * 100.0) / MQ-TESTED-QT      
           ELSE                                                         
               MOVE ZEROES                     TO TS-EST-PCT-DOGS       
           END-IF.                                                      
      *                                                                 08360077
      * COMPUTE THE QUALITY INDICES                                     08370008
           MOVE 102                            TO WS-UPPER-QUAL-LIMIT.  
           MOVE  98                            TO WS-LOWER-QUAL-LIMIT.  
      *                                                                 08390193
T15090     IF  TS-STD-DEV-WO-DOGS > 0                                   
C33235         COMPUTE TS-UPPER-QUAL-INDEX ROUNDED                      
T15090            = (102 - TS-MEAN-WITHOUT-DOGS) / TS-STD-DEV-WO-DOGS   
C33235         COMPUTE TS-LOWER-QUAL-INDEX ROUNDED                      
T15090            = (TS-MEAN-WITHOUT-DOGS - 98) / TS-STD-DEV-WO-DOGS    
           ELSE                                                         
               MOVE ZEROES                     TO TS-UPPER-QUAL-INDEX   
                                                  TS-LOWER-QUAL-INDEX   
           END-IF.                                                      
      *                                                                 08440077
      ******************************************************************08450077
      * LOOK UP QUALITY INDICES                                        *08460077
      * ESTIMATE PERCENT ABOVE UPPER-QUALITY-INDEX BY LOOKING UP ESTIM *08470077
      * -ATED PERCENT DEFECTIVE IN TABLE B-5 USING UPPER-QUALITY-INDEX *08480077
      * AND SAMPLE SIZE.                                               *08490077
      * ESTIMATE PERCENT BELOW LOWER-QUALITY-INDEX BY LOOKING UP ESTIM *08500077
      * -ATED PERCENT DEFECTIVE IN TABLE B-5 USING LOWER-QUALITY-INDEX *08510077
      * AND SAMPLE SIZE.                                               *08520077
      ******************************************************************08530077
           MOVE WS-NO                          TO WS-B5-FOUND.          
           PERFORM VARYING WS-SIZE-SUB FROM 1 BY 1 UNTIL                
                                    WS-SIZE-SUB > 15 OR B5-FOUND        
               IF  (WS-NBR-TESTS-WO-DOGS                                
                                 <= WS-B5-SAMPLE-SIZE-MAX (WS-SIZE-SUB))
                   MOVE WS-YES                 TO WS-B5-FOUND           
               END-IF                                                   
           END-PERFORM.                                                 
T15090     COMPUTE WS-SIZE-SUB    =   WS-SIZE-SUB  - 1.                 
           IF  B5-NOT-FOUND                                             
               MOVE 16                         TO WS-SIZE-SUB           
           END-IF.                                                      
           MOVE TS-UPPER-QUAL-INDEX            TO WS-QUALITY-INDEX.     
           PERFORM 3300-DETERMINE-EST-PCT-DEFEC THRU 3300-EXIT.         
           MOVE WS-EST-PCT-DEFEC               TO TS-EST-DEFEC-ABOVE-U  
           MOVE TS-LOWER-QUAL-INDEX            TO WS-QUALITY-INDEX.     
           PERFORM 3300-DETERMINE-EST-PCT-DEFEC THRU 3300-EXIT.         
           MOVE WS-EST-PCT-DEFEC               TO TS-EST-DEFEC-BELOW-L  
      *                                                                 08710077
      ****************************************************************  08720077
      * CALCULATE TOTAL ESTIMATE OF PERCENT DEFECTIVE IN GROUP       *  08730077
      ****************************************************************  08740077
C33235     COMPUTE WS-TOT-EST-PCT-DEFEC ROUNDED                         
C33235                         = TS-EST-PCT-DOGS +                      
                       + TS-EST-DEFEC-ABOVE-U  + TS-EST-DEFEC-BELOW-L.  
           PERFORM 3400-DETERMINE-PERFORMANCE THRU 3400-EXIT.           
T15090*                                                                 09270000
T15090     MOVE WS-R                      TO  TS-TEST-SCHED-CD          
T15090     MOVE WS-CURRENT-TIMESTAMP      TO  TS-ANALYSIS-TS            
T15090*                                                                 09310000
           IF  UPDATE-FLAG                                              
               PERFORM 3500-UPDATE-TABLES THRU 3500-EXIT                
           END-IF.                                                      
           PERFORM 8000-PRINT-REPORT-PARA THRU 8000-EXIT.               
      *                                                                 08800077
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08830078
      ****************************************************************  08840083
      * GETTING METER NO.  WHICH HAVE BEEN SELECTED FOR TESTING     **  08850083
      ****************************************************************  08860083
       3100-SELECT-METER-CURSOR.                                        
      *                                                                 08880078
           MOVE WS-E                           TO ET-CODE-UTIL-TYPE.    
           MOVE EM-METER-NO                    TO ET-METER-NO.          
           MOVE EM-LAST-TEST-SEL-DT            TO ET-DATE-TEST.         
           PERFORM 7140-OPEN-ELEC-MTR-TEST THRU 7140-EXIT.              
           PERFORM 7150-FETCH-ELEC-MTR-TEST THRU 7150-EXIT.             
           PERFORM 3110-SELECT-TEST-CURSOR THRU 3110-EXIT.              
           PERFORM 7160-CLOSE-ELEC-MTR-TEST THRU 7160-EXIT.             
T21537     IF  END-OF-PROCESS                                           
T21537         GO TO 3100-EXIT                                          
T21537     END-IF.                                                      
           PERFORM 7120-FETCH-ELEC-METER THRU 7120-EXIT.                
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08990017
      ****************************************************************  09000077
      * CHECKING WHETHER THE METER IS TESTED AFTER SELECTING OR NOT  *  09010077
      * IF NOT, WRITE THE METER NO. INTO ERROR FILE. IF IT IS TESTED *  09020077
      * WRITE THE DETAILS INTO FCSMT06                               *  09030099
      ****************************************************************  09040077
       3110-SELECT-TEST-CURSOR.                                         
      *                                                                 09060054
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 4100-LOAD-ERROR-DETAIL THRU 4100-EXIT            
               GO TO 3110-EXIT                                          
           END-IF.                                                      
T21537     PERFORM 3111-PREPARE-DETAIL-RPT THRU 3111-EXIT.              
           IF  UPDATE-FLAG                                              
               ADD 1 TO WS-NBR-TEST-RECS                                
               PERFORM 4200-LOAD-FIOMT06 THRU 4200-EXIT                 
           END-IF.                                                      
           ADD 1                               TO WS-TEST-SUB.          
           MOVE ET-FULL-LOAD-ACCU-AF           TO                       
                              WS-TEST-FULL-LOAD-ACCU-AF(WS-TEST-SUB).   
           ADD ET-FULL-LOAD-ACCU-AF            TO                       
                                             WS-TOTAL-FULL-LOAD-ACCU-AF.
           ADD 1                               TO WS-NBR-TESTS.         
       3110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09250078
T21537****************************************************************  09000077
T21537* REPORT OF ALL THE INDIVIDUAL TEST RESULTS                    *  09000077
T21537****************************************************************  09000077
T21537 3111-PREPARE-DETAIL-RPT.                                         
T21537*                                                                 09251102
T21537     IF  MQ-MTR-TEST-GRP-CD NOT EQUAL WS-RPT3-GRP-CD              
T21537         MOVE MQ-MTR-TEST-GRP-CD         TO WS-RPT3-GRP-CD        
T21537         MOVE 58                         TO WS-DTL-COUNT          
T21537     END-IF.                                                      
C31091     MOVE MQ-MTR-TEST-GRP-TX             TO WS-RPT3-GRP-DESC.     
T21537     MOVE EM-METER-NO                    TO WS-RPT3-MTR-NO.       
T21537     MOVE ET-DATE-TEST                   TO WS-RPT3-DATE-TEST.    
T21537     MOVE ET-LIGHT-LOAD-ACCU-AF          TO WS-RPT3-AF-LIGHT.     
T21537     MOVE ET-FULL-LOAD-ACCU-AF           TO WS-RPT3-AF-FULL.      
T21537     COMPUTE WS-AVG-LOAD ROUNDED                                  
T21537          = (ET-LIGHT-LOAD-ACCU-AF + ET-FULL-LOAD-ACCU-AF) / 2.0  
T21537     MOVE WS-AVG-LOAD                    TO WS-RPT3-AF-AVG.       
T21537     MOVE ET-LIGHT-LOAD-ACCU-AL          TO WS-RPT3-AL-LIGHT.     
T21537     MOVE ET-FULL-LOAD-ACCU-AL           TO WS-RPT3-AL-FULL.      
T21537     COMPUTE WS-AVG-LOAD ROUNDED                                  
T21537          = (ET-LIGHT-LOAD-ACCU-AL + ET-FULL-LOAD-ACCU-AL) / 2.0  
T21537     MOVE WS-AVG-LOAD                    TO WS-RPT3-AL-AVG.       
T21537     MOVE WS-E                           TO EQ-CODE-UTIL-TYPE.    
T21537     MOVE EM-METER-NO                    TO EQ-DEVICE-NO.         
T21537     MOVE WS-J                           TO EQ-CODE-CRNT-LOC      
T21537     MOVE ZEROS                          TO AT-ADDRESS-ID.        
T21537     PERFORM 7510-GET-LOC-NO THRU 7510-EXIT.                      
T21537     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T21537         MOVE EQ-CRNT-LOC-NO             TO WS-CPD99-PREMISE-NO   
T21537         PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT            
T21537         MOVE WS-CPD99-ACCOUNT-NO        TO AT-ACCOUNT-NO         
T21537         PERFORM 4000-MAIL-NAME-ADDRESS  THRU 4000-EXIT           
T21537         MOVE WS-PR-STREET               TO WS-RPT3-ADDRESS       
T21537     ELSE                                                         
T21537         MOVE SPACES                     TO WS-RPT3-ADDRESS       
T21537     END-IF.                                                      
T21537     PERFORM 8110-WRITE-DETAIL-RPT THRU 8110-EXIT.                
T21537*                                                                 09253802
T21537 3111-EXIT.                                                       
T21537     EXIT.                                                        
T21537*                                                                 09255002
      ***************************************************************   09260083
      * ACCUMULATE FULL LOAD ACCURACY AS FOUND FOR MEAN CALCULATION *   09270083
      * WITHOUT DOGS                                                *   09280083
      ***************************************************************   09290083
       3200-ACCUM-FULL-LOAD-ACCURACY.                                   
      *                                                                 09310083
           MOVE WS-NO                          TO                       
                                WS-TEST-IS-A-DOG-FLAG (WS-METER-SUB)    
C33235     COMPUTE WS-MEAN-DOG-TEST ROUNDED                             
                    = WS-TEST-FULL-LOAD-ACCU-AF (WS-METER-SUB)          
T15090     IF  WS-MEAN-DOG-TEST > WS-MEAN-DOG-LIMIT-U                   
               ADD 1                           TO TS-NUMBER-OF-DOGS     
               MOVE WS-YES                     TO                       
                               WS-TEST-IS-A-DOG-FLAG (WS-METER-SUB)     
           ELSE                                                         
T15090         IF  WS-MEAN-DOG-TEST < WS-MEAN-DOG-LIMIT-L               
T15090             ADD 1                       TO TS-NUMBER-OF-DOGS     
T15090             MOVE WS-YES                 TO                       
T15090                         WS-TEST-IS-A-DOG-FLAG (WS-METER-SUB)     
T15090         ELSE                                                     
C33235             COMPUTE WS-TOTAL-FULL-LOAD-ACCU-AF ROUNDED           
C33235                     = WS-TOTAL-FULL-LOAD-ACCU-AF +               
C33235                    WS-TEST-FULL-LOAD-ACCU-AF (WS-METER-SUB)      
T15090             ADD 1                       TO WS-NBR-TESTS-WO-DOGS  
T15090         END-IF                                                   
           END-IF.                                                      
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09490078
      ***************************************************************   09500078
      * DETERMINE EST-PCT-DEFEC VALUE DEPENDING ON QUALITY INDEX    *   09510078
      ***************************************************************   09520078
       3300-DETERMINE-EST-PCT-DEFEC.                                    
      *                                                                 09540010
           EVALUATE TRUE                                                
              WHEN WS-QUALITY-INDEX  < 0                                
                  MOVE ZEROES                  TO WS-EST-PCT-DEFEC      
              WHEN WS-QUALITY-INDEX  > 3.90                             
                  MOVE ZEROES                  TO   WS-EST-PCT-DEFEC    
              WHEN WS-QUALITY-INDEX  = 0                                
                  COMPUTE WS-EST-PCT-DEFEC                              
                                = WS-B5-EST-PCT-DEFEC (1, WS-SIZE-SUB)  
              WHEN WS-QUALITY-INDEX  < 0.10                             
C33235            COMPUTE WS-EST-PCT-DEFEC ROUNDED                      
                                = (WS-B5-EST-PCT-DEFEC (1, WS-SIZE-SUB) 
                              + WS-B5-EST-PCT-DEFEC(2, WS-SIZE-SUB)) / 2
              WHEN WS-QUALITY-INDEX  = 0.10                             
                  COMPUTE WS-EST-PCT-DEFEC                              
                                = WS-B5-EST-PCT-DEFEC (2, WS-SIZE-SUB)  
              WHEN WS-QUALITY-INDEX  < 0.20                             
C33235            COMPUTE WS-EST-PCT-DEFEC ROUNDED                      
                                = (WS-B5-EST-PCT-DEFEC (2, WS-SIZE-SUB) 
                              + WS-B5-EST-PCT-DEFEC(3, WS-SIZE-SUB)) / 2
              WHEN WS-QUALITY-INDEX  = 0.20                             
                  COMPUTE WS-EST-PCT-DEFEC                              
                                = WS-B5-EST-PCT-DEFEC (3, WS-SIZE-SUB)  
              WHEN WS-QUALITY-INDEX  < 0.30                             
C33235            COMPUTE WS-EST-PCT-DEFEC ROUNDED                      
                                = (WS-B5-EST-PCT-DEFEC (2, WS-SIZE-SUB) 
                             + WS-B5-EST-PCT-DEFEC(3, WS-SIZE-SUB)) / 2 
              WHEN OTHER                                                
                  MOVE WS-NO                   TO WS-B5-FOUND           
                  PERFORM VARYING WS-QL-SUB FROM 1 BY 1                 
                        UNTIL WS-QL-SUB > WS-MAX-B5-ROWS OR B5-FOUND    
                     IF  (WS-QUALITY-INDEX                              
                                    <= WS-B5-QUALITY-INDEX (WS-QL-SUB)) 
                        MOVE WS-B5-EST-PCT-DEFEC(WS-QL-SUB, WS-SIZE-SUB)
                                               TO WS-EST-PCT-DEFEC      
                         MOVE WS-YES           TO WS-B5-FOUND           
                     END-IF                                             
                  END-PERFORM                                           
                  IF  B5-NOT-FOUND                                      
                      MOVE 0                   TO WS-EST-PCT-DEFEC      
                  END-IF                                                
           END-EVALUATE.                                                
      *                                                                 09960023
      ***************************************************************   09970077
      * DETERMINE MAXIMUM ALLOWABLE PERCENT DEFECTIVE TABLE B-3     *   09980099
      * FOR AQL (ACCEPTABLE QUALITY LEVEL) = 2.5                    *   09990077
      ***************************************************************   10000077
T15090     MOVE MQ-SAMPLE-MIN-QT               TO WS-POPULATION-SIZE.   
           PERFORM VARYING WS-SUB FROM 1 BY 1                           
                      UNTIL WS-SUB > 15 OR B3-FOUND                     
T15090         IF WS-POPULATION-SIZE <= ESMP-SAMPLE-SIZE (WS-SUB)       
T15090              MOVE ESMP-AQL-250M(WS-SUB) TO                       
T15090                                         WS-SAMPL-MAX-PCT-DEFEC   
T15090                                         TS-MAX-PCT-DEFEC         
                    MOVE WS-YES                TO WS-B3-FOUND           
               END-IF                                                   
           END-PERFORM.                                                 
T15090     MOVE WS-NO                          TO WS-B3-FOUND.          
      *                                                                 10100022
       3300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10130020
      ***************************************************************   10140077
      * CHECKING FOR ACCEPTABILITY OF THE LOT                       *   10150077
      ***************************************************************   10160077
       3400-DETERMINE-PERFORMANCE.                                      
      *                                                                 10180077
           IF  WS-TOT-EST-PCT-DEFEC <= WS-SAMPL-MAX-PCT-DEFEC AND       
                TS-UPPER-QUAL-INDEX >= 0 AND TS-LOWER-QUAL-INDEX >= 0   
               IF  ( TS-MEAN-WITHOUT-DOGS > WS-UPPER-QUAL-LIMIT ) OR    
                   ( TS-MEAN-WITHOUT-DOGS < WS-LOWER-QUAL-LIMIT )       
                   MOVE SPACES                 TO WS-COMPARISON-LITERAL 
                   MOVE WS-F                   TO MQ-STATUS-CD          
                   MOVE 'UPPER/LOWER SPEC LIMIT LOT NOT ACCEPTABLE'     
                                               TO WS-PERFORMANCE-MESSAGE
               ELSE                                                     
                   MOVE WS-E                   TO MQ-STATUS-CD          
                   MOVE 'LOT MEETS THE ACCEPTABILITY CRITERION:'        
                                               TO WS-PERFORMANCE-MESSAGE
                   MOVE '<='                   TO WS-COMPARISON-LITERAL 
               END-IF                                                   
           ELSE                                                         
               MOVE WS-F                       TO MQ-STATUS-CD          
               MOVE 'LOT DOES NOT MEET THE ACCEPTABILITY CRITERION:'    
                                               TO WS-PERFORMANCE-MESSAGE
               MOVE ' >'                       TO WS-COMPARISON-LITERAL 
           END-IF.                                                      
       3400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10400066
      *************************************************************     10410083
      * UPDATING CSS_MTR_TEST_HIST, F F_MTR_TEST_STATS WITH THE   *     10420083
      * CALCULATED VALUES                                         *     10430083
      *************************************************************     10440083
       3500-UPDATE-TABLES.                                              
           MOVE WS-E                           TO MQ-CODE-UTIL-TYPE.    
           MOVE WS-R                           TO MQ-TEST-SCHED-CD.     
T21537     MOVE WS-TEST-YEAR                   TO MQ-TEST-YEAR.         
           PERFORM 8600-UPDATE-TEST-HIST THRU 8600-EXIT.                
           MOVE WS-E                           TO TS-CODE-UTIL-TYPE.    
T21537     MOVE WS-TEST-YEAR                   TO TS-TEST-YEAR.         
           MOVE MQ-MTR-TEST-GRP-CD             TO TS-MTR-TEST-GRP-CD.   
           PERFORM 8700-UPDATE-TEST-STATS THRU 8700-EXIT.               
T15090     IF  WS-ACTIVE-RETURN-CODE            EQUAL NOT-FOUND         
T15090         PERFORM 8800-INSERT-TEST-STATS   THRU  8800-EXIT         
T15090     END-IF.                                                      
       3500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10580083
      *************************************************************     10590083
      * LOADING ERROR DETAIL RECORD WITH METER NO & DESCRIPTION  **     10600083
      *************************************************************     10610083
       4100-LOAD-ERROR-DETAIL.                                          
           MOVE ET-METER-NO                    TO ERR-METER-NO.         
           PERFORM 8100-WRITE-ERROR-PARA THRU 8100-EXIT.                
      *                                                                 10670083
       4100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10700083
      ***************************************************************   10710077
      * MOVING TEST DETAILS TO FIOMT06 FIELDS TO WRITE INTO THE FILE*   10720077
      ***************************************************************   10730077
       4200-LOAD-FIOMT06.                                               
      *                                                                 10750048
           MOVE MQ-TEST-YEAR                   TO E-FMT06-TEST-YEAR.    
           MOVE MQ-MTR-TEST-GRP-CD             TO E-FMT06-GRP-CD.       
T22243     MOVE WS-COMP-NO                     TO E-FMT06-COMPANY-NO.   
           MOVE EM-METER-NO                    TO E-FMT06-DEVICE-NO.    
T15090     MOVE EM-DATE-LAST-TESTED            TO E-FMT06-DATE-TEST.    
           MOVE ET-EQ-TESTER-ID                TO E-FMT06-EQ-TESTER-ID. 
           MOVE ET-TEST-BENCH-ID               TO E-FMT06-TEST-BENCH-ID.
           MOVE EM-ELEC-MTR-CLASS-CD           TO                       
                                            E-FMT06-ELEC-MTR-CLASS-CD.  
           MOVE EM-ELEC-MTR-SPEC-CD            TO                       
                                            E-FMT06-ELEC-MTR-SPEC-CD.   
           MOVE EM-METER-SIZE-ID               TO E-FMT06-METER-SIZE-ID.
           MOVE ET-REPAIR-DESC                 TO E-FMT06-REPAIR-DESC.  
           MOVE ET-LIGHT-LOAD-ACCU-AF          TO                       
                                            E-FMT06-LIGHT-LOAD-ACCU-AF. 
           MOVE ET-FULL-LOAD-ACCU-AF           TO                       
                                            E-FMT06-FULL-LOAD-ACCU-AF.  
           MOVE ET-POWER-FCTR-ACCU-AF          TO                       
                                            E-FMT06-POWER-FCTR-ACCU-AF. 
           PERFORM 8150-WRITE-FIOMT06 THRU 8150-EXIT.                   
      *                                                                 10950048
       4200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10980077
      ***************************************************************   10990083
      * MOVING VARIABLES TO CORRESPONDING REPORT HEADERS            *   11000083
      ***************************************************************   11010083
       4300-LOAD-DATA-PARA.                                             
           MOVE MQ-MTR-TEST-GRP-CD             TO HDR-04-GRP-CD.        
C31091     MOVE MQ-MTR-TEST-GRP-TX             TO HDR-04-GRP-DESC.      
T15090     MOVE MQ-TESTED-QT                   TO HDR-05-SAMPL-SIZE.    
T15090     MOVE TS-STD-DEV-WO-DOGS             TO HDR-06-STAND-DEV.     
T15090     MOVE TS-MEAN-WITHOUT-DOGS           TO HDR-07-XBAR.          
           MOVE 102.00                         TO HDR-08-UPPER-LIM.     
           MOVE 98.00                          TO HDR-09-LOWER-LIM.     
           MOVE TS-UPPER-QUAL-INDEX            TO HDR-10-UPPER-INDEX.   
           MOVE TS-LOWER-QUAL-INDEX            TO HDR-11-LOWER-INDEX.   
           MOVE TS-EST-DEFEC-ABOVE-U           TO HDR-12-ABOVE-U.       
           MOVE TS-EST-DEFEC-BELOW-L           TO HDR-13-BELOW-L.       
           MOVE TS-EST-PCT-DOGS                TO HDR-14-PER-DOGS.      
           MOVE WS-TOT-EST-PCT-DEFEC           TO HDR-15-TOT-DEFEC      
                                            WS-TOT-EST-PCT-DEFEC-E.     
           MOVE WS-SAMPL-MAX-PCT-DEFEC         TO HDR-16-MAX-ALLOW      
                                            WS-SAMPL-MAX-PCT-DEFEC-E.   
           MOVE WS-PERFORMANCE-MESSAGE         TO HDR-18-PER-MESG.      
           MOVE WS-COMPARISON-LITERAL          TO HDR-18-COM-LIT.       
           IF  WS-COMPARISON-LITERAL NOT EQUAL SPACES                   
               MOVE WS-TOT-EST-PCT-DEFEC-E     TO HDR-18-PART1          
               MOVE WS-SAMPL-MAX-PCT-DEFEC-E   TO HDR-18-PART2          
           ELSE                                                         
               MOVE SPACES                     TO HDR-18-PART1          
                                                  HDR-18-PART2          
           END-IF.                                                      
       4300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11240083
T21537 COPY CPD00037.                                                           
T21537 COPY CPD00040.                                                           
T21537*                                                                         
T21537     EXEC SQL                                                             
T21537         INCLUDE CPD00038                                                 
T21537     END-EXEC.                                                            
T21537*                                                                         
T21537     EXEC SQL                                                             
T21537         INCLUDE CPD00039                                                 
T21537     END-EXEC.                                                            
T21537*                                                                         
T21537******************************************************************        
T21537* 4000-MAIL-NAME-ADDRESS.                                        *        
T21537* TO FETCH THE PREMISE ADDRESS.                                  *        
T21537******************************************************************        
T21537     EXEC SQL                                                             
T21537         INCLUDE CPD00074                                                 
T21537     END-EXEC.                                                            
T21537*                                                                         
T21537******************************************************************        
T21537* 6010-REDUCE-EMBEDDED-SPACES (NEEDED BY CPD00074)               *        
T21537******************************************************************        
T21537     EXEC SQL                                                             
T21537         INCLUDE CPD00004                                                 
T21537     END-EXEC.                                                            
T21537*                                                                         
T21537******************************************************************22080000
T21537* 6990-FETCH-CUR-ACCOUNT                                         *        
T21537*  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.             *        
T21537******************************************************************        
T21537     EXEC SQL                                                             
T21537         INCLUDE CPD00099                                                 
T21537     END-EXEC.                                                            
T21537*                                                                         
T21537******************************************************************        
T21537* 6995-CPD99-ERROR-ROUTINE                                       *        
T21537* MODULE TO DISPLAY ANY SQL ERRORS FROM COPYBOOK CPD00099        *        
T21537******************************************************************        
T21537 6995-CPD99-ERROR-ROUTINE.                                        
T21537*                                                                         
T21537     DISPLAY '********** PCSMT659 ABORT ************'.            
T21537     DISPLAY '* ERROR IN PARA ' ACTIVE-PARAGRAPH.                 
T21537     DISPLAY '* PREMISE-NO = ', WS-CPD99-PREMISE-NO.              
T21537     DISPLAY '* SQL CODE IS ', WS-CPD99-RETURN-CODE.              
T21537     DISPLAY '* PROGRAM ABENDING...                *'.            
T21537     DISPLAY '********** PCSMT659 ABORT ************'.            
T21537     PERFORM 9900-ABEND THRU 9900-EXIT.                           
T21537*                                                                         
T21537 6995-EXIT.                                                       
T21537     EXIT.                                                        
T21537*                                                                         
      *************************************************************     11250077
      * OPENING JOB_PARM CURSOR                                   *     11260077
      *************************************************************     11270077
       7000-OPEN-JOB-PARM.                                              
           EXEC SQL                                                     
              OPEN  JOB_PARM                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11320007
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 11340007
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* OPEN   ERROR IN 7000-OPEN-JOB-PARM    *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11450007
      ***************************************************************   11460083
      ** FETCHING ROWS FROM JOB_PARM FOR THE TABLE CSS_JOB_PARM    **   11470099
      ***************************************************************   11480083
       7010-FETCH-JOB-PARM.                                             
           EXEC SQL                                                     
              FETCH JOB_PARM                                            
               INTO :G6-SEQ-NO                                          
                   ,:G6-PARM-DATA                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11550007
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 11570007
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* FETCH  ERROR IN 7010-FETCH-JOB-PARM   *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11680007
      ***************************************************************   11690083
      ** CLOSING JOB_PARM FOR THE TABLE CSS_JOB_PARM               **   11700083
      ***************************************************************   11710083
       7020-CLOSE-JOB-PARM.                                             
           EXEC SQL                                                     
              CLOSE JOB_PARM                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11760007
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 11780007
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* CLOSE  ERROR IN 7020-CLOSE-JOB-PARM   *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11890007
      ***************************************************************   11900083
      ** SELECTING FROM THE TABLE CSS_MTR_TEST_HIST WHEN GROUP CODE**   11910083
      ** IS PRESENT IN JOB_PARM                                    **   11920083
      ***************************************************************   11930083
       7050-SELECT-TEST-HIST.                                           
           EXEC SQL                                                     
              SELECT  MQ.MTR_TEST_GRP_CD                                
                     ,MQ.MTR_TEST_GRP_TX                                
                     ,MQ.STATUS_CD                                      
                     ,MQ.SELECTED_QT                                    
                     ,MQ.SAMPLE_MIN_QT                                  
                     ,MQ.TESTED_QT                                      
                INTO  :MQ-MTR-TEST-GRP-CD                               
                     ,:MQ-MTR-TEST-GRP-TX                               
                     ,:MQ-STATUS-CD                                     
                     ,:MQ-SELECTED-QT                                   
                     ,:MQ-SAMPLE-MIN-QT                                 
                     ,:MQ-TESTED-QT                                     
                FROM  CSS_MTR_TEST_HIST  MQ                             
               WHERE  MQ.CODE_UTIL_TYPE  = :MQ-CODE-UTIL-TYPE           
                 AND  MQ.TEST_YEAR       = :MQ-TEST-YEAR                
                 AND  MQ.TEST_SCHED_CD   = :MQ-TEST-SCHED-CD            
                 AND  MQ.MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD          
T22243           AND  MQ.COMPANY_NO      = :MQ-COMPANY-NO               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12170007
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 12190007
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7050-SELECT-TEST-HIST *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
T22243         DISPLAY '* COMPANY NO  = ' MQ-COMPANY-NO                 
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12300007
      **************************************************************    12310083
      ** OPENING TEST_GROUP CURSOR FOR THE TABLE CSS_MTR_TEST_HIST**    12320083
      **************************************************************    12330083
       7060-OPEN-TEST-GROUP.                                            
           EXEC SQL                                                     
              OPEN  TEST_GROUP                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12380021
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 12400021
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* OPEN   ERROR IN 7060-OPEN-TEST-GROUP  *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12510021
      ***************************************************************   12520083
      ** FETCHING TEST_GROUP CURSOR FOR THE TABLE CSS_MTR_TEST_HIST**   12530083
      ***************************************************************   12540083
       7070-FETCH-TEST-GROUP.                                           
           EXEC SQL                                                     
              FETCH TEST_GROUP                                          
               INTO :MQ-MTR-TEST-GRP-CD                                 
                   ,:MQ-MTR-TEST-GRP-TX                                 
                   ,:MQ-STATUS-CD                                       
                   ,:MQ-SELECTED-QT                                     
                   ,:MQ-SAMPLE-MIN-QT                                   
                   ,:MQ-TESTED-QT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12650021
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 12670021
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* FETCH  ERROR IN 7070-FETCH-TEST-GROUP *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
T22243         DISPLAY '* COMPANY NO  = ' MQ-COMPANY-NO                 
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12780021
      **************************************************************    12790083
      ** CLOSING TEST_GROUP CURSOR FOR THE TABLE CSS_MTR_TEST_HIST**    12800083
      **************************************************************    12810083
       7080-CLOSE-TEST-GROUP.                                           
           EXEC SQL                                                     
              CLOSE TEST_GROUP                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12860021
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 12880021
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* CLOSE  ERROR IN 7080-CLOSE-TEST-GROUP *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7080-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12990021
      **************************************************************    13000083
      ** OPENING ELEC_METER CURSOR FOR THE TABLE CSS_ELEC_METER   **    13010083
      **************************************************************    13020083
       7110-OPEN-ELEC-METER.                                            
           EXEC SQL                                                     
              OPEN  ELEC_METER                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13070021
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 13090021
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* OPEN   ERROR IN 7110-OPEN-ELEC-METER  *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13200021
      ***************************************************************   13210083
      ** FETCHING ELEC_METER CURSOR FOR THE TABLE CSS_ELEC_METER   **   13220083
      ***************************************************************   13230083
       7120-FETCH-ELEC-METER.                                           
           EXEC SQL                                                     
              FETCH ELEC_METER                                          
               INTO :EM-METER-NO                                        
                   ,:EM-ELEC-MTR-CLASS-CD                               
                   ,:EM-ELEC-MTR-SPEC-CD                                
                   ,:EM-METER-SIZE-ID                                   
                   ,:EM-LAST-TEST-SEL-DT                                
T22243             ,:EM-DATE-LAST-TESTED :WS-DATE-LAST-INDICATOR        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13330021
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 13350021
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T22243         IF WS-DATE-LAST-INDICATOR = -1                           
T22243            MOVE SPACES                  TO EM-DATE-LAST-TESTED   
T22243         END-IF                                                   
T22243     ELSE                                                         
T22243         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  NEXT SENTENCE                                         
               ELSE                                                     
                  DISPLAY '* FETCH  ERROR IN 7120-FETCH-ELEC-METER *'   
                  DISPLAY '* RETURN CODE = ' SQLCODE                    
T22243            DISPLAY '* COMPANY NO  = ' EM-COMPANY-NO              
                  DISPLAY '*         PROCESSING TERMINATED         *'   
                  PERFORM 9900-ABEND            THRU 9900-EXIT          
T22243         END-IF                                                   
           END-IF.                                                      
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13460021
      **************************************************************    13470083
      ** CLOSING ELEC_METER CURSOR FOR THE TABLE CSS_ELEC_METER   **    13480083
      **************************************************************    13490083
       7130-CLOSE-ELEC-METER.                                           
           EXEC SQL                                                     
              CLOSE ELEC_METER                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13540021
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 13560021
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* CLOSE  ERROR IN 7130-CLOSE-ELEC-METER *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13670053
      **************************************************************    13680083
      ** OPENING METER_TEST CURSOR FOR THE TABLE CSS_ELEC_MTR_TEST *    13690083
      **************************************************************    13700083
       7140-OPEN-ELEC-MTR-TEST.                                         
           EXEC SQL                                                     
              OPEN  METER_TEST                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13750053
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 13770053
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* OPEN   ERROR IN 7140-OPEN-ELEC-MTR-TEST  *'   
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13880021
      ***************************************************************   13890083
      ** FETCHING METER_TEST CURSOR FOR THE TABLE CSS_ELEC_MTR_TEST *   13900083
      ***************************************************************   13910083
       7150-FETCH-ELEC-MTR-TEST.                                        
           EXEC SQL                                                     
             FETCH   METER_TEST                                         
              INTO  :ET-EQ-TESTER-ID                                    
                   ,:ET-TEST-BENCH-ID                                   
                   ,:ET-REPAIR-DESC                                     
                   ,:ET-LIGHT-LOAD-ACCU-AF                              
                   ,:ET-FULL-LOAD-ACCU-AF                               
                   ,:ET-POWER-FCTR-ACCU-AF                              
                   ,:ET-DATE-TEST                                       
T21537             ,:ET-LIGHT-LOAD-ACCU-AL                              
T21537             ,:ET-FULL-LOAD-ACCU-AL                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14030029
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 14050029
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7150-FETCH-ELEC-MTR-TEST*'    
               DISPLAY '* RETURN CODE = ' SQLCODE                       
T22243         DISPLAY '* COMPANY  NO = ' ET-COMPANY-NO                 
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14160053
      **************************************************************    14170083
      ** CLOSING METER_TEST CURSOR FOR THE TABLE CSS_ELEC_MTR_TEST *    14180083
      **************************************************************    14190083
       7160-CLOSE-ELEC-MTR-TEST.                                        
           EXEC SQL                                                     
              CLOSE METER_TEST                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14240053
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 14260053
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* CLOSE  ERROR IN 7160-CLOSE-ELEC-MTR-TEST *'   
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14370023
      *************************************************************     14380000
      *   GET CURRENT DATE FROM CSS_JOB_PARM                    ***     14390099
      *************************************************************     14400000
       7500-GET-CURRENT-DATE.                                           
      *                                                                 14420000
            EXEC SQL                                                    
T15090          SELECT  CAST(SYSDATETIMEOFFSET() AS DATE), REPLACE(
           REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP(), 121), 
           ' ', '-'), ':', '.')                 
T15090            INTO  :WS-CURRENT-DATE, :WS-CURRENT-TIMESTAMP         
                  FROM  CSS_JOB_PARM                                    
                 WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                 
                   AND  COMPANY_NO   = :G6-COMPANY-NO                   
                   AND  CMND_CODE    = :G6-CMND-CODE                    
                   AND  SEQ_NO       = :G6-SEQ-NO                       
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                    14430000
MFA-TR*         SELECT  CURRENT DATE, CURRENT TIMESTAMP                 15190000
MFA-TR*           INTO  :WS-CURRENT-DATE, :WS-CURRENT-TIMESTAMP         15200000
MFA-TR*           FROM  CSS_JOB_PARM                                    14460083
MFA-TR*          WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                 14470083
MFA-TR*            AND  COMPANY_NO   = :G6-COMPANY-NO                   14480083
MFA-TR*            AND  CMND_CODE    = :G6-CMND-CODE                    14490083
MFA-TR*            AND  SEQ_NO       = :G6-SEQ-NO                       14500083
MFA-TR*     END-EXEC.                                                   14510000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14520000
            MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE.
      *                                                                 14522099
T15090      IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND
                NEXT SENTENCE                                           
            ELSE                                                        
                DISPLAY '* SELECT ERROR IN 7500-GET-CURRENT-DATE *'     
                DISPLAY '* RETURN CODE = ' SQLCODE                      
                DISPLAY '*         PROCESSING TERMINATED         *'     
                PERFORM 9900-ABEND            THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       7500-EXIT.                                                       
            EXIT.                                                       
      *                                                                 14640000
T21537***************************************************************   11900083
T21537** GET PREMISE-NO                                            **   11910083
T21537***************************************************************   11930083
T21537 7510-GET-LOC-NO.                                                 
T21537     EXEC SQL                                                     
T21537        SELECT  CRNT_LOC_NO                                       
T21537          INTO :EQ-CRNT-LOC-NO                                    
T21537          FROM  CSS_EQUIPMENT                                     
T21537         WHERE  CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE              
T21537           AND  DEVICE_NO       = :EQ-DEVICE-NO                   
T21537           AND  CODE_CRNT_LOC   = :EQ-CODE-CRNT-LOC               
T22243           AND  COMPANY_NO      = :EQ-COMPANY-NO                  
T21537     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21537*                                                                 12170007
T21537     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T21537*                                                                 12190007
T21537     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
T21537         NEXT SENTENCE                                            
T21537     ELSE                                                         
T21537         DISPLAY '* SELECT ERROR IN 7510-GET-LOC-NO       *'      
T21537         DISPLAY '* RETURN CODE = ' SQLCODE                       
T21537         DISPLAY '*         PROCESSING TERMINATED         *'      
T21537         PERFORM 9900-ABEND            THRU 9900-EXIT             
T21537     END-IF.                                                      
T21537 7510-EXIT.                                                       
T21537     EXIT.                                                        
T21537*                                                                 12190007
      ***************************************************************** 14650083
      ** LOAD THE HEADER VARIABLES AND WRITE TO REPORT FILE WITH     ** 14660083
      ** THE NECESSARY BREAKS                                        ** 14670083
      ***************************************************************** 14680083
       8000-PRINT-REPORT-PARA.                                          
      *                                                                 14700022
            PERFORM 4300-LOAD-DATA-PARA THRU 4300-EXIT.                 
      *                                                                 14720080
            IF  ( 57 - WS-LINE-COUNT) > 17                              
                NEXT SENTENCE                                           
            ELSE                                                        
                ADD  1                         TO WS-PAGE-COUNT         
                MOVE WS-PAGE-COUNT             TO HDR-03-PAGE           
                MOVE '01'                      TO HDR-01-SUFFIX         
                WRITE PRT33-RECORD FROM HEADER-01 AFTER NEW-PAGE        
                WRITE PRT33-RECORD FROM HEADER-02 AFTER 1               
                WRITE PRT33-RECORD FROM HEADER-03 AFTER 1               
                MOVE 03                        TO WS-LINE-COUNT         
            END-IF.                                                     
            WRITE PRT33-RECORD FROM HEADER-04 AFTER 2.                  
T15090      IF WS-ZERO-SAMPLE-MIN-QT          EQUAL WS-Y                
T15090         MOVE WS-N                      TO WS-ZERO-SAMPLE-MIN-QT  
T15090         WRITE PRT33-RECORD FROM HEADER-05A AFTER 1               
T15090      ELSE                                                        
T15090         WRITE PRT33-RECORD FROM HEADER-05 AFTER 1                
T15090      END-IF.                                                     
            WRITE PRT33-RECORD FROM HEADER-06 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-07 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-08 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-09 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-10 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-11 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-12 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-13 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-14 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-15 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-16 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-17 AFTER 2.                  
            WRITE PRT33-RECORD FROM HEADER-18 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-19 AFTER 1.                  
            ADD 18                             TO WS-LINE-COUNT.        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15010022
      ***************************************************************** 15020083
      ** WRITING INTO ERROR RECORD WITH REQUIRED BREAKS              ** 15030083
      ***************************************************************** 15040083
       8100-WRITE-ERROR-PARA.                                           
      *                                                                 15060022
           IF  (57 - WS-ERR-COUNT) < 2                                  
               ADD  1                          TO WS-ERR-PAGE-NO        
               MOVE WS-ERR-PAGE-NO             TO HDR-02A-PAGE          
               MOVE '02'                       TO HDR-01-SUFFIX         
               WRITE PR232-RECORD FROM HEADER-01 AFTER NEW-PAGE         
               WRITE PR232-RECORD FROM HEADER-02 AFTER 1                
               WRITE PR232-RECORD FROM HEADER-02A AFTER 1               
               MOVE 3                          TO WS-ERR-COUNT          
           END-IF.                                                      
           WRITE PR232-RECORD FROM ERROR-DETAIL AFTER 2.                
           ADD 2                               TO WS-ERR-COUNT.         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15190022
      ***************************************************************** 15200083
T21537** WRITING TEST RECORD DETAILS INTO DETAIL-REPORT              ** 15192002
T21537***************************************************************** 15193002
T21537 8110-WRITE-DETAIL-RPT.                                           
T21537*                                                                 15195002
T21537     IF  (57 - WS-DTL-COUNT) < 2                                  
T21537         ADD  1                          TO WS-DTL-PAGE-NO        
T21537         MOVE WS-DTL-PAGE-NO             TO WS-RPT3-PAGE          
T21537         MOVE '03'                       TO HDR-01-SUFFIX         
T21537         WRITE PR233-RECORD FROM HEADER-01 AFTER NEW-PAGE         
T21537         WRITE PR233-RECORD FROM WS-RPT3-HDR2 AFTER 1             
T21537         WRITE PR233-RECORD FROM WS-RPT3-HDR3 AFTER 1             
T21537         WRITE PR233-RECORD FROM WS-RPT3-HDR4 AFTER 2             
T21537         WRITE PR233-RECORD FROM WS-RPT3-HDR5 AFTER 1             
T21537         MOVE 6                          TO WS-DTL-COUNT          
T21537     END-IF.                                                      
T21537     WRITE PR233-RECORD FROM WS-RPT3-DETAIL AFTER 2.              
T21537     ADD 2                               TO WS-DTL-COUNT.         
T21537 8110-EXIT.                                                       
T21537     EXIT.                                                        
T21537*                                                                 15200202
      ***************************************************************** 15200083
      ** WRITING INTO FCSMT06 FILE                                   ** 15210083
      ***************************************************************** 15220083
       8150-WRITE-FIOMT06.                                              
           WRITE FIOMT06.                                               
      *                                                                 15250077
           IF  FMT06-SUCCESS                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY 'FCSMT06  FILE WRITE ERROR'                      
               DISPLAY 'FCSMT06  FILE STATUE IS ==>' WS-FMT06-STATUS    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 15257086
       8150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15280077
      ***************************************************************** 15290083
      ** UPDATING CSS_MTR_TEST_HIST TABLE                            ** 15300083
      ***************************************************************** 15310083
       8600-UPDATE-TEST-HIST.                                           
      *                                                                 15330022
           EXEC SQL                                                     
             UPDATE  CSS_MTR_TEST_HIST                                  
                SET  STATUS_CD     = :MQ-STATUS-CD,                     
                     SELECTED_QT   = :MQ-SELECTED-QT,                   
                     SAMPLE_MIN_QT = :MQ-SAMPLE-MIN-QT,                 
                     TESTED_QT     = :MQ-TESTED-QT                      
              WHERE  CODE_UTIL_TYPE  = :MQ-CODE-UTIL-TYPE               
                AND  TEST_YEAR       = :MQ-TEST-YEAR                    
                AND  TEST_SCHED_CD   = :MQ-TEST-SCHED-CD                
                AND  MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD              
T22243          AND  COMPANY_NO      = :MQ-COMPANY-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15450022
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 15452099
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* UPDATE ERROR IN 8600-UPDATE-TEST-HIST *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
T22243         DISPLAY '* COMPANY NO  = ' MQ-COMPANY-NO                 
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 15540022
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15570022
      ***************************************************************** 15580083
      ** UPDATING CSS_MTR_TEST_STATS TABLE                           ** 15590083
      ***************************************************************** 15600083
       8700-UPDATE-TEST-STATS.                                          
           EXEC SQL                                                     
             UPDATE  CSS_MTR_TEST_STATS                                 
                SET  MEAN_WITHOUT_DOGS  = :TS-MEAN-WITHOUT-DOGS,        
                     STD_DEV_WO_DOGS    = :TS-STD-DEV-WO-DOGS,          
                     UPPER_QUAL_INDEX   = :TS-UPPER-QUAL-INDEX,         
                     LOWER_QUAL_INDEX   = :TS-LOWER-QUAL-INDEX,         
                     EST_DEFEC_ABOVE_U  = :TS-EST-DEFEC-ABOVE-U,        
                     NUMBER_OF_DOGS     = :TS-NUMBER-OF-DOGS,           
                     ANALYSIS_QT        = :TS-ANALYSIS-QT,              
                     MEAN_WITH_DOGS     = :TS-MEAN-WITH-DOGS,           
                     STD_DEV_W_DOGS     = :TS-STD-DEV-W-DOGS,           
                     EST_DEFEC_BELOW_L  = :TS-EST-DEFEC-BELOW-L,        
                     EST_PCT_DOGS       = :TS-EST-PCT-DOGS              
              WHERE  CODE_UTIL_TYPE   = :TS-CODE-UTIL-TYPE              
                AND  TEST_YEAR        = :TS-TEST-YEAR                   
                AND  MTR_TEST_GRP_CD  = :TS-MTR-TEST-GRP-CD             
T22243          AND  COMPANY_NO       = :TS-COMPANY-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15790022
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 15792099
T15090     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* UPDATE ERROR IN 8700-UPDATE-TEST-STATS*'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
T22243         DISPLAY '* COMPANY NO  = ' TS-COMPANY-NO                 
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 15880022
       8700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15910022
T15090*                                                                 16840000
T15090***************************************************************** 16850000
T15090** INSERTING RECORD IN CSS_MTR_TEST_STATS                      ** 16860000
T15090***************************************************************** 16870000
T15090 8800-INSERT-TEST-STATS.                                          
T15090     EXEC SQL                                                     
T15090       INSERT INTO  CSS_MTR_TEST_STATS                            
T15090               ( CODE_UTIL_TYPE    ,                              
T15090                 TEST_YEAR         ,                              
T15090                 MTR_TEST_GRP_CD   ,                              
T15090                 TEST_SCHED_CD     ,                              
T15090                 MEAN_WITHOUT_DOGS ,                              
T15090                 STD_DEV_WO_DOGS   ,                              
T15090                 UPPER_QUAL_INDEX  ,                              
T15090                 LOWER_QUAL_INDEX  ,                              
T15090                 EST_DEFEC_ABOVE_U ,                              
T15090                 NUMBER_OF_DOGS    ,                              
T15090                 MAX_PCT_DEFEC     ,                              
T15090                 ANALYSIS_TS       ,                              
T15090                 MEAN_WITH_DOGS    ,                              
T15090                 STD_DEV_W_DOGS    ,                              
T15090                 EST_DEFEC_BELOW_L ,                              
T15090                 ANALYSIS_QT       ,                              
T15090                 EST_PCT_DOGS      ,                              
T22243                 COMPANY_NO )                                     
T15090       VALUES                                                     
T15090              (:TS-CODE-UTIL-TYPE   ,                             
T15090               :TS-TEST-YEAR        ,                             
T15090               :TS-MTR-TEST-GRP-CD  ,                             
T15090               :TS-TEST-SCHED-CD    ,                             
T15090               :TS-MEAN-WITHOUT-DOGS,                             
T15090               :TS-STD-DEV-WO-DOGS  ,                             
T15090               :TS-UPPER-QUAL-INDEX ,                             
T15090               :TS-LOWER-QUAL-INDEX ,                             
T15090               :TS-EST-DEFEC-ABOVE-U,                             
T15090               :TS-NUMBER-OF-DOGS   ,                             
T15090               :TS-MAX-PCT-DEFEC    ,                             
T15090               CIS.CHAR2TIMESTAMP(:TS-ANALYSIS-TS)      ,                 
T15090               :TS-MEAN-WITH-DOGS   ,                             
T15090               :TS-STD-DEV-W-DOGS   ,                             
T15090               :TS-EST-DEFEC-BELOW-L,                             
T15090               :TS-ANALYSIS-QT      ,                             
T15090               :TS-EST-PCT-DOGS     ,                             
T22243               :TS-COMPANY-NO )                                   
T15090     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     16890000
MFA-TR*      INSERT INTO  CSS_MTR_TEST_STATS                            16900000
MFA-TR*              ( CODE_UTIL_TYPE    ,                              16910000
MFA-TR*                TEST_YEAR         ,                              16920000
MFA-TR*                MTR_TEST_GRP_CD   ,                              16930000
MFA-TR*                TEST_SCHED_CD     ,                              16940000
MFA-TR*                MEAN_WITHOUT_DOGS ,                              16950000
MFA-TR*                STD_DEV_WO_DOGS   ,                              16960000
MFA-TR*                UPPER_QUAL_INDEX  ,                              16970000
MFA-TR*                LOWER_QUAL_INDEX  ,                              16980000
MFA-TR*                EST_DEFEC_ABOVE_U ,                              16990000
MFA-TR*                NUMBER_OF_DOGS    ,                              17000000
MFA-TR*                MAX_PCT_DEFEC     ,                              17010000
MFA-TR*                ANALYSIS_TS       ,                              17020000
MFA-TR*                MEAN_WITH_DOGS    ,                              17030000
MFA-TR*                STD_DEV_W_DOGS    ,                              17040000
MFA-TR*                EST_DEFEC_BELOW_L ,                              17050000
MFA-TR*                ANALYSIS_QT       ,                              17060000
MFA-TR*                EST_PCT_DOGS      ,                              17070000
MFA-TR*                COMPANY_NO )                                             
MFA-TR*      VALUES                                                     17080000
MFA-TR*             (:TS-CODE-UTIL-TYPE   ,                             17090000
MFA-TR*              :TS-TEST-YEAR        ,                             17100000
MFA-TR*              :TS-MTR-TEST-GRP-CD  ,                             17110000
MFA-TR*              :TS-TEST-SCHED-CD    ,                             17120000
MFA-TR*              :TS-MEAN-WITHOUT-DOGS,                             17130000
MFA-TR*              :TS-STD-DEV-WO-DOGS  ,                             17140000
MFA-TR*              :TS-UPPER-QUAL-INDEX ,                             17150000
MFA-TR*              :TS-LOWER-QUAL-INDEX ,                             17160000
MFA-TR*              :TS-EST-DEFEC-ABOVE-U,                             17170000
MFA-TR*              :TS-NUMBER-OF-DOGS   ,                             17180000
MFA-TR*              :TS-MAX-PCT-DEFEC    ,                             17190000
MFA-TR*              :TS-ANALYSIS-TS      ,                             17200000
MFA-TR*              :TS-MEAN-WITH-DOGS   ,                             17210000
MFA-TR*              :TS-STD-DEV-W-DOGS   ,                             17220000
MFA-TR*              :TS-EST-DEFEC-BELOW-L,                             17230000
MFA-TR*              :TS-ANALYSIS-QT      ,                             17240000
MFA-TR*              :TS-EST-PCT-DOGS     ,                             17250000
MFA-TR*              :TS-COMPANY-NO )                                           
MFA-TR*    END-EXEC.                                                    17260000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T15090*                                                                 17270000
T15090     IF  SQLCODE EQUAL SUCCESSFUL-CALL                            
T15090         NEXT SENTENCE                                            
T15090     ELSE                                                         
T15090         DISPLAY '* INSERT ERROR IN 8800-UPDATE-TEST-STATS*'      
T15090         DISPLAY '* RETURN CODE = ' SQLCODE                       
T22243         DISPLAY '* COMPANY NO  = ' TS-COMPANY-NO                 
T15090         DISPLAY '*         PROCESSING TERMINATED         *'      
T15090         PERFORM 9900-ABEND            THRU 9900-EXIT             
T15090     END-IF.                                                      
T15090*                                                                 17360000
T15090 8800-EXIT.                                                       
T15090     EXIT.                                                        
T15090*                                                                 17390000
HPCCDM* EJECT                                                           15920000
      ******************************************************************15930000
      *   TERMINATION ROUTINE                                          *15940000
      ******************************************************************15950000
      *                                                                 15960000
       9000-TERMINATE.                                                  
      *                                                                 15980011
           CLOSE FCSMT14-FILE.                                          
      *                                                                 16000011
           IF  FMT14-SUCCESS                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY 'FCSMT14  FILE CLOSE ERROR'                      
               DISPLAY 'FCSMT14  FILE STATUE IS ==>' WS-FMT14-STATUS    
           END-IF.                                                      
      *                                                                 16080011
           CLOSE FCSMT06-FILE.                                          
           IF  FMT06-SUCCESS                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY 'FCSMT06  FILE CLOSE ERROR'                      
               DISPLAY 'FCSMT06  FILE STATUE IS ==>' WS-FMT06-STATUS    
           END-IF.                                                      
      *                                                                 16170011
           CLOSE FCSPT33-FILE.                                          
      *                                                                 16260011
           CLOSE FCSP232-FILE.                                          
      *                                                                 16350011
T21537     CLOSE FCSP233-FILE.                                          
T21537*                                                                 16352002
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16380000
      **************************************************************    16390000
      *     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE          *    16400000
      **************************************************************    16410000
           EXEC SQL                                                     16420000
             INCLUDE CPD09900                                           16430000
           END-EXEC.                                                    16440000
T21537******************************************************************        
T21537* 9700-PROCESS-ABEND  (REQUIED BY CPD00074)                      *        
T21537******************************************************************        
T21537 COPY CPD0023B.                                                           
      *                                                                 16450083
