       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSMT658.                                        
       DATE-WRITTEN.   OCT 1994.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **           DATE    INITIALS       REASON                     **         
      **         ________  ________   ______________________________ **         
5854  **          07/95      LMB      ADD TIME TEST PROCESSING       **         
DB    **          10/95      FSW      DATABASE SYNCRONIZED FIX       **         
TP3285**         02/23/96     DW      ADDED CODE-UTIL-TYPE TO WHERE  **         
TP3285**                              CLAUSE FOR GAS AND ELEC METERS.**         
PCR030**          08/96    CBSI       REPLACED TEST_INITIALS WITH    **         
      **                   MADRAS     EQ_TESTER_ID. INCLUDED         **         
      **                              VALIDATION FOR EQ_TESTER_ID    **         
PCR040**          01/97    CBSI       UPLOAD DATA TO                 **         
PCR040**                   MADRAS     E-FMT652-MTR-CLASS-CD AND      **         
PCR040**                              E-FMT652-MTR-SPEC-CD FIELDS OF **         
PCR040**                              FIOMT652 FILE. REMOVED ALL     **         
PCR040**                              REFERENES TO CODE_CO_SIZE      **         
PCR040**                              COLUMN OF CSS_ELEC_METER TABLE **         
PCR040**                              AS THIS COLUMN IS REMOVED FROM **         
PCR040**                              THE TABLE                      **         
TP4597**          08/97    CBSI       FILE FIOMT04 IS REPLACED WITH  **         
TP4597**                   MADRAS     SAME FILE NAME BUT DIFFERENT   **         
TP4597**                              STRUCTURE&FIELD NAME.VALIDATION**         
TP4597**                              FOR TIME_TEST,CODE_TIME_PERIOD,**         
TP4597**                              CODE_CAP_TYPE,CODE_TEST_LOC,   **         
TP4597**                              CODE_TEST_RESULT,IN_CONSTANT,  **         
TP4597**                              DEM_READ_AF,READ_AL,DEM_READ_AL**         
TP4597**                              ARE EXCLUDED SINCE THEY HOLD   **         
TP4597**                              CONSTANT VALUES. CODE RELATED  **         
TP4597**                              TO GAS & WATER UTILITY TYPES IS**         
TP4597**                              REMOVED FROM THE PROGRAM.      **         
EMTEST**          09/97    CBSI       DEFAULT TEST TIME TO 00:01:00  **         
EMTEST**                   MADRAS     A.M.                           **         
TP4597**          10/97    CBSI       CODE ADDED TO CREATE WORK QUEUES*         
TP4597**                              FOR FAST/SLOW ERRORS, SAMPLE   **         
TP4597**                              METER CHANGES AND ALSO TO UPDATE*         
TP4597**                              TESTED_QT ON CSS_MTR_TEST_HIST **         
TP4597**                              IF THE TEST IS A VALID TEST.   **         
T15090**          03/98    CBSI       CHANGES MADE WHILE TESTING     **         
T15090**                              ELECTRIC METER SAMPLE TEST PLAN**         
T16282**          05/98    CBSI       COMMENT INSERTED IN TABLE      **         
T16282**                   MADRAS     CSS_WQ_ITEMS_MF  HAS BEEN      **         
T16282**                              CHANGED TO  ELECTRIC METER     **         
T16282**                              XXXXXXXXX IS INACCURATE.       **         
T16874**         09/98     CBSI      POPULATING THE VALUES OF LOCAL- **         
T16874**                   MADRAS    OFFICE, CUSTOMER-NO AND PREMISE-**         
T16874**                             NO IN THE WORK QUEUE TABLE AND  **         
T16874**                             CODE ADDED TO VERIFY TESTER CDS.**         
T17958**         09/98     CBSI      CHANGES MADE TO CREATE WORK QUEUE*         
T17958**                             ONLY WHEN THE METER IS FAST.    **         
T18007**                                                             **         
T18007**         10/98     CBSI      CHANGES MADE IN EDITING THR CODE**         
T18007**                             REPAIR CD & LOGIC ADDED TO RETIRE*         
T18007**                             A MTR DEPENDING ON THE REPAIR CD**         
T18007**                             AND ALSO CODE TO CREATE ERROR   **         
T18007**                             FILE IS REMOVED AS IT IS ALREADY**         
T18007**                             GENERATING AN ERROR REPORT.     **         
T19333**                                                             **         
T19333**         03/99     CBSI      CHANGES MADE TO IGNORE THE DATES**         
T19333**                             ON JOB-PARM IF THE STATUS IS NOT**         
T19333**                             ACTIVE.                         **         
T20129**                                                             **         
T20129**         06/99     CBSI      CODE CORRECTED TO UPDATE MQ WHEN**         
T20129**                             A METER SELECTED FOR SAMPLE OR  **         
T20129**                             PERIODIC TESTING IS TESTED.     **         
T20235**                                                             **         
T20235**         06/99     CBSI      CHANGES MADE TO USE CPD00099    **         
T20235**                   MADRAS    COPYBOOK FOR GETTING THE MOST   **         
T20235**                             CURRENT ACCOUNT AT THE PREMISE. **         
T21806**                                                             **         
T21806**         03/00     SREENI    CHANGES MADE TO UPDATE TESTED-QT**         
T21806**                             WHEN A TEST IS ADDED FOR A MTR. **         
T22510**                                                             **         
T22510**         07/00     SREENI    CONVERT TESTER-CD 'A' TO 15629. **         
T22243**                                                             **         
T22243**         07/00     SREENI    CHANGES MADE TO IMPLEMENT MULTI-**         
T22243**                             COMPANY IN METER INVENTORY.     **         
      **                                                             **         
30271 **     FEB 2004      RDF       UPDATE THE METER CONSTANT IN    **         
30271 **                             CSS_ELEC_MTR_TEST TABLE FROM    **         
30271 **                             THE BATCH INPUT FILE.           **         
30271 **                             ALSO THE LOCATION AND           **         
30271 **                             EMPLOYEE-ID.                    **         
30271 **                             REMOVING FILE PPSV.A035         **         
      **                                                             **         
C29299**     MAR 2004     VD88125    ADDED CODE_UTIL_TYPE IN WHERE   **         
C29299**                             CLAUSE FOR CSS_EQUIP_TEST_TYP.  **         
      **                                                             **         
31127 **  30 JUN 2004     RF10596    PUT ERROR MESSAGE ON REPORT WHEN**         
31127 **                             E-FMT04-LOCATION = SPACES AND   **         
31127 **                             CONTINUE PROCESSING REST OF FILE**         
      **                                                             **         
31683 **  12 OCT 2004    RF10596     PRINT ERROR REPORT AND DO NOT   **         
      **                             RETIRE METER WITH CT/PT         **         
      **                             ATTACHMENT                      **         
C34152**  08 MAY 2006    DB41297     RETIRE METER FOR SAMPLE SELECTED**         
      **                                                             **         
C35434**     JUL 2007    SV82012     ADD COMMIT AND RESTART LOGIC.   **         
      **                                                             **         
T33887**  19 JUL 2007    RC41079     ADDED CODE-UTIL-TYPE AND        **         
T33887**                             COMPANY-NO TO WHERE CLAUSE FOR  **         
T33887**                             CSS_EQUIP_TST_REPR.             **         
      **                                                             **         
C36856**  31 JUL 2008    KW42462     RETIRE ATTCHMTS WHEN METER IS   **         
C36856**                             RETIRED & UPDATE RELEVANT TABLES**         
      **                                                             **         
A03352*   07/12/11       MC95456     CHANGE WQ CATEGORY FROM 143 TO  **         
A03352*                              528 - SCEG(ROUTING CATEGORY OF 4)*         
A03352*                              529 - PSNC(ROUTING CATEGORY OF 1)*         
A04860**   09/11/2014   AS7C117      REPLACE CSS_WQ_ITEMS_MF WITH    **         
A04860**                ACT042       CSS_WQ_ITEMS.                   **         
      *****************************************************************         
           REMARKS.                                                     
                              PCSMT658 NARRATIVE                        
                       ELECTRIC METER BATCH DATA UPDATE                 
      *                                                                         
                 THIS PROGRAM READS THE METER TESTING RESULTS FILE      
                 AND UPDATES THE EQUIPMENT TABLE AND THE APPROPRIATE    
                 TEST TABLE FOR THE METER TYPE.                         
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
T15090 CONFIGURATION SECTION.                                           
T15090 SPECIAL-NAMES.      C01 IS NEW-PAGE.                             
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
                                                                        
TP4597 COPY CSSMT04.                                                            
T15090 COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
TP4597 COPY CFDMT04.                                                            
TP4597 COPY FIOMT04.                                                            
T15090 COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSMT658'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                      PIC X(40) VALUE                
           'WORKING STORAGE FOR PCSMT658 STARTS HERE'.                  
      *                                                                         
       01  PROGRAM-NAME                  PIC X(08) VALUE 'PCSMT658'.    
      *                                                                         
A04860 01  SCSCB077                      PIC X(8)  VALUE 'SCSCB077'.    
A04860*                                                                         
       COPY CWS00303.                                                           
T15090 COPY CWS00010.                                                           
       COPY CWS00026.                                                           
       COPY CWS09900.                                                           
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
T20235******************************************************************        
T20235* WORKING STORAGE FOR CPD00099                                   *        
T20235******************************************************************        
      *                                                                         
T20235     EXEC SQL                                                             
T20235         INCLUDE CWS00099                                                 
T20235     END-EXEC.                                                            
      *                                                                         
       01  WS-WORK-AREA.                                                
31683      05  WS-EXISTS                   PIC X VALUE 'N'.             
           05  WS-DISPLAY-RC               PIC -ZZZZZZZZ9.9.            
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSMT658'.  
           05  COUNTERS.                                                
               10  WS-NBR-METER-TEST-RECS  PIC 9(5)        VALUE 0.     
               10  WS-NBR-GOOD-RECS        PIC 9(5)        VALUE 0.     
               10  WS-NBR-BAD-RECS         PIC 9(5)        VALUE 0.     
           05  WS-ERROR-ARRAY-SIZE         PIC S9(04) COMP VALUE ZEROES.
T18007     05  WS-DATE-LAST-MOVE-NULL      PIC S9(04) COMP VALUE ZEROES.
T18007         88  DATE-LAST-MOVE-NULL     VALUE -1.                    
           05  WS-NULL-IND                 PIC S9(04) COMP VALUE ZEROES.
           05  WS-DATE-LAST-TEST-NULL      PIC S9(04) COMP VALUE ZEROES.
               88  DATE-LAST-TEST-NULL     VALUE -1.                    
TP4597     05  WS-LAST-TEST-SEL-DT-NULL    PIC S9(04) COMP VALUE ZEROES.
TP4597         88  LAST-TEST-SEL-DT-NULL   VALUE -1.                    
TP4597     05  WS-STATUS-CD-NULL           PIC S9(04) COMP VALUE ZEROES.
TP4597         88  STATUS-CD-NULL          VALUE -1.                    
T15090     05  WS-LOC-NO-NULL              PIC S9(04) COMP VALUE +0.    
T35434     05  WS-RESTART-REQ              PIC X(01).                   
T35434     05  WS-DEFAULT-RESTART-REQ      PIC X(01) VALUE 'N'.         
T35434     05  WS-COUNT-UNSUCCESSFUL-ROWS                               
T35434                                     PIC S9(04) COMP-3 VALUE ZERO.
T35434     05  WS-FLAG-TO-TURN-OFF-COMMITS PIC 9(04) VALUE 9999.        
T35434     05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 20.          
T35434     05  WS-CHKP-LUW-LIMIT           PIC 9(04).                   
T35434     05  WS-CHKP-LUW-COUNTER         PIC 9(04) COMP-3 VALUE ZERO. 
T35434     05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 20.          
T35434     05  WS-CHKP-UPD-LIMIT           PIC 9(04).                   
T35434     05  WS-COMMIT-REQ-SW            PIC X(1) VALUE 'Y'.          
T35434         88 WS-COMMITS-REQUIRE                VALUE 'Y'.          
T35434         88 WS-COMMITS-NOT-REQUIRE            VALUE 'N'.          
T15090     05  WS-ACCT-FINALED-DT-NULL     PIC S9(04) COMP VALUE +0.    
T15090     05  WS-ACCT-CREATE-DT-NULL      PIC S9(04) COMP VALUE +0.    
T15090     05  WS-INSTALL-DT-NULL          PIC S9(04) COMP VALUE +0.    
T22243     05  WS-SYSIN-COMP-NO            PIC X(02) VALUE SPACES.      
           05  WS-CODE-REPAIR              PIC X(1).                    
TP4597     05  WS-ELEC-CODE-TEST-TYPE           PIC X.                  
           05  INDEXES.                                                 
               10  WS-ERR-ARRAY-IDX     PIC S9(04) COMP VALUE ZEROES.   
           05  FLAGS.                                                   
T15090         10  WS-MTR-NOT-FOUND        PIC X(01) VALUE 'N'.         
T15090             88  MTR-NOT-FOUND                 VALUE 'Y'.         
               10  WS-EOF-FLAG             PIC X(01) VALUE 'N'.         
                   88  END-OF-FILE                   VALUE 'Y'.         
               10  WS-IS-INPUT-VALID       PIC X(01) VALUE 'Y'.         
                   88  INPUT-IS-VALID                VALUE 'Y'.         
                   88  INPUT-IS-INVALID              VALUE 'N'.         
               10  WS-RECORD-FLAG          PIC X(01) VALUE 'Y'.         
                   88  GOOD-RECORD                   VALUE 'Y'.         
               10  WS-MASTER-ERROR-FLAG    PIC X(01) VALUE 'N'.         
                   88  NO-ERRORS                     VALUE 'N'.         
               10  WS-DEMAND-METER         PIC X(01)  VALUE 'N'.        
                   88  DEMAND-METER                   VALUE 'Y'.        
               10  WS-READ-FLAG            PIC X(01)  VALUE 'Y'.        
                   88  FIRST-READ                     VALUE 'Y'.        
T19333         10  NO-ERROR-FOUND          PIC X(01)  VALUE 'Y'.        
T19333             88  ERROR-FOUND                    VALUE 'N'.        
C36856         10  WS-INT-ERT-FLAG         PIC X(1)   VALUE 'N'.        
           05  WS-TEMP-CC                  PIC 99.                      
TP4597     05  WS-ACCURACY-PCT             PIC S9(03)V9(03) COMP-3      
TP4597                                                VALUE +0.         
           05  WS-NO-CAP-COUNTER           PIC 9(01)  COMP-3 VALUE 0.   
T15090     05  WS-TEMP-RETURN-CD           PIC S9(09) COMP.             
T15090     05  RS-RETURN-CODE              PIC S9(04) COMP VALUE +0.    
T15090     05  RS-RETURN-CODE-DISP         PIC Z(04).                   
T15090     05  WS-LOCAL-OFFICE.                                         
T15090         10  FILLER                  PIC X(01) VALUE '0'.         
T15090         10  WS-DISTRICT             PIC X(02).                   
           05  WS-MTR-CAP-TIME-PERIOD.                                  
               10  WS-MTR-CAP-TYPE         PIC X(01).                   
               10  WS-TIME-PERIOD          PIC ------9.                 
           05  WS-SYS-DATE.                                             
               10  WS-SYS-DATE-YY          PIC 9(02).                   
               10  WS-SYS-DATE-MM          PIC 9(02).                   
               10  WS-SYS-DATE-DD          PIC 9(02).                   
           05  WS-DB2-TODAYS-DATE          PIC X(10).                   
A04860     05  WS-CURRENT-TIME-STAMP.                                   
A04860         10  WS-DATE-PART            PIC X(10).                   
A04860         10  WS-TIME-PART    PIC X(16) VALUE '-00.00.00.000000'.  
TP4597     05  WS-DATE-OF-TEST             PIC X(10).                   
           05  WS-DB2-DATE.                                             
               10  WS-DB2-CC               PIC X(2).                    
               10  WS-DB2-YY               PIC X(2).                    
               10  FILLER                  PIC X.                       
               10  WS-DB2-MM               PIC X(2).                    
               10  FILLER                  PIC X.                       
               10  WS-DB2-DD               PIC X(2).                    
           05  UTILITY-TYPE-PARM           PIC X(01).                   
T15090     05  WS-BEGIN-DATE               PIC X(10).                   
T15090     05  WS-END-DATE                 PIC X(10).                   
T15090     05  WS-SERIAL-NO                PIC X(11).                   
T15090     05  WS-SER-NO-JUSTIFIED         PIC X(11) JUSTIFIED RIGHT.   
T15090     05  WS-INSPECT-CNTR             PIC 9(02)  VALUE ZERO.       
T35434     05  WS-RESTART-SW               PIC X(1)  VALUE 'N'.         
T35434     05  WS-IS-THIS-A-RESTART        PIC X(01) VALUE 'N'.         
T35434         88  WS-THIS-IS-A-RESTART              VALUE 'Y'.         
T35434 01  WS-RECORD-COUNTERS.                                          
T35434     05  WS-MT04-REC-CNTR        PIC S9(07) COMP-3 VALUE ZERO.    
T35434     05  WS-MT04-REC-CNTR-TOT    PIC S9(07) COMP-3 VALUE ZERO.    
T35434     05  WS-MT04-KEY             PIC 9(09)  VALUE ZERO.           
T35434     05  WS-COMMITS-COUNT            PIC 9(4)  VALUE ZEROES.      
T35434     05  WS-RECS-TO-COMMIT-COUNT     PIC 9(3)  VALUE ZEROES.      
T35434******************************************************************        
T35434* DATA USED TO UPDATE CSS_RESTART TABLE AT EVERY DB2 COMMIT.     *        
T35434* LENGTH OF RESTART DATA IS 888.                                 *        
T35434******************************************************************        
T35434                                                                  
T35434 01  WS-RESTART-DATA.                                             
T35434     05  WS-RESTRT-DATA-LEN      PIC S9(4)  USAGE COMP.           
T35434     05  WS-RESTART-PROCESS-TYPE     PIC 9(01).                   
T35434     05  WS-RESTART-JOB-COMPLETE     REDEFINES                    
T35434         WS-RESTART-PROCESS-TYPE     PIC X(01).                   
T35434     05  WS-RESTART-JOB-STATUS       PIC X(01).                   
T35434         88  WS-RUN-COMPLETED-NO-PROBLEMS VALUE 'A'.              
T35434         88  WS-RERUN-COMPLETED           VALUE 'B'.              
T35434         88  WS-RERUN-PENDING             VALUE 'C'.              
T35434     05  WS-RESTRT-INPUT-DATE    PIC X(10).                       
T35434     05  WS-RESTART-CHKP-SEQ-NO  PIC 9(05) VALUE ZERO.            
T35434     05  WS-RESTART-RECORD-NO    PIC 9(07).                       
T35434     05  WS-RESTRT-E-MT04R-KEY   PIC X(09).                       
T35434     05  WS-RESTRT-PART-NO       PIC 9(1).                        
COB305     05 WS-RESTRT-MT04-CNTR        PIC S9(07) COMP-3 VALUE 0.             
T35434     05  WS-RESTRT-VALID-IP-REC  PIC 9(5).                        
T35434     05  WS-RESTRT-GOOD-REC      PIC 9(5).                        
T35434     05  WS-RESTRT-BAD-REC       PIC 9(5).                        
T35434     05  WS-RESTRT-UTIL-TYP-PARM PIC X(1).                        
T35434     05  WS-RESTRT-PROGRAM-DATE  PIC X(10).                       
T35434     05  WS-RESTRT-BEGIN-DATE    PIC X(10).                       
T35434     05  WS-RESTRT-END-DATE      PIC X(10).                       
T35434     05  WS-RESTRT-COMMITS-COUNT PIC 9(4).                        
T35434     05  WS-RESTRT-DATA-REST     PIC X(791).                      
      *                                                                         
T15090 01  WS-CURRENT-TIME.                                             
           05  WS-HH                       PIC 9(02).                   
           05  WS-MM                       PIC 9(02).                   
           05  WS-SS                       PIC 9(02).                   
T15090     05  WS-TT                       PIC 9(02).                   
      *                                                                         
30271  01  WS-CONSTANT.                                                 
30271      05  WS-CONSTANT-6    PIC 9(6).                               
30271      05  WS-CONSTANT-3    PIC 9(3).                               
30271  01  WS-CONSTANT-NUM REDEFINES WS-CONSTANT PIC 9(6)V9(3).         
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-ONE                  PIC X(01) VALUE '1'.             
           05  WS-TWO                  PIC X(01) VALUE '2'.             
           05  WS-THREE                PIC X(01) VALUE '3'.             
           05  WS-D                    PIC X(01) VALUE 'D'.             
           05  WS-E                    PIC X(01) VALUE 'E'.             
           05  WS-F                    PIC X(01) VALUE 'F'.             
TP3285     05  WS-G                    PIC X(01) VALUE 'G'.             
TP4597     05  WS-W                    PIC X(01) VALUE 'W'.             
           05  WS-J                    PIC X(01) VALUE 'J'.             
T15090     05  WS-K                    PIC X(01) VALUE 'K'.             
           05  WS-M                    PIC X(01) VALUE 'M'.             
           05  WS-N                    PIC X(01) VALUE 'N'.             
TP4597     05  WS-R                    PIC X(01) VALUE 'R'.             
           05  WS-S                    PIC X(01) VALUE 'S'.             
           05  WS-T                    PIC X(01) VALUE 'T'.             
           05  WS-X                    PIC X(01) VALUE 'X'.             
           05  WS-Y                    PIC X(01) VALUE 'Y'.             
           05  WS-YES                  PIC X(03) VALUE 'YES'.           
           05  WS-NO                   PIC X(03) VALUE 'NO '.           
           05  WS-KWH                  PIC X(03) VALUE 'KWH'.           
           05  WS-DEM                  PIC X(03) VALUE 'DEM'.           
           05  WS-KVR                  PIC X(03) VALUE 'KVR'.           
           05  WS-QHR                  PIC X(03) VALUE 'QHR'.           
           05  WS-UNKNOWN              PIC X(08) VALUE 'UNKNOWN '.      
           05  WS-ZEROES               PIC X(03) VALUE '000'.           
T22243     05  WS-01                   PIC X(02) VALUE '01'.            
T15090     05  WS-LINE-COUNT           PIC 9(02) VALUE 57.              
T15090     05  WS-PAGE-COUNT           PIC 9(03) VALUE ZEROES.          
T16874     05  WS-SUB                  PIC 9(02) VALUE ZEROES.          
                                                                        
       01  ERROR-HOLD-AREA.                                             
           05  ERR-UTIL-TYPE           PIC X(01).                       
           05  ERR-METER-NBR           PIC X(09).                       
           05  ERR-FIELD               PIC X(20).                       
           05  ERR-FIELD-R REDEFINES                                    
               ERR-FIELD.                                               
               10                          PIC X(05).                   
               10  ERR-FIELD-N             PIC 9(10).9999.              
T15090     05  ERR-PROBLEM.                                             
T15090         10  ERROR-DESC          PIC X(33) VALUE SPACES.          
T18007         10  WS-DASH             PIC X(03) VALUE ' - '.           
T18007         10  ERROR-VALUE         PIC X(09) VALUE SPACES.          
PCR040     05  ERR-CLASS-CD            PIC X(02) VALUE SPACES.          
PCR040     05  ERR-SPEC-CD             PIC X(03) VALUE SPACES.          
                                                                        
       01  WS-ERROR-MSG-BUILD.                                          
           05  MSG-METER-NO                PIC 9(07).                   
           05  MSG-METER-ERROR             PIC X(25).                   
      *                                                                         
C36856 01  WS-WQ-COMMENTS.                                              
C36856     05  WS-WQ-MESSAGE               PIC X(150).                  
      *                                                                         
C36856 01  WS-WQ-COMMENT1.                                              
C36856     05  FILLER                      PIC X(15)  VALUE             
C36856         'ELECTRIC METER '.                                       
C36856     05  WS-WQ-METER-NO              PIC X(09).                   
C36856     05  FILLER                      PIC X(14)  VALUE             
C36856         ' IS INACCURATE'.                                        
      *                                                                         
C36856 01  WS-WQ-COMMENT2.                                              
C36856     05  FILLER                      PIC X(23)  VALUE             
C36856         'RETIRED ELECTRIC METER '.                               
C36856     05  WS-WQ-METER-NO              PIC X(09).                   
C36856     05  FILLER                      PIC X(83)  VALUE             
C36856         'CANNOT BE DELETED BECAUSE IT HAS METER DEVICE,INSTRUMENT        
      -        ' TRANSFORMER ATTACHED TO IT'.                                   
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
       01 WS-PARAMETER-DATA REDEFINES WS-INPUT-DATA-BREAKDOWN.          
T15090    05  WS-DURATION-BEGIN          PIC X(13).                     
              88  BEGIN-DATE-TEXT  VALUE 'BEGIN DATE = '.               
          05  WS-BEGIN-DT-VALUE          PIC X(10).                     
          05  FILLER                     PIC X(01).                     
          05  WS-DURATION-END            PIC X(11).                     
              88  END-DATE-TEXT    VALUE 'END DATE = '.                 
          05  WS-END-DT-VALUE            PIC X(10).                     
T15090 01 FILLER REDEFINES WS-PARAMETER-DATA.                           
          05  WS-PARAMETER-NAME          PIC X(11).                     
              88  UTIL-TYPE-DATA  VALUE 'UTIL TYPE ='.                  
          05  WS-PARAMETER-VALUE         PIC X(02).                     
          05  FILLER REDEFINES WS-PARAMETER-VALUE.                      
              10  UTILITY-TYPE-VALUE     PIC X(01).                     
              10                         PIC X(01).                     
      * WS FOR COMPANY REC COUNT CPD00104.                                      
      *                                                                         
       COPY CWS00104.                                                           
      *                                                                         
       01  WS-ERROR-REPORT.                                             
           05  WS-TITLE-1.                                              
               10  FILLER                      PIC X(01).               
               10  FILLER                      PIC X(08) VALUE          
                   'PCSMT658'.                                          
               10  FILLER                      PIC X(33) VALUE SPACES.  
T22243         10  WS-TITLE1-COMP-NAME         PIC X(29) VALUE          
                   'SOUTH CAROLINA ELECTRIC & GAS'.                     
               10  FILLER                      PIC X(42) VALUE SPACES.  
               10  FILLER                      PIC X(10) VALUE          
                   'RUN DATE: '.                                        
               10  WS-TITLE1-DATE              PIC X(10).               
      *                                                                         
           05  WS-TITLE-2.                                              
               10  FILLER                      PIC X(01).               
               10  FILLER                      PIC X(40) VALUE SPACES.  
               10  FILLER                      PIC X(32) VALUE          
                   'ELECTRIC METER TEST ERROR REPORT'.                  
               10  FILLER                      PIC X(40) VALUE SPACES.  
               10  FILLER                      PIC X(10) VALUE          
                   'RUN TIME: '.                                        
               10  FILLER                      PIC X(02) VALUE SPACES.  
               10  WS-TITLE2-TIME.                                      
                   15 WS-TTL2-HH               PIC X(2)  VALUE SPACES.  
                   15 FILLER                   PIC X(1)  VALUE ':'.     
                   15 WS-TTL2-MM               PIC X(2)  VALUE SPACES.  
                   15 FILLER                   PIC X(1)  VALUE ':'.     
                   15 WS-TTL2-SS               PIC X(2)  VALUE SPACES.  
      *                                                                         
           05  WS-TITLE-3.                                              
               10  FILLER                      PIC X(01).               
               10  FILLER                      PIC X(116) VALUE SPACES. 
               10  FILLER                      PIC X(08) VALUE          
                   'PAGE:   '.                                          
               10  FILLER                      PIC X(02) VALUE SPACES.  
               10  WS-TITLE3-PAGE-COUNT        PIC ZZ,ZZ9.              
      *                                                                         
           05  WS-TITLE-4.                                              
               10  FILLER                      PIC X(01).               
               10  FILLER                      PIC X(15) VALUE          
                   'LOCAL OFFICE - '.                                   
               10  WS-TITLE4-LOCAL-OFF         PIC X(03) VALUE SPACES.  
               10  FILLER                      PIC X(02) VALUE SPACES.  
               10  WS-TITLE4-LOCAL-OFF-DESC    PIC X(25) VALUE SPACES.  
               10  FILLER                      PIC X(96) VALUE SPACES.  
      *                                                                         
           05  WS-TITLE-5.                                              
               10  FILLER                      PIC X(01).               
               10  FILLER                      PIC X(24) VALUE SPACES.  
               10  FILLER                      PIC X(04) VALUE          
                   'TEST'.                                              
               10  FILLER                      PIC X(12) VALUE SPACES.  
               10  FILLER                      PIC X(04) VALUE          
                   'A.F.'.                                              
               10  FILLER                      PIC X(05) VALUE SPACES.  
               10  FILLER                      PIC X(04) VALUE          
                   'A.F.'.                                              
               10  FILLER                      PIC X(04) VALUE SPACES.  
               10  FILLER                      PIC X(04) VALUE          
                   'A.L.'.                                              
               10  FILLER                      PIC X(05) VALUE SPACES.  
               10  FILLER                      PIC X(05) VALUE          
                   'A.L.'.                                              
               10  FILLER                      PIC X(04) VALUE SPACES.  
               10  FILLER                      PIC X(05) VALUE          
                   'METER'.                                             
               10  FILLER                      PIC X(51) VALUE SPACES.  
      *                                                                         
           05  WS-TITLE-6.                                              
               10  FILLER                      PIC X(01).               
               10  FILLER                      PIC X(11) VALUE          
                   'DATE TESTED'.                                       
               10  FILLER                      PIC X(01) VALUE SPACES.  
               10  FILLER                      PIC X(08) VALUE          
                   'METER NO'.                                          
               10  FILLER                      PIC X(03) VALUE SPACES.  
               10  FILLER                      PIC X(06) VALUE          
                   'REASON'.                                            
               10  FILLER                      PIC X(01) VALUE SPACES.  
               10  FILLER                      PIC X(09) VALUE          
                   'TESTER'.                                            
               10  FILLER                      PIC X(01) VALUE SPACES.  
               10  FILLER                      PIC X(04) VALUE          
                   'FULL'.                                              
               10  FILLER                      PIC X(04) VALUE SPACES.  
               10  FILLER                      PIC X(05) VALUE          
                   'LIGHT'.                                             
               10  FILLER                      PIC X(04) VALUE SPACES.  
               10  FILLER                      PIC X(04) VALUE          
                   'FULL'.                                              
               10  FILLER                      PIC X(05) VALUE SPACES.  
               10  FILLER                      PIC X(05) VALUE          
                   'LIGHT'.                                             
               10  FILLER                      PIC X(04) VALUE SPACES.  
               10  FILLER                      PIC X(05) VALUE          
                   'INDEX'.                                             
               10  FILLER                      PIC X(02) VALUE SPACES.  
T18007         10  FILLER                      PIC X(18) VALUE          
T18007             'ERROR DESC - VALUE'.                                
T18007         10  FILLER                      PIC X(22) VALUE SPACES.  
      *                                                                         
           05  WS-DETAIL-1.                                             
               10  FILLER                      PIC X(01).               
               10  WS-DTL-DATE-TEST            PIC X(10).               
               10  FILLER                      PIC X(02) VALUE SPACES.  
               10  WS-DTL-MTR-NO               PIC X(09).               
               10  FILLER                      PIC X(04) VALUE SPACES.  
               10  WS-DTL-TEST-REASON          PIC X(01) VALUE SPACES.  
               10  FILLER                      PIC X(06) VALUE SPACES.  
               10  WS-DTL-TESTER-CD            PIC X(02) VALUE SPACES.  
               10  FILLER                      PIC X(05) VALUE SPACES.  
               10  WS-DTL-AF-FULL-LD           PIC Z(3).99.             
               10  FILLER                      PIC X(03) VALUE SPACES.  
               10  WS-DTL-AF-LIGHT-LD          PIC Z(3).99.             
               10  FILLER                      PIC X(03) VALUE SPACES.  
               10  WS-DTL-AL-FULL-LD           PIC Z(3).99.             
               10  FILLER                      PIC X(03) VALUE SPACES.  
               10  WS-DTL-AL-LIGHT-LD          PIC Z(3).99.             
               10  FILLER                      PIC X(03) VALUE SPACES.  
               10  WS-DTL-METER-INDEX          PIC X(05) VALUE SPACES.  
               10  FILLER                      PIC X(02) VALUE SPACES.  
T18007         10  WS-DTL-ERR-DESC             PIC X(45) VALUE SPACES.  
      *                                                                         
           05  WS-END-OF-DATA.                                          
               10  FILLER                      PIC X(55)  VALUE SPACES. 
               10  FILLER                      PIC X(23)  VALUE         
                   '*** END OF REPORT *** '.                            
               10  FILLER                      PIC X(54)  VALUE SPACES. 
      *                                                                         
T19333     05  WS-NO-ERROR-LINE.                                        
               10  FILLER                      PIC X(55)  VALUE SPACES. 
               10  FILLER                      PIC X(23)  VALUE         
                   '*** NO ERRORS FOUND ***'.                           
               10  FILLER                      PIC X(54)  VALUE SPACES. 
      *                                                                         
       01 WS-DET-LINE-2.                                                
          05  FILLER                   PIC X(05)  VALUE SPACES.         
          05  WS-RPT-MESSAGE           PIC X(20)  VALUE SPACES.         
          05  FILLER                   PIC X(03)                        
              VALUE ':  '.                                              
          05  WS-RPT-STATISTICS        PIC ZZZZ9  VALUE SPACES.         
      *                                                                         
       01  WS-ERROR-RPT-MSGS.                                           
           05 WS-TOT-RECDS-INFO        PIC X(18)    VALUE               
              ' VALID I/P RECORDS'.                                     
           05 WS-TOT-GOOD-RECDS        PIC X(13)    VALUE               
              ' GOOD RECORDS'.                                          
           05 WS-TOT-BAD-RECDS         PIC X(12)    VALUE               
              ' BAD RECORDS'.                                           
      *                                                                         
      *****************************************************************         
      **      INCLUDE DLCGEN TABLE AND HOST VARIABLE DEFINTIONS      **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBELMTR                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEMTEST                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
TP4597* CSS_MTR_TEST_HIST                                                       
      *                                                                         
TP4597     EXEC SQL                                                             
TP4597         INCLUDE TBMTRTST                                                 
TP4597     END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQTTYP                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQTRPR                                                 
T15090     END-EXEC.                                                            
      *                                                                         
      * TABLE DECLARATION FOR CSS_LOCAL_OFFICE ********************             
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMVHIST                                                 
T15090     END-EXEC.                                                            
      *                                                                         
T22243****************************************************************          
T22243*    CSS_COMPANY                                               *          
T22243****************************************************************          
      *                                                                         
T22243     EXEC SQL                                                             
T22243         INCLUDE TBCOMPNY                                                 
T22243     END-EXEC.                                                            
      *                                                                         
31683 ****************************************************************          
31683 *    CSS_METER_ATTCHMTS                                        *          
31683 ****************************************************************          
      *                                                                         
31683      EXEC SQL                                                             
31683          INCLUDE TBMTRATT                                                 
31683      END-EXEC.                                                            
      *                                                                         
31683 ****************************************************************          
31683 *    CSS_CUST_PREM_HIST                                        *          
31683 ****************************************************************          
      *                                                                         
31683      EXEC SQL                                                             
31683          INCLUDE TBCSTPRM                                                 
31683      END-EXEC.                                                            
*                                                                       
T35434******************************************************************        
T35434* COBOL DECLARATION FOR TABLE CSS_RESTART                    *            
T35434******************************************************************        
T35434     EXEC SQL                                                             
T35434         INCLUDE TBRESTRT                                                 
T35434     END-EXEC.                                                            
T35434*                                                                         
*                                                                       
C36856******************************************************************        
C36856* CSS_MTR_ATT_TYPE (N5)                                      *            
C36856******************************************************************        
C36856     EXEC SQL                                                             
C36856         INCLUDE TBMTRATP                                                 
C36856     END-EXEC.                                                            
C36856*                                                                         
*                                                                       
C36856******************************************************************        
C36856* CSS_EQUIP_ATT_MOVE (MP)                                    *            
C36856******************************************************************        
C36856     EXEC SQL                                                             
C36856         INCLUDE TBEQMOVE                                                 
C36856     END-EXEC.                                                            
C36856*                                                                         
*                                                                       
C36856******************************************************************        
C36856* CSS_EQUIP_ATTCHMTS  (LX)                                   *            
C36856******************************************************************        
C36856     EXEC SQL                                                             
C36856         INCLUDE TBEQATTH                                                 
C36856     END-EXEC.                                                            
C36856*                                                                         
      *****************************************************************         
      **      END OF DLCGEN TABLE AND HOST VARIABLE DEFINTIONS       **         
      *****************************************************************         
      *                                                                         
       01  WS-INPUT.                                                    
           10  WS-INPUT-TYPE             PIC X(1).                      
           10  WS-INPUT-ID               PIC X(5).                      
           10  WS-INPUT-IDS    REDEFINES WS-INPUT-ID.                   
               15  WS-INPUT-IDA          PIC X(1) OCCURS 5 TIMES.       
           10  WS-INPUT-ID9S.                                           
               15 WS-INPUT-IDB           PIC X(1) OCCURS 5 TIMES        
                                         VALUE SPACES.                  
           10  WS-INPUT-ID9    REDEFINES WS-INPUT-ID9S                  
                                         PIC X(5).                      
           10  WS-INPUT-RC               PIC 9(1).                      
                                                                        
       01  WS-NO-EMPL-ID                 PIC S9(4) COMP.                
       01  WS-NUM-FLAG                   PIC X VALUE 'N'.               
       01  WS-CTR                        PIC 9 VALUE 0.                 
       01  WS-CTR-END                    PIC 9 VALUE 0.                 
       01  WS-MAX                        PIC 9 VALUE 6.                 
       01  WS-I                          PIC X VALUE 'I'.               
       01  WS-CTR-ST                     PIC 9 VALUE 0.                 
A04860/****** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077             
A04860      EXEC SQL                                                            
A04860           INCLUDE CWS00077                                               
A04860      END-EXEC.                                                           
A04860*                                                                         
      *                                                                         
      *****************************************************************         
      **   SQL DECLARE STATEMENTS                                    **         
      *****************************************************************         
      *                                                                         
      *****************************************************************         
      * CURSOR DECLARATION       MOVE-HIST-CURSOR                     *         
      * THE FOLLOWING SELECT IS USED TO GET THE LATEST MOVEMENT       *         
      * HISTORY RECORD WITH LOCATION CODE = 'J' INSTALLED OR 'K'      *         
      * ATTACHED                                                      *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
               DECLARE MOVE-HIST-CURSOR CURSOR FOR                      
               SELECT  LOC_NO                                           
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), MOVE_NO, 121), 
           ' ', '-'), ':', '.') MOVE_NO                                        
                 FROM  CSS_MOVEMENT_HIST WITH(READUNCOMMITTED)                  
                WHERE  CODE_UTIL_TYPE   = :WS-E                         
T22243            AND  COMPANY_NO       = :MV-COMPANY-NO                
                  AND  DEVICE_NO        = :MV-DEVICE-NO                 
                  AND  CODE_CRNT_LOC   IN (:WS-J, :WS-K)                
                  AND  DATE_MOVE       <= IIF(TRY_CONVERT(DATE, 
                                                          :MV-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MV-DATE-MOVE
              ) <> 0) OR (LEN(:MV-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MV-DATE-MOVE
              ), CONVERT(DATE, :MV-DATE-MOVE) )                 
             ORDER BY  MOVE_NO DESC                                     
A03352       FOR READ ONLY                                      
A03352                                                      
ST         END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MOVE-HIST-CURSOR CURSOR FOR                              
MFA-TR*        SELECT  LOC_NO                                                   
MFA-TR*               ,MOVE_NO                                                  
MFA-TR*          FROM  CSS_MOVEMENT_HIST                                        
MFA-TR*         WHERE  CODE_UTIL_TYPE   = :WS-E                                 
MFA-TR*           AND  COMPANY_NO       = :MV-COMPANY-NO                        
MFA-TR*           AND  DEVICE_NO        = :MV-DEVICE-NO                         
MFA-TR*           AND  CODE_CRNT_LOC   IN (:WS-J, :WS-K)                        
MFA-TR*           AND  DATE_MOVE       <= :MV-DATE-MOVE                         
MFA-TR*      ORDER BY  MOVE_NO DESC                                             
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
C36856*****************************************************************         
C36856* CURSOR DECLARATION       INT-ERT                              *         
C36856* THE FOLLOWING SELECT IS USED TO CHECK IF METER HAS INTEGRATED *         
C36856* HOW_ATTCHED_CD = 'I'                                          *         
C36856*****************************************************************         
C36856*                                                                         
C36856     EXEC SQL                                                     
C36856          DECLARE INT-ERT CURSOR FOR                              
C36856          SELECT                                                  
C36856                MA.DEVICE_NO,                                     
C36856                MA.CODE_ATT_TYPE                                  
C36856          FROM  CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED),              
C36856                CSS_MTR_ATT_TYPE N5 WITH(READUNCOMMITTED)                 
C36856          WHERE MA.CODE_UTIL_TYPE   = :MA-CODE-UTIL-TYPE          
C36856          AND   MA.COMPANY_NO       = :MA-COMPANY-NO              
C36856          AND   MA.METER_NO         = :MA-METER-NO                
C36856          AND   MA.HOW_ATTACHED_CD  = 'I'                         
C36856          AND   N5.CODE_UTIL_TYPE   = MA.CODE_UTIL_TYPE           
C36856          AND   N5.CODE_ATT_TYPE    = MA.CODE_ATT_TYPE            
C36856          FOR READ ONLY                                   
A03352                                                      
C36856     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE INT-ERT CURSOR FOR                                      
MFA-TR*         SELECT                                                          
MFA-TR*               MA.DEVICE_NO,                                             
MFA-TR*               MA.CODE_ATT_TYPE                                          
MFA-TR*         FROM  CSS_METER_ATTCHMTS MA,                                    
MFA-TR*               CSS_MTR_ATT_TYPE N5                                       
MFA-TR*         WHERE MA.CODE_UTIL_TYPE   = :MA-CODE-UTIL-TYPE                  
MFA-TR*         AND   MA.COMPANY_NO       = :MA-COMPANY-NO                      
MFA-TR*         AND   MA.METER_NO         = :MA-METER-NO                        
MFA-TR*         AND   MA.HOW_ATTACHED_CD  = 'I'                                 
MFA-TR*         AND   N5.CODE_UTIL_TYPE   = MA.CODE_UTIL_TYPE                   
MFA-TR*         AND   N5.CODE_ATT_TYPE    = MA.CODE_ATT_TYPE                    
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7410                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                       PIC X(40) VALUE                 
           'WORKING STORAGE FOR PCSMT658 ENDS HERE  '.                  
      *                                                                         
       PROCEDURE DIVISION.                                              
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   CONTROLS MAIN PATH OF PROGRAM                                *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZATION.                                 
                                                                        
           PERFORM 1000-PROCESS-FILE THRU 1000-EXIT UNTIL END-OF-FILE.  
           PERFORM 8900-PRODUCE-SUMMARY-REPORTS THRU 8900-EXIT.         
                                                                        
T35434     MOVE SPACES               TO WS-INPUT-AREA                   
T35434     PERFORM  5000-PROCESS-SUCCESSFUL THRU 5000-EXIT.             
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
      *                                                                         
      *****************************************************************         
      * OPEN FILES, DO FIRST READ OF METER TEST FILE, ACCEPT DATE     *         
      *****************************************************************         
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
T18007     OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
TP4597     OPEN INPUT FCSMT04-FILE.                                     
      *                                                                         
           ACCEPT WS-SYS-DATE FROM DATE.                                
           IF WS-SYS-DATE-YY > 50                                       
              MOVE 19 TO WS-TEMP-CC                                     
           ELSE                                                         
              MOVE 20 TO WS-TEMP-CC                                     
           END-IF.                                                      
                                                                        
           STRING WS-TEMP-CC,                                           
                  WS-SYS-DATE-YY,                                       
                  '-',                                                  
                  WS-SYS-DATE-MM,                                       
                  '-',                                                  
                  WS-SYS-DATE-DD                                        
             DELIMITED BY SIZE                                          
             INTO WS-DB2-TODAYS-DATE.                                   
                                                                        
           STRING WS-TEMP-CC,                                           
                  WS-SYS-DATE-YY,                                       
                  WS-SYS-DATE-MM,                                       
                  WS-SYS-DATE-DD                                        
             DELIMITED BY SIZE                                          
             INTO WS-CURRENT-FULL-DATE.                                 
                                                                        
T22243     ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
T22243     IF  WS-SYSIN-COMP-NO = SPACES OR LOW-VALUES                  
T22243         MOVE WS-01 TO WS-SYSIN-COMP-NO                           
T22243     END-IF.                                                      
      *                                                                         
T22243     MOVE WS-SYSIN-COMP-NO TO EQ-COMPANY-NO                       
T22243                              EM-COMPANY-NO                       
T22243                              ET-COMPANY-NO                       
T22243                              MQ-COMPANY-NO                       
T22243                              B1-COMPANY-NO                       
T22243                              C7-COMPANY-NO                       
T22243                              MV-COMPANY-NO                       
T33887                              N3-COMPANY-NO.                      
      *                                                                         
T22243     DISPLAY '*********************************'                  
T22243     DISPLAY '* JOB IS RUNNING FOR COMPANY = ', EQ-COMPANY-NO     
T22243     DISPLAY '*********************************'                  
T22243     PERFORM  7350-GET-COMPANY-DESC THRU 7350-EXIT.               
T22243     MOVE C7-COMPANY-NAME TO WS-TITLE1-COMP-NAME.                 
      *                                                                         
           INITIALIZE ERROR-HOLD-AREA.                                  
           INITIALIZE COMPANY-END-REC.                                  
           INITIALIZE COMPANY-END-REC-DATA.                             
A04860     INITIALIZE CWS00077-FIELDS                                   
                                                                        
T18007     MOVE '-' TO WS-DASH.                                         
T15090     MOVE WS-DB2-TODAYS-DATE TO WS-TITLE1-DATE.                   
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH TO WS-TTL2-HH.                                    
           MOVE WS-MM TO WS-TTL2-MM.                                    
           MOVE WS-SS TO WS-TTL2-SS.                                    
T35434                                                                  
T35434     PERFORM 6253-GET-FJC01-CHKP-LIMIT  THRU 6253-EXIT            
T35434*                                                                         
T35434     IF WS-CHKP-LUW-LIMIT = WS-FLAG-TO-TURN-OFF-COMMITS           
T35434       AND WS-CHKP-UPD-LIMIT = WS-FLAG-TO-TURN-OFF-COMMITS        
T35434         SET WS-COMMITS-NOT-REQUIRE TO TRUE                       
T35434         DISPLAY ' '                                              
T35434         DISPLAY '**   ' WS-PGRMNAME ' INFORMATIONAL MSG    **'   
T35434         DISPLAY '** NO INTERIM COMMIT POINTS TO BE EXECUTED ** ' 
T35434     END-IF                                                       
T35434*                                                                         
T35434     PERFORM 6235-GET-FJC01-RESTART-REQ  THRU 6235-EXIT.          
T35434*                                                                         
T35434     PERFORM 0110-PREPARE-FOR-RESTART THRU 0110-EXIT.             
T35434     PERFORM 0605-VALIDATE-RESTART-REQ   THRU 0605-EXIT.          
T35434     IF  WS-THIS-IS-A-RESTART                                     
T35434         PERFORM 0111-RECOVER-FIELDS  THRU 0111-EXIT              
T35434         PERFORM 0112-POSITION-FILES  THRU 0112-EXIT              
T35434     ELSE                                                         
T35434         PERFORM 0113-INITIALIZE-RESTART  THRU 0113-EXIT          
T35434     END-IF.                                                      
T35434     IF WS-RESTART-SW NOT = 'Y'                                   
              PERFORM 0200-GET-PARM THRU 0200-EXIT                      
T35434     END-IF.                                                      
           PERFORM 8100-READ-METER-TEST-FILE THRU 8100-EXIT.            
T35434     IF NOT END-OF-FILE                                           
T35434        ADD 1 TO WS-NBR-METER-TEST-RECS                           
T35434     END-IF.                                                      
T35434                                                                  
T35434     ADD 1 TO WS-RECS-TO-COMMIT-COUNT.                            
T35434                                                                  
      *                                                                         
T35434******************************************************************        
T35434*   0110-PREPARE-FOR-RESTART                                     *        
T35434*        CHECK CSS_RESTART TABLE TO SEE IF THIS IS A RESTART OR  *        
T35434*   A NORMAL RUN.  IF A ROW IS FOUND IN THIS TABLE FOR PROGRAM   *        
T35434*   PCSMT658, THE RESTART LOGIC IS EXECUTED.  OTHERWISE, NORMAL  *        
T35434*   PROCESSING IS FOLLOWED.                                      *        
T35434******************************************************************        
T35434 0110-PREPARE-FOR-RESTART.                                        
T35434*                                                                         
T35434     MOVE SPACES                  TO WS-RESTART-DATA.             
T35434     MOVE 'PCSMT658'              TO RF-NAME-PROGRAM.             
T35434     MOVE 1                       TO RF-PARTITION-NO.             
T35434     MOVE 1                       TO RF-DUP-CNTRL-NO.             
T35434                                                                  
T35434     EXEC SQL                                                     
T35434         SELECT RESTART_DATA                                      
T35434           INTO :RF-RESTART-DATA                                  
T35434           FROM CSS_RESTART WITH(READUNCOMMITTED)                         
T35434         WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                    
T35434           AND PARTITION_NO = :RF-PARTITION-NO                    
T35434           AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                    
T35434                                                           
A03352                                                      
T35434     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESTART_DATA                                              
MFA-TR*          INTO :RF-RESTART-DATA                                          
MFA-TR*          FROM CSS_RESTART                                               
MFA-TR*        WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                            
MFA-TR*          AND PARTITION_NO = :RF-PARTITION-NO                            
MFA-TR*          AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 0110                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35434     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T35434     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T35434         MOVE RF-RESTART-DATA     TO WS-RESTART-DATA              
T35434         IF WS-RESTART-PROCESS-TYPE NUMERIC                       
T35434            DISPLAY '*****************************************'   
T35434            DISPLAY '**                                       '   
T35434            DISPLAY '** ROW FOUND IN CSS_RESTART - PCSMT658 **'   
T35434            DISPLAY '**     RESTART LOGIC WILL BE FOLLOWED    '   
T35434            DISPLAY '**                                       '   
T35434           DISPLAY '******************************************'   
T35434            MOVE 'Y'              TO WS-RESTART-SW                
T35434            MOVE WS-Y             TO WS-IS-THIS-A-RESTART         
T35434         ELSE                                                     
T35434            MOVE WS-N             TO WS-IS-THIS-A-RESTART         
T35434             MOVE 'N'             TO WS-RESTART-SW                
T35434         END-IF                                                   
T35434     ELSE                                                         
T35434         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
T35434             MOVE WS-N            TO WS-IS-THIS-A-RESTART         
T35434             MOVE 'N'             TO WS-RESTART-SW                
T35434         ELSE                                                     
T35434             DISPLAY '**  PROCESSING ERROR IN PGM PCSMT658  **'   
T35434             DISPLAY '**  PARA - 0110-PREPARE-FOR-RESTART   **'   
T35434             DISPLAY '**      ERROR DURING SELECT FOR       **'   
T35434             DISPLAY '**             CSS_RESTART            **'   
T35434             DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE            
T35434             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
T35434     END-IF
           END-IF.                                                      
T35434 0110-EXIT.                                                       
T35434     EXIT.                                                        
T35434                                                                  
T35434******************************************************************        
T35434*   0111-RECOVER-FIELDS                                          *        
T35434*        DATA THAT WAS ASAVED AT THE TIME OF COMMIT IS MOVED     *        
T35434*   BACK TO THE ORIGINAL FIELDS.                                 *        
T35434******************************************************************        
T35434 0111-RECOVER-FIELDS.                                             
T35434*                                                                         
T35434     MOVE WS-RESTRT-E-MT04R-KEY   TO WS-MT04-KEY.                 
T35434     MOVE WS-RESTRT-VALID-IP-REC  TO WS-NBR-METER-TEST-RECS.      
T35434     MOVE WS-RESTRT-GOOD-REC      TO WS-NBR-GOOD-RECS.            
T35434     MOVE WS-RESTRT-BAD-REC       TO WS-NBR-BAD-RECS.             
T35434     MOVE WS-RESTRT-UTIL-TYP-PARM TO UTILITY-TYPE-PARM.           
T35434     MOVE WS-RESTRT-BEGIN-DATE    TO WS-BEGIN-DATE.               
T35434     MOVE WS-RESTRT-END-DATE      TO WS-END-DATE.                 
T35434*    MOVE WS-RESTRT-INPUT-DATE    TO WS-PROGRAM-DATE                      
T35434*                                    WS-INPUT-DATE                        
T35434*                                    WS-HOLD-DATE.                        
T35434     MOVE WS-RESTRT-PROGRAM-DATE  TO WS-DB2-TODAYS-DATE.          
T35434     MOVE WS-RESTRT-COMMITS-COUNT TO WS-COMMITS-COUNT.            
T35434*                                                                         
T35434 0111-EXIT.                                                       
T35434     EXIT.                                                        
T35434*                                                                         
T35434******************************************************************        
T35434*   0112-POSITION-FILES                                          *        
T35434*        INPUT FILE FCSMT04 IS POSITION AFTER THE LAST RECORD    *        
T35434*   THAT WAS PROCESSED AND COMMITED.  THE REPORT DETAILS SUCH AS *        
T35434*   VALID I/P RECORDS , GOOD RECORDS AND BAD RECORDS ARE LOADED  *        
T35434*   A NEW REPORT FCSPT33 WILL BE CREATED FOR THE RESTART RUN AND *        
T35434*   HAVE THE OLD OLD DATA AND GETS ACCUMULATED WITH THIS RESTART *        
T35434*   RUN.                                                         *        
T35434******************************************************************        
T35434 0112-POSITION-FILES.                                             
T35434*                                                                         
T35434     PERFORM 8100-READ-METER-TEST-FILE THRU 8100-EXIT UNTIL       
T35434     WS-RESTRT-MT04-CNTR  = WS-MT04-REC-CNTR.                     
T35434*                                                                         
T35434  0112-EXIT.                                                      
T35434      EXIT.                                                       
T35434*==============================================================*          
T35434 0113-INITIALIZE-RESTART.                                         
T35434*==============================================================*          
T35434*                                                                         
T35434     MOVE 0                        TO WS-RESTART-PROCESS-TYPE.    
T35434     MOVE WS-DB2-TODAYS-DATE       TO WS-RESTRT-INPUT-DATE.       
T35434     MOVE ZERO                     TO WS-RESTART-CHKP-SEQ-NO.     
T35434     SET WS-RERUN-PENDING          TO TRUE.                       
T35434*                                                                         
T35434 0113-EXIT.                                                       
T35434     EXIT.                                                        
T35434*                                                                         
      *****************************************************************         
      * READ CSS_JOB_PARM TO GET UTILITY TYPE                         *         
      *****************************************************************         
      *                                                                         
       0200-GET-PARM.                                                   
      *                                                                         
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           MOVE WS-PARM TO WS-COMMAND.                                  
           MOVE ZEROES TO WS-SEQUENCE.                                  
           INITIALIZE WS-SYSIPT UTILITY-TYPE-PARM.                      
           MOVE WS-KEY-AREA TO E-FJC01-KEY.                             
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
           PERFORM 7610-READ-FCSJC01  THRU 7610-EXIT.                   
           PERFORM 0250-PROCESS-PARM  THRU 0250-EXIT                    
               UNTIL END-OF-SYSIPT.                                     
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       0250-PROCESS-PARM.                                               
T19333     MOVE SPACES TO WS-BEGIN-DATE                                 
T19333                    WS-END-DATE.                                  
           IF E-FJC01-CMND-CODE = WS-PARM                               
              IF E-FJC01-STATUS = WS-A                                  
T15090        IF E-FJC01-SEQ-NBR = 1                                    
                 MOVE E-FJC01-PARAMETER-DATA TO WS-PARAMETER-DATA       
                 IF UTIL-TYPE-DATA                                      
                    MOVE UTILITY-TYPE-VALUE  TO UTILITY-TYPE-PARM       
                 ELSE                                                   
                     DISPLAY '***************PCSMT658***************'   
                     DISPLAY '* INVALID PARM IN CSS_JOB_PARM TABLE *'   
                     DISPLAY '* DATA NAME IS ', WS-PARAMETER-NAME       
                     DISPLAY '* DATA VALUE IS ', WS-PARAMETER-VALUE     
                     DISPLAY '* PROGRAM ABORTING...                *'   
                     DISPLAY '***************PCSMT658***************'   
                     PERFORM 9900-ABEND THRU 9900-EXIT                  
                 END-IF                                                 
T15090        ELSE                                                      
T15090        IF E-FJC01-SEQ-NBR = 2                                    
                 MOVE E-FJC01-PARAMETER-DATA TO WS-PARAMETER-DATA       
                 IF BEGIN-DATE-TEXT AND END-DATE-TEXT                   
                    MOVE WS-BEGIN-DT-VALUE  TO WS-BEGIN-DATE            
                    MOVE WS-END-DT-VALUE    TO WS-END-DATE              
                 ELSE                                                   
                     DISPLAY '***************PCSMT658***************'   
                     DISPLAY '* INVALID PARM IN CSS_JOB_PARM TABLE *'   
                     DISPLAY '* FOR SEQ NO   ', E-FJC01-SEQ-NBR         
                     DISPLAY '* PROGRAM ABORTING...                *'   
                     DISPLAY '***************PCSMT658***************'   
                     PERFORM 9900-ABEND THRU 9900-EXIT                  
                 END-IF                                                 
              END-IF                                                    
              END-IF                                                    
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7610-READ-FCSJC01  THRU 7610-EXIT.                   
      *                                                                         
       0250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   RECEIVE, EDIT, AND PROCESS INPUT                             *        
      ******************************************************************        
      * FOR UTIL TYPE = 'E'                                        *            
      *      UPDATE DATE_LAST_TEST ON CSS_ELEC_METER,              *            
      *      SETUP AND INSERT         CSS_ELEC_MTR_TEST.           *            
      **************************************************************            
      * FOR ALL UTIL TYPES                                         *            
      * UPDATE DATE_LAST_TRAN ON CSS_EQUIPMENT.                    *            
      **************************************************************            
      *                                                                         
       1000-PROCESS-FILE.                                               
      *                                                                         
TP4597     IF  UTILITY-TYPE-PARM = WS-E                                 
TP4597         PERFORM 1200-PROCESS-ELEC-MTR THRU 1200-EXIT             
TP4597     END-IF.                                                      
                                                                        
           IF INPUT-IS-VALID                                            
               ADD 1 TO WS-NBR-GOOD-RECS                                
           ELSE                                                         
               ADD 1 TO WS-NBR-BAD-RECS                                 
           END-IF.                                                      
                                                                        
T35434      PERFORM 1400-PROCESS-COMMIT       THRU 1400-EXIT.           
T35434*                                                                         
           PERFORM 8000-INITIALIZE THRU 8000-EXIT.                      
           PERFORM 8100-READ-METER-TEST-FILE THRU 8100-EXIT.            
T35434     IF NOT END-OF-FILE                                           
T35434        ADD 1 TO WS-NBR-METER-TEST-RECS                           
T35434     END-IF.                                                      
T35434                                                                  
T35434     ADD 1 TO WS-RECS-TO-COMMIT-COUNT.                            
T35434                                                                  
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       1200-PROCESS-ELEC-MTR.                                           
      *                                                                         
           PERFORM 2000-EDIT-RECORD THRU 2000-EXIT.                     
                                                                        
           IF INPUT-IS-INVALID                                          
               GO TO 1200-EXIT                                          
           END-IF.                                                      
      *                                                                         
31683      IF E-FMT04-REASON-FOR-TEST = 'I'                             
T18007        PERFORM 1250-RETIRE-METER THRU 1250-EXIT                  
T18007        GO TO 1200-EXIT                                           
T18007     END-IF.                                                      
      *                                                                         
           MOVE E-FMT04-METER-NO           TO ET-METER-NO.              
TP4597     MOVE WS-DATE-OF-TEST            TO ET-DATE-TEST.             
EMTEST     MOVE '00:01:00'                 TO ET-TIME-TEST.             
TP4597     MOVE ZEROS                      TO ET-CODE-TIME-PERIOD.      
TP4597     MOVE 'A'                        TO ET-CODE-CAP-TYPE.         
T18007     MOVE WS-CODE-REPAIR             TO ET-CODE-REPAIR.           
      *                                                                         
TP4597*    MOVE SPACES                     TO ET-REPAIR-DESC.                   
      *                                                                         
31683      MOVE E-FMT04-RETIRE-DESC        TO ET-REPAIR-DESC.           
      *                                                                         
TP4597     MOVE E-FMT04-REASON-FOR-TEST    TO ET-CODE-TEST-TYPE.        
TP4597     MOVE 'A'                        TO ET-CODE-TEST-RESULT.      
      *                                                                         
30271      MOVE E-FMT04-LOCATION           TO ET-CODE-TEST-LOC.         
30271      MOVE ZEROS                      TO WS-CONSTANT.              
30271      MOVE E-FMT04-CONSTANT           TO WS-CONSTANT-6.            
30271      MOVE WS-CONSTANT-NUM            TO ET-IN-CONSTANT.           
      *                                                                         
TP4597     MOVE E-FMT04-METER-INDEX        TO ET-READ-AF.               
TP4597     MOVE ZEROS                      TO ET-DEM-READ-AF.           
TP4597     MOVE E-FMT04-LLD-FOUND-9        TO ET-LIGHT-LOAD-ACCU-AF.    
TP4597     MOVE E-FMT04-FLD-FOUND-9        TO ET-FULL-LOAD-ACCU-AF.     
TP4597     MOVE E-FMT04-LLD-LEFT-9         TO ET-LIGHT-LOAD-ACCU-AL.    
TP4597     MOVE E-FMT04-FLD-LEFT-9         TO ET-FULL-LOAD-ACCU-AL.     
TP4597     MOVE E-FMT04-FLD-POWER-9        TO ET-POWER-FCTR-ACCU-AF.    
TP4597     MOVE E-FMT04-FLD-POWER-L-9      TO ET-POWER-FCTR-ACCU-AL.    
TP4597     MOVE E-FMT04-TEST-TABLE         TO ET-TEST-BENCH-ID.         
TP4597     MOVE ZEROS                      TO ET-READ-AL.               
TP4597     MOVE ZEROS                      TO ET-DEM-READ-AL.           
      *                                                                         
           PERFORM 8630-INSERT-ELEC-MTR-TEST THRU 8630-EXIT.            
      *                                                                         
           IF SQLCODE = -803                                            
               PERFORM 8635-UPDATE-ELEC-MTR-TEST THRU 8635-EXIT         
           END-IF.                                                      
      *                                                                         
T21806     MOVE UTILITY-TYPE-PARM        TO EM-CODE-UTIL-TYPE.          
T21806     MOVE E-FMT04-METER-NO         TO EM-METER-NO.                
T21806     PERFORM 7020-SELECT-ELEC-METER THRU 7020-EXIT.               
T21806     IF  DATE-LAST-TEST-NULL                                      
T21806         MOVE SPACES               TO EM-DATE-LAST-TESTED         
T21806     END-IF.                                                      
      *                                                                         
TP4597     IF  LAST-TEST-SEL-DT-NULL                                    
TP4597         CONTINUE                                                 
TP4597     ELSE                                                         
TP4597         PERFORM 2250-CHECK-TEST-HIST THRU 2250-EXIT              
TP4597     END-IF.                                                      
      *                                                                         
TP4597     COMPUTE  WS-ACCURACY-PCT = ((4 * ET-FULL-LOAD-ACCU-AF)       
TP4597                                    + ET-LIGHT-LOAD-ACCU-AF) / 5  
TP4597     IF  WS-ACCURACY-PCT > +102                                   
A04860         MOVE 133            TO WS-77-CATEGORY-ID                 
A04860         MOVE 4              TO WS-77-ROUTE-CATEGORY              
A04860         MOVE 'N'            TO WS-77-PRIORITY                    
A04860         MOVE ZERO           TO WS-77-SERV-ORDER-NO               
A04860                                WS-77-PREMISE-NO                  
A04860                                WS-77-ACCOUNT-NO                  
C36856                                EQ-CRNT-LOC-NO                    
C36856                                MV-LOC-NO                         
C36856                                AT-PREMISE-NO                     
C36856                                AT-ACCOUNT-NO                     
A04860                                WS-77-CUSTOMER-NO                 
A04860         MOVE SPACES         TO WS-77-RESP-AREA-ID                
A04860                                WS-77-LOCAL-OFFICE                
C36856         MOVE ET-METER-NO    TO EQ-DEVICE-NO                      
C36856         MOVE ET-METER-NO    TO WS-WQ-METER-NO OF WS-WQ-COMMENT1  
C36856         MOVE WS-WQ-COMMENT1 TO WS-WQ-MESSAGE                     
               PERFORM 2300-CREATE-WORK-QUEUE THRU 2300-EXIT            
           END-IF.                                                      
      *                                                                         
           MOVE UTILITY-TYPE-PARM        TO EM-CODE-UTIL-TYPE.          
           MOVE E-FMT04-METER-NO         TO EM-METER-NO.                
TP4597     MOVE WS-DATE-OF-TEST          TO EM-DATE-LAST-TESTED.        
           PERFORM 8640-UPDATE-ELEC-METER THRU 8640-EXIT.               
      *                                                                         
           MOVE UTILITY-TYPE-PARM TO EQ-CODE-UTIL-TYPE.                 
           MOVE E-FMT04-METER-NO  TO EQ-DEVICE-NO.                      
           PERFORM 8600-UPDATE-EQUIP THRU 8600-EXIT.                    
      *                                                                         
C34152* POST TEST RESULTS AND THEN RETIRE THE METER FOR SAMPLE SELECTED         
C34152     IF E-FMT04-REASON-FOR-TEST = 'F'                             
C34152         PERFORM 1250-RETIRE-METER THRU 1250-EXIT                 
C34152     END-IF.                                                      
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T18007 1250-RETIRE-METER.                                               
      *                                                                         
31683      MOVE 'N' TO WS-EXISTS.                                       
      *                                                                         
T18007     MOVE E-FMT04-METER-NO TO EQ-DEVICE-NO.                       
C36856     MOVE EQ-DEVICE-NO TO MA-METER-NO.                            
C36856     MOVE 'E' TO MA-CODE-UTIL-TYPE.                               
C36856     MOVE EQ-COMPANY-NO TO MA-COMPANY-NO.                         
      *                                                                         
T18007     PERFORM 7000-SELECT-COMP-NO THRU 7000-EXIT.                  
      *                                                                         
31683      PERFORM 7400-METER-ATTCHMTS THRU 7400-EXIT.                  
      *                                                                         
31683      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36856        IF WS-EXISTS = 'Y'                                        
A03352           IF EQ-COMPANY-NO = '01'                                
A04860              MOVE 528         TO WS-77-CATEGORY-ID               
A04860              MOVE 4           TO WS-77-ROUTE-CATEGORY            
A03352           ELSE                                                   
A04860              MOVE 529         TO WS-77-CATEGORY-ID               
A04860              MOVE 1           TO WS-77-ROUTE-CATEGORY            
A03352           END-IF                                                 
A04860           MOVE 'N'            TO WS-77-PRIORITY                  
A04860           MOVE ZERO           TO WS-77-SERV-ORDER-NO             
A04860                                  WS-77-PREMISE-NO                
A04860                                  WS-77-ACCOUNT-NO                
C36856                                  EQ-CRNT-LOC-NO                  
C36856                                  MV-LOC-NO                       
C36856                                  AT-PREMISE-NO                   
C36856                                  AT-ACCOUNT-NO                   
A04860                                  WS-77-CUSTOMER-NO               
A04860           MOVE SPACES         TO WS-77-RESP-AREA-ID              
A04860                                  WS-77-LOCAL-OFFICE              
C36856           MOVE MA-METER-NO    TO EQ-DEVICE-NO                    
C36856           MOVE MA-METER-NO    TO WS-WQ-METER-NO OF WS-WQ-COMMENT2
C36856           MOVE WS-WQ-COMMENT2 TO WS-WQ-MESSAGE                   
C36856           PERFORM 2300-CREATE-WORK-QUEUE THRU 2300-EXIT          
C36856        END-IF                                                    
31683         MOVE UTILITY-TYPE-PARM    TO ERR-UTIL-TYPE                
31683         MOVE E-FMT04-METER-NO     TO ERR-METER-NBR                
31683         MOVE E-FMT04-LOCATION     TO ERR-FIELD                    
31683         MOVE 'METER HAS ATTACHMENT' TO ERR-PROBLEM                
31683         MOVE EM-ELEC-MTR-CLASS-CD TO ERR-CLASS-CD                 
31683         MOVE EM-ELEC-MTR-SPEC-CD  TO ERR-SPEC-CD                  
31683         SET INPUT-IS-INVALID      TO TRUE                         
31683         MOVE 'Y'                  TO WS-MASTER-ERROR-FLAG         
31683         PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                 
31683         GO TO 1250-EXIT                                           
31683      END-IF.                                                      
      *                                                                         
C36856     MOVE WS-N TO WS-INT-ERT-FLAG                                 
C36856     PERFORM 7410-OPEN-INT-ERT   THRU 7410-EXIT                   
C36856     PERFORM 7420-FETCH-INT-ERT   THRU 7420-EXIT                  
C36856     PERFORM UNTIL WS-INT-ERT-FLAG = 'Y'                          
C36856        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
C36856           MOVE MA-CODE-ATT-TYPE  TO MP-CODE-ATT-TYPE             
C36856                                     LX-CODE-ATT-TYPE             
C36856           MOVE MA-CODE-UTIL-TYPE TO MP-CODE-UTIL-TYPE            
C36856                                     LX-CODE-UTIL-TYPE            
C36856           MOVE EQ-COMPANY-NO     TO MP-COMPANY-NO                
C36856                                     LX-COMPANY-NO                
C36856           MOVE MA-DEVICE-NO      TO MP-DEVICE-NO                 
C36856                                     LX-DEVICE-NO                 
C36856           MOVE MA-METER-NO       TO MP-METER-NO                  
C36856           PERFORM 7440-GET-MOVE-DETAILS                          
C36856                                  THRU 7440-EXIT                  
C36856           MOVE LX-EQUIP-LOC-ID   TO MP-EQUIP-LOC-ID              
C36856           MOVE LX-MTR-STORAGE-FAC-CD                             
C36856                            TO MP-MTR-STORAGE-FAC-CD              
C36856           MOVE WS-DATE-OF-TEST   TO MP-DATE-MOVE                 
C36856           PERFORM 8800-CREATE-MOVE-HIST THRU 8800-EXIT           
C36856           MOVE WS-I              TO LX-EQUIP-LOC-ID              
C36856           MOVE WS-DATE-OF-TEST   TO LX-DATE-LAST-MOVE            
C36856                                     LX-DATE-DISPOSED-OF          
C36856           PERFORM 8810-UPDATE-ATTCHMTS THRU 8810-EXIT            
C36856        END-IF                                                    
DELETE        DISPLAY 'MTR : ' MA-METER-NO ' ERT : ' MP-DEVICE-NO       
C36856        PERFORM 7420-FETCH-INT-ERT   THRU 7420-EXIT               
C36856     END-PERFORM                                                  
C36856     PERFORM 7430-CLOSE-INT-ERT   THRU 7430-EXIT                  
      *                                                                         
T18007     MOVE E-FMT04-METER-NO TO MV-DEVICE-NO.                       
T18007     IF DATE-LAST-MOVE-NULL                                       
T18007        MOVE WS-DATE-OF-TEST TO MV-DATE-MOVE                      
T18007     ELSE                                                         
T18007        MOVE EQ-DATE-LAST-MOVE TO MV-DATE-MOVE                    
T18007     END-IF.                                                      
T18007     MOVE EQ-COMPANY-NO       TO MV-COMPANY-NO.                   
T18007     MOVE EQ-LOCAL-OFFICE     TO MV-LOCAL-OFFICE.                 
T18007     MOVE EQ-CRNT-LOC-NO      TO MV-LOC-NO.                       
T18007     MOVE EQ-CODE-CRNT-LOC    TO MV-CODE-CRNT-LOC.                
T18007     PERFORM 8660-INSERT-MOVEMENT-HIST THRU 8660-EXIT.            
T18007     MOVE WS-DATE-OF-TEST     TO EQ-DATE-LAST-MOVE.               
T18007     MOVE ZEROS               TO EQ-CRNT-LOC-NO.                  
T18007     MOVE 'I'                 TO EQ-CODE-CRNT-LOC.                
31683      MOVE E-FMT04-RETIRE-DESC TO EQ-UPGRADES-TX.                  
T18007     PERFORM 8670-UPDATE-CRNT-LOC THRU 8670-EXIT.                 
31683      MOVE SPACES              TO EQ-UPGRADES-TX.                  
      *                                                                         
T18007 1250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T35434*==============================================================*          
T35434 1400-PROCESS-COMMIT.                                             
T35434*==============================================================*          
T35434*                                                                         
T35434     IF WS-RECS-TO-COMMIT-COUNT >= WS-CHKP-LUW-LIMIT              
T35434        AND WS-COMMITS-REQUIRE                                    
T35434*                                                                         
T35434        MOVE 0               TO WS-RESTART-PROCESS-TYPE           
T35434        SET WS-RERUN-PENDING TO TRUE                              
T35434        PERFORM 8700-COMMIT-DB2-UPDATES   THRU 8700-EXIT          
T35434*                                                                         
T35434     END-IF                                                       
T35434     .                                                            
T35434 1400-EXIT.                                                       
T35434     EXIT.                                                        
T35434*                                                                         
      ******************************************************************        
      *   EDIT CHECK RECORD FIELDS. IF INVALID FIELD, WRITE TO ERROR   *        
      ******************************************************************        
      *                                                                         
       2000-EDIT-RECORD.                                                
      *                                                                         
           SET INPUT-IS-VALID TO TRUE.                                  
      *                                                                         
TP4597     IF  UTILITY-TYPE-PARM = WS-E                                 
TP4597         PERFORM 2200-EDIT-ELEC-MTR THRU 2200-EXIT                
TP4597     END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2110-EDIT-TEST-DATE.                                             
      *                                                                         
           MOVE WS-F  TO WS-PARM-DAY-REQUIRED.                          
           MOVE WS-Y  TO WS-PARM-DATE-REQUIRED.                         
           MOVE WS-LE TO WS-PARM-OPERATOR.                              
      *                                                                         
           PERFORM  6100-DATE-VALIDATION  THRU  6100-EXIT.              
      *                                                                         
           IF INVALID-MONTH                                             
           OR INVALID-DAY                                               
           OR INVALID-YEAR                                              
               SET INPUT-IS-INVALID TO TRUE                             
           END-IF.                                                      
      *                                                                         
       2110-EXIT.  EXIT.                                                
      *                                                                         
       2200-EDIT-ELEC-MTR.                                              
      *                                                                         
31127 *========================================================*                
31127 *  VERIFY E-FMT04-LOCATION NOT = SPACES                                   
31127 *========================================================*                
      *                                                                         
31127      IF E-FMT04-LOCATION = SPACES                                 
31227          MOVE UTILITY-TYPE-PARM     TO ERR-UTIL-TYPE              
31127          MOVE E-FMT04-METER-NO      TO ERR-METER-NBR              
31127          MOVE E-FMT04-LOCATION      TO ERR-FIELD                  
31127          MOVE 'INVALID LOCATION'    TO ERR-PROBLEM                
31127          MOVE EM-ELEC-MTR-CLASS-CD  TO ERR-CLASS-CD               
31127          MOVE EM-ELEC-MTR-SPEC-CD   TO ERR-SPEC-CD                
31127          SET INPUT-IS-INVALID       TO TRUE                       
31127          MOVE 'Y'                   TO WS-MASTER-ERROR-FLAG       
31127          PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
31127          GO TO 2200-EXIT                                          
31127      END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY DATE TEST                                                       
      *========================================================*                
      *                                                                         
T15090     MOVE SPACES TO WS-DATE-OF-TEST.                              
      *                                                                         
TP4597     STRING E-FMT04-DATE-OF-TEST (3:2),                           
TP4597            E-FMT04-DATE-OF-TEST (5:2),                           
TP4597            E-FMT04-DATE-OF-TEST (1:2)                            
               DELIMITED BY SIZE                                        
             INTO WS-IN-DATE.                                           
      *                                                                         
           PERFORM 2110-EDIT-TEST-DATE THRU 2110-EXIT.                  
      *                                                                         
           IF INPUT-IS-INVALID                                          
               MOVE UTILITY-TYPE-PARM     TO ERR-UTIL-TYPE              
               MOVE E-FMT04-METER-NO      TO ERR-METER-NBR              
TP4597         MOVE E-FMT04-DATE-OF-TEST  TO ERR-FIELD                  
               MOVE 'INVALID TEST DATE'   TO ERR-PROBLEM                
PCR040         MOVE EM-ELEC-MTR-CLASS-CD  TO ERR-CLASS-CD               
PCR040         MOVE EM-ELEC-MTR-SPEC-CD   TO ERR-SPEC-CD                
T15090         SET INPUT-IS-INVALID TO TRUE                             
T15090         MOVE 'Y' TO WS-MASTER-ERROR-FLAG                         
               PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
               GO TO 2200-EXIT                                          
           END-IF.                                                      
      *                                                                         
TP4597     IF E-FMT04-YEAR > 50                                         
TP4597        MOVE 19 TO WS-TEMP-CC                                     
TP4597     ELSE                                                         
TP4597        MOVE 20 TO WS-TEMP-CC                                     
           END-IF.                                                      
      *                                                                         
TP4597     STRING WS-TEMP-CC,                                           
TP4597            E-FMT04-YEAR,                                         
TP4597            '-',                                                  
TP4597            E-FMT04-MONTH,                                        
TP4597            '-',                                                  
TP4597            E-FMT04-DAY                                           
TP4597       DELIMITED BY SIZE                                          
TP4597              INTO WS-DATE-OF-TEST.                               
      *                                                                         
TP4597     IF WS-DATE-OF-TEST > WS-DB2-TODAYS-DATE                      
               SET INPUT-IS-INVALID TO TRUE                             
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT04-METER-NO           TO ERR-METER-NBR         
TP4597         MOVE E-FMT04-DATE-OF-TEST       TO ERR-FIELD             
               MOVE 'TEST DATE CANNOT BE GREATER THAN CURRENT DATE'     
                                               TO ERR-PROBLEM           
PCR040         MOVE EM-ELEC-MTR-CLASS-CD       TO ERR-CLASS-CD          
PCR040         MOVE EM-ELEC-MTR-SPEC-CD        TO ERR-SPEC-CD           
T15090         SET INPUT-IS-INVALID TO TRUE                             
T15090         MOVE 'Y' TO WS-MASTER-ERROR-FLAG                         
               PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
               GO TO 2200-EXIT                                          
           END-IF.                                                      
      *                                                                         
T19333     IF WS-BEGIN-DATE > LOW-VALUES AND SPACES                     
T19333           AND WS-END-DATE > LOW-VALUES AND SPACES                
T15090        IF WS-DATE-OF-TEST < WS-BEGIN-DATE                        
T15090                      OR WS-DATE-OF-TEST > WS-END-DATE            
T15090           SET INPUT-IS-INVALID TO TRUE                           
T15090           MOVE 'Y' TO WS-MASTER-ERROR-FLAG                       
T15090           GO TO 2200-EXIT                                        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      * VERIFY METER FOR UTIL TYPE                                              
      *========================================================*                
      *                                                                         
T15090     MOVE WS-N             TO WS-MTR-NOT-FOUND.                   
           MOVE E-FMT04-METER-NO TO EM-METER-NO.                        
           PERFORM 7020-SELECT-ELEC-METER THRU 7020-EXIT.               
      *                                                                         
           IF SQLCODE = NOT-FOUND                                       
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT04-METER-NO           TO ERR-METER-NBR         
               MOVE 'METER NOT FOUND FOR UTIL' TO ERR-PROBLEM           
PCR040         MOVE SPACES                     TO ERR-CLASS-CD          
PCR040         MOVE SPACES                     TO ERR-SPEC-CD           
T15090         SET MTR-NOT-FOUND    TO TRUE                             
T15090         SET INPUT-IS-INVALID TO TRUE                             
T15090         MOVE 'Y' TO WS-MASTER-ERROR-FLAG                         
               PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
               GO TO 2200-EXIT                                          
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *   CHECK TIME PERIOD AND CAPABILITIES AGAINST                            
      *   THE METER CAPABILITIES TABLE                                          
      *========================================================*                
      *                                                                         
           MOVE UTILITY-TYPE-PARM        TO N3-CODE-UTIL-TYPE.          
      *                                                                         
      *========================================================*                
      *  VERIFY CODE TEST TYPE                                                  
      *========================================================*                
      *                                                                         
TP4597     MOVE E-FMT04-REASON-FOR-TEST TO WS-ELEC-CODE-TEST-TYPE.      
C29299     MOVE UTILITY-TYPE-PARM       TO M9-CODE-UTIL-TYPE.           
      *                                                                         
T15090     PERFORM 7070-SELECT-CODE-TEST-TYPE THRU 7070-EXIT.           
      *                                                                         
T15090     IF  SQLCODE = NOT-FOUND                                      
               MOVE UTILITY-TYPE-PARM       TO ERR-UTIL-TYPE            
               MOVE E-FMT04-METER-NO        TO ERR-METER-NBR            
TP4597         MOVE E-FMT04-REASON-FOR-TEST TO ERR-FIELD                
               MOVE 'INVALID TEST TYPE'     TO ERR-PROBLEM              
PCR040         MOVE EM-ELEC-MTR-CLASS-CD    TO ERR-CLASS-CD             
PCR040         MOVE EM-ELEC-MTR-SPEC-CD     TO ERR-SPEC-CD              
T15090         SET INPUT-IS-INVALID TO TRUE                             
T15090         MOVE 'Y' TO WS-MASTER-ERROR-FLAG                         
T15090         PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
T15090*        GO TO 2200-EXIT.                                                 
           END-IF.                                                      
      *                                                                         
31683      IF E-FMT04-REASON-FOR-TEST = 'I'                             
31683         GO TO 2200-EXIT                                           
31683      END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY REPAIR CODE                                                     
      *========================================================*                
      *                                                                         
T18007     PERFORM 2210-EDIT-CODE-REPAIR THRU 2210-EXIT.                
      *                                                                         
           MOVE E-FMT04-METER-NO TO ET-METER-NO.                        
TP4597     MOVE WS-DATE-OF-TEST  TO ET-DATE-TEST.                       
EMTEST     MOVE '00:01:00'       TO ET-TIME-TEST.                       
TP4597     MOVE ZEROS            TO ET-CODE-TIME-PERIOD.                
TP4597     MOVE  'A'             TO ET-CODE-CAP-TYPE.                   
                                                                        
           PERFORM 7115-SELECT-ELEC-MTR-TEST-KEY THRU 7115-EXIT.        
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
TP4597        IF E-FMT04-REASON-FOR-TEST NOT = ET-CODE-TEST-TYPE        
                 MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE       
                 MOVE E-FMT04-METER-NO           TO ERR-METER-NBR       
TP4597           MOVE E-FMT04-REASON-FOR-TEST TO ERR-FIELD              
                 MOVE 'TEST EXIST FOR DATE,TIME,CAP' TO ERR-PROBLEM     
PCR040           MOVE EM-ELEC-MTR-CLASS-CD   TO ERR-CLASS-CD            
PCR040           MOVE EM-ELEC-MTR-SPEC-CD    TO ERR-SPEC-CD             
T15090           SET INPUT-IS-INVALID TO TRUE                           
T15090           MOVE 'Y' TO WS-MASTER-ERROR-FLAG                       
T15090           PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT              
T15090*          GO TO 2200-EXIT.                                               
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY READ AF                                                         
      *========================================================*                
      *                                                                         
T15090     IF  E-FMT04-METER-INDEX = SPACES OR LOW-VALUES               
T15090         MOVE ZEROS                      TO E-FMT04-METER-INDEX   
T15090     END-IF.                                                      
      *                                                                         
T18007     INSPECT E-FMT04-METER-INDEX REPLACING LEADING ' ' BY '0'.    
TP4597     IF E-FMT04-METER-INDEX NOT NUMERIC                           
               MOVE UTILITY-TYPE-PARM        TO ERR-UTIL-TYPE           
               MOVE E-FMT04-METER-NO         TO ERR-METER-NBR           
      *        MOVE E-FMT04-READ-AF          TO ERR-FIELD-N                     
               MOVE 'INVALID READ AF      '  TO ERR-PROBLEM             
PCR040         MOVE EM-ELEC-MTR-CLASS-CD     TO ERR-CLASS-CD            
PCR040         MOVE EM-ELEC-MTR-SPEC-CD      TO ERR-SPEC-CD             
T15090         SET INPUT-IS-INVALID TO TRUE                             
T15090         MOVE 'Y' TO WS-MASTER-ERROR-FLAG                         
T15090         PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
T15090*        GO TO 2200-EXIT.                                                 
           END-IF.                                                      
      *                                                                         
TP4597*   CHECK FOR E-FMT04-IN-CONSTANT > 0 IS REMOVED SINCE IT IS MADE         
TP4597*   CONSTANT                                                              
      *                                                                         
T18007*COMMENTED PER JERRY SMITH                                                
T18007*    IF  E-FMT04-METER-INDEX = ZERO                                       
T18007*        MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE                 
T18007*        MOVE E-FMT04-METER-NO           TO ERR-METER-NBR                 
T18007*        MOVE 1                          TO ERR-FIELD-N                   
T18007*        MOVE '*WARNING-IDX=0,AF MUST HAVE READING'                       
T18007*                                        TO ERR-PROBLEM                   
T18007*        MOVE EM-ELEC-MTR-CLASS-CD       TO ERR-CLASS-CD                  
T18007*        MOVE EM-ELEC-MTR-SPEC-CD        TO ERR-SPEC-CD                   
T18007*        PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT.                       
T15090*        GO TO 2200-EXIT.                                                 
      *                                                                         
      *========================================================*                
      *  VERIFY LIGHT LOAD ACCU AF                                              
      *========================================================*                
      *                                                                         
TP4597     IF E-FMT04-LLD-FOUND-9 NOT NUMERIC                           
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT04-METER-NO           TO ERR-METER-NBR         
      *        MOVE E-FMT04-LIGHT-LOAD-ACCU-AF TO ERR-FIELD-N                   
               MOVE 'INVALID LIGHT LOAD AF'    TO ERR-PROBLEM           
PCR040         MOVE EM-ELEC-MTR-CLASS-CD       TO ERR-CLASS-CD          
PCR040         MOVE EM-ELEC-MTR-SPEC-CD        TO ERR-SPEC-CD           
T15090         SET INPUT-IS-INVALID TO TRUE                             
T15090         MOVE 'Y' TO WS-MASTER-ERROR-FLAG                         
T15090         PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
T15090*        GO TO 2200-EXIT.                                                 
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY FULL LOAD ACCU AF                                               
      *========================================================*                
      *                                                                         
TP4597     IF E-FMT04-FLD-FOUND-9 NOT NUMERIC                           
               MOVE UTILITY-TYPE-PARM         TO ERR-UTIL-TYPE          
               MOVE E-FMT04-METER-NO          TO ERR-METER-NBR          
      *        MOVE E-FMT04-FULL-LOAD-ACCU-AF TO ERR-FIELD-N                    
               MOVE 'INVALID FULL LOAD AF'    TO ERR-PROBLEM            
PCR040         MOVE EM-ELEC-MTR-CLASS-CD      TO ERR-CLASS-CD           
PCR040         MOVE EM-ELEC-MTR-SPEC-CD       TO ERR-SPEC-CD            
T15090         SET INPUT-IS-INVALID TO TRUE                             
T15090         MOVE 'Y' TO WS-MASTER-ERROR-FLAG                         
T15090         PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
T15090*        GO TO 2200-EXIT.                                                 
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY LIGHT LOAD ACCU AL                                              
      *========================================================*                
      *                                                                         
TP4597     IF E-FMT04-LLD-LEFT-9 NOT NUMERIC                            
              MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE          
              MOVE E-FMT04-METER-NO           TO ERR-METER-NBR          
      *       MOVE E-FMT04-LIGHT-LOAD-ACCU-AL TO ERR-FIELD-N                    
              MOVE 'INVALID LIGHT LOAD AL'    TO ERR-PROBLEM            
PCR040        MOVE EM-ELEC-MTR-CLASS-CD       TO ERR-CLASS-CD           
PCR040        MOVE EM-ELEC-MTR-SPEC-CD        TO ERR-SPEC-CD            
T15090        SET INPUT-IS-INVALID TO TRUE                              
T15090        MOVE 'Y' TO WS-MASTER-ERROR-FLAG                          
T15090        PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                 
T15090*       GO TO 2200-EXIT.                                                  
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY FULL LOAD ACCU AL                                               
      *========================================================*                
      *                                                                         
TP4597     IF E-FMT04-FLD-LEFT-9 NOT NUMERIC                            
              MOVE UTILITY-TYPE-PARM         TO ERR-UTIL-TYPE           
              MOVE E-FMT04-METER-NO          TO ERR-METER-NBR           
      *       MOVE E-FMT04-FULL-LOAD-ACCU-AL TO ERR-FIELD-N                     
              MOVE 'INVALID FULL LOAD AL'    TO ERR-PROBLEM             
PCR040        MOVE EM-ELEC-MTR-CLASS-CD      TO ERR-CLASS-CD            
PCR040        MOVE EM-ELEC-MTR-SPEC-CD       TO ERR-SPEC-CD             
T15090        SET INPUT-IS-INVALID TO TRUE                              
T15090        MOVE 'Y' TO WS-MASTER-ERROR-FLAG                          
T15090        PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                 
T15090*       GO TO 2200-EXIT.                                                  
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY POWER FCTR ACCU AF                                              
      *========================================================*                
      *                                                                         
TP4597     IF E-FMT04-FLD-POWER-9 NOT NUMERIC                           
              MOVE UTILITY-TYPE-PARM        TO ERR-UTIL-TYPE            
              MOVE E-FMT04-METER-NO         TO ERR-METER-NBR            
T15090        MOVE 'INVALID POWER FCTR AF'  TO ERROR-DESC               
T15090        MOVE E-FMT04-F-LD-POWER       TO ERROR-VALUE              
PCR040        MOVE EM-ELEC-MTR-CLASS-CD     TO ERR-CLASS-CD             
PCR040        MOVE EM-ELEC-MTR-SPEC-CD      TO ERR-SPEC-CD              
T15090        SET INPUT-IS-INVALID TO TRUE                              
T15090        MOVE 'Y' TO WS-MASTER-ERROR-FLAG                          
T15090        PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                 
T15090*       GO TO 2200-EXIT.                                                  
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY POWER FCTR ACCU AL                                              
      *========================================================*                
      *                                                                         
TP4597     IF E-FMT04-FLD-POWER-L-9 NOT NUMERIC                         
              MOVE UTILITY-TYPE-PARM       TO ERR-UTIL-TYPE             
              MOVE E-FMT04-METER-NO        TO ERR-METER-NBR             
T15090        MOVE 'INVALID POWER FCTR AL' TO ERROR-DESC                
T15090        MOVE E-FMT04-F-LD-POWER-L    TO ERROR-VALUE               
PCR040        MOVE EM-ELEC-MTR-CLASS-CD    TO ERR-CLASS-CD              
PCR040        MOVE EM-ELEC-MTR-SPEC-CD     TO ERR-SPEC-CD               
T15090        SET INPUT-IS-INVALID TO TRUE                              
T15090        MOVE 'Y' TO WS-MASTER-ERROR-FLAG                          
T15090        PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                 
T15090*       GO TO 2200-EXIT.                                                  
           END-IF.                                                      
      *                                                                         
30271      MOVE E-FMT04-EMPLOYEE-ID TO ET-EQ-TESTER-ID.                 
      *                                                                         
      *========================================================*                
      *  VERIFY TEST BENCH ID                                                   
      *========================================================*                
      *                                                                         
TP4597     IF E-FMT04-TEST-TABLE = (LOW-VALUES OR SPACES)               
              NEXT SENTENCE                                             
           ELSE                                                         
TP4597        IF E-FMT04-TEST-TABLE ALPHABETIC                          
                 NEXT SENTENCE                                          
              ELSE                                                      
T18007           IF E-FMT04-TEST-TABLE NUMERIC                          
                    NEXT SENTENCE                                       
                 ELSE                                                   
                    MOVE UTILITY-TYPE-PARM TO ERR-UTIL-TYPE             
                    MOVE E-FMT04-METER-NO TO ERR-METER-NBR              
T18007              MOVE '*WARNING-INVALID TEST BENCH ID '              
T18007                        TO ERROR-DESC                             
TP4597              MOVE E-FMT04-TEST-TABLE TO ERR-FIELD                
T15090                                         ERROR-VALUE              
PCR040              MOVE EM-ELEC-MTR-CLASS-CD TO ERR-CLASS-CD           
PCR040              MOVE EM-ELEC-MTR-SPEC-CD TO ERR-SPEC-CD             
T15090              PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT           
T15090*             GO TO 2200-EXIT.                                            
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
      *========================================================*                
ST    *  VERIFY SERIAL NO                                                       
      *========================================================*                
      *                                                                         
           IF  E-FMT04-SERIAL-NO = SPACES OR LOW-VALUES                 
               MOVE ZEROES TO WS-SERIAL-NO                              
T18007         MOVE SPACES TO E-FMT04-SERIAL-NO                         
           END-IF.                                                      
      *                                                                         
           MOVE E-FMT04-SERIAL-NO TO WS-SERIAL-NO.                      
           INSPECT WS-SERIAL-NO REPLACING ALL LOW-VALUES BY SPACES.     
           MOVE 0 TO WS-INSPECT-CNTR.                                   
           INSPECT WS-SERIAL-NO TALLYING WS-INSPECT-CNTR FOR ALL ' '.   
           COMPUTE WS-INSPECT-CNTR =                                    
                          LENGTH OF WS-SERIAL-NO - WS-INSPECT-CNTR.     
      *                                                                         
T18007     IF  WS-INSPECT-CNTR > 0                                      
              MOVE WS-SERIAL-NO(1:WS-INSPECT-CNTR)                      
                     TO WS-SER-NO-JUSTIFIED                             
T18007     ELSE                                                         
T18007        MOVE SPACES TO WS-SER-NO-JUSTIFIED                        
T18007     END-IF.                                                      
      *                                                                         
           INSPECT WS-SER-NO-JUSTIFIED REPLACING ALL ' ' BY '0'.        
           MOVE WS-SER-NO-JUSTIFIED TO WS-SERIAL-NO.                    
T18007     MOVE E-FMT04-METER-NO TO EQ-DEVICE-NO.                       
           PERFORM 7000-SELECT-COMP-NO THRU 7000-EXIT.                  
      *                                                                         
T18007*PER JERRY SMITH ON 6/10/99                                               
T18007*CHANGED TO POST SERIAL-NO FROM TEST RECORD, IF IT IS 'NA' ON EQ          
      *                                                                         
T18007     IF  (EQ-SERIAL-NO = 'NA' AND E-FMT04-SERIAL-NO NOT = ' ')    
T18007            OR ( EQ-SERIAL-NO = SPACES OR LOW-VALUES )            
T18007        MOVE WS-SERIAL-NO  TO EQ-SERIAL-NO                        
T18007        PERFORM 8680-UPDATE-SERIAL-NO THRU 8680-EXIT              
T18007     ELSE                                                         
              IF WS-SERIAL-NO = EQ-SERIAL-NO                            
                 CONTINUE                                               
              ELSE                                                      
                 MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE       
                 MOVE E-FMT04-METER-NO           TO ERR-METER-NBR       
T18007           MOVE '*WARNING-INVALID SERIAL NO ' TO ERROR-DESC       
TP4597           MOVE E-FMT04-SERIAL-NO          TO ERR-FIELD           
T15090                                              ERROR-VALUE         
                 MOVE EM-ELEC-MTR-CLASS-CD       TO ERR-CLASS-CD        
END              MOVE EM-ELEC-MTR-SPEC-CD        TO ERR-SPEC-CD         
T15090           PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2200-EXIT.  EXIT.                                                
      *                                                                         
      *========================================================*                
      *  VERIFY REPAIR CODE                                                     
      *========================================================*                
      *                                                                         
T18007 2210-EDIT-CODE-REPAIR.                                           
      *                                                                         
T18007     EVALUATE E-FMT04-TYPE-RETIREMENT                             
T18007        WHEN ' '                                                  
T18007           MOVE 'N'                        TO WS-CODE-REPAIR      
T18007        WHEN '1'                                                  
T18007           MOVE '4'                        TO WS-CODE-REPAIR      
T18007        WHEN '2'                                                  
T18007           MOVE '3'                        TO WS-CODE-REPAIR      
T18007        WHEN OTHER                                                
T18007           MOVE E-FMT04-TYPE-RETIREMENT    TO WS-CODE-REPAIR      
T18007     END-EVALUATE.                                                
      *                                                                         
T15090     PERFORM 7060-SELECT-CODE-REPAIR THRU 7060-EXIT.              
      *                                                                         
T15090     IF  SQLCODE = NOT-FOUND                                      
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT04-METER-NO           TO ERR-METER-NBR         
T15090         MOVE 'INVALID CODE REPAIR'      TO ERROR-DESC            
TP4597         MOVE E-FMT04-TYPE-RETIREMENT    TO ERR-FIELD             
T15090                                            ERROR-VALUE           
PCR040         MOVE EM-ELEC-MTR-CLASS-CD       TO ERR-CLASS-CD          
PCR040         MOVE EM-ELEC-MTR-SPEC-CD        TO ERR-SPEC-CD           
T15090         SET INPUT-IS-INVALID TO TRUE                             
T15090         MOVE 'Y' TO WS-MASTER-ERROR-FLAG                         
T15090         PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
T15090*        GO TO 2200-EXIT.                                                 
T15090     END-IF.                                                      
      *                                                                         
T18007 2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
TP4597******************************************************************        
TP4597*   UPDATE CSS_MTR_TEST_HIST DEPENDING ON THE OPERATION          *        
TP4597******************************************************************        
      *                                                                         
TP4597 2250-CHECK-TEST-HIST.                                            
      *                                                                         
TP4597     IF  (EM-LAST-TEST-SEL-CD GREATER THAN SPACES AND             
TP4597         EM-LAST-TEST-SEL-DT > EM-DATE-LAST-TESTED)               
TP4597         MOVE WS-E                       TO MQ-CODE-UTIL-TYPE     
TP4597         MOVE EM-TEST-SCHED-CD           TO MQ-TEST-SCHED-CD      
TP4597         MOVE EM-LAST-TEST-SEL-DT(1:4)                            
TP4597                                         TO MQ-TEST-YEAR          
TP4597         IF  EM-TEST-SCHED-CD = WS-R                              
T20129             MOVE EM-LAST-TEST-SEL-CD    TO MQ-MTR-TEST-GRP-CD    
TP4597         ELSE                                                     
TP4597             MOVE SPACES                 TO MQ-MTR-TEST-GRP-CD    
TP4597         END-IF                                                   
TP4597         PERFORM 7150-SELECT-TEST-HIST THRU 7150-EXIT             
TP4597         IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
TP4597             GO TO 2250-EXIT                                      
TP4597         END-IF                                                   
TP4597         IF  STATUS-CD-NULL                                       
TP4597             MOVE SPACES                 TO MQ-STATUS-CD          
TP4597         END-IF                                                   
TP4597         IF  MQ-STATUS-CD = WS-B                                  
TP4597             MOVE WS-C                   TO MQ-STATUS-CD          
TP4597         END-IF                                                   
TP4597         ADD 1                           TO MQ-TESTED-QT          
TP4597         IF  (MQ-TEST-SCHED-CD NOT = WS-R AND                     
TP4597             MQ-TESTED-QT NOT LESS THAN MQ-SELECTED-QT)           
TP4597             OR  (MQ-TEST-SCHED-CD = WS-R                         
TP4597             AND MQ-TESTED-QT NOT LESS THAN MQ-SAMPLE-MIN-QT)     
TP4597             MOVE WS-D                   TO MQ-STATUS-CD          
TP4597         END-IF                                                   
T21806         PERFORM 8650-UPDATE-TEST-HIST THRU 8650-EXIT             
TP4597     END-IF.                                                      
      *                                                                         
TP4597 2250-EXIT.                                                       
TP4597     EXIT.                                                        
      *                                                                         
TP4597******************************************************************        
TP4597*   CREATE WORK QUEUE FOR INACURATE METERS (EXCEED 2% VARIANCE)  *        
TP4597******************************************************************        
      *                                                                         
TP4597 2300-CREATE-WORK-QUEUE.                                          
      *                                                                         
T15090     PERFORM 7000-SELECT-COMP-NO THRU 7000-EXIT.                  
T15090     IF  (WS-INSTALL-DT-NULL = -1 OR WS-DATE-OF-TEST >            
T15090         EQ-INSTALL-DT) AND (EQ-CODE-CRNT-LOC = WS-J OR WS-K)     
T15090         MOVE EQ-CRNT-LOC-NO       TO AT-PREMISE-NO               
T15090     ELSE                                                         
T15090         MOVE EM-METER-NO          TO MV-DEVICE-NO                
T15090         MOVE WS-DATE-OF-TEST      TO MV-DATE-MOVE                
      *                                                                         
T15090         PERFORM 7300-OPEN-MOVE-HIST-CURSOR THRU 7300-EXIT        
T15090         PERFORM 7310-FETCH-MOVE-HIST-CURSOR THRU 7310-EXIT       
T15090         IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND          
T15090             WS-LOC-NO-NULL NOT = -1                              
T15090             MOVE MV-LOC-NO        TO AT-PREMISE-NO               
T15090         ELSE                                                     
T15090             MOVE ZERO             TO AT-PREMISE-NO               
T15090         END-IF                                                   
T15090         PERFORM 7320-CLOSE-MOVE-HIST-CURSOR THRU 7320-EXIT       
T15090     END-IF.                                                      
      *                                                                         
T20235     MOVE AT-PREMISE-NO                  TO WS-CPD99-PREMISE-NO.  
T20235     PERFORM 6990-FETCH-CUR-ACCOUNT      THRU 6990-EXIT.          
T20235     MOVE WS-CPD99-ACCOUNT-NO            TO AT-ACCOUNT-NO.        
T20235     PERFORM 7250-SELECT-ACCOUNT-DETAILS THRU 7250-EXIT.          
T15090     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
A04860         MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO      
A04860         MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO     
A04860         MOVE AT-LOCAL-OFFICE            TO WS-77-LOCAL-OFFICE    
T15090     END-IF.                                                      
      *                                                                         
A04860     MOVE 'SYSTEM '                      TO WS-77-USER-ID-ORIG.   
A04860     MOVE AT-PREMISE-NO                  TO WS-77-PREMISE-NO.     
A04860*    MOVE '01'                           TO WS-77-COMPANY-NO.             
A04860     MOVE WS-DB2-TODAYS-DATE             TO WS-DATE-PART          
A04860     MOVE WS-CURRENT-TIME-STAMP          TO WS-77-DATE-REQUIRED   
A04860                                            WS-77-DATE-CREATED.   
A04860     MOVE WS-WQ-MESSAGE                  TO WS-77-COMMENTS-TEXT.  
A04860     MOVE LENGTH OF WS-WQ-MESSAGE        TO WS-77-COMMENTS-LEN.   
A04860     MOVE SPACES                         TO WS-77-FREE-FORM-TXT.  
A04860     MOVE LENGTH OF WS-77-FREE-FORM-TXT  TO WS-77-FREE-FORM-LEN.  
A04860     MOVE PROGRAM-NAME                   TO WS-77-CREATED-BY.     
      *                                                                         
T15879     PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.               
      *                                                                         
TP4597 2300-EXIT.                                                       
TP4597     EXIT.                                                        
      *                                                                         
T15090 2400-LOAD-ERROR-DATA.                                            
      *                                                                         
ST         MOVE E-FMT04-METER-NO               TO WS-DTL-MTR-NO         
           IF  WS-DATE-OF-TEST = SPACES                                 
               MOVE E-FMT04-DATE-OF-TEST       TO WS-DTL-DATE-TEST      
           ELSE                                                         
               MOVE WS-DATE-OF-TEST            TO WS-DTL-DATE-TEST      
           END-IF.                                                      
           MOVE E-FMT04-REASON-FOR-TEST        TO WS-DTL-TEST-REASON    
           MOVE E-FMT04-TESTER                 TO WS-DTL-TESTER-CD      
           IF  E-FMT04-FLD-FOUND-9 NOT NUMERIC                          
               MOVE E-FMT04-F-LD-FOUND         TO WS-DTL-AF-FULL-LD     
           ELSE                                                         
           MOVE E-FMT04-FLD-FOUND-9            TO WS-DTL-AF-FULL-LD     
           END-IF.                                                      
           IF  E-FMT04-LLD-FOUND-9 NOT NUMERIC                          
               MOVE E-FMT04-L-LD-FOUND         TO WS-DTL-AF-LIGHT-LD    
           ELSE                                                         
               MOVE E-FMT04-LLD-FOUND-9        TO WS-DTL-AF-LIGHT-LD    
           END-IF.                                                      
           IF  E-FMT04-FLD-LEFT-9 NOT NUMERIC                           
               MOVE E-FMT04-F-LD-LEFT          TO WS-DTL-AL-FULL-LD     
           ELSE                                                         
               MOVE E-FMT04-FLD-LEFT-9         TO WS-DTL-AL-FULL-LD     
           END-IF.                                                      
           IF  E-FMT04-LLD-LEFT-9 NOT NUMERIC                           
               MOVE E-FMT04-L-LD-LEFT          TO WS-DTL-AL-LIGHT-LD    
           ELSE                                                         
               MOVE E-FMT04-LLD-LEFT-9         TO WS-DTL-AL-LIGHT-LD    
           END-IF.                                                      
END        MOVE E-FMT04-METER-INDEX            TO WS-DTL-METER-INDEX    
T15090     MOVE ERR-PROBLEM                    TO WS-DTL-ERR-DESC.      
T18007     INITIALIZE ERR-PROBLEM.                                      
T18007     MOVE '-'                            TO WS-DASH.              
      *                                                                         
TP4597 2400-EXIT.                                                       
TP4597     EXIT.                                                        
      *                                                                         
T35434 5000-PROCESS-SUCCESSFUL.                                         
T35434*--------------------------------------------------------------*          
T35434* THE FOLLOWING SETTINGS DECLARES SUCCESSFUL COMPLETION OF RUN *          
T35434* AND RESET RE-START CONTROLS IN CASE OF RE-START RUN          *          
T35434*--------------------------------------------------------------*          
T35434     IF  WS-THIS-IS-A-RESTART                                     
T35434         SET WS-RERUN-COMPLETED    TO TRUE                        
T35434     ELSE                                                         
T35434         SET WS-RUN-COMPLETED-NO-PROBLEMS                         
T35434                                   TO TRUE                        
T35434     END-IF.                                                      
T35434     MOVE SPACES                   TO WS-RESTART-JOB-COMPLETE.    
T35434     PERFORM 8700-COMMIT-DB2-UPDATES   THRU 8700-EXIT.            
T35434*                                                                         
T35434     IF WS-RESTART-REQ ='Y'                                       
T35434         PERFORM 8893-RESET-RESTART-REQ-PARM THRU 8893-EXIT       
T35434     END-IF.                                                      
T35434 5000-EXIT.                                                       
T35434     EXIT.                                                        
       6000-ERROR-ROUTINE.                                              
      *                                                                         
           MOVE ERR-UTIL-TYPE                    TO EQ-CODE-UTIL-TYPE.  
           MOVE ERR-METER-NBR                    TO EQ-DEVICE-NO        
           PERFORM 7000-SELECT-COMP-NO THRU 7000-EXIT.                  
           MOVE EQ-COMPANY-NO                    TO CMP-COMPANY-NO.     
T19333     SET ERROR-FOUND                       TO TRUE.               
T15090     PERFORM 8200-WRITE-ERROR-REPORT THRU 8200-EXIT               
           MOVE SPACES                         TO ERR-FIELD.            
      *                                                                         
       6000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6100-DATE-VALIDATION.                                            
      *                                                                         
           MOVE ZEROES TO     WS-RETURN-DATE                            
                              WS-WORK-FIELDS                            
                              WS-DATE-FLAGS.                            
           PERFORM 6110-NUMERIC-CHECK   THRU 6110-EXIT.                 
           IF WS-DATE-FLAGS = ZEROS                                     
             MOVE WS-IN-DD         TO WS-RETURN-DD                      
             MOVE WS-IN-YY         TO WS-RETURN-YY                      
             MOVE WS-IN-MM         TO WS-RETURN-MM                      
                                                                        
             IF WS-RETURN-YY GREATER THAN 50                            
                 MOVE 19           TO WS-RETURN-CC                      
               ELSE                                                     
                 MOVE 20           TO WS-RETURN-CC                      
             END-IF                                                     
             IF WS-CURRENT-CMPR-YY IS NUMERIC                           
                 IF WS-CURRENT-CMPR-YY GREATER THAN 50                  
                     MOVE 19       TO WS-CURRENT-CMPR-CC                
                   ELSE                                                 
                     MOVE 20       TO WS-CURRENT-CMPR-CC                
                 END-IF                                                 
             END-IF                                                     
             PERFORM 6120-BOUNDARY-CHECK        THRU 6120-EXIT          
             IF NOT (INVALID-DAY AND INVALID-MONTH)                     
               IF WS-PARM-OPERATOR NOT = SPACES AND 'NA'                
                 PERFORM 6140-COMPARE-FULL-DATES    THRU 6140-EXIT      
                 IF WS-DATE-OPERATOR-FLAG = WS-PARM-OPERATOR            
                   NEXT SENTENCE                                        
                 ELSE                                                   
                   IF WS-DATE-OPERATOR-FLAG = WS-EQ                     
                     IF WS-PARM-OPERATOR = WS-LE OR WS-GE OR WS-EQ      
                       NEXT SENTENCE                                    
                     ELSE                                               
                         MOVE 1 TO MONTH-FLAG DAY-FLAG YEAR-FLAG        
                     END-IF                                             
                   ELSE                                                 
                     IF WS-DATE-OPERATOR-FLAG = WS-GT                   
                       IF WS-PARM-OPERATOR = WS-GE OR WS-GT             
                         NEXT SENTENCE                                  
                       ELSE                                             
                         MOVE 1 TO MONTH-FLAG DAY-FLAG YEAR-FLAG        
                       END-IF                                           
                     ELSE                                               
                       IF WS-DATE-OPERATOR-FLAG = WS-LT                 
                         IF WS-PARM-OPERATOR = WS-LE OR WS-LT           
                           NEXT SENTENCE                                
                         ELSE                                           
                           MOVE 1 TO MONTH-FLAG DAY-FLAG YEAR-FLAG      
                         END-IF                                         
                       END-IF                                           
                     END-IF                                             
                   END-IF                                               
                 END-IF                                                 
               END-IF                                                   
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       6100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      *   VALIDATE DATE INFORMATION                                  *          
      ****************************************************************          
      *                                                                         
       6110-NUMERIC-CHECK.                                              
      *                                                                         
           IF WS-IN-MM NUMERIC                                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 1 TO MONTH-FLAG                                      
           END-IF.                                                      
      *                                                                         
           IF WS-IN-DD NUMERIC                                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 1 TO DAY-FLAG                                        
           END-IF.                                                      
      *                                                                         
           IF WS-IN-YY NUMERIC                                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 1 TO YEAR-FLAG                                       
           END-IF.                                                      
      *                                                                         
       6110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6120-BOUNDARY-CHECK.                                             
      *                                                                         
           IF WS-RETURN-MM > 12 OR                                      
              WS-RETURN-MM < 01                                         
              MOVE 1 TO MONTH-FLAG                                      
           END-IF.                                                      
      *                                                                         
           IF THIRTY-ONE-DAY                                            
               MOVE 31 TO WS-UPPER-LIMIT                                
           ELSE                                                         
              IF THIRTY-DAY                                             
                 MOVE 30 TO WS-UPPER-LIMIT                              
              ELSE                                                      
                 DIVIDE WS-RETURN-YY BY 4 GIVING WS-RESULT              
                 REMAINDER WS-REMAINDER-DATE                            
                 IF WS-REMAINDER-DATE = ZEROES                          
                    MOVE 29 TO WS-UPPER-LIMIT                           
                 ELSE                                                   
                    MOVE 28 TO WS-UPPER-LIMIT                           
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-RETURN-DD > WS-UPPER-LIMIT                             
                       OR                                               
              WS-RETURN-DD < 1                                          
              MOVE 1 TO DAY-FLAG                                        
           END-IF.                                                      
      *                                                                         
       6120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6140-COMPARE-FULL-DATES.                                         
           IF  WS-RETURN-DATE > WS-CURRENT-FULL-DATE                    
               MOVE 'GT'   TO WS-DATE-OPERATOR-FLAG                     
           ELSE                                                         
              IF  WS-RETURN-DATE < WS-CURRENT-FULL-DATE                 
                 MOVE 'LT' TO WS-DATE-OPERATOR-FLAG                     
              ELSE                                                      
                 MOVE 'EQ' TO WS-DATE-OPERATOR-FLAG                     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF  WS-RETURN-YY > 50                                        
               MOVE 19 TO WS-CENTURY-INDICATOR                          
           ELSE                                                         
               MOVE 20 TO WS-CENTURY-INDICATOR                          
           END-IF.                                                      
      *                                                                         
       6140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T20235****************************************************************          
T20235* 6990-FETCH-CUR-ACCOUNT                                       *          
T20235*  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.           *          
T20235****************************************************************          
      *                                                                         
T20235     EXEC SQL                                                             
T20235         INCLUDE CPD00099                                                 
T20235     END-EXEC.                                                            
      *                                                                         
T20235 6995-CPD99-ERROR-ROUTINE.                                        
      *                                                                         
T20235     DISPLAY '***************PCSMT658*******************'         
T20235     DISPLAY '* 6995-CPD99-ERROR-ROUTINE               *'         
T20235     DISPLAY '* ERROR GETTING ACCOUNT-NO FROM CPD00099 *'         
T20235     DISPLAY '* PROGRAM ABENDING...                    *'         
T20235     DISPLAY '* ERROR IN PARA', ACTIVE-PARAGRAPH                  
T20235     DISPLAY '* PREMISE-NO = ', WS-CPD99-PREMISE-NO               
T20235     DISPLAY '* SQL CODE IS  ', WS-CPD99-RETURN-CODE              
T20235     DISPLAY '***************PCSMT658*******************'         
T20235     PERFORM 9900-ABEND              THRU 9900-EXIT.              
      *                                                                         
T20235 6995-EXIT.                                                       
T20235     EXIT.                                                        
      *                                                                         
       7000-SELECT-COMP-NO.                                             
      *                                                                         
           EXEC SQL                                                     
               SELECT COMPANY_NO,                                       
T15090                SERIAL_NO,                                        
T15090                CODE_CRNT_LOC,                                    
T15090                CRNT_LOC_NO,                                      
T15090                INSTALL_DT                                        
T18007               ,LOCAL_OFFICE                                      
T18007               ,DATE_LAST_MOVE                                    
               INTO :EQ-COMPANY-NO,                                     
T15090              :EQ-SERIAL-NO,                                      
T15090              :EQ-CODE-CRNT-LOC,                                  
T15090              :EQ-CRNT-LOC-NO,                                    
T15090              :EQ-INSTALL-DT :WS-INSTALL-DT-NULL                   
T18007             ,:EQ-LOCAL-OFFICE                                    
T18007             ,:EQ-DATE-LAST-MOVE :WS-DATE-LAST-MOVE-NULL           
               FROM CSS_EQUIPMENT WITH(READUNCOMMITTED)                         
T15090         WHERE CODE_UTIL_TYPE = :WS-E                             
T22243           AND COMPANY_NO     = :EQ-COMPANY-NO                    
                 AND DEVICE_NO      = :EQ-DEVICE-NO                     
A04860                                                           
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NO,                                               
MFA-TR*               SERIAL_NO,                                                
MFA-TR*               CODE_CRNT_LOC,                                            
MFA-TR*               CRNT_LOC_NO,                                              
MFA-TR*               INSTALL_DT                                                
MFA-TR*              ,LOCAL_OFFICE                                              
MFA-TR*              ,DATE_LAST_MOVE                                            
MFA-TR*        INTO :EQ-COMPANY-NO,                                             
MFA-TR*             :EQ-SERIAL-NO,                                              
MFA-TR*             :EQ-CODE-CRNT-LOC,                                          
MFA-TR*             :EQ-CRNT-LOC-NO,                                            
MFA-TR*             :EQ-INSTALL-DT:WS-INSTALL-DT-NULL                           
MFA-TR*            ,:EQ-LOCAL-OFFICE                                            
MFA-TR*            ,:EQ-DATE-LAST-MOVE:WS-DATE-LAST-MOVE-NULL                   
MFA-TR*        FROM CSS_EQUIPMENT                                               
MFA-TR*        WHERE CODE_UTIL_TYPE = :WS-E                                     
MFA-TR*          AND COMPANY_NO     = :EQ-COMPANY-NO                            
MFA-TR*          AND DEVICE_NO      = :EQ-DEVICE-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
           OR SQLCODE = NOT-FOUND                                       
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '***************PCSMT658**************'          
               DISPLAY '* 7000-SELECT-COMP-NO               *'          
               DISPLAY '* ERROR READING CSS_EQUIPMENT       *'          
T22243         DISPLAY '* COMPANY NO IS ', EQ-COMPANY-NO                
               DISPLAY '* DEVICE NO IS ', EQ-DEVICE-NO                  
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSMT658**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7020-SELECT-ELEC-METER.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT AMPS,                                             
                      VOLTAGE,                                          
                      METER_SIZE_ID,                                    
PCR040                DATE_LAST_TESTED,                                 
PCR040                ELEC_MTR_CLASS_CD,                                
PCR040                ELEC_MTR_SPEC_CD                                  
TP4597               ,LAST_TEST_SEL_CD                                  
TP4597               ,LAST_TEST_SEL_DT                                  
T20129               ,TEST_SCHED_CD                                     
               INTO :EM-AMPS,                                           
                    :EM-VOLTAGE,                                        
                    :EM-METER-SIZE-ID  ,                                
PCR040              :EM-DATE-LAST-TESTED :WS-DATE-LAST-TEST-NULL,        
PCR040              :EM-ELEC-MTR-CLASS-CD,                              
PCR040              :EM-ELEC-MTR-SPEC-CD                                
TP4597             ,:EM-LAST-TEST-SEL-CD                                
TP4597             ,:EM-LAST-TEST-SEL-DT :WS-LAST-TEST-SEL-DT-NULL       
T20129             ,:EM-TEST-SCHED-CD                                   
               FROM CSS_ELEC_METER WITH(READUNCOMMITTED)                        
TP3285         WHERE CODE_UTIL_TYPE = :WS-E                             
T22243           AND COMPANY_NO     = :EM-COMPANY-NO                    
                 AND       METER_NO = :EM-METER-NO                      
A03352                                                           
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AMPS,                                                     
MFA-TR*               VOLTAGE,                                                  
MFA-TR*               METER_SIZE_ID,                                            
MFA-TR*               DATE_LAST_TESTED,                                         
MFA-TR*               ELEC_MTR_CLASS_CD,                                        
MFA-TR*               ELEC_MTR_SPEC_CD                                          
MFA-TR*              ,LAST_TEST_SEL_CD                                          
MFA-TR*              ,LAST_TEST_SEL_DT                                          
MFA-TR*              ,TEST_SCHED_CD                                             
MFA-TR*        INTO :EM-AMPS,                                                   
MFA-TR*             :EM-VOLTAGE,                                                
MFA-TR*             :EM-METER-SIZE-ID  ,                                        
MFA-TR*             :EM-DATE-LAST-TESTED:WS-DATE-LAST-TEST-NULL,                
MFA-TR*             :EM-ELEC-MTR-CLASS-CD,                                      
MFA-TR*             :EM-ELEC-MTR-SPEC-CD                                        
MFA-TR*            ,:EM-LAST-TEST-SEL-CD                                        
MFA-TR*            ,:EM-LAST-TEST-SEL-DT:WS-LAST-TEST-SEL-DT-NULL               
MFA-TR*            ,:EM-TEST-SCHED-CD                                           
MFA-TR*        FROM CSS_ELEC_METER                                              
MFA-TR*        WHERE CODE_UTIL_TYPE = :WS-E                                     
MFA-TR*          AND COMPANY_NO     = :EM-COMPANY-NO                            
MFA-TR*          AND       METER_NO = :EM-METER-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
           OR SQLCODE = NOT-FOUND                                       
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '***************PCSMT658**************'          
               DISPLAY '* 7020-SELECT-ELEC-METER            *'          
               DISPLAY '* ERROR READING CSS_ELEC_METER      *'          
T22243         DISPLAY '* COMPANY NO IS ', EM-COMPANY-NO                
               DISPLAY '* METER NBR IS ', EM-METER-NO                   
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSMT658**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T15090 7060-SELECT-CODE-REPAIR.                                         
      *                                                                         
           EXEC SQL                                                     
               SELECT CODE_REPAIR,                                      
                      TEST_REPAIR_DESC                                  
               INTO :N3-CODE-REPAIR,                                    
                    :N3-TEST-REPAIR-DESC                                
               FROM CSS_EQUIP_TST_REPR WITH(READUNCOMMITTED)                    
               WHERE CODE_REPAIR    = :WS-CODE-REPAIR                   
T33887           AND CODE_UTIL_TYPE = :N3-CODE-UTIL-TYPE                
T33887           AND COMPANY_NO     = :N3-COMPANY-NO                    
A03352                                                           
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_REPAIR,                                              
MFA-TR*               TEST_REPAIR_DESC                                          
MFA-TR*        INTO :N3-CODE-REPAIR,                                            
MFA-TR*             :N3-TEST-REPAIR-DESC                                        
MFA-TR*        FROM CSS_EQUIP_TST_REPR                                          
MFA-TR*        WHERE CODE_REPAIR    = :WS-CODE-REPAIR                           
MFA-TR*          AND CODE_UTIL_TYPE = :N3-CODE-UTIL-TYPE                        
MFA-TR*          AND COMPANY_NO     = :N3-COMPANY-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7060                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
           OR SQLCODE = NOT-FOUND                                       
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '***************PCSMT658**************'          
               DISPLAY '* 7060-SELECT-CODE-REPAIR           *'          
               DISPLAY '* ERROR READING CSS_EQUIP_TST_REPR  *'          
               DISPLAY '* CODE_REPAIR IS ', WS-CODE-REPAIR              
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSMT658**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7070-SELECT-CODE-TEST-TYPE.                                      
      *                                                                         
           EXEC SQL                                                     
               SELECT CODE_TEST_TYPE,                                   
                      TEST_TYPE_DESC                                    
               INTO :M9-CODE-TEST-TYPE,                                 
                    :M9-TEST-TYPE-DESC                                  
               FROM CSS_EQUIP_TEST_TYP WITH(READUNCOMMITTED)                    
               WHERE CODE_TEST_TYPE = :WS-ELEC-CODE-TEST-TYPE           
C29299           AND CODE_UTIL_TYPE = :M9-CODE-UTIL-TYPE                
A03352                                                           
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_TEST_TYPE,                                           
MFA-TR*               TEST_TYPE_DESC                                            
MFA-TR*        INTO :M9-CODE-TEST-TYPE,                                         
MFA-TR*             :M9-TEST-TYPE-DESC                                          
MFA-TR*        FROM CSS_EQUIP_TEST_TYP                                          
MFA-TR*        WHERE CODE_TEST_TYPE = :WS-ELEC-CODE-TEST-TYPE                   
MFA-TR*          AND CODE_UTIL_TYPE = :M9-CODE-UTIL-TYPE                        
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7070                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
           OR SQLCODE = NOT-FOUND                                       
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '***************PCSMT658**************'          
               DISPLAY '* 7070-SELECT-CODE-TEST-TYPE        *'          
               DISPLAY '* ERROR READING CSS_EQUIP_TEST_TYP  *'          
               DISPLAY '* CODE_TEST_TYPE IS ', WS-ELEC-CODE-TEST-TYPE   
C29299         DISPLAY '* CODE_UTIL_TYPE IS ', M9-CODE-UTIL-TYPE        
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSMT658**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7115-SELECT-ELEC-MTR-TEST-KEY.                                   
      *                                                                         
           EXEC SQL                                                     
               SELECT CODE_TEST_TYPE                                    
               INTO :ET-CODE-TEST-TYPE                                  
               FROM CSS_ELEC_MTR_TEST WITH(READUNCOMMITTED)                     
DB             WHERE CODE_UTIL_TYPE     = 'E'                           
T22243         AND   COMPANY_NO         = :ET-COMPANY-NO                
DB             AND   METER_NO           = :ET-METER-NO                  
               AND   DATE_TEST          = IIF(TRY_CONVERT(DATE, 
                                                          :ET-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :ET-DATE-TEST
              ) <> 0) OR (LEN(:ET-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :ET-DATE-TEST
              ), CONVERT(DATE, :ET-DATE-TEST) )                 
5854           AND   TIME_TEST          = CIS.CHAR2TIME(:ET-TIME-TEST)          
               AND   CODE_TIME_PERIOD   = :ET-CODE-TIME-PERIOD          
               AND   CODE_CAP_TYPE      = :ET-CODE-CAP-TYPE             
A03352                                                           
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_TEST_TYPE                                            
MFA-TR*        INTO :ET-CODE-TEST-TYPE                                          
MFA-TR*        FROM CSS_ELEC_MTR_TEST                                           
MFA-TR*        WHERE CODE_UTIL_TYPE     = 'E'                                   
MFA-TR*        AND   COMPANY_NO         = :ET-COMPANY-NO                        
MFA-TR*        AND   METER_NO           = :ET-METER-NO                          
MFA-TR*        AND   DATE_TEST          = :ET-DATE-TEST                         
MFA-TR*        AND   TIME_TEST          = :ET-TIME-TEST                         
MFA-TR*        AND   CODE_TIME_PERIOD   = :ET-CODE-TIME-PERIOD                  
MFA-TR*        AND   CODE_CAP_TYPE      = :ET-CODE-CAP-TYPE                     
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7115                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
           OR SQLCODE = NOT-FOUND                                       
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '***************PCSMT658**************'          
               DISPLAY '* 7115-SELECT-ELEC-MTR-TEST-KEY     *'          
               DISPLAY '* ERROR READING CSS_ELEC_MTR_TEST   *'          
T22243         DISPLAY '* COMPANY NO IS ', ET-COMPANY-NO                
               DISPLAY '* METER NBR IS   ', ET-METER-NO                 
               DISPLAY '* DATE TEST IS   ', ET-DATE-TEST                
5854           DISPLAY '* TIME TEST IS   ', ET-TIME-TEST                
               DISPLAY '* TIME PERIOD IS ', ET-CODE-TIME-PERIOD         
               DISPLAY '* CAP TYPE IS    ', ET-CODE-CAP-TYPE            
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSMT658**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7115-EXIT.  EXIT.                                                
      *                                                                         
TP4597****************************************************************          
TP4597** OBTAIN THE TEST HISTORY RECORD                             **          
TP4597****************************************************************          
      *                                                                         
TP4597 7150-SELECT-TEST-HIST.                                           
      *                                                                         
TP4597     EXEC SQL                                                     
TP4597         SELECT  SELECTED_QT                                      
TP4597                ,STATUS_CD                                        
TP4597                ,SAMPLE_MIN_QT                                    
TP4597                ,TESTED_QT                                        
TP4597          INTO  :MQ-SELECTED-QT                                   
TP4597               ,:MQ-STATUS-CD :WS-STATUS-CD-NULL                  
TP4597               ,:MQ-SAMPLE-MIN-QT                                 
TP4597               ,:MQ-TESTED-QT                                     
TP4597          FROM  CSS_MTR_TEST_HIST WITH(READUNCOMMITTED)                   
TP4597         WHERE  CODE_UTIL_TYPE  = :MQ-CODE-UTIL-TYPE              
T22243           AND  COMPANY_NO      = :MQ-COMPANY-NO                  
TP4597           AND  TEST_YEAR       = :MQ-TEST-YEAR                   
TP4597           AND  TEST_SCHED_CD   = :MQ-TEST-SCHED-CD               
TP4597           AND  MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD             
A03352                                                           
A03352                                                      
TP4597     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  SELECTED_QT                                              
MFA-TR*               ,STATUS_CD                                                
MFA-TR*               ,SAMPLE_MIN_QT                                            
MFA-TR*               ,TESTED_QT                                                
MFA-TR*         INTO  :MQ-SELECTED-QT                                           
MFA-TR*              ,:MQ-STATUS-CD :WS-STATUS-CD-NULL                          
MFA-TR*              ,:MQ-SAMPLE-MIN-QT                                         
MFA-TR*              ,:MQ-TESTED-QT                                             
MFA-TR*         FROM  CSS_MTR_TEST_HIST                                         
MFA-TR*        WHERE  CODE_UTIL_TYPE  = :MQ-CODE-UTIL-TYPE                      
MFA-TR*          AND  COMPANY_NO      = :MQ-COMPANY-NO                          
MFA-TR*          AND  TEST_YEAR       = :MQ-TEST-YEAR                           
MFA-TR*          AND  TEST_SCHED_CD   = :MQ-TEST-SCHED-CD                       
MFA-TR*          AND  MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD                     
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7150                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP4597     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
TP4597     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
TP4597         NEXT SENTENCE                                            
TP4597     ELSE                                                         
TP4597         MOVE SQLCODE TO WS-DISPLAY-RC                            
TP4597         DISPLAY '***************PCSMT658**************'          
TP4597         DISPLAY '* 7150-SELECT-TEST-HIST             *'          
TP4597         DISPLAY '* ERROR READING CSS_MTR_TEST_HIST   *'          
TP4597         DISPLAY '* CODE UTIL TYPE IS ', MQ-CODE-UTIL-TYPE        
T22243         DISPLAY '* COMPANY NO IS ', MQ-COMPANY-NO                
TP4597         DISPLAY '* TEST YEAR IS  ', MQ-TEST-YEAR                 
TP4597         DISPLAY '* TEST SCHED CD IS  ', MQ-TEST-SCHED-CD         
TP4597         DISPLAY '* TEST GRP CD IS  ', MQ-MTR-TEST-GRP-CD         
TP4597         DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
TP4597         DISPLAY '* PROGRAM ABENDING...               *'          
TP4597         DISPLAY '***************PCSMT658**************'          
TP4597         PERFORM 9900-ABEND THRU 9900-EXIT                        
TP4597     END-IF.                                                      
      *                                                                         
TP4597 7150-EXIT.                                                       
TP4597     EXIT.                                                        
      *                                                                         
T15090 7200-SELECT-LOC-OFFICE.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT   LOCAL_OFFICE_DESC                               
                 INTO   :B1-LOCAL-OFFICE-DESC                           
                 FROM   CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                  
T22243         WHERE    COMPANY_NO   = :B1-COMPANY-NO                   
               AND      LOCAL_OFFICE = :B1-LOCAL-OFFICE                 
A03352                                                           
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT   LOCAL_OFFICE_DESC                                       
MFA-TR*          INTO   :B1-LOCAL-OFFICE-DESC                                   
MFA-TR*          FROM   CSS_LOCAL_OFFICE                                        
MFA-TR*        WHERE    COMPANY_NO   = :B1-COMPANY-NO                           
MFA-TR*        AND      LOCAL_OFFICE = :B1-LOCAL-OFFICE                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '***************PCSMT658**************'          
               DISPLAY '* 7200-SELECT-LOC-OFFICE            *'          
               DISPLAY '* ERROR READING CSS_LOCAL_OFFICE    *'          
               DISPLAY '* SQLCODE   IS ', SQLCODE                       
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSMT658**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
T20235* SELECT CUSTOMER-NO AND LOCAL-OFFCE                          **          
      ****************************************************************          
      *                                                                         
T20235 7250-SELECT-ACCOUNT-DETAILS.                                     
      *                                                                         
           EXEC SQL                                                     
T20235         SELECT  CUSTOMER_NO,                                     
T20235                 LOCAL_OFFICE                                     
T20235           INTO  :AT-CUSTOMER-NO,                                 
T20235                 :AT-LOCAL-OFFICE                                 
T20235           FROM  CSS_ACCOUNT WITH(READUNCOMMITTED)                        
T20235           WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      
A03352                                                           
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  CUSTOMER_NO,                                             
MFA-TR*                LOCAL_OFFICE                                             
MFA-TR*          INTO  :AT-CUSTOMER-NO,                                         
MFA-TR*                :AT-LOCAL-OFFICE                                         
MFA-TR*          FROM  CSS_ACCOUNT                                              
MFA-TR*          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                              
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7250                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
T20235     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-RC              
               DISPLAY '**************** PCSMT658 *****************'    
T20235         DISPLAY '* 7250 : RETURN CODE ERROR - SELECT       *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
T20235         DISPLAY 'ACCOUNT NO: = ' AT-ACCOUNT-NO                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  OPEN THE CURSOR                                           **          
      ****************************************************************          
      *                                                                         
       7300-OPEN-MOVE-HIST-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
               OPEN MOVE-HIST-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-RC              
               DISPLAY '**************** PCSMT658 *****************'    
               DISPLAY '* 7300 : RETURN CODE ERROR - OPEN         *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
T22243         DISPLAY 'COMPANY NO : ', MV-COMPANY-NO                   
               DISPLAY 'DEVICE NO : ' MV-DEVICE-NO                      
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  THIS PARAGRAPH IS USED TO FETCH MOVE-HIST-CURSOR          **          
      ****************************************************************          
      *                                                                         
       7310-FETCH-MOVE-HIST-CURSOR.                                     
      *                                                                         
           EXEC SQL                                                     
               FETCH  MOVE-HIST-CURSOR                                  
                INTO  :MV-LOC-NO :WS-LOC-NO-NULL                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSMT658******************'    
               DISPLAY '* 7310 : RETURN CODE ERROR - FETCH        *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
T22243         DISPLAY 'COMPANY NO : ', MV-COMPANY-NO                   
               DISPLAY 'DEVICE NO : ' MV-DEVICE-NO                      
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  THIS PARAGRAPH IS USED TO CLOSE MOVE-HIST-CURSOR          **          
      ****************************************************************          
      *                                                                         
       7320-CLOSE-MOVE-HIST-CURSOR.                                     
      *                                                                         
           EXEC SQL                                                     
               CLOSE MOVE-HIST-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSMT658******************'    
               DISPLAY '* 7320 : RETURN CODE ERROR - CLOSE        *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
T22243         DISPLAY 'COMPANY NO : ', MV-COMPANY-NO                   
               DISPLAY 'DEVICE NO : ' MV-DEVICE-NO                      
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
END    7320-EXIT.                                                       
T15090     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      READS THE COMPANY NAME WITH THE GIVEN CODE            **          
      ****************************************************************          
      *                                                                         
       7350-GET-COMPANY-DESC.                                           
      *                                                                         
           MOVE '7350'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               SELECT  COMPANY_NAME                                     
                 INTO :C7-COMPANY-NAME                                  
                 FROM  CSS_COMPANY WITH(READUNCOMMITTED)                        
                WHERE  COMPANY_NO = :C7-COMPANY-NO                      
A03352                                                           
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  COMPANY_NAME                                             
MFA-TR*          INTO :C7-COMPANY-NAME                                          
MFA-TR*          FROM  CSS_COMPANY                                              
MFA-TR*         WHERE  COMPANY_NO = :C7-COMPANY-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7350                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '** SELECT ERROR IN 7350-GET-COMPANY-DESC **'    
               DISPLAY 'COMPANY NO : ', C7-COMPANY-NO                   
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
31683 ****************************************************************          
31683 **  SEE IF THE METER HAS A METER ATTACHMENT                   **          
31683 ****************************************************************          
      *                                                                         
31683  7400-METER-ATTCHMTS.                                             
      *                                                                         
C36856*    /*SELECTING ONLY METERS THAT ARE AMR (DEVICE_TYPE_CD = 'A')          
C36856*    /*AND NOT INTEGRATED (HOW_ATTACHED_CD <> 'I') OR NOT AMR             
C36856*    DISPLAY '7400-METER-ATTCHMTS'                                        
31683      EXEC SQL                                                     
31683         SELECT TOP(1) 'Y'                                               
31683           INTO  :WS-EXISTS                                        
31683           FROM  CSS_METER_ATTCHMTS MA,                            
C36856                CSS_MTR_ATT_TYPE N5                               
C36856         WHERE  MA.METER_NO       = :MA-METER-NO                  
C36856         AND    MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE            
C36856         AND    MA.COMPANY_NO     = :MA-COMPANY-NO                
C36856         AND    MA.DEVICE_NO      > ' '                           
C36856         AND    ((N5.DEVICE_TYPE_CD = 'A' AND                     
C36856          MA.HOW_ATTACHED_CD <> 'I') OR N5.DEVICE_TYPE_CD <> 'A') 
C36856         AND    N5.CODE_UTIL_TYPE   = MA.CODE_UTIL_TYPE           
C36856         AND    N5.CODE_ATT_TYPE    = MA.CODE_ATT_TYPE            
C36856                                              
A03352                                                      
31683      END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         INTO  :WS-EXISTS                                                
MFA-TR*         FROM  CSS_METER_ATTCHMTS MA,                                    
MFA-TR*               CSS_MTR_ATT_TYPE N5                                       
MFA-TR*        WHERE  MA.METER_NO       = :MA-METER-NO                          
MFA-TR*        AND    MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                    
MFA-TR*        AND    MA.COMPANY_NO     = :MA-COMPANY-NO                        
MFA-TR*        AND    MA.DEVICE_NO      > ' '                                   
MFA-TR*        AND    ((N5.DEVICE_TYPE_CD = 'A' AND                             
MFA-TR*         MA.HOW_ATTACHED_CD <> 'I') OR N5.DEVICE_TYPE_CD <> 'A')         
MFA-TR*        AND    N5.CODE_UTIL_TYPE   = MA.CODE_UTIL_TYPE                   
MFA-TR*        AND    N5.CODE_ATT_TYPE    = MA.CODE_ATT_TYPE                    
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
31683      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
31683                      WS-DISPLAY-RC.                               
      *                                                                         
31683      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
31683         CONTINUE                                                  
31683      ELSE                                                         
31683        DISPLAY '********** PCSMT658 ABORT ****************'       
31683        DISPLAY '* 1250-RETIRE-METER                      *'       
31683        DISPLAY '* METER_NO ', E-FMT04-METER-NO                    
31683        DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                   
31683        DISPLAY '* PROGRAM ABORTING...                    *'       
31683        DISPLAY '********** PCSMT658 ABORT ****************'       
31683        PERFORM 9900-ABEND            THRU 9900-EXIT               
31683      END-IF.                                                      
      *                                                                         
31683  7400-EXIT.                                                       
31683      EXIT.                                                        
      *                                                                         
C36856****************************************************************          
C36856**                                                            **          
C36856**   7410-OPEN-INT-ERT.                                       **          
C36856**       TO OPEN CURSOR INT-ERT FOR CSS_METER_ATTCHMTS        **          
C36856**                                                            **          
C36856****************************************************************          
C36856*                                                                         
C36856 7410-OPEN-INT-ERT.                                               
C36856*                                                                         
C36856     EXEC SQL                                                     
C36856         OPEN INT-ERT                                             
C36856     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36856*                                                                         
C36856     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
C36856*                                                                         
C36856     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C36856         NEXT SENTENCE                                            
C36856     ELSE                                                         
C36856         DISPLAY '**  OPEN ERROR IN 7410-OPEN-RET-MTR   **'       
C36856         DISPLAY '**    TABLE :  CSS_METER_ATTCHMTS     **'       
C36856         DISPLAY '**    TABLE :   CSS_MTR_ATT_TYPE      **'       
C36856         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C36856         DISPLAY '**       PROCESSING TERMINATED        **'       
C36856         PERFORM 9900-ABEND         THRU 9900-EXIT                
C36856     END-IF.                                                      
C36856*                                                                         
C36856 7410-EXIT.                                                       
C36856     EXIT.                                                        
C36856*                                                                         
C36856****************************************************************          
C36856**                                                            **          
C36856**   7420-FETCH-INT-ERT.                                      **          
C36856**       TO FETCH FIELD DETAILS FROM CSS_METER_ATTCHMTS       **          
C36856**                                                            **          
C36856****************************************************************          
C36856*                                                                         
C36856 7420-FETCH-INT-ERT.                                              
C36856*                                                                         
C36856     EXEC SQL                                                     
C36856         FETCH                                                    
C36856             INT-ERT                                              
C36856         INTO                                                     
C36856             :MA-DEVICE-NO,                                       
C36856             :MA-CODE-ATT-TYPE                                    
C36856     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36856*                                                                         
C36856     MOVE SQLCODE           TO     WS-ACTIVE-RETURN-CODE.         
C36856*                                                                         
C36856     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C36856         NEXT SENTENCE                                            
C36856     ELSE                                                         
C36856         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
C36856             MOVE WS-Y TO WS-INT-ERT-FLAG                         
C36856         ELSE                                                     
C36856             DISPLAY '**  FETCH ERROR IN 7420-FETCH-INT-ERT   **' 
C36856             DISPLAY '**     TABLE :  CSS_METER_ATTCHMTS      **' 
C36856             DISPLAY '**     TABLE :   CSS_MTR_ATT_TYPE       **' 
C36856             DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
C36856             DISPLAY '** COMPANY-NO  = ' EQ-COMPANY-NO            
C36856             DISPLAY '** UTIL-TYPE   = ' MA-CODE-UTIL-TYPE        
C36856             DISPLAY '** COMPANY-NO  = ' MA-COMPANY-NO            
C36856             DISPLAY '** METER-NO    = ' MA-METER-NO              
C36856             DISPLAY '**       PROCESSING TERMINATED        **'   
C36856             PERFORM 9900-ABEND         THRU 9900-EXIT            
C36856         END-IF                                                   
C36856     END-IF.                                                      
C36856*                                                                         
C36856 7420-EXIT.                                                       
C36856     EXIT.                                                        
C36856*                                                                         
C36856****************************************************************          
C36856**                                                            **          
C36856**   7430-CLOSE-INT-ERT.                                      **          
C36856**       TO CLOSE CURSOR INT-ERT                              **          
C36856**                                                            **          
C36856****************************************************************          
C36856*                                                                         
C36856 7430-CLOSE-INT-ERT.                                              
C36856*                                                                         
C36856     EXEC SQL                                                     
C36856         CLOSE INT-ERT                                            
C36856     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36856*                                                                         
C36856     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
C36856*                                                                         
C36856     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C36856         NEXT SENTENCE                                            
C36856     ELSE                                                         
C36856         DISPLAY '**  CLOSE ERROR IN 7430-CLOSE-RET-MTR **'       
C36856         DISPLAY '**    TABLE :  CSS_METER_ATTCHMTS     **'       
C36856         DISPLAY '**    TABLE :   CSS_MTR_ATT_TYPE      **'       
C36856         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C36856         DISPLAY '**       PROCESSING TERMINATED        **'       
C36856         PERFORM 9900-ABEND         THRU 9900-EXIT                
C36856     END-IF.                                                      
C36856*                                                                         
C36856 7430-EXIT.                                                       
C36856     EXIT.                                                        
C36856*                                                                         
C36856****************************************************************          
C36856**                                                            **          
C36856**   7440-GET-MOVE-DETAILS.                                   **          
C36856**       GET METER STORAGE FACILITY CODE FOR ATTCH MOVE HIST  **          
C36856**                                                            **          
C36856****************************************************************          
C36856*                                                                         
C36856 7440-GET-MOVE-DETAILS.                                           
C36856*                                                                         
C36856     EXEC SQL                                                     
C36856         SELECT LX.MTR_STORAGE_FAC_CD                             
C36856               ,LX.EQUIP_LOC_ID                                   
C36856         INTO :LX-MTR-STORAGE-FAC-CD                              
C36856             ,:LX-EQUIP-LOC-ID                                    
C36856         FROM  CSS_EQUIP_ATTCHMTS  LX WITH(READUNCOMMITTED)               
C36856         WHERE LX.DEVICE_NO        = :LX-DEVICE-NO                
C36856         AND   LX.CODE_ATT_TYPE    = :LX-CODE-ATT-TYPE            
C36856         AND   LX.COMPANY_NO       = :LX-COMPANY-NO               
C36856         AND   LX.CODE_UTIL_TYPE   = :LX-CODE-UTIL-TYPE           
C36856                                                           
A03352                                                      
C36856     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LX.MTR_STORAGE_FAC_CD                                     
MFA-TR*              ,LX.EQUIP_LOC_ID                                           
MFA-TR*        INTO :LX-MTR-STORAGE-FAC-CD                                      
MFA-TR*            ,:LX-EQUIP-LOC-ID                                            
MFA-TR*        FROM  CSS_EQUIP_ATTCHMTS  LX                                     
MFA-TR*        WHERE LX.DEVICE_NO        = :LX-DEVICE-NO                        
MFA-TR*        AND   LX.CODE_ATT_TYPE    = :LX-CODE-ATT-TYPE                    
MFA-TR*        AND   LX.COMPANY_NO       = :LX-COMPANY-NO                       
MFA-TR*        AND   LX.CODE_UTIL_TYPE   = :LX-CODE-UTIL-TYPE                   
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7440                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36856*                                                                         
C36856     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
C36856*                                                                         
C36856     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C36856         NEXT SENTENCE                                            
C36856     ELSE                                                         
C36856         DISPLAY '**  7440-GET-MOVE-DETAILS             **'       
C36856         DISPLAY '**    TABLE :  CSS_EQUIP_ATTCHMTS     **'       
C36856         DISPLAY '** LX-DEVICE-NO      : ' LX-DEVICE-NO           
C36856         DISPLAY '** LX-CODE-ATT-TYPE  : ' LX-CODE-ATT-TYPE       
C36856         DISPLAY '** LX-COMPANY-NO     : ' LX-COMPANY-NO          
C36856         DISPLAY '** LX-CODE-UTIL-TYPE : ' LX-CODE-UTIL-TYPE      
C36856         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C36856         DISPLAY '**       PROCESSING TERMINATED        **'       
C36856         PERFORM 9900-ABEND         THRU 9900-EXIT                
C36856     END-IF.                                                      
C36856*                                                                         
C36856 7440-EXIT.                                                       
C36856     EXIT.                                                        
C36856*                                                                         
T35434******************************************************************        
T35434* 8893-RESET-RESTART-REQ-PARM                                    *        
T35434******************************************************************        
T35434     EXEC SQL                                                             
T35434          INCLUDE CPD00029                                                
T35434     END-EXEC.                                                            
T35434*                                                                         
T35434*****************************************************************         
T35434*    0605-VALIDATE-RESTART                                      *         
T35434*****************************************************************         
T35434     EXEC SQL                                                             
T35434          INCLUDE CPD00030                                                
T35434     END-EXEC.                                                            
T35434*                                                                         
T35434*****************************************************************         
T35434*    6523-GET-FJC01-CHKP-LIMIT.                                 *         
T35434*****************************************************************         
T35434     EXEC SQL                                                             
T35434          INCLUDE CPD00034                                                
T35434     END-EXEC.                                                            
T35434*                                                                         
T35434*****************************************************************         
T35434*    6235-GET-FJC01-RESTART-REQ.                                          
T35434*****************************************************************         
T35434     EXEC SQL                                                             
T35434          INCLUDE CPD00035                                                
T35434     END-EXEC.                                                            
T35434*                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00038                                                
           END-EXEC.                                                            
      *                                                                         
       8000-INITIALIZE.                                                 
      *                                                                         
      *    MOVE WS-N TO WS-DEMAND-METER WS-RECORD-FLAG.                         
      *    COMPUTE WS-ERR-ARRAY-IDX = 1.                                        
      *    COMPUTE WS-NO-CAP-COUNTER = 0.                                       
           SET INPUT-IS-VALID TO TRUE.                                  
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8100-READ-METER-TEST-FILE.                                       
      *                                                                         
TP4597     READ FCSMT04-FILE                                            
           AT END MOVE 'Y' TO WS-EOF-FLAG.                              
                                                                        
TP4597     IF  UTILITY-TYPE-PARM = WS-E                                 
TP4597         IF  FIOMT04-ELEC-TEST-REC(78:1) = WS-W                   
TP4597             MOVE 'Y'                    TO WS-EOF-FLAG           
TP4597             GO TO 8100-EXIT                                      
TP4597         END-IF                                                   
TP4597     ELSE                                                         
                   DISPLAY '***************PCSMT658***************'     
                   DISPLAY '* 8100-READ-METER-TEST-FILE          *'     
                   DISPLAY '* INVALID PARM IN CSS_JOB_PARM TABLE *'     
                   DISPLAY '* DATA NAME IS  UTIL TYPE =          *'     
                   DISPLAY '* DATA VALUE IS ', UTILITY-TYPE-PARM        
                   DISPLAY '* PROGRAM ABORTING...                *'     
                   DISPLAY '***************PCSMT658***************'     
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
TP4597     END-IF.                                                      
                                                                        
           IF FIRST-READ                                                
              MOVE 'N' TO WS-READ-FLAG                                  
           END-IF.                                                      
T35434     ADD 1 TO WS-MT04-REC-CNTR.                                   
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T15090 8200-WRITE-ERROR-REPORT.                                         
      *                                                                         
           PERFORM 2400-LOAD-ERROR-DATA THRU 2400-EXIT.                 
           MOVE E-FMT04-DISTRICT               TO WS-DISTRICT.          
           IF  WS-DISTRICT = '15'                                       
               MOVE '02'                       TO WS-DISTRICT           
           END-IF.                                                      
           IF  WS-LOCAL-OFFICE NOT = WS-TITLE4-LOCAL-OFF                
               MOVE 57              TO WS-LINE-COUNT                    
               MOVE WS-LOCAL-OFFICE TO WS-TITLE4-LOCAL-OFF              
                                       B1-LOCAL-OFFICE                  
               PERFORM 7200-SELECT-LOC-OFFICE THRU 7200-EXIT            
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 MOVE B1-LOCAL-OFFICE-DESC TO WS-TITLE4-LOCAL-OFF-DESC  
               ELSE                                                     
                 MOVE 'UNKNOWN' TO WS-TITLE4-LOCAL-OFF-DESC             
               END-IF                                                   
           END-IF.                                                      
           IF  (57 - WS-LINE-COUNT) < 2                                 
               ADD  1             TO WS-PAGE-COUNT                      
               MOVE WS-PAGE-COUNT TO WS-TITLE3-PAGE-COUNT               
               WRITE PRT33-RECORD FROM WS-TITLE-1 AFTER NEW-PAGE        
               WRITE PRT33-RECORD FROM WS-TITLE-2 AFTER 1               
               WRITE PRT33-RECORD FROM WS-TITLE-3 AFTER 1               
               WRITE PRT33-RECORD FROM WS-TITLE-4 AFTER 1               
               WRITE PRT33-RECORD FROM WS-TITLE-5 AFTER 1               
               WRITE PRT33-RECORD FROM WS-TITLE-6 AFTER 1               
               MOVE 6             TO WS-LINE-COUNT                      
           END-IF.                                                      
           WRITE PRT33-RECORD FROM WS-DETAIL-1 AFTER 2.                 
           ADD 2 TO WS-LINE-COUNT.                                      
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8600-UPDATE-EQUIP.                                               
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_EQUIPMENT                                     
                SET DATE_LAST_TRAN  = CAST(SYSDATETIMEOFFSET() AS DATE)         
               WHERE CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                
T22243           AND COMPANY_NO     = :EQ-COMPANY-NO                    
                 AND DEVICE_NO      = :EQ-DEVICE-NO                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_EQUIPMENT                                             
MFA-TR*         SET DATE_LAST_TRAN  = CURRENT DATE                              
MFA-TR*        WHERE CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                        
MFA-TR*          AND COMPANY_NO     = :EQ-COMPANY-NO                            
MFA-TR*          AND DEVICE_NO      = :EQ-DEVICE-NO                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSMT658************'              
               DISPLAY '* 8600-UPDATE-EQUIP             *'              
               DISPLAY '* ERROR UPDATING CSS_EQUIPMENT  *'              
               DISPLAY '* UTIL TYPE IS    ', EQ-CODE-UTIL-TYPE          
T22243         DISPLAY '* COMPANY NO IS   ', EQ-COMPANY-NO              
               DISPLAY '* METER NUMBER IS ', EQ-DEVICE-NO               
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...           *'              
               DISPLAY '*************PCSMT658************'              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8630-INSERT-ELEC-MTR-TEST.                                       
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_ELEC_MTR_TEST                            
                    ( CODE_UTIL_TYPE                                    
                    , METER_NO                                          
                    , DATE_TEST                                         
                    , TIME_TEST                                         
                    , CODE_TIME_PERIOD                                  
                    , CODE_CAP_TYPE                                     
                    , CODE_REPAIR                                       
                    , REPAIR_DESC                                       
                    , CODE_TEST_TYPE                                    
                    , CODE_TEST_LOC                                     
                    , CODE_TEST_RESULT                                  
                    , IN_CONSTANT                                       
                    , READ_AF                                           
                    , DEM_READ_AF                                       
                    , LIGHT_LOAD_ACCU_AF                                
                    , FULL_LOAD_ACCU_AF                                 
                    , LIGHT_LOAD_ACCU_AL                                
                    , FULL_LOAD_ACCU_AL                                 
                    , POWER_FCTR_ACCU_AF                                
                    , POWER_FCTR_ACCU_AL                                
PCR030              , EQ_TESTER_ID                                      
                    , TEST_BENCH_ID                                     
                    , READ_AL                                           
T22243              , COMPANY_NO                                        
                    , DEM_READ_AL )                                     
               VALUES ( 'E'                                             
                      , :ET-METER-NO                                    
                      , IIF(TRY_CONVERT(DATE, :ET-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :ET-DATE-TEST
              ) <> 0) OR (LEN(:ET-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :ET-DATE-TEST
              ), CONVERT(DATE, :ET-DATE-TEST) )                                
                      , CIS.CHAR2TIME(:ET-TIME-TEST)                            
                      , :ET-CODE-TIME-PERIOD                            
                      , :ET-CODE-CAP-TYPE                               
                      , :ET-CODE-REPAIR                                 
                      , :ET-REPAIR-DESC                                 
                      , :ET-CODE-TEST-TYPE                              
                      , :ET-CODE-TEST-LOC                               
                      , :ET-CODE-TEST-RESULT                            
                      , :ET-IN-CONSTANT                                 
                      , :ET-READ-AF                                     
                      , :ET-DEM-READ-AF                                 
                      , :ET-LIGHT-LOAD-ACCU-AF                          
                      , :ET-FULL-LOAD-ACCU-AF                           
                      , :ET-LIGHT-LOAD-ACCU-AL                          
                      , :ET-FULL-LOAD-ACCU-AL                           
                      , :ET-POWER-FCTR-ACCU-AF                          
                      , :ET-POWER-FCTR-ACCU-AL                          
PCR030                , :ET-EQ-TESTER-ID                                
                      , :ET-TEST-BENCH-ID                               
                      , :ET-READ-AL                                     
T22243                , :ET-COMPANY-NO                                  
                      , :ET-DEM-READ-AL )                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_ELEC_MTR_TEST                                    
MFA-TR*             ( CODE_UTIL_TYPE                                            
MFA-TR*             , METER_NO                                                  
MFA-TR*             , DATE_TEST                                                 
MFA-TR*             , TIME_TEST                                                 
MFA-TR*             , CODE_TIME_PERIOD                                          
MFA-TR*             , CODE_CAP_TYPE                                             
MFA-TR*             , CODE_REPAIR                                               
MFA-TR*             , REPAIR_DESC                                               
MFA-TR*             , CODE_TEST_TYPE                                            
MFA-TR*             , CODE_TEST_LOC                                             
MFA-TR*             , CODE_TEST_RESULT                                          
MFA-TR*             , IN_CONSTANT                                               
MFA-TR*             , READ_AF                                                   
MFA-TR*             , DEM_READ_AF                                               
MFA-TR*             , LIGHT_LOAD_ACCU_AF                                        
MFA-TR*             , FULL_LOAD_ACCU_AF                                         
MFA-TR*             , LIGHT_LOAD_ACCU_AL                                        
MFA-TR*             , FULL_LOAD_ACCU_AL                                         
MFA-TR*             , POWER_FCTR_ACCU_AF                                        
MFA-TR*             , POWER_FCTR_ACCU_AL                                        
MFA-TR*             , EQ_TESTER_ID                                              
MFA-TR*             , TEST_BENCH_ID                                             
MFA-TR*             , READ_AL                                                   
MFA-TR*             , COMPANY_NO                                                
MFA-TR*             , DEM_READ_AL )                                             
MFA-TR*        VALUES ( 'E'                                                     
MFA-TR*               , :ET-METER-NO                                            
MFA-TR*               , :ET-DATE-TEST                                           
MFA-TR*               , :ET-TIME-TEST                                           
MFA-TR*               , :ET-CODE-TIME-PERIOD                                    
MFA-TR*               , :ET-CODE-CAP-TYPE                                       
MFA-TR*               , :ET-CODE-REPAIR                                         
MFA-TR*               , :ET-REPAIR-DESC                                         
MFA-TR*               , :ET-CODE-TEST-TYPE                                      
MFA-TR*               , :ET-CODE-TEST-LOC                                       
MFA-TR*               , :ET-CODE-TEST-RESULT                                    
MFA-TR*               , :ET-IN-CONSTANT                                         
MFA-TR*               , :ET-READ-AF                                             
MFA-TR*               , :ET-DEM-READ-AF                                         
MFA-TR*               , :ET-LIGHT-LOAD-ACCU-AF                                  
MFA-TR*               , :ET-FULL-LOAD-ACCU-AF                                   
MFA-TR*               , :ET-LIGHT-LOAD-ACCU-AL                                  
MFA-TR*               , :ET-FULL-LOAD-ACCU-AL                                   
MFA-TR*               , :ET-POWER-FCTR-ACCU-AF                                  
MFA-TR*               , :ET-POWER-FCTR-ACCU-AL                                  
MFA-TR*               , :ET-EQ-TESTER-ID                                        
MFA-TR*               , :ET-TEST-BENCH-ID                                       
MFA-TR*               , :ET-READ-AL                                             
MFA-TR*               , :ET-COMPANY-NO                                          
MFA-TR*               , :ET-DEM-READ-AL )                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
           OR SQLCODE = -803                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSMT658*****************'         
               DISPLAY '* 8630-INSERT-ELEC-MTR-TEST          *'         
               DISPLAY '* ERROR INSERTING CSS_ELECT_MTR_TEST *'         
T22243         DISPLAY '* COMPANY NO IS   ', ET-COMPANY-NO              
               DISPLAY '* METER NUMBER IS ', ET-METER-NO                
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...                *'         
               DISPLAY '*************PCSMT658*****************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8630-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8635-UPDATE-ELEC-MTR-TEST.                                       
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_ELEC_MTR_TEST                                 
                  SET CODE_REPAIR         = :ET-CODE-REPAIR             
                    , REPAIR_DESC         = :ET-REPAIR-DESC             
                    , CODE_TEST_TYPE      = :ET-CODE-TEST-TYPE          
                    , CODE_TEST_LOC       = :ET-CODE-TEST-LOC           
                    , CODE_TEST_RESULT    = :ET-CODE-TEST-RESULT        
                    , IN_CONSTANT         = :ET-IN-CONSTANT             
                    , READ_AF             = :ET-READ-AF                 
                    , DEM_READ_AF         = :ET-DEM-READ-AF             
                    , LIGHT_LOAD_ACCU_AF  = :ET-LIGHT-LOAD-ACCU-AF      
                    , FULL_LOAD_ACCU_AF   = :ET-FULL-LOAD-ACCU-AF       
                    , LIGHT_LOAD_ACCU_AL  = :ET-LIGHT-LOAD-ACCU-AL      
                    , FULL_LOAD_ACCU_AL   = :ET-FULL-LOAD-ACCU-AL       
                    , POWER_FCTR_ACCU_AF  = :ET-POWER-FCTR-ACCU-AF      
                    , POWER_FCTR_ACCU_AL  = :ET-POWER-FCTR-ACCU-AL      
PCR030              , EQ_TESTER_ID        = :ET-EQ-TESTER-ID            
                    , TEST_BENCH_ID       = :ET-TEST-BENCH-ID           
                    , READ_AL             = :ET-READ-AL                 
                    , DEM_READ_AL         = :ET-DEM-READ-AL             
DB             WHERE CODE_UTIL_TYPE   = 'E'                             
T22243           AND COMPANY_NO       = :ET-COMPANY-NO                  
DB               AND METER_NO         = :ET-METER-NO                    
                 AND DATE_TEST        = IIF(TRY_CONVERT(DATE, 
                                                          :ET-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :ET-DATE-TEST
              ) <> 0) OR (LEN(:ET-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :ET-DATE-TEST
              ), CONVERT(DATE, :ET-DATE-TEST) )                   
5854             AND TIME_TEST        = CIS.CHAR2TIME(:ET-TIME-TEST)            
                 AND CODE_TIME_PERIOD = :ET-CODE-TIME-PERIOD            
                 AND CODE_CAP_TYPE    = :ET-CODE-CAP-TYPE               
                 AND CODE_TEST_TYPE   = :ET-CODE-TEST-TYPE              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ELEC_MTR_TEST                                         
MFA-TR*           SET CODE_REPAIR         = :ET-CODE-REPAIR                     
MFA-TR*             , REPAIR_DESC         = :ET-REPAIR-DESC                     
MFA-TR*             , CODE_TEST_TYPE      = :ET-CODE-TEST-TYPE                  
MFA-TR*             , CODE_TEST_LOC       = :ET-CODE-TEST-LOC                   
MFA-TR*             , CODE_TEST_RESULT    = :ET-CODE-TEST-RESULT                
MFA-TR*             , IN_CONSTANT         = :ET-IN-CONSTANT                     
MFA-TR*             , READ_AF             = :ET-READ-AF                         
MFA-TR*             , DEM_READ_AF         = :ET-DEM-READ-AF                     
MFA-TR*             , LIGHT_LOAD_ACCU_AF  = :ET-LIGHT-LOAD-ACCU-AF              
MFA-TR*             , FULL_LOAD_ACCU_AF   = :ET-FULL-LOAD-ACCU-AF               
MFA-TR*             , LIGHT_LOAD_ACCU_AL  = :ET-LIGHT-LOAD-ACCU-AL              
MFA-TR*             , FULL_LOAD_ACCU_AL   = :ET-FULL-LOAD-ACCU-AL               
MFA-TR*             , POWER_FCTR_ACCU_AF  = :ET-POWER-FCTR-ACCU-AF              
MFA-TR*             , POWER_FCTR_ACCU_AL  = :ET-POWER-FCTR-ACCU-AL              
MFA-TR*             , EQ_TESTER_ID        = :ET-EQ-TESTER-ID                    
MFA-TR*             , TEST_BENCH_ID       = :ET-TEST-BENCH-ID                   
MFA-TR*             , READ_AL             = :ET-READ-AL                         
MFA-TR*             , DEM_READ_AL         = :ET-DEM-READ-AL                     
MFA-TR*        WHERE CODE_UTIL_TYPE   = 'E'                                     
MFA-TR*          AND COMPANY_NO       = :ET-COMPANY-NO                          
MFA-TR*          AND METER_NO         = :ET-METER-NO                            
MFA-TR*          AND DATE_TEST        = :ET-DATE-TEST                           
MFA-TR*          AND TIME_TEST        = :ET-TIME-TEST                           
MFA-TR*          AND CODE_TIME_PERIOD = :ET-CODE-TIME-PERIOD                    
MFA-TR*          AND CODE_CAP_TYPE    = :ET-CODE-CAP-TYPE                       
MFA-TR*          AND CODE_TEST_TYPE   = :ET-CODE-TEST-TYPE                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSMT658*****************'         
               DISPLAY '* 8635-UPDATE-ELEC-MTR-TEST          *'         
               DISPLAY '* ERROR UPDATING CSS_ELECT_MTR_TEST  *'         
T22243         DISPLAY '* COMPANY NO IS   ', ET-COMPANY-NO              
               DISPLAY '* METER NUMBER IS ', ET-METER-NO                
               DISPLAY '* DATE TEST IS ', ET-DATE-TEST                  
5854           DISPLAY '* TIME TEST IS ', ET-TIME-TEST                  
               DISPLAY '* TIME PERIOD IS ', ET-CODE-TIME-PERIOD         
               DISPLAY '* CAP TYPE IS ', ET-CODE-CAP-TYPE               
               DISPLAY '* TEST TYPE IS ', ET-CODE-TEST-TYPE             
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...                *'         
               DISPLAY '*************PCSMT658*****************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8635-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8640-UPDATE-ELEC-METER.                                          
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_ELEC_METER                                    
                 SET DATE_LAST_TESTED = IIF(TRY_CONVERT(DATE, 
                                                   :EM-DATE-LAST-TESTED
              ) IS NULL OR (PATINDEX('%.%', :EM-DATE-LAST-TESTED
              ) <> 0) OR (LEN(:EM-DATE-LAST-TESTED
              ) <> 10), CIS.CHAR2DATE(:EM-DATE-LAST-TESTED
              ), CONVERT(DATE, :EM-DATE-LAST-TESTED) )            
               WHERE   CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE              
T22243           AND       COMPANY_NO = :EM-COMPANY-NO                  
                 AND         METER_NO = :EM-METER-NO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ELEC_METER                                            
MFA-TR*          SET DATE_LAST_TESTED = :EM-DATE-LAST-TESTED                    
MFA-TR*        WHERE   CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE                      
MFA-TR*          AND       COMPANY_NO = :EM-COMPANY-NO                          
MFA-TR*          AND         METER_NO = :EM-METER-NO                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSMT658************'              
               DISPLAY '* 8640-UPDATE-ELEC-METER        *'              
               DISPLAY '* ERROR UPDATING CSS_ELEC_METER *'              
T22243         DISPLAY '* COMPANY NO IS   ', EM-COMPANY-NO              
               DISPLAY '* METER NUMBER IS ', EM-METER-NO                
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...           *'              
               DISPLAY '*************PCSMT658************'              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8640-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
TP4597****************************************************************          
TP4597** UPDATES CSS_MTR_TEST_HIST                                  **          
TP4597****************************************************************          
      *                                                                         
TP4597 8650-UPDATE-TEST-HIST.                                           
      *                                                                         
TP4597     EXEC SQL                                                     
TP4597         UPDATE  CSS_MTR_TEST_HIST                                
TP4597            SET  STATUS_CD       = :MQ-STATUS-CD,                 
TP4597                 TESTED_QT       = :MQ-TESTED-QT                  
TP4597          WHERE  CODE_UTIL_TYPE  = :MQ-CODE-UTIL-TYPE             
T22243            AND  COMPANY_NO      = :MQ-COMPANY-NO                 
TP4597            AND  TEST_YEAR       = :MQ-TEST-YEAR                  
TP4597            AND  TEST_SCHED_CD   = :MQ-TEST-SCHED-CD              
TP4597            AND  MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD            
TP4597     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP4597     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
TP4597     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
TP4597         NEXT SENTENCE                                            
TP4597     ELSE                                                         
TP4597         MOVE SQLCODE TO WS-DISPLAY-RC                            
TP4597         DISPLAY '*************PCSMT658**************'            
TP4597         DISPLAY '* 8650-UPDATE-TEST-HIST           *'            
TP4597         DISPLAY '* ERROR UPDATING CSS_MTR_TEST_HIST*'            
T22243         DISPLAY '* COMPANY NO IS   ', MQ-COMPANY-NO              
TP4597         DISPLAY '* CODE UTIL TYPE IS ', MQ-CODE-UTIL-TYPE        
TP4597         DISPLAY '* TEST YEAR IS  ', MQ-TEST-YEAR                 
TP4597         DISPLAY '* TEST SCHED CD IS  ', MQ-TEST-SCHED-CD         
TP4597         DISPLAY '* TEST GRP CD IS  ', MQ-MTR-TEST-GRP-CD         
TP4597         DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
TP4597         DISPLAY '* PROGRAM ABENDING...             *'            
TP4597         DISPLAY '*************PCSMT658**************'            
TP4597         PERFORM 9900-ABEND THRU 9900-EXIT                        
TP4597     END-IF.                                                      
      *                                                                         
TP4597 8650-EXIT.                                                       
TP4597     EXIT.                                                        
      *                                                                         
T18007 8660-INSERT-MOVEMENT-HIST.                                       
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_MOVEMENT_HIST                            
                      ( CODE_DEVICE_TYPE,                               
                        DEVICE_NO,                                      
                        CODE_UTIL_TYPE,                                 
                        DATE_MOVE,                                      
                        LOCAL_OFFICE,                                   
                        COMPANY_NO,                                     
                        LOC_NO,                                         
                        MOVE_NO,                                        
                        CODE_CRNT_LOC )                                 
               VALUES ( 'M',                                            
                        :MV-DEVICE-NO,                                  
                        'E',                                            
                        IIF(TRY_CONVERT(DATE, :MV-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MV-DATE-MOVE
              ) <> 0) OR (LEN(:MV-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MV-DATE-MOVE
              ), CONVERT(DATE, :MV-DATE-MOVE) ),                               
                        :MV-LOCAL-OFFICE,                               
                        :MV-COMPANY-NO,                                 
                        :MV-LOC-NO,                                     
                        CIS.CURRENT$TIMESTAMP(),                              
                        :MV-CODE-CRNT-LOC )                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MOVEMENT_HIST                                    
MFA-TR*               ( CODE_DEVICE_TYPE,                                       
MFA-TR*                 DEVICE_NO,                                              
MFA-TR*                 CODE_UTIL_TYPE,                                         
MFA-TR*                 DATE_MOVE,                                              
MFA-TR*                 LOCAL_OFFICE,                                           
MFA-TR*                 COMPANY_NO,                                             
MFA-TR*                 LOC_NO,                                                 
MFA-TR*                 MOVE_NO,                                                
MFA-TR*                 CODE_CRNT_LOC )                                         
MFA-TR*        VALUES ( 'M',                                                    
MFA-TR*                 :MV-DEVICE-NO,                                          
MFA-TR*                 'E',                                                    
MFA-TR*                 :MV-DATE-MOVE,                                          
MFA-TR*                 :MV-LOCAL-OFFICE,                                       
MFA-TR*                 :MV-COMPANY-NO,                                         
MFA-TR*                 :MV-LOC-NO,                                             
MFA-TR*                 CURRENT TIMESTAMP,                                      
MFA-TR*                 :MV-CODE-CRNT-LOC )                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSMT658************'              
               DISPLAY '* 8660-INSERT-MOVEMENT-HIST     *'              
               DISPLAY '* ERROR INSERT CSS_MOVEMENT_HIST*'              
T22243         DISPLAY '* COMPANY NO IS   ', MV-COMPANY-NO              
               DISPLAY '* METER NUMBER IS ', MV-DEVICE-NO               
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...           *'              
               DISPLAY '*************PCSMT658************'              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8660-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8670-UPDATE-CRNT-LOC.                                            
           EXEC SQL                                                     
               UPDATE CSS_EQUIPMENT                                     
                SET DATE_LAST_MOVE  = IIF(TRY_CONVERT(DATE, 
                                                     :EQ-DATE-LAST-MOVE
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-MOVE
              ) <> 0) OR (LEN(:EQ-DATE-LAST-MOVE
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-MOVE
              ), CONVERT(DATE, :EQ-DATE-LAST-MOVE) )                
                   ,CODE_CRNT_LOC   = :EQ-CODE-CRNT-LOC                 
                   ,CRNT_LOC_NO     = :EQ-CRNT-LOC-NO                   
31683              ,UPGRADES_TX     = :EQ-UPGRADES-TX                   
               WHERE CODE_UTIL_TYPE = :WS-E                             
T22243           AND COMPANY_NO     = :EQ-COMPANY-NO                    
                 AND DEVICE_NO      = :EQ-DEVICE-NO                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_EQUIPMENT                                             
MFA-TR*         SET DATE_LAST_MOVE  = :EQ-DATE-LAST-MOVE                        
MFA-TR*            ,CODE_CRNT_LOC   = :EQ-CODE-CRNT-LOC                         
MFA-TR*            ,CRNT_LOC_NO     = :EQ-CRNT-LOC-NO                           
MFA-TR*            ,UPGRADES_TX     = :EQ-UPGRADES-TX                           
MFA-TR*        WHERE CODE_UTIL_TYPE = :WS-E                                     
MFA-TR*          AND COMPANY_NO     = :EQ-COMPANY-NO                            
MFA-TR*          AND DEVICE_NO      = :EQ-DEVICE-NO                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSMT658************'              
               DISPLAY '* 8670-UPDATE-CRNT-LOC          *'              
               DISPLAY '* ERROR UPDATING CSS_EQUIPMENT  *'              
               DISPLAY '* UTIL TYPE IS    ', WS-E                       
T22243         DISPLAY '* COMPANY NO IS   ', EQ-COMPANY-NO              
               DISPLAY '* METER NUMBER IS ', EQ-DEVICE-NO               
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...           *'              
               DISPLAY '*************PCSMT658************'              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8670-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T18007 8680-UPDATE-SERIAL-NO.                                           
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_EQUIPMENT                                     
                  SET SERIAL_NO  = :EQ-SERIAL-NO                        
                WHERE CODE_UTIL_TYPE = :WS-E                            
T22243            AND COMPANY_NO     = :EQ-COMPANY-NO                   
                  AND DEVICE_NO      = :EQ-DEVICE-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSMT658************'              
               DISPLAY '* 8680-UPDATE-SERIAL-NO         *'              
               DISPLAY '* ERROR UPDATING CSS_EQUIPMENT  *'              
               DISPLAY '* UTIL TYPE IS    ', WS-E                       
T22243         DISPLAY '* COMPANY NO IS   ', EQ-COMPANY-NO              
               DISPLAY '* METER NUMBER IS ', EQ-DEVICE-NO               
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...           *'              
               DISPLAY '*************PCSMT658************'              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8680-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T35434******************************************************************        
T35434*   8700-COMMIT-DB2-UPDATES                                      *        
T35434*        UPDATES TO DB2 ARE COMMITED FOR EVERY 100 RECORDS       *        
T35434*   PROCESSED.  ALSO, ONE LAST COMMIT IS DONE AT END OF INPUT    *        
T35434*   FILE FCSFA00.                                                *        
T35434******************************************************************        
T35434 8700-COMMIT-DB2-UPDATES.                                         
T35434*                                                                         
T35434     ADD 1                   TO WS-COMMITS-COUNT.                 
T35434     PERFORM 8710-UPDATE-RESTART-TABLE THRU 8710-EXIT.            
T35434     EXEC SQL                                                     
T35434         COMMIT                                                   
T35434     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35434     DISPLAY '*** COMMIT POINT # ' WS-COMMITS-COUNT ' TAKEN.'     
T35434             '  KEY OF LAST REC PROCESSED = ' E-FMT04-KEY         
T35434              ' ***'.                                             
T35434     MOVE ZEROES TO WS-RECS-TO-COMMIT-COUNT.                      
T35434*                                                                         
T35434 8700-EXIT.                                                       
T35434     EXIT.                                                        
T35434******************************************************************        
T35434*   8710-UPDATE-RESTART-TABLE                                    *        
T35434*        THE RESTART TABLE IS UPDATED WITH A ROW FOR PROGRAM     *        
T35434*   PCSMT658 WITH PERTINENT INFORMATION NEEDED REPOSITION INPUT  *        
T35434*   FILE AND REBUILD OUTPUT FILES IN CASE A RESTART IS NEEDED.   *        
T35434*   IF A ROW FOR PCSMT658 DOES NOT ALREADY EXIST IN CSS_RESTART, *        
T35434*   A ROW WILL BE INSERTED.  OTHERWISE, THE EXISTING ROW WILL BE *        
T35434*   UPDATED.  THERE WILL ONLY BE ON ROW IN CSS_RESTART AT ANY    *        
T35434*   GIVEN TIME.                                                  *        
T35434******************************************************************        
T35434 8710-UPDATE-RESTART-TABLE.                                       
T35434*                                                                         
T35434     MOVE 888                     TO WS-RESTRT-DATA-LEN.          
T35434     MOVE SPACES                  TO WS-RESTRT-DATA-REST.         
T35434     MOVE WS-NBR-METER-TEST-RECS  TO WS-RESTRT-VALID-IP-REC       
T35434                                     WS-RESTRT-MT04-CNTR.         
T35434     MOVE WS-NBR-GOOD-RECS        TO WS-RESTRT-GOOD-REC.          
T35434     MOVE WS-NBR-BAD-RECS         TO WS-RESTRT-BAD-REC.           
T35434     MOVE UTILITY-TYPE-PARM       TO WS-RESTRT-UTIL-TYP-PARM.     
T35434     MOVE WS-INPUT-DATE           TO WS-RESTRT-INPUT-DATE.        
T35434     MOVE WS-DB2-TODAYS-DATE      TO WS-RESTRT-PROGRAM-DATE.      
T35434     MOVE WS-BEGIN-DATE           TO WS-RESTRT-BEGIN-DATE.        
T35434     MOVE WS-END-DATE             TO WS-RESTRT-END-DATE.          
T35434     MOVE WS-COMMITS-COUNT        TO WS-RESTRT-COMMITS-COUNT.     
T35434     MOVE E-FMT04-METER-NO        TO WS-RESTRT-E-MT04R-KEY.       
T35434     MOVE WS-RESTART-DATA         TO RF-RESTART-DATA.             
T35434     MOVE 'PCSMT658'              TO RF-NAME-PROGRAM.             
T35434     MOVE 1                       TO RF-PARTITION-NO.             
T35434     MOVE 1                       TO RF-DUP-CNTRL-NO.             
T35434*                                                                         
T35434     EXEC SQL                                                     
T35434         UPDATE CSS_RESTART                                       
T35434            SET RESTART_DATA = :RF-RESTART-DATA                   
T35434          WHERE NAME_PROGRAM = :RF-NAME-PROGRAM AND               
T35434                PARTITION_NO = :RF-PARTITION-NO AND               
T35434                DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
T35434     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35434*                                                                         
T35434     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T35434     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T35434         NEXT SENTENCE                                            
T35434     ELSE                                                         
T35434         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
T35434             PERFORM 8720-INSERT-RESTART-TABLE  THRU 8720-EXIT    
T35434         ELSE                                                     
T35434             DISPLAY '**  PROCESSING ERROR IN PGM PCSMT658  **'   
T35434             DISPLAY '** PARA -  8710-UPDATE-RESTART-TABLE  **'   
T35434             DISPLAY '**      ERROR DURING UPDATE FOR       **'   
T35434             DISPLAY '**             CSS_RESTART            **'   
T35434             DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE            
T35434             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.           
T35434*                                                                         
T35434 8710-EXIT.                                                       
T35434     EXIT.                                                        
T35434******************************************************************        
T35434*   8720-INSERT-RESTART-TABLE                                    *        
T35434*        IF A ROW DOES NOT EXIST IN CSS_RESTART FOR PCSMT658,    *        
T35434*   ONE IS ADDED.                                                *        
T35434******************************************************************        
T35434 8720-INSERT-RESTART-TABLE.                                       
T35434*                                                                         
T35434     EXEC SQL                                                     
T35434         INSERT INTO CSS_RESTART                                  
T35434              (NAME_PROGRAM,                                      
T35434               PARTITION_NO,                                      
T35434               DUP_CNTRL_NO,                                      
T35434               RESTART_DATA)                                      
T35434         VALUES                                                   
T35434              (:RF-NAME-PROGRAM,                                  
T35434               :RF-PARTITION-NO,                                  
T35434               :RF-DUP-CNTRL-NO,                                  
T35434               :RF-RESTART-DATA)                                  
T35434     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35434*                                                                         
T35434     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T35434     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T35434         NEXT SENTENCE                                            
T35434     ELSE                                                         
T35434         DISPLAY '**  PROCESSING ERROR IN PGM PCSMT658  **'       
T35434         DISPLAY '** PARA -  8720-INSERT-RESTART-TABLE  **'       
T35434         DISPLAY '**      ERROR DURING INSERT FOR       **'       
T35434         DISPLAY '**             CSS_RESTART            **'       
T35434         DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                
T35434         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
T35434*                                                                         
T35434 8720-EXIT.                                                       
T35434     EXIT.                                                        
T35434*                                                                         
C36856****************************************************************          
C36856**                                                            **          
C36856**   8800-CREATE-MOVE-HIST.                                   **          
C36856**       TO INSERT A NEW RECORD IN CSS_EQUIP_ATTCH_MOVE       **          
C36856**                                                            **          
C36856****************************************************************          
C36856*                                                                         
C36856 8800-CREATE-MOVE-HIST.                                           
C36856*                                                                         
C36856     EXEC SQL                                                     
C36856         INSERT INTO                                              
C36856             CSS_EQUIP_ATT_MOVE                                   
C36856             ( CODE_ATT_TYPE,                                     
C36856               CODE_UTIL_TYPE,                                    
C36856               COMPANY_NO,                                        
C36856               DATE_MOVE,                                         
C36856               DEVICE_NO,                                         
C36856               EQUIP_LOC_ID,                                      
C36856               METER_NO,                                          
C36856               MOVE_NO,                                           
C36856               MTR_STORAGE_FAC_CD)                                
C36856             VALUES                                               
C36856             ( :MP-CODE-ATT-TYPE,                                 
C36856               :MP-CODE-UTIL-TYPE,                                
C36856               :MP-COMPANY-NO,                                    
C36856               IIF(TRY_CONVERT(DATE, :MP-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MP-DATE-MOVE
              ) <> 0) OR (LEN(:MP-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MP-DATE-MOVE
              ), CONVERT(DATE, :MP-DATE-MOVE) ),                               
C36856               :MP-DEVICE-NO,                                     
C36856               :MP-EQUIP-LOC-ID,                                  
C36856               :MP-METER-NO,                                      
C36856               CIS.CURRENT$TIMESTAMP(),                                 
C36856               :MP-MTR-STORAGE-FAC-CD)                            
C36856     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO                                                      
MFA-TR*            CSS_EQUIP_ATT_MOVE                                           
MFA-TR*            ( CODE_ATT_TYPE,                                             
MFA-TR*              CODE_UTIL_TYPE,                                            
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              DATE_MOVE,                                                 
MFA-TR*              DEVICE_NO,                                                 
MFA-TR*              EQUIP_LOC_ID,                                              
MFA-TR*              METER_NO,                                                  
MFA-TR*              MOVE_NO,                                                   
MFA-TR*              MTR_STORAGE_FAC_CD)                                        
MFA-TR*            VALUES                                                       
MFA-TR*            ( :MP-CODE-ATT-TYPE,                                         
MFA-TR*              :MP-CODE-UTIL-TYPE,                                        
MFA-TR*              :MP-COMPANY-NO,                                            
MFA-TR*              :MP-DATE-MOVE,                                             
MFA-TR*              :MP-DEVICE-NO,                                             
MFA-TR*              :MP-EQUIP-LOC-ID,                                          
MFA-TR*              :MP-METER-NO,                                              
MFA-TR*              CURRENT TIMESTAMP,                                         
MFA-TR*              :MP-MTR-STORAGE-FAC-CD)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36856*                                                                         
C36856     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
C36856*                                                                         
C36856     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C36856         NEXT SENTENCE                                            
C36856     ELSE                                                         
C36856         DISPLAY '** INSERT ERROR IN 8800-CREATE-MOVE-HIST**'     
C36856         DISPLAY '**     TABLE :  CSS_EQUIP_ATT_MOVE      **'     
C36856         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C36856         DISPLAY '**       PROCESSING TERMINATED        **'       
C36856         DISPLAY ' MP-CODE-ATT-TYPE ' MP-CODE-ATT-TYPE            
C36856         DISPLAY ' MP-CODE-UTIL-TYPE   ' MP-CODE-UTIL-TYPE        
C36856         DISPLAY ' MP-COMPANY-NO       ' MP-COMPANY-NO            
C36856         DISPLAY ' MP-DEVICE-NO        ' MP-DEVICE-NO             
C36856         DISPLAY ' MP-EQUIP_LOC_ID     ' MP-EQUIP-LOC-ID          
C36856         DISPLAY ' MP-METER-NO         ' MP-METER-NO              
C36856         DISPLAY ' MP-MTR-STORAGE-FAC-CD ' MP-MTR-STORAGE-FAC-CD  
C36856         PERFORM 9900-ABEND         THRU 9900-EXIT                
C36856     END-IF.                                                      
C36856*                                                                         
C36856 8800-EXIT.                                                       
C36856     EXIT.                                                        
C36856*                                                                         
C36856****************************************************************          
C36856**                                                            **          
C36856**   8810-UPDATE-ATTCHMTS.                                    **          
C36856**       TO UPDATE CURRENT CODE IN CSS_EQUIP_ATTCHMTS TABLE   **          
C36856**                                                            **          
C36856****************************************************************          
C36856*                                                                         
C36856 8810-UPDATE-ATTCHMTS.                                            
C36856*                                                                         
C36856     EXEC SQL                                                     
C36856         UPDATE CSS_EQUIP_ATTCHMTS                                
C36856             SET   EQUIP_LOC_ID        = :LX-EQUIP-LOC-ID         
C36856                  ,DATE_LAST_MOVE      = IIF(TRY_CONVERT(DATE, 
                                                     :LX-DATE-LAST-MOVE
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-MOVE
              ) <> 0) OR (LEN(:LX-DATE-LAST-MOVE
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-MOVE
              ), CONVERT(DATE, :LX-DATE-LAST-MOVE) )       
C36856                  ,DATE_DISPOSED_OF    = IIF(TRY_CONVERT(DATE, 
                                                   :LX-DATE-DISPOSED-OF
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-DISPOSED-OF
              ) <> 0) OR (LEN(:LX-DATE-DISPOSED-OF
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-DISPOSED-OF
              ), CONVERT(DATE, :LX-DATE-DISPOSED-OF) )     
C36856             WHERE CODE_UTIL_TYPE      = :LX-CODE-UTIL-TYPE       
C36856             AND   COMPANY_NO          = :LX-COMPANY-NO           
C36856             AND   DEVICE_NO           = :LX-DEVICE-NO            
C36856     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_EQUIP_ATTCHMTS                                        
MFA-TR*            SET   EQUIP_LOC_ID        = :LX-EQUIP-LOC-ID                 
MFA-TR*                 ,DATE_LAST_MOVE      = :LX-DATE-LAST-MOVE               
MFA-TR*                 ,DATE_DISPOSED_OF    = :LX-DATE-DISPOSED-OF             
MFA-TR*            WHERE CODE_UTIL_TYPE      = :LX-CODE-UTIL-TYPE               
MFA-TR*            AND   COMPANY_NO          = :LX-COMPANY-NO                   
MFA-TR*            AND   DEVICE_NO           = :LX-DEVICE-NO                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36856*                                                                         
C36856     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
C36856*                                                                         
C36856     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C36856         NEXT SENTENCE                                            
C36856     ELSE                                                         
C36856         DISPLAY '**  UPDATE ERROR IN 8810-UPDATE-ATTCHMTS**'     
C36856         DISPLAY '**     TABLE :  CSS_EQUIP_ATTCHMTS      **'     
C36856         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C36856         DISPLAY '** COMPANY NO  = ' LX-COMPANY-NO                
C36856         DISPLAY '** EQUIP-LOC-ID     = ' LX-EQUIP-LOC-ID,        
C36856         DISPLAY '** DATE-LAST-MOVE   = ' LX-DATE-LAST-MOVE       
C36856         DISPLAY '** DATE-DISPOSED-OF = ' LX-DATE-DISPOSED-OF     
C36856         DISPLAY '** CODE-UTIL-TYPE   = ' LX-CODE-UTIL-TYPE       
C36856         DISPLAY '** DEVICE-NO        = ' LX-DEVICE-NO            
C36856         DISPLAY '**       PROCESSING TERMINATED        **'       
C36856         PERFORM 9900-ABEND         THRU 9900-EXIT                
C36856     END-IF.                                                      
C36856*                                                                         
C36856 8810-EXIT.                                                       
C36856     EXIT.                                                        
C36856*                                                                         
TP4597*****************************************************************         
TP4597** INSERTS A RECORD INTO THE WORK QUEUE WHEN ACCURACY VARIATION**         
TP4597** EXCEEDS 2%                                                  **         
T15879**    PARAGRAPH 8895-INSERT-WORK-QUEUE                         **         
TP4597*****************************************************************         
A04860*                                                                         
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860*                                                                         
A04860     CALL SCSCB077 USING CWS00077-FIELDS,                         
A04860                         ABEND-FILE,                              
A04860                         RS-RETURN-CODE                           
A04860     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     END-IF.                                                      
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
      *                                                                         
       8900-PRODUCE-SUMMARY-REPORTS.                                    
      *                                                                         
      *    IF NO-ERRORS                                                         
      *       WRITE ERROR-RECORD FROM WS-NO-ERROR-LINE                          
      *    END-IF.                                                              
      *                                                                         
T19333     IF  (57 - WS-LINE-COUNT) < 5                                 
               ADD  1             TO WS-PAGE-COUNT                      
               MOVE WS-PAGE-COUNT TO WS-TITLE3-PAGE-COUNT               
               WRITE PRT33-RECORD FROM WS-TITLE-1 AFTER NEW-PAGE        
               WRITE PRT33-RECORD FROM WS-TITLE-2 AFTER 1               
               WRITE PRT33-RECORD FROM WS-TITLE-3 AFTER 1               
               WRITE PRT33-RECORD FROM WS-TITLE-4 AFTER 1               
               WRITE PRT33-RECORD FROM WS-TITLE-5 AFTER 1               
               WRITE PRT33-RECORD FROM WS-TITLE-6 AFTER 1               
               MOVE 5             TO WS-LINE-COUNT                      
           END-IF.                                                      
           IF NOT ERROR-FOUND                                           
              WRITE PRT33-RECORD FROM WS-NO-ERROR-LINE AFTER 2          
              ADD +2 TO WS-LINE-COUNT                                   
           END-IF.                                                      
           MOVE WS-TOT-RECDS-INFO      TO WS-RPT-MESSAGE.               
           MOVE WS-NBR-METER-TEST-RECS TO WS-RPT-STATISTICS.            
           WRITE PRT33-RECORD FROM WS-DET-LINE-2 AFTER 2.               
           ADD +2 TO WS-LINE-COUNT.                                     
           MOVE WS-TOT-GOOD-RECDS      TO WS-RPT-MESSAGE.               
           MOVE WS-NBR-GOOD-RECS       TO WS-RPT-STATISTICS.            
           WRITE PRT33-RECORD FROM WS-DET-LINE-2 AFTER 1.               
           ADD +1 TO WS-LINE-COUNT.                                     
           MOVE WS-TOT-BAD-RECDS       TO WS-RPT-MESSAGE.               
           MOVE WS-NBR-BAD-RECS        TO WS-RPT-STATISTICS.            
           WRITE PRT33-RECORD FROM WS-DET-LINE-2 AFTER 1.               
           ADD +1 TO WS-LINE-COUNT.                                     
           WRITE PRT33-RECORD FROM WS-END-OF-DATA  AFTER 2.             
T19333     ADD +2 TO WS-LINE-COUNT.                                     
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9000-TERMINATE.                                                  
TP4597     CLOSE FCSMT04-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T15090     COPY CPD0023B.                                                       
      *                                                                         
      ****************************************************************          
      * THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE                *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD09900                                                
           END-EXEC.                                                            
      *                                                                         
