       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSMT657.                                        
       DATE-WRITTEN.   AUG 1997.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              PROGRAM  MODIFICATION  LOG                     ** 00120000
      **                                                             ** 00130000
      **           DATE    INITIALS       REASON                     ** 00140000
      **         ________  ________   ______________                 ** 00150000
      **                                                             ** 00150000
      **         08/98     CBSI      POPULATING THE VALUES OF LOCAL- ** 00150000
      **                   MADRAS    OFFICE, CUSTOMER-NO AND PREMISE-** 00150000
      **                             NO IN THE WORK QUEUE TABLE      ** 00150000
      **                                                             ** 00150000
      **         09/98     CBSI      RETIRE A METER WHEN CODE-RAPAIR ** 00150000
      **                             IS NOT ALPHABETIC.              ** 00150000
      **                                                             **         
      **         06/99     CBSI      CHANGES MADE TO USE CPD00099    **         
      **                   MADRAS    COPYBOOK FOR GETTING THE MOST   **         
      **                             CURRENT ACCOUNT AT THE PREMISE. **         
T22243**         11/00     CBSI      MULTI-COMPANY CHANGES           **         
T22243**                   MADRAS                                    **         
      **                                                             ** 00150000
T71907**  19 JUL 2007      RC41079   ADDED CODE-UTIL-TYPE AND        **         
T71907**                             COMPANY-NO TO WHERE CLAUSE FOR  **         
T71907**                             CSS_EQUIP_TST_REPR.             **         
A01209**  25 SEP 2009      MC95456   METER INVENTORY WILL BE SET TO  **         
A01209**                             AUTOMATICALLY DIVORCE ATTACHMENTS*         
A01209**                             TO A - INVENTORY UPON THE METER **         
A01209**                             MOVING TO  I - RETIRED.THIS RET **         
A01209**                             IRING PROCESS IS CHANGED FOR    **         
A01209**                             PSNC ALONE WITH NO UDATES FOR   **         
A01209**                             CSS_GAS_METER_TEST NOT HAPPENING**         
A01209**                             WHEN TEST GROUP NOT FOUND.      **         
      **                                                             **         
A04527**  22 AUG 2013      RF10596   ALLOW COMPANY-NO '01' TO DELETE **         
A04527**                             METER ATTACHMENTS               **         
      **                                                             **         
A04860**  06 JAN 2014      MR7E794   LOAD DIRECTLY CSS_WQ_ITEMS      **         
A04860**                   ACT014    INSTEAD OF CSS_WQ_ITEMS_MF BY   **         
A04860**                             CALLING SUB PROGRAM SCSCB077    **         
      *****************************************************************         
           REMARKS.                                                     
                              PCSMT657 NARRATIVE                        
                          GAS METER BATCH DATA UPDATE                   
      *                                                                         
                 THIS PROGRAM READS THE METER TESTING RESULTS FILE      
                 AND UPDATES THE EQUIPMENT TABLE AND THE APPROPRIATE    
                 TEST TABLE FOR THE METER TYPE.                         
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9900 - 9999     ABEND/ABORT MODULES                     
                                                                        
       ENVIRONMENT DIVISION.                                            
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
                                                                        
           SELECT METER-TEST-FILE ASSIGN TO UT-S-FCSMT03I.              
           SELECT CNTL-FILE       ASSIGN TO UT-S-FCSMT05O.              
           SELECT PRINTER1        ASSIGN UT-S-PRINTER1.                 
        COPY CSSMT652.                                                          
      **************************************************************            
      *  CSSMT652  -  SELECT STATEMENT FOR FILE FCSMT652         *              
      **************************************************************            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  METER-TEST-FILE                                              
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
      *01  METER-TEST-REC                PIC X(160).                            
       01  METER-TEST-REC.                                              
           03  FILLER                   PIC X(117).                     
           03  METER-TEST-LO            PIC X(02).                      
           03  FILLER                   PIC X(41).                      
                                                                        
       FD  CNTL-FILE                                                    
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       01  CNTL-RECORD.                                                 
           05  CNTL-METER-NO            PIC X(09).                      
           05                           PIC X(01).                      
           05  CNTL-TEST-DATE           PIC X(10).                      
           05                           PIC X(01).                      
           05  CNTL-IN-TEST-METERS      PIC 9(05).                      
           05                           PIC X(01).                      
           05  CNTL-GOOD-TEST-METERS    PIC 9(05).                      
           05                           PIC X(01).                      
           05  CNTL-BAD-TEST-METERS     PIC 9(05).                      
           05                           PIC X(12).                      
                                                                        
       FD  PRINTER1                                                     
           LABEL RECORDS ARE STANDARD.                                  
       01  PRINT-LINE                  PIC X(133).                      
                                                                        
      ******************************************************************        
      * CFDMT652 - FILE DESC FOR FCSMT652                              *        
      ******************************************************************        
        COPY CFDMT652.                                                          
                                                                        
      ******************************************************************        
      * FIOMT652 - FILE DESCRIPTION FOR INPUT FILE FCSMT652.                    
      ******************************************************************        
        COPY FIOMT652.                                                          
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSMT657'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                      PIC X(40) VALUE                
           'WORKING STORAGE FOR PCSMT657 STARTS HERE'.                  
      *                                                                         
       01  PROGRAM-NAME                  PIC X(08) VALUE 'PCSMT657'.    
A04860 01  SCSCB077                      PIC X(08) VALUE 'SCSCB077'.    
      *                                                                         
      *****************************************************************         
      *  THIS COPYBOOK IS USED FOR DB2 AND CICS ERROR PROCESSING.     *         
      *   NOTE:                                                       *         
      *         WHEN MODIFYING THIS MEMBER, MEMBER CPD0303B SHOULD    *         
      *         BE EVALUATED FOR CORRESPONDING MODIFICATIONS.         *         
      *****************************************************************         
       COPY CWS00303.                                                           
      *                                                                 00110000
      *****************************************************************         
      *         CWS00010   WS ABEND WORK AREA                         *         
      *****************************************************************         
       COPY CWS00010.                                                           
      *                                                                         
      ******************************************************************00010000
      *THIS WS COPY STATEMENT IS USED TO RETAIN DATE PARAMETERS AND    *00080000
      *DATE FIELDS USED FOR EDITING                                    *00090000
      ******************************************************************00100000
       COPY CWS00026.                                                           
      *                                                                 00110000
      *****************************************************************         
      *  THIS COPYBOOK IS USED WITH THE CPD09900 INCLUDE MEMBER       *         
      *  WHICH INVOKES THE ABEND ROUTINE                              *         
      *****************************************************************         
       COPY CWS09900.                                                           
      *                                                                         
      ******************************************************************        
      * FIOMT03 - IO AREA FOR THE GAS METER TEST PC EXTRACT FILE       *        
      ******************************************************************        
       COPY FIOMT03.                                                            
      ******************************************************************        
      * WORKING STORAGE FOR CPD00099                                   *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
       01  WS-WORK-AREA.                                                
A04527     05  WS-SAVE-COMPANY             PIC XX VALUE SPACES.         
           05  WS-SQLCODE-TEMP             PIC S9(9) VALUE +000 COMP.   
           05  WS-DISPLAY-RC               PIC -ZZZZZZZZ9.9.            
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSMT657'.  
A04860     05  RS-RETURN-CODE              PIC S9(09) COMP VALUE +0.    
A04860     05  WS-ITEM-ID                  PIC S9(10)V COMP-3 VALUE +0. 
           05  COUNTERS.                                                
               10  WS-NBR-METER-TEST-RECS  PIC 9(5)        VALUE 0.     
               10  WS-NBR-GOOD-RECS        PIC 9(5)        VALUE 0.     
               10  WS-NBR-BAD-RECS         PIC 9(5)        VALUE 0.     
           05  WS-FMT652-STATUS        PIC X(02).                       
               88  FMT652-SUCCESSFUL                VALUE '00'.         
           05  WS-FMT652-REC-CNTR          PIC 9(09).                   
A01209     05  WS-LX-EQUIP-ATTACH-DT-NULL  PIC S9(04) COMP VALUE ZEROES.
A01209     05  WS-LX-MTR-STOR-FAC-CD-NULL  PIC S9(04) COMP VALUE ZEROES.
A01209     05  WS-LX-DATE-LAST-MOVE-NULL   PIC S9(04) COMP VALUE ZEROES.
           05  WS-DATE-LAST-MOVE-NULL      PIC S9(04) COMP VALUE ZEROES.
               88  DATE-LAST-MOVE-NULL     VALUE -1.                    
           05  WS-DATE-PURCHASED-NULL      PIC S9(04) COMP VALUE ZEROES.
               88  DATE-PURCHASED-NULL     VALUE -1.                    
           05  WS-LAST-TEST-SEL-DATE-NULL  PIC S9(04) COMP VALUE ZEROES.
               88  LAST-TEST-SEL-DT-NULL   VALUE -1.                    
           05  WS-DATE-LAST-TEST-NULL      PIC S9(04) COMP VALUE ZEROES.
               88  DATE-LAST-TEST-NULL     VALUE -1.                    
           05  WS-STATUS-CD-NULL           PIC S9(04) COMP VALUE ZEROES.
               88  STATUS-CD-NULL          VALUE -1.                    
           05  WS-ACCT-FINALED-DT-NULL     PIC S9(04) COMP VALUE ZEROES.
               88  ACCT-FINALED-DT-NULL    VALUE -1.                    
           05  WS-ACCT-CREATE-DT-NULL      PIC S9(04) COMP VALUE ZEROES.
               88  ACCT-CREATE-DT-NULL     VALUE -1.                    
           05  WS-INSTALL-DT-NULL          PIC S9(04) COMP VALUE +0.    
           05  WS-LOC-NO-NULL              PIC S9(04) COMP VALUE +0.    
           05  WS-CODE-TIME-PERIOD         PIC S9(4)  COMP.             
               88  VALID-CODE-TIME-PERIOD        VALUES 0.              
           05  WS-GAS-CAP-TYPE             PIC X(1).                    
               88  VALID-GAS-CAP-TYPE            VALUES 'A', 'B'.       
           05  WS-CODE-REPAIR              PIC X(1).                    
           05  WS-CODE-TEST-TYPE           PIC X.                       
           05  WS-CODE-TEST-LOC            PIC X.                       
           05  WS-CODE-TEST-RESULT         PIC X.                       
               88  VALID-CODE-TEST-RESULT       VALUES 'B'.             
           05  FLAGS.                                                   
               10  WS-EOF-FLAG             PIC X(01) VALUE 'N'.         
                   88  END-OF-FILE                   VALUE 'Y'.         
               10  WS-IS-INPUT-VALID       PIC X(01) VALUE 'Y'.         
                   88  INPUT-IS-VALID                VALUE 'Y'.         
                   88  INPUT-IS-INVALID              VALUE 'N'.         
               10  WS-MASTER-ERROR-FLAG    PIC X(01) VALUE 'N'.         
                   88  NO-ERRORS                     VALUE 'N'.         
               10  WS-READ-FLAG            PIC X(01) VALUE 'Y'.         
                   88  FIRST-READ                    VALUE 'Y'.         
               10  WS-AMR-ERT-FLAG         PIC X(01) VALUE 'N'.         
                   88  AMR-ERT                       VALUE 'Y'.         
               10  WS-TEST-GROUP-FOUND     PIC X(01) VALUE 'Y'.         
                   88  TEST-GROUP-NOT-FOUND          VALUE 'N'.         
           05  WS-ACCURACY-PCT             PIC S9(03)V9(02) VALUE +0.   
           05  WS-ACCURACY-PCTX            PIC -ZZZ.ZZ.                 
           05  WS-TEMP-CC                  PIC 99.                      
           05  WS-MTR-CAP-TIME-PERIOD.                                  
               10  WS-MTR-CAP-TYPE         PIC X(01).                   
               10  WS-TIME-PERIOD          PIC ------9.                 
           05  WS-SYS-DATE.                                             
               10  WS-SYS-DATE-YY          PIC 9(02).                   
               10  WS-SYS-DATE-MM          PIC 9(02).                   
               10  WS-SYS-DATE-DD          PIC 9(02).                   
           05  WS-DB2-TODAYS-DATE          PIC X(10).                   
           05  WS-DATE-OF-TEST             PIC X(10).                   
           05  WS-DATE-PURCHASED           PIC X(10).                   
           05  WS-NUM-EDIT                 PIC 9(09)V9999 VALUE ZEROES. 
           05  WS-NUM-EDIT-R REDEFINES                                  
               WS-NUM-EDIT.                                             
               10  WS-NUM-INTEGER          PIC 9(9).                    
               10  WS-NUM-DECIMAL          PIC 9(4).                    
           05  UTILITY-TYPE-PARM           PIC X(01).                   
T22243     05  WS-SYSIN-COMP-NO            PIC X(02) VALUE SPACES.      
       01  WS-LITERALS.                                                 
T22243     05  WS-ONE                  PIC X(02) VALUE '01'.            
           05  WS-D                    PIC X(01) VALUE 'D'.             
           05  WS-F                    PIC X(01) VALUE 'F'.             
           05  WS-G                    PIC X(01) VALUE 'G'.             
           05  WS-J                    PIC X(01) VALUE 'J'.             
           05  WS-K                    PIC X(01) VALUE 'K'.             
           05  WS-N                    PIC X(01) VALUE 'N'.             
           05  WS-R                    PIC X(01) VALUE 'R'.             
           05  WS-Y                    PIC X(01) VALUE 'Y'.             
      *                                                                         
       01  WS-NO-EMPL-ID                 PIC S9(4) COMP.                
       01  WS-INPUT.                                                    
           10  WS-INPUT-TYPE             PIC X(1).                      
           10  WS-INPUT-ID               PIC X(5).                      
           10  WS-INPUT-IDS    REDEFINES WS-INPUT-ID.                   
               15  WS-INPUT-IDA          PIC X(1) OCCURS 5 TIMES.       
           10  WS-INPUT-ID9S.                                           
               15 WS-INPUT-IDB           PIC X(1) OCCURS 5 TIMES        
                                         VALUE SPACES.                  
           10  WS-INPUT-ID9    REDEFINES WS-INPUT-ID9S                  
                                         PIC X(5).                      
           10  WS-INPUT-RC               PIC 9(1).                      
      *                                                                         
       01  WS-WQ-ERROR-MESSAGES.                                        
           05 WS-FAST-SLOW-METER         PIC X(55) VALUE                
              'THE GAS METER HAS FAILED THE 2% HI/LO TEST - PERCENT = '.
           05 WS-FAST-METER              PIC X(14) VALUE                
              '  METER NBR = '.                                         
           05 WS-TEST-INSTALLED          PIC X(55) VALUE                
              ' METER NBR IS INSTALLED ON SYSTEM AND BEING TESTED     '.
      *                                                                 01350000
       01  WS-WQ-COMMENTS.                                              
           05  WS-WQ-COMMENTS-LEN          PIC S9(4)  COMP VALUE +0.    
           05  WS-WQ-COMMENTS-TEXT         PIC X(250) VALUE SPACES.     
      *                                                                         
       01  ERROR-REPORT-FIELDS.                                         
           05  WS-WQ-ERROR-TEXT           PIC X(90).                    
           05  WS-WQ-ERROR-TEXT-SPLIT REDEFINES WS-WQ-ERROR-TEXT.       
               10  WS-WQ-ERROR-FIELD      PIC X(20).                    
               10                         PIC X(02).                    
               10  WS-WQ-ERROR-MESSAGE    PIC X(68).                    
           05  E-ERROR-SW              PIC X(01)     VALUE 'N'.         
               88  ERRORS-FOUND                      VALUE 'Y'.         
               88  NO-ERRORS-FOUND                   VALUE 'N'.         
           05  NEW-PAGE-SW             PIC X(01)     VALUE 'N'.         
               88  PRINT-NEW-PAGE                    VALUE 'Y'.         
           05 PAGE-COUNT                 PIC 9(02)  VALUE ZERO.         
           05 AFTER-NUM                  PIC 9(02)  VALUE ZERO.         
           05 LINE-COUNT                 PIC S9(02) VALUE +90.          
      *                                                                         
       01  ERROR-HOLD-AREA.                                             
           05  ERR-UTIL-TYPE           PIC X(01).                       
           05  ERR-METER-NBR           PIC X(09).                       
           05  ERR-FIELD               PIC X(20).                       
           05  ERR-FIELD-R REDEFINES ERR-FIELD.                         
               10                          PIC X(05).                   
               10  ERR-FIELD-N             PIC 9(10).9999.              
           05  ERR-PROBLEM             PIC X(48).                       
           05  ERR-CLASS-CD            PIC X(02) VALUE SPACES.          
           05  ERR-SPEC-CD             PIC X(03) VALUE SPACES.          
                                                                        
       01  E-HEAD-1.                                                    
           03  FILLER              PIC X(01) VALUE SPACES.              
           03  FILLER              PIC X(12) VALUE 'PCSMT657-01'.       
           03  FILLER              PIC X(12) VALUE SPACES.              
           03  E-DATE              PIC X(10) VALUE SPACES.              
           03  FILLER              PIC X(12) VALUE SPACES.              
T22243     03  WS-COMPANY-NAME     PIC X(60) VALUE SPACES.              
           03  FILLER              PIC X(16) VALUE SPACES.              
           03  FILLER              PIC X(4)  VALUE 'PAGE'.              
           03  E-PAGE-COUNT        PIC Z(6).                            
       01  E-HEAD-2.                                                    
           03  FILLER        PIC X(01) VALUE SPACES.                    
           03  FILLER        PIC X(48) VALUE SPACES.                    
           03  FILLER PIC X(30) VALUE 'GAS METER TEST POSTING ERROR R'. 
           03  FILLER PIC X(30) VALUE 'EPORT                         '. 
           03  FILLER        PIC X(23) VALUE SPACES.                    
       01  E-HEAD-3.                                                    
           03  FILLER           PIC X(01) VALUE SPACES.                 
           03  FILLER           PIC X(10) VALUE 'MTR NBR   '.           
           03  FILLER           PIC X(08) VALUE '   L/O  '.             
           03  FILLER           PIC X(20) VALUE '   DATE TEST        '. 
           03  FILLER           PIC X(30) VALUE                         
                                      '        ERROR MESSAGE         '. 
           03  FILLER           PIC X(64) VALUE SPACES.                 
       01  E-DETAIL-1.                                                  
           03  FILLER           PIC X(01) VALUE SPACES.                 
           03  E-METER-NBR      PIC X(09).                              
           03  FILLER           PIC X(05) VALUE SPACES.                 
           03  E-LOCAL-OFFICE   PIC X(02).                              
           03  FILLER           PIC X(05) VALUE SPACES.                 
           03  E-DATE-TEST      PIC X(10).                              
           03  FILLER           PIC X(05) VALUE SPACES.                 
           03  E-ERROR-MESSAGE  PIC X(90).                              
           03  FILLER           PIC X(05) VALUE SPACES.                 
       01  E-NO-REPORT-LINE.                                            
           03  FILLER PIC X(25) VALUE SPACES.                           
           03  FILLER PIC X(45) VALUE                                   
              '********************  THERE ARE NO ERRORS FOR'.          
           03  FILLER PIC X(36) VALUE                                   
                  ' THE REPORT TODAY  *****************'.               
           03  FILLER PIC X(27) VALUE SPACES.                           
                                                                        
       01  WS-NO-ERROR-LINE.                                            
           05                              PIC X(30) VALUE              
           'PCSMT657  NO ERRORS WERE FOUND'.                            
           05                              PIC X(50) VALUE SPACES.      
                                                                        
      ******************************************************************00051000
      * MISCELLANEOUS WORKING STORAGE FIELDS                           *00052000
      ******************************************************************00059400
       COPY CWS00038.                                                           
      *                                                                         
       01 WS-PARAMETER-DATA REDEFINES WS-INPUT-DATA-BREAKDOWN.          
          05  WS-PARAMETER-NAME          PIC X(11).                     
              88  UTIL-TYPE-DATA  VALUE 'UTIL TYPE ='.                  
          05  WS-PARAMETER-VALUE         PIC X(02).                     
          05  FILLER REDEFINES WS-PARAMETER-VALUE.                      
              10  UTILITY-TYPE-VALUE     PIC X(01).                     
              10                         PIC X(01).                     
      *                                                                         
      *****************************************************************         
      **  THIS COPY STATEMENT CONTAINS THE WORKING STORAGE TABLE     **         
      **  LAYOUT FOR USE WITH CPD00104 AND CPD00105 WHICH WILL       **         
      **  ACCUMULATE RECORD COUNTS FOR EACH COMPANY IN A TABLE.      **         
      **  AND WRITE THE COMPANY RECORDS.                             **         
      *****************************************************************         
       COPY CWS00104.                                                           
A04860******************************************************************        
A04860* WORKING STORAGE COPYBOOK FOR SCSCB077                          *        
A04860******************************************************************        
A04860**                                                                        
A04860     EXEC SQL                                                             
A04860        INCLUDE CWS00077                                                  
A04860     END-EXEC.                                                            
A04860**                                                                        
      *****************************************************************         
      **      INCLUDE DLCGEN TABLE AND HOST VARIABLE DEFINTIONS      **         
      *****************************************************************         
      **                                                                        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      **                                                                        
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      **                                                                        
           EXEC SQL                                                             
               INCLUDE TBEQTTYP                                                 
           END-EXEC.                                                            
      **                                                                        
           EXEC SQL                                                             
               INCLUDE TBEQTRPR                                                 
           END-EXEC.                                                            
      **                                                                        
           EXEC SQL                                                             
               INCLUDE TBEQTLOC                                                 
           END-EXEC.                                                            
      **                                                                        
           EXEC SQL                                                             
               INCLUDE TBGASMTR                                                 
           END-EXEC.                                                            
      **                                                                        
           EXEC SQL                                                             
               INCLUDE TBGASGRP                                                 
           END-EXEC.                                                            
      **                                                                        
           EXEC SQL                                                             
               INCLUDE TBGMTEST                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRCAP                                                 
           END-EXEC.                                                            
      **                                                                        
           EXEC SQL                                                     02940328
               INCLUDE TBMTRTST                                         02940428
           END-EXEC.                                                    02941028
      *                                                                 02941128
           EXEC SQL                                                     02941328
               INCLUDE TBACCT                                           02941428
           END-EXEC.                                                    02942028
      *                                                                         
           EXEC SQL                                                     02941328
               INCLUDE TBMVHIST                                         02941428
           END-EXEC.                                                    02942028
      *                                                                         
T22243     EXEC SQL                                                             
T22243         INCLUDE TBCOMPNY                                                 
T22243     END-EXEC.                                                            
      *                                                                         
A01209****************************************************************          
A01209*    CSS_METER_ATTCHMTS                                        *          
A01209****************************************************************          
A01209*                                                                         
A01209     EXEC SQL                                                             
A01209         INCLUDE TBMTRATT                                                 
A01209     END-EXEC.                                                            
A01209*                                                                         
A01209******************************************************************        
A01209* CSS_MTR_ATT_TYPE (N5)                                      *            
A01209******************************************************************        
A01209     EXEC SQL                                                             
A01209         INCLUDE TBMTRATP                                                 
A01209     END-EXEC.                                                            
A01209*                                                                         
A01209                                                                  
A01209******************************************************************        
A01209* CSS_EQUIP_ATT_MOVE (MP)                                    *            
A01209******************************************************************        
A01209     EXEC SQL                                                             
A01209         INCLUDE TBEQMOVE                                                 
A01209     END-EXEC.                                                            
A01209*                                                                         
A01209                                                                  
A01209******************************************************************        
A01209* CSS_EQUIP_ATTCHMTS  (LX)                                   *            
A01209******************************************************************        
A01209     EXEC SQL                                                             
A01209         INCLUDE TBEQATTH                                                 
A01209     END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **      END OF DLCGEN TABLE AND HOST VARIABLE DEFINTIONS       **         
      *****************************************************************         
      *                                                                         
      *****************************************************************         
      **   SQL DECLARE STATEMENTS                                    **         
      *****************************************************************         
      ***************************************************************** 03330121
      * CURSOR DECLARATION       MOVE-HIST-CURSOR                     * 03333221
      * THE FOLLOWING SELECT IS USED TO GET THE LATEST MOVEMENT       * 03333321
      * HISTORY RECORD WITH LOCATION CODE = 'J' INSTALLED OR 'K'      * 03333421
      * ATTACHED                                                      * 03333521
      ***************************************************************** 03333621
           EXEC SQL                                                     
               DECLARE MOVE-HIST-CURSOR CURSOR FOR                      
               SELECT  LOC_NO                                           
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), MOVE_NO, 121), 
           ' ', '-'), ':', '.') MOVE_NO                                        
                 FROM  CSS_MOVEMENT_HIST WITH(READUNCOMMITTED)                  
                WHERE  CODE_UTIL_TYPE   = :WS-G                         
                  AND  DEVICE_NO        = :MV-DEVICE-NO                 
                  AND  CODE_CRNT_LOC    = :WS-J                         
                  AND  DATE_MOVE       <= IIF(TRY_CONVERT(DATE, 
                                                          :MV-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MV-DATE-MOVE
              ) <> 0) OR (LEN(:MV-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MV-DATE-MOVE
              ), CONVERT(DATE, :MV-DATE-MOVE) )                 
T22243            AND  COMPANY_NO       = :MV-COMPANY-NO                
             ORDER BY  MOVE_NO DESC                                     
A01209       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     03333721
MFA-TR*        DECLARE MOVE-HIST-CURSOR CURSOR FOR                      03333821
MFA-TR*        SELECT  LOC_NO                                           03333921
MFA-TR*               ,MOVE_NO                                          03334021
MFA-TR*          FROM  CSS_MOVEMENT_HIST                                03334121
MFA-TR*         WHERE  CODE_UTIL_TYPE   = :WS-G                         03334221
MFA-TR*           AND  DEVICE_NO        = :MV-DEVICE-NO                 03334321
MFA-TR*           AND  CODE_CRNT_LOC    = :WS-J                         03334421
MFA-TR*           AND  DATE_MOVE       <= :MV-DATE-MOVE                 03334421
MFA-TR*           AND  COMPANY_NO       = :MV-COMPANY-NO                        
MFA-TR*      ORDER BY  MOVE_NO DESC                                     03334521
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                    03334621
      *                                                                 03335021
A01209***************************************************************** 03330121
A01209* CURSOR DECLARATION       METER ATTACHMENTS                    * 03333221
A01209***************************************************************** 03333621
A01209     EXEC SQL                                                     
A01209         DECLARE AMR-ERT-CURSOR CURSOR FOR                        
A01209         SELECT  MA.CODE_ATT_TYPE                                 
A01209                ,MA.DEVICE_NO                                     
A01209                ,LX.MTR_STORAGE_FAC_CD                            
A01209                ,LX.EQUIP_LOC_ID                                  
A01209                ,LX.DATE_LAST_MOVE                                
A01209           FROM  CSS_METER_ATTCHMTS   MA WITH(READUNCOMMITTED)            
A01209                ,CSS_EQUIP_ATTCHMTS   LX WITH(READUNCOMMITTED)            
A01209                ,CSS_MTR_ATT_TYPE     N5 WITH(READUNCOMMITTED)            
A01209          WHERE  MA.COMPANY_NO      = :MA-COMPANY-NO              
A01209            AND  MA.CODE_UTIL_TYPE  = :MA-CODE-UTIL-TYPE          
A01209            AND  MA.METER_NO        = :MA-METER-NO                
A01209            AND  N5.DEVICE_TYPE_CD  = 'A'                         
A01209            AND  N5.CODE_UTIL_TYPE  = MA.CODE_UTIL_TYPE           
A01209            AND  N5.CODE_ATT_TYPE   = MA.CODE_ATT_TYPE            
A01209            AND  MA.CODE_UTIL_TYPE  = LX.CODE_UTIL_TYPE           
A01209            AND  MA.COMPANY_NO      = LX.COMPANY_NO               
A01209            AND  MA.DEVICE_NO       = LX.DEVICE_NO                
A01209            AND  MA.CODE_ATT_TYPE   = LX.CODE_ATT_TYPE            
A01209       FOR READ ONLY                                      
A01209     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03333721
MFA-TR*        DECLARE AMR-ERT-CURSOR CURSOR FOR                        03333821
MFA-TR*        SELECT  MA.CODE_ATT_TYPE                                 03333921
MFA-TR*               ,MA.DEVICE_NO                                     03334021
MFA-TR*               ,LX.MTR_STORAGE_FAC_CD                            03334021
MFA-TR*               ,LX.EQUIP_LOC_ID                                  03334021
MFA-TR*               ,LX.DATE_LAST_MOVE                                03334021
MFA-TR*          FROM  CSS_METER_ATTCHMTS   MA                          03334121
MFA-TR*               ,CSS_EQUIP_ATTCHMTS   LX                                  
MFA-TR*               ,CSS_MTR_ATT_TYPE     N5                                  
MFA-TR*         WHERE  MA.COMPANY_NO      = :MA-COMPANY-NO              03334321
MFA-TR*           AND  MA.CODE_UTIL_TYPE  = :MA-CODE-UTIL-TYPE          03334221
MFA-TR*           AND  MA.METER_NO        = :MA-METER-NO                03334421
MFA-TR*           AND  N5.DEVICE_TYPE_CD  = 'A'                                 
MFA-TR*           AND  N5.CODE_UTIL_TYPE  = MA.CODE_UTIL_TYPE                   
MFA-TR*           AND  N5.CODE_ATT_TYPE   = MA.CODE_ATT_TYPE                    
MFA-TR*           AND  MA.CODE_UTIL_TYPE  = LX.CODE_UTIL_TYPE                   
MFA-TR*           AND  MA.COMPANY_NO      = LX.COMPANY_NO                       
MFA-TR*           AND  MA.DEVICE_NO       = LX.DEVICE_NO                        
MFA-TR*           AND  MA.CODE_ATT_TYPE   = LX.CODE_ATT_TYPE                    
MFA-TR*      FOR FETCH ONLY WITH UR                                     03334521
MFA-TR*    END-EXEC.                                                    03334621
      *                                                                 03335021
       01  WS-END                       PIC X(40) VALUE                 
           'WORKING STORAGE FOR PCSMT657 ENDS HERE  '.                  
      *                                                                         
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *   CONTROLS MAIN PATH OF PROGRAM                                *        
      ******************************************************************        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZATION.                                 
           PERFORM 1000-PROCESS-FILE THRU 1000-EXIT UNTIL END-OF-FILE.  
           PERFORM 8820-WRITE-CO-END-REC THRU 8820-EXIT.                
           PERFORM 8850-WRITE-END-CONTROLS THRU 8850-EXIT.              
           PERFORM 8900-PRODUCE-SUMMARY-REPORTS THRU 8900-EXIT.         
                                                                        
           DISPLAY '*********** PCSMT657 NORMAL EOJ ************'.      
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
                                                                        
       0100-INITIALIZATION.                                             
      *****************************************************************         
      * OPEN FILES, DO FIRST READ OF METER TEST FILE, ACCEPT DATE     *         
      *****************************************************************         
           OPEN OUTPUT FCSMT652-FILE                                    
                       CNTL-FILE                                        
                       PRINTER1.                                        
                                                                        
           IF FMT652-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**      PCSMT657 PROCESSING ERROR      **'      
               DISPLAY '**  OPEN ERROR OF FCSMT652 - OUTPUT FILE **'    
               DISPLAY '**  FILE STATUS = ' WS-FMT652-STATUS            
               DISPLAY '**        PROCESSING TERMINATED        **'      
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           OPEN INPUT METER-TEST-FILE.                                  
                                                                        
           ACCEPT WS-SYS-DATE FROM DATE.                                
           IF WS-SYS-DATE-YY GREATER THAN 50                            
              MOVE 19 TO WS-TEMP-CC                                     
           ELSE                                                         
              MOVE 20 TO WS-TEMP-CC
           END-IF.                                    
                                                                        
           ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
T22243     IF WS-SYSIN-COMP-NO EQUAL SPACES                             
T22243        MOVE WS-ONE                TO WS-SYSIN-COMP-NO            
T22243     END-IF.                                                      
      *                                                                         
A04527*    MOVE WS-SYSIN-COMP-NO         TO C7-COMPANY-NO,                      
A04527*                                     AT-COMPANY-NO,                      
A04527*                                     EQ-COMPANY-NO,                      
A04527*                                     GG-COMPANY-NO,                      
A04527*                                     GM-COMPANY-NO,                      
A04527*                                     GT-COMPANY-NO,                      
A04527*                                     MC-COMPANY-NO,                      
A04527*                                     MQ-COMPANY-NO,                      
A04527*                                     MV-COMPANY-NO,                      
A04527*                                     N3-COMPANY-NO.                      
      *                                                                         
           STRING WS-TEMP-CC,                                           
                  WS-SYS-DATE-YY,                                       
                  '-',                                                  
                  WS-SYS-DATE-MM,                                       
                  '-',                                                  
                  WS-SYS-DATE-DD                                        
             DELIMITED BY SIZE                                          
             INTO WS-DB2-TODAYS-DATE.                                   
                                                                        
           STRING WS-TEMP-CC,                                           
                  WS-SYS-DATE-YY,                                       
                  WS-SYS-DATE-MM,                                       
                  WS-SYS-DATE-DD                                        
             DELIMITED BY SIZE                                          
             INTO WS-CURRENT-FULL-DATE.                                 
                                                                        
           INITIALIZE ERROR-HOLD-AREA.                                  
           INITIALIZE COMPANY-END-REC.                                  
           INITIALIZE COMPANY-END-REC-DATA.                             
           MOVE 'G' TO UTILITY-TYPE-PARM.                               
      *                                                                         
A04527*    PERFORM 7200-SELECT-COMPANY-NAME  THRU 7200-EXIT.                    
A04527*    MOVE C7-COMPANY-NAME         TO WS-COMPANY-NAME.                     
      *                                                                         
           PERFORM 0300-WRITE-BEGIN-REC THRU 0300-EXIT.                 
      *                                                                         
           PERFORM 8100-READ-METER-TEST-FILE THRU 8100-EXIT.            
      *                                                                         
A04527     MOVE E-FMT03-COMPANY-NO       TO WS-SYSIN-COMP-NO.           
A04527     MOVE E-FMT03-COMPANY-NO       TO WS-SAVE-COMPANY.            
A04527     DISPLAY 'FIRST READ WS-SYSIN-COMP-NO = ' WS-SYSIN-COMP-NO.   
      *                                                                         
A04527     MOVE WS-SYSIN-COMP-NO         TO C7-COMPANY-NO               
A04527                                      AT-COMPANY-NO               
A04527                                      EQ-COMPANY-NO               
A04527                                      GG-COMPANY-NO               
A04527                                      GM-COMPANY-NO               
A04527                                      GT-COMPANY-NO               
A04527                                      MC-COMPANY-NO               
A04527                                      MQ-COMPANY-NO               
A04527                                      MV-COMPANY-NO               
A04527                                      N3-COMPANY-NO.              
      *                                                                         
A04527     PERFORM 7200-SELECT-COMPANY-NAME  THRU 7200-EXIT.            
A04527     MOVE C7-COMPANY-NAME         TO WS-COMPANY-NAME.             
      *                                                                         
       0300-WRITE-BEGIN-REC.                                            
      *                                                                         
           MOVE LOW-VALUES TO E-FMT652-KEY-BREC.                        
           MOVE WS-DB2-TODAYS-DATE TO E-FMT652-CREATE-DATE-BREC.        
           WRITE FIOMT652.                                              
           MOVE SPACES TO FIOMT652.                                     
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   RECEIVE, EDIT, AND PROCESS INPUT                             *        
      ******************************************************************        
       1000-PROCESS-FILE.                                               
      *                                                                         
      **************************************************************            
      * FOR UTIL TYPE = 'G'                                        *            
      *      UPDATE DATE_LAST_TEST ON CSS_GAS_METER,               *            
      *      SETUP AND INSERT         CSS_GAS_MTR_TEST.            *            
      *      UPDATE DATE_LAST_TRAN ON CSS_EQUIPMENT.               *            
      **************************************************************            
      *                                                                         
           EVALUATE UTILITY-TYPE-PARM                                   
               WHEN 'G'                                                 
                   PERFORM 1100-PROCESS-GAS-MTR  THRU 1100-EXIT         
           END-EVALUATE.                                                
                                                                        
           IF INPUT-IS-VALID                                            
               ADD 1 TO WS-NBR-GOOD-RECS                                
           ELSE                                                         
               ADD 1 TO WS-NBR-BAD-RECS                                 
           END-IF.                                                      
      *                                                                         
           PERFORM 8000-INITIALIZE THRU 8000-EXIT.                      
      *                                                                         
           PERFORM 8100-READ-METER-TEST-FILE THRU 8100-EXIT.            
      *                                                                         
A04527     MOVE E-FMT03-COMPANY-NO TO WS-SYSIN-COMP-NO.                 
      *                                                                         
A04527     IF WS-SYSIN-COMP-NO = WS-SAVE-COMPANY                        
A04527        NEXT SENTENCE                                             
A04527     ELSE                                                         
A04527        MOVE WS-SYSIN-COMP-NO TO C7-COMPANY-NO                    
A04527                                 AT-COMPANY-NO                    
A04527                                 EQ-COMPANY-NO                    
A04527                                 GG-COMPANY-NO                    
A04527                                 GM-COMPANY-NO                    
A04527                                 GT-COMPANY-NO                    
A04527                                 MC-COMPANY-NO                    
A04527                                 MQ-COMPANY-NO                    
A04527                                 MV-COMPANY-NO                    
A04527                                 N3-COMPANY-NO                    
A04527        PERFORM 7200-SELECT-COMPANY-NAME THRU 7200-EXIT           
A04527        MOVE C7-COMPANY-NAME TO WS-COMPANY-NAME                   
A04527        MOVE WS-SYSIN-COMP-NO TO WS-SAVE-COMPANY                  
A04527     END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       1100-PROCESS-GAS-MTR.                                            
      *                                                                         
           PERFORM 2000-EDIT-RECORD THRU 2000-EXIT.                     
           IF INPUT-IS-INVALID                                          
               GO TO 1100-EXIT                                          
           END-IF.                                                      
      *                                                                         
           IF EQ-CODE-CRNT-LOC = 'J'                                    
A04860         PERFORM 2310-CREATE-ERROR-REPORT THRU 2310-EXIT          
               GO TO 1100-EXIT                                          
           END-IF.                                                      
      *                                                                         
           MOVE E-FMT03-METER-NO         TO GT-METER-NO.                
           MOVE E-FMT03-DATE-TEST        TO GT-DATE-TEST                
           MOVE E-FMT03-TIME-TEST        TO GT-TIME-TEST                
           MOVE E-FMT03-CODE-TIME-PERIOD TO GT-CODE-TIME-PERIOD         
           MOVE E-FMT03-CODE-CAP-TYPE    TO GT-CODE-CAP-TYPE            
           MOVE E-FMT03-CODE-REPAIR      TO GT-CODE-REPAIR              
           MOVE E-FMT03-REPAIR-DESC      TO GT-REPAIR-DESC              
           MOVE E-FMT03-CODE-TEST-TYPE   TO GT-CODE-TEST-TYPE           
           MOVE E-FMT03-CODE-TEST-LOC    TO GT-CODE-TEST-LOC            
           MOVE E-FMT03-CODE-TEST-RESULT TO GT-CODE-TEST-RESULT         
           MOVE E-FMT03-IN-CHECK-RATE    TO GT-IN-CHECK-RATE            
           MOVE E-FMT03-IN-INTER-RATE    TO GT-IN-INTER-RATE            
           MOVE E-FMT03-IN-OPEN-RATE     TO GT-IN-OPEN-RATE             
           MOVE E-FMT03-IN-READ          TO GT-IN-READ                  
           MOVE E-FMT03-OUT-CHECK-RATE   TO GT-OUT-CHECK-RATE           
           MOVE E-FMT03-OUT-INTER-RATE   TO GT-OUT-INTER-RATE           
           MOVE E-FMT03-OUT-OPEN-RATE    TO GT-OUT-OPEN-RATE            
           MOVE E-FMT03-OUT-READ         TO GT-OUT-READ                 
           MOVE E-FMT03-EQ-TESTER-ID     TO GT-EQ-TESTER-ID             
           MOVE E-FMT03-TEST-PROVER-ID   TO GT-TEST-PROVER-ID           
      *                                                                         
           MOVE UTILITY-TYPE-PARM        TO GM-CODE-UTIL-TYPE.          
           MOVE E-FMT03-METER-NO         TO GM-METER-NO.                
           PERFORM 7010-SELECT-GAS-METER THRU 7010-EXIT.                
           IF  DATE-LAST-TEST-NULL                                      
               MOVE SPACES               TO GM-DATE-LAST-TESTED         
           END-IF.                                                      
      *                                                                         
           IF  LAST-TEST-SEL-DT-NULL                                    
           OR E-FMT03-CODE-TEST-TYPE = 'U'                              
               CONTINUE                                                 
           ELSE                                                         
               PERFORM 2250-CHECK-TEST-HIST THRU 2250-EXIT              
A01209         IF TEST-GROUP-NOT-FOUND                                  
A01209            MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE      
A01209            MOVE E-FMT03-METER-NO           TO ERR-METER-NBR      
A01209            MOVE GM-METER-SIZE-ID           TO ERR-FIELD          
A01209            MOVE 'TEST GROUP NOT FOUND; TEST POSTING FAILED'      
A01209                                        TO ERR-PROBLEM            
A01209            PERFORM 6000-ERROR-ROUTINE  THRU  6000-EXIT           
A01209            GO TO 1100-EXIT                                       
A01209         END-IF                                                   
           END-IF.                                                      
      *                                                                         
A01209     PERFORM 8610-INSERT-GAS-MTR-TEST THRU 8610-EXIT              
A01209     IF SQLCODE = -803                                            
A01209        DISPLAY 'DUP GAS METER TEST'                              
A01209        DISPLAY 'METER-NO         '  GT-METER-NO                  
A01209        DISPLAY 'DATE-TEST        '  GT-DATE-TEST                 
A01209        DISPLAY 'TIME-TEST        '  GT-TIME-TEST                 
A01209        DISPLAY 'CODE-TIME-PERIOD '  GT-CODE-TIME-PERIOD          
A01209        DISPLAY 'CODE-CAP-TYPE    '  GT-CODE-CAP-TYPE             
A01209        DISPLAY 'CODE-TEST-TYPE   '  GT-CODE-TEST-TYPE            
A01209        PERFORM 8615-UPDATE-GAS-MTR-TEST THRU 8615-EXIT           
A01209     END-IF.                                                      
      *                                                                 05340228
           IF  E-FMT03-IN-OPEN-RATE > 0                                 
               COMPUTE  WS-ACCURACY-PCT = (E-FMT03-IN-OPEN-RATE         
                                         + E-FMT03-IN-CHECK-RATE) / 2   
               IF  WS-ACCURACY-PCT > +102                               
                   PERFORM 2300-CREATE-WORK-QUEUE THRU 2300-EXIT        
               END-IF                                                   
           END-IF.                                                      
      *                                                                 05340928
           MOVE E-FMT03-METER-NO         TO GM-METER-NO.                
           MOVE E-FMT03-DATE-TEST        TO GM-DATE-LAST-TESTED.        
           PERFORM 8620-UPDATE-GAS-METER THRU 8620-EXIT.                
      *                                                                         
           MOVE UTILITY-TYPE-PARM TO EQ-CODE-UTIL-TYPE.                 
           MOVE E-FMT03-METER-NO  TO EQ-DEVICE-NO.                      
           PERFORM 8600-UPDATE-EQUIP THRU 8600-EXIT.                    
      *                                                                         
           IF  E-FMT03-CODE-REPAIR IS ALPHABETIC                        
           OR  (E-FMT03-CODE-REPAIR = '*' OR = '$')                     
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 7000-SELECT-COMP-NO THRU 7000-EXIT               
               MOVE E-FMT03-METER-NO       TO MV-DEVICE-NO              
               IF  DATE-LAST-MOVE-NULL                                  
                   MOVE E-FMT03-DATE-TEST  TO MV-DATE-MOVE              
               ELSE                                                     
                   MOVE EQ-DATE-LAST-MOVE  TO MV-DATE-MOVE              
               END-IF                                                   
               MOVE EQ-COMPANY-NO          TO MV-COMPANY-NO             
               MOVE EQ-LOCAL-OFFICE        TO MV-LOCAL-OFFICE           
               MOVE EQ-CRNT-LOC-NO         TO MV-LOC-NO                 
               MOVE EQ-CODE-CRNT-LOC       TO MV-CODE-CRNT-LOC          
               PERFORM 8650-INSERT-MOVEMENT-HIST THRU 8650-EXIT         
               MOVE E-FMT03-DATE-TEST      TO EQ-DATE-LAST-MOVE         
               MOVE ZEROS                  TO EQ-CRNT-LOC-NO            
               MOVE 'I'                    TO EQ-CODE-CRNT-LOC          
               PERFORM 8660-UPDATE-CRNT-LOC THRU 8660-EXIT              
      *                                                                         
A04527         PERFORM 1150-METER-RETIREMENT-PROCESS THRU 1150-EXIT     
      *                                                                         
           END-IF.                                                      
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A01209******************************************************************        
A01209*   METER RETIREMENT PROCESS                                     *        
A01209******************************************************************        
A01209 1150-METER-RETIREMENT-PROCESS.                                   
A01209*                                                                         
A01209     MOVE EQ-CODE-UTIL-TYPE     TO MA-CODE-UTIL-TYPE.             
A01209     MOVE EQ-COMPANY-NO         TO MA-COMPANY-NO.                 
A01209     MOVE E-FMT03-METER-NO      TO MA-METER-NO.                   
                                                                        
A01209     INITIALIZE    WS-AMR-ERT-FLAG.                               
                                                                        
A01209     PERFORM 7410-OPEN-AMR-ERT  THRU 7410-EXIT.                   
A01209     PERFORM 7420-FETCH-AMR-ERT THRU 7420-EXIT.                   
A01209     PERFORM UNTIL WS-AMR-ERT-FLAG = 'Y'                          
A01209        PERFORM 8500-DELETE-MA-ENTRY THRU 8500-EXIT               
A01209        MOVE MA-CODE-ATT-TYPE  TO MP-CODE-ATT-TYPE                
A01209                                  LX-CODE-ATT-TYPE                
A01209        MOVE MA-CODE-UTIL-TYPE TO MP-CODE-UTIL-TYPE               
A01209                                  LX-CODE-UTIL-TYPE               
A01209        MOVE MA-COMPANY-NO     TO MP-COMPANY-NO                   
A01209                                  LX-COMPANY-NO                   
A01209        MOVE MA-DEVICE-NO      TO MP-DEVICE-NO                    
A01209                                  LX-DEVICE-NO                    
A01209        MOVE MA-METER-NO       TO MP-METER-NO                     
A01209        MOVE LX-EQUIP-LOC-ID   TO MP-EQUIP-LOC-ID                 
A01209        MOVE LX-MTR-STORAGE-FAC-CD                                
A01209                               TO MP-MTR-STORAGE-FAC-CD           
A01209        IF WS-LX-DATE-LAST-MOVE-NULL < 0                          
A01209           MOVE E-FMT03-DATE-TEST TO MP-DATE-MOVE                 
A01209        ELSE                                                      
A01209           MOVE LX-DATE-LAST-MOVE TO MP-DATE-MOVE                 
A01209        END-IF                                                    
A01209        PERFORM 8510-CREATE-MOVE-HIST THRU 8510-EXIT              
A01209        MOVE WS-A              TO LX-EQUIP-LOC-ID                 
A01209        MOVE E-FMT03-DATE-TEST TO LX-DATE-LAST-MOVE               
A01209        MOVE -1 TO  WS-LX-EQUIP-ATTACH-DT-NULL                    
A01209        PERFORM 8520-UPDATE-ATTCHMTS THRU 8520-EXIT               
A01209        PERFORM 7420-FETCH-AMR-ERT   THRU 7420-EXIT               
A01209     END-PERFORM.                                                 
A01209     PERFORM 7430-CLOSE-AMR-ERT       THRU 7430-EXIT.             
      *                                                                         
A01209 1150-EXIT.                                                       
A01209      EXIT.                                                       
      ******************************************************************        
      *   EDIT CHECK RECORD FIELDS. IF INVALID FIELD, WRITE TO ERROR   *        
      ******************************************************************        
       2000-EDIT-RECORD.                                                
      *                                                                         
           SET INPUT-IS-VALID TO TRUE.                                  
      *                                                                         
           EVALUATE UTILITY-TYPE-PARM                                   
               WHEN 'G'                                                 
                   PERFORM 2100-EDIT-GAS-MTR  THRU 2100-EXIT            
           END-EVALUATE.                                                
      *                                                                         
       2000-EXIT. EXIT.                                                 
      *                                                                         
       2100-EDIT-GAS-MTR.                                               
      *                                                                         
      *========================================================*                
      * VERIFY METER FOR UTIL TYPE                                              
      *========================================================*                
           MOVE E-FMT03-METER-NO TO GM-METER-NO.                        
           PERFORM 7010-SELECT-GAS-METER THRU 7010-EXIT.                
      *                                                                         
           IF SQLCODE EQUAL NOT-FOUND                                   
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT03-METER-NO           TO ERR-METER-NBR         
               MOVE SPACES                     TO ERR-FIELD             
               MOVE 'METER NOT FOUND FOR UTILITY' TO ERR-PROBLEM        
               PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
               GO TO 2100-EXIT
           END-IF.                                         
      *                                                                         
           MOVE E-FMT03-METER-NO               TO EQ-DEVICE-NO.         
           PERFORM 7000-SELECT-COMP-NO THRU 7000-EXIT.                  
      *                                                                         
           IF SQLCODE EQUAL NOT-FOUND                                   
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT03-METER-NO           TO ERR-METER-NBR         
               MOVE SPACES                     TO ERR-FIELD             
               MOVE 'EQUIPMENT NOT FOUND     ' TO ERR-PROBLEM           
               PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
               GO TO 2100-EXIT
           END-IF.                                         
      *========================================================*                
      *  VERIFY DATE TEST                                                       
      *========================================================*                
           STRING E-FMT03-DATE-TEST (6:2),                              
                  E-FMT03-DATE-TEST (9:2),                              
                  E-FMT03-DATE-TEST (3:2)                               
               DELIMITED BY SIZE                                        
             INTO WS-IN-DATE.                                           
      *                                                                         
           PERFORM 2110-EDIT-TEST-DATE THRU 2110-EXIT.                  
      *                                                                         
           IF INPUT-IS-INVALID                                          
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT03-METER-NO           TO ERR-METER-NBR         
               MOVE E-FMT03-DATE-TEST          TO ERR-FIELD             
               MOVE 'INVALID TEST DATE'        TO ERR-PROBLEM           
               PERFORM 6000-ERROR-ROUTINE  THRU  6000-EXIT              
               GO TO 2100-EXIT
           END-IF.                                         
      *                                                                         
           IF E-FMT03-DATE-TEST > WS-DB2-TODAYS-DATE                    
               SET INPUT-IS-INVALID TO TRUE                             
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT03-METER-NO           TO ERR-METER-NBR         
               MOVE E-FMT03-DATE-TEST          TO ERR-FIELD             
               MOVE 'TEST DATE CANNOT BE GREATER THAN CURRENT DATE'     
                                               TO ERR-PROBLEM           
               PERFORM 6000-ERROR-ROUTINE  THRU  6000-EXIT              
               GO TO 2100-EXIT
           END-IF.                                         
      *========================================================*                
      * VERIFY TIME PERIOD                                                      
      *========================================================*                
           MOVE E-FMT03-CODE-TIME-PERIOD TO WS-CODE-TIME-PERIOD.        
      *                                                                         
           IF VALID-CODE-TIME-PERIOD                                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT03-METER-NO           TO ERR-METER-NBR         
               MOVE E-FMT03-CODE-TIME-PERIOD   TO ERR-FIELD             
               MOVE 'INVALID CODE TIME PERIOD' TO ERR-PROBLEM           
               PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
               GO TO 2100-EXIT
           END-IF.                                         
      *========================================================*                
      * VERIFY CAP TYPE                                                         
      *========================================================*                
           MOVE E-FMT03-CODE-CAP-TYPE TO WS-GAS-CAP-TYPE.               
      *                                                                         
           IF VALID-GAS-CAP-TYPE                                        
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT03-METER-NO           TO ERR-METER-NBR         
               MOVE E-FMT03-CODE-CAP-TYPE      TO ERR-FIELD             
               MOVE 'INVALID CODE CAP TYPE   ' TO ERR-PROBLEM           
               PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
               GO TO 2100-EXIT
           END-IF.                                         
      *========================================================*                
      *   CHECK TIME PERIOD AND CAPABILITIES AGAINST                            
      *   THE METER CAPABILITIES TABLE                                          
      *========================================================*                
           MOVE UTILITY-TYPE-PARM        TO MC-CODE-UTIL-TYPE.          
           MOVE E-FMT03-METER-NO         TO MC-METER-NO.                
      *    MOVE E-FMT03-CODE-TIME-PERIOD TO MC-CODE-TIME-PERIOD.                
           MOVE E-FMT03-CODE-CAP-TYPE    TO MC-CODE-CAP-TYPE.           
                                                                        
           PERFORM 7050-SELECT-MTR-CAP-EXISTS THRU 7050-EXIT.           
                                                                        
           IF SQLCODE EQUAL NOT-FOUND                                   
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT03-METER-NO           TO ERR-METER-NBR         
               MOVE E-FMT03-CODE-CAP-TYPE      TO WS-MTR-CAP-TYPE       
               MOVE E-FMT03-CODE-TIME-PERIOD   TO WS-TIME-PERIOD        
               MOVE WS-MTR-CAP-TIME-PERIOD     TO ERR-FIELD             
               MOVE 'INVALID CAP TYPE/TIME PERIOD' TO ERR-PROBLEM       
               PERFORM 6000-ERROR-ROUTINE  THRU  6000-EXIT              
               GO TO 2100-EXIT                                          
           END-IF.                                                      
      *========================================================*                
      *  VERIFY REPAIR CODE                                                     
      *========================================================*                
           MOVE E-FMT03-CODE-REPAIR  TO WS-CODE-REPAIR.                 
33887      MOVE UTILITY-TYPE-PARM    TO N3-CODE-UTIL-TYPE.              
      *                                                                         
           PERFORM 7020-SELECT-CODE-REPAIR THRU 7020-EXIT.              
      *                                                                         
           IF SQLCODE EQUAL NOT-FOUND                                   
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT03-METER-NO           TO ERR-METER-NBR         
               MOVE E-FMT03-CODE-REPAIR        TO ERR-FIELD             
               MOVE 'INVALID CODE REPAIR'      TO ERR-PROBLEM           
               PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
               GO TO 2100-EXIT                                          
           END-IF.                                                      
      *========================================================*                
      *  VERIFY CODE TEST TYPE                                                  
      *========================================================*                
           MOVE E-FMT03-CODE-TEST-TYPE TO WS-CODE-TEST-TYPE.            
      *                                                                         
           PERFORM 7030-SELECT-CODE-TEST-TYPE THRU 7030-EXIT.           
      *                                                                         
           IF SQLCODE EQUAL NOT-FOUND                                   
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT03-METER-NO           TO ERR-METER-NBR         
               MOVE E-FMT03-CODE-TEST-TYPE     TO ERR-FIELD             
               MOVE 'INVALID TEST TYPE'        TO ERR-PROBLEM           
               PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
               GO TO 2100-EXIT
           END-IF.                                         
                                                                        
           MOVE E-FMT03-METER-NO           TO GT-METER-NO.              
           MOVE E-FMT03-DATE-TEST          TO GT-DATE-TEST.             
           MOVE E-FMT03-TIME-TEST          TO GT-TIME-TEST.             
           MOVE E-FMT03-CODE-TIME-PERIOD   TO GT-CODE-TIME-PERIOD.      
           MOVE E-FMT03-CODE-CAP-TYPE      TO GT-CODE-CAP-TYPE.         
                                                                        
           PERFORM 7105-SELECT-GAS-MTR-TEST-KEY THRU 7105-EXIT.         
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               IF E-FMT03-CODE-TEST-TYPE NOT = GT-CODE-TEST-TYPE        
                   MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE     
                   MOVE E-FMT03-METER-NO           TO ERR-METER-NBR     
                   MOVE E-FMT03-CODE-TEST-TYPE     TO ERR-FIELD         
                   MOVE 'TEST EXIST FOR DATE,TIME,CAP' TO ERR-PROBLEM   
                   PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT            
                   GO TO 2100-EXIT
               END-IF
           END-IF.                                     
      *                                                                         
      *========================================================*                
      *  VERIFY CODE TEST LOC                                                   
      *========================================================*                
           MOVE E-FMT03-CODE-TEST-LOC TO WS-CODE-TEST-LOC.              
      *                                                                         
           PERFORM 7040-SELECT-CODE-TEST-LOC THRU 7040-EXIT.            
      *                                                                         
           IF SQLCODE EQUAL NOT-FOUND                                   
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT03-METER-NO           TO ERR-METER-NBR         
               MOVE E-FMT03-CODE-TEST-LOC      TO ERR-FIELD             
               MOVE 'INVALID TEST LOC '        TO ERR-PROBLEM           
               PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
               GO TO 2100-EXIT
           END-IF.                                         
      *========================================================*                
      *   VERIFY CODE TEST RESULT                                               
      *========================================================*                
           MOVE E-FMT03-CODE-TEST-RESULT TO WS-CODE-TEST-RESULT.        
      *                                                                         
           IF VALID-CODE-TEST-RESULT                                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT03-METER-NO           TO ERR-METER-NBR         
               MOVE E-FMT03-CODE-TEST-RESULT   TO ERR-FIELD             
               MOVE 'INVALID CODE TEST RESULT' TO ERR-PROBLEM           
               PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
               GO TO 2100-EXIT
           END-IF.                                         
      *========================================================*                
      *  VERIFY IN CHECK RATE                                                   
      *========================================================*                
           MOVE E-FMT03-IN-CHECK-RATE TO WS-NUM-EDIT.                   
      *                                                                         
           IF E-FMT03-IN-CHECK-RATE NOT NUMERIC                         
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT03-METER-NO           TO ERR-METER-NBR         
               MOVE 'INVALID IN CHECK RATE'    TO ERR-PROBLEM           
               PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
               GO TO 2100-EXIT
           END-IF.                                         
      *                                                                         
           IF  WS-NUM-INTEGER    = ZEROES                               
           AND WS-NUM-DECIMAL    > ZEROES                               
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT03-METER-NO           TO ERR-METER-NBR         
               MOVE E-FMT03-IN-CHECK-RATE      TO ERR-FIELD-N           
               MOVE 'INVALID IN CHECK RATE'    TO ERR-PROBLEM           
               PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
               GO TO 2100-EXIT
           END-IF.                                         
      *========================================================*                
      * VERIFY IN OPEN RATE                                                     
      *========================================================*                
           MOVE E-FMT03-IN-OPEN-RATE TO WS-NUM-EDIT.                    
      *                                                                         
           IF E-FMT03-IN-OPEN-RATE NOT NUMERIC                          
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT03-METER-NO           TO ERR-METER-NBR         
               MOVE 'INVALID IN OPEN RATE'     TO ERR-PROBLEM           
               PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
               GO TO 2100-EXIT
           END-IF.                                         
      *                                                                         
           IF  WS-NUM-INTEGER    = ZEROES                               
           AND WS-NUM-DECIMAL    > ZEROES                               
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT03-METER-NO           TO ERR-METER-NBR         
               MOVE E-FMT03-IN-OPEN-RATE       TO ERR-FIELD-N           
               MOVE 'INVALID IN OPEN RATE'     TO ERR-PROBLEM           
               PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
               GO TO 2100-EXIT
           END-IF.                                         
      *                                                                         
           IF  E-FMT03-IN-CHECK-RATE NUMERIC                            
           AND E-FMT03-IN-OPEN-RATE  NUMERIC                            
               IF  E-FMT03-IN-CHECK-RATE > ZERO                         
               AND E-FMT03-IN-OPEN-RATE  = ZERO                         
                   MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE     
                   MOVE E-FMT03-METER-NO           TO ERR-METER-NBR     
                   MOVE E-FMT03-IN-CHECK-RATE      TO ERR-FIELD-N       
                   MOVE 'IN CHECK RATE MUST HAVE IN OPEN RATE'          
                                                   TO ERR-PROBLEM       
                   PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT            
                   GO TO 2100-EXIT
               END-IF
           END-IF.                                     
                                                                        
           IF  E-FMT03-IN-CHECK-RATE NUMERIC                            
           AND E-FMT03-IN-OPEN-RATE  NUMERIC                            
               IF  E-FMT03-IN-CHECK-RATE = ZERO                         
               AND E-FMT03-IN-OPEN-RATE  > ZERO                         
                   MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE     
                   MOVE E-FMT03-METER-NO           TO ERR-METER-NBR     
                   MOVE E-FMT03-IN-OPEN-RATE       TO ERR-FIELD-N       
                   MOVE 'IN OPEN RATE MUST HAVE IN CHECK RATE'          
                                                   TO ERR-PROBLEM       
                   PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT            
                   GO TO 2100-EXIT
               END-IF
           END-IF.                                     
      *                                                                         
      *========================================================*                
      *  VERIFY IN READ                                                         
      *========================================================*                
           IF E-FMT03-IN-READ NOT NUMERIC                               
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT03-METER-NO           TO ERR-METER-NBR         
               MOVE 'INVALID IN READ      '    TO ERR-PROBLEM           
               PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
               GO TO 2100-EXIT
           END-IF.                                         
      *========================================================*                
      *  VERIFY OUT CHECK RATE                                                  
      *========================================================*                
           MOVE E-FMT03-OUT-CHECK-RATE TO WS-NUM-EDIT.                  
      *                                                                         
           IF E-FMT03-OUT-CHECK-RATE NOT NUMERIC                        
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT03-METER-NO           TO ERR-METER-NBR         
               MOVE 'INVALID OUT CHECK RATE'   TO ERR-PROBLEM           
               PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
               GO TO 2100-EXIT
           END-IF.                                         
      *                                                                         
           IF  WS-NUM-INTEGER    = ZEROES                               
           AND WS-NUM-DECIMAL    > ZEROES                               
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT03-METER-NO           TO ERR-METER-NBR         
               MOVE E-FMT03-OUT-CHECK-RATE     TO ERR-FIELD-N           
               MOVE 'INVALID OUT CHECK RATE'   TO ERR-PROBLEM           
               PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
               GO TO 2100-EXIT
           END-IF.                                         
      *                                                                         
      *========================================================*                
      *  VERIFY OUT OPEN RATE                                                   
      *========================================================*                
           MOVE E-FMT03-OUT-OPEN-RATE TO WS-NUM-EDIT.                   
      *                                                                         
           IF E-FMT03-OUT-OPEN-RATE NUMERIC                             
               IF  WS-NUM-INTEGER    = ZEROES                           
               AND WS-NUM-DECIMAL    > ZEROES                           
                   MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE     
                   MOVE E-FMT03-METER-NO           TO ERR-METER-NBR     
                   MOVE E-FMT03-OUT-OPEN-RATE      TO ERR-FIELD-N       
                   MOVE 'INVALID OUT OPEN RATE '   TO ERR-PROBLEM       
                   PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT            
                   GO TO 2100-EXIT
               END-IF
           END-IF.                                     
      *                                                                         
           IF  E-FMT03-OUT-CHECK-RATE NUMERIC                           
           AND E-FMT03-OUT-OPEN-RATE NUMERIC                            
               IF  E-FMT03-OUT-CHECK-RATE > ZERO                        
               AND E-FMT03-OUT-OPEN-RATE = ZERO                         
                   MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE     
                   MOVE E-FMT03-METER-NO           TO ERR-METER-NBR     
                   MOVE E-FMT03-OUT-CHECK-RATE     TO ERR-FIELD-N       
                   MOVE 'OUT CHECK RATE MUST HAVE OUT OPEN RATE'        
                                                   TO ERR-PROBLEM       
                   PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT            
                   GO TO 2100-EXIT
               END-IF
           END-IF.                                     
                                                                        
           IF  E-FMT03-OUT-CHECK-RATE NUMERIC                           
           AND E-FMT03-OUT-OPEN-RATE NUMERIC                            
               IF  E-FMT03-OUT-CHECK-RATE = ZERO                        
               AND E-FMT03-OUT-OPEN-RATE > ZERO                         
                   MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE     
                   MOVE E-FMT03-METER-NO           TO ERR-METER-NBR     
                   MOVE E-FMT03-OUT-OPEN-RATE      TO ERR-FIELD-N       
                   MOVE 'OUT OPEN RATE MUST HAVE OUT CHECK RATE'        
                                                   TO ERR-PROBLEM       
                   PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT            
                   GO TO 2100-EXIT
               END-IF
           END-IF.                                     
      *                                                                         
      *========================================================*                
      *  VERIFY OUT READ                                                        
      *========================================================*                
           IF E-FMT03-OUT-READ NOT NUMERIC                              
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT03-METER-NO           TO ERR-METER-NBR         
               MOVE 'INVALID OUT READ      '   TO ERR-PROBLEM           
               PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
               GO TO 2100-EXIT
           END-IF.                                         
      *                                                                         
      *========================================================*                
      *  VERIFY PROVER ID                                                       
      *========================================================*                
           IF E-FMT03-TEST-PROVER-ID EQUAL (LOW-VALUES OR SPACES)       
               NEXT SENTENCE                                            
           ELSE                                                         
           IF E-FMT03-TEST-PROVER-ID NUMERIC                            
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE UTILITY-TYPE-PARM          TO ERR-UTIL-TYPE         
               MOVE E-FMT03-METER-NO           TO ERR-METER-NBR         
               MOVE E-FMT03-TEST-PROVER-ID     TO ERR-FIELD             
               MOVE 'INVALID PROVER ID '       TO ERR-PROBLEM           
               PERFORM 6000-ERROR-ROUTINE THRU 6000-EXIT                
               GO TO 2100-EXIT
           END-IF
           END-IF.                                         
      *                                                                         
       2100-EXIT.  EXIT.                                                
      *                                                                         
       2110-EDIT-TEST-DATE.                                             
      *                                                                         
           MOVE WS-F  TO WS-PARM-DAY-REQUIRED.                          
           MOVE WS-Y  TO WS-PARM-DATE-REQUIRED.                         
           MOVE WS-LE TO WS-PARM-OPERATOR.                              
      *                                                                         
           PERFORM  6100-DATE-VALIDATION  THRU  6100-EXIT.              
      *                                                                         
           IF INVALID-MONTH                                             
           OR INVALID-DAY                                               
           OR INVALID-YEAR                                              
               SET INPUT-IS-INVALID TO TRUE                             
           END-IF.                                                      
      *                                                                         
       2110-EXIT.  EXIT.                                                
      *                                                                 10480010
      ******************************************************************10480128
      *   UPDATE CSS_MTR_TEST_HIST DEPENDING ON THE OPERATION          *10480228
      ******************************************************************10480320
       2250-CHECK-TEST-HIST.                                            
      *                                                                 10480520
           IF  (GM-LAST-TEST-SEL-CD GREATER THAN SPACES AND             
               GM-LAST-TEST-SEL-DT > GM-DATE-LAST-TESTED)               
                                                                        
               MOVE GM-LAST-TEST-SEL-DT(1:4) TO MQ-TEST-YEAR            
               IF GM-TEST-SCHED-CD = 'R'                                
                   MOVE 'R' TO MQ-TEST-SCHED-CD                         
A01209             IF DATE-PURCHASED-NULL                               
A01209                MOVE '1950-01-01' TO EQ-DATE-PURCHASED            
A01209             END-IF                                               
A01209             IF WS-SYSIN-COMP-NO = '26'                           
A01209                IF DATE-LAST-TEST-NULL                            
A01209                   MOVE EQ-DATE-PURCHASED TO WS-DATE-PURCHASED    
A01209                ELSE                                              
A01209                   MOVE GM-DATE-LAST-TESTED TO WS-DATE-PURCHASED  
A01209                END-IF                                            
A01209             ELSE                                                 
A01209                MOVE EQ-DATE-PURCHASED TO WS-DATE-PURCHASED       
A01209             END-IF                                               
                   PERFORM 7060-SELECT-MTR-TEST-GROUP-CD                
                                                      THRU 7060-EXIT    
A01209             IF SQLCODE EQUAL NOT-FOUND                           
A01209                MOVE 'N'  TO  WS-TEST-GROUP-FOUND                 
A01209                GO TO 2250-EXIT                                   
A01209             ELSE                                                 
A01209                MOVE 'Y'  TO  WS-TEST-GROUP-FOUND                 
A01209             END-IF                                               
               ELSE                                                     
                   MOVE GM-TEST-SCHED-CD TO MQ-TEST-SCHED-CD            
                   MOVE SPACE            TO MQ-MTR-TEST-GRP-CD          
               END-IF                                                   
                                                                        
               PERFORM 7150-SELECT-TEST-HIST THRU 7150-EXIT             
               IF  SQLCODE EQUAL NOT-FOUND                              
                   GO TO 2250-EXIT                                      
               END-IF                                                   
               IF  STATUS-CD-NULL                                       
                   MOVE SPACES             TO MQ-STATUS-CD              
               END-IF                                                   
               IF  MQ-STATUS-CD = WS-B                                  
                   MOVE WS-C               TO MQ-STATUS-CD              
               END-IF                                                   
               ADD 1                       TO MQ-TESTED-QT              
               IF  (MQ-TEST-SCHED-CD NOT = WS-R AND                     
                 MQ-TESTED-QT NOT LESS THAN MQ-SELECTED-QT)             
                 OR  (MQ-TEST-SCHED-CD = WS-R                           
                 AND MQ-TESTED-QT NOT LESS THAN MQ-SAMPLE-MIN-QT)       
                   MOVE WS-D               TO MQ-STATUS-CD              
               END-IF                                                   
               PERFORM 8630-UPDATE-TEST-HIST THRU 8630-EXIT             
           END-IF.                                                      
      *                                                                 16083820
       2250-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************16580000
      *   CREATE WORK QUEUE FOR INACURATE METERS (EXCEED 2% VARIANCE)  *16590000
      ******************************************************************16600000
       2300-CREATE-WORK-QUEUE.                                          
      *                                                                 15860000
A04860     INITIALIZE CWS00077-FIELDS.                                  
A04860     MOVE ZERO                     TO WS-ITEM-ID.                 
A04860     MOVE WS-ITEM-ID               TO WS-77-ITEM-ID.              
A04860     MOVE 133                      TO WS-77-CATEGORY-ID.          
A04860     MOVE 4                        TO WS-77-ROUTE-CATEGORY.       
A04860     MOVE 'N'                      TO WS-77-PRIORITY.             
A04860     MOVE ZERO                     TO WS-77-SERV-ORDER-NO         
A04860                                      WS-77-ACCOUNT-NO            
A04860                                      WS-77-PREMISE-NO            
A04860                                      WS-77-LOCAL-OFFICE          
A04860                                      WS-77-CUSTOMER-NO.          
      *                                                                         
           MOVE GT-METER-NO              TO EQ-DEVICE-NO.               
           PERFORM 7000-SELECT-COMP-NO THRU 7000-EXIT.                  
           IF  (WS-INSTALL-DT-NULL = -1 OR E-FMT03-DATE-TEST >          
               EQ-INSTALL-DT) AND EQ-CODE-CRNT-LOC = WS-J               
               MOVE EQ-CRNT-LOC-NO       TO AT-PREMISE-NO               
           ELSE                                                         
               MOVE GM-METER-NO          TO MV-DEVICE-NO                
               MOVE E-FMT03-DATE-TEST    TO MV-DATE-MOVE                
                                                                        
               PERFORM 7300-OPEN-MOVE-HIST-CURSOR THRU 7300-EXIT        
               PERFORM 7310-FETCH-MOVE-HIST-CURSOR THRU 7310-EXIT       
               IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL AND      
                   WS-LOC-NO-NULL NOT EQUAL -1                          
                   MOVE MV-LOC-NO        TO AT-PREMISE-NO               
               ELSE                                                     
                   MOVE ZERO             TO AT-PREMISE-NO               
               END-IF                                                   
               PERFORM 7320-CLOSE-MOVE-HIST-CURSOR THRU 7320-EXIT       
           END-IF.                                                      
      *                                                                         
           MOVE AT-PREMISE-NO            TO WS-CPD99-PREMISE-NO.        
           PERFORM 6990-FETCH-CUR-ACCOUNT                               
                                         THRU 6990-EXIT.                
           MOVE WS-CPD99-ACCOUNT-NO      TO AT-ACCOUNT-NO.              
           PERFORM 7250-SELECT-ACCOUNT-DETAILS THRU 7250-EXIT.          
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
A04860         MOVE AT-ACCOUNT-NO        TO WS-77-ACCOUNT-NO            
A04860         MOVE AT-CUSTOMER-NO       TO WS-77-CUSTOMER-NO           
A04860         MOVE AT-LOCAL-OFFICE      TO WS-77-LOCAL-OFFICE          
           END-IF.                                                      
      *                                                                         
A04860     MOVE 'SYSTEM '                TO WS-77-USER-ID-ORIG.         
A04860     MOVE AT-PREMISE-NO            TO WS-77-PREMISE-NO.           
A04860     MOVE SPACES                   TO WS-77-RESP-AREA-ID.         
A04860     MOVE ZERO                     TO WS-77-FREE-FORM-LEN.        
A04860     MOVE LOW-VALUES               TO WS-77-FREE-FORM-TXT.        
      *                                                                 15860000
           MOVE WS-ACCURACY-PCT          TO WS-ACCURACY-PCTX.           
           STRING WS-FAST-SLOW-METER                                    
                  WS-ACCURACY-PCTX                                      
                  WS-FAST-METER                                         
                  GT-METER-NO                                           
                  DELIMITED BY SIZE                                     
           INTO   WS-WQ-COMMENTS-TEXT.                                  
           MOVE  +85                     TO WS-WQ-COMMENTS-LEN.         
A04860     MOVE WS-WQ-COMMENTS           TO WS-77-COMMENTS.             
A04860     MOVE WS-PGRMNAME              TO WS-77-CREATED-BY.           
      *                                                                         
           PERFORM 8640-INSERT-WORK-QUEUE-ITEM THRU 8640-EXIT.          
      *                                                                         
           MOVE WS-WQ-COMMENTS-TEXT  TO WS-WQ-ERROR-TEXT.               
           PERFORM P1010-ERROR-REPORT THRU P1010-EXIT.                  
      *                                                                 15860000
       2300-EXIT.  EXIT.                                                
      *                                                                 15860000
      ******************************************************************16580000
A04860*  CREATE ERROR REPORT FOR INSTALLED METERS TRYING TO BE RETIRED *16590000
      ******************************************************************16600000
A04860 2310-CREATE-ERROR-REPORT.                                        
      *                                                                 15860000
           STRING GT-METER-NO                                           
                  WS-TEST-INSTALLED                                     
                  DELIMITED BY SIZE                                     
           INTO   WS-WQ-COMMENTS-TEXT.                                  
           MOVE  +64                     TO WS-WQ-COMMENTS-LEN.         
           MOVE WS-WQ-COMMENTS-TEXT  TO WS-WQ-ERROR-TEXT.               
           PERFORM P1010-ERROR-REPORT THRU P1010-EXIT.                  
      *                                                                 15860000
       2310-EXIT.  EXIT.                                                
      *                                                                 15860000
       6000-ERROR-ROUTINE.                                              
      *                                                                 15860000
           SET INPUT-IS-INVALID TO TRUE.                                
           MOVE 'Y' TO WS-MASTER-ERROR-FLAG.                            
           MOVE ERR-UTIL-TYPE                    TO E-FMT652-UTIL-TYPE  
                                                    EQ-CODE-UTIL-TYPE.  
           MOVE ERR-METER-NBR                    TO E-FMT652-METER-NBR  
                                                    EQ-DEVICE-NO.       
           MOVE ERR-FIELD                       TO E-FMT652-ERROR-FIELD.
           MOVE ERR-PROBLEM                      TO E-FMT652-PROBLEM.   
           MOVE ERR-CLASS-CD                     TO                     
                                                  E-FMT652-MTR-CLASS-CD.
           MOVE ERR-SPEC-CD                      TO                     
                                                  E-FMT652-MTR-SPEC-CD. 
      *    PERFORM 7000-SELECT-COMP-NO THRU 7000-EXIT.                          
           MOVE EQ-COMPANY-NO                    TO E-FMT652-COMPANY-NO 
                                                    CMP-COMPANY-NO.     
           ADD 1                                 TO WS-FMT652-REC-CNTR. 
           PERFORM 8800-PROCESS-END-REC-TBL THRU 8800-EXIT.             
           WRITE FIOMT652.                                              
           MOVE ERR-FIELD            TO WS-WQ-ERROR-FIELD.              
           MOVE ERR-PROBLEM          TO WS-WQ-ERROR-MESSAGE.            
           PERFORM P1010-ERROR-REPORT THRU P1010-EXIT.                  
           MOVE SPACES                         TO ERR-FIELD.            
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6100-DATE-VALIDATION.                                            
      *                                                                         
           MOVE ZEROES TO     WS-RETURN-DATE                            
                              WS-WORK-FIELDS                            
                              WS-DATE-FLAGS.                            
           PERFORM 6110-NUMERIC-CHECK   THRU 6110-EXIT.                 
           IF WS-DATE-FLAGS = ZEROS                                     
             MOVE WS-IN-DD         TO WS-RETURN-DD                      
             MOVE WS-IN-YY         TO WS-RETURN-YY                      
             MOVE WS-IN-MM         TO WS-RETURN-MM                      
                                                                        
             IF WS-RETURN-YY GREATER THAN 50                            
                 MOVE 19           TO WS-RETURN-CC                      
               ELSE                                                     
                 MOVE 20           TO WS-RETURN-CC                      
             END-IF                                                     
             IF WS-CURRENT-CMPR-YY IS NUMERIC                           
                 IF WS-CURRENT-CMPR-YY GREATER THAN 50                  
                     MOVE 19       TO WS-CURRENT-CMPR-CC                
                   ELSE                                                 
                     MOVE 20       TO WS-CURRENT-CMPR-CC                
                 END-IF                                                 
             END-IF                                                     
             PERFORM 6120-BOUNDARY-CHECK        THRU 6120-EXIT          
             IF NOT (INVALID-DAY AND INVALID-MONTH)                     
               IF WS-PARM-OPERATOR NOT = SPACES AND 'NA'                
                 PERFORM 6140-COMPARE-FULL-DATES    THRU 6140-EXIT      
                 IF WS-DATE-OPERATOR-FLAG = WS-PARM-OPERATOR            
                   NEXT SENTENCE                                        
                 ELSE                                                   
                   IF WS-DATE-OPERATOR-FLAG = WS-EQ                     
                     IF WS-PARM-OPERATOR = WS-LE OR WS-GE OR WS-EQ      
                       NEXT SENTENCE                                    
                     ELSE                                               
                         MOVE 1 TO MONTH-FLAG DAY-FLAG YEAR-FLAG        
                     END-IF                                             
                   ELSE                                                 
                     IF WS-DATE-OPERATOR-FLAG = WS-GT                   
                       IF WS-PARM-OPERATOR = WS-GE OR WS-GT             
                         NEXT SENTENCE                                  
                       ELSE                                             
                         MOVE 1 TO MONTH-FLAG DAY-FLAG YEAR-FLAG        
                       END-IF                                           
                     ELSE                                               
                       IF WS-DATE-OPERATOR-FLAG = WS-LT                 
                         IF WS-PARM-OPERATOR = WS-LE OR WS-LT           
                           NEXT SENTENCE                                
                         ELSE                                           
                           MOVE 1 TO MONTH-FLAG DAY-FLAG YEAR-FLAG      
                         END-IF                                         
                       END-IF                                           
                     END-IF                                             
                   END-IF                                               
                 END-IF                                                 
               END-IF                                                   
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       6100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *   VALIDATE DATE INFORMATION...                                          
      *****************************************************************         
       6110-NUMERIC-CHECK.                                              
      *                                                                         
           IF WS-IN-MM NUMERIC                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 1 TO MONTH-FLAG
           END-IF.                                    
           IF WS-IN-DD NUMERIC                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 1 TO DAY-FLAG
           END-IF.                                      
           IF WS-IN-YY NUMERIC                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 1 TO YEAR-FLAG
           END-IF.                                     
                                                                        
       6110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6120-BOUNDARY-CHECK.                                             
      *                                                                         
           IF WS-RETURN-MM > 12 OR                                      
              WS-RETURN-MM < 01                                         
              MOVE 1 TO MONTH-FLAG
           END-IF.                                     
           IF THIRTY-ONE-DAY                                            
               MOVE 31 TO WS-UPPER-LIMIT                                
           ELSE                                                         
           IF THIRTY-DAY                                                
               MOVE 30 TO WS-UPPER-LIMIT                                
           ELSE                                                         
           DIVIDE WS-RETURN-YY BY 4 GIVING WS-RESULT                    
               REMAINDER WS-REMAINDER-DATE                              
           IF WS-REMAINDER-DATE = ZEROES                                
              MOVE 29 TO WS-UPPER-LIMIT                                 
           ELSE                                                         
              MOVE 28 TO WS-UPPER-LIMIT
           END-IF
           END-IF
           END-IF.                                
           IF WS-RETURN-DD > WS-UPPER-LIMIT                             
                       OR                                               
              WS-RETURN-DD < 1                                          
              MOVE 1 TO DAY-FLAG
           END-IF.                                       
      *                                                                         
       6120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6140-COMPARE-FULL-DATES.                                         
      *                                                                         
           IF  WS-RETURN-DATE > WS-CURRENT-FULL-DATE                    
               MOVE 'GT'              TO WS-DATE-OPERATOR-FLAG          
           ELSE                                                         
               IF  WS-RETURN-DATE < WS-CURRENT-FULL-DATE                
                   MOVE 'LT'          TO WS-DATE-OPERATOR-FLAG          
               ELSE                                                     
                   MOVE 'EQ'          TO WS-DATE-OPERATOR-FLAG
               END-IF
           END-IF.         
                                                                        
           IF  WS-RETURN-YY > 50                                        
               MOVE 19                TO WS-CENTURY-INDICATOR           
           ELSE                                                         
               MOVE 20                TO WS-CENTURY-INDICATOR
           END-IF.          
      *                                                                         
       6140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6990-FETCH-CUR-ACCOUNT                                         *        
      *  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.             *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00099                                                 
           END-EXEC.                                                            
      *                                                                         
       6995-CPD99-ERROR-ROUTINE.                                        
      *                                                                         
           DISPLAY '***************PCSMT657*******************'         
           DISPLAY '* 6995-CPD99-ERROR-ROUTINE               *'         
           DISPLAY '* ERROR GETTING ACCOUNT-NO FROM CPD00099 *'         
           DISPLAY '* PROGRAM ABENDING...                    *'         
           DISPLAY '* ERROR IN PARA', ACTIVE-PARAGRAPH                  
           DISPLAY '* PREMISE-NO = ', WS-CPD99-PREMISE-NO               
           DISPLAY '* SQL CODE IS  ', WS-CPD99-RETURN-CODE              
           DISPLAY '***************PCSMT657*******************'         
           PERFORM 9900-ABEND              THRU 9900-EXIT.              
      *                                                                         
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7000-SELECT-COMP-NO.                                             
      *                                                                         
           EXEC SQL                                                     
               SELECT DATE_PURCHASED,                                   
                      COMPANY_NO,                                       
                      SERIAL_NO,                                        
                      CODE_CRNT_LOC,                                    
                      CRNT_LOC_NO,                                      
                      INSTALL_DT                                        
                     ,LOCAL_OFFICE                                      
                     ,DATE_LAST_MOVE                                    
               INTO :EQ-DATE-PURCHASED :WS-DATE-PURCHASED-NULL,          
                    :EQ-COMPANY-NO,                                     
                    :EQ-SERIAL-NO,                                      
                    :EQ-CODE-CRNT-LOC,                                  
                    :EQ-CRNT-LOC-NO,                                    
                    :EQ-INSTALL-DT :WS-INSTALL-DT-NULL                   
                   ,:EQ-LOCAL-OFFICE                                    
                   ,:EQ-DATE-LAST-MOVE :WS-DATE-LAST-MOVE-NULL           
               FROM CSS_EQUIPMENT WITH(READUNCOMMITTED)                         
               WHERE CODE_UTIL_TYPE = :WS-G                             
                 AND DEVICE_NO      = :EQ-DEVICE-NO                     
                 AND COMPANY_NO     = :EQ-COMPANY-NO                    
                 AND EQUIP_TYPE_CD  = 'M'                               
A01209                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE_PURCHASED,                                           
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               SERIAL_NO,                                                
MFA-TR*               CODE_CRNT_LOC,                                            
MFA-TR*               CRNT_LOC_NO,                                              
MFA-TR*               INSTALL_DT                                                
MFA-TR*              ,LOCAL_OFFICE                                              
MFA-TR*              ,DATE_LAST_MOVE                                            
MFA-TR*        INTO :EQ-DATE-PURCHASED:WS-DATE-PURCHASED-NULL,                  
MFA-TR*             :EQ-COMPANY-NO,                                             
MFA-TR*             :EQ-SERIAL-NO,                                              
MFA-TR*             :EQ-CODE-CRNT-LOC,                                          
MFA-TR*             :EQ-CRNT-LOC-NO,                                            
MFA-TR*             :EQ-INSTALL-DT:WS-INSTALL-DT-NULL                           
MFA-TR*            ,:EQ-LOCAL-OFFICE                                            
MFA-TR*            ,:EQ-DATE-LAST-MOVE:WS-DATE-LAST-MOVE-NULL                   
MFA-TR*        FROM CSS_EQUIPMENT                                               
MFA-TR*        WHERE CODE_UTIL_TYPE = :WS-G                                     
MFA-TR*          AND DEVICE_NO      = :EQ-DEVICE-NO                             
MFA-TR*          AND COMPANY_NO     = :EQ-COMPANY-NO                            
MFA-TR*          AND EQUIP_TYPE_CD  = 'M'                                       
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
           OR SQLCODE EQUAL NOT-FOUND                                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '***************PCSMT657**************'          
               DISPLAY '* 7000-SELECT-COMP-NO               *'          
               DISPLAY '* ERROR READING CSS_EQUIPMENT       *'          
               DISPLAY '* DEVICE NO IS ', EQ-DEVICE-NO                  
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSMT657**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7010-SELECT-GAS-METER.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT CODE_METER_TYPE,                                  
                      CASE_PRESSURE,                                    
                      CODE_CAP_CFF,                                     
                      CODE_CAP_UCG,                                     
                      DATE_LAST_TESTED,                                 
                      METER_SIZE_ID,                                    
                      CODE_CO_SIZE,                                     
                      TEST_SCHED_CD,                                    
                      LAST_TEST_SEL_DT,                                 
                      LAST_TEST_SEL_CD                                  
               INTO :GM-CODE-METER-TYPE,                                
                    :GM-CASE-PRESSURE,                                  
                    :GM-CODE-CAP-CFF,                                   
                    :GM-CODE-CAP-UCG,                                   
                    :GM-DATE-LAST-TESTED :WS-DATE-LAST-TEST-NULL,        
                    :GM-METER-SIZE-ID,                                  
                    :GM-CODE-CO-SIZE,                                   
                    :GM-TEST-SCHED-CD,                                  
                    :GM-LAST-TEST-SEL-DT :WS-LAST-TEST-SEL-DATE-NULL,    
                    :GM-LAST-TEST-SEL-CD                                
               FROM CSS_GAS_METER WITH(READUNCOMMITTED)                         
               WHERE CODE_UTIL_TYPE = :WS-G                             
                 AND METER_NO       = :GM-METER-NO                      
T22243           AND COMPANY_NO     = :GM-COMPANY-NO                    
A01209                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_METER_TYPE,                                          
MFA-TR*               CASE_PRESSURE,                                            
MFA-TR*               CODE_CAP_CFF,                                             
MFA-TR*               CODE_CAP_UCG,                                             
MFA-TR*               DATE_LAST_TESTED,                                         
MFA-TR*               METER_SIZE_ID,                                            
MFA-TR*               CODE_CO_SIZE,                                             
MFA-TR*               TEST_SCHED_CD,                                            
MFA-TR*               LAST_TEST_SEL_DT,                                         
MFA-TR*               LAST_TEST_SEL_CD                                          
MFA-TR*        INTO :GM-CODE-METER-TYPE,                                        
MFA-TR*             :GM-CASE-PRESSURE,                                          
MFA-TR*             :GM-CODE-CAP-CFF,                                           
MFA-TR*             :GM-CODE-CAP-UCG,                                           
MFA-TR*             :GM-DATE-LAST-TESTED:WS-DATE-LAST-TEST-NULL,                
MFA-TR*             :GM-METER-SIZE-ID,                                          
MFA-TR*             :GM-CODE-CO-SIZE,                                           
MFA-TR*             :GM-TEST-SCHED-CD,                                          
MFA-TR*             :GM-LAST-TEST-SEL-DT:WS-LAST-TEST-SEL-DATE-NULL,            
MFA-TR*             :GM-LAST-TEST-SEL-CD                                        
MFA-TR*        FROM CSS_GAS_METER                                               
MFA-TR*        WHERE CODE_UTIL_TYPE = :WS-G                                     
MFA-TR*          AND METER_NO       = :GM-METER-NO                              
MFA-TR*          AND COMPANY_NO     = :GM-COMPANY-NO                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
           OR SQLCODE EQUAL NOT-FOUND                                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '***************PCSMT657**************'          
               DISPLAY '* 7010-SELECT-GAS-METER             *'          
               DISPLAY '* ERROR READING CSS_GAS_METER       *'          
               DISPLAY '* METER NBR IS ', GM-METER-NO                   
T22243         DISPLAY '* COMPANY NO IS ', GM-COMPANY-NO                
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSMT657**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7020-SELECT-CODE-REPAIR.                                         
      *                                                                         
           EXEC SQL                                                     
               SELECT CODE_REPAIR,                                      
                      TEST_REPAIR_DESC                                  
               INTO :N3-CODE-REPAIR,                                    
                    :N3-TEST-REPAIR-DESC                                
               FROM CSS_EQUIP_TST_REPR WITH(READUNCOMMITTED)                    
               WHERE CODE_REPAIR = :WS-CODE-REPAIR                      
33887            AND COMPANY_NO  = :N3-COMPANY-NO                       
33887            AND CODE_UTIL_TYPE = :N3-CODE-UTIL-TYPE                
A01209                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_REPAIR,                                              
MFA-TR*               TEST_REPAIR_DESC                                          
MFA-TR*        INTO :N3-CODE-REPAIR,                                            
MFA-TR*             :N3-TEST-REPAIR-DESC                                        
MFA-TR*        FROM CSS_EQUIP_TST_REPR                                          
MFA-TR*        WHERE CODE_REPAIR = :WS-CODE-REPAIR                              
MFA-TR*          AND COMPANY_NO  = :N3-COMPANY-NO                               
MFA-TR*          AND CODE_UTIL_TYPE = :N3-CODE-UTIL-TYPE                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
           OR SQLCODE EQUAL NOT-FOUND                                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '***************PCSMT657**************'          
               DISPLAY '* 7020-SELECT-CODE-REPAIR           *'          
               DISPLAY '* ERROR READING CSS_EQUIP_TST_REPR  *'          
               DISPLAY '* CODE_REPAIR IS ', WS-CODE-REPAIR              
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSMT657**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7030-SELECT-CODE-TEST-TYPE.                                      
      *                                                                         
           EXEC SQL                                                     
               SELECT CODE_TEST_TYPE,                                   
                      TEST_TYPE_DESC                                    
               INTO :M9-CODE-TEST-TYPE,                                 
                    :M9-TEST-TYPE-DESC                                  
               FROM CSS_EQUIP_TEST_TYP WITH(READUNCOMMITTED)                    
               WHERE CODE_TEST_TYPE = :WS-CODE-TEST-TYPE                
                 AND CODE_UTIL_TYPE = :WS-G                             
A01209                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_TEST_TYPE,                                           
MFA-TR*               TEST_TYPE_DESC                                            
MFA-TR*        INTO :M9-CODE-TEST-TYPE,                                         
MFA-TR*             :M9-TEST-TYPE-DESC                                          
MFA-TR*        FROM CSS_EQUIP_TEST_TYP                                          
MFA-TR*        WHERE CODE_TEST_TYPE = :WS-CODE-TEST-TYPE                        
MFA-TR*          AND CODE_UTIL_TYPE = :WS-G                                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
           OR SQLCODE EQUAL NOT-FOUND                                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '***************PCSMT657**************'          
               DISPLAY '* 7030-SELECT-CODE-TEST-TYPE        *'          
               DISPLAY '* ERROR READING CSS_EQUIP_TEST_TYP  *'          
               DISPLAY '* CODE_REPAIR IS ', WS-CODE-TEST-TYPE           
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSMT657**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7040-SELECT-CODE-TEST-LOC.                                       
      *                                                                         
           EXEC SQL                                                     
               SELECT CODE_TEST_LOC,                                    
                      TEST_LOC_DESC                                     
               INTO :N1-CODE-TEST-LOC,                                  
                    :N1-TEST-LOC-DESC                                   
               FROM CSS_EQUIP_TEST_LOC WITH(READUNCOMMITTED)                    
               WHERE CODE_TEST_LOC = :WS-CODE-TEST-LOC                  
A01209                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_TEST_LOC,                                            
MFA-TR*               TEST_LOC_DESC                                             
MFA-TR*        INTO :N1-CODE-TEST-LOC,                                          
MFA-TR*             :N1-TEST-LOC-DESC                                           
MFA-TR*        FROM CSS_EQUIP_TEST_LOC                                          
MFA-TR*        WHERE CODE_TEST_LOC = :WS-CODE-TEST-LOC                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
           OR SQLCODE EQUAL NOT-FOUND                                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '***************PCSMT657**************'          
               DISPLAY '* 7040-SELECT-CODE-TEST-LOC         *'          
               DISPLAY '* ERROR READING CSS_EQUIP_TEST_LOC  *'          
               DISPLAY '* CODE_REPAIR IS ', WS-CODE-TEST-LOC            
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSMT657**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7050-SELECT-MTR-CAP-EXISTS.                                      
      *                                                                         
           EXEC SQL                                                     
               SELECT DEMAND_TYPE                                       
               INTO :MC-DEMAND-TYPE                                     
               FROM CSS_MTR_CAP WITH(READUNCOMMITTED)                           
               WHERE CODE_UTIL_TYPE     = :MC-CODE-UTIL-TYPE            
               AND   METER_NO           = :MC-METER-NO                  
      *        AND   CODE_TIME_PERIOD   = :MC-CODE-TIME-PERIOD                  
               AND   CODE_CAP_TYPE      = :MC-CODE-CAP-TYPE             
T22243         AND   COMPANY_NO         = :MC-COMPANY-NO                
A01209                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DEMAND_TYPE                                               
MFA-TR*        INTO :MC-DEMAND-TYPE                                             
MFA-TR*        FROM CSS_MTR_CAP                                                 
MFA-TR*        WHERE CODE_UTIL_TYPE     = :MC-CODE-UTIL-TYPE                    
MFA-TR*        AND   METER_NO           = :MC-METER-NO                          
MFA-TR*        AND   CODE_TIME_PERIOD   = :MC-CODE-TIME-PERIOD                  
MFA-TR*        AND   CODE_CAP_TYPE      = :MC-CODE-CAP-TYPE                     
MFA-TR*        AND   COMPANY_NO         = :MC-COMPANY-NO                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
           OR SQLCODE EQUAL NOT-FOUND                                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '***************PCSMT657**************'          
               DISPLAY '* 7050-SELECT-METER-CAP-EXISTS      *'          
               DISPLAY '* ERROR READING CSS_MTR_CAP         *'          
               DISPLAY '* UTIL TYPE IS   ', MC-CODE-UTIL-TYPE           
               DISPLAY '* METER NBR IS   ', MC-METER-NO                 
      *        DISPLAY '* TIME PERIOD IS ', MC-CODE-TIME-PERIOD                 
               DISPLAY '* CAP TYPE IS    ', MC-CODE-CAP-TYPE            
T22243         DISPLAY '* COMPANY NO IS ', MC-COMPANY-NO                
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSMT657**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7060-SELECT-MTR-TEST-GROUP-CD.                                   
      *                                                                         
           EXEC SQL                                                     
               SELECT MTR_TEST_GRP_CD                                   
                 INTO :MQ-MTR-TEST-GRP-CD                               
                 FROM CSS_GAS_TST_GROUP WITH(READUNCOMMITTED)                   
                 WHERE CODE_UTIL_TYPE = :WS-G                           
                   AND METER_SIZE_ID  = :GM-METER-SIZE-ID               
                   AND BEGIN_PURCHASE_DT <= IIF(TRY_CONVERT(DATE, 
                                                     :WS-DATE-PURCHASED
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-PURCHASED
              ) <> 0) OR (LEN(:WS-DATE-PURCHASED
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-PURCHASED
              ), CONVERT(DATE, :WS-DATE-PURCHASED) )          
                   AND END_PURCHASE_DT >= IIF(TRY_CONVERT(DATE, 
                                                     :WS-DATE-PURCHASED
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-PURCHASED
              ) <> 0) OR (LEN(:WS-DATE-PURCHASED
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-PURCHASED
              ), CONVERT(DATE, :WS-DATE-PURCHASED) )            
T22243             AND COMPANY_NO = :GG-COMPANY-NO                      
A01209                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MTR_TEST_GRP_CD                                   1721    
MFA-TR*          INTO :MQ-MTR-TEST-GRP-CD                               1821    
MFA-TR*          FROM CSS_GAS_TST_GROUP                                 1821    
MFA-TR*          WHERE CODE_UTIL_TYPE = :WS-G                           1821    
MFA-TR*            AND METER_SIZE_ID  = :GM-METER-SIZE-ID               1821    
MFA-TR*            AND BEGIN_PURCHASE_DT <= :WS-DATE-PURCHASED          1821    
MFA-TR*            AND END_PURCHASE_DT >= :WS-DATE-PURCHASED            1821    
MFA-TR*            AND COMPANY_NO = :GG-COMPANY-NO                              
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
A01209        NEXT SENTENCE                                             
            ELSE                                                        
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '***************PCSMT657**************'          
               DISPLAY '* 7060-SELECT-METER-TEST-GROUP-CODE *'          
               DISPLAY '* ERROR READING CSS_GAS-TST-GROUP   *'          
               DISPLAY '* MTR SIZE ID    ', GM-METER-SIZE-ID            
               DISPLAY '* PURCHASE DT ', WS-DATE-PURCHASED              
T22243         DISPLAY '* COMPANY NO IS ', GG-COMPANY-NO                
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSMT657**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
A01209      END-IF.                                                     
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7105-SELECT-GAS-MTR-TEST-KEY.                                    
      *                                                                         
           EXEC SQL                                                     
               SELECT CODE_TEST_TYPE                                    
               INTO :GT-CODE-TEST-TYPE                                  
               FROM CSS_GAS_MTR_TEST WITH(READUNCOMMITTED)                      
               WHERE CODE_UTIL_TYPE     = 'G'                           
               AND   METER_NO           = :GT-METER-NO                  
               AND   DATE_TEST          = IIF(TRY_CONVERT(DATE, 
                                                          :GT-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :GT-DATE-TEST
              ) <> 0) OR (LEN(:GT-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :GT-DATE-TEST
              ), CONVERT(DATE, :GT-DATE-TEST) )                 
               AND   TIME_TEST          = CIS.CHAR2TIME(:GT-TIME-TEST)          
               AND   CODE_TIME_PERIOD   = :GT-CODE-TIME-PERIOD          
               AND   CODE_CAP_TYPE      = :GT-CODE-CAP-TYPE             
T22243         AND   COMPANY_NO         = :GT-COMPANY-NO                
A01209                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_TEST_TYPE                                            
MFA-TR*        INTO :GT-CODE-TEST-TYPE                                          
MFA-TR*        FROM CSS_GAS_MTR_TEST                                            
MFA-TR*        WHERE CODE_UTIL_TYPE     = 'G'                                   
MFA-TR*        AND   METER_NO           = :GT-METER-NO                          
MFA-TR*        AND   DATE_TEST          = :GT-DATE-TEST                         
MFA-TR*        AND   TIME_TEST          = :GT-TIME-TEST                         
MFA-TR*        AND   CODE_TIME_PERIOD   = :GT-CODE-TIME-PERIOD                  
MFA-TR*        AND   CODE_CAP_TYPE      = :GT-CODE-CAP-TYPE                     
MFA-TR*        AND   COMPANY_NO         = :GT-COMPANY-NO                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
           OR SQLCODE EQUAL NOT-FOUND                                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '***************PCSMT657**************'          
               DISPLAY '* 7105-SELECT-GAS-MTR-TEST-KEY      *'          
               DISPLAY '* ERROR READING CSS_GAS_MTR_TEST    *'          
               DISPLAY '* METER NBR IS   ', GT-METER-NO                 
               DISPLAY '* DATE TEST IS   ', GT-DATE-TEST                
               DISPLAY '* TIME TEST IS   ', GT-TIME-TEST                
               DISPLAY '* TIME PERIOD IS ', GT-CODE-TIME-PERIOD         
               DISPLAY '* CAP TYPE IS    ', GT-CODE-CAP-TYPE            
T22243         DISPLAY '* COMPANY NO IS ', GT-COMPANY-NO                
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSMT657**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
       7105-EXIT.  EXIT.                                                
      *                                                                         
      ******************************************************************13860128
      ** OBTAIN THE TEST HISTORY RECORD                               **13860228
      ******************************************************************13860320
       7150-SELECT-TEST-HIST.                                           
      *                                                                 13860520
           EXEC SQL                                                     
               SELECT  SELECTED_QT                                      
                      ,STATUS_CD                                        
                      ,SAMPLE_MIN_QT                                    
                      ,TESTED_QT                                        
                INTO  :MQ-SELECTED-QT                                   
                     ,:MQ-STATUS-CD :WS-STATUS-CD-NULL                  
                     ,:MQ-SAMPLE-MIN-QT                                 
                     ,:MQ-TESTED-QT                                     
                FROM  CSS_MTR_TEST_HIST WITH(READUNCOMMITTED)                   
               WHERE  CODE_UTIL_TYPE  = :WS-G                           
                 AND  TEST_YEAR       = :MQ-TEST-YEAR                   
                 AND  TEST_SCHED_CD   = :MQ-TEST-SCHED-CD               
                 AND  MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD             
T22243           AND  COMPANY_NO      = :MQ-COMPANY-NO                  
A01209                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13860620
MFA-TR*        SELECT  SELECTED_QT                                      13860720
MFA-TR*               ,STATUS_CD                                        13860820
MFA-TR*               ,SAMPLE_MIN_QT                                    13860920
MFA-TR*               ,TESTED_QT                                        13861020
MFA-TR*         INTO  :MQ-SELECTED-QT                                   13861120
MFA-TR*              ,:MQ-STATUS-CD :WS-STATUS-CD-NULL                  13861220
MFA-TR*              ,:MQ-SAMPLE-MIN-QT                                 13861320
MFA-TR*              ,:MQ-TESTED-QT                                     13861420
MFA-TR*         FROM  CSS_MTR_TEST_HIST                                 13861520
MFA-TR*        WHERE  CODE_UTIL_TYPE  = :WS-G                           13861620
MFA-TR*          AND  TEST_YEAR       = :MQ-TEST-YEAR                   13861720
MFA-TR*          AND  TEST_SCHED_CD   = :MQ-TEST-SCHED-CD               13861820
MFA-TR*          AND  MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD             13861920
MFA-TR*          AND  COMPANY_NO      = :MQ-COMPANY-NO                          
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    13862020

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13862220
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                    TO WS-DISPLAY-RC         
               DISPLAY '***************PCSMT657**************'          
               DISPLAY '* 7150-SELECT-TEST-HIST             *'          
               DISPLAY '* ERROR READING CSS_MTR_TEST_HIST   *'          
               DISPLAY '* CODE UTIL TYPE IS ', MQ-CODE-UTIL-TYPE        
               DISPLAY '* TEST YEAR IS  ', MQ-TEST-YEAR                 
               DISPLAY '* TEST SCHED CD IS  ', MQ-TEST-SCHED-CD         
               DISPLAY '* TEST GRP CD IS  ', MQ-MTR-TEST-GRP-CD         
T22243         DISPLAY '* COMPANY NO IS ', MQ-COMPANY-NO                
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSMT657**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 13864520
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13869128
T22243******************************************************************        
T22243**  7200-SELECT-COMPANY-NAME                                    **        
T22243******************************************************************        
T22243 7200-SELECT-COMPANY-NAME.                                        
      *                                                                 13869128
T22243     EXEC SQL                                                     
T22243         SELECT COMPANY_NAME                                      
T22243           INTO :C7-COMPANY-NAME                                  
T22243           FROM CSS_COMPANY WITH(READUNCOMMITTED)                         
T22243         WHERE COMPANY_NO = :C7-COMPANY-NO                        
A01209                                                           
T22243     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NAME                                              
MFA-TR*          INTO :C7-COMPANY-NAME                                          
MFA-TR*          FROM CSS_COMPANY                                               
MFA-TR*        WHERE COMPANY_NO = :C7-COMPANY-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22243     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
T22243                                                                  
T22243     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
T22243         NEXT SENTENCE                                            
T22243     ELSE                                                         
T22243         MOVE WS-ACTIVE-RETURN-CODE      TO WS-DISPLAY-RC         
T22243         DISPLAY '**************** PCSMT657 *****************'    
T22243         DISPLAY '* 7200 : RETURN CODE ERROR - SELECT       *'    
T22243         DISPLAY '*        RC = ' WS-DISPLAY-RC                   
T22243         DISPLAY 'COMPANY NO: = ' C7-COMPANY-NO                   
T22243         DISPLAY '* PROGRAM ABENDING...                     *'    
T22243         DISPLAY '*******************************************'    
T22243         PERFORM 9900-ABEND  THRU  9900-EXIT
           END-IF.                     
T22243 7200-EXIT.                                                       
T22243     EXIT.                                                        
      *                                                                         
      ******************************************************************13877621
      **  7250-SELECT-ACCOUNT-DETAILS                                 **13877721
      ******************************************************************13877921
        7250-SELECT-ACCOUNT-DETAILS.                                    
      *                                                                 13878121
           EXEC SQL                                                     
               SELECT  CUSTOMER_NO,                                     
                       LOCAL_OFFICE                                     
                 INTO  :AT-CUSTOMER-NO,                                 
                       :AT-LOCAL-OFFICE                                 
                 FROM  CSS_ACCOUNT WITH(READUNCOMMITTED)                        
                 WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      
                   AND COMPANY_NO = :AT-COMPANY-NO                      
A01209                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13878221
MFA-TR*        SELECT  CUSTOMER_NO,                                             
MFA-TR*                LOCAL_OFFICE                                             
MFA-TR*          INTO  :AT-CUSTOMER-NO,                                         
MFA-TR*                :AT-LOCAL-OFFICE                                         
MFA-TR*          FROM  CSS_ACCOUNT                                              
MFA-TR*          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                              
MFA-TR*            AND COMPANY_NO = :AT-COMPANY-NO                              
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                    13878421

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO WS-DISPLAY-RC         
               DISPLAY '**************** PCSMT657 *****************'    
               DISPLAY '* 7250 : RETURN CODE ERROR - SELECT       *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY 'ACCOUNT NO: = ' AT-ACCOUNT-NO                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT
           END-IF.                     
      *                                                                 13879821
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13884621
      ******************************************************************13884721
      **  7300-OPEN-MOVE-HIST-CURSOR                                  **13884821
      **  OPEN THE CURSOR                                             **13884921
      ******************************************************************13885021
       7300-OPEN-MOVE-HIST-CURSOR.                                      
      *                                                                 13885221
           EXEC SQL                                                     
               OPEN MOVE-HIST-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
      *                                                                 13885721
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO WS-DISPLAY-RC         
               DISPLAY '**************** PCSMT657 *****************'    
               DISPLAY '* 7300 : RETURN CODE ERROR - OPEN         *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '*        DEVICE NO : ' MV-DEVICE-NO             
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT
           END-IF.                     
      *                                                                 13886921
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13887221
      ******************************************************************13887321
      **  7310-FETCH-MOVE-HIST-CURSOR                                 **13887421
      **  THIS PARAGRAPH IS USED TO FETCH MOVE-HIST-CURSOR            **13887521
      ******************************************************************13887621
       7310-FETCH-MOVE-HIST-CURSOR.                                     
      *                                                                 13887821
           EXEC SQL                                                     
               FETCH  MOVE-HIST-CURSOR                                  
                INTO  :MV-LOC-NO :WS-LOC-NO-NULL                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 13888421
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                    TO WS-DISPLAY-RC         
               DISPLAY '*****************PCSMT657******************'    
               DISPLAY '* 7310 : RETURN CODE ERROR - FETCH        *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '*        DEVICE NO : ' MV-DEVICE-NO             
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                 13889721
       7310-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            13890021
      *                                                                 13890121
      ******************************************************************13890221
      **  7320-CLOSE-MOVE-HIST-CURSOR                                 **13890321
      **  THIS PARAGRAPH IS USED TO CLOSE MOVE-HIST-CURSOR            **13890421
      ******************************************************************13890521
       7320-CLOSE-MOVE-HIST-CURSOR.                                     
      *                                                                 13890721
           EXEC SQL                                                     
               CLOSE MOVE-HIST-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE  SQLCODE                       TO WS-ACTIVE-RETURN-CODE.
      *                                                                 13891221
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSMT657******************'    
               DISPLAY '* 7320 : RETURN CODE ERROR - CLOSE        *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '*        DEVICE NO : ' MV-DEVICE-NO             
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                 13892521
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13892821
A01209****************************************************************          
A01209**   7410-OPEN-AMR-ERT.                                       **          
A01209**       TO OPEN CURSOR INT-ERT FOR CSS_METER_ATTCHMTS        **          
A01209****************************************************************          
A01209 7410-OPEN-AMR-ERT.                                               
A01209*                                                                         
A01209     EXEC SQL                                                     
A01209         OPEN AMR-ERT-CURSOR                                      
A01209     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01209*                                                                         
A01209     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
A01209*                                                                         
A01209     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A01209         NEXT SENTENCE                                            
A01209     ELSE                                                         
A01209         DISPLAY '**  OPEN ERROR IN 7410-OPEN-AMR-RET   **'       
A01209         DISPLAY '**    TABLE :  CSS_METER_ATTCHMTS     **'       
A01209         DISPLAY '**    TABLE :   CSS_MTR_ATT_TYPE      **'       
A01209         DISPLAY '**    TABLE :   CSS_EQUIP_ATTCHMTS    **'       
A01209         DISPLAY '** UTIL-TYPE   = ' MA-CODE-UTIL-TYPE            
A01209         DISPLAY '** COMPANY-NO  = ' MA-COMPANY-NO                
A01209         DISPLAY '** METER-NO    = ' MA-METER-NO                  
A01209         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
A01209         DISPLAY '**       PROCESSING TERMINATED        **'       
A01209         PERFORM 9900-ABEND         THRU 9900-EXIT                
A01209     END-IF.                                                      
A01209*                                                                         
A01209 7410-EXIT.                                                       
A01209     EXIT.                                                        
A01209*                                                                         
A01209****************************************************************          
A01209**   7420-FETCH-AMR-ERT.                                      **          
A01209**       TO FETCH FIELD DETAILS FROM CSS_METER_ATTCHMTS       **          
A01209****************************************************************          
A01209 7420-FETCH-AMR-ERT.                                              
A01209*                                                                         
A01209     EXEC SQL                                                     
A01209         FETCH  AMR-ERT-CURSOR                                    
A01209         INTO :MA-CODE-ATT-TYPE                                   
A01209             ,:MA-DEVICE-NO                                       
A01209             ,:LX-MTR-STORAGE-FAC-CD :WS-LX-MTR-STOR-FAC-CD-NULL   
A01209             ,:LX-EQUIP-LOC-ID                                    
A01209             ,:LX-DATE-LAST-MOVE :WS-LX-DATE-LAST-MOVE-NULL        
A01209     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01209*                                                                         
A01209     MOVE SQLCODE           TO     WS-ACTIVE-RETURN-CODE.         
A01209*                                                                         
A01209     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A01209        IF WS-LX-MTR-STOR-FAC-CD-NULL < 0                         
A01209           MOVE SPACES TO LX-MTR-STORAGE-FAC-CD                   
A01209        END-IF                                                    
A01209        IF WS-LX-DATE-LAST-MOVE-NULL  < 0                         
A01209           MOVE SPACES TO LX-DATE-LAST-MOVE                       
A01209        END-IF                                                    
A01209     ELSE                                                         
A01209         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
A01209             MOVE WS-Y TO WS-AMR-ERT-FLAG                         
A01209         ELSE                                                     
A01209             DISPLAY '**  FETCH ERROR IN 7420-FETCH-AMR-ERT   **' 
A01209             DISPLAY '**     TABLE :  CSS_METER_ATTCHMTS      **' 
A01209             DISPLAY '**     TABLE :  CSS_MTR_ATT_TYPE        **' 
A01209             DISPLAY '**     TABLE :  CSS_EQUIP_ATTCHMTS      **' 
A01209             DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
A01209             DISPLAY '** UTIL-TYPE   = ' MA-CODE-UTIL-TYPE        
A01209             DISPLAY '** COMPANY-NO  = ' MA-COMPANY-NO            
A01209             DISPLAY '** METER-NO    = ' MA-METER-NO              
A01209             DISPLAY '**       PROCESSING TERMINATED        **'   
A01209             PERFORM 9900-ABEND         THRU 9900-EXIT            
A01209         END-IF                                                   
A01209     END-IF.                                                      
A01209*                                                                         
A01209 7420-EXIT.                                                       
A01209     EXIT.                                                        
A01209*                                                                         
A01209****************************************************************          
A01209**   7430-CLOSE-AMR-ERT.                                      **          
A01209**       TO CLOSE CURSOR AMR-ERT                              *           
A01209****************************************************************          
A01209 7430-CLOSE-AMR-ERT.                                              
A01209*                                                                         
A01209     EXEC SQL                                                     
A01209         CLOSE AMR-ERT-CURSOR                                     
A01209     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01209*                                                                         
A01209     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
A01209*                                                                         
A01209     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A01209         NEXT SENTENCE                                            
A01209     ELSE                                                         
A01209         DISPLAY '**  CLOSE ERROR IN 7430-CLOSE-AMR-ERT **'       
A01209         DISPLAY '**    TABLE :  CSS_METER_ATTCHMTS     **'       
A01209         DISPLAY '**    TABLE :  CSS_MTR_ATT_TYPE       **'       
A01209         DISPLAY '**    TABLE :  CSS_EQUIP_ATCHMTS      **'       
A01209         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
A01209         DISPLAY '** UTIL-TYPE   = ' MA-CODE-UTIL-TYPE            
A01209         DISPLAY '** COMPANY-NO  = ' MA-COMPANY-NO                
A01209         DISPLAY '** METER-NO    = ' MA-METER-NO                  
A01209         DISPLAY '**       PROCESSING TERMINATED        **'       
A01209         PERFORM 9900-ABEND         THRU 9900-EXIT                
A01209     END-IF.                                                      
A01209*                                                                         
A01209 7430-EXIT.                                                       
A01209     EXIT.                                                        
A01209*                                                                         
      ****************************************************************          
       8000-INITIALIZE.                                                 
      *                                                                 13892821
           SET INPUT-IS-VALID TO TRUE.                                  
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8100-READ-METER-TEST-FILE.                                       
      *                                                                         
           READ METER-TEST-FILE                                         
           AT END MOVE 'Y' TO WS-EOF-FLAG.                              
                                                                        
           EVALUATE UTILITY-TYPE-PARM                                   
               WHEN 'G'                                                 
                   MOVE METER-TEST-REC  TO FIOMT03-GAS-TEST-REC         
               WHEN OTHER                                               
                   DISPLAY '***************PCSMT657***************'     
                   DISPLAY '* 8100-READ-METER-TEST-FILE          *'     
                   DISPLAY '* INVALID PARM IN CSS_JOB_PARM TABLE *'     
                   DISPLAY '* DATA NAME IS  UTIL TYPE =          *'     
                   DISPLAY '* DATA VALUE IS ', UTILITY-TYPE-PARM        
                   DISPLAY '* PROGRAM ABORTING...                *'     
                   DISPLAY '***************PCSMT657***************'     
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
           DISPLAY 'E-FMT03-METER-NO = ' E-FMT03-METER-NO.              
                                                                        
           IF FIRST-READ                                                
              MOVE 'N' TO WS-READ-FLAG                                  
           END-IF.                                                      
                                                                        
           IF NOT END-OF-FILE                                           
              ADD 1 TO WS-NBR-METER-TEST-RECS                           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A01209 8500-DELETE-MA-ENTRY.                                            
A01209*                                                                         
A01209     EXEC SQL                                                     
A01209         DELETE FROM                                              
A01209             MA                                 
               FROM CSS_METER_ATTCHMTS MA
A01209             WHERE  MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE        
A01209             AND    MA.METER_NO       = :MA-METER-NO              
A01209             AND    MA.COMPANY_NO     = :MA-COMPANY-NO            
A01209             AND    MA.DEVICE_NO      = :MA-DEVICE-NO             
A01209             AND    MA.CODE_ATT_TYPE  = :MA-CODE-ATT-TYPE         
A01209     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM                                                      
MFA-TR*            CSS_METER_ATTCHMTS MA                                        
MFA-TR*            WHERE  MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                
MFA-TR*            AND    MA.METER_NO       = :MA-METER-NO                      
MFA-TR*            AND    MA.COMPANY_NO     = :MA-COMPANY-NO                    
MFA-TR*            AND    MA.DEVICE_NO      = :MA-DEVICE-NO                     
MFA-TR*            AND    MA.CODE_ATT_TYPE  = :MA-CODE-ATT-TYPE                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01209*                                                                         
A01209     IF SQLCODE = SUCCESSFUL-CALL                                 
A01209         NEXT SENTENCE                                            
A01209     ELSE                                                         
A01209         MOVE SQLCODE TO WS-DISPLAY-RC                            
A01209         DISPLAY '*************PCSMT657************'              
A01209         DISPLAY '* 8500-DELET-MA-ENTRY           *'              
A01209         DISPLAY '* ERROR DELETING CSS_METER_ATTCHMTS*'           
A01209         DISPLAY '* UTIL TYPE IS    ', MA-CODE-UTIL-TYPE          
A01209         DISPLAY '* METER NUMBER IS ', MA-METER-NO                
A01209         DISPLAY '* COMPANY NO IS ', MA-COMPANY-NO                
A01209         DISPLAY '* DEVICE  NO IS ', MA-DEVICE-NO                 
A01209         DISPLAY '* CODE ATT TYPE IS ', MA-CODE-ATT-TYPE          
A01209         DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
A01209         DISPLAY '* PROGRAM ABENDING...           *'              
A01209         DISPLAY '*************PCSMT657************'              
A01209         PERFORM 9900-ABEND THRU 9900-EXIT                        
A01209     END-IF.                                                      
                                                                        
A01209 8500-EXIT.                                                       
A01209     EXIT.                                                        
      **                                                                        
A01209****************************************************************          
A01209**   8510-CREATE-MOVE-HIST.                                   **          
A01209**       TO INSERT A NEW RECORD IN CSS_EQUIP_ATTCH_MOVE       **          
A01209****************************************************************          
A01209 8510-CREATE-MOVE-HIST.                                           
A01209*                                                                         
A01209     EXEC SQL                                                     
A01209         INSERT INTO                                              
A01209             CSS_EQUIP_ATT_MOVE                                   
A01209             ( CODE_ATT_TYPE,                                     
A01209               CODE_UTIL_TYPE,                                    
A01209               COMPANY_NO,                                        
A01209               DATE_MOVE,                                         
A01209               DEVICE_NO,                                         
A01209               EQUIP_LOC_ID,                                      
A01209               METER_NO,                                          
A01209               MOVE_NO,                                           
A01209               MTR_STORAGE_FAC_CD)                                
A01209             VALUES                                               
A01209             ( :MP-CODE-ATT-TYPE,                                 
A01209               :MP-CODE-UTIL-TYPE,                                
A01209               :MP-COMPANY-NO,                                    
A01209               IIF(TRY_CONVERT(DATE, :MP-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MP-DATE-MOVE
              ) <> 0) OR (LEN(:MP-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MP-DATE-MOVE
              ), CONVERT(DATE, :MP-DATE-MOVE) ),                               
A01209               :MP-DEVICE-NO,                                     
A01209               :MP-EQUIP-LOC-ID,                                  
A01209               :MP-METER-NO,                                      
A01209               CIS.CURRENT$TIMESTAMP(),                                 
A01209               :MP-MTR-STORAGE-FAC-CD)                            
A01209     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO                                                      
MFA-TR*            CSS_EQUIP_ATT_MOVE                                           
MFA-TR*            ( CODE_ATT_TYPE,                                             
MFA-TR*              CODE_UTIL_TYPE,                                            
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              DATE_MOVE,                                                 
MFA-TR*              DEVICE_NO,                                                 
MFA-TR*              EQUIP_LOC_ID,                                              
MFA-TR*              METER_NO,                                                  
MFA-TR*              MOVE_NO,                                                   
MFA-TR*              MTR_STORAGE_FAC_CD)                                        
MFA-TR*            VALUES                                                       
MFA-TR*            ( :MP-CODE-ATT-TYPE,                                         
MFA-TR*              :MP-CODE-UTIL-TYPE,                                        
MFA-TR*              :MP-COMPANY-NO,                                            
MFA-TR*              :MP-DATE-MOVE,                                             
MFA-TR*              :MP-DEVICE-NO,                                             
MFA-TR*              :MP-EQUIP-LOC-ID,                                          
MFA-TR*              :MP-METER-NO,                                              
MFA-TR*              CURRENT TIMESTAMP,                                         
MFA-TR*              :MP-MTR-STORAGE-FAC-CD)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01209*                                                                         
A01209     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
A01209*                                                                         
A01209     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A01209         NEXT SENTENCE                                            
A01209     ELSE                                                         
A01209         DISPLAY '** INSERT ERROR IN 8510-CREATE-MOVE-HIST**'     
A01209         DISPLAY '**     TABLE :  CSS_EQUIP_ATT_MOVE      **'     
A01209         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
A01209         DISPLAY '**       PROCESSING TERMINATED        **'       
A01209         DISPLAY ' MP-CODE-ATT-TYPE ' MP-CODE-ATT-TYPE            
A01209         DISPLAY ' MP-CODE-UTIL-TYPE   ' MP-CODE-UTIL-TYPE        
A01209         DISPLAY ' MP-COMPANY-NO       ' MP-COMPANY-NO            
A01209         DISPLAY ' MP-DEVICE-NO        ' MP-DEVICE-NO             
A01209         DISPLAY ' MP-EQUIP_LOC_ID     ' MP-EQUIP-LOC-ID          
A01209         DISPLAY ' MP-METER-NO         ' MP-METER-NO              
A01209         DISPLAY ' MP-MTR-STORAGE-FAC-CD ' MP-MTR-STORAGE-FAC-CD  
A01209         PERFORM 9900-ABEND         THRU 9900-EXIT                
A01209     END-IF.                                                      
A01209*                                                                         
A01209 8510-EXIT.                                                       
A01209     EXIT.                                                        
A01209*                                                                         
A01209****************************************************************          
A01209**   8520-UPDATE-ATTCHMTS.                                    **          
A01209**       TO UPDATE CURRENT CODE IN CSS_EQUIP_ATTCHMTS TABLE   **          
A01209****************************************************************          
A01209 8520-UPDATE-ATTCHMTS.                                            
A01209*                                                                         
A01209     EXEC SQL                                                     
A01209         UPDATE CSS_EQUIP_ATTCHMTS                                
A01209             SET   EQUIP_LOC_ID        = :LX-EQUIP-LOC-ID         
A01209                  ,DATE_LAST_MOVE      = IIF(TRY_CONVERT(DATE, 
                                                     :LX-DATE-LAST-MOVE
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-MOVE
              ) <> 0) OR (LEN(:LX-DATE-LAST-MOVE
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-MOVE
              ), CONVERT(DATE, :LX-DATE-LAST-MOVE) )       
A01209                  ,EQUIP_ATTACH_DT     = IIF(TRY_CONVERT(DATE, 
                                                   :LX-EQUIP-ATTACH-DT 
                                            :WS-LX-EQUIP-ATTACH-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :LX-EQUIP-ATTACH-DT 
                                            :WS-LX-EQUIP-ATTACH-DT-NULL
              ) <> 0) OR (LEN(:LX-EQUIP-ATTACH-DT 
                                            :WS-LX-EQUIP-ATTACH-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:LX-EQUIP-ATTACH-DT 
                                            :WS-LX-EQUIP-ATTACH-DT-NULL
              ), CONVERT(DATE, :LX-EQUIP-ATTACH-DT 
                                            :WS-LX-EQUIP-ATTACH-DT-NULL
              ) )      
A01209             WHERE CODE_UTIL_TYPE      = :LX-CODE-UTIL-TYPE       
A01209             AND   COMPANY_NO          = :LX-COMPANY-NO           
A01209             AND   DEVICE_NO           = :LX-DEVICE-NO            
A01209             AND   CODE_ATT_TYPE       = :LX-CODE-ATT-TYPE        
A01209     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_EQUIP_ATTCHMTS                                        
MFA-TR*            SET   EQUIP_LOC_ID        = :LX-EQUIP-LOC-ID                 
MFA-TR*                 ,DATE_LAST_MOVE      = :LX-DATE-LAST-MOVE               
MFA-TR*                 ,EQUIP_ATTACH_DT     = :LX-EQUIP-ATTACH-DT              
MFA-TR*                                :WS-LX-EQUIP-ATTACH-DT-NULL              
MFA-TR*            WHERE CODE_UTIL_TYPE      = :LX-CODE-UTIL-TYPE               
MFA-TR*            AND   COMPANY_NO          = :LX-COMPANY-NO                   
MFA-TR*            AND   DEVICE_NO           = :LX-DEVICE-NO                    
MFA-TR*            AND   CODE_ATT_TYPE       = :LX-CODE-ATT-TYPE                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01209*                                                                         
A01209     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
A01209*                                                                         
A01209     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A01209         NEXT SENTENCE                                            
A01209     ELSE                                                         
A01209         DISPLAY '**  UPDATE ERROR IN 8520-UPDATE-ATTCHMTS**'     
A01209         DISPLAY '**     TABLE :  CSS_EQUIP_ATTCHMTS      **'     
A01209         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
A01209         DISPLAY '** COMPANY NO       = ' LX-COMPANY-NO           
A01209         DISPLAY '** EQUIP-LOC-ID     = ' LX-EQUIP-LOC-ID,        
A01209         DISPLAY '** DATE-LAST-MOVE   = ' LX-DATE-LAST-MOVE       
A01209         DISPLAY '** CODE-UTIL-TYPE   = ' LX-CODE-UTIL-TYPE       
A01209         DISPLAY '** DEVICE-NO        = ' LX-DEVICE-NO            
A01209         DISPLAY '** METER-NO         = ' MA-METER-NO             
A01209         DISPLAY '**       PROCESSING TERMINATED        **'       
A01209         PERFORM 9900-ABEND         THRU 9900-EXIT                
A01209     END-IF.                                                      
A01209*                                                                         
A01209 8520-EXIT.                                                       
A01209     EXIT.                                                        
A01209*                                                                         
      *                                                                         
       8600-UPDATE-EQUIP.                                               
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_EQUIPMENT                                     
                SET DATE_LAST_TRAN  = CAST(SYSDATETIMEOFFSET() AS DATE)         
               WHERE CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                
                 AND DEVICE_NO      = :EQ-DEVICE-NO                     
T22243           AND COMPANY_NO     = :EQ-COMPANY-NO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_EQUIPMENT                                             
MFA-TR*         SET DATE_LAST_TRAN  = CURRENT DATE                              
MFA-TR*        WHERE CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                        
MFA-TR*          AND DEVICE_NO      = :EQ-DEVICE-NO                             
MFA-TR*          AND COMPANY_NO     = :EQ-COMPANY-NO                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      **                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSMT657************'              
               DISPLAY '* 8600-UPDATE-EQUIP             *'              
               DISPLAY '* ERROR UPDATING CSS_EQUIPMENT  *'              
               DISPLAY '* UTIL TYPE IS    ', EQ-CODE-UTIL-TYPE          
               DISPLAY '* METER NUMBER IS ', EQ-DEVICE-NO               
T22243         DISPLAY '* COMPANY NO IS ', EQ-COMPANY-NO                
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...           *'              
               DISPLAY '*************PCSMT657************'              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8610-INSERT-GAS-MTR-TEST.                                        
      *                                                                         
           MOVE ZERO TO  GT-IN-INTER-RATE.                              
           MOVE ZERO TO  GT-OUT-INTER-RATE.                             
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_GAS_MTR_TEST                             
                   (  CODE_UTIL_TYPE,                                   
                      METER_NO,                                         
                      DATE_TEST,                                        
                      TIME_TEST,                                        
                      CODE_TIME_PERIOD,                                 
                      CODE_CAP_TYPE,                                    
                      CODE_REPAIR,                                      
                      REPAIR_DESC,                                      
                      CODE_TEST_TYPE,                                   
                      CODE_TEST_LOC,                                    
                      CODE_TEST_RESULT,                                 
                      IN_CHECK_RATE,                                    
                      IN_INTER_RATE,                                    
                      IN_OPEN_RATE,                                     
                      IN_READ,                                          
                      OUT_CHECK_RATE,                                   
                      OUT_INTER_RATE,                                   
                      OUT_OPEN_RATE,                                    
                      OUT_READ,                                         
                      EQ_TESTER_ID,                                     
                      TEST_PROVER_ID,                                   
T22243                COMPANY_NO)                                       
               VALUES ( 'G',                                            
                        :GT-METER-NO,                                   
                        IIF(TRY_CONVERT(DATE, :GT-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :GT-DATE-TEST
              ) <> 0) OR (LEN(:GT-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :GT-DATE-TEST
              ), CONVERT(DATE, :GT-DATE-TEST) ),                               
                        CIS.CHAR2TIME(:GT-TIME-TEST),                           
                        :GT-CODE-TIME-PERIOD,                           
                        :GT-CODE-CAP-TYPE,                              
                        :GT-CODE-REPAIR,                                
                        :GT-REPAIR-DESC,                                
                        :GT-CODE-TEST-TYPE,                             
                        :GT-CODE-TEST-LOC,                              
                        :GT-CODE-TEST-RESULT,                           
                        :GT-IN-CHECK-RATE,                              
                        :GT-IN-INTER-RATE,                              
                        :GT-IN-OPEN-RATE,                               
                        :GT-IN-READ,                                    
                        :GT-OUT-CHECK-RATE,                             
                        :GT-OUT-INTER-RATE,                             
                        :GT-OUT-OPEN-RATE,                              
                        :GT-OUT-READ,                                   
                        :GT-EQ-TESTER-ID,                               
                        :GT-TEST-PROVER-ID,                             
T22243                  :GT-COMPANY-NO)                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_GAS_MTR_TEST                                     
MFA-TR*            (  CODE_UTIL_TYPE,                                           
MFA-TR*               METER_NO,                                                 
MFA-TR*               DATE_TEST,                                                
MFA-TR*               TIME_TEST,                                                
MFA-TR*               CODE_TIME_PERIOD,                                         
MFA-TR*               CODE_CAP_TYPE,                                            
MFA-TR*               CODE_REPAIR,                                              
MFA-TR*               REPAIR_DESC,                                              
MFA-TR*               CODE_TEST_TYPE,                                           
MFA-TR*               CODE_TEST_LOC,                                            
MFA-TR*               CODE_TEST_RESULT,                                         
MFA-TR*               IN_CHECK_RATE,                                            
MFA-TR*               IN_INTER_RATE,                                            
MFA-TR*               IN_OPEN_RATE,                                             
MFA-TR*               IN_READ,                                                  
MFA-TR*               OUT_CHECK_RATE,                                           
MFA-TR*               OUT_INTER_RATE,                                           
MFA-TR*               OUT_OPEN_RATE,                                            
MFA-TR*               OUT_READ,                                                 
MFA-TR*               EQ_TESTER_ID,                                             
MFA-TR*               TEST_PROVER_ID,                                           
MFA-TR*               COMPANY_NO)                                               
MFA-TR*        VALUES ( 'G',                                                    
MFA-TR*                 :GT-METER-NO,                                           
MFA-TR*                 :GT-DATE-TEST,                                          
MFA-TR*                 :GT-TIME-TEST,                                          
MFA-TR*                 :GT-CODE-TIME-PERIOD,                                   
MFA-TR*                 :GT-CODE-CAP-TYPE,                                      
MFA-TR*                 :GT-CODE-REPAIR,                                        
MFA-TR*                 :GT-REPAIR-DESC,                                        
MFA-TR*                 :GT-CODE-TEST-TYPE,                                     
MFA-TR*                 :GT-CODE-TEST-LOC,                                      
MFA-TR*                 :GT-CODE-TEST-RESULT,                                   
MFA-TR*                 :GT-IN-CHECK-RATE,                                      
MFA-TR*                 :GT-IN-INTER-RATE,                                      
MFA-TR*                 :GT-IN-OPEN-RATE,                                       
MFA-TR*                 :GT-IN-READ,                                            
MFA-TR*                 :GT-OUT-CHECK-RATE,                                     
MFA-TR*                 :GT-OUT-INTER-RATE,                                     
MFA-TR*                 :GT-OUT-OPEN-RATE,                                      
MFA-TR*                 :GT-OUT-READ,                                           
MFA-TR*                 :GT-EQ-TESTER-ID,                                       
MFA-TR*                 :GT-TEST-PROVER-ID,                                     
MFA-TR*                 :GT-COMPANY-NO)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
           OR SQLCODE EQUAL -803                                        
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSMT657************'              
               DISPLAY '* 8610-INSERT-GAS-MTR-TEST      *'              
               DISPLAY '* ERROR INSERT CSS_GAS_MTR_TEST *'              
               DISPLAY '* METER NUMBER IS ', GT-METER-NO                
T22243         DISPLAY '* COMPANY NO IS ', GT-COMPANY-NO                
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...           *'              
               DISPLAY '*************PCSMT657************'              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8615-UPDATE-GAS-MTR-TEST.                                        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_GAS_MTR_TEST                                  
                  SET CODE_REPAIR      = :GT-CODE-REPAIR,               
                      REPAIR_DESC      = :GT-REPAIR-DESC,               
                      CODE_TEST_TYPE   = :GT-CODE-TEST-TYPE,            
                      CODE_TEST_LOC    = :GT-CODE-TEST-LOC,             
                      CODE_TEST_RESULT = :GT-CODE-TEST-RESULT,          
                      IN_CHECK_RATE    = :GT-IN-CHECK-RATE,             
                      IN_INTER_RATE    = :GT-IN-INTER-RATE,             
                      IN_OPEN_RATE     = :GT-IN-OPEN-RATE,              
                      IN_READ          = :GT-IN-READ,                   
                      OUT_CHECK_RATE   = :GT-OUT-CHECK-RATE,            
                      OUT_INTER_RATE   = :GT-OUT-INTER-RATE,            
                      OUT_OPEN_RATE    = :GT-OUT-OPEN-RATE,             
                      OUT_READ         = :GT-OUT-READ,                  
                      EQ_TESTER_ID     = :GT-EQ-TESTER-ID,              
                      TEST_PROVER_ID   = :GT-TEST-PROVER-ID             
               WHERE CODE_UTIL_TYPE   = 'G'                             
                 AND METER_NO         = :GT-METER-NO                    
                 AND DATE_TEST        = IIF(TRY_CONVERT(DATE, 
                                                          :GT-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :GT-DATE-TEST
              ) <> 0) OR (LEN(:GT-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :GT-DATE-TEST
              ), CONVERT(DATE, :GT-DATE-TEST) )                   
                 AND TIME_TEST        = CIS.CHAR2TIME(:GT-TIME-TEST)            
                 AND CODE_TIME_PERIOD = :GT-CODE-TIME-PERIOD            
                 AND CODE_CAP_TYPE    = :GT-CODE-CAP-TYPE               
                 AND CODE_TEST_TYPE   = :GT-CODE-TEST-TYPE              
T22243           AND COMPANY_NO       = :GT-COMPANY-NO                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_GAS_MTR_TEST                                          
MFA-TR*           SET CODE_REPAIR      = :GT-CODE-REPAIR,                       
MFA-TR*               REPAIR_DESC      = :GT-REPAIR-DESC,                       
MFA-TR*               CODE_TEST_TYPE   = :GT-CODE-TEST-TYPE,                    
MFA-TR*               CODE_TEST_LOC    = :GT-CODE-TEST-LOC,                     
MFA-TR*               CODE_TEST_RESULT = :GT-CODE-TEST-RESULT,                  
MFA-TR*               IN_CHECK_RATE    = :GT-IN-CHECK-RATE,                     
MFA-TR*               IN_INTER_RATE    = :GT-IN-INTER-RATE,                     
MFA-TR*               IN_OPEN_RATE     = :GT-IN-OPEN-RATE,                      
MFA-TR*               IN_READ          = :GT-IN-READ,                           
MFA-TR*               OUT_CHECK_RATE   = :GT-OUT-CHECK-RATE,                    
MFA-TR*               OUT_INTER_RATE   = :GT-OUT-INTER-RATE,                    
MFA-TR*               OUT_OPEN_RATE    = :GT-OUT-OPEN-RATE,                     
MFA-TR*               OUT_READ         = :GT-OUT-READ,                          
MFA-TR*               EQ_TESTER_ID     = :GT-EQ-TESTER-ID,                      
MFA-TR*               TEST_PROVER_ID   = :GT-TEST-PROVER-ID                     
MFA-TR*        WHERE CODE_UTIL_TYPE   = 'G'                                     
MFA-TR*          AND METER_NO         = :GT-METER-NO                            
MFA-TR*          AND DATE_TEST        = :GT-DATE-TEST                           
MFA-TR*          AND TIME_TEST        = :GT-TIME-TEST                           
MFA-TR*          AND CODE_TIME_PERIOD = :GT-CODE-TIME-PERIOD                    
MFA-TR*          AND CODE_CAP_TYPE    = :GT-CODE-CAP-TYPE                       
MFA-TR*          AND CODE_TEST_TYPE   = :GT-CODE-TEST-TYPE                      
MFA-TR*          AND COMPANY_NO       = :GT-COMPANY-NO                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSMT657************'              
               DISPLAY '* 8615-UPDATE-GAS-MTR-TEST      *'              
               DISPLAY '* ERROR UPDATING CSS_GAS_MTR_TEST'              
               DISPLAY '* METER NUMBER IS ', GT-METER-NO                
               DISPLAY '* DATE TEST IS ', GT-DATE-TEST                  
               DISPLAY '* TIME TEST IS ', GT-TIME-TEST                  
               DISPLAY '* TIME PERIOD IS ', GT-CODE-TIME-PERIOD         
               DISPLAY '* CAP TYPE IS ', GT-CODE-CAP-TYPE               
               DISPLAY '* TEST TYPE IS', GT-CODE-TEST-TYPE              
T22243         DISPLAY '* COMPANY NO IS ', GT-COMPANY-NO                
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...           *'              
               DISPLAY '*************PCSMT657************'              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       8615-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8620-UPDATE-GAS-METER.                                           
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_GAS_METER                                     
               SET DATE_LAST_TESTED = IIF(TRY_CONVERT(DATE, 
                                                   :GM-DATE-LAST-TESTED
              ) IS NULL OR (PATINDEX('%.%', :GM-DATE-LAST-TESTED
              ) <> 0) OR (LEN(:GM-DATE-LAST-TESTED
              ) <> 10), CIS.CHAR2DATE(:GM-DATE-LAST-TESTED
              ), CONVERT(DATE, :GM-DATE-LAST-TESTED) )              
               WHERE CODE_UTIL_TYPE = :WS-G                             
                 AND       METER_NO = :GM-METER-NO                      
T22243           AND  COMPANY_NO    = :GM-COMPANY-NO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_GAS_METER                                             
MFA-TR*        SET DATE_LAST_TESTED = :GM-DATE-LAST-TESTED                      
MFA-TR*        WHERE CODE_UTIL_TYPE = :WS-G                                     
MFA-TR*          AND       METER_NO = :GM-METER-NO                              
MFA-TR*          AND  COMPANY_NO    = :GM-COMPANY-NO                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSMT657************'              
               DISPLAY '* 8620-UPDATE-GAS-METER         *'              
               DISPLAY '* ERROR INSERT CSS_GAS_METER    *'              
               DISPLAY '* METER NUMBER IS ', GM-METER-NO                
T22243         DISPLAY '* COMPANY NO IS ', GM-COMPANY-NO                
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...           *'              
               DISPLAY '*************PCSMT657************'              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       8620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8630-UPDATE-TEST-HIST.                                           
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_MTR_TEST_HIST                                 
                  SET  STATUS_CD       = :MQ-STATUS-CD,                 
                       TESTED_QT       = :MQ-TESTED-QT                  
                 WHERE CODE_UTIL_TYPE  = 'G'                            
                   AND TEST_YEAR       = :MQ-TEST-YEAR                  
                   AND TEST_SCHED_CD   = :MQ-TEST-SCHED-CD              
                   AND MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD            
T22243             AND COMPANY_NO      = :MQ-COMPANY-NO                 
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 16081620
           IF  SQLCODE = SUCCESSFUL-CALL                                
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSMT657**************'            
               DISPLAY '* 8630-UPDATE-TEST-HIST           *'            
               DISPLAY '* ERROR UPDATING CSS_MTR_TEST_HIST*'            
               DISPLAY '* CODE UTIL TYPE IS ', MQ-CODE-UTIL-TYPE        
               DISPLAY '* TEST SCHED CD IS  ', MQ-TEST-SCHED-CD         
               DISPLAY '* TEST GRP CD IS  ', MQ-MTR-TEST-GRP-CD         
T22243         DISPLAY '* COMPANY NO IS ', MQ-COMPANY-NO                
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...             *'            
               DISPLAY '*************PCSMT657**************'            
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       8630-EXIT.                                                       
           EXIT.                                                        
      **                                                                        
       8640-INSERT-WORK-QUEUE-ITEM.                                     
      *                                                                         
A04860     CALL SCSCB077  USING   CWS00077-FIELDS,                      
A04860                            ABEND-FILE,                           
A04860                            RS-RETURN-CODE.                       
A04860*                                                                         
A04860     MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE.   
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
A04860        DISPLAY '8640-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     ELSE                                                         
A04860        MOVE WS-77-WQ-ITEM-ID         TO WS-ITEM-ID               
A04860     END-IF.                                                      
      *                                                                         
       8640-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23990000
       8650-INSERT-MOVEMENT-HIST.                                       
      *                                                                 23990000
           EXEC SQL                                                     
               INSERT INTO CSS_MOVEMENT_HIST                            
                      ( CODE_DEVICE_TYPE,                               
                        DEVICE_NO,                                      
                        CODE_UTIL_TYPE,                                 
                        DATE_MOVE,                                      
                        LOCAL_OFFICE,                                   
                        COMPANY_NO,                                     
                        LOC_NO,                                         
                        MOVE_NO,                                        
                        CODE_CRNT_LOC )                                 
               VALUES ( 'M',                                            
                        :MV-DEVICE-NO,                                  
                        'G',                                            
                        IIF(TRY_CONVERT(DATE, :MV-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MV-DATE-MOVE
              ) <> 0) OR (LEN(:MV-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MV-DATE-MOVE
              ), CONVERT(DATE, :MV-DATE-MOVE) ),                               
                        :MV-LOCAL-OFFICE,                               
                        :MV-COMPANY-NO,                                 
                        :MV-LOC-NO,                                     
                        CIS.CURRENT$TIMESTAMP(),                              
                        :MV-CODE-CRNT-LOC )                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     13800000
MFA-TR*        INSERT INTO CSS_MOVEMENT_HIST                            13810000
MFA-TR*               ( CODE_DEVICE_TYPE,                               13820000
MFA-TR*                 DEVICE_NO,                                      13830000
MFA-TR*                 CODE_UTIL_TYPE,                                 13840000
MFA-TR*                 DATE_MOVE,                                      13850000
MFA-TR*                 LOCAL_OFFICE,                                   13860000
MFA-TR*                 COMPANY_NO,                                     13870000
MFA-TR*                 LOC_NO,                                         13880000
MFA-TR*                 MOVE_NO,                                        13890000
MFA-TR*                 CODE_CRNT_LOC )                                 13900000
MFA-TR*        VALUES ( 'M',                                            13910000
MFA-TR*                 :MV-DEVICE-NO,                                  13920000
MFA-TR*                 'G',                                            13930000
MFA-TR*                 :MV-DATE-MOVE,                                  13940000
MFA-TR*                 :MV-LOCAL-OFFICE,                               13950000
MFA-TR*                 :MV-COMPANY-NO,                                 13960000
MFA-TR*                 :MV-LOC-NO,                                     13970000
MFA-TR*                 CURRENT TIMESTAMP,                              13980000
MFA-TR*                 :MV-CODE-CRNT-LOC )                             13990000
MFA-TR*    END-EXEC.                                                    14000000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSMT657************'              
               DISPLAY '* 8650-INSERT-MOVEMENT-HIST     *'              
               DISPLAY '* ERROR INSERT CSS_MOVEMENT_HIST*'              
               DISPLAY '* METER NUMBER IS ', MV-DEVICE-NO               
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...PCSMT657   *'              
               DISPLAY '*************PCSMT657************'              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8660-UPDATE-CRNT-LOC.                                            
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_EQUIPMENT                                     
                SET DATE_LAST_MOVE  = IIF(TRY_CONVERT(DATE, 
                                                     :EQ-DATE-LAST-MOVE
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-MOVE
              ) <> 0) OR (LEN(:EQ-DATE-LAST-MOVE
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-MOVE
              ), CONVERT(DATE, :EQ-DATE-LAST-MOVE) )                
                   ,CODE_CRNT_LOC   = :EQ-CODE-CRNT-LOC                 
                   ,CRNT_LOC_NO     = :EQ-CRNT-LOC-NO                   
               WHERE CODE_UTIL_TYPE = :WS-G                             
                 AND DEVICE_NO      = :EQ-DEVICE-NO                     
T22243           AND COMPANY_NO     = :EQ-COMPANY-NO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_EQUIPMENT                                             
MFA-TR*         SET DATE_LAST_MOVE  = :EQ-DATE-LAST-MOVE                        
MFA-TR*            ,CODE_CRNT_LOC   = :EQ-CODE-CRNT-LOC                         
MFA-TR*            ,CRNT_LOC_NO     = :EQ-CRNT-LOC-NO                           
MFA-TR*        WHERE CODE_UTIL_TYPE = :WS-G                                     
MFA-TR*          AND DEVICE_NO      = :EQ-DEVICE-NO                             
MFA-TR*          AND COMPANY_NO     = :EQ-COMPANY-NO                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      **                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSMT657************'              
               DISPLAY '* 8660-UPDATE-CRNT-LOC          *'              
               DISPLAY '* ERROR UPDATING CSS_EQUIPMENT  *'              
               DISPLAY '* UTIL TYPE IS    ', WS-G                       
               DISPLAY '* METER NUMBER IS ', EQ-DEVICE-NO               
T22243         DISPLAY '* COMPANY NO IS ', EQ-COMPANY-NO                
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...           *'              
               DISPLAY '*************PCSMT657************'              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       8660-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8840-WRITE-END-REC.                                              
      *                                                                         
           MOVE COMPANY-END-REC TO FIOMT652-COMPANY-END-REC.            
           WRITE FIOMT652.                                              
      *                                                                         
       8840-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8850-WRITE-END-CONTROLS.                                         
      *                                                                         
           MOVE SPACES TO FIOMT652.                                     
           MOVE HIGH-VALUES TO E-FMT652-KEY-EREC.                       
           MOVE WS-FMT652-REC-CNTR TO E-FMT652-RECORD-COUNT-EREC.       
           WRITE FIOMT652.                                              
      *                                                                         
       8850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8900-PRODUCE-SUMMARY-REPORTS.                                    
      *                                                                         
      *    IF NO-ERRORS                                                         
      *       WRITE ERROR-RECORD FROM WS-NO-ERROR-LINE                          
      *    END-IF.                                                              
                                                                        
      *    MOVE WS-DB2-TODAYS-DATE TO CNTL-CURR-DATE.                           
           MOVE WS-DB2-TODAYS-DATE TO CNTL-TEST-DATE.                   
           DISPLAY 'NBR-MTRS = ' WS-NBR-METER-TEST-RECS.                
           MOVE WS-NBR-METER-TEST-RECS TO CNTL-IN-TEST-METERS.          
           DISPLAY 'CNTL-MTRS = ' CNTL-IN-TEST-METERS.                  
           DISPLAY 'NBR-GOOD-RECS = ' WS-NBR-GOOD-RECS.                 
           MOVE WS-NBR-GOOD-RECS   TO CNTL-GOOD-TEST-METERS.            
           DISPLAY 'CNTL-GOOD-MTRS = ' CNTL-GOOD-TEST-METERS.           
           DISPLAY 'NBR-BAD-RECS = ' WS-NBR-BAD-RECS.                   
           MOVE WS-NBR-BAD-RECS    TO CNTL-BAD-TEST-METERS.             
           DISPLAY 'CNTL-BAD-MTRS = ' CNTL-BAD-TEST-METERS.             
                                                                        
           DISPLAY 'CNTL-REC = ' CNTL-RECORD.                           
           WRITE CNTL-RECORD.                                           
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       COPY CPD00104.                                                           
      ************************************************************              
      **                                                        **              
      **  CPD00104 WILL LOAD INTO THE WORKING STORAGE           **              
      **  TABLE(CWS00104) THE DIFFERENT COMPANY NUMBERS AND     **              
      **  THE RECORD COUNTS FOR EACH COMPANY.  THIS IS TO BE    **              
      **  USED IN CONJUNCTION WITH CPD00105 WHICH WRITES THE    **              
      **  COMPANY END RECORDS USING THE TABLE CPD00104 CREATES. **              
      ************************************************************              
      *                                                                         
       COPY CPD00105.                                                           
      ************************************************************              
      **  CPD00105 WILL WRITE THE COMPANY END RECORDS USING     **              
      **  THE TABLE CREATED BY CPD00104.  CPD00104 AND CWS00104 **              
      **  ARE USED IN CONJUNCTION WITH CPD00105.                **              
      ************************************************************              
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE METER-TEST-FILE                                        
                 FCSMT652-FILE                                          
                 CNTL-FILE.                                             
                                                                        
           IF FMT652-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**      PCSMT657 PROCESSING ERROR      **'      
               DISPLAY '**  CLOSE ERROR OF FCSMT652 - OUTPUT FILE **'   
               DISPLAY '**  FILE STATUS = ' WS-FMT652-STATUS            
               DISPLAY '**        PROCESSING TERMINATED        **'      
           END-IF.                                                      
      *                                                                         
           DISPLAY '*  INPUT RECORDS = ', WS-NBR-METER-TEST-RECS.       
           DISPLAY '*  GOOD  RECORDS = ', WS-NBR-GOOD-RECS.             
           DISPLAY '*  BAD   RECORDS = ', WS-NBR-BAD-RECS.              
      *                                                                         
      *    IF WS-NBR-BAD-RECS > 0                                               
      *        EXEC SQL                                                         
      *            ROLLBACK                                                     
      *        END-EXEC                                                         
      *        MOVE +9 TO RETURN-CODE                                           
      *    END-IF.                                                              
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE                *          
      ****************************************************************          
           EXEC SQL                                                             
                INCLUDE CPD09900                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *********************  ERROR REPORT LOGIC  **********************         
      *****************************************************************         
       P1010-ERROR-REPORT.                                              
           MOVE 'Y' TO E-ERROR-SW.                                      
           MOVE METER-TEST-LO TO E-LOCAL-OFFICE.                        
           MOVE E-FMT03-METER-NO TO E-METER-NBR.                        
           MOVE E-FMT03-DATE-TEST TO E-DATE-TEST.                       
           MOVE WS-WQ-ERROR-TEXT TO E-ERROR-MESSAGE.                    
           MOVE 1 TO AFTER-NUM.                                         
           ADD AFTER-NUM TO LINE-COUNT.                                 
           IF LINE-COUNT GREATER THAN +55                               
              PERFORM P1020-E-HEADINGS THRU P1020-EXIT
           END-IF.                 
           MOVE E-DETAIL-1 TO PRINT-LINE.                               
           PERFORM P1100-PRINT-REPORT THRU P1100-EXIT.                  
           MOVE SPACES TO E-DETAIL-1.                                   
           MOVE SPACES TO WS-WQ-ERROR-TEXT.                             
       P1010-EXIT.                                                      
             EXIT.                                                      
                                                                        
       P1020-E-HEADINGS.                                                
           ADD +1 TO PAGE-COUNT.                                        
           MOVE WS-DB2-TODAYS-DATE TO E-DATE.                           
           MOVE PAGE-COUNT TO E-PAGE-COUNT.                             
           MOVE E-HEAD-1 TO PRINT-LINE.                                 
           MOVE 'Y' TO NEW-PAGE-SW.                                     
           PERFORM P1100-PRINT-REPORT THRU P1100-EXIT.                  
           MOVE +1 TO LINE-COUNT.                                       
           MOVE 'N' TO NEW-PAGE-SW.                                     
                                                                        
           MOVE E-HEAD-2 TO PRINT-LINE.                                 
           MOVE +2 TO AFTER-NUM.                                        
           PERFORM P1100-PRINT-REPORT THRU P1100-EXIT.                  
           ADD AFTER-NUM TO LINE-COUNT.                                 
                                                                        
           IF NO-ERRORS-FOUND                                           
               GO TO P1020-EXIT                                         
           END-IF.                                                      
                                                                        
           MOVE E-HEAD-3 TO PRINT-LINE.                                 
           MOVE +2 TO AFTER-NUM.                                        
           PERFORM P1100-PRINT-REPORT THRU P1100-EXIT.                  
           ADD AFTER-NUM TO LINE-COUNT.                                 
                                                                        
           MOVE SPACES TO PRINT-LINE.                                   
           MOVE +2 TO AFTER-NUM.                                        
           PERFORM P1100-PRINT-REPORT THRU P1100-EXIT.                  
           ADD AFTER-NUM TO LINE-COUNT.                                 
       P1020-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
       P1100-PRINT-REPORT.                                              
           IF PRINT-NEW-PAGE                                            
              WRITE PRINT-LINE AFTER PAGE                               
           ELSE                                                         
              WRITE PRINT-LINE AFTER AFTER-NUM                          
           END-IF.                                                      
       P1100-EXIT.                                                      
             EXIT.                                                      
      *****************************************************************         
      *****************  END OF ERROR REPORT LOGIC  *******************         
      *****************************************************************         
