       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSMT656.                                        
       DATE-WRITTEN.   SEPT. 1997.                                      
       DATE-COMPILED.                                                   
      ***************************************************************** 00050000
      **               SOUTH CAROLINA ELECTRIC & GAS                 ** 00060000
      **         COMPLETE BUSINESS SOLUTIONS INC., MADRAS            ** 00070000
      **                                                             ** 00080000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00090000
      ********                      DB2                       ********* 00100000
      ***************************************************************** 00110000
      **              PROGRAM  MODIFICATION  LOG                     ** 00120000
      **                                                             ** 00130000
      **    DATE    INITIALS     REASON                              ** 00140000
      **  ________  ________     _________________________________   ** 00150000
      **                                                             ** 00151000
TP4597**  02/03/98     CBSI     COMBINED 2 DIRECT SELECTS INTO 1     ** 00151100
TP4597**               MADRAS   CURSOR (ACCT-DET-CURSOR) TO          ** 00151200
TP4597**                        INSURE THE CORRECT ACCOUNT IS        ** 00151300
TP4597**                        SELECTED.                            ** 00152000
T14805**                                                             ** 00152100
T14805**    02/98      CBSI     ONE MORE FILE FCSRP000 IS CREATED IN ** 00152200
T14805**               MADRAS   THE PROGRAM. COPY BOOK FIORP000 IS   ** 00152300
T14805**                        CHANGED TO INCLUDE TEST DATA.        ** 00153000
T15090**                                                             ** 00154007
T15090**    04/98      CBSI     LOGIC TO CALL A SUB PROGRAM SCSCA657 ** 00155007
T15090**                        TO CREATE SERVICE ORDERS IS ADDED TO ** 00156007
T15090**                        THE PROGRAM.                         ** 00157007
T16229**                                                             ** 00154007
T16229**    05/98      CBSI     UTIL-TYPE IS ALSO PASSED TO THE CALLED* 00155007
T16229**                        PROGRAM ALONG WITH OTHER DETAILS.    ** 00156007
T17492**                                                             ** 00154007
T17492**    08/98      CBSI     CHANGES MADE TO SELECT METERS FOR    ** 00155007
T17492**                        TESTING EVEN THEY ARE NOT ACTIVE.    ** 00156007
T19653**                                                             ** 00154007
T19653**    04/99      CBSI     CHANGES MADE TO PASS ADDRESS OVERFLOW**         
T19653**                        READ ROUTE & SEQUENCE NO TO THE TEST **         
T19653**                        CARD FILE.                           **         
T20234**    06/99      CBSI     DELETED THE CODE WHICH ACCESS THE OLD**         
T20234**               MADRAS   SYSTEM TO GET THE ACCOUNT AND METER  **         
T20234**                        DETAILS AND INCLUDED LOGIC TO GET    **         
T20234**                        ACCOUNT NO FROM CPD00099.            **         
T22243**    11/17      CBSI     CHANGES MADE TO IMPLEMENT MULTI-     **         
T22243**              CHENNAI   COMPANY IN METER INVENTORY.          **         
T12999**    08/02     RNK       ADD READ CYCLE TO OUTPUT             **         
A01209**                                                             **         
A01209**    02/09     SP94986  1.INSTEAD OF JCL PARAMETER USE THE JOB**         
A01209**                        PARM PARAMETER FOR MODE=REPORT/UPDATE)*         
A01209**                                                             **         
A01209**                       2.ADDED "WITH UR" TO THE CURSORS      **         
A01209**                                                             **         
A01209**                       3.REPLACED CSS_MODEL_SQL TO SET STATS.**         
      ***************************************************************** 00160000
           REMARKS.                                                     
                              PCSMT656 NARRATIVE                        
                     SELECT GAS METERS FOR PERIODIC TESTING             
      *                                                                 00200000
                 THIS PROGRAM SELECTS GAS  METERS FOR PERIODIC          
                 TESTING. WHEN A METER IS SELECTED LAST_TEST_SEL_CD     
                 AND LAST_TEST_SEL_DT ON CSS_GAS_METER WILL BE          
                 POPULATED. A JOB PARM CAN BE USED TO RUN THE PROGRAM   
                 TO ONLY COUNT THE INSTALLED METERS, DETERMINE THE      
                 SELECTED MTRS AND CREATE THE OUTPUT FILE FOR           
                 PCSRP651, AND INSERTS ROWS INTO CSS_MTR_TEST_HIST      
                 WITH INSTALLED QTY, SELECTED QTY, STATUS CODE AND      
                 ALL THE OTHERS TO ZEROES.                              
                                                                        
      *                                                                 00320000
                    ---- BASIC BATCH SEQUENCE STRUCTURE ----            
                  0000 - 0000     MAIN CONTROL PATH                     
                  1000 - 1999     INITIALIZATION                        
                  2000 - 4999     MAJOR PROCESSING LOOP                 
                  5000 - 5999     COMMON PROGRAM MODULES                
                  7000 - 7999     SQL MODULES                           
                  8000 - 8999     OUTPUT MODULES                        
                  9000 - 9799     TERMINATION MODULES                   
                  9900 - 9999     ABEND/ABORT MODULES                   
                                                                        
      *                                                                 00440000
       ENVIRONMENT DIVISION.                                            
      *                                                                 00460000
       CONFIGURATION SECTION.                                           
      *                                                                 00460000
       SOURCE-COMPUTER. IBM-3090.                                       
       OBJECT-COMPUTER. IBM-3090.                                       
      *                                                                 00460000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                 00490000
T15090 COPY CSSMT12.                                                    00510005
T14805 COPY CSSRP000.                                                   00511000
T17492*                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
T15090 COPY CFDMT12.                                                    00550005
       COPY FIOMT12.                                                    00590000
T14805 COPY CFDRP000.                                                   00590200
T14805 COPY FIORP000.                                                   00591000
T17492*                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSMT656'.
MSQ017     COPY MFASQLM.
      *                                                                 00620000
       01  WS-START                            PIC X(40)    VALUE       
           'WORKING STORAGE FOR PCSMT656 STARTS HERE'.                  
      *                                                                 00650000
       01  PROGRAM-NAME                      PIC X(08) VALUE            
           'PCSMT656'.                                                  
      *                                                                 00680000
       COPY CWS09900.                                                   00690000
      *COPYBOOK HAVING NOT-FOUND                                        00700000
       COPY CWS00303.                                                   00710000
      *ABEND WORK AREA                                                  00720000
       COPY CWS00010.                                                   00730000
      *COPYBOOK USED BY CPD00074                                        00740000
       COPY CWS00074.                                                   00750000
       COPY FIOJC01.                                                    00760000
                                                                        
      *COPYBOOK FOR 6010-REDUCE-EMBEDDED-SPACES                         00780000
       COPY CWS00011.                                                   00790000
T20234******************************************************************        
T20234* WORKING STORAGE FOR CPD00099                                   *        
T20234******************************************************************        
T20234     EXEC SQL                                                             
T20234         INCLUDE CWS00099                                                 
T20234     END-EXEC.                                                            
      *                                                                 00800000
       01  WS-SCHEDULE-TABLE.                                           
           05  WS-ACCUM-SCHEDULE-TABLE OCCURS 25 TIMES.                 
               10  WS-ACCUM-TEST-SCHED-CD      PIC X(01).               
               10  WS-ACCUM-TEST-FREQ-MON      PIC 9(03).               
      *                                                                 00850000
       01  WS-WORK-AREA.                                                
           05  WS-DISPLAY-RC                   PIC -ZZZZZZZZ9.9.        
           05  WS-PGRMNAME                     PIC X(08) VALUE          
               'PCSMT656'.                                              
           05  WS-SUB                          PIC 9(04)    VALUE 0.    
           05  WS-NO-OF-SCHED-CDS              PIC 9(04)    VALUE 0.    
           05  RS-RETURN-CODE                  PIC S9(04)   COMP.       
           05  RS-RETURN-CODE-DISP             PIC S9(04)   COMP.       
           05  WS-NO-OF-MONTHS                 PIC S9(04)   COMP.       
           05  WS-PARM-TEST-YEAR               PIC 9(04).               
T15090     05  WS-SO-INDEX                     PIC S9(7) VALUE +0.      
T17492     05  WS-LOCAL-OFFICE.                                         
T17492         10  FILLER                      PIC X(01) VALUE '0'.     
T17492         10  WS-LOC-OFF                  PIC X(02) VALUE SPACES.  
T17492     05  WS-TEMP-RETURN-CD               PIC S9(09) COMP.         
T17492     05  WS-ACCOUNT-NO                   PIC 9(13).               
T17492     05  WS-READ-ROUTE                   PIC 9(04).               
      *                                                                 00960000
A01209     05  WS-DB2-TODAYS-DATE              PIC X(10).               
           05  WS-NEXT-TEST-DATE               PIC X(10).               
           05  WS-NEXT-TEST-DATE-RED REDEFINES WS-NEXT-TEST-DATE.       
               10  WS-NEXT-TEST-YEAR           PIC 9(04).               
               10  FILLER                      PIC X(06).               
      *                                                                 01010000
           05  WS-SWITCHES.                                             
               10  WS-DATE-LAST-TESTED-NULL    PIC S9(04) COMP VALUE 0. 
                   88  DATE-LAST-TESTED-NULL                   VALUE -1.
               10  WS-DATE-PURCHASED-NULL      PIC S9(04) COMP VALUE 0. 
                   88  DATE-PURCHASED-NULL                     VALUE -1.
               10  WS-ADDRESS-ID-NULL          PIC S9(04) COMP VALUE 0. 
                   88  ADDRESS-ID-NULL                         VALUE -1.
T15090         10  WS-INSTALL-DT-NULL          PIC S9(04) COMP VALUE 0. 
T15090             88  INSTALL-DT-NULL                         VALUE -1.
               10  WS-FMT12-STATUS             PIC X(02) VALUE '00'.    
                   88  FMT12-SUCCESS                     VALUE '00'.    
T14805         10  WS-FRP000-STATUS            PIC X(02) VALUE '00'.    
T14805             88  FRP000-SUCCESS                    VALUE '00'.    
               10  WS-NO-ACCOUNT-FOUND-FLAG    PIC X(01) VALUE 'N'.     
                   88  NO-ACCOUNT-FOUND                  VALUE 'Y'.     
               10  WS-FIRST-TIME-FLAG          PIC X(01) VALUE 'Y'.     
                   88  FIRST-TIME                        VALUE 'Y'.     
                   88  NOT-FIRST-TIME                    VALUE 'N'.     
       01  WS-NO-ACCOUNT-MSG                   PIC X(40)    VALUE       
           'NO ACCOUNT NUMBER FOUND FOR THE METER'.                     
      *                                                                 01450000
T15090 01  WS-METER-NO                         PIC X(09).               
T15090*                                                                 01450000
       01  WS-LITERALS.                                                 
           05  WS-ONE                          PIC 9(01)    VALUE 1.    
           05  WS-TWO                          PIC 9(01)    VALUE 2.    
           05  WS-THREE                        PIC 9(01)    VALUE 3.    
           05  WS-FOUR                         PIC 9(01)    VALUE 4.    
           05  WS-E                            PIC X(01)    VALUE 'E'.  
           05  WS-F                            PIC X(01)    VALUE 'F'.  
           05  WS-G                            PIC X(01)    VALUE 'G'.  
           05  WS-I                            PIC X(01)    VALUE 'I'.  
T15090     05  WS-P                            PIC X(01)    VALUE 'P'.  
           05  WS-R                            PIC X(01)    VALUE 'R'.  
           05  WS-S                            PIC X(01)    VALUE 'S'.  
           05  WS-Y                            PIC X(01)    VALUE 'Y'.  
           05  WS-N                            PIC X(01)    VALUE 'N'.  
           05  WS-YES                          PIC X(03)    VALUE 'YES'.
           05  WS-NO                           PIC X(03)    VALUE 'NO '.
           05  WS-UNKNOWN                      PIC X(08)    VALUE       
               'UNKNOWN '.                                              
           05  WS-ACTIVE                       PIC X(01)    VALUE 'A'.  
           05  WS-ZEROES                       PIC X(03)    VALUE '000'.
           05  WS-COMPANY-NO                   PIC X(02)    VALUE '01'. 
TP4597     05  WS-ACCT-FINALED-DT-NULL         PIC S9(04) COMP VALUE +0.
A01209     05  WS-UPDATE                       PIC X(06) VALUE 'UPDATE'.
A01209     05  WS-COMP-NO                      PIC X(02) VALUE '01'.    
A01209     05  WS-SYSIN-COMP-NO                PIC X(02) VALUE SPACES.  
A01209     05  WS-PARM-DATA.                                            
A01209         10 WS-PARM-FILLER              PIC X(17)  VALUE SPACES.  
A01209         10 WS-FILLER                   PIC X(63)  VALUE SPACES.  
      *                                                                 01670000
A01209     05  WS-UPDATE-FLAG                  PIC X(01)  VALUE 'N'.    
A01209         88  WS-DO-UPDATE-TABLES                    VALUE 'Y'.    
A01209*                                                                 01670000
       COPY CWS00038.                                                   01680000
       01 WS-PARAMETER-DATA REDEFINES WS-INPUT-DATA-BREAKDOWN.          
          05  WS-PARAMETER-REC.                                         
              10  WS-TEST-YEAR                 PIC X(12).               
              10  WS-TEST-YEAR-VALUE-C         PIC X(04).               
              10  FILLER  REDEFINES WS-TEST-YEAR-VALUE-C.               
                  15 WS-TEST-YEAR-VALUE        PIC 9(04).               
              10  FILLER                       PIC X(64).               
      *                                                                 01760000
T15090 01  WS-SCSCA657-LINKAGE.                                         
T16229     05  WS-SO-UTIL-TYPE                 PIC X(01).               
COB305     05 WS-NBR-METERS        PIC S9(3) COMP-3 VALUE 0.       
           05  WS-SO-DATE                      PIC X(10).               
           05  WS-SCSCA657-ARRAY       OCCURS  100 TIMES.               
COB305         10 WS-SO-ACCT-NO        PIC S9(13) COMP-3 VALUE 0.       
END            10  WS-SO-METER-NO              PIC X(9).                
T15090         10  WS-SO-TEST-TYPE             PIC X(1).                
      *                                                                 01765005
      ****************************************************************  01770000
      **     INCLUDE DCLGEN TABLE AND HOST VARIABLE DEFINITIONS     **  01780000
      ****************************************************************  01790000
      *                                                                 01800000
           EXEC SQL                                                     01810000
               INCLUDE SQLCA                                            01820000
           END-EXEC.                                                    01830000
      ****************************************************************  01831000
      *    COPYBOOK FOR CSS_EQUIPMENT,  PREFIX - EQ                  *  01832000
      ****************************************************************  01833000
           EXEC SQL                                                     01834000
               INCLUDE TBEQUIP                                          01835000
           END-EXEC.                                                    01836000
      ****************************************************************  01840000
      *    COPYBOOK FOR CSS_EQUIP_MAKE  PREFIX - M2                  *  01838004
      ****************************************************************  01839004
           EXEC SQL                                                     01839104
               INCLUDE TBEQMAKE                                         01839204
           END-EXEC.                                                    01839304
      ****************************************************************  01840000
      *    COPYBOOK FOR CSS_GAS_METER, PREFIX - GM                   *  01850000
      ****************************************************************  01860000
           EXEC SQL                                                     01870000
               INCLUDE TBGASMTR                                         01880000
           END-EXEC.                                                    01890000
      ****************************************************************  01900000
      *    COPYBOOK FOR CSS_GAS_TST_GROUP PREFIX - GG                *  01910000
      ****************************************************************  01920000
           EXEC SQL                                                     01930000
               INCLUDE TBGASGRP                                         01940000
           END-EXEC.                                                    01950000
      ****************************************************************  01960000
      *    COPYBOOK FOR CSS_TEST_SCHEDULE PREFIX - M3                *  01970000
      ****************************************************************  01980000
           EXEC SQL                                                     01990000
               INCLUDE TBTSTSCH                                         02000000
           END-EXEC.                                                    02010000
      ****************************************************************  02020000
      *    COPYBOOK FOR CSS_MTR_TEST_HIST , PREFIX - MQ              *  02030000
      ****************************************************************  02040000
           EXEC SQL                                                     02050000
               INCLUDE TBMTRTST                                         02060000
           END-EXEC.                                                    02070000
      ****************************************************************  02140000
      *    COPYBOOK FOR CSS_JOB_PARM,       PREFIX - G6              *  02150000
      ****************************************************************  02160000
           EXEC SQL                                                     02170000
               INCLUDE TBJBPARM                                         02180000
           END-EXEC.                                                    02190000
      ****************************************************************  02200000
      *    COPYBOOK FOR CSS_ACCOUNT,        PREFIX - AT              *  02210000
      ****************************************************************  02220000
           EXEC SQL                                                     02230000
               INCLUDE TBACCT                                           02240000
           END-EXEC.                                                    02250000
      ****************************************************************  02260000
      *    COPYBOOK FOR CSS_UTIL_ENVRNMT,   PREFIX - UT              *  02270000
      ****************************************************************  02280000
           EXEC SQL                                                     02290000
               INCLUDE TBUTLENV                                         02300000
           END-EXEC.                                                    02310000
      ****************************************************************  02320000
      *    COPYBOOK FOR CSS_MTRD_ENVRNMT,   PREFIX - MN              *  02330000
      ****************************************************************  02340000
           EXEC SQL                                                     02350000
               INCLUDE TBMTRENV                                         02360000
           END-EXEC.                                                    02370000
      ****************************************************************  02380000
      *    COPYBOOK FOR CSS_MTR_CAP,        PREFIX - MC              *  02390000
      ****************************************************************  02400000
           EXEC SQL                                                     02410000
               INCLUDE TBMTRCAP                                         02420000
           END-EXEC.                                                    02430000
      *                                                                 02440000
      *****TABLES REQUIRED FOR 4000-MAIL-NAME-ADDRESS                   02450000
      ****************************************************************  02460000
      *    COPYBOOK FOR CSS_NAME,           PREFIX - DQ              *  02470000
      ****************************************************************  02480000
           EXEC SQL                                                     02490000
               INCLUDE TBNAME                                           02500000
           END-EXEC.                                                    02510000
      ****************************************************************  02520000
      *    COPYBOOK FOR CSS_NAME_ACCT_XREF, PREFIX - HT              *  02530000
      ****************************************************************  02540000
           EXEC SQL                                                     02550000
               INCLUDE TBNMACTX                                         02560000
           END-EXEC.                                                    02570000
      ****************************************************************  02580000
      *    COPYBOOK FOR CSS_CUST_ADDR_XREF, PREFIX - DM              *  02590000
      ****************************************************************  02600000
           EXEC SQL                                                     02610000
               INCLUDE TBCSADRX                                         02620000
           END-EXEC.                                                    02630000
      ****************************************************************  02640000
      *    COPYBOOK FOR  CSS_ADDR_FREEFORM, PREFIX - DZ              *  02650000
      ****************************************************************  02660000
           EXEC SQL                                                     02670000
               INCLUDE TBADRFRE                                         02680000
           END-EXEC.                                                    02690000
      ****************************************************************  02700000
      *    COPYBOOK FOR CSS_ADDR_FORMATTED, PREFIX - DY              *  02710000
      ****************************************************************  02720000
           EXEC SQL                                                     02730000
               INCLUDE TBADRFMT                                         02740000
           END-EXEC.                                                    02750000
      ****************************************************************  02760000
      *    COPYBOOK FOR CSS_ZIP_CODE,       PREFIX - A4              *  02770000
      ****************************************************************  02780000
           EXEC SQL                                                     02790000
               INCLUDE TBZIPCD                                          02800000
           END-EXEC.                                                    02810000
      ****************************************************************  02820000
      *    COPYBOOK FOR CSS_ACCT_MISC_INFO, PREFIX - TA              *  02830000
      ****************************************************************  02840000
           EXEC SQL                                                     02850000
               INCLUDE TBATMISC                                         02860000
           END-EXEC.                                                    02870000
      *                                                                 02880000
      ***  END OF DCLGEN TABLE AND HOST VARIABLE DEFINITIONS            02890000
      *                                                                 02900000
      ***  SQL DECLARE STATEMENTS                                       02910000
      *                                                                 02920000
      ****************************************************************  02930000
      ** CURSOR TO SELECT TEST-SCHED-CD FROM CSS_TEST_SCHEDULE       *  02940000
      ** LKP - JAN 2000 CHANGE THE SELECTION TO SELECT JUST THE     **  03070000
      ** GROUP THAT ARE "C" IN THE TEST SCHEDULE ON TEST_SCHEDTABLE **  03070000
      ** ADDED "F"(5 YR TEST) FOR PSNC METERS                       **  03020000
      ** RNK - OCT 2004 ADDED "E"(6 MO TEST) FOR SCEG METERS        **  03020000
      ****************************************************************  02950000
      ****************************************************************  02950000
      *                                                                 02960000
           EXEC SQL                                                     
               DECLARE TEST-SCHED CURSOR FOR                            
                SELECT TEST_SCHED_CD,                                   
                       TEST_SCHED_TEXT                                  
                  FROM CSS_TEST_SCHEDULE WITH(READUNCOMMITTED)                  
LKP              WHERE TEST_SCHED_CD IN ('C', 'E', 'F')                 
              ORDER BY TEST_SCHED_CD                                    
A01209        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02970000
MFA-TR*        DECLARE TEST-SCHED CURSOR FOR                            02980000
MFA-TR*         SELECT TEST_SCHED_CD,                                   02990000
MFA-TR*                TEST_SCHED_TEXT                                  03000000
MFA-TR*           FROM CSS_TEST_SCHEDULE                                03010000
MFA-TR*          WHERE TEST_SCHED_CD IN ('C', 'E', 'F')                 03020000
MFA-TR*       ORDER BY TEST_SCHED_CD                                    03030000
MFA-TR*       FOR FETCH ONLY WITH UR                                    03030000
MFA-TR*    END-EXEC.                                                    03040000
      *                                                                 03050000
      ****************************************************************  03060000
      **            CURSOR TO SELECT METERS FOR A TEST GROUP        **  03070000
      ** LKP - JAN 2000 CHANGE THE SELECTION TO SELECT JUST THE     **  03070000
      ** GROUP THAT ARE "C" IN THE TEST SCHEDULE ON EQUIPMENT TABLE **  03070000
      ** ADDED "F"(5 YR TEST) FOR PSNC METERS                       **  03020000
      ** RNK - OCT 2004 ADDED "E"(6 MO TEST) FOR SCEG METERS        **  03020000
      ****************************************************************  03080000
      *                                                                 03090000
           EXEC SQL                                                     
              DECLARE METER-DETAILS CURSOR FOR                          
               SELECT GM.METER_NO         ,                             
T14805                EQ.SERIAL_NO        ,                             
T14805                EQ.CODE_MAKE        ,                             
T15090                EQ.INSTALL_DT       ,                             
T15090                EQ.CODE_CRNT_LOC    ,                             
T17492                EQ.CRNT_LOC_NO      ,                             
T14805                GM.NUMBER_OF_DRIVE  ,                             
T14805                GM.CASE_PRESSURE    ,                             
T14805                GM.CODE_ATTACHMENTS ,                             
T15090                GM.CCF_CAP_PER_HR   ,                             
                      GM.TEST_SCHED_CD    ,                             
                      GM.METER_SIZE_ID    ,                             
                      GM.DATE_LAST_TESTED ,                             
                      EQ.DATE_PURCHASED                                 
                 FROM CSS_GAS_METER      GM WITH(READUNCOMMITTED),              
                      CSS_EQUIPMENT      EQ WITH(READUNCOMMITTED)               
                WHERE EQ.CODE_UTIL_TYPE    = :WS-G                      
T20234            AND (EQ.CODE_CRNT_LOC     IN ('J','K'))               
LKP               AND  GM.TEST_SCHED_CD    IN ('C', 'E', 'F')           
                  AND GM.METER_NO          = EQ.DEVICE_NO               
                  AND GM.CODE_UTIL_TYPE    = EQ.CODE_UTIL_TYPE          
T22243            AND EQ.COMPANY_NO        = :EQ-COMPANY-NO             
T22243            AND EQ.COMPANY_NO        = GM.COMPANY_NO              
             ORDER BY GM.TEST_SCHED_CD                                  
A01209        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03100000
MFA-TR*       DECLARE METER-DETAILS CURSOR FOR                          03110000
MFA-TR*        SELECT GM.METER_NO         ,                             03120000
MFA-TR*               EQ.SERIAL_NO        ,                             03130000
MFA-TR*               EQ.CODE_MAKE        ,                             03130100
MFA-TR*               EQ.INSTALL_DT       ,                             03132205
MFA-TR*               EQ.CODE_CRNT_LOC    ,                             03132205
MFA-TR*               EQ.CRNT_LOC_NO      ,                             03132205
MFA-TR*               GM.NUMBER_OF_DRIVE  ,                             03131000
MFA-TR*               GM.CASE_PRESSURE    ,                             03132000
MFA-TR*               GM.CODE_ATTACHMENTS ,                             03132100
MFA-TR*               GM.CCF_CAP_PER_HR   ,                             03132205
MFA-TR*               GM.TEST_SCHED_CD    ,                             03130000
MFA-TR*               GM.METER_SIZE_ID    ,                             03140000
MFA-TR*               GM.DATE_LAST_TESTED ,                             03150000
MFA-TR*               EQ.DATE_PURCHASED                                 03160000
MFA-TR*          FROM CSS_GAS_METER      GM,                            03180000
MFA-TR*               CSS_EQUIPMENT      EQ                             03190000
MFA-TR*         WHERE EQ.CODE_UTIL_TYPE    = :WS-G                      03200000
MFA-TR*           AND (EQ.CODE_CRNT_LOC     IN ('J','K'))               03210000
MFA-TR*           AND  GM.TEST_SCHED_CD    IN ('C', 'E', 'F')           03220000
MFA-TR*           AND GM.METER_NO          = EQ.DEVICE_NO               03230000
MFA-TR*           AND GM.CODE_UTIL_TYPE    = EQ.CODE_UTIL_TYPE          03240000
MFA-TR*           AND EQ.COMPANY_NO        = :EQ-COMPANY-NO             03250000
MFA-TR*           AND EQ.COMPANY_NO        = GM.COMPANY_NO                      
MFA-TR*      ORDER BY GM.TEST_SCHED_CD                                  03260000
MFA-TR*       FOR FETCH ONLY WITH UR                                    03030000
MFA-TR*    END-EXEC.                                                    03270000
      *                                                                 03280000
TP4597***************************************************************** 03470100
TP4597* CURSOR DECLARATION       ACCT-DET-CURSOR                      * 03470200
TP4597* THE FOLLOWING SELECT IS USED TO GET ACCOUNT INFORMATION       * 03470300
TP4597***************************************************************** 03470400
TP4597     EXEC SQL                                                     
TP4597         DECLARE ACCT-DET-CURSOR CURSOR FOR                       
TP4597         SELECT  UT.ACCOUNT_NO                                    
TP4597                ,UT.RATE_PLAN_NO                                  
TP4597                ,UT.READ_ROUTE                                    
TP4597                ,UT.READ_CYCLE                                    
TP4597                ,AT.ADDRESS_ID                                    
TP4597                ,AT.LOCAL_OFFICE                                  
T19653                ,MN.REGISTER_RD_SEQ                               
TP4597           FROM  CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                
TP4597                ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
TP4597                ,CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                
TP4597          WHERE  MN.CODE_UTIL_TYPE    = :WS-G                     
TP4597            AND  MN.METER_NO          = :GM-METER-NO              
TP4597            AND  MN.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE         
TP4597            AND  MN.IC_NO             = UT.IC_NO                  
TP4597            AND  MN.ACCOUNT_NO        = UT.ACCOUNT_NO             
TP4597            AND  MN.ACCOUNT_NO        = AT.ACCOUNT_NO             
T20234            AND  MN.ACCOUNT_NO        = :MN-ACCOUNT-NO            
T17492            AND  AT.PREMISE_NO        = :EQ-CRNT-LOC-NO           
A01209        FOR READ ONLY                                     
TP4597     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03470500
MFA-TR*        DECLARE ACCT-DET-CURSOR CURSOR FOR                       03470600
MFA-TR*        SELECT  UT.ACCOUNT_NO                                    03470700
MFA-TR*               ,UT.RATE_PLAN_NO                                  03470800
MFA-TR*               ,UT.READ_ROUTE                                    03470900
MFA-TR*               ,UT.READ_CYCLE                                    03470900
MFA-TR*               ,AT.ADDRESS_ID                                    03471000
MFA-TR*               ,AT.LOCAL_OFFICE                                  03471100
MFA-TR*               ,MN.REGISTER_RD_SEQ                                       
MFA-TR*          FROM  CSS_MTRD_ENVRNMT MN                              03471500
MFA-TR*               ,CSS_UTIL_ENVRNMT UT                              03471600
MFA-TR*               ,CSS_ACCOUNT      AT                              03471700
MFA-TR*         WHERE  MN.CODE_UTIL_TYPE    = :WS-G                     03471800
MFA-TR*           AND  MN.METER_NO          = :GM-METER-NO              03471900
MFA-TR*           AND  MN.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE         03472000
MFA-TR*           AND  MN.IC_NO             = UT.IC_NO                  03472100
MFA-TR*           AND  MN.ACCOUNT_NO        = UT.ACCOUNT_NO             03472200
MFA-TR*           AND  MN.ACCOUNT_NO        = AT.ACCOUNT_NO             03472300
MFA-TR*           AND  MN.ACCOUNT_NO        = :MN-ACCOUNT-NO                    
MFA-TR*           AND  AT.PREMISE_NO        = :EQ-CRNT-LOC-NO           03472300
MFA-TR*       FOR FETCH ONLY WITH UR                                    03030000
MFA-TR*    END-EXEC.                                                    03472800
TP4597*                                                                 03473000
       01  WS-END                              PIC X(40)    VALUE       
           'WORKING STORAGE FOR PCSMT656 ENDS HERE  '.                  
                                                                        
A01209 PROCEDURE DIVISION.                                              
                                                                        
      ****************************************************************  03670000
      **                                                            **  03680000
      **  0000-MAINLINE                                             **  03690000
      **      CONTROLS MAIN PATH OF PROGRAM                         **  03700000
      **                                                            **  03710000
      ****************************************************************  03720000
       0000-MAINLINE.                                                   
      *                                                                 03740000
           PERFORM 1000-INITIALIZATION        THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-TEST-SCHED    THRU 2000-EXIT.           
           PERFORM 3000-PROCESS-PERIODIC-MTRS THRU 3000-EXIT.           
           PERFORM 8200-UPDATE-PARM           THRU 8200-EXIT.           
           PERFORM 9000-TERMINATE             THRU 9000-EXIT.           
      *                                                                 03840000
           STOP RUN.                                                    
      *                                                                 03860000
      ****************************************************************  03870000
      * INITIALIZATION ROUTINE. GETS DATE FROM JOB-PARM/CURRENT DATE *  03880000
      ****************************************************************  03890000
       1000-INITIALIZATION.                                             
      *                                                                 04110000
A01209     ACCEPT WS-SYSIN-COMP-NO             FROM SYSIN.              
A01209     MOVE   WS-SYSIN-COMP-NO             TO WS-COMP-NO.           
A01209     DISPLAY 'COMPANY NO : '    WS-COMP-NO.                       
A01209*                                                                 04130000
           INITIALIZE    DCLCSS-JOB-PARM.                               
      *                                                                 04130000
           PERFORM 1200-OPEN-OUTPUT-FILES THRU 1200-EXIT.               
           PERFORM 1100-READ-INPUT-PARM THRU 1100-EXIT.                 
A01209     MOVE WS-COMP-NO             TO GM-COMPANY-NO,                
T22243                                    G6-COMPANY-NO,                
T22243                                    MQ-COMPANY-NO,                
T22243                                    MC-COMPANY-NO,                
T22243                                    GG-COMPANY-NO,                
T22243                                    EQ-COMPANY-NO,                
                                          WS-COMPANY-NO.                
T22243     DISPLAY '*********************************'                  
T22243     DISPLAY '* JOB IS RUNNING FOR COMPANY = ', GM-COMPANY-NO     
T22243     DISPLAY '*********************************'.                 
T22243*                                                                         
      *                                                                 04160000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04190000
      ****************************************************************  04200000
      * READS THE CSS_JOB_PARM TO GET THE TEST YEAR                  *  04210000
      ****************************************************************  04220000
       1100-READ-INPUT-PARM.                                            
A01209******************************************************************        
A01209**  THIS JOB PARM ALLOWS THE PROGRAM TO RUN WITH THE ROLLBACK   **        
A01209**  OPTION TO PRODUCE THE REPORTS WITHOUT UPDATING THE DATABASE **        
A01209**  TABLES.                                                     **        
A01209******************************************************************        
A01209*                                                                         
A01209     MOVE  WS-PGRMNAME TO WS-PROGRAM.                             
A01209     MOVE  WS-PARM     TO WS-COMMAND.                             
A01209     MOVE  ZEROS       TO WS-SEQUENCE.                            
A01209     MOVE  WS-COMP-NO  TO G6-COMPANY-NO.                          
A01209     MOVE  SPACES      TO WS-SYSIPT.                              
A01209     MOVE  WS-KEY-AREA TO E-FJC01-KEY.                            
A01209     PERFORM 7600-START-FCSJC01 THRU  7600-EXIT.                  
A01209     PERFORM 7610-READ-FCSJC01 THRU  7610-EXIT                    
A01209         UNTIL (WS-INPUT-DATA-BREAKDOWN(1:17) =                   
A01209              ('RUN TYPE = UPDATE' OR 'RUN TYPE = REPORT')        
A01209                AND  INPUT-ACTIVE) OR END-OF-SYSIPT.              
A01209*                                                                         
A01209     IF  END-OF-SYSIPT                                            
A01209         DISPLAY ' '                                              
A01209         DISPLAY '** ' WS-PGRMNAME ' INFORMATIONAL MSG **'        
A01209         DISPLAY '**  JOB PARM PARM IS  NOT ACTIVE...  **'        
A01209         DISPLAY '**  DO  NOT CONTINUE PROCESSING      **'        
A01209         DISPLAY ' '                                              
A01209         PERFORM 9900-ABEND              THRU 9900-EXIT           
A01209     ELSE                                                         
A01209         DISPLAY ' '                                              
A01209         DISPLAY '** ' WS-PGRMNAME ' INFORMATIONAL MSG **'        
A01209         DISPLAY '**  JOB PARM IS ACTIVE AND  **'                 
A01209         DISPLAY '**  SET TO YES - PROCESSING CONTINUES**'        
A01209         DISPLAY '**  PARM-DATA (MODE:Y/N) : ' G6-PARM-DATA       
A01209         DISPLAY ' '                                              
A01209         MOVE G6-PARM-DATA           TO WS-PARM-DATA              
A01209         IF  WS-PARM-DATA(12:6) = WS-UPDATE                       
A01209             SET WS-DO-UPDATE-TABLES   TO TRUE                    
A01209         END-IF                                                   
A01209         PERFORM 7611-CLOSE THRU 7611-EXIT                        
A01209     END-IF.                                                      
A01209*                                                                         
A01209     PERFORM 7310-GET-DB2-TODAYS-DATE    THRU 7310-EXIT.          
A01209*                                                                         
           MOVE WS-PARM                        TO WS-COMMAND.           
           MOVE WS-PGRMNAME                    TO WS-PROGRAM.           
A01209     MOVE ZEROS                          TO WS-SEQUENCE.          
A01209     MOVE WS-COMP-NO                     TO G6-COMPANY-NO.        
A01209     MOVE SPACES                         TO WS-SYSIPT.            
A01209     MOVE WS-KEY-AREA                    TO E-FJC01-KEY.          
           PERFORM   7600-START-FCSJC01 THRU 7600-EXIT.                 
           PERFORM   7610-READ-FCSJC01 THRU 7610-EXIT                   
A01209         UNTIL (WS-INPUT-DATA-BREAKDOWN(1:12) =                   
A01209               'TEST YEAR = '  AND INPUT-ACTIVE)                  
A01209            OR END-OF-SYSIPT.                                     
      *                                                                 04280000
           IF  END-OF-SYSIPT                                            
A01209         MOVE WS-DB2-TODAYS-DATE(1:4)        TO WS-PARM-TEST-YEAR 
               GO TO 1100-EXIT                                          
           ELSE                                                         
               MOVE WS-INPUT-DATA-BREAKDOWN    TO WS-PARAMETER-DATA     
               IF  WS-TEST-YEAR-VALUE-C        NOT NUMERIC              
                   DISPLAY '*****************************************'  
                   DISPLAY '*    TEST YEAR  SHOULD BE NUMERIC IN    *'  
                   DISPLAY '*      1 ST RECORD OF CSS_JOB_PARM      *'  
                   DISPLAY '* PARM TEST YEAR : ' WS-TEST-YEAR-VALUE-C   
                   DISPLAY '*****************************************'  
                   PERFORM 9900-ABEND              THRU 9900-EXIT       
                ELSE                                                    
A01209             DISPLAY '*****************************************'  
A01209             DISPLAY '* PARM TEST YEAR : ' WS-TEST-YEAR-VALUE-C   
A01209             DISPLAY '*****************************************'  
               END-IF                                                   
               MOVE WS-TEST-YEAR-VALUE         TO WS-PARM-TEST-YEAR     
           END-IF.                                                      
           PERFORM 7611-CLOSE THRU 7611-EXIT.                           
      *                                                                 04540000
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04570000
      ****************************************************************  04580000
      * OPENS THE FILE FCSMT12 MTRS SELECTED FOR PERIODIC TESTING    *  04590000
      ****************************************************************  04600000
       1200-OPEN-OUTPUT-FILES.                                          
           OPEN OUTPUT FCSMT12-FILE.                                    
      *                                                                 04630000
           IF  FMT12-SUCCESS                                            
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '***************PCSMT656**************'          
               DISPLAY 'FCSMT12             FILE OPEN ERROR'            
               DISPLAY 'FCSMT12 FILE STATUS IS ==>' WS-FMT12-STATUS     
               DISPLAY '***************PCSMT656**************'          
           END-IF.                                                      
      *                                                                 04710000
T14805     OPEN OUTPUT FCSRP000-FILE.                                   
T14805*                                                                 04710200
T14805     IF  FRP000-SUCCESS                                           
T14805         CONTINUE                                                 
T14805     ELSE                                                         
T14805         DISPLAY '***************PCSMT656**************'          
T14805         DISPLAY 'FCSRP000            FILE OPEN ERROR'            
T14805         DISPLAY 'FCSRP000 FILE STATUS IS ==>' WS-FRP000-STATUS   
T14805         DISPLAY '***************PCSMT656**************'          
T14805     END-IF.                                                      
T14805*                                                                 04712000
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04740000
      ****************************************************************  04750000
      * READS CSS_TEST_SCHEDULE TO GET THE SCHED-CD AND FREQUENCY OF *  04760000
      * TESTING.                                                     *  04770000
      ****************************************************************  04780000
       2000-PROCESS-TEST-SCHED.                                         
           PERFORM 7000-OPEN-TEST-SCHED THRU 7000-EXIT.                 
           PERFORM 7010-FETCH-TEST-SCHED THRU 7010-EXIT.                
           PERFORM 2100-ACCUM-SCHED-DETAILS THRU 2100-EXIT              
              UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.              
           MOVE WS-SUB                         TO WS-NO-OF-SCHED-CDS.   
           PERFORM 7020-CLOSE-TEST-SCHED THRU 7020-EXIT.                
      *                                                                 04860000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04890000
      ****************************************************************  04900000
      * LOADS THE WORKING STORAGE TABL WITH SCHED-CD AND FREQUENCY OF*  04910000
      * TESTING.                                                     *  04920000
      ****************************************************************  04930000
       2100-ACCUM-SCHED-DETAILS.                                        
           ADD 1                               TO WS-SUB.               
           MOVE M3-TEST-SCHED-CD               TO                       
                                  WS-ACCUM-TEST-SCHED-CD (WS-SUB).      
           MOVE M3-TEST-SCHED-TEXT(1:3)        TO                       
                                  WS-ACCUM-TEST-FREQ-MON (WS-SUB).      
           PERFORM 7010-FETCH-TEST-SCHED THRU 7010-EXIT.                
      *                                                                 05010000
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05040000
      ****************************************************************  05050000
      * SELECTS METERS WHICH ARE SELECTED FOR PERIODIC TESTING       *  05060000
      ****************************************************************  05070000
       3000-PROCESS-PERIODIC-MTRS.                                      
      *                                                                 05090000
           PERFORM 7050-OPEN-METER-DETAILS  THRU 7050-EXIT.             
           PERFORM 7060-FETCH-METER-DETAILS THRU 7060-EXIT.             
      *                                                                 05120000
           MOVE WS-ONE                         TO WS-SUB.               
           PERFORM 3100-CALC-QUANTITIES THRU 3100-EXIT                  
               UNTIL  WS-SUB > WS-NO-OF-SCHED-CDS                       
                  OR  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.            
                                                                        
      ** THE WS-SO-INDEX SHOULD REMAIN 0 TO SUPPRESS THE                        
      ** PRINTING OF SERVICE ORDERS. LKP 01/00.                                 
T17492*                                                                         
T17492     IF  WS-SO-INDEX  >  0   AND                                  
T17492         WS-SO-INDEX  <= 100                                      
T17492         MOVE WS-G                TO WS-SO-UTIL-TYPE              
T17492         MOVE WS-DB2-TODAYS-DATE  TO WS-SO-DATE                   
T17492         COMPUTE WS-NBR-METERS    =  WS-SO-INDEX                  
T17492*********CALL 'SCSCA657' USING WS-SCSCA657-LINKAGE                        
T17492         COMPUTE WS-SO-INDEX = 0                                  
T17492     END-IF                                                       
T17492*                                                                         
           IF  MQ-SELECTED-QT > 0                                       
               PERFORM 5100-INSERT-HIST-REC THRU 5100-EXIT              
           END-IF.                                                      
           PERFORM 7070-CLOSE-METER-DETAILS THRU 7070-EXIT.             
      *                                                                 05180000
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05210000
      ****************************************************************  05220000
      * CALCULATES THE INSTALLED QTY FOR THAT TEST-SCHED-CD          *  05230000
      ****************************************************************  05240000
       3100-CALC-QUANTITIES.                                            
      *                                                                 05260000
           MOVE WS-G                           TO GG-CODE-UTIL-TYPE.    
           MOVE GM-METER-SIZE-ID               TO GG-METER-SIZE-ID.     
           MOVE GM-TEST-SCHED-CD               TO GG-MTR-TEST-GRP-CD.   
           IF  DATE-PURCHASED-NULL                                      
               MOVE SPACES                     TO EQ-DATE-PURCHASED     
           END-IF.                                                      
      *                                                                 05262700
           IF  GM-TEST-SCHED-CD NOT EQUAL MQ-TEST-SCHED-CD              
               PERFORM UNTIL WS-ACCUM-TEST-SCHED-CD (WS-SUB)            
                                              EQUAL GM-TEST-SCHED-CD    
                   ADD 1                       TO WS-SUB                
               END-PERFORM                                              
               IF  FIRST-TIME                                           
                   SET NOT-FIRST-TIME          TO TRUE                  
               ELSE                                                     
                   IF  MQ-SELECTED-QT > 0                               
                       PERFORM 5100-INSERT-HIST-REC THRU 5100-EXIT      
                   END-IF                                               
               END-IF                                                   
               MOVE GM-TEST-SCHED-CD           TO MQ-TEST-SCHED-CD      
               MOVE ZEROES                     TO MQ-INSTALLED-QT       
                                                  MQ-SELECTED-QT        
           END-IF.                                                      
           ADD 1                               TO MQ-INSTALLED-QT.      
T15090     MOVE GM-METER-NO                    TO WS-METER-NO.          
           IF  DATE-LAST-TESTED-NULL                                    
T17492         IF  INSTALL-DT-NULL                                      
T17492             IF  DATE-PURCHASED-NULL                              
T15090                 MOVE '*'                TO WS-METER-NO(1:1)      
T15090                 MOVE WS-PARM-TEST-YEAR  TO WS-NEXT-TEST-YEAR     
T15090             ELSE                                                 
T17492                 MOVE EQ-DATE-PURCHASED  TO WS-NEXT-TEST-DATE     
T15090             END-IF                                               
T15090         ELSE                                                     
T17492             MOVE EQ-INSTALL-DT          TO WS-NEXT-TEST-DATE     
T15090         END-IF                                                   
           ELSE                                                         
               MOVE GM-DATE-LAST-TESTED        TO WS-NEXT-TEST-DATE     
           END-IF.                                                      
      *                                                                 05500000
           MOVE WS-ACCUM-TEST-FREQ-MON (WS-SUB)                         
                                               TO WS-NO-OF-MONTHS       
T15090     IF  WS-METER-NO(1:1) EQUAL '*'                               
T15090         CONTINUE                                                 
T15090     ELSE                                                         
T15090         PERFORM 7400-SELECT-NEXT-TEST-DATE THRU 7400-EXIT        
T15090     END-IF.                                                      
      *                                                                 05560000
T17492     IF  WS-NEXT-TEST-YEAR <= WS-PARM-TEST-YEAR                   
T17492         MOVE WS-PARM-TEST-YEAR          TO WS-NEXT-TEST-YEAR     
               PERFORM 3110-SELECT-OTHER-DETAILS THRU 3110-EXIT         
           END-IF.                                                      
           PERFORM 7060-FETCH-METER-DETAILS THRU 7060-EXIT.             
      *                                                                 05610000
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05640000
      ****************************************************************  05650000
      * CALCULATES SELECTED QTY IF THE METERS SELECTED FOR TESTING   *  05660000
      * IN TEST-PARM-YEAR                                            *  05670000
      ****************************************************************  05680000
       3110-SELECT-OTHER-DETAILS.                                       
           ADD 1                               TO MQ-SELECTED-QT.       
           MOVE GM-TEST-SCHED-CD               TO GM-LAST-TEST-SEL-CD.  
      *                                                                 05720000
A01209     IF WS-DO-UPDATE-TABLES                                       
              PERFORM 8000-UPDATE-GAS-METER THRU 8000-EXIT              
A01209     END-IF.                                                      
      *                                                                 06020000
           MOVE +1                             TO MC-REG-ID-NO.         
           MOVE GM-METER-NO                    TO MC-METER-NO.          
           PERFORM 7300-SELECT-MTR-CAP-CONSTANT THRU 7300-EXIT.         
           IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               MOVE ZEROES                     TO MC-CONSTANT           
           END-IF.                                                      
           MOVE GM-METER-NO                    TO MN-METER-NO.          
T17492*                                                                 05720000
T20234     MOVE EQ-CRNT-LOC-NO                 TO WS-CPD99-PREMISE-NO.  
T20234     PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT.               
T20234     MOVE WS-CPD99-ACCOUNT-NO            TO MN-ACCOUNT-NO.        
      *                                                                 05750000
TP4597     PERFORM 7100-FETCH-ACCOUNT-DETAILS THRU 7100-EXIT            
      *                                                                 05760000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE WS-N                       TO                       
                                              WS-NO-ACCOUNT-FOUND-FLAG  
               MOVE UT-ACCOUNT-NO              TO AT-ACCOUNT-NO         
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                                            OR ADDRESS-ID-NULL          
                   MOVE SPACES                 TO AT-LOCAL-OFFICE       
                   MOVE ZEROES                 TO AT-ADDRESS-ID         
               END-IF                                                   
               PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT            
           ELSE                                                         
               MOVE WS-Y                TO WS-NO-ACCOUNT-FOUND-FLAG     
           END-IF.                                                      
      *                                                                 05950000
           PERFORM 3111-LOAD-FIOMT12 THRU 3111-EXIT.                    
      *                                                                 05950000
      * LKP - JANUARY 2000..DO NOT PRINT SERVICE ORDERS OR TEST CARDS   06040000
      * THIS CODE WILL CREATE THE FILE TO PRODUCE THE SERVICE           06040000
      * ORDERS. (CALL SCSCA657).                                        06040000
      * IT WAS COMMENTED OUT FOR THE JAN 2000 PERIODIC RUN.             06040000
      * COMMENT OUT TEST CARDS PER DENISE GRANT                                 
      * (LOAD FIORP000)                                                 06040000
      * RK12999 - 3/30/01: RTN 3113-CALL... WAS LEFT IN CASE IT IS      06040000
      * NEEDED IN THE FUTURE                                            06040000
T15090     IF  (GM-CCF-CAP-PER-HR NOT < 3000 ) OR                       
T15090         GM-METER-SIZE-ID = 'AL 1400' OR 'AL 2300' OR 'RTS 1.5M'  
T15090            OR 'AM 80B' OR 'AM 2M' OR 'RW 1600'                   
T15090         PERFORM 3112-LOAD-FIORP000 THRU 3112-EXIT                
T15090     ELSE                                                         
T15090         PERFORM 3113-CALL-SCSCA657-FOR-SO THRU 3113-EXIT         
T15090     END-IF.                                                      
T14805*                                                                 06042000
       3110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06070000
      ***************************************************************** 06080000
      * LOADS THE OUTPUT RECORD FIOMT12 WITH THE CORRESPONDING DETAILS* 06090000
      * LKP - THIS FILE GOES TO GMC661 AND WILL PRINT THE PAPER REPORT* 06090000
      ***************************************************************** 06100000
       3111-LOAD-FIOMT12.                                               
      *                                                                 06120000
           MOVE WS-COMPANY-NO                  TO E-FMT12-COMPANY-NO.   
           MOVE WS-PARM-TEST-YEAR              TO E-FMT12-TEST-YEAR.    
           MOVE WS-DB2-TODAYS-DATE             TO                       
                                           E-FMT12-LAST-TEST-SEL-DT.    
           MOVE GM-TEST-SCHED-CD               TO E-FMT12-TEST-SCH-CD.  
           MOVE WS-ACCUM-TEST-FREQ-MON(WS-SUB) TO                       
                                           E-FMT12-TEST-FREQ-MONTHS.    
T15090     MOVE WS-METER-NO                    TO E-FMT12-METER-NO.     
           IF  DATE-LAST-TESTED-NULL                                    
               MOVE SPACES                     TO                       
                                               E-FMT12-DATE-LAST-TESTED 
           ELSE                                                         
               MOVE GM-DATE-LAST-TESTED        TO                       
                                               E-FMT12-DATE-LAST-TESTED 
           END-IF.                                                      
           MOVE WS-NEXT-TEST-DATE              TO                       
                                               E-FMT12-SCHED-TEST-DATE. 
           MOVE GM-METER-SIZE-ID               TO E-FMT12-METER-SIZE-ID.
           MOVE MC-CONSTANT                    TO E-FMT12-CONSTANT.     
           IF  NO-ACCOUNT-FOUND                                         
               MOVE WS-NO-ACCOUNT-MSG          TO E-FMT12-NAME          
               MOVE ZEROES                     TO E-FMT12-ACCT-NO       
                                                  E-FMT12-READ-ROUTE    
               MOVE SPACES                     TO E-FMT12-SERV-ADDR     
                                                  E-FMT12-RATE          
                                                  E-FMT12-READ-CYCLE    
                                            E-FMT12-ADDR-CITY-STATE-ZIP 
           ELSE                                                         
               MOVE AT-LOCAL-OFFICE            TO E-FMT12-LOCAL-OFFICE  
               MOVE UT-ACCOUNT-NO              TO E-FMT12-ACCT-NO       
               MOVE UT-RATE-PLAN-NO            TO E-FMT12-RATE          
               MOVE WS-CUSTOMER-NAME           TO E-FMT12-NAME          
               MOVE WS-PR-STREET               TO E-FMT12-SERV-ADDR     
               MOVE WS-PR-ADDR-CITY-STATE-ZIP  TO                       
                                            E-FMT12-ADDR-CITY-STATE-ZIP 
               MOVE UT-READ-ROUTE              TO E-FMT12-READ-ROUTE    
               MOVE UT-READ-CYCLE              TO E-FMT12-READ-CYCLE    
           END-IF.                                                      
           PERFORM 8600-WRITE-FCSMT12 THRU 8600-EXIT.                   
      *                                                                 06520000
       3111-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06550000
T14805******************************************************************06550100
T14805* LOADS THE OUTPUT RECORD FIORP000 WITH THE CORRESPONDING DETAILS*06550200
T14805* LKP - THIS PRINTS THE TEST CARDS. CHECK WITH ENGINEERING TO SEE*06550200
T14805* IF THESE NEED TO BE PRINTED EVERY YEAR.                        *06550200
T14805******************************************************************06550300
T14805 3112-LOAD-FIORP000.                                              
T14805*                                                                 06550500
T14805     INITIALIZE FIORP000.                                         
T19653     MOVE 'AG3292'                       TO E-FRP000-RECORD-KEY.  
T14805     MOVE  90704                         TO E-FRP000-MESSAGE-NO.  
T14805     MOVE WS-COMPANY-NO                  TO E-RP000-COMPANY-NO.   
T14805     MOVE GM-METER-NO                    TO E-RP000-GAS-MTR-NO.   
T14805     MOVE EQ-CODE-MAKE                   TO M2-CODE-MAKE.         
T14805     PERFORM 7080-SELECT-MAKE-DESC       THRU 7080-EXIT.          
T14805     MOVE M2-EQUIP-MAKE-DESC             TO E-RP000-MAKE.         
T14805     MOVE EQ-SERIAL-NO                   TO E-RP000-GAS-SERIAL-NO.
T14805     MOVE GM-METER-SIZE-ID               TO                       
T14805                                         E-RP000-GAS-MTR-SIZE-ID. 
T14805     MOVE GM-NUMBER-OF-DRIVE             TO                       
T14805                                         E-RP000-NBR-OF-DRIVE.    
T14805     MOVE GM-CASE-PRESSURE               TO                       
T14805                                         E-RP000-CASE-PRESSURE.   
T14805     MOVE GM-CODE-ATTACHMENTS            TO                       
T14805                                         E-RP000-CODE-ATTACHMENTS.
T14805     MOVE MC-CONSTANT                    TO E-RP000-GAS-CONSTANT. 
T14805     MOVE MC-NO-DIALS                    TO E-RP000-GAS-NBR-DIALS.
T14805     IF  NO-ACCOUNT-FOUND                                         
               MOVE WS-NO-ACCOUNT-MSG          TO E-RP000-CUSTOMER-NAME 
               MOVE ZEROES                     TO E-RP000-ACCOUNT-NO    
                                                  E-RP000-GAS-READ-ROUTE
                                                  E-RP000-GAS-REG-RD-SEQ
               MOVE SPACES                     TO                       
                                             E-RP000-SERVICE-ADDRESS (1)
                                             E-RP000-SERVICE-ADDRESS (2)
                                             E-RP000-SERVICE-ADDRESS (3)
T14805     ELSE                                                         
               MOVE AT-LOCAL-OFFICE            TO E-RP000-LOCAL-OFFICE  
T14805         MOVE UT-ACCOUNT-NO              TO E-RP000-ACCOUNT-NO    
T19653         MOVE UT-READ-ROUTE              TO E-RP000-GAS-READ-ROUTE
T19653         MOVE MN-REGISTER-RD-SEQ         TO E-RP000-GAS-REG-RD-SEQ
T14805         MOVE WS-CUSTOMER-NAME           TO E-RP000-CUSTOMER-NAME 
T17492         MOVE WS-PR-STREET               TO                       
T14805                                       E-RP000-SERVICE-ADDRESS (1)
T19653         IF  WS-PR-ADDR-OVERFLOW > LOW-VALUES AND SPACES          
T19653             MOVE WS-PR-ADDR-OVERFLOW    TO                       
T14805                                   E-RP000-SERVICE-ADDRESS (2)    
T19653             MOVE WS-PR-ADDR-CITY-STATE-ZIP  TO                   
T19653                                   E-RP000-SERVICE-ADDRESS (3)    
T19653         ELSE                                                     
T19653             MOVE WS-PR-ADDR-CITY-STATE-ZIP  TO                   
T19653                                   E-RP000-SERVICE-ADDRESS (2)    
T19653             MOVE SPACES                     TO                   
T19653                                   E-RP000-SERVICE-ADDRESS (3)    
T19653         END-IF                                                   
T14805     END-IF.                                                      
T14805     PERFORM 8650-WRITE-FCSRP000 THRU 8650-EXIT.                  
T14805*                                                                 06555000
T14805 3112-EXIT.                                                       
T14805     EXIT.                                                        
T14805*                                                                 06556000
T14805******************************************************************06550100
      *** LKP - THIS PARAGRAPH PRINTS THE SERVICE ORDERS. IT WAS                
      *** COMMENTED OUT FOR JANUARY 2000 PERIODIC TEST.                         
T14805******************************************************************06550100
T15090 3113-CALL-SCSCA657-FOR-SO.                                       
ST    *                                                                 06558005
           IF  NO-ACCOUNT-FOUND                                         
               DISPLAY  WS-NO-ACCOUNT-MSG, ' ', GM-METER-NO             
           ELSE                                                         
               ADD +1                          TO WS-SO-INDEX           
               MOVE UT-ACCOUNT-NO              TO                       
                                             WS-SO-ACCT-NO(WS-SO-INDEX) 
               MOVE WS-P                       TO                       
                                           WS-SO-TEST-TYPE(WS-SO-INDEX) 
               MOVE GM-METER-NO                TO                       
                                           WS-SO-METER-NO(WS-SO-INDEX)  
               IF  WS-SO-INDEX = 100                                    
T16229             MOVE WS-G                   TO WS-SO-UTIL-TYPE       
                   MOVE WS-DB2-TODAYS-DATE     TO WS-SO-DATE            
                   COMPUTE WS-NBR-METERS = WS-SO-INDEX                  
 LKP **************CALL 'SCSCA657'   USING WS-SCSCA657-LINKAGE          06561005
                   COMPUTE WS-SO-INDEX = 0                              
               END-IF                                                   
           END-IF.                                                      
      *                                                                 06562305
END    3113-EXIT.                                                       
T15090     EXIT.                                                        
      *                                                                 06562605
      ***************************************************************** 06740000
      * INSERTING A ROW INTO MTR-TEST-HIST FOR SELECTED-QTY > 0       * 06750000
      ***************************************************************** 06760000
       5100-INSERT-HIST-REC.                                            
      *                                                                 06780000
           MOVE WS-G                           TO MQ-CODE-UTIL-TYPE.    
           MOVE WS-PARM-TEST-YEAR              TO MQ-TEST-YEAR.         
           MOVE SPACES                         TO MQ-MTR-TEST-GRP-CD.   
           MOVE WS-B                           TO MQ-STATUS-CD.         
           MOVE WS-DB2-TODAYS-DATE             TO MQ-LAST-TEST-SEL-DT.  
A01209     IF WS-DO-UPDATE-TABLES                                       
              PERFORM 8100-INSERT-MTR-TEST-HIST THRU 8100-EXIT          
A01209     END-IF.                                                      
      *                                                                 06850000
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06880000
      ****************************************************************  06890000
      * THIS INCLUDES THE READ ON CSS_JOB_PARM                       *  06900000
      ****************************************************************  06910000
           EXEC SQL                                                     06920000
                INCLUDE CPD00038                                        06930000
           END-EXEC.                                                    06940000
      *                                                                 06950000
      ****************************************************************  07020000
      * THIS INCLUDES 4000-MAIL-NAME-ADDRESS                         *  07030000
      ****************************************************************  07040000
           EXEC SQL                                                     07050000
                INCLUDE CPD00074                                        07060000
           END-EXEC.                                                    07070000
      ****************************************************************  07080000
      * THIS INCLUDES 6010-REDUCE-EMBEDDED-SPACES                    *  07090000
      ****************************************************************  07100000
           EXEC SQL                                                     07110000
                INCLUDE CPD00004                                        07120000
           END-EXEC.                                                    07130000
T20234*                                                                         
T20234******************************************************************        
T20234* 6990-FETCH-CUR-ACCOUNT                                         *        
T20234*  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.             *        
T20234******************************************************************        
T20234     EXEC SQL                                                             
T20234         INCLUDE CPD00099                                                 
T20234     END-EXEC.                                                            
T20234*                                                                         
T20234 6995-CPD99-ERROR-ROUTINE.                                        
T20234*                                                                         
T20234     DISPLAY '***************PCSMT656*******************'         
T20234     DISPLAY '* ERROR IN PARA ', ACTIVE-PARAGRAPH                 
T20234     DISPLAY '* PREMISE-NO = ', WS-CPD99-PREMISE-NO               
T20234     DISPLAY '* SQL CODE IS ', WS-CPD99-RETURN-CODE               
T20234     DISPLAY '***************PCSMT656*******************'         
T20234     PERFORM 9900-ABEND              THRU 9900-EXIT.              
T20234*                                                                         
T20234 6995-EXIT.                                                       
T20234     EXIT.                                                        
T20234*                                                                         
      ****************************************************************  07180000
      * OPENING TEST-SCHED CURSOR ON CSS_TEST_SCHEDULE               *  07190000
      ****************************************************************  07200000
       7000-OPEN-TEST-SCHED.                                            
      *                                                                 07220000
           EXEC SQL                                                     
              OPEN TEST-SCHED                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07260000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                    TO WS-DISPLAY-RC         
               DISPLAY '***************PCSMT656**************'          
               DISPLAY '* 7000-OPEN-TEST-SCHED              *'          
               DISPLAY '* ERROR OPENING CSS_TEST_SCHEDULE   *'          
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSMT656**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 07400000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07430000
      ****************************************************************  07440000
      * FETCHING TEST-SCHED CURSOR ON CSS_TEST_SCHEDULE              *  07450000
      ****************************************************************  07460000
       7010-FETCH-TEST-SCHED.                                           
      *                                                                 07480000
           EXEC SQL                                                     
              FETCH TEST-SCHED                                          
               INTO :M3-TEST-SCHED-CD,                                  
                    :M3-TEST-SCHED-TEXT                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07540000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                    TO WS-DISPLAY-RC         
               DISPLAY '***************PCSMT656**************'          
               DISPLAY '* 7010-FETCH-TEST-SCHED             *'          
               DISPLAY '* ERROR FETCHING CSS_TEST_SCHEDULE  *'          
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSMT656**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 07680000
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07710000
      ****************************************************************  07720000
      * CLOSING  TEST-SCHED CURSOR ON CSS_TEST_SCHEDULE              *  07730000
      ****************************************************************  07740000
       7020-CLOSE-TEST-SCHED.                                           
      *                                                                 07760000
           EXEC SQL                                                     
              CLOSE TEST-SCHED                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07800000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                    TO WS-DISPLAY-RC         
               DISPLAY '***************PCSMT656**************'          
               DISPLAY '* 7020-CLOSE-TEST-SCHED             *'          
               DISPLAY '* ERROR CLOSING CSS_TEST_SCHEDULE   *'          
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSMT656**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 07940000
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07970000
      ****************************************************************  07980000
      * OPENING METER-DETAILS CURSOR ON CSS_EQUIPMENT, CSS_GAS_METER *  07990000
      ****************************************************************  08000000
       7050-OPEN-METER-DETAILS.                                         
      *                                                                 08020000
           EXEC SQL                                                     
              OPEN METER-DETAILS                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08060000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                    TO WS-DISPLAY-RC         
               DISPLAY '***************PCSMT656**************'          
               DISPLAY '* 7050-OPEN-METER-DETAILS           *'          
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSMT656**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 08190000
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08220000
      ****************************************************************  08230000
      * FETCH   METER-DETAILS CURSOR ON CSS_EQUIPMENT, CSS_GAS_METER *  08240000
      ****************************************************************  08250000
       7060-FETCH-METER-DETAILS.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH  METER-DETAILS                                      
               INTO  :GM-METER-NO                                       
T14805              ,:EQ-SERIAL-NO                                      
T14805              ,:EQ-CODE-MAKE                                      
T15090              ,:EQ-INSTALL-DT :WS-INSTALL-DT-NULL                  
T15090              ,:EQ-CODE-CRNT-LOC                                  
T17492              ,:EQ-CRNT-LOC-NO                                    
T14805              ,:GM-NUMBER-OF-DRIVE                                
T14805              ,:GM-CASE-PRESSURE                                  
T14805              ,:GM-CODE-ATTACHMENTS                               
T15090              ,:GM-CCF-CAP-PER-HR                                 
                    ,:GM-TEST-SCHED-CD                                  
                    ,:GM-METER-SIZE-ID                                  
                    ,:GM-DATE-LAST-TESTED :WS-DATE-LAST-TESTED-NULL      
                    ,:EQ-DATE-PURCHASED :WS-DATE-PURCHASED-NULL        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08370000
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               NEXT SENTENCE                                            
           END-IF.                                                      
      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                    TO WS-DISPLAY-RC         
               DISPLAY '***************PCSMT656**************'          
               DISPLAY '* 7060-FETCH-METER-DETAILS          *'          
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSMT656**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 08500000
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08530000
      ****************************************************************  08540000
      * CLOSE   METER-DETAILS CURSOR ON CSS_EQUIPMENT, CSS_GAS_METER *  08550000
      ****************************************************************  08560000
       7070-CLOSE-METER-DETAILS.                                        
      *                                                                 08580000
           EXEC SQL                                                     
              CLOSE METER-DETAILS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08620000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                    TO WS-DISPLAY-RC         
               DISPLAY '***************PCSMT656**************'          
               DISPLAY '* 7070-CLOSE-METER-DETAILS          *'          
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSMT656**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 08750000
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08780000
T14805****************************************************************  08780103
T14805* SELECT MAKE DESCRIPTION FROM CSS_EQUIP_MAKE                  *  08780203
T14805****************************************************************  08780303
T14805 7080-SELECT-MAKE-DESC.                                           
T14805                                                                  
T14805     EXEC SQL                                                     
T14805        SELECT EQUIP_MAKE_DESC                                    
T14805        INTO   :M2-EQUIP-MAKE-DESC                                
T14805        FROM   CSS_EQUIP_MAKE WITH(READUNCOMMITTED)                       
T14805        WHERE  CODE_MAKE = :M2-CODE-MAKE                          
A01209                                                           
T14805     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08780603
MFA-TR*       SELECT EQUIP_MAKE_DESC                                    08780703
MFA-TR*       INTO   :M2-EQUIP-MAKE-DESC                                08780803
MFA-TR*       FROM   CSS_EQUIP_MAKE                                     08780903
MFA-TR*       WHERE  CODE_MAKE = :M2-CODE-MAKE                          08781003
MFA-TR*       WITH UR                                                   08781003
MFA-TR*    END-EXEC.                                                    08781203

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T14805                                                                  
T14805     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T14805     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
T14805         NEXT SENTENCE                                            
T14805     ELSE                                                         
T14805         MOVE SQLCODE                    TO WS-DISPLAY-RC         
T14805         DISPLAY '***************PCSMT656**************'          
T14805         DISPLAY '* 7080-SELECT-MAKE-DESC             *'          
T14805         DISPLAY '* ERROR SELECT IN CSS_TEST_SCHEDULE *'          
T14805         DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
T14805         DISPLAY '* PROGRAM ABENDING...               *'          
T14805         DISPLAY '***************PCSMT656**************'          
T14805         PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
T14805                                                                  
T14805 7080-EXIT.                                                       
T14805     EXIT.                                                        
T14805*                                                                 08782903
TP4597******************************************************************08780100
TP4597** 7100-FETCH-ACCOUNT-DETAILS                                   **08780200
TP4597**  THIS PARAGRAPH IS USED TO FETCH ACCT-DET-CURSOR             **08780300
TP4597******************************************************************08780400
TP4597 7100-FETCH-ACCOUNT-DETAILS.                                      
TP4597*                                                                 08780600
TP4597     EXEC SQL                                                     
TP4597         OPEN ACCT-DET-CURSOR                                     
TP4597     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP4597     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
TP4597                                                                  
TP4597     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
TP4597         NEXT SENTENCE                                            
TP4597     ELSE                                                         
TP4597         MOVE WS-ACTIVE-RETURN-CODE      TO WS-DISPLAY-RC         
TP4597         DISPLAY '**************** PCSMT606 *****************'    
TP4597         DISPLAY '* 7000 : RETURN CODE ERROR - OPEN         *'    
TP4597         DISPLAY '*        ACCT-DET-CURSOR           *'           
TP4597         DISPLAY '*        RC = ' WS-DISPLAY-RC                   
TP4597         DISPLAY '* PROGRAM ABENDING...                     *'    
TP4597         DISPLAY '*******************************************'    
TP4597         PERFORM 9900-ABEND  THRU  9900-EXIT
           END-IF.                     
TP4597*                                                                 08782300
TP4597     EXEC SQL                                                     
TP4597         FETCH  ACCT-DET-CURSOR                                   
TP4597           INTO  :UT-ACCOUNT-NO                                   
TP4597                ,:UT-RATE-PLAN-NO                                 
TP4597                ,:UT-READ-ROUTE                                   
TP4597                ,:UT-READ-CYCLE                                   
TP4597                ,:AT-ADDRESS-ID                                   
TP4597                ,:AT-LOCAL-OFFICE                                 
T19653                ,:MN-REGISTER-RD-SEQ                              
TP4597     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP4597     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
T17492                                             WS-TEMP-RETURN-CD.   
TP4597*                                                                 08783600
TP4597     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
TP4597         NEXT SENTENCE                                            
TP4597     ELSE                                                         
TP4597         MOVE SQLCODE TO WS-DISPLAY-RC                            
TP4597         DISPLAY '*****************PCSMT656******************'    
TP4597         DISPLAY '* 7100 : RETURN CODE ERROR - FETCH        *'    
TP4597         DISPLAY '*        RC = ' WS-DISPLAY-RC                   
TP4597         DISPLAY 'METER NO : ' GM-METER-NO                        
TP4597         DISPLAY '* PROGRAM ABENDING...                     *'    
TP4597         DISPLAY '*******************************************'    
TP4597         PERFORM 9900-ABEND  THRU  9900-EXIT                      
TP4597     END-IF.                                                      
TP4597*                                                                 08784900
TP4597     EXEC SQL                                                     
TP4597         CLOSE ACCT-DET-CURSOR                                    
TP4597     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP4597     MOVE  SQLCODE                       TO WS-ACTIVE-RETURN-CODE.
TP4597                                                                  
TP4597     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
TP4597         NEXT SENTENCE                                            
TP4597     ELSE                                                         
TP4597         MOVE SQLCODE TO WS-DISPLAY-RC                            
TP4597         DISPLAY '*****************PCSMT656******************'    
TP4597         DISPLAY '* 7020 : RETURN CODE ERROR - CLOSE        *'    
TP4597         DISPLAY '*        ACCT-DET-CURSOR           *'           
TP4597         DISPLAY '*        RC = ' WS-DISPLAY-RC                   
TP4597         DISPLAY '* PROGRAM ABENDING...                     *'    
TP4597         DISPLAY '*******************************************'    
TP4597         PERFORM 9900-ABEND  THRU  9900-EXIT                      
TP4597     END-IF.                                                      
T17492     MOVE  WS-TEMP-RETURN-CD             TO WS-ACTIVE-RETURN-CODE.
TP4597*                                                                 08786700
TP4597 7100-EXIT.                                                       
TP4597     EXIT.                                                        
      *                                                                 09650000
      ***************************************************************** 09970000
      *SELECT ON CSS_MTR_CAP TO GET THE CONSTANT                      * 09980000
      ***************************************************************** 09990000
       7300-SELECT-MTR-CAP-CONSTANT.                                    
      *                                                                 10010000
           EXEC SQL                                                     
                SELECT  CONSTANT                                        
T14805                 ,NO_DIALS                                        
                  INTO :MC-CONSTANT                                     
T14805                ,:MC-NO-DIALS                                     
                  FROM  CSS_MTR_CAP WITH(READUNCOMMITTED)                       
                 WHERE  CODE_UTIL_TYPE = :WS-G                          
                   AND  METER_NO       = :MC-METER-NO                   
                   AND  REG_ID_NO      = :MC-REG-ID-NO                  
T22243             AND  COMPANY_NO     = :MC-COMPANY-NO                 
A01209                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     10020000
MFA-TR*         SELECT  CONSTANT                                        10030000
MFA-TR*                ,NO_DIALS                                        10031000
MFA-TR*           INTO :MC-CONSTANT                                     10040000
MFA-TR*               ,:MC-NO-DIALS                                     10041000
MFA-TR*           FROM  CSS_MTR_CAP                                     10050000
MFA-TR*          WHERE  CODE_UTIL_TYPE = :WS-G                          10060000
MFA-TR*            AND  METER_NO       = :MC-METER-NO                   10070000
MFA-TR*            AND  REG_ID_NO      = :MC-REG-ID-NO                  10080000
MFA-TR*            AND  COMPANY_NO     = :MC-COMPANY-NO                         
MFA-TR*       WITH UR                                                   08781003
MFA-TR*    END-EXEC.                                                    10090000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10100000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE                    TO WS-DISPLAY-RC         
               DISPLAY '********** PCSMT656 ABORT ************'         
               DISPLAY '* 7300-SELECT-MTR-CAP-CONSTANT       *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
               DISPLAY '* METER NO IS ', MC-METER-NO                    
T22243         DISPLAY '* COMPANY_NO  = ' MC-COMPANY-NO                 
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSMT656 ABORT ************'         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 10250000
       7300-EXIT.                                                       
           EXIT.                                                        
A01209***************************************************************** 10290000
A01209* GET THE DB2- DATE                                             * 10300000
A01209***************************************************************** 10320000
A01209 7310-GET-DB2-TODAYS-DATE.                                        
A01209*                                                                 10340000
A01209     EXEC SQL                                                     
A01209       SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-DB2-TODAYS-DATE                     
A01209     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     10350000
MFA-TR*      SET :WS-DB2-TODAYS-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                    10390000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01209*                                                                 10400000
A01209     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
A01209     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
A01209         CONTINUE                                                 
A01209     ELSE                                                         
A01209         MOVE SQLCODE                    TO WS-DISPLAY-RC         
A01209         DISPLAY '********** PCSMT656 ABORT ************'         
A01209         DISPLAY '* 7310-GET-DB2-TODAYS-DATE           *'         
A01209         DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
A01209         DISPLAY '* TEST DATE  ', WS-DB2-TODAYS-DATE              
A01209         DISPLAY '* PROGRAM ABORTING...                *'         
A01209         DISPLAY '********** PCSMT656 ABORT ************'         
A01209         PERFORM 9900-ABEND                THRU 9900-EXIT         
A01209     END-IF.                                                      
A01209*                                                                 10540000
A01209 7310-EXIT.                                                       
A01209     EXIT.                                                        
      *                                                                 10572000
      ***************************************************************** 10290000
      * DUMMY SELECT ON CSS_MDEL_SQL TO ADD DATE AND NO-OF-MONTHS TO  * 10300000
      * FUTURE DATE                                                   * 10310000
      ***************************************************************** 10320000
       7400-SELECT-NEXT-TEST-DATE.                                      
      *                                                                 10340000
           EXEC SQL                                                     
A01209       SELECT
              DATEADD( MONTH, :WS-NO-OF-MONTHS, IIF(TRY_CONVERT(DATE, 
                                                     :WS-NEXT-TEST-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-NEXT-TEST-DATE
              ) <> 0) OR (LEN(:WS-NEXT-TEST-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-NEXT-TEST-DATE
              ), CONVERT(DATE, :WS-NEXT-TEST-DATE) ) )
            INTO
              :WS-NEXT-TEST-DATE  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     10350000
MFA-TR*      SET :WS-NEXT-TEST-DATE =                                           
MFA-TR*             DATE(:WS-NEXT-TEST-DATE) + :WS-NO-OF-MONTHS MONTHS  10360000
MFA-TR*    END-EXEC.                                                    10390000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10400000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE                    TO WS-DISPLAY-RC         
               DISPLAY '********** PCSMT656 ABORT ************'         
               DISPLAY '* 7400-SELECT-NEXT-TEST-DATE         *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
A01209         DISPLAY '* TEST DATE  ', WS-NEXT-TEST-DATE               
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSMT656 ABORT ************'         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 10540000
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10572000
      ***************************************************************** 10580000
      * UPDATES CSS_GAS_METER WITH CURRENT DATE & TEST-SCHED-CD       * 10590000
      ***************************************************************** 10600000
       8000-UPDATE-GAS-METER.                                           
           EXEC SQL                                                     
               UPDATE CSS_GAS_METER                                     
                  SET LAST_TEST_SEL_DT = CAST(SYSDATETIMEOFFSET() 
           AS DATE),                  
                      LAST_TEST_SEL_CD = :GM-LAST-TEST-SEL-CD           
                WHERE CODE_UTIL_TYPE = :WS-G                            
                  AND METER_NO       = :GM-METER-NO                     
T22243            AND COMPANY_NO     = :GM-COMPANY-NO                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     10620000
MFA-TR*        UPDATE CSS_GAS_METER                                     10630000
MFA-TR*           SET LAST_TEST_SEL_DT = CURRENT DATE,                  10640000
MFA-TR*               LAST_TEST_SEL_CD = :GM-LAST-TEST-SEL-CD           10650000
MFA-TR*         WHERE CODE_UTIL_TYPE = :WS-G                            10660000
MFA-TR*           AND METER_NO       = :GM-METER-NO                     10670000
MFA-TR*           AND COMPANY_NO     = :GM-COMPANY-NO                           
MFA-TR*    END-EXEC.                                                    10680000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10690000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
A01290         NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                    TO WS-DISPLAY-RC         
               DISPLAY '*************PCSMT656******************'        
               DISPLAY '* 8000-UPDATE-GAS-METER               *'        
               DISPLAY '* ERROR UPDATING CSS_GAS_METER        *'        
               DISPLAY '* UTIL TYPE IS    ', WS-G                       
               DISPLAY '* METER NUMBER IS ', GM-METER-NO                
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
T22243         DISPLAY '* COMPANY_NO  = ' GM-COMPANY-NO                 
               DISPLAY '* PROGRAM ABENDING...                 *'        
               DISPLAY '*************PCSMT656******************'        
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 10860000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10890000
      ***************************************************************** 10900000
      * INSERTS INTO CSS_MTR_TEST_HIST WITH INSTALLED & SELECTED QTS  * 10910000
      ***************************************************************** 10920000
       8100-INSERT-MTR-TEST-HIST.                                       
      *                                                                 10940000
           EXEC SQL                                                     
             INSERT INTO CSS_MTR_TEST_HIST                              
                 (CODE_UTIL_TYPE                                        
                 ,TEST_YEAR                                             
                 ,TEST_SCHED_CD                                         
                 ,MTR_TEST_GRP_CD                                       
                 ,INSTALLED_QT                                          
                 ,SELECTED_QT                                           
                 ,LAST_TEST_SEL_DT                                      
                 ,STATUS_CD                                             
T22243           ,COMPANY_NO)                                           
              VALUES                                                    
                 (:MQ-CODE-UTIL-TYPE                                    
                 ,:MQ-TEST-YEAR                                         
                 ,:MQ-TEST-SCHED-CD                                     
                 ,:MQ-MTR-TEST-GRP-CD                                   
                 ,:MQ-INSTALLED-QT                                      
                 ,:MQ-SELECTED-QT                                       
                 ,IIF(TRY_CONVERT(DATE, :MQ-LAST-TEST-SEL-DT
              ) IS NULL OR (PATINDEX('%.%', :MQ-LAST-TEST-SEL-DT
              ) <> 0) OR (LEN(:MQ-LAST-TEST-SEL-DT
              ) <> 10), CIS.CHAR2DATE(:MQ-LAST-TEST-SEL-DT
              ), CONVERT(DATE, :MQ-LAST-TEST-SEL-DT) )                         
                 ,:MQ-STATUS-CD                                         
T22243           ,:MQ-COMPANY-NO)                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     10950000
MFA-TR*      INSERT INTO CSS_MTR_TEST_HIST                              10960000
MFA-TR*          (CODE_UTIL_TYPE                                        10970000
MFA-TR*          ,TEST_YEAR                                             10980000
MFA-TR*          ,TEST_SCHED_CD                                         10990000
MFA-TR*          ,MTR_TEST_GRP_CD                                       11000000
MFA-TR*          ,INSTALLED_QT                                          11010000
MFA-TR*          ,SELECTED_QT                                           11020000
MFA-TR*          ,LAST_TEST_SEL_DT                                      11030000
MFA-TR*          ,STATUS_CD                                             11040000
MFA-TR*          ,COMPANY_NO)                                                   
MFA-TR*       VALUES                                                    11050000
MFA-TR*          (:MQ-CODE-UTIL-TYPE                                    11060000
MFA-TR*          ,:MQ-TEST-YEAR                                         11070000
MFA-TR*          ,:MQ-TEST-SCHED-CD                                     11080000
MFA-TR*          ,:MQ-MTR-TEST-GRP-CD                                   11090000
MFA-TR*          ,:MQ-INSTALLED-QT                                      11100000
MFA-TR*          ,:MQ-SELECTED-QT                                       11110000
MFA-TR*          ,:MQ-LAST-TEST-SEL-DT                                  11120000
MFA-TR*          ,:MQ-STATUS-CD                                         11130000
MFA-TR*          ,:MQ-COMPANY-NO)                                               
MFA-TR*    END-EXEC.                                                    11140000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11150000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                    TO WS-DISPLAY-RC         
               DISPLAY '*************PCSMT656******************'        
               DISPLAY '* 8100-INSERT-MTR-TEST-HIST           *'        
               DISPLAY '* ERROR UPDATING CSS_MTR_TEST_HIST    *'        
               DISPLAY '* UTIL TYPE IS    ', WS-G                       
               DISPLAY '* TEST_YEAR       ', MQ-TEST-YEAR               
               DISPLAY '* TEST_SCHED_CD   ', MQ-TEST-SCHED-CD           
               DISPLAY '* MTR_TEST_GRP_CD ', MQ-MTR-TEST-GRP-CD         
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
T22243         DISPLAY '* COMPANY_NO  = ' MQ-COMPANY-NO                 
               DISPLAY '* PROGRAM ABENDING...                 *'        
               DISPLAY '*************PCSMT656******************'        
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 11340000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11370000
A01209***************************************************************** 06560000
A01209* UPDATION OF JOB-PARM ROWS WITH STATUS = 'I'                   * 06570000
A01209***************************************************************** 06580000
A01209 8200-UPDATE-PARM.                                                
A01209*                                                                 06730000
A01209     EXEC SQL                                                     
A01209          UPDATE CSS_JOB_PARM                                     
A01209          SET STATUS         = :WS-I                              
A01209          WHERE COMPANY_NO   = :G6-COMPANY-NO                     
A01209            AND PROGRAM_NAME = :G6-PROGRAM-NAME                   
A01209            AND CMND_CODE    = :G6-CMND-CODE                      
A01209     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01209     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
A01209     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
A01209         NEXT SENTENCE                                            
A01209     ELSE                                                         
A01209         MOVE SQLCODE                    TO WS-DISPLAY-RC         
A01209         DISPLAY '*************PCSMT656******************'        
A01209         DISPLAY '* 8200-UPDATE-PARM                *'            
A01209         DISPLAY '* ERROR UPDATING CSS_JOB_PARM         *'        
A01209         DISPLAY '* PROGRAM NAME    ', WS-PGRMNAME                
A01209         DISPLAY '* CMP NO          '                             
A01209         DISPLAY '* CMND_CODE       ', WS-PARM                    
A01209         DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
A01209         DISPLAY '* PROGRAM ABENDING...                 *'        
A01209         DISPLAY '*************PCSMT656******************'        
A01209         PERFORM 9900-ABEND THRU 9900-EXIT                        
A01209     END-IF.                                                      
A01209*                                                                 12270000
A01209 8200-EXIT.                                                       
A01209     EXIT.                                                        
A01209*                                                                 06730000
      ***************************************************************** 12610000
      * WRITING PERIODIC TESTED MTR DETAILS TO FCSMT12 FILE           * 12620000
      ***************************************************************** 12630000
       8600-WRITE-FCSMT12.                                              
           WRITE FIOMT12.                                               
      *                                                                 12660000
           IF  FMT12-SUCCESS                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*************PCSMT656******************'        
               DISPLAY 'FCSMT12 FILE WRITE ERROR'                       
               DISPLAY 'FCSMT12 FILE STATUS ==>' WS-FMT12-STATUS        
               DISPLAY '*************PCSMT656******************'        
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12750000
      ***************************************************************** 12760000
T14805* WRITING RECORDS TO FCSRP000 FILE                              * 12750200
T14805***************************************************************** 12750300
T14805 8650-WRITE-FCSRP000.                                             
T14805     WRITE FIORP000.                                              
T14805*                                                                 12750600
T14805     IF  FRP000-SUCCESS                                           
T14805         NEXT SENTENCE                                            
T14805     ELSE                                                         
T14805         DISPLAY '*************PCSMT656******************'        
T14805         DISPLAY 'FCSRP000 FILE WRITE ERROR'                      
T14805         DISPLAY 'FCSRP000 FILE STATUS ==>' WS-FRP000-STATUS      
T14805         DISPLAY '*************PCSMT656******************'        
T14805         PERFORM 9900-ABEND THRU 9900-EXIT                        
T14805     END-IF.                                                      
T14805 8650-EXIT.                                                       
T14805     EXIT.                                                        
T14805*                                                                 12751800
      ***************************************************************** 12760000
      * TERMINATING ROUTINE, CLOSES THE FILE                          * 12770000
      ***************************************************************** 12780000
       9000-TERMINATE.                                                  
      *                                                                 12800000
           CLOSE FCSMT12-FILE.                                          
      *                                                                 12820000
           IF  FMT12-SUCCESS                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*************PCSMT656******************'        
               DISPLAY 'FCSMT12  FILE CLOSE ERROR'                      
               DISPLAY 'FCSMT12 FILE STATUS ==>' WS-FMT12-STATUS        
               DISPLAY '*************PCSMT656******************'        
           END-IF.                                                      
      *                                                                 12890000
T14805     CLOSE FCSRP000-FILE.                                         
T14805*                                                                 12882000
T14805     IF  FRP000-SUCCESS                                           
T14805         NEXT SENTENCE                                            
T14805     ELSE                                                         
T14805         DISPLAY '*************PCSMT656******************'        
T14805         DISPLAY 'FCSRP000 FILE CLOSE ERROR'                      
T14805         DISPLAY 'FCSRP000 FILE STATUS ==>' WS-FRP000-STATUS      
T14805         DISPLAY '*************PCSMT656******************'        
T14805     END-IF.                                                      
T17492*                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12970000
      **************************************************************    12971000
      * THIS INCLUDES 9700-PROCESS-ABEND                           *    12972000
      **************************************************************    12973000
       COPY CPD0023B.                                                   12980000
      **************************************************************    12990000
      *     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE          *    13000000
      **************************************************************    13010000
           EXEC SQL                                                     13020000
             INCLUDE CPD09900                                           13030000
           END-EXEC.                                                    13040000
      *                                                                 13050000
