       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSMT654.                                        
       DATE-WRITTEN.   JAN 11,2011.                                     
       DATE-COMPILED.                                                   
      ****************************************************************          
      **                                                            **          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                      DB2                       ********          
      ****************************************************************          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      **           DATE    INITIALS       REASON                    **          
      **         ________  ________   _____________________________ **          
      **         01/11/11  SS95855    P00462 SMARTSYNCH             **          
P00462**         03/11/11  SS95855    CREATE MULTIPLE ATTACHMENTS   **          
P00462**                              ONLY FOR ERT ATT TYPE.        **          
      ****************************************************************          
           REMARKS.                                                     
                              PCSMT654 NARRATIVE                        
                     MARRY ELECTRIC METERS AND ATTACHMENTS              
                                                                        
         This program will link existing meters and attachments by      
         creating a record in the css_meter_attchmts table. Only        
         attachments with code_device_type 'Q' can use this program.    
         This means they are in the CSS_equip_attchmts table.           
                                                                        
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSMT54.                                                            
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDMT54.                                                            
       COPY FIOMT54.                                                            
      *                                                                         
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSMT654'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                          PIC X(40) VALUE            
             'WORKING STORAGE FOR PCSMT654 STARTS HERE'.                
      *                                                                         
       01  PROGRAM-NAME                      PIC X(08) VALUE 'PCSMT654'.
      *                                                                         
       01  WS-WORK-AREA.                                                
           05  WS-CODE-VALUE                 PIC X(10) VALUE SPACES.    
           05  WS-HOW-CONN-SUB               PIC 9(02) VALUE 0.         
           05  WS-COLUMN-NA                  PIC X(18) VALUE SPACES.    
           05  WS-TABLE-NA                   PIC X(18) VALUE SPACES.    
           05  WS-DB2-TODAYS-DATE            PIC X(10) VALUE SPACES.    
      *                                                                         
           05  WS-HOLD-VARIABLES.                                       
               10  WS-ATTCHMNT-NO            PIC 9(12) VALUE ZERO.      
               10  WS-ATTCHMNT-NO1           PIC 9(12) VALUE ZERO.      
               10  WS-ATTCHMNT-NO2           PIC 9(12) VALUE ZERO.      
               10  WS-NEW-EQUIP-LOCTN-ID     PIC X(01) VALUE SPACES.    
               10  WS-NEW-MTR-STO-FAC-CD     PIC X(03) VALUE SPACES.    
               10  WS-NEW-DATE-LAST-MOVE     PIC X(10) VALUE SPACES.    
               10  WS-NEW-DATE-PURCHASED     PIC X(10) VALUE SPACES.    
               10  WS-NEW-EQUIP-LOCTN-ID-1   PIC X(01) VALUE SPACES.    
               10  WS-NEW-MTR-STO-FAC-CD-1   PIC X(03) VALUE SPACES.    
               10  WS-NEW-DATE-LAST-MOVE-1   PIC X(10) VALUE SPACES.    
               10  WS-NEW-DATE-PURCHASED-1   PIC X(10) VALUE SPACES.    
               10  WS-NEW-EQUIP-LOCTN-ID-2   PIC X(01) VALUE SPACES.    
               10  WS-NEW-MTR-STO-FAC-CD-2   PIC X(03) VALUE SPACES.    
               10  WS-NEW-DATE-LAST-MOVE-2   PIC X(10) VALUE SPACES.    
               10  WS-NEW-DATE-PURCHASED-2   PIC X(10) VALUE SPACES.    
               10  WS-NEW-EQUIP-LOCTN-ID-3   PIC X(01) VALUE SPACES.    
               10  WS-NEW-MTR-STO-FAC-CD-3   PIC X(03) VALUE SPACES.    
               10  WS-NEW-DATE-LAST-MOVE-3   PIC X(10) VALUE SPACES.    
               10  WS-NEW-DATE-PURCHASED-3   PIC X(10) VALUE SPACES.    
               10  WS-TEMP-DEVICE-NO         PIC X(12) VALUE SPACES.    
               10  WS-TEMP-CODE-ATT-TYPE     PIC X(02) VALUE SPACES.    
               10  WS-MA-LAST-TEST-IND       PIC S9(04) COMP VALUE 0.   
               10  WS-EQUIP-ATTACH-DT-IND    PIC S9(04) COMP VALUE 0.   
               10  WS-DT-LST-MOVE-IND        PIC S9(04) COMP VALUE 0.   
               10  WS-DT-PURCHASE-IND        PIC S9(04) COMP VALUE 0.   
               10  WS-ERR-IDX                PIC S9(04) COMP VALUE 0.   
               10  WS-SUB                    PIC S9(04) COMP VALUE 0.   
               10  WS-DEL-IDX                PIC S9(04) COMP VALUE 0.   
               10  WS-ERROR-ARRAY-SIZE       PIC S9(04) COMP VALUE 0.   
               10  WS-FRMT-ATT               PIC X(12) VALUE SPACES.    
               10  WS-DISPLAY-RC             PIC -ZZZZZ9.               
      *                                                                         
           05  WS-FLAGS.                                                
               10  WS-FCSMT54-STATUS         PIC X(02).                 
                   88  FCSMT54-SUCCESSFUL              VALUE '00'.      
                   88  FCSMT54-READ-EOF                VALUE '10'.      
               10  WS-MT654-EOF              PIC X(01) VALUE 'N'.       
                   88  EOF-REACHED                     VALUE 'Y'.       
               10  WS-RECORD-FLAG            PIC X(01) VALUE 'N'.       
                   88  GOOD-RECORD                     VALUE 'N'.       
               10  NO-ERROR-FOUND            PIC X(01) VALUE 'Y'.       
                   88  ERROR-FOUND                     VALUE 'N'.       
               05  WS-CODE-VAL-MATCH         PIC X(01) VALUE 'N'.       
                   88  WS-CODE-VAL-NOT-MATCHED         VALUE 'N'.       
                   88  WS-CODE-VAL-MATCHED             VALUE 'Y'.       
               05  WS-CT-PT-FLAG             PIC X(01) VALUE 'N'.       
                   88  WS-CT-PT-ATTACHED               VALUE 'Y'.       
                   88  WS-CT-PT-NOT-ATTACHED           VALUE 'N'.       
               05  WS-ATT-TYPE               PIC X(01) VALUE 'N'.       
                   88  WS-ATT-TYPE-EXISTS              VALUE 'Y'.       
                   88  WS-ATT-TYPE-NOT-EXISTS          VALUE 'N'.       
      *                                                                         
      * TABLE TO STORE HOW CONNECTED CODE VALUES                                
           05 WS-HOW-CONN-VAL-TAB.                                      
              10 WS-HOW-CONN-VAL-ROW OCCURS 10 TIMES                    
                              INDEXED BY WS-CONN-INDX.                  
                 15 WS-TAB-HOW-CONN-VAL      PIC X(01).                 
      *                                                                         
      * TABLE TO STORE EXISTING ATTACHMENTS                                     
       01  EXISTING-ATTACHMENTS.                                        
           05  EXIST-ATTCH OCCURS 10  TIMES.                            
               10  EXIST-DEVICE-NO           PIC X(12).                 
               10  EXIST-CODE-ATT-TYPE       PIC X(02).                 
      *                                                                         
      * TABLE TO STORE ERROR REPORT                                             
       01  ERROR-HOLD-AREA.                                             
           05  ERROR-ARRAY OCCURS 100 TIMES.                            
               10  ERR-ATT-TYP               PIC X(02).                 
               10  ERR-MTR-NO                PIC X(09).                 
               10  ERR-ATT-NO                PIC X(12).                 
               10  ERR-FIELD                 PIC X(20).                 
               10  ERR-PROBLEM               PIC X(43).                 
      *                                                                         
       01  WS-HDR-ONE.                                                  
           05 FILLER                         PIC X(08) VALUE            
              'PCSMT654'.                                               
           05 FILLER                         PIC X(39) VALUE SPACES.    
           05 WS-COMPANY-NAME                PIC X(39) VALUE SPACES.    
           05 FILLER                         PIC X(30) VALUE SPACES.    
           05 FILLER                         PIC X(06) VALUE            
              'PAGE: '.                                                 
           05 FILLER                         PIC X(06) VALUE SPACES.    
           05 WS-DET-PAGE                    PIC ZZZZ  VALUE SPACES.    
      *                                                                         
       01  WS-HDR-TWO.                                                  
           05 FILLER                         PIC X(50) VALUE SPACES.    
           05 FILLER                         PIC X(30) VALUE            
              'ELECTRIC METER ADDITION ERRORS'.                         
           05 FILLER                         PIC X(36) VALUE SPACES.    
           05 FILLER                         PIC X(06) VALUE            
              'DATE: '.                                                 
           05 WS-RUN-DATE                    PIC X(10) VALUE SPACES.    
      *                                                                         
       01  WS-HDR-THREE.                                                
           05 FILLER                         PIC X(05) VALUE SPACES.    
           05 FILLER                         PIC X(09) VALUE            
              'ATTCH TYP'.                                              
           05 FILLER                         PIC X(05) VALUE SPACES.    
           05 FILLER                         PIC X(08) VALUE            
              'METER NO'.                                               
           05 FILLER                         PIC X(05) VALUE SPACES.    
           05 FILLER                         PIC X(09) VALUE            
              'ATTCHT NO'.                                              
           05 FILLER                         PIC X(08) VALUE SPACES.    
           05 FILLER                         PIC X(11) VALUE            
              'ERROR FIELD'.                                            
           05 FILLER                         PIC X(20) VALUE SPACES.    
           05 FILLER                         PIC X(12) VALUE            
              'PROBLEM DESC'.                                           
      *                                                                         
       01  WS-FOOT-LINE.                                                
           05 FILLER                         PIC X(55) VALUE SPACES.    
           05 FILLER                         PIC X(22) VALUE            
              '*** END OF  REPORT ***'.                                 
           05 FILLER                         PIC X(55) VALUE SPACES.    
      *                                                                         
       01  WS-NO-ERROR-LINE.                                            
           05 FILLER                         PIC X(55) VALUE SPACES.    
           05 FILLER                         PIC X(23) VALUE            
              '*** NO ERRORS FOUND ***'.                                
           05 FILLER                         PIC X(54) VALUE SPACES.    
      *                                                                         
       01 WS-DET-LINE-1.                                                
          05  FILLER                         PIC X(08) VALUE SPACES.    
          05  WS-RPT-ATTCH-TYP               PIC X(02).                 
          05  FILLER                         PIC X(09) VALUE SPACES.    
          05  WS-RPT-METER-NO                PIC X(09).                 
          05  FILLER                         PIC X(04) VALUE SPACES.    
          05  WS-RPT-ATTCH-NO                PIC X(12).                 
          05  FILLER                         PIC X(05) VALUE SPACES.    
          05  WS-RPT-ERROR-FIELD             PIC X(20).                 
          05  FILLER                         PIC X(11) VALUE SPACES.    
          05  WS-RPT-PROBLEM-DESC            PIC X(43).                 
      *                                                                         
       01 WS-DET-LINE-2.                                                
          05  FILLER                         PIC X(05) VALUE SPACES.    
          05  WS-RPT-MESSAGE                 PIC X(20) VALUE SPACES.    
          05  FILLER                         PIC X(03)                  
              VALUE ':  '.                                              
          05  WS-RPT-STATISTICS              PIC ZZZZ9 VALUE SPACES.    
      *                                                                         
       01  WS-ERROR-RPT-MSGS.                                           
           05 WS-TOT-RECDS-INFO              PIC X(18) VALUE            
              ' TOTAL I/P RECORDS'.                                     
           05 WS-TOT-GOOD-RECDS              PIC X(13) VALUE            
              ' GOOD RECORDS'.                                          
           05 WS-TOT-BAD-RECDS               PIC X(12) VALUE            
              ' BAD RECORDS'.                                           
           05 WS-TOT-UNADDED-MTRS            PIC X(17) VALUE            
              ' NOT ADDED METERS'.                                      
      *                                                                         
       01  WS-VARIABLES.                                                
           05 WS-LINE-CNTR                   PIC 9(02) VALUE 57.        
           05 WS-BLANK-LINE                  PIC X(132) VALUE SPACES.   
           05 WS-PAGE                        PIC 9(04) VALUE ZEROS.     
           05 WS-LINE-SPACE                  PIC 9(01) VALUE ZERO.      
      *                                                                         
       01  WS-COUNTERS.                                                 
           05 WS-NBR-METER-RECS              PIC S9(5) COMP-3 VALUE 0.  
           05 WS-NBR-GOOD-RECS               PIC S9(5) COMP-3 VALUE 0.  
           05 WS-NBR-BAD-RECS                PIC S9(5) COMP-3 VALUE 0.  
           05 WS-NO-ADDITION-MTRS            PIC S9(5) COMP-3 VALUE 0.  
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-ONE                        PIC 9(01) VALUE 1.         
           05  WS-CMP-NO                     PIC X(02) VALUE '01'.      
           05  WS-TWO                        PIC 9(01) VALUE 2.         
           05  WS-SIX                        PIC 9(01) VALUE 6.         
           05  WS-FIFTY-SIX                  PIC 9(02) VALUE 56.        
           05  WS-FIFTY-TWO                  PIC 9(02) VALUE 52.        
           05  WS-A                          PIC X(01) VALUE 'A'.       
           05  WS-B                          PIC X(01) VALUE 'B'.       
           05  WS-C                          PIC X(01) VALUE 'C'.       
           05  WS-K                          PIC X(01) VALUE 'K'.       
           05  WS-J                          PIC X(01) VALUE 'J'.       
           05  WS-M                          PIC X(01) VALUE 'M'.       
           05  WS-N                          PIC X(01) VALUE 'N'.       
           05  WS-Q                          PIC X(01) VALUE 'Q'.       
           05  WS-Z                          PIC X(01) VALUE 'Z'.       
           05  WS-ATT-TYPE-ERT               PIC X(02) VALUE 'IT'.      
           05  WS-ATT-TYPE-SMARTSYNCH        PIC X(02) VALUE 'SS'.      
           05  WS-ATT-TYPE-KBASE             PIC X(02) VALUE 'KA'.      
           05  WS-CURRENT-XFORMER-CT         PIC X(02) VALUE 'CT'.      
           05  WS-POTENTIAL-XFORMER-PT       PIC X(02) VALUE 'PT'.      
           05  WS-DEFAULT-DATE               PIC X(10) VALUE            
                                                       '1900-01-01'.    
      *                                                                         
      *** Support DB2 SQL error checking                                        
       COPY CWS00303.                                                           
      *                                                                         
      *** Abend Switch Copybook                                                 
       COPY CWS09900.                                                           
      *                                                                         
      *** Include DCLGEN Table and Host Variable definitions                    
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      *** CSS_CODE_VALUE, UV                                                    
           EXEC SQL                                                             
               INCLUDE TBCDVALU                                                 
           END-EXEC.                                                            
      *                                                                         
      *** CSS_COMPANY, C7                                                       
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
      *** CSS_EQUIPMENT, EQ                                                     
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      *                                                                         
      *** CSS_EQUIP_ATTCHMTS, LX                                                
           EXEC SQL                                                             
               INCLUDE TBEQATTH                                                 
           END-EXEC.                                                            
      *                                                                         
      *** CSS_METER_ATTCHMTS, MA                                                
           EXEC SQL                                                             
               INCLUDE TBMTRATT                                                 
           END-EXEC.                                                            
      *                                                                         
      *** CSS_EQUIP_ATT_MOVE, MP                                                
           EXEC SQL                                                             
               INCLUDE TBEQMOVE                                                 
           END-EXEC.                                                            
      *                                                                         
      *** CSS_MTR_ATT_TYPE, N5                                                  
           EXEC SQL                                                             
               INCLUDE TBMTRATP                                                 
           END-EXEC.                                                            
      *                                                                         
      *** CSS_ELEC_MTR_SPEC, U5                                                 
           EXEC SQL                                                             
               INCLUDE TBEMTRSP                                                 
           END-EXEC.                                                            
      *                                                                         
      *** CSS_ELEC_METER, EM                                                    
           EXEC SQL                                                             
               INCLUDE TBELMTR                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **   SQL DECLARE STATEMENTS                                    **         
      *****************************************************************         
      *----------------------------------------------------------------*        
      * CURSOR TO GET DATA FROM CODE_VALUE TABLE FOR MULTIPLE PURPOSES          
      *----------------------------------------------------------------*        
           EXEC SQL                                                     
               DECLARE CODE_VAL_CSR CURSOR FOR                          
                   SELECT CODE_VALUE                                    
                    FROM  CSS_CODE_VALUE WITH(READUNCOMMITTED)                  
                   WHERE COMPANY_NO = :WS-CMP-NO                        
                     AND TABLE_NA   = :WS-TABLE-NA                      
                     AND COLUMN_NA  = :WS-COLUMN-NA                     
                     AND PROGRAM_ID = 'ALL'                             
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CODE_VAL_CSR CURSOR FOR                                  
MFA-TR*            SELECT CODE_VALUE                                            
MFA-TR*             FROM  CSS_CODE_VALUE                                        
MFA-TR*            WHERE COMPANY_NO = :WS-CMP-NO                                
MFA-TR*              AND TABLE_NA   = :WS-TABLE-NA                              
MFA-TR*              AND COLUMN_NA  = :WS-COLUMN-NA                             
MFA-TR*              AND PROGRAM_ID = 'ALL'                                     
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7610                                                     
MFA-TR*    END-EXEC.                                                            
      ***                                                                       
      *----------------------------------------------------------------*        
      * CURSOR TO GET CHECK EXISTING ATTACHMENTS FOR VALIDATION                 
      *----------------------------------------------------------------*        
           EXEC SQL                                                     
               DECLARE CHECK_EXIST_ATT_CSR CURSOR FOR                   
               SELECT  DEVICE_NO                                        
                      ,CODE_ATT_TYPE                                    
               FROM    CSS_METER_ATTCHMTS WITH(READUNCOMMITTED)                 
               WHERE   METER_NO       = :MA-METER-NO                    
                 AND   CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE              
                 AND   COMPANY_NO     = :MA-COMPANY-NO                  
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CHECK_EXIST_ATT_CSR CURSOR FOR                           
MFA-TR*        SELECT  DEVICE_NO                                                
MFA-TR*               ,CODE_ATT_TYPE                                            
MFA-TR*        FROM    CSS_METER_ATTCHMTS                                       
MFA-TR*        WHERE   METER_NO       = :MA-METER-NO                            
MFA-TR*          AND   CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                      
MFA-TR*          AND   COMPANY_NO     = :MA-COMPANY-NO                          
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7810                                                     
MFA-TR*    END-EXEC.                                                            
      ***                                                                       
       01  WS-END                      PIC X(40)    VALUE               
             'WORKING STORAGE FOR PCSMT654 ENDS HERE  '.                
      *                                                                         
       PROCEDURE DIVISION.                                              
                                                                        
      ****************************************************************          
      **                                                            **          
      **  0000-MAINLINE                                             **          
      **      CONTROLS MAIN PATH OF PROGRAM                         **          
      **                                                            **          
      ****************************************************************          
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
      *                                                                         
           PERFORM 1000-PROCESS-FILE             THRU 1000-EXIT         
               UNTIL EOF-REACHED.                                       
                                                                        
           PERFORM 8900-PRODUCE-SUMMARY-REPORTS  THRU 8900-EXIT.        
      *                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0100-INITIALIZATION.                                             
      *================================================================*        
      *                                                                         
           OPEN INPUT  FCSMT54-FILE                                     
                OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           PERFORM 0200-INITIALIZE               THRU 0200-EXIT.        
      *                                                                         
           MOVE WS-CMP-NO              TO  C7-COMPANY-NO.               
           PERFORM 7500-SELECT-COMP-NAME         THRU 7500-EXIT.        
           MOVE C7-COMPANY-NAME        TO WS-COMPANY-NAME.              
                                                                        
           PERFORM 7550-GET-CURRENT-DATE         THRU 7550-EXIT.        
                                                                        
           PERFORM 0300-GET-HOW-CONN-VAL         THRU 0300-EXIT.        
      *                                                                         
           PERFORM 7000-READ-METER-FILE          THRU 7000-EXIT.        
                                                                        
           IF EOF-REACHED                                               
              DISPLAY '***************************************'         
              DISPLAY '*         EMPTY FILE RECEIVED         *'         
              DISPLAY '*            FOR MARRY FILE           *'         
              DISPLAY '***************************************'         
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      **  0200-INITIALIZE                                           **          
      *================================================================*        
       0200-INITIALIZE.                                                 
      *                                                                         
           MOVE WS-N                   TO WS-RECORD-FLAG.               
           COMPUTE WS-ERR-IDX = 0.                                      
           INITIALIZE ERROR-HOLD-AREA                                   
                    , EXISTING-ATTACHMENTS                              
                    , WS-HOLD-VARIABLES                                 
                    , DCLCSS-EQUIPMENT                                  
                    , DCLCSS-EQUIP-ATTCHMTS                             
                    , DCLCSS-EQUIP-ATT-MOVE                             
                    , DCLCSS-METER-ATTCHMTS.                            
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0300-GET-HOW-CONN-VAL.                                           
      *================================================================*        
      *                                                                         
           INITIALIZE WS-HOW-CONN-VAL-TAB.                              
                                                                        
           MOVE ZERO                   TO WS-HOW-CONN-SUB.              
           MOVE 'HOW_ATTACHED_CD'      TO WS-COLUMN-NA.                 
           MOVE 'CSS_METER_ATTCHMTS'   TO WS-TABLE-NA.                  
                                                                        
           PERFORM 7610-OPEN-CODE-VALUE          THRU 7610-EXIT.        
           PERFORM 7620-FETCH-CODE-VALUE         THRU 7620-EXIT.        
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
              ADD +1  TO WS-HOW-CONN-SUB                                
              MOVE WS-CODE-VALUE(1:1)  TO                               
                              WS-TAB-HOW-CONN-VAL (WS-HOW-CONN-SUB)     
              IF WS-HOW-CONN-SUB > 10                                   
                 DISPLAY '***ERROR: ARRAY OVERFLOW         ***'         
                 DISPLAY '***PARA:0300-GET-HOW-CONN-VAL    ***'         
                 DISPLAY '*** MORE THAN 10 CODE VALUES     ***'         
                 DISPLAY '*** COLUMN_NA:' WS-COLUMN-NA    ' **'         
                 DISPLAY '*** TABLE-NA :' WS-TABLE-NA     ' **'         
                 DISPLAY '*** COMPANY-NO:' WS-CMP-NO ' **'              
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
              PERFORM 7620-FETCH-CODE-VALUE      THRU 7620-EXIT         
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7630-CLOSE-CODE-VALUE         THRU 7630-EXIT.        
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      **  1000-PROCESS-FILE                                         **          
      **      RECEIVE, EDIT, AND PROCESS INPUT                      **          
      *================================================================*        
      *                                                                         
       1000-PROCESS-FILE.                                               
      *                                                                         
           PERFORM 2000-EDIT-RECORD              THRU 2000-EXIT.        
      *                                                                         
           IF GOOD-RECORD                                               
               PERFORM 5000-MARRY-MTR-ERT        THRU 5000-EXIT         
               ADD 1                   TO WS-NBR-GOOD-RECS              
           ELSE                                                         
               ADD 1                   TO WS-NBR-BAD-RECS               
P00462                                    WS-NO-ADDITION-MTRS           
           END-IF.                                                      
      *                                                                         
           MOVE WS-ERR-IDX             TO WS-ERROR-ARRAY-SIZE           
                                                                        
           PERFORM 6000-ERROR-ROUTINE            THRU 6000-EXIT         
           VARYING WS-ERR-IDX FROM 1 BY 1                               
             UNTIL WS-ERR-IDX > WS-ERROR-ARRAY-SIZE                     
      *                                                                         
           PERFORM 0200-INITIALIZE               THRU 0200-EXIT.        
      *                                                                         
           PERFORM 7000-READ-METER-FILE          THRU 7000-EXIT.        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2000-EDIT-RECORD.                                                
      *================================================================*        
      *                                                                         
      *** Validate Company number                                               
      *                                                                         
           IF E-FMT54-COMPANY-NO > SPACES                               
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 2500-LOAD-ERROR-ARRAY      THRU 2500-EXIT         
              MOVE 'COMPANY NO'       TO ERR-FIELD(WS-ERR-IDX)          
              MOVE 'NOT VALID'        TO ERR-PROBLEM(WS-ERR-IDX)        
           END-IF.                                                      
      *                                                                         
      *** Validate Util type                                                    
      *                                                                         
           IF E-FMT54-CODE-UTIL-TYPE > SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 2500-LOAD-ERROR-ARRAY      THRU 2500-EXIT         
              MOVE 'UTIL TYPE'        TO ERR-FIELD(WS-ERR-IDX)          
              MOVE 'NOT VALID'        TO ERR-PROBLEM(WS-ERR-IDX)        
           END-IF.                                                      
      *                                                                         
      *** Validate Meter                                                        
      *                                                                         
           IF E-FMT54-METER-NO NOT NUMERIC                              
               PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
               MOVE 'METER NUMBER'         TO ERR-FIELD(WS-ERR-IDX)     
               MOVE 'NOT NUMERIC'          TO ERR-PROBLEM(WS-ERR-IDX)   
           ELSE                                                         
               MOVE E-FMT54-COMPANY-NO     TO EQ-COMPANY-NO             
               MOVE E-FMT54-CODE-UTIL-TYPE TO EQ-CODE-UTIL-TYPE         
               MOVE E-FMT54-METER-NO       TO EQ-DEVICE-NO              
               PERFORM 7400-CHECK-VALID-METER    THRU 7400-EXIT         
                                                                        
               IF SQLCODE EQUAL NOT-FOUND                               
                  PERFORM 2500-LOAD-ERROR-ARRAY  THRU 2500-EXIT         
                  MOVE 'METER NUMBER'      TO ERR-FIELD(WS-ERR-IDX)     
                  MOVE 'NOT FOUND  '       TO ERR-PROBLEM(WS-ERR-IDX)   
               ELSE                                                     
                  IF EQ-CODE-CRNT-LOC = WS-A OR WS-B OR WS-C OR WS-J    
                                                             OR WS-K    
                     IF EQ-CODE-CRNT-LOC = WS-J OR WS-K                 
                        ADD +1        TO WS-ERR-IDX                     
                        MOVE E-FMT54-ATT-TYPE TO ERR-ATT-TYP(WS-ERR-IDX)
                        MOVE E-FMT54-METER-NO TO ERR-MTR-NO(WS-ERR-IDX) 
                        MOVE E-FMT54-ATTACHMENT-NO                      
                                              TO ERR-ATT-NO(WS-ERR-IDX) 
                        MOVE 'METER LOCATION' TO ERR-FIELD(WS-ERR-IDX)  
                        MOVE 'INSTALLED ** ALERT **'                    
                                              TO ERR-PROBLEM(WS-ERR-IDX)
                     END-IF                                             
                  ELSE                                                  
                     PERFORM 2500-LOAD-ERROR-ARRAY THRU 2500-EXIT       
                     MOVE 'METER LOCATION' TO ERR-FIELD(WS-ERR-IDX)     
                     MOVE 'NOT VALID'      TO ERR-PROBLEM(WS-ERR-IDX)   
                  END-IF                                                
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
      *** Check if Remote read code is valid for the Attachment type            
      *                                                                         
           MOVE E-FMT54-COMPANY-NO         TO EM-COMPANY-NO             
                                              MA-COMPANY-NO.            
           MOVE E-FMT54-CODE-UTIL-TYPE     TO EM-CODE-UTIL-TYPE         
                                              MA-CODE-UTIL-TYPE.        
           MOVE E-FMT54-METER-NO           TO EM-METER-NO               
                                              MA-METER-NO.              
           PERFORM 7110-GET-REMOTE-READ-CODE     THRU 7110-EXIT.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF E-FMT54-ATT-TYPE EQUAL WS-ATT-TYPE-ERT                 
                 IF U5-REMOTE-READ-CODE NOT EQUAL WS-A AND WS-M         
                     PERFORM 2500-LOAD-ERROR-ARRAY   THRU 2500-EXIT     
                     MOVE 'REMOTE READ CODE' TO ERR-FIELD(WS-ERR-IDX)   
                     MOVE 'NOT VALID'        TO ERR-PROBLEM(WS-ERR-IDX) 
                 END-IF                                                 
              ELSE                                                      
                 IF E-FMT54-ATT-TYPE EQUAL WS-ATT-TYPE-SMARTSYNCH       
                    IF U5-REMOTE-READ-CODE NOT EQUAL WS-Z               
                       PERFORM 2500-LOAD-ERROR-ARRAY THRU 2500-EXIT     
                       MOVE 'REMOTE READ CODE' TO ERR-FIELD(WS-ERR-IDX) 
                       MOVE 'NOT VALID'       TO ERR-PROBLEM(WS-ERR-IDX)
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              PERFORM 2500-LOAD-ERROR-ARRAY   THRU 2500-EXIT            
              MOVE 'REMOTE READ CODE'     TO ERR-FIELD(WS-ERR-IDX)      
              MOVE 'NOT PRESENT'          TO ERR-PROBLEM(WS-ERR-IDX)    
           END-IF.                                                      
      *                                                                         
      *** Validate Attachment type                                              
      *                                                                         
           SET WS-ATT-TYPE-NOT-EXISTS     TO  TRUE                      
                                                                        
           IF E-FMT54-ATT-TYPE > SPACES                                 
              MOVE E-FMT54-ATT-TYPE       TO N5-CODE-ATT-TYPE           
              MOVE E-FMT54-CODE-UTIL-TYPE TO N5-CODE-UTIL-TYPE          
              PERFORM 7100-SELECT-ATTACHMENT-TYPE THRU 7100-EXIT        
              IF SQLCODE EQUAL SUCCESSFUL-CALL                          
                 IF N5-CODE-DEVICE-TYPE EQUAL WS-Q                      
                    SET WS-ATT-TYPE-EXISTS TO TRUE                      
                 ELSE                                                   
                    PERFORM 2500-LOAD-ERROR-ARRAY   THRU 2500-EXIT      
                    MOVE 'ATTACHMENT TYPE' TO ERR-FIELD(WS-ERR-IDX)     
                    MOVE 'NOT HANDLED'    TO ERR-PROBLEM(WS-ERR-IDX)    
                 END-IF                                                 
              ELSE                                                      
                 PERFORM 2500-LOAD-ERROR-ARRAY   THRU 2500-EXIT         
                 MOVE 'ATTACHMENT TYPE'   TO ERR-FIELD(WS-ERR-IDX)      
                 MOVE 'NOT VALID'         TO ERR-PROBLEM(WS-ERR-IDX)    
              END-IF                                                    
           ELSE                                                         
              PERFORM 2500-LOAD-ERROR-ARRAY      THRU 2500-EXIT         
              MOVE 'ATTACHMENT TYPE'      TO ERR-FIELD(WS-ERR-IDX)      
              MOVE 'NOT PRESENT'          TO ERR-PROBLEM(WS-ERR-IDX)    
           END-IF.                                                      
      *                                                                         
      *** Format Attachment Number with leading zero                            
      *                                                                         
           MOVE E-FMT54-ATTACHMENT-NO     TO WS-FRMT-ATT.               
           PERFORM 7700-FORMAT-ATTACHMENT        THRU 7700-EXIT.        
           MOVE WS-FRMT-ATT               TO E-FMT54-ATTACHMENT-NO.     
      *                                                                         
      *** Validate Attachment Number                                            
      *                                                                         
           IF E-FMT54-ATTACHMENT-NO NOT NUMERIC                         
              PERFORM 2500-LOAD-ERROR-ARRAY      THRU 2500-EXIT         
              MOVE 'ATTACHMENT NUMBER'    TO ERR-FIELD(WS-ERR-IDX)      
              MOVE 'NOT NUMERIC'          TO ERR-PROBLEM(WS-ERR-IDX)    
           ELSE                                                         
              IF WS-ATT-TYPE-EXISTS                                     
                 MOVE E-FMT54-ATTACHMENT-NO  TO LX-DEVICE-NO            
                 MOVE E-FMT54-ATT-TYPE       TO LX-CODE-ATT-TYPE        
                 MOVE E-FMT54-COMPANY-NO     TO LX-COMPANY-NO           
                 MOVE E-FMT54-CODE-UTIL-TYPE TO LX-CODE-UTIL-TYPE       
                 PERFORM 2100-VALIDATE-ATTACHMENTS THRU 2100-EXIT       
                 MOVE WS-NEW-EQUIP-LOCTN-ID  TO WS-NEW-EQUIP-LOCTN-ID-1 
                 MOVE WS-NEW-MTR-STO-FAC-CD  TO WS-NEW-MTR-STO-FAC-CD-1 
                 MOVE WS-NEW-DATE-LAST-MOVE  TO WS-NEW-DATE-LAST-MOVE-1 
                 MOVE WS-NEW-DATE-PURCHASED  TO WS-NEW-DATE-PURCHASED-1 
                                                                        
                 IF U5-REMOTE-READ-CODE EQUAL WS-M                      
P00462              AND E-FMT54-ATT-TYPE = WS-ATT-TYPE-ERT              
                   MOVE E-FMT54-ATTACHMENT-NO  TO WS-ATTCHMNT-NO        
                                                                        
                   ADD 1 TO WS-ATTCHMNT-NO GIVING WS-ATTCHMNT-NO1       
                   MOVE WS-ATTCHMNT-NO1      TO LX-DEVICE-NO            
                   PERFORM 2100-VALIDATE-ATTACHMENTS THRU 2100-EXIT     
                   MOVE WS-NEW-EQUIP-LOCTN-ID TO WS-NEW-EQUIP-LOCTN-ID-2
                   MOVE WS-NEW-MTR-STO-FAC-CD TO WS-NEW-MTR-STO-FAC-CD-2
                   MOVE WS-NEW-DATE-LAST-MOVE TO WS-NEW-DATE-LAST-MOVE-2
                   MOVE WS-NEW-DATE-PURCHASED TO WS-NEW-DATE-PURCHASED-2
                                                                        
                   ADD 2 TO WS-ATTCHMNT-NO GIVING WS-ATTCHMNT-NO2       
                   MOVE WS-ATTCHMNT-NO2       TO LX-DEVICE-NO           
                   PERFORM 2100-VALIDATE-ATTACHMENTS THRU 2100-EXIT     
                   MOVE WS-NEW-EQUIP-LOCTN-ID TO WS-NEW-EQUIP-LOCTN-ID-3
                   MOVE WS-NEW-MTR-STO-FAC-CD TO WS-NEW-MTR-STO-FAC-CD-3
                   MOVE WS-NEW-DATE-LAST-MOVE TO WS-NEW-DATE-LAST-MOVE-3
                   MOVE WS-NEW-DATE-PURCHASED TO WS-NEW-DATE-PURCHASED-3
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
      ***  Module connect type (HOW-ATTACHED-CD) validation                     
      *                                                                         
           IF E-FMT54-ATT-CONN-TYPE > SPACES                            
              SET WS-CODE-VAL-NOT-MATCHED TO TRUE                       
              PERFORM VARYING WS-CONN-INDX FROM 1 BY 1                  
                UNTIL WS-CONN-INDX > WS-HOW-CONN-SUB                    
                   OR WS-CODE-VAL-MATCHED                               
                   OR WS-TAB-HOW-CONN-VAL (WS-CONN-INDX) = SPACES       
                      IF WS-TAB-HOW-CONN-VAL (WS-CONN-INDX)             
                                      = E-FMT54-ATT-CONN-TYPE           
                         SET WS-CODE-VAL-MATCHED TO TRUE                
                      END-IF                                            
              END-PERFORM                                               
              IF WS-CODE-VAL-NOT-MATCHED                                
                 PERFORM 2500-LOAD-ERROR-ARRAY   THRU 2500-EXIT         
                 MOVE 'ATT CONN TYPE'         TO ERR-FIELD(WS-ERR-IDX)  
                 MOVE 'NOT VALID'             TO ERR-PROBLEM(WS-ERR-IDX)
              END-IF                                                    
           ELSE                                                         
              PERFORM 2500-LOAD-ERROR-ARRAY      THRU 2500-EXIT         
              MOVE 'ATT CONN TYPE'            TO ERR-FIELD(WS-ERR-IDX)  
              MOVE 'NOT PRESENT'              TO ERR-PROBLEM(WS-ERR-IDX)
           END-IF.                                                      
      *                                                                         
      ***  Check if Meter has any Attachments attached to the Meter             
      *                                                                         
           SET WS-CT-PT-NOT-ATTACHED          TO TRUE.                  
           PERFORM 7810-OPEN-CHECK-EXIST-ATT     THRU 7810-EXIT.        
           PERFORM 7820-FETCH-CHECK-EXIST-ATT    THRU 7820-EXIT.        
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
              ADD +1                          TO WS-SUB                 
              MOVE WS-TEMP-DEVICE-NO          TO EXIST-DEVICE-NO(WS-SUB)
              MOVE WS-TEMP-CODE-ATT-TYPE  TO EXIST-CODE-ATT-TYPE(WS-SUB)
              IF WS-TEMP-CODE-ATT-TYPE EQUAL WS-CURRENT-XFORMER-CT      
                                          OR WS-POTENTIAL-XFORMER-PT    
                 SET WS-CT-PT-ATTACHED        TO TRUE                   
              END-IF                                                    
              PERFORM 7820-FETCH-CHECK-EXIST-ATT THRU 7820-EXIT         
           END-PERFORM.                                                 
                                                                        
           PERFORM 7830-CLOSE-CHECK-EXIST-ATT    THRU 7830-EXIT.        
      *                                                                         
      ***  If a Meter has CT/PT attached, it cannot have K-BASE                 
      *                                                                         
           IF E-FMT54-ATT-TYPE = WS-ATT-TYPE-KBASE                      
              IF WS-CT-PT-ATTACHED                                      
                 PERFORM 2500-LOAD-ERROR-ARRAY   THRU 2500-EXIT         
                 MOVE 'KBASE NOT ALLOWED'     TO ERR-FIELD(WS-ERR-IDX)  
                 MOVE 'CT/PT ATTACHED'        TO ERR-PROBLEM(WS-ERR-IDX)
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2100-VALIDATE-ATTACHMENTS.                                       
      *                                                                         
           PERFORM 7200-CHECK-VALID-ATTACH    THRU 7200-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 2500-LOAD-ERROR-ARRAY   THRU 2500-EXIT            
              MOVE LX-DEVICE-NO               TO ERR-FIELD(WS-ERR-IDX)  
              MOVE 'NOT FOUND'                TO ERR-PROBLEM(WS-ERR-IDX)
           ELSE                                                         
              IF WS-NEW-EQUIP-LOCTN-ID = WS-A OR WS-B OR WS-C           
                 IF WS-DT-LST-MOVE-IND = -1                             
                    MOVE SPACES               TO WS-NEW-DATE-LAST-MOVE  
                 END-IF                                                 
                 IF WS-DT-PURCHASE-IND = -1                             
                    MOVE SPACES               TO WS-NEW-DATE-PURCHASED  
                 END-IF                                                 
              ELSE                                                      
                 PERFORM 2500-LOAD-ERROR-ARRAY THRU 2500-EXIT           
                 MOVE 'ATTACHMENT LOCATION'   TO ERR-FIELD(WS-ERR-IDX)  
                 MOVE 'NOT VALID'             TO ERR-PROBLEM(WS-ERR-IDX)
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2500-LOAD-ERROR-ARRAY.                                           
      *                                                                         
           MOVE 'Y'                           TO WS-RECORD-FLAG.        
           ADD +1                             TO WS-ERR-IDX.            
           MOVE E-FMT54-ATT-TYPE              TO ERR-ATT-TYP(WS-ERR-IDX)
           MOVE E-FMT54-METER-NO              TO ERR-MTR-NO(WS-ERR-IDX).
           MOVE E-FMT54-ATTACHMENT-NO         TO ERR-ATT-NO(WS-ERR-IDX).
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       5000-MARRY-MTR-ERT.                                              
      *================================================================*        
      *                                                                         
      *** Delete any previous attachments for the Meter that has the            
      * same attachment type.                                                   
           PERFORM VARYING WS-DEL-IDX FROM 1 BY 1                       
             UNTIL WS-DEL-IDX > WS-SUB                                  
             IF E-FMT54-ATT-TYPE = EXIST-CODE-ATT-TYPE(WS-DEL-IDX)      
                PERFORM 5100-DELETE-PROCESS    THRU 5100-EXIT           
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
      *** Create Move history for the new attachment/S                          
      *                                                                         
           MOVE E-FMT54-ATTACHMENT-NO      TO MP-DEVICE-NO              
                                              LX-DEVICE-NO              
                                              MA-DEVICE-NO.             
           MOVE E-FMT54-ATT-TYPE           TO MP-CODE-ATT-TYPE          
                                              LX-CODE-ATT-TYPE          
                                              MA-CODE-ATT-TYPE.         
           MOVE E-FMT54-COMPANY-NO         TO MP-COMPANY-NO             
                                              LX-COMPANY-NO             
                                              MA-COMPANY-NO.            
           MOVE E-FMT54-CODE-UTIL-TYPE     TO MP-CODE-UTIL-TYPE         
                                              MP-CODE-UTIL-TYPE         
                                              MP-CODE-UTIL-TYPE.        
           MOVE SPACES                     TO MP-METER-NO.              
           MOVE WS-NEW-EQUIP-LOCTN-ID-1    TO MP-EQUIP-LOC-ID.          
           MOVE WS-NEW-MTR-STO-FAC-CD-1    TO MP-MTR-STORAGE-FAC-CD.    
                                                                        
           IF WS-NEW-DATE-LAST-MOVE-1 > SPACES                          
              MOVE WS-NEW-DATE-LAST-MOVE-1 TO MP-DATE-MOVE              
           ELSE                                                         
              IF WS-NEW-DATE-PURCHASED-1 > SPACES                       
                 MOVE WS-NEW-DATE-PURCHASED-1 TO MP-DATE-MOVE           
              ELSE                                                      
                 MOVE WS-DEFAULT-DATE      TO MP-DATE-MOVE              
              END-IF                                                    
           END-IF.                                                      
           PERFORM 8500-INSERT-EQUIP-ATT-MOVE  THRU 8500-EXIT.          
                                                                        
           IF U5-REMOTE-READ-CODE EQUAL WS-M                            
P00462        AND E-FMT54-ATT-TYPE = WS-ATT-TYPE-ERT                    
              MOVE WS-ATTCHMNT-NO1            TO MP-DEVICE-NO           
              MOVE WS-NEW-EQUIP-LOCTN-ID-2    TO MP-EQUIP-LOC-ID        
              MOVE WS-NEW-MTR-STO-FAC-CD-2    TO MP-MTR-STORAGE-FAC-CD  
              IF WS-NEW-DATE-LAST-MOVE-2 > SPACES                       
                 MOVE WS-NEW-DATE-LAST-MOVE-2 TO MP-DATE-MOVE           
              ELSE                                                      
                 IF WS-NEW-DATE-PURCHASED-2 > SPACES                    
                    MOVE WS-NEW-DATE-PURCHASED-2 TO MP-DATE-MOVE        
                 ELSE                                                   
                    MOVE WS-DEFAULT-DATE      TO MP-DATE-MOVE           
                 END-IF                                                 
              END-IF                                                    
              PERFORM 8500-INSERT-EQUIP-ATT-MOVE THRU 8500-EXIT         
                                                                        
              MOVE WS-ATTCHMNT-NO2            TO MP-DEVICE-NO           
              MOVE WS-NEW-EQUIP-LOCTN-ID-3    TO MP-EQUIP-LOC-ID        
              MOVE WS-NEW-MTR-STO-FAC-CD-3    TO MP-MTR-STORAGE-FAC-CD  
              IF WS-NEW-DATE-LAST-MOVE-3 > SPACES                       
                 MOVE WS-NEW-DATE-LAST-MOVE-3 TO MP-DATE-MOVE           
              ELSE                                                      
                 IF WS-NEW-DATE-PURCHASED-3 > SPACES                    
                    MOVE WS-NEW-DATE-PURCHASED-3 TO MP-DATE-MOVE        
                 ELSE                                                   
                    MOVE WS-DEFAULT-DATE      TO MP-DATE-MOVE           
                 END-IF                                                 
              END-IF                                                    
              PERFORM 8500-INSERT-EQUIP-ATT-MOVE THRU 8500-EXIT         
           END-IF.                                                      
      *                                                                         
      *** Update Equip Attachment/S                                             
      *                                                                         
           MOVE WS-K                       TO LX-EQUIP-LOC-ID.          
           MOVE EQ-LOCAL-OFFICE            TO LX-MTR-STORAGE-FAC-CD.    
           MOVE WS-DB2-TODAYS-DATE         TO LX-EQUIP-ATTACH-DT        
                                              LX-DATE-LAST-MOVE         
                                              LX-DATE-LAST-TRAN.        
           PERFORM 8100-UPDATE-NEW-EQUIP-LOC     THRU 8100-EXIT.        
                                                                        
           IF U5-REMOTE-READ-CODE EQUAL WS-M                            
P00462        AND E-FMT54-ATT-TYPE = WS-ATT-TYPE-ERT                    
              MOVE WS-ATTCHMNT-NO1            TO LX-DEVICE-NO           
              PERFORM 8100-UPDATE-NEW-EQUIP-LOC  THRU 8100-EXIT         
                                                                        
              MOVE WS-ATTCHMNT-NO2            TO LX-DEVICE-NO           
              PERFORM 8100-UPDATE-NEW-EQUIP-LOC  THRU 8100-EXIT         
           END-IF.                                                      
      *                                                                         
      *** Setup Meter Attachment                                                
      *                                                                         
           MOVE E-FMT54-METER-NO           TO MA-METER-NO.              
           MOVE E-FMT54-ATT-CONN-TYPE      TO MA-HOW-ATTACHED-CD.       
           MOVE N5-CODE-DEVICE-TYPE        TO MA-CODE-DEVICE-TYPE.      
           MOVE ZERO                       TO MA-CT-PT-RATIO.           
           MOVE SPACES                     TO MA-DATE-LAST-TESTED       
                                              MA-CODE-MAKE              
                                              MA-TEST-SCHED-CD.         
           MOVE -1                         TO WS-MA-LAST-TEST-IND.      
           PERFORM 8000-INSERT-MTR-ATTACH        THRU 8000-EXIT.        
                                                                        
           IF U5-REMOTE-READ-CODE EQUAL WS-M                            
P00462        AND E-FMT54-ATT-TYPE = WS-ATT-TYPE-ERT                    
              MOVE WS-ATTCHMNT-NO1         TO MA-DEVICE-NO              
              PERFORM 8000-INSERT-MTR-ATTACH     THRU 8000-EXIT         
                                                                        
              MOVE WS-ATTCHMNT-NO2         TO MA-DEVICE-NO              
              PERFORM 8000-INSERT-MTR-ATTACH     THRU 8000-EXIT         
           END-IF.                                                      
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       5100-DELETE-PROCESS.                                             
      *================================================================*        
      *                                                                         
           MOVE EXIST-DEVICE-NO(WS-DEL-IDX)     TO MA-DEVICE-NO.        
           MOVE EXIST-CODE-ATT-TYPE(WS-DEL-IDX) TO MA-CODE-ATT-TYPE.    
                                                                        
           PERFORM 8600-DELETE-METER-ATTCHMTS    THRU 8600-EXIT.        
                                                                        
           MOVE MA-DEVICE-NO               TO LX-DEVICE-NO.             
           MOVE MA-CODE-ATT-TYPE           TO LX-CODE-ATT-TYPE.         
           MOVE MA-CODE-UTIL-TYPE          TO LX-CODE-UTIL-TYPE.        
           MOVE MA-COMPANY-NO              TO LX-COMPANY-NO.            
           MOVE ZEROES                     TO WS-DT-LST-MOVE-IND        
                                              WS-DT-PURCHASE-IND.       
                                                                        
           PERFORM 7900-GET-EQUIP-ATTCH-DETLS    THRU 7900-EXIT.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                                                        
              MOVE MA-METER-NO             TO MP-METER-NO               
              MOVE LX-DEVICE-NO            TO MP-DEVICE-NO              
              MOVE LX-CODE-ATT-TYPE        TO MP-CODE-ATT-TYPE          
              MOVE LX-COMPANY-NO           TO MP-COMPANY-NO             
              MOVE LX-CODE-UTIL-TYPE       TO MP-CODE-UTIL-TYPE         
              MOVE LX-EQUIP-LOC-ID         TO MP-EQUIP-LOC-ID           
              MOVE LX-MTR-STORAGE-FAC-CD   TO MP-MTR-STORAGE-FAC-CD     
                                                                        
              IF WS-DT-LST-MOVE-IND = -1                                
                 MOVE SPACES   TO LX-DATE-LAST-MOVE                     
              END-IF                                                    
              IF WS-DT-PURCHASE-IND = -1                                
                 MOVE SPACES   TO LX-DATE-PURCHASED                     
              END-IF                                                    
                                                                        
              IF LX-DATE-LAST-MOVE > SPACES                             
                 MOVE LX-DATE-LAST-MOVE    TO MP-DATE-MOVE              
              ELSE                                                      
                 IF LX-DATE-PURCHASED > SPACES                          
                    MOVE LX-DATE-PURCHASED TO MP-DATE-MOVE              
                 ELSE                                                   
                    MOVE WS-DEFAULT-DATE   TO MP-DATE-MOVE              
                 END-IF                                                 
              END-IF                                                    
                                                                        
              PERFORM 8500-INSERT-EQUIP-ATT-MOVE THRU 8500-EXIT         
                                                                        
              MOVE WS-A                    TO LX-EQUIP-LOC-ID           
              MOVE SPACES                  TO LX-EQUIP-ATTACH-DT        
              MOVE -1                      TO WS-EQUIP-ATTACH-DT-IND    
              PERFORM 8800-UPDATE-EQUIP-ATCH-DTL THRU 8800-EXIT         
                                                                        
           END-IF.                                                      
      *                                                                         
           ADD +1                          TO WS-ERR-IDX.               
           MOVE MA-CODE-ATT-TYPE           TO ERR-ATT-TYP(WS-ERR-IDX)   
           MOVE E-FMT54-METER-NO           TO ERR-MTR-NO(WS-ERR-IDX)    
           MOVE MA-DEVICE-NO               TO ERR-ATT-NO(WS-ERR-IDX)    
           MOVE 'OLD ATTACHMENT'           TO ERR-FIELD(WS-ERR-IDX).    
           MOVE 'REMOVED   ** ALERT **'    TO ERR-PROBLEM(WS-ERR-IDX).  
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6000-ERROR-ROUTINE.                                              
      *================================================================*        
      *                                                                         
           MOVE ERR-ATT-TYP(WS-ERR-IDX)    TO WS-RPT-ATTCH-TYP.         
           MOVE ERR-MTR-NO(WS-ERR-IDX)     TO WS-RPT-METER-NO.          
           MOVE ERR-FIELD(WS-ERR-IDX)      TO WS-RPT-ERROR-FIELD.       
           MOVE ERR-PROBLEM(WS-ERR-IDX)    TO WS-RPT-PROBLEM-DESC.      
           MOVE ERR-ATT-NO(WS-ERR-IDX)     TO WS-RPT-ATTCH-NO.          
           PERFORM 8200-WRITE-PRINTER-RECORD     THRU 8200-EXIT.        
      *                                                                         
       6000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7000-READ-METER-FILE.                                            
      *===============================================================*         
      *                                                                         
           READ FCSMT54-FILE                                            
               AT END MOVE 'Y'         TO WS-MT654-EOF.                 
      *                                                                         
           EVALUATE TRUE                                                
              WHEN FCSMT54-SUCCESSFUL                                   
                   ADD +1                   TO WS-NBR-METER-RECS        
                   DISPLAY 'PROCESSING METER ' E-FMT54-METER-NO ' '     
                     E-FMT54-ATT-TYPE ' ' E-FMT54-ATTACHMENT-NO         
              WHEN FCSMT54-READ-EOF                                     
                 CONTINUE                                               
              WHEN OTHER                                                
                 DISPLAY '************ PCSMT654 ERROR ***************'  
                 DISPLAY '**          7000-READ-METER-FILE         **'  
                 DISPLAY '** STATUS IS      : ' WS-FCSMT54-STATUS       
                 DISPLAY '** PROCESSING TERMINATED.......          **'  
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-EVALUATE.                                                
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7100-SELECT-ATTACHMENT-TYPE.                                     
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               SELECT UNIQUE_ATT_ID_CD                                  
                     ,CODE_DEVICE_TYPE                                  
                 INTO :N5-UNIQUE-ATT-ID-CD                              
                     ,:N5-CODE-DEVICE-TYPE                              
                FROM  CSS_MTR_ATT_TYPE WITH(READUNCOMMITTED)                    
                WHERE  CODE_UTIL_TYPE     = :N5-CODE-UTIL-TYPE          
                  AND  CODE_ATT_TYPE      = :N5-CODE-ATT-TYPE           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT UNIQUE_ATT_ID_CD                                          
MFA-TR*              ,CODE_DEVICE_TYPE                                          
MFA-TR*          INTO :N5-UNIQUE-ATT-ID-CD                                      
MFA-TR*              ,:N5-CODE-DEVICE-TYPE                                      
MFA-TR*         FROM  CSS_MTR_ATT_TYPE                                          
MFA-TR*         WHERE  CODE_UTIL_TYPE     = :N5-CODE-UTIL-TYPE                  
MFA-TR*           AND  CODE_ATT_TYPE      = :N5-CODE-ATT-TYPE                   
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE         TO WS-DISPLAY-RC                     
              DISPLAY '***************PCSMT654****************'         
              DISPLAY '* 7100-SELECT-ATTACHMENT-TYPE         *'         
              DISPLAY '* SQL CODE         ' WS-DISPLAY-RC               
              DISPLAY '* CODE_UTIL_TYPE = ' N5-CODE-UTIL-TYPE           
              DISPLAY '* CODE_ATT_TYPE  = ' N5-CODE-ATT-TYPE            
              DISPLAY '* METER NO       = ' E-FMT54-METER-NO            
              DISPLAY '***************PCSMT654****************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7110-GET-REMOTE-READ-CODE.                                       
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) U5.REMOTE_READ_CODE                              
                 INTO :U5-REMOTE-READ-CODE                              
                 FROM  CSS_ELEC_METER    EM WITH(READUNCOMMITTED)               
                      ,CSS_ELEC_MTR_SPEC U5 WITH(READUNCOMMITTED)               
                WHERE  EM.COMPANY_NO    = :EM-COMPANY-NO                
                AND EM.CODE_UTIL_TYPE   = :EM-CODE-UTIL-TYPE            
                AND EM.METER_NO         = :EM-METER-NO                  
                AND EM.ELEC_MTR_SPEC_CD = U5.ELEC_MTR_SPEC_CD           
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  U5.REMOTE_READ_CODE                                      
MFA-TR*          INTO :U5-REMOTE-READ-CODE                                      
MFA-TR*          FROM  CSS_ELEC_METER    EM                                     
MFA-TR*               ,CSS_ELEC_MTR_SPEC U5                                     
MFA-TR*         WHERE  EM.COMPANY_NO    = :EM-COMPANY-NO                        
MFA-TR*         AND EM.CODE_UTIL_TYPE   = :EM-CODE-UTIL-TYPE                    
MFA-TR*         AND EM.METER_NO         = :EM-METER-NO                          
MFA-TR*         AND EM.ELEC_MTR_SPEC_CD = U5.ELEC_MTR_SPEC_CD                   
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*       WITH UR                                                           
MFA-TR*      QUERYNO 7110                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES       TO U5-REMOTE-READ-CODE               
              END-IF                                                    
           ELSE                                                         
              MOVE SQLCODE         TO WS-DISPLAY-RC                     
              DISPLAY '***************PCSMT654****************'         
              DISPLAY '* 7110-GET-REMOTE-READ-CODE           *'         
              DISPLAY '* SQL CODE         ' WS-DISPLAY-RC               
              DISPLAY '* COMPANY NO     = ' EM-COMPANY-NO               
              DISPLAY '* CODE UTIL TYPE = ' EM-CODE-UTIL-TYPE           
              DISPLAY '* METER NO       = ' EM-METER-NO                 
              DISPLAY '***************PCSMT654****************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7200-CHECK-VALID-ATTACH.                                         
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               SELECT  EQUIP_LOC_ID                                     
                      ,MTR_STORAGE_FAC_CD                               
                      ,DATE_LAST_MOVE                                   
                      ,DATE_PURCHASED                                   
                 INTO :WS-NEW-EQUIP-LOCTN-ID                            
                     ,:WS-NEW-MTR-STO-FAC-CD                            
                     ,:WS-NEW-DATE-LAST-MOVE :WS-DT-LST-MOVE-IND         
                     ,:WS-NEW-DATE-PURCHASED :WS-DT-PURCHASE-IND         
                 FROM  CSS_EQUIP_ATTCHMTS WITH(READUNCOMMITTED)                 
                WHERE  DEVICE_NO         = :LX-DEVICE-NO                
                  AND  CODE_ATT_TYPE     = :LX-CODE-ATT-TYPE            
                  AND  COMPANY_NO        = :LX-COMPANY-NO               
                  AND  CODE_UTIL_TYPE    = :LX-CODE-UTIL-TYPE           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  EQUIP_LOC_ID                                             
MFA-TR*               ,MTR_STORAGE_FAC_CD                                       
MFA-TR*               ,DATE_LAST_MOVE                                           
MFA-TR*               ,DATE_PURCHASED                                           
MFA-TR*          INTO :WS-NEW-EQUIP-LOCTN-ID                                    
MFA-TR*              ,:WS-NEW-MTR-STO-FAC-CD                                    
MFA-TR*              ,:WS-NEW-DATE-LAST-MOVE:WS-DT-LST-MOVE-IND                 
MFA-TR*              ,:WS-NEW-DATE-PURCHASED:WS-DT-PURCHASE-IND                 
MFA-TR*          FROM  CSS_EQUIP_ATTCHMTS                                       
MFA-TR*         WHERE  DEVICE_NO         = :LX-DEVICE-NO                        
MFA-TR*           AND  CODE_ATT_TYPE     = :LX-CODE-ATT-TYPE                    
MFA-TR*           AND  COMPANY_NO        = :LX-COMPANY-NO                       
MFA-TR*           AND  CODE_UTIL_TYPE    = :LX-CODE-UTIL-TYPE                   
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE         TO WS-DISPLAY-RC                     
              DISPLAY '***************PCSMT654***************'          
              DISPLAY '* 7200-CHECK-VALID-ATTACH            *'          
              DISPLAY '* SQL CODE    '   WS-DISPLAY-RC                  
              DISPLAY '* DEVICE NO          = ' LX-DEVICE-NO            
              DISPLAY '* CODE ATT TYPE      = ' LX-CODE-ATT-TYPE        
              DISPLAY '* COMPANY NUMBER     = ' LX-COMPANY-NO           
              DISPLAY '* CODE UTIL TYPE     = ' LX-CODE-UTIL-TYPE       
              DISPLAY '* PROGRAM ABENDING...                *'          
              DISPLAY '***************PCSMT654***************'          
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7400-CHECK-VALID-METER.                                          
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               SELECT  CODE_CRNT_LOC                                    
                      ,LOCAL_OFFICE                                     
                 INTO  :EQ-CODE-CRNT-LOC                                
                      ,:EQ-LOCAL-OFFICE                                 
                 FROM  CSS_EQUIPMENT WITH(READUNCOMMITTED)                      
                WHERE  COMPANY_NO     = :EQ-COMPANY-NO                  
                  AND  CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE              
                  AND  DEVICE_NO      = :EQ-DEVICE-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  CODE_CRNT_LOC                                            
MFA-TR*               ,LOCAL_OFFICE                                             
MFA-TR*          INTO  :EQ-CODE-CRNT-LOC                                        
MFA-TR*               ,:EQ-LOCAL-OFFICE                                         
MFA-TR*          FROM  CSS_EQUIPMENT                                            
MFA-TR*         WHERE  COMPANY_NO     = :EQ-COMPANY-NO                          
MFA-TR*           AND  CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                      
MFA-TR*           AND  DEVICE_NO      = :EQ-DEVICE-NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE         TO WS-DISPLAY-RC                     
              DISPLAY '***************PCSMT654***************'          
              DISPLAY '* 7400-CHECK-VALID-METER             *'          
              DISPLAY '* SQL CODE IS '  WS-DISPLAY-RC                   
              DISPLAY '* COMPANY NUMBER     = ' EQ-COMPANY-NO           
              DISPLAY '* CODE UTIL TYPE     = ' EQ-CODE-UTIL-TYPE       
              DISPLAY '* DEVICE NUMBER      = ' EQ-DEVICE-NO            
              DISPLAY '* PROGRAM ABENDING...                *'          
              DISPLAY '***************PCSMT654***************'          
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7500-SELECT-COMP-NAME.                                           
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               SELECT COMPANY_NAME                                      
               INTO   :C7-COMPANY-NAME                                  
               FROM   CSS_COMPANY WITH(READUNCOMMITTED)                         
               WHERE COMPANY_NO = :C7-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NAME                                              
MFA-TR*        INTO   :C7-COMPANY-NAME                                          
MFA-TR*        FROM   CSS_COMPANY                                               
MFA-TR*        WHERE COMPANY_NO = :C7-COMPANY-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE         TO WS-DISPLAY-RC                     
              DISPLAY '***************PCSMT654***************'          
              DISPLAY '* 7500-SELECT-COMP-NAME              *'          
              DISPLAY '* SQL CODE IS '  WS-DISPLAY-RC                   
              DISPLAY '* COMPANY_NO =' C7-COMPANY-NO                    
              DISPLAY '* PROGRAM ABENDING...                *'          
              DISPLAY '***************PCSMT654***************'          
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7550-GET-CURRENT-DATE.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              CIS.CHAR2$DATE(CAST(SYSDATETIMEOFFSET() AS DATE), 'USA')
            INTO
              :WS-DB2-TODAYS-DATE,
              :WS-RUN-DATE                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DB2-TODAYS-DATE = CURRENT DATE                            
MFA-TR*          ,:WS-RUN-DATE = CHAR(CURRENT DATE, USA)                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE         TO WS-DISPLAY-RC                     
              DISPLAY '***************PCSMT654***************'          
              DISPLAY '* 7550-GET-CURRENT-DATE              *'          
              DISPLAY '* SQL CODE IS '  WS-DISPLAY-RC                   
              DISPLAY '* PROGRAM ABENDING...                *'          
              DISPLAY '***************PCSMT604***************'          
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7610-OPEN-CODE-VALUE.                                            
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              OPEN CODE_VAL_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE            TO   WS-ACTIVE-RETURN-CODE           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE         TO WS-DISPLAY-RC                     
              DISPLAY '***************PCSMT654****************'         
              DISPLAY '* 7610-OPEN-CODE-VALUE                *'         
              DISPLAY '* SQL CODE IS ' WS-DISPLAY-RC                    
              DISPLAY '* COMPANY_NO = :' WS-CMP-NO                      
              DISPLAY '* TABLE_NA   = :' WS-TABLE-NA                    
              DISPLAY '* COLUMN_NA  = :' WS-COLUMN-NA                   
              DISPLAY '***************PCSMT654****************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7620-FETCH-CODE-VALUE.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              FETCH CODE_VAL_CSR                                        
               INTO :WS-CODE-VALUE                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE         TO WS-DISPLAY-RC                     
              DISPLAY '***************PCSMT654****************'         
              DISPLAY '* 7620-FETCH-CODE-VALUE               *'         
              DISPLAY '* SQL CODE IS ' WS-DISPLAY-RC                    
              DISPLAY '* COMPANY_NO = :' WS-CMP-NO                      
              DISPLAY '* TABLE_NA   = :' WS-TABLE-NA                    
              DISPLAY '* COLUMN_NA  = :' WS-COLUMN-NA                   
              DISPLAY '***************PCSMT654****************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7630-CLOSE-CODE-VALUE.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              CLOSE CODE_VAL_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE         TO WS-DISPLAY-RC                     
              DISPLAY '***************PCSMT654****************'         
              DISPLAY '* 7630-CLOSE-CODE-VALUE               *'         
              DISPLAY '* SQL CODE IS '  WS-DISPLAY-RC                   
              DISPLAY '* COMPANY_NO = :' WS-CMP-NO                      
              DISPLAY '* TABLE_NA   = :' WS-TABLE-NA                    
              DISPLAY '* COLUMN_NA  = :' WS-COLUMN-NA                   
              DISPLAY '***************PCSMT654****************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7630-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7700-FORMAT-ATTACHMENT.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                SELECT
              CIS.SUBSTR3('000000000000',1 ,                           
                  (12 - DATALENGTH(RTRIM(LTRIM(:WS-FRMT-ATT))))) + 
           RTRIM(LTRIM(:WS-FRMT-ATT))
            INTO
              :WS-FRMT-ATT                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-FRMT-ATT   =                                            
MFA-TR*             SUBSTR('000000000000',1 ,                                   
MFA-TR*           (12 - LENGTH(RTRIM(LTRIM(:WS-FRMT-ATT)))))                    
MFA-TR*                 || RTRIM(LTRIM(:WS-FRMT-ATT))                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              MOVE SQLCODE         TO WS-DISPLAY-RC                     
              DISPLAY '* 7700-FORMAT-ATTACHMENT              *'         
              DISPLAY '** ATTACHMENT NO  : ' WS-FRMT-ATT                
              DISPLAY '** SQLCODE        : ' WS-DISPLAY-RC              
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7810-OPEN-CHECK-EXIST-ATT.                                       
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              OPEN CHECK_EXIST_ATT_CSR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO   WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE         TO WS-DISPLAY-RC                     
              DISPLAY '***************PCSMT654****************'         
              DISPLAY '* 7810-OPEN-CHECK-EXIST-ATT           *'         
              DISPLAY '* SQL CODE IS '  WS-DISPLAY-RC                   
              DISPLAY '* METER NO   = :' MA-METER-NO                    
              DISPLAY '* UTIL TYPE  = :' MA-CODE-UTIL-TYPE              
              DISPLAY '* COMPANY NO = :' MA-COMPANY-NO                  
              DISPLAY '***************PCSMT654****************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7820-FETCH-CHECK-EXIST-ATT.                                      
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              FETCH CHECK_EXIST_ATT_CSR                                 
               INTO :WS-TEMP-DEVICE-NO                                  
                   ,:WS-TEMP-CODE-ATT-TYPE                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE         TO WS-DISPLAY-RC                     
              DISPLAY '***************PCSMT654****************'         
              DISPLAY '* 7820-FETCH-CHECK-EXIST-ATT         *'          
              DISPLAY '* SQL CODE IS '  WS-DISPLAY-RC                   
              DISPLAY '* METER NO   = :' MA-METER-NO                    
              DISPLAY '* UTIL TYPE  = :' MA-CODE-UTIL-TYPE              
              DISPLAY '* COMPANY NO = :' MA-COMPANY-NO                  
              DISPLAY '***************PCSMT654****************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7820-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7830-CLOSE-CHECK-EXIST-ATT.                                      
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              CLOSE CHECK_EXIST_ATT_CSR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE         TO WS-DISPLAY-RC                     
              DISPLAY '***************PCSMT654****************'         
              DISPLAY '* 7830-CLOSE-CHECK-EXIST-ATT          *'         
              DISPLAY '* SQL CODE IS '  WS-DISPLAY-RC                   
              DISPLAY '* METER NO   = :' MA-METER-NO                    
              DISPLAY '* UTIL TYPE  = :' MA-CODE-UTIL-TYPE              
              DISPLAY '* COMPANY NO = :' MA-COMPANY-NO                  
              DISPLAY '***************PCSMT654****************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7830-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7900-GET-EQUIP-ATTCH-DETLS.                                      
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT DATE_LAST_MOVE                                    
                     ,DATE_PURCHASED                                    
                     ,CODE_ATT_TYPE                                     
                     ,EQUIP_LOC_ID                                      
                     ,MTR_STORAGE_FAC_CD                                
                 INTO :LX-DATE-LAST-MOVE :WS-DT-LST-MOVE-IND             
                     ,:LX-DATE-PURCHASED :WS-DT-PURCHASE-IND             
                     ,:LX-CODE-ATT-TYPE                                 
                     ,:LX-EQUIP-LOC-ID                                  
                     ,:LX-MTR-STORAGE-FAC-CD                            
                 FROM CSS_EQUIP_ATTCHMTS WITH(READUNCOMMITTED)                  
                WHERE DEVICE_NO      = :LX-DEVICE-NO                    
                  AND COMPANY_NO     = :LX-COMPANY-NO                   
                  AND CODE_UTIL_TYPE = :LX-CODE-UTIL-TYPE               
                  AND CODE_ATT_TYPE  = :LX-CODE-ATT-TYPE                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE_LAST_MOVE                                            
MFA-TR*              ,DATE_PURCHASED                                            
MFA-TR*              ,CODE_ATT_TYPE                                             
MFA-TR*              ,EQUIP_LOC_ID                                              
MFA-TR*              ,MTR_STORAGE_FAC_CD                                        
MFA-TR*          INTO :LX-DATE-LAST-MOVE:WS-DT-LST-MOVE-IND                     
MFA-TR*              ,:LX-DATE-PURCHASED:WS-DT-PURCHASE-IND                     
MFA-TR*              ,:LX-CODE-ATT-TYPE                                         
MFA-TR*              ,:LX-EQUIP-LOC-ID                                          
MFA-TR*              ,:LX-MTR-STORAGE-FAC-CD                                    
MFA-TR*          FROM CSS_EQUIP_ATTCHMTS                                        
MFA-TR*         WHERE DEVICE_NO      = :LX-DEVICE-NO                            
MFA-TR*           AND COMPANY_NO     = :LX-COMPANY-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = :LX-CODE-UTIL-TYPE                       
MFA-TR*           AND CODE_ATT_TYPE  = :LX-CODE-ATT-TYPE                        
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7900                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE         TO WS-DISPLAY-RC                     
              DISPLAY '***************PCSMT654****************'         
              DISPLAY '* 7900-GET-EQUIP-ATTCH-DETLS          *'         
              DISPLAY '* SQL CODE IS ' WS-DISPLAY-RC                    
              DISPLAY '* DEVICE NO         ' LX-DEVICE-NO               
              DISPLAY '* COMPANY NO        ' LX-COMPANY-NO              
              DISPLAY '* CODE UTIL TYPE    ' LX-CODE-UTIL-TYPE          
              DISPLAY '* CODE ATT TYPE     ' LX-CODE-ATT-TYPE           
              DISPLAY '***************PCSMT654****************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8000-INSERT-MTR-ATTACH.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_METER_ATTCHMTS                           
                   (  CODE_UTIL_TYPE                                    
                     ,METER_NO                                          
                     ,CODE_DEVICE_TYPE                                  
                     ,DEVICE_NO                                         
                     ,CODE_ATT_TYPE                                     
                     ,CT_PT_RATIO                                       
                     ,CODE_MAKE                                         
                     ,DATE_LAST_TESTED                                  
                     ,TEST_SCHED_CD                                     
                     ,HOW_ATTACHED_CD                                   
                     ,COMPANY_NO)                                       
               VALUES                                                   
                   (  :MA-CODE-UTIL-TYPE                                
                     ,:MA-METER-NO                                      
                     ,:MA-CODE-DEVICE-TYPE                              
                     ,:MA-DEVICE-NO                                     
                     ,:MA-CODE-ATT-TYPE                                 
                     ,:MA-CT-PT-RATIO                                   
                     ,:MA-CODE-MAKE                                     
                     ,IIF(TRY_CONVERT(DATE, :MA-DATE-LAST-TESTED 
                                            :WS-MA-LAST-TEST-IND
              ) IS NULL OR (PATINDEX('%.%', :MA-DATE-LAST-TESTED 
                                                   :WS-MA-LAST-TEST-IND
              ) <> 0) OR (LEN(:MA-DATE-LAST-TESTED :WS-MA-LAST-TEST-IND
              ) <> 10), CIS.CHAR2DATE(:MA-DATE-LAST-TESTED 
                                                   :WS-MA-LAST-TEST-IND
              ), CONVERT(DATE, :MA-DATE-LAST-TESTED 
                                                   :WS-MA-LAST-TEST-IND
              ) )          
                     ,:MA-TEST-SCHED-CD                                 
                     ,:MA-HOW-ATTACHED-CD                               
                     ,:MA-COMPANY-NO)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_METER_ATTCHMTS                                   
MFA-TR*            (  CODE_UTIL_TYPE                                            
MFA-TR*              ,METER_NO                                                  
MFA-TR*              ,CODE_DEVICE_TYPE                                          
MFA-TR*              ,DEVICE_NO                                                 
MFA-TR*              ,CODE_ATT_TYPE                                             
MFA-TR*              ,CT_PT_RATIO                                               
MFA-TR*              ,CODE_MAKE                                                 
MFA-TR*              ,DATE_LAST_TESTED                                          
MFA-TR*              ,TEST_SCHED_CD                                             
MFA-TR*              ,HOW_ATTACHED_CD                                           
MFA-TR*              ,COMPANY_NO)                                               
MFA-TR*        VALUES                                                           
MFA-TR*            (  :MA-CODE-UTIL-TYPE                                        
MFA-TR*              ,:MA-METER-NO                                              
MFA-TR*              ,:MA-CODE-DEVICE-TYPE                                      
MFA-TR*              ,:MA-DEVICE-NO                                             
MFA-TR*              ,:MA-CODE-ATT-TYPE                                         
MFA-TR*              ,:MA-CT-PT-RATIO                                           
MFA-TR*              ,:MA-CODE-MAKE                                             
MFA-TR*              ,:MA-DATE-LAST-TESTED:WS-MA-LAST-TEST-IND                  
MFA-TR*              ,:MA-TEST-SCHED-CD                                         
MFA-TR*              ,:MA-HOW-ATTACHED-CD                                       
MFA-TR*              ,:MA-COMPANY-NO)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE         TO WS-DISPLAY-RC                     
              DISPLAY '***************PCSMT654****************'         
              DISPLAY '* 8000-INSERT-MTR-ATTACH              *'         
              DISPLAY '* SQL CODE IS ' WS-DISPLAY-RC                    
              DISPLAY '* COMPANY NUMBER    ' MA-COMPANY-NO              
              DISPLAY '* UTIL TYPE         ' MA-CODE-ATT-TYPE           
              DISPLAY '* METER NUMBER      ' MA-METER-NO                
              DISPLAY '* ATTACHMENT NUMBER ' MA-DEVICE-NO               
              DISPLAY '* ATTACHMENT TYPE   ' MA-CODE-ATT-TYPE           
              DISPLAY '***************PCSMT654****************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8100-UPDATE-NEW-EQUIP-LOC.                                       
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_EQUIP_ATTCHMTS                                
                  SET EQUIP_LOC_ID       = :LX-EQUIP-LOC-ID             
                     ,EQUIP_ATTACH_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :LX-EQUIP-ATTACH-DT
              ) IS NULL OR (PATINDEX('%.%', :LX-EQUIP-ATTACH-DT
              ) <> 0) OR (LEN(:LX-EQUIP-ATTACH-DT
              ) <> 10), CIS.CHAR2DATE(:LX-EQUIP-ATTACH-DT
              ), CONVERT(DATE, :LX-EQUIP-ATTACH-DT) )          
                     ,MTR_STORAGE_FAC_CD = :LX-MTR-STORAGE-FAC-CD       
                     ,DATE_LAST_MOVE     = IIF(TRY_CONVERT(DATE, 
                                                     :LX-DATE-LAST-MOVE
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-MOVE
              ) <> 0) OR (LEN(:LX-DATE-LAST-MOVE
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-MOVE
              ), CONVERT(DATE, :LX-DATE-LAST-MOVE) )           
                     ,DATE_LAST_TRAN     = IIF(TRY_CONVERT(DATE, 
                                                     :LX-DATE-LAST-TRAN
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-TRAN
              ) <> 0) OR (LEN(:LX-DATE-LAST-TRAN
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-TRAN
              ), CONVERT(DATE, :LX-DATE-LAST-TRAN) )           
                WHERE DEVICE_NO          = :LX-DEVICE-NO                
                  AND CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE            
                  AND COMPANY_NO         = :LX-COMPANY-NO               
                  AND CODE_UTIL_TYPE     = :LX-CODE-UTIL-TYPE           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_EQUIP_ATTCHMTS                                        
MFA-TR*           SET EQUIP_LOC_ID       = :LX-EQUIP-LOC-ID                     
MFA-TR*              ,EQUIP_ATTACH_DT    = :LX-EQUIP-ATTACH-DT                  
MFA-TR*              ,MTR_STORAGE_FAC_CD = :LX-MTR-STORAGE-FAC-CD               
MFA-TR*              ,DATE_LAST_MOVE     = :LX-DATE-LAST-MOVE                   
MFA-TR*              ,DATE_LAST_TRAN     = :LX-DATE-LAST-TRAN                   
MFA-TR*         WHERE DEVICE_NO          = :LX-DEVICE-NO                        
MFA-TR*           AND CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE                    
MFA-TR*           AND COMPANY_NO         = :LX-COMPANY-NO                       
MFA-TR*           AND CODE_UTIL_TYPE     = :LX-CODE-UTIL-TYPE                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE         TO WS-DISPLAY-RC                     
              DISPLAY '***************PCSMT654****************'         
              DISPLAY '* 8100-UPDATE-NEW-EQUIP-LOC           *'         
              DISPLAY '* SQL CODE IS ' WS-DISPLAY-RC                    
              DISPLAY '* COMPANY NUMBER    ' LX-COMPANY-NO              
              DISPLAY '* UTIL TYPE         ' LX-CODE-ATT-TYPE           
              DISPLAY '* ATTACHMENT NUMBER ' LX-DEVICE-NO               
              DISPLAY '* ATTACHMENT TYPE   ' LX-CODE-ATT-TYPE           
              DISPLAY '***************PCSMT654****************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *** IF LINE COUNTER IS > 56 PRINTS THE PAGE HEADINGS, MOVES INPUT         
      *** VARIABLES TO THE REPORT VARIABLES AND  PRINTS THE REPORT.             
      *================================================================*        
       8200-WRITE-PRINTER-RECORD.                                       
      *================================================================*        
      *                                                                         
           IF WS-LINE-CNTR > WS-FIFTY-SIX                               
              PERFORM 8300-PRT-HEADINGS       THRU 8300-EXIT            
              ADD WS-TWO                      TO WS-LINE-CNTR           
              SET ERROR-FOUND                 TO TRUE                   
           END-IF.                                                      
      *                                                                         
           MOVE WS-DET-LINE-1                 TO PRT33-DATA.            
      *                                                                         
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
      *                                                                         
           MOVE WS-ONE                        TO WS-LINE-SPACE.         
           ADD +1                             TO WS-LINE-CNTR.          
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8300-PRT-HEADINGS.                                               
      *================================================================*        
      *                                                                         
           MOVE 0                              TO WS-LINE-CNTR.         
           ADD WS-ONE                          TO WS-PAGE.              
           MOVE WS-PAGE                        TO WS-DET-PAGE.          
           MOVE WS-HDR-ONE                     TO PRT33-DATA.           
           WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
      *                                                                         
           MOVE WS-HDR-TWO                     TO PRT33-DATA.           
           MOVE WS-ONE                         TO WS-LINE-SPACE.        
           PERFORM 8400-WRITE-PRINT-REC        THRU 8400-EXIT.          
           MOVE WS-BLANK-LINE                  TO PRT33-DATA.           
           PERFORM 8400-WRITE-PRINT-REC        THRU 8400-EXIT.          
      *                                                                         
           MOVE WS-HDR-THREE                   TO PRT33-DATA.           
           MOVE WS-TWO                         TO WS-LINE-SPACE.        
           PERFORM 8400-WRITE-PRINT-REC        THRU 8400-EXIT.          
           MOVE WS-BLANK-LINE                  TO PRT33-DATA.           
           MOVE WS-ONE                         TO WS-LINE-SPACE.        
      *                                                                         
           PERFORM 8400-WRITE-PRINT-REC        THRU 8400-EXIT.          
           ADD  WS-SIX                         TO WS-LINE-CNTR.         
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8400-WRITE-PRINT-REC.                                            
      *================================================================*        
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING WS-LINE-SPACE.            
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8500-INSERT-EQUIP-ATT-MOVE.                                      
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_EQUIP_ATT_MOVE                           
                   (  DEVICE_NO                                         
                     ,CODE_ATT_TYPE                                     
                     ,COMPANY_NO                                        
                     ,CODE_UTIL_TYPE                                    
                     ,DATE_MOVE                                         
                     ,MOVE_NO                                           
                     ,MTR_STORAGE_FAC_CD                                
                     ,METER_NO                                          
                     ,EQUIP_LOC_ID)                                     
               VALUES                                                   
                   (  :MP-DEVICE-NO                                     
                     ,:MP-CODE-ATT-TYPE                                 
                     ,:MP-COMPANY-NO                                    
                     ,:MP-CODE-UTIL-TYPE                                
                     ,IIF(TRY_CONVERT(DATE, :MP-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MP-DATE-MOVE
              ) <> 0) OR (LEN(:MP-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MP-DATE-MOVE
              ), CONVERT(DATE, :MP-DATE-MOVE) )                                
                     , CIS.CURRENT$TIMESTAMP()                                
                     ,:MP-MTR-STORAGE-FAC-CD                            
                     ,:MP-METER-NO                                      
                     ,:MP-EQUIP-LOC-ID)                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_EQUIP_ATT_MOVE                                   
MFA-TR*            (  DEVICE_NO                                                 
MFA-TR*              ,CODE_ATT_TYPE                                             
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,CODE_UTIL_TYPE                                            
MFA-TR*              ,DATE_MOVE                                                 
MFA-TR*              ,MOVE_NO                                                   
MFA-TR*              ,MTR_STORAGE_FAC_CD                                        
MFA-TR*              ,METER_NO                                                  
MFA-TR*              ,EQUIP_LOC_ID)                                             
MFA-TR*        VALUES                                                           
MFA-TR*            (  :MP-DEVICE-NO                                             
MFA-TR*              ,:MP-CODE-ATT-TYPE                                         
MFA-TR*              ,:MP-COMPANY-NO                                            
MFA-TR*              ,:MP-CODE-UTIL-TYPE                                        
MFA-TR*              ,:MP-DATE-MOVE                                             
MFA-TR*              , CURRENT TIMESTAMP                                        
MFA-TR*              ,:MP-MTR-STORAGE-FAC-CD                                    
MFA-TR*              ,:MP-METER-NO                                              
MFA-TR*              ,:MP-EQUIP-LOC-ID)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE         TO WS-DISPLAY-RC                     
              DISPLAY '***************PCSMT654****************'         
              DISPLAY '* 8500-WRITE-MOVE-HIST                *'         
              DISPLAY '* SQL CODE IS ' WS-DISPLAY-RC                    
              DISPLAY '* DEVICE NO         ' MP-DEVICE-NO               
              DISPLAY '* ATT  TYPE         ' MP-CODE-ATT-TYPE           
              DISPLAY '* COMPANY NO        ' MP-COMPANY-NO              
              DISPLAY '* CODE UTIL TYPE    ' MP-CODE-UTIL-TYPE          
              DISPLAY '* DATE MOVE         ' MP-DATE-MOVE               
              DISPLAY '* METER NO          ' MP-METER-NO                
              DISPLAY '***************PCSMT654****************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8600-DELETE-METER-ATTCHMTS.                                      
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               DELETE                                                   
                 FROM CSS_METER_ATTCHMTS                                
                WHERE CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE               
                  AND METER_NO       = :MA-METER-NO                     
                  AND DEVICE_NO      = :MA-DEVICE-NO                    
                  AND CODE_ATT_TYPE  = :MA-CODE-ATT-TYPE                
                  AND COMPANY_NO     = :MA-COMPANY-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE         TO WS-DISPLAY-RC                     
              DISPLAY '***************PCSMT654****************'         
              DISPLAY '* 8600-DELETE-METER-ATTCHMTS          *'         
              DISPLAY '* SQL CODE IS ' WS-DISPLAY-RC                    
              DISPLAY '* CODE UTIL TYPE    ' MA-CODE-UTIL-TYPE          
              DISPLAY '* METER NO          ' MA-METER-NO                
              DISPLAY '* DEVICE NO         ' MA-DEVICE-NO               
              DISPLAY '* CODE ATT TYPE     ' MA-CODE-ATT-TYPE           
              DISPLAY '* COMPANY NO        ' MA-COMPANY-NO              
              DISPLAY '***************PCSMT654****************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8800-UPDATE-EQUIP-ATCH-DTL.                                      
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_EQUIP_ATTCHMTS                                
               SET EQUIP_LOC_ID       = :LX-EQUIP-LOC-ID                
                  ,MTR_STORAGE_FAC_CD = :LX-MTR-STORAGE-FAC-CD          
                  ,EQUIP_ATTACH_DT    =                                 
                          IIF(TRY_CONVERT(DATE, :LX-EQUIP-ATTACH-DT 
                                                :WS-EQUIP-ATTACH-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :LX-EQUIP-ATTACH-DT 
                                                :WS-EQUIP-ATTACH-DT-IND
              ) <> 0) OR (LEN(:LX-EQUIP-ATTACH-DT 
                                                :WS-EQUIP-ATTACH-DT-IND
              ) <> 10), CIS.CHAR2DATE(:LX-EQUIP-ATTACH-DT 
                                                :WS-EQUIP-ATTACH-DT-IND
              ), CONVERT(DATE, :LX-EQUIP-ATTACH-DT 
                                                :WS-EQUIP-ATTACH-DT-IND
              ) )    
                  ,DATE_LAST_MOVE     = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                    
                  ,DATE_LAST_TRAN     = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                    
               WHERE COMPANY_NO       = :LX-COMPANY-NO                  
               AND CODE_UTIL_TYPE     = :LX-CODE-UTIL-TYPE              
               AND DEVICE_NO          = :LX-DEVICE-NO                   
               AND CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_EQUIP_ATTCHMTS                                        
MFA-TR*        SET EQUIP_LOC_ID       = :LX-EQUIP-LOC-ID                        
MFA-TR*           ,MTR_STORAGE_FAC_CD = :LX-MTR-STORAGE-FAC-CD                  
MFA-TR*           ,EQUIP_ATTACH_DT    =                                         
MFA-TR*                   :LX-EQUIP-ATTACH-DT:WS-EQUIP-ATTACH-DT-IND            
MFA-TR*           ,DATE_LAST_MOVE     = CURRENT DATE                            
MFA-TR*           ,DATE_LAST_TRAN     = CURRENT DATE                            
MFA-TR*        WHERE COMPANY_NO       = :LX-COMPANY-NO                          
MFA-TR*        AND CODE_UTIL_TYPE     = :LX-CODE-UTIL-TYPE                      
MFA-TR*        AND DEVICE_NO          = :LX-DEVICE-NO                           
MFA-TR*        AND CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE         TO WS-DISPLAY-RC                     
              DISPLAY '***************PCSMT654****************'         
              DISPLAY '* 8800-UPDATE-EQUIP-ATCH-DTL          *'         
              DISPLAY '* SQL CODE IS ' WS-DISPLAY-RC                    
              DISPLAY '* COMPANY NO        ' LX-COMPANY-NO              
              DISPLAY '* CODE UTIL TYPE    ' LX-CODE-UTIL-TYPE          
              DISPLAY '* DEVICE NO         ' LX-DEVICE-NO               
              DISPLAY '* CODE ATT TYPE     ' LX-CODE-ATT-TYPE           
              DISPLAY '***************PCSMT654****************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8900-PRODUCE-SUMMARY-REPORTS.                                    
      *================================================================*        
      *                                                                         
           IF WS-LINE-CNTR > WS-FIFTY-TWO                               
              PERFORM 8300-PRT-HEADINGS       THRU 8300-EXIT            
              ADD WS-TWO               TO WS-LINE-CNTR                  
           END-IF.                                                      
      *                                                                         
           MOVE WS-ONE                 TO WS-LINE-SPACE.                
           IF NOT ERROR-FOUND                                           
              MOVE WS-NO-ERROR-LINE    TO PRT33-DATA                    
              PERFORM 8400-WRITE-PRINT-REC    THRU 8400-EXIT            
           END-IF.                                                      
           MOVE WS-BLANK-LINE          TO PRT33-DATA.                   
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
      *                                                                         
           MOVE WS-TOT-RECDS-INFO      TO WS-RPT-MESSAGE.               
           MOVE WS-NBR-METER-RECS      TO WS-RPT-STATISTICS.            
           MOVE WS-DET-LINE-2          TO PRT33-DATA.                   
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
      *                                                                         
           MOVE WS-TOT-GOOD-RECDS      TO WS-RPT-MESSAGE.               
           MOVE WS-NBR-GOOD-RECS       TO WS-RPT-STATISTICS.            
           MOVE WS-DET-LINE-2          TO PRT33-DATA.                   
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
      *                                                                         
           MOVE WS-TOT-BAD-RECDS       TO WS-RPT-MESSAGE.               
           MOVE WS-NBR-BAD-RECS        TO WS-RPT-STATISTICS.            
           MOVE WS-DET-LINE-2          TO PRT33-DATA.                   
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
      *                                                                         
           MOVE WS-TOT-UNADDED-MTRS    TO WS-RPT-MESSAGE.               
           MOVE WS-NO-ADDITION-MTRS    TO WS-RPT-STATISTICS.            
           MOVE WS-DET-LINE-2          TO PRT33-DATA.                   
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
      *                                                                         
           MOVE WS-BLANK-LINE          TO PRT33-DATA.                   
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
      *                                                                         
           MOVE WS-FOOT-LINE           TO PRT33-DATA.                   
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  9000-TERMINATE                                            **          
      **                                                            **          
      ****************************************************************          
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSMT54-FILE                                           
                 FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE     **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
