       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSMT618.                                        
       DATE-WRITTEN.   SEP 2004.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **   DATE      INITIALS             REASON                     **         
      **  -------   ----------        ------------------------------ **         
C31190** 10/07/04   VD88125          CODE CHANGES TO COMPUTE FILED ON**         
      **                             PH-ANG-ERR-ACCU-FL              **         
      **                                                             **         
31190 ** 10/11/04   RF10596          CODE CHANGES FOR BURDEN         **         
T35434** 06/09/07   PC97415          REPLACED MODEL_SQL TO SET CMD,  **         
T35434**                             ADDED FETCH ONLY WITH UR FOR    **         
T35434**                             AVOIDING -911 ABENDS.           **         
      **                                                             **         
T71807** 07/18/07   RC41079          ADDED CODE-UTIL-TYPE AND        **         
T71807**                             COMPANY-NO TO WHERE CLAUSE FOR  **         
T71807**                             CSS_EQUIP_TST_REPR.             **         
ACT128** 08/10/14   BD09555          REMOVE EDITS FOR CT AND PT      **         
ACT128**                             TRANSFORMERS FOR 'BURDEN ACCURACY*         
ACT128**                             FULL' AND 'BURDEN ACCURACY LIGHT'*         
A05460** 07/26/16   MR7E794          REMOVED UNUSED COPYBOOKS         *         
A05460**            ACT229                                            *         
      *****************************************************************         
           REMARKS.                                                     
                              PCSMT618 NARRATIVE                        
                       TRANSFORMER TEST RESULTS BATCH DATA UPDATE       
      *                                                                         
                 THIS PROGRAM READS THE XFORMER TESTING RESULTS FILE    
                 FROM THE METER SHOP, VALIDATE ALL THE TEST RESULTS.    
                 ANY RECORDS WITH INVALID DATA IS WRITTEN TO AN ERROR   
                 REPORT AND WILL NOT BE POSTED. ALL VALID RECORDS ARE   
                 POSTED TO CSS_XFORMER_TEST TABLE. IF THE TEST RECORD   
                 SAYS TO RETIRE THE XFMR, THE TEST RECORD IS NOT POSTED 
                 TO THE ABOVE TABLE, BUT RETIRED IN METER INVENTORY.    
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9900 - 9999     ABEND/ABORT MODULES                     
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SPECIAL-NAMES.      C01 IS NEW-PAGE.                             
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSMT618.                                                           
       COPY CSSPT33.                                                            
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDMT618.                                                           
       COPY FIOMT618.                                                           
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSMT618'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                        PIC X(40) VALUE              
           'WORKING STORAGE FOR PCSMT618 STARTS HERE'.                  
      *                                                                         
       01  PROGRAM-NAME                    PIC X(08) VALUE 'PCSMT618'.  
      *                                                                         
HPCCDM*EJECT                                                                    
       COPY CWS00303.                                                           
       COPY CWS00010.                                                           
       COPY CWS09900.                                                           
      *                                                                         
       01  WS-WORK-AREA.                                                
           05  WS-DISPLAY-RC               PIC -ZZZZZZZZ9.9.            
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSMT618'.  
           05  COUNTERS.                                                
               10  WS-NBR-XFMR-TEST-RECS   PIC 9(5)        VALUE 0.     
               10  WS-NBR-GOOD-RECS        PIC 9(5)        VALUE 0.     
               10  WS-NBR-BAD-RECS         PIC 9(5)        VALUE 0.     
           05  WS-DATE-LAST-MOVE-NULL      PIC S9(04) COMP VALUE ZEROES.
               88  DATE-LAST-MOVE-NULL     VALUE -1.                    
           05  WS-INSTALL-DT-NULL          PIC S9(04) COMP VALUE +0.    
           05  FLAGS.                                                   
               10  WS-FMT618-STATUS           PIC X(02).                
                   88  FMT618-SUCCESSFUL                 VALUE '00'.    
               10  WS-XFMR-FOUND           PIC X(01) VALUE 'N'.         
                   88  XFMR-FOUND                    VALUE 'Y'.         
                   88  XFMR-NOT-FOUND                VALUE 'N'.         
               10  WS-EOF-FLAG             PIC X(01) VALUE 'N'.         
                   88  END-OF-FILE                   VALUE 'Y'.         
               10  WS-IS-INPUT-VALID       PIC X(01) VALUE 'Y'.         
                   88  INPUT-IS-VALID                VALUE 'Y'.         
                   88  INPUT-IS-INVALID              VALUE 'N'.         
               10  WS-NO-ERROR-FOUND       PIC X(01) VALUE 'Y'.         
                   88  ERROR-FOUND                   VALUE 'N'.         
           05  RS-RETURN-CODE              PIC S9(04) COMP VALUE +0.    
           05  RS-RETURN-CODE-DISP         PIC Z(04).                   
           05  WS-SYS-DATE.                                             
               10  WS-SYS-DATE-YY          PIC 9(02).                   
               10  WS-SYS-DATE-MM          PIC 9(02).                   
               10  WS-SYS-DATE-DD          PIC 9(02).                   
           05  WS-DB2-TODAYS-DATE          PIC X(10).                   
           05  WS-DATE-OF-TEST             PIC X(10).                   
           05  WS-DB2-DATE                 PIC X(10).                   
           05  WS-DB2-TIME                 PIC X(08).                   
           05  WS-SERIAL-NO                PIC X(11).                   
           05  WS-SER-NO-JUSTIFIED         PIC X(11) JUSTIFIED RIGHT.   
           05  WS-INSPECT-CNTR             PIC 9(02)  VALUE ZERO.       
           05  WS-CURRENT-TIME             PIC X(08) VALUE SPACES.      
           05  WS-CURRENT-DATE             PIC X(10) VALUE SPACES.      
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-ONE                  PIC X(01) VALUE '1'.             
           05  WS-TWO                  PIC X(01) VALUE '2'.             
           05  WS-THREE                PIC X(01) VALUE '3'.             
           05  WS-D                    PIC X(01) VALUE 'D'.             
           05  WS-E                    PIC X(01) VALUE 'E'.             
           05  WS-F                    PIC X(01) VALUE 'F'.             
           05  WS-G                    PIC X(01) VALUE 'G'.             
           05  WS-W                    PIC X(01) VALUE 'W'.             
           05  WS-J                    PIC X(01) VALUE 'J'.             
           05  WS-K                    PIC X(01) VALUE 'K'.             
           05  WS-M                    PIC X(01) VALUE 'M'.             
           05  WS-N                    PIC X(01) VALUE 'N'.             
           05  WS-R                    PIC X(01) VALUE 'R'.             
           05  WS-S                    PIC X(01) VALUE 'S'.             
           05  WS-T                    PIC X(01) VALUE 'T'.             
           05  WS-X                    PIC X(01) VALUE 'X'.             
           05  WS-Y                    PIC X(01) VALUE 'Y'.             
           05  WS-MINUS                PIC X(01) VALUE '-'.             
           05  WS-RETIRED              PIC X(01) VALUE 'I'.             
           05  WS-YES                  PIC X(03) VALUE 'YES'.           
           05  WS-NO                   PIC X(03) VALUE 'NO '.           
           05  WS-UNKNOWN              PIC X(08) VALUE 'UNKNOWN '.      
           05  WS-ZEROES               PIC X(03) VALUE '000'.           
           05  WS-01                   PIC X(02) VALUE '01'.            
           05  WS-LINE-COUNT           PIC 9(02) VALUE 57.              
           05  WS-PAGE-COUNT           PIC 9(03) VALUE ZEROES.          
           05  WS-SUB                  PIC 9(02) VALUE ZEROES.          
                                                                        
       01  WS-ERROR-HOLD-AREA.                                          
           05  WS-ERROR-PROBLEM            PIC X(33) VALUE SPACES.      
           05  WS-DASH                     PIC X(03) VALUE ' - '.       
           05  WS-ERR-FIELD                PIC X(20).                   
           05  WS-ERR-FIELD-R REDEFINES WS-ERR-FIELD.                   
               10  WS-ERR-FIELD-N          PIC 9(09).99999.             
               10                          PIC X(05).                   
      *                                                                         
       01  WS-ERROR-REPORT.                                             
           05  WS-TITLE-1.                                              
               10  FILLER                      PIC X(01).               
               10  FILLER                      PIC X(08) VALUE          
                   'PCSMT618'.                                          
               10  FILLER                      PIC X(33) VALUE SPACES.  
               10  WS-TITLE1-COMP-NAME         PIC X(29) VALUE          
                   'SOUTH CAROLINA ELECTRIC & GAS'.                     
               10  FILLER                      PIC X(42) VALUE SPACES.  
               10  FILLER                      PIC X(10) VALUE          
                   'RUN DATE: '.                                        
               10  WS-TITLE1-DATE              PIC X(10).               
      *                                                                         
           05  WS-TITLE-2.                                              
               10  FILLER                      PIC X(01).               
               10  FILLER                      PIC X(35) VALUE SPACES.  
               10  FILLER                      PIC X(42) VALUE          
                   'TRANSFORMER TEST RESULTS ERROR REPORT'.             
               10  FILLER                      PIC X(35) VALUE SPACES.  
               10  FILLER                      PIC X(10) VALUE          
                   'RUN TIME: '.                                        
               10  FILLER                      PIC X(02) VALUE SPACES.  
               10  WS-TITLE2-TIME              PIC X(08) VALUE SPACES.  
      *                                                                         
           05  WS-TITLE-3.                                              
               10  FILLER                      PIC X(01).               
               10  FILLER                      PIC X(116) VALUE SPACES. 
               10  FILLER                      PIC X(08) VALUE          
                   'PAGE:   '.                                          
               10  FILLER                      PIC X(02) VALUE SPACES.  
               10  WS-TITLE3-PAGE-COUNT        PIC ZZ,ZZ9.              
      *                                                                         
           05  WS-TITLE-4.                                              
               10  FILLER                      PIC X(01).               
               10  FILLER                      PIC X(24) VALUE SPACES.  
               10  FILLER                      PIC X(03) VALUE          
                   'CT/'.                                               
               10  FILLER                      PIC X(02) VALUE SPACES.  
               10  FILLER                      PIC X(04) VALUE          
                   'TEST'.                                              
               10  FILLER                      PIC X(10) VALUE SPACES.  
               10  FILLER                      PIC X(14) VALUE          
                   'ACCURACY CLASS'.                                    
               10  FILLER                      PIC X(80) VALUE SPACES.  
      *                                                                         
           05  WS-TITLE-5.                                              
               10  FILLER                      PIC X(01).               
               10  FILLER                      PIC X(11) VALUE          
                   'DATE TESTED'.                                       
               10  FILLER                      PIC X(01) VALUE SPACES.  
               10  FILLER                      PIC X(10) VALUE          
                   'XFORMER NO'.                                        
               10  FILLER                      PIC X(02) VALUE SPACES.  
               10  FILLER                      PIC X(02) VALUE          
                   'PT'.                                                
               10  FILLER                      PIC X(03) VALUE SPACES.  
               10  FILLER                      PIC X(04) VALUE          
                   'TYPE'.                                              
               10  FILLER                      PIC X(02) VALUE SPACES.  
               10  FILLER                      PIC X(06) VALUE          
                   'TESTER'.                                            
               10  FILLER                      PIC X(02) VALUE SPACES.  
               10  FILLER                      PIC X(05) VALUE          
                   'LIGHT'.                                             
               10  FILLER                      PIC X(04) VALUE SPACES.  
               10  FILLER                      PIC X(04) VALUE          
                   'FULL'.                                              
               10  FILLER                      PIC X(06) VALUE SPACES.  
               10  FILLER                      PIC X(18) VALUE          
                   'ERROR DESC - VALUE'.                                
               10  FILLER                      PIC X(10) VALUE SPACES.  
      *                                                                         
           05  WS-DETAIL-1.                                             
               10  FILLER                      PIC X(01).               
               10  WS-DTL-DATE-TEST            PIC X(10).               
               10  FILLER                      PIC X(02) VALUE SPACES.  
               10  WS-DTL-XFMR-NO              PIC X(09).               
               10  FILLER                      PIC X(03) VALUE SPACES.  
               10  WS-DTL-XFMR-TYPE            PIC X(02) VALUE SPACES.  
               10  FILLER                      PIC X(05) VALUE SPACES.  
               10  WS-DTL-TEST-TYPE            PIC X(01) VALUE SPACES.  
               10  FILLER                      PIC X(04) VALUE SPACES.  
               10  WS-DTL-TESTER               PIC X(05) VALUE SPACES.  
               10  FILLER                      PIC X(02) VALUE SPACES.  
               10  WS-DTL-ACC-CL-LL            PIC Z9.99.               
               10  FILLER                      PIC X(03) VALUE SPACES.  
               10  WS-DTL-ACC-CL-FL            PIC Z9.99.               
               10  FILLER                      PIC X(03) VALUE SPACES.  
               10  WS-DTL-ERR-DESC             PIC X(70) VALUE SPACES.  
      *                                                                         
           05  WS-END-OF-DATA.                                          
               10  FILLER                      PIC X(55)  VALUE SPACES. 
               10  FILLER                      PIC X(23)  VALUE         
                   '*** END OF REPORT *** '.                            
               10  FILLER                      PIC X(54)  VALUE SPACES. 
      *                                                                         
           05  WS-NO-ERROR-LINE.                                        
               10  FILLER                      PIC X(55)  VALUE SPACES. 
               10  FILLER                      PIC X(23)  VALUE         
                   '*** NO ERRORS FOUND ***'.                           
               10  FILLER                      PIC X(54)  VALUE SPACES. 
      *                                                                         
       01 WS-DET-LINE-2.                                                
          05  FILLER                   PIC X(15)  VALUE SPACES.         
          05  WS-RPT-MESSAGE           PIC X(20)  VALUE SPACES.         
          05  FILLER                   PIC X(03)                        
              VALUE ':  '.                                              
          05  WS-RPT-STATISTICS        PIC ZZZZ9  VALUE SPACES.         
      *                                                                         
       01  WS-ERROR-RPT-MSGS.                                           
           05 WS-TOT-RECDS-INFO        PIC X(18)    VALUE               
              ' VALID I/P RECORDS'.                                     
           05 WS-TOT-GOOD-RECDS        PIC X(13)    VALUE               
              ' GOOD RECORDS'.                                          
           05 WS-TOT-BAD-RECDS         PIC X(12)    VALUE               
              ' BAD RECORDS'.                                           
      *                                                                         
      *****************************************************************         
      **      INCLUDE DLCGEN TABLE AND HOST VARIABLE DEFINTIONS      **         
      *****************************************************************         
      **                                                                        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQTLOC                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQTTYP                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQTRST                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQTRPR                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMVHIST                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBXFORM                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBINXFOR                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **      END OF DLCGEN TABLE AND HOST VARIABLE DEFINTIONS       **         
      *****************************************************************         
      *                                                                         
       01  WS-END                       PIC X(40) VALUE                 
           'WORKING STORAGE FOR PCSMT618 ENDS HERE  '.                  
HPCCDM*EJECT                                                                    
      *                                                                         
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *   CONTROLS MAIN PATH OF PROGRAM                                *        
      ******************************************************************        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                         
           PERFORM 1000-PROCESS-FILE THRU 1000-EXIT UNTIL END-OF-FILE.  
           PERFORM 8900-PRODUCE-SUMMARY-REPORTS THRU 8900-EXIT.         
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * OPEN FILES, DO FIRST READ OF METER TEST FILE, ACCEPT DATE     *         
      *****************************************************************         
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN INPUT FCSMT618-FILE.                                    
           IF  FMT618-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSMT618 PROCESSING ERROR      **'       
               DISPLAY '**     ERROR ON OPEN FILE FIOMT618    **'       
               DISPLAY '**     OPEN STATUS   = ' WS-FMT618-STATUS       
               DISPLAY '**     PROCESSING TERMINATED...       **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           PERFORM 7200-GET-CURRENT-DATE-TIME THRU 7200-EXIT.           
           MOVE WS-CURRENT-TIME            TO WS-TITLE2-TIME.           
           MOVE WS-CURRENT-DATE            TO WS-DB2-TODAYS-DATE        
           MOVE WS-DB2-TODAYS-DATE         TO WS-TITLE1-DATE.           
      *                                                                         
           INITIALIZE WS-ERROR-HOLD-AREA.                               
           MOVE ' - '                      TO WS-DASH.                  
      *                                                                         
           PERFORM 7000-READ-XFMR-TEST-FILE THRU 7000-EXIT.             
           IF  END-OF-FILE                                              
               MOVE WS-01                  TO C7-COMPANY-NO             
           ELSE                                                         
               MOVE E-FMT618-COMPANY-NO    TO C7-COMPANY-NO             
           END-IF.                                                      
      *                                                                         
           PERFORM  7100-GET-COMPANY-DESC THRU 7100-EXIT.               
           MOVE C7-COMPANY-NAME            TO WS-TITLE1-COMP-NAME.      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   RECEIVE, EDIT, AND PROCESS INPUT                             *        
      ******************************************************************        
       1000-PROCESS-FILE.                                               
      **************************************************************            
      *                                                                         
           MOVE WS-X                       TO EQ-CODE-UTIL-TYPE         
                                              IX-CODE-UTIL-TYPE         
                                              XT-CODE-UTIL-TYPE         
                                              MV-CODE-UTIL-TYPE         
33887                                         N3-CODE-UTIL-TYPE.        
           MOVE E-FMT618-COMPANY-NO        TO EQ-COMPANY-NO             
                                              MV-COMPANY-NO             
                                              IX-COMPANY-NO             
                                              XT-COMPANY-NO             
33887                                         N3-COMPANY-NO.            
           MOVE E-FMT618-XFORMER-NO        TO IX-XFORMER-NO             
                                              XT-XFORMER-NO             
                                              EQ-DEVICE-NO              
                                              MV-DEVICE-NO.             
           SET INPUT-IS-VALID              TO TRUE.                     
           PERFORM 1100-EDIT-RECORD THRU 1100-EXIT.                     
      *                                                                         
           IF  INPUT-IS-VALID                                           
               ADD 1                       TO WS-NBR-GOOD-RECS          
               PERFORM 2000-PROCESS-XFMR-TEST THRU 2000-EXIT            
           ELSE                                                         
               ADD 1                       TO WS-NBR-BAD-RECS           
           END-IF.                                                      
      *                                                                         
           PERFORM 7000-READ-XFMR-TEST-FILE THRU 7000-EXIT.             
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   EDIT CHECK RECORD FIELDS. IF INVALID FIELD, WRITE TO ERROR   *        
      ******************************************************************        
       1100-EDIT-RECORD.                                                
      *                                                                         
      *========================================================*                
      * VERIFY METER FOR UTIL TYPE                                              
      *========================================================*                
           MOVE E-FMT618-XFORMER-NO        TO IX-XFORMER-NO.            
           PERFORM 7020-SELECT-XFMR THRU 7020-EXIT.                     
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               MOVE 'XFORMER NOT FOUND'    TO WS-ERROR-PROBLEM          
               SET INPUT-IS-INVALID        TO TRUE                      
               PERFORM 2400-LOAD-ERROR-DATA THRU 2400-EXIT              
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY SERIAL NO                                                       
      *========================================================*                
           IF  E-FMT618-SERIAL-NO EQUAL SPACES OR LOW-VALUES            
               MOVE ZEROES                 TO WS-SERIAL-NO              
               MOVE SPACES                 TO E-FMT618-SERIAL-NO        
           END-IF.                                                      
           MOVE E-FMT618-SERIAL-NO         TO WS-SERIAL-NO              
           INSPECT WS-SERIAL-NO REPLACING ALL LOW-VALUES BY SPACES      
           MOVE 0                          TO WS-INSPECT-CNTR           
           INSPECT WS-SERIAL-NO TALLYING WS-INSPECT-CNTR FOR ALL ' '    
           COMPUTE  WS-INSPECT-CNTR =                                   
                               LENGTH OF WS-SERIAL-NO - WS-INSPECT-CNTR 
           IF  WS-INSPECT-CNTR > 0                                      
               MOVE WS-SERIAL-NO(1:WS-INSPECT-CNTR)                     
                                           TO WS-SER-NO-JUSTIFIED       
           ELSE                                                         
               MOVE SPACES                 TO WS-SER-NO-JUSTIFIED       
           END-IF                                                       
           INSPECT WS-SER-NO-JUSTIFIED REPLACING ALL ' ' BY '0'         
           MOVE WS-SER-NO-JUSTIFIED        TO WS-SERIAL-NO              
           MOVE E-FMT618-XFORMER-NO        TO EQ-DEVICE-NO.             
           PERFORM 7050-SELECT-EQ THRU 7050-EXIT.                       
           IF  WS-SERIAL-NO EQUAL EQ-SERIAL-NO                          
               CONTINUE                                                 
           ELSE                                                         
               MOVE '*WARNING-INVALID SERIAL NO '                       
                                           TO WS-ERROR-PROBLEM          
               MOVE E-FMT618-SERIAL-NO     TO WS-ERR-FIELD              
               PERFORM 2400-LOAD-ERROR-DATA THRU 2400-EXIT              
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY DATE TEST                                                       
      *========================================================*                
      *                                                                         
           MOVE E-FMT618-DATE-TEST         TO WS-DB2-DATE.              
           PERFORM 7210-VALIDATE-DATE-TEST THRU 7210-EXIT.              
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL -181                         
               MOVE E-FMT618-DATE-TEST     TO WS-ERR-FIELD              
               MOVE 'INVALID TEST DATE'    TO WS-ERROR-PROBLEM          
               SET INPUT-IS-INVALID TO TRUE                             
               PERFORM 2400-LOAD-ERROR-DATA THRU 2400-EXIT              
           ELSE                                                         
               IF  E-FMT618-DATE-TEST > WS-DB2-TODAYS-DATE              
                   SET INPUT-IS-INVALID TO TRUE                         
                   MOVE E-FMT618-DATE-TEST TO WS-ERR-FIELD              
                   MOVE 'TEST DATE GREATER THAN CURRENT DATE'           
                                           TO WS-ERROR-PROBLEM          
                   SET INPUT-IS-INVALID    TO TRUE                      
                   PERFORM 2400-LOAD-ERROR-DATA THRU 2400-EXIT          
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY TIME TEST                                                       
      *========================================================*                
      *                                                                         
           MOVE E-FMT618-TIME-TEST         TO WS-DB2-TIME.              
           PERFORM 7220-VALIDATE-TIME-TEST THRU 7220-EXIT.              
           IF  WS-ACTIVE-RETURN-CODE EQUAL -181                         
               MOVE E-FMT618-TIME-TEST     TO WS-ERR-FIELD              
               MOVE 'INVALID TEST TIME'    TO WS-ERROR-PROBLEM          
               SET INPUT-IS-INVALID        TO TRUE                      
               PERFORM 2400-LOAD-ERROR-DATA THRU 2400-EXIT              
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY E-FMT618-CODE-TEST-LOC                                          
      *========================================================*                
      *                                                                         
           MOVE E-FMT618-CODE-TEST-LOC     TO N1-CODE-TEST-LOC.         
           PERFORM 7080-SELECT-CODE-TEST-LOC THRU 7080-EXIT.            
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               MOVE E-FMT618-CODE-TEST-LOC TO WS-ERR-FIELD              
               MOVE 'INVALID LOCATION'     TO WS-ERROR-PROBLEM          
               SET INPUT-IS-INVALID        TO TRUE                      
               PERFORM 2400-LOAD-ERROR-DATA THRU 2400-EXIT              
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY CODE TEST TYPE                                                  
      *========================================================*                
           MOVE E-FMT618-CODE-TEST-TYPE    TO M9-CODE-TEST-TYPE.        
           MOVE IX-CODE-UTIL-TYPE          TO M9-CODE-UTIL-TYPE.        
      *                                                                         
           PERFORM 7070-SELECT-CODE-TEST-TYPE THRU 7070-EXIT.           
           IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               MOVE E-FMT618-CODE-TEST-TYPE                             
                                           TO WS-ERR-FIELD              
               MOVE 'INVALID TEST TYPE'    TO WS-ERROR-PROBLEM          
               SET INPUT-IS-INVALID        TO TRUE                      
               PERFORM 2400-LOAD-ERROR-DATA THRU 2400-EXIT              
           END-IF.                                                      
      *                                                                         
           IF  E-FMT618-CODE-TEST-TYPE = WS-RETIRED                     
               GO TO 1100-EXIT                                          
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY REPAIR CODE                                                     
      *========================================================*                
      *                                                                         
           MOVE E-FMT618-CODE-REPAIR       TO N3-CODE-REPAIR            
           PERFORM 7060-SELECT-CODE-REPAIR THRU 7060-EXIT.              
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               MOVE 'INVALID CODE REPAIR'  TO WS-ERROR-PROBLEM          
               MOVE E-FMT618-CODE-REPAIR   TO WS-ERR-FIELD              
               SET INPUT-IS-INVALID        TO TRUE                      
               PERFORM 2400-LOAD-ERROR-DATA THRU 2400-EXIT              
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY E-FMT618-CODE-TEST-RESULT                                       
      *========================================================*                
      *                                                                         
           MOVE E-FMT618-CODE-TEST-RESULT  TO N2-CODE-TEST-RESULT.      
           PERFORM 7090-SELECT-CODE-TEST-RSLT THRU 7090-EXIT.           
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               MOVE E-FMT618-CODE-TEST-RESULT                           
                                           TO WS-ERR-FIELD              
               MOVE 'INVALID TEST RESULT CODE'                          
                                           TO WS-ERROR-PROBLEM          
               SET INPUT-IS-INVALID        TO TRUE                      
               PERFORM 2400-LOAD-ERROR-DATA THRU 2400-EXIT              
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY ACCURACY-CLASS-LL                                               
      *========================================================*                
      *                                                                         
           IF  E-FMT618-ACCURACY-CLASS-LL NOT NUMERIC                   
               MOVE E-FMT618-ACCU-CLASS-LL-A                            
                                           TO WS-ERR-FIELD              
               MOVE 'INVALID ACCURACY CLASS LL'                         
                                           TO WS-ERROR-PROBLEM          
               SET INPUT-IS-INVALID TO TRUE                             
               PERFORM 2400-LOAD-ERROR-DATA THRU 2400-EXIT              
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY ACCURACY-CLASS-FL                                               
      *========================================================*                
      *                                                                         
           IF  E-FMT618-ACCURACY-CLASS-FL NOT NUMERIC                   
               MOVE E-FMT618-ACCU-CLASS-FL-A                            
                                           TO WS-ERR-FIELD              
               MOVE 'INVALID ACCURACY CLASS FL'                         
                                           TO WS-ERROR-PROBLEM          
               SET INPUT-IS-INVALID TO TRUE                             
               PERFORM 2400-LOAD-ERROR-DATA THRU 2400-EXIT              
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY PH-ANG-ERR-LL-SIGN                                              
      *========================================================*                
      *                                                                         
           IF  E-FMT618-PH-ANG-ERR-LL-SIGN NOT EQUAL SPACES             
                           AND WS-MINUS                                 
               MOVE E-FMT618-PH-ANG-ERR-LL-SIGN                         
                                           TO WS-ERR-FIELD              
               MOVE 'INVALID PH-ANG-ERR-LL-SIGN'                        
                                           TO WS-ERROR-PROBLEM          
               SET INPUT-IS-INVALID TO TRUE                             
               PERFORM 2400-LOAD-ERROR-DATA THRU 2400-EXIT              
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY PH-ANG-ERR-ACCU-LL                                              
      *========================================================*                
      *                                                                         
           IF  E-FMT618-PH-ANG-ERR-ACCU-LL NOT NUMERIC                  
               MOVE E-FMT618-PH-ANG-ERR-ACCU-LL-A                       
                                           TO WS-ERR-FIELD              
               MOVE 'INVALID PH-ANG-ERR-ACCU-LL'                        
                                           TO WS-ERROR-PROBLEM          
               SET INPUT-IS-INVALID TO TRUE                             
               PERFORM 2400-LOAD-ERROR-DATA THRU 2400-EXIT              
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY PH-ANG-ERR-FL-SIGN                                              
      *========================================================*                
      *                                                                         
           IF  E-FMT618-PH-ANG-ERR-FL-SIGN NOT EQUAL SPACES             
                           AND WS-MINUS                                 
               MOVE E-FMT618-PH-ANG-ERR-FL-SIGN                         
                                           TO WS-ERR-FIELD              
               MOVE 'INVALID PH-ANG-ERR-FL-SIGN'                        
                                           TO WS-ERROR-PROBLEM          
               SET INPUT-IS-INVALID TO TRUE                             
               PERFORM 2400-LOAD-ERROR-DATA THRU 2400-EXIT              
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY PH-ANG-ERR-ACCU-FL                                              
      *========================================================*                
      *                                                                         
           IF  E-FMT618-PH-ANG-ERR-ACCU-FL NOT NUMERIC                  
               MOVE E-FMT618-PH-ANG-ERR-ACCU-FL-A                       
                                           TO WS-ERR-FIELD              
               MOVE 'INVALID PH-ANG-ERR-ACCU-FL'                        
                                           TO WS-ERROR-PROBLEM          
               SET INPUT-IS-INVALID TO TRUE                             
               PERFORM 2400-LOAD-ERROR-DATA THRU 2400-EXIT              
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY RCF-ACCU-LL                                                     
      *========================================================*                
      *                                                                         
           IF  E-FMT618-RCF-ACCU-LL NOT NUMERIC                         
               MOVE E-FMT618-RCF-ACCU-LL-A                              
                                           TO WS-ERR-FIELD              
               MOVE 'INVALID RCF-ACCU-LL'                               
                                           TO WS-ERROR-PROBLEM          
               SET INPUT-IS-INVALID        TO TRUE                      
               PERFORM 2400-LOAD-ERROR-DATA THRU 2400-EXIT              
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY RCF-ACCU-FL                                                     
      *========================================================*                
      *                                                                         
           IF  E-FMT618-RCF-ACCU-FL NOT NUMERIC                         
               MOVE E-FMT618-RCF-ACCU-FL-A                              
                                           TO WS-ERR-FIELD              
               MOVE 'INVALID RCF-ACCU-FL'                               
                                           TO WS-ERROR-PROBLEM          
               SET INPUT-IS-INVALID        TO TRUE                      
               PERFORM 2400-LOAD-ERROR-DATA THRU 2400-EXIT              
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY AMP-VOLT-ACCU-LL                                                
      *========================================================*                
      *                                                                         
           IF  E-FMT618-AMP-VOLT-ACCU-LL NOT NUMERIC                    
               MOVE E-FMT618-AMP-VOLT-ACCU-LL-A                         
                                           TO WS-ERR-FIELD              
               MOVE 'INVALID AMP-VOLT-ACCU-LL'                          
                                           TO WS-ERROR-PROBLEM          
               SET INPUT-IS-INVALID        TO TRUE                      
               PERFORM 2400-LOAD-ERROR-DATA THRU 2400-EXIT              
           END-IF.                                                      
      *                                                                         
      *========================================================*                
      *  VERIFY AMP-VOLT-ACCU-FL                                                
      *========================================================*                
      *                                                                         
           IF  E-FMT618-AMP-VOLT-ACCU-FL NOT NUMERIC                    
               MOVE E-FMT618-AMP-VOLT-ACCU-FL-A                         
                                           TO WS-ERR-FIELD              
               MOVE 'INVALID AMP-VOLT-ACCU-FL'                          
                                           TO WS-ERROR-PROBLEM          
               SET INPUT-IS-INVALID        TO TRUE                      
               PERFORM 2400-LOAD-ERROR-DATA THRU 2400-EXIT              
           END-IF.                                                      
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2000-PROCESS-XFMR-TEST.                                          
      *                                                                         
           IF  E-FMT618-CODE-TEST-TYPE = WS-RETIRED                     
               PERFORM 2100-RETIRE-XFMR THRU 2100-EXIT                  
               GO TO 2000-EXIT                                          
           END-IF.                                                      
      *                                                                         
           MOVE E-FMT618-XFORMER-NO        TO XT-XFORMER-NO.            
           MOVE E-FMT618-DATE-TEST         TO XT-DATE-TEST.             
           MOVE E-FMT618-TIME-TEST         TO XT-TIME-TEST.             
           MOVE E-FMT618-CODE-REPAIR       TO XT-CODE-REPAIR.           
           MOVE E-FMT618-REPAIR-DESC       TO XT-REPAIR-DESC.           
           MOVE E-FMT618-CODE-TEST-TYPE    TO XT-CODE-TEST-TYPE.        
           MOVE E-FMT618-CODE-TEST-RESULT  TO XT-CODE-TEST-RESULT.      
      *                                                                         
           MOVE E-FMT618-CODE-TEST-LOC     TO XT-CODE-TEST-LOC.         
           MOVE E-FMT618-EQ-TESTER-ID      TO XT-EQ-TESTER-ID.          
      *                                                                         
           MOVE E-FMT618-ACCURACY-CLASS-LL TO XT-ACCURACY-CLASS-LL.     
           MOVE E-FMT618-ACCURACY-CLASS-FL TO XT-ACCURACY-CLASS-FL.     
           MOVE E-FMT618-RCF-ACCU-LL       TO XT-RCF-ACCU-LL.           
           MOVE E-FMT618-RCF-ACCU-FL       TO XT-RCF-ACCU-FL.           
           MOVE E-FMT618-BURDEN-ACCU-LL    TO XT-BURDEN-ACCU-LL.        
           MOVE E-FMT618-BURDEN-ACCU-FL    TO XT-BURDEN-ACCU-FL.        
           MOVE E-FMT618-AMP-VOLT-ACCU-LL  TO XT-AMP-VOLT-ACCU-LL.      
           MOVE E-FMT618-AMP-VOLT-ACCU-FL  TO XT-AMP-VOLT-ACCU-FL.      
      *                                                                         
           IF  E-FMT618-PH-ANG-ERR-LL-SIGN = WS-MINUS                   
               COMPUTE XT-PH-ANG-ERR-ACCU-LL =                          
                            E-FMT618-PH-ANG-ERR-ACCU-LL * -1            
           ELSE                                                         
               COMPUTE XT-PH-ANG-ERR-ACCU-LL =                          
                            E-FMT618-PH-ANG-ERR-ACCU-LL                 
           END-IF.                                                      
      *                                                                         
           IF  E-FMT618-PH-ANG-ERR-FL-SIGN = WS-MINUS                   
               COMPUTE XT-PH-ANG-ERR-ACCU-FL =                          
                            E-FMT618-PH-ANG-ERR-ACCU-FL * -1            
           ELSE                                                         
C31190         COMPUTE XT-PH-ANG-ERR-ACCU-FL =                          
                            E-FMT618-PH-ANG-ERR-ACCU-FL                 
           END-IF.                                                      
      *                                                                         
           PERFORM 8200-INSERT-XFMR-TEST THRU 8200-EXIT.                
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL ALREADY-EXISTS               
               PERFORM 8250-UPDATE-XFMR-TEST THRU 8250-EXIT             
           END-IF.                                                      
      *                                                                         
           MOVE E-FMT618-XFORMER-NO        TO EQ-DEVICE-NO.             
           MOVE E-FMT618-COMPANY-NO        TO EQ-COMPANY-NO.            
           PERFORM 8100-UPDATE-EQUIP THRU 8100-EXIT.                    
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2100-RETIRE-XFMR.                                                
      *                                                                         
           MOVE E-FMT618-XFORMER-NO        TO EQ-DEVICE-NO              
                                              MV-DEVICE-NO              
           PERFORM 7050-SELECT-EQ THRU 7050-EXIT.                       
           IF  DATE-LAST-MOVE-NULL                                      
               MOVE E-FMT618-DATE-TEST     TO MV-DATE-MOVE              
           ELSE                                                         
               MOVE EQ-DATE-LAST-MOVE      TO MV-DATE-MOVE              
           END-IF                                                       
           MOVE EQ-COMPANY-NO              TO MV-COMPANY-NO             
           MOVE EQ-LOCAL-OFFICE            TO MV-LOCAL-OFFICE           
           MOVE EQ-CRNT-LOC-NO             TO MV-LOC-NO                 
           MOVE EQ-CODE-CRNT-LOC           TO MV-CODE-CRNT-LOC          
           MOVE EQ-EQUIP-TYPE-CD           TO MV-CODE-DEVICE-TYPE       
           PERFORM 8300-INSERT-MOVEMENT-HIST THRU 8300-EXIT             
           MOVE E-FMT618-DATE-TEST         TO EQ-DATE-LAST-MOVE         
           MOVE ZEROS                      TO EQ-CRNT-LOC-NO            
           MOVE 'I'                        TO EQ-CODE-CRNT-LOC          
           MOVE E-FMT618-REPAIR-DESC       TO EQ-UPGRADES-TX.           
           PERFORM 8350-UPDATE-CRNT-LOC THRU 8350-EXIT.                 
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2400-LOAD-ERROR-DATA.                                            
           SET ERROR-FOUND                 TO TRUE.                     
           MOVE E-FMT618-XFORMER-NO        TO WS-DTL-XFMR-NO            
           MOVE IX-XFORMER-TYPE-CD         TO WS-DTL-XFMR-TYPE          
           MOVE E-FMT618-DATE-TEST         TO WS-DTL-DATE-TEST          
           MOVE E-FMT618-CODE-TEST-TYPE    TO WS-DTL-TEST-TYPE          
           MOVE E-FMT618-EQ-TESTER-ID      TO WS-DTL-TESTER             
           MOVE E-FMT618-ACCURACY-CLASS-LL TO WS-DTL-ACC-CL-LL          
           MOVE E-FMT618-ACCURACY-CLASS-FL TO WS-DTL-ACC-CL-FL          
           MOVE WS-ERROR-HOLD-AREA         TO WS-DTL-ERR-DESC.          
      *                                                                         
           PERFORM 8000-WRITE-ERROR-REPORT THRU 8000-EXIT.              
      *                                                                         
           INITIALIZE WS-ERROR-HOLD-AREA.                               
           MOVE ' - '                      TO WS-DASH.                  
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * READ XFMR TEST RESULTS FILE                                    *        
      ******************************************************************        
       7000-READ-XFMR-TEST-FILE.                                        
      *                                                                         
           READ FCSMT618-FILE                                           
                AT END MOVE 'Y' TO WS-EOF-FLAG.                         
      *                                                                         
           IF  END-OF-FILE                                              
               CONTINUE                                                 
           ELSE                                                         
               IF  FMT618-SUCCESSFUL                                    
                   ADD 1                   TO WS-NBR-XFMR-TEST-RECS     
               ELSE                                                     
                   DISPLAY '****************************************'   
                   DISPLAY '**     PCSMT618 PROCESSING ERROR      **'   
                   DISPLAY '**     ABEND IN PARAGRAPH 7000        **'   
                   DISPLAY '**     READ STATUS   = ' WS-FMT618-STATUS   
                   DISPLAY '**     PROCESSING TERMINATED...       **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7020-SELECT-XFMR.                                                
           EXEC SQL                                                     
             SELECT XFORMER_TYPE_CD                                     
               INTO :IX-XFORMER-TYPE-CD                                 
               FROM CSS_INSTR_XFORMER WITH(READUNCOMMITTED)                     
              WHERE CODE_UTIL_TYPE = :IX-CODE-UTIL-TYPE                 
                AND COMPANY_NO     = :IX-COMPANY-NO                     
                AND XFORMER_NO     = :IX-XFORMER-NO                     
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT XFORMER_TYPE_CD                                             
MFA-TR*        INTO :IX-XFORMER-TYPE-CD                                         
MFA-TR*        FROM CSS_INSTR_XFORMER                                           
MFA-TR*       WHERE CODE_UTIL_TYPE = :IX-CODE-UTIL-TYPE                         
MFA-TR*         AND COMPANY_NO     = :IX-COMPANY-NO                             
MFA-TR*         AND XFORMER_NO     = :IX-XFORMER-NO                             
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**  PCSMT618 PROCESSING ERROR      **'          
               DISPLAY '**  ABEND IN PARAGRAPH 7020       **'           
               DISPLAY '**      COMPANY-NO    = ' IX-COMPANY-NO         
               DISPLAY '**      XFORMER-NO    = ' IX-XFORMER-NO         
               DISPLAY '**            SQLCODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7050-SELECT-EQ.                                                  
      *                                                                         
           EXEC SQL                                                     
             SELECT COMPANY_NO                                          
                   ,SERIAL_NO                                           
                   ,CODE_CRNT_LOC                                       
                   ,CRNT_LOC_NO                                         
                   ,INSTALL_DT                                          
                   ,LOCAL_OFFICE                                        
                   ,DATE_LAST_MOVE                                      
                   ,EQUIP_TYPE_CD                                       
               INTO :EQ-COMPANY-NO                                      
                   ,:EQ-SERIAL-NO                                       
                   ,:EQ-CODE-CRNT-LOC                                   
                   ,:EQ-CRNT-LOC-NO                                     
                   ,:EQ-INSTALL-DT :WS-INSTALL-DT-NULL                   
                   ,:EQ-LOCAL-OFFICE                                    
                   ,:EQ-DATE-LAST-MOVE :WS-DATE-LAST-MOVE-NULL           
                   ,:EQ-EQUIP-TYPE-CD                                   
               FROM CSS_EQUIPMENT WITH(READUNCOMMITTED)                         
              WHERE CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                 
                AND COMPANY_NO     = :EQ-COMPANY-NO                     
                AND DEVICE_NO      = :EQ-DEVICE-NO                      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT COMPANY_NO                                                  
MFA-TR*            ,SERIAL_NO                                                   
MFA-TR*            ,CODE_CRNT_LOC                                               
MFA-TR*            ,CRNT_LOC_NO                                                 
MFA-TR*            ,INSTALL_DT                                                  
MFA-TR*            ,LOCAL_OFFICE                                                
MFA-TR*            ,DATE_LAST_MOVE                                              
MFA-TR*            ,EQUIP_TYPE_CD                                               
MFA-TR*        INTO :EQ-COMPANY-NO                                              
MFA-TR*            ,:EQ-SERIAL-NO                                               
MFA-TR*            ,:EQ-CODE-CRNT-LOC                                           
MFA-TR*            ,:EQ-CRNT-LOC-NO                                             
MFA-TR*            ,:EQ-INSTALL-DT:WS-INSTALL-DT-NULL                           
MFA-TR*            ,:EQ-LOCAL-OFFICE                                            
MFA-TR*            ,:EQ-DATE-LAST-MOVE:WS-DATE-LAST-MOVE-NULL                   
MFA-TR*            ,:EQ-EQUIP-TYPE-CD                                           
MFA-TR*        FROM CSS_EQUIPMENT                                               
MFA-TR*       WHERE CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                         
MFA-TR*         AND COMPANY_NO     = :EQ-COMPANY-NO                             
MFA-TR*         AND DEVICE_NO      = :EQ-DEVICE-NO                              
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**  PCSMT618 PROCESSING ERROR      **'          
               DISPLAY '**  ABEND IN PARAGRAPH 7050       **'           
               DISPLAY '**      COMPANY-NO    = ' EQ-COMPANY-NO         
               DISPLAY '**      DEVICE-NO     = ' EQ-DEVICE-NO          
               DISPLAY '**            SQLCODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7060-SELECT-CODE-REPAIR.                                         
      *                                                                         
           EXEC SQL                                                     
               SELECT CODE_REPAIR                                       
                 INTO :N3-CODE-REPAIR                                   
                 FROM CSS_EQUIP_TST_REPR WITH(READUNCOMMITTED)                  
                WHERE CODE_REPAIR = :N3-CODE-REPAIR                     
33887             AND CODE_UTIL_TYPE = :N3-CODE-UTIL-TYPE               
33887             AND COMPANY_NO     = :N3-COMPANY-NO                   
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_REPAIR                                               
MFA-TR*          INTO :N3-CODE-REPAIR                                           
MFA-TR*          FROM CSS_EQUIP_TST_REPR                                        
MFA-TR*         WHERE CODE_REPAIR = :N3-CODE-REPAIR                             
MFA-TR*           AND CODE_UTIL_TYPE = :N3-CODE-UTIL-TYPE                       
MFA-TR*           AND COMPANY_NO     = :N3-COMPANY-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**  PCSMT618 PROCESSING ERROR      **'          
               DISPLAY '**  ABEND IN PARAGRAPH 7060       **'           
               DISPLAY '**      COMPANY-NO    = ' EQ-COMPANY-NO         
               DISPLAY '**      DEVICE-NO     = ' EQ-DEVICE-NO          
               DISPLAY '**      CODE-REPAIR   = ' N3-CODE-REPAIR        
               DISPLAY '**            SQLCODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7070-SELECT-CODE-TEST-TYPE.                                      
      *                                                                         
           EXEC SQL                                                     
               SELECT CODE_TEST_TYPE                                    
                 INTO :M9-CODE-TEST-TYPE                                
                 FROM CSS_EQUIP_TEST_TYP WITH(READUNCOMMITTED)                  
                WHERE CODE_TEST_TYPE = :M9-CODE-TEST-TYPE               
                  AND CODE_UTIL_TYPE = :M9-CODE-UTIL-TYPE               
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_TEST_TYPE                                            
MFA-TR*          INTO :M9-CODE-TEST-TYPE                                        
MFA-TR*          FROM CSS_EQUIP_TEST_TYP                                        
MFA-TR*         WHERE CODE_TEST_TYPE = :M9-CODE-TEST-TYPE                       
MFA-TR*           AND CODE_UTIL_TYPE = :M9-CODE-UTIL-TYPE                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**  PCSMT618 PROCESSING ERROR      **'          
               DISPLAY '**  ABEND IN PARAGRAPH 7070       **'           
               DISPLAY '**      COMPANY-NO    = ' EQ-COMPANY-NO         
               DISPLAY '**      DEVICE-NO     = ' EQ-DEVICE-NO          
               DISPLAY '**    CODE-TEST-TYPE  = ' M9-CODE-TEST-TYPE     
               DISPLAY '**            SQLCODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7080-SELECT-CODE-TEST-LOC.                                       
      *                                                                         
           EXEC SQL                                                     
               SELECT CODE_TEST_LOC                                     
                 INTO :N1-CODE-TEST-LOC                                 
                 FROM CSS_EQUIP_TEST_LOC WITH(READUNCOMMITTED)                  
                WHERE CODE_TEST_LOC = :N1-CODE-TEST-LOC                 
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_TEST_LOC                                             
MFA-TR*          INTO :N1-CODE-TEST-LOC                                         
MFA-TR*          FROM CSS_EQUIP_TEST_LOC                                        
MFA-TR*         WHERE CODE_TEST_LOC = :N1-CODE-TEST-LOC                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**  PCSMT618 PROCESSING ERROR      **'          
               DISPLAY '**  ABEND IN PARAGRAPH 7080       **'           
               DISPLAY '**      COMPANY-NO    = ' EQ-COMPANY-NO         
               DISPLAY '**      DEVICE-NO     = ' EQ-DEVICE-NO          
               DISPLAY '**    CODE-TEST-LOC   = ' N1-CODE-TEST-LOC      
               DISPLAY '**            SQLCODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7080-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7090-SELECT-CODE-TEST-RSLT.                                      
      *                                                                         
           EXEC SQL                                                     
               SELECT CODE_TEST_RESULT                                  
                 INTO :N2-CODE-TEST-RESULT                              
                 FROM CSS_EQUIP_TST_RSLT WITH(READUNCOMMITTED)                  
                WHERE CODE_TEST_RESULT = :N2-CODE-TEST-RESULT           
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_TEST_RESULT                                          
MFA-TR*          INTO :N2-CODE-TEST-RESULT                                      
MFA-TR*          FROM CSS_EQUIP_TST_RSLT                                        
MFA-TR*         WHERE CODE_TEST_RESULT = :N2-CODE-TEST-RESULT                   
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**  PCSMT618 PROCESSING ERROR      **'          
               DISPLAY '**  ABEND IN PARAGRAPH 7090       **'           
               DISPLAY '**      COMPANY-NO    = ' EQ-COMPANY-NO         
               DISPLAY '**      DEVICE-NO     = ' EQ-DEVICE-NO          
               DISPLAY '**   CODE-TEST-RESULT = ' N2-CODE-TEST-RESULT   
               DISPLAY '**            SQLCODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7090-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7100-GET-COMPANY-DESC.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT  COMPANY_NAME                                     
                 INTO :C7-COMPANY-NAME                                  
                 FROM  CSS_COMPANY WITH(READUNCOMMITTED)                        
                WHERE  COMPANY_NO = :C7-COMPANY-NO                      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  COMPANY_NAME                                             
MFA-TR*          INTO :C7-COMPANY-NAME                                          
MFA-TR*          FROM  CSS_COMPANY                                              
MFA-TR*         WHERE  COMPANY_NO = :C7-COMPANY-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**  PCSMT618 PROCESSING ERROR      **'          
               DISPLAY '**  ABEND IN PARAGRAPH 7100       **'           
               DISPLAY '**      COMPANY-NO    = ' C7-COMPANY-NO         
               DISPLAY '**            SQLCODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7200-GET-CURRENT-DATE-TIME.                                      
           EXEC SQL                                                     
T35434          SELECT
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIME,
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIME = CURRENT TIME                             
MFA-TR*            ,:WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**  PCSMT618 PROCESSING ERROR      **'          
               DISPLAY '**  ABEND IN PARAGRAPH 7200       **'           
               DISPLAY '**            SQLCODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7210-VALIDATE-DATE-TEST.                                         
           EXEC SQL                                                     
T35434          SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :WS-DB2-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DB2-DATE
              ) <> 0) OR (LEN(:WS-DB2-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-DB2-DATE
              ), CONVERT(DATE, :WS-DB2-DATE) ) )
            INTO
              :WS-DB2-DATE           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-DB2-DATE = DATE(:WS-DB2-DATE) - 1 DAY                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -181      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**  PCSMT618 PROCESSING ERROR      **'          
               DISPLAY '**  ABEND IN PARAGRAPH 7210       **'           
               DISPLAY '**           DB2 DATE = ' WS-DB2-DATE           
               DISPLAY '**            SQLCODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7220-VALIDATE-TIME-TEST.                                         
           EXEC SQL                                                     
T35434          SELECT
              REPLACE(CONVERT(CHAR(8), DATEADD( SECOND, -1, 
           CIS.CHAR2TIME(:WS-DB2-TIME) ), 108), ':', '.')
            INTO
              :WS-DB2-TIME        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-DB2-TIME = TIME(:WS-DB2-TIME) - 1 SECOND                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -181      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**  PCSMT618 PROCESSING ERROR      **'          
               DISPLAY '**  ABEND IN PARAGRAPH 7220       **'           
               DISPLAY '**           DB2 TIME = ' WS-DB2-TIME           
               DISPLAY '**            SQLCODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8000-WRITE-ERROR-REPORT.                                         
      *                                                                         
           IF  (57 - WS-LINE-COUNT) < 2                                 
               ADD  1                          TO WS-PAGE-COUNT         
               MOVE WS-PAGE-COUNT              TO WS-TITLE3-PAGE-COUNT  
               WRITE PRT33-RECORD FROM WS-TITLE-1 AFTER NEW-PAGE        
               WRITE PRT33-RECORD FROM WS-TITLE-2 AFTER 1               
               WRITE PRT33-RECORD FROM WS-TITLE-3 AFTER 1               
               WRITE PRT33-RECORD FROM WS-TITLE-4 AFTER 1               
               WRITE PRT33-RECORD FROM WS-TITLE-5 AFTER 1               
               MOVE 6                          TO WS-LINE-COUNT         
           END-IF.                                                      
           WRITE PRT33-RECORD FROM WS-DETAIL-1 AFTER 2.                 
           ADD 2                               TO WS-LINE-COUNT.        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8100-UPDATE-EQUIP.                                               
           EXEC SQL                                                     
               UPDATE CSS_EQUIPMENT                                     
                SET DATE_LAST_TRAN  = CAST(SYSDATETIMEOFFSET() AS DATE)         
               WHERE CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                
                 AND COMPANY_NO     = :EQ-COMPANY-NO                    
                 AND DEVICE_NO      = :EQ-DEVICE-NO                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_EQUIPMENT                                             
MFA-TR*         SET DATE_LAST_TRAN  = CURRENT DATE                              
MFA-TR*        WHERE CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                        
MFA-TR*          AND COMPANY_NO     = :EQ-COMPANY-NO                            
MFA-TR*          AND DEVICE_NO      = :EQ-DEVICE-NO                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**  PCSMT618 PROCESSING ERROR      **'          
               DISPLAY '**  ABEND IN PARAGRAPH 8100       **'           
               DISPLAY '**      COMPANY-NO    = ' EQ-COMPANY-NO         
               DISPLAY '**      DEVICE-NO     = ' EQ-DEVICE-NO          
               DISPLAY '**            SQLCODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8200-INSERT-XFMR-TEST.                                           
           EXEC SQL                                                     
               INSERT INTO CSS_XFORMER_TEST                             
                    (XFORMER_NO                                         
                    ,DATE_TEST                                          
                    ,TIME_TEST                                          
                    ,CODE_UTIL_TYPE                                     
                    ,CODE_TEST_TYPE                                     
                    ,CODE_REPAIR                                        
                    ,REPAIR_DESC                                        
                    ,CODE_TEST_LOC                                      
                    ,CODE_TEST_RESULT                                   
                    ,EQ_TESTER_ID                                       
                    ,ACCURACY_CLASS_LL                                  
                    ,ACCURACY_CLASS_FL                                  
                    ,PH_ANG_ERR_ACCU_LL                                 
                    ,PH_ANG_ERR_ACCU_FL                                 
                    ,RCF_ACCU_LL                                        
                    ,RCF_ACCU_FL                                        
                    ,BURDEN_ACCU_LL                                     
                    ,BURDEN_ACCU_FL                                     
                    ,AMP_VOLT_ACCU_LL                                   
                    ,AMP_VOLT_ACCU_FL                                   
                    ,COMPANY_NO   )                                     
               VALUES (:XT-XFORMER-NO                                   
                      ,IIF(TRY_CONVERT(DATE, :XT-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :XT-DATE-TEST
              ) <> 0) OR (LEN(:XT-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :XT-DATE-TEST
              ), CONVERT(DATE, :XT-DATE-TEST) )                                
                      ,CIS.CHAR2TIME(:XT-TIME-TEST)                             
                      ,:XT-CODE-UTIL-TYPE                               
                      ,:XT-CODE-TEST-TYPE                               
                      ,:XT-CODE-REPAIR                                  
                      ,:XT-REPAIR-DESC                                  
                      ,:XT-CODE-TEST-LOC                                
                      ,:XT-CODE-TEST-RESULT                             
                      ,:XT-EQ-TESTER-ID                                 
                      ,:XT-ACCURACY-CLASS-LL                            
                      ,:XT-ACCURACY-CLASS-FL                            
                      ,:XT-PH-ANG-ERR-ACCU-LL                           
                      ,:XT-PH-ANG-ERR-ACCU-FL                           
                      ,:XT-RCF-ACCU-LL                                  
                      ,:XT-RCF-ACCU-FL                                  
                      ,:XT-BURDEN-ACCU-LL                               
                      ,:XT-BURDEN-ACCU-FL                               
                      ,:XT-AMP-VOLT-ACCU-LL                             
                      ,:XT-AMP-VOLT-ACCU-FL                             
                      ,:XT-COMPANY-NO  )                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_XFORMER_TEST                                     
MFA-TR*             (XFORMER_NO                                                 
MFA-TR*             ,DATE_TEST                                                  
MFA-TR*             ,TIME_TEST                                                  
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,CODE_TEST_TYPE                                             
MFA-TR*             ,CODE_REPAIR                                                
MFA-TR*             ,REPAIR_DESC                                                
MFA-TR*             ,CODE_TEST_LOC                                              
MFA-TR*             ,CODE_TEST_RESULT                                           
MFA-TR*             ,EQ_TESTER_ID                                               
MFA-TR*             ,ACCURACY_CLASS_LL                                          
MFA-TR*             ,ACCURACY_CLASS_FL                                          
MFA-TR*             ,PH_ANG_ERR_ACCU_LL                                         
MFA-TR*             ,PH_ANG_ERR_ACCU_FL                                         
MFA-TR*             ,RCF_ACCU_LL                                                
MFA-TR*             ,RCF_ACCU_FL                                                
MFA-TR*             ,BURDEN_ACCU_LL                                             
MFA-TR*             ,BURDEN_ACCU_FL                                             
MFA-TR*             ,AMP_VOLT_ACCU_LL                                           
MFA-TR*             ,AMP_VOLT_ACCU_FL                                           
MFA-TR*             ,COMPANY_NO   )                                             
MFA-TR*        VALUES (:XT-XFORMER-NO                                           
MFA-TR*               ,:XT-DATE-TEST                                            
MFA-TR*               ,:XT-TIME-TEST                                            
MFA-TR*               ,:XT-CODE-UTIL-TYPE                                       
MFA-TR*               ,:XT-CODE-TEST-TYPE                                       
MFA-TR*               ,:XT-CODE-REPAIR                                          
MFA-TR*               ,:XT-REPAIR-DESC                                          
MFA-TR*               ,:XT-CODE-TEST-LOC                                        
MFA-TR*               ,:XT-CODE-TEST-RESULT                                     
MFA-TR*               ,:XT-EQ-TESTER-ID                                         
MFA-TR*               ,:XT-ACCURACY-CLASS-LL                                    
MFA-TR*               ,:XT-ACCURACY-CLASS-FL                                    
MFA-TR*               ,:XT-PH-ANG-ERR-ACCU-LL                                   
MFA-TR*               ,:XT-PH-ANG-ERR-ACCU-FL                                   
MFA-TR*               ,:XT-RCF-ACCU-LL                                          
MFA-TR*               ,:XT-RCF-ACCU-FL                                          
MFA-TR*               ,:XT-BURDEN-ACCU-LL                                       
MFA-TR*               ,:XT-BURDEN-ACCU-FL                                       
MFA-TR*               ,:XT-AMP-VOLT-ACCU-LL                                     
MFA-TR*               ,:XT-AMP-VOLT-ACCU-FL                                     
MFA-TR*               ,:XT-COMPANY-NO  )                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
                                         OR ALREADY-EXISTS              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**  PCSMT618 PROCESSING ERROR      **'          
               DISPLAY '**  ABEND IN PARAGRAPH 8200       **'           
               DISPLAY '**      COMPANY-NO    = ' XT-COMPANY-NO         
               DISPLAY '**      XFORMER-NO    = ' XT-XFORMER-NO         
               DISPLAY '**      DATE-TEST     = ' XT-DATE-TEST          
               DISPLAY '**      TIME-TEST     = ' XT-TIME-TEST          
               DISPLAY '**            SQLCODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8250-UPDATE-XFMR-TEST.                                           
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_XFORMER_TEST                                  
                  SET CODE_TEST_TYPE      = :XT-CODE-TEST-TYPE          
                     ,CODE_REPAIR         = :XT-CODE-REPAIR             
                     ,REPAIR_DESC         = :XT-REPAIR-DESC             
                     ,CODE_TEST_LOC       = :XT-CODE-TEST-LOC           
                     ,CODE_TEST_RESULT    = :XT-CODE-TEST-RESULT        
                     ,EQ_TESTER_ID        = :XT-EQ-TESTER-ID            
                     ,ACCURACY_CLASS_LL   = :XT-ACCURACY-CLASS-LL       
                     ,ACCURACY_CLASS_FL   = :XT-ACCURACY-CLASS-FL       
                     ,PH_ANG_ERR_ACCU_LL  = :XT-PH-ANG-ERR-ACCU-LL      
                     ,PH_ANG_ERR_ACCU_FL  = :XT-PH-ANG-ERR-ACCU-FL      
                     ,RCF_ACCU_LL         = :XT-RCF-ACCU-LL             
                     ,RCF_ACCU_FL         = :XT-RCF-ACCU-FL             
                     ,BURDEN_ACCU_LL      = :XT-BURDEN-ACCU-LL          
                     ,BURDEN_ACCU_FL      = :XT-BURDEN-ACCU-FL          
                     ,AMP_VOLT_ACCU_LL    = :XT-AMP-VOLT-ACCU-LL        
                     ,AMP_VOLT_ACCU_FL    = :XT-AMP-VOLT-ACCU-FL        
               WHERE CODE_UTIL_TYPE   = :XT-CODE-UTIL-TYPE              
                 AND COMPANY_NO       = :XT-COMPANY-NO                  
                 AND XFORMER_NO       = :XT-XFORMER-NO                  
                 AND DATE_TEST        = IIF(TRY_CONVERT(DATE, 
                                                          :XT-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :XT-DATE-TEST
              ) <> 0) OR (LEN(:XT-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :XT-DATE-TEST
              ), CONVERT(DATE, :XT-DATE-TEST) )                   
                 AND TIME_TEST        = CIS.CHAR2TIME(:XT-TIME-TEST)            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_XFORMER_TEST                                          
MFA-TR*           SET CODE_TEST_TYPE      = :XT-CODE-TEST-TYPE                  
MFA-TR*              ,CODE_REPAIR         = :XT-CODE-REPAIR                     
MFA-TR*              ,REPAIR_DESC         = :XT-REPAIR-DESC                     
MFA-TR*              ,CODE_TEST_LOC       = :XT-CODE-TEST-LOC                   
MFA-TR*              ,CODE_TEST_RESULT    = :XT-CODE-TEST-RESULT                
MFA-TR*              ,EQ_TESTER_ID        = :XT-EQ-TESTER-ID                    
MFA-TR*              ,ACCURACY_CLASS_LL   = :XT-ACCURACY-CLASS-LL               
MFA-TR*              ,ACCURACY_CLASS_FL   = :XT-ACCURACY-CLASS-FL               
MFA-TR*              ,PH_ANG_ERR_ACCU_LL  = :XT-PH-ANG-ERR-ACCU-LL              
MFA-TR*              ,PH_ANG_ERR_ACCU_FL  = :XT-PH-ANG-ERR-ACCU-FL              
MFA-TR*              ,RCF_ACCU_LL         = :XT-RCF-ACCU-LL                     
MFA-TR*              ,RCF_ACCU_FL         = :XT-RCF-ACCU-FL                     
MFA-TR*              ,BURDEN_ACCU_LL      = :XT-BURDEN-ACCU-LL                  
MFA-TR*              ,BURDEN_ACCU_FL      = :XT-BURDEN-ACCU-FL                  
MFA-TR*              ,AMP_VOLT_ACCU_LL    = :XT-AMP-VOLT-ACCU-LL                
MFA-TR*              ,AMP_VOLT_ACCU_FL    = :XT-AMP-VOLT-ACCU-FL                
MFA-TR*        WHERE CODE_UTIL_TYPE   = :XT-CODE-UTIL-TYPE                      
MFA-TR*          AND COMPANY_NO       = :XT-COMPANY-NO                          
MFA-TR*          AND XFORMER_NO       = :XT-XFORMER-NO                          
MFA-TR*          AND DATE_TEST        = :XT-DATE-TEST                           
MFA-TR*          AND TIME_TEST        = :XT-TIME-TEST                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**  PCSMT618 PROCESSING ERROR      **'          
               DISPLAY '**  ABEND IN PARAGRAPH 8250       **'           
               DISPLAY '**      COMPANY-NO    = ' XT-COMPANY-NO         
               DISPLAY '**      XFORMER-NO    = ' XT-XFORMER-NO         
               DISPLAY '**      DATE-TEST     = ' XT-DATE-TEST          
               DISPLAY '**      TIME-TEST     = ' XT-TIME-TEST          
               DISPLAY '**            SQLCODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8300-INSERT-MOVEMENT-HIST.                                       
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_MOVEMENT_HIST                            
                      ( CODE_UTIL_TYPE                                  
                       ,DEVICE_NO                                       
                       ,DATE_MOVE                                       
                       ,MOVE_NO                                         
                       ,CODE_DEVICE_TYPE                                
                       ,COMPANY_NO                                      
                       ,LOCAL_OFFICE                                    
                       ,LOC_NO                                          
                       ,CODE_CRNT_LOC)                                  
               VALUES (:MV-CODE-UTIL-TYPE                               
                      ,:MV-DEVICE-NO                                    
                      ,IIF(TRY_CONVERT(DATE, :MV-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MV-DATE-MOVE
              ) <> 0) OR (LEN(:MV-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MV-DATE-MOVE
              ), CONVERT(DATE, :MV-DATE-MOVE) )                                
                      ,CIS.CURRENT$TIMESTAMP()                                
                      ,:MV-CODE-DEVICE-TYPE                             
                      ,:MV-COMPANY-NO                                   
                      ,:MV-LOCAL-OFFICE                                 
                      ,:MV-LOC-NO                                       
                      ,:MV-CODE-CRNT-LOC)                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MOVEMENT_HIST                                    
MFA-TR*               ( CODE_UTIL_TYPE                                          
MFA-TR*                ,DEVICE_NO                                               
MFA-TR*                ,DATE_MOVE                                               
MFA-TR*                ,MOVE_NO                                                 
MFA-TR*                ,CODE_DEVICE_TYPE                                        
MFA-TR*                ,COMPANY_NO                                              
MFA-TR*                ,LOCAL_OFFICE                                            
MFA-TR*                ,LOC_NO                                                  
MFA-TR*                ,CODE_CRNT_LOC)                                          
MFA-TR*        VALUES (:MV-CODE-UTIL-TYPE                                       
MFA-TR*               ,:MV-DEVICE-NO                                            
MFA-TR*               ,:MV-DATE-MOVE                                            
MFA-TR*               ,CURRENT TIMESTAMP                                        
MFA-TR*               ,:MV-CODE-DEVICE-TYPE                                     
MFA-TR*               ,:MV-COMPANY-NO                                           
MFA-TR*               ,:MV-LOCAL-OFFICE                                         
MFA-TR*               ,:MV-LOC-NO                                               
MFA-TR*               ,:MV-CODE-CRNT-LOC)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**  PCSMT618 PROCESSING ERROR      **'          
               DISPLAY '**  ABEND IN PARAGRAPH 8300       **'           
               DISPLAY '**      COMPANY-NO    = ' MV-COMPANY-NO         
               DISPLAY '**      XFORMER-NO    = ' MV-DEVICE-NO          
               DISPLAY '**            SQLCODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8350-UPDATE-CRNT-LOC.                                            
           EXEC SQL                                                     
               UPDATE CSS_EQUIPMENT                                     
                SET DATE_LAST_MOVE  = IIF(TRY_CONVERT(DATE, 
                                                     :EQ-DATE-LAST-MOVE
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-MOVE
              ) <> 0) OR (LEN(:EQ-DATE-LAST-MOVE
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-MOVE
              ), CONVERT(DATE, :EQ-DATE-LAST-MOVE) )                
                   ,CODE_CRNT_LOC   = :EQ-CODE-CRNT-LOC                 
                   ,CRNT_LOC_NO     = :EQ-CRNT-LOC-NO                   
                   ,DATE_LAST_TRAN  = CAST(SYSDATETIMEOFFSET() AS DATE)         
                   ,UPGRADES_TX     = :EQ-UPGRADES-TX                   
               WHERE CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                
                 AND COMPANY_NO     = :EQ-COMPANY-NO                    
                 AND DEVICE_NO      = :EQ-DEVICE-NO                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_EQUIPMENT                                             
MFA-TR*         SET DATE_LAST_MOVE  = :EQ-DATE-LAST-MOVE                        
MFA-TR*            ,CODE_CRNT_LOC   = :EQ-CODE-CRNT-LOC                         
MFA-TR*            ,CRNT_LOC_NO     = :EQ-CRNT-LOC-NO                           
MFA-TR*            ,DATE_LAST_TRAN  = CURRENT DATE                              
MFA-TR*            ,UPGRADES_TX     = :EQ-UPGRADES-TX                           
MFA-TR*        WHERE CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                        
MFA-TR*          AND COMPANY_NO     = :EQ-COMPANY-NO                            
MFA-TR*          AND DEVICE_NO      = :EQ-DEVICE-NO                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**  PCSMT618 PROCESSING ERROR      **'          
               DISPLAY '**  ABEND IN PARAGRAPH 8350       **'           
               DISPLAY '**      COMPANY-NO    = ' EQ-COMPANY-NO         
               DISPLAY '**      DEVICE-NO     = ' EQ-DEVICE-NO          
               DISPLAY '**            SQLCODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8900-PRODUCE-SUMMARY-REPORTS.                                    
      *                                                                         
           IF  (57 - WS-LINE-COUNT) < 5                                 
               ADD  1                          TO WS-PAGE-COUNT         
               MOVE WS-PAGE-COUNT              TO WS-TITLE3-PAGE-COUNT  
               WRITE PRT33-RECORD FROM WS-TITLE-1 AFTER NEW-PAGE        
               WRITE PRT33-RECORD FROM WS-TITLE-2 AFTER 1               
               WRITE PRT33-RECORD FROM WS-TITLE-3 AFTER 1               
               WRITE PRT33-RECORD FROM WS-TITLE-4 AFTER 1               
               WRITE PRT33-RECORD FROM WS-TITLE-5 AFTER 1               
               MOVE 5                          TO WS-LINE-COUNT         
           END-IF.                                                      
           IF NOT ERROR-FOUND                                           
              WRITE PRT33-RECORD FROM WS-NO-ERROR-LINE AFTER 2          
              ADD +2                       TO WS-LINE-COUNT             
           END-IF.                                                      
           MOVE WS-TOT-RECDS-INFO          TO WS-RPT-MESSAGE.           
           MOVE WS-NBR-XFMR-TEST-RECS      TO WS-RPT-STATISTICS.        
           WRITE PRT33-RECORD FROM WS-DET-LINE-2 AFTER 2                
           ADD +2                          TO WS-LINE-COUNT             
           MOVE WS-TOT-GOOD-RECDS          TO WS-RPT-MESSAGE.           
           MOVE WS-NBR-GOOD-RECS           TO WS-RPT-STATISTICS.        
           WRITE PRT33-RECORD FROM WS-DET-LINE-2 AFTER 1                
           ADD +1                          TO WS-LINE-COUNT             
           MOVE WS-TOT-BAD-RECDS           TO WS-RPT-MESSAGE.           
           MOVE WS-NBR-BAD-RECS            TO WS-RPT-STATISTICS.        
           WRITE PRT33-RECORD FROM WS-DET-LINE-2 AFTER 1                
           ADD +1                          TO WS-LINE-COUNT             
           WRITE PRT33-RECORD FROM WS-END-OF-DATA  AFTER 2.             
           ADD +2                          TO WS-LINE-COUNT.            
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9000-TERMINATE.                                                  
           CLOSE FCSMT618-FILE                                          
                 FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE                *          
      ****************************************************************          
           EXEC SQL                                                             
                INCLUDE CPD09900                                                
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
