       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSMT617.                                         
       DATE-WRITTEN.  07/29/04.                                         
       DATE-COMPILED.                                                   
      *****************************************************************         
      * COPYLIB:                                                                
      * CSSMT617                                                                
      * CFDMT617                                                                
      * FIOMT617                                                                
      *****************************************************************         
      **               SOUTH CAROLINA ELECTRIC & GAS                 **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **               PROGRAM MODIFICATION LOG                      **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **    ----    --------     -----------------                   **         
      **  07/29/04   VD88125     ORIGINAL VERSION                    **         
      *****************************************************************         
           REMARKS.                                                     
                              PCSMT617 NARRATIVE                        
            THIS PROGRAM PROCESSES A FILE WITH DATA FOR NEW INSTRUMENT  
            TRANSFORMER TO ADD TO METER INVENTORY.  THIS PROGRAM IS     
            IS RUN AS A REQUEST JOB BY THE ELECTRIC METER SHOP.         
                                                                        
            THE PROGRAM EDITS THE TRANSFORMER DATA AND LOADS DEFAULT    
            ATTRIBUTES FROM THE TRANSFORMER CLASS AND SPECIFICATION     
            USER TABLES.  ERRORS ARE PINTED ON A REPORT.                
                                                                        
            THERE ARE NO COMMITS PERFORMED AND NO RESTART LOGIC.        
                                                                        
            PROGRAM PCSMT618 IS USED TO ADD THE ASSOCIATED TEST RESULTS 
            FOR THE NEW INSTRUMENT TRANSFORMERS.                        
      *                                                                         
                   ---- BASIC BATCH SEQUENCE STRUCTURE ----             
                                                                        
                  0000 - 0000     MAIN CONTROL PATH                     
                  0100 - 0999     INITIALIZATION                        
                  1000 - 4999     MAJOR PROCESSING LOOP                 
                  5000 - 5999     COMMON PROGRAM MODULES                
                  7000 - 7999     SQL MODULES                           
                  8000 - 8999     OUTPUT MODULES                        
                  9000 - 9799     TERMINATION MODULES                   
                  9900 - 9999     ABEND/ABORT MODULES                   
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSMT617.                                                           
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDMT617.                                                           
       COPY FIOMT617.                                                           
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSMT617'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                        PIC X(40)  VALUE             
           'WORKING STORAGE FOR PCSMT617 STARTS HERE'.                  
      *                                                                         
       01  WS-MISC.                                                     
           05  PROGRAM-NAME                PIC X(08)  VALUE             
               'PCSMT617'.                                              
           05  WS-PGRMNAME                 PIC X(08)  VALUE             
               'PCSMT617'.                                              
           05  WS-NO-MORE-DATA             PIC X(01)  VALUE 'N'.        
      *                                                                         
HPCCDM*EJECT                                                                    
       COPY CWS00005.                                                           
       COPY CWS00303.                                                           
       COPY CWS00010.                                                           
       COPY CWS00018.                                                           
       COPY CWS00026.                                                           
       COPY CWS09900.                                                           
      *                                                                         
       COPY CCA00003.                                                           
      *                                                                         
       01  WS-WORK-AREA.                                                
           05  WS-DISPLAY-RC           PIC -ZZZZZZZZ9.9.                
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSMT617'.   
           05  WS-TIMESTAMP-AREA.                                       
               10  WS-DATE-TS          PIC X(10).                       
               10  WS-TIME-TS          PIC X(16)    VALUE               
                                                   '-12.00.00.000000'.  
      *                                                                         
           05  COUNTERS.                                                
               10  WS-NBR-XFORM-RECS   PIC S9(5)     COMP-3 VALUE 0.    
               10  WS-NBR-GOOD-RECS    PIC S9(5)     COMP-3 VALUE 0.    
               10  WS-NBR-BAD-RECS     PIC S9(5)     COMP-3 VALUE 0.    
      *                                                                         
           05  WS-ERROR-ARRAY-SIZE     PIC S9(04)   COMP VALUE ZEROES.  
           05  WS-LOCAL-OFFICE         PIC X(03).                       
           05  WS-DATE-DISPOSED-OF-NULL                                 
                                       PIC S9(04)   COMP VALUE ZEROES.  
               88  DATE-DISPOSED-OF-NULL            VALUE -1.           
           05  WS-INSTALL-DT-NULL      PIC S9(04)   COMP VALUE ZEROES.  
               88  INSTALL-DT-NULL                  VALUE -1.           
           05  WS-DATE-LAST-TESTED-NULL                                 
                                       PIC S9(04)   COMP VALUE ZEROES.  
               88  DATE-LAST-TESTED-NULL            VALUE -1.           
           05  WS-DATE-PURCHASED-NULL  PIC S9(04)   COMP VALUE ZEROES.  
               88  DATE-PURCHASED-NULL              VALUE -1.           
           05  WS-DATE-LAST-TEST-NULL  PIC S9(04)   COMP VALUE ZEROES.  
               88  DATE-LAST-TEST-NULL              VALUE -1.           
           05  WS-LAST-TEST-SEL-DT-NULL                                 
                                       PIC S9(04)   COMP VALUE ZEROES.  
               88  LAST-TEST-SEL-DT-NULL            VALUE -1.           
           05  WS-DATE-LAST-MOVE-NULL  PIC S9(04)   COMP VALUE ZEROES.  
               88  DATE-LAST-MOVE-NULL              VALUE -1.           
           05  WS-DATE-LAST-TRAN-NULL  PIC S9(04)   COMP VALUE ZEROES.  
               88  DATE-LAST-TRAN-NULL              VALUE -1.           
           05  WS-DATE-OBSOLETE-NULL   PIC S9(04)   COMP VALUE ZEROES.  
               88  DATE-OBSOLETE-NULL               VALUE -1.           
           05  WS-WARRANTY-EXP-DT-NULL PIC S9(04)   COMP VALUE ZEROES.  
               88  WARRANTY-EXP-DT-NULL             VALUE -1.           
           05  WS-MFR-DT-NULL          PIC S9(04)   COMP VALUE ZEROES.  
               88 MFR-DT-NULL                       VALUE -1.           
      *                                                                         
           05  INDEXES.                                                 
               10  WS-ERR-ARRAY-IDX    PIC S9(04)   COMP VALUE ZEROES.  
      *                                                                         
           05  FLAGS.                                                   
               10  WS-EOF-FLAG         PIC X(01)    VALUE 'N'.          
                   88  END-OF-FILE                  VALUE 'Y'.          
               10  WS-RECORD-FLAG      PIC X(01)    VALUE 'N'.          
                   88  GOOD-RECORD                  VALUE 'N'.          
               10  WS-XFORMER-FLAG     PIC X(01)    VALUE 'N'.          
                   88  MORE-DATA                    VALUE 'N'.          
                   88  NO-MORE-DATA                 VALUE 'Y'.          
               10  WS-READ-FLAG        PIC X(01)    VALUE 'Y'.          
                   88  FIRST-READ                   VALUE 'Y'.          
               10  NO-ERROR-FOUND      PIC X(01)    VALUE 'Y'.          
                   88  ERROR-FOUND                  VALUE 'N'.          
      *                                                                         
           05  WS-TEMP-CC              PIC 99.                          
           05  WS-TEMP1-CC             PIC 99.                          
           05  WS-WARRANTY-YEAR        PIC 99.                          
           05  WS-CODE-MAKE            PIC X(02)    VALUE SPACE.        
           05  WS-SAVE-XFORM-NO        PIC X(09).                       
           05  WS-SAVE-SERIAL-NO       PIC X(08).                       
           05  WS-SAVE-VENDOR-ID       PIC X(02).                       
           05  WS-SYS-DATE.                                             
               10  WS-SYS-DATE-YY      PIC 9(02).                       
               10  WS-SYS-DATE-MM      PIC 9(02).                       
               10  WS-SYS-DATE-DD      PIC 9(02).                       
           05  WS-DB2-TODAYS-DATE      PIC X(10).                       
           05  WS-CRNT-DATE-BREAKDOWN.                                  
               10  WS-CRNT-MM          PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-CRNT-DD          PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-CRNT-YY          PIC 9(02).                       
           05  WS-DB2-DATE.                                             
               10  WS-DB2-CC           PIC X(2).                        
               10  WS-DB2-YY           PIC X(2).                        
               10  FILLER              PIC X.                           
               10  WS-DB2-MM           PIC X(2).                        
               10  FILLER              PIC X.                           
               10  WS-DB2-DD           PIC X(2).                        
           05  WS-MFR-DT               PIC X(10).                       
           05  WS-EXP-DT REDEFINES WS-MFR-DT.                           
               10  WS-EXP-DATE-CC      PIC 9(02).                       
               10  WS-EXP-DATE-YY      PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-EXP-DATE-MM      PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-EXP-DATE-DD      PIC 9(02).                       
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-ONE                  PIC 9(01)    VALUE 1.            
           05  WS-TWO                  PIC 9(01)    VALUE 2.            
           05  WS-CMP-NO               PIC X(02)    VALUE '01'.         
           05  WS-E                    PIC X(01)    VALUE 'E'.          
           05  WS-G                    PIC X(01)    VALUE 'G'.          
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-T                    PIC X(01)    VALUE 'T'.          
           05  WS-X                    PIC X(01)    VALUE 'X'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-YES                  PIC X(03)    VALUE 'YES'.        
           05  WS-NO                   PIC X(03)    VALUE 'NO '.        
           05  WS-FOUND                PIC X(01)    VALUE 'N'.          
           05  WS-01                   PIC X(02)    VALUE '01'.         
      *                                                                         
       01  WS-TEMP-ERR-HOLD-AREA.                                       
           05  TEMP-ERROR  PIC X(85) OCCURS 100 TIMES.                  
      *                                                                         
       01  ERROR-HOLD-AREA.                                             
           05  ERROR-ARRAY OCCURS 100 TIMES.                            
               10  ERR-VENDOR          PIC X(02).                       
               10  ERR-XFORM-TYPE      PIC X(02).                       
               10  ERR-XFORM-NBR       PIC X(09).                       
               10  ERR-SERIAL-NBR      PIC X(11).                       
               10  ERR-FIELD           PIC X(25).                       
               10  ERR-PROBLEM         PIC X(46).                       
      *                                                                         
       01  WS-HDR-ONE.                                                  
           05 FILLER                   PIC X(08)  VALUE                 
              'PCSMT617'.                                               
           05 FILLER                   PIC X(39)  VALUE SPACES.         
           05 WS-COMPANY-NAME          PIC X(39)  VALUE                 
              'SOUTH CAROLINA ELECTRIC & GAS'.                          
           05 FILLER                   PIC X(30)  VALUE SPACES.         
           05 FILLER                   PIC X(06)  VALUE                 
              'PAGE: '.                                                 
           05 FILLER                   PIC X(06)  VALUE SPACES.         
           05 WS-DET-PAGE              PIC ZZZZ   VALUE SPACES.         
      *                                                                         
       01  WS-HDR-TWO.                                                  
           05 FILLER                   PIC X(45)  VALUE SPACES.         
           05 FILLER                   PIC X(35)  VALUE                 
              'TRANSFORMERS ADDITION ERROR REPORT'.                     
           05 FILLER                   PIC X(36)  VALUE SPACES.         
           05 FILLER                   PIC X(06)  VALUE                 
              'DATE: '.                                                 
           05 WS-RUN-DATE.                                              
              10 WS-RUN-DATE-MM        PIC X(02) VALUE SPACES.          
              10 FILLER                PIC X(01) VALUE '/'.             
              10 WS-RUN-DATE-DD        PIC X(02) VALUE SPACES.          
              10 FILLER                PIC X(01) VALUE '/'.             
              10 WS-RUN-DATE-CC        PIC X(02) VALUE SPACES.          
              10 WS-RUN-DATE-YY        PIC X(02) VALUE SPACES.          
      *                                                                         
       01  WS-HDR-THREE.                                                
           05 FILLER                   PIC X(05)  VALUE SPACES.         
           05 FILLER                   PIC X(09)  VALUE                 
              'VENDOR ID'.                                              
           05 FILLER                   PIC X(05)  VALUE SPACES.         
           05 FILLER                   PIC X(10)  VALUE                 
              'XFORM TYPE'.                                             
           05 FILLER                   PIC X(05)  VALUE SPACES.         
           05 FILLER                   PIC X(08)  VALUE                 
              'XFORM NO'.                                               
           05 FILLER                   PIC X(05)  VALUE SPACES.         
           05 FILLER                   PIC X(09)  VALUE                 
              'SERIAL NO'.                                              
           05 FILLER                   PIC X(05)  VALUE SPACES.         
           05 FILLER                   PIC X(11)  VALUE                 
              'ERROR FIELD'.                                            
           05 FILLER                   PIC X(20)  VALUE SPACES.         
           05 FILLER                   PIC X(12)  VALUE                 
              'PROBLEM DESC'.                                           
      *                                                                         
       01  WS-FOOT-LINE.                                                
           05 FILLER                           PIC X(55)  VALUE SPACES. 
           05 FILLER                           PIC X(22)  VALUE         
              '*** END OF  REPORT ***'.                                 
           05 FILLER                           PIC X(55)  VALUE SPACES. 
      *                                                                         
       01  WS-NO-ERROR-LINE.                                            
           05 FILLER                           PIC X(55)  VALUE SPACES. 
           05 FILLER                           PIC X(23)  VALUE         
              '*** NO ERRORS FOUND ***'.                                
           05 FILLER                           PIC X(54)  VALUE SPACES. 
      *                                                                         
HPCCDM*SKIP1                                                                    
      *                                                                         
       01 WS-DET-LINE-1.                                                
          05  FILLER                   PIC X(08)  VALUE SPACES.         
          05  WS-RPT-VENDOR-ID         PIC X(02).                       
          05  FILLER                   PIC X(12)  VALUE SPACES.         
          05  WS-RPT-XFORM-TYPE        PIC X(02).                       
          05  FILLER                   PIC X(10)  VALUE SPACES.         
          05  WS-RPT-XFORM-NO          PIC X(09).                       
          05  FILLER                   PIC X(04)  VALUE SPACES.         
          05  WS-RPT-SERIAL-NO         PIC X(11).                       
          05  FILLER                   PIC X(03)  VALUE SPACES.         
          05  WS-RPT-ERROR-FIELD       PIC X(25).                       
          05  FILLER                   PIC X(06)  VALUE SPACES.         
          05  WS-RPT-PROBLEM-DESC      PIC X(46).                       
HPCCDM*SKIP1                                                                    
      *                                                                         
       01 WS-DET-LINE-2.                                                
          05  FILLER                   PIC X(05)  VALUE SPACES.         
          05  WS-RPT-MESSAGE           PIC X(20)  VALUE SPACES.         
          05  FILLER                   PIC X(03)                        
              VALUE ':  '.                                              
          05  WS-RPT-STATISTICS        PIC ZZZZ9  VALUE SPACES.         
      *                                                                         
       01  WS-ERROR-RPT-MSGS.                                           
           05 WS-TOT-RECDS-INFO        PIC X(18)    VALUE               
              ' TOTAL I/P RECORDS'.                                     
           05 WS-TOT-GOOD-RECDS        PIC X(13)    VALUE               
              ' GOOD RECORDS'.                                          
           05 WS-TOT-BAD-RECDS         PIC X(12)    VALUE               
              ' BAD RECORDS'.                                           
      *                                                                         
       01  WS-VARIABLES.                                                
           05 WS-LINE-CNTR                     PIC 9(02)  VALUE 57.     
           05 WS-BLANK-LINE                    PIC X(132) VALUE SPACES. 
           05 WS-PAGE                          PIC 9(04)  VALUE ZEROS.  
           05 WS-LINE-SPACE                    PIC 9(01)  VALUE ZERO.   
      *                                                                         
       01  WS-ERR-803.                                                  
           05  WS-ERR-FIELD-803.                                        
               10  FILLER           PIC X(25) VALUE                     
               'CAN''T ADD FROM VNDR FILE'.                             
           05  WS-ERR-MSG-803.                                          
               10  FILLER           PIC X(38) VALUE                     
               'XFORMER EXISTS ON CSS_EQUIPMENT TABLE'.                 
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-FMT617-STATUS           PIC X(02).                    
               88  FMT617-SUCCESSFUL                 VALUE '00'.        
               88  FMT617-READ-EOF                   VALUE '10'.        
      *                                                                         
      ***  INCLUDE DCLGEN TABLE AND HOST VARIABLE DEFINITIONS                   
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBINXFOR                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBXSSPEC                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBXFRMCL                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBTBLENT                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMODEL                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     04290019
               INCLUDE TBMTRFAC                                         04300019
           END-EXEC.                                                    04310019
      *                                                                 04320019
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
       01  WS-END                      PIC X(40)    VALUE               
             'WORKING STORAGE FOR PCSMT617 ENDS HERE  '.                
      *                                                                         
       PROCEDURE DIVISION.                                              
           EXIT.                                                        
      ****************************************************************          
      **                                                            **          
      **  0000-MAINLINE                                             **          
      **      CONTROLS MAIN PATH OF PROGRAM                         **          
      **                                                            **          
      ****************************************************************          
       0000-MAINLINE.                                                   
           DISPLAY 'AT BEGINNING OF PROGRAM'.                           
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
      *                                                                         
           PERFORM 1000-PROCESS-FILE             THRU 1000-EXIT         
               UNTIL END-OF-FILE.                                       
           PERFORM 8900-PRODUCE-SUMMARY-REPORTS  THRU 8900-EXIT.        
      *                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0100-INITIALIZATION                                       **          
      **      OPEN FILES, DO FIRST READ OF METER FILE, ACCEPT DATE  **          
      **                                                            **          
      ****************************************************************          
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN INPUT FCSMT617-FILE.                                    
                                                                        
           IF  FMT617-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY ' **ERROR ON OPEN FILE FIOMT617     **'          
               DISPLAY ' FILE STATUS = ' WS-FMT617-STATUS               
               DISPLAY '** PROCESSING TERMINATED           **'          
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           ACCEPT WS-SYS-DATE FROM DATE.                                
                                                                        
           IF WS-SYS-DATE-YY GREATER THAN 50                            
               MOVE 19                 TO WS-TEMP-CC                    
           ELSE                                                         
               MOVE 20                 TO WS-TEMP-CC                    
           END-IF.                                                      
      *                                                                         
           STRING WS-TEMP-CC,                                           
                  WS-SYS-DATE-YY,                                       
                  '-',                                                  
                  WS-SYS-DATE-MM,                                       
                  '-',                                                  
                  WS-SYS-DATE-DD                                        
                               DELIMITED BY SIZE                        
                                     INTO WS-DB2-TODAYS-DATE            
           END-STRING.                                                  
           MOVE WS-SYS-DATE-MM            TO WS-RUN-DATE-MM.            
           MOVE WS-SYS-DATE-DD            TO WS-RUN-DATE-DD             
           MOVE WS-TEMP-CC                TO WS-RUN-DATE-CC.            
           MOVE WS-SYS-DATE-YY            TO WS-RUN-DATE-YY.            
      *                                                                         
           STRING WS-TEMP-CC,                                           
                  WS-SYS-DATE-YY,                                       
                  WS-SYS-DATE-MM,                                       
                  WS-SYS-DATE-DD                                        
                               DELIMITED BY SIZE                        
                                     INTO WS-CURRENT-FULL-DATE          
           END-STRING.                                                  
      *                                                                         
           INITIALIZE ERROR-HOLD-AREA.                                  
           MOVE ERROR-HOLD-AREA           TO WS-TEMP-ERR-HOLD-AREA.     
      *                                                                         
           PERFORM 7000-INITIALIZE               THRU 7000-EXIT.        
                                                                        
           PERFORM 7400-READ-XFORM-FILE          THRU 7400-EXIT.        
           IF  END-OF-FILE                                              
               MOVE WS-01                  TO C7-COMPANY-NO             
           ELSE                                                         
               MOVE E-FMT617-COMPANY-NO    TO C7-COMPANY-NO             
           END-IF.                                                      
                                                                        
           PERFORM 7500-SELECT-COMP-NAME   THRU 7500-EXIT.              
           MOVE C7-COMPANY-NAME            TO WS-COMPANY-NAME.          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1000-PROCESS-FILE                                         **          
      **      RECEIVE, EDIT, AND PROCESS INPUT                      **          
      **                                                            **          
      ****************************************************************          
       1000-PROCESS-FILE.                                               
      *                                                                         
           PERFORM 2000-EDIT-RECORD              THRU 2000-EXIT.        
      *                                                                         
           IF GOOD-RECORD                                               
               PERFORM 5000-UPDATE-PROCESS       THRU 5000-EXIT         
               ADD 1                   TO WS-NBR-GOOD-RECS              
           END-IF.                                                      
           IF WS-RECORD-FLAG EQUAL 'Y'                                  
               MOVE WS-ERR-ARRAY-IDX   TO WS-ERROR-ARRAY-SIZE           
               PERFORM 6000-ERROR-ROUTINE        THRU 6000-EXIT         
                   VARYING WS-ERR-ARRAY-IDX FROM 1 BY 1                 
                       UNTIL WS-ERR-ARRAY-IDX > WS-ERROR-ARRAY-SIZE     
               ADD 1                   TO WS-NBR-BAD-RECS               
           END-IF.                                                      
      *                                                                         
           PERFORM 7000-INITIALIZE               THRU 7000-EXIT.        
           PERFORM 7400-READ-XFORM-FILE          THRU 7400-EXIT.        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  2000-EDIT-RECORD                                          **          
      **      EDIT CHECK RECORD FIELDS. IF INVALID, WRITE TO ERROR  **          
      **                                                            **          
      ****************************************************************          
       2000-EDIT-RECORD.                                                
      *                                                                         
              MOVE E-FMT617-XFORMER-SPEC-CD    TO XS-XFORMER-SPEC-CD    
              PERFORM 7510-SELECT-XFORMER-SPEC     THRU 7510-EXIT       
              MOVE XS-CODE-MAKE                TO WS-SAVE-VENDOR-ID     
      *                                                                         
              MOVE E-FMT617-XFORMER-CLASS-CD   TO XC-XFORMER-CLASS-CD   
              PERFORM 7520-SELECT-XFORMER-CLASS    THRU 7520-EXIT       
      *                                                                         
           IF E-FMT617-XFORMER-NO NOT NUMERIC                           
               PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
               MOVE 'E-FMT617-XFORMER-NO'                               
                                       TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
               MOVE 'NOT NUMERIC'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
           IF E-FMT617-SERIAL-NO EQUAL SPACES OR LOW-VALUES             
               PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
               MOVE 'E-FMT617-SERIAL-NO'                                
                                       TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
               MOVE 'NOT PRESENT'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
           IF  NOT E-FMT617-XFORMER-TYPE-CT AND                         
               NOT E-FMT617-XFORMER-TYPE-PT                             
               PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
               MOVE 'E-FMT617-XFORMER-TYPE-CD'                          
                                       TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
               MOVE 'NOT CT/PT'        TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
           PERFORM 2200-EDIT-DATES               THRU 2200-EXIT.        
      *                                                                         
           IF E-FMT617-MTR-STORAGE-FACILITY NOT EQUAL WS-LOCAL-OFFICE   
              STRING E-FMT617-MTR-STORAGE-FACILITY , ' '                
                 DELIMITED BY SIZE                                      
                 INTO WS-LOCAL-OFFICE                                   
              PERFORM 7530-SELECT-MTR-STORGE-FAC  THRU 7530-EXIT        
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  2200-EDIT-DATES                                           **          
      **                                                            **          
      ****************************************************************          
       2200-EDIT-DATES.                                                 
      *                                                                         
           MOVE WS-LE                  TO WS-PARM-OPERATOR.             
      *                                                                         
           MOVE E-FMT617-MFR-DT (3:2)  TO WS-IN-YY.                     
           MOVE E-FMT617-MFR-DT (6:2)  TO WS-IN-MM.                     
           MOVE E-FMT617-MFR-DT (9:2)  TO WS-IN-DD.                     
                                                                        
           PERFORM 6100-DATE-VALIDATION          THRU 6100-EXIT.        
      *                                                                         
           IF (INVALID-MONTH OR INVALID-DAY OR INVALID-YEAR)            
               PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
               MOVE 'E-FMT617-MFR-DT'  TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
               MOVE 'INVALID DATE'     TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  2500-LOAD-ERROR-ARRAY                                     **          
      **                                                            **          
      ****************************************************************          
       2500-LOAD-ERROR-ARRAY.                                           
      *                                                                         
           MOVE 'Y'                    TO WS-RECORD-FLAG.               
           ADD 1                       TO WS-ERR-ARRAY-IDX.             
           MOVE WS-SAVE-VENDOR-ID      TO ERR-VENDOR (WS-ERR-ARRAY-IDX).
           MOVE E-FMT617-XFORMER-TYPE-CD                                
                                  TO ERR-XFORM-TYPE (WS-ERR-ARRAY-IDX). 
           MOVE E-FMT617-XFORMER-NO    TO ERR-XFORM-NBR                 
                                                     (WS-ERR-ARRAY-IDX).
           MOVE E-FMT617-SERIAL-NO     TO ERR-SERIAL-NBR                
                                                     (WS-ERR-ARRAY-IDX).
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  5000-UPDATE-PROCESS                                       **          
      **      SETUP AND INSERT CSS_EQUIPMENT, CSS_INST_XFORMER      **          
      ****************************************************************          
       5000-UPDATE-PROCESS.                                             
      *                                                                         
      ***  SETUP EQUIPMENT TABLE AND INSERT                                     
      *                                                                         
           MOVE E-FMT617-XFORMER-NO    TO EQ-DEVICE-NO,                 
                                          IX-XFORMER-NO.                
      *                                                                         
           MOVE WS-X                   TO EQ-CODE-UTIL-TYPE.            
           MOVE WS-T                   TO EQ-EQUIP-TYPE-CD.             
           MOVE XS-CODE-MAKE           TO EQ-CODE-MAKE.                 
           MOVE SPACE                  TO EQ-PALETTE-NO.                
           MOVE E-FMT617-SERIAL-NO     TO EQ-SERIAL-NO.                 
           MOVE E-FMT617-MFR-DT        TO EQ-DATE-PURCHASED             
                                          WS-MFR-DT.                    
      *                                                                         
           MOVE SPACE                  TO EQ-DATE-DISPOSED-OF.          
           SET DATE-DISPOSED-OF-NULL   TO TRUE.                         
           COMPUTE WS-EXP-DATE-YY = WS-EXP-DATE-YY + 1.                 
           MOVE WS-EXP-DT              TO EQ-WARRANTY-EXP-DT.           
      *                                                                 07860018
           MOVE SPACE                  TO EQ-INSTALL-EMP-ID.            
           MOVE SPACE                  TO EQ-INSTALL-DT.                
           SET INSTALL-DT-NULL         TO TRUE.                         
           MOVE 'A'                    TO EQ-CODE-CRNT-LOC.             
           MOVE ZERO                   TO EQ-CRNT-LOC-NO.               
           MOVE WS-DB2-TODAYS-DATE     TO EQ-DATE-LAST-TRAN,            
                                          EQ-DATE-LAST-MOVE.            
           MOVE WS-LOCAL-OFFICE        TO EQ-LOCAL-OFFICE.              
           MOVE E-FMT617-MFR-DT        TO EQ-MFR-DT.                    
           MOVE SPACE                  TO EQ-DATE-OBSOLETE.             
           SET DATE-OBSOLETE-NULL      TO TRUE.                         
           MOVE E-FMT617-COMMENTS      TO EQ-UPGRADES-TX.               
           MOVE E-FMT617-HAZARD-MATERIAL-CD                             
                                       TO EQ-HAZARD-MATERIAL-CD.        
           MOVE E-FMT617-COMPANY-NO    TO EQ-COMPANY-NO.                
      *                                                                         
           PERFORM 8500-INSERT-EQUIP             THRU 8500-EXIT.        
      *    XFORMER ALREADY EXISTS ON EQUIP TABLE, SEND TO ERROR REPORT          
           IF  SQLCODE EQUAL -803                                       
               PERFORM 2500-LOAD-ERROR-ARRAY THRU 2500-EXIT             
               MOVE WS-ERR-FIELD-803                                    
                                      TO ERR-FIELD (WS-ERR-ARRAY-IDX)   
               MOVE WS-ERR-MSG-803                                      
                                      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX) 
               COMPUTE WS-NBR-GOOD-RECS = WS-NBR-GOOD-RECS - 1          
               GO TO 5000-EXIT                                          
           END-IF.                                                      
      *                                                                         
      ***  SETUP CSS_INSTR_XFORMER AND INSERT                                   
      *                                                                         
           MOVE WS-X                   TO IX-CODE-UTIL-TYPE.            
           MOVE WS-T                   TO IX-DEVICE-TYPE-CD.            
      *                                                                         
           MOVE XS-RTO-UPPER-FRACTION  TO IX-RTO-UPPER-FRACTION.        
           MOVE XS-RTO-LOWER-FRACTION  TO IX-RTO-LOWER-FRACTION.        
           MOVE XS-XFORMER-SIZE-ID     TO IX-XFORMER-SIZE-ID.           
      *                                                                         
           MOVE XC-CONNECTION-TYPE     TO IX-CONNECTION-TYPE.           
           MOVE XC-RATE-FACTOR         TO IX-RATE-FACTOR.               
           MOVE XC-BIL-RATING          TO IX-BIL-RATING-CD.             
           MOVE XC-BURDEN-CAPACITY     TO IX-BURDEN-QT.                 
           MOVE XC-VOLTAGE-CLASS       TO IX-VOLTAGE-CLASS.             
      *                                                                         
           MOVE E-FMT617-XFORMER-TYPE-CD                                
                                       TO IX-XFORMER-TYPE-CD.           
           MOVE E-FMT617-COMPANY-NO    TO IX-COMPANY-NO.                
           MOVE E-FMT617-XFORMER-SPEC-CD                                
                                       TO IX-XFORMER-SPEC-CD.           
           MOVE E-FMT617-XFORMER-CLASS-CD                               
                                       TO IX-XFORMER-CLASS-CD.          
      *                                                                         
           MOVE ZERO                   TO IX-DIELECTRIC-GAL             
                                          IX-PPM-PCB.                   
           MOVE SPACES                 TO IX-PCB-LAB-TST-REF-NO.        
                                                                        
           PERFORM 8600-INSERT-INSTR-XFORMER     THRU 8600-EXIT.        
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  6000-ERROR-ROUTINE                                        **          
      **                                                            **          
      ****************************************************************          
       6000-ERROR-ROUTINE.                                              
      *                                                                         
           MOVE ERR-VENDOR    (WS-ERR-ARRAY-IDX)                        
                                       TO WS-RPT-VENDOR-ID.             
           MOVE ERR-XFORM-TYPE (WS-ERR-ARRAY-IDX)                       
                                       TO WS-RPT-XFORM-TYPE.            
           MOVE ERR-XFORM-NBR (WS-ERR-ARRAY-IDX)                        
                                       TO WS-RPT-XFORM-NO.              
           MOVE ERR-FIELD     (WS-ERR-ARRAY-IDX)                        
                                       TO WS-RPT-ERROR-FIELD.           
           MOVE ERR-PROBLEM   (WS-ERR-ARRAY-IDX)                        
                                       TO WS-RPT-PROBLEM-DESC.          
           MOVE ERR-SERIAL-NBR (WS-ERR-ARRAY-IDX)                       
                                       TO WS-RPT-SERIAL-NO.             
      *                                                                         
           PERFORM 8105-WRITE-PRINTER-RECORD     THRU 8105-EXIT.        
      *                                                                         
       6000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  6100-DATE-VALIDATION                                      **          
      **                                                            **          
      ****************************************************************          
       6100-DATE-VALIDATION.                                            
      *                                                                         
           MOVE ZEROES                 TO WS-RETURN-DATE,               
                                          WS-WORK-FIELDS,               
                                          WS-DATE-FLAGS.                
           PERFORM 6110-NUMERIC-CHECK            THRU 6110-EXIT.        
      *                                                                         
           IF WS-DATE-FLAGS EQUAL ZEROS                                 
               MOVE WS-IN-DD           TO WS-RETURN-DD                  
               MOVE WS-IN-YY           TO WS-RETURN-YY                  
               MOVE WS-IN-MM           TO WS-RETURN-MM                  
               IF WS-RETURN-YY GREATER THAN 50                          
                   MOVE 19             TO WS-RETURN-CC                  
               ELSE                                                     
                   MOVE 20             TO WS-RETURN-CC                  
               END-IF                                                   
               IF WS-CURRENT-CMPR-YY IS NUMERIC                         
                   IF WS-CURRENT-CMPR-YY GREATER THAN 50                
                       MOVE 19         TO WS-CURRENT-CMPR-CC            
                   ELSE                                                 
                       MOVE 20         TO WS-CURRENT-CMPR-CC            
                   END-IF                                               
               END-IF                                                   
               PERFORM 6120-BOUNDARY-CHECK       THRU 6120-EXIT         
               IF NOT (INVALID-DAY AND INVALID-MONTH)                   
                   IF WS-PARM-OPERATOR NOT EQUAL SPACES AND 'NA'        
                       PERFORM 6140-COMPARE-FULL-DATES                  
                                                 THRU 6140-EXIT         
                       IF WS-DATE-OPERATOR-FLAG EQUAL WS-PARM-OPERATOR  
                           NEXT SENTENCE                                
                       ELSE                                             
                           IF WS-DATE-OPERATOR-FLAG EQUAL WS-EQ         
                               IF WS-PARM-OPERATOR EQUAL WS-LE          
                                             OR WS-GE OR WS-EQ          
                                   NEXT SENTENCE                        
                               ELSE                                     
                                   MOVE 1                               
                                       TO MONTH-FLAG,                   
                                          DAY-FLAG,                     
                                          YEAR-FLAG                     
                               END-IF                                   
                           ELSE                                         
                               IF WS-DATE-OPERATOR-FLAG EQUAL WS-GT     
                                   IF WS-PARM-OPERATOR EQUAL WS-GE      
                                                          OR WS-GT      
                                       NEXT SENTENCE                    
                                   ELSE                                 
                                       MOVE 1                           
                                       TO MONTH-FLAG,                   
                                          DAY-FLAG,                     
                                          YEAR-FLAG                     
                                   END-IF                               
                               ELSE                                     
                                   IF WS-DATE-OPERATOR-FLAG EQUAL WS-LT 
                                       IF WS-PARM-OPERATOR EQUAL WS-LE  
                                                              OR WS-LT  
                                           NEXT SENTENCE                
                                       ELSE                             
                                           MOVE 1  TO MONTH-FLAG,       
                                                      DAY-FLAG,         
                                                      YEAR-FLAG         
                                       END-IF                           
                                   END-IF                               
                               END-IF                                   
                           END-IF                                       
                       END-IF                                           
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       6100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  6110-NUMERIC-CHECK                                        **          
      **      VALIDATE DATE INFORMATION                             **          
      **                                                            **          
      ****************************************************************          
       6110-NUMERIC-CHECK.                                              
      *                                                                         
           IF WS-IN-MM NUMERIC                                          
               CONTINUE                                                 
           ELSE                                                         
               MOVE 1                  TO MONTH-FLAG                    
           END-IF.                                                      
      *                                                                         
           IF WS-IN-DD NUMERIC                                          
               CONTINUE                                                 
           ELSE                                                         
               MOVE 1                  TO DAY-FLAG                      
           END-IF.                                                      
      *                                                                         
           IF WS-IN-YY NUMERIC                                          
               CONTINUE                                                 
           ELSE                                                         
               MOVE 1                  TO YEAR-FLAG                     
           END-IF.                                                      
      *                                                                         
       6110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  6120-BOUNDARY-CHECK                                       **          
      **                                                            **          
      ****************************************************************          
       6120-BOUNDARY-CHECK.                                             
      *                                                                         
           IF WS-RETURN-MM > 12 OR                                      
              WS-RETURN-MM < 01                                         
               MOVE 1                  TO MONTH-FLAG                    
           END-IF.                                                      
      *                                                                         
           IF THIRTY-ONE-DAY                                            
               MOVE 31                 TO WS-UPPER-LIMIT                
           ELSE                                                         
               IF THIRTY-DAY                                            
                   MOVE 30             TO WS-UPPER-LIMIT                
               ELSE                                                     
                   DIVIDE WS-RETURN-YY BY 4 GIVING WS-RESULT            
                          REMAINDER WS-REMAINDER-DATE                   
                   IF WS-REMAINDER-DATE EQUAL ZEROES                    
                       MOVE 29         TO WS-UPPER-LIMIT                
                   ELSE                                                 
                       MOVE 28         TO WS-UPPER-LIMIT                
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           IF WS-RETURN-DD > WS-UPPER-LIMIT OR                          
              WS-RETURN-DD < 1                                          
               MOVE 1                  TO DAY-FLAG                      
           END-IF.                                                      
      *                                                                         
       6120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  6140-COMPARE-FULL-DATES                                   **          
      **                                                            **          
      ****************************************************************          
       6140-COMPARE-FULL-DATES.                                         
      *                                                                         
           IF WS-RETURN-DATE > WS-CURRENT-FULL-DATE                     
               MOVE 'GT'               TO WS-DATE-OPERATOR-FLAG         
           ELSE                                                         
               IF WS-RETURN-DATE < WS-CURRENT-FULL-DATE                 
                   MOVE 'LT'           TO WS-DATE-OPERATOR-FLAG         
               ELSE                                                     
                   MOVE 'EQ'           TO WS-DATE-OPERATOR-FLAG         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           IF WS-RETURN-YY > 50                                         
               MOVE 19                 TO WS-CENTURY-INDICATOR          
           ELSE                                                         
               MOVE 20                 TO WS-CENTURY-INDICATOR          
           END-IF.                                                      
      *                                                                         
       6140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7000-INITIALIZE                                           **          
      **                                                            **          
      ****************************************************************          
       7000-INITIALIZE.                                                 
      *                                                                         
           MOVE WS-N                   TO WS-RECORD-FLAG.               
           COMPUTE WS-ERR-ARRAY-IDX  = 0.                               
           MOVE WS-TEMP-ERR-HOLD-AREA  TO ERROR-HOLD-AREA.              
           INITIALIZE DCLCSS-EQUIPMENT,                                 
                      DCLCSS-INSTR-XFORMER.                             
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **                                                            **          
      **  7400-READ-XFORM-FILE, FCSMT617-FILE                       **  15060023
      **                                                            **          
      ****************************************************************          
       7400-READ-XFORM-FILE.                                            
      *                                                                         
           READ FCSMT617-FILE                                           
               AT END MOVE 'Y'         TO WS-EOF-FLAG.                  
      *                                                                         
           IF FIRST-READ                                                
               MOVE 'N'                TO WS-READ-FLAG                  
           END-IF.                                                      
      *                                                                         
           IF NOT END-OF-FILE                                           
               ADD 1                   TO WS-NBR-XFORM-RECS             
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7500-SELECT-COMP-NAME                                     **          
      **                                                            **          
      ****************************************************************          
       7500-SELECT-COMP-NAME.                                           
      *                                                                         
           MOVE '7500'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
               SELECT COMPANY_NAME                                      
               INTO   :C7-COMPANY-NAME                                  
               FROM   CSS_COMPANY                                       
               WHERE COMPANY_NO = :C7-COMPANY-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT617***************'         
               DISPLAY '* ERROR ON 7500-SELECT-COMP-NAME     *'         
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...                *'         
               DISPLAY '***************PCSMT617***************'         
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **                                                            **          
      **  7510-SELECT-XFORMER-SPEC                                  **          
      **                                                            **          
      ****************************************************************          
       7510-SELECT-XFORMER-SPEC.                                        
      *                                                                         
           MOVE '7510'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               SELECT XFORMER_SPEC_CD                                   
                     ,CODE_MAKE                                         
                     ,XFORMER_SIZE_ID                                   
                     ,RTO_UPPER_FRACTION                                
                     ,RTO_LOWER_FRACTION                                
                     ,XFORMER_SPEC_DESC                                 
                     ,PCB_FREE_CODE                                     
                     ,DIELECTRIC_CODE                                   
               INTO  :XS-XFORMER-SPEC-CD                                
                    ,:XS-CODE-MAKE                                      
                    ,:XS-XFORMER-SIZE-ID                                
                    ,:XS-RTO-UPPER-FRACTION                             
                    ,:XS-RTO-LOWER-FRACTION                             
                    ,:XS-XFORMER-SPEC-DESC                              
                    ,:XS-PCB-FREE-CODE                                  
                    ,:XS-DIELECTRIC-CODE                                
               FROM   CSS_XFORMER_SPEC                                  
               WHERE  XFORMER_SPEC_CD = :XS-XFORMER-SPEC-CD             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   PERFORM 2500-LOAD-ERROR-ARRAY THRU 2500-EXIT         
                   MOVE 'E-FMT617-XFORMER-SPEC-CD'                      
                                       TO ERR-FIELD (WS-ERR-ARRAY-IDX)  
                   STRING XS-XFORMER-SPEC-CD,                           
                          ' NOT FOUND IN TABLE'                         
                          DELIMITED BY SIZE                             
                                     INTO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
                   END-STRING                                           
               ELSE                                                     
                   MOVE SQLCODE        TO WS-DISPLAY-RC                 
                   DISPLAY '***************PCSMT617***************'     
                   DISPLAY '* ERROR ON 7510-SELECT-XFORMER-SPEC  *'     
                   DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC              
                   DISPLAY '* PROGRAM ABENDING...                *'     
                   DISPLAY '***************PCSMT617***************'     
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7520-SELECT-XFORMER-CLASS                                **           
      **                                                            **          
      ****************************************************************          
       7520-SELECT-XFORMER-CLASS.                                       
      *                                                                         
           MOVE '7520'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               SELECT XFORMER_CLASS_CD                                  
                     ,RATE_FACTOR                                       
                     ,BURDEN_CAPACITY                                   
                     ,VOLTAGE_CLASS                                     
                     ,XFORMER_TYPE_CD                                   
                     ,CONNECTION_TYPE                                   
                     ,BIL_RATING                                        
               INTO  :XC-XFORMER-CLASS-CD                               
                    ,:XC-RATE-FACTOR                                    
                    ,:XC-BURDEN-CAPACITY                                
                    ,:XC-VOLTAGE-CLASS                                  
                    ,:XC-XFORMER-TYPE-CD                                
                    ,:XC-CONNECTION-TYPE                                
                    ,:XC-BIL-RATING                                     
               FROM   CSS_XFORMER_CLASS                                 
               WHERE  XFORMER_CLASS_CD = :XC-XFORMER-CLASS-CD           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   PERFORM 2500-LOAD-ERROR-ARRAY THRU 2500-EXIT         
                   MOVE 'E-FMT617-XFORMER-CLASS-CD'                     
                                       TO ERR-FIELD (WS-ERR-ARRAY-IDX)  
                   STRING XC-XFORMER-CLASS-CD,                          
                          ' NOT FOUND IN TABLE'                         
                          DELIMITED BY SIZE                             
                                     INTO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
                   END-STRING                                           
               ELSE                                                     
                   MOVE SQLCODE        TO WS-DISPLAY-RC                 
                   DISPLAY '***************PCSMT617****************'    
                   DISPLAY '* ERROR ON 7520-SELECT-XFORMER-CLASS *'     
                   DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC              
                   DISPLAY '* PROGRAM ABENDING...                 *'    
                   DISPLAY '***************PCSMT617****************'    
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  14500019
      **                                                            **  14510019
      **  7530-SELECT-MTR-STORGE-FAC                                **  14520019
      **                                                            **  14530019
      ****************************************************************  14540019
       7530-SELECT-MTR-STORGE-FAC.                                      
      *                                                                 14560019
           MOVE '7530'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                 14580019
           EXEC SQL                                                     
               SELECT  MTR_STORAGE_FAC_TX                               
                 INTO :W9-MTR-STORAGE-FAC-TX                            
                 FROM  CSS_MTR_STORGE_FAC                               
                WHERE  CODE_UTIL_TYPE     = :W9-CODE-UTIL-TYPE          
                  AND  COMPANY_NO         = :W9-COMPANY-NO              
                  AND  MTR_STORAGE_FAC_CD = :WS-LOCAL-OFFICE            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14660019
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               CONTINUE                                                 
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   PERFORM 2500-LOAD-ERROR-ARRAY THRU 2500-EXIT         
                   MOVE 'E-FMT617-MTR-STORAGE-FAC'                      
                                       TO ERR-FIELD (WS-ERR-ARRAY-IDX)  
                   STRING WS-LOCAL-OFFICE,                              
                          ' NOT FOUND IN TABLE'                         
                          DELIMITED BY SIZE                             
                                     INTO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
                   END-STRING                                           
               ELSE                                                     
                   MOVE SQLCODE        TO WS-DISPLAY-RC                 
                   DISPLAY '***************PCSMT617****************'    
                   DISPLAY '* ERROR ON 7530-SELECT-MTR-STOEGE-FAC *'    
                   DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC              
                   DISPLAY '* XFORMER NBR ' E-FMT617-XFORMER-NO         
                   DISPLAY '* PROGRAM ABENDING...                 *'    
                   DISPLAY '***************PCSMT617****************'    
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                 14780019
       7530-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14810019
      *****************************************************************         
      * IF LINE COUNTER IS > 56 PRINTS THE PAGE HEADINGS, MOVES INPUT**         
      * VARIABLES TO THE REPORT VARIABLES AND  PRINTS THE REPORT.    **         
      *****************************************************************         
      *                                                                         
       8105-WRITE-PRINTER-RECORD.                                       
      *                                                                         
           IF WS-LINE-CNTR > 56                                         
              PERFORM 8200-PRT-HEADINGS       THRU 8200-EXIT            
              ADD WS-TWO                      TO WS-LINE-CNTR           
              SET ERROR-FOUND                 TO TRUE                   
           END-IF.                                                      
           MOVE WS-DET-LINE-1                  TO PRT33-DATA.           
           PERFORM 8300-WRITE-PRINT-REC        THRU 8300-EXIT.          
           MOVE WS-ONE                         TO WS-LINE-SPACE.        
           ADD WS-ONE                          TO WS-LINE-CNTR.         
      *                                                                         
       8105-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  PRINTS THE PAGE HEADINGS  AT THE TOP OF EACH PAGE          **          
      ****************************************************************          
      *                                                                         
       8200-PRT-HEADINGS.                                               
           MOVE 0                              TO WS-LINE-CNTR.         
           ADD WS-ONE                          TO WS-PAGE.              
           MOVE WS-PAGE                        TO WS-DET-PAGE.          
           MOVE WS-HDR-ONE                     TO PRT33-DATA.           
           WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
           MOVE WS-HDR-TWO                     TO PRT33-DATA.           
           MOVE WS-ONE                         TO WS-LINE-SPACE.        
           PERFORM 8300-WRITE-PRINT-REC        THRU 8300-EXIT.          
           MOVE WS-BLANK-LINE                  TO PRT33-DATA.           
           PERFORM 8300-WRITE-PRINT-REC        THRU 8300-EXIT.          
           MOVE WS-HDR-THREE                   TO PRT33-DATA.           
           MOVE WS-TWO                         TO WS-LINE-SPACE.        
           PERFORM 8300-WRITE-PRINT-REC        THRU 8300-EXIT.          
           MOVE WS-BLANK-LINE                  TO PRT33-DATA.           
           MOVE WS-ONE                         TO WS-LINE-SPACE.        
           PERFORM 8300-WRITE-PRINT-REC        THRU 8300-EXIT.          
           ADD  6                              TO WS-LINE-CNTR.         
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8300-WRITE-PRINT-REC.                                            
           WRITE PRT33-RECORD AFTER ADVANCING WS-LINE-SPACE.            
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  8500-INSERT-EQUIP                                         **          
      **                                                            **          
      ****************************************************************          
       8500-INSERT-EQUIP.                                               
      *                                                                         
           MOVE '8500'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_EQUIPMENT                                
                  ( CODE_UTIL_TYPE    ,                                 
                    DEVICE_NO         ,                                 
                    EQUIP_TYPE_CD     ,                                 
                    PALETTE_NO        ,                                 
                    SERIAL_NO         ,                                 
                    DATE_PURCHASED    ,                                 
                    DATE_DISPOSED_OF  ,                                 
                    WARRANTY_EXP_DT   ,                                 
                    INSTALL_EMP_ID    ,                                 
                    INSTALL_DT        ,                                 
                    CODE_CRNT_LOC     ,                                 
                    CRNT_LOC_NO       ,                                 
                    DATE_LAST_TRAN    ,                                 
                    DATE_LAST_MOVE    ,                                 
                    LOCAL_OFFICE      ,                                 
                    MFR_DT            ,                                 
                    CODE_MAKE         ,                                 
                    DATE_OBSOLETE     ,                                 
                    UPGRADES_TX       ,                                 
                    HAZARD_MATERIAL_CD,                                 
                    COMPANY_NO )                                        
               VALUES                                                   
                  (:EQ-CODE-UTIL-TYPE                            ,      
                   :EQ-DEVICE-NO                                 ,      
                   :EQ-EQUIP-TYPE-CD                             ,      
                   :EQ-PALETTE-NO                                ,      
                   :EQ-SERIAL-NO                                 ,      
                   IIF(TRY_CONVERT(DATE, :EQ-DATE-PURCHASED 
                                         :WS-DATE-PURCHASED-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-PURCHASED 
                                                :WS-DATE-PURCHASED-NULL
              ) <> 0) OR (LEN(:EQ-DATE-PURCHASED 
                                                :WS-DATE-PURCHASED-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-PURCHASED 
                                                :WS-DATE-PURCHASED-NULL
              ), CONVERT(DATE, :EQ-DATE-PURCHASED 
                                                :WS-DATE-PURCHASED-NULL
              ) )  ,      
                   IIF(TRY_CONVERT(DATE, :EQ-DATE-DISPOSED-OF 
                                         :WS-DATE-DISPOSED-OF-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-DISPOSED-OF 
                                              :WS-DATE-DISPOSED-OF-NULL
              ) <> 0) OR (LEN(:EQ-DATE-DISPOSED-OF 
                                              :WS-DATE-DISPOSED-OF-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-DISPOSED-OF 
                                              :WS-DATE-DISPOSED-OF-NULL
              ), CONVERT(DATE, :EQ-DATE-DISPOSED-OF 
                                              :WS-DATE-DISPOSED-OF-NULL
              ) ),      
                   IIF(TRY_CONVERT(DATE, :EQ-WARRANTY-EXP-DT 
                                         :WS-WARRANTY-EXP-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-WARRANTY-EXP-DT 
                                               :WS-WARRANTY-EXP-DT-NULL
              ) <> 0) OR (LEN(:EQ-WARRANTY-EXP-DT 
                                               :WS-WARRANTY-EXP-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-WARRANTY-EXP-DT 
                                               :WS-WARRANTY-EXP-DT-NULL
              ), CONVERT(DATE, :EQ-WARRANTY-EXP-DT 
                                               :WS-WARRANTY-EXP-DT-NULL
              ) ) ,      
                   :EQ-INSTALL-EMP-ID                            ,      
                   IIF(TRY_CONVERT(DATE, :EQ-INSTALL-DT 
                                         :WS-INSTALL-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-INSTALL-DT 
                                                    :WS-INSTALL-DT-NULL
              ) <> 0) OR (LEN(:EQ-INSTALL-DT :WS-INSTALL-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-INSTALL-DT 
                                                    :WS-INSTALL-DT-NULL
              ), CONVERT(DATE, :EQ-INSTALL-DT :WS-INSTALL-DT-NULL
              ) )      ,      
                   :EQ-CODE-CRNT-LOC                             ,      
                   :EQ-CRNT-LOC-NO                               ,      
                   IIF(TRY_CONVERT(DATE, :EQ-DATE-LAST-TRAN 
                                         :WS-DATE-LAST-TRAN-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-TRAN 
                                                :WS-DATE-LAST-TRAN-NULL
              ) <> 0) OR (LEN(:EQ-DATE-LAST-TRAN 
                                                :WS-DATE-LAST-TRAN-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-TRAN 
                                                :WS-DATE-LAST-TRAN-NULL
              ), CONVERT(DATE, :EQ-DATE-LAST-TRAN 
                                                :WS-DATE-LAST-TRAN-NULL
              ) )  ,      
                   IIF(TRY_CONVERT(DATE, :EQ-DATE-LAST-MOVE 
                                         :WS-DATE-LAST-MOVE-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-MOVE 
                                                :WS-DATE-LAST-MOVE-NULL
              ) <> 0) OR (LEN(:EQ-DATE-LAST-MOVE 
                                                :WS-DATE-LAST-MOVE-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-MOVE 
                                                :WS-DATE-LAST-MOVE-NULL
              ), CONVERT(DATE, :EQ-DATE-LAST-MOVE 
                                                :WS-DATE-LAST-MOVE-NULL
              ) )  ,      
                   :WS-LOCAL-OFFICE                              ,      
                   IIF(TRY_CONVERT(DATE, :EQ-MFR-DT :WS-MFR-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-MFR-DT :WS-MFR-DT-NULL
              ) <> 0) OR (LEN(:EQ-MFR-DT :WS-MFR-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-MFR-DT :WS-MFR-DT-NULL
              ), CONVERT(DATE, :EQ-MFR-DT :WS-MFR-DT-NULL) )          ,      
                   :EQ-CODE-MAKE                                 ,      
                   IIF(TRY_CONVERT(DATE, :EQ-DATE-OBSOLETE 
                                         :WS-DATE-OBSOLETE-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-OBSOLETE 
                                                 :WS-DATE-OBSOLETE-NULL
              ) <> 0) OR (LEN(:EQ-DATE-OBSOLETE :WS-DATE-OBSOLETE-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-OBSOLETE 
                                                 :WS-DATE-OBSOLETE-NULL
              ), CONVERT(DATE, :EQ-DATE-OBSOLETE :WS-DATE-OBSOLETE-NULL
              ) )   ,      
                   :EQ-UPGRADES-TX                               ,      
                   :EQ-HAZARD-MATERIAL-CD                        ,      
                   :EQ-COMPANY-NO  )                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_EQUIPMENT                                        
MFA-TR*           ( CODE_UTIL_TYPE    ,                                         
MFA-TR*             DEVICE_NO         ,                                         
MFA-TR*             EQUIP_TYPE_CD     ,                                         
MFA-TR*             PALETTE_NO        ,                                         
MFA-TR*             SERIAL_NO         ,                                         
MFA-TR*             DATE_PURCHASED    ,                                         
MFA-TR*             DATE_DISPOSED_OF  ,                                         
MFA-TR*             WARRANTY_EXP_DT   ,                                         
MFA-TR*             INSTALL_EMP_ID    ,                                         
MFA-TR*             INSTALL_DT        ,                                         
MFA-TR*             CODE_CRNT_LOC     ,                                         
MFA-TR*             CRNT_LOC_NO       ,                                         
MFA-TR*             DATE_LAST_TRAN    ,                                         
MFA-TR*             DATE_LAST_MOVE    ,                                         
MFA-TR*             LOCAL_OFFICE      ,                                         
MFA-TR*             MFR_DT            ,                                         
MFA-TR*             CODE_MAKE         ,                                         
MFA-TR*             DATE_OBSOLETE     ,                                         
MFA-TR*             UPGRADES_TX       ,                                         
MFA-TR*             HAZARD_MATERIAL_CD,                                         
MFA-TR*             COMPANY_NO )                                                
MFA-TR*        VALUES                                                           
MFA-TR*           (:EQ-CODE-UTIL-TYPE                            ,              
MFA-TR*            :EQ-DEVICE-NO                                 ,              
MFA-TR*            :EQ-EQUIP-TYPE-CD                             ,              
MFA-TR*            :EQ-PALETTE-NO                                ,              
MFA-TR*            :EQ-SERIAL-NO                                 ,              
MFA-TR*            :EQ-DATE-PURCHASED   :WS-DATE-PURCHASED-NULL  ,              
MFA-TR*            :EQ-DATE-DISPOSED-OF :WS-DATE-DISPOSED-OF-NULL,              
MFA-TR*            :EQ-WARRANTY-EXP-DT  :WS-WARRANTY-EXP-DT-NULL ,              
MFA-TR*            :EQ-INSTALL-EMP-ID                            ,              
MFA-TR*            :EQ-INSTALL-DT       :WS-INSTALL-DT-NULL      ,              
MFA-TR*            :EQ-CODE-CRNT-LOC                             ,              
MFA-TR*            :EQ-CRNT-LOC-NO                               ,              
MFA-TR*            :EQ-DATE-LAST-TRAN   :WS-DATE-LAST-TRAN-NULL  ,              
MFA-TR*            :EQ-DATE-LAST-MOVE   :WS-DATE-LAST-MOVE-NULL  ,              
MFA-TR*            :WS-LOCAL-OFFICE                              ,              
MFA-TR*            :EQ-MFR-DT           :WS-MFR-DT-NULL          ,              
MFA-TR*            :EQ-CODE-MAKE                                 ,              
MFA-TR*            :EQ-DATE-OBSOLETE    :WS-DATE-OBSOLETE-NULL   ,              
MFA-TR*            :EQ-UPGRADES-TX                               ,              
MFA-TR*            :EQ-HAZARD-MATERIAL-CD                        ,              
MFA-TR*            :EQ-COMPANY-NO  )                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR -803                     
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '***********PCSMT617**************'              
               DISPLAY '* ERROR INSERTING CSS_EQUIPMENT *'              
               DISPLAY '* XFORMER-NO   IS ', EQ-DEVICE-NO               
               DISPLAY '* COMPANY-NO   IS ', EQ-COMPANY-NO              
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...           *'              
               DISPLAY '***********PCSMT617**************'              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  8600-INSERT-INSTR-XFORMER                                 **          
      **                                                            **          
      ****************************************************************          
       8600-INSERT-INSTR-XFORMER.                                       
      *                                                                         
           MOVE '8600'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_INSTR_XFORMER                            
                    ( XFORMER_NO                                        
                     ,BIL_RATING_CD                                     
                     ,BURDEN_QT                                         
                     ,VOLTAGE_CLASS                                     
                     ,XFORMER_TYPE_CD                                   
                     ,CODE_UTIL_TYPE                                    
                     ,DEVICE_TYPE_CD                                    
                     ,XFORMER_SIZE_ID                                   
                     ,RTO_UPPER_FRACTION                                
                     ,RTO_LOWER_FRACTION                                
                     ,XFORMER_SPEC_CD                                   
                     ,CONNECTION_TYPE                                   
                     ,RATE_FACTOR                                       
                     ,XFORMER_CLASS_CD                                  
                     ,DIELECTRIC_GAL                                    
                     ,PCB_LAB_TST_REF_NO                                
                     ,PPM_PCB                                           
                     ,COMPANY_NO)                                       
             VALUES                                                     
                  ( :IX-XFORMER-NO                                      
                   ,:IX-BIL-RATING-CD                                   
                   ,:IX-BURDEN-QT                                       
                   ,:IX-VOLTAGE-CLASS                                   
                   ,:IX-XFORMER-TYPE-CD                                 
                   ,:IX-CODE-UTIL-TYPE                                  
                   ,:IX-DEVICE-TYPE-CD                                  
                   ,:IX-XFORMER-SIZE-ID                                 
                   ,:IX-RTO-UPPER-FRACTION                              
                   ,:IX-RTO-LOWER-FRACTION                              
                   ,:IX-XFORMER-SPEC-CD                                 
                   ,:IX-CONNECTION-TYPE                                 
                   ,:IX-RATE-FACTOR                                     
                   ,:IX-XFORMER-CLASS-CD                                
                   ,:IX-DIELECTRIC-GAL                                  
                   ,:IX-PCB-LAB-TST-REF-NO                              
                   ,:IX-PPM-PCB                                         
                   ,:IX-COMPANY-NO)                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '*************PCSMT617****************'          
               DISPLAY '* ERROR INSERTING CSS_INSTR_XFORMER *'          
               DISPLAY '* XFORMER NO   IS ', IX-XFORMER-NO              
               DISPLAY '* COMPANY NO   IS ', IX-COMPANY-NO              
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...           *'              
               DISPLAY '***********PCSMT617**************'              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  8900-PRODUCE-SUMMARY-REPORTS                              **          
      **                                                            **          
      ****************************************************************          
       8900-PRODUCE-SUMMARY-REPORTS.                                    
      *                                                                         
           IF WS-LINE-CNTR > 52                                         
              PERFORM 8200-PRT-HEADINGS       THRU 8200-EXIT            
              ADD WS-TWO               TO WS-LINE-CNTR                  
           END-IF.                                                      
           MOVE WS-ONE                 TO WS-LINE-SPACE.                
           IF NOT ERROR-FOUND                                           
              MOVE WS-NO-ERROR-LINE    TO PRT33-DATA                    
              PERFORM 8300-WRITE-PRINT-REC    THRU 8300-EXIT            
           END-IF.                                                      
           MOVE WS-BLANK-LINE          TO PRT33-DATA.                   
           PERFORM 8300-WRITE-PRINT-REC       THRU 8300-EXIT.           
      *                                                                         
           MOVE WS-TOT-RECDS-INFO      TO WS-RPT-MESSAGE.               
           MOVE WS-NBR-XFORM-RECS      TO WS-RPT-STATISTICS.            
           MOVE WS-DET-LINE-2          TO PRT33-DATA.                   
           PERFORM 8300-WRITE-PRINT-REC       THRU 8300-EXIT.           
      *                                                                         
           MOVE WS-TOT-GOOD-RECDS      TO WS-RPT-MESSAGE.               
           MOVE WS-NBR-GOOD-RECS       TO WS-RPT-STATISTICS.            
           MOVE WS-DET-LINE-2          TO PRT33-DATA.                   
           PERFORM 8300-WRITE-PRINT-REC       THRU 8300-EXIT.           
      *                                                                         
           MOVE WS-TOT-BAD-RECDS       TO WS-RPT-MESSAGE.               
           MOVE WS-NBR-BAD-RECS        TO WS-RPT-STATISTICS.            
           MOVE WS-DET-LINE-2          TO PRT33-DATA.                   
           PERFORM 8300-WRITE-PRINT-REC       THRU 8300-EXIT.           
      *                                                                         
           MOVE WS-BLANK-LINE          TO PRT33-DATA.                   
           PERFORM 8300-WRITE-PRINT-REC       THRU 8300-EXIT.           
      *                                                                         
           MOVE WS-FOOT-LINE           TO PRT33-DATA.                   
           PERFORM 8300-WRITE-PRINT-REC       THRU 8300-EXIT.           
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **                                                            **          
      **  9000-TERMINATE                                            **          
      **                                                            **          
      ****************************************************************          
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSMT617-FILE                                          
                 FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE     **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
