       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSMT605.                                        
       DATE-WRITTEN.   DEC 1999.                                        
       DATE-COMPILED.                                                   
      ****************************************************************          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                      DB2                       ********          
      ****************************************************************          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      **           DATE    INITIALS       REASON                    **          
      **         ________  ________   _____________________________ **          
T35434**  08/24/07  RK12999  IMPELEMENTED RESTART / COMMIT LOGIC    **          
T35434**                                                            **          
A01209**  05/05/09  GD97441  IF VALID ATTACHMENT ALREADY EXISTS IN  **          
A01209**                     EQUIP_ATTCHMTS & IT IS VALID, PROCESS  **          
A01209**                     UPDATES. DON'T ABEND THE PROGRAM.      **          
A01209**  05/10/09  SJ97149  DELETE RETURN CODE = 9 WHEN WRITING    **          
A01209**            ACT0020  OUT ERROR REPORT                       **          
A04527**  05/10/09  BD09555  CHANGE IF STATEMENT TO MOVE TO         **          
A04517**            ACT180    INVENTORY                             **          
A04860*  12/20/13   MR7E794  LOAD DIRECTLY CSS_WQ_ITEMS INSTEAD OF  **          
A04860*             ACT005   CSS_WQ_ITEMS_MF BY CALLING SUB PROGRAM **          
A04860*                      SCSCB077                               **          
A05462**   10/16    DB41297   MAKE PROGRAM MICROFOCUS COMPLIANT      ** 00016220
      ****************************************************************          
           REMARKS.                                                     
                              PCSMT605 NARRATIVE                        
                            GAS METER BATCH ADD PROGRAM                 
      *                                                                         
                 THIS PROGRAM READS A VENDOR FILE CONTAINING            
                 GAS METER INFORMATION FOR NEW METERS.  AN EDIT         
                 CHECK IS DONE TO ENSURE THE DATA IS CORRECT.  IF IT    
                 IS THE DATABASE IS UPDATED ACCORDINGLY.  IF PROBLEMS   
                 ARE FOUND IN A RECORD THEY ARE WRITTEN TO THE FCSPT33  
                 FILE AND PROCESSING CONTINUES.  IF AN ERROR OCCURS     
                 WHEN UPDATING THE DATABASE, IT IS WRITTEN TO THE       
                 ERROR FILE AND PROCESSING STOPS.PCSMT605 WILL PRINT    
                 THE ERRORS.                                            
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT GAS-METER-FILE ASSIGN UT-S-FCSMT20.                   
           SELECT GAS-TEST-FILE  ASSIGN UT-S-FCSMT03.                   
           SELECT FCSPT33-FILE   ASSIGN UT-S-FCSPT33.                   
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       FD  GAS-METER-FILE                                               
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       COPY FIOMT20.                                                            
      *                                                                         
       01  GAS-METER-REC.                                               
           05  GAS-TEST-DATA             PIC X(160).                    
           05  FILLER                    PIC X(140).                    
      *                                                                         
       FD  GAS-TEST-FILE                                                
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       COPY FIOMT03.                                                            
      *                                                                         
       FD  FCSPT33-FILE                                                 
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRT33-RECORD.                                                
           05  PRT33-CC                  PIC X(01).                     
           05  PRT33-DATA                PIC X(132).                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSMT605'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
             'WORKING STORAGE FOR PCSMT605 STARTS HERE'.                
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
       01  WS-ABEND-SWITCH                PIC X(03).                    
           88  WS-ABEND-YES               VALUE 'YES'.                  
      *                                                                         
       01  WS-WORK-AREA.                                                
           05  WS-DISPLAY-RC           PIC -ZZZZZZZZ9.9.                
           05  WS-PGRMNAME             PIC X(08)     VALUE 'PCSMT605'.  
A04860     05  SCSCB077                PIC X(08)     VALUE 'SCSCB077'.  
A04860*                                                                         
A04860     05  RS-RETURN-CODE           PIC S9(09)  COMP VALUE +0.      
A04860     05  WS-ITEM-ID               PIC S9(10)V COMP-3 VALUE +0.    
      *                                                                         
           05  COUNTERS.                                                
               10  WS-NBR-METER-RECS   PIC S9(5)     COMP-3 VALUE 0.    
               10  WS-NBR-GOOD-RECS    PIC S9(5)     COMP-3 VALUE 0.    
               10  WS-NBR-BAD-RECS     PIC S9(5)     COMP-3 VALUE 0.    
               10  WS-NO-ADDITION-MTRS PIC S9(5)     COMP-3 VALUE 0.    
               10  WS-INSPECT-CNTR     PIC  9(5)     VALUE 0.           
      *                                                                         
           05  WS-ERROR-ARRAY-SIZE         PIC S9(04) COMP VALUE +0.    
           05  WS-LOCAL-OFFICE             PIC X(03).                   
           05  WS-CODE-UTIL-TYPE           PIC X(01).                   
           05  WS-SYSIN-COMP-NO            PIC X(02) VALUE SPACES.      
ACT180     05  WS-INVENTORY                PIC X(01) VALUE 'A'.         
           05  WS-MTR-SIZE-FOUND           PIC X(01) VALUE 'N'.         
               88  METER-SIZE-FOUND                  VALUE 'Y'.         
           05  WS-CODE-VALUE           PIC X(10) VALUE SPACES.          
           05  WS-VER-CODE-SUB         PIC 9(02).                       
           05  WS-HOW-CONN-SUB         PIC 9(02).                       
           05  WS-COLUMN-NA            PIC X(18) VALUE SPACES.          
           05  WS-TABLE-NA             PIC X(18) VALUE SPACES.          
           05  WS-DB-COMPANY-NO        PIC X(02) VALUE SPACES.          
           05  WS-DB-CODE-UTIL-TYPE    PIC X(01) VALUE SPACES.          
           05  WS-DB-METER-NO          PIC X(12) VALUE SPACES.          
A01209     05  WS-MP-DATE-MOVE           PIC X(10) VALUE SPACES.        
A01209     05  WS-MP-MTR-STORAGE-FAC-CD  PIC X(03) VALUE SPACES.        
A01209     05  WS-MP-EQUIP-LOC-ID        PIC X(01) VALUE SPACES.        
      *                                                                         
           05  WS-NULLIND-DATE-PURCHASED   PIC S9(04) COMP VALUE +0.    
               88  DATE-PURCHASED-NULL                     VALUE -1.    
               88  DATE-PURCHASED-NOT-NULL                 VALUE +0.    
           05  WS-NULLIND-DATE-DISPOSED    PIC S9(04) COMP VALUE +0.    
               88  DATE-DISPOSED-NULL                      VALUE -1.    
           05  WS-NULLIND-DATE-OBSOLETE    PIC S9(04) COMP VALUE +0.    
               88  DATE-OBSOLETE-NULL                      VALUE -1.    
           05  WS-NULLIND-WARRANTY-DATE    PIC S9(04) COMP VALUE +0.    
               88  WARRANTY-DATE-NULL                      VALUE -1.    
               88  WARRANTY-DATE-NOT-NULL                  VALUE +0.    
           05  WS-NULLIND-INSTALL-DT       PIC S9(04) COMP VALUE +0.    
               88  INSTALL-DT-NULL                         VALUE -1.    
           05  WS-NULLIND-DATE-LAST-TRAN   PIC S9(04) COMP VALUE +0.    
               88  DATE-LAST-TRAN-NULL                     VALUE -1.    
               88  DATE-LAST-TRAN-NOT-NULL                 VALUE +0.    
           05  WS-NULLIND-DATE-LAST-MOVE   PIC S9(04) COMP VALUE +0.    
               88  DATE-LAST-MOVE-NULL                     VALUE -1.    
               88  DATE-LAST-MOVE-NOT-NULL                 VALUE +0.    
           05  WS-NULLIND-MFR-DATE         PIC S9(04) COMP VALUE +0.    
               88  MFR-DATE-NULL                           VALUE -1.    
           05  WS-NULLIND-LAST-TEST-SEL-DT PIC S9(04) COMP VALUE +0.    
               88  LAST-TEST-SEL-DT-NULL                   VALUE -1.    
           05  WS-NULLIND-DATE-LAST-TESTED PIC S9(04) COMP VALUE +0.    
               88  DATE-LAST-TESTED-NULL                   VALUE -1.    
           05  WS-NULLIND-ATTACH-DT        PIC S9(04) COMP VALUE +0.    
               88  ATTACH-DT-NOT-NULL                      VALUE +0.    
                                                                        
           05  WS-DRIVE-COMP               PIC S9(04) COMP VALUE +0.    
           05  WS-DRIVE-OPTIONS            PIC X(10).                   
           05  WS-DRV-OPTIONS-N REDEFINES WS-DRIVE-OPTIONS.             
               10  WS-DRIVE-OPTIONS-N      PIC 9(04).                   
               10  FILLER                  PIC 9(06).                   
      *                                                                         
           05  INDEXES.                                                 
               10  WS-ERR-ARRAY-IDX    PIC S9(04)   COMP VALUE ZEROES.  
      *                                                                         
           05  FLAGS.                                                   
               10  WS-EOF-FLAG         PIC X(01)    VALUE 'N'.          
                   88  END-OF-FILE                  VALUE 'Y'.          
               10  WS-RECORD-FLAG      PIC X(01)    VALUE 'N'.          
                   88  GOOD-RECORD                  VALUE 'N'.          
               10  NO-ERROR-FOUND      PIC X(01)    VALUE 'Y'.          
                   88  ERROR-FOUND                  VALUE 'N'.          
               10  WS-USE-OF-CHAR-ATT  PIC X(01)    VALUE 'N'.          
                   88  WS-USE-12-CHAR-ATT           VALUE 'N'.          
                   88  WS-USE-09-CHAR-ATT           VALUE 'Y'.          
               10  WS-CODE-VAL-MATCH-SW  PIC X(01)  VALUE 'N'.          
                   88  WS-CODE-VAL-NOT-MATCHED      VALUE 'N'.          
                   88  WS-CODE-VAL-MATCHED          VALUE 'Y'.          
               10  WS-ATTACHMENT-ADD-SW  PIC X(01)  VALUE 'Y'.          
                   88  WS-ADD-ATTACHMENT            VALUE 'Y'.          
                   88  WS-NOT-ADD-ATTACHMENT        VALUE 'N'.          
               10  WS-VALID-ATTACHMENT-SW PIC X(01) VALUE 'Y'.          
                   88  WS-VALID-ATTACHMENT          VALUE 'Y'.          
                   88  WS-NOT-VALID-ATTACHMENT      VALUE 'N'.          
               10  WS-ATT-TYPE-EXIST-SW  PIC X(01)  VALUE 'Y'.          
                   88  WS-ATT-TYPE-NOT-EXISTS       VALUE 'Y'.          
                   88  WS-ATT-TYPE-EXISTS           VALUE 'N'.          
               10  WS-LOC-OFF-FLAG     PIC X(01)    VALUE 'N'.          
                   88  LOC-OFF-GIVEN                VALUE 'Y'.          
A01209         10  WS-EQUIP-ATTCH-EXIST-SW  PIC X(01) VALUE 'N'.        
A01209             88  EQUIP-ATTCHMT-ALREADY-EXISTS   VALUE 'Y'.        
A01209             88  EQUIP-ATTCHMT-NOT-EXISTS       VALUE 'N'.        
      *                                                                         
           05  WS-TEMP-CC              PIC 99.                          
           05  WS-TEMP1-CC             PIC 99.                          
           05  WS-WARRANTY-YEAR        PIC 99.                          
           05  WS-SYS-DATE.                                             
               10  WS-SYS-DATE-YY      PIC 9(02).                       
               10  WS-SYS-DATE-MM      PIC 9(02).                       
               10  WS-SYS-DATE-DD      PIC 9(02).                       
           05  WS-WARRANTY-DATE        PIC X(10).                       
           05  WS-WARRANTY-MTHS        PIC S9(04) COMP VALUE +0.        
           05  WS-DB2-TODAYS-DATE      PIC X(10).                       
           05  WS-DB2-DATE-CCYY-MM-DD.                                  
               10  WS-DB2-DATE-CC      PIC X(2).                        
               10  WS-DB2-DATE-YY      PIC X(2).                        
               10  FILLER              PIC X VALUE '-'.                 
               10  WS-DB2-DATE-MM      PIC X(2).                        
               10  FILLER              PIC X VALUE '-'.                 
               10  WS-DB2-DATE-DD      PIC X(2).                        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-ONE                  PIC 9(01)    VALUE 1.            
           05  WS-TWO                  PIC 9(01)    VALUE 2.            
           05  WS-SIX                  PIC 9(01)    VALUE 6.            
           05  WS-FIFTY-SIX            PIC 9(02)    VALUE 56.           
           05  WS-FIFTY-TWO            PIC 9(02)    VALUE 52.           
           05  WS-G                    PIC X(01)    VALUE 'G'.          
           05  WS-M                    PIC X(01)    VALUE 'M'.          
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
T35434     05  WS-I                    PIC X(01)    VALUE 'I'.          
      *                                                                         
       01  ERROR-HOLD-AREA.                                             
           05  ERROR-ARRAY OCCURS 100 TIMES.                            
               10  ERR-MTR-SIZE        PIC X(08).                       
               10  ERR-METER-NBR       PIC X(09).                       
               10  ERR-SERIAL-NBR      PIC X(11).                       
               10  ERR-FIELD           PIC X(20).                       
               10  ERR-PROBLEM         PIC X(46).                       
      *                                                                         
      * TABLE TO STORE VERSION CODE VALUES                                      
       01  VERSION-CODE-AREA.                                           
           05 WS-VER-CODE-VAL-TAB.                                      
              10 WS-VER-CODE-VAL-ROW OCCURS 50 TIMES                    
                              INDEXED BY WS-VER-INDX.                   
                 15 WS-TAB-UTL-CODE-VAL       PIC X(01).                
                 15 WS-TAB-ATT-CODE-VAL       PIC X(02).                
                 15 WS-TAB-VER-CODE-VAL       PIC X(03).                
      *                                                                         
      * TABLE TO STORE HOW CONNECTED CODE VALUES                                
       01  CONNECTED-CODE-AREA.                                         
           05 WS-HOW-CONN-VAL-TAB.                                      
              10 WS-HOW-CONN-VAL-ROW OCCURS 10 TIMES                    
                              INDEXED BY WS-CONN-INDX.                  
                 15 WS-TAB-HOW-CONN-VAL       PIC X(01).                
      *                                                                         
T35434 01  WS-RESTART-MISC.                                             
T35434     05  WS-COUNT-UNSUCCESSFUL-ROWS                               
T35434                                   PIC S9(04)  COMP-3 VALUE ZERO. 
T35434     05  WS-RESTART-DATA-LENGTH    PIC S9(04)  COMP VALUE +39.    
T35434     05  WS-IS-THIS-A-RESTART      PIC X(01)   VALUE 'N'.         
T35434         88  WS-THIS-IS-A-RESTART              VALUE 'Y'.         
T35434     05  WS-RESTART-COMMIT-COUNTER PIC 9(04)   VALUE ZERO.        
T35434     05  WS-RESTART-REQ            PIC X(01).                     
T35434     05  WS-DEFAULT-RESTART-REQ    PIC X(01)   VALUE 'N'.         
T35434     05  WS-PROCESS-TYPE           PIC 9(01).                     
T35434     05  WS-DEFAULT-CHKP-LUW-LIMIT PIC 9(04)   VALUE 4.           
T35434     05  WS-FLAG-TO-TURN-OFF-COMMITS PIC 9(04) VALUE 9999.        
T35434     05  WS-SEQ-NO                 PIC 9(04)   VALUE ZERO.        
T35434     05  WS-CHKP-LUW-LIMIT         PIC 9(04)   VALUE ZERO.        
T35434     05  WS-CHKP-LUW-COUNTER       PIC 9(04)   VALUE ZERO COMP-3. 
T35434     05  WS-DEFAULT-CHKP-UPD-LIMIT PIC 9(04)   VALUE 20.          
T35434     05  WS-CHKP-UPD-LIMIT         PIC 9(04)   VALUE ZERO.        
T35434     05  WS-COMMIT-REQ-SW          PIC X(1)    VALUE 'Y'.         
T35434         88 WS-COMMITS-REQUIRE                 VALUE 'Y'.         
T35434         88 WS-COMMITS-NOT-REQUIRE             VALUE 'N'.         
T35434     05  WS-CHKP-UPD-COUNTER       PIC 9(04)   VALUE ZERO COMP-3. 
T35434     05  WS-CHKP-ID.                                              
T35434         10 WS-CHKP-PGM-ID         PIC X(02)   VALUE '09'.        
T35434         10 WS-CHKP-PART-NO        PIC 9(01)   VALUE 1.           
T35434         10 WS-CHKP-SEQ-NO         PIC 9(05)   VALUE ZERO.        
T35434*                                                                         
T35434 01  WS-RESTART-DATA.                                             
T35434     05  WS-RESTART-PROCESS-TYPE   PIC 9(01).                     
T35434     05  WS-RESTART-JOB-COMPLETE   REDEFINES                      
T35434         WS-RESTART-PROCESS-TYPE   PIC X(01).                     
T35434     05  WS-RESTART-JOB-STATUS     PIC X(01).                     
T35434         88  WS-RUN-COMPLETED-NO-PROBLEMS      VALUE 'A'.         
T35434         88  WS-RERUN-COMPLETED                VALUE 'B'.         
T35434         88  WS-RERUN-PENDING                  VALUE 'C'.         
T35434     05  WS-RESTART-CHKP-SEQ-NO     PIC 9(05).                    
T35434     05  WS-FMT20-METER-NO          PIC X(09).                    
T35434     05  WS-FMT20-METER-SERIAL-NBR  PIC X(11).                    
T35434     05  WS-RESTART-FIOMT20-REC-CNTR                              
T35434                                   PIC S9(07)  COMP-3 VALUE ZERO. 
T35434     05  WS-RESTART-GOOD-REC-CNTR                                 
T35434                                   PIC S9(07)  COMP-3 VALUE ZERO. 
T35434     05  WS-RESTART-BAD-REC-CNTR                                  
T35434                                   PIC S9(07)  COMP-3 VALUE ZERO. 
      *                                                                         
A04860 COPY CWS00010.                                                           
       COPY CWS00038.                                                           
      *                                                                         
       01  WS-PARAMETER-DATA REDEFINES WS-INPUT-DATA-BREAKDOWN.         
           05  WS-PARAMETER-NAME       PIC X(13).                       
               88  LOCAL-OFF-DATA                   VALUE               
                                                 'LOCAL-OFFICE='.       
           05  WS-PARAMETER-VALUE      PIC X(10).                       
           05  FILLER REDEFINES WS-PARAMETER-VALUE.                     
               10  LOCAL-OFF-VALUE     PIC X(02).                       
               10                      PIC X(08).                       
      *                                                                         
       01  WS-ATT-PARM-DATA REDEFINES WS-INPUT-DATA-BREAKDOWN.          
           05  WS-ATT-PARM-NAME        PIC X(17).                       
               88  ATT-NBR-XPND-DATA                VALUE               
                                              'ATT NBR EXPANDED='.      
           05  WS-ATT-PARM-VALUE       PIC X(01).                       
               88  ATT-NBR-12-CHAR                VALUE 'Y'.            
               88  ATT-NBR-09-CHAR                VALUE 'N'.            
           05  FILLER                  PIC X(15).                       
      *                                                                         
       01  WS-HDR-ONE.                                                  
           05 FILLER                   PIC X(08)  VALUE                 
              'PCSMT605'.                                               
           05 FILLER                   PIC X(39)  VALUE SPACES.         
           05 FILLER                   PIC X(39)  VALUE                 
              'SOUTH CAROLINA ELECTRIC AND GAS COMPANY'.                
           05 FILLER                   PIC X(30)  VALUE SPACES.         
           05 FILLER                   PIC X(06)  VALUE                 
              'PAGE: '.                                                 
           05 FILLER                   PIC X(06)  VALUE SPACES.         
           05 WS-DET-PAGE              PIC ZZZZ   VALUE SPACES.         
      *                                                                         
       01  WS-HDR-TWO.                                                  
           05 FILLER                   PIC X(50)  VALUE SPACES.         
           05 FILLER                   PIC X(30)  VALUE                 
              '     GAS METER ADDITION ERRORS'.                         
           05 FILLER                   PIC X(36)  VALUE SPACES.         
           05 FILLER                   PIC X(06)  VALUE                 
              'DATE: '.                                                 
           05 WS-RUN-DATE.                                              
              10 WS-RUN-DATE-MM        PIC X(02) VALUE SPACES.          
              10 FILLER                PIC X(01) VALUE '/'.             
              10 WS-RUN-DATE-DD        PIC X(02) VALUE SPACES.          
              10 FILLER                PIC X(01) VALUE '/'.             
              10 WS-RUN-DATE-CC        PIC X(02) VALUE SPACES.          
              10 WS-RUN-DATE-YY        PIC X(02) VALUE SPACES.          
      *                                                                         
       01  WS-HDR-THREE.                                                
           05 FILLER                   PIC X(05)  VALUE SPACES.         
           05 FILLER                   PIC X(08)  VALUE                 
              'MTR SIZE'.                                               
           05 FILLER                   PIC X(06)  VALUE SPACES.         
           05 FILLER                   PIC X(08)  VALUE                 
              'METER NO'.                                               
           05 FILLER                   PIC X(05)  VALUE SPACES.         
           05 FILLER                   PIC X(09)  VALUE                 
              'SERIAL NO'.                                              
           05 FILLER                   PIC X(05)  VALUE SPACES.         
           05 FILLER                   PIC X(11)  VALUE                 
              'ERROR FIELD'.                                            
           05 FILLER                   PIC X(20)  VALUE SPACES.         
           05 FILLER                   PIC X(12)  VALUE                 
              'PROBLEM DESC'.                                           
      *                                                                         
       01 WS-DET-LINE-1.                                                
          05  FILLER                   PIC X(06)  VALUE SPACES.         
          05  WS-RPT-MTR-SIZE          PIC X(08).                       
          05  FILLER                   PIC X(05)  VALUE SPACES.         
          05  WS-RPT-METER-NO          PIC X(09).                       
          05  FILLER                   PIC X(03)  VALUE SPACES.         
          05  WS-RPT-SERIAL-NO         PIC X(11).                       
          05  FILLER                   PIC X(04)  VALUE SPACES.         
          05  WS-RPT-ERROR-FIELD       PIC X(20).                       
          05  FILLER                   PIC X(11)  VALUE SPACES.         
          05  WS-RPT-PROBLEM-DESC      PIC X(46).                       
      *                                                                         
       01 WS-DET-LINE-2.                                                
          05  FILLER                   PIC X(05)  VALUE SPACES.         
          05  WS-RPT-MESSAGE           PIC X(20)  VALUE SPACES.         
          05  FILLER                   PIC X(03)                        
              VALUE ':  '.                                              
          05  WS-RPT-STATISTICS        PIC ZZZZ9  VALUE SPACES.         
      *                                                                         
       01  WS-FOOT-LINE.                                                
           05 FILLER                           PIC X(55)  VALUE SPACES. 
           05 FILLER                           PIC X(22)  VALUE         
              '*** END OF  REPORT ***'.                                 
           05 FILLER                           PIC X(55)  VALUE SPACES. 
      *                                                                         
       01  WS-NO-ERROR-LINE.                                            
           05 FILLER                           PIC X(55)  VALUE SPACES. 
           05 FILLER                           PIC X(23)  VALUE         
              '*** NO ERRORS FOUND ***'.                                
           05 FILLER                           PIC X(54)  VALUE SPACES. 
      *                                                                         
       01  WS-ERROR-RPT-MSGS.                                           
           05 WS-TOT-RECDS-INFO        PIC X(18)    VALUE               
              ' TOTAL I/P RECORDS'.                                     
           05 WS-TOT-GOOD-RECDS        PIC X(13)    VALUE               
              ' GOOD RECORDS'.                                          
           05 WS-TOT-BAD-RECDS         PIC X(12)    VALUE               
              ' BAD RECORDS'.                                           
           05 WS-TOT-UNADDED-MTRS      PIC X(17)    VALUE               
              ' NOT ADDED METERS'.                                      
      *                                                                         
       01  WS-VARIABLES.                                                
           05 WS-LINE-CNTR                     PIC 9(02)  VALUE 57.     
           05 WS-BLANK-LINE                    PIC X(132) VALUE SPACES. 
           05 WS-PAGE                          PIC 9(04)  VALUE ZEROS.  
           05 WS-LINE-SPACE                    PIC 9(01)  VALUE ZERO.   
      *                                                                         
       01  WS-WQ-COMMENTS.                                              
           05  WS-WQ-COMMENTS-LEN   PIC S9(4) USAGE COMP VALUE +84.     
           05  WS-WQ-COMMENTS-TEXT.                                     
               10  FILLER           PIC X(15) VALUE 'GAS METER      '.  
               10  WS-WQ-METER-NO   PIC X(09).                          
               10  FILLER           PIC X(01) VALUE SPACES.             
               10  FILLER           PIC X(42) VALUE                     
               'EXISTS ON CSS_EQUIPMENT. CAN NOT ADD FROM '.            
               10  FILLER           PIC X(17) VALUE                     
               'VENDOR/TEST FILE.'.                                     
      *                                                                         
       01  WS-CODES-GAS-ATT-DATA-PRESENT.                               
           05  WS-ATT-TEMP-COMP             PIC X(01).                  
           05  WS-ATT-PAPER-DISK            PIC X(01).                  
           05  FILLER                       PIC X(04).                  
A04860******************************************************************        
A04860* WORKING STORAGE COPYBOOK FOR SCSCB077                          *        
A04860******************************************************************        
A04860*                                                                         
A04860     EXEC SQL                                                             
A04860        INCLUDE CWS00077                                                  
A04860     END-EXEC.                                                            
A04860*                                                                         
      *                                                                         
      ***  INCLUDE DCLGEN TABLE AND HOST VARIABLE DEFINITIONS                   
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQMAKE                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGASMSZ                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGASMTR                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRCAP                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRFAC                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRATT                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRATP                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQATTH                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBTSTSCH                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCDVALU                                                 
           END-EXEC.                                                            
      *                                                                         
T35434     EXEC SQL                                                             
T35434         INCLUDE TBRESTRT                                                 
T35434     END-EXEC.                                                            
T35434*                                                                         
A01209****************************************************************          
A01209*   DCLGEN COPYBOOK FOR CSS_EQUIP_ATT_MOVE                     *          
A01209****************************************************************          
A01209*                                                                         
A01209     EXEC SQL                                                             
A01209         INCLUDE TBEQMOVE                                                 
A01209     END-EXEC.                                                            
A01209*                                                                         
      *****************************************************************         
      **   SQL DECLARE STATEMENTS                                    **         
      *****************************************************************         
      *----------------------------------------------------------------*        
      * CURSOR TO GET EXISTING EQUIP ATTACHMENTS FOR VALIDATION                 
      *----------------------------------------------------------------*        
           EXEC SQL                                                     
               DECLARE EQUIP-ATTCHMTS CURSOR FOR                        
               SELECT  CODE_UTIL_TYPE                                   
                      ,COMPANY_NO                                       
               FROM    CSS_EQUIP_ATTCHMTS WITH(READUNCOMMITTED)                 
               WHERE   DEVICE_NO          = :LX-DEVICE-NO               
                 AND   CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE           
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE EQUIP-ATTCHMTS CURSOR FOR                                
MFA-TR*        SELECT  CODE_UTIL_TYPE                                           
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*        FROM    CSS_EQUIP_ATTCHMTS                                       
MFA-TR*        WHERE   DEVICE_NO          = :LX-DEVICE-NO                       
MFA-TR*          AND   CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE                   
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      * CURSOR TO GET EXISTING METER ATTACHMENTS FOR VALIDATION                 
      *----------------------------------------------------------------*        
           EXEC SQL                                                     
               DECLARE METER-ATTCHMTS CURSOR FOR                        
               SELECT  CODE_UTIL_TYPE                                   
                      ,COMPANY_NO                                       
                      ,METER_NO                                         
               FROM    CSS_METER_ATTCHMTS WITH(READUNCOMMITTED)                 
               WHERE   DEVICE_NO          = :MA-DEVICE-NO               
                 AND   CODE_ATT_TYPE      = :MA-CODE-ATT-TYPE           
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE METER-ATTCHMTS CURSOR FOR                                
MFA-TR*        SELECT  CODE_UTIL_TYPE                                           
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,METER_NO                                                 
MFA-TR*        FROM    CSS_METER_ATTCHMTS                                       
MFA-TR*        WHERE   DEVICE_NO          = :MA-DEVICE-NO                       
MFA-TR*          AND   CODE_ATT_TYPE      = :MA-CODE-ATT-TYPE                   
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      * CURSOR TO GET DATA FROM CODE_VALUE TABLE FOR MULTIPLE PURPOSES          
      *----------------------------------------------------------------*        
           EXEC SQL                                                     
               DECLARE CODE_VAL_CSR CURSOR FOR                          
                   SELECT CODE_VALUE                                    
                    FROM  CSS_CODE_VALUE WITH(READUNCOMMITTED)                  
                   WHERE COMPANY_NO = :WS-SYSIN-COMP-NO                 
                     AND TABLE_NA   = :WS-TABLE-NA                      
                     AND COLUMN_NA  = :WS-COLUMN-NA                     
                     AND PROGRAM_ID = 'ALL'                             
                   FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CODE_VAL_CSR CURSOR FOR                                  
MFA-TR*            SELECT CODE_VALUE                                            
MFA-TR*             FROM  CSS_CODE_VALUE                                        
MFA-TR*            WHERE COMPANY_NO = :WS-SYSIN-COMP-NO                         
MFA-TR*              AND TABLE_NA   = :WS-TABLE-NA                              
MFA-TR*              AND COLUMN_NA  = :WS-COLUMN-NA                             
MFA-TR*              AND PROGRAM_ID = 'ALL'                                     
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                      PIC X(40)    VALUE               
             'WORKING STORAGE FOR PCSMT605 ENDS HERE  '.                
      *                                                                         
       PROCEDURE DIVISION.                                              
      ****************************************************************          
      **                                                            **          
      **  0000-MAINLINE                                             **          
      **      CONTROLS MAIN PATH OF PROGRAM                         **          
      **                                                            **          
      ****************************************************************          
       0000-MAINLINE.                                                   
           DISPLAY 'AT BEGINNING OF PROGRAM'.                           
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
      *                                                                         
           PERFORM 1000-PROCESS-FILE             THRU 1000-EXIT         
               UNTIL END-OF-FILE.                                       
      *                                                                         
           PERFORM 8500-PRODUCE-SUMMARY-REPORTS  THRU 8500-EXIT.        
T35434*                                                                         
T35434     PERFORM 1900-PROCESS-SUCCESSFUL-JOB   THRU 1900-EXIT.        
T35434*                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0100-INITIALIZATION                                       **          
      **      OPEN FILES, DO FIRST READ OF METER FILE, ACCEPT DATE  **          
      **                                                            **          
      ****************************************************************          
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN INPUT GAS-METER-FILE                                    
                OUTPUT FCSPT33-FILE                                     
                       GAS-TEST-FILE.                                   
      *                                                                         
           ACCEPT WS-SYS-DATE FROM DATE.                                
           IF WS-SYS-DATE-YY GREATER THAN 50                            
               MOVE 19                 TO WS-TEMP-CC                    
           ELSE                                                         
               MOVE 20                 TO WS-TEMP-CC                    
           END-IF.                                                      
      *                                                                         
           STRING WS-TEMP-CC,                                           
                  WS-SYS-DATE-YY,                                       
                  '-',                                                  
                  WS-SYS-DATE-MM,                                       
                  '-',                                                  
                  WS-SYS-DATE-DD                                        
                               DELIMITED BY SIZE                        
                                     INTO WS-DB2-TODAYS-DATE            
           END-STRING.                                                  
           MOVE WS-SYS-DATE-MM            TO WS-RUN-DATE-MM.            
           MOVE WS-SYS-DATE-DD            TO WS-RUN-DATE-DD             
           MOVE WS-TEMP-CC                TO WS-RUN-DATE-CC.            
           MOVE WS-SYS-DATE-YY            TO WS-RUN-DATE-YY.            
      *                                                                         
T12999     ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
T12999     IF WS-SYSIN-COMP-NO EQUAL SPACES                             
T12999        MOVE WS-ONE                TO WS-SYSIN-COMP-NO            
T12999     END-IF.                                                      
      *                                                                         
           PERFORM 0300-GET-HOW-CONN-VAL  THRU 0300-EXIT.               
           PERFORM 0400-GET-VER-CODE-VAL  THRU 0400-EXIT.               
      *                                                                         
           PERFORM 8000-INITIALIZE               THRU 8000-EXIT.        
           PERFORM 0200-GET-PARM                 THRU 0200-EXIT.        
T35434*                                                                         
T35434     PERFORM 6253-GET-FJC01-CHKP-LIMIT     THRU 6253-EXIT.        
T35434     IF WS-CHKP-LUW-LIMIT = WS-FLAG-TO-TURN-OFF-COMMITS           
T35434        AND WS-CHKP-UPD-LIMIT = WS-FLAG-TO-TURN-OFF-COMMITS       
T35434            SET WS-COMMITS-NOT-REQUIRE TO TRUE                    
T35434            DISPLAY ' '                                           
T35434            DISPLAY '**   ' WS-PGRMNAME ' INFORMATIONAL MSG    **'
T35434            DISPLAY '**   CHKP-LUW AND CHKP-UPD PARMS   **'       
T35434            DISPLAY '** BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS 
T35434                    ', INTERPRETED TO**'                          
T35434            DISPLAY '**  INDICATE THAT INTERIM COMMIT   **'       
T35434            DISPLAY '**   POINTS SHOULD NOT BE TAKEN.   **'       
T35434     END-IF.                                                      
T35434*                                                                         
T35434     PERFORM 6235-GET-FJC01-RESTART-REQ    THRU 6235-EXIT.        
T35434*                                                                         
T35434     PERFORM 0150-CHECK-RESTART            THRU 0150-EXIT.        
T35434*                                                                         
T35434     PERFORM 0605-VALIDATE-RESTART-REQ     THRU 0605-EXIT.        
T35434*                                                                         
T35434     IF WS-THIS-IS-A-RESTART                                      
T35434        PERFORM 0160-REPOSITION-FILE      THRU 0160-EXIT          
T35434     ELSE                                                         
T35434         MOVE ZEROS              TO WS-NBR-GOOD-RECS              
T35434         MOVE ZEROS              TO WS-NBR-BAD-RECS               
T35434         MOVE ZEROS              TO WS-RESTART-GOOD-REC-CNTR      
T35434         MOVE ZEROS              TO WS-RESTART-BAD-REC-CNTR       
T35434         MOVE ZEROS              TO WS-RESTART-FIOMT20-REC-CNTR   
T35434         MOVE ZEROS              TO WS-RESTART-CHKP-SEQ-NO        
T35434         MOVE ZEROS              TO WS-CHKP-SEQ-NO                
T35434     END-IF.                                                      
      *                                                                         
           PERFORM 8100-READ-METER-FILE          THRU 8100-EXIT.        
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
T35434*                                                                         
T35434*===============================================================*         
T35434 0150-CHECK-RESTART.                                              
T35434*===============================================================*         
T35434*                                                                         
T35434     MOVE 'PCSMT605'                       TO RF-NAME-PROGRAM.    
T35434     MOVE 1                                TO RF-PARTITION-NO.    
T35434     MOVE 1                                TO RF-DUP-CNTRL-NO.    
T35434     PERFORM 7200-SELECT-RESTART           THRU 7200-EXIT.        
T35434     IF WS-ACTIVE-RETURN-CODE              EQUAL SUCCESSFUL-CALL  
T35434        MOVE RF-RESTART-DATA-TEXT          TO WS-RESTART-DATA     
T35434        IF WS-RESTART-PROCESS-TYPE NUMERIC                        
T35434           SET WS-THIS-IS-A-RESTART TO TRUE                       
T35434        END-IF                                                    
T35434     END-IF.                                                      
T35434*                                                                         
T35434 0150-EXIT.                                                       
T35434      EXIT.                                                       
T35434*                                                                         
T35434*================================================================*        
T35434  0160-REPOSITION-FILE.                                           
T35434*================================================================*        
T35434                                                                  
T35434     PERFORM 8100-READ-METER-FILE THRU 8100-EXIT                  
T35434        UNTIL  WS-NBR-METER-RECS   = WS-RESTART-FIOMT20-REC-CNTR. 
T35434     DISPLAY '*******************************************'.       
T35434     DISPLAY '*****  THIS IS A RESTART OF PCSMT605  *****'.       
T35434     DISPLAY '*******************************************'.       
T35434     IF  WS-FMT20-METER-NO          = E-FMT20-METER-NO            
T35434     AND WS-FMT20-METER-SERIAL-NBR  = E-FMT20-SERIAL-NO           
T35434         DISPLAY '*** REPOSITION SUCCESSFULL ***'                 
T35434         MOVE WS-RESTART-GOOD-REC-CNTR TO WS-NBR-GOOD-RECS        
T35434         MOVE WS-RESTART-BAD-REC-CNTR  TO WS-NBR-BAD-RECS         
T35434         MOVE WS-RESTART-CHKP-SEQ-NO   TO WS-CHKP-SEQ-NO          
T35434     ELSE                                                         
T35434         DISPLAY '***    FAIL TO REPOSITIONING FILE     **'       
T35434         DISPLAY '**      ABEND IN PARAGRAPH 0160       **'       
T35434         PERFORM 9900-ABEND THRU 9900-EXIT                        
T35434     END-IF.                                                      
T35434                                                                  
T35434 0160-EXIT.                                                       
T35434     EXIT.                                                        
T35434*                                                                         
T35434*****************************************************************         
T35434* 0605-VALIDATE-RESTART-REQ                                               
T35434*****************************************************************         
T35434  COPY CPD00030.                                                          
T35434*****************************************************************         
T35434*                                                                         
      ****************************************************************          
      **                                                            **          
      **  0200-GET-PARM                                             **          
      **      READ CSS_JOB_PARM TO GET COMPANY_NO AND CRNT_LOC_NO   **          
      **      AND LOCAL OFFICE                                      **          
      ****************************************************************          
       0200-GET-PARM.                                                   
      *                                                                         
           MOVE WS-PGRMNAME            TO WS-PROGRAM.                   
           MOVE WS-PARM                TO WS-COMMAND.                   
           MOVE ZEROES                 TO WS-SEQUENCE.                  
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
      *                                                                         
           PERFORM 7600-START-FCSJC01            THRU 7600-EXIT.        
           PERFORM 7610-READ-FCSJC01             THRU 7610-EXIT.        
           PERFORM 0250-PROCESS-PARM             THRU 0250-EXIT.        
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0250-PROCESS-PARM                                         **          
      **                                                            **          
      ****************************************************************          
       0250-PROCESS-PARM.                                               
      *                                                                         
           SET WS-USE-12-CHAR-ATT      TO TRUE                          
           PERFORM UNTIL END-OF-SYSIPT                                  
             IF INPUT-ACTIVE                                            
                EVALUATE TRUE                                           
                  WHEN LOCAL-OFF-DATA                                   
                    MOVE LOCAL-OFF-VALUE TO WS-LOCAL-OFFICE             
                    SET LOC-OFF-GIVEN       TO TRUE                     
                    DISPLAY '**************************************'    
                    DISPLAY '**LOCAL OFFICE PARM RECEIVED      ****'    
                    DISPLAY '**LOCAL OFFICE :' WS-LOCAL-OFFICE          
                    DISPLAY '**************************************'    
                  WHEN ATT-NBR-XPND-DATA                                
                    DISPLAY '**************************************'    
                    DISPLAY '**PARM RCVD TO SET ATT-NBR LENGTH ****'    
                    IF ATT-NBR-09-CHAR                                  
                       SET WS-USE-09-CHAR-ATT TO TRUE                   
                       DISPLAY '**PGM INSERT 09 CHAR ATT-NBR INTO MA**' 
                       DISPLAY '**PGM INSERT 12 CHAR ATT-NBR INTO LX**' 
                    ELSE                                                
                       SET WS-USE-12-CHAR-ATT TO TRUE                   
                       DISPLAY '**PGM INSERT 12 CHAR ATT-NBR INTO MA**' 
                       DISPLAY '**PGM INSERT 12 CHAR ATT-NBR INTO LX**' 
                    END-IF                                              
                    DISPLAY '**************************************'    
                  WHEN OTHER                                            
                    DISPLAY '************************************'      
                    DISPLAY '**UNRECOGNIZED PARM IS ACTIVE     **'      
********            DISPLAY '**BUT PGM DISCARDED PARAMETER:    **'              
                    DISPLAY '** '                                       
                             WS-INPUT-DATA-BREAKDOWN(1:31)    '**'      
                    DISPLAY '************************************'      
                END-EVALUATE                                            
             END-IF                                                     
             PERFORM 7610-READ-FCSJC01     THRU  7610-EXIT              
           END-PERFORM.                                                 
      *                                                                         
       0250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0300-GET-HOW-CONN-VAL.                                           
      *================================================================*        
           MOVE ZERO TO WS-HOW-CONN-SUB                                 
           INITIALIZE WS-HOW-CONN-VAL-TAB                               
           MOVE 'HOW_ATTACHED_CD'      TO WS-COLUMN-NA                  
           MOVE 'CSS_METER_ATTCHMTS'   TO WS-TABLE-NA                   
           PERFORM 7800-OPEN-CODE-VALUE  THRU 7800-EXIT                 
           PERFORM 7820-FETCH-CODE-VALUE THRU 7820-EXIT                 
      *                                                                         
           PERFORM UNTIL SQLCODE EQUAL NOT-FOUND                        
              ADD +1  TO WS-HOW-CONN-SUB                                
              IF WS-HOW-CONN-SUB > 10                                   
                 DISPLAY '***ERROR: ARRAY OVERFLOW         ***'         
                 DISPLAY '***PARA:0300-GET-HOW-CONN-VAL    ***'         
                 DISPLAY '*** MORE THAN 10 CODE VALUES     ***'         
                 DISPLAY '*** COLUMN_NA:' WS-COLUMN-NA    ' **'         
                 DISPLAY '*** TABLE-NA :' WS-TABLE-NA     ' **'         
                 DISPLAY '*** COMPANY-NO:' WS-SYSIN-COMP-NO ' **'       
                 PERFORM 9900-ABEND            THRU 9900-EXIT           
              END-IF                                                    
      *                                                                         
              MOVE WS-CODE-VALUE(1:1)  TO                               
                              WS-TAB-HOW-CONN-VAL (WS-HOW-CONN-SUB)     
              PERFORM 7820-FETCH-CODE-VALUE  THRU 7820-EXIT             
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7840-CLOSE-CODE-VALUE THRU 7840-EXIT.                
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0400-GET-VER-CODE-VAL.                                           
      *================================================================*        
           MOVE ZERO TO WS-VER-CODE-SUB                                 
           INITIALIZE WS-VER-CODE-VAL-TAB                               
           MOVE 'VERSION_CD'           TO WS-COLUMN-NA                  
           MOVE 'CSS_EQUIP_ATTCHMTS'   TO WS-TABLE-NA                   
           PERFORM 7800-OPEN-CODE-VALUE  THRU 7800-EXIT                 
           PERFORM 7820-FETCH-CODE-VALUE THRU 7820-EXIT                 
      *                                                                         
           PERFORM UNTIL SQLCODE EQUAL NOT-FOUND                        
              ADD +1  TO WS-VER-CODE-SUB                                
              IF WS-VER-CODE-SUB > 50                                   
                 DISPLAY '***ERROR: ARRAY OVERFLOW         ***'         
                 DISPLAY '***PARA:0400-GET-VER-CODE-VAL    ***'         
                 DISPLAY '*** MORE THAN 50 CODE VALUES     ***'         
                 DISPLAY '*** COLUMN_NA:' WS-COLUMN-NA    ' **'         
                 DISPLAY '*** TABLE-NA :' WS-TABLE-NA     ' **'         
                 DISPLAY '*** COMPANY-NO:' WS-SYSIN-COMP-NO ' **'       
                 PERFORM 9900-ABEND            THRU 9900-EXIT           
              END-IF                                                    
      *                                                                         
              MOVE WS-CODE-VALUE(1:1)  TO                               
                             WS-TAB-UTL-CODE-VAL (WS-VER-CODE-SUB)      
              MOVE WS-CODE-VALUE(2:2)  TO                               
                             WS-TAB-ATT-CODE-VAL (WS-VER-CODE-SUB)      
              MOVE WS-CODE-VALUE(4:3)  TO                               
                             WS-TAB-VER-CODE-VAL (WS-VER-CODE-SUB)      
              PERFORM 7820-FETCH-CODE-VALUE  THRU 7820-EXIT             
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7840-CLOSE-CODE-VALUE THRU 7840-EXIT.                
      *                                                                         
       0400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1000-PROCESS-FILE                                         **          
      **      RECEIVE, EDIT, AND PROCESS INPUT                      **          
      **                                                            **          
      ****************************************************************          
       1000-PROCESS-FILE.                                               
      *                                                                         
           PERFORM 2000-EDIT-RECORD    THRU 2000-EXIT.                  
      *                                                                         
           IF GOOD-RECORD                                               
               PERFORM 8600-WRITE-GAS-TEST-FILE THRU 8600-EXIT          
               PERFORM 5000-UPDATE     THRU 5000-EXIT                   
               ADD 1                   TO WS-NBR-GOOD-RECS              
           ELSE                                                         
               MOVE WS-ERR-ARRAY-IDX   TO WS-ERROR-ARRAY-SIZE           
               PERFORM 6000-ERROR-ROUTINE        THRU 6000-EXIT         
                   VARYING WS-ERR-ARRAY-IDX FROM 1 BY 1                 
                       UNTIL WS-ERR-ARRAY-IDX > WS-ERROR-ARRAY-SIZE     
               ADD 1                   TO WS-NBR-BAD-RECS               
                                          WS-NO-ADDITION-MTRS           
           END-IF.                                                      
      *                                                                         
           IF GOOD-RECORD                                               
T35434         ADD 1                   TO WS-RESTART-COMMIT-COUNTER     
T35434*                                                                         
T35434         PERFORM 1800-PREPARE-PRECOMMIT  THRU 1800-EXIT           
T35434         IF WS-RESTART-COMMIT-COUNTER >= WS-CHKP-LUW-LIMIT        
T35434           AND WS-COMMITS-REQUIRE                                 
T35434             PERFORM 3000-COMMIT          THRU 3000-EXIT          
T35434             MOVE ZEROES         TO WS-RESTART-COMMIT-COUNTER     
T35434*                                                                         
T35434         END-IF                                                   
T35434     END-IF.                                                      
T35434*                                                                         
           PERFORM 8000-INITIALIZE               THRU 8000-EXIT.        
           PERFORM 8100-READ-METER-FILE          THRU 8100-EXIT.        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T35434*===============================================================*         
T35434 1800-PREPARE-PRECOMMIT.                                          
T35434*===============================================================*         
T35434*                                                                         
T35434      MOVE 1                     TO WS-RESTART-PROCESS-TYPE.      
T35434      SET WS-RERUN-PENDING       TO TRUE.                         
T35434      MOVE WS-NBR-METER-RECS     TO WS-RESTART-FIOMT20-REC-CNTR.  
T35434      MOVE WS-NBR-GOOD-RECS      TO WS-RESTART-GOOD-REC-CNTR.     
T35434      MOVE WS-NBR-BAD-RECS       TO WS-RESTART-BAD-REC-CNTR.      
T35434      MOVE E-FMT20-METER-NO      TO WS-FMT20-METER-NO.            
T35434      MOVE E-FMT20-SERIAL-NO     TO WS-FMT20-METER-SERIAL-NBR.    
T35434*                                                                         
T35434 1800-EXIT.                                                       
T35434      EXIT.                                                       
T35434*                                                                         
T35434*==============================================================*          
T35434 1900-PROCESS-SUCCESSFUL-JOB.                                     
T35434*==============================================================*          
T35434*--------------------------------------------------------------*          
T35434* THE FOLLOWING SETTINGS DECLARES SUCCESSFUL COMPLETION OF RUN *          
T35434* AND RESET RE-START CONTROLS IN CASE OF RE-START RUN          *          
T35434*--------------------------------------------------------------*          
T35434     MOVE SPACES                   TO WS-RESTART-JOB-COMPLETE     
T35434     IF  WS-THIS-IS-A-RESTART                                     
T35434         SET WS-RERUN-COMPLETED    TO TRUE                        
T35434     ELSE                                                         
T35434         SET WS-RUN-COMPLETED-NO-PROBLEMS                         
T35434                                   TO TRUE                        
T35434     END-IF.                                                      
T35434*                                                                         
T35434     PERFORM 3000-COMMIT               THRU 3000-EXIT.            
T35434*                                                                         
T35434     IF  WS-RESTART-REQ EQUAL WS-Y                                
T35434         PERFORM 8893-RESET-RESTART-REQ-PARM                      
T35434            THRU 8893-EXIT                                        
T35434     END-IF.                                                      
T35434*                                                                         
T35434 1900-EXIT.                                                       
T35434     EXIT.                                                        
T35434*                                                                         
      ****************************************************************          
      **                                                            **          
      **  2000-EDIT-RECORD                                          **          
      **      EDIT CHECK RECORD FIELDS. IF INVALID, WRITE TO ERROR  **          
      **                                                            **          
      ****************************************************************          
       2000-EDIT-RECORD.                                                
      *                                                                         
           MOVE E-FMT20-CODE-UTIL-TYPE   TO WS-CODE-UTIL-TYPE           
                                            EQ-CODE-UTIL-TYPE           
                                            GM-CODE-UTIL-TYPE           
                                            MA-CODE-UTIL-TYPE           
                                            LX-CODE-UTIL-TYPE           
                                            N5-CODE-UTIL-TYPE           
                                            W9-CODE-UTIL-TYPE           
                                            MC-CODE-UTIL-TYPE.          
      *                                                                         
           IF E-FMT20-METER-NO NOT NUMERIC                              
               PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
               MOVE 'METER NUMBER    ' TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
               MOVE 'NOT NUMERIC'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
           IF E-FMT20-SERIAL-NO EQUAL SPACES OR LOW-VALUES              
               PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
               MOVE 'SERIAL NUMBER   ' TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
               MOVE 'NOT PRESENT'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
*******    IF E-FMT20-ATTACH-TEST-CD > SPACES                                   
*******       MOVE E-FMT20-ATTACH-TEST-CD TO M3-TEST-SCHED-CD                   
*******       PERFORM 7010-SELECT-TEST-SCH  THRU 7010-EXIT                      
*******       IF SQLCODE EQUAL NOT-FOUND                                        
*******          PERFORM 2500-LOAD-ERROR-ARRAY THRU 2500-EXIT                   
*******          MOVE 'MTR TEST SCHEDULE'                                       
*******                                TO ERR-FIELD (WS-ERR-ARRAY-IDX)          
*******          MOVE 'NOT VALID'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)        
*******       END-IF                                                            
*******    ELSE                                                                 
*******       PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT                  
*******       MOVE 'MTR TEST SCHEDULE' TO ERR-FIELD  (WS-ERR-ARRAY-IDX)         
*******       MOVE 'NOT PRESENT'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)         
*******    END-IF                                                               
      *                                                                         
           MOVE WS-SYSIN-COMP-NO        TO W9-COMPANY-NO.               
           MOVE E-FMT20-MTR-FACILITY-CD TO WS-LOCAL-OFFICE.             
           PERFORM 7040-SELECT-MTR-STORGE-FAC THRU 7040-EXIT.           
           IF SQLCODE EQUAL NOT-FOUND                                   
               PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
               MOVE 'MTR FACILITY CD ' TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
               MOVE 'NOT VALID  '      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
           PERFORM 2200-EDIT-DATES               THRU 2200-EXIT.        
      *                                                                         
      *** ALL METERS MAY NOT HAVE ATTACHMENTS, SO SKIP ATTACHMENT AND           
      *** ITS VALIDATIONS WHEN ATT NBR/TYPE NOT PRESENT                         
           SET WS-NOT-ADD-ATTACHMENT   TO TRUE                          
           IF E-FMT20-ATTACH-NO > SPACES                                
              OR E-FMT20-ATTACH-TYPE > SPACES                           
              SET WS-ADD-ATTACHMENT    TO TRUE                          
              PERFORM 2100-VALIDATE-ATT-DTL  THRU 2100-EXIT             
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2100-VALIDATE-ATT-DTL.                                           
      *================================================================*        
      *                                                                         
           SET WS-ATT-TYPE-NOT-EXISTS  TO  TRUE                         
           IF E-FMT20-ATTACH-TYPE NOT EQUAL SPACES                      
              MOVE E-FMT20-ATTACH-TYPE TO N5-CODE-ATT-TYPE              
              PERFORM 7020-SELECT-ATTACHMENT-TYPE THRU 7020-EXIT        
              IF SQLCODE EQUAL SUCCESSFUL-CALL                          
                 SET WS-ATT-TYPE-EXISTS  TO  TRUE                       
              ELSE                                                      
               PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
               MOVE 'ATTACHMENT TYPE ' TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
               MOVE 'NOT VALID  '      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
              END-IF                                                    
           ELSE                                                         
               PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
               MOVE 'ATTACHMENT TYPE ' TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
               MOVE 'NOT PRESENT'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
           IF E-FMT20-ATTACH-NO IS NUMERIC                              
              IF WS-ATT-TYPE-EXISTS                                     
                 PERFORM 2110-VALIDATE-ATTACHMENT  THRU 2110-EXIT       
              END-IF                                                    
           ELSE                                                         
              PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT          
              MOVE 'ATTACHMENT NBR  '  TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
              MOVE 'NOT NUMERIC'       TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
      * METER WARRANTY PERIOD EDIT, SAME WARRANTY APPLIES TO ATTACHMENT         
           IF E-FMT20-ATTACH-WARRENTY NOT NUMERIC                       
               PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
               MOVE 'ATTACHMENT WAR  ' TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
               MOVE 'NOT NUMERIC'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
      ***  ATTACHMENT MANUFACTURER CODE (CODE ATT MAKE) VALIDATION              
           IF E-FMT20-ATTACH-MAKE > SPACES                              
              MOVE E-FMT20-ATTACH-MAKE TO M2-CODE-MAKE                  
              PERFORM 7030-SELECT-ATTACHMENT-MAKE THRU 7030-EXIT        
              IF SQLCODE EQUAL NOT-FOUND                                
                 PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT       
                 MOVE 'ATTACHMENT MFR CODE'                             
                                       TO ERR-FIELD  (WS-ERR-ARRAY-IDX) 
                 MOVE 'NOT VALID  '    TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
             END-IF                                                     
           ELSE                                                         
               PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
               MOVE 'ATTACHMENT MFR CODE'                               
                                       TO ERR-FIELD  (WS-ERR-ARRAY-IDX) 
               MOVE 'NOT PRESENT'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
      ***  ATTACHMENT TEST SCHEDULE VALIDATION                                  
           IF E-FMT20-ATTACH-TEST-CD > SPACES                           
              MOVE E-FMT20-ATTACH-TEST-CD TO M3-TEST-SCHED-CD           
              PERFORM 7010-SELECT-TEST-SCH  THRU 7010-EXIT              
              IF SQLCODE EQUAL NOT-FOUND                                
                 PERFORM 2500-LOAD-ERROR-ARRAY THRU 2500-EXIT           
                 MOVE 'ATT TEST SCHEDULE'                               
                                       TO ERR-FIELD (WS-ERR-ARRAY-IDX)  
                 MOVE 'NOT VALID'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
              END-IF                                                    
           ELSE                                                         
              PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT          
              MOVE 'ATT TEST SCHEDULE' TO ERR-FIELD  (WS-ERR-ARRAY-IDX) 
              MOVE 'NOT PRESENT'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX) 
           END-IF                                                       
      *                                                                         
      ***  AMR MODULE CONNECT TYPE (HOW-ATTACHED-CD) VALIDATION                 
           IF E-FMT20-ATTACH-CODE > SPACES                              
              SET WS-CODE-VAL-NOT-MATCHED TO TRUE                       
              PERFORM VARYING WS-CONN-INDX FROM 1 BY 1                  
                 UNTIL WS-CONN-INDX > WS-HOW-CONN-SUB                   
                  OR WS-CODE-VAL-MATCHED                                
                  OR WS-TAB-HOW-CONN-VAL (WS-CONN-INDX) = SPACES        
                 IF WS-TAB-HOW-CONN-VAL (WS-CONN-INDX)                  
                                      = E-FMT20-ATTACH-CODE             
                    SET WS-CODE-VAL-MATCHED TO TRUE                     
                 END-IF                                                 
              END-PERFORM                                               
              IF WS-CODE-VAL-NOT-MATCHED                                
                 PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT       
                 MOVE 'ATT CONNECTION TYPE'                             
                                       TO ERR-FIELD (WS-ERR-ARRAY-IDX)  
                 MOVE 'NOT VALID'    TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)  
              END-IF                                                    
           ELSE                                                         
              PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT          
              MOVE 'ATT CONNECTION TYPE'                                
                                      TO ERR-FIELD   (WS-ERR-ARRAY-IDX) 
              MOVE 'NOT PRESENT'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX) 
           END-IF.                                                      
      *                                                                         
      ***  ATTACHMENT VERSION CODE VALIDATION                                   
           IF E-FMT20-ATTACH-VERSION > SPACES                           
              SET WS-CODE-VAL-NOT-MATCHED TO TRUE                       
              PERFORM VARYING WS-VER-INDX FROM 1 BY 1                   
                 UNTIL WS-VER-INDX > WS-VER-CODE-SUB                    
                  OR WS-CODE-VAL-MATCHED                                
                  OR WS-TAB-UTL-CODE-VAL (WS-VER-INDX) = SPACES         
                 IF WS-TAB-UTL-CODE-VAL (WS-VER-INDX)                   
                                      = WS-G                            
                  AND WS-TAB-ATT-CODE-VAL (WS-VER-INDX)                 
                                      = E-FMT20-ATTACH-TYPE             
                  AND WS-TAB-VER-CODE-VAL (WS-VER-INDX)                 
                                      = E-FMT20-ATTACH-VERSION          
                    SET WS-CODE-VAL-MATCHED TO TRUE                     
                 END-IF                                                 
              END-PERFORM                                               
              IF WS-CODE-VAL-NOT-MATCHED                                
                 PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT       
                 MOVE 'ATTACHMENT VER CD'                               
                                       TO ERR-FIELD (WS-ERR-ARRAY-IDX)  
                 MOVE 'NOT VALID'    TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)  
              END-IF                                                    
           ELSE                                                         
              PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT          
              MOVE 'ATTACHMENT VER CD' TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
              MOVE 'NOT PRESENT'       TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2110-VALIDATE-ATTACHMENT.                                        
      *================================================================*        
      * ATTACHMENT NBR IS VALIDATED AGAINST EQUIP_ATTCHMTS AND         *        
      * METER_ATTCHMTS TABLE BASED ON UNIQUE-ATT-ID-CD OF ATTACHMENT   *        
      * TYPE. BELOW ARE THE RULES OF UNIQUE-ATT-ID-CD                  *        
      *                                                                *        
      ***   U     - UNIQUE WITHIN A UTIL-TYPE ACROSS COMPANIES         *        
      ***   S     - UNIQUE WITHIN THE SYSTEM                           *        
      ***   C     - UNIQUE WITHIN COMPANY ACROSS UTIL-TYPES            *        
      ***   A     - UNIQUE WITHIN A UTIL-TYPE WITHIN A COMPANY         *        
      ***   OTHER - SAME AS 'A'                                        *        
      *----------------------------------------------------------------*        
           SET WS-VALID-ATTACHMENT  TO TRUE                             
      *** USE METER_ATTCHMTS TABLE TO VALIDATE ATTACHMENT NBR                   
           IF WS-USE-09-CHAR-ATT                                        
              MOVE SPACES                 TO MA-DEVICE-NO               
              MOVE E-FMT20-ATTACH-NO(4:)  TO MA-DEVICE-NO               
           ELSE                                                         
              MOVE E-FMT20-ATTACH-NO      TO MA-DEVICE-NO               
           END-IF.                                                      
           MOVE E-FMT20-ATTACH-TYPE       TO MA-CODE-ATT-TYPE           
           PERFORM 7130-OPEN-METER-ATTCHMTS  THRU 7130-EXIT             
           PERFORM 7140-FETCH-METER-ATTCHMTS THRU 7140-EXIT             
      *                                                                         
           PERFORM UNTIL SQLCODE EQUAL NOT-FOUND                        
                           OR WS-NOT-VALID-ATTACHMENT                   
              PERFORM 2120-APPLY-UNIQUE-RULES  THRU 2120-EXIT           
      *                                                                         
              IF WS-VALID-ATTACHMENT                                    
                 PERFORM 7140-FETCH-METER-ATTCHMTS THRU 7140-EXIT       
              END-IF                                                    
      *                                                                         
           END-PERFORM                                                  
      *                                                                         
           PERFORM 7150-CLOSE-METER-ATTCHMTS THRU 7150-EXIT             
      *                                                                         
           IF WS-NOT-VALID-ATTACHMENT                                   
              PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT          
              MOVE 'ATTACHMENT NBR  '  TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
              MOVE 'ATTACHED TO MTR#'                                   
                                   TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)    
              MOVE WS-DB-METER-NO                                       
                               TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)(17:9)  
              GO TO 2110-EXIT                                           
           END-IF.                                                      
      *                                                                         
      *** USE EQUIP_ATTCHMTS TABLE TO VALIDATE ATTACHMENT NBR                   
           MOVE E-FMT20-ATTACH-NO         TO LX-DEVICE-NO               
           MOVE E-FMT20-ATTACH-TYPE       TO LX-CODE-ATT-TYPE           
A01209     SET  EQUIP-ATTCHMT-NOT-EXISTS  TO TRUE                       
           PERFORM 7100-OPEN-EQUIP-ATTCHMTS  THRU 7100-EXIT             
           PERFORM 7110-FETCH-EQUIP-ATTCHMTS THRU 7110-EXIT             
      *                                                                         
           PERFORM UNTIL SQLCODE EQUAL NOT-FOUND                        
                           OR WS-NOT-VALID-ATTACHMENT                   
              PERFORM 2120-APPLY-UNIQUE-RULES  THRU 2120-EXIT           
A01209*                                                                         
A01209        IF WS-DB-CODE-UTIL-TYPE = WS-G  AND                       
A01209           WS-DB-COMPANY-NO     = WS-SYSIN-COMP-NO                
A01209           SET EQUIP-ATTCHMT-ALREADY-EXISTS  TO  TRUE             
A01209           SET WS-VALID-ATTACHMENT           TO  TRUE             
A01209        END-IF                                                    
      *                                                                         
              IF WS-VALID-ATTACHMENT                                    
                 PERFORM 7110-FETCH-EQUIP-ATTCHMTS THRU 7110-EXIT       
              END-IF                                                    
      *                                                                         
           END-PERFORM                                                  
      *                                                                         
           PERFORM 7120-CLOSE-EQUIP-ATTCHMTS THRU 7120-EXIT             
      *                                                                         
           IF WS-NOT-VALID-ATTACHMENT                                   
              PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT          
              MOVE 'ATTACHMENT NBR  '  TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
              MOVE 'ALREADY AT INVENTORY'                               
                                       TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
A01209*                                                                         
A01209     IF EQUIP-ATTCHMT-ALREADY-EXISTS                              
A01209        INITIALIZE             WS-MP-DATE-MOVE                    
A01209                               WS-MP-MTR-STORAGE-FAC-CD           
A01209                               WS-MP-EQUIP-LOC-ID                 
A01209        MOVE E-FMT20-ATTACH-NO      TO LX-DEVICE-NO               
A01209        MOVE E-FMT20-ATTACH-TYPE    TO LX-CODE-ATT-TYPE           
A01209        MOVE WS-SYSIN-COMP-NO       TO LX-COMPANY-NO              
A01209        PERFORM 7300-SELECT-EQUIP-ATTCHMT  THRU  7300-EXIT        
A01209        IF WS-MP-EQUIP-LOC-ID = 'K'                               
A01209           PERFORM 2500-LOAD-ERROR-ARRAY THRU 2500-EXIT           
A01209           MOVE 'ATTACHMENT NBR  ' TO ERR-FIELD (WS-ERR-ARRAY-IDX)
A01209           MOVE 'DEVICE # '                                       
A01209                       TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)          
A01209           MOVE LX-DEVICE-NO                                      
A01209                       TO ERR-PROBLEM (WS-ERR-ARRAY-IDX) (10:12)  
A01209           MOVE ' EXISTS WITH DIFF METER'                         
A01209                       TO ERR-PROBLEM (WS-ERR-ARRAY-IDX) (22:23)  
A01209        END-IF                                                    
A01209     END-IF.                                                      
      *                                                                         
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2120-APPLY-UNIQUE-RULES.                                         
      *================================================================*        
      *                                                                         
           EVALUATE N5-UNIQUE-ATT-ID-CD                                 
              WHEN 'A'                                                  
                 IF WS-DB-COMPANY-NO = WS-SYSIN-COMP-NO                 
                    AND WS-DB-CODE-UTIL-TYPE = WS-G                     
                    SET WS-NOT-VALID-ATTACHMENT TO TRUE                 
                 END-IF                                                 
              WHEN 'C'                                                  
                 IF WS-DB-COMPANY-NO = WS-SYSIN-COMP-NO                 
                    SET WS-NOT-VALID-ATTACHMENT TO TRUE                 
                 END-IF                                                 
              WHEN 'S'                                                  
                 SET WS-NOT-VALID-ATTACHMENT TO TRUE                    
              WHEN 'U'                                                  
                 IF WS-DB-CODE-UTIL-TYPE = WS-G                         
                    SET WS-NOT-VALID-ATTACHMENT TO TRUE                 
                 END-IF                                                 
              WHEN OTHER                                                
                 IF WS-DB-COMPANY-NO = WS-SYSIN-COMP-NO                 
                    AND WS-DB-CODE-UTIL-TYPE = WS-G                     
                    SET WS-NOT-VALID-ATTACHMENT TO TRUE                 
                 END-IF                                                 
           END-EVALUATE.                                                
      *                                                                         
       2120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 2200-EDIT-DATES                                                         
      * VALIDATE PURCHASE DATE & CALCULATE WARRANTY END DATE BY                 
      * ADDING  WARRANTY MONTHS TO PURCHASE DATE                                
      ****************************************************************          
       2200-EDIT-DATES.                                                 
      *                                                                         
           INITIALIZE WS-DB2-DATE-CCYY-MM-DD.                           
           MOVE E-FMT20-PURCHASE-DATE (1:2) TO WS-DB2-DATE-CC.          
           MOVE E-FMT20-PURCHASE-DATE (3:2) TO WS-DB2-DATE-YY.          
           MOVE E-FMT20-PURCHASE-DATE (6:2) TO WS-DB2-DATE-MM.          
           MOVE E-FMT20-PURCHASE-DATE (9:2) TO WS-DB2-DATE-DD.          
      *                                                                         
           MOVE WS-DB2-DATE-CCYY-MM-DD TO WS-WARRANTY-DATE.             
           MOVE E-FMT20-ATTACH-WARRENTY TO WS-WARRANTY-MTHS.            
      *                                                                         
           PERFORM 5200-SELECT-WARRANTY-DATE   THRU 5200-EXIT.          
      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE        TO WS-DISPLAY-RC                      
              DISPLAY '***************PCSMT605***************'          
              DISPLAY '* WARNING: PURCHASE DATE IS NOT VALID*'          
              DISPLAY '* ERROR IN:2200-EDIT-DATES           *'          
              DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
              DISPLAY '* PURCHASE DATE : ' E-FMT20-PURCHASE-DATE        
              DISPLAY '* WARRANTY DAYS : ' E-FMT20-ATTACH-WARRENTY      
              PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT          
              MOVE 'PURCHASE DATE '   TO ERR-FIELD   (WS-ERR-ARRAY-IDX) 
              MOVE 'INVALID DATE'     TO ERR-PROBLEM (WS-ERR-ARRAY-IDX) 
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  2500-LOAD-ERROR-ARRAY                                     **          
      **                                                            **          
      ****************************************************************          
       2500-LOAD-ERROR-ARRAY.                                           
      *                                                                         
           MOVE 'Y'                    TO WS-RECORD-FLAG.               
           ADD 1                       TO WS-ERR-ARRAY-IDX.             
           MOVE E-FMT20-METER-TYPE     TO ERR-MTR-SIZE                  
                                                     (WS-ERR-ARRAY-IDX).
           MOVE E-FMT20-METER-NO       TO ERR-METER-NBR                 
                                                     (WS-ERR-ARRAY-IDX).
           MOVE E-FMT20-SERIAL-NO      TO ERR-SERIAL-NBR                
                                                     (WS-ERR-ARRAY-IDX).
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  2600-EDIT-DRIVE-OPTIONS.                                  **          
      **                                                            **          
      ****************************************************************          
       2600-EDIT-DRIVE-OPTIONS.                                         
      *                                                                         
*******    DISPLAY '2600-EDIT-DRIVE-OPTIONS'.                                   
      *                                                                         
           IF M5-DRIVE-OPTIONS = SPACES                                 
               MOVE ZEROS              TO WS-DRIVE-OPTIONS-N            
               GO TO 2600-EXIT                                          
           END-IF.                                                      
                                                                        
           MOVE ZERO TO WS-INSPECT-CNTR.                                
           INSPECT M5-DRIVE-OPTIONS TALLYING WS-INSPECT-CNTR            
                                             FOR ALL ','.               
           IF WS-INSPECT-CNTR = 0                                       
               INSPECT M5-DRIVE-OPTIONS TALLYING WS-INSPECT-CNTR        
                                   FOR CHARACTERS BEFORE INITIAL ' '    
               MOVE M5-DRIVE-OPTIONS(1:WS-INSPECT-CNTR)                 
                                       TO WS-DRIVE-OPTIONS-N            
           ELSE                                                         
               MOVE ZEROS              TO WS-DRIVE-OPTIONS-N            
           END-IF.                                                      
           MOVE WS-DRIVE-OPTIONS-N TO WS-DRIVE-COMP.                    
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T35434*================================================================*        
T35434 3000-COMMIT.                                                     
T35434*================================================================*        
T35434*                                                                         
T35434     PERFORM 8800-WRITE-RESTART         THRU 8800-EXIT            
T35434*                                                                         
T35434     EXEC SQL                                                     
T35434          COMMIT                                                  
T35434     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35434*                                                                         
T35434     DISPLAY 'COMMIT-POINT #'  WS-CHKP-SEQ-NO 'TAKEN.'.           
T35434     DISPLAY 'COMMITTED UPTO =  MTR|SERIAL NO: '                  
T35434              E-FMT20-METER-NO '|' E-FMT20-SERIAL-NO.             
T35434*                                                                         
T35434 3000-EXIT.                                                       
T35434      EXIT.                                                       
T35434*                                                                         
      ****************************************************************          
      **                                                            **          
      **  5000-UPDATE                                               **          
      **      SETUP AND INSERT CSS_EQUIPMENT, CSS_ELEC_METER,       **          
      **                       CSS_MTR_CAP                          **          
      ****************************************************************          
       5000-UPDATE.                                                     
      *                                                                         
*******    DISPLAY '5000-UPDATE'.                                               
      *                                                                         
      ***  SETUP EQUIPMENT TABLE AND INSERT                                     
      *                                                                         
           MOVE E-FMT20-METER-NO         TO EQ-DEVICE-NO                
                                            GM-METER-NO                 
                                            MA-METER-NO                 
                                            MC-METER-NO.                
      *                                                                         
T12999     MOVE WS-SYSIN-COMP-NO         TO EQ-COMPANY-NO.              
           MOVE E-FMT20-SERIAL-NO        TO EQ-SERIAL-NO.               
           MOVE E-FMT20-MTR-FACILITY-CD  TO EQ-LOCAL-OFFICE.            
      *                                                                         
           MOVE E-FMT20-METER-TYPE       TO GM-METER-SIZE-ID            
                                            M5-METER-SIZE-ID.           
T12999     MOVE WS-SYSIN-COMP-NO         TO M5-COMPANY-NO.              
           PERFORM 7000-SELECT-GAS-METER-SIZE THRU 7000-EXIT.           
           IF METER-SIZE-FOUND                                          
               MOVE M5-CODE-MAKE         TO EQ-CODE-MAKE                
               PERFORM 2600-EDIT-DRIVE-OPTIONS THRU 2600-EXIT           
           ELSE                                                         
               MOVE SPACES               TO EQ-CODE-MAKE                
           END-IF.                                                      
      *                                                                         
ACT180     MOVE WS-INVENTORY           TO EQ-CODE-CRNT-LOC              
           MOVE ZEROES                 TO EQ-CRNT-LOC-NO.               
           MOVE WS-M                   TO EQ-EQUIP-TYPE-CD.             
           MOVE SPACE                  TO EQ-PALETTE-NO.                
           MOVE SPACE                  TO EQ-INSTALL-EMP-ID.            
           MOVE SPACE                  TO EQ-UPGRADES-TX.               
           MOVE SPACE                  TO EQ-HAZARD-MATERIAL-CD.        
           MOVE E-FMT20-PURCHASE-DATE  TO EQ-DATE-PURCHASED.            
           SET DATE-PURCHASED-NOT-NULL TO TRUE.                         
           MOVE SPACES                 TO EQ-MFR-DT.                    
           SET MFR-DATE-NULL           TO TRUE.                         
           MOVE SPACE                  TO EQ-DATE-OBSOLETE.             
           SET DATE-OBSOLETE-NULL      TO TRUE.                         
           MOVE SPACE                  TO EQ-INSTALL-DT.                
           SET INSTALL-DT-NULL         TO TRUE.                         
           MOVE SPACE                  TO EQ-DATE-DISPOSED-OF.          
           SET DATE-DISPOSED-NULL      TO TRUE.                         
           MOVE WS-DB2-TODAYS-DATE     TO EQ-DATE-LAST-TRAN             
                                          EQ-DATE-LAST-MOVE.            
           SET DATE-LAST-TRAN-NOT-NULL TO TRUE.                         
           SET DATE-LAST-MOVE-NOT-NULL TO TRUE.                         
      *                                                                         
           SET WARRANTY-DATE-NOT-NULL  TO TRUE.                         
           COMPUTE WS-WARRANTY-YEAR = WS-SYS-DATE-YY + 1.               
           IF WS-WARRANTY-YEAR GREATER THAN 50                          
               MOVE 19                 TO WS-TEMP1-CC                   
           ELSE                                                         
               MOVE 20                 TO WS-TEMP1-CC                   
           END-IF.                                                      
           STRING WS-TEMP1-CC,                                          
                  WS-WARRANTY-YEAR,                                     
                  '-',                                                  
                  WS-SYS-DATE-MM,                                       
                  '-',                                                  
                  WS-SYS-DATE-DD                                        
                               DELIMITED BY SIZE                        
                                     INTO EQ-WARRANTY-EXP-DT            
           END-STRING.                                                  
      *                                                                         
           PERFORM 7900-INSERT-EQUIPMENT         THRU 7900-EXIT.        
           IF  SQLCODE EQUAL -803                                       
               PERFORM 5100-CREATE-WORK-QUEUE THRU 5100-EXIT            
A04860         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
A04860            COMPUTE WS-NBR-GOOD-RECS = WS-NBR-GOOD-RECS - 1       
A04860            ADD 1                   TO WS-NBR-BAD-RECS            
A04860            GO TO 5000-EXIT                                       
A04860         END-IF                                                   
           END-IF.                                                      
      *                                                                         
      ***  SETUP CSS_GAS_METER AND INSERT                                       
      *                                                                         
T12999     MOVE WS-SYSIN-COMP-NO           TO GM-COMPANY-NO.            
           MOVE WS-M                       TO GM-DEVICE-TYPE-CD.        
           MOVE 'XX '                      TO GM-DIGTL-MTR-TYPE.        
           IF E-FMT20-ATTACH-TYPE = 'IT'                                
               MOVE '00'                   TO GM-PROGRAM-ID             
           ELSE                                                         
               MOVE '01'                   TO GM-PROGRAM-ID             
           END-IF.                                                      
           MOVE ZERO                       TO GM-CODE-TIME-PERIOD       
                                              GM-MCF-CAP-PER-HR         
                                              GM-CASE-PRESSURE.         
           MOVE SPACE                      TO GM-CODE-CAP-CFF           
                                              GM-CODE-CAP-UCG           
                                              GM-CODE-CAP-GAL           
                                              GM-CODE-CASE-TYPE.        
           MOVE WS-N                       TO WS-ATT-TEMP-COMP          
                                              WS-ATT-PAPER-DISK.        
           MOVE WS-CODES-GAS-ATT-DATA-PRESENT                           
                                           TO GM-CODE-ATTACHMENTS.      
           MOVE SPACES                     TO GM-LAST-TEST-SEL-CD       
                                              GM-LAST-TEST-SEL-DT.      
           SET LAST-TEST-SEL-DT-NULL       TO TRUE.                     
           MOVE SPACES                     TO GM-DATE-LAST-TESTED.      
           SET DATE-LAST-TESTED-NULL       TO TRUE.                     
           IF METER-SIZE-FOUND                                          
             MOVE M5-TEST-SCHED-CD           TO GM-TEST-SCHED-CD        
             MOVE M5-CODE-METER-TYPE         TO GM-CODE-METER-TYPE      
             MOVE M5-MODEL-CD                TO GM-MODEL-CD             
             MOVE M5-CODE-CO-SIZE            TO GM-CODE-CO-SIZE         
             MOVE M5-CCF-CAP-PER-HR          TO GM-CCF-CAP-PER-HR       
             MOVE M5-ALLOW-CONSTANT-FL       TO GM-ALLOW-CONSTANT-FL    
             MOVE M5-CONNECTION-TYPE-CD      TO GM-CONNECTION-TYPE-CD   
             MOVE WS-DRIVE-COMP              TO GM-NUMBER-OF-DRIVE      
           ELSE                                                         
             MOVE SPACES                     TO GM-TEST-SCHED-CD        
                                                GM-CODE-METER-TYPE      
                                                GM-MODEL-CD             
                                                GM-ALLOW-CONSTANT-FL    
                                                GM-CONNECTION-TYPE-CD   
             MOVE ZEROS                      TO GM-CODE-CO-SIZE         
                                                GM-CCF-CAP-PER-HR       
                                                GM-NUMBER-OF-DRIVE      
           END-IF.                                                      
      *                                                                         
           PERFORM 7910-INSERT-GAS-METER   THRU 7910-EXIT.              
      *                                                                         
      ***  SETUP METER CAPABILITY TABLE AND INSERT                              
      *                                                                         
T12999     MOVE WS-SYSIN-COMP-NO           TO MC-COMPANY-NO.            
           MOVE 'A'                        TO MC-CODE-CAP-TYPE.         
           MOVE ZERO                       TO MC-FULL-SCALE.            
           MOVE WS-ONE                     TO MC-CONSTANT               
                                              MC-REG-ID-NO.             
           MOVE SPACES                     TO MC-DEMAND-TYPE            
                                              MC-REG-MEASURES-CD        
                                              MC-K-Q-LEAD-LAG-IND       
                                              MC-CODE-HIGH-LOW-DIAL.    
           MOVE M5-NO-DIALS                TO MC-NO-DIALS               
                                              MC-NO-READ-DIALS.         
      *                                                                         
           PERFORM 7920-INSERT-MTR-CAP     THRU 7920-EXIT.              
      *                                                                         
           IF WS-ADD-ATTACHMENT                                         
      ***     BUILD AND INSERT EQUIP ATTCHMTS TABLE                             
A01209        IF EQUIP-ATTCHMT-ALREADY-EXISTS                           
A01209           MOVE E-FMT20-ATTACH-NO       TO LX-DEVICE-NO           
A01209                                           MP-DEVICE-NO           
A01209           MOVE E-FMT20-ATTACH-TYPE     TO LX-CODE-ATT-TYPE       
A01209                                           MP-CODE-ATT-TYPE       
A01209           MOVE WS-SYSIN-COMP-NO        TO LX-COMPANY-NO          
A01209                                           MP-COMPANY-NO          
A01209           MOVE E-FMT20-CODE-UTIL-TYPE  TO LX-CODE-UTIL-TYPE      
A01209                                           MP-CODE-UTIL-TYPE      
A01209           MOVE E-FMT20-METER-NO        TO MP-METER-NO            
A01209           MOVE WS-MP-DATE-MOVE         TO MP-DATE-MOVE           
A01209           MOVE WS-MP-MTR-STORAGE-FAC-CD TO MP-MTR-STORAGE-FAC-CD 
A01209           MOVE WS-MP-EQUIP-LOC-ID      TO MP-EQUIP-LOC-ID        
A01209           MOVE SPACES                  TO MP-REASON-REMOVED-CD   
A01209           PERFORM 8700-INSERT-EQUIP-ATT-MOVE THRU 8700-EXIT      
A01209           MOVE E-FMT20-MTR-FACILITY-CD TO LX-MTR-STORAGE-FAC-CD  
A01209           MOVE 'K'                     TO LX-EQUIP-LOC-ID        
A01209           PERFORM 8710-UPDATE-EQUIP-ATTCHMTS THRU 8710-EXIT      
A01209        ELSE                                                      
A01209           PERFORM 5300-SETUP-LX-ROWS        THRU 5300-EXIT       
A01209        END-IF                                                    
      *                                                                         
      ***     BUILD AND INSERT METER ATTCHMTS TABLE                             
              PERFORM 5400-SETUP-MA-ROWS        THRU 5400-EXIT          
           END-IF.                                                      
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A04860******************************************************************        
A04860*   CREATE WORK QUEUE FOR DUPLICATE METERS                       *        
A04860******************************************************************        
A04860 5100-CREATE-WORK-QUEUE.                                          
A04860*                                                                         
A04860     INITIALIZE CWS00077-FIELDS.                                  
A04860     MOVE ZERO                     TO WS-ITEM-ID.                 
A04860     MOVE WS-ITEM-ID               TO WS-77-ITEM-ID.              
A04860     MOVE ZERO                     TO WS-77-SERV-ORDER-NO.        
A04860     MOVE 143                      TO WS-77-CATEGORY-ID.          
A04860     MOVE ZERO                     TO WS-77-ACCOUNT-NO            
A04860                                      WS-77-PREMISE-NO            
A04860                                      WS-77-CUSTOMER-NO.          
A04860     MOVE 'SYSTEM '                TO WS-77-USER-ID-ORIG.         
A04860     MOVE SPACES                   TO WS-77-RESP-AREA-ID          
A04860                                      WS-77-LOCAL-OFFICE.         
A04860     MOVE ZERO                     TO WS-77-FREE-FORM-LEN.        
A04860     MOVE LOW-VALUES               TO WS-77-FREE-FORM-TXT.        
A04860     MOVE 4                        TO WS-77-ROUTE-CATEGORY.       
A04860     MOVE 'N'                      TO WS-77-PRIORITY.             
A04860     MOVE EQ-DEVICE-NO             TO WS-WQ-METER-NO.             
A04860     MOVE WS-WQ-COMMENTS           TO WS-77-COMMENTS.             
A04860     MOVE WS-PGRMNAME              TO WS-77-CREATED-BY.           
A04860*                                                                         
A04860     PERFORM 7950-INSERT-WORK-QUEUE-ITEM THRU 7950-EXIT.          
A04860*                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * DUMMY SELECT ON CSS_MDEL_SQL TO ADD PURCHASE DATE AND         *         
      * WARRANTY PERIOD TO OBTAIN THE WARRANTY DATE                   *         
      *****************************************************************         
       5200-SELECT-WARRANTY-DATE.                                       
      *                                                                         
           EXEC SQL                                                     
             SELECT
              DATEADD( MONTH, :WS-WARRANTY-MTHS, IIF(TRY_CONVERT(DATE, 
                                                      :WS-WARRANTY-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WARRANTY-DATE
              ) <> 0) OR (LEN(:WS-WARRANTY-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-WARRANTY-DATE
              ), CONVERT(DATE, :WS-WARRANTY-DATE) ) )
            INTO
              :WS-WARRANTY-DATE     
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-WARRANTY-DATE =                                            
MFA-TR*          DATE(:WS-WARRANTY-DATE) + :WS-WARRANTY-MTHS MONTHS             
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                         
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***  SETUP EQUIP ATTCHMTS TABLE AND INSERT                                
      *================================================================*        
       5300-SETUP-LX-ROWS.                                              
      *================================================================*        
      *                                                                         
           MOVE WS-SYSIN-COMP-NO           TO LX-COMPANY-NO.            
           MOVE E-FMT20-ATTACH-NO          TO LX-DEVICE-NO.             
           MOVE E-FMT20-ATTACH-TYPE        TO LX-CODE-ATT-TYPE.         
           MOVE E-FMT20-ATTACH-MAKE        TO LX-CODE-MAKE.             
           MOVE E-FMT20-ATTACH-VERSION     TO LX-VERSION-CD.            
           MOVE E-FMT20-ATTACH-TEST-CD     TO LX-TEST-SCHED-CD.         
           MOVE E-FMT20-MTR-FACILITY-CD    TO LX-MTR-STORAGE-FAC-CD.    
           MOVE 'K'                        TO LX-EQUIP-LOC-ID.          
           MOVE E-FMT20-PURCHASE-DATE      TO LX-DATE-PURCHASED.        
           SET DATE-PURCHASED-NOT-NULL     TO TRUE.                     
           MOVE WS-DB2-TODAYS-DATE         TO LX-DATE-LAST-TRAN         
                                              LX-EQUIP-ATTACH-DT.       
           SET ATTACH-DT-NOT-NULL          TO TRUE.                     
           SET DATE-LAST-TRAN-NOT-NULL     TO TRUE.                     
           MOVE SPACES                     TO LX-DATE-LAST-MOVE         
                                              LX-DATE-LAST-TESTED       
                                              LX-DATE-OBSOLETE          
                                              LX-DATE-DISPOSED-OF.      
           SET DATE-LAST-MOVE-NULL         TO TRUE.                     
           SET DATE-LAST-TESTED-NULL       TO TRUE.                     
           SET DATE-OBSOLETE-NULL          TO TRUE.                     
           SET DATE-DISPOSED-NULL          TO TRUE.                     
           MOVE WS-WARRANTY-DATE           TO LX-WARRANTY-EXP-DT.       
           SET WARRANTY-DATE-NOT-NULL      TO TRUE.                     
           PERFORM 7940-INSERT-EQUIP-ATTCHMTS  THRU 7940-EXIT.          
      *                                                                         
       5300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***  SETUP METER ATTACHMENT TABLE AND INSERT                              
      *================================================================*        
       5400-SETUP-MA-ROWS.                                              
      *================================================================*        
      *                                                                         
           MOVE WS-SYSIN-COMP-NO           TO MA-COMPANY-NO.            
           MOVE 'M'                        TO MA-CODE-DEVICE-TYPE.      
           IF WS-USE-09-CHAR-ATT                                        
              MOVE SPACES                     TO MA-DEVICE-NO           
              MOVE E-FMT20-ATTACH-NO(4:)      TO MA-DEVICE-NO           
           ELSE                                                         
              MOVE E-FMT20-ATTACH-NO          TO MA-DEVICE-NO           
           END-IF.                                                      
           MOVE E-FMT20-ATTACH-MAKE        TO MA-CODE-MAKE.             
           MOVE E-FMT20-ATTACH-TYPE        TO MA-CODE-ATT-TYPE.         
           MOVE ZERO                       TO MA-CT-PT-RATIO.           
           MOVE E-FMT20-ATTACH-TEST-CD     TO MA-TEST-SCHED-CD.         
           MOVE E-FMT20-ATTACH-CODE        TO MA-HOW-ATTACHED-CD.       
           MOVE SPACES                     TO MA-DATE-LAST-TESTED.      
           SET DATE-LAST-TESTED-NULL       TO TRUE.                     
           PERFORM 7930-INSERT-MTR-ATTACH  THRU 7930-EXIT.              
      *                                                                         
       5400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  6000-ERROR-ROUTINE                                        **          
      **                                                            **          
      ****************************************************************          
       6000-ERROR-ROUTINE.                                              
      *                                                                         
           MOVE ERR-MTR-SIZE  (WS-ERR-ARRAY-IDX)                        
                                       TO WS-RPT-MTR-SIZE.              
           MOVE ERR-METER-NBR (WS-ERR-ARRAY-IDX)                        
                                       TO WS-RPT-METER-NO.              
           MOVE ERR-FIELD     (WS-ERR-ARRAY-IDX)                        
                                       TO WS-RPT-ERROR-FIELD.           
           MOVE ERR-PROBLEM   (WS-ERR-ARRAY-IDX)                        
                                       TO WS-RPT-PROBLEM-DESC.          
           MOVE ERR-SERIAL-NBR (WS-ERR-ARRAY-IDX)                       
                                       TO WS-RPT-SERIAL-NO.             
      *                                                                         
           PERFORM 8200-WRITE-PRINTER-RECORD     THRU 8200-EXIT.        
      *                                                                         
       6000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T35434*===============================================================*         
T35434* *6235-GET-FJC01-RESTART-REQ.                                            
T35434*===============================================================*         
T35434     EXEC SQL                                                             
T35434         INCLUDE CPD00035                                                 
T35434     END-EXEC.                                                            
T35434*===============================================================*         
T35434*  6253-GET-FJC01-CHKP-LIMIT                                              
T35434*===============================================================*         
T35434       EXEC SQL                                                           
T35434          INCLUDE CPD00034                                                
T35434       END-EXEC.                                                          
      ******************************************************************        
      ** GET THE GAS METER SIZE FROM CSS_GAS_METER_SIZE               **        
      ******************************************************************        
       7000-SELECT-GAS-METER-SIZE.                                      
      *                                                                         
           MOVE 'N' TO WS-MTR-SIZE-FOUND.                               
           EXEC SQL                                                     
               SELECT  TEST_SCHED_CD                                    
                      ,REMOTE_READ_CODE                                 
                      ,DRIVE_OPTIONS                                    
                      ,CONNECTION_TYPE_CD                               
                      ,ALLOW_CONSTANT_FL                                
                      ,CCF_CAP_PER_HR                                   
                      ,CODE_METER_TYPE                                  
                      ,CODE_MAKE                                        
                      ,NO_DIALS                                         
                      ,COMPANY_NO                                       
                 INTO  :M5-TEST-SCHED-CD                                
                      ,:M5-REMOTE-READ-CODE                             
                      ,:M5-DRIVE-OPTIONS                                
                      ,:M5-CONNECTION-TYPE-CD                           
                      ,:M5-ALLOW-CONSTANT-FL                            
                      ,:M5-CCF-CAP-PER-HR                               
                      ,:M5-CODE-METER-TYPE                              
                      ,:M5-CODE-MAKE                                    
                      ,:M5-NO-DIALS                                     
                      ,:M5-COMPANY-NO                                   
                 FROM  CSS_GAS_METER_SIZE                               
                WHERE  METER_SIZE_ID = :M5-METER-SIZE-ID                
                  AND  COMPANY_NO    = :M5-COMPANY-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE EQUAL SUCCESSFUL-CALL                            
               MOVE 'Y' TO WS-MTR-SIZE-FOUND                            
           ELSE                                                         
               IF  SQLCODE EQUAL NOT-FOUND                              
                   NEXT SENTENCE                                        
               ELSE                                                     
                   MOVE SQLCODE        TO WS-DISPLAY-RC                 
                   DISPLAY '***************PCSMT605****************'    
                   DISPLAY '* ERROR ON 7000-SELECT-GAS-METER-SIZE *'    
                   DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC              
                   DISPLAY '* MTR NBR ' E-FMT20-METER-NO                
                   DISPLAY '* DATE ' E-FMT20-DATE-TEST                  
                   DISPLAY '***************PCSMT605****************'    
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7010-SELECT-TEST-SCH.                                            
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT  TEST_SCHED_DESC                                  
                 INTO :M3-TEST-SCHED-DESC                               
                 FROM  CSS_TEST_SCHEDULE WITH(READUNCOMMITTED)                  
                WHERE  TEST_SCHED_CD = :M3-TEST-SCHED-CD                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  TEST_SCHED_DESC                                          
MFA-TR*          INTO :M3-TEST-SCHED-DESC                                       
MFA-TR*          FROM  CSS_TEST_SCHEDULE                                        
MFA-TR*         WHERE  TEST_SCHED_CD = :M3-TEST-SCHED-CD                        
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT605****************'        
               DISPLAY '* ERROR ON 7010-SELECT-TEST-SCH       *'        
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* TEST_SCHED_CD = ' M3-TEST-SCHED-CD            
               DISPLAY '***************PCSMT605****************'        
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7020-SELECT-ATTACHMENT-TYPE                               **          
      **                                                            **          
      ****************************************************************          
       7020-SELECT-ATTACHMENT-TYPE.                                     
      *                                                                         
           EXEC SQL                                                     
               SELECT  MTR_ATT_TYPE_DESC                                
                 INTO :N5-MTR-ATT-TYPE-DESC                              
                 FROM  CSS_MTR_ATT_TYPE                                 
                WHERE  CODE_UTIL_TYPE     = :N5-CODE-UTIL-TYPE          
                  AND  CODE_ATT_TYPE      = :N5-CODE-ATT-TYPE           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ064
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  MTR_ATT_TYPE_DESC                                        
MFA-TR*          INTO :N5-MTR-ATT-TYPE-DESC                                     
MFA-TR*              ,:N5-UNIQUE-ATT-ID-CD                                      
MFA-TR*          FROM  CSS_MTR_ATT_TYPE                                         
MFA-TR*         WHERE  CODE_UTIL_TYPE     = :N5-CODE-UTIL-TYPE                  
MFA-TR*           AND  CODE_ATT_TYPE      = :N5-CODE-ATT-TYPE                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT605****************'        
               DISPLAY '* ERROR ON 7020-SELECT-ATTACHMENT-TYPE*'        
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* MTR NBR ' E-FMT20-METER-NO                    
               DISPLAY '* ATTACH NBR ' E-FMT20-ATTACH-NO                
               DISPLAY '***************PCSMT605****************'        
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7030-SELECT-ATTACHMENT-MAKE                               **          
      **                                                            **          
      ****************************************************************          
       7030-SELECT-ATTACHMENT-MAKE.                                     
      *                                                                         
           EXEC SQL                                                     
               SELECT  EQUIP_MAKE_DESC                                  
                 INTO :M2-EQUIP-MAKE-DESC                               
                 FROM  CSS_EQUIP_MAKE                                   
                WHERE  CODE_MAKE = :M2-CODE-MAKE                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT605****************'        
               DISPLAY '* ERROR ON 7030-SELECT-ATTACHMENT-MAKE*'        
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* MTR NBR ' E-FMT20-METER-NO                    
               DISPLAY '* ATTACH NBR ' E-FMT20-ATTACH-NO                
               DISPLAY '***************PCSMT605****************'        
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7040-SELECT-MTR-STORGE-FAC                                **          
      **                                                            **          
      ****************************************************************          
       7040-SELECT-MTR-STORGE-FAC.                                      
      *                                                                         
           EXEC SQL                                                     
               SELECT  MTR_STORAGE_FAC_TX                               
                 INTO :W9-MTR-STORAGE-FAC-TX                            
                 FROM  CSS_MTR_STORGE_FAC                               
                WHERE  CODE_UTIL_TYPE     = :W9-CODE-UTIL-TYPE          
                  AND  MTR_STORAGE_FAC_CD = :WS-LOCAL-OFFICE            
T12999            AND  COMPANY_NO         = :W9-COMPANY-NO              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT605****************'        
               DISPLAY '* ERROR ON 7040-SELECT-MTR-STORGE-FAC *'        
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* MTR NBR ' E-FMT20-METER-NO                    
               DISPLAY '* DATE ' E-FMT20-DATE-TEST                      
               DISPLAY '***************PCSMT605****************'        
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7100-OPEN-EQUIP-ATTCHMTS.                                        
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               OPEN EQUIP-ATTCHMTS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      **                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE        TO WS-DISPLAY-RC                      
              DISPLAY '***************PCSMT605***************'          
              DISPLAY '* ERROR ON 7100-OPEN-EQUIP-ATTCHMTS  *'          
              DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
              DISPLAY '* DEVICE_NO          = ' LX-DEVICE-NO            
              DISPLAY '* CODE_ATT_TYPE      = ' LX-CODE-ATT-TYPE        
              DISPLAY '* PROGRAM ABENDING...                *'          
              DISPLAY '***************PCSMT605***************'          
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7110-FETCH-EQUIP-ATTCHMTS.                                       
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               FETCH EQUIP-ATTCHMTS                                     
                INTO :WS-DB-CODE-UTIL-TYPE                              
                    ,:WS-DB-COMPANY-NO                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      **                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE        TO WS-DISPLAY-RC                      
              DISPLAY '***************PCSMT605***************'          
              DISPLAY '* ERROR ON 7110-FETCH-EQUIP-ATTCHMTS *'          
              DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
              DISPLAY '* DEVICE_NO          = ' LX-DEVICE-NO            
              DISPLAY '* CODE_ATT_TYPE      = ' LX-CODE-ATT-TYPE        
              DISPLAY '* PROGRAM ABENDING...                *'          
              DISPLAY '***************PCSMT605***************'          
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7120-CLOSE-EQUIP-ATTCHMTS.                                       
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               CLOSE EQUIP-ATTCHMTS                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      **                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE        TO WS-DISPLAY-RC                      
              DISPLAY '***************PCSMT605***************'          
              DISPLAY '* ERROR ON 7120-CLOSE-EQUIP-ATTCHMTS *'          
              DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
              DISPLAY '* PROGRAM ABENDING...                *'          
              DISPLAY '***************PCSMT605***************'          
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7130-OPEN-METER-ATTCHMTS.                                        
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               OPEN METER-ATTCHMTS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      **                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE        TO WS-DISPLAY-RC                      
              DISPLAY '***************PCSMT605***************'          
              DISPLAY '* ERROR ON 7130-OPEN-METER-ATTCHMTS  *'          
              DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
              DISPLAY '* DEVICE_NO          = ' MA-DEVICE-NO            
              DISPLAY '* CODE_ATT_TYPE      = ' MA-CODE-ATT-TYPE        
              DISPLAY '* PROGRAM ABENDING...                *'          
              DISPLAY '***************PCSMT605***************'          
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7140-FETCH-METER-ATTCHMTS.                                       
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               FETCH METER-ATTCHMTS                                     
                INTO :WS-DB-CODE-UTIL-TYPE                              
                    ,:WS-DB-COMPANY-NO                                  
                    ,:WS-DB-METER-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      **                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE        TO WS-DISPLAY-RC                      
              DISPLAY '***************PCSMT605***************'          
              DISPLAY '* ERROR ON 7140-FETCH-METER-ATTCHMTS *'          
              DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
              DISPLAY '* DEVICE_NO          = ' MA-DEVICE-NO            
              DISPLAY '* CODE_ATT_TYPE      = ' MA-CODE-ATT-TYPE        
              DISPLAY '* PROGRAM ABENDING...                *'          
              DISPLAY '***************PCSMT605***************'          
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7150-CLOSE-METER-ATTCHMTS.                                       
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               CLOSE METER-ATTCHMTS                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      **                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE        TO WS-DISPLAY-RC                      
              DISPLAY '***************PCSMT605***************'          
              DISPLAY '* ERROR ON 7150-CLOSE-METER-ATTCHMTS *'          
              DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
              DISPLAY '* PROGRAM ABENDING...                *'          
              DISPLAY '***************PCSMT605***************'          
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
T35434*===============================================================*         
T35434 7200-SELECT-RESTART.                                             
T35434*===============================================================*         
T35434     EXEC  SQL                                                    
T35434        SELECT RESTART_DATA                                       
T35434          INTO :RF-RESTART-DATA                                   
T35434          FROM CSS_RESTART                                        
T35434         WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                    
T35434           AND PARTITION_NO = :RF-PARTITION-NO                    
T35434           AND  DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
T35434     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35434*                                                                 21060000
T35434     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T35434*                                                                 21060000
T35434     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T35434                                       OR NOT-FOUND               
T35434         CONTINUE                                                 
T35434       ELSE                                                       
T35434         DISPLAY '**  ERROR ON 7200-SELECT-RESTART   ***'         
T35434         DISPLAY '**  NAME_PROGRAM = ' RF-NAME-PROGRAM            
T35434         DISPLAY '**  PARTITION_NO = ' RF-PARTITION-NO            
T35434         DISPLAY '**  DUP_CNTRL_NO = ' RF-DUP-CNTRL-NO            
T35434         DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
T35434         DISPLAY '**      PROCESSING TERMINATED     **'           
T35434         PERFORM 9900-ABEND            THRU 9900-EXIT             
T35434      END-IF.                                                     
T35434*                                                                 21060000
T35434 7200-EXIT.                                                       
T35434      EXIT.                                                       
T35434                                                                  
A01209*================================================================*        
A01209 7300-SELECT-EQUIP-ATTCHMT.                                       
A01209*================================================================*        
A01209*                                                                         
A01209     EXEC SQL                                                     
A01209         SELECT  EQUIP_LOC_ID                                     
A01209                ,COALESCE(MTR_STORAGE_FAC_CD, '   ')              
A01209                ,COALESCE(DATE_LAST_MOVE, 
           CAST(SYSDATETIMEOFFSET() AS DATE))           
A01209           INTO :WS-MP-EQUIP-LOC-ID                               
A01209               ,:WS-MP-MTR-STORAGE-FAC-CD                         
A01209               ,:WS-MP-DATE-MOVE                                  
A01209         FROM    CSS_EQUIP_ATTCHMTS WITH(READUNCOMMITTED)                 
A01209         WHERE   DEVICE_NO          = :LX-DEVICE-NO               
A01209           AND   CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE           
A01209           AND   COMPANY_NO         = :LX-COMPANY-NO              
A01209           AND   CODE_UTIL_TYPE     = 'G'                         
A01209                                                           
A01209     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  EQUIP_LOC_ID                                     03310000
MFA-TR*               ,COALESCE(MTR_STORAGE_FAC_CD, '   ')                      
MFA-TR*               ,COALESCE(DATE_LAST_MOVE, CURRENT DATE)           03310000
MFA-TR*          INTO :WS-MP-EQUIP-LOC-ID                                       
MFA-TR*              ,:WS-MP-MTR-STORAGE-FAC-CD                                 
MFA-TR*              ,:WS-MP-DATE-MOVE                                          
MFA-TR*        FROM    CSS_EQUIP_ATTCHMTS                               03320000
MFA-TR*        WHERE   DEVICE_NO          = :LX-DEVICE-NO               03330000
MFA-TR*          AND   CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE                   
MFA-TR*          AND   COMPANY_NO         = :LX-COMPANY-NO                      
MFA-TR*          AND   CODE_UTIL_TYPE     = 'G'                                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    03380000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01209*                                                                         
A01209     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
A01209        CONTINUE                                                  
A01209     ELSE                                                         
A01209        MOVE SQLCODE        TO WS-DISPLAY-RC                      
A01209        DISPLAY '***************PCSMT605***************'          
A01209        DISPLAY '* ERROR IN 7300-SELECT-EQUIP-ATTCHMT *'          
A01209        DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
A01209        DISPLAY '* DEVICE_NO          = ' LX-DEVICE-NO            
A01209        DISPLAY '* CODE_ATT_TYPE      = ' LX-CODE-ATT-TYPE        
A01209        DISPLAY '* COMPANY_NO         = ' LX-COMPANY-NO           
A01209        DISPLAY '***************PCSMT605***************'          
A01209        PERFORM 9900-ABEND            THRU 9900-EXIT              
A01209     END-IF.                                                      
A01209*                                                                         
A01209 7300-EXIT.                                                       
A01209     EXIT.                                                        
A01209*                                                                         
      *================================================================*        
       7800-OPEN-CODE-VALUE.                                            
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              OPEN CODE_VAL_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT605****************'        
               DISPLAY '* ERROR ON 7800-OPEN-CODE-VALUE       *'        
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* COMPANY_NO = :' WS-SYSIN-COMP-NO              
               DISPLAY '* TABLE_NA   = :' WS-TABLE-NA                   
               DISPLAY '* COLUMN_NA  = :' WS-COLUMN-NA                  
               DISPLAY '***************PCSMT605****************'        
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7820-FETCH-CODE-VALUE.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              FETCH CODE_VAL_CSR                                        
               INTO :WS-CODE-VALUE                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT605****************'        
               DISPLAY '* ERROR ON 7820-FETCH-CODE-VALUE      *'        
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* COMPANY_NO = :' WS-SYSIN-COMP-NO              
               DISPLAY '* TABLE_NA   = :' WS-TABLE-NA                   
               DISPLAY '* COLUMN_NA  = :' WS-COLUMN-NA                  
               DISPLAY '***************PCSMT605****************'        
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7820-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7840-CLOSE-CODE-VALUE.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              CLOSE CODE_VAL_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT605****************'        
               DISPLAY '* ERROR ON 7840-CLOSE-CODE-VALUE      *'        
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* COMPANY_NO = :' WS-SYSIN-COMP-NO              
               DISPLAY '* TABLE_NA   = :' WS-TABLE-NA                   
               DISPLAY '* COLUMN_NA  = :' WS-COLUMN-NA                  
               DISPLAY '***************PCSMT605****************'        
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7840-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INSERT THE METER INTO CSS_EQUIPMENT TABLE                    **        
      ******************************************************************        
       7900-INSERT-EQUIPMENT.                                           
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_EQUIPMENT                                
                   ( CODE_UTIL_TYPE                                     
                    ,DEVICE_NO                                          
                    ,CODE_MAKE                                          
                    ,EQUIP_TYPE_CD                                      
                    ,DATE_DISPOSED_OF                                   
                    ,DATE_PURCHASED                                     
                    ,SERIAL_NO                                          
                    ,CODE_CRNT_LOC                                      
                    ,CRNT_LOC_NO                                        
                    ,DATE_LAST_TRAN                                     
                    ,DATE_LAST_MOVE                                     
                    ,LOCAL_OFFICE                                       
                    ,INSTALL_EMP_ID                                     
                    ,PALETTE_NO                                         
                    ,UPGRADES_TX                                        
                    ,COMPANY_NO)                                        
               VALUES                                                   
                   ( :EQ-CODE-UTIL-TYPE                                 
                    ,:EQ-DEVICE-NO                                      
                    ,:EQ-CODE-MAKE                                      
                    ,:EQ-EQUIP-TYPE-CD                                  
                    ,IIF(TRY_CONVERT(DATE, :EQ-DATE-DISPOSED-OF 
                                           :WS-NULLIND-DATE-DISPOSED
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-DISPOSED-OF 
                                              :WS-NULLIND-DATE-DISPOSED
              ) <> 0) OR (LEN(:EQ-DATE-DISPOSED-OF 
                                              :WS-NULLIND-DATE-DISPOSED
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-DISPOSED-OF 
                                              :WS-NULLIND-DATE-DISPOSED
              ), CONVERT(DATE, :EQ-DATE-DISPOSED-OF 
                                              :WS-NULLIND-DATE-DISPOSED
              ) )      
                    ,IIF(TRY_CONVERT(DATE, :EQ-DATE-PURCHASED 
                                           :WS-NULLIND-DATE-PURCHASED
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-PURCHASED 
                                             :WS-NULLIND-DATE-PURCHASED
              ) <> 0) OR (LEN(:EQ-DATE-PURCHASED 
                                             :WS-NULLIND-DATE-PURCHASED
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-PURCHASED 
                                             :WS-NULLIND-DATE-PURCHASED
              ), CONVERT(DATE, :EQ-DATE-PURCHASED 
                                             :WS-NULLIND-DATE-PURCHASED
              ) )       
                    ,:EQ-SERIAL-NO                                      
                    ,:EQ-CODE-CRNT-LOC                                  
                    ,:EQ-CRNT-LOC-NO                                    
                    ,CAST(SYSDATETIMEOFFSET() AS DATE)                          
                    ,IIF(TRY_CONVERT(DATE, :EQ-DATE-LAST-MOVE
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-MOVE
              ) <> 0) OR (LEN(:EQ-DATE-LAST-MOVE
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-MOVE
              ), CONVERT(DATE, :EQ-DATE-LAST-MOVE) )                           
                    ,:EQ-LOCAL-OFFICE                                   
                    ,:EQ-INSTALL-EMP-ID                                 
                    ,:EQ-PALETTE-NO                                     
                    ,:EQ-UPGRADES-TX                                    
                    ,:EQ-COMPANY-NO)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_EQUIPMENT                                        
MFA-TR*            ( CODE_UTIL_TYPE                                             
MFA-TR*             ,DEVICE_NO                                                  
MFA-TR*             ,CODE_MAKE                                                  
MFA-TR*             ,EQUIP_TYPE_CD                                              
MFA-TR*             ,DATE_DISPOSED_OF                                           
MFA-TR*             ,DATE_PURCHASED                                             
MFA-TR*             ,SERIAL_NO                                                  
MFA-TR*             ,CODE_CRNT_LOC                                              
MFA-TR*             ,CRNT_LOC_NO                                                
MFA-TR*             ,DATE_LAST_TRAN                                             
MFA-TR*             ,DATE_LAST_MOVE                                             
MFA-TR*             ,LOCAL_OFFICE                                               
MFA-TR*             ,INSTALL_EMP_ID                                             
MFA-TR*             ,PALETTE_NO                                                 
MFA-TR*             ,UPGRADES_TX                                                
MFA-TR*             ,COMPANY_NO)                                                
MFA-TR*        VALUES                                                           
MFA-TR*            ( :EQ-CODE-UTIL-TYPE                                         
MFA-TR*             ,:EQ-DEVICE-NO                                              
MFA-TR*             ,:EQ-CODE-MAKE                                              
MFA-TR*             ,:EQ-EQUIP-TYPE-CD                                          
MFA-TR*             ,:EQ-DATE-DISPOSED-OF:WS-NULLIND-DATE-DISPOSED              
MFA-TR*             ,:EQ-DATE-PURCHASED:WS-NULLIND-DATE-PURCHASED               
MFA-TR*             ,:EQ-SERIAL-NO                                              
MFA-TR*             ,:EQ-CODE-CRNT-LOC                                          
MFA-TR*             ,:EQ-CRNT-LOC-NO                                            
MFA-TR*             ,CURRENT DATE                                               
MFA-TR*             ,:EQ-DATE-LAST-MOVE                                         
MFA-TR*             ,:EQ-LOCAL-OFFICE                                           
MFA-TR*             ,:EQ-INSTALL-EMP-ID                                         
MFA-TR*             ,:EQ-PALETTE-NO                                             
MFA-TR*             ,:EQ-UPGRADES-TX                                            
MFA-TR*             ,:EQ-COMPANY-NO)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR -803                     
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT605****************'        
               DISPLAY '* ERROR ON 7900-INSERT-METER          *'        
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* MTR NBR ' E-FMT20-METER-NO                    
               DISPLAY '* DATE ' E-FMT20-DATE-TEST                      
               DISPLAY '***************PCSMT605****************'        
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INSERT A RECORD INTO CSS_GAS_METER                           **        
      ******************************************************************        
       7910-INSERT-GAS-METER.                                           
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_GAS_METER                                
                   ( CODE_UTIL_TYPE                                     
                    ,METER_NO                                           
                    ,CODE_ATTACHMENTS                                   
                    ,CASE_PRESSURE                                      
                    ,CCF_CAP_PER_HR                                     
                    ,CODE_METER_TYPE                                    
                    ,METER_SIZE_ID                                      
                    ,MODEL_CD                                           
                    ,CONNECTION_TYPE_CD                                 
                    ,ALLOW_CONSTANT_FL                                  
                    ,TEST_SCHED_CD                                      
                    ,DEVICE_TYPE_CD                                     
                    ,DIGTL_MTR_TYPE                                     
C26373              ,PROGRAM_ID                                         
                    ,NUMBER_OF_DRIVE                                    
                    ,COMPANY_NO)                                        
               VALUES                                                   
                   ( :GM-CODE-UTIL-TYPE                                 
                    ,:GM-METER-NO                                       
                    ,:GM-CODE-ATTACHMENTS                               
                    ,:GM-CASE-PRESSURE                                  
                    ,:GM-CCF-CAP-PER-HR                                 
                    ,:GM-CODE-METER-TYPE                                
                    ,:GM-METER-SIZE-ID                                  
                    ,:GM-MODEL-CD                                       
                    ,:GM-CONNECTION-TYPE-CD                             
                    ,:GM-ALLOW-CONSTANT-FL                              
                    ,:GM-TEST-SCHED-CD                                  
                    ,:GM-DEVICE-TYPE-CD                                 
                    ,:GM-DIGTL-MTR-TYPE                                 
C26373              ,:GM-PROGRAM-ID                                     
                    ,:GM-NUMBER-OF-DRIVE                                
                    ,:GM-COMPANY-NO)                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR ALREADY-EXISTS          
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT605****************'        
               DISPLAY '* ERROR ON 7910-INSERT-GAS-METER      *'        
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* MTR NBR ' E-FMT20-METER-NO                    
               DISPLAY '* DATE ' E-FMT20-DATE-TEST                      
               DISPLAY '***************PCSMT605****************'        
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7910-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** INSERT A RECORD INTO CSS_MTR_CAP                             **        
      ******************************************************************        
       7920-INSERT-MTR-CAP.                                             
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_MTR_CAP                                  
                   (  CODE_UTIL_TYPE                                    
                     ,METER_NO                                          
                     ,REG_ID_NO                                         
                     ,CODE_CAP_TYPE                                     
                     ,CONSTANT                                          
                     ,NO_DIALS                                          
                     ,NO_READ_DIALS                                     
                     ,COMPANY_NO)                                       
               VALUES                                                   
                   (  :MC-CODE-UTIL-TYPE                                
                     ,:MC-METER-NO                                      
                     ,:MC-REG-ID-NO                                     
                     ,:MC-CODE-CAP-TYPE                                 
                     ,:MC-CONSTANT                                      
                     ,:MC-NO-DIALS                                      
                     ,:MC-NO-READ-DIALS                                 
                     ,:MC-COMPANY-NO)                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT605****************'        
               DISPLAY '* ERROR ON 7920-INSERT-MTR-CAP        *'        
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* MTR NBR ' E-FMT20-METER-NO                    
               DISPLAY '* DATE ' E-FMT20-DATE-TEST                      
               DISPLAY '***************PCSMT605****************'        
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INSERT A RECORD INTO CSS_METER_ATTCHMTS                      **        
      ******************************************************************        
       7930-INSERT-MTR-ATTACH.                                          
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_METER_ATTCHMTS                           
                   (  CODE_UTIL_TYPE                                    
                     ,METER_NO                                          
                     ,CODE_DEVICE_TYPE                                  
                     ,DEVICE_NO                                         
                     ,CODE_ATT_TYPE                                     
                     ,CT_PT_RATIO                                       
                     ,CODE_MAKE                                         
                     ,DATE_LAST_TESTED                                  
                     ,TEST_SCHED_CD                                     
                     ,HOW_ATTACHED_CD                                   
                     ,COMPANY_NO)                                       
               VALUES                                                   
                   (  :MA-CODE-UTIL-TYPE                                
                     ,:MA-METER-NO                                      
                     ,:MA-CODE-DEVICE-TYPE                              
                     ,:MA-DEVICE-NO                                     
                     ,:MA-CODE-ATT-TYPE                                 
                     ,:MA-CT-PT-RATIO                                   
                     ,:MA-CODE-MAKE                                     
                     ,IIF(TRY_CONVERT(DATE, :MA-DATE-LAST-TESTED 
                                            :WS-NULLIND-DATE-LAST-TESTED
              ) IS NULL OR (PATINDEX('%.%', :MA-DATE-LAST-TESTED 
                                           :WS-NULLIND-DATE-LAST-TESTED
              ) <> 0) OR (LEN(:MA-DATE-LAST-TESTED 
                                           :WS-NULLIND-DATE-LAST-TESTED
              ) <> 10), CIS.CHAR2DATE(:MA-DATE-LAST-TESTED 
                                           :WS-NULLIND-DATE-LAST-TESTED
              ), CONVERT(DATE, :MA-DATE-LAST-TESTED 
                                           :WS-NULLIND-DATE-LAST-TESTED
              ) )  
                     ,:MA-TEST-SCHED-CD                                 
                     ,:MA-HOW-ATTACHED-CD                               
                     ,:MA-COMPANY-NO)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_METER_ATTCHMTS                                   
MFA-TR*            (  CODE_UTIL_TYPE                                            
MFA-TR*              ,METER_NO                                                  
MFA-TR*              ,CODE_DEVICE_TYPE                                          
MFA-TR*              ,DEVICE_NO                                                 
MFA-TR*              ,CODE_ATT_TYPE                                             
MFA-TR*              ,CT_PT_RATIO                                               
MFA-TR*              ,CODE_MAKE                                                 
MFA-TR*              ,DATE_LAST_TESTED                                          
MFA-TR*              ,TEST_SCHED_CD                                             
MFA-TR*              ,HOW_ATTACHED_CD                                           
MFA-TR*              ,COMPANY_NO)                                               
MFA-TR*        VALUES                                                           
MFA-TR*            (  :MA-CODE-UTIL-TYPE                                        
MFA-TR*              ,:MA-METER-NO                                              
MFA-TR*              ,:MA-CODE-DEVICE-TYPE                                      
MFA-TR*              ,:MA-DEVICE-NO                                             
MFA-TR*              ,:MA-CODE-ATT-TYPE                                         
MFA-TR*              ,:MA-CT-PT-RATIO                                           
MFA-TR*              ,:MA-CODE-MAKE                                             
MFA-TR*              ,:MA-DATE-LAST-TESTED:WS-NULLIND-DATE-LAST-TESTED          
MFA-TR*              ,:MA-TEST-SCHED-CD                                         
MFA-TR*              ,:MA-HOW-ATTACHED-CD                                       
MFA-TR*              ,:MA-COMPANY-NO)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT605****************'        
               DISPLAY '* ERROR ON 7930-INSERT-MTR-ATTACH     *'        
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* MTR NBR ' E-FMT20-METER-NO                    
               DISPLAY '* ATTACH NBR ' E-FMT20-ATTACH-NO                
               DISPLAY '***************PCSMT605****************'        
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7930-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INSERT A RECORD INTO CSS_EQUIP_ATTCHMTS                      **        
      ******************************************************************        
       7940-INSERT-EQUIP-ATTCHMTS.                                      
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_EQUIP_ATTCHMTS                           
                   (  DEVICE_NO                                         
                     ,CODE_ATT_TYPE                                     
                     ,COMPANY_NO                                        
                     ,CODE_UTIL_TYPE                                    
                     ,EQUIP_LOC_ID                                      
                     ,MTR_STORAGE_FAC_CD                                
                     ,CODE_MAKE                                         
                     ,TEST_SCHED_CD                                     
                     ,VERSION_CD                                        
                     ,EQUIP_ATTACH_DT                                   
                     ,DATE_LAST_MOVE                                    
                     ,DATE_LAST_TESTED                                  
                     ,DATE_LAST_TRAN                                    
                     ,DATE_PURCHASED                                    
                     ,WARRANTY_EXP_DT                                   
                     ,DATE_OBSOLETE                                     
                     ,DATE_DISPOSED_OF)                                 
               VALUES                                                   
                   (  :LX-DEVICE-NO                                     
                     ,:LX-CODE-ATT-TYPE                                 
                     ,:LX-COMPANY-NO                                    
                     ,:LX-CODE-UTIL-TYPE                                
                     ,:LX-EQUIP-LOC-ID                                  
                     ,:LX-MTR-STORAGE-FAC-CD                            
                     ,:LX-CODE-MAKE                                     
                     ,:LX-TEST-SCHED-CD                                 
                     ,:LX-VERSION-CD                                    
                     ,IIF(TRY_CONVERT(DATE, :LX-EQUIP-ATTACH-DT 
                                            :WS-NULLIND-ATTACH-DT
              ) IS NULL OR (PATINDEX('%.%', :LX-EQUIP-ATTACH-DT 
                                                  :WS-NULLIND-ATTACH-DT
              ) <> 0) OR (LEN(:LX-EQUIP-ATTACH-DT :WS-NULLIND-ATTACH-DT
              ) <> 10), CIS.CHAR2DATE(:LX-EQUIP-ATTACH-DT 
                                                  :WS-NULLIND-ATTACH-DT
              ), CONVERT(DATE, :LX-EQUIP-ATTACH-DT 
                                                  :WS-NULLIND-ATTACH-DT
              ) )          
                     ,IIF(TRY_CONVERT(DATE, :LX-DATE-LAST-MOVE 
                                            :WS-NULLIND-DATE-LAST-MOVE
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-MOVE 
                                             :WS-NULLIND-DATE-LAST-MOVE
              ) <> 0) OR (LEN(:LX-DATE-LAST-MOVE 
                                             :WS-NULLIND-DATE-LAST-MOVE
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-MOVE 
                                             :WS-NULLIND-DATE-LAST-MOVE
              ), CONVERT(DATE, :LX-DATE-LAST-MOVE 
                                             :WS-NULLIND-DATE-LAST-MOVE
              ) )      
                     ,IIF(TRY_CONVERT(DATE, :LX-DATE-LAST-TESTED 
                                            :WS-NULLIND-DATE-LAST-TESTED
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-TESTED 
                                           :WS-NULLIND-DATE-LAST-TESTED
              ) <> 0) OR (LEN(:LX-DATE-LAST-TESTED 
                                           :WS-NULLIND-DATE-LAST-TESTED
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-TESTED 
                                           :WS-NULLIND-DATE-LAST-TESTED
              ), CONVERT(DATE, :LX-DATE-LAST-TESTED 
                                           :WS-NULLIND-DATE-LAST-TESTED
              ) )  
                     ,IIF(TRY_CONVERT(DATE, :LX-DATE-LAST-TRAN 
                                            :WS-NULLIND-DATE-LAST-TRAN
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-TRAN 
                                             :WS-NULLIND-DATE-LAST-TRAN
              ) <> 0) OR (LEN(:LX-DATE-LAST-TRAN 
                                             :WS-NULLIND-DATE-LAST-TRAN
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-TRAN 
                                             :WS-NULLIND-DATE-LAST-TRAN
              ), CONVERT(DATE, :LX-DATE-LAST-TRAN 
                                             :WS-NULLIND-DATE-LAST-TRAN
              ) )      
                     ,IIF(TRY_CONVERT(DATE, :LX-DATE-PURCHASED 
                                            :WS-NULLIND-DATE-PURCHASED
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-PURCHASED 
                                             :WS-NULLIND-DATE-PURCHASED
              ) <> 0) OR (LEN(:LX-DATE-PURCHASED 
                                             :WS-NULLIND-DATE-PURCHASED
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-PURCHASED 
                                             :WS-NULLIND-DATE-PURCHASED
              ), CONVERT(DATE, :LX-DATE-PURCHASED 
                                             :WS-NULLIND-DATE-PURCHASED
              ) )      
                     ,IIF(TRY_CONVERT(DATE, :LX-WARRANTY-EXP-DT 
                                            :WS-NULLIND-WARRANTY-DATE
              ) IS NULL OR (PATINDEX('%.%', :LX-WARRANTY-EXP-DT 
                                              :WS-NULLIND-WARRANTY-DATE
              ) <> 0) OR (LEN(:LX-WARRANTY-EXP-DT 
                                              :WS-NULLIND-WARRANTY-DATE
              ) <> 10), CIS.CHAR2DATE(:LX-WARRANTY-EXP-DT 
                                              :WS-NULLIND-WARRANTY-DATE
              ), CONVERT(DATE, :LX-WARRANTY-EXP-DT 
                                              :WS-NULLIND-WARRANTY-DATE
              ) )      
                     ,IIF(TRY_CONVERT(DATE, :LX-DATE-OBSOLETE 
                                            :WS-NULLIND-DATE-OBSOLETE
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-OBSOLETE 
                                              :WS-NULLIND-DATE-OBSOLETE
              ) <> 0) OR (LEN(:LX-DATE-OBSOLETE 
                                              :WS-NULLIND-DATE-OBSOLETE
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-OBSOLETE 
                                              :WS-NULLIND-DATE-OBSOLETE
              ), CONVERT(DATE, :LX-DATE-OBSOLETE 
                                              :WS-NULLIND-DATE-OBSOLETE
              ) )        
                     ,IIF(TRY_CONVERT(DATE, :LX-DATE-DISPOSED-OF 
                                            :WS-NULLIND-DATE-DISPOSED
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-DISPOSED-OF 
                                              :WS-NULLIND-DATE-DISPOSED
              ) <> 0) OR (LEN(:LX-DATE-DISPOSED-OF 
                                              :WS-NULLIND-DATE-DISPOSED
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-DISPOSED-OF 
                                              :WS-NULLIND-DATE-DISPOSED
              ), CONVERT(DATE, :LX-DATE-DISPOSED-OF 
                                              :WS-NULLIND-DATE-DISPOSED
              ) ))    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_EQUIP_ATTCHMTS                                   
MFA-TR*            (  DEVICE_NO                                                 
MFA-TR*              ,CODE_ATT_TYPE                                             
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,CODE_UTIL_TYPE                                            
MFA-TR*              ,EQUIP_LOC_ID                                              
MFA-TR*              ,MTR_STORAGE_FAC_CD                                        
MFA-TR*              ,CODE_MAKE                                                 
MFA-TR*              ,TEST_SCHED_CD                                             
MFA-TR*              ,VERSION_CD                                                
MFA-TR*              ,EQUIP_ATTACH_DT                                           
MFA-TR*              ,DATE_LAST_MOVE                                            
MFA-TR*              ,DATE_LAST_TESTED                                          
MFA-TR*              ,DATE_LAST_TRAN                                            
MFA-TR*              ,DATE_PURCHASED                                            
MFA-TR*              ,WARRANTY_EXP_DT                                           
MFA-TR*              ,DATE_OBSOLETE                                             
MFA-TR*              ,DATE_DISPOSED_OF)                                         
MFA-TR*        VALUES                                                           
MFA-TR*            (  :LX-DEVICE-NO                                             
MFA-TR*              ,:LX-CODE-ATT-TYPE                                         
MFA-TR*              ,:LX-COMPANY-NO                                            
MFA-TR*              ,:LX-CODE-UTIL-TYPE                                        
MFA-TR*              ,:LX-EQUIP-LOC-ID                                          
MFA-TR*              ,:LX-MTR-STORAGE-FAC-CD                                    
MFA-TR*              ,:LX-CODE-MAKE                                             
MFA-TR*              ,:LX-TEST-SCHED-CD                                         
MFA-TR*              ,:LX-VERSION-CD                                            
MFA-TR*              ,:LX-EQUIP-ATTACH-DT:WS-NULLIND-ATTACH-DT                  
MFA-TR*              ,:LX-DATE-LAST-MOVE:WS-NULLIND-DATE-LAST-MOVE              
MFA-TR*              ,:LX-DATE-LAST-TESTED:WS-NULLIND-DATE-LAST-TESTED          
MFA-TR*              ,:LX-DATE-LAST-TRAN:WS-NULLIND-DATE-LAST-TRAN              
MFA-TR*              ,:LX-DATE-PURCHASED:WS-NULLIND-DATE-PURCHASED              
MFA-TR*              ,:LX-WARRANTY-EXP-DT:WS-NULLIND-WARRANTY-DATE              
MFA-TR*              ,:LX-DATE-OBSOLETE:WS-NULLIND-DATE-OBSOLETE                
MFA-TR*              ,:LX-DATE-DISPOSED-OF:WS-NULLIND-DATE-DISPOSED)            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT605****************'        
               DISPLAY '* ERROR ON 7940-INSERT-EQUIP-ATTCHMTS *'        
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* MTR NBR ' E-FMT20-METER-NO                    
               DISPLAY '* ATTACH NBR ' E-FMT20-ATTACH-NO                
               DISPLAY '***************PCSMT605****************'        
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7940-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
A04860** INSERT A RECORD INTO CSS_WQ_ITEMS                            **        
      ******************************************************************        
       7950-INSERT-WORK-QUEUE-ITEM.                                     
      *                                                                         
A04860     CALL SCSCB077  USING   CWS00077-FIELDS,                      
A04860                            ABEND-FILE,                           
A04860                            RS-RETURN-CODE.                       
A04860*                                                                         
A04860     MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE.   
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE WS-PGRMNAME              TO ABEND-PROGRAM            
A04860        DISPLAY '7950-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'COMMENTS        ' WS-WQ-COMMENTS                 
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     ELSE                                                         
A04860        MOVE WS-77-WQ-ITEM-ID         TO WS-ITEM-ID               
A04860     END-IF.                                                      
      *                                                                         
       7950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  8000-INITIALIZE                                           **          
      **                                                            **          
      ****************************************************************          
       8000-INITIALIZE.                                                 
      *                                                                         
           MOVE WS-N TO WS-RECORD-FLAG.                                 
           COMPUTE WS-ERR-ARRAY-IDX  = 0.                               
           INITIALIZE DCLCSS-EQUIPMENT,                                 
                      DCLCSS-GAS-METER,                                 
                      DCLCSS-MTR-CAP,                                   
                      ERROR-HOLD-AREA,                                  
                      DCLCSS-EQUIP-ATTCHMTS,                            
                      DCLCSS-METER-ATTCHMTS.                            
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  8100-READ-METER-FILE, FCSMT20-FILE                        **          
      **                                                            **          
      ****************************************************************          
       8100-READ-METER-FILE.                                            
      *                                                                         
           READ GAS-METER-FILE                                          
               AT END MOVE 'Y'         TO WS-EOF-FLAG.                  
      *                                                                         
           IF NOT END-OF-FILE                                           
               ADD 1                   TO WS-NBR-METER-RECS             
               DISPLAY 'METER NBR = ' E-FMT20-METER-NO                  
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * IF LINE COUNTER IS > 56 PRINTS THE PAGE HEADINGS, MOVES INPUT**         
      * VARIABLES TO THE REPORT VARIABLES AND  PRINTS THE REPORT.    **         
      *****************************************************************         
       8200-WRITE-PRINTER-RECORD.                                       
      *                                                                         
           IF WS-LINE-CNTR > WS-FIFTY-SIX                               
              PERFORM 8300-PRT-HEADINGS       THRU 8300-EXIT            
              ADD WS-TWO                      TO WS-LINE-CNTR           
              SET ERROR-FOUND                 TO TRUE                   
           END-IF.                                                      
           MOVE WS-DET-LINE-1                  TO PRT33-DATA.           
           PERFORM 8400-WRITE-PRINT-REC        THRU 8400-EXIT.          
           MOVE WS-ONE                         TO WS-LINE-SPACE.        
           ADD WS-ONE                          TO WS-LINE-CNTR.         
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  PRINTS THE PAGE HEADINGS  AT THE TOP OF EACH PAGE          **          
      ****************************************************************          
       8300-PRT-HEADINGS.                                               
      *                                                                         
           MOVE 0                              TO WS-LINE-CNTR.         
           ADD WS-ONE                          TO WS-PAGE.              
           MOVE WS-PAGE                        TO WS-DET-PAGE.          
           MOVE WS-HDR-ONE                     TO PRT33-DATA.           
           WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
           MOVE WS-HDR-TWO                     TO PRT33-DATA.           
           MOVE WS-ONE                         TO WS-LINE-SPACE.        
           PERFORM 8400-WRITE-PRINT-REC        THRU 8400-EXIT.          
           MOVE WS-BLANK-LINE                  TO PRT33-DATA.           
           PERFORM 8400-WRITE-PRINT-REC        THRU 8400-EXIT.          
           MOVE WS-HDR-THREE                   TO PRT33-DATA.           
           MOVE WS-TWO                         TO WS-LINE-SPACE.        
           PERFORM 8400-WRITE-PRINT-REC        THRU 8400-EXIT.          
           MOVE WS-BLANK-LINE                  TO PRT33-DATA.           
           MOVE WS-ONE                         TO WS-LINE-SPACE.        
           PERFORM 8400-WRITE-PRINT-REC        THRU 8400-EXIT.          
           ADD  WS-SIX                         TO WS-LINE-CNTR.         
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** WRITES THE PRINT RECORD                                      **        
      ******************************************************************        
       8400-WRITE-PRINT-REC.                                            
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING WS-LINE-SPACE.            
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  8500-PRODUCE-SUMMARY-REPORTS                              **          
      **                                                            **          
      ****************************************************************          
       8500-PRODUCE-SUMMARY-REPORTS.                                    
      *                                                                         
           IF WS-LINE-CNTR > WS-FIFTY-TWO                               
              PERFORM 8300-PRT-HEADINGS       THRU 8300-EXIT            
              ADD WS-TWO               TO WS-LINE-CNTR                  
           END-IF.                                                      
           MOVE WS-ONE                 TO WS-LINE-SPACE.                
           IF NOT ERROR-FOUND                                           
              MOVE WS-NO-ERROR-LINE    TO PRT33-DATA                    
              PERFORM 8400-WRITE-PRINT-REC    THRU 8400-EXIT            
           END-IF.                                                      
           MOVE WS-BLANK-LINE          TO PRT33-DATA.                   
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
           MOVE WS-TOT-RECDS-INFO      TO WS-RPT-MESSAGE.               
           MOVE WS-NBR-METER-RECS      TO WS-RPT-STATISTICS.            
           MOVE WS-DET-LINE-2          TO PRT33-DATA.                   
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
           MOVE WS-TOT-GOOD-RECDS      TO WS-RPT-MESSAGE.               
           MOVE WS-NBR-GOOD-RECS       TO WS-RPT-STATISTICS.            
           MOVE WS-DET-LINE-2          TO PRT33-DATA.                   
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
           MOVE WS-TOT-BAD-RECDS       TO WS-RPT-MESSAGE.               
           MOVE WS-NBR-BAD-RECS        TO WS-RPT-STATISTICS.            
           MOVE WS-DET-LINE-2          TO PRT33-DATA.                   
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
           MOVE WS-TOT-UNADDED-MTRS    TO WS-RPT-MESSAGE.               
           MOVE WS-NO-ADDITION-MTRS    TO WS-RPT-STATISTICS.            
           MOVE WS-DET-LINE-2          TO PRT33-DATA.                   
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
           MOVE WS-BLANK-LINE          TO PRT33-DATA.                   
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
           MOVE WS-FOOT-LINE           TO PRT33-DATA.                   
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** WRITES THE GAS TEST FILE                                     **        
      ******************************************************************        
       8600-WRITE-GAS-TEST-FILE.                                        
      *                                                                         
           MOVE GAS-TEST-DATA TO FIOMT03-GAS-TEST-REC.                  
           WRITE FIOMT03-GAS-TEST-REC.                                  
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A01209*==============================================================*          
A01209 8700-INSERT-EQUIP-ATT-MOVE.                                      
A01209*==============================================================*          
A01209*--------------------------------------------------------------*          
A01209*   INSERT ROW IN CSS_EQUIP_ATT_MOVE                           *          
A01209*--------------------------------------------------------------*          
A01209*                                                                         
A01209     EXEC SQL                                                     
A01209       INSERT INTO CSS_EQUIP_ATT_MOVE                             
A01209            ( DEVICE_NO                                           
A01209             ,CODE_ATT_TYPE                                       
A01209             ,COMPANY_NO                                          
A01209             ,CODE_UTIL_TYPE                                      
A01209             ,DATE_MOVE                                           
A01209             ,MOVE_NO                                             
A01209             ,MTR_STORAGE_FAC_CD                                  
A01209             ,METER_NO                                            
A01209             ,EQUIP_LOC_ID                                        
A01209             ,REASON_REMOVED_CD )                                 
A01209      VALUES (:MP-DEVICE-NO                                       
A01209             ,:MP-CODE-ATT-TYPE                                   
A01209             ,:MP-COMPANY-NO                                      
A01209             ,:MP-CODE-UTIL-TYPE                                  
A01209             ,IIF(TRY_CONVERT(DATE, :MP-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MP-DATE-MOVE
              ) <> 0) OR (LEN(:MP-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MP-DATE-MOVE
              ), CONVERT(DATE, :MP-DATE-MOVE) )                                
A01209             ,CIS.CURRENT$TIMESTAMP()                                   
A01209             ,:MP-MTR-STORAGE-FAC-CD                              
A01209             ,:MP-METER-NO                                        
A01209             ,:MP-EQUIP-LOC-ID                                    
A01209             ,:MP-REASON-REMOVED-CD )                             
A01209     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_EQUIP_ATT_MOVE                                     
MFA-TR*           ( DEVICE_NO                                                   
MFA-TR*            ,CODE_ATT_TYPE                                               
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,CODE_UTIL_TYPE                                              
MFA-TR*            ,DATE_MOVE                                                   
MFA-TR*            ,MOVE_NO                                                     
MFA-TR*            ,MTR_STORAGE_FAC_CD                                          
MFA-TR*            ,METER_NO                                                    
MFA-TR*            ,EQUIP_LOC_ID                                                
MFA-TR*            ,REASON_REMOVED_CD )                                         
MFA-TR*     VALUES (:MP-DEVICE-NO                                               
MFA-TR*            ,:MP-CODE-ATT-TYPE                                           
MFA-TR*            ,:MP-COMPANY-NO                                              
MFA-TR*            ,:MP-CODE-UTIL-TYPE                                          
MFA-TR*            ,:MP-DATE-MOVE                                               
MFA-TR*            ,CURRENT TIMESTAMP                                           
MFA-TR*            ,:MP-MTR-STORAGE-FAC-CD                                      
MFA-TR*            ,:MP-METER-NO                                                
MFA-TR*            ,:MP-EQUIP-LOC-ID                                            
MFA-TR*            ,:MP-REASON-REMOVED-CD )                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01209*                                                                         
A01209     IF SQLCODE EQUAL SUCCESSFUL-CALL OR -803                     
A01209         CONTINUE                                                 
A01209     ELSE                                                         
A01209         MOVE SQLCODE        TO WS-DISPLAY-RC                     
A01209         DISPLAY '***************PCSMT605****************'        
A01209         DISPLAY '* ERROR IN 8700-INSERT-EQUIP-ATT-MOVE *'        
A01209         DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
A01209         DISPLAY '* MTR NBR ' E-FMT20-METER-NO                    
A01209         DISPLAY '* DEVICE_NO          =' MP-DEVICE-NO            
A01209         DISPLAY '* CODE_ATT_TYPE      =' MP-CODE-ATT-TYPE        
A01209         DISPLAY '* CODE_UTIL_TYPE     =' MP-CODE-UTIL-TYPE       
A01209         DISPLAY '* COMPANY_NO         =' MP-COMPANY-NO           
A01209         DISPLAY '* DATE_MOVE          =' MP-DATE-MOVE            
A01209         DISPLAY '***************PCSMT605****************'        
A01209         PERFORM 9900-ABEND            THRU 9900-EXIT             
A01209     END-IF.                                                      
A01209*                                                                         
A01209 8700-EXIT.                                                       
A01209     EXIT.                                                        
A01209*                                                                         
A01209*==============================================================*          
A01209 8710-UPDATE-EQUIP-ATTCHMTS.                                      
A01209*==============================================================*          
A01209*                                                                         
A01209     EXEC SQL                                                     
A01209         UPDATE CSS_EQUIP_ATTCHMTS                                
A01209         SET EQUIP_LOC_ID       = :LX-EQUIP-LOC-ID                
A01209            ,MTR_STORAGE_FAC_CD = :LX-MTR-STORAGE-FAC-CD          
A01209            ,EQUIP_ATTACH_DT    = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                    
A01209            ,DATE_LAST_MOVE     = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                    
A01209            ,DATE_LAST_TRAN     = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                    
A01209         WHERE   DEVICE_NO          = :LX-DEVICE-NO               
A01209           AND   CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE           
A01209           AND   CODE_UTIL_TYPE     = :LX-CODE-UTIL-TYPE          
A01209           AND   COMPANY_NO         = :LX-COMPANY-NO              
A01209     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_EQUIP_ATTCHMTS                                        
MFA-TR*        SET EQUIP_LOC_ID       = :LX-EQUIP-LOC-ID                        
MFA-TR*           ,MTR_STORAGE_FAC_CD = :LX-MTR-STORAGE-FAC-CD                  
MFA-TR*           ,EQUIP_ATTACH_DT    = CURRENT DATE                            
MFA-TR*           ,DATE_LAST_MOVE     = CURRENT DATE                            
MFA-TR*           ,DATE_LAST_TRAN     = CURRENT DATE                            
MFA-TR*        WHERE   DEVICE_NO          = :LX-DEVICE-NO               03330000
MFA-TR*          AND   CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE                   
MFA-TR*          AND   CODE_UTIL_TYPE     = :LX-CODE-UTIL-TYPE                  
MFA-TR*          AND   COMPANY_NO         = :LX-COMPANY-NO                      
MFA-TR*    END-EXEC.                                                    03380000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01209*                                                                         
A01209     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
A01209         CONTINUE                                                 
A01209     ELSE                                                         
A01209         MOVE SQLCODE        TO WS-DISPLAY-RC                     
A01209         DISPLAY '***************PCSMT605****************'        
A01209         DISPLAY '* ERROR IN 8710-UPDATE-EQUIP-ATTCHMTS *'        
A01209         DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
A01209         DISPLAY '* DEVICE_NO          =' LX-DEVICE-NO            
A01209         DISPLAY '* CODE_ATT_TYPE      =' LX-CODE-ATT-TYPE        
A01209         DISPLAY '* CODE_UTIL_TYPE     =' LX-CODE-UTIL-TYPE       
A01209         DISPLAY '* COMPANY_NO         =' LX-COMPANY-NO           
A01209         DISPLAY '***************PCSMT605****************'        
A01209         PERFORM 9900-ABEND            THRU 9900-EXIT             
A01209     END-IF.                                                      
A01209*                                                                         
A01209 8710-EXIT.                                                       
A01209     EXIT.                                                        
A01209*                                                                         
T35434*================================================================*        
T35434 8800-WRITE-RESTART.                                              
T35434*================================================================*        
T35434*                                                                         
T35434     ADD  1                     TO  WS-CHKP-SEQ-NO.               
T35434     MOVE WS-CHKP-SEQ-NO        TO WS-RESTART-CHKP-SEQ-NO.        
T35434*                                                                         
T35434     MOVE WS-PGRMNAME            TO RF-NAME-PROGRAM.              
T35434     MOVE 1                      TO RF-PARTITION-NO.              
T35434     MOVE 1                      TO RF-DUP-CNTRL-NO.              
T35434     MOVE WS-RESTART-DATA        TO RF-RESTART-DATA-TEXT.         
T35434     MOVE WS-RESTART-DATA-LENGTH TO RF-RESTART-DATA-LEN.          
T35434*                                                                         
T35434     PERFORM 8850-UPDATE-RESTART           THRU 8850-EXIT.        
T35434     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
T35434        PERFORM 8860-INSERT-RESTART        THRU 8860-EXIT         
T35434     END-IF.                                                      
T35434*                                                                         
T35434 8800-EXIT.                                                       
T35434      EXIT.                                                       
T35434*                                                                         
T35434*================================================================*        
T35434 8850-UPDATE-RESTART.                                             
T35434*================================================================*        
T35434*                                                                         
T35434        EXEC SQL                                                  
T35434            UPDATE CSS_RESTART                                    
T35434            SET RESTART_DATA   = :RF-RESTART-DATA                 
T35434            WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                 
T35434              AND PARTITION_NO = :RF-PARTITION-NO                 
T35434              AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                 
T35434        END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35434*                                                                         
T35434        MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.        
T35434*                                                                         
T35434        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
T35434                                       OR NOT-FOUND               
T35434           CONTINUE                                               
T35434        ELSE                                                      
T35434           DISPLAY '**  ERROR ON 8850-UPDATE-RESTART  *'          
T35434           DISPLAY '**  NAME_PROGRAM = ' RF-NAME-PROGRAM          
T35434           DISPLAY '**  PARTITION_NO = ' RF-PARTITION-NO          
T35434           DISPLAY '**  DUP_CNTRL_NO = ' RF-DUP-CNTRL-NO          
T35434           DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
T35434           DISPLAY '**      PROCESSING TERMINATED     **'         
T35434           PERFORM 9900-ABEND            THRU 9900-EXIT           
T35434        END-IF.                                                   
T35434*                                                                         
T35434 8850-EXIT.                                                       
T35434      EXIT.                                                       
T35434*                                                                         
T35434*================================================================*        
T35434 8860-INSERT-RESTART.                                             
T35434*================================================================*        
T35434*                                                                         
T35434        EXEC SQL                                                  
T35434             INSERT INTO CSS_RESTART                              
T35434                         (NAME_PROGRAM                            
T35434                         ,PARTITION_NO                            
T35434                         ,DUP_CNTRL_NO                            
T35434                         ,RESTART_DATA)                           
T35434             VALUES    (:RF-NAME-PROGRAM                          
T35434                       ,:RF-PARTITION-NO                          
T35434                       ,:RF-DUP-CNTRL-NO                          
T35434                       ,:RF-RESTART-DATA)                         
T35434        END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35434*                                                                         
T35434        MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.        
T35434*                                                                         
T35434        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
T35434           CONTINUE                                               
T35434        ELSE                                                      
T35434           DISPLAY '**  ERROR ON 8860-INSERT-RESTART  *'          
T35434           DISPLAY '**  NAME_PROGRAM = ' RF-NAME-PROGRAM          
T35434           DISPLAY '**  PARTITION_NO = ' RF-PARTITION-NO          
T35434           DISPLAY '**  DUP_CNTRL_NO = ' RF-DUP-CNTRL-NO          
T35434           DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
T35434           DISPLAY '**      PROCESSING TERMINATED     **'         
T35434           PERFORM 9900-ABEND            THRU 9900-EXIT           
T35434        END-IF.                                                   
T35434*                                                                         
T35434 8860-EXIT.                                                       
T35434      EXIT.                                                       
T35434*                                                                         
T35434******************************************************************        
T35434* 8893-RESET-RESTART-REQ-PARM                                    *        
T35434******************************************************************        
T35434     EXEC SQL                                                             
T35434         INCLUDE CPD00029                                                 
T35434     END-EXEC.                                                            
T35434*                                                                         
      ****************************************************************          
      **                                                            **          
      **  9000-TERMINATE                                            **          
      **                                                            **          
      ****************************************************************          
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE GAS-METER-FILE                                         
                 FCSPT33-FILE                                           
                 GAS-TEST-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE     **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
