       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSMT604.                                        
       DATE-WRITTEN.   OCT 1994.                                        
       DATE-COMPILED.                                                   
      ****************************************************************          
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL              **          
      **                     PRICE WATERHOUSE                       **          
      **                1410 NORTH WESTSHORE BLVD                   **          
      **                   TAMPA, FLORIDA  33607                    **          
      **                      (813) 287-9200                        **          
      **                                                            **          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                      DB2                       ********          
      ****************************************************************          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      **           DATE    INITIALS       REASON                    **          
      **         ________  ________   _____________________________ **          
TP2838**         03/28/96    DW       LOAD PURCHASE ORDER DATE INTO **          
TP2838**                              TEST DATE FOR ELECRIC METER.  **          
PCR040**         12/27/96    CBSI     REMOVED REFERENCES TO THE     **          
PCR040**                     MADRAS   COLUMNS REG-NO, REG-LOWER-    **          
PCR040**                              FRACTION, REG-UPPER-FRACTION, **          
PCR040**                              WATTS_PER_PULSE FROM          **          
PCR040**                              CSS_ELEC_MTR_SPEC TABLE AS    **          
PCR040**                              THESE COLUMNS ARE DROPPED.    **          
PCR040**                              ALSO REMOVED REFERENCES TO    **          
PCR040**                              DEMAND_INTERVAL COLUMN OF CAP **          
PCR040**                              TABLE, CODE-CO_SIZE OF        **          
PCR040**                              CSS_ELEC_MTR TABLE.           **          
TP4597**           07/97     CBSI     CSS_JOB_PARM CONTAINS ONLY    **          
TP4597**                     MADRAS   LOCAL OFFICE, CODE FOR OTHER  **          
TP4597**                              CHECKINGS IS REMOVED.         **          
TP4597**                              A NEW COPYBOOK IS CREATED FOR **          
TP4597**                              THE I/P FILE LAYOUT. CODE FOR **          
TP4597**                              MOVEMENT HISTORY CREATION,V2H **          
TP4597**                              AMPS,QHR IS REMOVED. CODE FOR **          
TP4597**                              INSERTION OF THE METER DETAILS**          
TP4597**                              INTO WORK QUEUE FOR DUPLICATING*          
TP4597**                              CSS_EQUIPMENT IS ADDED.       **          
T18703**           12/98     CBSI     WQ CATEGORY ID IS CHANGED FROM**          
T18703**                              4 TO 143, ROUTE CATEGORY TO 4 **          
T18703**                              AND PRIORITY TO 'N'.          **          
T19249**           02/99     CBSI     ADDED REPORT FILE TO PRINT THE**          
T19249**                              ERRORS AND RUN STATISTICS     **          
T21650**           02/00     SREENI   CHANGES MADE TO POPULATE      **          
T21650**                              CORRECT CENTURY TO THE DATES. **          
T22243**        08/28/00     CBSI     CHANGES TO IMPLEMENT MULTI-   **          
T22243**                     CHENNAI  COMPANY IN METER-INVENTORY    **          
C26373**        07/29/02     SR82046  CHANGED TO POPULATE PROGRAM ID**          
T26373**                              CORRECTLY.                    **          
T29021**        05/29/03     COVANSYS CHANGE MADE TO HANDLE SCEG    **          
T29021**                     INDIA    CAT 253 FOR MV90 ACCOUNTS     **          
      **                                                            **          
30346 **  13 FEB 2004  RDF   INITIALIZE THE LAST 3 FIELDS OF        **          
30346 **                     WS-CODES-ELEC-ATT-DATA-PRESENT         **          
      **                                                            **          
C33887**  03/13/07  NC94746  ADD METER ATTACHMENTS WHILE INSERTING  **          
C33887**                     METERS INTO METER INVENTORY            **          
T35434**                                                            **          
T35434**  07/05/07  MC95456  IMPELEMENTED RESTART / COMMIT LOGIC    **          
T33887**                                                            **          
T33887**  02/15/08  RC41079  ENHANCED PROGRAM TO ATTACH MULTIPLE (3)**          
T33887**                     ERTS TO A MULTI-REGISTER METER, WHICH  **          
T33887**                     IS IDENTIFIED BY REMOTE-READ-CODE VALUE**          
T33887**                     OF 'M' FROM ELEC_MTR_SPEC TABLE.       **          
T33887**                                                            **          
C37481**  08/06/08  MC95456  CHANGE PROGRAM TO LOAD FULL_SCALE FROM **          
C37481**                     CSS_ELEC_CL_SPEC.                      **          
A00633**  07/08/09  MC95456  REFERENCES OF U5-MTR-CONNECT-TYP-ID,   **          
A00633**                     U5-FULL-SCALE  CHANGED TO              **          
A00633**                     U0-MTR-CONNECT-TYP-ID, U0-FULL-SCALE   **          
A00633**                     RESPECTIVELY.                          **          
P00251** 02/24/10   SS95855  Net Metering                           **          
P00251**                     Synch REG_ID_NO and CODE_CAP_TYPE with **          
P00251**                     CSS_MTR_RD_FMT table.                  **          
P00251** 05/05/10   SS95855  Populate value for MC-CODE-UTIL-TYPE   **          
P00251**                     to fix the abend.                      **          
P00447*  09/13/10  SB40505    ADD CSS_ELEC_CL_SPEC FOR CONSTANT DEFLT*          
P00447*                       IF CT_METER_FL = 'Y' THEN 0 ELSE 1    **          
P00462*  11/19/10   SS95855  SmartSynch                             **          
P00462*                      Enhance program to support SmartSynch  **          
P00462*                      and K-base adapter attachments.        **          
A02790*  11/30/10   SS95855  Meter Inventory Cleanup                **          
A02790*                    - Populate CSS_METER_ATTCHMTS with       **          
A02790*                      correct CODE_DEVICE_TYPE.              **          
A02790*                    - Remove references in CSS_ELEC_MTR_SPEC **          
A02790*                    - Add QUERYNO to SQL's                   **          
A02790*  21/06/11   SS95855  Meter Inventory Cleanup                **          
A02790*                    - Remove UTIL-TYPE from CSS_ELEC_MTR_SPEC**          
A03352*  07/12/11   MC95456  CHANGE WORK QUE CATEGORY FROM 143 TO   **          
A03352*                      528 - SCEG (ROUTING CATEGORY OF 4)     **          
A03352*                      529 - PSNC (ROUTING CATEGORY OF 1)     **          
A04860*  12/17/13   MR7E794  LOAD DIRECTLY CSS_WQ_ITEMS INSTEAD OF  **          
A04860*             ACT001   CSS_WQ_ITEMS_MF BY CALLING SUB PROGRAM **          
A04860*                      SCSCB077                               **          
PRJ914*  10/08/15   SS95855  Openway AMI Metering                   **          
PR#914*  03/10/16   SS95855  Get Constant from CSS_ELEC_CL_SPEC tabl**          
A#4200*  10/10/16   SS95855  Add FERC-ACCT-NO                       **          
      ****************************************************************          
           REMARKS.                                                     
                              PCSMT604 NARRATIVE                        
                       ELECTRIC METER BATCH DATA UPDATE                 
      *                                                                         
                 THIS PROGRAM READS A VENDOR FILE CONTAINING            
                 ELECTRIC METER INFORMATION FOR NEW METERS.  AN EDIT    
                 CHECK IS DONE TO ENSURE THE DATA IS CORRECT.  IF IT    
                 IS THE DATABASE IS UPDATED ACCORDINGLY.  IF PROBLEMS   
TP4597           ARE FOUND IN A RECORD THEY ARE WRITTEN TO THE FCSPT33  
                 FILE AND PROCESSING CONTINUES.  IF AN ERROR OCCURS     
                 WHEN UPDATING THE DATABASE, IT IS WRITTEN TO THE       
TP4597           ERROR FILE AND PROCESSING STOPS.PCSMT605 WILL PRINT    
TP4597           THE ERRORS.                                            
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
TP4597 COPY CSSMT19.                                                            
      *                                                                         
T19249 COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
TP4597 COPY CFDMT19.                                                            
TP4597 COPY FIOMT19.                                                            
      *                                                                         
T19249 COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSMT604'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
             'WORKING STORAGE FOR PCSMT604 STARTS HERE'.                
      *                                                                         
       01  PROGRAM-NAME                PIC X(08)    VALUE 'PCSMT604'.   
A04860 01  SCSCB077                    PIC X(08)    VALUE 'SCSCB077'.   
      *                                                                         
       COPY CWS00005.                                                           
       COPY CWS00303.                                                           
       COPY CWS00018.                                                           
       COPY CWS00021.                                                           
       COPY CWS00026.                                                           
       COPY CWS09900.                                                           
A04860 COPY CWS00010.                                                           
      *                                                                         
       COPY FIOJC01.                                                            
       COPY CCA00003.                                                           
T35434 COPY FIOCA00.                                                            
T35434 COPY CWS00039.                                                           
T35434 COPY CWS00037.                                                           
      *                                                                         
       01  WS-WORK-AREA.                                                
           05  WS-DISPLAY-RC           PIC -ZZZZZZZZ9.9.                
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSMT604'.   
           05  WS-TIMESTAMP-AREA.                                       
               10  WS-DATE-TS          PIC X(10).                       
               10  WS-TIME-TS          PIC X(16)    VALUE               
                                                   '-12.00.00.000000'.  
A04860*                                                                         
A04860     05  RS-RETURN-CODE           PIC S9(09) COMP VALUE +0.       
A04860     05  WS-ITEM-ID               PIC S9(10)V COMP-3 VALUE +0.    
      *                                                                         
           05  COUNTERS.                                                
T18703         10  WS-NBR-METER-RECS   PIC S9(5)     COMP-3 VALUE 0.    
T18703         10  WS-NBR-GOOD-RECS    PIC S9(5)     COMP-3 VALUE 0.    
T18703         10  WS-NBR-BAD-RECS     PIC S9(5)     COMP-3 VALUE 0.    
T18703         10  WS-NO-ADDITION-MTRS PIC S9(5)     COMP-3 VALUE 0.    
      *                                                                         
           05  WS-ERROR-ARRAY-SIZE     PIC S9(04)   COMP VALUE ZEROES.  
           05  WS-LOCAL-OFFICE         PIC X(03).                       
           05  WS-TEST-SCHED-CD        PIC X(01)    VALUE '1'.          
           05  WS-NULL-IND             PIC S9(04)   COMP VALUE ZEROES.  
           05  WS-LOC-NO-NULL          PIC S9(04)   COMP VALUE ZEROES.  
               88  LOC-NO-NULL                      VALUE -1.           
           05  WS-DATE-DISPOSED-OF-NULL                                 
                                       PIC S9(04)   COMP VALUE ZEROES.  
               88  DATE-DISPOSED-OF-NULL            VALUE -1.           
           05  WS-INSTALL-DT-NULL      PIC S9(04)   COMP VALUE ZEROES.  
               88  INSTALL-DT-NULL                  VALUE -1.           
TP4597     05  WS-DATE-LAST-TESTED-NULL                                 
TP4597                                 PIC S9(04)   COMP VALUE ZEROES.  
               88  DATE-LAST-TESTED-NULL            VALUE -1.           
           05  WS-DATE-PURCHASED-NULL  PIC S9(04)   COMP VALUE ZEROES.  
               88  DATE-PURCHASED-NULL              VALUE -1.           
           05  WS-DATE-LAST-TEST-NULL  PIC S9(04)   COMP VALUE ZEROES.  
               88  DATE-LAST-TEST-NULL              VALUE -1.           
TP4597     05  WS-LAST-TEST-SEL-DT-NULL                                 
TP4597                                 PIC S9(04)   COMP VALUE ZEROES.  
TP4597         88  LAST-TEST-SEL-DT-NULL            VALUE -1.           
           05  WS-DATE-LAST-MOVE-NULL  PIC S9(04)   COMP VALUE ZEROES.  
               88  DATE-LAST-MOVE-NULL              VALUE -1.           
           05  WS-DATE-LAST-TRAN-NULL  PIC S9(04)   COMP VALUE ZEROES.  
               88  DATE-LAST-TRAN-NULL              VALUE -1.           
           05  WS-DATE-OBSOLETE-NULL   PIC S9(04)   COMP VALUE ZEROES.  
               88  DATE-OBSOLETE-NULL               VALUE -1.           
           05  WS-WARRANTY-EXP-DT-NULL PIC S9(04)   COMP VALUE ZEROES.  
               88  WARRANTY-EXP-DT-NULL             VALUE -1.           
           05  WS-MFR-DT-NULL          PIC S9(04)   COMP VALUE ZEROES.  
               88 MFR-DT-NULL                       VALUE -1.           
COB305     05 WS-TEMP-VOLTAGE        PIC 9(5) COMP-3 VALUE 0.
COB305         88  VALID-VOLTAGE                    VALUES 120, 240,    
COB305                                                     277, 480.    
      *                                                                         
C33887     05  WS-NULL-INDICATORS.                                      
C33887         10  WS-LX-EQIP-ATT-IND      PIC S9(04) COMP VALUE +0.    
C33887         10  WS-LX-LAST-TRAN-IND     PIC S9(04) COMP VALUE +0.    
C33887         10  WS-LX-PUR-DT-IND        PIC S9(04) COMP VALUE +0.    
C33887         10  WS-LX-WAR-EXP-IND       PIC S9(04) COMP VALUE +0.    
C33887         10  WS-LX-LAST-MOVE-IND     PIC S9(04) COMP VALUE -1.    
C33887         10  WS-LX-LAST-TEST-IND     PIC S9(04) COMP VALUE -1.    
C33887         10  WS-LX-OBSOL-DT-IND      PIC S9(04) COMP VALUE -1.    
C33887         10  WS-LX-DISP-DT-IND       PIC S9(04) COMP VALUE -1.    
C33887         10  WS-MA-LAST-TEST-IND     PIC S9(04) COMP VALUE -1.    
           05  INDEXES.                                                 
               10  WS-ERR-ARRAY-IDX    PIC S9(04)   COMP VALUE ZEROES.  
               10  WS-IDX              PIC S9(08)   COMP VALUE ZEROES.  
               10  WS-IDX2             PIC S9(08)   COMP VALUE ZEROES.  
TP4597         10  WS-SUB              PIC S9(04)   COMP VALUE ZEROES.  
T18703         10  WS-SUB1             PIC S9(04)   COMP VALUE ZEROES.  
T18703         10  WS-DEC-POS          PIC S9(04)   COMP VALUE ZEROES.  
      *                                                                         
           05  FLAGS.                                                   
               10  WS-EOF-FLAG         PIC X(01)    VALUE 'N'.          
                   88  END-OF-FILE                  VALUE 'Y'.          
               10  WS-RECORD-FLAG      PIC X(01)    VALUE 'N'.          
                   88  GOOD-RECORD                  VALUE 'N'.          
               10  WS-METER-FLAG       PIC X(01)    VALUE 'N'.          
                   88  MORE-DATA                    VALUE 'N'.          
                   88  NO-MORE-DATA                 VALUE 'Y'.          
               10  WS-UPDATE-FLAG      PIC X(01)    VALUE 'N'.          
                   88  UPDATE-DATA                  VALUE 'Y'.          
               10  WS-DELETE-FLAG      PIC X(01)    VALUE 'N'.          
                   88  OK-TO-DELETE                 VALUE 'Y'.          
               10  WS-READ-FLAG        PIC X(01)    VALUE 'Y'.          
                   88  FIRST-READ                   VALUE 'Y'.          
               10  WS-ACTIVE-FLAG      PIC X(01)    VALUE 'N'.          
                   88  ACTIVE-CAPABILITY            VALUE 'Y'.          
               10  WS-ADD-FLAG         PIC X(01)    VALUE 'N'.          
                   88  ACTIVE-ADD                   VALUE 'Y'.          
TP4597         10  WS-LOC-OFF-FLAG     PIC X(01)    VALUE 'N'.          
TP4597             88  LOC-OFF-GIVEN                VALUE 'Y'.          
TP4597         10  WS-KH-NOT-NUM-FLAG  PIC X(01)    VALUE 'Y'.          
TP4597             88  KH-NOT-NUMERIC               VALUE 'N'.          
T19249         10  NO-ERROR-FOUND      PIC X(01)    VALUE 'Y'.          
T19249             88  ERROR-FOUND                  VALUE 'N'.          
C26373         10  WS-PGM-ID-EXISTS    PIC X(01)    VALUE 'N'.          
C26373             88  PGM-ID-EXISTS                VALUE 'Y'.          
C33887         10  WS-USE-OF-CHAR-ATT         PIC X(01) VALUE 'N'.      
C33887             88  WS-USE-12-CHAR-ATT               VALUE 'N'.      
C33887             88  WS-USE-09-CHAR-ATT               VALUE 'Y'.      
C33887         10  WS-DTL-MTR-TYP-FND-SW      PIC X(01) VALUE 'N'.      
C33887             88  WS-DTL-MTR-TYP-NOT-FND           VALUE 'N'.      
C33887             88  WS-DTL-MTR-TYP-FND               VALUE 'Y'.      
C33887         05  WS-CODE-VAL-MATCH-SW       PIC X(01) VALUE 'N'.      
C33887             88  WS-CODE-VAL-NOT-MATCHED          VALUE 'N'.      
C33887             88  WS-CODE-VAL-MATCHED              VALUE 'Y'.      
C33887         05  WS-ATTACHMENT-ADD-SW       PIC X(01) VALUE 'Y'.      
C33887             88  WS-ADD-ATTACHMENT                VALUE 'Y'.      
C33887             88  WS-NOT-ADD-ATTACHMENT            VALUE 'N'.      
C33887         05  WS-VALID-ATTACHMENT-SW     PIC X(01) VALUE 'Y'.      
C33887             88  WS-VALID-ATTACHMENT              VALUE 'Y'.      
C33887             88  WS-NOT-VALID-ATTACHMENT          VALUE 'N'.      
C33887         05  WS-ATT-TYPE-EXIST-SW       PIC X(01) VALUE 'Y'.      
C33887             88  WS-ATT-TYPE-NOT-EXISTS           VALUE 'Y'.      
C33887             88  WS-ATT-TYPE-EXISTS               VALUE 'N'.      
      *                                                                         
           05  WS-TEMP-CC              PIC 99.                          
TP4597     05  WS-TEMP1-CC             PIC 99.                          
TP4597     05  WS-WARRANTY-YEAR        PIC 99.                          
           05  WS-REG-RATIO            PIC S9(05)   COMP-3 VALUE ZERO.  
           05  WS-REG-NO               PIC 9(05)    COMP-3 VALUE 0.     
           05  WS-REG-UPPER-FRAC       PIC 9(05)    COMP-3 VALUE 0.     
           05  WS-REG-LOWER-FRAC       PIC 9(05)    COMP-3 VALUE 0.     
           05  WS-CODE-TIME-PERIOD     PIC 9(05)    COMP-3 VALUE 0.     
           05  WS-NO-DIALS             PIC 9(05)    COMP-3 VALUE 0.     
           05  WS-CODE-MAKE            PIC X(02)    VALUE SPACE.        
           05  WS-METER-CAP-EXISTS     PIC X(01)    VALUE 'N'.          
           05  WS-SAVE-TYPE-CAP        PIC X(04).                       
P00251     05  WS-LAST-REG-ID-NO       PIC S9(4)    COMP VALUE +0.      
P00462     05  WS-KH-OR-KE-NUM         PIC 9(4)V9(3).                   
P00462     05  WS-KH-OR-KE             PIC X(05).                       
T18703     05  WS-KH-OR-KE-RED REDEFINES WS-KH-OR-KE.                   
P00462         10  WS-KH-OR-KE-A       PIC X(01) OCCURS 5 TIMES.        
P00462     05  WS-KH-OR-KE-N REDEFINES   WS-KH-OR-KE PIC 999V99.        
TP4597     05  WS-NUMERIC-KH           PIC Z9.99.                       
TP4597     05  WS-KH-VALUE             PIC 99V99    VALUE ZEROES.       
TP4597     05  WS-FACTOR               PIC 9V9      VALUE ZEROES.       
T18703     05  WS-SAVE-MTR-NO          PIC X(09).                       
T18703     05  WS-SAVE-SER-NO          PIC X(08).                       
T19249     05  WS-SAVE-VENDOR-ID       PIC X(02).                       
           05  WS-CODE-GEAR-REDUCTION  PIC 9(03)    VALUE ZEROES.       
           05  WS-SOLID-ST-DIP-SET     PIC 9(05)    COMP-3 VALUE 0.     
           05  WS-CHECK-MEASURES       PIC X(01)    VALUE SPACES.       
           05  WS-NO-CAP-COUNTER       PIC 9(01)    COMP-3 VALUE 0.     
           05  WS-HOLD-CUR-LOC-CODE    PIC X(01)    VALUE SPACES.       
           05  WS-COMP-MULTIPLIER      PIC S9(11)   COMP-3 VALUE ZERO.  
           05  WS-MULTIPLIER           PIC 9(06)V999                    
                                                    VALUE ZEROES.       
           05  WS-CT-PRESENT           PIC X(01)    VALUE 'N'.          
           05  WS-PT-PRESENT           PIC X(01)    VALUE 'N'.          
           05  WS-SYS-DATE.                                             
               10  WS-SYS-DATE-YY      PIC 9(02).                       
               10  WS-SYS-DATE-MM      PIC 9(02).                       
               10  WS-SYS-DATE-DD      PIC 9(02).                       
           05  WS-DB2-TODAYS-DATE      PIC X(10).                       
           05  WS-CRNT-DATE-BREAKDOWN.                                  
               10  WS-CRNT-MM          PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-CRNT-DD          PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-CRNT-YY          PIC 9(02).                       
           05  WS-MAP-DATE-BREAKDOWN   PIC 9(07)    VALUE ZEROES.       
           05  FILLER REDEFINES WS-MAP-DATE-BREAKDOWN.                  
               10  FILLER              PIC X(01).                       
               10  WS-MAP-DATE-YY      PIC 9(02).                       
               10  WS-MAP-DATE-MM      PIC 9(02).                       
               10  WS-MAP-DATE-DD      PIC 9(02).                       
           05  WS-DB2-DATE.                                             
               10  WS-DB2-CC           PIC X(2).                        
               10  WS-DB2-YY           PIC X(2).                        
               10  FILLER              PIC X.                           
               10  WS-DB2-MM           PIC X(2).                        
               10  FILLER              PIC X.                           
               10  WS-DB2-DD           PIC X(2).                        
C33887* TABLE TO STORE VERSION CODE VALUES                                      
C33887     05 WS-VER-CODE-VAL-TAB.                                      
C33887        10 WS-VER-CODE-VAL-ROW OCCURS 50 TIMES                    
C33887                        INDEXED BY WS-VER-INDX.                   
C33887           15 WS-TAB-UTL-CODE-VAL       PIC X(01).                
C33887           15 WS-TAB-ATT-CODE-VAL       PIC X(02).                
C33887           15 WS-TAB-VER-CODE-VAL       PIC X(03).                
C33887* TABLE TO STORE HOW CONNECTED CODE VALUES                                
C33887     05 WS-HOW-CONN-VAL-TAB.                                      
C33887        10 WS-HOW-CONN-VAL-ROW OCCURS 10 TIMES                    
C33887                        INDEXED BY WS-CONN-INDX.                  
C33887           15 WS-TAB-HOW-CONN-VAL       PIC X(01).                
C33887     05  WS-CODE-VALUE           PIC X(10) VALUE SPACES.          
C33887     05  WS-VER-CODE-SUB               PIC 9(02).                 
C33887     05  WS-HOW-CONN-SUB               PIC 9(02).                 
C33887     05  WS-WARRANTY-DB2-DT      PIC X(10).                       
C33887     05  WS-PURCHASE-DB2-DT      PIC X(10).                       
C33887     05  WS-ACTION-DB2-DT        PIC X(10).                       
C33887     05  WS-DB2-DATE-CCYY-MM-DD.                                  
C33887         10  WS-DB2-DATE-CC      PIC X(2).                        
C33887         10  WS-DB2-DATE-YY      PIC X(2).                        
C33887         10  FILLER              PIC X VALUE '-'.                 
C33887         10  WS-DB2-DATE-MM      PIC X(2).                        
C33887         10  FILLER              PIC X VALUE '-'.                 
C33887         10  WS-DB2-DATE-DD      PIC X(2).                        
C33887     05  WS-DUMMY-DB2-DT         PIC X(10).                       
C33887     05  WS-WARRANTY-MONTHS      PIC S9(4) COMP VALUE ZEROS.      
C33887     05  WS-COLUMN-NA            PIC X(18) VALUE SPACES.          
C33887     05  WS-TABLE-NA             PIC X(18) VALUE SPACES.          
C33887     05  WS-DB-COMPANY-NO        PIC X(02) VALUE SPACES.          
C33887     05  WS-DB-CODE-UTIL-TYPE    PIC X(01) VALUE SPACES.          
C33887     05  WS-DB-METER-NO          PIC X(12) VALUE SPACES.          
C33887*                                                                         
T33887     05  WS-ATTCHMNT-NO          PIC 9(12).                       
T33887     05  WS-ATTCHMNT-NO1         PIC 9(12).                       
T33887     05  WS-ATTCHMNT-NO2         PIC 9(12).                       
T33887     05  WS-ATT-ERR-TEXT         PIC X(20).                       
           05  WS-KH-OR-KE-VALUE       PIC 9(03)V9999                   
                                                    VALUE ZEROES.       
           05  WS-FULL-SCALE-VALUE     PIC 9(05)V9999                   
                                                    VALUE ZEROES.       
           05  WS-CT-RATIO-BREAKDOWN   PIC 9(05)V99 VALUE 1.            
           05  WS-PT-RATIO-BREAKDOWN   PIC 9(05)V99 VALUE 1.            
           05  WS-HOLD-KEY-VALUE.                                       
               10  WS-HOLD-KEY-08      PIC 9(08)    VALUE ZEROES.       
T21650     05  WS-TEMP-DATE.                                            
T21650         10  WS-TEMP-DATE-YY     PIC 9(02).                       
T21650         10  WS-TEMP-DATE-MM     PIC 9(02).                       
T21650         10  WS-TEMP-DATE-DD     PIC 9(02).                       
P00462     05  WS-TEMP-ATT-TYPE        PIC X(02) VALUE SPACES.          
P00462     05  WS-MISC-ATTACHMENT      PIC X(01) VALUE 'N'.             
P00462         88  ADD-MISC-ATTACHMENT           VALUE 'Y'.             
P00462         88  DO-NOT-ADD-MISC-ATTACHMENT    VALUE 'N'.             
P00462     05  WS-MISC-ATT-TYPE-SW     PIC X(01) VALUE 'N'.             
P00462         88  MISC-ATT-TYPE-EXISTS          VALUE 'Y'.             
P00462         88  MISC-ATT-TYPE-DO-NOT-EXIST    VALUE 'N'.             
P00462     05  WS-ATT-TYPE-SMARTSYNCH  PIC X(02) VALUE 'SS'.            
P00462     05  WS-FRMT-ATT             PIC X(12) VALUE SPACES.          
P00462     05  WS-FRMT-SERIAL-NO       PIC X(11) VALUE SPACES.          
A02790     05  WS-ATT-CODE-DEV-TYPE    PIC X(01) VALUE ' '.             
A02790     05  WS-MISC-ATT-CODE-DEV-TYPE                                
A02790                                 PIC X(01) VALUE ' '.             
      *                                                                         
       01  MAX-MAKE-ENTRIES            PIC S9(03)   VALUE +9.           
      *                                                                         
       01  MANUFACTURER-CODES.                                          
           05 FILLER                   PIC X(01)    VALUE '1'.          
           05 FILLER                   PIC X(02)    VALUE 'GE'.         
           05 FILLER                   PIC X(01)    VALUE '2'.          
           05 FILLER                   PIC X(02)    VALUE 'AB'.         
           05 FILLER                   PIC X(01)    VALUE '3'.          
           05 FILLER                   PIC X(02)    VALUE 'SO'.         
           05 FILLER                   PIC X(01)    VALUE '4'.          
           05 FILLER                   PIC X(02)    VALUE 'DN'.         
           05 FILLER                   PIC X(01)    VALUE '5'.          
           05 FILLER                   PIC X(02)    VALUE 'PS'.         
           05 FILLER                   PIC X(01)    VALUE '6'.          
           05 FILLER                   PIC X(02)    VALUE 'SC'.         
           05 FILLER                   PIC X(01)    VALUE '7'.          
           05 FILLER                   PIC X(02)    VALUE 'TD'.         
           05 FILLER                   PIC X(01)    VALUE '8'.          
           05 FILLER                   PIC X(02)    VALUE 'AT'.         
           05 FILLER                   PIC X(01)    VALUE '9'.          
           05 FILLER                   PIC X(02)    VALUE 'DA'.         
       01  MANUFACTURER-R REDEFINES MANUFACTURER-CODES.                 
           05  MANF-GROUP OCCURS 9 TIMES INDEXED BY MANF-INDX.          
               10 MANF-CODE            PIC X(01).                       
               10 MANF-ABBREV          PIC X(02).                       
      *                                                                         
       01  WS-LITERALS.                                                 
T19249     05  WS-ONE                  PIC 9(01)    VALUE 1.            
TP4597     05  WS-CMP-NO               PIC X(02)    VALUE '01'.         
T19249     05  WS-TWO                  PIC 9(01)    VALUE 2.            
T19249     05  WS-THREE                PIC 9(01)    VALUE 3.            
T19249     05  WS-SIX                  PIC 9(01)    VALUE 6.            
T19249     05  WS-FIFTY-SIX            PIC 9(02)    VALUE 56.           
T19249     05  WS-FIFTY-TWO            PIC 9(02)    VALUE 52.           
           05  WS-D                    PIC X(01)    VALUE 'D'.          
           05  WS-E                    PIC X(01)    VALUE 'E'.          
           05  WS-F                    PIC X(01)    VALUE 'F'.          
           05  WS-G                    PIC X(01)    VALUE 'G'.          
           05  WS-H                    PIC X(01)    VALUE 'H'.          
T35434     05  WS-I                    PIC X(01)    VALUE 'I'.          
           05  WS-J                    PIC X(01)    VALUE 'J'.          
           05  WS-M                    PIC X(01)    VALUE 'M'.          
           05  WS-N                    PIC X(01)    VALUE 'N'.          
TP4597     05  WS-R                    PIC X(01)    VALUE 'R'.          
           05  WS-S                    PIC X(01)    VALUE 'S'.          
           05  WS-T                    PIC X(01)    VALUE 'T'.          
TP4597     05  WS-W                    PIC X(01)    VALUE 'W'.          
           05  WS-X                    PIC X(01)    VALUE 'X'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
P00462     05  WS-Z                    PIC X(01)    VALUE 'Z'.          
           05  WS-YES                  PIC X(03)    VALUE 'YES'.        
           05  WS-NO                   PIC X(03)    VALUE 'NO '.        
           05  WS-KWH                  PIC X(03)    VALUE 'KWH'.        
           05  WS-DEM                  PIC X(03)    VALUE 'DEM'.        
           05  WS-KVR                  PIC X(03)    VALUE 'KVR'.        
           05  WS-QHR                  PIC X(03)    VALUE 'QHR'.        
           05  WS-UNKNOWN              PIC X(08)    VALUE 'UNKNOWN '.   
           05  WS-ZEROES               PIC X(03)    VALUE '000'.        
           05  WS-FOUND                PIC X(01)    VALUE 'N'.          
T22243     05  WS-01                   PIC X(02)    VALUE '01'.         
P00251     05  WS-1                    PIC X(01)    VALUE '1'.          
      *                                                                         
T22243 01  WS-SYSIN-COMP-NO            PIC X(02) VALUE SPACES.          
      *                                                                         
       01  ERROR-HOLD-AREA.                                             
           05  ERROR-ARRAY OCCURS 100 TIMES.                            
               10  ERR-VENDOR          PIC X(02).                       
               10  ERR-METER-NBR       PIC X(09).                       
C33887         10  ERR-SERIAL-NBR      PIC X(11).                       
               10  ERR-FIELD           PIC X(20).                       
               10  ERR-PROBLEM         PIC X(43).                       
      *                                                                         
       01  WS-ERROR-MSG-BUILD.                                          
           05  MSG-METER-NO            PIC 9(07).                       
           05  MSG-METER-ERROR         PIC X(25).                       
      *                                                                         
T19249 01  WS-HDR-ONE.                                                  
T19249     05 FILLER                   PIC X(08)  VALUE                 
T19249        'PCSMT604'.                                               
T19249     05 FILLER                   PIC X(39)  VALUE SPACES.         
T22243     05 WS-COMPANY-NAME          PIC X(39)  VALUE SPACES.         
T19249     05 FILLER                   PIC X(30)  VALUE SPACES.         
T19249     05 FILLER                   PIC X(06)  VALUE                 
T19249        'PAGE: '.                                                 
T19249     05 FILLER                   PIC X(06)  VALUE SPACES.         
T19249     05 WS-DET-PAGE              PIC ZZZZ   VALUE SPACES.         
T19249*                                                                         
T19249 01  WS-HDR-TWO.                                                  
T19249     05 FILLER                   PIC X(50)  VALUE SPACES.         
T19249     05 FILLER                   PIC X(30)  VALUE                 
T19249        'ELECTRIC METER ADDITION ERRORS'.                         
T19249     05 FILLER                   PIC X(36)  VALUE SPACES.         
T19249     05 FILLER                   PIC X(06)  VALUE                 
T19249        'DATE: '.                                                 
C33887     05 WS-RUN-DATE              PIC X(10) VALUE SPACES.          
T19249*                                                                         
T19249 01  WS-HDR-THREE.                                                
T19249     05 FILLER                   PIC X(05)  VALUE SPACES.         
T19249     05 FILLER                   PIC X(09)  VALUE                 
T19249        'VENDOR ID'.                                              
T19249     05 FILLER                   PIC X(05)  VALUE SPACES.         
T19249     05 FILLER                   PIC X(08)  VALUE                 
T19249        'METER NO'.                                               
T19249     05 FILLER                   PIC X(05)  VALUE SPACES.         
T19249     05 FILLER                   PIC X(09)  VALUE                 
T19249        'SERIAL NO'.                                              
C33887     05 FILLER                   PIC X(08)  VALUE SPACES.         
T19249     05 FILLER                   PIC X(11)  VALUE                 
T19249        'ERROR FIELD'.                                            
T19249     05 FILLER                   PIC X(20)  VALUE SPACES.         
T19249     05 FILLER                   PIC X(12)  VALUE                 
T19249        'PROBLEM DESC'.                                           
T19249*                                                                         
T19249 01  WS-FOOT-LINE.                                                
T19249     05 FILLER                           PIC X(55)  VALUE SPACES. 
T19249     05 FILLER                           PIC X(22)  VALUE         
T19249        '*** END OF  REPORT ***'.                                 
T19249     05 FILLER                           PIC X(55)  VALUE SPACES. 
T19249*                                                                         
T19249 01  WS-NO-ERROR-LINE.                                            
T19249     05 FILLER                           PIC X(55)  VALUE SPACES. 
T19249     05 FILLER                           PIC X(23)  VALUE         
T19249        '*** NO ERRORS FOUND ***'.                                
T19249     05 FILLER                           PIC X(54)  VALUE SPACES. 
T19249*                                                                         
HPCCDM*SKIP1                                                                    
T19249*                                                                         
T19249 01 WS-DET-LINE-1.                                                
T19249    05  FILLER                   PIC X(08)  VALUE SPACES.         
T19249    05  WS-RPT-VENDOR-ID         PIC X(02).                       
T19249    05  FILLER                   PIC X(09)  VALUE SPACES.         
T19249    05  WS-RPT-METER-NO          PIC X(09).                       
T19249    05  FILLER                   PIC X(04)  VALUE SPACES.         
T19249    05  WS-RPT-SERIAL-NO         PIC X(11).                       
T19249    05  FILLER                   PIC X(06)  VALUE SPACES.         
T19249    05  WS-RPT-ERROR-FIELD       PIC X(20).                       
T19249    05  FILLER                   PIC X(11)  VALUE SPACES.         
T19249    05  WS-RPT-PROBLEM-DESC      PIC X(43).                       
HPCCDM*SKIP1                                                                    
T19249*                                                                         
T19249 01 WS-DET-LINE-2.                                                
T19249    05  FILLER                   PIC X(05)  VALUE SPACES.         
T19249    05  WS-RPT-MESSAGE           PIC X(20)  VALUE SPACES.         
T19249    05  FILLER                   PIC X(03)                        
T19249        VALUE ':  '.                                              
T19249    05  WS-RPT-STATISTICS        PIC ZZZZ9  VALUE SPACES.         
T19249*                                                                         
T19249 01  WS-ERROR-RPT-MSGS.                                           
T19249     05 WS-TOT-RECDS-INFO        PIC X(18)    VALUE               
T19249        ' TOTAL I/P RECORDS'.                                     
T19249     05 WS-TOT-GOOD-RECDS        PIC X(13)    VALUE               
T19249        ' GOOD RECORDS'.                                          
T19249     05 WS-TOT-BAD-RECDS         PIC X(12)    VALUE               
T19249        ' BAD RECORDS'.                                           
T19249     05 WS-TOT-UNADDED-MTRS      PIC X(17)    VALUE               
T19249        ' NOT ADDED METERS'.                                      
T19249*                                                                         
T19249 01  WS-VARIABLES.                                                
T19249     05 WS-LINE-CNTR                     PIC 9(02)  VALUE 57.     
T19249     05 WS-BLANK-LINE                    PIC X(132) VALUE SPACES. 
T19249     05 WS-PAGE                          PIC 9(04)  VALUE ZEROS.  
T19249     05 WS-LINE-SPACE                    PIC 9(01)  VALUE ZERO.   
T19249*                                                                         
TP4597 01  WS-WQ-COMMENTS.                                              
T18703     05  WS-WQ-COMMENTS-LEN   PIC S9(4) USAGE COMP VALUE +84.     
TP4597     05  WS-WQ-COMMENTS-TEXT.                                     
T18703         10  FILLER           PIC X(15) VALUE 'ELECTRIC METER '.  
TP4597         10  WS-WQ-METER-NO   PIC X(09).                          
T18703         10  FILLER           PIC X(01) VALUE SPACES.             
T18703         10  FILLER           PIC X(42) VALUE                     
T18703         'EXISTS ON CSS_EQUIPMENT. CAN NOT ADD FROM '.            
T18703         10  FILLER           PIC X(17) VALUE                     
T18703         'VENDOR/TEST FILE.'.                                     
      *                                                                         
T35434 01  WS-RESTART-MISC.                                             
T35434     05  WS-COUNT-UNSUCCESSFUL-ROWS                               
T35434                                     PIC S9(04) COMP-3 VALUE ZERO.
T35434     05  WS-RESTART-DATA-LENGTH    PIC S9(04)  COMP VALUE +39.    
T35434     05  WS-IS-THIS-A-RESTART      PIC X(01)   VALUE 'N'.         
T35434         88  WS-THIS-IS-A-RESTART              VALUE 'Y'.         
T35434     05  WS-RESTART-COMMIT-COUNTER PIC 9(04)   VALUE ZERO.        
T35434     05  WS-RESTART-REQ            PIC X(01).                     
T35434     05  WS-DEFAULT-RESTART-REQ    PIC X(01)   VALUE 'N'.         
T35434     05  WS-PROCESS-TYPE           PIC 9(01).                     
T35434     05  WS-DEFAULT-CHKP-LUW-LIMIT PIC 9(04)   VALUE 4.           
T35434     05  WS-FLAG-TO-TURN-OFF-COMMITS PIC 9(04) VALUE 9999.        
T35434     05  WS-SEQ-NO                 PIC 9(04)   VALUE ZERO.        
T35434     05  WS-CHKP-LUW-LIMIT         PIC 9(04)   VALUE ZERO.        
T35434     05  WS-CHKP-LUW-COUNTER       PIC 9(04)   VALUE ZERO COMP-3. 
T35434     05  WS-DEFAULT-CHKP-UPD-LIMIT PIC 9(04)   VALUE 20.          
T35434     05  WS-CHKP-UPD-LIMIT         PIC 9(04)   VALUE ZERO.        
T35434     05  WS-COMMIT-REQ-SW          PIC X(1)    VALUE 'Y'.         
T35434         88 WS-COMMITS-REQUIRE                 VALUE 'Y'.         
T35434         88 WS-COMMITS-NOT-REQUIRE             VALUE 'N'.         
T35434     05  WS-CHKP-UPD-COUNTER       PIC 9(04)   VALUE ZERO COMP-3. 
T35434     05  WS-CHKP-ID.                                              
T35434         10 WS-CHKP-PGM-ID         PIC X(02)   VALUE '09'.        
T35434         10 WS-CHKP-PART-NO        PIC 9(01)   VALUE 1.           
T35434         10 WS-CHKP-SEQ-NO         PIC 9(05)   VALUE ZERO.        
T35434*                                                                         
T35434 01  WS-RESTART-DATA.                                             
T35434     05  WS-RESTART-PROCESS-TYPE   PIC 9(01).                     
T35434     05  WS-RESTART-JOB-COMPLETE   REDEFINES                      
T35434         WS-RESTART-PROCESS-TYPE   PIC X(01).                     
T35434     05  WS-RESTART-JOB-STATUS     PIC X(01).                     
T35434         88  WS-RUN-COMPLETED-NO-PROBLEMS      VALUE 'A'.         
T35434         88  WS-RERUN-COMPLETED                VALUE 'B'.         
T35434         88  WS-RERUN-PENDING                  VALUE 'C'.         
T35434     05  WS-RESTART-CHKP-SEQ-NO     PIC 9(05).                    
T35434     05  WS-FMT19-METER-NO          PIC X(09).                    
T35434     05  WS-FMT19-METER-SERIAL-NBR  PIC X(11).                    
T35434     05  WS-RESTART-FIOMT19-REC-CNTR                              
T35434                                   PIC S9(07)  COMP-3 VALUE ZERO. 
T35434     05  WS-RESTART-GOOD-REC-CNTR                                 
T35434                                   PIC S9(07)  COMP-3 VALUE ZERO. 
T35434     05  WS-RESTART-BAD-REC-CNTR                                  
T35434                                   PIC S9(07)  COMP-3 VALUE ZERO. 
       COPY CWS00038.                                                           
      *                                                                         
       01  WS-PARAMETER-DATA REDEFINES WS-INPUT-DATA-BREAKDOWN.         
TP4597     05  WS-PARAMETER-NAME       PIC X(13).                       
TP4597         88  LOCAL-OFF-DATA                   VALUE               
TP4597                                           'LOCAL-OFFICE='.       
           05  WS-PARAMETER-VALUE      PIC X(10).                       
           05  FILLER REDEFINES WS-PARAMETER-VALUE.                     
TP4597         10  LOCAL-OFF-VALUE     PIC X(02).                       
               10                      PIC X(08).                       
      *                                                                         
C33887 01  WS-ATT-PARM-DATA REDEFINES WS-INPUT-DATA-BREAKDOWN.          
C33887     05  WS-ATT-PARM-NAME        PIC X(17).                       
C33887         88  ATT-NBR-XPND-DATA                VALUE               
C33887                                        'ATT NBR EXPANDED='.      
C33887     05  WS-ATT-PARM-VALUE       PIC X(01).                       
C33887         88  ATT-NBR-12-CHAR                VALUE 'Y'.            
C33887         88  ATT-NBR-09-CHAR                VALUE 'N'.            
C33887     05  FILLER                  PIC X(15).                       
      *                                                                         
       COPY CWS00057.                                                           
      *                                                                         
A04860******************************************************************        
A04860* WORKING STORAGE COPYBOOK FOR SCSCB077                          *        
A04860******************************************************************        
A04860*                                                                         
A04860     EXEC SQL                                                             
A04860        INCLUDE CWS00077                                                  
A04860     END-EXEC.                                                            
A04860*                                                                         
      ***  INCLUDE DCLGEN TABLE AND HOST VARIABLE DEFINITIONS                   
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      *                                                                         
C33887     EXEC SQL                                                             
C33887         INCLUDE TBEQMAKE                                                 
C33887     END-EXEC.                                                            
C33887*                                                                         
           EXEC SQL                                                             
               INCLUDE TBELMTR                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRCAP                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRATT                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEMTRSP                                                 
           END-EXEC.                                                            
      *                                                                         
C37481     EXEC SQL                                                             
C37481         INCLUDE TBELCLSP                                                 
C37481     END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEMTRCL                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
TP4597     EXEC SQL                                                             
TP4597         INCLUDE TBMTRFAC                                                 
TP4597     END-EXEC.                                                            
TP4597*                                                                         
T22243     EXEC SQL                                                             
T22243         INCLUDE TBCOMPNY                                                 
T22243     END-EXEC.                                                            
T26373*CSS_METER_PGM                                                            
T26373     EXEC SQL                                                             
T26373         INCLUDE TBMTRPGM                                                 
T26373     END-EXEC.                                                            
T26373*                                                                         
C33887     EXEC SQL                                                             
C33887         INCLUDE TBEQATTH                                                 
C33887     END-EXEC.                                                            
C33887*                                                                         
C33887     EXEC SQL                                                             
C33887         INCLUDE TBMTRATP                                                 
C33887     END-EXEC.                                                            
C33887*                                                                         
C33887     EXEC SQL                                                             
C33887         INCLUDE TBTSTSCH                                                 
C33887     END-EXEC.                                                            
C33887*                                                                         
T35434     EXEC SQL                                                             
T35434         INCLUDE TBRESTRT                                                 
T35434     END-EXEC.                                                            
T35434*                                                                         
P00251*** CSS_MTR_RD_FMT                                                        
P00251     EXEC SQL                                                             
P00251         INCLUDE TBRDFMT                                                  
P00251     END-EXEC.                                                            
P00251*                                                                         
C33887*****************************************************************         
C33887**   SQL DECLARE STATEMENTS                                    **         
C33887*****************************************************************         
C33887*----------------------------------------------------------------*        
C33887* CURSOR TO GET EXISTING EQUIP ATTACHMENTS FOR VALIDATION                 
C33887*----------------------------------------------------------------*        
C33887     EXEC SQL                                                     
C33887         DECLARE EQUIP-ATTCHMTS CURSOR FOR                        
C33887         SELECT  CODE_UTIL_TYPE                                   
C33887                ,COMPANY_NO                                       
C33887                ,REPLICATE(' ', 9)                                        
C33887         FROM    CSS_EQUIP_ATTCHMTS WITH(READUNCOMMITTED)                 
C33887         WHERE   DEVICE_NO          = :LX-DEVICE-NO               
C33887           AND   CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE           
C33887         FOR READ ONLY                                    
A02790                                                      
C33887     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE EQUIP-ATTCHMTS CURSOR FOR                                
MFA-TR*        SELECT  CODE_UTIL_TYPE                                           
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,SPACE(9)                                                 
MFA-TR*        FROM    CSS_EQUIP_ATTCHMTS                                       
MFA-TR*        WHERE   DEVICE_NO          = :LX-DEVICE-NO                       
MFA-TR*          AND   CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE                   
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7310                                                     
MFA-TR*    END-EXEC.                                                            
C33887/                                                                         
C33887*----------------------------------------------------------------*        
C33887* CURSOR TO GET EXISTING METER ATTACHMENTS FOR VALIDATION                 
C33887*----------------------------------------------------------------*        
C33887     EXEC SQL                                                     
C33887         DECLARE METER-ATTCHMTS CURSOR FOR                        
C33887         SELECT  CODE_UTIL_TYPE                                   
C33887                ,COMPANY_NO                                       
C33887                ,METER_NO                                         
C33887         FROM    CSS_METER_ATTCHMTS WITH(READUNCOMMITTED)                 
C33887         WHERE   DEVICE_NO          = :MA-DEVICE-NO               
C33887           AND   CODE_ATT_TYPE      = :MA-CODE-ATT-TYPE           
C33887         FOR READ ONLY                                    
A02790                                                      
C33887     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE METER-ATTCHMTS CURSOR FOR                                
MFA-TR*        SELECT  CODE_UTIL_TYPE                                           
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,METER_NO                                                 
MFA-TR*        FROM    CSS_METER_ATTCHMTS                                       
MFA-TR*        WHERE   DEVICE_NO          = :MA-DEVICE-NO                       
MFA-TR*          AND   CODE_ATT_TYPE      = :MA-CODE-ATT-TYPE                   
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7340                                                     
MFA-TR*    END-EXEC.                                                            
C33887/                                                                         
C33887*----------------------------------------------------------------*        
C33887* CURSOR TO GET DATA FROM CODE_VALUE TABLE FOR MULTIPLE PURPOSES          
C33887*----------------------------------------------------------------*        
C33887     EXEC SQL                                                     
C33887         DECLARE CODE_VAL_CSR CURSOR FOR                          
C33887             SELECT CODE_VALUE                                    
C33887              FROM  CSS_CODE_VALUE WITH(READUNCOMMITTED)                  
C33887             WHERE COMPANY_NO = :WS-CMP-NO                        
C33887               AND TABLE_NA   = :WS-TABLE-NA                      
C33887               AND COLUMN_NA  = :WS-COLUMN-NA                     
C33887               AND PROGRAM_ID = 'ALL'                             
C33887             FOR READ ONLY                                
A02790                                                      
C33887     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CODE_VAL_CSR CURSOR FOR                                  
MFA-TR*            SELECT CODE_VALUE                                            
MFA-TR*             FROM  CSS_CODE_VALUE                                        
MFA-TR*            WHERE COMPANY_NO = :WS-CMP-NO                                
MFA-TR*              AND TABLE_NA   = :WS-TABLE-NA                              
MFA-TR*              AND COLUMN_NA  = :WS-COLUMN-NA                             
MFA-TR*              AND PROGRAM_ID = 'ALL'                                     
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7800                                                     
MFA-TR*    END-EXEC.                                                            
C33887***                                                                       
P00251*----------------------------------------------------------------*        
P00251* Cursor to get REG_ID_NO and CODE_CAP_TYPE from CSS_MTR_RD_FMT           
P00251*----------------------------------------------------------------*        
P00251     EXEC SQL                                                     
P00251         DECLARE READ_FMT_CSR CURSOR FOR                          
P00251             SELECT OA.CODE_CAP_TYPE                              
P00251                   ,OA.REG_ID_NO                                  
P00251                   ,OA.CODE_USAGE_TYPE                            
P00251                   ,OA.NO_READ_DIGITS                             
P00251                   ,OA.MTR_RD_DISP_CD                             
P00251             FROM   CSS_MTR_RD_FMT OA WITH(READUNCOMMITTED)               
P00251           WHERE OA.CODE_UTIL_TYPE     =  'E'                     
P00251             AND OA.DIGTL_MTR_TYPE     =  :OA-DIGTL-MTR-TYPE      
P00251             AND OA.PROGRAM_ID         =  :OA-PROGRAM-ID          
P00251             AND OA.MTR_READ_SOURCE_CD =  :OA-MTR-READ-SOURCE-CD  
P00251             AND OA.REMOTE_READ_IND    =  :OA-REMOTE-READ-IND     
P00251             AND OA.CODE_TOU_SEASN     =  'C'                     
P00251             AND OA.SO_REGISTER_CD     <> 'S'                     
P00251             ORDER BY OA.REG_ID_NO                                
P00251             FOR READ ONLY                                
P00251                                                      
P00251     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE READ_FMT_CSR CURSOR FOR                                  
MFA-TR*            SELECT OA.CODE_CAP_TYPE                                      
MFA-TR*                  ,OA.REG_ID_NO                                          
MFA-TR*                  ,OA.CODE_USAGE_TYPE                                    
MFA-TR*                  ,OA.NO_READ_DIGITS                                     
MFA-TR*                  ,OA.MTR_RD_DISP_CD                                     
MFA-TR*            FROM   CSS_MTR_RD_FMT OA                                     
MFA-TR*          WHERE OA.CODE_UTIL_TYPE     =  'E'                             
MFA-TR*            AND OA.DIGTL_MTR_TYPE     =  :OA-DIGTL-MTR-TYPE              
MFA-TR*            AND OA.PROGRAM_ID         =  :OA-PROGRAM-ID                  
MFA-TR*            AND OA.MTR_READ_SOURCE_CD =  :OA-MTR-READ-SOURCE-CD          
MFA-TR*            AND OA.REMOTE_READ_IND    =  :OA-REMOTE-READ-IND             
MFA-TR*            AND OA.CODE_TOU_SEASN     =  'C'                             
MFA-TR*            AND OA.SO_REGISTER_CD     <> 'S'                             
MFA-TR*            ORDER BY OA.REG_ID_NO                                        
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*       QUERYNO 7210                                                      
MFA-TR*    END-EXEC.                                                            
P00251*                                                                         
       01  WS-END                      PIC X(40)    VALUE               
             'WORKING STORAGE FOR PCSMT604 ENDS HERE  '.                
      *                                                                         
       PROCEDURE DIVISION.                                              
           EXIT.                                                        
      ****************************************************************          
      **                                                            **          
      **  0000-MAINLINE                                             **          
      **      CONTROLS MAIN PATH OF PROGRAM                         **          
      **                                                            **          
      ****************************************************************          
       0000-MAINLINE.                                                   
           DISPLAY 'AT BEGINNING OF PROGRAM'.                           
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
      *                                                                         
           PERFORM 1000-PROCESS-FILE             THRU 1000-EXIT         
               UNTIL END-OF-FILE.                                       
           PERFORM 8900-PRODUCE-SUMMARY-REPORTS  THRU 8900-EXIT.        
T35434*                                                                         
T35434     PERFORM 1900-PROCESS-SUCCESSFUL-JOB   THRU 1900-EXIT.        
T35434*                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0100-INITIALIZATION                                       **          
      **      OPEN FILES, DO FIRST READ OF METER FILE, ACCEPT DATE  **          
      **                                                            **          
      ****************************************************************          
       0100-INITIALIZATION.                                             
      *                                                                         
TP4597     OPEN INPUT FCSMT19-FILE.                                     
T19249     OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
T22243     ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
T22243     IF  WS-SYSIN-COMP-NO EQUAL SPACES OR LOW-VALUES              
T22243         MOVE WS-01              TO WS-SYSIN-COMP-NO              
T22243     END-IF.                                                      
T22243*                                                                         
T22243     MOVE WS-SYSIN-COMP-NO       TO  WS-CMP-NO.                   
T22243     DISPLAY '*************************************'.             
T22243     DISPLAY '* JOB IS RUNNING FOR COMPANY = ', WS-CMP-NO.        
T22243     DISPLAY '*************************************'.             
T22243*                                                                         
T22243     MOVE WS-CMP-NO              TO  C7-COMPANY-NO.               
T22243     PERFORM 7500-SELECT-COMP-NAME                                
T22243                                 THRU 7500-EXIT.                  
T22243     MOVE C7-COMPANY-NAME        TO WS-COMPANY-NAME.              
T22243*                                                                         
C33887     PERFORM 7550-GET-CURRENT-DATE  THRU 7550-EXIT.               
C33887     PERFORM 0300-GET-HOW-CONN-VAL  THRU 0300-EXIT.               
C33887     PERFORM 0400-GET-VER-CODE-VAL  THRU 0400-EXIT.               
C33887*                                                                         
           INITIALIZE ERROR-HOLD-AREA.                                  
      *                                                                         
           PERFORM 8000-INITIALIZE               THRU 8000-EXIT.        
C33887     PERFORM 0200-GET-PARM                 THRU 0200-EXIT.        
T35434*                                                                         
T35434     PERFORM 6253-GET-FJC01-CHKP-LIMIT                            
T35434                                           THRU 6253-EXIT.        
T35434     IF WS-CHKP-LUW-LIMIT = WS-FLAG-TO-TURN-OFF-COMMITS           
T35434        AND WS-CHKP-UPD-LIMIT = WS-FLAG-TO-TURN-OFF-COMMITS       
T35434            SET WS-COMMITS-NOT-REQUIRE TO TRUE                    
T35434            DISPLAY ' '                                           
T35434            DISPLAY '**   ' WS-PGRMNAME ' INFORMATIONAL MSG    **'
T35434            DISPLAY '**   CHKP-LUW AND CHKP-UPD PARMS   **'       
T35434            DISPLAY '** BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS 
T35434                    ', INTERPRETED TO**'                          
T35434            DISPLAY '**  INDICATE THAT INTERIM COMMIT   **'       
T35434            DISPLAY '**   POINTS SHOULD NOT BE TAKEN.   **'       
T35434     END-IF.                                                      
T35434*                                                                         
T35434     PERFORM 6235-GET-FJC01-RESTART-REQ                           
T35434                                           THRU  6235-EXIT.       
T35434     PERFORM 0150-CHECK-RESTART            THRU 0150-EXIT.        
T35434*                                                                         
T35434     PERFORM 0605-VALIDATE-RESTART-REQ     THRU 0605-EXIT.        
T35434*                                                                         
T35434     IF WS-THIS-IS-A-RESTART                                      
T35434        PERFORM 0160-REPOSITION-FILE      THRU 0160-EXIT          
T35434     ELSE                                                         
T35434         MOVE ZEROS              TO WS-NBR-GOOD-RECS              
T35434         MOVE ZEROS              TO WS-NBR-BAD-RECS               
T35434         MOVE ZEROS              TO WS-RESTART-GOOD-REC-CNTR      
T35434         MOVE ZEROS              TO WS-RESTART-BAD-REC-CNTR       
T35434         MOVE ZEROS              TO WS-RESTART-FIOMT19-REC-CNTR   
T35434         MOVE ZEROS              TO WS-RESTART-CHKP-SEQ-NO        
T35434         MOVE ZEROS              TO WS-CHKP-SEQ-NO                
T35434     END-IF.                                                      
T35434*                                                                         
           PERFORM 8100-READ-METER-FILE          THRU 8100-EXIT.        
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T35434*===============================================================*         
T35434 0150-CHECK-RESTART.                                              
T35434*===============================================================*         
T35434*                                                                         
T35434     MOVE 'PCSMT604'                       TO RF-NAME-PROGRAM.    
T35434     MOVE 1                                TO RF-PARTITION-NO.    
T35434     MOVE 1                                TO RF-DUP-CNTRL-NO.    
T35434     PERFORM 7100-SELECT-RESTART           THRU 7100-EXIT.        
T35434     IF WS-ACTIVE-RETURN-CODE              EQUAL SUCCESSFUL-CALL  
T35434        MOVE RF-RESTART-DATA-TEXT          TO WS-RESTART-DATA     
T35434        IF WS-RESTART-PROCESS-TYPE NUMERIC                        
T35434           SET WS-THIS-IS-A-RESTART TO TRUE                       
T35434        END-IF                                                    
T35434     END-IF.                                                      
T35434*                                                                         
T35434 0150-EXIT.                                                       
T35434      EXIT.                                                       
T35434*                                                                         
T35434*================================================================*        
T35434  0160-REPOSITION-FILE.                                           
T35434*================================================================*        
T35434                                                                  
T35434     PERFORM 8100-READ-METER-FILE THRU 8100-EXIT                  
T35434        UNTIL  WS-NBR-METER-RECS   = WS-RESTART-FIOMT19-REC-CNTR. 
T35434     DISPLAY '*******************************************'.       
T35434     DISPLAY '*****  THIS IS A RESTART OF PCSMT604  *****'.       
T35434     DISPLAY '*******************************************'.       
T35434     IF  WS-FMT19-METER-NO          = E-FMT19-METER-NO            
T35434     AND WS-FMT19-METER-SERIAL-NBR  = E-FMT19-METER-SERIAL-NBR    
T35434         DISPLAY '*** REPOSITION SUCCESSFULL ***'                 
T35434         MOVE WS-RESTART-GOOD-REC-CNTR TO WS-NBR-GOOD-RECS        
T35434         MOVE WS-RESTART-BAD-REC-CNTR  TO WS-NBR-BAD-RECS         
T35434         MOVE WS-RESTART-CHKP-SEQ-NO   TO WS-CHKP-SEQ-NO          
T35434     ELSE                                                         
T35434         DISPLAY '***    FAIL TO REPOSITIONING FILE     **'       
T35434         DISPLAY '**      ABEND IN PARAGRAPH 0160       **'       
T35434         PERFORM 9900-ABEND THRU 9900-EXIT                        
T35434     END-IF.                                                      
T35434                                                                  
T35434 0160-EXIT.                                                       
T35434     EXIT.                                                        
T35434*                                                                         
T35434*****************************************************************         
T35434* 0605-VALIDATE-RESTART-REQ                                               
T35434*****************************************************************         
T35434  COPY CPD00030.                                                          
T35434*****************************************************************         
T35434*                                                                         
      ****************************************************************          
      **                                                            **          
      **  0200-GET-PARM                                             **          
      **      READ CSS_JOB_PARM TO GET COMPANY_NO AND CRNT_LOC_NO   **          
TP4597**      AND LOCAL OFFICE                                      **          
      ****************************************************************          
       0200-GET-PARM.                                                   
      *                                                                         
           MOVE WS-PGRMNAME            TO WS-PROGRAM.                   
           MOVE WS-PARM                TO WS-COMMAND.                   
           MOVE ZEROES                 TO WS-SEQUENCE.                  
      *                                                                         
TP4597     INITIALIZE WS-SYSIPT.                                        
           MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
      *                                                                         
           PERFORM 7600-START-FCSJC01            THRU 7600-EXIT.        
           PERFORM 7610-READ-FCSJC01             THRU 7610-EXIT.        
           PERFORM 0250-PROCESS-PARM             THRU 0250-EXIT.        
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0250-PROCESS-PARM                                         **          
      **                                                            **          
      ****************************************************************          
       0250-PROCESS-PARM.                                               
      *                                                                         
C33887     SET WS-USE-12-CHAR-ATT      TO TRUE                          
C33887     PERFORM UNTIL END-OF-SYSIPT                                  
C33887       IF INPUT-ACTIVE                                            
C33887          EVALUATE TRUE                                           
C33887            WHEN LOCAL-OFF-DATA                                   
C33887              MOVE LOCAL-OFF-VALUE TO WS-LOCAL-OFFICE             
C33887              SET LOC-OFF-GIVEN       TO TRUE                     
C33887              DISPLAY '**************************************'    
C33887              DISPLAY '**LOCAL OFFICE PARM RECEIVED      ****'    
C33887              DISPLAY '**LOCAL OFFICE :' WS-LOCAL-OFFICE          
C33887              DISPLAY '**************************************'    
C33887            WHEN OTHER                                            
T35434              CONTINUE                                            
C33887          END-EVALUATE                                            
C33887       END-IF                                                     
C33887       PERFORM 7610-READ-FCSJC01     THRU  7610-EXIT              
C33887     END-PERFORM.                                                 
C33887*                                                                         
C33887     IF LOC-OFF-GIVEN                                             
C33887        MOVE WS-E                         TO W9-CODE-UTIL-TYPE    
C33887        MOVE WS-LOCAL-OFFICE              TO W9-MTR-STORAGE-FAC-CD
C33887        MOVE WS-CMP-NO                    TO W9-COMPANY-NO        
C33887        PERFORM 7530-SELECT-MTR-STORGE-FAC THRU 7530-EXIT         
C33887                                                                  
C33887        IF SQLCODE EQUAL SUCCESSFUL-CALL                          
C33887           CONTINUE                                               
C33887        ELSE                                                      
C33887           DISPLAY '*************PCSMT604*****************'       
C33887           DISPLAY '* LOCAL OFFICE GIVEN IN CSS_JOB_PARM *'       
C33887           DISPLAY '* NOT FOUND IN PARENT TABLE          *'       
C33887           DISPLAY '*     CSS_MTR_STORGE_FAC             *'       
C33887           DISPLAY '* DATA VALUE = ', WS-LOCAL-OFFICE             
C33887           DISPLAY '* PROGRAM ABORTING...                *'       
C33887           DISPLAY '*************PCSMT604*****************'       
C33887           PERFORM 9900-ABEND    THRU 9900-EXIT                   
C33887        END-IF
           END-IF.                                                   
C33887*                                                                         
       0250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C33887*================================================================*        
C33887 0300-GET-HOW-CONN-VAL.                                           
C33887*================================================================*        
C33887     MOVE ZERO TO WS-HOW-CONN-SUB                                 
C33887     INITIALIZE WS-HOW-CONN-VAL-TAB                               
C33887     MOVE 'HOW_ATTACHED_CD'      TO WS-COLUMN-NA                  
C33887     MOVE 'CSS_METER_ATTCHMTS'   TO WS-TABLE-NA                   
C33887     PERFORM 7800-OPEN-CODE-VALUE  THRU 7800-EXIT                 
C33887     PERFORM 7820-FETCH-CODE-VALUE THRU 7820-EXIT                 
C33887*                                                                         
C33887     PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
C33887        ADD +1  TO WS-HOW-CONN-SUB                                
C33887        IF WS-HOW-CONN-SUB > 10                                   
C33887           DISPLAY '***ERROR: ARRAY OVERFLOW         ***'         
C33887           DISPLAY '***PARA:0300-GET-HOW-CONN-VAL    ***'         
C33887           DISPLAY '*** MORE THAN 25 CODE VALUES     ***'         
C33887           DISPLAY '*** COLUMN_NA:' WS-COLUMN-NA    ' **'         
C33887           DISPLAY '*** TABLE-NA :' WS-TABLE-NA     ' **'         
C33887           DISPLAY '*** COMPANY-NO:' WS-CMP-NO ' **'              
C33887           PERFORM 9900-ABEND            THRU 9900-EXIT           
C33887        END-IF                                                    
C33887*                                                                         
C33887        MOVE WS-CODE-VALUE(1:1)  TO                               
C33887                        WS-TAB-HOW-CONN-VAL (WS-HOW-CONN-SUB)     
C33887        PERFORM 7820-FETCH-CODE-VALUE  THRU 7820-EXIT             
C33887     END-PERFORM.                                                 
C33887*                                                                         
C33887     PERFORM 7840-CLOSE-CODE-VALUE THRU 7840-EXIT.                
C33887*                                                                         
C33887 0300-EXIT.                                                       
C33887     EXIT.                                                        
C33887/                                                                         
C33887*================================================================*        
C33887 0400-GET-VER-CODE-VAL.                                           
C33887*================================================================*        
C33887     MOVE ZERO TO WS-VER-CODE-SUB                                 
C33887     INITIALIZE WS-VER-CODE-VAL-TAB                               
C33887     MOVE 'VERSION_CD'           TO WS-COLUMN-NA                  
C33887     MOVE 'CSS_EQUIP_ATTCHMTS'   TO WS-TABLE-NA                   
C33887     PERFORM 7800-OPEN-CODE-VALUE  THRU 7800-EXIT                 
C33887     PERFORM 7820-FETCH-CODE-VALUE THRU 7820-EXIT                 
C33887*                                                                         
C33887     PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
C33887        ADD +1  TO WS-VER-CODE-SUB                                
C33887        IF WS-VER-CODE-SUB > 50                                   
C33887           DISPLAY '***ERROR: ARRAY OVERFLOW         ***'         
C33887           DISPLAY '***PARA:0400-GET-VER-CODE-VAL    ***'         
C33887           DISPLAY '*** MORE THAN 25 CODE VALUES     ***'         
C33887           DISPLAY '*** COLUMN_NA:' WS-COLUMN-NA    ' **'         
C33887           DISPLAY '*** TABLE-NA :' WS-TABLE-NA     ' **'         
C33887           DISPLAY '*** COMPANY-NO:' WS-CMP-NO ' **'              
C33887           PERFORM 9900-ABEND            THRU 9900-EXIT           
C33887        END-IF                                                    
C33887*                                                                         
C33887        MOVE WS-CODE-VALUE(1:1)  TO                               
C33887                       WS-TAB-UTL-CODE-VAL (WS-VER-CODE-SUB)      
C33887        MOVE WS-CODE-VALUE(2:2)  TO                               
C33887                       WS-TAB-ATT-CODE-VAL (WS-VER-CODE-SUB)      
C33887        MOVE WS-CODE-VALUE(4:3)  TO                               
C33887                       WS-TAB-VER-CODE-VAL (WS-VER-CODE-SUB)      
C33887        PERFORM 7820-FETCH-CODE-VALUE  THRU 7820-EXIT             
C33887     END-PERFORM.                                                 
C33887*                                                                         
C33887     PERFORM 7840-CLOSE-CODE-VALUE THRU 7840-EXIT.                
C33887*                                                                         
C33887 0400-EXIT.                                                       
C33887     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1000-PROCESS-FILE                                         **          
      **      RECEIVE, EDIT, AND PROCESS INPUT                      **          
      **                                                            **          
      ****************************************************************          
       1000-PROCESS-FILE.                                               
      *                                                                         
           PERFORM 2000-EDIT-RECORD              THRU 2000-EXIT.        
      *                                                                         
           IF GOOD-RECORD                                               
               PERFORM 5000-UPDATE               THRU 5000-EXIT         
               ADD 1                   TO WS-NBR-GOOD-RECS              
           ELSE                                                         
               MOVE WS-ERR-ARRAY-IDX   TO WS-ERROR-ARRAY-SIZE           
               PERFORM 6000-ERROR-ROUTINE        THRU 6000-EXIT         
                   VARYING WS-ERR-ARRAY-IDX FROM 1 BY 1                 
                       UNTIL WS-ERR-ARRAY-IDX > WS-ERROR-ARRAY-SIZE     
               ADD 1                   TO WS-NBR-BAD-RECS               
           END-IF.                                                      
      *                                                                         
T35434     ADD 1                          TO WS-RESTART-COMMIT-COUNTER. 
T35434*                                                                         
T35434     PERFORM 1800-PREPARE-PRECOMMIT  THRU 1800-EXIT.              
T35434     IF WS-RESTART-COMMIT-COUNTER >= WS-CHKP-LUW-LIMIT            
T35434        AND WS-COMMITS-REQUIRE                                    
T35434        PERFORM 3000-COMMIT          THRU 3000-EXIT               
T35434        MOVE ZEROES              TO WS-RESTART-COMMIT-COUNTER     
T35434*                                                                         
T35434     END-IF.                                                      
T35434*                                                                         
           PERFORM 8000-INITIALIZE               THRU 8000-EXIT.        
           PERFORM 8100-READ-METER-FILE          THRU 8100-EXIT.        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T35434*===============================================================*         
T35434 1800-PREPARE-PRECOMMIT.                                          
T35434*===============================================================*         
T35434*                                                                         
T35434      MOVE 1                     TO WS-RESTART-PROCESS-TYPE.      
T35434      SET WS-RERUN-PENDING       TO TRUE.                         
T35434      MOVE WS-NBR-METER-RECS     TO WS-RESTART-FIOMT19-REC-CNTR.  
T35434      MOVE WS-NBR-GOOD-RECS      TO WS-RESTART-GOOD-REC-CNTR.     
T35434      MOVE WS-NBR-BAD-RECS       TO WS-RESTART-BAD-REC-CNTR.      
T35434      MOVE E-FMT19-METER-NO      TO WS-FMT19-METER-NO.            
T35434      MOVE E-FMT19-METER-SERIAL-NBR                               
T35434                                 TO WS-FMT19-METER-SERIAL-NBR.    
T35434*                                                                         
T35434 1800-EXIT.                                                       
T35434      EXIT.                                                       
T35434*                                                                         
T35434*==============================================================*          
T35434 1900-PROCESS-SUCCESSFUL-JOB.                                     
T35434*==============================================================*          
T35434*--------------------------------------------------------------*          
T35434* THE FOLLOWING SETTINGS DECLARES SUCCESSFUL COMPLETION OF RUN *          
T35434* AND RESET RE-START CONTROLS IN CASE OF RE-START RUN          *          
T35434*--------------------------------------------------------------*          
T35434     MOVE SPACES                   TO WS-RESTART-JOB-COMPLETE     
T35434     IF  WS-THIS-IS-A-RESTART                                     
T35434         SET WS-RERUN-COMPLETED    TO TRUE                        
T35434     ELSE                                                         
T35434         SET WS-RUN-COMPLETED-NO-PROBLEMS                         
T35434                                   TO TRUE                        
T35434     END-IF.                                                      
T35434*                                                                         
T35434     PERFORM 3000-COMMIT               THRU 3000-EXIT.            
T35434*                                                                         
T35434     IF  WS-RESTART-REQ EQUAL WS-Y                                
T35434         PERFORM 8893-RESET-RESTART-REQ-PARM                      
T35434            THRU 8893-EXIT                                        
T35434     END-IF.                                                      
T35434*                                                                         
T35434 1900-EXIT.                                                       
T35434     EXIT.                                                        
T35434*                                                                         
C33887*================================================================*        
       2000-EDIT-RECORD.                                                
C33887*================================================================*        
      **------------------------------------------------------------**          
      **                                                            **          
      **      EDIT CHECK RECORD FIELDS. IF INVALID, WRITE TO ERROR  **          
      **                                                            **          
C33887**------------------------------------------------------------**          
C33887*** VALIDATE METER SPEC CODE                                  **          
C33887**------------------------------------------------------------**          
C33887     MOVE WS-E                   TO W9-CODE-UTIL-TYPE             
C33887                                    N5-CODE-UTIL-TYPE             
C33887                                    O8-CODE-UTIL-TYPE             
C33887                                    EQ-CODE-UTIL-TYPE             
C33887                                    EM-CODE-UTIL-TYPE             
C33887                                    LX-CODE-UTIL-TYPE             
C33887                                    MA-CODE-UTIL-TYPE.            
TP4597     MOVE E-FMT19-MTR-SPEC-CD    TO U5-ELEC-MTR-SPEC-CD.          
C33887     SET WS-DTL-MTR-TYP-NOT-FND      TO TRUE                      
           PERFORM 7540-SELECT-ELEC-MTR-SPEC     THRU 7540-EXIT.        
C33887     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
C33887        MOVE U5-CODE-MAKE           TO WS-SAVE-VENDOR-ID          
C33887        SET WS-DTL-MTR-TYP-FND      TO TRUE                       
C33887     ELSE                                                         
C33887        PERFORM 2500-LOAD-ERROR-ARRAY THRU 2500-EXIT              
C33887        MOVE 'METER SPEC CODE'   TO ERR-FIELD (WS-ERR-ARRAY-IDX)  
C33887        MOVE 'NOT VALID'         TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
C33887     END-IF                                                       
      *                                                                         
C33887**------------------------------------------------------------**          
C33887*** VALIDATE METER CLASS CODE                                             
C33887**------------------------------------------------------------**          
TP4597     MOVE E-FMT19-MTR-CLASS-CD   TO U4-ELEC-MTR-CLASS-CD.         
           PERFORM 7520-SELECT-ELEC-MTR-CLASS    THRU 7520-EXIT.        
C37481     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
C37481**** GET FULL_SCALE FROM CSS_ELEC_CL_SPEC & VALIDATE THE SAME             
C37481        MOVE E-FMT19-MTR-CLASS-CD TO U0-ELEC-MTR-CLASS-CD         
C37481        MOVE E-FMT19-MTR-SPEC-CD  TO U0-ELEC-MTR-SPEC-CD          
C37481        PERFORM 7541-SELECT-FULL-SCALE     THRU 7541-EXIT         
C37481        IF SQLCODE EQUAL SUCCESSFUL-CALL                          
PR#914           CONTINUE                                               
C37481        ELSE                                                      
C37481           PERFORM 2500-LOAD-ERROR-ARRAY THRU 2500-EXIT           
C37481           MOVE 'FULL SCALE'   TO ERR-FIELD   (WS-ERR-ARRAY-IDX)  
C37481           MOVE 'NOT VALID'    TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)  
C37481        END-IF                                                    
C37481     ELSE                                                         
              PERFORM 2500-LOAD-ERROR-ARRAY THRU 2500-EXIT              
C33887        MOVE 'METER CLASS CODE'  TO ERR-FIELD (WS-ERR-ARRAY-IDX)  
C33887        MOVE 'NOT VALID'       TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)  
           END-IF                                                       
      *                                                                         
TP4597     IF E-FMT19-METER-NO NOT NUMERIC                              
               PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
TP4597         MOVE 'METER NUMBER'     TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
               MOVE 'NOT NUMERIC'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
C33887     IF E-FMT19-METER-SERIAL-NBR EQUAL SPACES OR LOW-VALUES       
C33887        PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT          
C33887        MOVE 'METER SERIAL NUM' TO ERR-FIELD   (WS-ERR-ARRAY-IDX) 
C33887        MOVE 'NOT PRESENT'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX) 
C33887     END-IF.                                                      
      *                                                                         
TP4597     MOVE E-FMT19-KH             TO WS-KH-OR-KE.                  
TP4597     INSPECT WS-KH-OR-KE REPLACING LEADING ' ' BY '0'.            
C33887*    MOVE ZEROS                  TO WS-KH-OR-KE-DET                       
C33887     MOVE ZEROS                  TO WS-DEC-POS.                   
P00462     PERFORM VARYING WS-SUB FROM 1 BY 1 UNTIL WS-SUB > 5          
T18703        IF  WS-KH-OR-KE-A (WS-SUB) EQUAL '.'                      
T18703            MOVE WS-SUB          TO WS-DEC-POS                    
T18703        END-IF                                                    
T18703     END-PERFORM.                                                 
C33887     IF  WS-DEC-POS EQUAL ZEROS AND WS-KH-OR-KE IS NUMERIC        
C33887         MOVE WS-KH-OR-KE-N      TO WS-KH-OR-KE-NUM               
C33887     ELSE                                                         
C33887         PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
C33887         MOVE 'KH-OR-KE'         TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
C33887         MOVE 'NOT NUMERIC'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
C33887     END-IF                                                       
      *                                                                         
TP4597     IF  E-FMT19-NO-OF-DIALS EQUAL '0' OR                         
TP4597                             E-FMT19-NO-OF-DIALS NOT NUMERIC      
               PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
               MOVE 'NO-OF-DIALS'      TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
               MOVE 'NOT NUMERIC'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
C33887*** RETAIN VALIDATION BUT FIELD NOT USING ANY WHERE                       
C33887     IF E-FMT19-COST-PER-METER NOT NUMERIC                        
C33887         PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
C33887         MOVE 'COST PER METER'   TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
C33887         MOVE 'NOT NUMERIC'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
C33887     END-IF.                                                      
      *                                                                         
C33887***  PROGRAM-ID VALIDATION. IT NEEDS DTL METER TYPE FROM SPEC             
C33887     IF WS-DTL-MTR-TYP-FND                                        
C33887        PERFORM 2150-VALIDATE-PGM-ID          THRU 2150-EXIT      
C33887     END-IF.                                                      
C33887*                                                                         
C33887* METER STORAGE FACILITY VALIDATION                                       
C33887     IF E-FMT19-METER-STORAGE-FAC > SPACES                        
C33887        MOVE E-FMT19-METER-STORAGE-FAC                            
C33887                                 TO W9-MTR-STORAGE-FAC-CD         
C33887        MOVE WS-CMP-NO           TO W9-COMPANY-NO                 
C33887        PERFORM 7530-SELECT-MTR-STORGE-FAC THRU 7530-EXIT         
C33887        IF SQLCODE EQUAL NOT-FOUND                                
C33887           PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT       
C33887           MOVE 'MTR STORAGE FACILITY'                            
C33887                                 TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
C33887           MOVE 'NOT VALID'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
C33887        END-IF                                                    
C33887     ELSE                                                         
C33887         IF WS-LOCAL-OFFICE > SPACES                              
C33887            MOVE WS-LOCAL-OFFICE TO E-FMT19-METER-STORAGE-FAC     
C33887         ELSE                                                     
C33887            PERFORM 2500-LOAD-ERROR-ARRAY  THRU 2500-EXIT         
C33887            MOVE 'METER STOR FAC' TO ERR-FIELD (WS-ERR-ARRAY-IDX) 
C33887            MOVE 'NOT PRESENT'  TO ERR-PROBLEM (WS-ERR-ARRAY-IDX) 
C33887         END-IF                                                   
C33887     END-IF                                                       
C33887*                                                                         
C33887     IF E-FMT19-TEST-SCHEDULE > SPACES                            
C33887        MOVE E-FMT19-TEST-SCHEDULE TO M3-TEST-SCHED-CD            
C33887        PERFORM 7660-SELECT-TEST-SCH  THRU 7660-EXIT              
C33887        IF SQLCODE EQUAL NOT-FOUND                                
C33887           PERFORM 2500-LOAD-ERROR-ARRAY THRU 2500-EXIT           
C33887           MOVE 'MTR TEST SCHEDULE'                               
C33887                                 TO ERR-FIELD (WS-ERR-ARRAY-IDX)  
C33887           MOVE 'NOT VALID'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
C33887        END-IF                                                    
C33887     ELSE                                                         
C33887        PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT          
C33887        MOVE 'MTR TEST SCHEDULE' TO ERR-FIELD  (WS-ERR-ARRAY-IDX) 
C33887        MOVE 'NOT PRESENT'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX) 
C33887     END-IF                                                       
C33887* METER WARRANTY PERIOD EDIT, SAME WARRANTY APPLIES TO ATTACHMENT         
C33887     MOVE ZEROS                  TO WS-WARRANTY-MONTHS            
C33887     IF E-FMT19-WARRANTY-MONTHS IS NUMERIC                        
C33887         MOVE E-FMT19-WARRANTY-MONTHS TO WS-WARRANTY-MONTHS       
C33887     ELSE                                                         
C33887         PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
C33887         MOVE 'WARRANTY PERIOD ' TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
C33887         MOVE 'NOT NUMERIC'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
C33887     END-IF.                                                      
C33887*                                                                         
           PERFORM 2200-EDIT-DATES               THRU 2200-EXIT.        
C33887*                                                                         
P00462*** FORMAT METER SERIAL NUMBER TO PREFIL ZEROS.                           
P00462     MOVE SPACES                 TO WS-FRMT-SERIAL-NO.            
P00462     MOVE E-FMT19-METER-SERIAL-NBR TO WS-FRMT-SERIAL-NO.          
P00462     PERFORM 7960-FORMAT-SERIAL-NO                                
P00462        THRU 7960-EXIT.                                           
P00462*                                                                         
C33887*** ALL METERS MAY NOT HAVE ATTACHMENTS, SO SKIP ATTACHMENT AND           
C33887*** ITS VALIDATIONS WHEN ATT NBR/TYPE NOT PRESENT                         
C33887     SET WS-NOT-ADD-ATTACHMENT   TO TRUE                          
C33887     IF E-FMT19-ATTACHMENT-NO > SPACES                            
C33887        OR E-FMT19-ATT-TYPE > SPACES                              
C33887        SET WS-ADD-ATTACHMENT    TO TRUE                          
C33887        PERFORM 2100-VALIDATE-ATT-DTL  THRU 2100-EXIT             
C33887     END-IF.                                                      
P00462*                                                                         
P00462*** ALL METERS MAY NOT HAVE MISC ATTACHMENTS,SO SKIP MISC ATT AND         
P00462*** ITS VALIDATIONS WHEN MISC ATTACHMENT IS NOT PRESENT.                  
P00462     SET DO-NOT-ADD-MISC-ATTACHMENT  TO TRUE.                     
P00462     IF E-FMT19-MISC-ATT-DEV-NO > SPACES                          
P00462        OR E-FMT19-MISC-ATT-TYPE > SPACES                         
P00462        SET ADD-MISC-ATTACHMENT     TO TRUE                       
P00462        PERFORM 2300-VALIDATE-MISC-ATT THRU 2300-EXIT             
P00462     END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C33887*================================================================*        
C33887 2100-VALIDATE-ATT-DTL.                                           
C33887*================================================================*        
C33887*                                                                         
C33887     SET WS-ATT-TYPE-NOT-EXISTS  TO  TRUE                         
C33887     IF E-FMT19-ATT-TYPE > SPACES                                 
C33887        MOVE E-FMT19-ATT-TYPE    TO N5-CODE-ATT-TYPE              
A02790        MOVE SPACES              TO WS-ATT-CODE-DEV-TYPE          
C33887        PERFORM 7020-SELECT-ATTACHMENT-TYPE THRU 7020-EXIT        
C33887        IF SQLCODE EQUAL SUCCESSFUL-CALL                          
C33887           SET WS-ATT-TYPE-EXISTS  TO  TRUE                       
A02790           MOVE N5-CODE-DEVICE-TYPE TO WS-ATT-CODE-DEV-TYPE       
C33887        ELSE                                                      
C33887         PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
C33887         MOVE 'ATTACHMENT TYPE ' TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
C33887         MOVE 'NOT VALID  '      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
C33887        END-IF                                                    
C33887     ELSE                                                         
C33887         PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
C33887         MOVE 'ATTACHMENT TYPE ' TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
C33887         MOVE 'NOT PRESENT'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
C33887     END-IF.                                                      
C33887*                                                                         
P00462*** Format attachment with leading zero                                   
P00462     MOVE SPACES                 TO WS-FRMT-ATT.                  
P00462     MOVE E-FMT19-ATTACHMENT-NO  TO WS-FRMT-ATT.                  
P00462     PERFORM 7950-FORMAT-ATTACHMENT                               
P00462        THRU 7950-EXIT.                                           
P00462     MOVE WS-FRMT-ATT            TO E-FMT19-ATTACHMENT-NO.        
P00462*                                                                         
P00462     MOVE SPACES                 TO WS-TEMP-ATT-TYPE.             
C33887     IF E-FMT19-ATTACHMENT-NO IS NUMERIC                          
C33887        IF WS-ATT-TYPE-EXISTS                                     
C33887           SET WS-VALID-ATTACHMENT  TO TRUE                       
T33887           MOVE E-FMT19-ATTACHMENT-NO  TO WS-ATTCHMNT-NO          
T33887                                          MA-DEVICE-NO            
P00462           MOVE E-FMT19-ATT-TYPE       TO WS-TEMP-ATT-TYPE        
T33887           MOVE ZEROS                  TO WS-ATTCHMNT-NO1         
T33887                                          WS-ATTCHMNT-NO2         
T33887           MOVE 'ATTACHMENT NBR  '     TO WS-ATT-ERR-TEXT         
C33887           PERFORM 2600-VALIDATE-ATTACHMENT  THRU 2600-EXIT       
T33887           IF U5-REMOTE-READ-CODE = 'M' AND WS-VALID-ATTACHMENT   
T33887              PERFORM 2400-VALIDATE-OTHER2-ATT  THRU 2400-EXIT    
T33887           END-IF                                                 
C33887        END-IF                                                    
C33887     ELSE                                                         
C33887        PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT          
C33887        MOVE 'ATTACHMENT NBR  '  TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
C33887        MOVE 'NOT NUMERIC'       TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
C33887     END-IF.                                                      
C33887***  ATTACHMENT MANUFACTURER CODE (CODE ATT MAKE) VALIDATION              
C33887     IF E-FMT19-ATT-MFR-CD > SPACES                               
C33887        MOVE E-FMT19-ATT-MFR-CD TO M2-CODE-MAKE                   
C33887        PERFORM 7200-SELECT-ATTACHMENT-MAKE THRU 7200-EXIT        
C33887        IF SQLCODE EQUAL NOT-FOUND                                
C33887           PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT       
C33887           MOVE 'ATTACHMENT MFR CODE'                             
C33887                                 TO ERR-FIELD  (WS-ERR-ARRAY-IDX) 
C33887           MOVE 'NOT VALID  '    TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
C33887       END-IF                                                     
C33887     ELSE                                                         
C33887         PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
C33887         MOVE 'ATTACHMENT MFR CODE'                               
C33887                                 TO ERR-FIELD  (WS-ERR-ARRAY-IDX) 
C33887         MOVE 'NOT PRESENT'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
C33887     END-IF.                                                      
C33887***  ATTACHMENT TEST SCHEDULE VALIDATION                                  
C33887     IF E-FMT19-ATT-TEST-SCH > SPACES                             
C33887        MOVE E-FMT19-ATT-TEST-SCH TO M3-TEST-SCHED-CD             
C33887        PERFORM 7660-SELECT-TEST-SCH  THRU 7660-EXIT              
C33887        IF SQLCODE EQUAL NOT-FOUND                                
C33887           PERFORM 2500-LOAD-ERROR-ARRAY THRU 2500-EXIT           
C33887           MOVE 'ATT TEST SCHEDULE'                               
C33887                                 TO ERR-FIELD (WS-ERR-ARRAY-IDX)  
C33887           MOVE 'NOT VALID'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
C33887        END-IF                                                    
C33887     ELSE                                                         
C33887        PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT          
C33887        MOVE 'ATT TEST SCHEDULE' TO ERR-FIELD  (WS-ERR-ARRAY-IDX) 
C33887        MOVE 'NOT PRESENT'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX) 
C33887     END-IF                                                       
C33887***  AMR MODULE CONNECT TYPE (HOW-ATTACHED-CD) VALIDATION                 
C33887     IF E-FMT19-ATT-CONN-TYPE > SPACES                            
C33887        SET WS-CODE-VAL-NOT-MATCHED TO TRUE                       
C33887        PERFORM VARYING WS-CONN-INDX FROM 1 BY 1                  
C33887           UNTIL WS-CONN-INDX > WS-HOW-CONN-SUB                   
C33887            OR WS-CODE-VAL-MATCHED                                
C33887            OR WS-TAB-HOW-CONN-VAL (WS-CONN-INDX) = SPACES        
C33887           IF WS-TAB-HOW-CONN-VAL (WS-CONN-INDX)                  
C33887                                = E-FMT19-ATT-CONN-TYPE           
C33887              SET WS-CODE-VAL-MATCHED TO TRUE                     
C33887           END-IF                                                 
C33887        END-PERFORM                                               
C33887        IF WS-CODE-VAL-NOT-MATCHED                                
C33887           PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT       
C33887           MOVE 'ATT CONNECTION TYPE'                             
C33887                                 TO ERR-FIELD (WS-ERR-ARRAY-IDX)  
C33887           MOVE 'NOT VALID'    TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)  
C33887        END-IF                                                    
C33887     ELSE                                                         
C33887        PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT          
C33887        MOVE 'ATT CONNECTION TYPE'                                
C33887                                TO ERR-FIELD   (WS-ERR-ARRAY-IDX) 
C33887        MOVE 'NOT PRESENT'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX) 
C33887     END-IF.                                                      
C33887***  ATTACHMENT VERSION CODE VALIDATION                                   
C33887     IF E-FMT19-ATT-VER-CD > SPACES                               
C33887        SET WS-CODE-VAL-NOT-MATCHED TO TRUE                       
C33887        PERFORM VARYING WS-VER-INDX FROM 1 BY 1                   
C33887           UNTIL WS-VER-INDX > WS-VER-CODE-SUB                    
C33887            OR WS-CODE-VAL-MATCHED                                
C33887            OR WS-TAB-UTL-CODE-VAL (WS-VER-INDX) = SPACES         
C33887           IF WS-TAB-UTL-CODE-VAL (WS-VER-INDX)                   
C33887                                = WS-E                            
C33887            AND WS-TAB-ATT-CODE-VAL (WS-VER-INDX)                 
C33887                                = E-FMT19-ATT-TYPE                
C33887            AND WS-TAB-VER-CODE-VAL (WS-VER-INDX)                 
C33887                                = E-FMT19-ATT-VER-CD              
C33887              SET WS-CODE-VAL-MATCHED TO TRUE                     
C33887           END-IF                                                 
C33887        END-PERFORM                                               
C33887        IF WS-CODE-VAL-NOT-MATCHED                                
C33887           PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT       
C33887           MOVE 'ATTACHMENT VER CD'                               
C33887                                 TO ERR-FIELD (WS-ERR-ARRAY-IDX)  
C33887           MOVE 'NOT VALID'    TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)  
C33887        END-IF                                                    
C33887     ELSE                                                         
C33887        PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT          
C33887        MOVE 'ATTACHMENT VER CD' TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
C33887        MOVE 'NOT PRESENT'       TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
C33887     END-IF.                                                      
P00462*                                                                         
P00462***** CHECK IF IT'S SMARTSYNCH AND HAS A SERIAL NUMBER                    
P00462     IF E-FMT19-ATT-TYPE = WS-ATT-TYPE-SMARTSYNCH                 
P00462        IF E-FMT19-ATT-SERIAL-NBR EQUAL SPACES OR LOW-VALUES      
P00462           PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT       
P00462           MOVE 'SMARTSYNCH SERIAL NUM'                           
P00462                              TO ERR-FIELD (WS-ERR-ARRAY-IDX)     
P00462           MOVE 'NOT PRESENT' TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)   
P00462        END-IF                                                    
P00462     END-IF.                                                      
      *                                                                         
C33887 2100-EXIT.                                                       
C33887     EXIT.                                                        
      *                                                                         
C26373****************************************************************          
C26373**                                                            **          
C26373**  2150-VALIDATE-PGM-ID.                                     **          
C26373****************************************************************          
C26373*                                                                         
C26373 2150-VALIDATE-PGM-ID.                                            
C26373*                                                                         
C26373     IF E-FMT19-PROGRAM-ID EQUAL SPACES OR LOW-VALUES             
C26373        PERFORM 2500-LOAD-ERROR-ARRAY    THRU 2500-EXIT           
C26373        MOVE 'PROGRAM-ID'              TO                         
C26373                                   ERR-FIELD(WS-ERR-ARRAY-IDX)    
C26373        MOVE 'NOT PRESENT'             TO                         
C26373                                   ERR-PROBLEM(WS-ERR-ARRAY-IDX)  
C26373     ELSE                                                         
C26373        MOVE U5-DIGTL-MTR-TYPE         TO O8-DIGTL-MTR-TYPE       
C26373        MOVE E-FMT19-PROGRAM-ID        TO O8-PROGRAM-ID           
C26373        MOVE 'N'                       TO WS-PGM-ID-EXISTS        
C26373        PERFORM 7150-SELECT-METER-PGM  THRU 7150-EXIT             
C26373        IF NOT PGM-ID-EXISTS                                      
C26373           PERFORM 2500-LOAD-ERROR-ARRAY  THRU 2500-EXIT          
C26373           MOVE 'PROGRAM-ID'              TO                      
C26373                                    ERR-FIELD(WS-ERR-ARRAY-IDX)   
C26373           MOVE 'NOT VALID'               TO                      
C26373                                    ERR-PROBLEM(WS-ERR-ARRAY-IDX) 
C26373        END-IF                                                    
C26373     END-IF.                                                      
C26373*                                                                         
C26373 2150-EXIT.                                                       
C26373     EXIT.                                                        
C26373*                                                                         
C33887*===============================================================*         
       2200-EDIT-DATES.                                                 
C33887*===============================================================*         
C33887* VALIDATE PURCHASE DATE & CALCULATE WARRANTY END DATE BY ADDING*         
C33887*  WARRANTY MONTHS TO PURCHASE DATE                             *         
C33887*---------------------------------------------------------------*         
C33887     INITIALIZE WS-DB2-DATE-CCYY-MM-DD                            
C33887     MOVE E-FMT19-PURCHASE-CC    TO WS-DB2-DATE-CC                
C33887     MOVE E-FMT19-PURCHASE-YY    TO WS-DB2-DATE-YY                
C33887     MOVE E-FMT19-PURCHASE-MM    TO WS-DB2-DATE-MM                
C33887     MOVE E-FMT19-PURCHASE-DD    TO WS-DB2-DATE-DD                
C33887     MOVE WS-DB2-DATE-CCYY-MM-DD TO WS-PURCHASE-DB2-DT            
C33887*                                                                         
C33887     PERFORM 7860-VALIDATE-PURCHASE-DATE   THRU 7860-EXIT.        
C33887*                                                                         
C33887     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C33887        CONTINUE                                                  
C33887     ELSE                                                         
C33887        MOVE SQLCODE        TO WS-DISPLAY-RC                      
C33887        DISPLAY '***************PCSMT604***************'          
C33887        DISPLAY '* WARNING: PURCHASE DATE IS NOT VALID*'          
C33887        DISPLAY '* ERROR IN:2200-EDIT-DATES           *'          
C33887        DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
C33887        DISPLAY '* PURCHASE DATE : ' WS-PURCHASE-DB2-DT           
C33887        DISPLAY '* WARRANTY DAYS : ' E-FMT19-WARRANTY-MONTHS      
C33887        PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT          
C33887        MOVE 'PURCHASE DATE '   TO ERR-FIELD   (WS-ERR-ARRAY-IDX) 
C33887        MOVE 'INVALID DATE'     TO ERR-PROBLEM (WS-ERR-ARRAY-IDX) 
C33887     END-IF.                                                      
C33887*                                                                         
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
P00462*                                                                         
P00462*================================================================*        
P00462 2300-VALIDATE-MISC-ATT.                                          
P00462*================================================================*        
P00462*                                                                         
P00462* MISC ATTACHMENT TYPE VALIDATION                                         
P00462     SET MISC-ATT-TYPE-DO-NOT-EXIST    TO  TRUE.                  
P00462     IF  E-FMT19-MISC-ATT-TYPE > SPACES                           
P00462         MOVE E-FMT19-MISC-ATT-TYPE  TO N5-CODE-ATT-TYPE          
P00462         MOVE SPACES                 TO WS-MISC-ATT-CODE-DEV-TYPE 
P00462         PERFORM 7020-SELECT-ATTACHMENT-TYPE THRU 7020-EXIT       
P00462         IF SQLCODE EQUAL SUCCESSFUL-CALL                         
P00462            SET MISC-ATT-TYPE-EXISTS TO TRUE                      
P00462            MOVE N5-CODE-DEVICE-TYPE TO WS-MISC-ATT-CODE-DEV-TYPE 
P00462         ELSE                                                     
P00462            PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT      
P00462            MOVE 'MISC ATTCH TYPE' TO ERR-FIELD(WS-ERR-ARRAY-IDX) 
P00462            MOVE 'NOT VALID  '  TO ERR-PROBLEM (WS-ERR-ARRAY-IDX) 
P00462         END-IF                                                   
P00462     ELSE                                                         
P00462         PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
P00462         MOVE 'MISC ATTCH TYPE' TO ERR-FIELD(WS-ERR-ARRAY-IDX)    
P00462         MOVE 'NOT PRESENT'     TO ERR-PROBLEM (WS-ERR-ARRAY-IDX) 
P00462     END-IF.                                                      
P00462*                                                                         
P00462*** Format MISC attachment with leading zero                              
P00462     MOVE SPACES                  TO WS-FRMT-ATT.                 
P00462     MOVE E-FMT19-MISC-ATT-DEV-NO TO WS-FRMT-ATT.                 
P00462     PERFORM 7950-FORMAT-ATTACHMENT                               
P00462        THRU 7950-EXIT.                                           
P00462     MOVE WS-FRMT-ATT            TO E-FMT19-MISC-ATT-DEV-NO.      
P00462*                                                                         
P00462* MISC ATTACHMENT NUMBER VALIDATION                                       
P00462     MOVE SPACES                       TO WS-TEMP-ATT-TYPE.       
P00462     IF E-FMT19-MISC-ATT-DEV-NO IS NUMERIC                        
P00462        IF MISC-ATT-TYPE-EXISTS                                   
P00462           SET WS-VALID-ATTACHMENT      TO TRUE                   
P00462           MOVE E-FMT19-MISC-ATT-DEV-NO TO MA-DEVICE-NO           
P00462           MOVE E-FMT19-MISC-ATT-TYPE   TO WS-TEMP-ATT-TYPE       
P00462           MOVE 'MISC ATT DEV NBR'      TO WS-ATT-ERR-TEXT        
P00462           PERFORM 2600-VALIDATE-ATTACHMENT  THRU 2600-EXIT       
P00462        END-IF                                                    
P00462     ELSE                                                         
P00462        PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT          
P00462        MOVE 'MISC ATT DEVICE NO' TO ERR-FIELD(WS-ERR-ARRAY-IDX)  
P00462        MOVE 'NOT NUMERIC'        TO ERR-PROBLEM(WS-ERR-ARRAY-IDX)
P00462     END-IF.                                                      
P00462*                                                                         
P00462* MISC ATTACHMENT MANUFACTURER CODE (CODE ATT MAKE) VALIDATION            
P00462     IF E-FMT19-MISC-ATT-MFR-CD > SPACES                          
P00462        MOVE E-FMT19-MISC-ATT-MFR-CD  TO M2-CODE-MAKE             
P00462        PERFORM 7200-SELECT-ATTACHMENT-MAKE THRU 7200-EXIT        
P00462        IF SQLCODE EQUAL NOT-FOUND                                
P00462           PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT       
P00462           MOVE 'MISC ATTCH MFR CODE'                             
P00462                                 TO ERR-FIELD  (WS-ERR-ARRAY-IDX) 
P00462           MOVE 'NOT VALID  '    TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
P00462       END-IF                                                     
P00462     ELSE                                                         
P00462         PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT         
P00462         MOVE 'MISC ATTCH MFR CODE'                               
P00462                                 TO ERR-FIELD  (WS-ERR-ARRAY-IDX) 
P00462         MOVE 'NOT PRESENT'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
P00462     END-IF.                                                      
P00462*                                                                         
P00462* MISC ATTACHMENT TEST SCHEDULE VALIDATION                                
P00462     IF E-FMT19-MISC-ATT-TEST-SCH > SPACES                        
P00462        MOVE E-FMT19-MISC-ATT-TEST-SCH TO M3-TEST-SCHED-CD        
P00462        PERFORM 7660-SELECT-TEST-SCH  THRU 7660-EXIT              
P00462        IF SQLCODE EQUAL NOT-FOUND                                
P00462           PERFORM 2500-LOAD-ERROR-ARRAY THRU 2500-EXIT           
P00462           MOVE 'MISC ATT TEST SCHED'                             
P00462                                 TO ERR-FIELD (WS-ERR-ARRAY-IDX)  
P00462           MOVE 'NOT VALID'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
P00462        END-IF                                                    
P00462     ELSE                                                         
P00462        PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT          
P00462        MOVE 'MISC ATT TEST SCHED'                                
P00462                                TO ERR-FIELD  (WS-ERR-ARRAY-IDX)  
P00462        MOVE 'NOT PRESENT'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX) 
P00462     END-IF.                                                      
P00462*                                                                         
P00462* MISC ATT MODULE CONNECT TYPE (HOW-ATTACHED-CD) VALIDATION               
P00462     IF E-FMT19-MISC-ATT-CONN-TYPE > SPACES                       
P00462        SET WS-CODE-VAL-NOT-MATCHED TO TRUE                       
P00462        PERFORM VARYING WS-CONN-INDX FROM 1 BY 1                  
P00462           UNTIL WS-CONN-INDX > WS-HOW-CONN-SUB                   
P00462            OR WS-CODE-VAL-MATCHED                                
P00462            OR WS-TAB-HOW-CONN-VAL (WS-CONN-INDX) = SPACES        
P00462           IF WS-TAB-HOW-CONN-VAL (WS-CONN-INDX)                  
P00462                                = E-FMT19-MISC-ATT-CONN-TYPE      
P00462              SET WS-CODE-VAL-MATCHED TO TRUE                     
P00462           END-IF                                                 
P00462        END-PERFORM                                               
P00462        IF WS-CODE-VAL-NOT-MATCHED                                
P00462           PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT       
P00462           MOVE 'MISC ATT CONTN TYP'                              
P00462                                 TO ERR-FIELD (WS-ERR-ARRAY-IDX)  
P00462           MOVE 'NOT VALID'    TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)  
P00462        END-IF                                                    
P00462     ELSE                                                         
P00462        PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT          
P00462        MOVE 'MISC ATT CONTN TYP'                                 
P00462                                TO ERR-FIELD   (WS-ERR-ARRAY-IDX) 
P00462        MOVE 'NOT PRESENT'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX) 
P00462     END-IF.                                                      
P00462*                                                                         
P00462* MISC ATTACHMENT VERSION CODE VALIDATION                                 
P00462     IF E-FMT19-MISC-ATT-VER-CD > SPACES                          
P00462        SET WS-CODE-VAL-NOT-MATCHED TO TRUE                       
P00462        PERFORM VARYING WS-VER-INDX FROM 1 BY 1                   
P00462           UNTIL WS-VER-INDX > WS-VER-CODE-SUB                    
P00462            OR WS-CODE-VAL-MATCHED                                
P00462            OR WS-TAB-UTL-CODE-VAL (WS-VER-INDX) = SPACES         
P00462           IF WS-TAB-UTL-CODE-VAL (WS-VER-INDX)                   
P00462                                = WS-E                            
P00462            AND WS-TAB-ATT-CODE-VAL (WS-VER-INDX)                 
P00462                                = E-FMT19-MISC-ATT-TYPE           
P00462            AND WS-TAB-VER-CODE-VAL (WS-VER-INDX)                 
P00462                                = E-FMT19-MISC-ATT-VER-CD         
P00462                SET WS-CODE-VAL-MATCHED TO TRUE                   
P00462           END-IF                                                 
P00462        END-PERFORM                                               
P00462        IF WS-CODE-VAL-NOT-MATCHED                                
P00462           PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT       
P00462           MOVE 'MISC ATTCH VER CD'                               
P00462                                 TO ERR-FIELD (WS-ERR-ARRAY-IDX)  
P00462           MOVE 'NOT VALID'    TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)  
P00462        END-IF                                                    
P00462     ELSE                                                         
P00462        PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT          
P00462        MOVE 'MISC ATTCH VER CD' TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
P00462        MOVE 'NOT PRESENT'       TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
P00462     END-IF.                                                      
P00462*                                                                         
P00462 2300-EXIT.                                                       
P00462     EXIT.                                                        
P00462*                                                                         
C33887/                                                                         
C33887/                                                                         
       2500-LOAD-ERROR-ARRAY.                                           
      *                                                                         
           MOVE 'Y'                    TO WS-RECORD-FLAG.               
           ADD 1                       TO WS-ERR-ARRAY-IDX.             
T19249     MOVE WS-SAVE-VENDOR-ID      TO ERR-VENDOR (WS-ERR-ARRAY-IDX).
TP4597     MOVE E-FMT19-METER-NO       TO ERR-METER-NBR                 
                                                     (WS-ERR-ARRAY-IDX).
C33887     MOVE E-FMT19-METER-SERIAL-NBR    TO ERR-SERIAL-NBR           
                                                     (WS-ERR-ARRAY-IDX).
                                                                        
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T33887*================================================================*        
T33887 2400-VALIDATE-OTHER2-ATT.                                        
T33887*================================================================*        
T33887*                                                                         
T33887     ADD 1 TO WS-ATTCHMNT-NO GIVING WS-ATTCHMNT-NO1               
T33887     ADD 2 TO WS-ATTCHMNT-NO GIVING WS-ATTCHMNT-NO2               
T33887*                                                                         
T33887     MOVE WS-ATTCHMNT-NO1        TO MA-DEVICE-NO                  
T33887     MOVE 'ATTACHMENT NBR +1 '   TO WS-ATT-ERR-TEXT               
T33887     PERFORM 2600-VALIDATE-ATTACHMENT  THRU 2600-EXIT             
T33887     IF WS-VALID-ATTACHMENT                                       
T33887        MOVE WS-ATTCHMNT-NO2          TO MA-DEVICE-NO             
T33887        MOVE 'ATTACHMENT NBR +2 '     TO WS-ATT-ERR-TEXT          
T33887        PERFORM 2600-VALIDATE-ATTACHMENT  THRU 2600-EXIT          
T33887     END-IF.                                                      
T33887*                                                                         
T33887 2400-EXIT.                                                       
T33887     EXIT.                                                        
T33887*                                                                         
C33887*================================================================*        
C33887 2600-VALIDATE-ATTACHMENT.                                        
C33887*================================================================*        
C33887* ATTACHMENT NBR IS VALIDATED AGAINST EQUIP_ATTCHMTS AND         *        
C33887* METER_ATTCHMTS TABLE BASED ON UNIQUE-ATT-ID-CD OF ATTACHMENT   *        
C33887* TYPE. BELOW ARE THE RULES OF UNIQUE-ATT-ID-CD                  *        
C33887*                                                                *        
C33887***   U     - UNIQUE WITHIN A UTIL-TYPE ACROSS COMPANIES         *        
C33887***   S     - UNIQUE WITH IN THE SYSTEM                          *        
C33887***   C     - UNIQUE WITHIN COMPANY ACROSS UTIL-TYPES            *        
C33887***   A     - UNIQUE WITHIN A UTIL-TYPE WITHIN A COMPANY         *        
C33887***   OTHER - SAME AS 'A'                                        *        
C33887*----------------------------------------------------------------*        
C33887*** USE METER_ATTCHMTS TABLE TO VALIDATE ATTACHMENT NBR                   
P00462     MOVE WS-TEMP-ATT-TYPE       TO MA-CODE-ATT-TYPE              
C33887     PERFORM 7340-OPEN-METER-ATTCHMTS  THRU 7340-EXIT             
C33887     PERFORM 7350-FETCH-METER-ATTCHMTS THRU 7350-EXIT             
C33887*                                                                         
C33887     PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
C33887                     OR WS-NOT-VALID-ATTACHMENT                   
C33887        PERFORM 2610-APPLY-UNIQUE-RULES  THRU 2610-EXIT           
C33887*                                                                         
C33887        IF WS-VALID-ATTACHMENT                                    
C33887           PERFORM 7350-FETCH-METER-ATTCHMTS THRU 7350-EXIT       
C33887        END-IF                                                    
C33887*                                                                         
C33887     END-PERFORM                                                  
C33887*                                                                         
C33887     PERFORM 7360-CLOSE-METER-ATTCHMTS THRU 7360-EXIT             
C33887*                                                                         
C33887     IF WS-NOT-VALID-ATTACHMENT                                   
C33887        PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT          
T33887        MOVE WS-ATT-ERR-TEXT     TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
C33887        MOVE 'ATTACHED TO MTR#'                                   
C33887                             TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)    
C33887        MOVE WS-DB-METER-NO                                       
C33887                         TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)(17:9)  
C33887        GO TO 2600-EXIT                                           
C33887     END-IF.                                                      
C33887*                                                                         
C33887*** USE EQUIP_ATTCHMTS TABLE TO VALIDATE ATTACHMENT NBR                   
T33887     MOVE MA-DEVICE-NO           TO LX-DEVICE-NO                  
P00462     MOVE WS-TEMP-ATT-TYPE       TO LX-CODE-ATT-TYPE              
C33887     PERFORM 7310-OPEN-EQUIP-ATTCHMTS  THRU 7310-EXIT             
C33887     PERFORM 7320-FETCH-EQUIP-ATTCHMTS THRU 7320-EXIT             
C33887*                                                                         
C33887     PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
C33887                     OR WS-NOT-VALID-ATTACHMENT                   
C33887        PERFORM 2610-APPLY-UNIQUE-RULES  THRU 2610-EXIT           
C33887*                                                                         
C33887        IF WS-VALID-ATTACHMENT                                    
C33887           PERFORM 7320-FETCH-EQUIP-ATTCHMTS THRU 7320-EXIT       
C33887        END-IF                                                    
C33887*                                                                         
C33887     END-PERFORM                                                  
C33887*                                                                         
C33887     PERFORM 7330-CLOSE-EQUIP-ATTCHMTS THRU 7330-EXIT             
C33887*                                                                         
C33887     IF WS-NOT-VALID-ATTACHMENT                                   
C33887        PERFORM 2500-LOAD-ERROR-ARRAY     THRU 2500-EXIT          
T33887        MOVE WS-ATT-ERR-TEXT     TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
C33887        MOVE 'ALREADY AT INVENTORY'                               
C33887                                 TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
C33887     END-IF.                                                      
C33887*                                                                         
C33887 2600-EXIT.                                                       
C33887     EXIT.                                                        
C33887*                                                                         
C33887*================================================================*        
C33887 2610-APPLY-UNIQUE-RULES.                                         
C33887*================================================================*        
C33887*                                                                         
C33887     EVALUATE N5-UNIQUE-ATT-ID-CD                                 
C33887        WHEN 'A'                                                  
C33887           IF WS-DB-COMPANY-NO         = WS-CMP-NO                
C33887              AND WS-DB-CODE-UTIL-TYPE = WS-E                     
C33887              SET WS-NOT-VALID-ATTACHMENT TO TRUE                 
C33887           END-IF                                                 
C33887        WHEN 'C'                                                  
C33887           IF WS-DB-COMPANY-NO  = WS-CMP-NO                       
C33887              SET WS-NOT-VALID-ATTACHMENT TO TRUE                 
C33887           END-IF                                                 
C33887        WHEN 'S'                                                  
C33887           SET WS-NOT-VALID-ATTACHMENT TO TRUE                    
C33887        WHEN 'U'                                                  
C33887           IF WS-DB-CODE-UTIL-TYPE = WS-E                         
C33887              SET WS-NOT-VALID-ATTACHMENT TO TRUE                 
C33887           END-IF                                                 
C33887        WHEN OTHER                                                
C33887           IF WS-DB-COMPANY-NO   = WS-CMP-NO                      
C33887              AND WS-DB-CODE-UTIL-TYPE = WS-E                     
C33887              SET WS-NOT-VALID-ATTACHMENT TO TRUE                 
C33887           END-IF                                                 
C33887     END-EVALUATE.                                                
C33887*                                                                         
C33887 2610-EXIT.                                                       
C33887     EXIT.                                                        
C33887/                                                                         
T35434*================================================================*        
T35434 3000-COMMIT.                                                     
T35434*================================================================*        
T35434*                                                                         
T35434     PERFORM 8800-WRITE-RESTART         THRU 8800-EXIT            
T35434*                                                                         
T35434     EXEC SQL                                                     
T35434          COMMIT                                                  
T35434     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35434*                                                                         
T35434     DISPLAY 'COMMIT-POINT #'  WS-CHKP-SEQ-NO 'TAKEN.'.           
T35434     DISPLAY 'COMMITTED UPTO =  MTR|SERIAL NO: '                  
T35434              E-FMT19-METER-NO '|' E-FMT19-METER-SERIAL-NBR.      
T35434*                                                                         
T35434 3000-EXIT.                                                       
T35434      EXIT.                                                       
T35434*                                                                         
      ****************************************************************          
      **                                                            **          
      **  5000-UPDATE                                               **          
      **      SETUP AND INSERT CSS_EQUIPMENT, CSS_ELEC_METER,       **          
TP4597**                       CSS_MTR_CAP                          **          
      ****************************************************************          
       5000-UPDATE.                                                     
      *                                                                         
      ***  SETUP EQUIPMENT TABLE AND INSERT                                     
      *                                                                         
TP4597     MOVE E-FMT19-METER-NO       TO EQ-DEVICE-NO,                 
                                          EM-METER-NO,                  
A04860                                    MC-METER-NO.                  
      *                                                                         
TP4597     MOVE E-FMT19-METER-NO       TO EQ-DEVICE-NO.                 
           MOVE WS-M                   TO EQ-EQUIP-TYPE-CD.             
           MOVE U5-CODE-MAKE           TO EQ-CODE-MAKE.                 
           MOVE SPACE                  TO EQ-PALETTE-NO.                
P00462     MOVE WS-FRMT-SERIAL-NO      TO EQ-SERIAL-NO.                 
      *                                                                         
C33887     MOVE WS-PURCHASE-DB2-DT     TO EQ-DATE-PURCHASED             
           MOVE SPACE                  TO EQ-DATE-DISPOSED-OF.          
           SET DATE-DISPOSED-OF-NULL   TO TRUE.                         
C33887     MOVE WS-WARRANTY-DB2-DT     TO EQ-WARRANTY-EXP-DT            
           MOVE SPACE                  TO EQ-INSTALL-EMP-ID.            
           MOVE SPACE                  TO EQ-INSTALL-DT.                
           SET INSTALL-DT-NULL         TO TRUE.                         
PCR040     MOVE 'A'                    TO EQ-CODE-CRNT-LOC.             
           MOVE ZERO                   TO EQ-CRNT-LOC-NO.               
TP4597     MOVE WS-DB2-TODAYS-DATE     TO EQ-DATE-LAST-TRAN,            
TP4597                                    EQ-DATE-LAST-MOVE.            
TP4597     MOVE E-FMT19-METER-STORAGE-FAC TO  EQ-LOCAL-OFFICE.          
TP4597     MOVE SPACES                 TO EQ-MFR-DT.                    
TP4597     SET MFR-DT-NULL             TO TRUE.                         
           MOVE SPACE                  TO EQ-DATE-OBSOLETE.             
           SET DATE-OBSOLETE-NULL      TO TRUE.                         
           MOVE SPACE                  TO EQ-UPGRADES-TX.               
           MOVE SPACE                  TO EQ-HAZARD-MATERIAL-CD.        
TP4597     MOVE WS-CMP-NO              TO EQ-COMPANY-NO.                
A#4200     MOVE E-FMT19-FERC-ACCOUNT-NO TO EQ-FERC-ACCOUNT-NO.          
C33887*                                                                         
C33887     IF E-FMT19-COMMENTS > SPACES                                 
C33887        MOVE E-FMT19-COMMENTS TO EQ-EQUIP-COMMENTS-TX-TEXT        
C33887        MOVE LENGTH OF E-FMT19-COMMENTS                           
C33887                             TO EQ-EQUIP-COMMENTS-TX-LEN          
C33887     END-IF.                                                      
      *                                                                         
           PERFORM 8600-INSERT-EQUIP             THRU 8600-EXIT.        
TP4597     IF  SQLCODE EQUAL -803                                       
TP4597         PERFORM 5035-CREATE-WORK-QUEUE THRU 5035-EXIT            
A04860         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
A04860            COMPUTE WS-NBR-GOOD-RECS = WS-NBR-GOOD-RECS - 1       
A04860            ADD 1                   TO WS-NBR-BAD-RECS            
A04860            GO TO 5000-EXIT                                       
A04860         END-IF                                                   
TP4597     END-IF.                                                      
      *                                                                         
      ***  SETUP CSS_ELEC_METER AND INSERT                                      
      *                                                                         
TP4597     MOVE E-FMT19-MTR-CLASS-CD   TO EM-ELEC-MTR-CLASS-CD.         
TP4597     MOVE E-FMT19-MTR-SPEC-CD    TO EM-ELEC-MTR-SPEC-CD.          
           MOVE SPACE                  TO EM-CODE-GEAR-REDUCTN.         
      *                                                                         
T18703     IF  WS-KH-OR-KE-NUM IS NUMERIC                               
T18703         MOVE WS-KH-OR-KE-NUM    TO EM-KH-OR-KE                   
           ELSE                                                         
               MOVE ZERO               TO EM-KH-OR-KE                   
           END-IF.                                                      
      *                                                                         
PCR040     MOVE ZERO                   TO EM-REG-NO.                    
PCR040     MOVE ZERO                   TO EM-REG-UPPER-FRACTION.        
PCR040     MOVE ZERO                   TO EM-REG-LOWER-FRACTION.        
           MOVE U5-TOU-RATE-IND        TO EM-TOU-RATE-IND.              
C37481* WE DON'T USE THIS FIELD AND HENCE SPACES HAVE BEEN MOVED                
C37481     MOVE SPACE                  TO EM-IDR-MEMORY-SIZE.           
           MOVE ZERO                   TO EM-SOLID-ST-DIP-SET.          
PCR040     MOVE ZERO                   TO EM-WATTS-PER-PULSE.           
C37481* WE DON'T USE THIS FIELD AND HENCE ZERO IS BEEN MOVED                    
C37481     MOVE ZERO                   TO EM-PULSES-PER-REV.            
           MOVE SPACE                  TO EM-CODE-METER-TYPE.           
TP4597     MOVE SPACE                  TO EM-DATE-LAST-TESTED.          
TP4597     SET DATE-LAST-TESTED-NULL   TO TRUE.                         
TP4597     MOVE WS-M                   TO EM-DEVICE-TYPE-CD.            
TP4597     MOVE SPACE                  TO EM-LAST-TEST-SEL-CD.          
TP4597     MOVE SPACE                  TO EM-LAST-TEST-SEL-DT.          
TP4597     SET LAST-TEST-SEL-DT-NULL   TO TRUE.                         
      *                                                                         
           MOVE WS-N                   TO WS-ATT-CT-RATED               
                                          WS-ATT-PT-RATED               
                                          WS-ATT-MAG-TAPE               
30346                                     WS-ATT-IDR-DEVC               
30346                                     WS-ATT-REACTIVE-MTR           
30346                                     WS-ATT-V2H-MTR.               
      *                                                                         
           MOVE WS-CODES-ELEC-ATT-DATA-PRESENT                          
                                       TO EM-CODE-ATTACHMENTS.          
           MOVE U4-NO-PHASES           TO EM-NO-PHASES.                 
           MOVE U4-NO-WIRES            TO EM-NO-WIRES.                  
           MOVE U4-AMPS                TO EM-AMPS.                      
           MOVE U4-VOLTAGE             TO EM-VOLTAGE.                   
A00633     MOVE U0-MTR-CONNECT-TYP-ID  TO EM-MTR-CONNECT-TYP-ID.        
           MOVE U5-DIGTL-MTR-TYPE      TO EM-DIGTL-MTR-TYPE.            
C26373     MOVE E-FMT19-PROGRAM-ID     TO EM-PROGRAM-ID.                
           MOVE U5-METER-SIZE-ID       TO EM-METER-SIZE-ID.             
PCR040*                                                                         
C33887     MOVE E-FMT19-TEST-SCHEDULE  TO EM-TEST-SCHED-CD.             
T22243     MOVE WS-CMP-NO                      TO EM-COMPANY-NO.        
      *                                                                         
           PERFORM 8610-INSERT-ELEC-METER        THRU 8610-EXIT.        
      *                                                                         
      ***  SETUP METER CAPABILITY TABLE AND INSERT                              
      *                                                                         
           PERFORM 5100-BUILD-MC-ROWS            THRU 5100-EXIT.        
      *                                                                         
C33887     IF WS-ADD-ATTACHMENT                                         
C33887***     BUILD AND INSERT EQUIP ATTCHMTS TABLE                             
C33887        PERFORM 5300-SETUP-LX-ROWS        THRU 5300-EXIT          
C33887*                                                                         
C33887***     BUILD AND INSERT METER ATTCHMTS TABLE                             
C33887        PERFORM 5400-SETUP-MA-ROWS           THRU 5400-EXIT       
C33887     END-IF.                                                      
C33887*                                                                         
P00462     IF ADD-MISC-ATTACHMENT                                       
P00462        MOVE E-FMT19-MISC-ATT-DEV-NO    TO LX-DEVICE-NO           
P00462                                           MA-DEVICE-NO           
P00462        MOVE E-FMT19-MISC-ATT-TYPE      TO LX-CODE-ATT-TYPE       
P00462                                           MA-CODE-ATT-TYPE       
P00462        MOVE E-FMT19-MISC-ATT-MFR-CD    TO LX-CODE-MAKE           
P00462                                           MA-CODE-MAKE           
P00462        MOVE E-FMT19-MISC-ATT-VER-CD    TO LX-VERSION-CD          
P00462        MOVE E-FMT19-MISC-ATT-TEST-SCH  TO LX-TEST-SCHED-CD       
P00462                                           MA-TEST-SCHED-CD       
P00462        MOVE E-FMT19-MISC-ATT-CONN-TYPE TO MA-HOW-ATTACHED-CD     
P00462        MOVE WS-MISC-ATT-CODE-DEV-TYPE  TO MA-CODE-DEVICE-TYPE    
P00462        MOVE SPACES                     TO LX-SERIAL-NO           
P00462                                                                  
P00462        PERFORM 8630-INSERT-EQUIP-ATTCHMTS  THRU 8630-EXIT        
P00462        PERFORM 8640-INSERT-MTR-ATTACH      THRU 8640-EXIT        
P00462     END-IF.                                                      
P00462*                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
TP4597******************************************************************        
TP4597*   CREATE WORK QUEUE FOR DUPLICATE METERS                       *        
TP4597******************************************************************        
TP4597 5035-CREATE-WORK-QUEUE.                                          
TP4597*                                                                         
A04860     INITIALIZE CWS00077-FIELDS.                                  
A04860     MOVE ZERO                     TO WS-ITEM-ID.                 
A04860     MOVE WS-ITEM-ID               TO WS-77-ITEM-ID.              
A04860     MOVE ZERO                     TO WS-77-SERV-ORDER-NO.        
A04860     IF WS-CMP-NO = '01'                                          
A04860        MOVE 253                   TO WS-77-CATEGORY-ID           
A04860        MOVE 4                     TO WS-77-ROUTE-CATEGORY        
A04860     ELSE                                                         
A04860        MOVE 529                   TO WS-77-CATEGORY-ID           
A04860        MOVE 1                     TO WS-77-ROUTE-CATEGORY        
A04860     END-IF.                                                      
A04860     MOVE ZERO                     TO WS-77-ACCOUNT-NO            
A04860                                      WS-77-PREMISE-NO            
A04860                                      WS-77-CUSTOMER-NO.          
A04860     MOVE 'SYSTEM '                TO WS-77-USER-ID-ORIG.         
A04860     MOVE SPACES                   TO WS-77-USER-ID-ASGN.         
A04860     MOVE SPACES                   TO WS-77-RESP-AREA-ID          
A04860                                      WS-77-LOCAL-OFFICE.         
A04860     MOVE ZERO                     TO WS-77-FREE-FORM-LEN.        
A04860     MOVE LOW-VALUES               TO WS-77-FREE-FORM-TXT.        
A04860     MOVE SPACES                   TO WS-77-DATE-REQUIRED.        
A04860     MOVE SPACES                   TO WS-77-DATE-CREATED.         
A04860     MOVE 'N'                      TO WS-77-PRIORITY.             
A04860     MOVE EQ-DEVICE-NO             TO WS-WQ-METER-NO.             
A04860     MOVE WS-WQ-COMMENTS           TO WS-77-COMMENTS.             
A04860     MOVE PROGRAM-NAME             TO WS-77-CREATED-BY.           
A04860*                                                                         
A04860     PERFORM 8950-INSERT-WORK-QUEUE-ITEM THRU 8950-EXIT.          
TP4597*                                                                         
TP4597 5035-EXIT.                                                       
TP4597     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  5100-BUILD-MC-ROWS  -  CALLED BY: 5000-UPDATE  -          **          
      **      THIS PROCEDURE EVALUATES THE METER TYPE TO DETERMINE  **          
      **      HOW MANY METER CAPABILITY ROWS TO CREATE.             **          
      ****************************************************************          
       5100-BUILD-MC-ROWS.                                              
      *                                                                         
P00251     INITIALIZE      DCLCSS-MTR-RD-FMT                            
P00251                     DCLCSS-MTR-CAP                               
P00251                     WS-LAST-REG-ID-NO.                           
P00251                                                                  
P00251     MOVE U5-DIGTL-MTR-TYPE      TO OA-DIGTL-MTR-TYPE.            
P00251     MOVE E-FMT19-PROGRAM-ID     TO OA-PROGRAM-ID.                
P00251     MOVE O8-DEF-RD-SOURCE-CD    TO OA-MTR-READ-SOURCE-CD.        
P00251     MOVE O8-DFLT-REMOTE-RD-IND  TO OA-REMOTE-READ-IND.           
P00251                                                                  
P00251     PERFORM 7210-OPEN-READ-FMT-CSR        THRU 7210-EXIT.        
P00251     PERFORM 7220-FETCH-READ-FMT-CSR       THRU 7220-EXIT.        
P00251                                                                  
P00251     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
P00251        MOVE SQLCODE        TO WS-DISPLAY-RC                      
P00251        DISPLAY '***************PCSMT604***************'          
P00251        DISPLAY '* ERROR ON 7220-FETCH-READ-FMT-CSR'              
P00251        DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
P00251        DISPLAY '* OA-DIGTL-MTR-TYPE     = ' OA-DIGTL-MTR-TYPE    
P00251        DISPLAY '* OA-PROGRAM-ID         = ' OA-PROGRAM-ID        
P00251        DISPLAY '* OA-MTR-READ-SOURCE-CD = ' OA-MTR-READ-SOURCE-CD
P00251        DISPLAY '* OA-REMOTE-READ-IND    = ' OA-REMOTE-READ-IND   
P00251        DISPLAY '* PROGRAM ABENDING...                *'          
P00251        DISPLAY '***************PCSMT604***************'          
P00251        PERFORM 9900-ABEND            THRU 9900-EXIT              
P00251     ELSE                                                         
P00251        MOVE WS-E                   TO MC-CODE-UTIL-TYPE          
P00251        MOVE E-FMT19-METER-NO       TO MC-METER-NO                
PR#914        MOVE U0-DEF-MTR-CONSTANT    TO MC-CONSTANT                
P00251        MOVE WS-CMP-NO              TO MC-COMPANY-NO              
P00251        MOVE U0-FULL-SCALE          TO MC-FULL-SCALE              
P00251        MOVE SPACE                  TO MC-CODE-HIGH-LOW-DIAL      
P00251                                       MC-K-Q-LEAD-LAG-IND        
P00251                                       MC-DEMAND-TYPE             
P00251        PERFORM 5200-BUILD-COMMON-MC     THRU 5200-EXIT           
P00251           UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
P00251     END-IF.                                                      
P00251                                                                  
P00251     PERFORM 7230-CLOSE-READ-FMT-CSR       THRU 7230-EXIT.        
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  5200-BUILD-COMMON-MC  -  CALLED BY: 5100-BUILD-MC-ROWS    **          
      **      THIS PROCEDURE BUILDS THE COMMON INFORMATION OF AN MC **          
      **      ROW & CALLS PROCEDURE TO WRITE OUT MC TBL ROW IMAGES. **          
      ****************************************************************          
       5200-BUILD-COMMON-MC.                                            
      *                                                                         
P00251     IF OA-REG-ID-NO > 0 AND                                      
P00251        OA-REG-ID-NO NOT = WS-LAST-REG-ID-NO                      
P00251        MOVE OA-REG-ID-NO        TO MC-REG-ID-NO                  
P00251                                    WS-LAST-REG-ID-NO             
P00251        MOVE OA-CODE-CAP-TYPE    TO MC-CODE-CAP-TYPE              
P00251        MOVE OA-NO-READ-DIGITS   TO MC-NO-READ-DIALS              
P00251                                    MC-NO-DIALS                   
P00251        MOVE OA-MTR-RD-DISP-CD   TO MC-REG-MEASURES-CD            
P00251        PERFORM 8620-INSERT-MTR-CAP        THRU 8620-EXIT         
P00251     END-IF.                                                      
P00251                                                                  
P00251     PERFORM 7220-FETCH-READ-FMT-CSR       THRU 7220-EXIT.        
      *                                                                         
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C33887*================================================================*        
C33887 5300-SETUP-LX-ROWS.                                              
C33887*================================================================*        
C33887*                                                                         
C33887     MOVE WS-CMP-NO                  TO LX-COMPANY-NO             
C33887     MOVE E-FMT19-ATTACHMENT-NO      TO LX-DEVICE-NO              
C33887     MOVE E-FMT19-ATT-TYPE           TO LX-CODE-ATT-TYPE          
C33887     MOVE E-FMT19-ATT-MFR-CD         TO LX-CODE-MAKE.             
C33887     MOVE E-FMT19-ATT-VER-CD         TO LX-VERSION-CD.            
C33887     MOVE E-FMT19-ATT-TEST-SCH       TO LX-TEST-SCHED-CD.         
C33887     MOVE EQ-LOCAL-OFFICE            TO LX-MTR-STORAGE-FAC-CD.    
C33887     MOVE 'K'                        TO LX-EQUIP-LOC-ID.          
C33887     MOVE WS-PURCHASE-DB2-DT         TO LX-DATE-PURCHASED.        
C33887     MOVE WS-DB2-TODAYS-DATE         TO LX-DATE-LAST-TRAN         
C33887                                        LX-EQUIP-ATTACH-DT.       
C33887     MOVE SPACES                     TO LX-DATE-LAST-MOVE         
P00462                                        LX-SERIAL-NO              
C33887                                        LX-DATE-LAST-TESTED       
C33887                                        LX-DATE-OBSOLETE          
C33887                                        LX-DATE-DISPOSED-OF.      
C33887     MOVE WS-WARRANTY-DB2-DT  TO     LX-WARRANTY-EXP-DT           
P00462*                                                                         
P00462        MOVE E-FMT19-ATT-SERIAL-NBR  TO LX-SERIAL-NO              
P00462*                                                                         
C33887     PERFORM 8630-INSERT-EQUIP-ATTCHMTS  THRU 8630-EXIT.          
C33887*                                                                         
T33887     IF U5-REMOTE-READ-CODE = 'M'                                 
T33887        MOVE WS-ATTCHMNT-NO1     TO LX-DEVICE-NO                  
T33887        PERFORM 8630-INSERT-EQUIP-ATTCHMTS  THRU 8630-EXIT        
T33887        MOVE WS-ATTCHMNT-NO2     TO LX-DEVICE-NO                  
T33887        PERFORM 8630-INSERT-EQUIP-ATTCHMTS  THRU 8630-EXIT        
T33887     END-IF.                                                      
T33887*                                                                         
C33887 5300-EXIT.                                                       
C33887     EXIT.                                                        
C33887/                                                                         
C33887*================================================================*        
C33887 5400-SETUP-MA-ROWS.                                              
C33887*================================================================*        
C33887*                                                                         
C33887     MOVE E-FMT19-METER-NO           TO MA-METER-NO               
C33887     MOVE WS-CMP-NO                  TO MA-COMPANY-NO.            
A02790     MOVE WS-ATT-CODE-DEV-TYPE       TO MA-CODE-DEVICE-TYPE.      
T33887     MOVE E-FMT19-ATTACHMENT-NO      TO MA-DEVICE-NO              
C33887     MOVE E-FMT19-ATT-TYPE           TO MA-CODE-ATT-TYPE          
C33887     MOVE E-FMT19-ATT-MFR-CD         TO MA-CODE-MAKE.             
C33887     MOVE ZERO                       TO MA-CT-PT-RATIO.           
C33887     MOVE E-FMT19-ATT-TEST-SCH       TO MA-TEST-SCHED-CD          
C33887     MOVE E-FMT19-ATT-CONN-TYPE      TO MA-HOW-ATTACHED-CD.       
C33887     MOVE SPACES                     TO MA-DATE-LAST-TESTED.      
C33887*                                                                         
C33887     PERFORM 8640-INSERT-MTR-ATTACH  THRU 8640-EXIT.              
C33887*                                                                         
T33887     IF U5-REMOTE-READ-CODE = 'M'                                 
T33887        MOVE WS-ATTCHMNT-NO1     TO MA-DEVICE-NO                  
T33887        PERFORM 8640-INSERT-MTR-ATTACH  THRU 8640-EXIT            
T33887        MOVE WS-ATTCHMNT-NO2     TO MA-DEVICE-NO                  
T33887        PERFORM 8640-INSERT-MTR-ATTACH  THRU 8640-EXIT            
T33887     END-IF.                                                      
T33887*                                                                         
C33887 5400-EXIT.                                                       
C33887     EXIT.                                                        
C33887/                                                                         
      ****************************************************************          
      **                                                            **          
      **  6000-ERROR-ROUTINE                                        **          
      **                                                            **          
      ****************************************************************          
       6000-ERROR-ROUTINE.                                              
      *                                                                         
           MOVE ERR-VENDOR    (WS-ERR-ARRAY-IDX)                        
T19249                                 TO WS-RPT-VENDOR-ID.             
           MOVE ERR-METER-NBR (WS-ERR-ARRAY-IDX)                        
T19249                                 TO WS-RPT-METER-NO.              
           MOVE ERR-FIELD     (WS-ERR-ARRAY-IDX)                        
T19249                                 TO WS-RPT-ERROR-FIELD.           
           MOVE ERR-PROBLEM   (WS-ERR-ARRAY-IDX)                        
T19249                                 TO WS-RPT-PROBLEM-DESC.          
T19249     MOVE ERR-SERIAL-NBR (WS-ERR-ARRAY-IDX)                       
T19249                                 TO WS-RPT-SERIAL-NO.             
      *                                                                         
T19249     PERFORM 8105-WRITE-PRINTER-RECORD     THRU 8105-EXIT.        
      *                                                                         
       6000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
T35434*===============================================================*         
T35434* *6235-GET-FJC01-RESTART-REQ.                                            
T35434*===============================================================*         
T35434     EXEC SQL                                                             
T35434         INCLUDE CPD00035                                                 
T35434     END-EXEC.                                                            
T35434*===============================================================*         
T35434*  6253-GET-FJC01-CHKP-LIMIT                                              
T35434*===============================================================*         
T35434       EXEC SQL                                                           
T35434          INCLUDE CPD00034                                                
T35434       END-EXEC.                                                          
C33887*===============================================================*         
C33887 7020-SELECT-ATTACHMENT-TYPE.                                     
C33887*===============================================================*         
C33887*                                                                         
C33887     EXEC SQL                                                     
C33887         SELECT UNIQUE_ATT_ID_CD                                  
A02790               ,CODE_DEVICE_TYPE                                  
C33887           INTO :N5-UNIQUE-ATT-ID-CD                              
A02790               ,:N5-CODE-DEVICE-TYPE                              
C33887           FROM  CSS_MTR_ATT_TYPE WITH(READUNCOMMITTED)                   
C33887          WHERE  CODE_UTIL_TYPE     = :N5-CODE-UTIL-TYPE          
C33887            AND  CODE_ATT_TYPE      = :N5-CODE-ATT-TYPE           
C33887                                                           
A02790                                                      
C33887     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT UNIQUE_ATT_ID_CD                                          
MFA-TR*              ,CODE_DEVICE_TYPE                                          
MFA-TR*          INTO :N5-UNIQUE-ATT-ID-CD                                      
MFA-TR*              ,:N5-CODE-DEVICE-TYPE                                      
MFA-TR*          FROM  CSS_MTR_ATT_TYPE                                         
MFA-TR*         WHERE  CODE_UTIL_TYPE     = :N5-CODE-UTIL-TYPE                  
MFA-TR*           AND  CODE_ATT_TYPE      = :N5-CODE-ATT-TYPE                   
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887*                                                                         
C33887     IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
C33887         CONTINUE                                                 
C33887     ELSE                                                         
C33887         MOVE SQLCODE        TO WS-DISPLAY-RC                     
C33887         DISPLAY '***************PCSMT604****************'        
C33887         DISPLAY '* ERROR ON 7020-SELECT-ATTACHMENT-TYPE*'        
C33887         DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
C33887         DISPLAY '* CODE_UTIL_TYPE = ' N5-CODE-UTIL-TYPE          
C33887         DISPLAY '* CODE_ATT_TYPE  = ' N5-CODE-ATT-TYPE           
C33887         DISPLAY '* MTR NBR        = ' E-FMT19-METER-NO           
C33887         DISPLAY '* ATTACH NBR     = ' E-FMT19-ATTACHMENT-NO      
C33887         DISPLAY '***************PCSMT604****************'        
C33887         PERFORM 9900-ABEND            THRU 9900-EXIT             
C33887     END-IF.                                                      
C33887*                                                                         
C33887 7020-EXIT.                                                       
C33887     EXIT.                                                        
      *                                                                         
T35434*===============================================================*         
T35434 7100-SELECT-RESTART.                                             
T35434*===============================================================*         
T35434     EXEC  SQL                                                    
T35434        SELECT RESTART_DATA                                       
T35434          INTO :RF-RESTART-DATA                                   
T35434          FROM CSS_RESTART                                        
T35434         WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                    
T35434           AND PARTITION_NO = :RF-PARTITION-NO                    
T35434           AND  DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
T35434     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35434*                                                                         
T35434     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T35434*                                                                         
T35434        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
T35434                                       OR NOT-FOUND               
T35434           CONTINUE                                               
T35434        ELSE                                                      
T35434           DISPLAY '**  ERROR ON 7100-SELECT-RESTART   ***'       
T35434           DISPLAY '**  NAME_PROGRAM = ' RF-NAME-PROGRAM          
T35434           DISPLAY '**  PARTITION_NO = ' RF-PARTITION-NO          
T35434           DISPLAY '**  DUP_CNTRL_NO = ' RF-DUP-CNTRL-NO          
T35434           DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
T35434           DISPLAY '**      PROCESSING TERMINATED     **'         
T35434           PERFORM 9900-ABEND            THRU 9900-EXIT           
T35434        END-IF.                                                   
T35434*                                                                         
T35434 7100-EXIT.                                                       
T35434      EXIT.                                                       
T35434                                                                  
C26373******************************************************************        
C26373* CHECKING CSS_METER_PGM IF THE DMT AND PGM ID COMBINATION IS   **        
C26373* VALID                                                                   
C26373******************************************************************        
C26373 7150-SELECT-METER-PGM.                                           
C26373     EXEC SQL                                                     
C26373         SELECT 'Y'                                               
P00251               , DEF_RD_SOURCE_CD                                 
P00251               , DFLT_REMOTE_RD_IND                               
C26373           INTO  :WS-PGM-ID-EXISTS                                
P00251                ,:O8-DEF-RD-SOURCE-CD                             
P00251                ,:O8-DFLT-REMOTE-RD-IND                           
C26373           FROM  CSS_METER_PGM WITH(READUNCOMMITTED)                      
C26373          WHERE  CODE_UTIL_TYPE = :WS-E                           
C26373            AND  DIGTL_MTR_TYPE = :O8-DIGTL-MTR-TYPE              
C26373            AND  PROGRAM_ID     = :O8-PROGRAM-ID                  
C33887                                                           
A02790                                                      
C26373     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*              , DEF_RD_SOURCE_CD                                         
MFA-TR*              , DFLT_REMOTE_RD_IND                                       
MFA-TR*          INTO  :WS-PGM-ID-EXISTS                                        
MFA-TR*               ,:O8-DEF-RD-SOURCE-CD                                     
MFA-TR*               ,:O8-DFLT-REMOTE-RD-IND                                   
MFA-TR*          FROM  CSS_METER_PGM                                            
MFA-TR*         WHERE  CODE_UTIL_TYPE = :WS-E                                   
MFA-TR*           AND  DIGTL_MTR_TYPE = :O8-DIGTL-MTR-TYPE                      
MFA-TR*           AND  PROGRAM_ID     = :O8-PROGRAM-ID                          
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7150                                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26373*                                                                         
C26373     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
C26373*                                                                         
C26373     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
C26373         NEXT SENTENCE                                            
C26373     ELSE                                                         
C26373         MOVE SQLCODE        TO WS-DISPLAY-RC                     
C26373         DISPLAY '***************PCSMT604***************'         
C26373         DISPLAY '* ERROR ON 7150-SELECT-METER-PGM     *'         
C26373         DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
C26373         DISPLAY '* CODE_UTIL_TYPE =' WS-E                        
C26373         DISPLAY '* DIGTL_MTR_TYPE =' O8-DIGTL-MTR-TYPE           
C26373         DISPLAY '* PROGRAM_ID     =' O8-PROGRAM-ID               
C26373         DISPLAY '* PROGRAM ABENDING...                *'         
C26373         DISPLAY '***************PCSMT604***************'         
C26373         PERFORM 9900-ABEND            THRU 9900-EXIT             
C26373     END-IF.                                                      
C26373*                                                                         
C26373 7150-EXIT.                                                       
C26373     EXIT.                                                        
C33887/                                                                         
C33887*===============================================================*         
C33887 7200-SELECT-ATTACHMENT-MAKE.                                     
C33887*===============================================================*         
C33887*                                                                         
C33887     EXEC SQL                                                     
C33887         SELECT  EQUIP_MAKE_DESC                                  
C33887           INTO :M2-EQUIP-MAKE-DESC                               
C33887           FROM  CSS_EQUIP_MAKE WITH(READUNCOMMITTED)                     
C33887          WHERE  CODE_MAKE = :M2-CODE-MAKE                        
C33887                                                           
A02790                                                      
C33887     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  EQUIP_MAKE_DESC                                          
MFA-TR*          INTO :M2-EQUIP-MAKE-DESC                                       
MFA-TR*          FROM  CSS_EQUIP_MAKE                                           
MFA-TR*         WHERE  CODE_MAKE = :M2-CODE-MAKE                                
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887*                                                                         
C33887     IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
C33887         CONTINUE                                                 
C33887     ELSE                                                         
C33887         MOVE SQLCODE        TO WS-DISPLAY-RC                     
C33887         DISPLAY '***************PCSMT604****************'        
C33887         DISPLAY '* ERROR ON 7200-SELECT-ATTACHMENT-MAKE*'        
C33887         DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
C33887         DISPLAY '* CODE_MAKE =' M2-CODE-MAKE                     
C33887         DISPLAY '* PROGRAM ABENDING...                *'         
C33887         DISPLAY '***************PCSMT604****************'        
C33887         PERFORM 9900-ABEND            THRU 9900-EXIT             
C33887     END-IF.                                                      
C33887*                                                                         
C33887 7200-EXIT.                                                       
C33887     EXIT.                                                        
C33887*                                                                         
P00251*===============================================================*         
P00251 7210-OPEN-READ-FMT-CSR.                                          
P00251*===============================================================*         
P00251                                                                  
P00251     EXEC SQL                                                     
P00251         OPEN READ_FMT_CSR                                        
P00251     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00251                                                                  
P00251     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00251                                                                  
P00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00251        CONTINUE                                                  
P00251     ELSE                                                         
P00251        MOVE SQLCODE        TO WS-DISPLAY-RC                      
P00251        DISPLAY '***************PCSMT604***************'          
P00251        DISPLAY '* ERROR ON 7210-OPEN-READ-FMT-CSR    *'          
P00251        DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
P00251        DISPLAY '* OA-DIGTL-MTR-TYPE     = ' OA-DIGTL-MTR-TYPE    
P00251        DISPLAY '* OA-PROGRAM-ID         = ' OA-PROGRAM-ID        
P00251        DISPLAY '* OA-MTR-READ-SOURCE-CD = ' OA-MTR-READ-SOURCE-CD
P00251        DISPLAY '* OA-REMOTE-READ-IND    = ' OA-REMOTE-READ-IND   
P00251        DISPLAY '* PROGRAM ABENDING...                *'          
P00251        DISPLAY '***************PCSMT604***************'          
P00251        PERFORM 9900-ABEND            THRU 9900-EXIT              
P00251     END-IF.                                                      
P00251                                                                  
P00251 7210-EXIT.                                                       
P00251     EXIT.                                                        
P00251                                                                  
P00251*===============================================================*         
P00251 7220-FETCH-READ-FMT-CSR.                                         
P00251*===============================================================*         
P00251                                                                  
P00251     EXEC SQL                                                     
P00251         FETCH READ_FMT_CSR                                       
P00251          INTO :OA-CODE-CAP-TYPE                                  
P00251              ,:OA-REG-ID-NO                                      
P00251              ,:OA-CODE-USAGE-TYPE                                
P00251              ,:OA-NO-READ-DIGITS                                 
P00251              ,:OA-MTR-RD-DISP-CD                                 
P00251     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00251                                                                  
P00251     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00251                                                                  
P00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL  OR           
P00251                                    NOT-FOUND                     
P00251        CONTINUE                                                  
P00251     ELSE                                                         
P00251        MOVE SQLCODE        TO WS-DISPLAY-RC                      
P00251        DISPLAY '***************PCSMT604***************'          
P00251        DISPLAY '* ERROR ON 7220-FETCH-READ-FMT-CSR'              
P00251        DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
P00251        DISPLAY '* OA-DIGTL-MTR-TYPE     = ' OA-DIGTL-MTR-TYPE    
P00251        DISPLAY '* OA-PROGRAM-ID         = ' OA-PROGRAM-ID        
P00251        DISPLAY '* OA-MTR-READ-SOURCE-CD = ' OA-MTR-READ-SOURCE-CD
P00251        DISPLAY '* OA-REMOTE-READ-IND    = ' OA-REMOTE-READ-IND   
P00251        DISPLAY '* PROGRAM ABENDING...                *'          
P00251        DISPLAY '***************PCSMT604***************'          
P00251        PERFORM 9900-ABEND            THRU 9900-EXIT              
P00251     END-IF.                                                      
P00251                                                                  
P00251 7220-EXIT.                                                       
P00251     EXIT.                                                        
P00251                                                                  
P00251*===============================================================*         
P00251 7230-CLOSE-READ-FMT-CSR.                                         
P00251*===============================================================*         
P00251                                                                  
P00251     EXEC SQL                                                     
P00251         CLOSE READ_FMT_CSR                                       
P00251     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00251                                                                  
P00251     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00251                                                                  
P00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00251        CONTINUE                                                  
P00251     ELSE                                                         
P00251        MOVE SQLCODE        TO WS-DISPLAY-RC                      
P00251        DISPLAY '***************PCSMT604***************'          
P00251        DISPLAY '* ERROR ON 7230-CLOSE-READ-FMT-CSR   *'          
P00251        DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
P00251        DISPLAY '* OA-DIGTL-MTR-TYPE     = ' OA-DIGTL-MTR-TYPE    
P00251        DISPLAY '* OA-PROGRAM-ID         = ' OA-PROGRAM-ID        
P00251        DISPLAY '* OA-MTR-READ-SOURCE-CD = ' OA-MTR-READ-SOURCE-CD
P00251        DISPLAY '* OA-REMOTE-READ-IND    = ' OA-REMOTE-READ-IND   
P00251        DISPLAY '* PROGRAM ABENDING...                *'          
P00251        DISPLAY '***************PCSMT604***************'          
P00251        PERFORM 9900-ABEND            THRU 9900-EXIT              
P00251     END-IF.                                                      
P00251                                                                  
P00251 7230-EXIT.                                                       
P00251     EXIT.                                                        
P00251                                                                  
C33887*===============================================================*         
C33887 7310-OPEN-EQUIP-ATTCHMTS.                                        
C33887*===============================================================*         
C33887*                                                                         
C33887     EXEC SQL                                                     
C33887         OPEN EQUIP-ATTCHMTS                                      
C33887     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887**                                                                        
C33887     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C33887**                                                                        
C33887     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C33887        CONTINUE                                                  
C33887     ELSE                                                         
C33887        MOVE SQLCODE        TO WS-DISPLAY-RC                      
C33887        DISPLAY '***************PCSMT604***************'          
C33887        DISPLAY '* ERROR ON 7310-OPEN-EQUIP-ATTCHMTS  *'          
C33887        DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
C33887        DISPLAY '* DEVICE_NO          = ' LX-DEVICE-NO            
C33887        DISPLAY '* CODE_ATT_TYPE      = ' LX-CODE-ATT-TYPE        
C33887        DISPLAY '* PROGRAM ABENDING...                *'          
C33887        DISPLAY '***************PCSMT604***************'          
C33887        PERFORM 9900-ABEND            THRU 9900-EXIT              
C33887     END-IF.                                                      
C33887*                                                                         
C33887 7310-EXIT.                                                       
C33887     EXIT.                                                        
C33887/                                                                         
C33887*===============================================================*         
C33887 7320-FETCH-EQUIP-ATTCHMTS.                                       
C33887*===============================================================*         
C33887*                                                                         
C33887     EXEC SQL                                                     
C33887         FETCH EQUIP-ATTCHMTS                                     
C33887          INTO :WS-DB-CODE-UTIL-TYPE                              
C33887              ,:WS-DB-COMPANY-NO                                  
C33887              ,:WS-DB-METER-NO                                    
C33887     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887**                                                                        
C33887     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C33887**                                                                        
C33887     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C33887                                    OR NOT-FOUND                  
C33887        CONTINUE                                                  
C33887     ELSE                                                         
C33887        MOVE SQLCODE        TO WS-DISPLAY-RC                      
C33887        DISPLAY '***************PCSMT604***************'          
C33887        DISPLAY '* ERROR ON 7320-FETCH-EQUIP-ATTCHMTS *'          
C33887        DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
C33887        DISPLAY '* DEVICE_NO          = ' LX-DEVICE-NO            
C33887        DISPLAY '* CODE_ATT_TYPE      = ' LX-CODE-ATT-TYPE        
C33887        DISPLAY '* PROGRAM ABENDING...                *'          
C33887        DISPLAY '***************PCSMT604***************'          
C33887        PERFORM 9900-ABEND            THRU 9900-EXIT              
C33887     END-IF.                                                      
C33887 7320-EXIT.                                                       
C33887     EXIT.                                                        
C33887*                                                                         
C33887/                                                                         
C33887*===============================================================*         
C33887 7330-CLOSE-EQUIP-ATTCHMTS.                                       
C33887*===============================================================*         
C33887*                                                                         
C33887     EXEC SQL                                                     
C33887         CLOSE EQUIP-ATTCHMTS                                     
C33887     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887**                                                                        
C33887     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C33887**                                                                        
C33887     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C33887        CONTINUE                                                  
C33887     ELSE                                                         
C33887        MOVE SQLCODE        TO WS-DISPLAY-RC                      
C33887        DISPLAY '***************PCSMT604***************'          
C33887        DISPLAY '* ERROR ON 7330-CLOSE-EQUIP-ATTCHMTS *'          
C33887        DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
C33887        DISPLAY '* PROGRAM ABENDING...                *'          
C33887        DISPLAY '***************PCSMT604***************'          
C33887        PERFORM 9900-ABEND            THRU 9900-EXIT              
C33887     END-IF.                                                      
C33887 7330-EXIT.                                                       
C33887     EXIT.                                                        
C33887*                                                                         
C33887*===============================================================*         
C33887 7340-OPEN-METER-ATTCHMTS.                                        
C33887*===============================================================*         
C33887*                                                                         
C33887     EXEC SQL                                                     
C33887         OPEN METER-ATTCHMTS                                      
C33887     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887**                                                                        
C33887     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C33887**                                                                        
C33887     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C33887        CONTINUE                                                  
C33887     ELSE                                                         
C33887        MOVE SQLCODE        TO WS-DISPLAY-RC                      
C33887        DISPLAY '***************PCSMT604***************'          
C33887        DISPLAY '* ERROR ON 7340-OPEN-METER-ATTCHMTS  *'          
C33887        DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
C33887        DISPLAY '* DEVICE_NO          = ' MA-DEVICE-NO            
C33887        DISPLAY '* CODE_ATT_TYPE      = ' MA-CODE-ATT-TYPE        
C33887        DISPLAY '* PROGRAM ABENDING...                *'          
C33887        DISPLAY '***************PCSMT604***************'          
C33887        PERFORM 9900-ABEND            THRU 9900-EXIT              
C33887     END-IF.                                                      
C33887*                                                                         
C33887 7340-EXIT.                                                       
C33887     EXIT.                                                        
C33887/                                                                         
C33887*===============================================================*         
C33887 7350-FETCH-METER-ATTCHMTS.                                       
C33887*===============================================================*         
C33887*                                                                         
C33887     EXEC SQL                                                     
C33887         FETCH METER-ATTCHMTS                                     
C33887          INTO :WS-DB-CODE-UTIL-TYPE                              
C33887              ,:WS-DB-COMPANY-NO                                  
C33887              ,:WS-DB-METER-NO                                    
C33887     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887**                                                                        
C33887     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C33887**                                                                        
C33887     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C33887                                    OR NOT-FOUND                  
C33887        CONTINUE                                                  
C33887     ELSE                                                         
C33887        MOVE SQLCODE        TO WS-DISPLAY-RC                      
C33887        DISPLAY '***************PCSMT604***************'          
C33887        DISPLAY '* ERROR ON 7350-FETCH-METER-ATTCHMTS *'          
C33887        DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
C33887        DISPLAY '* DEVICE_NO          = ' MA-DEVICE-NO            
C33887        DISPLAY '* CODE_ATT_TYPE      = ' MA-CODE-ATT-TYPE        
C33887        DISPLAY '* PROGRAM ABENDING...                *'          
C33887        DISPLAY '***************PCSMT604***************'          
C33887        PERFORM 9900-ABEND            THRU 9900-EXIT              
C33887     END-IF.                                                      
C33887 7350-EXIT.                                                       
C33887     EXIT.                                                        
C33887/                                                                         
C33887*===============================================================*         
C33887 7360-CLOSE-METER-ATTCHMTS.                                       
C33887*===============================================================*         
C33887*                                                                         
C33887     EXEC SQL                                                     
C33887         CLOSE METER-ATTCHMTS                                     
C33887     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887**                                                                        
C33887     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C33887**                                                                        
C33887     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C33887        CONTINUE                                                  
C33887     ELSE                                                         
C33887        MOVE SQLCODE        TO WS-DISPLAY-RC                      
C33887        DISPLAY '***************PCSMT604***************'          
C33887        DISPLAY '* ERROR ON 7360-CLOSE-METER-ATTCHMTS *'          
C33887        DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
C33887        DISPLAY '* PROGRAM ABENDING...                *'          
C33887        DISPLAY '***************PCSMT604***************'          
C33887        PERFORM 9900-ABEND            THRU 9900-EXIT              
C33887     END-IF.                                                      
C33887 7360-EXIT.                                                       
C33887     EXIT.                                                        
C33887/                                                                         
T22243****************************************************************          
T22243**                                                            **          
T22243**  7500-SELECT-COMP-NAME                                     **          
T22243**                                                            **          
T22243****************************************************************          
T22243 7500-SELECT-COMP-NAME.                                           
T22243     MOVE '7500'                 TO WS-ACTIVE-PARAGRAPH.          
T22243     EXEC SQL                                                     
T22243         SELECT COMPANY_NAME                                      
T22243         INTO   :C7-COMPANY-NAME                                  
T22243         FROM   CSS_COMPANY WITH(READUNCOMMITTED)                         
T22243         WHERE COMPANY_NO = :C7-COMPANY-NO                        
C33887                                                           
A02790                                                      
T22243     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NAME                                              
MFA-TR*        INTO   :C7-COMPANY-NAME                                          
MFA-TR*        FROM   CSS_COMPANY                                               
MFA-TR*        WHERE COMPANY_NO = :C7-COMPANY-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22243     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
T22243         CONTINUE                                                 
T22243     ELSE                                                         
T22243         MOVE SQLCODE        TO WS-DISPLAY-RC                     
T22243         DISPLAY '***************PCSMT604***************'         
T22243         DISPLAY '* ERROR ON 7500-SELECT-COMP-NAME     *'         
T22243         DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
T22243         DISPLAY '* COMPANY_NO =' C7-COMPANY-NO                   
T22243         DISPLAY '* PROGRAM ABENDING...                *'         
T22243         DISPLAY '***************PCSMT604***************'         
T22243         PERFORM 9900-ABEND            THRU 9900-EXIT             
T22243     END-IF.                                                      
T22243 7500-EXIT.                                                       
T22243     EXIT.                                                        
C33887/                                                                         
      ****************************************************************          
      **                                                            **          
      **  7520-SELECT-ELEC-MTR-CLASS                                **          
      **                                                            **          
      ****************************************************************          
       7520-SELECT-ELEC-MTR-CLASS.                                      
      *                                                                         
           MOVE '7520'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               SELECT ELEC_MTR_CLASS_CD,                                
                      NO_PHASES,                                        
                      NO_WIRES,                                         
                      AMPS,                                             
PCR040                VOLTAGE,                                          
PCR040                TEST_SCHED_CD                                     
               INTO  :U4-ELEC-MTR-CLASS-CD,                             
                     :U4-NO-PHASES,                                     
                     :U4-NO-WIRES,                                      
                     :U4-AMPS,                                          
PCR040               :U4-VOLTAGE,                                       
PCR040               :U4-TEST-SCHED-CD                                  
               FROM   CSS_ELEC_MTR_CLASS WITH(READUNCOMMITTED)                  
               WHERE  ELEC_MTR_CLASS_CD = :U4-ELEC-MTR-CLASS-CD         
C33887                                                           
A02790                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ELEC_MTR_CLASS_CD,                                        
MFA-TR*               NO_PHASES,                                                
MFA-TR*               NO_WIRES,                                                 
MFA-TR*               AMPS,                                                     
MFA-TR*               VOLTAGE,                                                  
MFA-TR*               TEST_SCHED_CD                                             
MFA-TR*        INTO  :U4-ELEC-MTR-CLASS-CD,                                     
MFA-TR*              :U4-NO-PHASES,                                             
MFA-TR*              :U4-NO-WIRES,                                              
MFA-TR*              :U4-AMPS,                                                  
MFA-TR*              :U4-VOLTAGE,                                               
MFA-TR*              :U4-TEST-SCHED-CD                                          
MFA-TR*        FROM   CSS_ELEC_MTR_CLASS                                        
MFA-TR*        WHERE  ELEC_MTR_CLASS_CD = :U4-ELEC-MTR-CLASS-CD                 
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7520                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE        TO WS-DISPLAY-RC                      
              DISPLAY '***************PCSMT604****************'         
              DISPLAY '* ERROR ON 7520-SELECT-ELEC-MTR-CLASS *'         
              DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
C33887        DISPLAY '* ELEC_MTR_CLASS_CD =' U4-ELEC-MTR-CLASS-CD      
              DISPLAY '* PROGRAM ABENDING...                 *'         
              DISPLAY '***************PCSMT604****************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
TP4597****************************************************************          
TP4597**                                                            **          
TP4597**  7530-SELECT-MTR-STORGE-FAC                                **          
TP4597**                                                            **          
TP4597****************************************************************          
TP4597 7530-SELECT-MTR-STORGE-FAC.                                      
TP4597*                                                                         
TP4597     MOVE '7530'                 TO WS-ACTIVE-PARAGRAPH.          
TP4597*                                                                         
TP4597     EXEC SQL                                                     
TP4597         SELECT  MTR_STORAGE_FAC_TX                               
TP4597           INTO :W9-MTR-STORAGE-FAC-TX                            
TP4597           FROM  CSS_MTR_STORGE_FAC WITH(READUNCOMMITTED)                 
TP4597          WHERE  CODE_UTIL_TYPE     = :W9-CODE-UTIL-TYPE          
T22243            AND  COMPANY_NO         = :W9-COMPANY-NO              
C33887            AND  MTR_STORAGE_FAC_CD = :W9-MTR-STORAGE-FAC-CD      
C33887                                                           
A02790                                                      
TP4597     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  MTR_STORAGE_FAC_TX                                       
MFA-TR*          INTO :W9-MTR-STORAGE-FAC-TX                                    
MFA-TR*          FROM  CSS_MTR_STORGE_FAC                                       
MFA-TR*         WHERE  CODE_UTIL_TYPE     = :W9-CODE-UTIL-TYPE                  
MFA-TR*           AND  COMPANY_NO         = :W9-COMPANY-NO                      
MFA-TR*           AND  MTR_STORAGE_FAC_CD = :W9-MTR-STORAGE-FAC-CD              
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7530                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP4597*                                                                         
C33887     MOVE SQLCODE            TO   WS-ACTIVE-RETURN-CODE           
TP4597     IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
TP4597         CONTINUE                                                 
TP4597     ELSE                                                         
TP4597         MOVE SQLCODE        TO WS-DISPLAY-RC                     
TP4597         DISPLAY '***************PCSMT604****************'        
TP4597         DISPLAY '* ERROR ON 7530-SELECT-MTR-STORGE-FAC *'        
TP4597         DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
TP4597         DISPLAY '* CODE_UTIL_TYPE     =' W9-CODE-UTIL-TYPE       
T22243         DISPLAY '* COMPANY_NO         =' W9-COMPANY-NO           
TP4597         DISPLAY '* MTR_STORAGE_FAC_CD =' W9-MTR-STORAGE-FAC-CD   
TP4597         DISPLAY '***************PCSMT604****************'        
C33887         PERFORM 9900-ABEND            THRU 9900-EXIT             
TP4597     END-IF.                                                      
TP4597*                                                                         
TP4597 7530-EXIT.                                                       
TP4597     EXIT.                                                        
TP4597*                                                                         
      ****************************************************************          
      **                                                            **          
      **  7540-SELECT-ELEC-MTR-SPEC                                 **          
      **                                                            **          
      ****************************************************************          
       7540-SELECT-ELEC-MTR-SPEC.                                       
      *                                                                         
           MOVE '7540'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               SELECT ELEC_MTR_SPEC_CD,                                 
                      METER_SIZE_ID,                                    
                      TOU_RATE_IND,                                     
                      DIGTL_MTR_TYPE,                                   
                      CODE_MAKE,                                        
T33887                REMOTE_READ_CODE                                  
               INTO  :U5-ELEC-MTR-SPEC-CD,                              
                     :U5-METER-SIZE-ID,                                 
                     :U5-TOU-RATE-IND,                                  
                     :U5-DIGTL-MTR-TYPE,                                
                     :U5-CODE-MAKE,                                     
T33887               :U5-REMOTE-READ-CODE                               
               FROM   CSS_ELEC_MTR_SPEC WITH(READUNCOMMITTED)                   
               WHERE  ELEC_MTR_SPEC_CD = :U5-ELEC-MTR-SPEC-CD           
C33887                                                           
A02790                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ELEC_MTR_SPEC_CD,                                         
MFA-TR*               METER_SIZE_ID,                                            
MFA-TR*               TOU_RATE_IND,                                             
MFA-TR*               DIGTL_MTR_TYPE,                                           
MFA-TR*               CODE_MAKE,                                                
MFA-TR*               REMOTE_READ_CODE                                          
MFA-TR*        INTO  :U5-ELEC-MTR-SPEC-CD,                                      
MFA-TR*              :U5-METER-SIZE-ID,                                         
MFA-TR*              :U5-TOU-RATE-IND,                                          
MFA-TR*              :U5-DIGTL-MTR-TYPE,                                        
MFA-TR*              :U5-CODE-MAKE,                                             
MFA-TR*              :U5-REMOTE-READ-CODE                                       
MFA-TR*        FROM   CSS_ELEC_MTR_SPEC                                         
MFA-TR*        WHERE  ELEC_MTR_SPEC_CD = :U5-ELEC-MTR-SPEC-CD                   
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7540                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
C33887     IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
C33887        CONTINUE                                                  
C33887     ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT604***************'         
               DISPLAY '* ERROR ON 7540-SELECT-ELEC-MTR-SPEC *'         
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
C33887         DISPLAY '* ELEC_MTR_SPEC_CD =' U5-ELEC-MTR-SPEC-CD       
               DISPLAY '* PROGRAM ABENDING...                *'         
               DISPLAY '***************PCSMT604***************'         
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7540-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C37481****************************************************************          
C37481**                                                            **          
C37481**  7541-SELECT-FULL-SCALE.                                   **          
C37481**                                                            **          
C37481****************************************************************          
C37481 7541-SELECT-FULL-SCALE.                                          
C37481*                                                                         
C37481     MOVE '7541'                 TO WS-ACTIVE-PARAGRAPH.          
C37481*                                                                         
C37481     EXEC SQL                                                     
C37481         SELECT  FULL_SCALE                                       
A00633                ,MTR_CONNECT_TYP_ID                               
PR#914                ,DEF_MTR_CONSTANT                                 
C37481         INTO   :U0-FULL-SCALE                                    
A00633               ,:U0-MTR-CONNECT-TYP-ID                            
PR#914               ,:U0-DEF-MTR-CONSTANT                              
C37481         FROM   CSS_ELEC_CL_SPEC WITH(READUNCOMMITTED)                    
C37481         WHERE  ELEC_MTR_CLASS_CD  = :U0-ELEC-MTR-CLASS-CD        
C37481           AND  ELEC_MTR_SPEC_CD   = :U0-ELEC-MTR-SPEC-CD         
C37481                                                           
A02790                                                      
C37481     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  FULL_SCALE                                               
MFA-TR*               ,MTR_CONNECT_TYP_ID                                       
MFA-TR*               ,DEF_MTR_CONSTANT                                         
MFA-TR*        INTO   :U0-FULL-SCALE                                            
MFA-TR*              ,:U0-MTR-CONNECT-TYP-ID                                    
MFA-TR*              ,:U0-DEF-MTR-CONSTANT                                      
MFA-TR*        FROM   CSS_ELEC_CL_SPEC                                          
MFA-TR*        WHERE  ELEC_MTR_CLASS_CD  = :U0-ELEC-MTR-CLASS-CD                
MFA-TR*          AND  ELEC_MTR_SPEC_CD   = :U0-ELEC-MTR-SPEC-CD                 
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7541                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C37481*                                                                         
C37481     IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
C37481        CONTINUE                                                  
C37481     ELSE                                                         
C37481        MOVE SQLCODE        TO WS-DISPLAY-RC                      
C37481        DISPLAY '***************PCSMT604***************'          
C37481        DISPLAY '* ERROR ON 7541-SELECT-FULL-SCALE    *'          
C37481        DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
C37481        DISPLAY '* ELEC_MTR_CLASS_CD =' U0-ELEC-MTR-CLASS-CD      
C37481        DISPLAY '* ELEC_MTR_SPEC_CD  =' U0-ELEC-MTR-SPEC-CD       
C37481        DISPLAY '* PROGRAM ABENDING...                *'          
C37481        DISPLAY '***************PCSMT604***************'          
C37481        PERFORM 9900-ABEND            THRU 9900-EXIT              
C37481     END-IF.                                                      
C37481*                                                                         
C37481 7541-EXIT.                                                       
C37481     EXIT.                                                        
      *                                                                         
C33887*================================================================*        
C33887 7550-GET-CURRENT-DATE.                                           
C33887*================================================================*        
C33887*                                                                         
C33887     EXEC SQL                                                     
C33887        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              CIS.CHAR2$DATE(CAST(SYSDATETIMEOFFSET() AS DATE), 'USA')
            INTO
              :WS-DB2-TODAYS-DATE,
              :WS-RUN-DATE                
C33887     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DB2-TODAYS-DATE = CURRENT DATE                            
MFA-TR*          ,:WS-RUN-DATE = CHAR(CURRENT DATE, USA)                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887**                                                                        
C33887     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C33887**                                                                        
C33887     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C33887        CONTINUE                                                  
C33887     ELSE                                                         
C33887        MOVE SQLCODE        TO WS-DISPLAY-RC                      
C33887        DISPLAY '***************PCSMT604***************'          
C33887        DISPLAY '* ERROR IN 7550-GET-CURRENT-DATE     *'          
C33887        DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
C33887        DISPLAY '* PROGRAM ABENDING...                *'          
C33887        DISPLAY '***************PCSMT604***************'          
C33887        PERFORM 9900-ABEND            THRU 9900-EXIT              
C33887     END-IF.                                                      
C33887*                                                                         
C33887 7550-EXIT.                                                       
C33887     EXIT.                                                        
C33887/                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
C33887*================================================================*        
C33887 7660-SELECT-TEST-SCH.                                            
C33887*================================================================*        
C33887*                                                                         
C33887     EXEC SQL                                                     
C33887         SELECT  TEST_SCHED_DESC                                  
C33887           INTO :M3-TEST-SCHED-DESC                               
C33887           FROM  CSS_TEST_SCHEDULE WITH(READUNCOMMITTED)                  
C33887          WHERE  TEST_SCHED_CD = :M3-TEST-SCHED-CD                
C33887                                                           
A02790                                                      
C33887     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  TEST_SCHED_DESC                                          
MFA-TR*          INTO :M3-TEST-SCHED-DESC                                       
MFA-TR*          FROM  CSS_TEST_SCHEDULE                                        
MFA-TR*         WHERE  TEST_SCHED_CD = :M3-TEST-SCHED-CD                        
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7660                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887*                                                                         
C33887     MOVE SQLCODE            TO   WS-ACTIVE-RETURN-CODE           
C33887     IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
C33887         CONTINUE                                                 
C33887     ELSE                                                         
C33887         MOVE SQLCODE        TO WS-DISPLAY-RC                     
C33887         DISPLAY '***************PCSMT604****************'        
C33887         DISPLAY '* ERROR ON 7660-SELECT-TEST-SCH       *'        
C33887         DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
C33887         DISPLAY '* TEST_SCHED_CD = ' M3-TEST-SCHED-CD            
C33887         DISPLAY '***************PCSMT604****************'        
C33887         PERFORM 9900-ABEND            THRU 9900-EXIT             
C33887     END-IF.                                                      
C33887*                                                                         
C33887 7660-EXIT.                                                       
C33887     EXIT.                                                        
C33887/                                                                         
C33887*================================================================*        
C33887 7800-OPEN-CODE-VALUE.                                            
C33887*================================================================*        
C33887*                                                                         
C33887     MOVE '7800'                     TO WS-ACTIVE-PARAGRAPH       
C33887                                                                  
C33887     EXEC SQL                                                     
C33887        OPEN CODE_VAL_CSR                                         
C33887     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887                                                                  
C33887     MOVE SQLCODE            TO   WS-ACTIVE-RETURN-CODE           
C33887     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C33887         CONTINUE                                                 
C33887     ELSE                                                         
C33887         MOVE SQLCODE        TO WS-DISPLAY-RC                     
C33887         DISPLAY '***************PCSMT604****************'        
C33887         DISPLAY '* ERROR ON 7800-OPEN-CODE-VALUE       *'        
C33887         DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
C33887         DISPLAY '* COMPANY_NO = :' WS-CMP-NO                     
C33887         DISPLAY '* TABLE_NA   = :' WS-TABLE-NA                   
C33887         DISPLAY '* COLUMN_NA  = :' WS-COLUMN-NA                  
C33887         DISPLAY '***************PCSMT604****************'        
C33887         PERFORM 9900-ABEND            THRU 9900-EXIT             
C33887     END-IF                                                       
C33887     .                                                            
C33887 7800-EXIT.                                                       
C33887     EXIT.                                                        
C33887/                                                                         
C33887*================================================================*        
C33887 7820-FETCH-CODE-VALUE.                                           
C33887*================================================================*        
C33887*                                                                         
C33887     MOVE '7820'                       TO WS-ACTIVE-PARAGRAPH     
C33887                                                                  
C33887     EXEC SQL                                                     
C33887        FETCH CODE_VAL_CSR                                        
C33887         INTO :WS-CODE-VALUE                                      
C33887     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887*                                                                         
C33887     MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE                
C33887     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
C33887         CONTINUE                                                 
C33887     ELSE                                                         
C33887         MOVE SQLCODE        TO WS-DISPLAY-RC                     
C33887         DISPLAY '***************PCSMT604****************'        
C33887         DISPLAY '* ERROR ON 7820-FETCH-CODE-VALUE      *'        
C33887         DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
C33887         DISPLAY '* COMPANY_NO = :' WS-CMP-NO                     
C33887         DISPLAY '* TABLE_NA   = :' WS-TABLE-NA                   
C33887         DISPLAY '* COLUMN_NA  = :' WS-COLUMN-NA                  
C33887         DISPLAY '***************PCSMT604****************'        
C33887         PERFORM 9900-ABEND            THRU 9900-EXIT             
C33887     END-IF                                                       
C33887     .                                                            
C33887 7820-EXIT.                                                       
C33887     EXIT.                                                        
C33887/                                                                         
C33887*================================================================*        
C33887 7840-CLOSE-CODE-VALUE.                                           
C33887*================================================================*        
C33887*                                                                         
C33887     MOVE '7840'                       TO WS-ACTIVE-PARAGRAPH.    
C33887*                                                                         
C33887     EXEC SQL                                                     
C33887        CLOSE CODE_VAL_CSR                                        
C33887     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887*                                                                         
C33887     MOVE SQLCODE        TO WS-ACTIVE-RETURN-CODE                 
C33887     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C33887         CONTINUE                                                 
C33887     ELSE                                                         
C33887         MOVE SQLCODE        TO WS-DISPLAY-RC                     
C33887         DISPLAY '***************PCSMT604****************'        
C33887         DISPLAY '* ERROR ON 7840-CLOSE-CODE-VALUE      *'        
C33887         DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
C33887         DISPLAY '* COMPANY_NO = :' WS-CMP-NO                     
C33887         DISPLAY '* TABLE_NA   = :' WS-TABLE-NA                   
C33887         DISPLAY '* COLUMN_NA  = :' WS-COLUMN-NA                  
C33887         DISPLAY '***************PCSMT604****************'        
C33887         PERFORM 9900-ABEND            THRU 9900-EXIT             
C33887     END-IF                                                       
C33887     .                                                            
C33887 7840-EXIT.                                                       
C33887     EXIT.                                                        
C33887/                                                                         
C33887*================================================================*        
C33887 7860-VALIDATE-PURCHASE-DATE.                                     
C33887*================================================================*        
C33887                                                                  
C33887     EXEC SQL                                                     
C33887       SELECT
              DATEADD( MONTH, :WS-WARRANTY-MONTHS, 
              IIF(TRY_CONVERT(DATE, :WS-PURCHASE-DB2-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-PURCHASE-DB2-DT
              ) <> 0) OR (LEN(:WS-PURCHASE-DB2-DT
              ) <> 10), CIS.CHAR2DATE(:WS-PURCHASE-DB2-DT
              ), CONVERT(DATE, :WS-PURCHASE-DB2-DT) ) )
            INTO
              :WS-WARRANTY-DB2-DT 
C33887     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-WARRANTY-DB2-DT =                                          
MFA-TR*          DATE(:WS-PURCHASE-DB2-DT) + :WS-WARRANTY-MONTHS MONTHS         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887**                                                                        
C33887     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C33887**                                                                        
C33887 7860-EXIT.                                                       
C33887     EXIT.                                                        
C33887/                                                                         
P00462*                                                                         
P00462*================================================================*        
P00462 7950-FORMAT-ATTACHMENT.                                          
P00462*================================================================*        
P00462*                                                                         
P00462     EXEC SQL                                                     
P00462          SELECT
              CIS.SUBSTR3('000000000000',1 ,                           
P00462            (12 - DATALENGTH(RTRIM(LTRIM(:WS-FRMT-ATT))))) + 
           RTRIM(LTRIM(:WS-FRMT-ATT))
            INTO
              :WS-FRMT-ATT                   
P00462     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-FRMT-ATT   =                                            
MFA-TR*             SUBSTR('000000000000',1 ,                                   
MFA-TR*           (12 - LENGTH(RTRIM(LTRIM(:WS-FRMT-ATT)))))                    
MFA-TR*                 || RTRIM(LTRIM(:WS-FRMT-ATT))                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00462                                                                  
P00462     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00462*                                                                         
P00462     IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
P00462        MOVE SQLCODE        TO WS-DISPLAY-RC                      
P00462        DISPLAY '***************PCSMT604****************'         
P00462        DISPLAY '* ERROR ON 7950-FORMAT-ATTACHMENT     *'         
P00462        DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
P00462        DISPLAY '** ATTACHMENT NO  : ' WS-FRMT-ATT                
P00462        DISPLAY '***************PCSMT604****************'         
P00462        PERFORM 9900-ABEND            THRU 9900-EXIT              
P00462     END-IF.                                                      
P00462*                                                                         
P00462 7950-EXIT.                                                       
P00462     EXIT.                                                        
P00462*                                                                         
P00462*================================================================*        
P00462 7960-FORMAT-SERIAL-NO.                                           
P00462*================================================================*        
P00462*                                                                         
P00462     EXEC SQL                                                     
P00462          SELECT
              CIS.SUBSTR3('00000000000',1 ,                            
P00462            (11 - DATALENGTH(RTRIM(LTRIM(:WS-FRMT-SERIAL-NO))
           ))) + RTRIM(LTRIM(:WS-FRMT-SERIAL-NO))
            INTO
              :WS-FRMT-SERIAL-NO             
P00462     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-FRMT-SERIAL-NO =                                        
MFA-TR*             SUBSTR('00000000000',1 ,                                    
MFA-TR*           (11 - LENGTH(RTRIM(LTRIM(:WS-FRMT-SERIAL-NO)))))              
MFA-TR*                 || RTRIM(LTRIM(:WS-FRMT-SERIAL-NO))                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00462                                                                  
P00462     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00462*                                                                         
P00462     IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
P00462        MOVE SQLCODE        TO WS-DISPLAY-RC                      
P00462        DISPLAY '***************PCSMT604****************'         
P00462        DISPLAY '* ERROR ON 7960-FORMAT-ATTACHMENT     *'         
P00462        DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
P00462        DISPLAY '** METER NO       : ' E-FMT19-METER-NO           
P00462        DISPLAY '** SERIAL NO      : ' WS-FRMT-SERIAL-NO          
P00462        DISPLAY '***************PCSMT604****************'         
P00462        PERFORM 9900-ABEND            THRU 9900-EXIT              
P00462     END-IF.                                                      
P00462*                                                                         
P00462 7960-EXIT.                                                       
P00462     EXIT.                                                        
P00462*                                                                         
      ****************************************************************          
      **                                                            **          
      **  8000-INITIALIZE                                           **          
      **                                                            **          
      ****************************************************************          
       8000-INITIALIZE.                                                 
      *                                                                         
           MOVE WS-N                   TO WS-RECORD-FLAG.               
           COMPUTE WS-ERR-ARRAY-IDX  = 0.                               
           COMPUTE WS-NO-CAP-COUNTER = 0.                               
           INITIALIZE DCLCSS-EQUIPMENT,                                 
                      DCLCSS-ELEC-METER,                                
C33887                DCLCSS-MTR-CAP,                                   
C33887                ERROR-HOLD-AREA,                                  
C33887                DCLCSS-EQUIP-ATTCHMTS,                            
C33887                DCLCSS-METER-ATTCHMTS.                            
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
TP4597**  8100-READ-METER-FILE, FCSMT19-FILE                        **          
      **                                                            **          
      ****************************************************************          
       8100-READ-METER-FILE.                                            
      *                                                                         
TP4597     READ FCSMT19-FILE                                            
               AT END MOVE 'Y'         TO WS-EOF-FLAG.                  
      *                                                                         
           IF FIRST-READ                                                
               MOVE 'N'                TO WS-READ-FLAG                  
           END-IF.                                                      
      *                                                                         
           IF NOT END-OF-FILE                                           
               ADD 1                   TO WS-NBR-METER-RECS             
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T19249*****************************************************************         
T19249* IF LINE COUNTER IS > 56 PRINTS THE PAGE HEADINGS, MOVES INPUT**         
T19249* VARIABLES TO THE REPORT VARIABLES AND  PRINTS THE REPORT.    **         
T19249*****************************************************************         
T19249*                                                                         
T19249 8105-WRITE-PRINTER-RECORD.                                       
T19249     IF WS-LINE-CNTR > WS-FIFTY-SIX                               
T19249        PERFORM 8200-PRT-HEADINGS       THRU 8200-EXIT            
T19249        ADD WS-TWO                      TO WS-LINE-CNTR           
T19249        SET ERROR-FOUND                 TO TRUE                   
T19249     END-IF.                                                      
T19249     MOVE WS-DET-LINE-1                  TO PRT33-DATA.           
T19249     PERFORM 8300-WRITE-PRINT-REC        THRU 8300-EXIT.          
T19249     MOVE WS-ONE                         TO WS-LINE-SPACE.        
T19249     ADD WS-ONE                          TO WS-LINE-CNTR.         
T19249 8105-EXIT.                                                       
T19249     EXIT.                                                        
T19249*                                                                         
T19249****************************************************************          
T19249*  PRINTS THE PAGE HEADINGS  AT THE TOP OF EACH PAGE          **          
T19249****************************************************************          
T19249*                                                                         
T19249 8200-PRT-HEADINGS.                                               
T19249     MOVE 0                              TO WS-LINE-CNTR.         
T19249     ADD WS-ONE                          TO WS-PAGE.              
T19249     MOVE WS-PAGE                        TO WS-DET-PAGE.          
T19249     MOVE WS-HDR-ONE                     TO PRT33-DATA.           
T19249     WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
T19249     MOVE WS-HDR-TWO                     TO PRT33-DATA.           
T19249     MOVE WS-ONE                         TO WS-LINE-SPACE.        
T19249     PERFORM 8300-WRITE-PRINT-REC        THRU 8300-EXIT.          
T19249     MOVE WS-BLANK-LINE                  TO PRT33-DATA.           
T19249     PERFORM 8300-WRITE-PRINT-REC        THRU 8300-EXIT.          
T19249     MOVE WS-HDR-THREE                   TO PRT33-DATA.           
T19249     MOVE WS-TWO                         TO WS-LINE-SPACE.        
T19249     PERFORM 8300-WRITE-PRINT-REC        THRU 8300-EXIT.          
T19249     MOVE WS-BLANK-LINE                  TO PRT33-DATA.           
T19249     MOVE WS-ONE                         TO WS-LINE-SPACE.        
T19249     PERFORM 8300-WRITE-PRINT-REC        THRU 8300-EXIT.          
T19249     ADD  WS-SIX                         TO WS-LINE-CNTR.         
T19249*                                                                         
T19249 8200-EXIT.                                                       
T19249     EXIT.                                                        
T19249*                                                                         
T19249 8300-WRITE-PRINT-REC.                                            
T19249     WRITE PRT33-RECORD AFTER ADVANCING WS-LINE-SPACE.            
T19249*                                                                         
T19249 8300-EXIT.                                                       
T19249     EXIT.                                                        
T19249*                                                                         
      ****************************************************************          
      **                                                            **          
      **  8600-INSERT-EQUIP                                         **          
      **                                                            **          
      ****************************************************************          
       8600-INSERT-EQUIP.                                               
      *                                                                         
           MOVE '8600'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_EQUIPMENT                                
                  ( CODE_UTIL_TYPE    ,                                 
                    DEVICE_NO         ,                                 
                    EQUIP_TYPE_CD     ,                                 
                    PALETTE_NO        ,                                 
                    SERIAL_NO         ,                                 
                    DATE_PURCHASED    ,                                 
                    DATE_DISPOSED_OF  ,                                 
                    WARRANTY_EXP_DT   ,                                 
                    INSTALL_EMP_ID    ,                                 
                    INSTALL_DT        ,                                 
                    CODE_CRNT_LOC     ,                                 
                    CRNT_LOC_NO       ,                                 
                    DATE_LAST_TRAN    ,                                 
                    DATE_LAST_MOVE    ,                                 
                    LOCAL_OFFICE      ,                                 
                    MFR_DT            ,                                 
                    CODE_MAKE         ,                                 
                    DATE_OBSOLETE     ,                                 
                    UPGRADES_TX       ,                                 
                    HAZARD_MATERIAL_CD,                                 
A#4200              FERC_ACCOUNT_NO   ,                                 
C33887              COMPANY_NO        ,                                 
C33887              EQUIP_COMMENTS_TX )                                 
               VALUES                                                   
                  (:EQ-CODE-UTIL-TYPE                            ,      
                   :EQ-DEVICE-NO                                 ,      
                   :EQ-EQUIP-TYPE-CD                             ,      
                   :EQ-PALETTE-NO                                ,      
                   :EQ-SERIAL-NO                                 ,      
                   IIF(TRY_CONVERT(DATE, :EQ-DATE-PURCHASED 
                                         :WS-DATE-PURCHASED-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-PURCHASED 
                                                :WS-DATE-PURCHASED-NULL
              ) <> 0) OR (LEN(:EQ-DATE-PURCHASED 
                                                :WS-DATE-PURCHASED-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-PURCHASED 
                                                :WS-DATE-PURCHASED-NULL
              ), CONVERT(DATE, :EQ-DATE-PURCHASED 
                                                :WS-DATE-PURCHASED-NULL
              ) )  ,      
                   IIF(TRY_CONVERT(DATE, :EQ-DATE-DISPOSED-OF 
                                         :WS-DATE-DISPOSED-OF-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-DISPOSED-OF 
                                              :WS-DATE-DISPOSED-OF-NULL
              ) <> 0) OR (LEN(:EQ-DATE-DISPOSED-OF 
                                              :WS-DATE-DISPOSED-OF-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-DISPOSED-OF 
                                              :WS-DATE-DISPOSED-OF-NULL
              ), CONVERT(DATE, :EQ-DATE-DISPOSED-OF 
                                              :WS-DATE-DISPOSED-OF-NULL
              ) ),      
                   IIF(TRY_CONVERT(DATE, :EQ-WARRANTY-EXP-DT 
                                         :WS-WARRANTY-EXP-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-WARRANTY-EXP-DT 
                                               :WS-WARRANTY-EXP-DT-NULL
              ) <> 0) OR (LEN(:EQ-WARRANTY-EXP-DT 
                                               :WS-WARRANTY-EXP-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-WARRANTY-EXP-DT 
                                               :WS-WARRANTY-EXP-DT-NULL
              ), CONVERT(DATE, :EQ-WARRANTY-EXP-DT 
                                               :WS-WARRANTY-EXP-DT-NULL
              ) ) ,      
                   :EQ-INSTALL-EMP-ID                            ,      
                   IIF(TRY_CONVERT(DATE, :EQ-INSTALL-DT 
                                         :WS-INSTALL-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-INSTALL-DT 
                                                    :WS-INSTALL-DT-NULL
              ) <> 0) OR (LEN(:EQ-INSTALL-DT :WS-INSTALL-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-INSTALL-DT 
                                                    :WS-INSTALL-DT-NULL
              ), CONVERT(DATE, :EQ-INSTALL-DT :WS-INSTALL-DT-NULL
              ) )      ,      
                   :EQ-CODE-CRNT-LOC                             ,      
                   :EQ-CRNT-LOC-NO                               ,      
                   IIF(TRY_CONVERT(DATE, :EQ-DATE-LAST-TRAN 
                                         :WS-DATE-LAST-TRAN-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-TRAN 
                                                :WS-DATE-LAST-TRAN-NULL
              ) <> 0) OR (LEN(:EQ-DATE-LAST-TRAN 
                                                :WS-DATE-LAST-TRAN-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-TRAN 
                                                :WS-DATE-LAST-TRAN-NULL
              ), CONVERT(DATE, :EQ-DATE-LAST-TRAN 
                                                :WS-DATE-LAST-TRAN-NULL
              ) )  ,      
                   IIF(TRY_CONVERT(DATE, :EQ-DATE-LAST-MOVE 
                                         :WS-DATE-LAST-MOVE-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-MOVE 
                                                :WS-DATE-LAST-MOVE-NULL
              ) <> 0) OR (LEN(:EQ-DATE-LAST-MOVE 
                                                :WS-DATE-LAST-MOVE-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-MOVE 
                                                :WS-DATE-LAST-MOVE-NULL
              ), CONVERT(DATE, :EQ-DATE-LAST-MOVE 
                                                :WS-DATE-LAST-MOVE-NULL
              ) )  ,      
C33887             :EQ-LOCAL-OFFICE                              ,      
                   IIF(TRY_CONVERT(DATE, :EQ-MFR-DT :WS-MFR-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-MFR-DT :WS-MFR-DT-NULL
              ) <> 0) OR (LEN(:EQ-MFR-DT :WS-MFR-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-MFR-DT :WS-MFR-DT-NULL
              ), CONVERT(DATE, :EQ-MFR-DT :WS-MFR-DT-NULL) )          ,      
                   :EQ-CODE-MAKE                                 ,      
                   IIF(TRY_CONVERT(DATE, :EQ-DATE-OBSOLETE 
                                         :WS-DATE-OBSOLETE-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-OBSOLETE 
                                                 :WS-DATE-OBSOLETE-NULL
              ) <> 0) OR (LEN(:EQ-DATE-OBSOLETE :WS-DATE-OBSOLETE-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-OBSOLETE 
                                                 :WS-DATE-OBSOLETE-NULL
              ), CONVERT(DATE, :EQ-DATE-OBSOLETE :WS-DATE-OBSOLETE-NULL
              ) )   ,      
                   :EQ-UPGRADES-TX                               ,      
                   :EQ-HAZARD-MATERIAL-CD                        ,      
A#4200             :EQ-FERC-ACCOUNT-NO                           ,      
C33887             :EQ-COMPANY-NO                                ,      
C33887             :EQ-EQUIP-COMMENTS-TX )                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_EQUIPMENT                                        
MFA-TR*           ( CODE_UTIL_TYPE    ,                                         
MFA-TR*             DEVICE_NO         ,                                         
MFA-TR*             EQUIP_TYPE_CD     ,                                         
MFA-TR*             PALETTE_NO        ,                                         
MFA-TR*             SERIAL_NO         ,                                         
MFA-TR*             DATE_PURCHASED    ,                                         
MFA-TR*             DATE_DISPOSED_OF  ,                                         
MFA-TR*             WARRANTY_EXP_DT   ,                                         
MFA-TR*             INSTALL_EMP_ID    ,                                         
MFA-TR*             INSTALL_DT        ,                                         
MFA-TR*             CODE_CRNT_LOC     ,                                         
MFA-TR*             CRNT_LOC_NO       ,                                         
MFA-TR*             DATE_LAST_TRAN    ,                                         
MFA-TR*             DATE_LAST_MOVE    ,                                         
MFA-TR*             LOCAL_OFFICE      ,                                         
MFA-TR*             MFR_DT            ,                                         
MFA-TR*             CODE_MAKE         ,                                         
MFA-TR*             DATE_OBSOLETE     ,                                         
MFA-TR*             UPGRADES_TX       ,                                         
MFA-TR*             HAZARD_MATERIAL_CD,                                         
MFA-TR*             FERC_ACCOUNT_NO   ,                                         
MFA-TR*             COMPANY_NO        ,                                         
MFA-TR*             EQUIP_COMMENTS_TX )                                         
MFA-TR*        VALUES                                                           
MFA-TR*           (:EQ-CODE-UTIL-TYPE                            ,              
MFA-TR*            :EQ-DEVICE-NO                                 ,              
MFA-TR*            :EQ-EQUIP-TYPE-CD                             ,              
MFA-TR*            :EQ-PALETTE-NO                                ,              
MFA-TR*            :EQ-SERIAL-NO                                 ,              
MFA-TR*            :EQ-DATE-PURCHASED   :WS-DATE-PURCHASED-NULL  ,              
MFA-TR*            :EQ-DATE-DISPOSED-OF :WS-DATE-DISPOSED-OF-NULL,              
MFA-TR*            :EQ-WARRANTY-EXP-DT  :WS-WARRANTY-EXP-DT-NULL ,              
MFA-TR*            :EQ-INSTALL-EMP-ID                            ,              
MFA-TR*            :EQ-INSTALL-DT       :WS-INSTALL-DT-NULL      ,              
MFA-TR*            :EQ-CODE-CRNT-LOC                             ,              
MFA-TR*            :EQ-CRNT-LOC-NO                               ,              
MFA-TR*            :EQ-DATE-LAST-TRAN   :WS-DATE-LAST-TRAN-NULL  ,              
MFA-TR*            :EQ-DATE-LAST-MOVE   :WS-DATE-LAST-MOVE-NULL  ,              
MFA-TR*            :EQ-LOCAL-OFFICE                              ,              
MFA-TR*            :EQ-MFR-DT           :WS-MFR-DT-NULL          ,              
MFA-TR*            :EQ-CODE-MAKE                                 ,              
MFA-TR*            :EQ-DATE-OBSOLETE    :WS-DATE-OBSOLETE-NULL   ,              
MFA-TR*            :EQ-UPGRADES-TX                               ,              
MFA-TR*            :EQ-HAZARD-MATERIAL-CD                        ,              
MFA-TR*            :EQ-FERC-ACCOUNT-NO                           ,              
MFA-TR*            :EQ-COMPANY-NO                                ,              
MFA-TR*            :EQ-EQUIP-COMMENTS-TX )                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
T33887     MOVE SQLCODE        TO WS-ACTIVE-RETURN-CODE                 
TP4597     IF SQLCODE EQUAL SUCCESSFUL-CALL OR -803                     
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '***********PCSMT604**************'              
               DISPLAY '* ERROR INSERTING CSS_EQUIPMENT *'              
               DISPLAY '* METER NUMBER IS ', EQ-DEVICE-NO               
T22243         DISPLAY '* COMPANY-NO   IS ', EQ-COMPANY-NO              
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...           *'              
               DISPLAY '***********PCSMT604**************'              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  8610-INSERT-ELEC-METER                                    **          
      **                                                            **          
      ****************************************************************          
       8610-INSERT-ELEC-METER.                                          
      *                                                                         
           MOVE '8610'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_ELEC_METER                               
                    ( CODE_UTIL_TYPE     ,                              
                      METER_NO           ,                              
                      AMPS               ,                              
                      CODE_GEAR_REDUCTN  ,                              
                      KH_OR_KE           ,                              
                      NO_WIRES           ,                              
                      NO_PHASES          ,                              
                      REG_NO             ,                              
                      REG_UPPER_FRACTION ,                              
                      REG_LOWER_FRACTION ,                              
                      SOLID_ST_DIP_SET   ,                              
                      VOLTAGE            ,                              
                      WATTS_PER_PULSE    ,                              
                      PULSES_PER_REV     ,                              
                      CODE_ATTACHMENTS   ,                              
                      CODE_METER_TYPE    ,                              
                      DATE_LAST_TESTED   ,                              
                      METER_SIZE_ID      ,                              
                      MTR_CONNECT_TYP_ID ,                              
                      DEVICE_TYPE_CD     ,                              
                      TEST_SCHED_CD      ,                              
                      TOU_RATE_IND       ,                              
                      IDR_MEMORY_SIZE    ,                              
PCR040                ELEC_MTR_CLASS_CD  ,                              
PCR040                ELEC_MTR_SPEC_CD   ,                              
                      DIGTL_MTR_TYPE     ,                              
C26373                PROGRAM_ID         ,                              
T22243                COMPANY_NO )                                      
             VALUES                                                     
                  ( :EM-CODE-UTIL-TYPE     ,                            
                    :EM-METER-NO           ,                            
                    :EM-AMPS               ,                            
                    :EM-CODE-GEAR-REDUCTN  ,                            
                    :EM-KH-OR-KE           ,                            
                    :EM-NO-WIRES           ,                            
                    :EM-NO-PHASES          ,                            
                    :EM-REG-NO             ,                            
                    :EM-REG-UPPER-FRACTION ,                            
                    :EM-REG-LOWER-FRACTION ,                            
                    :EM-SOLID-ST-DIP-SET   ,                            
                    :EM-VOLTAGE            ,                            
                    :EM-WATTS-PER-PULSE    ,                            
                    :EM-PULSES-PER-REV     ,                            
                    :EM-CODE-ATTACHMENTS   ,                            
                    :EM-CODE-METER-TYPE    ,                            
TP4597              IIF(TRY_CONVERT(DATE, :EM-DATE-LAST-TESTED 
                                          :WS-DATE-LAST-TESTED-NULL
              ) IS NULL OR (PATINDEX('%.%', :EM-DATE-LAST-TESTED 
                                              :WS-DATE-LAST-TESTED-NULL
              ) <> 0) OR (LEN(:EM-DATE-LAST-TESTED 
                                              :WS-DATE-LAST-TESTED-NULL
              ) <> 10), CIS.CHAR2DATE(:EM-DATE-LAST-TESTED 
                                              :WS-DATE-LAST-TESTED-NULL
              ), CONVERT(DATE, :EM-DATE-LAST-TESTED 
                                              :WS-DATE-LAST-TESTED-NULL
              ) ),     
                    :EM-METER-SIZE-ID      ,                            
                    :EM-MTR-CONNECT-TYP-ID ,                            
                    :EM-DEVICE-TYPE-CD     ,                            
                    :EM-TEST-SCHED-CD      ,                            
                    :EM-TOU-RATE-IND       ,                            
                    :EM-IDR-MEMORY-SIZE    ,                            
PCR040              :EM-ELEC-MTR-CLASS-CD  ,                            
PCR040              :EM-ELEC-MTR-SPEC-CD   ,                            
                    :EM-DIGTL-MTR-TYPE     ,                            
C26373              :EM-PROGRAM-ID         ,                            
T22243              :EM-COMPANY-NO )                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_ELEC_METER                                       
MFA-TR*             ( CODE_UTIL_TYPE     ,                                      
MFA-TR*               METER_NO           ,                                      
MFA-TR*               AMPS               ,                                      
MFA-TR*               CODE_GEAR_REDUCTN  ,                                      
MFA-TR*               KH_OR_KE           ,                                      
MFA-TR*               NO_WIRES           ,                                      
MFA-TR*               NO_PHASES          ,                                      
MFA-TR*               REG_NO             ,                                      
MFA-TR*               REG_UPPER_FRACTION ,                                      
MFA-TR*               REG_LOWER_FRACTION ,                                      
MFA-TR*               SOLID_ST_DIP_SET   ,                                      
MFA-TR*               VOLTAGE            ,                                      
MFA-TR*               WATTS_PER_PULSE    ,                                      
MFA-TR*               PULSES_PER_REV     ,                                      
MFA-TR*               CODE_ATTACHMENTS   ,                                      
MFA-TR*               CODE_METER_TYPE    ,                                      
MFA-TR*               DATE_LAST_TESTED   ,                                      
MFA-TR*               METER_SIZE_ID      ,                                      
MFA-TR*               MTR_CONNECT_TYP_ID ,                                      
MFA-TR*               DEVICE_TYPE_CD     ,                                      
MFA-TR*               TEST_SCHED_CD      ,                                      
MFA-TR*               TOU_RATE_IND       ,                                      
MFA-TR*               IDR_MEMORY_SIZE    ,                                      
MFA-TR*               ELEC_MTR_CLASS_CD  ,                                      
MFA-TR*               ELEC_MTR_SPEC_CD   ,                                      
MFA-TR*               DIGTL_MTR_TYPE     ,                                      
MFA-TR*               PROGRAM_ID         ,                                      
MFA-TR*               COMPANY_NO )                                              
MFA-TR*      VALUES                                                             
MFA-TR*           ( :EM-CODE-UTIL-TYPE     ,                                    
MFA-TR*             :EM-METER-NO           ,                                    
MFA-TR*             :EM-AMPS               ,                                    
MFA-TR*             :EM-CODE-GEAR-REDUCTN  ,                                    
MFA-TR*             :EM-KH-OR-KE           ,                                    
MFA-TR*             :EM-NO-WIRES           ,                                    
MFA-TR*             :EM-NO-PHASES          ,                                    
MFA-TR*             :EM-REG-NO             ,                                    
MFA-TR*             :EM-REG-UPPER-FRACTION ,                                    
MFA-TR*             :EM-REG-LOWER-FRACTION ,                                    
MFA-TR*             :EM-SOLID-ST-DIP-SET   ,                                    
MFA-TR*             :EM-VOLTAGE            ,                                    
MFA-TR*             :EM-WATTS-PER-PULSE    ,                                    
MFA-TR*             :EM-PULSES-PER-REV     ,                                    
MFA-TR*             :EM-CODE-ATTACHMENTS   ,                                    
MFA-TR*             :EM-CODE-METER-TYPE    ,                                    
MFA-TR*             :EM-DATE-LAST-TESTED :WS-DATE-LAST-TESTED-NULL,             
MFA-TR*             :EM-METER-SIZE-ID      ,                                    
MFA-TR*             :EM-MTR-CONNECT-TYP-ID ,                                    
MFA-TR*             :EM-DEVICE-TYPE-CD     ,                                    
MFA-TR*             :EM-TEST-SCHED-CD      ,                                    
MFA-TR*             :EM-TOU-RATE-IND       ,                                    
MFA-TR*             :EM-IDR-MEMORY-SIZE    ,                                    
MFA-TR*             :EM-ELEC-MTR-CLASS-CD  ,                                    
MFA-TR*             :EM-ELEC-MTR-SPEC-CD   ,                                    
MFA-TR*             :EM-DIGTL-MTR-TYPE     ,                                    
MFA-TR*             :EM-PROGRAM-ID         ,                                    
MFA-TR*             :EM-COMPANY-NO )                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '***********PCSMT604**************'              
               DISPLAY '* ERROR INSERTING CSS_ELEC_METER*'              
               DISPLAY '* METER NUMBER IS ', EQ-DEVICE-NO               
T22243         DISPLAY '* COMPANY NO   IS ', EM-COMPANY-NO              
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...           *'              
               DISPLAY '***********PCSMT604**************'              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  8620-INSERT-MTR-CAP                                       **          
      **                                                            **          
      ****************************************************************          
       8620-INSERT-MTR-CAP.                                             
      *                                                                         
           MOVE '8620'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_MTR_CAP                                  
                    ( CODE_UTIL_TYPE        ,                           
                      METER_NO              ,                           
                      REG_ID_NO             ,                           
                      CODE_CAP_TYPE         ,                           
                      CONSTANT              ,                           
                      NO_READ_DIALS         ,                           
                      NO_DIALS              ,                           
                      K_Q_LEAD_LAG_IND      ,                           
                      DEMAND_TYPE           ,                           
                      FULL_SCALE            ,                           
                      CODE_HIGH_LOW_DIAL    ,                           
                      REG_MEASURES_CD       ,                           
T22243                COMPANY_NO )                                      
               VALUES ( :MC-CODE-UTIL-TYPE     ,                        
                        :MC-METER-NO           ,                        
                        :MC-REG-ID-NO          ,                        
                        :MC-CODE-CAP-TYPE      ,                        
                        :MC-CONSTANT           ,                        
                        :MC-NO-READ-DIALS      ,                        
                        :MC-NO-DIALS           ,                        
                        :MC-K-Q-LEAD-LAG-IND   ,                        
                        :MC-DEMAND-TYPE        ,                        
                        :MC-FULL-SCALE         ,                        
                        :MC-CODE-HIGH-LOW-DIAL ,                        
                        :MC-REG-MEASURES-CD    ,                        
T22243                  :MC-COMPANY-NO )                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '***********PCSMT604**************'              
               DISPLAY '* ERROR INSERTING CSS_MTR_CAP   *'              
               DISPLAY '* METER NUMBER IS ', EQ-DEVICE-NO               
T22243         DISPLAY '* COMPANY NO   IS ', MC-COMPANY-NO              
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...           *'              
               DISPLAY '***********PCSMT604**************'              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C33887/                                                                         
C33887*================================================================*        
C33887 8630-INSERT-EQUIP-ATTCHMTS.                                      
C33887*================================================================*        
C33887*                                                                         
C33887     EXEC SQL                                                     
C33887         INSERT INTO CSS_EQUIP_ATTCHMTS                           
C33887             (  DEVICE_NO                                         
C33887               ,CODE_ATT_TYPE                                     
C33887               ,COMPANY_NO                                        
C33887               ,CODE_UTIL_TYPE                                    
C33887               ,EQUIP_LOC_ID                                      
C33887               ,MTR_STORAGE_FAC_CD                                
C33887               ,CODE_MAKE                                         
C33887               ,TEST_SCHED_CD                                     
C33887               ,VERSION_CD                                        
C33887               ,EQUIP_ATTACH_DT                                   
C33887               ,DATE_LAST_MOVE                                    
C33887               ,DATE_LAST_TESTED                                  
C33887               ,DATE_LAST_TRAN                                    
C33887               ,DATE_PURCHASED                                    
C33887               ,WARRANTY_EXP_DT                                   
C33887               ,DATE_OBSOLETE                                     
P00462               ,SERIAL_NO                                         
C33887               ,DATE_DISPOSED_OF)                                 
C33887         VALUES                                                   
C33887             (  :LX-DEVICE-NO                                     
C33887               ,:LX-CODE-ATT-TYPE                                 
C33887               ,:LX-COMPANY-NO                                    
C33887               ,:LX-CODE-UTIL-TYPE                                
C33887               ,:LX-EQUIP-LOC-ID                                  
C33887               ,:LX-MTR-STORAGE-FAC-CD                            
C33887               ,:LX-CODE-MAKE                                     
C33887               ,:LX-TEST-SCHED-CD                                 
C33887               ,:LX-VERSION-CD                                    
C33887               ,IIF(TRY_CONVERT(DATE, :LX-EQUIP-ATTACH-DT 
                                            :WS-LX-EQIP-ATT-IND
              ) IS NULL OR (PATINDEX('%.%', :LX-EQUIP-ATTACH-DT 
                                                    :WS-LX-EQIP-ATT-IND
              ) <> 0) OR (LEN(:LX-EQUIP-ATTACH-DT :WS-LX-EQIP-ATT-IND
              ) <> 10), CIS.CHAR2DATE(:LX-EQUIP-ATTACH-DT 
                                                    :WS-LX-EQIP-ATT-IND
              ), CONVERT(DATE, :LX-EQUIP-ATTACH-DT :WS-LX-EQIP-ATT-IND
              ) )           
C33887               ,IIF(TRY_CONVERT(DATE, :LX-DATE-LAST-MOVE 
                                            :WS-LX-LAST-MOVE-IND
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-MOVE 
                                                   :WS-LX-LAST-MOVE-IND
              ) <> 0) OR (LEN(:LX-DATE-LAST-MOVE :WS-LX-LAST-MOVE-IND
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-MOVE 
                                                   :WS-LX-LAST-MOVE-IND
              ), CONVERT(DATE, :LX-DATE-LAST-MOVE :WS-LX-LAST-MOVE-IND
              ) )          
C33887               ,IIF(TRY_CONVERT(DATE, :LX-DATE-LAST-TESTED 
                                            :WS-LX-LAST-TEST-IND
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-TESTED 
                                                   :WS-LX-LAST-TEST-IND
              ) <> 0) OR (LEN(:LX-DATE-LAST-TESTED :WS-LX-LAST-TEST-IND
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-TESTED 
                                                   :WS-LX-LAST-TEST-IND
              ), CONVERT(DATE, :LX-DATE-LAST-TESTED 
                                                   :WS-LX-LAST-TEST-IND
              ) )          
C33887               ,IIF(TRY_CONVERT(DATE, :LX-DATE-LAST-TRAN 
                                            :WS-LX-LAST-TRAN-IND
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-TRAN 
                                                   :WS-LX-LAST-TRAN-IND
              ) <> 0) OR (LEN(:LX-DATE-LAST-TRAN :WS-LX-LAST-TRAN-IND
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-TRAN 
                                                   :WS-LX-LAST-TRAN-IND
              ), CONVERT(DATE, :LX-DATE-LAST-TRAN :WS-LX-LAST-TRAN-IND
              ) )          
C33887               ,IIF(TRY_CONVERT(DATE, :LX-DATE-PURCHASED 
                                            :WS-LX-PUR-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-PURCHASED 
                                                      :WS-LX-PUR-DT-IND
              ) <> 0) OR (LEN(:LX-DATE-PURCHASED :WS-LX-PUR-DT-IND
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-PURCHASED 
                                                      :WS-LX-PUR-DT-IND
              ), CONVERT(DATE, :LX-DATE-PURCHASED :WS-LX-PUR-DT-IND) )         
C33887               ,IIF(TRY_CONVERT(DATE, :LX-WARRANTY-EXP-DT 
                                            :WS-LX-WAR-EXP-IND
              ) IS NULL OR (PATINDEX('%.%', :LX-WARRANTY-EXP-DT 
                                                     :WS-LX-WAR-EXP-IND
              ) <> 0) OR (LEN(:LX-WARRANTY-EXP-DT :WS-LX-WAR-EXP-IND
              ) <> 10), CIS.CHAR2DATE(:LX-WARRANTY-EXP-DT 
                                                     :WS-LX-WAR-EXP-IND
              ), CONVERT(DATE, :LX-WARRANTY-EXP-DT :WS-LX-WAR-EXP-IND
              ) )            
C33887               ,IIF(TRY_CONVERT(DATE, :LX-DATE-OBSOLETE 
                                            :WS-LX-OBSOL-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-OBSOLETE 
                                                    :WS-LX-OBSOL-DT-IND
              ) <> 0) OR (LEN(:LX-DATE-OBSOLETE :WS-LX-OBSOL-DT-IND
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-OBSOLETE 
                                                    :WS-LX-OBSOL-DT-IND
              ), CONVERT(DATE, :LX-DATE-OBSOLETE :WS-LX-OBSOL-DT-IND) )        
P00462               ,:LX-SERIAL-NO                                     
C33887               ,IIF(TRY_CONVERT(DATE, :LX-DATE-DISPOSED-OF 
                                            :WS-LX-DISP-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-DISPOSED-OF 
                                                     :WS-LX-DISP-DT-IND
              ) <> 0) OR (LEN(:LX-DATE-DISPOSED-OF :WS-LX-DISP-DT-IND
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-DISPOSED-OF 
                                                     :WS-LX-DISP-DT-IND
              ), CONVERT(DATE, :LX-DATE-DISPOSED-OF :WS-LX-DISP-DT-IND
              ) ) )          
C33887     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_EQUIP_ATTCHMTS                                   
MFA-TR*            (  DEVICE_NO                                                 
MFA-TR*              ,CODE_ATT_TYPE                                             
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,CODE_UTIL_TYPE                                            
MFA-TR*              ,EQUIP_LOC_ID                                              
MFA-TR*              ,MTR_STORAGE_FAC_CD                                        
MFA-TR*              ,CODE_MAKE                                                 
MFA-TR*              ,TEST_SCHED_CD                                             
MFA-TR*              ,VERSION_CD                                                
MFA-TR*              ,EQUIP_ATTACH_DT                                           
MFA-TR*              ,DATE_LAST_MOVE                                            
MFA-TR*              ,DATE_LAST_TESTED                                          
MFA-TR*              ,DATE_LAST_TRAN                                            
MFA-TR*              ,DATE_PURCHASED                                            
MFA-TR*              ,WARRANTY_EXP_DT                                           
MFA-TR*              ,DATE_OBSOLETE                                             
MFA-TR*              ,SERIAL_NO                                                 
MFA-TR*              ,DATE_DISPOSED_OF)                                         
MFA-TR*        VALUES                                                           
MFA-TR*            (  :LX-DEVICE-NO                                             
MFA-TR*              ,:LX-CODE-ATT-TYPE                                         
MFA-TR*              ,:LX-COMPANY-NO                                            
MFA-TR*              ,:LX-CODE-UTIL-TYPE                                        
MFA-TR*              ,:LX-EQUIP-LOC-ID                                          
MFA-TR*              ,:LX-MTR-STORAGE-FAC-CD                                    
MFA-TR*              ,:LX-CODE-MAKE                                             
MFA-TR*              ,:LX-TEST-SCHED-CD                                         
MFA-TR*              ,:LX-VERSION-CD                                            
MFA-TR*              ,:LX-EQUIP-ATTACH-DT :WS-LX-EQIP-ATT-IND                   
MFA-TR*              ,:LX-DATE-LAST-MOVE  :WS-LX-LAST-MOVE-IND                  
MFA-TR*              ,:LX-DATE-LAST-TESTED:WS-LX-LAST-TEST-IND                  
MFA-TR*              ,:LX-DATE-LAST-TRAN  :WS-LX-LAST-TRAN-IND                  
MFA-TR*              ,:LX-DATE-PURCHASED  :WS-LX-PUR-DT-IND                     
MFA-TR*              ,:LX-WARRANTY-EXP-DT :WS-LX-WAR-EXP-IND                    
MFA-TR*              ,:LX-DATE-OBSOLETE   :WS-LX-OBSOL-DT-IND                   
MFA-TR*              ,:LX-SERIAL-NO                                             
MFA-TR*              ,:LX-DATE-DISPOSED-OF:WS-LX-DISP-DT-IND )                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887*                                                                         
C33887     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
C33887         CONTINUE                                                 
C33887     ELSE                                                         
C33887         MOVE SQLCODE        TO WS-DISPLAY-RC                     
C33887         DISPLAY '***************PCSMT604****************'        
C33887         DISPLAY '* ERROR ON 8630-INSERT-EQUIP-ATTCHMTS *'        
C33887         DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
C33887         DISPLAY '* UTIL TYPE:' LX-CODE-UTIL-TYPE                 
C33887         DISPLAY '* ATT  TYPE:' LX-CODE-ATT-TYPE                  
C33887         DISPLAY '* ATTACH NBR:' LX-DEVICE-NO                     
C33887         DISPLAY '***************PCSMT604****************'        
C33887         PERFORM 9900-ABEND            THRU 9900-EXIT             
C33887     END-IF.                                                      
C33887*                                                                         
C33887 8630-EXIT.                                                       
C33887     EXIT.                                                        
C33887/                                                                         
C33887*================================================================*        
C33887 8640-INSERT-MTR-ATTACH.                                          
C33887*================================================================*        
C33887*                                                                         
C33887     EXEC SQL                                                     
C33887         INSERT INTO CSS_METER_ATTCHMTS                           
C33887             (  CODE_UTIL_TYPE                                    
C33887               ,METER_NO                                          
C33887               ,CODE_DEVICE_TYPE                                  
C33887               ,DEVICE_NO                                         
C33887               ,CODE_ATT_TYPE                                     
C33887               ,CT_PT_RATIO                                       
C33887               ,CODE_MAKE                                         
C33887               ,DATE_LAST_TESTED                                  
C33887               ,TEST_SCHED_CD                                     
C33887               ,HOW_ATTACHED_CD                                   
C33887               ,COMPANY_NO)                                       
C33887         VALUES                                                   
C33887             (  :MA-CODE-UTIL-TYPE                                
C33887               ,:MA-METER-NO                                      
C33887               ,:MA-CODE-DEVICE-TYPE                              
C33887               ,:MA-DEVICE-NO                                     
C33887               ,:MA-CODE-ATT-TYPE                                 
C33887               ,:MA-CT-PT-RATIO                                   
C33887               ,:MA-CODE-MAKE                                     
C33887               ,IIF(TRY_CONVERT(DATE, :MA-DATE-LAST-TESTED 
                                            :WS-MA-LAST-TEST-IND
              ) IS NULL OR (PATINDEX('%.%', :MA-DATE-LAST-TESTED 
                                                   :WS-MA-LAST-TEST-IND
              ) <> 0) OR (LEN(:MA-DATE-LAST-TESTED :WS-MA-LAST-TEST-IND
              ) <> 10), CIS.CHAR2DATE(:MA-DATE-LAST-TESTED 
                                                   :WS-MA-LAST-TEST-IND
              ), CONVERT(DATE, :MA-DATE-LAST-TESTED 
                                                   :WS-MA-LAST-TEST-IND
              ) )          
C33887               ,:MA-TEST-SCHED-CD                                 
C33887               ,:MA-HOW-ATTACHED-CD                               
C33887               ,:MA-COMPANY-NO)                                   
C33887     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_METER_ATTCHMTS                                   
MFA-TR*            (  CODE_UTIL_TYPE                                            
MFA-TR*              ,METER_NO                                                  
MFA-TR*              ,CODE_DEVICE_TYPE                                          
MFA-TR*              ,DEVICE_NO                                                 
MFA-TR*              ,CODE_ATT_TYPE                                             
MFA-TR*              ,CT_PT_RATIO                                               
MFA-TR*              ,CODE_MAKE                                                 
MFA-TR*              ,DATE_LAST_TESTED                                          
MFA-TR*              ,TEST_SCHED_CD                                             
MFA-TR*              ,HOW_ATTACHED_CD                                           
MFA-TR*              ,COMPANY_NO)                                               
MFA-TR*        VALUES                                                           
MFA-TR*            (  :MA-CODE-UTIL-TYPE                                        
MFA-TR*              ,:MA-METER-NO                                              
MFA-TR*              ,:MA-CODE-DEVICE-TYPE                                      
MFA-TR*              ,:MA-DEVICE-NO                                             
MFA-TR*              ,:MA-CODE-ATT-TYPE                                         
MFA-TR*              ,:MA-CT-PT-RATIO                                           
MFA-TR*              ,:MA-CODE-MAKE                                             
MFA-TR*              ,:MA-DATE-LAST-TESTED:WS-MA-LAST-TEST-IND                  
MFA-TR*              ,:MA-TEST-SCHED-CD                                         
MFA-TR*              ,:MA-HOW-ATTACHED-CD                                       
MFA-TR*              ,:MA-COMPANY-NO)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887*                                                                         
C33887     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
C33887         CONTINUE                                                 
C33887     ELSE                                                         
C33887         MOVE SQLCODE        TO WS-DISPLAY-RC                     
C33887         DISPLAY '***************PCSMT604****************'        
C33887         DISPLAY '* ERROR ON 8640-INSERT-MTR-ATTACH     *'        
C33887         DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
C33887         DISPLAY '* MTR NBR ' MA-METER-NO                         
C33887         DISPLAY '* ATTACH NBR ' MA-DEVICE-NO                     
C33887         DISPLAY '***************PCSMT604****************'        
C33887         PERFORM 9900-ABEND            THRU 9900-EXIT             
C33887     END-IF.                                                      
C33887*                                                                         
C33887 8640-EXIT.                                                       
C33887     EXIT.                                                        
      *                                                                         
T35434*================================================================*        
T35434 8800-WRITE-RESTART.                                              
T35434*================================================================*        
T35434*                                                                         
T35434     ADD  1                     TO  WS-CHKP-SEQ-NO.               
T35434     MOVE WS-CHKP-SEQ-NO        TO WS-RESTART-CHKP-SEQ-NO.        
T35434*                                                                         
T35434     MOVE WS-PGRMNAME            TO RF-NAME-PROGRAM.              
T35434     MOVE 1                      TO RF-PARTITION-NO.              
T35434     MOVE 1                      TO RF-DUP-CNTRL-NO.              
T35434     MOVE WS-RESTART-DATA        TO RF-RESTART-DATA-TEXT.         
T35434     MOVE WS-RESTART-DATA-LENGTH TO RF-RESTART-DATA-LEN.          
T35434*                                                                         
T35434     PERFORM 8850-UPDATE-RESTART           THRU 8850-EXIT.        
T35434     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
T35434        PERFORM 8860-INSERT-RESTART        THRU 8860-EXIT         
T35434     END-IF.                                                      
T35434*                                                                         
T35434 8800-EXIT.                                                       
T35434      EXIT.                                                       
T35434*                                                                         
T35434*================================================================*        
T35434 8850-UPDATE-RESTART.                                             
T35434*================================================================*        
T35434*                                                                         
T35434        EXEC SQL                                                  
T35434            UPDATE CSS_RESTART                                    
T35434            SET RESTART_DATA   = :RF-RESTART-DATA                 
T35434            WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                 
T35434              AND PARTITION_NO = :RF-PARTITION-NO                 
T35434              AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                 
T35434        END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35434*                                                                         
T35434        MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.        
T35434*                                                                         
T35434        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
T35434                                       OR NOT-FOUND               
T35434           CONTINUE                                               
T35434        ELSE                                                      
T35434           DISPLAY '**  ERROR ON 8850-UPDATE-RESTART  *'          
T35434           DISPLAY '**  NAME_PROGRAM = ' RF-NAME-PROGRAM          
T35434           DISPLAY '**  PARTITION_NO = ' RF-PARTITION-NO          
T35434           DISPLAY '**  DUP_CNTRL_NO = ' RF-DUP-CNTRL-NO          
T35434           DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
T35434           DISPLAY '**      PROCESSING TERMINATED     **'         
T35434           PERFORM 9900-ABEND            THRU 9900-EXIT           
T35434        END-IF.                                                   
T35434*                                                                         
T35434 8850-EXIT.                                                       
T35434      EXIT.                                                       
T35434*                                                                         
T35434*================================================================*        
T35434 8860-INSERT-RESTART.                                             
T35434*================================================================*        
T35434*                                                                         
T35434        EXEC SQL                                                  
T35434             INSERT INTO CSS_RESTART                              
T35434                         (NAME_PROGRAM                            
T35434                         ,PARTITION_NO                            
T35434                         ,DUP_CNTRL_NO                            
T35434                         ,RESTART_DATA)                           
T35434             VALUES    (:RF-NAME-PROGRAM                          
T35434                       ,:RF-PARTITION-NO                          
T35434                       ,:RF-DUP-CNTRL-NO                          
T35434                       ,:RF-RESTART-DATA)                         
T35434        END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35434*                                                                         
T35434        MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.        
T35434*                                                                         
T35434        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
T35434           CONTINUE                                               
T35434        ELSE                                                      
T35434           DISPLAY '**  ERROR ON 8860-INSERT-RESTART  *'          
T35434           DISPLAY '**  NAME_PROGRAM = ' RF-NAME-PROGRAM          
T35434           DISPLAY '**  PARTITION_NO = ' RF-PARTITION-NO          
T35434           DISPLAY '**  DUP_CNTRL_NO = ' RF-DUP-CNTRL-NO          
T35434           DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
T35434           DISPLAY '**      PROCESSING TERMINATED     **'         
T35434           PERFORM 9900-ABEND            THRU 9900-EXIT           
T35434        END-IF.                                                   
T35434*                                                                         
T35434 8860-EXIT.                                                       
T35434      EXIT.                                                       
T35434*                                                                         
T35434******************************************************************        
T35434* 8893-RESET-RESTART-REQ-PARM                                    *        
T35434******************************************************************        
T35434     EXEC SQL                                                             
T35434         INCLUDE CPD00029                                                 
T35434     END-EXEC.                                                            
T35434*                                                                         
      ****************************************************************          
      **                                                            **          
      **  8900-PRODUCE-SUMMARY-REPORTS                              **          
      **                                                            **          
      ****************************************************************          
       8900-PRODUCE-SUMMARY-REPORTS.                                    
      *                                                                         
T19249     IF WS-LINE-CNTR > WS-FIFTY-TWO                               
T19249        PERFORM 8200-PRT-HEADINGS       THRU 8200-EXIT            
T19249        ADD WS-TWO               TO WS-LINE-CNTR                  
T19249     END-IF.                                                      
T19249     MOVE WS-ONE                 TO WS-LINE-SPACE.                
T19249     IF NOT ERROR-FOUND                                           
T19249        MOVE WS-NO-ERROR-LINE    TO PRT33-DATA                    
T19249        PERFORM 8300-WRITE-PRINT-REC    THRU 8300-EXIT            
T19249     END-IF.                                                      
T19249     MOVE WS-BLANK-LINE          TO PRT33-DATA.                   
T19249     PERFORM 8300-WRITE-PRINT-REC       THRU 8300-EXIT.           
T19249     MOVE WS-TOT-RECDS-INFO      TO WS-RPT-MESSAGE.               
T19249     MOVE WS-NBR-METER-RECS      TO WS-RPT-STATISTICS.            
T19249     MOVE WS-DET-LINE-2          TO PRT33-DATA.                   
T19249     PERFORM 8300-WRITE-PRINT-REC       THRU 8300-EXIT.           
T19249     MOVE WS-TOT-GOOD-RECDS      TO WS-RPT-MESSAGE.               
T19249     MOVE WS-NBR-GOOD-RECS       TO WS-RPT-STATISTICS.            
T19249     MOVE WS-DET-LINE-2          TO PRT33-DATA.                   
T19249     PERFORM 8300-WRITE-PRINT-REC       THRU 8300-EXIT.           
T19249     MOVE WS-TOT-BAD-RECDS       TO WS-RPT-MESSAGE.               
T19249     MOVE WS-NBR-BAD-RECS        TO WS-RPT-STATISTICS.            
T19249     MOVE WS-DET-LINE-2          TO PRT33-DATA.                   
T19249     PERFORM 8300-WRITE-PRINT-REC       THRU 8300-EXIT.           
T19249     MOVE WS-TOT-UNADDED-MTRS    TO WS-RPT-MESSAGE.               
T19249     MOVE WS-NO-ADDITION-MTRS    TO WS-RPT-STATISTICS.            
T19249     MOVE WS-DET-LINE-2          TO PRT33-DATA.                   
T19249     PERFORM 8300-WRITE-PRINT-REC       THRU 8300-EXIT.           
T19249     MOVE WS-BLANK-LINE          TO PRT33-DATA.                   
T19249     PERFORM 8300-WRITE-PRINT-REC       THRU 8300-EXIT.           
T19249     MOVE WS-FOOT-LINE           TO PRT33-DATA.                   
T19249     PERFORM 8300-WRITE-PRINT-REC       THRU 8300-EXIT.           
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
TP4597 8950-INSERT-WORK-QUEUE-ITEM.                                     
TP4597                                                                  
A04860     CALL SCSCB077  USING   CWS00077-FIELDS,                      
A04860                            ABEND-FILE,                           
A04860                            RS-RETURN-CODE.                       
A04860*                                                                         
A04860     MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE.   
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE  PROGRAM-NAME            TO ABEND-PROGRAM            
A04860        DISPLAY '8950-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     ELSE                                                         
A04860        MOVE WS-77-WQ-ITEM-ID         TO WS-ITEM-ID               
A04860     END-IF.                                                      
TP4597*                                                                         
TP4597 8950-EXIT.                                                       
TP4597     EXIT.                                                        
      ****************************************************************          
      **                                                            **          
      **  9000-TERMINATE                                            **          
      **                                                            **          
      ****************************************************************          
       9000-TERMINATE.                                                  
      *                                                                         
TP4597     CLOSE FCSMT19-FILE                                           
T19249           FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE     **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
