       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSMT601.                                        
       DATE-WRITTEN.   OCT 2006.                                        
       DATE-COMPILED.                                                   
      ****************************************************************          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                      DB2                       ********          
      ****************************************************************          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      **           DATE    INITIALS       REASON                    **          
      **         ________  ________   _____________________________ **          
T35434**11/07/07 RK12999  IMPELEMENTED RESTART / COMMIT LOGIC       **          
T35434**                                                            **          
A02034**18/06/10 SP94986  NOT TOGET RC=9 WHEN ERROR RPT IS GENERATED**          
P00462**01/03/10 SS95855  PROGRAM ENHANCED TO HANDLE GAS & ELECTRIC **          
a04860**10/12/15 SS95855  Openway AMI Metering                      **          
A04860**07/02/16 MR7E794  REMOVED THE UNUSED CODE OF INSERT FOR     **          
A04860**         ACT121   CSS_WQ_ITMES_MF IN PARA 7550.             **          
      ****************************************************************          
           REMARKS.                                                     
                              PCSMT601 NARRATIVE                        
                      METER ATTACHMENT BATCH ADD PROGRAM                
      *                                                                         
                 THIS PROGRAM READS A VENDOR FILE CONTAINING            
                 METER INFORMATION FOR NEW ATTACHMENT METERS. AN EDIT   
                 CHECK IS DONE TO ENSURE THE DATA IS CORRECT.  IF IT    
                 IS, THE DATABASE IS UPDATED ACCORDINGLY. IF PROBLEMS   
                 ARE FOUND IN A RECORD THEY ARE WRITTEN TO THE FCSPT33  
                 FILE AND PROCESSING CONTINUES.  IF AN ERROR OCCURS     
                 WHEN UPDATING THE DATABASE, IT IS WRITTEN TO THE       
                 ERROR FILE AND PROCESSING STOPS.PCSMT601 WILL PRINT    
                 THE ERRORS.                                            
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT ATT-METER-FILE ASSIGN UT-S-FCSMT25.                   
           SELECT FCSPT33-FILE   ASSIGN UT-S-FCSPT33.                   
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
      *                                                                         
       FD  ATT-METER-FILE                                               
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       COPY FIOMT25.                                                            
      *                                                                         
       FD  FCSPT33-FILE                                                 
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRT33-RECORD.                                                
           05  PRT33-CC                  PIC X(01).                     
           05  PRT33-DATA                PIC X(132).                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSMT601'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
             'WORKING STORAGE FOR PCSMT601 STARTS HERE'.                
      *                                                                         
T35434 COPY CWS00303.                                                           
      *                                                                         
T35434 COPY FIOJC01.                                                            
T35434 COPY FIOCA00.                                                            
T35434 COPY CWS00038.                                                           
T35434 COPY CWS00039.                                                           
T35434 COPY CWS00037.                                                           
      *                                                                         
       01  WS-DATE-PARAMETERS.                                          
           05  WS-PARM-DAY-REQUIRED     PIC X      VALUE 'F'.           
               88  EDIT-MMYY-ONLY        VALUE 'S'.                     
           05  WS-PARM-DATE-REQUIRED    PIC X      VALUE 'Y'.           
               88  VALIDATE-NOT-REQUIRED VALUE 'N'.                     
               88  VALIDATE-REQUIRED     VALUE 'Y'.                     
           05  WS-PARM-OPERATOR         PIC X(02)  VALUE SPACES.        
       01  WS-DATE-FLAGS           VALUE ZEROES.                        
           05  DAY-FLAG                  PIC 9.                         
               88  INVALID-DAY     VALUE 1.                             
           05  MONTH-FLAG                PIC 9.                         
               88  INVALID-MONTH   VALUE 1.                             
           05  YEAR-FLAG                 PIC 9.                         
               88  INVALID-YEAR    VALUE 1.                             
           05  CENTURY-FLAG              PIC 9.                         
               88  INVALID-CENTURY VALUE 1.                             
       01  WS-DATE-FORMATS      VALUE ZEROES.                           
           05  WS-IN-DATE.                                              
               10  WS-IN-CC        PIC XX.                              
               10  WS-IN-YY        PIC XX.                              
               10  WS-IN-MM        PIC XX.                              
               10  WS-IN-DD        PIC XX.                              
           05  WS-RETURN-DATE      PIC 9(08).                           
           05  FILLER  REDEFINES  WS-RETURN-DATE.                       
               10  WS-RETURN-SHORT-DATE.                                
                   15  WS-RETURN-CCYY  PIC 9(04).                       
                   15  FILLER  REDEFINES  WS-RETURN-CCYY.               
                       20  WS-RETURN-CC   PIC 9(02).                    
                       20  WS-RETURN-YY   PIC 9(02).                    
                   15  WS-RETURN-MM    PIC 99.                          
                       88  THIRTY-DAY     VALUE 04 06 09 11.            
                       88  THIRTY-ONE-DAY VALUE 01 03 05 07 08 10 12.   
               10  WS-RETURN-DD     PIC 99.                             
           05  WS-CURRENT-FULL-DATE.                                    
               10  WS-CURRENT-SHORT-DATE.                               
                   15  WS-CURRENT-CMPR-CCYY    PIC 9(04).               
                   15  FILLER  REDEFINES  WS-CURRENT-CMPR-CCYY.         
                       20  WS-CURRENT-CMPR-CC  PIC 9(02).               
                       20  WS-CURRENT-CMPR-YY  PIC 9(02).               
                   15  WS-CURRENT-CMPR-MM    PIC 99.                    
               10  WS-CURRENT-CMPR-DD    PIC 99.                        
       01  WS-WORK-FIELDS         VALUE ZEROES.                         
           05  WS-RESULT             PIC 9(02).                         
           05  WS-REMAINDER-DATE     PIC 9(04).                         
           05  WS-UPPER-LIMIT        PIC 9(02).                         
           05  WS-DATE-OPERATOR-FLAG PIC X(02).                         
           05  WS-CENTURY-INDICATOR  PIC 9(02).                         
               88 20TH-CENTURY                   VALUE 19.              
               88 21ST-CENTURY                   VALUE 20.              
       01  WS-DATE-COMPARE-OPTIONS.                                     
           05  WS-NA                 PIC X(02)   VALUE 'NA'.            
           05  WS-GT                 PIC X(02)   VALUE 'GT'.            
           05  WS-GE                 PIC X(02)   VALUE 'GE'.            
           05  WS-LT                 PIC X(02)   VALUE 'LT'.            
           05  WS-LE                 PIC X(02)   VALUE 'LE'.            
           05  WS-EQ                 PIC X(02)   VALUE 'EQ'.            
      *                                                                         
      ***************** E N D   O F    C W S 0 0 0 2 6 *****************        
      ******************************************************************        
      *                                                                         
      *                                                                         
       01  WS-ABEND-SWITCH                PIC X(03).                    
           88  WS-ABEND-YES               VALUE 'YES'.                  
      *                                                                         
       01  WS-WARNING-DATA-ELEMENTS.                                    
           05  ALREADY-EXISTS             PIC S9(9) VALUE -803 COMP.    
      *                                                                         
       01  WS-WORK-AREA.                                                
           05  WS-DISPLAY-RC           PIC -ZZZZZZZZ9.9.                
           05  WS-PGRMNAME             PIC X(08)     VALUE 'PCSMT601'.  
      *                                                                         
           05  COUNTERS.                                                
               10  WS-NBR-METER-RECS   PIC S9(5)     COMP-3 VALUE 0.    
               10  WS-NBR-GOOD-RECS    PIC S9(5)     COMP-3 VALUE 0.    
               10  WS-NBR-BAD-RECS     PIC S9(5)     COMP-3 VALUE 0.    
               10  WS-NO-ADDITION-MTRS PIC S9(5)     COMP-3 VALUE 0.    
      *                                                                         
           05  WS-LOCAL-OFFICE             PIC X(03).                   
           05  WS-CODE-UTIL-TYPE           PIC X(01).                   
           05  WS-ERROR-ARRAY-SIZE         PIC S9(04) COMP VALUE +0.    
           05  WS-SYSIN-COMP-NO            PIC X(02) VALUE SPACES.      
           05  WS-CODE-VALUE           PIC X(10) VALUE SPACES.          
           05  WS-VER-CODE-SUB         PIC 9(02).                       
           05  WS-COLUMN-NA            PIC X(18) VALUE SPACES.          
           05  WS-TABLE-NA             PIC X(18) VALUE SPACES.          
           05  WS-DB-COMPANY-NO        PIC X(02) VALUE SPACES.          
           05  WS-DB-CODE-UTIL-TYPE    PIC X(01) VALUE SPACES.          
P00462     05  WS-FRMT-ATT             PIC X(12) VALUE SPACES.          
PRJ914     05  WS-ATTCH-COUNT          PIC S9(09) COMP VALUE +0.        
      *                                                                         
           05  WS-NULLIND-DATE-PURCHASED   PIC S9(04) COMP VALUE +0.    
               88  DATE-PURCHASED-NULL                     VALUE -1.    
               88  DATE-PURCHASED-NOT-NULL                 VALUE +0.    
           05  WS-NULLIND-DATE-DISPOSED    PIC S9(04) COMP VALUE +0.    
               88  DATE-DISPOSED-NULL                      VALUE -1.    
               88  DATE-DISPOSED-NOT-NULL                  VALUE +0.    
           05  WS-NULLIND-DATE-OBSOLETE    PIC S9(04) COMP VALUE +0.    
               88  DATE-OBSOLETE-NULL                      VALUE -1.    
               88  DATE-OBSOLETE-NOT-NULL                  VALUE +0.    
           05  WS-NULLIND-WARRANTY-DATE    PIC S9(04) COMP VALUE +0.    
               88  WARRANTY-DATE-NULL                      VALUE -1.    
               88  WARRANTY-DATE-NOT-NULL                  VALUE +0.    
           05  WS-NULLIND-DATE-LAST-TRAN   PIC S9(04) COMP VALUE +0.    
               88  DATE-LAST-TRAN-NULL                     VALUE -1.    
               88  DATE-LAST-TRAN-NOT-NULL                 VALUE +0.    
           05  WS-NULLIND-DATE-LAST-MOVE   PIC S9(04) COMP VALUE +0.    
               88  DATE-LAST-MOVE-NULL                     VALUE -1.    
               88  DATE-LAST-MOVE-NOT-NULL                 VALUE +0.    
           05  WS-NULLIND-DATE-LAST-TESTED PIC S9(04) COMP VALUE +0.    
               88  DATE-LAST-TESTED-NULL                   VALUE -1.    
               88  DATE-LAST-TESTED-NOT-NULL               VALUE +0.    
           05  WS-NULLIND-ATTACH-DT        PIC S9(04) COMP VALUE +0.    
               88  ATTACH-DT-NULL                          VALUE -1.    
               88  ATTACH-DT-NOT-NULL                      VALUE +0.    
      *                                                                         
           05  INDEXES.                                                 
               10  WS-ERR-ARRAY-IDX        PIC S9(04) COMP VALUE +0.    
      *                                                                         
           05  FLAGS.                                                   
               10  WS-EOF-FLAG         PIC X(01)    VALUE 'N'.          
                   88  END-OF-FILE                  VALUE 'Y'.          
               10  WS-RECORD-FLAG      PIC X(01)    VALUE 'N'.          
                   88  GOOD-RECORD                  VALUE 'N'.          
               10  NO-ERROR-FOUND      PIC X(01)    VALUE 'Y'.          
                   88  ERROR-FOUND                  VALUE 'N'.          
               10  WS-CODE-VAL-MATCH-SW  PIC X(01)  VALUE 'N'.          
                   88  WS-CODE-VAL-NOT-MATCHED      VALUE 'N'.          
                   88  WS-CODE-VAL-MATCHED          VALUE 'Y'.          
               10  WS-VALID-ATTACHMENT-SW PIC X(01) VALUE 'Y'.          
                   88  WS-VALID-ATTACHMENT          VALUE 'Y'.          
                   88  WS-NOT-VALID-ATTACHMENT      VALUE 'N'.          
               10  WS-ATT-TYPE-EXIST-SW  PIC X(01)  VALUE 'Y'.          
                   88  WS-ATT-TYPE-NOT-EXISTS       VALUE 'Y'.          
                   88  WS-ATT-TYPE-EXISTS           VALUE 'N'.          
PRJ914         10  WS-ATTACHED-FLAG    PIC X(01)    VALUE 'N'.          
PRJ914             88  ATTACHED-TO-MTR              VALUE 'Y'.          
PRJ914             88  NOT-ATTACHED-TO-MTR          VALUE 'N'.          
      *                                                                         
           05  WS-TEMP-CC              PIC 99.                          
           05  WS-SYS-DATE.                                             
               10  WS-SYS-DATE-YY      PIC 9(02).                       
               10  WS-SYS-DATE-MM      PIC 9(02).                       
               10  WS-SYS-DATE-DD      PIC 9(02).                       
           05  WS-DB2-TODAYS-DATE      PIC X(10).                       
           05  WS-WARRANTY-DATE        PIC X(10).                       
           05  WS-WARRANTY-MTHS        PIC S9(04) COMP VALUE +0.        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-ONE                  PIC 9(01)    VALUE 1.            
           05  WS-TWO                  PIC 9(01)    VALUE 2.            
           05  WS-SIX                  PIC 9(01)    VALUE 6.            
           05  WS-FIFTY-SIX            PIC 9(02)    VALUE 56.           
           05  WS-FIFTY-TWO            PIC 9(02)    VALUE 52.           
           05  WS-A                    PIC X(01)    VALUE 'A'.          
           05  WS-B                    PIC X(01)    VALUE 'B'.          
           05  WS-M                    PIC X(01)    VALUE 'M'.          
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
T35434     05  WS-I                    PIC X(01)    VALUE 'I'.          
       01  ERROR-HOLD-AREA.                                             
           05  ERROR-ARRAY OCCURS 100 TIMES.                            
               10  ERR-METER-NBR       PIC X(20).                       
               10  ERR-FIELD           PIC X(20).                       
               10  ERR-PROBLEM         PIC X(46).                       
      *                                                                         
      * TABLE TO STORE VERSION CODE VALUES                                      
       01  VERSION-CODE-AREA.                                           
           05 WS-VER-CODE-VAL-TAB.                                      
              10 WS-VER-CODE-VAL-ROW OCCURS 50 TIMES                    
                              INDEXED BY WS-VER-INDX.                   
                 15 WS-TAB-UTL-CODE-VAL       PIC X(01).                
                 15 WS-TAB-ATT-CODE-VAL       PIC X(02).                
                 15 WS-TAB-VER-CODE-VAL       PIC X(03).                
      *                                                                         
       01  WS-HDR-ONE.                                                  
           05 FILLER                   PIC X(08)  VALUE                 
              'PCSMT601'.                                               
           05 FILLER                   PIC X(39)  VALUE SPACES.         
           05 FILLER                   PIC X(39)  VALUE                 
              'SOUTH CAROLINA ELECTRIC AND GAS COMPANY'.                
           05 FILLER                   PIC X(30)  VALUE SPACES.         
           05 FILLER                   PIC X(06)  VALUE                 
              'PAGE: '.                                                 
           05 FILLER                   PIC X(06)  VALUE SPACES.         
           05 WS-DET-PAGE              PIC ZZZZ   VALUE SPACES.         
      *                                                                         
       01  WS-HDR-TWO.                                                  
           05 FILLER                   PIC X(48)  VALUE SPACES.         
           05 FILLER                   PIC X(32)  VALUE                 
              'ATTACHMENT METER ADDITION ERRORS'.                       
           05 FILLER                   PIC X(36)  VALUE SPACES.         
           05 FILLER                   PIC X(06)  VALUE                 
              'DATE: '.                                                 
           05 WS-RUN-DATE.                                              
              10 WS-RUN-DATE-MM        PIC X(02) VALUE SPACES.          
              10 FILLER                PIC X(01) VALUE '/'.             
              10 WS-RUN-DATE-DD        PIC X(02) VALUE SPACES.          
              10 FILLER                PIC X(01) VALUE '/'.             
              10 WS-RUN-DATE-CC        PIC X(02) VALUE SPACES.          
              10 WS-RUN-DATE-YY        PIC X(02) VALUE SPACES.          
      *                                                                         
       01  WS-HDR-THREE.                                                
           05 FILLER                   PIC X(05)  VALUE SPACES.         
           05 FILLER                   PIC X(13)  VALUE                 
              'ATTACHMENT NO'.                                          
           05 FILLER                   PIC X(20)  VALUE SPACES.         
           05 FILLER                   PIC X(11)  VALUE                 
              'ERROR FIELD'.                                            
           05 FILLER                   PIC X(20)  VALUE SPACES.         
           05 FILLER                   PIC X(12)  VALUE                 
              'PROBLEM DESC'.                                           
      *                                                                         
       01 WS-DET-LINE-1.                                                
          05  FILLER                   PIC X(02)  VALUE SPACES.         
          05  WS-RPT-ATTACH-NO         PIC X(20).                       
          05  FILLER                   PIC X(16)  VALUE SPACES.         
          05  WS-RPT-ERROR-FIELD       PIC X(20).                       
          05  FILLER                   PIC X(11)  VALUE SPACES.         
          05  WS-RPT-PROBLEM-DESC      PIC X(46).                       
      *                                                                         
       01 WS-DET-LINE-2.                                                
          05  FILLER                   PIC X(05)  VALUE SPACES.         
          05  WS-RPT-MESSAGE           PIC X(20)  VALUE SPACES.         
          05  FILLER                   PIC X(03)                        
              VALUE ':  '.                                              
          05  WS-RPT-STATISTICS        PIC ZZZZ9  VALUE SPACES.         
      *                                                                         
       01  WS-FOOT-LINE.                                                
           05 FILLER                           PIC X(55)  VALUE SPACES. 
           05 FILLER                           PIC X(22)  VALUE         
              '*** END OF  REPORT ***'.                                 
           05 FILLER                           PIC X(55)  VALUE SPACES. 
      *                                                                         
       01  WS-NO-ERROR-LINE.                                            
           05 FILLER                           PIC X(55)  VALUE SPACES. 
           05 FILLER                           PIC X(23)  VALUE         
              '*** NO ERRORS FOUND ***'.                                
           05 FILLER                           PIC X(54)  VALUE SPACES. 
      *                                                                         
       01  WS-ERROR-RPT-MSGS.                                           
           05 WS-TOT-RECDS-INFO        PIC X(18)    VALUE               
              ' TOTAL I/P RECORDS'.                                     
           05 WS-TOT-GOOD-RECDS        PIC X(13)    VALUE               
              ' GOOD RECORDS'.                                          
           05 WS-TOT-BAD-RECDS         PIC X(12)    VALUE               
              ' BAD RECORDS'.                                           
           05 WS-TOT-UNADDED-MTRS      PIC X(17)    VALUE               
              ' NOT ADDED METERS'.                                      
      *                                                                         
       01  WS-VARIABLES.                                                
           05 WS-LINE-CNTR                     PIC 9(02)  VALUE 57.     
           05 WS-BLANK-LINE                    PIC X(132) VALUE SPACES. 
           05 WS-PAGE                          PIC 9(04)  VALUE ZEROS.  
           05 WS-LINE-SPACE                    PIC 9(01)  VALUE ZERO.   
      *                                                                         
       01  WS-WQ-COMMENTS.                                              
           05  WS-WQ-COMMENTS-LEN   PIC S9(4) USAGE COMP VALUE +84.     
           05  WS-WQ-COMMENTS-TEXT.                                     
               10  FILLER           PIC X(15) VALUE 'ATTACHMENT MTR '.  
               10  WS-WQ-ATTACH-NO  PIC X(12).                          
               10  FILLER           PIC X(01) VALUE SPACES.             
               10  FILLER           PIC X(42) VALUE                     
               'EXISTS ON CSS_EQUIP_ATTCHMTS. CAN NOT ADD '.            
               10  FILLER           PIC X(14) VALUE                     
               'THIS METER.   '.                                        
      *                                                                         
T35434 01  WS-RESTART-MISC.                                             
T35434     05  WS-COUNT-UNSUCCESSFUL-ROWS                               
T35434                                   PIC S9(04)  COMP-3 VALUE ZERO. 
T35434     05  WS-RESTART-DATA-LENGTH    PIC S9(04)  COMP VALUE +39.    
T35434     05  WS-IS-THIS-A-RESTART      PIC X(01)   VALUE 'N'.         
T35434         88  WS-THIS-IS-A-RESTART              VALUE 'Y'.         
T35434     05  WS-RESTART-COMMIT-COUNTER PIC 9(04)   VALUE ZERO.        
T35434     05  WS-RESTART-REQ            PIC X(01).                     
T35434     05  WS-DEFAULT-RESTART-REQ    PIC X(01)   VALUE 'N'.         
T35434     05  WS-PROCESS-TYPE           PIC 9(01).                     
T35434     05  WS-DEFAULT-CHKP-LUW-LIMIT PIC 9(04)   VALUE 4.           
T35434     05  WS-FLAG-TO-TURN-OFF-COMMITS PIC 9(04) VALUE 9999.        
T35434     05  WS-SEQ-NO                 PIC 9(04)   VALUE ZERO.        
T35434     05  WS-CHKP-LUW-LIMIT         PIC 9(04)   VALUE ZERO.        
T35434     05  WS-CHKP-LUW-COUNTER       PIC 9(04)   VALUE ZERO COMP-3. 
T35434     05  WS-DEFAULT-CHKP-UPD-LIMIT PIC 9(04)   VALUE 20.          
T35434     05  WS-CHKP-UPD-LIMIT         PIC 9(04)   VALUE ZERO.        
T35434     05  WS-COMMIT-REQ-SW          PIC X(1)    VALUE 'Y'.         
T35434         88 WS-COMMITS-REQUIRE                 VALUE 'Y'.         
T35434         88 WS-COMMITS-NOT-REQUIRE             VALUE 'N'.         
T35434     05  WS-CHKP-UPD-COUNTER       PIC 9(04)   VALUE ZERO COMP-3. 
T35434     05  WS-CHKP-ID.                                              
T35434         10 WS-CHKP-PGM-ID         PIC X(02)   VALUE '09'.        
T35434         10 WS-CHKP-PART-NO        PIC 9(01)   VALUE 1.           
T35434         10 WS-CHKP-SEQ-NO         PIC 9(05)   VALUE ZERO.        
T35434*                                                                         
T35434 01  WS-RESTART-DATA.                                             
T35434     05  WS-RESTART-PROCESS-TYPE   PIC 9(01).                     
T35434     05  WS-RESTART-JOB-COMPLETE   REDEFINES                      
T35434         WS-RESTART-PROCESS-TYPE   PIC X(01).                     
T35434     05  WS-RESTART-JOB-STATUS     PIC X(01).                     
T35434         88  WS-RUN-COMPLETED-NO-PROBLEMS      VALUE 'A'.         
T35434         88  WS-RERUN-COMPLETED                VALUE 'B'.         
T35434         88  WS-RERUN-PENDING                  VALUE 'C'.         
T35434     05  WS-RESTART-CHKP-SEQ-NO     PIC 9(05).                    
T35434     05  WS-FMT25-DEVICE-NO         PIC X(12).                    
T35434     05  WS-RESTART-FIOMT25-REC-CNTR                              
T35434                                   PIC S9(07)  COMP-3 VALUE ZERO. 
T35434     05  WS-RESTART-GOOD-REC-CNTR                                 
T35434                                   PIC S9(07)  COMP-3 VALUE ZERO. 
T35434     05  WS-RESTART-BAD-REC-CNTR                                  
T35434                                   PIC S9(07)  COMP-3 VALUE ZERO. 
      *                                                                         
      ***  INCLUDE DCLGEN TABLE AND HOST VARIABLE DEFINITIONS                   
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQMAKE                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRFAC                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRATP                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQATTH                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBTSTSCH                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCDVALU                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
T35434     EXEC SQL                                                             
T35434         INCLUDE TBRESTRT                                                 
T35434     END-EXEC.                                                            
T35434*                                                                         
PRJ914     EXEC SQL                                                             
PRJ914         INCLUDE TBMTRATT                                                 
PRJ914     END-EXEC.                                                            
      *****************************************************************         
      **   SQL DECLARE STATEMENTS                                    **         
      *****************************************************************         
      *----------------------------------------------------------------*        
      * CURSOR TO GET EXISTING EQUIP ATTACHMENTS FOR VALIDATION                 
      *----------------------------------------------------------------*        
           EXEC SQL                                                     
               DECLARE EQUIP-ATTCHMTS CURSOR FOR                        
               SELECT  CODE_UTIL_TYPE                                   
                      ,COMPANY_NO                                       
               FROM    CSS_EQUIP_ATTCHMTS WITH(READUNCOMMITTED)                 
               WHERE   DEVICE_NO          = :LX-DEVICE-NO               
                 AND   CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE           
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE EQUIP-ATTCHMTS CURSOR FOR                                
MFA-TR*        SELECT  CODE_UTIL_TYPE                                           
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*        FROM    CSS_EQUIP_ATTCHMTS                                       
MFA-TR*        WHERE   DEVICE_NO          = :LX-DEVICE-NO                       
MFA-TR*          AND   CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE                   
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7410                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      * CURSOR TO GET DATA FROM CODE_VALUE TABLE FOR MULTIPLE PURPOSES          
      *----------------------------------------------------------------*        
           EXEC SQL                                                     
               DECLARE CODE_VAL_CSR CURSOR FOR                          
                   SELECT CODE_VALUE                                    
                    FROM  CSS_CODE_VALUE WITH(READUNCOMMITTED)                  
                   WHERE COMPANY_NO = :WS-SYSIN-COMP-NO                 
                     AND TABLE_NA   = :WS-TABLE-NA                      
                     AND COLUMN_NA  = :WS-COLUMN-NA                     
                     AND PROGRAM_ID = 'ALL'                             
                   FOR READ ONLY                                
A02034                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CODE_VAL_CSR CURSOR FOR                                  
MFA-TR*            SELECT CODE_VALUE                                            
MFA-TR*             FROM  CSS_CODE_VALUE                                        
MFA-TR*            WHERE COMPANY_NO = :WS-SYSIN-COMP-NO                         
MFA-TR*              AND TABLE_NA   = :WS-TABLE-NA                              
MFA-TR*              AND COLUMN_NA  = :WS-COLUMN-NA                             
MFA-TR*              AND PROGRAM_ID = 'ALL'                                     
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7510                                                 
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                      PIC X(40)    VALUE               
             'WORKING STORAGE FOR PCSMT601 ENDS HERE  '.                
      *                                                                         
       PROCEDURE DIVISION.                                              
      ****************************************************************          
      **                                                            **          
      **  0000-MAINLINE                                             **          
      **      CONTROLS MAIN PATH OF PROGRAM                         **          
      **                                                            **          
      ****************************************************************          
       0000-MAINLINE.                                                   
           DISPLAY 'AT BEGINNING OF PROGRAM'.                           
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
      *                                                                         
           PERFORM 1000-PROCESS-FILE             THRU 1000-EXIT         
               UNTIL END-OF-FILE.                                       
      *                                                                         
           PERFORM 8500-PRODUCE-SUMMARY-REPORTS  THRU 8500-EXIT.        
T35434*                                                                         
T35434     PERFORM 1900-PROCESS-SUCCESSFUL-JOB   THRU 1900-EXIT.        
T35434*                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0100-INITIALIZATION                                       **          
      **      OPEN FILES, DO FIRST READ OF METER FILE, ACCEPT DATE  **          
      **                                                            **          
      ****************************************************************          
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN INPUT ATT-METER-FILE                                    
                OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           ACCEPT WS-SYS-DATE FROM DATE.                                
           IF WS-SYS-DATE-YY GREATER THAN 50                            
               MOVE 19                 TO WS-TEMP-CC                    
           ELSE                                                         
               MOVE 20                 TO WS-TEMP-CC                    
           END-IF.                                                      
      *                                                                         
           STRING WS-TEMP-CC,                                           
                  WS-SYS-DATE-YY,                                       
                  '-',                                                  
                  WS-SYS-DATE-MM,                                       
                  '-',                                                  
                  WS-SYS-DATE-DD                                        
                               DELIMITED BY SIZE                        
                                     INTO WS-DB2-TODAYS-DATE            
           END-STRING.                                                  
           MOVE WS-SYS-DATE-MM            TO WS-RUN-DATE-MM.            
           MOVE WS-SYS-DATE-DD            TO WS-RUN-DATE-DD             
           MOVE WS-TEMP-CC                TO WS-RUN-DATE-CC.            
           MOVE WS-SYS-DATE-YY            TO WS-RUN-DATE-YY.            
      *                                                                         
           ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
           IF WS-SYSIN-COMP-NO EQUAL SPACES                             
              MOVE WS-ONE                 TO WS-SYSIN-COMP-NO           
           END-IF.                                                      
      *                                                                         
           PERFORM 0400-GET-VER-CODE-VAL  THRU 0400-EXIT.               
      *                                                                         
           PERFORM 8000-INITIALIZE               THRU 8000-EXIT.        
T35434*                                                                         
T35434     PERFORM 6253-GET-FJC01-CHKP-LIMIT                            
T35434                                           THRU 6253-EXIT.        
T35434     IF WS-CHKP-LUW-LIMIT = WS-FLAG-TO-TURN-OFF-COMMITS           
T35434        AND WS-CHKP-UPD-LIMIT = WS-FLAG-TO-TURN-OFF-COMMITS       
T35434            SET WS-COMMITS-NOT-REQUIRE TO TRUE                    
T35434            DISPLAY ' '                                           
T35434            DISPLAY '**   ' WS-PGRMNAME ' INFORMATIONAL MSG    **'
T35434            DISPLAY '**   CHKP-LUW AND CHKP-UPD PARMS   **'       
T35434            DISPLAY '** BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS 
T35434                    ', INTERPRETED TO**'                          
T35434            DISPLAY '**  INDICATE THAT INTERIM COMMIT   **'       
T35434            DISPLAY '**   POINTS SHOULD NOT BE TAKEN.   **'       
T35434     END-IF.                                                      
T35434*                                                                         
T35434     PERFORM 6235-GET-FJC01-RESTART-REQ                           
T35434                                           THRU  6235-EXIT.       
T35434     PERFORM 0150-CHECK-RESTART            THRU 0150-EXIT.        
T35434*                                                                         
T35434     PERFORM 0605-VALIDATE-RESTART-REQ     THRU 0605-EXIT.        
T35434*                                                                         
T35434     IF WS-THIS-IS-A-RESTART                                      
T35434        PERFORM 0160-REPOSITION-FILE      THRU 0160-EXIT          
T35434     ELSE                                                         
T35434         MOVE ZEROS              TO WS-NBR-GOOD-RECS              
T35434         MOVE ZEROS              TO WS-NBR-BAD-RECS               
T35434         MOVE ZEROS              TO WS-RESTART-GOOD-REC-CNTR      
T35434         MOVE ZEROS              TO WS-RESTART-BAD-REC-CNTR       
T35434         MOVE ZEROS              TO WS-RESTART-FIOMT25-REC-CNTR   
T35434         MOVE ZEROS              TO WS-RESTART-CHKP-SEQ-NO        
T35434         MOVE ZEROS              TO WS-CHKP-SEQ-NO                
T35434     END-IF.                                                      
T35434*                                                                         
           PERFORM 8100-READ-METER-FILE          THRU 8100-EXIT.        
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T35434*===============================================================*         
T35434 0150-CHECK-RESTART.                                              
T35434*===============================================================*         
T35434*                                                                         
T35434     MOVE 'PCSMT601'                       TO RF-NAME-PROGRAM.    
T35434     MOVE 1                                TO RF-PARTITION-NO.    
T35434     MOVE 1                                TO RF-DUP-CNTRL-NO.    
T35434     PERFORM 7800-SELECT-RESTART           THRU 7800-EXIT.        
T35434     IF WS-ACTIVE-RETURN-CODE              EQUAL SUCCESSFUL-CALL  
T35434        MOVE RF-RESTART-DATA-TEXT          TO WS-RESTART-DATA     
T35434        IF WS-RESTART-PROCESS-TYPE NUMERIC                        
T35434           SET WS-THIS-IS-A-RESTART TO TRUE                       
T35434        END-IF                                                    
T35434     END-IF.                                                      
T35434*                                                                         
T35434 0150-EXIT.                                                       
T35434      EXIT.                                                       
T35434*                                                                         
T35434*================================================================*        
T35434  0160-REPOSITION-FILE.                                           
T35434*================================================================*        
T35434                                                                  
T35434     PERFORM 8100-READ-METER-FILE THRU 8100-EXIT                  
T35434        UNTIL  WS-NBR-METER-RECS   = WS-RESTART-FIOMT25-REC-CNTR. 
T35434     DISPLAY '*******************************************'.       
T35434     DISPLAY '*****  THIS IS A RESTART OF PCSMT601  *****'.       
T35434     DISPLAY '*******************************************'.       
T35434     IF  WS-FMT25-DEVICE-NO         = E-FMT25-DEVICE-NO           
T35434         DISPLAY '*** REPOSITION SUCCESSFULL ***'                 
T35434         MOVE WS-RESTART-GOOD-REC-CNTR TO WS-NBR-GOOD-RECS        
T35434         MOVE WS-RESTART-BAD-REC-CNTR  TO WS-NBR-BAD-RECS         
T35434         MOVE WS-RESTART-CHKP-SEQ-NO   TO WS-CHKP-SEQ-NO          
T35434     ELSE                                                         
T35434         DISPLAY '***    FAIL TO REPOSITIONING FILE     **'       
T35434         DISPLAY '**      ABEND IN PARAGRAPH 0160       **'       
T35434         PERFORM 9900-ABEND THRU 9900-EXIT                        
T35434     END-IF.                                                      
T35434                                                                  
T35434 0160-EXIT.                                                       
T35434     EXIT.                                                        
T35434*                                                                         
T35434*****************************************************************         
T35434* 0605-VALIDATE-RESTART-REQ                                               
T35434*****************************************************************         
T35434  COPY CPD00030.                                                          
T35434*****************************************************************         
T35434*                                                                         
      **===============================================================*        
      **  0400-GET-VER-CODE-VAL.                                                
      **===============================================================*        
       0400-GET-VER-CODE-VAL.                                           
      *                                                                         
           MOVE ZERO TO WS-VER-CODE-SUB                                 
           INITIALIZE WS-VER-CODE-VAL-TAB                               
           MOVE 'VERSION_CD'           TO WS-COLUMN-NA                  
           MOVE 'CSS_EQUIP_ATTCHMTS'   TO WS-TABLE-NA                   
           PERFORM 7500-OPEN-CODE-VALUE  THRU 7500-EXIT                 
           PERFORM 7510-FETCH-CODE-VALUE THRU 7510-EXIT                 
      *                                                                         
           PERFORM UNTIL SQLCODE EQUAL NOT-FOUND                        
              ADD +1  TO WS-VER-CODE-SUB                                
              IF WS-VER-CODE-SUB > 50                                   
                 DISPLAY '***ERROR: ARRAY OVERFLOW         ***'         
                 DISPLAY '***PARA:0400-GET-VER-CODE-VAL    ***'         
                 DISPLAY '*** MORE THAN 50 CODE VALUES     ***'         
                 DISPLAY '*** COLUMN_NA:' WS-COLUMN-NA    ' **'         
                 DISPLAY '*** TABLE-NA :' WS-TABLE-NA     ' **'         
                 DISPLAY '*** COMPANY-NO:' WS-SYSIN-COMP-NO ' **'       
                 PERFORM 9900-ABEND            THRU 9900-EXIT           
              END-IF                                                    
      *                                                                         
              MOVE WS-CODE-VALUE(1:1)  TO                               
                             WS-TAB-UTL-CODE-VAL (WS-VER-CODE-SUB)      
              MOVE WS-CODE-VALUE(2:2)  TO                               
                             WS-TAB-ATT-CODE-VAL (WS-VER-CODE-SUB)      
              MOVE WS-CODE-VALUE(4:3)  TO                               
                             WS-TAB-VER-CODE-VAL (WS-VER-CODE-SUB)      
              PERFORM 7510-FETCH-CODE-VALUE  THRU 7510-EXIT             
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7520-CLOSE-CODE-VALUE THRU 7520-EXIT.                
      *                                                                         
       0400-EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1000-PROCESS-FILE                                         **          
      **      RECEIVE, EDIT, AND PROCESS INPUT                      **          
      **                                                            **          
      ****************************************************************          
       1000-PROCESS-FILE.                                               
      *                                                                         
           PERFORM 2000-EDIT-RECORD    THRU 2000-EXIT.                  
      *                                                                         
           IF GOOD-RECORD                                               
               PERFORM 5000-UPDATE     THRU 5000-EXIT                   
               ADD 1                   TO WS-NBR-GOOD-RECS              
           ELSE                                                         
               MOVE WS-ERR-ARRAY-IDX   TO WS-ERROR-ARRAY-SIZE           
               PERFORM 6000-ERROR-ROUTINE        THRU 6000-EXIT         
                   VARYING WS-ERR-ARRAY-IDX FROM 1 BY 1                 
                       UNTIL WS-ERR-ARRAY-IDX > WS-ERROR-ARRAY-SIZE     
               ADD 1                   TO WS-NBR-BAD-RECS               
                                          WS-NO-ADDITION-MTRS           
           END-IF.                                                      
T35434*                                                                         
           IF GOOD-RECORD                                               
T35434         ADD 1 TO WS-RESTART-COMMIT-COUNTER                       
T35434*                                                                         
T35434         PERFORM 1800-PREPARE-PRECOMMIT  THRU 1800-EXIT           
T35434         IF WS-RESTART-COMMIT-COUNTER >= WS-CHKP-LUW-LIMIT        
T35434           AND WS-COMMITS-REQUIRE                                 
T35434             PERFORM 3000-COMMIT          THRU 3000-EXIT          
T35434             MOVE ZEROES TO WS-RESTART-COMMIT-COUNTER             
T35434         END-IF                                                   
T35434*                                                                         
T35434     END-IF.                                                      
T35434*                                                                         
           PERFORM 8000-INITIALIZE               THRU 8000-EXIT.        
           PERFORM 8100-READ-METER-FILE          THRU 8100-EXIT.        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T35434*===============================================================*         
T35434 1800-PREPARE-PRECOMMIT.                                          
T35434*===============================================================*         
T35434*                                                                         
T35434      MOVE 1                     TO WS-RESTART-PROCESS-TYPE.      
T35434      SET WS-RERUN-PENDING       TO TRUE.                         
T35434      MOVE WS-NBR-METER-RECS     TO WS-RESTART-FIOMT25-REC-CNTR.  
T35434      MOVE WS-NBR-GOOD-RECS      TO WS-RESTART-GOOD-REC-CNTR.     
T35434      MOVE WS-NBR-BAD-RECS       TO WS-RESTART-BAD-REC-CNTR.      
T35434      MOVE E-FMT25-DEVICE-NO     TO WS-FMT25-DEVICE-NO.           
T35434*                                                                         
T35434 1800-EXIT.                                                       
T35434      EXIT.                                                       
T35434*                                                                         
T35434*==============================================================*          
T35434 1900-PROCESS-SUCCESSFUL-JOB.                                     
T35434*==============================================================*          
T35434*--------------------------------------------------------------*          
T35434* THE FOLLOWING SETTINGS DECLARES SUCCESSFUL COMPLETION OF RUN *          
T35434* AND RESET RE-START CONTROLS IN CASE OF RE-START RUN          *          
T35434*--------------------------------------------------------------*          
T35434     MOVE SPACES                   TO WS-RESTART-JOB-COMPLETE     
T35434     IF  WS-THIS-IS-A-RESTART                                     
T35434         SET WS-RERUN-COMPLETED    TO TRUE                        
T35434     ELSE                                                         
T35434         SET WS-RUN-COMPLETED-NO-PROBLEMS                         
T35434                                   TO TRUE                        
T35434     END-IF.                                                      
T35434*                                                                         
T35434     PERFORM 3000-COMMIT               THRU 3000-EXIT.            
T35434*                                                                         
T35434     IF  WS-RESTART-REQ EQUAL WS-Y                                
T35434         PERFORM 8893-RESET-RESTART-REQ-PARM                      
T35434            THRU 8893-EXIT                                        
T35434     END-IF.                                                      
T35434*                                                                         
T35434 1900-EXIT.                                                       
T35434     EXIT.                                                        
T35434*                                                                         
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  2000-EDIT-RECORD                                          **          
      **      EDIT CHECK RECORD FIELDS. IF INVALID, WRITE TO ERROR  **          
      **                                                            **          
      ****************************************************************          
       2000-EDIT-RECORD.                                                
      *                                                                         
           MOVE E-FMT25-CODE-UTIL-TYPE   TO WS-CODE-UTIL-TYPE.          
      *                                                                         
           SET WS-ATT-TYPE-NOT-EXISTS  TO  TRUE                         
           IF E-FMT25-CODE-ATT-TYPE > SPACES                            
              MOVE E-FMT25-CODE-ATT-TYPE TO N5-CODE-ATT-TYPE            
              PERFORM 7000-SELECT-ATTACHMENT-TYPE THRU 7000-EXIT        
              IF SQLCODE EQUAL SUCCESSFUL-CALL                          
                 SET WS-ATT-TYPE-EXISTS  TO  TRUE                       
              ELSE                                                      
               PERFORM 2700-LOAD-ERROR-ARRAY     THRU 2700-EXIT         
               MOVE 'ATTACHMENT TYPE ' TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
               MOVE 'NOT VALID  '      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
               END-IF                                                   
           ELSE                                                         
               PERFORM 2700-LOAD-ERROR-ARRAY     THRU 2700-EXIT         
               MOVE 'ATTACHMENT TYPE ' TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
               MOVE 'NOT PRESENT'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
P00462*** Format Device No with leading zero                                    
P00462     MOVE SPACES                 TO WS-FRMT-ATT.                  
P00462     MOVE E-FMT25-DEVICE-NO      TO WS-FRMT-ATT.                  
P00462                                                                  
P00462     PERFORM 7950-FORMAT-DEVICE-NO                                
P00462        THRU 7950-EXIT.                                           
P00462                                                                  
P00462     MOVE WS-FRMT-ATT            TO E-FMT25-DEVICE-NO.            
P00462*                                                                         
           IF E-FMT25-DEVICE-NO IS NUMERIC                              
              IF WS-ATT-TYPE-EXISTS                                     
                 PERFORM 2100-VALIDATE-ATTACHMENT  THRU 2100-EXIT       
              END-IF                                                    
           ELSE                                                         
              PERFORM 2700-LOAD-ERROR-ARRAY     THRU 2700-EXIT          
              MOVE 'ATTACHMENT NBR  '  TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
              MOVE 'NOT NUMERIC'       TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
           IF E-FMT25-ATTACH-WARRANTY NOT NUMERIC                       
               PERFORM 2700-LOAD-ERROR-ARRAY     THRU 2700-EXIT         
               MOVE 'ATTACHMENT WAR  ' TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
               MOVE 'NOT NUMERIC'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
           IF E-FMT25-CODE-MAKE > SPACES                                
              MOVE E-FMT25-CODE-MAKE TO M2-CODE-MAKE                    
              PERFORM 7200-SELECT-ATTACHMENT-MAKE THRU 7200-EXIT        
              IF SQLCODE EQUAL NOT-FOUND                                
                 PERFORM 2700-LOAD-ERROR-ARRAY     THRU 2700-EXIT       
                 MOVE 'ATTACHMENT MFR CODE'                             
                                       TO ERR-FIELD  (WS-ERR-ARRAY-IDX) 
                 MOVE 'NOT VALID  '    TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
              END-IF                                                    
           ELSE                                                         
               PERFORM 2700-LOAD-ERROR-ARRAY     THRU 2700-EXIT         
               MOVE 'ATTACHMENT MFR CODE'                               
                                       TO ERR-FIELD  (WS-ERR-ARRAY-IDX) 
               MOVE 'NOT PRESENT'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
      ***  ATTACHMENT TEST SCHEDULE VALIDATION                                  
           IF E-FMT25-TEST-SCHED-CD > SPACES                            
              MOVE E-FMT25-TEST-SCHED-CD  TO M3-TEST-SCHED-CD           
              PERFORM 7100-SELECT-TEST-SCH  THRU 7100-EXIT              
              IF SQLCODE EQUAL NOT-FOUND                                
                 PERFORM 2700-LOAD-ERROR-ARRAY THRU 2700-EXIT           
                 MOVE 'ATT TEST SCHEDULE'                               
                                       TO ERR-FIELD (WS-ERR-ARRAY-IDX)  
                 MOVE 'NOT VALID'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
              END-IF                                                    
           ELSE                                                         
              PERFORM 2700-LOAD-ERROR-ARRAY     THRU 2700-EXIT          
              MOVE 'ATT TEST SCHEDULE' TO ERR-FIELD  (WS-ERR-ARRAY-IDX) 
              MOVE 'NOT PRESENT'      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX) 
           END-IF                                                       
      *                                                                         
      ***  ATTACHMENT VERSION CODE VALIDATION                                   
           IF E-FMT25-VERSION-CD > SPACES                               
              SET WS-CODE-VAL-NOT-MATCHED TO TRUE                       
              PERFORM VARYING WS-VER-INDX FROM 1 BY 1                   
                 UNTIL WS-VER-INDX > WS-VER-CODE-SUB                    
                  OR WS-CODE-VAL-MATCHED                                
                  OR WS-TAB-UTL-CODE-VAL (WS-VER-INDX) = SPACES         
                 IF WS-TAB-UTL-CODE-VAL (WS-VER-INDX)                   
P00462                                = E-FMT25-CODE-UTIL-TYPE          
                  AND WS-TAB-ATT-CODE-VAL (WS-VER-INDX)                 
                                      = E-FMT25-CODE-ATT-TYPE           
                  AND WS-TAB-VER-CODE-VAL (WS-VER-INDX)                 
                                      = E-FMT25-VERSION-CD              
                    SET WS-CODE-VAL-MATCHED TO TRUE                     
                 END-IF                                                 
              END-PERFORM                                               
              IF WS-CODE-VAL-NOT-MATCHED                                
                 PERFORM 2700-LOAD-ERROR-ARRAY     THRU 2700-EXIT       
                 MOVE 'ATTACHMENT VER CD'                               
                                       TO ERR-FIELD (WS-ERR-ARRAY-IDX)  
                 MOVE 'NOT VALID'    TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)  
              END-IF                                                    
           ELSE                                                         
              PERFORM 2700-LOAD-ERROR-ARRAY     THRU 2700-EXIT          
              MOVE 'ATTACHMENT VER CD' TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
              MOVE 'NOT PRESENT'       TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
           MOVE WS-SYSIN-COMP-NO           TO W9-COMPANY-NO.            
           MOVE E-FMT25-MTR-STORAGE-FAC-CD TO WS-LOCAL-OFFICE.          
           PERFORM 7300-SELECT-MTR-STORGE-FAC THRU 7300-EXIT.           
           IF SQLCODE EQUAL NOT-FOUND                                   
               PERFORM 2700-LOAD-ERROR-ARRAY     THRU 2700-EXIT         
               MOVE 'MTR FACILITY CD ' TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
               MOVE 'NOT VALID  '      TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
           PERFORM 2300-EDIT-DATES               THRU 2300-EXIT.        
                                                                        
PRJ914*** VALIDATE METER ATTACHMENTS FOR MARRY THE ATTACHMENT                   
PRJ914*                                                                         
PRJ914     INSPECT E-FMT25-METER-NO                                     
PRJ914     REPLACING ALL LOW-VALUES BY SPACES.                          
PRJ914                                                                  
PRJ914     IF E-FMT25-METER-NO > SPACES                                 
PRJ914        INITIALIZE DCLCSS-METER-ATTCHMTS                          
PRJ914        MOVE E-FMT25-COMPANY-NO       TO MA-COMPANY-NO            
PRJ914        MOVE E-FMT25-CODE-UTIL-TYPE   TO MA-CODE-UTIL-TYPE        
PRJ914        MOVE E-FMT25-DEVICE-NO        TO MA-DEVICE-NO             
PRJ914        MOVE E-FMT25-CODE-ATT-TYPE    TO MA-CODE-ATT-TYPE         
PRJ914        MOVE E-FMT25-METER-NO         TO MA-METER-NO              
PRJ914                                                                  
PRJ914        MOVE WS-N TO WS-ATTACHED-FLAG                             
PRJ914        PERFORM 7560-CHECK-IF-ATTCHD-TO-MTR THRU 7560-EXIT        
PRJ914                                                                  
PRJ914        IF ATTACHED-TO-MTR                                        
PRJ914           MOVE MA-METER-NO       TO ERR-FIELD (WS-ERR-ARRAY-IDX) 
PRJ914           MOVE 'DEVICE ATTACHED TO METER'                        
PRJ914                                  TO ERR-PROBLEM(WS-ERR-ARRAY-IDX)
PRJ914           PERFORM 2700-LOAD-ERROR-ARRAY    THRU 2700-EXIT        
PRJ914        END-IF                                                    
PRJ914                                                                  
PRJ914        MOVE 0 TO WS-ATTCH-COUNT                                  
PRJ914        PERFORM 7570-GET-COUNT-ATT-TYP-TO-MTR THRU 7570-EXIT      
PRJ914                                                                  
PRJ914        IF WS-ATTCH-COUNT > 0                                     
PRJ914           MOVE MA-METER-NO        TO ERR-FIELD (WS-ERR-ARRAY-IDX)
PRJ914           MOVE 'METER EXCEEDS ATTACHMENT LIMIT'                  
PRJ914                                  TO ERR-PROBLEM(WS-ERR-ARRAY-IDX)
PRJ914           PERFORM 2700-LOAD-ERROR-ARRAY    THRU 2700-EXIT        
PRJ914        END-IF                                                    
PRJ914     END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      ** 2100-VALIDATE-ATTACHMENT.                                              
      *================================================================*        
      * ATTACHMENT NBR IS VALIDATED AGAINST EQUIP_ATTCHMTS             *        
      * TABLE BASED ON UNIQUE-ATT-ID-CD OF ATTACHMENT TYPE.            *        
      * BELOW ARE THE RULES OF UNIQUE-ATT-ID-CD                        *        
      *                                                                *        
      ***   U     - UNIQUE WITHIN A UTIL-TYPE ACROSS COMPANIES         *        
      ***   S     - UNIQUE WITHIN THE SYSTEM                           *        
      ***   C     - UNIQUE WITHIN COMPANY ACROSS UTIL-TYPES            *        
      ***   A     - UNIQUE WITHIN A UTIL-TYPE WITHIN A COMPANY         *        
      ***   OTHER - SAME AS 'A'                                        *        
      *----------------------------------------------------------------*        
       2100-VALIDATE-ATTACHMENT.                                        
      *                                                                         
           SET WS-VALID-ATTACHMENT  TO TRUE                             
      *                                                                         
      *** USE EQUIP_ATTCHMTS TABLE TO VALIDATE ATTACHMENT NBR                   
           MOVE E-FMT25-DEVICE-NO         TO LX-DEVICE-NO               
           MOVE E-FMT25-CODE-ATT-TYPE       TO LX-CODE-ATT-TYPE         
           PERFORM 7400-OPEN-EQUIP-ATTCHMTS  THRU 7400-EXIT             
           PERFORM 7410-FETCH-EQUIP-ATTCHMTS THRU 7410-EXIT             
      *                                                                         
           PERFORM UNTIL SQLCODE EQUAL NOT-FOUND                        
                           OR WS-NOT-VALID-ATTACHMENT                   
              PERFORM 2200-APPLY-UNIQUE-RULES  THRU 2200-EXIT           
      *                                                                         
              IF WS-VALID-ATTACHMENT                                    
                 PERFORM 7410-FETCH-EQUIP-ATTCHMTS THRU 7410-EXIT       
              END-IF                                                    
      *                                                                         
           END-PERFORM                                                  
      *                                                                         
           PERFORM 7420-CLOSE-EQUIP-ATTCHMTS THRU 7420-EXIT             
      *                                                                         
           IF WS-NOT-VALID-ATTACHMENT                                   
              PERFORM 2700-LOAD-ERROR-ARRAY     THRU 2700-EXIT          
              MOVE 'ATTACHMENT NBR  '  TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
              MOVE 'ALREADY IN INVENTORY'                               
                                       TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2200-APPLY-UNIQUE-RULES.                                         
      *================================================================*        
      *                                                                         
           EVALUATE N5-UNIQUE-ATT-ID-CD                                 
              WHEN 'A'                                                  
                 IF WS-DB-COMPANY-NO = WS-SYSIN-COMP-NO                 
P00462              AND WS-DB-CODE-UTIL-TYPE = E-FMT25-CODE-UTIL-TYPE   
                    SET WS-NOT-VALID-ATTACHMENT TO TRUE                 
                 END-IF                                                 
              WHEN 'C'                                                  
                 IF WS-DB-COMPANY-NO = WS-SYSIN-COMP-NO                 
                    SET WS-NOT-VALID-ATTACHMENT TO TRUE                 
                 END-IF                                                 
              WHEN 'S'                                                  
                 SET WS-NOT-VALID-ATTACHMENT TO TRUE                    
              WHEN 'U'                                                  
P00462           IF WS-DB-CODE-UTIL-TYPE = E-FMT25-CODE-UTIL-TYPE       
                    SET WS-NOT-VALID-ATTACHMENT TO TRUE                 
                 END-IF                                                 
              WHEN OTHER                                                
                 IF WS-DB-COMPANY-NO = WS-SYSIN-COMP-NO                 
P00462              AND WS-DB-CODE-UTIL-TYPE = E-FMT25-CODE-UTIL-TYPE   
                    SET WS-NOT-VALID-ATTACHMENT TO TRUE                 
                 END-IF                                                 
           END-EVALUATE.                                                
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  2300-EDIT-DATES                                           **          
      **                                                            **          
      ****************************************************************          
       2300-EDIT-DATES.                                                 
      *                                                                         
           MOVE E-FMT25-DATE-PURCHASED (1:2) TO WS-IN-CC.               
           MOVE E-FMT25-DATE-PURCHASED (3:2) TO WS-IN-YY.               
           MOVE E-FMT25-DATE-PURCHASED (6:2) TO WS-IN-MM.               
           MOVE E-FMT25-DATE-PURCHASED (9:2) TO WS-IN-DD.               
           PERFORM 2400-DATE-VALIDATION   THRU 2400-EXIT.               
      *                                                                         
           IF (INVALID-MONTH OR INVALID-DAY                             
               OR INVALID-YEAR OR INVALID-CENTURY)                      
               PERFORM 2700-LOAD-ERROR-ARRAY     THRU 2700-EXIT         
               MOVE 'PURCHASE DATE '   TO ERR-FIELD   (WS-ERR-ARRAY-IDX)
               MOVE 'INVALID DATE'     TO ERR-PROBLEM (WS-ERR-ARRAY-IDX)
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  2400-DATE-VALIDATION                                      **          
      **                                                            **          
      ****************************************************************          
       2400-DATE-VALIDATION.                                            
      *                                                                         
           MOVE ZEROES                 TO WS-RETURN-DATE,               
                                          WS-WORK-FIELDS,               
                                          WS-DATE-FLAGS.                
           PERFORM 2500-NUMERIC-CHECK     THRU 2500-EXIT.               
      *                                                                         
           IF WS-DATE-FLAGS EQUAL ZEROS                                 
               MOVE WS-IN-DD           TO WS-RETURN-DD                  
               MOVE WS-IN-YY           TO WS-RETURN-YY                  
               MOVE WS-IN-MM           TO WS-RETURN-MM                  
               MOVE WS-IN-CC           TO WS-RETURN-CC                  
               PERFORM 2600-BOUNDARY-CHECK       THRU 2600-EXIT         
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  2500-NUMERIC-CHECK                                        **          
      **      VALIDATE DATE INFORMATION                             **          
      **                                                            **          
      ****************************************************************          
       2500-NUMERIC-CHECK.                                              
      *                                                                         
           IF WS-IN-MM NUMERIC                                          
               CONTINUE                                                 
           ELSE                                                         
               MOVE 1                  TO MONTH-FLAG                    
           END-IF.                                                      
      *                                                                         
           IF WS-IN-DD NUMERIC                                          
               CONTINUE                                                 
           ELSE                                                         
               MOVE 1                  TO DAY-FLAG                      
           END-IF.                                                      
      *                                                                         
           IF WS-IN-YY NUMERIC                                          
               CONTINUE                                                 
           ELSE                                                         
               MOVE 1                  TO YEAR-FLAG                     
           END-IF.                                                      
      *                                                                         
           IF WS-IN-CC NUMERIC                                          
               CONTINUE                                                 
           ELSE                                                         
               MOVE 1                  TO CENTURY-FLAG                  
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  2600-BOUNDARY-CHECK                                       **          
      **                                                            **          
      ****************************************************************          
       2600-BOUNDARY-CHECK.                                             
      *                                                                         
           IF WS-RETURN-MM > 12 OR                                      
              WS-RETURN-MM < 01                                         
               MOVE 1                  TO MONTH-FLAG                    
           END-IF.                                                      
      *                                                                         
           IF WS-RETURN-CC > 20 OR                                      
              WS-RETURN-CC < 19                                         
               MOVE 1                  TO CENTURY-FLAG                  
           END-IF.                                                      
      *                                                                         
           IF THIRTY-ONE-DAY                                            
               MOVE 31                 TO WS-UPPER-LIMIT                
           ELSE                                                         
               IF THIRTY-DAY                                            
                   MOVE 30             TO WS-UPPER-LIMIT                
               ELSE                                                     
                   DIVIDE WS-RETURN-YY BY 4 GIVING WS-RESULT            
                          REMAINDER WS-REMAINDER-DATE                   
                   IF WS-REMAINDER-DATE EQUAL ZEROES                    
                       MOVE 29         TO WS-UPPER-LIMIT                
                   ELSE                                                 
                       MOVE 28         TO WS-UPPER-LIMIT                
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           IF WS-RETURN-DD > WS-UPPER-LIMIT OR                          
              WS-RETURN-DD < 1                                          
               MOVE 1                  TO DAY-FLAG                      
           END-IF.                                                      
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  2700-LOAD-ERROR-ARRAY                                     **          
      **                                                            **          
      ****************************************************************          
       2700-LOAD-ERROR-ARRAY.                                           
      *                                                                         
           MOVE WS-Y                   TO WS-RECORD-FLAG.               
           ADD 1                       TO WS-ERR-ARRAY-IDX.             
           MOVE E-FMT25-DEVICE-NO      TO ERR-METER-NBR                 
                                          (WS-ERR-ARRAY-IDX).           
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T35434*================================================================*        
T35434 3000-COMMIT.                                                     
T35434*================================================================*        
T35434*                                                                         
T35434     PERFORM 8800-WRITE-RESTART         THRU 8800-EXIT            
T35434*                                                                         
T35434     EXEC SQL                                                     
T35434          COMMIT                                                  
T35434     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35434*                                                                         
T35434     DISPLAY 'COMMIT-POINT #'  WS-CHKP-SEQ-NO 'TAKEN.'.           
T35434     DISPLAY 'COMMITTED UPTO =  METER NO: ' E-FMT25-DEVICE-NO.    
T35434*                                                                         
T35434 3000-EXIT.                                                       
T35434      EXIT.                                                       
T35434*                                                                         
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  5000-UPDATE                                               **          
      **      SETUP AND INSERT CSS_EQUIP_ATTCHMTS                   **          
      ****************************************************************          
       5000-UPDATE.                                                     
      *                                                                         
      *                                                                         
           MOVE WS-SYSIN-COMP-NO           TO LX-COMPANY-NO.            
           MOVE E-FMT25-CODE-UTIL-TYPE     TO LX-CODE-UTIL-TYPE.        
           MOVE E-FMT25-DEVICE-NO          TO LX-DEVICE-NO.             
           MOVE E-FMT25-CODE-ATT-TYPE      TO LX-CODE-ATT-TYPE.         
           MOVE E-FMT25-CODE-MAKE          TO LX-CODE-MAKE.             
           MOVE E-FMT25-VERSION-CD         TO LX-VERSION-CD.            
           MOVE E-FMT25-TEST-SCHED-CD      TO LX-TEST-SCHED-CD.         
           MOVE E-FMT25-MTR-STORAGE-FAC-CD TO LX-MTR-STORAGE-FAC-CD.    
           MOVE 'A'                        TO LX-EQUIP-LOC-ID.          
PRJ914     MOVE E-FMT25-ATT-SERIAL-NBR     TO LX-SERIAL-NO.             
           MOVE E-FMT25-DATE-PURCHASED     TO LX-DATE-PURCHASED.        
           SET DATE-PURCHASED-NOT-NULL     TO TRUE.                     
           MOVE E-FMT25-DATE-PURCHASED     TO LX-DATE-LAST-MOVE.        
           SET DATE-LAST-MOVE-NOT-NULL     TO TRUE.                     
           MOVE WS-DB2-TODAYS-DATE         TO LX-DATE-LAST-TRAN         
           SET DATE-LAST-TRAN-NOT-NULL     TO TRUE.                     
           MOVE SPACES                     TO LX-DATE-LAST-TESTED       
                                              LX-DATE-OBSOLETE          
                                              LX-EQUIP-ATTACH-DT        
                                              LX-DATE-DISPOSED-OF.      
           SET DATE-LAST-TESTED-NULL       TO TRUE.                     
           SET DATE-OBSOLETE-NULL          TO TRUE.                     
           SET ATTACH-DT-NULL              TO TRUE.                     
           SET DATE-DISPOSED-NULL          TO TRUE.                     
           MOVE E-FMT25-ATTACH-WARRANTY    TO WS-WARRANTY-MTHS.         
           MOVE E-FMT25-DATE-PURCHASED     TO WS-WARRANTY-DATE.         
           PERFORM 5200-SELECT-WARRANTY-DATE THRU 5200-EXIT.            
           MOVE WS-WARRANTY-DATE           TO LX-WARRANTY-EXP-DT.       
           SET WARRANTY-DATE-NOT-NULL      TO TRUE.                     
           PERFORM 7700-INSERT-EQUIP-ATTCHMTS  THRU 7700-EXIT.          
                                                                        
PRJ914     IF E-FMT25-METER-NO > SPACES                                 
PRJ914        MOVE N5-CODE-DEVICE-TYPE     TO MA-CODE-DEVICE-TYPE       
PRJ914        MOVE ZERO                    TO MA-CT-PT-RATIO            
PRJ914        MOVE E-FMT25-CODE-MAKE       TO MA-CODE-MAKE              
PRJ914        MOVE SPACES                  TO MA-DATE-LAST-TESTED       
PRJ914        SET DATE-LAST-TESTED-NULL    TO TRUE                      
PRJ914        MOVE E-FMT25-TEST-SCHED-CD   TO MA-TEST-SCHED-CD          
PRJ914        MOVE E-FMT25-MOD-CONNT-TYPE  TO MA-HOW-ATTACHED-CD        
PRJ914        PERFORM 8900-INSERT-METER-ATTCH THRU 8900-EXIT            
PRJ914     END-IF.                                                      
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ***************************************************************** 10290000
      * ADD PURCHASE DATE AND WARRANTY PERIOD TO OBTAIN THE           * 10300000
      * WARRANTY DATE                                                 * 10310000
      ***************************************************************** 10320000
       5200-SELECT-WARRANTY-DATE.                                       
      *                                                                 10340000
           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, :WS-WARRANTY-MTHS, IIF(TRY_CONVERT(DATE, 
                                                      :WS-WARRANTY-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WARRANTY-DATE
              ) <> 0) OR (LEN(:WS-WARRANTY-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-WARRANTY-DATE
              ), CONVERT(DATE, :WS-WARRANTY-DATE) ) )
            INTO
              :WS-WARRANTY-DATE       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-WARRANTY-DATE =                                          
MFA-TR*        DATE(:WS-WARRANTY-DATE) + :WS-WARRANTY-MTHS MONTHS               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10400000
           IF  SQLCODE EQUAL SUCCESSFUL-CALL                            
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE                    TO WS-DISPLAY-RC         
               DISPLAY '********** PCSMT601 ABORT ************'         
               DISPLAY '* 5200-SELECT-WARRANTY-DATE          *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSMT601 ABORT ************'         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 10540000
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  6000-ERROR-ROUTINE                                        **          
      **                                                            **          
      ****************************************************************          
       6000-ERROR-ROUTINE.                                              
      *                                                                         
           MOVE ERR-METER-NBR (WS-ERR-ARRAY-IDX)                        
                                       TO WS-RPT-ATTACH-NO.             
           MOVE ERR-FIELD     (WS-ERR-ARRAY-IDX)                        
                                       TO WS-RPT-ERROR-FIELD.           
           MOVE ERR-PROBLEM   (WS-ERR-ARRAY-IDX)                        
                                       TO WS-RPT-PROBLEM-DESC.          
      *                                                                         
           PERFORM 8200-WRITE-PRINTER-RECORD     THRU 8200-EXIT.        
      *                                                                         
       6000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T35434*===============================================================*         
T35434* *6235-GET-FJC01-RESTART-REQ.                                            
T35434*===============================================================*         
T35434     EXEC SQL                                                             
T35434         INCLUDE CPD00035                                                 
T35434     END-EXEC.                                                            
T35434*===============================================================*         
T35434*  6253-GET-FJC01-CHKP-LIMIT                                              
T35434*===============================================================*         
T35434       EXEC SQL                                                           
T35434          INCLUDE CPD00034                                                
T35434       END-EXEC.                                                          
T35434*===============================================================*         
T35434*  7600-START-FCSJC01                                                     
T35434*===============================================================*         
T35434     EXEC SQL                                                             
T35434         INCLUDE CPD00038                                                 
T35434     END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7000-SELECT-ATTACHMENT-TYPE                               **          
      **                                                            **          
      ****************************************************************          
       7000-SELECT-ATTACHMENT-TYPE.                                     
      *                                                                         
           EXEC SQL                                                     
               SELECT MTR_ATT_TYPE_DESC                                 
                     ,UNIQUE_ATT_ID_CD                                  
PRJ914               ,CODE_DEVICE_TYPE                                  
                 INTO :N5-MTR-ATT-TYPE-DESC                             
                     ,:N5-UNIQUE-ATT-ID-CD                              
PRJ914               ,:N5-CODE-DEVICE-TYPE                              
                 FROM  CSS_MTR_ATT_TYPE WITH(READUNCOMMITTED)                   
                WHERE  CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE          
                  AND  CODE_ATT_TYPE      = :N5-CODE-ATT-TYPE           
A02034                                                           
A02034                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MTR_ATT_TYPE_DESC                                         
MFA-TR*              ,UNIQUE_ATT_ID_CD                                          
MFA-TR*              ,CODE_DEVICE_TYPE                                          
MFA-TR*          INTO :N5-MTR-ATT-TYPE-DESC                                     
MFA-TR*              ,:N5-UNIQUE-ATT-ID-CD                                      
MFA-TR*              ,:N5-CODE-DEVICE-TYPE                                      
MFA-TR*          FROM  CSS_MTR_ATT_TYPE                                         
MFA-TR*         WHERE  CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE                  
MFA-TR*           AND  CODE_ATT_TYPE      = :N5-CODE-ATT-TYPE                   
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7000                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT601****************'        
               DISPLAY '* ERROR ON 7000-SELECT-ATTACHMENT-TYPE*'        
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* ATTACH NBR ' E-FMT25-DEVICE-NO                
               DISPLAY '***************PCSMT601****************'        
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      ** 7010-SELECT-TEST-SCH.                                                  
      *================================================================*        
       7100-SELECT-TEST-SCH.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT  TEST_SCHED_DESC                                  
                 INTO :M3-TEST-SCHED-DESC                               
                 FROM  CSS_TEST_SCHEDULE WITH(READUNCOMMITTED)                  
                WHERE  TEST_SCHED_CD = :M3-TEST-SCHED-CD                
A02034                                                           
A02034                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  TEST_SCHED_DESC                                          
MFA-TR*          INTO :M3-TEST-SCHED-DESC                                       
MFA-TR*          FROM  CSS_TEST_SCHEDULE                                        
MFA-TR*         WHERE  TEST_SCHED_CD = :M3-TEST-SCHED-CD                        
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE            TO   WS-DISPLAY-RC                   
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT601****************'        
               DISPLAY '* ERROR ON 7100-SELECT-TEST-SCH       *'        
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* TEST_SCHED_CD = ' M3-TEST-SCHED-CD            
               DISPLAY '***************PCSMT601****************'        
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7200-SELECT-ATTACHMENT-MAKE                               **          
      **                                                            **          
      ****************************************************************          
       7200-SELECT-ATTACHMENT-MAKE.                                     
      *                                                                         
           EXEC SQL                                                     
               SELECT  EQUIP_MAKE_DESC                                  
                 INTO :M2-EQUIP-MAKE-DESC                               
                 FROM  CSS_EQUIP_MAKE WITH(READUNCOMMITTED)                     
                WHERE  CODE_MAKE = :M2-CODE-MAKE                        
A02034                                                           
A02034                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  EQUIP_MAKE_DESC                                          
MFA-TR*          INTO :M2-EQUIP-MAKE-DESC                                       
MFA-TR*          FROM  CSS_EQUIP_MAKE                                           
MFA-TR*         WHERE  CODE_MAKE = :M2-CODE-MAKE                                
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT601****************'        
               DISPLAY '* ERROR ON 7200-SELECT-ATTACHMENT-MAKE*'        
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* ATTACH NBR ' E-FMT25-DEVICE-NO                
               DISPLAY '***************PCSMT601****************'        
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7300-SELECT-MTR-STORGE-FAC                                **          
      **                                                            **          
      ****************************************************************          
       7300-SELECT-MTR-STORGE-FAC.                                      
      *                                                                         
           EXEC SQL                                                     
               SELECT  MTR_STORAGE_FAC_TX                               
                 INTO :W9-MTR-STORAGE-FAC-TX                            
                 FROM  CSS_MTR_STORGE_FAC WITH(READUNCOMMITTED)                 
                WHERE  CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE          
                  AND  MTR_STORAGE_FAC_CD = :WS-LOCAL-OFFICE            
                  AND  COMPANY_NO         = :W9-COMPANY-NO              
A02034                                                           
A02034                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  MTR_STORAGE_FAC_TX                                       
MFA-TR*          INTO :W9-MTR-STORAGE-FAC-TX                                    
MFA-TR*          FROM  CSS_MTR_STORGE_FAC                                       
MFA-TR*         WHERE  CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE                  
MFA-TR*           AND  MTR_STORAGE_FAC_CD = :WS-LOCAL-OFFICE                    
MFA-TR*           AND  COMPANY_NO         = :W9-COMPANY-NO                      
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7300                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT601****************'        
               DISPLAY '* ERROR ON 7300-SELECT-MTR-STORGE-FAC *'        
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* ATT NBR ' E-FMT25-DEVICE-NO                   
               DISPLAY '* DATE ' E-FMT25-DATE-PURCHASED                 
               DISPLAY '***************PCSMT601****************'        
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
      ** 7400-OPEN-EQUIP-ATTCHMTS.                                              
      *===============================================================*         
       7400-OPEN-EQUIP-ATTCHMTS.                                        
      *                                                                         
           EXEC SQL                                                     
               OPEN EQUIP-ATTCHMTS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      **                                                                        
           MOVE SQLCODE TO WS-DISPLAY-RC.                               
      **                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE        TO WS-DISPLAY-RC                      
              DISPLAY '***************PCSMT601***************'          
              DISPLAY '* ERROR ON 7400-OPEN-EQUIP-ATTCHMTS  *'          
              DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
              DISPLAY '* DEVICE_NO          = ' LX-DEVICE-NO            
              DISPLAY '* CODE_ATT_TYPE      = ' LX-CODE-ATT-TYPE        
              DISPLAY '* PROGRAM ABENDING...                *'          
              DISPLAY '***************PCSMT601***************'          
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
      ** 7410-FETCH-EQUIP-ATTCHMTS.                                             
      *===============================================================*         
       7410-FETCH-EQUIP-ATTCHMTS.                                       
      *                                                                         
           EXEC SQL                                                     
               FETCH EQUIP-ATTCHMTS                                     
                INTO :WS-DB-CODE-UTIL-TYPE                              
                    ,:WS-DB-COMPANY-NO                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      **                                                                        
           MOVE SQLCODE TO WS-DISPLAY-RC.                               
      **                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE        TO WS-DISPLAY-RC                      
              DISPLAY '***************PCSMT601***************'          
              DISPLAY '* ERROR ON 7410-FETCH-EQUIP-ATTCHMTS *'          
              DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
              DISPLAY '* DEVICE_NO          = ' LX-DEVICE-NO            
              DISPLAY '* CODE_ATT_TYPE      = ' LX-CODE-ATT-TYPE        
              DISPLAY '* PROGRAM ABENDING...                *'          
              DISPLAY '***************PCSMT601***************'          
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
      ** 7420-CLOSE-EQUIP-ATTCHMTS.                                             
      *===============================================================*         
       7420-CLOSE-EQUIP-ATTCHMTS.                                       
      *                                                                         
           EXEC SQL                                                     
               CLOSE EQUIP-ATTCHMTS                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      **                                                                        
           MOVE SQLCODE TO WS-DISPLAY-RC.                               
      **                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE        TO WS-DISPLAY-RC                      
              DISPLAY '***************PCSMT601***************'          
              DISPLAY '* ERROR ON 7420-CLOSE-EQUIP-ATTCHMTS *'          
              DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                   
              DISPLAY '* PROGRAM ABENDING...                *'          
              DISPLAY '***************PCSMT601***************'          
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
     ** 7500-OPEN-CODE-VALUE.                                                   
      *================================================================*        
       7500-OPEN-CODE-VALUE.                                            
      *                                                                         
           EXEC SQL                                                     
              OPEN CODE_VAL_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE            TO   WS-DISPLAY-RC                   
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT601****************'        
               DISPLAY '* ERROR ON 7500-OPEN-CODE-VALUE       *'        
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* COMPANY_NO = :' WS-SYSIN-COMP-NO              
               DISPLAY '* TABLE_NA   = :' WS-TABLE-NA                   
               DISPLAY '* COLUMN_NA  = :' WS-COLUMN-NA                  
               DISPLAY '***************PCSMT601****************'        
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      ** 7510-FETCH-CODE-VALUE.                                                 
      *================================================================*        
       7510-FETCH-CODE-VALUE.                                           
      *                                                                         
           EXEC SQL                                                     
              FETCH CODE_VAL_CSR                                        
               INTO :WS-CODE-VALUE                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE         TO WS-DISPLAY-RC                        
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT601****************'        
               DISPLAY '* ERROR ON 7510-FETCH-CODE-VALUE      *'        
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* COMPANY_NO = :' WS-SYSIN-COMP-NO              
               DISPLAY '* TABLE_NA   = :' WS-TABLE-NA                   
               DISPLAY '* COLUMN_NA  = :' WS-COLUMN-NA                  
               DISPLAY '***************PCSMT601****************'        
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      ** 7520-CLOSE-CODE-VALUE.                                                 
      *================================================================*        
       7520-CLOSE-CODE-VALUE.                                           
      *                                                                         
           EXEC SQL                                                     
              CLOSE CODE_VAL_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE        TO WS-DISPLAY-RC                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT601****************'        
               DISPLAY '* ERROR ON 7520-CLOSE-CODE-VALUE      *'        
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* COMPANY_NO = :' WS-SYSIN-COMP-NO              
               DISPLAY '* TABLE_NA   = :' WS-TABLE-NA                   
               DISPLAY '* COLUMN_NA  = :' WS-COLUMN-NA                  
               DISPLAY '***************PCSMT601****************'        
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
PRJ914*================================================================*        
PRJ914** 7560-CHECK-IF-ATTCHD-TO-MTR.                                           
PRJ914*================================================================*        
PRJ914 7560-CHECK-IF-ATTCHD-TO-MTR.                                     
PRJ914*                                                                         
PRJ914     EXEC SQL                                                     
PRJ914        SELECT 'Y'                                                
PRJ914          INTO :WS-ATTACHED-FLAG                                  
PRJ914          FROM CSS_METER_ATTCHMTS                                 
PRJ914         WHERE CODE_UTIL_TYPE  = :MA-CODE-UTIL-TYPE               
PRJ914           AND DEVICE_NO       = :MA-DEVICE-NO                    
PRJ914           AND CODE_ATT_TYPE   = :MA-CODE-ATT-TYPE                
PRJ914           AND COMPANY_NO      = :MA-COMPANY-NO                   
PRJ914                                                      
PRJ914     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-ATTACHED-FLAG                                          
MFA-TR*         FROM CSS_METER_ATTCHMTS                                         
MFA-TR*        WHERE CODE_UTIL_TYPE  = :MA-CODE-UTIL-TYPE                       
MFA-TR*          AND DEVICE_NO       = :MA-DEVICE-NO                            
MFA-TR*          AND CODE_ATT_TYPE   = :MA-CODE-ATT-TYPE                        
MFA-TR*          AND COMPANY_NO      = :MA-COMPANY-NO                           
MFA-TR*          QUERYNO 7560                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ914*                                                                         
PRJ914     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PRJ914     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
PRJ914         CONTINUE                                                 
PRJ914     ELSE                                                         
PRJ914         DISPLAY '***************PCSMT601****************'        
PRJ914         DISPLAY '* ERROR ON 7560-CHECK-IF-ATTCHD-TO-MTR*'        
PRJ914         DISPLAY '* SQL CODE IS    ' WS-ACTIVE-RETURN-CODE        
PRJ914         DISPLAY '* TABLE_NA       : CSS_METER_ATTCHMTS'          
PRJ914         DISPLAY '* COMPANY_NO     ' MA-COMPANY-NO                
PRJ914         DISPLAY '* CODE_ATT_TYPE  ' MA-CODE-ATT-TYPE             
PRJ914         DISPLAY '* DEVICE_NO      ' MA-DEVICE-NO                 
PRJ914         DISPLAY '* CODE_UTIL_TYPE ' MA-CODE-UTIL-TYPE            
PRJ914         DISPLAY '***************PCSMT601****************'        
PRJ914         PERFORM 9900-ABEND            THRU 9900-EXIT             
PRJ914     END-IF.                                                      
PRJ914*                                                                         
PRJ914 7560-EXIT.                                                       
PRJ914     EXIT.                                                        
PRJ914*                                                                         
PRJ914*                                                                         
PRJ914*================================================================*        
PRJ914** 7570-GET-COUNT-ATT-TYP-TO-MTR                                          
PRJ914*================================================================*        
PRJ914 7570-GET-COUNT-ATT-TYP-TO-MTR.                                   
PRJ914*                                                                         
PRJ914     EXEC SQL                                                     
PRJ914        SELECT COALESCE(COUNT(*),0)                                 
PRJ914          INTO :WS-ATTCH-COUNT                                    
PRJ914          FROM CSS_METER_ATTCHMTS                                 
PRJ914         WHERE CODE_UTIL_TYPE  = :MA-CODE-UTIL-TYPE               
PRJ914           AND METER_NO        = :MA-METER-NO                     
PRJ914           AND CODE_ATT_TYPE   = :MA-CODE-ATT-TYPE                
PRJ914           AND COMPANY_NO      = :MA-COMPANY-NO                   
PRJ914                                                      
PRJ914     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IFNULL(COUNT(*),0)                                         
MFA-TR*         INTO :WS-ATTCH-COUNT                                            
MFA-TR*         FROM CSS_METER_ATTCHMTS                                         
MFA-TR*        WHERE CODE_UTIL_TYPE  = :MA-CODE-UTIL-TYPE                       
MFA-TR*          AND METER_NO        = :MA-METER-NO                             
MFA-TR*          AND CODE_ATT_TYPE   = :MA-CODE-ATT-TYPE                        
MFA-TR*          AND COMPANY_NO      = :MA-COMPANY-NO                           
MFA-TR*          QUERYNO 7570                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ914*                                                                         
PRJ914     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PRJ914     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
PRJ914         CONTINUE                                                 
PRJ914     ELSE                                                         
PRJ914         DISPLAY '***************PCSMT601****************'        
PRJ914         DISPLAY '* ERROR ON 7570-CHECK-METER-ATTCHMNTS *'        
PRJ914         DISPLAY '* SQL CODE IS    ' WS-ACTIVE-RETURN-CODE        
PRJ914         DISPLAY '* TABLE_NA       : CSS_METER_ATTCHMTS'          
PRJ914         DISPLAY '* COMPANY_NO     ' MA-COMPANY-NO                
PRJ914         DISPLAY '* CODE_ATT_TYPE  ' MA-CODE-ATT-TYPE             
PRJ914         DISPLAY '* METER_NO       ' MA-METER-NO                  
PRJ914         DISPLAY '* CODE_UTIL_TYPE ' MA-CODE-UTIL-TYPE            
PRJ914         DISPLAY '***************PCSMT601****************'        
PRJ914         PERFORM 9900-ABEND            THRU 9900-EXIT             
PRJ914     END-IF.                                                      
PRJ914*                                                                         
PRJ914 7570-EXIT.                                                       
PRJ914     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INSERT A RECORD INTO CSS_EQUIP_ATTCHMTS                      **        
      ******************************************************************        
       7700-INSERT-EQUIP-ATTCHMTS.                                      
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_EQUIP_ATTCHMTS                           
                   (  DEVICE_NO                                         
                     ,CODE_ATT_TYPE                                     
                     ,COMPANY_NO                                        
                     ,CODE_UTIL_TYPE                                    
                     ,EQUIP_LOC_ID                                      
                     ,MTR_STORAGE_FAC_CD                                
                     ,CODE_MAKE                                         
                     ,TEST_SCHED_CD                                     
                     ,VERSION_CD                                        
                     ,EQUIP_ATTACH_DT                                   
                     ,DATE_LAST_MOVE                                    
                     ,DATE_LAST_TESTED                                  
                     ,DATE_LAST_TRAN                                    
                     ,DATE_PURCHASED                                    
                     ,WARRANTY_EXP_DT                                   
                     ,DATE_OBSOLETE                                     
P00462               ,SERIAL_NO                                         
                     ,DATE_DISPOSED_OF)                                 
               VALUES                                                   
                   (  :LX-DEVICE-NO                                     
                     ,:LX-CODE-ATT-TYPE                                 
                     ,:LX-COMPANY-NO                                    
                     ,:LX-CODE-UTIL-TYPE                                
                     ,:LX-EQUIP-LOC-ID                                  
                     ,:LX-MTR-STORAGE-FAC-CD                            
                     ,:LX-CODE-MAKE                                     
                     ,:LX-TEST-SCHED-CD                                 
                     ,:LX-VERSION-CD                                    
                     ,IIF(TRY_CONVERT(DATE, :LX-EQUIP-ATTACH-DT 
                                            :WS-NULLIND-ATTACH-DT
              ) IS NULL OR (PATINDEX('%.%', :LX-EQUIP-ATTACH-DT 
                                                  :WS-NULLIND-ATTACH-DT
              ) <> 0) OR (LEN(:LX-EQUIP-ATTACH-DT :WS-NULLIND-ATTACH-DT
              ) <> 10), CIS.CHAR2DATE(:LX-EQUIP-ATTACH-DT 
                                                  :WS-NULLIND-ATTACH-DT
              ), CONVERT(DATE, :LX-EQUIP-ATTACH-DT 
                                                  :WS-NULLIND-ATTACH-DT
              ) )          
                     ,IIF(TRY_CONVERT(DATE, :LX-DATE-LAST-MOVE 
                                            :WS-NULLIND-DATE-LAST-MOVE
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-MOVE 
                                             :WS-NULLIND-DATE-LAST-MOVE
              ) <> 0) OR (LEN(:LX-DATE-LAST-MOVE 
                                             :WS-NULLIND-DATE-LAST-MOVE
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-MOVE 
                                             :WS-NULLIND-DATE-LAST-MOVE
              ), CONVERT(DATE, :LX-DATE-LAST-MOVE 
                                             :WS-NULLIND-DATE-LAST-MOVE
              ) )      
                     ,IIF(TRY_CONVERT(DATE, :LX-DATE-LAST-TESTED 
                                            :WS-NULLIND-DATE-LAST-TESTED
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-TESTED 
                                           :WS-NULLIND-DATE-LAST-TESTED
              ) <> 0) OR (LEN(:LX-DATE-LAST-TESTED 
                                           :WS-NULLIND-DATE-LAST-TESTED
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-TESTED 
                                           :WS-NULLIND-DATE-LAST-TESTED
              ), CONVERT(DATE, :LX-DATE-LAST-TESTED 
                                           :WS-NULLIND-DATE-LAST-TESTED
              ) )  
                     ,IIF(TRY_CONVERT(DATE, :LX-DATE-LAST-TRAN 
                                            :WS-NULLIND-DATE-LAST-TRAN
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-TRAN 
                                             :WS-NULLIND-DATE-LAST-TRAN
              ) <> 0) OR (LEN(:LX-DATE-LAST-TRAN 
                                             :WS-NULLIND-DATE-LAST-TRAN
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-TRAN 
                                             :WS-NULLIND-DATE-LAST-TRAN
              ), CONVERT(DATE, :LX-DATE-LAST-TRAN 
                                             :WS-NULLIND-DATE-LAST-TRAN
              ) )      
                     ,IIF(TRY_CONVERT(DATE, :LX-DATE-PURCHASED 
                                            :WS-NULLIND-DATE-PURCHASED
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-PURCHASED 
                                             :WS-NULLIND-DATE-PURCHASED
              ) <> 0) OR (LEN(:LX-DATE-PURCHASED 
                                             :WS-NULLIND-DATE-PURCHASED
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-PURCHASED 
                                             :WS-NULLIND-DATE-PURCHASED
              ), CONVERT(DATE, :LX-DATE-PURCHASED 
                                             :WS-NULLIND-DATE-PURCHASED
              ) )      
                     ,IIF(TRY_CONVERT(DATE, :LX-WARRANTY-EXP-DT 
                                            :WS-NULLIND-WARRANTY-DATE
              ) IS NULL OR (PATINDEX('%.%', :LX-WARRANTY-EXP-DT 
                                              :WS-NULLIND-WARRANTY-DATE
              ) <> 0) OR (LEN(:LX-WARRANTY-EXP-DT 
                                              :WS-NULLIND-WARRANTY-DATE
              ) <> 10), CIS.CHAR2DATE(:LX-WARRANTY-EXP-DT 
                                              :WS-NULLIND-WARRANTY-DATE
              ), CONVERT(DATE, :LX-WARRANTY-EXP-DT 
                                              :WS-NULLIND-WARRANTY-DATE
              ) )      
                     ,IIF(TRY_CONVERT(DATE, :LX-DATE-OBSOLETE 
                                            :WS-NULLIND-DATE-OBSOLETE
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-OBSOLETE 
                                              :WS-NULLIND-DATE-OBSOLETE
              ) <> 0) OR (LEN(:LX-DATE-OBSOLETE 
                                              :WS-NULLIND-DATE-OBSOLETE
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-OBSOLETE 
                                              :WS-NULLIND-DATE-OBSOLETE
              ), CONVERT(DATE, :LX-DATE-OBSOLETE 
                                              :WS-NULLIND-DATE-OBSOLETE
              ) )        
P00462               ,:LX-SERIAL-NO                                     
                     ,IIF(TRY_CONVERT(DATE, :LX-DATE-DISPOSED-OF 
                                            :WS-NULLIND-DATE-DISPOSED
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-DISPOSED-OF 
                                              :WS-NULLIND-DATE-DISPOSED
              ) <> 0) OR (LEN(:LX-DATE-DISPOSED-OF 
                                              :WS-NULLIND-DATE-DISPOSED
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-DISPOSED-OF 
                                              :WS-NULLIND-DATE-DISPOSED
              ), CONVERT(DATE, :LX-DATE-DISPOSED-OF 
                                              :WS-NULLIND-DATE-DISPOSED
              ) ))    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_EQUIP_ATTCHMTS                                   
MFA-TR*            (  DEVICE_NO                                                 
MFA-TR*              ,CODE_ATT_TYPE                                             
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,CODE_UTIL_TYPE                                            
MFA-TR*              ,EQUIP_LOC_ID                                              
MFA-TR*              ,MTR_STORAGE_FAC_CD                                        
MFA-TR*              ,CODE_MAKE                                                 
MFA-TR*              ,TEST_SCHED_CD                                             
MFA-TR*              ,VERSION_CD                                                
MFA-TR*              ,EQUIP_ATTACH_DT                                           
MFA-TR*              ,DATE_LAST_MOVE                                            
MFA-TR*              ,DATE_LAST_TESTED                                          
MFA-TR*              ,DATE_LAST_TRAN                                            
MFA-TR*              ,DATE_PURCHASED                                            
MFA-TR*              ,WARRANTY_EXP_DT                                           
MFA-TR*              ,DATE_OBSOLETE                                             
MFA-TR*              ,SERIAL_NO                                                 
MFA-TR*              ,DATE_DISPOSED_OF)                                         
MFA-TR*        VALUES                                                           
MFA-TR*            (  :LX-DEVICE-NO                                             
MFA-TR*              ,:LX-CODE-ATT-TYPE                                         
MFA-TR*              ,:LX-COMPANY-NO                                            
MFA-TR*              ,:LX-CODE-UTIL-TYPE                                        
MFA-TR*              ,:LX-EQUIP-LOC-ID                                          
MFA-TR*              ,:LX-MTR-STORAGE-FAC-CD                                    
MFA-TR*              ,:LX-CODE-MAKE                                             
MFA-TR*              ,:LX-TEST-SCHED-CD                                         
MFA-TR*              ,:LX-VERSION-CD                                            
MFA-TR*              ,:LX-EQUIP-ATTACH-DT:WS-NULLIND-ATTACH-DT                  
MFA-TR*              ,:LX-DATE-LAST-MOVE:WS-NULLIND-DATE-LAST-MOVE              
MFA-TR*              ,:LX-DATE-LAST-TESTED:WS-NULLIND-DATE-LAST-TESTED          
MFA-TR*              ,:LX-DATE-LAST-TRAN:WS-NULLIND-DATE-LAST-TRAN              
MFA-TR*              ,:LX-DATE-PURCHASED:WS-NULLIND-DATE-PURCHASED              
MFA-TR*              ,:LX-WARRANTY-EXP-DT:WS-NULLIND-WARRANTY-DATE              
MFA-TR*              ,:LX-DATE-OBSOLETE:WS-NULLIND-DATE-OBSOLETE                
MFA-TR*              ,:LX-SERIAL-NO                                             
MFA-TR*              ,:LX-DATE-DISPOSED-OF:WS-NULLIND-DATE-DISPOSED)            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSMT601****************'        
               DISPLAY '* ERROR ON 7700-INSERT-EQUIP-ATTCHMTS *'        
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* ATTACH NBR ' E-FMT25-DEVICE-NO                
               DISPLAY '***************PCSMT601****************'        
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T35434*===============================================================*         
T35434 7800-SELECT-RESTART.                                             
T35434*===============================================================*         
T35434     EXEC  SQL                                                    
T35434        SELECT RESTART_DATA                                       
T35434          INTO :RF-RESTART-DATA                                   
T35434          FROM CSS_RESTART WITH(READUNCOMMITTED)                          
T35434         WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                    
T35434           AND PARTITION_NO = :RF-PARTITION-NO                    
T35434           AND  DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
A02034                                                           
A02034                                                      
T35434     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC  SQL                                                            
MFA-TR*       SELECT RESTART_DATA                                               
MFA-TR*         INTO :RF-RESTART-DATA                                           
MFA-TR*         FROM CSS_RESTART                                                
MFA-TR*        WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                            
MFA-TR*          AND PARTITION_NO = :RF-PARTITION-NO                            
MFA-TR*          AND  DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                           
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7800                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35434*                                                                 21060000
T35434     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T35434*                                                                 21060000
T35434        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
T35434                                       OR NOT-FOUND               
T35434           CONTINUE                                               
T35434        ELSE                                                      
T35434           DISPLAY '**  ERROR ON 7800-SELECT-RESTART   ***'       
T35434           DISPLAY '**  NAME_PROGRAM = ' RF-NAME-PROGRAM          
T35434           DISPLAY '**  PARTITION_NO = ' RF-PARTITION-NO          
T35434           DISPLAY '**  DUP_CNTRL_NO = ' RF-DUP-CNTRL-NO          
T35434           DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
T35434           DISPLAY '**      PROCESSING TERMINATED     **'         
T35434           PERFORM 9900-ABEND            THRU 9900-EXIT           
T35434        END-IF.                                                   
T35434*                                                                 21060000
T35434 7800-EXIT.                                                       
T35434      EXIT.                                                       
T35434                                                                  
P00462*                                                                         
P00462*================================================================*        
P00462 7950-FORMAT-DEVICE-NO.                                           
P00462*================================================================*        
P00462*                                                                         
P00462     EXEC SQL                                                     
P00462          SELECT
              CIS.SUBSTR3('000000000000',1 ,                           
P00462            (12 - DATALENGTH(RTRIM(LTRIM(:WS-FRMT-ATT))))) + 
           RTRIM(LTRIM(:WS-FRMT-ATT))
            INTO
              :WS-FRMT-ATT                   
P00462     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-FRMT-ATT   =                                            
MFA-TR*             SUBSTR('000000000000',1 ,                                   
MFA-TR*           (12 - LENGTH(RTRIM(LTRIM(:WS-FRMT-ATT)))))                    
MFA-TR*                 || RTRIM(LTRIM(:WS-FRMT-ATT))                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00462                                                                  
P00462     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00462*                                                                         
P00462     IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
P00462        DISPLAY '**    7950-FORMAT-DEVICE-NO       **'            
P00462        DISPLAY '** ATTACHMENT NO  : ' WS-FRMT-ATT                
P00462        DISPLAY '** SQLCODE        : ' WS-ACTIVE-RETURN-CODE      
P00462     END-IF.                                                      
P00462*                                                                         
P00462 7950-EXIT.                                                       
P00462     EXIT.                                                        
P00462*                                                                         
      ****************************************************************          
      **                                                            **          
      **  8000-INITIALIZE                                           **          
      **                                                            **          
      ****************************************************************          
       8000-INITIALIZE.                                                 
      *                                                                         
           MOVE WS-N TO WS-RECORD-FLAG.                                 
           COMPUTE WS-ERR-ARRAY-IDX  = 0.                               
           INITIALIZE DCLCSS-EQUIP-ATTCHMTS,                            
                      ERROR-HOLD-AREA.                                  
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  8100-READ-METER-FILE                                      **          
      **                                                            **          
      ****************************************************************          
       8100-READ-METER-FILE.                                            
      *                                                                         
           READ ATT-METER-FILE                                          
               AT END MOVE 'Y'         TO WS-EOF-FLAG.                  
      *                                                                         
           IF NOT END-OF-FILE                                           
               ADD 1                   TO WS-NBR-METER-RECS             
               DISPLAY 'ATTACHMENT NBR = ' E-FMT25-DEVICE-NO            
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * IF LINE COUNTER IS > 56 PRINTS THE PAGE HEADINGS, MOVES INPUT**         
      * VARIABLES TO THE REPORT VARIABLES AND  PRINTS THE REPORT.    **         
      *****************************************************************         
       8200-WRITE-PRINTER-RECORD.                                       
      *                                                                         
           IF WS-LINE-CNTR > WS-FIFTY-SIX                               
              PERFORM 8300-PRT-HEADINGS       THRU 8300-EXIT            
              ADD WS-TWO                      TO WS-LINE-CNTR           
              SET ERROR-FOUND                 TO TRUE                   
           END-IF.                                                      
           MOVE WS-DET-LINE-1                  TO PRT33-DATA.           
           PERFORM 8400-WRITE-PRINT-REC        THRU 8400-EXIT.          
           MOVE WS-ONE                         TO WS-LINE-SPACE.        
           ADD WS-ONE                          TO WS-LINE-CNTR.         
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  PRINTS THE PAGE HEADINGS  AT THE TOP OF EACH PAGE          **          
      ****************************************************************          
       8300-PRT-HEADINGS.                                               
      *                                                                         
           MOVE 0                              TO WS-LINE-CNTR.         
           ADD WS-ONE                          TO WS-PAGE.              
           MOVE WS-PAGE                        TO WS-DET-PAGE.          
           MOVE WS-HDR-ONE                     TO PRT33-DATA.           
           WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
           MOVE WS-HDR-TWO                     TO PRT33-DATA.           
           MOVE WS-ONE                         TO WS-LINE-SPACE.        
           PERFORM 8400-WRITE-PRINT-REC        THRU 8400-EXIT.          
           MOVE WS-BLANK-LINE                  TO PRT33-DATA.           
           PERFORM 8400-WRITE-PRINT-REC        THRU 8400-EXIT.          
           MOVE WS-HDR-THREE                   TO PRT33-DATA.           
           MOVE WS-TWO                         TO WS-LINE-SPACE.        
           PERFORM 8400-WRITE-PRINT-REC        THRU 8400-EXIT.          
           MOVE WS-BLANK-LINE                  TO PRT33-DATA.           
           MOVE WS-ONE                         TO WS-LINE-SPACE.        
           PERFORM 8400-WRITE-PRINT-REC        THRU 8400-EXIT.          
           ADD  WS-SIX                         TO WS-LINE-CNTR.         
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** WRITES THE PRINT RECORD                                      **        
      ******************************************************************        
       8400-WRITE-PRINT-REC.                                            
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING WS-LINE-SPACE.            
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  8500-PRODUCE-SUMMARY-REPORTS                              **          
      **                                                            **          
      ****************************************************************          
       8500-PRODUCE-SUMMARY-REPORTS.                                    
      *                                                                         
           IF WS-LINE-CNTR > WS-FIFTY-TWO                               
              PERFORM 8300-PRT-HEADINGS       THRU 8300-EXIT            
              ADD WS-TWO               TO WS-LINE-CNTR                  
           END-IF.                                                      
           MOVE WS-ONE                 TO WS-LINE-SPACE.                
           IF NOT ERROR-FOUND                                           
              MOVE WS-NO-ERROR-LINE    TO PRT33-DATA                    
              PERFORM 8400-WRITE-PRINT-REC    THRU 8400-EXIT            
           END-IF.                                                      
           MOVE WS-BLANK-LINE          TO PRT33-DATA.                   
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
           MOVE WS-TOT-RECDS-INFO      TO WS-RPT-MESSAGE.               
           MOVE WS-NBR-METER-RECS      TO WS-RPT-STATISTICS.            
           MOVE WS-DET-LINE-2          TO PRT33-DATA.                   
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
           MOVE WS-TOT-GOOD-RECDS      TO WS-RPT-MESSAGE.               
           MOVE WS-NBR-GOOD-RECS       TO WS-RPT-STATISTICS.            
           MOVE WS-DET-LINE-2          TO PRT33-DATA.                   
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
           MOVE WS-TOT-BAD-RECDS       TO WS-RPT-MESSAGE.               
           MOVE WS-NBR-BAD-RECS        TO WS-RPT-STATISTICS.            
           MOVE WS-DET-LINE-2          TO PRT33-DATA.                   
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
           MOVE WS-TOT-UNADDED-MTRS    TO WS-RPT-MESSAGE.               
           MOVE WS-NO-ADDITION-MTRS    TO WS-RPT-STATISTICS.            
           MOVE WS-DET-LINE-2          TO PRT33-DATA.                   
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
           MOVE WS-BLANK-LINE          TO PRT33-DATA.                   
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
           MOVE WS-FOOT-LINE           TO PRT33-DATA.                   
           PERFORM 8400-WRITE-PRINT-REC       THRU 8400-EXIT.           
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T35434*================================================================*        
T35434 8800-WRITE-RESTART.                                              
T35434*================================================================*        
T35434*                                                                         
T35434     ADD  1                     TO  WS-CHKP-SEQ-NO.               
T35434     MOVE WS-CHKP-SEQ-NO        TO WS-RESTART-CHKP-SEQ-NO.        
T35434*                                                                         
T35434     MOVE WS-PGRMNAME            TO RF-NAME-PROGRAM.              
T35434     MOVE 1                      TO RF-PARTITION-NO.              
T35434     MOVE 1                      TO RF-DUP-CNTRL-NO.              
T35434     MOVE WS-RESTART-DATA        TO RF-RESTART-DATA-TEXT.         
T35434     MOVE WS-RESTART-DATA-LENGTH TO RF-RESTART-DATA-LEN.          
T35434*                                                                         
T35434     PERFORM 8850-UPDATE-RESTART           THRU 8850-EXIT.        
T35434     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
T35434        PERFORM 8860-INSERT-RESTART        THRU 8860-EXIT         
T35434     END-IF.                                                      
T35434*                                                                         
T35434 8800-EXIT.                                                       
T35434      EXIT.                                                       
T35434*                                                                         
T35434*================================================================*        
T35434 8850-UPDATE-RESTART.                                             
T35434*================================================================*        
T35434*                                                                         
T35434        EXEC SQL                                                  
T35434            UPDATE CSS_RESTART                                    
T35434            SET RESTART_DATA   = :RF-RESTART-DATA                 
T35434            WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                 
T35434              AND PARTITION_NO = :RF-PARTITION-NO                 
T35434              AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                 
T35434        END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35434*                                                                         
T35434        MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.        
T35434*                                                                         
T35434        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
T35434                                       OR NOT-FOUND               
T35434           CONTINUE                                               
T35434        ELSE                                                      
T35434           DISPLAY '**  ERROR ON 8850-UPDATE-RESTART  *'          
T35434           DISPLAY '**  NAME_PROGRAM = ' RF-NAME-PROGRAM          
T35434           DISPLAY '**  PARTITION_NO = ' RF-PARTITION-NO          
T35434           DISPLAY '**  DUP_CNTRL_NO = ' RF-DUP-CNTRL-NO          
T35434           DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
T35434           DISPLAY '**      PROCESSING TERMINATED     **'         
T35434           PERFORM 9900-ABEND            THRU 9900-EXIT           
T35434        END-IF.                                                   
T35434*                                                                         
T35434 8850-EXIT.                                                       
T35434      EXIT.                                                       
T35434*                                                                         
T35434*================================================================*        
T35434 8860-INSERT-RESTART.                                             
T35434*================================================================*        
T35434*                                                                         
T35434        EXEC SQL                                                  
T35434             INSERT INTO CSS_RESTART                              
T35434                         (NAME_PROGRAM                            
T35434                         ,PARTITION_NO                            
T35434                         ,DUP_CNTRL_NO                            
T35434                         ,RESTART_DATA)                           
T35434             VALUES    (:RF-NAME-PROGRAM                          
T35434                       ,:RF-PARTITION-NO                          
T35434                       ,:RF-DUP-CNTRL-NO                          
T35434                       ,:RF-RESTART-DATA)                         
T35434        END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35434*                                                                         
T35434        MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.        
T35434*                                                                         
T35434        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
T35434           CONTINUE                                               
T35434        ELSE                                                      
T35434           DISPLAY '**  ERROR ON 8860-INSERT-RESTART  *'          
T35434           DISPLAY '**  NAME_PROGRAM = ' RF-NAME-PROGRAM          
T35434           DISPLAY '**  PARTITION_NO = ' RF-PARTITION-NO          
T35434           DISPLAY '**  DUP_CNTRL_NO = ' RF-DUP-CNTRL-NO          
T35434           DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
T35434           DISPLAY '**      PROCESSING TERMINATED     **'         
T35434           PERFORM 9900-ABEND            THRU 9900-EXIT           
T35434        END-IF.                                                   
T35434*                                                                         
T35434 8860-EXIT.                                                       
T35434      EXIT.                                                       
T35434*                                                                         
T35434******************************************************************        
T35434* 8893-RESET-RESTART-REQ-PARM                                    *        
T35434******************************************************************        
T35434     EXEC SQL                                                             
T35434         INCLUDE CPD00029                                                 
T35434     END-EXEC.                                                            
T35434*                                                                         
PRJ914*================================================================*        
PRJ914 8900-INSERT-METER-ATTCH.                                         
PRJ914*================================================================*        
PRJ914*                                                                         
PRJ914     EXEC SQL                                                     
PRJ914         INSERT INTO CSS_METER_ATTCHMTS                           
PRJ914             (  CODE_UTIL_TYPE                                    
PRJ914               ,METER_NO                                          
PRJ914               ,CODE_DEVICE_TYPE                                  
PRJ914               ,DEVICE_NO                                         
PRJ914               ,CODE_ATT_TYPE                                     
PRJ914               ,CT_PT_RATIO                                       
PRJ914               ,CODE_MAKE                                         
PRJ914               ,DATE_LAST_TESTED                                  
PRJ914               ,TEST_SCHED_CD                                     
PRJ914               ,HOW_ATTACHED_CD                                   
PRJ914               ,COMPANY_NO)                                       
PRJ914         VALUES                                                   
PRJ914             (  :MA-CODE-UTIL-TYPE                                
PRJ914               ,:MA-METER-NO                                      
PRJ914               ,:MA-CODE-DEVICE-TYPE                              
PRJ914               ,:MA-DEVICE-NO                                     
PRJ914               ,:MA-CODE-ATT-TYPE                                 
PRJ914               ,:MA-CT-PT-RATIO                                   
PRJ914               ,:MA-CODE-MAKE                                     
PRJ914               ,IIF(TRY_CONVERT(DATE, :MA-DATE-LAST-TESTED 
                                            :WS-NULLIND-DATE-LAST-TESTED
              ) IS NULL OR (PATINDEX('%.%', :MA-DATE-LAST-TESTED 
                                           :WS-NULLIND-DATE-LAST-TESTED
              ) <> 0) OR (LEN(:MA-DATE-LAST-TESTED 
                                           :WS-NULLIND-DATE-LAST-TESTED
              ) <> 10), CIS.CHAR2DATE(:MA-DATE-LAST-TESTED 
                                           :WS-NULLIND-DATE-LAST-TESTED
              ), CONVERT(DATE, :MA-DATE-LAST-TESTED 
                                           :WS-NULLIND-DATE-LAST-TESTED
              ) )  
PRJ914               ,:MA-TEST-SCHED-CD                                 
PRJ914               ,:MA-HOW-ATTACHED-CD                               
PRJ914               ,:MA-COMPANY-NO)                                   
PRJ914     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_METER_ATTCHMTS                                   
MFA-TR*            (  CODE_UTIL_TYPE                                            
MFA-TR*              ,METER_NO                                                  
MFA-TR*              ,CODE_DEVICE_TYPE                                          
MFA-TR*              ,DEVICE_NO                                                 
MFA-TR*              ,CODE_ATT_TYPE                                             
MFA-TR*              ,CT_PT_RATIO                                               
MFA-TR*              ,CODE_MAKE                                                 
MFA-TR*              ,DATE_LAST_TESTED                                          
MFA-TR*              ,TEST_SCHED_CD                                             
MFA-TR*              ,HOW_ATTACHED_CD                                           
MFA-TR*              ,COMPANY_NO)                                               
MFA-TR*        VALUES                                                           
MFA-TR*            (  :MA-CODE-UTIL-TYPE                                        
MFA-TR*              ,:MA-METER-NO                                              
MFA-TR*              ,:MA-CODE-DEVICE-TYPE                                      
MFA-TR*              ,:MA-DEVICE-NO                                             
MFA-TR*              ,:MA-CODE-ATT-TYPE                                         
MFA-TR*              ,:MA-CT-PT-RATIO                                           
MFA-TR*              ,:MA-CODE-MAKE                                             
MFA-TR*              ,:MA-DATE-LAST-TESTED:WS-NULLIND-DATE-LAST-TESTED          
MFA-TR*              ,:MA-TEST-SCHED-CD                                         
MFA-TR*              ,:MA-HOW-ATTACHED-CD                                       
MFA-TR*              ,:MA-COMPANY-NO)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ914*                                                                         
PRJ914     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PRJ914*                                                                         
PRJ914     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
PRJ914        CONTINUE                                                  
PRJ914     ELSE                                                         
PRJ914        DISPLAY '**  ERROR ON 8900-INSERT-METER-ATTCH **'         
PRJ914        DISPLAY '**  CODE_UTIL_TYPE = ' MA-CODE-UTIL-TYPE         
PRJ914        DISPLAY '**  METER_NO       = ' MA-METER-NO               
PRJ914        DISPLAY '**  DEVICE_NO      = ' MA-DEVICE-NO              
PRJ914        DISPLAY '**  CODE_ATT_TYPE  = ' MA-CODE-ATT-TYPE          
PRJ914        DISPLAY '**  COMPANY_NO     = ' MA-COMPANY-NO             
PRJ914        DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
PRJ914        DISPLAY '**      PROCESSING TERMINATED        **'         
PRJ914        PERFORM 9900-ABEND            THRU 9900-EXIT              
PRJ914     END-IF.                                                      
PRJ914*                                                                         
PRJ914 8900-EXIT.                                                       
PRJ914     EXIT.                                                        
PRJ914*                                                                         
      ****************************************************************          
      **                                                            **          
      **  9000-TERMINATE                                            **          
      **                                                            **          
      ****************************************************************          
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE ATT-METER-FILE                                         
                 FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE     **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
