       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSMT500.                                        
       AUTHOR.         CBSI-MADRAS.                                     
       DATE-WRITTEN.   02/18/97.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC AND GAS                **         
      **                                                             **         
      ********            CUSTOMER INFORMATION SYSTEM         *********         
      *****************************************************************         
      **                  P R O G R A M S U M M A R Y                **         
      **                                                             **         
      **                                                             **         
      **           F U N C T I O N A L    D E S C R I P T I O N      **         
      **                       O F   M O D U L E                     **         
      **                                                             **         
      **                                                             **         
      **  PURPOSE :                                                  **         
      **  DELETE ELECTRIC METERS AND TRANSFORMERS WITH A LOCATION    **         
      **  CODE OF 'RETIRED' AFTER 5 YEARS.                           **         
      **  DELETE GAS METERS WITH A LOCATION CODE OF 'RETIRED'        **         
      **  AFTER 2 YEARS.                                             **         
      **  RETIRE ELECTRIC METERS, GAS METERS AND TRANSFORMERS WITH   **         
      **  A LOCATION CODE OF 'UNKNOWN' AFTER 2 YEARS.                **         
      **  PRINT A REPORT OF ELECTRIC METERS, GAS METERS AND          **         
      **  TRANFORMERS WITH A LOCATION MOVEMENT FROM 'UNKNOWN' TO     **         
      **  'RETIRED' AND ALSO FOR THE DELETED DEVICES.                **         
PCR533**                                                             **         
PCR533** 05/97     CBSI      TO SEND THE PREVIOUS LOCATION OF GAS    **         
PCR533**           MADRAS    METER TO THE OUTPUT FILE BEFORE CODE IS **         
PCR533**                     CHANGED TO UNKNOWN.WHEN THE LOCATION    **         
PCR533**                     CODE IS 'X' ACCOUNT NUMBER IS SEND      **         
PCR533**                     INSTEAD OF ADDRESS                      **         
      **                                                             **         
T18026** 11/98     CBSI      CHANGES MADE TO POPULATE DATE FIELDS    **         
T18026**                     TO WQ TABLE WITH CENTURY.               **         
      **                                                             **         
T22243** 10/00     CBSI      CHANGES MADE TO IMPLEMENT MULTI-        **         
T22243**           MADRAS    COMPANY IN METER INVENTORY              **         
T22243** 01/01     CBSI      CHANGES MADE IN RET-MTR CURSOR          **         
T22243**           MADRAS                                            **         
C23811** 04/01     GSR       CHANGES MADE TO HANDLE COMPANY_NO       **         
C23811**                     ON CSS_GAS_METER_SIZE TABLE.            **         
BGBG01** 01/06/04  GAUSE     ADDED DISPLAY IN PARA 7430 ON BAD CALL  **         
BGBG01**                     ADDED EQ-COMPANY-NO TO INSERT CALL IN   **         
BGBG01**                     PARA 7430                               **         
T35434** 06/07/07  PC97415   REPLACED MODEL_SQL TO SET COMMANDS      **         
T35434**                     AND ADDED FETCH ONLY WITH UR FOR        **         
T35434**                     AVOIDING -911 ABENDS.                   **         
T35249** 07/07     PSG       WRITE CURRENT RETIRED/UNKNOW STATUS     **         
T35249**                     ATTACHED TO ACTIVE ACCOUNT TO WQ        **         
      **                                                             **         
36906 ** 8 FEB 2008 RF10596  CHANGE THE CURSOR IN 7960-METER-ERR     **         
      **                     AND THE MESSAGE IN COMMENT 3 AND 4      **         
      **                                                             **         
C36856** 09/16/2008 KW42462 DELETE/RETIRE ATTACHMENT WHEN DELETING   **         
      **                    OR RETIRING METERS WHEN APPLICABLE AND   **         
      **                    ADD COMMITS TO PROGRAM                   **         
ACT022** 03/23/2011 BG17805  APL3082 CORRECT WQ REASSIGNEMENT        **         
A03352*  07/12/2011 MC95456  CHANGE WORK QUE CATEGORY FROM 143 TO   **          
A03352*                      528 - SCEG (ROUTING CATEGORY OF 4)     **          
A03352*                      529 - PSNC (ROUTING CATEGORY OF 1)     **          
A04860** 09/08/2014 AS7C117  REPLACE CSS_WQ_ITEMS_MF WITH           **          
A04860**            ACT041   CSS_WQ_ITEMS.                          **          
                                                                        
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  _________    __________________________________  **         
      **                                                             **         
      *****************************************************************         
           REMARKS.                                                     
                   --THIS IS A NEW PROGRAM WRITTEN TO RUN YEARLY--      
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH                       
                1000 - 1999     INITIALIZATION                          
                2000 - 2999     INPUT  PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES                
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSMT51.                                                            
       COPY CSSMT52.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDMT51.                                                            
       COPY FIOMT51.                                                            
       COPY CFDMT52.                                                            
       COPY FIOMT52.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSMT500'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                       PIC X(40)  VALUE              
           'WORKING STORAGE FOR PCSMT500 STARTS HERE'.                  
      *                                                                         
       01  WS-RUN-DATE.                                                 
          03  WS-CY                       PIC X(02)  VALUE SPACES.      
          03  WS-CM                       PIC X(02)  VALUE SPACES.      
          03  WS-CD                       PIC X(02)  VALUE SPACES.      
      *                                                                         
A04860 01  WS-CUR-DATE                    PIC X(26).                    
A04860 01  WS-DATE-CREATED                PIC X(26).                    
      *                                                                         
       01  WS-FMT51-STATUS                PIC X(02).                    
      *                                                                         
       01  WS-FMT52-STATUS                PIC X(02).                    
      *                                                                         
       01  WS-MISC.                                                     
      *                                                                         
           03  WS-LINE-SPACE              PIC 9(01)  VALUE 1.           
      *                                                                         
           03  WS-FIVE-YEARS-AGO          PIC X(10).                    
      *                                                                         
           03  WS-TWO-YEARS-AGO           PIC X(10).                    
      *                                                                         
           03  RS-RETURN-CODE             PIC S9(9)  VALUE +000 COMP.   
      *                                                                         
           03  RS-RETURN-CODE-DISP        PIC S9(9)  VALUE +000 COMP.   
      *                                                                         
           03  PROGRAM-NAME               PIC X(10)  VALUE 'PCSMT500'.  
      *                                                                         
A04860     03  SCSCB077                   PIC X(8)   VALUE 'SCSCB077'.  
A04860*                                                                         
           03  WS-REC-EXISTS              PIC X(01).                    
      *                                                                         
           03  ONE-EXISTS                 PIC S9(9)  VALUE -811 COMP.   
      *                                                                         
           03  WS-INSTALL-MOVE-NO         PIC X(26).                    
      *                                                                         
COB305     03 WS-ACCOUNT        PIC S9(13) COMP-3 VALUE 0.            
COB305     03 WS-CUSTOMER        PIC S9(10) COMP-3 VALUE 0.            
COB305     03 WS-PREMISE        PIC S9(10) COMP-3 VALUE 0.            
T35249     03  WS-OFFICE                  PIC X(03).                    
           03  WS-MOVE-NO-NULL            PIC S9(4) COMP.               
PCR533     03  WS-NO-OF-ATTCH             PIC S9(4) COMP.               
PCR533     03  WS-NO-OF-ATTCH-NULL        PIC S9(4) COMP.               
C36856*                                                                         
C36856 01  WS-COMMIT-SECTION.                                           
C36856     05  WS-FLAG-TO-TURN-OFF-COMMITS PIC 9(04) VALUE 9999.        
C36856     05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 20.          
C36856     05  WS-CHKP-LUW-LIMIT           PIC 9(04).                   
C36856*    05  WS-CHKP-LUW-COUNTER         PIC 9(04) COMP-3 VALUE ZERO.         
C36856     05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 20.          
C36856     05  WS-CHKP-UPD-LIMIT           PIC 9(04).                   
C36856     05  WS-COMMIT-COUNTER           PIC S9(3) COMP-3 VALUE 0.    
C36856     05  WS-COMMIT-REQ-SW            PIC X(1)  VALUE 'Y'.         
C36856         88 WS-COMMITS-REQUIRE                 VALUE 'Y'.         
C36856         88 WS-COMMITS-NOT-REQUIRE             VALUE 'N'.         
C36856     05  WS-CHKP-UPD-COUNTER         PIC S9(04) COMP-3 VALUE ZERO.
C36856     05  WS-PGRMNAME             PIC X(8)    VALUE 'PCSMT500'.    
C36856*                                                                         
       01  WS-FLAG.                                                     
           03  WS-DIS-MTR-FLAG            PIC X(1)   VALUE 'N'.         
           03  WS-TRAN-EQP-FLAG           PIC X(1)   VALUE 'N'.         
           03  WS-GAS-EQP-FLAG            PIC X(1)   VALUE 'N'.         
           03  WS-RET-MTR-FLAG            PIC X(1)   VALUE 'N'.         
C36856     03  WS-INT-ERT-FLAG            PIC X(1)   VALUE 'N'.         
C36856     03  WS-NON-INT-ERT-FLAG        PIC X(1)   VALUE 'N'.         
           03  WS-MOVE-HIST-FLAG          PIC X(1)   VALUE 'N'.         
T35249     03  WS-DATA-IND                PIC X(1)   VALUE 'N'.         
           03  WS-NON-U-REC-SWITCH        PIC X(1).                     
               88  NON-U-REC-NOT-FOUND               VALUE 'N'.         
               88  NON-U-REC-FOUND                   VALUE 'Y'.         
PCR533     03  WS-FIRST-MOVE-HIST-FLAG    PIC X(1).                     
PCR533         88  FIRST-MOVE-HIST-FOUND             VALUE 'Y'.         
PCR533         88  FIRST-MOVE-HIST-NOT-FOUND         VALUE 'N'.         
      *                                                                         
       01  WS-LITERALS.                                                 
           03  WS-E                       PIC X(1)   VALUE 'E'.         
           03  WS-G                       PIC X(1)   VALUE 'G'.         
           03  WS-X                       PIC X(1)   VALUE 'X'.         
           03  WS-U                       PIC X(1)   VALUE 'U'.         
           03  WS-I                       PIC X(1)   VALUE 'I'.         
           03  WS-Y                       PIC X(1)   VALUE 'Y'.         
           03  WS-N                       PIC X(1)   VALUE 'N'.         
           03  WS-J                       PIC X(1)   VALUE 'J'.         
ACT022 01 CNT-WQ-WRITTEN                PIC 9(9)   VALUE 0.             
      *                                                                         
       01  WS-PR-ADDRESS.                                               
           05 WS-PR-ADR-STR                PIC  X(30).                  
           05 WS-PR-ADDR-FILLER            PIC  X(01).                  
           05 WS-PR-CITY-ST-ZIP            PIC  X(24).                  
       01  WS-ADDR-UNKNOWN-MSG             PIC  X(30)                   
           VALUE 'PREMISE ADDR NOT AVAILABLE FOR'.                      
       01  WS-PR-ACTIVE-RETURN-CODE        PIC S9(4) COMP.              
      *                                                                         
       COPY CWS00023.                                                           
       COPY CWS00074.                                                           
      ****************************************************************          
      *                   WORK QUEUE VARIABLES                       *          
      ****************************************************************          
      *                                                                         
       01  WS-WORK-QUEUE-DIRECTION.                                     
      *    WQ CAT ID = 97 "INCORRECT METER MOVEMEMENT"                          
           03  WS-CATEGORY-ID             PIC S9(04) COMP VALUE 97.     
      *    ROUTING CATEGOR = 4 "ROUTE BASED ON CATEGORY ONLY"                   
           03  WS-ROUTING-CATEGORY        PIC X      VALUE '4'.         
      *                                                                         
       01  WS-WQ-COMMENTS.                                              
           03  WS-WQ-MESSAGE              PIC X(250).                   
      *                                                                         
       01  WS-WORK-QUEUE-COMMENT1.                                      
           03  FILLER                     PIC X(23)  VALUE              
               'RETIRED ELECTRIC METER '.                               
           03  WS-WQ-METER-NO             PIC X(09).                    
           03  FILLER                     PIC X(83)  VALUE              
               'CANNOT BE DELETED BECAUSE IT HAS METER DEVICE,INSTRUMENT        
      -        ' TRANSFORMER ATTACHED TO IT'.                                   
      *                                                                         
       01  WS-WORK-QUEUE-COMMENT2.                                      
           03  FILLER                     PIC X(18)  VALUE              
               'LOCATION OF METER '.                                    
           03  WS-WQ-METER-NO             PIC X(09).                    
           03  FILLER                     PIC X(110) VALUE              
               'CANNOT BE CHANGED FROM UNKNOWN TO RETIRED BECAUSE IT HAS        
      -        ' METER DEVICE OR INSTRUMENT TRANSFORMER ATTACHED TO IT'.        
      *                                                                         
T35249 01  WS-WORK-QUEUE-COMMENT3.                                      
T35249     03  FILLER                     PIC X(15)  VALUE              
T35249         'ELECTRIC METER '.                                       
T35249     03  WS-WQ-METR-ELC             PIC X(09).                    
T35249     03  FILLER                     PIC X(35)  VALUE              
T35249         ' IS CURRENTLY WITH RETIRED/UNKNOWN '.                   
36906      03  FILLER                     PIC X(36)  VALUE              
36906          'STATUS, BUT ATTACHED TO AN ACCOUNT: '.                  
T35249     03  WS-WQ-ACCT-ELC             PIC 9(13).                    
T35249     03  FILLER                     PIC X(44) VALUE               
T35249         '. PLEASE REVIEW AND CORRECT METER INVENTORY.'.          
      *                                                                         
T35249 01  WS-WORK-QUEUE-COMMENT4.                                      
T35249     03  FILLER                     PIC X(10)  VALUE              
T35249         'GAS METER '.                                            
T35249     03  WS-WQ-METR-GAS             PIC X(09).                    
T35249     03  FILLER                     PIC X(35)  VALUE              
T35249         ' IS CURRENTLY WITH RETIRED/UNKNOWN '.                   
36906      03  FILLER                     PIC X(36)  VALUE              
36906          'STATUS, BUT ATTACHED TO AN ACCOUNT: '.                  
T35249     03  WS-WQ-ACCT-GAS             PIC 9(13).                    
T35249     03  FILLER                     PIC X(44) VALUE               
T35249         '. PLEASE REVIEW AND CORRECT METER INVENTORY.'.          
      *                                                                         
C36856 01 WS-WORK-QUEUE-COMMENT5.                                       
C36856     03  FILLER                     PIC X(18)  VALUE              
C36856         'RETIRED GAS METER '.                                    
C36856     03  WS-WQ-METER-NO             PIC X(09).                    
C36856     03  FILLER                     PIC X(110) VALUE              
C36856         ' CANNOT BE DELETED BECAUSE IT HAS METER DEVICE                  
C36856-        'ATTACHED TO IT'.                                                
      *                                                                         
C36856****************************************************************          
C36856*  CWS00038  JOB PARM ROUTINE                                  *          
C36856****************************************************************          
C36856*                                                                         
C36856 COPY CWS00038.                                                           
C36856*                                                                         
C36856****************************************************************          
C36856*  IO AREA FOR GETTING THE COMMIT PARM FROM CSS_JOB_PARM       *          
C36856****************************************************************          
C36856*                                                                         
C36856 COPY FIOJC01.                                                            
C36856*                                                                         
      **************COPY LIB FOR DB2 ERROR PROCESSING  ****************         
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      **************COPY LIB FOR ABEND ERROR PROCESSING****************         
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00010.                                                           
      *                                                                         
       01  ABEND-FUNCTIONS.                                             
           03  WS-ABEND-SPACE             PIC X(02).                    
           03  FILLER REDEFINES WS-ABEND-SPACE.                         
               05  WS-ABEND-NUMERIC       PIC 9(02).                    
      *                                                                         
      *****************************************************************         
      **        INCLUDE DLCGEN TABLE AND HOST VARIABLE DEFINTIONS    **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      *****************************************************************         
      **              APPLICATION TABLE DCLGENS                      **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBELMTR                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEMTRSP                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBXSSPEC                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGASMSZ                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGASMTR                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBINXFOR                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRATT                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMVHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      * DCLGENS FOR GETTING AND FORMATTING ADDRESS                              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
T35249*                                                                         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
T35249*                                                                         
T35249*DCLGEN FOR CSS_MTRD_ENVRNMT                                              
T35249     EXEC SQL                                                             
T35249         INCLUDE TBMTRENV                                                 
T35249     END-EXEC.                                                            
      *                                                                         
C36856*CSS_EQUIP_ATTCHMTS (LX)                                                  
C36856     EXEC SQL                                                             
C36856         INCLUDE TBEQATTH                                                 
C36856     END-EXEC.                                                            
      *                                                                         
C36856*CSS_EQUIP_ATT_MOVE (MP)                                                  
C36856     EXEC SQL                                                             
C36856         INCLUDE TBEQMOVE                                                 
C36856     END-EXEC.                                                            
C36856*                                                                         
C36856*CSS_JOB_PARM                                                             
C36856     EXEC SQL                                                             
C36856         INCLUDE TBJBPARM                                                 
C36856     END-EXEC.                                                            
C36856*                                                                         
A04860/****** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077             
A04860      EXEC SQL                                                            
A04860           INCLUDE CWS00077                                               
A04860      END-EXEC.                                                           
A04860*                                                                         
      *                                                                         
      *****************************************************************         
      **                SQL DECLARE STATEMENTS                       **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
                DECLARE MOV-HIST CURSOR FOR                             
                SELECT                                                  
                      REPLACE(REPLACE(CONVERT(CHAR(26), MOVE_NO, 121), 
           ' ', '-'), ':', '.') MOVE_NO,                                       
                      LOCAL_OFFICE,                                     
                      LOC_NO,                                           
                      CODE_CRNT_LOC                                     
                FROM  CSS_MOVEMENT_HIST WITH(READUNCOMMITTED)                   
                WHERE CODE_UTIL_TYPE = :MV-CODE-UTIL-TYPE               
                  AND DEVICE_NO      = :MV-DEVICE-NO                    
T22243            AND COMPANY_NO     = :MV-COMPANY-NO                   
                ORDER BY MOVE_NO DESC                                   
T35434          FOR READ ONLY                                   
ACT022                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE MOV-HIST CURSOR FOR                                     
MFA-TR*         SELECT                                                          
MFA-TR*               MOVE_NO,                                                  
MFA-TR*               LOCAL_OFFICE,                                             
MFA-TR*               LOC_NO,                                                   
MFA-TR*               CODE_CRNT_LOC                                             
MFA-TR*         FROM  CSS_MOVEMENT_HIST                                         
MFA-TR*         WHERE CODE_UTIL_TYPE = :MV-CODE-UTIL-TYPE                       
MFA-TR*           AND DEVICE_NO      = :MV-DEVICE-NO                            
MFA-TR*           AND COMPANY_NO     = :MV-COMPANY-NO                           
MFA-TR*         ORDER BY MOVE_NO DESC                                           
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7900                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      **                                                                        
      *                                                                         
           EXEC SQL                                                     
C36856          DECLARE DIS-MTR CURSOR WITH HOLD FOR                    
                SELECT                                                  
                      DEVICE_NO,                                        
T22243                COMPANY_NO                                        
                FROM  CSS_EQUIPMENT WITH(READUNCOMMITTED)                       
                WHERE CODE_UTIL_TYPE    =  :WS-E                        
                AND   CODE_CRNT_LOC     =  :WS-I                        
                AND   DATE_DISPOSED_OF  <= IIF(TRY_CONVERT(DATE, 
                                                     :WS-FIVE-YEARS-AGO
              ) IS NULL OR (PATINDEX('%.%', :WS-FIVE-YEARS-AGO
              ) <> 0) OR (LEN(:WS-FIVE-YEARS-AGO
              ) <> 10), CIS.CHAR2DATE(:WS-FIVE-YEARS-AGO
              ), CONVERT(DATE, :WS-FIVE-YEARS-AGO) )           
T35434          FOR READ ONLY                                   
ACT022                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE DIS-MTR CURSOR WITH HOLD FOR                            
MFA-TR*         SELECT                                                          
MFA-TR*               DEVICE_NO,                                                
MFA-TR*               COMPANY_NO                                                
MFA-TR*         FROM  CSS_EQUIPMENT                                             
MFA-TR*         WHERE CODE_UTIL_TYPE    =  :WS-E                                
MFA-TR*         AND   CODE_CRNT_LOC     =  :WS-I                                
MFA-TR*         AND   DATE_DISPOSED_OF  <= :WS-FIVE-YEARS-AGO                   
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      **                                                                        
      *                                                                         
           EXEC SQL                                                     
C36856          DECLARE TRAN-EQP CURSOR WITH HOLD FOR                   
                SELECT                                                  
                      DEVICE_NO,                                        
T22243                COMPANY_NO                                        
                FROM  CSS_EQUIPMENT WITH(READUNCOMMITTED)                       
                WHERE CODE_UTIL_TYPE   =   :WS-X                        
                AND   CODE_CRNT_LOC    =   :WS-I                        
                AND   DATE_DISPOSED_OF <=  IIF(TRY_CONVERT(DATE, 
                                                     :WS-FIVE-YEARS-AGO
              ) IS NULL OR (PATINDEX('%.%', :WS-FIVE-YEARS-AGO
              ) <> 0) OR (LEN(:WS-FIVE-YEARS-AGO
              ) <> 10), CIS.CHAR2DATE(:WS-FIVE-YEARS-AGO
              ), CONVERT(DATE, :WS-FIVE-YEARS-AGO) )           
T35434          FOR READ ONLY                                   
ACT022                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE TRAN-EQP CURSOR WITH HOLD FOR                           
MFA-TR*         SELECT                                                          
MFA-TR*               DEVICE_NO,                                                
MFA-TR*               COMPANY_NO                                                
MFA-TR*         FROM  CSS_EQUIPMENT                                             
MFA-TR*         WHERE CODE_UTIL_TYPE   =   :WS-X                                
MFA-TR*         AND   CODE_CRNT_LOC    =   :WS-I                                
MFA-TR*         AND   DATE_DISPOSED_OF <=  :WS-FIVE-YEARS-AGO                   
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      **                                                                        
      *                                                                         
           EXEC SQL                                                     
C36856          DECLARE GAS-EQP CURSOR WITH HOLD FOR                    
                SELECT                                                  
                      DEVICE_NO,                                        
                      SERIAL_NO,                                        
T22243                COMPANY_NO                                        
                FROM  CSS_EQUIPMENT WITH(READUNCOMMITTED)                       
                WHERE CODE_UTIL_TYPE    =  :WS-G                        
                AND   CODE_CRNT_LOC     =  :WS-I                        
                AND   DATE_DISPOSED_OF  <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-TWO-YEARS-AGO
              ) IS NULL OR (PATINDEX('%.%', :WS-TWO-YEARS-AGO
              ) <> 0) OR (LEN(:WS-TWO-YEARS-AGO) <> 10), CIS.CHAR2DATE(
                                                      :WS-TWO-YEARS-AGO
              ), CONVERT(DATE, :WS-TWO-YEARS-AGO) )            
T35434          FOR READ ONLY                                   
ACT022                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE GAS-EQP CURSOR WITH HOLD FOR                            
MFA-TR*         SELECT                                                          
MFA-TR*               DEVICE_NO,                                                
MFA-TR*               SERIAL_NO,                                                
MFA-TR*               COMPANY_NO                                                
MFA-TR*         FROM  CSS_EQUIPMENT                                             
MFA-TR*         WHERE CODE_UTIL_TYPE    =  :WS-G                                
MFA-TR*         AND   CODE_CRNT_LOC     =  :WS-I                                
MFA-TR*         AND   DATE_DISPOSED_OF  <= :WS-TWO-YEARS-AGO                    
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      **                                                                        
      *                                                                         
           EXEC SQL                                                     
C36856          DECLARE RET-MTR CURSOR WITH HOLD FOR                    
                        SELECT                                          
                              DEVICE_NO,                                
                              SERIAL_NO,                                
                              LOCAL_OFFICE,                             
                              CRNT_LOC_NO,                              
                              CODE_UTIL_TYPE,                           
                              DATE_LAST_MOVE,                           
                              EQUIP_TYPE_CD,                            
T22243                        COMPANY_NO                                
                        FROM  CSS_EQUIPMENT WITH(READUNCOMMITTED)               
                        WHERE CODE_CRNT_LOC     =  :WS-U                
T22243*                 AND   DATE_LAST_MOVE    <= :WS-TWO-YEARS-AGO            
T22243                  AND   DATE_LAST_TRAN    <= 
              IIF(TRY_CONVERT(DATE, :WS-TWO-YEARS-AGO
              ) IS NULL OR (PATINDEX('%.%', :WS-TWO-YEARS-AGO
              ) <> 0) OR (LEN(:WS-TWO-YEARS-AGO) <> 10), CIS.CHAR2DATE(
                                                      :WS-TWO-YEARS-AGO
              ), CONVERT(DATE, :WS-TWO-YEARS-AGO) )    
T35434                  FOR READ ONLY                           
ACT022                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE RET-MTR CURSOR WITH HOLD FOR                            
MFA-TR*                 SELECT                                                  
MFA-TR*                       DEVICE_NO,                                        
MFA-TR*                       SERIAL_NO,                                        
MFA-TR*                       LOCAL_OFFICE,                                     
MFA-TR*                       CRNT_LOC_NO,                                      
MFA-TR*                       CODE_UTIL_TYPE,                                   
MFA-TR*                       DATE_LAST_MOVE,                                   
MFA-TR*                       EQUIP_TYPE_CD,                                    
MFA-TR*                       COMPANY_NO                                        
MFA-TR*                 FROM  CSS_EQUIPMENT                                     
MFA-TR*                 WHERE CODE_CRNT_LOC     =  :WS-U                        
MFA-TR*                 AND   DATE_LAST_MOVE    <= :WS-TWO-YEARS-AGO            
MFA-TR*                 AND   DATE_LAST_TRAN    <= :WS-TWO-YEARS-AGO            
MFA-TR*                 FOR FETCH ONLY WITH UR                                  
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      **                                                                        
      *                                                                         
C36856*    /*SELECTING ONLY METERS WITH AMR (DEVICE_TYPE_CD = 'A')              
C36856*    /*AND INTEGRATED (HOW_ATTACHED_CD = 'I') ATTCHMTS                    
C36856     EXEC SQL                                                     
C36856          DECLARE INT-ERT CURSOR WITH HOLD FOR                    
C36856          SELECT                                                  
C36856                MA.DEVICE_NO,                                     
C36856                MA.CODE_ATT_TYPE                                  
C36856          FROM  CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED),              
C36856                CSS_MTR_ATT_TYPE N5 WITH(READUNCOMMITTED)                 
C36856          WHERE MA.CODE_UTIL_TYPE   = :MA-CODE-UTIL-TYPE          
C36856          AND   MA.COMPANY_NO       = :MA-COMPANY-NO              
C36856          AND   MA.METER_NO         = :MA-METER-NO                
C36856          AND (N5.DEVICE_TYPE_CD  = 'A' AND                       
C36856               MA.HOW_ATTACHED_CD = 'I')                          
C36856          AND   N5.CODE_UTIL_TYPE   = MA.CODE_UTIL_TYPE           
C36856          AND   N5.CODE_ATT_TYPE    = MA.CODE_ATT_TYPE            
C36856          FOR READ ONLY                                   
ACT022                                                      
C36856     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE INT-ERT CURSOR WITH HOLD FOR                            
MFA-TR*         SELECT                                                          
MFA-TR*               MA.DEVICE_NO,                                             
MFA-TR*               MA.CODE_ATT_TYPE                                          
MFA-TR*         FROM  CSS_METER_ATTCHMTS MA,                                    
MFA-TR*               CSS_MTR_ATT_TYPE N5                                       
MFA-TR*         WHERE MA.CODE_UTIL_TYPE   = :MA-CODE-UTIL-TYPE                  
MFA-TR*         AND   MA.COMPANY_NO       = :MA-COMPANY-NO                      
MFA-TR*         AND   MA.METER_NO         = :MA-METER-NO                        
MFA-TR*         AND (N5.DEVICE_TYPE_CD  = 'A' AND                               
MFA-TR*              MA.HOW_ATTACHED_CD = 'I')                                  
MFA-TR*         AND   N5.CODE_UTIL_TYPE   = MA.CODE_UTIL_TYPE                   
MFA-TR*         AND   N5.CODE_ATT_TYPE    = MA.CODE_ATT_TYPE                    
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7480                                                    
MFA-TR*    END-EXEC.                                                            
C36856*                                                                         
C36856*    /*SELECT ONLY THE STAND-A-LONE AMR ATTACHMTS                         
C36856*    /*(DEVICE_TYPE_CD = 'A') THAT ARE NOT INTEGRATED                     
C36856*    /*(DOES NOT EXISTS IN CSS_METER_ATTCHMTS)                            
C36856     EXEC SQL                                                     
C36856          DECLARE NON-INT-ERT CURSOR WITH HOLD FOR                
C36856          SELECT                                                  
C36856                LX.DEVICE_NO,                                     
C36856                LX.CODE_ATT_TYPE,                                 
C36856                LX.EQUIP_LOC_ID,                                  
C36856                LX.CODE_UTIL_TYPE,                                
C36856                LX.COMPANY_NO,                                    
C36856                LX.DATE_LAST_MOVE,                                
C36856                LX.MTR_STORAGE_FAC_CD                             
C36856          FROM  CSS_EQUIP_ATTCHMTS LX WITH(READUNCOMMITTED),              
C36856                CSS_MTR_ATT_TYPE N5 WITH(READUNCOMMITTED)                 
C36856          WHERE LX.CODE_UTIL_TYPE   = :WS-G                       
C36856          AND   LX.DEVICE_NO        > ' '                         
C36856          AND   ((LX.EQUIP_LOC_ID = 'I' AND                       
C36856                   LX.DATE_DISPOSED_OF <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-TWO-YEARS-AGO
              ) IS NULL OR (PATINDEX('%.%', :WS-TWO-YEARS-AGO
              ) <> 0) OR (LEN(:WS-TWO-YEARS-AGO) <> 10), CIS.CHAR2DATE(
                                                      :WS-TWO-YEARS-AGO
              ), CONVERT(DATE, :WS-TWO-YEARS-AGO) )) OR   
C36856                 (LX.EQUIP_LOC_ID = 'U' AND                       
C36856                   LX.DATE_LAST_MOVE <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-TWO-YEARS-AGO
              ) IS NULL OR (PATINDEX('%.%', :WS-TWO-YEARS-AGO
              ) <> 0) OR (LEN(:WS-TWO-YEARS-AGO) <> 10), CIS.CHAR2DATE(
                                                      :WS-TWO-YEARS-AGO
              ), CONVERT(DATE, :WS-TWO-YEARS-AGO) )))      
C36856          AND   N5.CODE_UTIL_TYPE   = LX.CODE_UTIL_TYPE           
C36856          AND   N5.CODE_ATT_TYPE    = LX.CODE_ATT_TYPE            
C36856          AND   N5.DEVICE_TYPE_CD = 'A'                           
C36856          AND   NOT EXISTS                                        
C36856          (SELECT 1                                               
C36856          FROM  CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)               
C36856          WHERE MA.DEVICE_NO      = LX.DEVICE_NO                  
C36856          AND   MA.COMPANY_NO     = LX.COMPANY_NO                 
C36856          AND   MA.CODE_ATT_TYPE  = LX.CODE_ATT_TYPE              
C36856          AND   MA.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE)            
C36856          FOR READ ONLY                                   
ACT022                                                      
C36856     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE NON-INT-ERT CURSOR WITH HOLD FOR                        
MFA-TR*         SELECT                                                          
MFA-TR*               LX.DEVICE_NO,                                             
MFA-TR*               LX.CODE_ATT_TYPE,                                         
MFA-TR*               LX.EQUIP_LOC_ID,                                          
MFA-TR*               LX.CODE_UTIL_TYPE,                                        
MFA-TR*               LX.COMPANY_NO,                                            
MFA-TR*               LX.DATE_LAST_MOVE,                                        
MFA-TR*               LX.MTR_STORAGE_FAC_CD                                     
MFA-TR*         FROM  CSS_EQUIP_ATTCHMTS LX,                                    
MFA-TR*               CSS_MTR_ATT_TYPE N5                                       
MFA-TR*         WHERE LX.CODE_UTIL_TYPE   = :WS-G                               
MFA-TR*         AND   LX.DEVICE_NO        > ' '                                 
MFA-TR*         AND   ((LX.EQUIP_LOC_ID = 'I' AND                               
MFA-TR*                  LX.DATE_DISPOSED_OF <= :WS-TWO-YEARS-AGO) OR           
MFA-TR*                (LX.EQUIP_LOC_ID = 'U' AND                               
MFA-TR*                  LX.DATE_LAST_MOVE <= : WS-TWO-YEARS-AGO))              
MFA-TR*         AND   N5.CODE_UTIL_TYPE   = LX.CODE_UTIL_TYPE                   
MFA-TR*         AND   N5.CODE_ATT_TYPE    = LX.CODE_ATT_TYPE                    
MFA-TR*         AND   N5.DEVICE_TYPE_CD = 'A'                                   
MFA-TR*         AND   NOT EXISTS                                                
MFA-TR*         (SELECT 1                                                       
MFA-TR*         FROM  CSS_METER_ATTCHMTS MA                                     
MFA-TR*         WHERE MA.DEVICE_NO      = LX.DEVICE_NO                          
MFA-TR*         AND   MA.COMPANY_NO     = LX.COMPANY_NO                         
MFA-TR*         AND   MA.CODE_ATT_TYPE  = LX.CODE_ATT_TYPE                      
MFA-TR*         AND   MA.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE)                    
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7970                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                      PIC X(38)    VALUE               
           'WORKING STORAGE FOR PCSMT500 ENDS HERE'.                    
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
           PERFORM 1000-INITIALIZATION THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS        THRU 2000-EXIT.                  
           PERFORM 3000-CLOSE-PROCESS  THRU 3000-EXIT.                  
ACT022     DISPLAY ' WQ WRITTEN ' CNT-WQ-WRITTEN.                       
C36856     STOP RUN.                                                    
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1000-INITIALIZATION                                      **          
      **       PERFORMS INITIALIZATION OF REPORT VARIABLES          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1000-INITIALIZATION.                                             
      *                                                                         
           ACCEPT  WS-RUN-DATE        FROM DATE.                        
      *                                                                         
           PERFORM 1100-DATE-CALC     THRU 1100-EXIT.                   
      *                                                                         
C36856     DISPLAY '     WS-FIVE-YEARS-AGO : ' WS-FIVE-YEARS-AGO        
C36856     DISPLAY '     WS-TWO-YEARS-AGO  : ' WS-TWO-YEARS-AGO         
C36856     DISPLAY '  '                                                 
C36856*                                                                         
C36856     PERFORM 6253-GET-FJC01-CHKP-LIMIT    THRU 6253-EXIT          
C36856                                                                  
C36856     IF WS-CHKP-LUW-LIMIT = WS-FLAG-TO-TURN-OFF-COMMITS           
C36856        AND WS-CHKP-UPD-LIMIT = WS-FLAG-TO-TURN-OFF-COMMITS       
C36856        SET WS-COMMITS-NOT-REQUIRE TO TRUE                        
C36856        DISPLAY ' '                                               
C36856        DISPLAY '**   ' WS-PGRMNAME ' INFORMATIONAL MSG    **'    
C36856        DISPLAY '**   CHKP-LUW AND CHKP-UPD PARMS   **'           
C36856        DISPLAY '** BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS     
C36856                ', INTERPRETED TO  **'                            
C36856        DISPLAY '**  INDICATE THAT INTERIM COMMIT   **'           
C36856        DISPLAY '**   POINTS SHOULD NOT BE TAKEN.   **'           
C36856     END-IF                                                       
C36856                                                                  
           PERFORM 1200-OPEN-FILE     THRU 1200-EXIT.                   
      *                                                                         
           PERFORM 1300-OPEN-CURSORS  THRU 1300-EXIT.                   
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1100-DATE-CALC                                           **          
      **       TO CALCULATE DATES                                   **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1100-DATE-CALC.                                                  
      *                                                                         
           PERFORM 1110-FIVE-YEARS-AGO     THRU 1110-EXIT.              
      *                                                                         
           PERFORM 1120-TWO-YEARS-AGO      THRU 1120-EXIT.              
      *                                                                         
           PERFORM 1130-ADD-THIRTY-CURDATE THRU 1130-EXIT.              
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1110-FIVE-YEARS-AGO                                      **          
      **       TO GET A DATE FIVE YEARS BEFORE                      **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1110-FIVE-YEARS-AGO.                                             
      *                                                                         
           EXEC SQL                                                     
T35434         SELECT
              DATEADD( YEAR, -5, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-FIVE-YEARS-AGO       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-FIVE-YEARS-AGO = (CURRENT DATE  - 5 YEARS)               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
T35434         DISPLAY '** SET ERROR IN 1110-FIVE-YEARS-AGO **'         
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED       **'        
               PERFORM 9900-ABEND        THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
       1110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1120-TWO-YEARS-AGO                                       **          
      **       TO GET A DATE TWO YEARS BEFORE                       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1120-TWO-YEARS-AGO.                                              
      *                                                                         
           EXEC SQL                                                     
T35434         SELECT
              DATEADD( YEAR, -2, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-TWO-YEARS-AGO        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-TWO-YEARS-AGO = (CURRENT DATE  - 2 YEARS)                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
T35434         DISPLAY '** SET ERROR IN 1120-TWO-YEARS-AGO **'          
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED       **'        
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       1120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1130-ADD-THIRTY-CURDATE.                                 **          
      **       TO GET A DATE 30 DAYS FROM CURRENT DATE              **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1130-ADD-THIRTY-CURDATE.                                         
      *                                                                         
           EXEC SQL                                                     
A04860         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), (DATEADD( DAY, 30, 
           CIS.CURRENT$TIMESTAMP() )), 121), ' ', '-'), ':', '.'),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CUR-DATE,
              :WS-DATE-CREATED                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CUR-DATE     = (CURRENT TIMESTAMP + 30 DAYS)             
MFA-TR*           ,:WS-DATE-CREATED = CURRENT TIMESTAMP                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
T35434         DISPLAY '** SET ERROR IN 1130-ADD-THIRTY-CURDATE**'      
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED       **'        
               PERFORM 9900-ABEND        THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
       1130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1200-OPEN-FILE                                           **          
      **       THIS PROCESS OPENS ALL THE FILES.                    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1200-OPEN-FILE.                                                  
      *                                                                         
           OPEN OUTPUT FCSMT51                                          
                       FCSMT52.                                         
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1300-OPEN-CURSORS.                                       **          
      **       THIS PROCESS OPENS ALL THE CURSORS.                  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1300-OPEN-CURSORS.                                               
      *                                                                         
           PERFORM 7100-OPEN-DIS-MTR       THRU 7100-EXIT.              
      *                                                                         
           PERFORM 7200-OPEN-TRAN-EQP      THRU 7200-EXIT.              
      *                                                                         
           PERFORM 7300-OPEN-GAS-EQP       THRU 7300-EXIT.              
      *                                                                         
           PERFORM 7400-OPEN-RET-MTR       THRU 7400-EXIT.              
      *                                                                         
C36856     PERFORM 7970-OPEN-NON-INT       THRU 7970-EXIT.              
C36856*                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2000-PROCESS.                                            **          
      **       THIS PROCESS FETCHES DETAILS FROM THE TABLES.        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2000-PROCESS.                                                    
      *                                                                         
           SET E-FMT52-ELECTRIC-METER    TO TRUE.                       
           SET E-FMT52-DEVICE-DELETED    TO TRUE.                       
C36856*                                                                         
C36856     DISPLAY '       PROCESSING ELECTRIC METERS.....'             
C36856     DISPLAY '       '                                            
      *                                                                         
           PERFORM 2100-DIS-MTR-PROC     THRU 2100-EXIT                 
                                 UNTIL WS-DIS-MTR-FLAG = WS-Y.          
      *                                                                         
           INITIALIZE       DCLCSS-EQUIPMENT.                           
      *                                                                         
           SET E-FMT52-INSTR-XFORMER     TO TRUE.                       
           SET E-FMT52-DEVICE-DELETED    TO TRUE.                       
C36856*                                                                         
C36856     DISPLAY '       '                                            
C36856     DISPLAY '       PROCESSING TRANSFORMERS.....'                
C36856     DISPLAY '       '                                            
      *                                                                         
           PERFORM 2200-TRAN-EQP-PROC    THRU 2200-EXIT                 
      *                                                                         
                                 UNTIL WS-TRAN-EQP-FLAG = WS-Y.         
      *                                                                         
           INITIALIZE       DCLCSS-EQUIPMENT.                           
      *                                                                         
           SET E-FMT51-DEVICE-DELETED    TO TRUE.                       
C36856*                                                                         
C36856     DISPLAY '       '                                            
C36856     DISPLAY '       PROCESSING GAS METERS.....'                  
C36856     DISPLAY '       '                                            
      *                                                                         
           PERFORM 2300-GAS-EQP-PROC     THRU 2300-EXIT                 
                                 UNTIL WS-GAS-EQP-FLAG = WS-Y.          
      *                                                                         
           INITIALIZE       DCLCSS-EQUIPMENT                            
                            DCLCSS-METER-ATTCHMTS.                      
      *                                                                         
           SET E-FMT52-DEVICE-RETIRED    TO TRUE.                       
           SET E-FMT51-DEVICE-RETIRED    TO TRUE.                       
C36856*                                                                         
C36856     DISPLAY '       '                                            
C36856     DISPLAY '       PROCESSING RETIRING METERS.....'             
C36856     DISPLAY '       '                                            
      *                                                                         
           PERFORM 2400-RET-MTR-PROC     THRU 2400-EXIT                 
                                 UNTIL WS-RET-MTR-FLAG = WS-Y.          
      *                                                                         
C36856     DISPLAY '       '                                            
C36856     DISPLAY '       PROCESSING NON-INT ERT.....'                 
C36856     DISPLAY '       '                                            
C36856     PERFORM 2600-NON-INT-ERTS     THRU 2600-EXIT                 
C36856                           UNTIL WS-NON-INT-ERT-FLAG = WS-Y.      
C36856*                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2100-DIS-MTR-PROC.                                       **          
      **       THIS PROCESS FETCHES DETAILS FROM THE CSS_EQUIPMENT  **          
      **          TABLE  USING THE DIS-MTR CURSOR                   **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2100-DIS-MTR-PROC.                                               
      *                                                                         
           MOVE  SPACES TO    E-FMT52-ELEC-MTR-CLASS                    
                              E-FMT52-SPEC-CODE                         
                              E-FMT52-SPEC-DESC.                        
      *                                                                         
           PERFORM 7110-FETCH-DIS-MTR     THRU  7110-EXIT.              
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T35249         MOVE 'E' TO EQ-CODE-UTIL-TYPE                            
T35249         PERFORM 2500-CHK-IF-MTR-INSTALL THRU 2500-EXIT           
T35249         IF WS-DATA-IND EQUAL 'Y'                                 
T35249            GO TO 2100-EXIT                                       
T35249         END-IF                                                   
               PERFORM 2110-CHK-MTR-ATT   THRU  2110-EXIT               
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2110-CHK-MTR-ATT.                                        **          
      **       THIS PROCESS FETCHES DETAILS FROM APPROPRIATE        **          
      **          TABLE  AND WRITES A REPORT                        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2110-CHK-MTR-ATT.                                                
      *                                                                         
           MOVE EQ-DEVICE-NO                  TO MA-METER-NO.           
T22243     MOVE EQ-COMPANY-NO                 TO MA-COMPANY-NO.         
C36856     MOVE EQ-CODE-UTIL-TYPE             TO MA-CODE-UTIL-TYPE.     
TCR533     MOVE ZEROS                         TO WS-NO-OF-ATTCH         
T35249     MOVE ZEROS                         TO WS-ACCOUNT.            
T35249     MOVE ZEROS                         TO WS-CUSTOMER.           
T35249     MOVE ZEROS                         TO WS-PREMISE.            
T35249     MOVE SPACES                        TO WS-OFFICE.             
T35249*                                                                         
           PERFORM 7120-SEL-MTR-ATT           THRU 7120-EXIT.           
      *                                                                         
PCR533     IF  WS-NO-OF-ATTCH > 0                                       
C36856         DISPLAY '*** FOUND RETRO-FIT/HARDWIRED ATTACHMENT FOR : '
C36856         EQ-DEVICE-NO ' ATTCH - ' WS-NO-OF-ATTCH                  
               MOVE    WS-WORK-QUEUE-COMMENT1   TO WS-WQ-MESSAGE        
               PERFORM 4500-CREATE-WORK-QUEUE   THRU 4500-EXIT          
           ELSE                                                         
C36856         DISPLAY '*** DELETING RETIRED ELEC METER ' EQ-DEVICE-NO  
               MOVE   WS-E  TO                  EQ-CODE-UTIL-TYPE       
               PERFORM 4100-WRITE-ELE-MTR-REC   THRU 4100-EXIT          
               PERFORM 7800-DELETE-TABLES       THRU 7800-EXIT          
           END-IF.                                                      
      *                                                                         
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2200-TRAN-EQP-PROC.                                      **          
      **       THIS PROCESS FETCHES DETAILS FROM THE CSS_EQUIPMENT  **          
      **           TABLE USING THE TRAN-EQP CURSOR                  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2200-TRAN-EQP-PROC.                                              
      *                                                                         
           MOVE  SPACES TO    E-FMT52-ELEC-MTR-CLASS                    
                              E-FMT52-SPEC-CODE                         
                              E-FMT52-SPEC-DESC.                        
      *                                                                         
           PERFORM 7210-FETCH-TRAN-EQP        THRU 7210-EXIT.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE    WS-X                   TO   EQ-CODE-UTIL-TYPE    
               PERFORM 4200-TRAN-EQP-REC      THRU 4200-EXIT            
C36856         DISPLAY '*** DELETING RETIRED TRANSFORMER ' EQ-DEVICE-NO 
               PERFORM 7800-DELETE-TABLES     THRU 7800-EXIT            
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2300-GAS-EQP-PROC.                                       **          
      **       THIS PROCESS FETCHES DETAILS FROM THE CSS_EQUIPMENT  **          
      **           TABLE USING THE GAS-EQP CURSOR                   **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2300-GAS-EQP-PROC.                                               
      *                                                                         
           MOVE SPACES TO    E-FMT51-METER-SIZE-ID                      
                             E-FMT51-METER-SIZE-DESC.                   
C36856     MOVE ZEROS   TO   WS-NO-OF-ATTCH                             
      *                                                                         
           PERFORM 7310-FETCH-GAS-EQP       THRU 7310-EXIT.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE    WS-G TO                EQ-CODE-UTIL-TYPE         
T35249         PERFORM 2500-CHK-IF-MTR-INSTALL THRU  2500-EXIT          
T35249         IF WS-DATA-IND EQUAL 'Y'                                 
T35249            GO TO 2300-EXIT                                       
T35249         END-IF                                                   
C36856*                                                                         
C36856         MOVE EQ-DEVICE-NO      TO MA-METER-NO                    
C36856         MOVE EQ-COMPANY-NO     TO MA-COMPANY-NO                  
C36856         MOVE EQ-CODE-UTIL-TYPE TO MA-CODE-UTIL-TYPE              
ACT022         MOVE ZEROS                         TO WS-ACCOUNT         
ACT022         MOVE ZEROS                         TO WS-CUSTOMER        
ACT022         MOVE ZEROS                         TO WS-PREMISE         
ACT022         MOVE SPACES                        TO WS-OFFICE          
C36856         PERFORM 7120-SEL-MTR-ATT THRU 7120-EXIT                  
C36856*                                                                         
C36856         IF  WS-NO-OF-ATTCH > 0                                   
C36856             DISPLAY '*** ATTACHMENT FOUND FOR GAS METER : '      
C36856             EQ-DEVICE-NO ' ATTCH - ' WS-NO-OF-ATTCH              
C36856             MOVE   EQ-DEVICE-NO  TO                              
C36856                      WS-WQ-METER-NO OF WS-WORK-QUEUE-COMMENT5    
ACT022             MOVE 526 TO WS-CATEGORY-ID                           
ACT022             MOVE '5' TO WS-ROUTING-CATEGORY                      
C36856             MOVE    WS-WORK-QUEUE-COMMENT5   TO WS-WQ-MESSAGE    
C36856             PERFORM 4500-CREATE-WORK-QUEUE   THRU 4500-EXIT      
C36856         ELSE                                                     
C36856            DISPLAY '*** DELETING RETIRED GAS METER ' EQ-DEVICE-NO
                   PERFORM 4300-GAS-EQP-REC       THRU 4300-EXIT        
                   PERFORM 7800-DELETE-TABLES     THRU 7800-EXIT        
           END-IF
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2400-RET-MTR-PROC.                                       **          
      **       THIS PROCESS FETCHES DETAILS FROM THE CSS_EQUIPMENT  **          
      **           TABLE USING THE RET-MTR CURSOR                   **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2400-RET-MTR-PROC.                                               
      *                                                                         
           MOVE  SPACES TO    E-FMT52-ELEC-MTR-CLASS                    
                              E-FMT52-SPEC-CODE                         
                              E-FMT52-SPEC-DESC                         
                              E-FMT51-METER-SIZE-ID                     
                              E-FMT51-METER-SIZE-DESC.                  
      *                                                                         
           PERFORM 7410-FETCH-RET-MTR       THRU 7410-EXIT.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T35249         PERFORM 2500-CHK-IF-MTR-INSTALL THRU  2500-EXIT          
T35249         IF WS-DATA-IND EQUAL 'Y'                                 
T35249             GO TO 2400-EXIT                                      
T35249         END-IF                                                   
C36856         IF EQ-CODE-UTIL-TYPE = WS-E OR EQ-CODE-UTIL-TYPE = WS-G  
                   PERFORM 2410-SEL-MTR-ATT  THRU 2410-EXIT             
               ELSE                                                     
C36856             SET E-FMT52-DEVICE-RETIRED  TO TRUE                  
C36856         DISPLAY '*** RETIRING TRANSFORMER ' EQ-DEVICE-NO         
C36856             PERFORM 4430-RET-TRN-REC    THRU  4430-EXIT          
C36856             PERFORM 7420-RETIRE-RET-MTR THRU 7420-EXIT           
C36856         END-IF                                                   
C36856     END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2410-SEL-MTR-ATT.                                        **          
      **       THIS PROCESS FETCHES DETAILS FROM THE                **          
      **           CSS_METER_ATTCHMTS TABLE                         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2410-SEL-MTR-ATT.                                                
      *                                                                         
           MOVE EQ-DEVICE-NO            TO MA-METER-NO.                 
C36856     MOVE EQ-CODE-UTIL-TYPE       TO MA-CODE-UTIL-TYPE            
C36856     MOVE EQ-COMPANY-NO           TO MA-COMPANY-NO.               
PCR533     MOVE ZEROS                   TO WS-NO-OF-ATTCH               
T35249     MOVE ZEROS                   TO WS-ACCOUNT.                  
T35249     MOVE ZEROS                   TO WS-CUSTOMER.                 
T35249     MOVE ZEROS                   TO WS-PREMISE.                  
T35249     MOVE SPACES                  TO WS-OFFICE.                   
T35249*                                                                         
           PERFORM 7120-SEL-MTR-ATT     THRU 7120-EXIT.                 
      *                                                                         
PCR533     IF  WS-NO-OF-ATTCH > 0                                       
C36856         DISPLAY '*** UNREMOVABLE ATTACHMENT FOUND FOR METER : '  
C36856         EQ-DEVICE-NO ' ' EQ-CODE-UTIL-TYPE ' ' WS-NO-OF-ATTCH    
               MOVE WS-WORK-QUEUE-COMMENT2      TO   WS-WQ-MESSAGE      
               PERFORM 4500-CREATE-WORK-QUEUE   THRU 4500-EXIT          
           ELSE                                                         
C36856         DISPLAY '*** RETIRING METER : ' EQ-DEVICE-NO             
C36856          '  '  EQ-CODE-UTIL-TYPE  ' ' EQ-COMPANY-NO              
PCR533         PERFORM 4400-RETIRE-REC      THRU 4400-EXIT              
C36856         MOVE WS-N TO WS-INT-ERT-FLAG                             
C36856         PERFORM 7480-OPEN-INT-ERT    THRU 7480-EXIT              
C36856         PERFORM 7485-FETCH-INT-ERT   THRU 7485-EXIT              
C36856         PERFORM UNTIL WS-INT-ERT-FLAG = 'Y'                      
C36856              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
C36856                 MOVE MA-CODE-ATT-TYPE  TO MP-CODE-ATT-TYPE       
C36856                 MOVE MA-CODE-UTIL-TYPE TO MP-CODE-UTIL-TYPE      
C36856                                           LX-CODE-UTIL-TYPE      
C36856                 MOVE EQ-COMPANY-NO     TO MP-COMPANY-NO          
C36856                                           LX-COMPANY-NO          
C36856                 MOVE MA-DEVICE-NO      TO MP-DEVICE-NO           
C36856                                           LX-DEVICE-NO           
C36856                 MOVE WS-I              TO LX-EQUIP-LOC-ID        
C36856                                           MP-EQUIP-LOC-ID        
C36856                 MOVE MA-METER-NO       TO MP-METER-NO            
C36856                 MOVE LX-MTR-STORAGE-FAC-CD                       
C36856                            TO MP-MTR-STORAGE-FAC-CD              
C36856                 DISPLAY '*** RETIRING INT ERT : ' LX-DEVICE-NO   
C36856                 PERFORM 7460-ATTCH-MOVE-HIST THRU 7460-EXIT      
C36856                 PERFORM 7470-UPDATE-ATTCHMTS THRU 7470-EXIT      
C36856              END-IF                                              
C36856              PERFORM 7485-FETCH-INT-ERT   THRU 7485-EXIT         
C36856         END-PERFORM                                              
C36856         PERFORM 7490-CLOSE-INT-ERT   THRU 7490-EXIT              
C36856         PERFORM 7420-RETIRE-RET-MTR  THRU 7420-EXIT              
           END-IF.                                                      
      *                                                                         
       2410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T35249****************************************************************          
T35249**                                                            **          
T35249**   2500-CHK-IF-MTR-INSTALL                                  **          
T35249**       GENERATE WQ INSTEAD OF REPORT                        **          
T35249**                                                            **          
T35249****************************************************************          
T35249*                                                                         
T35249 2500-CHK-IF-MTR-INSTALL.                                         
T35249*                                                                         
T35249     MOVE 'N'        TO WS-DATA-IND.                              
T35249     MOVE EQ-CODE-UTIL-TYPE          TO MN-CODE-UTIL-TYPE.        
T35249     MOVE EQ-COMPANY-NO              TO AT-COMPANY-NO.            
T35249     MOVE EQ-DEVICE-NO               TO MN-METER-NO.              
T35249*                                                                         
T35249     PERFORM 7960-METER-ERR      THRU  7960-EXIT.                 
T35249     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T35249         MOVE AT-ACCOUNT-NO          TO WS-ACCOUNT                
T35249                                        WS-WQ-ACCT-ELC            
T35249                                        WS-WQ-ACCT-GAS            
T35249         MOVE AT-CUSTOMER-NO         TO WS-CUSTOMER               
T35249         MOVE AT-PREMISE-NO          TO WS-PREMISE                
T35249         MOVE AT-LOCAL-OFFICE        TO WS-OFFICE                 
T35249         MOVE 'Y'                    TO WS-DATA-IND               
T35249         IF EQ-CODE-UTIL-TYPE EQUAL WS-E                          
T35249             MOVE EQ-DEVICE-NO           TO WS-WQ-METR-ELC        
A03352             MOVE 528                    TO WS-CATEGORY-ID        
ACT022             MOVE '4'                    TO WS-ROUTING-CATEGORY   
T35249             MOVE WS-WORK-QUEUE-COMMENT3 TO WS-WQ-MESSAGE         
T35249         ELSE                                                     
T35249             IF EQ-CODE-UTIL-TYPE EQUAL WS-G                      
T35249                MOVE EQ-DEVICE-NO        TO WS-WQ-METR-GAS        
ACT022                IF EQ-COMPANY-NO = '01'                           
ACT022                    MOVE 526 TO WS-CATEGORY-ID                    
ACT022                    MOVE '5' TO WS-ROUTING-CATEGORY               
ACT022                ELSE                                              
ACT022                    MOVE 527               TO WS-CATEGORY-ID      
ACT022                    MOVE '1'               TO WS-ROUTING-CATEGORY 
ACT022                END-IF                                            
T35249                MOVE WS-WORK-QUEUE-COMMENT4 TO WS-WQ-MESSAGE      
T35249             END-IF                                               
T35249         END-IF                                                   
C36856*                                                                         
C36856         DISPLAY ' *** METER IS ATTACHED TO AN ACTIVE ACCOUNT '   
C36856            EQ-DEVICE-NO ' ' EQ-CODE-UTIL-TYPE ' ' EQ-COMPANY-NO  
C36856*                                                                         
T35249         PERFORM 4500-CREATE-WORK-QUEUE THRU 4500-EXIT            
T35249     END-IF.                                                      
T35249*                                                                         
T35249 2500-EXIT.                                                       
T35249     EXIT.                                                        
C36856*                                                                         
C36856****************************************************************          
C36856**                                                            **          
C36856**   2600-NON-INT-ERTS                                        **          
C36856**     FETCHES DETAILS FROM THE CSS_EQUIP_ATTCHMTS TABLE      **          
C36856**           USING THE NON-INT-ERT CURSOR                     **          
C36856**                                                            **          
C36856****************************************************************          
C36856*                                                                         
C36856 2600-NON-INT-ERTS.                                               
C36856*                                                                         
C36856     MOVE WS-G TO LX-CODE-UTIL-TYPE.                              
C36856     PERFORM 7980-FETCH-NON-INT         THRU 7980-EXIT.           
C36856*                                                                         
C36856     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C36856        IF LX-EQUIP-LOC-ID = WS-I                                 
C36856           DISPLAY '*** DELETING NON INT ERT : ' LX-DEVICE-NO     
C36856           PERFORM 7865-DEL-EQP-ATT      THRU 7865-EXIT           
C36856        ELSE                                                      
C36856           IF LX-EQUIP-LOC-ID = WS-U                              
C36856              MOVE LX-CODE-ATT-TYPE  TO MP-CODE-ATT-TYPE          
C36856              MOVE LX-CODE-UTIL-TYPE TO MP-CODE-UTIL-TYPE         
C36856              MOVE LX-COMPANY-NO     TO MP-COMPANY-NO             
C36856              MOVE LX-DATE-LAST-MOVE TO MP-DATE-MOVE              
C36856              MOVE LX-DEVICE-NO      TO MP-DEVICE-NO              
C36856              MOVE LX-EQUIP-LOC-ID   TO MP-EQUIP-LOC-ID           
C36856              MOVE WS-I              TO LX-EQUIP-LOC-ID           
C36856              MOVE SPACES            TO MP-METER-NO               
C36856              MOVE LX-MTR-STORAGE-FAC-CD                          
C36856                             TO MP-MTR-STORAGE-FAC-CD             
C36856              DISPLAY '*** RETIRING NON INT ERT : ' LX-DEVICE-NO  
C36856              PERFORM 7460-ATTCH-MOVE-HIST  THRU 7460-EXIT        
C36856              PERFORM 7470-UPDATE-ATTCHMTS  THRU 7470-EXIT        
C36856           END-IF                                                 
C36856        END-IF                                                    
C36856     END-IF.                                                      
C36856*                                                                         
C36856 2600-EXIT.                                                       
C36856     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   3000-CLOSE-PROCESS.                                      **          
      **       TO CLOSE THE OPEN CURSORS AND FILES                  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       3000-CLOSE-PROCESS.                                              
      *                                                                         
           PERFORM    3100-CLOSE-CURSOR     THRU 3100-EXIT.             
      *                                                                         
           PERFORM    3200-CLOSE-FILES      THRU 3200-EXIT.             
      *                                                                         
C36856*                                                                         
C36856     DISPLAY '       '                                            
C36856     DISPLAY '        ***   END OF PROGRAM PCSMT500   ***'        
C36856     .                                                            
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   3100-CLOSE-CURSOR.                                       **          
      **       TO CLOSE THE OPEN CURSOR                             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       3100-CLOSE-CURSOR.                                               
      *                                                                         
           PERFORM  7130-CLOSE-ELEC-MTR     THRU 7130-EXIT.             
      *                                                                         
           PERFORM  7220-CLOSE-TRAN-EQP     THRU 7220-EXIT.             
      *                                                                         
           PERFORM  7320-CLOSE-GAS-MTR      THRU 7320-EXIT.             
      *                                                                         
           PERFORM  7450-CLOSE-RET-MTR      THRU 7450-EXIT.             
      *                                                                         
C36856     PERFORM  7990-CLOSE-NON-INT      THRU 7990-EXIT.             
C36856*                                                                         
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   3200-CLOSE-FILES.                                        **          
      **       TO CLOSE THE OPEN FILES                              **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       3200-CLOSE-FILES.                                                
      *                                                                         
           CLOSE FCSMT51                                                
                 FCSMT52.                                               
      *                                                                         
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   4100-WRITE-ELE-MTR-REC.                                  **          
      **       TO WRITE THE DELETED ELECTRIC METERS TO A FILE       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       4100-WRITE-ELE-MTR-REC.                                          
      *                                                                         
           MOVE SPACES                 TO    E-FMT52-SPEC-DESC          
                                             E-FMT52-ELEC-MTR-CLASS     
                                             E-FMT52-SPEC-CODE.         
           MOVE  EQ-DEVICE-NO          TO    EM-METER-NO.               
           MOVE  EQ-CODE-UTIL-TYPE     TO    EM-CODE-UTIL-TYPE.         
T22243     MOVE  EQ-COMPANY-NO         TO    EM-COMPANY-NO.             
           PERFORM 7500-ELEC-MTR-DET   THRU  7500-EXIT.                 
           MOVE EM-ELEC-MTR-SPEC-CD    TO    U5-ELEC-MTR-SPEC-CD.       
           PERFORM 7510-ELEC-MTR-DESC  THRU  7510-EXIT.                 
           SET E-FMT52-ELECTRIC-METER TO     TRUE.                      
           SET E-FMT52-DEVICE-DELETED TO     TRUE.                      
T22243     MOVE  EM-COMPANY-NO         TO    E-FMT52-COMPANY-NO.        
           MOVE  EM-METER-NO           TO    E-FMT52-DEVICE-NO.         
           MOVE  EM-ELEC-MTR-CLASS-CD  TO    E-FMT52-ELEC-MTR-CLASS.    
           MOVE  EM-ELEC-MTR-SPEC-CD   TO    E-FMT52-SPEC-CODE.         
           MOVE  U5-ELEC-MTR-SPEC-DESC TO    E-FMT52-SPEC-DESC.         
      *                                                                         
           WRITE FIOMT52.                                               
      *                                                                         
       4100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   4200-TRAN-EQP-REC.                                       **          
      **       TO WRITE THE DELETED TRANSFORMERS TO A FILE          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       4200-TRAN-EQP-REC.                                               
      *                                                                         
           MOVE  SPACES                TO   E-FMT52-ELEC-MTR-CLASS      
                                            E-FMT52-SPEC-CODE           
                                            E-FMT52-SPEC-DESC.          
           SET E-FMT52-INSTR-XFORMER   TO   TRUE.                       
           SET E-FMT52-DEVICE-DELETED  TO   TRUE.                       
           MOVE  EQ-DEVICE-NO          TO   IX-XFORMER-NO.              
           MOVE  EQ-CODE-UTIL-TYPE     TO   IX-CODE-UTIL-TYPE.          
T22243     MOVE  EQ-COMPANY-NO         TO   IX-COMPANY-NO.              
C36856     PERFORM 7620-TRAN-EQP-DET   THRU 7620-EXIT.                  
           MOVE IX-XFORMER-SPEC-CD     TO   XS-XFORMER-SPEC-CD.         
C36856     PERFORM 7630-TRAN-EQP-DESC  THRU 7630-EXIT.                  
           MOVE  IX-XFORMER-NO         TO   E-FMT52-DEVICE-NO.          
T22243     MOVE  IX-COMPANY-NO         TO   E-FMT52-COMPANY-NO.         
           MOVE  IX-XFORMER-SPEC-CD    TO   E-FMT52-SPEC-CODE.          
           MOVE  XS-XFORMER-SPEC-DESC  TO   E-FMT52-SPEC-DESC.          
      *                                                                         
           WRITE FIOMT52.                                               
      *                                                                         
       4200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   4300-GAS-EQP-REC.                                        **          
      **       TO WRITE THE DELETED GAS METERS TO A FILE            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       4300-GAS-EQP-REC.                                                
      *                                                                         
           MOVE  SPACES               TO   E-FMT51-METER-SIZE-ID        
PCR533                                     E-FMT51-METER-SIZE-DESC      
PCR533                                     E-FMT51-DEVICE-NO            
PCR533                                     E-FMT51-SERIAL-NUMBER        
PCR533                                     E-FMT51-LOCAL-OFFICE         
PCR533                                     E-FMT51-ADDR-STREET          
PCR533                                     E-FMT51-CITY-ZIP             
PCR533                                     E-FMT51-INSTALL-DT           
PCR533                                     E-FMT51-REMOVE-DT            
PCR533                                     E-FMT51-PREV-LOC-CODE.       
PCR533     MOVE ZEROES                TO   E-FMT51-PREV-LOC-NO.         
           MOVE  EQ-DEVICE-NO         TO   GM-METER-NO.                 
           MOVE  EQ-CODE-UTIL-TYPE    TO   GM-CODE-UTIL-TYPE.           
T22243     MOVE  EQ-COMPANY-NO        TO   GM-COMPANY-NO                
C23811                                     M5-COMPANY-NO.               
           PERFORM 7700-GAS-EQP-DET   THRU 7700-EXIT.                   
           MOVE GM-METER-SIZE-ID      TO   M5-METER-SIZE-ID.            
           PERFORM 7710-GAS-EQP-DESC  THRU 7710-EXIT.                   
           SET E-FMT51-DEVICE-DELETED      TO TRUE.                     
           MOVE  GM-METER-NO          TO   E-FMT51-DEVICE-NO.           
           MOVE  GM-METER-SIZE-ID     TO   E-FMT51-METER-SIZE-ID.       
T22243     MOVE  GM-COMPANY-NO        TO   E-FMT51-COMPANY-NO.          
           MOVE  M5-METER-SIZE-DESC   TO   E-FMT51-METER-SIZE-DESC.     
                                                                        
      *                                                                         
           MOVE  EQ-SERIAL-NO         TO   E-FMT51-SERIAL-NUMBER.       
      *                                                                         
           WRITE FIOMT51.                                               
      *                                                                         
       4300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   4400-RETIRE-REC.                                         **          
      **       TO WRITE RETIRED DEVICES  IN A FILE                  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       4400-RETIRE-REC.                                                 
      *                                                                         
           SET E-FMT52-DEVICE-RETIRED    TO TRUE.                       
           SET E-FMT51-DEVICE-RETIRED    TO TRUE.                       
      *                                                                         
           IF EQ-CODE-UTIL-TYPE = WS-E                                  
               PERFORM 4410-RET-ELE-REC    THRU  4410-EXIT              
           ELSE                                                         
               PERFORM 4420-RET-GAS-REC    THRU  4420-EXIT              
           END-IF.                                                      
      *                                                                         
       4400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   4410-RET-ELE-REC.                                        **          
      **       TO WRITE THE RETIRED ELECTRIC METERS TO A FILE       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       4410-RET-ELE-REC.                                                
      *                                                                         
           MOVE  SPACES                TO    E-FMT52-ELEC-MTR-CLASS     
                                             E-FMT52-SPEC-CODE          
                                             E-FMT52-SPEC-DESC.         
           MOVE  EQ-DEVICE-NO          TO    EM-METER-NO.               
           MOVE  EQ-CODE-UTIL-TYPE     TO    EM-CODE-UTIL-TYPE.         
T22243     MOVE  EQ-COMPANY-NO         TO    EM-COMPANY-NO.             
           PERFORM 7500-ELEC-MTR-DET   THRU  7500-EXIT.                 
           MOVE EM-ELEC-MTR-SPEC-CD    TO    U5-ELEC-MTR-SPEC-CD.       
           PERFORM 7510-ELEC-MTR-DESC  THRU  7510-EXIT.                 
           SET E-FMT52-ELECTRIC-METER TO     TRUE.                      
           MOVE  EM-METER-NO           TO    E-FMT52-DEVICE-NO.         
T22243     MOVE  EM-COMPANY-NO         TO    E-FMT52-COMPANY-NO.        
           MOVE  EM-ELEC-MTR-CLASS-CD  TO    E-FMT52-ELEC-MTR-CLASS.    
           MOVE  EM-ELEC-MTR-SPEC-CD   TO    E-FMT52-SPEC-CODE.         
           MOVE  U5-ELEC-MTR-SPEC-DESC TO    E-FMT52-SPEC-DESC.         
      *                                                                         
           WRITE FIOMT52.                                               
      *                                                                         
       4410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   4420-RET-GAS-REC.                                        **          
      **       TO WRITE THE RETIRED GAS METERS TO A FILE            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       4420-RET-GAS-REC.                                                
      *                                                                         
           MOVE  SPACES                 TO   E-FMT51-METER-SIZE-ID      
PCR533                                       E-FMT51-METER-SIZE-DESC    
PCR533                                       E-FMT51-DEVICE-NO          
PCR533                                       E-FMT51-SERIAL-NUMBER      
PCR533                                       E-FMT51-LOCAL-OFFICE       
PCR533                                       E-FMT51-ADDR-STREET        
PCR533                                       E-FMT51-CITY-ZIP           
PCR533                                       E-FMT51-INSTALL-DT         
PCR533                                       E-FMT51-REMOVE-DT          
PCR533                                       E-FMT51-PREV-LOC-CODE      
PCR533                                       MV-CODE-CRNT-LOC.          
PCR533     MOVE ZEROES                  TO   E-FMT51-PREV-LOC-NO.       
           MOVE  EQ-DEVICE-NO           TO   GM-METER-NO.               
           MOVE  EQ-CODE-UTIL-TYPE      TO   GM-CODE-UTIL-TYPE.         
T22243     MOVE  EQ-COMPANY-NO          TO   GM-COMPANY-NO.             
           PERFORM 7700-GAS-EQP-DET     THRU 7700-EXIT.                 
           MOVE GM-METER-SIZE-ID        TO   M5-METER-SIZE-ID.          
           PERFORM 7710-GAS-EQP-DESC    THRU 7710-EXIT.                 
           MOVE    GM-METER-NO          TO    E-FMT51-DEVICE-NO.        
T22243     MOVE    GM-COMPANY-NO        TO    E-FMT51-COMPANY-NO.       
           MOVE    GM-METER-SIZE-ID     TO    E-FMT51-METER-SIZE-ID.    
           MOVE    M5-METER-SIZE-DESC   TO    E-FMT51-METER-SIZE-DESC.  
      *                                                                         
           MOVE    EQ-SERIAL-NO         TO    E-FMT51-SERIAL-NUMBER.    
PCR533*                                                                         
           MOVE    WS-G                 TO    MV-CODE-UTIL-TYPE.        
           MOVE    EQ-DEVICE-NO         TO    MV-DEVICE-NO.             
T22243     MOVE    EQ-COMPANY-NO        TO    MV-COMPANY-NO.            
           MOVE    WS-N                 TO    WS-MOVE-HIST-FLAG.        
           SET     NON-U-REC-NOT-FOUND  TO    TRUE.                     
PCR533     SET FIRST-MOVE-HIST-NOT-FOUND TO TRUE.                       
           PERFORM 7900-OPEN-MOV-HIST   THRU 7900-EXIT.                 
           PERFORM UNTIL WS-MOVE-HIST-FLAG = WS-Y OR                    
                         NON-U-REC-FOUND                                
               PERFORM  7910-FETCH-MOV-HIST THRU 7910-EXIT              
               IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
PCR533             IF  FIRST-MOVE-HIST-NOT-FOUND                        
PCR533                 SET FIRST-MOVE-HIST-FOUND   TO    TRUE           
PCR533                 MOVE    MV-CODE-CRNT-LOC    TO                   
PCR533                                         E-FMT51-PREV-LOC-CODE    
PCR533                 IF  MV-CODE-CRNT-LOC = WS-X                      
PCR533                     MOVE MV-LOC-NO        TO  E-FMT51-PREV-LOC-NO
PCR533                END-IF                                            
PCR533             END-IF                                               
PCR533             IF  MV-CODE-CRNT-LOC EQUAL WS-J                      
                       SET NON-U-REC-FOUND TO TRUE                      
                   END-IF                                               
               END-IF                                                   
           END-PERFORM                                                  
           PERFORM 7920-CLOSE-MOV-HIST  THRU 7920-EXIT.                 
      *                                                                         
           IF  NON-U-REC-FOUND                                          
PCR533         PERFORM  4421-GET-ADDR THRU 4421-EXIT                    
PCR533         PERFORM  4422-GET-DATE THRU 4422-EXIT                    
           END-IF.                                                      
      *                                                                         
           WRITE FIOMT51.                                               
      *                                                                         
       4420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   4421-GET-ADDR                                            **          
      **       GETS THE ADDRESS IN FORMATTED FORM USING THE COPYBOOK *          
      **       LOCATION IS J.  IF INSTALL DATE IS NOT FOUND, NO     **          
      **       ACTION IS TAKEN, SINCE THE DATE FIELDS ARE ALREADY   **          
      **       INITIALIZED TO BLANKS.                               **          
      ****************************************************************          
      *                                                                         
       4421-GET-ADDR.                                                   
      *                                                                         
           MOVE MV-LOC-NO                 TO PR-PREMISE-NO              
           MOVE ZEROS                     TO DY-ADDRESS-ID              
           PERFORM 4423-GET-ADDRESS-ID THRU 4423-EXIT                   
           IF  DY-ADDRESS-ID > 0                                        
               PERFORM 4050-GET-FORMATTED-ADDRESS THRU 4050-EXIT        
               IF  WS-FMT-ADDR-STREET > SPACES                          
                   MOVE WS-FMT-ADDR-STREET    TO E-FMT51-ADDR-STREET    
                   MOVE WS-FMT-CITY-STATE-ZIP TO E-FMT51-CITY-ZIP       
               END-IF                                                   
           END-IF                                                       
           IF  DY-ADDRESS-ID NOT > 0                                    
               OR WS-FMT-ADDR-STREET EQUAL SPACES                       
               MOVE WS-ADDR-UNKNOWN-MSG     TO E-FMT51-ADDR-STREET      
               MOVE MV-LOC-NO               TO E-FMT51-CITY-ZIP         
           END-IF.                                                      
       4421-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **                                                            **          
      **   4422-GET-DATE                                            **          
      **       GET INSTALL DATE AND REMOVAL DATE IN CASE THE PREVIOUS*          
      **       LOCATION IS J.  IF INSTALL DATE IS NOT FOUND, NO     **          
      **       ACTION IS TAKEN, SINCE THE DATE FIELDS ARE ALREADY   **          
      **       INITIALIZED TO BLANKS.                               **          
      ****************************************************************          
      *                                                                         
       4422-GET-DATE.                                                   
      *                                                                         
           MOVE EQ-CODE-UTIL-TYPE       TO   MV-CODE-UTIL-TYPE          
           MOVE EQ-DEVICE-NO            TO   MV-DEVICE-NO               
      *                                                                         
           PERFORM 7930-GET-INSTALL-DATE THRU 7930-EXIT                 
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE MV-DATE-MOVE        TO    E-FMT51-INSTALL-DT        
               MOVE MV-MOVE-NO          TO    WS-INSTALL-MOVE-NO        
      *                                                                         
               PERFORM 7940-GET-REMOVAL-DATE THRU 7940-EXIT             
      *                                                                         
               IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
                   MOVE MV-DATE-MOVE    TO    E-FMT51-REMOVE-DT         
               ELSE                                                     
                   MOVE EQ-DATE-LAST-MOVE                               
                                        TO    E-FMT51-REMOVE-DT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       4422-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   4423-GET-ADDRESS-ID                                      **          
      **       STANDARD CODE FOR GETTING THE ADDRESS IN PROPER FORMAT*          
      ****************************************************************          
      *                                                                         
        4423-GET-ADDRESS-ID.                                            
      *                                                                         
            EXEC SQL                                                    
                SELECT ADDRESS_ID,                                      
                       LOCAL_OFFICE                                     
                  INTO :PR-ADDRESS-ID,                                  
                       :PR-LOCAL-OFFICE                                 
                  FROM CSS_PREMISE WITH(READUNCOMMITTED)                        
                 WHERE PREMISE_NO = :PR-PREMISE-NO                      
T35434                                                           
ACT022                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT ADDRESS_ID,                                              
MFA-TR*                LOCAL_OFFICE                                             
MFA-TR*           INTO :PR-ADDRESS-ID,                                          
MFA-TR*                :PR-LOCAL-OFFICE                                         
MFA-TR*           FROM CSS_PREMISE                                              
MFA-TR*          WHERE PREMISE_NO = :PR-PREMISE-NO                              
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 4423                                                   
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                 TO WS-PR-ACTIVE-RETURN-CODE.   
            IF  WS-PR-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
                                            OR NOT-FOUND                
                NEXT SENTENCE                                           
            ELSE                                                        
                DISPLAY '**  SELECT ERROR IN 4423-GET-ADDRESS-ID **'    
                DISPLAY '**    TABLE :  CSS_PREMISE            **'      
                DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
                DISPLAY '**       PROCESSING TERMINATED        **'      
                PERFORM 9000-TERMINATE     THRU 9000-EXIT               
                PERFORM 9900-ABEND         THRU 9900-EXIT               
            END-IF.                                                     
            IF  WS-PR-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
                MOVE PR-ADDRESS-ID        TO DY-ADDRESS-ID              
                MOVE PR-LOCAL-OFFICE      TO E-FMT51-LOCAL-OFFICE       
            ELSE                                                        
                MOVE ZERO                 TO DY-ADDRESS-ID              
                MOVE ZERO                 TO E-FMT51-LOCAL-OFFICE       
            END-IF.                                                     
      *                                                                         
       4423-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
           COPY CPD0023C.                                                       
           EXEC SQL                                                             
              INCLUDE CPD00004                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00074                                                  
           END-EXEC.                                                            
      *                                                                         
PCR533****************************************************************          
      **   4430-RET-TRN-REC.                                        **          
      **       TO WRITE THE RETIRED TRANSFORMERS TO A FILE          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       4430-RET-TRN-REC.                                                
      *                                                                         
           MOVE  SPACES               TO   E-FMT52-ELEC-MTR-CLASS       
                                           E-FMT52-SPEC-CODE            
                                           E-FMT52-SPEC-DESC.           
           MOVE  EQ-DEVICE-NO         TO   IX-XFORMER-NO.               
           MOVE  EQ-CODE-UTIL-TYPE    TO   IX-CODE-UTIL-TYPE.           
T22243     MOVE  EQ-COMPANY-NO        TO   IX-COMPANY-NO.               
C36856     PERFORM 7620-TRAN-EQP-DET  THRU 7620-EXIT.                   
           MOVE IX-XFORMER-SPEC-CD    TO   XS-XFORMER-SPEC-CD           
C36856     PERFORM 7630-TRAN-EQP-DESC THRU 7630-EXIT.                   
           SET E-FMT52-INSTR-XFORMER  TO    TRUE.                       
           MOVE  IX-XFORMER-NO        TO E-FMT52-DEVICE-NO.             
T22243     MOVE  IX-COMPANY-NO        TO E-FMT52-COMPANY-NO.            
           MOVE  IX-XFORMER-SPEC-CD   TO E-FMT52-SPEC-CODE.             
           MOVE  XS-XFORMER-SPEC-DESC TO E-FMT52-SPEC-DESC.             
      *                                                                         
           WRITE FIOMT52.                                               
      *                                                                         
       4430-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   4500-CREATE-WORK-QUEUE.                                  **          
      **       TO DISPLAY THE METER ATTACHMENTS DETAILS             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       4500-CREATE-WORK-QUEUE.                                          
      *                                                                         
A04860     INITIALIZE CWS00077-FIELDS                                   
A04860     MOVE WS-CATEGORY-ID           TO WS-77-CATEGORY-ID.          
A04860     MOVE SPACES                   TO WS-77-RESP-AREA-ID.         
A04860     PERFORM 1130-ADD-THIRTY-CURDATE THRU 1130-EXIT.              
A04860     MOVE WS-DATE-CREATED          TO WS-77-DATE-CREATED.         
A04860     MOVE ZEROS                    TO WS-77-SERV-ORDER-NO.        
A04860     MOVE WS-CUR-DATE              TO WS-77-DATE-REQUIRED.        
A04860     MOVE WS-ACCOUNT               TO WS-77-ACCOUNT-NO.           
A04860     MOVE WS-PREMISE               TO WS-77-PREMISE-NO.           
A04860     MOVE WS-CUSTOMER              TO WS-77-CUSTOMER-NO.          
A04860     MOVE WS-OFFICE                TO WS-77-LOCAL-OFFICE.         
A04860     MOVE WS-ROUTING-CATEGORY      TO WS-77-ROUTE-CATEGORY.       
A04860     MOVE WS-N                     TO WS-77-PRIORITY.             
A04860     MOVE WS-WQ-MESSAGE            TO WS-77-COMMENTS-TEXT.        
A04860     MOVE LENGTH OF WS-WQ-MESSAGE                                 
A04860                                   TO WS-77-COMMENTS-LEN.         
A04860     MOVE SPACES                   TO WS-77-FREE-FORM-TXT.        
A04860     MOVE LENGTH OF WS-77-FREE-FORM-TXT                           
A04860                                   TO WS-77-FREE-FORM-LEN.        
A04860     MOVE PROGRAM-NAME             TO WS-77-CREATED-BY            
           PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.               
           ADD 1 TO CNT-WQ-WRITTEN.                                     
      *                                                                         
       4500-EXIT.                                                       
           EXIT.                                                        
C36856*****************************************************************         
C36856*6253-GET-FJC01-CHKP-LIMIT.                                   *           
C36856*****************************************************************         
C36856*                                                                         
C36856 COPY CPD00034.                                                           
C36856*                                                                         
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7100-OPEN-DIS-MTR.                                       **          
      **       TO OPEN CURSOR DIS-MTR FOR CSS_EQUIPMENT             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7100-OPEN-DIS-MTR.                                               
      *                                                                         
           EXEC SQL                                                     
               OPEN DIS-MTR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  OPEN ERROR IN 7100-OPEN-DIS-MTR   **'       
               DISPLAY '**    TABLE :  CSS_EQUIPMENT          **'       
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
T22243         DISPLAY '** COMPANY-NO  = ' EQ-COMPANY-NO                
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7110-FETCH-DIS-MTR.                                      **          
      **       TO FETCH FIELD DETAILS FROM CSS_EQUIPMENT            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7110-FETCH-DIS-MTR.                                              
      *                                                                         
           EXEC SQL                                                     
               FETCH                                                    
                   DIS-MTR                                              
               INTO                                                     
                   :EQ-DEVICE-NO,                                       
T22243             :EQ-COMPANY-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO     WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE    EQ-DEVICE-NO                                     
                       TO WS-WQ-METER-NO OF WS-WORK-QUEUE-COMMENT1      
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   MOVE WS-Y TO WS-DIS-MTR-FLAG                         
               ELSE                                                     
                   DISPLAY '**  FETCH ERROR IN 7110-FETCH-DIS-MTR   **' 
                   DISPLAY '**     TABLE :  CSS_EQUIPMENT           **' 
                   DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
T22243             DISPLAY '** COMPANY-NO  = ' EQ-COMPANY-NO            
                   DISPLAY '**       PROCESSING TERMINATED        **'   
                   PERFORM 9000-TERMINATE     THRU 9000-EXIT            
                   PERFORM 9900-ABEND         THRU 9900-EXIT            
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7120-SEL-MTR-ATT.                                        **          
      **       TO CHECK IF ANY INSTRUMENT TRANSFORMER OR METER      **          
      **            DEVICE IS ATTACHED TO THE METER                 **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7120-SEL-MTR-ATT.                                                
      *                                                                         
C36856*    /*SELECTING ONLY METERS THAT ARE AMR (DEVICE_TYPE_CD = 'A')          
C36856*    /*AND NOT INTEGRATED (HOW_ATTACHED_CD <> 'I') OR NOT AMR             
           EXEC SQL                                                     
PCR533         SELECT COUNT(*)                                          
PCR533         INTO  :WS-NO-OF-ATTCH :WS-NO-OF-ATTCH-NULL               
C36856         FROM  CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED),               
C36856               CSS_MTR_ATT_TYPE N5 WITH(READUNCOMMITTED)                  
C36856         WHERE MA.CODE_UTIL_TYPE   = :MA-CODE-UTIL-TYPE           
C36856         AND   MA.COMPANY_NO       = :MA-COMPANY-NO               
C36856         AND   MA.METER_NO         = :MA-METER-NO                 
C36856         AND   MA.DEVICE_NO        > ' '                          
C36856         AND ((N5.DEVICE_TYPE_CD   = 'A' AND                      
C36856               MA.HOW_ATTACHED_CD <> 'I') OR                      
C36856               N5.DEVICE_TYPE_CD  <> 'A')                         
C36856         AND   N5.CODE_UTIL_TYPE   = MA.CODE_UTIL_TYPE            
C36856         AND   N5.CODE_ATT_TYPE    = MA.CODE_ATT_TYPE             
T35434                                                           
ACT022                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*        INTO  :WS-NO-OF-ATTCH :WS-NO-OF-ATTCH-NULL                       
MFA-TR*        FROM  CSS_METER_ATTCHMTS MA,                                     
MFA-TR*              CSS_MTR_ATT_TYPE N5                                        
MFA-TR*        WHERE MA.CODE_UTIL_TYPE   = :MA-CODE-UTIL-TYPE                   
MFA-TR*        AND   MA.COMPANY_NO       = :MA-COMPANY-NO                       
MFA-TR*        AND   MA.METER_NO         = :MA-METER-NO                         
MFA-TR*        AND   MA.DEVICE_NO        > ' '                                  
MFA-TR*        AND ((N5.DEVICE_TYPE_CD   = 'A' AND                              
MFA-TR*              MA.HOW_ATTACHED_CD <> 'I') OR                              
MFA-TR*              N5.DEVICE_TYPE_CD  <> 'A')                                 
MFA-TR*        AND   N5.CODE_UTIL_TYPE   = MA.CODE_UTIL_TYPE                    
MFA-TR*        AND   N5.CODE_ATT_TYPE    = MA.CODE_ATT_TYPE                     
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7120                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  SELECT ERROR IN 7120-SEL-MTR-ATT    **'     
               DISPLAY '**     TABLE :  CSS_METER_ATTCHMTS      **'     
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
T22243         DISPLAY '** COMPANY-NO  = ' MA-COMPANY-NO                
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7130-CLOSE-ELEC-MTR.                                     **          
      **       TO CLOSE CURSOR DIS-MTR FOR CSS_EQUIPMENT            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7130-CLOSE-ELEC-MTR.                                             
      *                                                                         
           EXEC SQL                                                     
               CLOSE DIS-MTR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  CLOSE ERROR IN 7130-CLOSE-ELEC-MTR  **'     
               DISPLAY '**    TABLE :  CSS_EQUIPMENT            **'     
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7200-OPEN-TRAN-EQP.                                      **          
      **       TO OPEN CURSOR TRAN-EQP FOR CSS_EQUIPMENT            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7200-OPEN-TRAN-EQP.                                              
      *                                                                         
           EXEC SQL                                                     
               OPEN TRAN-EQP                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  OPEN ERROR IN 7200-OPEN-TRAN-EQP  **'       
               DISPLAY '**    TABLE :  CSS_EQUIPMENT          **'       
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
T22243         DISPLAY '** COMPANY-NO  = ' EQ-COMPANY-NO                
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7210-FETCH-TRAN-EQP.                                     **          
      **       TO FETCH DETAILS FROM  CSS_EQUIPMENT                 **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7210-FETCH-TRAN-EQP.                                             
      *                                                                         
           EXEC SQL                                                     
               FETCH                                                    
                   TRAN-EQP                                             
               INTO                                                     
                   :EQ-DEVICE-NO,                                       
T22243             :EQ-COMPANY-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE     SQLCODE       TO     WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   MOVE WS-Y TO  WS-TRAN-EQP-FLAG                       
               ELSE                                                     
                   DISPLAY '**  FETCH ERROR IN 7210-FETCH-TRAN-EQP  **' 
                   DISPLAY '**     TABLE :  CSS_EQUIPMENT           **' 
                   DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
                   DISPLAY '**       PROCESSING TERMINATED        **'   
                   PERFORM 9000-TERMINATE     THRU 9000-EXIT            
                   PERFORM 9900-ABEND         THRU 9900-EXIT            
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7220-CLOSE-TRAN-EQP.                                     **          
      **       TO CLOSE CURSOR TRAN-EQP FOR CSS_EQUIPMENT           **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7220-CLOSE-TRAN-EQP.                                             
      *                                                                         
           EXEC SQL                                                     
               CLOSE TRAN-EQP                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  CLOSE ERROR IN 7220-CLOSE-TRAN-EQP  **'     
               DISPLAY '**    TABLE :  CSS_EQUIPMENT            **'     
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7300-OPEN-GAS-EQP.                                       **          
      **       TO OPEN CURSOR GAS-EQP FOR CSS_EQUIPMENT             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7300-OPEN-GAS-EQP.                                               
      *                                                                         
           EXEC SQL                                                     
               OPEN GAS-EQP                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  OPEN ERROR IN 7300-OPEN-GAS-EQP   **'       
               DISPLAY '**    TABLE :  CSS_EQUIPMENT          **'       
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7310-FETCH-GAS-EQP.                                      **          
      **       TO FETCH GAS METER DETAILS FROM CSS_EQUIPMENT        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7310-FETCH-GAS-EQP.                                              
      *                                                                         
           EXEC SQL                                                     
               FETCH                                                    
                   GAS-EQP                                              
               INTO                                                     
                   :EQ-DEVICE-NO,                                       
                   :EQ-SERIAL-NO,                                       
T22243             :EQ-COMPANY-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE     SQLCODE      TO     WS-ACTIVE-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   MOVE WS-Y TO WS-GAS-EQP-FLAG                         
               ELSE                                                     
                   DISPLAY '**  FETCH ERROR IN 7310-FETCH-GAS-EQP   **' 
                   DISPLAY '**     TABLE :  CSS_EQUIPMENT           **' 
                   DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
                   DISPLAY '**       PROCESSING TERMINATED        **'   
                   PERFORM 9000-TERMINATE     THRU 9000-EXIT            
                                                                        
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7320-CLOSE-GAS-MTR.                                      **          
      **       TO CLOSE CURSOR GAS-EQP FOR CSS_EQUIPMENT            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7320-CLOSE-GAS-MTR.                                              
      *                                                                         
           EXEC SQL                                                     
               CLOSE GAS-EQP                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  CLOSE ERROR IN 7320-CLOSE-GAS-MTR   **'     
               DISPLAY '**    TABLE :  CSS_EQUIPMENT            **'     
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7400-OPEN-RET-MTR.                                       **          
      **       TO OPEN CURSOR RET-MTR FOR CSS_EQUIPMENT             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7400-OPEN-RET-MTR.                                               
      *                                                                         
           EXEC SQL                                                     
               OPEN RET-MTR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  OPEN ERROR IN 7400-OPEN-RET-MTR   **'       
               DISPLAY '**    TABLE :  CSS_EQUIPMENT          **'       
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7410-FETCH-RET-MTR.                                      **          
      **       TO FETCH METER DETAILS FROM CSS_EQUIPMENT WITH       **          
      **            LOCATION AS UNKNOWN                             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7410-FETCH-RET-MTR.                                              
      *                                                                         
           EXEC SQL                                                     
               FETCH                                                    
                   RET-MTR                                              
               INTO                                                     
                   :EQ-DEVICE-NO,                                       
                   :EQ-SERIAL-NO,                                       
                   :EQ-LOCAL-OFFICE,                                    
                   :EQ-CRNT-LOC-NO,                                     
                   :EQ-CODE-UTIL-TYPE,                                  
                   :EQ-DATE-LAST-MOVE,                                  
                   :EQ-EQUIP-TYPE-CD,                                   
T22243             :EQ-COMPANY-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE     SQLCODE       TO     WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE EQ-DEVICE-NO                                        
                    TO WS-WQ-METER-NO OF WS-WORK-QUEUE-COMMENT2         
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   MOVE WS-Y TO WS-RET-MTR-FLAG                         
               ELSE                                                     
                   DISPLAY '**  FETCH ERROR IN 7410-FETCH-RET-MTR   **' 
                   DISPLAY '**     TABLE :  CSS_EQUIPMENT           **' 
                   DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
T22243             DISPLAY '** COMPANY NO  = ' EQ-COMPANY-NO            
                   DISPLAY '**       PROCESSING TERMINATED        **'   
                   PERFORM 9000-TERMINATE     THRU 9000-EXIT            
                   PERFORM 9900-ABEND         THRU 9900-EXIT            
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7420-RETIRE-RET-MTR.                                     **          
      **       TO MOVE ELECTRIC, GAS METERS AND INSTRUMENT          **          
      **            TRANSFORMERS TO LOCATION RETIRED                **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7420-RETIRE-RET-MTR.                                             
      *                                                                         
           MOVE EQ-EQUIP-TYPE-CD      TO   MV-CODE-DEVICE-TYPE.         
           MOVE EQ-CODE-UTIL-TYPE     TO   MV-CODE-UTIL-TYPE.           
           MOVE EQ-DEVICE-NO          TO   MV-DEVICE-NO.                
           MOVE EQ-LOCAL-OFFICE       TO   MV-LOCAL-OFFICE.             
           MOVE EQ-CRNT-LOC-NO        TO   MV-LOC-NO.                   
           MOVE EQ-DATE-LAST-MOVE     TO   MV-DATE-MOVE.                
           PERFORM 7430-CREATE-MOVE-HIST   THRU 7430-EXIT.              
           PERFORM 7440-UPDATE-EQUIP       THRU 7440-EXIT.              
      *                                                                         
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7430-CREATE-MOVE-HIST.                                   **          
      **       TO INSERT A NEW RECORD IN CSS_MOVEMENT_HIST TABLE    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7430-CREATE-MOVE-HIST.                                           
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO                                              
                   CSS_MOVEMENT_HIST                                    
                   ( CODE_DEVICE_TYPE,                                  
                     CODE_UTIL_TYPE,                                    
                     DEVICE_NO,                                         
                     DATE_MOVE,                                         
                     LOCAL_OFFICE,                                      
                     COMPANY_NO,                                        
                     LOC_NO,                                            
                     MOVE_NO,                                           
                     CODE_CRNT_LOC )                                    
                   VALUES                                               
                   ( :MV-CODE-DEVICE-TYPE,                              
                     :MV-CODE-UTIL-TYPE,                                
                     :MV-DEVICE-NO,                                     
                     IIF(TRY_CONVERT(DATE, :MV-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MV-DATE-MOVE
              ) <> 0) OR (LEN(:MV-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MV-DATE-MOVE
              ), CONVERT(DATE, :MV-DATE-MOVE) ),                               
                     :MV-LOCAL-OFFICE,                                  
BGBG01*              '01',                                                      
BGBG01               :EQ-COMPANY-NO,                                    
                     :MV-LOC-NO,                                        
                     CIS.CURRENT$TIMESTAMP(),                                 
                     :WS-U )                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO                                                      
MFA-TR*            CSS_MOVEMENT_HIST                                            
MFA-TR*            ( CODE_DEVICE_TYPE,                                          
MFA-TR*              CODE_UTIL_TYPE,                                            
MFA-TR*              DEVICE_NO,                                                 
MFA-TR*              DATE_MOVE,                                                 
MFA-TR*              LOCAL_OFFICE,                                              
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              LOC_NO,                                                    
MFA-TR*              MOVE_NO,                                                   
MFA-TR*              CODE_CRNT_LOC )                                            
MFA-TR*            VALUES                                                       
MFA-TR*            ( :MV-CODE-DEVICE-TYPE,                                      
MFA-TR*              :MV-CODE-UTIL-TYPE,                                        
MFA-TR*              :MV-DEVICE-NO,                                             
MFA-TR*              :MV-DATE-MOVE,                                             
MFA-TR*              :MV-LOCAL-OFFICE,                                          
MFA-TR*              '01',                                                      
MFA-TR*              :EQ-COMPANY-NO,                                            
MFA-TR*              :MV-LOC-NO,                                                
MFA-TR*              CURRENT TIMESTAMP,                                         
MFA-TR*              :WS-U )                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** INSERT ERROR IN 7430-CREATE-MOVE-HIST**'     
               DISPLAY '**     TABLE :  CSS_MOVEMENT_HIST       **'     
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED        **'       
BGBG01         DISPLAY ' MV-CODE-DEVICE-TYPE ' MV-CODE-DEVICE-TYPE      
BGBG01         DISPLAY ' MV-CODE-UTIL-TYPE   ' MV-CODE-UTIL-TYPE        
BGBG01         DISPLAY ' MV-DEVICE-NO        ' MV-DEVICE-NO             
BGBG01         DISPLAY ' MV-DATE-MOVE        ' MV-DATE-MOVE             
BGBG01         DISPLAY ' MV-LOCAL-OFFICE     ' MV-LOCAL-OFFICE          
BGBG01         DISPLAY ' MV-LOC-NO           ' MV-LOC-NO                
BGBG01         DISPLAY ' WS-U                ' WS-U                     
BGBG01         DISPLAY ' EQ-COMPANY-NO       ' EQ-COMPANY-NO            
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7430-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7440-UPDATE-EQUIP.                                       **          
      **       TO UPDATE CURRENT CODE IN CSS_EQUIPMENT TABLE        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7440-UPDATE-EQUIP.                                               
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_EQUIPMENT                                     
                   SET   CODE_CRNT_LOC       = :WS-I,                   
                         DATE_LAST_MOVE      = CAST(SYSDATETIMEOFFSET() 
           AS DATE),            
                         DATE_DISPOSED_OF    = CAST(SYSDATETIMEOFFSET() 
           AS DATE)             
                   WHERE CODE_UTIL_TYPE      = :EQ-CODE-UTIL-TYPE       
T22243             AND   COMPANY_NO          = :EQ-COMPANY-NO           
                   AND   DEVICE_NO           = :EQ-DEVICE-NO            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_EQUIPMENT                                             
MFA-TR*            SET   CODE_CRNT_LOC       = :WS-I,                           
MFA-TR*                  DATE_LAST_MOVE      = CURRENT_DATE,                    
MFA-TR*                  DATE_DISPOSED_OF    = CURRENT_DATE                     
MFA-TR*            WHERE CODE_UTIL_TYPE      = :EQ-CODE-UTIL-TYPE               
MFA-TR*            AND   COMPANY_NO          = :EQ-COMPANY-NO                   
MFA-TR*            AND   DEVICE_NO           = :EQ-DEVICE-NO                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  UPDATE ERROR IN 7440-UPDATE-EQUIP   **'     
               DISPLAY '**     TABLE :  CSS_EQUIPMENT           **'     
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
T22243         DISPLAY '** COMPANY NO  = ' EQ-COMPANY-NO                
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7440-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7450-CLOSE-RET-MTR.                                      **          
      **       TO CLOSE CURSOR RET-MTR FOR CSS_EQUIPMENT            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7450-CLOSE-RET-MTR.                                              
      *                                                                         
           EXEC SQL                                                     
               CLOSE RET-MTR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  CLOSE ERROR IN 7450-CLOSE-RET-MTR   **'     
               DISPLAY '**    TABLE :  CSS_EQUIPMENT            **'     
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C36856****************************************************************          
C36856**                                                            **          
C36856**   7460-ATTCH-MOVE-HIST.                                    **          
C36856**       TO UPDATE RECORD IN CSS_EQUIP_ATTCH_MOVE             **          
C36856**                                                            **          
C36856****************************************************************          
C36856*                                                                         
C36856 7460-ATTCH-MOVE-HIST.                                            
C36856*                                                                         
C36856     EXEC SQL                                                     
C36856         UPDATE CSS_EQUIP_ATT_MOVE                                
C36856             SET   EQUIP_LOC_ID        = :WS-I,                   
C36856                   DATE_MOVE           = CAST(SYSDATETIMEOFFSET() 
           AS DATE),            
C36856                   MOVE_NO             = CIS.CURRENT$TIMESTAMP()        
C36856             WHERE CODE_UTIL_TYPE      = :MP-CODE-UTIL-TYPE       
C36856             AND   COMPANY_NO          = :MP-COMPANY-NO           
C36856             AND   DEVICE_NO           = :MP-DEVICE-NO            
C36856             AND   CODE_ATT_TYPE       = :MP-CODE-ATT-TYPE        
C36856             AND   METER_NO            = :MP-METER-NO             
C36856             AND   MTR_STORAGE_FAC_CD  = :MP-MTR-STORAGE-FAC-CD   
C36856     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_EQUIP_ATT_MOVE                                        
MFA-TR*            SET   EQUIP_LOC_ID        = :WS-I,                           
MFA-TR*                  DATE_MOVE           = CURRENT_DATE,                    
MFA-TR*                  MOVE_NO             = CURRENT_TIMESTAMP                
MFA-TR*            WHERE CODE_UTIL_TYPE      = :MP-CODE-UTIL-TYPE               
MFA-TR*            AND   COMPANY_NO          = :MP-COMPANY-NO                   
MFA-TR*            AND   DEVICE_NO           = :MP-DEVICE-NO                    
MFA-TR*            AND   CODE_ATT_TYPE       = :MP-CODE-ATT-TYPE                
MFA-TR*            AND   METER_NO            = :MP-METER-NO                     
MFA-TR*            AND   MTR_STORAGE_FAC_CD  = :MP-MTR-STORAGE-FAC-CD           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36856*                                                                         
C36856     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
C36856*                                                                         
C36856     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C36856         NEXT SENTENCE                                            
C36856     ELSE                                                         
C36856         DISPLAY '** UPDATE ERROR IN 7460-ATTCH-MOVE-HIST**'      
C36856         DISPLAY '**     TABLE :  CSS_EQUIP_ATT_MOVE      **'     
C36856         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C36856         DISPLAY '**       PROCESSING TERMINATED        **'       
C36856         DISPLAY ' MP-CODE-ATT-TYPE ' MP-CODE-ATT-TYPE            
C36856         DISPLAY ' MP-CODE-UTIL-TYPE   ' MP-CODE-UTIL-TYPE        
C36856         DISPLAY ' MP-COMPANY-NO       ' MP-COMPANY-NO            
C36856         DISPLAY ' MP-DATE-MOVE        ' MP-DATE-MOVE             
C36856         DISPLAY ' MP-DEVICE-NO        ' MP-DEVICE-NO             
C36856         DISPLAY ' MP-EQUIP_LOC_ID     ' MP-EQUIP-LOC-ID          
C36856         DISPLAY ' MP-METER-NO         ' MP-METER-NO              
C36856         PERFORM 9000-TERMINATE     THRU 9000-EXIT                
C36856         PERFORM 9900-ABEND         THRU 9900-EXIT                
C36856     END-IF.                                                      
C36856*                                                                         
C36856 7460-EXIT.                                                       
C36856     EXIT.                                                        
C36856*                                                                         
C36856****************************************************************          
C36856**                                                            **          
C36856**   7470-UPDATE-ATTCHMTS.                                    **          
C36856**       TO UPDATE CURRENT CODE IN CSS_EQUIP_ATTCHMTS TABLE   **          
C36856**                                                            **          
C36856****************************************************************          
C36856*                                                                         
C36856 7470-UPDATE-ATTCHMTS.                                            
C36856*                                                                         
C36856     EXEC SQL                                                     
C36856         UPDATE CSS_EQUIP_ATTCHMTS                                
C36856             SET   EQUIP_LOC_ID        = :LX-EQUIP-LOC-ID,        
C36856                   DATE_LAST_MOVE      = CAST(SYSDATETIMEOFFSET() 
           AS DATE),            
C36856                   DATE_DISPOSED_OF    = CAST(SYSDATETIMEOFFSET() 
           AS DATE)             
C36856             WHERE CODE_UTIL_TYPE      = :LX-CODE-UTIL-TYPE       
C36856             AND   COMPANY_NO          = :LX-COMPANY-NO           
C36856             AND   DEVICE_NO           = :LX-DEVICE-NO            
C36856     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_EQUIP_ATTCHMTS                                        
MFA-TR*            SET   EQUIP_LOC_ID        = :LX-EQUIP-LOC-ID,                
MFA-TR*                  DATE_LAST_MOVE      = CURRENT_DATE,                    
MFA-TR*                  DATE_DISPOSED_OF    = CURRENT_DATE                     
MFA-TR*            WHERE CODE_UTIL_TYPE      = :LX-CODE-UTIL-TYPE               
MFA-TR*            AND   COMPANY_NO          = :LX-COMPANY-NO                   
MFA-TR*            AND   DEVICE_NO           = :LX-DEVICE-NO                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36856*                                                                         
C36856     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
C36856*                                                                         
C36856     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C36856         NEXT SENTENCE                                            
C36856     ELSE                                                         
C36856         DISPLAY '**  UPDATE ERROR IN 7470-UPDATE-EQUIP   **'     
C36856         DISPLAY '**     TABLE :  CSS_EQUIP_ATTCHMTS      **'     
C36856         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C36856         DISPLAY '** COMPANY NO  = ' LX-COMPANY-NO                
C36856         DISPLAY '**       PROCESSING TERMINATED        **'       
C36856         PERFORM 9000-TERMINATE     THRU 9000-EXIT                
C36856         PERFORM 9900-ABEND         THRU 9900-EXIT                
C36856     END-IF.                                                      
C36856*                                                                         
C36856 7470-EXIT.                                                       
C36856     EXIT.                                                        
C36856*                                                                         
C36856****************************************************************          
C36856**                                                                        
C36856**   7480-OPEN-INT-ERT.                                       **          
C36856**       TO OPEN CURSOR INT-ERT FOR CSS_METER_ATTCHMTS        **          
C36856**                                                            **          
C36856****************************************************************          
C36856*                                                                         
C36856 7480-OPEN-INT-ERT.                                               
C36856*                                                                         
C36856     EXEC SQL                                                     
C36856         OPEN INT-ERT                                             
C36856     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36856*                                                                         
C36856     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
C36856*                                                                         
C36856     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C36856         NEXT SENTENCE                                            
C36856     ELSE                                                         
C36856         DISPLAY '**  OPEN ERROR IN 7480-OPEN-RET-MTR   **'       
C36856         DISPLAY '**    TABLE :  CSS_METER_ATTCHMTS     **'       
C36856         DISPLAY '**    TABLE :   CSS_MTR_ATT_TYPE      **'       
C36856         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C36856         DISPLAY '**       PROCESSING TERMINATED        **'       
C36856         PERFORM 9000-TERMINATE     THRU 9000-EXIT                
C36856         PERFORM 9900-ABEND         THRU 9900-EXIT                
C36856     END-IF.                                                      
C36856*                                                                         
C36856 7480-EXIT.                                                       
C36856     EXIT.                                                        
C36856*                                                                         
C36856****************************************************************          
C36856**                                                            **          
C36856**   7485-FETCH-INT-ERT.                                      **          
C36856**       TO FETCH FIELD DETAILS FROM CSS_METER_ATTCHMTS       **          
C36856**                                                            **          
C36856****************************************************************          
C36856*                                                                         
C36856 7485-FETCH-INT-ERT.                                              
C36856*                                                                         
C36856     EXEC SQL                                                     
C36856         FETCH                                                    
C36856             INT-ERT                                              
C36856         INTO                                                     
C36856             :MA-DEVICE-NO,                                       
C36856             :MA-CODE-ATT-TYPE                                    
C36856     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36856*                                                                         
C36856     MOVE SQLCODE           TO     WS-ACTIVE-RETURN-CODE.         
C36856*                                                                         
C36856     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C36856         NEXT SENTENCE                                            
C36856     ELSE                                                         
C36856         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
C36856             MOVE WS-Y TO WS-INT-ERT-FLAG                         
C36856         ELSE                                                     
C36856             DISPLAY '**  FETCH ERROR IN 7485-FETCH-INT-ERT   **' 
C36856             DISPLAY '**     TABLE :  CSS_METER_ATTCHMTS      **' 
C36856             DISPLAY '**     TABLE :   CSS_MTR_ATT_TYPE       **' 
C36856             DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
C36856             DISPLAY '** COMPANY-NO  = ' EQ-COMPANY-NO            
C36856             DISPLAY '**       PROCESSING TERMINATED        **'   
C36856             PERFORM 9000-TERMINATE     THRU 9000-EXIT            
C36856             PERFORM 9900-ABEND         THRU 9900-EXIT            
C36856         END-IF                                                   
C36856     END-IF.                                                      
C36856*                                                                         
C36856 7485-EXIT.                                                       
C36856     EXIT.                                                        
C36856*                                                                         
C36856****************************************************************          
C36856**                                                            **          
C36856**   7490-CLOSE-INT-ERT.                                      **          
C36856**       TO CLOSE CURSOR INT-ERT                              **          
C36856**                                                            **          
C36856****************************************************************          
C36856*                                                                         
C36856 7490-CLOSE-INT-ERT.                                              
C36856*                                                                         
C36856     EXEC SQL                                                     
C36856         CLOSE INT-ERT                                            
C36856     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36856*                                                                         
C36856     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
C36856*                                                                         
C36856     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C36856         NEXT SENTENCE                                            
C36856     ELSE                                                         
C36856         DISPLAY '**  CLOSE ERROR IN 7490-CLOSE-RET-MTR **'       
C36856         DISPLAY '**    TABLE :  CSS_METER_ATTCHMTS     **'       
C36856         DISPLAY '**    TABLE :   CSS_MTR_ATT_TYPE      **'       
C36856         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C36856         DISPLAY '**       PROCESSING TERMINATED        **'       
C36856         PERFORM 9000-TERMINATE     THRU 9000-EXIT                
C36856         PERFORM 9900-ABEND         THRU 9900-EXIT                
C36856     END-IF.                                                      
C36856*                                                                         
C36856 7490-EXIT.                                                       
C36856     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7500-ELEC-MTR-DET.                                       **          
      **       TO GET THE ELECTRIC METER DETAILS FROM CSS_ELEC_MTR  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7500-ELEC-MTR-DET.                                               
      *                                                                         
           EXEC SQL                                                     
               SELECT METER_NO,                                         
                      ELEC_MTR_CLASS_CD,                                
                      ELEC_MTR_SPEC_CD                                  
               INTO   :EM-METER-NO,                                     
                      :EM-ELEC-MTR-CLASS-CD,                            
                      :EM-ELEC-MTR-SPEC-CD                              
               FROM   CSS_ELEC_METER WITH(READUNCOMMITTED)                      
               WHERE  CODE_UTIL_TYPE =  :EM-CODE-UTIL-TYPE              
T22243         AND    COMPANY_NO     =  :EM-COMPANY-NO                  
               AND    METER_NO       =  :EM-METER-NO                    
T35434                                                           
ACT022                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT METER_NO,                                                 
MFA-TR*               ELEC_MTR_CLASS_CD,                                        
MFA-TR*               ELEC_MTR_SPEC_CD                                          
MFA-TR*        INTO   :EM-METER-NO,                                             
MFA-TR*               :EM-ELEC-MTR-CLASS-CD,                                    
MFA-TR*               :EM-ELEC-MTR-SPEC-CD                                      
MFA-TR*        FROM   CSS_ELEC_METER                                            
MFA-TR*        WHERE  CODE_UTIL_TYPE =  :EM-CODE-UTIL-TYPE                      
MFA-TR*        AND    COMPANY_NO     =  :EM-COMPANY-NO                          
MFA-TR*        AND    METER_NO       =  :EM-METER-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  SELECT ERROR IN 7500-ELEC-MTR-DET **'       
               DISPLAY '**    TABLE :  CSS_ELEC_METER         **'       
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
T22243         DISPLAY '** COMPANY-NO  = ' EM-COMPANY-NO                
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7510-ELEC-MTR-DESC.                                      **          
      **       TO GET THE ELECTRIC METER DESC FROM CSS_ELEC_MTR_SPEC**          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7510-ELEC-MTR-DESC.                                              
      *                                                                         
           EXEC SQL                                                     
               SELECT ELEC_MTR_SPEC_DESC                                
               INTO   :U5-ELEC-MTR-SPEC-DESC                            
               FROM   CSS_ELEC_MTR_SPEC WITH(READUNCOMMITTED)                   
               WHERE  ELEC_MTR_SPEC_CD = :U5-ELEC-MTR-SPEC-CD           
T35434                                                           
ACT022                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ELEC_MTR_SPEC_DESC                                        
MFA-TR*        INTO   :U5-ELEC-MTR-SPEC-DESC                                    
MFA-TR*        FROM   CSS_ELEC_MTR_SPEC                                         
MFA-TR*        WHERE  ELEC_MTR_SPEC_CD = :U5-ELEC-MTR-SPEC-CD                   
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7510                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  SELECT ERROR IN 7510-ELEC-MTR-DESC**'       
               DISPLAY '**    TABLE :  CSS_ELEC_MTR_SPEC      **'       
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7510-EXIT.                                                       
           EXIT.                                                        
C36856*                                                                         
C36856****************************************************************          
C36856*  7600-START-FCSJC01                                          *          
C36856*  7610-READ-FCSJC01                                           *          
C36856*  GET THE REVENUE MONTH                                       *          
C36856****************************************************************          
C36856*                                                                         
C36856     EXEC SQL                                                             
C36856         INCLUDE CPD00038                                                 
C36856     END-EXEC.                                                            
C36856*                                                                         
C36856*                                                                         
      *                                                                         
      ****************************************************************          
      **                                                            **          
C36856**   7620-TRAN-EQP-DET.                                       **          
      **      TO GET THE TRANSFORMER DETAILS FROM CSS_INSTR_XFORMER **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
C36856 7620-TRAN-EQP-DET.                                               
      *                                                                         
           EXEC SQL                                                     
               SELECT XFORMER_NO,                                       
                      XFORMER_SPEC_CD                                   
               INTO   :IX-XFORMER-NO,                                   
                      :IX-XFORMER-SPEC-CD                               
               FROM   CSS_INSTR_XFORMER WITH(READUNCOMMITTED)                   
               WHERE  CODE_UTIL_TYPE =  :IX-CODE-UTIL-TYPE              
T22243         AND    COMPANY_NO     =  :IX-COMPANY-NO                  
               AND    XFORMER_NO     =  :IX-XFORMER-NO                  
T35434                                                           
ACT022                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT XFORMER_NO,                                               
MFA-TR*               XFORMER_SPEC_CD                                           
MFA-TR*        INTO   :IX-XFORMER-NO,                                           
MFA-TR*               :IX-XFORMER-SPEC-CD                                       
MFA-TR*        FROM   CSS_INSTR_XFORMER                                         
MFA-TR*        WHERE  CODE_UTIL_TYPE =  :IX-CODE-UTIL-TYPE                      
MFA-TR*        AND    COMPANY_NO     =  :IX-COMPANY-NO                          
MFA-TR*        AND    XFORMER_NO     =  :IX-XFORMER-NO                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7620                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
C36856         DISPLAY '**  SELECT ERROR IN 7620-TRAN-EQP-DET **'       
               DISPLAY '**    TABLE :  CSS_INSTR_XFORMER      **'       
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
T22243         DISPLAY '** COMPANY-NO  = ' IX-COMPANY-NO                
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
           IF IX-XFORMER-SPEC-CD EQUAL LOW-VALUES OR SPACES             
               MOVE SPACES TO IX-XFORMER-SPEC-CD                        
           END-IF.                                                      
      *                                                                         
C36856 7620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
C36856**   7630-TRAN-EQP-DESC.                                      **          
      **      TO GET THE TRANSFORMER DESC FROM CSS_XFORMER_SPEC     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
C36856 7630-TRAN-EQP-DESC.                                              
      *                                                                         
           EXEC SQL                                                     
               SELECT XFORMER_SPEC_DESC                                 
               INTO   :XS-XFORMER-SPEC-DESC                             
               FROM   CSS_XFORMER_SPEC WITH(READUNCOMMITTED)                    
               WHERE  XFORMER_SPEC_CD = :XS-XFORMER-SPEC-CD             
T35434                                                           
ACT022                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT XFORMER_SPEC_DESC                                         
MFA-TR*        INTO   :XS-XFORMER-SPEC-DESC                                     
MFA-TR*        FROM   CSS_XFORMER_SPEC                                          
MFA-TR*        WHERE  XFORMER_SPEC_CD = :XS-XFORMER-SPEC-CD                     
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7630                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
C36856         DISPLAY '**  SELECT ERROR IN 7630-TRAN-EQP-DESC**'       
               DISPLAY '**    TABLE :  CSS_XFORMER_SPEC       **'       
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
           IF XS-XFORMER-SPEC-DESC EQUAL LOW-VALUES OR SPACES           
               MOVE SPACES TO XS-XFORMER-SPEC-DESC                      
           END-IF.                                                      
      *                                                                         
C36856 7630-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7700-GAS-EQP-DET.                                        **          
      **      TO GET THE GAS METER  DETAILS FROM CSS_GAS_METER      **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7700-GAS-EQP-DET.                                                
      *                                                                         
           EXEC SQL                                                     
               SELECT METER_NO,                                         
                      METER_SIZE_ID                                     
               INTO   :GM-METER-NO,                                     
                      :GM-METER-SIZE-ID                                 
               FROM   CSS_GAS_METER WITH(READUNCOMMITTED)                       
               WHERE  CODE_UTIL_TYPE =  :GM-CODE-UTIL-TYPE              
T22243         AND    COMPANY_NO     =  :GM-COMPANY-NO                  
               AND    METER_NO       =  :GM-METER-NO                    
T35434                                                           
ACT022                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT METER_NO,                                                 
MFA-TR*               METER_SIZE_ID                                             
MFA-TR*        INTO   :GM-METER-NO,                                             
MFA-TR*               :GM-METER-SIZE-ID                                         
MFA-TR*        FROM   CSS_GAS_METER                                             
MFA-TR*        WHERE  CODE_UTIL_TYPE =  :GM-CODE-UTIL-TYPE                      
MFA-TR*        AND    COMPANY_NO     =  :GM-COMPANY-NO                          
MFA-TR*        AND    METER_NO       =  :GM-METER-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  SELECT ERROR IN 7700-GAS-EQP-DET  **'       
               DISPLAY '**    TABLE :  CSS_GAS_METER          **'       
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
T22243         DISPLAY '** COMPANY-NO  = ' GM-COMPANY-NO                
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7710-GAS-EQP-DESC                                        **          
      **      TO GET THE GAS METER  DESC FROM CSS_GAS_METER_SIZE    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7710-GAS-EQP-DESC.                                               
      *                                                                         
           EXEC SQL                                                     
               SELECT METER_SIZE_DESC                                   
               INTO   :M5-METER-SIZE-DESC                               
               FROM   CSS_GAS_METER_SIZE WITH(READUNCOMMITTED)                  
               WHERE  METER_SIZE_ID =  :M5-METER-SIZE-ID                
C23811           AND  COMPANY_NO    =  :M5-COMPANY-NO                   
T35434                                                           
ACT022                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT METER_SIZE_DESC                                           
MFA-TR*        INTO   :M5-METER-SIZE-DESC                                       
MFA-TR*        FROM   CSS_GAS_METER_SIZE                                        
MFA-TR*        WHERE  METER_SIZE_ID =  :M5-METER-SIZE-ID                        
MFA-TR*          AND  COMPANY_NO    =  :M5-COMPANY-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7710                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  SELECT ERROR IN 7710-GAS-EQP-DESC **'       
               DISPLAY '**    TABLE :  CSS_GAS_METER_SIZE     **'       
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
           IF M5-METER-SIZE-DESC EQUAL LOW-VALUES OR SPACES             
               MOVE SPACES TO M5-METER-SIZE-DESC                        
           END-IF.                                                      
      *                                                                         
       7710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7800-DELETE-TABLES.                                      **          
      **       TO DELETE RECORDS WITH LOCATION AS DISPOSED FOR      **          
      **        MORE THAN 5/2 YEARS IN APPROPRIATE TABLES.          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7800-DELETE-TABLES.                                              
      *                                                                         
           IF EQ-CODE-UTIL-TYPE = WS-X                                  
               MOVE EQ-DEVICE-NO      TO    IX-XFORMER-NO               
               MOVE EQ-CODE-UTIL-TYPE TO    IX-CODE-UTIL-TYPE           
T22243         MOVE EQ-COMPANY-NO     TO    IX-COMPANY-NO               
               PERFORM 7820-DEL-INS-TRN     THRU 7820-EXIT              
           END-IF.                                                      
      *                                                                         
           IF EQ-CODE-UTIL-TYPE = WS-E OR WS-G                          
               MOVE EQ-DEVICE-NO      TO    MA-METER-NO                 
               MOVE EQ-CODE-UTIL-TYPE TO    MA-CODE-UTIL-TYPE           
T22243         MOVE EQ-COMPANY-NO     TO    MA-COMPANY-NO               
C36856         MOVE WS-N TO WS-INT-ERT-FLAG                             
C36856         PERFORM 7480-OPEN-INT-ERT    THRU 7480-EXIT              
C36856         PERFORM 7485-FETCH-INT-ERT   THRU 7485-EXIT              
C36856         PERFORM UNTIL WS-INT-ERT-FLAG = 'Y'                      
C36856              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
C36856                 MOVE MA-CODE-ATT-TYPE  TO LX-CODE-ATT-TYPE       
C36856                 MOVE MA-CODE-UTIL-TYPE TO LX-CODE-UTIL-TYPE      
C36856                 MOVE EQ-COMPANY-NO     TO LX-COMPANY-NO          
C36856                 MOVE MA-DEVICE-NO      TO LX-DEVICE-NO           
C36856                 DISPLAY '*** DELETING INT ERT : ' LX-DEVICE-NO   
C36856                 PERFORM 7865-DEL-EQP-ATT THRU 7865-EXIT          
C36856              END-IF                                              
C36856              PERFORM 7485-FETCH-INT-ERT   THRU 7485-EXIT         
C36856         END-PERFORM                                              
C36856         PERFORM 7490-CLOSE-INT-ERT   THRU 7490-EXIT              
               PERFORM 7870-DEL-MTR-ATT     THRU 7870-EXIT              
           END-IF.                                                      
      *                                                                         
           IF EQ-CODE-UTIL-TYPE = WS-G                                  
               MOVE EQ-DEVICE-NO      TO    GM-METER-NO                 
               MOVE EQ-CODE-UTIL-TYPE TO    GM-CODE-UTIL-TYPE           
T22243         MOVE EQ-COMPANY-NO     TO    GM-COMPANY-NO               
               PERFORM 7850-DEL-GAS-MTR     THRU 7850-EXIT
           END-IF.             
      *                                                                         
           IF EQ-CODE-UTIL-TYPE = WS-E                                  
               MOVE EQ-DEVICE-NO      TO    EM-METER-NO                 
               MOVE EQ-CODE-UTIL-TYPE TO    EM-CODE-UTIL-TYPE           
T22243         MOVE EQ-COMPANY-NO     TO    EM-COMPANY-NO               
               PERFORM 7860-DEL-ELE-MTR     THRU 7860-EXIT
           END-IF.             
      *                                                                         
           PERFORM 7880-DEL-EQUIP           THRU 7880-EXIT.             
      *                                                                         
C36856*                                                                         
C36856     ADD +1                           TO WS-COMMIT-COUNTER        
C36856                                                                  
C36856     IF WS-COMMIT-COUNTER >= WS-CHKP-LUW-LIMIT                    
C36856        AND WS-COMMITS-REQUIRE                                    
C36856        ADD +1                          TO WS-CHKP-UPD-COUNTER    
C36856        PERFORM 8898-ISSUE-CHKP         THRU 8898-EXIT            
C36856        MOVE 0                          TO WS-COMMIT-COUNTER      
C36856     END-IF                                                       
C36856     .                                                            
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7820-DEL-INS-TRN.                                        **          
      **       TO DELETE RECORDS WITH LOCATION AS DISPOSED FOR      **          
      **        MORE THAN 5/2 YEARS IN CSS_INSTR_XFORMER            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7820-DEL-INS-TRN.                                                
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM                                              
                   CSS_INSTR_XFORMER                                    
                   WHERE  CODE_UTIL_TYPE = :IX-CODE-UTIL-TYPE           
T22243             AND    COMPANY_NO     = :IX-COMPANY-NO               
                   AND    XFORMER_NO     = :IX-XFORMER-NO               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  DELETE ERROR IN 7820-DEL-INS-TRN    **'     
               DISPLAY '**     TABLE :  CSS_INSTR_XFORMER       **'     
               DISPLAY '**  CODE UTIL TYPE = ' EQ-CODE-UTIL-TYPE        
T22243         DISPLAY '**  COMPANY-NO     = ' EQ-COMPANY-NO            
               DISPLAY '**   IX-XFORMER-NO = ' EQ-DEVICE-NO             
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7820-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7850-DEL-GAS-MTR.                                        **          
      **       TO DELETE RECORDS  WITH LOCATION AS DISPOSED FOR     **          
      **        MORE THAN 5/2 YEARS IN CSS_GAS_METER                **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7850-DEL-GAS-MTR.                                                
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM                                              
                   CSS_GAS_METER                                        
                   WHERE  CODE_UTIL_TYPE  = :GM-CODE-UTIL-TYPE          
T22243             AND    COMPANY_NO      = :GM-COMPANY-NO              
                   AND    METER_NO        = :GM-METER-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** DELETE ERROR IN 7850-DEL-GAS-MTR    **'      
               DISPLAY '**        TABLE :  CSS_GAS_METER       **'      
               DISPLAY '**  CODE UTIL TYPE = ' EQ-CODE-UTIL-TYPE        
T22243         DISPLAY '**  COMPANY-NO     = ' GM-COMPANY-NO            
               DISPLAY '**  GM-METER-NO    = ' GM-METER-NO              
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7860-DEL-ELE-MTR.                                        **          
      **       TO DELETE RECORDS WITH LOCATION AS DISPOSED FOR      **          
      **        MORE THAN 5/2 YEARS IN CSS_ELEC_METER.              **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7860-DEL-ELE-MTR.                                                
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM                                              
                   CSS_ELEC_METER                                       
                   WHERE  CODE_UTIL_TYPE  = :EM-CODE-UTIL-TYPE          
T22243             AND    COMPANY_NO      = :EM-COMPANY-NO              
                   AND    METER_NO        = :EM-METER-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** DELETE ERROR IN 7860-DEL-ELE-MTR     **'     
               DISPLAY '**        TABLE :  CSS_ELEC_METER       **'     
               DISPLAY '**  CODE UTIL TYPE = ' EQ-CODE-UTIL-TYPE        
T22243         DISPLAY '**  COMPANY-NO     = ' EM-COMPANY-NO            
               DISPLAY '**  EM-METER-NO    = ' EM-METER-NO              
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7860-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C36856****************************************************************          
C36856**                                                            **          
C36856**   7865-DEL-EQP-ATT.                                        **          
C36856**       TO DELETE RECORDS WITH LOCATION AS DISPOSED FOR      **          
C36856**        MORE THAN 5/2 YEARS IN CSS_EQUIP_ATTCHMTS           **          
C36856**                                                            **          
C36856****************************************************************          
C36856*                                                                         
C36856 7865-DEL-EQP-ATT.                                                
C36856*                                                                         
C36856     EXEC SQL                                                     
C36856         DELETE FROM                                              
C36856             CSS_EQUIP_ATTCHMTS                                   
C36856             WHERE  CODE_UTIL_TYPE = :LX-CODE-UTIL-TYPE           
C36856             AND    COMPANY_NO     = :LX-COMPANY-NO               
C36856             AND    DEVICE_NO      = :LX-DEVICE-NO                
C36856             AND    CODE_ATT_TYPE  = :LX-CODE-ATT-TYPE            
C36856     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36856*                                                                         
C36856     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
C36856*                                                                         
C36856     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C36856         NEXT SENTENCE                                            
C36856     ELSE                                                         
C36856         DISPLAY '** DELETE ERROR IN 7865-DEL-EQP-ATT   **'       
C36856         DISPLAY '**     TABLE :  CSS_EQUIP_ATTCHMTS    **'       
C36856         DISPLAY '**  CODE UTIL TYPE = ' LX-CODE-UTIL-TYPE        
C36856         DISPLAY '**  COMPANY-NO     = ' LX-COMPANY-NO            
C36856         DISPLAY '**  DEVICE-NO      = ' LX-DEVICE-NO             
C36856         DISPLAY '**  CODE ATT TYPE  = ' LX-CODE-ATT-TYPE         
C36856         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C36856         DISPLAY '**       PROCESSING TERMINATED        **'       
C36856         PERFORM 9000-TERMINATE     THRU 9000-EXIT                
C36856         PERFORM 9900-ABEND         THRU 9900-EXIT                
C36856     END-IF.                                                      
C36856*                                                                         
C36856 7865-EXIT.                                                       
C36856     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7870-DEL-MTR-ATT.                                        **          
      **       TO DELETE RECORDS WITH LOCATION AS DISPOSED FOR      **          
      **        MORE THAN 5/2 YEARS IN CSS_METER_ATTCHMTS           **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7870-DEL-MTR-ATT.                                                
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM                                              
                   CSS_METER_ATTCHMTS                                   
                   WHERE  CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE           
T22243             AND    COMPANY_NO     = :MA-COMPANY-NO               
                   AND    METER_NO       = :MA-METER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** DELETE ERROR IN 7870-DEL-MTR-ATT   **'       
               DISPLAY '**     TABLE :  CSS_METER_ATTCHMTS    **'       
               DISPLAY '**  CODE UTIL TYPE = ' EQ-CODE-UTIL-TYPE        
T22243         DISPLAY '**  COMPANY-NO     = ' MA-COMPANY-NO            
               DISPLAY '**  MA-METER-NO    = ' MA-METER-NO              
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7870-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7880-DEL-EQUIP.                                          **          
      **       TO DELETE RECORDS WITH LOCATION AS DISPOSED FOR      **          
      **        MORE THAN 5/2 YEARS IN CSS_EQUIPMENT.               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7880-DEL-EQUIP.                                                  
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM                                              
                   CSS_EQUIPMENT                                        
                   WHERE  CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE          
T22243             AND    COMPANY_NO      = :EQ-COMPANY-NO              
                   AND    DEVICE_NO       = :EQ-DEVICE-NO               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** DELETE ERROR IN 7880-DEL-EQUIP    **'        
               DISPLAY '**        TABLE :  CSS_EQUIPMENT     **'        
               DISPLAY '**  CODE UTIL TYPE = ' EQ-CODE-UTIL-TYPE        
T22243         DISPLAY '**  COMPANY-NO     = ' EQ-COMPANY-NO            
               DISPLAY '**  EQ-DEVICE-NO   = ' EQ-DEVICE-NO             
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7880-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
PCR533***************************************************************           
      **                                                            **          
      **   7900-OPEN-MOV-HIST                                       **          
      **       TO OPEN CURSOR MOV-HIST FOR CSS_MOVEMENT_HIST        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7900-OPEN-MOV-HIST.                                              
      *                                                                         
           EXEC SQL                                                     
               OPEN MOV-HIST                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
             IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-Y TO WS-MOVE-HIST-FLAG                         
             ELSE                                                       
               DISPLAY '**  OPEN ERROR IN 7900-OPEN-MOV-HIST  **'       
               DISPLAY '**    TABLE :  CSS_MOVEMENT_HIST      **'       
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7910-FETCH-MOV-HIST.                                     **          
      **       TO FETCH MOVEMENT HIST DETAILS FOM CSS_MOVEMENT_HIST **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7910-FETCH-MOV-HIST.                                             
      *                                                                         
           EXEC SQL                                                     
               FETCH MOV-HIST                                           
               INTO                                                     
                     :MV-MOVE-NO,                                       
                     :MV-LOCAL-OFFICE,                                  
                     :MV-LOC-NO,                                        
                     :MV-CODE-CRNT-LOC                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE     SQLCODE      TO     WS-ACTIVE-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   MOVE WS-Y TO WS-MOVE-HIST-FLAG                       
               ELSE                                                     
                   DISPLAY '**  FETCH ERROR IN 7910-FETCH-GAS-EQP   **' 
                   DISPLAY '**     TABLE :  CSS_MOVEMENT_HIST       **' 
                   DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
                   DISPLAY '**       PROCESSING TERMINATED        **'   
                   PERFORM 9000-TERMINATE     THRU 9000-EXIT            
                   PERFORM 9900-ABEND         THRU 9900-EXIT            
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7920-CLOSE-MOV-HIST.                                     **          
      **       TO CLOSE CURSOR MOV-HIST FOR CSS_MOVEMENT_HIST       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7920-CLOSE-MOV-HIST.                                             
      *                                                                         
           EXEC SQL                                                     
               CLOSE MOV-HIST                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  CLOSE ERROR IN 7920-CLOSE-MOV-HIST  **'     
               DISPLAY '**    TABLE :  CSS_MOVEMENT_HIST        **'     
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9000-TERMINATE     THRU 9000-EXIT                
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **   7930-GET-INSTALL-DATE GETS THE INSTALL DATE, BY LOOKING FOR**        
      **   LATEST MOVEMENT (MAX (MOVE-NO) TO LOCATION CODE J          **        
      *****************************************************************         
      *                                                                         
       7930-GET-INSTALL-DATE.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT                                                   
                     REPLACE(REPLACE(CONVERT(CHAR(26), MAX(MOVE_NO)
           , 121), ' ', '-'), ':', '.')                                       
               INTO  :MV-MOVE-NO :WS-MOVE-NO-NULL                       
               FROM  CSS_MOVEMENT_HIST WITH(READUNCOMMITTED)                    
               WHERE CODE_UTIL_TYPE    = :MV-CODE-UTIL-TYPE             
                 AND DEVICE_NO         = :MV-DEVICE-NO                  
                 AND CODE_CRNT_LOC     = :WS-J                          
T35434                                                           
ACT022                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*              MAX(MOVE_NO)                                               
MFA-TR*        INTO  :MV-MOVE-NO :WS-MOVE-NO-NULL                               
MFA-TR*        FROM  CSS_MOVEMENT_HIST                                          
MFA-TR*        WHERE CODE_UTIL_TYPE    = :MV-CODE-UTIL-TYPE                     
MFA-TR*          AND DEVICE_NO         = :MV-DEVICE-NO                          
MFA-TR*          AND CODE_CRNT_LOC     = :WS-J                                  
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7930                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** SELECT ERROR IN 7930-GET-INSTALL-DATE **'    
               DISPLAY '** TABLE :CSS_MOVEMENT_HIST'                    
               DISPLAY '**  CODE UTIL TYPE = ' MV-CODE-UTIL-TYPE        
               DISPLAY '**  MV-DEVICE-NO   = ' MV-DEVICE-NO             
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED       **'        
               PERFORM 9900-ABEND        THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
           IF WS-MOVE-NO-NULL = -1                                      
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 7950-MOVE-DATE  THRU 7950-EXIT                   
           END-IF.                                                      
      *                                                                         
       7930-EXIT.                                                       
      *                                                                         
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **   7940-GET-REMOVAL-DATE GETS THE REMOVAL DATE, BY LOOKING FOR**        
      **   EARLIEST MOVEMENT (MIN(MOVE-NO)) FOR THE GIVEN METER       **        
      *****************************************************************         
      *                                                                         
       7940-GET-REMOVAL-DATE.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT                                                   
                     REPLACE(REPLACE(CONVERT(CHAR(26), MIN(MOVE_NO)
           , 121), ' ', '-'), ':', '.')                                       
               INTO  :MV-MOVE-NO :WS-MOVE-NO-NULL                       
               FROM  CSS_MOVEMENT_HIST WITH(READUNCOMMITTED)                    
               WHERE CODE_UTIL_TYPE     = :MV-CODE-UTIL-TYPE            
                 AND DEVICE_NO          = :MV-DEVICE-NO                 
                 AND MOVE_NO            > CIS.CHAR2TIMESTAMP(
                                                    :WS-INSTALL-MOVE-NO
              )           
T35434                                                           
ACT022                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*              MIN(MOVE_NO)                                               
MFA-TR*        INTO  :MV-MOVE-NO :WS-MOVE-NO-NULL                               
MFA-TR*        FROM  CSS_MOVEMENT_HIST                                          
MFA-TR*        WHERE CODE_UTIL_TYPE     = :MV-CODE-UTIL-TYPE                    
MFA-TR*          AND DEVICE_NO          = :MV-DEVICE-NO                         
MFA-TR*          AND MOVE_NO            > :WS-INSTALL-MOVE-NO                   
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7940                                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** SELECT ERROR IN 7940-GET-REMOVAL-DATE **'    
               DISPLAY '** TABLE : CSS_MOVEMENT_HIST'                   
               DISPLAY '**  CODE UTIL TYPE = ' MV-CODE-UTIL-TYPE        
               DISPLAY '**  MV-DEVICE-NO   = ' MV-DEVICE-NO             
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED       **'        
               PERFORM 9900-ABEND        THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
           IF WS-MOVE-NO-NULL = -1                                      
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 7950-MOVE-DATE THRU  7950-EXIT                   
           END-IF.                                                      
      *                                                                         
       7940-EXIT.                                                       
      *                                                                         
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   7950-MOVE-DATE                                          **           
      ****************************************************************          
      *                                                                         
       7950-MOVE-DATE.                                                  
      *                                                                         
           EXEC SQL                                                     
               SELECT DATE_MOVE                                         
               INTO  :MV-DATE-MOVE                                      
               FROM  CSS_MOVEMENT_HIST WITH(READUNCOMMITTED)                    
               WHERE CODE_UTIL_TYPE    = :MV-CODE-UTIL-TYPE             
                 AND DEVICE_NO         = :MV-DEVICE-NO                  
                 AND MOVE_NO           = CIS.CHAR2TIMESTAMP(:MV-MOVE-NO)        
T35434                                                           
ACT022                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE_MOVE                                                 
MFA-TR*        INTO  :MV-DATE-MOVE                                              
MFA-TR*        FROM  CSS_MOVEMENT_HIST                                          
MFA-TR*        WHERE CODE_UTIL_TYPE    = :MV-CODE-UTIL-TYPE                     
MFA-TR*          AND DEVICE_NO         = :MV-DEVICE-NO                          
MFA-TR*          AND MOVE_NO           = :MV-MOVE-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7950                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO  WS-ACTIVE-RETURN-CODE.            
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** SELECT ERROR IN 7950-MOVE-DATE **'           
               DISPLAY '** TABLE : CSS_MOVEMENT_HIST'                   
               DISPLAY '** CODE UTIL TYPE = ' MV-CODE-UTIL-TYPE         
               DISPLAY '** MV-DEVICE-NO   = ' MV-DEVICE-NO              
               DISPLAY '** MV-MOVE-NO     = ' MV-MOVE-NO                
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**       PROCESSING TERMINATED       **'        
               PERFORM 9900-ABEND        THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
      *                                                                         
       7950-EXIT.                                                       
      *                                                                         
           EXIT.                                                        
      *                                                                         
T35249****************************************************************          
T35249**   7960-METER-ERR                                          **           
T35249****************************************************************          
T35249 7960-METER-ERR.                                                  
T35249*                                                                         
T35249     EXEC SQL                                                     
T35249         SELECT TOP(1) AT.ACCOUNT_NO,
              AT.CUSTOMER_NO,
              AT.PREMISE_NO,
              AT.LOCAL_OFFICE                                   
T35249         INTO  :AT-ACCOUNT-NO                                     
T35249              ,:AT-CUSTOMER-NO                                    
T35249              ,:AT-PREMISE-NO                                     
T35249              ,:AT-LOCAL-OFFICE                                   
T35249         FROM  CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
T35249              ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
36906               ,CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)                
T35249         WHERE MN.ACCOUNT_NO        = AT.ACCOUNT_NO               
36906            AND CH.ACCOUNT_NO        = MN.ACCOUNT_NO               
36906            AND CH.PREMISE_NO        = AT.PREMISE_NO               
T35249           AND MN.CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE          
T35249           AND AT.COMPANY_NO        = :AT-COMPANY-NO              
T35249           AND MN.METER_NO          = :MN-METER-NO                
T35249           AND MN.CODE_METER_STATUS <> 'K'                        
36906            AND CH.DATE_UTIL_SVC_STRT =                            
36906                 ( SELECT MAX(DATE_UTIL_SVC_STRT)                  
36906                     FROM CSS_CUST_PREM_HIST WITH(READUNCOMMITTED)         
36906                    WHERE PREMISE_NO = AT.PREMISE_NO )             
T35249                                       
ACT022                                                      
T35249     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.ACCOUNT_NO                                             
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.PREMISE_NO                                             
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*        INTO  :AT-ACCOUNT-NO                                             
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*        FROM  CSS_MTRD_ENVRNMT MN                                        
MFA-TR*             ,CSS_ACCOUNT AT                                             
MFA-TR*             ,CSS_CUST_PREM_HIST CH                                      
MFA-TR*        WHERE MN.ACCOUNT_NO        = AT.ACCOUNT_NO                       
MFA-TR*          AND CH.ACCOUNT_NO        = MN.ACCOUNT_NO                       
MFA-TR*          AND CH.PREMISE_NO        = AT.PREMISE_NO                       
MFA-TR*          AND MN.CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE                  
MFA-TR*          AND AT.COMPANY_NO        = :AT-COMPANY-NO                      
MFA-TR*          AND MN.METER_NO          = :MN-METER-NO                        
MFA-TR*          AND MN.CODE_METER_STATUS <> 'K'                                
MFA-TR*          AND CH.DATE_UTIL_SVC_STRT =                                    
MFA-TR*               ( SELECT MAX(DATE_UTIL_SVC_STRT)                          
MFA-TR*                   FROM CSS_CUST_PREM_HIST                               
MFA-TR*                  WHERE PREMISE_NO = AT.PREMISE_NO )                     
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7960                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35249*                                                                         
T35249     MOVE SQLCODE           TO  WS-ACTIVE-RETURN-CODE.            
T35249*                                                                         
T35249     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
T35249         NEXT SENTENCE                                            
T35249     ELSE                                                         
T35249         DISPLAY '** SELECT ERROR IN 7960-METER-ERR **'           
T35249         DISPLAY '** AT-COMPANY-NO      = ' AT-COMPANY-NO         
T35249         DISPLAY '** MN-CODE-UTIL-TYPE  = ' MN-CODE-UTIL-TYPE     
T35249         DISPLAY '** MN-METER-NO        = ' MN-METER-NO           
T35249         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
T35249         DISPLAY '**       PROCESSING TERMINATED       **'        
T35249         PERFORM 9900-ABEND        THRU 9900-EXIT                 
T35249     END-IF.                                                      
T35249*                                                                         
T35249 7960-EXIT.                                                       
T35249     EXIT.                                                        
      *                                                                         
C36856****************************************************************          
C36856**                                                            **          
C36856**   7970-OPEN-NON-INT.                                       **          
C36856**       TO OPEN CURSOR NON-INT-ERT                           **          
C36856**                                                            **          
C36856****************************************************************          
C36856*                                                                         
C36856 7970-OPEN-NON-INT.                                               
C36856*                                                                         
C36856     EXEC SQL                                                     
C36856         OPEN NON-INT-ERT                                         
C36856     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36856*                                                                         
C36856     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
C36856*                                                                         
C36856     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C36856         NEXT SENTENCE                                            
C36856     ELSE                                                         
C36856         DISPLAY '**  OPEN ERROR IN 7970-OPEN-NON-INT   **'       
C36856         DISPLAY '**    TABLE :  CSS_EQUIP_ATTCHMTS     **'       
C36856         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C36856         DISPLAY '** DEVICE-NO  = ' LX-DEVICE-NO                  
C36856         DISPLAY '**       PROCESSING TERMINATED        **'       
C36856         PERFORM 9000-TERMINATE     THRU 9000-EXIT                
C36856         PERFORM 9900-ABEND         THRU 9900-EXIT                
C36856     END-IF.                                                      
C36856*                                                                         
C36856 7970-EXIT.                                                       
C36856     EXIT.                                                        
C36856*                                                                         
C36856****************************************************************          
C36856**                                                            **          
C36856**   7980-FETCH-NON-INT.                                      **          
C36856**       TO FETCH FIELD DETAILS FROM CSS_EQUIP_ATTCHMTS       **          
C36856**                                                            **          
C36856****************************************************************          
C36856*                                                                         
C36856 7980-FETCH-NON-INT.                                              
C36856*                                                                         
C36856     EXEC SQL                                                     
C36856         FETCH                                                    
C36856             NON-INT-ERT                                          
C36856         INTO                                                     
C36856             :LX-DEVICE-NO,                                       
C36856             :LX-CODE-ATT-TYPE,                                   
C36856             :LX-EQUIP-LOC-ID,                                    
C36856             :LX-CODE-UTIL-TYPE,                                  
C36856             :LX-COMPANY-NO,                                      
C36856             :LX-DATE-LAST-MOVE,                                  
C36856             :LX-MTR-STORAGE-FAC-CD                               
C36856     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36856*                                                                         
C36856     MOVE SQLCODE           TO     WS-ACTIVE-RETURN-CODE.         
C36856*                                                                         
C36856     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C36856         NEXT SENTENCE                                            
C36856     ELSE                                                         
C36856         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
C36856             MOVE WS-Y TO WS-NON-INT-ERT-FLAG                     
C36856         ELSE                                                     
C36856             DISPLAY '**  FETCH ERROR IN 7980-FETCH-INT-ERT   **' 
C36856             DISPLAY '**     TABLE :  CSS_EQUIP_ATTCHMTS      **' 
C36856             DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
C36856             DISPLAY '** DEVICE-NO  = ' LX-DEVICE-NO              
C36856             DISPLAY '**       PROCESSING TERMINATED        **'   
C36856             PERFORM 9000-TERMINATE     THRU 9000-EXIT            
C36856             PERFORM 9900-ABEND         THRU 9900-EXIT            
C36856         END-IF                                                   
C36856     END-IF.                                                      
C36856*                                                                         
C36856 7980-EXIT.                                                       
C36856     EXIT.                                                        
C36856*                                                                         
C36856****************************************************************          
C36856**                                                            **          
C36856**   7990-CLOSE-NON-INT.                                      **          
C36856**       TO CLOSE CURSOR NON-INT-ERT                          **          
C36856**                                                            **          
C36856****************************************************************          
C36856*                                                                         
C36856 7990-CLOSE-NON-INT.                                              
C36856*                                                                         
C36856     EXEC SQL                                                     
C36856         CLOSE NON-INT-ERT                                        
C36856     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36856*                                                                         
C36856     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
C36856*                                                                         
C36856     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C36856         NEXT SENTENCE                                            
C36856     ELSE                                                         
C36856         DISPLAY '**  CLOSE ERROR IN 7990-CLOSE-NON-INT   **'     
C36856         DISPLAY '**    TABLE :  CSS_EQUIPMENT            **'     
C36856         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C36856         DISPLAY '**       PROCESSING TERMINATED        **'       
C36856         PERFORM 9000-TERMINATE     THRU 9000-EXIT                
C36856         PERFORM 9900-ABEND         THRU 9900-EXIT                
C36856     END-IF.                                                      
C36856*                                                                         
C36856 7990-EXIT.                                                       
C36856     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                                         
      *    8895-INSERT-WORK-QUEUE                                               
      *                                                                         
      *****************************************************************         
A04860*                                                                         
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860*                                                                         
A04860     CALL SCSCB077 USING CWS00077-FIELDS,                         
A04860                         ABEND-FILE,                              
A04860                         RS-RETURN-CODE                           
A04860     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     END-IF.                                                      
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
      *                                                                         
C36856****************************************************************          
C36856*         ISSUE COMMIT CHECKPOINT                                         
C36856*==============================================================*          
C36856 8898-ISSUE-CHKP.                                                 
C36856*==============================================================*          
C36856*                                                                         
C36856                                                                  
C36856     EXEC SQL                                                             
C36856         INCLUDE CPD00047                                                 
C36856     END-EXEC.                                                            
C36856                                                                  
C36856     DISPLAY 'COMMIT POINT # ' WS-CHKP-UPD-COUNTER ' TAKEN. '     
C36856     .                                                            
C36856 8898-EXIT.                                                       
C36856     EXIT.                                                        
C36856*                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      **                                                            **          
      ****************************************************************          
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSMT51                                                
                 FCSMT52.                                               
      *                                                                         
      * DUMMY PARA FOR ADDR FORMATTING ROUTINES                                 
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *DUMMY PARA FOR ADDR FORMATTING ROUTINES - EXECUTES 9900-ABEND            
       9900-SQL-ERROR-ROUTINE.                                          
      ******************************************************************        
      *     9900-ABEND                                                 *        
      *                                                                *        
      *     PERFORMED IF VSAM OR DB2 PROBLEM OCCURS.                   *        
      ******************************************************************        
      *                                                                         
       9900-ABEND.                                                      
      *                                                                         
           DISPLAY 'PERFORMING 9900-ABEND'.                             
      *                                                                         
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                      

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

      *                                                                         
           MOVE 12  TO  RETURN-CODE.                                    
           MOVE 'YES' TO WS-ABEND-SWITCH.                               
      *                                                                         
           IF WS-ABEND-YES                                              
               STOP RUN                                                 
           END-IF.                                                      
      *                                                                         
       9900-EXIT.                                                       
           EXIT.                                                        
