       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSMT301.                                        
       DATE-WRITTEN.   NOVEMBER, 1986.                                  
       DATE-COMPILED.                                                   
      ****************************************************************  PCS00050
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL              **  PCS00060
      **                     PRICE WATERHOUSE                       **  PCS00070
      **                1410 NORTH WESTSHORE BLVD                   **  PCS00080
      **                   TAMPA, FLORIDA  33607                    **  PCS00090
      **                      (813) 287-9200                        **  PCS00100
      **                                                            **  PCS00110
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                      DB2                       ********          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **    DATE    INITIALS     REASON                             **          
      **  ________  ________     _________________________________  **          
      **  07/12/95    LMB        CHANGED DEVICE_NO                  **          
      **                              TO DEVICE_TYPE_CD             **          
      **                         CHANGED IX-DEVICE-NO               **          
      **                              TO IX-DEVICE-TYPE-CD          **          
      **  --------  --------     ---------------------------------- **          
      **  03/06/96     DW        ADDED CODE_UTIL_TYPE TO SELECT OF  **          
      **                         CSS_ELEC_METER AND CSS_GAS_METER.  **          
PCR156**  09/96     CBSI         RENAMED WS-LOCAL-OFFICE-1,WS-LOCAL-**          
      **            MADRAS       OFFICE-2,E-FMT01-LOCAL-OFFICE TO   **          
      **                         WS-MTR-STORAGE-FAC-CD-1,           **  PCS00110
      **                         WS-MTR-STORAGE-FAC-CD-2,           **  PCS00110
      **                         E-FMT01-MTR-STORAGE-FAC-CD         **  PCS00110
PCR040**  12/96     CBSI         REMOVED ALL REFERENCES TO          **  PCS00110
PCR040**            MADRAS       CODE_CO_SIZE FIELD OF CSS_ELEC_METER*  PCS00110
PCR040**                         AS THIS FIELD IS REMOVED FROM THE  **  PCS00110
PCR040**                         TABLE                              **  PCS00110
T14799**   03/98    BAB          MODIFIED WS-DIS-DATE.              **          
T18652**   12/98    CBSI         CHANGES MADE TO EXTRACT THE DETAILS**          
T18652**                         OF THE ELEC, GAS & XFORMERS INTO   **  PCS00110
T18652**                         THREE FILES INSTEAD OF ONE FILE.   **  PCS00110
T19027**   02/99    CBSI         CODE CHANGED TO ADD 1 TO A 4-DIGIT **          
T19027**                         YEAR INSTEAD OF A 2-DIGIT YEAR.    **  PCS00110
T22243**   09/00    CBSI         CHANGES MADE TO IMPLEMENT MULTI-   **          
T22243**            CHENNAI      COMPANY IN METER INVENTORY.        **          
      **                                                            **          
C36457** 11/02/07   RC41079      DELETE REFERENCES TO CSS_WTR_SWR_  **          
C36457**                         METER AND TBWSMTR.                 **          
ACT123** 06/15/15   RS7M249      REMOVED UNUSED COPYBOOKS.          **          
      ****************************************************************          
T18652     REMARKS.                                                     
T18652                        PCSMT301 NARRATIVE                        
T18652                    PRS-CIS INTERFACE PROGRAM                     
      *                                                                 00007500
T18652           THIS PROGRAM EXTRACTS RETIRED ELECTRIC/GAS METERS,     
T18652           XFORMERS,AND ATTACHMENTS IN THE CURRENT MONTH INTO     
                 FOUR FILES. THESE FILES WILL BE SENT AS INPUT TO       
T18652           ELC300(ELECTRIC), GMC300(GAS), ELC301(XFORMERS),       
                 AND GMC301(ATTACHMENTS) PROGRAMS WHICH PRODUCE         
T18652           REPORTS FOR PRS SYSTEM.                                
      *                                                                 00007500
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                 00009500
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
      *                                                                 00011000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSMT01.                                                    00014500
       COPY CSSMT02.                                                    00014500
T18652 COPY CSSMT22.                                                    00014500
T18652 COPY CSSMT23.                                                    00014500
      ******************************************************************        
      * CSSMT26- SELECT STATEMENT FOR FCSMT26 FILE                     *        
      ******************************************************************        
T12999 COPY CSSMT26.                                                    00014500
      *                                                                 00015000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDMT01.                                                    00019000
       COPY FIOMT01.                                                    00019500
      *                                                                 00018500
       COPY CFDMT02.                                                    00019000
       COPY FIOMT02.                                                    00019500
      *                                                                 00020000
T18652 COPY CFDMT22.                                                    00019000
T18652 COPY FIOMT22.                                                    00019500
T18652*                                                                 00018500
T18652 COPY CFDMT23.                                                    00019000
T18652 COPY FIOMT23.                                                    00019500
T18652*                                                                 00018500
      ***************************************************************   00000100
      ** CFDMT26 - FILE DESCRIPTION FOR THE FILE FCSMT26           **   00000204
      ***************************************************************   00000300
T12999 COPY CFDMT26.                                                    00019000
      *                                                                 00002001
      ******************************************************************        
      * FIOMT26 - IO AREA FOR THE ATTACHMENT PROPERTY EXTRACT FILE     *        
      ******************************************************************        
T12999 COPY FIOMT26.                                                    00019500
T12999*                                                                 00018500
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSMT301'.
MSQ017     COPY MFASQLM.
      *                                                                 00020000
       77  WS-MIN-DIV-NO               PIC X(2).                        
       77  WS-MAX-DIV-NO               PIC X(2).                        
       77  WS-MAX-LOC                  PIC S9(04)   COMP.               
       77  WS-MIN-LOC                  PIC S9(04)   COMP.               
       77  WS-MAX-METER-NO             PIC X(09).                       
       77  WS-MIN-METER-NO             PIC X(09).                       
      *                                                                 00020000
       01  WORK-STORAGE-BEGIN.                                          
           05  FILLER                  PIC X(20)    VALUE               
               'WORKING STORAGE FOR '.                                  
           05  WS-PROGRAM-NAME         PIC X(08)    VALUE               
               'PCSMT301'.                                              
           05  FILLER                  PIC X(12)    VALUE               
               ' BEGINS HERE'.                                          
      *                                                                 00025000
       COPY FIOJC01.                                                    00018000
       COPY FIOCA00.                                                    00018000
       COPY CWS09900.                                                   00025500
      *                                                                 00026000
       COPY CWS00004.                                                   00025500
      *                                                                 00026000
       01  WS-CONSTANTS.                                                
           05  WS-1                    PIC X(01)    VALUE '1'.          
           05  WS-2                    PIC X(01)    VALUE '2'.          
           05  WS-3                    PIC X(01)    VALUE '3'.          
           05  WS-4                    PIC X(01)    VALUE '4'.          
           05  WS-5                    PIC X(01)    VALUE '5'.          
           05  WS-6                    PIC X(01)    VALUE '6'.          
           05  WS-7                    PIC X(01)    VALUE '7'.          
           05  WS-D                    PIC X(01)    VALUE 'D'.          
           05  WS-E                    PIC X(01)    VALUE 'E'.          
           05  WS-G                    PIC X(01)    VALUE 'G'.          
           05  WS-I                    PIC X(01)    VALUE 'I'.          
           05  WS-J                    PIC X(01)    VALUE 'J'.          
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-M                    PIC X(01)    VALUE 'M'.          
           05  WS-NO                   PIC X(01)    VALUE 'N'.          
           05  WS-MT                   PIC X(02)    VALUE 'MT'.         
           05  WS-TF                   PIC X(02)    VALUE 'TF'.         
           05  WS-PARAMETER-KEY.                                        
               10  WS-PARM-PROG        PIC X(08)    VALUE 'PCSMT301'.   
               10  WS-PARM-CMND        PIC X(04)    VALUE 'PARM'.       
               10  WS-PARM-SEQ         PIC 9(03)    VALUE ZERO.         
           05  WS-S                    PIC X(01)    VALUE 'S'.          
           05  WS-T                    PIC X(01)    VALUE 'T'.          
           05  WS-W                    PIC X(01)    VALUE 'W'.          
           05  WS-X                    PIC X(01)    VALUE 'X'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-YES                  PIC X(01)    VALUE 'Y'.          
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSMT301'.   
           05  WS-PCSMT301             PIC X(08)    VALUE 'PCSMT301'.   
      *                                                                         
       01  WS-88-LEVEL-FLAGS.                                           
           05  WS-EOF-MT-FLAG          PIC X(01)    VALUE 'N'.          
               88  EOF-MT                           VALUE 'Y'.          
           05  WS-EOF-PARM-FLAG        PIC X(01)    VALUE 'N'.          
               88  EOF-PARM                         VALUE 'Y'.          
           05  WS-PROCESS-ELEC-FLAG    PIC X(01)    VALUE 'N'.          
               88  PROCESS-ELECTRIC                 VALUE 'Y'.          
           05  WS-PROCESS-GAS-FLAG     PIC X(01)    VALUE 'N'.          
               88  PROCESS-GAS                      VALUE 'Y'.          
           05  WS-PROCESS-WATER-FLAG   PIC X(01)    VALUE 'N'.          
               88  PROCESS-WATER                    VALUE 'Y'.          
           05  WS-PROCESS-SEWER-FLAG   PIC X(01)    VALUE 'N'.          
               88  PROCESS-SEWER                    VALUE 'Y'.          
           05  WS-PROCESS-XFORMER-FLAG PIC X(01)    VALUE 'N'.          
               88  PROCESS-XFORMER                  VALUE 'Y'.          
           05  WS-PROCESS-ATTACH-FLAG PIC X(01)     VALUE 'N'.          
               88  PROCESS-ATTACH                   VALUE 'Y'.          
           05  WS-MOVE-ON-HOLD-FLAG    PIC X(01)    VALUE 'N'.          
               88  MOVE-ON-HOLD                     VALUE 'Y'.          
           05  WS-FIRST-A-FOUND-FLAG   PIC X(01)    VALUE 'N'.          
               88  FIRST-A-FOUND                    VALUE 'Y'.          
      *                                                                 00043000
       01  WS-WORKING-VARIABLES.                                        
           05  WS-CURR-DATE-YY-MM.                                      
               10  WS-CURR-DATE-YY     PIC 9(02).                       
               10  WS-CURR-DATE-MM     PIC 9(02).                       
           05  WS-COMPARE-DATE-YY-MM.                                   
               10  WS-COMPARE-DATE-YY  PIC 9(02).                       
               10  WS-COMPARE-DATE-MM  PIC 9(02).                       
T14799     05  WS-DIS-DATE.                                             
T19027         10  WS-DIS-CCYY.                                         
T19027             15  WS-DIS-CC       PIC 9(02).                       
T19027             15  WS-DIS-YY       PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-DIS-MM           PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-DIS-DD           PIC 9(02).                       
           05  WS-MOVE-DATE-1.                                          
T19027         10 WS-MOVE-CCYY-1       PIC 9(04).                       
               10 FILLER               PIC X(01)    VALUE '-'.          
               10 WS-MOVE-MM-1         PIC 9(02).                       
               10 FILLER               PIC X(01)    VALUE '-'.          
               10 WS-MOVE-DD-1         PIC 9(02).                       
           05  WS-MOVE-DATE-2.                                          
T19027         10 WS-MOVE-CCYY-2       PIC 9(04).                       
               10 FILLER               PIC X(01)    VALUE '-'.          
               10 WS-MOVE-MM-2         PIC 9(02).                       
               10 FILLER               PIC X(01)    VALUE '-'.          
               10 WS-MOVE-DD-2         PIC 9(02).                       
           05  WS-MOVE-TO-DATE-1       PIC X(10).                       
           05  WS-MOVE-TO-DATE-2       PIC X(10).                       
           05  WS-MOVE-TS-1.                                            
               10  WS-MOVE-TS-DATE-1   PIC X(10).                       
               10  FILLER              PIC X(09)    VALUE '-00.00.00'.  
               10  FILLER              PIC X(07)    VALUE '.000001'.    
           05  WS-MOVE-TS-1-R REDEFINES                                 
               WS-MOVE-TS-1            PIC X(26).                       
           05  WS-MOVE-TS-2.                                            
               10  WS-MOVE-TS-DATE-2   PIC X(10).                       
               10  FILLER              PIC X(09)    VALUE '-23.59.59'.  
               10  FILLER              PIC X(07)    VALUE '.999999'.    
           05  WS-MOVE-TS-2-R REDEFINES                                 
               WS-MOVE-TS-2            PIC X(26).                       
           05  WS-FMT01-STATUS         PIC X(02).                       
T18652     05  WS-FMT22-STATUS         PIC X(02).                       
T18652     05  WS-FMT23-STATUS         PIC X(02).                       
T12999     05  WS-FMT26-STATUS         PIC X(02).                       
           05  WS-MAX-E-OFF-LOC        PIC 9(03)    VALUE 999.          
           05  WS-MIN-E-OFF-LOC        PIC 9(03)    VALUE ZERO.         
           05  WS-MAX-E-METER-NO       PIC X(09)    VALUE               
                                                   '999999999'.         
           05  WS-MIN-E-METER-NO       PIC X(09)    VALUE SPACES.       
           05  WS-MAX-G-OFF-LOC        PIC 9(03)    VALUE 999.          
           05  WS-MIN-G-OFF-LOC        PIC 9(03)    VALUE ZERO.         
           05  WS-MAX-G-METER-NO       PIC X(09)    VALUE               
                                                   '999999999'.         
           05  WS-MIN-G-METER-NO       PIC X(09)    VALUE SPACES.       
           05  WS-MAX-W-OFF-LOC        PIC 9(03)    VALUE 999.          
           05  WS-MIN-W-OFF-LOC        PIC 9(03)    VALUE ZERO.         
           05  WS-MAX-W-METER-NO       PIC X(09)    VALUE               
                                                   '999999999'.         
           05  WS-MIN-W-METER-NO       PIC X(09)    VALUE SPACES.       
           05  WS-MAX-S-OFF-LOC        PIC 9(03)    VALUE 999.          
           05  WS-MIN-S-OFF-LOC        PIC 9(03)    VALUE ZERO.         
           05  WS-MAX-S-METER-NO       PIC X(09)    VALUE               
                                                   '999999999'.         
           05  WS-MIN-S-METER-NO       PIC X(09)    VALUE SPACES.       
           05  WS-MAX-X-OFF-LOC        PIC 9(03)    VALUE 999.          
           05  WS-MIN-X-OFF-LOC        PIC 9(03)    VALUE ZERO.         
           05  WS-MAX-XFORMER-NO       PIC X(09)    VALUE               
                                                   '999999999'.         
           05  WS-MIN-XFORMER-NO       PIC X(09)    VALUE SPACES.       
           05  WS-MAX-A-OFF-LOC        PIC 9(03)    VALUE 999.          
           05  WS-MIN-A-OFF-LOC        PIC 9(03)    VALUE ZERO.         
           05  WS-MAX-ATTACH-NO        PIC X(12)    VALUE               
                                                   '999999999999'.      
           05  WS-MIN-ATTACH-NO        PIC X(12)    VALUE SPACES.       
           05  WS-ABEND-SPACE          PIC X(01)    VALUE SPACES.       
           05  WS-ABEND-NUMERIC        REDEFINES                        
               WS-ABEND-SPACE          PIC 9(01).                       
           05  WS-NULLIND-DATE-PURCHASED                                
                                       PIC S9(04)   COMP VALUE ZEROES.  
           05  WS-NULLIND-DATE-DISPOSED                                 
                                       PIC S9(04)   COMP VALUE ZEROES.  
           05  WS-NULLIND-DATE-LAST-MOVE                                
                                       PIC S9(04)   COMP VALUE ZEROES.  
           05  WS-NULLIND-DATE-OBSOLETE                                 
                                       PIC S9(04)   COMP VALUE ZEROES.  
           05  WS-NULLIND-LOC-NO       PIC S9(04)   COMP VALUE ZEROES.  
           05  WS-FIOMT01-REC-COUNT    PIC 9(07)    COMP-3 VALUE ZEROES.
T18652     05  WS-FIOMT22-REC-COUNT    PIC 9(07)    COMP-3 VALUE ZEROES.
T18652     05  WS-FIOMT23-REC-COUNT    PIC 9(07)    COMP-3 VALUE ZEROES.
T12999     05  WS-FIOMT26-REC-COUNT    PIC 9(07)    COMP-3 VALUE ZEROES.
      *                                                                 00056000
       01  WS-METER-INFO.                                               
PCR156     05  WS-MTR-STORAGE-FAC-CD-1 PIC X(03).                       
PCR156     05  WS-MTR-STORAGE-FAC-CD-2 PIC X(03).                       
           05  WS-CODE-CRNT-LOC-1      PIC X(01).                       
           05  WS-CODE-CRNT-LOC-2      PIC X(01).                       
           05  WS-DATE-MOVE-1.                                          
               10  WS-DATE-MOVE-CC-1   PIC X(2).                        
               10  WS-DATE-MOVE-YY-1   PIC X(2).                        
               10  FILLER              PIC X.                           
               10  WS-DATE-MOVE-MM-1   PIC X(2).                        
               10  FILLER              PIC X.                           
               10  WS-DATE-MOVE-DD-1   PIC X(2).                        
           05  WS-DATE-MOVE-2.                                          
               10  WS-DATE-MOVE-CC-2   PIC X(2).                        
               10  WS-DATE-MOVE-YY-2   PIC X(2).                        
               10  FILLER              PIC X.                           
               10  WS-DATE-MOVE-MM-2   PIC X(2).                        
               10  FILLER              PIC X.                           
               10  WS-DATE-MOVE-DD-2   PIC X(2).                        
      *                                                                 00056000
       01  WS-METER-MOVEMENT-TYPES.                                     
           05  WS-TYPE-1               PIC 9(01)    VALUE 1.            
      *******  PURCHASE METER                                                   
           05  WS-TYPE-2               PIC 9(01)    VALUE 2.            
      *******  REACTIVATE METER                                                 
           05  WS-TYPE-3               PIC 9(01)    VALUE 3.            
      *******  MOVE METER TO                                                    
           05  WS-TYPE-4               PIC 9(01)    VALUE 4.            
      *******  REMOVE METER FROM ACCOUNT                                        
           05  WS-TYPE-5               PIC 9(01)    VALUE 5.            
      *******  JUNK METER                                                       
           05  WS-TYPE-6               PIC 9(01)    VALUE 6.            
      *******  JUNK METER                                                       
           05  WS-TYPE-7               PIC 9(01)    VALUE 7.            
      *******  MOVE FROM DIV TO ANOTHER DIV INVENTORY                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
       01  WS-PARAMETER-DATA REDEFINES WS-INPUT-DATA-BREAKDOWN.         
           05  WS-PARAMETER-NAME       PIC X(22).                       
               88  EXTR-ELEC                        VALUE               
                         'EXTRACT ELEC METERS = '.                      
               88  EXTR-GAS                         VALUE               
                         'EXTRACT GAS  METERS = '.                      
               88  EXTR-WATER                       VALUE               
                         'EXTRACT WTR  METERS = '.                      
               88  EXTR-SEWER                       VALUE               
                         'EXTRACT SWR  METERS = '.                      
               88  EXTR-XFORMER                     VALUE               
                         'EXTRACT    XFORMERS = '.                      
               88  EXTR-ATTACHMENTS                 VALUE               
                         'EXTRACT ATTACHMENTS = '.                      
               88  MIN-ELEC-OFF                     VALUE               
                         'MIN ELEC OFFICE LOC = '.                      
               88  MAX-ELEC-OFF                     VALUE               
                         'MAX ELEC OFFICE LOC = '.                      
               88  MIN-GAS-OFF                      VALUE               
                         'MIN GAS  OFFICE LOC = '.                      
               88  MAX-GAS-OFF                      VALUE               
                         'MAX GAS  OFFICE LOC = '.                      
               88  MIN-WATER-OFF                    VALUE               
                         'MIN WTR  OFFICE LOC = '.                      
               88  MAX-WATER-OFF                    VALUE               
                         'MAX WTR  OFFICE LOC = '.                      
               88  MIN-SEWER-OFF                    VALUE               
                         'MIN SWR  OFFICE LOC = '.                      
               88  MAX-SEWER-OFF                    VALUE               
                         'MAX SWR  OFFICE LOC = '.                      
               88  MIN-XFORMER-OFF                  VALUE               
                         'MIN XFMR OFFICE LOC = '.                      
               88  MAX-XFORMER-OFF                  VALUE               
                         'MAX XFMR OFFICE LOC = '.                      
               88  MIN-ATTACH-OFF                   VALUE               
                         'MIN ATT  OFFICE LOC = '.                      
               88  MAX-ATTACH-OFF                   VALUE               
                         'MAX ATT  OFFICE LOC = '.                      
               88  MIN-ELEC-METER                   VALUE               
                         'MIN ELEC METER NO   = '.                      
               88  MAX-ELEC-METER                   VALUE               
                         'MAX ELEC METER NO   = '.                      
               88  MIN-GAS-METER                    VALUE               
                         'MIN GAS  METER NO   = '.                      
               88  MAX-GAS-METER                    VALUE               
                         'MAX GAS  METER NO   = '.                      
               88  MIN-WATER-METER                  VALUE               
                         'MIN WTR  METER NO   = '.                      
               88  MAX-WATER-METER                  VALUE               
                         'MAX WTR  METER NO   = '.                      
               88  MIN-SEWER-METER                  VALUE               
                         'MIN SWR  METER NO   = '.                      
               88  MAX-SEWER-METER                  VALUE               
                         'MAX SWR  METER NO   = '.                      
               88  MIN-XFORMER                      VALUE               
                         'MIN    XFORMER NO   = '.                      
               88  MAX-XFORMER                      VALUE               
                         'MAX    XFORMER NO   = '.                      
               88  MIN-ATTACH-METER                 VALUE               
                         'MIN ATT  METER NO   = '.                      
               88  MAX-ATTACH-METER                 VALUE               
                         'MAX ATT  METER NO   = '.                      
           05  WS-PARAMETER-VALUE      PIC X(09).                       
           05  FILLER REDEFINES WS-PARAMETER-VALUE.                     
               10  WS-PARM-VAL-EXT     PIC X(01).                       
               10  FILLER              PIC X(08).                       
           05  FILLER REDEFINES WS-PARAMETER-VALUE.                     
               10  WS-PARM-VAL-OFF     PIC 9(03).                       
               10  FILLER              PIC X(06).                       
           05  FILLER REDEFINES WS-PARAMETER-VALUE.                     
               10  WS-PARM-VAL-MET     PIC X(09).                       
           05  FILLER                  PIC X(22).                       
      *                                                                         
       COPY CWS00039.                                                           
       COPY CWS00303.                                                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMVHIST                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBELMTR                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGASMTR                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBINXFOR                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQATTH                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
ST             DECLARE EQUIP_CURSOR CURSOR FOR                          
               SELECT  DEVICE_NO                                        
                      ,DATE_LAST_MOVE                                   
                      ,LOCAL_OFFICE                                     
                      ,CODE_CRNT_LOC                                    
                      ,DATE_PURCHASED                                   
                      ,DATE_DISPOSED_OF                                 
                      ,SERIAL_NO                                        
                      ,CODE_MAKE                                        
T22243                ,COMPANY_NO                                       
                FROM   CSS_EQUIPMENT  EQ                                
               WHERE   CODE_UTIL_TYPE   = :EQ-CODE-UTIL-TYPE            
                 AND   EQUIP_TYPE_CD    = :EQ-EQUIP-TYPE-CD             
                 AND   CODE_CRNT_LOC    = :EQ-CODE-CRNT-LOC             
T22243           AND   DATE_LAST_MOVE  >= IIF(TRY_CONVERT(DATE, 
                                                     :WS-MOVE-TO-DATE-1
              ) IS NULL OR (PATINDEX('%.%', :WS-MOVE-TO-DATE-1
              ) <> 0) OR (LEN(:WS-MOVE-TO-DATE-1
              ) <> 10), CIS.CHAR2DATE(:WS-MOVE-TO-DATE-1
              ), CONVERT(DATE, :WS-MOVE-TO-DATE-1) )            
T22243           AND   DATE_LAST_MOVE   < IIF(TRY_CONVERT(DATE, 
                                                     :WS-MOVE-TO-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-MOVE-TO-DATE-2
              ) <> 0) OR (LEN(:WS-MOVE-TO-DATE-2
              ) <> 10), CIS.CHAR2DATE(:WS-MOVE-TO-DATE-2
              ), CONVERT(DATE, :WS-MOVE-TO-DATE-2) )            
              ORDER BY DATE_PURCHASED                                   
END                   ,DEVICE_NO                                        
T18652     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE EQUIP_CURSOR CURSOR FOR                                  
MFA-TR*        SELECT  DEVICE_NO                                                
MFA-TR*               ,DATE_LAST_MOVE                                           
MFA-TR*               ,LOCAL_OFFICE                                             
MFA-TR*               ,CODE_CRNT_LOC                                            
MFA-TR*               ,DATE_PURCHASED                                           
MFA-TR*               ,DATE_DISPOSED_OF                                         
MFA-TR*               ,SERIAL_NO                                                
MFA-TR*               ,CODE_MAKE                                                
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*         FROM   CSS_EQUIPMENT  EQ                                        
MFA-TR*        WHERE   CODE_UTIL_TYPE   = :EQ-CODE-UTIL-TYPE                    
MFA-TR*          AND   EQUIP_TYPE_CD    = :EQ-EQUIP-TYPE-CD                     
MFA-TR*          AND   CODE_CRNT_LOC    = :EQ-CODE-CRNT-LOC                     
MFA-TR*          AND   DATE_LAST_MOVE  >= :WS-MOVE-TO-DATE-1                    
MFA-TR*          AND   DATE_LAST_MOVE   < :WS-MOVE-TO-DATE-2                    
MFA-TR*       ORDER BY DATE_PURCHASED                                           
MFA-TR*               ,DEVICE_NO                                                
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE ATTACH_CURSOR CURSOR FOR                         
               SELECT  DEVICE_NO                                        
                      ,CODE_ATT_TYPE                                    
                      ,COMPANY_NO                                       
                      ,CODE_UTIL_TYPE                                   
                      ,EQUIP_LOC_ID                                     
                      ,MTR_STORAGE_FAC_CD                               
                      ,CODE_MAKE                                        
                      ,DATE_LAST_MOVE                                   
                      ,DATE_PURCHASED                                   
                      ,DATE_OBSOLETE                                    
                FROM   CSS_EQUIP_ATTCHMTS LX                            
               WHERE   CODE_UTIL_TYPE   = :LX-CODE-UTIL-TYPE            
                 AND   CODE_ATT_TYPE    = :LX-CODE-ATT-TYPE             
                 AND   EQUIP_LOC_ID     = :LX-EQUIP-LOC-ID              
                 AND   DATE_LAST_MOVE  >= IIF(TRY_CONVERT(DATE, 
                                                     :WS-MOVE-TO-DATE-1
              ) IS NULL OR (PATINDEX('%.%', :WS-MOVE-TO-DATE-1
              ) <> 0) OR (LEN(:WS-MOVE-TO-DATE-1
              ) <> 10), CIS.CHAR2DATE(:WS-MOVE-TO-DATE-1
              ), CONVERT(DATE, :WS-MOVE-TO-DATE-1) )            
                 AND   DATE_LAST_MOVE   < IIF(TRY_CONVERT(DATE, 
                                                     :WS-MOVE-TO-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-MOVE-TO-DATE-2
              ) <> 0) OR (LEN(:WS-MOVE-TO-DATE-2
              ) <> 10), CIS.CHAR2DATE(:WS-MOVE-TO-DATE-2
              ), CONVERT(DATE, :WS-MOVE-TO-DATE-2) )            
              ORDER BY DATE_PURCHASED                                   
                      ,DEVICE_NO                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ATTACH_CURSOR CURSOR FOR                                 
MFA-TR*        SELECT  DEVICE_NO                                                
MFA-TR*               ,CODE_ATT_TYPE                                            
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,EQUIP_LOC_ID                                             
MFA-TR*               ,MTR_STORAGE_FAC_CD                                       
MFA-TR*               ,CODE_MAKE                                                
MFA-TR*               ,DATE_LAST_MOVE                                           
MFA-TR*               ,DATE_PURCHASED                                           
MFA-TR*               ,DATE_OBSOLETE                                            
MFA-TR*         FROM   CSS_EQUIP_ATTCHMTS LX                                    
MFA-TR*        WHERE   CODE_UTIL_TYPE   = :LX-CODE-UTIL-TYPE                    
MFA-TR*          AND   CODE_ATT_TYPE    = :LX-CODE-ATT-TYPE                     
MFA-TR*          AND   EQUIP_LOC_ID     = :LX-EQUIP-LOC-ID                      
MFA-TR*          AND   DATE_LAST_MOVE  >= :WS-MOVE-TO-DATE-1                    
MFA-TR*          AND   DATE_LAST_MOVE   < :WS-MOVE-TO-DATE-2                    
MFA-TR*       ORDER BY DATE_PURCHASED                                           
MFA-TR*               ,DEVICE_NO                                                
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE MVHCUR CURSOR FOR                                
               SELECT  CODE_DEVICE_TYPE,                                
                       DEVICE_NO,                                       
                       DATE_MOVE,                                       
                       MOVE_NO,                                         
                       LOCAL_OFFICE,                                    
                       LOC_NO,                                          
                       CODE_CRNT_LOC,                                   
                       CODE_UTIL_TYPE                                   
               FROM    CSS_MOVEMENT_HIST                                
               WHERE   CODE_UTIL_TYPE   =:MV-CODE-UTIL-TYPE             
                 AND   CODE_DEVICE_TYPE =:MV-CODE-DEVICE-TYPE           
                 AND   DATE_MOVE BETWEEN IIF(TRY_CONVERT(DATE, 
                                                     :WS-MOVE-TO-DATE-1
              ) IS NULL OR (PATINDEX('%.%', :WS-MOVE-TO-DATE-1
              ) <> 0) OR (LEN(:WS-MOVE-TO-DATE-1
              ) <> 10), CIS.CHAR2DATE(:WS-MOVE-TO-DATE-1
              ), CONVERT(DATE, :WS-MOVE-TO-DATE-1) )             
                                     AND IIF(TRY_CONVERT(DATE, 
                                                     :WS-MOVE-TO-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-MOVE-TO-DATE-2
              ) <> 0) OR (LEN(:WS-MOVE-TO-DATE-2
              ) <> 10), CIS.CHAR2DATE(:WS-MOVE-TO-DATE-2
              ), CONVERT(DATE, :WS-MOVE-TO-DATE-2) )             
               ORDER BY LOCAL_OFFICE,                                   
                        DEVICE_NO,                                      
                        MOVE_NO                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MVHCUR CURSOR FOR                                        
MFA-TR*        SELECT  CODE_DEVICE_TYPE,                                        
MFA-TR*                DEVICE_NO,                                               
MFA-TR*                DATE_MOVE,                                               
MFA-TR*                MOVE_NO,                                                 
MFA-TR*                LOCAL_OFFICE,                                            
MFA-TR*                LOC_NO,                                                  
MFA-TR*                CODE_CRNT_LOC,                                           
MFA-TR*                CODE_UTIL_TYPE                                           
MFA-TR*        FROM    CSS_MOVEMENT_HIST                                        
MFA-TR*        WHERE   CODE_UTIL_TYPE   =:MV-CODE-UTIL-TYPE                     
MFA-TR*          AND   CODE_DEVICE_TYPE =:MV-CODE-DEVICE-TYPE                   
MFA-TR*          AND   DATE_MOVE BETWEEN :WS-MOVE-TO-DATE-1                     
MFA-TR*                              AND :WS-MOVE-TO-DATE-2                     
MFA-TR*        ORDER BY LOCAL_OFFICE,                                           
MFA-TR*                 DEVICE_NO,                                              
MFA-TR*                 MOVE_NO                                                 
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE MVHCUR-2 CURSOR FOR                              
               SELECT  CODE_DEVICE_TYPE,                                
                       DEVICE_NO,                                       
                       DATE_MOVE,                                       
                       REPLACE(REPLACE(CONVERT(CHAR(26), MOVE_NO, 121), 
           ' ', '-'), ':', '.') MOVE_NO,                                       
                       LOCAL_OFFICE,                                    
                       LOC_NO,                                          
                       CODE_CRNT_LOC,                                   
                       CODE_UTIL_TYPE                                   
               FROM    CSS_MOVEMENT_HIST                                
               WHERE   CODE_DEVICE_TYPE =:MV-CODE-DEVICE-TYPE           
                 AND   DEVICE_NO        =:MV-DEVICE-NO                  
                 AND   MOVE_NO <         CIS.CHAR2TIMESTAMP(:MV-MOVE-NO)        
               ORDER BY MOVE_NO DESC                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MVHCUR-2 CURSOR FOR                                      
MFA-TR*        SELECT  CODE_DEVICE_TYPE,                                        
MFA-TR*                DEVICE_NO,                                               
MFA-TR*                DATE_MOVE,                                               
MFA-TR*                MOVE_NO,                                                 
MFA-TR*                LOCAL_OFFICE,                                            
MFA-TR*                LOC_NO,                                                  
MFA-TR*                CODE_CRNT_LOC,                                           
MFA-TR*                CODE_UTIL_TYPE                                           
MFA-TR*        FROM    CSS_MOVEMENT_HIST                                        
MFA-TR*        WHERE   CODE_DEVICE_TYPE =:MV-CODE-DEVICE-TYPE                   
MFA-TR*          AND   DEVICE_NO        =:MV-DEVICE-NO                          
MFA-TR*          AND   MOVE_NO <         :MV-MOVE-NO                            
MFA-TR*        ORDER BY MOVE_NO DESC                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE MVH-JUNK CURSOR FOR                              
               SELECT  CODE_DEVICE_TYPE,                                
                       DEVICE_NO,                                       
                       DATE_MOVE,                                       
                       REPLACE(REPLACE(CONVERT(CHAR(26), MOVE_NO, 121), 
           ' ', '-'), ':', '.') MOVE_NO,                                       
                       LOCAL_OFFICE,                                    
                       LOC_NO,                                          
                       CODE_CRNT_LOC,                                   
                       CODE_UTIL_TYPE                                   
               FROM    CSS_MOVEMENT_HIST                                
               WHERE   CODE_CRNT_LOC    =:WS-2                          
                 AND   MOVE_NO   BETWEEN CIS.CHAR2TIMESTAMP(
                                                        :WS-MOVE-TS-1-R
              )                
                                     AND CIS.CHAR2TIMESTAMP(
                                                        :WS-MOVE-TS-2-R
              )                
               ORDER BY MOVE_NO DESC                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MVH-JUNK CURSOR FOR                                      
MFA-TR*        SELECT  CODE_DEVICE_TYPE,                                        
MFA-TR*                DEVICE_NO,                                               
MFA-TR*                DATE_MOVE,                                               
MFA-TR*                MOVE_NO,                                                 
MFA-TR*                LOCAL_OFFICE,                                            
MFA-TR*                LOC_NO,                                                  
MFA-TR*                CODE_CRNT_LOC,                                           
MFA-TR*                CODE_UTIL_TYPE                                           
MFA-TR*        FROM    CSS_MOVEMENT_HIST                                        
MFA-TR*        WHERE   CODE_CRNT_LOC    =:WS-2                                  
MFA-TR*          AND   MOVE_NO   BETWEEN :WS-MOVE-TS-1-R                        
MFA-TR*                              AND :WS-MOVE-TS-2-R                        
MFA-TR*        ORDER BY MOVE_NO DESC                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                 00081500
       01  WORK-STORAGE-END            PIC X(38)    VALUE               
              'WORKING STORAGE FOR PCSMT301 ENDS HERE'.                 
      *                                                                 00081500
       PROCEDURE DIVISION.                                              
      *                                                                 00084500
      ****************************************************************          
      **                                                            **          
      **  0000-MAIN                                                 **          
      **      CONTROLS MAIN PROCESSING                              **          
      **                                                            **          
      ****************************************************************          
       0000-MAIN.                                                       
      *                                                                 00084500
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
      *                                                                 00084500
           PERFORM 0200-PROCESS-BEGIN-CONTROL-REC                       
                                                 THRU 0200-EXIT.        
           PERFORM 1000-PROCESS-INPUT            THRU 1000-EXIT.        
           PERFORM 8900-PROCESS-END-CONTROL-REC  THRU 8900-EXIT.        
      *                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0100-INITIALIZATION                                       **          
      **      COMMON INITIALIZATION ROUTINE                         **          
      **                                                            **          
      ****************************************************************          
       0100-INITIALIZATION.                                             
      *                                                                 00089000
      *    OPEN INPUT FCSCA00-FILE.                                             
      *                                                                 00089000
      *    IF FCA00-SUCCESSFUL                                                  
      *        CONTINUE                                                         
      *    ELSE                                                                 
      *        DISPLAY '0100-ERROR ON FCSCA00 OPEN.  STATUS IS '                
      *                 WS-FCA00-STATUS                                         
      *        PERFORM 9900-ABEND                THRU 9900-EXIT                 
      *    END-IF.                                                              
      *                                                                 00089000
      *    OPEN INPUT FCSJC01-FILE.                                             
      *                                                                 00089000
      *    IF FJC01-SUCCESSFUL                                                  
      *        CONTINUE                                                         
      *    ELSE                                                                 
      *        DISPLAY '0100-ERROR ON FCSJC01 OPEN.  STATUS IS '                
      *                 WS-FJC01-STATUS                                         
      *        PERFORM 9900-ABEND                 THRU 9900-EXIT                
      *    END-IF.                                                              
      *                                                                 00089000
           MOVE WS-PGRMNAME            TO WS-PROGRAM.                   
           MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
           PERFORM 7600-START-FCSJC01            THRU 7600-EXIT.        
           PERFORM 7610-READ-FCSJC01             THRU 7610-EXIT         
               UNTIL (RUN-DATE AND INPUT-ACTIVE)                        
                  OR  END-OF-SYSIPT.                                    
      *                                                                 00089000
           IF NOT END-OF-SYSIPT                                         
               PERFORM 7611-CLOSE                THRU 7611-EXIT         
           END-IF.                                                      
      *                                                                 04534000
           IF END-OF-SYSIPT                                             
               MOVE 'COMMON  '         TO WS-PROGRAM                    
               MOVE 'DATE'             TO WS-COMMAND                    
               MOVE SPACES             TO WS-SYSIPT                     
               MOVE ZERO               TO WS-SEQUENCE                   
               MOVE WS-KEY-AREA        TO E-FJC01-KEY                   
               PERFORM 7600-START-FCSJC01        THRU 7600-EXIT         
               PERFORM 7610-READ-FCSJC01         THRU 7610-EXIT         
                   UNTIL (RUN-DATE AND INPUT-ACTIVE)                    
                      OR  END-OF-SYSIPT                                 
      *                                                                 04542600
               IF END-OF-SYSIPT                                         
                   DISPLAY '*** PROCESSING ERROR IN PCSMT301  ***'      
                   DISPLAY '*** NO ACTIVE DATE CARD IN COMMON ***'      
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               ELSE                                                     
                   PERFORM 7611-CLOSE            THRU 7611-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                 04542600
           MOVE WS-INPUT-RUN-DATE      TO WS-INPUT-DATE.                
           MOVE WS-INPUT-DATE          TO WS-DIS-DATE.                  
           PERFORM 0130-PROCESS-MOVE-DATE        THRU 0130-EXIT.        
           MOVE WS-DIS-MM              TO WS-CURR-DATE-MM.              
           MOVE WS-DIS-YY              TO WS-CURR-DATE-YY.              
           PERFORM 6243-GET-FCA00-UTIL-TYPES     THRU 6243-EXIT.        
           MOVE WS-PGRMNAME            TO WS-PROGRAM.                   
           MOVE WS-PARM                TO WS-COMMAND.                   
           MOVE ZEROS                  TO WS-SEQUENCE.                  
           MOVE SPACES                 TO WS-SYSIPT.                    
           MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
           PERFORM 7600-START-FCSJC01            THRU 7600-EXIT.        
           PERFORM 7610-READ-FCSJC01             THRU 7610-EXIT.        
           PERFORM 0110-PROCESS-PARAMETER-FILE   THRU 0110-EXIT         
               UNTIL (WS-PGRMNAME NOT EQUAL WS-PROGRAM)                 
                  OR  END-OF-SYSIPT.                                    
      *                                                                 04534000
           IF NOT END-OF-SYSIPT                                         
               PERFORM 7611-CLOSE                THRU 7611-EXIT         
           END-IF.                                                      
      *                                                                 04534000
      *    CLOSE                                                        00098000
      *        FCSJC01-FILE.                                            00098500
      *                                                                 04534000
           OPEN                                                         
               OUTPUT FCSMT01-FILE,                                     
                      FCSMT02-FILE,                                     
T18652                FCSMT22-FILE,                                     
T18652                FCSMT23-FILE,                                     
T12999                FCSMT26-FILE.                                     
      *                                                                 04534000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0110-PROCESS-PARAMETER-FILE                               **          
      **                                                            **          
      ****************************************************************          
       0110-PROCESS-PARAMETER-FILE.                                     
      *                                                                 00102500
           IF E-FJC01-CMND-CODE EQUAL WS-PARM                           
               IF E-FJC01-STATUS EQUAL WS-A                             
                   PERFORM 0120-HANDLE-PARM      THRU 0120-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                 00102500
           PERFORM 7610-READ-FCSJC01             THRU 7610-EXIT.        
      *                                                                 00102500
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0120-HANDLE-PARM                                          **          
      **                                                            **          
      ****************************************************************          
       0120-HANDLE-PARM.                                                
      *                                                                 00107000
           MOVE E-FJC01-PARAMETER-DATA TO WS-PARAMETER-DATA.            
      *                                                                 00107000
           IF EXTR-ELEC                                                 
               IF WS-PARM-VAL-EXT EQUAL WS-YES OR WS-NO                 
                   MOVE WS-PARM-VAL-EXT                                 
                                       TO WS-PROCESS-ELEC-FLAG          
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF EXTR-GAS                                                  
               IF WS-PARM-VAL-EXT EQUAL WS-YES OR WS-NO                 
                   MOVE WS-PARM-VAL-EXT                                 
                                       TO WS-PROCESS-GAS-FLAG           
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
T18652*    IF EXTR-WATER                                                        
ST    *        IF WS-PARM-VAL-EXT EQUAL WS-YES OR WS-NO                         
      *            MOVE WS-PARM-VAL-EXT                                         
      *                                TO WS-PROCESS-WATER-FLAG                 
      *        ELSE                                                             
      *            PERFORM 9110-INVALID-PARAMETER                               
      *                                          THRU 9110-EXIT                 
      *        END-IF                                                           
      *    ELSE                                                                 
      *    IF EXTR-SEWER                                                        
      *        IF WS-PARM-VAL-EXT EQUAL WS-YES OR WS-NO                         
      *            MOVE WS-PARM-VAL-EXT                                         
      *                                TO WS-PROCESS-SEWER-FLAG                 
      *        ELSE                                                             
      *            PERFORM 9110-INVALID-PARAMETER                               
      *                                          THRU 9110-EXIT                 
END   *        END-IF                                                           
T18652*    ELSE                                                                 
           IF EXTR-XFORMER                                              
               IF WS-PARM-VAL-EXT EQUAL WS-YES OR WS-NO                 
                   MOVE WS-PARM-VAL-EXT                                 
                                       TO WS-PROCESS-XFORMER-FLAG       
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF EXTR-ATTACHMENTS                                          
               IF WS-PARM-VAL-EXT EQUAL WS-YES OR WS-NO                 
                   MOVE WS-PARM-VAL-EXT                                 
                                       TO WS-PROCESS-ATTACH-FLAG        
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF MIN-ELEC-OFF                                              
               IF WS-PARM-VAL-OFF NUMERIC                               
                   MOVE WS-PARM-VAL-OFF                                 
                                       TO WS-MIN-E-OFF-LOC              
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF MAX-ELEC-OFF                                              
               IF WS-PARM-VAL-OFF NUMERIC                               
                   MOVE WS-PARM-VAL-OFF                                 
                                       TO WS-MAX-E-OFF-LOC              
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF MIN-GAS-OFF                                               
               IF WS-PARM-VAL-OFF NUMERIC                               
                   MOVE WS-PARM-VAL-OFF                                 
                                       TO WS-MIN-G-OFF-LOC              
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF MAX-GAS-OFF                                               
               IF WS-PARM-VAL-OFF NUMERIC                               
                   MOVE WS-PARM-VAL-OFF                                 
                                       TO WS-MAX-G-OFF-LOC              
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
T18652*    IF MIN-WATER-OFF                                                     
ST    *        IF WS-PARM-VAL-OFF NUMERIC                                       
      *            MOVE WS-PARM-VAL-OFF                                         
      *                                TO WS-MIN-W-OFF-LOC                      
      *        ELSE                                                             
      *            PERFORM 9110-INVALID-PARAMETER                               
      *                                          THRU 9110-EXIT                 
      *        END-IF                                                           
      *    ELSE                                                                 
      *    IF MAX-WATER-OFF                                                     
      *        IF WS-PARM-VAL-OFF NUMERIC                                       
      *            MOVE WS-PARM-VAL-OFF                                         
      *                                TO WS-MAX-W-OFF-LOC                      
      *        ELSE                                                             
      *            PERFORM 9110-INVALID-PARAMETER                               
      *                                          THRU 9110-EXIT                 
      *        END-IF                                                           
      *    ELSE                                                                 
      *    IF MIN-SEWER-OFF                                                     
      *        IF WS-PARM-VAL-OFF NUMERIC                                       
      *            MOVE WS-PARM-VAL-OFF                                         
      *                                TO WS-MIN-S-OFF-LOC                      
      *        ELSE                                                             
      *            PERFORM 9110-INVALID-PARAMETER                               
      *                                          THRU 9110-EXIT                 
      *        END-IF                                                           
      *    ELSE                                                                 
      *    IF MAX-SEWER-OFF                                                     
      *        IF WS-PARM-VAL-OFF NUMERIC                                       
      *            MOVE WS-PARM-VAL-OFF                                         
      *                                TO WS-MAX-S-OFF-LOC                      
      *        ELSE                                                             
      *            PERFORM 9110-INVALID-PARAMETER                               
      *                                          THRU 9110-EXIT                 
END   *        END-IF                                                           
T18652*    ELSE                                                                 
           IF MIN-XFORMER-OFF                                           
               IF WS-PARM-VAL-OFF NUMERIC                               
                   MOVE WS-PARM-VAL-OFF                                 
                                       TO WS-MIN-X-OFF-LOC              
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF MAX-XFORMER-OFF                                           
               IF WS-PARM-VAL-OFF NUMERIC                               
                   MOVE WS-PARM-VAL-OFF                                 
                                       TO WS-MAX-X-OFF-LOC              
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF MIN-ATTACH-OFF                                            
               IF WS-PARM-VAL-OFF NUMERIC                               
                   MOVE WS-PARM-VAL-OFF                                 
                                       TO WS-MIN-A-OFF-LOC              
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF MAX-ATTACH-OFF                                            
               IF WS-PARM-VAL-OFF NUMERIC                               
                   MOVE WS-PARM-VAL-OFF                                 
                                       TO WS-MAX-A-OFF-LOC              
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF MIN-ELEC-METER                                            
               MOVE WS-PARM-VAL-MET    TO WS-MIN-E-METER-NO             
           ELSE                                                         
           IF MAX-ELEC-METER                                            
               MOVE WS-PARM-VAL-MET    TO WS-MAX-E-METER-NO             
           ELSE                                                         
           IF MIN-GAS-METER                                             
               MOVE WS-PARM-VAL-MET    TO WS-MIN-G-METER-NO             
           ELSE                                                         
           IF MAX-GAS-METER                                             
               MOVE WS-PARM-VAL-MET    TO WS-MAX-G-METER-NO             
           ELSE                                                         
T18652*    IF MIN-WATER-METER                                                   
ST    *        MOVE WS-PARM-VAL-MET    TO WS-MIN-W-METER-NO                     
      *    ELSE                                                                 
      *    IF MAX-WATER-METER                                                   
      *        MOVE WS-PARM-VAL-MET    TO WS-MAX-W-METER-NO                     
      *    ELSE                                                                 
      *    IF MIN-SEWER-METER                                                   
      *        MOVE WS-PARM-VAL-MET    TO WS-MIN-S-METER-NO                     
      *    ELSE                                                                 
      *    IF MAX-SEWER-METER                                                   
END   *        MOVE WS-PARM-VAL-MET    TO WS-MAX-S-METER-NO                     
T18652*    ELSE                                                                 
           IF MIN-XFORMER                                               
               MOVE WS-PARM-VAL-MET    TO WS-MIN-XFORMER-NO             
           ELSE                                                         
           IF MAX-XFORMER                                               
               MOVE WS-PARM-VAL-MET    TO WS-MAX-XFORMER-NO             
           ELSE                                                         
           IF MIN-ATTACH-METER                                          
               MOVE WS-PARM-VAL-MET    TO WS-MIN-ATTACH-NO              
           ELSE                                                         
           IF MAX-ATTACH-METER                                          
               MOVE WS-PARM-VAL-MET    TO WS-MAX-ATTACH-NO              
           ELSE                                                         
               PERFORM 9110-INVALID-PARAMETER    THRU 9110-EXIT         
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF.                                                      
      *                                                                         
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0130-PROCESS-MOVE-DATE                                    **          
      **                                                            **          
      ****************************************************************          
       0130-PROCESS-MOVE-DATE.                                          
      *                                                                         
T19027     MOVE WS-DIS-CCYY            TO WS-MOVE-CCYY-1,               
                                          WS-MOVE-CCYY-2.               
           MOVE 01                     TO WS-MOVE-DD-1,                 
                                          WS-MOVE-DD-2.                 
           MOVE WS-DIS-MM              TO WS-MOVE-MM-1,                 
                                          WS-MOVE-MM-2.                 
           ADD 1                       TO WS-MOVE-MM-2.                 
      *                                                                         
           IF WS-MOVE-MM-2 EQUAL 13                                     
T19027         ADD 1                   TO WS-MOVE-CCYY-2                
               MOVE 01                 TO WS-MOVE-MM-2                  
           END-IF.                                                      
      *                                                                         
           MOVE WS-MOVE-DATE-1         TO WS-MOVE-TO-DATE-1,            
                                          WS-MOVE-TS-DATE-1.            
           MOVE WS-MOVE-DATE-2         TO WS-MOVE-TO-DATE-2,            
                                          WS-MOVE-TS-DATE-2.            
      *                                                                         
       0130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00140500
      ****************************************************************          
      **                                                            **          
      **  0200-PROCESS-BEGIN-CONTROL-REC                            **          
      **                                                            **          
      ****************************************************************          
       0200-PROCESS-BEGIN-CONTROL-REC.                                  
      *                                                                 00140500
           MOVE LOW-VALUES             TO E-FMT01-KEY-BREC.             
           MOVE WS-INPUT-DATE          TO E-FMT01-CREATE-DATE-BREC.     
           PERFORM 8000-WRITE-FCSMT01            THRU 8000-EXIT.        
           MOVE SPACES                 TO FIOMT01.                      
      *                                                                 00140500
T18652     MOVE LOW-VALUES             TO E-FMT22-KEY-BREC.             
           MOVE WS-INPUT-DATE          TO E-FMT22-CREATE-DATE-BREC.     
           PERFORM 8200-WRITE-FCSMT22            THRU 8200-EXIT.        
           MOVE SPACES                 TO FIOMT22.                      
      *                                                                 00140500
           MOVE LOW-VALUES             TO E-FMT23-KEY-BREC.             
           MOVE WS-INPUT-DATE          TO E-FMT23-CREATE-DATE-BREC.     
           PERFORM 8300-WRITE-FCSMT23            THRU 8300-EXIT.        
           MOVE SPACES                 TO FIOMT23.                      
T18652*                                                                 00140500
           MOVE LOW-VALUES             TO E-FMT26-KEY-BREC.             
           MOVE WS-INPUT-DATE          TO E-FMT26-CREATE-DATE-BREC.     
           PERFORM 8400-WRITE-FCSMT26            THRU 8400-EXIT.        
           MOVE SPACES                 TO FIOMT26.                      
      *                                                                 00140500
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00140500
      ****************************************************************          
      **                                                            **          
      **  1000-PROCESS-INPUT                                        **          
      **                                                            **          
      ****************************************************************          
       1000-PROCESS-INPUT.                                              
      *                                                                 00140500
           DISPLAY 'PROCESS ELEC = ' WS-PROCESS-ELEC-FLAG.              
           DISPLAY 'PROCESS GAS  = ' WS-PROCESS-GAS-FLAG.               
           DISPLAY 'PROCESS WTR  = ' WS-PROCESS-WATER-FLAG.             
           DISPLAY 'PROCESS SWR  = ' WS-PROCESS-SEWER-FLAG.             
           DISPLAY 'PROCESS XFRM = ' WS-PROCESS-XFORMER-FLAG.           
           DISPLAY 'PROCESS ATT  = ' WS-PROCESS-ATTACH-FLAG.            
      *                                                                 00140500
           IF PROCESS-ELECTRIC                                          
               PERFORM 1100-PROCESS-ELECTRIC      THRU 1100-EXIT        
           END-IF.                                                      
      *                                                                         
           IF PROCESS-GAS                                               
               PERFORM 1200-PROCESS-GAS           THRU 1200-EXIT        
           END-IF.                                                      
      *                                                                         
T18652*    IF PROCESS-WATER                                                     
ST    *        PERFORM 1300-PROCESS-WATER         THRU 1300-EXIT                
      *    END-IF.                                                              
      *                                                                         
      *    IF PROCESS-SEWER                                                     
END   *        PERFORM 1400-PROCESS-SEWER         THRU 1400-EXIT                
T18652*    END-IF.                                                              
      *                                                                         
           IF PROCESS-XFORMER                                           
               PERFORM 1500-PROCESS-XFORMER      THRU 1500-EXIT         
           END-IF.                                                      
      *                                                                         
           IF PROCESS-ATTACH                                            
               PERFORM 1600-PROCESS-ATTACHMENT   THRU 1600-EXIT         
           END-IF.                                                      
      *                                                                         
           PERFORM 2000-PROCESS-JUNK-EQUIP       THRU 2000-EXIT.        
      *                                                                 00140500
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00140500
      ****************************************************************          
      **                                                            **          
      **  1100-PROCESS-ELECTRIC                                     **          
      **                                                            **          
      ****************************************************************          
       1100-PROCESS-ELECTRIC.                                           
      *                                                                 00145000
T18652     MOVE WS-E                   TO EQ-CODE-UTIL-TYPE.            
T18652     MOVE WS-M                   TO EQ-EQUIP-TYPE-CD.             
T18652     MOVE WS-I                   TO EQ-CODE-CRNT-LOC.             
T18652     PERFORM 7000-OPEN-EQUIP-CURSOR THRU 7000-EXIT.               
      *                                                                 00145000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T18652         PERFORM 7001-FETCH-EQUIP-CURSOR THRU 7001-EXIT           
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
T22243             MOVE EQ-COMPANY-NO  TO EM-COMPANY-NO                 
                   PERFORM 1110-PROCESS-ELEC-MTD THRU 1110-EXIT         
                      UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
T18652                   OR EQ-DEVICE-NO GREATER THAN WS-MAX-E-METER-NO 
T18652                 PERFORM 7002-CLOSE-EQUIP-CURSOR                  
                                                 THRU 7002-EXIT         
               ELSE                                                     
T18652             PERFORM 7002-CLOSE-EQUIP-CURSOR                      
                                                 THRU 7002-EXIT         
               END-IF                                                   
           ELSE                                                         
T18652         PERFORM 7002-CLOSE-EQUIP-CURSOR THRU 7002-EXIT           
           END-IF.                                                      
      *                                                                 00155000
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00155000
      ****************************************************************          
      **                                                            **          
      **  1110-PROCESS-ELEC-MTD                                     **          
      **                                                            **          
      ****************************************************************          
       1110-PROCESS-ELEC-MTD.                                           
      *                                                                 00156000
T18652     PERFORM 1115-GATHER-ELEC-MTD-INFO THRU 1115-EXIT.            
      *                                                                 00156000
T18652     PERFORM 7001-FETCH-EQUIP-CURSOR THRU 7001-EXIT.              
      *                                                                 00165000
       1110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00165000
      ****************************************************************          
      **                                                            **          
      **  1115-GATHER-ELEC-MTD-INFO                                 **          
      **                                                            **          
      ****************************************************************          
       1115-GATHER-ELEC-MTD-INFO.                                       
      *                                                                 00165000
T18652     MOVE WS-E                   TO E-FMT22-UTL-TYPE.             
T18652     MOVE EQ-DEVICE-NO           TO E-FMT22-METER-NO.             
           PERFORM 7010-SELECT-EQUIPMENT         THRU 7010-EXIT.        
      *                                                                 00165000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               PERFORM 7020-SELECT-ELEC-METER    THRU 7020-EXIT         
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   PERFORM 1120-PROCESS-ELEC-MTB THRU 1120-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                 00165000
       1115-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00165000
      ****************************************************************          
      **                                                            **          
      **  1120-PROCESS-ELEC-MTB                                     **          
      **                                                            **          
      ****************************************************************          
       1120-PROCESS-ELEC-MTB.                                           
      *                                                                 00166000
T18652     MOVE EQ-CODE-MAKE           TO E-FMT22-CODE-MAKE.            
T18652     MOVE EQ-SERIAL-NO           TO E-FMT22-SERIAL-NO.            
T18652     MOVE EM-ELEC-MTR-CLASS-CD   TO E-FMT22-MTR-CLASS-CD.         
T18652     MOVE EM-ELEC-MTR-SPEC-CD    TO E-FMT22-MTR-SPEC-CD.          
T18652     MOVE EQ-LOCAL-OFFICE        TO E-FMT22-MTR-STORAGE-FAC-CD.   
T18652     MOVE EQ-CODE-CRNT-LOC       TO E-FMT22-CODE-CRNT-LOC.        
T18652     MOVE EQ-DATE-PURCHASED(1:4) TO E-FMT22-YEAR-PURCHASED.       
T18652     MOVE EQ-DATE-LAST-MOVE      TO E-FMT22-DATE-RETIRED.         
T22243     MOVE EQ-COMPANY-NO          TO E-FMT22-COMPANY-NO.           
T18652     PERFORM 8200-WRITE-FCSMT22 THRU 8200-EXIT.                   
T18652     MOVE SPACES                 TO FIOMT22.                      
      *                                                                 00166000
       1120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00171500
      ****************************************************************          
      **                                                            **          
      **  1200-PROCESS-GAS                                          **          
      **                                                            **          
      ****************************************************************          
       1200-PROCESS-GAS.                                                
      *                                                                 00200000
T18652     MOVE WS-G                   TO EQ-CODE-UTIL-TYPE.            
T18652     MOVE WS-M                   TO EQ-EQUIP-TYPE-CD.             
T12999     MOVE WS-I                   TO EQ-CODE-CRNT-LOC.             
           MOVE WS-MIN-G-OFF-LOC       TO WS-MIN-LOC.                   
           MOVE WS-MAX-G-OFF-LOC       TO WS-MAX-LOC.                   
           MOVE WS-MIN-G-METER-NO      TO WS-MIN-METER-NO.              
           MOVE WS-MAX-G-METER-NO      TO WS-MAX-METER-NO.              
T18652     PERFORM 7000-OPEN-EQUIP-CURSOR THRU 7000-EXIT.               
      *                                                                 00200000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T18652         PERFORM 7001-FETCH-EQUIP-CURSOR THRU 7001-EXIT           
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   PERFORM 1210-PROCESS-GAS-MTD  THRU 1210-EXIT         
                      UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
T18652                   OR EQ-DEVICE-NO GREATER THAN WS-MAX-G-METER-NO 
T18652                 PERFORM 7002-CLOSE-EQUIP-CURSOR                  
                                                 THRU 7002-EXIT         
               ELSE                                                     
T18652             PERFORM 7002-CLOSE-EQUIP-CURSOR                      
                                                 THRU 7002-EXIT         
               END-IF                                                   
           ELSE                                                         
T18652         PERFORM 7002-CLOSE-EQUIP-CURSOR  THRU 7002-EXIT          
           END-IF.                                                      
      *                                                                 00209500
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00209500
      ****************************************************************          
      **                                                            **          
      **  1210-PROCESS-GAS-MTD                                      **          
      **                                                            **          
      ****************************************************************          
       1210-PROCESS-GAS-MTD.                                            
      *                                                                 00210500
T18652     PERFORM 1215-GATHER-GAS-MTD-INFO  THRU 1215-EXIT.            
      *                                                                 00210500
T18652     PERFORM 7001-FETCH-EQUIP-CURSOR THRU 7001-EXIT.              
      *                                                                 00219500
       1210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00219500
      ****************************************************************          
      **                                                            **          
      **  1215-GATHER-GAS-MTD-INFO                                  **          
      **                                                            **          
      ****************************************************************          
       1215-GATHER-GAS-MTD-INFO.                                        
      *                                                                 00219500
           MOVE WS-G                   TO E-FMT01-UTL-TYPE.             
T18652     MOVE EQ-DEVICE-NO           TO E-FMT01-METER-NO.             
           PERFORM 7010-SELECT-EQUIPMENT         THRU 7010-EXIT.        
      *                                                                 00219500
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T22243         MOVE EQ-COMPANY-NO  TO GM-COMPANY-NO                     
               PERFORM 7030-SELECT-GAS-METER     THRU 7030-EXIT         
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   PERFORM 1220-PROCESS-GAS-MTB  THRU 1220-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                 00219500
       1215-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00219500
      ****************************************************************          
      **                                                            **          
      **  1220-PROCESS-GAS-MTB                                      **          
      **                                                            **          
      ****************************************************************          
       1220-PROCESS-GAS-MTB.                                            
      *                                                                 00220500
           MOVE EQ-CODE-MAKE           TO E-FMT01-CODE-MAKE.            
           MOVE EQ-SERIAL-NO           TO E-FMT01-SERIAL-NO.            
T18652     MOVE GM-METER-SIZE-ID       TO E-FMT01-MTR-SIZE-ID.          
T18652     MOVE EQ-LOCAL-OFFICE        TO E-FMT01-MTR-STORAGE-FAC-CD.   
T18652     MOVE EQ-CODE-CRNT-LOC       TO E-FMT01-CODE-CRNT-LOC.        
T18652     MOVE EQ-DATE-PURCHASED(1:4) TO E-FMT01-YEAR-PURCHASED.       
T18652     MOVE EQ-DATE-LAST-MOVE      TO E-FMT01-DATE-RETIRED.         
T22243     MOVE EQ-COMPANY-NO          TO E-FMT01-COMPANY-NO.           
T18652     PERFORM 8000-WRITE-FCSMT01 THRU 8000-EXIT.                   
T18652     MOVE SPACES                 TO FIOMT01.                      
      *                                                                 00166000
       1220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00226000
      ****************************************************************          
      **                                                            **          
      **  1300-PROCESS-WATER                                        **          
      **                                                            **          
      ****************************************************************          
      *1300-PROCESS-WATER.                                              00231500
      *                                                                         
      *    DISPLAY '1300-PROCESS-WATER'                                         
      *                                                                         
      *    MOVE WS-W                   TO MV-CODE-UTIL-TYPE.                    
      *    MOVE WS-M                   TO MV-CODE-DEVICE-TYPE.                  
      *    MOVE WS-MIN-W-OFF-LOC       TO WS-MIN-LOC.                   00231500
      *    MOVE WS-MAX-W-OFF-LOC       TO WS-MAX-LOC.                   00231500
      *    MOVE WS-MIN-W-METER-NO      TO WS-MIN-METER-NO.              00231500
      *    MOVE WS-MAX-W-METER-NO      TO WS-MAX-METER-NO.              00231500
      *    PERFORM 7000-OPEN-MOVEMENT-HIST       THRU 7000-EXIT.        00231500
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               00231500
      *        PERFORM 7001-FETCH-MOVEMENT-HIST  THRU 7001-EXIT         00231500
      *        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           00231500
      *            PERFORM 1310-PROCESS-WATER-MTD                               
      *                                          THRU 1310-EXIT                 
      *               UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       00231500
      *                  OR MV-DEVICE-NO GREATER THAN WS-MAX-W-METER-NO 00231500
      *            PERFORM 7002-CLOSE-MOVEMENT-HIST                     00231500
      *                                          THRU 7002-EXIT         00231500
      *        ELSE                                                     00231500
      *            PERFORM 7002-CLOSE-MOVEMENT-HIST                     00231500
      *                                          THRU 7002-EXIT         00231500
      *        END-IF                                                           
      *    ELSE                                                                 
      *        PERFORM 7002-CLOSE-MOVEMENT-HIST  THRU 7002-EXIT                 
      *    END-IF.                                                              
      *                                                                         
      *1300-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1310-PROCESS-WATER-MTD                                    **          
      **                                                            **          
      ****************************************************************          
      *1310-PROCESS-WATER-MTD.                                                  
      *                                                                         
      *    DISPLAY '1310-PROCESS-WTR-MTD'.                                      
      *                                                                         
PCR156*    MOVE MV-LOCAL-OFFICE        TO WS-MTR-STORAGE-FAC-CD-1.              
      *    MOVE MV-CODE-CRNT-LOC       TO WS-CODE-CRNT-LOC-1.                   
      *    MOVE MV-DATE-MOVE           TO WS-DATE-MOVE-1.                       
      *                                                                         
      *    IF MV-CODE-CRNT-LOC EQUAL WS-I                                       
      *        MOVE ZERO               TO WS-CODE-CRNT-LOC-2                    
      *        PERFORM 1315-GATHER-WATER-MTD-INFO                               
      *                                          THRU 1315-EXIT                 
      *    ELSE                                                                 
      *        IF MV-CODE-CRNT-LOC EQUAL WS-A OR                                
      *           MV-CODE-CRNT-LOC EQUAL WS-J OR                                
      *           MV-CODE-CRNT-LOC EQUAL WS-C                                   
      *            PERFORM 7200-OPEN-MOVEMENT-HIST-2                            
      *                                          THRU 7200-EXIT                 
      *            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
      *                PERFORM 7210-FETCH-MOVEMENT-HIST-2                       
      *                                          THRU 7210-EXIT                 
      *                IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
      *                    MOVE MV-LOCAL-OFFICE                                 
PCR156*                                TO WS-MTR-STORAGE-FAC-CD-2               
      *                    MOVE MV-CODE-CRNT-LOC                                
      *                                TO WS-CODE-CRNT-LOC-2                    
      *                    MOVE MV-DATE-MOVE                                    
      *                                TO WS-DATE-MOVE-2                        
      *                    PERFORM 1315-GATHER-WATER-MTD-INFO                   
      *                                          THRU 1315-EXIT                 
      *                ELSE                                                     
      *                    PERFORM 7220-CLOSE-MOVEMENT-HIST-2                   
      *                                          THRU 7220-EXIT                 
      *                END-IF                                                   
      *            ELSE                                                         
      *                PERFORM 7220-CLOSE-MOVEMENT-HIST-2                       
      *                                          THRU 7220-EXIT                 
      *            END-IF                                                       
      *        END-IF                                                           
      *    END-IF.                                                              
      *                                                                         
      *    MOVE SPACES                 TO WS-CODE-CRNT-LOC-1,                   
      *                                   WS-CODE-CRNT-LOC-2.                   
      *    MOVE ZEROS                  TO WS-DATE-MOVE-1,                       
      *                                   WS-DATE-MOVE-2,                       
PCR156*                                   WS-MTR-STORAGE-FAC-CD-1,              
PCR156*                                   WS-MTR-STORAGE-FAC-CD-2.              
      *                                                                         
      *    PERFORM 7001-FETCH-MOVEMENT-HIST       THRU 7001-EXIT.               
      *                                                                         
      *1310-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1315-GATHER-WATER-MTD-INFO                                **          
      **                                                            **          
      ****************************************************************          
T18652*1315-GATHER-WATER-MTD-INFO.                                              
      *                                                                         
      *    DISPLAY '1315-GATHER-WTR-MTD'.                                       
      *                                                                         
      *    MOVE WS-W                   TO E-FMT01-UTL-TYPE.                     
      *    MOVE MV-DEVICE-NO           TO E-FMT01-EQUIPMENT-NO.                 
      *    PERFORM 7010-SELECT-EQUIPMENT         THRU 7010-EXIT.                
      *                                                                         
      *        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL                   
      *            PERFORM 1320-PROCESS-WATER-MTB                               
      *                                          THRU 1320-EXIT                 
      *            PERFORM 1330-PROCESS-WATER-MTM                               
      *                                          THRU 1330-EXIT                 
      *        END-IF                                                           
      *    END-IF.                                                              
      *                                                                         
      *    IF WS-CODE-CRNT-LOC-1 EQUAL WS-A OR                                  
      *       WS-CODE-CRNT-LOC-1 EQUAL WS-J OR                                  
      *       WS-CODE-CRNT-LOC-1 EQUAL WS-C                                     
      *        PERFORM 7220-CLOSE-MOVEMENT-HIST-2                               
      *                                          THRU 7220-EXIT                 
      *    END-IF.                                                              
      *                                                                         
      *1315-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1320-PROCESS-WATER-MTB                                    **          
      **                                                            **          
      ****************************************************************          
      *1320-PROCESS-WATER-MTB.                                                  
      *                                                                         
      *    MOVE EQ-CODE-MAKE           TO E-FMT01-CODE-MAKE.                    
      *    MOVE EQ-SERIAL-NO           TO E-FMT01-SERIAL-NO.                    
      *    MOVE WM-METER-SIZE-ID       TO E-FMT01-EQUIPMENT-SIZE-ID.    00170000
      *                                                                         
      *1320-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1330-PROCESS-WATER-MTM                                    **          
      **                                                            **          
      ****************************************************************          
      *1330-PROCESS-WATER-MTM.                                                  
      *                                                                 00172500
      *    DISPLAY '1330-MTM'.                                                  
      *    DISPLAY 'CODE CRNT LOC 1 = ' WS-CODE-CRNT-LOC-1.                     
      *    DISPLAY 'CODE CRNT LOC 2 = ' WS-CODE-CRNT-LOC-2.                     
      *                                                                 00227000
      *    IF WS-CODE-CRNT-LOC-1 EQUAL WS-A AND                                 
      *       WS-CODE-CRNT-LOC-2 EQUAL WS-1                                     
      *        MOVE WS-1               TO E-FMT01-FUNC-ID                       
PCR156*        MOVE WS-MTR-STORAGE-FAC-CD-1                                     
PCR156*                                TO E-FMT01-MTR-STORAGE-FAC-CD            
      *        MOVE WS-CODE-CRNT-LOC-1 TO E-FMT01-CODE-CRNT-LOC                 
      *        MOVE WS-DATE-MOVE-1     TO E-FMT01-EVENT-DATE                    
      *        MOVE WS-DATE-MOVE-YY-1  TO E-FMT01-EVENT-YY                      
      *        PERFORM 8000-WRITE-FCSMT01        THRU 8000-EXIT                 
      *    END-IF.                                                              
      *                                                                         
      *    IF WS-CODE-CRNT-LOC-1 EQUAL WS-A AND                                 
      *       WS-CODE-CRNT-LOC-2 EQUAL WS-2                                     
      *        MOVE WS-2               TO E-FMT01-FUNC-ID                       
PCR156*        MOVE WS-MTR-STORAGE-FAC-CD-1                                     
PCR156*                                TO E-FMT01-MTR-STORAGE-FAC-CD            
      *        MOVE WS-CODE-CRNT-LOC-1 TO E-FMT01-CODE-CRNT-LOC                 
      *        MOVE WS-DATE-MOVE-1     TO E-FMT01-EVENT-DATE                    
      *        MOVE WS-DATE-MOVE-YY-1  TO E-FMT01-EVENT-YY                      
      *        PERFORM 8000-WRITE-FCSMT01        THRU 8000-EXIT                 
      *    END-IF.                                                              
      *                                                                         
      *    IF WS-CODE-CRNT-LOC-1 EQUAL WS-A AND                                 
      *       WS-CODE-CRNT-LOC-2 EQUAL WS-3                                     
      *        MOVE WS-3               TO E-FMT01-FUNC-ID                       
PCR156*        MOVE WS-MTR-STORAGE-FAC-CD-1                                     
PCR156*                                TO E-FMT01-MTR-STORAGE-FAC-CD            
      *        MOVE WS-CODE-CRNT-LOC-1 TO E-FMT01-CODE-CRNT-LOC                 
      *        MOVE WS-DATE-MOVE-1     TO E-FMT01-EVENT-DATE                    
      *        MOVE WS-DATE-MOVE-YY-1  TO E-FMT01-EVENT-YY                      
      *        PERFORM 8000-WRITE-FCSMT01        THRU 8000-EXIT                 
      *    END-IF.                                                              
      *                                                                         
      *    IF WS-CODE-CRNT-LOC-1 EQUAL WS-J AND                                 
      *       WS-CODE-CRNT-LOC-2 EQUAL WS-A                                     
      *        MOVE WS-6               TO E-FMT01-FUNC-ID                       
PCR156*        MOVE WS-MTR-STORAGE-FAC-CD-1                                     
PCR156*                                TO E-FMT01-MTR-STORAGE-FAC-CD            
      *        MOVE WS-CODE-CRNT-LOC-1 TO E-FMT01-CODE-CRNT-LOC                 
      *        MOVE WS-DATE-MOVE-1     TO E-FMT01-EVENT-DATE                    
      *        MOVE WS-DATE-MOVE-YY-1  TO E-FMT01-EVENT-YY                      
      *        PERFORM 8000-WRITE-FCSMT01        THRU 8000-EXIT                 
      *    END-IF.                                                              
      *                                                                         
      *    IF WS-CODE-CRNT-LOC-1 EQUAL WS-J AND                                 
      *       WS-CODE-CRNT-LOC-2 EQUAL WS-A                                     
      *        MOVE WS-7               TO E-FMT01-FUNC-ID                       
PCR156*        MOVE WS-MTR-STORAGE-FAC-CD-2                                     
PCR156*                                TO E-FMT01-MTR-STORAGE-FAC-CD            
      *        MOVE WS-CODE-CRNT-LOC-2 TO E-FMT01-CODE-CRNT-LOC                 
      *        MOVE WS-DATE-MOVE-2     TO E-FMT01-EVENT-DATE                    
      *        MOVE WS-DATE-MOVE-YY-2  TO E-FMT01-EVENT-YY                      
      *        PERFORM 8000-WRITE-FCSMT01        THRU 8000-EXIT                 
      *    END-IF.                                                              
      *                                                                         
      *    IF WS-CODE-CRNT-LOC-1 EQUAL WS-C AND                                 
      *       WS-CODE-CRNT-LOC-2 EQUAL WS-A                                     
      *        MOVE WS-7               TO E-FMT01-FUNC-ID                       
PCR156*        MOVE WS-MTR-STORAGE-FAC-CD-1                                     
PCR156*                                TO E-FMT01-MTR-STORAGE-FAC-CD            
      *        MOVE WS-CODE-CRNT-LOC-1 TO E-FMT01-CODE-CRNT-LOC                 
      *        MOVE WS-DATE-MOVE-1     TO E-FMT01-EVENT-DATE                    
      *        MOVE WS-DATE-MOVE-YY-1  TO E-FMT01-EVENT-YY                      
      *        PERFORM 8000-WRITE-FCSMT01        THRU 8000-EXIT                 
      *    END-IF.                                                              
      *                                                                         
      *    IF WS-CODE-CRNT-LOC-1 EQUAL WS-I AND                                 
      *       WS-CODE-CRNT-LOC-2 EQUAL ZERO                                     
      *        MOVE WS-5               TO E-FMT01-FUNC-ID                       
PCR156*        MOVE WS-MTR-STORAGE-FAC-CD-1                                     
PCR156*                                TO E-FMT01-MTR-STORAGE-FAC-CD            
      *        MOVE WS-CODE-CRNT-LOC-1 TO E-FMT01-CODE-CRNT-LOC                 
      *        MOVE WS-DATE-MOVE-1     TO E-FMT01-EVENT-DATE                    
      *        MOVE WS-DATE-MOVE-YY-1  TO E-FMT01-EVENT-YY                      
      *        PERFORM 8000-WRITE-FCSMT01        THRU 8000-EXIT                 
      *    END-IF.                                                              
      *                                                                         
      *    IF WS-CODE-CRNT-LOC-1 EQUAL WS-A AND                                 
      *       WS-CODE-CRNT-LOC-2 EQUAL WS-J                                     
      *        MOVE WS-4               TO E-FMT01-FUNC-ID                       
PCR156*        MOVE WS-MTR-STORAGE-FAC-CD-1                                     
PCR156*                                TO E-FMT01-MTR-STORAGE-FAC-CD            
      *        MOVE WS-CODE-CRNT-LOC-1 TO E-FMT01-CODE-CRNT-LOC                 
      *        MOVE WS-DATE-MOVE-1     TO E-FMT01-EVENT-DATE                    
      *        MOVE WS-DATE-MOVE-YY-1  TO E-FMT01-EVENT-YY                      
      *        PERFORM 8000-WRITE-FCSMT01        THRU 8000-EXIT                 
      *    END-IF.                                                              
      *                                                                         
      *1330-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1400-PROCESS-SEWER                                        **          
      **                                                            **          
      ****************************************************************          
      *1400-PROCESS-SEWER.                                                      
      *                                                                         
      *    DISPLAY '1400-PROCESS-SEWER'                                         
      *                                                                         
      *    MOVE WS-S                   TO MV-CODE-UTIL-TYPE.                    
      *    MOVE WS-M                   TO MV-CODE-DEVICE-TYPE.                  
      *    MOVE WS-MIN-S-OFF-LOC       TO WS-MIN-LOC.                           
      *    MOVE WS-MAX-S-OFF-LOC       TO WS-MAX-LOC.                           
      *    MOVE WS-MIN-S-METER-NO      TO WS-MIN-METER-NO.                      
      *    MOVE WS-MAX-S-METER-NO      TO WS-MAX-METER-NO.                      
      *    PERFORM 7000-OPEN-MOVEMENT-HIST       THRU 7000-EXIT.                
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL                       
      *        PERFORM 7001-FETCH-MOVEMENT-HIST  THRU 7001-EXIT                 
      *        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL                   
      *            PERFORM 1410-PROCESS-SEWER-MTD                               
      *                                          THRU 1410-EXIT                 
      *               UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
      *                  OR MV-DEVICE-NO GREATER THAN WS-MAX-S-METER-NO         
      *            PERFORM 7002-CLOSE-MOVEMENT-HIST                             
      *                                          THRU 7002-EXIT                 
      *        ELSE                                                             
      *            PERFORM 7002-CLOSE-MOVEMENT-HIST                             
      *                                          THRU 7002-EXIT                 
      *        END-IF                                                           
      *    ELSE                                                                 
      *        PERFORM 7002-CLOSE-MOVEMENT-HIST  THRU 7002-EXIT                 
      *    END-IF.                                                              
      *                                                                         
      *1400-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1410-PROCESS-SEWER-MTD                                    **          
      **                                                            **          
      ****************************************************************          
      *1410-PROCESS-SEWER-MTD.                                                  
      *                                                                         
      *    DISPLAY '1410-PROCESS-SWR-MTD'.                                      
      *                                                                         
PCR156*    MOVE MV-LOCAL-OFFICE        TO WS-MTR-STORAGE-FAC-CD-1.              
      *    MOVE MV-CODE-CRNT-LOC       TO WS-CODE-CRNT-LOC-1.                   
      *    MOVE MV-DATE-MOVE           TO WS-DATE-MOVE-1.                       
      *                                                                         
      *    IF MV-CODE-CRNT-LOC EQUAL WS-I                                       
      *        MOVE ZERO               TO WS-CODE-CRNT-LOC-2                    
      *        PERFORM 1415-GATHER-SEWER-MTD-INFO                               
      *                                          THRU 1415-EXIT                 
      *    ELSE                                                                 
      *        IF MV-CODE-CRNT-LOC EQUAL WS-A OR                                
      *           MV-CODE-CRNT-LOC EQUAL WS-J OR                                
      *           MV-CODE-CRNT-LOC EQUAL WS-C                                   
      *            PERFORM 7200-OPEN-MOVEMENT-HIST-2                            
      *                                          THRU 7200-EXIT                 
      *            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
      *               PERFORM 7210-FETCH-MOVEMENT-HIST-2                        
      *                                          THRU 7210-EXIT                 
      *                IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
      *                    MOVE MV-LOCAL-OFFICE                                 
PCR156*                                TO WS-MTR-STORAGE-FAC-CD-2               
      *                    MOVE MV-CODE-CRNT-LOC                                
      *                                TO WS-CODE-CRNT-LOC-2                    
      *                    MOVE MV-DATE-MOVE                                    
      *                                TO WS-DATE-MOVE-2                        
      *                    PERFORM 1415-GATHER-SEWER-MTD-INFO                   
      *                                          THRU 1415-EXIT                 
      *                ELSE                                                     
      *                    PERFORM 7220-CLOSE-MOVEMENT-HIST-2                   
      *                                          THRU 7220-EXIT                 
      *                END-IF                                                   
      *            ELSE                                                         
      *                PERFORM 7220-CLOSE-MOVEMENT-HIST-2                       
      *                                          THRU 7220-EXIT                 
      *            END-IF                                                       
      *        END-IF                                                           
      *    END-IF.                                                              
      *                                                                         
      *    MOVE SPACES                 TO WS-CODE-CRNT-LOC-1,                   
      *                                   WS-CODE-CRNT-LOC-2.                   
      *    MOVE ZEROS                  TO WS-DATE-MOVE-1,                       
      *                                   WS-DATE-MOVE-2,                       
PCR156*                                   WS-MTR-STORAGE-FAC-CD-1,              
PCR156*                                   WS-MTR-STORAGE-FAC-CD-2.              
      *                                                                         
      *    PERFORM 7001-FETCH-MOVEMENT-HIST       THRU 7001-EXIT.               
      *                                                                         
      *1410-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1415-GATHER-SEWER-MTD-INFO                                **          
      **                                                            **          
      ****************************************************************          
      *1415-GATHER-SEWER-MTD-INFO.                                              
      *                                                                         
      *    DISPLAY '1415-GATHER-SWR-MTD'.                                       
      *                                                                         
      *    MOVE WS-S                   TO E-FMT01-UTL-TYPE.                     
      *    MOVE MV-DEVICE-NO           TO E-FMT01-EQUIPMENT-NO.                 
      *    PERFORM 7010-SELECT-EQUIPMENT         THRU 7010-EXIT.                
      *                                                                         
      *        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL                   
      *            PERFORM 1420-PROCESS-SEWER-MTB                               
      *                                          THRU 1420-EXIT                 
      *            PERFORM 1430-PROCESS-SEWER-MTM                               
      *                                          THRU 1430-EXIT                 
      *        END-IF                                                           
      *    END-IF.                                                              
      *                                                                         
      *    IF WS-CODE-CRNT-LOC-1 EQUAL WS-A OR                                  
      *       WS-CODE-CRNT-LOC-1 EQUAL WS-J OR                                  
      *       WS-CODE-CRNT-LOC-1 EQUAL WS-C                                     
      *        PERFORM 7220-CLOSE-MOVEMENT-HIST-2                               
      *                                          THRU 7220-EXIT                 
      *    END-IF.                                                              
      *                                                                         
      *1415-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1420-PROCESS-SEWER-MTB                                    **          
      **                                                            **          
      ****************************************************************          
      *1420-PROCESS-SEWER-MTB.                                                  
      *                                                                         
      *    MOVE EQ-CODE-MAKE           TO E-FMT01-CODE-MAKE.                    
      *    MOVE EQ-SERIAL-NO           TO E-FMT01-SERIAL-NO.                    
      *    MOVE WM-METER-SIZE-ID       TO E-FMT01-EQUIPMENT-SIZE-ID.    00170000
      *                                                                         
      *1420-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1430-PROCESS-SEWER-MTM                                    **          
      **                                                            **          
      ****************************************************************          
      *1430-PROCESS-SEWER-MTM.                                                  
      *                                                                 00172500
      *    DISPLAY '1430-MTM'.                                                  
      *    DISPLAY 'CODE CRNT LOC 1 = ' WS-CODE-CRNT-LOC-1.                     
      *    DISPLAY 'CODE CRNT LOC 2 = ' WS-CODE-CRNT-LOC-2.                     
      *                                                                 00227000
      *    IF WS-CODE-CRNT-LOC-1 EQUAL WS-A AND                                 
      *       WS-CODE-CRNT-LOC-2 EQUAL WS-1                                     
      *        MOVE WS-1               TO E-FMT01-FUNC-ID                       
PCR156*        MOVE WS-MTR-STORAGE-FAC-CD-1                                     
PCR156*                                TO E-FMT01-MTR-STORAGE-FAC-CD            
      *        MOVE WS-CODE-CRNT-LOC-1 TO E-FMT01-CODE-CRNT-LOC                 
      *        MOVE WS-DATE-MOVE-1     TO E-FMT01-EVENT-DATE                    
      *        MOVE WS-DATE-MOVE-YY-1  TO E-FMT01-EVENT-YY                      
      *        PERFORM 8000-WRITE-FCSMT01        THRU 8000-EXIT                 
      *    END-IF.                                                              
      *                                                                         
      *    IF WS-CODE-CRNT-LOC-1 EQUAL WS-A AND                                 
      *       WS-CODE-CRNT-LOC-2 EQUAL WS-2                                     
      *        MOVE WS-2               TO E-FMT01-FUNC-ID                       
PCR156*        MOVE WS-MTR-STORAGE-FAC-CD-1                                     
PCR156*                                TO E-FMT01-MTR-STORAGE-FAC-CD            
      *        MOVE WS-CODE-CRNT-LOC-1 TO E-FMT01-CODE-CRNT-LOC                 
      *        MOVE WS-DATE-MOVE-1     TO E-FMT01-EVENT-DATE                    
      *        MOVE WS-DATE-MOVE-YY-1  TO E-FMT01-EVENT-YY                      
      *        PERFORM 8000-WRITE-FCSMT01        THRU 8000-EXIT                 
      *    END-IF.                                                              
      *                                                                         
      *    IF WS-CODE-CRNT-LOC-1 EQUAL WS-A AND                                 
      *       WS-CODE-CRNT-LOC-2 EQUAL WS-3                                     
      *        MOVE WS-3               TO E-FMT01-FUNC-ID                       
PCR156*        MOVE WS-MTR-STORAGE-FAC-CD-1                                     
PCR156*                                TO E-FMT01-MTR-STORAGE-FAC-CD            
      *        MOVE WS-CODE-CRNT-LOC-1 TO E-FMT01-CODE-CRNT-LOC                 
      *        MOVE WS-DATE-MOVE-1     TO E-FMT01-EVENT-DATE                    
      *        MOVE WS-DATE-MOVE-YY-1  TO E-FMT01-EVENT-YY                      
      *        PERFORM 8000-WRITE-FCSMT01        THRU 8000-EXIT                 
      *    END-IF.                                                              
      *                                                                         
      *    IF WS-CODE-CRNT-LOC-1 EQUAL WS-J AND                                 
      *       WS-CODE-CRNT-LOC-2 EQUAL WS-A                                     
      *        MOVE WS-6               TO E-FMT01-FUNC-ID                       
PCR156*        MOVE WS-MTR-STORAGE-FAC-CD-1                                     
PCR156*                                TO E-FMT01-MTR-STORAGE-FAC-CD            
      *        MOVE WS-CODE-CRNT-LOC-1 TO E-FMT01-CODE-CRNT-LOC                 
      *        MOVE WS-DATE-MOVE-1     TO E-FMT01-EVENT-DATE                    
      *        MOVE WS-DATE-MOVE-YY-1  TO E-FMT01-EVENT-YY                      
      *        PERFORM 8000-WRITE-FCSMT01        THRU 8000-EXIT                 
      *    END-IF.                                                              
      *                                                                         
      *    IF WS-CODE-CRNT-LOC-1 EQUAL WS-J AND                                 
      *       WS-CODE-CRNT-LOC-2 EQUAL WS-A                                     
      *        MOVE WS-7               TO E-FMT01-FUNC-ID                       
PCR156*        MOVE WS-MTR-STORAGE-FAC-CD-2                                     
PCR156*                                TO E-FMT01-MTR-STORAGE-FAC-CD            
      *        MOVE WS-CODE-CRNT-LOC-2 TO E-FMT01-CODE-CRNT-LOC                 
      *        MOVE WS-DATE-MOVE-2     TO E-FMT01-EVENT-DATE                    
      *        MOVE WS-DATE-MOVE-YY-2  TO E-FMT01-EVENT-YY                      
      *        PERFORM 8000-WRITE-FCSMT01        THRU 8000-EXIT                 
      *    END-IF.                                                              
      *                                                                         
      *    IF WS-CODE-CRNT-LOC-1 EQUAL WS-C AND                                 
      *       WS-CODE-CRNT-LOC-2 EQUAL WS-A                                     
      *        MOVE WS-7               TO E-FMT01-FUNC-ID                       
PCR156*        MOVE WS-MTR-STORAGE-FAC-CD-1                                     
PCR156*                                TO E-FMT01-MTR-STORAGE-FAC-CD            
      *        MOVE WS-CODE-CRNT-LOC-1 TO E-FMT01-CODE-CRNT-LOC                 
      *        MOVE WS-DATE-MOVE-1     TO E-FMT01-EVENT-DATE                    
      *        MOVE WS-DATE-MOVE-YY-1  TO E-FMT01-EVENT-YY                      
      *        PERFORM 8000-WRITE-FCSMT01        THRU 8000-EXIT                 
      *    END-IF.                                                              
      *                                                                         
      *    IF WS-CODE-CRNT-LOC-1 EQUAL WS-I AND                                 
      *       WS-CODE-CRNT-LOC-2 EQUAL ZERO                                     
      *        MOVE WS-5               TO E-FMT01-FUNC-ID                       
PCR156*        MOVE WS-MTR-STORAGE-FAC-CD-1                                     
PCR156*                                TO E-FMT01-MTR-STORAGE-FAC-CD            
      *        MOVE WS-CODE-CRNT-LOC-1 TO E-FMT01-CODE-CRNT-LOC                 
      *        MOVE WS-DATE-MOVE-1     TO E-FMT01-EVENT-DATE                    
      *        MOVE WS-DATE-MOVE-YY-1  TO E-FMT01-EVENT-YY                      
      *        PERFORM 8000-WRITE-FCSMT01        THRU 8000-EXIT                 
      *    END-IF.                                                              
      *                                                                         
      *    IF WS-CODE-CRNT-LOC-1 EQUAL WS-A AND                                 
      *       WS-CODE-CRNT-LOC-2 EQUAL WS-J                                     
      *        MOVE WS-4               TO E-FMT01-FUNC-ID                       
PCR156*        MOVE WS-MTR-STORAGE-FAC-CD-1                                     
PCR156*                                TO E-FMT01-MTR-STORAGE-FAC-CD            
      *        MOVE WS-CODE-CRNT-LOC-1 TO E-FMT01-CODE-CRNT-LOC                 
      *        MOVE WS-DATE-MOVE-1     TO E-FMT01-EVENT-DATE                    
      *        MOVE WS-DATE-MOVE-YY-1  TO E-FMT01-EVENT-YY                      
      *        PERFORM 8000-WRITE-FCSMT01        THRU 8000-EXIT                 
      *    END-IF.                                                              
      *                                                                         
END   *1430-EXIT.                                                               
T18652*    EXIT.                                                                
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1500-PROCESS-XFORMER                                      **          
      **                                                            **          
      ****************************************************************          
       1500-PROCESS-XFORMER.                                            
      *                                                                         
T18652     MOVE WS-X                   TO EQ-CODE-UTIL-TYPE.            
T18652     MOVE WS-T                   TO EQ-EQUIP-TYPE-CD.             
           MOVE WS-MIN-X-OFF-LOC       TO WS-MIN-LOC.                   
           MOVE WS-MAX-X-OFF-LOC       TO WS-MAX-LOC.                   
           MOVE WS-MIN-XFORMER-NO      TO WS-MIN-METER-NO.              
           MOVE WS-MAX-XFORMER-NO      TO WS-MAX-METER-NO.              
T18652     PERFORM 7000-OPEN-EQUIP-CURSOR THRU 7000-EXIT.               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T18652         PERFORM 7001-FETCH-EQUIP-CURSOR THRU 7001-EXIT           
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
T22243             MOVE EQ-COMPANY-NO  TO IX-COMPANY-NO                 
                   PERFORM 1510-PROCESS-XFORMER-MTD                     
                                                 THRU 1510-EXIT         
                      UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
T18652                   OR EQ-DEVICE-NO GREATER THAN WS-MAX-XFORMER-NO 
T18652             PERFORM 7002-CLOSE-EQUIP-CURSOR                      
                                                 THRU 7002-EXIT         
               ELSE                                                     
T18652             PERFORM 7002-CLOSE-EQUIP-CURSOR                      
                                                 THRU 7002-EXIT         
               END-IF                                                   
           ELSE                                                         
T18652         PERFORM 7002-CLOSE-EQUIP-CURSOR THRU 7002-EXIT           
           END-IF.                                                      
      *                                                                         
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1510-PROCESS-XFORMER-MTD                                  **          
      **                                                            **          
      ****************************************************************          
       1510-PROCESS-XFORMER-MTD.                                        
      *                                                                         
T18652     PERFORM 1515-GATHER-XFORMER-MTD-INFO                         
                                                 THRU 1515-EXIT         
      *                                                                         
T18652     PERFORM 7001-FETCH-EQUIP-CURSOR THRU 7001-EXIT.              
      *                                                                         
       1510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1515-GATHER-XFORMER-MTD-INFO                              **          
      **                                                            **          
      ****************************************************************          
       1515-GATHER-XFORMER-MTD-INFO.                                    
      *                                                                         
T18652     MOVE WS-X                   TO E-FMT23-UTL-TYPE.             
T18652     MOVE EQ-DEVICE-NO           TO E-FMT23-XFORMER-NO.           
           PERFORM 7010-SELECT-EQUIPMENT         THRU 7010-EXIT.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               PERFORM 7050-SELECT-INSTR-XFORMER THRU 7050-EXIT         
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   PERFORM 1520-PROCESS-XFORMER-MTB                     
                                                 THRU 1520-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       1515-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1520-PROCESS-XFORMER-MTB                                  **          
      **                                                            **          
      ****************************************************************          
       1520-PROCESS-XFORMER-MTB.                                        
      *                                                                         
T18652     MOVE EQ-CODE-MAKE           TO E-FMT23-CODE-MAKE.            
T18652     MOVE EQ-SERIAL-NO           TO E-FMT23-SERIAL-NO.            
T18652     MOVE IX-XFORMER-SPEC-CD     TO E-FMT23-XFORMER-SPEC-CD.      
T18652     MOVE IX-XFORMER-CLASS-CD    TO E-FMT23-XFORMER-CLASS-CD.     
T18652     MOVE IX-XFORMER-TYPE-CD     TO E-FMT23-XFORMER-TYPE-CD.      
T18652     MOVE EQ-LOCAL-OFFICE        TO E-FMT23-MTR-STORAGE-FAC-CD.   
T18652     MOVE EQ-CODE-CRNT-LOC       TO E-FMT23-CODE-CRNT-LOC.        
T18652     MOVE EQ-DATE-PURCHASED(1:4) TO E-FMT23-YEAR-PURCHASED.       
T18652     MOVE EQ-DATE-LAST-MOVE      TO E-FMT23-DATE-RETIRED.         
T22243     MOVE EQ-COMPANY-NO          TO E-FMT23-COMPANY-NO.           
T18652     PERFORM 8300-WRITE-FCSMT23 THRU 8300-EXIT.                   
T18652     MOVE SPACES                 TO FIOMT23.                      
      *                                                                         
       1520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1600-PROCESS-ATTACHMENT                                   **          
      **                                                            **          
      ****************************************************************          
       1600-PROCESS-ATTACHMENT.                                         
      *                                                                         
           MOVE WS-G                   TO LX-CODE-UTIL-TYPE.            
           MOVE 'IT'                   TO LX-CODE-ATT-TYPE.             
           MOVE 'I'                    TO LX-EQUIP-LOC-ID.              
           PERFORM 7300-OPEN-ATTACH-CURSOR THRU 7300-EXIT.              
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               PERFORM 7310-FETCH-ATTACH-CURSOR THRU 7310-EXIT          
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   PERFORM 1610-PROCESS-ATTACH-MTB THRU 1610-EXIT       
                      UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                   PERFORM 7320-CLOSE-ATTACH-CURSOR                     
                                                 THRU 7320-EXIT         
               ELSE                                                     
                   PERFORM 7320-CLOSE-ATTACH-CURSOR                     
                                                 THRU 7320-EXIT         
               END-IF                                                   
           ELSE                                                         
               PERFORM 7320-CLOSE-ATTACH-CURSOR THRU 7320-EXIT          
           END-IF.                                                      
      *                                                                         
       1600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1610-PROCESS-ATTACH-MTB                                   **          
      **                                                            **          
      ****************************************************************          
       1610-PROCESS-ATTACH-MTB.                                         
      *                                                                         
           MOVE LX-CODE-UTIL-TYPE      TO E-FMT26-CODE-UTIL-TYPE.       
           MOVE LX-DEVICE-NO           TO E-FMT26-DEVICE-NO.            
           MOVE LX-CODE-ATT-TYPE       TO E-FMT26-CODE-ATT-TYPE.        
           MOVE LX-CODE-MAKE           TO E-FMT26-CODE-MAKE.            
           MOVE LX-MTR-STORAGE-FAC-CD  TO E-FMT26-MTR-STORAGE-FAC-CD.   
           MOVE LX-EQUIP-LOC-ID        TO E-FMT26-EQUIP-LOC-ID.         
           MOVE LX-DATE-PURCHASED(1:4) TO E-FMT26-YEAR-PURCHASED.       
           MOVE LX-DATE-LAST-MOVE      TO E-FMT26-DATE-RETIRED.         
           MOVE LX-COMPANY-NO          TO E-FMT26-COMPANY-NO.           
           PERFORM 8400-WRITE-FCSMT26 THRU 8400-EXIT.                   
           MOVE SPACES                 TO FIOMT26.                      
           PERFORM 7310-FETCH-ATTACH-CURSOR THRU 7310-EXIT.             
      *                                                                         
       1610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  2000-PROCESS-JUNK-EQUIP                                   **          
      **                                                            **          
      ****************************************************************          
       2000-PROCESS-JUNK-EQUIP.                                         
      *                                                                 00140500
           PERFORM 7100-OPEN-MOVEMENT-JUNK       THRU 7100-EXIT.        
      *                                                                 00140500
           PERFORM 7101-FETCH-MOVEMENT-JUNK      THRU 7101-EXIT.        
           PERFORM 2100-PROCESS-ALL-JUNK-EQUIP   THRU 2100-EXIT         
               UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.             
      *                                                                 00140500
           PERFORM 7102-CLOSE-MOVEMENT-JUNK      THRU 7102-EXIT.        
      *                                                                 00140500
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  2100-PROCESS-ALL-JUNK-EQUIP                               **          
      **                                                            **          
      ****************************************************************          
       2100-PROCESS-ALL-JUNK-EQUIP.                                     
      *                                                                         
           PERFORM 7010-SELECT-EQUIPMENT         THRU 7010-EXIT.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               PERFORM 7101-FETCH-MOVEMENT-JUNK  THRU 7101-EXIT         
               GO                      TO 2100-EXIT                     
           END-IF.                                                      
      *                                                                         
           IF MV-CODE-UTIL-TYPE   = WS-E AND                            
              MV-CODE-DEVICE-TYPE = WS-M                                
               PERFORM 7020-SELECT-ELEC-METER    THRU 7020-EXIT         
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   MOVE WS-E           TO E-FMT02-UTL-TYPE              
                   MOVE WS-MT          TO E-FMT02-CODE-DEVICE-TYPE      
                   MOVE EM-METER-SIZE-ID                                
                                       TO E-FMT02-METER-SIZE-ID         
PCR040             MOVE ZERO           TO E-FMT02-CODE-CO-SIZE          
                   MOVE EQ-DATE-PURCHASED (1:4)                         
                                       TO E-FMT02-PURCHASE-YEAR         
                   MOVE +1             TO E-FMT02-QTY-RETIRED           
T22243             MOVE EQ-COMPANY-NO  TO E-FMT02-COMPANY-NO            
                   PERFORM 8100-WRITE-FCSMT02    THRU 8100-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           IF MV-CODE-UTIL-TYPE   = WS-G AND                            
              MV-CODE-DEVICE-TYPE = WS-M                                
               PERFORM 7030-SELECT-GAS-METER     THRU 7030-EXIT         
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   MOVE WS-G           TO E-FMT02-UTL-TYPE              
                   MOVE WS-MT          TO E-FMT02-CODE-DEVICE-TYPE      
                   MOVE GM-METER-SIZE-ID                                
                                       TO E-FMT02-METER-SIZE-ID         
                   MOVE GM-CODE-CO-SIZE                                 
                                       TO E-FMT02-CODE-CO-SIZE          
                   MOVE EQ-DATE-PURCHASED (1:4)                         
                                       TO E-FMT02-PURCHASE-YEAR         
                   MOVE +1             TO E-FMT02-QTY-RETIRED           
T22243             MOVE EQ-COMPANY-NO  TO E-FMT02-COMPANY-NO            
                   PERFORM 8100-WRITE-FCSMT02    THRU 8100-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                 00166000
      *                                                                 00166000
T18652     IF MV-CODE-UTIL-TYPE   = WS-X AND                            
              MV-CODE-DEVICE-TYPE = WS-T                                
               PERFORM 7050-SELECT-INSTR-XFORMER THRU 7050-EXIT         
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   MOVE WS-I           TO E-FMT02-UTL-TYPE              
                   MOVE WS-TF          TO E-FMT02-CODE-DEVICE-TYPE      
                   MOVE IX-XFORMER-SIZE-ID                              
                                       TO E-FMT02-METER-SIZE-ID         
                   MOVE ZERO           TO E-FMT02-CODE-CO-SIZE          
                   MOVE EQ-DATE-PURCHASED (1:4)                         
                                       TO E-FMT02-PURCHASE-YEAR         
                   MOVE +1             TO E-FMT02-QTY-RETIRED           
T22243             MOVE EQ-COMPANY-NO  TO E-FMT02-COMPANY-NO            
                   PERFORM 8100-WRITE-FCSMT02    THRU 8100-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                 00166000
           PERFORM 7101-FETCH-MOVEMENT-JUNK      THRU 7101-EXIT.        
      *                                                                 00220500
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00140500
       COPY CPD00040.                                                           
       COPY CPD00043.                                                           
       COPY CPD00037.                                                           
      *                                                                         
      ****************************************************************          
      **                                                            **          
T18652**  7000-OPEN-EQUIP-CURSOR                                    **          
      **                                                            **          
      ****************************************************************          
T18652 7000-OPEN-EQUIP-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
T18652         OPEN EQUIP_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7000-OPEN-EQUIP-CURSOR'                         
T18652         DISPLAY 'UTIL   TYPE = ' EQ-CODE-UTIL-TYPE               
T18652         DISPLAY 'DEVICE TYPE = ' EQ-EQUIP-TYPE-CD                
               DISPLAY 'MOVE DATE1  = ' WS-MOVE-TO-DATE-1               
               DISPLAY 'MOVE DATE2  = ' WS-MOVE-TO-DATE-2               
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
T18652**  7001-FETCH-EQUIP-CURSOR                                   **          
      **                                                            **          
      ****************************************************************          
T18652 7001-FETCH-EQUIP-CURSOR.                                         
      *                                                                         
           EXEC SQL                                                     
T18652         FETCH EQUIP_CURSOR                                       
ST              INTO :EQ-DEVICE-NO                                      
                    ,:EQ-DATE-LAST-MOVE                                 
                    ,:EQ-LOCAL-OFFICE                                   
                    ,:EQ-CODE-CRNT-LOC                                  
                    ,:EQ-DATE-PURCHASED :WS-NULLIND-DATE-PURCHASED    
                    ,:EQ-DATE-DISPOSED-OF :WS-NULLIND-DATE-DISPOSED     
END                 ,:EQ-SERIAL-NO                                      
T18652              ,:EQ-CODE-MAKE                                      
T22243              ,:EQ-COMPANY-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
T18652         DISPLAY '7001-FETCH-EQUIP-CURSOR'                        
T18652         DISPLAY 'UTILITY     = ' EQ-CODE-UTIL-TYPE               
T18652         DISPLAY 'TYPE        = ' EQ-EQUIP-TYPE-CD                
T18652         DISPLAY 'SQLCODE     = ' SQLCODE                         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7001-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
T18652**  7002-CLOSE-EQUIP-CURSOR                                   **          
      **                                                            **          
      ****************************************************************          
T18652 7002-CLOSE-EQUIP-CURSOR.                                         
      *                                                                         
           EXEC SQL                                                     
T18652         CLOSE EQUIP_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
T18652         DISPLAY '7002-CLOSE-EQUIP-CURSOR'                        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7002-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00262500
      ****************************************************************          
      **                                                            **          
      **  7010-SELECT-EQUIPMENT                                     **          
      **                                                            **          
      ****************************************************************          
       7010-SELECT-EQUIPMENT.                                           
      *                                                                 00262500
           EXEC SQL                                                     
               SELECT CODE_UTIL_TYPE,                                   
                      DEVICE_NO,                                        
                      EQUIP_TYPE_CD,                                    
                      SERIAL_NO,                                        
                      CODE_CRNT_LOC,                                    
                      LOCAL_OFFICE,                                     
                      CODE_MAKE,                                        
                      DATE_PURCHASED,                                   
                      DATE_DISPOSED_OF                                  
               INTO   :EQ-CODE-UTIL-TYPE,                               
                      :EQ-DEVICE-NO,                                    
                      :EQ-EQUIP-TYPE-CD,                                
                      :EQ-SERIAL-NO,                                    
                      :EQ-CODE-CRNT-LOC,                                
                      :EQ-LOCAL-OFFICE,                                 
                      :EQ-CODE-MAKE                                     
                     ,:EQ-DATE-PURCHASED :WS-NULLIND-DATE-PURCHASED   
                     ,:EQ-DATE-DISPOSED-OF :WS-NULLIND-DATE-DISPOSED    
               FROM   CSS_EQUIPMENT                                     
T18652         WHERE  CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE               
T18652           AND  EQUIP_TYPE_CD  = :EQ-EQUIP-TYPE-CD                
T18652           AND  DEVICE_NO      = :EQ-DEVICE-NO                    
T22243           AND  COMPANY_NO     = :EQ-COMPANY-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00262500
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 00262500
T18652     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '7010-SELECT-EQUIPMENT'                           
T18652        DISPLAY 'UTILITY TYPE = ' EQ-CODE-UTIL-TYPE               
T18652        DISPLAY 'EQUIP TYPE CD= ' EQ-EQUIP-TYPE-CD                
T18652        DISPLAY 'DEVICE NO    = ' EQ-DEVICE-NO                    
T18652        DISPLAY 'SQLCODE      = ' SQLCODE                         
T22243        DISPLAY 'COMPANY NO   = ' EQ-COMPANY-NO                   
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 00262500
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00262500
      ****************************************************************          
      **                                                            **          
      **  7020-SELECT-ELEC-METER                                    **          
      **                                                            **          
      ****************************************************************          
       7020-SELECT-ELEC-METER.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT CODE_METER_TYPE                                   
T18652               ,ELEC_MTR_CLASS_CD                                 
T18652               ,ELEC_MTR_SPEC_CD                                  
               INTO   :EM-CODE-METER-TYPE                               
T18652               ,:EM-ELEC-MTR-CLASS-CD                             
T18652               ,:EM-ELEC-MTR-SPEC-CD                              
               FROM   CSS_ELEC_METER                                    
T18652         WHERE  METER_NO       = :EQ-DEVICE-NO                    
TP3285           AND  CODE_UTIL_TYPE = :WS-E                            
T22243           AND  COMPANY_NO     = :EM-COMPANY-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7020-SELECT-ELEC-METER'                         
T18652         DISPLAY 'DEVICE NO    = ' EQ-DEVICE-NO                   
T22243         DISPLAY 'COMPANY NO   = ' EM-COMPANY-NO                  
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00262500
      ****************************************************************          
      **                                                            **          
      **  7030-SELECT-GAS-METER                                     **          
      **                                                            **          
      ****************************************************************          
       7030-SELECT-GAS-METER.                                           
      *                                                                 00262500
           EXEC SQL                                                     
               SELECT CODE_METER_TYPE                                   
                     ,METER_SIZE_ID                                     
                     ,CODE_CO_SIZE                                      
               INTO   :GM-CODE-METER-TYPE                               
                     ,:GM-METER-SIZE-ID                                 
                     ,:GM-CODE-CO-SIZE                                  
               FROM   CSS_GAS_METER                                     
T18652         WHERE  METER_NO       = :EQ-DEVICE-NO                    
TP3285           AND  CODE_UTIL_TYPE = :WS-G                            
T22243           AND  COMPANY_NO     = :GM-COMPANY-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00262500
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 00262500
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7030-SELECT-GAS-METER'                          
T18652         DISPLAY 'DEVICE NO    = ' EQ-DEVICE-NO                   
T22243         DISPLAY 'COMPANY NO   = ' GM-COMPANY-NO                  
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 00262500
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00262500
      ****************************************************************          
      **                                                            **          
      **  7050-SELECT-INSTR-XFORMER                                 **          
      **                                                            **          
      ****************************************************************          
       7050-SELECT-INSTR-XFORMER.                                       
      *                                                                 00262500
           EXEC SQL                                                     
               SELECT DEVICE_TYPE_CD                                    
T18652               ,XFORMER_TYPE_CD                                   
T18652               ,XFORMER_SIZE_ID                                   
T18652               ,XFORMER_SPEC_CD                                   
               INTO   :IX-DEVICE-TYPE-CD                                
T18652               ,:IX-XFORMER-TYPE-CD                               
T18652               ,:IX-XFORMER-SIZE-ID                               
T18652               ,:IX-XFORMER-SPEC-CD                               
               FROM   CSS_INSTR_XFORMER                                 
T18652         WHERE  XFORMER_NO = :EQ-DEVICE-NO                        
T22243           AND  COMPANY_NO = :IX-COMPANY-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00262500
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 00262500
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7050-SELECT-INSTR-XFORMER'                      
T18652         DISPLAY 'DEVICE NO    = ' EQ-DEVICE-NO                   
T22243         DISPLAY 'COMPANY NO   = ' IX-COMPANY-NO                  
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 00262500
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7100-OPEN-MOVEMENT-JUNK                                   **          
      **                                                            **          
      ****************************************************************          
       7100-OPEN-MOVEMENT-JUNK.                                         
      *                                                                         
           EXEC SQL                                                     
               OPEN MVH-JUNK                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7100-OPEN-MOVEMENT-JUNK'                        
               DISPLAY 'MOVE DATE1  = ' WS-MOVE-TS-DATE-1               
               DISPLAY 'MOVE DATE2  = ' WS-MOVE-TS-DATE-2               
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7101-FETCH-MOVEMENT-JUNK                                  **          
      **                                                            **          
      ****************************************************************          
       7101-FETCH-MOVEMENT-JUNK.                                        
      *                                                                         
           EXEC SQL                                                     
               FETCH MVH-JUNK                                           
               INTO :MV-CODE-DEVICE-TYPE                                
                   ,:MV-DEVICE-NO                                       
                   ,:MV-DATE-MOVE                                       
                   ,:MV-MOVE-NO                                         
                   ,:MV-LOCAL-OFFICE                                    
                   ,:MV-LOC-NO :WS-NULLIND-LOC-NO                      
                   ,:MV-CODE-CRNT-LOC                                   
                   ,:MV-CODE-UTIL-TYPE                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               DISPLAY 'DEVICE TYPE = ' MV-CODE-DEVICE-TYPE             
               DISPLAY 'UTIL   TYPE = ' MV-CODE-UTIL-TYPE               
               DISPLAY 'MOVE DATE1  = ' WS-MOVE-TS-DATE-1               
               DISPLAY 'MOVE DATE2  = ' WS-MOVE-TS-DATE-2               
           END-IF.                                                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7101-FETCH-MOVEMENT-JUNK'                       
               DISPLAY 'MOVE DATE1  = ' WS-MOVE-TS-DATE-1               
               DISPLAY 'MOVE DATE2  = ' WS-MOVE-TS-DATE-2               
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7101-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7102-CLOSE-MOVEMENT-JUNK                                  **          
      **                                                            **          
      ****************************************************************          
       7102-CLOSE-MOVEMENT-JUNK.                                        
      *                                                                         
           EXEC SQL                                                     
               CLOSE MVH-JUNK                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7102-CLOSE-MOVEMENT-JUNK'                       
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7102-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00262500
      ****************************************************************          
      **                                                            **          
      **  7200-OPEN-MOVEMENT-HIST2                                  **          
      **                                                            **          
      ****************************************************************          
       7200-OPEN-MOVEMENT-HIST-2.                                       
      *                                                                 00290500
           EXEC SQL                                                     
               OPEN MVHCUR-2                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00290500
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 00290500
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7200-OPEN-MOVE-HIST-2'                          
               DISPLAY 'DEVICE TYPE =' MV-CODE-DEVICE-TYPE              
               DISPLAY 'DEVICE NO   =' MV-DEVICE-NO                     
               DISPLAY 'MOVE NO     =' MV-MOVE-NO                       
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 00290500
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00290500
      ****************************************************************          
      **                                                            **          
      **  7210-FETCH-MOVEMENT-HIST2                                 **          
      **                                                            **          
      ****************************************************************          
       7210-FETCH-MOVEMENT-HIST-2.                                      
      *                                                                 00290500
           EXEC SQL                                                     
               FETCH MVHCUR-2                                           
               INTO :MV-CODE-DEVICE-TYPE,                               
                    :MV-DEVICE-NO,                                      
                    :MV-DATE-MOVE,                                      
                    :MV-MOVE-NO,                                        
                    :MV-LOCAL-OFFICE,                                   
                    :MV-LOC-NO,                                         
                    :MV-CODE-CRNT-LOC,                                  
                    :MV-CODE-UTIL-TYPE                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00290500
           DISPLAY '~~~~~~~~~~~~~~~~~~~~~'                              
           DISPLAY '7210-FETCH-MOVE-HIST-2'                             
           DISPLAY 'SQLCODE     = ' WS-ACTIVE-RETURN-CODE.              
           DISPLAY 'DEVICE TYPE = ' MV-CODE-DEVICE-TYPE.                
           DISPLAY 'DEVICE NO   = ' MV-DEVICE-NO.                       
           DISPLAY 'MOVE NO     = ' MV-MOVE-NO.                         
           DISPLAY 'CRNT LOC    = ' MV-CODE-CRNT-LOC.                   
      *                                                                 00290500
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 00290500
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7210-FETCH-MOVE-HIST-2'                         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 00290500
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00290500
      ****************************************************************          
      **                                                            **          
      **  7220-CLOSE-MOVEMENT-HIST2                                 **          
      **                                                            **          
      ****************************************************************          
       7220-CLOSE-MOVEMENT-HIST-2.                                      
      *                                                                 00290500
           EXEC SQL                                                     
               CLOSE MVHCUR-2                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00290500
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 00290500
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7220-CLOSE-MOVE-HIST-2'                         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 00290500
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00262500
      ****************************************************************          
      **                                                            **          
      **  7300-OPEN-ATTACH-CURSOR                                   **          
      **                                                            **          
      ****************************************************************          
       7300-OPEN-ATTACH-CURSOR.                                         
      *                                                                         
           EXEC SQL                                                     
               OPEN ATTACH_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7300-OPEN-ATTACH-CURSOR'                        
               DISPLAY 'UTIL   TYPE = ' LX-CODE-UTIL-TYPE               
               DISPLAY 'DEVICE TYPE = ' LX-CODE-ATT-TYPE                
               DISPLAY 'MOVE DATE1  = ' WS-MOVE-TO-DATE-1               
               DISPLAY 'MOVE DATE2  = ' WS-MOVE-TO-DATE-2               
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7310-FETCH-ATTACH-CURSOR                                  **          
      **                                                            **          
      ****************************************************************          
       7310-FETCH-ATTACH-CURSOR.                                        
      *                                                                         
           EXEC SQL                                                     
               FETCH ATTACH_CURSOR                                      
               INTO :LX-DEVICE-NO                                       
                   ,:LX-CODE-ATT-TYPE                                   
                   ,:LX-COMPANY-NO                                      
                   ,:LX-CODE-UTIL-TYPE                                  
                   ,:LX-EQUIP-LOC-ID                                    
                   ,:LX-MTR-STORAGE-FAC-CD                              
                   ,:LX-CODE-MAKE                                       
                   ,:LX-DATE-LAST-MOVE :WS-NULLIND-DATE-LAST-MOVE        
                   ,:LX-DATE-PURCHASED :WS-NULLIND-DATE-PURCHASED        
                   ,:LX-DATE-OBSOLETE :WS-NULLIND-DATE-OBSOLETE          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00290500
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7310-FETCH-ATTACH-CURSOR'                       
               DISPLAY 'UTILITY     = ' LX-CODE-UTIL-TYPE               
               DISPLAY 'TYPE        = ' LX-CODE-ATT-TYPE                
               DISPLAY 'SQLCODE     = ' SQLCODE                         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7320-CLOSE-ATTACH-CURSOR                                  **          
      **                                                            **          
      ****************************************************************          
       7320-CLOSE-ATTACH-CURSOR.                                        
      *                                                                         
           EXEC SQL                                                     
               CLOSE ATTACH_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7320-CLOSE-ATTACH-CURSOR'                       
               DISPLAY 'UTILITY     = ' LX-CODE-UTIL-TYPE               
               DISPLAY 'TYPE        = ' LX-CODE-ATT-TYPE                
               DISPLAY 'SQLCODE     = ' SQLCODE                         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00262500
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      *COPY CPD00039.                                                           
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  8000-WRITE-FCSMT01                                        **          
      **                                                            **          
      ****************************************************************          
       8000-WRITE-FCSMT01.                                              
      *                                                                 00296000
           ADD +1                      TO WS-FIOMT01-REC-COUNT.         
      *                                                                 00296000
           IF E-FMT01-KEY-EREC EQUAL HIGH-VALUES                        
T18652         SUBTRACT +2           FROM WS-FIOMT01-REC-COUNT          
               MOVE WS-FIOMT01-REC-COUNT                                
                                       TO E-FMT01-RECORD-COUNT-EREC     
           END-IF.                                                      
      *                                                                 00296000
           WRITE FIOMT01.                                               
      *                                                                 00296000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00296000
      ****************************************************************          
      **                                                            **          
      **  8100-WRITE-FCSMT02                                        **          
      **                                                            **          
      ****************************************************************          
       8100-WRITE-FCSMT02.                                              
      *                                                                 00296000
           WRITE FIOMT02.                                               
      *                                                                 00296000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00296000
      ****************************************************************          
ST    **  8200-WRITE-FCSMT22                                        **          
      ****************************************************************          
       8200-WRITE-FCSMT22.                                              
      *                                                                 00296000
           ADD +1                      TO WS-FIOMT22-REC-COUNT.         
      *                                                                 00296000
           IF E-FMT22-KEY-EREC EQUAL HIGH-VALUES                        
               SUBTRACT +2           FROM WS-FIOMT22-REC-COUNT          
               MOVE WS-FIOMT22-REC-COUNT                                
                                       TO E-FMT22-RECORD-COUNT-EREC     
           END-IF.                                                      
      *                                                                 00296000
           WRITE FIOMT22.                                               
      *                                                                 00296000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00296000
      ****************************************************************          
      **  8300-WRITE-FCSMT23                                        **          
      ****************************************************************          
       8300-WRITE-FCSMT23.                                              
      *                                                                 00296000
           ADD +1                      TO WS-FIOMT23-REC-COUNT.         
      *                                                                 00296000
           IF E-FMT23-KEY-EREC EQUAL HIGH-VALUES                        
               SUBTRACT +2           FROM WS-FIOMT23-REC-COUNT          
               MOVE WS-FIOMT23-REC-COUNT                                
                                       TO E-FMT23-RECORD-COUNT-EREC     
           END-IF.                                                      
      *                                                                 00296000
           WRITE FIOMT23.                                               
      *                                                                 00296000
       8300-EXIT.                                                       
END        EXIT.                                                        
      *                                                                 00296000
      ****************************************************************          
      **  8400-WRITE-FCSMT26                                        **          
      ****************************************************************          
       8400-WRITE-FCSMT26.                                              
      *                                                                 00296000
           ADD +1                      TO WS-FIOMT26-REC-COUNT.         
      *                                                                 00296000
           IF E-FMT26-KEY-EREC EQUAL HIGH-VALUES                        
               SUBTRACT +2           FROM WS-FIOMT26-REC-COUNT          
               MOVE WS-FIOMT26-REC-COUNT                                
                                       TO E-FMT26-RECORD-COUNT-EREC     
           END-IF.                                                      
      *                                                                 00296000
           WRITE FIOMT26.                                               
      *                                                                 00296000
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00296000
      ****************************************************************          
      **                                                            **          
      **  8900-PROCESS-END-CONTROL-REC                              **          
      **                                                            **          
      ****************************************************************          
       8900-PROCESS-END-CONTROL-REC.                                    
      *                                                                 00296000
           MOVE SPACES                 TO FIOMT01.                      
           MOVE HIGH-VALUES            TO E-FMT01-KEY-EREC.             
           PERFORM 8000-WRITE-FCSMT01            THRU 8000-EXIT.        
      *                                                                 00296000
T18652     MOVE SPACES                 TO FIOMT22.                      
ST         MOVE HIGH-VALUES            TO E-FMT22-KEY-EREC.             
           PERFORM 8200-WRITE-FCSMT22            THRU 8200-EXIT.        
      *                                                                 00296000
           MOVE SPACES                 TO FIOMT23.                      
           MOVE HIGH-VALUES            TO E-FMT23-KEY-EREC.             
END        PERFORM 8300-WRITE-FCSMT23            THRU 8300-EXIT.        
      *                                                                 00296000
           MOVE SPACES                 TO FIOMT26.                      
           MOVE HIGH-VALUES            TO E-FMT26-KEY-EREC.             
           PERFORM 8400-WRITE-FCSMT26            THRU 8400-EXIT.        
      *                                                                 00296000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00296000
      ****************************************************************          
      **                                                            **          
      **  9000-TERMINATE                                            **          
      **                                                            **          
      ****************************************************************          
       9000-TERMINATE.                                                  
      *                                                                 00296000
           CLOSE                                                        
               FCSMT01-FILE                                             
               FCSMT02-FILE                                             
T18652         FCSMT22-FILE                                             
T18652         FCSMT23-FILE                                             
               FCSMT26-FILE.                                            
      *                                                                 00296000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  9110-INVALID-PARAMETER                                    **          
      **                                                            **          
      ****************************************************************          
       9110-INVALID-PARAMETER.                                          
      *                                                                 00308000
           DISPLAY '*******************************'                    
           DISPLAY '*         PCSMT301'                                 
           DISPLAY '* INVALID PARAMETER ENCOUNTERED'                    
           DISPLAY '* ' E-FJC01-PARAMETER-DATA                          
           DISPLAY '*     PROGRAM TERMINATING'                          
           DISPLAY '*******************************'                    
           PERFORM 9900-ABEND                    THRU 9900-EXIT.        
      *                                                                 00308000
       9110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00312500
      ****************************************************************          
      **  9900-  THIS INCLUDES THE DB2 SQL ABEND MODULE             **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
