       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSMT102.                                            
       INSTALLATION.                                                    
       DATE-WRITTEN. MAY 24, 2010.                                      
       DATE-COMPILED.                                                   
       AUTHOR.  Satish Sivasubramanian.                                 
                                                                        
      *****************************************************************         
      **                                                             **         
      **             SOUTH CAROLINA ELECTRICITY  & GAS               **         
      **                                                             **         
      *********           CUSTOMER SERVICE SYSTEM             *********         
      *********                    DB2                        *********         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS      REASON                             **         
      ** --------   --------      -----------------------------------**         
      ** 06/10/10   SS95855       P#0279 New Program                 **         
P00279** 10/19/10   SS95855       Process barcode records that have  **         
P00279**                          Service orders override.           **         
P0279A** 03/21/11   SS95855       Update Status for Service Order Rec**         
P0279B** 09/26/11   SS95855       Fix Barcode records that processed **         
P0279B**                          Meter at Customer Location.        **         
A02863** 06/07/12   SS95855       Remove the exception that is no    **         
A02863**                          no longer needed - Meter is already**         
A02863**                          in that location, msf and crew-id. **         
A02863** 06/25/12   SS95855       TURN OFF ERROR MESSAGES            **         
A2863A** 12/18/12   SS95855       ALLOW 30 DAYS FOR RE-PROCESSING    **         
A2863A**                          FROM 10 DAYS.                      **         
A2863B** 04/04/13   SS95855       ERT COMES IN AS 12 CHARS FROM 09.  **         
A05136** 07/24/15   RS7M249       SKIP THE DEVICE IN ERROR AND WRITE **         
      **            ACT125        IT IN TO EXISTING ERROR FILE.      **         
A04200** 10/10/16   SS95855       Validate Blank Meter Location Code **         
      *****************************************************************         
           REMARKS.                                                     
      *****************************************************************         
      *                       PCSMT102 NARRATIVE                      *         
      *                       ------------------                      *         
      *                                                               *         
      *    Meter Asset Tracking                                       *         
      *    --------------------                                       *         
      *    This program updates the equipment location and creates a  *         
      *    movement history for the Meter/ERT received from the Vendor*         
      *    file.If there's an integrated Meter/ERT, it is moved along *         
      *    with it.                                                   *         
      *    The input file is the Barcode vendor file. Status and      *         
      *    Message fields are updated and transmitted back to the     *         
      *    Bar Code System.                                           *         
      *                                                               *         
      *    Status :       'C' - Successful Completion                 *         
      *                   'E' - Exception                             *         
      *                   'I' - Service order not complete            *         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
      *** SELECT STMT FOR INPUT FILE                                            
       COPY CSSM102.                                                            
      *                                                                         
      *** SELECT STMT FOR OUTPUT FILE                                           
       COPY CSSM102B.                                                           
      *                                                                         
      *** SELECT STMT FOR RESTART FILE                                          
       COPY CSSM102R.                                                           
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *** FD STMT FOR MT102 INPUT FILE                                          
       COPY CFDM102.                                                            
       COPY FIOMT102.                                                           
                                                                        
      *** FD STMT FOR M102B OUTPUT FILE                                         
       COPY CFDM102B.                                                           
       01  FIOM102B-REC                    PIC X(200).                  
                                                                        
      *** FD STMT FOR M102R RESTART FILE                                        
       COPY CFDM102R.                                                           
       01  FMT102R-REC                     PIC X(200).                  
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-MTR-STOR-FAC  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSMT102'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                        PIC X(40) VALUE              
                        'WORKING STORAGE FOR PCSMT102 STARTS HERE'.     
      *                                                                         
       01  WS-MISC.                                                     
      *                                                                         
           05  WS-FCSMT102-REC-CNTR        PIC 9(09) VALUE ZERO.        
           05  WS-SUB                      PIC 9(09) VALUE ZERO.        
           05  WS-RECEIVED-MOVE-DATE       PIC X(10) VALUE SPACES.      
A2863A     05  WS-CURRENT-30-DAYS          PIC X(10) VALUE SPACES.      
           05  WS-TEMP-MTR-MESG            PIC X(50) VALUE SPACES.      
           05  WS-TEMP-ERT-MESG            PIC X(50) VALUE SPACES.      
           05  WS-HOLD-ERR-MESG            PIC X(50) VALUE SPACES.      
           05  WS-HOLD-STATUS              PIC X(01) VALUE SPACES.      
           05  WS-DISPLAY-SQLCODE          PIC -ZZ9.                    
           05  WS-CURRENT-DATE             PIC X(10) VALUE SPACES.      
           05  WS-CURRENT-TIMESTMP         PIC X(26) VALUE SPACES.      
           05  WS-FRMT-MOVE-TS             PIC X(26) VALUE SPACES.      
           05  WS-FRMT-TIMESTAMP           PIC X(26) VALUE SPACES.      
           05  WS-I-RECORD-TS              PIC X(26) VALUE SPACES.      
           05  WS-I-DECRMT-TS              PIC X(26) VALUE SPACES.      
           05  WS-I-PREV-METER-ERT-NO      PIC X(12) VALUE SPACES.      
           05  WS-PREV-VALUES.                                          
               10  WS-PREV-COMP-NO         PIC X(02) VALUE SPACES.      
               10  WS-PREV-CODE-UTIL-TYPE  PIC X(01) VALUE SPACES.      
               10  WS-PREV-METER-ERT-FLAG  PIC X(01) VALUE SPACES.      
A2863B         10  WS-PREV-METER-ERT-NO    PIC X(12) VALUE SPACES.      
               10  WS-PREV-MOVE-TS         PIC X(26) VALUE SPACES.      
           05  WS-METER-NO                 PIC X(09) VALUE SPACES.      
           05  WS-ERT-NO                   PIC X(12) VALUE SPACES.      
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSMT102'.  
           05  PROGRAM-NAME                PIC X(08) VALUE 'PCSMT102'.  
           05  WS-COMPANY-NO               PIC X(02) VALUE '01'.        
           05  WS-I                        PIC X(01) VALUE 'I'.         
           05  WS-811                      PIC S9(9) VALUE -811 COMP.   
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-N                        PIC X(01) VALUE 'N'.         
           05  WS-YES                      PIC X(01) VALUE 'Y'.         
           05  WS-NO                       PIC X(01) VALUE 'N'.         
           05  WS-AT-CUSTOMER-LOCATION     PIC X(01) VALUE 'J'.         
           05  WS-DEVICE-ATTCHD-TO-MTR     PIC X(01) VALUE 'K'.         
           05  WS-METER                    PIC X(01) VALUE 'M'.         
           05  WS-ERT                      PIC X(01) VALUE 'E'.         
           05  WS-COMPLETED                PIC X(01) VALUE 'C'.         
           05  WS-EXCEPTION                PIC X(01) VALUE 'E'.         
           05  WS-UNKNOWN                  PIC X(01) VALUE 'U'.         
           05  WS-RETIRED                  PIC X(01) VALUE 'I'.         
           05  WS-INTEGRATED               PIC X(02) VALUE 'IT'.        
      *                                                                         
       01  WS-MTR-STOR-FAC-TABLE.                                       
           05 WS-MSF-COUNT                 PIC 9(05) VALUE ZERO.        
           05 WS-MSF-SUB                   PIC 9(05) VALUE ZERO.        
           05 WS-MSF-TABLE.                                             
              10 TAB-COMPANY-NO         OCCURS 1000 TIMES  PIC X(02).   
              10 TAB-CODE-UTIL-TYPE     OCCURS 1000 TIMES  PIC X(01).   
              10 TAB-MTR-STORAGE-FAC-CD OCCURS 1000 TIMES  PIC X(03).   
              10 TAB-EQUIP-LOC-ID       OCCURS 1000 TIMES  PIC X(01).   
      *                                                                         
       01  WS-EXCEPTION-MESSAGES.                                       
           05  WS-MESG-INVALID-DATE        PIC X(50) VALUE              
               'Move Date cannot be greater than current date'.         
      *                                                                         
           05  WS-MESG-INVALID-FLG         PIC X(50) VALUE              
               'Meter/ERT Flag should be M/E'.                          
      *                                                                         
           05  WS-MESG-LOC-J               PIC X(50) VALUE              
               'Cannot move from location J'.                           
      *                                                                         
           05  WS-MESG-NO-MTR              PIC X(50) VALUE              
               'Meter not in CIS'.                                      
      *                                                                         
           05  WS-MESG-NO-ERT              PIC X(50) VALUE              
               'ERT not in CIS'.                                        
      *                                                                         
           05  WS-MESG-LOC-K               PIC X(50) VALUE              
               'Meter Location is "K"'.                                 
ACT003*                                                                         
ACT003     05  WS-MESG-LOC-B               PIC X(50) VALUE              
ACT003         'Meter Location is Blank'.                               
      *                                                                         
           05  WS-MESG-CUST-LOC            PIC X(50) VALUE              
               'Meter at Customer Location'.                            
      *                                                                         
           05  WS-MESG-LOC-ID              PIC X(50) VALUE              
               'Location should be "K" for attached ERT'.               
      *                                                                         
           05  WS-MESG-DUPLICATE           PIC X(50) VALUE              
               'Record already processed'.                              
      *                                                                         
           05  WS-MESG-RMVD-METR           PIC X(50) VALUE              
               'Retiring Meter that is still at Customer Location'.     
      *                                                                         
           05  WS-MESG-MTR-MISS            PIC X(50) VALUE              
               'ERT at location "K" but no link to a meter'.            
      *                                                                         
           05  WS-MESG-MTR1                PIC X(50) VALUE              
               'Attached Meter not in CIS'.                             
      *                                                                         
           05  WS-MESG-MTR2                PIC X(50) VALUE              
               'Attached Meter at Customer location'.                   
      *                                                                         
           05  WS-MESG-ERT-MISS            PIC X(50) VALUE              
               'Attached ERT not in CIS'.                               
      *                                                                         
           05  WS-MESG-INVALID-MSF         PIC X(50) VALUE              
               'Invalid MSF Location Code combination'.                 
      *                                                                         
           05  WS-MESG-INVALID-TS          PIC X(50) VALUE              
               'Invalid Timestamp on record'.                           
      *                                                                         
           05  WS-MESG-MTR-EXIST           PIC X(50) VALUE              
               'Meter is already in that location, msf and crew id'.    
      *                                                                         
           05  WS-MESG-ERT-EXIST           PIC X(50) VALUE              
               'ERT is already in that location, msf and crew id'.      
      *                                                                         
           05  WS-MESG-CREW-ID             PIC X(50) VALUE              
               "Crew ID must be in location 'C'".                       
      *                                                                         
           05  WS-MESG-DAYS-OLD.                                        
               10  WS-PRE-TEXT             PIC X(34) VALUE              
                   'Record movement date is more than '.                
A2863A         10  WS-30-DAYS              PIC X(02) VALUE              
A2863A             '30'.                                                
               10  WS-SUF-TEXT             PIC X(14) VALUE              
                   ' days old'.                                         
      *                                                                         
       01  WS-NULL-INDS.                                                
           05  WS-NULL-IND-1               PIC S9(04) COMP VALUE +0.    
           05  WS-NULL-IND-2               PIC S9(04) COMP VALUE +0.    
           05  WS-NULL-IND-3               PIC S9(04) COMP VALUE +0.    
           05  WS-NULL-IND-4               PIC S9(04) COMP VALUE +0.    
      *                                                                         
       01  WS-ATT-ERT-TABLE.                                            
           05  WS-ATT-ERT-DATA                                          
                              OCCURS 05 TIMES.                          
               10  WS-EQUIP-LOC-ID         PIC X(01) VALUE SPACES.      
               10  WS-MTR-STORAGE-FAC-CD   PIC X(03) VALUE SPACES.      
               10  WS-CODE-ATT-TYPE        PIC X(02) VALUE SPACES.      
               10  WS-DATE-LAST-MOVE       PIC X(10) VALUE SPACES.      
               10  WS-DATE-LAST-TRAN       PIC X(10) VALUE SPACES.      
               10  WS-IN-TRANSIT-EMP-ID    PIC X(07) VALUE SPACES.      
               10  WS-DEVICE-NO            PIC X(12) VALUE SPACES.      
               10  WS-CODE-UTIL-TYPE       PIC X(01) VALUE SPACES.      
               10  WS-COMPANY-NO-ERT       PIC X(02) VALUE SPACES.      
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-FCSMT102-STATUS          PIC X(02).                   
               88  FCSMT102-SUCCESSFUL               VALUE '00'.        
               88  FCSMT102-READ-EOF                 VALUE '10'.        
           05  WS-FCSM102B-STATUS          PIC X(02).                   
               88  FCSM102B-SUCCESSFUL               VALUE '00'.        
               88  FCSM102B-READ-EOF                 VALUE '10'.        
           05  WS-FCSM102R-STATUS          PIC X(02).                   
               88  FCSM102R-SUCCESSFUL               VALUE '00'.        
               88  FCSM102R-READ-EOF                 VALUE '10'.        
           05  WS-FCSMT102-EOF             PIC X(01) VALUE 'N'.         
               88  END-OF-FILE-FCSMT102              VALUE 'Y'.         
           05  WS-SKIP-RECORD              PIC X(01) VALUE 'N'.         
               88  SKIP-RECORD                       VALUE 'Y'.         
A02863     05  WS-IGNORE-RECORD            PIC X(01) VALUE 'N'.         
A02863         88  IGNORE-RECORD                     VALUE 'Y'.         
           05  WS-METER-ERT-ATTACHED       PIC X(01) VALUE 'N'.         
               88  METER-ERT-ATTACHED                VALUE 'Y'.         
           05  WS-VALID-MSF-CODE           PIC X(01) VALUE 'N'.         
               88  VALID-MSF-CODE                    VALUE 'Y'.         
           05  WS-MTR-VALIDATION           PIC X(01).                   
               88  PASS-MTR-VALIDATION               VALUE 'Y'.         
               88  FAIL-MTR-VALIDATION               VALUE 'N'.         
           05  WS-ERT-VALIDATION           PIC X(01).                   
               88  PASS-ERT-VALIDATION               VALUE 'Y'.         
               88  FAIL-ERT-VALIDATION               VALUE 'N'.         
P00279     05  WS-SERV-ORDER-CHECK-REC     PIC X(01).                   
P00279         88  SERV-ORDER-CHECK-REC              VALUE 'Y'.         
P00279         88  SERV-ORDER-CHECK-REC-NO           VALUE 'N'.         
      *                                                                         
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE     PIC 9(01).                   
           05  WS-RESTART-JOB-COMPLETE     REDEFINES                    
               WS-RESTART-PROCESS-TYPE     PIC X(01).                   
           05  WS-RESTART-JOB-STATUS       PIC X(01).                   
               88  WS-RUN-COMPLETED-NO-PROBLEMS VALUE 'A'.              
               88  WS-RERUN-COMPLETED           VALUE 'B'.              
               88  WS-RERUN-PENDING             VALUE 'C'.              
           05  WS-RESTART-INPUT-DATE       PIC X(10) VALUE SPACES.      
           05  WS-RESTART-COMP-NO          PIC X(02) VALUE SPACES.      
           05  WS-RESTART-CODE-UTIL-TYPE   PIC X(01) VALUE SPACES.      
A2863B     05  WS-RESTART-METER-ERT-NO     PIC X(12) VALUE SPACES.      
           05  WS-RESTART-METER-ERT-FLAG   PIC X(01) VALUE SPACES.      
           05  WS-RESTART-MOVE-TS          PIC X(26) VALUE SPACES.      
           05  WS-RESTART-RECORD-NO        PIC 9(09) VALUE ZERO.        
           05  WS-RESTART-CHKP-SEQ-NO      PIC 9(09) VALUE ZERO.        
      *                                                                         
       01  WS-RESTART-MISC.                                             
A2863B     05  WS-RESTART-DATA-LENGTH      PIC S9(04) COMP VALUE +72.   
           05  WS-IS-THIS-A-RESTART        PIC X(01) VALUE 'N'.         
               88  WS-THIS-IS-A-RESTART              VALUE 'Y'.         
           05  WS-COMMIT-REQ-SW            PIC 9(1)  VALUE 0.           
               88 COMMITS-REQUIRE                    VALUE 0.           
               88 COMMITS-NOT-REQUIRE                VALUE 1.           
           05  WS-RESTART-REQ              PIC X(01).                   
           05  WS-DEFAULT-RESTART-REQ      PIC X(01) VALUE 'N'.         
           05  WS-REPOSITION-NEEDED        PIC X(01) VALUE 'Y'.         
           05  WS-CHKP-SEQ-NO              PIC 9(05) VALUE ZERO.        
           05  WS-COMMIT-COUNT             PIC 9(07) VALUE ZERO.        
           05  WS-FLAG-TO-TURN-OFF-COMMITS PIC 9(04) VALUE 9999.        
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 4.           
           05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 20.          
           05  WS-CHKP-LUW-LIMIT           PIC 9(04).                   
           05  WS-CHKP-UPD-LIMIT           PIC 9(04).                   
           05  WS-COUNT-UNSUCCESSFUL-ROWS  PIC S9(04) COMP-3 VALUE ZERO.
      *                                                                         
       01  WS-END                          PIC X(40) VALUE              
                       'WORKING STORAGE FOR PCSMT102 ENDS HERE  '.      
                                                                        
      *===============================================================*         
      *    CSS_JOB_PARM G6                                            *         
      *===============================================================*         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_EQUIPMENT EQ                                           *         
      *===============================================================*         
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_EQUIP_ATTCHMTS LX                                      *         
      *===============================================================*         
           EXEC SQL                                                             
               INCLUDE TBEQATTH                                                 
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_METER_ATTCHMTS MA                                      *         
      *===============================================================*         
           EXEC SQL                                                             
               INCLUDE TBMTRATT                                                 
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_MOVEMENT_HIST MV                                       *         
      *===============================================================*         
           EXEC SQL                                                             
               INCLUDE TBMVHIST                                                 
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_EQUIP_ATT_MOVE MP                                      *         
      *===============================================================*         
           EXEC SQL                                                             
               INCLUDE TBEQMOVE                                                 
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_MTRD_ENVRNMT MN                                        *         
      *===============================================================*         
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_ACCOUNT AT                                             *         
      *===============================================================*         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_CUST_PREM_HIST CH                                      *         
      *===============================================================*         
           EXEC SQL                                                             
               INCLUDE TBCSTPRM                                                 
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_MTR_STORGE_LOC JB                                      *         
      *===============================================================*         
           EXEC SQL                                                             
               INCLUDE TBSTRGLO                                                 
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_RESTART RF                                             *         
      *===============================================================*         
           EXEC SQL                                                             
              INCLUDE TBRESTRT                                                  
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    SQL COMMUNICATION AREA                                     *         
      *===============================================================*         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      * WORKING STORAGE FOR COPYBOOKS                                 *         
      *===============================================================*         
      *                                                                         
      *** FCA00-KEY                                                             
           EXEC SQL                                                             
              INCLUDE FIOCA00                                                   
           END-EXEC.                                                            
                                                                        
      *** IO AREA FOR PARM INPUT FILE 'A'                                       
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
                                                                        
      *** MISC INPUT                                                            
           EXEC SQL                                                             
               INCLUDE CWS00038                                                 
           END-EXEC.                                                            
                                                                        
      *** FCA00 MISC INPUT                                                      
           EXEC SQL                                                             
               INCLUDE CWS00039                                                 
           END-EXEC.                                                            
                                                                        
      ***  WORKING STORAGE COPY BOOK FOR CPDCA099                               
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
                                                                        
      *** WARNING DATA                                                          
       COPY CWS00303.                                                           
                                                                        
      *** ABEND SWITCH                                                          
       COPY CWS09900.                                                           
                                                                        
      *** ABEND WORK AREA                                                       
       COPY CWS00010.                                                           
                                                                        
      *================================================================*        
      *          CURSOR TO CHECK IF REMOVED METER IS INSTALLED OR NOT  *        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               DECLARE CHECK_REMOVED_MTR CURSOR FOR                     
                  SELECT AT.ACCOUNT_NO                                  
                        ,AT.PREMISE_NO                                  
                        ,AT.CODE_ACCT_STAT                              
                  FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)               
                  WHERE MN.ACCOUNT_NO       = AT.ACCOUNT_NO             
                  AND MN.CODE_UTIL_TYPE     = :MN-CODE-UTIL-TYPE        
                  AND AT.COMPANY_NO         = :AT-COMPANY-NO            
                  AND MN.METER_NO           = :MN-METER-NO              
                  AND MN.CODE_METER_STATUS <> 'K'                       
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CHECK_REMOVED_MTR CURSOR FOR                             
MFA-TR*           SELECT AT.ACCOUNT_NO                                          
MFA-TR*                 ,AT.PREMISE_NO                                          
MFA-TR*                 ,AT.CODE_ACCT_STAT                                      
MFA-TR*           FROM  CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_MTRD_ENVRNMT MN                                     
MFA-TR*           WHERE MN.ACCOUNT_NO       = AT.ACCOUNT_NO                     
MFA-TR*           AND MN.CODE_UTIL_TYPE     = :MN-CODE-UTIL-TYPE                
MFA-TR*           AND AT.COMPANY_NO         = :AT-COMPANY-NO                    
MFA-TR*           AND MN.METER_NO           = :MN-METER-NO                      
MFA-TR*           AND MN.CODE_METER_STATUS <> 'K'                               
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7110                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *================================================================*        
      *          CURSOR DECLARATION FOR ATTACHED ERT                   *        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               DECLARE ATTACHED_ERT CURSOR FOR                          
                  SELECT MA.DEVICE_NO                                   
                  FROM CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)              
                  WHERE MA.COMPANY_NO        = :MA-COMPANY-NO           
                  AND   MA.CODE_UTIL_TYPE    = :MA-CODE-UTIL-TYPE       
                  AND   MA.CODE_ATT_TYPE     = 'IT'                     
                  AND   MA.METER_NO          = :MA-METER-NO             
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ATTACHED_ERT CURSOR FOR                                  
MFA-TR*           SELECT MA.DEVICE_NO                                           
MFA-TR*           FROM CSS_METER_ATTCHMTS MA                                    
MFA-TR*           WHERE MA.COMPANY_NO        = :MA-COMPANY-NO                   
MFA-TR*           AND   MA.CODE_UTIL_TYPE    = :MA-CODE-UTIL-TYPE               
MFA-TR*           AND   MA.CODE_ATT_TYPE     = 'IT'                             
MFA-TR*           AND   MA.METER_NO          = :MA-METER-NO                     
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7410                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *================================================================*        
      *          CURSOR DECLARATION FOR CSS_MTR_STORGE_LOC             *        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               DECLARE MTR_STOR_FAC CURSOR WITH ROWSET POSITIONING FOR  
                  SELECT JB.COMPANY_NO                                  
                        ,JB.CODE_UTIL_TYPE                              
                        ,JB.MTR_STORAGE_FAC_CD                          
                        ,JB.EQUIP_LOC_ID                                
                  FROM CSS_MTR_STORGE_LOC JB WITH(READUNCOMMITTED)              
                  WHERE JB.EQUIP_LOC_ID IN ('A','B','C','I')            
                  ORDER BY JB.COMPANY_NO                                
                          ,JB.CODE_UTIL_TYPE                            
                          ,JB.MTR_STORAGE_FAC_CD                        
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MTR_STOR_FAC CURSOR WITH ROWSET POSITIONING FOR          
MFA-TR*           SELECT JB.COMPANY_NO                                          
MFA-TR*                 ,JB.CODE_UTIL_TYPE                                      
MFA-TR*                 ,JB.MTR_STORAGE_FAC_CD                                  
MFA-TR*                 ,JB.EQUIP_LOC_ID                                        
MFA-TR*           FROM CSS_MTR_STORGE_LOC JB                                    
MFA-TR*           WHERE JB.EQUIP_LOC_ID IN ('A','B','C','I')                    
MFA-TR*           ORDER BY JB.COMPANY_NO                                        
MFA-TR*                   ,JB.CODE_UTIL_TYPE                                    
MFA-TR*                   ,JB.MTR_STORAGE_FAC_CD                                
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7510                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
                                                                        
      *================================================================*        
      *   0000-MAINLINE                                                *        
      *        CONTROLS THE MAIN PATH OF PROGRAM                       *        
      *================================================================*        
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT.                                           
      *                                                                         
           PERFORM 0400-LOAD-MSF-CODE                                   
              THRU 0400-EXIT.                                           
      *                                                                         
           PERFORM 1000-PROCESS-FCSMT102                                
              THRU 1000-EXIT                                            
             UNTIL END-OF-FILE-FCSMT102.                                
      *                                                                         
           PERFORM 3000-WRITE-CNTRL-REC                                 
              THRU 3000-EXIT.                                           
      *                                                                         
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT.                                           
      *                                                                         
           DISPLAY ' '                                                  
           DISPLAY '******************************************'         
           DISPLAY '*    PCSMT102 COMPLETED SUCCESSFULLY     *'         
           DISPLAY '******************************************'         
           DISPLAY ' '                                                  
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       0100-INITIALIZATION.                                             
      *================================================================*        
      *                                                                         
           OPEN INPUT FCSMT102-FILE.                                    
                                                                        
           IF  FCSMT102-SUCCESSFUL                                      
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '************ PCSMT102 ERROR ******************'  
              DISPLAY '**        0100-INITIALIZATION               **'  
              DISPLAY '** OPEN FILE FCSMT102-FILE                  **'  
              DISPLAY '** FILE STATUS = ' WS-FCSMT102-STATUS            
              DISPLAY '** PROCESSING TERMINATED.......             **'  
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSM102B-FILE.                                   
                                                                        
           IF FCSM102B-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************ PCSMT102 ERROR ******************'  
              DISPLAY '**        0100-INITIALIZATION               **'  
              DISPLAY '** OPEN FILE FCSM102B-FILE                  **'  
              DISPLAY '** FILE STATUS = ' WS-FCSM102B-STATUS            
              DISPLAY '** PROCESSING TERMINATED.......             **'  
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
                                                                        
           PERFORM 7900-GET-CURRENT-DATE-TS                             
              THRU 7900-EXIT.                                           
                                                                        
           MOVE WS-COMPANY-NO              TO  G6-COMPANY-NO.           
           PERFORM 0150-GET-PARM-DATA                                   
              THRU 0150-EXIT.                                           
                                                                        
      *** Check job_parm table to get ws-restart-req flag                       
           PERFORM 6235-GET-FJC01-RESTART-REQ                           
              THRU 6235-EXIT.                                           
                                                                        
      *** Check css_restart table to get prior run last commited data           
           PERFORM 0600-CHECK-FOR-RESTART                               
              THRU 0600-EXIT.                                           
                                                                        
      *** Validate Job_Parm & CSS_Restart Status                                
           PERFORM 0605-VALIDATE-RESTART-REQ                            
              THRU 0605-EXIT.                                           
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-Y                    TO WS-REPOSITION-NEEDED      
              PERFORM 0601-REPOSITION-INPUT-FILE                        
                 THRU 0601-EXIT                                         
              PERFORM 0700-REPOSITION-OUTPUT-FILE                       
                 THRU 0700-EXIT                                         
           ELSE                                                         
              PERFORM 0610-INITIALIZE-RESTART                           
                 THRU 0610-EXIT                                         
           END-IF.                                                      
                                                                        
      *** Check for empty input file                                            
           PERFORM 7000-READ-FCSMT102                                   
              THRU 7000-EXIT.                                           
                                                                        
           IF FCSMT102-READ-EOF AND                                     
              NOT WS-THIS-IS-A-RESTART                                  
              DISPLAY '******************************************'      
              DISPLAY '**             PCSMT102                 **'      
              DISPLAY '**        FIOMT102 FILE IS EMPTY        **'      
              DISPLAY '**    THIS IS OK, IF MEANT TO BE EMPTY  **'      
              DISPLAY '******************************************'      
              MOVE 05                       TO  RETURN-CODE             
              STOP RUN                                                  
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       0150-GET-PARM-DATA.                                              
      *================================================================*        
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE                                  
              THRU 6251-EXIT.                                           
                                                                        
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE                        
                 THRU 6240-EXIT                                         
              DISPLAY 'COMMON DATE ==> ' WS-FCA00-COMMON-DATE           
              MOVE WS-FCA00-COMMON-DATE    TO WS-INPUT-DATE             
           END-IF.                                                      
                                                                        
           DISPLAY ' '                                                  
           DISPLAY    'RUN DATE    ==> ' WS-INPUT-DATE                  
                                                                        
           PERFORM 6253-GET-FJC01-CHKP-LIMIT                            
              THRU 6253-EXIT.                                           
                                                                        
           IF WS-CHKP-LUW-LIMIT = WS-FLAG-TO-TURN-OFF-COMMITS           
             AND WS-CHKP-UPD-LIMIT = WS-FLAG-TO-TURN-OFF-COMMITS        
              SET COMMITS-NOT-REQUIRE      TO TRUE                      
              DISPLAY ' '                                               
              DISPLAY '**   ' WS-PGRMNAME ' INFORMATIONAL MSG    **'    
              DISPLAY '**   CHKP-LUW AND CHKP-UPD PARMS   **'           
              DISPLAY '** BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS     
                      ', INTERPRETED TO**'                              
              DISPLAY '**  INDICATE THAT INTERIM COMMIT   **'           
              DISPLAY '**   POINTS SHOULD NOT BE TAKEN.   **'           
              DISPLAY '** COMPLETE RERUN WILL BE REQUIRED **'           
              DISPLAY '**  UPON UNSUCCESSFUL COMPLETION.  **'           
              DISPLAY '**      PROCESSING CONTINUING      **'           
           END-IF.                                                      
      *                                                                         
       0150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       0400-LOAD-MSF-CODE.                                              
      *================================================================*        
      *                                                                         
           INITIALIZE WS-MTR-STOR-FAC-TABLE.                            
      *                                                                         
           PERFORM 7510-OPEN-MTR-STOR-FAC  THRU 7510-EXIT.              
      *                                                                         
           PERFORM 7520-FETCH-MTR-STOR-FAC THRU 7520-EXIT               
                                                                        
           IF WS-MSF-COUNT = 0                                          
              DISPLAY '************ PCSMT102 ERROR **********'          
              DISPLAY '**   0400-LOAD-MSF-CODE             **'          
              DISPLAY '*** ZERO ROWS SELECTED FROM CSS_MTR_STORGE_LOC'  
              DISPLAY '**  PROGRAM ABORTING...             **'          
              DISPLAY '**************************************'          
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF                                                       
                                                                        
           IF WS-MSF-COUNT >= 1000                                      
              DISPLAY '************ PCSMT102 ERROR **********'          
              DISPLAY '**        0400-LOAD-MSF-CODE        **'          
              DISPLAY '***         ARRAY OVERFLOW:        ***'          
              DISPLAY '** EXPECTED MTR_STOR_FAC ROWS BELOW 1000'        
              DISPLAY '**  PROGRAM ABORTING...             **'          
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF                                                       
                                                                        
           PERFORM 7530-CLOSE-MTR-STOR-FAC  THRU 7530-EXIT.             
      *                                                                         
       0400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       0600-CHECK-FOR-RESTART.                                          
      *================================================================*        
      *                                                                         
           MOVE PROGRAM-NAME               TO RF-NAME-PROGRAM.          
           MOVE 1                          TO RF-PARTITION-NO           
                                              RF-DUP-CNTRL-NO.          
           PERFORM 7800-SELECT-RESTART-DATA                             
              THRU 7800-EXIT.                                           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE RF-RESTART-DATA-TEXT    TO WS-RESTART-DATA           
                                                                        
              IF WS-RESTART-PROCESS-TYPE NUMERIC                        
                 MOVE WS-YES               TO WS-IS-THIS-A-RESTART      
              ELSE                                                      
                 MOVE WS-NO                TO WS-IS-THIS-A-RESTART      
              END-IF                                                    
           ELSE                                                         
              MOVE WS-NO                   TO WS-IS-THIS-A-RESTART      
           END-IF.                                                      
      *                                                                         
       0600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       0601-REPOSITION-INPUT-FILE.                                      
      *================================================================*        
      *** Reposition input file to last successful commit                       
      *                                                                         
           MOVE ZERO                       TO WS-FCSMT102-REC-CNTR.     
                                                                        
           PERFORM 7000-READ-FCSMT102                                   
              THRU 7000-EXIT                                            
             UNTIL WS-FCSMT102-REC-CNTR = WS-RESTART-RECORD-NO          
                OR END-OF-FILE-FCSMT102.                                
                                                                        
      *****************************************************************         
      *    THE FOLLOWING CODE COMPARES KEY VALUES STORED IN                     
      *    RESTART DATA WITH REPOSITIONED RECORD KEY.                           
      *****************************************************************         
           IF  WS-RESTART-COMP-NO        NOT = E-FIOMT102-COMP-NO       
           AND WS-RESTART-CODE-UTIL-TYPE NOT = E-FIOMT102-UTIL-TYPE     
           AND WS-RESTART-METER-ERT-NO   NOT = E-FIOMT102-METER-ERT-NO  
           AND WS-RESTART-METER-ERT-FLAG NOT = E-FIOMT102-METER-ERT-FLAG
           AND WS-RESTART-MOVE-TS        NOT = E-FIOMT102-MOVE-TIMESTMP 
                                                                        
              DISPLAY '************ PCSMT102 ERROR ******************'  
              DISPLAY '**     0601-REPOSITION-INPUT-FILE           **'  
              DISPLAY '** FAIL TO REPOSITION MT102 FILE            **'  
                      '** CHECK FOR CORRECT  MT102 FILE            **'  
              DISPLAY ' '                                               
              DISPLAY '** LAST RECORD  PROCESSED IN PRIOR RUN: '        
              DISPLAY '  COMP-NO          '  WS-RESTART-COMP-NO         
              DISPLAY '  CODE-UTIL-TYPE   '  WS-RESTART-CODE-UTIL-TYPE  
              DISPLAY '  METER-ERT-NO     '  WS-RESTART-METER-ERT-NO    
              DISPLAY '  METER-ERT-FLAG   '  WS-RESTART-METER-ERT-FLAG  
              DISPLAY '  MOVE-DATE        '  WS-RESTART-MOVE-TS         
              DISPLAY ' '                                               
              DISPLAY '** BUT FILE POSITIONED AT             : '        
              DISPLAY '  COMP-NO          '  E-FIOMT102-COMP-NO         
              DISPLAY '  CODE-UTIL-TYPE   '  E-FIOMT102-UTIL-TYPE       
              DISPLAY '  METER-ERT-NO     '  E-FIOMT102-METER-ERT-NO    
              DISPLAY '  METER-ERT-FLAG   '  E-FIOMT102-METER-ERT-FLAG  
              DISPLAY '  MOVE-TS          '  E-FIOMT102-MOVE-TIMESTMP   
                                                                        
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
                                                                        
      *****************************************************************         
      *    THE FOLLOWING CODE COMPARES RUN DATE STORED IN                       
      *    RESTART DATA TO RUN DATE FROM JOB CONTROL FILE:                      
      *****************************************************************         
           IF WS-RESTART-INPUT-DATE = WS-INPUT-DATE                     
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '************ PCSMT102 ERROR ******************'  
              DISPLAY '**     0601-REPOSITION-INPUT-FILE           **'  
              DISPLAY '***************************************'         
              DISPLAY '** RUN DATE WAS CHANGED PRIOR TO '               
                      'RESTART **'                                      
              DISPLAY '***************************************'         
              DISPLAY '** OLD RUN DATE = ' WS-RESTART-INPUT-DATE        
              DISPLAY '** NEW RUN DATE = ' WS-INPUT-DATE                
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
                                                                        
           DISPLAY '*******************************************'.       
           DISPLAY '*****  THIS IS A RESTART OF PCSMT102  *****'.       
           DISPLAY '*******************************************'.       
                                                                        
           MOVE WS-RESTART-CHKP-SEQ-NO     TO WS-CHKP-SEQ-NO.           
      *                                                                         
       0601-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
      *  0605-VALIDATE-RESTART-REQ                                              
      *================================================================*        
       COPY CPD00030.                                                           
                                                                        
      *================================================================*        
       0610-INITIALIZE-RESTART.                                         
      *================================================================*        
      *                                                                         
           MOVE ZEROS                      TO WS-RESTART-PROCESS-TYPE   
                                              WS-RESTART-CHKP-SEQ-NO    
                                              WS-RESTART-RECORD-NO.     
           MOVE SPACES                     TO WS-RESTART-METER-ERT-NO   
                                              WS-RESTART-COMP-NO        
                                              WS-RESTART-CODE-UTIL-TYPE 
                                              WS-RESTART-METER-ERT-FLAG 
                                              WS-RESTART-MOVE-TS.       
           SET WS-RERUN-PENDING            TO TRUE.                     
           MOVE WS-INPUT-DATE              TO WS-RESTART-INPUT-DATE.    
           MOVE WS-N                       TO WS-REPOSITION-NEEDED.     
      *                                                                         
       0610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       0700-REPOSITION-OUTPUT-FILE.                                     
      *================================================================*        
      *                                                                         
           OPEN INPUT FCSM102R-FILE.                                    
                                                                        
           IF NOT FCSM102R-SUCCESSFUL                                   
              DISPLAY '************ PCSMT102 ERROR ******************'  
              DISPLAY '**   0700-REPOSITION-OUTPUT-FILE            **'  
              DISPLAY '** OPEN FILE FCSM102R-FILE                  **'  
              DISPLAY '** FILE STATUS = ' WS-FCSM102R-STATUS            
              DISPLAY '** PROCESSING TERMINATED.......             **'  
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
                                                                        
           PERFORM WS-RESTART-RECORD-NO TIMES                           
              READ FCSM102R-FILE                                        
                IF FCSM102R-SUCCESSFUL                                  
                   WRITE FIOM102B-REC FROM FMT102R-REC                  
                   IF FCSM102B-SUCCESSFUL                               
                      CONTINUE                                          
                   ELSE                                                 
                      DISPLAY '************ PCSMT102 ERROR **********'  
                      DISPLAY '**   0700-REPOSITION-OUTPUT-FILE    **'  
                      DISPLAY '** REWRITE OF FILE FCSM102B         **'  
                      DISPLAY '** FILE STATUS = ' WS-FCSM102B-STATUS    
                      DISPLAY '** PROCESSING TERMINATED.......     **'  
                      PERFORM 9900-ABEND                                
                         THRU 9900-EXIT                                 
                   END-IF                                               
                ELSE                                                    
                   DISPLAY '************ PCSMT102 ERROR **************' 
                   DISPLAY '**   0700-REPOSITION-OUTPUT-FILE        **' 
                   DISPLAY '** PREMATURE EOF FCSM102R RESTART       **' 
                   DISPLAY '** FILE STATUS = ' WS-FCSM102R-STATUS       
                   DISPLAY '** PROCESSING TERMINATED.......         **' 
                   PERFORM 9900-ABEND                                   
                      THRU 9900-EXIT                                    
                END-IF                                                  
           END-PERFORM.                                                 
                                                                        
           CLOSE FCSM102R-FILE.                                         
      *                                                                         
        0700-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *================================================================*        
       1000-PROCESS-FCSMT102.                                           
      *================================================================*        
      *                                                                         
           MOVE SPACES                     TO WS-HOLD-STATUS            
                                              WS-HOLD-ERR-MESG          
                                              WS-FRMT-TIMESTAMP         
                                              WS-FRMT-MOVE-TS           
                                              WS-RECEIVED-MOVE-DATE     
                                              WS-ERT-NO                 
                                              WS-METER-NO               
P00279                                        WS-SERV-ORDER-CHECK-REC.  
                                                                        
           MOVE ZERO                       TO WS-NULL-INDS.             
                                                                        
           MOVE WS-N                       TO WS-SKIP-RECORD            
A02863                                        WS-IGNORE-RECORD.         
                                                                        
           PERFORM 1100-EDIT-INPUTS                                     
              THRU 1100-EXIT.                                           
                                                                        
           IF SKIP-RECORD                                               
              MOVE WS-EXCEPTION            TO WS-HOLD-STATUS            
           ELSE                                                         
A02863        IF IGNORE-RECORD                                          
A02863           MOVE WS-COMPLETED         TO WS-HOLD-STATUS            
A02863           MOVE SPACES               TO WS-HOLD-ERR-MESG          
A02863           DISPLAY ' IGNORED : ' E-FIOMT102-METER-ERT-NO          
A02863        ELSE                                                      
                 PERFORM 1300-PROCESS-MOVE-RECORD                       
                    THRU 1300-EXIT                                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 2900-PREPARE-FCSM102B                                
              THRU 2900-EXIT.                                           
                                                                        
           PERFORM 8000-WRITE-FCSM102B                                  
              THRU 8000-EXIT.                                           
                                                                        
           PERFORM 7000-READ-FCSMT102                                   
              THRU 7000-EXIT.                                           
                                                                        
           COMPUTE WS-COMMIT-COUNT = WS-COMMIT-COUNT + 1.               
           IF COMMITS-REQUIRE AND                                       
              WS-COMMIT-COUNT >= WS-CHKP-LUW-LIMIT                      
              IF E-FIOMT102-METER-ERT-NO NOT = WS-PREV-METER-ERT-NO     
                 PERFORM 8898-ISSUE-CHKP                                
                    THRU 8898-EXIT                                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1100-EDIT-INPUTS.                                                
      *================================================================*        
      *                                                                         
           MOVE E-FIOMT102-COMP-NO         TO WS-RESTART-COMP-NO.       
           MOVE E-FIOMT102-UTIL-TYPE       TO WS-RESTART-CODE-UTIL-TYPE.
           MOVE E-FIOMT102-METER-ERT-FLAG  TO WS-RESTART-METER-ERT-FLAG.
           MOVE E-FIOMT102-METER-ERT-NO    TO WS-RESTART-METER-ERT-NO.  
           MOVE E-FIOMT102-MOVE-TIMESTMP   TO WS-RESTART-MOVE-TS.       
                                                                        
           MOVE E-FIOMT102-MOVE-TIMESTMP   TO WS-FRMT-MOVE-TS.          
           PERFORM 7910-GET-RECEIVED-MOVE-DATE                          
              THRU 7910-EXIT.                                           
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              SET SKIP-RECORD              TO TRUE                      
              MOVE WS-MESG-INVALID-TS      TO WS-HOLD-ERR-MESG          
              GO TO 1100-EXIT                                           
           END-IF.                                                      
      *                                                                         
      *** Do not Move Meter if Move date is > Current date                      
           IF WS-RECEIVED-MOVE-DATE > WS-CURRENT-DATE                   
              SET SKIP-RECORD              TO TRUE                      
              MOVE WS-MESG-INVALID-DATE    TO WS-HOLD-ERR-MESG          
              GO TO 1100-EXIT                                           
           END-IF.                                                      
      *                                                                         
      *** Do not Move Meter if record movement date is > 30 days old            
A2863A     IF WS-RECEIVED-MOVE-DATE < WS-CURRENT-30-DAYS                
              SET SKIP-RECORD              TO TRUE                      
              MOVE WS-MESG-DAYS-OLD       TO WS-HOLD-ERR-MESG           
              GO TO 1100-EXIT                                           
           END-IF.                                                      
      *                                                                         
      *** Validate the MSF Code from the barcode file                           
           MOVE WS-N                       TO WS-VALID-MSF-CODE.        
                                                                        
           PERFORM VARYING WS-MSF-SUB FROM 1 BY 1                       
             UNTIL WS-MSF-SUB > WS-MSF-COUNT                            
                OR VALID-MSF-CODE                                       
              IF TAB-COMPANY-NO (WS-MSF-SUB) = E-FIOMT102-COMP-NO AND   
                 TAB-CODE-UTIL-TYPE (WS-MSF-SUB) =                      
                                             E-FIOMT102-UTIL-TYPE AND   
                 TAB-MTR-STORAGE-FAC-CD (WS-MSF-SUB) =                  
                                       E-FIOMT102-MOVETO-MSF-CODE AND   
                 TAB-EQUIP-LOC-ID (WS-MSF-SUB) =                        
                                       E-FIOMT102-MOVETO-LOC-CODE       
                 SET VALID-MSF-CODE        TO TRUE                      
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           IF NOT VALID-MSF-CODE                                        
              SET SKIP-RECORD              TO TRUE                      
              MOVE WS-MESG-INVALID-MSF     TO WS-HOLD-ERR-MESG          
              GO TO 1100-EXIT                                           
           END-IF.                                                      
      *                                                                         
      *** Do not Move Meter if Crew ID NOT in location 'C'                      
           IF E-FIOMT102-MOVETO-LOC-CODE NOT = WS-C                     
              IF E-FIOMT102-MOVETO-EMP-ID > SPACES                      
                 SET SKIP-RECORD           TO TRUE                      
                 MOVE WS-MESG-CREW-ID      TO WS-HOLD-ERR-MESG          
                 GO TO 1100-EXIT                                        
              END-IF                                                    
           END-IF.                                                      
                                                                        
      *** Do not Move Meter if Location Code is 'J'                             
P00279*    IF E-FIOMT102-MOVETO-LOC-CODE = WS-AT-CUSTOMER-LOCATION              
P00279*       SET SKIP-RECORD              TO TRUE                              
P00279*       MOVE WS-MESG-CUST-LOC        TO WS-HOLD-ERR-MESG                  
P00279*       GO TO 1100-EXIT                                                   
P00279*    END-IF.                                                              
      *                                                                         
      *** Check the Meter ERT flag                                              
           IF E-FIOMT102-METER-ERT-FLAG NOT EQUAL WS-METER AND          
              E-FIOMT102-METER-ERT-FLAG NOT EQUAL WS-ERT                
              SET SKIP-RECORD              TO TRUE                      
              MOVE WS-MESG-INVALID-FLG     TO WS-HOLD-ERR-MESG          
              GO TO 1100-EXIT                                           
           END-IF.                                                      
      *                                                                         
      *** Don't re-process meter records if already processed                   
           IF E-FIOMT102-METER-ERT-FLAG = WS-METER                      
A2863B        MOVE E-FIOMT102-METER-ERT-NO(1:9) TO WS-METER-NO          
                                                   MV-DEVICE-NO         
              MOVE E-FIOMT102-UTIL-TYPE    TO MV-CODE-UTIL-TYPE         
              MOVE E-FIOMT102-COMP-NO      TO MV-COMPANY-NO             
              MOVE WS-FRMT-TIMESTAMP       TO MV-MOVE-NO                
                                                                        
              PERFORM 7940-CHECK-DUPLICATE-MTR-RECD                     
                 THRU 7940-EXIT                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
A02863           SET IGNORE-RECORD         TO TRUE                      
A2863B           DISPLAY ' IGNORED ' E-FIOMT102-METER-ERT-NO            
                 GO TO 1100-EXIT                                        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
      *** Don't re-process ert records if already processed                     
           IF E-FIOMT102-METER-ERT-FLAG = WS-ERT                        
A2863B        MOVE E-FIOMT102-METER-ERT-NO TO WS-ERT-NO                 
                                              MP-DEVICE-NO              
              MOVE E-FIOMT102-UTIL-TYPE    TO MP-CODE-UTIL-TYPE         
              MOVE E-FIOMT102-COMP-NO      TO MP-COMPANY-NO             
              MOVE WS-FRMT-TIMESTAMP       TO MP-MOVE-NO                
                                                                        
              PERFORM 7960-CHECK-DUPLICATE-ERT-RECD                     
                 THRU 7960-EXIT                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
A02863           SET IGNORE-RECORD         TO TRUE                      
A2863B           DISPLAY ' IGNORED ' E-FIOMT102-METER-ERT-NO            
                 GO TO 1100-EXIT                                        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
      *** Check if meter is still in customer location                          
           MOVE WS-METER-NO             TO MN-METER-NO.                 
           MOVE E-FIOMT102-COMP-NO      TO AT-COMPANY-NO.               
           MOVE E-FIOMT102-UTIL-TYPE    TO MN-CODE-UTIL-TYPE.           
           MOVE SPACES                  TO AT-CODE-ACCT-STAT.           
           MOVE ZEROES                  TO AT-ACCOUNT-NO                
                                           AT-PREMISE-NO                
                                           WS-CPD99-ACCOUNT-NO.         
                                                                        
           IF E-FIOMT102-METER-ERT-FLAG = WS-METER AND                  
              ( E-FIOMT102-MOVETO-LOC-CODE = WS-UNKNOWN OR WS-RETIRED ) 
                                                                        
              PERFORM 7110-OPEN-REMOVED-METER                           
                 THRU 7110-EXIT                                         
                                                                        
              PERFORM 7120-FETCH-REMOVED-METER                          
                 THRU 7120-EXIT                                         
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 1110-CHECK-REMOVED-METER                       
                    THRU 1110-EXIT                                      
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                      OR SKIP-RECORD                                    
              END-IF                                                    
                                                                        
              PERFORM 7130-CLOSE-REMOVED-METER                          
                 THRU 7130-EXIT                                         
           END-IF.                                                      
      *                                                                         
      *** Skip duplicate Meter/ERT validation                                   
           IF E-FIOMT102-METER-ERT-NO  =  WS-PREV-METER-ERT-NO   AND    
              E-FIOMT102-UTIL-TYPE     =  WS-PREV-CODE-UTIL-TYPE AND    
              E-FIOMT102-COMP-NO       =  WS-PREV-COMP-NO               
                                                                        
              IF E-FIOMT102-METER-ERT-FLAG = WS-METER                   
                 IF FAIL-MTR-VALIDATION                                 
                    SET SKIP-RECORD       TO TRUE                       
                    MOVE WS-TEMP-MTR-MESG TO WS-HOLD-ERR-MESG           
                    GO TO 1100-EXIT                                     
                 END-IF                                                 
              ELSE                                                      
                 IF FAIL-ERT-VALIDATION                                 
                    SET SKIP-RECORD        TO TRUE                      
                    MOVE WS-TEMP-ERT-MESG  TO WS-HOLD-ERR-MESG          
                    GO TO 1100-EXIT                                     
                 END-IF                                                 
              END-IF                                                    
                                                                        
           END-IF.                                                      
      *                                                                         
      *** Validate Meter or ERT if no error                                     
           IF E-FIOMT102-METER-ERT-NO NOT = WS-PREV-METER-ERT-NO   OR   
              E-FIOMT102-UTIL-TYPE    NOT = WS-PREV-CODE-UTIL-TYPE OR   
              E-FIOMT102-COMP-NO      NOT = WS-PREV-COMP-NO             
                                                                        
              MOVE E-FIOMT102-METER-ERT-NO TO WS-PREV-METER-ERT-NO      
              MOVE E-FIOMT102-UTIL-TYPE    TO WS-PREV-CODE-UTIL-TYPE    
              MOVE E-FIOMT102-COMP-NO      TO WS-PREV-COMP-NO           
                                                                        
              IF NOT SKIP-RECORD                                        
                 IF E-FIOMT102-METER-ERT-FLAG = WS-METER                
                    PERFORM 1200-VALIDATE-METER                         
                       THRU 1200-EXIT                                   
                 ELSE                                                   
                    PERFORM 1700-VALIDATE-ERT                           
                       THRU 1700-EXIT                                   
                 END-IF                                                 
              END-IF                                                    
                                                                        
           END-IF.                                                      
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1110-CHECK-REMOVED-METER.                                        
      *================================================================*        
      *** If the account is the Current account, Skip the record.               
      *                                                                         
           IF AT-CODE-ACCT-STAT NOT = 'A'                               
              MOVE AT-PREMISE-NO        TO WS-CPD99-PREMISE-NO          
              PERFORM 6990-FETCH-CUR-ACCOUNT                            
                 THRU 6990-EXIT                                         
              IF WS-CPD99-ACCOUNT-NO = AT-ACCOUNT-NO                    
                 SET SKIP-RECORD        TO TRUE                         
                 MOVE WS-MESG-RMVD-METR TO WS-HOLD-ERR-MESG             
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7120-FETCH-REMOVED-METER                             
              THRU 7120-EXIT.                                           
      *                                                                         
       1110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1200-VALIDATE-METER.                                             
      *================================================================*        
      *                                                                         
           MOVE '1200-VALIDATE-METER'      TO WS-ACTIVE-PARAGRAPH.      
      *    DISPLAY WS-ACTIVE-PARAGRAPH.                                         
                                                                        
           MOVE SPACES                     TO WS-MTR-VALIDATION         
                                              WS-TEMP-MTR-MESG.         
                                                                        
           MOVE E-FIOMT102-UTIL-TYPE       TO LX-CODE-UTIL-TYPE         
                                              MP-CODE-UTIL-TYPE         
                                              EQ-CODE-UTIL-TYPE         
                                              MA-CODE-UTIL-TYPE.        
                                                                        
           MOVE E-FIOMT102-COMP-NO         TO LX-COMPANY-NO             
                                              MP-COMPANY-NO             
                                              EQ-COMPANY-NO             
                                              MA-COMPANY-NO.            
                                                                        
           MOVE WS-METER-NO                TO EQ-DEVICE-NO              
                                              MP-METER-NO               
                                              MA-METER-NO.              
                                                                        
           MOVE SPACES                     TO MA-DEVICE-NO.             
      *                                                                         
           PERFORM 7200-GET-METER-DETAILS                               
              THRU 7200-EXIT.                                           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              SET SKIP-RECORD           TO TRUE                         
              MOVE WS-MESG-NO-MTR       TO WS-HOLD-ERR-MESG             
           ELSE                                                         
              IF EQ-CODE-CRNT-LOC = WS-AT-CUSTOMER-LOCATION             
P00279           IF E-FIOMT102-STATUS EQUAL WS-I                        
                    SET SKIP-RECORD     TO TRUE                         
                    MOVE WS-MESG-LOC-J  TO WS-HOLD-ERR-MESG             
P00279           ELSE                                                   
P00279              SET SERV-ORDER-CHECK-REC TO TRUE                    
P00279           END-IF                                                 
              ELSE                                                      
                 IF EQ-CODE-CRNT-LOC = WS-DEVICE-ATTCHD-TO-MTR          
                    SET SKIP-RECORD     TO TRUE                         
                    MOVE WS-MESG-LOC-K  TO WS-HOLD-ERR-MESG             
ACT003           ELSE                                                   
ACT003              IF EQ-CODE-CRNT-LOC = SPACES                        
ACT003                 SET SKIP-RECORD     TO TRUE                      
ACT003                 MOVE WS-MESG-LOC-B  TO WS-HOLD-ERR-MESG          
ACT003              ELSE                                                
ACT003                 IF E-FIOMT102-MOVETO-MSF-CODE = EQ-LOCAL-OFFICE  
ACT003                    AND E-FIOMT102-MOVETO-LOC-CODE =              
ACT003                                                  EQ-CODE-CRNT-LOC
ACT003                    AND E-FIOMT102-MOVETO-EMP-ID =                
ACT003                                              EQ-IN-TRANSIT-EMP-ID
ACT003                    SET IGNORE-RECORD TO TRUE                     
ACT003                 END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
A02863     IF SKIP-RECORD OR IGNORE-RECORD                              
              SET FAIL-MTR-VALIDATION   TO TRUE                         
              MOVE WS-HOLD-ERR-MESG     TO WS-TEMP-MTR-MESG             
              GO TO 1200-EXIT                                           
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-ATT-ERT-TABLE.                                 
           MOVE +1                      TO WS-SUB.                      
           MOVE WS-N                    TO WS-METER-ERT-ATTACHED.       
                                                                        
           PERFORM 7410-OPEN-ATTACHED-ERT                               
              THRU 7410-EXIT.                                           
                                                                        
           PERFORM 7420-FETCH-ATTACHED-ERT                              
              THRU 7420-EXIT.                                           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 1210-LOAD-ERT-ARRAY                               
                 THRU 1210-EXIT                                         
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
           END-IF.                                                      
                                                                        
           PERFORM 7430-CLOSE-ATTACHED-ERT                              
              THRU 7430-EXIT.                                           
                                                                        
           IF SKIP-RECORD                                               
              SET FAIL-MTR-VALIDATION   TO TRUE                         
              MOVE WS-HOLD-ERR-MESG     TO WS-TEMP-MTR-MESG             
           END-IF.                                                      
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1210-LOAD-ERT-ARRAY.                                             
      *================================================================*        
      *                                                                         
           MOVE '1210-LOAD-ERT-ARRAY'   TO WS-ACTIVE-PARAGRAPH.         
      *    DISPLAY WS-ACTIVE-PARAGRAPH.                                         
                                                                        
           MOVE MA-DEVICE-NO            TO LX-DEVICE-NO                 
                                           MP-DEVICE-NO                 
                                           WS-ERT-NO.                   
           PERFORM 7500-GET-ERT-DETAILS                                 
              THRU 7500-EXIT.                                           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF LX-EQUIP-LOC-ID = WS-DEVICE-ATTCHD-TO-MTR              
                                                                        
                 IF WS-NULL-IND-1 < 0                                   
                    MOVE SPACES         TO LX-MTR-STORAGE-FAC-CD        
                 END-IF                                                 
                 IF WS-NULL-IND-2 < 0                                   
                    MOVE SPACES         TO LX-DATE-LAST-MOVE            
                 END-IF                                                 
                 IF WS-NULL-IND-3 < 0                                   
                    MOVE SPACES         TO LX-DATE-LAST-TRAN            
                 END-IF                                                 
                 IF WS-NULL-IND-4 < 0                                   
                    MOVE SPACES         TO LX-EQUIP-ATTACH-DT           
                 END-IF                                                 
                                                                        
                 IF LX-EQUIP-ATTACH-DT <= WS-RECEIVED-MOVE-DATE         
                                                                        
                    MOVE LX-MTR-STORAGE-FAC-CD                          
                                        TO WS-MTR-STORAGE-FAC-CD(WS-SUB)
                    MOVE LX-DATE-LAST-MOVE TO WS-DATE-LAST-MOVE (WS-SUB)
                    MOVE LX-DATE-LAST-TRAN TO WS-DATE-LAST-TRAN (WS-SUB)
                    MOVE LX-IN-TRANSIT-EMP-ID                           
                                        TO WS-IN-TRANSIT-EMP-ID (WS-SUB)
                    MOVE LX-EQUIP-LOC-ID   TO WS-EQUIP-LOC-ID (WS-SUB)  
                    MOVE LX-CODE-ATT-TYPE  TO WS-CODE-ATT-TYPE (WS-SUB) 
                    MOVE LX-DEVICE-NO      TO WS-DEVICE-NO (WS-SUB)     
                    MOVE LX-CODE-UTIL-TYPE TO WS-CODE-UTIL-TYPE (WS-SUB)
                    MOVE LX-COMPANY-NO     TO WS-COMPANY-NO-ERT (WS-SUB)
                    ADD +1                 TO WS-SUB                    
                    SET METER-ERT-ATTACHED TO TRUE                      
                 ELSE                                                   
                    DISPLAY 'LX-EQUIP-ATTACH-DT > WS-RECEIVED-MOVE-DATE'
                            ' ATT ERT NOT MOVED'                        
                 END-IF                                                 
                                                                        
              ELSE                                                      
                 SET SKIP-RECORD        TO TRUE                         
                 MOVE WS-MESG-LOC-ID    TO WS-HOLD-ERR-MESG             
              END-IF                                                    
                                                                        
           ELSE                                                         
              SET SKIP-RECORD           TO TRUE                         
              MOVE WS-MESG-ERT-MISS     TO WS-HOLD-ERR-MESG             
           END-IF.                                                      
                                                                        
           PERFORM 7420-FETCH-ATTACHED-ERT                              
              THRU 7420-EXIT.                                           
      *                                                                         
       1210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1300-PROCESS-MOVE-RECORD.                                        
      *================================================================*        
                                                                        
           MOVE '1300-PROCESS-MOVE-RECORD' TO WS-ACTIVE-PARAGRAPH.      
      *    DISPLAY WS-ACTIVE-PARAGRAPH.                                         
                                                                        
           IF E-FIOMT102-STATUS EQUAL WS-I                              
                                                                        
              IF E-FIOMT102-METER-ERT-NO NOT = WS-I-PREV-METER-ERT-NO   
                                                                        
                 MOVE E-FIOMT102-METER-ERT-NO                           
                                        TO WS-I-PREV-METER-ERT-NO       
                 MOVE SPACES            TO WS-I-RECORD-TS               
                                           WS-I-DECRMT-TS               
                 IF E-FIOMT102-METER-ERT-FLAG = WS-METER                
                    PERFORM 1500-UPDATE-METER-MOVEMENT                  
                       THRU 1500-EXIT                                   
                 ELSE                                                   
                    PERFORM 2000-UPDATE-ERT-MOVEMENT                    
                       THRU 2000-EXIT                                   
                 END-IF                                                 
                                                                        
              ELSE                                                      
                                                                        
                 IF E-FIOMT102-METER-ERT-FLAG = WS-METER                
                    PERFORM 1400-INSERT-METER-MOV-HIST                  
                       THRU 1400-EXIT                                   
                 ELSE                                                   
                    PERFORM 1900-INSERT-ERT-MOV-HIST                    
                       THRU 1900-EXIT                                   
                 END-IF                                                 
                                                                        
              END-IF                                                    
                                                                        
           ELSE                                                         
                                                                        
              IF E-FIOMT102-METER-ERT-FLAG = WS-METER                   
P00279           IF SERV-ORDER-CHECK-REC                                
P00279              PERFORM 1350-CHECK-MOVE-HISTORY                     
P00279                 THRU 1350-EXIT                                   
P00279           ELSE                                                   
                    EVALUATE TRUE                                       
                       WHEN WS-RECEIVED-MOVE-DATE < EQ-DATE-LAST-MOVE   
                          PERFORM 1400-INSERT-METER-MOV-HIST            
                             THRU 1400-EXIT                             
                       WHEN WS-RECEIVED-MOVE-DATE > EQ-DATE-LAST-MOVE   
                          PERFORM 1500-UPDATE-METER-MOVEMENT            
                             THRU 1500-EXIT                             
                       WHEN WS-RECEIVED-MOVE-DATE = EQ-DATE-LAST-MOVE   
                          PERFORM 1600-CHECK-SAME-DAY-MTR-MVMT          
                             THRU 1600-EXIT                             
                    END-EVALUATE                                        
P00279           END-IF                                                 
              ELSE                                                      
                 EVALUATE TRUE                                          
                    WHEN WS-RECEIVED-MOVE-DATE < LX-DATE-LAST-MOVE      
                       PERFORM 1900-INSERT-ERT-MOV-HIST                 
                          THRU 1900-EXIT                                
                    WHEN WS-RECEIVED-MOVE-DATE > LX-DATE-LAST-MOVE      
                       PERFORM 2000-UPDATE-ERT-MOVEMENT                 
                          THRU 2000-EXIT                                
                    WHEN WS-RECEIVED-MOVE-DATE = LX-DATE-LAST-MOVE      
                       PERFORM 2100-CHECK-SAME-DAY-ERT-MVMT             
                          THRU 2100-EXIT                                
                 END-EVALUATE                                           
              END-IF                                                    
                                                                        
           END-IF.                                                      
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00279*================================================================*        
P00279 1350-CHECK-MOVE-HISTORY.                                         
P00279*================================================================*        
P00279                                                                  
P00279     MOVE '1350-CHECK-MOVE-HISTORY ' TO WS-ACTIVE-PARAGRAPH.      
P00279*    DISPLAY WS-ACTIVE-PARAGRAPH.                                         
P00279                                                                  
P00279     MOVE WS-METER-NO                TO MV-DEVICE-NO.             
P00279     MOVE E-FIOMT102-UTIL-TYPE       TO MV-CODE-UTIL-TYPE.        
P00279     MOVE E-FIOMT102-COMP-NO         TO MV-COMPANY-NO.            
P00279     MOVE SPACES                     TO MV-MOVE-NO.               
P00279                                                                  
P00279     PERFORM 7300-GET-METER-LAST-MOVE                             
P00279        THRU 7300-EXIT.                                           
P00279                                                                  
P00279     IF E-FIOMT102-MOVE-TIMESTMP < MV-MOVE-NO                     
P00279                                                                  
P00279        MOVE E-FIOMT102-MOVE-TIMESTMP   TO MV-MOVE-NO             
P00279        MOVE WS-RECEIVED-MOVE-DATE      TO MV-DATE-MOVE           
P00279        MOVE WS-METER                   TO MV-CODE-DEVICE-TYPE    
P00279        MOVE ZERO                       TO MV-LOC-NO              
P00279        MOVE E-FIOMT102-MOVETO-MSF-CODE TO MV-LOCAL-OFFICE        
P00279        MOVE E-FIOMT102-MOVETO-EMP-ID   TO MV-IN-TRANSIT-EMP-ID   
P00279        MOVE E-FIOMT102-MOVETO-LOC-CODE TO MV-CODE-CRNT-LOC       
P0279A        MOVE WS-COMPLETED               TO WS-HOLD-STATUS         
P00279                                                                  
P00279        PERFORM 8100-INSERT-METER-HIST                            
P00279           THRU 8100-EXIT                                         
P00279     ELSE                                                         
P00279        MOVE WS-MESG-LOC-J  TO WS-HOLD-ERR-MESG                   
P0279B                               WS-TEMP-MTR-MESG                   
P00279        MOVE WS-EXCEPTION   TO WS-HOLD-STATUS                     
P0279B        SET FAIL-MTR-VALIDATION TO TRUE                           
P00279     END-IF.                                                      
P00279*                                                                         
P00279 1350-EXIT.                                                       
P00279     EXIT.                                                        
                                                                        
      **** Process Meter records                                                
      *================================================================*        
       1400-INSERT-METER-MOV-HIST.                                      
      *================================================================*        
      ***  Bar coding program when creating a history record will               
      ***  always use file Move date instead of Current Timestamp.              
      *                                                                         
           MOVE '1400-INSERT-METER-MOV-HIST' TO WS-ACTIVE-PARAGRAPH.    
      *    DISPLAY WS-ACTIVE-PARAGRAPH.                                         
                                                                        
           IF E-FIOMT102-STATUS = WS-I                                  
              PERFORM 7920-GET-DEC-TIMESTAMP                            
                 THRU 7920-EXIT                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE WS-I-DECRMT-TS       TO MV-MOVE-NO                
                                              WS-I-RECORD-TS            
              ELSE                                                      
                 SET SKIP-RECORD           TO TRUE                      
                 MOVE WS-EXCEPTION         TO WS-HOLD-STATUS            
                 MOVE WS-MESG-INVALID-TS   TO WS-HOLD-ERR-MESG          
                 GO TO 1400-EXIT                                        
              END-IF                                                    
           ELSE                                                         
              MOVE E-FIOMT102-MOVE-TIMESTMP TO MV-MOVE-NO               
           END-IF.                                                      
                                                                        
           MOVE WS-RECEIVED-MOVE-DATE      TO MV-DATE-MOVE.             
           MOVE WS-METER-NO                TO MV-DEVICE-NO.             
           MOVE WS-METER                   TO MV-CODE-DEVICE-TYPE.      
           MOVE ZERO                       TO MV-LOC-NO.                
           MOVE E-FIOMT102-UTIL-TYPE       TO MV-CODE-UTIL-TYPE.        
           MOVE E-FIOMT102-COMP-NO         TO MV-COMPANY-NO.            
           MOVE E-FIOMT102-MOVETO-MSF-CODE TO MV-LOCAL-OFFICE.          
           MOVE E-FIOMT102-MOVETO-EMP-ID   TO MV-IN-TRANSIT-EMP-ID.     
           MOVE E-FIOMT102-MOVETO-LOC-CODE TO MV-CODE-CRNT-LOC.         
                                                                        
           PERFORM 8100-INSERT-METER-HIST                               
              THRU 8100-EXIT.                                           
                                                                        
           MOVE +1                         TO WS-SUB.                   
           IF METER-ERT-ATTACHED                                        
              PERFORM 1410-CREATE-HIST-FOR-ATTCH-ERT                    
                 THRU 1410-EXIT                                         
                UNTIL WS-SUB >= 5                                       
                   OR WS-DEVICE-NO(WS-SUB) <= SPACES                    
           END-IF.                                                      
                                                                        
           MOVE WS-COMPLETED               TO WS-HOLD-STATUS.           
      *                                                                         
       1400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1410-CREATE-HIST-FOR-ATTCH-ERT.                                  
      *================================================================*        
      *                                                                         
           MOVE '1410-CREATE-HIST-FOR-ATTCH-ERT' TO WS-ACTIVE-PARAGRAPH.
      *    DISPLAY WS-ACTIVE-PARAGRAPH.                                         
                                                                        
           IF E-FIOMT102-STATUS = WS-I                                  
              MOVE WS-I-DECRMT-TS           TO MP-MOVE-NO               
           ELSE                                                         
              MOVE E-FIOMT102-MOVE-TIMESTMP TO MP-MOVE-NO               
           END-IF.                                                      
                                                                        
           MOVE WS-RECEIVED-MOVE-DATE      TO MP-DATE-MOVE.             
           MOVE E-FIOMT102-MOVETO-MSF-CODE TO MP-MTR-STORAGE-FAC-CD.    
           MOVE E-FIOMT102-MOVETO-EMP-ID   TO MP-IN-TRANSIT-EMP-ID.     
           MOVE WS-METER-NO                TO MP-METER-NO.              
           MOVE WS-DEVICE-NO(WS-SUB)       TO MP-DEVICE-NO.             
           MOVE WS-CODE-ATT-TYPE(WS-SUB)   TO MP-CODE-ATT-TYPE.         
           MOVE WS-CODE-UTIL-TYPE(WS-SUB)  TO MP-CODE-UTIL-TYPE.        
           MOVE WS-COMPANY-NO-ERT(WS-SUB)  TO MP-COMPANY-NO.            
           MOVE WS-EQUIP-LOC-ID(WS-SUB)    TO MP-EQUIP-LOC-ID.          
                                                                        
           PERFORM 8300-INSERT-ERT-HIST                                 
              THRU 8300-EXIT.                                           
                                                                        
           ADD +1                          TO WS-SUB.                   
      *                                                                         
       1410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1500-UPDATE-METER-MOVEMENT.                                      
      *================================================================*        
      *** During Update,History will have the Date Last Move from Equip         
      *** and the timestamp from bar coding file.                               
      *                                                                         
           MOVE '1500-UPDATE-METER-MOVEMENT' TO WS-ACTIVE-PARAGRAPH.    
      *    DISPLAY WS-ACTIVE-PARAGRAPH.                                         
                                                                        
           IF E-FIOMT102-STATUS = WS-I                                  
              PERFORM 7900-GET-CURRENT-DATE-TS                          
                 THRU 7900-EXIT                                         
              IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL            
                 SET SKIP-RECORD           TO TRUE                      
                 MOVE WS-EXCEPTION         TO WS-HOLD-STATUS            
                 MOVE WS-MESG-INVALID-TS   TO WS-HOLD-ERR-MESG          
                 GO TO 1500-EXIT                                        
              END-IF                                                    
              MOVE WS-CURRENT-DATE         TO MV-DATE-MOVE              
                                              EQ-DATE-LAST-MOVE         
                                              EQ-DATE-LAST-TRAN         
              MOVE WS-CURRENT-TIMESTMP     TO MV-MOVE-NO                
                                               WS-I-RECORD-TS           
           ELSE                                                         
              MOVE EQ-DATE-LAST-MOVE       TO MV-DATE-MOVE              
              MOVE WS-RECEIVED-MOVE-DATE   TO EQ-DATE-LAST-MOVE         
                                              EQ-DATE-LAST-TRAN         
              MOVE E-FIOMT102-MOVE-TIMESTMP TO MV-MOVE-NO               
           END-IF.                                                      
                                                                        
           MOVE EQ-CODE-UTIL-TYPE          TO MV-CODE-UTIL-TYPE.        
           MOVE EQ-DEVICE-NO               TO MV-DEVICE-NO.             
           MOVE EQ-EQUIP-TYPE-CD           TO MV-CODE-DEVICE-TYPE.      
           MOVE EQ-COMPANY-NO              TO MV-COMPANY-NO.            
           MOVE EQ-LOCAL-OFFICE            TO MV-LOCAL-OFFICE.          
           MOVE EQ-CRNT-LOC-NO             TO MV-LOC-NO.                
           MOVE EQ-CODE-CRNT-LOC           TO MV-CODE-CRNT-LOC.         
           MOVE EQ-IN-TRANSIT-EMP-ID       TO MV-IN-TRANSIT-EMP-ID.     
                                                                        
           PERFORM 8100-INSERT-METER-HIST                               
              THRU 8100-EXIT.                                           
                                                                        
           MOVE E-FIOMT102-MOVETO-MSF-CODE  TO EQ-LOCAL-OFFICE.         
           MOVE E-FIOMT102-MOVETO-LOC-CODE  TO EQ-CODE-CRNT-LOC.        
           MOVE E-FIOMT102-MOVETO-EMP-ID    TO EQ-IN-TRANSIT-EMP-ID.    
                                                                        
           PERFORM 8200-UPDATE-METER                                    
              THRU 8200-EXIT.                                           
                                                                        
           MOVE +1                         TO WS-SUB.                   
           IF METER-ERT-ATTACHED                                        
              PERFORM 1510-CREATE-MVMT-FOR-ATTCH-ERT                    
                 THRU 1510-EXIT                                         
                UNTIL WS-SUB >= 5                                       
                   OR WS-DEVICE-NO(WS-SUB) <= SPACES                    
           END-IF.                                                      
                                                                        
           MOVE WS-COMPLETED               TO WS-HOLD-STATUS.           
      *                                                                         
       1500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1510-CREATE-MVMT-FOR-ATTCH-ERT.                                  
      *================================================================*        
      *                                                                         
           MOVE '1510-CREATE-MVMT-FOR-ATTCH-ERT' TO WS-ACTIVE-PARAGRAPH.
      *    DISPLAY WS-ACTIVE-PARAGRAPH.                                         
                                                                        
           IF E-FIOMT102-STATUS = WS-I                                  
              MOVE WS-CURRENT-DATE         TO MP-DATE-MOVE              
                                              LX-DATE-LAST-MOVE         
                                              LX-DATE-LAST-TRAN         
              MOVE WS-CURRENT-TIMESTMP     TO MP-MOVE-NO                
           ELSE                                                         
              MOVE E-FIOMT102-MOVE-TIMESTMP TO MP-MOVE-NO               
              MOVE WS-RECEIVED-MOVE-DATE    TO LX-DATE-LAST-MOVE        
                                               LX-DATE-LAST-TRAN        
                                                                        
              IF WS-DATE-LAST-MOVE (WS-SUB) > SPACES                    
                 MOVE WS-DATE-LAST-MOVE (WS-SUB) TO MP-DATE-MOVE        
              ELSE                                                      
                 IF WS-DATE-LAST-TRAN (WS-SUB) > SPACES                 
                    MOVE WS-DATE-LAST-TRAN (WS-SUB) TO MP-DATE-MOVE     
                 ELSE                                                   
                    MOVE WS-RECEIVED-MOVE-DATE   TO MP-DATE-MOVE        
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE EQ-DEVICE-NO               TO MP-METER-NO.              
           MOVE WS-CODE-UTIL-TYPE(WS-SUB)  TO MP-CODE-UTIL-TYPE.        
           MOVE WS-COMPANY-NO-ERT(WS-SUB)  TO MP-COMPANY-NO.            
           MOVE WS-IN-TRANSIT-EMP-ID(WS-SUB)  TO MP-IN-TRANSIT-EMP-ID.  
           MOVE WS-MTR-STORAGE-FAC-CD(WS-SUB) TO MP-MTR-STORAGE-FAC-CD. 
           MOVE WS-CODE-ATT-TYPE(WS-SUB)   TO MP-CODE-ATT-TYPE          
                                              LX-CODE-ATT-TYPE.         
           MOVE WS-DEVICE-NO(WS-SUB)       TO MP-DEVICE-NO              
                                              LX-DEVICE-NO.             
           MOVE WS-EQUIP-LOC-ID (WS-SUB)   TO MP-EQUIP-LOC-ID           
                                              LX-EQUIP-LOC-ID.          
           PERFORM 8300-INSERT-ERT-HIST                                 
              THRU 8300-EXIT.                                           
                                                                        
      **** Don't change the location of ERT, if attached to Meter               
           MOVE E-FIOMT102-MOVETO-MSF-CODE TO LX-MTR-STORAGE-FAC-CD.    
           MOVE E-FIOMT102-MOVETO-EMP-ID   TO LX-IN-TRANSIT-EMP-ID.     
                                                                        
           PERFORM 8400-UPDATE-ERT                                      
              THRU 8400-EXIT.                                           
                                                                        
           ADD +1                          TO WS-SUB.                   
      *                                                                         
       1510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1600-CHECK-SAME-DAY-MTR-MVMT.                                    
      *================================================================*        
      *** Move date is the same                                                 
      *** 1. Timestamp on barcoding is earlier than last movement hist          
      ***    record. So insert bar coding record into Movement history.         
      *** 2. Timestamp on barcoding is later   than last movement hist          
      ***    record. So update equiment and insert movement history.            
      *** 3. No history. Check the MSF code and location. If different          
      ***    assume barcoding is more current.                                  
      *                                                                         
           MOVE '1600-CHECK-SAME-DAY-MTR-MVMT  ' TO WS-ACTIVE-PARAGRAPH.
      *    DISPLAY WS-ACTIVE-PARAGRAPH.                                         
                                                                        
           MOVE WS-METER-NO                TO MV-DEVICE-NO.             
           MOVE WS-RECEIVED-MOVE-DATE      TO MV-DATE-MOVE.             
           MOVE E-FIOMT102-UTIL-TYPE       TO MV-CODE-UTIL-TYPE.        
           MOVE E-FIOMT102-COMP-NO         TO MV-COMPANY-NO.            
           MOVE SPACES                     TO MV-MOVE-NO.               
                                                                        
           PERFORM 7300-GET-METER-LAST-MOVE                             
              THRU 7300-EXIT.                                           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF E-FIOMT102-MOVE-TIMESTMP < MV-MOVE-NO                  
                 PERFORM 1400-INSERT-METER-MOV-HIST                     
                    THRU 1400-EXIT                                      
              ELSE                                                      
                 PERFORM 1500-UPDATE-METER-MOVEMENT                     
                    THRU 1500-EXIT                                      
              END-IF                                                    
           ELSE                                                         
              IF E-FIOMT102-MOVETO-MSF-CODE NOT = EQ-LOCAL-OFFICE AND   
                 E-FIOMT102-MOVETO-LOC-CODE NOT = EQ-CODE-CRNT-LOC      
                 PERFORM 1500-UPDATE-METER-MOVEMENT                     
                    THRU 1500-EXIT                                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-COMPLETED               TO WS-HOLD-STATUS.           
      *                                                                         
       1600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1700-VALIDATE-ERT.                                               
      *================================================================*        
      *                                                                         
           MOVE '1700-VALIDATE-ERT             ' TO WS-ACTIVE-PARAGRAPH.
      *    DISPLAY WS-ACTIVE-PARAGRAPH.                                         
                                                                        
           MOVE SPACES                     TO WS-ERT-VALIDATION         
                                              WS-TEMP-ERT-MESG.         
                                                                        
           MOVE SPACES                     TO MA-METER-NO.              
           MOVE WS-N                       TO WS-METER-ERT-ATTACHED.    
           MOVE E-FIOMT102-COMP-NO         TO LX-COMPANY-NO             
                                              MA-COMPANY-NO             
                                              EQ-COMPANY-NO.            
           MOVE E-FIOMT102-UTIL-TYPE       TO LX-CODE-UTIL-TYPE         
                                              MA-CODE-UTIL-TYPE         
                                              EQ-CODE-UTIL-TYPE.        
           MOVE WS-ERT-NO                  TO LX-DEVICE-NO              
                                              MA-DEVICE-NO.             
           PERFORM 7500-GET-ERT-DETAILS                                 
              THRU 7500-EXIT.                                           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              SET SKIP-RECORD              TO TRUE                      
              MOVE WS-MESG-NO-ERT          TO WS-HOLD-ERR-MESG          
           ELSE                                                         
              IF WS-NULL-IND-1 < 0                                      
                 MOVE SPACES               TO LX-MTR-STORAGE-FAC-CD     
              END-IF                                                    
              IF WS-NULL-IND-2 < 0                                      
                 MOVE SPACES               TO LX-DATE-LAST-MOVE         
              END-IF                                                    
              IF WS-NULL-IND-3 < 0                                      
                 MOVE SPACES               TO LX-DATE-LAST-TRAN         
              END-IF                                                    
              IF WS-NULL-IND-4 < 0                                      
                 MOVE SPACES               TO LX-EQUIP-ATTACH-DT        
              END-IF                                                    
                                                                        
              IF LX-EQUIP-LOC-ID = WS-AT-CUSTOMER-LOCATION              
                 SET SKIP-RECORD           TO TRUE                      
                 SET FAIL-ERT-VALIDATION   TO TRUE                      
                 MOVE WS-MESG-LOC-J        TO WS-HOLD-ERR-MESG          
                                              WS-TEMP-ERT-MESG          
                 GO TO 1700-EXIT                                        
              END-IF                                                    
                                                                        
              IF E-FIOMT102-MOVETO-MSF-CODE = LX-MTR-STORAGE-FAC-CD AND 
                 E-FIOMT102-MOVETO-LOC-CODE = LX-EQUIP-LOC-ID       AND 
                 E-FIOMT102-MOVETO-EMP-ID   = LX-IN-TRANSIT-EMP-ID      
                 SET FAIL-ERT-VALIDATION   TO TRUE                      
A02863           SET IGNORE-RECORD         TO TRUE                      
                 GO TO 1700-EXIT                                        
              END-IF                                                    
                                                                        
              IF LX-EQUIP-ATTACH-DT <= WS-RECEIVED-MOVE-DATE            
                                                                        
                 IF LX-EQUIP-LOC-ID = WS-DEVICE-ATTCHD-TO-MTR           
                    PERFORM 7440-GET-ATTACHED-MTR                       
                       THRU 7440-EXIT                                   
                                                                        
                    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
                       MOVE MA-METER-NO       TO EQ-DEVICE-NO           
                                                 WS-METER-NO            
                       PERFORM 7200-GET-METER-DETAILS                   
                          THRU 7200-EXIT                                
                                                                        
                       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL       
                          IF EQ-CODE-CRNT-LOC = WS-AT-CUSTOMER-LOCATION 
                             SET SKIP-RECORD   TO TRUE                  
                             MOVE WS-MESG-MTR2 TO WS-HOLD-ERR-MESG      
                          ELSE                                          
                             SET METER-ERT-ATTACHED TO TRUE             
                          END-IF                                        
                       ELSE                                             
                          SET SKIP-RECORD      TO TRUE                  
                          MOVE WS-MESG-MTR1    TO WS-HOLD-ERR-MESG      
                       END-IF                                           
                                                                        
                    ELSE                                                
                       SET SKIP-RECORD         TO TRUE                  
ACT125                 MOVE "ERT not attached to any Meter"             
ACT125                                         TO WS-HOLD-ERR-MESG      
                    END-IF                                              
                                                                        
                 END-IF                                                 
                                                                        
              ELSE                                                      
                 DISPLAY 'LX-EQUIP-ATTACH-DT > RECEIVED-MOVE-DATE '     
                         'ATT MTR NOT MOVED'                            
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF SKIP-RECORD                                               
              SET FAIL-ERT-VALIDATION   TO TRUE                         
              MOVE WS-HOLD-ERR-MESG     TO WS-TEMP-ERT-MESG             
           END-IF.                                                      
      *                                                                         
       1700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **** Process ERT records                                                  
      *================================================================*        
       1900-INSERT-ERT-MOV-HIST.                                        
      *================================================================*        
      *                                                                         
           MOVE '1900-INSERT-ERT-MOV-HIST      ' TO WS-ACTIVE-PARAGRAPH.
      *    DISPLAY WS-ACTIVE-PARAGRAPH.                                         
                                                                        
           IF E-FIOMT102-STATUS = WS-I                                  
              PERFORM 7920-GET-DEC-TIMESTAMP                            
                 THRU 7920-EXIT                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE WS-I-DECRMT-TS        TO MP-MOVE-NO               
                                               MV-MOVE-NO               
                                               WS-I-RECORD-TS           
              ELSE                                                      
                 SET SKIP-RECORD            TO TRUE                     
                 MOVE WS-EXCEPTION          TO WS-HOLD-STATUS           
                 MOVE WS-MESG-INVALID-TS    TO WS-HOLD-ERR-MESG         
                 GO TO 1900-EXIT                                        
              END-IF                                                    
           ELSE                                                         
              MOVE E-FIOMT102-MOVE-TIMESTMP TO MP-MOVE-NO               
                                               MV-MOVE-NO               
           END-IF.                                                      
                                                                        
           MOVE WS-RECEIVED-MOVE-DATE       TO MP-DATE-MOVE.            
                                                                        
           IF METER-ERT-ATTACHED                                        
              MOVE MA-METER-NO              TO MP-METER-NO              
              MOVE WS-DEVICE-ATTCHD-TO-MTR  TO MP-EQUIP-LOC-ID          
              DISPLAY ' LX-EQUIP-LOC-ID : ' LX-EQUIP-LOC-ID             
           ELSE                                                         
              MOVE SPACES                   TO MP-METER-NO              
              MOVE E-FIOMT102-MOVETO-LOC-CODE TO MP-EQUIP-LOC-ID        
           END-IF.                                                      
                                                                        
           MOVE WS-ERT-NO                   TO MP-DEVICE-NO.            
           MOVE WS-INTEGRATED               TO MP-CODE-ATT-TYPE.        
           MOVE E-FIOMT102-UTIL-TYPE        TO MP-CODE-UTIL-TYPE.       
           MOVE E-FIOMT102-COMP-NO          TO MP-COMPANY-NO.           
           MOVE E-FIOMT102-MOVETO-MSF-CODE  TO MP-MTR-STORAGE-FAC-CD.   
           MOVE E-FIOMT102-MOVETO-EMP-ID    TO MP-IN-TRANSIT-EMP-ID.    
                                                                        
           PERFORM 8300-INSERT-ERT-HIST                                 
              THRU 8300-EXIT.                                           
                                                                        
           IF METER-ERT-ATTACHED                                        
              MOVE WS-RECEIVED-MOVE-DATE    TO MV-DATE-MOVE             
              MOVE E-FIOMT102-UTIL-TYPE     TO MV-CODE-UTIL-TYPE        
              MOVE MA-METER-NO              TO MV-DEVICE-NO             
              MOVE WS-METER                 TO MV-CODE-DEVICE-TYPE      
              MOVE E-FIOMT102-COMP-NO       TO MV-COMPANY-NO            
              MOVE ZEROES                   TO MV-LOC-NO                
              MOVE E-FIOMT102-MOVETO-MSF-CODE TO MV-LOCAL-OFFICE        
              MOVE E-FIOMT102-MOVETO-LOC-CODE TO MV-CODE-CRNT-LOC       
              MOVE E-FIOMT102-MOVETO-EMP-ID TO MV-IN-TRANSIT-EMP-ID     
                                                                        
              PERFORM 8100-INSERT-METER-HIST                            
                 THRU 8100-EXIT                                         
           END-IF.                                                      
                                                                        
           MOVE WS-COMPLETED            TO WS-HOLD-STATUS.              
      *                                                                         
       1900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       2000-UPDATE-ERT-MOVEMENT.                                        
      *================================================================*        
      *                                                                         
           MOVE '2000-UPDATE-ERT-MOVEMENT      ' TO WS-ACTIVE-PARAGRAPH.
      *    DISPLAY WS-ACTIVE-PARAGRAPH.                                         
                                                                        
           IF E-FIOMT102-STATUS = WS-I                                  
              PERFORM 7900-GET-CURRENT-DATE-TS                          
                 THRU 7900-EXIT                                         
              IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL            
                 SET SKIP-RECORD            TO TRUE                     
                 MOVE WS-EXCEPTION          TO WS-HOLD-STATUS           
                 MOVE WS-MESG-INVALID-TS    TO WS-HOLD-ERR-MESG         
                 GO TO 2000-EXIT                                        
              END-IF                                                    
              MOVE WS-CURRENT-DATE          TO MP-DATE-MOVE             
                                               MV-DATE-MOVE             
                                               LX-DATE-LAST-MOVE        
                                               LX-DATE-LAST-TRAN        
                                               EQ-DATE-LAST-MOVE        
                                               EQ-DATE-LAST-TRAN        
              MOVE WS-CURRENT-TIMESTMP      TO MP-MOVE-NO               
                                               MV-MOVE-NO               
                                               WS-I-RECORD-TS           
           ELSE                                                         
              MOVE EQ-DATE-LAST-MOVE        TO MV-DATE-MOVE             
              MOVE E-FIOMT102-MOVE-TIMESTMP TO MP-MOVE-NO               
                                               MV-MOVE-NO               
              IF LX-DATE-LAST-MOVE > SPACES                             
                 MOVE LX-DATE-LAST-MOVE     TO MP-DATE-MOVE             
              ELSE                                                      
                 IF LX-DATE-LAST-TRAN > SPACES                          
                    MOVE LX-DATE-LAST-TRAN  TO MP-DATE-MOVE             
                 ELSE                                                   
                    MOVE WS-RECEIVED-MOVE-DATE TO MP-DATE-MOVE          
                 END-IF                                                 
              END-IF                                                    
                                                                        
              MOVE WS-RECEIVED-MOVE-DATE    TO LX-DATE-LAST-MOVE        
                                               LX-DATE-LAST-TRAN        
                                               EQ-DATE-LAST-MOVE        
                                               EQ-DATE-LAST-TRAN        
           END-IF.                                                      
                                                                        
           MOVE LX-CODE-ATT-TYPE            TO MP-CODE-ATT-TYPE.        
           MOVE LX-COMPANY-NO               TO MP-COMPANY-NO.           
           MOVE LX-CODE-UTIL-TYPE           TO MP-CODE-UTIL-TYPE.       
           MOVE LX-MTR-STORAGE-FAC-CD       TO MP-MTR-STORAGE-FAC-CD.   
           MOVE LX-IN-TRANSIT-EMP-ID        TO MP-IN-TRANSIT-EMP-ID.    
           MOVE LX-EQUIP-LOC-ID             TO MP-EQUIP-LOC-ID.         
           MOVE WS-ERT-NO                   TO MP-DEVICE-NO.            
           MOVE SPACES                      TO MP-METER-NO.             
                                                                        
           IF METER-ERT-ATTACHED                                        
              MOVE MA-METER-NO              TO MP-METER-NO              
           END-IF.                                                      
                                                                        
           PERFORM 8300-INSERT-ERT-HIST                                 
              THRU 8300-EXIT.                                           
                                                                        
           IF NOT METER-ERT-ATTACHED                                    
              MOVE E-FIOMT102-MOVETO-LOC-CODE                           
                                            TO LX-EQUIP-LOC-ID          
           END-IF.                                                      
                                                                        
           MOVE E-FIOMT102-MOVETO-MSF-CODE  TO LX-MTR-STORAGE-FAC-CD.   
           MOVE E-FIOMT102-MOVETO-EMP-ID    TO LX-IN-TRANSIT-EMP-ID.    
                                                                        
           PERFORM 8400-UPDATE-ERT                                      
              THRU 8400-EXIT.                                           
                                                                        
           IF METER-ERT-ATTACHED                                        
              MOVE EQ-CODE-UTIL-TYPE        TO MV-CODE-UTIL-TYPE        
              MOVE EQ-DEVICE-NO             TO MV-DEVICE-NO             
              MOVE EQ-EQUIP-TYPE-CD         TO MV-CODE-DEVICE-TYPE      
              MOVE EQ-COMPANY-NO            TO MV-COMPANY-NO            
              MOVE EQ-LOCAL-OFFICE          TO MV-LOCAL-OFFICE          
              MOVE EQ-CRNT-LOC-NO           TO MV-LOC-NO                
              MOVE EQ-CODE-CRNT-LOC         TO MV-CODE-CRNT-LOC         
              MOVE EQ-IN-TRANSIT-EMP-ID     TO MV-IN-TRANSIT-EMP-ID     
                                                                        
              PERFORM 8100-INSERT-METER-HIST                            
                 THRU 8100-EXIT                                         
                                                                        
              MOVE E-FIOMT102-MOVETO-MSF-CODE TO EQ-LOCAL-OFFICE        
              MOVE E-FIOMT102-MOVETO-LOC-CODE TO EQ-CODE-CRNT-LOC       
              MOVE E-FIOMT102-MOVETO-EMP-ID   TO EQ-IN-TRANSIT-EMP-ID   
                                                                        
              PERFORM 8200-UPDATE-METER                                 
                 THRU 8200-EXIT                                         
                                                                        
           END-IF.                                                      
                                                                        
           MOVE WS-COMPLETED               TO WS-HOLD-STATUS.           
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       2100-CHECK-SAME-DAY-ERT-MVMT.                                    
      *================================================================*        
      *                                                                         
           MOVE '2100-CHECK-SAME-DAY-ERT-MVMT  ' TO WS-ACTIVE-PARAGRAPH.
      *    DISPLAY WS-ACTIVE-PARAGRAPH.                                         
                                                                        
           MOVE WS-ERT-NO                  TO MP-DEVICE-NO.             
           MOVE WS-RECEIVED-MOVE-DATE      TO MP-DATE-MOVE.             
           MOVE WS-INTEGRATED              TO MP-CODE-ATT-TYPE.         
           MOVE E-FIOMT102-COMP-NO         TO MP-COMPANY-NO.            
           MOVE E-FIOMT102-UTIL-TYPE       TO MP-CODE-UTIL-TYPE.        
                                                                        
           PERFORM 7700-GET-ERT-LAST-MOVE                               
              THRU 7700-EXIT.                                           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF E-FIOMT102-MOVE-TIMESTMP < MP-MOVE-NO                  
                 PERFORM 1900-INSERT-ERT-MOV-HIST                       
                    THRU 1900-EXIT                                      
              ELSE                                                      
                 PERFORM 2000-UPDATE-ERT-MOVEMENT                       
                    THRU 2000-EXIT                                      
              END-IF                                                    
           ELSE                                                         
              IF E-FIOMT102-MOVETO-MSF-CODE NOT = LX-MTR-STORAGE-FAC-CD 
                 AND E-FIOMT102-MOVETO-LOC-CODE NOT = LX-EQUIP-LOC-ID   
                 PERFORM 2000-UPDATE-ERT-MOVEMENT                       
                    THRU 2000-EXIT                                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-COMPLETED               TO WS-HOLD-STATUS.           
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       2900-PREPARE-FCSM102B.                                           
      *================================================================*        
      *                                                                         
           MOVE SPACES                     TO FIOM102B-REC.             
           MOVE WS-HOLD-STATUS             TO E-FIOMT102-STATUS.        
           MOVE WS-HOLD-ERR-MESG           TO E-FIOMT102-ERROR-MESSAGE. 
                                                                        
           MOVE FIOMT102                   TO FIOM102B-REC.             
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3000-WRITE-CNTRL-REC.                                            
      *================================================================*        
      * The following statements upgrade the job-complete field to              
      * indicate a successful completion:                                       
      *                                                                         
           MOVE SPACES                     TO WS-RESTART-JOB-COMPLETE.  
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              SET WS-RERUN-COMPLETED       TO TRUE                      
           ELSE                                                         
              SET WS-RUN-COMPLETED-NO-PROBLEMS                          
                                           TO TRUE                      
           END-IF.                                                      
                                                                        
           IF COMMITS-REQUIRE                                           
              PERFORM 8899-WRITE-RSDDR                                  
                 THRU 8899-EXIT                                         
           END-IF.                                                      
                                                                        
           IF WS-RESTART-REQ = WS-Y                                     
              PERFORM 8893-RESET-RESTART-REQ-PARM                       
                 THRU 8893-EXIT                                         
           END-IF.                                                      
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
      *6253-GET-FJC01-CHKP-LIMIT.                                               
      *================================================================*        
      *** Check job parm table for commits                                      
       COPY CPD00034.                                                           
                                                                        
      *================================================================*        
      *6235-GET-FJC01-RESTART-REQ.                                              
      *================================================================*        
      *** Check job parm table to get ws-restart-req flag                       
       COPY CPD00035.                                                           
                                                                        
      *================================================================*        
      *6240-GET-FCA00-COMMON-DATE.                                              
      *================================================================*        
      *** Copybook to get the common date record                                
       COPY CPD00040.                                                           
                                                                        
      *================================================================*        
      *6251-GET-FJC01-DATE.                                                     
      *================================================================*        
      *** Copybook to read parm file for override date                          
       COPY CPD00037.                                                           
                                                                        
      *****************************************************************         
      * COPYBOOK TO GET THE MOST CURRENT ACCOUNT AT A PREMISE         *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPDCA099                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * ERROR ROUTINE TO HANDLE ERRORS FROM CPD00099                   *        
      ******************************************************************        
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = WS-811                           
               MOVE AT-ACCOUNT-NO          TO WS-CPD99-ACCOUNT-NO       
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSBW182 PROCESSING ERROR      **'       
               DISPLAY '**  ERROR IN PARA ', ACTIVE-PARAGRAPH           
               DISPLAY '**  PREMISE-NO = ', WS-CPD99-PREMISE-NO         
               DISPLAY '**  SQL CODE IS ', WS-CPD99-RETURN-CODE         
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      *===============================================================*         
       7000-READ-FCSMT102.                                              
      *===============================================================*         
      *                                                                         
           READ FCSMT102-FILE                                           
                 AT END MOVE 'Y'           TO WS-FCSMT102-EOF.          
                                                                        
           EVALUATE TRUE                                                
                                                                        
              WHEN FCSMT102-SUCCESSFUL                                  
                 ADD +1                    TO WS-FCSMT102-REC-CNTR      
                 DISPLAY  'PROCESSING ' E-FIOMT102-METER-ERT-FLAG ' '   
                                        E-FIOMT102-METER-ERT-NO         
              WHEN FCSMT102-READ-EOF                                    
                 CONTINUE                                               
                                                                        
              WHEN OTHER                                                
                 DISPLAY '************ PCSMT102 ERROR ***************'  
                 DISPLAY '**         7000-READ-FCSMT102            **'  
                 DISPLAY '** COMP NO        : ' E-FIOMT102-COMP-NO      
                 DISPLAY '** CODE UTIL TYPE : ' E-FIOMT102-UTIL-TYPE    
                 DISPLAY '** MTR/ERT NO     : ' E-FIOMT102-METER-ERT-NO 
                 DISPLAY '** MOVE TS        : ' E-FIOMT102-MOVE-TIMESTMP
                 DISPLAY '** STATUS IS      : ' WS-FCSMT102-STATUS      
                 DISPLAY '** PROCESSING TERMINATED.......          **'  
                 PERFORM 9900-ABEND                                     
                    THRU 9900-EXIT                                      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7110-OPEN-REMOVED-METER.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                OPEN CHECK_REMOVED_MTR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSMT102 ERROR ******************' 
               DISPLAY '**      7110-OPEN-REMOVED-METER             **' 
               DISPLAY '** CODE-UTIL-TYPE = ' MN-CODE-UTIL-TYPE         
               DISPLAY '** COMPANY_NO     = ' AT-COMPANY-NO             
               DISPLAY '** METER_NO       = ' MN-METER-NO               
               DISPLAY '** SQLCODE        = ' WS-DISPLAY-SQLCODE        
               DISPLAY '** PROCESSING TERMINATED.......             **' 
               PERFORM 9900-ABEND                                       
                  THRU 9900-EXIT                                        
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7120-FETCH-REMOVED-METER.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                FETCH CHECK_REMOVED_MTR                                 
                 INTO :AT-ACCOUNT-NO                                    
                     ,:AT-PREMISE-NO                                    
                     ,:AT-CODE-ACCT-STAT                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSMT102 ERROR ******************' 
               DISPLAY '**      7120-FETCH-REMOVED-METER            **' 
               DISPLAY '** CODE-UTIL-TYPE = ' MN-CODE-UTIL-TYPE         
               DISPLAY '** COMPANY_NO     = ' AT-COMPANY-NO             
               DISPLAY '** METER_NO       = ' MN-METER-NO               
               DISPLAY '** SQLCODE        = ' WS-DISPLAY-SQLCODE        
               DISPLAY '** PROCESSING TERMINATED.......             **' 
               PERFORM 9900-ABEND                                       
                  THRU 9900-EXIT                                        
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7130-CLOSE-REMOVED-METER.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                CLOSE CHECK_REMOVED_MTR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSMT102 ERROR ******************' 
               DISPLAY '**      7130-CLOSE-REMOVED-METER            **' 
               DISPLAY '** CODE-UTIL-TYPE = ' MN-CODE-UTIL-TYPE         
               DISPLAY '** COMPANY_NO     = ' AT-COMPANY-NO             
               DISPLAY '** METER_NO       = ' MN-METER-NO               
               DISPLAY '** SQLCODE        = ' WS-DISPLAY-SQLCODE        
               DISPLAY '** PROCESSING TERMINATED.......             **' 
               PERFORM 9900-ABEND                                       
                  THRU 9900-EXIT                                        
           END-IF.                                                      
      *                                                                         
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7200-GET-METER-DETAILS.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                SELECT EQ.DATE_LAST_MOVE                                
                      ,EQ.EQUIP_TYPE_CD                                 
                      ,EQ.LOCAL_OFFICE                                  
                      ,EQ.CRNT_LOC_NO                                   
                      ,EQ.CODE_CRNT_LOC                                 
                      ,EQ.IN_TRANSIT_EMP_ID                             
                INTO  :EQ-DATE-LAST-MOVE                                
                     ,:EQ-EQUIP-TYPE-CD                                 
                     ,:EQ-LOCAL-OFFICE                                  
                     ,:EQ-CRNT-LOC-NO                                   
                     ,:EQ-CODE-CRNT-LOC                                 
                     ,:EQ-IN-TRANSIT-EMP-ID                             
                FROM  CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                    
                WHERE EQ.COMPANY_NO     = :EQ-COMPANY-NO                
                AND   EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE            
                AND   EQ.DEVICE_NO      = :EQ-DEVICE-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT EQ.DATE_LAST_MOVE                                        
MFA-TR*               ,EQ.EQUIP_TYPE_CD                                         
MFA-TR*               ,EQ.LOCAL_OFFICE                                          
MFA-TR*               ,EQ.CRNT_LOC_NO                                           
MFA-TR*               ,EQ.CODE_CRNT_LOC                                         
MFA-TR*               ,EQ.IN_TRANSIT_EMP_ID                                     
MFA-TR*         INTO  :EQ-DATE-LAST-MOVE                                        
MFA-TR*              ,:EQ-EQUIP-TYPE-CD                                         
MFA-TR*              ,:EQ-LOCAL-OFFICE                                          
MFA-TR*              ,:EQ-CRNT-LOC-NO                                           
MFA-TR*              ,:EQ-CODE-CRNT-LOC                                         
MFA-TR*              ,:EQ-IN-TRANSIT-EMP-ID                                     
MFA-TR*         FROM  CSS_EQUIPMENT EQ                                          
MFA-TR*         WHERE EQ.COMPANY_NO     = :EQ-COMPANY-NO                        
MFA-TR*         AND   EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                    
MFA-TR*         AND   EQ.DEVICE_NO      = :EQ-DEVICE-NO                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSMT102 ERROR ******************' 
               DISPLAY '**       7200-GET-METER-DETAILS             **' 
               DISPLAY '** COMPANY_NO     = ' EQ-COMPANY-NO             
               DISPLAY '** CODE_UTIL_TYPE = ' EQ-CODE-UTIL-TYPE         
               DISPLAY '** METER_NO       = ' EQ-DEVICE-NO              
               DISPLAY '** SQLCODE        = ' WS-DISPLAY-SQLCODE        
               DISPLAY '** PROCESSING TERMINATED.......             **' 
               PERFORM 9900-ABEND                                       
                  THRU 9900-EXIT                                        
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7300-GET-METER-LAST-MOVE.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           MV.MOVE_NO, 121), ' ', '-'), ':', '.') MOVE_NO                      
                 INTO :MV-MOVE-NO                                       
                FROM   CSS_MOVEMENT_HIST MV WITH(READUNCOMMITTED)               
                WHERE  MV.CODE_UTIL_TYPE  = :MV-CODE-UTIL-TYPE          
                AND    MV.DEVICE_NO       = :MV-DEVICE-NO               
                AND    MV.COMPANY_NO      = :MV-COMPANY-NO              
               ORDER BY MOVE_NO DESC                                 
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT MV.MOVE_NO                                               
MFA-TR*          INTO :MV-MOVE-NO                                               
MFA-TR*         FROM   CSS_MOVEMENT_HIST MV                                     
MFA-TR*         WHERE  MV.CODE_UTIL_TYPE  = :MV-CODE-UTIL-TYPE                  
MFA-TR*         AND    MV.DEVICE_NO       = :MV-DEVICE-NO                       
MFA-TR*         AND    MV.COMPANY_NO      = :MV-COMPANY-NO                      
MFA-TR*        ORDER BY MV.MOVE_NO DESC                                         
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
P00279     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSMT102 ERROR ******************' 
               DISPLAY '**      7300-GET-METER-LAST-MOVE            **' 
               DISPLAY '** COMPANY_NO     = ' MV-COMPANY-NO             
               DISPLAY '** CODE_UTIL_TYPE = ' MV-CODE-UTIL-TYPE         
               DISPLAY '** METER_NO       = ' MV-DEVICE-NO              
               DISPLAY '** SQLCODE        = ' WS-DISPLAY-SQLCODE        
               DISPLAY '** PROCESSING TERMINATED.......             **' 
               PERFORM 9900-ABEND                                       
                  THRU 9900-EXIT                                        
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7410-OPEN-ATTACHED-ERT.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                OPEN ATTACHED_ERT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSMT102 ERROR ******************'  
              DISPLAY '**    7410-OPEN-ATTACHED-ERT                **'  
              DISPLAY '** COMPANY_NO     = ' MA-COMPANY-NO              
              DISPLAY '** CODE_UTIL_TYPE = ' MA-CODE-UTIL-TYPE          
              DISPLAY '** METER_NO       = ' MA-METER-NO                
              DISPLAY '** SQLCODE        = ' WS-DISPLAY-SQLCODE         
              DISPLAY '** PROCESSING TERMINATED.......             **'  
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
      *                                                                         
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7420-FETCH-ATTACHED-ERT.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                FETCH ATTACHED_ERT                                      
                 INTO :MA-DEVICE-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSMT102 ERROR ****************'    
              DISPLAY '**       7420-FETCH-ATTACHED-ERT          **'    
              DISPLAY '** COMPANY_NO     = ' MA-COMPANY-NO              
              DISPLAY '** CODE_UTIL_TYPE = ' MA-CODE-UTIL-TYPE          
              DISPLAY '** METER_NO       = ' MA-METER-NO                
              DISPLAY '** SQLCODE        = ' WS-DISPLAY-SQLCODE         
              DISPLAY '** PROCESSING TERMINATED.......           **'    
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
      *                                                                         
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7430-CLOSE-ATTACHED-ERT.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                CLOSE ATTACHED_ERT                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSMT102 ERROR ******************' 
               DISPLAY '**    7430-CLOSE-ATTACHED-ERT               **' 
               DISPLAY '** COMPANY_NO     = ' MA-COMPANY-NO             
               DISPLAY '** CODE_UTIL_TYPE = ' MA-CODE-UTIL-TYPE         
               DISPLAY '** METER_NO       = ' MA-METER-NO               
               DISPLAY '** SQLCODE        = ' WS-DISPLAY-SQLCODE        
               DISPLAY '** PROCESSING TERMINATED.......             **' 
               PERFORM 9900-ABEND                                       
                  THRU 9900-EXIT                                        
           END-IF.                                                      
      *                                                                         
       7430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7440-GET-ATTACHED-MTR.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                SELECT MA.METER_NO                                      
                 INTO :MA-METER-NO                                      
                FROM CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                
                WHERE MA.COMPANY_NO        = :MA-COMPANY-NO             
                AND   MA.CODE_UTIL_TYPE    = :MA-CODE-UTIL-TYPE         
                AND   MA.CODE_ATT_TYPE     = 'IT'                       
                AND   MA.DEVICE_NO         = :MA-DEVICE-NO              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT MA.METER_NO                                              
MFA-TR*          INTO :MA-METER-NO                                              
MFA-TR*         FROM CSS_METER_ATTCHMTS MA                                      
MFA-TR*         WHERE MA.COMPANY_NO        = :MA-COMPANY-NO                     
MFA-TR*         AND   MA.CODE_UTIL_TYPE    = :MA-CODE-UTIL-TYPE                 
MFA-TR*         AND   MA.CODE_ATT_TYPE     = 'IT'                               
MFA-TR*         AND   MA.DEVICE_NO         = :MA-DEVICE-NO                      
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7440                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
ACT125     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSMT102 ERROR ******************'  
              DISPLAY '**    7440-GET-ATTACHED-MTR                 **'  
              DISPLAY '** COMPANY_NO     = ' MA-COMPANY-NO              
              DISPLAY '** CODE_UTIL_TYPE = ' MA-CODE-UTIL-TYPE          
              DISPLAY '** DEVICE_NO      = ' MA-DEVICE-NO               
              DISPLAY '** SQLCODE        = ' WS-DISPLAY-SQLCODE         
              DISPLAY '** PROCESSING TERMINATED.......             **'  
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
      *                                                                         
       7440-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7500-GET-ERT-DETAILS.                                            
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                SELECT LX.EQUIP_LOC_ID                                  
                      ,LX.MTR_STORAGE_FAC_CD                            
                      ,LX.DATE_LAST_MOVE                                
                      ,LX.DATE_LAST_TRAN                                
                      ,LX.EQUIP_ATTACH_DT                               
                      ,LX.CODE_ATT_TYPE                                 
                      ,LX.IN_TRANSIT_EMP_ID                             
                INTO  :LX-EQUIP-LOC-ID                                  
                     ,:LX-MTR-STORAGE-FAC-CD :WS-NULL-IND-1              
                     ,:LX-DATE-LAST-MOVE :WS-NULL-IND-2                  
                     ,:LX-DATE-LAST-TRAN :WS-NULL-IND-3                  
                     ,:LX-EQUIP-ATTACH-DT :WS-NULL-IND-4                 
                     ,:LX-CODE-ATT-TYPE                                 
                     ,:LX-IN-TRANSIT-EMP-ID                             
                FROM  CSS_EQUIP_ATTCHMTS LX WITH(READUNCOMMITTED)               
                WHERE LX.COMPANY_NO     = :LX-COMPANY-NO                
                AND   LX.CODE_UTIL_TYPE = :LX-CODE-UTIL-TYPE            
                AND   LX.DEVICE_NO      = :LX-DEVICE-NO                 
                AND   LX.CODE_ATT_TYPE  = 'IT'                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT LX.EQUIP_LOC_ID                                          
MFA-TR*               ,LX.MTR_STORAGE_FAC_CD                                    
MFA-TR*               ,LX.DATE_LAST_MOVE                                        
MFA-TR*               ,LX.DATE_LAST_TRAN                                        
MFA-TR*               ,LX.EQUIP_ATTACH_DT                                       
MFA-TR*               ,LX.CODE_ATT_TYPE                                         
MFA-TR*               ,LX.IN_TRANSIT_EMP_ID                                     
MFA-TR*         INTO  :LX-EQUIP-LOC-ID                                          
MFA-TR*              ,:LX-MTR-STORAGE-FAC-CD:WS-NULL-IND-1                      
MFA-TR*              ,:LX-DATE-LAST-MOVE:WS-NULL-IND-2                          
MFA-TR*              ,:LX-DATE-LAST-TRAN:WS-NULL-IND-3                          
MFA-TR*              ,:LX-EQUIP-ATTACH-DT:WS-NULL-IND-4                         
MFA-TR*              ,:LX-CODE-ATT-TYPE                                         
MFA-TR*              ,:LX-IN-TRANSIT-EMP-ID                                     
MFA-TR*         FROM  CSS_EQUIP_ATTCHMTS LX                                     
MFA-TR*         WHERE LX.COMPANY_NO     = :LX-COMPANY-NO                        
MFA-TR*         AND   LX.CODE_UTIL_TYPE = :LX-CODE-UTIL-TYPE                    
MFA-TR*         AND   LX.DEVICE_NO      = :LX-DEVICE-NO                         
MFA-TR*         AND   LX.CODE_ATT_TYPE  = 'IT'                                  
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSMT102 ERROR ******************' 
               DISPLAY '**        7500-GET-ERT-DETAILS              **' 
               DISPLAY '** COMPANY_NO     = ' LX-COMPANY-NO             
               DISPLAY '** CODE_UTIL_TYPE = ' LX-CODE-UTIL-TYPE         
               DISPLAY '** DEVICE_NO      = ' LX-DEVICE-NO              
               DISPLAY '** SQLCODE        = ' WS-DISPLAY-SQLCODE        
               DISPLAY '** PROCESSING TERMINATED.......             **' 
               PERFORM 9900-ABEND                                       
                  THRU 9900-EXIT                                        
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7510-OPEN-MTR-STOR-FAC.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                OPEN MTR_STOR_FAC                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSMT102 ERROR ****************'    
              DISPLAY '**       7510-OPEN-MTR-STOR-FAC           **'    
              DISPLAY '** COMPANY_NO     = ' JB-COMPANY-NO              
              DISPLAY '** CODE_UTIL_TYPE = ' JB-CODE-UTIL-TYPE          
              DISPLAY '** MOVE_TO_MSF  = ' E-FIOMT102-MOVETO-MSF-CODE   
              DISPLAY '** SQLCODE        = ' WS-DISPLAY-SQLCODE         
              DISPLAY '** PROCESSING TERMINATED.......           **'    
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
      *                                                                         
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7520-FETCH-MTR-STOR-FAC.                                         

MSQ008     MOVE 1000 TO MSQ008-MTR-STOR-FAC
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                FOR :MSQ008-MTR-STOR-FAC
              FETCH 
              FROM MTR_STOR_FAC        
                 INTO :TAB-COMPANY-NO                                   
                     ,:TAB-CODE-UTIL-TYPE                               
                     ,:TAB-MTR-STORAGE-FAC-CD                           
                     ,:TAB-EQUIP-LOC-ID                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*         FETCH NEXT ROWSET FROM MTR_STOR_FAC FOR 1000 ROWS               
MFA-TR*          INTO :TAB-COMPANY-NO                                           
MFA-TR*              ,:TAB-CODE-UTIL-TYPE                                       
MFA-TR*              ,:TAB-MTR-STORAGE-FAC-CD                                   
MFA-TR*              ,:TAB-EQUIP-LOC-ID                                         
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-MTR-STOR-FAC
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SQLERRD(3)             TO WS-MSF-COUNT               
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSMT102 ERROR ******************'  
              DISPLAY '**    7520-FETCH-MTR-STOR-FAC               **'  
              DISPLAY '** COMPANY_NO     = ' JB-COMPANY-NO              
              DISPLAY '** CODE_UTIL_TYPE = ' JB-CODE-UTIL-TYPE          
              DISPLAY '** MOVE_TO_MSF  = ' E-FIOMT102-MOVETO-MSF-CODE   
              DISPLAY '** SQLCODE        = ' WS-DISPLAY-SQLCODE         
              DISPLAY '** PROCESSING TERMINATED.......             **'  
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
      *                                                                         
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7530-CLOSE-MTR-STOR-FAC.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                CLOSE MTR_STOR_FAC                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSMT102 ERROR ******************' 
               DISPLAY '**    7530-CLOSE-MTR-STOR-FAC               **' 
               DISPLAY '** COMPANY_NO     = ' JB-COMPANY-NO             
               DISPLAY '** CODE_UTIL_TYPE = ' JB-CODE-UTIL-TYPE         
               DISPLAY '** MOVE_TO_MSF  = ' E-FIOMT102-MOVETO-MSF-CODE  
               DISPLAY '** SQLCODE        = ' WS-DISPLAY-SQLCODE        
               DISPLAY '** PROCESSING TERMINATED.......             **' 
               PERFORM 9900-ABEND                                       
                  THRU 9900-EXIT                                        
           END-IF.                                                      
      *                                                                         
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
      * 7600-START-FCSJC01                                             *        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
                                                                        
      *================================================================*        
      * 7620-START-FCSCA00 VSAM CTRL FILE                              *        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
                                                                        
      *================================================================*        
       7700-GET-ERT-LAST-MOVE.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           MP.MOVE_NO, 121), ' ', '-'), ':', '.') MOVE_NO                      
                 INTO :MP-MOVE-NO                                       
                FROM   CSS_EQUIP_ATT_MOVE MP WITH(READUNCOMMITTED)              
                WHERE  MP.DEVICE_NO        = :MP-DEVICE-NO              
                AND    MP.CODE_ATT_TYPE    = :MP-CODE-ATT-TYPE          
                AND    MP.COMPANY_NO       = :MP-COMPANY-NO             
                AND    MP.CODE_UTIL_TYPE   = :MP-CODE-UTIL-TYPE         
                ORDER BY MOVE_NO DESC                                
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT MP.MOVE_NO                                               
MFA-TR*          INTO :MP-MOVE-NO                                               
MFA-TR*         FROM   CSS_EQUIP_ATT_MOVE MP                                    
MFA-TR*         WHERE  MP.DEVICE_NO        = :MP-DEVICE-NO                      
MFA-TR*         AND    MP.CODE_ATT_TYPE    = :MP-CODE-ATT-TYPE                  
MFA-TR*         AND    MP.COMPANY_NO       = :MP-COMPANY-NO                     
MFA-TR*         AND    MP.CODE_UTIL_TYPE   = :MP-CODE-UTIL-TYPE                 
MFA-TR*         ORDER BY MP.MOVE_NO DESC                                        
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSMT102 ERROR ******************' 
               DISPLAY '**       7700-GET-ERT-LAST-MOVE             **' 
               DISPLAY '** DEVICE_NO      = ' MP-DEVICE-NO              
               DISPLAY '** CODE_ATT_TYPE  = ' MP-CODE-ATT-TYPE          
               DISPLAY '** COMPANY_NO     = ' MP-COMPANY-NO             
               DISPLAY '** CODE_UTIL_TYPE = ' MP-CODE-UTIL-TYPE         
               DISPLAY '** SQLCODE        = ' WS-DISPLAY-SQLCODE        
               DISPLAY '** PROCESSING TERMINATED.......             **' 
               PERFORM 9900-ABEND                                       
                  THRU 9900-EXIT                                        
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7800-SELECT-RESTART-DATA.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT RESTART_DATA                                      
                 INTO :RF-RESTART-DATA                                  
                 FROM CSS_RESTART WITH(READUNCOMMITTED)                         
                WHERE NAME_PROGRAM   = :RF-NAME-PROGRAM                 
                  AND PARTITION_NO   = :RF-PARTITION-NO                 
                  AND DUP_CNTRL_NO   = :RF-DUP-CNTRL-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESTART_DATA                                              
MFA-TR*          INTO :RF-RESTART-DATA                                          
MFA-TR*          FROM CSS_RESTART                                               
MFA-TR*         WHERE NAME_PROGRAM   = :RF-NAME-PROGRAM                         
MFA-TR*           AND PARTITION_NO   = :RF-PARTITION-NO                         
MFA-TR*           AND DUP_CNTRL_NO   = :RF-DUP-CNTRL-NO                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7800                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSMT102 ERROR ******************' 
               DISPLAY '**      7800-SELECT-RESTART-DATA            **' 
               DISPLAY '** NAME_PROGRAM    = ' RF-NAME-PROGRAM          
               DISPLAY '** PARTITION_NO    = ' RF-PARTITION-NO          
               DISPLAY '** DUP_CNTRL_NO    = ' RF-DUP-CNTRL-NO          
               DISPLAY '** SQL CODE        = ' WS-DISPLAY-SQLCODE       
               DISPLAY '** PROCESSING TERMINATED.......             **' 
               PERFORM 9900-ABEND                                       
                  THRU 9900-EXIT                                        
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7900-GET-CURRENT-DATE-TS.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE),
              DATEADD( DAY, -30, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-CURRENT-TIMESTMP,
              :WS-CURRENT-DATE,
              :WS-CURRENT-30-DAYS        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-TIMESTMP = CURRENT TIMESTAMP                     
MFA-TR*           ,:WS-CURRENT-DATE     = CURRENT DATE                          
MFA-TR*           ,:WS-CURRENT-30-DAYS  = CURRENT DATE - 30 DAYS                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSMT102 ERROR ******************'  
              DISPLAY '**       7900-GET-CURRENT-DATE-TS           **'  
              DISPLAY '** SQL CODE       = ' WS-DISPLAY-SQLCODE         
              DISPLAY '** PROCESSING TERMINATED.......             **'  
      *       PERFORM 9900-ABEND                                                
      *          THRU 9900-EXIT                                                 
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7910-GET-RECEIVED-MOVE-DATE.                                     
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT
              IIF(TRY_CONVERT(DATE, :WS-FRMT-MOVE-TS
              ) IS NULL OR (PATINDEX('%.%', :WS-FRMT-MOVE-TS
              ) <> 0) OR (LEN(:WS-FRMT-MOVE-TS) <> 10), CIS.CHAR2DATE(
                                                       :WS-FRMT-MOVE-TS
              ), CONVERT(DATE, :WS-FRMT-MOVE-TS) ),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CHAR2TIMESTAMP(
                                                      :WS-FRMT-MOVE-TS)
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-RECEIVED-MOVE-DATE,
              :WS-FRMT-TIMESTAMP  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET                                                              
MFA-TR*           :WS-RECEIVED-MOVE-DATE = DATE(:WS-FRMT-MOVE-TS)               
MFA-TR*          ,:WS-FRMT-TIMESTAMP     = TIMESTAMP(:WS-FRMT-MOVE-TS)          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '**    7910-GET-RECEIVED-MOVE-DATE    **'         
              DISPLAY '** MTR/ERT NO     : ' E-FIOMT102-METER-ERT-NO    
              DISPLAY '** MOVE TS        : ' E-FIOMT102-MOVE-TIMESTMP   
              DISPLAY '** SQLCODE        : ' WS-DISPLAY-SQLCODE         
           END-IF.                                                      
      *                                                                         
       7910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7920-GET-DEC-TIMESTAMP.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MICROSECOND, -
              10, CIS.CHAR2TIMESTAMP(:WS-I-RECORD-TS) ), 121), ' ', 
           '-'), ':', '.')
            INTO
              :WS-I-DECRMT-TS         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-I-DECRMT-TS =                                            
MFA-TR*            TIMESTAMP(:WS-I-RECORD-TS) - 10 MICROSECONDS                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '**    7920-GET-DEC-TIMESTAMP    **'              
              DISPLAY '** MTR/ERT NO     : ' E-FIOMT102-METER-ERT-NO    
              DISPLAY '** MOVE TS        : ' E-FIOMT102-MOVE-TIMESTMP   
              DISPLAY '** CALLED FROM    : ' WS-ACTIVE-PARAGRAPH        
              DISPLAY '** SQLCODE        : ' WS-DISPLAY-SQLCODE         
           END-IF.                                                      
      *                                                                         
       7920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7940-CHECK-DUPLICATE-MTR-RECD.                                   
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                SELECT DATE_MOVE                                        
                 INTO :MV-DATE-MOVE                                     
                FROM  CSS_MOVEMENT_HIST WITH(READUNCOMMITTED)                   
                WHERE CODE_UTIL_TYPE = :MV-CODE-UTIL-TYPE               
                AND   DEVICE_NO      = :MV-DEVICE-NO                    
                AND   MOVE_NO        = CIS.CHAR2TIMESTAMP(:MV-MOVE-NO)          
                AND   COMPANY_NO     = :MV-COMPANY-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DATE_MOVE                                                
MFA-TR*          INTO :MV-DATE-MOVE                                             
MFA-TR*         FROM  CSS_MOVEMENT_HIST                                         
MFA-TR*         WHERE CODE_UTIL_TYPE = :MV-CODE-UTIL-TYPE                       
MFA-TR*         AND   DEVICE_NO      = :MV-DEVICE-NO                            
MFA-TR*         AND   MOVE_NO        = :MV-MOVE-NO                              
MFA-TR*         AND   COMPANY_NO     = :MV-COMPANY-NO                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7940                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSMT102 ERROR ******************'  
              DISPLAY '**       7940-CHECK-DUPLICATE-MTR-RECD      **'  
              DISPLAY '** MTR/ERT NO     : ' E-FIOMT102-METER-ERT-NO    
              DISPLAY '** MOVE TS        : ' E-FIOMT102-MOVE-TIMESTMP   
              DISPLAY '** DEVICE_NO      : ' MV-DEVICE-NO               
              DISPLAY '** CODE-UTIL-TYPE : ' MV-CODE-UTIL-TYPE          
              DISPLAY '** MOVE_NO        : ' MV-MOVE-NO                 
              DISPLAY '** COMPANY_NO     : ' MV-COMPANY-NO              
              DISPLAY '** SQL CODE       = ' WS-DISPLAY-SQLCODE         
              DISPLAY '** PROCESSING TERMINATED.......             **'  
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
      *                                                                         
       7940-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7960-CHECK-DUPLICATE-ERT-RECD.                                   
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                SELECT DEVICE_NO                                        
                 INTO :MP-DEVICE-NO                                     
                FROM  CSS_EQUIP_ATT_MOVE MP WITH(READUNCOMMITTED)               
                WHERE CODE_UTIL_TYPE = :MP-CODE-UTIL-TYPE               
                AND   DEVICE_NO      = :MP-DEVICE-NO                    
                AND   MOVE_NO        = CIS.CHAR2TIMESTAMP(:MP-MOVE-NO)          
                AND   COMPANY_NO     = :MP-COMPANY-NO                   
                AND   CODE_ATT_TYPE  = 'IT'                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DEVICE_NO                                                
MFA-TR*          INTO :MP-DEVICE-NO                                             
MFA-TR*         FROM  CSS_EQUIP_ATT_MOVE MP                                     
MFA-TR*         WHERE CODE_UTIL_TYPE = :MP-CODE-UTIL-TYPE                       
MFA-TR*         AND   DEVICE_NO      = :MP-DEVICE-NO                            
MFA-TR*         AND   MOVE_NO        = :MP-MOVE-NO                              
MFA-TR*         AND   COMPANY_NO     = :MP-COMPANY-NO                           
MFA-TR*         AND   CODE_ATT_TYPE  = 'IT'                                     
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7960                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSMT102 ERROR ******************' 
               DISPLAY '**       7960-CHECK-DUPLICATE-ERT-RECD      **' 
               DISPLAY '** MTR/ERT NO     : ' E-FIOMT102-METER-ERT-NO   
               DISPLAY '** MOVE TS        : ' E-FIOMT102-MOVE-TIMESTMP  
               DISPLAY '** DEVICE_NO      : ' MP-DEVICE-NO              
               DISPLAY '** CODE-UTIL-TYPE : ' MP-CODE-UTIL-TYPE         
               DISPLAY '** MOVE_NO        : ' MP-MOVE-NO                
               DISPLAY '** COMPANY_NO     : ' MP-COMPANY-NO             
               DISPLAY '** SQL CODE       = ' WS-DISPLAY-SQLCODE        
               DISPLAY '** PROCESSING TERMINATED.......             **' 
               PERFORM 9900-ABEND                                       
                  THRU 9900-EXIT                                        
           END-IF.                                                      
      *                                                                         
       7960-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       8000-WRITE-FCSM102B.                                             
      *================================================================*        
      *                                                                         
           WRITE FIOM102B-REC.                                          
                                                                        
           IF FCSM102B-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************ PCSMT102 ERROR *******************' 
              DISPLAY '**        8000-WRITE-FCSM102B                **' 
              DISPLAY '** MTR/ERT NO   : ' E-FIOMT102-METER-ERT-NO      
              DISPLAY '** MOVE TS      : ' E-FIOMT102-MOVE-TIMESTMP     
              DISPLAY '** STATUS IS    : ' WS-FCSM102B-STATUS           
              DISPLAY '** PROCESSING TERMINATED.......              **' 
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       8100-INSERT-METER-HIST.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_MOVEMENT_HIST                           
                      (  CODE_UTIL_TYPE                                 
                        ,DEVICE_NO                                      
                        ,DATE_MOVE                                      
                        ,MOVE_NO                                        
                        ,CODE_DEVICE_TYPE                               
                        ,COMPANY_NO                                     
                        ,LOCAL_OFFICE                                   
                        ,LOC_NO                                         
                        ,CODE_CRNT_LOC                                  
                        ,IN_TRANSIT_EMP_ID )                            
                VALUES(                                                 
                         :MV-CODE-UTIL-TYPE                             
                        ,:MV-DEVICE-NO                                  
                        ,IIF(TRY_CONVERT(DATE, :MV-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MV-DATE-MOVE
              ) <> 0) OR (LEN(:MV-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MV-DATE-MOVE
              ), CONVERT(DATE, :MV-DATE-MOVE) )                                
                        ,CIS.CHAR2TIMESTAMP(:MV-MOVE-NO)                        
                        ,:MV-CODE-DEVICE-TYPE                           
                        ,:MV-COMPANY-NO                                 
                        ,:MV-LOCAL-OFFICE                               
                        ,:MV-LOC-NO                                     
                        ,:MV-CODE-CRNT-LOC                              
                        ,:MV-IN-TRANSIT-EMP-ID )                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_MOVEMENT_HIST                                   
MFA-TR*               (  CODE_UTIL_TYPE                                         
MFA-TR*                 ,DEVICE_NO                                              
MFA-TR*                 ,DATE_MOVE                                              
MFA-TR*                 ,MOVE_NO                                                
MFA-TR*                 ,CODE_DEVICE_TYPE                                       
MFA-TR*                 ,COMPANY_NO                                             
MFA-TR*                 ,LOCAL_OFFICE                                           
MFA-TR*                 ,LOC_NO                                                 
MFA-TR*                 ,CODE_CRNT_LOC                                          
MFA-TR*                 ,IN_TRANSIT_EMP_ID )                                    
MFA-TR*         VALUES(                                                         
MFA-TR*                  :MV-CODE-UTIL-TYPE                                     
MFA-TR*                 ,:MV-DEVICE-NO                                          
MFA-TR*                 ,:MV-DATE-MOVE                                          
MFA-TR*                 ,:MV-MOVE-NO                                            
MFA-TR*                 ,:MV-CODE-DEVICE-TYPE                                   
MFA-TR*                 ,:MV-COMPANY-NO                                         
MFA-TR*                 ,:MV-LOCAL-OFFICE                                       
MFA-TR*                 ,:MV-LOC-NO                                             
MFA-TR*                 ,:MV-CODE-CRNT-LOC                                      
MFA-TR*                 ,:MV-IN-TRANSIT-EMP-ID )                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSMT102 ERROR ******************' 
               DISPLAY '**       8100-INSERT-METER-HIST             **' 
               DISPLAY '** CODE_UTIL_TYPE = ' MV-CODE-UTIL-TYPE         
               DISPLAY '** DEVICE_NO      = ' MV-DEVICE-NO              
               DISPLAY '** DATE_MOVE      = ' MV-DATE-MOVE              
               DISPLAY '** MOVE_NO        = ' MV-MOVE-NO                
               DISPLAY '** CODE_DEVICE_TYP= ' MV-CODE-DEVICE-TYPE       
               DISPLAY '** COMPANY_NO     = ' MV-COMPANY-NO             
               DISPLAY '** LOCAL_OFFICE   = ' MV-LOCAL-OFFICE           
               DISPLAY '** LOC_NO         = ' MV-LOC-NO                 
               DISPLAY '** CODE_CRNT_LOC  = ' MV-CODE-CRNT-LOC          
               DISPLAY '** IN_TRANSIT_EMP = ' MV-IN-TRANSIT-EMP-ID      
               DISPLAY '** SQLCODE        = ' WS-DISPLAY-SQLCODE        
               DISPLAY '** PROCESSING TERMINATED.......             **' 
               PERFORM 9900-ABEND                                       
                  THRU 9900-EXIT                                        
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       8200-UPDATE-METER.                                               
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                UPDATE CSS_EQUIPMENT                                    
                   SET LOCAL_OFFICE      = :EQ-LOCAL-OFFICE             
                      ,CODE_CRNT_LOC     = :EQ-CODE-CRNT-LOC            
                      ,DATE_LAST_MOVE    = IIF(TRY_CONVERT(DATE, 
                                                     :EQ-DATE-LAST-MOVE
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-MOVE
              ) <> 0) OR (LEN(:EQ-DATE-LAST-MOVE
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-MOVE
              ), CONVERT(DATE, :EQ-DATE-LAST-MOVE) )           
                      ,DATE_LAST_TRAN    = IIF(TRY_CONVERT(DATE, 
                                                     :EQ-DATE-LAST-TRAN
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-TRAN
              ) <> 0) OR (LEN(:EQ-DATE-LAST-TRAN
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-TRAN
              ), CONVERT(DATE, :EQ-DATE-LAST-TRAN) )           
                      ,IN_TRANSIT_EMP_ID = :EQ-IN-TRANSIT-EMP-ID        
                WHERE COMPANY_NO         = :EQ-COMPANY-NO               
                AND   CODE_UTIL_TYPE     = :EQ-CODE-UTIL-TYPE           
                AND   DEVICE_NO          = :EQ-DEVICE-NO                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_EQUIPMENT                                            
MFA-TR*            SET LOCAL_OFFICE      = :EQ-LOCAL-OFFICE                     
MFA-TR*               ,CODE_CRNT_LOC     = :EQ-CODE-CRNT-LOC                    
MFA-TR*               ,DATE_LAST_MOVE    = :EQ-DATE-LAST-MOVE                   
MFA-TR*               ,DATE_LAST_TRAN    = :EQ-DATE-LAST-TRAN                   
MFA-TR*               ,IN_TRANSIT_EMP_ID = :EQ-IN-TRANSIT-EMP-ID                
MFA-TR*         WHERE COMPANY_NO         = :EQ-COMPANY-NO                       
MFA-TR*         AND   CODE_UTIL_TYPE     = :EQ-CODE-UTIL-TYPE                   
MFA-TR*         AND   DEVICE_NO          = :EQ-DEVICE-NO                        
MFA-TR*        QUERYNO 8300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSMT102 ERROR ******************' 
               DISPLAY '**         8200-UPDATE-METER                **' 
               DISPLAY '** COMPANY_NO     = ' EQ-COMPANY-NO             
               DISPLAY '** CODE_UTIL_TYPE = ' EQ-CODE-UTIL-TYPE         
               DISPLAY '** DEVICE_NO      = ' EQ-DEVICE-NO              
               DISPLAY '** LOCAL_OFFICE   = ' EQ-LOCAL-OFFICE           
               DISPLAY '** CODE_CRNT_LOC  = ' EQ-CODE-CRNT-LOC          
               DISPLAY '** DATE_LAST_MOVE = ' EQ-DATE-LAST-MOVE         
               DISPLAY '** IN_TRANSIT_EMP = ' EQ-IN-TRANSIT-EMP-ID      
               DISPLAY '** SQLCODE        = ' WS-DISPLAY-SQLCODE        
               DISPLAY '** PROCESSING TERMINATED.......             **' 
               PERFORM 9900-ABEND                                       
                  THRU 9900-EXIT                                        
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       8300-INSERT-ERT-HIST.                                            
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_EQUIP_ATT_MOVE                          
                      (                                                 
                        DEVICE_NO                                       
                       ,CODE_ATT_TYPE                                   
                       ,COMPANY_NO                                      
                       ,CODE_UTIL_TYPE                                  
                       ,DATE_MOVE                                       
                       ,MOVE_NO                                         
                       ,MTR_STORAGE_FAC_CD                              
                       ,METER_NO                                        
                       ,EQUIP_LOC_ID                                    
                       ,REASON_REMOVED_CD                               
                       ,IN_TRANSIT_EMP_ID                               
                      )                                                 
                VALUES(                                                 
                        :MP-DEVICE-NO                                   
                       ,:MP-CODE-ATT-TYPE                               
                       ,:MP-COMPANY-NO                                  
                       ,:MP-CODE-UTIL-TYPE                              
                       ,IIF(TRY_CONVERT(DATE, :MP-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MP-DATE-MOVE
              ) <> 0) OR (LEN(:MP-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MP-DATE-MOVE
              ), CONVERT(DATE, :MP-DATE-MOVE) )                                
                       ,CIS.CHAR2TIMESTAMP(:MP-MOVE-NO)                         
                       ,:MP-MTR-STORAGE-FAC-CD                          
                       ,:MP-METER-NO                                    
                       ,:MP-EQUIP-LOC-ID                                
                       ,' '                                             
                       ,:MP-IN-TRANSIT-EMP-ID                           
                      )                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_EQUIP_ATT_MOVE                                  
MFA-TR*               (                                                         
MFA-TR*                 DEVICE_NO                                               
MFA-TR*                ,CODE_ATT_TYPE                                           
MFA-TR*                ,COMPANY_NO                                              
MFA-TR*                ,CODE_UTIL_TYPE                                          
MFA-TR*                ,DATE_MOVE                                               
MFA-TR*                ,MOVE_NO                                                 
MFA-TR*                ,MTR_STORAGE_FAC_CD                                      
MFA-TR*                ,METER_NO                                                
MFA-TR*                ,EQUIP_LOC_ID                                            
MFA-TR*                ,REASON_REMOVED_CD                                       
MFA-TR*                ,IN_TRANSIT_EMP_ID                                       
MFA-TR*               )                                                         
MFA-TR*         VALUES(                                                         
MFA-TR*                 :MP-DEVICE-NO                                           
MFA-TR*                ,:MP-CODE-ATT-TYPE                                       
MFA-TR*                ,:MP-COMPANY-NO                                          
MFA-TR*                ,:MP-CODE-UTIL-TYPE                                      
MFA-TR*                ,:MP-DATE-MOVE                                           
MFA-TR*                ,:MP-MOVE-NO                                             
MFA-TR*                ,:MP-MTR-STORAGE-FAC-CD                                  
MFA-TR*                ,:MP-METER-NO                                            
MFA-TR*                ,:MP-EQUIP-LOC-ID                                        
MFA-TR*                ,' '                                                     
MFA-TR*                ,:MP-IN-TRANSIT-EMP-ID                                   
MFA-TR*               )                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSMT102 ERROR ******************' 
               DISPLAY '**        8300-INSERT-ERT-HIST              **' 
               DISPLAY '** DEVICE_NO     = ' MP-DEVICE-NO               
               DISPLAY '** CODE_ATT_TYPE = ' MP-CODE-ATT-TYPE           
               DISPLAY '** COMPANY_NO    = ' MP-COMPANY-NO              
               DISPLAY '** CODE_UTIL_TYPE= ' MP-CODE-UTIL-TYPE          
               DISPLAY '** DATE_MOVE     = ' MP-DATE-MOVE               
               DISPLAY '** MOVE_NO       = ' MP-MOVE-NO                 
               DISPLAY '** MTR-STORAGE-FA= ' MP-MTR-STORAGE-FAC-CD      
               DISPLAY '** METER-NO      = ' MP-METER-NO                
               DISPLAY '** EQUIP-LOC-ID  = ' MP-EQUIP-LOC-ID            
               DISPLAY '** IN-TRANSIT-EMP= ' MP-IN-TRANSIT-EMP-ID       
               DISPLAY '** SQLCODE       = ' WS-DISPLAY-SQLCODE         
               DISPLAY '** PROCESSING TERMINATED.......             **' 
               PERFORM 9900-ABEND                                       
                  THRU 9900-EXIT                                        
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       8400-UPDATE-ERT.                                                 
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                UPDATE CSS_EQUIP_ATTCHMTS                               
                   SET EQUIP_LOC_ID       = :LX-EQUIP-LOC-ID            
                      ,MTR_STORAGE_FAC_CD = :LX-MTR-STORAGE-FAC-CD      
                      ,DATE_LAST_MOVE     = IIF(TRY_CONVERT(DATE, 
                                                     :LX-DATE-LAST-MOVE
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-MOVE
              ) <> 0) OR (LEN(:LX-DATE-LAST-MOVE
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-MOVE
              ), CONVERT(DATE, :LX-DATE-LAST-MOVE) )          
                      ,DATE_LAST_TRAN     = IIF(TRY_CONVERT(DATE, 
                                                     :LX-DATE-LAST-TRAN
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-TRAN
              ) <> 0) OR (LEN(:LX-DATE-LAST-TRAN
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-TRAN
              ), CONVERT(DATE, :LX-DATE-LAST-TRAN) )          
                      ,IN_TRANSIT_EMP_ID  = :LX-IN-TRANSIT-EMP-ID       
                WHERE DEVICE_NO           = :LX-DEVICE-NO               
                AND   CODE_ATT_TYPE       = :LX-CODE-ATT-TYPE           
                AND   CODE_UTIL_TYPE      = :LX-CODE-UTIL-TYPE          
                AND   COMPANY_NO          = :LX-COMPANY-NO              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_EQUIP_ATTCHMTS                                       
MFA-TR*            SET EQUIP_LOC_ID       = :LX-EQUIP-LOC-ID                    
MFA-TR*               ,MTR_STORAGE_FAC_CD = :LX-MTR-STORAGE-FAC-CD              
MFA-TR*               ,DATE_LAST_MOVE     = :LX-DATE-LAST-MOVE                  
MFA-TR*               ,DATE_LAST_TRAN     = :LX-DATE-LAST-TRAN                  
MFA-TR*               ,IN_TRANSIT_EMP_ID  = :LX-IN-TRANSIT-EMP-ID               
MFA-TR*         WHERE DEVICE_NO           = :LX-DEVICE-NO                       
MFA-TR*         AND   CODE_ATT_TYPE       = :LX-CODE-ATT-TYPE                   
MFA-TR*         AND   CODE_UTIL_TYPE      = :LX-CODE-UTIL-TYPE                  
MFA-TR*         AND   COMPANY_NO          = :LX-COMPANY-NO                      
MFA-TR*        QUERYNO 8500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSMT102 ERROR ******************' 
               DISPLAY '**          8400-UPDATE-ERT                 **' 
               DISPLAY '** DEVICE_NO     = ' LX-DEVICE-NO               
               DISPLAY '** CODE_ATT_TYPE = ' LX-CODE-ATT-TYPE           
               DISPLAY '** COMPANY_NO    = ' LX-COMPANY-NO              
               DISPLAY '** CODE_UTIL_TYPE= ' LX-CODE-UTIL-TYPE          
               DISPLAY '** EQUIP_LOC_ID  = ' LX-EQUIP-LOC-ID            
               DISPLAY '** MTR_STORAGE_FA= ' LX-MTR-STORAGE-FAC-CD      
               DISPLAY '** DATE_LAST_MOVE= ' LX-DATE-LAST-MOVE          
               DISPLAY '** DATE_LAST_TRAN= ' LX-DATE-LAST-TRAN          
               DISPLAY '** IN_TRANSIT_EMP= ' LX-IN-TRANSIT-EMP-ID       
               DISPLAY '** SQLCODE       = ' WS-DISPLAY-SQLCODE         
               DISPLAY '** PROCESSING TERMINATED.......             **' 
               PERFORM 9900-ABEND                                       
                  THRU 9900-EXIT                                        
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       8896-UPDATE-RESTART.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_RESTART                                               
MFA-TR*           SET RESTART_DATA = :RF-RESTART-DATA                           
MFA-TR*         WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                           
MFA-TR*           AND PARTITION_NO = :RF-PARTITION-NO                           
MFA-TR*           AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                           
MFA-TR*        QUERYNO 8896                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '************ PCSMT102 ERROR ******************'  
              DISPLAY '**        8896-UPDATE-RESTART               **'  
              DISPLAY '** NAME_PROGRAM     = ' RF-NAME-PROGRAM          
              DISPLAY '** PARTITION_NO     = ' RF-PARTITION-NO          
              DISPLAY '** DUP_CNTRL_NO     = ' RF-DUP-CNTRL-NO          
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED.......             **'  
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
      *                                                                         
       8896-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       8897-INSERT-RESTART.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                   (NAME_PROGRAM, PARTITION_NO, DUP_CNTRL_NO,           
                    RESTART_DATA)                                       
               VALUES                                                   
                   (:RF-NAME-PROGRAM, :RF-PARTITION-NO,                 
                    :RF-DUP-CNTRL-NO, :RF-RESTART-DATA)                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '************ PCSMT102 ERROR ******************'  
              DISPLAY '**        8897-INSERT-RESTART               **'  
              DISPLAY '** NAME_PROGRAM     = ' RF-NAME-PROGRAM          
              DISPLAY '** PARTITION_NO     = ' RF-PARTITION-NO          
              DISPLAY '** DUP_CNTRL_NO     = ' RF-DUP-CNTRL-NO          
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED.......             **'  
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
      *                                                                         
       8897-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
      **** RESET RESTART-REQ PARAMETER TO INACTIVE                              
      *8893-RESET-RESTART-REQ-PARM.                                             
      *================================================================*        
           EXEC SQL                                                             
               INCLUDE CPD00029                                                 
           END-EXEC.                                                            
                                                                        
      *================================================================*        
       8898-ISSUE-CHKP.                                                 
      *================================================================*        
      *                                                                         
           MOVE 1                          TO WS-RESTART-PROCESS-TYPE.  
           ADD +1                          TO WS-CHKP-SEQ-NO.           
           MOVE WS-CHKP-SEQ-NO             TO WS-RESTART-CHKP-SEQ-NO.   
                                                                        
           MOVE WS-FCSMT102-REC-CNTR       TO WS-RESTART-RECORD-NO.     
           COMPUTE WS-RESTART-RECORD-NO = WS-RESTART-RECORD-NO - 1.     
                                                                        
           PERFORM 8899-WRITE-RSDDR                                     
              THRU 8899-EXIT.                                           
                                                                        
      *** Commit statement for DB2/SQL check points                             
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
                                                                        
           MOVE ZEROS                      TO WS-COMMIT-COUNT.          
           DISPLAY ' '                                                  
           DISPLAY 'COMMIT POINT# ' WS-CHKP-SEQ-NO ' TAKEN. '           
                   'METER/ERT ' WS-RESTART-METER-ERT-NO '   '           
                   'MOVE DATE ' WS-RESTART-MOVE-TS.                     
      *                                                                         
       8898-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       8899-WRITE-RSDDR.                                                
      *================================================================*        
      *                                                                         
           MOVE 1                          TO RF-PARTITION-NO           
                                              RF-DUP-CNTRL-NO.          
           MOVE PROGRAM-NAME               TO RF-NAME-PROGRAM.          
           MOVE WS-RESTART-DATA            TO RF-RESTART-DATA-TEXT.     
           MOVE WS-RESTART-DATA-LENGTH     TO RF-RESTART-DATA-LEN.      
                                                                        
           PERFORM 8896-UPDATE-RESTART                                  
              THRU 8896-EXIT.                                           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 8897-INSERT-RESTART                               
                 THRU 8897-EXIT                                         
           END-IF.                                                      
      *                                                                         
       8899-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       9000-TERMINATE.                                                  
      *================================================================*        
      *                                                                         
           CLOSE FCSMT102-FILE.                                         
                                                                        
           IF  FCSMT102-SUCCESSFUL                                      
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '************ PCSMT102 ERROR ******************'  
              DISPLAY '**           9000-TERMINATE                 **'  
              DISPLAY '** FILE FCSMT102-FILE                       **'  
              DISPLAY '** FILE STATUS = ' WS-FCSMT102-STATUS            
              DISPLAY '** PROCESSING TERMINATED.......             **'  
           END-IF.                                                      
                                                                        
           CLOSE FCSM102B-FILE.                                         
                                                                        
           IF FCSM102B-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************ PCSMT102 ERROR ******************'  
              DISPLAY '**           9000-TERMINATE                 **'  
              DISPLAY '** FILE FCSM102B-FILE                       **'  
              DISPLAY '** FILE STATUS = ' WS-FCSM102B-STATUS            
              DISPLAY '** PROCESSING TERMINATED.......             **'  
           END-IF.                                                      
                                                                        
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
      *9900-ABEND.                                                     *        
      *================================================================*        
      *** Abend copybook includes sql rollback                                  
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
