       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSMT101.                                         
       DATE-WRITTEN.   12/28/00.                                        
       DATE-COMPILED.                                                   
      ***************************************************************** 00050001
      ***************************************************************** 00060067
      **               SOUTH CAROLINA ELECTRIC & GAS                 ** 00070001
      **                                                             ** 00090001
      ********            CUSTOMER SERVICE SYSTEM             ********* 00100001
      ********                      DB2                       ********* 00110001
      ***************************************************************** 00120001
      **                                                             ** 00130001
      **            PROGRAM    MODIFICATION  LOG                     ** 00140001
      **    DATE    INITIALS     REASON                              ** 00150001
      **    ____    ________     ______                              ** 00160080
C35227**    03/07   DB41297      PERFORMANCE IMPROVEMENTS/ABEND      ** 00160080
C35227**                         REDUCTION.                          ** 00160080
      **                                                             ** 00160080
A04527**  JUL 2013  RF10596      CHANGE FOR SCEG AND PSNC            ** 00160080
A04527**  OCT 2013  BD09555      ADD 'INVENTORY' LOCATION FOR SELECT ** 00160080
      **  ACT180                                                     ** 00160080
      ***************************************************************** 00170001
           REMARKS.                                                     
                              PCSMT101 NARRATIVE                        
            THIS PROGRAM EXTRACTS THE DETAILS OF ALL THE METERS SENT    
            TO THE METER SHOP FOR TESTING. THE EXTRACTED INFORMATION    
            WILL BE SENT TO THE METER PROVER/TEST HISTORY SYSTEM.       
      *                                                                 00240001
                   ---- BASIC BATCH SEQUENCE STRUCTURE ----             
                                                                        
                  0000 - 0000     MAIN CONTROL PATH                     
                  1000 - 1999     INITIALIZATION                        
                  2000 - 4999     MAJOR PROCESSING LOOP                 
                  5000 - 5999     COMMON PROGRAM MODULES                
                  7000 - 7999     SQL MODULES                           
                  8000 - 8999     OUTPUT MODULES                        
                  9000 - 9799     TERMINATION MODULES                   
                  9900 - 9999     ABEND/ABORT MODULES                   
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSMT53.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDMT53.                                                            
       COPY FIOMT53.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSMT101'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-MISC.                                                     
           05  PROGRAM-NAME                PIC X(08)  VALUE             
               'PCSMT101'.                                              
           05  WS-PGRMNAME                 PIC X(08)  VALUE             
               'PCSMT101'.                                              
           05  WS-NO-MORE-DATA             PIC X(01)  VALUE 'N'.        
           05  WS-FMT53-STATUS             PIC X(02).                   
               88 FMT53-SUCCESSFUL                    VALUE '00'.       
           05  WS-TIMES-TESTED             PIC S9(4)  COMP.             
           05  WS-TIMES-TESTED-N           PIC 9(02).                   
           05  WS-PURCHASE-YEAR            PIC S9(4)  COMP.             
           05  WS-PURCHASE-YEAR-N          PIC 9(04).                   
           05  WS-PURCHASE-YEAR-X REDEFINES                             
               WS-PURCHASE-YEAR-N          PIC X(04).                   
           05  WS-RUN-DATE                 PIC X(10).                   
           05  WS-DATE-REMOVED             PIC X(10).                   
           05  WS-LAST-READ-VALUE          PIC 9(12)V9(3).              
           05  WS-PURCH-YR-NULL            PIC S9(4) COMP.              
           05  WS-DATE-LAST-MOVE-NULL      PIC S9(4) COMP.              
           05  WS-DATE-LAST-TESTED-NULL    PIC S9(4) COMP.              
           05  WS-TIMES-TESTED-NULL        PIC S9(4) COMP.              
           05  WS-TEST-SHOP                PIC X(01) VALUE 'B'.         
ACT180     05  WS-INVENTORY                PIC X(01) VALUE 'A'.         
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-G                        PIC X(01)  VALUE 'G'.        
           05  WS-J                        PIC X(01)  VALUE 'J'.        
           05  WS-K                        PIC X(01)  VALUE 'K'.        
           05  WS-N                        PIC X(01)  VALUE 'N'.        
           05  WS-Y                        PIC X(01)  VALUE 'Y'.        
           05  WS-U                        PIC X(01)  VALUE 'U'.        
           05  WS-26                       PIC X(02)  VALUE '26'.       
      *                                                                         
      *****************************                                             
      **  ABEND SWITCH COPYBOOK  **                                             
      *****************************                                             
      *                                                                         
           COPY CWS00010.                                                       
           COPY CWS09900.                                                       
           COPY CWS00038.                                                       
           COPY CWS00039.                                                       
           COPY FIOCA00.                                                        
           COPY FIOJC01.                                                        
      *                                                                         
      **********************************                                        
      **  DB2 AND SQL ERROR CHECKING  **                                        
      **********************************                                        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      *****************************************************************         
      **             TABLE DEFINITIONS AND DB2 INTERACTIONS          **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
      *                                                                         
      ********************                                                      
      **  CSS_JOB_PARM  **                                                      
      ********************                                                      
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      *********************                                                     
      **  CSS_EQUIPMENT  **                                                     
      *********************                                                     
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBEQUIP                                                    
           END-EXEC.                                                            
      *                                                                         
      ********************                                                      
      **  CSS_GAS_METER **                                                      
      ********************                                                      
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBGASMTR                                                   
           END-EXEC.                                                            
      *                                                                         
      ************************                                                  
      **  CSS_GAS_MTR_TEST  **                                                  
      ************************                                                  
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBGMTEST                                                   
           END-EXEC.                                                            
      *                                                                         
      ************************                                                  
      **  CSS_MOVEMENT_HIST **                                                  
      ************************                                                  
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBMVHIST                                                   
           END-EXEC.                                                            
      *                                                                         
      **************************************                                    
      **  CURSOR DECLARATION -- MAIN_CSR  **                                    
      **************************************                                    
           EXEC SQL                                                     
              DECLARE MAIN_CSR CURSOR FOR                               
              SELECT  EQ.DEVICE_NO                                      
                     ,EQ.SERIAL_NO                                      
                     ,GM.METER_SIZE_ID                                  
                     ,YEAR(DATE_PURCHASED)                              
                     ,EQ.DATE_LAST_MOVE                                 
                     ,GM.DATE_LAST_TESTED                               
                     ,EQ.LOCAL_OFFICE                                   
A04527               ,EQ.COMPANY_NO                                     
                FROM  CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                    
                     ,CSS_GAS_METER GM WITH(READUNCOMMITTED)                    
               WHERE  EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE            
ACT180           AND  EQ.CODE_CRNT_LOC  IN (:WS-TEST-SHOP,              
ACT180                                      :WS-INVENTORY)              
                 AND  GM.COMPANY_NO     = EQ.COMPANY_NO                 
                 AND  GM.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE             
                 AND  EQ.DEVICE_NO      = GM.METER_NO                   
C35227         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MAIN_CSR CURSOR FOR                                       
MFA-TR*       SELECT  EQ.DEVICE_NO                                              
MFA-TR*              ,EQ.SERIAL_NO                                              
MFA-TR*              ,GM.METER_SIZE_ID                                          
MFA-TR*              ,YEAR(DATE_PURCHASED)                                      
MFA-TR*              ,EQ.DATE_LAST_MOVE                                         
MFA-TR*              ,GM.DATE_LAST_TESTED                                       
MFA-TR*              ,EQ.LOCAL_OFFICE                                           
MFA-TR*              ,EQ.COMPANY_NO                                             
MFA-TR*         FROM  CSS_EQUIPMENT EQ                                          
MFA-TR*              ,CSS_GAS_METER GM                                          
MFA-TR*        WHERE  EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                    
MFA-TR*          AND  EQ.CODE_CRNT_LOC  IN (:WS-TEST-SHOP,                      
MFA-TR*                                     :WS-INVENTORY)                      
MFA-TR*          AND  GM.COMPANY_NO     = EQ.COMPANY_NO                         
MFA-TR*          AND  GM.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE                     
MFA-TR*          AND  EQ.DEVICE_NO      = GM.METER_NO                           
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      **************************************                                    
      **  CURSOR DECLARATION -- MV_CSR    **                                    
      **************************************                                    
           EXEC SQL                                                     
              DECLARE MV_CSR CURSOR FOR                                 
              SELECT  DATE_MOVE                                         
                     ,LOC_NO                                            
                     ,LOCAL_OFFICE                                      
                     ,CAST(MOVE_NO AS DATE)                                     
                     ,REASON_REMOVED_CD                                 
                     ,LAST_READ_VALUE                                   
                FROM  CSS_MOVEMENT_HIST WITH(READUNCOMMITTED)                   
               WHERE  CODE_UTIL_TYPE = :MV-CODE-UTIL-TYPE               
                 AND  COMPANY_NO     = :MV-COMPANY-NO                   
                 AND  DEVICE_NO      = :MV-DEVICE-NO                    
C35227           AND  CODE_CRNT_LOC  = 'J'                              
                 AND  DATE_MOVE      < IIF(TRY_CONVERT(DATE, 
                                                     :EQ-DATE-LAST-MOVE
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-MOVE
              ) <> 0) OR (LEN(:EQ-DATE-LAST-MOVE
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-MOVE
              ), CONVERT(DATE, :EQ-DATE-LAST-MOVE) )               
            ORDER BY  DATE_MOVE DESC                                    
C35227      FOR READ ONLY                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MV_CSR CURSOR FOR                                         
MFA-TR*       SELECT  DATE_MOVE                                                 
MFA-TR*              ,LOC_NO                                                    
MFA-TR*              ,LOCAL_OFFICE                                              
MFA-TR*              ,DATE(MOVE_NO)                                             
MFA-TR*              ,REASON_REMOVED_CD                                         
MFA-TR*              ,LAST_READ_VALUE                                           
MFA-TR*         FROM  CSS_MOVEMENT_HIST                                         
MFA-TR*        WHERE  CODE_UTIL_TYPE = :MV-CODE-UTIL-TYPE                       
MFA-TR*          AND  COMPANY_NO     = :MV-COMPANY-NO                           
MFA-TR*          AND  DEVICE_NO      = :MV-DEVICE-NO                            
MFA-TR*          AND  CODE_CRNT_LOC  = 'J'                                      
MFA-TR*          AND  DATE_MOVE      < :EQ-DATE-LAST-MOVE                       
MFA-TR*     ORDER BY  DATE_MOVE DESC                                            
MFA-TR*     FOR FETCH ONLY WITH UR                                              
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      **************************************                                    
      **  CURSOR DECLARATION -- NEW_MTR   **                                    
      **************************************                                    
           EXEC SQL                                                     
              DECLARE NEW_MTR CURSOR FOR                                
              SELECT  CODE_TEST_TYPE                                    
                FROM  CSS_GAS_MTR_TEST WITH(READUNCOMMITTED)                    
               WHERE  CODE_UTIL_TYPE = :GT-CODE-UTIL-TYPE               
                 AND  METER_NO       = :GT-METER-NO                     
                 AND  COMPANY_NO     = :GT-COMPANY-NO                   
C35227           AND  CODE_TEST_TYPE = 'E'                              
C35227         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE NEW_MTR CURSOR FOR                                        
MFA-TR*       SELECT  CODE_TEST_TYPE                                            
MFA-TR*         FROM  CSS_GAS_MTR_TEST                                          
MFA-TR*        WHERE  CODE_UTIL_TYPE = :GT-CODE-UTIL-TYPE                       
MFA-TR*          AND  METER_NO       = :GT-METER-NO                             
MFA-TR*          AND  COMPANY_NO     = :GT-COMPANY-NO                           
MFA-TR*          AND  CODE_TEST_TYPE = 'E'                                      
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *     ORDER BY  DATE_TEST DESC                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARMIN.                                                      
           05  PARMLENGTH                  PIC S9(4)      COMP.         
           05  PARMDATA.                                                
               10  PARM-COMPANY-NO         PIC X(02).                   
      *                                                                         
       PROCEDURE DIVISION USING PARMIN.                                 
      *                                                                         
      *****************************************************************         
      **    0000-MAIN                                                **         
      *****************************************************************         
      *                                                                         
       0000-MAIN.                                                       
      *                                                                         
           PERFORM 0100-INIT-PROCESS THRU 0100-EXIT.                    
      *                                                                         
           PERFORM 1000-PROCESS-PCSMT101 THRU 1000-EXIT.                
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    0100-INIT-PROCESS                                        **         
      **       OPEN OUTPUT FILES.                                    **         
      *****************************************************************         
       0100-INIT-PROCESS.                                               
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
      *                                                                 00568500
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT        
               MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE               
           END-IF.                                                      
           MOVE WS-INPUT-DATE            TO WS-RUN-DATE.                
      *                                                                 05620000
           IF  PARMLENGTH > 0 AND                                       
                 PARM-COMPANY-NO > SPACES AND LOW-VALUES                
               MOVE PARM-COMPANY-NO      TO EQ-COMPANY-NO               
           ELSE                                                         
               MOVE WS-26                TO EQ-COMPANY-NO               
           END-IF.                                                      
      *                                                                 05620000
           OPEN OUTPUT FCSMT53-FILE.                                    
      *                                                                         
           IF  FMT53-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********************************************'   
               DISPLAY '**     PCSMT101 PROCESSING ERROR          **'   
               DISPLAY '**     OPEN ERROR ON FCSMT53 FILE         **'   
               DISPLAY '**     FMT53 FILE STATUS = ' WS-FMT53-STATUS    
               DISPLAY '**     PROCESSING TERMINATED....          **'   
               DISPLAY '********************************************'   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
           MOVE SPACES                   TO FIOMT53.                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    1000-PROCESS-PCSMT101                                    **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       1000-PROCESS-PCSMT101.                                           
      *                                                                         
           MOVE WS-G                     TO EQ-CODE-UTIL-TYPE.          
           PERFORM 7000-OPEN-METER-CURSOR THRU 7000-EXIT.               
           PERFORM 7100-FETCH-METER-CURSOR THRU 7100-EXIT.              
           PERFORM 1100-FORMAT-FIOMT53 THRU 1100-EXIT                   
                 UNTIL  WS-NO-MORE-DATA EQUAL WS-Y.                     
           PERFORM 7200-CLOSE-METER-CURSOR THRU 7200-EXIT.              
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   1100-FORMAT-FIOMT53                                       **         
      **   FORMAT DATA FOR THE OUTPUT FILE FCSMT53                   **         
      *****************************************************************         
       1100-FORMAT-FIOMT53.                                             
      *                                                                         
           MOVE EQ-COMPANY-NO            TO GM-COMPANY-NO               
                                            GT-COMPANY-NO               
                                            MV-COMPANY-NO               
                                            E-FMT53-COMPANY-NO.         
           MOVE EQ-DEVICE-NO             TO GM-METER-NO                 
                                            GT-METER-NO                 
                                            MV-DEVICE-NO                
                                            E-FMT53-METER-NO.           
           MOVE WS-G                     TO E-FMT53-CODE-UTIL-TYPE      
                                            GM-CODE-UTIL-TYPE           
                                            MV-CODE-UTIL-TYPE           
                                            GT-CODE-UTIL-TYPE.          
           IF  WS-PURCH-YR-NULL = -1                                    
               MOVE SPACES               TO WS-PURCHASE-YEAR-X          
           ELSE                                                         
               MOVE WS-PURCHASE-YEAR     TO WS-PURCHASE-YEAR-N          
           END-IF.                                                      
           IF  WS-DATE-LAST-MOVE-NULL = -1                              
               MOVE SPACES               TO EQ-DATE-LAST-MOVE           
           END-IF.                                                      
           IF  WS-DATE-LAST-TESTED-NULL = -1                            
               MOVE SPACES               TO GM-DATE-LAST-TESTED         
           END-IF.                                                      
      *                                                                         
           MOVE SPACES                   TO WS-DATE-REMOVED.            
           MOVE EQ-SERIAL-NO             TO E-FMT53-SERIAL-NO.          
           MOVE GM-METER-SIZE-ID         TO E-FMT53-METER-TYPE.         
           MOVE WS-PURCHASE-YEAR-X       TO E-FMT53-PURCHASE-YEAR.      
           MOVE GM-DATE-LAST-TESTED      TO E-FMT53-LAST-TEST-DATE.     
      *                                                                         
           PERFORM 7220-OPEN-MV-CURSOR THRU 7220-EXIT.                  
           PERFORM 7240-FETCH-MV-CURSOR THRU 7240-EXIT.                 
           IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               MOVE SPACES               TO MV-LOCAL-OFFICE             
                                            MV-REASON-REMOVED-CD        
                                            WS-DATE-REMOVED             
               MOVE ZEROS                TO MV-LAST-READ-VALUE          
                                            MV-LOC-NO                   
               PERFORM 7280-OPEN-NEW-MTR THRU 7280-EXIT                 
               PERFORM 7285-FETCH-NEW-MTR THRU 7285-EXIT                
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   IF GT-COMPANY-NO = '26'                              
                       MOVE '202' TO MV-LOCAL-OFFICE                    
                       MOVE 'E' TO MV-REASON-REMOVED-CD                 
                   END-IF                                               
               END-IF                                                   
               PERFORM 7290-CLOSE-NEW-MTR THRU 7290-EXIT                
           END-IF.                                                      
      *                                                                         
           PERFORM 7260-CLOSE-MV-CURSOR THRU 7260-EXIT.                 
           MOVE MV-LOCAL-OFFICE          TO E-FMT53-LOCAL-OFFICE.       
      *                                                                         
           EVALUATE MV-REASON-REMOVED-CD                                
               WHEN 'H'                                                 
                  MOVE 'G'               TO E-FMT53-CODE-TEST-TYPE      
               WHEN 'U'                                                 
                  MOVE 'J'               TO E-FMT53-CODE-TEST-TYPE      
               WHEN 'Y'                                                 
                  MOVE 'D'               TO E-FMT53-CODE-TEST-TYPE      
               WHEN '1'                                                 
                  MOVE 'Z'               TO E-FMT53-CODE-TEST-TYPE      
               WHEN '2'                                                 
                  MOVE 'W'               TO E-FMT53-CODE-TEST-TYPE      
               WHEN '3'                                                 
                  MOVE 'B'               TO E-FMT53-CODE-TEST-TYPE      
               WHEN '4'                                                 
                  MOVE 'C'               TO E-FMT53-CODE-TEST-TYPE      
               WHEN '5'                                                 
                  MOVE 'O'               TO E-FMT53-CODE-TEST-TYPE      
               WHEN 'I'                                                 
                  MOVE 'N'               TO E-FMT53-CODE-TEST-TYPE      
               WHEN 'Q'                                                 
                  MOVE 'Q'               TO E-FMT53-CODE-TEST-TYPE      
               WHEN 'T'                                                 
                  MOVE 'T'               TO E-FMT53-CODE-TEST-TYPE      
               WHEN 'J'                                                 
                  MOVE 'Y'               TO E-FMT53-CODE-TEST-TYPE      
               WHEN 'V'                                                 
                  MOVE 'V'               TO E-FMT53-CODE-TEST-TYPE      
               WHEN 'G'                                                 
                  MOVE 'K'               TO E-FMT53-CODE-TEST-TYPE      
               WHEN 'F'                                                 
                  MOVE '1'               TO E-FMT53-CODE-TEST-TYPE      
               WHEN '0'                                                 
                  MOVE '2'               TO E-FMT53-CODE-TEST-TYPE      
               WHEN 'E'                                                 
                  MOVE 'E'               TO E-FMT53-CODE-TEST-TYPE      
               WHEN OTHER                                               
                  MOVE 'J'               TO E-FMT53-CODE-TEST-TYPE      
           END-EVALUATE.                                                
           MOVE MV-LAST-READ-VALUE       TO WS-LAST-READ-VALUE.         
           MOVE WS-LAST-READ-VALUE       TO E-FMT53-LAST-READ-VALUE.    
           MOVE WS-DATE-REMOVED          TO E-FMT53-DATE-REMOVED.       
      *                                                                         
           PERFORM 7300-GET-TIMES-TESTED THRU 7300-EXIT.                
           IF  WS-TIMES-TESTED-NULL = -1                                
               MOVE ZERO                 TO WS-TIMES-TESTED             
           END-IF.                                                      
      *                                                                         
           MOVE WS-TIMES-TESTED          TO WS-TIMES-TESTED-N.          
           MOVE WS-TIMES-TESTED-N        TO E-FMT53-TIMES-TESTED.       
      *                                                                         
           MOVE MV-LOC-NO                TO E-FMT53-FROM-LOC-NO.        
      *                                                                         
           PERFORM 8000-WRITE-FIOMT53 THRU 8000-EXIT.                   
      *                                                                         
           PERFORM 7100-FETCH-METER-CURSOR THRU 7100-EXIT.              
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ********************************************************                  
      * JOB_PARM INCLUDES FOR DATE ACCESS                                       
      ********************************************************                  
       COPY CPD00037.                                                   13580000
       COPY CPD00040.                                                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **    7000-OPEN-METER-CURSOR                                   **         
      **        THE DRIVING CURSOR IS OPENED.                        **         
      *****************************************************************         
       7000-OPEN-METER-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
               OPEN MAIN_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSMT101 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7000       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7100-FETCH-METER-CURSOR                                  **         
      **        THE NEXT RECORD MATCHING THE CRITERIA IS RETRIEVED.  **         
      *****************************************************************         
       7100-FETCH-METER-CURSOR.                                         
      *                                                                         
           EXEC SQL                                                     
              FETCH  MAIN_CSR                                           
               INTO  :EQ-DEVICE-NO                                      
                    ,:EQ-SERIAL-NO                                      
                    ,:GM-METER-SIZE-ID                                  
                    ,:WS-PURCHASE-YEAR :WS-PURCH-YR-NULL                 
                    ,:EQ-DATE-LAST-MOVE :WS-DATE-LAST-MOVE-NULL          
                    ,:GM-DATE-LAST-TESTED :WS-DATE-LAST-TESTED-NULL      
                    ,:EQ-LOCAL-OFFICE                                   
A04527              ,:EQ-COMPANY-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   MOVE WS-Y               TO WS-NO-MORE-DATA           
               ELSE                                                     
                   DISPLAY '****************************************'   
                   DISPLAY '**     PCSMT101 PROCESSING ERROR      **'   
                   DISPLAY '**      ABEND IN PARAGRAPH 7100       **'   
                   DISPLAY '**     COMPANY NO = ' EQ-COMPANY-NO         
                   DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE 
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7200-CLOSE-METER-CURSOR                                  **         
      **        THE DRIVING CURSOR IS CLOSED.                        **         
      *****************************************************************         
       7200-CLOSE-METER-CURSOR.                                         
      *                                                                         
           EXEC SQL                                                     
               CLOSE  MAIN_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSMT101 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7200       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7220-OPEN-MV-CURSOR                                      **         
      **   OPEN CURSOR TO GET MOVEMENT DETAILS                       **         
      *****************************************************************         
       7220-OPEN-MV-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN MV_CSR                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSMT101 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7220       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7240-FETCH-MV-CURSOR                                     **         
      **  FETCH CURSOR TO GET MOVEMENT DETAILS                       **         
      *****************************************************************         
       7240-FETCH-MV-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
              FETCH  MV_CSR                                             
               INTO :MV-DATE-MOVE                                       
                   ,:MV-LOC-NO                                          
                   ,:MV-LOCAL-OFFICE                                    
                   ,:WS-DATE-REMOVED                                    
                   ,:MV-REASON-REMOVED-CD                               
                   ,:MV-LAST-READ-VALUE                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSMT101 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7240       **'       
               DISPLAY '**   COMPANY NO = ' MV-COMPANY-NO               
               DISPLAY '**     METER NO = ' MV-DEVICE-NO                
               DISPLAY '** DT-LAST-MOVE = ' EQ-DATE-LAST-MOVE           
               DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7260-CLOSE-MV-CURSOR                                     **         
      **  CLOSE CURSOR TO GET MOVEMENT DETAILS                       **         
      *****************************************************************         
       7260-CLOSE-MV-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE  MV_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSMT101 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7260       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7280-OPEN-NEW-MTR                                        **         
      **   OPEN CURSOR TO GET METER TEST DETAILS                     **         
      *****************************************************************         
       7280-OPEN-NEW-MTR.                                               
      *                                                                         
           EXEC SQL                                                     
               OPEN NEW_MTR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSMT101 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7280-OPEN  **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7280-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7285-FETCH-NEW-MTR                                       **         
      **  FETCH CURSOR TO GET METER TEST DETAILS                     **         
      *****************************************************************         
       7285-FETCH-NEW-MTR.                                              
      *                                                                         
           EXEC SQL                                                     
              FETCH  NEW_MTR                                            
               INTO :GT-CODE-TEST-TYPE                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSMT101 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7285-FETCH **'       
               DISPLAY '**   COMPANY NO = ' GT-COMPANY-NO               
               DISPLAY '**     METER NO = ' GT-METER-NO                 
               DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7285-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7290-CLOSE-NEW-MTR                                       **         
      **  CLOSE CURSOR TO GET METER TEST DETAILS                     **         
      *****************************************************************         
       7290-CLOSE-NEW-MTR.                                              
      *                                                                         
           EXEC SQL                                                     
               CLOSE  NEW_MTR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSMT101 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7290-CLOSE **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7290-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7300-GET-TIMES-TESTED                                    **         
      *****************************************************************         
       7300-GET-TIMES-TESTED.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT  COUNT(*)                                        
                  INTO :WS-TIMES-TESTED :WS-TIMES-TESTED-NULL            
                  FROM  CSS_GAS_MTR_TEST WITH(READUNCOMMITTED)                  
                 WHERE  COMPANY_NO     = :GT-COMPANY-NO                 
                   AND  CODE_UTIL_TYPE = :GT-CODE-UTIL-TYPE             
                   AND  METER_NO       = :GT-METER-NO                   
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  COUNT(*)                                                
MFA-TR*           INTO :WS-TIMES-TESTED:WS-TIMES-TESTED-NULL                    
MFA-TR*           FROM  CSS_GAS_MTR_TEST                                        
MFA-TR*          WHERE  COMPANY_NO     = :GT-COMPANY-NO                         
MFA-TR*            AND  CODE_UTIL_TYPE = :GT-CODE-UTIL-TYPE                     
MFA-TR*            AND  METER_NO       = :GT-METER-NO                           
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSMT101 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7300       **'       
               DISPLAY '**  COMPANY NO = ' GT-COMPANY-NO                
               DISPLAY '**    METER NO = ' GT-METER-NO                  
               DISPLAY '**     SQLCODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** WRITE INTO THE FILE FCSMT53                                 **         
      *****************************************************************         
       8000-WRITE-FIOMT53.                                              
      *                                                                         
           WRITE FIOMT53.                                               
      *                                                                         
           IF  FMT53-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '**     PCSMT101 PROCESSING ERROR         **'    
               DISPLAY '**     ABEND IN PARAGRAPH 8000           **'    
               DISPLAY '**     ERROR ON FCSMT53  WRITE           **'    
               DISPLAY '**     STATUS IS ' WS-FMT53-STATUS              
               DISPLAY '**     PROCESSING TERMINATED....         **'    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
           MOVE SPACES                   TO FIOMT53.                    
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    9000-TERMINATE                                           **         
      *****************************************************************         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSMT53-FILE.                                          
      *                                                                         
           IF  FMT53-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********************************************'   
               DISPLAY '**     PCSMT101 PROCESSING ERROR          **'   
               DISPLAY '**     CLOSE ERROR ON FCSMT53 FILE        **'   
               DISPLAY '**     FMT53 FILE STATUS = ' WS-FMT53-STATUS    
               DISPLAY '********************************************'   
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      *     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE          *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
