       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSLM100.                                            
       DATE-WRITTEN. JAN-2015.                                          
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *                                                               *         
      *****************************************************************         
      *                 P R O G R A M  S U M M A R Y                  *         
      *                                                               *         
      * THIS PROGRAM PROCESS DAILY TRANSACTIONS FROM LMS HAND HELD    *         
      * TRANSACTION TABLE AND CREATE LIGHTING ENVIRONMENT FOR APPROVAL*         
      *                                                               *         
      *****************************************************************         
      *                     PROGRAM MODIFICATION LOG                  *         
      *                                                               *         
      *    DATE    INITIALS   COMMENTS                                *         
      *  --------  --------   --------------------------------------- *         
      *  04/01/15  LIGHTING   INITIAL VERSION.                        *         
A05084*  04/30/15  LIGHTING   CREATE TASK TO NOTIFY USER TO CLOSE     *         
A05084*                       WHEN HANDHELD DATA WAITING IN QUEUE.    *         
A05084*  05/12/15  LIGHTING   ASSIGN TASK TO 002 LOCAL OFFICE WHEN    *         
A05084*                       INVALID ACCOUNT AND LOCAL OFFICE NOT    *         
A05084*                       PROVIDED WITH WMS ORDER.                *         
A05084*  05/27/15  LIGHTING   REMOVE TASKS WITH 'CONVERTED SCEG TAG'  *         
A05084*                       COMMENTS. CREATE TASK IMMIDIATLY WHEN   *         
A05084*                       WMS ORDER MATCH WITH HH WITH SOME       *         
A05084*                       EXCEPTIONS.                             *         
A05136*  11/11/15  DB41297    ADD NODE TAG COMMENTS TO WQ.            *         
ACT076*  07/27/16  EM19682    NO HANDHELD DATA TASK SET CHANGED FROM  *         
ACT076*                       5 DAYS TO 2 DAYS.                       *         
ACT081*  07/28/16  DB41297    TRIM COMMENTS TO NOT EXCEED 250.        *         
      *                                                               *         
      *****************************************************************         
      *****************************************************************         
      *                                                               *         
      *                ---- BASIC SEQUENCE STRUCTURE ----             *         
      *                                                               *         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION            *         
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                   *         
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                  *         
      *  3000 - 4999  NOT USED                                        *         
      *  5000 - 5999  COMMON PROGRAM MODULES                          *         
      *  6000 - 6999  COMMON SYSTEM MODULES                           *         
      *  7000 - 7999  INPUT MODULES                                   *         
      *  8000 - 8999  OUTPUT MODULES                                  *         
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES            *         
      *                                                               *         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-SCAN-NOM-CRSR  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-REQ-DTL-CRSR  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-SCAN-DTL-CRSR  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSLM100'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)  VALUE               
           'WORKING STORAGE FOR PCSLM100 STARTS HERE'.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-PGM-NAME               PIC X(08)   VALUE 'PCSLM100'.  
           05  WS-PGRMNAME               PIC X(08)   VALUE 'PCSLM100'.  
           05  PROGRAM-NAME              PIC X(08)   VALUE 'PCSLM100'.  
           05  WS-DISPLAY-SQLCODE        PIC ---9.                      
           05  WS-RUN-DATE               PIC X(10).                     
ACT076     05  WS-RUN-DATE-1DAY          PIC X(10).                     
A05084     05  WS-RUN-DATE-3DAYS         PIC X(10).                     
           05  WS-RUN-DATE-4DAYS         PIC X(10).                     
A05084     05  WS-RUN-DATE-9DAYS         PIC X(10).                     
A05084     05  WS-DAYS-INDX              PIC 9(02).                     
           05  SCSCB077                  PIC X(08)  VALUE 'SCSCB077'.   
           05  SCSCA822                  PIC X(08)  VALUE 'SCSCA822'.   
           05  WS-YES                    PIC X(01)  VALUE 'Y'.          
           05  WS-NO                     PIC X(01)  VALUE 'N'.          
           05  WS-Y                      PIC X(01)  VALUE 'Y'.          
           05  WS-N                      PIC X(01)  VALUE 'N'.          
           05  WS-LOCAL-ACTION           PIC X(01)  VALUE ' '.          
                                                                        
       01 WS-TO-REMOVE-LEADING-ZEROS.                                   
          05 WS-IN-SUB                   PIC 9(4) VALUE ZERO.           
          05 WS-OUT-SUB                  PIC 9(4) VALUE ZERO.           
          05 WS-IN-STRING.                                              
             10 WS-IN-CHAR               PIC X(1) OCCURS 12 TIMES.      
          05 WS-OUT-STRING.                                             
             10 WS-OUT-CHAR               PIC X(1) OCCURS 12 TIMES.     
          05 WS-LAST-CHAR-SW             PIC 9(1)   VALUE 0.            
             88 LAST-CHAR-ZERO            VALUE 0.                      
             88 LAST-CHAR-NON-ZERO        VALUE 1.                      
          05 WS-CHAR-LENGTH              PIC S9(03) VALUE ZERO.         
       01 WS-TASK-DATA-FIELDS.                                          
          05 WS-TASK-ORDER-NO            PIC Z(8)9(5)  VALUE ZERO.      
          05 WS-TASK-POINT-NO            PIC ZZZ9.99   VALUE ZERO.      
          05 WS-TASK-ORDER-SRC           PIC X(03)     VALUE SPACES.    
          05 WS-TASK-FXTR-TAG-NO         PIC X(12)     VALUE SPACES.    
          05 WS-TASK-FXTR-TAG-OLD        PIC X(12)     VALUE SPACES.    
          05 WS-TASK-FXTR-SEQ-NO         PIC 9(10)     VALUE ZERO.      
          05 WS-TASK-FXTR-SEQ-OLD        PIC 9(10)     VALUE ZERO.      
          05 WS-TASK-POLE-TAG-NO         PIC X(12)     VALUE SPACES.    
          05 WS-TASK-POLE-TAG-OLD        PIC X(12)     VALUE SPACES.    
          05 WS-TASK-POLE-STOCK          PIC X(15)     VALUE SPACES.    
          05 WS-TASK-WMS-RATE            PIC X(08)     VALUE SPACES.    
          05 WS-TASK-WMS-RATE-ITEM       PIC ZZZ99     VALUE ZERO.      
          05 WS-TASK-LMS-RATE            PIC X(08)     VALUE SPACES.    
          05 WS-TASK-LMS-RATE-ITEM       PIC ZZZ99     VALUE ZERO.      
          05 WS-TASK-WORK-FLOW           PIC X(10)     VALUE SPACES.    
          05 WS-TASK-MISMATCH-DESC       PIC X(25)     VALUE SPACES.    
       01 WS-TASK-COMMENTS-DATA.                                        
          05 WS-ERROR-ORDER-DETAILS.                                    
              10 FILLER                  PIC X(07)     VALUE            
              'ORDER: '.                                                
              10 WS-ERROR-ORDER-NO       PIC 9(13)     VALUE ZERO.      
              10 FILLER                  PIC X(09)     VALUE            
              ' SOURCE: '.                                              
              10 WS-ERROR-SOURCE         PIC X(03)     VALUE SPACES.    
              10 FILLER                  PIC X(08)     VALUE            
              ' POINT: '.                                               
              10 WS-ERROR-POINT-NO       PIC ZZZ9.99   VALUE ZERO.      
          05 WS-FXR-NOT-IN-INVENTORY.                                   
              10 FILLER                  PIC X(28)     VALUE            
              'ORDER NOT PROCESSED: FIXTURE'.                           
              10 WS-ERROR-FXR-NO         PIC X(12)     VALUE SPACES.    
              10 FILLER                  PIC X(17)     VALUE            
              ' NOT IN INVENTORY'.                                      
       01 WS-TEMP-VARIABLES.                                            
          05 RS-RETURN-CODE              PIC S9(9) COMP VALUE 0.        
          05 WS-ROUTING-CATEGORY         PIC X(01)   VALUE '1'.         
          05 WS-LOCAL-OFFICE             PIC X(03)  VALUE SPACES.       
          05 WS-CATEGORY-ID              PIC S9(04) COMP VALUE 0.       
          05 WS-HH-REQ-COUNT             PIC S9(04) COMP VALUE ZERO.    
          05 WS-REQ-DTL-COUNT            PIC S9(04) COMP VALUE ZERO.    
          05 WS-STOCK-EXITS              PIC S9(04) COMP VALUE ZERO.    
             88 NO-STOCK-CODE             VALUE 0.                      
             88 VALID-STOCK-CODE          VALUE 1.                      
             88 NOT-VALID-STOCK-CODE      VALUE 2.                      
          05 WS-REQ-MATCH-SW             PIC X(01) VALUE SPACES.        
             88 UNMATCH-REQ-FOUND         VALUE 'Y'.                    
             88 ALL-REQ-MATCHED           VALUE ' '.                    
          05 WS-WQ-CREATED-SW            PIC 9(01) VALUE ZERO.          
             88 NO-TASK-CREATED           VALUE 0.                      
             88 TASK-CREATED              VALUE 1.                      
          05 WS-SINGLE-POINT-ORD-SW      PIC 9(01) VALUE ZERO.          
             88 SINGLE-POINT-ORDER        VALUE 0.                      
             88 MULTI-POINT-ORDER         VALUE 1.                      
          05 WS-METERS-LIGHTS-SW         PIC S9(04) COMP VALUE ZERO.    
             88 NO-MORE-METERS            VALUE 0.                      
             88 NO-MORE-LIGHTS            VALUE 0.                      
             88 METERS-LIGHTS-EXISTS      VALUE 1.                      
          05 WS-WORK-TYPE-SW             PIC X(03) VALUE SPACES.        
             88 WORK-TYPE-RPLC-SAME       VALUE 'LXL'.                  
             88 WORK-TYPE-RPLC-DIFF       VALUE 'LLD'.                  
             88 WORK-TYPE-REPLACE         VALUE 'LLD', 'LXL'.           
             88 WORK-TYPE-REPAIR          VALUE 'LRL'.                  
          05 WS-ATTACH-EQUIP-SEQ         PIC S9(10)V COMP-3 VALUE ZERO. 
          05 WS-REQ-ACTION-CD            PIC X(01) VALUE SPACES.        
          05 WS-REQ-ACTION-CD1           PIC X(01) VALUE SPACES.        
          05 WS-REQ-ACTION-CD2           PIC X(01) VALUE SPACES.        
          05 WS-CURRENT-DATE             PIC X(10) VALUE SPACES.        
          05 WS-CUR-FXR-ONLY-MCH         PIC 9(05) VALUE ZERO.          
          05 WS-OLD-FXR-ONLY-MCH         PIC 9(05) VALUE ZERO.          
          05 WS-CUR-FXR-POL-TAG-MCH      PIC 9(05) VALUE ZERO.          
          05 WS-OLD-FXR-POL-TAG-MCH      PIC 9(05) VALUE ZERO.          
          05 WS-CUR-POL-TAG-MCH          PIC 9(05) VALUE ZERO.          
          05 WS-OLD-POL-TAG-MCH          PIC 9(05) VALUE ZERO.          
          05 WS-WMS-POINT-NO             PIC S9(3)V9(2) COMP-3 VALUE 0. 
          05 WS-WMS-POINT-NO1            PIC S9(3)V9(2) COMP-3 VALUE 0. 
          05 WS-WMS-POINT-NO2            PIC S9(3)V9(2) COMP-3 VALUE 0. 
          05 WS-WMS-POINT-NO3            PIC S9(3)V9(2) COMP-3 VALUE 0. 
          05 WS-WMS-POINT-NO-OLD         PIC S9(3)V9(2) COMP-3 VALUE 0. 
          05 WS-MATCHED-POLE-TAG-NO      PIC X(12) VALUE SPACES.        
          05 WS-PREMISE-NO-NUM           PIC 9(10)      VALUE ZERO.     
          05 WS-EQUIP-INSTALL-DT-IND     PIC S9(04) COMP VALUE ZERO.    
          05 WS-APPROVED-TS-IND          PIC S9(04) COMP VALUE ZERO.    
          05 WS-EQUIP-MFR-DT-IND         PIC S9(04) COMP VALUE ZERO.    
          05 WS-WARRANTY-EXP-DT-IND      PIC S9(04) COMP VALUE ZERO.    
          05 WS-EQUIP-DISPOSAL-DT-IND    PIC S9(04) COMP VALUE ZERO.    
       01 WS-SCN-DATA-TABLE.                                            
          05 WS-SCN-ROW-COUNT          PIC 9(05) VALUE ZERO.            
          05 WS-SCN-SUB                PIC 9(05) VALUE ZERO.            
          05 WS-SCN-SUB1               PIC 9(05) VALUE ZERO.            
          05 WS-SCN-TABLE.                                              
             10 SCN-TRANS-SEQ-NO        OCCURS 500 TIMES PIC X(26).     
             10 SCN-TRANS-DATE          OCCURS 500 TIMES PIC X(10).     
             10 SCN-TRANS-TIME          OCCURS 500 TIMES PIC X(08).     
             10 SCN-WORK-FLOW-TYPE-CD   OCCURS 500 TIMES PIC X(01).     
COB305       10 SCN-ACCOUNT-NO        PIC S9(13)V OCCURS 500 TIMES 
COB305          COMP-3 VALUE 0.     
COB305       10 SCN-WMS-POINT-CUR        PIC S9(3)V9(2) 
COB305          OCCURS 500 TIMES COMP-3 VALUE 0.  
COB305       10 SCN-WMS-POINT-OLD        PIC S9(3)V9(2) 
COB305          OCCURS 500 TIMES COMP-3 VALUE 0.  
             10 SCN-REQUEST-ACTION-TS    OCCURS 500 TIMES PIC X(26).    
             10 SCN-FXTR-TAG-NO-OLD     OCCURS 500 TIMES PIC X(12).     
COB305       10 SCN-FXTR-SEQ-NO-OLD        PIC S9(10)V OCCURS 500 TIMES 
COB305          COMP-3 VALUE 0.     
             10 SCN-FXTR-STOCK-OLD      OCCURS 500 TIMES PIC X(15).     
             10 SCN-FXTR-INV-ST-OLD     OCCURS 500 TIMES PIC X(01).     
             10 SCN-FXTR-WMS-ST-OLD     OCCURS 500 TIMES PIC X(01).     
COB305       10 SCN-FXTR-WRNTY-AMT-OLD        PIC S9(5)V9(2) 
COB305          OCCURS 500 TIMES COMP-3 VALUE 0.     
             10 SCN-FXTR-INS-LOC-NO-OLD OCCURS 500 TIMES PIC X(10).     
COB305       10 SCN-FXTR-INS-POINT-NO-OLD        PIC S9(5)V 
COB305          OCCURS 500 TIMES COMP-3 VALUE 0.         
             10 SCN-FXTR-BILLING-FL-OLD OCCURS 500 TIMES PIC X(01).     
             10 SCN-FXTR-CONTRACT-FL-OLD OCCURS 500 TIMES PIC X(01).    
             10 SCN-FXTR-UTIL-TYPE-OLD  OCCURS 500 TIMES PIC X(01).     
             10 SCN-FXTR-RATE-PLAN-OLD  OCCURS 500 TIMES PIC X(03).     
             10 SCN-FXTR-RATE-ITEM-OLD  OCCURS 500 TIMES                
                                             PIC S9(4) COMP.            
             10 SCN-FXTR-TAG-NO-CUR     OCCURS 500 TIMES PIC X(12).     
COB305       10 SCN-FXTR-SEQ-NO-CUR        PIC S9(10)V OCCURS 500 TIMES 
COB305          COMP-3 VALUE 0.     
             10 SCN-FXTR-STOCK-CUR      OCCURS 500 TIMES PIC X(15).     
             10 SCN-FXTR-INV-ST-CUR     OCCURS 500 TIMES PIC X(01).     
             10 SCN-FXTR-WMS-ST-CUR     OCCURS 500 TIMES PIC X(01).     
COB305       10 SCN-FXTR-WRNTY-AMT-CUR        PIC S9(5)V9(2) 
COB305          OCCURS 500 TIMES COMP-3 VALUE 0.     
             10 SCN-FXTR-INS-LOC-NO-CUR OCCURS 500 TIMES PIC X(10).     
COB305       10 SCN-FXTR-INS-POINT-NO-CUR        PIC S9(5)V 
COB305          OCCURS 500 TIMES COMP-3 VALUE 0.         
             10 SCN-FXTR-BILLING-FL-CUR OCCURS 500 TIMES PIC X(01).     
             10 SCN-FXTR-CONTRACT-FL-CUR OCCURS 500 TIMES PIC X(01).    
             10 SCN-FXTR-UTIL-TYPE-CUR  OCCURS 500 TIMES PIC X(01).     
             10 SCN-FXTR-RATE-PLAN-CUR OCCURS 500 TIMES PIC X(03).      
             10 SCN-FXTR-RATE-ITEM-CUR OCCURS 500 TIMES                 
                                             PIC S9(4) COMP.            
             10 SCN-POLE-TAG-NO-OLD     OCCURS 500 TIMES PIC X(12).     
             10 SCN-REQ-POLE-NO-OLD     OCCURS 500 TIMES PIC X(12).     
COB305       10 SCN-POLE-SEQ-NO-OLD        PIC S9(10)V OCCURS 500 TIMES 
COB305          COMP-3 VALUE 0.     
             10 SCN-POLE-STOCK-OLD      OCCURS 500 TIMES PIC X(15).     
             10 SCN-POLE-INV-ST-OLD     OCCURS 500 TIMES PIC X(01).     
             10 SCN-POLE-WMS-ST-OLD     OCCURS 500 TIMES PIC X(01).     
COB305       10 SCN-POLE-WRNTY-AMT-OLD        PIC S9(5)V9(2) 
COB305          OCCURS 500 TIMES COMP-3 VALUE 0.     
             10 SCN-POLE-INS-LOC-NO-OLD OCCURS 500 TIMES PIC X(10).     
COB305       10 SCN-POLE-INS-POINT-NO-OLD        PIC S9(5)V 
COB305          OCCURS 500 TIMES COMP-3 VALUE 0.         
             10 SCN-POLE-BILLING-FL-OLD OCCURS 500 TIMES PIC X(01).     
             10 SCN-POLE-UTIL-TYPE-OLD  OCCURS 500 TIMES PIC X(01).     
             10 SCN-POLE-RATE-PLAN-OLD  OCCURS 500 TIMES PIC X(03).     
             10 SCN-POLE-RATE-ITEM-OLD  OCCURS 500 TIMES                
                                             PIC S9(4) COMP.            
             10 SCN-POLE-TAG-NO-CUR     OCCURS 500 TIMES PIC X(12).     
             10 SCN-REQ-POLE-NO-CUR     OCCURS 500 TIMES PIC X(12).     
COB305       10 SCN-POLE-SEQ-NO-CUR        PIC S9(10)V OCCURS 500 TIMES 
COB305          COMP-3 VALUE 0.     
             10 SCN-POLE-STOCK-CUR      OCCURS 500 TIMES PIC X(15).     
             10 SCN-POLE-INV-ST-CUR     OCCURS 500 TIMES PIC X(01).     
             10 SCN-POLE-WMS-ST-CUR     OCCURS 500 TIMES PIC X(01).     
COB305       10 SCN-POLE-WRNTY-AMT-CUR        PIC S9(5)V9(2) 
COB305          OCCURS 500 TIMES COMP-3 VALUE 0.     
             10 SCN-POLE-INS-LOC-NO-CUR OCCURS 500 TIMES PIC X(10).     
COB305       10 SCN-POLE-INS-POINT-NO-CUR        PIC S9(5)V 
COB305          OCCURS 500 TIMES COMP-3 VALUE 0.         
             10 SCN-POLE-BILLING-FL-CUR OCCURS 500 TIMES PIC X(01).     
             10 SCN-POLE-UTIL-TYPE-CUR  OCCURS 500 TIMES PIC X(01).     
             10 SCN-POLE-RATE-PLAN-CUR OCCURS 500 TIMES PIC X(03).      
             10 SCN-POLE-RATE-ITEM-CUR OCCURS 500 TIMES                 
                                             PIC S9(4) COMP.            
             10 SCN-NODE-TAG-NO-OLD     OCCURS 500 TIMES PIC X(12).     
             10 SCN-NODE-TAG-NO-CUR     OCCURS 500 TIMES PIC X(12).     
COB305       10 SCN-NODE-SEQ-NO-CUR        PIC S9(10)V OCCURS 500 TIMES 
COB305          COMP-3 VALUE 0.     
COB305       10 SCN-FXTR-GPS-LATITUDE        PIC S9(3)V9(6) 
COB305          OCCURS 500 TIMES COMP-3 VALUE 0.     
COB305       10 SCN-FXTR-GPS-LONGITUDE        PIC S9(3)V9(6) 
COB305          OCCURS 500 TIMES COMP-3 VALUE 0.     
             10 SCN-TRANS-USERID        OCCURS 500 TIMES PIC X(07).     
             10 SCN-SOURCE-APPL-CD      OCCURS 500 TIMES PIC X(03).     
COB305       10 SCN-SOURCE-APPL-REQ-NO        PIC S9(13)V 
COB305          OCCURS 500 TIMES COMP-3 VALUE 0.        
             10 SCN-TRANS_STATUS_CD     OCCURS 500 TIMES PIC X(01).     
             10 SCN-LOCAL-OFFICE        OCCURS 500 TIMES PIC X(03).     
             10 SCN-MISMATCH-TYPE       OCCURS 500 TIMES PIC X(02).     
             10 SCN-LOCAL-ACTION        OCCURS 500 TIMES PIC X(01).     
      *                                                                         
       01 WS-REQ-DATA-TABLE.                                            
          05 WS-REQ-ROW-COUNT          PIC 9(05) VALUE ZERO.            
          05 WS-REQ-SUB                PIC 9(05) VALUE ZERO.            
          05 WS-REQ-SUB1               PIC 9(05) VALUE ZERO.            
          05 WS-REQ-TABLE.                                              
             10 REQ-TRANS-SEQ-NO         OCCURS 500 TIMES PIC X(26).    
             10 REQ-SOURCE-APPL-CD       OCCURS 500 TIMES PIC X(03).    
COB305       10 REQ-SOURCE-APPL-REQ-NO        PIC S9(13)V 
COB305          OCCURS 500 TIMES COMP-3 VALUE 0.    
COB305       10 REQ-WMS-POINT-NO        PIC S9(3)V9(2) OCCURS 500 TIMES 
COB305          COMP-3 VALUE 0.    
             10 REQ-ORDER-TYPE-CD        OCCURS 500 TIMES PIC X(05).    
             10 REQ-WORK-TYPE-CD         OCCURS 500 TIMES PIC X(03).    
             10 REQ-RECORD-TYPE-CD       OCCURS 500 TIMES PIC X(01).    
             10 REQ-STOCK-CD             OCCURS 500 TIMES PIC X(15).    
             10 REQ-RATE-PLAN-NO         OCCURS 500 TIMES PIC X(03).    
             10 REQ-RATE-ITEM-CODE       OCCURS 500 TIMES               
                                                     PIC S9(4) COMP.    
             10 REQ-POLE-TAG-NO          OCCURS 500 TIMES PIC X(12).    
             10 REQ-REQUEST-ACTION-TS    OCCURS 500 TIMES PIC X(26).    
             10 REQ-REQUEST-ACTION-CD    OCCURS 500 TIMES PIC X(01).    
             10 REQ-EQUIP-QTY            OCCURS 500 TIMES               
                                                     PIC S9(4) COMP.    
COB305       10 REQ-ACCOUNT-NO        PIC S9(13)V OCCURS 500 TIMES 
COB305          COMP-3 VALUE 0.    
             10 REQ-REQUEST-STATUS-CD    OCCURS 500 TIMES PIC X(01).    
             10 REQ-LOCAL-OFFICE         OCCURS 500 TIMES PIC X(03).    
             10 REQ-LOCAL-ACTION         OCCURS 500 TIMES PIC X(01).    
      *                                                                         
      *****************************************************************         
      * SQL COMMUNICATION AREA                                        *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_ACCOUNT        (AT)                                       *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_UTIL_ENVRNMT   (UT)                                       *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBUTLENV                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_CONTRACT       (CT)                                       *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCNTRCT                                                
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      *****************************************************************         
      * LMS_HANDHELD_TRANS (4N)                                       *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHNDTRN                                                
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      *****************************************************************         
      * LMS_REQUEST_DETAIL (4O)                                       *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBREQDET                                                
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      *****************************************************************         
      * LMS_EQUIP_INVENTRY 4D                                         *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBEQPINV                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * LMS_MSTR_STCK_INFO 4A                                         *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBMSTINF                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * LMS_EQUIP_ENVRNMT  4F                                         *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBEQPIVT                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * LMS_FXTR_ATTACHMTS 4H                                         *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBFXTATC                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * LMS_TRANS_HIST    4J                                          *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBLGTHST                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * LMS_TRANS_HIST_DET  4S                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBLMSHST                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * LMS_EQUIP_CONTRACT  4L                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBEQPCNT                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * LMS_TERM_CHRG_CALC  4K                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBTRMCLC                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_DELINQUENCY   C8                                          *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBDELQ                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_WQ_ITEMS       WQ                                         *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBWQITS                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_RATE_PLAN_DESC    RD                                      *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_MTRD_ENVRNMT      MN                                      *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_CUST_PLAN         CP                                      *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_UNMTR_PLAN        UP                                      *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBUMPLAN                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_RATE_CREATOR      RT                                      *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_HOLIDAY   J8                                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBHLDAY                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_JOB_PARM  G6                                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_MNT_TRANS_HIST  MH                                        *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_MT_TRN_HST_DET  MI                                        *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * WORKING STORAGE COPYBOOK FOR SCSCB077                         *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE CWS00077                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * WORKING STORAGE COPY BOOK FOR CPDLM001                                  
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CWSLM001                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * WORKING STORAGE COPY BOOK FOR CPDLM003                                  
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CWSLM003                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * WORKING STORAGE COPY BOOK FOR CPD00099                                  
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CWS00099                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * WORKING STORAGE COPYBOOK TO GET THE NEXT BUSINESS DAY         *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE CWS00315                                                 
           END-EXEC.                                                            
      *                                                                         
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
       COPY CWS00010.                                                           
      *                                                                         
       COPY CWS00038.                                                           
       COPY CWS00039.                                                           
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      * INPUT FILE TO SET-UP NEW CONTRACT USING CPD04822 COPYBOOK.              
       COPY CWS04822.                                                           
      *                                                                         
      *****************************************************************         
      * CURSOR DECLARATION FOR LMS_HANDHELD_TRANS                     *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE MAIN_CRSR CURSOR WITH HOLD FOR                    
               SELECT SOURCE_APPL_REQ_NO                                
                     ,SOURCE_APPL_CD                                    
                 FROM LMS_REQUEST_DETAIL WITH(READUNCOMMITTED)                  
                WHERE REQUEST_STATUS_CD = ' '                           
                GROUP BY SOURCE_APPL_REQ_NO                             
                        ,SOURCE_APPL_CD                                 
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MAIN_CRSR CURSOR WITH HOLD FOR                            
MFA-TR*        SELECT SOURCE_APPL_REQ_NO                                        
MFA-TR*              ,SOURCE_APPL_CD                                            
MFA-TR*          FROM LMS_REQUEST_DETAIL                                        
MFA-TR*         WHERE REQUEST_STATUS_CD = ' '                                   
MFA-TR*         GROUP BY SOURCE_APPL_REQ_NO                                     
MFA-TR*                 ,SOURCE_APPL_CD                                         
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *                                                                         
      *****************************************************************         
      * CURSOR DECLARATION FOR LMS_HANDHELD_TRANS                     *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE SCAN_DTL_CRSR CURSOR WITH ROWSET POSITIONING FOR  
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           [4N].TRANS_SEQ_NO, 121), ' ', '-'), ':', '.') TRANS_SEQ_NO          
                     ,[4N].TRANS_DATE                                     
                     ,REPLACE(CONVERT(CHAR(8), [4N].TRANS_TIME, 108), 
           ':', '.') TRANS_TIME                                     
                     ,[4N].WORK_FLOW_TYPE_CD                              
                     ,[4N].FXTR_TAG_NO_OLD                                
                     ,[4N].FXTR_TAG_NO_CURR                               
                     ,[4N].POLE_TAG_NO_OLD                                
                     ,[4N].POLE_TAG_NO_CURR                               
                     ,[4N].NODE_TAG_NO_OLD                                
                     ,[4N].NODE_TAG_NO_CURR                               
                     ,[4N].FXTR_GPS_LATITUDE                              
                     ,[4N].FXTR_GPS_LONGITUDE                             
                     ,[4N].TRANS_USERID                                   
                     ,[4N].SOURCE_APPL_CD                                 
                     ,[4N].SOURCE_APPL_REQ_NO                             
                     ,[4N].TRANS_STATUS_CD                                
                 FROM LMS_HANDHELD_TRANS [4N] WITH(READUNCOMMITTED)             
               WHERE [4N].SOURCE_APPL_REQ_NO = :4N-SOURCE-APPL-REQ-NO     
                 AND [4N].TRANS_STATUS_CD = ' '                           
                ORDER BY TRANS_SEQ_NO                                   
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SCAN_DTL_CRSR CURSOR WITH ROWSET POSITIONING FOR          
MFA-TR*        SELECT 4N.TRANS_SEQ_NO                                           
MFA-TR*              ,4N.TRANS_DATE                                             
MFA-TR*              ,4N.TRANS_TIME                                             
MFA-TR*              ,4N.WORK_FLOW_TYPE_CD                                      
MFA-TR*              ,4N.FXTR_TAG_NO_OLD                                        
MFA-TR*              ,4N.FXTR_TAG_NO_CURR                                       
MFA-TR*              ,4N.POLE_TAG_NO_OLD                                        
MFA-TR*              ,4N.POLE_TAG_NO_CURR                                       
MFA-TR*              ,4N.NODE_TAG_NO_OLD                                        
MFA-TR*              ,4N.NODE_TAG_NO_CURR                                       
MFA-TR*              ,4N.FXTR_GPS_LATITUDE                                      
MFA-TR*              ,4N.FXTR_GPS_LONGITUDE                                     
MFA-TR*              ,4N.TRANS_USERID                                           
MFA-TR*              ,4N.SOURCE_APPL_CD                                         
MFA-TR*              ,4N.SOURCE_APPL_REQ_NO                                     
MFA-TR*              ,4N.TRANS_STATUS_CD                                        
MFA-TR*          FROM LMS_HANDHELD_TRANS 4N                                     
MFA-TR*        WHERE 4N.SOURCE_APPL_REQ_NO = :4N-SOURCE-APPL-REQ-NO             
MFA-TR*          AND 4N.TRANS_STATUS_CD = ' '                                   
MFA-TR*         ORDER BY TRANS_SEQ_NO                                           
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *                                                                         
      *****************************************************************         
      * CURSOR DECLARATION FOR REQUEST DETAILS                        *         
      *****************************************************************         
           EXEC SQL                                                     
             DECLARE REQ_DTL_CRSR CURSOR WITH ROWSET POSITIONING FOR    
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_SEQ_NO                           
                     ,SOURCE_APPL_CD                                    
                     ,SOURCE_APPL_REQ_NO                                
                     ,WMS_POINT_NO                                      
                     ,ORDER_TYPE_CD                                     
                     ,WORK_TYPE_CD                                      
                     ,RECORD_TYPE_CD                                    
                     ,STOCK_CD                                          
                     ,RATE_PLAN_NO                                      
                     ,RATE_ITEM_CODE                                    
                     ,POLE_TAG_NO                                       
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           REQUEST_ACTION_TS, 121), ' ', '-'), ':', '.') 
           REQUEST_ACTION_TS                                 
                     ,REQUEST_ACTION_CD                                 
                     ,EQUIP_QTY                                         
                     ,ACCOUNT_NO                                        
                     ,REQUEST_STATUS_CD                                 
                     ,LOCAL_OFFICE                                      
               FROM LMS_REQUEST_DETAIL [4O] WITH(READUNCOMMITTED)               
              WHERE [4O].REQUEST_STATUS_CD = ' '                          
                AND [4O].SOURCE_APPL_REQ_NO = :4O-SOURCE-APPL-REQ-NO      
                AND [4O].SOURCE_APPL_CD     = :4O-SOURCE-APPL-CD          
                ORDER BY WMS_POINT_NO                                   
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE REQ_DTL_CRSR CURSOR WITH ROWSET POSITIONING FOR            
MFA-TR*        SELECT TRANS_SEQ_NO                                              
MFA-TR*              ,SOURCE_APPL_CD                                            
MFA-TR*              ,SOURCE_APPL_REQ_NO                                        
MFA-TR*              ,WMS_POINT_NO                                              
MFA-TR*              ,ORDER_TYPE_CD                                             
MFA-TR*              ,WORK_TYPE_CD                                              
MFA-TR*              ,RECORD_TYPE_CD                                            
MFA-TR*              ,STOCK_CD                                                  
MFA-TR*              ,RATE_PLAN_NO                                              
MFA-TR*              ,RATE_ITEM_CODE                                            
MFA-TR*              ,POLE_TAG_NO                                               
MFA-TR*              ,REQUEST_ACTION_TS                                         
MFA-TR*              ,REQUEST_ACTION_CD                                         
MFA-TR*              ,EQUIP_QTY                                                 
MFA-TR*              ,ACCOUNT_NO                                                
MFA-TR*              ,REQUEST_STATUS_CD                                         
MFA-TR*              ,LOCAL_OFFICE                                              
MFA-TR*        FROM LMS_REQUEST_DETAIL 4O                                       
MFA-TR*       WHERE 4O.REQUEST_STATUS_CD = ' '                                  
MFA-TR*         AND 4O.SOURCE_APPL_REQ_NO = :4O-SOURCE-APPL-REQ-NO              
MFA-TR*         AND 4O.SOURCE_APPL_CD     = :4O-SOURCE-APPL-CD                  
MFA-TR*         ORDER BY WMS_POINT_NO                                           
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*       QUERYNO 7150                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CURSOR DECLARATION FOR LMS_HANDHELD_TRANS                     *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE SCAN_NOM_CRSR CURSOR WITH ROWSET POSITIONING FOR  
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           [4N].TRANS_SEQ_NO, 121), ' ', '-'), ':', '.') TRANS_SEQ_NO          
                     ,[4N].TRANS_DATE                                     
                     ,REPLACE(CONVERT(CHAR(8), [4N].TRANS_TIME, 108), 
           ':', '.') TRANS_TIME                                     
                     ,[4N].WORK_FLOW_TYPE_CD                              
                     ,[4N].FXTR_TAG_NO_OLD                                
                     ,[4N].FXTR_TAG_NO_CURR                               
                     ,[4N].POLE_TAG_NO_OLD                                
                     ,[4N].POLE_TAG_NO_CURR                               
                     ,[4N].NODE_TAG_NO_OLD                                
                     ,[4N].NODE_TAG_NO_CURR                               
                     ,[4N].FXTR_GPS_LATITUDE                              
                     ,[4N].FXTR_GPS_LONGITUDE                             
                     ,[4N].TRANS_USERID                                   
                     ,[4N].SOURCE_APPL_CD                                 
                     ,[4N].SOURCE_APPL_REQ_NO                             
                     ,[4N].TRANS_STATUS_CD                                
                 FROM LMS_HANDHELD_TRANS [4N] WITH(READUNCOMMITTED)             
               WHERE [4N].TRANS_STATUS_CD = ' '                           
                 AND NOT EXISTS (SELECT 1                               
                   FROM LMS_REQUEST_DETAIL [4O] WITH(READUNCOMMITTED)           
                  WHERE [4O].SOURCE_APPL_REQ_NO = 
           [4N].SOURCE_APPL_REQ_NO   
                    AND [4O].REQUEST_STATUS_CD = ' ' )                    
                ORDER BY [4N].TRANS_DATE                                  
                        ,TRANS_TIME                                  
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SCAN_NOM_CRSR CURSOR WITH ROWSET POSITIONING FOR          
MFA-TR*        SELECT 4N.TRANS_SEQ_NO                                           
MFA-TR*              ,4N.TRANS_DATE                                             
MFA-TR*              ,4N.TRANS_TIME                                             
MFA-TR*              ,4N.WORK_FLOW_TYPE_CD                                      
MFA-TR*              ,4N.FXTR_TAG_NO_OLD                                        
MFA-TR*              ,4N.FXTR_TAG_NO_CURR                                       
MFA-TR*              ,4N.POLE_TAG_NO_OLD                                        
MFA-TR*              ,4N.POLE_TAG_NO_CURR                                       
MFA-TR*              ,4N.NODE_TAG_NO_OLD                                        
MFA-TR*              ,4N.NODE_TAG_NO_CURR                                       
MFA-TR*              ,4N.FXTR_GPS_LATITUDE                                      
MFA-TR*              ,4N.FXTR_GPS_LONGITUDE                                     
MFA-TR*              ,4N.TRANS_USERID                                           
MFA-TR*              ,4N.SOURCE_APPL_CD                                         
MFA-TR*              ,4N.SOURCE_APPL_REQ_NO                                     
MFA-TR*              ,4N.TRANS_STATUS_CD                                        
MFA-TR*          FROM LMS_HANDHELD_TRANS 4N                                     
MFA-TR*        WHERE 4N.TRANS_STATUS_CD = ' '                                   
MFA-TR*          AND NOT EXISTS (SELECT 1                                       
MFA-TR*            FROM LMS_REQUEST_DETAIL 4O                                   
MFA-TR*           WHERE 4O.SOURCE_APPL_REQ_NO = 4N.SOURCE_APPL_REQ_NO           
MFA-TR*             AND 4O.REQUEST_STATUS_CD = ' ' )                            
MFA-TR*         ORDER BY 4N.TRANS_DATE                                          
MFA-TR*                 ,4N.TRANS_TIME                                          
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
                                                                        
       01  WS-END                        PIC X(40)  VALUE               
             'WORKING STORAGE FOR PCSLM100 ENDS HERE  '.                
                                                                        
      *****************************************************************         
      **                                                             **         
      *                                                               *         
      *****************************************************************         
       PROCEDURE DIVISION.                                              
      *****************************************************************         
                                                                        
      *================================================================*        
       0000-MAINLINE.                                                   
      *================================================================*        
                                                                        
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
                                                                        
           PERFORM 1000-PROCESS-EACH-REQ   THRU 1000-EXIT               
              UNTIL WS-ACTIVE-RETURN-CODE  =    NOT-FOUND.              
                                                                        
           PERFORM 7060-CLOSE-MAIN-CRSR    THRU 7060-EXIT.              
           PERFORM 1020-PROCESS-SCAN-NOM   THRU 1020-EXIT.              
           PERFORM 8909-SUCCESSFUL-END     THRU 8909-EXIT.              
                                                                        
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       0100-INITIALIZATION.                                             
      *================================================================*        
                                                                        
      *    GET COMMON DATE                                                      
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT        
               DISPLAY 'COMMON DATE ==> ' WS-FCA00-COMMON-DATE          
               MOVE WS-FCA00-COMMON-DATE   TO WS-INPUT-DATE             
                                              WS-NEW-BUSINESS-DAY       
               PERFORM 6500-GET-NEXT-BUSINESS-DAY THRU                  
                      6500-NEXT-BUSINESS-DAY-EXIT                       
                      UNTIL NEXT-BUSINESS-DAY-FOUND                     
               MOVE WS-NEW-BUSINESS-DAY    TO WS-INPUT-DATE             
           END-IF.                                                      
           MOVE WS-INPUT-DATE              TO WS-RUN-DATE               
           DISPLAY 'PROGRAM RUN DATE ==> ' WS-RUN-DATE                  
      *                                                                         
A05084     MOVE WS-RUN-DATE              TO WS-NEW-BUSINESS-DAY         
A05084     PERFORM 0500-GET-10-BUSINESS-DAYS-AGO THRU 0500-EXIT         
A05084        VARYING WS-DAYS-INDX FROM 1 BY 1                          
A05084          UNTIL WS-DAYS-INDX GREATER THAN 10.                     
A05084*                                                                         
           DISPLAY 'RUN DATE - 4DAYS ==> ' WS-RUN-DATE-4DAYS            
           PERFORM 7050-OPEN-MAIN-CRSR           THRU 7050-EXIT.        
           PERFORM 7055-FETCH-MAIN-CRSR          THRU 7055-EXIT.        
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05084*================================================================*        
A05084 0500-GET-10-BUSINESS-DAYS-AGO.                                   
A05084*================================================================*        
A05084******************************************************************        
A05084*** GET PREVIOUS 3RD, 4TH & 10TH BUSINESS DAY FROM RUN DATE               
A05084*                                                                         
A05084     MOVE WS-NO                 TO WS-NEXT-BUSINESS-DAY.          
A05084     PERFORM 6525-PREV-BUSINESS-DAY THRU                          
A05084             6525-PREV-BUSINESS-DAY-EXIT UNTIL                    
A05084             NEXT-BUSINESS-DAY-FOUND.                             
A05084*                                                                         
A05084     EVALUATE TRUE                                                
ACT076        WHEN WS-DAYS-INDX = 1                                     
ACT076             MOVE WS-NEW-BUSINESS-DAY TO WS-RUN-DATE-1DAY         
A05084        WHEN WS-DAYS-INDX = 3                                     
A05084             MOVE WS-NEW-BUSINESS-DAY TO WS-RUN-DATE-3DAYS        
A05084        WHEN WS-DAYS-INDX = 4                                     
A05084             MOVE WS-NEW-BUSINESS-DAY TO WS-RUN-DATE-4DAYS        
A05084        WHEN WS-DAYS-INDX = 9                                     
A05084             MOVE WS-NEW-BUSINESS-DAY TO WS-RUN-DATE-9DAYS        
A05084        WHEN OTHER                                                
A05084             CONTINUE                                             
A05084     END-EVALUATE.                                                
A05084*                                                                         
A05084 0500-EXIT.                                                       
A05084     EXIT.                                                        
A05084*                                                                         
      *================================================================*        
       1000-PROCESS-EACH-REQ.                                           
      *================================================================*        
                                                                        
           INITIALIZE WS-REQ-DATA-TABLE                                 
                      WS-SCN-DATA-TABLE                                 
                      DCLCSS-ACCOUNT.                                   
           MOVE 4O-SOURCE-APPL-REQ-NO         TO 4N-SOURCE-APPL-REQ-NO  
                                                 WS-TASK-ORDER-NO       
           DISPLAY 'PROCESSING ORDER ==> ' WS-TASK-ORDER-NO             
           PERFORM 7100-OPEN-SCAN-DTL            THRU 7100-EXIT         
           PERFORM 7110-FETCH-SCAN-DTL           THRU 7110-EXIT         
           PERFORM 7120-CLOSE-SCAN-DTL           THRU 7120-EXIT         
           PERFORM 7150-OPEN-REQ-DTL             THRU 7150-EXIT         
           PERFORM 7160-FETCH-REQ-DTL            THRU 7160-EXIT         
           PERFORM 7170-CLOSE-REQ-DTL            THRU 7170-EXIT         
           IF WS-SCN-ROW-COUNT > 0 AND WS-REQ-ROW-COUNT  > 0            
              PERFORM 1050-SCN-ADNL-DATA      THRU 1050-EXIT            
                 VARYING WS-SCN-SUB FROM 1 BY 1                         
                    UNTIL WS-SCN-SUB > WS-SCN-ROW-COUNT                 
              MOVE REQ-WMS-POINT-NO (1)  TO WS-WMS-POINT-NO3            
              SET SINGLE-POINT-ORDER     TO TRUE                        
              PERFORM 1060-REQ-ADNL-DATA      THRU 1060-EXIT            
                 VARYING WS-REQ-SUB FROM 1 BY 1                         
                    UNTIL WS-REQ-SUB > WS-REQ-ROW-COUNT                 
              PERFORM 1100-MATCH-EACH-SCAN     THRU 1100-EXIT           
           ELSE                                                         
      ****  WQ'S POSSIBLE FROM REQ TABLE                                        
              PERFORM 5600-CREATE-WQ-EACH-REQ       THRU 5600-EXIT      
                 VARYING WS-REQ-SUB FROM 1 BY 1                         
                    UNTIL WS-REQ-SUB > WS-REQ-ROW-COUNT                 
           END-IF                                                       
           PERFORM 7055-FETCH-MAIN-CRSR          THRU 7055-EXIT.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1020-PROCESS-SCAN-NOM.                                           
      *================================================================*        
                                                                        
           INITIALIZE WS-REQ-DATA-TABLE                                 
                      WS-SCN-DATA-TABLE                                 
                      DCLCSS-ACCOUNT.                                   
           MOVE ZEROS                         TO 4N-SOURCE-APPL-REQ-NO  
                                                 WS-TASK-ORDER-NO       
           PERFORM 7200-OPEN-SCAN-NOM            THRU 7200-EXIT         
           PERFORM 7210-FETCH-SCAN-NOM           THRU 7210-EXIT         
           PERFORM 7220-CLOSE-SCAN-NOM           THRU 7220-EXIT         
                                                                        
           IF WS-SCN-ROW-COUNT > 0                                      
                                                                        
              PERFORM 1050-SCN-ADNL-DATA      THRU 1050-EXIT            
                 VARYING WS-SCN-SUB FROM 1 BY 1                         
                    UNTIL WS-SCN-SUB > WS-SCN-ROW-COUNT                 
              PERFORM 1060-REQ-ADNL-DATA      THRU 1060-EXIT            
                 VARYING WS-REQ-SUB FROM 1 BY 1                         
                    UNTIL WS-REQ-SUB > WS-REQ-ROW-COUNT                 
                                                                        
              PERFORM VARYING WS-SCN-SUB FROM 1 BY 1                    
                 UNTIL WS-SCN-SUB > WS-SCN-ROW-COUNT                    
                 IF SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB) = 'A'            
      ***         /* AUDIT */                                                   
                    MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)               
                                         TO WS-TASK-FXTR-TAG-NO         
A05084              DISPLAY 'AUDIT PROCESSED ==> ' WS-TASK-FXTR-TAG-NO  
                    MOVE 'M'         TO SCN-LOCAL-ACTION(WS-SCN-SUB)    
                    PERFORM 3500-PROCESS-AUDITS THRU 3500-EXIT          
                    MOVE SCN-TRANS-SEQ-NO (WS-SCN-SUB)                  
                                         TO 4N-TRANS-SEQ-NO             
                    MOVE SCN-LOCAL-ACTION(WS-SCN-SUB)                   
                                         TO 4N-TRANS-STATUS-CD          
                    PERFORM 8350-UPDATE-SCN THRU 8350-EXIT              
                 ELSE                                                   
A05084             PERFORM 1030-NOTIFY-TO-CMPL-REQ THRU 1030-EXIT       
                 END-IF                                                 
              END-PERFORM                                               
           END-IF.                                                      
       1020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1030-NOTIFY-TO-CMPL-REQ.                                         
      *================================================================*        
                                                                        
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                     TO WS-TASK-ORDER-NO                
           DISPLAY 'ORDER NOT CLOSED ==> ' WS-TASK-ORDER-NO             
           EVALUATE TRUE                                                
              WHEN SCN-TRANS-SEQ-NO (WS-SCN-SUB) (1:10)                 
                               > WS-RUN-DATE-4DAYS                      
               AND SCN-TRANS-SEQ-NO (WS-SCN-SUB) (1:10)                 
                               <= WS-RUN-DATE-3DAYS                     
                   MOVE SCN-FXTR-SEQ-NO-CUR  (WS-SCN-SUB)               
                                     TO WS-TASK-FXTR-SEQ-NO             
                   MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                
                                     TO WS-TASK-FXTR-TAG-NO             
                   MOVE SCN-POLE-TAG-NO-CUR (WS-SCN-SUB)                
                                     TO WS-TASK-POLE-TAG-NO             
                   PERFORM 5793-TASK-NOTIFY-USER     THRU 5793-EXIT     
              WHEN SCN-TRANS-SEQ-NO (WS-SCN-SUB) (1:10)                 
                               < WS-RUN-DATE-9DAYS                      
                   MOVE 'E'  TO SCN-LOCAL-ACTION(WS-SCN-SUB)            
                                4N-TRANS-STATUS-CD                      
                   MOVE SCN-TRANS-SEQ-NO (WS-SCN-SUB)                   
                                     TO 4N-TRANS-SEQ-NO                 
                   PERFORM 8350-UPDATE-SCN THRU 8350-EXIT               
                   MOVE SCN-FXTR-SEQ-NO-CUR  (WS-SCN-SUB)               
                                     TO WS-TASK-FXTR-SEQ-NO             
                   MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                
                                     TO WS-TASK-FXTR-TAG-NO             
                   MOVE SCN-POLE-TAG-NO-CUR (WS-SCN-SUB)                
                                     TO WS-TASK-POLE-TAG-NO             
                   PERFORM 5791-TASK-MISSING-WMS-REQ THRU 5791-EXIT     
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
                                                                        
       1030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1050-SCN-ADNL-DATA.                                              
      *================================================================*        
                                                                        
           IF SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB) > SPACES                 
              MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                     
                                         TO 4D-EQUIP-TAG-NO             
              MOVE 'F'                   TO 4D-EQUIP-TYPE-CD            
              PERFORM 7032-GET-FXTR-LOCATION THRU 7032-EXIT             
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 4D-EQUIP-SEQ            TO                        
                               SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)         
                 MOVE 4D-INVENTRY-STATUS-CD   TO                        
                               SCN-FXTR-INV-ST-CUR (WS-SCN-SUB)         
                 MOVE 4D-WRNTY-RECOUP-AMT     TO                        
                            SCN-FXTR-WRNTY-AMT-CUR (WS-SCN-SUB)         
                 MOVE 4D-STOCK-CD             TO                        
                                SCN-FXTR-STOCK-CUR (WS-SCN-SUB)         
                 MOVE 4F-INSTALL-LOC-NO       TO                        
                           SCN-FXTR-INS-LOC-NO-CUR (WS-SCN-SUB)         
                 MOVE 4F-INSTALL-POINT-NO     TO                        
                         SCN-FXTR-INS-POINT-NO-CUR (WS-SCN-SUB)         
                 MOVE 4F-CODE-UTIL-TYPE       TO                        
                         SCN-FXTR-UTIL-TYPE-CUR (WS-SCN-SUB)            
                 MOVE 4F-BILLING-FL           TO                        
                         SCN-FXTR-BILLING-FL-CUR (WS-SCN-SUB)           
                 MOVE 4F-EQUIP-CONTRACT-FL    TO                        
                         SCN-FXTR-CONTRACT-FL-CUR (WS-SCN-SUB)          
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF SCN-FXTR-TAG-NO-OLD (WS-SCN-SUB) > SPACES                 
              IF SCN-FXTR-TAG-NO-OLD (WS-SCN-SUB) =                     
                    SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                    
                 MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                  
                                         TO                             
                            SCN-FXTR-SEQ-NO-OLD (WS-SCN-SUB)            
                 MOVE SCN-FXTR-INV-ST-CUR (WS-SCN-SUB)                  
                                         TO                             
                            SCN-FXTR-INV-ST-OLD (WS-SCN-SUB)            
                 MOVE SCN-FXTR-WRNTY-AMT-CUR (WS-SCN-SUB)               
                                         TO                             
                         SCN-FXTR-WRNTY-AMT-OLD (WS-SCN-SUB)            
                 MOVE SCN-FXTR-STOCK-CUR (WS-SCN-SUB)                   
                                         TO                             
                             SCN-FXTR-STOCK-OLD (WS-SCN-SUB)            
                 MOVE SCN-FXTR-INS-LOC-NO-CUR (WS-SCN-SUB)              
                                         TO                             
                        SCN-FXTR-INS-LOC-NO-OLD (WS-SCN-SUB)            
                 MOVE SCN-FXTR-INS-POINT-NO-CUR (WS-SCN-SUB)            
                                         TO                             
                      SCN-FXTR-INS-POINT-NO-OLD (WS-SCN-SUB)            
                MOVE SCN-FXTR-UTIL-TYPE-CUR  (WS-SCN-SUB)               
                                         TO                             
                         SCN-FXTR-UTIL-TYPE-OLD  (WS-SCN-SUB)           
                MOVE SCN-FXTR-BILLING-FL-CUR (WS-SCN-SUB)               
                                         TO                             
                         SCN-FXTR-BILLING-FL-OLD (WS-SCN-SUB)           
                MOVE SCN-FXTR-CONTRACT-FL-CUR (WS-SCN-SUB)              
                                         TO                             
                         SCN-FXTR-CONTRACT-FL-OLD (WS-SCN-SUB)          
              ELSE                                                      
                 MOVE SCN-FXTR-TAG-NO-OLD (WS-SCN-SUB)                  
                                         TO 4D-EQUIP-TAG-NO             
                 MOVE 'F'                TO 4D-EQUIP-TYPE-CD            
                 PERFORM 7032-GET-FXTR-LOCATION THRU 7032-EXIT          
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE 4D-EQUIP-SEQ         TO                        
                               SCN-FXTR-SEQ-NO-OLD (WS-SCN-SUB)         
                    MOVE 4D-INVENTRY-STATUS-CD TO                       
                               SCN-FXTR-INV-ST-OLD (WS-SCN-SUB)         
                    MOVE 4D-WRNTY-RECOUP-AMT  TO                        
                            SCN-FXTR-WRNTY-AMT-OLD (WS-SCN-SUB)         
                    MOVE 4D-STOCK-CD          TO                        
                                SCN-FXTR-STOCK-OLD (WS-SCN-SUB)         
                    MOVE 4F-INSTALL-LOC-NO    TO                        
                           SCN-FXTR-INS-LOC-NO-OLD (WS-SCN-SUB)         
                    MOVE 4F-INSTALL-POINT-NO  TO                        
                         SCN-FXTR-INS-POINT-NO-OLD (WS-SCN-SUB)         
                    MOVE 4F-CODE-UTIL-TYPE    TO                        
                         SCN-FXTR-UTIL-TYPE-OLD (WS-SCN-SUB)            
                    MOVE 4F-BILLING-FL        TO                        
                         SCN-FXTR-BILLING-FL-OLD (WS-SCN-SUB)           
                    MOVE 4F-EQUIP-CONTRACT-FL    TO                     
                         SCN-FXTR-CONTRACT-FL-OLD (WS-SCN-SUB)          
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
           IF SCN-POLE-TAG-NO-CUR (WS-SCN-SUB) > SPACES                 
              MOVE SCN-POLE-TAG-NO-CUR (WS-SCN-SUB)                     
                                         TO WS-IN-STRING                
              PERFORM 5100-REMOVE-LEADING-ZEROS THRU 5100-EXIT          
              MOVE WS-OUT-STRING         TO                             
                             SCN-POLE-TAG-NO-CUR (WS-SCN-SUB)           
                             SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)           
           END-IF.                                                      
           IF SCN-POLE-TAG-NO-OLD (WS-SCN-SUB) > SPACES                 
              MOVE SCN-POLE-TAG-NO-OLD (WS-SCN-SUB)                     
                                         TO WS-IN-STRING                
              PERFORM 5100-REMOVE-LEADING-ZEROS THRU 5100-EXIT          
              MOVE WS-OUT-STRING         TO                             
                             SCN-POLE-TAG-NO-OLD (WS-SCN-SUB)           
                             SCN-REQ-POLE-NO-OLD (WS-SCN-SUB)           
           END-IF.                                                      
                                                                        
       1050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1060-REQ-ADNL-DATA.                                              
      *================================================================*        
                                                                        
           IF REQ-POLE-TAG-NO (WS-REQ-SUB) > SPACES                     
              MOVE REQ-POLE-TAG-NO (WS-REQ-SUB)                         
                                         TO WS-IN-STRING                
              PERFORM 5100-REMOVE-LEADING-ZEROS THRU 5100-EXIT          
              MOVE WS-OUT-STRING         TO                             
                             REQ-POLE-TAG-NO (WS-REQ-SUB)               
           END-IF.                                                      
           IF REQ-WMS-POINT-NO (WS-REQ-SUB) =   WS-WMS-POINT-NO3        
              CONTINUE                                                  
           ELSE                                                         
              SET MULTI-POINT-ORDER      TO TRUE                        
           END-IF.                                                      
                                                                        
       1060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1100-MATCH-EACH-SCAN.                                            
      *================================================================*        
                                                                        
           PERFORM VARYING WS-SCN-SUB FROM 1 BY 1                       
              UNTIL WS-SCN-SUB > WS-SCN-ROW-COUNT                       
              IF SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB) = 'C'               
      ***         /* REPLACE/CHANGE */                                          
                 MOVE 'REPLACE'            TO WS-TASK-WORK-FLOW         
                 IF SCN-SOURCE-APPL-CD (WS-SCN-SUB) = 'WMS'             
                    PERFORM 1200-MATCH-REPLACE-WMS THRU 1200-EXIT       
                 ELSE                                                   
                    PERFORM 1220-MATCH-REPLACE-CIS THRU 1220-EXIT       
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           PERFORM VARYING WS-SCN-SUB FROM 1 BY 1                       
              UNTIL WS-SCN-SUB > WS-SCN-ROW-COUNT                       
              IF SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB) = 'M'               
      ***         /* RELOCATE  */                                               
                 MOVE 'RELOCATE'           TO WS-TASK-WORK-FLOW         
                 IF SCN-SOURCE-APPL-CD (WS-SCN-SUB) = 'WMS'             
                    PERFORM 1200-MATCH-REPLACE-WMS THRU 1200-EXIT       
                 ELSE                                                   
                    PERFORM 1220-MATCH-REPLACE-CIS THRU 1220-EXIT       
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           PERFORM VARYING WS-SCN-SUB FROM 1 BY 1                       
              UNTIL WS-SCN-SUB > WS-SCN-ROW-COUNT                       
              IF SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB) = 'D'               
      ***         /* REMOVE/DELETE */                                           
                 PERFORM 1400-MATCH-REMOVE     THRU 1400-EXIT           
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           PERFORM VARYING WS-SCN-SUB FROM 1 BY 1                       
              UNTIL WS-SCN-SUB > WS-SCN-ROW-COUNT                       
              IF SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB) = 'I'               
      ***         /* INSTALL */                                                 
                 PERFORM 1600-MATCH-INSTALL    THRU 1600-EXIT           
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           PERFORM VARYING WS-SCN-SUB FROM 1 BY 1                       
              UNTIL WS-SCN-SUB > WS-SCN-ROW-COUNT                       
              IF SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB) = 'R'               
      ***         /* REPAIR  */                                                 
                 PERFORM 1800-MATCH-REPAIR     THRU 1800-EXIT           
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           PERFORM VARYING WS-SCN-SUB FROM 1 BY 1                       
              UNTIL WS-SCN-SUB > WS-SCN-ROW-COUNT                       
              IF SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB) = 'A'               
      ***         /* AUDIT */                                                   
                 MOVE 'M'             TO SCN-LOCAL-ACTION(WS-SCN-SUB)   
                 MOVE 'AUDIT'         TO WS-TASK-WORK-FLOW              
                 CONTINUE                                               
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           PERFORM VARYING WS-SCN-SUB FROM 1 BY 1                       
              UNTIL WS-SCN-SUB > WS-SCN-ROW-COUNT                       
              IF SCN-LOCAL-ACTION(WS-SCN-SUB) = 'M'                     
                 MOVE SCN-WMS-POINT-CUR (WS-SCN-SUB)                    
                                         TO WS-WMS-POINT-NO1            
                 MOVE SCN-WMS-POINT-OLD (WS-SCN-SUB)                    
                                         TO WS-WMS-POINT-NO2            
                 SET ALL-REQ-MATCHED     TO TRUE                        
                 PERFORM VARYING WS-REQ-SUB1 FROM 1 BY 1                
                    UNTIL WS-REQ-SUB1 > WS-REQ-ROW-COUNT                
                    IF (REQ-WMS-POINT-NO (WS-REQ-SUB1)                  
                                = WS-WMS-POINT-NO1 OR WS-WMS-POINT-NO2) 
                       AND REQ-LOCAL-ACTION(WS-REQ-SUB1) NOT = 'M'      
                       SET UNMATCH-REQ-FOUND TO TRUE                    
                    END-IF                                              
                 END-PERFORM                                            
                 IF UNMATCH-REQ-FOUND                                   
                    MOVE 'E'  TO SCN-LOCAL-ACTION(WS-SCN-SUB)           
                    PERFORM 5790-TASK-PART-WMS-MISMATCH THRU 5790-EXIT  
                    PERFORM VARYING WS-REQ-SUB1 FROM 1 BY 1             
                       UNTIL WS-REQ-SUB1 > WS-REQ-ROW-COUNT             
                       IF REQ-WMS-POINT-NO (WS-REQ-SUB1)                
                              = WS-WMS-POINT-NO1 OR WS-WMS-POINT-NO2    
                          MOVE 'E'   TO REQ-LOCAL-ACTION(WS-REQ-SUB1)   
                       END-IF                                           
                    END-PERFORM                                         
                                                                        
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           PERFORM 3000-PROCESS-MATCHED-DATA     THRU 3000-EXIT.        
                                                                        
           PERFORM VARYING WS-SCN-SUB FROM 1 BY 1                       
              UNTIL WS-SCN-SUB > WS-SCN-ROW-COUNT                       
            EVALUATE TRUE                                               
               WHEN (SCN-LOCAL-ACTION(WS-SCN-SUB)  = ' '                
                 OR SCN-LOCAL-ACTION(WS-SCN-SUB)  = 'N')                
A05084***        IF SCN-TRANS-SEQ-NO (WS-SCN-SUB) (1:10)                        
A05084***                          < WS-RUN-DATE-4DAYS                          
                    MOVE 'E'  TO SCN-LOCAL-ACTION(WS-SCN-SUB)           
                                   4N-TRANS-STATUS-CD                   
                    MOVE SCN-TRANS-SEQ-NO (WS-SCN-SUB)                  
                                         TO 4N-TRANS-SEQ-NO             
                    PERFORM 8350-UPDATE-SCN        THRU 8350-EXIT       
                    IF REQ-ACCOUNT-NO  (1) IS NUMERIC                   
                       AND REQ-ACCOUNT-NO  (1) > ZERO                   
                       MOVE REQ-ACCOUNT-NO (1) TO AT-ACCOUNT-NO         
                       PERFORM 7000-GET-PREMISE   THRU 7000-EXIT        
                       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL       
                          MOVE AT-LOCAL-OFFICE  TO                      
                                       SCN-LOCAL-OFFICE (WS-SCN-SUB)    
                          IF AT-CODE-ACCT-STAT = 'A' OR 'P'             
                             CONTINUE                                   
                          ELSE                                          
                             MOVE AT-PREMISE-NO                         
                                         TO WS-CPD99-PREMISE-NO         
                             PERFORM 6990-FETCH-CUR-ACCOUNT             
                                THRU  6990-EXIT                         
                             IF WS-CPD99-ACCOUNT-NO = AT-ACCOUNT-NO     
                                CONTINUE                                
                             ELSE                                       
                                MOVE WS-CPD99-ACCOUNT-NO                
                                        TO AT-ACCOUNT-NO                
                                           REQ-ACCOUNT-NO (1)           
A05084                          PERFORM 7000-GET-PREMISE                
A05084                             THRU 7000-EXIT                       
                             END-IF                                     
                          END-IF                                        
                       ELSE                                             
                          MOVE ZEROS  TO REQ-ACCOUNT-NO (1)             
                                         AT-ACCOUNT-NO                  
                          MOVE REQ-LOCAL-OFFICE (1) TO                  
                                       SCN-LOCAL-OFFICE (WS-SCN-SUB)    
                       END-IF                                           
A05084              ELSE                                                
A05084                 MOVE ZEROS  TO REQ-ACCOUNT-NO (1)                
A05084                                AT-ACCOUNT-NO                     
A05084                 MOVE REQ-LOCAL-OFFICE (1) TO                     
A05084                               SCN-LOCAL-OFFICE (WS-SCN-SUB)      
                    END-IF                                              
                    PERFORM 5680-PROCESS-MISMATCH                       
                       THRU 5680-EXIT                                   
                    MOVE 'E'             TO WS-LOCAL-ACTION             
                    MOVE ZERO            TO WS-WMS-POINT-NO1            
                    PERFORM 5660-UPDATE-UNMTCH-REQ  THRU 5660-EXIT      
                       VARYING WS-REQ-SUB1 FROM 1 BY 1                  
                           UNTIL WS-REQ-SUB1 > WS-REQ-ROW-COUNT         
A05084***        END-IF                                                         
               WHEN SCN-LOCAL-ACTION(WS-SCN-SUB)  = 'E'                 
                    MOVE SCN-WMS-POINT-CUR (WS-SCN-SUB)                 
                                         TO WS-WMS-POINT-NO1            
                    MOVE SCN-WMS-POINT-OLD (WS-SCN-SUB)                 
                                         TO WS-WMS-POINT-NO2            
                    MOVE  'E'  TO 4N-TRANS-STATUS-CD                    
                    MOVE SCN-TRANS-SEQ-NO (WS-SCN-SUB)                  
                                         TO 4N-TRANS-SEQ-NO             
                    PERFORM 8350-UPDATE-SCN THRU 8350-EXIT              
                    MOVE 'E'             TO WS-LOCAL-ACTION             
                    PERFORM 5650-UPDATE-EACH-REQ  THRU 5650-EXIT        
                       VARYING WS-REQ-SUB1 FROM 1 BY 1                  
                          UNTIL WS-REQ-SUB1 > WS-REQ-ROW-COUNT          
               WHEN SCN-LOCAL-ACTION(WS-SCN-SUB)  = 'M'                 
                    MOVE SCN-WMS-POINT-CUR (WS-SCN-SUB)                 
                                         TO WS-WMS-POINT-NO1            
                    MOVE SCN-WMS-POINT-OLD (WS-SCN-SUB)                 
                                         TO WS-WMS-POINT-NO2            
                    MOVE 'C'  TO SCN-LOCAL-ACTION(WS-SCN-SUB)           
                                 4N-TRANS-STATUS-CD                     
                    MOVE SCN-TRANS-SEQ-NO (WS-SCN-SUB)                  
                                         TO 4N-TRANS-SEQ-NO             
                    PERFORM 8350-UPDATE-SCN THRU 8350-EXIT              
                                                                        
                    MOVE 'C'             TO WS-LOCAL-ACTION             
                    PERFORM 5650-UPDATE-EACH-REQ  THRU 5650-EXIT        
                       VARYING WS-REQ-SUB1 FROM 1 BY 1                  
                          UNTIL WS-REQ-SUB1 > WS-REQ-ROW-COUNT          
            END-EVALUATE                                                
           END-PERFORM.                                                 
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1200-MATCH-REPLACE-WMS.                                          
      *================================================================*        
                                                                        
      *** CHECK FIXTURE INVENTORY STATUS                                        
      *** CHECK POLE INVENTORY STATUS                                           
      *** CHECK CHECK IC DETAILS IN CUST PLAN                                   
      *** CREATE LIGHT ENVIRONMENT                                              
      *** CREATE FIXTURE/POLE ATTACHMENT                                        
      *** CREATE FIXUTE/NODE ATTACHMENT                                         
                                                                        
                                                                        
      ***  CHECK POLE INVENTORY STATUS LATER                                    
      *** MATCH WITH DETAILS                                                    
           MOVE ZEROS                    TO WS-CUR-FXR-POL-TAG-MCH      
                                            WS-CUR-FXR-ONLY-MCH         
                                            WS-OLD-FXR-ONLY-MCH         
                                            WS-CUR-POL-TAG-MCH          
                                            WS-OLD-FXR-POL-TAG-MCH      
                                            WS-OLD-POL-TAG-MCH          
                                            WS-WMS-POINT-NO             
                                            WS-WMS-POINT-NO-OLD         
           MOVE SPACES                   TO WS-MATCHED-POLE-TAG-NO      
           MOVE 'I'                      TO WS-REQ-ACTION-CD            
                                            WS-REQ-ACTION-CD1           
                                            WS-REQ-ACTION-CD2           
           PERFORM 2100-FIRM-CURR-FXR-MATCH THRU 2100-EXIT              
              VARYING WS-REQ-SUB FROM WS-REQ-ROW-COUNT BY -1            
              UNTIL WS-REQ-SUB < 1 OR WS-CUR-FXR-POL-TAG-MCH > 0        
                                                                        
           IF WS-CUR-FXR-POL-TAG-MCH = 0 AND SINGLE-POINT-ORDER         
              PERFORM 2105-SOFT-CURR-FXR-MATCH  THRU 2105-EXIT          
                 VARYING WS-REQ-SUB FROM WS-REQ-ROW-COUNT BY -1         
                 UNTIL WS-REQ-SUB < 1 OR WS-CUR-FXR-POL-TAG-MCH > 0     
           END-IF                                                       
                                                                        
           IF WS-WMS-POINT-NO > 0                                       
              PERFORM 2120-FIND-CURR-POLE-MATCH THRU 2120-EXIT          
                 VARYING WS-REQ-SUB FROM WS-REQ-ROW-COUNT BY -1         
                    UNTIL WS-REQ-SUB < 1                                
                      OR WS-CUR-POL-TAG-MCH > 0                         
              MOVE SPACES                TO WS-MATCHED-POLE-TAG-NO      
              PERFORM 2110-FIRM-OLD-FXR-MATCH THRU 2110-EXIT            
                 VARYING WS-REQ-SUB FROM WS-REQ-ROW-COUNT BY -1         
                    UNTIL WS-REQ-SUB < 1                                
                         OR WS-OLD-FXR-POL-TAG-MCH > 0                  
              IF WS-OLD-FXR-POL-TAG-MCH = 0                             
                 PERFORM 2111-OLD-FXR-POLE-ONLY-MCH THRU 2111-EXIT      
                    VARYING WS-REQ-SUB FROM WS-REQ-ROW-COUNT BY -1      
                    UNTIL WS-REQ-SUB < 1                                
                          OR WS-OLD-FXR-POL-TAG-MCH > 0                 
              END-IF                                                    
              IF WS-OLD-FXR-POL-TAG-MCH = 0                             
                 PERFORM 2112-NOPOINT-OLD-FXR-MATCH THRU 2112-EXIT      
                    VARYING WS-REQ-SUB FROM WS-REQ-ROW-COUNT BY -1      
                    UNTIL WS-REQ-SUB < 1                                
                          OR WS-OLD-FXR-POL-TAG-MCH > 0                 
              END-IF                                                    
              IF WS-OLD-FXR-POL-TAG-MCH = 0                             
                 PERFORM 2113-NOPOINT-FXR-POLE-ONLY THRU 2113-EXIT      
                    VARYING WS-REQ-SUB FROM WS-REQ-ROW-COUNT BY -1      
                    UNTIL WS-REQ-SUB < 1                                
                          OR WS-OLD-FXR-POL-TAG-MCH > 0                 
              END-IF                                                    
              IF WS-OLD-FXR-POL-TAG-MCH = 0 AND SINGLE-POINT-ORDER      
                 PERFORM 2115-SOFT-OLD-FXR-MATCH THRU 2115-EXIT         
                    VARYING WS-REQ-SUB FROM WS-REQ-ROW-COUNT BY -1      
                       UNTIL WS-REQ-SUB < 1                             
                          OR WS-OLD-FXR-POL-TAG-MCH > 0                 
              END-IF                                                    
              IF WS-WMS-POINT-NO-OLD > 0                                
                 PERFORM 2130-FIND-OLD-POLE-MATCH THRU 2130-EXIT        
                    VARYING WS-REQ-SUB FROM WS-REQ-ROW-COUNT BY -1      
                       UNTIL WS-REQ-SUB < 1                             
                         OR WS-OLD-POL-TAG-MCH > 0                      
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF WS-CUR-FXR-POL-TAG-MCH > 0                                
              MOVE 'M'            TO SCN-LOCAL-ACTION(WS-SCN-SUB)       
              MOVE WS-CUR-FXR-POL-TAG-MCH     TO WS-REQ-SUB             
              PERFORM 2210-ADD-CURR-FXR-DATA  THRU 2210-EXIT            
              IF WS-CUR-POL-TAG-MCH > 0                                 
                 MOVE WS-CUR-POL-TAG-MCH      TO WS-REQ-SUB             
                 PERFORM 2230-ADD-CURR-POL-DATA   THRU 2230-EXIT        
              END-IF                                                    
           END-IF                                                       
           IF WS-OLD-FXR-POL-TAG-MCH > 0                                
              MOVE 'M'            TO SCN-LOCAL-ACTION(WS-SCN-SUB)       
              MOVE WS-OLD-FXR-POL-TAG-MCH     TO WS-REQ-SUB             
              PERFORM 2220-ADD-OLD-FXR-DATA   THRU 2220-EXIT            
              IF WS-OLD-POL-TAG-MCH > 0                                 
                 MOVE WS-OLD-POL-TAG-MCH      TO WS-REQ-SUB             
                 PERFORM 2240-ADD-OLD-POL-DATA   THRU 2240-EXIT         
              END-IF                                                    
           END-IF                                                       
           IF WS-CUR-FXR-POL-TAG-MCH > 0                                
              AND WS-OLD-FXR-POL-TAG-MCH > 0                            
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'N'            TO SCN-LOCAL-ACTION(WS-SCN-SUB)       
              IF WS-CUR-FXR-POL-TAG-MCH = 0                             
                 EVALUATE TRUE                                          
                    WHEN SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB) = ZEROS       
                       MOVE 'N1' TO SCN-MISMATCH-TYPE (WS-SCN-SUB)      
                    WHEN WS-CUR-FXR-ONLY-MCH > 0                        
                       MOVE 'P1' TO SCN-MISMATCH-TYPE (WS-SCN-SUB)      
                    WHEN OTHER                                          
                       MOVE 'F1' TO SCN-MISMATCH-TYPE (WS-SCN-SUB)      
                 END-EVALUATE                                           
              ELSE                                                      
                 EVALUATE TRUE                                          
                    WHEN SCN-FXTR-SEQ-NO-OLD (WS-SCN-SUB) = ZEROS       
                       MOVE 'N2' TO SCN-MISMATCH-TYPE (WS-SCN-SUB)      
                    WHEN WS-OLD-FXR-ONLY-MCH > 0                        
                       MOVE 'P2' TO SCN-MISMATCH-TYPE (WS-SCN-SUB)      
                    WHEN OTHER                                          
                       MOVE 'F2' TO SCN-MISMATCH-TYPE (WS-SCN-SUB)      
                 END-EVALUATE                                           
              END-IF                                                    
           END-IF.                                                      
           .                                                            
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1220-MATCH-REPLACE-CIS.                                          
      *================================================================*        
                                                                        
           MOVE ZEROS                    TO WS-CUR-FXR-POL-TAG-MCH      
                                            WS-CUR-POL-TAG-MCH          
                                            WS-WMS-POINT-NO             
           PERFORM VARYING WS-REQ-SUB FROM WS-REQ-ROW-COUNT BY -1       
              UNTIL WS-REQ-SUB < 1                                      
              MOVE REQ-WORK-TYPE-CD (WS-REQ-SUB) TO WS-WORK-TYPE-SW     
              IF REQ-SOURCE-APPL-CD (WS-REQ-SUB) = 'CIS'                
                 AND REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = 'S'           
                 AND WORK-TYPE-REPLACE                                  
      ***        AND REQ-LOCAL-ACTION (WS-REQ-SUB) = ' '                        
                    MOVE WS-REQ-SUB      TO WS-CUR-FXR-POL-TAG-MCH      
                    MOVE REQ-WMS-POINT-NO (WS-REQ-SUB)                  
                                         TO WS-WMS-POINT-NO             
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           IF WS-CUR-FXR-POL-TAG-MCH > 0                                
              MOVE 'M'            TO SCN-LOCAL-ACTION(WS-SCN-SUB)       
              MOVE WS-CUR-FXR-POL-TAG-MCH     TO WS-REQ-SUB             
              PERFORM 2210-ADD-CURR-FXR-DATA  THRU 2210-EXIT            
           ELSE                                                         
              MOVE 'N'         TO SCN-LOCAL-ACTION(WS-SCN-SUB)          
           END-IF.                                                      
           .                                                            
       1220-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       1400-MATCH-REMOVE.                                               
      *================================================================*        
                                                                        
           MOVE ZEROS                    TO WS-CUR-FXR-POL-TAG-MCH      
                                            WS-CUR-FXR-ONLY-MCH         
                                            WS-CUR-POL-TAG-MCH          
                                            WS-WMS-POINT-NO             
           MOVE 'REMOVE'                 TO WS-TASK-WORK-FLOW           
           MOVE SPACES                   TO WS-MATCHED-POLE-TAG-NO      
           MOVE 'R'                      TO WS-REQ-ACTION-CD            
           MOVE 'S'                      TO WS-REQ-ACTION-CD1           
           MOVE 'A'                      TO WS-REQ-ACTION-CD2           
           PERFORM 2100-FIRM-CURR-FXR-MATCH  THRU 2100-EXIT             
              VARYING WS-REQ-SUB FROM WS-REQ-ROW-COUNT BY -1            
              UNTIL WS-REQ-SUB < 1 OR WS-CUR-FXR-POL-TAG-MCH > 0        
                                                                        
           IF WS-CUR-FXR-POL-TAG-MCH = 0 AND SINGLE-POINT-ORDER         
              PERFORM 2105-SOFT-CURR-FXR-MATCH  THRU 2105-EXIT          
                 VARYING WS-REQ-SUB FROM WS-REQ-ROW-COUNT BY -1         
                 UNTIL WS-REQ-SUB < 1 OR WS-CUR-FXR-POL-TAG-MCH > 0     
           END-IF                                                       
                                                                        
           IF WS-WMS-POINT-NO > 0                                       
              PERFORM 2120-FIND-CURR-POLE-MATCH THRU 2120-EXIT          
                 VARYING WS-REQ-SUB FROM WS-REQ-ROW-COUNT BY -1         
                   UNTIL WS-REQ-SUB < 1                                 
                      OR WS-CUR-POL-TAG-MCH > 0                         
           END-IF                                                       
                                                                        
           IF WS-CUR-FXR-POL-TAG-MCH > 0                                
              MOVE 'M'            TO SCN-LOCAL-ACTION(WS-SCN-SUB)       
              MOVE WS-CUR-FXR-POL-TAG-MCH     TO WS-REQ-SUB             
              PERFORM 2210-ADD-CURR-FXR-DATA  THRU 2210-EXIT            
              IF WS-CUR-POL-TAG-MCH > 0                                 
                 MOVE WS-CUR-POL-TAG-MCH      TO WS-REQ-SUB             
                 PERFORM 2230-ADD-CURR-POL-DATA   THRU 2230-EXIT        
              END-IF                                                    
           ELSE                                                         
              MOVE 'N'            TO SCN-LOCAL-ACTION(WS-SCN-SUB)       
              EVALUATE TRUE                                             
                 WHEN SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB) = ZEROS          
                    MOVE 'N0'   TO SCN-MISMATCH-TYPE (WS-SCN-SUB)       
                 WHEN WS-CUR-FXR-ONLY-MCH > 0                           
                    MOVE 'P0'   TO SCN-MISMATCH-TYPE (WS-SCN-SUB)       
                 WHEN OTHER                                             
                    MOVE 'F0'   TO SCN-MISMATCH-TYPE (WS-SCN-SUB)       
              END-EVALUATE                                              
           END-IF.                                                      
           .                                                            
       1400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1600-MATCH-INSTALL.                                              
      *================================================================*        
                                                                        
      *** CHECK FIXTURE INVENTORY STATUS                                        
      *** CHECK POLE INVENTORY STATUS                                           
      *** CHECK CHECK IC DETAILS IN CUST PLAN                                   
      *** CREATE LIGHT ENVIRONMENT                                              
      *** CREATE FIXTURE/POLE ATTACHMENT                                        
      *** CREATE FIXUTE/NODE ATTACHMENT                                         
                                                                        
                                                                        
      ***  CHECK POLE INVENTORY STATUS LATER                                    
      *** MATCH WITH DETAILS                                                    
           MOVE ZEROS                    TO WS-CUR-FXR-POL-TAG-MCH      
                                            WS-CUR-FXR-ONLY-MCH         
                                            WS-CUR-POL-TAG-MCH          
                                            WS-WMS-POINT-NO             
           MOVE 'INSTALL'                TO WS-TASK-WORK-FLOW           
           MOVE SPACES                   TO WS-MATCHED-POLE-TAG-NO      
           MOVE 'I'                      TO WS-REQ-ACTION-CD            
                                            WS-REQ-ACTION-CD1           
                                            WS-REQ-ACTION-CD2           
           PERFORM 2100-FIRM-CURR-FXR-MATCH  THRU 2100-EXIT             
              VARYING WS-REQ-SUB FROM WS-REQ-ROW-COUNT BY -1            
              UNTIL WS-REQ-SUB < 1 OR WS-CUR-FXR-POL-TAG-MCH > 0        
                                                                        
           IF WS-CUR-FXR-POL-TAG-MCH = 0 AND SINGLE-POINT-ORDER         
              PERFORM 2105-SOFT-CURR-FXR-MATCH  THRU 2105-EXIT          
                 VARYING WS-REQ-SUB FROM WS-REQ-ROW-COUNT BY -1         
                 UNTIL WS-REQ-SUB < 1 OR WS-CUR-FXR-POL-TAG-MCH > 0     
           END-IF                                                       
                                                                        
           IF WS-WMS-POINT-NO > 0                                       
              PERFORM 2120-FIND-CURR-POLE-MATCH THRU 2120-EXIT          
                 VARYING WS-REQ-SUB FROM WS-REQ-ROW-COUNT BY -1         
                   UNTIL WS-REQ-SUB < 1                                 
                      OR WS-CUR-POL-TAG-MCH > 0                         
           END-IF                                                       
                                                                        
           IF WS-CUR-FXR-POL-TAG-MCH > 0                                
              MOVE 'M'            TO SCN-LOCAL-ACTION(WS-SCN-SUB)       
              MOVE WS-CUR-FXR-POL-TAG-MCH     TO WS-REQ-SUB             
              PERFORM 2210-ADD-CURR-FXR-DATA  THRU 2210-EXIT            
              IF WS-CUR-POL-TAG-MCH > 0                                 
                 MOVE WS-CUR-POL-TAG-MCH      TO WS-REQ-SUB             
                 PERFORM 2230-ADD-CURR-POL-DATA   THRU 2230-EXIT        
              END-IF                                                    
           ELSE                                                         
              MOVE 'N'            TO SCN-LOCAL-ACTION(WS-SCN-SUB)       
              EVALUATE TRUE                                             
                 WHEN SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB) = ZEROS          
                    MOVE 'N0'   TO SCN-MISMATCH-TYPE (WS-SCN-SUB)       
                 WHEN WS-CUR-FXR-ONLY-MCH > 0                           
                    MOVE 'P0'   TO SCN-MISMATCH-TYPE (WS-SCN-SUB)       
                 WHEN OTHER                                             
                    MOVE 'F0'   TO SCN-MISMATCH-TYPE (WS-SCN-SUB)       
              END-EVALUATE                                              
           END-IF.                                                      
                                                                        
      ***  CHECK CHECK IC DETAILS IN CUST PLAN                                  
      ***  CREATE LIGHT ENVIRONMENT                                             
      ***  CREATE FIXTURE/POLE ATTACHMENT                                       
      ***  CREATE FIXUTE/NODE ATTACHMENT                                        
                                                                        
       1600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1800-MATCH-REPAIR.                                               
      *================================================================*        
                                                                        
           MOVE ZEROS                    TO WS-CUR-FXR-POL-TAG-MCH      
                                            WS-CUR-POL-TAG-MCH          
                                            WS-WMS-POINT-NO             
           MOVE 'REPAIR'                 TO WS-TASK-WORK-FLOW           
           PERFORM VARYING WS-REQ-SUB FROM WS-REQ-ROW-COUNT BY -1       
              UNTIL WS-REQ-SUB < 1                                      
              MOVE REQ-WORK-TYPE-CD (WS-REQ-SUB) TO WS-WORK-TYPE-SW     
              IF REQ-SOURCE-APPL-CD (WS-REQ-SUB) = 'CIS'                
                 AND REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = 'S'           
                 AND WORK-TYPE-REPAIR                                   
      ***        AND REQ-LOCAL-ACTION (WS-REQ-SUB) = ' '                        
                    MOVE WS-REQ-SUB      TO WS-CUR-FXR-POL-TAG-MCH      
                    MOVE REQ-WMS-POINT-NO (WS-REQ-SUB)                  
                                         TO WS-WMS-POINT-NO             
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           IF WS-CUR-FXR-POL-TAG-MCH > 0                                
              MOVE 'M'            TO SCN-LOCAL-ACTION(WS-SCN-SUB)       
              MOVE WS-CUR-FXR-POL-TAG-MCH     TO WS-REQ-SUB             
              PERFORM 2210-ADD-CURR-FXR-DATA  THRU 2210-EXIT            
           ELSE                                                         
              MOVE 'N'         TO SCN-LOCAL-ACTION(WS-SCN-SUB)          
           END-IF.                                                      
           .                                                            
       1800-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       2210-ADD-CURR-FXR-DATA.                                          
      *================================================================*        
                                                                        
           MOVE 'M' TO REQ-LOCAL-ACTION (WS-REQ-SUB)                    
           MOVE REQ-WMS-POINT-NO (WS-REQ-SUB) TO                        
                                      SCN-WMS-POINT-CUR (WS-SCN-SUB)    
           MOVE ZEROS              TO SCN-WMS-POINT-OLD (WS-SCN-SUB)    
           MOVE REQ-REQUEST-ACTION-TS (WS-REQ-SUB) TO                   
                                      SCN-REQUEST-ACTION-TS (WS-SCN-SUB)
                                                                        
           MOVE REQ-RATE-PLAN-NO  (WS-REQ-SUB) TO                       
                                  SCN-FXTR-RATE-PLAN-CUR (WS-SCN-SUB)   
           MOVE REQ-RATE-ITEM-CODE (WS-REQ-SUB) TO                      
                                  SCN-FXTR-RATE-ITEM-CUR (WS-SCN-SUB)   
           MOVE REQ-LOCAL-OFFICE (WS-REQ-SUB) TO                        
                                  SCN-LOCAL-OFFICE (WS-SCN-SUB)         
           MOVE REQ-REQUEST-ACTION-CD (WS-REQ-SUB)                      
                                 TO SCN-FXTR-WMS-ST-CUR (WS-SCN-SUB)    
      *** CHECK ACCOUNT NO EXISTS OR NOT                                        
           MOVE ZEROS              TO AT-PREMISE-NO                     
                                      SCN-ACCOUNT-NO (WS-SCN-SUB)       
           IF REQ-ACCOUNT-NO (WS-REQ-SUB) IS NUMERIC                    
              AND REQ-ACCOUNT-NO (WS-REQ-SUB) > 0                       
              MOVE REQ-ACCOUNT-NO (WS-REQ-SUB) TO AT-ACCOUNT-NO         
                                                                        
              PERFORM 7000-GET-PREMISE   THRU 7000-EXIT                 
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF AT-CODE-ACCT-STAT = 'A' OR 'P'                      
                    CONTINUE                                            
                 ELSE                                                   
                    MOVE AT-PREMISE-NO     TO WS-CPD99-PREMISE-NO       
                    PERFORM 6990-FETCH-CUR-ACCOUNT  THRU  6990-EXIT     
                    IF WS-CPD99-ACCOUNT-NO = AT-ACCOUNT-NO              
                       CONTINUE                                         
                    ELSE                                                
                       MOVE WS-CPD99-ACCOUNT-NO                         
                                           TO AT-ACCOUNT-NO             
A05084                 PERFORM 7000-GET-PREMISE                         
A05084                    THRU 7000-EXIT                                
                    END-IF                                              
                 END-IF                                                 
                 MOVE AT-ACCOUNT-NO   TO SCN-ACCOUNT-NO (WS-SCN-SUB)    
                 MOVE AT-LOCAL-OFFICE TO SCN-LOCAL-OFFICE (WS-SCN-SUB)  
              ELSE                                                      
                 MOVE ZEROS           TO REQ-ACCOUNT-NO (WS-REQ-SUB)    
                                         AT-ACCOUNT-NO                  
A05084           MOVE REQ-LOCAL-OFFICE (WS-REQ-SUB)                     
A05084                           TO  SCN-LOCAL-OFFICE (WS-SCN-SUB)      
              END-IF                                                    
A05084     ELSE                                                         
A05084           MOVE ZEROS           TO REQ-ACCOUNT-NO (WS-REQ-SUB)    
A05084                                   AT-ACCOUNT-NO                  
A05084           MOVE REQ-LOCAL-OFFICE (WS-REQ-SUB)                     
A05084                           TO  SCN-LOCAL-OFFICE (WS-SCN-SUB)      
           END-IF.                                                      
           .                                                            
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2220-ADD-OLD-FXR-DATA.                                           
      *================================================================*        
                                                                        
           MOVE 'M' TO REQ-LOCAL-ACTION (WS-REQ-SUB)                    
                                                                        
           MOVE REQ-WMS-POINT-NO (WS-REQ-SUB) TO                        
                                      SCN-WMS-POINT-OLD (WS-SCN-SUB)    
           MOVE REQ-RATE-PLAN-NO  (WS-REQ-SUB) TO                       
                                  SCN-FXTR-RATE-PLAN-OLD (WS-SCN-SUB)   
           MOVE REQ-RATE-ITEM-CODE (WS-REQ-SUB) TO                      
                                  SCN-FXTR-RATE-ITEM-OLD (WS-SCN-SUB)   
           MOVE REQ-REQUEST-ACTION-CD (WS-REQ-SUB)                      
                                 TO SCN-FXTR-WMS-ST-OLD (WS-SCN-SUB).   
      *                                                                         
       2220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2230-ADD-CURR-POL-DATA.                                          
      *================================================================*        
                                                                        
           MOVE 'M' TO REQ-LOCAL-ACTION (WS-REQ-SUB)                    
                                                                        
           MOVE REQ-RATE-PLAN-NO  (WS-REQ-SUB) TO                       
                                  SCN-POLE-RATE-PLAN-CUR (WS-SCN-SUB)   
           MOVE REQ-RATE-ITEM-CODE (WS-REQ-SUB) TO                      
                                  SCN-POLE-RATE-ITEM-CUR (WS-SCN-SUB)   
           MOVE REQ-STOCK-CD (WS-REQ-SUB) TO                            
                                  SCN-POLE-STOCK-CUR (WS-SCN-SUB).      
           MOVE REQ-REQUEST-ACTION-CD (WS-REQ-SUB)                      
                                 TO SCN-POLE-WMS-ST-CUR (WS-SCN-SUB).   
                                                                        
       2230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2240-ADD-OLD-POL-DATA.                                           
      *================================================================*        
                                                                        
           MOVE 'M' TO REQ-LOCAL-ACTION (WS-REQ-SUB)                    
                                                                        
           MOVE REQ-RATE-PLAN-NO  (WS-REQ-SUB) TO                       
                                  SCN-POLE-RATE-PLAN-OLD  (WS-SCN-SUB)  
           MOVE REQ-RATE-ITEM-CODE (WS-REQ-SUB) TO                      
                                  SCN-POLE-RATE-ITEM-OLD  (WS-SCN-SUB)  
           MOVE REQ-STOCK-CD (WS-REQ-SUB) TO                            
                                  SCN-POLE-STOCK-OLD  (WS-SCN-SUB).     
           MOVE REQ-REQUEST-ACTION-CD (WS-REQ-SUB)                      
                                 TO SCN-POLE-WMS-ST-OLD (WS-SCN-SUB).   
                                                                        
       2240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2100-FIRM-CURR-FXR-MATCH.                                        
      *================================================================*        
                                                                        
           IF (REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = WS-REQ-ACTION-CD    
            OR REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = WS-REQ-ACTION-CD1   
            OR REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = WS-REQ-ACTION-CD2)  
              AND REQ-LOCAL-ACTION (WS-REQ-SUB)   = ' '                 
              AND REQ-RECORD-TYPE-CD (WS-REQ-SUB) = 'F'                 
                                                                        
              AND REQ-STOCK-CD (WS-REQ-SUB) = SCN-FXTR-STOCK-CUR        
                                                      (WS-SCN-SUB)      
              MOVE WS-REQ-SUB      TO WS-CUR-FXR-ONLY-MCH               
              IF REQ-POLE-TAG-NO (WS-REQ-SUB) = SCN-POLE-TAG-NO-CUR     
                                                    (WS-SCN-SUB)        
                    MOVE REQ-POLE-TAG-NO (WS-REQ-SUB)                   
                                         TO                             
                                  SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)      
                                  WS-MATCHED-POLE-TAG-NO                
                    MOVE WS-REQ-SUB      TO WS-CUR-FXR-POL-TAG-MCH      
                    MOVE REQ-WMS-POINT-NO (WS-REQ-SUB)                  
                                         TO WS-WMS-POINT-NO             
                    MOVE 'M'       TO REQ-LOCAL-ACTION (WS-REQ-SUB)     
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2105-SOFT-CURR-FXR-MATCH.                                        
      *================================================================*        
                                                                        
           IF (REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = WS-REQ-ACTION-CD    
            OR REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = WS-REQ-ACTION-CD1   
            OR REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = WS-REQ-ACTION-CD2)  
               AND REQ-LOCAL-ACTION (WS-REQ-SUB) = ' '                  
                                                                        
              IF REQ-STOCK-CD (WS-REQ-SUB) = SCN-FXTR-STOCK-CUR         
                                                      (WS-SCN-SUB)      
                 AND REQ-RECORD-TYPE-CD (WS-REQ-SUB) = 'F'              
                    MOVE REQ-POLE-TAG-NO (WS-REQ-SUB)                   
                                         TO                             
                                  SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)      
                                  WS-MATCHED-POLE-TAG-NO                
                    MOVE WS-REQ-SUB      TO WS-CUR-FXR-POL-TAG-MCH      
                    MOVE REQ-WMS-POINT-NO (WS-REQ-SUB)                  
                                         TO WS-WMS-POINT-NO             
                    MOVE 'M'       TO REQ-LOCAL-ACTION (WS-REQ-SUB)     
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2105-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2110-FIRM-OLD-FXR-MATCH.                                         
      *================================================================*        
                                                                        
           IF (REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = 'R'                 
               OR REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = 'S'              
               OR REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = 'A')             
               AND REQ-LOCAL-ACTION (WS-REQ-SUB) = ' '                  
               AND REQ-RECORD-TYPE-CD (WS-REQ-SUB) = 'F'                
               AND REQ-STOCK-CD (WS-REQ-SUB) = SCN-FXTR-STOCK-OLD       
                                                      (WS-SCN-SUB)      
               MOVE WS-REQ-SUB      TO WS-OLD-FXR-ONLY-MCH              
               IF REQ-POLE-TAG-NO (WS-REQ-SUB) = SCN-POLE-TAG-NO-OLD    
                                                    (WS-SCN-SUB)        
                 AND REQ-WMS-POINT-NO (WS-REQ-SUB)                      
                                              = WS-WMS-POINT-NO         
                  MOVE REQ-POLE-TAG-NO (WS-REQ-SUB)                     
                                         TO                             
                                  SCN-REQ-POLE-NO-OLD (WS-SCN-SUB)      
                                  WS-MATCHED-POLE-TAG-NO                
                  MOVE WS-REQ-SUB      TO WS-OLD-FXR-POL-TAG-MCH        
                  MOVE WS-WMS-POINT-NO TO WS-WMS-POINT-NO-OLD           
                  MOVE 'M'         TO REQ-LOCAL-ACTION (WS-REQ-SUB)     
               END-IF                                                   
           END-IF.                                                      
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2111-OLD-FXR-POLE-ONLY-MCH.                                      
      *================================================================*        
                                                                        
           IF (REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = 'R'                 
               OR REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = 'S'              
               OR REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = 'A')             
               AND REQ-LOCAL-ACTION (WS-REQ-SUB) = ' '                  
               AND REQ-RECORD-TYPE-CD (WS-REQ-SUB) = 'F'                
               AND (REQ-STOCK-CD (WS-REQ-SUB) = SCN-FXTR-STOCK-OLD      
                                                      (WS-SCN-SUB)      
                    OR SCN-FXTR-STOCK-OLD (WS-SCN-SUB) = SPACES)        
               MOVE WS-REQ-SUB      TO WS-OLD-FXR-ONLY-MCH              
               IF REQ-POLE-TAG-NO (WS-REQ-SUB) = SCN-POLE-TAG-NO-OLD    
                                                    (WS-SCN-SUB)        
                 AND REQ-WMS-POINT-NO (WS-REQ-SUB)                      
                                              = WS-WMS-POINT-NO         
                  MOVE REQ-POLE-TAG-NO (WS-REQ-SUB)                     
                                         TO                             
                                  SCN-REQ-POLE-NO-OLD (WS-SCN-SUB)      
                                  WS-MATCHED-POLE-TAG-NO                
                  MOVE WS-REQ-SUB      TO WS-OLD-FXR-POL-TAG-MCH        
                  MOVE WS-WMS-POINT-NO TO WS-WMS-POINT-NO-OLD           
                  MOVE 'M'         TO REQ-LOCAL-ACTION (WS-REQ-SUB)     
               END-IF                                                   
           END-IF.                                                      
                                                                        
       2111-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2112-NOPOINT-OLD-FXR-MATCH.                                      
      *================================================================*        
                                                                        
           IF (REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = 'R'                 
               OR REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = 'S'              
               OR REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = 'A')             
               AND REQ-LOCAL-ACTION (WS-REQ-SUB) = ' '                  
               AND REQ-RECORD-TYPE-CD (WS-REQ-SUB) = 'F'                
               AND REQ-STOCK-CD (WS-REQ-SUB) = SCN-FXTR-STOCK-OLD       
                                                      (WS-SCN-SUB)      
               MOVE WS-REQ-SUB      TO WS-OLD-FXR-ONLY-MCH              
               IF REQ-POLE-TAG-NO (WS-REQ-SUB) = SCN-POLE-TAG-NO-OLD    
                                                    (WS-SCN-SUB)        
                  MOVE REQ-POLE-TAG-NO (WS-REQ-SUB)                     
                                         TO                             
                                  SCN-REQ-POLE-NO-OLD (WS-SCN-SUB)      
                                  WS-MATCHED-POLE-TAG-NO                
                  MOVE WS-REQ-SUB      TO WS-OLD-FXR-POL-TAG-MCH        
                  MOVE REQ-WMS-POINT-NO (WS-REQ-SUB)                    
                                         TO WS-WMS-POINT-NO-OLD         
                  MOVE 'M'         TO REQ-LOCAL-ACTION (WS-REQ-SUB)     
               END-IF                                                   
           END-IF.                                                      
                                                                        
       2112-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2113-NOPOINT-FXR-POLE-ONLY.                                      
      *================================================================*        
                                                                        
           IF (REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = 'R'                 
               OR REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = 'S'              
               OR REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = 'A')             
               AND REQ-LOCAL-ACTION (WS-REQ-SUB) = ' '                  
               AND REQ-RECORD-TYPE-CD (WS-REQ-SUB) = 'F'                
               AND (REQ-STOCK-CD (WS-REQ-SUB) = SCN-FXTR-STOCK-OLD      
                                                      (WS-SCN-SUB)      
                    OR SCN-FXTR-STOCK-OLD (WS-SCN-SUB) = SPACES)        
               MOVE WS-REQ-SUB      TO WS-OLD-FXR-ONLY-MCH              
               IF REQ-POLE-TAG-NO (WS-REQ-SUB) = SCN-POLE-TAG-NO-OLD    
                                                    (WS-SCN-SUB)        
                  MOVE REQ-POLE-TAG-NO (WS-REQ-SUB)                     
                                         TO                             
                                  SCN-REQ-POLE-NO-OLD (WS-SCN-SUB)      
                                  WS-MATCHED-POLE-TAG-NO                
                  MOVE WS-REQ-SUB      TO WS-OLD-FXR-POL-TAG-MCH        
                  MOVE REQ-WMS-POINT-NO (WS-REQ-SUB)                    
                                         TO WS-WMS-POINT-NO-OLD         
                  MOVE 'M'         TO REQ-LOCAL-ACTION (WS-REQ-SUB)     
               END-IF                                                   
           END-IF.                                                      
                                                                        
       2113-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2115-SOFT-OLD-FXR-MATCH.                                         
      *================================================================*        
                                                                        
           IF (REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = 'R'                 
               OR REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = 'S'              
               OR REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = 'A')             
               AND REQ-LOCAL-ACTION (WS-REQ-SUB) = ' '                  
              IF REQ-STOCK-CD (WS-REQ-SUB) = SCN-FXTR-STOCK-OLD         
                                                      (WS-SCN-SUB)      
                 AND REQ-RECORD-TYPE-CD (WS-REQ-SUB) = 'F'              
                 AND REQ-WMS-POINT-NO (WS-REQ-SUB)                      
                                              = WS-WMS-POINT-NO         
                    MOVE REQ-POLE-TAG-NO (WS-REQ-SUB)                   
                                         TO                             
                                  SCN-REQ-POLE-NO-OLD (WS-SCN-SUB)      
                                  WS-MATCHED-POLE-TAG-NO                
                    MOVE WS-REQ-SUB      TO WS-OLD-FXR-POL-TAG-MCH      
                    MOVE WS-WMS-POINT-NO TO WS-WMS-POINT-NO-OLD         
                    MOVE 'M'       TO REQ-LOCAL-ACTION (WS-REQ-SUB)     
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2115-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2120-FIND-CURR-POLE-MATCH.                                       
      *================================================================*        
                                                                        
           IF (REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = WS-REQ-ACTION-CD    
            OR REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = WS-REQ-ACTION-CD1   
            OR REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = WS-REQ-ACTION-CD2)  
               AND REQ-LOCAL-ACTION (WS-REQ-SUB) = ' '                  
              IF REQ-POLE-TAG-NO (WS-REQ-SUB) = WS-MATCHED-POLE-TAG-NO  
                 AND REQ-WMS-POINT-NO (WS-REQ-SUB)                      
                                              = WS-WMS-POINT-NO         
                 AND REQ-RECORD-TYPE-CD (WS-REQ-SUB) = 'P'              
                 MOVE WS-REQ-SUB      TO WS-CUR-POL-TAG-MCH             
                 MOVE 'M'          TO REQ-LOCAL-ACTION (WS-REQ-SUB)     
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2130-FIND-OLD-POLE-MATCH.                                        
      *================================================================*        
                                                                        
           IF (REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = 'R'                 
               OR REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = 'S'              
               OR REQ-REQUEST-ACTION-CD (WS-REQ-SUB) = 'A')             
               AND REQ-LOCAL-ACTION (WS-REQ-SUB) = ' '                  
              IF REQ-POLE-TAG-NO (WS-REQ-SUB) = WS-MATCHED-POLE-TAG-NO  
                 AND REQ-WMS-POINT-NO (WS-REQ-SUB)                      
                                              = WS-WMS-POINT-NO-OLD     
                 AND REQ-RECORD-TYPE-CD (WS-REQ-SUB) = 'P'              
                 MOVE WS-REQ-SUB      TO WS-OLD-POL-TAG-MCH             
                 MOVE 'M'          TO REQ-LOCAL-ACTION (WS-REQ-SUB)     
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3000-PROCESS-MATCHED-DATA.                                       
      *================================================================*        
                                                                        
           PERFORM VARYING WS-SCN-SUB FROM 1 BY 1                       
              UNTIL WS-SCN-SUB > WS-SCN-ROW-COUNT                       
              IF SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB) = 'C'               
                 AND SCN-LOCAL-ACTION(WS-SCN-SUB) = 'M'                 
      ***         /* REPLACE/CHANGE */                                          
                 MOVE 'REPLACE'                  TO WS-TASK-WORK-FLOW   
                 PERFORM 3300-PROCESS-REPLACES   THRU 3300-EXIT         
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           PERFORM VARYING WS-SCN-SUB FROM 1 BY 1                       
              UNTIL WS-SCN-SUB > WS-SCN-ROW-COUNT                       
              IF SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB) = 'M'               
                 AND SCN-LOCAL-ACTION(WS-SCN-SUB) = 'M'                 
      ***         /* RELOCATE */                                                
                 MOVE 'RELOCATE'                 TO WS-TASK-WORK-FLOW   
                 PERFORM 3300-PROCESS-REPLACES   THRU 3300-EXIT         
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           PERFORM VARYING WS-SCN-SUB FROM 1 BY 1                       
              UNTIL WS-SCN-SUB > WS-SCN-ROW-COUNT                       
              IF SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB) = 'D'               
                 AND SCN-LOCAL-ACTION(WS-SCN-SUB) = 'M'                 
      ***         /* REMOVE/DELETE */                                           
                 PERFORM 3200-PROCESS-REMOVES    THRU 3200-EXIT         
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           PERFORM VARYING WS-SCN-SUB FROM 1 BY 1                       
              UNTIL WS-SCN-SUB > WS-SCN-ROW-COUNT                       
              IF SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB) = 'I'               
                 AND SCN-LOCAL-ACTION(WS-SCN-SUB) = 'M'                 
      ***         /* INSTALL */                                                 
                 PERFORM 3100-PROCESS-INSTALLS   THRU 3100-EXIT         
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           PERFORM VARYING WS-SCN-SUB FROM 1 BY 1                       
              UNTIL WS-SCN-SUB > WS-SCN-ROW-COUNT                       
              IF SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB) = 'R'               
                 AND SCN-LOCAL-ACTION(WS-SCN-SUB) = 'M'                 
      ***         /* REPAIR  */                                                 
                 PERFORM 3400-PROCESS-REPAIRS    THRU 3400-EXIT         
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           PERFORM VARYING WS-SCN-SUB FROM 1 BY 1                       
              UNTIL WS-SCN-SUB > WS-SCN-ROW-COUNT                       
              IF SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB) = 'A'               
                 AND SCN-LOCAL-ACTION(WS-SCN-SUB) = 'M'                 
      ***         /* AUDIT */                                                   
                 PERFORM 3500-PROCESS-AUDITS     THRU 3500-EXIT         
              END-IF                                                    
           END-PERFORM                                                  
           .                                                            
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3100-PROCESS-INSTALLS.                                           
      *================================================================*        
                                                                        
           MOVE 'INSTALL'                TO WS-TASK-WORK-FLOW           
           SET NO-TASK-CREATED           TO TRUE                        
           IF AT-PREMISE-NO > 0                                         
              MOVE AT-PREMISE-NO         TO WS-PREMISE-NO-NUM           
           ELSE                                                         
      ***     CREATE WQ: ACCOUNT NEEDED                                         
              SET TASK-CREATED           TO TRUE                        
              MOVE SCN-FXTR-SEQ-NO-CUR  (WS-SCN-SUB)                    
                                         TO WS-TASK-FXTR-SEQ-NO         
              MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                     
                                         TO WS-TASK-FXTR-TAG-NO         
              PERFORM 5705-CREATE-ACC-REQ-TASK THRU 5705-EXIT           
           END-IF.                                                      
      *** CHECK FIXTURE INVENTORY                                               
           IF SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB) = ZERO                   
              AND NO-TASK-CREATED                                       
      ***     CREATE WQ: FIXTURE NOT IN INVENTORY                               
              SET TASK-CREATED           TO TRUE                        
              PERFORM 5710-TASK-FXTR-NOT-INVENTORY THRU 5710-EXIT       
           END-IF.                                                      
      *** CHECK FIXTURE INVENTORY STATUS                                        
           IF (SCN-FXTR-INV-ST-CUR (WS-SCN-SUB) = 'J'                   
               OR SCN-FXTR-INS-LOC-NO-CUR (WS-SCN-SUB) > SPACES)        
              AND NO-TASK-CREATED                                       
      ***     CREATE WQ: FXTR IS WITH INSTALLED STATUS                          
              SET TASK-CREATED           TO TRUE                        
              PERFORM 5715-TASK-FXTR-INSTALLED THRU 5715-EXIT           
           END-IF.                                                      
      *** FIXTURE RATE VALIDATION                                               
           MOVE SPACES                   TO UP-CODE-UTIL-TYPE           
           IF NO-TASK-CREATED                                           
              MOVE SCN-FXTR-RATE-ITEM-CUR   (WS-SCN-SUB)                
                                         TO UP-RATE-ITEM-CODE           
              MOVE SCN-FXTR-RATE-PLAN-CUR   (WS-SCN-SUB)                
                                         TO UP-RATE-PLAN-NO             
              MOVE SCN-FXTR-SEQ-NO-CUR  (WS-SCN-SUB)                    
                                         TO WS-TASK-FXTR-SEQ-NO         
              MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                     
                                         TO WS-TASK-FXTR-TAG-NO         
              MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                     
                                         TO WS-TASK-POLE-TAG-NO         
              PERFORM 3600-VALIDATE-RATE    THRU 3600-EXIT              
           END-IF                                                       
           MOVE UP-CODE-UTIL-TYPE        TO                             
                                SCN-FXTR-UTIL-TYPE-CUR (WS-SCN-SUB)     
           IF SCN-REQ-POLE-NO-CUR (WS-SCN-SUB) = SPACES                 
      ***     CREATE WQ: POLE TAG REQUIRED                                      
              AND NO-TASK-CREATED                                       
              SET TASK-CREATED           TO TRUE                        
              MOVE ZEROS                 TO WS-TASK-FXTR-SEQ-NO         
              MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                     
                                         TO WS-TASK-FXTR-TAG-NO         
              PERFORM 5725-TASK-POLE-TAG-REQ   THRU 5725-EXIT           
           END-IF.                                                      
      ***  NODE VALIDATION                                                      
           IF NO-TASK-CREATED AND                                       
              SCN-NODE-TAG-NO-CUR (WS-SCN-SUB) > SPACES                 
              MOVE SCN-NODE-TAG-NO-CUR (WS-SCN-SUB)                     
                                         TO 4D-EQUIP-TAG-NO             
              PERFORM 7038-GET-NODE-SEQ        THRU 7038-EXIT           
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 AND 4D-INVENTRY-STATUS-CD NOT = 'J'                    
                 MOVE 4D-EQUIP-SEQ       TO                             
                                   SCN-NODE-SEQ-NO-CUR (WS-SCN-SUB)     
              ELSE                                                      
      ***        CREATE WQ: NODE NOT IN INVENTORY OR NOT INV STATUS             
                 SET TASK-CREATED           TO TRUE                     
                 MOVE ZEROS                 TO WS-TASK-FXTR-SEQ-NO      
                 MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                  
                                         TO WS-TASK-FXTR-TAG-NO         
                 PERFORM 5730-TASK-NODE-NOT-EXITS  THRU 5730-EXIT       
              END-IF                                                    
           END-IF                                                       
      ***  POLE VALIDATION                                                      
           IF NO-TASK-CREATED                                           
              PERFORM 3310-VALIDATE-NEW-POLE   THRU 3310-EXIT           
           END-IF                                                       
           IF NO-TASK-CREATED                                           
      ***  SETUP NEW POLE ENVIRONMENT                                           
              PERFORM 3130-SETUP-POLE-ENV      THRU 3130-EXIT           
      ***  SETUP NEW FIXTURE ENVIRONMENT                                        
              PERFORM 3150-SETUP-FXTR-ENV      THRU 3150-EXIT           
              MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                     
                                         TO 4D-EQUIP-SEQ                
                                            4H-FXTR-EQUIP-SEQ           
              MOVE 'J'                   TO 4D-INVENTRY-STATUS-CD       
              PERFORM 8120-UPDATE-LMS-INVENTORY THRU 8120-EXIT          
              MOVE SCN-POLE-SEQ-NO-CUR (WS-SCN-SUB)                     
                                         TO 4D-EQUIP-SEQ                
                                            4H-ATTACH-EQUIP-SEQ         
              PERFORM 8120-UPDATE-LMS-INVENTORY THRU 8120-EXIT          
              PERFORM 7015-GET-MAX-ATTACH-SEQ  THRU 7015-EXIT           
              MOVE 'P'                   TO 4H-EQUIP-TYPE-CD            
              MOVE SCN-REQUEST-ACTION-TS (WS-SCN-SUB) (1:10)            
                                         TO 4H-ATTACH-EQUIP-DT          
              PERFORM 8200-INSERT-FXTR-ATTACHMTS THRU 8200-EXIT         
              IF SCN-NODE-SEQ-NO-CUR (WS-SCN-SUB) > 0                   
                 MOVE SCN-NODE-SEQ-NO-CUR (WS-SCN-SUB)                  
                                         TO 4H-ATTACH-EQUIP-SEQ         
                 COMPUTE 4H-ATTACH-SEQ-NO = 4H-ATTACH-SEQ-NO + 1        
                 MOVE 'N'                TO 4H-EQUIP-TYPE-CD            
                 PERFORM 8200-INSERT-FXTR-ATTACHMTS THRU 8200-EXIT      
              END-IF                                                    
      ***     CREATE APPROVAL TASK                                              
              MOVE SCN-FXTR-SEQ-NO-CUR  (WS-SCN-SUB)                    
                                         TO WS-TASK-FXTR-SEQ-NO         
              MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                     
                                         TO WS-TASK-FXTR-TAG-NO         
              PERFORM 5700-TASK-APPROVAL-REQ  THRU 5700-EXIT            
              PERFORM 3180-INSTALL-TX-HIST    THRU 3180-EXIT            
           ELSE                                                         
              MOVE 'E'            TO SCN-LOCAL-ACTION(WS-SCN-SUB)       
           END-IF.                                                      
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      *================================================================*        
       3130-SETUP-POLE-ENV.                                             
      *================================================================*        
                                                                        
           MOVE WS-PREMISE-NO-NUM        TO 4F-INSTALL-LOC-NO           
                                 SCN-POLE-INS-LOC-NO-CUR (WS-SCN-SUB)   
           PERFORM 7010-GET-MAX-POINT    THRU 7010-EXIT                 
           MOVE 4F-INSTALL-POINT-NO      TO                             
                              SCN-POLE-INS-POINT-NO-CUR (WS-SCN-SUB)    
           MOVE SCN-POLE-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO 4F-EQUIP-SEQ                
           MOVE SCN-POLE-RATE-ITEM-CUR   (WS-SCN-SUB)                   
                                         TO 4F-RATE-ITEM-CODE           
           MOVE SCN-POLE-RATE-PLAN-CUR   (WS-SCN-SUB)                   
                                         TO 4F-RATE-PLAN-NO             
           MOVE SCN-POLE-UTIL-TYPE-CUR (WS-SCN-SUB)                     
                                         TO 4F-CODE-UTIL-TYPE           
           MOVE 'P'                      TO 4F-INSTALL-LOC-CD           
           MOVE ZERO                     TO 4F-IC-NO                    
           MOVE ZERO                     TO 4F-ITEM-SEQ-NO              
           IF 4F-RATE-PLAN-NO = SPACES                                  
              MOVE 'N'                   TO 4F-BILLING-FL               
           ELSE                                                         
              MOVE 'Z'                   TO 4F-BILLING-FL               
           END-IF                                                       
           MOVE SPACES                   TO 4F-NO-BILL-REASON-CD        
           MOVE SPACES                   TO 4F-EQUIP-CONTRACT-FL        
           MOVE SPACES                   TO 4F-NO-CONTRACT-RSN-CD       
           MOVE SPACES                   TO 4F-EQUIP-OWNER-CD           
           MOVE SPACES                   TO 4F-EQUIP-DRAWING-ID         
           MOVE ZEROS                    TO 4F-EQUIP-GIS-GKEY           
           MOVE SCN-SOURCE-APPL-CD (WS-SCN-SUB) TO 4F-SOURCE-APPL-CD    
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                         TO 4F-SOURCE-APPL-REQ-NO       
           MOVE SCN-WMS-POINT-CUR (WS-SCN-SUB) TO 4F-WMS-POINT-NO       
           MOVE ZEROS                    TO WS-EQUIP-INSTALL-DT-IND     
           MOVE SCN-REQUEST-ACTION-TS (WS-SCN-SUB) (1:10)               
                                         TO 4F-EQUIP-INSTALL-DT         
           MOVE -1                       TO WS-APPROVED-TS-IND          
           MOVE SCN-TRANS-USERID (WS-SCN-SUB) TO 4F-INSTALL-USERID      
           MOVE SPACES                   TO 4F-APPROVED-TS              
                                            4F-APPROVER-USERID          
                                            4F-LAST-UPDATE-TS           
                                            4F-LAST-UPDATE-USERID       
                                            4F-SPCL-AGR-COMMENTS-TEXT   
                                            4F-EQUIP-COMMENTS-TEXT      
           MOVE ZERO                     TO 4F-SPCL-AGR-COMMENTS-LEN    
                                            4F-EQUIP-COMMENTS-LEN       
                                                                        
           PERFORM 8000-INSERT-LIGHT-ENV THRU 8000-EXIT                 
           .                                                            
       3130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3150-SETUP-FXTR-ENV.                                             
      *================================================================*        
                                                                        
           MOVE WS-PREMISE-NO-NUM        TO 4F-INSTALL-LOC-NO           
                                 SCN-FXTR-INS-LOC-NO-CUR (WS-SCN-SUB)   
           PERFORM 7010-GET-MAX-POINT    THRU 7010-EXIT                 
           MOVE 4F-INSTALL-POINT-NO      TO                             
                              SCN-FXTR-INS-POINT-NO-CUR (WS-SCN-SUB)    
           MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO 4F-EQUIP-SEQ                
           MOVE SCN-FXTR-RATE-ITEM-CUR   (WS-SCN-SUB)                   
                                         TO 4F-RATE-ITEM-CODE           
           MOVE SCN-FXTR-RATE-PLAN-CUR   (WS-SCN-SUB)                   
                                         TO 4F-RATE-PLAN-NO             
           MOVE SCN-FXTR-UTIL-TYPE-CUR (WS-SCN-SUB)                     
                                         TO 4F-CODE-UTIL-TYPE           
           MOVE 'P'                      TO 4F-INSTALL-LOC-CD           
           MOVE ZERO                     TO 4F-IC-NO                    
           MOVE ZERO                     TO 4F-ITEM-SEQ-NO              
           MOVE 'Z'                      TO 4F-BILLING-FL               
           MOVE SPACES                   TO 4F-NO-BILL-REASON-CD        
           MOVE 'Y'                      TO 4F-EQUIP-CONTRACT-FL        
           MOVE SPACES                   TO 4F-NO-CONTRACT-RSN-CD       
           MOVE SPACES                   TO 4F-EQUIP-OWNER-CD           
           MOVE SPACES                   TO 4F-EQUIP-DRAWING-ID         
           MOVE ZEROS                    TO 4F-EQUIP-GIS-GKEY           
           MOVE SCN-SOURCE-APPL-CD (WS-SCN-SUB) TO 4F-SOURCE-APPL-CD    
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                         TO 4F-SOURCE-APPL-REQ-NO       
           MOVE SCN-WMS-POINT-CUR (WS-SCN-SUB) TO 4F-WMS-POINT-NO       
           MOVE ZEROS                    TO WS-EQUIP-INSTALL-DT-IND     
           MOVE SCN-REQUEST-ACTION-TS (WS-SCN-SUB) (1:10)               
                                         TO 4F-EQUIP-INSTALL-DT         
           MOVE -1                       TO WS-APPROVED-TS-IND          
           MOVE SCN-TRANS-USERID (WS-SCN-SUB) TO 4F-INSTALL-USERID      
           MOVE SPACES                   TO 4F-APPROVED-TS              
                                            4F-APPROVER-USERID          
                                            4F-LAST-UPDATE-TS           
                                            4F-LAST-UPDATE-USERID       
                                            4F-SPCL-AGR-COMMENTS-TEXT   
                                            4F-EQUIP-COMMENTS-TEXT      
           MOVE ZERO                     TO 4F-SPCL-AGR-COMMENTS-LEN    
                                            4F-EQUIP-COMMENTS-LEN       
                                                                        
           PERFORM 8000-INSERT-LIGHT-ENV THRU 8000-EXIT                 
           .                                                            
       3150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3180-INSTALL-TX-HIST.                                            
      *================================================================*        
                                                                        
           INITIALIZE DCLLMS-TRANS-HIST                                 
                      DCLLMS-TRANS-HIST-DET.                            
           PERFORM 7045-GET-CURR-TS         THRU 7045-EXIT              
           MOVE 4J-TRANS-HIST-SEQ-NO     TO 4S-TRANS-HIST-SEQ-NO        
           MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO 4J-EQUIP-SEQ                
                                            4S-EQUIP-SEQ                
           MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                        
                                         TO 4J-EQUIP-TAG-NO             
           MOVE WS-PGM-NAME               TO 4J-APPL-PROGRAM-ID         
           MOVE SCN-REQUEST-ACTION-TS (WS-SCN-SUB) (1:10)               
                                          TO 4J-TRANS-DATE              
           MOVE SCN-SOURCE-APPL-CD (WS-SCN-SUB)                         
                                          TO 4J-SOURCE-APPL-CD          
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                          TO 4J-SOURCE-APPL-REQ-NO      
           MOVE SCN-WMS-POINT-CUR (WS-SCN-SUB)                          
                                          TO 4J-WMS-POINT-NO            
                                                                        
           MOVE SCN-FXTR-INS-LOC-NO-CUR  (WS-SCN-SUB)                   
                                          TO 4J-INSTALL-LOC-NO          
           MOVE SCN-FXTR-INS-POINT-NO-CUR  (WS-SCN-SUB)                 
                                          TO 4J-INSTALL-POINT-NO        
                                                                        
           MOVE SCN-ACCOUNT-NO (WS-SCN-SUB)                             
                                          TO 4J-ACCOUNT-NO              
      ***  TRANS COMMENTS START****                                             
           MOVE 1                          TO 4J-TRANS-COMMENTS-LEN     
           STRING 'FIXTURE/POLE: '            DELIMITED BY SIZE         
                  4J-EQUIP-TAG-NO             DELIMITED BY ' '          
                   '/'                        DELIMITED BY SIZE         
                  SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                      
                                              DELIMITED BY ' '          
                   ' NEW INSTALL APPROVAL REQUEST CREATED'              
                                              DELIMITED BY SIZE         
                 INTO 4J-TRANS-COMMENTS-TEXT                            
                 WITH POINTER 4J-TRANS-COMMENTS-LEN                     
                                                                        
           COMPUTE 4J-TRANS-COMMENTS-LEN = 4J-TRANS-COMMENTS-LEN  - 1   
      ***  TRANS COMMENTS END  ****                                             
                                                                        
           MOVE 'LM100'                   TO 4J-LAST-UPDATE-USERID      
                                             4S-LAST-UPDATE-USERID      
                                                                        
           PERFORM 8400-INS-LMS-TRN-HST    THRU 8400-EXIT.              
                                                                        
           MOVE SCN-POLE-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO 4J-EQUIP-SEQ                
                                            4S-EQUIP-SEQ                
           MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                        
                                         TO 4J-EQUIP-TAG-NO             
           MOVE SCN-POLE-INS-LOC-NO-CUR  (WS-SCN-SUB)                   
                                          TO 4J-INSTALL-LOC-NO          
           MOVE SCN-POLE-INS-POINT-NO-CUR  (WS-SCN-SUB)                 
                                          TO 4J-INSTALL-POINT-NO        
           PERFORM 8400-INS-LMS-TRN-HST    THRU 8400-EXIT.              
                                                                        
       3180-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       3200-PROCESS-REMOVES.                                            
      *================================================================*        
                                                                        
           MOVE 'REMOVE'                 TO WS-TASK-WORK-FLOW           
           SET NO-TASK-CREATED           TO TRUE                        
           IF AT-PREMISE-NO > 0 AND AT-CODE-ACCT-STAT NOT = 'P'         
              MOVE AT-PREMISE-NO         TO WS-PREMISE-NO-NUM           
           ELSE                                                         
      ***     CREATE WQ: ACCOUNT NEEDED                                         
              SET TASK-CREATED           TO TRUE                        
              MOVE SCN-FXTR-SEQ-NO-CUR  (WS-SCN-SUB)                    
                                         TO WS-TASK-FXTR-SEQ-NO         
              MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                     
                                         TO WS-TASK-FXTR-TAG-NO         
              PERFORM 5705-CREATE-ACC-REQ-TASK THRU 5705-EXIT           
           END-IF.                                                      
                                                                        
      *** FIXTURE RATE VALIDATION                                               
           MOVE SPACES                   TO UP-CODE-UTIL-TYPE           
           IF NO-TASK-CREATED                                           
              MOVE SCN-FXTR-RATE-ITEM-CUR   (WS-SCN-SUB)                
                                         TO UP-RATE-ITEM-CODE           
              MOVE SCN-FXTR-RATE-PLAN-CUR   (WS-SCN-SUB)                
                                         TO UP-RATE-PLAN-NO             
              MOVE SCN-FXTR-SEQ-NO-CUR  (WS-SCN-SUB)                    
                                         TO WS-TASK-FXTR-SEQ-NO         
              MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                     
                                         TO WS-TASK-FXTR-TAG-NO         
              MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                     
                                         TO WS-TASK-POLE-TAG-NO         
              PERFORM 3600-VALIDATE-RATE    THRU 3600-EXIT              
           END-IF                                                       
           MOVE UP-CODE-UTIL-TYPE        TO                             
                                SCN-FXTR-UTIL-TYPE-CUR (WS-SCN-SUB)     
      *** CHECK FIXTURE INVENTORY STATUS - SHOULD BE INSTALLED                  
      *** AT THIS LOCATION                                                      
           IF NO-TASK-CREATED                                           
              PERFORM 3420-CHECK-LIGHT-LOCATION THRU 3420-EXIT          
           END-IF.                                                      
                                                                        
           IF NO-TASK-CREATED                                           
              IF (SCN-FXTR-BILLING-FL-CUR (WS-SCN-SUB) = 'Y'            
                  OR SCN-FXTR-BILLING-FL-CUR (WS-SCN-SUB) = 'N')        
                 MOVE SCN-ACCOUNT-NO (WS-SCN-SUB)                       
                                         TO LM001-ACCOUNT-NO            
                 MOVE SCN-FXTR-INS-LOC-NO-CUR (WS-SCN-SUB)              
                                         TO LM001-INSTALL-LOC-NO        
                 MOVE SCN-FXTR-INS-POINT-NO-CUR (WS-SCN-SUB)            
                                         TO LM001-INSTALL-POINT-NO      
                 MOVE 4F-CODE-UTIL-TYPE     TO LM001-NEW-RATE-UTIL-TYPE 
                 MOVE SCN-FXTR-RATE-PLAN-CUR (WS-SCN-SUB)               
                                         TO LM001-NEW-RATE-PLAN-NO      
                 MOVE SCN-FXTR-RATE-ITEM-CUR (WS-SCN-SUB)               
                                         TO LM001-NEW-RATE-ITEM-CODE    
                 MOVE SPACES             TO LM001-CODE-REVENUE-CLASS    
                 MOVE SCN-REQUEST-ACTION-TS (WS-SCN-SUB)                
                                         TO LM001-ACTION-DATE           
                 MOVE 'R'                TO LM001-ACTION-CODE           
                 MOVE 'SYSTEM'           TO LM001-USER-ID               
                 MOVE PROGRAM-NAME       TO LM001-PROGRAM-NAME          
                 PERFORM 5500-CALL-CUST-PLAN-SYNC THRU 5500-EXIT        
              ELSE                                                      
                 MOVE SCN-FXTR-INS-LOC-NO-CUR (WS-SCN-SUB)              
                                 TO 4F-INSTALL-LOC-NO                   
                 MOVE SCN-FXTR-INS-POINT-NO-CUR (WS-SCN-SUB)            
                                 TO 4F-INSTALL-POINT-NO                 
                 PERFORM 8500-DELETE-EQUIP-ENVRNMT                      
                    THRU 8500-EXIT                                      
              END-IF                                                    
                                                                        
              IF SCN-POLE-RATE-PLAN-CUR (WS-SCN-SUB) > SPACES           
                 AND (SCN-POLE-BILLING-FL-CUR (WS-SCN-SUB) = 'Y'        
                   OR SCN-POLE-BILLING-FL-CUR (WS-SCN-SUB) = 'N')       
                 MOVE SCN-ACCOUNT-NO (WS-SCN-SUB)                       
                                         TO LM001-ACCOUNT-NO            
                 MOVE SCN-POLE-INS-LOC-NO-CUR (WS-SCN-SUB)              
                                         TO LM001-INSTALL-LOC-NO        
                 MOVE SCN-POLE-INS-POINT-NO-CUR (WS-SCN-SUB)            
                                         TO LM001-INSTALL-POINT-NO      
                 MOVE SCN-POLE-UTIL-TYPE-CUR (WS-SCN-SUB)               
                                         TO LM001-NEW-RATE-UTIL-TYPE    
                 MOVE SCN-POLE-RATE-PLAN-CUR (WS-SCN-SUB)               
                                         TO LM001-NEW-RATE-PLAN-NO      
                 MOVE SCN-POLE-RATE-ITEM-CUR (WS-SCN-SUB)               
                                         TO LM001-NEW-RATE-ITEM-CODE    
                 MOVE SPACES             TO LM001-CODE-REVENUE-CLASS    
                 MOVE SCN-REQUEST-ACTION-TS (WS-SCN-SUB)                
                                         TO LM001-ACTION-DATE           
                 MOVE 'R'                TO LM001-ACTION-CODE           
                 PERFORM 5500-CALL-CUST-PLAN-SYNC THRU 5500-EXIT        
              ELSE                                                      
                 IF SCN-POLE-INS-LOC-NO-CUR (WS-SCN-SUB) > SPACES       
                    MOVE SCN-POLE-INS-LOC-NO-CUR (WS-SCN-SUB)           
                                 TO 4F-INSTALL-LOC-NO                   
                    MOVE SCN-POLE-INS-POINT-NO-CUR (WS-SCN-SUB)         
                                 TO 4F-INSTALL-POINT-NO                 
                    PERFORM 8500-DELETE-EQUIP-ENVRNMT                   
                       THRU 8500-EXIT                                   
                 END-IF                                                 
              END-IF                                                    
      *** UPDATE FXTR AND POLE STATUS TO INVENTORY                              
              MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                     
                                         TO 4D-EQUIP-SEQ                
                                            4H-FXTR-EQUIP-SEQ           
              IF SCN-FXTR-WMS-ST-CUR (WS-SCN-SUB) = 'S'                 
                 OR SCN-FXTR-WMS-ST-CUR (WS-SCN-SUB) = 'A'              
                 MOVE SCN-FXTR-WMS-ST-CUR (WS-SCN-SUB)                  
                                         TO 4D-INVENTRY-STATUS-CD       
              ELSE                                                      
                 MOVE 'I'                TO 4D-INVENTRY-STATUS-CD       
              END-IF                                                    
              PERFORM 8120-UPDATE-LMS-INVENTORY THRU 8120-EXIT          
              MOVE SCN-POLE-SEQ-NO-CUR (WS-SCN-SUB)                     
                                         TO 4D-EQUIP-SEQ                
                                            4H-ATTACH-EQUIP-SEQ         
              IF SCN-POLE-WMS-ST-CUR (WS-SCN-SUB) = 'S'                 
                 OR SCN-POLE-WMS-ST-CUR (WS-SCN-SUB) = 'A'              
                 MOVE SCN-POLE-WMS-ST-CUR (WS-SCN-SUB)                  
                                         TO 4D-INVENTRY-STATUS-CD       
              ELSE                                                      
                 MOVE 'I'                TO 4D-INVENTRY-STATUS-CD       
              END-IF                                                    
              PERFORM 8120-UPDATE-LMS-INVENTORY THRU 8120-EXIT          
                                                                        
              PERFORM 8600-DELETE-FXTR-ATTACHMTS THRU 8600-EXIT         
      ***     CREATE INFORMATIONAL TASK TO NOTIFY OF FXTR/POLE DELETION         
              MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                     
                                         TO WS-TASK-FXTR-SEQ-NO         
              MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                     
                                         TO WS-TASK-FXTR-TAG-NO         
              MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                     
                                         TO WS-TASK-POLE-TAG-NO         
              IF SCN-FXTR-CONTRACT-FL-CUR (WS-SCN-SUB) = 'Y'            
                 PERFORM 3270-PROCESS-CONTRACT   THRU 3270-EXIT         
      ***     FOLLOWING NOTIFICATION NOT NEEDED AS PER NIKKI                    
      ***     ELSE                                                              
      ***        PERFORM 5830-TASK-VERIFY-REMOVE THRU 5830-EXIT                 
              END-IF                                                    
A05084        IF AT-CODE-ACCT-STAT = 'A'                                
                 PERFORM 3260-CHECK-FOR-LAST-LIGHT THRU 3260-EXIT       
A05084        END-IF                                                    
              PERFORM 3280-REMOVE-TX-HIST     THRU 3280-EXIT            
           ELSE                                                         
              MOVE 'E'            TO SCN-LOCAL-ACTION(WS-SCN-SUB)       
           END-IF                                                       
           .                                                            
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3260-CHECK-FOR-LAST-LIGHT.                                       
      *================================================================*        
                                                                        
           MOVE AT-ACCOUNT-NO            TO MN-ACCOUNT-NO               
                                            CP-ACCOUNT-NO               
           SET NO-MORE-LIGHTS            TO TRUE                        
                                                                        
           PERFORM 7310-CHECK-FOR-LIGHTS    THRU 7310-EXIT              
                                                                        
           IF NO-MORE-LIGHTS                                            
              PERFORM 7320-CHECK-FOR-METERS    THRU 7320-EXIT           
           END-IF.                                                      
                                                                        
           IF NO-MORE-METERS                                            
              PERFORM 5780-TASK-LAST-LIGHT-GONE THRU 5780-EXIT          
           END-IF.                                                      
                                                                        
       3260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3270-PROCESS-CONTRACT.                                           
      *================================================================*        
                                                                        
           INITIALIZE                       CPDLM3-INPUT.               
           MOVE 'F'                      TO CPDLM3-CALL-TYPE            
           MOVE 'Y'                      TO CPDLM3-UPDATE-FL            
           MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO CPDLM3-FXTR-SEQ             
           MOVE SCN-FXTR-INS-LOC-NO-CUR (WS-SCN-SUB)                    
                                         TO CPDLM3-INSTALL-LOC-NO       
           MOVE SCN-ACCOUNT-NO (WS-SCN-SUB)                             
                                         TO CPDLM3-ACCOUNT-NO           
           MOVE WS-INPUT-DATE            TO CPDLM3-INPUT-DATE           
           MOVE 'LM100'                  TO CPDLM3-USER-ID              
           PERFORM 6000-CPDLM3-LIGHT-CNTRCT-TERM                        
              THRU 6000-CPDLM3-EXIT                                     
           IF CPDLM3-DB2-ERROR OR CPDLM3-ERROR                          
              MOVE CPDLM3-RETURN-CODE   TO WS-DISPLAY-SQLCODE           
              DISPLAY 'ERROR IN 3270-PROCESS-CONTRACTS'                 
              DISPLAY 'SQL RETURN CODE = ' WS-DISPLAY-SQLCODE           
              PERFORM 9900-ABEND    THRU 9900-EXIT                      
           END-IF                                                       
           IF CPDLM3-APPROVAL-REQ-FL = 'Y'                              
              PERFORM 5775-TASK-VERIFY-TRMCHG THRU 5775-EXIT            
           ELSE                                                         
              IF CPDLM3-TOTAL-CHRG-AM > 0                               
                 INITIALIZE DCLCSS-CONTRACT                             
                            WS-CONTRACT-DETAIL-PARMS                    
                            WS-CONTRACT-RETURN-INFO                     
                            WS-CONTRACT-HEADER-PARMS                    
                 SET LMS-CONTRACT TO TRUE                               
                 MOVE 'PCSLM100' TO WS-4822-CNT-APPL-PGM-ID             
                 MOVE 'I' TO WS-4822-UPDATE-TYPE                        
                 MOVE 'B' TO WS-4822-PGM-CALLED-FROM                    
                 MOVE AT-ACCOUNT-NO TO WS-4822-ACCOUNT-NO               
                 MOVE 'E' TO WS-4822-CODE-CONTRACT-TYPE                 
                 MOVE 407 TO WS-4822-CNT-NAME-CD                        
                 MOVE CPDLM3-TOTAL-CHRG-AM TO                           
                                     WS-4822-AMT-ORIG-ENTERED           
                 CALL SCSCA822 USING ABEND-FILE                         
                      WS-WARNING-DATA-ELEMENTS                          
                      WS-CONTRACT-HEADER-PARMS                          
                      WS-CONTRACT-DETAIL-PARMS                          
                      WS-CONTRACT-OPERATION-TYPE                        
                      WS-CONTRACT-RETURN-INFO                           
                 IF CPD4822-DB2-ERR-FOUND                               
                    MOVE WS-4822-DB2-ERR-RETURN-CD                      
                                           TO WS-ACTIVE-RETURN-CODE     
                                              WS-DISPLAY-SQLCODE        
                    DISPLAY '3270-PROCESS-CONTRACTS'                    
                    DISPLAY 'CALL SCSCA822         '                    
                    DISPLAY 'ACCOUNT-NO      ' WS-4822-ACCOUNT-NO       
                    DISPLAY 'SQL RETURN CODE ' WS-DISPLAY-SQLCODE       
                    DISPLAY 'APPL RETURN CODE  '                        
                                            WS-4822-APPL-CNT-RETURN-CD  
                    DISPLAY 'SCSCA822 - ABEND PARA = '                  
                                            ACTIVE-PARAGRAPH            
                    PERFORM 9900-ABEND    THRU 9900-EXIT                
                 ELSE                                                   
                    PERFORM 5775-TASK-VERIFY-TRMCHG THRU 5775-EXIT      
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
           .                                                            
       3270-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *================================================================*        
       3280-REMOVE-TX-HIST.                                             
      *================================================================*        
                                                                        
           INITIALIZE DCLLMS-TRANS-HIST                                 
                      DCLLMS-TRANS-HIST-DET.                            
           PERFORM 7045-GET-CURR-TS         THRU 7045-EXIT              
           MOVE 4J-TRANS-HIST-SEQ-NO     TO 4S-TRANS-HIST-SEQ-NO        
           MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO 4J-EQUIP-SEQ                
                                            4S-EQUIP-SEQ                
           MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                        
                                         TO 4J-EQUIP-TAG-NO             
           MOVE WS-PGM-NAME               TO 4J-APPL-PROGRAM-ID         
           MOVE SCN-REQUEST-ACTION-TS (WS-SCN-SUB) (1:10)               
                                          TO 4J-TRANS-DATE              
           MOVE SCN-SOURCE-APPL-CD (WS-SCN-SUB)                         
                                          TO 4J-SOURCE-APPL-CD          
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                          TO 4J-SOURCE-APPL-REQ-NO      
           MOVE SCN-WMS-POINT-CUR (WS-SCN-SUB)                          
                                          TO 4J-WMS-POINT-NO            
                                                                        
           MOVE SCN-FXTR-INS-LOC-NO-CUR  (WS-SCN-SUB)                   
                                          TO 4J-INSTALL-LOC-NO          
           MOVE SCN-FXTR-INS-POINT-NO-CUR  (WS-SCN-SUB)                 
                                          TO 4J-INSTALL-POINT-NO        
                                                                        
           MOVE SCN-ACCOUNT-NO (WS-SCN-SUB)                             
                                          TO 4J-ACCOUNT-NO              
      ***  TRANS COMMENTS START****                                             
           MOVE 1                          TO 4J-TRANS-COMMENTS-LEN     
           STRING 'FIXTURE/POLE: '            DELIMITED BY SIZE         
                  4J-EQUIP-TAG-NO             DELIMITED BY ' '          
                   '/'                        DELIMITED BY SIZE         
                  SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                      
                                              DELIMITED BY ' '          
                   ' REMOVED FROM THIS CUSTOMER LOCATION'               
                                              DELIMITED BY SIZE         
                 INTO 4J-TRANS-COMMENTS-TEXT                            
                 WITH POINTER 4J-TRANS-COMMENTS-LEN                     
                                                                        
           COMPUTE 4J-TRANS-COMMENTS-LEN = 4J-TRANS-COMMENTS-LEN  - 1   
      ***  TRANS COMMENTS END  ****                                             
                                                                        
           MOVE 'LM100'                   TO 4J-LAST-UPDATE-USERID      
                                             4S-LAST-UPDATE-USERID      
                                                                        
           PERFORM 8400-INS-LMS-TRN-HST    THRU 8400-EXIT.              
                                                                        
       3280-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3300-PROCESS-REPLACES.                                           
      *================================================================*        
                                                                        
           MOVE SPACES                   TO WS-TASK-POLE-TAG-OLD        
           SET NO-TASK-CREATED           TO TRUE                        
           IF AT-PREMISE-NO > 0                                         
              MOVE AT-PREMISE-NO         TO WS-PREMISE-NO-NUM           
           ELSE                                                         
      ***     CREATE WQ: ACCOUNT NEEDED                                         
              SET TASK-CREATED           TO TRUE                        
              MOVE SCN-FXTR-SEQ-NO-OLD  (WS-SCN-SUB)                    
                                         TO WS-TASK-FXTR-SEQ-NO         
              MOVE SCN-FXTR-TAG-NO-OLD (WS-SCN-SUB)                     
                                         TO WS-TASK-FXTR-TAG-NO         
              PERFORM 5705-CREATE-ACC-REQ-TASK THRU 5705-EXIT           
           END-IF.                                                      
           IF SCN-FXTR-TAG-NO-OLD (WS-SCN-SUB) = SPACES                 
              AND NO-TASK-CREATED                                       
      ***     CREATE WQ: OLD FXTR TAG REQUIRED                                  
              SET TASK-CREATED           TO TRUE                        
              PERFORM 5750-TASK-OLD-FXTR-REQ   THRU 5750-EXIT           
           END-IF                                                       
                                                                        
           IF SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB) = SPACES                 
              AND NO-TASK-CREATED                                       
      ***     CREATE WQ: NEW FXTR TAG REQUIRED                                  
              SET TASK-CREATED           TO TRUE                        
              PERFORM 5755-TASK-NEW-FXTR-REQ   THRU 5755-EXIT           
           END-IF                                                       
                                                                        
           IF SCN-FXTR-SEQ-NO-OLD (WS-SCN-SUB) = 0                      
              AND NO-TASK-CREATED                                       
      ***     CREATE WQ: OLD FXTR NOT EXISTS INVENTORY                          
              SET TASK-CREATED           TO TRUE                        
              PERFORM 5711-TASK-OLD-FXTR-NOT-INV                        
                 THRU 5711-EXIT                                         
           END-IF                                                       
           IF SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB) = 0                      
              AND NO-TASK-CREATED                                       
      ***     CREATE WQ: NEW FXTR NOT IN INVENTORY                              
              SET TASK-CREATED           TO TRUE                        
              PERFORM 5712-TASK-NEW-FXTR-NOT-INV   THRU 5712-EXIT       
           END-IF                                                       
      **** VALIDATE CURRENT FIXTURE RATE                                        
           MOVE SPACES                   TO UP-CODE-UTIL-TYPE           
           IF NO-TASK-CREATED                                           
              IF SCN-SOURCE-APPL-CD (WS-SCN-SUB) = 'WMS'                
                 MOVE SCN-FXTR-RATE-ITEM-CUR   (WS-SCN-SUB)             
                                         TO UP-RATE-ITEM-CODE           
                 MOVE SCN-FXTR-RATE-PLAN-CUR   (WS-SCN-SUB)             
                                         TO UP-RATE-PLAN-NO             
                 MOVE SCN-FXTR-SEQ-NO-CUR  (WS-SCN-SUB)                 
                                         TO WS-TASK-FXTR-SEQ-NO         
                 MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                  
                                         TO WS-TASK-FXTR-TAG-NO         
                 MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                  
                                         TO WS-TASK-POLE-TAG-NO         
                 PERFORM 3600-VALIDATE-RATE    THRU 3600-EXIT           
              ELSE                                                      
                 MOVE 'U'                TO UP-CODE-UTIL-TYPE           
              END-IF                                                    
           END-IF                                                       
           MOVE UP-CODE-UTIL-TYPE        TO                             
                                SCN-FXTR-UTIL-TYPE-CUR (WS-SCN-SUB)     
                                                                        
           IF SCN-REQ-POLE-NO-CUR (WS-SCN-SUB) = SPACES                 
              AND NO-TASK-CREATED                                       
      ***     CREATE WQ: POLE TAG REQUIRED                                      
              SET TASK-CREATED           TO TRUE                        
              MOVE ZEROS                 TO WS-TASK-FXTR-SEQ-NO         
              MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                     
                                         TO WS-TASK-FXTR-TAG-NO         
              PERFORM 5725-TASK-POLE-TAG-REQ   THRU 5725-EXIT           
           END-IF.                                                      
           IF NO-TASK-CREATED                                           
              PERFORM 3320-CHK-OLD-LIGHT-LOCATION THRU 3320-EXIT        
           END-IF.                                                      
           IF NO-TASK-CREATED                                           
      ***     CHECK OLD FIXTURE RATE WITH SYSTEM                                
              MOVE SCN-FXTR-INS-LOC-NO-OLD (WS-SCN-SUB)                 
                            TO 4F-INSTALL-LOC-NO                        
              MOVE SCN-FXTR-INS-POINT-NO-OLD (WS-SCN-SUB)               
                            TO 4F-INSTALL-POINT-NO                      
              MOVE SPACES   TO 4F-RATE-PLAN-NO                          
              MOVE ZEROS    TO 4F-RATE-ITEM-CODE                        
              PERFORM 7005-SELECT-EQUIP-ENVRNMT THRU 7005-EXIT          
              IF SCN-FXTR-RATE-PLAN-OLD (WS-SCN-SUB)                    
                       = 4F-RATE-PLAN-NO                                
                 AND 4F-RATE-PLAN-NO > SPACES                           
                 AND SCN-FXTR-RATE-ITEM-OLD  (WS-SCN-SUB)               
                       = 4F-RATE-ITEM-CODE                              
                 CONTINUE                                               
              ELSE                                                      
      ***        SWAP RATE FROM WMS WITH WHAT WAS SET UP IN CIS                 
                 MOVE 4F-RATE-PLAN-NO    TO SCN-FXTR-RATE-PLAN-OLD      
                                            (WS-SCN-SUB)                
                 MOVE 4F-RATE-ITEM-CODE  TO SCN-FXTR-RATE-ITEM-OLD      
                                            (WS-SCN-SUB)                
                                                                        
      ***        CREATE WQ: OLD RATE RCVD NOT MATCH WITH SYSTEM                 
      ***        SET TASK-CREATED        TO TRUE                                
      ***        MOVE ZEROS              TO WS-TASK-FXTR-SEQ-NO                 
      ***        MOVE SCN-FXTR-TAG-NO-OLD (WS-SCN-SUB)                          
      ***                                TO WS-TASK-FXTR-TAG-NO                 
      ***        MOVE 4F-RATE-PLAN-NO    TO WS-TASK-LMS-RATE                    
      ***        MOVE SCN-FXTR-RATE-PLAN-OLD (WS-SCN-SUB)                       
      ***                                TO WS-TASK-WMS-RATE                    
      ***        PERFORM 5855-TASK-RATE-MISMATCH THRU 5855-EXIT                 
              END-IF                                                    
           END-IF.                                                      
           IF SCN-REQ-POLE-NO-OLD (WS-SCN-SUB)                          
                     = SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                 
              AND SCN-POLE-STOCK-OLD (WS-SCN-SUB)                       
                     = SCN-POLE-STOCK-CUR (WS-SCN-SUB)                  
      ***      POLE ITSELF NOT CHANGING, BUT RATE COULD CHANGE                  
              MOVE SCN-POLE-SEQ-NO-OLD (WS-SCN-SUB)                     
                                         TO                             
                               SCN-POLE-SEQ-NO-CUR (WS-SCN-SUB)         
              MOVE SCN-POLE-INV-ST-OLD (WS-SCN-SUB)                     
                                         TO                             
                               SCN-POLE-INV-ST-CUR (WS-SCN-SUB)         
              MOVE SCN-POLE-WRNTY-AMT-OLD (WS-SCN-SUB)                  
                                         TO                             
                            SCN-POLE-WRNTY-AMT-CUR (WS-SCN-SUB)         
      ***     WE MAY NEED STOCK CODE CHECK LATER B/W RCVD VS SYSTEM             
              MOVE SCN-POLE-STOCK-OLD (WS-SCN-SUB)                      
                                         TO                             
                                SCN-POLE-STOCK-CUR (WS-SCN-SUB)         
              MOVE SCN-POLE-INS-LOC-NO-OLD (WS-SCN-SUB)                 
                                         TO                             
                           SCN-POLE-INS-LOC-NO-CUR (WS-SCN-SUB)         
              MOVE SCN-POLE-INS-POINT-NO-OLD (WS-SCN-SUB)               
                                         TO                             
                         SCN-POLE-INS-POINT-NO-CUR (WS-SCN-SUB)         
              MOVE SCN-POLE-UTIL-TYPE-OLD (WS-SCN-SUB)                  
                                         TO                             
                         SCN-POLE-UTIL-TYPE-CUR (WS-SCN-SUB)            
              MOVE SCN-FXTR-BILLING-FL-OLD (WS-SCN-SUB)                 
                                         TO                             
                         SCN-FXTR-BILLING-FL-CUR (WS-SCN-SUB)           
           ELSE                                                         
              IF NO-TASK-CREATED                                        
                 PERFORM 3310-VALIDATE-NEW-POLE   THRU 3310-EXIT        
              END-IF                                                    
           END-IF                                                       
      ***  NODE VALIDATION                                                      
           IF NO-TASK-CREATED AND                                       
              SCN-NODE-TAG-NO-CUR (WS-SCN-SUB) > SPACES                 
              MOVE SCN-NODE-TAG-NO-CUR (WS-SCN-SUB)                     
                                         TO 4D-EQUIP-TAG-NO             
              PERFORM 7038-GET-NODE-SEQ        THRU 7038-EXIT           
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF 4D-INVENTRY-STATUS-CD NOT = 'J'                     
                    MOVE 4D-EQUIP-SEQ       TO                          
                                   SCN-NODE-SEQ-NO-CUR (WS-SCN-SUB)     
                 END-IF                                                 
              ELSE                                                      
      ***        CREATE WQ: NODE NOT IN INVENTORY OR NOT INV STATUS             
                 SET TASK-CREATED           TO TRUE                     
                 MOVE ZEROS                 TO WS-TASK-FXTR-SEQ-NO      
                 MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                  
                                         TO WS-TASK-FXTR-TAG-NO         
                 PERFORM 5730-TASK-NODE-NOT-EXITS  THRU 5730-EXIT       
              END-IF                                                    
           END-IF                                                       
           EVALUATE TRUE                                                
              WHEN TASK-CREATED                                         
                   CONTINUE                                             
              WHEN SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                     
                     NOT = SCN-FXTR-TAG-NO-OLD (WS-SCN-SUB)             
                   AND SCN-POLE-SEQ-NO-CUR (WS-SCN-SUB)                 
                     = SCN-POLE-SEQ-NO-OLD (WS-SCN-SUB)                 
                 PERFORM 3340-REPLACE-FXTR        THRU 3340-EXIT        
      **** FXTR ONLY CHANGE? POLE RATE COULD ALSO CHANGE                        
                     DISPLAY 'FXTR ONLY CHANGE'                         
              WHEN SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                     
                     NOT = SCN-FXTR-TAG-NO-OLD (WS-SCN-SUB)             
                   AND SCN-POLE-SEQ-NO-CUR (WS-SCN-SUB)                 
                   NOT = SCN-POLE-SEQ-NO-OLD (WS-SCN-SUB)               
                 PERFORM 3380-REPLACE-LIGHT       THRU 3380-EXIT        
      **** FXTR/POLE CHANGE? RATES COULD ALSO CHANGE                            
                     DISPLAY 'FXTR/POLE CHANGE'                         
              WHEN SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                     
                      = SCN-FXTR-TAG-NO-OLD (WS-SCN-SUB)                
                   AND SCN-POLE-SEQ-NO-CUR (WS-SCN-SUB)                 
                   NOT = SCN-POLE-SEQ-NO-OLD (WS-SCN-SUB)               
                 PERFORM 3360-REPLACE-POLE        THRU 3360-EXIT        
      **** POLE ONLY CHANGE? FXTR RATE COULD ALSO CHANGE                        
                     DISPLAY 'POLE ONLY CHANGE'                         
              WHEN OTHER                                                
                     DISPLAY 'NO CHANGES TO FXTR&POLE'                  
      **** NO FXTR/POLE CHANGE? THEN IT COULD BE RATE CHANGE                    
           END-EVALUATE                                                 
           IF NO-TASK-CREATED                                           
      ***     CREATE INFORMATIONAL TASK TO NOTIFY OF FXTR/POLE CHANGES          
              PERFORM 3390-NOTIFY-RATE-CHANGES THRU 3390-EXIT           
           ELSE                                                         
              MOVE 'E'            TO SCN-LOCAL-ACTION(WS-SCN-SUB)       
           END-IF                                                       
           .                                                            
       3300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3310-VALIDATE-NEW-POLE.                                          
      *================================================================*        
                                                                        
           MOVE SCN-POLE-STOCK-CUR (WS-SCN-SUB)                         
                                         TO 4D-STOCK-CD                 
           MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                        
                                         TO 4D-EQUIP-TAG-NO             
           MOVE 'P'                      TO 4D-EQUIP-TYPE-CD            
           IF SCN-POLE-RATE-PLAN-CUR (WS-SCN-SUB) > SPACES              
              MOVE SCN-POLE-RATE-ITEM-CUR   (WS-SCN-SUB)                
                                            TO UP-RATE-ITEM-CODE        
              MOVE SCN-POLE-RATE-PLAN-CUR   (WS-SCN-SUB)                
                                            TO UP-RATE-PLAN-NO          
              MOVE SPACES                   TO UP-CODE-UTIL-TYPE        
              MOVE SCN-FXTR-SEQ-NO-CUR  (WS-SCN-SUB)                    
                                         TO WS-TASK-FXTR-SEQ-NO         
              MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                     
                                         TO WS-TASK-FXTR-TAG-NO         
              MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                     
                                         TO WS-TASK-POLE-TAG-NO         
              PERFORM 3600-VALIDATE-RATE    THRU 3600-EXIT              
              MOVE UP-CODE-UTIL-TYPE        TO                          
                                SCN-POLE-UTIL-TYPE-CUR (WS-SCN-SUB)     
           END-IF                                                       
           SET NO-STOCK-CODE             TO TRUE                        
           IF NO-TASK-CREATED                                           
              IF 4D-STOCK-CD = SPACES                                   
                 PERFORM VARYING WS-SCN-SUB1 FROM 1 BY 1                
                    UNTIL WS-SCN-SUB1 > WS-SCN-ROW-COUNT                
                    IF  SCN-LOCAL-ACTION(WS-SCN-SUB1) = 'M'             
                      AND SCN-WMS-POINT-CUR (WS-SCN-SUB1)               
                                    = SCN-WMS-POINT-CUR (WS-SCN-SUB)    
                      AND SCN-REQ-POLE-NO-CUR (WS-SCN-SUB1)             
                                         = 4D-EQUIP-TAG-NO              
                      AND SCN-POLE-STOCK-CUR (WS-SCN-SUB1) > SPACES     
                      MOVE SCN-POLE-STOCK-CUR (WS-SCN-SUB1)             
                               TO SCN-POLE-STOCK-CUR (WS-SCN-SUB)       
                                  4D-STOCK-CD                           
                    END-IF                                              
                 END-PERFORM                                            
              END-IF                                                    
      *** STOCK DETAILS FROM OTHER LIGHTS                                       
             IF 4D-STOCK-CD > SPACES                                    
                SET NOT-VALID-STOCK-CODE   TO TRUE                      
                PERFORM 3315-CHECK-NEW-POLE     THRU 3315-EXIT          
             END-IF                                                     
           END-IF                                                       
           IF SCN-POLE-SEQ-NO-CUR (WS-SCN-SUB) = 0                      
              AND NO-TASK-CREATED                                       
              IF VALID-STOCK-CODE OR NO-STOCK-CODE                      
                 PERFORM 7034-GET-NEXT-EQUIP-SEQ THRU 7034-EXIT         
                 IF 4D-STOCK-CD = SPACES                                
                    MOVE 'MAINJOBDFLT'     TO 4D-STOCK-CD               
                 END-IF                                                 
                 MOVE '01'                 TO 4D-COMPANY-NO             
                 MOVE 'E'                  TO 4D-CODE-SERVICE-TYPE      
                 MOVE SPACES               TO 4D-EQUIP-MFR-CD           
                 MOVE SPACES               TO 4D-STORAGE-FAC-CD         
                 MOVE SPACES               TO 4D-IN-TRANSIT-USERID      
                 MOVE SPACES               TO 4D-EQUIP-MFR-DT           
                                              4D-WARRANTY-EXP-DT        
                                              4D-EQUIP-DISPOSAL-DT      
                 MOVE -1                   TO WS-EQUIP-MFR-DT-IND       
                                              WS-WARRANTY-EXP-DT-IND    
                                              WS-EQUIP-DISPOSAL-DT-IND  
                 MOVE 'I'                  TO 4D-INVENTRY-STATUS-CD     
                 MOVE SPACES               TO 4D-WRNTY-RECEIVED-FL      
                 MOVE ZEROS                TO 4D-WRNTY-RECOUP-AMT       
                 MOVE WS-PGM-NAME          TO 4D-LAST-UPDATE-USERID     
                 PERFORM 8100-INSERT-LMS-INVENTORY THRU 8100-EXIT       
                 MOVE 4D-EQUIP-SEQ          TO                          
                                  SCN-POLE-SEQ-NO-CUR (WS-SCN-SUB)      
                 MOVE 4D-INVENTRY-STATUS-CD TO                          
                                  SCN-POLE-INV-ST-CUR (WS-SCN-SUB)      
                 MOVE 4D-WRNTY-RECOUP-AMT   TO                          
                                  SCN-POLE-WRNTY-AMT-CUR (WS-SCN-SUB)   
              ELSE                                                      
      ***     CREATE WQ: NOT VALID STOCK CODE                                   
                 SET TASK-CREATED           TO TRUE                     
                 MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                  
                                            TO WS-TASK-POLE-TAG-NO      
                 MOVE SCN-POLE-STOCK-CUR (WS-SCN-SUB)                   
                                            TO WS-TASK-POLE-STOCK       
                 MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                  
                                            TO WS-TASK-FXTR-TAG-NO      
                 PERFORM 5735-TASK-STOCK-INVALID THRU 5735-EXIT         
              END-IF                                                    
           END-IF                                                       
           .                                                            
       3310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3315-CHECK-NEW-POLE.                                             
      *================================================================*        
                                                                        
           PERFORM 7030-CHECK-EQUIP-STATUS     THRU 7030-EXIT           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              SET VALID-STOCK-CODE       TO TRUE                        
              MOVE 4D-EQUIP-SEQ          TO                             
                                  SCN-POLE-SEQ-NO-CUR (WS-SCN-SUB)      
              MOVE 4D-INVENTRY-STATUS-CD TO                             
                                  SCN-POLE-INV-ST-CUR (WS-SCN-SUB)      
              MOVE 4D-WRNTY-RECOUP-AMT   TO                             
                                  SCN-POLE-WRNTY-AMT-CUR (WS-SCN-SUB)   
           ELSE                                                         
              PERFORM 7040-VALIDATE-STOCK  THRU 7040-EXIT               
           END-IF.                                                      
                                                                        
       3315-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       3320-CHK-OLD-LIGHT-LOCATION.                                     
      *================================================================*        
                                                                        
           IF SCN-FXTR-INV-ST-OLD (WS-SCN-SUB) = 'J'                    
              AND SCN-FXTR-INS-LOC-NO-OLD (WS-SCN-SUB)                  
                               = WS-PREMISE-NO-NUM                      
      *** POLE ALSO SHOULD BE IN SAME PREMISE TO REMOVE                         
              MOVE WS-PREMISE-NO-NUM     TO 4F-INSTALL-LOC-NO           
              MOVE SCN-FXTR-SEQ-NO-OLD (WS-SCN-SUB)                     
                                         TO 4H-FXTR-EQUIP-SEQ           
              MOVE SCN-REQ-POLE-NO-OLD (WS-SCN-SUB)                     
                                         TO 4D-EQUIP-TAG-NO             
              MOVE 'P'                   TO 4D-EQUIP-TYPE-CD            
              PERFORM 7033-GET-POLE-LOCATION THRU 7033-EXIT             
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 4D-EQUIP-SEQ            TO                        
                               SCN-POLE-SEQ-NO-OLD (WS-SCN-SUB)         
                 MOVE 4D-INVENTRY-STATUS-CD   TO                        
                               SCN-POLE-INV-ST-OLD (WS-SCN-SUB)         
                 MOVE 4D-WRNTY-RECOUP-AMT     TO                        
                            SCN-POLE-WRNTY-AMT-OLD (WS-SCN-SUB)         
      ***     WE MAY NEED STOCK CODE CHECK LATER B/W RCVD VS SYSTEM             
      ***        MOVE 4D-STOCK-CD             TO                                
      ***                       SCN-POLE-STOCK-CUR (WS-SCN-SUB)                 
                 MOVE 4F-INSTALL-LOC-NO       TO                        
                           SCN-POLE-INS-LOC-NO-OLD (WS-SCN-SUB)         
                 MOVE 4F-INSTALL-POINT-NO     TO                        
                         SCN-POLE-INS-POINT-NO-OLD (WS-SCN-SUB)         
                 MOVE 4F-CODE-UTIL-TYPE       TO                        
                         SCN-POLE-UTIL-TYPE-OLD (WS-SCN-SUB)            
                 MOVE 4F-BILLING-FL           TO                        
                         SCN-FXTR-BILLING-FL-OLD (WS-SCN-SUB)           
      ***        SWAP RATE FROM WMS WITH WHAT WAS SET UP IN CIS                 
                 MOVE 4F-RATE-PLAN-NO    TO SCN-POLE-RATE-PLAN-OLD      
                                            (WS-SCN-SUB)                
                 MOVE 4F-RATE-ITEM-CODE  TO SCN-POLE-RATE-ITEM-OLD      
                                            (WS-SCN-SUB)                
              ELSE                                                      
      ***        IF SCN-POLE-STOCK-OLD (WS-SCN-SUB) > SPACES                    
      ***     CREATE WQ POLE REPLACE REVD WITH STOCK                            
      ***     POLE NOT AT THE LOCATION                                          
                    SET TASK-CREATED       TO TRUE                      
                    MOVE SCN-FXTR-SEQ-NO-OLD (WS-SCN-SUB)               
                                         TO WS-TASK-FXTR-SEQ-NO         
                    MOVE SCN-FXTR-TAG-NO-OLD (WS-SCN-SUB)               
                                         TO WS-TASK-FXTR-TAG-NO         
                    MOVE SCN-REQ-POLE-NO-OLD (WS-SCN-SUB)               
                                         TO WS-TASK-POLE-TAG-NO         
                    PERFORM 5745-TASK-POLE-NOT-EXISTS THRU 5745-EXIT    
      ***        END-IF                                                         
              END-IF                                                    
           ELSE                                                         
      ***     CREATE WQ FXTR NOT FOUND IN SYSTEM                                
              SET TASK-CREATED           TO TRUE                        
              MOVE SCN-FXTR-SEQ-NO-OLD (WS-SCN-SUB)                     
                                         TO WS-TASK-FXTR-SEQ-NO         
              MOVE SCN-FXTR-TAG-NO-OLD (WS-SCN-SUB)                     
                                         TO WS-TASK-FXTR-TAG-NO         
              MOVE SCN-REQ-POLE-NO-OLD (WS-SCN-SUB)                     
                                         TO WS-TASK-POLE-TAG-NO         
              PERFORM 5740-TASK-FXTR-NOT-EXISTS THRU 5740-EXIT          
           END-IF.                                                      
                                                                        
       3320-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       3340-REPLACE-FXTR.                                               
      *================================================================*        
                                                                        
           MOVE SCN-FXTR-INS-LOC-NO-OLD (WS-SCN-SUB)                    
                                         TO 4F-INSTALL-LOC-NO           
           MOVE SCN-FXTR-INS-POINT-NO-OLD (WS-SCN-SUB)                  
                                         TO 4F-INSTALL-POINT-NO         
           MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO 4F-EQUIP-SEQ                
           PERFORM 8140-UPDATE-LMS-ENV        THRU 8140-EXIT            
                                                                        
      ***  UPDATE NEW FXTR STATUS TO CUSTOMER LOCATION                          
           MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO 4D-EQUIP-SEQ                
           MOVE 'J'                      TO 4D-INVENTRY-STATUS-CD       
           PERFORM 8120-UPDATE-LMS-INVENTORY  THRU 8120-EXIT            
      ***  UPDATE OLD FXTR STATUS TO INVENTORY                                  
           MOVE SCN-FXTR-SEQ-NO-OLD (WS-SCN-SUB)                        
                                         TO 4D-EQUIP-SEQ                
           IF SCN-FXTR-WMS-ST-OLD (WS-SCN-SUB) = 'S'                    
              OR SCN-FXTR-WMS-ST-OLD (WS-SCN-SUB) = 'A'                 
              MOVE SCN-FXTR-WMS-ST-OLD (WS-SCN-SUB)                     
                                      TO 4D-INVENTRY-STATUS-CD          
           ELSE                                                         
              MOVE 'I'                TO 4D-INVENTRY-STATUS-CD          
           END-IF                                                       
                                                                        
           PERFORM 8120-UPDATE-LMS-INVENTORY  THRU 8120-EXIT            
      ***  DELETE OLD FXTR ATTACHMENTS                                          
           MOVE SCN-FXTR-SEQ-NO-OLD (WS-SCN-SUB)                        
                                         TO 4H-FXTR-EQUIP-SEQ           
           PERFORM 8600-DELETE-FXTR-ATTACHMTS THRU 8600-EXIT            
      ***  INSERT NEW FXTR ATTACHMENTS                                          
           MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO 4H-FXTR-EQUIP-SEQ           
           MOVE SCN-POLE-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO 4H-ATTACH-EQUIP-SEQ         
           PERFORM 7015-GET-MAX-ATTACH-SEQ    THRU 7015-EXIT            
           MOVE 'P'                      TO 4H-EQUIP-TYPE-CD            
           MOVE SCN-REQUEST-ACTION-TS (WS-SCN-SUB) (1:10)               
                                         TO 4H-ATTACH-EQUIP-DT          
           PERFORM 8200-INSERT-FXTR-ATTACHMTS THRU 8200-EXIT.           
      ***  INSERT NODE ATTACHMENT                                               
           IF SCN-NODE-SEQ-NO-CUR (WS-SCN-SUB) > 0                      
              MOVE SCN-NODE-SEQ-NO-CUR (WS-SCN-SUB)                     
                                      TO 4H-ATTACH-EQUIP-SEQ            
              COMPUTE 4H-ATTACH-SEQ-NO = 4H-ATTACH-SEQ-NO + 1           
              MOVE 'N'                TO 4H-EQUIP-TYPE-CD               
              PERFORM 8200-INSERT-FXTR-ATTACHMTS THRU 8200-EXIT         
           END-IF                                                       
      ***  WRITING TX HIST                                                      
           PERFORM 3382-FXTR-RPLC-TX-HIST     THRU 3382-EXIT.           
                                                                        
       3340-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       3360-REPLACE-POLE.                                               
      *================================================================*        
                                                                        
           MOVE SCN-POLE-INS-LOC-NO-OLD (WS-SCN-SUB)                    
                                         TO 4F-INSTALL-LOC-NO           
           MOVE SCN-POLE-INS-POINT-NO-OLD (WS-SCN-SUB)                  
                                         TO 4F-INSTALL-POINT-NO         
           MOVE SCN-POLE-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO 4F-EQUIP-SEQ                
           PERFORM 8140-UPDATE-LMS-ENV        THRU 8140-EXIT            
                                                                        
      ***  UPDATE NEW POLE STATUS TO CUSTOMER LOCATION                          
           MOVE SCN-POLE-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO 4D-EQUIP-SEQ                
           MOVE 'J'                      TO 4D-INVENTRY-STATUS-CD       
           PERFORM 8120-UPDATE-LMS-INVENTORY  THRU 8120-EXIT            
      ***  UPDATE OLD POLE STATUS TO INVENTORY                                  
           MOVE SCN-POLE-SEQ-NO-OLD (WS-SCN-SUB)                        
                                         TO 4D-EQUIP-SEQ                
           IF SCN-POLE-WMS-ST-OLD (WS-SCN-SUB) = 'S'                    
              OR SCN-POLE-WMS-ST-OLD (WS-SCN-SUB) = 'A'                 
              MOVE SCN-POLE-WMS-ST-OLD (WS-SCN-SUB)                     
                                      TO 4D-INVENTRY-STATUS-CD          
           ELSE                                                         
              MOVE 'I'                TO 4D-INVENTRY-STATUS-CD          
           END-IF                                                       
           PERFORM 8120-UPDATE-LMS-INVENTORY  THRU 8120-EXIT            
      ***  UPDATE FXTR ATTACHMENTS                                              
           MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO 4H-FXTR-EQUIP-SEQ           
           MOVE SCN-POLE-SEQ-NO-OLD (WS-SCN-SUB)                        
                                         TO 4H-ATTACH-EQUIP-SEQ         
           MOVE SCN-POLE-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO WS-ATTACH-EQUIP-SEQ         
           MOVE SCN-REQUEST-ACTION-TS (WS-SCN-SUB) (1:10)               
                                         TO 4H-ATTACH-EQUIP-DT          
           PERFORM 8220-UPDATE-FXTR-ATTACHMTS THRU 8220-EXIT            
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
      ***  INSERT NEW FXTR ATTACHMENTS                                          
              MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                     
                                         TO 4H-FXTR-EQUIP-SEQ           
              MOVE SCN-POLE-SEQ-NO-CUR (WS-SCN-SUB)                     
                                         TO 4H-ATTACH-EQUIP-SEQ         
              PERFORM 7015-GET-MAX-ATTACH-SEQ    THRU 7015-EXIT         
              MOVE 'P'                   TO 4H-EQUIP-TYPE-CD            
              MOVE SCN-REQUEST-ACTION-TS (WS-SCN-SUB) (1:10)            
                                         TO 4H-ATTACH-EQUIP-DT          
              PERFORM 8200-INSERT-FXTR-ATTACHMTS THRU 8200-EXIT         
           END-IF.                                                      
                                                                        
      ***  WRITING TX HIST                                                      
           PERFORM 3384-POLE-RPLC-TX-HIST     THRU 3384-EXIT.           
                                                                        
       3360-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       3380-REPLACE-LIGHT.                                              
      *================================================================*        
                                                                        
      ***  UPDATE FXTR ENV                                                      
           MOVE SCN-FXTR-INS-LOC-NO-OLD (WS-SCN-SUB)                    
                                         TO 4F-INSTALL-LOC-NO           
           MOVE SCN-FXTR-INS-POINT-NO-OLD (WS-SCN-SUB)                  
                                         TO 4F-INSTALL-POINT-NO         
           MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO 4F-EQUIP-SEQ                
           PERFORM 8140-UPDATE-LMS-ENV        THRU 8140-EXIT            
                                                                        
      ***  UPDATE NEW FXTR STATUS TO CUSTOMER LOCATION                          
           MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO 4D-EQUIP-SEQ                
           MOVE 'J'                      TO 4D-INVENTRY-STATUS-CD       
           PERFORM 8120-UPDATE-LMS-INVENTORY  THRU 8120-EXIT            
      ***  UPDATE OLD FXTR STATUS TO INVENTORY                                  
           MOVE SCN-FXTR-SEQ-NO-OLD (WS-SCN-SUB)                        
                                         TO 4D-EQUIP-SEQ                
           IF SCN-FXTR-WMS-ST-OLD (WS-SCN-SUB) = 'S'                    
              OR SCN-FXTR-WMS-ST-OLD (WS-SCN-SUB) = 'A'                 
              MOVE SCN-FXTR-WMS-ST-OLD (WS-SCN-SUB)                     
                                      TO 4D-INVENTRY-STATUS-CD          
           ELSE                                                         
              MOVE 'I'                TO 4D-INVENTRY-STATUS-CD          
           END-IF                                                       
                                                                        
           PERFORM 8120-UPDATE-LMS-INVENTORY  THRU 8120-EXIT            
      ***  DELETE OLD FXTR ATTACHMENTS                                          
           MOVE SCN-FXTR-SEQ-NO-OLD (WS-SCN-SUB)                        
                                         TO 4H-FXTR-EQUIP-SEQ           
           PERFORM 8600-DELETE-FXTR-ATTACHMTS THRU 8600-EXIT            
      ***  UPDATE POLE ENV                                                      
           MOVE SCN-POLE-INS-LOC-NO-OLD (WS-SCN-SUB)                    
                                         TO 4F-INSTALL-LOC-NO           
           MOVE SCN-POLE-INS-POINT-NO-OLD (WS-SCN-SUB)                  
                                         TO 4F-INSTALL-POINT-NO         
           MOVE SCN-POLE-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO 4F-EQUIP-SEQ                
           PERFORM 8140-UPDATE-LMS-ENV        THRU 8140-EXIT            
                                                                        
      ***  UPDATE NEW POLE STATUS TO CUSTOMER LOCATION                          
           MOVE SCN-POLE-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO 4D-EQUIP-SEQ                
           MOVE 'J'                      TO 4D-INVENTRY-STATUS-CD       
           PERFORM 8120-UPDATE-LMS-INVENTORY  THRU 8120-EXIT            
      ***  UPDATE OLD POLE STATUS TO INVENTORY                                  
           MOVE SCN-POLE-SEQ-NO-OLD (WS-SCN-SUB)                        
                                         TO 4D-EQUIP-SEQ                
           IF SCN-POLE-WMS-ST-OLD (WS-SCN-SUB) = 'S'                    
              OR SCN-POLE-WMS-ST-OLD (WS-SCN-SUB) = 'A'                 
              MOVE SCN-POLE-WMS-ST-OLD (WS-SCN-SUB)                     
                                      TO 4D-INVENTRY-STATUS-CD          
           ELSE                                                         
              MOVE 'I'                TO 4D-INVENTRY-STATUS-CD          
           END-IF                                                       
                                                                        
           PERFORM 8120-UPDATE-LMS-INVENTORY  THRU 8120-EXIT            
      ***  INSERT NEW FXTR ATTACHMENTS                                          
           MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO 4H-FXTR-EQUIP-SEQ           
           MOVE SCN-POLE-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO 4H-ATTACH-EQUIP-SEQ         
           PERFORM 7015-GET-MAX-ATTACH-SEQ    THRU 7015-EXIT            
           MOVE 'P'                      TO 4H-EQUIP-TYPE-CD            
           MOVE SCN-REQUEST-ACTION-TS (WS-SCN-SUB) (1:10)               
                                         TO 4H-ATTACH-EQUIP-DT          
           PERFORM 8200-INSERT-FXTR-ATTACHMTS THRU 8200-EXIT.           
      ***  INSERT NODE ATTACHMENT                                               
           IF SCN-NODE-SEQ-NO-CUR (WS-SCN-SUB) > 0                      
              MOVE SCN-NODE-SEQ-NO-CUR (WS-SCN-SUB)                     
                                      TO 4H-ATTACH-EQUIP-SEQ            
              COMPUTE 4H-ATTACH-SEQ-NO = 4H-ATTACH-SEQ-NO + 1           
              MOVE 'N'                TO 4H-EQUIP-TYPE-CD               
              PERFORM 8200-INSERT-FXTR-ATTACHMTS THRU 8200-EXIT         
           END-IF                                                       
                                                                        
      ***  WRITING TX HIST                                                      
           PERFORM 3382-FXTR-RPLC-TX-HIST     THRU 3382-EXIT.           
      ***  WRITING TX HIST                                                      
           PERFORM 3384-POLE-RPLC-TX-HIST     THRU 3384-EXIT.           
                                                                        
       3380-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       3382-FXTR-RPLC-TX-HIST.                                          
      *================================================================*        
                                                                        
      ***   SAY FIXTURE REMOVED                                                 
           INITIALIZE DCLLMS-TRANS-HIST                                 
                      DCLLMS-TRANS-HIST-DET.                            
           PERFORM 7045-GET-CURR-TS         THRU 7045-EXIT              
           MOVE 4J-TRANS-HIST-SEQ-NO     TO 4S-TRANS-HIST-SEQ-NO        
           MOVE SCN-FXTR-SEQ-NO-OLD (WS-SCN-SUB)                        
                                         TO 4J-EQUIP-SEQ                
                                            4S-EQUIP-SEQ                
           MOVE SCN-FXTR-TAG-NO-OLD (WS-SCN-SUB)                        
                                         TO 4J-EQUIP-TAG-NO             
           MOVE WS-PGM-NAME               TO 4J-APPL-PROGRAM-ID         
           MOVE SCN-REQUEST-ACTION-TS (WS-SCN-SUB) (1:10)               
                                          TO 4J-TRANS-DATE              
           MOVE SCN-SOURCE-APPL-CD (WS-SCN-SUB)                         
                                          TO 4J-SOURCE-APPL-CD          
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                          TO 4J-SOURCE-APPL-REQ-NO      
           MOVE SCN-WMS-POINT-OLD (WS-SCN-SUB)                          
                                          TO 4J-WMS-POINT-NO            
                                                                        
           MOVE SCN-FXTR-INS-LOC-NO-OLD  (WS-SCN-SUB)                   
                                          TO 4J-INSTALL-LOC-NO          
           MOVE SCN-FXTR-INS-POINT-NO-OLD  (WS-SCN-SUB)                 
                                          TO 4J-INSTALL-POINT-NO        
                                                                        
           MOVE SCN-ACCOUNT-NO (WS-SCN-SUB)                             
                                          TO 4J-ACCOUNT-NO              
      ***  TRANS COMMENTS START****                                             
           MOVE 1                          TO 4J-TRANS-COMMENTS-LEN     
           STRING 'FIXTURE '                  DELIMITED BY SIZE         
                  4J-EQUIP-TAG-NO             DELIMITED BY ' '          
                   ' REPLACED BY '            DELIMITED BY SIZE         
                  SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                      
                                              DELIMITED BY ' '          
                 INTO 4J-TRANS-COMMENTS-TEXT                            
                 WITH POINTER 4J-TRANS-COMMENTS-LEN                     
                                                                        
           COMPUTE 4J-TRANS-COMMENTS-LEN = 4J-TRANS-COMMENTS-LEN  - 1   
      ***  TRANS COMMENTS END  ****                                             
                                                                        
           MOVE 'LM100'                   TO 4J-LAST-UPDATE-USERID      
                                             4S-LAST-UPDATE-USERID      
                                                                        
           MOVE +1                        TO 4S-DETAIL-SEQ-NO           
           MOVE 'FIXTURE TAG'             TO 4S-COLUMN-DESC             
           MOVE 12                        TO 4S-PRV-COLUMN-VALUE-LEN    
           MOVE SCN-FXTR-TAG-NO-OLD (WS-SCN-SUB)                        
                                          TO 4S-PRV-COLUMN-VALUE-TEXT   
           MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN    
           MOVE '**REMOVED**'            TO 4S-CHG-COLUMN-VALUE-TEXT    
                                                                        
      ***   SAY FIXTURE INSTALLED                                               
           PERFORM 8400-INS-LMS-TRN-HST    THRU 8400-EXIT               
           PERFORM 8420-INS-LMS-TRN-HSTDET THRU 8420-EXIT.              
                                                                        
           MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO 4J-EQUIP-SEQ                
                                            4S-EQUIP-SEQ                
           MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                        
                                         TO 4J-EQUIP-TAG-NO             
                                                                        
           MOVE SCN-ACCOUNT-NO (WS-SCN-SUB)                             
                                          TO 4J-ACCOUNT-NO              
      ***  TRANS COMMENTS START****                                             
           MOVE 1                          TO 4J-TRANS-COMMENTS-LEN     
           STRING 'FIXTURE '                  DELIMITED BY SIZE         
                  SCN-FXTR-TAG-NO-OLD (WS-SCN-SUB)                      
                                              DELIMITED BY ' '          
                   ' WAS REPLACED WITH FIXTURE ' DELIMITED BY SIZE      
                  4J-EQUIP-TAG-NO             DELIMITED BY ' '          
                 INTO 4J-TRANS-COMMENTS-TEXT                            
                 WITH POINTER 4J-TRANS-COMMENTS-LEN                     
                                                                        
           COMPUTE 4J-TRANS-COMMENTS-LEN = 4J-TRANS-COMMENTS-LEN  - 1   
      ***  TRANS COMMENTS END  ****                                             
           MOVE 'LM100'                   TO 4J-LAST-UPDATE-USERID      
                                             4S-LAST-UPDATE-USERID      
           MOVE +1                        TO 4S-DETAIL-SEQ-NO           
           MOVE 'FIXTURE TAG'             TO 4S-COLUMN-DESC             
           MOVE 07                        TO 4S-PRV-COLUMN-VALUE-LEN    
           MOVE '**NEW**'                 TO 4S-PRV-COLUMN-VALUE-TEXT   
           MOVE 12                        TO 4S-CHG-COLUMN-VALUE-LEN    
           MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                        
                                          TO 4S-CHG-COLUMN-VALUE-TEXT   
           PERFORM 8400-INS-LMS-TRN-HST    THRU 8400-EXIT               
           PERFORM 8420-INS-LMS-TRN-HSTDET THRU 8420-EXIT.              
                                                                        
       3382-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       3384-POLE-RPLC-TX-HIST.                                          
      *================================================================*        
                                                                        
      ***   SAY POLE REMOVED                                                    
           INITIALIZE DCLLMS-TRANS-HIST                                 
                      DCLLMS-TRANS-HIST-DET.                            
           PERFORM 7045-GET-CURR-TS         THRU 7045-EXIT              
           MOVE 4J-TRANS-HIST-SEQ-NO     TO 4S-TRANS-HIST-SEQ-NO        
           MOVE SCN-POLE-SEQ-NO-OLD (WS-SCN-SUB)                        
                                         TO 4J-EQUIP-SEQ                
                                            4S-EQUIP-SEQ                
           MOVE SCN-REQ-POLE-NO-OLD (WS-SCN-SUB)                        
                                         TO 4J-EQUIP-TAG-NO             
           MOVE WS-PGM-NAME               TO 4J-APPL-PROGRAM-ID         
           MOVE SCN-REQUEST-ACTION-TS (WS-SCN-SUB) (1:10)               
                                          TO 4J-TRANS-DATE              
           MOVE SCN-SOURCE-APPL-CD (WS-SCN-SUB)                         
                                          TO 4J-SOURCE-APPL-CD          
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                          TO 4J-SOURCE-APPL-REQ-NO      
           MOVE SCN-WMS-POINT-OLD (WS-SCN-SUB)                          
                                          TO 4J-WMS-POINT-NO            
                                                                        
           MOVE SCN-POLE-INS-LOC-NO-OLD  (WS-SCN-SUB)                   
                                          TO 4J-INSTALL-LOC-NO          
           MOVE SCN-POLE-INS-POINT-NO-OLD  (WS-SCN-SUB)                 
                                          TO 4J-INSTALL-POINT-NO        
                                                                        
           MOVE SCN-ACCOUNT-NO (WS-SCN-SUB)                             
                                          TO 4J-ACCOUNT-NO              
      ***  TRANS COMMENTS START****                                             
           MOVE 1                          TO 4J-TRANS-COMMENTS-LEN     
           STRING 'POLE '                     DELIMITED BY SIZE         
                  4J-EQUIP-TAG-NO             DELIMITED BY ' '          
                   ' REPLACED BY '            DELIMITED BY SIZE         
                  SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                      
                                              DELIMITED BY ' '          
                 INTO 4J-TRANS-COMMENTS-TEXT                            
                 WITH POINTER 4J-TRANS-COMMENTS-LEN                     
                                                                        
           COMPUTE 4J-TRANS-COMMENTS-LEN = 4J-TRANS-COMMENTS-LEN  - 1   
      ***  TRANS COMMENTS END  ****                                             
           MOVE 'LM100'                   TO 4J-LAST-UPDATE-USERID      
                                             4S-LAST-UPDATE-USERID      
                                                                        
           MOVE +1                        TO 4S-DETAIL-SEQ-NO           
           MOVE 'POLE TAG'                TO 4S-COLUMN-DESC             
           MOVE 12                        TO 4S-PRV-COLUMN-VALUE-LEN    
           MOVE SCN-REQ-POLE-NO-OLD (WS-SCN-SUB)                        
                                          TO 4S-PRV-COLUMN-VALUE-TEXT   
           MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN    
           MOVE '**REMOVED**'             TO 4S-CHG-COLUMN-VALUE-TEXT   
                                                                        
      ***   SAY POLE INSTALLED                                                  
           PERFORM 8400-INS-LMS-TRN-HST    THRU 8400-EXIT               
           PERFORM 8420-INS-LMS-TRN-HSTDET THRU 8420-EXIT.              
           MOVE SCN-POLE-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO 4J-EQUIP-SEQ                
                                            4S-EQUIP-SEQ                
           MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                        
                                         TO 4J-EQUIP-TAG-NO             
                                                                        
           MOVE SCN-ACCOUNT-NO (WS-SCN-SUB)                             
                                          TO 4J-ACCOUNT-NO              
      ***  TRANS COMMENTS START****                                             
           MOVE 1                          TO 4J-TRANS-COMMENTS-LEN     
           STRING 'POLE '                     DELIMITED BY SIZE         
                  4J-EQUIP-TAG-NO             DELIMITED BY ' '          
                   ' INSTALLED BY REPLACING ' DELIMITED BY SIZE         
                  SCN-REQ-POLE-NO-OLD (WS-SCN-SUB)                      
                                              DELIMITED BY ' '          
                 INTO 4J-TRANS-COMMENTS-TEXT                            
                 WITH POINTER 4J-TRANS-COMMENTS-LEN                     
                                                                        
           COMPUTE 4J-TRANS-COMMENTS-LEN = 4J-TRANS-COMMENTS-LEN  - 1   
      ***  TRANS COMMENTS END  ****                                             
           MOVE 'LM100'                   TO 4J-LAST-UPDATE-USERID      
                                             4S-LAST-UPDATE-USERID      
           MOVE +1                        TO 4S-DETAIL-SEQ-NO           
           MOVE 'POLE TAG'                TO 4S-COLUMN-DESC             
           MOVE 07                        TO 4S-PRV-COLUMN-VALUE-LEN    
           MOVE '**NEW**'                 TO 4S-PRV-COLUMN-VALUE-TEXT   
           MOVE 12                        TO 4S-CHG-COLUMN-VALUE-LEN    
           MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                        
                                          TO 4S-CHG-COLUMN-VALUE-TEXT   
           PERFORM 8400-INS-LMS-TRN-HST    THRU 8400-EXIT               
           PERFORM 8420-INS-LMS-TRN-HSTDET THRU 8420-EXIT.              
       3384-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       3390-NOTIFY-RATE-CHANGES.                                        
      *================================================================*        
                                                                        
           IF SCN-FXTR-RATE-PLAN-OLD (WS-SCN-SUB)                       
                       = SCN-FXTR-RATE-PLAN-CUR (WS-SCN-SUB)            
              AND SCN-FXTR-RATE-ITEM-OLD  (WS-SCN-SUB)                  
                       = SCN-FXTR-RATE-ITEM-CUR  (WS-SCN-SUB)           
              AND SCN-POLE-RATE-PLAN-OLD (WS-SCN-SUB)                   
                       = SCN-POLE-RATE-PLAN-CUR (WS-SCN-SUB)            
              AND SCN-POLE-RATE-ITEM-OLD  (WS-SCN-SUB)                  
                       = SCN-POLE-RATE-ITEM-CUR  (WS-SCN-SUB)           
                 PERFORM 5760-TASK-VERIFY-REPLACE THRU 5760-EXIT        
           ELSE                                                         
              IF SCN-SOURCE-APPL-CD (WS-SCN-SUB) = 'CIS'                
                 PERFORM 5760-TASK-VERIFY-REPLACE THRU 5760-EXIT        
              ELSE                                                      
      ***     CREATE WQ: RATE CHANGE REQUIRED                                   
                 MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                  
                                      TO WS-TASK-FXTR-SEQ-NO            
                 MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                  
                                      TO WS-TASK-FXTR-TAG-NO            
                 MOVE SCN-FXTR-RATE-PLAN-CUR (WS-SCN-SUB)               
                                      TO WS-TASK-LMS-RATE               
                 MOVE SCN-FXTR-RATE-ITEM-CUR (WS-SCN-SUB)               
                                      TO WS-TASK-LMS-RATE-ITEM          
                 MOVE SCN-POLE-RATE-PLAN-CUR (WS-SCN-SUB)               
                                      TO WS-TASK-WMS-RATE               
                 MOVE SCN-POLE-RATE-ITEM-CUR (WS-SCN-SUB)               
                                      TO WS-TASK-WMS-RATE-ITEM          
                 PERFORM 5765-TASK-RATE-CHANGE-REQ THRU 5765-EXIT       
              END-IF                                                    
           END-IF.                                                      
       3390-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       3400-PROCESS-REPAIRS.                                            
      *================================================================*        
                                                                        
           MOVE 'REPAIR'                 TO WS-TASK-WORK-FLOW           
           SET NO-TASK-CREATED           TO TRUE                        
           IF AT-PREMISE-NO > 0                                         
              MOVE AT-PREMISE-NO         TO WS-PREMISE-NO-NUM           
           ELSE                                                         
      ***     CREATE WQ: ACCOUNT NEEDED                                         
              SET TASK-CREATED           TO TRUE                        
              MOVE SCN-FXTR-SEQ-NO-CUR  (WS-SCN-SUB)                    
                                         TO WS-TASK-FXTR-SEQ-NO         
              MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                     
                                         TO WS-TASK-FXTR-TAG-NO         
              PERFORM 5705-CREATE-ACC-REQ-TASK THRU 5705-EXIT           
           END-IF.                                                      
                                                                        
           IF SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB) = 0                      
              AND NO-TASK-CREATED                                       
      ***     CREATE WQ: FXTR NOT IN INVENTORY                                  
              SET TASK-CREATED           TO TRUE                        
              PERFORM 5710-TASK-FXTR-NOT-INVENTORY THRU 5710-EXIT       
           END-IF                                                       
                                                                        
           IF NO-TASK-CREATED                                           
              PERFORM 3420-CHECK-LIGHT-LOCATION THRU 3420-EXIT          
           END-IF.                                                      
           IF NO-TASK-CREATED                                           
              IF SCN-FXTR-BILLING-FL-CUR (WS-SCN-SUB) = 'Y'             
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM 5770-TASK-VERIFY-BILLING  THRU 5770-EXIT       
              END-IF                                                    
              PERFORM 3480-REPAIR-TX-HIST       THRU 3480-EXIT          
           ELSE                                                         
              MOVE 'E'            TO SCN-LOCAL-ACTION(WS-SCN-SUB)       
           END-IF.                                                      
           .                                                            
       3400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3420-CHECK-LIGHT-LOCATION.                                       
      *================================================================*        
                                                                        
           IF SCN-FXTR-INV-ST-CUR (WS-SCN-SUB) = 'J'                    
              AND SCN-FXTR-INS-LOC-NO-CUR (WS-SCN-SUB)                  
                               = WS-PREMISE-NO-NUM                      
      *** POLE ALSO SHOULD BE IN SAME PREMISE TO REMOVE                         
              MOVE WS-PREMISE-NO-NUM     TO 4F-INSTALL-LOC-NO           
              MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                     
                                         TO 4H-FXTR-EQUIP-SEQ           
              MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                     
                                         TO 4D-EQUIP-TAG-NO             
              MOVE 'P'                   TO 4D-EQUIP-TYPE-CD            
              PERFORM 7033-GET-POLE-LOCATION THRU 7033-EXIT             
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 4D-EQUIP-SEQ            TO                        
                               SCN-POLE-SEQ-NO-CUR (WS-SCN-SUB)         
                 MOVE 4D-INVENTRY-STATUS-CD   TO                        
                               SCN-POLE-INV-ST-CUR (WS-SCN-SUB)         
                 MOVE 4D-WRNTY-RECOUP-AMT     TO                        
                            SCN-POLE-WRNTY-AMT-CUR (WS-SCN-SUB)         
      ***     WE MAY NEED STOCK CODE CHECK LATER B/W RCVD VS SYSTEM             
      ***        MOVE 4D-STOCK-CD             TO                                
      ***                       SCN-POLE-STOCK-CUR (WS-SCN-SUB)                 
                 MOVE 4F-INSTALL-LOC-NO       TO                        
                           SCN-POLE-INS-LOC-NO-CUR (WS-SCN-SUB)         
                 MOVE 4F-INSTALL-POINT-NO     TO                        
                         SCN-POLE-INS-POINT-NO-CUR (WS-SCN-SUB)         
                 MOVE 4F-CODE-UTIL-TYPE       TO                        
                         SCN-POLE-UTIL-TYPE-CUR (WS-SCN-SUB)            
                 MOVE 4F-BILLING-FL           TO                        
                         SCN-POLE-BILLING-FL-CUR (WS-SCN-SUB)           
      ***        SWAP RATE FROM WMS WITH WHAT WAS SET UP IN CIS                 
                 MOVE 4F-RATE-PLAN-NO    TO SCN-POLE-RATE-PLAN-CUR      
                                            (WS-SCN-SUB)                
                 MOVE 4F-RATE-ITEM-CODE  TO SCN-POLE-RATE-ITEM-CUR      
                                            (WS-SCN-SUB)                
              ELSE                                                      
      ***        IF SCN-POLE-STOCK-CUR (WS-SCN-SUB) > SPACES                    
      ***     CREATE WQ POLE REMOVAL REVD WITH STOCK                            
      ***     POLE NOT AT THE LOCATION                                          
                    SET TASK-CREATED       TO TRUE                      
                    MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)               
                                         TO WS-TASK-FXTR-SEQ-NO         
                    MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)               
                                         TO WS-TASK-FXTR-TAG-NO         
                    MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)               
                                         TO WS-TASK-POLE-TAG-NO         
                    PERFORM 5745-TASK-POLE-NOT-EXISTS THRU 5745-EXIT    
      ***        END-IF                                                         
              END-IF                                                    
           ELSE                                                         
      ***     CREATE WQ FXTR NOT FOUND IN SYSTEM                                
              SET TASK-CREATED           TO TRUE                        
              MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                     
                                         TO WS-TASK-FXTR-SEQ-NO         
              MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                     
                                         TO WS-TASK-FXTR-TAG-NO         
              MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                     
                                         TO WS-TASK-POLE-TAG-NO         
              PERFORM 5740-TASK-FXTR-NOT-EXISTS THRU 5740-EXIT          
           END-IF.                                                      
                                                                        
       3420-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       3480-REPAIR-TX-HIST.                                             
      *================================================================*        
                                                                        
           INITIALIZE DCLLMS-TRANS-HIST                                 
                      DCLLMS-TRANS-HIST-DET.                            
           PERFORM 7045-GET-CURR-TS         THRU 7045-EXIT              
           MOVE 4J-TRANS-HIST-SEQ-NO     TO 4S-TRANS-HIST-SEQ-NO        
           MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO 4J-EQUIP-SEQ                
                                            4S-EQUIP-SEQ                
           MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                        
                                         TO 4J-EQUIP-TAG-NO             
           MOVE WS-PGM-NAME               TO 4J-APPL-PROGRAM-ID         
           MOVE SCN-REQUEST-ACTION-TS (WS-SCN-SUB) (1:10)               
                                          TO 4J-TRANS-DATE              
           MOVE SCN-SOURCE-APPL-CD (WS-SCN-SUB)                         
                                          TO 4J-SOURCE-APPL-CD          
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                          TO 4J-SOURCE-APPL-REQ-NO      
           MOVE SCN-WMS-POINT-CUR (WS-SCN-SUB)                          
                                          TO 4J-WMS-POINT-NO            
                                                                        
           MOVE SCN-FXTR-INS-LOC-NO-CUR  (WS-SCN-SUB)                   
                                          TO 4J-INSTALL-LOC-NO          
           MOVE SCN-FXTR-INS-POINT-NO-CUR  (WS-SCN-SUB)                 
                                          TO 4J-INSTALL-POINT-NO        
                                                                        
           MOVE SCN-ACCOUNT-NO (WS-SCN-SUB)                             
                                          TO 4J-ACCOUNT-NO              
      ***  TRANS COMMENTS START****                                             
           MOVE 1                          TO 4J-TRANS-COMMENTS-LEN     
           STRING 'FIXTURE/POLE: '            DELIMITED BY SIZE         
                  4J-EQUIP-TAG-NO             DELIMITED BY ' '          
                   '/'                        DELIMITED BY SIZE         
                  SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                      
                                              DELIMITED BY ' '          
                   ' REPAIR COMPLETED'                                  
                                              DELIMITED BY SIZE         
                 INTO 4J-TRANS-COMMENTS-TEXT                            
                 WITH POINTER 4J-TRANS-COMMENTS-LEN                     
                                                                        
           COMPUTE 4J-TRANS-COMMENTS-LEN = 4J-TRANS-COMMENTS-LEN  - 1   
      ***  TRANS COMMENTS END  ****                                             
                                                                        
           MOVE 'LM100'                   TO 4J-LAST-UPDATE-USERID      
                                             4S-LAST-UPDATE-USERID      
                                                                        
           PERFORM 8400-INS-LMS-TRN-HST    THRU 8400-EXIT.              
                                                                        
       3480-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       3500-PROCESS-AUDITS.                                             
      *================================================================*        
                                                                        
           MOVE 'AUDIT'                  TO WS-TASK-WORK-FLOW           
           SET NO-TASK-CREATED           TO TRUE                        
           IF SCN-FXTR-INV-ST-CUR (WS-SCN-SUB) = 'J'                    
              AND SCN-FXTR-INS-LOC-NO-CUR (WS-SCN-SUB)                  
                               = WS-PREMISE-NO-NUM                      
      *** POLE ALSO SHOULD BE IN SAME PREMISE TO REMOVE                         
              MOVE WS-PREMISE-NO-NUM     TO 4F-INSTALL-LOC-NO           
              MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                     
                                         TO 4H-FXTR-EQUIP-SEQ           
              MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                     
                                         TO 4D-EQUIP-TAG-NO             
              MOVE 'P'                   TO 4D-EQUIP-TYPE-CD            
              PERFORM 7033-GET-POLE-LOCATION THRU 7033-EXIT             
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 SET TASK-CREATED        TO TRUE                        
                 PERFORM 5795-TASK-AUDIT-DATA       THRU 5795-EXIT      
              END-IF                                                    
           ELSE                                                         
      ***     CREATE WQ FXTR NOT ABLE TO LOCATE IN SYSTEM                       
              SET TASK-CREATED           TO TRUE                        
              PERFORM 5795-TASK-AUDIT-DATA       THRU 5795-EXIT         
           END-IF.                                                      
           .                                                            
       3500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3600-VALIDATE-RATE.                                              
      *================================================================*        
                                                                        
           PERFORM 7020-SELECT-RATE      THRU 7020-EXIT                 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
      *** CREATE WQ                                                             
              SET TASK-CREATED           TO TRUE                        
              MOVE UP-RATE-PLAN-NO       TO WS-TASK-WMS-RATE            
              MOVE UP-RATE-ITEM-CODE     TO WS-TASK-WMS-RATE-ITEM       
              PERFORM 5720-TASK-RATE-NOT-FOUND THRU 5720-EXIT           
           END-IF                                                       
                                                                        
           .                                                            
       3600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       5100-REMOVE-LEADING-ZEROS.                                       
      *================================================================*        
                                                                        
           MOVE 12                            TO WS-CHAR-LENGTH         
           MOVE SPACES                        TO WS-OUT-STRING          
           IF WS-IN-CHAR (1) >= 'A' AND WS-IN-CHAR (1) <= 'Z'           
              MOVE WS-IN-CHAR (1)        TO WS-OUT-CHAR (1)             
              MOVE 2                     TO WS-OUT-SUB                  
           ELSE                                                         
              MOVE 1                     TO WS-OUT-SUB                  
           END-IF                                                       
                                                                        
           MOVE WS-OUT-SUB               TO WS-IN-SUB                   
                                                                        
           IF WS-IN-CHAR (WS-IN-SUB) = '0'                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-IN-STRING          TO WS-OUT-STRING               
              GO TO 5100-EXIT                                           
           END-IF                                                       
                                                                        
           SET LAST-CHAR-ZERO            TO TRUE                        
                                                                        
           PERFORM UNTIL WS-IN-SUB > WS-CHAR-LENGTH                     
                      OR LAST-CHAR-NON-ZERO                             
              IF WS-IN-CHAR (WS-IN-SUB) = '0'                           
                 CONTINUE                                               
              ELSE                                                      
                 SET LAST-CHAR-NON-ZERO  TO TRUE                        
                 MOVE WS-IN-STRING (WS-IN-SUB : )                       
                                TO   WS-OUT-STRING (WS-OUT-SUB : )      
              END-IF                                                    
              COMPUTE WS-IN-SUB = WS-IN-SUB  + 1                        
           END-PERFORM.                                                 
                                                                        
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
                                                                        
      *================================================================*        
       5500-CALL-CUST-PLAN-SYNC.                                        
      *================================================================*        
                                                                        
           PERFORM 6300-LM001-CUST-LIGHT-SYNC THRU 6300-LM001-EXIT      
                                                                        
           IF LM001-ERROR                                               
              MOVE LM001-ERR-SQLCODE     TO WS-ACTIVE-RETURN-CODE       
                                            WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSLM100 PROCESSING ERROR        **'          
              DISPLAY '** ABEND IN COPYBOOK CPDLM001       **'          
              DISPLAY '** ABEND IN PARAGRAPH ' LM001-ERR-PARAGRAPH-NO   
              DISPLAY '** ACCOUNT_NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '** ERROR TABLE1: ' LM001-ERR-TABLE1              
              DISPLAY '** ERROR TABLE2: ' LM001-ERR-TABLE2              
              DISPLAY LM001-ERR-COLUMN-1 ':' LM001-ERR-HOSTVAR-1        
              DISPLAY LM001-ERR-COLUMN-2 ':' LM001-ERR-HOSTVAR-2        
              DISPLAY LM001-ERR-COLUMN-3 ':' LM001-ERR-HOSTVAR-3        
              DISPLAY LM001-ERR-COLUMN-4 ':' LM001-ERR-HOSTVAR-4        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
           .                                                            
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       5600-CREATE-WQ-EACH-REQ.                                         
      *================================================================*        
           IF REQ-LOCAL-ACTION  (WS-REQ-SUB) = SPACES                   
              AND REQ-REQUEST-ACTION-TS (WS-REQ-SUB) (1:10)             
ACT076                             < WS-RUN-DATE-1DAY                   
ACT076*********                    < WS-RUN-DATE-4DAYS                          
              IF REQ-ACCOUNT-NO  (WS-REQ-SUB) IS NUMERIC                
                 AND REQ-ACCOUNT-NO  (WS-REQ-SUB) > ZERO                
                 AND AT-PREMISE-NO = 0                                  
                 MOVE REQ-ACCOUNT-NO  (WS-REQ-SUB)                      
                                         TO AT-ACCOUNT-NO               
                 PERFORM 7000-GET-PREMISE   THRU 7000-EXIT              
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    IF AT-CODE-ACCT-STAT = 'A' OR 'P'                   
                       CONTINUE                                         
                    ELSE                                                
                       MOVE AT-PREMISE-NO   TO WS-CPD99-PREMISE-NO      
                       PERFORM 6990-FETCH-CUR-ACCOUNT                   
                          THRU  6990-EXIT                               
                       IF WS-CPD99-ACCOUNT-NO = AT-ACCOUNT-NO           
                          CONTINUE                                      
                       ELSE                                             
                          MOVE WS-CPD99-ACCOUNT-NO                      
                                        TO AT-ACCOUNT-NO                
                                           REQ-ACCOUNT-NO (WS-REQ-SUB)  
A05084                    PERFORM 7000-GET-PREMISE                      
A05084                       THRU 7000-EXIT                             
                       END-IF                                           
                    END-IF                                              
                 ELSE                                                   
                    MOVE ZEROS        TO REQ-ACCOUNT-NO (WS-REQ-SUB)    
                                         AT-ACCOUNT-NO                  
                 END-IF                                                 
              END-IF                                                    
              IF AT-LOCAL-OFFICE > SPACES                               
                 MOVE AT-LOCAL-OFFICE TO WS-LOCAL-OFFICE                
              ELSE                                                      
                 MOVE REQ-LOCAL-OFFICE (WS-REQ-SUB)                     
                                      TO WS-LOCAL-OFFICE                
              END-IF                                                    
              PERFORM 5792-TASK-NO-HANDHELD   THRU 5792-EXIT            
              MOVE REQ-WMS-POINT-NO (WS-REQ-SUB)                        
                                         TO WS-WMS-POINT-NO1            
              MOVE 'E'                   TO WS-LOCAL-ACTION             
              PERFORM 5650-UPDATE-EACH-REQ    THRU 5650-EXIT            
                 VARYING WS-REQ-SUB1 FROM 1 BY 1                        
                    UNTIL WS-REQ-SUB1 > WS-REQ-ROW-COUNT                
           END-IF                                                       
           .                                                            
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       5650-UPDATE-EACH-REQ.                                            
      *================================================================*        
                                                                        
           IF REQ-WMS-POINT-NO (WS-REQ-SUB1)                            
                                         = WS-WMS-POINT-NO1             
                                           OR WS-WMS-POINT-NO2          
              MOVE WS-LOCAL-ACTION     TO                               
                              REQ-LOCAL-ACTION  (WS-REQ-SUB1)           
                              4O-REQUEST-STATUS-CD                      
              MOVE REQ-TRANS-SEQ-NO (WS-REQ-SUB1)                       
                                         TO 4O-TRANS-SEQ-NO             
              PERFORM 8300-UPDATE-REQ         THRU 8300-EXIT            
           END-IF                                                       
           .                                                            
       5650-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5660-UPDATE-UNMTCH-REQ.                                          
      *================================================================*        
                                                                        
           IF WS-WMS-POINT-NO1 = 0                                      
              AND REQ-LOCAL-ACTION  (WS-REQ-SUB1) = ' '                 
                                                                        
              MOVE WS-LOCAL-ACTION     TO                               
                              REQ-LOCAL-ACTION  (WS-REQ-SUB1)           
                              4O-REQUEST-STATUS-CD                      
              MOVE REQ-TRANS-SEQ-NO (WS-REQ-SUB1)                       
                                         TO 4O-TRANS-SEQ-NO             
              PERFORM 8300-UPDATE-REQ         THRU 8300-EXIT            
           END-IF                                                       
           .                                                            
       5660-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       5680-PROCESS-MISMATCH.                                           
      *================================================================*        
                                                                        
           EVALUATE TRUE                                                
              WHEN SCN-MISMATCH-TYPE (WS-SCN-SUB) = 'N0'                
                 IF SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB) > SPACES           
                    PERFORM 5710-TASK-FXTR-NOT-INVENTORY                
                       THRU 5710-EXIT                                   
                 ELSE                                                   
                    PERFORM 5756-TASK-FXTR-REQ                          
                       THRU 5756-EXIT                                   
                 END-IF                                                 
              WHEN SCN-MISMATCH-TYPE (WS-SCN-SUB) = 'N1'                
                 IF SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB) > SPACES           
                    PERFORM 5712-TASK-NEW-FXTR-NOT-INV                  
                       THRU 5712-EXIT                                   
                 ELSE                                                   
                    PERFORM 5755-TASK-NEW-FXTR-REQ                      
                       THRU 5755-EXIT                                   
                 END-IF                                                 
              WHEN SCN-MISMATCH-TYPE (WS-SCN-SUB) = 'N2'                
                 IF SCN-FXTR-TAG-NO-OLD (WS-SCN-SUB) > SPACES           
                    PERFORM 5711-TASK-OLD-FXTR-NOT-INV                  
                       THRU 5711-EXIT                                   
                 ELSE                                                   
                    PERFORM 5750-TASK-OLD-FXTR-REQ                      
                       THRU 5750-EXIT                                   
                 END-IF                                                 
              WHEN OTHER                                                
                 PERFORM 5785-TASK-MISMATCH-HH                          
                    THRU 5785-EXIT                                      
           END-EVALUATE                                                 
           .                                                            
       5680-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       5700-TASK-APPROVAL-REQ.                                          
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                          TO WS-77-ROUTE-CATEGORY      
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                           TO WS-77-LOCAL-OFFICE        
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE 560                        TO WS-77-CATEGORY-ID         
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR (WS-SCN-SUB)                          
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           IF SCN-REQ-POLE-NO-CUR (WS-SCN-SUB) > SPACES                 
           AND SCN-REQ-POLE-NO-CUR (WS-SCN-SUB) NOT =                   
               SCN-POLE-TAG-NO-CUR (WS-SCN-SUB)                         
               STRING 'NEW LIGHT WAS INSTALLED WITH POLE EXCEPTIONS.'   
                                                 DELIMITED BY SIZE      
                     '  PLEASE REVIEW THE'       DELIMITED BY SIZE      
                                                                        
                     ' LIGHT DETAILS, UPDATE AND START BILLING.'        
                                                 DELIMITED BY SIZE      
                      ' WMS POLE: '              DELIMITED BY SIZE      
                    SCN-REQ-POLE-NO-CUR (WS-SCN-SUB) DELIMITED BY ' '   
                      ', HH POLE: '               DELIMITED BY SIZE     
                    SCN-POLE-TAG-NO-CUR (WS-SCN-SUB) DELIMITED BY ' '   
                      ', FIXTURE TAG: '          DELIMITED BY SIZE      
                      WS-TASK-FXTR-TAG-NO        DELIMITED BY ' '       
                      ', ORDER: '                DELIMITED BY SIZE      
                      WS-TASK-ORDER-NO           DELIMITED BY SIZE      
                      ', POINT: '                DELIMITED BY SIZE      
                      WS-TASK-POINT-NO           DELIMITED BY SIZE      
                    INTO WS-77-COMMENTS-TEXT                            
                    WITH POINTER WS-77-COMMENTS-LEN                     
           ELSE                                                         
               STRING 'NEW LIGHT WAS INSTALLED. PLEASE REVIEW THE'      
                                                 DELIMITED BY SIZE      
                     ' LIGHT DETAILS, UPDATE AND START BILLING.'        
                                                 DELIMITED BY SIZE      
                      ' FIXTURE TAG: '           DELIMITED BY SIZE      
                      WS-TASK-FXTR-TAG-NO        DELIMITED BY ' '       
                      ', ORDER: '                 DELIMITED BY SIZE     
                      WS-TASK-ORDER-NO           DELIMITED BY SIZE      
                      ', POINT: '                 DELIMITED BY SIZE     
                      WS-TASK-POINT-NO           DELIMITED BY SIZE      
                    INTO WS-77-COMMENTS-TEXT                            
                    WITH POINTER WS-77-COMMENTS-LEN                     
           END-IF                                                       
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 13                      TO WS-77-FREE-FORM-LEN          
           MOVE 'DTL'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-NO     TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5700-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5705-CREATE-ACC-REQ-TASK.                                        
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                          TO WS-77-ROUTE-CATEGORY      
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                           TO WS-77-LOCAL-OFFICE        
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           EVALUATE SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB)                  
              WHEN 'I'                                                  
                 MOVE 562                  TO WS-77-CATEGORY-ID         
              WHEN 'D'                                                  
                 MOVE 563                  TO WS-77-CATEGORY-ID         
              WHEN 'C'                                                  
                 MOVE 564                  TO WS-77-CATEGORY-ID         
              WHEN 'M'                                                  
                 MOVE 565                  TO WS-77-CATEGORY-ID         
              WHEN 'R'                                                  
                 MOVE 566                  TO WS-77-CATEGORY-ID         
           END-EVALUATE                                                 
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR (WS-SCN-SUB)                          
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           STRING  'INVALID ACCOUNT NUMBER PROVIDED IN '                
                                              DELIMITED BY SIZE         
                   WS-TASK-ORDER-SRC          DELIMITED BY SIZE         
                   ' ORDER. PLEASE REVIEW.'   DELIMITED BY SIZE         
                   ' ORDER: '                 DELIMITED BY SIZE         
                   WS-TASK-ORDER-NO           DELIMITED BY SIZE         
                   ', POINT: '                DELIMITED BY SIZE         
                   WS-TASK-POINT-NO           DELIMITED BY SIZE         
                   ', FIXTURE TAG:'           DELIMITED BY SIZE         
                   WS-TASK-FXTR-TAG-NO        DELIMITED BY SIZE         
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 25                      TO WS-77-FREE-FORM-LEN          
           MOVE 'SRC'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-NO     TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-TASK-FXTR-TAG-NO     TO WS-77-FREE-FORM-TXT (14:)    
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5705-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5710-TASK-FXTR-NOT-INVENTORY.                                    
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                        TO WS-77-ROUTE-CATEGORY        
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                         TO WS-77-LOCAL-OFFICE          
           MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                        
                                         TO WS-TASK-FXTR-TAG-NO         
           MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                        
                                         TO WS-TASK-POLE-TAG-NO         
           MOVE SCN-FXTR-SEQ-NO-CUR  (WS-SCN-SUB)                       
                                         TO WS-TASK-FXTR-SEQ-NO         
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           EVALUATE SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB)                  
              WHEN 'I'                                                  
                 MOVE 562                  TO WS-77-CATEGORY-ID         
              WHEN 'D'                                                  
                 MOVE 563                  TO WS-77-CATEGORY-ID         
              WHEN 'C'                                                  
                 MOVE 564                  TO WS-77-CATEGORY-ID         
              WHEN 'M'                                                  
                 MOVE 565                  TO WS-77-CATEGORY-ID         
              WHEN 'R'                                                  
                 MOVE 566                  TO WS-77-CATEGORY-ID         
           END-EVALUATE                                                 
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
              STRING 'UNABLE TO PROCESS BECAUSE' DELIMITED BY SIZE      
                     ' FIXTURE NOT IN INVENTORY.' DELIMITED BY SIZE     
                      ' FIXTURE TAG: '           DELIMITED BY SIZE      
                      WS-TASK-FXTR-TAG-NO        DELIMITED BY ' '       
                      ', POLE TAG: '             DELIMITED BY SIZE      
                      WS-TASK-POLE-TAG-NO        DELIMITED BY ' '       
                      ', ORDER: '                DELIMITED BY SIZE      
                      WS-TASK-ORDER-NO           DELIMITED BY SIZE      
                      ', POINT: '                DELIMITED BY SIZE      
                      WS-TASK-POINT-NO           DELIMITED BY SIZE      
                      ', SOURCE: '               DELIMITED BY SIZE      
                      WS-TASK-ORDER-SRC          DELIMITED BY SIZE      
                    INTO WS-77-COMMENTS-TEXT                            
                    WITH POINTER WS-77-COMMENTS-LEN                     
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 25                      TO WS-77-FREE-FORM-LEN          
           MOVE 'SRC'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-NO     TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-TASK-FXTR-TAG-NO     TO WS-77-FREE-FORM-TXT (14:)    
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5710-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5711-TASK-OLD-FXTR-NOT-INV.                                      
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                          TO WS-77-ROUTE-CATEGORY      
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                           TO WS-77-LOCAL-OFFICE        
           MOVE SCN-FXTR-SEQ-NO-OLD (WS-SCN-SUB)                        
                                           TO WS-TASK-FXTR-SEQ-OLD      
           MOVE SCN-FXTR-TAG-NO-OLD (WS-SCN-SUB)                        
                                           TO WS-TASK-FXTR-TAG-OLD      
           MOVE SCN-REQ-POLE-NO-OLD (WS-SCN-SUB)                        
                                           TO WS-TASK-POLE-TAG-OLD      
           MOVE SCN-FXTR-SEQ-NO-CUR  (WS-SCN-SUB)                       
                                           TO WS-TASK-FXTR-SEQ-NO       
           MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                        
                                           TO WS-TASK-FXTR-TAG-NO       
           MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                        
                                           TO WS-TASK-POLE-TAG-NO       
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           EVALUATE SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB)                  
              WHEN 'I'                                                  
                 MOVE 562                  TO WS-77-CATEGORY-ID         
              WHEN 'D'                                                  
                 MOVE 563                  TO WS-77-CATEGORY-ID         
              WHEN 'C'                                                  
                 MOVE 564                  TO WS-77-CATEGORY-ID         
              WHEN 'M'                                                  
                 MOVE 565                  TO WS-77-CATEGORY-ID         
              WHEN 'R'                                                  
                 MOVE 566                  TO WS-77-CATEGORY-ID         
           END-EVALUATE                                                 
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
ACT081        STRING 'UNABLE TO PROCESS,' DELIMITED BY SIZE             
                  ' OLD FIXTURE NOT IN INVENTORY.' DELIMITED BY SIZE    
                      ' OLD FXTR TAG: '          DELIMITED BY SIZE      
                      WS-TASK-FXTR-TAG-OLD       DELIMITED BY ' '       
                      ',OLD POLE TAG: '          DELIMITED BY SIZE      
                      WS-TASK-POLE-TAG-OLD       DELIMITED BY ' '       
                      ',NEW FXTR TAG: '          DELIMITED BY SIZE      
                      WS-TASK-FXTR-TAG-NO        DELIMITED BY ' '       
                      ',NEW POLE TAG: '          DELIMITED BY SIZE      
                      WS-TASK-POLE-TAG-NO        DELIMITED BY ' '       
                      ', ORDER: '                DELIMITED BY SIZE      
                      WS-TASK-ORDER-NO           DELIMITED BY SIZE      
                      ', POINT: '                DELIMITED BY SIZE      
                      WS-TASK-POINT-NO           DELIMITED BY SIZE      
                      ', SOURCE: '               DELIMITED BY SIZE      
                      WS-TASK-ORDER-SRC          DELIMITED BY SIZE      
                    INTO WS-77-COMMENTS-TEXT                            
                    WITH POINTER WS-77-COMMENTS-LEN                     
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 25                      TO WS-77-FREE-FORM-LEN          
           MOVE 'SRC'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-OLD    TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-TASK-FXTR-TAG-OLD    TO WS-77-FREE-FORM-TXT (14:)    
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5711-EXIT.                                                       
      *================================================================*        
       5712-TASK-NEW-FXTR-NOT-INV.                                      
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                          TO WS-77-ROUTE-CATEGORY      
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                           TO WS-77-LOCAL-OFFICE        
           MOVE SCN-FXTR-SEQ-NO-OLD (WS-SCN-SUB)                        
                                           TO WS-TASK-FXTR-SEQ-OLD      
           MOVE SCN-FXTR-TAG-NO-OLD (WS-SCN-SUB)                        
                                           TO WS-TASK-FXTR-TAG-OLD      
           MOVE SCN-REQ-POLE-NO-OLD (WS-SCN-SUB)                        
                                           TO WS-TASK-POLE-TAG-OLD      
           MOVE SCN-FXTR-SEQ-NO-CUR  (WS-SCN-SUB)                       
                                           TO WS-TASK-FXTR-SEQ-NO       
           MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                        
                                           TO WS-TASK-FXTR-TAG-NO       
           MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                        
                                           TO WS-TASK-POLE-TAG-NO       
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           EVALUATE SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB)                  
              WHEN 'I'                                                  
                 MOVE 562                  TO WS-77-CATEGORY-ID         
              WHEN 'D'                                                  
                 MOVE 563                  TO WS-77-CATEGORY-ID         
              WHEN 'C'                                                  
                 MOVE 564                  TO WS-77-CATEGORY-ID         
              WHEN 'M'                                                  
                 MOVE 565                  TO WS-77-CATEGORY-ID         
              WHEN 'R'                                                  
                 MOVE 566                  TO WS-77-CATEGORY-ID         
           END-EVALUATE                                                 
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
              STRING 'UNABLE TO PROCESS BECAUSE' DELIMITED BY SIZE      
                  ' NEW FIXTURE NOT IN INVENTORY.' DELIMITED BY SIZE    
                      ' OLD FXTR TAG: '          DELIMITED BY SIZE      
                      WS-TASK-FXTR-TAG-OLD       DELIMITED BY ' '       
                      ',OLD POLE TAG: '          DELIMITED BY SIZE      
                      WS-TASK-POLE-TAG-OLD       DELIMITED BY ' '       
                      ',NEW FXTR TAG: '          DELIMITED BY SIZE      
                      WS-TASK-FXTR-TAG-NO        DELIMITED BY ' '       
                      ',NEW POLE TAG: '          DELIMITED BY SIZE      
                      WS-TASK-POLE-TAG-NO        DELIMITED BY ' '       
                      ', ORDER: '                DELIMITED BY SIZE      
                      WS-TASK-ORDER-NO           DELIMITED BY SIZE      
                      ', POINT: '                DELIMITED BY SIZE      
                      WS-TASK-POINT-NO           DELIMITED BY SIZE      
                      ', SOURCE: '               DELIMITED BY SIZE      
                      WS-TASK-ORDER-SRC          DELIMITED BY SIZE      
                    INTO WS-77-COMMENTS-TEXT                            
                    WITH POINTER WS-77-COMMENTS-LEN                     
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 25                      TO WS-77-FREE-FORM-LEN          
           MOVE 'SRC'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-NO     TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-TASK-FXTR-TAG-NO     TO WS-77-FREE-FORM-TXT (14:)    
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5712-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5715-TASK-FXTR-INSTALLED.                                        
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                        TO WS-77-ROUTE-CATEGORY        
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                         TO WS-77-LOCAL-OFFICE          
           MOVE SCN-FXTR-SEQ-NO-CUR  (WS-SCN-SUB)                       
                                         TO WS-TASK-FXTR-SEQ-NO         
           MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                        
                                         TO WS-TASK-FXTR-TAG-NO         
           MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                        
                                         TO WS-TASK-POLE-TAG-NO         
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE 562                        TO WS-77-CATEGORY-ID         
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           STRING 'NEW FIXTURE RECEIVED IN HANDHELD IS ALREADY'         
                                              DELIMITED BY SIZE         
                  ' INSTALLED STATUS IN LMS.' DELIMITED BY SIZE         
                   ' FIXTURE TAG: '           DELIMITED BY SIZE         
                   WS-TASK-FXTR-TAG-NO        DELIMITED BY ' '          
                   ', POLE TAG: '             DELIMITED BY SIZE         
                   WS-TASK-POLE-TAG-NO        DELIMITED BY ' '          
                   ', ORDER: '                DELIMITED BY SIZE         
                   WS-TASK-ORDER-NO           DELIMITED BY SIZE         
                   ', POINT: '                DELIMITED BY SIZE         
                   WS-TASK-POINT-NO           DELIMITED BY SIZE         
                   ', SOURCE: '               DELIMITED BY SIZE         
                   WS-TASK-ORDER-SRC          DELIMITED BY SIZE         
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 25                      TO WS-77-FREE-FORM-LEN          
           MOVE 'DTL'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-NO     TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-TASK-FXTR-TAG-NO     TO WS-77-FREE-FORM-TXT (14:)    
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5715-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5720-TASK-RATE-NOT-FOUND.                                        
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                          TO WS-77-ROUTE-CATEGORY      
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                           TO WS-77-LOCAL-OFFICE        
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           EVALUATE SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB)                  
              WHEN 'I'                                                  
                 MOVE 562                  TO WS-77-CATEGORY-ID         
              WHEN 'D'                                                  
                 MOVE 563                  TO WS-77-CATEGORY-ID         
              WHEN 'C'                                                  
                 MOVE 564                  TO WS-77-CATEGORY-ID         
              WHEN 'M'                                                  
                 MOVE 565                  TO WS-77-CATEGORY-ID         
              WHEN 'R'                                                  
                 MOVE 566                  TO WS-77-CATEGORY-ID         
           END-EVALUATE                                                 
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           STRING 'WMS RATE NOT FOUND IN CIS SYSTEM.'                   
                                              DELIMITED BY SIZE         
                   ' WMS RATE: '              DELIMITED BY SIZE         
                   WS-TASK-WMS-RATE           DELIMITED BY SIZE         
                   ' RATE ITEM: '             DELIMITED BY SIZE         
                   WS-TASK-WMS-RATE-ITEM      DELIMITED BY SIZE         
                   ', FIXTURE TAG: '          DELIMITED BY SIZE         
                   WS-TASK-FXTR-TAG-NO        DELIMITED BY '  '         
                   ', ORDER: '                DELIMITED BY SIZE         
                   WS-TASK-ORDER-NO           DELIMITED BY SIZE         
                   ', POINT: '                DELIMITED BY SIZE         
                   WS-TASK-POINT-NO           DELIMITED BY SIZE         
                   ', SOURCE: '               DELIMITED BY SIZE         
                   WS-TASK-ORDER-SRC          DELIMITED BY SIZE         
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 25                      TO WS-77-FREE-FORM-LEN          
           MOVE 'SRC'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-NO     TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-TASK-FXTR-TAG-NO     TO WS-77-FREE-FORM-TXT (14:)    
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5720-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5725-TASK-POLE-TAG-REQ.                                          
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                          TO WS-77-ROUTE-CATEGORY      
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                           TO WS-77-LOCAL-OFFICE        
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           EVALUATE SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB)                  
              WHEN 'I'                                                  
                 MOVE 562                  TO WS-77-CATEGORY-ID         
              WHEN 'D'                                                  
                 MOVE 563                  TO WS-77-CATEGORY-ID         
              WHEN 'C'                                                  
                 MOVE 564                  TO WS-77-CATEGORY-ID         
              WHEN 'M'                                                  
                 MOVE 565                  TO WS-77-CATEGORY-ID         
              WHEN 'R'                                                  
                 MOVE 566                  TO WS-77-CATEGORY-ID         
           END-EVALUATE                                                 
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           STRING 'POLE TAG REQUIRED.'                                  
                                              DELIMITED BY SIZE         
                   ' FIXTURE TAG: '           DELIMITED BY SIZE         
                   WS-TASK-FXTR-TAG-NO        DELIMITED BY ' '          
                   ', ORDER: '                DELIMITED BY SIZE         
                   WS-TASK-ORDER-NO           DELIMITED BY SIZE         
                   ', POINT: '                DELIMITED BY SIZE         
                   WS-TASK-POINT-NO           DELIMITED BY SIZE         
                   ', SOURCE: '               DELIMITED BY SIZE         
                   WS-TASK-ORDER-SRC          DELIMITED BY SIZE         
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 25                      TO WS-77-FREE-FORM-LEN          
A05084     MOVE 'SRC'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-NO     TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-TASK-FXTR-TAG-NO     TO WS-77-FREE-FORM-TXT (14:)    
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5725-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5730-TASK-NODE-NOT-EXITS.                                        
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 4                          TO WS-77-ROUTE-CATEGORY      
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                           TO WS-77-LOCAL-OFFICE        
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           EVALUATE SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB)                  
              WHEN 'I'                                                  
                 MOVE 562                  TO WS-77-CATEGORY-ID         
              WHEN 'D'                                                  
                 MOVE 563                  TO WS-77-CATEGORY-ID         
              WHEN 'C'                                                  
                 MOVE 564                  TO WS-77-CATEGORY-ID         
              WHEN 'M'                                                  
                 MOVE 565                  TO WS-77-CATEGORY-ID         
              WHEN 'R'                                                  
                 MOVE 566                  TO WS-77-CATEGORY-ID         
           END-EVALUATE                                                 
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           STRING 'NODE NOT IN INVENTORY OR ALREADY IN INSTALL'         
                                              DELIMITED BY SIZE         
                   ' STATUS.'                 DELIMITED BY SIZE         
                   ' FIXTURE TAG: '           DELIMITED BY SIZE         
                   WS-TASK-FXTR-TAG-NO        DELIMITED BY ' '          
                   ', ORDER: '                DELIMITED BY SIZE         
                   WS-TASK-ORDER-NO           DELIMITED BY SIZE         
                   ', POINT: '                DELIMITED BY SIZE         
                   WS-TASK-POINT-NO           DELIMITED BY SIZE         
                   ', SOURCE: '               DELIMITED BY SIZE         
                   WS-TASK-ORDER-SRC          DELIMITED BY SIZE         
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN.                       
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 25                      TO WS-77-FREE-FORM-LEN          
A05084     MOVE 'SRC'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-NO     TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-TASK-FXTR-TAG-NO     TO WS-77-FREE-FORM-TXT (14:)    
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5730-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5735-TASK-STOCK-INVALID.                                         
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                          TO WS-77-ROUTE-CATEGORY      
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                           TO WS-77-LOCAL-OFFICE        
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           STRING 'INVALID POLE STOCK CODE RECEIVED.'                   
                                              DELIMITED BY SIZE         
                   ' POLE STOCK: '            DELIMITED BY SIZE         
                   WS-TASK-POLE-STOCK         DELIMITED BY '  '         
                   ', POLE TAG: '             DELIMITED BY SIZE         
                   WS-TASK-POLE-TAG-NO        DELIMITED BY '  '         
                   ', FIXTURE TAG: '          DELIMITED BY SIZE         
                   WS-TASK-FXTR-TAG-NO        DELIMITED BY ' '          
                   ', ORDER: '                DELIMITED BY SIZE         
                   WS-TASK-ORDER-NO           DELIMITED BY SIZE         
                   ', POINT: '                DELIMITED BY SIZE         
                   WS-TASK-POINT-NO           DELIMITED BY SIZE         
                   ', SOURCE: '               DELIMITED BY SIZE         
                   WS-TASK-ORDER-SRC          DELIMITED BY SIZE         
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 25                      TO WS-77-FREE-FORM-LEN          
A05084     MOVE 'SRC'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-NO     TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-TASK-FXTR-TAG-NO     TO WS-77-FREE-FORM-TXT (14:)    
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5735-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5740-TASK-FXTR-NOT-EXISTS.                                       
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                          TO WS-77-ROUTE-CATEGORY      
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                           TO WS-77-LOCAL-OFFICE        
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           EVALUATE SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB)                  
              WHEN 'I'                                                  
                 MOVE 562                  TO WS-77-CATEGORY-ID         
              WHEN 'D'                                                  
                 MOVE 563                  TO WS-77-CATEGORY-ID         
              WHEN 'C'                                                  
                 MOVE 564                  TO WS-77-CATEGORY-ID         
              WHEN 'M'                                                  
                 MOVE 565                  TO WS-77-CATEGORY-ID         
              WHEN 'R'                                                  
                 MOVE 566                  TO WS-77-CATEGORY-ID         
           END-EVALUATE                                                 
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
      *** "FIXTURE NOT AT CUSTOMER LOCATION" REPLACED WITH"                     
           STRING 'ACCOUNT NUMBER DOES NOT MATCH.'                      
                                              DELIMITED BY SIZE         
                   ' FIXTURE TAG: '           DELIMITED BY SIZE         
                   WS-TASK-FXTR-TAG-NO        DELIMITED BY '  '         
                   ', POLE TAG: '             DELIMITED BY SIZE         
                   WS-TASK-POLE-TAG-NO        DELIMITED BY '  '         
                   ', ORDER: '                DELIMITED BY SIZE         
                   WS-TASK-ORDER-NO           DELIMITED BY SIZE         
                   ', POINT: '                DELIMITED BY SIZE         
                   WS-TASK-POINT-NO           DELIMITED BY SIZE         
                   ', SOURCE: '               DELIMITED BY SIZE         
                   WS-TASK-ORDER-SRC          DELIMITED BY SIZE         
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 25                      TO WS-77-FREE-FORM-LEN          
A05084     MOVE 'SRC'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-NO     TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-TASK-FXTR-TAG-NO     TO WS-77-FREE-FORM-TXT (14:)    
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5740-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5745-TASK-POLE-NOT-EXISTS.                                       
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                          TO WS-77-ROUTE-CATEGORY      
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                           TO WS-77-LOCAL-OFFICE        
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           EVALUATE SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB)                  
              WHEN 'I'                                                  
                 MOVE 562                  TO WS-77-CATEGORY-ID         
              WHEN 'D'                                                  
                 MOVE 563                  TO WS-77-CATEGORY-ID         
              WHEN 'C'                                                  
                 MOVE 564                  TO WS-77-CATEGORY-ID         
              WHEN 'M'                                                  
                 MOVE 565                  TO WS-77-CATEGORY-ID         
              WHEN 'R'                                                  
                 MOVE 566                  TO WS-77-CATEGORY-ID         
           END-EVALUATE                                                 
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           STRING 'POLE NOT ASSOCIATED WITH  FIXTURE. '                 
                                              DELIMITED BY SIZE         
                   ' FIXTURE TAG: '           DELIMITED BY SIZE         
                   WS-TASK-FXTR-TAG-NO        DELIMITED BY '  '         
                   ', POLE TAG: '             DELIMITED BY SIZE         
                   WS-TASK-POLE-TAG-NO        DELIMITED BY '  '         
                   ', ORDER: '                DELIMITED BY SIZE         
                   WS-TASK-ORDER-NO           DELIMITED BY SIZE         
                   ', SOURCE: '               DELIMITED BY SIZE         
                   WS-TASK-ORDER-SRC          DELIMITED BY SIZE         
                   ', POINT: '                DELIMITED BY SIZE         
                   WS-TASK-POINT-NO           DELIMITED BY SIZE         
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 25                      TO WS-77-FREE-FORM-LEN          
A05084     MOVE 'SRC'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-NO     TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-TASK-FXTR-TAG-NO     TO WS-77-FREE-FORM-TXT (14:)    
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5745-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5750-TASK-OLD-FXTR-REQ.                                          
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                        TO WS-77-ROUTE-CATEGORY        
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                         TO WS-77-LOCAL-OFFICE          
           MOVE SCN-REQ-POLE-NO-OLD (WS-SCN-SUB)                        
                                         TO WS-TASK-POLE-TAG-OLD        
           MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                        
                                         TO WS-TASK-POLE-TAG-NO         
           MOVE SCN-FXTR-TAG-NO-OLD (WS-SCN-SUB)                        
                                         TO WS-TASK-FXTR-TAG-OLD        
           MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                        
                                         TO WS-TASK-FXTR-TAG-NO         
           MOVE SCN-FXTR-SEQ-NO-OLD  (WS-SCN-SUB)                       
                                         TO WS-TASK-FXTR-SEQ-OLD        
           MOVE SCN-FXTR-SEQ-NO-CUR  (WS-SCN-SUB)                       
                                         TO WS-TASK-FXTR-SEQ-NO         
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           IF SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB) = 'C'                  
      ***  REPLACE                                                              
              MOVE 564                  TO WS-77-CATEGORY-ID            
           ELSE                                                         
      ***  RELOCATE                                                             
              MOVE 565                  TO WS-77-CATEGORY-ID            
           END-IF                                                       
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           STRING 'OLD FIXTURE NOT PROVIDED.'                           
                                              DELIMITED BY SIZE         
                   ' NEW FXTR TAG: '          DELIMITED BY SIZE         
                   WS-TASK-FXTR-TAG-NO        DELIMITED BY '  '         
                   ', NEW POLE TAG: '         DELIMITED BY SIZE         
                   WS-TASK-POLE-TAG-NO        DELIMITED BY '  '         
                   ', OLD POLE TAG: '         DELIMITED BY SIZE         
                   WS-TASK-POLE-TAG-OLD       DELIMITED BY '  '         
                   ', ORDER: '                DELIMITED BY SIZE         
                   WS-TASK-ORDER-NO           DELIMITED BY SIZE         
                   ', SOURCE: '               DELIMITED BY SIZE         
                   WS-TASK-ORDER-SRC          DELIMITED BY SIZE         
                   ', POINT: '                DELIMITED BY SIZE         
                   WS-TASK-POINT-NO           DELIMITED BY SIZE         
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 25                      TO WS-77-FREE-FORM-LEN          
A05084     MOVE 'SRC'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-NO     TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-TASK-FXTR-TAG-NO     TO WS-77-FREE-FORM-TXT (14:)    
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5750-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5755-TASK-NEW-FXTR-REQ.                                          
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                        TO WS-77-ROUTE-CATEGORY        
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                         TO WS-77-LOCAL-OFFICE          
           MOVE SCN-REQ-POLE-NO-OLD (WS-SCN-SUB)                        
                                         TO WS-TASK-POLE-TAG-OLD        
           MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                        
                                         TO WS-TASK-POLE-TAG-NO         
           MOVE SCN-FXTR-TAG-NO-OLD (WS-SCN-SUB)                        
                                         TO WS-TASK-FXTR-TAG-OLD        
           MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                        
                                         TO WS-TASK-FXTR-TAG-NO         
           MOVE SCN-FXTR-SEQ-NO-OLD  (WS-SCN-SUB)                       
                                         TO WS-TASK-FXTR-SEQ-OLD        
           MOVE SCN-FXTR-SEQ-NO-CUR  (WS-SCN-SUB)                       
                                         TO WS-TASK-FXTR-SEQ-NO         
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           IF SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB) = 'C'                  
      ***  REPLACE                                                              
              MOVE 564                  TO WS-77-CATEGORY-ID            
           ELSE                                                         
      ***  RELOCATE                                                             
              MOVE 565                  TO WS-77-CATEGORY-ID            
           END-IF                                                       
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           STRING 'NEW FIXTURE NOT PROVIDED.'                           
                                              DELIMITED BY SIZE         
                   ' OLD FXTR TAG: '          DELIMITED BY SIZE         
                   WS-TASK-FXTR-TAG-OLD       DELIMITED BY '  '         
                   ', OLD POLE TAG: '         DELIMITED BY SIZE         
                   WS-TASK-POLE-TAG-OLD       DELIMITED BY '  '         
                   ', NEW POLE TAG: '         DELIMITED BY SIZE         
                   WS-TASK-POLE-TAG-NO        DELIMITED BY '  '         
                   ', ORDER: '                DELIMITED BY SIZE         
                   WS-TASK-ORDER-NO           DELIMITED BY SIZE         
                   ', SOURCE: '               DELIMITED BY SIZE         
                   WS-TASK-ORDER-SRC          DELIMITED BY SIZE         
                   ', POINT: '                DELIMITED BY SIZE         
                   WS-TASK-POINT-NO           DELIMITED BY SIZE         
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 25                      TO WS-77-FREE-FORM-LEN          
A05084     MOVE 'SRC'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-OLD    TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-TASK-FXTR-TAG-OLD    TO WS-77-FREE-FORM-TXT (14:)    
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5755-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5756-TASK-FXTR-REQ.                                              
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                        TO WS-77-ROUTE-CATEGORY        
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                         TO WS-77-LOCAL-OFFICE          
           MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                        
                                         TO WS-TASK-POLE-TAG-NO         
           MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                        
                                         TO WS-TASK-FXTR-TAG-NO         
           MOVE SCN-FXTR-SEQ-NO-CUR  (WS-SCN-SUB)                       
                                         TO WS-TASK-FXTR-SEQ-NO         
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           EVALUATE SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB)                  
              WHEN 'I'                                                  
                 MOVE 562                  TO WS-77-CATEGORY-ID         
              WHEN 'D'                                                  
                 MOVE 563                  TO WS-77-CATEGORY-ID         
              WHEN 'C'                                                  
                 MOVE 564                  TO WS-77-CATEGORY-ID         
              WHEN 'M'                                                  
                 MOVE 565                  TO WS-77-CATEGORY-ID         
              WHEN 'R'                                                  
                 MOVE 566                  TO WS-77-CATEGORY-ID         
           END-EVALUATE                                                 
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           STRING 'FIXTURE NOT PROVIDED.'                               
                                              DELIMITED BY SIZE         
                   ' FXTR TAG: '              DELIMITED BY SIZE         
                   WS-TASK-FXTR-TAG-NO        DELIMITED BY '  '         
                   ', POLE TAG: '             DELIMITED BY SIZE         
                   WS-TASK-POLE-TAG-NO        DELIMITED BY '  '         
                   ', ORDER: '                DELIMITED BY SIZE         
                   WS-TASK-ORDER-NO           DELIMITED BY SIZE         
                   ', SOURCE: '               DELIMITED BY SIZE         
                   WS-TASK-ORDER-SRC          DELIMITED BY SIZE         
                   ', POINT: '                DELIMITED BY SIZE         
                   WS-TASK-POINT-NO           DELIMITED BY SIZE         
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 25                      TO WS-77-FREE-FORM-LEN          
A05084     MOVE 'SRC'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-NO     TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-TASK-FXTR-TAG-NO     TO WS-77-FREE-FORM-TXT (14:)    
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5756-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5760-TASK-VERIFY-REPLACE.                                        
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                        TO WS-77-ROUTE-CATEGORY        
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                         TO WS-77-LOCAL-OFFICE          
           MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO WS-TASK-FXTR-SEQ-NO         
           MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                        
                                         TO WS-TASK-FXTR-TAG-NO         
           MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                        
                                         TO WS-TASK-POLE-TAG-NO         
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           IF SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB) = 'C'                  
      ***  REPLACE REVIEW                                                       
              MOVE 569                  TO WS-77-CATEGORY-ID            
           ELSE                                                         
      ***  RELOCATE REVIEW                                                      
              MOVE 559                  TO WS-77-CATEGORY-ID            
           END-IF                                                       
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           STRING 'ORDER PROCESSED SUCCESSFULLY.'                       
                                              DELIMITED BY SIZE         
                  ' PLEASE REVIEW LIGHT DETAILS.'                       
                                              DELIMITED BY SIZE         
                   ' FIXTURE TAG: '           DELIMITED BY SIZE         
                   WS-TASK-FXTR-TAG-NO        DELIMITED BY '  '         
                   ', POLE TAG: '             DELIMITED BY SIZE         
                   WS-TASK-POLE-TAG-NO        DELIMITED BY '  '         
                   ', ORDER: '                DELIMITED BY SIZE         
                   WS-TASK-ORDER-NO           DELIMITED BY SIZE         
                   ', SOURCE: '               DELIMITED BY SIZE         
                   WS-TASK-ORDER-SRC          DELIMITED BY SIZE         
                   ', POINT: '                DELIMITED BY SIZE         
                   WS-TASK-POINT-NO           DELIMITED BY SIZE         
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 25                      TO WS-77-FREE-FORM-LEN          
           MOVE 'DTL'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-NO     TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-TASK-FXTR-TAG-NO     TO WS-77-FREE-FORM-TXT (14:)    
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5760-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5765-TASK-RATE-CHANGE-REQ.                                       
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                          TO WS-77-ROUTE-CATEGORY      
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                           TO WS-77-LOCAL-OFFICE        
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           IF SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB) = 'C'                  
      ***  REPLACE REVIEW                                                       
              MOVE 569                  TO WS-77-CATEGORY-ID            
           ELSE                                                         
      ***  RELOCATE REVIEW                                                      
              MOVE 559                  TO WS-77-CATEGORY-ID            
           END-IF                                                       
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           STRING 'ORDER COMPLETED, BUT IT MAY REQUIRE RATE CHNG, '     
                                              DELIMITED BY SIZE         
                  'REVIEW AND UPDATE RATE.'                             
                                              DELIMITED BY SIZE         
                   ' NEW FXTR RATE: '         DELIMITED BY SIZE         
                   WS-TASK-LMS-RATE           DELIMITED BY SIZE         
                   '/'                        DELIMITED BY SIZE         
                   WS-TASK-LMS-RATE-ITEM      DELIMITED BY SIZE         
                   ', NEW POLE RATE: '        DELIMITED BY SIZE         
                   WS-TASK-WMS-RATE           DELIMITED BY SIZE         
                   '/'                        DELIMITED BY SIZE         
                   WS-TASK-WMS-RATE-ITEM      DELIMITED BY SIZE         
                   ', FIXTURE TAG: '          DELIMITED BY SIZE         
                   WS-TASK-FXTR-TAG-NO        DELIMITED BY '  '         
                   ', ORDER: '                DELIMITED BY SIZE         
                   WS-TASK-ORDER-NO           DELIMITED BY SIZE         
                   ', SOURCE: '               DELIMITED BY SIZE         
                   WS-TASK-ORDER-SRC          DELIMITED BY SIZE         
                   ', POINT: '                DELIMITED BY SIZE         
                   WS-TASK-POINT-NO           DELIMITED BY SIZE         
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 25                      TO WS-77-FREE-FORM-LEN          
A05084     MOVE 'SRC'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-NO     TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-TASK-FXTR-TAG-NO     TO WS-77-FREE-FORM-TXT (14:)    
           MOVE WS-PGM-NAME             TO WS-77-CREATED-BY             
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5765-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5770-TASK-VERIFY-BILLING.                                        
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                        TO WS-77-ROUTE-CATEGORY        
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                         TO WS-77-LOCAL-OFFICE          
           MOVE SCN-FXTR-SEQ-NO-CUR  (WS-SCN-SUB)                       
                                         TO WS-TASK-FXTR-SEQ-NO         
           MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                        
                                         TO WS-TASK-FXTR-TAG-NO         
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           MOVE 572                        TO WS-77-CATEGORY-ID         
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           STRING 'LIGHT REPAIRED IS NOT BEING BILLED. '                
                                              DELIMITED BY SIZE         
                   ' FIXTURE TAG: '           DELIMITED BY SIZE         
                   WS-TASK-FXTR-TAG-NO        DELIMITED BY ' '          
                   ', ORDER: '                DELIMITED BY SIZE         
                   WS-TASK-ORDER-NO           DELIMITED BY SIZE         
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 13                      TO WS-77-FREE-FORM-LEN          
           MOVE 'DTL'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-NO     TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5770-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5775-TASK-VERIFY-TRMCHG.                                         
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                          TO WS-77-ROUTE-CATEGORY      
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                           TO WS-77-LOCAL-OFFICE        
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           MOVE 567                        TO WS-77-CATEGORY-ID         
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           STRING 'LIGHT REMOVE COMPLETED.'   DELIMITED BY SIZE         
                  ' REVIEW AND APPLY TERMINATION CHARGES.'              
                                              DELIMITED BY SIZE         
                   ' FIXTURE TAG: '           DELIMITED BY SIZE         
                   WS-TASK-FXTR-TAG-NO        DELIMITED BY '  '         
                   ', POLE TAG: '             DELIMITED BY SIZE         
                   WS-TASK-POLE-TAG-NO        DELIMITED BY '  '         
                   ', ORDER: '                DELIMITED BY SIZE         
                   WS-TASK-ORDER-NO           DELIMITED BY SIZE         
                   ', SOURCE: '               DELIMITED BY SIZE         
                   WS-TASK-ORDER-SRC          DELIMITED BY SIZE         
                   ', POINT: '                DELIMITED BY SIZE         
                   WS-TASK-POINT-NO           DELIMITED BY SIZE         
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 25                      TO WS-77-FREE-FORM-LEN          
           MOVE 'TRM'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-NO     TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-TASK-FXTR-TAG-NO     TO WS-77-FREE-FORM-TXT (14:)    
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5775-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5780-TASK-LAST-LIGHT-GONE.                                       
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                          TO WS-77-ROUTE-CATEGORY      
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                           TO WS-77-LOCAL-OFFICE        
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           MOVE 571                        TO WS-77-CATEGORY-ID         
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           STRING 'ALL LIGHTS HAVE BEEN REMOVED.'                       
                                              DELIMITED BY SIZE         
                   ' NEED TO FINAL BILL ACCOUNT.'                       
                                              DELIMITED BY SIZE         
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
           MOVE 'H'                        TO WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 0                       TO WS-77-FREE-FORM-LEN          
           MOVE SPACES                  TO WS-77-FREE-FORM-TXT          
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5780-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5785-TASK-MISMATCH-HH.                                           
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                          TO WS-77-ROUTE-CATEGORY      
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                           TO WS-77-LOCAL-OFFICE        
           MOVE SCN-REQ-POLE-NO-OLD (WS-SCN-SUB)                        
                                         TO WS-TASK-POLE-TAG-OLD        
           MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                        
                                         TO WS-TASK-POLE-TAG-NO         
           MOVE SCN-FXTR-TAG-NO-OLD (WS-SCN-SUB)                        
                                         TO WS-TASK-FXTR-TAG-OLD        
           MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                        
                                         TO WS-TASK-FXTR-TAG-NO         
           MOVE SCN-FXTR-SEQ-NO-OLD  (WS-SCN-SUB)                       
                                         TO WS-TASK-FXTR-SEQ-OLD        
           MOVE SCN-FXTR-SEQ-NO-CUR  (WS-SCN-SUB)                       
                                         TO WS-TASK-FXTR-SEQ-NO         
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           EVALUATE SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB)                  
              WHEN 'I'                                                  
                 MOVE 562                  TO WS-77-CATEGORY-ID         
              WHEN 'D'                                                  
                 MOVE 563                  TO WS-77-CATEGORY-ID         
              WHEN 'C'                                                  
                 MOVE 564                  TO WS-77-CATEGORY-ID         
              WHEN 'M'                                                  
                 MOVE 565                  TO WS-77-CATEGORY-ID         
              WHEN 'R'                                                  
                 MOVE 566                  TO WS-77-CATEGORY-ID         
              WHEN OTHER                                                
                 MOVE 566                  TO WS-77-CATEGORY-ID         
           END-EVALUATE                                                 
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           EVALUATE TRUE                                                
              WHEN SCN-MISMATCH-TYPE (WS-SCN-SUB) = 'P0'                
                 MOVE 'POLE MISMATCH'      TO WS-TASK-MISMATCH-DESC     
              WHEN SCN-MISMATCH-TYPE (WS-SCN-SUB) = 'F0'                
                 MOVE 'FIXTURE MISMATCH'   TO WS-TASK-MISMATCH-DESC     
              WHEN SCN-MISMATCH-TYPE (WS-SCN-SUB) = 'P1'                
                 MOVE 'NEW POLE MISMATCH'    TO WS-TASK-MISMATCH-DESC   
              WHEN SCN-MISMATCH-TYPE (WS-SCN-SUB) = 'F1'                
                 MOVE 'NEW FIXTURE MISMATCH' TO WS-TASK-MISMATCH-DESC   
              WHEN SCN-MISMATCH-TYPE (WS-SCN-SUB) = 'P2'                
                 MOVE 'OLD POLE MISMATCH'    TO WS-TASK-MISMATCH-DESC   
              WHEN SCN-MISMATCH-TYPE (WS-SCN-SUB) = 'F2'                
                 MOVE 'OLD FIXTURE MISMATCH' TO WS-TASK-MISMATCH-DESC   
              WHEN OTHER                                                
                 MOVE 'ORDER MISMATCH'       TO WS-TASK-MISMATCH-DESC   
           END-EVALUATE                                                 
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           IF SCN-MISMATCH-TYPE (WS-SCN-SUB) = 'P1' OR 'F1'             
                                            OR 'P2' OR 'F2'             
              STRING 'HANDHELD TRANSACTION NOT MATCHED WITH '           
                   WS-TASK-ORDER-SRC    DELIMITED BY SIZE               
                  ' ORDER DUE TO '            DELIMITED BY SIZE         
                  WS-TASK-MISMATCH-DESC       DELIMITED BY '  '         
                   '. HAND HELD DATA,'        DELIMITED BY SIZE         
                   ' ORDER: '                 DELIMITED BY SIZE         
                   WS-TASK-ORDER-NO           DELIMITED BY SIZE         
                   ', NEW FXTR: '             DELIMITED BY SIZE         
                   WS-TASK-FXTR-TAG-NO        DELIMITED BY ' '          
                   ', NEW POLE: '             DELIMITED BY SIZE         
                   WS-TASK-POLE-TAG-NO        DELIMITED BY ' '          
                   ', OLD FXTR: '             DELIMITED BY SIZE         
                   WS-TASK-FXTR-TAG-OLD       DELIMITED BY ' '          
                   ', OLD POLE: '             DELIMITED BY SIZE         
                   WS-TASK-POLE-TAG-OLD       DELIMITED BY ' '          
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
           ELSE                                                         
              STRING 'HANDHELD TRANSACTION NOT MATCHED WITH '           
                   WS-TASK-ORDER-SRC    DELIMITED BY SIZE               
                  ' ORDER DUE TO '            DELIMITED BY SIZE         
                  WS-TASK-MISMATCH-DESC       DELIMITED BY '  '         
                   '. HAND HELD DATA,'        DELIMITED BY SIZE         
                   ' ORDER: '                 DELIMITED BY SIZE         
                   WS-TASK-ORDER-NO           DELIMITED BY SIZE         
                   ', FIXTURE: '              DELIMITED BY SIZE         
                   WS-TASK-FXTR-TAG-NO        DELIMITED BY ' '          
                   ', POLE: '                 DELIMITED BY SIZE         
                   WS-TASK-POLE-TAG-NO        DELIMITED BY ' '          
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
           END-IF                                                       
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 25                      TO WS-77-FREE-FORM-LEN          
A05084     MOVE 'SRC'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-NO     TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-TASK-FXTR-TAG-NO     TO WS-77-FREE-FORM-TXT (14:)    
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5785-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5790-TASK-PART-WMS-MISMATCH.                                     
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                          TO WS-77-ROUTE-CATEGORY      
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                           TO WS-77-LOCAL-OFFICE        
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           EVALUATE SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB)                  
              WHEN 'I'                                                  
                 MOVE 562                  TO WS-77-CATEGORY-ID         
              WHEN 'D'                                                  
                 MOVE 563                  TO WS-77-CATEGORY-ID         
              WHEN 'C'                                                  
                 MOVE 564                  TO WS-77-CATEGORY-ID         
              WHEN 'M'                                                  
                 MOVE 565                  TO WS-77-CATEGORY-ID         
              WHEN 'R'                                                  
                 MOVE 566                  TO WS-77-CATEGORY-ID         
              WHEN OTHER                                                
                 MOVE 566                  TO WS-77-CATEGORY-ID         
           END-EVALUATE                                                 
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           STRING 'SOME WMS ORDER RECORDS NOT MATCHED'                  
                                        DELIMITED BY SIZE               
                  ' WITH HANDHELD.' DELIMITED BY SIZE                   
                   ' ORDER: '                 DELIMITED BY SIZE         
                   WS-TASK-ORDER-NO           DELIMITED BY SIZE         
                   ' SOURCE: '                DELIMITED BY SIZE         
                   WS-TASK-ORDER-SRC          DELIMITED BY SIZE         
                   ' POINT: '                 DELIMITED BY SIZE         
                   WS-TASK-POINT-NO           DELIMITED BY SIZE         
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 0                          TO WS-77-FREE-FORM-LEN       
           MOVE SPACES                     TO WS-77-FREE-FORM-TXT       
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5790-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5791-TASK-MISSING-WMS-REQ.                                       
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                          TO WS-77-ROUTE-CATEGORY      
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                           TO WS-77-LOCAL-OFFICE        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           EVALUATE SCN-WORK-FLOW-TYPE-CD (WS-SCN-SUB)                  
              WHEN 'I'                                                  
                 MOVE 562                  TO WS-77-CATEGORY-ID         
              WHEN 'D'                                                  
                 MOVE 563                  TO WS-77-CATEGORY-ID         
              WHEN 'C'                                                  
                 MOVE 564                  TO WS-77-CATEGORY-ID         
              WHEN 'M'                                                  
                 MOVE 565                  TO WS-77-CATEGORY-ID         
              WHEN 'R'                                                  
                 MOVE 566                  TO WS-77-CATEGORY-ID         
              WHEN OTHER                                                
                 MOVE 566                  TO WS-77-CATEGORY-ID         
           END-EVALUATE                                                 
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           STRING 'HANDHELD DATA RECEIVED, BUT '                        
                                        DELIMITED BY SIZE               
                  WS-TASK-ORDER-SRC     DELIMITED BY SIZE               
                  ' ORDER HAS NOT BEEN CLOSED.'                         
                                              DELIMITED BY SIZE         
                   ' ORDER: '                 DELIMITED BY SIZE         
                   WS-TASK-ORDER-NO           DELIMITED BY SIZE         
                   ', FIXTURE: '              DELIMITED BY SIZE         
                   WS-TASK-FXTR-TAG-NO        DELIMITED BY ' '          
                   ', POLE: '                 DELIMITED BY SIZE         
                   WS-TASK-POLE-TAG-NO        DELIMITED BY ' '          
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 25                      TO WS-77-FREE-FORM-LEN          
           MOVE 'SRC'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-NO     TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-TASK-FXTR-TAG-NO     TO WS-77-FREE-FORM-TXT (14:)    
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5791-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5792-TASK-NO-HANDHELD.                                           
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                          TO WS-77-ROUTE-CATEGORY      
           MOVE WS-LOCAL-OFFICE            TO WS-77-LOCAL-OFFICE        
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE 561                        TO WS-77-CATEGORY-ID         
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
      ***  WS-77-COMMENTS****                                                   
           MOVE REQ-SOURCE-APPL-REQ-NO (WS-REQ-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE REQ-SOURCE-APPL-CD     (WS-REQ-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE REQ-WMS-POINT-NO       (WS-REQ-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           STRING 'ORDER '                   DELIMITED BY SIZE          
                   WS-TASK-ORDER-SRC          DELIMITED BY SIZE         
                   ' HAS BEEN CLOSED, BUT HANDHELD DATA HAS NOT'        
                                              DELIMITED BY SIZE         
                   ' BEEN RECEIVED.'          DELIMITED BY SIZE         
                   ' ORDER: '                 DELIMITED BY SIZE         
                   WS-TASK-ORDER-NO           DELIMITED BY SIZE         
                   ', SOURCE: '               DELIMITED BY SIZE         
                   WS-TASK-ORDER-SRC          DELIMITED BY SIZE         
                   ', POINT: '                DELIMITED BY SIZE         
                   WS-TASK-POINT-NO           DELIMITED BY SIZE         
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 25                      TO WS-77-FREE-FORM-LEN          
           MOVE 'SRC'                   TO WS-77-FREE-FORM-TXT          
           MOVE '0000000000'            TO WS-77-FREE-FORM-TXT (4:10)   
           MOVE SPACES                  TO WS-77-FREE-FORM-TXT (14:12)  
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5792-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5793-TASK-NOTIFY-USER.                                           
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 4                          TO WS-77-ROUTE-CATEGORY      
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                           TO WS-77-LOCAL-OFFICE        
           IF WS-77-LOCAL-OFFICE > SPACES                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE '002'                   TO WS-77-LOCAL-OFFICE        
           END-IF.                                                      
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           MOVE 576                        TO WS-77-CATEGORY-ID         
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           STRING 'HANDHELD DATA RECEIVED, PLEASE CLOSE '               
                                        DELIMITED BY SIZE               
                  WS-TASK-ORDER-SRC     DELIMITED BY SIZE               
                  ' ORDER TO PROCESS IN LMS.'                           
                                              DELIMITED BY SIZE         
                   ' ORDER: '                 DELIMITED BY SIZE         
                   WS-TASK-ORDER-NO           DELIMITED BY SIZE         
                   ', FIXTURE: '              DELIMITED BY SIZE         
                   WS-TASK-FXTR-TAG-NO        DELIMITED BY ' '          
                   ', POLE: '                 DELIMITED BY SIZE         
                   WS-TASK-POLE-TAG-NO        DELIMITED BY ' '          
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE ZERO                    TO WS-77-FREE-FORM-LEN          
           MOVE SPACES                  TO WS-77-FREE-FORM-TXT          
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5793-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       5795-TASK-AUDIT-DATA.                                            
      *================================================================*        
                                                                        
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 1                        TO WS-77-ROUTE-CATEGORY        
           MOVE SCN-LOCAL-OFFICE (WS-SCN-SUB)                           
                                         TO WS-77-LOCAL-OFFICE          
           MOVE SCN-FXTR-SEQ-NO-CUR (WS-SCN-SUB)                        
                                         TO WS-TASK-FXTR-SEQ-NO         
           MOVE SCN-FXTR-TAG-NO-CUR (WS-SCN-SUB)                        
                                         TO WS-TASK-FXTR-TAG-NO         
           MOVE SCN-REQ-POLE-NO-CUR (WS-SCN-SUB)                        
                                         TO WS-TASK-POLE-TAG-NO         
                                                                        
           MOVE SPACES                     TO WS-77-USER-ID-ORIG        
           MOVE SPACES                     TO WS-77-USER-ID-ASGN        
           MOVE SPACES                     TO WS-77-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
           MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO          
           MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO         
           MOVE ZEROS                      TO WS-77-SERV-ORDER-NO       
           MOVE 570                        TO WS-77-CATEGORY-ID         
      ***  WS-77-COMMENTS****                                                   
           MOVE SCN-SOURCE-APPL-REQ-NO (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-NO          
           MOVE SCN-SOURCE-APPL-CD     (WS-SCN-SUB)                     
                                           TO WS-TASK-ORDER-SRC         
           MOVE SCN-WMS-POINT-CUR      (WS-SCN-SUB)                     
                                           TO WS-TASK-POINT-NO          
           MOVE 1                          TO WS-77-COMMENTS-LEN        
           STRING 'PROCESS AUDIT DATA.'                                 
                                              DELIMITED BY SIZE         
                   ' FIXTURE TAG: '           DELIMITED BY SIZE         
                   WS-TASK-FXTR-TAG-NO        DELIMITED BY '  '         
                   ', POLE TAG: '             DELIMITED BY SIZE         
                   WS-TASK-POLE-TAG-NO        DELIMITED BY '  '         
                 INTO WS-77-COMMENTS-TEXT                               
                 WITH POINTER WS-77-COMMENTS-LEN                        
                                                                        
           COMPUTE WS-77-COMMENTS-LEN = WS-77-COMMENTS-LEN - 1          
           MOVE WS-RUN-DATE                TO WS-77-DATE-REQUIRED(1:10) 
           MOVE SPACES                     TO WS-77-DATE-CREATED        
                                              WS-77-PRIORITY            
      ***  WS-77-FREE-FORM-AREA****                                             
           MOVE 25                      TO WS-77-FREE-FORM-LEN          
           MOVE 'SRC'                   TO WS-77-FREE-FORM-TXT          
           MOVE WS-TASK-FXTR-SEQ-NO     TO WS-77-FREE-FORM-TXT (4:)     
           MOVE WS-TASK-FXTR-TAG-NO     TO WS-77-FREE-FORM-TXT (14:)    
           MOVE WS-PGM-NAME                TO WS-77-CREATED-BY          
           PERFORM 5900-SETUP-WQ-ITEM      THRU 5900-EXIT.              
                                                                        
       5795-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       5900-SETUP-WQ-ITEM.                                              
      *================================================================*        
                                                                        
A05084     IF WS-77-LOCAL-OFFICE > SPACES                               
A05084        CONTINUE                                                  
A05084     ELSE                                                         
A05084        MOVE '002'                   TO WS-77-LOCAL-OFFICE        
A05084     END-IF.                                                      
A05084                                                                  
A05136     IF WS-SCN-SUB > 0 AND                                        
A05136        SCN-NODE-TAG-NO-OLD(WS-SCN-SUB) > ' '                     
A05136        MOVE ', NODE TAG OLD: ' TO                                
A05136             WS-77-COMMENTS-TEXT(WS-77-COMMENTS-LEN:16)           
A05136        ADD 16 TO WS-77-COMMENTS-LEN                              
A05136        MOVE SCN-NODE-TAG-NO-OLD(WS-SCN-SUB) TO                   
A05136             WS-77-COMMENTS-TEXT(WS-77-COMMENTS-LEN:12)           
A05136        ADD 12 TO WS-77-COMMENTS-LEN                              
A05136     END-IF.                                                      
A05136                                                                  
A05136     IF WS-SCN-SUB > 0 AND                                        
A05136        SCN-NODE-TAG-NO-CUR(WS-SCN-SUB) > ' '                     
A05136        MOVE ', NODE TAG CUR: ' TO                                
A05136             WS-77-COMMENTS-TEXT(WS-77-COMMENTS-LEN:16)           
A05136        ADD 16 TO WS-77-COMMENTS-LEN                              
A05136        MOVE SCN-NODE-TAG-NO-CUR(WS-SCN-SUB) TO                   
A05136             WS-77-COMMENTS-TEXT(WS-77-COMMENTS-LEN:12)           
A05136        ADD 12 TO WS-77-COMMENTS-LEN                              
A05136     END-IF.                                                      
                                                                        
           CALL SCSCB077 USING CWS00077-FIELDS,                         
                               ABEND-FILE,                              
                               RS-RETURN-CODE.                          
                                                                        
           MOVE RS-RETURN-CODE     TO WS-ACTIVE-RETURN-CODE.            
           IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '5900-SETUP-WQ-ITEM'                              
              DISPLAY 'CALL SCSCB077         '                          
              DISPLAY 'ACCOUNT-NO      ' AT-ACCOUNT-NO                  
              DISPLAY 'SOURCE REQ NO   ' 4N-SOURCE-APPL-REQ-NO          
              DISPLAY 'COMMENTS        ' WS-77-COMMENTS                 
              DISPLAY 'SQL RETURN CODE ' WS-DISPLAY-SQLCODE             
              PERFORM 9900-ABEND    THRU 9900-EXIT                      
           END-IF.                                                      
           .                                                            
       5900-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * COPYBOOK TO GET THE NEXT BUSINESS DAY                          *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00315                                                 
           END-EXEC.                                                            
      *================================================================*        
      *** 6240-GET-FCA00-COMMON-DATE                                   *        
      *================================================================*        
      *** COPYBOOK TO GET COMMON DATE FROM JOB PARM                             
       COPY CPD00040.                                                           
      *                                                                         
      *    6251-GET-FJC01-DATE.                                                 
       COPY CPD00037.                                                           
      *                                                                         
      *================================================================*        
      *6000-CPDLM3-LIGHT-CNTRCT-TERM                                   *        
      *================================================================*        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDLM003                                                  
           END-EXEC.                                                            
                                                                        
      *================================================================*        
      *6300-LM001-CUST-LITE-SYNC                                       *        
      *================================================================*        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDLM001                                                  
           END-EXEC.                                                            
                                                                        
      *================================================================*        
      *** 6990-FETCH-CUR-ACCOUNT                                       *        
      *================================================================*        
      * COPYBOOK TO GET THE MOST CURRENT ACCOUNT AT A PREMISE         *         
           EXEC SQL                                                             
               INCLUDE CPDCA099                                                 
           END-EXEC.                                                            
                                                                        
      *================================================================*        
       6995-CPD99-ERROR-ROUTINE.                                        
      *================================================================*        
      *                                                                         
           MOVE ZEROES  TO  WS-CPD99-ACCOUNT-NO.                        
                                                                        
           MOVE WS-CPD99-RETURN-CODE  TO WS-DISPLAY-SQLCODE             
           DISPLAY '****************************************'           
           DISPLAY '** PCSLM100 PROCESSING ERROR        **'             
           DISPLAY '** ABEND IN PARAGRAPH 6995          **'             
           DISPLAY '** PREMISE-NO = ' WS-CPD99-PREMISE-NO               
           DISPLAY '** SQLCODE    = ' WS-DISPLAY-SQLCODE                
           DISPLAY '****************************************'           
           PERFORM 9900-ABEND THRU 9900-EXIT.                           
      *                                                                         
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7000-GET-PREMISE.                                                
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT PREMISE_NO                                        
                     ,CUSTOMER_NO                                       
                     ,CODE_ACCT_STAT                                    
                     ,LOCAL_OFFICE                                      
                 INTO :AT-PREMISE-NO                                    
                     ,:AT-CUSTOMER-NO                                   
                     ,:AT-CODE-ACCT-STAT                                
                     ,:AT-LOCAL-OFFICE                                  
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PREMISE_NO                                                
MFA-TR*              ,CUSTOMER_NO                                               
MFA-TR*              ,CODE_ACCT_STAT                                            
MFA-TR*              ,LOCAL_OFFICE                                              
MFA-TR*          INTO :AT-PREMISE-NO                                            
MFA-TR*              ,:AT-CUSTOMER-NO                                           
MFA-TR*              ,:AT-CODE-ACCT-STAT                                        
MFA-TR*              ,:AT-LOCAL-OFFICE                                          
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '** PCSLM100 PROCESSING ERROR        **'          
              DISPLAY '** ABEND IN PARAGRAPH 7000          **'          
              DISPLAY '** ACCOUNT_NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7005-SELECT-EQUIP-ENVRNMT.                                       
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT CODE_UTIL_TYPE                                    
                     ,RATE_PLAN_NO                                      
                     ,RATE_ITEM_CODE                                    
                     ,BILLING_FL                                        
                     ,EQUIP_CONTRACT_FL                                 
                 INTO :4F-CODE-UTIL-TYPE                                
                     ,:4F-RATE-PLAN-NO                                  
                     ,:4F-RATE-ITEM-CODE                                
                     ,:4F-BILLING-FL                                    
                     ,:4F-EQUIP-CONTRACT-FL                             
                 FROM LMS_EQUIP_ENVRNMT WITH(READUNCOMMITTED)                   
               WHERE INSTALL_LOC_NO   = :4F-INSTALL-LOC-NO              
                 AND INSTALL_POINT_NO = :4F-INSTALL-POINT-NO            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_UTIL_TYPE                                            
MFA-TR*              ,RATE_PLAN_NO                                              
MFA-TR*              ,RATE_ITEM_CODE                                            
MFA-TR*              ,BILLING_FL                                                
MFA-TR*              ,EQUIP_CONTRACT_FL                                         
MFA-TR*          INTO :4F-CODE-UTIL-TYPE                                        
MFA-TR*              ,:4F-RATE-PLAN-NO                                          
MFA-TR*              ,:4F-RATE-ITEM-CODE                                        
MFA-TR*              ,:4F-BILLING-FL                                            
MFA-TR*              ,:4F-EQUIP-CONTRACT-FL                                     
MFA-TR*          FROM LMS_EQUIP_ENVRNMT                                         
MFA-TR*        WHERE INSTALL_LOC_NO   = :4F-INSTALL-LOC-NO                      
MFA-TR*          AND INSTALL_POINT_NO = :4F-INSTALL-POINT-NO                    
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7005                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '** PCSLM100 PROCESSING ERROR        **'          
              DISPLAY '** ABEND IN PARAGRAPH 7005          **'          
              DISPLAY '** INSTALL_LOC_NO   = ' 4F-INSTALL-LOC-NO        
              DISPLAY '** INSTALL_POINT_NO = ' 4F-INSTALL-POINT-NO      
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
      *                                                                         
       7005-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7010-GET-MAX-POINT.                                              
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT COALESCE(MAX(INSTALL_POINT_NO), 0) + 1              
                 INTO :4F-INSTALL-POINT-NO                              
                 FROM LMS_EQUIP_ENVRNMT WITH(READUNCOMMITTED)                   
               WHERE INSTALL_LOC_NO = :4F-INSTALL-LOC-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IFNULL(MAX(INSTALL_POINT_NO), 0) + 1                      
MFA-TR*          INTO :4F-INSTALL-POINT-NO                                      
MFA-TR*          FROM LMS_EQUIP_ENVRNMT                                         
MFA-TR*        WHERE INSTALL_LOC_NO = :4F-INSTALL-LOC-NO                        
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '** PCSLM100 PROCESSING ERROR        **'          
              DISPLAY '** ABEND IN PARAGRAPH 7010          **'          
              DISPLAY '** INSTALL_LOC_NO = ' 4F-INSTALL-LOC-NO          
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7015-GET-MAX-ATTACH-SEQ.                                         
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT COALESCE(MAX(ATTACH_SEQ_NO),0) + 1                   
                INTO :4H-ATTACH-SEQ-NO                                  
               FROM  LMS_FXTR_ATTACHMTS WITH(READUNCOMMITTED)                   
              WHERE  FXTR_EQUIP_SEQ = :4H-FXTR-EQUIP-SEQ                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IFNULL(MAX(ATTACH_SEQ_NO),0) + 1                           
MFA-TR*         INTO :4H-ATTACH-SEQ-NO                                          
MFA-TR*        FROM  LMS_FXTR_ATTACHMTS                                         
MFA-TR*       WHERE  FXTR_EQUIP_SEQ = :4H-FXTR-EQUIP-SEQ                        
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7015                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '** PCSLM100 PROCESSING ERROR        **'          
              DISPLAY '** ABEND IN PARAGRAPH 7015          **'          
              DISPLAY '** FXTR_EQUIP_SEQ = ' 4H-FXTR-EQUIP-SEQ          
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
       7015-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       7020-SELECT-RATE.                                                
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) CODE_UTIL_TYPE                                    
                 INTO :UP-CODE-UTIL-TYPE                                
                 FROM CSS_UNMTR_PLAN UP WITH(READUNCOMMITTED)                   
               WHERE UP.RATE_PLAN_NO    = :UP-RATE-PLAN-NO              
                 AND UP.RATE_ITEM_CODE  = :UP-RATE-ITEM-CODE            
                 AND UP.CODE_UTIL_TYPE IN ('U', 'E')                    
                 AND UP.VERSION_NO_CNTRL                                
                      = (SELECT MAX(RT.VERSION_NO_CNTRL)                
                          FROM  CSS_RATE_CREATOR RT
                           WITH(READUNCOMMITTED)                     
                         WHERE RT.CODE_UTIL_TYPE = UP.CODE_UTIL_TYPE    
                           AND RT.RATE_PLAN_NO   = UP.RATE_PLAN_NO      
                           AND RT.FROM_EFFECTIVE_DT <= 
              IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )     
                           AND RT.CODE_STATUS = 'A' )                   
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_UTIL_TYPE                                            
MFA-TR*          INTO :UP-CODE-UTIL-TYPE                                        
MFA-TR*          FROM CSS_UNMTR_PLAN UP                                         
MFA-TR*        WHERE UP.RATE_PLAN_NO    = :UP-RATE-PLAN-NO                      
MFA-TR*          AND UP.RATE_ITEM_CODE  = :UP-RATE-ITEM-CODE                    
MFA-TR*          AND UP.CODE_UTIL_TYPE IN ('U', 'E')                            
MFA-TR*          AND UP.VERSION_NO_CNTRL                                        
MFA-TR*               = (SELECT MAX(RT.VERSION_NO_CNTRL)                        
MFA-TR*                   FROM  CSS_RATE_CREATOR RT                             
MFA-TR*                  WHERE RT.CODE_UTIL_TYPE = UP.CODE_UTIL_TYPE            
MFA-TR*                    AND RT.RATE_PLAN_NO   = UP.RATE_PLAN_NO              
MFA-TR*                    AND RT.FROM_EFFECTIVE_DT <= :WS-RUN-DATE             
MFA-TR*                    AND RT.CODE_STATUS = 'A' )                           
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '** PCSLM100 PROCESSING ERROR        **'          
              DISPLAY '** ABEND IN PARAGRAPH 7020          **'          
              DISPLAY '** RATE_PLAN_NO   = ' UP-RATE-PLAN-NO            
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7030-CHECK-EQUIP-STATUS.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) EQUIP_SEQ,
              INVENTRY_STATUS_CD,
              WRNTY_RECOUP_AMT                                  
                 INTO :4D-EQUIP-SEQ                                     
                     ,:4D-INVENTRY-STATUS-CD                            
                     ,:4D-WRNTY-RECOUP-AMT                              
                 FROM LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)             
               WHERE EQUIP_TAG_NO   = :4D-EQUIP-TAG-NO                  
                 AND STOCK_CD       = :4D-STOCK-CD                      
                 AND EQUIP_TYPE_CD  = :4D-EQUIP-TYPE-CD                 
                 AND INVENTRY_STATUS_CD <> 'J'                          
                 AND NOT EXISTS (SELECT 1                               
                            FROM LMS_EQUIP_ENVRNMT [4F]
                           WITH(READUNCOMMITTED)                   
                            WHERE [4D].EQUIP_SEQ = [4F].EQUIP_SEQ )         
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT EQUIP_SEQ                                                 
MFA-TR*              ,INVENTRY_STATUS_CD                                        
MFA-TR*              ,WRNTY_RECOUP_AMT                                          
MFA-TR*          INTO :4D-EQUIP-SEQ                                             
MFA-TR*              ,:4D-INVENTRY-STATUS-CD                                    
MFA-TR*              ,:4D-WRNTY-RECOUP-AMT                                      
MFA-TR*          FROM LMS_EQUIP_INVENTRY 4D                                     
MFA-TR*        WHERE EQUIP_TAG_NO   = :4D-EQUIP-TAG-NO                          
MFA-TR*          AND STOCK_CD       = :4D-STOCK-CD                              
MFA-TR*          AND EQUIP_TYPE_CD  = :4D-EQUIP-TYPE-CD                         
MFA-TR*          AND INVENTRY_STATUS_CD <> 'J'                                  
MFA-TR*          AND NOT EXISTS (SELECT 1                                       
MFA-TR*                     FROM LMS_EQUIP_ENVRNMT 4F                           
MFA-TR*                     WHERE 4D.EQUIP_SEQ = 4F.EQUIP_SEQ )                 
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '** PCSLM100 PROCESSING ERROR        **'          
              DISPLAY '** ABEND IN PARAGRAPH 7030          **'          
              DISPLAY '** EQUIP_TAG_NO   = ' 4D-EQUIP-TAG-NO            
              DISPLAY '** STOCK_CD       = ' 4D-STOCK-CD                
              DISPLAY '** EQUIP_TYPE_CD  = ' 4D-EQUIP-TYPE-CD           
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7032-GET-FXTR-LOCATION.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT [4D].EQUIP_SEQ                                      
                     ,[4D].INVENTRY_STATUS_CD                             
                     ,[4D].WRNTY_RECOUP_AMT                               
                     ,[4D].STOCK_CD                                       
                     ,COALESCE([4F].INSTALL_LOC_NO, '          ')           
                     ,COALESCE([4F].INSTALL_POINT_NO, 0)                    
                     ,COALESCE([4F].CODE_UTIL_TYPE, ' ')                    
                     ,COALESCE([4F].BILLING_FL, ' ')                        
                     ,COALESCE([4F].EQUIP_CONTRACT_FL, ' ')                 
                 INTO :4D-EQUIP-SEQ                                     
                     ,:4D-INVENTRY-STATUS-CD                            
                     ,:4D-WRNTY-RECOUP-AMT                              
                     ,:4D-STOCK-CD                                      
                     ,:4F-INSTALL-LOC-NO                                
                     ,:4F-INSTALL-POINT-NO                              
                     ,:4F-CODE-UTIL-TYPE                                
                     ,:4F-BILLING-FL                                    
                     ,:4F-EQUIP-CONTRACT-FL                             
                 FROM LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)             
                  LEFT JOIN LMS_EQUIP_ENVRNMT  [4F]
                           WITH(READUNCOMMITTED)                       
                  ON [4D].EQUIP_SEQ      = [4F].EQUIP_SEQ                   
               WHERE EQUIP_TAG_NO   = :4D-EQUIP-TAG-NO                  
                 AND EQUIP_TYPE_CD  = :4D-EQUIP-TYPE-CD                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 4D.EQUIP_SEQ                                              
MFA-TR*              ,4D.INVENTRY_STATUS_CD                                     
MFA-TR*              ,4D.WRNTY_RECOUP_AMT                                       
MFA-TR*              ,4D.STOCK_CD                                               
MFA-TR*              ,IFNULL(4F.INSTALL_LOC_NO, '          ')                   
MFA-TR*              ,IFNULL(4F.INSTALL_POINT_NO, 0)                            
MFA-TR*              ,IFNULL(4F.CODE_UTIL_TYPE, ' ')                            
MFA-TR*              ,IFNULL(4F.BILLING_FL, ' ')                                
MFA-TR*              ,IFNULL(4F.EQUIP_CONTRACT_FL, ' ')                         
MFA-TR*          INTO :4D-EQUIP-SEQ                                             
MFA-TR*              ,:4D-INVENTRY-STATUS-CD                                    
MFA-TR*              ,:4D-WRNTY-RECOUP-AMT                                      
MFA-TR*              ,:4D-STOCK-CD                                              
MFA-TR*              ,:4F-INSTALL-LOC-NO                                        
MFA-TR*              ,:4F-INSTALL-POINT-NO                                      
MFA-TR*              ,:4F-CODE-UTIL-TYPE                                        
MFA-TR*              ,:4F-BILLING-FL                                            
MFA-TR*              ,:4F-EQUIP-CONTRACT-FL                                     
MFA-TR*          FROM LMS_EQUIP_INVENTRY 4D                                     
MFA-TR*           LEFT JOIN LMS_EQUIP_ENVRNMT  4F                               
MFA-TR*           ON 4D.EQUIP_SEQ      = 4F.EQUIP_SEQ                           
MFA-TR*        WHERE EQUIP_TAG_NO   = :4D-EQUIP-TAG-NO                          
MFA-TR*          AND EQUIP_TYPE_CD  = :4D-EQUIP-TYPE-CD                         
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7032                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '** PCSLM100 PROCESSING ERROR        **'          
              DISPLAY '** ABEND IN PARAGRAPH 7032          **'          
              DISPLAY '** EQUIP_TAG_NO   = ' 4D-EQUIP-TAG-NO            
              DISPLAY '** STOCK_CD       = ' 4D-STOCK-CD                
              DISPLAY '** EQUIP_TYPE_CD  = ' 4D-EQUIP-TYPE-CD           
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7032-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7033-GET-POLE-LOCATION.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT [4D].EQUIP_SEQ                                      
                     ,[4D].INVENTRY_STATUS_CD                             
                     ,[4D].WRNTY_RECOUP_AMT                               
                     ,[4D].STOCK_CD                                       
                     ,[4F].INSTALL_LOC_NO                                 
                     ,[4F].INSTALL_POINT_NO                               
                     ,[4F].CODE_UTIL_TYPE                                 
                     ,[4F].BILLING_FL                                     
                     ,[4F].RATE_PLAN_NO                                   
                     ,[4F].RATE_ITEM_CODE                                 
                 INTO :4D-EQUIP-SEQ                                     
                     ,:4D-INVENTRY-STATUS-CD                            
                     ,:4D-WRNTY-RECOUP-AMT                              
                     ,:4D-STOCK-CD                                      
                     ,:4F-INSTALL-LOC-NO                                
                     ,:4F-INSTALL-POINT-NO                              
                     ,:4F-CODE-UTIL-TYPE                                
                     ,:4F-BILLING-FL                                    
                     ,:4F-RATE-PLAN-NO                                  
                     ,:4F-RATE-ITEM-CODE                                
                 FROM LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)             
                     ,LMS_EQUIP_ENVRNMT  [4F] WITH(READUNCOMMITTED)             
                     ,LMS_FXTR_ATTACHMTS [4H] WITH(READUNCOMMITTED)             
               WHERE [4D].EQUIP_SEQ      = [4F].EQUIP_SEQ                   
                 AND [4F].EQUIP_SEQ      = [4H].ATTACH_EQUIP_SEQ            
                 AND [4H].EQUIP_TYPE_CD  = [4D].EQUIP_TYPE_CD               
                 AND [4H].FXTR_EQUIP_SEQ = :4H-FXTR-EQUIP-SEQ             
                 AND [4D].EQUIP_TAG_NO   = :4D-EQUIP-TAG-NO               
                 AND [4D].EQUIP_TYPE_CD  = :4D-EQUIP-TYPE-CD              
                 AND [4F].INSTALL_LOC_NO = :4F-INSTALL-LOC-NO             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 4D.EQUIP_SEQ                                              
MFA-TR*              ,4D.INVENTRY_STATUS_CD                                     
MFA-TR*              ,4D.WRNTY_RECOUP_AMT                                       
MFA-TR*              ,4D.STOCK_CD                                               
MFA-TR*              ,4F.INSTALL_LOC_NO                                         
MFA-TR*              ,4F.INSTALL_POINT_NO                                       
MFA-TR*              ,4F.CODE_UTIL_TYPE                                         
MFA-TR*              ,4F.BILLING_FL                                             
MFA-TR*              ,4F.RATE_PLAN_NO                                           
MFA-TR*              ,4F.RATE_ITEM_CODE                                         
MFA-TR*          INTO :4D-EQUIP-SEQ                                             
MFA-TR*              ,:4D-INVENTRY-STATUS-CD                                    
MFA-TR*              ,:4D-WRNTY-RECOUP-AMT                                      
MFA-TR*              ,:4D-STOCK-CD                                              
MFA-TR*              ,:4F-INSTALL-LOC-NO                                        
MFA-TR*              ,:4F-INSTALL-POINT-NO                                      
MFA-TR*              ,:4F-CODE-UTIL-TYPE                                        
MFA-TR*              ,:4F-BILLING-FL                                            
MFA-TR*              ,:4F-RATE-PLAN-NO                                          
MFA-TR*              ,:4F-RATE-ITEM-CODE                                        
MFA-TR*          FROM LMS_EQUIP_INVENTRY 4D                                     
MFA-TR*              ,LMS_EQUIP_ENVRNMT  4F                                     
MFA-TR*              ,LMS_FXTR_ATTACHMTS 4H                                     
MFA-TR*        WHERE 4D.EQUIP_SEQ      = 4F.EQUIP_SEQ                           
MFA-TR*          AND 4F.EQUIP_SEQ      = 4H.ATTACH_EQUIP_SEQ                    
MFA-TR*          AND 4H.EQUIP_TYPE_CD  = 4D.EQUIP_TYPE_CD                       
MFA-TR*          AND 4H.FXTR_EQUIP_SEQ = :4H-FXTR-EQUIP-SEQ                     
MFA-TR*          AND 4D.EQUIP_TAG_NO   = :4D-EQUIP-TAG-NO                       
MFA-TR*          AND 4D.EQUIP_TYPE_CD  = :4D-EQUIP-TYPE-CD                      
MFA-TR*          AND 4F.INSTALL_LOC_NO = :4F-INSTALL-LOC-NO                     
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7033                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '** PCSLM100 PROCESSING ERROR        **'          
              DISPLAY '** ABEND IN PARAGRAPH 7033          **'          
              DISPLAY '** 4H.FXTR_EQUIP_SEQ = ' 4H-FXTR-EQUIP-SEQ       
              DISPLAY '** 4D.EQUIP_TAG_NO   = ' 4D-EQUIP-TAG-NO         
              DISPLAY '** 4D.EQUIP_TYPE_CD  = ' 4D-EQUIP-TYPE-CD        
              DISPLAY '** 4F.INSTALL_LOC_NO = ' 4F-INSTALL-LOC-NO       
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7033-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7034-GET-NEXT-EQUIP-SEQ.                                         
      *================================================================*        
                                                                        
           EXEC SQL                                                     
             SELECT
              NEXT VALUE FOR SEQ_ID_EQUIP_SEQ
            INTO
              :4D-EQUIP-SEQ                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :4D-EQUIP-SEQ =                                                
MFA-TR*             NEXT VALUE FOR SEQ_ID_EQUIP_SEQ                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              WS-DISPLAY-SQLCODE        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  SELECT ERROR IN 7034                **'      
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**  STOCK-CD    = ' 4D-STOCK-CD                  
              DISPLAY '**  GET NEXT SEQ FROM SEQ_ID_EQUIP_SEQ  **'      
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7034-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7038-GET-NODE-SEQ.                                               
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT [4D].EQUIP_SEQ                                      
                     ,[4D].INVENTRY_STATUS_CD                             
                 INTO :4D-EQUIP-SEQ                                     
                     ,:4D-INVENTRY-STATUS-CD                            
                 FROM LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)             
               WHERE EQUIP_TAG_NO   = :4D-EQUIP-TAG-NO                  
                 AND EQUIP_TYPE_CD  = 'N'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 4D.EQUIP_SEQ                                              
MFA-TR*              ,4D.INVENTRY_STATUS_CD                                     
MFA-TR*          INTO :4D-EQUIP-SEQ                                             
MFA-TR*              ,:4D-INVENTRY-STATUS-CD                                    
MFA-TR*          FROM LMS_EQUIP_INVENTRY 4D                                     
MFA-TR*        WHERE EQUIP_TAG_NO   = :4D-EQUIP-TAG-NO                          
MFA-TR*          AND EQUIP_TYPE_CD  = 'N'                                       
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7038                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '** PCSLM100 PROCESSING ERROR        **'          
              DISPLAY '** ABEND IN PARAGRAPH 7038          **'          
              DISPLAY '** EQUIP_TAG_NO   = ' 4D-EQUIP-TAG-NO            
              DISPLAY '** EQUIP_TYPE_CD  = N'                           
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7038-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7040-VALIDATE-STOCK.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT 1                                                 
                 INTO :WS-STOCK-EXITS                                   
                 FROM LMS_MSTR_STCK_INFO [4A] WITH(READUNCOMMITTED)             
                WHERE [4A].STOCK_CD = :4D-STOCK-CD                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 1                                                         
MFA-TR*          INTO :WS-STOCK-EXITS                                           
MFA-TR*          FROM LMS_MSTR_STCK_INFO 4A                                     
MFA-TR*         WHERE 4A.STOCK_CD = :4D-STOCK-CD                                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              WS-DISPLAY-SQLCODE        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '**  SELECT ERROR IN 7040                **'     
               DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE          
               DISPLAY '**  STOCK-CD    = ' 4D-STOCK-CD                 
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7045-GET-CURR-TS.                                                
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :4J-TRANS-HIST-SEQ-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :4J-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  SELECT ERROR IN 7045                **'     
               DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE          
               DISPLAY '**  RUN DATE    = ' WS-RUN-DATE                 
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7045-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       7050-OPEN-MAIN-CRSR.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               OPEN MAIN_CRSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSLM100 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7050          **'        
              DISPLAY '**   REQUEST_STATUS_CD = SPACES       **'        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *================================================================*        
       7055-FETCH-MAIN-CRSR.                                            
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
             FETCH  MAIN_CRSR                                           
               INTO :4O-SOURCE-APPL-REQ-NO                              
                   ,:4O-SOURCE-APPL-CD                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSLM100 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7055          **'        
              DISPLAY '**   REQUEST_STATUS_CD = SPACES       **'        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7055-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *================================================================*        
       7060-CLOSE-MAIN-CRSR.                                            
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               CLOSE MAIN_CRSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSLM100 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7060          **'        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7100-OPEN-SCAN-DTL.                                              
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               OPEN SCAN_DTL_CRSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSLM100 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7100          **'        
              DISPLAY '**   HANDHELD_STATUS_CD = SPACES      **'        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *================================================================*        
       7110-FETCH-SCAN-DTL.                                             

MSQ008     MOVE 500 TO MSQ008-SCAN-DTL-CRSR
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
             FOR :MSQ008-SCAN-DTL-CRSR
              FETCH 
              FROM SCAN_DTL_CRSR         
               INTO :SCN-TRANS-SEQ-NO                                   
                   ,:SCN-TRANS-DATE                                     
                   ,:SCN-TRANS-TIME                                     
                   ,:SCN-WORK-FLOW-TYPE-CD                              
                   ,:SCN-FXTR-TAG-NO-OLD                                
                   ,:SCN-FXTR-TAG-NO-CUR                                
                   ,:SCN-POLE-TAG-NO-OLD                                
                   ,:SCN-POLE-TAG-NO-CUR                                
                   ,:SCN-NODE-TAG-NO-OLD                                
                   ,:SCN-NODE-TAG-NO-CUR                                
                   ,:SCN-FXTR-GPS-LATITUDE                              
                   ,:SCN-FXTR-GPS-LONGITUDE                             
                   ,:SCN-TRANS-USERID                                   
                   ,:SCN-SOURCE-APPL-CD                                 
                   ,:SCN-SOURCE-APPL-REQ-NO                             
                   ,:SCN-TRANS_STATUS_CD                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*      FETCH  NEXT ROWSET FROM SCAN_DTL_CRSR FOR 500  ROWS                
MFA-TR*        INTO :SCN-TRANS-SEQ-NO                                           
MFA-TR*            ,:SCN-TRANS-DATE                                             
MFA-TR*            ,:SCN-TRANS-TIME                                             
MFA-TR*            ,:SCN-WORK-FLOW-TYPE-CD                                      
MFA-TR*            ,:SCN-FXTR-TAG-NO-OLD                                        
MFA-TR*            ,:SCN-FXTR-TAG-NO-CUR                                        
MFA-TR*            ,:SCN-POLE-TAG-NO-OLD                                        
MFA-TR*            ,:SCN-POLE-TAG-NO-CUR                                        
MFA-TR*            ,:SCN-NODE-TAG-NO-OLD                                        
MFA-TR*            ,:SCN-NODE-TAG-NO-CUR                                        
MFA-TR*            ,:SCN-FXTR-GPS-LATITUDE                                      
MFA-TR*            ,:SCN-FXTR-GPS-LONGITUDE                                     
MFA-TR*            ,:SCN-TRANS-USERID                                           
MFA-TR*            ,:SCN-SOURCE-APPL-CD                                         
MFA-TR*            ,:SCN-SOURCE-APPL-REQ-NO                                     
MFA-TR*            ,:SCN-TRANS_STATUS_CD                                        
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-SCAN-DTL-CRSR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SQLERRD(3)              TO WS-SCN-ROW-COUNT          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSLM100 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7110          **'        
              DISPLAY '**   HANDHELD_STATUS_CD = SPACES      **'        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *================================================================*        
       7120-CLOSE-SCAN-DTL.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               CLOSE SCAN_DTL_CRSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSLM100 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7120          **'        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7150-OPEN-REQ-DTL.                                               
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               OPEN REQ_DTL_CRSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '** PCSLM100 PROCESSING ERROR        **'          
              DISPLAY '** ABEND IN PARAGRAPH 7100          **'          
              DISPLAY '** SOURCE_APPL_REQ_NO = ' 4O-SOURCE-APPL-REQ-NO  
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *================================================================*        
       7160-FETCH-REQ-DTL.                                              

MSQ008     MOVE 500 TO MSQ008-REQ-DTL-CRSR
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
             FOR :MSQ008-REQ-DTL-CRSR
              FETCH 
              FROM REQ_DTL_CRSR          
               INTO :REQ-TRANS-SEQ-NO                                   
                   ,:REQ-SOURCE-APPL-CD                                 
                   ,:REQ-SOURCE-APPL-REQ-NO                             
                   ,:REQ-WMS-POINT-NO                                   
                   ,:REQ-ORDER-TYPE-CD                                  
                   ,:REQ-WORK-TYPE-CD                                   
                   ,:REQ-RECORD-TYPE-CD                                 
                   ,:REQ-STOCK-CD                                       
                   ,:REQ-RATE-PLAN-NO                                   
                   ,:REQ-RATE-ITEM-CODE                                 
                   ,:REQ-POLE-TAG-NO                                    
                   ,:REQ-REQUEST-ACTION-TS                              
                   ,:REQ-REQUEST-ACTION-CD                              
                   ,:REQ-EQUIP-QTY                                      
                   ,:REQ-ACCOUNT-NO                                     
                   ,:REQ-REQUEST-STATUS-CD                              
                   ,:REQ-LOCAL-OFFICE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*      FETCH  NEXT ROWSET FROM REQ_DTL_CRSR FOR 500  ROWS                 
MFA-TR*        INTO :REQ-TRANS-SEQ-NO                                           
MFA-TR*            ,:REQ-SOURCE-APPL-CD                                         
MFA-TR*            ,:REQ-SOURCE-APPL-REQ-NO                                     
MFA-TR*            ,:REQ-WMS-POINT-NO                                           
MFA-TR*            ,:REQ-ORDER-TYPE-CD                                          
MFA-TR*            ,:REQ-WORK-TYPE-CD                                           
MFA-TR*            ,:REQ-RECORD-TYPE-CD                                         
MFA-TR*            ,:REQ-STOCK-CD                                               
MFA-TR*            ,:REQ-RATE-PLAN-NO                                           
MFA-TR*            ,:REQ-RATE-ITEM-CODE                                         
MFA-TR*            ,:REQ-POLE-TAG-NO                                            
MFA-TR*            ,:REQ-REQUEST-ACTION-TS                                      
MFA-TR*            ,:REQ-REQUEST-ACTION-CD                                      
MFA-TR*            ,:REQ-EQUIP-QTY                                              
MFA-TR*            ,:REQ-ACCOUNT-NO                                             
MFA-TR*            ,:REQ-REQUEST-STATUS-CD                                      
MFA-TR*            ,:REQ-LOCAL-OFFICE                                           
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-REQ-DTL-CRSR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SQLERRD(3)              TO WS-REQ-ROW-COUNT          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '** PCSLM100 PROCESSING ERROR        **'          
              DISPLAY '** ABEND IN PARAGRAPH 7160          **'          
              DISPLAY '** SOURCE_APPL_REQ_NO = ' 4O-SOURCE-APPL-REQ-NO  
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *================================================================*        
       7170-CLOSE-REQ-DTL.                                              
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               CLOSE REQ_DTL_CRSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSLM100 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7170          **'        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
      *                                                                         
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7200-OPEN-SCAN-NOM.                                              
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               OPEN SCAN_NOM_CRSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSLM100 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7200          **'        
              DISPLAY '**   HANDHELD_STATUS_CD = SPACES      **'        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *================================================================*        
       7210-FETCH-SCAN-NOM.                                             

MSQ008     MOVE 500 TO MSQ008-SCAN-NOM-CRSR
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
             FOR :MSQ008-SCAN-NOM-CRSR
              FETCH 
              FROM SCAN_NOM_CRSR         
               INTO :SCN-TRANS-SEQ-NO                                   
                   ,:SCN-TRANS-DATE                                     
                   ,:SCN-TRANS-TIME                                     
                   ,:SCN-WORK-FLOW-TYPE-CD                              
                   ,:SCN-FXTR-TAG-NO-OLD                                
                   ,:SCN-FXTR-TAG-NO-CUR                                
                   ,:SCN-POLE-TAG-NO-OLD                                
                   ,:SCN-POLE-TAG-NO-CUR                                
                   ,:SCN-NODE-TAG-NO-OLD                                
                   ,:SCN-NODE-TAG-NO-CUR                                
                   ,:SCN-FXTR-GPS-LATITUDE                              
                   ,:SCN-FXTR-GPS-LONGITUDE                             
                   ,:SCN-TRANS-USERID                                   
                   ,:SCN-SOURCE-APPL-CD                                 
                   ,:SCN-SOURCE-APPL-REQ-NO                             
                   ,:SCN-TRANS_STATUS_CD                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*      FETCH  NEXT ROWSET FROM SCAN_NOM_CRSR FOR 500  ROWS                
MFA-TR*        INTO :SCN-TRANS-SEQ-NO                                           
MFA-TR*            ,:SCN-TRANS-DATE                                             
MFA-TR*            ,:SCN-TRANS-TIME                                             
MFA-TR*            ,:SCN-WORK-FLOW-TYPE-CD                                      
MFA-TR*            ,:SCN-FXTR-TAG-NO-OLD                                        
MFA-TR*            ,:SCN-FXTR-TAG-NO-CUR                                        
MFA-TR*            ,:SCN-POLE-TAG-NO-OLD                                        
MFA-TR*            ,:SCN-POLE-TAG-NO-CUR                                        
MFA-TR*            ,:SCN-NODE-TAG-NO-OLD                                        
MFA-TR*            ,:SCN-NODE-TAG-NO-CUR                                        
MFA-TR*            ,:SCN-FXTR-GPS-LATITUDE                                      
MFA-TR*            ,:SCN-FXTR-GPS-LONGITUDE                                     
MFA-TR*            ,:SCN-TRANS-USERID                                           
MFA-TR*            ,:SCN-SOURCE-APPL-CD                                         
MFA-TR*            ,:SCN-SOURCE-APPL-REQ-NO                                     
MFA-TR*            ,:SCN-TRANS_STATUS_CD                                        
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-SCAN-NOM-CRSR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SQLERRD(3)              TO WS-SCN-ROW-COUNT          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSLM100 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7210          **'        
              DISPLAY '**   HANDHELD_STATUS_CD = SPACES      **'        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *================================================================*        
       7220-CLOSE-SCAN-NOM.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               CLOSE SCAN_NOM_CRSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSLM100 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7220          **'        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7300-GET-WARRANTY-EXP-DT.                                        
      *================================================================*        
                                                                        
           EXEC SQL                                                     
             SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-CURRENT-DATE = CURRENT DATE                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                WS-DISPLAY-SQLCODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '**  SET ERROR IN 7300-                  **'     
               DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE          
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7310-CHECK-FOR-LIGHTS.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 1                                                 
                 INTO :WS-METERS-LIGHTS-SW                              
                 FROM CSS_CUST_PLAN WITH(READUNCOMMITTED)                       
                WHERE ACCOUNT_NO       = :CP-ACCOUNT-NO                 
                  AND CODE_PLAN_STATUS = 'A'                            
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 1                                                         
MFA-TR*          INTO :WS-METERS-LIGHTS-SW                                      
MFA-TR*          FROM CSS_CUST_PLAN                                             
MFA-TR*         WHERE ACCOUNT_NO       = :CP-ACCOUNT-NO                         
MFA-TR*           AND CODE_PLAN_STATUS = 'A'                                    
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*       QUERYNO 7310                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              WS-DISPLAY-SQLCODE        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '**  SELECT ERROR IN 7310                **'     
               DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE          
               DISPLAY '**  ACCOUNT_NO       = ' CP-ACCOUNT-NO          
               DISPLAY '**  CODE_PLAN_STATUS =  A'                      
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7320-CHECK-FOR-METERS.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 1                                                 
                 INTO :WS-METERS-LIGHTS-SW                              
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO       = :MN-ACCOUNT-NO                 
                  AND CODE_METER_STATUS <> 'K'                          
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 1                                                         
MFA-TR*          INTO :WS-METERS-LIGHTS-SW                                      
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO       = :MN-ACCOUNT-NO                         
MFA-TR*           AND CODE_METER_STATUS <> 'K'                                  
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*       QUERYNO 7320                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              WS-DISPLAY-SQLCODE        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '**  SELECT ERROR IN 7320                **'     
               DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE          
               DISPLAY '**  ACCOUNT_NO       = ' MN-ACCOUNT-NO          
               DISPLAY '**  CODE_METER_STATUS <>  K'                    
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
      *** 7600-START-FCSJC01                                         *          
      *** 7610-READ-FCSJC01                                          *          
      *** 7611-CLOSE                                                 *          
      *==============================================================*          
      *** COPYBOOK TO GET GENERIC DATA FROM JOB PARM                            
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      *==============================================================*          
      *** 7620-START-FCSCA00                                         *          
      *** 7621-READ-FCSCA00                                          *          
      *** 7622-CLOSE-CA00-CSR                                        *          
      *==============================================================*          
      *** COPYBOOK TO GET SPECIAL DATA FROM JOB PARM (CA00)                     
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *================================================================*        
       8000-INSERT-LIGHT-ENV.                                           
      *================================================================*        
                                                                        
           EXEC SQL                                                     
           INSERT INTO LMS_EQUIP_ENVRNMT                                
                  ( INSTALL_LOC_NO                                      
                   ,INSTALL_POINT_NO                                    
                   ,EQUIP_SEQ                                           
                   ,INSTALL_LOC_CD                                      
                   ,CODE_UTIL_TYPE                                      
                   ,IC_NO                                               
                   ,RATE_PLAN_NO                                        
                   ,RATE_ITEM_CODE                                      
                   ,ITEM_SEQ_NO                                         
                   ,BILLING_FL                                          
                   ,NO_BILL_REASON_CD                                   
                   ,EQUIP_CONTRACT_FL                                   
                   ,NO_CONTRACT_RSN_CD                                  
                   ,EQUIP_OWNER_CD                                      
                   ,EQUIP_DRAWING_ID                                    
                   ,EQUIP_GIS_GKEY                                      
                   ,SOURCE_APPL_CD                                      
                   ,SOURCE_APPL_REQ_NO                                  
                   ,WMS_POINT_NO                                        
                   ,EQUIP_INSTALL_DT                                    
                   ,INSTALL_USERID                                      
                   ,APPROVED_TS                                         
                   ,APPROVER_USERID                                     
                   ,LAST_UPDATE_TS                                      
                   ,LAST_UPDATE_USERID                                  
                   ,SPCL_AGR_COMMENTS                                   
                   ,EQUIP_COMMENTS )                                    
           VALUES (:4F-INSTALL-LOC-NO                                   
                  ,:4F-INSTALL-POINT-NO                                 
                  ,:4F-EQUIP-SEQ                                        
                  ,:4F-INSTALL-LOC-CD                                   
                  ,:4F-CODE-UTIL-TYPE                                   
                  ,:4F-IC-NO                                            
                  ,:4F-RATE-PLAN-NO                                     
                  ,:4F-RATE-ITEM-CODE                                   
                  ,:4F-ITEM-SEQ-NO                                      
                  ,:4F-BILLING-FL                                       
                  ,:4F-NO-BILL-REASON-CD                                
                  ,:4F-EQUIP-CONTRACT-FL                                
                  ,:4F-NO-CONTRACT-RSN-CD                               
                  ,:4F-EQUIP-OWNER-CD                                   
                  ,:4F-EQUIP-DRAWING-ID                                 
                  ,:4F-EQUIP-GIS-GKEY                                   
                  ,:4F-SOURCE-APPL-CD                                   
                  ,:4F-SOURCE-APPL-REQ-NO                               
                  ,:4F-WMS-POINT-NO                                     
                  ,IIF(TRY_CONVERT(DATE, :4F-EQUIP-INSTALL-DT 
                                         :WS-EQUIP-INSTALL-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ) <> 0) OR (LEN(:4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ) <> 10), CIS.CHAR2DATE(:4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ), CONVERT(DATE, :4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ) )        
                  ,:4F-INSTALL-USERID                                   
                  ,CIS.CHAR2TIMESTAMP(:4F-APPROVED-TS 
                                      :WS-APPROVED-TS-IND)             
                  ,:4F-APPROVER-USERID                                  
                  ,CIS.CURRENT$TIMESTAMP()                                    
                  ,:4F-LAST-UPDATE-USERID                               
                  ,:4F-SPCL-AGR-COMMENTS                                
                  ,:4F-EQUIP-COMMENTS )                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    INSERT INTO LMS_EQUIP_ENVRNMT                                        
MFA-TR*           ( INSTALL_LOC_NO                                              
MFA-TR*            ,INSTALL_POINT_NO                                            
MFA-TR*            ,EQUIP_SEQ                                                   
MFA-TR*            ,INSTALL_LOC_CD                                              
MFA-TR*            ,CODE_UTIL_TYPE                                              
MFA-TR*            ,IC_NO                                                       
MFA-TR*            ,RATE_PLAN_NO                                                
MFA-TR*            ,RATE_ITEM_CODE                                              
MFA-TR*            ,ITEM_SEQ_NO                                                 
MFA-TR*            ,BILLING_FL                                                  
MFA-TR*            ,NO_BILL_REASON_CD                                           
MFA-TR*            ,EQUIP_CONTRACT_FL                                           
MFA-TR*            ,NO_CONTRACT_RSN_CD                                          
MFA-TR*            ,EQUIP_OWNER_CD                                              
MFA-TR*            ,EQUIP_DRAWING_ID                                            
MFA-TR*            ,EQUIP_GIS_GKEY                                              
MFA-TR*            ,SOURCE_APPL_CD                                              
MFA-TR*            ,SOURCE_APPL_REQ_NO                                          
MFA-TR*            ,WMS_POINT_NO                                                
MFA-TR*            ,EQUIP_INSTALL_DT                                            
MFA-TR*            ,INSTALL_USERID                                              
MFA-TR*            ,APPROVED_TS                                                 
MFA-TR*            ,APPROVER_USERID                                             
MFA-TR*            ,LAST_UPDATE_TS                                              
MFA-TR*            ,LAST_UPDATE_USERID                                          
MFA-TR*            ,SPCL_AGR_COMMENTS                                           
MFA-TR*            ,EQUIP_COMMENTS )                                            
MFA-TR*    VALUES (:4F-INSTALL-LOC-NO                                           
MFA-TR*           ,:4F-INSTALL-POINT-NO                                         
MFA-TR*           ,:4F-EQUIP-SEQ                                                
MFA-TR*           ,:4F-INSTALL-LOC-CD                                           
MFA-TR*           ,:4F-CODE-UTIL-TYPE                                           
MFA-TR*           ,:4F-IC-NO                                                    
MFA-TR*           ,:4F-RATE-PLAN-NO                                             
MFA-TR*           ,:4F-RATE-ITEM-CODE                                           
MFA-TR*           ,:4F-ITEM-SEQ-NO                                              
MFA-TR*           ,:4F-BILLING-FL                                               
MFA-TR*           ,:4F-NO-BILL-REASON-CD                                        
MFA-TR*           ,:4F-EQUIP-CONTRACT-FL                                        
MFA-TR*           ,:4F-NO-CONTRACT-RSN-CD                                       
MFA-TR*           ,:4F-EQUIP-OWNER-CD                                           
MFA-TR*           ,:4F-EQUIP-DRAWING-ID                                         
MFA-TR*           ,:4F-EQUIP-GIS-GKEY                                           
MFA-TR*           ,:4F-SOURCE-APPL-CD                                           
MFA-TR*           ,:4F-SOURCE-APPL-REQ-NO                                       
MFA-TR*           ,:4F-WMS-POINT-NO                                             
MFA-TR*           ,:4F-EQUIP-INSTALL-DT :WS-EQUIP-INSTALL-DT-IND                
MFA-TR*           ,:4F-INSTALL-USERID                                           
MFA-TR*           ,:4F-APPROVED-TS      :WS-APPROVED-TS-IND                     
MFA-TR*           ,:4F-APPROVER-USERID                                          
MFA-TR*           ,CURRENT TIMESTAMP                                            
MFA-TR*           ,:4F-LAST-UPDATE-USERID                                       
MFA-TR*           ,:4F-SPCL-AGR-COMMENTS                                        
MFA-TR*           ,:4F-EQUIP-COMMENTS )                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '**  INSERT ERROR IN 8000-               **'      
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**  INSTALL_LOC_NO   = ' 4F-INSTALL-LOC-NO       
              DISPLAY '**  INSTALL_POINT_NO = ' 4F-INSTALL-POINT-NO     
              DISPLAY '**  EQUIP_SEQ        = ' 4F-EQUIP-SEQ            
              DISPLAY '**  PROCESSING TERMINATED               **'      
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
           .                                                            
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8100-INSERT-LMS-INVENTORY.                                       
      *================================================================*        
                                                                        
           EXEC SQL                                                     
           INSERT INTO LMS_EQUIP_INVENTRY                               
                  ( EQUIP_SEQ                                           
                   ,EQUIP_TAG_NO                                        
                   ,COMPANY_NO                                          
                   ,CODE_SERVICE_TYPE                                   
                   ,STOCK_CD                                            
                   ,EQUIP_TYPE_CD                                       
                   ,EQUIP_MFR_CD                                        
                   ,EQUIP_MFR_DT                                        
                   ,WARRANTY_EXP_DT                                     
                   ,EQUIP_DISPOSAL_DT                                   
                   ,STORAGE_FAC_CD                                      
                   ,IN_TRANSIT_USERID                                   
                   ,INVENTRY_STATUS_CD                                  
                   ,WRNTY_RECEIVED_FL                                   
                   ,WRNTY_RECOUP_AMT                                    
                   ,LAST_UPDATE_TS                                      
                   ,LAST_UPDATE_USERID )                                
           VALUES (:4D-EQUIP-SEQ                                        
                  ,:4D-EQUIP-TAG-NO                                     
                  ,:4D-COMPANY-NO                                       
                  ,:4D-CODE-SERVICE-TYPE                                
                  ,:4D-STOCK-CD                                         
                  ,:4D-EQUIP-TYPE-CD                                    
                  ,:4D-EQUIP-MFR-CD                                     
                  ,IIF(TRY_CONVERT(DATE, :4D-EQUIP-MFR-DT 
                                         :WS-EQUIP-MFR-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :4D-EQUIP-MFR-DT 
                                                   :WS-EQUIP-MFR-DT-IND
              ) <> 0) OR (LEN(:4D-EQUIP-MFR-DT :WS-EQUIP-MFR-DT-IND
              ) <> 10), CIS.CHAR2DATE(:4D-EQUIP-MFR-DT 
                                                   :WS-EQUIP-MFR-DT-IND
              ), CONVERT(DATE, :4D-EQUIP-MFR-DT :WS-EQUIP-MFR-DT-IND) )        
                  ,IIF(TRY_CONVERT(DATE, :4D-WARRANTY-EXP-DT 
                                         :WS-WARRANTY-EXP-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :4D-WARRANTY-EXP-DT 
                                                :WS-WARRANTY-EXP-DT-IND
              ) <> 0) OR (LEN(:4D-WARRANTY-EXP-DT 
                                                :WS-WARRANTY-EXP-DT-IND
              ) <> 10), CIS.CHAR2DATE(:4D-WARRANTY-EXP-DT 
                                                :WS-WARRANTY-EXP-DT-IND
              ), CONVERT(DATE, :4D-WARRANTY-EXP-DT 
                                                :WS-WARRANTY-EXP-DT-IND
              ) )        
                  ,IIF(TRY_CONVERT(DATE, :4D-EQUIP-DISPOSAL-DT 
                                         :WS-EQUIP-DISPOSAL-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :4D-EQUIP-DISPOSAL-DT 
                                              :WS-EQUIP-DISPOSAL-DT-IND
              ) <> 0) OR (LEN(:4D-EQUIP-DISPOSAL-DT 
                                              :WS-EQUIP-DISPOSAL-DT-IND
              ) <> 10), CIS.CHAR2DATE(:4D-EQUIP-DISPOSAL-DT 
                                              :WS-EQUIP-DISPOSAL-DT-IND
              ), CONVERT(DATE, :4D-EQUIP-DISPOSAL-DT 
                                              :WS-EQUIP-DISPOSAL-DT-IND
              ) )      
                  ,:4D-STORAGE-FAC-CD                                   
                  ,:4D-IN-TRANSIT-USERID                                
                  ,:4D-INVENTRY-STATUS-CD                               
                  ,:4D-WRNTY-RECEIVED-FL                                
                  ,:4D-WRNTY-RECOUP-AMT                                 
                  ,CIS.CURRENT$TIMESTAMP()                                    
                  ,:4D-LAST-UPDATE-USERID )                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    INSERT INTO LMS_EQUIP_INVENTRY                                       
MFA-TR*           ( EQUIP_SEQ                                                   
MFA-TR*            ,EQUIP_TAG_NO                                                
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,CODE_SERVICE_TYPE                                           
MFA-TR*            ,STOCK_CD                                                    
MFA-TR*            ,EQUIP_TYPE_CD                                               
MFA-TR*            ,EQUIP_MFR_CD                                                
MFA-TR*            ,EQUIP_MFR_DT                                                
MFA-TR*            ,WARRANTY_EXP_DT                                             
MFA-TR*            ,EQUIP_DISPOSAL_DT                                           
MFA-TR*            ,STORAGE_FAC_CD                                              
MFA-TR*            ,IN_TRANSIT_USERID                                           
MFA-TR*            ,INVENTRY_STATUS_CD                                          
MFA-TR*            ,WRNTY_RECEIVED_FL                                           
MFA-TR*            ,WRNTY_RECOUP_AMT                                            
MFA-TR*            ,LAST_UPDATE_TS                                              
MFA-TR*            ,LAST_UPDATE_USERID )                                        
MFA-TR*    VALUES (:4D-EQUIP-SEQ                                                
MFA-TR*           ,:4D-EQUIP-TAG-NO                                             
MFA-TR*           ,:4D-COMPANY-NO                                               
MFA-TR*           ,:4D-CODE-SERVICE-TYPE                                        
MFA-TR*           ,:4D-STOCK-CD                                                 
MFA-TR*           ,:4D-EQUIP-TYPE-CD                                            
MFA-TR*           ,:4D-EQUIP-MFR-CD                                             
MFA-TR*           ,:4D-EQUIP-MFR-DT      :WS-EQUIP-MFR-DT-IND                   
MFA-TR*           ,:4D-WARRANTY-EXP-DT   :WS-WARRANTY-EXP-DT-IND                
MFA-TR*           ,:4D-EQUIP-DISPOSAL-DT :WS-EQUIP-DISPOSAL-DT-IND              
MFA-TR*           ,:4D-STORAGE-FAC-CD                                           
MFA-TR*           ,:4D-IN-TRANSIT-USERID                                        
MFA-TR*           ,:4D-INVENTRY-STATUS-CD                                       
MFA-TR*           ,:4D-WRNTY-RECEIVED-FL                                        
MFA-TR*           ,:4D-WRNTY-RECOUP-AMT                                         
MFA-TR*           ,CURRENT TIMESTAMP                                            
MFA-TR*           ,:4D-LAST-UPDATE-USERID )                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '**  INSERT ERROR IN 8100                **'      
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**  EQUIP-SEQ     ' 4D-EQUIP-SEQ                 
              DISPLAY '**  EQUIP-TAG-NO  ' 4D-EQUIP-TAG-NO              
              DISPLAY '**  COMPANY-NO    ' 4D-COMPANY-NO                
              DISPLAY '**  PROCESSING TERMINATED               **'      
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8120-UPDATE-LMS-INVENTORY.                                       
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              UPDATE LMS_EQUIP_INVENTRY                                 
                SET INVENTRY_STATUS_CD = :4D-INVENTRY-STATUS-CD         
                   ,LAST_UPDATE_TS  = CIS.CURRENT$TIMESTAMP()                 
                   ,LAST_UPDATE_USERID = 'LM100'                        
              WHERE EQUIP_SEQ = :4D-EQUIP-SEQ                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE LMS_EQUIP_INVENTRY                                         
MFA-TR*         SET INVENTRY_STATUS_CD = :4D-INVENTRY-STATUS-CD                 
MFA-TR*            ,LAST_UPDATE_TS  = CURRENT TIMESTAMP                         
MFA-TR*            ,LAST_UPDATE_USERID = 'LM100'                                
MFA-TR*       WHERE EQUIP_SEQ = :4D-EQUIP-SEQ                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** UPDATE ERROR IN 8120                **'       
              DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE            
              DISPLAY '** EQUIP_SEQ = ' 4D-EQUIP-SEQ                    
              DISPLAY '** PROCESSING TERMINATED               **'       
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
       8120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8140-UPDATE-LMS-ENV.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              UPDATE LMS_EQUIP_ENVRNMT                                  
                SET EQUIP_SEQ       = :4F-EQUIP-SEQ                     
                   ,LAST_UPDATE_TS  = CIS.CURRENT$TIMESTAMP()                 
                   ,LAST_UPDATE_USERID = 'LM100'                        
               WHERE INSTALL_LOC_NO   = :4F-INSTALL-LOC-NO              
                 AND INSTALL_POINT_NO = :4F-INSTALL-POINT-NO            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE LMS_EQUIP_ENVRNMT                                          
MFA-TR*         SET EQUIP_SEQ       = :4F-EQUIP-SEQ                             
MFA-TR*            ,LAST_UPDATE_TS  = CURRENT TIMESTAMP                         
MFA-TR*            ,LAST_UPDATE_USERID = 'LM100'                                
MFA-TR*        WHERE INSTALL_LOC_NO   = :4F-INSTALL-LOC-NO                      
MFA-TR*          AND INSTALL_POINT_NO = :4F-INSTALL-POINT-NO                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** UPDATE ERROR IN 8140                **'       
              DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE            
              DISPLAY '** INSTALL_LOC_NO   = ' 4F-INSTALL-LOC-NO        
              DISPLAY '** INSTALL_POINT_NO = ' 4F-INSTALL-POINT-NO      
              DISPLAY '** EQUIP_SEQ = ' 4F-EQUIP-SEQ                    
              DISPLAY '** PROCESSING TERMINATED               **'       
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
       8140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8200-INSERT-FXTR-ATTACHMTS.                                      
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              INSERT INTO LMS_FXTR_ATTACHMTS                            
                 (                                                      
                   FXTR_EQUIP_SEQ                                       
                  ,ATTACH_SEQ_NO                                        
                  ,EQUIP_TYPE_CD                                        
                  ,ATTACH_EQUIP_SEQ                                     
                  ,ATTACH_EQUIP_DT                                      
                  ,LAST_UPDATE_USERID                                   
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :4H-FXTR-EQUIP-SEQ                                   
                  ,:4H-ATTACH-SEQ-NO                                    
                  ,:4H-EQUIP-TYPE-CD                                    
                  ,:4H-ATTACH-EQUIP-SEQ                                 
                  ,IIF(TRY_CONVERT(DATE, :4H-ATTACH-EQUIP-DT
              ) IS NULL OR (PATINDEX('%.%', :4H-ATTACH-EQUIP-DT
              ) <> 0) OR (LEN(:4H-ATTACH-EQUIP-DT
              ) <> 10), CIS.CHAR2DATE(:4H-ATTACH-EQUIP-DT
              ), CONVERT(DATE, :4H-ATTACH-EQUIP-DT) )                          
                  ,'LM100'                                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO LMS_FXTR_ATTACHMTS                                    
MFA-TR*          (                                                              
MFA-TR*            FXTR_EQUIP_SEQ                                               
MFA-TR*           ,ATTACH_SEQ_NO                                                
MFA-TR*           ,EQUIP_TYPE_CD                                                
MFA-TR*           ,ATTACH_EQUIP_SEQ                                             
MFA-TR*           ,ATTACH_EQUIP_DT                                              
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :4H-FXTR-EQUIP-SEQ                                           
MFA-TR*           ,:4H-ATTACH-SEQ-NO                                            
MFA-TR*           ,:4H-EQUIP-TYPE-CD                                            
MFA-TR*           ,:4H-ATTACH-EQUIP-SEQ                                         
MFA-TR*           ,:4H-ATTACH-EQUIP-DT                                          
MFA-TR*           ,'LM100'                                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '**  INSERT ERROR IN 8200                **'      
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**  FXTR_EQUIP_SEQ = ' 4H-FXTR-EQUIP-SEQ         
              DISPLAY '**  ATTACH_SEQ_NO    ' 4H-ATTACH-SEQ-NO          
              DISPLAY '**  EQUIP_TYPE_CD    ' 4H-EQUIP-TYPE-CD          
              DISPLAY '**  ATTACH_EQUIP_SEQ ' 4H-ATTACH-EQUIP-SEQ       
              DISPLAY '**  EQUIP-TAG-NO  ' 4D-EQUIP-TAG-NO              
              DISPLAY '**  COMPANY-NO    ' 4D-COMPANY-NO                
              DISPLAY '**  PROCESSING TERMINATED               **'      
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       8220-UPDATE-FXTR-ATTACHMTS.                                      
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              UPDATE LMS_FXTR_ATTACHMTS                                 
                SET ATTACH_EQUIP_SEQ = :WS-ATTACH-EQUIP-SEQ             
                   ,ATTACH_EQUIP_DT = IIF(TRY_CONVERT(DATE, 
                                                    :4H-ATTACH-EQUIP-DT
              ) IS NULL OR (PATINDEX('%.%', :4H-ATTACH-EQUIP-DT
              ) <> 0) OR (LEN(:4H-ATTACH-EQUIP-DT
              ) <> 10), CIS.CHAR2DATE(:4H-ATTACH-EQUIP-DT
              ), CONVERT(DATE, :4H-ATTACH-EQUIP-DT) )               
                   ,LAST_UPDATE_USERID = 'LM100'                        
              WHERE FXTR_EQUIP_SEQ = :4H-FXTR-EQUIP-SEQ                 
                AND ATTACH_EQUIP_SEQ = :4H-ATTACH-EQUIP-SEQ             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE LMS_FXTR_ATTACHMTS                                         
MFA-TR*         SET ATTACH_EQUIP_SEQ = :WS-ATTACH-EQUIP-SEQ                     
MFA-TR*            ,ATTACH_EQUIP_DT = :4H-ATTACH-EQUIP-DT                       
MFA-TR*            ,LAST_UPDATE_USERID = 'LM100'                                
MFA-TR*       WHERE FXTR_EQUIP_SEQ = :4H-FXTR-EQUIP-SEQ                         
MFA-TR*         AND ATTACH_EQUIP_SEQ = :4H-ATTACH-EQUIP-SEQ                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** UPDATE ERROR IN 8220                **'       
              DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE            
              DISPLAY '** FXTR_EQUIP_SEQ = ' 4H-FXTR-EQUIP-SEQ          
              DISPLAY '** ATTACH_EQUIP_SEQ = ' 4H-ATTACH-EQUIP-SEQ      
              DISPLAY '** PROCESSING TERMINATED               **'       
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
       8220-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       8300-UPDATE-REQ.                                                 
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              UPDATE LMS_REQUEST_DETAIL                                 
                SET REQUEST_STATUS_CD = :4O-REQUEST-STATUS-CD           
                   ,LAST_UPDATE_TS  = CIS.CURRENT$TIMESTAMP()                 
                   ,LAST_UPDATE_USERID = 'LM100'                        
              WHERE TRANS_SEQ_NO = CIS.CHAR2TIMESTAMP(:4O-TRANS-SEQ-NO)         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE LMS_REQUEST_DETAIL                                         
MFA-TR*         SET REQUEST_STATUS_CD = :4O-REQUEST-STATUS-CD                   
MFA-TR*            ,LAST_UPDATE_TS  = CURRENT TIMESTAMP                         
MFA-TR*            ,LAST_UPDATE_USERID = 'LM100'                                
MFA-TR*       WHERE TRANS_SEQ_NO = :4O-TRANS-SEQ-NO                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** UPDATE ERROR IN 8300                **'       
              DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE            
              DISPLAY '** TRANS_SEQ_NO = ' 4O-TRANS-SEQ-NO              
              DISPLAY '** REQUEST_STATUS_CD = ' 4O-REQUEST-STATUS-CD    
              DISPLAY '** COMPANY-NO    ' 4D-COMPANY-NO                 
              DISPLAY '** PROCESSING TERMINATED               **'       
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8350-UPDATE-SCN.                                                 
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              UPDATE LMS_HANDHELD_TRANS                                 
                SET TRANS_STATUS_CD = :4N-TRANS-STATUS-CD               
                   ,LAST_UPDATE_TS  = CIS.CURRENT$TIMESTAMP()                 
                   ,LAST_UPDATE_USERID = 'LM100'                        
              WHERE TRANS_SEQ_NO = CIS.CHAR2TIMESTAMP(:4N-TRANS-SEQ-NO)         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE LMS_HANDHELD_TRANS                                         
MFA-TR*         SET TRANS_STATUS_CD = :4N-TRANS-STATUS-CD                       
MFA-TR*            ,LAST_UPDATE_TS  = CURRENT TIMESTAMP                         
MFA-TR*            ,LAST_UPDATE_USERID = 'LM100'                                
MFA-TR*       WHERE TRANS_SEQ_NO = :4N-TRANS-SEQ-NO                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** UPDATE ERROR IN 8350                **'       
              DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE            
              DISPLAY '** TRANS_SEQ_NO = ' 4N-TRANS-SEQ-NO              
              DISPLAY '** TRANS_STATUS_CD = ' 4N-TRANS-STATUS-CD        
              DISPLAY '** PROCESSING TERMINATED               **'       
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8400-INS-LMS-TRN-HST.                                            
                                                                        
           EXEC SQL                                                     
               INSERT INTO LMS_TRANS_HIST                               
                 (                                                      
                   EQUIP_SEQ,           TRANS_HIST_SEQ_NO,              
                   EQUIP_TAG_NO,        APPL_PROGRAM_ID,                
                   TRANS_DATE,          SOURCE_APPL_CD,                 
                   SOURCE_APPL_REQ_NO,  WMS_POINT_NO,                   
                   INSTALL_LOC_NO,      INSTALL_POINT_NO,               
                   ACCOUNT_NO,          LAST_UPDATE_USERID,             
                   TRANS_COMMENTS                                       
                 )                                                      
               VALUES                                                   
                 (                                                      
                   :4J-EQUIP-SEQ,           CIS.CHAR2TIMESTAMP(
                                                  :4J-TRANS-HIST-SEQ-NO
              ),      
                   :4J-EQUIP-TAG-NO,        :4J-APPL-PROGRAM-ID,        
                   IIF(TRY_CONVERT(DATE, :4J-TRANS-DATE
              ) IS NULL OR (PATINDEX('%.%', :4J-TRANS-DATE
              ) <> 0) OR (LEN(:4J-TRANS-DATE) <> 10), CIS.CHAR2DATE(
                                                         :4J-TRANS-DATE
              ), CONVERT(DATE, :4J-TRANS-DATE) ),          
                                                    :4J-SOURCE-APPL-CD,        
                   :4J-SOURCE-APPL-REQ-NO,  :4J-WMS-POINT-NO,           
                   :4J-INSTALL-LOC-NO,      :4J-INSTALL-POINT-NO,       
                   :4J-ACCOUNT-NO,          :4J-LAST-UPDATE-USERID,     
                   :4J-TRANS-COMMENTS                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO LMS_TRANS_HIST                                       
MFA-TR*          (                                                              
MFA-TR*            EQUIP_SEQ,           TRANS_HIST_SEQ_NO,                      
MFA-TR*            EQUIP_TAG_NO,        APPL_PROGRAM_ID,                        
MFA-TR*            TRANS_DATE,          SOURCE_APPL_CD,                         
MFA-TR*            SOURCE_APPL_REQ_NO,  WMS_POINT_NO,                           
MFA-TR*            INSTALL_LOC_NO,      INSTALL_POINT_NO,                       
MFA-TR*            ACCOUNT_NO,          LAST_UPDATE_USERID,                     
MFA-TR*            TRANS_COMMENTS                                               
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :4J-EQUIP-SEQ,           :4J-TRANS-HIST-SEQ-NO,              
MFA-TR*            :4J-EQUIP-TAG-NO,        :4J-APPL-PROGRAM-ID,                
MFA-TR*            :4J-TRANS-DATE,          :4J-SOURCE-APPL-CD,                 
MFA-TR*            :4J-SOURCE-APPL-REQ-NO,  :4J-WMS-POINT-NO,                   
MFA-TR*            :4J-INSTALL-LOC-NO,      :4J-INSTALL-POINT-NO,               
MFA-TR*            :4J-ACCOUNT-NO,          :4J-LAST-UPDATE-USERID,             
MFA-TR*            :4J-TRANS-COMMENTS                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** UPDATE ERROR IN 8400                **'       
              DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE            
              DISPLAY '** EQUIP-SEQ         = ' 4J-EQUIP-SEQ            
              DISPLAY '** TRANS-HIST-SEQ-NO = ' 4J-TRANS-HIST-SEQ-NO    
              DISPLAY '** INSTALL-LOC-NO    = ' 4J-INSTALL-LOC-NO       
              DISPLAY '** INSTALL-POINT-NO  = ' 4J-INSTALL-POINT-NO     
              DISPLAY '** PROCESSING TERMINATED               **'       
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8420-INS-LMS-TRN-HSTDET.                                         
                                                                        
           EXEC SQL                                                     
               INSERT INTO LMS_TRANS_HIST_DET                           
               (                                                        
                 EQUIP_SEQ,         TRANS_HIST_SEQ_NO,                  
                 DETAIL_SEQ_NO,     COLUMN_DESC,                        
                 PRV_COLUMN_VALUE,  CHG_COLUMN_VALUE,                   
                 LAST_UPDATE_USERID                                     
               )                                                        
               VALUES                                                   
               (                                                        
                 :4S-EQUIP-SEQ,         CIS.CHAR2TIMESTAMP(
                                                  :4S-TRANS-HIST-SEQ-NO
              ),          
                 :4S-DETAIL-SEQ-NO,     :4S-COLUMN-DESC,                
                 :4S-PRV-COLUMN-VALUE,  :4S-CHG-COLUMN-VALUE,           
                 :4S-LAST-UPDATE-USERID                                 
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO LMS_TRANS_HIST_DET                                   
MFA-TR*        (                                                                
MFA-TR*          EQUIP_SEQ,         TRANS_HIST_SEQ_NO,                          
MFA-TR*          DETAIL_SEQ_NO,     COLUMN_DESC,                                
MFA-TR*          PRV_COLUMN_VALUE,  CHG_COLUMN_VALUE,                           
MFA-TR*          LAST_UPDATE_USERID                                             
MFA-TR*        )                                                                
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*          :4S-EQUIP-SEQ,         :4S-TRANS-HIST-SEQ-NO,                  
MFA-TR*          :4S-DETAIL-SEQ-NO,     :4S-COLUMN-DESC,                        
MFA-TR*          :4S-PRV-COLUMN-VALUE,  :4S-CHG-COLUMN-VALUE,                   
MFA-TR*          :4S-LAST-UPDATE-USERID                                         
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** UPDATE ERROR IN 8420                **'       
              DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE            
              DISPLAY '** EQUIP-SEQ         = ' 4S-EQUIP-SEQ            
              DISPLAY '** TRANS-HIST-SEQ-NO = ' 4S-TRANS-HIST-SEQ-NO    
              DISPLAY '** DETAIL_SEQ_NO     = ' 4S-DETAIL-SEQ-NO        
              DISPLAY '** COLUMN_DESC       = ' 4S-COLUMN-DESC          
              DISPLAY '** PROCESSING TERMINATED               **'       
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8420-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       8500-DELETE-EQUIP-ENVRNMT.                                       
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              DELETE FROM LMS_EQUIP_ENVRNMT                             
               WHERE INSTALL_LOC_NO   = :4F-INSTALL-LOC-NO              
                 AND INSTALL_POINT_NO = :4F-INSTALL-POINT-NO            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '**  DELETE ERROR IN 8500                **'      
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**  INSTALL_LOC_NO   = ' 4F-INSTALL-LOC-NO       
              DISPLAY '**  INSTALL_POINT_NO = ' 4F-INSTALL-POINT-NO     
              DISPLAY '**  PROCESSING TERMINATED               **'      
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       8600-DELETE-FXTR-ATTACHMTS.                                      
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              DELETE FROM LMS_FXTR_ATTACHMTS                            
              WHERE FXTR_EQUIP_SEQ = :4H-FXTR-EQUIP-SEQ                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '**  DELETE ERROR IN 8600                **'      
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**  FXTR_EQUIP_SEQ = ' 4H-FXTR-EQUIP-SEQ         
              DISPLAY '**  PROCESSING TERMINATED               **'      
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       8909-SUCCESSFUL-END.                                             
      *================================================================*        
                                                                        
                                                                        
           DISPLAY '**********************************************'.    
           DISPLAY '** SUCCESSFUL END OF PROGRAM                **'.    
           DISPLAY '**********************************************'.    
                                                                        
       8909-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       9000-TERMINATE.                                                  
      *================================================================*        
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
