       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSLM064.                                            
       DATE-WRITTEN. MAY-2014.                                          
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                SOUTH CAROLINA ELECTRIC & GAS                            
      *                                                                         
      *****************************************************************         
      *                 P R O G R A M  S U M M A R Y                  *         
      *                                                               *         
      *  THIS PROGRAM VALIDATES VENDOR FILE AND LOADS IN INVENTORY.   *         
      *  IS USED TO POST FIXTURE AND NODES. EXCEPTIONS ARE WRITTEN    *         
      *  IN ERROR FILE.                                               *         
      *****************************************************************         
      *                     PROGRAM MODIFICATION LOG                            
      *                                                                         
      *    DATE    INITIALS   COMMENTS                                          
      *  --------  --------   ---------------------------------------           
A05136*  12/07/15  DB41297    NEW PROGRAM, CONVERTED FROM EZTR.       *         
A05470*  09/26/16  SS95855    USE CSS_SUBDIVISION TO GET RATE ITEM CD *         
      *****************************************************************         
      *****************************************************************         
      *                                                                         
      *                ---- BASIC SEQUENCE STRUCTURE ----                       
      *                                                                         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION                      
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                             
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                            
      *  3000 - 4999  NOT USED                                                  
      *  5000 - 5999  COMMON PROGRAM MODULES                                    
      *  6000 - 6999  COMMON SYSTEM MODULES                                     
      *  7000 - 7999  INPUT MODULES                                             
      *  8000 - 8999  OUTPUT MODULES                                            
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES                      
      *                                                                         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSLM064.                                                           
       COPY CSSLE064.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDLM064.                                                           
       COPY FIOLM064.                                                           
       COPY CFDLE064.                                                           
       COPY FIOLE064.                                                           
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSLM064'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)  VALUE               
           'WORKING STORAGE FOR PCSLM064 STARTS HERE'.                  
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-PGM-NAME               PIC X(08)   VALUE 'PCSLM064'.  
           05  WS-SYSTEM                 PIC X(07)   VALUE 'SYSTEM '.   
           05  WS-FIXTURE                PIC X(01)   VALUE 'F'.         
           05  WS-NEW                    PIC X(07)   VALUE '**NEW**'.   
           05  WS-NO                     PIC X(01)   VALUE 'N'.         
           05  WS-TRANS-COMMENTS         PIC X(60)   VALUE              
                                          'ADD NEW LIGHT TO INVENTORY'. 
       01  WS-MISC.                                                     
           05  WS-FLM64-REC-CNTR         PIC 9(08)   VALUE ZERO.        
           05  WS-FLE64-REC-CNTR         PIC 9(08)   VALUE ZERO.        
           05  WS-INSERT-REC-CNTR        PIC 9(08)   VALUE ZERO.        
           05  WS-GOOD-REC-CNTR          PIC 9(08)   VALUE ZERO.        
           05  WS-SQL-CODE               PIC -9(9)   VALUE ZERO.        
           05  WS-ERROR-MSG              PIC X(34)   VALUE SPACES.      
           05  WS-STOCK-CD-NO-EXITS      PIC X(01)   VALUE 'N'.         
           05  WS-WARRANTY-PERIOD        PIC S9(04)  USAGE COMP.        
           05  RS-RETURN-CODE            PIC S9(09)  COMP  VALUE +0.    
           05  MULTIPLE-ROWS-FOUND       PIC S9(9)   VALUE -811 COMP.   
           05  WS-WARR-PER-NUM           PIC 9(02)   VALUE 0.           
                                                                        
       01  WS-DATE-FIELDS.                                              
           05  WS-CURRENT-DATE           PIC X(10)   VALUE SPACES.      
           05  WS-TEMP-PURCHASE-DT       PIC X(10)   VALUE SPACES.      
           05  WS-PURCHASE-DT.                                          
               10 WS-PURCHASE-CCYY       PIC X(04).                     
               10 FILLER                 PIC X(01)   VALUE '-'.         
               10 WS-PURCHASE-MM         PIC X(02).                     
               10 FILLER                 PIC X(01)   VALUE '-'.         
               10 WS-PURCHASE-DD         PIC X(02).                     
           05  WS-PURCH-DATE.                                           
               10  WS-PURCH-DD           PIC X(02)   VALUE SPACES.      
               10  WS-PURCH-MM           PIC X(02)   VALUE SPACES.      
               10  WS-PURCH-YYYY         PIC X(04)   VALUE SPACES.      
           05  WS-DATE-LENGTH.                                          
               10  WS-LEN-SLASH          PIC 9(01)   VALUE 0.           
               10  WS-LEN-DATE           PIC 9(01)   VALUE 0.           
               10  WS-LEN-SPACE          PIC 9(01)   VALUE 0.           
                                                                        
       01  WS-SWITCH.                                                   
           05  WS-FLE64-STATUS           PIC X(02).                     
               88 FLE64-SUCCESSFUL                  VALUE '00'.         
           05  WS-FLM64-STATUS           PIC X(02).                     
               88 FLM64-SUCCESSFUL                  VALUE '00'.         
           05  WS-MORE-DATA-SW           PIC X(01)  VALUE 'Y'.          
               88 NO-MORE-DATA                      VALUE 'N'.          
           05  WS-VALIDATION-SW          PIC X(01)  VALUE 'N'.          
               88 INVALID-RECORD                    VALUE 'Y'.          
               88 VALID-RECORD                      VALUE 'N'.          
           05  WS-TAG-NO-SW              PIC X(02)  VALUE SPACES.       
               88 VALID-TAG-NO           VALUE '17','40','SC'.          
           05  WS-TAG-CHECK              PIC X(01)  VALUE 'N'.          
               88 TAG-EXISTS                        VALUE 'Y'.          
               88 TAG-NOT-EXISTS                    VALUE 'N'.          
           05  WS-STOCK-CD-CHECK         PIC X(01)  VALUE 'N'.          
               88 STOCK-CD-EXISTS                   VALUE 'Y'.          
               88 STOCK-CD-NOT-EXISTS               VALUE 'N'.          
           05  WS-EQUIP-TYPE-CD          PIC X(01)  VALUE ' '.          
               88 EQUIP-TYPE-FIXTURE                VALUE 'F'.          
               88 EQUIP-TYPE-NODE                   VALUE 'N'.          
               88 EQUIP-TYPE-OTHER                  VALUE 'P'.          
           05  WS-EXCPTN-EMAIL           PIC X(01)  VALUE 'N'.          
               88 CREATE-EXCPTN-EMAIL               VALUE 'Y'.          
                                                                        
       01  WS-STOCK-CD-GROUPING.                                        
           05  WS-STOCK-CD-STR1          PIC X(15).                     
           05  WS-STOCK-CD-STR2          PIC X(08).                     
           05  WS-STOCK-CD-STR3          PIC X(08).                     
           05  WS-STOCK-CD-STR4          PIC X(08).                     
           05  WS-STOCK-CD-STR5          PIC X(08).                     
           05  WS-STOCK-CD-STR6          PIC X(08).                     
           05  WS-STOCK-CD-STR7          PIC X(08).                     
           05  WS-STOCK-CD-STR8          PIC X(08).                     
                                                                        
       01  WS-FLE64-REC.                                                
           05  WS-FLE64-DATA             PIC X(315).                    
           05  WS-FLE64-FLR01            PIC X(01) VALUE ','.           
           05  WS-FLE64-MESG             PIC X(19).                     
                                                                        
       01  WS-MISC-FLDS.                                                
           05  WS-ACTION                 PIC X(8).                      
           05  WS-TABLE                  PIC X(18).                     
           05  WS-CALL-TYPE              PIC X(1) VALUE ' '.            
           05  WS-GIS-KEY                PIC X(7).                      
           05  WS-GIS-KEYR REDEFINES WS-GIS-KEY.                        
               10  WS-GIS-KEY-RATE       PIC X(3).                      
               10  WS-GIS-KEY-FILL1      PIC X.                         
               10  WS-GIS-KEY-RATE-ITEM  PIC 99.                        
               10  WS-GIS-KEY-FILL2      PIC X.                         
           05  WS-GIS-DET                PIC X(73).                     
           05  WS-GIS-DETR REDEFINES WS-GIS-DET.                        
               10  WS-GIS-DET-ATTR-1     PIC X(4).                      
               10  WS-GIS-DET-FILL1      PIC X.                         
               10  WS-GIS-DET-ATTR-2     PIC X(10).                     
               10  WS-GIS-DET-FILL2      PIC X.                         
               10  WS-GIS-DET-ATTR-3     PIC X(21).                     
               10  WS-GIS-DET-FILL3      PIC X.                         
               10  WS-GIS-DET-STOCK-1    PIC X(11).                     
               10  WS-GIS-DET-FILL4      PIC X.                         
               10  WS-GIS-DET-STOCK-2    PIC X(11).                     
               10  WS-GIS-DET-FILL5      PIC X.                         
               10  WS-GIS-DET-STOCK-3    PIC X(11).                     
           05  WS-IN-ATTR-FMT            PIC X(73).                     
           05  WS-IN-ATTR-FMTR REDEFINES WS-IN-ATTR-FMT.                
               10  WS-IN-ATTR-ATTR-1     PIC X(4).                      
               10  WS-IN-ATTR-FILL1      PIC X(10).                     
               10  WS-IN-ATTR-ATTR-2     PIC X(10).                     
               10  WS-IN-ATTR-FILL2      PIC X.                         
               10  WS-IN-ATTR-ATTR-3     PIC X(21).                     
               10  WS-IN-ATTR-FILL3      PIC X.                         
               10  WS-IN-ATTR-STOCK-1    PIC X(11).                     
               10  WS-IN-ATTR-FILL4      PIC X.                         
               10  WS-IN-ATTR-STOCK-2    PIC X(11).                     
               10  WS-IN-ATTR-FILL5      PIC X.                         
               10  WS-IN-ATTR-STOCK-3    PIC X(11).                     
           05  WS-VLD-SUBDIV-FL          PIC X(01) VALUE ' '.           
           05  WS-PREV-VLD-SUB-DIV-FL    PIC X(01) VALUE ' '.           
           05  WS-VLD-ACCT-FL            PIC X(01) VALUE ' '.           
           05  WS-VLD-CUST-PLAN-FL       PIC X(01) VALUE ' '.           
           05  WS-VLD-ATTR-FL            PIC X(01) VALUE ' '.           
           05  WS-VLD-REC-COUNT          PIC 9(04) VALUE 0.             
           05  WS-CPD99-ACCT-NO-FMT      PIC 9(13) VALUE 0.             
           05  WS-STOCK-CD-FMT           PIC X(11) VALUE ' '.           
           05  WS-G-KEY-FMT              PIC X(07).                     
           05  WS-G-KEY-FMT-FMT-N REDEFINES WS-G-KEY-FMT PIC 9(7).      
           05  WS-APPR-TS-FMT            PIC X(26).                     
           05  WS-APPR-TS-FMT-DT         PIC X(10).                     
           05  WS-APPR-TS-FMT-TM         PIC X(16).                     
           05  WS-SAVE-FXTR-SEQ          PIC 9(10) VALUE 0.             
           05  WS-SAVE-FXTR-POINT        PIC 9(05) VALUE 0.             
           05  WS-RATE-ITEM-FMT          PIC X(04).                     
           05  WS-RATE-ITEM-FMT-N REDEFINES WS-RATE-ITEM-FMT PIC 9(4).  
           05  WS-DO-LOOP-COUNTER        PIC 9(05) VALUE 0.             
           05  WS-PREV-PREMISE-NO        PIC 9(10) VALUE 0.             
           05  WS-PREV-LOCATION-NO       PIC X(10) VALUE ' '.           
           05  WS-PREV-ACCOUNT-NO        PIC 9(13) VALUE 0.             
           05  WS-PREV-CONV-TAG          PIC X(09) VALUE ' '.           
           05  WS-PREV-UTIL-TYPE         PIC X(01) VALUE ' '.           
           05  WS-PREV-IC-NO             PIC 9(04) VALUE 0.             
           05  WS-PREV-RATE              PIC X(03) VALUE ' '.           
           05  WS-PREV-RATE-ITEM         PIC 9(02) VALUE 0.             
           05  WS-PREV-ITEM-SEQ          PIC 9(04) VALUE 0.             
           05  WS-PREV-NO-UNITS          PIC 9(04) VALUE 0.             
           05  WS-PREV-PLAN-STAT         PIC X(01) VALUE ' '.           
           05  WS-EQUIP-SEQ-NO           PIC S9(10)V COMP-3 VALUE +0.   
           05  WS-NULL-MFR-DT            PIC S9(4) COMP VALUE +0.       
           05  WS-NULL-EXP-DT            PIC S9(4) COMP VALUE +0.       
           05  WS-NULL-DISPOSAL-DT       PIC S9(4) COMP VALUE +0.       
           05  WS-NULL-INSTALL-DT        PIC S9(4) COMP VALUE +0.       
           05  WS-APPROVED-TS-IND        PIC S9(04) COMP VALUE +0.      
           05  WS-RATE-ITEM-CD           PIC S9(4) COMP VALUE +0.       
           05  WS-SUB-DIVISION-ID.                                      
              10  WS-SUB-DIVISION-ID-1      PIC X(7).                   
              10  WS-SUB-DIVISION-ID-2      PIC X(3).                   
                                                                        
      *****************************************************************         
      * SQL COMMUNICATION AREA                                        *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * LMS_EQUIP_INVENTRY 4D                                         *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBEQPINV                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * LMS_FXTR_ATTACHMTS 4H                                         *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBFXTATC                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * LMS_EQUIP_ENVRNMT  4F                                         *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBEQPIVT                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * LMS_MSTR_STCK_INFO 4A                                         *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBMSTINF                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * LMS_TRANS_HIST    4J                                          *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBLGTHST                                               
            END-EXEC.                                                           
      *                                                                         
      *****************************************************************         
      * LMS_TRANS_HIST_DET  4S                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBLMSHST                                               
            END-EXEC.                                                           
      *                                                                         
      *****************************************************************         
      * LMS_CODE_DESC       3U                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBLMCODE                                               
            END-EXEC.                                                           
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
                                                                        
       01  WS-END                        PIC X(40)  VALUE               
             'WORKING STORAGE FOR PCSLM064 ENDS HERE  '.                
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
                                                                        
           PERFORM 0200-GET-FIOLM64-DATA       THRU 0200-EXIT.          
                                                                        
           PERFORM 1000-MAIN-PROCESS-PARA      THRU 1000-EXIT           
             UNTIL NO-MORE-DATA.                                        
                                                                        
           PERFORM 2700-PROCESS-EXCPTNS        THRU 2700-EXIT.          
                                                                        
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      **                                                       **               
      **    0100-INITIALIZATION.                               **               
      **        INITIALIZATION ROUTINE                         **               
      **                                                       **               
      ***********************************************************               
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN OUTPUT FCSLE064-FILE.                                   
           IF FLE64-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  PARA 0100-INITIALIZATION            **'     
               DISPLAY '**  OPEN ERROR OF FCSLE01 - INPUT FILE  **'     
               DISPLAY '**         FILE STATUS = ' WS-FLE64-STATUS      
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
           OPEN INPUT FCSLM064-FILE.                                    
           IF FLM64-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  PARA 0100-INITIALIZATION            **'     
               DISPLAY '**  OPEN ERROR OF FCSLM64 - INPUT FILE  **'     
               DISPLAY '**         FILE STATUS = ' WS-FLM64-STATUS      
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
           PERFORM 7500-GET-CURRENT-DATE         THRU 7500-EXIT.        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      **                                                       **               
      **    0200-GET-FIOLM64-DATA.                             **               
      **        INITIALIZATION ROUTINE                         **               
      **                                                       **               
      ***********************************************************               
                                                                        
       0200-GET-FIOLM64-DATA.                                           
                                                                        
           PERFORM 7100-READ-FCSLM64           THRU 7100-EXIT.          
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************************************************             
      **                                                         **             
      **      1000-MAIN-PROCESS-PARA                             **             
      **           MAIN PROCESS                                  **             
      **                                                         **             
      *************************************************************             
                                                                        
       1000-MAIN-PROCESS-PARA.                                          
                                                                        
           PERFORM 2000-VALIDATE-INPUTS          THRU 2000-EXIT.        
                                                                        
           IF INVALID-RECORD                                            
              SET CREATE-EXCPTN-EMAIL TO TRUE                           
              INITIALIZE E-FLE64-DATA                                   
              MOVE FIOLM064-REC               TO WS-FLE64-DATA          
              MOVE WS-ERROR-MSG               TO WS-FLE64-MESG          
              PERFORM 8600-WRITE-ERROR-FILE      THRU 8600-EXIT         
           END-IF.                                                      
                                                                        
           PERFORM 0200-GET-FIOLM64-DATA       THRU 0200-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-VALIDATE-INPUTS.                                            
                                                                        
           INITIALIZE  WS-DATE-LENGTH                                   
                       WS-STOCK-CD-GROUPING.                            
           SET VALID-RECORD TO TRUE.                                    
           SET TAG-NOT-EXISTS TO TRUE.                                  
           SET STOCK-CD-NOT-EXISTS TO TRUE.                             
           MOVE 0                            TO WS-WARR-PER-NUM.        
           MOVE SPACES                       TO WS-ERROR-MSG.           
           MOVE 'N' TO WS-VLD-SUBDIV-FL.                                
           MOVE 0 TO WS-RATE-ITEM-CD.                                   
           MOVE FIOLM064-LOCATION-NO TO WS-SUB-DIVISION-ID.             
                                                                        
           PERFORM 7400-CHECK-RATE-ITEM         THRU 7400-EXIT.         
                                                                        
           IF WS-VLD-SUBDIV-FL = 'Y'                                    
              PERFORM 7450-CHECK-DUPLICATE   THRU 7450-EXIT             
              IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL        
                 PERFORM 2100-SET-ALL-CONSTANTS THRU 2100-EXIT          
                 PERFORM 2150-MAIN-FXPL-INV-ENV THRU 2150-EXIT          
                 PERFORM 2075-PROCESS-ATCH-POLE-INV-ENV THRU 2075-EXIT  
                 PERFORM 2300-PROCESS-TRANS-HIST THRU 2300-EXIT         
                 ADD 1 TO WS-GOOD-REC-CNTR                              
                 DISPLAY     'GOOD REC:' FIOLM064-LOCATION-NO '|' ,     
                                         FIOLM064-FXPL-CONV-TAG '|' ,   
                                         FIOLM064-GIS-LIGHT-G-KEY '|' , 
                                         FIOLM064-GIS-WATTAGE-NO '|' ,  
                                         FIOLM064-GIS-BULB-TYPE '|' ,   
                                         FIOLM064-GIS-FXTR-STYLE '|' ,  
                                         FIOLM064-GIS-POLE-HEIGHT '|' , 
                                         FIOLM064-GIS-POLE-TYPE '|' ,   
                                         FIOLM064-GIS-POLE-NO '|'       
              ELSE                                                      
                 SET INVALID-RECORD TO TRUE                             
                 MOVE 'DUPLICATE RECORD' TO WS-ERROR-MSG                
                 DISPLAY     'DUPL REC:' FIOLM064-LOCATION-NO '|' ,     
                                         FIOLM064-FXPL-CONV-TAG '|' ,   
                                         FIOLM064-GIS-LIGHT-G-KEY '|' , 
                                         FIOLM064-GIS-WATTAGE-NO '|' ,  
                                         FIOLM064-GIS-BULB-TYPE '|' ,   
                                         FIOLM064-GIS-FXTR-STYLE '|' ,  
                                         FIOLM064-GIS-POLE-HEIGHT '|' , 
                                         FIOLM064-GIS-POLE-TYPE '|' ,   
                                         FIOLM064-GIS-POLE-NO '|'       
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-VLD-SUBDIV-FL = 'N'                                    
              SET INVALID-RECORD TO TRUE                                
              MOVE 'INVALID SUBDIVISION' TO WS-ERROR-MSG                
              DISPLAY  'SUB DIV ERR:' FIOLM064-LOCATION-NO '|' ,        
                                      FIOLM064-FXPL-CONV-TAG '|' ,      
                                      FIOLM064-GIS-LIGHT-G-KEY '|' ,    
                                      FIOLM064-GIS-WATTAGE-NO '|' ,     
                                      FIOLM064-GIS-BULB-TYPE '|' ,      
                                      FIOLM064-GIS-FXTR-STYLE '|' ,     
                                      FIOLM064-GIS-POLE-HEIGHT '|' ,    
                                      FIOLM064-GIS-POLE-TYPE '|' ,      
                                      FIOLM064-GIS-POLE-NO '|'          
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2075-PROCESS-ATCH-POLE-INV-ENV.                                  
                                                                        
           MOVE 0 TO WS-SAVE-FXTR-SEQ                                   
                     WS-SAVE-FXTR-POINT.                                
           MOVE 4D-EQUIP-SEQ TO WS-SAVE-FXTR-SEQ                        
                                                                        
           MOVE 4F-INSTALL-POINT-NO TO WS-SAVE-FXTR-POINT.              
                                                                        
           PERFORM 2175-GET-NEXT-EQUIP-SEQ-NO THRU 2175-EXIT.           
           MOVE WS-EQUIP-SEQ-NO TO 4D-EQUIP-SEQ                         
                                                                        
           MOVE FIOLM064-GIS-POLE-NO TO 4D-EQUIP-TAG-NO.                
                                                                        
           MOVE ' ' TO WS-STOCK-CD-FMT                                  
           IF FIOLM064-GIS-POLE-TYPE > ' ' AND                          
              FIOLM064-GIS-POLE-HEIGHT > ' '                            
              PERFORM 7700-CHECK-CODEDESC   THRU 7700-EXIT              
           END-IF                                                       
           IF WS-STOCK-CD-FMT > ' '                                     
              MOVE WS-STOCK-CD-FMT  TO 4D-STOCK-CD                      
           ELSE                                                         
              EVALUATE FIOLM064-GIS-POLE-TYPE                           
                WHEN 'WOOD'                                             
                  MOVE 'CNVPOLEWOOD' TO 4D-STOCK-CD                     
                WHEN 'ALUMINUM'                                         
                  MOVE 'CNVPOLEALUM' TO 4D-STOCK-CD                     
                WHEN 'FIBERGLASS'                                       
                  MOVE 'CNVPOLEFBGL' TO 4D-STOCK-CD                     
                WHEN OTHER                                              
                  MOVE 'CNVPOLEDFLT' TO 4D-STOCK-CD                     
              END-EVALUATE                                              
           END-IF                                                       
                                                                        
           MOVE 'P' TO 4D-EQUIP-TYPE-CD                                 
                                                                        
           MOVE WS-SUB-DIVISION-ID-2 TO 4F-INSTALL-LOC-NO               
                                                                        
           COMPUTE 4F-INSTALL-POINT-NO  = 4F-INSTALL-POINT-NO + 1.      
                                                                        
           MOVE 4D-EQUIP-SEQ TO 4F-EQUIP-SEQ                            
                                                                        
           MOVE ' '   TO 4F-CODE-UTIL-TYPE                              
           MOVE 0     TO 4F-IC-NO                                       
           MOVE '   ' TO 4F-RATE-PLAN-NO                                
           MOVE 0     TO 4F-RATE-ITEM-CODE                              
           MOVE 0  TO 4F-ITEM-SEQ-NO                                    
           MOVE 'N' TO 4F-BILLING-FL                                    
           MOVE '64' TO 4F-NO-BILL-REASON-CD                            
           MOVE ' ' TO 4F-EQUIP-CONTRACT-FL                             
           MOVE '  ' TO 4F-NO-CONTRACT-RSN-CD                           
           MOVE ' ' TO 4F-EQUIP-OWNER-CD                                
                                                                        
      *                                                                         
      *** 4F-EQUIP-GIS-GKEY: USE SAME GKEY AS FIXTURE                           
      *                                                                         
      *** 4F-EQUIP-INSTALL-DT: USE SAME INSTALL DATE AS FIXTURE                 
      *                                                                         
      *** 4F-APPROVED-TS: USE SAME APPROVAL TIMESTAMP AS FIXTURE                
      *                                                                         
           IF FIOLM064-GIS-INSTALL-DATE > ' '                           
              MOVE FIOLM064-GIS-INSTALL-DATE TO 4F-EQUIP-INSTALL-DT     
              MOVE 0  TO WS-NULL-INSTALL-DT                             
           ELSE                                                         
              MOVE 0  TO WS-NULL-INSTALL-DT                             
              MOVE WS-CURRENT-DATE     TO 4F-EQUIP-INSTALL-DT           
           END-IF.                                                      
                                                                        
           IF FIOLM064-GIS-INSTALL-DATE > ' '                           
              MOVE ' ' TO WS-APPR-TS-FMT                                
              MOVE FIOLM064-GIS-INSTALL-DATE TO WS-APPR-TS-FMT-DT       
              MOVE '-00.00.00.000000' TO WS-APPR-TS-FMT-TM              
              MOVE WS-APPR-TS-FMT TO 4F-APPROVED-TS                     
           ELSE                                                         
              PERFORM 7000-GET-CURR-TS THRU 7000-EXIT                   
              MOVE 4J-TRANS-HIST-SEQ-NO  TO 4F-APPROVED-TS              
           END-IF.                                                      
                                                                        
           PERFORM 8100-INSERT-LMS-INVENTORY  THRU 8100-EXIT            
                                                                        
           PERFORM 8200-INSERT-EQUIP-ENVRNMT THRU 8200-EXIT             
                                                                        
           MOVE WS-SAVE-FXTR-SEQ TO 4H-FXTR-EQUIP-SEQ                   
                                                                        
           PERFORM 7900-CHECK-FXTR-ATTACH THRU 7900-EXIT                
           COMPUTE 4H-ATTACH-SEQ-NO = 4H-ATTACH-SEQ-NO + 1.             
                                                                        
           MOVE 4F-EQUIP-SEQ TO 4H-ATTACH-EQUIP-SEQ                     
           IF 4F-EQUIP-INSTALL-DT > ' '                                 
              MOVE 4F-EQUIP-INSTALL-DT TO 4H-ATTACH-EQUIP-DT            
           ELSE                                                         
              MOVE WS-CURRENT-DATE     TO 4H-ATTACH-EQUIP-DT            
           END-IF                                                       
                                                                        
           PERFORM 8300-INSERT-FXTR-ATTACHMTS THRU 8300-EXIT.           
                                                                        
       2075-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-SET-ALL-CONSTANTS.                                          
      *                                                                         
      *** INVENTORY TABLE - INITIALIZE VALUES                                   
      *                                                                         
           MOVE '01' TO 4D-COMPANY-NO                                   
           MOVE 'E' TO 4D-CODE-SERVICE-TYPE                             
                                                                        
           MOVE 'UN' TO 4D-EQUIP-MFR-CD                                 
      *                                                                         
      *** MOVE NULL VALUES FOR DATES                                            
      *                                                                         
           MOVE -1 TO                                                   
           WS-NULL-MFR-DT                                               
           WS-NULL-EXP-DT                                               
           WS-NULL-DISPOSAL-DT.                                         
                                                                        
           MOVE ' ' TO 4D-STORAGE-FAC-CD                                
                       4D-WRNTY-RECEIVED-FL                             
                       4F-EQUIP-DRAWING-ID                              
                       4F-SOURCE-APPL-CD                                
                       4D-IN-TRANSIT-USERID.                            
           MOVE 'J' TO 4D-INVENTRY-STATUS-CD.                           
           MOVE 'S' TO 4F-INSTALL-LOC-CD.                               
           MOVE 0 TO 4D-WRNTY-RECOUP-AMT.                               
           MOVE 'PCSLM064' TO 4D-LAST-UPDATE-USERID                     
                              4F-INSTALL-USERID.                        
      *                                                                         
      *** ENVIRONMENT TABLE - INITIALIZE VALUES                                 
      *                                                                         
           IF FIOLM064-GIS-LIGHT-G-KEY > ' '                            
              MOVE 0 TO WS-G-KEY-FMT-FMT-N                              
              MOVE FIOLM064-GIS-LIGHT-G-KEY TO WS-G-KEY-FMT             
              MOVE WS-G-KEY-FMT-FMT-N TO 4F-EQUIP-GIS-GKEY              
           ELSE                                                         
              MOVE 0 TO 4F-EQUIP-GIS-GKEY                               
           END-IF.                                                      
                                                                        
           MOVE 0 TO 4F-SOURCE-APPL-REQ-NO                              
                     4F-WMS-POINT-NO.                                   
                                                                        
      * CHECK THE DATE FORMAT                                                   
           IF FIOLM064-GIS-INSTALL-DATE > ' '                           
              MOVE FIOLM064-GIS-INSTALL-DATE TO 4F-EQUIP-INSTALL-DT     
           ELSE                                                         
              MOVE -1 TO WS-NULL-INSTALL-DT                             
           END-IF.                                                      
                                                                        
           MOVE 'LMSCONV' TO 4F-APPROVER-USERID                         
                             4F-LAST-UPDATE-USERID.                     
                                                                        
           MOVE ' ' TO 4F-SPCL-AGR-COMMENTS                             
                       4F-EQUIP-COMMENTS.                               
           MOVE 'P' TO 4H-EQUIP-TYPE-CD.                                
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2150-MAIN-FXPL-INV-ENV.                                          
                                                                        
           PERFORM 2175-GET-NEXT-EQUIP-SEQ-NO THRU 2175-EXIT.           
           MOVE WS-EQUIP-SEQ-NO TO 4D-EQUIP-SEQ                         
                                                                        
           MOVE FIOLM064-FXPL-CONV-TAG TO 4D-EQUIP-TAG-NO.              
                                                                        
           IF FIOLM064-GIS-INSTALL-DATE > ' '                           
              MOVE ' ' TO WS-APPR-TS-FMT                                
              MOVE FIOLM064-GIS-INSTALL-DATE TO WS-APPR-TS-FMT-DT       
              MOVE '-00.00.00.000000' TO WS-APPR-TS-FMT-TM              
              MOVE WS-APPR-TS-FMT TO 4F-APPROVED-TS                     
           ELSE                                                         
              PERFORM 7000-GET-CURR-TS THRU 7000-EXIT                   
              MOVE 4J-TRANS-HIST-SEQ-NO  TO 4F-APPROVED-TS              
           END-IF.                                                      
                                                                        
           MOVE ' ' TO WS-STOCK-CD-FMT.                                 
           IF FIOLM064-GIS-WATTAGE-NO > ' ' AND                         
              FIOLM064-GIS-BULB-TYPE > ' '  AND                         
              FIOLM064-GIS-FXTR-STYLE > ' '                             
              PERFORM 7600-GET-FXTR-STOCK THRU 7600-EXIT                
           END-IF                                                       
           IF WS-STOCK-CD-FMT > ' '                                     
              MOVE WS-STOCK-CD-FMT TO 4D-STOCK-CD                       
           ELSE                                                         
              MOVE 'SCEGFXTR064'  TO 4D-STOCK-CD                        
           END-IF                                                       
                                                                        
           MOVE 'F' TO 4D-EQUIP-TYPE-CD                                 
                                                                        
           MOVE WS-SUB-DIVISION-ID-2 TO 4F-INSTALL-LOC-NO               
                                                                        
           PERFORM 7800-CHECK-INSTALL-LOC THRU 7800-EXIT                
           COMPUTE 4F-INSTALL-POINT-NO  = 4F-INSTALL-POINT-NO + 1.      
                                                                        
           COMPUTE 4F-EQUIP-SEQ         = 4D-EQUIP-SEQ                  
                                                                        
           MOVE 'U' TO 4F-CODE-UTIL-TYPE                                
           MOVE 0  TO 4F-IC-NO                                          
           MOVE '064' TO 4F-RATE-PLAN-NO                                
           MOVE WS-RATE-ITEM-CD TO 4F-RATE-ITEM-CODE                    
           MOVE 0  TO 4F-ITEM-SEQ-NO                                    
           MOVE 'Y' TO 4F-BILLING-FL                                    
           MOVE ' ' TO 4F-NO-BILL-REASON-CD                             
           MOVE 'N' TO 4F-EQUIP-CONTRACT-FL                             
           MOVE 'EL' TO 4F-NO-CONTRACT-RSN-CD                           
           MOVE 'L' TO 4F-EQUIP-OWNER-CD                                
                                                                        
           PERFORM 8100-INSERT-LMS-INVENTORY  THRU 8100-EXIT.           
                                                                        
           PERFORM 8200-INSERT-EQUIP-ENVRNMT THRU 8200-EXIT.            
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2175-GET-NEXT-EQUIP-SEQ-NO.                                      
                                                                        
           EXEC SQL                                                     
             SELECT  NEXT VALUE FOR SEQ_ID_EQUIP_SEQ                    
               INTO :WS-EQUIP-SEQ-NO                                    
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  NEXT VALUE FOR SEQ_ID_EQUIP_SEQ                            
MFA-TR*        INTO :WS-EQUIP-SEQ-NO                                            
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          WS-SQL-CODE                   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE 4J-TRANS-HIST-SEQ-NO        TO 4S-TRANS-HIST-SEQ-NO 
           ELSE                                                         
               DISPLAY '**  SELECT ERROR IN 2175                **'     
               DISPLAY '**  RETURN CODE = ' WS-SQL-CODE                 
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
       2175-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-PROCESS-TRANS-HIST.                                         
                                                                        
           MOVE WS-CURRENT-DATE TO 4J-TRANS-DATE.                       
           MOVE 'LMSCONV' TO 4J-APPL-PROGRAM-ID                         
                             4J-LAST-UPDATE-USERID.                     
           MOVE ' ' TO 4J-SOURCE-APPL-CD.                               
           MOVE 0 TO 4J-SOURCE-APPL-REQ-NO                              
                     4J-WMS-POINT-NO                                    
                     4J-ACCOUNT-NO.                                     
           MOVE WS-SAVE-FXTR-SEQ  TO 4J-EQUIP-SEQ.                      
           MOVE FIOLM064-FXPL-CONV-TAG TO 4J-EQUIP-TAG-NO.              
           MOVE WS-SUB-DIVISION-ID-2 TO 4J-INSTALL-LOC-NO.              
                                                                        
           PERFORM 7000-GET-CURR-TS THRU 7000-EXIT.                     
           MOVE WS-SAVE-FXTR-POINT TO 4J-INSTALL-POINT-NO.              
           MOVE 'LMS CONVERSION - RATE064 USING CIS & GIS DATA'         
              TO 4J-TRANS-COMMENTS-TEXT.                                
           COMPUTE 4J-TRANS-COMMENTS-LEN  = 45                          
           PERFORM 8400-INS-LMS-TRN-HST  THRU 8400-EXIT.                
                                                                        
           MOVE 1 TO 4S-DETAIL-SEQ-NO.                                  
           MOVE 4J-EQUIP-SEQ TO 4S-EQUIP-SEQ.                           
           MOVE 4J-LAST-UPDATE-USERID TO 4S-LAST-UPDATE-USERID.         
           MOVE 'FXTR_RATE_PLAN_NO' TO 4S-COLUMN-DESC.                  
           MOVE '*NEW*' TO 4S-PRV-COLUMN-VALUE-TEXT.                    
           MOVE 5 TO 4S-PRV-COLUMN-VALUE-LEN.                           
           MOVE '064' TO 4S-CHG-COLUMN-VALUE-TEXT.                      
           MOVE 3 TO 4S-CHG-COLUMN-VALUE-LEN.                           
           PERFORM 8500-INSERT-TRANS-HIST-DET THRU 8500-EXIT.           
                                                                        
           MOVE 2 TO 4S-DETAIL-SEQ-NO.                                  
           MOVE 'FXTR_RATE_ITEM_CD' TO 4S-COLUMN-DESC.                  
           MOVE '*NEW*' TO 4S-PRV-COLUMN-VALUE-TEXT.                    
           MOVE 5 TO 4S-PRV-COLUMN-VALUE-LEN.                           
           MOVE 0 TO WS-RATE-ITEM-FMT-N.                                
           MOVE WS-RATE-ITEM-CD TO WS-RATE-ITEM-FMT-N.                  
           IF WS-RATE-ITEM-FMT-N > 0                                    
              MOVE WS-RATE-ITEM-FMT    TO 4S-CHG-COLUMN-VALUE-TEXT      
              MOVE 4 TO 4S-CHG-COLUMN-VALUE-LEN                         
           ELSE                                                         
              MOVE ' ' TO 4S-CHG-COLUMN-VALUE-TEXT                      
              MOVE 1 TO 4S-CHG-COLUMN-VALUE-LEN                         
           END-IF                                                       
           MOVE 3 TO 4S-CHG-COLUMN-VALUE-LEN.                           
           PERFORM 8500-INSERT-TRANS-HIST-DET THRU 8500-EXIT.           
                                                                        
           MOVE 3 TO 4S-DETAIL-SEQ-NO.                                  
           MOVE 'FXTR_BILLING_FL'   TO 4S-COLUMN-DESC.                  
           MOVE '*NEW*' TO 4S-PRV-COLUMN-VALUE-TEXT.                    
           MOVE 5 TO 4S-PRV-COLUMN-VALUE-LEN.                           
           MOVE 'Y' TO 4S-CHG-COLUMN-VALUE-TEXT                         
           MOVE 1 TO 4S-CHG-COLUMN-VALUE-LEN                            
           PERFORM 8500-INSERT-TRANS-HIST-DET THRU 8500-EXIT.           
                                                                        
      *** POLE-TRANSACTION HISTORY DETAILS                                      
           MOVE 4 TO 4S-DETAIL-SEQ-NO.                                  
           MOVE 'POLE NUMBER'   TO 4S-COLUMN-DESC.                      
           MOVE '*NEW*' TO 4S-PRV-COLUMN-VALUE-TEXT.                    
           MOVE 5 TO 4S-PRV-COLUMN-VALUE-LEN.                           
           MOVE FIOLM064-GIS-POLE-NO TO 4S-CHG-COLUMN-VALUE-TEXT        
           MOVE 10 TO 4S-CHG-COLUMN-VALUE-LEN                           
           PERFORM 8500-INSERT-TRANS-HIST-DET THRU 8500-EXIT.           
                                                                        
           MOVE 5 TO 4S-DETAIL-SEQ-NO.                                  
           MOVE 'POLE_RATE_PLAN_NO'   TO 4S-COLUMN-DESC.                
           MOVE '*NEW*' TO 4S-PRV-COLUMN-VALUE-TEXT.                    
           MOVE 5 TO 4S-PRV-COLUMN-VALUE-LEN.                           
           MOVE 4F-RATE-PLAN-NO TO 4S-CHG-COLUMN-VALUE-TEXT             
           MOVE 3 TO 4S-PRV-COLUMN-VALUE-LEN.                           
           PERFORM 8500-INSERT-TRANS-HIST-DET THRU 8500-EXIT.           
                                                                        
           MOVE 6 TO 4S-DETAIL-SEQ-NO.                                  
           MOVE 'POLE_RATE_ITEM_CD'   TO 4S-COLUMN-DESC.                
           MOVE '*NEW*' TO 4S-PRV-COLUMN-VALUE-TEXT.                    
           MOVE 5 TO 4S-PRV-COLUMN-VALUE-LEN.                           
           MOVE 4F-RATE-ITEM-CODE TO WS-RATE-ITEM-FMT-N.                
           IF WS-RATE-ITEM-FMT-N > 0                                    
              MOVE WS-RATE-ITEM-FMT    TO 4S-CHG-COLUMN-VALUE-TEXT      
              MOVE 4 TO 4S-CHG-COLUMN-VALUE-LEN                         
           ELSE                                                         
              MOVE ' ' TO 4S-CHG-COLUMN-VALUE-TEXT                      
              MOVE 1 TO 4S-CHG-COLUMN-VALUE-LEN                         
           END-IF                                                       
           PERFORM 8500-INSERT-TRANS-HIST-DET THRU 8500-EXIT.           
                                                                        
           MOVE 7 TO 4S-DETAIL-SEQ-NO.                                  
           MOVE 'POLE_BILLING_FL'     TO 4S-COLUMN-DESC.                
           MOVE '*NEW*' TO 4S-PRV-COLUMN-VALUE-TEXT.                    
           MOVE 5 TO 4S-PRV-COLUMN-VALUE-LEN.                           
           MOVE 'N' TO 4S-CHG-COLUMN-VALUE-TEXT                         
           MOVE 1 TO 4S-CHG-COLUMN-VALUE-LEN                            
           PERFORM 8500-INSERT-TRANS-HIST-DET THRU 8500-EXIT.           
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2700-PROCESS-EXCPTNS.                                            
      *                                                                         
      *** EMAIL EXCPTNS TO GROUP, FORCING RC TO 05                              
           IF CREATE-EXCPTN-EMAIL                                       
              MOVE 05                        TO  RETURN-CODE            
              DISPLAY '                                     '           
              DISPLAY '*************************************'           
              DISPLAY '*           PCSLM064                *'           
              DISPLAY '*    RATE64 FILE HAS EXCEPTIONS     *'           
              DISPLAY '*       EMAILING EXCEPTIONS         *'           
              DISPLAY '*  RC=05 IS SUCCESSFUL EXECUTION    *'           
              DISPLAY '*************************************'           
           END-IF.                                                      
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *GET CURRENT TIMESTAMP TO INSERT INTO TRANSACTION HISTORY                 
      ******************************************************************        
       7000-GET-CURR-TS.                                                
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :4J-TRANS-HIST-SEQ-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :4J-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          WS-SQL-CODE                   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE 4J-TRANS-HIST-SEQ-NO        TO 4S-TRANS-HIST-SEQ-NO 
           ELSE                                                         
               DISPLAY '**  SELECT ERROR IN 7000                **'     
               DISPLAY '**  RETURN CODE = ' WS-SQL-CODE                 
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **                                                            **          
      **   7100-READ-FCSLM64                                        **          
      **       READS DATA RECORD FROM THE INPUT FILE FCSLM64        **          
      **                                                            **          
      ****************************************************************          
       7100-READ-FCSLM64.                                               
                                                                        
           READ FCSLM064-FILE                                           
               AT END                                                   
                   MOVE WS-NO          TO WS-MORE-DATA-SW               
                   GO                  TO 7100-EXIT.                    
                                                                        
           IF FLM64-SUCCESSFUL                                          
               ADD 1                   TO WS-FLM64-REC-CNTR             
           ELSE                                                         
               DISPLAY '**  PARA  7100-READ-FCSLM64             **'     
               DISPLAY '**  READ ERROR OF FCSLM64 - INPUT FILE  **'     
               DISPLAY '**         FILE STATUS = ' WS-FLM64-STATUS      
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **      7400-CHECK-RATE-ITEM.                                 **          
      **                                                            **          
      ****************************************************************          
       7400-CHECK-RATE-ITEM.                                            
                                                                        
           EXEC SQL                                                     
               SELECT  RATE_ITEM_CD                                     
               INTO :WS-RATE-ITEM-CD                                    
ACT051         FROM  CSS_SUBDIVISION                                    
                WHERE  SUBDIVISION_ID   =  :WS-SUB-DIVISION-ID-2        
ACT051            AND  COMPANY_NO       = '01'                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  RATE_ITEM_CD                                             
MFA-TR*        INTO :WS-RATE-ITEM-CD                                            
MFA-TR*        FROM  CSS_SUBDIVISION                                            
MFA-TR*         WHERE  SUBDIVISION_ID   =  :WS-SUB-DIVISION-ID-2                
MFA-TR*           AND  COMPANY_NO       = '01'                                  
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-SQL-CODE.                                 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND                                              
              IF WS-RATE-ITEM-CD > 0                                    
                 MOVE 'Y' TO WS-VLD-SUBDIV-FL                           
              ELSE                                                      
                 SET INVALID-RECORD TO TRUE                             
              END-IF                                                    
           ELSE                                                         
               DISPLAY '**  SELECT ERROR IN 7400-               **'     
               DISPLAY '**  RETURN CODE = ' WS-SQL-CODE                 
               DISPLAY '**  SUBDIV ID   = ' WS-SUB-DIVISION-ID-2        
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **                                                            **          
      **      7450-CHECK-DUPLICATE.                                 **          
      **                                                            **          
      ****************************************************************          
       7450-CHECK-DUPLICATE.                                            
                                                                        
           MOVE FIOLM064-FXPL-CONV-TAG TO 4D-EQUIP-TAG-NO.              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) EQUIP_TAG_NO                                       
               INTO :4J-EQUIP-TAG-NO                                    
              FROM LMS_EQUIP_INVENTRY A1 WITH(READUNCOMMITTED)                  
              WHERE A1.EQUIP_TAG_NO = :4D-EQUIP-TAG-NO                  
              AND A1.EQUIP_TYPE_CD = 'F'                                
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EQUIP_TAG_NO                                               
MFA-TR*        INTO :4J-EQUIP-TAG-NO                                            
MFA-TR*       FROM LMS_EQUIP_INVENTRY A1                                        
MFA-TR*       WHERE A1.EQUIP_TAG_NO = :4D-EQUIP-TAG-NO                          
MFA-TR*       AND A1.EQUIP_TYPE_CD = 'F'                                        
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7450                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-SQL-CODE.                                 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND                                              
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '**  SELECT ERROR IN 7450-               **'     
               DISPLAY '**  RETURN CODE = ' WS-SQL-CODE                 
               DISPLAY '**  EQUIP-TAG-NO = ' 4D-EQUIP-TAG-NO            
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE  = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                WS-SQL-CODE.            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '**  SET STATEMENT ERROR 7500- PARA      **'     
               DISPLAY '**  RETURN CODE = ' WS-SQL-CODE                 
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7600-GET-FXTR-STOCK                                            *        
      ******************************************************************        
       7600-GET-FXTR-STOCK.                                             
                                                                        
           MOVE ' ' TO 3U-LMS-CODE-DESC.                                
           MOVE FIOLM064-GIS-WATTAGE-NO TO 3U-LMS-CODE-DESC(1:4).       
           MOVE FIOLM064-GIS-BULB-TYPE  TO 3U-LMS-CODE-DESC(6:10).      
           MOVE FIOLM064-GIS-FXTR-STYLE TO 3U-LMS-CODE-DESC(17:20).     
                                                                        
           EXEC SQL                                                     
              SELECT
              UPPER(:3U-LMS-CODE-DESC)
            INTO
              :3U-LMS-CODE-DESC     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :3U-LMS-CODE-DESC      = UPPER(:3U-LMS-CODE-DESC)             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
            SELECT CIS.SUBSTR3(LMS_CODE_DESC,38,11)                          
              INTO :WS-STOCK-CD-FMT                                     
              FROM LMS_CODE_DESC WITH(READUNCOMMITTED)                          
             WHERE COMPANY_NO        = '01'                             
             AND LMS_COLUMN_NA       = 'CNV-FXTR-STOCK-CD'              
             AND CIS.SUBSTR3(LMS_CODE_DESC,1,4)   =                          
                 CIS.SUBSTR3(:3U-LMS-CODE-DESC,1,4)                          
             AND CIS.SUBSTR3(LMS_CODE_DESC,6,10)   =                         
                 CIS.SUBSTR3(:3U-LMS-CODE-DESC,6,10)                         
             AND CIS.SUBSTR3(LMS_CODE_DESC,17,20)   =                        
                 CIS.SUBSTR3(:3U-LMS-CODE-DESC,17,20)                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT SUBSTR(LMS_CODE_DESC,38,11)                                  
MFA-TR*       INTO :WS-STOCK-CD-FMT                                             
MFA-TR*       FROM LMS_CODE_DESC                                                
MFA-TR*      WHERE COMPANY_NO        = '01'                                     
MFA-TR*      AND LMS_COLUMN_NA       = 'CNV-FXTR-STOCK-CD'                      
MFA-TR*      AND SUBSTR(LMS_CODE_DESC,1,4)   =                                  
MFA-TR*          SUBSTR(:3U-LMS-CODE-DESC,1,4)                                  
MFA-TR*      AND SUBSTR(LMS_CODE_DESC,6,10)   =                                 
MFA-TR*          SUBSTR(:3U-LMS-CODE-DESC,6,10)                                 
MFA-TR*      AND SUBSTR(LMS_CODE_DESC,17,20)   =                                
MFA-TR*          SUBSTR(:3U-LMS-CODE-DESC,17,20)                                
MFA-TR*       WITH UR                                                           
MFA-TR*      QUERYNO 7600                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-PGM-NAME              TO ABEND-PROGRAM            
              MOVE '7600'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'LMS_CODE_DESC     '     TO TABLE-1                  
              MOVE 'LMS-CODE-DESC'          TO TABLE-ELEMENT-2          
              MOVE 3U-LMS-CODE-DESC         TO HOSTVAR-ELEMENT-2        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7700-CHECK-CODEDESC                                            *        
      ******************************************************************        
       7700-CHECK-CODEDESC.                                             
                                                                        
           MOVE ' ' TO 3U-LMS-CODE-DESC.                                
           MOVE FIOLM064-GIS-POLE-HEIGHT TO 3U-LMS-CODE-DESC(1:4).      
           MOVE FIOLM064-GIS-POLE-TYPE  TO 3U-LMS-CODE-DESC(6:10).      
                                                                        
           EXEC SQL                                                     
            SELECT CIS.SUBSTR3(LMS_CODE_DESC,17,11)                          
              INTO :WS-STOCK-CD-FMT                                     
              FROM LMS_CODE_DESC WITH(READUNCOMMITTED)                          
             WHERE COMPANY_NO         = '01'                            
              AND LMS_COLUMN_NA       = 'CNV-POLE-STOCK-CD'             
              AND CIS.SUBSTR3(LMS_CODE_DESC,1,4)   =                         
                  CIS.SUBSTR3(:3U-LMS-CODE-DESC,1,4)                         
              AND CIS.SUBSTR3(LMS_CODE_DESC,6,10)   =                        
                  CIS.SUBSTR3(:3U-LMS-CODE-DESC,6,10)                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT SUBSTR(LMS_CODE_DESC,17,11)                                  
MFA-TR*       INTO :WS-STOCK-CD-FMT                                             
MFA-TR*       FROM LMS_CODE_DESC                                                
MFA-TR*      WHERE COMPANY_NO         = '01'                                    
MFA-TR*       AND LMS_COLUMN_NA       = 'CNV-POLE-STOCK-CD'                     
MFA-TR*       AND SUBSTR(LMS_CODE_DESC,1,4)   =                                 
MFA-TR*           SUBSTR(:3U-LMS-CODE-DESC,1,4)                                 
MFA-TR*       AND SUBSTR(LMS_CODE_DESC,6,10)   =                                
MFA-TR*           SUBSTR(:3U-LMS-CODE-DESC,6,10)                                
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7700                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-PGM-NAME              TO ABEND-PROGRAM            
              MOVE '7700'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'LMS_CODE_DESC     '     TO TABLE-1                  
              MOVE 'LMS_CODE_DESC      '    TO TABLE-ELEMENT-2          
              MOVE 3U-LMS-CODE-DESC         TO HOSTVAR-ELEMENT-2        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7800-CHECK-INSTALL-LOC                                         *        
      ******************************************************************        
       7800-CHECK-INSTALL-LOC.                                          
                                                                        
           EXEC SQL                                                     
            SELECT  COALESCE(MAX(INSTALL_POINT_NO),0)                     
              INTO :4F-INSTALL-POINT-NO                                 
              FROM  LMS_EQUIP_ENVRNMT WITH(READUNCOMMITTED)                     
             WHERE  INSTALL_LOC_NO   =  :4F-INSTALL-LOC-NO              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT  IFNULL(MAX(INSTALL_POINT_NO),0)                             
MFA-TR*       INTO :4F-INSTALL-POINT-NO                                         
MFA-TR*       FROM  LMS_EQUIP_ENVRNMT                                           
MFA-TR*      WHERE  INSTALL_LOC_NO   =  :4F-INSTALL-LOC-NO                      
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7800                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-PGM-NAME              TO ABEND-PROGRAM            
              MOVE '7800'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_ENVRNMT    '  TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-2          
              MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-2        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7900-CHECK-FXTR-ATTACH                                         *        
      ******************************************************************        
       7900-CHECK-FXTR-ATTACH.                                          
                                                                        
           EXEC SQL                                                     
            SELECT  COALESCE(MAX(ATTACH_SEQ_NO),0)                        
              INTO :4H-ATTACH-SEQ-NO                                    
              FROM  LMS_FXTR_ATTACHMTS WITH(READUNCOMMITTED)                    
             WHERE  FXTR_EQUIP_SEQ   =  :4H-FXTR-EQUIP-SEQ              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT  IFNULL(MAX(ATTACH_SEQ_NO),0)                                
MFA-TR*       INTO :4H-ATTACH-SEQ-NO                                            
MFA-TR*       FROM  LMS_FXTR_ATTACHMTS                                          
MFA-TR*      WHERE  FXTR_EQUIP_SEQ   =  :4H-FXTR-EQUIP-SEQ                      
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7900                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-PGM-NAME              TO ABEND-PROGRAM            
              MOVE '7900'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'LMS_FXTR_ATTACHMTS '    TO TABLE-1                  
              MOVE 'FXTR_EQUIP_SEQ  '       TO TABLE-ELEMENT-2          
              MOVE 4H-FXTR-EQUIP-SEQ        TO HOSTVAR-ELEMENT-2        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * INSERT RECORD IN THE LMS EQUIP INVENTRY TABLE.              *           
      ***************************************************************           
       8100-INSERT-LMS-INVENTORY.                                       
                                                                        
           EXEC SQL                                                     
           INSERT INTO LMS_EQUIP_INVENTRY                               
                 ( EQUIP_SEQ                                            
                  ,EQUIP_TAG_NO                                         
                  ,COMPANY_NO                                           
                  ,CODE_SERVICE_TYPE                                    
                  ,STOCK_CD                                             
                  ,EQUIP_TYPE_CD                                        
                  ,EQUIP_MFR_CD                                         
                  ,EQUIP_MFR_DT                                         
                  ,WARRANTY_EXP_DT                                      
                  ,EQUIP_DISPOSAL_DT                                    
                  ,STORAGE_FAC_CD                                       
                  ,IN_TRANSIT_USERID                                    
                  ,INVENTRY_STATUS_CD                                   
                  ,WRNTY_RECEIVED_FL                                    
                  ,WRNTY_RECOUP_AMT                                     
                  ,LAST_UPDATE_USERID)                                  
             VALUES ( :4D-EQUIP-SEQ                                     
                     ,:4D-EQUIP-TAG-NO                                  
                     ,:4D-COMPANY-NO                                    
                     ,:4D-CODE-SERVICE-TYPE                             
                     ,:4D-STOCK-CD                                      
                     ,:4D-EQUIP-TYPE-CD                                 
                     ,:4D-EQUIP-MFR-CD                                  
                     ,IIF(TRY_CONVERT(DATE, :4D-EQUIP-MFR-DT 
                                            :WS-NULL-MFR-DT
              ) IS NULL OR (PATINDEX('%.%', :4D-EQUIP-MFR-DT 
                                                        :WS-NULL-MFR-DT
              ) <> 0) OR (LEN(:4D-EQUIP-MFR-DT :WS-NULL-MFR-DT
              ) <> 10), CIS.CHAR2DATE(:4D-EQUIP-MFR-DT :WS-NULL-MFR-DT
              ), CONVERT(DATE, :4D-EQUIP-MFR-DT :WS-NULL-MFR-DT) )             
                     ,IIF(TRY_CONVERT(DATE, :4D-WARRANTY-EXP-DT 
                                            :WS-NULL-EXP-DT
              ) IS NULL OR (PATINDEX('%.%', :4D-WARRANTY-EXP-DT 
                                                        :WS-NULL-EXP-DT
              ) <> 0) OR (LEN(:4D-WARRANTY-EXP-DT :WS-NULL-EXP-DT
              ) <> 10), CIS.CHAR2DATE(:4D-WARRANTY-EXP-DT 
                                                        :WS-NULL-EXP-DT
              ), CONVERT(DATE, :4D-WARRANTY-EXP-DT :WS-NULL-EXP-DT) )          
                     ,IIF(TRY_CONVERT(DATE, :4D-EQUIP-DISPOSAL-DT 
                                            :WS-NULL-DISPOSAL-DT
              ) IS NULL OR (PATINDEX('%.%', :4D-EQUIP-DISPOSAL-DT 
                                                   :WS-NULL-DISPOSAL-DT
              ) <> 0) OR (LEN(:4D-EQUIP-DISPOSAL-DT 
                                                   :WS-NULL-DISPOSAL-DT
              ) <> 10), CIS.CHAR2DATE(:4D-EQUIP-DISPOSAL-DT 
                                                   :WS-NULL-DISPOSAL-DT
              ), CONVERT(DATE, :4D-EQUIP-DISPOSAL-DT 
                                                   :WS-NULL-DISPOSAL-DT
              ) )         
                     ,:4D-STORAGE-FAC-CD                                
                     ,:4D-IN-TRANSIT-USERID                             
                     ,:4D-INVENTRY-STATUS-CD                            
                     ,:4D-WRNTY-RECEIVED-FL                             
                     ,:4D-WRNTY-RECOUP-AMT                              
                     ,:4D-LAST-UPDATE-USERID)                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    INSERT INTO LMS_EQUIP_INVENTRY                                       
MFA-TR*          ( EQUIP_SEQ                                                    
MFA-TR*           ,EQUIP_TAG_NO                                                 
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,CODE_SERVICE_TYPE                                            
MFA-TR*           ,STOCK_CD                                                     
MFA-TR*           ,EQUIP_TYPE_CD                                                
MFA-TR*           ,EQUIP_MFR_CD                                                 
MFA-TR*           ,EQUIP_MFR_DT                                                 
MFA-TR*           ,WARRANTY_EXP_DT                                              
MFA-TR*           ,EQUIP_DISPOSAL_DT                                            
MFA-TR*           ,STORAGE_FAC_CD                                               
MFA-TR*           ,IN_TRANSIT_USERID                                            
MFA-TR*           ,INVENTRY_STATUS_CD                                           
MFA-TR*           ,WRNTY_RECEIVED_FL                                            
MFA-TR*           ,WRNTY_RECOUP_AMT                                             
MFA-TR*           ,LAST_UPDATE_USERID)                                          
MFA-TR*      VALUES ( :4D-EQUIP-SEQ                                             
MFA-TR*              ,:4D-EQUIP-TAG-NO                                          
MFA-TR*              ,:4D-COMPANY-NO                                            
MFA-TR*              ,:4D-CODE-SERVICE-TYPE                                     
MFA-TR*              ,:4D-STOCK-CD                                              
MFA-TR*              ,:4D-EQUIP-TYPE-CD                                         
MFA-TR*              ,:4D-EQUIP-MFR-CD                                          
MFA-TR*              ,:4D-EQUIP-MFR-DT:WS-NULL-MFR-DT                           
MFA-TR*              ,:4D-WARRANTY-EXP-DT:WS-NULL-EXP-DT                        
MFA-TR*              ,:4D-EQUIP-DISPOSAL-DT:WS-NULL-DISPOSAL-DT                 
MFA-TR*              ,:4D-STORAGE-FAC-CD                                        
MFA-TR*              ,:4D-IN-TRANSIT-USERID                                     
MFA-TR*              ,:4D-INVENTRY-STATUS-CD                                    
MFA-TR*              ,:4D-WRNTY-RECEIVED-FL                                     
MFA-TR*              ,:4D-WRNTY-RECOUP-AMT                                      
MFA-TR*              ,:4D-LAST-UPDATE-USERID)                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE         
                                          WS-SQL-CODE                   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD 1                   TO WS-INSERT-REC-CNTR             
           ELSE                                                         
               DISPLAY '**  INSERT ERROR IN 8100-               **'     
               DISPLAY '**  RETURN CODE = ' WS-SQL-CODE                 
               MOVE 'LMS_EQUIP_INVENTRY  '   TO TABLE-1                 
               DISPLAY '**  EQUIP-SEQ-NO  ' 4D-EQUIP-SEQ                
               DISPLAY '**  EQUIP-TAG-NO  ' 4D-EQUIP-TAG-NO             
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * INSERT RECORD IN THE LMS EQUIP ENVRNMT  TABLE.              *           
      ***************************************************************           
       8200-INSERT-EQUIP-ENVRNMT.                                       
                                                                        
           MOVE +0 TO 4F-SPCL-AGR-COMMENTS-LEN                          
                      4F-EQUIP-COMMENTS-LEN.                            
                                                                        
           EXEC SQL                                                     
           INSERT INTO LMS_EQUIP_ENVRNMT                                
                  ( INSTALL_LOC_NO                                      
                   ,INSTALL_POINT_NO                                    
                   ,EQUIP_SEQ                                           
                   ,INSTALL_LOC_CD                                      
                   ,CODE_UTIL_TYPE                                      
                   ,IC_NO                                               
                   ,RATE_PLAN_NO                                        
                   ,RATE_ITEM_CODE                                      
                   ,ITEM_SEQ_NO                                         
                   ,BILLING_FL                                          
                   ,NO_BILL_REASON_CD                                   
                   ,EQUIP_CONTRACT_FL                                   
                   ,NO_CONTRACT_RSN_CD                                  
                   ,EQUIP_OWNER_CD                                      
                   ,EQUIP_DRAWING_ID                                    
                   ,EQUIP_GIS_GKEY                                      
                   ,SOURCE_APPL_CD                                      
                   ,SOURCE_APPL_REQ_NO                                  
                   ,WMS_POINT_NO                                        
                   ,EQUIP_INSTALL_DT                                    
                   ,INSTALL_USERID                                      
                   ,APPROVED_TS                                         
                   ,APPROVER_USERID                                     
                   ,LAST_UPDATE_TS                                      
                   ,LAST_UPDATE_USERID                                  
                   ,SPCL_AGR_COMMENTS                                   
                   ,EQUIP_COMMENTS )                                    
           VALUES (:4F-INSTALL-LOC-NO                                   
                  ,:4F-INSTALL-POINT-NO                                 
                  ,:4F-EQUIP-SEQ                                        
                  ,:4F-INSTALL-LOC-CD                                   
                  ,:4F-CODE-UTIL-TYPE                                   
                  ,:4F-IC-NO                                            
                  ,:4F-RATE-PLAN-NO                                     
                  ,:4F-RATE-ITEM-CODE                                   
                  ,:4F-ITEM-SEQ-NO                                      
                  ,:4F-BILLING-FL                                       
                  ,:4F-NO-BILL-REASON-CD                                
                  ,:4F-EQUIP-CONTRACT-FL                                
                  ,:4F-NO-CONTRACT-RSN-CD                               
                  ,:4F-EQUIP-OWNER-CD                                   
                  ,:4F-EQUIP-DRAWING-ID                                 
                  ,:4F-EQUIP-GIS-GKEY                                   
                  ,:4F-SOURCE-APPL-CD                                   
                  ,:4F-SOURCE-APPL-REQ-NO                               
                  ,:4F-WMS-POINT-NO                                     
                  ,IIF(TRY_CONVERT(DATE, :4F-EQUIP-INSTALL-DT 
                                         :WS-NULL-INSTALL-DT
              ) IS NULL OR (PATINDEX('%.%', :4F-EQUIP-INSTALL-DT 
                                                    :WS-NULL-INSTALL-DT
              ) <> 0) OR (LEN(:4F-EQUIP-INSTALL-DT :WS-NULL-INSTALL-DT
              ) <> 10), CIS.CHAR2DATE(:4F-EQUIP-INSTALL-DT 
                                                    :WS-NULL-INSTALL-DT
              ), CONVERT(DATE, :4F-EQUIP-INSTALL-DT :WS-NULL-INSTALL-DT
              ) )             
                  ,:4F-INSTALL-USERID                                   
                  ,CIS.CHAR2TIMESTAMP(:4F-APPROVED-TS 
                                      :WS-APPROVED-TS-IND)             
                  ,:4F-APPROVER-USERID                                  
                  ,CIS.CURRENT$TIMESTAMP()                                    
                  ,:4F-LAST-UPDATE-USERID                               
                  ,:4F-SPCL-AGR-COMMENTS                                
                  ,:4F-EQUIP-COMMENTS )                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    INSERT INTO LMS_EQUIP_ENVRNMT                                        
MFA-TR*           ( INSTALL_LOC_NO                                              
MFA-TR*            ,INSTALL_POINT_NO                                            
MFA-TR*            ,EQUIP_SEQ                                                   
MFA-TR*            ,INSTALL_LOC_CD                                              
MFA-TR*            ,CODE_UTIL_TYPE                                              
MFA-TR*            ,IC_NO                                                       
MFA-TR*            ,RATE_PLAN_NO                                                
MFA-TR*            ,RATE_ITEM_CODE                                              
MFA-TR*            ,ITEM_SEQ_NO                                                 
MFA-TR*            ,BILLING_FL                                                  
MFA-TR*            ,NO_BILL_REASON_CD                                           
MFA-TR*            ,EQUIP_CONTRACT_FL                                           
MFA-TR*            ,NO_CONTRACT_RSN_CD                                          
MFA-TR*            ,EQUIP_OWNER_CD                                              
MFA-TR*            ,EQUIP_DRAWING_ID                                            
MFA-TR*            ,EQUIP_GIS_GKEY                                              
MFA-TR*            ,SOURCE_APPL_CD                                              
MFA-TR*            ,SOURCE_APPL_REQ_NO                                          
MFA-TR*            ,WMS_POINT_NO                                                
MFA-TR*            ,EQUIP_INSTALL_DT                                            
MFA-TR*            ,INSTALL_USERID                                              
MFA-TR*            ,APPROVED_TS                                                 
MFA-TR*            ,APPROVER_USERID                                             
MFA-TR*            ,LAST_UPDATE_TS                                              
MFA-TR*            ,LAST_UPDATE_USERID                                          
MFA-TR*            ,SPCL_AGR_COMMENTS                                           
MFA-TR*            ,EQUIP_COMMENTS )                                            
MFA-TR*    VALUES (:4F-INSTALL-LOC-NO                                           
MFA-TR*           ,:4F-INSTALL-POINT-NO                                         
MFA-TR*           ,:4F-EQUIP-SEQ                                                
MFA-TR*           ,:4F-INSTALL-LOC-CD                                           
MFA-TR*           ,:4F-CODE-UTIL-TYPE                                           
MFA-TR*           ,:4F-IC-NO                                                    
MFA-TR*           ,:4F-RATE-PLAN-NO                                             
MFA-TR*           ,:4F-RATE-ITEM-CODE                                           
MFA-TR*           ,:4F-ITEM-SEQ-NO                                              
MFA-TR*           ,:4F-BILLING-FL                                               
MFA-TR*           ,:4F-NO-BILL-REASON-CD                                        
MFA-TR*           ,:4F-EQUIP-CONTRACT-FL                                        
MFA-TR*           ,:4F-NO-CONTRACT-RSN-CD                                       
MFA-TR*           ,:4F-EQUIP-OWNER-CD                                           
MFA-TR*           ,:4F-EQUIP-DRAWING-ID                                         
MFA-TR*           ,:4F-EQUIP-GIS-GKEY                                           
MFA-TR*           ,:4F-SOURCE-APPL-CD                                           
MFA-TR*           ,:4F-SOURCE-APPL-REQ-NO                                       
MFA-TR*           ,:4F-WMS-POINT-NO                                             
MFA-TR*           ,:4F-EQUIP-INSTALL-DT :WS-NULL-INSTALL-DT                     
MFA-TR*           ,:4F-INSTALL-USERID                                           
MFA-TR*           ,:4F-APPROVED-TS      :WS-APPROVED-TS-IND                     
MFA-TR*           ,:4F-APPROVER-USERID                                          
MFA-TR*           ,CURRENT TIMESTAMP                                            
MFA-TR*           ,:4F-LAST-UPDATE-USERID                                       
MFA-TR*           ,:4F-SPCL-AGR-COMMENTS                                        
MFA-TR*           ,:4F-EQUIP-COMMENTS )                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE         
                                          WS-SQL-CODE                   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD 1                   TO WS-INSERT-REC-CNTR             
           ELSE                                                         
               DISPLAY '**  INSERT ERROR IN 8200-               **'     
               DISPLAY '**  RETURN CODE = ' WS-SQL-CODE                 
               MOVE 'LMS_EQUIP_ENVRNMT   '   TO TABLE-1                 
               DISPLAY '**  INSTALL-LOC   ' 4F-INSTALL-LOC-NO           
               DISPLAY '**  SEQ-NO        ' 4F-EQUIP-SEQ                
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * INSERT RECORD IN THE LMS_FXTR_ATTACHMTS TABLE.              *           
      ***************************************************************           
       8300-INSERT-FXTR-ATTACHMTS.                                      
                                                                        
           EXEC SQL                                                     
           INSERT INTO LMS_FXTR_ATTACHMTS                               
                  ( FXTR_EQUIP_SEQ                                      
                   ,ATTACH_SEQ_NO                                       
                   ,EQUIP_TYPE_CD                                       
                   ,ATTACH_EQUIP_SEQ                                    
                   ,ATTACH_EQUIP_DT                                     
                   ,LAST_UPDATE_USERID)                                 
           VALUES ( :4H-FXTR-EQUIP-SEQ                                  
                   ,:4H-ATTACH-SEQ-NO                                   
                   ,:4H-EQUIP-TYPE-CD                                   
                   ,:4H-ATTACH-EQUIP-SEQ                                
                   ,IIF(TRY_CONVERT(DATE, :4H-ATTACH-EQUIP-DT
              ) IS NULL OR (PATINDEX('%.%', :4H-ATTACH-EQUIP-DT
              ) <> 0) OR (LEN(:4H-ATTACH-EQUIP-DT
              ) <> 10), CIS.CHAR2DATE(:4H-ATTACH-EQUIP-DT
              ), CONVERT(DATE, :4H-ATTACH-EQUIP-DT) )                          
                   ,:4H-LAST-UPDATE-USERID)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    INSERT INTO LMS_FXTR_ATTACHMTS                                       
MFA-TR*           ( FXTR_EQUIP_SEQ                                              
MFA-TR*            ,ATTACH_SEQ_NO                                               
MFA-TR*            ,EQUIP_TYPE_CD                                               
MFA-TR*            ,ATTACH_EQUIP_SEQ                                            
MFA-TR*            ,ATTACH_EQUIP_DT                                             
MFA-TR*            ,LAST_UPDATE_USERID)                                         
MFA-TR*    VALUES ( :4H-FXTR-EQUIP-SEQ                                          
MFA-TR*            ,:4H-ATTACH-SEQ-NO                                           
MFA-TR*            ,:4H-EQUIP-TYPE-CD                                           
MFA-TR*            ,:4H-ATTACH-EQUIP-SEQ                                        
MFA-TR*            ,:4H-ATTACH-EQUIP-DT                                         
MFA-TR*            ,:4H-LAST-UPDATE-USERID)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE         
                                          WS-SQL-CODE                   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '**  INSERT ERROR IN 8300-               **'     
               DISPLAY '**  RETURN CODE = ' WS-SQL-CODE                 
               MOVE 'LMS_FXTR_ATTACHMTS   '  TO TABLE-1                 
               DISPLAY '**  EQUIP-SEQ-NO  ' 4H-FXTR-EQUIP-SEQ           
               DISPLAY '**  ATTACH-SEQ-NO ' 4H-ATTACH-SEQ-NO            
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * INSERT RECORD IN THE LMS TRANSACTION HISTORY TABLE.         *           
      ***************************************************************           
       8400-INS-LMS-TRN-HST.                                            
                                                                        
           EXEC SQL                                                     
               INSERT INTO LMS_TRANS_HIST                               
                 ( EQUIP_SEQ,           TRANS_HIST_SEQ_NO,              
                   EQUIP_TAG_NO,        APPL_PROGRAM_ID,                
                   TRANS_DATE,          SOURCE_APPL_CD,                 
                   SOURCE_APPL_REQ_NO,  WMS_POINT_NO,                   
                   INSTALL_LOC_NO,      INSTALL_POINT_NO,               
                   ACCOUNT_NO,          LAST_UPDATE_USERID,             
                   TRANS_COMMENTS      )                                
               VALUES                                                   
                 ( :4J-EQUIP-SEQ,           CIS.CHAR2TIMESTAMP(
                                                  :4J-TRANS-HIST-SEQ-NO
              ),      
                   :4J-EQUIP-TAG-NO,        :4J-APPL-PROGRAM-ID,        
                   IIF(TRY_CONVERT(DATE, :4J-TRANS-DATE
              ) IS NULL OR (PATINDEX('%.%', :4J-TRANS-DATE
              ) <> 0) OR (LEN(:4J-TRANS-DATE) <> 10), CIS.CHAR2DATE(
                                                         :4J-TRANS-DATE
              ), CONVERT(DATE, :4J-TRANS-DATE) ),          
                                                    :4J-SOURCE-APPL-CD,        
                   :4J-SOURCE-APPL-REQ-NO,  :4J-WMS-POINT-NO,           
                   :4J-INSTALL-LOC-NO,      :4J-INSTALL-POINT-NO,       
                   :4J-ACCOUNT-NO,          :4J-LAST-UPDATE-USERID,     
                   :4J-TRANS-COMMENTS  )                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO LMS_TRANS_HIST                                       
MFA-TR*          ( EQUIP_SEQ,           TRANS_HIST_SEQ_NO,                      
MFA-TR*            EQUIP_TAG_NO,        APPL_PROGRAM_ID,                        
MFA-TR*            TRANS_DATE,          SOURCE_APPL_CD,                         
MFA-TR*            SOURCE_APPL_REQ_NO,  WMS_POINT_NO,                           
MFA-TR*            INSTALL_LOC_NO,      INSTALL_POINT_NO,                       
MFA-TR*            ACCOUNT_NO,          LAST_UPDATE_USERID,                     
MFA-TR*            TRANS_COMMENTS      )                                        
MFA-TR*        VALUES                                                           
MFA-TR*          ( :4J-EQUIP-SEQ,           :4J-TRANS-HIST-SEQ-NO,              
MFA-TR*            :4J-EQUIP-TAG-NO,        :4J-APPL-PROGRAM-ID,                
MFA-TR*            :4J-TRANS-DATE,          :4J-SOURCE-APPL-CD,                 
MFA-TR*            :4J-SOURCE-APPL-REQ-NO,  :4J-WMS-POINT-NO,                   
MFA-TR*            :4J-INSTALL-LOC-NO,      :4J-INSTALL-POINT-NO,               
MFA-TR*            :4J-ACCOUNT-NO,          :4J-LAST-UPDATE-USERID,             
MFA-TR*            :4J-TRANS-COMMENTS  )                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE         
                                          WS-SQL-CODE                   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** INSERT ERROR IN 8400                **'       
              DISPLAY '** RETURN CODE = ' WS-SQL-CODE                   
              DISPLAY '** EQUIP-SEQ         = ' 4J-EQUIP-SEQ            
              DISPLAY '** TRANS-HIST-SEQ-NO = ' 4J-TRANS-HIST-SEQ-NO    
              DISPLAY '** INSTALL-LOC-NO    = ' 4J-INSTALL-LOC-NO       
              DISPLAY '** INSTALL-POINT-NO  = ' 4J-INSTALL-POINT-NO     
              DISPLAY '** PROCESSING TERMINATED               **'       
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * INSERT RECORD IN THE LMS TRANSACTION HISTORY DETAIL TABLE.  *           
      ***************************************************************           
       8500-INSERT-TRANS-HIST-DET.                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO LMS_TRANS_HIST_DET                           
               (                                                        
                 EQUIP_SEQ,         TRANS_HIST_SEQ_NO,                  
                 DETAIL_SEQ_NO,     COLUMN_DESC,                        
                 PRV_COLUMN_VALUE,  CHG_COLUMN_VALUE,                   
                 LAST_UPDATE_USERID  )                                  
               VALUES                                                   
               (                                                        
                 :4S-EQUIP-SEQ,         CIS.CHAR2TIMESTAMP(
                                                  :4S-TRANS-HIST-SEQ-NO
              ),          
                 :4S-DETAIL-SEQ-NO,     :4S-COLUMN-DESC,                
                 :4S-PRV-COLUMN-VALUE,  :4S-CHG-COLUMN-VALUE,           
                 :4S-LAST-UPDATE-USERID       )                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO LMS_TRANS_HIST_DET                                   
MFA-TR*        (                                                                
MFA-TR*          EQUIP_SEQ,         TRANS_HIST_SEQ_NO,                          
MFA-TR*          DETAIL_SEQ_NO,     COLUMN_DESC,                                
MFA-TR*          PRV_COLUMN_VALUE,  CHG_COLUMN_VALUE,                           
MFA-TR*          LAST_UPDATE_USERID  )                                          
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*          :4S-EQUIP-SEQ,         :4S-TRANS-HIST-SEQ-NO,                  
MFA-TR*          :4S-DETAIL-SEQ-NO,     :4S-COLUMN-DESC,                        
MFA-TR*          :4S-PRV-COLUMN-VALUE,  :4S-CHG-COLUMN-VALUE,                   
MFA-TR*          :4S-LAST-UPDATE-USERID       )                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE         
                                          WS-SQL-CODE                   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD +1                           TO 4S-DETAIL-SEQ-NO      
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** INSERT ERROR IN 8500                **'       
              DISPLAY '** RETURN CODE = ' WS-SQL-CODE                   
              DISPLAY '** EQUIP-SEQ         = ' 4S-EQUIP-SEQ            
              DISPLAY '** TRANS-HIST-SEQ-NO = ' 4S-TRANS-HIST-SEQ-NO    
              DISPLAY '** DETAIL_SEQ_NO     = ' 4S-DETAIL-SEQ-NO        
              DISPLAY '** COLUMN_DESC       = ' 4S-COLUMN-DESC          
              DISPLAY '** PROCESSING TERMINATED               **'       
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *WRITES THE RECORD IN THE ERROR  FILE                           **        
      ******************************************************************        
       8600-WRITE-ERROR-FILE.                                           
                                                                        
           WRITE FIOLE064-REC FROM WS-FLE64-REC.                        
           IF FLE64-SUCCESSFUL                                          
               ADD 1                   TO WS-FLE64-REC-CNTR             
           ELSE                                                         
               DISPLAY '**  PARA 8600-WRITE-ERROR-FILE          **'     
               DISPLAY '**  WRITE ERROR OF FCSLE01 - INPUT FILE **'     
               DISPLAY '**         FILE STATUS = ' WS-FLE64-STATUS      
               DISPLAY '**         PROCESSING TERMINATED        **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  9000-TERMINATE.                                             **        
      **       TERMINATION ROUTINE                                    **        
      **                                                              **        
      ******************************************************************        
       9000-TERMINATE.                                                  
                                                                        
           IF FLM64-SUCCESSFUL                                          
              CLOSE FCSLM064-FILE                                       
              IF FLM64-SUCCESSFUL                                       
                  CONTINUE                                              
              ELSE                                                      
                  DISPLAY '**  PARA 9000-TERMINATE                 **'  
                  DISPLAY '**  CLOSE ERROR OF FCSLM64 - INPUT FILE **'  
                  DISPLAY '**         FILE STATUS = ' WS-FLM64-STATUS   
                  DISPLAY '**         PROCESSING TERMINATED         **' 
                  PERFORM 9900-ABEND                THRU 9900-EXIT      
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF FLE64-SUCCESSFUL                                          
              CLOSE FCSLE064-FILE                                       
              IF FLE64-SUCCESSFUL                                       
                  CONTINUE                                              
              ELSE                                                      
                  DISPLAY '**  PARA 9000-TERMINATE                 **'  
                  DISPLAY '**  CLOSE ERROR OF FCSLE01 - INPUT FILE **'  
                  DISPLAY '**         FILE STATUS = ' WS-FLE64-STATUS   
                  DISPLAY '**         PROCESSING TERMINATED         **' 
                  PERFORM 9900-ABEND                THRU 9900-EXIT      
              END-IF                                                    
           END-IF.                                                      
                                                                        
           DISPLAY '********************************************'.      
           DISPLAY '** READ RECORDS FROM INPUT FILE:' WS-FLM64-REC-CNTR 
           DISPLAY '** GOOD RECORDS PROCESSED   :' WS-GOOD-REC-CNTR.    
           DISPLAY '** WRITTEN RECORDS INTO ERROR:' WS-FLE64-REC-CNTR.  
           DISPLAY '** INSERTED RECORDS IN TABLE:' WS-INSERT-REC-CNTR.  
           DISPLAY '*********************************************'.     
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
