       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSLM009.                                            
       DATE-WRITTEN. DEC-2015.                                          
       DATE-COMPILED.                                                   
                                                                        
      ***************************************************************** 00000600
      *                SOUTH CAROLINA ELECTRIC & GAS                    00000700
      *                                                                 00000800
      ***************************************************************** 00000900
      *                 P R O G R A M  S U M M A R Y                  * 00001000
      *                                                               * 00001100
      *  THIS PROGRAM WILL ROLL UP ROW ON THE CSS_CUST_PLAN TABLE.    * 00001200
      ***************************************************************** 00001300
      *                     PROGRAM MODIFICATION LOG                    00001400
      *                                                                 00001500
      *    DATE    INITIALS   COMMENTS                                  00001600
      *  --------  --------   --------------------------------------- * 00001700
      *  12/17/15  EM19682    INITIAL VERSION.                        * 00001800
      *  07/01/16  SV95326    MERGIE POLECORR EZTR LOGIC IN           * 00001900
      *                       2000-POLE-PROCESS-PARA .                * 00002000
A*5501*  09/09/16  AK7T405    ACT17062 - REMOVING LMS_CODE_VALUE AND  * 00002100
      *                       REPLACING WITH CSS_RATE_PLAN_DESC  TABLE* 00002200
      ***************************************************************** 00002300
      ***************************************************************** 00002400
      *                                                                 00002500
      *                ---- BASIC SEQUENCE STRUCTURE ----               00002600
      *                                                                 00002700
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION              00002800
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                     00002900
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                    00003000
      *  3000 - 4999  NOT USED                                          00003100
      *  5000 - 5999  COMMON PROGRAM MODULES                            00003200
      *  6000 - 6999  COMMON SYSTEM MODULES                             00003300
      *  7000 - 8999  INPUT/OUTPUT MODULES                              00003400
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES              00003500
      *                                                                 00003600
      ***************************************************************** 00003700
       ENVIRONMENT DIVISION.                                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSLM009'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)  VALUE               
           'WORKING STORAGE FOR PCSLM009 STARTS HERE'.                  
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-PGM-NAME               PIC X(08)   VALUE 'PCSLM009'.  
           05  WS-PGRMNAME               PIC X(10)   VALUE 'PCSLM009  '.
           05  WS-SYSTEM                 PIC X(07)   VALUE 'SYSTEM '.   
           05  WS-NO                     PIC X(01)   VALUE 'N'.         
           05  WS-Y                      PIC X(01)   VALUE 'Y'.         
           05  WS-N                      PIC X(01)   VALUE 'N'.         
           05  WS-I                      PIC X(01)   VALUE 'I'.         
                                                                        
       01  WS-MISC.                                                     
           05  WS-INSERT-REC-CNTR        PIC 9(08)   VALUE ZERO.        
           05  WS-SQL-CODE               PIC -9(9)   VALUE ZERO.        
           05  WS-ERROR-MSG              PIC X(38)   VALUE SPACES.      
           05  RS-RETURN-CODE            PIC S9(09)  COMP  VALUE +0.    
           05  EE-RETURN-CODE            PIC S9(09)  COMP  VALUE +0.    
           05  WS-CHKP-LUW-LIMIT         PIC 9(04)   VALUE ZERO.        
           05  WS-CHKP-UPD-LIMIT         PIC 9(04)   VALUE ZERO.        
           05  WS-DEFAULT-CHKP-LUW-LIMIT PIC 9(04)   VALUE 100.         
           05  WS-DEFAULT-CHKP-UPD-LIMIT PIC 9(04)   VALUE 100.         
           05  WS-DISPLAY-SQLCODE        PIC ---9.                      
           05  WS-CHKP-NO                PIC 9(06)   VALUE ZERO.        
                                                                        
       01  WS-VARIABLES.                                                
COB305     05 WS-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.      
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05  WS-IC-NO                  PIC S9(04)  USAGE COMP.        
           05  WS-CODE-UTIL-TYPE         PIC X(01)   VALUE SPACES.      
           05  WS-RATE-PLAN-NO           PIC X(03)   VALUE SPACES.      
           05  WS-RATE-ITEM-CODE         PIC S9(04)  USAGE COMP.        
           05  WS-CODE-PLAN-STATUS       PIC X(01)   VALUE SPACES.      
           05  WS-LAST-BILL-DATE         PIC X(10)   VALUE SPACES.      
           05  WS-NO-UNITS               PIC S9(09)  USAGE COMP.        
           05  WS-DATE-PLAN-START        PIC X(10)   VALUE SPACES.      
           05  WS-COUNT                  PIC S9(09)  COMP  VALUE +0.    
           05  WS-ITEM-SEQ-NO            PIC S9(04)  USAGE COMP.        
COB305     05 WS-INSTALL-POINT-NO        PIC S9(05)V USAGE COMP-3 
COB305       VALUE 0.      
           05  WS-BILLING-FL             PIC X(01)   VALUE SPACES.      
COB305     05 WS-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.      
           05  WS-COMPANY-NO             PIC X(02)   VALUE SPACES.      
           05  WS-RESP-AREA-ID           PIC X(03)   VALUE SPACES.      
           05  WS-TIMESTAMP              PIC X(26)   VALUE SPACES.      
           05  WS-NO-UNITS-C             PIC X(09)   VALUE SPACES.      
           05  WS-NO-UNITS-N REDEFINES WS-NO-UNITS-C                    
                                         PIC 9(09).                     
COB305     05 WS-PREV-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.      
           05  WS-4-DIGIT-FMT            PIC X(04)   VALUE SPACES.      
           05  WS-4-DIGIT-FMT-N REDEFINES WS-4-DIGIT-FMT                
                                         PIC 9(04).                     
           05  WS-PREMISE-NO-CHAR        PIC X(10)   VALUE SPACES.      
           05  WS-PREMISE-NO-NUM REDEFINES WS-PREMISE-NO-CHAR           
                                         PIC 9(10).                     
                                                                        
       01  WS-DATE-FIELDS.                                              
           05  WS-CURRENT-DATE           PIC X(10)   VALUE SPACES.      
           05  WS-DATE-LENGTH.                                          
               10  WS-LEN-SLASH          PIC 9(01)   VALUE 0.           
               10  WS-LEN-DATE           PIC 9(01)   VALUE 0.           
               10  WS-LEN-SPACE          PIC 9(01)   VALUE 0.           
                                                                        
       01  WS-SWITCH.                                                   
           05  WS-MORE-DATA-SW           PIC X(01)  VALUE 'Y'.          
               88 NO-MORE-DATA                      VALUE 'N'.          
           05  WS-VALIDATION-SW          PIC X(01)  VALUE 'N'.          
               88 INVALID-RECORD                    VALUE 'Y'.          
               88 VALID-RECORD                      VALUE 'N'.          
                                                                        
       01  WS-CNTRS.                                                    
           05  WS-ACCOUNTS-READ          PIC 9(07)  VALUE ZERO.         
           05  WS-ACCTS-UPDATED          PIC 9(07)  VALUE ZERO.         
           05  WS-COMMIT-ACCTS-CNT       PIC 9(07)  VALUE ZERO.         
      *                                                                 00011700
           COPY FIOCA00.                                                00011800
      ***************************************************************** 00011900
      * SQL COMMUNICATION AREA                                        * 00012000
      ***************************************************************** 00012100
           EXEC SQL                                                     00012200
                INCLUDE SQLCA                                           00012300
           END-EXEC.                                                    00012400
      *                                                                 00012500
      ***************************************************************** 00012600
      * CSS_ACCOUNT AT                                                * 00012700
      ***************************************************************** 00012800
           EXEC SQL                                                     00012900
                INCLUDE TBACCT                                          00013000
           END-EXEC.                                                    00013100
      *                                                                 00013200
      ***************************************************************** 00013300
      * CSS_UTIL_ENVRNMT  UT                                          * 00013400
      ***************************************************************** 00013500
           EXEC SQL                                                     00013600
                INCLUDE TBUTLENV                                        00013700
           END-EXEC.                                                    00013800
      *                                                                 00013900
      ***************************************************************** 00014000
      * CSS_CUST_PLAN  CP                                             * 00014100
      ***************************************************************** 00014200
           EXEC SQL                                                     00014300
                INCLUDE TBCSTPLN                                        00014400
           END-EXEC.                                                    00014500
      *                                                                 00014600
      ***************************************************************** 00014700
      * LMS_CODE_DESC  U3                                             * 00014800
      ***************************************************************** 00014900
           EXEC SQL                                                     00015000
                INCLUDE TBLMCODE                                        00015100
           END-EXEC.                                                    00015200
      *                                                                 00015300
      ***************************************************************** 00015400
      * LMS_EQUIP_ENVRNMT  4F                                         * 00015500
      ***************************************************************** 00015600
           EXEC SQL                                                     00015700
                INCLUDE TBEQPIVT                                        00015800
           END-EXEC.                                                    00015900
      *                                                                 00016000
      ***************************************************************** 00016100
      * CSS_MNT_TRANS_HIST  MH                                        * 00016200
      ***************************************************************** 00016300
           EXEC SQL                                                     00016400
                INCLUDE TBMNHIST                                        00016500
           END-EXEC.                                                    00016600
      *                                                                 00016700
      ***************************************************************** 00016800
      * CSS_MT_TRN_HST_DET  MI                                        * 00016900
      ***************************************************************** 00017000
           EXEC SQL                                                     00017100
                INCLUDE TBMNHDT                                         00017200
           END-EXEC.                                                    00017300
      *                                                                 00017400
      *************************************************************     00017500
      *    CSS_JOB_PARM                                                 00017600
      *************************************************************     00017700
           EXEC SQL                                                     00017800
                INCLUDE TBJBPARM                                        00017900
           END-EXEC.                                                    00018000
      *                                                                 00018100
      ***************************************************************** 00018200
      * CSS_RESTART                                                   * 00018300
      ***************************************************************** 00018400
           EXEC SQL                                                     00018500
                INCLUDE TBRESTRT                                        00018600
           END-EXEC.                                                    00018700
      *                                                                 00018800
      ***************************************************************** 00018900
      * LMS_EQUIP_INVENTRY                                            * 00019000
      ***************************************************************** 00019100
           EXEC SQL                                                     00019200
                INCLUDE TBEQPINV                                        00019300
           END-EXEC.                                                    00019400
      *                                                                 00019500
      ***************************************************************** 00019600
      * LMS_FXTR_ATTACHMTS                                            * 00019700
      ***************************************************************** 00019800
           EXEC SQL                                                     00019900
                INCLUDE TBFXTATC                                        00020000
           END-EXEC.                                                    00020100
      *                                                                 00020200
      ***************************************************************** 00020300
      * LMS_TRANS_HIST                                                * 00020400
      ***************************************************************** 00020500
           EXEC SQL                                                     00020600
                INCLUDE TBLGTHST                                        00020700
           END-EXEC.                                                    00020800
      *                                                                 00020900
      ***************************************************************** 00021000
      * LMS_TRANS_HIST_DET                                            * 00021100
      ***************************************************************** 00021200
           EXEC SQL                                                     00021300
                INCLUDE TBLMSHST                                        00021400
           END-EXEC.                                                    00021500
      *                                                                 00021600
      ***************************************************************** 00021700
      * WORKING STORAGE COPY BOOK FOR CPDCA099                        * 00021800
      ***************************************************************** 00021900
           EXEC SQL                                                     00022000
                INCLUDE CWS00099                                        00022100
           END-EXEC.                                                    00022200
      *                                                                 00022300
           EXEC SQL                                                     00022400
                INCLUDE CWS00039                                        00022500
           END-EXEC.                                                    00022600
      *                                                                 00022700
      ***************************************************************** 00022800
      *   WS-VARIABLES FOR CPD00038                                   * 00022900
      ***************************************************************** 00023000
       COPY CWS00038.                                                   00023100
       COPY FIOJC01.                                                    00023200
      *                                                                 00023300
       COPY CWS09900.                                                   00023400
      *                                                                 00023500
       COPY CWS00303.                                                   00023600
      *                                                                 00023700
       COPY CWS00010.                                                   00023800
      *                                                                 00023900
      ***************************************************************** 00024000
      * CURSOR DECLARATION FOR CSS_CUST_PLAN                          * 00024100
      ***************************************************************** 00024200
           EXEC SQL                                                     
              DECLARE MAIN_CUR CURSOR WITH HOLD FOR                     
              SELECT  UT.PREMISE_NO                                     
                     ,UT.ACCOUNT_NO                                     
                     ,UT.IC_NO                                          
                     ,UT.CODE_UTIL_TYPE                                 
                     ,UT.RATE_PLAN_NO                                   
                     ,AT.CUSTOMER_NO                                    
                     ,CP.RATE_ITEM_CODE                                 
                     ,CP.CODE_PLAN_STATUS                               
                     ,CP.LAST_BILL_DATE                                 
                     ,SUM(CP.NO_UNITS)                                  
                     ,MIN(CP.DATE_PLAN_START)                           
                     ,COUNT(*)                                          
                FROM  CSS_ACCOUNT         AT WITH(READUNCOMMITTED)              
                     ,CSS_UTIL_ENVRNMT    UT WITH(READUNCOMMITTED)              
                     ,CSS_CUST_PLAN       CP WITH(READUNCOMMITTED)              
A17062               ,CSS_RATE_PLAN_DESC  RD WITH(READUNCOMMITTED)              
               WHERE  AT.ACCOUNT_NO        =  UT.ACCOUNT_NO             
                 AND  AT.ACCOUNT_NO        =  CP.ACCOUNT_NO             
                 AND  AT.PREMISE_NO        =  UT.PREMISE_NO             
                 AND  AT.COMPANY_NO        =  UT.COMPANY_NO             
A17062           AND  AT.COMPANY_NO        =  RD.COMPANY_NO             
                 AND  AT.COMPANY_NO        =  '01'                      
                 AND  AT.CODE_ACCT_BILLED  <> 'X'                       
                 AND  UT.CODE_UTIL_TYPE    =  CP.CODE_UTIL_TYPE         
A17062           AND  RD.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE         
                 AND  UT.IC_NO             =  CP.IC_NO                  
                 AND  CP.CODE_PLAN_STATUS IN ('A','I')                  
                 AND  CP.LAST_BILL_DATE   IS NOT NULL                   
                 AND  CP.NO_UNITS          >  0                         
A17062           AND  RD.LMS_RATE_FL               = 'Y'                
A17062           AND  RD.RATE_PLAN_NO              = UT.RATE_PLAN_NO    
A17062           AND  RD.LMS_RATE_TYPE_CD          = 'P'                
              GROUP BY UT.PREMISE_NO, UT.ACCOUNT_NO, UT.IC_NO,          
                       UT.CODE_UTIL_TYPE, UT.RATE_PLAN_NO,              
                       AT.CUSTOMER_NO,                                  
                       CP.RATE_ITEM_CODE, CP.CODE_PLAN_STATUS,          
                       CP.LAST_BILL_DATE                                
              HAVING COUNT(*) >= 2                                      
              ORDER BY UT.PREMISE_NO, UT.ACCOUNT_NO, UT.IC_NO,          
                       UT.CODE_UTIL_TYPE, UT.RATE_PLAN_NO,              
                       AT.CUSTOMER_NO,                                  
                       CP.RATE_ITEM_CODE, CP.CODE_PLAN_STATUS,          
                       CP.LAST_BILL_DATE                                
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00024300
MFA-TR*       DECLARE MAIN_CUR CURSOR WITH HOLD FOR                     00024400
MFA-TR*       SELECT  UT.PREMISE_NO                                     00024500
MFA-TR*              ,UT.ACCOUNT_NO                                     00024600
MFA-TR*              ,UT.IC_NO                                          00024700
MFA-TR*              ,UT.CODE_UTIL_TYPE                                 00024800
MFA-TR*              ,UT.RATE_PLAN_NO                                   00024900
MFA-TR*              ,AT.CUSTOMER_NO                                    00025000
MFA-TR*              ,CP.RATE_ITEM_CODE                                 00025100
MFA-TR*              ,CP.CODE_PLAN_STATUS                               00025200
MFA-TR*              ,CP.LAST_BILL_DATE                                 00025300
MFA-TR*              ,SUM(CP.NO_UNITS)                                  00025400
MFA-TR*              ,MIN(CP.DATE_PLAN_START)                           00025500
MFA-TR*              ,COUNT(*)                                          00025600
MFA-TR*         FROM  CSS_ACCOUNT         AT                            00025700
MFA-TR*              ,CSS_UTIL_ENVRNMT    UT                            00025800
MFA-TR*              ,CSS_CUST_PLAN       CP                            00025900
MFA-TR*              ,CSS_RATE_PLAN_DESC  RD                            00026000
MFA-TR*        WHERE  AT.ACCOUNT_NO        =  UT.ACCOUNT_NO             00026100
MFA-TR*          AND  AT.ACCOUNT_NO        =  CP.ACCOUNT_NO             00026200
MFA-TR*          AND  AT.PREMISE_NO        =  UT.PREMISE_NO             00026300
MFA-TR*          AND  AT.COMPANY_NO        =  UT.COMPANY_NO             00026400
MFA-TR*          AND  AT.COMPANY_NO        =  RD.COMPANY_NO             00026500
MFA-TR*          AND  AT.COMPANY_NO        =  '01'                      00026600
MFA-TR*          AND  AT.CODE_ACCT_BILLED  <> 'X'                       00026700
MFA-TR*          AND  UT.CODE_UTIL_TYPE    =  CP.CODE_UTIL_TYPE         00026800
MFA-TR*          AND  RD.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE         00026900
MFA-TR*          AND  UT.IC_NO             =  CP.IC_NO                  00027000
MFA-TR*          AND  CP.CODE_PLAN_STATUS IN ('A','I')                  00027100
MFA-TR*          AND  CP.LAST_BILL_DATE   IS NOT NULL                   00027200
MFA-TR*          AND  CP.NO_UNITS          >  0                         00027300
MFA-TR*          AND  RD.LMS_RATE_FL               = 'Y'                00027400
MFA-TR*          AND  RD.RATE_PLAN_NO              = UT.RATE_PLAN_NO    00027500
MFA-TR*          AND  RD.LMS_RATE_TYPE_CD          = 'P'                00027600
MFA-TR*       GROUP BY UT.PREMISE_NO, UT.ACCOUNT_NO, UT.IC_NO,          00027700
MFA-TR*                UT.CODE_UTIL_TYPE, UT.RATE_PLAN_NO,              00027800
MFA-TR*                AT.CUSTOMER_NO,                                  00027900
MFA-TR*                CP.RATE_ITEM_CODE, CP.CODE_PLAN_STATUS,          00028000
MFA-TR*                CP.LAST_BILL_DATE                                00028100
MFA-TR*       HAVING COUNT(*) >= 2                                      00028200
MFA-TR*       ORDER BY UT.PREMISE_NO, UT.ACCOUNT_NO, UT.IC_NO,          00028300
MFA-TR*                UT.CODE_UTIL_TYPE, UT.RATE_PLAN_NO,              00028400
MFA-TR*                AT.CUSTOMER_NO,                                  00028500
MFA-TR*                CP.RATE_ITEM_CODE, CP.CODE_PLAN_STATUS,          00028600
MFA-TR*                CP.LAST_BILL_DATE                                00028700
MFA-TR*       FOR FETCH ONLY WITH UR                                    00028800
MFA-TR*       QUERYNO 7200                                              00028900
MFA-TR*    END-EXEC.                                                    00029000
      *                                                                 00029100
      ***************************************************************** 00029200
      * CURSOR DECLARATION FOR CSS_CUST_PLAN FOR REMOVAL              * 00029300
      ***************************************************************** 00029400
           EXEC SQL                                                     
              DECLARE MAIN_CUR_REMOVE CURSOR WITH HOLD FOR              
              SELECT  UT.PREMISE_NO                                     
                     ,UT.ACCOUNT_NO                                     
                     ,UT.IC_NO                                          
                     ,UT.CODE_UTIL_TYPE                                 
                     ,UT.RATE_PLAN_NO                                   
                     ,AT.CUSTOMER_NO                                    
                     ,CP.RATE_ITEM_CODE                                 
                     ,CP.CODE_PLAN_STATUS                               
                     ,MAX(CP.LAST_BILL_DATE)                            
                     ,SUM(CP.NO_UNITS)                                  
                     ,MIN(CP.DATE_PLAN_START)                           
                     ,COUNT(*)                                          
                FROM  CSS_ACCOUNT         AT WITH(READUNCOMMITTED)              
                     ,CSS_UTIL_ENVRNMT    UT WITH(READUNCOMMITTED)              
                     ,CSS_CUST_PLAN       CP WITH(READUNCOMMITTED)              
A17062               ,CSS_RATE_PLAN_DESC  RD WITH(READUNCOMMITTED)              
               WHERE  AT.ACCOUNT_NO        =  UT.ACCOUNT_NO             
                 AND  AT.ACCOUNT_NO        =  CP.ACCOUNT_NO             
                 AND  AT.PREMISE_NO        =  UT.PREMISE_NO             
                 AND  AT.COMPANY_NO        =  UT.COMPANY_NO             
A17062           AND  AT.COMPANY_NO        =  RD.COMPANY_NO             
                 AND  AT.COMPANY_NO        =  '01'                      
                 AND  AT.CODE_ACCT_BILLED  <> 'X'                       
                 AND  UT.CODE_UTIL_TYPE    =  CP.CODE_UTIL_TYPE         
A17062           AND  RD.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE         
                 AND  UT.IC_NO             =  CP.IC_NO                  
                 AND  CP.CODE_PLAN_STATUS  = 'R'                        
                 AND  CP.LAST_BILL_DATE   IS NOT NULL                   
                 AND  CP.LAST_BILL_DATE   < DATEADD( MONTH, -6, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )     
                 AND  CP.NO_UNITS          >  0                         
A17062           AND  RD.LMS_RATE_FL       = 'Y'                        
A17062           AND  RD.RATE_PLAN_NO      = UT.RATE_PLAN_NO            
A17062           AND  RD.LMS_RATE_TYPE_CD  = 'P'                        
              GROUP BY UT.PREMISE_NO, UT.ACCOUNT_NO, UT.IC_NO,          
                       UT.CODE_UTIL_TYPE, UT.RATE_PLAN_NO,              
                       AT.CUSTOMER_NO,                                  
                       CP.RATE_ITEM_CODE, CP.CODE_PLAN_STATUS           
              HAVING COUNT(*) >= 2                                      
              ORDER BY UT.PREMISE_NO, UT.ACCOUNT_NO, UT.IC_NO,          
                       UT.CODE_UTIL_TYPE, UT.RATE_PLAN_NO,              
                       AT.CUSTOMER_NO,                                  
                       CP.RATE_ITEM_CODE, CP.CODE_PLAN_STATUS           
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     00029500
MFA-TR*       DECLARE MAIN_CUR_REMOVE CURSOR WITH HOLD FOR              00029600
MFA-TR*       SELECT  UT.PREMISE_NO                                     00029700
MFA-TR*              ,UT.ACCOUNT_NO                                     00029800
MFA-TR*              ,UT.IC_NO                                          00029900
MFA-TR*              ,UT.CODE_UTIL_TYPE                                 00030000
MFA-TR*              ,UT.RATE_PLAN_NO                                   00030100
MFA-TR*              ,AT.CUSTOMER_NO                                    00030200
MFA-TR*              ,CP.RATE_ITEM_CODE                                 00030300
MFA-TR*              ,CP.CODE_PLAN_STATUS                               00030400
MFA-TR*              ,MAX(CP.LAST_BILL_DATE)                            00030500
MFA-TR*              ,SUM(CP.NO_UNITS)                                  00030600
MFA-TR*              ,MIN(CP.DATE_PLAN_START)                           00030700
MFA-TR*              ,COUNT(*)                                          00030800
MFA-TR*         FROM  CSS_ACCOUNT         AT                            00030900
MFA-TR*              ,CSS_UTIL_ENVRNMT    UT                            00031000
MFA-TR*              ,CSS_CUST_PLAN       CP                            00031100
MFA-TR*              ,CSS_RATE_PLAN_DESC  RD                            00031200
MFA-TR*        WHERE  AT.ACCOUNT_NO        =  UT.ACCOUNT_NO             00031300
MFA-TR*          AND  AT.ACCOUNT_NO        =  CP.ACCOUNT_NO             00031400
MFA-TR*          AND  AT.PREMISE_NO        =  UT.PREMISE_NO             00031500
MFA-TR*          AND  AT.COMPANY_NO        =  UT.COMPANY_NO             00031600
MFA-TR*          AND  AT.COMPANY_NO        =  RD.COMPANY_NO             00031700
MFA-TR*          AND  AT.COMPANY_NO        =  '01'                      00031800
MFA-TR*          AND  AT.CODE_ACCT_BILLED  <> 'X'                       00031900
MFA-TR*          AND  UT.CODE_UTIL_TYPE    =  CP.CODE_UTIL_TYPE         00032000
MFA-TR*          AND  RD.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE         00032100
MFA-TR*          AND  UT.IC_NO             =  CP.IC_NO                  00032200
MFA-TR*          AND  CP.CODE_PLAN_STATUS  = 'R'                        00032300
MFA-TR*          AND  CP.LAST_BILL_DATE   IS NOT NULL                   00032400
MFA-TR*          AND  CP.LAST_BILL_DATE   < CURRENT DATE - 6 MONTHS     00032500
MFA-TR*          AND  CP.NO_UNITS          >  0                         00032600
MFA-TR*          AND  RD.LMS_RATE_FL       = 'Y'                        00032700
MFA-TR*          AND  RD.RATE_PLAN_NO      = UT.RATE_PLAN_NO            00032800
MFA-TR*          AND  RD.LMS_RATE_TYPE_CD  = 'P'                        00032900
MFA-TR*       GROUP BY UT.PREMISE_NO, UT.ACCOUNT_NO, UT.IC_NO,          00033000
MFA-TR*                UT.CODE_UTIL_TYPE, UT.RATE_PLAN_NO,              00033100
MFA-TR*                AT.CUSTOMER_NO,                                  00033200
MFA-TR*                CP.RATE_ITEM_CODE, CP.CODE_PLAN_STATUS           00033300
MFA-TR*       HAVING COUNT(*) >= 2                                      00033400
MFA-TR*       ORDER BY UT.PREMISE_NO, UT.ACCOUNT_NO, UT.IC_NO,          00033500
MFA-TR*                UT.CODE_UTIL_TYPE, UT.RATE_PLAN_NO,              00033600
MFA-TR*                AT.CUSTOMER_NO,                                  00033700
MFA-TR*                CP.RATE_ITEM_CODE, CP.CODE_PLAN_STATUS           00033800
MFA-TR*       FOR FETCH ONLY WITH UR                                    00033900
MFA-TR*       QUERYNO 8200                                              00034000
MFA-TR*    END-EXEC.                                                    00034100
      *                                                                 00034200
      ***************************************************************** 00034300
      * CURSOR DECLARATION FOR POLE                                   * 00034400
      ***************************************************************** 00034500
           EXEC SQL                                                     
              DECLARE GET_POLE_CUR CURSOR WITH HOLD FOR                 
              SELECT [4D].EQUIP_SEQ                                       
                    ,[4D].EQUIP_TAG_NO                                    
                    ,[4F].INSTALL_LOC_NO                                  
                    ,[4F].INSTALL_POINT_NO                                
                    ,[4F].CODE_UTIL_TYPE                                  
                    ,[4F].IC_NO                                           
                    ,[4F].RATE_PLAN_NO                                    
                    ,[4F].RATE_ITEM_CODE                                  
                    ,[4F].ITEM_SEQ_NO                                     
              FROM   LMS_EQUIP_INVENTRY  [4D] WITH(READUNCOMMITTED)             
                    ,LMS_EQUIP_ENVRNMT   [4F] WITH(READUNCOMMITTED)             
              WHERE  [4D].EQUIP_SEQ          =  [4F].EQUIP_SEQ              
                AND  [4D].EQUIP_TYPE_CD      = 'P'                        
                AND  [4D].INVENTRY_STATUS_CD = 'J'                        
                AND  [4F].INSTALL_LOC_CD     = 'P'                        
                AND  [4F].BILLING_FL         = 'N'                        
                AND  [4F].NO_BILL_REASON_CD  IN ('CR','CO','SO')          
                AND  [4F].RATE_PLAN_NO       > ' '                        
                AND  [4F].RATE_ITEM_CODE     >  0                         
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                     00034600
MFA-TR*       DECLARE GET_POLE_CUR CURSOR WITH HOLD FOR                 00034700
MFA-TR*       SELECT 4D.EQUIP_SEQ                                       00034800
MFA-TR*             ,4D.EQUIP_TAG_NO                                    00034900
MFA-TR*             ,4F.INSTALL_LOC_NO                                  00035000
MFA-TR*             ,4F.INSTALL_POINT_NO                                00035100
MFA-TR*             ,4F.CODE_UTIL_TYPE                                  00035200
MFA-TR*             ,4F.IC_NO                                           00035300
MFA-TR*             ,4F.RATE_PLAN_NO                                    00035400
MFA-TR*             ,4F.RATE_ITEM_CODE                                  00035500
MFA-TR*             ,4F.ITEM_SEQ_NO                                     00035600
MFA-TR*       FROM   LMS_EQUIP_INVENTRY  4D                             00035700
MFA-TR*             ,LMS_EQUIP_ENVRNMT   4F                             00035800
MFA-TR*       WHERE  4D.EQUIP_SEQ          =  4F.EQUIP_SEQ              00035900
MFA-TR*         AND  4D.EQUIP_TYPE_CD      = 'P'                        00036000
MFA-TR*         AND  4D.INVENTRY_STATUS_CD = 'J'                        00036100
MFA-TR*         AND  4F.INSTALL_LOC_CD     = 'P'                        00036200
MFA-TR*         AND  4F.BILLING_FL         = 'N'                        00036300
MFA-TR*         AND  4F.NO_BILL_REASON_CD  IN ('CR','CO','SO')          00036400
MFA-TR*         AND  4F.RATE_PLAN_NO       > ' '                        00036500
MFA-TR*         AND  4F.RATE_ITEM_CODE     >  0                         00036600
MFA-TR*         FOR FETCH ONLY WITH UR                                  00036700
MFA-TR*         QUERYNO 7800                                            00036800
MFA-TR*    END-EXEC.                                                    00036900
      *                                                                 00037000
      ***************************************************************** 00037100
      * CURSOR DECLARATION FOR FIXTURE                                * 00037200
      ***************************************************************** 00037300
           EXEC SQL                                                     
               DECLARE GET_FXTR_CUR CURSOR WITH HOLD FOR                
                SELECT [4F].EQUIP_SEQ                                     
                      ,[4D].EQUIP_TAG_NO                                  
                      ,[4F].INSTALL_POINT_NO                              
                FROM   LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)            
                      ,LMS_EQUIP_ENVRNMT  [4F] WITH(READUNCOMMITTED)            
                      ,LMS_FXTR_ATTACHMTS [4H] WITH(READUNCOMMITTED)            
                WHERE [4D].EQUIP_SEQ        = [4F].EQUIP_SEQ                
                  AND [4D].EQUIP_TYPE_CD    = 'F'                         
                  AND [4F].INSTALL_LOC_NO   = :4F-INSTALL-LOC-NO          
                  AND [4H].ATTACH_EQUIP_SEQ = :4D-EQUIP-SEQ               
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                     00037400
MFA-TR*        DECLARE GET_FXTR_CUR CURSOR WITH HOLD FOR                00037500
MFA-TR*         SELECT 4F.EQUIP_SEQ                                     00037600
MFA-TR*               ,4D.EQUIP_TAG_NO                                  00037700
MFA-TR*               ,4F.INSTALL_POINT_NO                              00037800
MFA-TR*         FROM   LMS_EQUIP_INVENTRY 4D                            00037900
MFA-TR*               ,LMS_EQUIP_ENVRNMT  4F                            00038000
MFA-TR*               ,LMS_FXTR_ATTACHMTS 4H                            00038100
MFA-TR*         WHERE 4D.EQUIP_SEQ        = 4F.EQUIP_SEQ                00038200
MFA-TR*           AND 4D.EQUIP_TYPE_CD    = 'F'                         00038300
MFA-TR*           AND 4F.INSTALL_LOC_NO   = :4F-INSTALL-LOC-NO          00038400
MFA-TR*           AND 4H.ATTACH_EQUIP_SEQ = :4D-EQUIP-SEQ               00038500
MFA-TR*         FOR FETCH ONLY WITH UR                                  00038600
MFA-TR*         QUERYNO 7850                                            00038700
MFA-TR*    END-EXEC.                                                    00038800
      *                                                                 00038900
                                                                        
       01  WS-END                        PIC X(40)  VALUE               
             'WORKING STORAGE FOR PCSLM009 ENDS HERE  '.                
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
      *************************************************************     00039800
      ** ROLL UP CUSTOMER PLAN TABLE AND UPDATE LMS EQUIP ENVRNMT**     00039900
      *************************************************************     00040000
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
                                                                        
           PERFORM 1000-MAIN-PROCESS-PARA  THRU 1000-EXIT               
             UNTIL RS-RETURN-CODE = NOT-FOUND.                          
                                                                        
           PERFORM 7275-CLOSE-MAIN-CURSOR  THRU 7275-EXIT.              
                                                                        
      *************************************************************     00040800
      ** DELETE THE CUST PLAN CONSOLIDATION REMOVE STATUS ROWS   **     00040900
      *************************************************************     00041000
           PERFORM 0200-INITIAL-REMOVE     THRU 0200-EXIT.              
                                                                        
           PERFORM 1500-MAIN-REMOVE-PARA   THRU 1500-EXIT               
             UNTIL RS-RETURN-CODE = NOT-FOUND.                          
                                                                        
           PERFORM 8275-CLOSE-REMOVE-CURSOR THRU 8275-EXIT.             
           PERFORM 2000-POLE-PROCESS-PARA   THRU 2000-EXIT.             
                                                                        
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************       00042600
      **    0100-INITIALIZATION.                               **       00042700
      **        INITIALIZATION ROUTINE                         **       00042800
      ***********************************************************       00042900
       0100-INITIALIZATION.                                             
                                                                        
           MOVE ZEROES                     TO WS-CPD99-PREMISE-NO       
                                              WS-CPD99-ACCOUNT-NO       
                                              WS-PREV-ACCOUNT-NO        
                                              WS-CHKP-NO.               
                                                                        
           PERFORM 7100-GET-CURRENT-DATE   THRU 7100-EXIT.              
                                                                        
           PERFORM 7200-OPEN-MAIN-CURSOR   THRU 7200-EXIT.              
           PERFORM 7250-FETCH-MAIN-CURSOR  THRU 7250-EXIT.              
                                                                        
           PERFORM 6251-GET-FJC01-DATE     THRU 6251-EXIT.              
                                                                        
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                           THRU 6240-EXIT               
               MOVE WS-FCA00-COMMON-DATE   TO WS-INPUT-DATE             
           END-IF.                                                      
                                                                        
           PERFORM 6253-GET-FJC01-CHKP-LIMIT   THRU 6253-EXIT.          
      *                                                                 00045100
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00045400
      ***********************************************************       00045500
      **    0200-INITIAL-REMOVE.                               **       00045600
      **        INITIALIZATION ROUTINE FOR REMOVAL             **       00045700
      ***********************************************************       00045800
       0200-INITIAL-REMOVE.                                             
                                                                        
           MOVE ZEROES                     TO WS-CPD99-PREMISE-NO       
                                              WS-CPD99-ACCOUNT-NO       
                                              WS-PREV-ACCOUNT-NO.       
                                                                        
           PERFORM 8200-OPEN-REMOVE-CURSOR THRU 8200-EXIT.              
           PERFORM 8250-FETCH-REMOVE-CURSOR THRU 8250-EXIT.             
      *                                                                 00046700
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00047000
      *************************************************************     00047100
      **      1000-MAIN-PROCESS-PARA                             **     00047200
      **           MAIN PROCESS                                  **     00047300
      *************************************************************     00047400
       1000-MAIN-PROCESS-PARA.                                          
                                                                        
      * GET COUNT / FIND OLDEST DATE_PLAN_START FROM CSS_CUST_PLAN      00047700
      * GET ITEM_SEQ_NO FROM OLDEST ROW ON CSS_CUST_PLAN                00047800
      * UPDATE NO_UNITS ON CSS_CUST_PLAN WITH THE SUM ON OLDEST ROW     00047900
      * PROCESS TO DELETE REMAINING ROWS ON CSS_CUST_PLAN               00048000
      *   - DELETE WHERE DATE_PLAN_START NOT = OLDEST                   00048100
      * PROCESS TO UPDATE ITEM_SEQ_NO ON LMS_EQUIP_ENVRNMT              00048200
                                                                        
           MOVE WS-PREMISE-NO              TO WS-CPD99-PREMISE-NO.      
           PERFORM 6990-FETCH-CUR-ACCOUNT  THRU 6990-EXIT.              
                                                                        
           IF (WS-CPD99-ACCOUNT-NO NOT EQUAL WS-ACCOUNT-NO)             
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 7300-GET-ITEM-SEQ-NO     THRU 7300-EXIT           
                                                                        
              IF WS-CODE-PLAN-STATUS = ('A' OR 'I')                     
                 PERFORM 5500-UPDATE-EQUIP-ENV THRU 5500-EXIT           
              END-IF                                                    
                                                                        
              PERFORM 7400-UPDATE-CUST-PLAN    THRU 7400-EXIT           
              PERFORM 7500-DELETE-CUST-PLAN    THRU 7500-EXIT           
              PERFORM 7700-PROCESS-TRANS-HIST  THRU 7700-EXIT           
           END-IF.                                                      
                                                                        
           MOVE ZEROES                     TO WS-CPD99-PREMISE-NO       
                                              WS-CPD99-ACCOUNT-NO.      
                                                                        
           IF WS-ACCOUNT-NO NOT = WS-PREV-ACCOUNT-NO                    
              MOVE WS-ACCOUNT-NO           TO WS-PREV-ACCOUNT-NO        
              PERFORM 8900-ISSUE-COMMIT    THRU 8900-EXIT               
           END-IF.                                                      
                                                                        
           PERFORM 7250-FETCH-MAIN-CURSOR  THRU 7250-EXIT.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00051300
      *************************************************************     00051400
      **      1500-MAIN-REMOVE-PARA                              **     00051500
      **           MAIN REMOVE PROCESS                           **     00051600
      *************************************************************     00051700
       1500-MAIN-REMOVE-PARA.                                           
                                                                        
           MOVE WS-PREMISE-NO              TO WS-CPD99-PREMISE-NO.      
           PERFORM 6990-FETCH-CUR-ACCOUNT  THRU 6990-EXIT.              
                                                                        
           IF (WS-CPD99-ACCOUNT-NO NOT EQUAL WS-ACCOUNT-NO)             
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 8300-GET-ITEM-SEQ-NO     THRU 8300-EXIT           
              PERFORM 8400-UPDATE-CUST-PLAN    THRU 8400-EXIT           
              PERFORM 8500-DELETE-CUST-PLAN    THRU 8500-EXIT           
              PERFORM 7700-PROCESS-TRANS-HIST  THRU 7700-EXIT           
           END-IF.                                                      
                                                                        
           MOVE ZEROES                     TO WS-CPD99-PREMISE-NO       
                                              WS-CPD99-ACCOUNT-NO.      
                                                                        
           IF WS-ACCOUNT-NO NOT = WS-PREV-ACCOUNT-NO                    
              MOVE WS-ACCOUNT-NO           TO WS-PREV-ACCOUNT-NO        
              PERFORM 8900-ISSUE-COMMIT    THRU 8900-EXIT               
           END-IF.                                                      
                                                                        
           PERFORM 8250-FETCH-REMOVE-CURSOR THRU 8250-EXIT.             
                                                                        
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00054400
      *************************************************************     00054500
      **      2000-POLE-PROCESS-PARA                             **     00054600
      *************************************************************     00054700
       2000-POLE-PROCESS-PARA.                                          
                                                                        
           PERFORM 7800-OPEN-POLE-CURSOR   THRU 7800-EXIT.              
           PERFORM 7810-FETCH-POLE-CURSOR  THRU 7810-EXIT.              
           PERFORM 2100-PROCESS-FXTR-CUST-PLAN  THRU 2100-EXIT          
               UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.             
           PERFORM 7820-CLOSE-POLE-CURSOR  THRU 7820-EXIT.              
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00055800
      *************************************************************     00055900
      **      2100-PROCESS-FXTR-CUST-PLAN                        **     00056000
      *************************************************************     00056100
       2100-PROCESS-FXTR-CUST-PLAN.                                     
                                                                        
           PERFORM 7850-OPEN-FXTR-CURSOR   THRU 7850-EXIT.              
           PERFORM 7860-FETCH-FXTR-CURSOR  THRU 7860-EXIT.              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 4F-INSTALL-LOC-NO          TO WS-PREMISE-NO-CHAR     
              MOVE WS-PREMISE-NO-NUM          TO WS-CPD99-PREMISE-NO    
              PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT             
              MOVE WS-CPD99-ACCOUNT-NO    TO CP-ACCOUNT-NO              
              MOVE 4F-CODE-UTIL-TYPE      TO CP-CODE-UTIL-TYPE          
              MOVE 4F-IC-NO               TO CP-IC-NO                   
              MOVE 4F-RATE-ITEM-CODE      TO CP-RATE-ITEM-CODE          
              MOVE 4F-ITEM-SEQ-NO         TO CP-ITEM-SEQ-NO             
              PERFORM 7840-GET-CUST-PLAN  THRU 7840-EXIT                
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 8010-UPDATE-CUST-PLAN     THRU 8010-EXIT       
                 PERFORM 8020-UPDATE-EQUIP-ENVRNMT THRU 8020-EXIT       
                 PERFORM 7710-CUST-PLAN-TRANS-HIST THRU 7710-EXIT       
                 PERFORM 7770-LMS-TRANS-HISTORY    THRU 7770-EXIT       
              END-IF                                                    
              PERFORM 7860-FETCH-FXTR-CURSOR  THRU 7860-EXIT            
           END-IF                                                       
           PERFORM 7870-CLOSE-FXTR-CURSOR  THRU 7870-EXIT.              
           PERFORM 7810-FETCH-POLE-CURSOR  THRU 7810-EXIT.              
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00058900
      ******************************************************************00059000
      * 5500-UPDATE-EQUIP-ENV                                          *00059100
      ******************************************************************00059200
       5500-UPDATE-EQUIP-ENV.                                           
                                                                        
           MOVE 'N'                        TO WS-BILLING-FL.            
           IF WS-CODE-PLAN-STATUS = 'A'                                 
              MOVE 'Y'                     TO WS-BILLING-FL             
           END-IF.                                                      
                                                                        
           PERFORM 7601-UPDATE-EQUIP-ENV   THRU 7601-EXIT.              
                                                                        
      *                                                                 00060200
       5500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00060500
      ***************************************************************** 00060600
      * 6240-GET-FCA00-COMMON-DATE                                    * 00060700
      ***************************************************************** 00060800
           COPY CPD00040.                                               00060900
      *                                                                 00061000
      ***************************************************************** 00061100
      * 6235-GET-FJC01-RESTART-REQ.                                   * 00061200
      ***************************************************************** 00061300
      *    EXEC SQL                                                     00061400
      *      INCLUDE CPD00035                                           00061500
      *    END-EXEC.                                                    00061600
      *                                                                 00061700
           EXEC SQL                                                     00061800
             INCLUDE CPD00038                                           00061900
           END-EXEC.                                                    00062000
      *                                                                 00062100
           EXEC SQL                                                     00062200
             INCLUDE CPD00039                                           00062300
           END-EXEC.                                                    00062400
      *                                                                 00062500
      ***************************************************************** 00062600
      * 6251-GET-FJC01-DATE                                           * 00062700
      ***************************************************************** 00062800
           COPY CPD00037.                                               00062900
                                                                        
      ***************************************************************** 00063100
      * 6253-GET-FJC01-CHKP-LIMIT                                     * 00063200
      ***************************************************************** 00063300
           EXEC SQL                                                     00063400
               INCLUDE CPD00034                                         00063500
           END-EXEC.                                                    00063600
      *                                                                 00063700
      ******************************************************************00063800
      * 6990-FETCH-CUR-ACCOUNT                                         *00063900
      ******************************************************************00064000
      * COPYBOOK TO GET THE MOST CURRENT ACCOUNT AT A PREMISE         * 00064100
           EXEC SQL                                                     00064200
               INCLUDE CPDCA099                                         00064300
           END-EXEC.                                                    00064400
                                                                        
      ******************************************************************00064600
      * 6995-CPD99-ERROR-ROUTINE                                       *00064700
      ******************************************************************00064800
       6995-CPD99-ERROR-ROUTINE.                                        
      *                                                                 00065000
           MOVE ZEROES                     TO WS-CPD99-ACCOUNT-NO.      
                                                                        
           MOVE WS-CPD99-RETURN-CODE       TO WS-DISPLAY-SQLCODE.       
           DISPLAY '****************************************'.          
           DISPLAY '** PCSLM009 PROCESSING ERROR          **'.          
           DISPLAY '** ERROR RETRIEVING CURRENT ACCOUNT   **'.          
           DISPLAY '** ERROR FROM 6990-FETCH-CUR-ACCOUNT  **'.          
           DISPLAY '** ABEND IN PARAGRAPH 6995            **'.          
           DISPLAY '** PREMISE-NO = ' WS-CPD99-PREMISE-NO.              
           DISPLAY '** SQLCODE    = ' WS-DISPLAY-SQLCODE.               
           DISPLAY '****************************************'.          
           PERFORM 9900-ABEND              THRU 9900-EXIT.              
      *                                                                 00066300
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00066600
      ******************************************************************00066700
      *GET CURRENT TIMESTAMP TO INSERT INTO TRANSACTION HISTORY         00066800
      ******************************************************************00066900
      *7000-GET-CURR-TS.                                                00067000
      *                                                                 00067100
      *    EXEC SQL                                                     00067200
      *       SET :4J-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP             00067300
      *    END-EXEC.                                                    00067400
      *                                                                 00067500
      *    MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     00067600
      *                                       WS-SQL-CODE               00067700
      *                                                                 00067800
      *    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               00067900
      *        MOVE 4J-TRANS-HIST-SEQ-NO   TO 4S-TRANS-HIST-SEQ-NO      00068000
      *    ELSE                                                         00068100
      *        DISPLAY '******************************************'     00068200
      *        DISPLAY '** SELECT ERROR IN 7000                 **'     00068300
      *        DISPLAY '** ERROR GETTING CURRENT TIMESTAMP      **'     00068400
      *        DISPLAY '** RETURN CODE = ' WS-SQL-CODE                  00068500
      *        DISPLAY '** PROCESSING TERMINATED                **'     00068600
      *        DISPLAY '******************************************'     00068700
      *        PERFORM 9900-ABEND          THRU 9900-EXIT               00068800
      *    END-IF.                                                      00068900
      *                                                                 00069000
      *7000-EXIT.                                                       00069100
      *    EXIT.                                                        00069200
      *                                                                 00069300
      ******************************************************************00069400
      * 7100-GET-CURRENT-DATE                                          *00069500
      ******************************************************************00069600
       7100-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     00069900
MFA-TR*       SET :WS-CURRENT-DATE  = CURRENT DATE                      00070000
MFA-TR*    END-EXEC.                                                    00070100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              WS-DISPLAY-SQLCODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** SET STATEMENT ERROR 7100- PARA       **'     
               DISPLAY '** ERROR GETTING CURRENT DATE           **'     
               DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE           
               DISPLAY '** PROCESSING TERMINATED                **'     
               DISPLAY '******************************************'     
               PERFORM 9900-ABEND          THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00071600
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00071900
      ******************************************************************00072000
      * 7200-OPEN-MAIN-CURSOR                                          *00072100
      ******************************************************************00072200
       7200-OPEN-MAIN-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN MAIN_CUR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**  PCSLM009 PROCESSING ERROR         **'        
              DISPLAY '**  ERROR OPENING MAIN_CUR            **'        
              DISPLAY '**  ABEND IN PARAGRAPH 7200           **'        
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00074400
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00074700
      ******************************************************************00074800
      * 7250-FETCH-MAIN-CURSOR                                         *00074900
      ******************************************************************00075000
       7250-FETCH-MAIN-CURSOR.                                          
                                                                        
           INITIALIZE     WS-PREMISE-NO                                 
                          WS-ACCOUNT-NO                                 
                          WS-IC-NO                                      
                          WS-CODE-UTIL-TYPE                             
                          WS-RATE-PLAN-NO                               
                          WS-CUSTOMER-NO                                
                          WS-RATE-ITEM-CODE                             
                          WS-CODE-PLAN-STATUS                           
                          WS-LAST-BILL-DATE                             
                          WS-NO-UNITS                                   
                          WS-DATE-PLAN-START                            
                          WS-COUNT.                                     
                                                                        
           EXEC SQL                                                     
             FETCH  MAIN_CUR                                            
               INTO :WS-PREMISE-NO                                      
                   ,:WS-ACCOUNT-NO                                      
                   ,:WS-IC-NO                                           
                   ,:WS-CODE-UTIL-TYPE                                  
                   ,:WS-RATE-PLAN-NO                                    
                   ,:WS-CUSTOMER-NO                                     
                   ,:WS-RATE-ITEM-CODE                                  
                   ,:WS-CODE-PLAN-STATUS                                
                   ,:WS-LAST-BILL-DATE                                  
                   ,:WS-NO-UNITS                                        
                   ,:WS-DATE-PLAN-START                                 
                   ,:WS-COUNT                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              RS-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**  PCSLM009 PROCESSING ERROR         **'        
              DISPLAY '**  ABEND IN PARAGRAPH 7250           **'        
              DISPLAY '**  ERROR FETCHING FROM MAIN_CUR      **'        
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00079800
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00080100
      ******************************************************************00080200
      * 7275-CLOSE-MAIN-CURSOR                                         *00080300
      ******************************************************************00080400
       7275-CLOSE-MAIN-CURSOR.                                          
      *                                                                 00080600
           EXEC SQL                                                     
               CLOSE MAIN_CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00081000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 00081200
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**  PCSLM009 PROCESSING ERROR         **'        
              DISPLAY '**  ABEND IN PARAGRAPH 7275           **'        
              DISPLAY '**  ERROR CLOSING MAIN_CUR            **'        
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00082600
       7275-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00082900
      ******************************************************************00083000
      * 7300-GET-ITEM-SEQ-NO                                           *00083100
      ******************************************************************00083200
       7300-GET-ITEM-SEQ-NO.                                            
                                                                        
           EXEC SQL                                                     
               SELECT MIN(ITEM_SEQ_NO)                                  
                 INTO :WS-ITEM-SEQ-NO                                   
                 FROM CSS_CUST_PLAN WITH(READUNCOMMITTED)                       
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
                  AND IC_NO = :WS-IC-NO                                 
                  AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               
                  AND RATE_ITEM_CODE = :WS-RATE-ITEM-CODE               
                  AND CODE_PLAN_STATUS = :WS-CODE-PLAN-STATUS           
                  AND LAST_BILL_DATE  = IIF(TRY_CONVERT(DATE, 
                                                     :WS-LAST-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-BILL-DATE
              ) <> 0) OR (LEN(:WS-LAST-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-BILL-DATE
              ), CONVERT(DATE, :WS-LAST-BILL-DATE) )              
                  AND DATE_PLAN_START = IIF(TRY_CONVERT(DATE, 
                                                    :WS-DATE-PLAN-START
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-PLAN-START
              ) <> 0) OR (LEN(:WS-DATE-PLAN-START
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-PLAN-START
              ), CONVERT(DATE, :WS-DATE-PLAN-START) )             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00083500
MFA-TR*        SELECT MIN(ITEM_SEQ_NO)                                  00083600
MFA-TR*          INTO :WS-ITEM-SEQ-NO                                   00083700
MFA-TR*          FROM CSS_CUST_PLAN                                     00083800
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       00083900
MFA-TR*           AND IC_NO = :WS-IC-NO                                 00084000
MFA-TR*           AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               00084100
MFA-TR*           AND RATE_ITEM_CODE = :WS-RATE-ITEM-CODE               00084200
MFA-TR*           AND CODE_PLAN_STATUS = :WS-CODE-PLAN-STATUS           00084300
MFA-TR*           AND LAST_BILL_DATE  = :WS-LAST-BILL-DATE              00084400
MFA-TR*           AND DATE_PLAN_START = :WS-DATE-PLAN-START             00084500
MFA-TR*          WITH UR                                                00084600
MFA-TR*       QUERYNO 7300                                              00084700
MFA-TR*    END-EXEC.                                                    00084800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00084900
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '** PCSLM009 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7300            **'        
              DISPLAY '** ERROR SELECTING ITEM_SEQ_NO        **'        
              DISPLAY '** SQLCODE           = ' WS-DISPLAY-SQLCODE      
              DISPLAY '** ACCOUNT_NO        = ' WS-ACCOUNT-NO           
              DISPLAY '** IC_NO             = ' WS-IC-NO                
              DISPLAY '** UTIL_TYPE         = ' WS-CODE-UTIL-TYPE       
              DISPLAY '** RATE_ITEM_CODE    = ' WS-RATE-ITEM-CODE       
              DISPLAY '** CODE_PLAN_STATUS  = ' WS-CODE-PLAN-STATUS     
              DISPLAY '** LAST_BILL_DATE    = ' WS-LAST-BILL-DATE       
              DISPLAY '** DATE_PLAN_START   = ' WS-DATE-PLAN-START      
              DISPLAY '** PROCESSING TERMINATED              **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 00087200
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00087500
      ******************************************************************00087600
      * 7400-UPDATE-CUST-PLAN                                          *00087700
      ******************************************************************00087800
       7400-UPDATE-CUST-PLAN.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_PLAN                                      
                SET NO_UNITS = :WS-NO-UNITS                             
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        
                 AND IC_NO = :WS-IC-NO                                  
                 AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                
                 AND RATE_ITEM_CODE = :WS-RATE-ITEM-CODE                
                 AND ITEM_SEQ_NO = :WS-ITEM-SEQ-NO                      
                 AND CODE_PLAN_STATUS = :WS-CODE-PLAN-STATUS            
                 AND LAST_BILL_DATE  = IIF(TRY_CONVERT(DATE, 
                                                     :WS-LAST-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-BILL-DATE
              ) <> 0) OR (LEN(:WS-LAST-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-BILL-DATE
              ), CONVERT(DATE, :WS-LAST-BILL-DATE) )               
                 AND DATE_PLAN_START =  IIF(TRY_CONVERT(DATE, 
                                                    :WS-DATE-PLAN-START
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-PLAN-START
              ) <> 0) OR (LEN(:WS-DATE-PLAN-START
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-PLAN-START
              ), CONVERT(DATE, :WS-DATE-PLAN-START) )             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00088100
MFA-TR*       UPDATE CSS_CUST_PLAN                                      00088200
MFA-TR*         SET NO_UNITS = :WS-NO-UNITS                             00088300
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        00088400
MFA-TR*          AND IC_NO = :WS-IC-NO                                  00088500
MFA-TR*          AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                00088600
MFA-TR*          AND RATE_ITEM_CODE = :WS-RATE-ITEM-CODE                00088700
MFA-TR*          AND ITEM_SEQ_NO = :WS-ITEM-SEQ-NO                      00088800
MFA-TR*          AND CODE_PLAN_STATUS = :WS-CODE-PLAN-STATUS            00088900
MFA-TR*          AND LAST_BILL_DATE  = :WS-LAST-BILL-DATE               00089000
MFA-TR*          AND DATE_PLAN_START =  :WS-DATE-PLAN-START             00089100
MFA-TR*    END-EXEC.                                                    00089200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              WS-DISPLAY-SQLCODE        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** UPDATE ERROR IN 7400                     **'  
              DISPLAY '** ERROR UPDATING CSS_CUST_PLAN             **'  
              DISPLAY '** RETURN CODE      = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** ACCOUNT_NO       = ' WS-ACCOUNT-NO            
              DISPLAY '** IC NO            = ' WS-IC-NO                 
              DISPLAY '** UTIL TYPE        = ' WS-CODE-UTIL-TYPE        
              DISPLAY '** RATE ITEM CODE   = ' WS-RATE-ITEM-CODE        
              DISPLAY '** ITEM SEQ NO      = ' WS-ITEM-SEQ-NO           
              DISPLAY '** CODE PLAN STATUS = ' WS-CODE-PLAN-STATUS      
              DISPLAY '** LAST BILL DATE   = ' WS-LAST-BILL-DATE        
              DISPLAY '** DATE_PLAN_START  = ' WS-DATE-PLAN-START       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
           ADD  +1                         TO WS-COMMIT-ACCTS-CNT.      
      *                                                                 00091800
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00092100
      ******************************************************************00092200
      * 7500-DELETE-CUST-PLAN                                          *00092300
      ******************************************************************00092400
       7500-DELETE-CUST-PLAN.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_PLAN                                 
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        
                 AND IC_NO          = :WS-IC-NO                         
                 AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                
                 AND RATE_ITEM_CODE = :WS-RATE-ITEM-CODE                
                 AND ITEM_SEQ_NO <> :WS-ITEM-SEQ-NO                     
                 AND CODE_PLAN_STATUS = :WS-CODE-PLAN-STATUS            
                 AND LAST_BILL_DATE  = IIF(TRY_CONVERT(DATE, 
                                                     :WS-LAST-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-BILL-DATE
              ) <> 0) OR (LEN(:WS-LAST-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-BILL-DATE
              ), CONVERT(DATE, :WS-LAST-BILL-DATE) )               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00092700
MFA-TR*       DELETE FROM CSS_CUST_PLAN                                 00092800
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        00092900
MFA-TR*          AND IC_NO          = :WS-IC-NO                         00093000
MFA-TR*          AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                00093100
MFA-TR*          AND RATE_ITEM_CODE = :WS-RATE-ITEM-CODE                00093200
MFA-TR*          AND ITEM_SEQ_NO <> :WS-ITEM-SEQ-NO                     00093300
MFA-TR*          AND CODE_PLAN_STATUS = :WS-CODE-PLAN-STATUS            00093400
MFA-TR*          AND LAST_BILL_DATE  = :WS-LAST-BILL-DATE               00093500
MFA-TR*    END-EXEC.                                                    00093600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              WS-DISPLAY-SQLCODE        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** DELETE ERROR IN 7500                     **'  
              DISPLAY '** RETURN CODE      = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** ACCOUNT_NO       = ' WS-ACCOUNT-NO            
              DISPLAY '** IC NO            = ' WS-IC-NO                 
              DISPLAY '** UTIL TYPE        = ' WS-CODE-UTIL-TYPE        
              DISPLAY '** RATE ITEM CODE   = ' WS-RATE-ITEM-CODE        
              DISPLAY '** ITEM SEQ NO      = ' WS-ITEM-SEQ-NO           
              DISPLAY '** CODE PLAN STATUS = ' WS-CODE-PLAN-STATUS      
              DISPLAY '** LAST BILL DATE   = ' WS-LAST-BILL-DATE        
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00095800
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00096100
      ******************************************************************00096200
      * 7601-UPDATE-EQUIP-ENV                                          *00096300
      ******************************************************************00096400
       7601-UPDATE-EQUIP-ENV.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE LMS_EQUIP_ENVRNMT                                  
                SET ITEM_SEQ_NO     = :WS-ITEM-SEQ-NO                   
                   ,LAST_UPDATE_TS  = CIS.CURRENT$TIMESTAMP()                 
                   ,LAST_UPDATE_USERID = 'LM009'                        
               WHERE INSTALL_LOC_NO   = :WS-PREMISE-NO                  
                 AND CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE              
                 AND IC_NO            = :WS-IC-NO                       
                 AND RATE_PLAN_NO     = :WS-RATE-PLAN-NO                
                 AND RATE_ITEM_CODE   = :WS-RATE-ITEM-CODE              
                 AND BILLING_FL       = :WS-BILLING-FL                  
                 AND ITEM_SEQ_NO     IN                                 
                 (SELECT C1.ITEM_SEQ_NO                                 
                    FROM CSS_CUST_PLAN C1                               
                   WHERE C1.ACCOUNT_NO       = :WS-ACCOUNT-NO           
                     AND C1.IC_NO            = :WS-IC-NO                
                     AND C1.CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE       
                     AND C1.RATE_ITEM_CODE   = :WS-RATE-ITEM-CODE       
                     AND C1.CODE_PLAN_STATUS = :WS-CODE-PLAN-STATUS     
                     AND C1.LAST_BILL_DATE   = IIF(TRY_CONVERT(DATE, 
                                                     :WS-LAST-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-BILL-DATE
              ) <> 0) OR (LEN(:WS-LAST-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-BILL-DATE
              ), CONVERT(DATE, :WS-LAST-BILL-DATE) ))      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00096700
MFA-TR*       UPDATE LMS_EQUIP_ENVRNMT                                  00096800
MFA-TR*         SET ITEM_SEQ_NO     = :WS-ITEM-SEQ-NO                   00096900
MFA-TR*            ,LAST_UPDATE_TS  = CURRENT TIMESTAMP                 00097000
MFA-TR*            ,LAST_UPDATE_USERID = 'LM009'                        00097100
MFA-TR*        WHERE INSTALL_LOC_NO   = :WS-PREMISE-NO                  00097200
MFA-TR*          AND CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE              00097300
MFA-TR*          AND IC_NO            = :WS-IC-NO                       00097400
MFA-TR*          AND RATE_PLAN_NO     = :WS-RATE-PLAN-NO                00097500
MFA-TR*          AND RATE_ITEM_CODE   = :WS-RATE-ITEM-CODE              00097600
MFA-TR*          AND BILLING_FL       = :WS-BILLING-FL                  00097700
MFA-TR*          AND ITEM_SEQ_NO     IN                                 00097800
MFA-TR*          (SELECT C1.ITEM_SEQ_NO                                 00097900
MFA-TR*             FROM CSS_CUST_PLAN C1                               00098000
MFA-TR*            WHERE C1.ACCOUNT_NO       = :WS-ACCOUNT-NO           00098100
MFA-TR*              AND C1.IC_NO            = :WS-IC-NO                00098200
MFA-TR*              AND C1.CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE       00098300
MFA-TR*              AND C1.RATE_ITEM_CODE   = :WS-RATE-ITEM-CODE       00098400
MFA-TR*              AND C1.CODE_PLAN_STATUS = :WS-CODE-PLAN-STATUS     00098500
MFA-TR*              AND C1.LAST_BILL_DATE   = :WS-LAST-BILL-DATE)      00098600
MFA-TR*    END-EXEC.                                                    00098700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              WS-DISPLAY-SQLCODE        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 DISPLAY '** PARA 7601 UPDATE -'                        
                         ' RETURN CODE    = ' WS-DISPLAY-SQLCODE        
                         ' INSTALL_LOC_NO = ' WS-PREMISE-NO             
                         ' CODE_UTIL_TYPE = ' WS-CODE-UTIL-TYPE         
                         ' IC_NO          = ' WS-IC-NO                  
                         ' RATE_PLAN_NO   = ' WS-RATE-PLAN-NO           
                         ' RATE_ITEM_CODE = ' WS-RATE-ITEM-CODE         
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 DISPLAY '****************************************'     
                 DISPLAY '** NOT FOUND IN 7601                  **'     
                 DISPLAY '** RETURN CODE    = ' WS-DISPLAY-SQLCODE      
                 DISPLAY '** INSTALL_LOC_NO = ' WS-PREMISE-NO           
                 DISPLAY '** CODE_UTIL_TYPE = ' WS-CODE-UTIL-TYPE       
                 DISPLAY '** IC_NO          = ' WS-IC-NO                
                 DISPLAY '** RATE_PLAN_NO   = ' WS-RATE-PLAN-NO         
                 DISPLAY '** RATE_ITEM_CODE = ' WS-RATE-ITEM-CODE       
                 DISPLAY '** CODE PLAN STATUS  = ' WS-CODE-PLAN-STATUS  
                 DISPLAY '****************************************'     
              END-IF                                                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** UPDATE ERROR IN 7601                     **'  
              DISPLAY '** RETURN CODE    = ' WS-DISPLAY-SQLCODE         
              DISPLAY '** INSTALL_LOC_NO = ' WS-PREMISE-NO              
              DISPLAY '** CODE_UTIL_TYPE = ' WS-CODE-UTIL-TYPE          
              DISPLAY '** IC_NO          = ' WS-IC-NO                   
              DISPLAY '** RATE_PLAN_NO   = ' WS-RATE-PLAN-NO            
              DISPLAY '** RATE_ITEM_CODE = ' WS-RATE-ITEM-CODE          
              DISPLAY '** RATE_ITEM_CODE = ' WS-RATE-ITEM-CODE          
              DISPLAY '** CODE PLAN STATUS  = ' WS-CODE-PLAN-STATUS     
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00103000
       7601-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00103300
      ******************************************************************00103400
      * 7700-PROCESS-TRANS-HIST                                        *00103500
      ******************************************************************00103600
       7700-PROCESS-TRANS-HIST.                                         
                                                                        
           MOVE SPACES                     TO WS-RESP-AREA-ID.          
           PERFORM 7720-GET-RESP-AREA      THRU 7720-EXIT.              
           PERFORM 7730-SELECT-TIMESTAMP   THRU 7730-EXIT.              
                                                                        
           MOVE WS-TIMESTAMP               TO MH-TRANS-HIST-SEQ-NO.     
           MOVE WS-CURRENT-DATE            TO MH-DATE-TRANS.            
           MOVE 'F'                        TO MH-CODE-TRAN-TYPE.        
           MOVE WS-RESP-AREA-ID            TO MH-RESP-AREA-ID.          
           MOVE WS-ACCOUNT-NO              TO MH-ACCOUNT-NO.            
           MOVE WS-CUSTOMER-NO             TO MH-CUSTOMER-NO.           
           MOVE WS-PREMISE-NO              TO MH-PREMISE-NO.            
           MOVE WS-SYSTEM                  TO MH-USER-ID.               
           MOVE WS-PGM-NAME                TO MH-APPL-PROGRAM-ID.       
           PERFORM 7740-MN-TRANS-HIST      THRU 7740-EXIT.              
                                                                        
           MOVE WS-NO-UNITS                TO WS-NO-UNITS-N.            
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
           MOVE 1                          TO MI-TRAN-APPL-NO.          
           MOVE 'NO_UNITS'                 TO MI-COLUMN-DESC.           
           MOVE 'CP'                       TO MI-TABLE-ID.              
           MOVE +5                         TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE '*NEW*'                    TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE +9                         TO MI-CHG-COLUMN-VALUE-LEN.  
           MOVE WS-NO-UNITS-C              TO MI-CHG-COLUMN-VALUE-TEXT. 
           PERFORM 7750-MN-TRN-HST-DET     THRU 7750-EXIT.              
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00106700
      ******************************************************************00106800
      * 7710-CUST-PLAN-TRANS-HIST.                                     *00106900
      ******************************************************************00107000
       7710-CUST-PLAN-TRANS-HIST.                                       
                                                                        
           PERFORM 7730-SELECT-TIMESTAMP   THRU 7730-EXIT.              
                                                                        
           MOVE WS-TIMESTAMP               TO MH-TRANS-HIST-SEQ-NO.     
           MOVE WS-CURRENT-DATE            TO MH-DATE-TRANS.            
           MOVE 'F'                        TO MH-CODE-TRAN-TYPE.        
           MOVE ' '                        TO MH-RESP-AREA-ID.          
           MOVE CP-ACCOUNT-NO              TO MH-ACCOUNT-NO.            
           MOVE 0                          TO MH-CUSTOMER-NO.           
           MOVE 0                          TO MH-PREMISE-NO.            
           MOVE WS-SYSTEM                  TO MH-USER-ID.               
           MOVE WS-PGM-NAME                TO MH-APPL-PROGRAM-ID.       
           PERFORM 7740-MN-TRANS-HIST      THRU 7740-EXIT.              
                                                                        
           MOVE 1                          TO MI-TRAN-APPL-NO.          
           MOVE 'CD PLAN STATUS'           TO MI-COLUMN-DESC.           
           MOVE 'CP'                       TO MI-TABLE-ID.              
           MOVE +1                         TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE CP-CODE-PLAN-STATUS        TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE +1                         TO MI-CHG-COLUMN-VALUE-LEN.  
           MOVE 'R'                        TO MI-CHG-COLUMN-VALUE-TEXT. 
           PERFORM 7750-MN-TRN-HST-DET     THRU 7750-EXIT.              
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00109700
      ******************************************************************00109800
      * 7720-GET-RESP-AREA                                             *00109900
      ******************************************************************00110000
       7720-GET-RESP-AREA.                                              
                                                                        
           MOVE SPACES                     TO WS-RESP-AREA-ID.          
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
               INTO :WS-RESP-AREA-ID                                    
               FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                      
               WHERE USER_ID = :WS-SYSTEM                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00110500
MFA-TR*       SELECT RESP_AREA_ID                                       00110600
MFA-TR*        INTO :WS-RESP-AREA-ID                                    00110700
MFA-TR*        FROM CSS_USER_PROFILE                                    00110800
MFA-TR*        WHERE USER_ID = :WS-SYSTEM                               00110900
MFA-TR*          WITH UR                                                00111000
MFA-TR*       QUERYNO 7720                                              00111100
MFA-TR*    END-EXEC.                                                    00111200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              WS-DISPLAY-SQLCODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** SELECT ERROR IN 7720                     **'  
              DISPLAY '** ERROR SELECTING RESP_AREA_ID             **'  
              DISPLAY '** RETURN CODE    = ' WS-DISPLAY-SQLCODE         
              DISPLAY '** USER ID        = ' WS-SYSTEM                  
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7720-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00113200
      ******************************************************************00113300
      * 7730-SELECT-TIMESTAMP                                          *00113400
      ******************************************************************00113500
       7730-SELECT-TIMESTAMP.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTAMP                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     00113800
MFA-TR*       SET :WS-TIMESTAMP = CURRENT TIMESTAMP                     00113900
MFA-TR*    END-EXEC.                                                    00114000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              WS-DISPLAY-SQLCODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** SELECT ERROR IN 7730                     **'  
              DISPLAY '** ERROR SELECTING TIMESTAMP                **'  
              DISPLAY '** RETURN CODE    = ' WS-DISPLAY-SQLCODE         
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7730-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00115900
      ******************************************************************00116000
      * 7740-MN-TRANS-HIST                                             *00116100
      ******************************************************************00116200
       7740-MN-TRANS-HIST.                                              
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_MNT_TRANS_HIST                          
                     ( TRANS_HIST_SEQ_NO,                               
                       DATE_TRANS,                                      
                       CODE_TRAN_TYPE,                                  
                       RESP_AREA_ID,                                    
                       ACCOUNT_NO,                                      
                       CUSTOMER_NO,                                     
                       PREMISE_NO,                                      
                       USER_ID,                                         
                       APPL_PROGRAM_ID,                                 
                       TRAN_COMMENT,                                    
                       ENTITY_KEY_DESC)                                 
                VALUES                                                  
                     ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO),               
                       IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),                              
                       :MH-CODE-TRAN-TYPE,                              
                       :MH-RESP-AREA-ID,                                
                       :MH-ACCOUNT-NO,                                  
                       :MH-CUSTOMER-NO,                                 
                       :MH-PREMISE-NO,                                  
                       :MH-USER-ID,                                     
                       :MH-APPL-PROGRAM-ID,                             
                       :MH-TRAN-COMMENT,                                
                       :MH-ENTITY-KEY-DESC)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00116500
MFA-TR*         INSERT INTO CSS_MNT_TRANS_HIST                          00116600
MFA-TR*              ( TRANS_HIST_SEQ_NO,                               00116700
MFA-TR*                DATE_TRANS,                                      00116800
MFA-TR*                CODE_TRAN_TYPE,                                  00116900
MFA-TR*                RESP_AREA_ID,                                    00117000
MFA-TR*                ACCOUNT_NO,                                      00117100
MFA-TR*                CUSTOMER_NO,                                     00117200
MFA-TR*                PREMISE_NO,                                      00117300
MFA-TR*                USER_ID,                                         00117400
MFA-TR*                APPL_PROGRAM_ID,                                 00117500
MFA-TR*                TRAN_COMMENT,                                    00117600
MFA-TR*                ENTITY_KEY_DESC)                                 00117700
MFA-TR*         VALUES                                                  00117800
MFA-TR*              ( :MH-TRANS-HIST-SEQ-NO,                           00117900
MFA-TR*                :MH-DATE-TRANS,                                  00118000
MFA-TR*                :MH-CODE-TRAN-TYPE,                              00118100
MFA-TR*                :MH-RESP-AREA-ID,                                00118200
MFA-TR*                :MH-ACCOUNT-NO,                                  00118300
MFA-TR*                :MH-CUSTOMER-NO,                                 00118400
MFA-TR*                :MH-PREMISE-NO,                                  00118500
MFA-TR*                :MH-USER-ID,                                     00118600
MFA-TR*                :MH-APPL-PROGRAM-ID,                             00118700
MFA-TR*                :MH-TRAN-COMMENT,                                00118800
MFA-TR*                :MH-ENTITY-KEY-DESC)                             00118900
MFA-TR*    END-EXEC.                                                    00119000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              WS-DISPLAY-SQLCODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** SELECT ERROR IN 7740                     **'  
              DISPLAY '** ERROR INSERTING CSS_MNT_TRANS_HIST       **'  
              DISPLAY '** RETURN CODE    = ' WS-DISPLAY-SQLCODE         
              DISPLAY '** ACCOUNT NO     = ' MH-ACCOUNT-NO              
              DISPLAY '** TRANS HIST SEQ = ' MH-TRANS-HIST-SEQ-NO       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7740-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00121100
      ******************************************************************00121200
      * 7750-MN-TRN-HST-DET                                            *00121300
      ******************************************************************00121400
       7750-MN-TRN-HST-DET.                                             
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_MT_TRN_HST_DET                          
                     ( TRANS_HIST_SEQ_NO,                               
                       TRAN_APPL_NO,                                    
                       COLUMN_DESC,                                     
                       TABLE_ID,                                        
                       PRV_COLUMN_VALUE,                                
                       CHG_COLUMN_VALUE)                                
                VALUES                                                  
                     ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO),               
                       :MI-TRAN-APPL-NO,                                
                       :MI-COLUMN-DESC,                                 
                       :MI-TABLE-ID,                                    
                       :MI-PRV-COLUMN-VALUE,                            
                       :MI-CHG-COLUMN-VALUE)                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00121700
MFA-TR*         INSERT INTO CSS_MT_TRN_HST_DET                          00121800
MFA-TR*              ( TRANS_HIST_SEQ_NO,                               00121900
MFA-TR*                TRAN_APPL_NO,                                    00122000
MFA-TR*                COLUMN_DESC,                                     00122100
MFA-TR*                TABLE_ID,                                        00122200
MFA-TR*                PRV_COLUMN_VALUE,                                00122300
MFA-TR*                CHG_COLUMN_VALUE)                                00122400
MFA-TR*         VALUES                                                  00122500
MFA-TR*              ( :MH-TRANS-HIST-SEQ-NO,                           00122600
MFA-TR*                :MI-TRAN-APPL-NO,                                00122700
MFA-TR*                :MI-COLUMN-DESC,                                 00122800
MFA-TR*                :MI-TABLE-ID,                                    00122900
MFA-TR*                :MI-PRV-COLUMN-VALUE,                            00123000
MFA-TR*                :MI-CHG-COLUMN-VALUE)                            00123100
MFA-TR*    END-EXEC.                                                    00123200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              WS-DISPLAY-SQLCODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** SELECT ERROR IN 7750                     **'  
              DISPLAY '** ERROR INSERTING CSS_MT_TRN_HST_DET       **'  
              DISPLAY '** RETURN CODE    = ' WS-DISPLAY-SQLCODE         
              DISPLAY '** ACCOUNT NO     = ' MH-ACCOUNT-NO              
              DISPLAY '** TRANS HIST SEQ = ' MH-TRANS-HIST-SEQ-NO       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00125300
      ******************************************************************00125400
      * 7770-LMS-TRANS-HISTORY.                                        *00125500
      ******************************************************************00125600
       7770-LMS-TRANS-HISTORY.                                          
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO       TO 4J-TRANS-HIST-SEQ-NO.     
           MOVE 4F-EQUIP-SEQ               TO 4J-EQUIP-SEQ.             
           MOVE 4D-EQUIP-TAG-NO            TO 4J-EQUIP-TAG-NO.          
           MOVE 'LMSCONV'                  TO 4J-APPL-PROGRAM-ID.       
           MOVE ' '                        TO 4J-SOURCE-APPL-CD.        
           MOVE 0                          TO 4J-SOURCE-APPL-REQ-NO.    
           MOVE 0                          TO 4J-WMS-POINT-NO.          
           MOVE 4F-INSTALL-LOC-NO          TO 4J-INSTALL-LOC-NO.        
           MOVE 4F-INSTALL-POINT-NO        TO 4J-INSTALL-POINT-NO.      
           MOVE CP-ACCOUNT-NO              TO 4J-ACCOUNT-NO.            
           MOVE 'POLE CORRECTION-FOR INACTIVE POLES' TO                 
                                              4J-TRANS-COMMENTS-TEXT.   
           MOVE 34                         TO 4J-TRANS-COMMENTS-LEN.    
           MOVE 'SYSTEM'                   TO 4J-LAST-UPDATE-USERID.    
           PERFORM 7780-INSERT-LMS-TRANS-HIST THRU 7780-EXIT.           
                                                                        
           MOVE 1                          TO 4S-DETAIL-SEQ-NO.         
           MOVE 'CODE_UTIL_TYPE'           TO 4S-COLUMN-DESC.           
           MOVE 4F-CODE-UTIL-TYPE          TO 4S-PRV-COLUMN-VALUE-TEXT. 
           MOVE 1                          TO 4S-PRV-COLUMN-VALUE-LEN.  
           MOVE ' '                        TO 4S-CHG-COLUMN-VALUE-TEXT. 
           MOVE 1                          TO 4S-CHG-COLUMN-VALUE-LEN.  
           PERFORM 7790-INSERT-LMS-TRANS-DET  THRU 7790-EXIT.           
                                                                        
           ADD  1                          TO 4S-DETAIL-SEQ-NO.         
           MOVE 'IC_NO'                    TO 4S-COLUMN-DESC.           
           MOVE 0                          TO WS-4-DIGIT-FMT-N.         
           MOVE 4F-IC-NO                   TO WS-4-DIGIT-FMT-N.         
           IF WS-4-DIGIT-FMT-N > 0                                      
              MOVE WS-4-DIGIT-FMT          TO 4S-PRV-COLUMN-VALUE-TEXT  
              MOVE 4                       TO 4S-PRV-COLUMN-VALUE-LEN   
           ELSE                                                         
              MOVE ' '                     TO 4S-PRV-COLUMN-VALUE-TEXT  
              MOVE 1                       TO 4S-PRV-COLUMN-VALUE-LEN   
           END-IF                                                       
           MOVE '0000'                     TO 4S-CHG-COLUMN-VALUE-TEXT. 
           MOVE 4                          TO 4S-CHG-COLUMN-VALUE-LEN.  
           PERFORM 7790-INSERT-LMS-TRANS-DET  THRU 7790-EXIT.           
                                                                        
           ADD  1                          TO 4S-DETAIL-SEQ-NO.         
           MOVE 'POLE_RATE_PLAN_NO'        TO 4S-COLUMN-DESC.           
           MOVE 4F-RATE-PLAN-NO            TO 4S-PRV-COLUMN-VALUE-TEXT. 
           MOVE 3                          TO 4S-PRV-COLUMN-VALUE-LEN.  
           MOVE ' '                        TO 4S-CHG-COLUMN-VALUE-TEXT. 
           MOVE 1                          TO 4S-CHG-COLUMN-VALUE-LEN.  
           PERFORM 7790-INSERT-LMS-TRANS-DET  THRU 7790-EXIT.           
                                                                        
           ADD  1                          TO 4S-DETAIL-SEQ-NO.         
           MOVE 'POLE_RATE_ITEM_CD'        TO 4S-COLUMN-DESC.           
           MOVE 0                          TO WS-4-DIGIT-FMT-N.         
           MOVE 4F-RATE-ITEM-CODE          TO WS-4-DIGIT-FMT-N.         
           IF WS-4-DIGIT-FMT-N > 0                                      
              MOVE WS-4-DIGIT-FMT          TO 4S-PRV-COLUMN-VALUE-TEXT  
              MOVE 4                       TO 4S-PRV-COLUMN-VALUE-LEN   
           ELSE                                                         
              MOVE ' '                     TO 4S-PRV-COLUMN-VALUE-TEXT  
              MOVE 1                       TO 4S-PRV-COLUMN-VALUE-LEN   
           END-IF                                                       
           MOVE '0000'                     TO 4S-CHG-COLUMN-VALUE-TEXT. 
           MOVE 4                          TO 4S-CHG-COLUMN-VALUE-LEN.  
           PERFORM 7790-INSERT-LMS-TRANS-DET  THRU 7790-EXIT.           
                                                                        
           ADD  1                          TO 4S-DETAIL-SEQ-NO.         
           MOVE 'ITEM_SEQ_NO'              TO 4S-COLUMN-DESC.           
           MOVE 0                          TO WS-4-DIGIT-FMT-N.         
           MOVE 4F-ITEM-SEQ-NO             TO WS-4-DIGIT-FMT-N.         
           IF WS-4-DIGIT-FMT-N > 0                                      
              MOVE WS-4-DIGIT-FMT          TO 4S-PRV-COLUMN-VALUE-TEXT  
              MOVE 4                       TO 4S-PRV-COLUMN-VALUE-LEN   
           ELSE                                                         
              MOVE ' '                     TO 4S-PRV-COLUMN-VALUE-TEXT  
              MOVE 1                       TO 4S-PRV-COLUMN-VALUE-LEN   
           END-IF                                                       
           MOVE '0000'                     TO 4S-CHG-COLUMN-VALUE-TEXT. 
           MOVE 4                          TO 4S-CHG-COLUMN-VALUE-LEN.  
           PERFORM 7790-INSERT-LMS-TRANS-DET  THRU 7790-EXIT.           
                                                                        
       7770-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00133800
      ******************************************************************00133900
      * 7780-INSERT-LMS-TRANS-HIST.                                    *00134000
      ******************************************************************00134100
       7780-INSERT-LMS-TRANS-HIST.                                      
                                                                        
           EXEC SQL                                                     
                INSERT INTO LMS_TRANS_HIST                              
                     (  EQUIP_SEQ                                       
                       ,TRANS_HIST_SEQ_NO                               
                       ,EQUIP_TAG_NO                                    
                       ,APPL_PROGRAM_ID                                 
                       ,TRANS_DATE                                      
                       ,SOURCE_APPL_CD                                  
                       ,SOURCE_APPL_REQ_NO                              
                       ,WMS_POINT_NO                                    
                       ,INSTALL_LOC_NO                                  
                       ,INSTALL_POINT_NO                                
                       ,ACCOUNT_NO                                      
                       ,LAST_UPDATE_TS                                  
                       ,LAST_UPDATE_USERID                              
                       ,TRANS_COMMENTS)                                 
                VALUES                                                  
                     ( :4J-EQUIP-SEQ                                    
                      ,CIS.CHAR2TIMESTAMP(:4J-TRANS-HIST-SEQ-NO)                
                      ,:4J-EQUIP-TAG-NO                                 
                      ,:4J-APPL-PROGRAM-ID                              
                      ,CAST(SYSDATETIMEOFFSET() AS DATE)                        
                      ,:4J-SOURCE-APPL-CD                               
                      ,:4J-SOURCE-APPL-REQ-NO                           
                      ,:4J-WMS-POINT-NO                                 
                      ,:4J-INSTALL-LOC-NO                               
                      ,:4J-INSTALL-POINT-NO                             
                      ,:4J-ACCOUNT-NO                                   
                      ,CIS.CURRENT$TIMESTAMP()                                
                      ,:4J-LAST-UPDATE-USERID                           
                      ,:4J-TRANS-COMMENTS)                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00134400
MFA-TR*         INSERT INTO LMS_TRANS_HIST                              00134500
MFA-TR*              (  EQUIP_SEQ                                       00134600
MFA-TR*                ,TRANS_HIST_SEQ_NO                               00134700
MFA-TR*                ,EQUIP_TAG_NO                                    00134800
MFA-TR*                ,APPL_PROGRAM_ID                                 00134900
MFA-TR*                ,TRANS_DATE                                      00135000
MFA-TR*                ,SOURCE_APPL_CD                                  00135100
MFA-TR*                ,SOURCE_APPL_REQ_NO                              00135200
MFA-TR*                ,WMS_POINT_NO                                    00135300
MFA-TR*                ,INSTALL_LOC_NO                                  00135400
MFA-TR*                ,INSTALL_POINT_NO                                00135500
MFA-TR*                ,ACCOUNT_NO                                      00135600
MFA-TR*                ,LAST_UPDATE_TS                                  00135700
MFA-TR*                ,LAST_UPDATE_USERID                              00135800
MFA-TR*                ,TRANS_COMMENTS)                                 00135900
MFA-TR*         VALUES                                                  00136000
MFA-TR*              ( :4J-EQUIP-SEQ                                    00136100
MFA-TR*               ,:4J-TRANS-HIST-SEQ-NO                            00136200
MFA-TR*               ,:4J-EQUIP-TAG-NO                                 00136300
MFA-TR*               ,:4J-APPL-PROGRAM-ID                              00136400
MFA-TR*               ,CURRENT DATE                                     00136500
MFA-TR*               ,:4J-SOURCE-APPL-CD                               00136600
MFA-TR*               ,:4J-SOURCE-APPL-REQ-NO                           00136700
MFA-TR*               ,:4J-WMS-POINT-NO                                 00136800
MFA-TR*               ,:4J-INSTALL-LOC-NO                               00136900
MFA-TR*               ,:4J-INSTALL-POINT-NO                             00137000
MFA-TR*               ,:4J-ACCOUNT-NO                                   00137100
MFA-TR*               ,CURRENT TIMESTAMP                                00137200
MFA-TR*               ,:4J-LAST-UPDATE-USERID                           00137300
MFA-TR*               ,:4J-TRANS-COMMENTS)                              00137400
MFA-TR*    END-EXEC.                                                    00137500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              WS-DISPLAY-SQLCODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** SELECT ERROR IN 7780                     **'  
              DISPLAY '** ERROR INSERTING  LMS_TRANS_HIST          **'  
              DISPLAY '** RETURN CODE    = ' WS-DISPLAY-SQLCODE         
              DISPLAY '** EQUIP SEQ NO   = ' 4J-EQUIP-SEQ               
              DISPLAY '** TRANS HIST SEQ = ' 4J-TRANS-HIST-SEQ-NO       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7780-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00139600
      ******************************************************************00139700
      * 7790-INSERT-LMS-TRANS-DET.                                     *00139800
      ******************************************************************00139900
       7790-INSERT-LMS-TRANS-DET.                                       
                                                                        
           EXEC SQL                                                     
                INSERT INTO LMS_TRANS_HIST_DET                          
                     (  EQUIP_SEQ                                       
                       ,TRANS_HIST_SEQ_NO                               
                       ,DETAIL_SEQ_NO                                   
                       ,COLUMN_DESC                                     
                       ,PRV_COLUMN_VALUE                                
                       ,CHG_COLUMN_VALUE                                
                       ,LAST_UPDATE_USERID)                             
                VALUES                                                  
                     ( :4J-EQUIP-SEQ                                    
                      ,CIS.CHAR2TIMESTAMP(:4J-TRANS-HIST-SEQ-NO)                
                      ,:4S-DETAIL-SEQ-NO                                
                      ,:4S-COLUMN-DESC                                  
                      ,:4S-PRV-COLUMN-VALUE                             
                      ,:4S-CHG-COLUMN-VALUE                             
                      ,:4J-LAST-UPDATE-USERID)                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00140200
MFA-TR*         INSERT INTO LMS_TRANS_HIST_DET                          00140300
MFA-TR*              (  EQUIP_SEQ                                       00140400
MFA-TR*                ,TRANS_HIST_SEQ_NO                               00140500
MFA-TR*                ,DETAIL_SEQ_NO                                   00140600
MFA-TR*                ,COLUMN_DESC                                     00140700
MFA-TR*                ,PRV_COLUMN_VALUE                                00140800
MFA-TR*                ,CHG_COLUMN_VALUE                                00140900
MFA-TR*                ,LAST_UPDATE_USERID)                             00141000
MFA-TR*         VALUES                                                  00141100
MFA-TR*              ( :4J-EQUIP-SEQ                                    00141200
MFA-TR*               ,:4J-TRANS-HIST-SEQ-NO                            00141300
MFA-TR*               ,:4S-DETAIL-SEQ-NO                                00141400
MFA-TR*               ,:4S-COLUMN-DESC                                  00141500
MFA-TR*               ,:4S-PRV-COLUMN-VALUE                             00141600
MFA-TR*               ,:4S-CHG-COLUMN-VALUE                             00141700
MFA-TR*               ,:4J-LAST-UPDATE-USERID)                          00141800
MFA-TR*    END-EXEC.                                                    00141900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              WS-DISPLAY-SQLCODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** SELECT ERROR IN 7790                     **'  
              DISPLAY '** ERROR INSERTING  LMS_TRANS_HIST          **'  
              DISPLAY '** RETURN CODE    = ' WS-DISPLAY-SQLCODE         
              DISPLAY '** EQUIP SEQ NO   = ' 4J-EQUIP-SEQ               
              DISPLAY '** TRANS HIST SEQ = ' 4J-TRANS-HIST-SEQ-NO       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7790-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00144000
      ******************************************************************00144100
      * 7800-OPEN-POLE-CURSOR                                          *00144200
      ******************************************************************00144300
       7800-OPEN-POLE-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN GET_POLE_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**  PCSLM009 PROCESSING ERROR         **'        
              DISPLAY '**  ERROR OPENING GET_POLE_CUR        **'        
              DISPLAY '**  ABEND IN PARAGRAPH 7800           **'        
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00146500
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00146800
      ******************************************************************00146900
      * 7810-FETCH-POLE-CURSOR                                         *00147000
      ******************************************************************00147100
       7810-FETCH-POLE-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
             FETCH  GET_POLE_CUR                                        
               INTO  :4D-EQUIP-SEQ                                      
                    ,:4D-EQUIP-TAG-NO                                   
                    ,:4F-INSTALL-LOC-NO                                 
                    ,:4F-INSTALL-POINT-NO                               
                    ,:4F-CODE-UTIL-TYPE                                 
                    ,:4F-IC-NO                                          
                    ,:4F-RATE-PLAN-NO                                   
                    ,:4F-RATE-ITEM-CODE                                 
                    ,:4F-ITEM-SEQ-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              RS-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**  PCSLM009 PROCESSING ERROR         **'        
              DISPLAY '**  ABEND IN PARAGRAPH 7810           **'        
              DISPLAY '**  ERROR FETCHING FROM GET_POLE_CUR  **'        
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00150300
       7810-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00150600
      ******************************************************************00150700
      * 7820-CLOSE-POLE-CURSOR                                         *00150800
      ******************************************************************00150900
       7820-CLOSE-POLE-CURSOR.                                          
      *                                                                 00151100
           EXEC SQL                                                     
               CLOSE GET_POLE_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00151500
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 00151700
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**  PCSLM009 PROCESSING ERROR         **'        
              DISPLAY '**  ABEND IN PARAGRAPH 7820           **'        
              DISPLAY '**  ERROR CLOSING GET_POLE_CUR        **'        
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00153100
       7820-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00153400
      ******************************************************************00153500
      * 7840-GET-CUST-PLAN.                                            *00153600
      ******************************************************************00153700
       7840-GET-CUST-PLAN.                                              
                                                                        
           EXEC SQL                                                     
               SELECT CODE_PLAN_STATUS                                  
                 INTO :CP-CODE-PLAN-STATUS                              
                 FROM CSS_CUST_PLAN CP WITH(READUNCOMMITTED)                    
                WHERE CP.ACCOUNT_NO       = :CP-ACCOUNT-NO              
                  AND CP.CODE_UTIL_TYPE   = :CP-CODE-UTIL-TYPE          
                  AND CP.IC_NO            = :CP-IC-NO                   
                  AND CP.RATE_ITEM_CODE   = :CP-RATE-ITEM-CODE          
                  AND CP.ITEM_SEQ_NO      = :CP-ITEM-SEQ-NO             
                  AND CP.CODE_PLAN_STATUS = 'I'                         
                  AND CP.NO_UNITS         =  1                          
                  AND CP.REMOVE_DATE     IS NOT NULL                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00154000
MFA-TR*        SELECT CODE_PLAN_STATUS                                  00154100
MFA-TR*          INTO :CP-CODE-PLAN-STATUS                              00154200
MFA-TR*          FROM CSS_CUST_PLAN CP                                  00154300
MFA-TR*         WHERE CP.ACCOUNT_NO       = :CP-ACCOUNT-NO              00154400
MFA-TR*           AND CP.CODE_UTIL_TYPE   = :CP-CODE-UTIL-TYPE          00154500
MFA-TR*           AND CP.IC_NO            = :CP-IC-NO                   00154600
MFA-TR*           AND CP.RATE_ITEM_CODE   = :CP-RATE-ITEM-CODE          00154700
MFA-TR*           AND CP.ITEM_SEQ_NO      = :CP-ITEM-SEQ-NO             00154800
MFA-TR*           AND CP.CODE_PLAN_STATUS = 'I'                         00154900
MFA-TR*           AND CP.NO_UNITS         =  1                          00155000
MFA-TR*           AND CP.REMOVE_DATE     IS NOT NULL                    00155100
MFA-TR*          WITH UR                                                00155200
MFA-TR*       QUERYNO 7840                                              00155300
MFA-TR*    END-EXEC.                                                    00155400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00155500
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '** PCSLM009 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7840            **'        
              DISPLAY '** ERROR SELECTING GET-CUST-PLAN      **'        
              DISPLAY '** SQLCODE          = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** ACCOUNT_NO       = ' CP-ACCOUNT-NO            
              DISPLAY '** CODE_UTIL_TYPE   = ' CP-CODE-UTIL-TYPE        
              DISPLAY '** IC_NO            = ' CP-IC-NO                 
              DISPLAY '** RATE_ITEM_CODE   = ' CP-RATE-ITEM-CODE        
              DISPLAY '** ITEM_SEQ_NO      = ' CP-ITEM-SEQ-NO           
              DISPLAY '** PROCESSING TERMINATED              **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 00157600
       7840-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00157900
      ******************************************************************00158000
      * 7850-OPEN-FXTR-CURSOR                                          *00158100
      ******************************************************************00158200
       7850-OPEN-FXTR-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN GET_FXTR_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**  PCSLM009 PROCESSING ERROR         **'        
              DISPLAY '**  ERROR OPENING GET_FXTR_CUR        **'        
              DISPLAY '**  ABEND IN PARAGRAPH 7850           **'        
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00160400
       7850-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00160700
      ******************************************************************00160800
      * 7860-FETCH-FXTR-CURSOR                                         *00160900
      ******************************************************************00161000
       7860-FETCH-FXTR-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
             FETCH  GET_FXTR_CUR                                        
               INTO  :4F-EQUIP-SEQ                                      
                    ,:4D-EQUIP-TAG-NO                                   
                    ,:4F-INSTALL-POINT-NO                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              RS-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**  PCSLM009 PROCESSING ERROR         **'        
              DISPLAY '**  ABEND IN PARAGRAPH 7810           **'        
              DISPLAY '**  ERROR FETCHING FROM GET_FXTR_CUR  **'        
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00163600
       7860-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00163900
      ******************************************************************00164000
      * 7870-CLOSE-FXTR-CURSOR                                         *00164100
      ******************************************************************00164200
       7870-CLOSE-FXTR-CURSOR.                                          
      *                                                                 00164400
           EXEC SQL                                                     
               CLOSE GET_FXTR_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00164800
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 00165000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**  PCSLM009 PROCESSING ERROR         **'        
              DISPLAY '**  ABEND IN PARAGRAPH 7870           **'        
              DISPLAY '**  ERROR CLOSING GET_FXTR_CUR        **'        
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00166400
       7870-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00166700
      ******************************************************************00166800
      * 8010-UPDATE-CUST-PLAN                                          *00166900
      ******************************************************************00167000
       8010-UPDATE-CUST-PLAN.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_PLAN                                      
                 SET CODE_PLAN_STATUS    = 'R'                          
               WHERE ACCOUNT_NO          = :CP-ACCOUNT-NO               
                 AND CODE_UTIL_TYPE      = :CP-CODE-UTIL-TYPE           
                 AND IC_NO               = :CP-IC-NO                    
                 AND RATE_ITEM_CODE      = :CP-RATE-ITEM-CODE           
                 AND ITEM_SEQ_NO         = :CP-ITEM-SEQ-NO              
                 AND NO_UNITS            =  1                           
                 AND REMOVE_DATE        IS NOT NULL                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              WS-DISPLAY-SQLCODE        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** UPDATE ERROR IN 8010                     **'  
              DISPLAY '** ERROR UPDATING CSS_CUST_PLAN             **'  
              DISPLAY '** RETURN CODE      = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** ACCOUNT_NO       = ' CP-ACCOUNT-NO            
              DISPLAY '** CODE_UTIL_TYPE   = ' CP-CODE-UTIL-TYPE        
              DISPLAY '** IC_NO            = ' CP-IC-NO                 
              DISPLAY '** RATE_ITEM_CODE   = ' CP-RATE-ITEM-CODE        
              DISPLAY '** ITEM_SEQ_NO      = ' CP-ITEM-SEQ-NO           
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
           ADD  +1                         TO WS-COMMIT-ACCTS-CNT.      
      *                                                                 00170600
       8010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00170900
      ******************************************************************00171000
      * 8020-UPDATE-EQUIP-ENVRNMT.                                     *00171100
      ******************************************************************00171200
       8020-UPDATE-EQUIP-ENVRNMT.                                       
                                                                        
           EXEC SQL                                                     
              UPDATE LMS_EQUIP_ENVRNMT                                  
                 SET CODE_UTIL_TYPE      = ' '                          
                    ,IC_NO               =  0                           
                    ,RATE_PLAN_NO        = '   '                        
                    ,RATE_ITEM_CODE      =  0                           
                    ,ITEM_SEQ_NO         =  0                           
               WHERE INSTALL_LOC_NO      = :4F-INSTALL-LOC-NO           
                 AND INSTALL_POINT_NO    = :4F-INSTALL-POINT-NO         
                 AND INSTALL_LOC_CD      = 'P'                          
                 AND CODE_UTIL_TYPE      = :4F-CODE-UTIL-TYPE           
                 AND IC_NO               = :4F-IC-NO                    
                 AND RATE_PLAN_NO        = :4F-RATE-PLAN-NO             
                 AND RATE_ITEM_CODE      = :4F-RATE-ITEM-CODE           
                 AND ITEM_SEQ_NO         = :4F-ITEM-SEQ-NO              
                 AND BILLING_FL          = 'N'                          
                 AND NO_BILL_REASON_CD  IN ('CR','CO','SO')             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              WS-DISPLAY-SQLCODE        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** UPDATE ERROR IN 8020                     **'  
              DISPLAY '** RETURN CODE      = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** INSTALL_LOC_NO   = ' 4F-INSTALL-LOC-NO        
              DISPLAY '** INSTALL_POINT_NO = ' 4F-INSTALL-POINT-NO      
              DISPLAY '** CODE_UTIL_TYPE   = ' 4F-CODE-UTIL-TYPE        
              DISPLAY '** IC_NO            = ' 4F-IC-NO                 
              DISPLAY '** RATE_PLAN_NO     = ' 4F-RATE-PLAN-NO          
              DISPLAY '** RATE_ITEM_CODE   = ' 4F-RATE-ITEM-CODE        
              DISPLAY '** ITEM_SEQ_NO      = ' 4F-ITEM-SEQ-NO           
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00175400
       8020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00175700
      ******************************************************************00175800
      * 8200-OPEN-REMOVE-CURSOR                                        *00175900
      ******************************************************************00176000
       8200-OPEN-REMOVE-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               OPEN MAIN_CUR_REMOVE                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**  PCSLM009 PROCESSING ERROR         **'        
              DISPLAY '**  ERROR OPENING MAIN_CUR_REMOVE     **'        
              DISPLAY '**  ABEND IN PARAGRAPH 8200           **'        
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00178200
       8200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00178500
      * 8250-FETCH-REMOVE-CURSOR                                       *00178600
      ******************************************************************00178700
       8250-FETCH-REMOVE-CURSOR.                                        
                                                                        
           INITIALIZE     WS-PREMISE-NO                                 
                          WS-ACCOUNT-NO                                 
                          WS-IC-NO                                      
                          WS-CODE-UTIL-TYPE                             
                          WS-RATE-PLAN-NO                               
                          WS-CUSTOMER-NO                                
                          WS-RATE-ITEM-CODE                             
                          WS-CODE-PLAN-STATUS                           
                          WS-LAST-BILL-DATE                             
                          WS-NO-UNITS                                   
                          WS-DATE-PLAN-START                            
                          WS-COUNT.                                     
                                                                        
           EXEC SQL                                                     
             FETCH  MAIN_CUR_REMOVE                                     
               INTO :WS-PREMISE-NO                                      
                   ,:WS-ACCOUNT-NO                                      
                   ,:WS-IC-NO                                           
                   ,:WS-CODE-UTIL-TYPE                                  
                   ,:WS-RATE-PLAN-NO                                    
                   ,:WS-CUSTOMER-NO                                     
                   ,:WS-RATE-ITEM-CODE                                  
                   ,:WS-CODE-PLAN-STATUS                                
                   ,:WS-LAST-BILL-DATE                                  
                   ,:WS-NO-UNITS                                        
                   ,:WS-DATE-PLAN-START                                 
                   ,:WS-COUNT                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              RS-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '** PCSLM009 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 8250            **'        
              DISPLAY '** ERROR FETCHING FROM MAIN_CUR_REMOVE**'        
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '** PROCESSING TERMINATED              **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00183500
       8250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00183800
      ******************************************************************00183900
      * 8275-CLOSE-REMOVE-CURSOR                                       *00184000
      ******************************************************************00184100
       8275-CLOSE-REMOVE-CURSOR.                                        
      *                                                                 00184300
           EXEC SQL                                                     
               CLOSE MAIN_CUR_REMOVE                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00184700
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 00184900
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**  PCSLM009 PROCESSING ERROR         **'        
              DISPLAY '**  ABEND IN PARAGRAPH 8275           **'        
              DISPLAY '**  ERROR CLOSING MAIN_CUR_REMOVE     **'        
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00186300
       8275-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00186600
      ******************************************************************00186700
      * 8300-GET-ITEM-SEQ-NO                                           *00186800
      ******************************************************************00186900
       8300-GET-ITEM-SEQ-NO.                                            
                                                                        
           EXEC SQL                                                     
               SELECT MIN(ITEM_SEQ_NO)                                  
                 INTO :WS-ITEM-SEQ-NO                                   
                 FROM CSS_CUST_PLAN WITH(READUNCOMMITTED)                       
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
                  AND IC_NO = :WS-IC-NO                                 
                  AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               
                  AND RATE_ITEM_CODE = :WS-RATE-ITEM-CODE               
                  AND CODE_PLAN_STATUS = :WS-CODE-PLAN-STATUS           
                  AND DATE_PLAN_START = IIF(TRY_CONVERT(DATE, 
                                                    :WS-DATE-PLAN-START
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-PLAN-START
              ) <> 0) OR (LEN(:WS-DATE-PLAN-START
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-PLAN-START
              ), CONVERT(DATE, :WS-DATE-PLAN-START) )             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00187200
MFA-TR*        SELECT MIN(ITEM_SEQ_NO)                                  00187300
MFA-TR*          INTO :WS-ITEM-SEQ-NO                                   00187400
MFA-TR*          FROM CSS_CUST_PLAN                                     00187500
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       00187600
MFA-TR*           AND IC_NO = :WS-IC-NO                                 00187700
MFA-TR*           AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               00187800
MFA-TR*           AND RATE_ITEM_CODE = :WS-RATE-ITEM-CODE               00187900
MFA-TR*           AND CODE_PLAN_STATUS = :WS-CODE-PLAN-STATUS           00188000
MFA-TR*           AND DATE_PLAN_START = :WS-DATE-PLAN-START             00188100
MFA-TR*          WITH UR                                                00188200
MFA-TR*       QUERYNO 8300                                              00188300
MFA-TR*    END-EXEC.                                                    00188400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00188500
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '** PCSLM009 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 8300            **'        
              DISPLAY '** ERROR SELECTING ITEM_SEQ_NO        **'        
              DISPLAY '** SQLCODE           = ' WS-DISPLAY-SQLCODE      
              DISPLAY '** ACCOUNT_NO        = ' WS-ACCOUNT-NO           
              DISPLAY '** IC_NO             = ' WS-IC-NO                
              DISPLAY '** UTIL_TYPE         = ' WS-CODE-UTIL-TYPE       
              DISPLAY '** RATE_ITEM_CODE    = ' WS-RATE-ITEM-CODE       
              DISPLAY '** CODE_PLAN_STATUS  = ' WS-CODE-PLAN-STATUS     
              DISPLAY '** DATE_PLAN_START   = ' WS-DATE-PLAN-START      
              DISPLAY '** PROCESSING TERMINATED              **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 00190700
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00191000
      ******************************************************************00191100
      * 8400-UPDATE-CUST-PLAN                                          *00191200
      ******************************************************************00191300
       8400-UPDATE-CUST-PLAN.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_PLAN                                      
                SET NO_UNITS = :WS-NO-UNITS                             
                   ,LAST_BILL_DATE  = IIF(TRY_CONVERT(DATE, 
                                                     :WS-LAST-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-BILL-DATE
              ) <> 0) OR (LEN(:WS-LAST-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-BILL-DATE
              ), CONVERT(DATE, :WS-LAST-BILL-DATE) )                
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        
                 AND IC_NO = :WS-IC-NO                                  
                 AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                
                 AND RATE_ITEM_CODE = :WS-RATE-ITEM-CODE                
                 AND ITEM_SEQ_NO = :WS-ITEM-SEQ-NO                      
                 AND CODE_PLAN_STATUS = :WS-CODE-PLAN-STATUS            
                 AND DATE_PLAN_START =  IIF(TRY_CONVERT(DATE, 
                                                    :WS-DATE-PLAN-START
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-PLAN-START
              ) <> 0) OR (LEN(:WS-DATE-PLAN-START
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-PLAN-START
              ), CONVERT(DATE, :WS-DATE-PLAN-START) )             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00191600
MFA-TR*       UPDATE CSS_CUST_PLAN                                      00191700
MFA-TR*         SET NO_UNITS = :WS-NO-UNITS                             00191800
MFA-TR*            ,LAST_BILL_DATE  = :WS-LAST-BILL-DATE                00191900
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        00192000
MFA-TR*          AND IC_NO = :WS-IC-NO                                  00192100
MFA-TR*          AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                00192200
MFA-TR*          AND RATE_ITEM_CODE = :WS-RATE-ITEM-CODE                00192300
MFA-TR*          AND ITEM_SEQ_NO = :WS-ITEM-SEQ-NO                      00192400
MFA-TR*          AND CODE_PLAN_STATUS = :WS-CODE-PLAN-STATUS            00192500
MFA-TR*          AND DATE_PLAN_START =  :WS-DATE-PLAN-START             00192600
MFA-TR*    END-EXEC.                                                    00192700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              WS-DISPLAY-SQLCODE        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 DISPLAY '** PARA 8400 UPDATE -'                        
                         ' RETURN CODE = ' WS-DISPLAY-SQLCODE           
                         ' ACCOUNT_NO = ' WS-ACCOUNT-NO                 
                         ' IC_NO = ' WS-IC-NO                           
                         ' CODE_UTIL_TYPE = ' WS-CODE-UTIL-TYPE         
                         ' RATE_ITEM_CODE = ' WS-RATE-ITEM-CODE         
                         ' ITEM SEQ NO = ' WS-ITEM-SEQ-NO               
                         ' CODE PLAN STATUS = ' WS-CODE-PLAN-STATUS     
                         ' DATE PLAN START = ' WS-DATE-PLAN-START       
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 DISPLAY '****************************************'     
                 DISPLAY '** NOT FOUND IN 8400                  **'     
                 DISPLAY '** RETURN CODE      = ' WS-DISPLAY-SQLCODE    
                 DISPLAY '** ACCOUNT_NO       = ' WS-ACCOUNT-NO         
                 DISPLAY '** IC_NO            = ' WS-IC-NO              
                 DISPLAY '** CODE_UTIL_TYPE   = ' WS-CODE-UTIL-TYPE     
                 DISPLAY '** RATE_ITEM_CODE   = ' WS-RATE-ITEM-CODE     
                 DISPLAY '** ITEM_SEQ_NO      = ' WS-ITEM-SEQ-NO        
                 DISPLAY '** CODE PLAN STATUS = ' WS-CODE-PLAN-STATUS   
                 DISPLAY '** DATE PLAN START  = ' WS-DATE-PLAN-START    
                 DISPLAY '****************************************'     
              END-IF                                                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** UPDATE ERROR IN 8400                     **'  
              DISPLAY '** ERROR UPDATING CSS_CUST_PLAN             **'  
              DISPLAY '** RETURN CODE      = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** ACCOUNT_NO       = ' WS-ACCOUNT-NO            
              DISPLAY '** IC_NO            = ' WS-IC-NO                 
              DISPLAY '** CODE_UTIL_TYPE   = ' WS-CODE-UTIL-TYPE        
              DISPLAY '** RATE_ITEM_CODE   = ' WS-RATE-ITEM-CODE        
              DISPLAY '** ITEM_SEQ_NO      = ' WS-ITEM-SEQ-NO           
              DISPLAY '** CODE PLAN STATUS = ' WS-CODE-PLAN-STATUS      
              DISPLAY '** DATE PLAN START  = ' WS-DATE-PLAN-START       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
           ADD  +1                         TO WS-COMMIT-ACCTS-CNT.      
      *                                                                 00197600
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00197900
      ******************************************************************00198000
      * 8500-DELETE-CUST-PLAN                                          *00198100
      ******************************************************************00198200
       8500-DELETE-CUST-PLAN.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_PLAN                                 
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        
                 AND IC_NO          = :WS-IC-NO                         
                 AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                
                 AND RATE_ITEM_CODE = :WS-RATE-ITEM-CODE                
                 AND ITEM_SEQ_NO <> :WS-ITEM-SEQ-NO                     
                 AND CODE_PLAN_STATUS = :WS-CODE-PLAN-STATUS            
                 AND LAST_BILL_DATE < DATEADD( MONTH, -6, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     00198500
MFA-TR*       DELETE FROM CSS_CUST_PLAN                                 00198600
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        00198700
MFA-TR*          AND IC_NO          = :WS-IC-NO                         00198800
MFA-TR*          AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                00198900
MFA-TR*          AND RATE_ITEM_CODE = :WS-RATE-ITEM-CODE                00199000
MFA-TR*          AND ITEM_SEQ_NO <> :WS-ITEM-SEQ-NO                     00199100
MFA-TR*          AND CODE_PLAN_STATUS = :WS-CODE-PLAN-STATUS            00199200
MFA-TR*          AND LAST_BILL_DATE < CURRENT DATE - 6 MONTHS           00199300
MFA-TR*    END-EXEC.                                                    00199400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              WS-DISPLAY-SQLCODE        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** DELETE ERROR IN 8500                     **'  
              DISPLAY '** RETURN CODE      = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** ACCOUNT_NO       = ' WS-ACCOUNT-NO            
              DISPLAY '** IC NO            = ' WS-IC-NO                 
              DISPLAY '** UTIL TYPE        = ' WS-CODE-UTIL-TYPE        
              DISPLAY '** RATE ITEM CODE   = ' WS-RATE-ITEM-CODE        
              DISPLAY '** ITEM SEQ NO      = ' WS-ITEM-SEQ-NO           
              DISPLAY '** CODE PLAN STATUS = ' WS-CODE-PLAN-STATUS      
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00201500
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00201800
      ***************************************************************** 00201900
      * 8900-ISSUE-COMMIT.                                            * 00202000
      ***************************************************************** 00202100
       8900-ISSUE-COMMIT.                                               
                                                                        
           EXEC SQL                                                     00202400
                INCLUDE CPD00047                                        00202500
           END-EXEC.                                                    00202600
                                                                        
           ADD +1                          TO WS-CHKP-NO.               
      *    DISPLAY 'COMMIT POINT # ' WS-COMMIT-ACCTS-CNT ' TAKEN.'.     00202900
           DISPLAY 'COMMIT POINT # ' WS-CHKP-NO ' TAKEN.'.              
      *                                                                 00203100
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00203400
      ******************************************************************00203500
      **                                                              **00203600
      **  9000-TERMINATE.                                             **00203700
      **       TERMINATION ROUTINE                                    **00203800
      **                                                              **00203900
      ******************************************************************00204000
       9000-TERMINATE.                                                  
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00204500
      ************************************************************      00204600
      *                                                          *      00204700
      * COPYBOOK FOR ABEND ROUTINE                               *      00204800
      *                                                          *      00204900
      ************************************************************      00205000
                                                                        
           EXEC SQL                                                     00205200
               INCLUDE CPD09900                                         00205300
           END-EXEC.                                                    00205400
                                                                        
