       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSLM008.                                      
COB303 DATE-WRITTEN.     DEC 15, 2014.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  12/15/2014    VK7L032     P#0817 SYNC LMS WITH GIS        --         
      *--                SS95855     (CLONE OF CSR04824)             --         
      *--  04/16/2015    VK7L032     MODIFIED THE CURSOR             --         
A05084*--  05/15/2015    VK7L032     MODIFIED THE CURSOR AND REMOVED --         
ACT026*--                            7300 PARA.                      --         
A#5084*--  05/28/2015    SS95855     ACT036 FIX ID CHANGES TRACKING  --         
      *----------------------------------------------------------------         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSLM008.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *  CFDLM08 - FD SECTION & LAYOUT FOR REPORT OUTPUT FILE       *           
      ***************************************************************           
       COPY CFDLM008.                                                           
       COPY FIOLM008.                                                           
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSLM008'.
MSQ017     COPY MFASQLM.
      *                                                                         
      **********************************                                        
      **   DB2 INCLUDES               **                                        
      **********************************                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      **** LMS_EQUIP_INVENTRY, 4D                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEQPINV                                                  
           END-EXEC.                                                            
      *                                                                         
      **** LMS_EQUIP_ENVRNMT, 4F                                                
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEQPIVT                                                  
           END-EXEC.                                                            
      *                                                                         
      **** LMS_FXTR_ATTACHMTS, 4H                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBFXTATC                                                  
           END-EXEC.                                                            
      *                                                                         
      **** LMS_TRANS_HIST, 4J                                                   
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBLGTHST                                                  
           END-EXEC.                                                            
      *                                                                         
      **** LMS_EQUIP_CONTRACT, 4L                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEQPCNT                                                  
           END-EXEC.                                                            
      *                                                                         
      **** LMS_SPCL_AGREEMENT, 4Q                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSPLAGR                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_ACCOUNT, AT                                                      
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      **** CSS_PREMISE, PR                                                      
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      *                                                                         
      **** CSS_UTIL_ENVRNMT, UT                                                 
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_MTRD_ENVRNMT, MN                                                 
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_PIM_POINT, PP                                                    
           EXEC SQL                                                             
              INCLUDE TBPIMPNT                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_CUST_PREM_HIST, CH                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_NAME, DQ                                                         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      **** CSS_NAME_ACCT_XREF, HT                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_ADDR_FORMATTED, DY                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_ZIP_CODE, A4                                                     
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      *                                                                         
      **** CSS_ZIPCODE_SUBDIV, ZS                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBZIPSUB                                                  
           END-EXEC.                                                            
      *                                                                         
      **** LMS_MSTR_STCK_INFO, 4A                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMSTINF                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_LOCAL_OFFICE, B1                                                 
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_SUBDIVISION, B0                                                  
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSUBDVN                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_REV_DISTRICT, A9                                                 
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRVDST                                                   
           END-EXEC.                                                            
      *                                                                         
      **** CSS_JOB_PARM, G6                                                     
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
ACT036**** CSS_APPL_PGM_DESC, K9                                                
ACT036*                                                                         
ACT036     EXEC SQL                                                             
ACT036         INCLUDE TBPGMDSC                                                 
ACT036     END-EXEC.                                                            
ACT036*                                                                         
ACT036**** LMS_TRANS_HIST_DET, 4S                                               
ACT036*                                                                         
ACT036     EXEC SQL                                                             
ACT036         INCLUDE TBLMSHST                                                 
ACT036     END-EXEC.                                                            
      *                                                                         
       01 WS-LITERALS.                                                  
           05 PROGRAM-NAME              PIC X(08) VALUE 'PCSLM008'.     
           05 WS-RECORD-COUNT           PIC 9(9)  VALUE ZEROS.          
           05 WS-1                      PIC 9     VALUE 1.              
           05 WS-FCSLM08-STATUS         PIC X(02) VALUE SPACES.         
              88 LM08-SUCCESSFUL                  VALUE '00'.           
           05 WS-POLE-DESC              PIC X(50) VALUE SPACES.         
           05 WS-POLE-NO                PIC S9(4) COMP VALUE 0.         
           05 WS-YES-NULL               PIC S9(4) VALUE -1.             
           05 WS-COMMAND-CODE           PIC X(04) VALUE 'PARM'.         
           05 WS-COMPANY-NO             PIC X(02) VALUE '01'.           
           05 WS-CURRENT-TIMESTAMP      PIC X(26) VALUE SPACES.         
           05 WS-EQUIP-SEQ              PIC 9(10) VALUE 0.              
           05 WS-PREMISE-NO             PIC 9(10) VALUE 0.              
           05 WS-ACCOUNT-NO             PIC 9(13) VALUE 0.              
ACT026     05 WS-EQUIP-TAG-NO           PIC X(12) VALUE SPACES.         
ACT026     05 WS-INVENTRY-STATUS-CD     PIC X(01) VALUE SPACES.         
ACT036     05 WS-LITE-DTLS-UPDT         PIC X(09) VALUE 'CSR04769'.     
ACT036     05 WS-REPLACE-WIZARD         PIC X(09) VALUE 'CSR04770'.     
      *                                                                         
       01 WS-NULL-INDICATORS.                                           
           05 IND-INSTALL-DT            PIC S9(04) COMP.                
      *                                                                         
      ****************************************************************          
      *  ABEND SWITCH COPYBOOK                                       *          
      ****************************************************************          
      *                                                                         
           COPY CWS00038.                                                       
                                                                        
       01  WS-INPUT-DATA-R8                                             
           REDEFINES  WS-INPUT-DATA-BREAKDOWN.                          
           05  WS-SYSIPT-R25           PIC X(13).                       
               88  LAST-UPD-TMST           VALUE 'LAST-UPD-TMST'.       
           05  FILLER                  PIC X(01).                       
           05  WS-LAST-UPD-TMST        PIC X(26).                       
           05  FILLER                  PIC X(40).                       
      *                                                                         
      ******************************************************************        
      **** ERROR HANDLING (ABEND VARIABLES)                                     
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      **** DB2 AND SQL ERROR CHECKING                                           
           COPY CWS00303.                                                       
      *                                                                         
      **** ABEND ROUTINE (USED WITH CPD09900 INCLUDE MEMBER)                    
           COPY CWS09900.                                                       
      *                                                                         
      **** WOKING STORAGE FOR CPDCA099                                          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE FIOJC01                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * GET EQUIP-SEQ FROM TABLE LMS_TRANS_HIST                        *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE EQUIP_SEQ_CSR CURSOR FOR                          
               SELECT DISTINCT([4J].EQUIP_SEQ)                            
ACT026               ,[4D].EQUIP_TAG_NO                                   
ACT026               ,[4D].INVENTRY_STATUS_CD                             
ACT026               ,[4A].STOCK_DESC                                     
ACT036               ,K9.APPL_PROGRAM_ID                                
ACT036               ,K9.APPL_PROGRAM_DESC                              
                 FROM LMS_TRANS_HIST     [4J] WITH(READUNCOMMITTED)             
ACT026               ,LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)             
ACT026               ,LMS_MSTR_STCK_INFO [4A] WITH(READUNCOMMITTED)             
ACT036               ,CSS_APPL_PGM_DESC  K9 WITH(READUNCOMMITTED)               
                WHERE [4J].TRANS_HIST_SEQ_NO  > CIS.CHAR2TIMESTAMP(
                                                  :4J-TRANS-HIST-SEQ-NO
              )     
                  AND [4J].APPL_PROGRAM_ID IN ('PCSLM100','CSR04768',     
                                             'CSR04769','CSR04770',     
                                             'CSR04771','CSR04776',     
                                             'CSR04777')                
ACT026            AND [4D].EQUIP_SEQ         = [4J].EQUIP_SEQ               
ACT026            AND [4A].COMPANY_NO        = [4D].COMPANY_NO              
ACT026            AND [4A].CODE_SERVICE_TYPE = [4D].CODE_SERVICE_TYPE       
ACT026            AND [4A].STOCK_CD          = [4D].STOCK_CD                
ACT026            AND [4A].EQUIP_TYPE_CD     = [4D].EQUIP_TYPE_CD           
ACT026            AND [4D].EQUIP_TYPE_CD     = 'F'                        
ACT036            AND [4J].APPL_PROGRAM_ID   = K9.APPL_PROGRAM_ID         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE EQUIP_SEQ_CSR CURSOR FOR                                  
MFA-TR*        SELECT DISTINCT(4J.EQUIP_SEQ)                                    
MFA-TR*              ,4D.EQUIP_TAG_NO                                           
MFA-TR*              ,4D.INVENTRY_STATUS_CD                                     
MFA-TR*              ,4A.STOCK_DESC                                             
MFA-TR*              ,K9.APPL_PROGRAM_ID                                        
MFA-TR*              ,K9.APPL_PROGRAM_DESC                                      
MFA-TR*          FROM LMS_TRANS_HIST     4J                                     
MFA-TR*              ,LMS_EQUIP_INVENTRY 4D                                     
MFA-TR*              ,LMS_MSTR_STCK_INFO 4A                                     
MFA-TR*              ,CSS_APPL_PGM_DESC  K9                                     
MFA-TR*         WHERE 4J.TRANS_HIST_SEQ_NO  > :4J-TRANS-HIST-SEQ-NO             
MFA-TR*           AND 4J.APPL_PROGRAM_ID IN ('PCSLM100','CSR04768',             
MFA-TR*                                      'CSR04769','CSR04770',             
MFA-TR*                                      'CSR04771','CSR04776',             
MFA-TR*                                      'CSR04777')                        
MFA-TR*           AND 4D.EQUIP_SEQ         = 4J.EQUIP_SEQ                       
MFA-TR*           AND 4A.COMPANY_NO        = 4D.COMPANY_NO                      
MFA-TR*           AND 4A.CODE_SERVICE_TYPE = 4D.CODE_SERVICE_TYPE               
MFA-TR*           AND 4A.STOCK_CD          = 4D.STOCK_CD                        
MFA-TR*           AND 4A.EQUIP_TYPE_CD     = 4D.EQUIP_TYPE_CD                   
MFA-TR*           AND 4D.EQUIP_TYPE_CD     = 'F'                                
MFA-TR*           AND 4J.APPL_PROGRAM_ID   = K9.APPL_PROGRAM_ID                 
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE         THRU  0100-EXIT.             
                                                                        
           PERFORM 1000-PROCESS            THRU  1000-EXIT.             
                                                                        
           PERFORM 9000-TERMINATE          THRU  9000-EXIT.             
      *                                                                         
           DISPLAY '***********************************************'.   
           DISPLAY '* LAST UPD TS : ' WS-LAST-UPD-TMST.                 
           DISPLAY '* TOTAL RECORDS EXTRACTED ' WS-RECORD-COUNT.        
           DISPLAY '***********************************************'.   
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           OPEN OUTPUT FCSLM008-FILE.                                   
                                                                        
           IF LM08-SUCCESSFUL                                           
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSLM008 *****************'             
              DISPLAY '**  0100-INITIALIZE              **'             
              DISPLAY '**  ERROR ON FCSLM08 OUTPUT FILE  **'            
              DISPLAY '**  FILE STATUS = ' WS-FCSLM08-STATUS            
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           MOVE SPACES                      TO WS-SYSIPT.               
           MOVE PROGRAM-NAME                TO WS-PROGRAM.              
           MOVE WS-COMMAND-CODE             TO WS-COMMAND.              
           PERFORM 7600-START-FCSJC01          THRU 7600-EXIT.          
           PERFORM 7610-READ-FCSJC01           THRU 7610-EXIT UNTIL     
              (WS-INPUT-DATA-BREAKDOWN(1:13) = 'LAST-UPD-TMST')         
              OR END-OF-SYSIPT.                                         
                                                                        
              IF WS-LAST-UPD-TMST(1:4) NUMERIC AND                      
                 WS-LAST-UPD-TMST(6:2) NUMERIC AND                      
                 WS-LAST-UPD-TMST(9:2) NUMERIC                          
                 MOVE G6-PARM-DATA          TO WS-INPUT-DATA-BREAKDOWN  
                 PERFORM 7611-CLOSE            THRU 7611-EXIT           
              ELSE                                                      
                 DISPLAY '******** PCSLM008 *****************'          
                 DISPLAY '**  0100-INITIALIZE              **'          
                 DISPLAY '** ' PROGRAM-NAME ' PROCESSING ERROR '        
                 DISPLAY '**      PROCESSING TERMINATED '               
                 DISPLAY ' WS-LAST-UPD-TMST ' WS-LAST-UPD-TMST          
                 PERFORM 9900-ABEND               THRU 9900-EXIT        
              END-IF.                                                   
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS.                                                **        
      ******************************************************************        
       1000-PROCESS.                                                    
      *                                                                         
           MOVE WS-LAST-UPD-TMST            TO 4J-TRANS-HIST-SEQ-NO.    
      *                                                                         
           PERFORM 7000-OPEN-EQUIP-SEQ-CSR     THRU 7000-EXIT.          
      *                                                                         
           PERFORM 7100-FETCH-EQUIP-SEQ-CSR    THRU 7100-EXIT.          
      *                                                                         
           PERFORM 2000-PROCESS-FIXTURE-INFO   THRU 2000-EXIT           
               UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.             
      *                                                                         
           PERFORM 7200-CLOSE-EQUIP-SEQ-CSR    THRU 7200-EXIT.          
      *                                                                         
           PERFORM 2600-PROCESS-UPD-JOB-PARM   THRU 2600-EXIT.          
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS FIXTURE INVENTORY INFO,CUSTOMER INFO,CONTRACT INFO,  **        
      ** ATTACHMENTS INFO (POLE & NODE)                               **        
      ** 2000-PROCESS-FIXTURE-INFO                                    **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-FIXTURE-INFO.                                       
      *                                                                         
ACT026     MOVE 4D-EQUIP-TAG-NO             TO WS-EQUIP-TAG-NO.         
ACT026     MOVE 4D-INVENTRY-STATUS-CD       TO WS-INVENTRY-STATUS-CD.   
      *                                                                         
           INITIALIZE DCLLMS-EQUIP-INVENTRY                             
                      FIOLM08-REC                                       
                      DCLLMS-EQUIP-ENVRNMT                              
                      DCLCSS-NAME                                       
                      DCLCSS-PREMISE                                    
                      DCLCSS-ADDR-FORMATTED                             
                      DCLCSS-ZIP-CODE                                   
                      DCLCSS-ZIPCODE-SUBDIV.                            
      *                                                                         
      **** GET FIXTURE INVENTORY                                                
           MOVE 4J-EQUIP-SEQ                TO WS-EQUIP-SEQ             
                                               4D-EQUIP-SEQ             
                                               4F-EQUIP-SEQ.            
           MOVE 4A-STOCK-DESC               TO E-LM08-FXTR-DESC.        
ACT026     MOVE WS-EQUIP-TAG-NO             TO E-LM08-FXTR-TAG-NO.      
ACT026     MOVE WS-INVENTRY-STATUS-CD       TO E-LM08-FXTR-INV-STATUS.  
      *                                                                         
      **** GET FIXTURE EXNVIRONMENT                                             
ACT026     IF WS-INVENTRY-STATUS-CD = 'J'                               
              PERFORM 7400-FXTR-ENVRNMNT-DATA   THRU 7400-EXIT          
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 AND 4F-BILLING-FL NOT EQUAL 'Z'                        
                 PERFORM 2100-PROCESS-FIXTURE-ATTR                      
                                                THRU 2100-EXIT          
                 PERFORM 2400-MOVE-RESULT-FXTR  THRU 2400-EXIT          
              END-IF                                                    
           ELSE                                                         
              PERFORM 2400-MOVE-RESULT-FXTR     THRU 2400-EXIT          
           END-IF.                                                      
      *                                                                         
           PERFORM 7100-FETCH-EQUIP-SEQ-CSR    THRU 7100-EXIT.          
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS FIXTURE ATTRIBUTES: LOCATION INO, CONTRACT INFO AND  **        
      ** ATTACHMENTS INFO (POLE & NODE)                               **        
      ** 2100-PROCESS-FIXTURE-ATTR                                    **        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-FIXTURE-ATTR.                                       
      *                                                                         
           MOVE 4F-RATE-PLAN-NO             TO E-LM08-FXTR-RATE-PLAN.   
      *                                                                         
           MOVE SPACES                      TO 4D-EQUIP-TAG-NO.         
           MOVE SPACES                      TO 4A-STOCK-DESC.           
           MOVE 4D-EQUIP-SEQ                TO 4H-FXTR-EQUIP-SEQ.       
           PERFORM 7500-GET-POLE-STOCK-INFO    THRU 7500-EXIT.          
      *                                                                         
           MOVE 4D-EQUIP-TAG-NO             TO E-LM08-POLE-NO.          
           MOVE 4A-STOCK-DESC               TO E-LM08-POLE-DESC.        
      *                                                                         
           EVALUATE 4F-INSTALL-LOC-CD                                   
               WHEN 'P'                                                 
                 PERFORM 2200-PROCESS-PREMISE  THRU 2200-EXIT           
               WHEN 'S'                                                 
                 PERFORM 2300-PROCESS-SUB-DIV  THRU 2300-EXIT           
           END-EVALUATE.                                                
      *                                                                         
           MOVE B0-SUBDIVISION-ID           TO E-LM08-SUBDIV-ID.        
           MOVE B0-SUBDIVISION-DESC         TO E-LM08-SUBDIV-DESC.      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS FIXTURE LOCATION INFO USING PREMISE NO               **        
      ** 2200-PROCESS-PREMISE.                                        **        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-PREMISE.                                            
      *                                                                         
           INITIALIZE WS-CPD00099-WORK                                  
                      UT-CODE-REVENUE-CLASS                             
                      B0-SUBDIVISION-ID                                 
                      A9-REV-DISTRICT-CD                                
                      PP-AREA-ID                                        
                      PP-TAG-NM.                                        
      *                                                                         
           MOVE 4F-INSTALL-LOC-NO        TO WS-CPD99-PREMISE-NO.        
           PERFORM 6990-FETCH-CUR-ACCOUNT   THRU 6990-EXIT.             
                                                                        
           MOVE WS-CPD99-PREMISE-NO      TO PR-PREMISE-NO               
                                            WS-PREMISE-NO.              
           PERFORM 7700-GET-PREMISE-DET     THRU 7700-EXIT.             
      *                                                                         
           MOVE PR-SUBDIVISION-ID        TO B0-SUBDIVISION-ID.          
           PERFORM 7710-GET-SUBDIV-DESC     THRU 7710-EXIT.             
      *                                                                         
           MOVE PR-REV-DISTRICT-CD       TO A9-REV-DISTRICT-CD.         
           PERFORM 7720-GET-REVDIST-DESC    THRU 7720-EXIT.             
      *                                                                         
           MOVE WS-CPD99-ACCOUNT-NO      TO AT-ACCOUNT-NO               
                                            HT-ACCOUNT-NO               
                                            WS-ACCOUNT-NO.              
           PERFORM 7730-GET-ACCOUNT-DTL     THRU 7730-EXIT.             
           PERFORM 7740-GET-CUSTOMER-NAME   THRU 7740-EXIT.             
      *                                                                         
           MOVE AT-LOCAL-OFFICE          TO B1-LOCAL-OFFICE.            
           PERFORM 7750-GET-LOC-OFFC-DESC   THRU 7750-EXIT.             
      *                                                                         
           MOVE PR-ADDRESS-ID            TO DY-ADDRESS-ID.              
           PERFORM 7760-GET-FRMTD-ADDR      THRU 7760-EXIT.             
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS FIXTURE LOCATION INFO USING SUB DIVISION             **        
      ** 2300-PROCESS-SUB-DIV.                                        **        
      ******************************************************************        
      *                                                                         
       2300-PROCESS-SUB-DIV.                                            
      *                                                                         
           MOVE 4F-INSTALL-LOC-NO(1:3)      TO ZS-SUBDIVISION-ID.       
           PERFORM 7800-GET-SUBDIV-DATA        THRU 7800-EXIT.          
      *                                                                         
           MOVE ZS-REV-DISTRICT-CD          TO B0-SUBDIVISION-ID.       
           PERFORM 7710-GET-SUBDIV-DESC        THRU 7710-EXIT.          
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE & SEND FIXTURE RESULT SET                               **        
      ** 2400-MOVE-RESULT-FXTR                                        **        
      ******************************************************************        
      *                                                                         
       2400-MOVE-RESULT-FXTR.                                           
      *                                                                         
           IF WS-INVENTRY-STATUS-CD = 'J'                               
              IF 4F-INSTALL-LOC-CD = 'P'                                
                 MOVE AT-CUSTOMER-NO        TO E-LM08-CUSTOMER-NO       
                 MOVE WS-CPD99-ACCOUNT-NO   TO E-LM08-ACCOUNT-NO        
                 MOVE WS-CPD99-PREMISE-NO   TO E-LM08-PREMISE-NO        
                 MOVE AT-ACCOUNT-TYPE-CODE  TO E-LM08-ACCOUNT-TYPE      
                 MOVE DQ-FULL-NAME          TO E-LM08-CUSTOMER-NAME     
                 MOVE AT-LOCAL-OFFICE       TO E-LM08-LOC-OFFC          
                 MOVE B1-LOCAL-OFFICE-DESC  TO E-LM08-LOC-OFFC-DESC     
                 MOVE PR-REV-DISTRICT-CD    TO E-LM08-REV-DIST-ID       
                 MOVE A9-REV-DISTRICT-DESC  TO E-LM08-REV-DIST-DESC     
                 MOVE DY-HOUSE-NO           TO E-LM08-HOUSE-NO          
                 MOVE DY-ADDR-PREFIX-1      TO E-LM08-ADDR-PRFX1        
                 MOVE DY-ADDR-PREFIX-2      TO E-LM08-ADDR-PRFX2        
                 MOVE DY-STREET-NAME        TO E-LM08-STREET-NAME       
                 MOVE DY-STREET-LOCATION-1  TO E-LM08-STREET-LOC1       
                 MOVE DY-STREET-LOCATION-2  TO E-LM08-STREET-LOC2       
                 MOVE DY-STREET-SUFFIX      TO E-LM08-STREET-SFX        
                 MOVE DY-ADDRESS-OVERFLOW   TO E-LM08-ADDRESS-OVR       
                 MOVE DY-ZIP-CODE           TO E-LM08-ZIP-CODE          
                 MOVE DY-ZIP-CODE-PLUS-FOUR TO E-LM08-ZIP-CODE-4        
                 MOVE DY-ZIP-CODE-TOKEN     TO E-LM08-ZIP-CODE-TKN      
                 MOVE DY-ADDR-SUFFIX        TO E-LM08-ADDR-SFX          
                 MOVE A4-TOWN               TO E-LM08-TOWN              
                 MOVE A4-STATE              TO E-LM08-STATE             
ACT036           IF K9-APPL-PROGRAM-ID EQUAL ( WS-LITE-DTLS-UPDT OR     
ACT036                                         WS-REPLACE-WIZARD )      
ACT036              PERFORM 7300-GET-PRV-CURR-TAG-NOS THRU 7300-EXIT    
ACT036              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
ACT036                 MOVE K9-APPL-PROGRAM-DESC TO E-LM08-DESCRIPTION  
ACT036                 MOVE 4S-PRV-COLUMN-VALUE-TEXT                    
ACT036                                           TO E-LM08-OLD-TAG-NO   
ACT036                 MOVE 4S-CHG-COLUMN-VALUE-TEXT                    
ACT036                                           TO E-LM08-NEW-TAG-NO   
ACT036              END-IF                                              
ACT036           END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 8000-WRITE-FCSLM08          THRU 8000-EXIT.          
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET ADDRESS USING PREMISE ADDR ID                            **        
      ** 2600-PROCESS-UPD-JOB-PARM                                    **        
      ******************************************************************        
      *                                                                         
       2600-PROCESS-UPD-JOB-PARM.                                       
      *                                                                         
           PERFORM 7900-GET-CURR-TS            THRU 7900-EXIT.          
      *                                                                         
           MOVE WS-CURRENT-TIMESTAMP        TO WS-LAST-UPD-TMST.        
           MOVE WS-INPUT-DATA-R8            TO G6-PARM-DATA.            
           MOVE PROGRAM-NAME                TO G6-PROGRAM-NAME.         
           MOVE WS-COMMAND-CODE             TO G6-CMND-CODE.            
           MOVE WS-COMPANY-NO               TO G6-COMPANY-NO.           
      *                                                                         
           PERFORM 8100-UPDATE-JOB-PARM        THRU 8100-EXIT.          
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 6990-FETCH-CUR-ACCOUNT                                       **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00099                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** 6995-CPD99-ERROR-ROUTINE                                     **        
      ******************************************************************        
      *                                                                         
       6995-CPD99-ERROR-ROUTINE.                                        
      *                                                                         
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM.           
           MOVE WS-CPD99-RETURN-CODE        TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           DISPLAY '******** PCSLM008 ***********'                      
           DISPLAY '**  6995-CPD99-ERROR-ROUTINE**'                     
           DISPLAY ' WS-CPD99-RETURN-CODE: ' WS-ACTIVE-RETURN-CODE.     
           DISPLAY ' WS-CPD99-PREMISE-NO : ' WS-CPD99-PREMISE-NO.       
           DISPLAY '**  PROCESSING TERMINATED  **'                      
           PERFORM 9900-ABEND            THRU 9900-EXIT.                
      *                                                                         
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7000-OPEN-EQUIP-SEQ-CSR                                        *        
      *                                                                *        
      ******************************************************************        
       7000-OPEN-EQUIP-SEQ-CSR.                                         
      **                                                                        
           EXEC SQL                                                     
              OPEN EQUIP_SEQ_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSLM008 ***********'                   
              DISPLAY '**  7000-OPEN-EQUIP-SEQ-CSR **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  TRANS-HIST-SEQ-NO: ' 4J-TRANS-HIST-SEQ-NO    
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7100-FETCH-EQUIP-SEQ-CSR                                       *        
      *                                                                *        
      ******************************************************************        
       7100-FETCH-EQUIP-SEQ-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH EQUIP_SEQ_CSR                                       
               INTO :4J-EQUIP-SEQ                                       
ACT026             ,:4D-EQUIP-TAG-NO                                    
ACT026             ,:4D-INVENTRY-STATUS-CD                              
ACT026             ,:4A-STOCK-DESC                                      
ACT036             ,:K9-APPL-PROGRAM-ID                                 
ACT036             ,:K9-APPL-PROGRAM-DESC                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND                                              
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSLM008 ***********'                   
              DISPLAY '**  7100-FETCH-EQUIP-SEQ-CSR**'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  TRANS-HIST-SEQ-NO: ' 4J-TRANS-HIST-SEQ-NO    
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7200-CLOSE-EQUIP-SEQ-CSR                                       *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7200-CLOSE-EQUIP-SEQ-CSR.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE EQUIP_SEQ_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSLM008 ***********'                   
              DISPLAY '**  7200-CLOSE-EQUIP-SEQ-CSR**'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  TRANS-HIST-SEQ-NO: ' 4J-TRANS-HIST-SEQ-NO    
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
ACT036*                                                                         
ACT036******************************************************************        
ACT036**  GET PRV TAG NO AND CURR TAG NO DURING UPDATE                **        
ACT036**  7300-GET-PRV-CURR-TAG-NOS.                                  **        
ACT036******************************************************************        
ACT036*                                                                         
ACT036 7300-GET-PRV-CURR-TAG-NOS.                                       
ACT036*                                                                         
ACT036     EXEC SQL                                                     
ACT036        SELECT TOP(1) [4S].PRV_COLUMN_VALUE,
              [4S].CHG_COLUMN_VALUE                               
ACT036          INTO :4S-PRV-COLUMN-VALUE                               
ACT036              ,:4S-CHG-COLUMN-VALUE                               
ACT036          FROM LMS_TRANS_HIST [4J] WITH(READUNCOMMITTED)                  
ACT036              ,LMS_TRANS_HIST_DET [4S] WITH(READUNCOMMITTED)              
ACT036         WHERE [4J].EQUIP_SEQ         = :4J-EQUIP-SEQ               
ACT036           AND [4J].EQUIP_SEQ         = [4S].EQUIP_SEQ                
ACT036           AND [4J].TRANS_HIST_SEQ_NO = [4S].TRANS_HIST_SEQ_NO        
ACT036           AND [4J].APPL_PROGRAM_ID   = :K9-APPL-PROGRAM-ID         
ACT036           AND [4S].COLUMN_DESC       = 'FXTR_EQUIP_TAG_NO'         
ACT036           ORDER BY [4J].TRANS_HIST_SEQ_NO DESC                     
ACT036                                              
ACT036                                                           
ACT036                                                      
ACT036     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  4S.PRV_COLUMN_VALUE                                       
MFA-TR*              ,4S.CHG_COLUMN_VALUE                                       
MFA-TR*         INTO :4S-PRV-COLUMN-VALUE                                       
MFA-TR*             ,:4S-CHG-COLUMN-VALUE                                       
MFA-TR*         FROM LMS_TRANS_HIST 4J                                          
MFA-TR*             ,LMS_TRANS_HIST_DET 4S                                      
MFA-TR*        WHERE 4J.EQUIP_SEQ         = :4J-EQUIP-SEQ                       
MFA-TR*          AND 4J.EQUIP_SEQ         = 4S.EQUIP_SEQ                        
MFA-TR*          AND 4J.TRANS_HIST_SEQ_NO = 4S.TRANS_HIST_SEQ_NO                
MFA-TR*          AND 4J.APPL_PROGRAM_ID   = :K9-APPL-PROGRAM-ID                 
MFA-TR*          AND 4S.COLUMN_DESC       = 'FXTR_EQUIP_TAG_NO'                 
MFA-TR*          ORDER BY 4J.TRANS_HIST_SEQ_NO DESC                             
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT036*                                                                         
ACT036     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT036*                                                                         
ACT036     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT036        OR NOT-FOUND                                              
ACT036        CONTINUE                                                  
ACT036     ELSE                                                         
ACT036        DISPLAY '******** PCSLM008 ***********'                   
ACT036        DISPLAY '**  7300-GET-PRV-CURR-TAG-NOS'                   
ACT036        DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
ACT036        DISPLAY '**  EQUIP_SEQ   = ' WS-EQUIP-SEQ                 
ACT036        DISPLAY '**  APPL_PROGRAM_ID = ' K9-APPL-PROGRAM-ID       
ACT036        DISPLAY '**  PROCESSING TERMINATED  **'                   
ACT036        PERFORM 9900-ABEND            THRU 9900-EXIT              
ACT036     END-IF.                                                      
ACT036*                                                                         
ACT036 7300-EXIT.                                                       
ACT036     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  EQUIPMENT ENVIRONMENT DATA                                  **        
      **  7400-FXTR-ENVRNMNT-DATA                                     **        
      ******************************************************************        
      *                                                                         
       7400-FXTR-ENVRNMNT-DATA.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT  [4F].INSTALL_LOC_NO                                 
                     ,[4F].INSTALL_LOC_CD                                 
                     ,[4F].RATE_PLAN_NO                                   
                     ,[4F].BILLING_FL                                     
                INTO :4F-INSTALL-LOC-NO                                 
                    ,:4F-INSTALL-LOC-CD                                 
                    ,:4F-RATE-PLAN-NO                                   
                    ,:4F-BILLING-FL                                     
                FROM LMS_EQUIP_ENVRNMT  [4F] WITH(READUNCOMMITTED)              
               WHERE [4F].EQUIP_SEQ = :4F-EQUIP-SEQ                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  4F.INSTALL_LOC_NO                                         
MFA-TR*              ,4F.INSTALL_LOC_CD                                         
MFA-TR*              ,4F.RATE_PLAN_NO                                           
MFA-TR*              ,4F.BILLING_FL                                             
MFA-TR*         INTO :4F-INSTALL-LOC-NO                                         
MFA-TR*             ,:4F-INSTALL-LOC-CD                                         
MFA-TR*             ,:4F-RATE-PLAN-NO                                           
MFA-TR*             ,:4F-BILLING-FL                                             
MFA-TR*         FROM LMS_EQUIP_ENVRNMT  4F                                      
MFA-TR*        WHERE 4F.EQUIP_SEQ = :4F-EQUIP-SEQ                               
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND                                              
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSLM008 ***********'                   
              DISPLAY '**  7400-FXTR-ENVRNMNT-DATA**'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  EQUIP_SEQ   = ' WS-EQUIP-SEQ                 
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7500-GET-POLE-STOCK-INFO.                                    *        
      ******************************************************************        
      *                                                                         
       7500-GET-POLE-STOCK-INFO.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) [4D].EQUIP_TAG_NO,
              [4A].STOCK_DESC                                     
                INTO :4D-EQUIP-TAG-NO                                   
                    ,:4A-STOCK-DESC                                     
                FROM LMS_FXTR_ATTACHMTS [4H] WITH(READUNCOMMITTED)              
                    ,LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)              
                    ,LMS_MSTR_STCK_INFO [4A] WITH(READUNCOMMITTED)              
               WHERE [4H].FXTR_EQUIP_SEQ     = :4H-FXTR-EQUIP-SEQ         
                 AND [4H].EQUIP_TYPE_CD      = 'P'                        
                 AND [4D].EQUIP_SEQ          = [4H].ATTACH_EQUIP_SEQ        
                 AND [4D].EQUIP_TYPE_CD      = [4H].EQUIP_TYPE_CD           
                 AND [4D].INVENTRY_STATUS_CD = 'J'                        
                 AND [4A].COMPANY_NO         = [4D].COMPANY_NO              
                 AND [4A].CODE_SERVICE_TYPE  = [4D].CODE_SERVICE_TYPE       
                 AND [4A].STOCK_CD           = [4D].STOCK_CD                
                 AND [4A].EQUIP_TYPE_CD      = [4D].EQUIP_TYPE_CD           
               ORDER BY [4H].ATTACH_SEQ_NO                                
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  4D.EQUIP_TAG_NO                                           
MFA-TR*              ,4A.STOCK_DESC                                             
MFA-TR*         INTO :4D-EQUIP-TAG-NO                                           
MFA-TR*             ,:4A-STOCK-DESC                                             
MFA-TR*         FROM LMS_FXTR_ATTACHMTS 4H                                      
MFA-TR*             ,LMS_EQUIP_INVENTRY 4D                                      
MFA-TR*             ,LMS_MSTR_STCK_INFO 4A                                      
MFA-TR*        WHERE 4H.FXTR_EQUIP_SEQ     = :4H-FXTR-EQUIP-SEQ                 
MFA-TR*          AND 4H.EQUIP_TYPE_CD      = 'P'                                
MFA-TR*          AND 4D.EQUIP_SEQ          = 4H.ATTACH_EQUIP_SEQ                
MFA-TR*          AND 4D.EQUIP_TYPE_CD      = 4H.EQUIP_TYPE_CD                   
MFA-TR*          AND 4D.INVENTRY_STATUS_CD = 'J'                                
MFA-TR*          AND 4A.COMPANY_NO         = 4D.COMPANY_NO                      
MFA-TR*          AND 4A.CODE_SERVICE_TYPE  = 4D.CODE_SERVICE_TYPE               
MFA-TR*          AND 4A.STOCK_CD           = 4D.STOCK_CD                        
MFA-TR*          AND 4A.EQUIP_TYPE_CD      = 4D.EQUIP_TYPE_CD                   
MFA-TR*        ORDER BY 4H.ATTACH_SEQ_NO                                        
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSLM008 ***********'                   
              DISPLAY '**  7500-GET-POLE-STOCK-INFO     **'             
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  FXTR_EQUIP_SEQ = ' WS-EQUIP-SEQ              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * *                                                                       
      * 7600-START-FCSJC01                                           *          
      ****************************************************************          
                                                                        
            EXEC SQL                                                            
               INCLUDE CPD00038                                                 
            END-EXEC.                                                           
      *                                                                         
      ******************************************************************        
      ** PREMISE DATA                                                 **        
      ******************************************************************        
      *                                                                         
       7700-GET-PREMISE-DET.                                            
      *                                                                         
           EXEC SQL                                                     
             SELECT  PR.SUBDIVISION_ID                                  
                    ,PR.ADDRESS_ID                                      
                    ,PR.REV_DISTRICT_CD                                 
               INTO :PR-SUBDIVISION-ID                                  
                   ,:PR-ADDRESS-ID                                      
                   ,:PR-REV-DISTRICT-CD                                 
               FROM CSS_PREMISE  PR WITH(READUNCOMMITTED)                       
              WHERE PR.PREMISE_NO = :PR-PREMISE-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  PR.SUBDIVISION_ID                                          
MFA-TR*             ,PR.ADDRESS_ID                                              
MFA-TR*             ,PR.REV_DISTRICT_CD                                         
MFA-TR*        INTO :PR-SUBDIVISION-ID                                          
MFA-TR*            ,:PR-ADDRESS-ID                                              
MFA-TR*            ,:PR-REV-DISTRICT-CD                                         
MFA-TR*        FROM CSS_PREMISE  PR                                             
MFA-TR*       WHERE PR.PREMISE_NO = :PR-PREMISE-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7700                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSLM008 ***********'                   
              DISPLAY '**  7700-GET-PREMISE-DET   **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PREMISE_NO  = ' WS-PREMISE-NO                
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7710-GET-SUBDIV-DESC.                                       **        
      ******************************************************************        
      *                                                                         
       7710-GET-SUBDIV-DESC.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT B0.SUBDIVISION_DESC                                
                INTO :B0-SUBDIVISION-DESC                               
                FROM CSS_SUBDIVISION   B0 WITH(READUNCOMMITTED)                 
               WHERE B0.SUBDIVISION_ID = :B0-SUBDIVISION-ID             
                 AND B0.COMPANY_NO     = '01'                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT B0.SUBDIVISION_DESC                                        
MFA-TR*         INTO :B0-SUBDIVISION-DESC                                       
MFA-TR*         FROM CSS_SUBDIVISION   B0                                       
MFA-TR*        WHERE B0.SUBDIVISION_ID = :B0-SUBDIVISION-ID                     
MFA-TR*          AND B0.COMPANY_NO     = '01'                                   
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7710                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSLM008 ***********'                   
              DISPLAY '**  7710-GET-SUBDIV-DESC   **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  SUBDIVISION_ID = ' B0-SUBDIVISION-ID         
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET REVENUE DISTRICE DESCRIPTION.                            **        
      ******************************************************************        
      *                                                                         
       7720-GET-REVDIST-DESC.                                           
      *                                                                         
           EXEC SQL                                                     
             SELECT A9.REV_DISTRICT_DESC                                
               INTO :A9-REV-DISTRICT-DESC                               
               FROM CSS_REV_DISTRICT  A9 WITH(READUNCOMMITTED)                  
              WHERE A9.REV_DISTRICT_CD = :A9-REV-DISTRICT-CD            
                AND A9.COMPANY_NO      = '01'                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT A9.REV_DISTRICT_DESC                                        
MFA-TR*        INTO :A9-REV-DISTRICT-DESC                                       
MFA-TR*        FROM CSS_REV_DISTRICT  A9                                        
MFA-TR*       WHERE A9.REV_DISTRICT_CD = :A9-REV-DISTRICT-CD                    
MFA-TR*         AND A9.COMPANY_NO      = '01'                                   
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7720                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSLM008 ***********'                   
              DISPLAY '**  7720-GET-REVDIST-DESC  **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  REV-DISTRICT-CD = ' A9-REV-DISTRICT-CD       
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7720-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7730-GET-ACCOUNT-DTL.                                       **        
      ******************************************************************        
      *                                                                         
       7730-GET-ACCOUNT-DTL.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT  AT.CUSTOMER_NO                                    
                     ,AT.LOCAL_OFFICE                                   
                     ,AT.ACCOUNT_TYPE_CODE                              
                INTO :AT-CUSTOMER-NO                                    
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-ACCOUNT-TYPE-CODE                              
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,AT.ACCOUNT_TYPE_CODE                                      
MFA-TR*         INTO :AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7730                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSLM008 ***********'                   
              DISPLAY '**  7730-GET-ACCOUNT-DTL   **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  ACCOUNT_NO  = ' WS-ACCOUNT-NO                
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7730-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET CUSTOMER NAME                                            **        
      ******************************************************************        
      *                                                                         
       7740-GET-CUSTOMER-NAME.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                CASE WHEN DQ.NAME_FORMAT = 'B' THEN DQ.FULL_NAME        
                ELSE CIS.CHAR2$CHAR(LTRIM(RTRIM(DQ.LAST_NAME)) + 
           CASE WHEN CIS.SUBSTR3(DQ.FIRST_NAME,1,1)  = ' '         
                     THEN '' ELSE ', '    END + LTRIM(RTRIM(
           DQ.FIRST_NAME)) + CASE WHEN CIS.SUBSTR3(
           DQ.MIDDLE_NAME,1,1) = ' '         
                          THEN '' ELSE ' '     END + LTRIM(RTRIM(
           DQ.MIDDLE_NAME)),70) END                 
                INTO :DQ-FULL-NAME                                      
                FROM  CSS_NAME            DQ WITH(READUNCOMMITTED)              
                     ,CSS_NAME_ACCT_XREF  HT WITH(READUNCOMMITTED)              
               WHERE HT.ACCOUNT_NO        = :HT-ACCOUNT-NO              
                 AND HT.NAME_ID           =  DQ.NAME_ID                 
                 AND DQ.NAME_TYPE         =  'CN'                       
                 AND HT.CUSTOMER_ROLE_CD  =  ' '                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*         CASE WHEN DQ.NAME_FORMAT = 'B' THEN DQ.FULL_NAME                
MFA-TR*         ELSE CHAR(STRIP(DQ.LAST_NAME)       ||                          
MFA-TR*              CASE WHEN SUBSTR(DQ.FIRST_NAME,1,1)  = ' '                 
MFA-TR*              THEN '' ELSE ', '    END  ||                               
MFA-TR*                   STRIP(DQ.FIRST_NAME)           ||                     
MFA-TR*              CASE WHEN SUBSTR(DQ.MIDDLE_NAME,1,1) = ' '                 
MFA-TR*                   THEN '' ELSE ' '     END  ||                          
MFA-TR*                   STRIP(DQ.MIDDLE_NAME),70) END                         
MFA-TR*         INTO :DQ-FULL-NAME                                              
MFA-TR*         FROM  CSS_NAME            DQ                                    
MFA-TR*              ,CSS_NAME_ACCT_XREF  HT                                    
MFA-TR*        WHERE HT.ACCOUNT_NO        = :HT-ACCOUNT-NO                      
MFA-TR*          AND HT.NAME_ID           =  DQ.NAME_ID                         
MFA-TR*          AND DQ.NAME_TYPE         =  'CN'                               
MFA-TR*          AND HT.CUSTOMER_ROLE_CD  =  ' '                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7740                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND                                              
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSLM008 ***********'                   
              DISPLAY '**  7740-GET-CUSTOMER-NAME **'                   
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  ACCOUNT-NO   = ' WS-ACCOUNT-NO               
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7740-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7750-GET-LOC-OFFC-DESC.                                     **        
      ******************************************************************        
      *                                                                         
       7750-GET-LOC-OFFC-DESC.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT B1.LOCAL_OFFICE_DESC                               
                INTO :B1-LOCAL-OFFICE-DESC                              
                FROM CSS_LOCAL_OFFICE  B1 WITH(READUNCOMMITTED)                 
               WHERE B1.LOCAL_OFFICE = :B1-LOCAL-OFFICE                 
                 AND B1.COMPANY_NO   = '01'                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT B1.LOCAL_OFFICE_DESC                                       
MFA-TR*         INTO :B1-LOCAL-OFFICE-DESC                                      
MFA-TR*         FROM CSS_LOCAL_OFFICE  B1                                       
MFA-TR*        WHERE B1.LOCAL_OFFICE = :B1-LOCAL-OFFICE                         
MFA-TR*          AND B1.COMPANY_NO   = '01'                                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7750                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSLM008 ***********'                   
              DISPLAY '**  7750-GET-LOC-OFFC-DESC **'                   
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  LOCAL_OFFICE = ' B1-LOCAL-OFFICE             
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7760-GET-FRMTD-ADDR.                                         **        
      ** GET CUSTOMER ADDRESS                                         **        
      ******************************************************************        
      *                                                                         
       7760-GET-FRMTD-ADDR.                                             
      *                                                                         
           EXEC SQL                                                     
             SELECT  DY.HOUSE_NO                                        
                    ,DY.ADDR_PREFIX_1                                   
                    ,DY.ADDR_PREFIX_2                                   
                    ,DY.STREET_NAME                                     
                    ,DY.STREET_LOCATION_1                               
                    ,DY.STREET_LOCATION_2                               
                    ,DY.STREET_SUFFIX                                   
                    ,DY.ADDRESS_OVERFLOW                                
                    ,DY.CARRIER_ROUTE                                   
                    ,DY.ZIP_CODE                                        
                    ,DY.ZIP_CODE_PLUS_FOUR                              
                    ,DY.ZIP_CODE_TOKEN                                  
                    ,DY.ADDR_SUFFIX                                     
                    ,A4.TOWN                                            
                    ,A4.STATE                                           
               INTO :DY-HOUSE-NO                                        
                   ,:DY-ADDR-PREFIX-1                                   
                   ,:DY-ADDR-PREFIX-2                                   
                   ,:DY-STREET-NAME                                     
                   ,:DY-STREET-LOCATION-1                               
                   ,:DY-STREET-LOCATION-2                               
                   ,:DY-STREET-SUFFIX                                   
                   ,:DY-ADDRESS-OVERFLOW                                
                   ,:DY-CARRIER-ROUTE                                   
                   ,:DY-ZIP-CODE                                        
                   ,:DY-ZIP-CODE-PLUS-FOUR                              
                   ,:DY-ZIP-CODE-TOKEN                                  
                   ,:DY-ADDR-SUFFIX                                     
                   ,:A4-TOWN                                            
                   ,:A4-STATE                                           
               FROM  CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)                
                    ,CSS_ZIP_CODE       A4 WITH(READUNCOMMITTED)                
              WHERE DY.ADDRESS_ID      = :DY-ADDRESS-ID                 
                AND DY.ZIP_CODE        =  A4.ZIP_CODE                   
                AND DY.ZIP_CODE_TOKEN  =  A4.ZIP_CODE_TOKEN             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  DY.HOUSE_NO                                                
MFA-TR*             ,DY.ADDR_PREFIX_1                                           
MFA-TR*             ,DY.ADDR_PREFIX_2                                           
MFA-TR*             ,DY.STREET_NAME                                             
MFA-TR*             ,DY.STREET_LOCATION_1                                       
MFA-TR*             ,DY.STREET_LOCATION_2                                       
MFA-TR*             ,DY.STREET_SUFFIX                                           
MFA-TR*             ,DY.ADDRESS_OVERFLOW                                        
MFA-TR*             ,DY.CARRIER_ROUTE                                           
MFA-TR*             ,DY.ZIP_CODE                                                
MFA-TR*             ,DY.ZIP_CODE_PLUS_FOUR                                      
MFA-TR*             ,DY.ZIP_CODE_TOKEN                                          
MFA-TR*             ,DY.ADDR_SUFFIX                                             
MFA-TR*             ,A4.TOWN                                                    
MFA-TR*             ,A4.STATE                                                   
MFA-TR*        INTO :DY-HOUSE-NO                                                
MFA-TR*            ,:DY-ADDR-PREFIX-1                                           
MFA-TR*            ,:DY-ADDR-PREFIX-2                                           
MFA-TR*            ,:DY-STREET-NAME                                             
MFA-TR*            ,:DY-STREET-LOCATION-1                                       
MFA-TR*            ,:DY-STREET-LOCATION-2                                       
MFA-TR*            ,:DY-STREET-SUFFIX                                           
MFA-TR*            ,:DY-ADDRESS-OVERFLOW                                        
MFA-TR*            ,:DY-CARRIER-ROUTE                                           
MFA-TR*            ,:DY-ZIP-CODE                                                
MFA-TR*            ,:DY-ZIP-CODE-PLUS-FOUR                                      
MFA-TR*            ,:DY-ZIP-CODE-TOKEN                                          
MFA-TR*            ,:DY-ADDR-SUFFIX                                             
MFA-TR*            ,:A4-TOWN                                                    
MFA-TR*            ,:A4-STATE                                                   
MFA-TR*        FROM  CSS_ADDR_FORMATTED DY                                      
MFA-TR*             ,CSS_ZIP_CODE       A4                                      
MFA-TR*       WHERE DY.ADDRESS_ID      = :DY-ADDRESS-ID                         
MFA-TR*         AND DY.ZIP_CODE        =  A4.ZIP_CODE                           
MFA-TR*         AND DY.ZIP_CODE_TOKEN  =  A4.ZIP_CODE_TOKEN                     
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7760                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND                                              
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSLM008 ***********'                   
              DISPLAY '**  7760-GET-FRMTD-ADDR    **'                   
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  ACCOUNT-NO   = ' WS-ACCOUNT-NO               
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7760-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET SUB DIVISION ZIP CODE DATA                               **        
      ******************************************************************        
      *                                                                         
       7800-GET-SUBDIV-DATA.                                            
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) ZS.REV_DISTRICT_CD,
              ZS.ZIP_CODE                                        
               INTO :ZS-REV-DISTRICT-CD                                 
                   ,:ZS-ZIP-CODE                                        
               FROM CSS_ZIPCODE_SUBDIV  ZS WITH(READUNCOMMITTED)                
              WHERE ZS.SUBDIVISION_ID = :ZS-SUBDIVISION-ID              
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  ZS.REV_DISTRICT_CD                                         
MFA-TR*             ,ZS.ZIP_CODE                                                
MFA-TR*        INTO :ZS-REV-DISTRICT-CD                                         
MFA-TR*            ,:ZS-ZIP-CODE                                                
MFA-TR*        FROM CSS_ZIPCODE_SUBDIV  ZS                                      
MFA-TR*       WHERE ZS.SUBDIVISION_ID = :ZS-SUBDIVISION-ID                      
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*     QUERYNO 7800                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSLM008 ***********'                   
              DISPLAY '**  7800-GET-SUBDIV-DATA   **'                   
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  SUBDIVISION_ID = ' ZS-SUBDIVISION-ID         
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7900-GET-CURR-TS.                                              *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7900-GET-CURR-TS.                                                
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSLM008 ***********'                   
              DISPLAY '**  7900-GET-CURR-TS       **'                   
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** WRITE  - FIXTURE DETAILS                                     **        
      ** 8000-WRITE-FCSLM08                                           **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-FCSLM08.                                              
      *                                                                         
           WRITE FIOLM08-REC.                                           
      *                                                                         
           IF LM08-SUCCESSFUL                                           
              ADD 1                      TO WS-RECORD-COUNT             
           ELSE                                                         
              DISPLAY '******** PCSLM008 ***********'                   
              DISPLAY '**  8000-WRITE-FCSLM08     **'                   
              DISPLAY '**  FILE STATUS: ' WS-FCSLM08-STATUS             
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
        8000-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * UPDATE THE LAST-UPD-TMST IN CSS_JOB_PARM TABLE WITH THE        *        
      * CURRENT TIMESTAMP                                              *        
      * 8100-UPDATE-JOB-PARM                                           *        
      ******************************************************************        
       8100-UPDATE-JOB-PARM.                                            
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_JOB_PARM                                       
                 SET PARM_DATA    = :G6-PARM-DATA                       
               WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                    
                 AND CMND_CODE    = :G6-CMND-CODE                       
                 AND COMPANY_NO   = :G6-COMPANY-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSLM008 ***********'                   
              DISPLAY '**  8100-UPDATE-JOB-PARM   **'                   
              DISPLAY '**  RETURN CODE =' WS-ACTIVE-RETURN-CODE         
              DISPLAY '**  G6-PARM-DATA = ' G6-PARM-DATA                
              DISPLAY '**  G6-PROGRAM-NAME = ' G6-PROGRAM-NAME          
              DISPLAY '**  G6-CMND-CODE    = ' G6-CMND-CODE             
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *                                                              *          
      * 9000-CLOSE-FILES.                                            *          
      ****************************************************************          
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSLM008-FILE.                                         
                                                                        
           IF LM08-SUCCESSFUL                                           
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSLM008 ***********'                   
              DISPLAY '**  9000-TERMINATE         **'                   
              DISPLAY '**  FILE STATUS: ' WS-FCSLM08-STATUS             
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
