       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSLM007.                                            
       DATE-WRITTEN. NOV-2014.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *          WMS - DAILY UPDATE/INSERT MASTER STOCK INFO           *        
      *            I/P - WMS FILE                                      *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                            
      *                                                                         
      *    DATE    INITIALS   COMMENTS                                          
      *  --------  --------   ---------------------------------------           
      *  11/22/14  AD7F921    INITIAL VERSION.                                  
      *                                                                         
      *****************************************************************         
      *****************************************************************         
      *                                                                         
      *                ---- BASIC SEQUENCE STRUCTURE ----                       
      *                                                                         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION                      
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                             
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                            
      *  3000 - 4999  NOT USED                                                  
      *  5000 - 5999  COMMON PROGRAM MODULES                                    
      *  6000 - 6999  COMMON SYSTEM MODULES                                     
      *  7000 - 7999  INPUT MODULES                                             
      *  8000 - 8999  OUTPUT MODULES                                            
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES                      
      *                                                                         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
      *** SELECT STMT FOR INPUT VENDOR FILE                                     
        COPY CSSLM007.                                                          
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *** FD STMT FOR LM007 INPUT FILE                                          
       COPY CFDLM007.                                                           
       COPY FIOLM007.                                                           
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSLM007'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)  VALUE               
           'WORKING STORAGE FOR PCSLM007 STARTS HERE'.                  
                                                                        
       01  WS-INPUT-REC-FMT.                                            
           05 WS-IN-COMPANY-NO         PIC X(02) VALUE SPACES.          
           05 WS-IN-CD-SRV-TYP         PIC X(01) VALUE SPACES.          
           05 WS-IN-STK-CD             PIC X(15) VALUE SPACES.          
           05 WS-IN-STK-DESC           PIC X(50) VALUE SPACES.          
           05 WS-IN-EQ-TYP-CD          PIC X(01) VALUE SPACES.          
           05 WS-IN-EQ-COST-AMT        PIC S9(05)V9(02) USAGE COMP-3    
                                                 VALUE 0.               
           05 FILLER                   PIC X(27) VALUE SPACES.          
                                                                        
       01  WS-EQ-COST-AMT-FMT.                                          
           05 WS-EQ-COST-AMT.                                           
              10 WS-EQ-COST-AMT-INT      PIC 9(05) VALUE 0.             
              10 WS-EQ-COST-AMT-DEC      PIC 9(02) VALUE 0.             
           05 WS-EQ-COST-AMT-NUM         PIC 9(07) VALUE 0.             
           05 WS-EQ-COST-AMT-TXT         PIC X(08) VALUE SPACES.        
                                                                        
       01  WS-MISC.                                                     
           05  WS-PGM-NAME               PIC X(07)   VALUE 'SYSTEM'.    
           05  WS-N                      PIC X(01)   VALUE 'N'.         
           05  WS-FLM07-REC-CNTR         PIC 9(08)   VALUE ZERO.        
           05  WS-FLE07-REC-CNTR         PIC 9(08)   VALUE ZERO.        
           05  WS-UPDATE-REC-CNTR        PIC 9(08)   VALUE ZERO.        
           05  WS-INSERT-REC-CNTR        PIC 9(08)   VALUE ZERO.        
           05  WS-SQL-CODE               PIC -9(9)   VALUE ZERO.        
           05  WS-FLM07-STATUS           PIC X(02).                     
               88  FLM07-SUCCESSFUL                  VALUE '00'.        
               88  FLM07-EOF                         VALUE '10'.        
           05  WS-MORE-DATA-SW           PIC X(01)   VALUE 'Y'.         
               88  NO-MORE-DATA                      VALUE 'N'.         
           05  WS-ERROR-FIL-SW           PIC X(01)   VALUE 'N'.         
               88  ERROR-DATA                        VALUE 'Y'.         
           05  WS-LEN-LMS-EQUP-NO        PIC 9(03)   VALUE 0.           
           05  WS-ERROR-MSG              PIC X(50)   VALUE SPACES.      
      *****************************************************************         
      * SQL COMMUNICATION AREA                                        *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * LMS_MSTR_STCK_INFO 4A                                         *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBMSTINF                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
                                                                        
       01  WS-END                        PIC X(40)  VALUE               
             'WORKING STORAGE FOR PCSLM007 ENDS HERE  '.                
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
                                                                        
           PERFORM 1000-PROCESS-PARA             THRU 1000-EXIT.        
                                                                        
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***********************************************************               
      *                                                        **               
      * 0100-INITIALIZATION.                                   **               
      *      INITIALIZATION ROUTINE                            **               
      *                                                        **               
      ***********************************************************               
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN INPUT FCSLM007-FILE.                                    
           IF FLM07-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  PARA 0100-INITIALIZATION            **'     
               DISPLAY '**  OPEN ERROR OF FCSLM007 - INPUT FILE  **'    
               DISPLAY '**         FILE STATUS = ' WS-FLM07-STATUS      
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***********************************************************               
      *                                                        **               
      * 1000-PROCESS-PARA                                      **               
      *      PROCESS INPUT DATA                                **               
      *                                                        **               
      ***********************************************************               
      *                                                                         
       1000-PROCESS-PARA.                                               
      *                                                                         
           PERFORM 7100-READ-FCSLM007            THRU 7100-EXIT.        
                                                                        
           PERFORM 2000-PROCESS-UPDATE           THRU 2000-EXIT         
                                             UNTIL NO-MORE-DATA.        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *************************************************************             
      *                                                          **             
      * 2000-PROCESS-UPDATE                                      **             
      *      MAIN UPDATE PROCESS                                 **             
      *                                                          **             
      *************************************************************             
                                                                        
       2000-PROCESS-UPDATE.                                             
                                                                        
                                                                        
           PERFORM 7200-GET-MST-STK-INFO         THRU 7200-EXIT.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL             
              IF 4A-EQUIPMENT-COST-AM NOT EQUAL WS-IN-EQ-COST-AMT       
                 PERFORM 8000-UPD-MST-STK-INFO   THRU 8000-EXIT         
              END-IF                                                    
           ELSE                                                         
              PERFORM 8100-INS-MST-STK-INFO      THRU 8100-EXIT         
           END-IF.                                                      
                                                                        
           INITIALIZE WS-INPUT-REC-FMT                                  
                      WS-EQ-COST-AMT-FMT.                               
           MOVE 'N'                         TO WS-ERROR-FIL-SW.         
                                                                        
           PERFORM 7100-READ-FCSLM007            THRU 7100-EXIT.        
                                                                        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *                                                             **          
      *    7100-READ-FCSLM007                                       **          
      *        READS DATA FROM THE INPUT FILE FCSLM007              **          
      *                                                             **          
      ****************************************************************          
      *                                                                         
       7100-READ-FCSLM007.                                              
      *                                                                         
           READ FCSLM007-FILE                                           
               AT END                                                   
                   MOVE WS-N                TO WS-MORE-DATA-SW          
                   GO                       TO 7100-EXIT.               
      *                                                                         
           IF FLM07-SUCCESSFUL                                          
                                                                        
               UNSTRING E-CSSLM007-INFO-REC DELIMITED BY '~'            
                    INTO WS-IN-COMPANY-NO                               
                        ,WS-IN-CD-SRV-TYP                               
                        ,WS-IN-STK-CD                                   
                        ,WS-IN-STK-DESC                                 
                        ,WS-IN-EQ-TYP-CD                                
                        ,WS-EQ-COST-AMT-TXT                             
               END-UNSTRING                                             
                                                                        
               UNSTRING WS-EQ-COST-AMT-TXT DELIMITED BY '.' OR ' '      
                    INTO WS-EQ-COST-AMT-INT                             
                        ,WS-EQ-COST-AMT-DEC                             
               END-UNSTRING                                             
                                                                        
               MOVE WS-EQ-COST-AMT          TO WS-EQ-COST-AMT-NUM       
                                                                        
               COMPUTE WS-IN-EQ-COST-AMT = WS-EQ-COST-AMT-NUM / 100     
                                                                        
               ADD 1                        TO WS-FLM07-REC-CNTR        
           ELSE                                                         
               DISPLAY '**  PARA  7100-READ-FCSLM007             **'    
               DISPLAY '**  READ ERROR OF FCSLM007 - INPUT FILE  **'    
               DISPLAY '**         FILE STATUS = ' WS-FLM07-STATUS      
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************           
      * 7200-GET-MST-STK-INFO                                       *           
      ***************************************************************           
                                                                        
       7200-GET-MST-STK-INFO.                                           
                                                                        
           EXEC SQL                                                     
               SELECT EQUIPMENT_COST_AM                                 
                 INTO :4A-EQUIPMENT-COST-AM                             
                 FROM LMS_MSTR_STCK_INFO WITH(READUNCOMMITTED)                  
                WHERE COMPANY_NO        = :WS-IN-COMPANY-NO             
                  AND CODE_SERVICE_TYPE = :WS-IN-CD-SRV-TYP             
                  AND STOCK_CD          = :WS-IN-STK-CD                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT EQUIPMENT_COST_AM                                         
MFA-TR*          INTO :4A-EQUIPMENT-COST-AM                                     
MFA-TR*          FROM LMS_MSTR_STCK_INFO                                        
MFA-TR*         WHERE COMPANY_NO        = :WS-IN-COMPANY-NO                     
MFA-TR*           AND CODE_SERVICE_TYPE = :WS-IN-CD-SRV-TYP                     
MFA-TR*           AND STOCK_CD          = :WS-IN-STK-CD                         
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO    WS-ACTIVE-RETURN-CODE 
                                                  WS-SQL-CODE.          
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '**  SELECT ERROR IN 7200-             **'  
                    DISPLAY '**  RETURN CODE = ' WS-SQL-CODE            
                    DISPLAY '**  COMPANY-NO:' WS-IN-COMPANY-NO          
                    DISPLAY '**  CODE_SERVICE_TYPE:'WS-IN-CD-SRV-TYP    
                    DISPLAY '**  STOCK_CD:'WS-IN-STK-CD                 
                    DISPLAY '**  PROCESSING TERMINATED             **'  
                    PERFORM 9900-ABEND           THRU 9900-EXIT         
           END-EVALUATE.                                                
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************           
      * 8000-UPD-MST-STK-INFO.                                      *           
      ***************************************************************           
                                                                        
       8000-UPD-MST-STK-INFO.                                           
                                                                        
           EXEC SQL                                                     
                UPDATE LMS_MSTR_STCK_INFO                               
                SET EQUIP_TYPE_CD       = :WS-IN-EQ-TYP-CD              
                   ,LAST_UPDATE_USERID  = :WS-PGM-NAME                  
                   ,EQUIPMENT_COST_AM   = :WS-IN-EQ-COST-AMT            
                WHERE COMPANY_NO        = :WS-IN-COMPANY-NO             
                  AND CODE_SERVICE_TYPE = :WS-IN-CD-SRV-TYP             
                  AND STOCK_CD          = :WS-IN-STK-CD                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE LMS_MSTR_STCK_INFO                                       
MFA-TR*         SET EQUIP_TYPE_CD       = :WS-IN-EQ-TYP-CD                      
MFA-TR*            ,LAST_UPDATE_USERID  = :WS-PGM-NAME                          
MFA-TR*            ,EQUIPMENT_COST_AM   = :WS-IN-EQ-COST-AMT                    
MFA-TR*         WHERE COMPANY_NO        = :WS-IN-COMPANY-NO                     
MFA-TR*           AND CODE_SERVICE_TYPE = :WS-IN-CD-SRV-TYP                     
MFA-TR*           AND STOCK_CD          = :WS-IN-STK-CD                         
MFA-TR*       QUERYNO 8000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO    WS-ACTIVE-RETURN-CODE 
                                                  WS-SQL-CODE.          
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    ADD +1                 TO WS-UPDATE-REC-CNTR        
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '**  UPDATE ERROR IN 8000-             **'  
                    DISPLAY '**  RETURN CODE = ' WS-SQL-CODE            
                    DISPLAY '**  COMPANY-NO:' WS-IN-COMPANY-NO          
                    DISPLAY '**  CODE_SERVICE_TYPE:'WS-IN-CD-SRV-TYP    
                    DISPLAY '**  STOCK_CD:'WS-IN-STK-CD                 
                    DISPLAY '**  PROCESSING TERMINATED             **'  
                    PERFORM 9900-ABEND           THRU 9900-EXIT         
           END-EVALUATE.                                                
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************           
      * 8100-INS-MST-STK-INFO.                                      *           
      ***************************************************************           
                                                                        
       8100-INS-MST-STK-INFO.                                           
                                                                        
           EXEC SQL                                                     
                INSERT INTO LMS_MSTR_STCK_INFO                          
                           (COMPANY_NO                                  
                           ,CODE_SERVICE_TYPE                           
                           ,STOCK_CD                                    
                           ,STOCK_DESC                                  
                           ,EQUIP_TYPE_CD                               
                           ,LAST_UPDATE_USERID                          
                           ,EQUIPMENT_COST_AM)                          
                     VALUES                                             
                           (:WS-IN-COMPANY-NO                           
                           ,:WS-IN-CD-SRV-TYP                           
                           ,:WS-IN-STK-CD                               
                           ,:WS-IN-STK-DESC                             
                           ,:WS-IN-EQ-TYP-CD                            
                           ,:WS-PGM-NAME                                
                           ,:WS-IN-EQ-COST-AMT)                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO    WS-ACTIVE-RETURN-CODE 
                                                  WS-SQL-CODE.          
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    ADD +1                 TO WS-INSERT-REC-CNTR        
               WHEN OTHER                                               
                    DISPLAY '**  INSERT ERROR IN 8100-             **'  
                    DISPLAY '**  RETURN CODE = ' WS-SQL-CODE            
                    DISPLAY '**  COMPANY-NO:' WS-IN-COMPANY-NO          
                    DISPLAY '**  CODE_SERVICE_TYPE:'WS-IN-CD-SRV-TYP    
                    DISPLAY '**  STOCK_CD:'WS-IN-STK-CD                 
                    DISPLAY '**  PROCESSING TERMINATED             **'  
                    PERFORM 9900-ABEND           THRU 9900-EXIT         
           END-EVALUATE.                                                
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **                                                              **        
      **  9000-TERMINATE.                                             **        
      **       TERMINATION ROUTINE                                    **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSLM007-FILE.                                         
           IF FLM07-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  PARA 9000-TERMINATE                 **'     
               DISPLAY '**  CLOSE ERROR OF FCSLM007 - INPUT FILE **'    
               DISPLAY '**         FILE STATUS = ' WS-FLM07-STATUS      
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
                                                                        
           DISPLAY '********************************************'.      
           DISPLAY '** READ RECORDS FROM INPUT FILE:' WS-FLM07-REC-CNTR 
           DISPLAY '** UPDATED  RECORDS IN TABLE:' WS-UPDATE-REC-CNTR.  
           DISPLAY '** INSERTED RECORDS IN TABLE:' WS-INSERT-REC-CNTR.  
           DISPLAY '*********************************************'.     
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
