       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSLM005.                                         
       AUTHOR.        MC95456.                                          
       DATE-WRITTEN.  MAY 2014.                                         
                                                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRICITY  & GAS              **         
      **                                                             **         
      **                  CUSTOMER SERVICE SYSTEM                    **         
      **                         DB2                                 **         
      *****************************************************************         
      *                       PROGRAM SUMMARY                         *         
      *                                                               *         
      *    PURPOSE:  INSERT ORDERS IN TO LMS_REQUEST_DETAIL TABLE.    *         
      *                                                               *         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS       REASON                            **         
      **                                                             **         
P00817** 05/14      MC95456        NEW PROGRAM                       **         
P00817** 05/14      MC95456        NEW PROGRAM                       **         
A05084*  07/11/16  DB41297    USE CSS_SO_UPDATE INSTEAD OF            *         
A05084*            ACT080     CSS_SO_REMARKS.                         *         
      ******************************************************************        
      ******************************************************************        
                    ---- BASIC SEQUENCE STRUCTURE ------                
               0000 - 0099     MAIN CONTROL PATH                        
               0100 - 0999     INITIALIZATION                           
               1000 - 1999     INPUT PROCESSING CONTROL PATH            
               2000 - 2999     OUTPUT PROCESSING CONTROL PATH           
               3000 - 4999     BATCH PROCESSING MODULES - NOT USED      
               5000 - 5999     COMMON PROGRAM MODULES                   
               6000 - 6999     COMMON SYSTEM MODULES                    
               7000 - 7999     INPUT MODULES                            
               8000 - 8999     OUTPUT MODULES                           
               9000 - 9899     TERMINATION MODULES                      
               9900 - 9999     ABEND/ABORT MODULES                      
      *                                                                         
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
      ******************************************************************        
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
                                                                        
      ******************************************************************        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSLM005'.
MSQ017     COPY MFASQLM.
      ******************************************************************        
       01  WS-WORK-AREA.                                                
           05 WS-PARM-DATA.                                             
              10 WS-DESCRIPTION       PIC X(20) VALUE                   
                 'COMPLETED-DATE-TIME='.                                
              10 WS-COMPLT-DATE-TIME  PIC X(26) VALUE SPACES.           
           05 WS-COUNT                PIC 9(06) VALUE 0.                
           05 PROGRAM-NAME            PIC X(08) VALUE 'PCSLM005'.       
           05 WS-FW003                PIC X(05) VALUE 'FW003'.          
           05 WS-Z                    PIC X(01) VALUE 'Z'.              
           05 WS-LRL                  PIC X(03) VALUE 'LRL'.            
           05 WS-LXL                  PIC X(03) VALUE 'LXL'.            
           05 WS-LLD                  PIC X(03) VALUE 'LLD'.            
           05 WS-CIS                  PIC X(03) VALUE 'CIS'.            
           05 WS-01                   PIC X(02) VALUE '01'.             
           05 WS-PARM                 PIC X(04) VALUE 'PARM'.           
           05 WS-SEQ-NO               PIC S9(4)V COMP-3 VALUE 1.        
           05 WS-NO-MORE-SO-ROWS      PIC X(01) VALUE 'N'.              
              88 NO-MORE-SO-ROWS                VALUE 'Y'.              
      *                                                                         
      ******************************************************************        
      *  COPYBOOK FOR ABEND FILE                                                
      ******************************************************************        
       COPY CWS00010.                                                           
      *                                                                         
      ******************************************************************        
      *  COPYBOOK FOR ABEND SWITCH                                              
      ******************************************************************        
       COPY CWS09900.                                                           
      *                                                                         
      ******************************************************************        
      *  SQL COMMUNICATION AREA                                                 
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_JOB_PARM     - G6                                                  
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_PREMISE  - PR                                           *          
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_SOMATL_PROCESS - TN                                                
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE TBSOPROC                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_SO_ORDER_INST - VI                                                 
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE TBSOODR                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_SO_DATA - VO                                                       
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE TBSODAT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    LMS_REQUEST_DETAIL - 4O                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBREQDET                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_SO_REMARKS     - EF                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBSOREM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  COPYBOOK FOR SQL ERROR CHECKING                                        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS00303                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **  CURSOR DECLARATION TO SELECT CIS SO ORDERS DATA            **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
             DECLARE SO-DETAILS CURSOR WITH HOLD FOR                    
               SELECT VO.SERV_ORDER_NO                                  
                     ,VO.ORDER_TYPE_CD                                  
                     ,VI.WORK_TYPE_CD                                   
                     ,VO.ACCOUNT_NO                                     
                     ,VO.COMPANY_NO                                     
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME                             
                     ,VO.LOCAL_OFFICE                                   
                     ,VI.SO_INST_SEQ_NO                                 
                 FROM CSS_SO_DATA        VO WITH(READUNCOMMITTED)               
                     ,CSS_SO_ORDER_INST  VI WITH(READUNCOMMITTED)               
                     ,CSS_PREMISE        PR WITH(READUNCOMMITTED)               
                     ,CSS_SO_UPDATE      VW WITH(READUNCOMMITTED)               
                WHERE VO.ORDER_TYPE_CD      = :WS-FW003                 
                  AND VO.ORDER_STATE_CD     = :WS-Z                     
                  AND VW.UPDATE_DATETIME    > CIS.CHAR2TIMESTAMP(
                                                   :WS-COMPLT-DATE-TIME
              )      
                  AND VO.SERV_ORDER_NO      = VI.SERV_ORDER_NO          
                  AND VO.SERV_ORDER_NO      = VW.SERV_ORDER_NO          
                  AND VO.PREMISE_NO         = PR.PREMISE_NO             
                  AND VI.WORK_TYPE_CD      IN (:WS-LRL,:WS-LXL,:WS-LLD) 
                  AND VW. PANEL_NO      = '090'                         
                  AND VW.UPDATE_DATETIME =                              
                     (SELECT MAX(VW1.UPDATE_DATETIME)                   
                         FROM CSS_SO_UPDATE VW1 WITH(READUNCOMMITTED)           
                        WHERE VW.SERV_ORDER_NO   = VW1.SERV_ORDER_NO    
                          AND VW. PANEL_NO       = VW1. PANEL_NO      ) 
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SO-DETAILS CURSOR WITH HOLD FOR                            
MFA-TR*        SELECT VO.SERV_ORDER_NO                                          
MFA-TR*              ,VO.ORDER_TYPE_CD                                          
MFA-TR*              ,VI.WORK_TYPE_CD                                           
MFA-TR*              ,VO.ACCOUNT_NO                                             
MFA-TR*              ,VO.COMPANY_NO                                             
MFA-TR*              ,VO.COMPLETED_DATETIME                                     
MFA-TR*              ,VO.LOCAL_OFFICE                                           
MFA-TR*              ,VI.SO_INST_SEQ_NO                                         
MFA-TR*          FROM CSS_SO_DATA        VO                                     
MFA-TR*              ,CSS_SO_ORDER_INST  VI                                     
MFA-TR*              ,CSS_PREMISE        PR                                     
MFA-TR*              ,CSS_SO_UPDATE      VW                                     
MFA-TR*         WHERE VO.ORDER_TYPE_CD      = :WS-FW003                         
MFA-TR*           AND VO.ORDER_STATE_CD     = :WS-Z                             
MFA-TR*           AND VW.UPDATE_DATETIME    > :WS-COMPLT-DATE-TIME              
MFA-TR*           AND VO.SERV_ORDER_NO      = VI.SERV_ORDER_NO                  
MFA-TR*           AND VO.SERV_ORDER_NO      = VW.SERV_ORDER_NO                  
MFA-TR*           AND VO.PREMISE_NO         = PR.PREMISE_NO                     
MFA-TR*           AND VI.WORK_TYPE_CD      IN (:WS-LRL,:WS-LXL,:WS-LLD)         
MFA-TR*           AND VW. PANEL_NO      = '090'                                 
MFA-TR*           AND VW.UPDATE_DATETIME =                                      
MFA-TR*              (SELECT MAX(VW1.UPDATE_DATETIME)                           
MFA-TR*                  FROM CSS_SO_UPDATE VW1                                 
MFA-TR*                 WHERE VW.SERV_ORDER_NO   = VW1.SERV_ORDER_NO            
MFA-TR*                   AND VW. PANEL_NO       = VW1. PANEL_NO      )         
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *           AND EF.REMARK_TYPE_CD IN ('A','G')                            
      *           AND EF.REMARK_DATETIME    =                                   
      *              (SELECT MAX(EF1.UPDATE_DATETIME)                           
      *                 FROM CSS_SO_UPDATE  EF1                                 
      *                WHERE EF.SERV_ORDER_NO   = EF1.SERV_ORDER_NO             
      *                  AND EF1.PANEL_NO       = '090' )                       
      *                                                                         
      ******************************************************************        
      *                P R O C E D U R E   D I V I S I O N             *        
      ******************************************************************        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAIN.                                                       
      *                                                                         
           DISPLAY '<<< PCSLM005 STARTED >>>'.                          
           DISPLAY ' '.                                                 
      *                                                                         
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
           PERFORM 1000-MAIN-PROCESS-PARA      THRU 1000-EXIT.          
      *                                                                         
           DISPLAY ' '.                                                 
           DISPLAY '<<< PCSLM005 ENDED >>>'.                            
           STOP RUN.                                                    
      *                                                                         
      ******************************************************************        
      *  0100-INITIALIZATION                                           *        
      *      OPENS OUTPUT FILE, GETS CURRENT DATE                      *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE PROGRAM-NAME                TO G6-PROGRAM-NAME.         
           MOVE WS-01                       TO G6-COMPANY-NO.           
           MOVE WS-PARM                     TO G6-CMND-CODE.            
           MOVE WS-SEQ-NO                   TO G6-SEQ-NO.               
           PERFORM 7000-GET-JOB-PARM           THRU 7000-EXIT.          
           MOVE G6-PARM-DATA                TO WS-PARM-DATA.            
           DISPLAY 'PROCESSING DATETIME :' WS-COMPLT-DATE-TIME.         
           DISPLAY '  '.                                                
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  1000-MAIN-PROCESS-PARA                                        *        
      *      CONTROLS MAIN PROCESS                                     *        
      ******************************************************************        
       1000-MAIN-PROCESS-PARA.                                          
      *                                                                         
           PERFORM 7100-OPEN-SO-DTLS           THRU 7100-EXIT.          
                                                                        
           PERFORM 7200-FETCH-SO-DTLS          THRU 7200-EXIT.          
                                                                        
           PERFORM 2000-LOAD-LMS-REQ-DTLS      THRU 2000-EXIT           
             UNTIL NO-MORE-SO-ROWS.                                     
                                                                        
           PERFORM 7300-CLOSE-SO-DTLS          THRU 7300-EXIT.          
                                                                        
           PERFORM 2500-UPDATE-JOB-PARM        THRU 2500-EXIT.          
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-LOAD-LMS-REQ-DTLS.                                        *        
      ******************************************************************        
       2000-LOAD-LMS-REQ-DTLS.                                          
      *                                                                         
           INITIALIZE DCLLMS-REQUEST-DETAIL.                            
           MOVE WS-CIS                      TO 4O-SOURCE-APPL-CD.       
           MOVE VO-SERV-ORDER-NO            TO 4O-SOURCE-APPL-REQ-NO.   
           MOVE VO-ORDER-TYPE-CD            TO 4O-ORDER-TYPE-CD.        
           MOVE VI-WORK-TYPE-CD             TO 4O-WORK-TYPE-CD.         
           MOVE VO-COMPLETED-DATETIME       TO 4O-REQUEST-ACTION-TS.    
           MOVE VO-ACCOUNT-NO               TO 4O-ACCOUNT-NO.           
           MOVE VI-SO-INST-SEQ-NO           TO 4O-WMS-POINT-NO.         
           MOVE 'S'                         TO 4O-RECORD-TYPE-CD        
                                               4O-REQUEST-ACTION-CD.    
           MOVE 'SYSTEM'                    TO 4O-LAST-UPDATE-USERID.   
           MOVE PR-LOCAL-OFFICE             TO 4O-LOCAL-OFFICE.         
           PERFORM 8000-INSERT-LMS-REQ-DTLS    THRU 8000-EXIT.          
                                                                        
           PERFORM 7200-FETCH-SO-DTLS          THRU 7200-EXIT.          
      *                                                                         
       2000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *  2500-UPDATE-JOB-PARM.                                         *        
      ******************************************************************        
       2500-UPDATE-JOB-PARM.                                            
                                                                        
           MOVE SPACES                      TO WS-COMPLT-DATE-TIME.     
           PERFORM 7500-GET-CURRENT-TS         THRU 7500-EXIT.          
           MOVE WS-PARM-DATA                TO G6-PARM-DATA             
           PERFORM 8100-UPDATE-JOB-PARM        THRU 8100-EXIT.          
           DISPLAY 'UPDATED JOB PARM TS :' WS-COMPLT-DATE-TIME.         
           DISPLAY 'RECORDS INSERTED    :' WS-COUNT.                    
           DISPLAY '  '.                                                
                                                                        
       2500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * 7000-GET-JOB-PARM.                                                      
      *****************************************************************         
                                                                        
       7000-GET-JOB-PARM.                                               
                                                                        
           EXEC SQL                                                     
                SELECT G6.PARM_DATA                                     
                  INTO :G6-PARM-DATA                                    
                  FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                    
                 WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME               
                   AND G6.COMPANY_NO   = :G6-COMPANY-NO                 
                   AND G6.CMND_CODE    = :G6-CMND-CODE                  
                   AND G6.SEQ_NO       = :G6-SEQ-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT G6.PARM_DATA                                             
MFA-TR*           INTO :G6-PARM-DATA                                            
MFA-TR*           FROM CSS_JOB_PARM G6                                          
MFA-TR*          WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                       
MFA-TR*            AND G6.COMPANY_NO   = :G6-COMPANY-NO                         
MFA-TR*            AND G6.CMND_CODE    = :G6-CMND-CODE                          
MFA-TR*            AND G6.SEQ_NO       = :G6-SEQ-NO                             
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************* ABENDING  ************'            
              DISPLAY '**   PCSLM005 PROCESSING ERROR   **'             
              DISPLAY '**   ABEND IN PARAGRAPH 7000     **'             
              DISPLAY '**   SQLCODE = ' WS-ACTIVE-RETURN-CODE           
              DISPLAY '**   PROCESSING TERMINATED       **'             
              DISPLAY '************* PCSLM005 ************'             
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *   7100-OPEN-SO-DTLS .                                          *        
      ******************************************************************        
       7100-OPEN-SO-DTLS .                                              
      *                                                                         
           EXEC SQL                                                     
              OPEN SO-DETAILS                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO  WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************ ABENDING ************'             
               DISPLAY '** 7100-OPEN-SO-DTLS            **'             
               DISPLAY '** SQLCODE IS ',     WS-ACTIVE-RETURN-CODE      
               DISPLAY '** WS-COMP-DATE-TIME ' WS-COMPLT-DATE-TIME      
               DISPLAY '**     PROCESSING TERMINATED    **'             
               DISPLAY '************ PCSLM005 ************'             
               PERFORM 9900-ABEND             THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *7200-FETCH-SO-DTLS.                                                      
      ******************************************************************        
       7200-FETCH-SO-DTLS.                                              
                                                                        
           EXEC SQL                                                     
              FETCH SO-DETAILS                                          
               INTO :VO-SERV-ORDER-NO                                   
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VI-WORK-TYPE-CD                                    
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-COMPANY-NO                                      
                   ,:VO-COMPLETED-DATETIME                              
                   ,:PR-LOCAL-OFFICE                                    
                   ,:VI-SO-INST-SEQ-NO                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'         TO WS-NO-MORE-SO-ROWS              
               WHEN OTHER                                               
                    DISPLAY '************ ABENDING ************'        
                    DISPLAY '** 7200-FETCH-SO-DTLS           **'        
                    DISPLAY '** SO-ORDER-TYPE-CD : FW003'               
                    DISPLAY '** SO-ORDER-STATE-CD: Z'                   
                    DISPLAY '** SO-SERV-ORDER-NO : '  VO-SERV-ORDER-NO  
                    DISPLAY '** SO-PREMISE-NO    : '  VO-PREMISE-NO     
                    DISPLAY '** SQLCODE IS: '   WS-ACTIVE-RETURN-CODE   
                    DISPLAY '**     PROCESSING TERMINATED    **'        
                    DISPLAY '************ PCSLM005 ************'        
                    PERFORM 9900-ABEND             THRU 9900-EXIT       
           END-EVALUATE.                                                
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *7300-CLOSE-SO-DTLS.                                                      
      ******************************************************************        
       7300-CLOSE-SO-DTLS.                                              
      *                                                                         
           EXEC SQL                                                     
              CLOSE SO-DETAILS                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************ ABENDING ************'             
               DISPLAY '** 7300-CLOSE-SO-DTLS           **'             
               DISPLAY '** SQLCODE IS ', WS-ACTIVE-RETURN-CODE          
               DISPLAY '**     PROCESSING TERMINATED    **'             
               DISPLAY '************ PCSLM005 ************'             
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7500-GET-CURRENT-TS.                                                    
      *****************************************************************         
                                                                        
       7500-GET-CURRENT-TS.                                             
                                                                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-COMPLT-DATE-TIME           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-COMPLT-DATE-TIME =  CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO  WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL            
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************ ABENDING ************'             
               DISPLAY '** 7500-GET-CURRENT-TS          **'             
               DISPLAY '** SQLCODE IS ',     WS-ACTIVE-RETURN-CODE      
               DISPLAY '** WS-COMPL-DATE-TIME ' WS-COMPLT-DATE-TIME     
               DISPLAY '**     PROCESSING TERMINATED    **'             
               DISPLAY '************ PCSLM005 ************'             
               PERFORM 9900-ABEND             THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *  8000-INSERT-LMS-REQ-DTLS.                                    *         
      *****************************************************************         
       8000-INSERT-LMS-REQ-DTLS.                                        
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO LMS_REQUEST_DETAIL                          
                           (TRANS_SEQ_NO                                
                           ,SOURCE_APPL_CD                              
                           ,SOURCE_APPL_REQ_NO                          
                           ,WMS_POINT_NO                                
                           ,ORDER_TYPE_CD                               
                           ,WORK_TYPE_CD                                
                           ,RECORD_TYPE_CD                              
                           ,REQUEST_ACTION_TS                           
                           ,REQUEST_ACTION_CD                           
                           ,ACCOUNT_NO                                  
                           ,LAST_UPDATE_TS                              
                           ,LAST_UPDATE_USERID                          
                           ,LOCAL_OFFICE)                               
                 VALUES   (CIS.CURRENT$TIMESTAMP()                            
                          ,:4O-SOURCE-APPL-CD                           
                          ,:4O-SOURCE-APPL-REQ-NO                       
                          ,:4O-WMS-POINT-NO                             
                          ,:4O-ORDER-TYPE-CD                            
                          ,:4O-WORK-TYPE-CD                             
                          ,:4O-RECORD-TYPE-CD                           
                          ,CIS.CHAR2TIMESTAMP(:4O-REQUEST-ACTION-TS)            
                          ,:4O-REQUEST-ACTION-CD                        
                          ,:4O-ACCOUNT-NO                               
                          ,CIS.CURRENT$TIMESTAMP()                            
                          ,:4O-LAST-UPDATE-USERID                       
                          ,:4O-LOCAL-OFFICE)                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO LMS_REQUEST_DETAIL                                  
MFA-TR*                    (TRANS_SEQ_NO                                        
MFA-TR*                    ,SOURCE_APPL_CD                                      
MFA-TR*                    ,SOURCE_APPL_REQ_NO                                  
MFA-TR*                    ,WMS_POINT_NO                                        
MFA-TR*                    ,ORDER_TYPE_CD                                       
MFA-TR*                    ,WORK_TYPE_CD                                        
MFA-TR*                    ,RECORD_TYPE_CD                                      
MFA-TR*                    ,REQUEST_ACTION_TS                                   
MFA-TR*                    ,REQUEST_ACTION_CD                                   
MFA-TR*                    ,ACCOUNT_NO                                          
MFA-TR*                    ,LAST_UPDATE_TS                                      
MFA-TR*                    ,LAST_UPDATE_USERID                                  
MFA-TR*                    ,LOCAL_OFFICE)                                       
MFA-TR*          VALUES   (CURRENT TIMESTAMP                                    
MFA-TR*                   ,:4O-SOURCE-APPL-CD                                   
MFA-TR*                   ,:4O-SOURCE-APPL-REQ-NO                               
MFA-TR*                   ,:4O-WMS-POINT-NO                                     
MFA-TR*                   ,:4O-ORDER-TYPE-CD                                    
MFA-TR*                   ,:4O-WORK-TYPE-CD                                     
MFA-TR*                   ,:4O-RECORD-TYPE-CD                                   
MFA-TR*                   ,:4O-REQUEST-ACTION-TS                                
MFA-TR*                   ,:4O-REQUEST-ACTION-CD                                
MFA-TR*                   ,:4O-ACCOUNT-NO                                       
MFA-TR*                   ,CURRENT TIMESTAMP                                    
MFA-TR*                   ,:4O-LAST-UPDATE-USERID                               
MFA-TR*                   ,:4O-LOCAL-OFFICE)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               ADD 1                     TO WS-COUNT                    
           ELSE                                                         
               DISPLAY '************* ABENDING  ************'           
               DISPLAY '**   PCSLM005 PROCESSING ERROR   **'            
               DISPLAY '**   ABEND IN PARAGRAPH 8000     **'            
               DISPLAY '**   SQLCODE = '   WS-ACTIVE-RETURN-CODE        
               DISPLAY '**   ACCOUNT # = ' 4O-ACCOUNT-NO                
               DISPLAY '**   PROCESSING TERMINATED       **'            
               DISPLAY '************* PCSLM005 ************'            
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8100-UPDATE-JOB-PARM                                                    
      ******************************************************************        
       8100-UPDATE-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_JOB_PARM                                      
                  SET PARM_DATA    = :G6-PARM-DATA                      
                WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                   
                  AND CMND_CODE    = :G6-CMND-CODE                      
                  AND COMPANY_NO   = :G6-COMPANY-NO                     
                  AND SEQ_NO       = :G6-SEQ-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*** ERROR IN 8100-RESET-JOB-PARM ***'            
              DISPLAY '*** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '***   PROCESSING TERMINATED ***'                 
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-TERMINATE.                                                *        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 9900-PROCESS-ABEND                                             *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD09900                                                
           END-EXEC.                                                            
      ******************************************************************        
