       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSLM003.                                            
       DATE-WRITTEN. MAY-2014.                                          
       DATE-COMPILED.                                                   
      *                                                                         
      *****************************************************************         
      *                SOUTH CAROLINA ELECTRIC & GAS                            
      *                                                                         
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM UPLOAD HANDHELD INTERFACE FILE DATA (FROM SERVER)*        
      *  TO LMS HANDHELD TRANSACTION TABLE LMS_HANDHELD_TRANS.         *        
      *                        FIELD HANDHELD                          *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                            
      *                                                                         
      *    DATE    INITIALS   COMMENTS                                          
      *  --------  --------   ---------------------------------------           
      *  05/19/14  MR7E794    PRO#0817 LMS - INITIAL VERSION.                   
ACT035*  13/07/16  AK7T405    TO CREATE ENTRY IN WQ TABLE AND ERROR             
      *            A05470     FILE WHENEVER SQLCODE -180 OR -181                
      *                       OCCURED                                           
      *****************************************************************         
      *****************************************************************         
      *                                                                         
      *                ---- BASIC SEQUENCE STRUCTURE ----                       
      *                                                                         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION                      
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                             
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                            
      *  3000 - 4999  NOT USED                                                  
      *  5000 - 5999  COMMON PROGRAM MODULES                                    
      *  6000 - 6999  COMMON SYSTEM MODULES                                     
      *  7000 - 7999  INPUT MODULES                                             
      *  8000 - 8999  OUTPUT MODULES                                            
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES                      
      *                                                                         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSLM003.                                                           
       COPY CSSLE003.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDLM003.                                                           
       COPY FIOLM003.                                                           
       COPY CFDLE003.                                                           
       COPY FIOLE003.                                                           
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSLM003'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)  VALUE               
           'WORKING STORAGE FOR PCSLM003 STARTS HERE'.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-PGRMNAME               PIC X(08) VALUE 'PCSLM003'.    
           05  WS-SYSTEM                 PIC X(08) VALUE 'SYSTEM'.      
           05  WS-N                      PIC X(01) VALUE 'N'.           
           05  WS-FLM03-REC-CNTR         PIC 9(08) VALUE 0.             
           05  WS-FLE03-REC-CNTR         PIC 9(08) VALUE 0.             
           05  WS-INSERT-REC-CNTR        PIC 9(08) VALUE 0.             
           05  WS-CURRENT-DATE           PIC X(10) VALUE SPACES.        
           05  RS-RETURN-CODE            PIC S9(09) COMP  VALUE +0.     
           05  SCSCB077                  PIC X(08) VALUE 'SCSCB077'.    
           05  WS-ERROR-MSG              PIC X(50) VALUE SPACES.        
           05  WS-FLE03-STATUS           PIC X(02).                     
               88 FLE03-SUCCESSFUL                 VALUE '00'.          
           05  WS-FLM03-STATUS           PIC X(02).                     
               88 FLM03-SUCCESSFUL                 VALUE '00'.          
           05  WS-MORE-DATA-SW           PIC X(01) VALUE 'Y'.           
               88 NO-MORE-DATA                     VALUE 'N'.           
           05  WS-LATITUDE.                                             
               10 WS-LATITUDE-INT        PIC X(02) VALUE SPACES.        
               10 FILLER                 PIC X(01) VALUE '.'.           
               10 WS-LATITUDE-DEC        PIC X(06) VALUE SPACES.        
           05  WS-LATITUDE-1.                                           
               10 WS-LATITUDE-INT1       PIC 9(03) VALUE ZEROES.        
               10 WS-LATITUDE-DEC1       PIC 9(06) VALUE ZEROES.        
           05  WS-LATITUDE-RED REDEFINES                                
               WS-LATITUDE-1             PIC 9(3)V9(6).                 
           05  WS-LONGITUDE.                                            
               10 WS-LONGITUDE-SIGN      PIC X(01) VALUE SPACES.        
               10 WS-LONGITUDE-INT       PIC X(02) VALUE SPACES.        
               10 FILLER                 PIC X(01) VALUE '.'.           
               10 WS-LONGITUDE-DEC       PIC X(06) VALUE SPACES.        
           05  WS-LONGITUDE-1.                                          
               10 WS-LONGITUDE-INT1      PIC 9(03) VALUE ZEROES.        
               10 WS-LONGITUDE-DEC1      PIC 9(06) VALUE ZEROES.        
           05  WS-LONGITUDE-RED REDEFINES                               
               WS-LONGITUDE-1            PIC 9(3)V9(6).                 
           05  WS-REQUEST-NO             PIC X(13).                     
           05  WS-REQUEST-NO-NUM REDEFINES                              
               WS-REQUEST-NO             PIC 9(13).                     
           05  WS-VALIDATE-TS.                                          
               10 WS-VALID-DATE          PIC X(10).                     
               10 WS-VALID-TIME          PIC X(08).                     
               10 WS-DATE                PIC X(10).                     
               10 WS-TIME                PIC X(08).                     
      *                                                                         
       01  WS-WORK-QUEUE-SW              PIC X(01) VALUE 'N'.           
           88  CREATE-WQ                           VALUE 'Y'.           
           88  DO-NOT-CREATE-WQ                    VALUE 'N'.           
      *                                                                         
       01  WS-VALIDATION-SW              PIC X(01) VALUE 'N'.           
           88 INVALID-RECORD                       VALUE 'Y'.           
           88 VALID-RECORD                         VALUE 'N'.           
      *                                                                         
      *****************************************************************         
      * SQL COMMUNICATION AREA                                        *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * LMS_HANDHELD_TRANS                                            *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBHNDTRN                                                
           END-EXEC.                                                            
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      *****************************************************************         
      ****** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077              
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE CWS00077                                                
           END-EXEC.                                                            
      *                                                                         
       COPY CWS00010.                                                           
                                                                        
       01  WS-END                        PIC X(40)  VALUE               
             'WORKING STORAGE FOR PCSLM003 ENDS HERE  '.                
                                                                        
      ******************************************************************        
      ******************************************************************        
      *                                                                         
       PROCEDURE DIVISION.                                              
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
                                                                        
           PERFORM 1000-MAIN-PROCESS-PARA      THRU 1000-EXIT           
             UNTIL NO-MORE-DATA.                                        
                                                                        
           IF CREATE-WQ                                                 
              INITIALIZE CWS00077-FIELDS                                
              MOVE WS-CURRENT-DATE          TO WS-77-DATE-REQUIRED      
              MOVE 28                       TO WS-77-CATEGORY-ID        
              MOVE 'H'                      TO WS-77-PRIORITY           
              MOVE WS-PGRMNAME              TO WS-77-CREATED-BY         
              MOVE 'SYSTEM'                 TO WS-77-USER-ID-ORIG       
              PERFORM 6000-INSERT-WORK-QUEUE   THRU 6000-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
                                                                        
           DISPLAY '********************************************'       
           DISPLAY '** READ RECORDS FROM INPUT FILE:' WS-FLM03-REC-CNTR 
           DISPLAY '** INSERTED RECORDS IN TABLE:' WS-INSERT-REC-CNTR   
           DISPLAY '** WRITTEN RECORDS INTO ERROR:' WS-FLE03-REC-CNTR   
           DISPLAY '*********************************************'      
                                                                        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***********************************************************               
      **                                                       **               
      **    0100-INITIALIZATION.                               **               
      **        INITIALIZATION ROUTINE                         **               
      **                                                       **               
      ***********************************************************               
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN OUTPUT FCSLE003-FILE.                                   
           IF FLE03-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '************* PCSLM003 *******************'      
              DISPLAY '**  0100-INITIALIZATION                 **'      
              DISPLAY '**  OPEN ERROR OF FCSLE003 - INPUT FILE  **'     
              DISPLAY '**         FILE STATUS = ' WS-FLE03-STATUS       
              DISPLAY '**         PROCESSING TERMINATED         **'     
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
           OPEN INPUT FCSLM003-FILE.                                    
           IF FLM03-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '************* PCSLM003 *******************'      
              DISPLAY '**  0100-INITIALIZATION                 **'      
              DISPLAY '**  OPEN ERROR OF FCSLM03 - INPUT FILE  **'      
              DISPLAY '**         FILE STATUS = ' WS-FLM03-STATUS       
              DISPLAY '**         PROCESSING TERMINATED         **'     
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
           PERFORM 7100-READ-FILE              THRU 7100-EXIT.          
      *                                                                         
           SET DO-NOT-CREATE-WQ TO TRUE.                                
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      **                                                         **             
      **      1000-MAIN-PROCESS-PARA                             **             
      **           MAIN PROCESS                                  **             
      **                                                         **             
      *************************************************************             
      *                                                                         
       1000-MAIN-PROCESS-PARA.                                          
      *                                                                         
           PERFORM 2000-VALIDATE-INPUT         THRU 2000-EXIT.          
                                                                        
           IF INVALID-RECORD                                            
              SET CREATE-WQ TO TRUE                                     
              INITIALIZE FIOLE003-REC                                   
              MOVE  E-FLM03-DATA-REC        TO E-FLE03-DATA             
              MOVE  WS-ERROR-MSG            TO E-FLE03-ERR-MESG         
              PERFORM 8200-WRITE-ERROR-FILE    THRU 8200-EXIT           
           ELSE                                                         
              PERFORM 2100-LOAD-HAND-HELD      THRU 2100-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 7100-READ-FILE              THRU 7100-EXIT.          
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  2000-VALIDATE-INPUT.                                       **         
      *****************************************************************         
       2000-VALIDATE-INPUT.                                             
      *                                                                         
           SET VALID-RECORD TO TRUE.                                    
           INITIALIZE WS-VALIDATE-TS                                    
                      WS-REQUEST-NO.                                    
      *                                                                         
           MOVE E-FLM03-TRANS-DATE          TO WS-VALID-DATE.           
           MOVE E-FLM03-TRANS-TIME          TO WS-VALID-TIME.           
                                                                        
           PERFORM 7000-VALIDATE-DATETIME      THRU 7000-EXIT.          
      *                                                                         
ACT035     IF WS-ACTIVE-RETURN-CODE    EQUAL -180                       
ACT035        OR WS-ACTIVE-RETURN-CODE EQUAL -181                       
ACT035        INITIALIZE WS-ERROR-MSG                                   
ACT035        MOVE 'INVALID TIME/TIMESTAMP ERROR'                       
ACT035                                      TO WS-ERROR-MSG             
ACT035        SET INVALID-RECORD TO TRUE                                
ACT035        GO TO 2000-EXIT                                           
ACT035     END-IF.                                                      
      *                                                                         
           IF E-FLM03-WORK-FLOW-TYPE-CD > SPACES                        
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'WORK FLOW TYPE CODE IS INVALID'                     
                                            TO WS-ERROR-MSG             
              SET INVALID-RECORD TO TRUE                                
              GO TO 2000-EXIT                                           
           END-IF.                                                      
      *                                                                         
           IF E-FLM03-FXTR-TAG-NO-CUR > SPACES                          
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CURRENT FXTR TAG NO IS INVALID'                     
                                            TO WS-ERROR-MSG             
              SET INVALID-RECORD TO TRUE                                
              GO TO 2000-EXIT                                           
           END-IF.                                                      
      *                                                                         
           IF E-FLM03-POLE-TAG-NO-CUR > SPACES                          
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CURRENT POLE TAG NO IS INVALID'                     
                                            TO WS-ERROR-MSG             
              SET INVALID-RECORD TO TRUE                                
              GO TO 2000-EXIT                                           
           END-IF.                                                      
      *                                                                         
           MOVE E-FLM03-REQUEST-NO          TO WS-REQUEST-NO.           
           IF WS-REQUEST-NO-NUM IS >= 0                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'REQUEST NO IS INVALID'  TO WS-ERROR-MSG             
              SET INVALID-RECORD TO TRUE                                
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2100-LOAD-HAND-HELD.                                             
      *                                                                         
           INITIALIZE DCLLMS-HANDHELD-TRANS                             
                                                                        
           MOVE WS-DATE                     TO 4N-TRANS-DATE.           
           MOVE WS-TIME                     TO 4N-TRANS-TIME.           
           MOVE E-FLM03-WORK-FLOW-TYPE-CD   TO 4N-WORK-FLOW-TYPE-CD.    
           MOVE E-FLM03-FXTR-TAG-NO-OLD     TO 4N-FXTR-TAG-NO-OLD.      
           MOVE E-FLM03-FXTR-TAG-NO-CUR     TO 4N-FXTR-TAG-NO-CURR.     
           MOVE E-FLM03-POLE-TAG-NO-OLD     TO 4N-POLE-TAG-NO-OLD.      
           MOVE E-FLM03-POLE-TAG-NO-CUR     TO 4N-POLE-TAG-NO-CURR.     
           MOVE E-FLM03-NODE-TAG-NO-OLD     TO 4N-NODE-TAG-NO-OLD.      
           MOVE E-FLM03-NODE-TAG-NO-CUR     TO 4N-NODE-TAG-NO-CURR.     
           MOVE E-FLM03-TRANS-EMPL-ID       TO 4N-TRANS-USERID.         
           MOVE WS-REQUEST-NO-NUM           TO 4N-SOURCE-APPL-REQ-NO.   
           MOVE 'WMS'                       TO 4N-SOURCE-APPL-CD.       
      *                                                                         
           PERFORM 7200-TAG-NO-CASE-CNVRSN    THRU 7200-EXIT.           
      *                                                                         
           IF WS-REQUEST-NO-NUM > 9999999999                            
              MOVE 'CIS'                    TO 4N-SOURCE-APPL-CD        
           END-IF.                                                      
                                                                        
           MOVE LENGTH OF E-FLM03-TRANS-COMMENTS                        
                                            TO 4N-TRANS-COMMENTS-LEN.   
           MOVE E-FLM03-TRANS-COMMENTS      TO 4N-TRANS-COMMENTS-TEXT.  
           MOVE SPACES                      TO 4N-TRANS-STATUS-CD.      
           MOVE WS-SYSTEM                   TO 4N-LAST-UPDATE-USERID.   
           PERFORM 2200-FORMAT-LAT-LONG        THRU 2200-EXIT.          
                                                                        
           PERFORM 8100-INSERT-FLD-HANDHELD    THRU 8100-EXIT.          
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2200-FORMAT-LAT-LONG.                                            
      *                                                                         
           INITIALIZE WS-LATITUDE                                       
                      WS-LATITUDE-1                                     
                      WS-LONGITUDE                                      
                      WS-LONGITUDE-1.                                   
                                                                        
           MOVE E-FLM03-FXTR-GPS-LATITUDE   TO WS-LATITUDE.             
           MOVE E-FLM03-FXTR-GPS-LONGITUDE  TO WS-LONGITUDE.            
                                                                        
           MOVE WS-LATITUDE-INT             TO WS-LATITUDE-INT1.        
           MOVE WS-LATITUDE-DEC             TO WS-LATITUDE-DEC1.        
           MOVE WS-LATITUDE-RED             TO 4N-FXTR-GPS-LATITUDE.    
                                                                        
           IF WS-LONGITUDE-SIGN = '-'                                   
              MOVE WS-LONGITUDE-INT         TO WS-LONGITUDE-INT1        
              MOVE WS-LONGITUDE-DEC         TO WS-LONGITUDE-DEC1        
              COMPUTE 4N-FXTR-GPS-LONGITUDE = WS-LONGITUDE-RED * -1     
           ELSE                                                         
              MOVE WS-LONGITUDE-DEC         TO WS-LONGITUDE-DEC1        
              MOVE WS-LONGITUDE-INT         TO WS-LONGITUDE-INT1        
              MOVE WS-LONGITUDE-RED         TO 4N-FXTR-GPS-LONGITUDE    
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   6000-INSERT-WORK-QUEUE.                                      *        
      * INSERT THE WORK QUEUE ITEMS IN THE CSS_WQ_ITEMS TABLE.         *        
      ******************************************************************        
      *                                                                         
       6000-INSERT-WORK-QUEUE.                                          
                                                                        
           CALL SCSCB077 USING CWS00077-FIELDS,                         
                               ABEND-FILE,                              
                               RS-RETURN-CODE                           
           MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF ABEND-FUNCTION > SPACES                                   
              OR RS-RETURN-CODE NOT = 0                                 
              DISPLAY '************* PCSLM003 *******************'      
              DISPLAY '6000-INSERT-WORK-QUEUE'                          
              DISPLAY 'CALL SCSCB077         '                          
              DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       6000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7000-VALIDATE-DATETIME.                                  **         
      *****************************************************************         
       7000-VALIDATE-DATETIME.                                          
                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              IIF(TRY_CONVERT(DATE, :WS-VALID-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-VALID-DATE
              ) <> 0) OR (LEN(:WS-VALID-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-VALID-DATE
              ), CONVERT(DATE, :WS-VALID-DATE) ),
              REPLACE(CONVERT(CHAR(8), CIS.CHAR2TIME(:WS-VALID-TIME)
           , 108), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-DATE,
              :WS-TIME                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*            ,:WS-DATE = DATE(:WS-VALID-DATE)                             
MFA-TR*            ,:WS-TIME = TIME(:WS-VALID-TIME)                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT035        OR WS-ACTIVE-RETURN-CODE EQUAL -180                       
ACT035        OR WS-ACTIVE-RETURN-CODE EQUAL -181                       
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************* PCSLM003 *******************'      
              DISPLAY '**  7000-VALIDATE-DATETIME              **'      
              DISPLAY '**  RETURN CODE =     ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '**  WS-CURRENT-DATE:  ' WS-CURRENT-DATE          
              DISPLAY '**  WS-VALID-DATE:    ' WS-VALID-DATE            
              DISPLAY '**  WS-VALID-TIME:    ' WS-VALID-TIME            
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7100-READ-FILE                                           **          
      **       READS DATA RECORD FROM THE INPUT FILE FCSLM02        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7100-READ-FILE.                                                  
      *                                                                         
           READ FCSLM003-FILE                                           
               AT END                                                   
                  MOVE WS-N                 TO WS-MORE-DATA-SW          
                  GO TO 7100-EXIT.                                      
      *                                                                         
           IF FLM03-SUCCESSFUL                                          
              ADD 1                         TO WS-FLM03-REC-CNTR        
           ELSE                                                         
              DISPLAY '************* PCSLM003 *******************'      
              DISPLAY '**  7100-READ-FILE                      **'      
              DISPLAY '**  READ ERROR OF FCSLM003- INPUT FILE  **'      
              DISPLAY '**         FILE STATUS = ' WS-FLM03-STATUS       
              DISPLAY '**         PROCESSING TERMINATED         **'     
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7200-TAG-NO-CASE-CNVRSN.                                 **         
      *****************************************************************         
       7200-TAG-NO-CASE-CNVRSN.                                         
                                                                        
           EXEC SQL                                                     
              SELECT
              UPPER(:4N-FXTR-TAG-NO-OLD),
              UPPER(:4N-FXTR-TAG-NO-CURR),
              UPPER(:4N-POLE-TAG-NO-OLD),
              UPPER(:4N-POLE-TAG-NO-CURR),
              UPPER(:4N-NODE-TAG-NO-OLD),
              UPPER(:4N-NODE-TAG-NO-CURR)
            INTO
              :4N-FXTR-TAG-NO-OLD,
              :4N-FXTR-TAG-NO-CURR,
              :4N-POLE-TAG-NO-OLD,
              :4N-POLE-TAG-NO-CURR,
              :4N-NODE-TAG-NO-OLD,
              :4N-NODE-TAG-NO-CURR    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :4N-FXTR-TAG-NO-OLD  = UPPER(:4N-FXTR-TAG-NO-OLD)             
MFA-TR*          ,:4N-FXTR-TAG-NO-CURR = UPPER(:4N-FXTR-TAG-NO-CURR)            
MFA-TR*          ,:4N-POLE-TAG-NO-OLD  = UPPER(:4N-POLE-TAG-NO-OLD)             
MFA-TR*          ,:4N-POLE-TAG-NO-CURR = UPPER(:4N-POLE-TAG-NO-CURR)            
MFA-TR*          ,:4N-NODE-TAG-NO-OLD  = UPPER(:4N-NODE-TAG-NO-OLD)             
MFA-TR*          ,:4N-NODE-TAG-NO-CURR = UPPER(:4N-NODE-TAG-NO-CURR)            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************* PCSLM003 *******************'      
              DISPLAY '**  7200-TAG-NO-CASE-CNVRSN             **'      
              DISPLAY '**  RETURN CODE =     ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '**  FXTR-TAG-NO-CUR:  ' 4N-FXTR-TAG-NO-OLD       
              DISPLAY '**  FXTR-TAG-NO-OLD:  ' 4N-FXTR-TAG-NO-CURR      
              DISPLAY '**  POLE-TAG-NO-CUR:  ' 4N-POLE-TAG-NO-OLD       
              DISPLAY '**  POLE-TAG-NO-OLD:  ' 4N-POLE-TAG-NO-CURR      
              DISPLAY '**  NODE-TAG-NO-CUR:  ' 4N-NODE-TAG-NO-OLD       
              DISPLAY '**  NODE-TAG-NO-OLD:  ' 4N-NODE-TAG-NO-CURR      
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * INSERT RECORD IN THE LMS EQUIP INVENTRY TABLE.              *           
      ***************************************************************           
      *                                                                         
       8100-INSERT-FLD-HANDHELD.                                        
      *                                                                         
           EXEC SQL                                                     
           INSERT INTO LMS_HANDHELD_TRANS                               
                  ( TRANS_SEQ_NO                                        
                   ,TRANS_DATE                                          
                   ,TRANS_TIME                                          
                   ,WORK_FLOW_TYPE_CD                                   
                   ,FXTR_TAG_NO_OLD                                     
                   ,FXTR_TAG_NO_CURR                                    
                   ,POLE_TAG_NO_OLD                                     
                   ,POLE_TAG_NO_CURR                                    
                   ,NODE_TAG_NO_OLD                                     
                   ,NODE_TAG_NO_CURR                                    
                   ,FXTR_GPS_LATITUDE                                   
                   ,FXTR_GPS_LONGITUDE                                  
                   ,TRANS_USERID                                        
                   ,SOURCE_APPL_CD                                      
                   ,SOURCE_APPL_REQ_NO                                  
                   ,TRANS_STATUS_CD                                     
                   ,TRANS_COMMENTS                                      
                   ,LAST_UPDATE_USERID )                                
           VALUES ( CIS.CURRENT$TIMESTAMP()                                   
                  ,IIF(TRY_CONVERT(DATE, :4N-TRANS-DATE
              ) IS NULL OR (PATINDEX('%.%', :4N-TRANS-DATE
              ) <> 0) OR (LEN(:4N-TRANS-DATE) <> 10), CIS.CHAR2DATE(
                                                         :4N-TRANS-DATE
              ), CONVERT(DATE, :4N-TRANS-DATE) )                               
                  ,CIS.CHAR2TIME(:4N-TRANS-TIME)                                
                  ,:4N-WORK-FLOW-TYPE-CD                                
                  ,:4N-FXTR-TAG-NO-OLD                                  
                  ,:4N-FXTR-TAG-NO-CURR                                 
                  ,:4N-POLE-TAG-NO-OLD                                  
                  ,:4N-POLE-TAG-NO-CURR                                 
                  ,:4N-NODE-TAG-NO-OLD                                  
                  ,:4N-NODE-TAG-NO-CURR                                 
                  ,:4N-FXTR-GPS-LATITUDE                                
                  ,:4N-FXTR-GPS-LONGITUDE                               
                  ,:4N-TRANS-USERID                                     
                  ,:4N-SOURCE-APPL-CD                                   
                  ,:4N-SOURCE-APPL-REQ-NO                               
                  ,:4N-TRANS-STATUS-CD                                  
                  ,:4N-TRANS-COMMENTS                                   
                  ,:4N-LAST-UPDATE-USERID)                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    INSERT INTO LMS_HANDHELD_TRANS                                       
MFA-TR*           ( TRANS_SEQ_NO                                                
MFA-TR*            ,TRANS_DATE                                                  
MFA-TR*            ,TRANS_TIME                                                  
MFA-TR*            ,WORK_FLOW_TYPE_CD                                           
MFA-TR*            ,FXTR_TAG_NO_OLD                                             
MFA-TR*            ,FXTR_TAG_NO_CURR                                            
MFA-TR*            ,POLE_TAG_NO_OLD                                             
MFA-TR*            ,POLE_TAG_NO_CURR                                            
MFA-TR*            ,NODE_TAG_NO_OLD                                             
MFA-TR*            ,NODE_TAG_NO_CURR                                            
MFA-TR*            ,FXTR_GPS_LATITUDE                                           
MFA-TR*            ,FXTR_GPS_LONGITUDE                                          
MFA-TR*            ,TRANS_USERID                                                
MFA-TR*            ,SOURCE_APPL_CD                                              
MFA-TR*            ,SOURCE_APPL_REQ_NO                                          
MFA-TR*            ,TRANS_STATUS_CD                                             
MFA-TR*            ,TRANS_COMMENTS                                              
MFA-TR*            ,LAST_UPDATE_USERID )                                        
MFA-TR*    VALUES ( CURRENT TIMESTAMP                                           
MFA-TR*           ,:4N-TRANS-DATE                                               
MFA-TR*           ,:4N-TRANS-TIME                                               
MFA-TR*           ,:4N-WORK-FLOW-TYPE-CD                                        
MFA-TR*           ,:4N-FXTR-TAG-NO-OLD                                          
MFA-TR*           ,:4N-FXTR-TAG-NO-CURR                                         
MFA-TR*           ,:4N-POLE-TAG-NO-OLD                                          
MFA-TR*           ,:4N-POLE-TAG-NO-CURR                                         
MFA-TR*           ,:4N-NODE-TAG-NO-OLD                                          
MFA-TR*           ,:4N-NODE-TAG-NO-CURR                                         
MFA-TR*           ,:4N-FXTR-GPS-LATITUDE                                        
MFA-TR*           ,:4N-FXTR-GPS-LONGITUDE                                       
MFA-TR*           ,:4N-TRANS-USERID                                             
MFA-TR*           ,:4N-SOURCE-APPL-CD                                           
MFA-TR*           ,:4N-SOURCE-APPL-REQ-NO                                       
MFA-TR*           ,:4N-TRANS-STATUS-CD                                          
MFA-TR*           ,:4N-TRANS-COMMENTS                                           
MFA-TR*           ,:4N-LAST-UPDATE-USERID)                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO    WS-ACTIVE-RETURN-CODE                     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD 1                         TO WS-INSERT-REC-CNTR       
           ELSE                                                         
              DISPLAY '************* PCSLM003 *******************'      
              DISPLAY '**  8100-INSERT-FLD-HANDHELD            **'      
              DISPLAY '**  RETURN CODE =     ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '**  TRANS-SEQ-NO      ' 4N-TRANS-SEQ-NO          
              DISPLAY '**  FXTR_TAG_NO_CURR  ' 4N-FXTR-TAG-NO-CURR      
              DISPLAY '**  POLE_TAG_NO_CURR  ' 4N-POLE-TAG-NO-CURR      
              DISPLAY '**  SOURCE_APPL_REQ_NO' 4N-SOURCE-APPL-REQ-NO    
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **  8200-WRITE-ERROR-FILE                                       **        
      **       WRITES THE RECORD IN THE ERROR  FILE                   **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       8200-WRITE-ERROR-FILE.                                           
      *                                                                         
           WRITE FIOLE003-REC.                                          
                                                                        
           IF FLE03-SUCCESSFUL                                          
               ADD 1                        TO WS-FLE03-REC-CNTR        
           ELSE                                                         
              DISPLAY '************* PCSLM003 *******************'      
              DISPLAY '**  8200-WRITE-ERROR-FILE               **'      
              DISPLAY '**  WRITE ERROR OF FCSLE003 - INPUT FILE **'     
              DISPLAY '**         FILE STATUS = ' WS-FLE03-STATUS       
              DISPLAY '**         PROCESSING TERMINATED         **'     
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **  9000-TERMINATE.                                             **        
      **       TERMINATION ROUTINE                                    **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSLM003-FILE.                                         
                                                                        
           IF FLM03-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '************* PCSLM003 *******************'      
              DISPLAY '**  9000-TERMINATE                       **'     
              DISPLAY '**  CLOSE ERROR OF FCSLM003 - INPUT FILE **'     
              DISPLAY '**         FILE STATUS = ' WS-FLM03-STATUS       
              DISPLAY '**         PROCESSING TERMINATED          **'    
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           CLOSE FCSLE003-FILE.                                         
                                                                        
           IF FLE03-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '************* PCSLM003 *******************'      
              DISPLAY '**  9000-TERMINATE                      **'      
              DISPLAY '**  CLOSE ERROR OF FCSLE003 - INPUT FILE **'     
              DISPLAY '**         FILE STATUS = ' WS-FLE03-STATUS       
              DISPLAY '**         PROCESSING TERMINATED         **'     
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
