       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSLM002.                                            
       DATE-WRITTEN. MAY-2014.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00070000
      *                                                                *00080000
      ******************************************************************00090000
      *                 P R O G R A M  S U M M A R Y                   *00100000
      *                                                                *00110000
      *  THIS PROGRAM UPDATE THE EQUIPMENT STATUS IN LMS_EQUIP_INVENTORY00120000
      *       USING THE TRANSACTIONS FROM MATERIAL HANDHELD            *00130000
      ******************************************************************00150000
      *                     PROGRAM MODIFICATION LOG                    00160000
      *                                                                 00170000
      *    DATE    INITIALS   COMMENTS                                  00180000
      *  --------  --------   ---------------------------------------   00190000
      *  05/14/14  AD7F921    PROJ#0817 LIGHT MANAGEMENT SYSTEM         00200000
A#5084*  05/28/15  SS95855    ACT038    FIX INCORRECT STATUS UPDATE     00201002
      *                                                                 00210000
      ***************************************************************** 00220000
      ***************************************************************** 00230000
      *                                                                 00240000
      *                ---- BASIC SEQUENCE STRUCTURE ----               00250000
      *                                                                 00260000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION              00270000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                     00280000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                    00290000
      *  3000 - 4999  NOT USED                                          00300000
      *  5000 - 5999  COMMON PROGRAM MODULES                            00310000
      *  6000 - 6999  COMMON SYSTEM MODULES                             00320000
      *  7000 - 7999  INPUT MODULES                                     00330000
      *  8000 - 8999  OUTPUT MODULES                                    00340000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES              00350000
      *                                                                 00360000
      ***************************************************************** 00370000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER. IBM-4341.                                       
       OBJECT-COMPUTER. IBM-4341.                                       
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                 00450000
      *** SELECT STMT FOR FILES                                         00460000
        COPY CSSLM002.                                                  00470000
        COPY CSSLE002.                                                  00500000
      *                                                                 00510000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *** FD STMT FOR LM002 INPUT FILE                                  00540000
       COPY CFDLM002.                                                   00550000
       COPY FIOLM002.                                                   00560000
                                                                        
      *** FD STMT FOR LE002 OUTPUT FILE                                 00580000
       COPY CFDLE002.                                                   00590000
       COPY FIOLE002.                                                   00600000
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSLM002'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)  VALUE               
           'WORKING STORAGE FOR PCSLM002 STARTS HERE'.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-PGRMNAME               PIC X(08)   VALUE 'PCSLM002'.  
           05  WS-NO                     PIC X(01)   VALUE 'N'.         
           05  WS-YES                    PIC X(01)   VALUE 'Y'.         
           05  WS-FIXTURE                PIC X(01)   VALUE 'F'.         
ACT038     05  WS-ABANDONED              PIC X(01)   VALUE 'A'.         
ACT038     05  WS-IN-INVENTORY           PIC X(01)   VALUE 'I'.         
ACT038     05  WS-INSTALLED              PIC X(01)   VALUE 'J'.         
           05  WS-STORAGE-FAC-CD         PIC X(03)   VALUE SPACES.      
           05  WS-IN-TRANSIT-USERID      PIC X(07)   VALUE SPACES.      
           05  WS-INVENTRY-STATUS-CD     PIC X(01)   VALUE SPACES.      
           05  WS-FLM02-REC-CNTR         PIC 9(08)   VALUE ZERO.        
           05  WS-FLE02-REC-CNTR         PIC 9(08)   VALUE ZERO.        
           05  WS-UPDATE-REC-CNTR        PIC 9(08)   VALUE ZERO.        
           05  WS-FLE02-STATUS           PIC X(02).                     
               88  FLE02-SUCCESSFUL                  VALUE '00'.        
               88  FLE02-EOF                         VALUE '10'.        
           05  WS-FLM02-STATUS           PIC X(02).                     
               88  FLM02-SUCCESSFUL                  VALUE '00'.        
               88  FLM02-EOF                         VALUE '10'.        
           05  WS-MORE-DATA-SW           PIC X(01)   VALUE 'Y'.         
               88  NO-MORE-DATA                      VALUE 'N'.         
           05  WS-ERROR-FIL-SW           PIC X(01)   VALUE 'N'.         
               88  ERROR-DATA                        VALUE 'Y'.         
ACT038     05  WS-INSTALL-SW             PIC X(01)   VALUE 'N'.         
ACT038         88  INSTALLED                         VALUE 'Y'.         
           05  WS-ERROR-MSG              PIC X(50)   VALUE SPACES.      
           05  WS-CURRENT-DATE           PIC X(10)   VALUE SPACES.      
           05  RS-RETURN-CODE            PIC S9(09)  COMP  VALUE +0.    
           05  SCSCB077                  PIC X(08)   VALUE 'SCSCB077'.  
           05  WS-SYSTEM                 PIC X(07)   VALUE 'SYSTEM'.    
           05  WS-TRANS-COMMENTS         PIC X(60)   VALUE              
                                    'UPDATE LIGHT STATUS IN INVENTORY'. 
      *                                                                 00854100
       01 WS-WQ-COMMENTS.                                               
           05  WS-WQ-COMMENTS-1          PIC X(054) VALUE               
               'SCANNED MATERIAL DOES NOT MATCH INVENTORY. CHECK ERROR'.
           05  WS-WQ-COMMENTS-2          PIC X(051) VALUE               
               ' FILE AT \\SCANA\SHARES\APPS\APPS\MTR_BIS\LIGHTING\'.   
           05  WS-WQ-COMMENTS-3          PIC X(028) VALUE               
               'MATERIALHH\IMPORT\ERRRPT.TXT'.                          
       01  WS-WORK-QUEUE-SW              PIC X(01)   VALUE 'N'.         
               88  CREATE-WQ                         VALUE 'Y'.         
               88  DO-NOT-CREATE-WQ                  VALUE 'N'.         
      ***************************************************************** 00860000
      * SQL COMMUNICATION AREA                                        * 00870000
      ***************************************************************** 00880000
                                                                        
           EXEC SQL                                                     00900000
                INCLUDE SQLCA                                           00910000
           END-EXEC.                                                    00920000
      *                                                                 00930000
      ***************************************************************** 00940000
      * LMS_EQUIP_INVENTRY 4D                                         * 00950000
      ***************************************************************** 00960000
                                                                        
           EXEC SQL                                                     00980000
                INCLUDE TBEQPINV                                        00990000
           END-EXEC.                                                    01000000
      *                                                                 01010000
      ***************************************************************** 01011000
      * LMS_TRANS_HIST    4J                                          * 01012000
      ***************************************************************** 01013000
            EXEC SQL                                                    01014000
                 INCLUDE TBLGTHST                                       01015000
            END-EXEC.                                                   01016000
      *                                                                 01017000
      ***************************************************************** 01018000
      * LMS_TRANS_HIST_DET  4S                                        * 01019000
      ***************************************************************** 01019100
            EXEC SQL                                                    01019200
                 INCLUDE TBLMSHST                                       01019300
            END-EXEC.                                                   01019400
      *                                                                 01019500
       COPY CWS09900.                                                   01020000
      *                                                                 01030000
       COPY CWS00303.                                                   01040000
      *                                                                 01050000
      ***************************************************************** 01051000
      ****** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077      01052000
      ***************************************************************** 01053000
           EXEC SQL                                                     01054000
                INCLUDE CWS00077                                        01055000
           END-EXEC.                                                    01056000
      *                                                                 01057000
       COPY CWS00010.                                                   01058000
                                                                        
       01  WS-END                        PIC X(40)  VALUE               
             'WORKING STORAGE FOR PCSLM002 ENDS HERE  '.                
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
                                                                        
           PERFORM 1000-PROCESS-PARA           THRU 1000-EXIT.          
                                                                        
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01240000
      ***********************************************************       01250000
      *                                                        **       01260000
      * 0100-INITIALIZATION.                                   **       01270000
      *      INITIALIZATION ROUTINE                            **       01280000
      *                                                        **       01290000
      ***********************************************************       01300000
      *                                                                 01310000
       0100-INITIALIZATION.                                             
      *                                                                 01321000
           OPEN OUTPUT FCSLE002-FILE.                                   
           IF FLE02-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*************** PCSLM002 *****************'     
               DISPLAY '**  PARA 0100-INITIALIZATION            **'     
               DISPLAY '**  OPEN ERROR OF FCSLE002 - ERROR FILE  **'    
               DISPLAY '**         FILE STATUS = ' WS-FLE02-STATUS      
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 01440000
           OPEN INPUT FCSLM002-FILE.                                    
           IF FLM02-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*************** PCSLM002 *****************'     
               DISPLAY '**  PARA 0100-INITIALIZATION            **'     
               DISPLAY '**  OPEN ERROR OF FCSLM002 - INPUT FILE  **'    
               DISPLAY '**         FILE STATUS = ' WS-FLM02-STATUS      
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 01550000
           PERFORM 7000-GET-CURRENT-DATE       THRU 7000-EXIT.          
      *                                                                 01552000
           SET DO-NOT-CREATE-WQ             TO TRUE.                    
      *                                                                 01554000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01580000
      ***********************************************************       01590000
      *                                                        **       01600000
      * 1000-PROCESS-PARA                                      **       01610000
      *      PROCESS INPUT DATA                                **       01620000
      *                                                        **       01630000
      ***********************************************************       01640000
      *                                                                 01650000
       1000-PROCESS-PARA.                                               
      *                                                                 01670000
           PERFORM 7100-READ-FILE              THRU 7100-EXIT.          
                                                                        
           PERFORM 2000-PROCESS-UPDATE         THRU 2000-EXIT           
             UNTIL NO-MORE-DATA.                                        
                                                                        
           IF CREATE-WQ                                                 
              PERFORM 2100-CREATE-WQ           THRU 2100-EXIT           
           END-IF.                                                      
                                                                        
           DISPLAY '********************************************'.      
           DISPLAY '** RECORDS READ FROM INPUT FILE:' WS-FLM02-REC-CNTR 
           DISPLAY '** RECORDS UPDATED IN TABLE    :' WS-UPDATE-REC-CNTR
           DISPLAY '** RECORDS WRITTEN IN ERR FILE :' WS-FLE02-REC-CNTR 
           DISPLAY '*********************************************'.     
      *                                                                 01720000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01741000
      *************************************************************     01750000
      *                                                          **     01760000
      * 2000-PROCESS-UPDATE                                      **     01770000
      *      MAIN UPDATE PROCESS                                 **     01780000
      *                                                          **     01790000
      *************************************************************     01800000
      *                                                                 01810000
       2000-PROCESS-UPDATE.                                             
                                                                        
           INITIALIZE DCLLMS-EQUIP-INVENTRY.                            
ACT038     MOVE 'N'                         TO WS-ERROR-FIL-SW          
ACT038                                         WS-INSTALL-SW.           
                                                                        
           MOVE E-FLM02-EQUIP-TAG-NO        TO 4D-EQUIP-TAG-NO.         
           MOVE E-FLM02-EQUIP-TYPE-CD       TO 4D-EQUIP-TYPE-CD.        
                                                                        
           PERFORM 7200-CHECK-INVTRY           THRU 7200-EXIT.          
                                                                        
ACT038     IF WS-INVENTRY-STATUS-CD = WS-INSTALLED                      
ACT038        MOVE WS-YES             TO WS-ERROR-FIL-SW                
ACT038                                   WS-INSTALL-SW                  
ACT038     END-IF.                                                      
                                                                        
ACT038     IF WS-ERROR-FIL-SW = WS-NO                                   
ACT038        PERFORM 2050-PREPARE-UPDATE       THRU 2050-EXIT          
ACT038     END-IF.                                                      
                                                                        
           IF ERROR-DATA                                                
              SET CREATE-WQ TO TRUE                                     
              ADD +1                        TO WS-FLE02-REC-CNTR        
              MOVE SPACES                   TO E-FLE02-DATA-MESG        
              MOVE E-FLM02-DATA-REC         TO E-FLE02-DATA-REC         
              IF E-FLM02-EQUIP-TYPE-CD = WS-FIXTURE                     
                 MOVE 'FIXTURE NOT FOUND'   TO E-FLE02-DATA-MESG        
ACT038           IF INSTALLED                                           
ACT038              MOVE 'FIXTURE INSTALLED' TO E-FLE02-DATA-MESG       
ACT038           END-IF                                                 
              ELSE                                                      
                 MOVE 'NODE NOT FOUND'      TO E-FLE02-DATA-MESG        
              END-IF                                                    
              PERFORM 8200-WRITE-ERROR-FILE    THRU 8200-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 7100-READ-FILE              THRU 7100-EXIT.          
      *                                                                 01980000
       2000-EXIT.                                                       
           EXIT.                                                        
ACT038*                                                                 02010004
ACT038 2050-PREPARE-UPDATE.                                             
ACT038*                                                                 02019303
ACT038     MOVE E-FLM02-TO-MSF-CODE         TO 4D-STORAGE-FAC-CD.       
ACT038                                                                  
ACT038     MOVE E-FLM02-TO-LOCATION         TO 4D-INVENTRY-STATUS-CD.   
ACT038                                                                  
ACT038     IF E-FLM02-TO-LOCATION = WS-ABANDONED                        
ACT038        MOVE WS-IN-INVENTORY          TO 4D-INVENTRY-STATUS-CD    
ACT038     END-IF.                                                      
ACT038                                                                  
ACT038     IF E-FLM02-INTRANSIT-EMP-ID > SPACES                         
ACT038        MOVE E-FLM02-INTRANSIT-EMP-ID TO 4D-IN-TRANSIT-USERID     
ACT038     END-IF.                                                      
ACT038                                                                  
ACT038     MOVE WS-SYSTEM                   TO 4D-LAST-UPDATE-USERID.   
ACT038                                                                  
ACT038     PERFORM 8000-UPDATE-LMS-INVENTORY   THRU 8000-EXIT.          
ACT038                                                                  
ACT038     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT038        AND 4D-EQUIP-TYPE-CD = WS-FIXTURE                         
ACT038        PERFORM 5000-WRITE-TRAN-HIST   THRU 5000-EXIT             
ACT038     END-IF.                                                      
ACT038*                                                                 02021503
ACT038 2050-EXIT.                                                       
ACT038     EXIT.                                                        
      *                                                                 02021800
       2100-CREATE-WQ.                                                  
      *                                                                 02022000
           INITIALIZE CWS00077-FIELDS.                                  
           MOVE 4                           TO WS-77-ROUTE-CATEGORY     
           MOVE WS-CURRENT-DATE             TO WS-77-DATE-REQUIRED.     
           MOVE 568                         TO WS-77-CATEGORY-ID.       
           MOVE 'H'                         TO WS-77-PRIORITY.          
           MOVE WS-PGRMNAME                 TO WS-77-CREATED-BY.        
           MOVE WS-SYSTEM                   TO WS-77-USER-ID-ORIG.      
           MOVE 1                           TO WS-77-COMMENTS-LEN.      
           MOVE WS-WQ-COMMENTS              TO WS-77-COMMENTS-TEXT.     
           COMPUTE WS-77-COMMENTS-LEN = LENGTH OF WS-77-COMMENTS-TEXT.  
           PERFORM 6000-INSERT-WORK-QUEUE      THRU 6000-EXIT.          
      *                                                                 02023200
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02023500
      ******************************************************************02023600
      * 5000-WRITE-TRAN-HIST                                           *02023700
      ******************************************************************02023800
       5000-WRITE-TRAN-HIST.                                            
                                                                        
            INITIALIZE DCLLMS-TRANS-HIST                                
                       DCLLMS-TRANS-HIST-DET.                           
                                                                        
            MOVE 4D-EQUIP-SEQ               TO 4J-EQUIP-SEQ             
                                               4S-EQUIP-SEQ.            
            MOVE 4D-EQUIP-TAG-NO            TO 4J-EQUIP-TAG-NO.         
            MOVE WS-PGRMNAME                TO 4J-APPL-PROGRAM-ID.      
            MOVE WS-SYSTEM                  TO 4J-LAST-UPDATE-USERID    
                                               4S-LAST-UPDATE-USERID.   
            MOVE +1                         TO 4S-DETAIL-SEQ-NO.        
            MOVE WS-TRANS-COMMENTS          TO 4J-TRANS-COMMENTS-TEXT.  
            MOVE LENGTH OF WS-TRANS-COMMENTS                            
                                            TO 4J-TRANS-COMMENTS-LEN.   
      *                                                                 02028200
            IF 4D-STORAGE-FAC-CD NOT EQUAL WS-STORAGE-FAC-CD            
               MOVE 'STORAGE_FAC_CD'        TO 4S-COLUMN-DESC           
               MOVE WS-STORAGE-FAC-CD       TO 4S-PRV-COLUMN-VALUE-TEXT 
               MOVE LENGTH OF WS-STORAGE-FAC-CD                         
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
               MOVE 4D-STORAGE-FAC-CD       TO 4S-CHG-COLUMN-VALUE-TEXT 
               MOVE LENGTH OF 4D-STORAGE-FAC-CD                         
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
               PERFORM 5100-LOAD-LMS-TARNS-HST  THRU 5100-EXIT          
            END-IF.                                                     
      *                                                                 02029400
            IF 4D-INVENTRY-STATUS-CD NOT EQUAL WS-INVENTRY-STATUS-CD    
               MOVE 'FXTR_INVNTRY_ST_CD'    TO 4S-COLUMN-DESC           
               MOVE WS-INVENTRY-STATUS-CD   TO 4S-PRV-COLUMN-VALUE-TEXT 
               MOVE LENGTH OF WS-INVENTRY-STATUS-CD                     
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
               MOVE 4D-INVENTRY-STATUS-CD   TO 4S-CHG-COLUMN-VALUE-TEXT 
               MOVE LENGTH OF 4D-INVENTRY-STATUS-CD                     
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
               PERFORM 5100-LOAD-LMS-TARNS-HST  THRU 5100-EXIT          
            END-IF.                                                     
      *                                                                 02030500
            IF 4D-IN-TRANSIT-USERID NOT EQUAL WS-IN-TRANSIT-USERID      
               MOVE 'IN_TRANSIT_USERID'     TO 4S-COLUMN-DESC           
               MOVE WS-IN-TRANSIT-USERID    TO 4S-PRV-COLUMN-VALUE-TEXT 
               MOVE LENGTH OF WS-IN-TRANSIT-USERID                      
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
               MOVE 4D-IN-TRANSIT-USERID    TO 4S-CHG-COLUMN-VALUE-TEXT 
               MOVE LENGTH OF 4D-IN-TRANSIT-USERID                      
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
               PERFORM 5100-LOAD-LMS-TARNS-HST  THRU 5100-EXIT          
            END-IF.                                                     
      *                                                                 02031800
       5000-EXIT.                                                       
             EXIT.                                                      
      *                                                                 02032100
      ******************************************************************02032200
      * LOAD LMS TRANSACTION HISTORY DETAILS FOR TYPE FIXTURE          *02032300
      ******************************************************************02032400
      *                                                                 02032500
       5100-LOAD-LMS-TARNS-HST.                                         
                                                                        
            IF 4S-DETAIL-SEQ-NO EQUAL 1                                 
               MOVE WS-CURRENT-DATE         TO 4J-TRANS-DATE            
               PERFORM 7050-GET-CURR-TS      THRU 7050-EXIT             
                                                                        
               PERFORM 8300-INS-LMS-TRN-HST  THRU 8300-EXIT             
               PERFORM 8400-INS-LMS-TRN-HSTDET                          
                                             THRU 8400-EXIT             
            ELSE                                                        
               PERFORM 8400-INS-LMS-TRN-HSTDET                          
                                             THRU 8400-EXIT             
            END-IF.                                                     
      *                                                                 02033900
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02034200
      ******************************************************************02034300
      *   6000-INSERT-WORK-QUEUE.                                      *02034400
      * INSERT THE WORK QUEUE ITEMS IN THE CSS_WQ_ITEMS TABLE.         *02034500
      ******************************************************************02034600
      *                                                                 02034700
       6000-INSERT-WORK-QUEUE.                                          
      *                                                                 02034900
           CALL SCSCB077 USING CWS00077-FIELDS,                         
                               ABEND-FILE,                              
                               RS-RETURN-CODE                           
           MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
              DISPLAY '*************** PCSLM002 *****************'      
              DISPLAY '6000-INSERT-WORK-QUEUE'                          
              DISPLAY 'CALL SCSCB077         '                          
              DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 02036200
       6000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02036500
                                                                        
      ****************************************************************  02036700
      *                                                             **  02036800
      *    7000-GET-CURRENT-DATE                                    **  02036900
      *                                                             **  02037000
      *                                                             **  02037100
      ****************************************************************  02037200
      *                                                                 02037300
       7000-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     02037600
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                     02037700
MFA-TR*    END-EXEC.                                                    02037800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*************** PCSLM002 *****************'     
               DISPLAY '**  7000-GET-CURRENT-DATE               **'     
               DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 02039100
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02039400
      ******************************************************************02039500
      *GET CURRENT TIMESTAMP TO INSERT INTO TRANSACTION HISTORY         02039600
      ******************************************************************02039700
                                                                        
       7050-GET-CURR-TS.                                                
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :4J-TRANS-HIST-SEQ-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     02040100
MFA-TR*       SET :4J-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP             02040200
MFA-TR*    END-EXEC.                                                    02040300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
      *                                                                 02040700
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE 4J-TRANS-HIST-SEQ-NO        TO 4S-TRANS-HIST-SEQ-NO 
           ELSE                                                         
               DISPLAY '**  SELECT ERROR IN 7050                **'     
               DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 02041600
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02041900
      ****************************************************************  02042000
      *                                                             **  02042100
      *    7100-READ-FILE                                           **  02043000
      *        READS DATA FROM THE INPUT FILE FCSLM002              **  02050000
      *                                                             **  02060000
      ****************************************************************  02070000
      *                                                                 02080000
       7100-READ-FILE.                                                  
      *                                                                 02100000
           READ FCSLM002-FILE                                           
               AT END                                                   
                  MOVE WS-NO               TO WS-MORE-DATA-SW           
                  GO TO 7100-EXIT.                                      
      *                                                                 02150000
           IF FLM02-SUCCESSFUL                                          
               ADD 1                        TO WS-FLM02-REC-CNTR        
           ELSE                                                         
               DISPLAY '*************** PCSLM002 *****************'     
               DISPLAY '**  7100-READ-FILE                       **'    
               DISPLAY '**  READ ERROR OF FCSLM002 - INPUT FILE  **'    
               DISPLAY '**         FILE STATUS = ' WS-FLM02-STATUS      
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 02270000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02291000
      ******************************************************************02292000
      * 7200-CHECK-INVTRY                                              *02293000
      ******************************************************************02294000
       7200-CHECK-INVTRY.                                               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) [4D].STORAGE_FAC_CD,
              [4D].INVENTRY_STATUS_CD,
              [4D].IN_TRANSIT_USERID,
              [4D].EQUIP_SEQ                                       
                INTO :WS-STORAGE-FAC-CD                                 
                    ,:WS-INVENTRY-STATUS-CD                             
                    ,:WS-IN-TRANSIT-USERID                              
                    ,:4D-EQUIP-SEQ                                      
                FROM LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)              
               WHERE [4D].EQUIP_TAG_NO  = :4D-EQUIP-TAG-NO                
                 AND [4D].EQUIP_TYPE_CD = :4D-EQUIP-TYPE-CD               
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                     02297000
MFA-TR*       SELECT 4D.STORAGE_FAC_CD                                  02298000
MFA-TR*             ,4D.INVENTRY_STATUS_CD                              02299000
MFA-TR*             ,4D.IN_TRANSIT_USERID                               02299100
MFA-TR*             ,4D.EQUIP_SEQ                                       02300000
MFA-TR*         INTO :WS-STORAGE-FAC-CD                                 02310000
MFA-TR*             ,:WS-INVENTRY-STATUS-CD                             02320000
MFA-TR*             ,:WS-IN-TRANSIT-USERID                              02330000
MFA-TR*             ,:4D-EQUIP-SEQ                                      02333000
MFA-TR*         FROM LMS_EQUIP_INVENTRY 4D                              02340000
MFA-TR*        WHERE 4D.EQUIP_TAG_NO  = :4D-EQUIP-TAG-NO                02350000
MFA-TR*          AND 4D.EQUIP_TYPE_CD = :4D-EQUIP-TYPE-CD               02351000
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                               02360000
MFA-TR*    END-EXEC.                                                    02380000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES             TO WS-ERROR-FIL-SW          
               WHEN OTHER                                               
                    DISPLAY '*************** PCSLM002 *****************'
                    DISPLAY '**  7200-CHECK-INVTRY                   **'
                    DISPLAY '**  SELECT ERROR IN 7200- PARA          **'
                    DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE 
                    DISPLAY '**  EQUIP_TAG_NO = ' 4D-EQUIP-TAG-NO       
                    DISPLAY '**  PROCESSING TERMINATED             **'  
                    PERFORM 9900-ABEND           THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02524000
      ***************************************************************   02530000
      * 8000-UPDATE-LMS-INVENTORY.                                  *   02540000
      ***************************************************************   02550000
      *                                                                 02560000
       8000-UPDATE-LMS-INVENTORY.                                       
      *                                                                 02580000
           EXEC SQL                                                     
                UPDATE LMS_EQUIP_INVENTRY                               
                   SET STORAGE_FAC_CD     = :4D-STORAGE-FAC-CD          
                      ,INVENTRY_STATUS_CD = :4D-INVENTRY-STATUS-CD      
                      ,IN_TRANSIT_USERID  = :4D-IN-TRANSIT-USERID       
                      ,LAST_UPDATE_USERID = :4D-LAST-UPDATE-USERID      
                 WHERE EQUIP_SEQ          = :4D-EQUIP-SEQ               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     02590000
MFA-TR*         UPDATE LMS_EQUIP_INVENTRY                               02600000
MFA-TR*            SET STORAGE_FAC_CD     = :4D-STORAGE-FAC-CD          02610000
MFA-TR*               ,INVENTRY_STATUS_CD = :4D-INVENTRY-STATUS-CD      02611000
MFA-TR*               ,IN_TRANSIT_USERID  = :4D-IN-TRANSIT-USERID       02612000
MFA-TR*               ,LAST_UPDATE_USERID = :4D-LAST-UPDATE-USERID      02620000
MFA-TR*          WHERE EQUIP_SEQ          = :4D-EQUIP-SEQ               02630000
MFA-TR*         QUERYNO 8000                                            02640000
MFA-TR*    END-EXEC.                                                    02650000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    ADD +1                 TO WS-UPDATE-REC-CNTR        
               WHEN NOT-FOUND                                           
                    MOVE WS-YES            TO WS-ERROR-FIL-SW           
               WHEN OTHER                                               
                    DISPLAY '*************** PCSLM002 *****************'
                    DISPLAY '**  8000-UPDATE-LMS-INVENTORY         **'  
                    DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE  
                    DISPLAY '**  EQUIP-TAG-NO  ' 4D-EQUIP-TAG-NO        
                    DISPLAY '**  COMPANY-NO    ' 4D-COMPANY-NO          
                    DISPLAY '**  PROCESSING TERMINATED             **'  
                    PERFORM 9900-ABEND           THRU 9900-EXIT         
           END-EVALUATE.                                                
      *                                                                 02920000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02950000
                                                                        
      ******************************************************************02961000
      **                                                              **02970000
      **  8200-WRITE-ERROR-FILE                                       **02980000
      **       WRITES THE RECORD IN THE ERROR  FILE                   **02990000
      **                                                              **03000000
      ******************************************************************03010000
      *                                                                 03020000
       8200-WRITE-ERROR-FILE.                                           
      *                                                                 03040000
           WRITE FIOLE002-REC.                                          
           IF FLE02-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*************** PCSLM002 *****************'     
               DISPLAY '**  8200-WRITE-ERROR-FILE                **'    
               DISPLAY '**  WRITE ERROR OF FCSLE002 - ERROR FILE **'    
               DISPLAY '**  FILE STATUS = ' WS-FLE02-STATUS             
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 03150000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03180000
      ***************************************************************   03190000
      * INSERT RECORD IN THE LMS TRANSACTION HISTORY TABLE.         *   03190100
      ***************************************************************   03190200
      *                                                                 03190300
       8300-INS-LMS-TRN-HST.                                            
                                                                        
           EXEC SQL                                                     
               INSERT INTO LMS_TRANS_HIST                               
                 (                                                      
                   EQUIP_SEQ,           TRANS_HIST_SEQ_NO,              
                   EQUIP_TAG_NO,        APPL_PROGRAM_ID,                
                   TRANS_DATE,          SOURCE_APPL_CD,                 
                   SOURCE_APPL_REQ_NO,  WMS_POINT_NO,                   
                   INSTALL_LOC_NO,      INSTALL_POINT_NO,               
                   ACCOUNT_NO,          LAST_UPDATE_USERID,             
                   TRANS_COMMENTS                                       
                 )                                                      
               VALUES                                                   
                 (                                                      
                   :4J-EQUIP-SEQ,           CIS.CHAR2TIMESTAMP(
                                                  :4J-TRANS-HIST-SEQ-NO
              ),      
                   :4J-EQUIP-TAG-NO,        :4J-APPL-PROGRAM-ID,        
                   IIF(TRY_CONVERT(DATE, :4J-TRANS-DATE
              ) IS NULL OR (PATINDEX('%.%', :4J-TRANS-DATE
              ) <> 0) OR (LEN(:4J-TRANS-DATE) <> 10), CIS.CHAR2DATE(
                                                         :4J-TRANS-DATE
              ), CONVERT(DATE, :4J-TRANS-DATE) ),          
                                                    :4J-SOURCE-APPL-CD,        
                   :4J-SOURCE-APPL-REQ-NO,  :4J-WMS-POINT-NO,           
                   :4J-INSTALL-LOC-NO,      :4J-INSTALL-POINT-NO,       
                   :4J-ACCOUNT-NO,          :4J-LAST-UPDATE-USERID,     
                   :4J-TRANS-COMMENTS                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03190600
MFA-TR*        INSERT INTO LMS_TRANS_HIST                               03190700
MFA-TR*          (                                                      03190800
MFA-TR*            EQUIP_SEQ,           TRANS_HIST_SEQ_NO,              03190900
MFA-TR*            EQUIP_TAG_NO,        APPL_PROGRAM_ID,                03191000
MFA-TR*            TRANS_DATE,          SOURCE_APPL_CD,                 03191100
MFA-TR*            SOURCE_APPL_REQ_NO,  WMS_POINT_NO,                   03191200
MFA-TR*            INSTALL_LOC_NO,      INSTALL_POINT_NO,               03191300
MFA-TR*            ACCOUNT_NO,          LAST_UPDATE_USERID,             03191400
MFA-TR*            TRANS_COMMENTS                                       03191500
MFA-TR*          )                                                      03191600
MFA-TR*        VALUES                                                   03191700
MFA-TR*          (                                                      03191800
MFA-TR*            :4J-EQUIP-SEQ,           :4J-TRANS-HIST-SEQ-NO,      03191900
MFA-TR*            :4J-EQUIP-TAG-NO,        :4J-APPL-PROGRAM-ID,        03192000
MFA-TR*            :4J-TRANS-DATE,          :4J-SOURCE-APPL-CD,         03192100
MFA-TR*            :4J-SOURCE-APPL-REQ-NO,  :4J-WMS-POINT-NO,           03192200
MFA-TR*            :4J-INSTALL-LOC-NO,      :4J-INSTALL-POINT-NO,       03192300
MFA-TR*            :4J-ACCOUNT-NO,          :4J-LAST-UPDATE-USERID,     03192400
MFA-TR*            :4J-TRANS-COMMENTS                                   03192500
MFA-TR*          )                                                      03192600
MFA-TR*    END-EXEC.                                                    03192700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** INSERT ERROR IN 8300                **'       
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** EQUIP-SEQ         = ' 4J-EQUIP-SEQ            
              DISPLAY '** TRANS-HIST-SEQ-NO = ' 4J-TRANS-HIST-SEQ-NO    
              DISPLAY '** INSTALL-LOC-NO    = ' 4J-INSTALL-LOC-NO       
              DISPLAY '** INSTALL-POINT-NO  = ' 4J-INSTALL-POINT-NO     
              DISPLAY '** PROCESSING TERMINATED               **'       
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03194900
      ***************************************************************   03195000
      * INSERT RECORD IN THE LMS TRANSACTION HISTORY DETAIL TABLE.  *   03195100
      ***************************************************************   03195200
      *                                                                 03195300
       8400-INS-LMS-TRN-HSTDET.                                         
                                                                        
           EXEC SQL                                                     
               INSERT INTO LMS_TRANS_HIST_DET                           
               (                                                        
                 EQUIP_SEQ,         TRANS_HIST_SEQ_NO,                  
                 DETAIL_SEQ_NO,     COLUMN_DESC,                        
                 PRV_COLUMN_VALUE,  CHG_COLUMN_VALUE,                   
                 LAST_UPDATE_USERID                                     
               )                                                        
               VALUES                                                   
               (                                                        
                 :4S-EQUIP-SEQ,         CIS.CHAR2TIMESTAMP(
                                                  :4S-TRANS-HIST-SEQ-NO
              ),          
                 :4S-DETAIL-SEQ-NO,     :4S-COLUMN-DESC,                
                 :4S-PRV-COLUMN-VALUE,  :4S-CHG-COLUMN-VALUE,           
                 :4S-LAST-UPDATE-USERID                                 
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03195600
MFA-TR*        INSERT INTO LMS_TRANS_HIST_DET                           03195700
MFA-TR*        (                                                        03195800
MFA-TR*          EQUIP_SEQ,         TRANS_HIST_SEQ_NO,                  03195900
MFA-TR*          DETAIL_SEQ_NO,     COLUMN_DESC,                        03196000
MFA-TR*          PRV_COLUMN_VALUE,  CHG_COLUMN_VALUE,                   03196100
MFA-TR*          LAST_UPDATE_USERID                                     03196200
MFA-TR*        )                                                        03196300
MFA-TR*        VALUES                                                   03196400
MFA-TR*        (                                                        03196500
MFA-TR*          :4S-EQUIP-SEQ,         :4S-TRANS-HIST-SEQ-NO,          03196600
MFA-TR*          :4S-DETAIL-SEQ-NO,     :4S-COLUMN-DESC,                03196700
MFA-TR*          :4S-PRV-COLUMN-VALUE,  :4S-CHG-COLUMN-VALUE,           03196800
MFA-TR*          :4S-LAST-UPDATE-USERID                                 03196900
MFA-TR*        )                                                        03197000
MFA-TR*    END-EXEC.                                                    03197100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD +1                           TO 4S-DETAIL-SEQ-NO      
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** INSERT ERROR IN 8400                **'       
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** EQUIP-SEQ         = ' 4S-EQUIP-SEQ            
              DISPLAY '** TRANS-HIST-SEQ-NO = ' 4S-TRANS-HIST-SEQ-NO    
              DISPLAY '** DETAIL_SEQ_NO     = ' 4S-DETAIL-SEQ-NO        
              DISPLAY '** COLUMN_DESC       = ' 4S-COLUMN-DESC          
              DISPLAY '** PROCESSING TERMINATED               **'       
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03199300
      ******************************************************************03199400
      **                                                              **03200000
      **  9000-TERMINATE.                                             **03210000
      **       TERMINATION ROUTINE                                    **03220000
      **                                                              **03230000
      ******************************************************************03240000
      *                                                                 03250000
       9000-TERMINATE.                                                  
      *                                                                 03270000
           CLOSE FCSLM002-FILE.                                         
           IF FLM02-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*************** PCSLM002 *****************'     
               DISPLAY '**  9000-TERMINATE                      **'     
               DISPLAY '**  CLOSE ERROR OF FCSLM002 - INPUT FILE **'    
               DISPLAY '**         FILE STATUS = ' WS-FLM02-STATUS      
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 03380000
           CLOSE FCSLE002-FILE.                                         
           IF FLE02-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*************** PCSLM002 *****************'     
               DISPLAY '**  9000-TERMINATE                      **'     
               DISPLAY '**  CLOSE ERROR OF FCSLE002 - ERROR FILE **'    
               DISPLAY '**  FILE STATUS = ' WS-FLE02-STATUS             
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03580000
                                                                        
      ************************************************************      03590000
      *                                                          *      03600000
      * COPYBOOK FOR ABEND ROUTINE                               *      03610000
      *                                                          *      03620000
      ************************************************************      03630000
      *                                                                 03640000
           EXEC SQL                                                     03650000
               INCLUDE CPD09900                                         03660000
           END-EXEC.                                                    03670000
      *                                                                 03680000
