       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSLM001.                                            
       DATE-WRITTEN. MAY-2014.                                          
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                SOUTH CAROLINA ELECTRIC & GAS                            
      *                                                                         
      *****************************************************************         
      *                 P R O G R A M  S U M M A R Y                  *         
      *                                                               *         
      *  THIS PROGRAM VALIDATES VENDOR FILE AND LOADS IN INVENTORY.   *         
      *  IS USED TO POST FIXTURE AND NODES. EXCEPTIONS ARE WRITTEN    *         
      *  IN ERROR FILE.                                               *         
      *****************************************************************         
      *                     PROGRAM MODIFICATION LOG                            
      *                                                                         
      *    DATE    INITIALS   COMMENTS                                          
      *  --------  --------   ---------------------------------------           
      *  04/10/14  AS7C117    PROJ#0817 LIGHT MANAGEMENT SYSTEM.                
A05136*  05/25/15  MR7E794    UPDATED WQ CATEGORY AND MESSAGES.                 
A05136*            ACT110                                                       
A#5084*  06/30/15  SS95855    ACT050 EMAIL EXCEPTION REPORT           *         
A05136*  09/29/15  DB41297    ADD CHECK FOR WS-TAG-NO-SW = 'SC'.      *         
A05136*            ACT188                                                       
A05084*  05/10/16  DB41297    ALLOW 'C9' AS A VALID TAG.              *         
A05084*            ACT188                                                       
      *****************************************************************         
      *****************************************************************         
      *                                                                         
      *                ---- BASIC SEQUENCE STRUCTURE ----                       
      *                                                                         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION                      
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                             
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                            
      *  3000 - 4999  NOT USED                                                  
      *  5000 - 5999  COMMON PROGRAM MODULES                                    
      *  6000 - 6999  COMMON SYSTEM MODULES                                     
      *  7000 - 7999  INPUT MODULES                                             
      *  8000 - 8999  OUTPUT MODULES                                            
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES                      
      *                                                                         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSLM001.                                                           
       COPY CSSLE001.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDLM001.                                                           
       COPY FIOLM001.                                                           
       COPY CFDLE001.                                                           
       COPY FIOLE001.                                                           
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSLM001'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)  VALUE               
           'WORKING STORAGE FOR PCSLM001 STARTS HERE'.                  
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-PGM-NAME               PIC X(08)   VALUE 'PCSLM001'.  
           05  WS-SYSTEM                 PIC X(07)   VALUE 'SYSTEM '.   
           05  WS-FIXTURE                PIC X(01)   VALUE 'F'.         
           05  WS-NEW                    PIC X(07)   VALUE '**NEW**'.   
           05  WS-NO                     PIC X(01)   VALUE 'N'.         
           05  WS-TRANS-COMMENTS         PIC X(60)   VALUE              
                                          'ADD NEW LIGHT TO INVENTORY'. 
       01  WS-MISC.                                                     
           05  WS-FLM01-REC-CNTR         PIC 9(08)   VALUE ZERO.        
           05  WS-FLE01-REC-CNTR         PIC 9(08)   VALUE ZERO.        
           05  WS-INSERT-REC-CNTR        PIC 9(08)   VALUE ZERO.        
           05  WS-SQL-CODE               PIC -9(9)   VALUE ZERO.        
           05  WS-ERROR-MSG              PIC X(38)   VALUE SPACES.      
           05  WS-STOCK-CD-NO-EXITS      PIC X(01)   VALUE 'N'.         
           05  WS-WARRANTY-PERIOD        PIC S9(04)  USAGE COMP.        
           05  RS-RETURN-CODE            PIC S9(09)  COMP  VALUE +0.    
           05  MULTIPLE-ROWS-FOUND       PIC S9(9)   VALUE -811 COMP.   
           05  WS-WARR-PER-NUM           PIC 9(02)   VALUE 0.           
                                                                        
       01  WS-DATE-FIELDS.                                              
           05  WS-CURRENT-DATE           PIC X(10)   VALUE SPACES.      
           05  WS-TEMP-PURCHASE-DT       PIC X(10)   VALUE SPACES.      
           05  WS-PURCHASE-DT.                                          
               10 WS-PURCHASE-CCYY       PIC X(04).                     
               10 FILLER                 PIC X(01)   VALUE '-'.         
               10 WS-PURCHASE-MM         PIC X(02).                     
               10 FILLER                 PIC X(01)   VALUE '-'.         
               10 WS-PURCHASE-DD         PIC X(02).                     
           05  WS-PURCH-DATE.                                           
               10  WS-PURCH-DD           PIC X(02)   VALUE SPACES.      
               10  WS-PURCH-MM           PIC X(02)   VALUE SPACES.      
               10  WS-PURCH-YYYY         PIC X(04)   VALUE SPACES.      
           05  WS-DATE-LENGTH.                                          
               10  WS-LEN-SLASH          PIC 9(01)   VALUE 0.           
               10  WS-LEN-DATE           PIC 9(01)   VALUE 0.           
               10  WS-LEN-SPACE          PIC 9(01)   VALUE 0.           
                                                                        
       01  WS-SWITCH.                                                   
           05  WS-FLE01-STATUS           PIC X(02).                     
               88 FLE01-SUCCESSFUL                  VALUE '00'.         
           05  WS-FLM01-STATUS           PIC X(02).                     
               88 FLM01-SUCCESSFUL                  VALUE '00'.         
           05  WS-MORE-DATA-SW           PIC X(01)  VALUE 'Y'.          
               88 NO-MORE-DATA                      VALUE 'N'.          
           05  WS-VALIDATION-SW          PIC X(01)  VALUE 'N'.          
               88 INVALID-RECORD                    VALUE 'Y'.          
               88 VALID-RECORD                      VALUE 'N'.          
           05  WS-TAG-NO-SW              PIC X(02)  VALUE SPACES.       
ACT078         88 VALID-TAG-NO           VALUE '17','40','SC', 'C9'.    
           05  WS-TAG-CHECK              PIC X(01)  VALUE 'N'.          
               88 TAG-EXISTS                        VALUE 'Y'.          
               88 TAG-NOT-EXISTS                    VALUE 'N'.          
           05  WS-STOCK-CD-CHECK         PIC X(01)  VALUE 'N'.          
               88 STOCK-CD-EXISTS                   VALUE 'Y'.          
               88 STOCK-CD-NOT-EXISTS               VALUE 'N'.          
           05  WS-EQUIP-TYPE-CD          PIC X(01)  VALUE ' '.          
               88 EQUIP-TYPE-FIXTURE                VALUE 'F'.          
               88 EQUIP-TYPE-NODE                   VALUE 'N'.          
               88 EQUIP-TYPE-OTHER                  VALUE 'P'.          
ACT050     05  WS-EXCPTN-EMAIL           PIC X(01)  VALUE 'N'.          
ACT050         88 CREATE-EXCPTN-EMAIL               VALUE 'Y'.          
                                                                        
       01  WS-STOCK-CD-GROUPING.                                        
           05  WS-STOCK-CD-STR1          PIC X(15).                     
           05  WS-STOCK-CD-STR2          PIC X(08).                     
           05  WS-STOCK-CD-STR3          PIC X(08).                     
           05  WS-STOCK-CD-STR4          PIC X(08).                     
           05  WS-STOCK-CD-STR5          PIC X(08).                     
           05  WS-STOCK-CD-STR6          PIC X(08).                     
           05  WS-STOCK-CD-STR7          PIC X(08).                     
           05  WS-STOCK-CD-STR8          PIC X(08).                     
                                                                        
       01  WS-UNSTRING-FLM01-REC.                                       
           05  WS-FLM01-MFR-CD           PIC X(02).                     
           05  WS-FLM01-PURCHASE-DT      PIC X(10).                     
           05  WS-FLM01-STOCK-CD         PIC X(25).                     
           05  WS-FLM01-EQUIP-TAG-NO     PIC X(12).                     
           05  WS-FLM01-WARRANTY-PERIOD  PIC X(02).                     
           05  FILLER                    PIC X(59).                     
                                                                        
       01  WS-FLE01-REC.                                                
           05  WS-FLE01-DATA             PIC X(50).                     
           05  WS-FLE01-FLR01            PIC X(01) VALUE ','.           
           05  WS-FLE01-MESG             PIC X(38).                     
           05  WS-FLE01-FLR02            PIC X(11) VALUE SPACES.        
                                                                        
      *****************************************************************         
      * SQL COMMUNICATION AREA                                        *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * LMS_EQUIP_INVENTRY 4D                                         *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBEQPINV                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * LMS_MSTR_STCK_INFO 4A                                         *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBMSTINF                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * LMS_TRANS_HIST    4J                                          *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBLGTHST                                               
            END-EXEC.                                                           
      *                                                                         
      *****************************************************************         
      * LMS_TRANS_HIST_DET  4S                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBLMSHST                                               
            END-EXEC.                                                           
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
                                                                        
       01  WS-END                        PIC X(40)  VALUE               
             'WORKING STORAGE FOR PCSLM001 ENDS HERE  '.                
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
                                                                        
           PERFORM 0200-GET-FIOLM01-DATA       THRU 0200-EXIT.          
                                                                        
           PERFORM 1000-MAIN-PROCESS-PARA      THRU 1000-EXIT           
             UNTIL NO-MORE-DATA.                                        
                                                                        
ACT050     PERFORM 2100-PROCESS-EXCPTNS        THRU 2100-EXIT.          
                                                                        
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      **                                                       **               
      **    0100-INITIALIZATION.                               **               
      **        INITIALIZATION ROUTINE                         **               
      **                                                       **               
      ***********************************************************               
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN OUTPUT FCSLE001-FILE.                                   
           IF FLE01-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  PARA 0100-INITIALIZATION            **'     
               DISPLAY '**  OPEN ERROR OF FCSLE01 - INPUT FILE  **'     
               DISPLAY '**         FILE STATUS = ' WS-FLE01-STATUS      
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           OPEN INPUT FCSLM001-FILE.                                    
           IF FLM01-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  PARA 0100-INITIALIZATION            **'     
               DISPLAY '**  OPEN ERROR OF FCSLM01 - INPUT FILE  **'     
               DISPLAY '**         FILE STATUS = ' WS-FLM01-STATUS      
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
           PERFORM 7500-GET-CURRENT-DATE         THRU 7500-EXIT.        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      **                                                       **               
      **    0200-GET-FIOLM01-DATA.                             **               
      **        INITIALIZATION ROUTINE                         **               
      **                                                       **               
      ***********************************************************               
                                                                        
       0200-GET-FIOLM01-DATA.                                           
                                                                        
           PERFORM 7100-READ-FCSLM01           THRU 7100-EXIT.          
                                                                        
           IF FLM01-SUCCESSFUL                                          
              INITIALIZE  WS-UNSTRING-FLM01-REC                         
              UNSTRING E-FLM01-DATA-REC DELIMITED BY ','                
                  INTO WS-FLM01-MFR-CD                                  
                       WS-FLM01-PURCHASE-DT                             
                       WS-FLM01-STOCK-CD                                
                       WS-FLM01-EQUIP-TAG-NO                            
                       WS-FLM01-WARRANTY-PERIOD                         
              END-UNSTRING                                              
           END-IF.                                                      
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************************************************             
      **                                                         **             
      **      1000-MAIN-PROCESS-PARA                             **             
      **           MAIN PROCESS                                  **             
      **                                                         **             
      *************************************************************             
                                                                        
       1000-MAIN-PROCESS-PARA.                                          
                                                                        
           PERFORM 2000-VALIDATE-INPUTS          THRU 2000-EXIT.        
                                                                        
           IF INVALID-RECORD                                            
ACT050        SET CREATE-EXCPTN-EMAIL TO TRUE                           
              INITIALIZE E-FLE01-DATA                                   
              MOVE E-FLM01-DATA-REC(1:50)     TO WS-FLE01-DATA          
              MOVE WS-ERROR-MSG               TO WS-FLE01-MESG          
              MOVE WS-FLE01-REC               TO E-FLE01-DATA           
              PERFORM 8200-WRITE-ERROR-FILE      THRU 8200-EXIT         
           ELSE                                                         
              MOVE '01'                       TO 4D-COMPANY-NO          
              MOVE 'E'                        TO 4D-CODE-SERVICE-TYPE   
              MOVE WS-FLM01-EQUIP-TAG-NO      TO 4D-EQUIP-TAG-NO        
              MOVE WS-EQUIP-TYPE-CD           TO 4D-EQUIP-TYPE-CD       
              MOVE WS-FLM01-MFR-CD            TO 4D-EQUIP-MFR-CD        
              MOVE WS-WARR-PER-NUM            TO WS-WARRANTY-PERIOD     
              MOVE WS-PURCHASE-DT             TO 4D-EQUIP-MFR-DT        
                                                 WS-TEMP-PURCHASE-DT    
              MOVE '30'                       TO 4D-STORAGE-FAC-CD      
              MOVE 'I'                        TO 4D-INVENTRY-STATUS-CD  
              MOVE SPACES                     TO 4D-IN-TRANSIT-USERID   
              MOVE WS-SYSTEM                  TO 4D-LAST-UPDATE-USERID  
                                                                        
              PERFORM 7300-GET-WARRANTY-EXP-DT   THRU 7300-EXIT         
              MOVE 4D-WARRANTY-EXP-DT         TO 4D-EQUIP-DISPOSAL-DT   
              PERFORM 8100-INSERT-LMS-INVENTORY  THRU 8100-EXIT         
              IF 4D-EQUIP-TYPE-CD = WS-FIXTURE                          
                 PERFORM 7600-CHECK-INVTRY       THRU 7600-EXIT         
                 PERFORM 5000-WRITE-TRAN-HIST    THRU 5000-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 0200-GET-FIOLM01-DATA       THRU 0200-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
       2000-VALIDATE-INPUTS.                                            
      *                                                                         
           INITIALIZE  WS-DATE-LENGTH                                   
                       WS-STOCK-CD-GROUPING.                            
           SET VALID-RECORD TO TRUE.                                    
           SET TAG-NOT-EXISTS TO TRUE.                                  
           SET STOCK-CD-NOT-EXISTS TO TRUE.                             
           MOVE 0                            TO WS-WARR-PER-NUM.        
           MOVE SPACES                       TO WS-ERROR-MSG            
                                                WS-PURCH-DATE           
                                                WS-TAG-NO-SW            
                                                4D-STOCK-CD             
                                                4D-EQUIP-TAG-NO.        
      *                                                                         
           PERFORM 7200-TAG-NO-CASE-CNVRSN      THRU 7200-EXIT.         
      *                                                                         
           MOVE WS-FLM01-EQUIP-TAG-NO        TO 4D-EQUIP-TAG-NO.        
           PERFORM 7600-CHECK-INVTRY            THRU 7600-EXIT.         
           IF TAG-EXISTS                                                
              EVALUATE TRUE                                             
                 WHEN EQUIP-TYPE-NODE                                   
                    MOVE 'NODE ALREADY EXISTS'    TO WS-ERROR-MSG       
                 WHEN EQUIP-TYPE-FIXTURE                                
                    MOVE 'FIXTURE ALREADY EXISTS' TO WS-ERROR-MSG       
                 WHEN EQUIP-TYPE-OTHER                                  
                    MOVE 'ROW ALREADY EXISTS'     TO WS-ERROR-MSG       
              END-EVALUATE                                              
              SET INVALID-RECORD TO TRUE                                
              GO TO 2000-EXIT                                           
           END-IF.                                                      
      *                                                                         
           IF WS-FLM01-MFR-CD(1:1) = ' '                                
              OR WS-FLM01-MFR-CD(2:1) = ' '                             
              MOVE 'INVALID MANUFACTURER CD' TO WS-ERROR-MSG            
              SET INVALID-RECORD TO TRUE                                
              GO TO 2000-EXIT                                           
           END-IF.                                                      
      *                                                                         
           PERFORM 2010-FORMAT-PURCH-DT         THRU 2010-EXIT.         
      *                                                                         
           UNSTRING WS-FLM01-STOCK-CD DELIMITED BY ALL SPACES           
               INTO WS-STOCK-CD-STR1                                    
                    WS-STOCK-CD-STR2                                    
                    WS-STOCK-CD-STR3                                    
                    WS-STOCK-CD-STR4                                    
                    WS-STOCK-CD-STR5                                    
                    WS-STOCK-CD-STR6                                    
                    WS-STOCK-CD-STR7                                    
                    WS-STOCK-CD-STR8                                    
           END-UNSTRING.                                                
                                                                        
           STRING WS-STOCK-CD-STR1 DELIMITED BY SPACES                  
                  WS-STOCK-CD-STR2 DELIMITED BY SPACES                  
                  WS-STOCK-CD-STR3 DELIMITED BY SPACES                  
                  WS-STOCK-CD-STR4 DELIMITED BY SPACES                  
                  WS-STOCK-CD-STR5 DELIMITED BY SPACES                  
                  WS-STOCK-CD-STR6 DELIMITED BY SPACES                  
                  WS-STOCK-CD-STR7 DELIMITED BY SPACES                  
                  WS-STOCK-CD-STR8 DELIMITED BY SPACES                  
             INTO 4D-STOCK-CD.                                          
                                                                        
           PERFORM 7400-CHECK-STOCK-CD       THRU 7400-EXIT.            
           IF STOCK-CD-NOT-EXISTS                                       
              MOVE 'STOCK CODE NOT IN LMS'   TO WS-ERROR-MSG            
              SET INVALID-RECORD TO TRUE                                
              GO TO 2000-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE WS-FLM01-EQUIP-TAG-NO(1:2)   TO   WS-TAG-NO-SW.         
           IF EQUIP-TYPE-FIXTURE                                        
              AND NOT VALID-TAG-NO                                      
ACT078        MOVE 'TAG# MUST BE 17*/40*/C9*'  TO WS-ERROR-MSG          
              SET INVALID-RECORD TO TRUE                                
              GO TO 2000-EXIT                                           
           END-IF.                                                      
      *                                                                         
ACT188     IF WS-TAG-NO-SW = 'SC'                                       
ACT188        GO TO 2000-EXIT                                           
ACT188     END-IF.                                                      
ACT188*                                                                         
           IF WS-FLM01-WARRANTY-PERIOD(2:1) = SPACES                    
              IF WS-FLM01-WARRANTY-PERIOD(1:1) > SPACES                 
                 MOVE WS-FLM01-WARRANTY-PERIOD(1:1)                     
                                       TO WS-WARR-PER-NUM(2:1)          
                 MOVE '0'              TO WS-WARR-PER-NUM(1:1)          
              END-IF                                                    
           ELSE                                                         
              MOVE WS-FLM01-WARRANTY-PERIOD                             
                                       TO WS-WARR-PER-NUM               
           END-IF.                                                      
                                                                        
           IF WS-WARR-PER-NUM <= 0                                      
              MOVE 'INVALID WARRANTY PERIOD' TO WS-ERROR-MSG            
              SET INVALID-RECORD TO TRUE                                
              GO TO 2000-EXIT                                           
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2010-FORMAT-PURCH-DT.                                            
      *                                                                         
           INSPECT WS-FLM01-PURCHASE-DT TALLYING WS-LEN-SLASH           
                                        FOR ALL '/'.                    
                                                                        
           EVALUATE WS-LEN-SLASH                                        
              WHEN ZERO                                                 
                 PERFORM 2020-FORMAT-DATE-WO-SLASH                      
                                               THRU 2020-EXIT           
              WHEN 2                                                    
                 UNSTRING WS-FLM01-PURCHASE-DT DELIMITED BY '/'         
                     INTO WS-PURCH-MM                                   
                          WS-PURCH-DD                                   
                          WS-PURCH-YYYY                                 
                 END-UNSTRING                                           
              WHEN OTHER                                                
                 MOVE 'INVALID PURCHASE-DATE'                           
                                       TO WS-ERROR-MSG                  
                 SET INVALID-RECORD    TO TRUE                          
                 GO                    TO 2000-EXIT                     
           END-EVALUATE.                                                
                                                                        
           PERFORM 2030-VALIDATE-DATE          THRU 2030-EXIT.          
      *                                                                         
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2020-FORMAT-DATE-WO-SLASH.                                       
      *                                                                         
           INSPECT FUNCTION REVERSE(WS-FLM01-PURCHASE-DT) TALLYING      
                                    WS-LEN-SPACE FOR LEADING SPACES.    
                                                                        
           COMPUTE WS-LEN-DATE = LENGTH OF WS-FLM01-PURCHASE-DT         
                                         - WS-LEN-SPACE.                
                                                                        
           EVALUATE WS-LEN-DATE                                         
              WHEN 8                                                    
                 MOVE WS-FLM01-PURCHASE-DT(1:2)                         
                                       TO WS-PURCH-MM                   
                 MOVE WS-FLM01-PURCHASE-DT(3:2)                         
                                       TO WS-PURCH-DD                   
                 MOVE WS-FLM01-PURCHASE-DT(5:4)                         
                                       TO WS-PURCH-YYYY                 
              WHEN 7                                                    
                 IF WS-FLM01-PURCHASE-DT(1:2) > 12                      
                    MOVE WS-FLM01-PURCHASE-DT(1:1)                      
                                       TO WS-PURCH-MM                   
                    MOVE WS-FLM01-PURCHASE-DT(2:2)                      
                                       TO WS-PURCH-DD                   
                    MOVE WS-FLM01-PURCHASE-DT(4:4)                      
                                       TO WS-PURCH-YYYY                 
                 ELSE                                                   
                    MOVE WS-FLM01-PURCHASE-DT(1:2)                      
                                       TO WS-PURCH-MM                   
                    MOVE WS-FLM01-PURCHASE-DT(3:1)                      
                                       TO WS-PURCH-DD                   
                    MOVE WS-FLM01-PURCHASE-DT(4:4)                      
                                       TO WS-PURCH-YYYY                 
                 END-IF                                                 
              WHEN 6                                                    
                 MOVE WS-FLM01-PURCHASE-DT(1:1)                         
                                       TO WS-PURCH-MM                   
                 MOVE WS-FLM01-PURCHASE-DT(2:1)                         
                                       TO WS-PURCH-DD                   
                 MOVE WS-FLM01-PURCHASE-DT(3:6)                         
                                       TO WS-PURCH-YYYY                 
              WHEN OTHER                                                
                 MOVE 'INVALID PURCHASE-DATE'                           
                                       TO WS-ERROR-MSG                  
                 SET INVALID-RECORD    TO TRUE                          
                 GO                    TO 2000-EXIT                     
           END-EVALUATE.                                                
                                                                        
      *                                                                         
       2020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2030-VALIDATE-DATE.                                              
      *                                                                         
           IF WS-PURCH-MM(2:1) = SPACES                                 
              IF WS-PURCH-MM(1:1) > SPACES                              
                 MOVE WS-PURCH-MM(1:1) TO WS-PURCH-MM(2:1)              
                 MOVE '0'              TO WS-PURCH-MM(1:1)              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-PURCH-DD(2:1) = SPACES                                 
              IF WS-PURCH-DD(1:1) > SPACES                              
                 MOVE WS-PURCH-DD(1:1) TO WS-PURCH-DD(2:1)              
                 MOVE '0'              TO WS-PURCH-DD(1:1)              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-PURCH-DD IS NUMERIC                                    
              AND WS-PURCH-MM IS NUMERIC                                
              AND WS-PURCH-YYYY IS NUMERIC                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'INVALID PURCHASE-DATE'   TO WS-ERROR-MSG            
              SET INVALID-RECORD TO TRUE                                
              GO TO 2000-EXIT                                           
           END-IF.                                                      
                                                                        
           IF WS-PURCH-MM <= '00'                                       
              OR WS-PURCH-MM > '12'                                     
              MOVE 'INVALID PURCHASE-DATE MONTH'                        
                                          TO WS-ERROR-MSG               
              SET INVALID-RECORD TO TRUE                                
              GO TO 2000-EXIT                                           
           END-IF.                                                      
                                                                        
           IF WS-PURCH-DD <= '00'                                       
              OR WS-PURCH-DD > '31'                                     
              MOVE 'INVALID PURCHASE-DATE DAY'                          
                                          TO WS-ERROR-MSG               
              SET INVALID-RECORD TO TRUE                                
              GO TO 2000-EXIT                                           
           END-IF.                                                      
                                                                        
           IF WS-PURCH-YYYY <= '0000'                                   
              MOVE 'INVALID PURCHASE-DATE YEAR'                         
                                          TO WS-ERROR-MSG               
              SET INVALID-RECORD TO TRUE                                
              GO TO 2000-EXIT                                           
           END-IF.                                                      
      *                                                                         
           MOVE WS-PURCH-MM                TO WS-PURCHASE-MM.           
           MOVE WS-PURCH-DD                TO WS-PURCHASE-DD.           
           MOVE WS-PURCH-YYYY              TO WS-PURCHASE-CCYY.         
      *                                                                         
       2030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT050 2100-PROCESS-EXCPTNS.                                            
      *                                                                         
ACT050*** EMAIL EXCPTNS TO GROUP, FORCING RC TO 05                              
ACT050     IF CREATE-EXCPTN-EMAIL                                       
ACT050        MOVE 05                        TO  RETURN-CODE            
ACT050        DISPLAY '                                     '           
ACT050        DISPLAY '*************************************'           
ACT050        DISPLAY '*           PCSLM001                *'           
ACT050        DISPLAY '*    VENDOR FILE HAS EXCEPTIONS     *'           
ACT050        DISPLAY '*       EMAILING EXCETIONS          *'           
ACT050        DISPLAY '*  RC=05 IS SUCCESSFUL EXECUTION    *'           
ACT050        DISPLAY '*************************************'           
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5000-WRITE-TRAN-HIST                                           *        
      ******************************************************************        
       5000-WRITE-TRAN-HIST.                                            
                                                                        
            INITIALIZE DCLLMS-TRANS-HIST                                
                       DCLLMS-TRANS-HIST-DET.                           
                                                                        
            MOVE 4D-EQUIP-SEQ               TO 4J-EQUIP-SEQ             
                                               4S-EQUIP-SEQ.            
            MOVE 4D-EQUIP-TAG-NO            TO 4J-EQUIP-TAG-NO.         
            MOVE WS-PGM-NAME                TO 4J-APPL-PROGRAM-ID.      
            MOVE WS-SYSTEM                  TO 4J-LAST-UPDATE-USERID    
                                               4S-LAST-UPDATE-USERID.   
            MOVE +1                         TO 4S-DETAIL-SEQ-NO.        
            MOVE WS-TRANS-COMMENTS          TO 4J-TRANS-COMMENTS-TEXT.  
            MOVE LENGTH OF WS-TRANS-COMMENTS                            
                                            TO 4J-TRANS-COMMENTS-LEN.   
      *                                                                         
            MOVE 'FXTR_TAG_NO'              TO 4S-COLUMN-DESC.          
            MOVE WS-NEW                     TO 4S-PRV-COLUMN-VALUE-TEXT.
            MOVE LENGTH OF WS-NEW           TO 4S-PRV-COLUMN-VALUE-LEN. 
            MOVE 4D-EQUIP-TAG-NO            TO 4S-CHG-COLUMN-VALUE-TEXT.
            MOVE LENGTH OF 4D-EQUIP-TAG-NO  TO 4S-CHG-COLUMN-VALUE-LEN. 
                                                                        
            PERFORM 5100-LOAD-LMS-TARNS-HST  THRU 5100-EXIT.            
      *                                                                         
            MOVE 'FXTR_STOCK_CD'            TO 4S-COLUMN-DESC.          
            MOVE WS-NEW                     TO 4S-PRV-COLUMN-VALUE-TEXT.
            MOVE LENGTH OF WS-NEW           TO 4S-PRV-COLUMN-VALUE-LEN. 
            MOVE 4D-STOCK-CD                TO 4S-CHG-COLUMN-VALUE-TEXT.
            MOVE LENGTH OF 4D-STOCK-CD      TO 4S-CHG-COLUMN-VALUE-LEN. 
                                                                        
            PERFORM 5100-LOAD-LMS-TARNS-HST  THRU 5100-EXIT.            
      *                                                                         
            MOVE 'FXTR_EQUIP_MFR_CD'        TO 4S-COLUMN-DESC.          
            MOVE WS-NEW                     TO 4S-PRV-COLUMN-VALUE-TEXT.
            MOVE LENGTH OF WS-NEW           TO 4S-PRV-COLUMN-VALUE-LEN. 
            MOVE 4D-EQUIP-MFR-CD            TO 4S-CHG-COLUMN-VALUE-TEXT.
            MOVE LENGTH OF 4D-EQUIP-MFR-CD  TO 4S-CHG-COLUMN-VALUE-LEN. 
                                                                        
            PERFORM 5100-LOAD-LMS-TARNS-HST  THRU 5100-EXIT.            
      *                                                                         
            MOVE 'EQUIP_MFR_DT'             TO 4S-COLUMN-DESC.          
            MOVE WS-NEW                     TO 4S-PRV-COLUMN-VALUE-TEXT.
            MOVE LENGTH OF WS-NEW           TO 4S-PRV-COLUMN-VALUE-LEN. 
            MOVE 4D-EQUIP-MFR-DT            TO 4S-CHG-COLUMN-VALUE-TEXT.
            MOVE LENGTH OF 4D-EQUIP-MFR-DT  TO 4S-CHG-COLUMN-VALUE-LEN. 
                                                                        
            PERFORM 5100-LOAD-LMS-TARNS-HST  THRU 5100-EXIT.            
      *                                                                         
            MOVE 'WARRANTY_EXP_DT'          TO 4S-COLUMN-DESC.          
            MOVE WS-NEW                     TO 4S-PRV-COLUMN-VALUE-TEXT.
            MOVE LENGTH OF WS-NEW           TO 4S-PRV-COLUMN-VALUE-LEN. 
            MOVE 4D-WARRANTY-EXP-DT         TO 4S-CHG-COLUMN-VALUE-TEXT.
            MOVE LENGTH OF 4D-WARRANTY-EXP-DT                           
                                            TO 4S-CHG-COLUMN-VALUE-LEN. 
            PERFORM 5100-LOAD-LMS-TARNS-HST  THRU 5100-EXIT.            
      *                                                                         
            MOVE 'STORAGE_FAC_CD'           TO 4S-COLUMN-DESC.          
            MOVE WS-NEW                     TO 4S-PRV-COLUMN-VALUE-TEXT.
            MOVE LENGTH OF WS-NEW           TO 4S-PRV-COLUMN-VALUE-LEN. 
            MOVE 4D-STORAGE-FAC-CD          TO 4S-CHG-COLUMN-VALUE-TEXT.
            MOVE LENGTH OF 4D-STORAGE-FAC-CD                            
                                            TO 4S-CHG-COLUMN-VALUE-LEN. 
            PERFORM 5100-LOAD-LMS-TARNS-HST  THRU 5100-EXIT.            
      *                                                                         
            MOVE 'FXTR_INVNTRY_ST_CD'       TO 4S-COLUMN-DESC.          
            MOVE WS-NEW                     TO 4S-PRV-COLUMN-VALUE-TEXT.
            MOVE LENGTH OF WS-NEW           TO 4S-PRV-COLUMN-VALUE-LEN. 
            MOVE 4D-INVENTRY-STATUS-CD      TO 4S-CHG-COLUMN-VALUE-TEXT.
            MOVE LENGTH OF 4D-INVENTRY-STATUS-CD                        
                                            TO 4S-CHG-COLUMN-VALUE-LEN. 
            PERFORM 5100-LOAD-LMS-TARNS-HST  THRU 5100-EXIT.            
      *                                                                         
       5000-EXIT.                                                       
             EXIT.                                                      
      *                                                                         
      ******************************************************************        
      * LOAD LMS TRANSACTION HISTORY DETAILS FOR TYPE FIXTURE          *        
      ******************************************************************        
      *                                                                         
       5100-LOAD-LMS-TARNS-HST.                                         
                                                                        
            IF 4S-DETAIL-SEQ-NO EQUAL 1                                 
               MOVE WS-CURRENT-DATE         TO 4J-TRANS-DATE            
               PERFORM 7000-GET-CURR-TS      THRU 7000-EXIT             
                                                                        
               PERFORM 8300-INS-LMS-TRN-HST  THRU 8300-EXIT             
               PERFORM 8400-INS-LMS-TRN-HSTDET                          
                                             THRU 8400-EXIT             
            ELSE                                                        
               PERFORM 8400-INS-LMS-TRN-HSTDET                          
                                             THRU 8400-EXIT             
            END-IF.                                                     
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *GET CURRENT TIMESTAMP TO INSERT INTO TRANSACTION HISTORY                 
      ******************************************************************        
                                                                        
       7000-GET-CURR-TS.                                                
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :4J-TRANS-HIST-SEQ-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :4J-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          WS-SQL-CODE                   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE 4J-TRANS-HIST-SEQ-NO        TO 4S-TRANS-HIST-SEQ-NO 
           ELSE                                                         
               DISPLAY '**  SELECT ERROR IN 7000                **'     
               DISPLAY '**  RETURN CODE = ' WS-SQL-CODE                 
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7100-READ-FCSLM01                                        **          
      **       READS DATA RECORD FROM THE INPUT FILE FCSLM01        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7100-READ-FCSLM01.                                               
      *                                                                         
           READ FCSLM001-FILE                                           
               AT END                                                   
                   MOVE WS-NO          TO WS-MORE-DATA-SW               
                   GO                  TO 7100-EXIT.                    
      *                                                                         
           IF FLM01-SUCCESSFUL                                          
               ADD 1                   TO WS-FLM01-REC-CNTR             
           ELSE                                                         
               DISPLAY '**  PARA  7100-READ-FCSLM01             **'     
               DISPLAY '**  READ ERROR OF FCSLM01 - INPUT FILE  **'     
               DISPLAY '**         FILE STATUS = ' WS-FLM01-STATUS      
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
       7200-TAG-NO-CASE-CNVRSN.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT
              UPPER(:WS-FLM01-EQUIP-TAG-NO)
            INTO
              :WS-FLM01-EQUIP-TAG-NO
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-FLM01-EQUIP-TAG-NO = UPPER(:WS-FLM01-EQUIP-TAG-NO)        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                WS-SQL-CODE.            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '**  SET STATEMENT ERROR 7200- PARA      **'     
               DISPLAY '**  RETURN CODE = ' WS-SQL-CODE                 
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7300-GET-WARRANTY-EXP-DT.                                **         
      *****************************************************************         
                                                                        
       7300-GET-WARRANTY-EXP-DT.                                        
                                                                        
           EXEC SQL                                                     
             SELECT
              DATEADD( YEAR, :WS-WARRANTY-PERIOD, IIF(TRY_CONVERT(DATE, 
                                                   :WS-TEMP-PURCHASE-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-TEMP-PURCHASE-DT
              ) <> 0) OR (LEN(:WS-TEMP-PURCHASE-DT
              ) <> 10), CIS.CHAR2DATE(:WS-TEMP-PURCHASE-DT
              ), CONVERT(DATE, :WS-TEMP-PURCHASE-DT) ) )
            INTO
              :4D-WARRANTY-EXP-DT                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :4D-WARRANTY-EXP-DT   =                                        
MFA-TR*          DATE(:WS-TEMP-PURCHASE-DT) +                                   
MFA-TR*          :WS-WARRANTY-PERIOD YEARS                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                WS-SQL-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '**  SET ERROR IN 7300-                  **'     
               DISPLAY '**  RETURN CODE = ' WS-SQL-CODE                 
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      ****************************************************************          
      **                                                            **          
      **      7400-CHECK-STOCK-CD.                                  **          
      **      CHECKS STOCK CD IN LMS_MSTR_STCK_INFO                 **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7400-CHECK-STOCK-CD.                                             
      *                                                                         
           EXEC SQL                                                     
               SELECT 'Y'                                               
                     ,[4A].EQUIP_TYPE_CD                                  
                 INTO :WS-STOCK-CD-CHECK                                
                     ,:WS-EQUIP-TYPE-CD                                 
                 FROM LMS_MSTR_STCK_INFO [4A] WITH(READUNCOMMITTED)             
                WHERE [4A].STOCK_CD          = :4D-STOCK-CD               
                  AND [4A].COMPANY_NO        = '01'                       
                  AND [4A].CODE_SERVICE_TYPE = 'E'                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*              ,4A.EQUIP_TYPE_CD                                          
MFA-TR*          INTO :WS-STOCK-CD-CHECK                                        
MFA-TR*              ,:WS-EQUIP-TYPE-CD                                         
MFA-TR*          FROM LMS_MSTR_STCK_INFO 4A                                     
MFA-TR*         WHERE 4A.STOCK_CD          = :4D-STOCK-CD                       
MFA-TR*           AND 4A.COMPANY_NO        = '01'                               
MFA-TR*           AND 4A.CODE_SERVICE_TYPE = 'E'                                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-SQL-CODE.                                 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND                                              
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '**  SELECT ERROR IN 7400-               **'     
               DISPLAY '**  RETURN CODE = ' WS-SQL-CODE                 
               DISPLAY '**  STOCK-CD    = ' 4D-STOCK-CD                 
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7500-GET-CURRENT-DATE.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE  = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                WS-SQL-CODE.            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '**  SET STATEMENT ERROR 7500- PARA      **'     
               DISPLAY '**  RETURN CODE = ' WS-SQL-CODE                 
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7600-CHECK-INVTRY                                              *        
      ******************************************************************        
       7600-CHECK-INVTRY.                                               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y',
              [4D].EQUIP_TYPE_CD,
              [4D].EQUIP_SEQ                                       
                INTO :WS-TAG-CHECK                                      
                    ,:WS-EQUIP-TYPE-CD                                  
                    ,:4D-EQUIP-SEQ                                      
                FROM LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)              
               WHERE [4D].EQUIP_TAG_NO = :4D-EQUIP-TAG-NO                 
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*             ,4D.EQUIP_TYPE_CD                                           
MFA-TR*             ,4D.EQUIP_SEQ                                               
MFA-TR*         INTO :WS-TAG-CHECK                                              
MFA-TR*             ,:WS-EQUIP-TYPE-CD                                          
MFA-TR*             ,:4D-EQUIP-SEQ                                              
MFA-TR*         FROM LMS_EQUIP_INVENTRY 4D                                      
MFA-TR*        WHERE 4D.EQUIP_TAG_NO = :4D-EQUIP-TAG-NO                         
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*      QUERYNO 7600                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-PGM-NAME              TO ABEND-PROGRAM            
              MOVE '7600'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_INVENTRY'     TO TABLE-1                  
              MOVE 'EQUIP_TAG_NO'           TO TABLE-ELEMENT-2          
              MOVE 4D-EQUIP-TAG-NO          TO HOSTVAR-ELEMENT-2        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * INSERT RECORD IN THE LMS EQUIP INVENTRY TABLE.              *           
      ***************************************************************           
      *                                                                         
       8100-INSERT-LMS-INVENTORY.                                       
                                                                        
           EXEC SQL                                                     
           INSERT INTO LMS_EQUIP_INVENTRY                               
                  ( EQUIP_SEQ                                           
                   ,EQUIP_TAG_NO                                        
                   ,COMPANY_NO                                          
                   ,CODE_SERVICE_TYPE                                   
                   ,STOCK_CD                                            
                   ,EQUIP_TYPE_CD                                       
                   ,EQUIP_MFR_CD                                        
                   ,EQUIP_MFR_DT                                        
                   ,WARRANTY_EXP_DT                                     
                   ,EQUIP_DISPOSAL_DT                                   
                   ,STORAGE_FAC_CD                                      
                   ,IN_TRANSIT_USERID                                   
                   ,INVENTRY_STATUS_CD                                  
                   ,LAST_UPDATE_TS                                      
                   ,LAST_UPDATE_USERID )                                
           VALUES ( NEXT VALUE FOR SEQ_ID_EQUIP_SEQ                     
                  ,:4D-EQUIP-TAG-NO                                     
                  ,:4D-COMPANY-NO                                       
                  ,:4D-CODE-SERVICE-TYPE                                
                  ,:4D-STOCK-CD                                         
                  ,:4D-EQUIP-TYPE-CD                                    
                  ,:4D-EQUIP-MFR-CD                                     
                  ,IIF(TRY_CONVERT(DATE, :4D-EQUIP-MFR-DT
              ) IS NULL OR (PATINDEX('%.%', :4D-EQUIP-MFR-DT
              ) <> 0) OR (LEN(:4D-EQUIP-MFR-DT) <> 10), CIS.CHAR2DATE(
                                                       :4D-EQUIP-MFR-DT
              ), CONVERT(DATE, :4D-EQUIP-MFR-DT) )                             
                  ,IIF(TRY_CONVERT(DATE, :4D-WARRANTY-EXP-DT
              ) IS NULL OR (PATINDEX('%.%', :4D-WARRANTY-EXP-DT
              ) <> 0) OR (LEN(:4D-WARRANTY-EXP-DT
              ) <> 10), CIS.CHAR2DATE(:4D-WARRANTY-EXP-DT
              ), CONVERT(DATE, :4D-WARRANTY-EXP-DT) )                          
                  ,IIF(TRY_CONVERT(DATE, :4D-EQUIP-DISPOSAL-DT
              ) IS NULL OR (PATINDEX('%.%', :4D-EQUIP-DISPOSAL-DT
              ) <> 0) OR (LEN(:4D-EQUIP-DISPOSAL-DT
              ) <> 10), CIS.CHAR2DATE(:4D-EQUIP-DISPOSAL-DT
              ), CONVERT(DATE, :4D-EQUIP-DISPOSAL-DT) )                        
                  ,:4D-STORAGE-FAC-CD                                   
                  ,:4D-IN-TRANSIT-USERID                                
                  ,:4D-INVENTRY-STATUS-CD                               
                  ,CIS.CURRENT$TIMESTAMP()                                    
                  ,:4D-LAST-UPDATE-USERID )                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    INSERT INTO LMS_EQUIP_INVENTRY                                       
MFA-TR*           ( EQUIP_SEQ                                                   
MFA-TR*            ,EQUIP_TAG_NO                                                
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,CODE_SERVICE_TYPE                                           
MFA-TR*            ,STOCK_CD                                                    
MFA-TR*            ,EQUIP_TYPE_CD                                               
MFA-TR*            ,EQUIP_MFR_CD                                                
MFA-TR*            ,EQUIP_MFR_DT                                                
MFA-TR*            ,WARRANTY_EXP_DT                                             
MFA-TR*            ,EQUIP_DISPOSAL_DT                                           
MFA-TR*            ,STORAGE_FAC_CD                                              
MFA-TR*            ,IN_TRANSIT_USERID                                           
MFA-TR*            ,INVENTRY_STATUS_CD                                          
MFA-TR*            ,LAST_UPDATE_TS                                              
MFA-TR*            ,LAST_UPDATE_USERID )                                        
MFA-TR*    VALUES ( NEXT VALUE FOR SEQ_ID_EQUIP_SEQ                             
MFA-TR*           ,:4D-EQUIP-TAG-NO                                             
MFA-TR*           ,:4D-COMPANY-NO                                               
MFA-TR*           ,:4D-CODE-SERVICE-TYPE                                        
MFA-TR*           ,:4D-STOCK-CD                                                 
MFA-TR*           ,:4D-EQUIP-TYPE-CD                                            
MFA-TR*           ,:4D-EQUIP-MFR-CD                                             
MFA-TR*           ,:4D-EQUIP-MFR-DT                                             
MFA-TR*           ,:4D-WARRANTY-EXP-DT                                          
MFA-TR*           ,:4D-EQUIP-DISPOSAL-DT                                        
MFA-TR*           ,:4D-STORAGE-FAC-CD                                           
MFA-TR*           ,:4D-IN-TRANSIT-USERID                                        
MFA-TR*           ,:4D-INVENTRY-STATUS-CD                                       
MFA-TR*           ,CURRENT TIMESTAMP                                            
MFA-TR*           ,:4D-LAST-UPDATE-USERID )                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE         
                                          WS-SQL-CODE                   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD 1                   TO WS-INSERT-REC-CNTR             
           ELSE                                                         
               DISPLAY '**  INSERT ERROR IN 8100-               **'     
               DISPLAY '**  RETURN CODE = ' WS-SQL-CODE                 
               DISPLAY '**  EQUIP-TAG-NO  ' 4D-EQUIP-TAG-NO             
               DISPLAY '**  COMPANY-NO    ' 4D-COMPANY-NO               
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *WRITES THE RECORD IN THE ERROR  FILE                           **        
      ******************************************************************        
      *                                                                         
       8200-WRITE-ERROR-FILE.                                           
                                                                        
           WRITE FIOLE001-REC.                                          
           IF FLE01-SUCCESSFUL                                          
               ADD 1                   TO WS-FLE01-REC-CNTR             
           ELSE                                                         
               DISPLAY '**  PARA 8200-WRITE-ERROR-FILE          **'     
               DISPLAY '**  WRITE ERROR OF FCSLE01 - INPUT FILE **'     
               DISPLAY '**         FILE STATUS = ' WS-FLE01-STATUS      
               DISPLAY '**         PROCESSING TERMINATED        **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * INSERT RECORD IN THE LMS TRANSACTION HISTORY TABLE.         *           
      ***************************************************************           
      *                                                                         
       8300-INS-LMS-TRN-HST.                                            
                                                                        
           EXEC SQL                                                     
               INSERT INTO LMS_TRANS_HIST                               
                 (                                                      
                   EQUIP_SEQ,           TRANS_HIST_SEQ_NO,              
                   EQUIP_TAG_NO,        APPL_PROGRAM_ID,                
                   TRANS_DATE,          SOURCE_APPL_CD,                 
                   SOURCE_APPL_REQ_NO,  WMS_POINT_NO,                   
                   INSTALL_LOC_NO,      INSTALL_POINT_NO,               
                   ACCOUNT_NO,          LAST_UPDATE_USERID,             
                   TRANS_COMMENTS                                       
                 )                                                      
               VALUES                                                   
                 (                                                      
                   :4J-EQUIP-SEQ,           CIS.CHAR2TIMESTAMP(
                                                  :4J-TRANS-HIST-SEQ-NO
              ),      
                   :4J-EQUIP-TAG-NO,        :4J-APPL-PROGRAM-ID,        
                   IIF(TRY_CONVERT(DATE, :4J-TRANS-DATE
              ) IS NULL OR (PATINDEX('%.%', :4J-TRANS-DATE
              ) <> 0) OR (LEN(:4J-TRANS-DATE) <> 10), CIS.CHAR2DATE(
                                                         :4J-TRANS-DATE
              ), CONVERT(DATE, :4J-TRANS-DATE) ),          
                                                    :4J-SOURCE-APPL-CD,        
                   :4J-SOURCE-APPL-REQ-NO,  :4J-WMS-POINT-NO,           
                   :4J-INSTALL-LOC-NO,      :4J-INSTALL-POINT-NO,       
                   :4J-ACCOUNT-NO,          :4J-LAST-UPDATE-USERID,     
                   :4J-TRANS-COMMENTS                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO LMS_TRANS_HIST                                       
MFA-TR*          (                                                              
MFA-TR*            EQUIP_SEQ,           TRANS_HIST_SEQ_NO,                      
MFA-TR*            EQUIP_TAG_NO,        APPL_PROGRAM_ID,                        
MFA-TR*            TRANS_DATE,          SOURCE_APPL_CD,                         
MFA-TR*            SOURCE_APPL_REQ_NO,  WMS_POINT_NO,                           
MFA-TR*            INSTALL_LOC_NO,      INSTALL_POINT_NO,                       
MFA-TR*            ACCOUNT_NO,          LAST_UPDATE_USERID,                     
MFA-TR*            TRANS_COMMENTS                                               
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :4J-EQUIP-SEQ,           :4J-TRANS-HIST-SEQ-NO,              
MFA-TR*            :4J-EQUIP-TAG-NO,        :4J-APPL-PROGRAM-ID,                
MFA-TR*            :4J-TRANS-DATE,          :4J-SOURCE-APPL-CD,                 
MFA-TR*            :4J-SOURCE-APPL-REQ-NO,  :4J-WMS-POINT-NO,                   
MFA-TR*            :4J-INSTALL-LOC-NO,      :4J-INSTALL-POINT-NO,               
MFA-TR*            :4J-ACCOUNT-NO,          :4J-LAST-UPDATE-USERID,             
MFA-TR*            :4J-TRANS-COMMENTS                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE         
                                          WS-SQL-CODE                   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** INSERT ERROR IN 8300                **'       
              DISPLAY '** RETURN CODE = ' WS-SQL-CODE                   
              DISPLAY '** EQUIP-SEQ         = ' 4J-EQUIP-SEQ            
              DISPLAY '** TRANS-HIST-SEQ-NO = ' 4J-TRANS-HIST-SEQ-NO    
              DISPLAY '** INSTALL-LOC-NO    = ' 4J-INSTALL-LOC-NO       
              DISPLAY '** INSTALL-POINT-NO  = ' 4J-INSTALL-POINT-NO     
              DISPLAY '** PROCESSING TERMINATED               **'       
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * INSERT RECORD IN THE LMS TRANSACTION HISTORY DETAIL TABLE.  *           
      ***************************************************************           
      *                                                                         
       8400-INS-LMS-TRN-HSTDET.                                         
                                                                        
           EXEC SQL                                                     
               INSERT INTO LMS_TRANS_HIST_DET                           
               (                                                        
                 EQUIP_SEQ,         TRANS_HIST_SEQ_NO,                  
                 DETAIL_SEQ_NO,     COLUMN_DESC,                        
                 PRV_COLUMN_VALUE,  CHG_COLUMN_VALUE,                   
                 LAST_UPDATE_USERID                                     
               )                                                        
               VALUES                                                   
               (                                                        
                 :4S-EQUIP-SEQ,         CIS.CHAR2TIMESTAMP(
                                                  :4S-TRANS-HIST-SEQ-NO
              ),          
                 :4S-DETAIL-SEQ-NO,     :4S-COLUMN-DESC,                
                 :4S-PRV-COLUMN-VALUE,  :4S-CHG-COLUMN-VALUE,           
                 :4S-LAST-UPDATE-USERID                                 
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO LMS_TRANS_HIST_DET                                   
MFA-TR*        (                                                                
MFA-TR*          EQUIP_SEQ,         TRANS_HIST_SEQ_NO,                          
MFA-TR*          DETAIL_SEQ_NO,     COLUMN_DESC,                                
MFA-TR*          PRV_COLUMN_VALUE,  CHG_COLUMN_VALUE,                           
MFA-TR*          LAST_UPDATE_USERID                                             
MFA-TR*        )                                                                
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*          :4S-EQUIP-SEQ,         :4S-TRANS-HIST-SEQ-NO,                  
MFA-TR*          :4S-DETAIL-SEQ-NO,     :4S-COLUMN-DESC,                        
MFA-TR*          :4S-PRV-COLUMN-VALUE,  :4S-CHG-COLUMN-VALUE,                   
MFA-TR*          :4S-LAST-UPDATE-USERID                                         
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO    WS-ACTIVE-RETURN-CODE         
                                          WS-SQL-CODE                   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD +1                           TO 4S-DETAIL-SEQ-NO      
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '** INSERT ERROR IN 8400                **'       
              DISPLAY '** RETURN CODE = ' WS-SQL-CODE                   
              DISPLAY '** EQUIP-SEQ         = ' 4S-EQUIP-SEQ            
              DISPLAY '** TRANS-HIST-SEQ-NO = ' 4S-TRANS-HIST-SEQ-NO    
              DISPLAY '** DETAIL_SEQ_NO     = ' 4S-DETAIL-SEQ-NO        
              DISPLAY '** COLUMN_DESC       = ' 4S-COLUMN-DESC          
              DISPLAY '** PROCESSING TERMINATED               **'       
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **  9000-TERMINATE.                                             **        
      **       TERMINATION ROUTINE                                    **        
      **                                                              **        
      ******************************************************************        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           IF FLM01-SUCCESSFUL                                          
              CLOSE FCSLM001-FILE                                       
              IF FLM01-SUCCESSFUL                                       
                  CONTINUE                                              
              ELSE                                                      
                  DISPLAY '**  PARA 9000-TERMINATE                 **'  
                  DISPLAY '**  CLOSE ERROR OF FCSLM01 - INPUT FILE **'  
                  DISPLAY '**         FILE STATUS = ' WS-FLM01-STATUS   
                  DISPLAY '**         PROCESSING TERMINATED         **' 
                  PERFORM 9900-ABEND                THRU 9900-EXIT      
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF FLE01-SUCCESSFUL                                          
              CLOSE FCSLE001-FILE                                       
              IF FLE01-SUCCESSFUL                                       
                  CONTINUE                                              
              ELSE                                                      
                  DISPLAY '**  PARA 9000-TERMINATE                 **'  
                  DISPLAY '**  CLOSE ERROR OF FCSLE01 - INPUT FILE **'  
                  DISPLAY '**         FILE STATUS = ' WS-FLE01-STATUS   
                  DISPLAY '**         PROCESSING TERMINATED         **' 
                  PERFORM 9900-ABEND                THRU 9900-EXIT      
              END-IF                                                    
           END-IF.                                                      
                                                                        
           DISPLAY '********************************************'.      
           DISPLAY '** READ RECORDS FROM INPUT FILE:' WS-FLM01-REC-CNTR 
           DISPLAY '** INSERTED RECORDS IN TABLE:' WS-INSERT-REC-CNTR.  
           DISPLAY '** WRITTEN RECORDS INTO ERROR:' WS-FLE01-REC-CNTR.  
           DISPLAY '*********************************************'.     
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
