       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSKR405.                                          
       AUTHOR.       REGINA CLARK.                                      
       DATE-WRITTEN. JAN 2012.                                          
      ******************************************************************        
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **        
      **                                                              **        
      *********           CUSTOMER SERVICE SYSTEM              *********        
      *********                     DB2                        *********        
      **                                                              **        
      ******************************************************************        
      **--------------- P R O G R A M  S U M M A R Y -----------------**        
      *************************************************************** **        
      **                                                              **        
      ** THIS IS THE DRIVER PROGRAM FOR THE WRITE OFF LETTER AND      **        
      ** NOTICE PROCESSING FOR WRITE OFF ACCOUNTS.                    **        
      **                                                              **        
      **    THE FOLLOWING PROCESSES HAPPENS IN THE DRIVER:            **        
      **        1. WRITE OFF NOTICE PROCESS                           **        
      **        2. FA03 - CPD00345 WILL CREATE FA03 FILE TO BE        **        
      **           PROCESSED BY PCSCA136                              **        
      **                                                              **        
      ******************************************************************        
      **------------- PROGRAM  MODIFICATION  LOG -------------------- **        
      ******************************************************************        
      **      PCSKR405   PROGRAM  MODIFICATION  LOG                   **        
      **                                                              **        
      **   DATE        INITIALS  REASON                               **        
      **   __________  ________  ______________                       **        
P00599**   08/07/2012  RC41079   INITIAL PROGRAM VERSION.             **        
P0599A**   10/01/2012  RC41079   CHANGE TO NO LONGER CREATE FILE FOR  **        
P0599A**                         NOTICES BUT INSTEAD INSERT INTO TABLE**        
P0599B**   02/06/2013  RC41079   CHANGE TO CORRECT ISSUE WITH NOTICE   *        
P0599B**                         NOT BEING PROCESSED WHEN THERE IS    **        
P0599B**                         MORE THAN TWO RETCHKS.  ALSO POPULATE**        
P0599B**                         WS-TOTAL-RET-CHK-AMT TO PRINT ON     **        
P0599B**                         NOTICE.                              **        
A04527**   06/06/2013  AS7C117   REMOVE UNUSED COPYBOOK CWS00056      **        
      **                                                              **        
ACT289**   11/21/2014  RB19957   CHANGE PROGRAM TO RUN WEEKLY EVERY   **        
ACT289**          APPL00004880   MONDAY AFTER PCSCA206 RUNS ON SUNDAY.**        
      ******************************************************************        
      **----------------- BASIC SEQUENCE STRUCTURE -------------------**        
      *************************************************************** **        
      **         0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION **        
      **         1000 - 1999     INPUT PROCESSING CONTROL PATH        **        
      **         2000 - 2999     OUTPUT PROCESSING CONTROL PATH       **        
      **         3000 - 4999     BATCH PROCESSING MODULES - NOT USED  **        
      **         5000 - 5999     COMMON PROGRAM MODULES               **        
      **         6000 - 6999     COMMON SYSTEM MODULES                **        
      **         7000 - 7999     INPUT MODULES                        **        
      **         8000 - 8999     OUTPUT MODULES                       **        
      **         9000 - 9799     TERMINATION MODULES                  **        
      **         9900 - 9999     ABEND/ABORT MODULES                  **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSKR405'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)                      
           VALUE 'WORKING STORAGE FOR PCSKR405 STARTS HERE'.            
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME              PIC X(08)   VALUE 'PCSKR405'.  
           05  WS-PGRMNAME               PIC X(08)   VALUE 'PCSKR405'.  
           05  SCSCA151                  PIC X(08)   VALUE 'SCSCA151'.  
P0599A     05  SCSKR125                  PIC X(08)   VALUE 'SCSKR125'.  
           05  WS-N                      PIC X(01)   VALUE 'N'.         
           05  WS-Y                      PIC X(01)   VALUE 'Y'.         
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-DISPLAY-SQLCODE        PIC -Z(8)9.                    
P0599A     05  RS-KR125-RETURN-CODE      PIC S9(04)  COMP VALUE 0.      
           05  RS-RETURN-CODE-DISP       PIC S9(04)  COMP VALUE 0.      
           05  RS-RETURN-CODE            PIC S9(04)  COMP VALUE 0.      
           05  WS-PROCESSED-DATE         PIC X(10)   VALUE SPACES.      
           05  WS-LAST-PYMT-DATE-NULL    PIC S9(04)  COMP VALUE 0.      
           05  WS-NULL-IND-1             PIC S9(04)  COMP VALUE +0.     
           05  WS-COMMITS-COUNT          PIC S9(04)  COMP VALUE +0.     
           05  WS-RECS-TO-COMMIT-COUNT   PIC S9(04)  COMP VALUE +0.     
           05  WS-ACCOUNT-NO             PIC S9(13)V COMP-3 VALUE 0.    
           05  WS-WO-BALANCE             PIC S9(09)V99 COMP-3 VALUE 0.  
           05  WS-FW-ACTION-AM           PIC S9(9)V9(2)                 
                                                 USAGE COMP-3 VALUE 0.  
           05  WS-CORR-SEQ-NO-HOLD       PIC S9(4) USAGE COMP VALUE 0.  
           05  WS-CHKP-LUW-LIMIT         PIC 9(04)   VALUE 2.           
           05  WS-CHKP-UPD-LIMIT         PIC 9(04)   VALUE 2.           
           05  WS-DEFAULT-CHKP-LUW-LIMIT PIC 9(04)   VALUE 5.           
           05  WS-DEFAULT-CHKP-UPD-LIMIT PIC 9(04)   VALUE 5.           
           05  WS-READY-TO-COMMIT-COUNT  PIC S9(09) COMP VALUE +0.      
           05  WS-DEFAULT-INSERT-COUNT   PIC S9(09)  COMP VALUE +100.   
           05  WS-PREV-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.    
           05  WS-PREV-ACTION-TYPE-CD    PIC X(05)   VALUE SPACES.      
P0599A     05  WS-SLASHES-6              PIC X(06)   VALUE '//////'.    
P0599A     05  WS-HOLD-AMOUNT            PIC 9(09)V99 VALUE 0.          
P0599A     05  WS-HOLD-AMOUNT-K  REDEFINES WS-HOLD-AMOUNT.              
P0599A         10  WS-DOL-AMOUNT         PIC 9(09).                     
P0599A         10  WS-DEC-AMOUNT         PIC 9(02).                     
      *                                                                         
       01  WS-SWITCHES.                                                 
           05 WS-DATABASE                PIC 9(01)   VALUE ZERO.        
               88  CSR-DATABASE                      VALUE 1.           
               88  SEB-DATABASE                      VALUE 2.           
           05  WS-GUARANTOR-EXISTS       PIC X(01)   VALUE SPACES.      
               88  GUARANTOR-EXISTS                  VALUE 'Y'.         
           05  WS-PROCESSED-FL           PIC X(01)   VALUE SPACES.      
               88  PROCESSED-FL                      VALUE 'Y'.         
           05  WS-PROCESS-ACCOUNT        PIC X(01)   VALUE 'N'.         
               88  PROCESS-ACCT                      VALUE 'Y'.         
               88  SKIP-ACCT                         VALUE 'N'.         
      *                                                                         
      ******************************************************************        
      * CWS00010 CONTAINS DB2 ABEND VARIABLES                          *        
      ******************************************************************        
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
      ******************************************************************        
      * WS-ABEND-SWITCH                                                *        
      ******************************************************************        
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
      ******************************************************************        
      * CWS00039 JOB PARM ROUTINE                                      *        
      ******************************************************************        
      *                                                                         
       COPY CWS00039.                                                           
      *                                                                         
      ******************************************************************        
      * FIOJC01 WORKING STORAGE                                        *        
      ******************************************************************        
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      ******************************************************************        
      * FCA00-KEY                                                      *        
      ******************************************************************        
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
      ******************************************************************        
      *  CWS00038 INPUT DATA LAYOUT                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      *                                                                         
       01  WS-INSERT-ROW-COUNT REDEFINES WS-INPUT-DATA-BREAKDOWN.       
           10  WS-PARM-COMMIT-ROW-COUNT-TXT PIC X(09).                  
               88 COMMIT-ROW-CNT         VALUE 'COMMIT = '.             
           10  WS-NO-OF-ROWS-TO-COMMIT   PIC X(05).                     
           10  FILLER                    PIC X(66).                     
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR CODES-DATA-PRESENT                         *        
      ******************************************************************        
      *                                                                         
P0599A******************************************************************        
P0599A* VARIABLES NEEDED FOR MNT HIST COMMENTS.                        *        
P0599A******************************************************************        
P0599A*                                                                         
P0599A COPY CWS00136.                                                           
P0599A*                                                                         
      ******************************************************************        
      * VARIABLES NEEDED FOR ACCOUNT SKIP PROCESSING.                  *        
      ******************************************************************        
      *                                                                         
       COPY CWSCA151.                                                           
      *                                                                         
      ******************************************************************        
      * CWS00303 JOB PARM ROUTINE CONTAINS WS-WARNING-DATA-ELEMENTS    *        
      ******************************************************************        
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR CPD00337 CONTAINS LIMIT CHECK WS VARIABLES *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00337                                                  
           END-EXEC.                                                            
      *                                                                         
P0599A******************************************************************        
P0599A* WORKING STORAGE VARIABLES TO PROCESS AND INSERT NOTICES        *        
P0599A******************************************************************        
P0599A*                                                                         
P0599A     EXEC SQL                                                             
P0599A        INCLUDE CWS00341                                                  
P0599A     END-EXEC.                                                            
P0599A*                                                                         
P0599A******************************************************************        
P0599A* WORKING STORAGE VARIABLES TO PROCESS AND INSERT NOTICES        *        
P0599A******************************************************************        
P0599A*                                                                         
P0599A     EXEC SQL                                                             
P0599A        INCLUDE CWS00350                                                  
P0599A     END-EXEC.                                                            
P0599A*                                                                         
      ******************************************************************        
      *   CWS10008 KR100 PROCESSING DATA.                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS10008                                                  
           END-EXEC.                                                            
      *                                                                         
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSKR405 ENDS HERE  '.            
                                                                        
      ******************************************************************        
      * DB2 COMMUNICATION REQUIREMENT                                  *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ACCOUNT        - AT                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_BUSINESS_DAYS  - 1G                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBUSDAY                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CUSTOMER       - CU                                                 
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CHRG_OFF       - CO                                                 
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCHGOFF                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CREDIT_PROFILE - CZ                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCRPROF                                                 
           END-EXEC.                                                            
      *                                                                         
P0599A******************************************************************        
P0599A* CSS_DELINQUENCY    - C8                                        *        
P0599A******************************************************************        
P0599A*                                                                         
P0599A     EXEC SQL                                                             
P0599A         INCLUDE TBDELQ                                                   
P0599A     END-EXEC.                                                            
P0599A*                                                                         
      ******************************************************************        
      * CSS_DFA_ACCT       - DA                                                 
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDFAACT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_GUARANTOR      - GU                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGTNTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_FIN_WO_ACTION  - KD                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBFWACTN                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_FINAL_WO       - FW                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBFINLWO                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_FW_FCST_ACTION - F8                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBFWPDTL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_JOB_PARM       - G6                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_NSF_HIST       - NH                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNSFHST                                                 
           END-EXEC.                                                            
      *                                                                         
P0599B******************************************************************        
P0599B* CSS_NSF-REASON     - NR                                        *        
P0599B******************************************************************        
P0599B*                                                                         
P0599B     EXEC SQL                                                             
P0599B         INCLUDE TBNSFRSN                                                 
P0599B     END-EXEC.                                                            
P0599B*                                                                         
      ******************************************************************        
      * CSS_THD_PRTY       - ZW                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBTHDPTY                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CURSOR DECLARATION                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE FINAL-NOTICE-CSR CURSOR WITH HOLD FOR             
               SELECT AT.COMPANY_NO                                     
                     ,AT.ACCOUNT_NO                                     
                     ,AT.CUSTOMER_NO                                    
                     ,AT.TOTAL_AR_BALANCE                               
                     ,AT.BANKRUPTCY_IND                                 
                     ,AT.JUDGEMENT_CASE_NO                              
                     ,AT.LAST_PYMT_DATE                                 
                     ,AT.LAST_PYMT_AMOUNT                               
                     ,AT.PREMISE_NO                                     
                     ,AT.LOCAL_OFFICE                                   
                     ,AT.ADDRESS_ID                                     
                     ,AT.ADDRESS_FORMAT                                 
                     ,AT.BILL_CYCLE                                     
                     ,AT.CODE_ACCT_STAT                                 
                     ,AT.CREDIT_GROUP                                   
                     ,FW.REG_GROUP_CD                                   
                     ,FW.SENIOR_FL                                      
                     ,FW.FW_PATH_TYPE_CD                                
                     ,KD.FW_SEQ_NO                                      
                     ,KD.FW_ACTION_TYPE_CD                              
                     ,KD.FW_ACTION_DT                                   
                     ,KD.FW_ACTION_AM                                   
                     ,KD.FW_PROCESSED_FL                                
                     ,KD.FW_ACTION_COMMENTS                             
                 FROM CSS_ACCOUNT       AT WITH(READUNCOMMITTED)                
                     ,CSS_FIN_WO_ACTION KD WITH(READUNCOMMITTED)                
                     ,CSS_FINAL_WO      FW WITH(READUNCOMMITTED)                
                WHERE AT.ACCOUNT_NO        = FW.ACCOUNT_NO              
                  AND FW.ACCOUNT_NO        = KD.ACCOUNT_NO              
ACT289            AND KD.FW_ACTION_DT     <  IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )             
                  AND AT.CODE_ACCT_STAT    = 'S'                        
                  AND KD.FW_BUS_PROCESS_CD = 'WL'                       
                  AND KD.FW_PROCESSED_FL   = ''                         
                ORDER BY AT.COMPANY_NO                                  
                        ,AT.ACCOUNT_NO                                  
                        ,KD.FW_SEQ_NO                                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE FINAL-NOTICE-CSR CURSOR WITH HOLD FOR                     
MFA-TR*        SELECT AT.COMPANY_NO                                             
MFA-TR*              ,AT.ACCOUNT_NO                                             
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.TOTAL_AR_BALANCE                                       
MFA-TR*              ,AT.BANKRUPTCY_IND                                         
MFA-TR*              ,AT.JUDGEMENT_CASE_NO                                      
MFA-TR*              ,AT.LAST_PYMT_DATE                                         
MFA-TR*              ,AT.LAST_PYMT_AMOUNT                                       
MFA-TR*              ,AT.PREMISE_NO                                             
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,AT.ADDRESS_ID                                             
MFA-TR*              ,AT.ADDRESS_FORMAT                                         
MFA-TR*              ,AT.BILL_CYCLE                                             
MFA-TR*              ,AT.CODE_ACCT_STAT                                         
MFA-TR*              ,AT.CREDIT_GROUP                                           
MFA-TR*              ,FW.REG_GROUP_CD                                           
MFA-TR*              ,FW.SENIOR_FL                                              
MFA-TR*              ,FW.FW_PATH_TYPE_CD                                        
MFA-TR*              ,KD.FW_SEQ_NO                                              
MFA-TR*              ,KD.FW_ACTION_TYPE_CD                                      
MFA-TR*              ,KD.FW_ACTION_DT                                           
MFA-TR*              ,KD.FW_ACTION_AM                                           
MFA-TR*              ,KD.FW_PROCESSED_FL                                        
MFA-TR*              ,KD.FW_ACTION_COMMENTS                                     
MFA-TR*          FROM CSS_ACCOUNT       AT                                      
MFA-TR*              ,CSS_FIN_WO_ACTION KD                                      
MFA-TR*              ,CSS_FINAL_WO      FW                                      
MFA-TR*         WHERE AT.ACCOUNT_NO        = FW.ACCOUNT_NO                      
MFA-TR*           AND FW.ACCOUNT_NO        = KD.ACCOUNT_NO                      
MFA-TR*           AND KD.FW_ACTION_DT     <  :WS-INPUT-DATE                     
MFA-TR*           AND AT.CODE_ACCT_STAT    = 'S'                                
MFA-TR*           AND KD.FW_BUS_PROCESS_CD = 'WL'                               
MFA-TR*           AND KD.FW_PROCESSED_FL   = ''                                 
MFA-TR*         ORDER BY AT.COMPANY_NO                                          
MFA-TR*                 ,AT.ACCOUNT_NO                                          
MFA-TR*                 ,KD.FW_SEQ_NO                                           
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7510                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS MAIN PROCESSING OF PROGRAM                            *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION                   THRU 0100-EXIT.
           PERFORM 1000-PROCESS-INPUT                    THRU 1000-EXIT.
           PERFORM 9000-TERMINATE                        THRU 9000-EXIT.
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZATION.                                           *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE              THRU 6251-EXIT.     
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE   THRU 6240-EXIT      
               MOVE WS-FCA00-COMMON-DATE    TO WS-INPUT-DATE            
               DISPLAY '********************************************'   
               DISPLAY '* COMMON DATE BEING USED                   *'   
               DISPLAY '* DATE = ' WS-INPUT-DATE                        
               DISPLAY '* PROCESSING CONTINUING                    *'   
               DISPLAY '********************************************'   
           END-IF.                                                      
      *                                                                         
                                                                        
           MOVE WS-INPUT-DATE             TO WS-CWS337-PROCESS-DATE     
ACT289                                       WS-PROCESSED-DATE.         
                                                                        
      * GET DB2 INSERT ROW COUNT                                                
           PERFORM 0115-GET-COMMIT-ROW-COUNT    THRU 0115-EXIT.         
                                                                        
P0599A* GET DATABASE                                                            
P0599A     PERFORM 0145-GET-DATABASE            THRU 0145-EXIT.         
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0115-GET-COMMIT-ROW-COUNT.                                     *        
      * GET THE INSERT ROW COUNT FROM JOB PARM TABLE                   *        
      ******************************************************************        
      *                                                                         
       0115-GET-COMMIT-ROW-COUNT.                                       
      *                                                                         
           MOVE  WS-PGRMNAME               TO WS-PROGRAM.               
           MOVE  WS-PARM                   TO WS-COMMAND.               
           MOVE  ZEROS                     TO WS-SEQUENCE.              
           MOVE  SPACES                    TO WS-SYSIPT.                
           MOVE  WS-KEY-AREA               TO E-FJC01-KEY.              
      *                                                                         
           PERFORM 7600-START-FCSJC01      THRU  7600-EXIT.             
           PERFORM 7610-READ-FCSJC01       THRU  7610-EXIT              
              UNTIL (COMMIT-ROW-CNT AND INPUT-ACTIVE)                   
              OR  END-OF-SYSIPT.                                        
      *                                                                         
           IF END-OF-SYSIPT                                             
              DISPLAY '********************************************'    
              DISPLAY '** ' WS-PGRMNAME ' PROCESSING WARNING  **'       
              DISPLAY '**  COMMIT-ROW-CNT PARM NOT ACTIVE     **'       
              DISPLAY '**  DEFAULT OF ' WS-DEFAULT-INSERT-COUNT         
                          ' WILL BE USED  **'                           
              DISPLAY '**  PROCESSING CONTINUING        **'             
              DISPLAY '********************************************'    
              MOVE WS-DEFAULT-INSERT-COUNT                              
                                         TO WS-READY-TO-COMMIT-COUNT    
           ELSE                                                         
              IF WS-NO-OF-ROWS-TO-COMMIT NUMERIC                        
                 MOVE WS-NO-OF-ROWS-TO-COMMIT                           
                                         TO WS-READY-TO-COMMIT-COUNT    
              ELSE                                                      
                 DISPLAY '********************************************' 
                 DISPLAY '**  ' WS-PGRMNAME ' PROCESSING WARNING  **'   
                 DISPLAY '**  COMMIT-ROW-CNT PARM NOT NUMERIC  **'      
                 DISPLAY '**  DEFAULT OF ' WS-DEFAULT-INSERT-COUNT      
                         ' WILL BE USED  **'                            
                 DISPLAY '**  PROCESSING CONTINUING        **'          
                 DISPLAY '********************************************' 
                 MOVE WS-DEFAULT-INSERT-COUNT                           
                                         TO WS-READY-TO-COMMIT-COUNT    
              END-IF                                                    
              PERFORM 7611-CLOSE                 THRU 7611-EXIT         
           END-IF.                                                      
      *                                                                         
       0115-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P0599A******************************************************************        
P0599A* 0145-GET-DATABASE.                                             *        
P0599A******************************************************************        
P0599A*                                                                         
P0599A 0145-GET-DATABASE.                                               
P0599A*                                                                         
P0599A     MOVE 'DATABASE'                TO C8-DELINQ-CD.              
P0599A     MOVE '01'                      TO C8-COMPANY-NO.             
P0599A     PERFORM 7010-SELECT-DELINQ-VALUE              THRU 7010-EXIT.
P0599A     MOVE C8-DELINQ-VALUE           TO WS-DATABASE.               
P0599A*                                                                         
P0599A 0145-EXIT.                                                       
P0599A     EXIT.                                                        
P0599A*                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 7500-OPEN-FINAL-NOTICE-CSR     THRU 7500-EXIT.       
           PERFORM 7510-FETCH-FINAL-NOTICE-CSR    THRU 7510-EXIT.       
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE AT-ACCOUNT-NO         TO WS-ACCOUNT-NO               
              PERFORM 5200-CHK-SKIP-ACCTS         THRU 5200-CPD347-EXIT 
              IF PROCESS-ACCT                                           
                 PERFORM 1100-PROCESS-ACCOUNT     THRU 1100-EXIT        
              END-IF                                                    
              PERFORM 7510-FETCH-FINAL-NOTICE-CSR THRU 7510-EXIT        
           END-PERFORM.                                                 
           PERFORM 7520-CLOSE-FINAL-NOTICE-CSR    THRU 7520-EXIT.       
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1100-PROCESS-ACCOUNT                                           *        
      ******************************************************************        
      *                                                                         
       1100-PROCESS-ACCOUNT.                                            
      *                                                                         
           PERFORM 2000-PROCESS-OUTPUT          THRU 2000-EXIT.         
      *                                                                         
           IF WS-RECS-TO-COMMIT-COUNT = WS-READY-TO-COMMIT-COUNT        
              PERFORM 8888-COMMIT               THRU 8888-EXIT          
           END-IF.                                                      
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P0599A******************************************************************        
P0599A* 1427-CALL-NOTICE-SUB                                           *        
P0599A* THIS MODULE CALLS SCSKR125 THAT LOADS THE DATA TO THE CORRESP  *        
P0599A* NOTICE DB2 TABLES.                                             *        
P0599A******************************************************************        
P0599A*                                                                         
P0599A 1427-CALL-NOTICE-SUB.                                            
P0599A*                                                                         
P0599A     DISPLAY 'CALLING SCSKR125'.                                  
P0599A     CALL SCSKR125 USING WS-CORRESP-HDR                           
P0599A                         WS-CORRESP-NOTICE                        
P0599A                         WS-CORRESP-VAR                           
P0599A                         WS-MISC-PROCESSING-VARS                  
P0599A                         WS-KR125-COMM-DATA-VARS                  
P0599A                         WS-KR125-MNT-TRANS-VARS                  
P0599A                         ABEND-FILE                               
P0599A                         WS-CWS350-MISC                           
P0599A                         WS-CORRESP-COMM-VAR                      
P0599A                         RS-KR125-RETURN-CODE.                    
P0599A*                                                                         
P0599A     IF  ABEND-FUNCTION  > SPACES                                 
P0599A         MOVE ABEND-SQLCODE           TO RS-RETURN-CODE           
P0599A                                         WS-ACTIVE-RETURN-CODE    
P0599A         PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
P0599A     END-IF.                                                      
P0599A*                                                                         
P0599A 1427-EXIT.                                                       
P0599A     EXIT.                                                        
P0599A*                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
      * INITIALIZE WS VARIABLES                                                 
P0599A     INITIALIZE WS-FW-ACTION-AM                                   
P0599A                WS-WO-BALANCE                                     
P0599A                WS-CORRESP-HDR                                    
P0599A                WS-CORRESP-NOTICE                                 
P0599A                WS-CORRESP-VAR                                    
P0599A                WS-MISC-PROCESSING-VARS                           
P0599A                WS-KR125-COMM-DATA-VARS                           
P0599A                WS-KR125-MNT-TRANS-VARS.                          
      *                                                                         
           MOVE SPACES                       TO WS-PROCESSED-FL.        
           MOVE AT-ACCOUNT-NO                TO FW-ACCOUNT-NO           
                                                KD-ACCOUNT-NO           
                                                CZ-ACCOUNT-NO           
                                                WS-ACCOUNT-NO.          
           MOVE AT-TOTAL-AR-BALANCE          TO WS-TOTAL-AR-BALANCE-SM. 
      *                                                                         
           PERFORM 7090-SELECT-CREDIT-PROFILE   THRU 7090-EXIT.         
           MOVE CZ-CASH-ONLY-FL              TO WS-NOTICE-CASH-ONLY-FL. 
      *                                                                         
      * PROCESS BANKRUPT/JUDGEMENT/TOTAL-AR-BALANCE ACCOUNTS                    
           PERFORM 2010-UPDATE-PROCESSED-FLAG   THRU 2010-EXIT.         
      *                                                                         
      * LIMIT CHECK PROCESS                                                     
           PERFORM 2020-LIMIT-CHECK-PROCESS     THRU 2020-EXIT.         
      *                                                                         
           MOVE AT-ACCOUNT-NO                TO CO-ACCOUNT-NO.          
           PERFORM 7100-GET-WO-BALANCE          THRU 7100-EXIT.         
      *                                                                         
           IF WS-WO-BALANCE >= WS-FW-ACTION-LIMIT-AM                    
              MOVE WS-WO-BALANCE             TO WS-FW-ACTION-AM         
              EVALUATE TRUE                                             
                 WHEN WS-FW-SPEC-PROCESS-CD > SPACES                    
                     IF WS-FW-SPEC-PROCESS-CD   = 'RETCK'               
                       PERFORM 5040-RETURNED-CHECK THRU 5040-EXIT       
                     END-IF                                             
                 WHEN WS-FW-SPEC-PROCESS-CD = SPACES                    
                     PERFORM 5300-PROCESS-NOTICE   THRU 5300-EXIT       
              END-EVALUATE                                              
           ELSE                                                         
              MOVE 'Y'                       TO WS-PROCESSED-FL         
              MOVE ZEROS                     TO WS-FW-ACTION-AM         
              PERFORM 8510-UPDATE-PROCESS-FL-ACTN-AM THRU 8510-EXIT     
           END-IF.                                                      
           MOVE FW-ACCOUNT-NO      TO WS-PREV-ACCOUNT-NO.               
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2010-UPDATE-PROCESSED-FLAG                                     *        
      ******************************************************************        
      *                                                                         
       2010-UPDATE-PROCESSED-FLAG.                                      
      *                                                                         
           IF AT-BANKRUPTCY-IND    > SPACES                             
              SET PROCESSED-FL                  TO TRUE                 
              PERFORM 8500-UPDATE-PROCESSED-FL  THRU 8500-EXIT          
              GO TO 2000-EXIT                                           
           END-IF.                                                      
      *                                                                         
           IF AT-JUDGEMENT-CASE-NO > SPACES                             
              SET PROCESSED-FL                  TO TRUE                 
              PERFORM 8500-UPDATE-PROCESSED-FL  THRU 8500-EXIT          
              GO TO 2000-EXIT                                           
           END-IF.                                                      
      *                                                                         
           IF WS-PROCESSED-FL = 'Y'                                     
              GO TO 2000-EXIT                                           
           END-IF.                                                      
      *                                                                         
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2020-LIMIT-CHECK-PROCESS                                       *        
      ******************************************************************        
      *                                                                         
       2020-LIMIT-CHECK-PROCESS.                                        
      *                                                                         
           MOVE 'WL'                            TO F8-FW-BUS-PROCESS-CD.
           MOVE AT-COMPANY-NO                   TO WS-FW-COMPANY.       
           MOVE FW-REG-GROUP-CD                 TO WS-REG-GROUP-CD.     
           MOVE FW-FW-PATH-TYPE-CD              TO WS-FW-PATH-TYPE-CD.  
           MOVE KD-FW-ACTION-TYPE-CD            TO WS-FW-ACTION-TYPE-CD 
                                                 WS-PREV-ACTION-TYPE-CD.
           PERFORM 5100-GET-FCST-ACTN-DATA      THRU 5100-CPD337-EXIT.  
      *                                                                         
           IF F8-MATCH-FOUND                                            
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '**************PCSKR405*************************'
               DISPLAY '* NO MATCH FOUND ON CSS_FW_FCST_ACTION TABLE.  '
               DISPLAY '* RETURN CODE = 12'                             
               DISPLAY '**************PCSKR405*************************'
               PERFORM 9900-ABEND   THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       2020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P0599A******************************************************************        
P0599A* 2300-LOAD-KR125-MNT-TRANS                                               
P0599A**************************************************************            
P0599A                                                                  
P0599A 2300-LOAD-KR125-MNT-TRANS.                                       
P0599A                                                                  
P0599A* provide the comment for panel 156 - notice transaction                  
P0599A* history.                                                                
P0599A                                                                  
P0599A     INITIALIZE  WS-CWS00136-NOTICE-TYPE                          
P0599A                 WS-CWS00136-DATE-MAIL                            
P0599A                 WS-CWS00136-DATE-NOTICE-DUE                      
P0599A                 WS-CWS00136-AMT-NOTICE-DOL                       
P0599A                 WS-CWS00136-AMT-NOTICE-DEC                       
P0599A                 WS-CWS00136-MESSAGE-NUMBER                       
P0599A                 WS-CWS00136-FRCST-AUTO-DEP-DL                    
P0599A                 WS-CWS00136-FRCST-AUTO-DEP-DC                    
P0599A                 WS-HOLD-AMOUNT.                                  
P0599A                                                                  
P0599A     EVALUATE KD-FW-ACTION-TYPE-CD                                
P0599A         WHEN 90205                                               
P0599A            MOVE 'RETURNED CHECK NOTICE 1'                        
P0599A                                   TO WS-CWS00136-NOTICE-TYPE     
P0599A         WHEN 90503                                               
P0599A            MOVE '1ST WRITE OFF LTR'                              
P0599A                                   TO WS-CWS00136-NOTICE-TYPE     
P0599A         WHEN 90504                                               
P0599A            MOVE '2ND WRITE OFF LTR'                              
P0599A                                   TO WS-CWS00136-NOTICE-TYPE     
P0599A     END-EVALUATE.                                                
P0599A                                                                  
P0599A     MOVE KD-FW-ACTION-TYPE-CD     TO WS-CWS00136-MESSAGE-NUMBER. 
P0599A     MOVE SPACES                   TO WS-CWS00136-DATE-MAIL.      
P0599A     MOVE WS-SLASHES-6             TO WS-CWS00136-DATE-MAIL.      
P0599A     MOVE WS-PROCESSED-DATE(6:2)   TO WS-CWS00136-DATE-MAIL(1:2). 
P0599A     MOVE WS-PROCESSED-DATE(9:2)   TO WS-CWS00136-DATE-MAIL(4:2). 
P0599A     MOVE WS-PROCESSED-DATE(1:4)   TO WS-CWS00136-DATE-MAIL(7:4). 
P0599A                                                                  
P0599A     MOVE 'NONE'                   TO WS-CWS00136-DATE-NOTICE-DUE.
P0599A                                                                  
P0599A     MOVE WS-FW-ACTION-AM          TO WS-HOLD-AMOUNT.             
P0599A     MOVE WS-DOL-AMOUNT            TO WS-CWS00136-AMT-NOTICE-DOL. 
P0599A     MOVE WS-DEC-AMOUNT            TO WS-CWS00136-AMT-NOTICE-DEC. 
P0599A                                                                  
P0599A     MOVE WS-CWS00136-FORMATTED-COMMENT                           
P0599A                                   TO WS-KR125-TRAN-CMT-TEXT.     
P0599A     MOVE +107                     TO WS-KR125-TRAN-CMT-LEN.      
P0599A                                                                  
P0599A 2300-EXIT.                                                       
P0599A     EXIT.                                                        
P0599A                                                                  
      ******************************************************************        
      * 5040-RETURNED-CHECK                                            *        
      ******************************************************************        
      *                                                                         
       5040-RETURNED-CHECK.                                             
      *                                                                         
           IF KD-FW-ACTION-COMMENTS-TEXT > SPACES                       
              MOVE KD-FW-ACTION-COMMENTS-TEXT(1:26)                     
                                           TO NH-NSF-TIMESTMP           
              MOVE AT-ACCOUNT-NO           TO NH-ACCOUNT-NO             
              PERFORM 7070-GET-NSF-DETAILS THRU 7070-EXIT               
              IF WS-ACTIVE-RETURN-CODE = 0                              
                 MOVE NH-RETURN-CHECK-AMT  TO WS-RET-CHK-AMT            
                 MOVE NH-NSF-CHARGE-AMT    TO WS-NSF-CHARGE-AMT         
P0599B           COMPUTE WS-TOTAL-RET-CHK-AMT = NH-RETURN-CHECK-AMT +   
P0599B                                          NH-NSF-CHARGE-AMT       
P0599B           MOVE WS-WO-BALANCE        TO WS-RET-CHK-PAST-DUE-AMT   
                 MOVE NH-NSF-REASON-CD     TO WS-NSF-REASON-CD          
                 MOVE NH-DRAWN-BY-NM-TEXT  TO WS-DRAWN-BY-NM            
              ELSE                                                      
                 MOVE SPACES               TO WS-NSF-REASON-CD          
                                              WS-DRAWN-BY-NM            
                 MOVE ZEROS                TO WS-RET-CHK-AMT            
                                              WS-NSF-CHARGE-AMT         
              END-IF                                                    
P0599B        MOVE WS-NSF-REASON-CD         TO NR-NSF-REASON-CD         
P0599B        PERFORM 7060-SELECT-NSF-REASON   THRU 7060-EXIT           
P0599B        IF SQLCODE = 0                                            
P0599B           MOVE NR-NSF-REASON-DESC    TO WS-NSF-REASON-DESC       
P0599B        ELSE                                                      
P0599B           MOVE 'OTHER'               TO WS-NSF-REASON-DESC       
P0599B        END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 5300-PROCESS-NOTICE     THRU 5300-EXIT.              
      *                                                                         
       5040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5100-GET-FCST-ACTN-DATA                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00337                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 5200-CHK-SKIP-ACCTS                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00347                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 5300-PROCESS-NOTICE                                            *        
      * THIS MODULE WRITES THE ACCOUNT INFORMATION FOR THE NOTICE TO   *        
      * THE TABLE.                                                     *        
      ******************************************************************        
      *                                                                         
       5300-PROCESS-NOTICE.                                             
      *                                                                         
           MOVE WS-WO-BALANCE          TO WS-FW-ACTION-AM.              
           MOVE 'Y'                    TO WS-PROCESSED-FL.              
           PERFORM 8510-UPDATE-PROCESS-FL-ACTN-AM THRU 8510-EXIT.       
      *                                                                         
P0599A     MOVE WS-INPUT-DATE          TO WS-COMMON-DATE                
P0599A                                    WS-KR125-MNT-DATE-TRANS.      
P0599A     MOVE PROGRAM-NAME           TO WS-CORRESP-LAST-UPDATE-PGM-ID 
P0599A                                    WS-CORRESP-CREATED-BY-PGM-ID  
P0599A                                    WS-CALLING-PGM-NAME.          
P0599A     MOVE AT-ACCOUNT-NO          TO WS-NOTICE-ACCOUNT-NO          
P0599A                                    WS-KR125-COMM-ACCT-NO         
P0599A                                    WS-KR125-MNT-ACCOUNT-NO.      
P0599A     MOVE AT-CUSTOMER-NO         TO WS-NOTICE-CUSTOMER-NO         
P0599A                                    WS-KR125-MNT-CUSTOMER-NO      
P0599A                                    WS-KR125-CUSTOMER-NO.         
P0599A     MOVE KD-FW-ACTION-TYPE-CD   TO WS-CORRESP-MSG-ID.            
P0599A     MOVE 1                      TO WS-NOTICE-CORRESP-ID.         
P0599A     MOVE 0                      TO WS-NOTICE-GUARANTOR-ACCT-NO.  
P0599A     MOVE AT-COMPANY-NO          TO WS-CORRESP-COMPANY-NO         
P0599A                                    WS-PROCESS-COMPANY-NO.        
P0599A     MOVE FW-REG-GROUP-CD        TO WS-NOTICE-REG-GROUP-CD.       
P0599A     MOVE FW-SENIOR-FL           TO WS-NOTICE-SENIOR-FL.          
P0599A     MOVE WS-INPUT-DATE          TO WS-CORRESP-STMT-DT.           
P0599A     MOVE 0                      TO WS-NOTICE-AUTO-DEP-FCST-AM.   
P0599A     MOVE 0                      TO WS-NOTICE-UTIL-PAST-DUE-AM.   
P0599A     MOVE 0                      TO WS-NOTICE-NONUTL-PAST-DUE-AM. 
P0599A     MOVE SPACES                 TO WS-NOTICE-DUE-DT.             
P0599B     IF KD-FW-ACTION-TYPE-CD = '90205'                            
P0599B       MOVE WS-WO-BALANCE        TO WS-NOTICE-DUE-AM              
P0599B     ELSE                                                         
P0599A       MOVE WS-FW-ACTION-AM      TO WS-NOTICE-DUE-AM              
P0599B     END-IF.                                                      
P0599A     MOVE AT-LAST-PYMT-DATE      TO WS-NOTICE-LAST-PAYMENT-DT.    
P0599A     MOVE AT-LAST-PYMT-AMOUNT    TO WS-NOTICE-LAST-PAYMENT-AM.    
P0599A*                                                                         
P0599A     IF FW-ACCOUNT-NO = WS-PREV-ACCOUNT-NO                        
P0599B       ADD 1                     TO WS-CORR-SEQ-NO-HOLD           
P0599A     ELSE                                                         
P0599B       MOVE 0                    TO WS-CORR-SEQ-NO-HOLD           
P0599A     END-IF.                                                      
P0599A*                                                                         
P0599B     MOVE WS-CORR-SEQ-NO-HOLD    TO WS-CORRESP-SEQ-NO.            
P0599A     MOVE AT-LOCAL-OFFICE        TO WS-CWS350-LOCAL-OFFICE.       
P0599A     MOVE WS-DATABASE            TO WS-CWS350-DATABASE.           
P0599A     MOVE 'H'                    TO WS-KR125-CODE-TRAN-TYP.       
P0599A     MOVE SPACES                 TO WS-KR125-RESP-AREA-ID.        
P0599A     MOVE AT-PREMISE-NO          TO WS-KR125-PREMISE-NO           
P0599A                                    WS-KR125-MNT-PREMISE-NO.      
P0599A     MOVE 'A'                    TO WS-KR125-COMM-ASSOC-CD.       
P0599A     MOVE SPACES                 TO WS-KR125-PSC-COMPL-ID.        
P0599A     MOVE SPACES                 TO WS-KR125-CONTACT-NAME.        
P0599A     MOVE SPACES                 TO WS-KR125-RED-FL-EXP-DT.       
P0599A     MOVE SPACES                 TO WS-KR125-CALL-END-TIME.       
P0599A     MOVE 0                      TO WS-KR125-COMDAT-CMT-LEN.      
P0599A     MOVE SPACES                 TO WS-KR125-COMDAT-CMT-TEXT.     
P0599A*                                                                         
P0599A     IF FW-ACCOUNT-NO NOT EQUAL WS-PREV-ACCOUNT-NO                
P0599A       ADD 1 TO WS-COMMITS-COUNT                                  
P0599A                WS-RECS-TO-COMMIT-COUNT                           
P0599A     END-IF.                                                      
P0599A*                                                                         
P0599A     PERFORM 2300-LOAD-KR125-MNT-TRANS   THRU 2300-EXIT.          
P0599A*                                                                         
P0599A     PERFORM 1427-CALL-NOTICE-SUB        THRU 1427-EXIT.          
      *                                                                         
       5300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6240-GET-FCA00-COMMON-DATE                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00040                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00037                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6253-GET-FJC01-CHKP-LIMIT.                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00034                                                  
           END-EXEC.                                                            
      *                                                                         
P0599A******************************************************************        
P0599A* 7010-SELECT-DELINQ-VALUE                                       *        
P0599A******************************************************************        
P0599A*                                                                         
P0599A 7010-SELECT-DELINQ-VALUE.                                        
P0599A*                                                                         
P0599A     EXEC SQL                                                     
P0599A        SELECT DELINQ_VALUE                                       
P0599A          INTO :C8-DELINQ-VALUE                                   
P0599A          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
P0599A         WHERE DELINQ_CD    = :C8-DELINQ-CD                       
P0599A           AND COMPANY_NO   = :C8-COMPANY-NO                      
P0599A                                                           
P0599A                                                      
P0599A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD    = :C8-DELINQ-CD                               
MFA-TR*          AND COMPANY_NO   = :C8-COMPANY-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0599A                                                                  
P0599A     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
P0599A                                       WS-DISPLAY-SQLCODE.        
P0599A*                                                                         
P0599A     IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
P0599A        CONTINUE                                                  
P0599A     ELSE                                                         
P0599A         DISPLAY '********** PCSKR405  ABORT ********************'
P0599A         DISPLAY '* 7010-SELECT-DELINQ-VALUE                    *'
P0599A         DISPLAY '* SQLCODE IS   ' WS-DISPLAY-SQLCODE             
P0599A         DISPLAY '* DELINQ_CD  : ' C8-DELINQ-CD                   
P0599A         DISPLAY '* COMPANY_NO : ' C8-COMPANY-NO                  
P0599A         DISPLAY '* PROGRAM ABORTING...                         *'
P0599A         DISPLAY '********** PCSKR405  ABORT ********************'
P0599A         PERFORM 9900-ABEND                   THRU 9900-EXIT      
P0599A     END-IF.                                                      
P0599A*                                                                         
P0599A 7010-EXIT.                                                       
P0599A     EXIT.                                                        
P0599A*                                                                         
P0599B******************************************************************08494000
P0599B* 7060-SELECT-NSF-REASON                                         *        
P0599B******************************************************************08494000
P0599B                                                                  
P0599B 7060-SELECT-NSF-REASON.                                          
P0599B                                                                  
P0599B     EXEC SQL                                                     
P0599B        SELECT NSF_REASON_DESC                                    
P0599B          INTO :NR-NSF-REASON-DESC                                
P0599B          FROM CSS_NSF_REASON WITH(READUNCOMMITTED)                       
P0599B         WHERE COMPANY_NO    = '01'                               
P0599B           AND NSF_REASON_CD = :NR-NSF-REASON-CD                  
P0599B                                                           
P0599B                                                      
P0599B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NSF_REASON_DESC                                            
MFA-TR*         INTO :NR-NSF-REASON-DESC                                        
MFA-TR*         FROM CSS_NSF_REASON                                             
MFA-TR*        WHERE COMPANY_NO    = '01'                                       
MFA-TR*          AND NSF_REASON_CD = :NR-NSF-REASON-CD                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7060                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0599B                                                                  
P0599B     MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
P0599B                                                                  
P0599B     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
P0599B        CONTINUE                                                  
P0599B     ELSE                                                         
P0599B        DISPLAY '********** PCSKR405 ABORT **********************'
P0599B        DISPLAY '* ABEND IN 7060-SELECT-NSF-REASON              *'
P0599B        DISPLAY '* SQL RETURN CODE = ' WS-DISPLAY-SQLCODE         
P0599B        DISPLAY '* NSF_REASON_CD   = ' NR-NSF-REASON-CD           
P0599B        DISPLAY '* PROCESSING TERMINATED                        *'
P0599B        DISPLAY '********** PCSKR405 ABORT **********************'
P0599B        PERFORM 9900-ABEND            THRU 9900-EXIT              
P0599B     END-IF.                                                      
P0599B*                                                                         
P0599B 7060-EXIT.                                                       
P0599B      EXIT.                                                       
P0599B*                                                                         
      ******************************************************************        
      * 7070-GET-NSF-DETAILS                                                    
      ******************************************************************        
      *                                                                         
       7070-GET-NSF-DETAILS.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT NSF_CHARGE_AMT                                     
                    ,RETURN_CHECK_AMT                                   
                    ,NSF_REASON_CD                                      
                    ,DRAWN_BY_NM                                        
                    ,DATE_TRAN                                          
                INTO                                                    
                     :NH-NSF-CHARGE-AMT                                 
                    ,:NH-RETURN-CHECK-AMT                               
                    ,:NH-NSF-REASON-CD                                  
                    ,:NH-DRAWN-BY-NM                                    
                    ,:NH-DATE-TRAN                                      
                FROM CSS_NSF_HIST WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO    = :NH-ACCOUNT-NO                     
                 AND NSF_TIMESTMP  = CIS.CHAR2TIMESTAMP(:NH-NSF-TIMESTMP
              )                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NSF_CHARGE_AMT                                             
MFA-TR*             ,RETURN_CHECK_AMT                                           
MFA-TR*             ,NSF_REASON_CD                                              
MFA-TR*             ,DRAWN_BY_NM                                                
MFA-TR*             ,DATE_TRAN                                                  
MFA-TR*         INTO                                                            
MFA-TR*              :NH-NSF-CHARGE-AMT                                         
MFA-TR*             ,:NH-RETURN-CHECK-AMT                                       
MFA-TR*             ,:NH-NSF-REASON-CD                                          
MFA-TR*             ,:NH-DRAWN-BY-NM                                            
MFA-TR*             ,:NH-DATE-TRAN                                              
MFA-TR*         FROM CSS_NSF_HIST                                               
MFA-TR*        WHERE ACCOUNT_NO    = :NH-ACCOUNT-NO                             
MFA-TR*          AND NSF_TIMESTMP  = :NH-NSF-TIMESTMP                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7070                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-DISPLAY-SQLCODE         
                                             WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '********** PCSKR405  ABORT ***************'
                    DISPLAY '* 7070-GET-NSF-DETAILS                   *'
                    DISPLAY '* SQLCODE IS        ' WS-DISPLAY-SQLCODE   
                    DISPLAY '* ACCOUNT NO:       ' NH-ACCOUNT-NO        
                    DISPLAY '* NSF TIMESTAMP:    ' NH-NSF-TIMESTMP      
                    DISPLAY '* PROGRAM ABORTING...                    *'
                    DISPLAY '********** PCSKR405  ABORT ***************'
                    PERFORM 9900-ABEND                   THRU 9900-EXIT 
           END-EVALUATE.                                                
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7090-SELECT-CREDIT-PROFILE                                     *        
      ******************************************************************        
      *                                                                         
       7090-SELECT-CREDIT-PROFILE.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT CASH_ONLY_FL                                       
                INTO :CZ-CASH-ONLY-FL                                   
                FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                        
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CASH_ONLY_FL                                               
MFA-TR*         INTO :CZ-CASH-ONLY-FL                                           
MFA-TR*         FROM CSS_CREDIT_PROFILE                                         
MFA-TR*        WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                                
MFA-TR*      QUERYNO 7090                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-DISPLAY-SQLCODE         
                                             WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '********** PCSKR405  ABORT ***************'
                    DISPLAY '* 7090-SELECT-CREDIT-PROFILE             *'
                    DISPLAY '* SQLCODE IS        ' WS-DISPLAY-SQLCODE   
                    DISPLAY '* ACCOUNT NO:       ' CZ-ACCOUNT-NO        
                    DISPLAY '* PROGRAM ABORTING...                    *'
                    DISPLAY '********** PCSKR405  ABORT ***************'
                    PERFORM 9900-ABEND                   THRU 9900-EXIT 
           END-EVALUATE.                                                
      *                                                                         
       7090-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7100-GET-WO-BALANCE                                           *        
      ******************************************************************        
      *                                                                         
       7100-GET-WO-BALANCE.                                             
      *                                                                         
           EXEC SQL                                                     
               SELECT SUM(AMT_TRANS)                                    
                 INTO :WS-WO-BALANCE :WS-NULL-IND-1                     
               FROM CSS_CHRG_OFF WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO  = :CO-ACCOUNT-NO                       
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_TRANS)                                            
MFA-TR*          INTO :WS-WO-BALANCE :WS-NULL-IND-1                             
MFA-TR*        FROM CSS_CHRG_OFF                                                
MFA-TR*        WHERE ACCOUNT_NO  = :CO-ACCOUNT-NO                               
MFA-TR*       QUERYNO 7450                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-DISPLAY-SQLCODE         
                                             WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '********** PCSKR405  ABORT ***************'
                    DISPLAY '* 7100-GET-WO-BALANCE                    *'
                    DISPLAY '* SQLCODE IS        ' WS-DISPLAY-SQLCODE   
                    DISPLAY '* ACCOUNT NO:       ' CO-ACCOUNT-NO        
                    DISPLAY '* PROGRAM ABORTING...                    *'
                    DISPLAY '********** PCSKR405  ABORT ***************'
                    PERFORM 9900-ABEND                   THRU 9900-EXIT 
           END-EVALUATE.                                                
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7500-OPEN-FINAL-NOTICE-CSR                                    *         
      ******************************************************************        
      *                                                                         
       7500-OPEN-FINAL-NOTICE-CSR.                                      
      *                                                                         
           EXEC SQL                                                     
              OPEN FINAL-NOTICE-CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-DISPLAY-SQLCODE         
                                             WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR405 ABORT **********************'
              DISPLAY '* ABEND IN 7500-OPEN-FINAL-NOTICE-CSR          *'
              DISPLAY '* FINAL-NOTICE-CSR ERROR                       *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR405 ABORT **********************'
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7510-FETCH-FINAL-NOTICE-CSR                                    *        
      ******************************************************************        
      *                                                                         
       7510-FETCH-FINAL-NOTICE-CSR.                                     
      *                                                                         
           EXEC SQL                                                     
              FETCH FINAL-NOTICE-CSR                                    
               INTO :AT-COMPANY-NO                                      
                   ,:AT-ACCOUNT-NO                                      
                   ,:AT-CUSTOMER-NO                                     
                   ,:AT-TOTAL-AR-BALANCE                                
                   ,:AT-BANKRUPTCY-IND                                  
                   ,:AT-JUDGEMENT-CASE-NO                               
                   ,:AT-LAST-PYMT-DATE :WS-LAST-PYMT-DATE-NULL       
                   ,:AT-LAST-PYMT-AMOUNT                                
                   ,:AT-PREMISE-NO                                      
                   ,:AT-LOCAL-OFFICE                                    
                   ,:AT-ADDRESS-ID                                      
                   ,:AT-ADDRESS-FORMAT                                  
                   ,:AT-BILL-CYCLE                                      
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:AT-CREDIT-GROUP                                    
                   ,:FW-REG-GROUP-CD                                    
                   ,:FW-SENIOR-FL                                       
                   ,:FW-FW-PATH-TYPE-CD                                 
                   ,:KD-FW-SEQ-NO                                       
                   ,:KD-FW-ACTION-TYPE-CD                               
                   ,:KD-FW-ACTION-DT                                    
                   ,:KD-FW-ACTION-AM                                    
                   ,:KD-FW-PROCESSED-FL                                 
                   ,:KD-FW-ACTION-COMMENTS                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-DISPLAY-SQLCODE         
                                             WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-LAST-PYMT-DATE-NULL < 0                       
                       MOVE SPACES        TO AT-LAST-PYMT-DATE          
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '********** PCSKR405 ABORT ***************' 
                    DISPLAY '* ABEND IN 7510-FETCH-FINAL-NOTICE-CSR  *' 
                    DISPLAY '* FINAL-NOTICE-CSR ERROR                *' 
                    DISPLAY '* SQL RETURN CODE   = ' WS-DISPLAY-SQLCODE 
                    DISPLAY '* NEXT BUSINESS DAY = ' WS-PROCESSED-DATE  
                    DISPLAY '* PROCESSING TERMINATED             *'     
                    DISPLAY '********** PCSKR405 ABORT ***************' 
                    PERFORM 9900-ABEND                    THRU 9900-EXIT
           END-EVALUATE.                                                
      *                                                                         
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7520-CLOSE-FINAL-NOTICE-CSR                                    *        
      ******************************************************************        
      *                                                                         
       7520-CLOSE-FINAL-NOTICE-CSR.                                     
      *                                                                         
           EXEC SQL                                                     
              CLOSE FINAL-NOTICE-CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-DISPLAY-SQLCODE         
                                             WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR405 ABORT **********************'
              DISPLAY '* ABEND IN 7520-CLOSE-FINAL-NOTICE-CSR         *'
              DISPLAY '* FINAL-NOTICE-CSR ERROR                       *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR405 ABORT **********************'
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7600-START-FCSJC01                                             *        
      * 7610-READ-FCSJC01                                              *        
      * 7611-CLOSE                                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7620-START-FCSCA00                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00039                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 8500-UPDATE-PROCESSED-FL                                       *        
      ******************************************************************        
      *                                                                         
       8500-UPDATE-PROCESSED-FL.                                        
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_FIN_WO_ACTION                                  
                 SET FW_PROCESSED_FL     = :WS-PROCESSED-FL             
               WHERE ACCOUNT_NO          = :AT-ACCOUNT-NO               
                 AND FW_SEQ_NO           = :KD-FW-SEQ-NO                
                 AND FW_ACTION_TYPE_CD   = :KD-FW-ACTION-TYPE-CD        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_FIN_WO_ACTION                                          
MFA-TR*          SET FW_PROCESSED_FL     = :WS-PROCESSED-FL                     
MFA-TR*        WHERE ACCOUNT_NO          = :AT-ACCOUNT-NO                       
MFA-TR*          AND FW_SEQ_NO           = :KD-FW-SEQ-NO                        
MFA-TR*          AND FW_ACTION_TYPE_CD   = :KD-FW-ACTION-TYPE-CD                
MFA-TR*      QUERYNO 8500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-DISPLAY-SQLCODE         
                                             WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '********** PCSKR405 ABORT ****************'
                    DISPLAY '* 8500-UPDATE-PROCESSED-FL               *'
                    DISPLAY '* ACCOUNT NO       :' AT-ACCOUNT-NO        
                    DISPLAY '* FW SEQ NO        :' KD-FW-SEQ-NO         
                    DISPLAY '* FW ACTION TYPE CD:' KD-FW-ACTION-TYPE-CD 
                    DISPLAY '* SQLCODE          :' WS-DISPLAY-SQLCODE   
                    DISPLAY '* PROCESSING TERMINATED                  *'
                    DISPLAY '********** PCSKR405 ABORT ****************'
                    PERFORM 9900-ABEND                THRU 9900-EXIT    
           END-EVALUATE.                                                
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8510-UPDATE-PROCESS-FL-ACTN-AM                                          
      ******************************************************************        
      *                                                                         
       8510-UPDATE-PROCESS-FL-ACTN-AM.                                  
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_FIN_WO_ACTION                                  
                 SET FW_ACTION_AM        = :WS-FW-ACTION-AM             
                    ,FW_PROCESSED_FL     = :WS-PROCESSED-FL             
               WHERE ACCOUNT_NO          = :KD-ACCOUNT-NO               
                 AND FW_SEQ_NO           = :KD-FW-SEQ-NO                
                 AND FW_ACTION_TYPE_CD   = :KD-FW-ACTION-TYPE-CD        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_FIN_WO_ACTION                                          
MFA-TR*          SET FW_ACTION_AM        = :WS-FW-ACTION-AM                     
MFA-TR*             ,FW_PROCESSED_FL     = :WS-PROCESSED-FL                     
MFA-TR*        WHERE ACCOUNT_NO          = :KD-ACCOUNT-NO                       
MFA-TR*          AND FW_SEQ_NO           = :KD-FW-SEQ-NO                        
MFA-TR*          AND FW_ACTION_TYPE_CD   = :KD-FW-ACTION-TYPE-CD                
MFA-TR*      QUERYNO 8510                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-DISPLAY-SQLCODE         
                                             WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN OTHER                                                
                   DISPLAY '********** PCSKR405 ABORT *****************'
                   DISPLAY '* 8510-UPDATE-PROCESS-FL-ACTN-AM          *'
                   DISPLAY '* ACCOUNT NO        :' AT-ACCOUNT-NO        
                   DISPLAY '* FW SEQ NO         :' KD-FW-SEQ-NO         
                   DISPLAY '* FW ACTION TYPE CD :' KD-FW-ACTION-TYPE-CD 
                   DISPLAY '* SQLCODE           :' WS-DISPLAY-SQLCODE   
                   DISPLAY '* PROCESSING TERMINATED                   *'
                   DISPLAY '********** PCSKR405 ABORT *****************'
                   PERFORM 9900-ABEND                THRU 9900-EXIT     
           END-EVALUATE.                                                
      *                                                                         
       8510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8888-COMMIT.                                                   *        
      ******************************************************************        
      *                                                                         
       8888-COMMIT.                                                     
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
      *                                                                         
           DISPLAY '*************************************************'  
           DISPLAY '* COMMIT POINT # ' WS-COMMITS-COUNT  ' TAKEN.   *'  
           DISPLAY '* LAST REC PROCESSED  = ' AT-ACCOUNT-NO             
           DISPLAY '*************************************************'. 
           MOVE ZEROS TO WS-RECS-TO-COMMIT-COUNT.                       
      *                                                                         
       8888-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-TERMINATE.                                                *        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   9600-PROCESS-ABEND                                           *        
      *        THIS ROUTINE IS EXECUTED ONLY FROM 9000-TERMINATE WHEN  *        
      *   AN ERROR CONDITION OCCURS.  SINCE 9000-TERMINATE IS          *        
      *   EXECUTED FROM 9700-PROCESS-ABEND, THIS PARAGRAPH WAS SETUP   *        
      *   TO AVOID LOOP.                                               *        
      ******************************************************************        
      *                                                                         
       9600-PROCESS-ABEND.                                              
      *                                                                         
           MOVE '9600'                   TO ACTIVE-PARAGRAPH.           
           MOVE RS-RETURN-CODE           TO RS-RETURN-CODE-DISP.        
      *                                                                         
           DISPLAY '*********************************************'      
           DISPLAY '** COMPONENT ABEND   ' ABEND-PROGRAM                
           DISPLAY '** DB2 RETURN CODE   ' RS-RETURN-CODE-DISP          
           DISPLAY '** ABEND FUNCTION    ' ABEND-FUNCTION               
           DISPLAY '** TABLE 1           ' TABLE-1                      
           DISPLAY '** TABLE ELEMENT 1   ' TABLE-ELEMENT-1              
           DISPLAY '** HOSTVAR ELEMENT 1 ' HOSTVAR-ELEMENT-1            
           DISPLAY '** TABLE 2           ' TABLE-2                      
           DISPLAY '** TABLE ELEMENT 2   ' TABLE-ELEMENT-2              
           DISPLAY '** HOSTVAR ELEMENT 2 ' HOSTVAR-ELEMENT-2            
           DISPLAY '** TABLE 3           ' TABLE-3                      
           DISPLAY '** TABLE ELEMENT 3   ' TABLE-ELEMENT-3              
           DISPLAY '** HOSTVAR ELEMENT 3 ' HOSTVAR-ELEMENT-3            
           DISPLAY '** TABLE 4           ' TABLE-4                      
           DISPLAY '** TABLE ELEMENT 4   ' TABLE-ELEMENT-4              
           DISPLAY '** HOSTVAR ELEMENT 4 ' HOSTVAR-ELEMENT-4            
           DISPLAY '*********************************************'      
           DISPLAY 'PERFORMING 9600-PROCESS-ABEND'.                     
      *                                                                         
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

      *                                                                         
           MOVE 12  TO  RETURN-CODE.                                    
           MOVE 'YES' TO WS-ABEND-SWITCH.                               
      *                                                                         
       9600-EXIT.                                                       
            IF WS-ABEND-YES                                             
                STOP RUN
            END-IF.                                               
      *                                                                         
      ******************************************************************        
      * 9700-PROCESS-ABEND.                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * THIS ROUTINE IS NEEDED FOR CPD00067                            *        
      ******************************************************************        
      *                                                                         
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE,     
                                             RS-RETURN-CODE,            
                                             WS-DISPLAY-SQLCODE.        
      *                                                                         
           DISPLAY '********** PCSKR405 ABORT *************************'
           DISPLAY '* 9900-SQL-ERROR-ROUTINE                           '
           DISPLAY '* SQLCODE        = ' WS-DISPLAY-SQLCODE             
           DISPLAY '* ABEND RECORD 1 = ' ABEND-RECORD-1-DATA            
           DISPLAY '* ABEND RECORD 2 = ' ABEND-RECORD-2-DATA            
           DISPLAY '* ABEND RECORD 3 = ' ABEND-RECORD-3-DATA            
           DISPLAY '* PROCESSING TERMINATED                           *'
           DISPLAY '********** PCSKR405 ABORT *************************'
           PERFORM 9900-ABEND                       THRU 9900-EXIT.     
      *                                                                         
      ******************************************************************        
      * 9900-ABEND.                                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
