       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSKR400.                                           
       DATE-WRITTEN.  23 MAR 2012.                                      
       DATE-COMPILED.                                                   
       AUTHOR.   ROBERTSON.                                             
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRICITY  & GAS              *          
      **                                                             *          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                   DB2                          ********          
      ****************************************************************          
      *                   PCSKR400   NARRATIVE                       *          
      *                                                              *          
      * THE PURPOSE OF PCSKR400 IS TO HAVE A SINGLE PROGRAM WHICH    *          
      * CONTAINS ALL THE LOGIC NECESSARY TO WRITE OFF AN ACCOUNT     *          
      ****************************************************************          
      ****************************************************************          
      **                                                             *          
      **              PROGRAM  MODIFICATION  LOG                     *          
      **                                                             *          
      ** DATE       INITIALS       REASON                            *          
P00599** 10/19/11   WR19680        INTITIAL CODING                   *          
P00599** 10/19/11   WR19680        INTITIAL CODING                   *          
ACT063** 05/31/13   BD09555        CHANGE TABLES SIZE TO 601  A04527 *          
AC4527** 07/03/13   WR19680        ADD CHANGE TO GET TO POPULATE WL  *          
AC4527**                           FOR WS-FW-BUS-PROCESS-CD-F8       *          
A04860** 12/29/14   AS7C117        REPLACE CSS_WQ_ITEMS_MF WITH      *          
A04860**            ACT054         CSS_WQ_ITEMS.                     *          
A05136**                                                             *          
A05136** 09/17/15   MR7E794        CREATE THE WQ FOR CREDIT AMOUNT<-1*          
A05136**            ACT182         INSTEAD OF MULTI CREDIT RECEIVABLE*          
A05136**                                                             *          
A05460** 04/15/16   MR7E794        FIX FOR PREVENT TO UPDATE THE WO  *          
A05460**            ACT117         STATUS 'S' BY ADD CONDITION CREDIT*          
A05460**                           AMOUNT < 0.00 IN PARA 1595.       *          
ACT278** 09/20/16   TP7R341        REMOVE UNWANTED COLUMNS FROM      *          
ACT278**  A05460                   CONTRACT AND CONTRACT TABLES      *          
ACT372** 12/05/16   VIJAY          INITIALIZE INDEX TO SUPPORT MFES  *          
ACT372**  A05460                   CONTRACT AND CONTRACT TABLES      *          
      ****************************************************************          
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     DATABASE ACCESS / INPUT MODULES         
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9900     TERMINATION MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSKR400'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                      PIC X(40)                      
           VALUE 'WORKING STORAGE FOR PCSKR400 STARTS HERE'.            
                                                                        
       01  WS-MISCELLANEOUS.                                            
COB305     05 WS-AR-RECEIVABLE-GL        PIC S9(3)V9(4) COMP-3 VALUE 0.         
COB305     05 WS-WO-GL-NO        PIC S9(3)V9(4) COMP-3 VALUE 0.            
           05  WS-REVENUE-MONTH       PIC S9(6)      COMP-3 VALUE +0.   
           05  WS-COMMON-DATE         PIC X(10)      VALUE SPACES.      
           05  WS-DEF-NEXT-BUS-DAY    PIC X(10)     VALUE SPACES.       
           05  WS-WO-TOTAL            PIC S9(09)V99  COMP-3 VALUE +0.   
           05  WS-DAYS-TO-BUMP        PIC S9(11)V99  COMP-3 VALUE +0.   
           05  WS-RECEIVABLES-EXIST   PIC X(01)      VALUE SPACES.      
           05  WS-NOW-PROCESS-WO      PIC X(01)      VALUE SPACES.      
           05  PROGRAM-NAME           PIC X(08)      VALUE 'PCSKR400'.  
           05  SCSCB061               PIC X(08)      VALUE 'SCSCB061'.  
A04860     05  SCSCB077               PIC X(08)      VALUE 'SCSCB077'.  
A04860     05  WS-INPUT-TS.                                             
A04860         10 WS-INPUT-DATE-PT    PIC X(10).                        
A04860         10 WS-INPUT-TIME-PT    PIC X(16)      VALUE              
A04860                                               '-00.00.00.000000'.
A04860     05  WS-PROG-TS.                                              
A04860         10 WS-PROG-DATE-PT     PIC X(10).                        
A04860         10 WS-PROG-TIME-PT     PIC X(16)      VALUE              
A04860                                               '-00.00.00.000000'.
           05  RS-RETURN-CODE         PIC S9(04)     COMP VALUE 0.      
           05  RS-RETURN-CODE-DISP    PIC +Z(04).                       
           05  WS-PGRMNAME            PIC X(08)      VALUE 'PCSKR400'.  
           05  SCSCA151               PIC X(08)      VALUE 'SCSCA151'.  
           05  WS-SYSTEM              PIC X(07)      VALUE 'SYSTEM '.   
           05  WS-PROGRAM-DATE        PIC X(10).                        
           05  WS-DISPLAY-SQLCODE     PIC -ZZZZZZZZ9.                   
           05  WS-CASH-COMPANY-NO     PIC X(02)      VALUE '01'.        
           05  WS-CASH-REPORT-NO      PIC X(03)      VALUE '997'.       
           05  WS-CASH-DRAWER-ID      PIC 9(04)      VALUE 9999.        
           05  WS-CHG-OFF-ACTUAL-BAL  PIC S9(07)V99  COMP VALUE ZERO.   
           05  WS-CHG-OFF-ACCT-TOTAL  PIC S9(07)V99  COMP VALUE ZERO.   
           05  WS-CHG-OFF-CMP-TOTAL   PIC S9(07)V99  COMP VALUE ZERO.   
           05  WS-CHG-OFF-AMT-TOTAL   PIC S9(07)V99  COMP VALUE ZERO.   
           05  WS-ACCT-ELIG-FOR-CHG-OFF   PIC X(01)  VALUE 'Y'.         
           05  WS-FW-ACTION-TYPE-CD-2 PIC X(05)      VALUE SPACES.      
           05  WS-DATE-ORIG-PYMT-IND  PIC S9(04) COMP VALUE ZERO.       
           05  WS-ACTION-TYPE-CD      PIC X(05)      VALUE SPACES.      
           05  WS-COLLECTION-AM       PIC S9(9)V9(2) USAGE COMP-3       
                                                     VALUE 0.           
           05  WS-CALLED-PGM-RC        PIC X(01)     VALUE SPACE.       
               88 WS-CALLED-PGM-BAD-RC               VALUE 'Y'.         
           05  WS-ZERO-CNT-WO-GL-FL    PIC X         VALUE 'N'.         
               88  WS-ZERO-CNT-WO-GL                 VALUE 'Y'.         
           05  WS-UPDATE-PROCESSING   PIC X(01)      VALUE 'N'.         
           05  WS-BANKRUPT            PIC X(10)      VALUE 'BANKRUPTCY'.
           05  WS-SYSTEM-GEN          PIC X(16)                         
               VALUE 'SYSTEM GENERATED'.                                
           05  WS-DATE-OF-CHG-OFF-NULL    PIC S9(04) COMP VALUE +0.     
           05  WS-COMPANY-NO-X         PIC X(02)     VALUE SPACES.      
           05  WS-CSR02294-PROCESS     PIC X(01)     VALUE SPACES.      
           05  WS-NSA-FLAG             PIC 9(01)     VALUE ZERO.        
               88 NSA-ACTIVE                         VALUE 1.           
               88 NSA-INACTIVE                       VALUE 0.           
           05  WS-VALID-RATE-FL        PIC X.                           
               88  VALID-RATE                        VALUE 'Y'.         
               88  NOT-VALID-RATE                    VALUE 'N'.         
           05  WS-CHARGE-OFF-COMPLETE  PIC X(01)     VALUE 'Y'.         
               88  CHARGE-OFF-WAS-COMPLETE           VALUE 'Y'.         
           05  SCSCB224               PIC X(08)      VALUE 'SCSCB224'.  
           05  MULTIPLE-ROWS          PIC S9(04) COMP VALUE -811.       
           05  WS-INDEX-192           PIC 9(04)      VALUE ZERO.        
           05  WS-PR-INDX             PIC S9(09) COMP VALUE 0.          
           05  WS-NO-DAYS             PIC S9(4)V9(5) COMP-3 VALUE 0.    
           05  WS-WQ-CATEGORY         PIC 9(04) VALUE ZERO.             
           05  WS-COMMENTS-INVALID-ACCT                                 
                                       PIC X(35)   VALUE                
               ' INVALID ACCT PASSED TO SCSCB224'.                      
           05  WS-COMMENTS-INVALID-UTL-AMT                              
                                       PIC X(36)   VALUE                
               ' INVALID UTIL AMT PASSED TO SCSCB224'.                  
           05  WS-COMMENTS-INVALID-CD-UTLTYP                            
                                       PIC X(36)   VALUE                
               ' INVALID UTIL TYP PASSED TO SCSCB224'.                  
           05  WS-COMMENTS-NON-CALC-BILL                                
                                       PIC X(35)   VALUE                
               ' NON-CALC BILL-CALCULATE MANUALLY'.                     
           05  WS-COMMENTS-WRITE-OFF-FAILED                             
                                       PIC X(26)   VALUE                
               ' WRITE-OFF ATTEMPT FAILED'.                             
           05  WS-COMMENTS-ZERO-GL-NO.                                  
               10  WS-COMMENTS-INVALID-GL                               
                                       PIC X(28)   VALUE                
               'INVALID WRITE-OFF GL # FOR '.                           
               10  WS-COMMENTS-CNTRCT-NAME                              
                                       PIC X(70)   VALUE SPACES.        
           05  WS-TRAN-CMNT-CSR02294                                    
                                       PIC X(56)   VALUE                
           'LPC ONLY RECEIVABLE. CREDITING TO PREVENT LPC WRITE OFF.'.  
ACT182     05  WS-CREDIT-RCVBLES.                                       
ACT182         10  WS-CREDIT-RCVBLES-MSG  PIC X(98)  VALUE              
              'CREDIT EXISTS IN ONE OR MORE RECEIVABLE.  PLEASE CORRECT         
ACT182-        'FOR ACCOUNT TO WRITE OFF. CREDIT AMOUNT $'.                     
ACT182         10  WS-CREDIT-AMOUNT       PIC -Z(7)99.9(2).             
COB305     05 WS-AMT-TRAN-BALANCE        PIC S999999999V99 USAGE COMP-3 
COB305       VALUE 0.   
      *                                                                         
           05  WS-LPC                  PIC X(03)     VALUE 'LPC'.       
           05  WS-LPN                  PIC X(03)     VALUE 'LPN'.       
           05  WS-S                   PIC X(01)     VALUE 'S'.          
           05  WS-W                   PIC X(01)     VALUE 'W'.          
           05  WS-X                   PIC X(01)     VALUE 'X'.          
           05  WS-N                   PIC X(01)     VALUE 'N'.          
           05  WS-Y                   PIC X(01)     VALUE 'Y'.          
           05  WS-NO                   PIC X(01)     VALUE 'N'.         
           05  WS-YES                  PIC X(01)     VALUE 'Y'.         
           05  WS-A192                 PIC X(04)     VALUE 'A192'.      
           05  WS-BATCH                PIC X(07)     VALUE 'BATCH  '.   
           05  WS-ELEC-UTIL-SW         PIC X(01)     VALUE 'N'.         
               88  ELECTRIC-ACCT                     VALUE 'E'.         
           05  WS-GAS-UTIL-SW          PIC X(01)     VALUE 'N'.         
               88  GAS-ACCT                          VALUE 'G'.         
           05  WS-NO-UTIL-SW           PIC X(01)     VALUE 'N'.         
               88  NO-UTIL-ACCT                      VALUE 'U'.         
           05  WS-WO-REC-SUB           PIC S9(04)    COMP   VALUE +0.   
COB305     05 WS-TOT-INV-RCVBLE        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-TOT-VAL-RCVBLE        PIC S9(09)V99 COMP-3 VALUE 0.            
           05  WS-NULL-INV-RCVBLE      PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-VAL-RCVBLE      PIC S9(04) COMP VALUE +0.        
           05  WS-LAST-PYMT-DATE-NI    PIC S9(04)    COMP VALUE +0.     
           05  WS-ALLOCATION-FACTOR    PIC S9(3)V9(4) COMP-3 VALUE +0.  
           05  WS-OTHER-RECV           PIC X(01)     VALUE SPACES.      
           05  WS-CNT-FACTOR           PIC S9(3)V9(4) COMP-3 VALUE +0.  
           05  WS-RCC-GAS-AMT          PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-RCC-ELEC-AMT         PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-LPC-ELEC-AMT         PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-LPC-GAS-AMT          PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-LPC-RECV-TOTAL       PIC S9(09)V99 COMP-3 VALUE +0.   
           05  WS-LPN-RECV-TOTAL       PIC S9(09)V99 COMP-3 VALUE +0.   
           05  WS-00-DAY-LPC           PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-30-DAY-LPC           PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-60-DAY-LPC           PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-90-DAY-LPC           PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-00-DAY-LPN           PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-30-DAY-LPN           PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-60-DAY-LPN           PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-90-DAY-LPN           PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-00-DAY-UTE           PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-00-DAY-UTG           PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-30-DAY-UTE           PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-30-DAY-UTG           PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-60-DAY-UTE           PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-60-DAY-UTG           PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-90-DAY-UTE           PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-90-DAY-UTG           PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-SECOND-INVEST-DT     PIC X(10).                       
           05  WS-FORTH-FINAL-DT       PIC X(10).                       
           05  WS-WRITE-OFF-DT         PIC X(10).                       
           05  WS-FIRST-CREDIT-LTR-DT  PIC X(10).                       
           05  WS-FIR-PLACE-COLL-DT    PIC X(10).                       
           05  WS-SEC-PLACE-COLL-DT    PIC X(10).                       
           05  WS-TRD-PLACE-COLL-DT    PIC X(10).                       
           05  WS-AMT-CNT-DETAIL       PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-OLD-ACTION-DT        PIC X(10)     VALUE SPACE.       
           05  WS-FW-OLD-ACTION-DT     PIC X(10)     VALUE SPACE.       
           05  WS-ACTION-DT            PIC X(10)     VALUE SPACE.       
COB305     05 WS-OLD-ACTION-AM        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.     
           05  WS-VALUE-LEFT           PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-CONTRACT-REC-BAL-NEEDED PIC X(01)  VALUE 'Y'.         
           05  WS-CONTRACT             PIC S9(03)    COMP VALUE 100.    
           05  WS-COUNT-CREDIT-REC     PIC S9(04) COMP VALUE +0.        
           05  WS-CNTRCT-ITEM-ID       PIC Z(08)9 VALUE ZEROS.          
           05  WS-AMT-TRAN-BAL-HOLD    PIC S9(9)V99  COMP-3 VALUE +0.   
           05  WS-FST-TIME             PIC X(01) VALUE 'Y'.             
           05  WS-FST-OCCUR            PIC X(01) VALUE 'N'.             
           05  PRV-WD-INDX             PIC S9(04)    COMP VALUE 0.      
           05  WS-CREDIT-BUREAU-DT     PIC X(10).                       
           05  WRITE-OFF-INDX          PIC S9(04)    COMP VALUE 0.      
           05  WS-FIN-PROCESS-DT       PIC X(10)     VALUE SPACES.      
           05  WS-FINAL-PROCESS-DT     PIC X(10)     VALUE SPACES.      
           05  WS-REFRST-ACT-DT        PIC X(10)     VALUE SPACES.      
           05  WS-WITHDRAW-DT          PIC X(10)     VALUE SPACES.      
           05  WS-PYMT-PRIORITY-LVL    PIC S9(04)    COMP VALUE 0.      
           05  WS-PYMT-PRIORITY-LVL1   PIC S9(04)    COMP VALUE 0.      
           05  WS-PYMT-PRIORITY-LVL2   PIC S9(04)    COMP VALUE 0.      
           05  WS-TRAN-APPL-NO         PIC S9(04) COMP VALUE +0.        
           05  WS-PREV-TRAN-APPL-NO    PIC S9(4) COMP VALUE +0.         
           05  WS-JRNL-TRAN-APPL-NO    PIC S9(4) COMP VALUE +0.         
           05  WS-BATCH-TRAN-APPL-NO   PIC S9(4) COMP VALUE +0.         
           05  WS-AC-LAST-UPDATE-TS1   PIC X(26)     VALUE SPACES.      
           05  WS-AC-LAST-UPDATE-TS2   PIC X(26)     VALUE SPACES.      
           05  WS-ACCOUNT-NO           PIC 9(13)     VALUE ZEROS.       
COB305     05 WS-CUSTOMER-NO        PIC S9(10)V COMP-3 VALUE 0.              
           05  WS-ACCOUNT-NBR          PIC S9(13) COMP-3 VALUE ZEROS.   
COB305     05 WS-PREMISE-NO        PIC S9(10)V COMP-3 VALUE 0.              
           05  WS-CODE-PREMISE-STAT    PIC X(01).                       
           05  WS-COMPANY-NO           PIC X(02).                       
           05  WS-BANKRUPTCY-IND       PIC X(01).                       
COB305     05 WS-TOTAL-AR-BALANCE        PIC S9(11)V9(2) USAGE COMP-3 
COB305       VALUE 0.        
           05  WS-DATABASE            PIC 9(01)      VALUE ZERO.        
               88  CSR-DATABASE                      VALUE 1.           
               88  SEB-DATABASE                      VALUE 2.           
           05  WS-AMT-CREDIT-LPC-WO    PIC S9(4)V9(5) USAGE COMP-3      
                                                      VALUE 0.          
           05  WS-AMT-CREDIT-LPC-WO-01 PIC S9(4)V9(5) USAGE COMP-3      
                                                      VALUE 0.          
           05  WS-AMT-CREDIT-LPC-WO-26 PIC S9(4)V9(5) USAGE COMP-3      
                                                      VALUE 0.          
           05  WS-C8-DELINQ-VALUE      PIC S9(04)V9(05) USAGE COMP-3    
                                                     VALUE 0.           
           05  WS-DEL-VAL-SEB          PIC S9(04)V9(05) USAGE COMP-3    
                                                     VALUE 0.           
           05  WS-DEL-VAL-CSR01        PIC S9(04)V9(05) USAGE COMP-3    
                                                     VALUE 0.           
           05  WS-DEL-VAL-CSR26        PIC S9(04)V9(05) USAGE COMP-3    
                                                     VALUE 0.           
           05  WS-COMPANY-NO-01        PIC X(02) VALUE '01'.            
           05  WS-COMPANY-NO-26        PIC X(02) VALUE '26'.            
           05  WS-COMPANY-NO-DELINQ    PIC X(02)  VALUE SPACES.         
           05  WS-TIMESTAMP            PIC X(26)      VALUE SPACES.     
           05  WS-ACCOUNT-NO-NUM       PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-REG-DEREG-FLAG       PIC X(01)     VALUE 'N'.         
               88  REGULATED                         VALUE 'Y'.         
               88  DEREGULATED                       VALUE 'N'.         
           05  WS-TEMP-DATE            PIC X(10)     VALUE SPACES.      
           05  WS-LOCAL-OFFICE-NO      PIC X(03).                       
COB305     05 WS-BALANCE-DUE        PIC S9(09)V99 COMP-3 VALUE 0.            
           05  WS-FW-SEQ-NO-NULL-IND   PIC S9(04)    COMP VALUE 0.      
           05  WS-BILL-DAY-00-NULL     PIC S9(04)    COMP VALUE +0.     
           05  WS-IZ-COLL-AGY-NULL     PIC S9(4)     COMP VALUE ZERO.   
           05  WS-FW-SEQ-NO            PIC S9(04)    COMP VALUE 0.      
           05  WS-FW-OLD-SEQ-NO        PIC S9(04)    COMP VALUE 0.      
           05  WS-WO-SEQ-NO-MAX        PIC S9(04) COMP VALUE 0.         
           05  WS-F8-SEQ-NO-CHECK      PIC S9(05)V USAGE COMP-3         
                                                 VALUE 0.               
           05  WS-FW-OLD-ACTION-AM     PIC S9(9)V9(2) USAGE COMP-3      
                                                     VALUE 0.           
ACT182     05  WS-AMT-TRAN-NULL-IND    PIC S9(04)    COMP VALUE 0.      
      *                                                                         
           05 WS-SEQ-MATCH             PIC X(01) VALUE 'N'.             
               88 WS-SEQ-MATCH-EXIST             VALUE 'Y'.             
               88 WS-SEQ-MATCH-NOT-EXIST         VALUE 'N'.             
      *                                                                         
           05  WS-WORK-DAYS-LOAD       PIC X(01)     VALUE 'N'.         
               88  WORK-DAYS-LOADED                  VALUE 'Y'.         
               88  WORK-DAYS-NOT-LOADED              VALUE 'N'.         
      *                                                                         
           05  WS-CHRG-OFF-EXISTS      PIC X(01)  VALUE 'N'.            
           05  WS-ACCOUNT-ISSUE        PIC X(01)  VALUE 'N'.            
           05  WS-ACCOUNT-FAIL         PIC 9(13).                       
           05  WS-SUBSEQUENT-WO-FL     PIC X(01) VALUE 'N'.             
               88 SUBSEQUENT-WO                  VALUE 'Y'.             
           05  WS-WO-DATE-EXISTS       PIC X(01) VALUE 'N'.             
               88  WO-DATE-EXISTS                VALUE 'Y'.             
      *                                                                         
           05  WS-RFCST-ACTN-FOUND     PIC X(01) VALUE 'N'.             
               88 RFCST-ACTN-FOUND               VALUE 'Y'.             
           05  WS-RFCST-ACTN-INSERT    PIC X(01) VALUE 'N'.             
               88 RFCST-ACTN-INSERT              VALUE 'Y'.             
           05  WS-NEW-ACTN-INSERT      PIC X(01) VALUE 'N'.             
               88 NEW-ACTN-INSERT                VALUE 'Y'.             
      *                                                                         
           05  WS-FCST-ACTN            PIC X(01) VALUE 'N'.             
               88 FCST-ACTN                      VALUE 'Y'.             
               88 NO-MORE-FCST-ACTN              VALUE 'N'.             
      *                                                                         
           05  WS-NON-REFUNDED-DEP-EXISTS PIC X(01).                    
               88  NON-REFUNDED-DEP-EXISTS           VALUE 'Y'.         
      *                                                                         
           05  WS-GUARANTOR-EXISTS        PIC X(01).                    
               88  GUARANTOR-EXISTS                  VALUE 'Y'.         
      *                                                                         
           05  WS-SURETY-BOND-EXISTS      PIC X(01).                    
               88  SURETY-BOND-EXISTS                VALUE 'Y'.         
      *                                                                         
           05  WS-PROCESS-ACCOUNT        PIC X(01)   VALUE 'N'.         
               88  PROCESS-ACCT                      VALUE 'Y'.         
               88  SKIP-ACCT                         VALUE 'N'.         
      *                                                                         
       01  WS-DONE-LPC-ELEC             PIC X(1)  VALUE 'N'.            
           88 NO-MORE-ELEC              VALUE 'Y'.                      
           88 MORE-ELEC                 VALUE 'N'.                      
      *                                                                         
       01  WS-COMMENTS.                                                 
           05 WS-COMMENTS-LEN             PIC S9(4) USAGE COMP.         
           05 WS-COMMENTS-TEXT            PIC X(250).                   
      *                                                                         
       01  WS-COMMIT-VARS.                                              
           05  WS-COMMIT-COUNTER         PIC 9(04)     VALUE ZEROS.     
           05  WS-RECS-TO-COMMIT-COUNTER PIC 9(04)     VALUE ZEROS.     
           05  WS-READY-TO-COMMIT-COUNT  PIC S9(09) COMP VALUE +0.      
      *                                                                         
       01  WS-WO-MTH-YR-X             PIC X(06).                        
       01  WS-FW-COLL-SEQ-NO          PIC S9(04)    COMP VALUE 0.       
       01  WS-FW-ACTION-DT            PIC X(10)     VALUE SPACES.       
       01  WS-CURRENT-DATE            PIC X(10).                        
COB305 01 WS-TOTAL-LPC        PIC S9(13)V9(2) USAGE COMP-3 VALUE 0.     
COB305 01 WS-LPC-AMT        PIC S9(11)V9(2) USAGE COMP-3 VALUE 0.     
COB305 01 WS-LPN-AMT        PIC S9(11)V9(2) USAGE COMP-3 VALUE 0.     
COB305 01 WS-LPC-LPN        PIC S9(11)V9(2) USAGE COMP-3 VALUE 0.     
       01  WS-LPC-NULL-IND            PIC S9(04) COMP.                  
       01  WS-TS-NULL-IND             PIC S9(04) COMP.                  
       01  WS-TOTAL-CNT-REC           PIC S9(13)V99 COMP-3 VALUE ZERO.  
COB305 01 WS-CONTRACT-REC-AMT        PIC S9(11)V99 COMP-3 VALUE 0.             
COB305 01 WS-CONTRACT-REC-UN-CR        PIC S9(11)V99 COMP-3 VALUE 0.            
       01  WS-CHARGE-OFF-DATE-CHECK   PIC X(10).                        
       01  WS-DONE-RCC-ELEC             PIC X(1)  VALUE 'N'.            
           88 NO-MORE-ELEC-RCC          VALUE 'Y'.                      
           88 MORE-ELEC-RCC             VALUE 'N'.                      
      *                                                                         
       01  WS-PREV-COLUMN-VALUE.                                        
           05  WS-PREV-COLUMN-AM       PIC $$$$$$$$9.99.                
      *                                                                         
       01  WS-CHG-COLUMN-VALUE.                                         
           05  WS-CHG-COLUMN-AM        PIC $$$$$$$$9.99.                
      *                                                                         
       01  WS-NUMERIC-AMT              PIC 9(9)V9(2).                   
      *                                                                 00040000
       01  WS-DATE-BREAKDOWN.                                           
           05  WS-DATE-YYYY            PIC X(4).                        
           05  FILLER                  PIC X(1).                        
           05  WS-DATE-MM              PIC X(2).                        
           05  FILLER                  PIC X(1).                        
           05  WS-DATE-DD              PIC X(2).                        
      *                                                                         
       01  WS-DATE-NEW-FORMAT.                                          
           05  WS-DATE-NEW-MM          PIC X(2).                        
           05  FILLER                  PIC X(1) VALUE '/'.              
           05  WS-DATE-NEW-DD          PIC X(2).                        
           05  FILLER                  PIC X(1) VALUE '/'.              
           05  WS-DATE-NEW-YYYY        PIC X(4).                        
      *                                                                         
      *                                                                 00074000
       01  WS-END1                      PIC X(1)  VALUE 'N'.            
           88 NO-MORE-ROWS              VALUE 'Y'.                      
           88 MORE-ROWS                 VALUE 'N'.                      
      *                                                                         
       01 WS-CNT-MISC.                                                  
          05  WS-CHGOFF-ACCUM        PIC S9(11)V99 COMP-3 VALUE +0.00.  
COB305    05 WS-ADJ-CHGOFF-DIFF-AMT        PIC S9(11)V99 COMP-3 VALUE 0.        
      *                                                                 00074000
       01 WS-WO-TBL.                                                    
          05  WS-WO-GRP  OCCURS 100 TIMES                               
                       INDEXED BY WS-WO-INDX.                           
COB305        10 WS-AMOUNT        PIC S9(11)V99 COMP-3 VALUE 0.      
COB305        10 WS-GL-ACCOUNT-NO-DR        PIC S9(3)V9(4) COMP-3 
COB305          VALUE 0.     
COB305        10 WS-GL-ACCOUNT-NO-CR        PIC S9(3)V9(4) COMP-3 
COB305          VALUE 0.     
      *                                                                         
       01 WS-CNT-WO-TBL.                                                
          05  WS-WO-CNT-GRP  OCCURS 50 TIMES                            
                       INDEXED BY WS-CNT-INDX.                          
COB305        10 WS-CNT-CHGOFF-AMT        PIC S9(11)V99 COMP-3 VALUE 0.         
              10  WS-UOM-CD                  PIC X(2).                  
              10  WS-BNFT-COST-CENTER        PIC X(3).                  
              10  WS-CODE-CONTRACT-TYPE      PIC X(1).                  
              10  WS-PROPERTY-UNIT-CD        PIC X(8).                  
              10  WS-WRT-OFF-WK-ORD-NO       PIC X(9).                  
              10  WS-WRT-OFF-FNCTN-CODE      PIC X(4).                  
              10  WS-WRT-OFF-NOE-CODE        PIC X(3).                  
              10  WS-WRT-OFF-COST-CNTR       PIC X(3).                  
COB305        10 WS-WRT-OFF-GL-ACCT-NO        PIC S9(3)V9(4) COMP-3 
COB305          VALUE 0.     
COB305        10 WS-CONTRACT-NAME-CD        PIC S9(4) COMP-3 VALUE 0.          
COB305        10 WS-CONTRACT-ITEM-ID        PIC S9(9) COMP-3 VALUE 0.          
      *                                                                         
       01 WS-WO-REC-TBL.                                                
          05  WS-WO-REC-ENTRY OCCURS 20 TIMES                           
                       INDEXED BY WS-WO-REC-INDX.                       
COB305        10 WS-WO-00-DAY        PIC S9(09)V99 COMP-3 VALUE 0.     
COB305        10 WS-WO-30-DAY        PIC S9(09)V99 COMP-3 VALUE 0.     
COB305        10 WS-WO-60-DAY        PIC S9(09)V99 COMP-3 VALUE 0.     
COB305        10 WS-WO-90-DAY        PIC S9(09)V99 COMP-3 VALUE 0.     
              10  WS-WO-ITEM-ID              PIC S9(09)     COMP.       
COB305        10 WS-GL-ACCT-CR        PIC S9(3)V9(4) COMP-3 VALUE 0.     
COB305        10 WS-GL-ACCT-DR        PIC S9(3)V9(4) COMP-3 VALUE 0.     
      *                                                                         
                                                                        
       01 WS-ACCOUNT-TABLE.                                             
          05  WS-ACCOUNT-LINE OCCURS 750 TIMES.                         
              10  WS-ACCOUNT                 PIC X(13).                 
              10  WS-REASON.                                            
                  15  WS-REASON-PT1              PIC X(28).             
                  15  WS-REASON-PT2              PIC X(04).             
      *                                                                         
       01 WS-FIN-WO-PATH-TBL.                                           
          05  WS-FIN-REC-ENTRY OCCURS 4000 TIMES                        
                       INDEXED BY WS-FIN-INDX.                          
              10  WS-COMPANY-NO-F8-TBL       PIC X(02)    VALUE SPACES. 
              10  WS-REG-GROUP-CD-F8-TBL     PIC X(03)    VALUE SPACES. 
              10  WS-FW-PATH-TYPE-CD-F8-TBL  PIC X(02)    VALUE SPACES. 
              10  WS-FW-ACTION-SEQ-F8        PIC S9(05)V                
                                                 USAGE COMP-3 VALUE 0.  
              10  WS-FW-ACTION-TYPE-F8       PIC X(05)    VALUE SPACES. 
              10  WS-FW-ACTION-DAYS-F8       PIC S9(05)V                
                                                 USAGE COMP-3 VALUE 0.  
              10  WS-FW-FRCST-TIME-CD-F8     PIC X(01)    VALUE SPACES. 
              10  WS-FW-FRCST-SOURCE-CD-F8   PIC X(01)    VALUE SPACES. 
              10  WS-FW-FRCST-ACTN-LIMIT-F8  PIC S9(09)V99              
                                                 USAGE COMP-3 VALUE 0.  
              10  WS-FW-COLLECTION-FL-F8     PIC X(01)    VALUE SPACES. 
AC4527        10  WS-FW-BUS-PROCESS-CD-F8    PIC X(02) VALUE SPACES.    
      *                                                                         
       01  WS-WORK-DAY-TABLE.                                           
           03  WS-WORK-DAY-LIST                                         
ACT063            OCCURS 601 TIMES                                      
                  ASCENDING KEY WS-WORK-DAY                             
                  INDEXED BY WD-INDX.                                   
               05  WS-WORK-DAY            PIC X(10).                    
      *                                                                         
      *01  LOC1                        USAGE IS SQL TYPE IS             
      *                                RESULT-SET-LOCATOR VARYING.      
      *                                                                         
       01  PARM-FIELDS-REDEFINITION.                                    
      *                                                                         
           05 PARM-CR-AMT-AR-DAY-00-N       PIC S9(9)V99.               
           05 PARM-CR-AMT-AR-DAY-00-N1  REDEFINES                       
                PARM-CR-AMT-AR-DAY-00-N     PIC 9(11).                  
           05 PARM-CR-AMT-AR-DAY-30-N       PIC S9(9)V99.               
           05 PARM-CR-AMT-AR-DAY-30-N1  REDEFINES                       
                PARM-CR-AMT-AR-DAY-30-N     PIC 9(11).                  
           05 PARM-CR-AMT-AR-DAY-60-N       PIC S9(9)V99.               
           05 PARM-CR-AMT-AR-DAY-60-N1  REDEFINES                       
                PARM-CR-AMT-AR-DAY-60-N     PIC 9(11).                  
           05 PARM-CR-AMT-AR-DAY-90-N       PIC S9(9)V99.               
           05 PARM-CR-AMT-AR-DAY-90-N1  REDEFINES                       
                PARM-CR-AMT-AR-DAY-90-N     PIC 9(11).                  
           05 PARM-CR-AMT-AR-TOTAL-N        PIC S9(9)V99.               
           05 PARM-CR-AMT-AR-TOTAL-N1   REDEFINES                       
                PARM-CR-AMT-AR-TOTAL-N      PIC 9(11).                  
           05 PARM-PRINCIPAL-AMT-N          PIC S9(9)V99.               
           05 PARM-PRINCIPAL-AMT-N1     REDEFINES                       
                PARM-PRINCIPAL-AMT-N        PIC 9(11).                  
           05 PARM-STATE-TAX-AMT-N          PIC S9(9)V99.               
           05 PARM-STATE-TAX-AMT-N1     REDEFINES                       
                PARM-STATE-TAX-AMT-N        PIC 9(11).                  
           05 PARM-CITY-TAX-AMT-N           PIC S9(9)V99.               
           05 PARM-CITY-TAX-AMT-N1      REDEFINES                       
                PARM-CITY-TAX-AMT-N         PIC 9(11).                  
           05 PARM-OTHER-TAX-AMT-N          PIC S9(9)V99.               
           05 PARM-OTHER-TAX-AMT-N1     REDEFINES                       
                PARM-OTHER-TAX-AMT-N        PIC 9(11).                  
           05 PARM-DEF-INT-AMT-N            PIC S9(9)V99.               
           05 PARM-DEF-INT-AMT-N1       REDEFINES                       
                PARM-DEF-INT-AMT-N          PIC 9(11).                  
           05 PARM-EARNED-INT-AMT-N         PIC S9(9)V99.               
           05 PARM-EARNED-INT-AMT-N1    REDEFINES                       
                PARM-EARNED-INT-AMT-N       PIC 9(11).                  
                                                                        
      * INPUT PARAMETERS FOR CSR02294                                           
       01  WS-INPUT-PARM.                                               
           05 PARM-ACCOUNT-NO-X-TEMP        PIC X(13).                  
           05 PARM-ITEM-ID                  PIC S9(09) COMP.            
           05 PARM-RECV-TYPE                PIC X(03).                  
           05 PARM-PYMT-PRIORITY-LVL        PIC S9(4) USAGE COMP.       
           05 PARM-DB-GL-NUMBER-X-TEMP      PIC X(07).                  
           05 PARM-CR-AMT-AR-DAY-00-X-TEMP  PIC X(11).                  
           05 PARM-CR-AMT-AR-DAY-30-X-TEMP  PIC X(11).                  
           05 PARM-CR-AMT-AR-DAY-60-X-TEMP  PIC X(11).                  
           05 PARM-CR-AMT-AR-DAY-90-X-TEMP  PIC X(11).                  
           05 PARM-CR-AMT-AR-TOTAL-X-TEMP   PIC X(11).                  
           05 PARM-DIST-RECV-TYPE           PIC X(03).                  
           05 PARM-DIST-PYMT-PRI-LVL        PIC S9(4) USAGE COMP.       
           05 PARM-DIST-ITEM-ID             PIC S9(09) COMP VALUE ZERO. 
           05 PARM-RESP-AREA                PIC X(03).                  
           05 PARM-USER-ID                  PIC X(07).                  
           05 PARM-AT-LAST-UPDATE-TS        PIC X(26).                  
           05 PARM-AC-LAST-UPDATE-TS        PIC X(26).                  
           05 PARM-TRAN-COMNT-LEN         PIC S9(4) COMP SYNC VALUE +0. 
           05 PARM-TRAN-COMNT-TEXT          PIC X(210) VALUE SPACES.    
           05 PARM-PRINCIPAL-AMT-X-TEMP     PIC X(11).                  
           05 PARM-STATE-TAX-AMT-X-TEMP     PIC X(11).                  
           05 PARM-CITY-TAX-AMT-X-TEMP      PIC X(11).                  
           05 PARM-OTHER-TAX-AMT-X-TEMP     PIC X(11).                  
           05 PARM-DEF-INT-AMT-X-TEMP       PIC X(11).                  
           05 PARM-EARNED-INT-AMT-X-TEMP    PIC X(11).                  
           05 PARM-CNT-NAME-CD              PIC S9(04) COMP VALUE 0.    
           05 PARM-REVENUE-MONTH-TEMP       PIC X(06).                  
      *                                                                         
       01  FIOWK11.                                                     
           02  FIOWK11-DATA-REC.                                        
               05  E-FWK11-JRNL-SORT-ID         PIC X(1).               
               05  E-FWK11-100-RECORD-ID-DATA.                          
COB305             10 E-FWK11-ACCT-NO        PIC S9(13) COMP-3 VALUE 0.  
COB305             10 E-FWK11-CUSTOMER-NO        PIC S9(10) COMP-3 
COB305               VALUE 0.  
COB305             10 E-FWK11-PREMISE-NO        PIC S9(10) COMP-3 
COB305               VALUE 0.  
               05  E-FWK11-GL-RECORD-ID-DATA REDEFINES                  
                   E-FWK11-100-RECORD-ID-DATA.                          
                   10  E-FWK11-100-GL-ACCT-NO   PIC S9(3)V9(4) COMP-3.  
                   10  FILLER                   PIC X(15).              
               05  E-FWK11-100-LOCAL-OFFICE-CD  PIC X(3).               
               05  E-FWK11-100-COMPANY-NO       PIC X(2).               
               05  E-FWK11-CODE-TERMINAL-TRAN   PIC X(4).               
COB305         05 E-FWK11-JRNL-TRAN-APPL-NO        PIC S9(3) COMP-3 
COB305           VALUE 0.  
               05  E-FWK11-DATE-LAST-ACTION     PIC X(10).              
               05  E-FWK11-CODE-ENTRY-SOURCE    PIC X(1).               
               05  E-FWK11-TRAN-ERRORS.                                 
                   10  E-FWK11-CODE-TRAN-ERRORS PIC X(1)                
                       OCCURS 7 TIMES.                                  
               05  E-FWK11-USER-DEFINED-AREA    PIC X(150).             
               05  E-FWK11-SORT-SUM-FLD         PIC 9(01).              
      *                                                                         
      * RETURN FIELDS FOR CSR02294                                              
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-CANCELDNP-FLAG       PIC X(01) VALUE SPACES.           
           05  S-AR-LOCKOUT-IND       PIC X(01) VALUE SPACES.           
           05  S-XFER-ACCT-NO         PIC X(13) VALUE SPACES.           
           05  S-CANCELNOT-FLAG       PIC X(01) VALUE SPACES.           
      *                                                                 00139500
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSKR400 ENDS HERE  '.            
                                                                        
      *                                                                         
      *****************************************************************         
      * CWS00337 CONTAINS WS FOR CPD00337 LOAD LPC LIMITS             *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CWS00337                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CWS00315 CONTAINS WS FOR FINDING NEXT BUSINESS DAY            *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CWS00322                                                   
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ***************************************************************** 01553800
      * COMMON DATE ROUTINES                                          *         
      *****************************************************************         
           EXEC SQL                                                     01553900
               INCLUDE CWS00038                                         01554000
           END-EXEC.                                                    01554100
      *                                                                 01554200
       01  WS-INSERT-ROW-COUNT REDEFINES WS-INPUT-DATA-BREAKDOWN.       
           10  WS-PARM-COMMIT-ROW-COUNT-TXT PIC X(09).                  
               88 COMMIT-ROW-CNT         VALUE 'COMMIT = '.             
           10  WS-NO-OF-ROWS-TO-COMMIT   PIC X(05).                     
           10  FILLER                    PIC X(66).                     
      *                                                                         
           EXEC SQL                                                     01553900
               INCLUDE CWS00039                                         01554000
           END-EXEC.                                                    01554100
      *                                                                 01554200
      ******************************************************************        
      *    EXEC SQL                                                     00042600
      *       INCLUDE CWS10007                                          00042700
      *    END-EXEC.                                                    00042800
      *                                                                         
      ******************************************************************        
      * GENERAL LEDGER COPYBOOK                                        *        
      ******************************************************************        
       COPY CWS00061.                                                   01555000
                                                                        
      ******************************************************************        
      * VARIABLES NEEDED FOR ACCOUNT SKIP PROCESSING.                  *        
      ******************************************************************        
                                                                        
       COPY CWSCA151.                                                           
                                                                        
      ******************************************************************        
      * ABEND SWITCH COPYBOOK                                          *        
      ******************************************************************        
       COPY CWS09900.                                                   01554900
       COPY CWS00010.                                                   01555200
                                                                        
      ******************************************************************        
      *  CODES DATA PRESENT                                            *        
      ******************************************************************        
       COPY CWS00056.                                                   01555100
      *                                                                         
       COPY CWSCA224.                                                           
      *                                                                         
      ******************************************************************        
      *  JOURNALLING COPYBOOKS                                         *        
      ******************************************************************        
       COPY CJF00101.                                                   01555400
      *                                                                 01555500
           EXEC SQL                                                     01555900
              INCLUDE CWS00013                                          01556000
           END-EXEC.                                                    01557000
      *                                                                 01558000
       COPY FIOCA01.                                                    01560000
                                                                        
      ******************************************************************        
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'                 *        
      ******************************************************************        
       COPY FIOJC01.                                                    01570000
       COPY FIOCA00.                                                    01580000
      *                                                                 00139500
       COPY CWS00041.                                                           
      *                                                                         
       COPY CJF00102.                                                   00180500
      *                                                                 00203500
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSKR400 ENDS HERE  '.            
                                                                        
      *                                                                 00139500
      * USED FOR DB2 AND CICS ERROR PROCESSING                          02264000
      *                                                                 02264100
       COPY CWS00303.                                                   02264200
      *                                                                 02265000
           EXEC SQL                                                     02270000
               INCLUDE SQLCA                                            02280000
           END-EXEC.                                                    02290000
      *                                                                 02300000
      *                                                                 02744000
      ******************************************************************        
      * DCLGEN FOR CSS_JOB_PARM                                        *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                 00203500
      ******************************************************************        
      * DCLGEN FOR CSS_CUSTOMER   (CU)                                 *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
      *                                                                 00203500
      ******************************************************************        
      * DCLGEN FOR CSS_DELINQUENCY (C8)                                *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                 00203500
      ******************************************************************        
      * DCLGEN FOR CSS_ACCOUNT     (AT)                                *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                 00203500
      ******************************************************************        
      * DCLGEN FOR CSS_AR_TRANS_HIST (AR)                              *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
               INCLUDE TBARHIST                                                 
           END-EXEC.                                                            
      *                                                                 00203500
      ******************************************************************        
      * DCLGEN FOR CSS_AR_TRN_HST_DET (AU)                             *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
               INCLUDE TBARHDT                                                  
           END-EXEC.                                                            
      ******************************************************************        
      * DCLGEN FOR CSS_PREMISE       (PR)                              *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                 00203500
      ******************************************************************        
      * DCLGEN FOR CSS_BANK_EFT      (BE)                              *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
               INCLUDE TBBNKEFT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DCLGEN FOR CSS_AR_CNTL       (AR)                              *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
               INCLUDE TBARCNTL                                                 
           END-EXEC.                                                            
      *                                                                 00203500
      ******************************************************************        
      * DCLGEN FOR CSS_CHG_OFF_AMT   (SN)                              *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
               INCLUDE TBCHGAMT                                                 
           END-EXEC.                                                            
      *                                                                 00203500
      ******************************************************************        
      * DCLGEN FOR CSS_CHG_OFF       (CO)                              *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
               INCLUDE TBCHGOFF                                                 
           END-EXEC.                                                            
      *                                                                 00203500
      ******************************************************************        
      * DCLGEN FOR CSS_CONTRACT      (CT)                              *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
               INCLUDE TBCNTRCT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DCLGEN FOR CSS_CNT_DETAIL    (EA)                              *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
               INCLUDE TBCNTDET                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DCLGEN FOR CSS_UTIL_ENVRNMT  (UT)                              *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DCLGEN FOR CSS_CONNECT_CHRG  (CC)                              *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
               INCLUDE TBCCCHRG                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DCLGEN FOR CSS_LOCAL_OFFICE  (B1)                              *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DCLGEN FOR CSS_GL_ACCT_NO    (GO)                              *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
               INCLUDE TBGLATNO                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DCLGEN FOR CSS_RECONNECT_CHRG (U7)                             *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
               INCLUDE TBRCNCHR                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DCLGEN FOR CSS_FINAL_WO       (FW)                             *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
               INCLUDE TBFINLWO                                                 
           END-EXEC.                                                            
      *                                                                 00203500
      ******************************************************************        
      * DCLGEN FOR CSS_CUST_PLAN      (CP)                             *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
               INCLUDE TBCSTPLN                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DCLGEN FOR CSS_CONTRACT_INFO  (K6)                             *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
               INCLUDE TBCNTINF                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_WQ_PGM_CNTL    WN                                                
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBWQCNTL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DCLGEN FOR CSS_MNT_TRANS_HIST  (MH)                            *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
                INCLUDE TBMNHIST                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DCLGEN FOR CSS_MT_TRN_HST_DET   (MI)                           *02581000
      ******************************************************************02582000
           EXEC SQL                                                             
                INCLUDE TBMNHDT                                                 
           END-EXEC.                                                    00054800
      *                                                                 02794300
      ******************************************************************        
      * DCLGEN FOR CSS_GUARANTOR        (GU)                           *02581000
      ******************************************************************02582000
           EXEC SQL                                                     00054600
               INCLUDE TBGTNTR                                          00054700
           END-EXEC.                                                    00054800
      *                                                                 02794300
      ******************************************************************        
      * DCLGEN FOR CSS_DEP_ON_HAND      (DO)                           *02581000
      ******************************************************************02582000
           EXEC SQL                                                     00047700
               INCLUDE TBDEPHND                                         00047800
           END-EXEC.                                                    00047900
      *                                                                 02794300
      ******************************************************************        
      * DCLGEN FOR CSS_SURETY_BOND      (SB)                           *02581000
      ******************************************************************02582000
           EXEC SQL                                                     00058200
              INCLUDE TBSTYBND                                          00058300
           END-EXEC.                                                    00058400
      ******************************************************************02799400
      * DCLGEN FOR CSS_BATCH_JRNL  (BJ)                                *02799500
      ******************************************************************02799600
           EXEC SQL                                                     02799700
               INCLUDE TBBTJRNL                                         02799800
           END-EXEC.                                                    02799900
      *                                                                 02800000
      ******************************************************************        
      * DCLGEN FOR CSS_BCH_JRNL_CNTL  (BC)                             *02800100
      ******************************************************************02800200
           EXEC SQL                                                     02800300
               INCLUDE TBBJCNTL                                         02800400
           END-EXEC.                                                    02800500
      *                                                                 02800600
      ******************************************************************        
      * DCLGEN FOR CSS_MISC_JRNL  (MJ)                                 *02800700
      ******************************************************************02800800
           EXEC SQL                                                     02800900
               INCLUDE TBMSJRNL                                         02801000
           END-EXEC.                                                    02801100
      *                                                                         
      ******************************************************************        
      * DCLGEN FOR CSS_REG_PROFILE  (LR)                               *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBREGPRF                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DCLGEN FOR CSS_RATE_PLAN_DESC (RD)                             *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBRTDESC                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DCLGEN FOR CSS_FIN_WO_ACTION  (KD)                             *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBFWACTN                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DCLGEN FOR CSS_FIN_WO_COLLECT (IZ)                             *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBFWCLAG                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DCLGEN FOR CSS_FW_FCST_ACTION  (F8)                            *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBFWPDTL                                                 
           END-EXEC.                                                            
      ******************************************************************        
      * DCLGEN FOR CSS_FW_ATTRIB_DESC   (KV)                           *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBATTDES                                                 
           END-EXEC.                                                            
ACT182*                                                                         
ACT182******************************************************************        
ACT182* DCLGEN FOR CSS_BUSINESS_DAYS    (1G)                           *        
ACT182******************************************************************        
ACT182     EXEC SQL                                                             
ACT182         INCLUDE TBBUSDAY                                                 
ACT182     END-EXEC.                                                            
      *                                                                         
      ***************************************************************** 00010000
      *  CWS00346     CONTAINS WS GETTING WQ GENERATION FLAG          * 00020000
      ***************************************************************** 00080000
           EXEC SQL                                                             
              INCLUDE CWS00346                                                  
           END-EXEC.                                                            
A04860*                                                                         
A04860/****** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077             
A04860      EXEC SQL                                                            
A04860           INCLUDE CWS00077                                               
A04860      END-EXEC.                                                           
A04860*                                                                         
      *                                                                         
      ******************************************************************        
      *                                                                         
      **** CURSOR TO SELECT FB/WO ACTIONS TO BE PROCESSED***************        
           EXEC SQL                                                     
             DECLARE FINAL_WO_ACTN_CRSR CURSOR WITH HOLD FOR            
                SELECT                                                  
                     FW.ACCOUNT_NO                                      
                    ,FW.REG_GROUP_CD                                    
                    ,FW.SENIOR_FL                                       
                    ,KD.FW_SEQ_NO                                       
                    ,KD.FW_ACTION_TYPE_CD                               
                    ,KD.FW_ACTION_DT                                    
                    ,KD.FW_ACTION_AM                                    
                    ,KD.FW_PROCESSED_FL                                 
                    ,AT.COMPANY_NO                                      
                    ,AT.CUSTOMER_NO                                     
                    ,AT.PREMISE_NO                                      
                    ,AT.TOTAL_AR_BALANCE                                
                    ,AT.LOCAL_OFFICE                                    
                    ,AT.BANKRUPTCY_IND                                  
                    ,AT.JUDGEMENT_CASE_NO                               
                    ,AT.LAST_PYMT_DATE                                  
                    ,AT.LAST_PYMT_AMOUNT                                
                    ,AT.CODE_ACCT_STAT                                  
                    ,AT.CODES_DATA_PRESENT                              
                    ,AT.DATE_BILL_DAY_00                                
                    ,AT.ACCOUNT_TYPE_CODE                               
                    ,AT.ELEC_REV_ALLOC_PCT                              
                    ,AT.CODE_STATUS_REASON                              
                    ,B1.DISTRICT_NO                                     
                    ,B1.ELEC_REV_ALLOC_PCT                              
                FROM CSS_ACCOUNT       AT WITH(READUNCOMMITTED),                
                     CSS_FIN_WO_ACTION KD WITH(READUNCOMMITTED),                
                     CSS_FINAL_WO      FW WITH(READUNCOMMITTED),                
                     CSS_LOCAL_OFFICE  B1 WITH(READUNCOMMITTED)                 
                WHERE FW.ACCOUNT_NO     = AT.ACCOUNT_NO                 
                AND   FW.ACCOUNT_NO     = KD.ACCOUNT_NO                 
                AND   B1.LOCAL_OFFICE   = AT.LOCAL_OFFICE               
                AND   KD.FW_ACTION_DT   <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )             
                AND   KD.FW_BUS_PROCESS_CD = 'WO'                       
                AND   KD.FW_PROCESSED_FL   = ' '                        
                AND   AT.CODE_ACCT_STAT = 'B'                           
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE FINAL_WO_ACTN_CRSR CURSOR WITH HOLD FOR                    
MFA-TR*         SELECT                                                          
MFA-TR*              FW.ACCOUNT_NO                                              
MFA-TR*             ,FW.REG_GROUP_CD                                            
MFA-TR*             ,FW.SENIOR_FL                                               
MFA-TR*             ,KD.FW_SEQ_NO                                               
MFA-TR*             ,KD.FW_ACTION_TYPE_CD                                       
MFA-TR*             ,KD.FW_ACTION_DT                                            
MFA-TR*             ,KD.FW_ACTION_AM                                            
MFA-TR*             ,KD.FW_PROCESSED_FL                                         
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*             ,AT.CUSTOMER_NO                                             
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*             ,AT.TOTAL_AR_BALANCE                                        
MFA-TR*             ,AT.LOCAL_OFFICE                                            
MFA-TR*             ,AT.BANKRUPTCY_IND                                          
MFA-TR*             ,AT.JUDGEMENT_CASE_NO                                       
MFA-TR*             ,AT.LAST_PYMT_DATE                                          
MFA-TR*             ,AT.LAST_PYMT_AMOUNT                                        
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.CODES_DATA_PRESENT                                      
MFA-TR*             ,AT.DATE_BILL_DAY_00                                        
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                                       
MFA-TR*             ,AT.ELEC_REV_ALLOC_PCT                                      
MFA-TR*             ,AT.CODE_STATUS_REASON                                      
MFA-TR*             ,B1.DISTRICT_NO                                             
MFA-TR*             ,B1.ELEC_REV_ALLOC_PCT                                      
MFA-TR*         FROM CSS_ACCOUNT       AT,                                      
MFA-TR*              CSS_FIN_WO_ACTION KD,                                      
MFA-TR*              CSS_FINAL_WO      FW,                                      
MFA-TR*              CSS_LOCAL_OFFICE  B1                                       
MFA-TR*         WHERE FW.ACCOUNT_NO     = AT.ACCOUNT_NO                         
MFA-TR*         AND   FW.ACCOUNT_NO     = KD.ACCOUNT_NO                         
MFA-TR*         AND   B1.LOCAL_OFFICE   = AT.LOCAL_OFFICE                       
MFA-TR*         AND   KD.FW_ACTION_DT   <= :WS-CURRENT-DATE                     
MFA-TR*         AND   KD.FW_BUS_PROCESS_CD = 'WO'                               
MFA-TR*         AND   KD.FW_PROCESSED_FL   = ' '                                
MFA-TR*         AND   AT.CODE_ACCT_STAT = 'B'                                   
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*       QUERYNO 7110                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
                DECLARE CUST-RECEIVABLE  CURSOR FOR                     
                SELECT AMT_AR_DAY_00,                                   
                       AMT_AR_DAY_30,                                   
                       AMT_AR_DAY_60,                                   
                       AMT_AR_DAY_90,                                   
                       AMT_UNUSED_CR,                                   
                       AMT_TRAN_BALANCE,                                
                       ITEM_ID,                                         
                       PYMT_PRIORITY_LVL                                
                FROM  CSS_AR_CNTL WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NBR                      
                ORDER BY PYMT_PRIORITY_LVL DESC, ITEM_ID DESC           
                FOR READ ONLY                                   
                                                            
          END-EXEC.                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE CUST-RECEIVABLE  CURSOR FOR                             
MFA-TR*         SELECT AMT_AR_DAY_00,                                           
MFA-TR*                AMT_AR_DAY_30,                                           
MFA-TR*                AMT_AR_DAY_60,                                           
MFA-TR*                AMT_AR_DAY_90,                                           
MFA-TR*                AMT_UNUSED_CR,                                           
MFA-TR*                AMT_TRAN_BALANCE,                                        
MFA-TR*                ITEM_ID,                                                 
MFA-TR*                PYMT_PRIORITY_LVL                                        
MFA-TR*         FROM  CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NBR                              
MFA-TR*         ORDER BY PYMT_PRIORITY_LVL DESC, ITEM_ID DESC                   
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*       QUERYNO 7920                                                      
MFA-TR*   END-EXEC.                                                             
      *                                                                         
           EXEC SQL                                                     
              DECLARE UTIL-ENV-CSR CURSOR FOR                           
              SELECT  CODE_UTIL_TYPE,                                   
                      IC_NO                                             
              FROM    CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
              WHERE   ACCOUNT_NO = :WS-ACCOUNT-NBR                      
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE UTIL-ENV-CSR CURSOR FOR                                   
MFA-TR*       SELECT  CODE_UTIL_TYPE,                                           
MFA-TR*               IC_NO                                                     
MFA-TR*       FROM    CSS_UTIL_ENVRNMT                                          
MFA-TR*       WHERE   ACCOUNT_NO = :WS-ACCOUNT-NBR                              
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7710                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
             DECLARE UNMTRD-CURSOR CURSOR FOR                           
               SELECT CODE_SERVICE_TYPE                                 
               FROM CSS_CUST_PLAN                                       
               WHERE ACCOUNT_NO     =:WS-ACCOUNT-NBR                    
               AND CODE_UTIL_TYPE   =:UT-CODE-UTIL-TYPE                 
               AND IC_NO            =:UT-IC-NO
            OPTION(FAST 1)
            FOR READ ONLY
                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ021
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE UNMTRD-CURSOR CURSOR FOR                                   
MFA-TR*        SELECT CODE_SERVICE_TYPE                                         
MFA-TR*        FROM CSS_CUST_PLAN                                               
MFA-TR*        WHERE ACCOUNT_NO     =:WS-ACCOUNT-NBR                            
MFA-TR*        AND CODE_UTIL_TYPE   =:UT-CODE-UTIL-TYPE                         
MFA-TR*        AND IC_NO            =:UT-IC-NO                                  
MFA-TR*        OPTIMIZE FOR 1 ROW FOR FETCH ONLY                                
MFA-TR*       QUERYNO 7840                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
                DECLARE CNT-CSR CURSOR FOR                              
                SELECT                                                  
                     A.AMT_ORIG_ENTERED,                                
                     A.CODE_CONTRACT_TYPE,                              
                     A.CNT_NAME_CD,                                     
                     A.CNT_ITEM_ID,                                     
                     A.GL_ACCT_NO_DEF_INT,                              
                     A.GL_ACCT_NO_ERN_INT,                              
                     A.AMT_DEF_INTEREST,                                
                     A.SIMPLE_INT_FIN_CHG,                              
                     B.CHARGE_AM,                                       
ACT278               A.AMT_TAX_CITY,                                    
ACT278               A.AMT_TAX_OTHER,                                   
ACT278               A.AMT_TAX_STATE,                                   
                     B.WRT_OFF_GL_ACCT_NO                               
                FROM CSS_CONTRACT A, CSS_CNT_DETAIL B                   
                WHERE A.ACCOUNT_NO        =:AC-ACCOUNT-NO              
                AND   A.CNT_ITEM_ID       =:AC-ITEM-ID                 
                AND   A.ACCOUNT_NO        = B.ACCOUNT_NO                
                AND   A.CNT_ITEM_ID       = B.CNT_ITEM_ID               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE CNT-CSR CURSOR FOR                                      
MFA-TR*         SELECT                                                          
MFA-TR*              A.AMT_ORIG_ENTERED,                                        
MFA-TR*              A.CODE_CONTRACT_TYPE,                                      
MFA-TR*              A.CNT_NAME_CD,                                             
MFA-TR*              A.CNT_ITEM_ID,                                             
MFA-TR*              A.GL_ACCT_NO_DEF_INT,                                      
MFA-TR*              A.GL_ACCT_NO_ERN_INT,                                      
MFA-TR*              A.AMT_DEF_INTEREST,                                        
MFA-TR*              A.SIMPLE_INT_FIN_CHG,                                      
MFA-TR*              B.CHARGE_AM,                                               
MFA-TR*              A.AMT_TAX_CITY,                                            
MFA-TR*              A.AMT_TAX_OTHER,                                           
MFA-TR*              A.AMT_TAX_STATE,                                           
MFA-TR*              B.WRT_OFF_GL_ACCT_NO                                       
MFA-TR*         FROM CSS_CONTRACT A, CSS_CNT_DETAIL B                           
MFA-TR*         WHERE A.ACCOUNT_NO        =: AC-ACCOUNT-NO                      
MFA-TR*         AND   A.CNT_ITEM_ID       =: AC-ITEM-ID                         
MFA-TR*         AND   A.ACCOUNT_NO        = B.ACCOUNT_NO                        
MFA-TR*         AND   A.CNT_ITEM_ID       = B.CNT_ITEM_ID                       
MFA-TR*       QUERYNO 7810                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
             DECLARE WO_ACCT_ACT_REC CURSOR FOR                         
               SELECT DISTINCT                                          
                  AT.ACCOUNT_NO,                                        
                  AT.CUSTOMER_NO,                                       
                  AT.COMPANY_NO,                                        
                  AT.CODES_DATA_PRESENT,                                
                  AT.PREMISE_NO,                                        
                  AT.ELEC_REV_ALLOC_PCT,                                
                  AT.LOCAL_OFFICE,                                      
                  AT.CODE_ACCT_STAT,                                    
                  AT.DATE_BILL_DAY_00,                                  
                  AT.CODE_STATUS_REASON,                                
                  AT.CODE_COMPANY_ACCT,                                 
                  AT.TOTAL_AR_BALANCE,                                  
                  AT.ACCOUNT_TYPE_CODE,                                 
                  AT.ADDRESS_FORMAT,                                    
                  AT.ADDRESS_ID,                                        
                  AT.CREDIT_GROUP,                                      
                  AT.LAST_PYMT_AMOUNT,                                  
                  AT.LAST_PYMT_DATE,                                    
                  B1.ELEC_REV_ALLOC_PCT,                                
                  PR.CODE_PREMISE_STAT,                                 
                  PR.REV_DISTRICT_CD,                                   
                  CU.CODE_EMPL_ACCT,                                    
                  FW.REG_GROUP_CD,                                      
                  FW.SENIOR_FL                                          
               FROM                                                     
                  CSS_ACCOUNT       AT WITH(READUNCOMMITTED),                   
                  CSS_AR_CNTL       AC WITH(READUNCOMMITTED),                   
                  CSS_LOCAL_OFFICE  B1 WITH(READUNCOMMITTED),                   
                  CSS_PREMISE       PR WITH(READUNCOMMITTED),                   
                  CSS_CUSTOMER      CU WITH(READUNCOMMITTED),                   
                  CSS_FINAL_WO      FW WITH(READUNCOMMITTED)                    
               WHERE AT.ACCOUNT_NO   = AC.ACCOUNT_NO                    
                 AND AT.ACCOUNT_NO   = FW.ACCOUNT_NO                    
                 AND (AMT_AR_DAY_00 <> 0                                
                  OR  AMT_AR_DAY_30 <> 0                                
                  OR  AMT_AR_DAY_60 <> 0                                
                  OR  AMT_AR_DAY_90 <> 0                                
                  OR  AMT_UNUSED_CR <> 0                                
                  OR  TOT_SUMM_UNBILLED <> 0)                           
                 AND AT.CODE_ACCT_STAT = 'S'                            
                 AND AT.LOCAL_OFFICE = B1.LOCAL_OFFICE                  
                 AND AT.COMPANY_NO   = B1.COMPANY_NO                    
                 AND AT.CUSTOMER_NO  = CU.CUSTOMER_NO                   
                 AND AT.PREMISE_NO   = PR.PREMISE_NO                    
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE WO_ACCT_ACT_REC CURSOR FOR                                 
MFA-TR*        SELECT DISTINCT                                                  
MFA-TR*           AT.ACCOUNT_NO,                                                
MFA-TR*           AT.CUSTOMER_NO,                                               
MFA-TR*           AT.COMPANY_NO,                                                
MFA-TR*           AT.CODES_DATA_PRESENT,                                        
MFA-TR*           AT.PREMISE_NO,                                                
MFA-TR*           AT.ELEC_REV_ALLOC_PCT,                                        
MFA-TR*           AT.LOCAL_OFFICE,                                              
MFA-TR*           AT.CODE_ACCT_STAT,                                            
MFA-TR*           AT.DATE_BILL_DAY_00,                                          
MFA-TR*           AT.CODE_STATUS_REASON,                                        
MFA-TR*           AT.CODE_COMPANY_ACCT,                                         
MFA-TR*           AT.TOTAL_AR_BALANCE,                                          
MFA-TR*           AT.ACCOUNT_TYPE_CODE,                                         
MFA-TR*           AT.ADDRESS_FORMAT,                                            
MFA-TR*           AT.ADDRESS_ID,                                                
MFA-TR*           AT.CREDIT_GROUP,                                              
MFA-TR*           AT.LAST_PYMT_AMOUNT,                                          
MFA-TR*           AT.LAST_PYMT_DATE,                                            
MFA-TR*           B1.ELEC_REV_ALLOC_PCT,                                        
MFA-TR*           PR.CODE_PREMISE_STAT,                                         
MFA-TR*           PR.REV_DISTRICT_CD,                                           
MFA-TR*           CU.CODE_EMPL_ACCT,                                            
MFA-TR*           FW.REG_GROUP_CD,                                              
MFA-TR*           FW.SENIOR_FL                                                  
MFA-TR*        FROM                                                             
MFA-TR*           CSS_ACCOUNT       AT,                                         
MFA-TR*           CSS_AR_CNTL       AC,                                         
MFA-TR*           CSS_LOCAL_OFFICE  B1,                                         
MFA-TR*           CSS_PREMISE       PR,                                         
MFA-TR*           CSS_CUSTOMER      CU,                                         
MFA-TR*           CSS_FINAL_WO      FW                                          
MFA-TR*        WHERE AT.ACCOUNT_NO   = AC.ACCOUNT_NO                            
MFA-TR*          AND AT.ACCOUNT_NO   = FW.ACCOUNT_NO                            
MFA-TR*          AND (AMT_AR_DAY_00 <> 0                                15186900
MFA-TR*           OR  AMT_AR_DAY_30 <> 0                                        
MFA-TR*           OR  AMT_AR_DAY_60 <> 0                                        
MFA-TR*           OR  AMT_AR_DAY_90 <> 0                                        
MFA-TR*           OR  AMT_UNUSED_CR <> 0                                        
MFA-TR*           OR  TOT_SUMM_UNBILLED <> 0)                                   
MFA-TR*          AND AT.CODE_ACCT_STAT = 'S'                                    
MFA-TR*          AND AT.LOCAL_OFFICE = B1.LOCAL_OFFICE                          
MFA-TR*          AND AT.COMPANY_NO   = B1.COMPANY_NO                            
MFA-TR*          AND AT.CUSTOMER_NO  = CU.CUSTOMER_NO                           
MFA-TR*          AND AT.PREMISE_NO   = PR.PREMISE_NO                            
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*       QUERYNO 7905                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
             DECLARE WO_CUST_RECEIVABLE CURSOR FOR                      
               SELECT                                                   
                  AC.AMT_AR_DAY_00,                                     
                  AC.AMT_AR_DAY_30,                                     
                  AC.AMT_AR_DAY_60,                                     
                  AC.AMT_AR_DAY_90,                                     
                  AC.AMT_UNUSED_CR,                                     
                  AC.AMT_TRAN_BALANCE,                                  
                  AC.ITEM_ID,                                           
                  AC.PYMT_PRIORITY_LVL                                  
               FROM                                                     
                  CSS_AR_CNTL AC WITH(READUNCOMMITTED)                          
               WHERE AC.ACCOUNT_NO   = :WS-ACCOUNT-NBR                  
                 AND AC.PYMT_PRIORITY_LVL NOT IN (50, 70, 80, 90, 129)  
               ORDER BY AC.PYMT_PRIORITY_LVL DESC, AC.ITEM_ID DESC      
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE WO_CUST_RECEIVABLE CURSOR FOR                              
MFA-TR*        SELECT                                                           
MFA-TR*           AC.AMT_AR_DAY_00,                                             
MFA-TR*           AC.AMT_AR_DAY_30,                                             
MFA-TR*           AC.AMT_AR_DAY_60,                                             
MFA-TR*           AC.AMT_AR_DAY_90,                                             
MFA-TR*           AC.AMT_UNUSED_CR,                                             
MFA-TR*           AC.AMT_TRAN_BALANCE,                                          
MFA-TR*           AC.ITEM_ID,                                                   
MFA-TR*           AC.PYMT_PRIORITY_LVL                                          
MFA-TR*        FROM                                                             
MFA-TR*           CSS_AR_CNTL AC                                                
MFA-TR*        WHERE AC.ACCOUNT_NO   = :WS-ACCOUNT-NBR                          
MFA-TR*          AND AC.PYMT_PRIORITY_LVL NOT IN (50, 70, 80, 90, 129)          
MFA-TR*        ORDER BY AC.PYMT_PRIORITY_LVL DESC, AC.ITEM_ID DESC              
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*       QUERYNO 7970                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
            DECLARE REFORECAST_WO CURSOR WITH HOLD FOR                  
             SELECT AT.ACCOUNT_NO,                                      
                    AT.COMPANY_NO,                                      
                    AT.CODE_STATUS_REASON                               
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
                   ,CSS_FINAL_WO FW WITH(READUNCOMMITTED)                       
              WHERE AT.CODE_ACCT_STAT    = 'B'                          
                AND AT.TOTAL_AR_BALANCE  > 0                            
                AND FW.FINAL_BILL_DT   < IIF(TRY_CONVERT(DATE, 
                                                   :WS-FINAL-PROCESS-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-FINAL-PROCESS-DT
              ) <> 0) OR (LEN(:WS-FINAL-PROCESS-DT
              ) <> 10), CIS.CHAR2DATE(:WS-FINAL-PROCESS-DT
              ), CONVERT(DATE, :WS-FINAL-PROCESS-DT) )           
                AND AT.ACCOUNT_NO = FW.ACCOUNT_NO                       
              ORDER BY AT.ACCOUNT_NO                                    
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE REFORECAST_WO CURSOR WITH HOLD FOR                          
MFA-TR*      SELECT AT.ACCOUNT_NO,                                              
MFA-TR*             AT.COMPANY_NO,                                              
MFA-TR*             AT.CODE_STATUS_REASON                                       
MFA-TR*        FROM CSS_ACCOUNT AT                                              
MFA-TR*            ,CSS_FINAL_WO FW                                             
MFA-TR*       WHERE AT.CODE_ACCT_STAT    = 'B'                                  
MFA-TR*         AND AT.TOTAL_AR_BALANCE  > 0                                    
MFA-TR*         AND FW.FINAL_BILL_DT   < :WS-FINAL-PROCESS-DT                   
MFA-TR*         AND AT.ACCOUNT_NO = FW.ACCOUNT_NO                               
MFA-TR*       ORDER BY AT.ACCOUNT_NO                                            
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*       QUERYNO 7555                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
            DECLARE FIN_WO_PATH_CUR CURSOR FOR                          
             SELECT  F8.COMPANY_NO                                      
                    ,F8.REG_GROUP_CD                                    
                    ,F8.FW_PATH_TYPE_CD                                 
                    ,F8.FW_ACTION_SEQ_NO                                
                    ,F8.FW_ACTION_TYPE_CD                               
                    ,F8.FW_FCST_DAYS_NM                                 
                    ,F8.FW_FCST_TIME_CD                                 
                    ,F8.FW_FCST_SOURCE_CD                               
                    ,F8.FW_ACTION_LIMIT_AM                              
                    ,F8.FW_FCST_COLL_FL                                 
AC4527              ,F8.FW_BUS_PROCESS_CD                               
               FROM CSS_FW_FCST_ACTION F8 WITH(READUNCOMMITTED)                 
              WHERE F8.EFFECTIVE_DT   <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )               
                AND F8.EXPIRATION_DT  >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )               
              ORDER BY                                                  
                     F8.COMPANY_NO                                      
                    ,F8.REG_GROUP_CD                                    
                    ,F8.FW_PATH_TYPE_CD                                 
                    ,F8.FW_ACTION_SEQ_NO                                
                FOR READ ONLY                                   
                                                            
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE FIN_WO_PATH_CUR CURSOR FOR                                  
MFA-TR*      SELECT  F8.COMPANY_NO                                              
MFA-TR*             ,F8.REG_GROUP_CD                                            
MFA-TR*             ,F8.FW_PATH_TYPE_CD                                         
MFA-TR*             ,F8.FW_ACTION_SEQ_NO                                        
MFA-TR*             ,F8.FW_ACTION_TYPE_CD                                       
MFA-TR*             ,F8.FW_FCST_DAYS_NM                                         
MFA-TR*             ,F8.FW_FCST_TIME_CD                                         
MFA-TR*             ,F8.FW_FCST_SOURCE_CD                                       
MFA-TR*             ,F8.FW_ACTION_LIMIT_AM                                      
MFA-TR*             ,F8.FW_FCST_COLL_FL                                         
MFA-TR*             ,F8.FW_BUS_PROCESS_CD                                       
MFA-TR*        FROM CSS_FW_FCST_ACTION F8                                       
MFA-TR*       WHERE F8.EFFECTIVE_DT   <= :WS-CURRENT-DATE                       
MFA-TR*         AND F8.EXPIRATION_DT  >= :WS-CURRENT-DATE                       
MFA-TR*       ORDER BY                                                          
MFA-TR*              F8.COMPANY_NO                                              
MFA-TR*             ,F8.REG_GROUP_CD                                            
MFA-TR*             ,F8.FW_PATH_TYPE_CD                                         
MFA-TR*             ,F8.FW_ACTION_SEQ_NO                                        
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*       QUERYNO 7740                                                      
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE C1 CURSOR
MSQ001          FOR CALL CSR02294                                       
                       ( :PARM-ACCOUNT-NO-X-TEMP
                  , :PARM-ITEM-ID
                  , :PARM-RECV-TYPE
                  , :PARM-PYMT-PRIORITY-LVL
                  , :PARM-DB-GL-NUMBER-X-TEMP
                  , :PARM-CR-AMT-AR-DAY-00-X-TEMP
                  , :PARM-CR-AMT-AR-DAY-30-X-TEMP
                  , :PARM-CR-AMT-AR-DAY-60-X-TEMP
                  , :PARM-CR-AMT-AR-DAY-90-X-TEMP
                  , :PARM-CR-AMT-AR-TOTAL-X-TEMP
                  , :PARM-DIST-RECV-TYPE
                  , :PARM-DIST-PYMT-PRI-LVL
                  , :PARM-DIST-ITEM-ID
                  , :PARM-RESP-AREA
                  , :PARM-USER-ID
                  , :PARM-AT-LAST-UPDATE-TS
                  , :PARM-AC-LAST-UPDATE-TS
                  , :PARM-TRAN-COMNT-LEN
                  , :PARM-TRAN-COMNT-TEXT
                  , :PARM-PRINCIPAL-AMT-X-TEMP
                  , :PARM-STATE-TAX-AMT-X-TEMP
                  , :PARM-CITY-TAX-AMT-X-TEMP
                  , :PARM-OTHER-TAX-AMT-X-TEMP
                  , :PARM-DEF-INT-AMT-X-TEMP
                  , :PARM-EARNED-INT-AMT-X-TEMP
                  , :PARM-CNT-NAME-CD
                  , :PARM-REVENUE-MONTH-TEMP
                  )
MSQ001        END-EXEC.
                                                    
      *                                                                         
                                                                        
      *                                                                         
       PROCEDURE DIVISION.                                              

SCA006        SET WS-GL-SUB TO 1.
      *                                                                         
      ****************************************************************          
      * 0000-MAIN-PARA.                                              *          
      ****************************************************************          
       0000-MAIN-PARA.                                                  
      *                                                                         
           PERFORM 0100-INITIALIZATION          THRU 0100-EXIT.         
           PERFORM 0150-LOAD-FORECAST-OPTION    THRU 0150-EXIT.         
                                                                        
           IF WORK-DAYS-NOT-LOADED                                      
              PERFORM 0160-LOAD-WORK-DAYS        THRU 0160-EXIT         
              SET WORK-DAYS-LOADED TO TRUE                              
           END-IF.                                                      
      *                                                                         
           MOVE PROGRAM-NAME               TO                           
                                             WS-CPD00061-CALLING-PGM.   
           MOVE SPACES                     TO  ABEND-FUNCTION.          
           CALL SCSCB061 USING WS-GL-ACCT-NAME,                         
                               WS-GL-ACCT-MAJOR-FIELDS,                 
                               WS-VALID-COMPANY-NOS,                    
                               WS-GL-NAME-INFO,                         
                               WS-GL-ACCT-NO-TABLE,                     
                               WS-CPD00061-CALLING-PGM,                 
                               ABEND-FILE,                              
                               RS-RETURN-CODE.                          
                                                                        
           IF ABEND-FUNCTION > SPACES                                   
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 00220500
           MOVE WS-INPUT-DATE TO WS-NEW-BUSINESS-DAY.                   
           PERFORM 6500-GET-NEXT-BUSINESS-DAY                           
              THRU 6500-NEXT-BUSINESS-DAY-EXIT.                         
           MOVE WS-NEW-BUSINESS-DAY    TO WS-DEF-NEXT-BUS-DAY.          
      *                                                                         
           PERFORM 1000-PROCESS-ACCOUNTS        THRU 1000-EXIT.         
      *                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************02390000
      *   0100-INITIALIZATION                                          *02410000
      *        COMMON INITIALIZATION ROUTINE                           *02420000
      ******************************************************************02440000
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE              THRU 6251-EXIT.     
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE   THRU 6240-EXIT      
               MOVE WS-FCA00-COMMON-DATE    TO WS-INPUT-DATE            
           END-IF.                                                      
      *                                                                 04650000
           MOVE WS-INPUT-DATE          TO WS-CURRENT-DATE               
                                          WS-CHARGE-OFF-DATE-CHECK.     
      *                                                                 04670100
           PERFORM 0116-GET-COMMIT-ROW-COUNT    THRU 0116-EXIT.         
      *                                                                         
           MOVE 'COMMON'               TO G6-PROGRAM-NAME.              
           MOVE 20                     TO G6-SEQ-NO.                    
           MOVE '01'                   TO G6-COMPANY-NO.                
           MOVE 'A'                    TO G6-STATUS.                    
           MOVE 'DATE'                 TO G6-CMND-CODE.                 
           PERFORM 7000-GET-REVMON-DTBILL THRU 7000-EXIT.               
      *                                                                 04670100
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE G6-PARM-DATA(15:6)  TO WS-REVENUE-MONTH              
           ELSE                                                         
              MOVE ZEROS               TO WS-REVENUE-MONTH              
           END-IF.                                                      
      *                                                                 04680000
           MOVE 'DATABASE'             TO C8-DELINQ-CD.                 
           MOVE '01'                   TO C8-COMPANY-NO.                
           PERFORM 7160-SELECT-DELINQ-VALUE THRU 7160-EXIT.             
           MOVE WS-C8-DELINQ-VALUE     TO WS-DATABASE.                  
      *                                                                         
ACT372     SET WS-GL-SUB                 TO 1.                          
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      *0115-LOAD-F8-KA-VARIABLE                                        *        
      ******************************************************************        
       0115-LOAD-F8-KA-VARIABLE.                                        
                                                                        
           MOVE F8-COMPANY-NO            TO                             
                WS-COMPANY-NO-F8-TBL(WS-FIN-INDX).                      
           MOVE F8-REG-GROUP-CD          TO                             
                WS-REG-GROUP-CD-F8-TBL(WS-FIN-INDX).                    
           MOVE F8-FW-PATH-TYPE-CD       TO                             
                WS-FW-PATH-TYPE-CD-F8-TBL(WS-FIN-INDX).                 
           MOVE F8-FW-ACTION-SEQ-NO      TO                             
                WS-FW-ACTION-SEQ-F8(WS-FIN-INDX).                       
           MOVE F8-FW-ACTION-TYPE-CD     TO                             
                WS-FW-ACTION-TYPE-F8(WS-FIN-INDX).                      
           MOVE F8-FW-FCST-DAYS-NM       TO                             
                WS-FW-ACTION-DAYS-F8(WS-FIN-INDX).                      
           MOVE F8-FW-FCST-TIME-CD       TO                             
                WS-FW-FRCST-TIME-CD-F8(WS-FIN-INDX).                    
           MOVE F8-FW-FCST-SOURCE-CD     TO                             
                WS-FW-FRCST-SOURCE-CD-F8(WS-FIN-INDX).                  
           MOVE F8-FW-ACTION-LIMIT-AM    TO                             
                WS-FW-FRCST-ACTN-LIMIT-F8(WS-FIN-INDX).                 
           MOVE F8-FW-FCST-COLL-FL       TO                             
                WS-FW-COLLECTION-FL-F8(WS-FIN-INDX).                    
AC4527     MOVE F8-FW-BUS-PROCESS-CD     TO                             
AC4527          WS-FW-BUS-PROCESS-CD-F8(WS-FIN-INDX).                   
                                                                        
           SET WS-FIN-INDX UP BY 1.                                     
                                                                        
       0115-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 0116-GET-COMMIT-ROW-COUNT.                                     *        
      * GET THE COMMIT ROW COUNT FROM JOB PARM TABLE                   *        
      ******************************************************************        
       0116-GET-COMMIT-ROW-COUNT.                                       
      *                                                                         
           MOVE  WS-PGRMNAME               TO WS-PROGRAM.               
           MOVE  WS-PARM                   TO WS-COMMAND.               
           MOVE  ZEROS                     TO WS-SEQUENCE.              
           MOVE  SPACES                    TO WS-SYSIPT.                
           MOVE  WS-KEY-AREA               TO E-FJC01-KEY.              
      *                                                                         
           PERFORM 7600-START-FCSJC01      THRU  7600-EXIT.             
           PERFORM 7610-READ-FCSJC01       THRU  7610-EXIT              
              UNTIL (COMMIT-ROW-CNT AND INPUT-ACTIVE)                   
              OR  END-OF-SYSIPT.                                        
      *                                                                         
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '** ' WS-PGRMNAME ' PROCESSING WARNING  **'       
              DISPLAY '**  COMMIT-ROW-CNT PARM NOT ACTIVE     **'       
              DISPLAY '**  DEFAULT OF 1000 WILL BE USED  **'            
              DISPLAY '**  PROCESSING CONTINUING        **'             
              MOVE 1000 TO WS-READY-TO-COMMIT-COUNT                     
           ELSE                                                         
              IF WS-NO-OF-ROWS-TO-COMMIT NUMERIC                        
                 MOVE WS-NO-OF-ROWS-TO-COMMIT                           
                                         TO WS-READY-TO-COMMIT-COUNT    
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY '**  ' WS-PGRMNAME ' PROCESSING WARNING  **'   
                 DISPLAY '**  COMMIT-ROW-CNT PARM NOT NUMERIC  **'      
                 DISPLAY '**  DEFAULT OF 1000 WILL BE USED  **'         
                 DISPLAY '**  PROCESSING CONTINUING        **'          
                 MOVE 1000 TO WS-READY-TO-COMMIT-COUNT                  
              END-IF                                                    
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           END-IF.                                                      
      *                                                                         
       0116-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *0150-LOAD-FORECAST-OPTION                                       *        
      ******************************************************************        
       0150-LOAD-FORECAST-OPTION.                                       
                                                                        
           MOVE 'N'             TO   WS-END1.                           
                                                                        
           INITIALIZE WS-FIN-WO-PATH-TBL.                               
           SET WS-FIN-INDX TO 1.                                        
           PERFORM 7730-OPEN-FIN-WO-PATH-CUR     THRU 7730-EXIT.        
                                                                        
           PERFORM 7740-FETCH-FIN-WO-PATH-CUR    THRU 7740-EXIT         
                                     UNTIL NO-MORE-ROWS.                
                                                                        
       0150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * LOAD  NEXT 12 MONTHS WORK DAYS INTO TABLE. THIS IS USED        *        
      * IN W/O FORECASTING. ENTRY 101 IS                               *        
      * ALWAYS THE CURRENT DATE; 1-100 ARE PAST;  102-300 ARE          *        
      * FUTURE                                                         *        
      *                                                                *        
      ******************************************************************        
       0160-LOAD-WORK-DAYS.                                             
      *                                                                         
           MOVE WS-INPUT-DATE TO WS-CURRENT-DATE                        
                                 WS-NEW-BUSINESS-DAY                    
                                 WS-WORK-DAY (101).                     
           SET WD-INDX TO 100.                                          
           PERFORM UNTIL WD-INDX = 0                                    
              PERFORM 6525-PREV-BUSINESS-DAY                            
                 THRU 6525-PREV-BUSINESS-DAY-EXIT                       
                 MOVE WS-NEW-BUSINESS-DAY TO WS-WORK-DAY(WD-INDX)       
                  SET WD-INDX DOWN BY 1                                 
           END-PERFORM.                                                 
      *                                                                         
           MOVE WS-INPUT-DATE TO WS-WORK-DAY (101)                      
                                 WS-NEW-BUSINESS-DAY.                   
           SET WD-INDX TO 102.                                          
ACT063     PERFORM UNTIL WD-INDX > 601                                  
              PERFORM 6500-GET-NEXT-BUSINESS-DAY                        
                 THRU 6500-NEXT-BUSINESS-DAY-EXIT                       
                 MOVE WS-NEW-BUSINESS-DAY  TO WS-WORK-DAY (WD-INDX)     
                 SET WD-INDX UP BY 1                                    
           END-PERFORM.                                                 
      *                                                                         
       0160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0400-PREPARE-PRECOMMIT.                                        *        
      * ISSUE COMMIT IF THE COUNTER REACHED THE LIMIT                           
      ******************************************************************        
      *                                                                         
       0400-PREPARE-COMMIT.                                             
      *                                                                         
           ADD 1                  TO WS-COMMIT-COUNTER.                 
           PERFORM 8890-COMMIT    THRU 8890-EXIT.                       
           MOVE ZEROS             TO WS-RECS-TO-COMMIT-COUNTER.         
      *                                                                         
       0400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 08610000
      *                                                                 08620000
      * 1000-PROCESS-ACCOUNTS.                                          08630000
      *                                                                 08640000
      * THE PARAGRAPH CONTROLS THE PROCESSING OF THE ACCOUNTS           08641000
      *                                                                 08643000
      ***************************************************************** 08650000
      *                                                                 08660000
       1000-PROCESS-ACCOUNTS.                                           
                                                                        
           PERFORM 7100-OPEN-FINAL-WO-CRSR            THRU 7100-EXIT.   
           PERFORM 7110-FETCH-FINAL-WO-CRSR           THRU 7110-EXIT.   
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE FW-ACCOUNT-NO                TO WS-ACCOUNT-NO        
              PERFORM 5200-CHK-SKIP-ACCTS       THRU 5200-CPD347-EXIT   
              IF PROCESS-ACCT                                           
                 PERFORM 1500-WRITEOFF-ACCTS     THRU 1500-EXIT         
              END-IF                                                    
              PERFORM 7110-FETCH-FINAL-WO-CRSR   THRU 7110-EXIT         
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7120-CLOSE-FINAL-WO-ACTN       THRU 7120-EXIT.       
      *                                                                         
           MOVE 'Y'     TO WS-UPDATE-PROCESSING.                        
           PERFORM 4000-PROCESS-ACTIVE-REC        THRU 4000-EXIT.       
      *                                                                         
           PERFORM 4100-PROCESS-REFORECAST        THRU 4100-EXIT.       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1408-CHECK-WQ-GEN                                              *        
      ******************************************************************        
       1408-CHECK-WQ-GEN.                                               
      *                                                                         
           IF SEB-DATABASE                                              
              MOVE FW-REG-GROUP-CD TO WS-REG-GRP-CD                     
              MOVE FW-SENIOR-FL TO WS-SEN-FL                            
           ELSE                                                         
              MOVE SPACES TO WS-REG-GRP-CD                              
              MOVE SPACES TO WS-SEN-FL                                  
           END-IF.                                                      
      *                                                                         
           MOVE AT-COMPANY-NO  TO WS-COMP-NO.                           
           MOVE WS-WQ-CATEGORY TO WS-CATEGORY-ID.                       
           MOVE WS-PGRMNAME    TO WS-SRCE-PGM-ID.                       
           PERFORM 4900-GET-WQ-GEN-FL THRU 4900-CPD346-EXIT.            
           IF FL-NOT-FOUND AND SEB-DATABASE                             
              MOVE SPACES TO WS-REG-GRP-CD                              
              PERFORM 4900-GET-WQ-GEN-FL THRU 4900-CPD346-EXIT          
           END-IF.                                                      
           IF WS-WQ-GEN-FL = 'Y' OR FL-NOT-FOUND                        
              PERFORM 1409-CREATE-WORK-QUEUE THRU 1409-EXIT             
           END-IF.                                                      
      *                                                                         
       1408-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  14782505
      * 1409-CREATE-WORK-QUEUE*                                                 
      ****************************************************************          
       1409-CREATE-WORK-QUEUE.                                          
      *                                                                         
A04860     INITIALIZE CWS00077-FIELDS.                                  
      *                                                                         
A04860     INITIALIZE   WS-77-COMMENTS.                                 
      *                                                                         
A04860     MOVE WS-ACCOUNT-NBR          TO WS-77-ACCOUNT-NO.            
A04860     MOVE AT-CUSTOMER-NO          TO WS-77-CUSTOMER-NO.           
A04860     MOVE AT-PREMISE-NO           TO WS-77-PREMISE-NO.            
A04860     MOVE AT-LOCAL-OFFICE         TO WS-77-LOCAL-OFFICE.          
A04860     MOVE WS-WQ-CATEGORY          TO WS-77-CATEGORY-ID.           
      *                                                                         
A04860     MOVE WS-COMMENTS-TEXT        TO WS-77-COMMENTS-TEXT.         
A04860     MOVE WS-COMMENTS-LEN         TO WS-77-COMMENTS-LEN.          
      *                                                                         
A04860     MOVE 4 TO WS-77-ROUTE-CATEGORY.                              
A04860     MOVE WS-N                    TO WS-77-PRIORITY.              
A04860     MOVE WS-PROGRAM-DATE         TO WS-PROG-DATE-PT.             
A04860     MOVE WS-PROG-TS              TO WS-77-DATE-CREATED.          
      *                                                                         
A04860     MOVE WS-DEF-NEXT-BUS-DAY     TO WS-77-DATE-REQUIRED.         
A04860     MOVE PROGRAM-NAME            TO WS-77-CREATED-BY.            
      *                                                                         
           PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.               
                                                                        
       1409-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************14825500
      *   1500-WRITEOFF-ACCTS                                          *14825700
      *                                                                *14825800
      * ACCOUNTS READY TO BE CHARGED OFF ARE EVALUATED                 *14825900
      *                                                                *14826200
      * IF THE ACCOUNT FAILS THE TESTS ALL FINAL WRITE-OFF DATES ARE   *        
      * MOVED FORWARD 1 BUSINESS DAY.                                  *        
      ******************************************************************14827100
      *                                                                         
       1500-WRITEOFF-ACCTS.                                             
      *                                                                         
           MOVE FW-ACCOUNT-NO             TO AC-ACCOUNT-NO              
                                             CO-ACCOUNT-NO              
                                             GU-ACCOUNT-NO              
                                             DO-ACCOUNT-NO              
                                             SB-ACCOUNT-NO              
                                             KD-ACCOUNT-NO              
                                             WS-ACCOUNT-NBR.            
           MOVE AT-CODES-DATA-PRESENT     TO WS-CODES-DATA-PRESENT.     
           MOVE AT-COMPANY-NO             TO WS-COMPANY-NO.             
           MOVE AT-BANKRUPTCY-IND         TO WS-BANKRUPTCY-IND.         
      *                                                                         
           MOVE ZEROS                     TO WS-BALANCE-DUE.            
      *                                                                         
           PERFORM 1501-PROCESS-ACCTS-WAITING-WO   THRU 1501-EXIT.      
      *                                                                 14833200
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************14833510
      * 1501-PROCESS-ACCTS-WAITING-WO.                                 *14833530
      *                                                                *14833540
      * THIS MODULES PROCESSES ACCOUNTS THAT ARE READY TO BE WRITTEN   *14833550
      * OFF.  IF VALIDATIONS ARE PASSED, THE ACCOUNT IS SENT FOR WRITE *14833560
      * OFF AND AN FA04 RECORD IS WRITTEN WITH THE WRITE-OFF FLAG SET. *14833570
      ******************************************************************14833590
      *                                                                 14833500
       1501-PROCESS-ACCTS-WAITING-WO.                                   
      *                                                                         
           PERFORM 1502-CHECK-INVALID-ACCOUNTS  THRU 1502-EXIT.         
      *                                                                         
           IF WS-ACCT-ELIG-FOR-CHG-OFF = WS-Y                           
               PERFORM 2800-PROCESS-CALC-WO-TOT THRU 2800-EXIT          
           ELSE                                                         
               PERFORM 2810-BUMP-WRITEOFF-DT    THRU 2810-EXIT          
           END-IF.                                                      
      *                                                                 18599800
           IF WS-NOW-PROCESS-WO = 'Y'                                   
               PERFORM 2000-CONTROL-CHARGE-OFFS THRU 2000-EXIT          
           END-IF.                                                      
      *                                                                         
           MOVE SPACES TO WS-NOW-PROCESS-WO                             
                          WS-RECEIVABLES-EXIST.                         
      *                                                                         
           ADD 1                  TO WS-RECS-TO-COMMIT-COUNTER.         
           IF WS-RECS-TO-COMMIT-COUNTER > WS-READY-TO-COMMIT-COUNT      
              PERFORM 0400-PREPARE-COMMIT   THRU 0400-EXIT              
           END-IF.                                                      
      *                                                                         
       1501-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************14833510
      * 1502-CHECK-INVALID-ACCOUNTS.                                   *14833530
      *                                                                *14833540
      * THIS MODULES PERFORMS VALIDATIONS TO MAKE SURE THE ACCOUNT     *14833550
      * IS READY FOR WRITE-OFF.  FOR EACH VALIDATION THAT IS FAILED    *14833560
      * A WORK QUEUE IS PRODUCED AND THE WS-ACCT-ELIG-FOR-CHG-OFF      *14833570
      * FLAG IS SET TO NO, AND FINALLY THE CHARGE OFF DATE IS RECALC   *14833571
      * FOR THE NEXT WORKING DAY, FIRST CREDIT LETTER DATE IS SET TO   *14833580
      * THE NEXT WORKING DAY AFTER ITS DATE, SECOND CREDIT LETTER DATE *        
      * IS SET TO THE NEXT WORKING DAY AFTER ITS DATE, CREDIT BUREAU   *        
      * REPORT DATE IS SET TO THE NEXT WORKING DAY AFTER ITS DATE,     *        
      * COLLECTION AGENCY DATE IS SET TO THE NEXT WORKING DAY AFTER    *        
      * ITS DATE.                                                      *        
      ******************************************************************14833590
       1502-CHECK-INVALID-ACCOUNTS.                                     
      *                                                                 14833700
           MOVE WS-Y                    TO WS-ACCT-ELIG-FOR-CHG-OFF.    
      *                                                                 14833900
           PERFORM 1560-CHK-FOR-NON-REFUNDED-DEP      THRU 1560-EXIT.   
      *                                                                 14834100
           PERFORM 1570-CHK-FOR-ACT-GUAR              THRU 1570-EXIT.   
      *                                                                 14834300
           PERFORM 1580-CHK-FOR-ACT-SURETY-BOND       THRU 1580-EXIT.   
      *                                                                 14834500
           PERFORM 1590-CHK-FOR-INVALID-RCVBLES       THRU 1590-EXIT.   
      *                                                                 14834500
           PERFORM 1595-CHK-FOR-CREDIT-RCVBLES        THRU 1595-EXIT.   
      *                                                                 14834700
       1502-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************14847710
      * 1560-CHK-FOR-NON-REFUNDED-DEP                                  *14847712
      *                                                                *14847713
      * IF A NON-REFUNDED DEPOSIT IS FOUND ON THE ACCOUNT, A WORK      *14847720
      * QUEUE IS PRODUCED AND THE ACCOUNT IS MARKED INELIGIBLE FOR     *14847730
      * WRITE-OFF.                                                     *14847740
      ******************************************************************14847750
       1560-CHK-FOR-NON-REFUNDED-DEP.                                   
      *                                                                 14848400
           MOVE WS-N                  TO WS-NON-REFUNDED-DEP-EXISTS.    
      *                                                                 14848600
           PERFORM 7443-SELECT-NON-REFUNDED-DEP       THRU  7443-EXIT.  
           IF NON-REFUNDED-DEP-EXISTS                                   
              INITIALIZE WS-COMMENTS                                    
              MOVE WS-N              TO WS-ACCT-ELIG-FOR-CHG-OFF        
              MOVE 116               TO WS-WQ-CATEGORY                  
              PERFORM 1408-CHECK-WQ-GEN THRU 1408-EXIT                  
           END-IF.                                                      
      *                                                                 14849300
       1560-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14849600
      ******************************************************************14849610
      * 1570-CHK-FOR-ACT-GUAR                                          *14849612
      *                                                                *14849613
      * IF AN ACTIVE GUARANTOR EXISTS ON THE ACCOUNT, A WORK QUEUE     *14849620
      * IS PRODUCED AND THE ACCOUNT IS MARKED INELIGIBLE FOR WRITE-OFF.*14849630
      ******************************************************************14849640
       1570-CHK-FOR-ACT-GUAR.                                           
      *                                                                 14850200
           MOVE WS-N                  TO WS-GUARANTOR-EXISTS.           
           PERFORM 7445-SELECT-ACT-GUAR               THRU  7445-EXIT.  
      *                                                                 14850500
           IF GUARANTOR-EXISTS                                          
              MOVE WS-N              TO WS-ACCT-ELIG-FOR-CHG-OFF        
              INITIALIZE WS-COMMENTS                                    
              MOVE 45                TO WS-WQ-CATEGORY                  
              PERFORM 1408-CHECK-WQ-GEN THRU 1408-EXIT                  
           END-IF.                                                      
      *                                                                 14851100
       1570-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14851400
      ******************************************************************14851410
      * 1580-CHK-FOR-ACT-SURETY-BOND                                   *14851412
      *                                                                *14851413
      * IF AN ACTIVE SURETY BOND EXISTS ON THE ACCOUNT, A WORK QUEUE   *14851420
      * IS PRODUCED AND THE ACCOUNT IS MARKED INELIGIBLE FOR WRITE-OFF.*14851430
      ******************************************************************14851440
       1580-CHK-FOR-ACT-SURETY-BOND.                                    
      *                                                                 14852000
           MOVE WS-N                  TO WS-SURETY-BOND-EXISTS.         
      *                                                                 14852200
           PERFORM 7447-SELECT-ACTIVE-SURETY-BOND     THRU  7447-EXIT.  
           IF SURETY-BOND-EXISTS                                        
              INITIALIZE WS-COMMENTS                                    
              MOVE WS-N              TO WS-ACCT-ELIG-FOR-CHG-OFF        
              MOVE 115               TO WS-WQ-CATEGORY                  
              PERFORM 1408-CHECK-WQ-GEN THRU 1408-EXIT                  
           END-IF.                                                      
      *                                                                 14852900
       1580-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14852900
      *                                                                 14853200
      ******************************************************************14853210
      * 1590-CHK-FOR-INVALID-RCVBLES                                   *14853212
      *                                                                *14853213
      * IF AN ACCOUNT HAS MONEY IN EPP, DEP, DFA, AND/OR PJS           *14853220
      * RECEIVABLE(S) THE ACCOUNT A WORK QUEUE IS PRODUCED AND THE     *14853230
      * ACCOUNT IS MARKED INELIGIBLE FOR WRITE-OFF AT THIS TIME.       *14853240
      ******************************************************************14853250
       1590-CHK-FOR-INVALID-RCVBLES.                                    
      *                                                                 14853900
           PERFORM 7465-PERFORM-INVALID-RCVBLES THRU  7465-EXIT.        
                                                                        
           IF WS-TOT-INV-RCVBLE > ZERO                                  
              INITIALIZE WS-COMMENTS                                    
              MOVE 91                    TO WS-COMMENTS-LEN             
              STRING 'UNABLE TO WRITE OFF ACCOUNT DUE TO INELIGIBLE '   
                'RECEIVABLE OF BBP, CIA, DEP, DFA, DPP, OR PJS'         
              DELIMITED BY SIZE INTO WS-COMMENTS-TEXT                   
              MOVE WS-N                  TO WS-ACCT-ELIG-FOR-CHG-OFF    
              MOVE 46                    TO WS-WQ-CATEGORY              
              PERFORM 1408-CHECK-WQ-GEN THRU 1408-EXIT                  
           END-IF.                                                      
      *                                                                 14854600
       1590-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14853200
      ******************************************************************14853210
      * 1595-CHK-FOR-CREDIT-RCVBLES                                    *14853212
      *                                                                *14853213
      * IF AN ACCOUNT HAS ANY CREDIT RECEIVABLE(S)                     *14853220
      * THEN A WORK QUEUE IS PRODUCED AND THE ACCOUNT IS MARKED        *14853230
      * INELIGIBLE FOR WRITE-OFF AT THIS TIME.                         *14853240
      ******************************************************************14853250
       1595-CHK-FOR-CREDIT-RCVBLES.                                     
      *                                                                 14853900
           PERFORM 7470-PERFORM-CREDIT-RCVBLES        THRU  7470-EXIT.  
ACT117     IF WS-AMT-TRAN-BALANCE < 0.00                                
ACT117        MOVE WS-N           TO WS-ACCT-ELIG-FOR-CHG-OFF           
ACT117        IF ( WS-AMT-TRAN-BALANCE < -1.00 AND CSR-DATABASE ) OR    
ACT117           ( WS-AMT-TRAN-BALANCE < 0.00 AND SEB-DATABASE )        
ACT117           INITIALIZE WS-COMMENTS                                 
ACT117           MOVE 194               TO WS-WQ-CATEGORY               
ACT117           MOVE WS-AMT-TRAN-BALANCE TO WS-CREDIT-AMOUNT           
ACT117           MOVE WS-CREDIT-RCVBLES TO WS-COMMENTS-TEXT             
ACT117           MOVE +111              TO WS-COMMENTS-LEN              
ACT117           PERFORM 1408-CHECK-WQ-GEN THRU 1408-EXIT               
ACT117        END-IF                                                    
ACT117     END-IF.                                                      
      *                                                                 14854600
       1595-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00285500
      **                                                            **  00286000
      **    2000-CONTROL-CHARGE-OFFS                                **  00286500
      **        PERFORMS MAIN PROCESSING OF CHARGE-OFFS             **  00287000
      **                                                            **  00287000
      ****************************************************************  00287500
       2000-CONTROL-CHARGE-OFFS.                                        
      *                                                                         
           INITIALIZE DCLCSS-AR-TRN-HST-DET.                            
           MOVE ' '                    TO WS-CALLED-PGM-RC.             
           MOVE FW-ACCOUNT-NO          TO WS-ACCOUNT-NBR                
                                          AT-ACCOUNT-NO.                
                                                                        
           MOVE AT-CODES-DATA-PRESENT  TO WS-CODES-DATA-PRESENT.        
           MOVE AT-TOTAL-AR-BALANCE    TO WS-TOTAL-AR-BALANCE.          
           MOVE AT-CUSTOMER-NO         TO WS-CUSTOMER-NO.               
           MOVE AT-PREMISE-NO          TO WS-PREMISE-NO.                
           MOVE 'N'                    TO WS-OTHER-RECV.                
      *                                                                         
           IF WS-PREMISE-NO EQUAL ZEROES                                
               MOVE SPACE              TO WS-CODE-PREMISE-STAT          
           END-IF.                                                      
      *                                                                         
           MOVE ZERO                   TO WS-CHG-OFF-ACCT-TOTAL.        
           MOVE WS-YES                 TO WS-CHARGE-OFF-COMPLETE.       
      *                                                                         
           IF WS-FST-TIME = 'Y'                                         
              PERFORM 2010-LOAD-VALUES THRU 2010-EXIT                   
           END-IF.                                                      
                                                                        
      *                                                                         
           IF CSR-DATABASE                                              
              IF AT-COMPANY-NO      = '01'                              
                 MOVE WS-AMT-CREDIT-LPC-WO-01 TO                        
                      WS-AMT-CREDIT-LPC-WO                              
              ELSE                                                      
                 IF AT-COMPANY-NO      = '26'                           
                    MOVE WS-AMT-CREDIT-LPC-WO-26 TO                     
                         WS-AMT-CREDIT-LPC-WO                           
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
           IF SEB-DATABASE                                              
              PERFORM 7681-CHECK-REG-DEREG-ACCT THRU 7681-EXIT          
              IF REGULATED AND (WS-DEL-VAL-SEB = 2 OR 3)                
                 PERFORM 3010-CHECK-FOR-LPC-ONLY THRU 3010-EXIT         
                 IF WS-CALLED-PGM-BAD-RC                                
                    GO TO 2000-EXIT                                     
                 END-IF                                                 
                 IF WS-CSR02294-PROCESS = 'Y'                           
                    MOVE SPACES TO  WS-CSR02294-PROCESS                 
                    DISPLAY 'LPC CREDITED ON ACCT. ' WS-ACCOUNT-NBR     
                    PERFORM 8020-UPD-PROCESS-FLAG  THRU 8020-EXIT       
                    GO TO 2000-EXIT                                     
                 END-IF                                                 
              END-IF                                                    
              IF DEREGULATED AND (WS-DEL-VAL-SEB = 1 OR 3)              
                 PERFORM 3010-CHECK-FOR-LPC-ONLY THRU 3010-EXIT         
                 IF WS-CALLED-PGM-BAD-RC                                
                    GO TO 2000-EXIT                                     
                 END-IF                                                 
                 IF WS-CSR02294-PROCESS = 'Y'                           
                    MOVE SPACES TO  WS-CSR02294-PROCESS                 
                    DISPLAY 'LPC CREDITED ON ACCT. ' WS-ACCOUNT-NBR     
                    PERFORM 8020-UPD-PROCESS-FLAG  THRU 8020-EXIT       
                    GO TO 2000-EXIT                                     
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF CSR-DATABASE                                              
              IF AT-COMPANY-NO      = '01' AND WS-DEL-VAL-CSR01 = 1     
                  PERFORM 3010-CHECK-FOR-LPC-ONLY THRU 3010-EXIT        
                  IF WS-CALLED-PGM-BAD-RC                               
                     GO TO 2000-EXIT                                    
                  END-IF                                                
                  IF WS-CSR02294-PROCESS = 'Y'                          
                     MOVE SPACES TO  WS-CSR02294-PROCESS                
                     DISPLAY 'LPC CREDITED ON ACCT. ' WS-ACCOUNT-NBR    
                     PERFORM 8020-UPD-PROCESS-FLAG  THRU 8020-EXIT      
                     GO TO 2000-EXIT                                    
                  END-IF                                                
              ELSE                                                      
                 IF AT-COMPANY-NO      = '26' AND WS-DEL-VAL-CSR26 = 1  
                    PERFORM 3010-CHECK-FOR-LPC-ONLY THRU 3010-EXIT      
                    IF WS-CALLED-PGM-BAD-RC                             
                       GO TO 2000-EXIT                                  
                    END-IF                                              
                    IF WS-CSR02294-PROCESS = 'Y'                        
                       MOVE SPACES TO  WS-CSR02294-PROCESS              
                       DISPLAY 'LPC CREDITED ON ACCT. ' WS-ACCOUNT-NBR  
                       PERFORM 8020-UPD-PROCESS-FLAG  THRU 8020-EXIT    
                       GO TO 2000-EXIT                                  
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 3405-FMT-AR-TRANS-HDR        THRU 3405-EXIT          
      *                                                                         
           MOVE WS-W              TO AR-CODE-TRAN-TYPE.                 
           MOVE WS-WO-TOTAL       TO AR-AMT-ORIG-ENTERED.               
           IF AT-CODE-ACCT-STAT = 'B'                                   
               MOVE ZEROS                    TO AU-CODE-AR-AGE          
           ELSE                                                         
               MOVE SPACES                   TO AU-CODE-AR-AGE          
           END-IF.                                                      
           MOVE ZEROS                        TO AU-AMT-POSTED.          
      *                                                                         
           MOVE ZERO                   TO WS-JRNL-TRAN-APPL-NO          
                                          WS-PREV-TRAN-APPL-NO          
                                          WS-BATCH-TRAN-APPL-NO.        
      *                                                                         
           PERFORM 7603-OPEN-CUST-RECEIVABLES    THRU 7603-EXIT.        
           PERFORM 7613-FETCH-CUST-RECEIVABLES   THRU 7613-EXIT.        
      *                                                                         
           SET WS-WO-REC-INDX TO +1.                                    
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
              PERFORM 3100-CNTRL-AR-PROCESSING       THRU 3100-EXIT     
              IF WS-CALLED-PGM-BAD-RC                                   
                 PERFORM 7623-CLOSE-CUST-RECEIVABLES THRU 7623-EXIT     
                 GO TO 2000-EXIT                                        
              END-IF                                                    
              IF  WS-ZERO-CNT-WO-GL                                     
                 PERFORM 7623-CLOSE-CUST-RECEIVABLES THRU 7623-EXIT     
                 GO TO 2000-EXIT                                        
              END-IF                                                    
      *                                                                         
              PERFORM 7613-FETCH-CUST-RECEIVABLES    THRU 7613-EXIT     
      *                                                                         
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7623-CLOSE-CUST-RECEIVABLES      THRU 7623-EXIT.     
      *                                                                         
           PERFORM 3500-PROCESS-TRANS-DETAIL        THRU 3500-EXIT.     
           MOVE WS-INPUT-DATE TO WS-TEMP-DATE.                          
      *                                                                         
           MOVE 'WO'          TO WS-ACTION-TYPE-CD.                     
           PERFORM 8510-UPD-FINAL-WO-AMT            THRU 8510-EXIT.     
      *                                                                         
           PERFORM 3510-CONTROL-ADDL-PROCESSING     THRU 3510-EXIT.     
      *                                                                         
           PERFORM 5000-UPDATE-ACCOUNT              THRU 5000-EXIT.     
      *                                                                         
           PERFORM 2100-FORECAST-WO-ACTIONS         THRU 2100-EXIT.     
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00365000
                                                                        
      ******************************************************************        
      * 2010-LOAD-VALUES                                               *        
      ******************************************************************        
       2010-LOAD-VALUES.                                                
      *                                                                         
           IF SEB-DATABASE                                              
              MOVE 'WO-LPC-CREDIT-SW' TO C8-DELINQ-CD                   
              MOVE AT-COMPANY-NO      TO C8-COMPANY-NO                  
              PERFORM 7160-SELECT-DELINQ-VALUE     THRU 7160-EXIT       
              MOVE WS-C8-DELINQ-VALUE TO WS-DEL-VAL-SEB                 
              MOVE 'AM-CRED-LPC-WO'       TO C8-DELINQ-CD               
              MOVE AT-COMPANY-NO          TO C8-COMPANY-NO              
              PERFORM 7160-SELECT-DELINQ-VALUE THRU 7160-EXIT           
              MOVE WS-C8-DELINQ-VALUE     TO WS-AMT-CREDIT-LPC-WO       
              MOVE 'N' TO WS-FST-TIME                                   
           END-IF.                                                      
      *                                                                         
           IF CSR-DATABASE                                              
              MOVE 'WO-LPC-CREDIT-SW' TO C8-DELINQ-CD                   
              MOVE WS-COMPANY-NO-01   TO C8-COMPANY-NO                  
              PERFORM 7160-SELECT-DELINQ-VALUE     THRU 7160-EXIT       
              MOVE WS-C8-DELINQ-VALUE TO WS-DEL-VAL-CSR01               
      *                                                                         
              MOVE 'AM-CRED-LPC-WO'       TO C8-DELINQ-CD               
              MOVE WS-COMPANY-NO-01       TO C8-COMPANY-NO              
              PERFORM 7160-SELECT-DELINQ-VALUE THRU 7160-EXIT           
              MOVE WS-C8-DELINQ-VALUE     TO WS-AMT-CREDIT-LPC-WO-01    
      *                                                                         
              MOVE 'PCT-ELEC-RCC-ALLOC'   TO C8-DELINQ-CD               
              MOVE WS-COMPANY-NO-01       TO C8-COMPANY-NO              
              PERFORM 7160-SELECT-DELINQ-VALUE THRU 7160-EXIT           
              MOVE WS-C8-DELINQ-VALUE     TO C8-DELINQ-VALUE            
      *                                                                         
              MOVE 'WO-LPC-CREDIT-SW' TO C8-DELINQ-CD                   
              MOVE WS-COMPANY-NO-26   TO C8-COMPANY-NO                  
              PERFORM 7160-SELECT-DELINQ-VALUE     THRU 7160-EXIT       
              MOVE WS-C8-DELINQ-VALUE TO WS-DEL-VAL-CSR26               
      *                                                                         
              MOVE 'AM-CRED-LPC-WO'       TO C8-DELINQ-CD               
              MOVE WS-COMPANY-NO-26       TO C8-COMPANY-NO              
              PERFORM 7160-SELECT-DELINQ-VALUE THRU 7160-EXIT           
              MOVE WS-C8-DELINQ-VALUE     TO WS-AMT-CREDIT-LPC-WO-26    
      *                                                                         
              MOVE 'N' TO WS-FST-TIME                                   
           END-IF.                                                      
      *                                                                         
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-FORECAST-WO-ACTIONS                                       *        
      ******************************************************************        
       2100-FORECAST-WO-ACTIONS.                                        
      *                                                                         
           PERFORM 7685-GET-MAX-OF-SEQ-NO           THRU 7685-EXIT.     
      *                                                                         
           PERFORM 7676-GET-PATH-TYPE-CODE          THRU 7676-EXIT.     
           MOVE FW-FW-PATH-TYPE-CD  TO WS-FW-PATH-TYPE-CD.              
           MOVE WS-FW-SEQ-NO        TO KD-FW-SEQ-NO.                    
                                                                        
           IF SEB-DATABASE                                              
              MOVE FW-REG-GROUP-CD TO LR-REG-GROUP-CD                   
           ELSE                                                         
              MOVE SPACES           TO   LR-REG-GROUP-CD                
           END-IF.                                                      
                                                                        
           MOVE 'Y'                      TO WS-FST-OCCUR.               
           MOVE 'N'                      TO WS-SEQ-MATCH.               
           INITIALIZE WS-WO-SEQ-NO-MAX                                  
                      WS-F8-SEQ-NO-CHECK.                               
      *                                                                         
           MOVE 'WO'                         TO WS-ACTION-TYPE-CD.      
           PERFORM 7770-GET-WO-SEQ-FROM-FCST-ACTN THRU 7770-EXIT.       
           MOVE F8-FW-ACTION-SEQ-NO          TO WS-F8-SEQ-NO-CHECK.     
           PERFORM 7780-GET-MAX-OF-WO-SEQ-NO THRU 7780-EXIT.            
                                                                        
           IF WS-WO-SEQ-NO-MAX = WS-F8-SEQ-NO-CHECK                     
              MOVE 'Y' TO WS-SEQ-MATCH                                  
           ELSE                                                         
              MOVE 'N' TO WS-SEQ-MATCH                                  
           END-IF.                                                      
      *                                                                         
           PERFORM VARYING WS-FIN-INDX FROM 1 BY 1                      
             UNTIL WS-FIN-INDX > 4000 OR                                
             WS-COMPANY-NO-F8-TBL(WS-FIN-INDX) = SPACES                 
                IF WS-COMPANY-NO-F8-TBL(WS-FIN-INDX)                    
                                      = AT-COMPANY-NO      AND          
                   WS-REG-GROUP-CD-F8-TBL(WS-FIN-INDX)                  
                                      = LR-REG-GROUP-CD    AND          
                   WS-FW-PATH-TYPE-CD-F8-TBL(WS-FIN-INDX)               
                                      = WS-FW-PATH-TYPE-CD AND          
                   WS-FW-FRCST-TIME-CD-F8(WS-FIN-INDX) = 'W'            
      *                                                                         
                   PERFORM  5500-FORECAST-ACTIONS                       
                      THRU  5500-EXIT                                   
                END-IF                                                  
      *                                                                         
           END-PERFORM.                                                 
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************14825400
      *2800-PROCESS-CALC-WO-TOT.                                                
      *  CHECK RECEIVABLES                                                      
      ******************************************************************        
       2800-PROCESS-CALC-WO-TOT.                                        
      *                                                                         
           INITIALIZE WS-WO-TOTAL.                                      
      *                                                                         
           PERFORM 7603-OPEN-CUST-RECEIVABLES         THRU 7603-EXIT.   
      *                                                                         
           PERFORM 7613-FETCH-CUST-RECEIVABLES        THRU 7613-EXIT.   
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
      *                                                                         
               IF (AC-PYMT-PRIORITY-LVL < +50)                          
                 OR ((AC-PYMT-PRIORITY-LVL >= +50)                      
                     AND (AC-ITEM-ID NOT EQUAL 0))                      
      *                                                                         
                   ADD AC-AMT-AR-DAY-00,                                
                       AC-AMT-AR-DAY-30,                                
                       AC-AMT-AR-DAY-60,                                
                       AC-AMT-AR-DAY-90,                                
                       AC-AMT-UNUSED-CR       TO WS-WO-TOTAL            
               END-IF                                                   
      *                                                                         
               PERFORM 7613-FETCH-CUST-RECEIVABLES    THRU 7613-EXIT    
      *                                                                         
           END-PERFORM.                                                 
           PERFORM 7623-CLOSE-CUST-RECEIVABLES        THRU 7623-EXIT.   
      *                                                                         
           IF WS-WO-TOTAL NOT EQUAL AT-TOTAL-AR-BALANCE                 
              INITIALIZE WS-COMMENTS                                    
              MOVE 45                    TO WS-COMMENTS-LEN             
              STRING 'RECEIVABLES BALANCE DOES NOT MATCH AR BALANCE'    
              DELIMITED BY SIZE INTO WS-COMMENTS-TEXT                   
              MOVE WS-N                  TO WS-ACCT-ELIG-FOR-CHG-OFF    
              MOVE 545                   TO WS-WQ-CATEGORY              
              PERFORM 1408-CHECK-WQ-GEN THRU 1408-EXIT                  
              PERFORM 2810-BUMP-WRITEOFF-DT  THRU 2810-EXIT             
           ELSE                                                         
              PERFORM 7300-RECEIVABLES-CHECK     THRU 7300-EXIT         
              IF WS-RECEIVABLES-EXIST = 'Y'                             
                 MOVE 'Y' TO WS-NOW-PROCESS-WO                          
              ELSE                                                      
                 IF AT-TOTAL-AR-BALANCE <= 0                            
                   PERFORM 8020-UPD-PROCESS-FLAG THRU 8020-EXIT         
                 ELSE                                                   
                     INITIALIZE WS-COMMENTS                             
                     MOVE 42                    TO WS-COMMENTS-LEN      
                    STRING 'NO RECEIVABLES ON ACCT BUT ACCT BALANCE > 0'
                     DELIMITED BY SIZE INTO WS-COMMENTS-TEXT            
                     MOVE WS-N          TO WS-ACCT-ELIG-FOR-CHG-OFF     
                     MOVE 544               TO WS-WQ-CATEGORY           
                     PERFORM 1408-CHECK-WQ-GEN THRU 1408-EXIT           
                     PERFORM 2810-BUMP-WRITEOFF-DT  THRU 2810-EXIT      
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 2810-BUMP-WRITEOFF-DT                                                   
      *                                                                *        
      * LOAD VALUES FOR CALLING CPD00337 TO GET WO LIMITS              *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       2810-BUMP-WRITEOFF-DT.                                           
      *                                                                         
           MOVE 'WO'                   TO F8-FW-BUS-PROCESS-CD.         
           MOVE WS-INPUT-DATE          TO WS-CWS337-PROCESS-DATE.       
           MOVE AT-COMPANY-NO          TO WS-FW-COMPANY.                
           MOVE FW-REG-GROUP-CD        TO WS-REG-GROUP-CD.              
           MOVE 'DE'                   TO WS-FW-PATH-TYPE-CD.           
           MOVE 'WODFR'                TO WS-FW-ACTION-TYPE-CD.         
      *                                                                         
           PERFORM 5100-GET-FCST-ACTN-DATA    THRU 5100-CPD337-EXIT.    
           PERFORM 5150-VERIFY-DW-VARIABLES   THRU 5150-EXIT.           
           MOVE WS-FW-FCST-DAYS-NM     TO WS-DAYS-TO-BUMP.              
      *                                                                         
           MOVE KD-FW-ACTION-DT        TO WS-NEW-BUSINESS-DAY.          
           MOVE WS-DAYS-TO-BUMP        TO WS-NO-OF-DAY.                 
           PERFORM 6500-GET-NEXT-BUSINESS-DAY                           
              THRU 6500-NEXT-BUSINESS-DAY-EXIT.                         
      *                                                                         
           IF WS-NEW-BUSINESS-DAY >= WS-INPUT-DATE                      
              MOVE WS-NEW-BUSINESS-DAY    TO KD-FW-ACTION-DT            
           ELSE                                                         
              MOVE WS-DEF-NEXT-BUS-DAY    TO KD-FW-ACTION-DT            
           END-IF.                                                      
      *                                                                         
           PERFORM 8030-BUMP-WRITEOFF-DT THRU 8030-EXIT.                
      *                                                                         
                                                                        
       2810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  14782505
      * 3010-CHECK-FOR-LPC-ONLY                                                 
      ****************************************************************          
       3010-CHECK-FOR-LPC-ONLY.                                         
      *                                                                         
           PERFORM  7210-CHK-OTHER-RECEIVABLES    THRU 7210-EXIT.       
           IF WS-OTHER-RECV = 'Y'                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 3015-SUM-LPC-LPN            THRU 3015-EXIT        
              COMPUTE WS-TOTAL-LPC = WS-LPC-AMT + WS-LPN-AMT            
              PERFORM 7235-GET-LPC-CHRGED         THRU 7235-EXIT        
              EVALUATE TRUE                                             
                 WHEN WS-TOTAL-LPC <= KD-FW-ACTION-AM                   
                    IF WS-LPC-AMT > 0                                   
                       MOVE +30                   TO                    
                                            AC-PYMT-PRIORITY-LVL        
                       INITIALIZE  WS-INPUT-PARM                        
                       MOVE WS-LPC TO PARM-RECV-TYPE                    
                       MOVE WS-AC-LAST-UPDATE-TS1 TO AC-LAST-UPDATE-TS  
                       MOVE WS-00-DAY-LPC         TO AC-AMT-AR-DAY-00   
                       MOVE WS-30-DAY-LPC         TO AC-AMT-AR-DAY-30   
                       MOVE WS-60-DAY-LPC         TO AC-AMT-AR-DAY-60   
                       MOVE WS-90-DAY-LPC         TO AC-AMT-AR-DAY-90   
                       PERFORM 3020-CREDIT-LPC       THRU 3020-EXIT     
                    END-IF                                              
      *                                                                         
                    IF WS-LPN-AMT > 0                                   
                       MOVE +39                      TO                 
                                           AC-PYMT-PRIORITY-LVL         
                       INITIALIZE  WS-INPUT-PARM                        
                       MOVE WS-LPN TO PARM-RECV-TYPE                    
                       MOVE WS-AC-LAST-UPDATE-TS2 TO AC-LAST-UPDATE-TS  
                       MOVE WS-00-DAY-LPN         TO AC-AMT-AR-DAY-00   
                       MOVE WS-30-DAY-LPN         TO AC-AMT-AR-DAY-30   
                       MOVE WS-60-DAY-LPN         TO AC-AMT-AR-DAY-60   
                       MOVE WS-90-DAY-LPN         TO AC-AMT-AR-DAY-90   
                       PERFORM 3020-CREDIT-LPC       THRU 3020-EXIT     
                    END-IF                                              
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                         
       3010-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  14782505
      * 3015-SUM-LPC-LPN.                                                       
      ****************************************************************          
       3015-SUM-LPC-LPN.                                                
           INITIALIZE WS-LPC-NULL-IND                                   
                      WS-TS-NULL-IND                                    
                      WS-LPC-AMT.                                       
      *                                                                         
           MOVE +30 TO WS-PYMT-PRIORITY-LVL.                            
           PERFORM 7220-SUM-LPC-AMT        THRU 7220-EXIT.              
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE ZERO TO WS-LPC-AMT                                   
                           AC-LAST-UPDATE-TS                            
           ELSE                                                         
              MOVE WS-LPC-LPN        TO WS-LPC-AMT                      
              MOVE AC-AMT-AR-DAY-00  TO WS-00-DAY-LPC                   
              MOVE AC-AMT-AR-DAY-30  TO WS-30-DAY-LPC                   
              MOVE AC-AMT-AR-DAY-60  TO WS-60-DAY-LPC                   
              MOVE AC-AMT-AR-DAY-90  TO WS-90-DAY-LPC                   
              MOVE AC-LAST-UPDATE-TS TO WS-AC-LAST-UPDATE-TS1           
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-LPC-NULL-IND                                   
                      WS-TS-NULL-IND                                    
                      WS-LPC-LPN.                                       
      *                                                                         
           MOVE +39 TO WS-PYMT-PRIORITY-LVL.                            
           PERFORM 7220-SUM-LPC-AMT        THRU 7220-EXIT               
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE ZERO TO WS-LPN-AMT                                   
                           AC-LAST-UPDATE-TS                            
           ELSE                                                         
              MOVE WS-LPC-LPN        TO WS-LPN-AMT                      
              MOVE AC-AMT-AR-DAY-00  TO WS-00-DAY-LPN                   
              MOVE AC-AMT-AR-DAY-30  TO WS-30-DAY-LPN                   
              MOVE AC-AMT-AR-DAY-60  TO WS-60-DAY-LPN                   
              MOVE AC-AMT-AR-DAY-90  TO WS-90-DAY-LPN                   
              MOVE AC-LAST-UPDATE-TS TO WS-AC-LAST-UPDATE-TS2           
           END-IF.                                                      
      *                                                                         
       3015-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *  PERFORM 3020-CREDIT-LPC                                       *        
      ******************************************************************        
       3020-CREDIT-LPC.                                                 
      *                                                                         
           MOVE '3020'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS                                 
                      DCLCSS-CONTRACT                                   
                      DCLCSS-CNT-DETAIL                                 
                      PARM-FIELDS-REDEFINITION.                         
      *                                                                         
           MOVE  WS-ACCOUNT-NBR          TO PARM-ACCOUNT-NO-X-TEMP      
           MOVE  AC-ITEM-ID              TO PARM-ITEM-ID                
           MOVE  AC-PYMT-PRIORITY-LVL    TO PARM-PYMT-PRIORITY-LVL      
      *                                                                         
           IF PARM-RECV-TYPE = WS-LPC                                   
              IF AT-COMPANY-NO = '26' OR SEB-DATABASE                   
                 MOVE WS-GREV-LPC-RED(WS-GL-SUB)                        
                                           TO PARM-DB-GL-NUMBER-X-TEMP  
              ELSE                                                      
                 MOVE WS-EREV-LPC-RED(WS-GL-SUB)                        
                                           TO PARM-DB-GL-NUMBER-X-TEMP  
              END-IF                                                    
           ELSE                                                         
              MOVE  WS-REV-LPN-RED(WS-GL-SUB)                           
                                         TO PARM-DB-GL-NUMBER-X-TEMP    
           END-IF                                                       
      *                                                                         
           MOVE  AC-AMT-AR-DAY-00        TO PARM-CR-AMT-AR-DAY-00-N     
           MOVE  PARM-CR-AMT-AR-DAY-00-N1                               
                                         TO PARM-CR-AMT-AR-DAY-00-X-TEMP
           MOVE  AC-AMT-AR-DAY-30        TO PARM-CR-AMT-AR-DAY-30-N     
           MOVE  PARM-CR-AMT-AR-DAY-30-N1                               
                                         TO PARM-CR-AMT-AR-DAY-30-X-TEMP
           MOVE  AC-AMT-AR-DAY-60        TO PARM-CR-AMT-AR-DAY-60-N     
           MOVE  PARM-CR-AMT-AR-DAY-60-N1                               
                                         TO PARM-CR-AMT-AR-DAY-60-X-TEMP
           MOVE  AC-AMT-AR-DAY-90        TO PARM-CR-AMT-AR-DAY-90-N     
           MOVE  PARM-CR-AMT-AR-DAY-90-N1                               
                                         TO PARM-CR-AMT-AR-DAY-90-X-TEMP
           IF PARM-RECV-TYPE = WS-LPC                                   
               MOVE WS-LPC-AMT           TO PARM-CR-AMT-AR-TOTAL-N      
           ELSE                                                         
               MOVE WS-LPN-AMT           TO PARM-CR-AMT-AR-TOTAL-N      
           END-IF                                                       
           MOVE  PARM-CR-AMT-AR-TOTAL-N1 TO PARM-CR-AMT-AR-TOTAL-X-TEMP 
           MOVE  'UND'                   TO PARM-DIST-RECV-TYPE         
           MOVE  AC-PYMT-PRIORITY-LVL    TO PARM-DIST-PYMT-PRI-LVL      
           MOVE  AC-ITEM-ID              TO PARM-DIST-ITEM-ID           
           MOVE  SPACES                  TO PARM-RESP-AREA              
           MOVE  'SYSTEM'                TO PARM-USER-ID                
           MOVE  AT-LAST-UPDATE-TS       TO PARM-AT-LAST-UPDATE-TS      
           MOVE  AC-LAST-UPDATE-TS       TO PARM-AC-LAST-UPDATE-TS      
           MOVE  56                      TO PARM-TRAN-COMNT-LEN         
           MOVE  WS-TRAN-CMNT-CSR02294   TO PARM-TRAN-COMNT-TEXT        
           MOVE  CT-AMT-ORIG-ENTERED     TO PARM-PRINCIPAL-AMT-N        
           MOVE  PARM-PRINCIPAL-AMT-N1   TO PARM-PRINCIPAL-AMT-X-TEMP   
           MOVE  EA-AMT-STATE-TAX        TO PARM-STATE-TAX-AMT-N        
           MOVE  PARM-STATE-TAX-AMT-N1   TO PARM-STATE-TAX-AMT-X-TEMP   
           MOVE  CT-AMT-TAX-CITY         TO PARM-CITY-TAX-AMT-N         
           MOVE  PARM-CITY-TAX-AMT-N1    TO PARM-CITY-TAX-AMT-X-TEMP    
           MOVE  EA-AMT-OTHER-TAX        TO PARM-OTHER-TAX-AMT-N        
           MOVE  PARM-OTHER-TAX-AMT-N1   TO PARM-OTHER-TAX-AMT-X-TEMP   
           MOVE  CT-AMT-DEF-INTEREST     TO PARM-DEF-INT-AMT-N          
           MOVE  PARM-DEF-INT-AMT-N1     TO PARM-DEF-INT-AMT-X-TEMP     
           MOVE  CT-SIMPLE-INT-FIN-CHG   TO PARM-EARNED-INT-AMT-N       
           MOVE  PARM-EARNED-INT-AMT-N1  TO PARM-EARNED-INT-AMT-X-TEMP  
           MOVE  CT-CNT-NAME-CD          TO PARM-CNT-NAME-CD            
           MOVE  WS-REVENUE-MONTH        TO PARM-REVENUE-MONTH-TEMP     
           MOVE   'N'                    TO WS-CSR02294-PROCESS         
           MOVE  SPACE                   TO WS-CALLED-PGM-RC            
      *    EXEC SQL CALL CSR02294                                       
      *                ( :PARM-ACCOUNT-NO-X-TEMP                        
      *                 ,:PARM-ITEM-ID                                  
      *                 ,:PARM-RECV-TYPE                                
      *                 ,:PARM-PYMT-PRIORITY-LVL                        
      *                 ,:PARM-DB-GL-NUMBER-X-TEMP                      
      *                 ,:PARM-CR-AMT-AR-DAY-00-X-TEMP                  
      *                 ,:PARM-CR-AMT-AR-DAY-30-X-TEMP                  
      *                 ,:PARM-CR-AMT-AR-DAY-60-X-TEMP                  
      *                 ,:PARM-CR-AMT-AR-DAY-90-X-TEMP                  
      *                 ,:PARM-CR-AMT-AR-TOTAL-X-TEMP                   
      *                 ,:PARM-DIST-RECV-TYPE                           
      *                 ,:PARM-DIST-PYMT-PRI-LVL                        
      *                 ,:PARM-DIST-ITEM-ID                             
      *                 ,:PARM-RESP-AREA                                
      *                 ,:PARM-USER-ID                                  
      *                 ,:PARM-AT-LAST-UPDATE-TS                        
      *                 ,:PARM-AC-LAST-UPDATE-TS                        
      *                 ,:PARM-TRAN-COMNT-LEN                           
      *                 ,:PARM-TRAN-COMNT-TEXT                          
      *                 ,:PARM-PRINCIPAL-AMT-X-TEMP                     
      *                 ,:PARM-STATE-TAX-AMT-X-TEMP                     
      *                 ,:PARM-CITY-TAX-AMT-X-TEMP                      
      *                 ,:PARM-OTHER-TAX-AMT-X-TEMP                     
      *                 ,:PARM-DEF-INT-AMT-X-TEMP                       
      *                 ,:PARM-EARNED-INT-AMT-X-TEMP                    
      *                 ,:PARM-CNT-NAME-CD                              
      *                 ,:PARM-REVENUE-MONTH-TEMP                       
      *                )                                                
      *    END-EXEC                                                     

MSQ001        EXEC SQL
MSQ001          CLOSE C1
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C1
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C1 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
           IF SQLCODE = +466 THEN                                       
      *       EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE         
      *         CSR02294                                                
      *       END-EXEC                                                  
      *       EXEC SQL ALLOCATE C1 CURSOR FOR RESULT SET :LOC1          
      *       END-EXEC                                                  
              EXEC SQL                                                  
              FETCH C1 INTO :S-RETURN-CODE                              
                           ,:S-CANCELDNP-FLAG                           
                           ,:S-AR-LOCKOUT-IND                           
                           ,:S-XFER-ACCT-NO                             
                           ,:S-CANCELNOT-FLAG                           
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           END-IF.                                                      
           IF S-RETURN-CODE = 0                                         
              MOVE 'Y' TO WS-CSR02294-PROCESS                           
           ELSE                                                         
              IF WS-INDEX-192 < 750                                     
                 ADD 1 TO WS-INDEX-192                                  
                 MOVE WS-ACCOUNT-NBR TO WS-ACCOUNT(WS-INDEX-192)        
                 MOVE '- ERROR FROM CSR02294, RC = '                    
                                    TO WS-REASON-PT1(WS-INDEX-192)      
                 MOVE S-RETURN-CODE TO WS-REASON-PT2(WS-INDEX-192)      
                 MOVE 'Y'           TO WS-ACCOUNT-ISSUE                 
              END-IF                                                    
              MOVE 'Y' TO WS-CALLED-PGM-RC                              
           END-IF.                                                      
           INITIALIZE  C8-DELINQ-CD.                                    
      *                                                                         
       3020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    3100-CNTRL-AR-PROCESSING                                **  00272000
      **                                                            **  00273000
      ** CALLED BY: 3000-PROCESS-RECEIVABLES                        **  00273000
      ****************************************************************  00273500
      *                                                                         
       3100-CNTRL-AR-PROCESSING.                                        
      *                                                                         
           MOVE ZERO                        TO WS-CHG-OFF-ACTUAL-BAL.   
      *                                                                         
           MOVE AC-PYMT-PRIORITY-LVL        TO WS-PYMT-PRTY-LVL.        
      *                                                                         
           IF AC-ITEM-ID = ZERO                                         
      *                                                                         
             EVALUATE TRUE                                              
               WHEN WS-UTLE-PYMT-PRTY                                   
               WHEN WS-UTLG-PYMT-PRTY                                   
               WHEN WS-NSF-PYMT-PRTY                                    
               WHEN WS-NSA-PYMT-PRTY                                    
               WHEN WS-NSN-PYMT-PRTY                                    
               WHEN WS-LPN-PYMT-PRTY                                    
      *                                                                         
                   PERFORM 3110-PROCESS-SUMM-ONLY      THRU 3110-EXIT   
      *                                                                         
                   IF WS-CHG-OFF-ACTUAL-BAL GREATER THAN ZERO           
      *                                                                         
                       IF WS-UPDATE-PROCESSING = 'Y'                    
                           IF WS-NSF-PYMT-PRTY                          
                              MOVE SPACES TO FW-COLLECT-STATUS-CD       
                                             WS-ACTION-TYPE-CD          
                              MOVE 0      TO WS-COLLECTION-AM           
                              PERFORM 7677-GET-COLLECT-STATUS-CODE      
                                                      THRU 7677-EXIT    
                              EVALUATE FW-COLLECT-STATUS-CD             
                                 WHEN 'F'                               
                                   MOVE '1PLMT' TO WS-ACTION-TYPE-CD    
                                 WHEN 'H'                               
                                   MOVE '2PLMT' TO WS-ACTION-TYPE-CD    
                                 WHEN 'J'                               
                                   MOVE '3PLMT' TO WS-ACTION-TYPE-CD    
                                 WHEN 'D'                               
                                   MOVE 'ATY'   TO WS-ACTION-TYPE-CD    
                                 WHEN OTHER                             
                                   MOVE 0       TO WS-COLLECTION-AM     
                              END-EVALUATE                              
                                                                        
                              PERFORM 7679-GET-COLLECTION-AGNCY-CD      
                                                THRU 7679-EXIT          
      *                                                                         
      *//TEMPORARY FIX TO DISCLUDE ACCOUNTS SENT TO THE COLLECTION              
      *//AGENCY BY THE LEGACY SYSTEM.                                           
                              IF (WS-COLLECTION-AM > 0)                 
                                 PERFORM 4010-PROCESS-COLL-AGY-TOTALS   
                                 THRU 4010-EXIT                         
                              END-IF                                    
                           END-IF                                       
                       END-IF                                           
      *                                                                         
                       PERFORM 3300-CREATE-CHRG-OFF    THRU 3300-EXIT   
                       IF WS-CALLED-PGM-BAD-RC                          
                           GO TO 3100-EXIT                              
                       END-IF                                           
      *                                                                         
                       PERFORM 3400-CREATE-102-JOURNAL THRU 3400-EXIT   
      *                                                                 00492000
                       PERFORM 3150-FORMAT-WK11-HDR    THRU 3150-EXIT   
      *                                                                         
                       PERFORM 3402-LOAD-TRAN-DET-TABLE                 
                                                       THRU 3402-EXIT   
      *                                                                         
                   ELSE                                                 
                       MOVE WS-NO           TO WS-CHARGE-OFF-COMPLETE   
                   END-IF                                               
      *                                                                         
               WHEN WS-LPC-PYMT-PRTY                                    
      *                                                                         
                   PERFORM 3110-PROCESS-SUMM-ONLY      THRU 3110-EXIT   
      *                                                                         
                   IF WS-CHG-OFF-ACTUAL-BAL GREATER THAN ZERO           
                      IF B1-DISTRICT-NO = 'GAS'                         
                        INITIALIZE WS-WO-TBL                            
                                   WS-LPC-GAS-AMT                       
                                   WS-LPC-ELEC-AMT                      
                        MOVE WS-CHG-OFF-ACTUAL-BAL    TO WS-AMOUNT(1)   
                                                       WS-LPC-GAS-AMT   
                        MOVE WS-AR-LPC-GL-NO(WS-GL-SUB)                 
                                              TO WS-GL-ACCOUNT-NO-CR(1) 
                        MOVE WS-WO-GASCHG-GL-NO(WS-GL-SUB)              
                                              TO WS-GL-ACCOUNT-NO-DR(1) 
                        MOVE AC-AMT-AR-DAY-00  TO WS-00-DAY-UTG         
                        MOVE AC-AMT-AR-DAY-30  TO WS-30-DAY-UTG         
                        MOVE AC-AMT-AR-DAY-60  TO WS-60-DAY-UTG         
                        MOVE AC-AMT-AR-DAY-90  TO WS-90-DAY-UTG         
      *                                                                         
                        MOVE 'G'              TO WS-GAS-UTIL-SW         
                        MOVE 'N'              TO WS-ELEC-UTIL-SW        
                                                 WS-NO-UTIL-SW          
                      ELSE                                              
                        PERFORM 3175-PROCESS-ALLOCATE-LPC THRU 3175-EXIT
                      END-IF                                            
      *                                                                         
                     PERFORM VARYING WS-WO-INDX FROM 1 BY 1             
SCA006                 UNTIL WS-WO-INDX > 2 OR 
                             WS-GL-ACCOUNT-NO-CR(WS-WO-INDX) = 0                
      *                                                                         
                         PERFORM 3400-CREATE-102-JOURNAL THRU 3400-EXIT 
      *                                                                         
                         PERFORM 3150-FORMAT-WK11-HDR    THRU 3150-EXIT 
      *                                                                         
                         PERFORM 3402-LOAD-TRAN-DET-TABLE               
                                                        THRU 3402-EXIT  
      *                                                                         
                     END-PERFORM                                        
      *                                                                         
                     PERFORM 3300-CREATE-CHRG-OFF        THRU 3300-EXIT 
                     IF WS-CALLED-PGM-BAD-RC                            
                         GO TO 3100-EXIT                                
                     END-IF                                             
                   ELSE                                                 
                     MOVE WS-NO               TO WS-CHARGE-OFF-COMPLETE 
                   END-IF                                               
      *                                                                         
                WHEN WS-CNT-PYMT-PRTY                                   
      *                                                                         
                   PERFORM 8000-DLET-AR-CNTRL          THRU 8000-EXIT   
      *                                                                         
                WHEN WS-CCC-PYMT-PRTY                                   
      *                                                                         
                   PERFORM 8000-DLET-AR-CNTRL          THRU 8000-EXIT   
      *                                                                         
                END-EVALUATE                                            
      *                                                                         
           END-IF.                                                      
      *                                                                         
           IF AC-ITEM-ID > ZERO                                         
      *                                                                         
             EVALUATE TRUE                                              
      *                                                                         
               WHEN WS-CNT-PYMT-PRTY                                    
      *                                                                         
                 IF AC-AMT-TRAN-BALANCE > 0                             
                     IF WS-CONTRACT-REC-BAL-NEEDED = 'Y'                
                         PERFORM 7755-GET-CONTRACT-REC-BAL              
                                                         THRU 7755-EXIT 
      *                                                                         
                         COMPUTE WS-TOTAL-CNT-REC =                     
                           WS-CONTRACT-REC-AMT + WS-CONTRACT-REC-UN-CR  
      *                                                                         
                         MOVE 'N'        TO WS-CONTRACT-REC-BAL-NEEDED  
                     END-IF                                             
      *                                                                         
                     PERFORM 3130-PROCESS-CNT            THRU 3130-EXIT 
                     IF  WS-ZERO-CNT-WO-GL                              
                         GO TO 3100-EXIT                                
                     END-IF                                             
      *                                                                         
                     PERFORM 8000-DLET-AR-CNTRL          THRU 8000-EXIT 
      *                                                                         
                     PERFORM 3300-CREATE-CHRG-OFF        THRU 3300-EXIT 
                     IF WS-CALLED-PGM-BAD-RC                            
                         GO TO 3100-EXIT                                
                     END-IF                                             
                 ELSE                                                   
                    IF AC-AMT-TRAN-BALANCE = 0                          
                       PERFORM 8000-DLET-AR-CNTRL        THRU 8000-EXIT 
                    ELSE                                                
                       MOVE WS-NO  TO  WS-CHARGE-OFF-COMPLETE           
                    END-IF                                              
                 END-IF                                                 
      *                                                                         
               WHEN WS-CCC-PYMT-PRTY                                    
      *                                                                         
                 IF B1-DISTRICT-NO = 'GAS'                              
                   INITIALIZE WS-WO-TBL                                 
                   MOVE AC-AMT-TRAN-BALANCE   TO WS-AMOUNT(1)           
                                               WS-RCC-GAS-AMT           
                   MOVE WS-AR-CCC-GL-NO(WS-GL-SUB)                      
                                              TO WS-GL-ACCOUNT-NO-CR(1) 
                   MOVE WS-WO-GASCHG-GL-NO(WS-GL-SUB)                   
                                              TO WS-GL-ACCOUNT-NO-DR(1) 
                   MOVE AC-AMT-AR-DAY-00      TO WS-00-DAY-UTG          
                   MOVE AC-AMT-AR-DAY-30      TO WS-30-DAY-UTG          
                   MOVE AC-AMT-AR-DAY-60      TO WS-60-DAY-UTG          
                   MOVE AC-AMT-AR-DAY-90      TO WS-90-DAY-UTG          
                   MOVE 'G'                   TO WS-GAS-UTIL-SW         
                   MOVE 'N'                   TO WS-ELEC-UTIL-SW        
                                                 WS-NO-UTIL-SW          
                 ELSE                                                   
                   PERFORM 3165-PROCESS-ALLOCATE-RCC THRU 3165-EXIT     
                 END-IF                                                 
      *                                                                         
                 ADD AC-AMT-TRAN-BALANCE     TO WS-CHG-OFF-ACCT-TOTAL   
                                                WS-CHG-OFF-CMP-TOTAL    
                                                WS-CHG-OFF-AMT-TOTAL    
      *                                                                         
                 MOVE AC-AMT-TRAN-BALANCE    TO WS-CHG-OFF-ACTUAL-BAL   
      *                                                                         
                 PERFORM VARYING WS-WO-INDX FROM 1 BY 1                 
SCA006             UNTIL WS-WO-INDX > 2 OR 
                         WS-GL-ACCOUNT-NO-CR(WS-WO-INDX) = 0                    
      *                                                                         
                     PERFORM 3400-CREATE-102-JOURNAL     THRU 3400-EXIT 
      *                                                                         
                     PERFORM 3150-FORMAT-WK11-HDR        THRU 3150-EXIT 
      *                                                                         
                     PERFORM 3402-LOAD-TRAN-DET-TABLE    THRU 3402-EXIT 
      *                                                                         
                 END-PERFORM                                            
      *                                                                         
                 MOVE SPACES             TO WS-CODE-CONNECT-CHRG        
      *                                                                         
                 PERFORM 8000-DLET-AR-CNTRL          THRU 8000-EXIT     
                 PERFORM 3300-CREATE-CHRG-OFF        THRU 3300-EXIT     
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                         
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00492000
      ****************************************************************  00271000
      **                                                            **  00271500
      **    3110-PROCESS-SUMM-ONLY                                  **  00272000
      **                                                            **  00273000
      **    REMOVED CODE THAT BLANKED OUT CODE-UTL.                 **  00273000
      ****************************************************************  00273500
       3110-PROCESS-SUMM-ONLY.                                          
      *                                                                 00492000
           ADD AC-AMT-AR-DAY-00,                                        
               AC-AMT-AR-DAY-30,                                        
               AC-AMT-AR-DAY-60,                                        
               AC-AMT-AR-DAY-90,                                        
               AC-AMT-UNUSED-CR                                         
                  GIVING WS-CHG-OFF-ACTUAL-BAL.                         
      *                                                                         
           IF WS-CHG-OFF-ACTUAL-BAL GREATER THAN ZERO                   
      *                                                                 00492000
               ADD WS-CHG-OFF-ACTUAL-BAL   TO WS-CHG-OFF-ACCT-TOTAL     
                                              WS-CHG-OFF-CMP-TOTAL      
                                              WS-CHG-OFF-AMT-TOTAL      
               IF WS-LPC-PYMT-PRTY                                      
                   MOVE SPACES             TO WS-CODE-LPC               
               END-IF                                                   
      *                                                                         
               IF WS-NSF-PYMT-PRTY                                      
                   MOVE SPACES             TO WS-CODE-NSF-CHK-CHG       
               END-IF                                                   
      *                                                                 00513500
               PERFORM 8000-DLET-AR-CNTRL              THRU 8000-EXIT   
      *                                                                         
           END-IF.                                                      
      *                                                                 00513500
       3110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20500000
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    3130-PROCESS-CNT.                                       **  00272000
      **                                                            **  00273000
      ****************************************************************  00273500
      *                                                                         
       3130-PROCESS-CNT.                                                
      *                                                                         
           INITIALIZE WS-CNT-WO-TBL.                                    
      *                                                                         
           SET WS-CNT-INDX             TO +1.                           
      *                                                                         
           PERFORM 7800-OPEN-CNT-CSR            THRU 7800-EXIT.         
      *                                                                         
           PERFORM 7810-FETCH-CNT-CSR           THRU 7810-EXIT.         
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               IF  EA-WRT-OFF-GL-ACCT-NO EQUAL ZEROS                    
                   PERFORM 3132-PROCESS-ZERO-GL THRU 3132-EXIT          
                   GO TO  3130-EXIT                                     
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           MOVE AC-AMT-TRAN-BALANCE    TO WS-AMT-TRAN-BAL-HOLD.         
      *                                                                         
           ADD AC-AMT-TRAN-BALANCE     TO WS-CHG-OFF-ACCT-TOTAL         
                                          WS-CHG-OFF-CMP-TOTAL          
                                          WS-CHG-OFF-AMT-TOTAL.         
      *                                                                         
           MOVE AC-AMT-TRAN-BALANCE    TO WS-CHG-OFF-ACTUAL-BAL.        
      *                                                                         
           MOVE ZERO                   TO WS-CHGOFF-ACCUM               
                                          WS-ADJ-CHGOFF-DIFF-AMT.       
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
      *                                                                         
              IF  EA-WRT-OFF-GL-ACCT-NO EQUAL ZEROS                     
                  PERFORM 3132-PROCESS-ZERO-GL THRU 3132-EXIT           
                  GO TO  3130-EXIT                                      
              END-IF                                                    
      *                                                                         
              IF CT-AMT-ORIG-ENTERED = 0                                
                 MOVE 1 TO WS-CNT-FACTOR                                
              ELSE                                                      
                 COMPUTE WS-CNT-FACTOR   = (EA-CHARGE-AM +              
ACT278                                      CT-AMT-TAX-CITY +           
ACT278                                      CT-AMT-TAX-OTHER +          
ACT278                                      CT-AMT-TAX-STATE) /         
                                            CT-AMT-ORIG-ENTERED         
              END-IF                                                    
      *                                                                         
              COMPUTE WS-CNT-CHGOFF-AMT(WS-CNT-INDX) =                  
                  WS-CNT-FACTOR  * AC-AMT-TRAN-BALANCE                  
      *                                                                         
              ADD WS-CNT-CHGOFF-AMT(WS-CNT-INDX)                        
                                  TO WS-CHGOFF-ACCUM                    
      *                                                                         
              MOVE CT-CODE-CONTRACT-TYPE                                
                                  TO WS-CODE-CONTRACT-TYPE(WS-CNT-INDX) 
      *                                                                         
              MOVE CT-CNT-NAME-CD TO WS-CONTRACT-NAME-CD(WS-CNT-INDX)   
      *                                                                         
              MOVE CT-CNT-ITEM-ID TO WS-CONTRACT-ITEM-ID(WS-CNT-INDX)   
      *                                                                         
              MOVE EA-WRT-OFF-GL-ACCT-NO                                
                                  TO WS-WRT-OFF-GL-ACCT-NO(WS-CNT-INDX) 
      *                                                                         
              SET WS-CNT-INDX UP BY +1                                  
      *                                                                         
              PERFORM 7810-FETCH-CNT-CSR                THRU 7810-EXIT  
      *                                                                         
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7820-CLOSE-CNT-CSR                   THRU 7820-EXIT. 
      *                                                                         
           IF WS-CHGOFF-ACCUM NOT EQUAL AC-AMT-TRAN-BALANCE             
      *                                                                         
               SET WS-CNT-INDX UP BY -1                                 
      *                                                                         
               COMPUTE WS-ADJ-CHGOFF-DIFF-AMT =                         
                   AC-AMT-TRAN-BALANCE - WS-CHGOFF-ACCUM                
      *                                                                         
               COMPUTE WS-CNT-CHGOFF-AMT(WS-CNT-INDX) =                 
                   WS-CNT-CHGOFF-AMT(WS-CNT-INDX) +                     
                   WS-ADJ-CHGOFF-DIFF-AMT                               
           END-IF.                                                      
      *                                                                         
           PERFORM VARYING WS-CNT-INDX FROM 1 BY 1                      
SCA006       UNTIL WS-CNT-INDX > 100 OR 
                   WS-CNT-CHGOFF-AMT(WS-CNT-INDX) = ZERO                        
      *                                                                         
               PERFORM 3400-CREATE-102-JOURNAL THRU 3400-EXIT           
      *                                                                         
               PERFORM 3150-FORMAT-WK11-HDR     THRU 3150-EXIT          
      *                                                                         
               PERFORM 3155-PROCESS-REC-AGE     THRU 3155-EXIT          
      *                                                                         
           END-PERFORM.                                                 
      *                                                                         
           MOVE WS-CURRENT-DATE        TO CT-STATUS-CHANGE-DT.          
           MOVE 'E'                    TO CT-CNT-STATUS-CD.             
           MOVE WS-BATCH               TO CT-USER-ID.                   
           MOVE WS-ACCOUNT-NBR         TO CT-ACCOUNT-NO.                
           MOVE AC-PYMT-PRIORITY-LVL   TO CT-PYMT-PRIORITY-LVL.         
           MOVE AC-ITEM-ID             TO CT-CNT-ITEM-ID.               
      *                                                                         
           MOVE SPACE                  TO WS-CODE-CONTRACT.             
      *                                                                         
           PERFORM 8470-UPDT-CNT-STATUS              THRU 8470-EXIT.    
      *                                                                         
       3130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **   3132-PROCESS-ZERO-GL.                                    **          
      ****************************************************************          
       3132-PROCESS-ZERO-GL.                                            
      *                                                                         
           SET WS-ZERO-CNT-WO-GL       TO TRUE.                         
           MOVE CT-CNT-NAME-CD         TO K6-CNT-NAME-CD.               
           PERFORM 7825-GET-CNTRCT-NAME         THRU 7825-EXIT.         
                                                                        
           MOVE CT-CNT-ITEM-ID         TO WS-CNTRCT-ITEM-ID.            
      *                                                                         
           STRING K6-CNT-NAME-DESC DELIMITED  BY '  '                   
                  ' ' WS-CNTRCT-ITEM-ID                                 
                   WS-COMMENTS-WRITE-OFF-FAILED DELIMITED BY SIZE       
           INTO WS-COMMENTS-CNTRCT-NAME.                                
A04860     MOVE 20                     TO WS-77-CATEGORY-ID.            
      *                                                                         
A04860     MOVE WS-COMMENTS-ZERO-GL-NO TO WS-77-COMMENTS-TEXT.          
A04860     MOVE ZEROS                  TO WS-77-SERV-ORDER-NO.          
A04860     MOVE SPACES                 TO WS-77-RESP-AREA-ID.           
           MOVE LENGTH OF WS-COMMENTS-ZERO-GL-NO                        
A04860                                 TO WS-77-COMMENTS-LEN.           
A04860     MOVE ZEROS                  TO WS-77-FREE-FORM-LEN.          
A04860     MOVE LOW-VALUES             TO WS-77-FREE-FORM-TXT.          
A04860     MOVE 4                      TO WS-77-ROUTE-CATEGORY.         
      *                                                                         
           PERFORM 1408-CHECK-WQ-GEN   THRU 1408-EXIT.                  
      *                                                                         
           PERFORM 7820-CLOSE-CNT-CSR           THRU 7820-EXIT.         
      *                                                                         
       3132-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  00271000
      **                                                            **  00271500
      **    3150-FORMAT-WK11-HDR                                    **  00272000
      **                                                            **  00273000
      ** CALLED BY: 3130-PROCESS-CNT                                **  00273000
      ****************************************************************  00273500
       3150-FORMAT-WK11-HDR.                                            
      *                                                                         
           ADD +1                      TO WS-BATCH-TRAN-APPL-NO.        
      *                                                                         
           PERFORM 3166-CREATE-JRNL-FROM-RECORD THRU 3166-EXIT.         
      *                                                                         
       3150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    3155-PROCESS-REC-AGE                                    **  00272000
      **                                                            **  00273000
      **    THIS MODULE DISPLACES THE WRITTEN OFF CONTRACT ACROSS   **          
      **    THE 90, 60, 30, 00 DAY BUCKETS FOR TRANSACTION HISTORY  **          
      **    SIMPLE INTEREST, IF IT EXISTS ON THE ACCOUNT, IS        **          
      **    CREDITED FROM THE CONTRACT FIRST, THEREFORE THE 90 DAY  **          
      **    WILL BE HIT FIRST, ONCE THE 90 DAY BUCKET IS ZERO THE   **          
      **    60 DAY BUCKET WILL BE HIT, ETC.  THE DETAILS OF THE     **          
      **    CONTRACT ARE EACH HANDLED INDIVIDUALLY LIKE THE SIMPLE  **          
      **    INTEREST HITTING 90, 60, 30, 00.                        **          
      **                                                                        
      ****************************************************************  00273500
      *                                                                         
       3155-PROCESS-REC-AGE.                                            
      *                                                                         
           MOVE WS-CNT-CHGOFF-AMT(WS-CNT-INDX) TO WS-AMT-CNT-DETAIL     
      *                                                                         
           IF AC-AMT-AR-DAY-90 > 0                                      
              COMPUTE WS-VALUE-LEFT = AC-AMT-AR-DAY-90 -                
                                      WS-AMT-CNT-DETAIL                 
      *                                                                         
              MOVE 9                      TO AU-CODE-AR-AGE             
      *                                                                         
              IF WS-VALUE-LEFT <= 0                                     
                  MOVE AC-AMT-AR-DAY-90   TO AU-AMT-POSTED              
      *                                                                         
                  MOVE 0                  TO AC-AMT-AR-DAY-90           
      *                                                                         
                  MULTIPLY WS-VALUE-LEFT BY -1                          
                            GIVING WS-VALUE-LEFT                        
                  MOVE WS-VALUE-LEFT      TO WS-AMT-CNT-DETAIL          
      *                                                                         
              ELSE                                                      
                  MOVE WS-AMT-CNT-DETAIL  TO AU-AMT-POSTED              
                  MOVE WS-VALUE-LEFT      TO AC-AMT-AR-DAY-90           
                  MOVE 0                  TO WS-AMT-CNT-DETAIL          
              END-IF                                                    
      *                                                                         
              PERFORM 3160-INSRT-AR-TRAN-DET          THRU 3160-EXIT    
      *                                                                         
           END-IF.                                                      
      *                                                                         
           IF WS-AMT-CNT-DETAIL > 0 AND AC-AMT-AR-DAY-60 > 0            
      *                                                                         
              COMPUTE WS-VALUE-LEFT = AC-AMT-AR-DAY-60 -                
                                      WS-AMT-CNT-DETAIL                 
      *                                                                         
              MOVE 6                     TO AU-CODE-AR-AGE              
      *                                                                         
              IF WS-VALUE-LEFT <= 0                                     
                  MOVE AC-AMT-AR-DAY-60  TO AU-AMT-POSTED               
      *                                                                         
                  MOVE 0                 TO AC-AMT-AR-DAY-60            
      *                                                                         
                  MULTIPLY WS-VALUE-LEFT BY -1                          
                         GIVING WS-VALUE-LEFT                           
                  MOVE WS-VALUE-LEFT     TO WS-AMT-CNT-DETAIL           
              ELSE                                                      
                  MOVE WS-AMT-CNT-DETAIL TO AU-AMT-POSTED               
                  MOVE WS-VALUE-LEFT     TO AC-AMT-AR-DAY-60            
                  MOVE 0                 TO WS-AMT-CNT-DETAIL           
              END-IF                                                    
      *                                                                         
              PERFORM 3160-INSRT-AR-TRAN-DET          THRU 3160-EXIT    
           END-IF.                                                      
      *                                                                         
           IF WS-AMT-CNT-DETAIL > 0 AND AC-AMT-AR-DAY-30 > 0            
      *                                                                         
              COMPUTE WS-VALUE-LEFT = AC-AMT-AR-DAY-30 -                
                                      WS-AMT-CNT-DETAIL                 
      *                                                                         
              MOVE 3                     TO AU-CODE-AR-AGE              
      *                                                                         
              IF WS-VALUE-LEFT <= 0                                     
                  MOVE AC-AMT-AR-DAY-30  TO AU-AMT-POSTED               
      *                                                                         
                  MOVE 0                 TO AC-AMT-AR-DAY-30            
      *                                                                         
                  MULTIPLY WS-VALUE-LEFT BY -1                          
                         GIVING WS-VALUE-LEFT                           
                  MOVE WS-VALUE-LEFT     TO WS-AMT-CNT-DETAIL           
              ELSE                                                      
                  MOVE WS-AMT-CNT-DETAIL TO AU-AMT-POSTED               
                  MOVE WS-VALUE-LEFT     TO AC-AMT-AR-DAY-30            
                  MOVE 0                 TO WS-AMT-CNT-DETAIL           
              END-IF                                                    
      *                                                                         
              PERFORM 3160-INSRT-AR-TRAN-DET          THRU 3160-EXIT    
           END-IF.                                                      
      *                                                                         
           IF WS-AMT-CNT-DETAIL > 0                                     
      *                                                                         
              MOVE 0                     TO AU-CODE-AR-AGE              
      *                                                                         
              MOVE WS-AMT-CNT-DETAIL     TO AU-AMT-POSTED               
      *                                                                         
              MOVE 0                     TO AC-AMT-AR-DAY-00            
                                            WS-AMT-CNT-DETAIL           
      *                                                                         
              PERFORM 3160-INSRT-AR-TRAN-DET          THRU 3160-EXIT    
      *                                                                         
           END-IF.                                                      
      *                                                                         
       3155-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    3160-INSRT-AR-TRAN-DET                                  **  00272000
      **                                                            **  00273000
      ****************************************************************  00273500
       3160-INSRT-AR-TRAN-DET.                                          
      *                                                                         
           MOVE WS-ACCOUNT-NBR                  TO AU-ACCOUNT-NO.       
           MOVE WS-TIMESTAMP                    TO AU-TRANS-HIST-SEQ-NO.
                                                                        
           ADD +1       TO WS-JRNL-TRAN-APPL-NO.                        
                                                                        
           MOVE WS-JRNL-TRAN-APPL-NO            TO AU-TRAN-APPL-NO.     
                                                                        
           MOVE WS-AR-CNT-GL-NO(WS-GL-SUB)      TO AU-GL-ACCT-CREDIT.   
      *                                                                         
           MOVE WS-WRT-OFF-GL-ACCT-NO(WS-CNT-INDX)                      
                                           TO AU-GL-ACCT-DEBIT          
           MOVE WS-CODE-CONTRACT-TYPE(WS-CNT-INDX)                      
                                           TO AU-CODE-CONTRACT-TYPE     
      *                                                                         
           MOVE AC-ITEM-ID                      TO AU-ITEM-ID.          
           MOVE SPACES                          TO AU-CURRENCY-TYPE.    
           MOVE ZERO                            TO AU-CURRENCY-AMT.     
      *                                                                         
           PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST THRU 6500-EXIT.        
      *                                                                         
       3160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3166-CREATE-JRNL-FROM-RECORD                                            
      ******************************************************************        
       3166-CREATE-JRNL-FROM-RECORD.                                    
      *                                                                         
           IF WS-BATCH-TRAN-APPL-NO = 1                                 
               PERFORM 3170-GET-AND-VALIDATE-CNTRL    THRU 3170-EXIT    
           END-IF.                                                      
      *                                                                         
           MOVE WS-BATCH-TRAN-APPL-NO                                   
                              TO WS-100-JRNL-TRAN-APPL-NO.              
      *                                                                         
           MOVE WS-N          TO WS-UPDATE-JRNL-CNTL-NOW.               
      *                                                                         
           MOVE BC-NO-ITEMS-ENTERED                                     
                              TO WS-JRNL-NO-ITEMS-CNTRL.                
           MOVE WS-102-AMT-POSTED                                       
                              TO WS-JRNL-GEN-LEG-DEBIT-AMT              
                                 WS-JRNL-RCV-CREDIT-AMT.                
      *                                                                         
           MOVE 9999          TO WS-JRNL-BT-BAT-CASH-DRWR.              
      *                                                                         
           MOVE CJF00102      TO WS-100-USER-DEFINED-AREA.              
      *                                                                         
           MOVE WS-JRNL-ONLY  TO WS-JRNL-OPERATION-RQST.                
      *                                                                         
           PERFORM 6400-BATCH-JRNL-ROUTINE            THRU 6400-EXIT.   
      *                                                                         
           IF WS-JRNL-RTRN-CODE NOT EQUAL SPACES                        
                DISPLAY '*************************************'         
                DISPLAY '**  PCSKR400 PROCESSING ERROR'                 
                DISPLAY '**  PARAGRAPH = 3166-'                         
                DISPLAY '**  RC        = ' WS-JRNL-RTRN-CODE            
                DISPLAY '**  PROCESSING TERMINATED'                     
                DISPLAY '*************************************'         
                PERFORM 9900-ABEND                    THRU 9900-EXIT    
           END-IF.                                                      
      *                                                                         
           PERFORM 3180-TIE-OFF-CNTRL                 THRU 3180-EXIT.   
      *                                                                         
       3166-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *    GET AND VALIDATE CONTROL                                             
      ******************************************************************        
      *                                                                         
       3170-GET-AND-VALIDATE-CNTRL.                                     
                                                                        
           MOVE WS-B                  TO WS-JRNL-SOURCE-CODE.           
      *                                                                         
           MOVE SPACES                TO BC-LOCAL-OFFICE-ENTRY          
                                         WS-JRNL-BT-ENTRY-LOC.          
                                                                        
           PERFORM 6405-GET-CURRENT-JRNL-TIME THRU 6405-EXIT.           
           PERFORM 6410-GET-CURRENT-JRNL-DATE THRU 6410-EXIT.           
      *                                                                         
           MOVE '01'                  TO BC-CASH-COMPANY-NO.            
           MOVE '998'                 TO BC-CASH-LOCAL-OFFICE.          
           MOVE WS-JRNL-TRAN-DATE     TO BC-DATE-CASH-REPORT.           
           MOVE '998'                 TO BC-CASH-REPORT-NO.             
           MOVE 9999                  TO BC-CASH-DRAWER-ID.             
      *                                                                         
           MOVE BC-CASH-COMPANY-NO         TO WS-JRNL-BT-BAT-COMPANY.   
           MOVE BC-CASH-LOCAL-OFFICE       TO WS-JRNL-BT-BAT-LOC-OFF.   
           MOVE BC-CASH-REPORT-NO          TO WS-JRNL-BT-BAT-REPORT-NO. 
           MOVE BC-DATE-CASH-REPORT        TO WS-JRNL-BT-BAT-REPORT-DT. 
           MOVE BC-CASH-DRAWER-ID          TO WS-JRNL-BT-BAT-CASH-DRWR. 
      *                                                                         
           MOVE WS-ACCOUNT-NBR             TO WS-100-ACCT-NO.           
           MOVE AT-LOCAL-OFFICE            TO WS-100-LOCAL-OFFICE-CD.   
           MOVE WS-B                       TO WS-100-CODE-ENTRY-SOURCE. 
           MOVE SPACES                     TO WS-100-TRANS-ERRORS.      
           MOVE AT-COMPANY-NO              TO WS-100-COMPANY-NO.        
           MOVE WS-CUSTOMER-NO             TO WS-100-CUSTOMER-NO.       
           MOVE WS-CURRENT-DATE            TO WS-100-DATE-LAST-ACTION.  
           MOVE WS-A                       TO WS-100-JRNL-SORT-ID.      
           MOVE WS-PREMISE-NO              TO WS-100-PREMISE-NO.        
           MOVE WS-A192                    TO WS-100-CODE-TERMINAL-TRAN.
           MOVE WS-BATCH-TRAN-APPL-NO      TO WS-100-JRNL-TRAN-APPL-NO. 
      *                                                                         
           MOVE SPACES                   TO WS-JRNL-BT-ENTRY-LOC.       
      *                                                                         
           MOVE SPACES                   TO WS-JRNL-CURRENCY-TYPE       
                                            WS-JRNL-CODE-PYMT-FACILITY. 
      *                                                                         
           MOVE WS-JRNL-SELECT-AND-OR-INS  TO WS-JRNL-OPERATION-RQST.   
           PERFORM 6400-BATCH-JRNL-ROUTINE            THRU 6400-EXIT.   
      *                                                                         
           MOVE WS-JRNL-CASH-UPDATE        TO WS-JRNL-BT-AUTH-TYPE.     
      *                                                                         
       3170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    3165-PROCESS-ALLOCATE-RCC                               **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
      *                                                                         
       3165-PROCESS-ALLOCATE-RCC.                                       
      *                                                                         
           INITIALIZE WS-WO-TBL                                         
      *                                                                         
           PERFORM 7690-SELECT-RCC-DETAILS               THRU 7690-EXIT 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               PERFORM 3168-CONNECT-CHRG-NOT-FOUND THRU 3168-EXIT       
           END-IF                                                       
      *                                                                         
           PERFORM 3167-ALLOCATE-BUCKETS-RCC         THRU 3167-EXIT     
      *                                                                         
           EVALUATE TRUE                                                
             WHEN U7-RCNCT-ELEC-SVC-FL = 'Y' AND                        
                  U7-RCNCT-GAS-SVC-FL = 'Y'                             
               MOVE 'G'                   TO WS-GAS-UTIL-SW             
               MOVE 'E'                   TO WS-ELEC-UTIL-SW            
               MOVE 'N'                   TO WS-NO-UTIL-SW              
      *                                                                         
               COMPUTE WS-RCC-ELEC-AMT ROUNDED =                        
               (AC-AMT-TRAN-BALANCE * C8-DELINQ-VALUE) / 100            
                                                                        
               MOVE WS-RCC-ELEC-AMT       TO WS-AMOUNT(1)               
               MOVE WS-AR-CCC-GL-NO(WS-GL-SUB)                          
                                          TO WS-GL-ACCOUNT-NO-CR(1)     
               MOVE WS-WO-ELECCHG-GL-NO(WS-GL-SUB)                      
                                          TO WS-GL-ACCOUNT-NO-DR(1)     
                                                                        
               COMPUTE WS-RCC-GAS-AMT = AC-AMT-TRAN-BALANCE             
                                        - WS-RCC-ELEC-AMT               
               MOVE WS-RCC-GAS-AMT        TO WS-AMOUNT(2)               
               MOVE WS-AR-CCC-GL-NO(WS-GL-SUB)                          
                                          TO WS-GL-ACCOUNT-NO-CR(2)     
               MOVE WS-WO-GASCHG-GL-NO(WS-GL-SUB)                       
                                          TO WS-GL-ACCOUNT-NO-DR(2)     
      *                                                                         
             WHEN U7-RCNCT-GAS-SVC-FL = 'Y'                             
               MOVE 'G'                   TO WS-GAS-UTIL-SW             
               MOVE 'N'                   TO WS-ELEC-UTIL-SW            
                                             WS-NO-UTIL-SW              
                                                                        
               MOVE AC-AMT-TRAN-BALANCE   TO WS-AMOUNT(1)               
                                             WS-RCC-GAS-AMT             
               MOVE WS-AR-CCC-GL-NO(WS-GL-SUB)                          
                                          TO WS-GL-ACCOUNT-NO-CR(1)     
               MOVE WS-WO-GASCHG-GL-NO(WS-GL-SUB)                       
                                          TO WS-GL-ACCOUNT-NO-DR(1)     
      *                                                                         
             WHEN U7-RCNCT-ELEC-SVC-FL = 'Y'                            
               MOVE 'E'                   TO WS-ELEC-UTIL-SW            
               MOVE 'N'                   TO WS-GAS-UTIL-SW             
                                             WS-NO-UTIL-SW              
                                                                        
               MOVE AC-AMT-TRAN-BALANCE   TO WS-AMOUNT(1)               
                                             WS-RCC-ELEC-AMT            
               MOVE WS-AR-CCC-GL-NO(WS-GL-SUB)                          
                                          TO WS-GL-ACCOUNT-NO-CR(1)     
               MOVE WS-WO-ELECCHG-GL-NO(WS-GL-SUB)                      
                                          TO WS-GL-ACCOUNT-NO-DR(1)     
           END-EVALUATE.                                                
      *                                                                         
       3165-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *****************************************************************         
      *                                                                         
      * 3167-ALLOCATE-BUCKETS-RCC                                               
      *                                                                         
      * THIS MODULE MOVES THE ALLOCATED AMOUNT OF 00, 30, 60, 90 DAY            
      * MONEY BUCKETS FOR RCC.  THE ALLOCATED BUCKET AMOUNTS                    
      * ARE NEEDED FOR WRITING A/R TRANSACTION HISTORY.                         
      *                                                                         
      *****************************************************************         
      *                                                                         
       3167-ALLOCATE-BUCKETS-RCC.                                       
      *                                                                         
           EVALUATE TRUE                                                
             WHEN U7-RCNCT-ELEC-SVC-FL = 'Y' AND                        
                  U7-RCNCT-GAS-SVC-FL = 'Y'                             
      *                                                                         
                COMPUTE WS-00-DAY-UTE ROUNDED =                         
                        (C8-DELINQ-VALUE * AC-AMT-AR-DAY-00)            
                         / 100                                          
                                                                        
                COMPUTE WS-00-DAY-UTG = AC-AMT-AR-DAY-00                
                                            - WS-00-DAY-UTE             
      *                                                                         
                COMPUTE WS-30-DAY-UTE ROUNDED =                         
                        (C8-DELINQ-VALUE * AC-AMT-AR-DAY-30)            
                         / 100                                          
                                                                        
                COMPUTE WS-30-DAY-UTG = AC-AMT-AR-DAY-30                
                                            - WS-30-DAY-UTE             
      *                                                                         
                COMPUTE WS-60-DAY-UTE ROUNDED =                         
                        (C8-DELINQ-VALUE * AC-AMT-AR-DAY-60)            
                         / 100                                          
                                                                        
                COMPUTE WS-60-DAY-UTG = AC-AMT-AR-DAY-60                
                                            - WS-60-DAY-UTE             
      *                                                                         
                COMPUTE WS-90-DAY-UTE ROUNDED =                         
                        (C8-DELINQ-VALUE * AC-AMT-AR-DAY-90)            
                         / 100                                          
                                                                        
                COMPUTE WS-90-DAY-UTG = AC-AMT-AR-DAY-90                
                                            - WS-90-DAY-UTE             
      *                                                                         
             WHEN U7-RCNCT-ELEC-SVC-FL = 'Y'                            
                MOVE AC-AMT-AR-DAY-00  TO WS-00-DAY-UTE                 
                MOVE AC-AMT-AR-DAY-30  TO WS-30-DAY-UTE                 
                MOVE AC-AMT-AR-DAY-60  TO WS-60-DAY-UTE                 
                MOVE AC-AMT-AR-DAY-90  TO WS-90-DAY-UTE                 
      *                                                                         
             WHEN U7-RCNCT-GAS-SVC-FL = 'Y'                             
                MOVE AC-AMT-AR-DAY-00  TO WS-00-DAY-UTG                 
                MOVE AC-AMT-AR-DAY-30  TO WS-30-DAY-UTG                 
                MOVE AC-AMT-AR-DAY-60  TO WS-60-DAY-UTG                 
                MOVE AC-AMT-AR-DAY-90  TO WS-90-DAY-UTG                 
           END-EVALUATE.                                                
      *                                                                         
       3167-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3168-CONNECT-CHRG-NOT-FOUND.                                   *        
      ******************************************************************        
       3168-CONNECT-CHRG-NOT-FOUND.                                     
           IF B1-ELEC-REV-ALLOC-PCT = 0                                 
               MOVE 'Y' TO U7-RCNCT-GAS-SVC-FL                          
           ELSE                                                         
               IF B1-ELEC-REV-ALLOC-PCT = 100                           
                   MOVE 'Y' TO U7-RCNCT-ELEC-SVC-FL                     
               ELSE                                                     
                   MOVE 'Y' TO U7-RCNCT-ELEC-SVC-FL                     
                   MOVE 'Y' TO U7-RCNCT-GAS-SVC-FL                      
               END-IF                                                   
           END-IF.                                                      
       3168-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    3175-PROCESS-ALLOCATE-LPC.                              **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
      *                                                                         
       3175-PROCESS-ALLOCATE-LPC.                                       
      *                                                                         
           INITIALIZE WS-WO-TBL                                         
                      WS-LPC-GAS-AMT                                    
                      WS-LPC-ELEC-AMT.                                  
      *                                                                         
           MOVE 'N'            TO WS-ELEC-UTIL-SW                       
                                  WS-GAS-UTIL-SW                        
                                  WS-NO-UTIL-SW.                        
      *                                                                         
           PERFORM 7700-OPEN-UTIL-ENV-CSR              THRU 7700-EXIT.  
      *                                                                         
           PERFORM 7710-FETCH-UTIL-ENV-CSR             THRU 7710-EXIT.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               MOVE 'U'        TO WS-NO-UTIL-SW                         
           END-IF.                                                      
      *                                                                         
           PERFORM 3176-DETERMINE-UTIL-SVC             THRU 3176-EXIT   
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
      *                                                                         
           PERFORM 7720-CLOSE-UTIL-ENV-CSR             THRU 7720-EXIT   
      *                                                                         
           PERFORM 3177-ALLOCATE-BUCKETS-LPC           THRU 3177-EXIT   
      *                                                                         
           EVALUATE TRUE                                                
      *                                                                         
             WHEN ELECTRIC-ACCT AND GAS-ACCT                            
                                                                        
                COMPUTE WS-LPC-ELEC-AMT ROUNDED = (WS-ALLOCATION-FACTOR 
                        * WS-CHG-OFF-ACTUAL-BAL) / 100                  
                MOVE WS-LPC-ELEC-AMT          TO WS-AMOUNT(1)           
                MOVE WS-AR-LPC-GL-NO(WS-GL-SUB)                         
                                              TO WS-GL-ACCOUNT-NO-CR(1) 
                MOVE WS-WO-ELECCHG-GL-NO(WS-GL-SUB)                     
                                              TO WS-GL-ACCOUNT-NO-DR(1) 
                                                                        
                COMPUTE WS-LPC-GAS-AMT = WS-CHG-OFF-ACTUAL-BAL          
                                          - WS-LPC-ELEC-AMT             
                MOVE WS-LPC-GAS-AMT           TO WS-AMOUNT(2)           
                MOVE WS-AR-LPC-GL-NO(WS-GL-SUB)                         
                                              TO WS-GL-ACCOUNT-NO-CR(2) 
                MOVE WS-WO-GASCHG-GL-NO(WS-GL-SUB)                      
                                              TO WS-GL-ACCOUNT-NO-DR(2) 
      *                                                                         
             WHEN ELECTRIC-ACCT                                         
                MOVE WS-CHG-OFF-ACTUAL-BAL    TO WS-AMOUNT(1)           
                                                 WS-LPC-ELEC-AMT        
                MOVE WS-AR-LPC-GL-NO(WS-GL-SUB)                         
                                              TO WS-GL-ACCOUNT-NO-CR(1) 
                MOVE WS-WO-ELECCHG-GL-NO(WS-GL-SUB)                     
                                              TO WS-GL-ACCOUNT-NO-DR(1) 
      *                                                                         
             WHEN GAS-ACCT                                              
                MOVE WS-CHG-OFF-ACTUAL-BAL    TO WS-AMOUNT(1)           
                                                 WS-LPC-GAS-AMT         
                MOVE WS-AR-LPC-GL-NO(WS-GL-SUB)                         
                                              TO WS-GL-ACCOUNT-NO-CR(1) 
                MOVE WS-WO-GASCHG-GL-NO(WS-GL-SUB)                      
                                              TO WS-GL-ACCOUNT-NO-DR(1) 
           END-EVALUATE.                                                
      *                                                                         
       3175-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       3176-DETERMINE-UTIL-SVC.                                         
      *                                                                         
             EVALUATE TRUE                                              
               WHEN ELECTRIC-ACCT AND GAS-ACCT                          
                 MOVE +100 TO WS-ACTIVE-RETURN-CODE                     
                 GO                  TO 3176-EXIT                       
               WHEN UT-CODE-UTIL-TYPE = 'E'                             
                 SET ELECTRIC-ACCT   TO TRUE                            
               WHEN UT-CODE-UTIL-TYPE = 'G'                             
                 SET GAS-ACCT        TO TRUE                            
               WHEN UT-CODE-UTIL-TYPE = 'U'                             
                 PERFORM 7830-OPEN-UNMTRD-CSR          THRU 7830-EXIT   
                 PERFORM 7840-FETCH-UNMTRD-CSR         THRU 7840-EXIT   
                 IF CP-CODE-SERVICE-TYPE = 'G'                          
                   SET GAS-ACCT      TO TRUE                            
                 ELSE                                                   
                   SET ELECTRIC-ACCT TO TRUE                            
                 END-IF                                                 
                 PERFORM 7850-CLOSE-UNMTRD-CSR         THRU 7850-EXIT   
             END-EVALUATE.                                              
             PERFORM 7710-FETCH-UTIL-ENV-CSR           THRU 7710-EXIT.  
      *                                                                         
       3176-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                                         
      * 3177-ALLOCATE-BUCKETS-LPC                                               
      *                                                                         
      * THIS MODULE MOVES THE ALLOCATED AMOUNT OF 00, 30, 60, 90 DAY            
      * MONEY BUCKETS FOR LPC.  THE ALLOCATED BUCKET AMOUNTS                    
      * ARE NEEDED FOR WRITING A/R TRANSACTION HISTORY.                         
      *                                                                         
      *****************************************************************         
      *                                                                         
       3177-ALLOCATE-BUCKETS-LPC.                                       
      *                                                                         
           EVALUATE TRUE                                                
             WHEN ELECTRIC-ACCT AND GAS-ACCT                            
      *                                                                         
                IF (AT-ELEC-REV-ALLOC-PCT = 0 AND                       
                    B1-ELEC-REV-ALLOC-PCT = 0)                          
                    MOVE 'N'               TO WS-GAS-UTIL-SW            
                    MOVE AC-AMT-AR-DAY-00  TO WS-00-DAY-UTE             
                    MOVE AC-AMT-AR-DAY-30  TO WS-30-DAY-UTE             
                    MOVE AC-AMT-AR-DAY-60  TO WS-60-DAY-UTE             
                    MOVE AC-AMT-AR-DAY-90  TO WS-90-DAY-UTE             
                ELSE                                                    
                    IF AT-ELEC-REV-ALLOC-PCT EQUAL ZERO                 
                        MOVE B1-ELEC-REV-ALLOC-PCT                      
                                                TO WS-ALLOCATION-FACTOR 
                    ELSE                                                
                        MOVE AT-ELEC-REV-ALLOC-PCT                      
                                                TO WS-ALLOCATION-FACTOR 
                    END-IF                                              
                                                                        
                    COMPUTE WS-00-DAY-UTE ROUNDED =                     
                          (WS-ALLOCATION-FACTOR * AC-AMT-AR-DAY-00)     
                           / 100                                        
                                                                        
                    COMPUTE WS-00-DAY-UTG = AC-AMT-AR-DAY-00            
                                            - WS-00-DAY-UTE             
                                                                        
                    COMPUTE WS-30-DAY-UTE ROUNDED =                     
                        (WS-ALLOCATION-FACTOR * AC-AMT-AR-DAY-30)       
                         / 100                                          
                                                                        
                    COMPUTE WS-30-DAY-UTG = AC-AMT-AR-DAY-30            
                                            - WS-30-DAY-UTE             
      *                                                                         
                    COMPUTE WS-60-DAY-UTE ROUNDED =                     
                        (WS-ALLOCATION-FACTOR * AC-AMT-AR-DAY-60)       
                         / 100                                          
                                                                        
                    COMPUTE WS-60-DAY-UTG = AC-AMT-AR-DAY-60            
                                            - WS-60-DAY-UTE             
      *                                                                         
                    COMPUTE WS-90-DAY-UTE ROUNDED =                     
                        (WS-ALLOCATION-FACTOR * AC-AMT-AR-DAY-90)       
                         / 100                                          
                                                                        
                    COMPUTE WS-90-DAY-UTG = AC-AMT-AR-DAY-90            
                                            - WS-90-DAY-UTE             
                END-IF                                                  
      *                                                                         
             WHEN ELECTRIC-ACCT                                         
                MOVE AC-AMT-AR-DAY-00  TO WS-00-DAY-UTE                 
                MOVE AC-AMT-AR-DAY-30  TO WS-30-DAY-UTE                 
                MOVE AC-AMT-AR-DAY-60  TO WS-60-DAY-UTE                 
                MOVE AC-AMT-AR-DAY-90  TO WS-90-DAY-UTE                 
      *                                                                         
             WHEN GAS-ACCT                                              
                MOVE AC-AMT-AR-DAY-00  TO WS-00-DAY-UTG                 
                MOVE AC-AMT-AR-DAY-30  TO WS-30-DAY-UTG                 
                MOVE AC-AMT-AR-DAY-60  TO WS-60-DAY-UTG                 
                MOVE AC-AMT-AR-DAY-90  TO WS-90-DAY-UTG                 
      *                                                                         
             WHEN NO-UTIL-ACCT                                          
                IF (AT-ELEC-REV-ALLOC-PCT = 0 AND                       
                    B1-ELEC-REV-ALLOC-PCT = 0)                          
                    IF B1-DISTRICT-NO = 'GAS'                           
                        MOVE 'G'               TO WS-GAS-UTIL-SW        
                        MOVE AC-AMT-AR-DAY-00  TO WS-00-DAY-UTG         
                        MOVE AC-AMT-AR-DAY-30  TO WS-30-DAY-UTG         
                        MOVE AC-AMT-AR-DAY-60  TO WS-60-DAY-UTG         
                        MOVE AC-AMT-AR-DAY-90  TO WS-90-DAY-UTG         
                    ELSE                                                
                        MOVE 'E'               TO WS-ELEC-UTIL-SW       
                        MOVE AC-AMT-AR-DAY-00  TO WS-00-DAY-UTE         
                        MOVE AC-AMT-AR-DAY-30  TO WS-30-DAY-UTE         
                        MOVE AC-AMT-AR-DAY-60  TO WS-60-DAY-UTE         
                        MOVE AC-AMT-AR-DAY-90  TO WS-90-DAY-UTE         
                    END-IF                                              
                ELSE                                                    
                    IF AT-ELEC-REV-ALLOC-PCT EQUAL ZERO                 
                        MOVE B1-ELEC-REV-ALLOC-PCT                      
                                                TO WS-ALLOCATION-FACTOR 
                    ELSE                                                
                        MOVE AT-ELEC-REV-ALLOC-PCT                      
                                                TO WS-ALLOCATION-FACTOR 
                    END-IF                                              
                                                                        
                    MOVE 'G'                    TO WS-GAS-UTIL-SW       
                    MOVE 'E'                    TO WS-ELEC-UTIL-SW      
                                                                        
                    COMPUTE WS-00-DAY-UTE ROUNDED =                     
                          (WS-ALLOCATION-FACTOR * AC-AMT-AR-DAY-00)     
                           / 100                                        
                                                                        
                    COMPUTE WS-00-DAY-UTG = AC-AMT-AR-DAY-00            
                                            - WS-00-DAY-UTE             
                                                                        
                    COMPUTE WS-30-DAY-UTE ROUNDED =                     
                        (WS-ALLOCATION-FACTOR * AC-AMT-AR-DAY-30)       
                         / 100                                          
                                                                        
                    COMPUTE WS-30-DAY-UTG = AC-AMT-AR-DAY-30            
                                            - WS-30-DAY-UTE             
      *                                                                         
                    COMPUTE WS-60-DAY-UTE ROUNDED =                     
                        (WS-ALLOCATION-FACTOR * AC-AMT-AR-DAY-60)       
                         / 100                                          
                                                                        
                    COMPUTE WS-60-DAY-UTG = AC-AMT-AR-DAY-60            
                                            - WS-60-DAY-UTE             
      *                                                                         
                    COMPUTE WS-90-DAY-UTE ROUNDED =                     
                        (WS-ALLOCATION-FACTOR * AC-AMT-AR-DAY-90)       
                         / 100                                          
                                                                        
                    COMPUTE WS-90-DAY-UTG = AC-AMT-AR-DAY-90            
                                            - WS-90-DAY-UTE             
                END-IF                                                  
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       3177-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    UPDATE BATCH CONTROL RECORD                                          
      ******************************************************************        
                                                                        
       3180-TIE-OFF-CNTRL.                                              
                                                                        
           MOVE WS-JRNL-CNTRL-ONLY  TO WS-JRNL-OPERATION-RQST.          
                                                                        
           PERFORM 6400-BATCH-JRNL-ROUTINE            THRU 6400-EXIT.   
                                                                        
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '**  PCSKR400 PROCESSING ERROR'                  
               DISPLAY '**  PARAGRAPH = 3180-'                          
               DISPLAY '**  RC        = ' WS-JRNL-RTRN-CODE             
               DISPLAY '**  PROCESSING TERMINATED'                      
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND                     THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       3180-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    3300-CREATE-CHRG-OFF                                    **  00272000
      **        CREATE CHARGE OFF RECORD FOR INSERTION IN TABLE     **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       3300-CREATE-CHRG-OFF.                                            
      *                                                                         
           MOVE AC-PYMT-PRIORITY-LVL                                    
                                       TO CO-PYMT-PRIORITY-LVL.         
           MOVE AC-ITEM-ID             TO CO-ITEM-ID.                   
           MOVE WS-ACCOUNT-NBR         TO CO-ACCOUNT-NO.                
           MOVE WS-CHG-OFF-ACTUAL-BAL  TO CO-AMT-TRANS                  
                                          CO-WO-ORIGINAL-AM.            
      *                                                                         
           IF WS-UPDATE-PROCESSING = 'N'                                
      *                                                                         
               MOVE SPACES             TO CO-CODE-CHG-OFF-REAS          
      *                                                                         
               MOVE 'B'                TO CO-WO-STATUS                  
      *                                                                         
               MOVE WS-CHARGE-OFF-DATE-CHECK                            
                                       TO CO-DATE-OF-CHG-OFF            
      *                                                                         
               IF WS-BANKRUPTCY-IND EQUAL WS-B                          
                   MOVE WS-BANKRUPT    TO CO-CHG-OFF-DESC               
               ELSE                                                     
                   MOVE WS-SYSTEM-GEN  TO CO-CHG-OFF-DESC               
               END-IF                                                   
      *                                                                         
               MOVE WS-A               TO WS-CODE-CHRG-OFF              
      *                                                                         
           ELSE                                                         
               PERFORM 7240-SELECT-CHRG-OFF-VALUES    THRU 7240-EXIT    
               PERFORM 7677-GET-COLLECT-STATUS-CODE                     
                  THRU 7677-EXIT                                        
                  EVALUATE FW-COLLECT-STATUS-CD                         
                     WHEN 'F'                                           
                     WHEN 'H'                                           
                     WHEN 'J'                                           
                     WHEN 'D'                                           
                       MOVE 'J'       TO CO-WO-STATUS                   
                     WHEN 'G'                                           
                     WHEN 'I'                                           
                     WHEN 'K'                                           
                     WHEN 'E'                                           
                       MOVE 'F'       TO CO-WO-STATUS                   
                     WHEN OTHER                                         
                       MOVE 'B'       TO CO-WO-STATUS                   
                  END-EVALUATE                                          
           END-IF.                                                      
      *                                                                         
      ***  IF A PSNC ACCOUNT HAS A UTG OR NSA THAT IS WRITTEN OFF THEN          
      ***  CALCULATE COST OF GAS PERCENTAGE AND INSERT ROW IN                   
      ***  CSS_COST_GAS_DEFER TABLE BY CALLING SCSCB224                         
      *                                                                         
           IF WS-DATABASE = 0                                           
               MOVE 'DATABASE'                 TO C8-DELINQ-CD          
               MOVE AT-COMPANY-NO              TO C8-COMPANY-NO         
               PERFORM 7160-SELECT-DELINQ-VALUE THRU 7160-EXIT          
               MOVE WS-C8-DELINQ-VALUE          TO WS-DATABASE          
           END-IF                                                       
      *                                                                         
           IF CSR-DATABASE                                              
              IF (CO-PYMT-PRIORITY-LVL EQUAL 45 OR 20)                  
                 AND CO-WO-ORIGINAL-AM NOT EQUAL ZERO                   
                                                                        
              MOVE 'NSA-FLAG'                 TO C8-DELINQ-CD           
              MOVE AT-COMPANY-NO              TO C8-COMPANY-NO          
              PERFORM 7160-SELECT-DELINQ-VALUE THRU 7160-EXIT           
              MOVE WS-C8-DELINQ-VALUE          TO WS-NSA-FLAG           
                                                                        
              IF CO-PYMT-PRIORITY-LVL EQUAL 45 OR                       
                 (CO-PYMT-PRIORITY-LVL EQUAL 20 AND NSA-ACTIVE)         
                                                                        
              MOVE CO-ACCOUNT-NO              TO WS-C224-ACCOUNT-NO     
                                                 UT-ACCOUNT-NO          
              MOVE AT-COMPANY-NO              TO WS-C224-COMPANY-NO     
                                                 UT-COMPANY-NO          
              MOVE SPACES                   TO WS-VALID-RATE-FL         
              PERFORM 7980-CHECK-VALID-RATE THRU 7980-EXIT              
              IF VALID-RATE                                             
                 MOVE CO-PYMT-PRIORITY-LVL TO WS-C224-PYMT-PRIORITY-LVL 
                 MOVE CO-WO-ORIGINAL-AM     TO WS-C224-UTILITY-AMOUNT   
                 MOVE 'G'                   TO WS-C224-CODE-UTIL-TYPE   
                                                                        
                 MOVE SPACES                TO WS-CALLED-PGM-RC         
                 MOVE SPACES                TO ABEND-FUNCTION           
ACT372           MOVE ZEROS                 TO WS-C224-COG-PERCENT      
                 CALL SCSCB224              USING CWSCA224-PARMS,       
                                                     ABEND-FILE,        
                                                     RS-RETURN-CODE     
                                                                        
                 IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE > ZEROES  
                     IF WS-INDEX-192 < 750                              
                         ADD 1 TO WS-INDEX-192                          
                         MOVE CO-ACCOUNT-NO TO WS-ACCOUNT(WS-INDEX-192) 
                         MOVE '- ERROR FROM SCSCB224, RC = '            
                                   TO WS-REASON-PT1(WS-INDEX-192)       
                         MOVE RS-RETURN-CODE                            
                                   TO WS-REASON-PT2(WS-INDEX-192)       
                     END-IF                                             
                     MOVE 'Y' TO WS-CALLED-PGM-RC                       
                     GO TO 3300-EXIT                                    
                 ELSE                                                   
                    IF WS-C224-ERROR-CD > SPACES                        
                       PERFORM 3336-PROCESS-ERROR-CD THRU 3336-EXIT     
                       MOVE SPACES              TO WS-C224-ERROR-CD     
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
              END-IF                                                    
              END-IF                                                    
           END-IF                                                       
                                                                        
           PERFORM 8400-ISRT-CHRG-OFF                 THRU 8400-EXIT.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL ALREADY-EXISTS                
               PERFORM 3310-UPDATE-PREVIOUS-CO        THRU 3310-EXIT    
           END-IF.                                                      
      *                                                                         
       3300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    3310-UPDATE-PREVIOUS-CO                                 **  00272000
      **        PERFORM UPDATE OF TABLE IF RECORD ALREADY EXISTS    **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       3310-UPDATE-PREVIOUS-CO.                                         
      *                                                                         
           PERFORM 7245-GET-CHRG-OFF             THRU 7245-EXIT.        
      *                                                                         
           ADD WS-CHG-OFF-ACTUAL-BAL   TO CO-AMT-TRANS                  
                                          CO-WO-ORIGINAL-AM.            
      *                                                                         
           PERFORM 8410-REPL-CHRG-OFF            THRU 8410-EXIT.        
      *                                                                 00585500
       3310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00585500
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   3336-PROCESS-ERROR-CD                                    **          
      **                                                            **          
      **                                                            **          
      ****************************************************************          
       3336-PROCESS-ERROR-CD.                                           
      *                                                                         
           MOVE 429                               TO WS-77-CATEGORY-ID  
           EVALUATE WS-C224-ERROR-CD                                    
              WHEN 'CG0001'                                             
                 MOVE WS-COMMENTS-INVALID-ACCT    TO WS-77-COMMENTS-TEXT
                 MOVE LENGTH OF WS-COMMENTS-INVALID-ACCT TO             
A04860                                              WS-77-COMMENTS-LEN  
              WHEN 'CG0002'                                             
A04860           MOVE WS-COMMENTS-INVALID-UTL-AMT TO WS-77-COMMENTS-TEXT
                 MOVE LENGTH OF WS-COMMENTS-INVALID-UTL-AMT TO          
A04860                                              WS-77-COMMENTS-LEN  
              WHEN 'CG0003'                                             
A04860           MOVE WS-COMMENTS-INVALID-CD-UTLTYP TO                  
A04860                                              WS-77-COMMENTS-TEXT 
                 MOVE LENGTH OF WS-COMMENTS-INVALID-CD-UTLTYP TO        
A04860                                              WS-77-COMMENTS-LEN  
              WHEN 'CG0004'                                             
A04860           MOVE WS-COMMENTS-NON-CALC-BILL     TO                  
A04860                                              WS-77-COMMENTS-TEXT 
                 MOVE LENGTH OF WS-COMMENTS-NON-CALC-BILL TO            
A04860                                              WS-77-COMMENTS-LEN  
           END-EVALUATE                                                 
                                                                        
A04860     MOVE 'N'                          TO WS-77-PRIORITY          
A04860     MOVE ZEROS                        TO WS-77-SERV-ORDER-NO     
A04860     MOVE '437'                        TO WS-77-RESP-AREA-ID      
A04860     MOVE WS-INPUT-DATE                TO WS-77-DATE-REQUIRED     
A04860     MOVE WS-INPUT-DATE                TO WS-INPUT-DATE-PT        
A04860     MOVE WS-INPUT-TS                  TO WS-77-DATE-CREATED      
A04860     MOVE WS-ACCOUNT-NBR               TO WS-77-ACCOUNT-NO        
A04860     MOVE AT-PREMISE-NO                TO WS-77-PREMISE-NO        
A04860     MOVE AT-CUSTOMER-NO               TO WS-77-CUSTOMER-NO       
A04860     MOVE 'SYSTEM'                     TO WS-77-USER-ID-ORIG      
A04860     MOVE AT-LOCAL-OFFICE              TO WS-77-LOCAL-OFFICE      
A04860     MOVE 4                            TO WS-77-ROUTE-CATEGORY    
A04860     MOVE ZEROS                        TO WS-77-FREE-FORM-LEN     
A04860     MOVE LOW-VALUES                   TO WS-77-FREE-FORM-TXT     
A04860     MOVE PROGRAM-NAME                 TO WS-77-CREATED-BY        
           PERFORM 8895-INSERT-WORK-QUEUE       THRU 8895-EXIT          
           .                                                            
       3336-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  00271000
      **                                                            **  00271500
      **    3400-CREATE-102-JOURNAL                                 **  00272000
      **        CREATE RECORD FOR UPDATE OF JOURNAL                 **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       3400-CREATE-102-JOURNAL.                                         
      *                                                                 00585500
           INITIALIZE CJF00102.                                         
           MOVE AC-PYMT-PRIORITY-LVL      TO WS-PYMT-PRTY-LVL.          
           PERFORM 3410-CREATE-CORRECT-GL-NUM           THRU 3410-EXIT. 
           MOVE 102                       TO WS-102-JRNL-FORMAT-NO.     
           MOVE WS-X                      TO WS-102-CASH-DRAWER-USED.   
      *                                                                         
           IF WS-CCC-PYMT-PRTY OR WS-LPC-PYMT-PRTY                      
               MOVE WS-AMOUNT(WS-WO-INDX) TO WS-102-AMT-POSTED          
               MOVE WS-GL-ACCOUNT-NO-DR(WS-WO-INDX)                     
                                          TO WS-102-ACCT-GEN-LED-DR     
               MOVE WS-GL-ACCOUNT-NO-CR(WS-WO-INDX)                     
                                          TO WS-102-ACCT-GEN-LED-CR     
           ELSE                                                         
             IF WS-CNT-PYMT-PRTY                                        
                 MOVE WS-CHG-OFF-ACTUAL-BAL TO WS-102-AMT-POSTED        
                 MOVE WS-WRT-OFF-GL-ACCT-NO(WS-CNT-INDX)                
                                            TO WS-102-ACCT-GEN-LED-DR   
                 MOVE WS-AR-CNT-GL-NO(WS-GL-SUB)                        
                                            TO WS-102-ACCT-GEN-LED-CR   
             ELSE                                                       
                 MOVE WS-CHG-OFF-ACTUAL-BAL TO WS-102-AMT-POSTED        
                 MOVE WS-WO-GL-NO           TO WS-102-ACCT-GEN-LED-DR   
                 MOVE WS-AR-RECEIVABLE-GL   TO WS-102-ACCT-GEN-LED-CR   
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
           MOVE WS-REVENUE-MONTH          TO WS-102-REVENUE-MONTH.      
           MOVE AT-TOTAL-AR-BALANCE       TO WS-102-AMOUNT-ENTERED.     
           MOVE WS-W                      TO WS-102-AR-AGE.             
           MOVE AT-DATE-BILL-DAY-00       TO WS-102-DATE-AR-BILLED.     
           MOVE AC-ITEM-ID                TO WS-102-ITEM-ID-NO.         
           MOVE ZERO                      TO WS-102-DETAIL-END-BAL,     
                                             WS-102-DETAIL-END-AR-BAL.  
           SUBTRACT WS-102-AMT-POSTED                                   
                                          FROM WS-TOTAL-AR-BALANCE.     
      *                                                                         
           MOVE WS-TOTAL-AR-BALANCE    TO WS-102-ACCT-END-AR-BAL.       
           MOVE PR-REV-DISTRICT-CD     TO WS-102-CODE-REVENUE-DISTRICT. 
           MOVE WS-S                   TO WS-102-CODE-ACCOUNT-STATUS.   
      *                                                                         
       3400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00585500
      *                                                                 00585500
      ****************************************************************  00271000
      **                                                            **  00271500
      **    3402-LOAD-TRAN-DET-TABLE.                               **  00272000
      **                                                            **          
      **        LOADS THE INTERNAL TABLE FOR AR TRANS HIST.         **  00273000
      **                                                            **          
      **        THE INTERNAL TABLE CAPTURES THE 00, 30, 60, 90      **          
      **        BUCKET DETAIL FOR UTE, UTG, NSA, NSN, NSC, LPN,     **          
      **        LPC, RCC                                            **          
      **                                                            **  00273000
      ****************************************************************  00273500
      *                                                                         
       3402-LOAD-TRAN-DET-TABLE.                                        
      *                                                                         
           EVALUATE TRUE                                                
             WHEN WS-UTLE-PYMT-PRTY                                     
               MOVE AC-AMT-AR-DAY-00  TO WS-WO-00-DAY(WS-WO-REC-INDX)   
               MOVE AC-AMT-AR-DAY-30  TO WS-WO-30-DAY(WS-WO-REC-INDX)   
               MOVE AC-AMT-AR-DAY-60  TO WS-WO-60-DAY(WS-WO-REC-INDX)   
               MOVE AC-AMT-AR-DAY-90  TO WS-WO-90-DAY(WS-WO-REC-INDX)   
               MOVE AC-ITEM-ID        TO WS-WO-ITEM-ID(WS-WO-REC-INDX)  
               MOVE WS-AR-RECEIVABLE-GL TO                              
                                          WS-GL-ACCT-CR(WS-WO-REC-INDX) 
               MOVE WS-WO-GL-NO         TO                              
                                          WS-GL-ACCT-DR(WS-WO-REC-INDX) 
               SET WS-WO-REC-INDX UP BY +1                              
      *                                                                         
             WHEN WS-UTLG-PYMT-PRTY                                     
               MOVE AC-AMT-AR-DAY-00  TO WS-WO-00-DAY(WS-WO-REC-INDX)   
               MOVE AC-AMT-AR-DAY-30  TO WS-WO-30-DAY(WS-WO-REC-INDX)   
               MOVE AC-AMT-AR-DAY-60  TO WS-WO-60-DAY(WS-WO-REC-INDX)   
               MOVE AC-AMT-AR-DAY-90  TO WS-WO-90-DAY(WS-WO-REC-INDX)   
               MOVE AC-ITEM-ID        TO WS-WO-ITEM-ID(WS-WO-REC-INDX)  
               MOVE WS-AR-RECEIVABLE-GL TO                              
                                          WS-GL-ACCT-CR(WS-WO-REC-INDX) 
               MOVE WS-WO-GL-NO         TO                              
                                          WS-GL-ACCT-DR(WS-WO-REC-INDX) 
               SET WS-WO-REC-INDX UP BY +1                              
      *                                                                         
             WHEN WS-NSF-PYMT-PRTY                                      
               MOVE AC-AMT-AR-DAY-00  TO WS-WO-00-DAY(WS-WO-REC-INDX)   
               MOVE AC-AMT-AR-DAY-30  TO WS-WO-30-DAY(WS-WO-REC-INDX)   
               MOVE AC-AMT-AR-DAY-60  TO WS-WO-60-DAY(WS-WO-REC-INDX)   
               MOVE AC-AMT-AR-DAY-90  TO WS-WO-90-DAY(WS-WO-REC-INDX)   
               MOVE WS-AR-RECEIVABLE-GL TO                              
                                          WS-GL-ACCT-CR(WS-WO-REC-INDX) 
               MOVE WS-WO-GL-NO         TO                              
                                          WS-GL-ACCT-DR(WS-WO-REC-INDX) 
               SET WS-WO-REC-INDX UP BY +1                              
      *                                                                         
             WHEN WS-NSA-PYMT-PRTY                                      
               MOVE AC-AMT-AR-DAY-00  TO WS-WO-00-DAY(WS-WO-REC-INDX)   
               MOVE AC-AMT-AR-DAY-30  TO WS-WO-30-DAY(WS-WO-REC-INDX)   
               MOVE AC-AMT-AR-DAY-60  TO WS-WO-60-DAY(WS-WO-REC-INDX)   
               MOVE AC-AMT-AR-DAY-90  TO WS-WO-90-DAY(WS-WO-REC-INDX)   
               MOVE AC-ITEM-ID        TO WS-WO-ITEM-ID(WS-WO-REC-INDX)  
               MOVE WS-AR-RECEIVABLE-GL TO                              
                                          WS-GL-ACCT-CR(WS-WO-REC-INDX) 
               MOVE WS-WO-GL-NO         TO                              
                                          WS-GL-ACCT-DR(WS-WO-REC-INDX) 
               SET WS-WO-REC-INDX UP BY +1                              
      *                                                                         
             WHEN WS-NSN-PYMT-PRTY                                      
               MOVE AC-AMT-AR-DAY-00  TO WS-WO-00-DAY(WS-WO-REC-INDX)   
               MOVE AC-AMT-AR-DAY-30  TO WS-WO-30-DAY(WS-WO-REC-INDX)   
               MOVE AC-AMT-AR-DAY-60  TO WS-WO-60-DAY(WS-WO-REC-INDX)   
               MOVE AC-AMT-AR-DAY-90  TO WS-WO-90-DAY(WS-WO-REC-INDX)   
               MOVE AC-ITEM-ID        TO WS-WO-ITEM-ID(WS-WO-REC-INDX)  
               MOVE WS-AR-RECEIVABLE-GL TO                              
                                          WS-GL-ACCT-CR(WS-WO-REC-INDX) 
               MOVE WS-WO-GL-NO         TO                              
                                          WS-GL-ACCT-DR(WS-WO-REC-INDX) 
               SET WS-WO-REC-INDX UP BY +1                              
      *                                                                         
             WHEN WS-LPN-PYMT-PRTY                                      
               MOVE AC-AMT-AR-DAY-00  TO WS-WO-00-DAY(WS-WO-REC-INDX)   
               MOVE AC-AMT-AR-DAY-30  TO WS-WO-30-DAY(WS-WO-REC-INDX)   
               MOVE AC-AMT-AR-DAY-60  TO WS-WO-60-DAY(WS-WO-REC-INDX)   
               MOVE AC-AMT-AR-DAY-90  TO WS-WO-90-DAY(WS-WO-REC-INDX)   
               MOVE AC-ITEM-ID        TO WS-WO-ITEM-ID(WS-WO-REC-INDX)  
               MOVE WS-AR-RECEIVABLE-GL TO                              
                                          WS-GL-ACCT-CR(WS-WO-REC-INDX) 
               MOVE WS-WO-GL-NO         TO                              
                                          WS-GL-ACCT-DR(WS-WO-REC-INDX) 
               SET WS-WO-REC-INDX UP BY +1                              
      *                                                                         
             WHEN WS-CCC-PYMT-PRTY                                      
               EVALUATE TRUE                                            
                 WHEN ELECTRIC-ACCT AND GAS-ACCT                        
                   IF MORE-ELEC-RCC                                     
                     MOVE WS-00-DAY-UTE TO WS-WO-00-DAY(WS-WO-REC-INDX) 
                     MOVE WS-30-DAY-UTE TO WS-WO-30-DAY(WS-WO-REC-INDX) 
                     MOVE WS-60-DAY-UTE TO WS-WO-60-DAY(WS-WO-REC-INDX) 
                     MOVE WS-90-DAY-UTE TO WS-WO-90-DAY(WS-WO-REC-INDX) 
                     MOVE AC-ITEM-ID    TO WS-WO-ITEM-ID(WS-WO-REC-INDX)
      *                                                                         
                     MOVE WS-GL-ACCOUNT-NO-DR(WS-WO-INDX) TO            
                                          WS-GL-ACCT-DR(WS-WO-REC-INDX) 
                     MOVE WS-GL-ACCOUNT-NO-CR(WS-WO-INDX) TO            
                                          WS-GL-ACCT-CR(WS-WO-REC-INDX) 
                     SET WS-WO-REC-INDX UP BY +1                        
                     MOVE 'Y' TO WS-DONE-RCC-ELEC                       
                   ELSE                                                 
                     MOVE WS-00-DAY-UTG TO WS-WO-00-DAY(WS-WO-REC-INDX) 
                     MOVE WS-30-DAY-UTG TO WS-WO-30-DAY(WS-WO-REC-INDX) 
                     MOVE WS-60-DAY-UTG TO WS-WO-60-DAY(WS-WO-REC-INDX) 
                     MOVE WS-90-DAY-UTG TO WS-WO-90-DAY(WS-WO-REC-INDX) 
                     MOVE AC-ITEM-ID    TO WS-WO-ITEM-ID(WS-WO-REC-INDX)
      *                                                                         
                     MOVE WS-GL-ACCOUNT-NO-DR(WS-WO-INDX) TO            
                                          WS-GL-ACCT-DR(WS-WO-REC-INDX) 
                     MOVE WS-GL-ACCOUNT-NO-CR(WS-WO-INDX) TO            
                                          WS-GL-ACCT-CR(WS-WO-REC-INDX) 
                     SET WS-WO-REC-INDX UP BY +1                        
                     MOVE 'N' TO WS-DONE-RCC-ELEC                       
                   END-IF                                               
      *                                                                         
                 WHEN ELECTRIC-ACCT                                     
                     MOVE WS-00-DAY-UTE TO WS-WO-00-DAY(WS-WO-REC-INDX) 
                     MOVE WS-30-DAY-UTE TO WS-WO-30-DAY(WS-WO-REC-INDX) 
                     MOVE WS-60-DAY-UTE TO WS-WO-60-DAY(WS-WO-REC-INDX) 
                     MOVE WS-90-DAY-UTE TO WS-WO-90-DAY(WS-WO-REC-INDX) 
                     MOVE AC-ITEM-ID    TO WS-WO-ITEM-ID(WS-WO-REC-INDX)
      *                                                                         
                     MOVE WS-GL-ACCOUNT-NO-DR(WS-WO-INDX) TO            
                                          WS-GL-ACCT-DR(WS-WO-REC-INDX) 
                     MOVE WS-GL-ACCOUNT-NO-CR(WS-WO-INDX) TO            
                                          WS-GL-ACCT-CR(WS-WO-REC-INDX) 
                     SET WS-WO-REC-INDX UP BY +1                        
      *                                                                         
                 WHEN GAS-ACCT                                          
                     MOVE WS-00-DAY-UTG TO WS-WO-00-DAY(WS-WO-REC-INDX) 
                     MOVE WS-30-DAY-UTG TO WS-WO-30-DAY(WS-WO-REC-INDX) 
                     MOVE WS-60-DAY-UTG TO WS-WO-60-DAY(WS-WO-REC-INDX) 
                     MOVE WS-90-DAY-UTG TO WS-WO-90-DAY(WS-WO-REC-INDX) 
                     MOVE AC-ITEM-ID    TO WS-WO-ITEM-ID(WS-WO-REC-INDX)
      *                                                                         
                     MOVE WS-GL-ACCOUNT-NO-DR(WS-WO-INDX) TO            
                                          WS-GL-ACCT-DR(WS-WO-REC-INDX) 
                     MOVE WS-GL-ACCOUNT-NO-CR(WS-WO-INDX) TO            
                                          WS-GL-ACCT-CR(WS-WO-REC-INDX) 
                     SET WS-WO-REC-INDX UP BY +1                        
                 END-EVALUATE                                           
      *                                                                         
             WHEN WS-LPC-PYMT-PRTY                                      
               EVALUATE TRUE                                            
                 WHEN ELECTRIC-ACCT AND GAS-ACCT                        
                   IF MORE-ELEC                                         
                     MOVE WS-00-DAY-UTE TO WS-WO-00-DAY(WS-WO-REC-INDX) 
                     MOVE WS-30-DAY-UTE TO WS-WO-30-DAY(WS-WO-REC-INDX) 
                     MOVE WS-60-DAY-UTE TO WS-WO-60-DAY(WS-WO-REC-INDX) 
                     MOVE WS-90-DAY-UTE TO WS-WO-90-DAY(WS-WO-REC-INDX) 
                     MOVE AC-ITEM-ID    TO WS-WO-ITEM-ID(WS-WO-REC-INDX)
      *                                                                         
                     MOVE WS-GL-ACCOUNT-NO-DR(WS-WO-INDX) TO            
                                          WS-GL-ACCT-DR(WS-WO-REC-INDX) 
                     MOVE WS-GL-ACCOUNT-NO-CR(WS-WO-INDX) TO            
                                          WS-GL-ACCT-CR(WS-WO-REC-INDX) 
                     SET WS-WO-REC-INDX UP BY +1                        
                     MOVE 'Y' TO WS-DONE-LPC-ELEC                       
                   ELSE                                                 
                     MOVE WS-00-DAY-UTG TO WS-WO-00-DAY(WS-WO-REC-INDX) 
                     MOVE WS-30-DAY-UTG TO WS-WO-30-DAY(WS-WO-REC-INDX) 
                     MOVE WS-60-DAY-UTG TO WS-WO-60-DAY(WS-WO-REC-INDX) 
                     MOVE WS-90-DAY-UTG TO WS-WO-90-DAY(WS-WO-REC-INDX) 
                     MOVE AC-ITEM-ID    TO WS-WO-ITEM-ID(WS-WO-REC-INDX)
      *                                                                         
                     MOVE WS-GL-ACCOUNT-NO-DR(WS-WO-INDX) TO            
                                          WS-GL-ACCT-DR(WS-WO-REC-INDX) 
                     MOVE WS-GL-ACCOUNT-NO-CR(WS-WO-INDX) TO            
                                          WS-GL-ACCT-CR(WS-WO-REC-INDX) 
                     SET WS-WO-REC-INDX UP BY +1                        
                     MOVE 'N' TO WS-DONE-LPC-ELEC                       
                   END-IF                                               
      *                                                                         
                 WHEN ELECTRIC-ACCT                                     
                     MOVE WS-00-DAY-UTE TO WS-WO-00-DAY(WS-WO-REC-INDX) 
                     MOVE WS-30-DAY-UTE TO WS-WO-30-DAY(WS-WO-REC-INDX) 
                     MOVE WS-60-DAY-UTE TO WS-WO-60-DAY(WS-WO-REC-INDX) 
                     MOVE WS-90-DAY-UTE TO WS-WO-90-DAY(WS-WO-REC-INDX) 
                     MOVE AC-ITEM-ID    TO WS-WO-ITEM-ID(WS-WO-REC-INDX)
      *                                                                         
                     MOVE WS-GL-ACCOUNT-NO-DR(WS-WO-INDX) TO            
                                          WS-GL-ACCT-DR(WS-WO-REC-INDX) 
                     MOVE WS-GL-ACCOUNT-NO-CR(WS-WO-INDX) TO            
                                          WS-GL-ACCT-CR(WS-WO-REC-INDX) 
                     SET WS-WO-REC-INDX UP BY +1                        
      *                                                                         
                 WHEN GAS-ACCT                                          
                     MOVE WS-00-DAY-UTG TO WS-WO-00-DAY(WS-WO-REC-INDX) 
                     MOVE WS-30-DAY-UTG TO WS-WO-30-DAY(WS-WO-REC-INDX) 
                     MOVE WS-60-DAY-UTG TO WS-WO-60-DAY(WS-WO-REC-INDX) 
                     MOVE WS-90-DAY-UTG TO WS-WO-90-DAY(WS-WO-REC-INDX) 
                     MOVE AC-ITEM-ID    TO WS-WO-ITEM-ID(WS-WO-REC-INDX)
      *                                                                         
                     MOVE WS-GL-ACCOUNT-NO-DR(WS-WO-INDX) TO            
                                          WS-GL-ACCT-DR(WS-WO-REC-INDX) 
                     MOVE WS-GL-ACCOUNT-NO-CR(WS-WO-INDX) TO            
                                          WS-GL-ACCT-CR(WS-WO-REC-INDX) 
                     SET WS-WO-REC-INDX UP BY +1                        
                                                                        
               END-EVALUATE                                             
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       3402-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  00271000
      **                                                            **  00271500
      **    3405-FMT-AR-TRANS-HDR.                                  **  00272000
      **        FORMATS COMMON FIELDS FOR AR TRANS HIST             **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
      *                                                                         
       3405-FMT-AR-TRANS-HDR.                                           
      *                                                                         
           PERFORM 7270-SELECT-TIMESTAMP            THRU 7270-EXIT.     
      *                                                                         
           MOVE WS-ACCOUNT-NBR         TO AR-ACCOUNT-NO.                
           MOVE WS-TIMESTAMP           TO AR-TRANS-HIST-SEQ-NO.         
           MOVE WS-CURRENT-DATE        TO AR-DATE-TRANS                 
                                          AR-DATE-CASH-REPORT.          
           MOVE WS-PGRMNAME            TO AR-APPL-PROGRAM-ID.           
           IF SUBSEQUENT-WO                                             
              MOVE 'PCSKR400A'         TO AR-APPL-PROGRAM-ID            
           END-IF.                                                      
           MOVE WS-SYSTEM              TO AR-USER-ID.                   
           MOVE WS-COMPANY-NO          TO AR-COMPANY-NO.                
           MOVE 'N'                    TO AR-RECORD-ONLY-FL.            
           MOVE SPACES                 TO AR-RESP-AREA-ID,              
                                          AR-PYMT-FACILITY-CD,          
                                          AR-TRAN-COMMENT-TEXT,         
                                          AR-DATE-ORIG-PYMT,            
                                          AR-PYMT-REFUNDED-IND.         
           MOVE ZEROES                 TO AR-TRAN-COMMENT-LEN.          
           MOVE ZERO                   TO AR-AMT-BILLED-UNPAID.         
           MOVE ZERO                   TO AR-AMT-ORIG-ENTERED.          
           MOVE WS-CASH-COMPANY-NO     TO AR-CASH-COMPANY-NO.           
           MOVE -1                     TO WS-DATE-ORIG-PYMT-IND.        
           MOVE AT-LOCAL-OFFICE        TO AR-CASH-LOCAL-OFFICE.         
           MOVE WS-CASH-REPORT-NO      TO AR-CASH-REPORT-NO.            
           MOVE WS-CASH-DRAWER-ID      TO AR-CASH-DRAWER-ID.            
      *                                                                         
       3405-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    3410-CREATE-CORRECT-GL-NUM                              **  00272000
      **        CREATE CORRECT GL NUMBER FOR JOURNAL UPDATE         **  00273000
      **                                                            **  00273000
      ** CALLED BY:                                                 **  00273000
      ****************************************************************  00273500
       3410-CREATE-CORRECT-GL-NUM.                                      
      *                                                                         
           EVALUATE TRUE                                                
             WHEN WS-UTLE-PYMT-PRTY                                     
               MOVE WS-AR-UTE-GL-NO(WS-GL-SUB) TO WS-AR-RECEIVABLE-GL   
               MOVE WS-WO-UTE-GL-NO(WS-GL-SUB) TO WS-WO-GL-NO           
             WHEN WS-UTLG-PYMT-PRTY                                     
               MOVE WS-AR-UTG-GL-NO(WS-GL-SUB) TO WS-AR-RECEIVABLE-GL   
               MOVE WS-WO-UTG-GL-NO(WS-GL-SUB) TO WS-WO-GL-NO           
             WHEN WS-NSF-PYMT-PRTY                                      
               MOVE WS-AR-NSC-GL-NO(WS-GL-SUB) TO WS-AR-RECEIVABLE-GL   
               MOVE WS-WO-NSC-GL-NO(WS-GL-SUB) TO WS-WO-GL-NO           
             WHEN WS-NSA-PYMT-PRTY                                      
               MOVE WS-AR-NSA-GL-NO(WS-GL-SUB) TO WS-AR-RECEIVABLE-GL   
               MOVE WS-WO-NSA-GL-NO(WS-GL-SUB) TO WS-WO-GL-NO           
             WHEN WS-NSN-PYMT-PRTY                                      
               MOVE WS-AR-NSN-GL-NO(WS-GL-SUB) TO WS-AR-RECEIVABLE-GL   
               MOVE WS-WO-NSN-GL-NO(WS-GL-SUB) TO WS-WO-GL-NO           
             WHEN WS-LPN-PYMT-PRTY                                      
               MOVE WS-AR-LPN-GL-NO(WS-GL-SUB) TO WS-AR-RECEIVABLE-GL   
               MOVE WS-WO-LPN-GL-NO(WS-GL-SUB) TO WS-WO-GL-NO           
           END-EVALUATE.                                                
      *                                                                         
       3410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    3500-PROCESS-TRANS-DETAIL                               **  00272000
      **                                                            **  00271500
      **    THIS MODULE STEPS THROUGH WS-WO-REC-ENTRY INTERNAL      **  00271500
      **    TABLE TO WRITE THE TRANSACTION HISTORY DETAIL FOR       **          
      **    UTE, UTG, LPN, NSA, NSN, NSC, RCC, LPC.                 **          
      **    THE INFORMATION IN WS-WO-REC-ENTRY HAS BEEN CAPTURED    **          
      **    IN EARLIER PROCESSING.  THIS MODULE DOES NOT WRITE      **          
      **    CONTRACT RECEIVABLE DETAILS; AN EARLIER PROCESS WRITES  **          
      **    THE TRAN DETAIL ROWS FOR CNT.                           **          
      **                                                            **          
      ****************************************************************  00273500
      *                                                                         
       3500-PROCESS-TRANS-DETAIL.                                       
      *                                                                         
           MOVE 1                 TO WS-WO-REC-SUB.                     
                                                                        
           PERFORM UNTIL WS-WO-REC-SUB = WS-WO-REC-INDX                 
      *                                                                         
               IF WS-WO-90-DAY(WS-WO-REC-SUB) > 0                       
      *                                                                         
                   MOVE WS-WO-90-DAY(WS-WO-REC-SUB)                     
                                  TO AU-AMT-POSTED                      
                   MOVE 9         TO AU-CODE-AR-AGE                     
      *                                                                         
                   PERFORM 3505-PROCESS-AR-TRN-DET    THRU 3505-EXIT    
               END-IF                                                   
      *                                                                         
               IF WS-WO-60-DAY(WS-WO-REC-SUB) > 0                       
                   MOVE WS-WO-60-DAY(WS-WO-REC-SUB)                     
                                  TO AU-AMT-POSTED                      
                   MOVE 6         TO AU-CODE-AR-AGE                     
      *                                                                         
                   PERFORM 3505-PROCESS-AR-TRN-DET    THRU 3505-EXIT    
               END-IF                                                   
      *                                                                         
               IF WS-WO-30-DAY(WS-WO-REC-SUB) > 0                       
                   MOVE WS-WO-30-DAY(WS-WO-REC-SUB)                     
                                  TO AU-AMT-POSTED                      
                   MOVE 3         TO AU-CODE-AR-AGE                     
      *                                                                         
                   PERFORM 3505-PROCESS-AR-TRN-DET    THRU 3505-EXIT    
               END-IF                                                   
      *                                                                         
               IF WS-WO-00-DAY(WS-WO-REC-SUB) > 0                       
                   MOVE WS-WO-00-DAY(WS-WO-REC-SUB)                     
                                  TO AU-AMT-POSTED                      
                   MOVE 0         TO AU-CODE-AR-AGE                     
      *                                                                         
                   PERFORM 3505-PROCESS-AR-TRN-DET    THRU 3505-EXIT    
               END-IF                                                   
                                                                        
               ADD 1 TO WS-WO-REC-SUB                                   
           END-PERFORM.                                                 
      *                                                                         
       3500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *3406-PROCESS-AR-TRN-DET.                                                 
      ******************************************************************        
       3505-PROCESS-AR-TRN-DET.                                         
      *                                                                         
           MOVE WS-ACCOUNT-NBR          TO AU-ACCOUNT-NO.               
           MOVE WS-TIMESTAMP            TO AU-TRANS-HIST-SEQ-NO.        
                                                                        
           ADD +1       TO WS-JRNL-TRAN-APPL-NO.                        
      *                                                                         
           MOVE WS-JRNL-TRAN-APPL-NO    TO AU-TRAN-APPL-NO.             
      *                                                                         
           MOVE WS-GL-ACCT-CR(WS-WO-REC-SUB)                            
                                        TO AU-GL-ACCT-CREDIT.           
           MOVE WS-GL-ACCT-DR(WS-WO-REC-SUB)                            
                                        TO AU-GL-ACCT-DEBIT.            
           MOVE WS-WO-ITEM-ID(WS-WO-REC-SUB)                            
                                        TO AU-ITEM-ID.                  
      *                                                                         
           MOVE SPACES                  TO AU-CODE-CONTRACT-TYPE        
                                           AU-CURRENCY-TYPE.            
      *                                                                         
           MOVE ZERO                    TO AU-CURRENCY-AMT.             
      *                                                                         
           PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST THRU 6500-EXIT.        
      *                                                                         
       3505-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    3510-CONTROL-ADDL-PROCESSING                            **  00272000
      **                                                            **  00273000
      ** CALLED BY: 2000-CONTROL-CHARGE-OFFS                        **  00273000
      ****************************************************************  00273500
       3510-CONTROL-ADDL-PROCESSING.                                    
      *                                                                         
           IF CHARGE-OFF-WAS-COMPLETE                                   
               PERFORM 3520-DELETE-ADDL-INFO     THRU 3520-EXIT         
           END-IF.                                                      
      *                                                                         
       3510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00273500
      **                                                            **  00271500
      **    3520-DELETE-ADDL-INFO                                   **  00272000
      **                                                            **  00271500
      ** CALLED BY: 3510-CONTROL-ADDL-PROCESSING.                   **  00271500
      ****************************************************************  00273500
       3520-DELETE-ADDL-INFO.                                           
      *                                                                         
           MOVE SPACE                  TO WS-CODE-BANK-EFT.             
           PERFORM 8421-UPDT-BANK-EFT            THRU 8421-EXIT.        
      *                                                                         
           IF WS-PREMISE-NO EQUAL ZEROES                                
               CONTINUE                                                 
           ELSE                                                         
               MOVE SPACES             TO PR-SPCL-READ-INSTR-TEXT       
               MOVE ZEROS              TO PR-SPCL-READ-INSTR-LEN        
               PERFORM 8423-REPL-READ-INSTRUCTIONS                      
                                                 THRU 8423-EXIT         
           END-IF.                                                      
      *                                                                         
       3520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00273500
      **                                                            **  00271500
      **    4000-PROCESS-ACTIVE-REC                                 **  00272000
      **                                                            **  00271500
      **    PROCESSES WRITTEN OFF ACCOUNTS WITH ACTIVE RECEIVABLES. **          
      **    THE ACTIVE RECEIVABLE WILL BE DELETED FROM CSS_AR_CNTL, **          
      **    JOURNALED, CREATED OR UPDATED ON CSS_CHRG_OFF.  ALL     **          
      **    ACTIVE RECEIVABLES ARE ELIGIBLE EXCEPT PPL50 EPP,       **          
      **    PPL80 DEP, PPL90 DFA, PPL129 PJS, AND PPL70 CIA.        **          
      **                                                            **          
      ****************************************************************  00273500
      *                                                                         
       4000-PROCESS-ACTIVE-REC.                                         
      *                                                                         
           MOVE SPACES TO WS-BANKRUPTCY-IND.                            
      *                                                                         
           PERFORM 7900-OPEN-WO-ACCT-ACT-REC          THRU 7900-EXIT.   
      *                                                                         
           PERFORM 7905-FETCH-WO-ACCT-ACT-REC         THRU 7905-EXIT.   
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
             MOVE AT-ACCOUNT-NO                TO WS-ACCOUNT-NO         
             PERFORM 5200-CHK-SKIP-ACCTS       THRU 5200-CPD347-EXIT    
             IF PROCESS-ACCT                                            
               MOVE 'N'                TO WS-SUBSEQUENT-WO-FL           
               MOVE AT-CODES-DATA-PRESENT                               
                                       TO WS-CODES-DATA-PRESENT         
               MOVE AT-ACCOUNT-NO      TO WS-ACCOUNT-NBR                
                                          AC-ACCOUNT-NO                 
               MOVE AT-LOCAL-OFFICE    TO WS-LOCAL-OFFICE-NO            
               MOVE AT-COMPANY-NO      TO WS-COMPANY-NO                 
                                          WS-COMPANY-NO-X               
                                          WS-COMPANY-NO-DELINQ          
               MOVE AT-CUSTOMER-NO     TO WS-CUSTOMER-NO                
               MOVE AT-PREMISE-NO      TO WS-PREMISE-NO                 
      *                                                                         
               PERFORM 1590-CHK-FOR-INVALID-RCVBLES  THRU 1590-EXIT     
                                                                        
               PERFORM 7466-PERFORM-VALID-RCVBLES THRU 7466-EXIT        
               MOVE WS-TOT-VAL-RCVBLE TO WS-WO-TOTAL                    
      *                                                                         
               MOVE WS-WO-TOTAL                TO WS-TOTAL-AR-BALANCE   
               IF WS-WO-TOTAL > 0                                       
                  MOVE AT-ACCOUNT-NO         TO CO-ACCOUNT-NO           
                  PERFORM 7906-SELECT-CHRG-OFF          THRU 7906-EXIT  
                  IF WS-CHRG-OFF-EXISTS = 'Y'                           
                     SET SUBSEQUENT-WO   TO TRUE                        
                     PERFORM 3405-FMT-AR-TRANS-HDR      THRU 3405-EXIT  
      *                                                                         
                     MOVE WS-W           TO AR-CODE-TRAN-TYPE           
                     MOVE WS-WO-TOTAL    TO AR-AMT-ORIG-ENTERED         
                     MOVE ZERO           TO WS-JRNL-TRAN-APPL-NO        
                                            WS-PREV-TRAN-APPL-NO        
                                            WS-BATCH-TRAN-APPL-NO       
     *                                                                  
                     PERFORM 7915-OPEN-WO-CUST-RECEIVABLE               
                                                        THRU 7915-EXIT  
                     PERFORM 7920-FETCH-WO-CUST-RECEIVABLE              
                                                        THRU 7920-EXIT  
                     SET WS-WO-REC-INDX  TO +1                          
      *                                                                         
                     PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND
                             OR WS-ZERO-CNT-WO-GL                       
                        PERFORM 3100-CNTRL-AR-PROCESSING                
                                                        THRU 3100-EXIT  
                        IF WS-CALLED-PGM-BAD-RC                         
                            PERFORM 7925-CLOSE-WO-CUST-RECEIVABLE       
                                                        THRU 7925-EXIT  
                            PERFORM 7910-CLOSE-WO-ACCT-ACT-REC          
                                                        THRU 7910-EXIT  
                            GO TO 4000-EXIT                             
                        END-IF                                          
                        PERFORM 7920-FETCH-WO-CUST-RECEIVABLE           
                                                        THRU 7920-EXIT  
                     END-PERFORM                                        
      *                                                                         
                     PERFORM 7925-CLOSE-WO-CUST-RECEIVABLE              
                                                        THRU 7925-EXIT  
                     IF  WS-ZERO-CNT-WO-GL                              
                         MOVE 'N'        TO WS-ZERO-CNT-WO-GL-FL        
                     ELSE                                               
                         PERFORM 3500-PROCESS-TRANS-DETAIL              
                                                        THRU 3500-EXIT  
                         PERFORM 5000-UPDATE-ACCOUNT    THRU 5000-EXIT  
                     END-IF                                             
                  END-IF                                                
               END-IF                                                   
             END-IF                                                     
      *                                                                         
               PERFORM 7905-FETCH-WO-ACCT-ACT-REC     THRU 7905-EXIT    
      *                                                                         
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7910-CLOSE-WO-ACCT-ACT-REC         THRU 7910-EXIT.   
      *                                                                         
       4000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************  00273500
      **                                                            **  00271500
      **    4010-PROCESS-COLL-AGY-TOTALS                            **  00272000
      **                                                            **  00271500
      **    UPDATE WRITE OFF AMOUNT FOR THE COLLECTION AGENCY       **          
      **    TOTALS TABLE.                                           **          
      **                                                            **          
      ****************************************************************  00273500
      *                                                                         
       4010-PROCESS-COLL-AGY-TOTALS.                                    
      *                                                                         
           MOVE WS-ACCOUNT-NBR        TO CO-ACCOUNT-NO                  
                                         LR-ACCOUNT-NO.                 
      *                                                                         
           IF SEB-DATABASE                                              
                MOVE FW-REG-GROUP-CD TO LR-REG-GROUP-CD                 
           ELSE                                                         
                MOVE SPACES        TO   LR-REG-GROUP-CD                 
           END-IF.                                                      
                                                                        
      *                                                                         
           MOVE LR-REG-GROUP-CD       TO SN-REG-GROUP-CD.               
           MOVE AT-COMPANY-NO         TO SN-COMPANY-NO.                 
           MOVE IZ-CODE-COLLEC-AGNCY  TO SN-CODE-COLLEC-AGNCY.          
           MOVE KD-FW-ACTION-DT(1:4)                                    
                                      TO WS-WO-MTH-YR-X(1:4).           
           MOVE KD-FW-ACTION-DT(6:2)                                    
                                      TO WS-WO-MTH-YR-X(5:2).           
           MOVE WS-WO-MTH-YR-X        TO SN-WRITE-OFF-MONTH-YR.         
      *                                                                         
           PERFORM 7400-GET-COLLEC-AGNCY-WO-TOT  THRU 7400-EXIT.        
      *                                                                         
           ADD WS-CHG-OFF-ACTUAL-BAL  TO  SN-WRITE-OFF-AMT.             
           PERFORM 8050-UPDATE-COLL-AGY-WO-TOT   THRU 8050-EXIT.        
      *                                                                         
       4010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00273500
      **                                                            **  00271500
      **    4100-PROCESS-REFORECAST                                 **  00272000
      **                                                            **  00271500
      **    PROCESSES FINALLED ACCOUNTS WITH DEBIT BALANCES AFTER   **          
      **    WRITE OFF DATE TO BE REFORECASTED FOR WRITE OFF.        **          
      **    ALSO UPDATES MNT_TRANS_HIST TO SHOW PREVIOUS AND        **          
      **    CHANGED VALUES FOR THE RE FORECASTED DATES SUCH AS      **          
      **    FOUTH FINAL DATE,WRITE OFF DATE,FIRST CREDIT LETTER     **          
      **    DATE,COLLECTION DATE AND CREDIT BUREAU DATE.            **          
      **                                                            **          
      ****************************************************************  00273500
      *                                                                         
       4100-PROCESS-REFORECAST.                                         
      *                                                                         
           PERFORM 5310-CALC-PROCESS-DATE             THRU 5310-EXIT.   
           PERFORM 7550-OPEN-REFORECAST-WO            THRU 7550-EXIT.   
           PERFORM 7555-FETCH-REFORECAST-WO           THRU 7555-EXIT.   
           PERFORM 4200-REFORECAST-WO                 THRU 4200-EXIT    
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
           PERFORM 7560-CLOSE-REFORECAST-WO           THRU 7560-EXIT.   
           DISPLAY '*** REFORECAST PROCESSING DONE        ***'.         
      *                                                                         
       4100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00273500
      **                                                            **  00271500
      **    4200-REFORECAST-WO                                      **  00272000
      **                                                            **  00271500
      ****************************************************************  00273500
      *                                                                         
       4200-REFORECAST-WO.                                              
      *                                                                         
           MOVE AT-ACCOUNT-NO                TO WS-ACCOUNT-NO.          
           PERFORM 5200-CHK-SKIP-ACCTS       THRU 5200-CPD347-EXIT.     
           IF PROCESS-ACCT                                              
             IF WORK-DAYS-NOT-LOADED                                    
                PERFORM 0160-LOAD-WORK-DAYS             THRU 0160-EXIT  
                SET WORK-DAYS-LOADED TO TRUE                            
             END-IF                                                     
             MOVE AT-ACCOUNT-NO      TO WS-ACCOUNT-NO-NUM               
             PERFORM 7960-CHECK-WO-EXISTS                THRU 7960-EXIT 
             IF WO-DATE-EXISTS                                          
                CONTINUE                                                
             ELSE                                                       
                DISPLAY 'ACCOUNT NO BEING PROCESSED'  WS-ACCOUNT-NO-NUM 
                PERFORM 4220-PROCESS-REFORECAST         THRU 4220-EXIT  
             END-IF                                                     
           END-IF.                                                      
           PERFORM 7555-FETCH-REFORECAST-WO           THRU 7555-EXIT.   
      *                                                                         
       4200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 4220-PROCESS-REFORECAST                                                 
      ******************************************************************        
       4220-PROCESS-REFORECAST.                                         
      *                                                                         
           INITIALIZE WRITE-OFF-INDX                                    
                      WS-RFCST-ACTN-FOUND                               
                      WS-FCST-ACTN                                      
                      WS-TRAN-APPL-NO                                   
           PERFORM 4225-REFORECAST-WO-ACTION          THRU 4225-EXIT.   
      *                                                                         
           IF RFCST-ACTN-FOUND                                          
              PERFORM 4230-REFORECAST-ACTION          THRU 4230-EXIT    
              MOVE 'N'  TO WS-RFCST-ACTN-FOUND                          
           END-IF.                                                      
      *                                                                         
       4220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 4225-REFORECAST-WO-ACTION                                      *        
      ******************************************************************        
       4225-REFORECAST-WO-ACTION.                                       
                                                                        
           PERFORM 7676-GET-PATH-TYPE-CODE          THRU 7676-EXIT.     
                                                                        
           IF SEB-DATABASE                                              
                MOVE FW-REG-GROUP-CD TO LR-REG-GROUP-CD                 
           ELSE                                                         
                MOVE SPACES        TO   LR-REG-GROUP-CD                 
           END-IF.                                                      
                                                                        
           MOVE FW-FW-PATH-TYPE-CD       TO WS-FW-PATH-TYPE-CD.         
                                                                        
           MOVE 'Y'                      TO WS-FST-OCCUR.               
           MOVE 'N'                      TO WS-RFCST-ACTN-FOUND         
                                            WS-NEW-ACTN-INSERT          
                                            WS-RFCST-ACTN-INSERT.       
                                                                        
           IF WS-FW-PATH-TYPE-CD NOT EQUAL SPACES                       
               PERFORM VARYING WS-FIN-INDX FROM 1 BY 1                  
SCA006           UNTIL RFCST-ACTN-FOUND OR 
                       WS-FIN-INDX > 4000 OR 
                       WS-COMPANY-NO-F8-TBL(WS-FIN-INDX) = SPACES               
                    IF WS-COMPANY-NO-F8-TBL(WS-FIN-INDX)                
                                       = AT-COMPANY-NO    AND           
                       WS-REG-GROUP-CD-F8-TBL(WS-FIN-INDX)              
                                       = LR-REG-GROUP-CD  AND           
                       WS-FW-PATH-TYPE-CD-F8-TBL(WS-FIN-INDX)           
                                     = WS-FW-PATH-TYPE-CD AND           
                       WS-FW-FRCST-TIME-CD-F8(WS-FIN-INDX) = 'R'        
                                                                        
                       PERFORM 5525-REFORECAST-WO-ACTION                
                          THRU 5525-EXIT                                
                    END-IF                                              
               END-PERFORM                                              
           END-IF.                                                      
      *                                                                         
       4225-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 4230-REFORECAST-ACTION                                         *        
      ******************************************************************        
       4230-REFORECAST-ACTION.                                          
      *                                                                         
                                                                        
           MOVE FW-FW-PATH-TYPE-CD       TO WS-FW-PATH-TYPE-CD.         
      *                                                                         
           MOVE KD-FW-ACTION-TYPE-CD     TO WS-FW-ACTION-TYPE-CD-2.     
                                                                        
           MOVE 'Y'                      TO WS-FST-OCCUR.               
                                                                        
           IF WS-FW-PATH-TYPE-CD NOT EQUAL SPACES                       
               PERFORM VARYING WS-FIN-INDX FROM 1 BY 1                  
SCA006           UNTIL NO-MORE-FCST-ACTN OR 
                       WS-FIN-INDX > 4000 OR 
                       WS-COMPANY-NO-F8-TBL(WS-FIN-INDX) = SPACES               
                    IF WS-COMPANY-NO-F8-TBL(WS-FIN-INDX)                
                                     = AT-COMPANY-NO      AND           
                       WS-REG-GROUP-CD-F8-TBL(WS-FIN-INDX)              
                                     = LR-REG-GROUP-CD    AND           
                       WS-FW-PATH-TYPE-CD-F8-TBL(WS-FIN-INDX)           
                                     = WS-FW-PATH-TYPE-CD AND           
                       WS-FW-ACTION-TYPE-F8(WS-FIN-INDX)                
                                     = WS-FW-ACTION-TYPE-CD-2 AND       
                       WS-FW-FRCST-TIME-CD-F8 (WS-FIN-INDX) = 'F'       
      *                                                                         
                       SET FCST-ACTN TO TRUE                            
                       PERFORM 5550-REFORECAST-ACTIONS                  
                          THRU 5550-EXIT                                
                         UNTIL NO-MORE-FCST-ACTN                        
                            OR WS-FIN-INDX > 4000                       
                    END-IF                                              
               END-PERFORM                                              
           END-IF.                                                      
      *                                                                         
       4230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    5000-UPDATE-ACCOUNT                                     **  00272000
      **        FORMAT DATA FOR UPDATE OF ACCOUNT TABLE             **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       5000-UPDATE-ACCOUNT.                                             
      *                                                                         
           IF WS-UPDATE-PROCESSING EQUAL 'N'                            
               MOVE WS-TOTAL-AR-BALANCE    TO AT-TOTAL-AR-BALANCE       
           ELSE                                                         
               SUBTRACT WS-WO-TOTAL        FROM AT-TOTAL-AR-BALANCE     
           END-IF.                                                      
      *                                                                         
           MOVE WS-CURRENT-DATE        TO AT-DATE-LAST-ACTION.          
           MOVE WS-S                   TO AT-CODE-ACCT-STAT.            
           MOVE WS-A                   TO WS-CODE-CHRG-OFF.             
           MOVE WS-CODES-DATA-PRESENT  TO AT-CODES-DATA-PRESENT.        
      *                                                                 00691000
           PERFORM 8500-REPL-ACCOUNT             THRU 8500-EXIT.        
      *                                                                 00691000
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5310-CALC-PROCESS-DATE                                         *        
      ******************************************************************        
       5310-CALC-PROCESS-DATE.                                          
                                                                        
           MOVE 'WO'                   TO F8-FW-BUS-PROCESS-CD.         
           MOVE WS-INPUT-DATE          TO WS-CWS337-PROCESS-DATE.       
           MOVE AT-COMPANY-NO          TO WS-FW-COMPANY.                
           MOVE FW-REG-GROUP-CD        TO WS-REG-GROUP-CD.              
           MOVE 'DE'                   TO WS-FW-PATH-TYPE-CD.           
           MOVE 'FBDAY'                TO WS-FW-ACTION-TYPE-CD.         
      *                                                                         
           PERFORM 5100-GET-FCST-ACTN-DATA    THRU 5100-CPD337-EXIT.    
           PERFORM 5150-VERIFY-DW-VARIABLES   THRU 5150-EXIT.           
           MOVE WS-FW-FCST-DAYS-NM     TO WS-NO-DAYS.                   
      *                                                                         
           MOVE WS-INPUT-DATE          TO WS-NEW-BUSINESS-DAY.          
           MOVE WS-NO-DAYS             TO WS-NO-OF-DAY.                 
           PERFORM 6525-PREV-BUSINESS-DAY                               
              THRU 6525-PREV-BUSINESS-DAY-EXIT.                         
      *                                                                         
           MOVE WS-NEW-BUSINESS-DAY    TO WS-FIN-PROCESS-DT.            
                                                                        
           MOVE WS-FIN-PROCESS-DT    TO WS-FINAL-PROCESS-DT.            
                                                                        
           DISPLAY 'REFCSTNG ACCTS WITH FB DATE < ' WS-FIN-PROCESS-DT.  
                                                                        
       5310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5500-FORECAST-ACTIONS                                          *        
      ******************************************************************        
       5500-FORECAST-ACTIONS.                                           
                                                                        
           MOVE WS-FW-ACTION-TYPE-F8(WS-FIN-INDX)                       
                                  TO KD-FW-ACTION-TYPE-CD.              
                                                                        
AC4527     MOVE WS-FW-BUS-PROCESS-CD-F8 (WS-FIN-INDX)                   
AC4527                            TO KD-FW-BUS-PROCESS-CD.              
                                                                        
           IF ((WS-FST-OCCUR                         = 'Y') AND         
              (WS-FW-FRCST-SOURCE-CD-F8(WS-FIN-INDX) = 'W'  OR          
              WS-FW-FRCST-SOURCE-CD-F8(WS-FIN-INDX) = 'P'))             
              SET WD-INDX  TO 101                                       
              SET PRV-WD-INDX       TO WD-INDX                          
              MOVE 'N'     TO WS-FST-OCCUR                              
           END-IF.                                                      
                                                                        
                                                                        
           EVALUATE WS-FW-FRCST-SOURCE-CD-F8(WS-FIN-INDX)               
             WHEN 'W'                                                   
                  SET WD-INDX TO 101                                    
                  SET WD-INDX UP BY                                     
                               WS-FW-ACTION-DAYS-F8(WS-FIN-INDX)        
             WHEN 'P'                                                   
                  SET WD-INDX TO PRV-WD-INDX                            
                  SET WD-INDX UP BY                                     
                              WS-FW-ACTION-DAYS-F8(WS-FIN-INDX)         
           END-EVALUATE.                                                
                                                                        
ACT063     IF WD-INDX > 601                                             
              IF WS-INDEX-192 < 750                                     
                 ADD 1 TO WS-INDEX-192                                  
                 MOVE AT-ACCOUNT-NO TO WS-ACCOUNT(WS-INDEX-192)         
                 MOVE '- ERROR IN REFORECASTING INDEX OUT OF BOUNDS.'   
                                   TO WS-REASON(WS-INDEX-192)           
              END-IF                                                    
           ELSE                                                         
              MOVE WS-WORK-DAY(WD-INDX) TO KD-FW-ACTION-DT              
                                                                        
              SET  PRV-WD-INDX          TO WD-INDX                      
                                                                        
              IF WS-SEQ-MATCH-EXIST                                     
                 MOVE WS-FW-ACTION-SEQ-F8 (WS-FIN-INDX)                 
                                           TO KD-FW-SEQ-NO              
              ELSE                                                      
                 MOVE WS-FW-ACTION-SEQ-F8 (WS-FIN-INDX)                 
                                           TO KD-FW-SEQ-NO              
                 ADD WS-WO-SEQ-NO-MAX      TO KD-FW-SEQ-NO              
              END-IF                                                    
                                                                        
              MOVE 0                    TO KD-FW-ACTION-AM              
                                                                        
              MOVE AT-ACCOUNT-NO        TO KD-ACCOUNT-NO                
                                                                        
              MOVE SPACES               TO KD-FW-MANUAL-FL              
                                                                        
              MOVE ZEROS                TO KD-FW-ACTION-COMMENTS-LEN    
                                                                        
              MOVE SPACES               TO KD-FW-ACTION-COMMENTS-TEXT   
                                                                        
              PERFORM 8430-INSERT-FINAL-WO-ACTION   THRU 8430-EXIT      
                                                                        
              IF WS-FW-COLLECTION-FL-F8(WS-FIN-INDX) = 'Y'              
                                                                        
                 MOVE KD-FW-ACTION-TYPE-CD TO IZ-FW-ACTION-TYPE-CD      
                                                                        
                 MOVE KD-FW-SEQ-NO         TO IZ-FW-COLL-SEQ-NO         
                                                                        
                 MOVE KD-ACCOUNT-NO        TO IZ-ACCOUNT-NO             
                                                                        
                 MOVE LR-REG-GROUP-CD      TO IZ-REG-GROUP-CD           
                                                                        
                 MOVE AT-CUSTOMER-NO       TO IZ-CUSTOMER-NO            
                                                                        
                 MOVE SPACES               TO IZ-CODE-COLLEC-AGNCY      
                                                                        
                 MOVE SPACES               TO IZ-COLL-AGY-SUB-CD        
                                                                        
                 MOVE AT-COMPANY-NO        TO IZ-COMPANY-NO             
                                                                        
                 SET WS-FIN-INDX UP BY 1                                
                                                                        
                 SET WD-INDX UP BY                                      
                          WS-FW-ACTION-DAYS-F8(WS-FIN-INDX)             
                                                                        
ACT063           IF WD-INDX > 601                                       
                    IF WS-INDEX-192 < 750                               
                       ADD 1 TO WS-INDEX-192                            
                       MOVE AT-ACCOUNT-NO TO WS-ACCOUNT(WS-INDEX-192)   
                    MOVE '- ERROR IN REFORECASTING INDEX OUT OF BOUNDS.'
                                          TO WS-REASON(WS-INDEX-192)    
                    END-IF                                              
                 ELSE                                                   
                    MOVE WS-WORK-DAY(WD-INDX) TO WS-WITHDRAW-DT         
                                                                        
                    SET  PRV-WD-INDX          TO WD-INDX                
                                                                        
                    MOVE WS-WITHDRAW-DT       TO IZ-WITHDRAW-DT         
                                                                        
                    MOVE ZEROS             TO IZ-WITHDRAW-AM            
                                                                        
                    MOVE SPACES            TO IZ-WITHDRAW-REASON-CD     
                    IF WS-FW-COLLECTION-FL-F8(WS-FIN-INDX) = 'Y'        
                       PERFORM 8440-INSERT-FINAL-WO-COLL                
                                    THRU 8440-EXIT                      
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5525-REFORECAST-WO-ACTION.                                     *        
      ******************************************************************        
       5525-REFORECAST-WO-ACTION.                                       
      *                                                                         
           IF WS-FW-FRCST-TIME-CD-F8(WS-FIN-INDX) = 'R'                 
              SET RFCST-ACTN-FOUND TO TRUE                              
           END-IF                                                       
           MOVE SPACES            TO WS-OLD-ACTION-DT.                  
           MOVE ZEROES            TO WS-OLD-ACTION-AM.                  
           MOVE WS-FW-ACTION-TYPE-F8(WS-FIN-INDX)                       
                                  TO KD-FW-ACTION-TYPE-CD.              
                                                                        
AC4527     MOVE WS-FW-BUS-PROCESS-CD-F8 (WS-FIN-INDX)                   
AC4527                            TO KD-FW-BUS-PROCESS-CD.              
                                                                        
           MOVE WS-FW-ACTION-SEQ-F8(WS-FIN-INDX)                        
                                  TO KD-FW-SEQ-NO.                      
                                                                        
           PERFORM 7370-SELECT-ACTION-AM-SEQ     THRU 7370-EXIT.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-REFRST-ACT-DT   TO WS-OLD-ACTION-DT               
              MOVE KD-FW-ACTION-AM    TO WS-OLD-ACTION-AM               
                                                                        
             MOVE KD-FW-SEQ-NO        TO WS-FW-SEQ-NO                   
                                                                        
             MOVE WS-FW-SEQ-NO        TO WS-FW-COLL-SEQ-NO              
                                                                        
             IF KD-FW-ACTION-AM > 0                                     
                PERFORM 5530-INSERT-RFCST-ACTION                        
                   THRU 5530-EXIT                                       
             ELSE                                                       
                SET WD-INDX TO 101                                      
                SET WD-INDX UP BY WS-FW-ACTION-DAYS-F8(WS-FIN-INDX)     
                SET PRV-WD-INDX       TO WD-INDX                        
                                                                        
                MOVE WS-WORK-DAY(WD-INDX) TO WS-FW-ACTION-DT            
                                             WS-ACTION-DT               
                PERFORM 8445-UPDATE-ACTN-DT          THRU 8445-EXIT     
                                                                        
                  IF WS-FW-COLLECTION-FL-F8(WS-FIN-INDX) = 'Y'          
                                                                        
                     SET WS-FIN-INDX UP BY 1                            
                                                                        
                     SET WD-INDX TO 101                                 
                     SET WD-INDX UP BY                                  
                                 WS-FW-ACTION-DAYS-F8(WS-FIN-INDX)      
                                                                        
                     MOVE WS-WORK-DAY(WD-INDX) TO WS-WITHDRAW-DT        
                                                                        
                     PERFORM 8448-UPDATE-WITHDRAW-DT                    
                        THRU 8448-EXIT                                  
                  END-IF
             END-IF                                                
           ELSE                                                         
               PERFORM 5530-INSERT-RFCST-ACTION                         
                  THRU 5530-EXIT                                        
           END-IF                                                       
                                                                        
           MOVE 1                                   TO  WS-TRAN-APPL-NO 
           PERFORM 5800-MOVE-TRAN-HEAD              THRU 5800-EXIT      
           PERFORM 5850-MOVE-TRAN-DET               THRU 5850-EXIT      
                                                                        
           INITIALIZE WS-SECOND-INVEST-DT                               
                      WS-FORTH-FINAL-DT                                 
                      WS-WRITE-OFF-DT                                   
                      WS-FIRST-CREDIT-LTR-DT                            
                      WS-CREDIT-BUREAU-DT                               
                      WS-FIR-PLACE-COLL-DT                              
                      WS-SEC-PLACE-COLL-DT                              
                      WS-TRD-PLACE-COLL-DT                              
                      WS-ACTION-DT.                                     
                                                                        
       5525-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *5530-INSERT-RFCST-ACTION.                                       *        
      ******************************************************************        
       5530-INSERT-RFCST-ACTION.                                        
      *                                                                         
           SET RFCST-ACTN-INSERT TO TRUE                                
           PERFORM 7685-GET-MAX-OF-SEQ-NO             THRU 7685-EXIT    
           ADD  +10  TO WS-FW-SEQ-NO                                    
           SET WD-INDX TO 101                                           
           SET WD-INDX UP BY WS-FW-ACTION-DAYS-F8(WS-FIN-INDX)          
           SET PRV-WD-INDX       TO WD-INDX                             
           IF  KD-FW-ACTION-TYPE-CD = 'WO'                              
               SET WRITE-OFF-INDX TO WD-INDX                            
           END-IF                                                       
           MOVE WS-WORK-DAY(WD-INDX) TO WS-FW-ACTION-DT                 
                                                                        
                                                                        
           PERFORM 5600-CREATE-FINAL-WO-ACTION        THRU 5600-EXIT    
                                                                        
           IF  WS-FW-COLLECTION-FL-F8(WS-FIN-INDX) = 'Y'                
                                                                        
               SET WS-FIN-INDX UP BY 1                                  
                                                                        
               SET WD-INDX TO 101                                       
               SET WD-INDX UP BY                                        
                             WS-FW-ACTION-DAYS-F8(WS-FIN-INDX)          
                                                                        
               MOVE WS-WORK-DAY(WD-INDX) TO WS-WITHDRAW-DT              
                                                                        
               PERFORM 5700-CREATE-FINAL-WO-COLL                        
                  THRU 5700-EXIT                                        
           END-IF.                                                      
      *                                                                         
       5530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 5550-REFORECAST-ACTIONS                                        *        
      ******************************************************************        
       5550-REFORECAST-ACTIONS.                                         
                                                                        
      *CHECK IF ACTIONS ARE FOR THIS PATH                                       
           IF   WS-COMPANY-NO-F8-TBL(WS-FIN-INDX)      = AT-COMPANY-NO  
           AND  WS-REG-GROUP-CD-F8-TBL(WS-FIN-INDX)    = LR-REG-GROUP-CD
           AND  WS-FW-PATH-TYPE-CD-F8-TBL(WS-FIN-INDX) =                
                                           WS-FW-PATH-TYPE-CD           
           AND  WS-FW-FRCST-TIME-CD-F8 (WS-FIN-INDX) = 'F'              
                CONTINUE                                                
           ELSE                                                         
                SET NO-MORE-FCST-ACTN TO TRUE                           
                GO TO 5550-EXIT                                         
           END-IF                                                       
      *                                                                         
           MOVE SPACES            TO WS-OLD-ACTION-DT.                  
           MOVE ZEROES            TO WS-OLD-ACTION-AM.                  
      * START FORECASTING ACTIONS AFTER REFORECAST POINT.                       
           IF WS-FST-OCCUR = 'Y'                                        
              SET WS-FIN-INDX UP BY 1                                   
           END-IF                                                       
           MOVE WS-FW-ACTION-TYPE-F8(WS-FIN-INDX)                       
                                    TO KD-FW-ACTION-TYPE-CD.            
                                                                        
AC4527     MOVE WS-FW-BUS-PROCESS-CD-F8 (WS-FIN-INDX)                   
AC4527                              TO KD-FW-BUS-PROCESS-CD.            
                                                                        
           IF ((WS-FST-OCCUR                         = 'Y') AND         
              (WS-FW-FRCST-SOURCE-CD-F8(WS-FIN-INDX) = 'W'  OR          
               WS-FW-FRCST-SOURCE-CD-F8(WS-FIN-INDX) = 'P'))            
               SET WD-INDX  TO 101                                      
               MOVE 'N'     TO WS-FST-OCCUR                             
           END-IF.                                                      
           IF  KD-FW-ACTION-TYPE-CD = 'WO'                              
               SET WRITE-OFF-INDX TO WD-INDX                            
           END-IF                                                       
                                                                        
           EVALUATE WS-FW-FRCST-SOURCE-CD-F8(WS-FIN-INDX)               
              WHEN 'W'                                                  
                    SET WD-INDX TO WRITE-OFF-INDX                       
                    SET WD-INDX UP BY                                   
                                  WS-FW-ACTION-DAYS-F8(WS-FIN-INDX)     
              WHEN 'P'                                                  
                    SET WD-INDX          TO PRV-WD-INDX                 
                    SET WD-INDX UP BY                                   
                                  WS-FW-ACTION-DAYS-F8(WS-FIN-INDX)     
           END-EVALUATE.                                                
                                                                        
           SET  PRV-WD-INDX          TO WD-INDX.                        
                                                                        
ACT063     IF WD-INDX > 601                                             
              IF WS-INDEX-192 < 750                                     
                 ADD 1 TO WS-INDEX-192                                  
                 MOVE AT-ACCOUNT-NO TO WS-ACCOUNT(WS-INDEX-192)         
                 MOVE '- ERROR IN REFORECASTING INDEX OUY OF BOUNDS.'   
                                   TO WS-REASON(WS-INDEX-192)           
              END-IF                                                    
           ELSE                                                         
                                                                        
             MOVE WS-WORK-DAY(WD-INDX) TO WS-FW-ACTION-DT               
                                                                        
             MOVE WS-FW-ACTION-DT      TO KD-FW-ACTION-DT               
                                          WS-ACTION-DT                  
             MOVE WS-FW-SEQ-NO         TO KD-FW-SEQ-NO                  
                                                                        
             MOVE 0                    TO KD-FW-ACTION-AM               
                                                                        
             MOVE AT-ACCOUNT-NO        TO KD-ACCOUNT-NO                 
                                                                        
             MOVE SPACES               TO KD-FW-MANUAL-FL               
                                                                        
             MOVE ZEROS                TO KD-FW-ACTION-COMMENTS-LEN     
                                                                        
             MOVE SPACES               TO KD-FW-ACTION-COMMENTS-TEXT    
                                                                        
             IF WS-FW-COLLECTION-FL-F8(WS-FIN-INDX) = 'Y'               
                                                                        
                   MOVE KD-FW-ACTION-TYPE-CD TO IZ-FW-ACTION-TYPE-CD    
                                                                        
                   MOVE KD-FW-SEQ-NO         TO IZ-FW-COLL-SEQ-NO       
                                                                        
                   MOVE KD-ACCOUNT-NO        TO IZ-ACCOUNT-NO           
                                                                        
                   MOVE LR-REG-GROUP-CD      TO IZ-REG-GROUP-CD         
                                                                        
                   SET WS-FIN-INDX UP BY 1                              
                                                                        
                   SET WD-INDX UP BY                                    
                                  WS-FW-ACTION-DAYS-F8(WS-FIN-INDX)     
                                                                        
                   MOVE WS-WORK-DAY(WD-INDX) TO WS-WITHDRAW-DT          
                                                                        
                   MOVE WS-WITHDRAW-DT       TO IZ-WITHDRAW-DT          
                                                                        
                   MOVE ZEROS                TO IZ-WITHDRAW-AM          
                                                                        
                   MOVE AT-CUSTOMER-NO       TO IZ-CUSTOMER-NO          
                                                                        
                   MOVE SPACES               TO IZ-CODE-COLLEC-AGNCY    
                                                                        
                   MOVE SPACES               TO IZ-COLL-AGY-SUB-CD      
                                                                        
                   MOVE SPACES               TO IZ-WITHDRAW-REASON-CD   
                                                                        
             END-IF                                                     
                                                                        
             IF  WS-REFRST-ACT-DT > SPACES                              
                 CONTINUE                                               
             ELSE                                                       
                 MOVE '1900-01-01'          TO WS-REFRST-ACT-DT         
             END-IF                                                     
             PERFORM 7760-SELECT-FW-ACTION-AM           THRU 7760-EXIT  
                                                                        
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                                                                        
                MOVE WS-FW-OLD-ACTION-DT TO WS-OLD-ACTION-DT            
                MOVE WS-FW-OLD-ACTION-AM TO WS-OLD-ACTION-AM            
                IF  WS-OLD-ACTION-AM = 0                                
                    PERFORM 8530-DEL-OLD-ACTION                         
                       THRU 8530-EXIT                                   
                    SET NEW-ACTN-INSERT TO TRUE                         
                END-IF                                                  
                IF  RFCST-ACTN-INSERT                                   
                                                                        
                    ADD   10           TO WS-FW-SEQ-NO                  
                                                                        
                    MOVE WS-FW-SEQ-NO  TO     KD-FW-SEQ-NO              
                                                                        
                     PERFORM 8430-INSERT-FINAL-WO-ACTION                
                        THRU 8430-EXIT                                  
                                                                        
                       IF WS-FW-COLLECTION-FL-F8(WS-FIN-INDX) = 'Y'     
                                                                        
                          MOVE KD-FW-SEQ-NO TO IZ-FW-COLL-SEQ-NO        
                                                                        
                          PERFORM 8440-INSERT-FINAL-WO-COLL             
                             THRU 8440-EXIT                             
                       END-IF                                           
                ELSE                                                    
                                                                        
                    IF NEW-ACTN-INSERT                                  
                       PERFORM 7685-GET-MAX-OF-SEQ-NO   THRU 7685-EXIT  
                       ADD  +10  TO WS-FW-SEQ-NO                        
                       SET RFCST-ACTN-INSERT TO TRUE                    
                        MOVE WS-FW-SEQ-NO TO KD-FW-SEQ-NO               
                                                                        
                        PERFORM 8430-INSERT-FINAL-WO-ACTION             
                           THRU 8430-EXIT                               
                                                                        
                        IF WS-FW-COLLECTION-FL-F8(WS-FIN-INDX) = 'Y'    
                                                                        
                            MOVE KD-FW-SEQ-NO TO IZ-FW-COLL-SEQ-NO      
                                                                        
                            PERFORM 8440-INSERT-FINAL-WO-COLL           
                               THRU 8440-EXIT                           
                        END-IF                                          
                    ELSE                                                
                        MOVE WS-FW-OLD-SEQ-NO TO WS-FW-SEQ-NO           
                        PERFORM 8445-UPDATE-ACTN-DT                     
                           THRU 8445-EXIT                               
                          IF WS-FW-COLLECTION-FL-F8(WS-FIN-INDX) = 'Y'  
                                                                        
                             PERFORM 8448-UPDATE-WITHDRAW-DT            
                                THRU 8448-EXIT                          
                          END-IF                                        
                    END-IF                                              
                END-IF                                                  
                                                                        
      * IF ACTION ROW DOES NOT EXIST INSERT NEW ONE                             
             ELSE                                                       
                IF  RFCST-ACTN-INSERT                                   
                    ADD   10           TO WS-FW-SEQ-NO                  
                ELSE                                                    
                    PERFORM 7685-GET-MAX-OF-SEQ-NO       THRU 7685-EXIT 
                    ADD  +10  TO WS-FW-SEQ-NO                           
                    SET RFCST-ACTN-INSERT TO TRUE                       
                END-IF                                                  
                MOVE WS-FW-SEQ-NO  TO     KD-FW-SEQ-NO                  
                                                                        
                PERFORM 8430-INSERT-FINAL-WO-ACTION                     
                   THRU 8430-EXIT                                       
                                                                        
                IF WS-FW-COLLECTION-FL-F8(WS-FIN-INDX) = 'Y'            
                                                                        
                    MOVE KD-FW-SEQ-NO TO IZ-FW-COLL-SEQ-NO              
                                                                        
                    PERFORM 8440-INSERT-FINAL-WO-COLL                   
                       THRU 8440-EXIT                                   
                END-IF                                                  
                                                                        
             END-IF                                                     
             ADD 1                                   TO  WS-TRAN-APPL-NO
             PERFORM 5800-MOVE-TRAN-HEAD             THRU 5800-EXIT     
             PERFORM 5850-MOVE-TRAN-DET              THRU 5850-EXIT     
                                                                        
             SET WS-FIN-INDX UP BY 1                                    
             INITIALIZE WS-SECOND-INVEST-DT                             
                         WS-FORTH-FINAL-DT                              
                         WS-WRITE-OFF-DT                                
                         WS-FIRST-CREDIT-LTR-DT                         
                         WS-CREDIT-BUREAU-DT                            
                         WS-FIR-PLACE-COLL-DT                           
                         WS-SEC-PLACE-COLL-DT                           
                         WS-TRD-PLACE-COLL-DT                           
                         WS-ACTION-DT                                   
           END-IF.                                                      
      *                                                                         
       5550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5600-CREATE-FINAL-WO-ACTION                                    *        
      ******************************************************************        
       5600-CREATE-FINAL-WO-ACTION.                                     
                                                                        
           MOVE AT-ACCOUNT-NO          TO KD-ACCOUNT-NO.                
           MOVE WS-FW-SEQ-NO           TO KD-FW-SEQ-NO.                 
           MOVE WS-FW-ACTION-DT        TO KD-FW-ACTION-DT.              
           MOVE 0                      TO KD-FW-ACTION-AM.              
           MOVE SPACES                 TO KD-FW-MANUAL-FL.              
           MOVE 0                      TO KD-FW-ACTION-COMMENTS-LEN.    
           MOVE SPACES                 TO KD-FW-ACTION-COMMENTS-TEXT.   
                                                                        
           PERFORM 8430-INSERT-FINAL-WO-ACTION   THRU 8430-EXIT.        
                                                                        
       5600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5700-CREATE-FINAL-WO-COLL                                      *        
      ******************************************************************        
       5700-CREATE-FINAL-WO-COLL.                                       
                                                                        
           MOVE KD-ACCOUNT-NO          TO IZ-ACCOUNT-NO.                
           MOVE AT-COMPANY-NO          TO IZ-COMPANY-NO                 
           MOVE KD-FW-ACTION-TYPE-CD   TO IZ-FW-ACTION-TYPE-CD.         
           MOVE KD-FW-SEQ-NO           TO IZ-FW-COLL-SEQ-NO             
           MOVE LR-REG-GROUP-CD        TO IZ-REG-GROUP-CD               
           MOVE WS-WITHDRAW-DT         TO IZ-WITHDRAW-DT                
           MOVE AT-CUSTOMER-NO         TO IZ-CUSTOMER-NO                
           MOVE SPACES                 TO IZ-CODE-COLLEC-AGNCY          
           MOVE SPACES                 TO IZ-COLL-AGY-SUB-CD            
           MOVE ZEROS                  TO IZ-WITHDRAW-AM                
           MOVE SPACES                 TO IZ-WITHDRAW-REASON-CD         
                                                                        
           PERFORM 8440-INSERT-FINAL-WO-COLL     THRU 8440-EXIT.        
                                                                        
       5700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER AND       *           
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *           
      ***************************************************************           
       5800-MOVE-TRAN-HEAD.                                             
      *                                                                         
           IF WS-TRAN-APPL-NO > 1                                       
              GO TO 5800-EXIT                                           
           END-IF                                                       
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                    
MFA-TR*           ,:MH-DATE-TRANS = CURRENT DATE                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**     ERROR IN 5800-MOVE-TRAN-HEAD  **'        
               DISPLAY '**     RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '**     ACCOUNT NO ** ' AT-ACCOUNT-NO            
               DISPLAY '**     SET'                                     
               DISPLAY '**     PROCESSING IS TERMINATED     **'         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE 'F'                     TO MH-CODE-TRAN-TYPE.           
           MOVE SPACES                  TO MH-RESP-AREA-ID.             
           MOVE SPACES                  TO MI-TABLE-ID.                 
           MOVE WS-ACCOUNT-NO-NUM       TO MH-ACCOUNT-NO.               
           MOVE 0                       TO MH-CUSTOMER-NO.              
           MOVE 0                       TO MH-PREMISE-NO.               
           MOVE 'SYSTEM'                TO MH-USER-ID.                  
           MOVE PROGRAM-NAME            TO MH-APPL-PROGRAM-ID.          
           MOVE ZERO                    TO MH-TRAN-COMMENT-LEN.         
           MOVE SPACES                  TO MH-TRAN-COMMENT-TEXT.        
           PERFORM 8535-INSERT-MNT-TRANS-HIST    THRU 8535-EXIT.        
                                                                        
       5800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      * CHECK WHETHER ANY OF THE COLUMN VALUES HAVE CHANGED.IF    *             
      * SO THEN WRITE A RECORD IN THE TRANSACTION DETAIL.         *             
      *************************************************************             
       5850-MOVE-TRAN-DET.                                              
                                                                        
           MOVE '5850' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
                                                                        
             IF WS-ACTION-DT        NOT = '    -  -  '  AND             
                WS-ACTION-DT            > SPACES        AND             
                WS-ACTION-DT        NOT = WS-OLD-ACTION-DT              
                                                                        
                MOVE 'ACTION TYPE'          TO MI-COLUMN-DESC           
                MOVE '*UPDATED*'            TO MI-CHG-COLUMN-VALUE-TEXT 
                MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN  
                                                                        
                MOVE 'AT'                 TO KV-FW-ATTRIB-TYPE-CD       
                MOVE KD-FW-ACTION-TYPE-CD TO KV-FW-ATTR-VALUE-CD        
                                                                        
                PERFORM 7380-SELECT-ACTION-DESC        THRU 7380-EXIT   
                IF  KV-FW-ATTR-VALUE-DESC > SPACES                      
                    MOVE KV-FW-ATTR-VALUE-DESC TO                       
                         MI-PRV-COLUMN-VALUE-TEXT                       
                    MOVE LENGTH OF KV-FW-ATTR-VALUE-DESC                
                                            TO MI-PRV-COLUMN-VALUE-LEN  
                ELSE                                                    
                    MOVE KV-FW-ATTR-VALUE-CD   TO                       
                         MI-PRV-COLUMN-VALUE-TEXT                       
                    MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN  
                                                                        
                END-IF                                                  
                MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO           
                PERFORM 8540-INSERT-MT-TRN-HST-DET     THRU 8540-EXIT   
                ADD +1                        TO WS-TRAN-APPL-NO        
      *                                                                         
                MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN    
                                               MI-CHG-COLUMN-VALUE-LEN  
                MOVE SPACES               TO WS-DATE-BREAKDOWN          
                MOVE WS-ACTION-DT         TO WS-DATE-BREAKDOWN          
                                                                        
                PERFORM 5860-DATE-REFORMAT             THRU 5860-EXIT   
                                                                        
                MOVE WS-DATE-NEW-FORMAT   TO MI-CHG-COLUMN-VALUE-TEXT   
                MOVE SPACES               TO WS-DATE-BREAKDOWN          
                IF WS-OLD-ACTION-DT = SPACES                            
                   MOVE +5                TO MI-PRV-COLUMN-VALUE-LEN    
                   MOVE '*NEW*'           TO MI-PRV-COLUMN-VALUE-TEXT   
                ELSE                                                    
                   MOVE WS-OLD-ACTION-DT  TO WS-DATE-BREAKDOWN          
                                                                        
                   PERFORM 5860-DATE-REFORMAT          THRU 5860-EXIT   
                                                                        
                   MOVE WS-DATE-NEW-FORMAT TO MI-PRV-COLUMN-VALUE-TEXT  
                END-IF                                                  
                MOVE 'ACTION DATE'         TO MI-COLUMN-DESC            
                MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO           
                PERFORM 8540-INSERT-MT-TRN-HST-DET     THRU 8540-EXIT   
      *****************************************************************         
      *         INCLUDE FOR INSERTING AMOUNT                          *         
      *****************************************************************         
                IF WS-OLD-ACTION-AM > ZEROS                             
                   MOVE +12               TO MI-PRV-COLUMN-VALUE-LEN    
                                               MI-CHG-COLUMN-VALUE-LEN  
                   ADD 1                  TO WS-TRAN-APPL-NO            
                   MOVE WS-TRAN-APPL-NO   TO MI-TRAN-APPL-NO            
                   MOVE ZEROS             TO WS-CHG-COLUMN-AM           
                   MOVE WS-CHG-COLUMN-VALUE                             
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
                   MOVE WS-OLD-ACTION-AM                                
                                            TO WS-NUMERIC-AMT           
                   MOVE WS-NUMERIC-AMT    TO WS-PREV-COLUMN-AM          
                   MOVE WS-PREV-COLUMN-VALUE                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
                   MOVE 'ACTION AMT'        TO MI-COLUMN-DESC           
                   PERFORM 8540-INSERT-MT-TRN-HST-DET  THRU 8540-EXIT   
                   MOVE ZEROS TO WS-OLD-ACTION-AM                       
                END-IF                                                  
                INITIALIZE WS-PREV-COLUMN-VALUE,                        
                           WS-CHG-COLUMN-VALUE                          
                MOVE ZEROS                TO WS-NUMERIC-AMT             
             END-IF.                                                    
                                                                        
       5850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *5860-DATE-REFORMAT.                                                      
      *****************************************************************         
       5860-DATE-REFORMAT.                                              
                                                                        
           MOVE SPACES       TO WS-DATE-NEW-MM.                         
           MOVE SPACES       TO WS-DATE-NEW-DD.                         
           MOVE SPACES       TO WS-DATE-NEW-YYYY.                       
           MOVE WS-DATE-MM   TO WS-DATE-NEW-MM.                         
           MOVE WS-DATE-DD   TO WS-DATE-NEW-DD.                         
           MOVE WS-DATE-YYYY TO WS-DATE-NEW-YYYY.                       
                                                                        
       5860-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                 11188500
      * PARAGRAPH 5100-GET-FCST-ACTN-DATA IS IN CPD00337.               11187000
      *                                                                 11187100
           EXEC SQL                                                     11189600
               INCLUDE CPD00337                                         11189700
           END-EXEC.                                                    11189800
      *                                                                 11187300
      ******************************************************************        
      * 4900-GET-WQ-GEN-FL                                             *        
      * 5200-SEARCH-WQ-PGM-CNTL-TBL                                    *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00346                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 5200-CHK-SKIP-ACCTS                                            *11187000
      ******************************************************************11187100
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00347                                                  
           END-EXEC.                                                            
                                                                        
      *                                                                         
      *****************************************************************         
      *  THIS PARA CHECKS WHETHER ALL VALUES ARE POSITIVE                       
      *  IN THE TABLE ITSELF.                                                   
      *****************************************************************         
       5150-VERIFY-DW-VARIABLES.                                        
      *                                                                         
           IF F8-MATCH-FOUND                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**************PCSKR400***************'          
               DISPLAY '* 5150-VERIFY-DW-VARIABLES'                     
               DISPLAY '* RETURN CODE = 12'                             
               DISPLAY '**************PCSKR400***************'          
               PERFORM 9900-ABEND   THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       5150-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *    BATCH JOURNAL ROUTINE                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00007                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    6500-GET-NEXT-BUSINESS-DAY                                **         
      *    COPYBOOK CPD00322 CONTAINS THE LOGIC FOR FINDING          **         
      *    THE NEXT BUSINESS DAY.                                    **         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD00322                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    3500-ONLINE-LOAD-AR-TRAN-HIST                             **         
      *    COPYBOOK CPD00008 CONTAINS THE LOGIC FOR INSERTING        **         
      *    TO CSS_AR_TRANS_HIST AND CSS_AR_TR_TRN_HST_DET            **         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD00008                                                 
           END-EXEC.                                                            
      *                                                                         
      *                                                                 11188500
      * PARAGRAPH 6251-GET-FJC01-DATE IS IN CPD00037.                   11188600
      *                                                                 11188700
           EXEC SQL                                                             
               INCLUDE CPD00037                                         00730000
           END-EXEC.                                                            
      *                                                                         
      *                                                                 11188500
      * PARAGRAPH 6240-GET-FCA00-COMMON-DATE IS IN CPD00040.            11187000
      *                                                                 11187100
           EXEC SQL                                                             
               INCLUDE CPD00040                                         00730000
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ****************************************************************          
      **    COPYBOOKS NECESSARY FOR CSS_JOB_PARM PROCESSING          *          
      **    7600-START-FCSJC01                                       *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                         00730000
           END-EXEC.                                                            
      *                                                                         
      *                                                                 19000000
      * PARAGRAPH 7620-START-FCSCA00 IS IN CPD00039                     19001000
      *                                                                 19002000
           EXEC SQL                                                             
               INCLUDE CPD00039                                         00730000
           END-EXEC.                                                            
      *                                                                         
      ************************************************************              
      * SELECT THE REVENUE MONTH FROM CSS_JOB_PARM               *              
      ************************************************************              
      *                                                                         
       7000-GET-REVMON-DTBILL.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT PARM_DATA                                         
                 INTO :G6-PARM-DATA                                     
                 FROM CSS_JOB_PARM                                      
                WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                   
                  AND COMPANY_NO   = :G6-COMPANY-NO                     
                  AND CMND_CODE    = :G6-CMND-CODE                      
                  AND SEQ_NO       = :G6-SEQ-NO                         
                  AND STATUS       = :G6-STATUS                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*********************************'              
               DISPLAY '*** PCSKR400 PROCESSING ERROR ***'              
               DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                
               DISPLAY '*** 7000-GET-REVMON-DTBILL    ***'              
               DISPLAY '*** PROGRAM NAME ' G6-PROGRAM-NAME              
               DISPLAY '*** COMPANY NO   ' G6-COMPANY-NO                
               DISPLAY '*** CMND_CODE    ' G6-CMND-CODE                 
               DISPLAY '*** SEQ_NO       ' G6-SEQ-NO                    
               DISPLAY '*** STATUS       ' G6-STATUS                    
               DISPLAY '*********************************'              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12941900
      ****************************************************************  14936600
      **                                                            **  14936700
      **  7100-OPEN-FINAL-WO-CRSR                                   **  14936800
      **                                                            **  14936900
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **  14937000
      **      FINAL_WO_ACTN_CRSR CURSOR                             **  14937100
      **                                                            **  14937200
      ****************************************************************  14937300
      *                                                                 14937400
       7100-OPEN-FINAL-WO-CRSR.                                         
      *                                                                 14937600
           EXEC SQL                                                     
               OPEN FINAL_WO_ACTN_CRSR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14938000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 14938200
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************** PCSKR400 ******************'     
               DISPLAY '** 7100 :  RETURN CODE ERROR - OPEN '           
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '************** PCSKR400 ******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 14939200
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14939500
      ****************************************************************  14939600
      **                                                            **  14939700
      **  7110-FETCH-FINAL-WO-CRSR                                  **  14939800
      **                                                            **  14939900
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **  14940000
      **      FINAL_WO_ACTN_CRSR CURSOR                             **  14940100
      **                                                            **  14940200
      ****************************************************************  14940300
      *                                                                 14940400
       7110-FETCH-FINAL-WO-CRSR.                                        
      *                                                                 14940600
           EXEC SQL                                                     
               FETCH FINAL_WO_ACTN_CRSR INTO                            
                  :FW-ACCOUNT-NO                                        
                 ,:FW-REG-GROUP-CD                                      
                 ,:FW-SENIOR-FL                                         
                 ,:KD-FW-SEQ-NO                                         
                 ,:KD-FW-ACTION-TYPE-CD                                 
                 ,:KD-FW-ACTION-DT                                      
                 ,:KD-FW-ACTION-AM                                      
                 ,:KD-FW-PROCESSED-FL                                   
                 ,:AT-COMPANY-NO                                        
                 ,:AT-CUSTOMER-NO                                       
                 ,:AT-PREMISE-NO                                        
                 ,:AT-TOTAL-AR-BALANCE                                  
                 ,:AT-LOCAL-OFFICE                                      
                 ,:AT-BANKRUPTCY-IND                                    
                 ,:AT-JUDGEMENT-CASE-NO                                 
                 ,:AT-LAST-PYMT-DATE :WS-LAST-PYMT-DATE-NI               
                 ,:AT-LAST-PYMT-AMOUNT                                  
                 ,:AT-CODE-ACCT-STAT                                    
                 ,:AT-CODES-DATA-PRESENT                                
                 ,:AT-DATE-BILL-DAY-00 :WS-BILL-DAY-00-NULL             
                 ,:AT-ACCOUNT-TYPE-CODE                                 
                 ,:AT-ELEC-REV-ALLOC-PCT                                
                 ,:AT-CODE-STATUS-REASON                                
                 ,:B1-DISTRICT-NO                                       
                 ,:B1-ELEC-REV-ALLOC-PCT                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14944500
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 14944500
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               IF WS-BILL-DAY-00-NULL < 0                               
                   MOVE SPACES         TO AT-DATE-BILL-DAY-00           
               END-IF                                                   
               IF WS-LAST-PYMT-DATE-NI < 0                              
                   MOVE SPACES         TO AT-LAST-PYMT-DATE             
               END-IF                                                   
           ELSE                                                         
               DISPLAY '*********** PCSKR400 *********************'     
               DISPLAY '** 7110 :  RETURN CODE ERROR - FETCH'           
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '*********** PCSKR400 *********************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 14948000
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  15600000
      **  7120-CLOSE-FINAL-WO-ACTN                                  **  15610000
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **  15620000
      **      FINAL_WO_ACTN CURSOR                                  **  15630000
      ****************************************************************  15640000
       7120-CLOSE-FINAL-WO-ACTN.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE FINAL_WO_ACTN_CRSR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************* PCSKR400 *******************'      
              DISPLAY '** 7120 :  RETURN CODE ERROR - CLOSE'            
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '************* PCSKR400 *******************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   7160-SELECT-DELINQ-VALUE.                                    *        
      *   SELECT DELINQUENCY VALUE.                                    *        
      ******************************************************************        
                                                                        
       7160-SELECT-DELINQ-VALUE.                                        
                                                                        
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
              INTO    :WS-C8-DELINQ-VALUE                               
              FROM    CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
              WHERE   DELINQ_CD  = :C8-DELINQ-CD                        
              AND     COMPANY_NO = :C8-COMPANY-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*       INTO    :WS-C8-DELINQ-VALUE                                       
MFA-TR*       FROM    CSS_DELINQUENCY                                           
MFA-TR*       WHERE   DELINQ_CD  = :C8-DELINQ-CD                                
MFA-TR*       AND     COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7160                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '**                                     **'      
               DISPLAY '**     ERROR IN 7160-SELECT-DELINQ-VALUE*'      
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    DELINQ CD   = ' C8-DELINQ-CD              
               DISPLAY '**    COMPANY NO  = ' WS-COMPANY-NO-DELINQ      
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF                                                       
           .                                                            
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16660000
      ******************************************************************        
      * 7210-CHK-OTHER-RECEIVABLES                                     *        
      ******************************************************************        
       7210-CHK-OTHER-RECEIVABLES.                                      
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-OTHER-RECV                                   
                  FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                        
                 WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                      
                   AND PYMT_PRIORITY_LVL NOT IN (30,39)                 
                   AND (AMT_AR_DAY_00     <> 0                          
                        OR AMT_AR_DAY_30     <> 0                       
                        OR AMT_AR_DAY_60     <> 0                       
                        OR AMT_AR_DAY_90     <> 0                       
                        OR AMT_UNUSED_CR     <> 0                       
                        OR AMT_TRAN_BALANCE  <> 0                       
                        OR TOT_SUMM_UNBILLED <> 0)                      
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-OTHER-RECV                                           
MFA-TR*           FROM CSS_AR_CNTL                                              
MFA-TR*          WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                              
MFA-TR*            AND PYMT_PRIORITY_LVL NOT IN (30,39)                         
MFA-TR*            AND (AMT_AR_DAY_00     <> 0                                  
MFA-TR*                 OR AMT_AR_DAY_30     <> 0                               
MFA-TR*                 OR AMT_AR_DAY_60     <> 0                               
MFA-TR*                 OR AMT_AR_DAY_90     <> 0                               
MFA-TR*                 OR AMT_UNUSED_CR     <> 0                               
MFA-TR*                 OR AMT_TRAN_BALANCE  <> 0                               
MFA-TR*                 OR TOT_SUMM_UNBILLED <> 0)                              
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*           WITH UR                                                       
MFA-TR*       QUERYNO 7210                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '** ERROR IN 7210-CHK-OTHER-RECEIVABLES**'       
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**      ACCOUNT NO  = ' AC-ACCOUNT-NO           
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7220-SUM-LPC-AMT                                        **  00272000
      ****************************************************************  00273500
       7220-SUM-LPC-AMT.                                                
      *                                                                         
           EXEC SQL                                                     
                SELECT (AMT_AR_DAY_00 +                                 
                       AMT_AR_DAY_30 +                                  
                       AMT_AR_DAY_60 +                                  
                       AMT_AR_DAY_90 +                                  
                       AMT_UNUSED_CR )                                  
                      ,AMT_AR_DAY_00                                    
                      ,AMT_AR_DAY_30                                    
                      ,AMT_AR_DAY_60                                    
                      ,AMT_AR_DAY_90                                    
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                INTO   :WS-LPC-LPN :WS-LPC-NULL-IND          
                      ,:AC-AMT-AR-DAY-00                                
                      ,:AC-AMT-AR-DAY-30                                
                      ,:AC-AMT-AR-DAY-60                                
                      ,:AC-AMT-AR-DAY-90                                
                      ,:AC-LAST-UPDATE-TS :WS-TS-NULL-IND           
                FROM  CSS_AR_CNTL WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT (AMT_AR_DAY_00 +                                         
MFA-TR*                AMT_AR_DAY_30 +                                          
MFA-TR*                AMT_AR_DAY_60 +                                          
MFA-TR*                AMT_AR_DAY_90 +                                          
MFA-TR*                AMT_UNUSED_CR )                                          
MFA-TR*               ,AMT_AR_DAY_00                                            
MFA-TR*               ,AMT_AR_DAY_30                                            
MFA-TR*               ,AMT_AR_DAY_60                                            
MFA-TR*               ,AMT_AR_DAY_90                                            
MFA-TR*               ,LAST_UPDATE_TS                                           
MFA-TR*         INTO   :WS-LPC-LPN            :WS-LPC-NULL-IND                  
MFA-TR*               ,:AC-AMT-AR-DAY-00                                        
MFA-TR*               ,:AC-AMT-AR-DAY-30                                        
MFA-TR*               ,:AC-AMT-AR-DAY-60                                        
MFA-TR*               ,:AC-AMT-AR-DAY-90                                        
MFA-TR*               ,:AC-LAST-UPDATE-TS     :WS-TS-NULL-IND                   
MFA-TR*         FROM  CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL                 
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7220                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '************* PCSKR400 *******************'      
              DISPLAY '** AR_CNTL  TABLE                   '            
              DISPLAY '** ACCOUNT NO = ' AC-ACCOUNT-NO                  
              DISPLAY '** 7220 : RETURN CODE ERROR - SELECT '           
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '************* PCSKR400 *******************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7235-GET-LPC-CHRGED...GET LPC CHARGED ON ACCOUNT               15186000
      ******************************************************************        
       7235-GET-LPC-CHRGED.                                             
                                                                        
           EXEC SQL                                                     
              SELECT FW_ACTION_AM                                       
                INTO :KD-FW-ACTION-AM                                   
                FROM CSS_FIN_WO_ACTION WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO         = :WS-ACCOUNT-NBR               
                 AND FW_ACTION_TYPE_CD  = 'LPC'                         
                 AND FW_PROCESSED_FL    = 'Y'                           
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15186400
MFA-TR*       SELECT FW_ACTION_AM                                       15186500
MFA-TR*         INTO :KD-FW-ACTION-AM                                   15186600
MFA-TR*         FROM CSS_FIN_WO_ACTION                                  15186700
MFA-TR*        WHERE ACCOUNT_NO         = :WS-ACCOUNT-NBR               15186800
MFA-TR*          AND FW_ACTION_TYPE_CD  = 'LPC'                         15186900
MFA-TR*          AND FW_PROCESSED_FL    = 'Y'                                   
MFA-TR*       QUERYNO 7235                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    15187000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '************* PCSKR400 *******************'      
              DISPLAY '** CSS_FIN_WO_ACTION TABLE          '            
              DISPLAY '** ACCOUNT NO = ' WS-ACCOUNT-NBR                 
              DISPLAY '** 7235 : RETURN CODE ERROR - SELECT '           
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '************* PCSKR400 *******************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7235-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7240-SELECT-CHRG-OFF-VALUES                             **  00272000
      **        SELECT CHRG OFF VALUES FROM CSS_CHRG_OFF TABLE      **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
      *                                                                         
       7240-SELECT-CHRG-OFF-VALUES.                                     
      *                                                                         
           MOVE '7240'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) CHG_OFF_DESC,
              CODE_CHG_OFF_REAS,
              DATE_OF_CHG_OFF                                      
                INTO                                                    
                   :CO-CHG-OFF-DESC,                                    
                   :CO-CODE-CHG-OFF-REAS,                               
                   :CO-DATE-OF-CHG-OFF :WS-DATE-OF-CHG-OFF-NULL         
                FROM  CSS_CHRG_OFF WITH(READUNCOMMITTED)                        
                WHERE ACCOUNT_NO = :CO-ACCOUNT-NO                       
                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*            CHG_OFF_DESC,                                                
MFA-TR*            CODE_CHG_OFF_REAS,                                           
MFA-TR*            DATE_OF_CHG_OFF                                              
MFA-TR*         INTO                                                            
MFA-TR*            :CO-CHG-OFF-DESC,                                            
MFA-TR*            :CO-CODE-CHG-OFF-REAS,                                       
MFA-TR*            :CO-DATE-OF-CHG-OFF :WS-DATE-OF-CHG-OFF-NULL                 
MFA-TR*         FROM  CSS_CHRG_OFF                                              
MFA-TR*         WHERE ACCOUNT_NO = :CO-ACCOUNT-NO                               
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*       QUERYNO 7240                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
      * BYPASS SQLCODE -811                                                     
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -811       
               IF WS-DATE-OF-CHG-OFF-NULL < 0                           
                   MOVE SPACES     TO CO-DATE-OF-CHG-OFF                
               END-IF                                                   
           ELSE                                                         
               DISPLAY '**   ERROR IN 7240-SELECT-CHRG-OFF-VALUES *'    
               DISPLAY '**    RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '** ACCOUNT NO ' CO-ACCOUNT-NO                   
               DISPLAY '**    PROCESSING IS TERMINATED     **'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7245-GET-CHRG-OFF                                       **  00272000
      **        SELECT AMT-TRANS FROM CSS_CHRG_OFF TABLE            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
      *                                                                         
       7245-GET-CHRG-OFF.                                               
      *                                                                         
           MOVE '7245'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                SELECT AMT_TRANS,                                       
                       WO_ORIGINAL_AM                                   
                INTO :CO-AMT-TRANS,                                     
                     :CO-WO-ORIGINAL-AM                                 
                FROM  CSS_CHRG_OFF WITH(READUNCOMMITTED)                        
                WHERE ACCOUNT_NO = :CO-ACCOUNT-NO AND                   
                      PYMT_PRIORITY_LVL = :CO-PYMT-PRIORITY-LVL AND     
                      ITEM_ID = :CO-ITEM-ID                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT AMT_TRANS,                                               
MFA-TR*                WO_ORIGINAL_AM                                           
MFA-TR*         INTO :CO-AMT-TRANS,                                             
MFA-TR*              :CO-WO-ORIGINAL-AM                                         
MFA-TR*         FROM  CSS_CHRG_OFF                                              
MFA-TR*         WHERE ACCOUNT_NO = :CO-ACCOUNT-NO AND                           
MFA-TR*               PYMT_PRIORITY_LVL = :CO-PYMT-PRIORITY-LVL AND             
MFA-TR*               ITEM_ID = :CO-ITEM-ID                                     
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7245                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**   ERROR IN 7245-GET-CHRG-OFF    **'          
               DISPLAY '**    RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '**   ACCOUNT NO = ' CO-ACCOUNT-NO               
               DISPLAY '**   PAYMENT PRIORITY LEVEL = '                 
                     CO-PYMT-PRIORITY-LVL                               
               DISPLAY '**   ITEM ID = ' CO-ITEM-ID                     
               DISPLAY '**    PROCESSING IS TERMINATED     **'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7245-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   7270-SELECT-TIMESTAMP.                                    **          
      ****************************************************************          
       7270-SELECT-TIMESTAMP.                                           
      *                                                                 00691000
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTAMP                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET: WS-TIMESTAMP = CURRENT TIMESTAMP                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '************* PCSKR400 *******************'     
               DISPLAY '** ERROR IN 7270-SELECT-TIMESTAMP        **'    
               DISPLAY '**        RETURN CODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '**        PROCESSING IS TERMINATED       **'    
               DISPLAY '************* PCSKR400 *******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7270-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *  7300-RECEIVABLES-CHECK                                         15186000
      ******************************************************************        
       7300-RECEIVABLES-CHECK.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-RECEIVABLES-EXIST                              
                FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO      = :AC-ACCOUNT-NO                   
                 AND (AMT_AR_DAY_00 <> 0                                
                  OR  AMT_AR_DAY_30 <> 0                                
                  OR  AMT_AR_DAY_60 <> 0                                
                  OR  AMT_AR_DAY_90 <> 0                                
                  OR  AMT_UNUSED_CR <> 0                                
                  OR  TOT_SUMM_UNBILLED <> 0)                           
                                                  
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15186400
MFA-TR*       SELECT 'Y'                                                15186500
MFA-TR*         INTO :WS-RECEIVABLES-EXIST                              15186600
MFA-TR*         FROM CSS_AR_CNTL                                        15186700
MFA-TR*        WHERE ACCOUNT_NO      = :AC-ACCOUNT-NO                   15186800
MFA-TR*          AND (AMT_AR_DAY_00 <> 0                                15186900
MFA-TR*           OR  AMT_AR_DAY_30 <> 0                                        
MFA-TR*           OR  AMT_AR_DAY_60 <> 0                                        
MFA-TR*           OR  AMT_AR_DAY_90 <> 0                                        
MFA-TR*           OR  AMT_UNUSED_CR <> 0                                        
MFA-TR*           OR  TOT_SUMM_UNBILLED <> 0)                                   
MFA-TR*       FETCH FIRST 1 ROW ONLY                                            
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    15187000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '************* PCSKR400 *******************'      
              DISPLAY '** AR_CNTL  TABLE                   '            
              DISPLAY '** ACCOUNT NO = ' AC-ACCOUNT-NO                  
              DISPLAY '** 7300 : RETURN CODE ERROR - SELECT '           
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '************* PCSKR400 *******************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7370-SELECT-ACTION-AM-SEQ                                       *        
      ******************************************************************        
       7370-SELECT-ACTION-AM-SEQ.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) KD.FW_ACTION_AM,
              KD.FW_SEQ_NO,
              KD.FW_ACTION_DT                                   
                INTO :KD-FW-ACTION-AM,                                  
                     :KD-FW-SEQ-NO,                                     
                     :WS-REFRST-ACT-DT                                  
                FROM CSS_FIN_WO_ACTION KD WITH(READUNCOMMITTED)                 
               WHERE ACCOUNT_NO           = :AT-ACCOUNT-NO              
                 AND KD.FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD       
               ORDER BY FW_ACTION_DT DESC                               
                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  KD.FW_ACTION_AM                                           
MFA-TR*              ,KD.FW_SEQ_NO                                              
MFA-TR*              ,KD.FW_ACTION_DT                                           
MFA-TR*         INTO :KD-FW-ACTION-AM,                                          
MFA-TR*              :KD-FW-SEQ-NO,                                             
MFA-TR*              :WS-REFRST-ACT-DT                                          
MFA-TR*         FROM CSS_FIN_WO_ACTION KD                                       
MFA-TR*        WHERE ACCOUNT_NO           = :AT-ACCOUNT-NO                      
MFA-TR*          AND KD.FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD               
MFA-TR*        ORDER BY FW_ACTION_DT DESC                                       
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*       QUERYNO 7370                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    ERROR IN 7370-SELECT-ACTION-AM-SEQ **'    
               DISPLAY '**    RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '**    ACCOUNT NO = ' AT-ACCOUNT-NO              
               DISPLAY '**    FW ACTION TYPE CD =' F8-FW-ACTION-TYPE-CD 
               DISPLAY '**    PROCESSING IS TERMINATED     **'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7370-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7380-SELECT-ACTION-DESC.                                       *        
      ******************************************************************        
       7380-SELECT-ACTION-DESC.                                         
                                                                        
           MOVE '7380'                   TO ACTIVE-PARAGRAPH            
                                                                        
           EXEC SQL                                                     
              SELECT                                                    
                  FW_ATTR_VALUE_DESC                                    
              INTO                                                      
                  :KV-FW-ATTR-VALUE-DESC                                
              FROM                                                      
                  CSS_FW_ATTRIB_DESC WITH(READUNCOMMITTED)                      
              WHERE                                                     
                  FW_ATTRIB_TYPE_CD   = :KV-FW-ATTRIB-TYPE-CD           
              AND FW_ATTR_VALUE_CD    = :KV-FW-ATTR-VALUE-CD            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*           FW_ATTR_VALUE_DESC                                            
MFA-TR*       INTO                                                              
MFA-TR*           :KV-FW-ATTR-VALUE-DESC                                        
MFA-TR*       FROM                                                              
MFA-TR*           CSS_FW_ATTRIB_DESC                                            
MFA-TR*       WHERE                                                             
MFA-TR*           FW_ATTRIB_TYPE_CD   = :KV-FW-ATTRIB-TYPE-CD                   
MFA-TR*       AND FW_ATTR_VALUE_CD    = :KV-FW-ATTR-VALUE-CD                    
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7380                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    ERROR IN 7380-SELECT-ACTION-DESC   **'    
               DISPLAY '**    RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '**    FW ATTRIB TYPE CD =' KV-FW-ATTRIB-TYPE-CD 
               DISPLAY '**    FW ACTTR VALUE CD =' KV-FW-ATTR-VALUE-CD  
               DISPLAY '**    PROCESSING IS TERMINATED     **'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7380-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS41920
      *                                                                *PCS41930
      *     7400-GET-COLLEC-AGNCY-WO-TOT                               *PCS41940
      *                                                                *PCS41950
      ******************************************************************PCS41960
      *                                                                         
       7400-GET-COLLEC-AGNCY-WO-TOT.                                    
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                  WRITE_OFF_AMT                                         
              INTO                                                      
                  :SN-WRITE-OFF-AMT                                     
              FROM CSS_CHG_OFF_AMT WITH(READUNCOMMITTED)                        
              WHERE CODE_COLLEC_AGNCY  = :SN-CODE-COLLEC-AGNCY          
                AND WRITE_OFF_MONTH_YR = :SN-WRITE-OFF-MONTH-YR         
                AND COMPANY_NO         = :SN-COMPANY-NO                 
                AND REG_GROUP_CD       = :SN-REG-GROUP-CD               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*           WRITE_OFF_AMT                                                 
MFA-TR*       INTO                                                              
MFA-TR*           :SN-WRITE-OFF-AMT                                             
MFA-TR*       FROM CSS_CHG_OFF_AMT                                              
MFA-TR*       WHERE CODE_COLLEC_AGNCY  = :SN-CODE-COLLEC-AGNCY                  
MFA-TR*         AND WRITE_OFF_MONTH_YR = :SN-WRITE-OFF-MONTH-YR                 
MFA-TR*         AND COMPANY_NO         = :SN-COMPANY-NO                         
MFA-TR*         AND REG_GROUP_CD       = :SN-REG-GROUP-CD                       
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '** ERROR IN 7400-GET-COLLEC-AGNCY-WO-TOT *'     
               DISPLAY '** PROCESSING TERMINATING                *'     
               DISPLAY '** CODE COLLEC AGNCY    ' SN-CODE-COLLEC-AGNCY  
               DISPLAY '** WO MONTH YEAR        ' SN-WRITE-OFF-MONTH-YR 
               DISPLAY '** COMPANY NO           ' SN-COMPANY-NO         
               DISPLAY '** REG GROUP CD         ' SN-REG-GROUP-CD       
               DISPLAY '** RETURN CODE          ' WS-ACTIVE-RETURN-CODE 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************15183100
      *  7443-SELECT-NON-REFUNDED-DEP                                   15183200
      ******************************************************************15183300
       7443-SELECT-NON-REFUNDED-DEP.                                    
           EXEC SQL                                                     
               SELECT 'Y'                                               
                   INTO :WS-NON-REFUNDED-DEP-EXISTS                     
               FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO  = :DO-ACCOUNT-NO                       
                 AND (DEPOSIT_STATUS_CD = 'A'                           
                  OR  DEPOSIT_STATUS_CD = 'P')                          
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15183500
MFA-TR*        SELECT 'Y'                                               15183600
MFA-TR*            INTO :WS-NON-REFUNDED-DEP-EXISTS                     15183700
MFA-TR*        FROM CSS_DEP_ON_HAND                                     15183800
MFA-TR*        WHERE ACCOUNT_NO  = :DO-ACCOUNT-NO                       15183900
MFA-TR*          AND (DEPOSIT_STATUS_CD = 'A'                           15184000
MFA-TR*           OR  DEPOSIT_STATUS_CD = 'P')                                  
MFA-TR*       QUERYNO 7443                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    15184100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15184200
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
           OR -811                                                      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '************* PCSKR400 *******************'      
              DISPLAY '** DEP ON HAND TABLE                 '           
              DISPLAY '** ACCOUNT NO = ' DO-ACCOUNT-NO                  
              DISPLAY '** 7443 : RETURN CODE ERROR - SELECT '           
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '************* PCSKR400 *******************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7443-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15185800
      ******************************************************************        
      *  7445-SELECT-ACT-GUAR.                                          15186000
      ******************************************************************        
       7445-SELECT-ACT-GUAR.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                 INTO :WS-GUARANTOR-EXISTS                              
              FROM CSS_GUARANTOR WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO      = :GU-ACCOUNT-NO                    
                AND GUAR_STATUS_CD  = 'A'                               
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15186400
MFA-TR*       SELECT 'Y'                                                15186500
MFA-TR*          INTO :WS-GUARANTOR-EXISTS                              15186600
MFA-TR*       FROM CSS_GUARANTOR                                        15186700
MFA-TR*       WHERE ACCOUNT_NO      = :GU-ACCOUNT-NO                    15186800
MFA-TR*         AND GUAR_STATUS_CD  = 'A'                               15186900
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7445                                                      
MFA-TR*    END-EXEC.                                                    15187000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '************* PCSKR400 *******************'      
              DISPLAY '** GUARANTOR TABLE                   '           
              DISPLAY '** ACCOUNT NO = ' GU-ACCOUNT-NO                  
              DISPLAY '** 7445 : RETURN CODE ERROR - SELECT '           
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '************* PCSKR400 *******************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7445-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************15188800
      *  7447-SELECT-ACTIVE-SURETY-BOND.                                15188900
      ******************************************************************15189000
       7447-SELECT-ACTIVE-SURETY-BOND.                                  
           EXEC SQL                                                     
               SELECT 'Y'                                               
                   INTO :WS-SURETY-BOND-EXISTS                          
               FROM CSS_SURETY_BOND WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO  = :SB-ACCOUNT-NO                       
                 AND CODE_STATUS = 'A'                                  
                 AND (CODE_BOND_TYPE IN ('A', 'B'))                     
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15189200
MFA-TR*        SELECT 'Y'                                               15189300
MFA-TR*            INTO :WS-SURETY-BOND-EXISTS                          15189400
MFA-TR*        FROM CSS_SURETY_BOND                                     15189500
MFA-TR*        WHERE ACCOUNT_NO  = :SB-ACCOUNT-NO                       15189600
MFA-TR*          AND CODE_STATUS = 'A'                                  15189700
MFA-TR*          AND (CODE_BOND_TYPE IN ('A', 'B'))                     15189800
MFA-TR*       QUERYNO 7447                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    15189900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15190000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
           OR -811                                                      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '************* PCSKR400 *******************'      
              DISPLAY '** SURETY BOND TABLE                 '           
              DISPLAY '** ACCOUNT NO = ' SB-ACCOUNT-NO                  
              DISPLAY '** 7447 : RETURN CODE ERROR - SELECT '           
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '************* PCSKR400 *******************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7447-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  7465                                                          *15202500
      ******************************************************************        
       7465-PERFORM-INVALID-RCVBLES.                                    
                                                                        
           EXEC SQL                                                     
              SELECT SUM (AMT_AR_DAY_00 + AMT_AR_DAY_30 +               
                          AMT_AR_DAY_60 + AMT_AR_DAY_90 +               
                          AMT_TRAN_BALANCE)                             
              INTO  :WS-TOT-INV-RCVBLE :WS-NULL-INV-RCVBLE              
              FROM  CSS_AR_CNTL WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO       = :AC-ACCOUNT-NO                   
              AND ((PYMT_PRIORITY_LVL IN (50, 80, 90, 129)              
                 AND ITEM_ID > 0 )                                      
               OR (PYMT_PRIORITY_LVL = 70                               
              AND ITEM_ID = 3))                                         
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15202900
MFA-TR*       SELECT SUM (AMT_AR_DAY_00 + AMT_AR_DAY_30 +               15203000
MFA-TR*                   AMT_AR_DAY_60 + AMT_AR_DAY_90 +               15203100
MFA-TR*                   AMT_TRAN_BALANCE)                             15203200
MFA-TR*       INTO  :WS-TOT-INV-RCVBLE :WS-NULL-INV-RCVBLE              15203300
MFA-TR*       FROM  CSS_AR_CNTL                                         15203400
MFA-TR*       WHERE ACCOUNT_NO       = :AC-ACCOUNT-NO                   15203500
MFA-TR*       AND ((PYMT_PRIORITY_LVL IN (50, 80, 90, 129)                      
MFA-TR*          AND ITEM_ID > 0 )                                              
MFA-TR*        OR (PYMT_PRIORITY_LVL = 70                                       
MFA-TR*       AND ITEM_ID = 3))                                                 
MFA-TR*       QUERYNO 7465                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    15203700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-INV-RCVBLE = -1                                
                 MOVE ZERO            TO WS-TOT-INV-RCVBLE              
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE ZERO            TO WS-TOT-INV-RCVBLE              
                 DISPLAY '************* PCSKR400 *******************'   
                 DISPLAY '** AR_CNTL  TABLE                   '         
                 DISPLAY '** ACCOUNT NO = ' AC-ACCOUNT-NO               
                 DISPLAY '** 7465 : RETURN CODE ERROR - SELECT '        
                 DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE       
                 DISPLAY '************* PCSKR400 *******************'   
              PERFORM 9900-ABEND                THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
       7465-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7470                                                          *15202500
      ******************************************************************        
       7466-PERFORM-VALID-RCVBLES.                                      
                                                                        
           EXEC SQL                                                     
              SELECT SUM (AMT_AR_DAY_00 + AMT_AR_DAY_30 +               
                          AMT_AR_DAY_60 + AMT_AR_DAY_90 )               
                                                                        
              INTO  :WS-TOT-VAL-RCVBLE :WS-NULL-INV-RCVBLE              
              FROM  CSS_AR_CNTL WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO       = :AC-ACCOUNT-NO                   
              AND ((PYMT_PRIORITY_LVL >= 50                             
                 AND ITEM_ID > 0 )                                      
               OR (PYMT_PRIORITY_LVL < 50                               
              AND ITEM_ID = 0))                                         
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15202900
MFA-TR*       SELECT SUM (AMT_AR_DAY_00 + AMT_AR_DAY_30 +               15203000
MFA-TR*                   AMT_AR_DAY_60 + AMT_AR_DAY_90 )               15203100
MFA-TR*                                                                 15203200
MFA-TR*       INTO  :WS-TOT-VAL-RCVBLE :WS-NULL-INV-RCVBLE              15203300
MFA-TR*       FROM  CSS_AR_CNTL                                         15203400
MFA-TR*       WHERE ACCOUNT_NO       = :AC-ACCOUNT-NO                   15203500
MFA-TR*       AND ((PYMT_PRIORITY_LVL >= 50                                     
MFA-TR*          AND ITEM_ID > 0 )                                              
MFA-TR*        OR (PYMT_PRIORITY_LVL < 50                                       
MFA-TR*       AND ITEM_ID = 0))                                                 
MFA-TR*       QUERYNO 7470                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    15203700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-INV-RCVBLE = -1                                
                 MOVE ZERO            TO WS-TOT-VAL-RCVBLE              
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 DISPLAY '************* PCSKR400 *******************'   
                 DISPLAY '** AR_CNTL  TABLE                   '         
                 DISPLAY '** ACCOUNT NO = ' AC-ACCOUNT-NO               
                 DISPLAY '** 7466 : RETURN CODE ERROR - SELECT '        
                 DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE       
                 DISPLAY '************* PCSKR400 *******************'   
              PERFORM 9900-ABEND                THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
       7466-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7470                                                          *15202500
      ******************************************************************        
       7470-PERFORM-CREDIT-RCVBLES.                                     
                                                                        
ACT182     INITIALIZE  WS-AMT-TRAN-BALANCE,                             
ACT182                 WS-AMT-TRAN-NULL-IND.                            
ACT182                                                                  
           EXEC SQL                                                     
ACT182        SELECT  SUM(AMT_TRAN_BALANCE)                             
ACT182          INTO :WS-AMT-TRAN-BALANCE :WS-AMT-TRAN-NULL-IND         
ACT182          FROM  CSS_AR_CNTL WITH(READUNCOMMITTED)                         
ACT182         WHERE ACCOUNT_NO        =  :AC-ACCOUNT-NO                
ACT182           AND ITEM_ID           >  0                             
ACT182           AND AMT_TRAN_BALANCE  <  0                             
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15202900
MFA-TR*       SELECT  SUM(AMT_TRAN_BALANCE)                             15203200
MFA-TR*         INTO :WS-AMT-TRAN-BALANCE :WS-AMT-TRAN-NULL-IND         15203300
MFA-TR*         FROM  CSS_AR_CNTL                                       15203400
MFA-TR*        WHERE ACCOUNT_NO        =  :AC-ACCOUNT-NO                15203500
MFA-TR*          AND ITEM_ID           >  0                             15203600
MFA-TR*          AND AMT_TRAN_BALANCE  <  0                                     
MFA-TR*       QUERYNO 7470                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    15203700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT182         IF WS-AMT-TRAN-NULL-IND  = -1                            
ACT182            MOVE 0                 TO WS-AMT-TRAN-BALANCE         
ACT182         END-IF.                                                  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '************* PCSKR400 *******************'      
              DISPLAY '** AR_CNTL  TABLE                   '            
              DISPLAY '** ACCOUNT NO = ' AC-ACCOUNT-NO                  
              DISPLAY '** 7470 : RETURN CODE ERROR - SELECT '           
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '************* PCSKR400 *******************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7470-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7550-OPEN-REFORECAST-WO.                                **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       7550-OPEN-REFORECAST-WO.                                         
                                                                        
           MOVE '7550'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
                OPEN REFORECAST_WO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    ERROR IN 7550-OPEN-REFORECAST-WO    **'   
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    FINAL BILL DT = ' WS-FINAL-PROCESS-DT     
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7555-FETCH-REFORECAST-WO.                               **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       7555-FETCH-REFORECAST-WO.                                        
                                                                        
           EXEC SQL                                                     
                FETCH REFORECAST_WO                                     
                INTO  :AT-ACCOUNT-NO,                                   
                      :AT-COMPANY-NO,                                   
                      :AT-CODE-STATUS-REASON                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  ERROR IN 7555-FETCH-FORECAST-WO      **'    
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7555-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7560-CLOSE-REFORECAST-WO.                               **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       7560-CLOSE-REFORECAST-WO.                                        
                                                                        
           MOVE '7560'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
                CLOSE REFORECAST_WO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    ERROR IN 7560-CLOSE-REFORECAST-WO    **'  
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' WS-ACCOUNT-NBR             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7560-EXIT.                                                       
           EXIT.                                                        
      **                                                                        
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7603-OPEN-CUST-RECEIVABLES.                             **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       7603-OPEN-CUST-RECEIVABLES.                                      
      *                                                                         
           MOVE '7603'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                OPEN CUST-RECEIVABLE                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    ERROR IN 7603-OPEN-CUST-RECEIVABLES **'   
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' WS-ACCOUNT-NBR             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7603-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7613-FETCH-CUST-RECEIVABLES.                            **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       7613-FETCH-CUST-RECEIVABLES.                                     
      *                                                                         
           EXEC SQL                                                     
                FETCH CUST-RECEIVABLE                                   
                INTO  :AC-AMT-AR-DAY-00,                                
                      :AC-AMT-AR-DAY-30,                                
                      :AC-AMT-AR-DAY-60,                                
                      :AC-AMT-AR-DAY-90,                                
                      :AC-AMT-UNUSED-CR,                                
                      :AC-AMT-TRAN-BALANCE,                             
                      :AC-ITEM-ID,                                      
                      :AC-PYMT-PRIORITY-LVL                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  ERROR IN 7613-FETCH-CUST-RECEIVABLES **'    
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' WS-ACCOUNT-NBR             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7613-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7623-CLOSE-CUST-RECEIVABLES.                            **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       7623-CLOSE-CUST-RECEIVABLES.                                     
      *                                                                         
           MOVE '7623'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                CLOSE CUST-RECEIVABLE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    ERROR IN 7621-CLOSE-CUST-RECEIVABLES **'  
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' WS-ACCOUNT-NBR             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7623-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GET THE PATH-TYPE-CODE FROM CSS_FINAL_WO TABLE.                *        
      ******************************************************************        
       7676-GET-PATH-TYPE-CODE.                                         
                                                                        
           EXEC SQL                                                     
               SELECT FW_PATH_TYPE_CD                                   
                 INTO :FW-FW-PATH-TYPE-CD                               
                 FROM CSS_FINAL_WO WITH(READUNCOMMITTED)                        
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FW_PATH_TYPE_CD                                           
MFA-TR*          INTO :FW-FW-PATH-TYPE-CD                                       
MFA-TR*          FROM CSS_FINAL_WO                                              
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7676                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '** 7676-GET-PATH-TYPE-CODE **'                  
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY 'ACCOUNT NO =' AT-ACCOUNT-NO                     
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7676-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GET THE PATH-TYPE-CODE FROM CSS_FINAL_WO TABLE.                *        
      ******************************************************************        
       7677-GET-COLLECT-STATUS-CODE.                                    
                                                                        
           EXEC SQL                                                     
               SELECT COLLECT_STATUS_CD                                 
                 INTO :FW-COLLECT-STATUS-CD                             
                 FROM CSS_FINAL_WO WITH(READUNCOMMITTED)                        
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COLLECT_STATUS_CD                                         
MFA-TR*          INTO :FW-COLLECT-STATUS-CD                                     
MFA-TR*          FROM CSS_FINAL_WO                                              
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7677                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '** 7677-GET-COLLECT-STATUS-CODE **'             
               DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '**  ACCOUNT NO =' AT-ACCOUNT-NO                 
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7677-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GET THE ACTION AMOUNT AND COLLECTION AGENCY CODE               *        
      ******************************************************************        
       7679-GET-COLLECTION-AGNCY-CD.                                    
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) KD.FW_ACTION_AM,
              KD.FW_ACTION_DT,
              IZ.CODE_COLLEC_AGNCY                              
                 INTO :KD-FW-ACTION-AM,                                 
                      :KD-FW-ACTION-DT,                                 
                      :IZ-CODE-COLLEC-AGNCY :WS-IZ-COLL-AGY-NULL        
                 FROM CSS_FIN_WO_ACTION KD WITH(READUNCOMMITTED),               
                      CSS_FIN_WO_COLLECT IZ WITH(READUNCOMMITTED)               
                WHERE KD.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                  AND KD.ACCOUNT_NO = IZ.ACCOUNT_NO                     
                  AND KD.FW_ACTION_TYPE_CD = IZ.FW_ACTION_TYPE_CD       
                  AND KD.FW_SEQ_NO = IZ.FW_COLL_SEQ_NO                  
                  AND KD.FW_PROCESSED_FL = 'Y'                          
                  AND KD.FW_ACTION_TYPE_CD = :WS-ACTION-TYPE-CD         
                ORDER BY                                                
                      KD.FW_SEQ_NO DESC                                 
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT KD.FW_ACTION_AM,                                          
MFA-TR*               KD.FW_ACTION_DT,                                          
MFA-TR*               IZ.CODE_COLLEC_AGNCY                                      
MFA-TR*          INTO :KD-FW-ACTION-AM,                                         
MFA-TR*               :KD-FW-ACTION-DT,                                         
MFA-TR*               :IZ-CODE-COLLEC-AGNCY :WS-IZ-COLL-AGY-NULL                
MFA-TR*          FROM CSS_FIN_WO_ACTION KD,                                     
MFA-TR*               CSS_FIN_WO_COLLECT IZ                                     
MFA-TR*         WHERE KD.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           AND KD.ACCOUNT_NO = IZ.ACCOUNT_NO                             
MFA-TR*           AND KD.FW_ACTION_TYPE_CD = IZ.FW_ACTION_TYPE_CD               
MFA-TR*           AND KD.FW_SEQ_NO = IZ.FW_COLL_SEQ_NO                          
MFA-TR*           AND KD.FW_PROCESSED_FL = 'Y'                                  
MFA-TR*           AND KD.FW_ACTION_TYPE_CD = :WS-ACTION-TYPE-CD                 
MFA-TR*         ORDER BY                                                        
MFA-TR*               KD.FW_SEQ_NO DESC                                         
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7679                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 IF WS-IZ-COLL-AGY-NULL < 0                             
                    MOVE SPACES TO IZ-CODE-COLLEC-AGNCY                 
                 END-IF                                                 
                 MOVE KD-FW-ACTION-AM TO WS-COLLECTION-AM               
              WHEN NOT-FOUND                                            
                 MOVE 0      TO WS-COLLECTION-AM                        
                 MOVE SPACES TO IZ-CODE-COLLEC-AGNCY                    
              WHEN OTHER                                                
                 DISPLAY '** 7679-GET-COLLECTION-AGNCY-CD **'           
                 DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE      
                 DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO               
                 DISPLAY '** ACTION TYPE CD = ' WS-ACTION-TYPE-CD       
                 DISPLAY '**      PROCESSING IS TERMINATED     **'      
                 PERFORM 9900-ABEND                THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7679-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *****************************************************************         
      *CHECK WHETHER THE ACCOUNT IS REGULATED OR DEREGULATED          *         
      *****************************************************************         
       7681-CHECK-REG-DEREG-ACCT.                                       
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-REG-DEREG-FLAG                                
                 FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NBR                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-REG-DEREG-FLAG                                        
MFA-TR*          FROM CSS_REG_PROFILE                                           
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NBR                               
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7681                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE 'N'              TO WS-REG-DEREG-FLAG             
              WHEN OTHER                                                
                 DISPLAY '** 7681-CHECK-REG-DEREG-ACCT **'              
                 DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE 
                 DISPLAY 'ACCOUNT NO =' WS-ACCOUNT-NBR                  
                 DISPLAY '**      PROCESSING IS TERMINATED     **'      
                 PERFORM 9900-ABEND                THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7681-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7685-GET-MAX-OF-SEQ-NO                                         *        
      ******************************************************************        
       7685-GET-MAX-OF-SEQ-NO.                                          
                                                                        
           EXEC SQL                                                     
               SELECT MAX(FW_SEQ_NO)                                    
                 INTO :WS-FW-SEQ-NO :WS-FW-SEQ-NO-NULL-IND               
                 FROM CSS_FIN_WO_ACTION                                 
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(FW_SEQ_NO)                                            
MFA-TR*          INTO :WS-FW-SEQ-NO:WS-FW-SEQ-NO-NULL-IND                       
MFA-TR*          FROM CSS_FIN_WO_ACTION                                         
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*       QUERYNO 7685                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.      
                                                                        
               IF WS-FW-SEQ-NO-NULL-IND = -1                            
                  MOVE 0                 TO WS-FW-SEQ-NO                
               END-IF.                                                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '** 7685-GET-MAX-OF-SEQ-NO **'                   
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY 'ACCOUNT NO =' AT-ACCOUNT-NO                     
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7685-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7690-SELECT-RCC-DETAILS.                                **  00272000
      **                                                            **  00273000
      **    SELECT DETERMINES THE EXISTENCE OF THE THREE RECEIVABLES**  00273000
      **    THAT MUST BE TRANSFORMED PRIOR TO WRITE-OFF.            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       7690-SELECT-RCC-DETAILS.                                         
      *                                                                         
           MOVE '7690'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
             SELECT A.RCNCT_TYPE_NO,                                    
                    B.RCNCT_ELEC_SVC_FL,                                
                    B.RCNCT_GAS_SVC_FL                                  
             INTO   :CC-RCNCT-TYPE-NO,                                  
                    :U7-RCNCT-ELEC-SVC-FL,                              
                    :U7-RCNCT-GAS-SVC-FL                                
             FROM  CSS_CONNECT_CHRG A
                           WITH(READUNCOMMITTED), CSS_RECONNECT_CHRG B
                           WITH(READUNCOMMITTED)             
             WHERE ACCOUNT_NO         = :AC-ACCOUNT-NO                  
               AND PYMT_PRIORITY_LVL  = :AC-PYMT-PRIORITY-LVL           
               AND A.CCC_ITEM_ID      = :AC-ITEM-ID                     
               AND B.COMPANY_NO       = :AT-COMPANY-NO                  
               AND A.RCNCT_TYPE_NO    = B.RCNCT_TYPE_NO                 
               AND B.RCNCT_ACCT_TYPE_CD = :AT-ACCOUNT-TYPE-CODE         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT A.RCNCT_TYPE_NO,                                            
MFA-TR*             B.RCNCT_ELEC_SVC_FL,                                        
MFA-TR*             B.RCNCT_GAS_SVC_FL                                          
MFA-TR*      INTO   :CC-RCNCT-TYPE-NO,                                          
MFA-TR*             :U7-RCNCT-ELEC-SVC-FL,                                      
MFA-TR*             :U7-RCNCT-GAS-SVC-FL                                        
MFA-TR*      FROM  CSS_CONNECT_CHRG A, CSS_RECONNECT_CHRG B                     
MFA-TR*      WHERE ACCOUNT_NO         = :AC-ACCOUNT-NO                          
MFA-TR*        AND PYMT_PRIORITY_LVL  = :AC-PYMT-PRIORITY-LVL                   
MFA-TR*        AND A.CCC_ITEM_ID      = :AC-ITEM-ID                             
MFA-TR*        AND B.COMPANY_NO       = :AT-COMPANY-NO                          
MFA-TR*        AND A.RCNCT_TYPE_NO    = B.RCNCT_TYPE_NO                         
MFA-TR*        AND B.RCNCT_ACCT_TYPE_CD = :AT-ACCOUNT-TYPE-CODE                 
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7690                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '**    ERROR IN 7690-SELECT-RCC-DETAILS **'       
              DISPLAY '**    RETURN CODE = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**    ACCOUNT NO = ' AC-ACCOUNT-NO               
              DISPLAY '**   PAYMENT PRIORITY LEVEL = '                  
                        AC-PYMT-PRIORITY-LVL                            
              DISPLAY '**   ITEM ID = ' AC-ITEM-ID                      
              DISPLAY '**      PROCESSING IS TERMINATED     **'         
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7690-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7700-OPEN-UTIL-ENV-CSR                                  **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       7700-OPEN-UTIL-ENV-CSR.                                          
      *                                                                         
           MOVE '7700'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                OPEN UTIL-ENV-CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    ERROR IN 7700-OPEN-UTIL-ENV-CSR     **'   
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' WS-ACCOUNT-NBR             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7710-FETCH-UTIL-ENV-CSR.                                **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       7710-FETCH-UTIL-ENV-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
                FETCH UTIL-ENV-CSR                                      
                INTO  :UT-CODE-UTIL-TYPE,                               
                      :UT-IC-NO                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  ERROR IN 7710-FETCH-UTIL-ENV-CSR    **'     
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' WS-ACCOUNT-NBR             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7720-CLOSE-UTIL-ENV-CSR.                                **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
        7720-CLOSE-UTIL-ENV-CSR.                                        
      *                                                                         
           MOVE '7720'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                CLOSE UTIL-ENV-CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    ERROR IN  7720-CLOSE-UTIL-ENV-CSR    **'  
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' WS-ACCOUNT-NBR             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7720-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7730-OPEN-FIN-WO-PATH-CUR                               **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       7730-OPEN-FIN-WO-PATH-CUR.                                       
      *                                                                         
           MOVE '7730'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                OPEN FIN_WO_PATH_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    ERROR IN 7730-OPEN-FIN-WO-PATH-CUR **'    
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7730-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7740-FETCH-FIN-WO-PATH-CUR                               ** 00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       7740-FETCH-FIN-WO-PATH-CUR.                                      
      *                                                                         
           EXEC SQL                                                     
                FETCH FIN_WO_PATH_CUR                                   
                 INTO :F8-COMPANY-NO,                                   
                      :F8-REG-GROUP-CD,                                 
                      :F8-FW-PATH-TYPE-CD,                              
                      :F8-FW-ACTION-SEQ-NO,                             
                      :F8-FW-ACTION-TYPE-CD,                            
                      :F8-FW-FCST-DAYS-NM,                              
                      :F8-FW-FCST-TIME-CD,                              
                      :F8-FW-FCST-SOURCE-CD,                            
                      :F8-FW-ACTION-LIMIT-AM,                           
                      :F8-FW-FCST-COLL-FL,                              
AC4527                :F8-FW-BUS-PROCESS-CD                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 0115-LOAD-F8-KA-VARIABLE      THRU 0115-EXIT      
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET NO-MORE-ROWS TO TRUE                               
                 PERFORM 7750-CLOSE-FIN-WO-PATH-CUR THRU 7750-EXIT      
              ELSE                                                      
                 DISPLAY '**  ERROR IN 7740-FETCH-FIN-WO-PATH-CUR   **' 
                 DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
                 DISPLAY '**  PROCESSING IS TERMINATED              **' 
                 PERFORM 9900-ABEND                THRU 9900-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7740-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7750-CLOSE-FIN-WO-PATH-CUR                              **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
        7750-CLOSE-FIN-WO-PATH-CUR.                                     
      *                                                                         
           MOVE '7750'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                CLOSE FIN_WO_PATH_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    ERROR IN  7750-CLOSE-FIN-WO-PATH-CUR  **' 
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7755-GET-CONTRACT-REC-BAL                               **  00272000
      **                                                            **  00273000
      ****************************************************************  00273500
       7755-GET-CONTRACT-REC-BAL.                                       
      *                                                                         
           MOVE '7755'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                   SUM(AMT_TRAN_BALANCE),                               
                   SUM(AMT_UNUSED_CR)                                   
                INTO                                                    
                   :WS-CONTRACT-REC-AMT,                                
                   :WS-CONTRACT-REC-UN-CR                               
                FROM  CSS_AR_CNTL                                       
                WHERE                                                   
                    ACCOUNT_NO        = :AC-ACCOUNT-NO                  
                AND PYMT_PRIORITY_LVL = :WS-CONTRACT                    
                AND ITEM_ID           > 0                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*            SUM(AMT_TRAN_BALANCE),                                       
MFA-TR*            SUM(AMT_UNUSED_CR)                                           
MFA-TR*         INTO                                                            
MFA-TR*            :WS-CONTRACT-REC-AMT,                                        
MFA-TR*            :WS-CONTRACT-REC-UN-CR                                       
MFA-TR*         FROM  CSS_AR_CNTL                                               
MFA-TR*         WHERE                                                           
MFA-TR*             ACCOUNT_NO        = :AC-ACCOUNT-NO                          
MFA-TR*         AND PYMT_PRIORITY_LVL = :WS-CONTRACT                            
MFA-TR*         AND ITEM_ID           > 0                                       
MFA-TR*       QUERYNO 7755                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    ERROR IN 7755-GET-CONTRACT-REC-BAL ***'   
               DISPLAY '**    RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '**    ACCOUNT NO = ' AC-ACCOUNT-NO              
               DISPLAY '**    PAYMENT PRIORITY LEVEL = ' WS-CONTRACT    
               DISPLAY '**    PROCESSING IS TERMINATED           ***'   
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7755-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7760-SELECT-FW-ACTION-AM                                       *        
      ******************************************************************        
       7760-SELECT-FW-ACTION-AM.                                        
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) KD.FW_ACTION_AM,
              KD.FW_SEQ_NO,
              KD.FW_ACTION_DT                                 
                  INTO :WS-FW-OLD-ACTION-AM                             
                      ,:WS-FW-OLD-SEQ-NO                                
                      ,:WS-FW-OLD-ACTION-DT                             
                  FROM CSS_FIN_WO_ACTION KD WITH(READUNCOMMITTED)               
                 WHERE KD.ACCOUNT_NO        = :AT-ACCOUNT-NO            
                   AND KD.FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD     
                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  KD.FW_ACTION_AM                                         
MFA-TR*                ,KD.FW_SEQ_NO                                            
MFA-TR*                ,KD.FW_ACTION_DT                                         
MFA-TR*           INTO :WS-FW-OLD-ACTION-AM                                     
MFA-TR*               ,:WS-FW-OLD-SEQ-NO                                        
MFA-TR*               ,:WS-FW-OLD-ACTION-DT                                     
MFA-TR*           FROM CSS_FIN_WO_ACTION KD                                     
MFA-TR*          WHERE KD.ACCOUNT_NO        = :AT-ACCOUNT-NO                    
MFA-TR*            AND KD.FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD             
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*       QUERYNO 7760                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    ERROR IN  7760-SELECT-FW-ACTION-AM  **'   
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' AT-ACCOUNT-NO              
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7760-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 7770-GET-WO-SEQ-FROM-FCST-ACTN                                *         
      *                                                               *         
      *****************************************************************         
       7770-GET-WO-SEQ-FROM-FCST-ACTN.                                  
                                                                        
            EXEC SQL                                                    
                SELECT TOP(1) FW_ACTION_SEQ_NO                                 
                 INTO :F8-FW-ACTION-SEQ-NO                              
                 FROM CSS_FW_FCST_ACTION WITH(READUNCOMMITTED)                  
                 WHERE FW_PATH_TYPE_CD   =  :FW-FW-PATH-TYPE-CD         
                   AND COMPANY_NO        =  :AT-COMPANY-NO              
                   AND REG_GROUP_CD      =  :LR-REG-GROUP-CD            
                   AND FW_ACTION_TYPE_CD =  :WS-ACTION-TYPE-CD          
                   AND FW_FCST_TIME_CD   <> 'R'                         
                                           
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT FW_ACTION_SEQ_NO                                         
MFA-TR*          INTO :F8-FW-ACTION-SEQ-NO                                      
MFA-TR*          FROM CSS_FW_FCST_ACTION                                        
MFA-TR*          WHERE FW_PATH_TYPE_CD   =  :FW-FW-PATH-TYPE-CD                 
MFA-TR*            AND COMPANY_NO        =  :AT-COMPANY-NO                      
MFA-TR*            AND REG_GROUP_CD      =  :LR-REG-GROUP-CD                    
MFA-TR*            AND FW_ACTION_TYPE_CD =  :WS-ACTION-TYPE-CD                  
MFA-TR*            AND FW_FCST_TIME_CD   <> 'R'                                 
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*       QUERYNO 7770                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
            IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
            ELSE                                                        
               DISPLAY '** 7770-GET-WO-SEQ-FROM-FCST-ACTN **'           
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY 'ACCOUNT NO =' AT-ACCOUNT-NO                     
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
            END-IF.                                                     
      *                                                                         
       7770-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7780-GET-MAX-OF-WO-SEQ-NO                                      *        
      ******************************************************************        
       7780-GET-MAX-OF-WO-SEQ-NO.                                       
                                                                        
           EXEC SQL                                                     
               SELECT MAX(FW_SEQ_NO)                                    
                 INTO :WS-WO-SEQ-NO-MAX :WS-FW-SEQ-NO-NULL-IND           
                 FROM CSS_FIN_WO_ACTION                                 
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND FW_ACTION_TYPE_CD = :WS-ACTION-TYPE-CD            
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(FW_SEQ_NO)                                            
MFA-TR*          INTO :WS-WO-SEQ-NO-MAX:WS-FW-SEQ-NO-NULL-IND                   
MFA-TR*          FROM CSS_FIN_WO_ACTION                                         
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND FW_ACTION_TYPE_CD = :WS-ACTION-TYPE-CD                    
MFA-TR*       QUERYNO 7780                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-FW-SEQ-NO-NULL-IND = -1                                
              MOVE 0                 TO WS-WO-SEQ-NO-MAX                
           END-IF                                                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '** 7780-GET-WO-SEQ-FROM-FCST-ACTN **'           
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY 'ACCOUNT NO =' AT-ACCOUNT-NO                     
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7780-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7800-OPEN-CNT-CSR.                                      **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       7800-OPEN-CNT-CSR.                                               
      *                                                                         
           MOVE '7800'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                OPEN CNT-CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    ERROR IN 7800-OPEN-CNT-CSR.         **'   
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' WS-ACCOUNT-NBR             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7810-FETCH-CNT-CSR.                                     **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       7810-FETCH-CNT-CSR.                                              
      *                                                                         
           EXEC SQL                                                     
                FETCH CNT-CSR                                           
                INTO  :CT-AMT-ORIG-ENTERED,                             
                      :CT-CODE-CONTRACT-TYPE,                           
                      :CT-CNT-NAME-CD,                                  
                      :CT-CNT-ITEM-ID,                                  
                      :CT-GL-ACCT-NO-DEF-INT,                           
                      :CT-GL-ACCT-NO-ERN-INT,                           
                      :CT-AMT-DEF-INTEREST,                             
                      :CT-SIMPLE-INT-FIN-CHG,                           
                      :EA-CHARGE-AM,                                    
ACT278                :CT-AMT-TAX-CITY,                                 
ACT278                :CT-AMT-TAX-OTHER,                                
ACT278                :CT-AMT-TAX-STATE,                                
                      :EA-WRT-OFF-GL-ACCT-NO                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  ERROR IN 7810-FETCH-CNT-CSR      **'        
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' WS-ACCOUNT-NBR             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7820-CLOSE-CNT-CSR.                                     **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
        7820-CLOSE-CNT-CSR.                                             
      *                                                                         
           MOVE '7820'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                CLOSE CNT-CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    ERROR IN  7820-CLOSE-DFA-CSR         **'  
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' WS-ACCOUNT-NBR             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7820-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7825-GET-CNTRCT-NAME.                                   **  00272000
      **                                                            **  00273000
      **    GETS THE CONTRACT NAME FROM CSSCONTRACT_INFO            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       7825-GET-CNTRCT-NAME.                                            
      *                                                                         
           MOVE '7825'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
             SELECT K6.CNT_NAME_DESC                                    
             INTO   :K6-CNT-NAME-DESC                                   
             FROM  CSS_CONTRACT_INFO K6 WITH(READUNCOMMITTED)                   
             WHERE CNT_NAME_CD        = :K6-CNT-NAME-CD                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT K6.CNT_NAME_DESC                                            
MFA-TR*      INTO   :K6-CNT-NAME-DESC                                           
MFA-TR*      FROM  CSS_CONTRACT_INFO K6                                         
MFA-TR*      WHERE CNT_NAME_CD        = :K6-CNT-NAME-CD                         
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7825                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    ERROR IN 7825-GET-CNTRCT-NAME **'         
               DISPLAY '**    NAME CODE   = ' K6-CNT-NAME-CD            
               DISPLAY '**    RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7825-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7830-OPEN-UNMTRD-CSR                                    **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       7830-OPEN-UNMTRD-CSR.                                            
      *                                                                         
           MOVE '7830'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                OPEN UNMTRD-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    ERROR IN 7830-OPEN-UNMTRD-CSR       **'   
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' WS-ACCOUNT-NBR             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7830-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7840-FETCH-UNMTRD-CSR.                                  **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       7840-FETCH-UNMTRD-CSR.                                           
      *                                                                         
           EXEC SQL                                                     
                FETCH UNMTRD-CURSOR                                     
                INTO  :CP-CODE-SERVICE-TYPE                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  ERROR IN 7840-FETCH-UNMTRD-CSR      **'     
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' WS-ACCOUNT-NBR             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7840-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7850-CLOSE-UNMTRD-CSR                                   **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
        7850-CLOSE-UNMTRD-CSR.                                          
      *                                                                         
           MOVE '7850'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                CLOSE UNMTRD-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    ERROR IN  7850-CLOSE-UNMTRD-CSR      **'  
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' WS-ACCOUNT-NBR             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7900-OPEN-WO-ACCT-ACT-REC                               **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       7900-OPEN-WO-ACCT-ACT-REC.                                       
      *                                                                         
           MOVE '7900'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                OPEN WO_ACCT_ACT_REC                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    ERROR IN 7900-OPEN-WO-ACCT-ACT-REC  **'   
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' WS-ACCOUNT-NBR             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7905-FETCH-WO-ACCT-ACT-REC                              **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       7905-FETCH-WO-ACCT-ACT-REC.                                      
      *                                                                         
           EXEC SQL                                                     
                FETCH                                                   
                  WO_ACCT_ACT_REC                                       
                INTO                                                    
                  :AT-ACCOUNT-NO,                                       
                  :AT-CUSTOMER-NO,                                      
                  :AT-COMPANY-NO,                                       
                  :AT-CODES-DATA-PRESENT,                               
                  :AT-PREMISE-NO,                                       
                  :AT-ELEC-REV-ALLOC-PCT,                               
                  :AT-LOCAL-OFFICE,                                     
                  :AT-CODE-ACCT-STAT,                                   
                  :AT-DATE-BILL-DAY-00,                                 
                  :AT-CODE-STATUS-REASON,                               
                  :AT-CODE-COMPANY-ACCT,                                
                  :AT-TOTAL-AR-BALANCE,                                 
                  :AT-ACCOUNT-TYPE-CODE,                                
                  :AT-ADDRESS-FORMAT,                                   
                  :AT-ADDRESS-ID,                                       
                  :AT-CREDIT-GROUP,                                     
                  :AT-LAST-PYMT-AMOUNT,                                 
                  :AT-LAST-PYMT-DATE :WS-LAST-PYMT-DATE-NI,              
                  :B1-ELEC-REV-ALLOC-PCT,                               
                  :PR-CODE-PREMISE-STAT,                                
                  :PR-REV-DISTRICT-CD,                                  
                  :CU-CODE-EMPL-ACCT,                                   
                  :FW-REG-GROUP-CD,                                     
                  :FW-SENIOR-FL                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               IF WS-LAST-PYMT-DATE-NI < 0                              
                  MOVE SPACES TO AT-LAST-PYMT-DATE                      
               END-IF                                                   
           ELSE                                                         
               DISPLAY '**  ERROR IN 7905-FETCH-WO-ACCT-ACT-REC **'     
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**      ACCOUNT NO  = ' WS-ACCOUNT-NBR          
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7905-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7906-SELECT-CHRG-OFF                                    **  00272000
      **                                                            **  00273000
      ****************************************************************  00273500
      *                                                                         
       7906-SELECT-CHRG-OFF.                                            
      *                                                                         
           MOVE '7906'                 TO WS-ACTIVE-PARAGRAPH.          
           MOVE 'N'                    TO WS-CHRG-OFF-EXISTS.           
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) 'Y'                                                  
             INTO                                                       
                 :WS-CHRG-OFF-EXISTS                                    
             FROM  CSS_CHRG_OFF WITH(READUNCOMMITTED)                           
             WHERE ACCOUNT_NO = :CO-ACCOUNT-NO                          
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     18583400
MFA-TR*      SELECT                                                     18583500
MFA-TR*           'Y'                                                   18583600
MFA-TR*      INTO                                                       18583700
MFA-TR*          :WS-CHRG-OFF-EXISTS                                    18583800
MFA-TR*      FROM  CSS_CHRG_OFF                                                 
MFA-TR*      WHERE ACCOUNT_NO = :CO-ACCOUNT-NO                                  
MFA-TR*      FETCH FIRST 1 ROW ONLY                                             
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7906                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               MOVE 'Y' TO WS-ACCOUNT-ISSUE                             
               IF WS-INDEX-192 < 750                                    
                  ADD 1 TO WS-INDEX-192                                 
                  MOVE CO-ACCOUNT-NO TO WS-ACCOUNT(WS-INDEX-192)        
                  MOVE '- CHARGE OFF ROW DOES NOT EXIST.' TO            
                                      WS-REASON(WS-INDEX-192)           
               END-IF                                                   
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -811   
                  NEXT SENTENCE                                         
               ELSE                                                     
                  DISPLAY '**   ERROR IN 7906-SELECT-CHRG-OFF        *' 
                  DISPLAY '**    RETURN CODE = ' WS-ACTIVE-RETURN-CODE  
                  MOVE CO-ACCOUNT-NO     TO WS-ACCOUNT-FAIL             
                  DISPLAY '** ACCOUNT NO ' WS-ACCOUNT-FAIL              
                  DISPLAY '**    PROCESSING IS TERMINATED     **'       
                  PERFORM 9900-ABEND                THRU 9900-EXIT      
               END-IF                                                   
           END-IF.                                                      
       7906-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7910-CLOSE-WO-ACCT-ACT-REC                              **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
        7910-CLOSE-WO-ACCT-ACT-REC.                                     
      *                                                                         
           MOVE '7910'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                CLOSE WO_ACCT_ACT_REC                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    ERROR IN  7910-CLOSE-WO-ACCT-ACT-REC **'  
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' WS-ACCOUNT-NBR             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7915-OPEN-WO-CUST-RECEIVABLE                            **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       7915-OPEN-WO-CUST-RECEIVABLE.                                    
      *                                                                         
           MOVE '7915'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                OPEN WO_CUST_RECEIVABLE                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    ERROR IN 7915-OPEN-WO-CUST-RECEIVABLE *'  
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' WS-ACCOUNT-NBR             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7915-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7920-FETCH-WO-CUST-RECEIVABLE                           **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       7920-FETCH-WO-CUST-RECEIVABLE.                                   
      *                                                                         
           EXEC SQL                                                     
                FETCH                                                   
                  WO_CUST_RECEIVABLE                                    
                INTO                                                    
                  :AC-AMT-AR-DAY-00,                                    
                  :AC-AMT-AR-DAY-30,                                    
                  :AC-AMT-AR-DAY-60,                                    
                  :AC-AMT-AR-DAY-90,                                    
                  :AC-AMT-UNUSED-CR,                                    
                  :AC-AMT-TRAN-BALANCE,                                 
                  :AC-ITEM-ID,                                          
                  :AC-PYMT-PRIORITY-LVL                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  ERROR IN 7920-FETCH-WO-CUST-RECEIVABLE **'  
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' WS-ACCOUNT-NBR             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    7925-CLOSE-WO-CUST-RECEIVABLE                           **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
        7925-CLOSE-WO-CUST-RECEIVABLE.                                  
      *                                                                         
           MOVE '7925'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                CLOSE WO_CUST_RECEIVABLE                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    ERROR IN  7925-CLOSE-WO-CUST-RECEIVABLE *'
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' WS-ACCOUNT-NBR             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7925-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **    7960-CHECK-WO-EXISTS.                                 **    00272000
      **    CHECK IF ACCOUNT HAS A FUTURE WRITE OFF DATE.           **  00273000
      ****************************************************************  00273500
       7960-CHECK-WO-EXISTS.                                            
      *                                                                         
           MOVE '7960'                 TO WS-ACTIVE-PARAGRAPH.          
           MOVE 'N'                    TO WS-WO-DATE-EXISTS.            
      *                                                                         
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-WO-DATE-EXISTS                                
                 FROM CSS_FIN_WO_ACTION WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                
                  AND FW_ACTION_TYPE_CD = 'WO'                          
                  AND FW_ACTION_DT  > IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-WO-DATE-EXISTS                                        
MFA-TR*          FROM CSS_FIN_WO_ACTION                                         
MFA-TR*         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                        
MFA-TR*           AND FW_ACTION_TYPE_CD = 'WO'                                  
MFA-TR*           AND FW_ACTION_DT  > :WS-CURRENT-DATE                          
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7960                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
           OR MULTIPLE-ROWS                                             
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '**    ERROR IN 7960-CHECK-WO-EXISTS ***'        
               DISPLAY '**    RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '**    ACCOUNT NO  = ' AT-ACCOUNT-NO             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND             THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7960-EXIT.                                                       
           EXIT.                                                        
      *                                                                 30535900
      *                                                                         
      ****************************************************************  00271000
      **    7980-CHECK-VALID-RATE                                   **  00272000
      **    CHECK IF ACCOUNT HAS VALID RATE FOR COG CALCULATION     **  00273000
      ****************************************************************  00273500
       7980-CHECK-VALID-RATE.                                           
      *                                                                         
           MOVE '7980'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-VALID-RATE-FL                                 
                 FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)               
                     ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                WHERE UT.ACCOUNT_NO       = :UT-ACCOUNT-NO              
                  AND UT.COMPANY_NO       = :UT-COMPANY-NO              
                  AND UT.RATE_PLAN_NO     = RD.RATE_PLAN_NO             
                  AND UT.CODE_UTIL_TYPE   = RD.CODE_UTIL_TYPE           
                  AND UT.COMPANY_NO       = RD.COMPANY_NO               
                  AND RD.DEFERRED_COG_FL     = 'Y'                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-VALID-RATE-FL                                         
MFA-TR*          FROM CSS_RATE_PLAN_DESC RD                                     
MFA-TR*              ,CSS_UTIL_ENVRNMT UT                                       
MFA-TR*         WHERE UT.ACCOUNT_NO       = :UT-ACCOUNT-NO                      
MFA-TR*           AND UT.COMPANY_NO       = :UT-COMPANY-NO                      
MFA-TR*           AND UT.RATE_PLAN_NO     = RD.RATE_PLAN_NO                     
MFA-TR*           AND UT.CODE_UTIL_TYPE   = RD.CODE_UTIL_TYPE                   
MFA-TR*           AND UT.COMPANY_NO       = RD.COMPANY_NO                       
MFA-TR*           AND RD.DEFERRED_COG_FL     = 'Y'                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7980                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              OR MULTIPLE-ROWS                                          
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N'              TO WS-VALID-RATE-FL              
              ELSE                                                      
                 MOVE 'Y'              TO WS-VALID-RATE-FL              
              END-IF                                                    
           ELSE                                                         
               DISPLAY '**    ERROR IN 7980-CHECK-VALID-RATE **'        
               DISPLAY '**    RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '**    ACCOUNT NO  = ' UT-ACCOUNT-NO             
               DISPLAY '**    COMPANY NO  = ' UT-COMPANY-NO             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND             THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7980-EXIT.                                                       
           EXIT.                                                        
      *                                                                 30535900
      ****************************************************************  00271000
      **                                                            **  00271500
      **    8000-DLET-AR-CNTL                                       **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       8000-DLET-AR-CNTRL.                                              
      *                                                                         
           MOVE '8000'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CSS_AR_CNTL                                 
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NBR AND                  
                      PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL AND     
                      ITEM_ID = :AC-ITEM-ID                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**     ERROR IN 8000-DLET-AR-CNTL    **'        
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**   ACCOUNT NO        = ' WS-ACCOUNT-NBR       
               DISPLAY '**   PYMT PRIORITY LVL = ' AC-PYMT-PRIORITY-LVL 
               DISPLAY '**   ITEM ID           = ' AC-ITEM-ID           
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  18655100
      **                                                            **  18655200
      **    8020-UPD-PROCESS-FLAG.                                  **  18655300
      **                                                            **  18655400
      **                                                            **  18655500
      ****************************************************************  18655600
      *                                                                 18655700
       8020-UPD-PROCESS-FLAG.                                           
      *                                                                 18655900
           MOVE '8020'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_FIN_WO_ACTION                                   
               SET FW_PROCESSED_FL    = 'Y'                             
             WHERE ACCOUNT_NO         = :KD-ACCOUNT-NO                  
               AND FW_ACTION_TYPE_CD  = 'WO'                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 18659000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    8020-UPD-PROCESS-FLAG   **'               
               DISPLAY '**    RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '**    ACCOUNT NO  = ' KD-ACCOUNT-NO             
               DISPLAY '**    PROCESSING IS TERMINATED     **'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 18659900
       8020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************15183100
      *  8030-BUMP-WRITEOFF-DT                                          15183200
      ******************************************************************15183300
       8030-BUMP-WRITEOFF-DT.                                           
      *                                                                 16660000
           MOVE '8030'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_FIN_WO_ACTION                                   
               SET FW_ACTION_DT       = IIF(TRY_CONVERT(DATE, 
                                                       :KD-FW-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :KD-FW-ACTION-DT
              ) <> 0) OR (LEN(:KD-FW-ACTION-DT) <> 10), CIS.CHAR2DATE(
                                                       :KD-FW-ACTION-DT
              ), CONVERT(DATE, :KD-FW-ACTION-DT) )                
             WHERE ACCOUNT_NO         = :KD-ACCOUNT-NO                  
               AND FW_ACTION_TYPE_CD  = 'WO'                            
               AND FW_SEQ_NO          = :KD-FW-SEQ-NO                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     18656200
MFA-TR*      UPDATE CSS_FIN_WO_ACTION                                   15239000
MFA-TR*        SET FW_ACTION_DT       = :KD-FW-ACTION-DT                        
MFA-TR*      WHERE ACCOUNT_NO         = :KD-ACCOUNT-NO                          
MFA-TR*        AND FW_ACTION_TYPE_CD  = 'WO'                                    
MFA-TR*        AND FW_SEQ_NO          = :KD-FW-SEQ-NO                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 18659000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    8030-BUMP-WRITEOFF-DT   **'               
               DISPLAY '**    RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '**    ACCOUNT NO  = ' KD-ACCOUNT-NO             
               DISPLAY '**    SEQUENCE NO = ' KD-FW-SEQ-NO              
               DISPLAY '**      ACTION DT = ' KD-FW-ACTION-DT           
               DISPLAY '**    PROCESSING IS TERMINATED     **'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 18659900
       8030-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19311700
      *                                                                         
      ******************************************************************PCS40420
      *                                                                *PCS40430
      *      8050-UPDATE-COLL-AGY-WO-TOT                               *PCS40440
      *                                                                *PCS40450
      ******************************************************************PCS40480
      *                                                                         
       8050-UPDATE-COLL-AGY-WO-TOT.                                     
      *                                                                         
           EXEC SQL                                                     
                UPDATE CSS_CHG_OFF_AMT                                  
                  SET                                                   
                    WRITE_OFF_AMT        = :SN-WRITE-OFF-AMT            
                WHERE CODE_COLLEC_AGNCY  = :SN-CODE-COLLEC-AGNCY        
                  AND WRITE_OFF_MONTH_YR = :SN-WRITE-OFF-MONTH-YR       
                  AND COMPANY_NO         = :SN-COMPANY-NO               
                  AND REG_GROUP_CD       = :SN-REG-GROUP-CD             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '** ERROR IN 8050-UPDATE-COLL-AGY-WO-TOT '       
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '** PROCESSING IS TERMINATED     **'             
               DISPLAY '** CODE COLLEC AGNCY    ' SN-CODE-COLLEC-AGNCY  
               DISPLAY '** WO MONTH YEAR        ' SN-WRITE-OFF-MONTH-YR 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8050-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  00271000
      **                                                            **  00271500
      **    8400-ISRT-CHRG-OFF                                      **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       8400-ISRT-CHRG-OFF.                                              
      *                                                                         
           MOVE '8400'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_CHRG_OFF                                
                    (ACCOUNT_NO,                                        
                     PYMT_PRIORITY_LVL,                                 
                     ITEM_ID,                                           
                     DATE_OF_CHG_OFF,                                   
                     AMT_TRANS,                                         
                     CODE_CHG_OFF_REAS,                                 
                     WO_ORIGINAL_AM,                                    
                     WO_STATUS,                                         
                     CHG_OFF_DESC)                                      
                VALUES                                                  
                   (:CO-ACCOUNT-NO,                                     
                    :CO-PYMT-PRIORITY-LVL,                              
                    :CO-ITEM-ID,                                        
                    IIF(TRY_CONVERT(DATE, :CO-DATE-OF-CHG-OFF
              ) IS NULL OR (PATINDEX('%.%', :CO-DATE-OF-CHG-OFF
              ) <> 0) OR (LEN(:CO-DATE-OF-CHG-OFF
              ) <> 10), CIS.CHAR2DATE(:CO-DATE-OF-CHG-OFF
              ), CONVERT(DATE, :CO-DATE-OF-CHG-OFF) ),                         
                    :CO-AMT-TRANS,                                      
                    :CO-CODE-CHG-OFF-REAS,                              
                    :CO-WO-ORIGINAL-AM,                                 
                    :CO-WO-STATUS,                                      
                    :CO-CHG-OFF-DESC)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_CHRG_OFF                                        
MFA-TR*             (ACCOUNT_NO,                                                
MFA-TR*              PYMT_PRIORITY_LVL,                                         
MFA-TR*              ITEM_ID,                                                   
MFA-TR*              DATE_OF_CHG_OFF,                                           
MFA-TR*              AMT_TRANS,                                                 
MFA-TR*              CODE_CHG_OFF_REAS,                                         
MFA-TR*              WO_ORIGINAL_AM,                                            
MFA-TR*              WO_STATUS,                                                 
MFA-TR*              CHG_OFF_DESC)                                              
MFA-TR*         VALUES                                                          
MFA-TR*            (:CO-ACCOUNT-NO,                                             
MFA-TR*             :CO-PYMT-PRIORITY-LVL,                                      
MFA-TR*             :CO-ITEM-ID,                                                
MFA-TR*             :CO-DATE-OF-CHG-OFF,                                        
MFA-TR*             :CO-AMT-TRANS,                                              
MFA-TR*             :CO-CODE-CHG-OFF-REAS,                                      
MFA-TR*             :CO-WO-ORIGINAL-AM,                                         
MFA-TR*             :CO-WO-STATUS,                                              
MFA-TR*             :CO-CHG-OFF-DESC)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR ALREADY-EXISTS                
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**     ERROR IN 8400-ISRT-CHRG-OFF   **'        
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' CO-ACCOUNT-NO              
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    8410-REPL-CHRG-OFF                                      **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       8410-REPL-CHRG-OFF.                                              
      *                                                                         
           MOVE '8410'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                UPDATE CSS_CHRG_OFF                                     
                SET AMT_TRANS           = :CO-AMT-TRANS,                
                    WO_ORIGINAL_AM      = :CO-WO-ORIGINAL-AM,           
                    CODE_CHG_OFF_REAS   = :CO-CODE-CHG-OFF-REAS         
                WHERE ACCOUNT_NO        = :CO-ACCOUNT-NO AND            
                      PYMT_PRIORITY_LVL = :CO-PYMT-PRIORITY-LVL AND     
                      ITEM_ID           = :CO-ITEM-ID                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**     ERROR IN 8410-REPL-CHRG-OFF   **'        
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' CO-ACCOUNT-NO              
               DISPLAY '**    PAYMENT PRIOITY LEVEL = '                 
                              CO-PYMT-PRIORITY-LVL                      
               DISPLAY '**    ITEM ID = ' CO-ITEM-ID                    
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    8421-UPDT-BANK-EFT                                      **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       8421-UPDT-BANK-EFT.                                              
      *                                                                         
           MOVE '8421'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                UPDATE CSS_BANK_EFT                                     
                  SET  STATUS_CODE = 'D'                                
                WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                     
                AND   ACCOUNT_NO  = :WS-ACCOUNT-NBR                     
                AND STATUS_CODE NOT IN ('M','N','O')                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**                                   **'        
               DISPLAY '**     ERROR IN 8421-UPDT-BANK-EFT   **'        
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    CUSTOMER NO = ' AT-CUSTOMER-NO            
               DISPLAY '**    ACCOUNT NO  = ' WS-ACCOUNT-NO             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8421-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    8423-REPL-READ-INSTRUCTIONS                             **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       8423-REPL-READ-INSTRUCTIONS.                                     
      *                                                                         
           MOVE '8423'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                UPDATE CSS_PREMISE                                      
                SET SPCL_READ_INSTR = :PR-SPCL-READ-INSTR               
                WHERE PREMISE_NO    = :WS-PREMISE-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  ERROR IN 8423-REPL-READ-INSTRUCTIONS  **'   
               DISPLAY '**        RETURN CODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '**        PREMISE NO = ' WS-PREMISE-NO          
               DISPLAY '**        PROCESSING IS TERMINATED        **'   
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8423-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      *  8430-INSERT-FINAL-WO-ACTION                                   *        
      ******************************************************************        
                                                                        
       8430-INSERT-FINAL-WO-ACTION.                                     
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_FIN_WO_ACTION                            
                      (ACCOUNT_NO                                       
                      ,FW_SEQ_NO                                        
                      ,FW_ACTION_TYPE_CD                                
                      ,FW_ACTION_DT                                     
                      ,FW_ACTION_AM                                     
                      ,FW_MANUAL_FL                                     
                      ,FW_ACTION_COMMENTS                               
AC4527                ,FW_BUS_PROCESS_CD)                               
               VALUES (:KD-ACCOUNT-NO                                   
                      ,:KD-FW-SEQ-NO                                    
                      ,:KD-FW-ACTION-TYPE-CD                            
                      ,IIF(TRY_CONVERT(DATE, :KD-FW-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :KD-FW-ACTION-DT
              ) <> 0) OR (LEN(:KD-FW-ACTION-DT) <> 10), CIS.CHAR2DATE(
                                                       :KD-FW-ACTION-DT
              ), CONVERT(DATE, :KD-FW-ACTION-DT) )                             
                      ,:KD-FW-ACTION-AM                                 
                      ,:KD-FW-MANUAL-FL                                 
                      ,:KD-FW-ACTION-COMMENTS                           
AC4527                ,:KD-FW-BUS-PROCESS-CD)                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_FIN_WO_ACTION                                    
MFA-TR*               (ACCOUNT_NO                                               
MFA-TR*               ,FW_SEQ_NO                                                
MFA-TR*               ,FW_ACTION_TYPE_CD                                        
MFA-TR*               ,FW_ACTION_DT                                             
MFA-TR*               ,FW_ACTION_AM                                             
MFA-TR*               ,FW_MANUAL_FL                                             
MFA-TR*               ,FW_ACTION_COMMENTS                                       
MFA-TR*               ,FW_BUS_PROCESS_CD)                                       
MFA-TR*        VALUES (:KD-ACCOUNT-NO                                           
MFA-TR*               ,:KD-FW-SEQ-NO                                            
MFA-TR*               ,:KD-FW-ACTION-TYPE-CD                                    
MFA-TR*               ,:KD-FW-ACTION-DT                                         
MFA-TR*               ,:KD-FW-ACTION-AM                                         
MFA-TR*               ,:KD-FW-MANUAL-FL                                         
MFA-TR*               ,:KD-FW-ACTION-COMMENTS                                   
MFA-TR*               ,:KD-FW-BUS-PROCESS-CD)                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** 8430-INSERT-FINAL-WO-ACTION **'              
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '** ACCOUNT NO =' AT-ACCOUNT-NO                  
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8430-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  8440-INSERT-FINAL-WO-COLL                                    *         
      *****************************************************************         
                                                                        
       8440-INSERT-FINAL-WO-COLL.                                       
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_FIN_WO_COLLECT                           
                      (ACCOUNT_NO                                       
                      ,FW_ACTION_TYPE_CD                                
                      ,FW_COLL_SEQ_NO                                   
                      ,CUSTOMER_NO                                      
                      ,CODE_COLLEC_AGNCY                                
                      ,COLL_AGY_SUB_CD                                  
                      ,COMPANY_NO                                       
                      ,REG_GROUP_CD                                     
                      ,WITHDRAW_AM                                      
                      ,WITHDRAW_DT                                      
                      ,WITHDRAW_REASON_CD)                              
               VALUES (:IZ-ACCOUNT-NO                                   
                      ,:IZ-FW-ACTION-TYPE-CD                            
                      ,:IZ-FW-COLL-SEQ-NO                               
                      ,:IZ-CUSTOMER-NO                                  
                      ,:IZ-CODE-COLLEC-AGNCY                            
                      ,:IZ-COLL-AGY-SUB-CD                              
                      ,:IZ-COMPANY-NO                                   
                      ,:IZ-REG-GROUP-CD                                 
                      ,:IZ-WITHDRAW-AM                                  
                      ,IIF(TRY_CONVERT(DATE, :IZ-WITHDRAW-DT
              ) IS NULL OR (PATINDEX('%.%', :IZ-WITHDRAW-DT
              ) <> 0) OR (LEN(:IZ-WITHDRAW-DT) <> 10), CIS.CHAR2DATE(
                                                        :IZ-WITHDRAW-DT
              ), CONVERT(DATE, :IZ-WITHDRAW-DT) )                              
                      ,:IZ-WITHDRAW-REASON-CD)                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_FIN_WO_COLLECT                                   
MFA-TR*               (ACCOUNT_NO                                               
MFA-TR*               ,FW_ACTION_TYPE_CD                                        
MFA-TR*               ,FW_COLL_SEQ_NO                                           
MFA-TR*               ,CUSTOMER_NO                                              
MFA-TR*               ,CODE_COLLEC_AGNCY                                        
MFA-TR*               ,COLL_AGY_SUB_CD                                          
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,REG_GROUP_CD                                             
MFA-TR*               ,WITHDRAW_AM                                              
MFA-TR*               ,WITHDRAW_DT                                              
MFA-TR*               ,WITHDRAW_REASON_CD)                                      
MFA-TR*        VALUES (:IZ-ACCOUNT-NO                                           
MFA-TR*               ,:IZ-FW-ACTION-TYPE-CD                                    
MFA-TR*               ,:IZ-FW-COLL-SEQ-NO                                       
MFA-TR*               ,:IZ-CUSTOMER-NO                                          
MFA-TR*               ,:IZ-CODE-COLLEC-AGNCY                                    
MFA-TR*               ,:IZ-COLL-AGY-SUB-CD                                      
MFA-TR*               ,:IZ-COMPANY-NO                                           
MFA-TR*               ,:IZ-REG-GROUP-CD                                         
MFA-TR*               ,:IZ-WITHDRAW-AM                                          
MFA-TR*               ,:IZ-WITHDRAW-DT                                          
MFA-TR*               ,:IZ-WITHDRAW-REASON-CD)                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '** 8440-INSERT-FINAL-WO-ACTION **'              
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '** ACCOUNT NO =' AT-ACCOUNT-NO                  
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8440-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 8445-UPDATE-ACTN-DT                                            *        
      ******************************************************************        
       8445-UPDATE-ACTN-DT.                                             
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_FIN_WO_ACTION                                
                SET  FW_ACTION_DT       = IIF(TRY_CONVERT(DATE, 
                                                       :WS-FW-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-FW-ACTION-DT
              ) <> 0) OR (LEN(:WS-FW-ACTION-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-FW-ACTION-DT
              ), CONVERT(DATE, :WS-FW-ACTION-DT) )              
                    ,FW_PROCESSED_FL    = ' '                           
                WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                
                  AND FW_SEQ_NO         = :WS-FW-SEQ-NO                 
                  AND FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_FIN_WO_ACTION                                        
MFA-TR*         SET  FW_ACTION_DT       = :WS-FW-ACTION-DT                      
MFA-TR*             ,FW_PROCESSED_FL    = ' '                                   
MFA-TR*         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                        
MFA-TR*           AND FW_SEQ_NO         = :WS-FW-SEQ-NO                         
MFA-TR*           AND FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '**  ERROR IN 8445-UPDATE-ACTN-DT     **'        
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**  ACCOUNT NO = ' AT-ACCOUNT-NO                
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8445-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8448-UPDATE-WITHDRAW-DT                                        *        
      ******************************************************************        
       8448-UPDATE-WITHDRAW-DT.                                         
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_FIN_WO_COLLECT                               
                SET WITHDRAW_DT         = IIF(TRY_CONVERT(DATE, 
                                                        :WS-WITHDRAW-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-WITHDRAW-DT
              ) <> 0) OR (LEN(:WS-WITHDRAW-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-WITHDRAW-DT
              ), CONVERT(DATE, :WS-WITHDRAW-DT) )               
                WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                
                  AND FW_COLL_SEQ_NO    = :WS-FW-COLL-SEQ-NO            
                  AND FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_FIN_WO_COLLECT                                       
MFA-TR*         SET WITHDRAW_DT         = :WS-WITHDRAW-DT                       
MFA-TR*         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                        
MFA-TR*           AND FW_COLL_SEQ_NO    = :WS-FW-COLL-SEQ-NO                    
MFA-TR*           AND FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '**  ERROR IN 8448-UPDATE-WITHDRAW-DT   **'      
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**  ACCOUNT NO = ' AT-ACCOUNT-NO                
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8448-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    8470-UPDT-CNT-STATUS.                                   **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       8470-UPDT-CNT-STATUS.                                            
      *                                                                         
           MOVE '8470'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                UPDATE CSS_CONTRACT                                     
                SET CNT_STATUS_CD        = :CT-CNT-STATUS-CD,           
                    STATUS_CHANGE_DT     = IIF(TRY_CONVERT(DATE, 
                                                   :CT-STATUS-CHANGE-DT
              ) IS NULL OR (PATINDEX('%.%', :CT-STATUS-CHANGE-DT
              ) <> 0) OR (LEN(:CT-STATUS-CHANGE-DT
              ) <> 10), CIS.CHAR2DATE(:CT-STATUS-CHANGE-DT
              ), CONVERT(DATE, :CT-STATUS-CHANGE-DT) ),        
                    USER_ID              = :CT-USER-ID,                 
                    LAST_UPDATE_TS       = CIS.CURRENT$TIMESTAMP()            
                WHERE ACCOUNT_NO         = :CT-ACCOUNT-NO               
                  AND PYMT_PRIORITY_LVL  = :CT-PYMT-PRIORITY-LVL        
                  AND CNT_ITEM_ID        = :CT-CNT-ITEM-ID              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_CONTRACT                                             
MFA-TR*         SET CNT_STATUS_CD        = :CT-CNT-STATUS-CD,                   
MFA-TR*             STATUS_CHANGE_DT     = :CT-STATUS-CHANGE-DT,                
MFA-TR*             USER_ID              = :CT-USER-ID,                         
MFA-TR*             LAST_UPDATE_TS       = CURRENT TIMESTAMP                    
MFA-TR*         WHERE ACCOUNT_NO         = :CT-ACCOUNT-NO                       
MFA-TR*           AND PYMT_PRIORITY_LVL  = :CT-PYMT-PRIORITY-LVL                
MFA-TR*           AND CNT_ITEM_ID        = :CT-CNT-ITEM-ID                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  ERROR IN 8470-UPDT-CNT-STATUS    **'        
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**  ACCOUNT NO = ' CT-ACCOUNT-NO                
               DISPLAY 'PAYMENT PRIORITY LEVEL = '                      
                       CT-PYMT-PRIORITY-LVL                             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8470-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    8500-REPL-ACCOUNT                                       **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
       8500-REPL-ACCOUNT.                                               
      *                                                                         
           MOVE '8500'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                UPDATE CSS_ACCOUNT                                      
                SET   TOTAL_AR_BALANCE = :AT-TOTAL-AR-BALANCE,          
                        CODE_ACCT_STAT = :AT-CODE-ACCT-STAT,            
                      DATE_LAST_ACTION = IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-LAST-ACTION
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-LAST-ACTION
              ) <> 0) OR (LEN(:AT-DATE-LAST-ACTION
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-LAST-ACTION
              ), CONVERT(DATE, :AT-DATE-LAST-ACTION) ),          
                    CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,        
                    CODE_STATUS_REASON = :AT-CODE-STATUS-REASON,        
                        LAST_UPDATE_TS = CIS.CURRENT$TIMESTAMP()              
                WHERE       ACCOUNT_NO = :WS-ACCOUNT-NBR                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_ACCOUNT                                              
MFA-TR*         SET   TOTAL_AR_BALANCE = :AT-TOTAL-AR-BALANCE,                  
MFA-TR*                 CODE_ACCT_STAT = :AT-CODE-ACCT-STAT,                    
MFA-TR*               DATE_LAST_ACTION = :AT-DATE-LAST-ACTION,                  
MFA-TR*             CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,                
MFA-TR*             CODE_STATUS_REASON = :AT-CODE-STATUS-REASON,                
MFA-TR*                 LAST_UPDATE_TS = CURRENT TIMESTAMP                      
MFA-TR*         WHERE       ACCOUNT_NO = :WS-ACCOUNT-NBR                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**     ERROR IN 8500-REPL-ACCOUNT    **'        
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' WS-ACCOUNT-NBR             
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    8510-UPD-FINAL-WO-AMT                                   **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
      *                                                                         
       8510-UPD-FINAL-WO-AMT.                                           
      *                                                                         
           MOVE '8510'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                UPDATE CSS_FIN_WO_ACTION                                
                   SET FW_ACTION_AM      = :WS-WO-TOTAL                 
                      ,FW_PROCESSED_FL   = 'Y'                          
                 WHERE ACCOUNT_NO        = :WS-ACCOUNT-NBR              
                   AND FW_ACTION_TYPE_CD = :WS-ACTION-TYPE-CD           
                   AND FW_SEQ_NO         = :KD-FW-SEQ-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**     ERROR IN 8510-UPD-FINAL-WO-AMT**'        
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' WS-ACCOUNT-NBR             
               DISPLAY '**    ACTION TYPE CD =  WO'                     
               DISPLAY '**    ACTION DT =  ' WS-TEMP-DATE               
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8510-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00201200
      ****************************************************************  00271000
      **                                                            **  00271500
      **    8530-DEL-OLD-ACTION.                                    **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
      *                                                                         
       8530-DEL-OLD-ACTION.                                             
      *                                                                         
           MOVE '8530'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CSS_FIN_WO_ACTION                           
                 WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO               
                   AND FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD        
                   AND FW_SEQ_NO         = :WS-FW-OLD-SEQ-NO            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**     ERROR IN 8530-DEL-OLD-ACTION  **'        
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**    ACCOUNT NO = ' AT-ACCOUNT-NO              
               DISPLAY '**    ACTION TYPE CD =  ' KD-FW-ACTION-TYPE-CD  
               DISPLAY '**    FW_SEQ_NO =  ' WS-FW-OLD-SEQ-NO           
               DISPLAY '**      PROCESSING IS TERMINATED     **'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8535-INSERT-MNT-TRANS-HIST.                                      00201300
      ******************************************************************        
       8535-INSERT-MNT-TRANS-HIST.                                      
           MOVE '8535' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               INSERT INTO CSS_MNT_TRANS_HIST                           
                 ( TRANS_HIST_SEQ_NO, DATE_TRANS,                       
                   CODE_TRAN_TYPE,    RESP_AREA_ID,                     
                   ACCOUNT_NO,                                          
                   CUSTOMER_NO,       PREMISE_NO,                       
                   USER_ID,           APPL_PROGRAM_ID,                  
                   TRAN_COMMENT)                                        
               VALUES                                                   
                 ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO), 
              IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),               
                   :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,             
                   :MH-ACCOUNT-NO,                                      
                   :MH-CUSTOMER-NO,       :MH-PREMISE-NO,               
                   :MH-USER-ID,           :MH-APPL-PROGRAM-ID,          
                   :MH-TRAN-COMMENT)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00202600
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST                           00202700
MFA-TR*          ( TRANS_HIST_SEQ_NO, DATE_TRANS,                       00202800
MFA-TR*            CODE_TRAN_TYPE,    RESP_AREA_ID,                     00202900
MFA-TR*            ACCOUNT_NO,                                          00203000
MFA-TR*            CUSTOMER_NO,       PREMISE_NO,                       00203300
MFA-TR*            USER_ID,           APPL_PROGRAM_ID,                  00203400
MFA-TR*            TRAN_COMMENT)                                        00204000
MFA-TR*        VALUES                                                   00290000
MFA-TR*          ( :MH-TRANS-HIST-SEQ-NO, :MH-DATE-TRANS,               00291000
MFA-TR*            :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,             00293000
MFA-TR*            :MH-ACCOUNT-NO,                                      00295000
MFA-TR*            :MH-CUSTOMER-NO,       :MH-PREMISE-NO,               00297000
MFA-TR*            :MH-USER-ID,           :MH-APPL-PROGRAM-ID,          00299000
MFA-TR*            :MH-TRAN-COMMENT)                                    00299300
MFA-TR*    END-EXEC.                                                    00409000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** ERROR IN 8535-INSERT-MNT-TRANS-HIST **'       
              DISPLAY '**        RETURN CODE = ' WS-ACTIVE-RETURN-CODE  
              DISPLAY '**        PROCESSING IS TERMINATED       **'     
              DISPLAY '** ACCOUNT NO = ' WS-ACCOUNT-NO-NUM              
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8535-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
       8540-INSERT-MT-TRN-HST-DET.                                      
           MOVE '8540' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               INSERT INTO CSS_MT_TRN_HST_DET                           
               ( TRANS_HIST_SEQ_NO, TRAN_APPL_NO,                       
                 COLUMN_DESC,       PRV_COLUMN_VALUE,                   
                 CHG_COLUMN_VALUE,                                      
                 TABLE_ID)                                              
               VALUES                                                   
               ( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO), 
                                                      :MI-TRAN-APPL-NO,        
                 :MI-COLUMN-DESC,       :MI-PRV-COLUMN-VALUE,           
                 :MI-CHG-COLUMN-VALUE,                                  
                 :MI-TABLE-ID)                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00601200
MFA-TR*        INSERT INTO CSS_MT_TRN_HST_DET                           00601300
MFA-TR*        ( TRANS_HIST_SEQ_NO, TRAN_APPL_NO,                       00601600
MFA-TR*          COLUMN_DESC,       PRV_COLUMN_VALUE,                   00601900
MFA-TR*          CHG_COLUMN_VALUE,                                      00602200
MFA-TR*          TABLE_ID)                                              00602300
MFA-TR*        VALUES                                                   00602700
MFA-TR*        ( :MI-TRANS-HIST-SEQ-NO, :MI-TRAN-APPL-NO,               00602800
MFA-TR*          :MI-COLUMN-DESC,       :MI-PRV-COLUMN-VALUE,           00603200
MFA-TR*          :MI-CHG-COLUMN-VALUE,                                  00603500
MFA-TR*          :MI-TABLE-ID)                                          00603600
MFA-TR*    END-EXEC.                                                    00604300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** ERROR IN 8540-INSERT-MT-TRN-HST-DET **'       
              DISPLAY '**        RETURN CODE = ' WS-ACTIVE-RETURN-CODE  
              DISPLAY '**        PROCESSING IS TERMINATED       **'     
              DISPLAY '** ACCOUNT NO = ' WS-ACCOUNT-NO-NUM              
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8540-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8890-COMMIT.                                                   *        
      ******************************************************************        
      *                                                                         
       8890-COMMIT.                                                     
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
      *                                                                         
           DISPLAY '**********************************************'     
           DISPLAY '* COMMIT POINT # ' WS-COMMIT-COUNTER ' TAKEN.   *'  
           DISPLAY '* LAST REC PROCESSED  = ' WS-ACCOUNT-NBR            
           DISPLAY '**********************************************'.    
      *                                                                         
       8890-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *****************************                                     33438600
      *                          **                                     33438700
      *  8895-INSERT-WORK-QUEUE  **                                     33438800
      *                          **                                     33438900
      *****************************                                     33439000
      *                                                                 33439100
A04860*                                                                         
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860                                                                  
A04860     MOVE SPACES TO ABEND-FUNCTION.                               
A04860                                                                  
A04860     CALL SCSCB077 USING CWS00077-FIELDS,                         
A04860                         ABEND-FILE,                              
A04860                         RS-RETURN-CODE                           
A04860     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     END-IF.                                                      
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
      *                                                                         
      *                                                                 19300000
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK               *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
      *                                                                         
       9000-TERMINATE.                                                  
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               GO TO 9000-EXIT                                          
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-SQLCODE                       
               DISPLAY '                                      '         
               DISPLAY '**************************************'         
               DISPLAY '****  PCSKR400  PROCESSING ERROR  ****'         
               DISPLAY '**************************************'         
               DISPLAY '                                      '         
               DISPLAY 'SQLCODE =  ' WS-DISPLAY-SQLCODE
           END-IF.                
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
      *                                                                         
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                         
      *    MOVE '9900'                      TO ACTIVE-PARAGRAPH.                
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE,   
                                               RS-RETURN-CODE,          
                                               WS-DISPLAY-SQLCODE.      
           DISPLAY ' '                                                  
           DISPLAY '**********************************************'     
           DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
           DISPLAY '**********************************************'     
           DISPLAY ' '                                                  
           DISPLAY 'ACCT NO           = ' AT-ACCOUNT-NO                 
           DISPLAY 'ACTIVE-PARAGRAPH  = ' ACTIVE-PARAGRAPH              
           DISPLAY 'ABEND FUNCTION    = ' ABEND-FUNCTION                
           DISPLAY 'TABLE-1           = ' TABLE-1                       
           DISPLAY 'TABLE-ELEMENT-1   = ' TABLE-ELEMENT-1               
           DISPLAY 'HOSTVAR-ELEMENT-1 = ' HOSTVAR-ELEMENT-1             
           DISPLAY 'TABLE-ELEMENT-2   = ' TABLE-ELEMENT-2               
           DISPLAY 'HOSTVAR-ELEMENT-2 = ' HOSTVAR-ELEMENT-2             
           DISPLAY 'TABLE-ELEMENT-3   = ' TABLE-ELEMENT-3               
           DISPLAY 'HOSTVAR-ELEMENT-3 = ' HOSTVAR-ELEMENT-3             
           DISPLAY 'TABLE-ELEMENT-4   = ' TABLE-ELEMENT-4               
           DISPLAY 'HOSTVAR-ELEMENT-4 = ' HOSTVAR-ELEMENT-4             
           DISPLAY 'SQLCODE = ' WS-DISPLAY-SQLCODE                      
           DISPLAY '**********************************************'     
           PERFORM 9900-ABEND                    THRU 9900-EXIT.        
      *                                                                         
      *                                                                         
      ****************************************************************  19310900
      *  9700-PROCESS-ABEND.                                         *  19311000
      ****************************************************************  19311100
           EXEC SQL                                                     19311200
               INCLUDE CPD0023B                                         19311300
           END-EXEC.                                                    19311400
                                                                        
HPCCDM*    EJECT                                                        19311600
      *                                                                 19311700
      **************************************************************    19313800
      * CPD09900   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE   *    19313900
      * 9900-ABEND                                                 *    19314000
      **************************************************************    19314100
      *                                                                 19314200
           EXEC SQL                                                     19314300
               INCLUDE CPD09900                                         19314400
           END-EXEC.                                                    19314500
