       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSKR310.                                            
       AUTHOR. RC41079.                                                 
       DATE-WRITTEN. OCT 2011.                                          
      ******************************************************************        
      **               SOUTH CAROLINA ELECTRIC & GAS                  **        
      **                      COBOL-DB2                               **        
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **                                                              **        
      ** AS A PART OF THE CREDIT SIMPLIFICATION PROJECT, THE FINAL    **        
      ** BILL INVESTIGATION PROCESS HAS BEEN TAKEN FROM PCSCA132      **        
      ** AND PUT INTO A SINGLE PROGRAM WITH ALL THE LOGIC NEEDED TO   **        
      ** CREATE A FINAL BILL INVESTIGATION.                           **        
      **                                                              **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 2999     OUTPUT PROCESS CONTROL PATH           **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **              PROGRAM  MODIFICATION  LOG                      **        
      ******************************************************************        
      ** DATE     USERID   REASON                                     **        
      ** -------- -------  ------                                     **        
P00599** 10/17/11 RC41079  INITIAL IMPLEMENTATION.                    **        
P00599** 09/04/12 AA97148  ADDED SKIP PROCESS.                        **        
A04860** 09/18/14 AS7C117  REPLACE CSS_WQ_ITEMS_MF WITH               **        
A04860**          ACT043   CSS_WQ_ITEMS.                              **        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSKR310'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                      PIC X(40)  VALUE                
                           'WORKING STORAGE FOR PCSKR310 STARTS HERE'.  
      *                                                                         
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME               PIC X(08)  VALUE 'PCSKR310'.    
          05 WS-PGRMNAME                PIC X(10)  VALUE 'PCSKR310'.    
          05 SCSCA151                   PIC X(08)  VALUE 'SCSCA151'.    
          05 WS-Y                       PIC X(01)  VALUE 'Y'.           
          05 WS-N                       PIC X(01)  VALUE 'N'.           
A04860    05 SCSCB077                   PIC X(08)  VALUE 'SCSCB077'.    
      *                                                                         
       01 WS-MISC.                                                      
          05  WS-DISPLAY-SQLCODE        PIC -Z(8)9.                     
COB305    05 WS-BALANCE-DUE        PIC S9(09)V99 COMP-3 VALUE 0.           
          05  WS-FIN-INVEST-MIN-LIMIT   PIC S9(05) COMP-3 VALUE +0.     
          05  WS-WQ-CATEGORY            PIC 9(04)  VALUE ZERO.          
          05  WS-PROGRAM-DATE           PIC X(10).                      
          05  WS-FW-ACTION-AM           PIC S9(9)V9(2)                  
                                            USAGE COMP-3 VALUE 0.       
          05  WS-INVESTIGATION-AM       PIC S9(9)V9(2)                  
                                            USAGE COMP-3 VALUE 0.       
          05  WS-ACCT-PROC-CNT          PIC 9(9)         VALUE 0.       
P00599    05  WS-ACCOUNT-NO             PIC S9(13)V COMP-3 VALUE 0.     
A04860    05  WS-DATE-CREATED-TS.                                       
A04860        10  WS-CRE-DATE-PR        PIC X(10).                      
A04860        10  WS-CRE-TIME-PR    PIC X(16) VALUE '-00.00.00.000000'. 
A04860    05  WS-DATE-REQUIRED-TS.                                      
A04860        10  WS-REQ-DATE-PR        PIC X(10).                      
A04860        10  WS-REQ-TIME-PR    PIC X(16) VALUE '-00.00.00.000000'. 
      *                                                                         
       01 WS-SWITCHES.                                                  
          05  WS-ACCT-PASSED-FB-WO-CHKS  PIC X(01)  VALUE 'N'.          
          05  WS-DATABASES               PIC 9(01)  VALUE ZERO.         
              88  CSR-DATABASE                      VALUE 1.            
              88  SEB-DATABASE                      VALUE 2.            
P00599    05  WS-PROCESS-ACCOUNT         PIC X(01)  VALUE 'Y'.          
P00599        88  PROCESS-ACCT                      VALUE 'Y'.          
P00599        88  SKIP-ACCT                         VALUE 'N'.          
      *                                                                         
NUTIL  01  WS-WORKQUEUE-COMMENTS.                                       
           05  WS-NON-UTILITY             PIC X(19)  VALUE              
               'NON-UTILITY ACCOUNT'.                                   
      *                                                                 00031400
           05  WS-UTILITY-35-DAY.                                       
               10 WS-UTILITY-MESSAGE   PIC X(19) VALUE                  
                  'FINAL BILLED AMT = '.                                
               10 WS-INVESTIGATION-AMT    PIC $$$$$$$$9.99 VALUE SPACES.
      *                                                                         
       01  WS-COMMENTS.                                                 
           05 WS-COMMENTS-LEN             PIC S9(4) USAGE COMP.         
           05 WS-COMMENTS-TEXT            PIC X(250).                   
      *                                                                         
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
      *                                                                         
       01  WS-COMMIT-VARS.                                              
           05  WS-COMMIT-REC-CNTR          PIC S9(07) COMP-3 VALUE 0.   
           05  WS-COMMIT-COUNTER           PIC 9(9)   VALUE 0.          
           05  WS-COMMIT-LIMIT             PIC 9(4)   VALUE 0.          
           05  WS-DEFAULT-COMMIT-LIMIT     PIC 9(4)   VALUE 1000.       
           05  IN-PARM                     PIC X(8).                    
      *                                                                         
       01  WS-COMMIT-DATA.                                              
           05  WS-COMMIT-TEXT              PIC X(09).                   
           05  WS-COMMIT-NUM               PIC 9(04).                   
           05  FILLER                      PIC X(67).                   
      *                                                                 01482000
      ******************************************************************        
      *  ABEND SWITCH                                                  *        
      ******************************************************************        
      *  CWS00303 JOB PARM ROUTINE CONTAINS WS-WARNING-DATA-ELEMENTS   *        
      ******************************************************************        
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR CPD09900 CONTAINS ABEND WS VARIABLES       *        
      ******************************************************************        
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
      ******************************************************************        
      * WS-ABEND WORK AREA                                             *        
      ******************************************************************        
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
P00599******************************************************************        
P00599* VARIABLES NEEDED FOR ACCOUNT SKIP PROCESSING.                  *        
P00599******************************************************************        
P00599                                                                  
P00599 COPY CWSCA151.                                                           
P00599                                                                  
      ******************************************************************        
      * CONTAINS WORKING STORAGE VARIABLES TO GET JOB PARM             *        
      ******************************************************************        
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
      ******************************************************************        
      * WS-FCA00-MISC                                                  *        
      ******************************************************************        
      *                                                                         
       COPY CWS00039.                                                           
      *                                                                         
      ******************************************************************        
      * FCA00-KEY                                                      *        
      ******************************************************************        
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      *****************************************************************         
      * CWS00322 CONTAINS WS FOR FINDING NEXT BUSINESS DAY            *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00322                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CWS00337 CONTAINS WS FOR CPD00337 LOAD LIMITS                 *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00337                                                   
           END-EXEC.                                                            
      *                                                                         
       01 WS-END                         PIC X(40) VALUE                
                       'WORKING STORAGE FOR PCSKR310 ENDS HERE  '.      
      *                                                                         
      *****************************************************************         
      * DB2 INCLUDES.                                                 *         
      *****************************************************************         
      *                                                                         
      *****************************************************************         
      *    SQLCA                                                      *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_JOB_PARM  - G6                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ACCOUNT - AT                                                02301000
      ******************************************************************        
      *                                                                 02302000
           EXEC SQL                                                     02310000
               INCLUDE TBACCT                                           02320000
           END-EXEC.                                                    02330000
      *                                                                         
      ******************************************************************        
      * CSS_FINAL_WO - FW                                                       
      ******************************************************************        
      *                                                                 02500000
           EXEC SQL                                                             
               INCLUDE TBFINLWO                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_FIN_WO_ACTION - KD                                                  
      ******************************************************************        
      *                                                                 02500000
           EXEC SQL                                                             
               INCLUDE TBFWACTN                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_FW_FCST_ACTION - F8                                                 
      ******************************************************************        
      *                                                                 02500000
           EXEC SQL                                                             
               INCLUDE TBFWPDTL                                                 
           END-EXEC.                                                            
A04860*                                                                         
A04860/****** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077             
A04860      EXEC SQL                                                            
A04860           INCLUDE CWS00077                                               
A04860      END-EXEC.                                                           
      *                                                                         
      ******************************************************************        
      *   CURSOR TO SELECT FB/WO ACTIONS TO BE PROCESSED               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
             DECLARE FINAL_WO_ACTN CURSOR WITH HOLD FOR                 
              SELECT                                                    
                      FW.ACCOUNT_NO                                     
                     ,FW.REG_GROUP_CD                                   
                     ,FW.SENIOR_FL                                      
                     ,FW.FW_PATH_TYPE_CD                                
                     ,KD.FW_ACTION_DT                                   
                     ,KD.FW_ACTION_TYPE_CD                              
                     ,KD.FW_ACTION_AM                                   
                     ,KD.FW_PROCESSED_FL                                
                     ,KD.FW_SEQ_NO                                      
                     ,AT.COMPANY_NO                                     
                     ,AT.CUSTOMER_NO                                    
                     ,AT.CREDIT_GROUP                                   
                     ,AT.TOTAL_AR_BALANCE                               
                     ,AT.PREMISE_NO                                     
                     ,AT.LOCAL_OFFICE                                   
                FROM  CSS_ACCOUNT AT                                    
                     ,CSS_FIN_WO_ACTION KD                              
                     ,CSS_FINAL_WO FW                                   
               WHERE FW.ACCOUNT_NO         = AT.ACCOUNT_NO              
                 AND FW.ACCOUNT_NO         = KD.ACCOUNT_NO              
                 AND AT.CODE_ACCT_STAT     = 'B'                        
                 AND KD.FW_BUS_PROCESS_CD  = 'IN'                       
                 AND KD.FW_PROCESSED_FL    = ' '                        
                 AND KD.FW_ACTION_DT      <= IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) )       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE FINAL_WO_ACTN CURSOR WITH HOLD FOR                         
MFA-TR*       SELECT                                                            
MFA-TR*               FW.ACCOUNT_NO                                             
MFA-TR*              ,FW.REG_GROUP_CD                                           
MFA-TR*              ,FW.SENIOR_FL                                              
MFA-TR*              ,FW.FW_PATH_TYPE_CD                                        
MFA-TR*              ,KD.FW_ACTION_DT                                           
MFA-TR*              ,KD.FW_ACTION_TYPE_CD                                      
MFA-TR*              ,KD.FW_ACTION_AM                                           
MFA-TR*              ,KD.FW_PROCESSED_FL                                        
MFA-TR*              ,KD.FW_SEQ_NO                                              
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.CREDIT_GROUP                                           
MFA-TR*              ,AT.TOTAL_AR_BALANCE                               04200700
MFA-TR*              ,AT.PREMISE_NO                                     04200700
MFA-TR*              ,AT.LOCAL_OFFICE                                   04200700
MFA-TR*         FROM  CSS_ACCOUNT AT                                            
MFA-TR*              ,CSS_FIN_WO_ACTION KD                                      
MFA-TR*              ,CSS_FINAL_WO FW                                           
MFA-TR*        WHERE FW.ACCOUNT_NO         = AT.ACCOUNT_NO                      
MFA-TR*          AND FW.ACCOUNT_NO         = KD.ACCOUNT_NO                      
MFA-TR*          AND AT.CODE_ACCT_STAT     = 'B'                                
MFA-TR*          AND KD.FW_BUS_PROCESS_CD  = 'IN'                               
MFA-TR*          AND KD.FW_PROCESSED_FL    = ' '                                
MFA-TR*          AND KD.FW_ACTION_DT      <= :WS-NEW-BUSINESS-DAY               
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM  0100-INITIALIZATION          THRU  0100-EXIT.       
           PERFORM  0120-GET-COMMIT-PARM         THRU  0120-EXIT.       
           PERFORM  1000-MAIN-PROCESS            THRU  1000-EXIT.       
           DISPLAY  'NUMBER OF ACCOUNTS PROCESSED: ' WS-ACCT-PROC-CNT.  
           PERFORM  9000-TERMINATE               THRU  9000-EXIT.       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZATION                                            *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
                                                                        
      *                                                                 04680000
           PERFORM 6251-GET-FJC01-DATE              THRU 6251-EXIT.     
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE   THRU 6240-EXIT      
               MOVE WS-FCA00-COMMON-DATE    TO WS-INPUT-DATE            
           END-IF.                                                      
      *                                                                 04650000
           MOVE WS-INPUT-DATE          TO WS-NEW-BUSINESS-DAY.          
      *                                                                 04690100
           PERFORM 6500-GET-NEXT-BUSINESS-DAY                           
              THRU 6500-NEXT-BUSINESS-DAY-EXIT.                         
      *                                                                         
           DISPLAY WS-NEW-BUSINESS-DAY.                                 
      *                                                                         
           INITIALIZE  WS-FW-COMPANY                                    
                       WS-REG-GROUP-CD                                  
                       WS-FW-PATH-TYPE-CD                               
                       WS-FW-ACTION-TYPE-CD                             
                       WS-FW-ACTION-LIMIT-AM.                           
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  0120-GET-COMMIT-PARM                                        **        
      ******************************************************************        
      *                                                                         
       0120-GET-COMMIT-PARM.                                            
      *                                                                         
           MOVE SPACES                 TO WS-SYSIPT.                    
           MOVE WS-PGRMNAME            TO WS-PROGRAM.                   
           MOVE WS-PARM                TO WS-COMMAND.                   
           MOVE ZEROS                  TO WS-SEQUENCE.                  
                                                                        
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
                                                                        
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
                UNTIL (IN-PARM = 'COMMIT =' AND INPUT-ACTIVE)           
                  OR  END-OF-SYSIPT.                                    
                                                                        
           MOVE G6-PARM-DATA           TO WS-COMMIT-DATA.               
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSKR310 PROCESSING INFO   **'            
                 DISPLAY '**    COMMIT PARM NOT PRESENT'                
                 DISPLAY '**  DEFAULT CHKP LUW 1000 IS USED'            
                 MOVE WS-DEFAULT-COMMIT-LIMIT TO WS-COMMIT-LIMIT        
              WHEN WS-COMMIT-NUM NOT NUMERIC                            
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSKR310 PROCESSING ERROR  **'            
                 DISPLAY '**    COMMIT PARM NOT NUMERIC'                
                 DISPLAY '**    KEY = ' WS-INPUT-KEY                    
                 DISPLAY '**  PROCESSING TERMINATED  **'                
                 PERFORM 7611-CLOSE THRU 7611-EXIT                      
                 PERFORM 9900-ABEND  THRU  9900-EXIT                    
              WHEN WS-COMMIT-NUM NUMERIC                                
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSKR310 PROCESSING INFO  **'             
                 MOVE WS-COMMIT-NUM      TO WS-COMMIT-LIMIT             
                 DISPLAY '** COMMIT LIMIT IS ' WS-COMMIT-LIMIT          
                 PERFORM 7611-CLOSE THRU 7611-EXIT                      
           END-EVALUATE.                                                
      *                                                                         
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05210000
      *  1000-MAIN-PROCESS                                              05220000
      ******************************************************************        
      *                                                                         
       1000-MAIN-PROCESS.                                               
      *                                                                         
           PERFORM 7000-OPEN-FINAL-WO-ACTN     THRU 7000-EXIT.          
      *                                                                         
           PERFORM 7010-FETCH-FINAL-WO-ACTN    THRU 7010-EXIT.          
      *                                                                         
P00599     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
P00599        MOVE FW-ACCOUNT-NO               TO WS-ACCOUNT-NO         
P00599        PERFORM 5200-CHK-SKIP-ACCTS      THRU 5200-CPD347-EXIT    
P00599        IF PROCESS-ACCT                                           
                 PERFORM 2000-PROCESS-SECOND-INVEST THRU 2000-EXIT      
P00599        END-IF                                                    
P00599        PERFORM 7010-FETCH-FINAL-WO-ACTN THRU 7010-EXIT           
P00599     END-PERFORM.                                                 
      *                                                                         
           PERFORM 7020-CLOSE-FINAL-WO-ACTN    THRU 7020-EXIT.          
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************14904900
      *   2000-PROCESS-SECOND-INVEST                                   *14905100
      *                                                                *        
      *     SECOND INVEST NOTICE IS PROCESSED.                         *14905200
      *     FINAL BILL INVESTIGATIONS ARE WRITTEN TO THE WORK QUEUE.   *14905300
      *     THE ABOVE WILL OCCUR FOR FINAL BILLED ACCOUNTS WHERE THE   *14905500
      *     ACCOUNT BALANCE IS GREATER THAN $3.00.                     *        
      ******************************************************************14905700
      *                                                                         
       2000-PROCESS-SECOND-INVEST.                                      
      *                                                                 14905900
           INITIALIZE   WS-COMMENTS-TEXT                                
                        WS-COMMENTS-LEN.                                
           MOVE 'IN'                  TO F8-FW-BUS-PROCESS-CD.          
           MOVE WS-INPUT-DATE         TO WS-CWS337-PROCESS-DATE.        
           MOVE AT-COMPANY-NO         TO WS-FW-COMPANY.                 
           MOVE FW-REG-GROUP-CD       TO WS-REG-GROUP-CD.               
           MOVE FW-FW-PATH-TYPE-CD    TO WS-FW-PATH-TYPE-CD.            
           MOVE KD-FW-ACTION-TYPE-CD  TO WS-FW-ACTION-TYPE-CD.          
      *                                                                 14905900
           PERFORM 5100-GET-FCST-ACTN-DATA   THRU 5100-CPD337-EXIT.     
           PERFORM 3300-VERIFY-DW-VARIABLES THRU 3300-EXIT.             
           MOVE WS-FW-ACTION-LIMIT-AM TO  WS-FIN-INVEST-MIN-LIMIT.      
      *                                                                 14905900
           MOVE WS-N                  TO WS-ACCT-PASSED-FB-WO-CHKS.     
           MOVE FW-ACCOUNT-NO         TO KD-ACCOUNT-NO.                 
      *                                                                         
           IF AT-TOTAL-AR-BALANCE > WS-FIN-INVEST-MIN-LIMIT             
             MOVE AT-TOTAL-AR-BALANCE   TO WS-FW-ACTION-AM              
                                           WS-INVESTIGATION-AM          
             PERFORM 2100-FINAL-BILL-INVEST-WQ      THRU 2100-EXIT      
             DISPLAY KD-ACCOUNT-NO ' ' WS-FW-ACTION-AM ' '              
                                   WS-NEW-BUSINESS-DAY                  
             ADD 1                        TO WS-ACCT-PROC-CNT           
           ELSE                                                         
             MOVE ZEROS                 TO WS-FW-ACTION-AM              
           END-IF.                                                      
      *                                                                         
           MOVE 'FBIN1'                 TO KD-FW-ACTION-TYPE-CD.        
           PERFORM 8000-UPDATE-FW-ACTION-AM       THRU 8000-EXIT.       
      *                                                                         
           ADD 1                        TO WS-COMMIT-REC-CNTR.          
           IF WS-COMMIT-REC-CNTR  > WS-COMMIT-LIMIT                     
             ADD 1 TO WS-COMMIT-COUNTER                                 
             PERFORM 8898-ISSUE-CHKP  THRU  8898-EXIT                   
             DISPLAY 'COMMIT # ' WS-COMMIT-COUNTER ' TAKEN SUCESSFULLY.'
             MOVE ZEROES                TO  WS-COMMIT-REC-CNTR          
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************14820200
      * IF ITS A FINAL BILL INVESTIGATION NOTICE, WRITE A WORK QUEUE   *14820300
      * UPDATE THE FINAL WRITE OFF TABLE WITH THE AMOUNT.              *14820400
      * IF THE ACCOUNT IS A NON-UTILITY ACCOUNT A SPECIAL COMMENT      *        
      * IS INSERTED INTO THE WORKQUEUE COMMENTS.                       *        
      ******************************************************************14820700
      *                                                                         
       2100-FINAL-BILL-INVEST-WQ.                                       
      *                                                                         
           IF FW-FW-PATH-TYPE-CD = '6'                                  
             MOVE WS-NON-UTILITY        TO WS-COMMENTS-TEXT             
             MOVE +19                   TO WS-COMMENTS-LEN              
             MOVE WS-INVESTIGATION-AM   TO WS-INVESTIGATION-AMT         
             STRING WS-COMMENTS-TEXT   DELIMITED BY '  '                
                  ';'                  DELIMITED BY SIZE                
                    WS-UTILITY-35-DAY  DELIMITED BY SIZE                
                  ' '                  DELIMITED BY SIZE                
                                  INTO  WS-COMMENTS-TEXT                
             ADD +33                    TO  WS-COMMENTS-LEN             
           ELSE                                                         
             MOVE WS-INVESTIGATION-AM   TO WS-INVESTIGATION-AMT         
             STRING WS-UTILITY-35-DAY                                   
               ' '                     DELIMITED BY SIZE                
                                  INTO  WS-COMMENTS-TEXT                
             ADD +31                    TO  WS-COMMENTS-LEN             
           END-IF                                                       
      *                                                                         
           MOVE 122                     TO WS-WQ-CATEGORY               
      *                                                                         
           PERFORM 2200-CREATE-WORK-QUEUE THRU 2200-EXIT.               
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14821500
      ******************************************************************        
      * 2200-CREATE-WORK-QUEUE.                                         14782800
      ******************************************************************        
      *                                                                         
       2200-CREATE-WORK-QUEUE.                                          
      *                                                                         
A04860     INITIALIZE CWS00077-FIELDS.                                  
      *                                                                         
A04860     INITIALIZE   WS-77-COMMENTS.                                 
      *                                                                         
A04860     MOVE FW-ACCOUNT-NO           TO WS-77-ACCOUNT-NO.            
A04860     MOVE AT-CUSTOMER-NO          TO WS-77-CUSTOMER-NO.           
A04860     MOVE AT-PREMISE-NO           TO WS-77-PREMISE-NO.            
A04860     MOVE AT-LOCAL-OFFICE         TO WS-77-LOCAL-OFFICE.          
A04860     MOVE WS-WQ-CATEGORY          TO WS-77-CATEGORY-ID.           
           MOVE WS-INPUT-DATE           TO WS-PROGRAM-DATE.             
      *                                                                         
A04860     MOVE WS-COMMENTS-TEXT        TO WS-77-COMMENTS-TEXT.         
A04860     MOVE WS-COMMENTS-LEN         TO WS-77-COMMENTS-LEN.          
A04860     MOVE 4                       TO WS-77-ROUTE-CATEGORY         
A04860     MOVE WS-N                    TO WS-77-PRIORITY.              
A04860     MOVE WS-PROGRAM-DATE         TO WS-CRE-DATE-PR.              
A04860     MOVE WS-NEW-BUSINESS-DAY     TO WS-REQ-DATE-PR.              
A04860     MOVE WS-DATE-CREATED-TS      TO WS-77-DATE-CREATED.          
A04860     MOVE WS-DATE-REQUIRED-TS     TO WS-77-DATE-REQUIRED.         
A04860     MOVE PROGRAM-NAME            TO WS-77-CREATED-BY.            
      *                                                                         
           PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.               
      *                                                                 14784200
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14784401
      *****************************************************************         
      *  THIS PARA CHECKS WHETHER ALL VALUES ARE POSITIVE                       
      *  IN THE TABLE ITSELF.                                                   
      *****************************************************************         
      *                                                                         
       3300-VERIFY-DW-VARIABLES.                                        
      *                                                                         
           IF        WS-FW-ACTION-LIMIT-AM            > ZERO            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '**************PCSKR310***************'          
               DISPLAY '* 3300-VERIFY-DW-VARIABLES'                     
               DISPLAY '* RETURN CODE = 12'                             
               DISPLAY '**************PCSKR310***************'          
               PERFORM 9900-ABEND   THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       3300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5100-GET-FCST-ACTN-DATA                                        *11187000
      ******************************************************************11187100
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00337                                                 
           END-EXEC.                                                            
      *                                                                         
P00599******************************************************************        
P00599* 5200-CHK-SKIP-ACCTS                                      *      11187000
P00599******************************************************************11187100
P00599                                                                  
P00599     EXEC SQL                                                             
P00599        INCLUDE CPD00347                                                  
P00599     END-EXEC.                                                            
P00599                                                                  
      ******************************************************************        
      * 6240-GET-FCA00-COMMON-DATE                                     *11187000
      ******************************************************************11187100
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00040                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00037                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00039                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    6500-GET-NEXT-BUSINESS-DAY                                **         
      *    COPYBOOK CPD00322 CONTAINS THE LOGIC FOR FINDING          **         
      *    THE NEXT BUSINESS DAY.                                    **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00322                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************  14951400
      **  7000-OPEN-FINAL-WO-ACTN                                   **  14951500
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **  14952000
      **      FINAL_WO_ACTN CURSOR                                  **  14960000
      ****************************************************************  14970000
      *                                                                 14990000
       7000-OPEN-FINAL-WO-ACTN.                                         
      *                                                                 14990000
           EXEC SQL                                                     
               OPEN FINAL_WO_ACTN                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15030000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 15050000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**************PCSKR310***************'          
               DISPLAY '** 7000-OPEN-FINAL-WO-ACTN '                    
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**************PCSKR310***************'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 15150000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15180000
      ****************************************************************  15190000
      **  7010-FETCH-FINAL-WO-ACTN                                  **  15200000
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **  15210000
      **      FINAL_WO_ACTN CURSOR                                  **  15220000
      ****************************************************************  15230000
      *                                                                 15180000
       7010-FETCH-FINAL-WO-ACTN.                                        
      *                                                                 15250000
           EXEC SQL                                                     
               FETCH FINAL_WO_ACTN INTO                                 
                    :FW-ACCOUNT-NO,                                     
                    :FW-REG-GROUP-CD,                                   
                    :FW-SENIOR-FL,                                      
                    :FW-FW-PATH-TYPE-CD,                                
                    :KD-FW-ACTION-DT,                                   
                    :KD-FW-ACTION-TYPE-CD,                              
                    :KD-FW-ACTION-AM,                                   
                    :KD-FW-PROCESSED-FL,                                
                    :KD-FW-SEQ-NO,                                      
                    :AT-COMPANY-NO,                                     
                    :AT-CUSTOMER-NO,                                    
                    :AT-CREDIT-GROUP,                                   
                    :AT-TOTAL-AR-BALANCE,                               
                    :AT-PREMISE-NO,                                     
                    :AT-LOCAL-OFFICE                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15440000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 15459300
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**************PCSKR310***************'          
               DISPLAY '** 7010-FETCH-FINAL-WO-ACTN'                    
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**************PCSKR310***************'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 15560000
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15590000
      ****************************************************************  15600000
      **  7020-CLOSE-FINAL-WO-ACTN                                  **  15610000
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **  15620000
      **      FINAL_WO_ACTN CURSOR                                  **  15630000
      ****************************************************************  15640000
      *                                                                 15590000
       7020-CLOSE-FINAL-WO-ACTN.                                        
      *                                                                 15660000
           EXEC SQL                                                     
               CLOSE FINAL_WO_ACTN                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15700000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 15720000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**************PCSKR310***************'          
               DISPLAY '** 7020-CLOSE-FINAL-WO-ACTN'                    
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**************PCSKR310***************'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 15820000
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16660000
      *****************************************************************         
      *    7600-START-FCSJC01.                                                  
      *    7610-READ-FCSJC01.                                                   
      *    7611-CLOSE.                                                          
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00038                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 8000-UPDATE-FW-ACTION-AM                                        15238800
      ******************************************************************        
      *                                                                         
       8000-UPDATE-FW-ACTION-AM.                                        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_FIN_WO_ACTION                                 
                  SET FW_ACTION_AM     = :WS-FW-ACTION-AM               
                     ,FW_PROCESSED_FL  = 'Y'                            
               WHERE ACCOUNT_NO        = :KD-ACCOUNT-NO                 
                 AND FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD          
                 AND FW_SEQ_NO         = :KD-FW-SEQ-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 15239600
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
              CONTINUE                                                  
           WHEN OTHER                                                   
              DISPLAY '**************PCSKR310***************'           
              DISPLAY '** 8000-UPDATE-FW-ACTION-AM'                     
              DISPLAY '** CSS_FIN_WO_ACTION        '                    
              DISPLAY '** ACCOUNT NO = ' KD-ACCOUNT-NO                  
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '**************PCSKR310***************'           
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  8895-INSERT-WORK-QUEUE                                        *15303100
      ******************************************************************        
      *                                                                 15303400
A04860*                                                                         
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860*                                                                         
A04860     CALL SCSCB077 USING CWS00077-FIELDS,                         
A04860                         ABEND-FILE,                              
A04860                         RS-RETURN-CODE                           
A04860     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     END-IF.                                                      
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
      *                                                                 15304000
      **************************************************************            
      **  8898-ISSUE-CHKP                                                       
      **************************************************************            
      *                                                                         
       8898-ISSUE-CHKP.                                                 
             EXEC SQL                                                           
                 INCLUDE CPD00047                                               
             END-EXEC                                                           
                                                    
      *                                                                         
       8898-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      * CLOSES                                                                  
      ************************************************************              
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  19310900
      *  9700-PROCESS-ABEND.                                         *  19311000
      ****************************************************************  19311100
      *                                                                 19311700
           EXEC SQL                                                     19311200
               INCLUDE CPD0023B                                         19311300
           END-EXEC.                                                    19311400
                                                                        
HPCCDM*    EJECT                                                        19311600
      *                                                                 19311700
      **************************************************************    19313800
      * CPD09900   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE   *    19313900
      * 9900-ABEND                                                 *    19314000
      **************************************************************    19314100
      *                                                                 19314200
           EXEC SQL                                                     19314300
               INCLUDE CPD09900                                         19314400
           END-EXEC.                                                    19314500
      *                                                                 19314200
