       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSKR300.                                          
       AUTHOR.       AARON ABRAHAM.                                     
       DATE-WRITTEN. JAN 2012.                                          
      ******************************************************************00000401
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **00000501
      **                                                              **00000601
      *********           CUSTOMER SERVICE SYSTEM              *********00000701
      *********                     DB2                        *********00000801
      **                                                              **00000601
      ******************************************************************        
      **--------------- P R O G R A M  S U M M A R Y -----------------**        
      *************************************************************** **        
      **                                                              **        
      ** THIS IS THE DRIVER PROGRAM FOR THE POST BILLING FINAL NOTICE **        
      ** PROCESSING.                                                  **        
      **                                                              **        
      **    THE FOLLOWING PROCESSES HAPPEN IN THE DRIVER:             **        
      **        1. FINAL BILL NOTICE PROCESS                          **        
      **        2. FA03 - CPD00345 WILL CREATE FA03 FILE TO BE PROCESSED        
      **           BY PCSCA136                                        **        
      **        3. WQ GENERATION                                      **        
      **                                                              **        
      ******************************************************************        
      **------------- PROGRAM  MODIFICATION  LOG -------------------- **        
      ******************************************************************        
      **      PCSKR300   PROGRAM  MODIFICATION  LOG                   **        
      **                                                              **        
      **   DATE        INITIALS  REASON                               **        
      **   __________  ________  ______________                       **        
P00599**   03/18/2012  AA97148   INITIAL PROGRAM VERSION.             **        
P0599A**   10/09/2012  Gokul /   Change KR300 to call SCSKR125 and    **        
P0599A**               Aaron     stop generating FA03 file.           **        
P0599B**   02/06/2013  Gokul     Populate WS-TOTAL-RET-CHK-AMT to     **        
P0599B**                         print in notice.                     **        
P0599C**   02/11/2013  GOKUL     DO NOT GENERATE A GUARANTOR NOTICE   **        
P0599C**                         WHEN THE ACCOUNT IS NOT GUARANTEED.  **        
ACT017**   01/23/2014  AA97148   EXCLUDE RETURN CHECK NOTICE FROM     **        
ACT017**                         NOTICE GUARANTEED PROCESS - A04880   **        
ACT096**   05/08/2014  rb19957   bypass getting due date when         **        
ACT096**                         processing a 90205 notice - A04880   **        
ACT036**   06/20/2014  SS7F226   WORK QUEUE CHANGE TO REPLACE THE     **        
ACT036**               A4860     CSS_WQ_ITEMS_MF WITH CSS_WQ_ITEMS and**        
ACT036**               A4860     REMOVED UN USED COPY BOOKS.          **        
      **                                                              **        
A05154** 15 JAN 2015   RF10596   CLEAN UP PROGRAM                     **        
      **                                                              **        
      ******************************************************************        
      **----------------- BASIC SEQUENCE STRUCTURE -------------------**        
      *************************************************************** **        
      **         0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION **        
      **         1000 - 1999     INPUT PROCESSING CONTROL PATH        **        
      **         2000 - 2999     OUTPUT PROCESSING CONTROL PATH       **        
      **         3000 - 4999     BATCH PROCESSING MODULES - NOT USED  **        
      **         5000 - 5999     COMMON PROGRAM MODULES               **        
      **         6000 - 6999     COMMON SYSTEM MODULES                **        
      **         7000 - 7999     INPUT MODULES                        **        
      **         8000 - 8999     OUTPUT MODULES                       **        
      **         9000 - 9799     TERMINATION MODULES                  **        
      **         9900 - 9999     ABEND/ABORT MODULES                  **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSKR300'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)                      
           VALUE 'WORKING STORAGE FOR PCSKR300 STARTS HERE'.            
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME              PIC X(08)   VALUE 'PCSKR300'.  
           05  WS-PGRMNAME               PIC X(08)   VALUE 'PCSKR300'.  
           05  SCSCA151                  PIC X(08)   VALUE 'SCSCA151'.  
P0599A     05  SCSKR125                  PIC X(08)   VALUE 'SCSKR125'.  
ACT036     05  SCSCB077                  PIC X(08)   VALUE 'SCSCB077'.  
           05  WS-Y                      PIC X(01)   VALUE 'Y'.         
           05  WS-N                      PIC X(01)   VALUE 'N'.         
                                                                        
       01  WS-MISC.                                                     
           05  WS-DISPLAY-SQLCODE        PIC -Z(8)9.                    
           05  RS-RETURN-CODE            PIC S9(04)  COMP VALUE 0.      
           05  WS-PROCESSED-DATE         PIC X(10)   VALUE SPACES.      
           05  WS-FW-ACTION-DT           PIC X(10)   VALUE SPACES.      
           05  WS-LAST-PYMT-DATE-NULL    PIC S9(04)  COMP VALUE 0.      
           05  WS-NEW-ACTN-TYPE-CD       PIC X(05)   VALUE SPACES.      
           05  WS-COMMITS-COUNT          PIC S9(09)  COMP VALUE +0.     
           05  WS-RECS-TO-COMMIT-COUNT   PIC S9(09)  COMP VALUE +0.     
COB305     05 WS-AUTO-DEP-CHARGED-AMT        PIC S9(09)V99 COMP-3 
COB305       VALUE 0.          
           05  WS-PREV-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.    
           05  WS-CURR-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.    
           05  WS-ACCOUNT-NO             PIC S9(13)V COMP-3 VALUE 0.    
P0599A     05  WS-GUARANTOR-ACCT-NO      PIC S9(13)V COMP-3 VALUE 0.    
P0599B     05  WS-HOLD-CORRESP-SEQ-NO    PIC S9(04)V COMP VALUE 0.      
           05  WS-CHKP-LUW-LIMIT         PIC 9(04)   VALUE 2.           
           05  WS-CHKP-UPD-LIMIT         PIC 9(04)   VALUE 2.           
           05  WS-DEFAULT-CHKP-LUW-LIMIT PIC 9(04)   VALUE 5.           
           05  WS-DEFAULT-CHKP-UPD-LIMIT PIC 9(04)   VALUE 5.           
           05  WS-READY-TO-COMMIT-COUNT  PIC S9(09)  COMP VALUE +0.     
           05  WS-DEFAULT-INSERT-COUNT   PIC S9(09)  COMP VALUE +100.   
           05  WS-CURR-ACTION-TYPE-CD    PIC X(05)   VALUE SPACES.      
           05  WS-PREV-ACTION-TYPE-CD    PIC X(05)   VALUE SPACES.      
P0599A     05  RS-RETURN-CODE-DISP       PIC -Z(3)9.                    
P0599A     05  RS-KR125-RETURN-CODE      PIC S9(04)   COMP VALUE 0.     
P0599A     05  WS-LPC-AMOUNT             PIC S9(11)V9(2) COMP-3 VALUE 0.
P0599A     05  WS-DATE-TRAN              PIC X(10)   VALUE SPACES.      
P0599A     05  WS-SLASHES-6              PIC X(06)   VALUE '//////'.    
P0599A     05  WS-HOLD-AMOUNT            PIC 9(09)V99 VALUE 0.          
P0599A     05  WS-HOLD-AMOUNT-K  REDEFINES WS-HOLD-AMOUNT.              
P0599A         10  WS-DOL-AMOUNT         PIC 9(09).                     
P0599A         10  WS-DEC-AMOUNT         PIC 9(02).                     
ACT036     05  WS-INPUT-ZERO              PIC X(16)                     
ACT036                                    VALUE '-00.00.00.000000'.     
ACT036     05  WS-INPUT-DATE-26           PIC X(26) VALUE SPACES.       
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-GUARANTOR-EXISTS       PIC X(01)   VALUE SPACES.      
               88  GUARANTOR-EXISTS                  VALUE 'Y'.         
           05  WS-PROCESS-ACCOUNT        PIC X(01)   VALUE 'N'.         
               88  PROCESS-ACCT                      VALUE 'Y'.         
               88  SKIP-ACCT                         VALUE 'N'.         
           05  WS-GENERATE-NOTICE        PIC X(01)   VALUE SPACES.      
               88  GENERATE-NOTICE                   VALUE 'Y'.         
P0599C     05  WS-ACCT-NOT-GUARANTEED    PIC X(01)   VALUE SPACES.      
P0599C         88  ACCT-NOT-GUARANTEED               VALUE 'Y'.         
                                                                        
       01  WS-MISCELLANEOUS-MESSAGE.                                    
           05  WS-MISC-MSG-LEN           PIC S9(04)  COMP VALUE +10.    
           05  WS-MISC-MSG-TEXT          PIC X(95)   VALUE 'FINAL BILL'.
                                                                        
      ******************************************************************        
      * CWS00010 CONTAINS DB2 ABEND VARIABLES                          *        
      ******************************************************************        
                                                                        
       COPY CWS00010.                                                           
                                                                        
      ******************************************************************        
      * WS-ABEND-SWITCH                                                *        
      ******************************************************************        
                                                                        
       COPY CWS09900.                                                           
                                                                        
      ******************************************************************        
      * CWS00039 JOB PARM ROUTINE                                      *        
      ******************************************************************        
                                                                        
       COPY CWS00039.                                                           
                                                                        
      ******************************************************************        
      * FIOJC01 WORKING STORAGE                                        *        
      ******************************************************************        
                                                                        
       COPY FIOJC01.                                                            
                                                                        
      ******************************************************************        
      * FCA00-KEY                                                      *        
      ******************************************************************        
                                                                        
       COPY FIOCA00.                                                            
                                                                        
      ******************************************************************        
      * WORKING STORAGE FOR CODES-DATA-PRESENT                         *        
      ******************************************************************        
      *                                                                         
       COPY CWS00056.                                                           
      *                                                                         
      ******************************************************************        
      * CWS00303 JOB PARM ROUTINE CONTAINS WS-WARNING-DATA-ELEMENTS    *        
      ******************************************************************        
                                                                        
       COPY CWS00303.                                                           
                                                                        
      ******************************************************************        
      * VARIABLES NEEDED FOR ACCOUNT SKIP PROCESSING.                  *        
      ******************************************************************        
                                                                        
       COPY CWSCA151.                                                           
                                                                        
P0599A******************************************************************        
P0599A* VARIABLES NEEDED FOR MNT HIST COMMENTS.                        *        
P0599A******************************************************************        
P0599A                                                                  
P0599A COPY CWS00136.                                                           
P0599A                                                                  
      ******************************************************************        
      *   CWS10008 KR300 PROCESSING DATA.                              *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS10008                                                  
           END-EXEC.                                                            
                                                                        
P0599A******************************************************************        
P0599A* WORKING STORAGE VARIABLES TO PROCESS AND INSERT NOTICES        *        
P0599A******************************************************************        
P0599A*                                                                         
P0599A     EXEC SQL                                                             
P0599A        INCLUDE CWS00341                                                  
P0599A     END-EXEC.                                                            
      *                                                                         
P0599A******************************************************************        
P0599A* VARIABLES NEEDED FOR NOTICE PROCESSING                         *        
P0599A******************************************************************        
P0599A                                                                  
P0599A     EXEC SQL                                                             
P0599A        INCLUDE CWS00350                                                  
P0599A     END-EXEC.                                                            
P0599A                                                                  
      ******************************************************************        
      * WORKING STORAGE FOR CPD00337 CONTAINS LIMIT CHECK WS VARIABLES *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00337                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CWS00038 INPUT DATA LAYOUT                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
                                                                        
       01  WS-INSERT-ROW-COUNT REDEFINES WS-INPUT-DATA-BREAKDOWN.       
           10  WS-PARM-COMMIT-ROW-COUNT-TXT PIC X(21).                  
               88 COMMIT-ROW-CNT         VALUE 'NO-OF-ROWS-TO-COMMIT='. 
           10  WS-NO-OF-ROWS-TO-COMMIT   PIC X(05).                     
           10  FILLER                    PIC X(54).                     
                                                                        
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSKR300 ENDS HERE  '.            
                                                                        
      ******************************************************************        
      * DB2 COMMUNICATION REQUIREMENT                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ACCOUNT        - AT                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      * CSS_CREDIT_PROFILE - CZ                                        *06340000
      ******************************************************************06350000
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCRPROF                                                 
           END-EXEC.                                                            
                                                                        
P0599A******************************************************************        
P0599A*  CSS_DELINQUENCY   - C8                                        *        
P0599A******************************************************************        
P0599A*                                                                         
P0599A     EXEC SQL                                                             
P0599A       INCLUDE TBDELQ                                                     
P0599A     END-EXEC.                                                            
P0599A*                                                                         
      ******************************************************************        
      * CSS_GUARANTOR      - GU                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBGTNTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_FIN_WO_ACTION  - KD                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBFWACTN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_FINAL_WO       - FW                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBFINLWO                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_FW_FCST_ACTION - F8                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBFWPDTL                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_JOB_PARM       - G6                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_NSF_HIST       - NH                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBNSFHST                                                 
           END-EXEC.                                                            
                                                                        
P0599A******************************************************************        
P0599A* CSS_NSF-REASON     - NR                                        *        
P0599A******************************************************************        
P0599A                                                                  
P0599A     EXEC SQL                                                             
P0599A         INCLUDE TBNSFRSN                                                 
P0599A     END-EXEC.                                                            
P0599A                                                                  
      ******************************************************************        
      * WORKING STORAGE NEXT BUSINESS DAY CPYC CPD00322.               *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00322                                                  
           END-EXEC.                                                            
                                                                        
ACT036******************************************************************        
ACT036* CWS00077     WORKING STORAGE COPYBOOK FOR SCSCB077             *        
ACT036******************************************************************        
ACT036                                                                  
ACT036     EXEC SQL                                                             
ACT036        INCLUDE CWS00077                                                  
ACT036     END-EXEC.                                                            
ACT036                                                                  
      ******************************************************************        
      * CURSOR DECLARATION                                             *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE FINAL-NOTICE-CSR CURSOR WITH HOLD FOR             
               SELECT AT.COMPANY_NO                                     
                     ,AT.ACCOUNT_NO                                     
                     ,AT.CUSTOMER_NO                                    
                     ,AT.TOTAL_AR_BALANCE                               
                     ,AT.BANKRUPTCY_IND                                 
                     ,AT.JUDGEMENT_CASE_NO                              
                     ,AT.LAST_PYMT_DATE                                 
                     ,AT.LAST_PYMT_AMOUNT                               
                     ,AT.PREMISE_NO                                     
                     ,AT.LOCAL_OFFICE                                   
                     ,AT.ADDRESS_ID                                     
                     ,AT.ADDRESS_FORMAT                                 
                     ,AT.BILL_CYCLE                                     
                     ,AT.CODE_ACCT_STAT                                 
                     ,AT.CREDIT_GROUP                                   
                     ,FW.REG_GROUP_CD                                   
                     ,FW.SENIOR_FL                                      
                     ,FW.FW_PATH_TYPE_CD                                
                     ,FW.GUARANTEED_IND                                 
                     ,KD.FW_SEQ_NO                                      
                     ,KD.FW_ACTION_TYPE_CD                              
                     ,KD.FW_ACTION_DT                                   
                     ,KD.FW_ACTION_AM                                   
                     ,KD.FW_PROCESSED_FL                                
                     ,KD.FW_ACTION_COMMENTS                             
                     ,KD.GUARANTOR_ACCT_NO                              
                 FROM CSS_ACCOUNT       AT WITH(READUNCOMMITTED)                
                     ,CSS_FIN_WO_ACTION KD WITH(READUNCOMMITTED)                
                     ,CSS_FINAL_WO      FW WITH(READUNCOMMITTED)                
                WHERE AT.ACCOUNT_NO        = FW.ACCOUNT_NO              
                  AND FW.ACCOUNT_NO        = KD.ACCOUNT_NO              
                  AND KD.FW_ACTION_DT     <= IIF(TRY_CONVERT(DATE, 
                                                     :WS-PROCESSED-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PROCESSED-DATE
              ) <> 0) OR (LEN(:WS-PROCESSED-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-PROCESSED-DATE
              ), CONVERT(DATE, :WS-PROCESSED-DATE) )         
                  AND AT.CODE_ACCT_STAT    = 'B'                        
                  AND KD.FW_BUS_PROCESS_CD = 'FN'                       
                  AND KD.FW_PROCESSED_FL   = ''                         
                ORDER BY AT.COMPANY_NO                                  
                        ,AT.ACCOUNT_NO                                  
                        ,KD.FW_SEQ_NO                                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     01882000
MFA-TR*       DECLARE FINAL-NOTICE-CSR CURSOR WITH HOLD FOR             01883000
MFA-TR*        SELECT AT.COMPANY_NO                                             
MFA-TR*              ,AT.ACCOUNT_NO                                             
MFA-TR*              ,AT.CUSTOMER_NO                                    01897000
MFA-TR*              ,AT.TOTAL_AR_BALANCE                               01894000
MFA-TR*              ,AT.BANKRUPTCY_IND                                 01890000
MFA-TR*              ,AT.JUDGEMENT_CASE_NO                              01895000
MFA-TR*              ,AT.LAST_PYMT_DATE                                         
MFA-TR*              ,AT.LAST_PYMT_AMOUNT                                       
MFA-TR*              ,AT.PREMISE_NO                                             
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,AT.ADDRESS_ID                                             
MFA-TR*              ,AT.ADDRESS_FORMAT                                         
MFA-TR*              ,AT.BILL_CYCLE                                             
MFA-TR*              ,AT.CODE_ACCT_STAT                                         
MFA-TR*              ,AT.CREDIT_GROUP                                           
MFA-TR*              ,FW.REG_GROUP_CD                                           
MFA-TR*              ,FW.SENIOR_FL                                              
MFA-TR*              ,FW.FW_PATH_TYPE_CD                                        
MFA-TR*              ,FW.GUARANTEED_IND                                         
MFA-TR*              ,KD.FW_SEQ_NO                                      01891000
MFA-TR*              ,KD.FW_ACTION_TYPE_CD                              01889000
MFA-TR*              ,KD.FW_ACTION_DT                                   01892000
MFA-TR*              ,KD.FW_ACTION_AM                                   01893000
MFA-TR*              ,KD.FW_PROCESSED_FL                                01896000
MFA-TR*              ,KD.FW_ACTION_COMMENTS                                     
MFA-TR*              ,KD.GUARANTOR_ACCT_NO                                      
MFA-TR*          FROM CSS_ACCOUNT       AT                              01898000
MFA-TR*              ,CSS_FIN_WO_ACTION KD                                      
MFA-TR*              ,CSS_FINAL_WO      FW                                      
MFA-TR*         WHERE AT.ACCOUNT_NO        = FW.ACCOUNT_NO              01899000
MFA-TR*           AND FW.ACCOUNT_NO        = KD.ACCOUNT_NO              01899000
MFA-TR*           AND KD.FW_ACTION_DT     <= :WS-PROCESSED-DATE         01899000
MFA-TR*           AND AT.CODE_ACCT_STAT    = 'B'                        01899000
MFA-TR*           AND KD.FW_BUS_PROCESS_CD = 'FN'                               
MFA-TR*           AND KD.FW_PROCESSED_FL   = ''                                 
MFA-TR*         ORDER BY AT.COMPANY_NO                                          
MFA-TR*                 ,AT.ACCOUNT_NO                                          
MFA-TR*                 ,KD.FW_SEQ_NO                                           
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7510                                                      
MFA-TR*    END-EXEC.                                                    01901000
                                                                        
      ******************************************************************        
      * CSS_FIN_WO_ACTION CURSOR                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE FINAL-WO-ACTN CURSOR WITH HOLD FOR                
               SELECT KD.FW_ACTION_DT                                   
                     ,KD.FW_SEQ_NO                                      
                     ,KD.FW_ACTION_TYPE_CD                              
                 FROM CSS_FIN_WO_ACTION KD WITH(READUNCOMMITTED)                
                WHERE KD.ACCOUNT_NO        = :KD-ACCOUNT-NO             
                  AND KD.FW_BUS_PROCESS_CD = 'FN'                       
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE FINAL-WO-ACTN CURSOR WITH HOLD FOR                        
MFA-TR*        SELECT KD.FW_ACTION_DT                                           
MFA-TR*              ,KD.FW_SEQ_NO                                              
MFA-TR*              ,KD.FW_ACTION_TYPE_CD                                      
MFA-TR*          FROM CSS_FIN_WO_ACTION KD                                      
MFA-TR*         WHERE KD.ACCOUNT_NO        = :KD-ACCOUNT-NO                     
MFA-TR*           AND KD.FW_BUS_PROCESS_CD = 'FN'                               
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7540                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
P0599A****************************************************************          
P0599A**  CURSOR TO LOOK FOR ACTIVE GUARANTORS                      **          
P0599A****************************************************************          
P0599A     EXEC SQL                                                     
P0599A        DECLARE GUARANTOR_CURSOR CURSOR FOR                       
P0599A        SELECT A.AMOUNT_GUARANTEED                                
P0599A              ,A.GUARNTR_ACCT_NO                                  
P0599A              ,A.ADDRESS_ID                                       
P0599A              ,A.GUAR_NOTICE_FLAG                                 
P0599A              ,B.ADDRESS_ID                                       
P0599A              ,B.ADDRESS_FORMAT                                   
P0599A        FROM CSS_GUARANTOR A WITH(READUNCOMMITTED), CSS_ACCOUNT B
                           WITH(READUNCOMMITTED)                       
P0599A        WHERE A.ACCOUNT_NO = :GU-ACCOUNT-NO AND                   
P0599A            A.GUARNTR_ACCT_NO = B.ACCOUNT_NO AND                  
P0599A            A.GUAR_STATUS_CD = 'A' AND                            
P0599A            A.SERVICE_TYPE_CD = 'U'                               
P0599A       FOR READ ONLY                                      
P0599A                                                      
P0599A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE GUARANTOR_CURSOR CURSOR FOR                               
MFA-TR*       SELECT A.AMOUNT_GUARANTEED                                        
MFA-TR*             ,A.GUARNTR_ACCT_NO                                          
MFA-TR*             ,A.ADDRESS_ID                                               
MFA-TR*             ,A.GUAR_NOTICE_FLAG                                         
MFA-TR*             ,B.ADDRESS_ID                                               
MFA-TR*             ,B.ADDRESS_FORMAT                                           
MFA-TR*       FROM CSS_GUARANTOR A, CSS_ACCOUNT B                               
MFA-TR*       WHERE A.ACCOUNT_NO = :GU-ACCOUNT-NO AND                           
MFA-TR*           A.GUARNTR_ACCT_NO = B.ACCOUNT_NO AND                          
MFA-TR*           A.GUAR_STATUS_CD = 'A' AND                                    
MFA-TR*           A.SERVICE_TYPE_CD = 'U'                                       
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS MAIN PROCESSING OF PROGRAM                            *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION            THRU 0100-EXIT.       
           PERFORM 1000-PROCESS-INPUT             THRU 1000-EXIT.       
           PERFORM 9000-TERMINATE                 THRU 9000-EXIT.       
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZATION.                                           *        
      ******************************************************************        
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
P0599A     INITIALIZE WS-SYSIPT.                                        
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT           
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE   THRU 6240-EXIT       
              MOVE WS-FCA00-COMMON-DATE  TO WS-INPUT-DATE               
              DISPLAY '********************************************'    
              DISPLAY '* COMMON DATE BEING USED                   *'    
              DISPLAY '* DATE = ' WS-INPUT-DATE                         
              DISPLAY '* PROCESSING CONTINUING                    *'    
              DISPLAY '********************************************'    
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE               TO WS-CWS337-PROCESS-DATE   
                                               WS-COMMON-DATE.          
                                                                        
P0599A* TO IDENTIFY THE DATA BASE                                               
P0599A     MOVE ZERO                            TO WS-CWS350-DATABASE.  
P0599A     MOVE '01'                            TO C8-COMPANY-NO.       
P0599A     MOVE 'DATABASE'                      TO C8-DELINQ-CD.        
P0599A     PERFORM 7000-SELECT-DELINQ-VALUE     THRU 7000-EXIT.         
P0599A     MOVE C8-DELINQ-VALUE                 TO WS-CWS350-DATABASE.  
      * GET DB2 INSERT ROW COUNT                                                
           PERFORM 0115-GET-COMMIT-ROW-COUNT      THRU 0115-EXIT.       
                                                                        
      * GET THE NEXT BUSINESS DAY                                               
           MOVE WS-INPUT-DATE               TO WS-NEW-BUSINESS-DAY      
           PERFORM 6500-GET-NEXT-BUSINESS-DAY                           
                                    THRU 6500-NEXT-BUSINESS-DAY-EXIT    
           MOVE WS-NEW-BUSINESS-DAY         TO WS-PROCESSED-DATE.       
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0115-GET-COMMIT-ROW-COUNT.                                     *        
      * GET THE INSERT ROW COUNT FROM JOB PARM TABLE                   *        
      ******************************************************************        
                                                                        
       0115-GET-COMMIT-ROW-COUNT.                                       
                                                                        
           MOVE  WS-PGRMNAME                TO WS-PROGRAM.              
           MOVE  WS-PARM                    TO WS-COMMAND.              
           MOVE  ZEROS                      TO WS-SEQUENCE.             
           MOVE  SPACES                     TO WS-SYSIPT.               
           MOVE  WS-KEY-AREA                TO E-FJC01-KEY.             
                                                                        
           PERFORM 7600-START-FCSJC01       THRU  7600-EXIT.            
           PERFORM 7610-READ-FCSJC01        THRU  7610-EXIT             
             UNTIL (COMMIT-ROW-CNT AND INPUT-ACTIVE) OR                 
                   END-OF-SYSIPT.                                       
                                                                        
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '** ' WS-PGRMNAME ' PROCESSING WARNING  **'       
              DISPLAY '**  COMMIT-ROW-CNT PARM NOT ACTIVE     **'       
              DISPLAY '**  DEFAULT OF ' WS-DEFAULT-INSERT-COUNT         
                          ' WILL BE USED  **'                           
              DISPLAY '**  PROCESSING CONTINUING        **'             
              MOVE WS-DEFAULT-INSERT-COUNT                              
                                            TO WS-READY-TO-COMMIT-COUNT 
           ELSE                                                         
              IF WS-NO-OF-ROWS-TO-COMMIT NUMERIC                        
                 MOVE WS-NO-OF-ROWS-TO-COMMIT                           
                                            TO WS-READY-TO-COMMIT-COUNT 
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY '**  ' WS-PGRMNAME ' PROCESSING WARNING  **'   
                 DISPLAY '**  COMMIT-ROW-CNT PARM NOT NUMERIC  **'      
                 DISPLAY '**  DEFAULT OF ' WS-DEFAULT-INSERT-COUNT      
                         ' WILL BE USED  **'                            
                 DISPLAY '**  PROCESSING CONTINUING        **'          
                 MOVE WS-DEFAULT-INSERT-COUNT                           
                                            TO WS-READY-TO-COMMIT-COUNT 
              END-IF                                                    
              PERFORM 7611-CLOSE            THRU 7611-EXIT              
           END-IF.                                                      
                                                                        
       0115-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 7500-OPEN-FINAL-NOTICE-CSR   THRU 7500-EXIT.         
           PERFORM 7510-FETCH-FINAL-NOTICE-CSR  THRU 7510-EXIT.         
                                                                        
           PERFORM UNTIL SQLCODE = NOT-FOUND                            
              MOVE AT-ACCOUNT-NO         TO WS-ACCOUNT-NO               
              PERFORM 5200-CHK-SKIP-ACCTS       THRU 5200-CPD347-EXIT   
              IF PROCESS-ACCT                                           
                 PERFORM 1100-PROCESS-ACCOUNT   THRU 1100-EXIT          
              END-IF                                                    
              PERFORM 7510-FETCH-FINAL-NOTICE-CSR THRU 7510-EXIT        
           END-PERFORM.                                                 
           PERFORM 7520-CLOSE-FINAL-NOTICE-CSR  THRU 7520-EXIT.         
                                                                        
           IF WS-RECS-TO-COMMIT-COUNT > 0                               
              PERFORM 8888-COMMIT               THRU 8888-EXIT          
           END-IF.                                                      
                                                                        
           DISPLAY '** PCSKR300 PROCESSING COMPLETED SUCCESSFULLY **'.  
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-PROCESS-ACCOUNT                                           *        
      ******************************************************************        
                                                                        
       1100-PROCESS-ACCOUNT.                                            
                                                                        
           PERFORM 2000-PROCESS-OUTPUT          THRU 2000-EXIT.         
           PERFORM 2200-GENERATE-WQ             THRU 2200-EXIT          
                   VARYING WS-WQ-INDX FROM 1 BY 1                       
                   UNTIL   WS-WQ-INDX  > 50 OR                          
                           WS-WQ-CATEGORY-ID-WF(WS-WQ-INDX) = ZERO      
                                                                        
           IF WS-RECS-TO-COMMIT-COUNT = WS-READY-TO-COMMIT-COUNT        
              PERFORM 8888-COMMIT               THRU 8888-EXIT          
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
      * Initialize WS variables                                                 
           INITIALIZE WS-WQ-ITEMS-MF                                    
                      WS-CORRESP-HDR                                    
                      WS-CORRESP-NOTICE                                 
                      WS-CORRESP-VAR                                    
P0599A                WS-GUARANTOR-ACCT-NO                              
                      WS-AUTO-DEP-CHARGED-AMT.                          
           MOVE 'Y'                             TO WS-GENERATE-NOTICE.  
           MOVE 'N'                             TO WS-GUARANTOR-EXISTS. 
           MOVE 1                               TO WS-WQ-INDX.          
           MOVE AT-ACCOUNT-NO                   TO FW-ACCOUNT-NO        
                                                   KD-ACCOUNT-NO        
                                                   GU-ACCOUNT-NO        
                                                   CZ-ACCOUNT-NO        
                                                   WS-ACCOUNT-NO        
                                                   WS-CURR-ACCOUNT-NO.  
           MOVE KD-FW-ACTION-TYPE-CD   TO WS-CURR-ACTION-TYPE-CD.       
                                                                        
P0599C     IF WS-PREV-ACCOUNT-NO NOT = AT-ACCOUNT-NO                    
P0599C        MOVE SPACES                       TO                      
P0599C                                          WS-ACCT-NOT-GUARANTEED  
P0599C     END-IF.                                                      
                                                                        
           PERFORM 7060-SELECT-CREDIT-PROFILE   THRU 7060-EXIT.         
           MOVE CZ-CASH-ONLY-FL                 TO                      
                                               WS-NOTICE-CASH-ONLY-FL   
      * Process Bankrupt/Judgement/Total-AR-Balance Accounts                    
           PERFORM 2010-UPDATE-PROCESSED-FLAG   THRU 2010-EXIT.         
                                                                        
      * Limit check process                                                     
           PERFORM 2020-LIMIT-CHECK-PROCESS     THRU 2020-EXIT.         
                                                                        
P0599A     IF GENERATE-NOTICE                                           
              PERFORM 2100-PROCESS-ACCOUNT      THRU 2100-EXIT          
           END-IF.                                                      
           MOVE WS-CURR-ACCOUNT-NO     TO WS-PREV-ACCOUNT-NO.           
           MOVE WS-CURR-ACTION-TYPE-CD TO WS-PREV-ACTION-TYPE-CD.       
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07704000
      * 2010-UPDATE-PROCESSED-FLAG                                     *        
      ******************************************************************07704000
                                                                        
       2010-UPDATE-PROCESSED-FLAG.                                      
                                                                        
           IF AT-BANKRUPTCY-IND    > SPACES                             
              PERFORM 8500-UPDATE-PROCESSED-FL  THRU 8500-EXIT          
              MOVE 'N'                          TO WS-GENERATE-NOTICE   
           END-IF.                                                      
                                                                        
           IF AT-JUDGEMENT-CASE-NO > SPACES                             
              PERFORM 8500-UPDATE-PROCESSED-FL  THRU 8500-EXIT          
              MOVE 'N'                          TO WS-GENERATE-NOTICE   
           END-IF.                                                      
                                                                        
           IF AT-TOTAL-AR-BALANCE <= 0                                  
              PERFORM 8500-UPDATE-PROCESSED-FL  THRU 8500-EXIT          
              MOVE 'N'                          TO WS-GENERATE-NOTICE   
           END-IF.                                                      
                                                                        
P0599C     IF ACCT-NOT-GUARANTEED AND                                   
P0599C        KD-FW-ACTION-TYPE-CD   = 90306                            
P0599C        PERFORM 8900-DELETE-FIN-WO-ACTN   THRU 8900-EXIT          
P0599C        MOVE 'N'                          TO WS-GENERATE-NOTICE   
P0599C     END-IF.                                                      
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07704000
      * 2020-LIMIT-CHECK-PROCESS                                       *        
      ******************************************************************07704000
                                                                        
       2020-LIMIT-CHECK-PROCESS.                                        
                                                                        
           MOVE 'FN'                        TO F8-FW-BUS-PROCESS-CD.    
           MOVE AT-COMPANY-NO               TO WS-FW-COMPANY.           
           MOVE FW-REG-GROUP-CD             TO WS-REG-GROUP-CD.         
           MOVE FW-FW-PATH-TYPE-CD          TO WS-FW-PATH-TYPE-CD.      
           MOVE KD-FW-ACTION-TYPE-CD        TO WS-FW-ACTION-TYPE-CD.    
           PERFORM 5100-GET-FCST-ACTN-DATA  THRU 5100-CPD337-EXIT.      
                                                                        
           IF F8-MATCH-FOUND                                            
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '**************PCSKR300*************************'
               DISPLAY '* NO MATCH FOUND ON CSS_FW_FCST_ACTION TABLE.  '
               DISPLAY '* COMPANY NO     :' AT-COMPANY-NO               
               DISPLAY '* REG GROUP CD   :' FW-REG-GROUP-CD             
               DISPLAY '* PATH TYPE CD   :' FW-FW-PATH-TYPE-CD          
               DISPLAY '* ACTION TYPE CD :' KD-FW-ACTION-TYPE-CD        
               DISPLAY '* RETURN CODE = 12'                             
               DISPLAY '**************PCSKR300*************************'
               PERFORM 9900-ABEND   THRU 9900-EXIT                      
           END-IF.                                                      
                                                                        
           IF AT-TOTAL-AR-BALANCE < WS-FW-ACTION-LIMIT-AM AND           
              KD-FW-ACTION-TYPE-CD NOT EQUAL '90307'                    
              MOVE 0                        TO KD-FW-ACTION-AM          
              MOVE 'N'                      TO WS-GENERATE-NOTICE       
              PERFORM 8510-UPDATE-PROCESS-FL-ACTN-AM  THRU 8510-EXIT    
           END-IF.                                                      
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08494000
      * 2100-PROCESS-ACCOUNT                                            08495000
      ******************************************************************08497000
                                                                        
       2100-PROCESS-ACCOUNT.                                            
                                                                        
           DISPLAY 'PROCESSING ACCOUNT:' AT-ACCOUNT-NO                  
           IF FW-GUARANTEED-IND > SPACES                                
              PERFORM 7020-CHECK-GUARANTEED-ACCT        THRU 7020-EXIT  
           END-IF.                                                      
                                                                        
           IF AT-TOTAL-AR-BALANCE >= WS-FW-ACTION-LIMIT-AM              
              IF WS-FW-SPEC-PROCESS-CD > SPACES                         
                 EVALUATE WS-FW-SPEC-PROCESS-CD                         
                     WHEN 'LPC'                                         
                          PERFORM 5010-LPC-CHECK        THRU 5010-EXIT  
                     WHEN 'RETCK'                                       
                          PERFORM 5020-RETURNED-CHECK   THRU 5020-EXIT  
                 END-EVALUATE                                           
              END-IF                                                    
           END-IF.                                                      
                                                                        
P0599A     IF GENERATE-NOTICE                                           
              PERFORM 5300-PROCESS-NOTICE               THRU 5300-EXIT  
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07704000
      * 2200-GENERATE-WQ.                                              *        
      * INSERTS ANY WQ'S TO DB2.                                       *        
      ******************************************************************07704000
                                                                        
       2200-GENERATE-WQ.                                                
                                                                        
ACT036     INITIALIZE CWS00077-FIELDS.                                  
ACT036     INITIALIZE WS-77-COMMENTS.                                   
                                                                        
ACT036     MOVE WS-WQ-CATEGORY-ID-WF (WS-WQ-INDX)                       
                                                 TO WS-77-CATEGORY-ID   
ACT036     MOVE WS-WQ-PRIORITY-WF (WS-WQ-INDX)   TO WS-77-PRIORITY      
ACT036     MOVE WS-WQ-ROUTE-CATEGORY-WF (WS-WQ-INDX)                    
                                                 TO WS-77-ROUTE-CATEGORY
ACT036     MOVE WS-WQ-COMMENTS-WF (WS-WQ-INDX)   TO WS-77-COMMENTS      
ACT036     MOVE ZERO                             TO WS-77-SERV-ORDER-NO 
ACT036     MOVE WS-INPUT-DATE                    TO WS-77-DATE-REQUIRED 
ACT036     MOVE WS-INPUT-DATE                    TO                     
ACT036                                           WS-INPUT-DATE-26(1:10) 
ACT036     MOVE WS-INPUT-ZERO                    TO                     
ACT036                                           WS-INPUT-DATE-26(11:16)
ACT036     MOVE WS-INPUT-DATE-26                 TO WS-77-DATE-CREATED  
ACT036     MOVE AT-ACCOUNT-NO                    TO WS-77-ACCOUNT-NO    
ACT036     MOVE AT-PREMISE-NO                    TO WS-77-PREMISE-NO    
ACT036     MOVE AT-CUSTOMER-NO                   TO WS-77-CUSTOMER-NO   
ACT036     MOVE SPACES                           TO WS-77-USER-ID-ORIG  
ACT036     MOVE '001'                            TO WS-77-RESP-AREA-ID  
ACT036     MOVE SPACES                           TO WS-77-RESP-AREA-ID  
ACT036     MOVE AT-LOCAL-OFFICE                  TO WS-77-LOCAL-OFFICE  
ACT036     MOVE ZERO                             TO WS-77-FREE-FORM-LEN 
ACT036     MOVE LOW-VALUES                       TO WS-77-FREE-FORM-TXT 
ACT036     MOVE WS-PGRMNAME                      TO WS-77-CREATED-BY    
ACT036     DISPLAY '   ' WS-WQ-COMMENTS-WF (WS-WQ-INDX)                 
           PERFORM 8895-INSERT-WORK-QUEUE        THRU 8895-EXIT.        
                                                                        
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0599A******************************************************************        
P0599A* 2300-LOAD-KR125-MNT-TRANS                                               
P0599A**************************************************************            
P0599A                                                                  
P0599A 2300-LOAD-KR125-MNT-TRANS.                                       
P0599A                                                                  
P0599A* provide the comment for panel 156 - notice transaction                  
P0599A* history.                                                                
P0599A                                                                  
P0599A     INITIALIZE  WS-CWS00136-NOTICE-TYPE                          
P0599A                 WS-CWS00136-DATE-MAIL                            
P0599A                 WS-CWS00136-DATE-NOTICE-DUE                      
P0599A                 WS-CWS00136-AMT-NOTICE-DOL                       
P0599A                 WS-CWS00136-AMT-NOTICE-DEC                       
P0599A                 WS-CWS00136-MESSAGE-NUMBER                       
P0599A                 WS-CWS00136-FRCST-AUTO-DEP-DL                    
P0599A                 WS-CWS00136-FRCST-AUTO-DEP-DC                    
P0599A                 WS-HOLD-AMOUNT.                                  
P0599A     MOVE 'H'                      TO WS-KR125-CODE-TRAN-TYP.     
P0599A     MOVE SPACES                   TO WS-KR125-RESP-AREA-ID.      
P0599A     MOVE ZEROES                   TO WS-KR125-MNT-PREMISE-NO     
P0599A                                      WS-KR125-MNT-CUSTOMER-NO.   
P0599A     MOVE WS-PGRMNAME              TO WS-CORRESP-CREATED-BY-PGM-ID
P0599A                                                                  
P0599A     EVALUATE KD-FW-ACTION-TYPE-CD                                
P0599A         WHEN 90205                                               
P0599A            MOVE 'RETURNED CHECK NOTICE 1'                        
P0599A                                   TO WS-CWS00136-NOTICE-TYPE     
P0599A         WHEN 90301                                               
P0599A              MOVE 'FINAL BILL 20-DAY NOTICE'                     
P0599A                                   TO WS-CWS00136-NOTICE-TYPE     
P0599A         WHEN 90302                                               
P0599A              MOVE 'FINAL BILL 30-DAY NOTICE'                     
P0599A                                   TO WS-CWS00136-NOTICE-TYPE     
P0599A         WHEN 90303                                               
P0599A              MOVE 'FINAL BILL 40-DAY NOTICE'                     
P0599A                                   TO WS-CWS00136-NOTICE-TYPE     
P0599A         WHEN 90304                                               
P0599A              MOVE 'GUARANTEED 20-DAY NOTICE'                     
P0599A                                   TO WS-CWS00136-NOTICE-TYPE     
P0599A         WHEN 90305                                               
P0599A              MOVE 'GUARANTEED 30-DAY NOTICE'                     
P0599A                                   TO WS-CWS00136-NOTICE-TYPE     
P0599A         WHEN 90306                                               
P0599A              MOVE 'GUARANTOR FINAL BILL NOTICE'                  
P0599A                                   TO WS-CWS00136-NOTICE-TYPE     
P0599A         WHEN 90307                                               
P0599A              MOVE 'GUARANTOR TRANSFER NOTICE'                    
P0599A                                   TO WS-CWS00136-NOTICE-TYPE     
P0599A         WHEN 90308                                               
P0599A              MOVE 'DNP 10-DAY NOTICE'                            
P0599A                                   TO WS-CWS00136-NOTICE-TYPE     
P0599A         WHEN 90309                                               
P0599A              MOVE 'DNP 20-DAY NOTICE'                            
P0599A                                   TO WS-CWS00136-NOTICE-TYPE     
P0599A     END-EVALUATE.                                                
P0599A                                                                  
P0599A     MOVE KD-FW-ACTION-TYPE-CD     TO WS-CWS00136-MESSAGE-NUMBER. 
P0599A     MOVE SPACES                   TO WS-CWS00136-DATE-MAIL.      
P0599A     MOVE WS-SLASHES-6             TO WS-CWS00136-DATE-MAIL.      
P0599A     MOVE WS-PROCESSED-DATE(6:2)   TO WS-CWS00136-DATE-MAIL(1:2). 
P0599A     MOVE WS-PROCESSED-DATE(9:2)   TO WS-CWS00136-DATE-MAIL(4:2). 
P0599A     MOVE WS-PROCESSED-DATE(1:4)   TO WS-CWS00136-DATE-MAIL(7:4). 
P0599A                                                                  
P0599A     IF WS-FW-ACTION-DT = SPACES OR LOW-VALUES                    
P0599A        MOVE 'NONE'                TO WS-CWS00136-DATE-NOTICE-DUE 
P0599A     ELSE                                                         
P0599A        MOVE WS-SLASHES-6          TO WS-CWS00136-DATE-NOTICE-DUE 
P0599A        MOVE WS-FW-ACTION-DT(6:2)  TO                             
P0599A             WS-CWS00136-DATE-NOTICE-DUE(1:2)                     
P0599A        MOVE WS-FW-ACTION-DT(9:2)  TO                             
P0599A             WS-CWS00136-DATE-NOTICE-DUE(4:2)                     
P0599A        MOVE WS-FW-ACTION-DT(1:4)  TO                             
P0599A             WS-CWS00136-DATE-NOTICE-DUE(7:4)                     
P0599A                                                                  
P0599A        IF KD-FW-ACTION-TYPE-CD = 90307                           
P0599A           MOVE 'NONE'             TO WS-CWS00136-DATE-NOTICE-DUE 
P0599A        END-IF                                                    
P0599A     END-IF.                                                      
P0599A                                                                  
P0599A     MOVE KD-FW-ACTION-AM          TO WS-HOLD-AMOUNT.             
P0599A     IF KD-FW-ACTION-TYPE-CD   = 90306                            
P0599A        MOVE GU-AMOUNT-GUARANTEED  TO WS-HOLD-AMOUNT              
P0599A        MOVE WS-GUARANTOR-ACCT-NO  TO WS-KR125-MNT-ACCOUNT-NO     
P0599A        MOVE WS-LPC-AMOUNT         TO WS-CRED-LPC-AMT             
P0599A     END-IF.                                                      
P0599A                                                                  
P0599A     MOVE WS-DOL-AMOUNT            TO WS-CWS00136-AMT-NOTICE-DOL. 
P0599A     MOVE WS-DEC-AMOUNT            TO WS-CWS00136-AMT-NOTICE-DEC. 
P0599A                                                                  
P0599A     IF KD-FW-ACTION-TYPE-CD   = 90306 OR 90307                   
P0599A        MOVE AT-ACCOUNT-NO         TO WS-CWS00136-GUAR-TP-ACCT-NO 
P0599A        STRING 'GUARANTEE ACCT NO: ' DELIMITED BY SIZE            
P0599A               WS-CWS00136-GUAR-TP-ACCT-NO DELIMITED BY SIZE      
P0599A          INTO                                                    
P0599A               WS-CWS00136-COMMENT-LINE-3B                        
P0599A        STRING WS-CWS00136-FORMATTED-COMMENT DELIMITED BY SIZE    
P0599A               WS-CWS00136-COMMENT-LINE-3B   DELIMITED BY SIZE    
P0599A          INTO                                                    
P0599A               WS-KR125-TRAN-CMT-TEXT                             
P0599A        MOVE +173                  TO WS-KR125-TRAN-CMT-LEN       
P0599A     ELSE                                                         
P0599A        MOVE WS-CWS00136-FORMATTED-COMMENT                        
P0599A                                   TO WS-KR125-TRAN-CMT-TEXT      
P0599A        MOVE +107                  TO WS-KR125-TRAN-CMT-LEN       
P0599A     END-IF.                                                      
P0599A                                                                  
P0599A 2300-EXIT.                                                       
P0599A     EXIT.                                                        
P0599A                                                                  
      ******************************************************************08494000
      * 5010-LPC-CHECK                                                 *08495000
      ******************************************************************08497000
                                                                        
       5010-LPC-CHECK.                                                  
                                                                        
           PERFORM 7010-SELECT-LPC-AMOUNT      THRU 7010-EXIT.          
           IF SQLCODE = SUCCESSFUL-CALL                                 
              MOVE KD-FW-ACTION-AM             TO WS-CRED-LPC-AMT       
                                                  WS-LPC-AMOUNT         
           ELSE                                                         
              PERFORM 5400-POPULATE-WORK-QUEUE THRU 5400-EXIT           
              MOVE 'FN'                        TO F8-FW-BUS-PROCESS-CD  
              MOVE 'DE'                        TO WS-FW-PATH-TYPE-CD    
              MOVE 'LPDAY'                     TO WS-FW-ACTION-TYPE-CD  
              MOVE AT-COMPANY-NO               TO WS-FW-COMPANY         
              MOVE FW-REG-GROUP-CD             TO WS-REG-GROUP-CD       
              PERFORM 5100-GET-FCST-ACTN-DATA  THRU 5100-CPD337-EXIT    
              MOVE WS-FW-FCST-DAYS-NM          TO WS-NO-OF-DAY          
              PERFORM 5040-BUMP-UP-DAYS        THRU 5040-EXIT           
              MOVE 'N'                         TO WS-GENERATE-NOTICE    
                                                                        
              IF WS-CURR-ACCOUNT-NO NOT EQUAL WS-PREV-ACCOUNT-NO        
                 ADD 1 TO WS-RECS-TO-COMMIT-COUNT                       
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5020-RETURNED-CHECK                                            *        
      ******************************************************************        
                                                                        
       5020-RETURNED-CHECK.                                             
                                                                        
           IF KD-FW-ACTION-COMMENTS-TEXT > SPACES                       
              MOVE KD-FW-ACTION-COMMENTS-TEXT(1:26)                     
                                            TO NH-NSF-TIMESTMP          
              MOVE AT-ACCOUNT-NO            TO NH-ACCOUNT-NO            
              PERFORM 7050-GET-NSF-DETAILS  THRU 7050-EXIT              
              IF SQLCODE = 0                                            
                 MOVE NH-DATE-TRAN          TO WS-DATE-TRAN             
                 MOVE NH-RETURN-CHECK-AMT   TO WS-RET-CHK-AMT           
                 MOVE NH-NSF-CHARGE-AMT     TO WS-NSF-CHARGE-AMT        
                 MOVE NH-NSF-REASON-CD      TO WS-NSF-REASON-CD         
                 MOVE NH-DRAWN-BY-NM        TO WS-DRAWN-BY-NM           
P0599B           COMPUTE WS-TOTAL-RET-CHK-AMT =                         
P0599B                   NH-RETURN-CHECK-AMT + NH-NSF-CHARGE-AMT        
P0599B           MOVE AT-TOTAL-AR-BALANCE   TO WS-RET-CHK-PAST-DUE-AMT  
              END-IF                                                    
P0599A                                                                  
P0599A        MOVE WS-NSF-REASON-CD         TO NR-NSF-REASON-CD         
P0599A        PERFORM 7070-SELECT-NSF-REASON   THRU 7070-EXIT           
P0599A        IF SQLCODE = 0                                            
P0599A           MOVE NR-NSF-REASON-DESC    TO WS-NSF-REASON-DESC       
P0599A        ELSE                                                      
P0599A           MOVE 'OTHER'               TO WS-NSF-REASON-DESC       
P0599A        END-IF                                                    
           END-IF.                                                      
                                                                        
       5020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08494000
      * 5030-PATH-CHECK                                                *08495000
      ******************************************************************08497000
                                                                        
       5030-PATH-CHECK.                                                 
                                                                        
           IF FW-FW-PATH-TYPE-CD = '7'                                  
              IF FW-GUARANTEED-IND = 'Y'                                
                 IF GUARANTOR-EXISTS                                    
                    CONTINUE                                            
                 ELSE                                                   
                    PERFORM 8520-UPDATE-GUARANTEED-FL     THRU 8520-EXIT
                    PERFORM 5060-PREV-GUARANTEE-PROCESS   THRU 5060-EXIT
                 END-IF                                                 
              ELSE                                                      
                 PERFORM 5060-PREV-GUARANTEE-PROCESS      THRU 5060-EXIT
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************14833590
      * 5040-BUMP-UP-DAYS.                                              14833600
      ******************************************************************14833590
                                                                        
       5040-BUMP-UP-DAYS.                                               
                                                                        
           PERFORM 7530-OPEN-FINAL-WO-ACTN      THRU 7530-EXIT.         
           PERFORM 7540-FETCH-FINAL-WO-ACTN     THRU 7540-EXIT.         
                                                                        
           PERFORM 5050-BUMP-DATES-ACTN         THRU 5050-EXIT          
             UNTIL SQLCODE = NOT-FOUND.                                 
                                                                        
           PERFORM 7550-CLOSE-FINAL-WO-ACTN     THRU 7550-EXIT.         
                                                                        
       5040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5050-BUMP-DATES-ACTN                                                    
      ******************************************************************        
                                                                        
       5050-BUMP-DATES-ACTN.                                            
                                                                        
           IF KD-FW-ACTION-DT    > SPACES                               
              MOVE KD-FW-ACTION-DT          TO WS-NEW-BUSINESS-DAY      
              PERFORM 6500-GET-NEXT-BUSINESS-DAY                        
                                       THRU 6500-NEXT-BUSINESS-DAY-EXIT 
              MOVE WS-NEW-BUSINESS-DAY      TO KD-FW-ACTION-DT          
           END-IF.                                                      
                                                                        
           PERFORM 8530-UPDATE-FIN-WO-DATES-ACTN      THRU 8530-EXIT.   
                                                                        
           PERFORM 7540-FETCH-FINAL-WO-ACTN           THRU 7540-EXIT.   
                                                                        
       5050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08494000
      * 5060-PREV-GUARANTEE-PROCESS                                    *08495000
      ******************************************************************08497000
                                                                        
       5060-PREV-GUARANTEE-PROCESS.                                     
                                                                        
P0599C     SET ACCT-NOT-GUARANTEED          TO TRUE.                    
           MOVE 'FN'                        TO F8-FW-BUS-PROCESS-CD.    
           MOVE AT-COMPANY-NO               TO WS-FW-COMPANY.           
           MOVE FW-REG-GROUP-CD             TO WS-REG-GROUP-CD.         
           MOVE 'DE'                        TO WS-FW-PATH-TYPE-CD.      
           MOVE KD-FW-ACTION-TYPE-CD        TO WS-FW-ACTION-TYPE-CD.    
           PERFORM 5100-GET-FCST-ACTN-DATA  THRU 5100-CPD337-EXIT.      
           MOVE WS-FW-SPEC-PROCESS-CD       TO WS-NEW-ACTN-TYPE-CD.     
                                                                        
           PERFORM 8540-UPDATE-NEW-ACTION-TYPE-CD   THRU 8540-EXIT.     
           EVALUATE SQLCODE                                             
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
               WHEN -531                                                
                    PERFORM 8700-INSERT-FIN-WO-ACTN THRU 8700-EXIT      
                    PERFORM 8900-DELETE-FIN-WO-ACTN THRU 8900-EXIT      
           END-EVALUATE.                                                
                                                                        
           MOVE WS-NEW-ACTN-TYPE-CD         TO KD-FW-ACTION-TYPE-CD.    
                                                                        
       5060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5100-GET-FCST-ACTN-DATA                                        *11187000
      ******************************************************************11187100
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD00337                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 5200-CHK-SKIP-ACCTS                                      *      11187000
      ******************************************************************11187100
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00347                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************08494000
      * 5300-PROCESS-NOTICE                                            *08495000
      ******************************************************************08497000
                                                                        
       5300-PROCESS-NOTICE.                                             
                                                                        
ACT017     IF WS-CURR-ACTION-TYPE-CD = '90205'                          
ACT017        IF FW-FW-PATH-TYPE-CD = '7' AND FW-GUARANTEED-IND = 'Y'   
ACT017           IF GUARANTOR-EXISTS                                    
ACT017              CONTINUE                                            
ACT017           ELSE                                                   
ACT017              PERFORM 8520-UPDATE-GUARANTEED-FL THRU 8520-EXIT    
ACT017           END-IF                                                 
ACT017        END-IF                                                    
ACT017     ELSE                                                         
ACT017        PERFORM 5030-PATH-CHECK       THRU 5030-EXIT              
ACT017     END-IF.                                                      
ACT017                                                                  
ACT096     IF WS-CURR-ACTION-TYPE-CD = '90205'                          
ACT096        MOVE SPACES                    TO WS-FW-ACTION-DT         
ACT096     ELSE                                                         
              PERFORM 7040-GET-DUE-DATE        THRU 7040-EXIT           
              MOVE WS-FW-ACTION-DT             TO WS-NEW-BUSINESS-DAY   
              PERFORM 6525-PREV-BUSINESS-DAY                            
                                       THRU 6525-PREV-BUSINESS-DAY-EXIT 
              MOVE WS-NEW-BUSINESS-DAY         TO WS-FW-ACTION-DT       
ACT096     END-IF.                                                      
                                                                        
           IF WS-CURR-ACTION-TYPE-CD = '90205' OR '90307'               
              PERFORM 8500-UPDATE-PROCESSED-FL  THRU 8500-EXIT          
           ELSE                                                         
P0599A        MOVE AT-TOTAL-AR-BALANCE          TO KD-FW-ACTION-AM      
              PERFORM 8510-UPDATE-PROCESS-FL-ACTN-AM THRU 8510-EXIT     
           END-IF.                                                      
                                                                        
P0599A     IF WS-CURR-ACTION-TYPE-CD = '90306' AND                      
P0599A        GUARANTOR-EXISTS                                          
P0599A        PERFORM 5475-GENERATE-GRNTR-NOTICES THRU 5475-EXIT        
P0599A     ELSE                                                         
              IF KD-GUARANTOR-ACCT-NO > 0                               
                 PERFORM 7080-SELECT-GUAR-DTLS THRU 7080-EXIT           
                 MOVE KD-GUARANTOR-ACCT-NO     TO WS-GUARANTOR-ACCT-NO  
P0599A           IF GU-ADDRESS-ID > 0                                   
P0599A              MOVE GU-ADDRESS-ID         TO WS-CORRESP-CC-ADDR-ID 
P0599A              MOVE 'B'                   TO WS-GU-ADDRESS-FORMAT  
P0599A           ELSE                                                   
P0599A              MOVE AT-ADDRESS-ID         TO WS-CORRESP-CC-ADDR-ID 
P0599A              MOVE AT-ADDRESS-FORMAT     TO WS-GU-ADDRESS-FORMAT  
P0599A           END-IF                                                 
              END-IF                                                    
P0599A        PERFORM 5450-GENERATE-NOTICES    THRU 5450-EXIT           
P0599A     END-IF.                                                      
                                                                        
           IF FW-ACCOUNT-NO NOT= WS-PREV-ACCOUNT-NO                     
              ADD 1                         TO WS-RECS-TO-COMMIT-COUNT  
           END-IF.                                                      
                                                                        
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11183800
      * 5400-POPULATE-WORK-QUEUE                                       *11184000
      ******************************************************************11184200
                                                                        
       5400-POPULATE-WORK-QUEUE.                                        
                                                                        
                                                                        
           MOVE +151             TO WS-WQ-CATEGORY-ID-WF (WS-WQ-INDX).  
           MOVE WS-MISC-MSG-TEXT TO WS-WQ-COMMENTS-TEXT-WF (WS-WQ-INDX).
           MOVE WS-MISC-MSG-LEN  TO WS-WQ-COMMENTS-LEN-WF (WS-WQ-INDX). 
           MOVE 4                TO WS-WQ-ROUTE-CATEGORY-WF (WS-WQ-INDX)
           MOVE 'N'              TO WS-WQ-PRIORITY-WF (WS-WQ-INDX).     
           ADD  1 TO WS-WQ-INDX.                                        
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0599A******************************************************************        
P0599A* 5450-GENERATE-NOTICES.                                         *        
P0599A* Populate notice data and call SCSKR125.                        *        
P0599A******************************************************************        
P0599A*                                                                         
P0599A 5450-GENERATE-NOTICES.                                           
P0599A*                                                                         
P0599A     INITIALIZE WS-KR125-MNT-TRANS-VARS.                          
P0599A                                                                  
P0599A     MOVE WS-INPUT-DATE          TO WS-COMMON-DATE.               
P0599A     MOVE PROGRAM-NAME           TO WS-CORRESP-LAST-UPDATE-PGM-ID 
P0599A                                    WS-CALLING-PGM-NAME.          
P0599A     MOVE AT-ACCOUNT-NO          TO WS-NOTICE-ACCOUNT-NO          
P0599A                                    WS-KR125-COMM-ACCT-NO         
P0599A                                    WS-KR125-MNT-ACCOUNT-NO.      
P0599A     MOVE AT-CUSTOMER-NO         TO WS-NOTICE-CUSTOMER-NO         
P0599A                                    WS-KR125-CUSTOMER-NO.         
P0599A     MOVE KD-FW-ACTION-TYPE-CD   TO WS-CORRESP-MSG-ID.            
P0599A     MOVE 1                      TO WS-NOTICE-CORRESP-ID.         
P0599A     MOVE WS-GUARANTOR-ACCT-NO   TO WS-NOTICE-GUARANTOR-ACCT-NO.  
P0599A     MOVE AT-COMPANY-NO          TO WS-CORRESP-COMPANY-NO         
P0599A     MOVE FW-REG-GROUP-CD        TO WS-NOTICE-REG-GROUP-CD.       
P0599A     MOVE FW-SENIOR-FL           TO WS-NOTICE-SENIOR-FL.          
P0599A     MOVE WS-INPUT-DATE          TO WS-CORRESP-STMT-DT.           
P0599A     MOVE 0                      TO WS-NOTICE-AUTO-DEP-FCST-AM.   
P0599A     MOVE 0                      TO WS-NOTICE-UTIL-PAST-DUE-AM.   
P0599A     MOVE 0                      TO WS-NOTICE-NONUTL-PAST-DUE-AM. 
P0599A     MOVE WS-FW-ACTION-DT        TO WS-NOTICE-DUE-DT              
P0599A     MOVE AT-LAST-PYMT-DATE      TO WS-NOTICE-LAST-PAYMENT-DT.    
P0599A     MOVE AT-LAST-PYMT-AMOUNT    TO WS-NOTICE-LAST-PAYMENT-AM.    
P0599A     MOVE AT-LOCAL-OFFICE        TO WS-CWS350-LOCAL-OFFICE.       
P0599A                                                                  
P0599A     IF KD-FW-ACTION-TYPE-CD = '90205'                            
P0599A        MOVE WS-DATE-TRAN        TO    WS-KR125-MNT-DATE-TRANS    
P0599A     ELSE                                                         
P0599A        MOVE WS-INPUT-DATE       TO    WS-KR125-MNT-DATE-TRANS    
P0599A     END-IF.                                                      
P0599A*                                                                         
P0599A     IF FW-ACCOUNT-NO = WS-PREV-ACCOUNT-NO AND                    
P0599A        WS-CURR-ACTION-TYPE-CD = WS-PREV-ACTION-TYPE-CD           
P0599B       ADD 1                     TO WS-HOLD-CORRESP-SEQ-NO        
P0599A     ELSE                                                         
P0599B       MOVE 0                    TO WS-HOLD-CORRESP-SEQ-NO        
P0599A     END-IF.                                                      
P0599A*                                                                         
P0599B     MOVE WS-HOLD-CORRESP-SEQ-NO TO WS-CORRESP-SEQ-NO.            
P0599A     MOVE AT-PREMISE-NO          TO WS-KR125-PREMISE-NO.          
P0599A     MOVE 'A'                    TO WS-KR125-COMM-ASSOC-CD.       
P0599A     MOVE SPACES                 TO WS-KR125-PSC-COMPL-ID.        
P0599A     MOVE SPACES                 TO WS-KR125-CONTACT-NAME.        
P0599A     MOVE SPACES                 TO WS-KR125-RED-FL-EXP-DT.       
P0599A     MOVE SPACES                 TO WS-KR125-CALL-END-TIME.       
P0599A     MOVE 0                      TO WS-KR125-COMDAT-CMT-LEN.      
P0599A     MOVE SPACES                 TO WS-KR125-COMDAT-CMT-TEXT.     
P0599A     MOVE PROGRAM-NAME           TO WS-KR125-MNT-APPL-PGM-ID.     
P0599A     PERFORM 2300-LOAD-KR125-MNT-TRANS   THRU 2300-EXIT           
P0599A*                                                                         
P0599A     IF KD-FW-ACTION-TYPE-CD = '90306'                            
P0599A        MOVE WS-HOLD-AMOUNT      TO WS-NOTICE-DUE-AM              
P0599A     ELSE                                                         
P0599B        IF KD-FW-ACTION-TYPE-CD = '90205'                         
P0599B           MOVE AT-TOTAL-AR-BALANCE TO WS-NOTICE-DUE-AM           
P0599B        ELSE                                                      
P0599B           MOVE KD-FW-ACTION-AM     TO WS-NOTICE-DUE-AM           
P0599B        END-IF                                                    
P0599A     END-IF.                                                      
P0599A*                                                                         
P0599A     PERFORM 5500-CALL-NOTICE-SUB     THRU 5500-EXIT.             
P0599A*                                                                         
P0599A 5450-EXIT.                                                       
P0599A     EXIT.                                                        
      *                                                                         
P0599A******************************************************************        
P0599A* 5475-GENERATE-GRNTR-NOTICES                                    *        
P0599A* Generate Guarantor Notices.                                    *        
P0599A******************************************************************        
P0599A*                                                                         
P0599A 5475-GENERATE-GRNTR-NOTICES.                                     
P0599A*                                                                         
P0599A     PERFORM 7100-OPEN-GUARANTOR  THRU 7100-EXIT.                 
P0599A     PERFORM 7110-FETCH-GUARANTOR THRU 7110-EXIT.                 
P0599A     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
P0599A        INITIALIZE                       WS-GUARANTOR-ACCT-NO     
P0599A                                         WS-CORRESP-CC-ADDR-ID    
P0599A                                         WS-GU-ADDRESS-FORMAT     
P0599A        MOVE GU-GUARNTR-ACCT-NO       TO WS-GUARANTOR-ACCT-NO     
P0599A        IF GU-ADDRESS-ID > 0                                      
P0599A           MOVE GU-ADDRESS-ID         TO WS-CORRESP-CC-ADDR-ID    
P0599A           MOVE 'B'                   TO WS-GU-ADDRESS-FORMAT     
P0599A        ELSE                                                      
P0599A           MOVE AT-ADDRESS-ID         TO WS-CORRESP-CC-ADDR-ID    
P0599A           MOVE AT-ADDRESS-FORMAT     TO WS-GU-ADDRESS-FORMAT     
P0599A        END-IF                                                    
P0599A        PERFORM 5450-GENERATE-NOTICES THRU 5450-EXIT              
P0599A        PERFORM 7110-FETCH-GUARANTOR  THRU 7110-EXIT              
P0599A     END-PERFORM.                                                 
                                                                        
P0599A     PERFORM 7120-CLOSE-GUARANTOR THRU 7120-EXIT.                 
P0599A*                                                                         
P0599A 5475-EXIT.                                                       
P0599A     EXIT.                                                        
      *                                                                         
P0599A******************************************************************        
P0599A* 5500-CALL-NOTICE-SUB.                                          *        
P0599A* THIS MODULE CALLS SCSKR125 THAT LOADS THE DATA TO THE CORRESP  *        
P0599A* NOTICE DB2 TABLES.                                             *        
P0599A******************************************************************        
P0599A*                                                                         
P0599A 5500-CALL-NOTICE-SUB.                                            
P0599A*                                                                         
P0599A     DISPLAY 'CALLING SCSKR125'.                                  
P0599A     CALL SCSKR125 USING WS-CORRESP-HDR                           
P0599A                         WS-CORRESP-NOTICE                        
P0599A                         WS-CORRESP-VAR                           
P0599A                         WS-MISC-PROCESSING-VARS                  
P0599A                         WS-KR125-COMM-DATA-VARS                  
P0599A                         WS-KR125-MNT-TRANS-VARS                  
P0599A                         ABEND-FILE                               
P0599A                         WS-CWS350-MISC                           
P0599A                         WS-CORRESP-COMM-VAR                      
P0599A                         RS-KR125-RETURN-CODE.                    
P0599A*                                                                         
P0599A     IF  ABEND-FUNCTION  > SPACES                                 
P0599A         MOVE ABEND-SQLCODE             TO RS-RETURN-CODE         
P0599A                                           WS-ACTIVE-RETURN-CODE  
P0599A         PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
P0599A     END-IF.                                                      
P0599A*                                                                         
P0599A 5500-EXIT.                                                       
P0599A     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6240-GET-FCA00-COMMON-DATE                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00040                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00037                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6253-GET-FJC01-CHKP-LIMIT.                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00034                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6500-GET-NEXT-BUSINESS-DAY                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00322                                                  
           END-EXEC.                                                            
                                                                        
P0599A******************************************************************        
P0599A* 7000-SELECT-DELINQ-VALUE                                       *        
P0599A* SELECTS THE DELINQUENCY VALUE FOR THE GIVEN DELINQ CODE        *        
P0599A******************************************************************        
P0599A 7000-SELECT-DELINQ-VALUE.                                        
P0599A*                                                                         
P0599A     EXEC SQL                                                     
P0599A        SELECT DELINQ_VALUE                                       
P0599A          INTO :C8-DELINQ-VALUE                                   
P0599A          FROM CSS_DELINQUENCY                                    
P0599A         WHERE DELINQ_CD  = :C8-DELINQ-CD                         
P0599A           AND COMPANY_NO = :C8-COMPANY-NO                        
P0599A                                                      
P0599A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0599A*                                                                         
P0599A     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0599A     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0599A        CONTINUE                                                  
P0599A     ELSE                                                         
P0599A        DISPLAY '********** PCSKR300 ABORT **************'        
P0599A        DISPLAY '* 7000-SELECT-DELINQ-VALUE             *'        
P0599A        DISPLAY '* DELINQ CD ', C8-DELINQ-CD                      
P0599A        DISPLAY '* COMPANY NO', C8-COMPANY-NO                     
P0599A        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
P0599A        DISPLAY '* PROGRAM ABORTING...                  *'        
P0599A        DISPLAY '********** PCSKR300 ABORT **************'        
P0599A        PERFORM 9900-ABEND THRU 9900-EXIT                         
P0599A     END-IF.                                                      
P0599A*                                                                         
P0599A 7000-EXIT.                                                       
P0599A     EXIT.                                                        
P0599A*                                                                         
      ******************************************************************        
      * 7010-SELECT-LPC-AMOUNT                                         *        
      ******************************************************************        
                                                                        
       7010-SELECT-LPC-AMOUNT.                                          
                                                                        
           EXEC SQL                                                     
              SELECT KD.FW_ACTION_AM                                    
                INTO :KD-FW-ACTION-AM                                   
                FROM CSS_FIN_WO_ACTION KD WITH(READUNCOMMITTED)                 
               WHERE KD.ACCOUNT_NO        = :KD-ACCOUNT-NO              
                 AND KD.FW_ACTION_TYPE_CD = :WS-FW-SPEC-PROCESS-CD      
                 AND KD.FW_PROCESSED_FL   = 'Y'                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT KD.FW_ACTION_AM                                            
MFA-TR*         INTO :KD-FW-ACTION-AM                                           
MFA-TR*         FROM CSS_FIN_WO_ACTION KD                                       
MFA-TR*        WHERE KD.ACCOUNT_NO        = :KD-ACCOUNT-NO                      
MFA-TR*          AND KD.FW_ACTION_TYPE_CD = :WS-FW-SPEC-PROCESS-CD              
MFA-TR*          AND KD.FW_PROCESSED_FL   = 'Y'                                 
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR300  ABORT ***************'      
              DISPLAY '* 7010-LPC-CHECK                         *'      
              DISPLAY '* SQLCODE IS        ' WS-DISPLAY-SQLCODE         
              DISPLAY '* ACCOUNT NO:       ' AT-ACCOUNT-NO              
              DISPLAY '* SPEC PROCESS CD:  ' WS-FW-SPEC-PROCESS-CD      
              DISPLAY '* PROGRAM ABORTING...                    *'      
              DISPLAY '********** PCSKR300  ABORT ***************'      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-CHECK-GUARANTEED-ACCT                                     *        
      ******************************************************************        
                                                                        
       7020-CHECK-GUARANTEED-ACCT.                                      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-GUARANTOR-EXISTS                               
                FROM CSS_GUARANTOR GU WITH(READUNCOMMITTED)                     
               WHERE GU.ACCOUNT_NO       = :GU-ACCOUNT-NO               
                 AND ((GU.GUAR_STATUS_CD = 'A') OR                      
                     (GU.GUAR_STATUS_CD  = 'C'  AND                     
                     GU.GUAR_STATUS_REASON = 'GUARANTOR BILLED.'))      
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-GUARANTOR-EXISTS                                       
MFA-TR*         FROM CSS_GUARANTOR GU                                           
MFA-TR*        WHERE GU.ACCOUNT_NO       = :GU-ACCOUNT-NO                       
MFA-TR*          AND ((GU.GUAR_STATUS_CD = 'A') OR                              
MFA-TR*              (GU.GUAR_STATUS_CD  = 'C'  AND                             
MFA-TR*              GU.GUAR_STATUS_REASON = 'GUARANTOR BILLED.'))              
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7020                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR300  ABORT ***************'      
              DISPLAY '* 7020-CHECK-GUARANTEED-ACCT             *'      
              DISPLAY '* SQLCODE IS        ' WS-DISPLAY-SQLCODE         
              DISPLAY '* ACCOUNT NO:       ' AT-ACCOUNT-NO              
              DISPLAY '* SPEC PROCESS CD:  ' WS-FW-SPEC-PROCESS-CD      
              DISPLAY '* PROGRAM ABORTING...                    *'      
              DISPLAY '********** PCSKR300  ABORT ***************'      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7040-GET-DUE-DATE                                                       
      ******************************************************************        
                                                                        
       7040-GET-DUE-DATE.                                               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) KD.FW_ACTION_DT                                    
                INTO :WS-FW-ACTION-DT                                   
                FROM CSS_FIN_WO_ACTION KD WITH(READUNCOMMITTED)                 
               WHERE KD.ACCOUNT_NO          = :KD-ACCOUNT-NO            
                 AND KD.FW_ACTION_DT        > IIF(TRY_CONVERT(DATE, 
                                                     :WS-PROCESSED-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PROCESSED-DATE
              ) <> 0) OR (LEN(:WS-PROCESSED-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-PROCESSED-DATE
              ), CONVERT(DATE, :WS-PROCESSED-DATE) )        
                 AND FW_BUS_PROCESS_CD IN ('FN', 'WO')                  
               ORDER BY KD.FW_ACTION_DT ASC                             
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT KD.FW_ACTION_DT                                            
MFA-TR*         INTO :WS-FW-ACTION-DT                                           
MFA-TR*         FROM CSS_FIN_WO_ACTION KD                                       
MFA-TR*        WHERE KD.ACCOUNT_NO          = :KD-ACCOUNT-NO                    
MFA-TR*          AND KD.FW_ACTION_DT        > :WS-PROCESSED-DATE                
MFA-TR*          AND FW_BUS_PROCESS_CD IN ('FN', 'WO')                          
MFA-TR*        ORDER BY KD.FW_ACTION_DT ASC                                     
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           EVALUATE SQLCODE                                             
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '********** PCSKR300  ABORT ***************'
                    DISPLAY '* 7040-GET-DUE-DATE                      *'
                    DISPLAY '* SQLCODE IS        ' WS-DISPLAY-SQLCODE   
                    DISPLAY '* ACCOUNT NO:       ' KD-ACCOUNT-NO        
                    DISPLAY '* PROGRAM ABORTING...                    *'
                    DISPLAY '********** PCSKR300  ABORT ***************'
                    PERFORM 9900-ABEND      THRU 9900-EXIT              
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-GET-NSF-DETAILS                                                    
      ******************************************************************        
                                                                        
       7050-GET-NSF-DETAILS.                                            
                                                                        
           EXEC SQL                                                     
              SELECT NSF_CHARGE_AMT                                     
                    ,RETURN_CHECK_AMT                                   
                    ,NSF_REASON_CD                                      
                    ,DRAWN_BY_NM                                        
                    ,DATE_TRAN                                          
                INTO                                                    
                     :NH-NSF-CHARGE-AMT                                 
                    ,:NH-RETURN-CHECK-AMT                               
                    ,:NH-NSF-REASON-CD                                  
                    ,:NH-DRAWN-BY-NM                                    
                    ,:NH-DATE-TRAN                                      
                FROM CSS_NSF_HIST WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO    = :NH-ACCOUNT-NO                     
                 AND NSF_TIMESTMP  = CIS.CHAR2TIMESTAMP(:NH-NSF-TIMESTMP
              )                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NSF_CHARGE_AMT                                             
MFA-TR*             ,RETURN_CHECK_AMT                                           
MFA-TR*             ,NSF_REASON_CD                                              
MFA-TR*             ,DRAWN_BY_NM                                                
MFA-TR*             ,DATE_TRAN                                                  
MFA-TR*         INTO                                                            
MFA-TR*              :NH-NSF-CHARGE-AMT                                         
MFA-TR*             ,:NH-RETURN-CHECK-AMT                                       
MFA-TR*             ,:NH-NSF-REASON-CD                                          
MFA-TR*             ,:NH-DRAWN-BY-NM                                            
MFA-TR*             ,:NH-DATE-TRAN                                              
MFA-TR*         FROM CSS_NSF_HIST                                               
MFA-TR*        WHERE ACCOUNT_NO    = :NH-ACCOUNT-NO                             
MFA-TR*          AND NSF_TIMESTMP  = :NH-NSF-TIMESTMP                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           EVALUATE SQLCODE                                             
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '********** PCSKR300  ABORT ***************'
                    DISPLAY '* 7050-GET-NSF-DETAILS                   *'
                    DISPLAY '* SQLCODE IS        ' WS-DISPLAY-SQLCODE   
                    DISPLAY '* ACCOUNT NO:       ' NH-ACCOUNT-NO        
                    DISPLAY '* NSF TIMESTAMP:    ' NH-NSF-TIMESTMP      
                    DISPLAY '* PROGRAM ABORTING...                    *'
                    DISPLAY '********** PCSKR300  ABORT ***************'
                    PERFORM 9900-ABEND      THRU 9900-EXIT              
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7060-SELECT-CREDIT-PROFILE                                      15074000
      ******************************************************************        
                                                                        
       7060-SELECT-CREDIT-PROFILE.                                      
                                                                        
           EXEC SQL                                                     
              SELECT CASH_ONLY_FL                                       
                INTO :CZ-CASH-ONLY-FL                                   
                FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                        
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15074400
MFA-TR*       SELECT CASH_ONLY_FL                                       15074500
MFA-TR*         INTO :CZ-CASH-ONLY-FL                                   15075200
MFA-TR*         FROM CSS_CREDIT_PROFILE                                 15075900
MFA-TR*        WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                        15076000
MFA-TR*      QUERYNO 7060                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    15076100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           EVALUATE SQLCODE                                             
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '********** PCSKR300  ABORT ***************'
                    DISPLAY '* 7060-SELECT-CREDIT-PROFILE             *'
                    DISPLAY '* SQLCODE IS        ' WS-DISPLAY-SQLCODE   
                    DISPLAY '* ACCOUNT NO:       ' CZ-ACCOUNT-NO        
                    DISPLAY '* PROGRAM ABORTING...                    *'
                    DISPLAY '********** PCSKR300  ABORT ***************'
                    PERFORM 9900-ABEND      THRU 9900-EXIT              
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0599A******************************************************************08494000
P0599A* 7070-SELECT-NSF-REASON                                         *        
P0599A******************************************************************08494000
P0599A                                                                  
P0599A 7070-SELECT-NSF-REASON.                                          
P0599A                                                                  
P0599A     EXEC SQL                                                     
P0599A        SELECT NSF_REASON_DESC                                    
P0599A          INTO :NR-NSF-REASON-DESC                                
P0599A          FROM CSS_NSF_REASON WITH(READUNCOMMITTED)                       
P0599A         WHERE COMPANY_NO    = '01'                               
P0599A           AND NSF_REASON_CD = :NR-NSF-REASON-CD                  
P0599A                                                           
P0599A                                                      
P0599A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NSF_REASON_DESC                                            
MFA-TR*         INTO :NR-NSF-REASON-DESC                                        
MFA-TR*         FROM CSS_NSF_REASON                                             
MFA-TR*        WHERE COMPANY_NO    = '01'                                       
MFA-TR*          AND NSF_REASON_CD = :NR-NSF-REASON-CD                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7070                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0599A                                                                  
P0599A     MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
P0599A                                                                  
P0599A     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
P0599A        CONTINUE                                                  
P0599A     ELSE                                                         
P0599A        DISPLAY '********** PCSKR300 ABORT **********************'
P0599A        DISPLAY '* ABEND IN 7070-SELECT-NSF-REASON              *'
P0599A        DISPLAY '* SQL RETURN CODE = ' WS-DISPLAY-SQLCODE         
P0599A        DISPLAY '* NSF_REASON_CD   = ' NR-NSF-REASON-CD           
P0599A        DISPLAY '* PROCESSING TERMINATED                        *'
P0599A        DISPLAY '********** PCSKR300 ABORT **********************'
P0599A        PERFORM 9900-ABEND            THRU 9900-EXIT              
P0599A     END-IF.                                                      
P0599A                                                                  
P0599A 7070-EXIT.                                                       
P0599A      EXIT.                                                       
P0599A                                                                  
P0599A******************************************************************08494000
P0599A* 7080-SELECT-GUAR-DTLS                                          *        
P0599A******************************************************************08494000
P0599A                                                                  
P0599A 7080-SELECT-GUAR-DTLS.                                           
P0599A                                                                  
P0599A     EXEC SQL                                                     
P0599A       SELECT   GU.ADDRESS_ID                                     
P0599A              ,AT.ADDRESS_ID                                      
P0599A              ,AT.ADDRESS_FORMAT                                  
P0599A          INTO :GU-ADDRESS-ID                                     
P0599A              ,:AT-ADDRESS-ID                                     
P0599A              ,:AT-ADDRESS-FORMAT                                 
P0599A       FROM CSS_GUARANTOR GU WITH(READUNCOMMITTED),                       
P0599A            CSS_ACCOUNT AT WITH(READUNCOMMITTED)                          
P0599A       WHERE GU.GUARNTR_ACCT_NO = :KD-GUARANTOR-ACCT-NO           
P0599A         AND GU.GUARNTR_ACCT_NO = AT.ACCOUNT_NO                   
P0599A         AND GU.ACCOUNT_NO      = :KD-ACCOUNT-NO                  
P0599A                                                           
P0599A                                                      
P0599A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT   GU.ADDRESS_ID                                             
MFA-TR*             ,AT.ADDRESS_ID                                              
MFA-TR*             ,AT.ADDRESS_FORMAT                                          
MFA-TR*         INTO :GU-ADDRESS-ID                                             
MFA-TR*             ,:AT-ADDRESS-ID                                             
MFA-TR*             ,:AT-ADDRESS-FORMAT                                         
MFA-TR*      FROM CSS_GUARANTOR GU,                                             
MFA-TR*           CSS_ACCOUNT AT                                                
MFA-TR*      WHERE GU.GUARNTR_ACCT_NO = :KD-GUARANTOR-ACCT-NO                   
MFA-TR*        AND GU.GUARNTR_ACCT_NO = AT.ACCOUNT_NO                           
MFA-TR*        AND GU.ACCOUNT_NO      = :KD-ACCOUNT-NO                          
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7080                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0599A                                                                  
P0599A     MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
P0599A                                                                  
P0599A     IF SQLCODE = SUCCESSFUL-CALL                                 
P0599A        CONTINUE                                                  
P0599A     ELSE                                                         
P0599A        DISPLAY '********** PCSKR300 ABORT **********************'
P0599A        DISPLAY '* ABEND IN 7080-SELECT-GUAR-DTLS               *'
P0599A        DISPLAY '* SQL RETURN CODE = ' WS-DISPLAY-SQLCODE         
P0599A        DISPLAY '* ACCOUNT_NO      = ' KD-ACCOUNT-NO              
P0599A        DISPLAY '* GUAR_ACCT_NO    = ' KD-GUARANTOR-ACCT-NO       
P0599A        DISPLAY '* PROCESSING TERMINATED                        *'
P0599A        DISPLAY '********** PCSKR300 ABORT **********************'
P0599A        PERFORM 9900-ABEND            THRU 9900-EXIT              
P0599A     END-IF.                                                      
P0599A                                                                  
P0599A 7080-EXIT.                                                       
P0599A      EXIT.                                                       
P0599A                                                                  
P0599A******************************************************************        
P0599A*  7100-OPEN-GUARANTOR                                           *        
P0599A*  CHECKS FOR ACTIVE GUARANTORS                                  *        
P0599A******************************************************************        
P0599A 7100-OPEN-GUARANTOR.                                             
P0599A*                                                                         
P0599A     EXEC SQL                                                     
P0599A        OPEN GUARANTOR_CURSOR                                     
P0599A     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0599A*                                                                         
P0599A     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0599A     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P0599A        NEXT SENTENCE                                             
P0599A     ELSE                                                         
P0599A        DISPLAY '********** PCSKR300 ABORT **********************'
P0599A        DISPLAY '** OPEN CURSOR                                 *'
P0599A        DISPLAY '** GUARANTOR, ACCOUNT TABLE                    *'
P0599A        DISPLAY '** ACCOUNT NO = ' GU-ACCOUNT-NO                  
P0599A        DISPLAY '** 7050 :  RETURN CODE ERROR - OPEN            *'
P0599A        DISPLAY '********** PCSKR300 ABORT **********************'
P0599A        PERFORM 9900-SQL-ERROR-ROUTINE                            
P0599A     END-IF.                                                      
P0599A*                                                                         
P0599A 7100-EXIT.                                                       
P0599A     EXIT.                                                        
P0599A*                                                                         
P0599A******************************************************************        
P0599A*  7110-FETCH-GUARANTOR                                          *        
P0599A*  CHECKS FOR ACTIVE GUARANTORS                                  *        
P0599A******************************************************************        
P0599A 7110-FETCH-GUARANTOR.                                            
P0599A*                                                                         
P0599A     EXEC SQL                                                     
P0599A        FETCH GUARANTOR_CURSOR INTO                               
P0599A          :GU-AMOUNT-GUARANTEED,                                  
P0599A          :GU-GUARNTR-ACCT-NO,                                    
P0599A          :GU-ADDRESS-ID,                                         
P0599A          :GU-GUAR-NOTICE-FLAG,                                   
P0599A          :AT-ADDRESS-ID,                                         
P0599A          :AT-ADDRESS-FORMAT                                      
P0599A     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0599A*                                                                         
P0599A     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0599A     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P0599A        NEXT SENTENCE                                             
P0599A     ELSE                                                         
P0599A        DISPLAY '********** PCSKR300 ABORT **********************'
P0599A        DISPLAY '** FETCH CURSOR                                *'
P0599A        DISPLAY '** GUARANTOR, ACCOUNT TABLE                    *'
P0599A        DISPLAY '** ACCOUNT NO = ' GU-ACCOUNT-NO                  
P0599A        DISPLAY '** 7110 : RETURN CODE ERROR - FETCH            *'
P0599A        DISPLAY '********** PCSKR300 ABORT **********************'
P0599A        PERFORM 9900-SQL-ERROR-ROUTINE                            
P0599A     END-IF.                                                      
P0599A*                                                                         
P0599A 7110-EXIT.                                                       
P0599A     EXIT.                                                        
P0599A*                                                                         
P0599A******************************************************************        
P0599A*  7120-CLOSE-GUARANTOR                                          *        
P0599A*  CHECKS FOR ACTIVE GUARANTORS                                  *        
P0599A******************************************************************        
P0599A 7120-CLOSE-GUARANTOR.                                            
P0599A*                                                                         
P0599A     EXEC SQL                                                     
P0599A        CLOSE GUARANTOR_CURSOR                                    
P0599A     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0599A*                                                                         
P0599A     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0599A     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P0599A        NEXT SENTENCE                                             
P0599A     ELSE                                                         
P0599A        DISPLAY '********** PCSKR300 ABORT **********************'
P0599A        DISPLAY '** CLOSE CURSOR                                *'
P0599A        DISPLAY '** GUARANTOR, ACCOUNT TABLE                    *'
P0599A        DISPLAY '** ACCOUNT NO = ' GU-ACCOUNT-NO                  
P0599A        DISPLAY '** 7120 :  RETURN CODE ERROR - CLOSE           *'
P0599A        DISPLAY '********** PCSKR300 ABORT **********************'
P0599A        PERFORM 9900-SQL-ERROR-ROUTINE                            
P0599A     END-IF.                                                      
P0599A*                                                                         
P0599A 7120-EXIT.                                                       
P0599A     EXIT.                                                        
P0599A*                                                                         
      ******************************************************************        
      * 7500-OPEN-FINAL-NOTICE-CSR                                    *         
      ******************************************************************        
                                                                        
       7500-OPEN-FINAL-NOTICE-CSR.                                      
                                                                        
           EXEC SQL                                                     
              OPEN FINAL-NOTICE-CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR300 ABORT **********************'
              DISPLAY '* ABEND IN 7500-OPEN-FINAL-NOTICE-CSR          *'
              DISPLAY '* FINAL-NOTICE-CSR ERROR                       *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR300 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7510-FETCH-FINAL-NOTICE-CSR                                    *        
      ******************************************************************        
                                                                        
       7510-FETCH-FINAL-NOTICE-CSR.                                     
                                                                        
           EXEC SQL                                                     
              FETCH FINAL-NOTICE-CSR                                    
               INTO :AT-COMPANY-NO                                      
                   ,:AT-ACCOUNT-NO                                      
                   ,:AT-CUSTOMER-NO                                     
                   ,:AT-TOTAL-AR-BALANCE                                
                   ,:AT-BANKRUPTCY-IND                                  
                   ,:AT-JUDGEMENT-CASE-NO                               
                   ,:AT-LAST-PYMT-DATE :WS-LAST-PYMT-DATE-NULL       
                   ,:AT-LAST-PYMT-AMOUNT                                
                   ,:AT-PREMISE-NO                                      
                   ,:AT-LOCAL-OFFICE                                    
                   ,:AT-ADDRESS-ID                                      
                   ,:AT-ADDRESS-FORMAT                                  
                   ,:AT-BILL-CYCLE                                      
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:AT-CREDIT-GROUP                                    
                   ,:FW-REG-GROUP-CD                                    
                   ,:FW-SENIOR-FL                                       
                   ,:FW-FW-PATH-TYPE-CD                                 
                   ,:FW-GUARANTEED-IND                                  
                   ,:KD-FW-SEQ-NO                                       
                   ,:KD-FW-ACTION-TYPE-CD                               
                   ,:KD-FW-ACTION-DT                                    
                   ,:KD-FW-ACTION-AM                                    
                   ,:KD-FW-PROCESSED-FL                                 
                   ,:KD-FW-ACTION-COMMENTS                              
                   ,:KD-GUARANTOR-ACCT-NO                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           EVALUATE SQLCODE                                             
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-LAST-PYMT-DATE-NULL < 0                       
                       MOVE SPACES          TO AT-LAST-PYMT-DATE        
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '********** PCSKR300 ABORT ***************' 
                    DISPLAY '* ABEND IN 7510-FETCH-FINAL-NOTICE-CSR  *' 
                    DISPLAY '* FINAL-NOTICE-CSR ERROR                *' 
                    DISPLAY '* SQL RETURN CODE   = 'WS-DISPLAY-SQLCODE  
                    DISPLAY '* NEXT BUSINESS DAY = 'WS-PROCESSED-DATE   
                    DISPLAY '* PROCESSING TERMINATED             *'     
                    DISPLAY '********** PCSKR300 ABORT ***************' 
                    PERFORM 9900-ABEND      THRU 9900-EXIT              
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7520-CLOSE-FINAL-NOTICE-CSR                                    *        
      ******************************************************************        
                                                                        
       7520-CLOSE-FINAL-NOTICE-CSR.                                     
                                                                        
           EXEC SQL                                                     
              CLOSE FINAL-NOTICE-CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR300 ABORT **********************'
              DISPLAY '* ABEND IN 7520-CLOSE-FINAL-NOTICE-CSR         *'
              DISPLAY '* FINAL-NOTICE-CSR ERROR                       *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR300 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************14951400
      * 7530-OPEN-FINAL-WO-ACTN                                        *14951500
      ******************************************************************14970000
                                                                        
       7530-OPEN-FINAL-WO-ACTN.                                         
                                                                        
           EXEC SQL                                                     
               OPEN FINAL-WO-ACTN                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '********** PCSKR300 ABORT **********************'
              DISPLAY '* ABEND IN 7530-OPEN-FINAL-WO-ACTN             *'
              DISPLAY '* FINAL-WO-ACTN ERROR                          *'
              DISPLAY '* SQL RETURN CODE    = ' WS-DISPLAY-SQLCODE      
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR300 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15190000
      * 7540-FETCH-FINAL-WO-ACTN                                       *15200000
      ******************************************************************15230000
                                                                        
       7540-FETCH-FINAL-WO-ACTN.                                        
                                                                        
           EXEC SQL                                                     
               FETCH FINAL-WO-ACTN                                      
                INTO :KD-FW-ACTION-DT                                   
                    ,:KD-FW-SEQ-NO                                      
                    ,:KD-FW-ACTION-TYPE-CD                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '********** PCSKR300 ABORT **********************'
              DISPLAY '* ABEND IN 7540-FETCH-FINAL-WO-ACTN            *'
              DISPLAY '* FINAL-WO-ACTN ERROR                          *'
              DISPLAY '* ACCOUNT NO         = ' KD-ACCOUNT-NO           
              DISPLAY '* SQL RETURN CODE    = ' WS-DISPLAY-SQLCODE      
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR300 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15600000
      * 7550-CLOSE-FINAL-WO-ACTN                                       *15610000
      ******************************************************************15640000
                                                                        
       7550-CLOSE-FINAL-WO-ACTN.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE FINAL-WO-ACTN                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '********** PCSKR300 ABORT **********************'
              DISPLAY '* ABEND IN 7550-CLOSE-FINAL-WO-ACTN            *'
              DISPLAY '* FINAL-WO-ACTN ERROR                          *'
              DISPLAY '* SQL RETURN CODE    = ' WS-DISPLAY-SQLCODE      
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR300 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7600-START-FCSJC01                                             *        
      * 7610-READ-FCSJC01                                              *        
      * 7611-CLOSE                                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7620-START-FCSCA00                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00039                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************15170000
      * 8500-UPDATE-PROCESSED-FL                                       *15180000
      ******************************************************************15190000
                                                                        
       8500-UPDATE-PROCESSED-FL.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_FIN_WO_ACTION                                  
                 SET FW_PROCESSED_FL     = 'Y'                          
               WHERE ACCOUNT_NO          = :AT-ACCOUNT-NO               
                 AND FW_SEQ_NO           = :KD-FW-SEQ-NO                
                 AND FW_ACTION_TYPE_CD   = :KD-FW-ACTION-TYPE-CD        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_FIN_WO_ACTION                                          
MFA-TR*          SET FW_PROCESSED_FL     = 'Y'                                  
MFA-TR*        WHERE ACCOUNT_NO          = :AT-ACCOUNT-NO                       
MFA-TR*          AND FW_SEQ_NO           = :KD-FW-SEQ-NO                        
MFA-TR*          AND FW_ACTION_TYPE_CD   = :KD-FW-ACTION-TYPE-CD                
MFA-TR*      QUERYNO 8500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                                                        
           EVALUATE SQLCODE                                             
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '********** PCSKR300 ABORT ****************'
                    DISPLAY '* 8500-UPDATE-PROCESSED-FL               *'
                    DISPLAY '* ACCOUNT NO       :' AT-ACCOUNT-NO        
                    DISPLAY '* FW SEQ NO        :' KD-FW-SEQ-NO         
                    DISPLAY '* FW ACTION TYPE CD:' KD-FW-ACTION-TYPE-CD 
                    DISPLAY '* SQLCODE          :' WS-DISPLAY-SQLCODE   
                    DISPLAY '* PROCESSING TERMINATED                  *'
                    DISPLAY '********** PCSKR300 ABORT ****************'
                    PERFORM 9900-ABEND      THRU 9900-EXIT              
           END-EVALUATE.                                                
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15170000
      * 8510-UPDATE-PROCESS-FL-ACTN-AM                                  15180000
      ******************************************************************15190000
                                                                        
       8510-UPDATE-PROCESS-FL-ACTN-AM.                                  
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_FIN_WO_ACTION                                  
                 SET FW_ACTION_AM        = :KD-FW-ACTION-AM             
                    ,FW_PROCESSED_FL     = 'Y'                          
               WHERE ACCOUNT_NO          = :KD-ACCOUNT-NO               
                 AND FW_SEQ_NO           = :KD-FW-SEQ-NO                
                 AND FW_ACTION_TYPE_CD   = :KD-FW-ACTION-TYPE-CD        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_FIN_WO_ACTION                                          
MFA-TR*          SET FW_ACTION_AM        = :KD-FW-ACTION-AM                     
MFA-TR*             ,FW_PROCESSED_FL     = 'Y'                                  
MFA-TR*        WHERE ACCOUNT_NO          = :KD-ACCOUNT-NO                       
MFA-TR*          AND FW_SEQ_NO           = :KD-FW-SEQ-NO                        
MFA-TR*          AND FW_ACTION_TYPE_CD   = :KD-FW-ACTION-TYPE-CD                
MFA-TR*      QUERYNO 8510                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                                                        
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN OTHER                                                
                   DISPLAY '********** PCSKR300 ABORT *****************'
                   DISPLAY '* 8510-UPDATE-PROCESS-FL-ACTN-AM          *'
                   DISPLAY '* ACCOUNT NO        :' AT-ACCOUNT-NO        
                   DISPLAY '* FW SEQ NO         :' KD-FW-SEQ-NO         
                   DISPLAY '* FW ACTION TYPE CD :' KD-FW-ACTION-TYPE-CD 
                   DISPLAY '* SQLCODE           :' WS-DISPLAY-SQLCODE   
                   DISPLAY '* PROCESSING TERMINATED                   *'
                   DISPLAY '********** PCSKR300 ABORT *****************'
                   PERFORM 9900-ABEND       THRU 9900-EXIT              
           END-EVALUATE.                                                
                                                                        
       8510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15170000
      * 8520-UPDATE-GUARANTEED-FL                                      *15180000
      ******************************************************************15190000
                                                                        
       8520-UPDATE-GUARANTEED-FL.                                       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_FINAL_WO                                       
                 SET GUARANTEED_IND      = ''                           
               WHERE ACCOUNT_NO          = :AT-ACCOUNT-NO               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_FINAL_WO                                               
MFA-TR*          SET GUARANTEED_IND      = ''                                   
MFA-TR*        WHERE ACCOUNT_NO          = :AT-ACCOUNT-NO                       
MFA-TR*      QUERYNO 8520                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                                                        
           EVALUATE SQLCODE                                             
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '********** PCSKR300 ABORT ****************'
                    DISPLAY '* 8520-UPDATE-GUARANTEED-FL              *'
                    DISPLAY '* ACCOUNT NO        : ' AT-ACCOUNT-NO      
                    DISPLAY '* SQLCODE           : ' WS-DISPLAY-SQLCODE 
                    DISPLAY '* PROCESSING TERMINATED                  *'
                    DISPLAY '********** PCSKR300 ABORT ****************'
                    PERFORM 9900-ABEND      THRU 9900-EXIT              
           END-EVALUATE.                                                
                                                                        
       8520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15170000
      * 8530-UPDATE-FIN-WO-DATES-ACTN                                  *15180000
      ******************************************************************15190000
                                                                        
       8530-UPDATE-FIN-WO-DATES-ACTN.                                   
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_FIN_WO_ACTION                                  
                 SET FW_ACTION_DT        = IIF(TRY_CONVERT(DATE, 
                                                       :KD-FW-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :KD-FW-ACTION-DT
              ) <> 0) OR (LEN(:KD-FW-ACTION-DT) <> 10), CIS.CHAR2DATE(
                                                       :KD-FW-ACTION-DT
              ), CONVERT(DATE, :KD-FW-ACTION-DT) )             
               WHERE ACCOUNT_NO          = :KD-ACCOUNT-NO               
                 AND FW_SEQ_NO           = :KD-FW-SEQ-NO                
                 AND FW_ACTION_TYPE_CD   = :KD-FW-ACTION-TYPE-CD        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_FIN_WO_ACTION                                          
MFA-TR*          SET FW_ACTION_DT        = :KD-FW-ACTION-DT                     
MFA-TR*        WHERE ACCOUNT_NO          = :KD-ACCOUNT-NO                       
MFA-TR*          AND FW_SEQ_NO           = :KD-FW-SEQ-NO                        
MFA-TR*          AND FW_ACTION_TYPE_CD   = :KD-FW-ACTION-TYPE-CD                
MFA-TR*      QUERYNO 8530                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                                                        
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
              WHEN NOT-FOUND                                            
                   CONTINUE                                             
              WHEN OTHER                                                
                   DISPLAY '********** PCSKR300 ABORT *****************'
                   DISPLAY '* 8530-UPDATE-FIN-WO-DATES-ACTN           *'
                   DISPLAY '* ACCOUNT NO        :' AT-ACCOUNT-NO        
                   DISPLAY '* FW SEQ NO         :' KD-FW-SEQ-NO         
                   DISPLAY '* FW ACTION TYPE CD :' KD-FW-ACTION-TYPE-CD 
                   DISPLAY '* SQLCODE           :' WS-DISPLAY-SQLCODE   
                   DISPLAY '* PROCESSING TERMINATED                   *'
                   DISPLAY '********** PCSKR300 ABORT *****************'
                   PERFORM 9900-ABEND       THRU 9900-EXIT              
           END-EVALUATE.                                                
                                                                        
       8530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15170000
      * 8540-UPDATE-NEW-ACTION-TYPE-CD                                  15180000
      ******************************************************************15190000
                                                                        
       8540-UPDATE-NEW-ACTION-TYPE-CD.                                  
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_FIN_WO_ACTION                                  
                 SET FW_ACTION_TYPE_CD   = :WS-NEW-ACTN-TYPE-CD         
               WHERE ACCOUNT_NO          = :KD-ACCOUNT-NO               
                 AND FW_SEQ_NO           = :KD-FW-SEQ-NO                
                 AND FW_ACTION_TYPE_CD   = :KD-FW-ACTION-TYPE-CD        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_FIN_WO_ACTION                                          
MFA-TR*          SET FW_ACTION_TYPE_CD   = :WS-NEW-ACTN-TYPE-CD                 
MFA-TR*        WHERE ACCOUNT_NO          = :KD-ACCOUNT-NO                       
MFA-TR*          AND FW_SEQ_NO           = :KD-FW-SEQ-NO                        
MFA-TR*          AND FW_ACTION_TYPE_CD   = :KD-FW-ACTION-TYPE-CD                
MFA-TR*      QUERYNO 8540                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND OR -531            
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR300 ABORT *****************'     
              DISPLAY '* 8540-UPDATE-NEW-ACTION-TYPE-CD        *'       
              DISPLAY '* ACCOUNT NO        :' KD-ACCOUNT-NO             
              DISPLAY '* FW SEQ NO         :' KD-FW-SEQ-NO              
              DISPLAY '* FW ACTION TYPE CD :' KD-FW-ACTION-TYPE-CD      
              DISPLAY '* SQLCODE           :' WS-DISPLAY-SQLCODE        
              DISPLAY '* PROCESSING TERMINATED                   *'     
              DISPLAY '********** PCSKR300 ABORT *****************'     
              PERFORM 9900-ABEND       THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       8540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15170000
      * 8700-INSERT-FIN-WO-ACTN                                        *15180000
      ******************************************************************15190000
                                                                        
       8700-INSERT-FIN-WO-ACTN.                                         
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_FIN_WO_ACTION                             
                  (ACCOUNT_NO                                           
                 ,FW_SEQ_NO                                             
                 ,FW_ACTION_TYPE_CD                                     
                 ,FW_ACTION_DT                                          
                 ,FW_ACTION_AM                                          
                 ,FW_MANUAL_FL                                          
                 ,FW_ACTION_COMMENTS                                    
                 ,FW_PROCESSED_FL                                       
                 ,FW_BUS_PROCESS_CD)                                    
              VALUES                                                    
                  (:KD-ACCOUNT-NO                                       
                 ,:KD-FW-SEQ-NO                                         
                 ,:WS-NEW-ACTN-TYPE-CD                                  
                 ,IIF(TRY_CONVERT(DATE, :KD-FW-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :KD-FW-ACTION-DT
              ) <> 0) OR (LEN(:KD-FW-ACTION-DT) <> 10), CIS.CHAR2DATE(
                                                       :KD-FW-ACTION-DT
              ), CONVERT(DATE, :KD-FW-ACTION-DT) )                             
                 ,:KD-FW-ACTION-AM                                      
                 ,:KD-FW-MANUAL-FL                                      
                 ,:KD-FW-ACTION-COMMENTS                                
                 ,:KD-FW-PROCESSED-FL                                   
                 ,:KD-FW-BUS-PROCESS-CD)                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_FIN_WO_ACTION                                     
MFA-TR*           (ACCOUNT_NO                                                   
MFA-TR*          ,FW_SEQ_NO                                                     
MFA-TR*          ,FW_ACTION_TYPE_CD                                             
MFA-TR*          ,FW_ACTION_DT                                                  
MFA-TR*          ,FW_ACTION_AM                                                  
MFA-TR*          ,FW_MANUAL_FL                                                  
MFA-TR*          ,FW_ACTION_COMMENTS                                            
MFA-TR*          ,FW_PROCESSED_FL                                               
MFA-TR*          ,FW_BUS_PROCESS_CD)                                            
MFA-TR*       VALUES                                                            
MFA-TR*           (:KD-ACCOUNT-NO                                               
MFA-TR*          ,:KD-FW-SEQ-NO                                                 
MFA-TR*          ,:WS-NEW-ACTN-TYPE-CD                                          
MFA-TR*          ,:KD-FW-ACTION-DT                                              
MFA-TR*          ,:KD-FW-ACTION-AM                                              
MFA-TR*          ,:KD-FW-MANUAL-FL                                              
MFA-TR*          ,:KD-FW-ACTION-COMMENTS                                        
MFA-TR*          ,:KD-FW-PROCESSED-FL                                           
MFA-TR*          ,:KD-FW-BUS-PROCESS-CD)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR300 ABORT **********************'
              DISPLAY '* 8700-INSERT-FIN-WO-ACTN                      *'
              DISPLAY '* ACCOUNT NO             :' KD-ACCOUNT-NO        
              DISPLAY '* FW SEQ NO              :' KD-FW-SEQ-NO         
              DISPLAY '* FW ACTION TYPE CD      :' KD-FW-ACTION-TYPE-CD 
              DISPLAY '* SQLCODE                :' WS-DISPLAY-SQLCODE   
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR300 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15160000
      ******************************************************************        
      * 8888-COMMIT.                                                   *        
      ******************************************************************        
                                                                        
       8888-COMMIT.                                                     
                                                                        
           ADD 1       TO WS-COMMITS-COUNT                              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
                                                                        
           MOVE ZEROES TO WS-RECS-TO-COMMIT-COUNT.                      
           DISPLAY '*************************************************'  
           DISPLAY '* COMMIT POINT # ' WS-COMMITS-COUNT  ' TAKEN.   *'  
           DISPLAY '* LAST REC PROCESSED  = ' AT-ACCOUNT-NO             
           DISPLAY '*************************************************'. 
                                                                        
       8888-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15170000
      * 8900-DELETE-FIN-WO-ACTN                                        *15180000
      ******************************************************************15190000
                                                                        
       8900-DELETE-FIN-WO-ACTN.                                         
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_FIN_WO_ACTION                             
               WHERE ACCOUNT_NO           =:KD-ACCOUNT-NO               
                 AND FW_ACTION_TYPE_CD    =:KD-FW-ACTION-TYPE-CD        
                 AND FW_SEQ_NO            =:KD-FW-SEQ-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR300 ABORT **********************'
              DISPLAY '* 8700-DELETE-FIN-WO-ACTN                      *'
              DISPLAY '* ACCOUNT NO            :' KD-ACCOUNT-NO         
              DISPLAY '* FW SEQ NO             :' KD-FW-SEQ-NO          
              DISPLAY '* FW ACTION TYPE CD     :' KD-FW-ACTION-TYPE-CD  
              DISPLAY '* SQLCODE               :' WS-DISPLAY-SQLCODE    
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR300 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8895-INSERT-WORK-QUEUE.                                        *        
      ******************************************************************        
                                                                        
ACT036 8895-INSERT-WORK-QUEUE.                                          
ACT036                                                                  
ACT036     CALL SCSCB077  USING   CWS00077-FIELDS,                      
ACT036                            ABEND-FILE,                           
ACT036                            RS-RETURN-CODE.                       
ACT036                                                                  
ACT036      MOVE RS-RETURN-CODE             TO WS-ACTIVE-RETURN-CODE    
ACT036                                                                  
ACT036      IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0        
ACT036         MOVE PROGRAM-NAME               TO   ABEND-PROGRAM       
ACT036         DISPLAY '8895-INSERT-WORK-QUEUE'                         
ACT036         DISPLAY 'CALL SCSCB077         '                         
ACT036         DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO              
ACT036         DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO              
ACT036         DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO           
ACT036         DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE         
ACT036         PERFORM 9900-ABEND    THRU 9900-EXIT                     
ACT036     END-IF.                                                      
                                                                        
       8895-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-TERMINATE.                                                *        
      ******************************************************************        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-PROCESS-ABEND.                                            *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************12620000
      * THIS ROUTINE IS NEEDED FOR CPD00067                            *12620000
      ******************************************************************12620000
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE,   
                                               RS-RETURN-CODE,          
                                               WS-DISPLAY-SQLCODE.      
           DISPLAY '********** PCSKR300 ABORT *************************'
           DISPLAY '* 9900-SQL-ERROR-ROUTINE                           '
           DISPLAY '* SQLCODE        = ' WS-DISPLAY-SQLCODE             
           DISPLAY '* ABEND RECORD 1 = ' ABEND-RECORD-1-DATA            
           DISPLAY '* ABEND RECORD 2 = ' ABEND-RECORD-2-DATA            
           DISPLAY '* ABEND RECORD 3 = ' ABEND-RECORD-3-DATA            
           DISPLAY '* PROCESSING TERMINATED                           *'
           DISPLAY '********** PCSKR300 ABORT *************************'
           PERFORM 9900-ABEND               THRU 9900-EXIT.             
                                                                        
      ******************************************************************        
      * 9900-ABEND.                                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
