       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSKR215.                                        
       DATE-WRITTEN.   FEB 2012.                                        
      ******************************************************************        
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **        
      **                                                              **        
      *********           CUSTOMER SERVICE SYSTEM              *********        
      *********                     DB2                        *********        
      **                                                              **        
      ******************************************************************        
      **--------------- P R O G R A M  S U M M A R Y -----------------**        
      *************************************************************** **        
      **   THIS PROGRAM WILL PROCESS ACCOUNTS FOR INTERACTIVE VOICE   **        
      **   RESPONSE (IVR) AND INSERTS INTO THE CSS_IVR_NOTICE TABLE.  **        
      ******************************************************************        
      **------------- PROGRAM  MODIFICATION  LOG -------------------- **        
      ******************************************************************        
      **      PCSKR215   PROGRAM  MODIFICATION  LOG                   **        
      **                                                              **        
      **   DATE        INITIALS  REASON                               **        
      **   __________  ________  ______________                       **        
P00599**   02/15/2012  RC41079   INITIAL PROGRAM VERSION.             **        
ACT090**   04/22/2015  MJ13662   ADDED WS-DATE-NOTICE-MAIL-NULL FOR   **        
      **                         NULL CHECK.                          **        
      **                         APPL5136                             **        
a05323**   07/15/2015  bd09555   Removed notice type 'N' - returned   **        
      **                         check - from cursor                  **        
A05323**   09/29/2015  MJ13662   FOR BILL IMMED DEP (ROW O) USE       **        
A05323**                         WS-AMT-00-DAY-DEP INSTEAD OF         **        
A05323**                         PAST-DUE-UTL.                        **        
      ******************************************************************        
      **----------------- BASIC SEQUENCE STRUCTURE -------------------**        
      *************************************************************** **        
      **         0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION **        
      **         1000 - 1999     INPUT PROCESSING CONTROL PATH        **        
      **         2000 - 2999     OUTPUT PROCESSING CONTROL PATH       **        
      **         3000 - 4999     BATCH PROCESSING MODULES - NOT USED  **        
      **         5000 - 5999     COMMON PROGRAM MODULES               **        
      **         6000 - 6999     COMMON SYSTEM MODULES                **        
      **         7000 - 7999     INPUT MODULES                        **        
      **         8000 - 8999     OUTPUT MODULES                       **        
      **         9000 - 9799     TERMINATION MODULES                  **        
      **         9900 - 9999     ABEND/ABORT MODULES                  **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSKR215'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)                      
           VALUE 'WORKING STORAGE FOR PCSKR215 STARTS HERE'.            
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME               PIC X(08)    VALUE 'PCSKR215'.
           05  WS-PGRMNAME                PIC X(08)    VALUE 'PCSKR215'.
           05  WS-N                       PIC X(01)    VALUE 'N'.       
           05  WS-Y                       PIC X(01)    VALUE 'Y'.       
           05  WS-F                       PIC X(01)    VALUE 'F'.       
           05  WS-O                       PIC X(01)    VALUE 'O'.       
           05  WS-IVR-PRESENT             PIC X(01)    VALUE 'N'.       
           05  SCSCB068                   PIC X(08)    VALUE 'SCSCB068'.
P00599     05  SCSCA151                   PIC X(08)    VALUE 'SCSCA151'.
      *                                                                         
P00599 01  WS-SWITCHES.                                                 
P00599     05  WS-PROCESS-ACCOUNT         PIC X(01)    VALUE 'Y'.       
P00599         88  PROCESS-ACCT                        VALUE 'Y'.       
P00599         88  SKIP-ACCT                           VALUE 'N'.       
           05  WS-DATABASE-KR215         PIC 9(01)     VALUE ZERO.      
               88  CSR-DATABASE                        VALUE 1.         
               88  SEB-DATABASE                        VALUE 2.         
           05  WS-MULTI-IVR-DNP-SW       PIC X(01)     VALUE 'Y'.       
               88  MULTI-IVR-DNP                       VALUE 'Y'.       
               88  NOT-MULTI-IVR-DNP                   VALUE 'N'.       
           05  WS-IVR-READY-SW           PIC X(01)     VALUE 'Y'.       
               88  IVR-READY                           VALUE 'Y'.       
               88  IVR-NOT-READY                       VALUE 'N'.       
           05  WS-FKR215-STATUS          PIC XX        VALUE '  '.      
               88 FKR215-SUCCESSFUL                    VALUE '00'.      
           05  WS-FST-TIME               PIC X(01)     VALUE 'Y'.       
      *                                                                         
       01  WS-MISC.                                                     
           05  RS-RETURN-CODE             PIC S9(04)   COMP VALUE 0.    
           05  S-RETURN-CODE              PIC S9(04)   COMP VALUE 0.    
           05  RS-RETURN-CODE-DISP        PIC S9(04)   COMP VALUE 0.    
           05  MULTIPLE-ROWS              PIC S9(9)    VALUE -811 COMP. 
COB305     05 WS-CURRENT-CHARGES        PIC S9(09)V99 COMP-3 VALUE 0.         
           05  WS-DATE-CRED-ACT-NULL      PIC S9(4)    COMP.            
           05  WS-DT-IVR-DT-ACTION-NULL   PIC S9(04)   COMP VALUE +0.   
           05  WS-SCHEDULED-DNP-DT-NULL   PIC S9(4)    COMP VALUE +0.   
ACT090     05  WS-DATE-NOTICE-MAIL-NULL   PIC S9(4)    COMP VALUE +0.   
           05  WS-HOLD-COMPANY            PIC X(02)    VALUE SPACES.    
           05  WS-DISPLAY-SQLCODE         PIC -ZZZZZZZZ9.               
           05  WS-NON-UTL-CR-HST          PIC X(24)    VALUE SPACES.    
           05  WS-NON-UTL-CR-HST-EX       PIC X(24)    VALUE SPACES.    
           05  WS-NEXT-BUSINESS-DAY       PIC X(10)    VALUE SPACES.    
P00599     05  WS-ACCOUNT-NO              PIC S9(13)V  COMP-3 VALUE 0.  
           05  WS-HOLD-NOTICE-TYPE        PIC X(01)    VALUE SPACE.     
COB305     05 WS-BALANCE-DUE        PIC S9(09)V99 COMP-3 VALUE 0.         
           05  WS-TIMESTAMP               PIC X(26)     VALUE SPACES.   
           05  WS-TRAN-APPL-NO            PIC S9(04)    COMP VALUE +0.  
      *                                                                         
       01  WS-COMMIT-VARS.                                              
           05  WS-COMMIT-COUNTER         PIC 9(04)     VALUE ZERO.      
           05  WS-RECS-TO-COMMIT-COUNTER PIC 9(04)     VALUE ZERO.      
           05  WS-READY-TO-COMMIT-COUNT  PIC S9(09) COMP VALUE +0.      
      *                                                                         
       01  WS-CUST-LAST-NAME.                                           
           05 WS-CUST-LNAME-4              PIC X(04)  VALUE SPACE.      
           05 WS-CUST-LNAME-16             PIC X(16)  VALUE SPACE.      
      *                                                                         
       01  WS-CUST-ADDRESS1.                                            
           05 WS-CUST-ADDRS-10             PIC X(10)  VALUE SPACES.     
           05 WS-CUST-ADDRS-36             PIC X(36)  VALUE SPACES.     
      *                                                                         
       01  WS-WORKQUEUE-COMMENTS.                                       
           05  WS-IVR-TRANS-HIST-CMNT.                                  
               10  FILLER               PIC X(40)                       
                   VALUE 'Multiple IVR DNP notification with same '.    
               10  FILLER               PIC X(39)                       
                   VALUE 'date. Duplicates were deleted. IVR DNP '.     
               10  FILLER               PIC X(41)                       
                   VALUE 'notification attempted for full past due '.   
               10  FILLER               PIC X(39)                       
                   VALUE 'amount. Account still eligible for DNP.'.     
           05  WS-DNP-TRANS-HIST-CMNT.                                  
               10  FILLER               PIC X(36)                       
                   VALUE 'IVR DNP notification not attempted. '.        
               10  FILLER               PIC X(39)                       
                   VALUE 'IVR date was same date as DNP date for '.     
               10  FILLER               PIC X(38)                       
                   VALUE 'another action. To minimize confusion '.      
               10  FILLER               PIC X(39)                       
                   VALUE 'over conflicting dates and amounts, no '.     
               10  FILLER               PIC X(39)                       
                   VALUE 'attempt was made. Account still eligibl'.     
               10  FILLER               PIC X(10)                       
                   VALUE 'e for DNP.'.                                  
      *                                                                         
      ******************************************************************        
      * CWS00010 CONTAINS DB2 ABEND VARIABLES                          *        
      ******************************************************************        
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
      ******************************************************************        
      * WS-ABEND-SWITCH                                                *        
      ******************************************************************        
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
      ******************************************************************        
      * CWS00039 JOB PARM ROUTINE                                      *        
      ******************************************************************        
      *                                                                         
       COPY CWS00039.                                                           
      *                                                                         
P00599******************************************************************        
P00599* VARIABLES NEEDED FOR ACCOUNT SKIP PROCESSING.                  *        
P00599******************************************************************        
P00599*                                                                         
P00599 COPY CWSCA151.                                                           
P00599*                                                                         
      ******************************************************************        
      * FIOJC01 WORKING STORAGE                                        *        
      ******************************************************************        
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      ******************************************************************        
      * FCA00-KEY                                                      *        
      ******************************************************************        
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR CODES-DATA-PRESENT                         *        
      ******************************************************************        
      *                                                                         
       COPY CWS00056.                                                           
      *                                                                         
      ******************************************************************        
      * CWS00303 JOB PARM ROUTINE CONTAINS WS-WARNING-DATA-ELEMENTS    *        
      ******************************************************************        
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSKR215 ENDS HERE  '.            
      *                                                                         
      ******************************************************************        
      * DB2 COMMUNICATION REQUIREMENT                                  *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CWS00038 JOB PARM ROUTINE                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
       01  WS-INSERT-ROW-COUNT REDEFINES WS-INPUT-DATA-BREAKDOWN.       
           10  WS-PARM-COMMIT-ROW-COUNT-TXT PIC X(09).                  
               88 COMMIT-ROW-CNT         VALUE 'COMMIT = '.             
           10  WS-NO-OF-ROWS-TO-COMMIT   PIC X(05).                     
           10  FILLER                    PIC X(66).                     
      *                                                                         
      *****************************************************************         
      * CWS00068 CONTAINS WS FOR CALC OF ARREARS, DISCONNECT AMT,     *         
      * PASTE DUE, AND NUMEROUS DATES.                                *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CWS00322 CONTAINS WS FOR FINDING NEXT BUSINESS DAY            *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00322                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ACCOUNT        - AT                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ADDR_FORMATTED - DY                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_BUSINESS_DAYS  - 1G                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBUSDAY                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CRED_COLL - CL                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCRCOLL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CREDIT_PROFILE - CZ                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCRPROF                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CUSTOMER       - CU                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_DELINQUENCY    - C8                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_FINAL_WO - FW                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBFINLWO                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_JOB_PARM       - G6                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_IVR_NOTICE     - IY                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBIVRNOT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MNT_TRANS_HIST - MH                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MT_TRN_HST_DET - MI                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_NAME        - DQ                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_PREMISE     - PR                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_REG_PROFILE - LR                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_UTIL_ENVRNMT   - UT                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CURSOR DECLARATION                                             *        
      ******************************************************************        
      *****************************************                                 
      * IVR_CSR                                                                 
      *****************************************                                 
           EXEC SQL                                                     
               DECLARE IVR_CSR CURSOR WITH HOLD FOR                     
               SELECT  AT.CUSTOMER_NO,                                  
                       AT.ACCOUNT_NO,                                   
                       AT.PREMISE_NO,                                   
                       AT.COMPANY_NO,                                   
                       AT.LOCAL_OFFICE,                                 
                       AT.DATE_BILL_DAY_00,                             
                       AT.DATE_BILL_DAY_30,                             
                       AT.DATE_BILL_DAY_60,                             
                       AT.DATE_BILL_DAY_90,                             
                       AT.BILL_CYCLE,                                   
                       AT.TOTAL_AR_BALANCE,                             
                       AT.CODES_DATA_PRESENT,                           
                       AT.CODE_ACCT_STAT,                               
                       AT.CREDIT_GROUP,                                 
                       AT.ACCOUNT_TYPE_CODE,                            
                       AT.CODE_STATUS_REASON,                           
                       AT.NOTICE_EXEMPT_CD,                             
                       AT.IVR_EXEMPT_CD,                                
                       AT.CODE_DISC_OK,                                 
                       AT.BANKRUPTCY_IND,                               
                       CL.DATE_CREDIT_ACTION,                           
                       CL.CODE_NOTICE_TYPE,                             
                       CL.ITEM_ID                                       
               FROM    CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                      ,CSS_CRED_COLL CL WITH(READUNCOMMITTED)                   
               WHERE   AT.ACCOUNT_NO         = CL.ACCOUNT_NO            
                 AND   AT.CODE_ACCT_STAT    IN ('A','P')                
                 AND   CL.DATE_CREDIT_ACTION = IIF(TRY_CONVERT(DATE, 
                                                  :WS-NEXT-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEXT-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEXT-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEXT-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEXT-BUSINESS-DAY) )    
A05323           AND   CL.CODE_NOTICE_TYPE  IN ('C','F','O')            
                 AND   CL.PROCESSED_CD      IN (' ', 'N')               
               ORDER BY AT.ACCOUNT_NO, CL.CODE_NOTICE_TYPE DESC         
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE IVR_CSR CURSOR WITH HOLD FOR                             
MFA-TR*        SELECT  AT.CUSTOMER_NO,                                          
MFA-TR*                AT.ACCOUNT_NO,                                           
MFA-TR*                AT.PREMISE_NO,                                           
MFA-TR*                AT.COMPANY_NO,                                           
MFA-TR*                AT.LOCAL_OFFICE,                                         
MFA-TR*                AT.DATE_BILL_DAY_00,                                     
MFA-TR*                AT.DATE_BILL_DAY_30,                                     
MFA-TR*                AT.DATE_BILL_DAY_60,                                     
MFA-TR*                AT.DATE_BILL_DAY_90,                                     
MFA-TR*                AT.BILL_CYCLE,                                           
MFA-TR*                AT.TOTAL_AR_BALANCE,                                     
MFA-TR*                AT.CODES_DATA_PRESENT,                                   
MFA-TR*                AT.CODE_ACCT_STAT,                                       
MFA-TR*                AT.CREDIT_GROUP,                                         
MFA-TR*                AT.ACCOUNT_TYPE_CODE,                                    
MFA-TR*                AT.CODE_STATUS_REASON,                                   
MFA-TR*                AT.NOTICE_EXEMPT_CD,                                     
MFA-TR*                AT.IVR_EXEMPT_CD,                                        
MFA-TR*                AT.CODE_DISC_OK,                                         
MFA-TR*                AT.BANKRUPTCY_IND,                                       
MFA-TR*                CL.DATE_CREDIT_ACTION,                                   
MFA-TR*                CL.CODE_NOTICE_TYPE,                                     
MFA-TR*                CL.ITEM_ID                                               
MFA-TR*        FROM    CSS_ACCOUNT AT                                           
MFA-TR*               ,CSS_CRED_COLL CL                                         
MFA-TR*        WHERE   AT.ACCOUNT_NO         = CL.ACCOUNT_NO                    
MFA-TR*          AND   AT.CODE_ACCT_STAT    IN ('A','P')                        
MFA-TR*          AND   CL.DATE_CREDIT_ACTION = :WS-NEXT-BUSINESS-DAY            
MFA-TR*          AND   CL.CODE_NOTICE_TYPE  IN ('C','F','O')                    
MFA-TR*          AND   CL.PROCESSED_CD      IN (' ', 'N')                       
MFA-TR*        ORDER BY AT.ACCOUNT_NO, CL.CODE_NOTICE_TYPE DESC                 
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*      QUERYNO 7210                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS MAIN PROCESSING OF PROGRAM                            *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION                THRU 0100-EXIT.   
      *                                                                         
P00599     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
P00599        MOVE AT-ACCOUNT-NO         TO WS-ACCOUNT-NO               
P00599        PERFORM 5200-CHK-SKIP-ACCTS      THRU 5200-CPD347-EXIT    
P00599                                                                  
P00599        IF PROCESS-ACCT                                           
                IF AT-ACCOUNT-TYPE-CODE = 'R'                           
P00599            PERFORM 1200-IVR-PROCESS          THRU 1200-EXIT      
                ELSE                                                    
                  MOVE AT-ACCOUNT-NO TO CL-ACCOUNT-NO                   
                  MOVE SPACES        TO CL-DATE-CREDIT-ACTION           
                  PERFORM 8530-UPDATE-CRED-COLL     THRU 8530-EXIT      
                END-IF                                                  
P00599        END-IF                                                    
              PERFORM 7210-FETCH-CRED-COLL      THRU 7210-EXIT          
P00599     END-PERFORM.                                                 
      *                                                                         
           PERFORM 7220-CLOSE-CRED-COLL             THRU 7220-EXIT.     
           PERFORM 9000-TERMINATE                   THRU 9000-EXIT.     
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZATION.                                           *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           PERFORM 0110-GET-JOB-PARM-DATE                THRU 0110-EXIT.
      *                                                                         
           PERFORM 0120-GET-DATABASE                     THRU 0120-EXIT.
           PERFORM 7200-OPEN-CRED-COLL                   THRU 7200-EXIT.
           PERFORM 7210-FETCH-CRED-COLL                  THRU 7210-EXIT.
           MOVE ZEROS                TO CL-ACCOUNT-NO.                  
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0110-GET-JOB-PARM-DATE                                         *        
      ******************************************************************        
      *                                                                         
       0110-GET-JOB-PARM-DATE.                                          
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE              THRU 6251-EXIT.     
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE   THRU 6240-EXIT      
               MOVE WS-FCA00-COMMON-DATE    TO WS-INPUT-DATE            
           END-IF.                                                      
      *                                                                         
           MOVE WS-INPUT-DATE               TO WS-NEW-BUSINESS-DAY      
                                               WS-HOLD-DATE.            
      *                                                                         
           PERFORM 0115-GET-COMMIT-ROW-COUNT        THRU 0115-EXIT.     
      *                                                                         
           PERFORM 6500-GET-NEXT-BUSINESS-DAY                           
                                       THRU 6500-NEXT-BUSINESS-DAY-EXIT.
           MOVE WS-NEW-BUSINESS-DAY         TO WS-NEXT-BUSINESS-DAY.    
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0115-GET-COMMIT-ROW-COUNT.                                     *        
      * GET THE COMMIT ROW COUNT FROM JOB PARM TABLE                   *        
      ******************************************************************        
       0115-GET-COMMIT-ROW-COUNT.                                       
      *                                                                         
           MOVE  WS-PGRMNAME               TO WS-PROGRAM.               
           MOVE  WS-PARM                   TO WS-COMMAND.               
           MOVE  ZEROS                     TO WS-SEQUENCE.              
           MOVE  SPACES                    TO WS-SYSIPT.                
           MOVE  WS-KEY-AREA               TO E-FJC01-KEY.              
      *                                                                         
           PERFORM 7600-START-FCSJC01      THRU  7600-EXIT.             
           PERFORM 7610-READ-FCSJC01       THRU  7610-EXIT              
              UNTIL (COMMIT-ROW-CNT AND INPUT-ACTIVE)                   
              OR  END-OF-SYSIPT.                                        
      *                                                                         
           IF END-OF-SYSIPT                                             
              DISPLAY '************PCSKR215******************'          
              DISPLAY '** ' WS-PGRMNAME ' PROCESSING WARNING  **'       
              DISPLAY '**  COMMIT-ROW-CNT PARM NOT ACTIVE     **'       
              DISPLAY '**  DEFAULT OF 1000 WILL BE USED  **'            
              DISPLAY '**  PROCESSING CONTINUING        **'             
              DISPLAY '************PCSKR215******************'          
              MOVE 1000 TO WS-READY-TO-COMMIT-COUNT                     
           ELSE                                                         
              IF WS-NO-OF-ROWS-TO-COMMIT NUMERIC                        
                 MOVE WS-NO-OF-ROWS-TO-COMMIT                           
                                         TO WS-READY-TO-COMMIT-COUNT    
              ELSE                                                      
                 DISPLAY '************PCSKR215******************'       
                 DISPLAY '**  ' WS-PGRMNAME ' PROCESSING WARNING  **'   
                 DISPLAY '**  COMMIT-ROW-CNT PARM NOT NUMERIC  **'      
                 DISPLAY '**  DEFAULT OF 1000 WILL BE USED  **'         
                 DISPLAY '**  PROCESSING CONTINUING        **'          
                 DISPLAY '************PCSKR215******************'       
                 MOVE 1000 TO WS-READY-TO-COMMIT-COUNT                  
              END-IF                                                    
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           END-IF.                                                      
      *                                                                         
       0115-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0120-GET-DATABASE.                                             *        
      ******************************************************************        
      *                                                                         
       0120-GET-DATABASE.                                               
      *                                                                         
           MOVE 'DATABASE'                TO C8-DELINQ-CD.              
           MOVE '01'                      TO C8-COMPANY-NO.             
           PERFORM 7010-SELECT-DELINQ-VALUE              THRU 7010-EXIT.
           MOVE C8-DELINQ-VALUE           TO WS-DATABASE-KR215.         
      *                                                                         
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0200-PREPARE-PRECOMMIT.                                        *        
      * MOVE ALL THE REQUIRED RESTART RECORD VALUES PRIOR TO UPDATE    *        
      ******************************************************************        
      *                                                                         
       0200-PREPARE-COMMIT.                                             
      *                                                                         
      * ISSUE COMMIT IF THE COUNTER REACHED TO THE LIMIT                        
           ADD 1                       TO WS-COMMIT-COUNTER.            
           PERFORM 8890-COMMIT                   THRU 8890-EXIT.        
           MOVE ZEROS                  TO WS-RECS-TO-COMMIT-COUNTER.    
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   1200-IVR-PROCESS                                             *        
      ******************************************************************        
      *                                                                         
       1200-IVR-PROCESS.                                                
      *                                                                         
           INITIALIZE IY-SCHEDULED-DNP-DT                               
                      WS-SCHEDULED-DNP-DT-NULL                          
ACT090                WS-DATE-NOTICE-MAIL-NULL                          
                      WS-DT-IVR-DT-ACTION-NULL.                         
      *                                                                         
           IF AT-ACCOUNT-NO = CL-ACCOUNT-NO                             
             PERFORM 1300-MULTI-IVR THRU 1300-EXIT                      
             GO TO 1200-EXIT                                            
           END-IF.                                                      
      *                                                                         
           MOVE AT-CODES-DATA-PRESENT       TO WS-CODES-DATA-PRESENT.   
      *                                                                         
           MOVE WS-NEXT-BUSINESS-DAY        TO WS-CL-DATE-NOTICE-DUE    
                                               WS-CL-DATE-NOTICE-MAIL   
                                               WS-CL-DATE-CREDIT-ACTION.
      *                                                                         
           MOVE 'N'                         TO WS-IVR-READY-SW.         
      *                                                                         
           PERFORM 3200-CALC-AMOUNTS-DATES          THRU 3200-EXIT.     
      *                                                                         
           MOVE AT-ACCOUNT-NO               TO CL-ACCOUNT-NO.           
      *                                                                         
           EVALUATE WS-NEXT-BUSINESS-DAY                                
             WHEN WS-DATE-CREDIT-ACTION-O                               
               MOVE 'Y'                     TO WS-IVR-READY-SW          
               MOVE WS-O                    TO CL-CODE-NOTICE-TYPE      
               MOVE WS-ITEM-ID-O            TO CL-ITEM-ID               
               MOVE WS-DATE-NOTICE-MAIL-O   TO CL-DATE-NOTICE-MAIL      
               MOVE WS-DATE-NOTICE-DUE-O    TO CL-DATE-NOTICE-DUE       
               MOVE WS-DATE-CREDIT-ACTION-O TO CL-DATE-CREDIT-ACTION    
A05323         MOVE WS-AMT-00-DAY-DEP       TO CL-AMT-NOTICE            
               MOVE WS-AMT-NOTICE-O         TO WS-BALANCE-DUE           
               MOVE WS-CODE-SPECIAL-TYPE-O  TO CL-CODE-SPECIAL-TYPE     
               MOVE WS-CODE-MESSAGE-TYPE-O  TO CL-CODE-MESSAGE-TYPE     
               IF WS-DATE-CREDIT-ACTION-I  > SPACES  AND                
                  WS-DATE-CREDIT-ACTION-I  > WS-NEXT-BUSINESS-DAY       
                 MOVE WS-DATE-CREDIT-ACTION-I  TO IY-SCHEDULED-DNP-DT   
               END-IF                                                   
                                                                        
             WHEN WS-DATE-CREDIT-ACTION-N                               
               MOVE 'Y'                     TO WS-IVR-READY-SW          
               MOVE WS-N                    TO CL-CODE-NOTICE-TYPE      
               MOVE WS-ITEM-ID-N            TO CL-ITEM-ID               
               MOVE WS-DATE-NOTICE-MAIL-N   TO CL-DATE-NOTICE-MAIL      
               MOVE WS-DATE-NOTICE-DUE-N    TO CL-DATE-NOTICE-DUE       
               MOVE WS-DATE-CREDIT-ACTION-N TO CL-DATE-CREDIT-ACTION    
               MOVE WS-AMT-PAST-DUE-UTL     TO CL-AMT-NOTICE            
               MOVE WS-AMT-NOTICE-N         TO WS-BALANCE-DUE           
               MOVE WS-CODE-SPECIAL-TYPE-N  TO CL-CODE-SPECIAL-TYPE     
               MOVE WS-CODE-MESSAGE-TYPE-N  TO CL-CODE-MESSAGE-TYPE     
               IF WS-DATE-CREDIT-ACTION-H > SPACES AND                  
                  WS-DATE-CREDIT-ACTION-H > WS-NEXT-BUSINESS-DAY        
                 MOVE WS-DATE-CREDIT-ACTION-H TO IY-SCHEDULED-DNP-DT    
               END-IF                                                   
                                                                        
             WHEN WS-DATE-CREDIT-ACTION-F                               
               MOVE 'Y'                     TO WS-IVR-READY-SW          
               MOVE WS-F                    TO CL-CODE-NOTICE-TYPE      
               MOVE WS-ITEM-ID-F            TO CL-ITEM-ID               
               MOVE WS-DATE-NOTICE-MAIL-F   TO CL-DATE-NOTICE-MAIL      
               MOVE WS-DATE-NOTICE-DUE-F    TO CL-DATE-NOTICE-DUE       
               MOVE WS-DATE-CREDIT-ACTION-F TO CL-DATE-CREDIT-ACTION    
               MOVE WS-AMT-PAST-DUE-UTL     TO CL-AMT-NOTICE            
               MOVE WS-AMT-NOTICE-F         TO WS-BALANCE-DUE           
               MOVE WS-CODE-SPECIAL-TYPE-F  TO CL-CODE-SPECIAL-TYPE     
               MOVE WS-CODE-MESSAGE-TYPE-F  TO CL-CODE-MESSAGE-TYPE     
               IF WS-DATE-CREDIT-ACTION-G > SPACES AND                  
                  WS-DATE-CREDIT-ACTION-G > WS-NEXT-BUSINESS-DAY        
                 MOVE WS-DATE-CREDIT-ACTION-G TO IY-SCHEDULED-DNP-DT    
               END-IF                                                   
                                                                        
             WHEN WS-DATE-CREDIT-ACTION-C                               
               MOVE 'Y'                     TO WS-IVR-READY-SW          
               MOVE WS-C                    TO CL-CODE-NOTICE-TYPE      
               MOVE WS-ITEM-ID-C            TO CL-ITEM-ID               
               MOVE WS-AMT-PAST-DUE-UTL     TO CL-AMT-NOTICE            
               MOVE WS-DATE-NOTICE-MAIL-C   TO CL-DATE-NOTICE-MAIL      
               MOVE WS-DATE-NOTICE-DUE-C    TO CL-DATE-NOTICE-DUE       
               MOVE WS-AMT-NOTICE-C         TO WS-BALANCE-DUE           
               MOVE WS-DATE-CREDIT-ACTION-C TO CL-DATE-CREDIT-ACTION    
               MOVE WS-CODE-SPECIAL-TYPE-C  TO CL-CODE-SPECIAL-TYPE     
               MOVE WS-CODE-MESSAGE-TYPE-C  TO CL-CODE-MESSAGE-TYPE     
               IF WS-DATE-CREDIT-ACTION-D > SPACES AND                  
                  WS-DATE-CREDIT-ACTION-D > WS-NEXT-BUSINESS-DAY        
                 MOVE WS-DATE-CREDIT-ACTION-D TO IY-SCHEDULED-DNP-DT    
               END-IF                                                   
           END-EVALUATE.                                                
      *                                                                         
      ** IVR CALL WILL BE MADE AND DATE RESIDES IN DATE-CREDIT-ACTION.          
      ** IF BALANCE DUE IS NOT > 0 THEN IVR CALL WILL NOT BE                    
      ** GENERATED.                                                             
      *                                                                         
           PERFORM 1210-EDIT-IVR           THRU 1210-EXIT.              
      *                                                                         
           IF IVR-READY                                                 
             PERFORM 1220-MOVE-IVR-DATA    THRU 1220-EXIT               
           ELSE                                                         
             MOVE SPACES            TO CL-DATE-CREDIT-ACTION            
           END-IF.                                                      
      *                                                                         
           PERFORM 8530-UPDATE-CRED-COLL THRU 8530-EXIT.                
      *                                                                         
           ADD 1                      TO WS-RECS-TO-COMMIT-COUNTER.     
           IF WS-RECS-TO-COMMIT-COUNTER > WS-READY-TO-COMMIT-COUNT      
             PERFORM 0200-PREPARE-COMMIT     THRU 0200-EXIT             
           END-IF.                                                      
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  1210-EDIT-IVR                                               **        
      ******************************************************************        
      *                                                                         
       1210-EDIT-IVR.                                                   
      *                                                                         
A05323      IF CL-CODE-NOTICE-TYPE = 'O'                                
A05323         IF WS-AMT-00-DAY-DEP <= 0                                
A05323            MOVE 'N' TO WS-IVR-READY-SW                           
A05323         ELSE                                                     
A05323            CONTINUE                                              
A0523          END-IF                                                   
A05323      ELSE                                                        
               IF WS-AMT-PAST-DUE-UTL <= 0                              
                  MOVE 'N' TO WS-IVR-READY-SW                           
               END-IF                                                   
A05323      END-IF.                                                     
      *                                                                         
            IF IVR-READY                                                
               PERFORM 1305-MULTI-IVR-DNP   THRU 1305-EXIT              
            END-IF.                                                     
      *                                                                         
       1210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  1220-MOVE-IVR-DATA                                          **        
      ******************************************************************        
      *                                                                         
       1220-MOVE-IVR-DATA.                                              
      *                                                                         
           INITIALIZE WS-CUST-ADDRESS1                                  
                      WS-CUST-LAST-NAME                                 
                      IY-CUST-NAME-CD                                   
                      IY-PREM-ADDR-CD.                                  
           PERFORM 1280-MOVE-CUST-NAME   THRU 1280-EXIT                 
           PERFORM 1240-MOVE-CUST-ADDR   THRU 1240-EXIT                 
           MOVE ' '                         TO IY-CALL-STATUS-CD.       
           MOVE CL-CODE-SPECIAL-TYPE        TO IY-CODE-SPECIAL-TYPE.    
           MOVE CL-DATE-NOTICE-MAIL         TO IY-DATE-NOTICE-MAIL.     
           MOVE CL-DATE-NOTICE-DUE          TO IY-NOTICE-DUE-DT.        
           MOVE SPACES                      TO IY-DATE-CREDIT-ACTION.   
           MOVE -1                          TO WS-DT-IVR-DT-ACTION-NULL.
           MOVE CL-DATE-CREDIT-ACTION       TO IY-ORIGINAL-CALL-DT.     
           MOVE CL-AMT-NOTICE               TO IY-CURR-PAST-DUE-BAL     
                                               IY-ORIG-PAST-DUE-BAL.    
           MOVE AT-ACCOUNT-NO               TO IY-ACCOUNT-NO.           
           MOVE AT-CUSTOMER-NO              TO IY-CUSTOMER-NO.          
           MOVE AT-COMPANY-NO               TO IY-COMPANY-NO.           
           MOVE WS-CUST-ADDRS-10            TO IY-PREM-ADDR-CD.         
           MOVE WS-CUST-LNAME-4             TO IY-CUST-NAME-CD.         
           IF IY-SCHEDULED-DNP-DT = SPACES OR                           
              IY-SCHEDULED-DNP-DT = LOW-VALUES                          
             MOVE -1              TO WS-SCHEDULED-DNP-DT-NULL           
           END-IF.                                                      
ACT090     IF IY-DATE-NOTICE-MAIL = SPACES OR                           
ACT090        IY-DATE-NOTICE-MAIL = LOW-VALUES                          
ACT090       MOVE -1              TO WS-DATE-NOTICE-MAIL-NULL           
ACT090     END-IF.                                                      
      *                                                                         
           PERFORM 8620-INSERT-IVR       THRU 8620-EXIT.                
      *                                                                         
       1220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  1240-MOVE-CUST-ADDR.                                        **        
      ******************************************************************        
      *                                                                         
       1240-MOVE-CUST-ADDR.                                             
      *                                                                         
           MOVE AT-PREMISE-NO        TO PR-PREMISE-NO.                  
           PERFORM 7085-SELECT-PREM-ADDR THRU 7085-EXIT.                
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
             PERFORM 1260-CONFIG-ADDR    THRU 1260-EXIT                 
           ELSE                                                         
             MOVE SPACES             TO WS-CUST-ADDRESS1                
           END-IF.                                                      
      *                                                                         
       1240-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** 1260-CONFIG-ADDR                                             **        
      ******************************************************************        
      *                                                                         
       1260-CONFIG-ADDR.                                                
      *                                                                         
           IF DY-HOUSE-NO > ' '                                         
             MOVE DY-HOUSE-NO          TO WS-CUST-ADDRESS1              
           END-IF.                                                      
                                                                        
           IF DY-ADDR-PREFIX-1 > ' ' AND WS-CUST-ADDRESS1 > ' '         
             STRING WS-CUST-ADDRESS1    DELIMITED BY '  '               
                    ' '                 DELIMITED BY SIZE               
                    DY-ADDR-PREFIX-1    DELIMITED BY ' '                
                                  INTO WS-CUST-ADDRESS1                 
           ELSE                                                         
             IF DY-ADDR-PREFIX-1 > ' '                                  
               MOVE DY-ADDR-PREFIX-1   TO WS-CUST-ADDRESS1              
             END-IF                                                     
           END-IF.                                                      
           IF DY-ADDR-PREFIX-2 > ' ' AND WS-CUST-ADDRESS1 > ' '         
             STRING WS-CUST-ADDRESS1     DELIMITED BY '  '              
                    ' '                  DELIMITED BY SIZE              
                    DY-ADDR-PREFIX-2     DELIMITED BY ' '               
                                  INTO WS-CUST-ADDRESS1                 
           ELSE                                                         
             IF DY-ADDR-PREFIX-2 > ' '                                  
               MOVE DY-ADDR-PREFIX-2   TO WS-CUST-ADDRESS1              
             END-IF                                                     
           END-IF.                                                      
           IF DY-STREET-NAME > ' ' AND WS-CUST-ADDRESS1 > ' '           
             STRING WS-CUST-ADDRESS1     DELIMITED BY '  '              
                    ' '                  DELIMITED BY SIZE              
                    DY-STREET-NAME       DELIMITED BY '  '              
                                  INTO WS-CUST-ADDRESS1                 
           ELSE                                                         
             IF DY-STREET-NAME > ' '                                    
               MOVE DY-STREET-NAME     TO WS-CUST-ADDRESS1              
             END-IF                                                     
           END-IF.                                                      
           IF DY-STREET-SUFFIX > ' ' AND WS-CUST-ADDRESS1 > ' '         
             STRING WS-CUST-ADDRESS1     DELIMITED BY '  '              
                    ' '                  DELIMITED BY SIZE              
                    DY-STREET-SUFFIX     DELIMITED BY ' '               
                                  INTO WS-CUST-ADDRESS1                 
           ELSE                                                         
             IF DY-STREET-SUFFIX > ' '                                  
               MOVE DY-STREET-SUFFIX   TO WS-CUST-ADDRESS1              
             END-IF                                                     
           END-IF.                                                      
           IF DY-STREET-LOCATION-1 > ' ' AND WS-CUST-ADDRESS1 > ' '     
             STRING WS-CUST-ADDRESS1       DELIMITED BY '  '            
                    ' '                    DELIMITED BY SIZE            
                    DY-STREET-LOCATION-1   DELIMITED BY ' '             
                                    INTO WS-CUST-ADDRESS1               
           ELSE                                                         
             IF DY-STREET-LOCATION-1 > ' '                              
               MOVE DY-STREET-LOCATION-1   TO WS-CUST-ADDRESS1          
             END-IF                                                     
           END-IF.                                                      
           IF DY-STREET-LOCATION-2 > ' ' AND WS-CUST-ADDRESS1 > ' '     
             STRING WS-CUST-ADDRESS1       DELIMITED BY '  '            
                    ' '                    DELIMITED BY SIZE            
                    DY-STREET-LOCATION-2   DELIMITED BY ' '             
                                    INTO WS-CUST-ADDRESS1               
           ELSE                                                         
             IF DY-STREET-LOCATION-2 > ' '                              
                MOVE DY-STREET-LOCATION-2   TO WS-CUST-ADDRESS1         
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       1260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  1280-MOVE-CUST-NAME.                                        **        
      ******************************************************************        
      *                                                                         
       1280-MOVE-CUST-NAME.                                             
      *                                                                         
           MOVE AT-CUSTOMER-NO           TO CU-CUSTOMER-NO.             
           PERFORM 7080-SELECT-CUST-NAME  THRU 7080-EXIT.               
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
             MOVE DQ-LAST-NAME           TO WS-CUST-LAST-NAME           
           ELSE                                                         
             MOVE SPACES                 TO WS-CUST-LAST-NAME           
           END-IF.                                                      
      *                                                                         
       1280-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1300-MULTI-IVR                                                 *        
      ******************************************************************        
      *                                                                         
       1300-MULTI-IVR.                                                  
      *                                                                         
           INITIALIZE WS-TRAN-APPL-NO.                                  
           MOVE WS-IVR-TRANS-HIST-CMNT      TO MH-TRAN-COMMENT-TEXT.    
           PERFORM 5525-MAINT-TRANS-HIST       THRU 5525-EXIT           
           PERFORM 5550-MOVE-IVR-DETAILS       THRU 5550-EXIT           
           MOVE 'N'              TO WS-IVR-READY-SW                     
           MOVE SPACES           TO CL-DATE-CREDIT-ACTION               
           PERFORM 8530-UPDATE-CRED-COLL       THRU 8530-EXIT.          
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1305-MULTI-IVR-DNP                                             *        
      ******************************************************************        
      *                                                                         
       1305-MULTI-IVR-DNP.                                              
      *                                                                         
           MOVE 'N'                 TO WS-MULTI-IVR-DNP-SW.             
           MOVE CL-CODE-NOTICE-TYPE TO WS-HOLD-NOTICE-TYPE.             
           PERFORM 7090-SELECT-MULTI-IVR-DNP   THRU 7090-EXIT.          
           IF MULTI-IVR-DNP                                             
             INITIALIZE WS-TRAN-APPL-NO                                 
             MOVE WS-DNP-TRANS-HIST-CMNT      TO MH-TRAN-COMMENT-TEXT   
             PERFORM 5525-MAINT-TRANS-HIST       THRU 5525-EXIT         
             PERFORM 5550-MOVE-IVR-DETAILS       THRU 5550-EXIT         
             MOVE SPACES            TO CL-DATE-CREDIT-ACTION            
             PERFORM 8530-UPDATE-CRED-COLL       THRU 8530-EXIT         
             MOVE 'N'               TO WS-IVR-READY-SW                  
           END-IF.                                                      
      *                                                                         
       1305-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3200-CALC-AMOUNTS-DATES                                        *        
      * PERFORM ROUTINE THAT CALCULATES DNP-BAL, ARREARS, PAST DUE     *        
      * ETC, AND MOVE VALUES TO CWS10007 FOR USE BY OTHER PROGRAMS     *        
      ******************************************************************        
      *                                                                         
       3200-CALC-AMOUNTS-DATES.                                         
      *                                                                         
      *SET CPD00068 SWITCHES THAT ARE NEEDED                                    
           MOVE 'Y'         TO CALC-ARREARS-SW                          
                               CALC-BALANCE-SW                          
                               CALC-PAST-DUE-SW                         
                               LOAD-DNP-DATE-SW                         
                               LOAD-DUE-DATES-SW                        
                               LOAD-WS-AMOUNTS-SW.                      
      *                                                                         
           INITIALIZE          WS-DATE-CREDIT-ACTION-C                  
                               WS-DATE-CREDIT-ACTION-F                  
                               WS-DATE-CREDIT-ACTION-N                  
                               WS-DATE-CREDIT-ACTION-O                  
                               WS-AMT-NOTICE-C                          
                               WS-AMT-NOTICE-F                          
                               WS-AMT-NOTICE-N                          
                               WS-AMT-NOTICE-O.                         
      *                                                                         
           MOVE 'PCSCA132'  TO WS-CPD00068-CALLING-PGM.                 
      *                                                                         
           MOVE SPACES      TO ABEND-FUNCTION.                          
           CALL SCSCB068  USING  CWS00068-FIELDS,                       
                                 WS-CODES-DATA-PRESENT,                 
                                 DCLCSS-ACCOUNT,                        
                                 ABEND-FILE,                            
                                 RS-RETURN-CODE.                        
           MOVE 'PCSKR215'              TO PROGRAM-NAME.                
           IF  ABEND-FUNCTION  > SPACES                                 
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00599******************************************************************        
P00599* 5200-CHK-SKIP-ACCTS                                      *              
P00599******************************************************************        
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE CPD00347                                                 
P00599     END-EXEC.                                                            
P00599*                                                                         
      *****************************************************************         
      * 5525-MAINT-TRANS-HIST.                                        *         
      *****************************************************************         
      *                                                                         
       5525-MAINT-TRANS-HIST.                                           
      *                                                                         
           PERFORM 7000-GET-TIMESTAMP            THRU 7000-EXIT.        
           MOVE WS-TIMESTAMP                   TO MH-TRANS-HIST-SEQ-NO  
           MOVE WS-INPUT-DATE                  TO MH-DATE-TRANS         
           MOVE 'F'                            TO MH-CODE-TRAN-TYPE.    
           MOVE SPACES                         TO MH-RESP-AREA-ID.      
           MOVE AT-ACCOUNT-NO                  TO MH-ACCOUNT-NO.        
           MOVE ZEROS                          TO MH-CUSTOMER-NO        
                                                 MH-PREMISE-NO.         
           MOVE 'SYSTEM'                       TO MH-USER-ID.           
           MOVE 'PCSKR215'                     TO MH-APPL-PROGRAM-ID.   
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT TO MH-TRAN-COMMENT-LEN.  
      *                                                                         
       5525-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  5550-MOVE-IVR-DETAILS                                         *        
      ******************************************************************        
      *                                                                         
       5550-MOVE-IVR-DETAILS.                                           
      *                                                                         
           ADD 1                        TO WS-TRAN-APPL-NO.             
           MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
           MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
           MOVE SPACES                  TO MI-TABLE-ID.                 
           MOVE +11                     TO MI-CHG-COLUMN-VALUE-LEN.     
           MOVE +10                     TO MI-PRV-COLUMN-VALUE-LEN.     
           MOVE '**DELETED**'           TO MI-CHG-COLUMN-VALUE-TEXT.    
           MOVE CL-DATE-CREDIT-ACTION   TO MI-PRV-COLUMN-VALUE-TEXT.    
           MOVE 'IVR DATE'              TO MI-COLUMN-DESC.              
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                        TO WS-TRAN-APPL-NO              
           MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
           MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
           MOVE SPACES                  TO MI-TABLE-ID.                 
           MOVE +11                     TO MI-CHG-COLUMN-VALUE-LEN.     
           MOVE +14                     TO MI-PRV-COLUMN-VALUE-LEN.     
           MOVE '**DELETED**'           TO MI-CHG-COLUMN-VALUE-TEXT.    
           EVALUATE CL-CODE-NOTICE-TYPE                                 
             WHEN 'C'                                                   
                MOVE 'NORMAL'           TO MI-PRV-COLUMN-VALUE-TEXT     
             WHEN 'F'                                                   
                MOVE 'EXCEPTIONAL'      TO MI-PRV-COLUMN-VALUE-TEXT     
             WHEN 'N'                                                   
                MOVE 'RETURNED CHECK'   TO MI-PRV-COLUMN-VALUE-TEXT     
             WHEN 'O'                                                   
                MOVE 'DEPOSIT'          TO MI-PRV-COLUMN-VALUE-TEXT     
           END-EVALUATE.                                                
           MOVE 'IVR TYPE'              TO MI-COLUMN-DESC.              
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
      *                                                                         
       5550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6240-GET-FCA00-COMMON-DATE                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00040                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00037                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    6500-GET-NEXT-BUSINESS-DAY                                **         
      *    COPYBOOK CPD00322 CONTAINS THE LOGIC FOR FINDING          **         
      *    THE NEXT AND PREVIOUS BUSINESS DAY.                       **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00322                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST                                       *        
      * 6540-INSERT-MNT-TRANS-HIST                                     *        
      * 6550-INSERT-MT-TRN-HST-DET                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00067                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7000-GET-TIMESTAMP.                                            *        
      * GET TIMESTAMP FOR MNT_TRANS_HIST FILE                          *        
      ******************************************************************        
      *                                                                         
       7000-GET-TIMESTAMP.                                              
      *                                                                         
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTAMP                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET: WS-TIMESTAMP = CURRENT TIMESTAMP                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             WS-DISPLAY-SQLCODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             NEXT SENTENCE                                              
           ELSE                                                         
              DISPLAY '********** PCSKR210 ABORT **********************'
              DISPLAY ' 7000-GET-TIMESTAMP '                            
              DISPLAY ' RETURN CODE      = ' WS-DISPLAY-SQLCODE         
              DISPLAY ' PROCESSING TERMINATED                         *'
              DISPLAY '********** PCSKR210 ABORT **********************'
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010-SELECT-DELINQ-VALUE                                       *        
      ******************************************************************        
      *                                                                         
       7010-SELECT-DELINQ-VALUE.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD    = :C8-DELINQ-CD                       
                 AND COMPANY_NO   = :C8-COMPANY-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD    = :C8-DELINQ-CD                               
MFA-TR*          AND COMPANY_NO   = :C8-COMPANY-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             WS-DISPLAY-SQLCODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '********** PCSKR215  ABORT ********************'
               DISPLAY '* 7010-SELECT-DELINQ-VALUE                    *'
               DISPLAY '* SQLCODE IS   ' WS-DISPLAY-SQLCODE             
               DISPLAY '* DELINQ_CD  : ' C8-DELINQ-CD                   
               DISPLAY '* COMPANY_NO : ' C8-COMPANY-NO                  
               DISPLAY '* PROGRAM ABORTING...                         *'
               DISPLAY '********** PCSKR215  ABORT ********************'
               PERFORM 9900-ABEND                   THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   7040-CHECK-REGULATED                                         *        
      ******************************************************************        
      *                                                                         
       7040-CHECK-FOR-REGULATED.                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT REG_GROUP_CD                                      
                     ,SENIOR_FL                                         
                 INTO :LR-REG-GROUP-CD                                  
                     ,:LR-SENIOR-FL                                     
                 FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REG_GROUP_CD                                              
MFA-TR*              ,SENIOR_FL                                                 
MFA-TR*          INTO :LR-REG-GROUP-CD                                          
MFA-TR*              ,:LR-SENIOR-FL                                             
MFA-TR*          FROM CSS_REG_PROFILE                                           
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        QUERYNO 7040                                                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             NEXT SENTENCE                                              
           ELSE                                                         
               DISPLAY '***************PCSKR215*******************'     
               DISPLAY '** CSS_REG_PROFILE                        '     
               DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                 
               DISPLAY '** 7040 : RETURN CODE ERROR - SELECT      '     
               DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE            
               DISPLAY '***************PCSKR215*******************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7080-SELECT-CUST-NAME.                                                
      ******************************************************************        
       7080-SELECT-CUST-NAME.                                           
      *                                                                         
           EXEC SQL                                                     
             SELECT  DQ.LAST_NAME                                       
               INTO :DQ-LAST-NAME                                       
             FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED)                         
                 ,CSS_NAME DQ WITH(READUNCOMMITTED)                             
             WHERE CU.CUSTOMER_NO = :CU-CUSTOMER-NO                     
               AND DQ.NAME_ID = CU.NAME_ID                              
               AND DQ.NAME_TYPE = 'CN'                                  
               AND DQ.NAME_FORMAT = 'I'                                 
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  DQ.LAST_NAME                                               
MFA-TR*        INTO :DQ-LAST-NAME                                               
MFA-TR*      FROM CSS_CUSTOMER CU                                               
MFA-TR*          ,CSS_NAME DQ                                                   
MFA-TR*      WHERE CU.CUSTOMER_NO = :CU-CUSTOMER-NO                             
MFA-TR*        AND DQ.NAME_ID = CU.NAME_ID                                      
MFA-TR*        AND DQ.NAME_TYPE = 'CN'                                          
MFA-TR*        AND DQ.NAME_FORMAT = 'I'                                         
MFA-TR*        QUERYNO 7080                                                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***************PCSKR215*******************'      
              DISPLAY '** CSS_CUSTOMER CSS_NAME TABLES          '       
              DISPLAY '** ACCOUNT NO  = ' AT-ACCOUNT-NO                 
              DISPLAY '** CUSTOMER NO = ' CU-CUSTOMER-NO                
              DISPLAY '** 7080 :  RETURN CODE ERROR              '      
              DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE             
              DISPLAY '***************PCSKR215*******************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7080-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7085-SELECT-PREM-ADDR.                                      **        
      **                                                              **        
      ******************************************************************        
       7085-SELECT-PREM-ADDR.                                           
      *                                                                         
           EXEC SQL                                                     
           SELECT DY.HOUSE_NO                                           
                 ,DY.ADDR_PREFIX_1                                      
                 ,DY.ADDR_PREFIX_2                                      
                 ,DY.STREET_NAME                                        
                 ,DY.STREET_SUFFIX                                      
                 ,DY.STREET_LOCATION_1                                  
                 ,DY.STREET_LOCATION_2                                  
            INTO :DY-HOUSE-NO                                           
                ,:DY-ADDR-PREFIX-1                                      
                ,:DY-ADDR-PREFIX-2                                      
                ,:DY-STREET-NAME                                        
                ,:DY-STREET-SUFFIX                                      
                ,:DY-STREET-LOCATION-1                                  
                ,:DY-STREET-LOCATION-2                                  
            FROM CSS_PREMISE PR WITH(READUNCOMMITTED)                           
                ,CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)                    
           WHERE PR.PREMISE_NO = :PR-PREMISE-NO                         
             AND DY.ADDRESS_ID = PR.ADDRESS_ID                          
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*    SELECT DY.HOUSE_NO                                                   
MFA-TR*          ,DY.ADDR_PREFIX_1                                              
MFA-TR*          ,DY.ADDR_PREFIX_2                                              
MFA-TR*          ,DY.STREET_NAME                                                
MFA-TR*          ,DY.STREET_SUFFIX                                              
MFA-TR*          ,DY.STREET_LOCATION_1                                          
MFA-TR*          ,DY.STREET_LOCATION_2                                          
MFA-TR*     INTO :DY-HOUSE-NO                                                   
MFA-TR*         ,:DY-ADDR-PREFIX-1                                              
MFA-TR*         ,:DY-ADDR-PREFIX-2                                              
MFA-TR*         ,:DY-STREET-NAME                                                
MFA-TR*         ,:DY-STREET-SUFFIX                                              
MFA-TR*         ,:DY-STREET-LOCATION-1                                          
MFA-TR*         ,:DY-STREET-LOCATION-2                                          
MFA-TR*     FROM CSS_PREMISE PR                                                 
MFA-TR*         ,CSS_ADDR_FORMATTED DY                                          
MFA-TR*    WHERE PR.PREMISE_NO = :PR-PREMISE-NO                                 
MFA-TR*      AND DY.ADDRESS_ID = PR.ADDRESS_ID                                  
MFA-TR*      QUERYNO 7085                                                       
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*****************PCSKR215*****************'      
              DISPLAY '** CSS_PREMISE CSS_ADDR_FORMATTED TABLES '       
              DISPLAY '** ACCOUNT NO  = ' AT-ACCOUNT-NO                 
              DISPLAY '** PREMISE NO  = ' PR-PREMISE-NO                 
              DISPLAY '** 7085 :  RETURN CODE ERROR              '      
              DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE             
              DISPLAY '*****************PCSKR215*****************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7085-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7090-SELECT-MULTI-IVR-DNP                                             
      ******************************************************************        
      *                                                                         
       7090-SELECT-MULTI-IVR-DNP.                                       
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) 'Y'                                                
               INTO :WS-MULTI-IVR-DNP-SW                                
             FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                           
             WHERE ACCOUNT_NO = :CL-ACCOUNT-NO                          
               AND DATE_CREDIT_ACTION = IIF(TRY_CONVERT(DATE, 
                                                  :WS-NEXT-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEXT-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEXT-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEXT-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEXT-BUSINESS-DAY) )           
               AND CODE_NOTICE_TYPE IN ('D', 'G', 'H', 'I')             
               AND CODE_NOTICE_TYPE <> :WS-HOLD-NOTICE-TYPE             
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  'Y'                                                        
MFA-TR*        INTO :WS-MULTI-IVR-DNP-SW                                        
MFA-TR*      FROM CSS_CRED_COLL                                                 
MFA-TR*      WHERE ACCOUNT_NO = :CL-ACCOUNT-NO                                  
MFA-TR*        AND DATE_CREDIT_ACTION = :WS-NEXT-BUSINESS-DAY                   
MFA-TR*        AND CODE_NOTICE_TYPE IN ('D', 'G', 'H', 'I')                     
MFA-TR*        AND CODE_NOTICE_TYPE <> :WS-HOLD-NOTICE-TYPE                     
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***************PCSKR215*******************'      
              DISPLAY '** CSS_CRED_COLL TABLE                   '       
              DISPLAY '** ACCOUNT NO  = ' CL-ACCOUNT-NO                 
              DISPLAY '** CODE NOTICE TYPE = ' CL-CODE-NOTICE-TYPE      
              DISPLAY '** 7090 :  RETURN CODE ERROR - SELECT     '      
              DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE             
              DISPLAY '***************PCSKR215*******************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7090-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7200-OPEN-CRED-COLL                                       **          
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **          
      **      IVR_CSR CURSOR                                        **          
      ****************************************************************          
       7200-OPEN-CRED-COLL.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN IVR_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*************PCSKR215*********************'     
               DISPLAY '** 7200 :  RETURN CODE ERROR - OPEN '           
               DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE            
               DISPLAY '*************PCSKR215*********************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7210-FETCH-CRED-COLL                                      **          
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **          
      **      IVR_CSR CURSOR                                        **          
      ****************************************************************          
       7210-FETCH-CRED-COLL.                                            
      *                                                                         
           EXEC SQL                                                     
               FETCH IVR_CSR INTO                                       
                   :AT-CUSTOMER-NO,                                     
                   :AT-ACCOUNT-NO,                                      
                   :AT-PREMISE-NO,                                      
                   :AT-COMPANY-NO,                                      
                   :AT-LOCAL-OFFICE,                                    
                   :AT-DATE-BILL-DAY-00,                                
                   :AT-DATE-BILL-DAY-30,                                
                   :AT-DATE-BILL-DAY-60,                                
                   :AT-DATE-BILL-DAY-90,                                
                   :AT-BILL-CYCLE,                                      
                   :AT-TOTAL-AR-BALANCE,                                
                   :AT-CODES-DATA-PRESENT,                              
                   :AT-CODE-ACCT-STAT,                                  
                   :AT-CREDIT-GROUP,                                    
                   :AT-ACCOUNT-TYPE-CODE,                               
                   :AT-CODE-STATUS-REASON,                              
                   :AT-NOTICE-EXEMPT-CD,                                
                   :AT-IVR-EXEMPT-CD,                                   
                   :AT-CODE-DISC-OK,                                    
                   :AT-BANKRUPTCY-IND,                                  
                   :CL-DATE-CREDIT-ACTION :WS-DATE-CRED-ACT-NULL,       
                   :CL-CODE-NOTICE-TYPE,                                
                   :CL-ITEM-ID                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               IF WS-DATE-CRED-ACT-NULL < 0                             
                   MOVE SPACES         TO CL-DATE-CREDIT-ACTION         
               END-IF                                                   
           ELSE                                                         
               DISPLAY '***************PCSKR215*******************'     
               DISPLAY '** 7210 :  RETURN CODE ERROR - FETCH'           
               DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE            
               DISPLAY '***************PCSKR215*******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7220-CLOSE-CRED-COLL                                      **          
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **          
      **      IVR_CSR CURSOR                                        **          
      ****************************************************************          
       7220-CLOSE-CRED-COLL.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE IVR_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '****************PCSKR215******************'     
               DISPLAY '** 7220 :  RETURN CODE ERROR - CLOSE'           
               DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE            
               DISPLAY '****************PCSKR215******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7600-START-FCSJC01                                             *        
      * 7610-READ-FCSJC01                                              *        
      * 7611-CLOSE                                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7620-START-FCSCA00                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00039                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 8530-UPDATE-CRED-COLL                                          *        
      ******************************************************************        
      *                                                                         
       8530-UPDATE-CRED-COLL.                                           
      *                                                                         
           IF CL-DATE-CREDIT-ACTION = SPACES                            
             MOVE -1            TO WS-DATE-CRED-ACT-NULL                
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_CRED_COLL                                       
                SET DATE_CREDIT_ACTION = IIF(TRY_CONVERT(DATE, 
                                                :CL-DATE-CREDIT-ACTION 
                                                 :WS-DATE-CRED-ACT-NULL
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-CREDIT-ACTION 
                                                 :WS-DATE-CRED-ACT-NULL
              ) <> 0) OR (LEN(:CL-DATE-CREDIT-ACTION 
                                                 :WS-DATE-CRED-ACT-NULL
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-CREDIT-ACTION 
                                                 :WS-DATE-CRED-ACT-NULL
              ), CONVERT(DATE, :CL-DATE-CREDIT-ACTION 
                                                 :WS-DATE-CRED-ACT-NULL
              ) ),        
                    PROCESSED_CD       = 'I'                            
               WHERE ACCOUNT_NO       = :CL-ACCOUNT-NO                  
                AND  ITEM_ID          = :CL-ITEM-ID                     
                AND  CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_CRED_COLL                                               
MFA-TR*         SET DATE_CREDIT_ACTION = :CL-DATE-CREDIT-ACTION:                
MFA-TR*                                   WS-DATE-CRED-ACT-NULL,                
MFA-TR*             PROCESSED_CD       = 'I'                                    
MFA-TR*        WHERE ACCOUNT_NO       = :CL-ACCOUNT-NO                          
MFA-TR*         AND  ITEM_ID          = :CL-ITEM-ID                             
MFA-TR*         AND  CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '****************PCSKR215******************'      
              DISPLAY '** CRED_COLL TABLE                   '           
              DISPLAY '** ACCOUNT NO = ' CL-ACCOUNT-NO                  
              DISPLAY '** CODE NOTICE TYPE = ' CL-CODE-NOTICE-TYPE      
              DISPLAY '** AMT NOTICE = ' CL-AMT-NOTICE                  
              DISPLAY '** 8530 :  RETURN CODE ERROR - UPDATE'           
              DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE             
              DISPLAY '****************PCSKR215******************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8620-INSERT-IVR                                                *        
      ******************************************************************        
      *                                                                         
       8620-INSERT-IVR.                                                 
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO CSS_IVR_NOTICE                                 
               (ACCOUNT_NO,                                             
                ORIGINAL_CALL_DT,                                       
                CALL_STATUS_CD,                                         
                CODE_SPECIAL_TYPE,                                      
                CURR_PAST_DUE_BAL,                                      
                CUSTOMER_NO,                                            
                DATE_CREDIT_ACTION,                                     
                DATE_NOTICE_MAIL,                                       
                NOTICE_DUE_DT,                                          
                ORIG_PAST_DUE_BAL,                                      
                COMPANY_NO,                                             
                CREATED_TS,                                             
                CUST_NAME_CD,                                           
                PREM_ADDR_CD,                                           
                SCHEDULED_DNP_DT)                                       
             VALUES                                                     
               (:IY-ACCOUNT-NO,                                         
                IIF(TRY_CONVERT(DATE, :IY-ORIGINAL-CALL-DT
              ) IS NULL OR (PATINDEX('%.%', :IY-ORIGINAL-CALL-DT
              ) <> 0) OR (LEN(:IY-ORIGINAL-CALL-DT
              ) <> 10), CIS.CHAR2DATE(:IY-ORIGINAL-CALL-DT
              ), CONVERT(DATE, :IY-ORIGINAL-CALL-DT) ),                        
                :IY-CALL-STATUS-CD,                                     
                :IY-CODE-SPECIAL-TYPE,                                  
                :IY-CURR-PAST-DUE-BAL,                                  
                :IY-CUSTOMER-NO,                                        
                IIF(TRY_CONVERT(DATE, :IY-DATE-CREDIT-ACTION 
                                      :WS-DT-IVR-DT-ACTION-NULL
              ) IS NULL OR (PATINDEX('%.%', :IY-DATE-CREDIT-ACTION 
                                              :WS-DT-IVR-DT-ACTION-NULL
              ) <> 0) OR (LEN(:IY-DATE-CREDIT-ACTION 
                                              :WS-DT-IVR-DT-ACTION-NULL
              ) <> 10), CIS.CHAR2DATE(:IY-DATE-CREDIT-ACTION 
                                              :WS-DT-IVR-DT-ACTION-NULL
              ), CONVERT(DATE, :IY-DATE-CREDIT-ACTION 
                                              :WS-DT-IVR-DT-ACTION-NULL
              ) ),        
ACT090          IIF(TRY_CONVERT(DATE, :IY-DATE-NOTICE-MAIL 
                                      :WS-DATE-NOTICE-MAIL-NULL
              ) IS NULL OR (PATINDEX('%.%', :IY-DATE-NOTICE-MAIL 
                                              :WS-DATE-NOTICE-MAIL-NULL
              ) <> 0) OR (LEN(:IY-DATE-NOTICE-MAIL 
                                              :WS-DATE-NOTICE-MAIL-NULL
              ) <> 10), CIS.CHAR2DATE(:IY-DATE-NOTICE-MAIL 
                                              :WS-DATE-NOTICE-MAIL-NULL
              ), CONVERT(DATE, :IY-DATE-NOTICE-MAIL 
                                              :WS-DATE-NOTICE-MAIL-NULL
              ) ),          
                IIF(TRY_CONVERT(DATE, :IY-NOTICE-DUE-DT
              ) IS NULL OR (PATINDEX('%.%', :IY-NOTICE-DUE-DT
              ) <> 0) OR (LEN(:IY-NOTICE-DUE-DT) <> 10), CIS.CHAR2DATE(
                                                      :IY-NOTICE-DUE-DT
              ), CONVERT(DATE, :IY-NOTICE-DUE-DT) ),                           
                :IY-ORIG-PAST-DUE-BAL,                                  
                :IY-COMPANY-NO,                                         
                CIS.CURRENT$TIMESTAMP(),                                      
                :IY-CUST-NAME-CD,                                       
                :IY-PREM-ADDR-CD,                                       
                IIF(TRY_CONVERT(DATE, :IY-SCHEDULED-DNP-DT 
                                      :WS-SCHEDULED-DNP-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :IY-SCHEDULED-DNP-DT 
                                              :WS-SCHEDULED-DNP-DT-NULL
              ) <> 0) OR (LEN(:IY-SCHEDULED-DNP-DT 
                                              :WS-SCHEDULED-DNP-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:IY-SCHEDULED-DNP-DT 
                                              :WS-SCHEDULED-DNP-DT-NULL
              ), CONVERT(DATE, :IY-SCHEDULED-DNP-DT 
                                              :WS-SCHEDULED-DNP-DT-NULL
              ) ))          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_IVR_NOTICE                                         
MFA-TR*        (ACCOUNT_NO,                                                     
MFA-TR*         ORIGINAL_CALL_DT,                                               
MFA-TR*         CALL_STATUS_CD,                                                 
MFA-TR*         CODE_SPECIAL_TYPE,                                              
MFA-TR*         CURR_PAST_DUE_BAL,                                              
MFA-TR*         CUSTOMER_NO,                                                    
MFA-TR*         DATE_CREDIT_ACTION,                                             
MFA-TR*         DATE_NOTICE_MAIL,                                               
MFA-TR*         NOTICE_DUE_DT,                                                  
MFA-TR*         ORIG_PAST_DUE_BAL,                                              
MFA-TR*         COMPANY_NO,                                                     
MFA-TR*         CREATED_TS,                                                     
MFA-TR*         CUST_NAME_CD,                                                   
MFA-TR*         PREM_ADDR_CD,                                                   
MFA-TR*         SCHEDULED_DNP_DT)                                               
MFA-TR*      VALUES                                                             
MFA-TR*        (:IY-ACCOUNT-NO,                                                 
MFA-TR*         :IY-ORIGINAL-CALL-DT,                                           
MFA-TR*         :IY-CALL-STATUS-CD,                                             
MFA-TR*         :IY-CODE-SPECIAL-TYPE,                                          
MFA-TR*         :IY-CURR-PAST-DUE-BAL,                                          
MFA-TR*         :IY-CUSTOMER-NO,                                                
MFA-TR*         :IY-DATE-CREDIT-ACTION:WS-DT-IVR-DT-ACTION-NULL,                
MFA-TR*         :IY-DATE-NOTICE-MAIL:WS-DATE-NOTICE-MAIL-NULL,                  
MFA-TR*         :IY-NOTICE-DUE-DT,                                              
MFA-TR*         :IY-ORIG-PAST-DUE-BAL,                                          
MFA-TR*         :IY-COMPANY-NO,                                                 
MFA-TR*         CURRENT TIMESTAMP,                                              
MFA-TR*         :IY-CUST-NAME-CD,                                               
MFA-TR*         :IY-PREM-ADDR-CD,                                               
MFA-TR*         :IY-SCHEDULED-DNP-DT:WS-SCHEDULED-DNP-DT-NULL)                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*****************PCSKR215*****************'      
              DISPLAY '** IVR_NOTICE     TABLE              '           
              DISPLAY '** ACCOUNT NO = ' IY-ACCOUNT-NO                  
              DISPLAY '** 8620 :  RETURN CODE ERROR - INSERT'           
              DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE             
              DISPLAY '*****************PCSKR215*****************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8890-COMMIT.                                                   *        
      ******************************************************************        
      *                                                                         
       8890-COMMIT.                                                     
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
      *                                                                         
           DISPLAY '******************PCSKR215********************'     
           DISPLAY '* COMMIT POINT # ' WS-COMMIT-COUNTER ' TAKEN.   *'  
           DISPLAY '* LAST REC PROCESSED  = ' AT-ACCOUNT-NO             
           DISPLAY '******************PCSKR215********************'.    
      *                                                                         
       8890-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK               *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           GO TO 9000-EXIT.                                             
                                                                        
      *                                                                         
      ******************************************************************        
      * 9000-TERMINATE.                                                *        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  9700-PROCESS-ABEND.                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
      *                                                                         
      ************************************************************              
      * THE BELOW PARAGRAPH IS NECESSARY TO BE ABLE TO USE THE   *              
      * COPYBOOK FOR WRITING THE MH AND MI.                      *              
      ************************************************************              
      *                                                                         
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
