       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSKR210.                                        
       DATE-WRITTEN.   MAR 2012.                                        
      ******************************************************************        
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **        
      **                                                              **        
      *********           CUSTOMER SERVICE SYSTEM              *********        
      *********                     DB2                        *********        
      **                                                              **        
      ******************************************************************        
      **--------------- P R O G R A M  S U M M A R Y -----------------**        
      *************************************************************** **        
      **   THIS PROGRAM WILL PROCESS ACCOUNTS FOR DISCONNECT DUE TO   **        
      **   NONPAYMENT(DNP).  INSERT INTO THE CSS_SO_DATA_MF TABLE.    **        
      ******************************************************************        
      **------------- PROGRAM  MODIFICATION  LOG -------------------- **        
      ******************************************************************        
      **      PCSKR210   PROGRAM  MODIFICATION  LOG                   **        
      **                                                              **        
      **   DATE        INITIALS  REASON                               **        
      **   __________  ________  ______________                       **        
P00599**   03/10/2012  RC41079   INITIAL PROGRAM VERSION.             **        
      **                                                              **        
A04228**   07/23/2012  SV95326   FLEX DNP ARRANGEMENT CHANGES.        **        
      **                                                              **        
P0599A**   10/04/2012  RC41079   CORRECTED WQ ROUTING ISSUE           **        
      **                                                              **        
ACT034**   06/02/2014  SS7F226   WORK QUEUE CHANGE TO REPLACE THE     **        
ACT034**               A4860     CSS_WQ_ITEMS_MF WITH CSS_WQ_ITEMS.   **        
P00718**   07/18/2014  RB19957   ADDED NEW FIELD WS-DNP-RANKING-AMT   **        
P00718**             rick black  WHICH IS EQUAL TO                    **        
P00718**                         CL-AMT-NOTICE - TOTAL SECURITIES.    **        
P00726**   08/07/2014  RB19957   Change needed to look for STA in     **        
P00726**             rick black  new db2 tables and populate flex     **        
P00726**                         comments in service order place      **        
P00726**                         by field and also DISPLAY ACCOUNT NO.**        
A05136**   01/28/2015  MJ13662   ADD WS-ACCOUNT-NO AND REMOVE         **        
A05136**               ACT028    ARNG_TYPE IN 7900-SELECT STATEMENT.  **        
A05136**                         ON SELECT TO CSS_STA_SUMMARY ONLY GET**        
A05136**                         IF NEXT-DNP-DATE = CL-DATE-CREDIT-   **        
A05136**                         ACTION.                              **        
A05136**   06/11/2015  MJ13662   MOVE ZEROES TO WS-BALANCE-DUE WHEN   **        
A05136**                         PROCESSING WS-AMT-NOTICE-H.          **        
A05323**   06/15/2015  MJ13662   REMOVED TEMP FIX PUT IT ON 6/11.     **        
A05323**                         PERMANENT FIX PUT IN CPD00068.       **        
ACT155**   08/27/2015  MJ13662   INCREASED CSS_ORDER_RSN_PRTY USER    **        
ACT155**                         TABLE FROM 125 ENTRIES TO 600.       **        
ACT155**                         APPL 5136.                           **        
ACT210**   10/13/2015  MJ13662   MOVE ZEROES TO WS-BALANCE-DUE WHEN   **        
ACT210**                         PROCESSING WS-AMT-NOTICE-H.          **        
ACT210**                         ADDED THIS BACK DUE TO RET CHECK AMT **        
ACT210**                         BEING GREATER THAN 9,999.99.         **        
ACT210**                         REMOVE REFERENCE TO CSS_DNP_NOT_WORKED*        
ACT210**                         APPL5136                             **        
      **                                                              **        
A05460**  10 NOV 2016  RF10596   REMOVE CSS_STA_SUMMARY TABLE AND     **        
A05460**                         CSS_CRED_ARNGMENT AND                **        
A05460**                         CSS_CRED_ARNG_HIST                   **        
      **                                                              **        
ACT371**  05 DEC 2016  VIJAY     INITIALIZE INDEX TO SUPPORT MFES     **        
ACT371**                         (WS-RANGE-INDEX).                    **        
ACT057*   03/08/2017   RS7V450   DELETE TABLE CSS_DNP                 **        
      ******************************************************************        
      **----------------- BASIC SEQUENCE STRUCTURE -------------------**        
      *************************************************************** **        
      **         0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION **        
      **         1000 - 1999     INPUT PROCESSING CONTROL PATH        **        
      **         2000 - 2999     OUTPUT PROCESSING CONTROL PATH       **        
      **         3000 - 4999     BATCH PROCESSING MODULES - NOT USED  **        
      **         5000 - 5999     COMMON PROGRAM MODULES               **        
      **         6000 - 6999     COMMON SYSTEM MODULES                **        
      **         7000 - 7999     INPUT MODULES                        **        
      **         8000 - 8999     OUTPUT MODULES                       **        
      **         9000 - 9799     TERMINATION MODULES                  **        
      **         9900 - 9999     ABEND/ABORT MODULES                  **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
           SELECT FCSKR210-FILE                                         
               ASSIGN UT-S-FCSKR210                                     
               FILE STATUS IS WS-FKR210-STATUS.                         
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
       FD  FCSKR210-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORD CONTAINS 80 CHARACTERS                                
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01  FCSKR210.                                                    
           05  E-FCK210-DATA-REC.                                       
               10  E-FCK210-DATA-PART1               PIC X(22).         
               10  E-FCK210-DATA-PART2               PIC X(13).         
               10  E-FCK210-DATA-PART3               PIC X(45).         
           05  E-FCK210-DATA-REC1 REDEFINES E-FCK210-DATA-REC.          
               10  E-FCK210-DATA-PARTA               PIC X(14).         
               10  E-FCK210-DATA-PARTB               PIC X(28).         
               10  E-FCK210-DATA-PARTC               PIC X(38).         
           05  E-FCK210-DATA-REC2 REDEFINES E-FCK210-DATA-REC.          
               10  E-FCK210-DATA-PARTAA              PIC X(18).         
               10  E-FCK210-DATA-PARTBB              PIC X(28).         
               10  E-FCK210-DATA-PARTCC              PIC X(34).         
           05  E-FCK210-DATA-REC3 REDEFINES E-FCK210-DATA-REC.          
               10  E-FCK210-DATA-PARTAAA             PIC X(20).         
               10  E-FCK210-DATA-PARTBBB             PIC X(08).         
               10  E-FCK210-DATA-PARTCCC             PIC X(52).         
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ012      EXEC SQL INCLUDE MFADIAG END-EXEC
MSQ008  01 MSQ008-ORDER-RSN-CSR  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSKR210'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)                      
           VALUE 'WORKING STORAGE FOR PCSKR210 STARTS HERE'.            
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME               PIC X(08)    VALUE 'PCSKR210'.
           05  WS-PGRMNAME                PIC X(08)    VALUE 'PCSKR210'.
           05  SCSCB068                   PIC X(08)    VALUE 'SCSCB068'.
P00599     05  SCSCA151                   PIC X(08)    VALUE 'SCSCA151'.
ACT034     05  SCSCB077                   PIC X(08)    VALUE 'SCSCB077'.
           05  WS-SYSTEM                  PIC X(06)     VALUE 'SYSTEM'. 
           05  WS-IVR-PRESENT             PIC X(01)     VALUE 'N'.      
           05  WS-D                       PIC X(01)     VALUE 'D'.      
           05  WS-E                       PIC X(01)     VALUE 'E'.      
           05  WS-G                       PIC X(01)     VALUE 'G'.      
           05  WS-H                       PIC X(01)     VALUE 'H'.      
           05  WS-I                       PIC X(01)     VALUE 'I'.      
           05  WS-J                       PIC X(01)     VALUE 'J'.      
           05  WS-K                       PIC X(01)     VALUE 'K'.      
           05  WS-M                       PIC X(01)     VALUE 'M'.      
           05  WS-N                       PIC X(01)     VALUE 'N'.      
           05  WS-O                       PIC X(01)     VALUE 'O'.      
           05  WS-P                       PIC X(01)     VALUE 'P'.      
           05  WS-S                       PIC X(01)     VALUE 'S'.      
           05  WS-U                       PIC X(01)     VALUE 'U'.      
           05  WS-V                       PIC X(01)     VALUE 'V'.      
           05  WS-Y                       PIC X(01)     VALUE 'Y'.      
           05  WS-X                       PIC X(01)     VALUE 'X'.      
           05  WS-Z                       PIC X(01)     VALUE 'Z'.      
           05  WS-ON-SITE                 PIC X(02)     VALUE '30'.     
           05  WS-ORDER-TYPE              PIC X(05).                    
           05  WS-DNP-PRESENT             PIC X(01)     VALUE 'N'.      
           05  WS-SCEG                    PIC X(02)     VALUE '01'.     
           05  WS-PSNC                    PIC X(02)     VALUE '26'.     
           05  WS-WP                      PIC X(02)     VALUE 'WP'.     
           05  WS-WX                      PIC X(02)     VALUE 'WX'.     
           05  WS-MTRD-ENVRNMT            PIC X(01)     VALUE 'N'.      
           05  WS-DISCONNECT-FLAG         PIC X(01)     VALUE 'N'.      
           05  WS-EXCEPTIONAL-FLAG        PIC X(01)     VALUE 'N'.      
           05  WS-SCHEDULE                PIC X(02)     VALUE '10'.     
           05  WS-WORK-TYPE-CD            PIC X(03)     VALUE 'DNP'.    
      *                                                                         
       01  WS-MISC.                                                     
           05  RS-RETURN-CODE             PIC S9(04)    COMP VALUE 0.   
           05  S-RETURN-CODE              PIC S9(04)    COMP VALUE 0.   
           05  RS-RETURN-CODE-DISP        PIC S9(04)    COMP VALUE 0.   
           05  MULTIPLE-ROWS              PIC S9(09)    VALUE -811 COMP.
COB305     05 WS-CURRENT-CHARGES        PIC S9(09)V99 COMP-3 VALUE 0.         
           05  WS-DATE-CRED-ACT-NULL      PIC S9(04)    COMP VALUE +0.  
           05  WS-DATE-FORECAST-DNP-NULL  PIC S9(04)    COMP VALUE +0.  
           05  WS-TRAN-APPL-NO            PIC S9(04)    COMP VALUE +0.  
           05  WS-TIMESTAMP               PIC X(26)     VALUE SPACES.   
           05  WS-DNP-CO-NO               PIC X(02).                    
           05  WS-NEXT-BUSINESS-DAY       PIC X(10)     VALUE SPACES.   
ACT155     05  WS-ORDER-PRIORITY1         PIC 9(04)     VALUE 0.        
           05  WS-INDEX                   PIC S9(04)    COMP-3 VALUE +0.
           05  WS-DEP-ON-HAND             PIC S9(09)V99 COMP-3 VALUE +0.
           05  WS-DEP-ON-HAND-NULL        PIC S9(04)    COMP   VALUE +0.
           05  WS-NULL-IND                PIC S9(04)    COMP   VALUE +0.
           05  WS-NUM-COND                PIC S9(04)    COMP   VALUE +0.
           05  WS-ORDER-ROW-COUNT         PIC S9(04)    COMP   VALUE +0.
           05  WS-MAX-SO-INST-SEQ-NO      PIC S9(04)    COMP-3 VALUE +0.
COB305     05 WS-BALANCE-DUE        PIC S9(09)V99 COMP-3 VALUE 0.         
P00718     05  WS-DNP-RANKING-AMT         PIC S9(09)V99 COMP-3 VALUE +0.
P00718     05  WS-SECURITIES              PIC S9(09)V99 COMP-3 VALUE +0.
P00718     05  WS-SB-AMT-BOND-NULL        PIC S9(04) COMP      VALUE +0.
P00718     05  WS-GU-AMOUNT-GUARANTEED-NULL PIC S9(04) COMP    VALUE +0.
P00718     05  WS-AC-TRANS-BALANCE-NULL   PIC S9(04) COMP      VALUE +0.
           05  WS-ELECTRIC-ACCT-NO      PIC S9(13)      COMP-3 VALUE +0.
           05  WS-HOLD-DNP-ACCT-NO        PIC 9(13)       VALUE ZEROS.  
           05  WS-HOLD-NOTICE-TYPE        PIC X(01)    VALUE SPACE.     
           05  WS-DNP-CNTR              PIC S9(5) USAGE COMP-3 VALUE +0.
           05  WS-OLD-DISC-HIST           PIC X(24)       VALUE SPACES. 
           05  WS-DISPLAY-SQLCODE         PIC -ZZZZZZZZ9.               
           05  WS-OLD-DISCEX-HIST         PIC X(24)       VALUE SPACES. 
           05  WS-DISC-EXCEPTN-DESC       PIC X(14)       VALUE         
               'EXCEPTION HIST'.                                        
           05  WS-DISCONNECT-DESC         PIC X(15)       VALUE         
               'DISCONNECT HIST'.                                       
           05  WS-PENDING-ACCOUNT         PIC X(36)       VALUE         
               'PENDING ACCOUNT                     '.                  
ACT034     05  WS-INPUT-ZERO              PIC X(16)                     
ACT034                                    VALUE '-00.00.00.000000'.     
ACT034     05  WS-INPUT-DATE-26           PIC X(26) VALUE SPACES.       
           05  WS-DNP-HIST-TRANS-CMNT.                                  
               10  FILLER               PIC X(29)                       
                   VALUE 'CURRENT MONTH DNP EXEMPTED - '.               
               10  WS-DNP-COMMENT       PIC X(36)       VALUE SPACES.   
           05  WS-ACTIVE-MED-CERT       PIC X(36)       VALUE           
               'ACTIVE MEDICAL CERTIFICATE          '.                  
           05  WS-BANKRUPTCY            PIC X(36)       VALUE           
               'BANKRUPTCY                          '.                  
           05  WS-JUDGMENT              PIC X(36)       VALUE           
               'JUDGMENT                            '.                  
           05  WS-DNP-EXEMPTION         PIC X(36)       VALUE           
               'DNP EXEMPTION SET                   '.                  
           05  WS-DNP-DESELECTED        PIC X(36)       VALUE           
               'FORECASTED DNP DESELECTED           '.                  
           05  WS-DNP-WORKED            PIC X(36)       VALUE           
               'DNP WORKED WITHIN CURRENT BILL CYCLE'.                  
           05  WS-DNP-COMMENT-LEN       PIC S9(4)       VALUE 36 COMP.  
           05  WS-SEB-REG-SENIOR-WQ.                                    
               10 FILLER                PIC X(51)       VALUE           
                  'CUSTOMER IS SCHEDULED TO MOVE TO GROUP 2 BECAUSE OF'.
               10 FILLER                PIC X(49)       VALUE           
                  'NON-PAYMENT OF ARREARS; WILL BE BILLED HIGHER PER'.  
               10 FILLER                PIC X(49)       VALUE           
                  'THERM RATE, CUSTOMER SERVICE CHARGE, AND POSSIBLY'.  
               10 FILLER                PIC X(50)       VALUE           
                  'BILLED A DEPOSIT. FULL BALANCE WILL BE REQUIRED TO'. 
               10 FILLER                PIC X(50)       VALUE           
                  'MOVE BACK TO GROUP 1. WQ HAS PUT ACCT ON HOLD'.      
           05  WS-CURRENT-DNP-STATUS-E  PIC X(18)       VALUE           
               'CURRENT DNP STATUS'.                                    
           05  WS-CURRENT-DNP-STATUS-B  PIC X(18)       VALUE           
               'DNP - SAME BILLING'.                                    
           05  WS-CIA-DEBIT.                                            
               10 WS-CIA-DEBIT-TEXT1    PIC X(49)       VALUE           
                  'DNP PROCESSING HAS STOPPED DUE TO THE CIA DEBIT. '.  
               10 WS-CIA-DEBIT-TEXT2    PIC X(30)       VALUE           
                  'A MANUAL DNP MAY BE NECESSARY.'.                     
P00599     05  WS-ACCOUNT-NO            PIC S9(13)V  COMP-3 VALUE 0.    
           05  WS-DNP-HIST-TRANS-CMNT2.                                 
               10  FILLER               PIC X(37)                       
                   VALUE 'Multiple DNP''s for same date. Second'.       
               10  FILLER               PIC X(16)                       
                   VALUE 'ary DNP deleted.'.                            
ACT210     05  WS-REASON-NOT-DNP       PIC X(01) VALUE SPACE.           
                                                                        
       01  WS-MISC-HOST-VARIABLES.                                      
ACT155     05  WS-COMPANY-NUM          PIC X(02)  OCCURS 600 TIMES      
                                                  VALUE SPACES.         
ACT155     05  WS-ORDER-TYPE-CD        PIC X(05)  OCCURS 600 TIMES      
                                                  VALUE SPACES.         
ACT155     05  WS-ORDER-REASON-CD      PIC X(02)  OCCURS 600 TIMES      
                                                  VALUE SPACES.         
ACT155     05  WS-ACCOUNT-TYPE-CD      PIC X(01)  OCCURS 600 TIMES      
                                                  VALUE SPACES.         
           05  WS-ORDER-MIN-AM         PIC S9(9)V9(2) USAGE COMP-3      
ACT155                                     OCCURS 600 TIMES VALUE 0.    
           05  WS-ORDER-MAX-AM         PIC S9(9)V9(2) USAGE COMP-3      
ACT155                                     OCCURS 600 TIMES VALUE 0.    
           05  WS-ORDER-PRIORITY-CD    PIC S9(04) USAGE COMP            
ACT155                                     OCCURS 600 TIMES VALUE 0.    
ACT155     05  WS-EFFECTIVE-DT         PIC X(10)  OCCURS 600 TIMES      
                                                  VALUE SPACES.         
ACT155     05  WS-LAST-UPDATE-TS       PIC X(26)  OCCURS 600 TIMES      
                                                  VALUE SPACES.         
ACT155     05  WS-LAST-UPDATE-USERID   PIC X(07)  OCCURS 600 TIMES      
                                                  VALUE SPACES.         
           05  WS-GENERAL-CUSTOMER-DATA.                                
               10  WS-DISCONNECT-HIST-X.                                
                   15  WS-DISCONNECT-HIST PIC X(01)                     
                                         OCCURS 024 TIMES.              
               10  WS-DISC-EXCEPTN-HIST   PIC X(24).                    
      *                                                                         
       01  WS-WQ-MESSAGE-DATA.                                          
           05  WS-MISCELLANEOUS-MESSAGE.                                
               10  WS-MISC-CATEGORY-ID   PIC S9(04)   COMP VALUE 0.     
               10  WS-MISC-PRIORITY      PIC X(01)    VALUE SPACE.      
               10  WS-MISC-WQ-ROUTE      PIC X(01)    VALUE SPACE.      
               10  WS-MISC-MSG-LEN       PIC S9(04)   USAGE COMP.       
               10  WS-MISC-MSG-TEXT      PIC X(250).                    
      *                                                                         
       01  WS-WQ-COMMENTS.                                              
           05  WS-WQ-COMMENT-LIT          PIC X(51).                    
           05  WS-WQ-DNP-BALANCE-LIT      PIC X(13)  VALUE              
               ' DNP AMOUNT: '.                                         
           05  WS-WQ-DNP-BALANCE          PIC $$$$$$$$$.99.             
           05  WS-WQ-PAST-DUE-BALANCE-LIT PIC X(19)  VALUE              
               ' PAST DUE BALANCE: '.                                   
           05  WS-WQ-PAST-DUE-BALANCE     PIC $$$$$$$$$.99.             
           05  WS-WQ-BILLED-BALANCE-LIT   PIC X(17)  VALUE              
               ' BILLED BALANCE: '.                                     
           05  WS-WQ-BILLED-BALANCE       PIC $$$$$$$$$.99.             
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-DATABASE-KR210         PIC 9(01)    VALUE ZERO.       
               88  CSR-DATABASE                       VALUE 1.          
               88  SEB-DATABASE                       VALUE 2.          
           05  WS-STOP-SO-INSERTS        PIC X(01)    VALUE 'N'.        
           05  WS-MULTI-DNP-SW           PIC X(01)    VALUE 'Y'.        
               88  MULTI-DNP                          VALUE 'Y'.        
               88  NOT-MULTI-DNP                      VALUE 'N'.        
           05  WS-DNP-READY-SW           PIC X(01)    VALUE 'Y'.        
               88  DNP-READY                          VALUE 'Y'.        
               88  DNP-NOT-READY                      VALUE 'N'.        
           05  WS-SEB-SENIOR-FLAG        PIC X(01)    VALUE 'N'.        
               88  WS-SEB-SENIOR                      VALUE 'Y'.        
           05  WS-SEB-REG-FLAG           PIC X(01)    VALUE 'N'.        
               88  WS-SEB-REGULATED                   VALUE 'Y'.        
           05  WS-ACCOUNT-SW             PIC X(01)    VALUE 'N'.        
               88  ELECTRIC-ACCT                      VALUE 'Y'.        
               88  NOT-ELECTRIC-ACCT                  VALUE 'N'.        
P00599     05  WS-PROCESS-ACCOUNT        PIC X(01)    VALUE 'Y'.        
P00599         88  PROCESS-ACCT                       VALUE 'Y'.        
P00599         88  SKIP-ACCT                          VALUE 'N'.        
           05  WS-ORDER-RSN-TBL-LOADED   PIC X(01)    VALUE 'N'.        
               88 ORDER-RSN-TBL-LOADED                VALUE 'Y'.        
           05  WS-FKR210-STATUS          PIC XX       VALUE '  '.       
               88 FKR210-SUCCESSFUL                   VALUE '00'.       
           05  WS-FST-TIME               PIC X(01)    VALUE 'Y'.        
           05  WS-DISC-HIST-UPDT         PIC X(01)    VALUE 'N'.        
                                                                        
       01  WS-COMMIT-VARS.                                              
           05  WS-COMMIT-COUNTER         PIC 9(04)     VALUE ZERO.      
           05  WS-RECS-TO-COMMIT-COUNTER PIC 9(04)     VALUE ZERO.      
           05  WS-READY-TO-COMMIT-COUNT  PIC S9(09) COMP VALUE +0.      
      *                                                                         
       01  WS-COMMENTS.                                                 
           05 WS-COMMENTS-LEN              PIC S9(4) USAGE COMP.        
           05 WS-COMMENTS-TEXT             PIC X(250).                  
      *                                                                         
       01  WS-CUST-LAST-NAME.                                           
           05 WS-CUST-LNAME-4              PIC X(04)  VALUE SPACE.      
           05 WS-CUST-LNAME-16             PIC X(16)  VALUE SPACE.      
      *                                                                         
       01  WS-CUST-ADDRESS1.                                            
           05 WS-CUST-ADDRS-10             PIC X(10)  VALUE SPACES.     
           05 WS-CUST-ADDRS-36             PIC X(36)  VALUE SPACES.     
      *                                                                         
       01  WS-WORKQUEUE-COMMENTS.                                       
           05  WS-WQ-MULTI-DNP             PIC X(52)  VALUE             
               'ACCT HAS MULTIPLE DNPS WITH SAME CREDIT ACTION DATE.'.  
      *                                                                         
           05  WS-WQ-2ND-NOTICE-LIT.                                    
               10 FILLER                  PIC X(47) VALUE               
               'SET CUSTOMER TO CORRESPONDING CHOICE RATE PLAN '.       
               10 FILLER                  PIC X(47) VALUE               
               'WITH 6.95 CSC, UPDATE ANNIV DATE, UPDATE PRICE,'.       
               10 FILLER                  PIC X(24) VALUE               
               ' DELETE 6.95 CSC FACTOR.'.                              
      *                                                                         
           05  WS-WQ-LIGHT-ONLY-ACCOUNT   PIC X(51)  VALUE              
               'LIGHT ONLY ACCOUNT/DNP NOT GENERATED;              '.   
      *                                                                         
           05  WS-WQ-CT-METER             PIC X(51)  VALUE              
               'CT METER ACCOUNT/DNP NOT GENERATED;                '.   
      *                                                                         
           05  WS-WQ-WHITE-CROSS-PLUS     PIC X(51)  VALUE              
               'WHITE CROSS PLUS ACCOUNT/DNP NOT GENERATED;        '.   
      *                                                                         
       01  WS-ORDER-RSN-DATA.                                           
           03  WS-ORDER-RSN                                             
ACT155            OCCURS 600 TIMES                                      
                  DESCENDING KEY WS-EFFECTIVE-DT1                       
                  ASCENDING  KEY WS-COMPANY-NO1, WS-ORDER-TYPE-CD1,     
                            WS-ORDER-REASON-CD1, WS-ACCOUNT-TYPE-CODE1, 
                            WS-ORDER-MIN-AM1                            
                  INDEXED BY WS-RANGE-INDEX.                            
               05  WS-COMPANY-NO1          PIC X(02) VALUE SPACES.      
               05  WS-ORDER-TYPE-CD1       PIC X(05) VALUE SPACES.      
               05  WS-ORDER-REASON-CD1     PIC X(02) VALUE SPACES.      
               05  WS-ACCOUNT-TYPE-CODE1   PIC X(01) VALUE SPACES.      
               05  WS-ORDER-MIN-AM1        PIC S9(9)V9(2) USAGE COMP-3  
                                                     VALUE 0.           
               05  WS-ORDER-MAX-AM1        PIC S9(9)V9(2) USAGE COMP-3  
                                                     VALUE 0.           
               05  WS-ORDER-PRIORITY-CD1   PIC S9(04) USAGE COMP        
                                                     VALUE 0.           
               05  WS-EFFECTIVE-DT1        PIC X(10) VALUE SPACES.      
               05  WS-LAST-UPDATE-TS1      PIC X(26) VALUE SPACES.      
               05  WS-LAST-UPDATE-USERID1  PIC X(07) VALUE SPACES.      
      *                                                                         
       01  EMAIL-TO.                                                    
           05  EMAIL-TO-REC.                                            
               10  WS-PRG-TO              PIC X(08) VALUE SPACES.       
               10  FILLER                 PIC X(21) VALUE               
                                           '@SCEGJES2.SCANA.COM> '.     
      *                                                                         
       01  EMAIL-PRG.                                                   
           05  EMAIL-PRG-REC.                                           
               10  FILLER                 PIC X(17) VALUE               
                                                   '*****************'. 
               10  WS-PRGM                PIC X(08) VALUE SPACES.       
               10  FILLER                 PIC X(17) VALUE               
                                                   '*****************'. 
      *                                                                         
       01  EMAIL-HDN.                                                   
           05  EMAIL-HDN-REC.                                           
               10  FILLER                 PIC X(08) VALUE 'COMPANY'.    
               10  FILLER                 PIC X(03) VALUE SPACES.       
               10  FILLER                 PIC X(10) VALUE 'ACCOUNT NO'. 
               10  FILLER                 PIC X(07) VALUE SPACES.       
               10  FILLER                 PIC X(11) VALUE 'CATEGORY ID'.
               10  FILLER                 PIC X(03) VALUE SPACES.       
               10  FILLER                 PIC X(10) VALUE 'REG GRP CD'. 
               10  FILLER                 PIC X(03) VALUE SPACES.       
               10  FILLER                 PIC X(09) VALUE 'SENIOR FL'.  
      *                                                                         
       01  EMAIL-DTL.                                                   
           05  EMAIL-DTL-REC.                                           
               10  WS-EMAIL-COMP          PIC X(02)      VALUE SPACES.  
               10  FILLER                 PIC X(10)      VALUE SPACES.  
               10  WS-EMAIL-ACCT          PIC X(13)      VALUE SPACES.  
               10  FILLER                 PIC X(10)      VALUE SPACES.  
               10  WS-EMAIL-CAT           PIC 9(04)      VALUE 0.       
               10  FILLER                 PIC X(11)      VALUE SPACES.  
               10  WS-EMAIL-REG-GRP       PIC X(03)      VALUE SPACES.  
               10  FILLER                 PIC X(11)      VALUE SPACES.  
               10  WS-EMAIL-SEN-FL        PIC X(01)      VALUE SPACES.  
      *                                                                         
      ******************************************************************        
      * WS-ABEND-SWITCH                                                *        
      ******************************************************************        
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
      ******************************************************************        
      * CWS00038 JOB PARM ROUTINE                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00038                                                 
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
       01  WS-INSERT-ROW-COUNT REDEFINES WS-INPUT-DATA-BREAKDOWN.       
           10  WS-PARM-COMMIT-ROW-COUNT-TXT PIC X(09).                  
               88 COMMIT-ROW-CNT         VALUE 'COMMIT = '.             
           10  WS-NO-OF-ROWS-TO-COMMIT   PIC X(05).                     
           10  FILLER                    PIC X(66).                     
      *                                                                         
      ******************************************************************        
      * CWS00039 JOB PARM ROUTINE                                      *        
      ******************************************************************        
      *                                                                         
       COPY CWS00039.                                                           
      *                                                                         
      ******************************************************************        
      * FIOJC01 WORKING STORAGE                                        *        
      ******************************************************************        
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      ******************************************************************        
      * FCA00-KEY                                                      *        
      ******************************************************************        
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR CODES-DATA-PRESENT                         *        
      ******************************************************************        
      *                                                                         
       COPY CWS00056.                                                           
      *                                                                         
      ******************************************************************        
      * CWS00303 JOB PARM ROUTINE CONTAINS WS-WARNING-DATA-ELEMENTS    *        
      ******************************************************************        
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      ******************************************************************        
      * DB2 COMMUNICATION REQUIREMENT                                  *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CWS00010 CONTAINS DB2 ABEND VARIABLES                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00010                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CWS00068 CONTAINS WS FOR CALC OF ARREARS, DISCONNECT AMT,     *         
      * PASTE DUE, AND NUMEROUS DATES.                                *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CWS00314 CONTAINS WS FOR FINDING LIMITS FOR EXCEPTIONS        *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00314                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CWS00322 CONTAINS WS FOR FINDING NEXT BUSINESS DAY            *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00322                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CWS00346     CONTAINS WS GETTING WQ GENERATION FLAG          *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CWS00346                                                  
           END-EXEC.                                                            
      *                                                                         
ACT034*****************************************************************         
ACT034*  CWS00077     WORKING STORAGE COPYBOOK FOR SCSCB077           *         
ACT034*****************************************************************         
ACT034     EXEC SQL                                                             
ACT034        INCLUDE CWS00077                                                  
ACT034     END-EXEC.                                                            
ACT034*                                                                         
P00599******************************************************************        
P00599* VARIABLES NEEDED FOR ACCOUNT SKIP PROCESSING.                  *        
P00599******************************************************************        
P00599*                                                                         
P00599 COPY CWSCA151.                                                           
P00599*                                                                         
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSKR210 ENDS HERE  '.            
      *                                                                         
      ******************************************************************        
      * CSS_ACCOUNT        - AT                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_AR_CNTL        - AC                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBARCNTL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_BUSINESS_DAYS  - 1G                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBUSDAY                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CRED_COLL - CL                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCRCOLL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CREDIT_PROFILE - CZ                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCRPROF                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CUST_PLAN      - CP                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSTPLN                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_DELINQUENCY    - C8                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_DEP_ON_HAND - DO                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
      *                                                                         
P00718***************************************************************** *       
P00718* CSS_GUARANTOR - GU                                            *         
P00718***************************************************************** *       
P00718     EXEC SQL                                                             
P00718        INCLUDE TBGTNTR                                                   
P00718     END-EXEC.                                                            
P00718*                                                                         
      ******************************************************************        
      * CSS_JOB_PARM       - G6                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MT_TRN_HST_DET - MI                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MNT_TRANS_HIST - MH                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MTRD_ENVRNMT   - MN                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ORDER_RSN_PRTY - OZ                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBORDRSN                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_REG_PROFILE - LR                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_SO_DATA     - VO                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_SO_DATA_MF  - XE                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSODTMF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_SO_ORD_INST_MF - WB                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSOOIMF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_SO_REMARKS  - EF                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSOREM                                                   
           END-EXEC.                                                            
      *                                                                         
P00718***************************************************************** *       
P00718* CSS_SURETY_BOND - SB                                          *         
P00718***************************************************************** *       
P00718*                                                                         
P00718     EXEC SQL                                                             
P00718        INCLUDE TBSTYBND                                                  
P00718     END-EXEC.                                                            
P00718*                                                                         
      ******************************************************************        
      *    CSS_WQ_PGM_CNTL    WN                                                
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBWQCNTL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CURSOR DECLARATION                                             *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      * DNP_CSR                                                        *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE DNP_CSR CURSOR WITH HOLD FOR                     
               SELECT  AT.CUSTOMER_NO,                                  
                       AT.ACCOUNT_NO,                                   
                       AT.PREMISE_NO,                                   
                       AT.COMPANY_NO,                                   
                       AT.LOCAL_OFFICE,                                 
                       AT.DATE_BILL_DAY_00,                             
                       AT.DATE_BILL_DAY_30,                             
                       AT.DATE_BILL_DAY_60,                             
                       AT.DATE_BILL_DAY_90,                             
                       AT.BILL_CYCLE,                                   
                       AT.TOTAL_AR_BALANCE,                             
                       AT.CODES_DATA_PRESENT,                           
                       AT.CODE_ACCT_STAT,                               
                       AT.CREDIT_GROUP,                                 
                       AT.ACCOUNT_TYPE_CODE,                            
                       AT.CODE_STATUS_REASON,                           
                       AT.NOTICE_EXEMPT_CD,                             
                       AT.IVR_EXEMPT_CD,                                
                       AT.CODE_DISC_OK,                                 
                       AT.BANKRUPTCY_IND,                               
                       AT.CT_METER_RATED_IND,                           
                       AT.CODE_CRIT_OUTAGE,                             
                       CL.DATE_CREDIT_ACTION,                           
                       CL.CODE_NOTICE_TYPE,                             
                       CL.ITEM_ID                                       
               FROM    CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                      ,CSS_CRED_COLL CL WITH(READUNCOMMITTED)                   
               WHERE   AT.ACCOUNT_NO         = CL.ACCOUNT_NO            
                 AND   CL.DATE_CREDIT_ACTION = IIF(TRY_CONVERT(DATE, 
                                                  :WS-NEXT-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEXT-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEXT-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEXT-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEXT-BUSINESS-DAY) )    
                 AND   CL.CODE_NOTICE_TYPE  IN ('D','G','H','I')        
                 AND   AT.CODE_ACCT_STAT    IN ('A','P')                
                 AND   CL.PROCESSED_CD       = ' '                      
               ORDER BY AT.ACCOUNT_NO, CL.CODE_NOTICE_TYPE DESC         
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE DNP_CSR CURSOR WITH HOLD FOR                             
MFA-TR*        SELECT  AT.CUSTOMER_NO,                                          
MFA-TR*                AT.ACCOUNT_NO,                                           
MFA-TR*                AT.PREMISE_NO,                                           
MFA-TR*                AT.COMPANY_NO,                                           
MFA-TR*                AT.LOCAL_OFFICE,                                         
MFA-TR*                AT.DATE_BILL_DAY_00,                                     
MFA-TR*                AT.DATE_BILL_DAY_30,                                     
MFA-TR*                AT.DATE_BILL_DAY_60,                                     
MFA-TR*                AT.DATE_BILL_DAY_90,                                     
MFA-TR*                AT.BILL_CYCLE,                                           
MFA-TR*                AT.TOTAL_AR_BALANCE,                                     
MFA-TR*                AT.CODES_DATA_PRESENT,                                   
MFA-TR*                AT.CODE_ACCT_STAT,                                       
MFA-TR*                AT.CREDIT_GROUP,                                         
MFA-TR*                AT.ACCOUNT_TYPE_CODE,                                    
MFA-TR*                AT.CODE_STATUS_REASON,                                   
MFA-TR*                AT.NOTICE_EXEMPT_CD,                                     
MFA-TR*                AT.IVR_EXEMPT_CD,                                        
MFA-TR*                AT.CODE_DISC_OK,                                         
MFA-TR*                AT.BANKRUPTCY_IND,                                       
MFA-TR*                AT.CT_METER_RATED_IND,                                   
MFA-TR*                AT.CODE_CRIT_OUTAGE,                                     
MFA-TR*                CL.DATE_CREDIT_ACTION,                                   
MFA-TR*                CL.CODE_NOTICE_TYPE,                                     
MFA-TR*                CL.ITEM_ID                                               
MFA-TR*        FROM    CSS_ACCOUNT AT                                           
MFA-TR*               ,CSS_CRED_COLL CL                                         
MFA-TR*        WHERE   AT.ACCOUNT_NO         = CL.ACCOUNT_NO                    
MFA-TR*          AND   CL.DATE_CREDIT_ACTION = :WS-NEXT-BUSINESS-DAY            
MFA-TR*          AND   CL.CODE_NOTICE_TYPE  IN ('D','G','H','I')                
MFA-TR*          AND   AT.CODE_ACCT_STAT    IN ('A','P')                        
MFA-TR*          AND   CL.PROCESSED_CD       = ' '                              
MFA-TR*        ORDER BY AT.ACCOUNT_NO, CL.CODE_NOTICE_TYPE DESC                 
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*      QUERYNO 7210                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      * CURSOR TO LOAD ORDER-RSN-PRIORITY ROWS                                  
           EXEC SQL                                                     
              DECLARE ORDER_RSN_CSR CURSOR WITH ROWSET POSITIONING FOR  
               SELECT OZ.COMPANY_NO                                     
                     ,OZ.ORDER_TYPE_CD                                  
                     ,OZ.ORDER_REASON_CD                                
                     ,OZ.ACCOUNT_TYPE_CODE                              
                     ,OZ.ORDER_MIN_AM                                   
                     ,OZ.ORDER_MAX_AM                                   
                     ,OZ.ORDER_PRIORITY_CD                              
                     ,OZ.EFFECTIVE_DT                                   
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           OZ.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,OZ.LAST_UPDATE_USERID                             
                 FROM CSS_ORDER_RSN_PRTY OZ WITH(READUNCOMMITTED)               
                WHERE OZ.EFFECTIVE_DT <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )                 
                ORDER BY OZ.EFFECTIVE_DT DESC, OZ.COMPANY_NO,           
                         OZ.ORDER_TYPE_CD, OZ.ORDER_REASON_CD,          
                         OZ.ACCOUNT_TYPE_CODE, OZ.ORDER_MIN_AM          
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ORDER_RSN_CSR CURSOR WITH ROWSET POSITIONING FOR          
MFA-TR*        SELECT OZ.COMPANY_NO                                             
MFA-TR*              ,OZ.ORDER_TYPE_CD                                          
MFA-TR*              ,OZ.ORDER_REASON_CD                                        
MFA-TR*              ,OZ.ACCOUNT_TYPE_CODE                                      
MFA-TR*              ,OZ.ORDER_MIN_AM                                           
MFA-TR*              ,OZ.ORDER_MAX_AM                                           
MFA-TR*              ,OZ.ORDER_PRIORITY_CD                                      
MFA-TR*              ,OZ.EFFECTIVE_DT                                           
MFA-TR*              ,OZ.LAST_UPDATE_TS                                         
MFA-TR*              ,OZ.LAST_UPDATE_USERID                                     
MFA-TR*          FROM CSS_ORDER_RSN_PRTY OZ                                     
MFA-TR*         WHERE OZ.EFFECTIVE_DT <= :WS-INPUT-DATE                         
MFA-TR*         ORDER BY OZ.EFFECTIVE_DT DESC, OZ.COMPANY_NO,                   
MFA-TR*                  OZ.ORDER_TYPE_CD, OZ.ORDER_REASON_CD,                  
MFA-TR*                  OZ.ACCOUNT_TYPE_CODE, OZ.ORDER_MIN_AM                  
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*        QUERYNO 7440                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
              DECLARE MTRD_ENV_CSR CURSOR FOR                           
               SELECT CODE_METER_LOC,                                   
                      CODE_UTIL_TYPE,                                   
                      METER_NO,                                         
                      METER_SUPPLYING                                   
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                
                 AND (CODE_METER_STATUS = 'A' OR                        
                      CODE_METER_STATUS = 'B' OR                        
                      CODE_METER_STATUS = 'I')                          
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MTRD_ENV_CSR CURSOR FOR                                   
MFA-TR*        SELECT CODE_METER_LOC,                                           
MFA-TR*               CODE_UTIL_TYPE,                                           
MFA-TR*               METER_NO,                                                 
MFA-TR*               METER_SUPPLYING                                           
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                        
MFA-TR*          AND (CODE_METER_STATUS = 'A' OR                                
MFA-TR*               CODE_METER_STATUS = 'B' OR                                
MFA-TR*               CODE_METER_STATUS = 'I')                                  
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*        QUERYNO 7410                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS MAIN PROCESSING OF PROGRAM                            *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION              THRU 0100-EXIT.     
      *                                                                         
P00599     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
P00599        MOVE AT-ACCOUNT-NO         TO WS-ACCOUNT-NO               
P00599        PERFORM 5200-CHK-SKIP-ACCTS      THRU 5200-CPD347-EXIT    
P00599                                                                  
P00599        IF PROCESS-ACCT                                           
P00599           PERFORM 1200-DNP-EXTRACT           THRU 1200-EXIT      
P00599        END-IF                                                    
              PERFORM 7210-FETCH-CRED-COLL THRU 7210-EXIT               
P00599     END-PERFORM.                                                 
      *                                                                         
           PERFORM 7220-CLOSE-CRED-COLL             THRU 7220-EXIT.     
           PERFORM 9000-TERMINATE                   THRU 9000-EXIT.     
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZATION.                                           *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           INITIALIZE WS-COMMENTS                                       
                      WS-CUST-LAST-NAME.                                
      *                                                                         
           PERFORM 0110-GET-JOB-PARM-DATE           THRU 0110-EXIT.     
      *                                                                         
           OPEN OUTPUT FCSKR210-FILE.                                   
           IF NOT FKR210-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSKR210           **'        
               DISPLAY '**  FILE STATUS = ' WS-FKR210-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           PERFORM 0120-GET-DATABASE                THRU 0120-EXIT.     
           PERFORM 7200-OPEN-CRED-COLL              THRU 7200-EXIT.     
           PERFORM 7210-FETCH-CRED-COLL             THRU 7210-EXIT.     
           MOVE ZEROS                TO CL-ACCOUNT-NO.                  
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0110-GET-RELATIVE-DATES                                        *        
      ******************************************************************        
      *                                                                         
       0110-GET-JOB-PARM-DATE.                                          
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE              THRU 6251-EXIT.     
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE   THRU 6240-EXIT      
               MOVE WS-FCA00-COMMON-DATE    TO WS-INPUT-DATE            
           END-IF.                                                      
      *                                                                         
           MOVE WS-INPUT-DATE          TO WS-NEW-BUSINESS-DAY           
                                          WS-HOLD-DATE.                 
      *                                                                         
           PERFORM 0115-GET-COMMIT-ROW-COUNT    THRU 0115-EXIT.         
      *                                                                         
           PERFORM 6500-GET-NEXT-BUSINESS-DAY                           
                         THRU 6500-NEXT-BUSINESS-DAY-EXIT.              
           MOVE WS-NEW-BUSINESS-DAY    TO WS-NEXT-BUSINESS-DAY.         
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0115-GET-COMMIT-ROW-COUNT.                                     *        
      * GET THE COMMIT ROW COUNT FROM JOB PARM TABLE                   *        
      ******************************************************************        
       0115-GET-COMMIT-ROW-COUNT.                                       
      *                                                                         
           MOVE  WS-PGRMNAME               TO WS-PROGRAM.               
           MOVE  WS-PARM                   TO WS-COMMAND.               
           MOVE  ZEROS                     TO WS-SEQUENCE.              
           MOVE  SPACES                    TO WS-SYSIPT.                
           MOVE  WS-KEY-AREA               TO E-FJC01-KEY.              
      *                                                                         
           PERFORM 7600-START-FCSJC01      THRU  7600-EXIT.             
           PERFORM 7610-READ-FCSJC01       THRU  7610-EXIT              
              UNTIL (COMMIT-ROW-CNT AND INPUT-ACTIVE)                   
              OR  END-OF-SYSIPT.                                        
      *                                                                         
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '** ' WS-PGRMNAME ' PROCESSING WARNING  **'       
              DISPLAY '**  COMMIT-ROW-CNT PARM NOT ACTIVE     **'       
              DISPLAY '**  DEFAULT OF 1000 WILL BE USED  **'            
              DISPLAY '**  PROCESSING CONTINUING        **'             
              MOVE 1000 TO WS-READY-TO-COMMIT-COUNT                     
           ELSE                                                         
              IF WS-NO-OF-ROWS-TO-COMMIT NUMERIC                        
                 MOVE WS-NO-OF-ROWS-TO-COMMIT                           
                                         TO WS-READY-TO-COMMIT-COUNT    
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY '**  ' WS-PGRMNAME ' PROCESSING WARNING  **'   
                 DISPLAY '**  COMMIT-ROW-CNT PARM NOT NUMERIC  **'      
                 DISPLAY '**  DEFAULT OF 1000 WILL BE USED  **'         
                 DISPLAY '**  PROCESSING CONTINUING        **'          
                 MOVE 1000 TO WS-READY-TO-COMMIT-COUNT                  
              END-IF                                                    
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           END-IF.                                                      
      *                                                                         
       0115-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0120-GET-DATABASE.                                             *        
      ******************************************************************        
      *                                                                         
       0120-GET-DATABASE.                                               
      *                                                                         
           MOVE 'DATABASE'                TO C8-DELINQ-CD.              
           MOVE '01'                      TO C8-COMPANY-NO.             
           PERFORM 7010-SELECT-DELINQ-VALUE              THRU 7010-EXIT.
           MOVE C8-DELINQ-VALUE           TO WS-DATABASE-KR210.         
      *                                                                         
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0400-PREPARE-PRECOMMIT.                                        *        
      * ISSUE COMMIT IF THE COUNTER REACHED THE LIMIT                           
      ******************************************************************        
      *                                                                         
       0400-PREPARE-COMMIT.                                             
      *                                                                         
           ADD 1                  TO WS-COMMIT-COUNTER.                 
           PERFORM 8890-COMMIT    THRU 8890-EXIT.                       
           MOVE ZEROS             TO WS-RECS-TO-COMMIT-COUNTER.         
      *                                                                         
       0400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   1200-DNP-EXTRACT                                             *        
      ******************************************************************        
      *                                                                         
       1200-DNP-EXTRACT.                                                
      *                                                                         
           INITIALIZE E-FCK210-DATA-REC                                 
                      E-FCK210-DATA-REC1                                
                      E-FCK210-DATA-REC2                                
                      E-FCK210-DATA-REC3                                
                      EMAIL-TO-REC                                      
                      EMAIL-HDN-REC                                     
                      EMAIL-DTL-REC                                     
                      WS-DISC-HIST-UPDT                                 
                      WS-DNP-COMMENT.                                   
P00726*                                                                         
P00726     DISPLAY ' 1200 PARAGRAPH - ACCOUNT NO: ' AT-ACCOUNT-NO       
      *                                                                         
           IF AT-ACCOUNT-NO = CL-ACCOUNT-NO                             
             PERFORM 1300-MULTI-DNP                 THRU 1300-EXIT      
             GO TO 1200-EXIT                                            
           END-IF                                                       
      *                                                                         
           PERFORM 2000-PROCESS-ACCT-AND-CRED-PRO   THRU 2000-EXIT.     
      *                                                                         
           MOVE WS-NEXT-BUSINESS-DAY  TO CL-DATE-NOTICE-DUE             
                                         CL-DATE-NOTICE-MAIL            
                                         CL-DATE-CREDIT-ACTION.         
      *                                                                         
           MOVE ZEROS                 TO WS-BALANCE-DUE.                
           MOVE 'N'                   TO WS-DNP-READY-SW                
                                         WS-SEB-SENIOR-FLAG             
                                         WS-SEB-REG-FLAG.               
      *                                                                         
           PERFORM 3200-CALC-AMOUNTS-DATES          THRU 3200-EXIT.     
      *                                                                         
           EVALUATE WS-NEXT-BUSINESS-DAY                                
             WHEN WS-DATE-CREDIT-ACTION-I                               
               MOVE 'Y'                     TO WS-DNP-READY-SW          
               MOVE WS-DATE-CREDIT-ACTION-I TO CL-DATE-CREDIT-ACTION    
               MOVE WS-AMT-NOTICE-I         TO WS-BALANCE-DUE           
               MOVE WS-I                    TO CL-CODE-NOTICE-TYPE      
               MOVE WS-CODE-SPECIAL-TYPE-I  TO CL-CODE-SPECIAL-TYPE     
               MOVE WS-ITEM-ID-I            TO CL-ITEM-ID               
               MOVE WS-CODE-MESSAGE-TYPE-I  TO CL-CODE-MESSAGE-TYPE     
             WHEN WS-DATE-CREDIT-ACTION-H                               
              MOVE 'Y'                     TO WS-DNP-READY-SW           
              MOVE WS-DATE-CREDIT-ACTION-H TO CL-DATE-CREDIT-ACTION     
A05323        MOVE ZEROES                  TO WS-BALANCE-DUE            
              MOVE WS-H                    TO CL-CODE-NOTICE-TYPE       
              MOVE WS-CODE-SPECIAL-TYPE-H  TO CL-CODE-SPECIAL-TYPE      
              MOVE WS-ITEM-ID-H            TO CL-ITEM-ID                
              MOVE WS-CODE-MESSAGE-TYPE-H  TO CL-CODE-MESSAGE-TYPE      
             WHEN WS-DATE-CREDIT-ACTION-G                               
               MOVE 'Y'                     TO WS-DNP-READY-SW          
               MOVE WS-DATE-CREDIT-ACTION-G TO CL-DATE-CREDIT-ACTION    
               MOVE WS-AMT-NOTICE-G         TO WS-BALANCE-DUE           
               MOVE WS-G                    TO CL-CODE-NOTICE-TYPE      
               MOVE WS-CODE-SPECIAL-TYPE-G  TO CL-CODE-SPECIAL-TYPE     
               MOVE WS-ITEM-ID-G            TO CL-ITEM-ID               
               MOVE WS-CODE-MESSAGE-TYPE-G  TO CL-CODE-MESSAGE-TYPE     
             WHEN WS-DATE-CREDIT-ACTION-D                               
               MOVE 'Y'                     TO WS-DNP-READY-SW          
               MOVE WS-DATE-CREDIT-ACTION-D TO CL-DATE-CREDIT-ACTION    
               MOVE WS-AMT-NOTICE-D         TO WS-BALANCE-DUE           
               MOVE WS-D                    TO CL-CODE-NOTICE-TYPE      
               MOVE WS-CODE-SPECIAL-TYPE-D  TO CL-CODE-SPECIAL-TYPE     
               MOVE WS-ITEM-ID-D            TO CL-ITEM-ID               
               MOVE WS-CODE-MESSAGE-TYPE-D  TO CL-CODE-MESSAGE-TYPE     
           END-EVALUATE.                                                
      *                                                                         
           MOVE WS-BALANCE-DUE       TO CL-AMT-NOTICE.                  
           MOVE AT-ACCOUNT-NO        TO CL-ACCOUNT-NO.                  
      *                                                                         
           PERFORM 1210-VALIDATE-DNP THRU 1210-EXIT.                    
           IF DNP-READY                                                 
             PERFORM 8530-UPDATE-CRED-COLL THRU 8530-EXIT               
             PERFORM 5560-NEW-SERV-ORDERS  THRU 5560-EXIT               
           ELSE                                                         
             PERFORM 1275-DNP-NOT-READY      THRU 1275-EXIT             
           END-IF.                                                      
      *                                                                         
           ADD 1                  TO WS-RECS-TO-COMMIT-COUNTER.         
           IF WS-RECS-TO-COMMIT-COUNTER > WS-READY-TO-COMMIT-COUNT      
              PERFORM 0400-PREPARE-COMMIT   THRU 0400-EXIT              
           END-IF.                                                      
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   1210-VALIDATE-DNP                                            *        
      *   ORDER CHANGED - BANKRUPTCY CHECK BEFORE WHITE CROSS PLUS.    *        
      *   CIA DEBIT CHECK BEFORE WHITE CROSS PLUS.                     *        
      ******************************************************************        
      *                                                                         
       1210-VALIDATE-DNP.                                               
      *                                                                         
ACT210     MOVE SPACES           TO WS-REASON-NOT-DNP.                  
      *                                                                         
           IF DNP-READY                                                 
             PERFORM 1230-CHECK-BANKRUPTCY            THRU 1230-EXIT    
           END-IF.                                                      
      *                                                                         
           IF DNP-READY                                                 
             PERFORM 1231-CHECK-JUDGEMENT THRU 1231-EXIT                
           END-IF                                                       
      *                                                                         
           IF DNP-READY                                                 
               PERFORM 1235-CHECK-FOR-EXEMPTIONS      THRU 1235-EXIT    
           END-IF.                                                      
      *                                                                         
           IF WS-BALANCE-DUE = 0                                        
             MOVE 'N'                    TO WS-DNP-READY-SW             
           END-IF.                                                      
      *                                                                         
           IF DNP-READY                                                 
             PERFORM 1215-CHECK-PENDING-ACCT          THRU 1215-EXIT    
           END-IF.                                                      
      *                                                                         
           IF DNP-READY                                                 
               MOVE AT-ACCOUNT-NO        TO AC-ACCOUNT-NO               
               PERFORM 1266-CHECK-CIA-DEBIT           THRU 1266-EXIT    
           END-IF.                                                      
                                                                        
           IF DNP-READY                                                 
             IF (CSR-DATABASE AND AT-COMPANY-NO = WS-SCEG)              
               PERFORM 1232-CHECK-WHITE-CROSS-PLUS THRU 1232-EXIT       
             END-IF                                                     
           END-IF.                                                      
                                                                        
           IF DNP-READY                                                 
               PERFORM 1220-CHECK-ACTIVE-MED-CERT     THRU 1220-EXIT    
           END-IF.                                                      
      *                                                                         
           IF DNP-READY                                                 
             IF CSR-DATABASE AND AT-COMPANY-NO = WS-SCEG                
               PERFORM 1225-CHK-CT-METER            THRU 1225-EXIT      
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
           IF DNP-READY                                                 
             IF CSR-DATABASE AND AT-COMPANY-NO = WS-SCEG                
               PERFORM 1238-CHECK-FOR-UNMETERED-ONLY  THRU 1238-EXIT    
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
           IF DNP-READY                                                 
             MOVE AT-ACCOUNT-NO        TO MN-ACCOUNT-NO                 
             PERFORM 7020-CHECK-METER-STATUS          THRU 7020-EXIT    
           END-IF.                                                      
      *                                                                         
           IF DNP-READY                                                 
             PERFORM 1240-CHK-PRIOR-NOTIFICATION      THRU 1240-EXIT    
           END-IF.                                                      
      *                                                                         
           IF DNP-READY                                                 
             IF SEB-DATABASE                                            
               PERFORM 1255-CHECK-REGULATED THRU 1255-EXIT              
               IF WS-SEB-SENIOR                                         
                 PERFORM 8510-GENERATE-SR-WQ THRU 8510-EXIT             
               ELSE                                                     
                 PERFORM 1265-CHECK-SO-DATA  THRU 1265-EXIT             
               END-IF                                                   
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       1210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   1215-CHECK-PENDING-ACCT                                      *        
      *                                                                *        
      *   THIS PARAGRAPH CHECKS FOR A DISCONNECT ON A PENDING ACCT.    *        
      *   IF A FORECASTED DNP EXISTS ON A PENDING ACCOUNT, 1.          *        
      *   DISCONNECT HISTORY IS UPDATED                                *        
      ******************************************************************        
      *                                                                         
       1215-CHECK-PENDING-ACCT.                                         
      *                                                                         
           IF AT-CODE-ACCT-STAT = 'P'                                   
             MOVE WS-PENDING-ACCOUNT   TO WS-DNP-COMMENT                
             MOVE 'Y'                  TO WS-DISC-HIST-UPDT             
             MOVE 'N'                  TO WS-DNP-READY-SW               
ACT210       MOVE 'D'                  TO WS-REASON-NOT-DNP             
           END-IF.                                                      
      *                                                                         
       1215-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   1220-CHECK-ACTIVE-MED-CERT                                   *        
      *                                                                *        
      *   THIS PARAGRAPH CHECKS FOR AN ACTIVE MEDICAL CERTIFICATE ON   *        
      *   THE ACCOUNT. IF AN ACTIVE MEDICAL CERTIFICATE EXISTS, 1.     *        
      *   DISCONNECT HISTORY IS UPDATED                                *        
      ******************************************************************        
      *                                                                         
       1220-CHECK-ACTIVE-MED-CERT.                                      
      *                                                                         
           IF WS-CODE-MEDICAL = WS-A                                    
              MOVE WS-ACTIVE-MED-CERT   TO WS-DNP-COMMENT               
              MOVE 'Y'                  TO WS-DISC-HIST-UPDT            
              MOVE 'N'                  TO WS-DNP-READY-SW              
ACT210        MOVE 'D'                  TO WS-REASON-NOT-DNP            
           END-IF.                                                      
      *                                                                         
       1220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   1225-CHK-CT-METER                                            *        
      *                                                                *        
      *   THIS PARAGRAPH CHECKS TO SEE IF THE ACCOUNT HAS A CT METER.  *        
      *   IF ANY OF THESE EXIST A WORKQUEUE IS GENERATED AND THE DNP   *        
      *   IS NOT GENERATED.                                            *        
      *   IF PAST DUE BALANCE IS NOT > 0, THEN WQ IS NOT CREATED.      *        
      ******************************************************************        
      *                                                                         
       1225-CHK-CT-METER.                                               
      *                                                                         
           IF (AT-CT-METER-RATED-IND EQUAL WS-Y   AND                   
               WS-BALANCE-DUE   >  ZERO)                                
             INITIALIZE WS-COMMENTS                                     
             MOVE 108               TO WS-MISC-CATEGORY-ID              
             MOVE 4                 TO WS-MISC-WQ-ROUTE                 
             MOVE WS-WQ-CT-METER    TO WS-WQ-COMMENT-LIT                
             MOVE WS-BALANCE-DUE    TO WS-WQ-DNP-BALANCE                
             MOVE WS-AMT-PAST-DUE   TO WS-WQ-PAST-DUE-BALANCE           
             MOVE WS-TOTAL-BALANCE  TO WS-WQ-BILLED-BALANCE             
             MOVE +136              TO WS-MISC-MSG-LEN                  
             MOVE WS-WQ-COMMENTS    TO WS-MISC-MSG-TEXT                 
             PERFORM 1360-CHECK-WQ-FL              THRU 1360-EXIT       
             PERFORM 1226-CHK-DNP-TYPE             THRU 1226-EXIT       
             MOVE 'N'                  TO WS-DNP-READY-SW               
           END-IF.                                                      
      *                                                                         
       1225-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   1226-CHK-DNP-TYPE                                            *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       1226-CHK-DNP-TYPE.                                               
      *                                                                         
           EVALUATE CL-CODE-NOTICE-TYPE                                 
              WHEN 'D'                                                  
                 MOVE '3'              TO WS-DISCONNECT-HIST-X (1:1)    
                 MOVE WS-DISCONNECT-HIST-X   TO CZ-DISCONNECT-HIST      
              WHEN 'G'                                                  
              WHEN 'H'                                                  
              WHEN 'I'                                                  
                 MOVE '3'              TO WS-DISC-EXCEPTN-HIST (1:1)    
                 MOVE WS-DISC-EXCEPTN-HIST   TO CZ-DISC-EXCEPTN-HIST    
           END-EVALUATE.                                                
           PERFORM 8520-UPDATE-CREDIT-PROFILE     THRU 8520-EXIT.       
      *                                                                         
       1226-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   1230-CHECK-BANKRUPTCY                                        *        
      *                                                                *        
      *   THIS PARAGRAPH CHECKS TO SEE IF ACCOUNT IS BANKRUPT. IF THE  *        
      *   THE ACCOUNT IS BANKRUPT, THE FOLLOWING WILL OCCUR:    1.     *        
      *   DISCONNECT HISTORY IS F DEPED                                *        
      ******************************************************************        
      *                                                                         
       1230-CHECK-BANKRUPTCY.                                           
      *                                                                         
           IF AT-BANKRUPTCY-IND = WS-B                                  
             MOVE WS-BANKRUPTCY        TO WS-DNP-COMMENT                
             MOVE 'Y'                  TO WS-DISC-HIST-UPDT             
             MOVE 'N'                  TO WS-DNP-READY-SW               
ACT210       MOVE 'D'                  TO WS-REASON-NOT-DNP             
           END-IF.                                                      
      *                                                                         
       1230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1231-CHECK-JUDGEMENT.                                          *        
      *                                                                *        
      *   THIS PARAGRAPH CHECKS TO SEE IF ACCOUNT HAS A JUDEMENT.IF    *        
      *   THE ACCOUNT HAS A JUDGEMENT, THE FOLLOWING WILL OCCUR:       *        
      *   1. DISCONNECT HISTORY IS UPDATED                             *        
      ******************************************************************        
      *                                                                         
       1231-CHECK-JUDGEMENT.                                            
      *                                                                         
           IF AT-JUDGEMENT-CASE-NO > SPACES                             
             MOVE WS-JUDGMENT          TO WS-DNP-COMMENT                
             MOVE 'Y'                  TO WS-DISC-HIST-UPDT             
             MOVE 'N'                  TO WS-DNP-READY-SW               
ACT210       MOVE 'D'                  TO WS-REASON-NOT-DNP             
           END-IF.                                                      
      *                                                                         
       1231-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   1232-CHECK-WHITE-CROSS-PLUS                                  *        
      *   THIS PARAGRAPH CHECKS TO SEE IF THE ACCOUNT IS A WHITE CROSS *        
      *   PLUS ACCOUNT.  IF SO, A WQ IS GENERATED AND THE DNP IS NOT   *        
      *   GENERATED.                                                   *        
      *   IF WS-BALANCE-DUE   IS NOT > 0, THEN WQ IS NOT CREATED.      *        
      ******************************************************************        
       1232-CHECK-WHITE-CROSS-PLUS.                                     
      *                                                                         
           IF ((AT-CODE-CRIT-OUTAGE EQUAL WS-WP OR WS-WX) AND           
               (WS-BALANCE-DUE   >  ZERO))                              
             INITIALIZE WS-COMMENTS                                     
             MOVE 441                    TO WS-MISC-CATEGORY-ID         
             MOVE 4                      TO WS-MISC-WQ-ROUTE            
             MOVE WS-WQ-WHITE-CROSS-PLUS TO WS-WQ-COMMENT-LIT           
             MOVE WS-BALANCE-DUE         TO WS-WQ-DNP-BALANCE           
             MOVE WS-AMT-PAST-DUE        TO WS-WQ-PAST-DUE-BALANCE      
             MOVE WS-TOTAL-BALANCE       TO WS-WQ-BILLED-BALANCE        
             MOVE +136                   TO WS-MISC-MSG-LEN             
             MOVE WS-WQ-COMMENTS         TO WS-MISC-MSG-TEXT            
             PERFORM 1360-CHECK-WQ-FL              THRU 1360-EXIT       
             PERFORM 1226-CHK-DNP-TYPE             THRU 1226-EXIT       
             MOVE 'N'                  TO WS-DNP-READY-SW               
           END-IF.                                                      
      *                                                                         
       1232-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   1235-CHECK-FOR-EXEMPTIONS                                    *        
      *                                                                *        
      *   THIS PARAGRAPH CHECKS TO SEE IF AT-CODE-DISC-OK IS SET FOR   *        
      *   CREDIT ACTION EXEMPTIONS. IF THE ACCT IS EXEMPT:      1.     *        
      *   DISCONNECT HISTORY IS UPDATED                                *        
      *   ALL RULES WILL BE DONE BY IVR RETRIEVAL RPC AND NOT IN HERE. *        
      ******************************************************************        
      *                                                                         
       1235-CHECK-FOR-EXEMPTIONS.                                       
      *                                                                         
           EVALUATE AT-CODE-DISC-OK                                     
              WHEN SPACES                                               
                 CONTINUE                                               
              WHEN  WS-A                                                
                 IF CL-CODE-NOTICE-TYPE = WS-D                          
                   MOVE 'Y'                  TO WS-DISC-HIST-UPDT       
                   MOVE WS-DNP-EXEMPTION     TO WS-DNP-COMMENT          
                   MOVE 'N'                  TO WS-DNP-READY-SW         
ACT210             MOVE 'D'                  TO WS-REASON-NOT-DNP       
                 END-IF                                                 
              WHEN  WS-B                                                
                 IF CL-CODE-NOTICE-TYPE = WS-G OR WS-H OR WS-I          
                   MOVE 'Y'                  TO WS-DISC-HIST-UPDT       
                   MOVE WS-DNP-EXEMPTION     TO WS-DNP-COMMENT          
                   MOVE 'N'                  TO WS-DNP-READY-SW         
ACT210             MOVE 'D'                  TO WS-REASON-NOT-DNP       
                 END-IF                                                 
              WHEN OTHER                                                
                 MOVE 'Y'                    TO WS-DISC-HIST-UPDT       
                 MOVE WS-DNP-EXEMPTION       TO WS-DNP-COMMENT          
                 MOVE 'N'                    TO WS-DNP-READY-SW         
ACT210           MOVE 'D'                    TO WS-REASON-NOT-DNP       
           END-EVALUATE.                                                
      *                                                                         
       1235-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   1238-CHECK-FOR UNMETERED-ONLY                                *        
      *   THIS PARAGRAPH CHECKS TO SEE IF THE CUSTOMER HAS UNMETERED   *        
      *   SERVICES ONLY.                                               *        
      *   IF A UTILITY ACCOUNT HAS ONLY UNMETERED SERVICES -           *        
      *     A)  DOES NOT HAVE AN ENTRY IN CSS_MTRD_ENVRNMNT AND        *        
      *     B)  DOES HAVE AN ENTRY IN CSS_CUST_PLAN                    *        
      *   A WORK QUEUE IS CREATED BUT A DNP IS NOT GENERATED.          *        
      ******************************************************************        
       1238-CHECK-FOR-UNMETERED-ONLY.                                   
      *                                                                         
           MOVE AT-ACCOUNT-NO         TO MN-ACCOUNT-NO.                 
           PERFORM 7240-CHECK-MTRD-ENVRNMT        THRU 7240-EXIT.       
      *                                                                         
           IF WS-MTRD-ENVRNMT = 'N'                                     
             MOVE AT-ACCOUNT-NO     TO CP-ACCOUNT-NO                    
             PERFORM 7270-CHECK-CUST-PLAN       THRU 7270-EXIT          
             MOVE 'N'               TO WS-DNP-READY-SW                  
             INITIALIZE WS-COMMENTS                                     
             MOVE 135               TO WS-MISC-CATEGORY-ID              
             MOVE 4                 TO WS-MISC-WQ-ROUTE                 
             MOVE WS-WQ-LIGHT-ONLY-ACCOUNT    TO WS-WQ-COMMENT-LIT      
             MOVE WS-BALANCE-DUE    TO WS-WQ-DNP-BALANCE                
             MOVE WS-AMT-PAST-DUE   TO WS-WQ-PAST-DUE-BALANCE           
             MOVE WS-TOTAL-BALANCE  TO WS-WQ-BILLED-BALANCE             
             MOVE +136              TO WS-MISC-MSG-LEN                  
             MOVE WS-WQ-COMMENTS    TO WS-MISC-MSG-TEXT                 
             PERFORM 1360-CHECK-WQ-FL           THRU 1360-EXIT          
           END-IF.                                                      
      *                                                                         
       1238-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   1240-CHK-PRIOR-NOTIFICATION                                  *        
      *                                                                *        
      *   THIS PARAGRAPH CHECKS TO SEE IF THE CUSTOMER RECEIVED PRIOR  *        
      *   NOTIFICATION.  IF THE CUSTOMER DID NOT RECEIVE SOME TYPE     *        
      *   OF NOTIFICATION, THE DISCONNECT CANNOT OCCUR.                *        
      *   IF WS-BALANCE-DUE = 0, WQ WILL NOT BE GENERATED.             *        
      ******************************************************************        
      *                                                                         
       1240-CHK-PRIOR-NOTIFICATION.                                     
      *                                                                         
           EVALUATE CL-CODE-NOTICE-TYPE                                 
             WHEN WS-D                                                  
                  IF WS-DATE-NOTICE-MAIL-C = LOW-VALUES                 
                    MOVE 'N'         TO WS-DNP-READY-SW                 
                  END-IF                                                
             WHEN WS-G                                                  
                  IF WS-DATE-NOTICE-MAIL-F = LOW-VALUES                 
                    IF (CSR-DATABASE AND AT-COMPANY-NO = WS-PSNC        
                       AND CL-CODE-SPECIAL-TYPE = 'Q')                  
                      CONTINUE                                          
                    ELSE                                                
                      MOVE 'N'         TO WS-DNP-READY-SW               
                    END-IF                                              
                  END-IF                                                
             WHEN WS-H                                                  
                  IF WS-DATE-NOTICE-MAIL-N = LOW-VALUES                 
                    MOVE 'N'         TO WS-DNP-READY-SW                 
                  END-IF                                                
             WHEN WS-I                                                  
                  IF WS-DATE-NOTICE-MAIL-O = LOW-VALUES                 
                    MOVE 'N'         TO WS-DNP-READY-SW                 
                  END-IF                                                
           END-EVALUATE.                                                
                                                                        
           IF WS-BALANCE-DUE > ZEROES                                   
             IF  DNP-NOT-READY                                          
               INITIALIZE WS-COMMENTS                                   
               MOVE 56 TO WS-MISC-CATEGORY-ID                           
P0599A         MOVE 4  TO WS-MISC-WQ-ROUTE                              
               PERFORM 1360-CHECK-WQ-FL              THRU 1360-EXIT     
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       1240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   1255-CHECK-REGULATED                                         *        
      *   THIS PARAGRAPH SELECTS THE MOST RECENT 'DNP01' ORDER FROM    *        
      *   CSS_SO_DATA.                                                 *        
      *   AN ORDER-STATE-CD = 'A' AND 2ND POSITION OF ORDER-REASON = 'P'        
      *   INDICATES AN ACTIVE/CANCEL PENDING STATUS DNP.               *        
      ******************************************************************        
      *                                                                         
       1255-CHECK-REGULATED.                                            
      *                                                                         
           PERFORM 7040-CHECK-FOR-REGULATED            THRU 7040-EXIT.  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             MOVE 'Y' TO WS-SEB-REG-FLAG                                
             IF LR-SENIOR-FL = 'Y' AND LR-REG-GROUP-CD = '100'          
               MOVE 'Y' TO WS-SEB-SENIOR-FLAG                           
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       1255-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   1265-CHECK-SO-DATA                                           *        
      *   THIS PARAGRAPH SELECTS THE MOST RECENT 'DNP01' ORDER FROM    *        
      *   CSS_SO_DATA.                                                 *        
      *   AN ORDER-STATE-CD = 'A' AND 2ND POSITION OF ORDER-REASON = 'P'        
      *   INDICATES AN ACTIVE/CANCEL PENDING STATUS DNP.               *        
      ******************************************************************        
      *                                                                         
       1265-CHECK-SO-DATA.                                              
      *                                                                         
           MOVE AT-ACCOUNT-NO           TO VO-ACCOUNT-NO                
           PERFORM 7125-SELECT-SO-DATA             THRU 7125-EXIT.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      MULTIPLE-ROWS                     
              EVALUATE CL-CODE-SPECIAL-TYPE                             
               WHEN WS-N                                                
               WHEN WS-O                                                
               WHEN WS-J                                                
               WHEN WS-K                                                
               WHEN WS-U                                                
               WHEN WS-V                                                
                 EVALUATE VO-ORDER-STATE-CD                             
                   WHEN WS-A                                            
                     IF (VO-ORDER-REASON(1:1) = WS-H OR WS-M OR WS-S    
                            OR WS-X)                                    
                         OR (VO-ORDER-REASON(2:1) = WS-P)               
ACT210                 MOVE 'E'               TO WS-REASON-NOT-DNP      
                       MOVE 'N'               TO WS-DNP-READY-SW        
                       MOVE 'Y'               TO WS-DISC-HIST-UPDT      
                     END-IF                                             
                   WHEN WS-Z                                            
                      IF VO-ORDER-REASON(1:1) = WS-N OR WS-O OR WS-J OR 
                                                WS-K OR WS-U OR WS-V    
                        PERFORM 7135-SELECT-SO-REMARKS  THRU 7135-EXIT  
                        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR   
                                                    MULTIPLE-ROWS       
                          IF EF-REMARK-TX-TEXT(17:10) >                 
                                                    AT-DATE-BILL-DAY-00 
ACT210                      MOVE 'B'            TO WS-REASON-NOT-DNP    
                            MOVE 'N'            TO WS-DNP-READY-SW      
                            MOVE 'Y'            TO WS-DISC-HIST-UPDT    
                          END-IF                                        
                        END-IF                                          
                      END-IF                                            
                   WHEN WS-H                                            
                   WHEN WS-B                                            
                   WHEN WS-D                                            
ACT210                MOVE 'E'               TO WS-REASON-NOT-DNP       
                      MOVE 'N'               TO WS-DNP-READY-SW         
                      MOVE 'Y'               TO WS-DISC-HIST-UPDT       
                 END-EVALUATE                                           
               WHEN OTHER                                               
                 EVALUATE VO-ORDER-STATE-CD                             
                   WHEN WS-A                                            
                      IF (VO-ORDER-REASON(1:1) = WS-N OR WS-O OR WS-J OR
                                                WS-K OR WS-U OR WS-V) OR
                         (VO-ORDER-REASON(2:1) = WS-P)                  
ACT210                  MOVE 'E'               TO WS-REASON-NOT-DNP     
                        MOVE 'N'               TO WS-DNP-READY-SW       
                        MOVE 'Y'               TO WS-DISC-HIST-UPDT     
                      END-IF                                            
                   WHEN WS-H                                            
                   WHEN WS-B                                            
                   WHEN WS-D                                            
ACT210                MOVE 'E'               TO WS-REASON-NOT-DNP       
                      MOVE 'N'               TO WS-DNP-READY-SW         
                      MOVE 'Y'               TO WS-DISC-HIST-UPDT       
                 END-EVALUATE                                           
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                         
       1265-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   1266-CHECK-CIA-DEBIT                                         *        
      *   CHECKS FOR CIA DEBIT AND IF IT EXISTS CREATES WORK QUEUE     *        
      ******************************************************************        
      *                                                                         
       1266-CHECK-CIA-DEBIT.                                            
      *                                                                         
           PERFORM 7030-CHECK-FOR-CIA-DEBIT     THRU 7030-EXIT.         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             MOVE 'N' TO WS-DNP-READY-SW                                
             MOVE 124 TO WS-MISC-CATEGORY-ID                            
P0599A       MOVE 4   TO WS-MISC-WQ-ROUTE                               
             MOVE WS-CIA-DEBIT TO WS-MISC-MSG-TEXT                      
             MOVE +79 TO WS-MISC-MSG-LEN                                
             PERFORM 1360-CHECK-WQ-FL       THRU 1360-EXIT              
           END-IF.                                                      
      *                                                                         
       1266-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   1275-DNP-NOT-READY                                           *        
      * IF ACCT HAS A CT METER DO NOT DELETE DNP ROW AS DNP ROW IS     *        
      * REQUIRED WHEN A MANUAL DNP IS SET UP AFTER WQ IS CREATED       *        
      * CPD00068 WILL THEN CALCULATE THE CORRECT DNP BALANCE WHEN      *        
      * WHEN A PAYMENT COMES IN AFTER MANUAL DNP WAS SET UP.           *        
      * TREAT WHITE CROSS PLUS THE SAME.                               *        
      ******************************************************************        
      *                                                                         
       1275-DNP-NOT-READY.                                              
      *                                                                         
           IF WS-BALANCE-DUE > ZEROES                                   
             IF ((CSR-DATABASE AND AT-COMPANY-NO = WS-SCEG) AND         
                 (AT-CT-METER-RATED-IND EQUAL WS-Y) OR                  
                 (AT-CODE-CRIT-OUTAGE   EQUAL WS-WP OR WS-WX))          
               MOVE AT-ACCOUNT-NO  TO CL-ACCOUNT-NO                     
               MOVE WS-BALANCE-DUE TO CL-AMT-NOTICE                     
               PERFORM 8530-UPDATE-CRED-COLL THRU 8530-EXIT             
               GO TO 1275-EXIT                                          
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
           IF WS-DISC-HIST-UPDT = 'Y'                                   
             PERFORM 2200-PROCESS-DIS-HIST-PLUS THRU 2200-EXIT          
           END-IF.                                                      
      *                                                                         
           PERFORM 8650-DELETE-CRED-COLL        THRU 8650-EXIT.         
      *                                                                         
       1275-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1300-CHECK-FOR-MULTI-DNP                                       *        
      ******************************************************************        
      *                                                                         
       1300-MULTI-DNP.                                                  
      *                                                                         
           INITIALIZE WS-TRAN-APPL-NO.                                  
           PERFORM 5540-MAINT-TRANS-HIST       THRU 5540-EXIT.          
           PERFORM 5550-MOVE-DNP-DETAILS       THRU 5550-EXIT.          
           PERFORM 1310-WRITE-MULT-DNP-WQ      THRU 1310-EXIT.          
           PERFORM 8650-DELETE-CRED-COLL       THRU 8650-EXIT.          
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1310-WRITE-MULT-DNP-WQ                                         *        
      ******************************************************************        
      *                                                                         
       1310-WRITE-MULT-DNP-WQ.                                          
      *                                                                         
           MOVE +162                           TO WS-MISC-CATEGORY-ID.  
           MOVE 'H'                            TO WS-MISC-PRIORITY.     
           MOVE WS-WQ-MULTI-DNP                TO WS-MISC-MSG-TEXT.     
           MOVE +52                            TO WS-MISC-MSG-LEN.      
           PERFORM 1360-CHECK-WQ-FL            THRU 1360-EXIT.          
           MOVE ' '                            TO WS-MISC-PRIORITY.     
      *                                                                         
       1310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1360-CHECK-WQ-FL                                               *        
      ******************************************************************        
      *                                                                         
       1360-CHECK-WQ-FL.                                                
      *                                                                         
           MOVE SPACES                           TO WS-REG-GRP-CD.      
           MOVE SPACE                            TO WS-SEN-FL.          
           MOVE WS-PGRMNAME                      TO WS-SRCE-PGM-ID.     
           MOVE AT-COMPANY-NO                    TO WS-COMP-NO.         
           MOVE WS-MISC-CATEGORY-ID              TO WS-CATEGORY-ID.     
      *                                                                         
           IF SEB-DATABASE                                              
             PERFORM 7040-CHECK-FOR-REGULATED  THRU 7040-EXIT           
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
               MOVE LR-REG-GROUP-CD TO WS-REG-GRP-CD                    
               MOVE LR-SENIOR-FL    TO WS-SEN-FL                        
             END-IF                                                     
           END-IF.                                                      
           PERFORM 4900-GET-WQ-GEN-FL          THRU 4900-CPD346-EXIT.   
      *                                                                         
           IF WS-WQ-GEN-FL = 'Y'                                        
             PERFORM 2810-CREATE-WORK-QUEUE    THRU 2810-EXIT           
           END-IF.                                                      
      *                                                                         
           IF FL-NOT-FOUND                                              
             PERFORM 8500-WRITE-FCSKR210-FILE  THRU 8500-EXIT           
           END-IF.                                                      
      *                                                                         
       1360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   2000-PROCESS-ACCT-AND-CRED-PRO.                              *        
      *     SELECT FROM CSS_ACCOUNT THE DATA THAT THE ACCOUNT WILL BE  *        
      *     PROCESSED.  THE CSS_CREDIT_PROCESS WILL BE USED TO UPDATE  *        
      *     THE CREDIT HISTORY.                                        *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-ACCT-AND-CRED-PRO.                                  
      *                                                                         
           MOVE AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT.      
           MOVE AT-ACCOUNT-NO            TO CZ-ACCOUNT-NO.              
           PERFORM 7170-SELECT-CREDIT-PROFILE THRU 7170-EXIT.           
           MOVE CZ-DISCONNECT-HIST       TO WS-DISCONNECT-HIST-X.       
           MOVE CZ-DISC-EXCEPTN-HIST     TO WS-DISC-EXCEPTN-HIST.       
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      ******************************************************************        
      * 2010-LOAD-ORDER-RSN-PRTY.                                      *        
      ******************************************************************        
       2010-LOAD-ORDER-RSN-PRTY.                                        
      *                                                                         
           PERFORM 7430-OPEN-ORDER-RSN-CSR           THRU 7430-EXIT.    
           PERFORM 7440-FETCH-ORDER-RSN-CSR          THRU 7440-EXIT.    
           MOVE   1               TO WS-INDEX.                          
ACT371     SET WS-RANGE-INDEX     TO 1.                                 
           PERFORM 2020-LOAD-ORDER-PRTY-CD-TBL       THRU 2020-EXIT     
             UNTIL WS-INDEX > WS-ORDER-ROW-COUNT                        
             OR WS-ORDER-REASON-CD(WS-INDEX) = SPACES                   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             INITIALIZE WS-MISC-HOST-VARIABLES                          
             PERFORM 7440-FETCH-ORDER-RSN-CSR      THRU 7440-EXIT       
             MOVE   1           TO WS-INDEX                             
             PERFORM 2020-LOAD-ORDER-PRTY-CD-TBL   THRU 2020-EXIT       
               UNTIL WS-INDEX > WS-ORDER-ROW-COUNT                      
               OR WS-ORDER-REASON-CD(WS-INDEX) = SPACES                 
           END-IF.                                                      
           PERFORM 7450-CLOSE-ORDER-RSN-CSR          THRU 7450-EXIT.    
      *                                                                         
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2020-LOAD-ORDER-PRTY-CD-TBL.                                   *        
      ******************************************************************        
      *                                                                         
       2020-LOAD-ORDER-PRTY-CD-TBL.                                     
      *                                                                         
           MOVE WS-COMPANY-NUM(WS-INDEX)           TO                   
                               WS-COMPANY-NO1(WS-RANGE-INDEX)           
           MOVE WS-ORDER-TYPE-CD(WS-INDEX)         TO                   
                               WS-ORDER-TYPE-CD1(WS-RANGE-INDEX)        
           MOVE WS-ORDER-REASON-CD(WS-INDEX)       TO                   
                               WS-ORDER-REASON-CD1(WS-RANGE-INDEX)      
           MOVE WS-ACCOUNT-TYPE-CD(WS-INDEX)       TO                   
                               WS-ACCOUNT-TYPE-CODE1(WS-RANGE-INDEX)    
           MOVE WS-ORDER-MIN-AM(WS-INDEX)          TO                   
                               WS-ORDER-MIN-AM1(WS-RANGE-INDEX)         
           MOVE WS-ORDER-MAX-AM(WS-INDEX)          TO                   
                               WS-ORDER-MAX-AM1(WS-RANGE-INDEX)         
           MOVE WS-ORDER-PRIORITY-CD(WS-INDEX)     TO                   
                               WS-ORDER-PRIORITY-CD1(WS-RANGE-INDEX)    
           MOVE WS-EFFECTIVE-DT(WS-INDEX)          TO                   
                               WS-EFFECTIVE-DT1(WS-RANGE-INDEX)         
           MOVE WS-LAST-UPDATE-TS(WS-INDEX)        TO                   
                               WS-LAST-UPDATE-TS1(WS-RANGE-INDEX)       
           MOVE WS-LAST-UPDATE-USERID(WS-INDEX)    TO                   
                               WS-LAST-UPDATE-USERID1(WS-RANGE-INDEX)   
           SET WS-RANGE-INDEX UP BY 1.                                  
           ADD 1           TO WS-INDEX.                                 
      *                                                                         
       2020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   2200-PROCESS-DISCONNECT-HIST.                                *        
      *    MOVE EXEMPT TO THE CREDIT PROFILE FOR A REGULAR ACCOUNT.    *        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-DIS-HIST-PLUS.                                      
      *                                                                         
           INITIALIZE WS-TRAN-APPL-NO.                                  
      *                                                                         
           IF CL-CODE-NOTICE-TYPE = 'D'                                 
             MOVE CZ-DISCONNECT-HIST     TO WS-OLD-DISC-HIST            
             MOVE 'Y'                    TO WS-DISCONNECT-FLAG          
             MOVE WS-E                   TO WS-DISCONNECT-HIST-X(1:1)   
           ELSE                                                         
             MOVE CZ-DISC-EXCEPTN-HIST   TO WS-OLD-DISCEX-HIST          
             MOVE 'Y'                    TO WS-EXCEPTIONAL-FLAG         
             MOVE WS-E                   TO WS-DISC-EXCEPTN-HIST(1:1)   
           END-IF.                                                      
           MOVE WS-DISCONNECT-HIST-X     TO CZ-DISCONNECT-HIST.         
           MOVE WS-DISC-EXCEPTN-HIST     TO CZ-DISC-EXCEPTN-HIST.       
           PERFORM 8520-UPDATE-CREDIT-PROFILE       THRU 8520-EXIT.     
           PERFORM 5525-MAINT-TRANS-HIST            THRU 5525-EXIT.     
           PERFORM 5530-MOVE-HIST-DETAILS           THRU 5530-EXIT.     
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   2300-SEND-ORDER-PRIORITY-WQ.                                 *        
      ******************************************************************        
      *                                                                         
       2300-SEND-ORDER-PRIORITY-WQ.                                     
      *                                                                         
           INITIALIZE WS-COMMENTS.                                      
      *                                                                         
           MOVE 'N'                           TO WS-MISC-PRIORITY.      
           MOVE WS-WQ-COMMENTS                TO WS-MISC-MSG-TEXT.      
           MOVE +153                          TO WS-MISC-MSG-LEN.       
           MOVE +490                          TO WS-MISC-CATEGORY-ID.   
      *                                                                         
           IF CSR-DATABASE                                              
             MOVE 5                          TO WS-MISC-WQ-ROUTE        
           ELSE                                                         
             MOVE 4                          TO WS-MISC-WQ-ROUTE        
           END-IF.                                                      
      *                                                                         
           IF CSR-DATABASE                                              
             IF AT-COMPANY-NO = '01'                                    
ACT034         MOVE '595'                    TO WS-77-RESP-AREA-ID      
             ELSE                                                       
ACT034         MOVE 'P10'                    TO WS-77-RESP-AREA-ID      
             END-IF                                                     
           ELSE                                                         
ACT034       MOVE 'G44'                      TO WS-77-RESP-AREA-ID      
           END-IF                                                       
      *                                                                         
           PERFORM 1360-CHECK-WQ-FL          THRU 1360-EXIT.            
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2810-CREATE-WORK-QUEUE                                         *        
      ******************************************************************        
      *                                                                         
       2810-CREATE-WORK-QUEUE.                                          
      *                                                                         
ACT034     INITIALIZE CWS00077-FIELDS.                                  
ACT034     INITIALIZE WS-77-COMMENTS.                                   
ACT034*                                                                         
      * POPULATE WORK QUEUE VARIABLE FOR INSERT WORK QUEUE                      
ACT034     MOVE AT-ACCOUNT-NO             TO WS-77-ACCOUNT-NO.          
ACT034     MOVE AT-CUSTOMER-NO            TO WS-77-CUSTOMER-NO.         
ACT034     MOVE AT-PREMISE-NO             TO WS-77-PREMISE-NO.          
ACT034     MOVE AT-LOCAL-OFFICE           TO WS-77-LOCAL-OFFICE.        
ACT034     MOVE WS-MISC-CATEGORY-ID       TO WS-77-CATEGORY-ID.         
ACT034     MOVE WS-MISC-MSG-TEXT          TO WS-77-COMMENTS-TEXT.       
ACT034     MOVE WS-MISC-MSG-LEN           TO WS-77-COMMENTS-LEN.        
ACT034     MOVE WS-MISC-WQ-ROUTE          TO WS-77-ROUTE-CATEGORY.      
           IF WS-MISC-PRIORITY = SPACES                                 
ACT034       MOVE WS-N                    TO WS-77-PRIORITY             
           ELSE                                                         
ACT034       MOVE WS-MISC-PRIORITY        TO WS-77-PRIORITY             
           END-IF.                                                      
ACT034     MOVE WS-INPUT-DATE             TO WS-INPUT-DATE-26(1:10).    
ACT034     MOVE WS-INPUT-ZERO             TO WS-INPUT-DATE-26(11:16).   
ACT034     MOVE WS-INPUT-DATE-26          TO WS-77-DATE-CREATED.        
ACT034     MOVE WS-NEXT-BUSINESS-DAY      TO WS-77-DATE-REQUIRED.       
ACT034     MOVE WS-PGRMNAME               TO WS-77-CREATED-BY.          
           PERFORM 8895-INSERT-WORK-QUEUE           THRU 8895-EXIT.     
      *                                                                         
       2810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3200-CALC-AMOUNTS-DATES                                        *        
      * PERFORM ROUTINE THAT CALCULATES DNP-BAL, ARREARS, PAST DUE     *        
      * ETC, AND MOVE VALUES TO CWS10007 FOR USE BY OTHER PROGRAMS     *        
      ******************************************************************        
      *                                                                         
       3200-CALC-AMOUNTS-DATES.                                         
      *                                                                         
      *SET CPD00068 SWITCHES THAT ARE NEEDED                                    
           MOVE 'Y'         TO CALC-ARREARS-SW                          
                               CALC-BALANCE-SW                          
                               CALC-PAST-DUE-SW                         
                               LOAD-DNP-DATE-SW                         
                               LOAD-DUE-DATES-SW                        
                               LOAD-WS-AMOUNTS-SW.                      
      *                                                                         
           INITIALIZE          WS-DATE-CREDIT-ACTION-D                  
                               WS-DATE-CREDIT-ACTION-G                  
                               WS-DATE-CREDIT-ACTION-H                  
                               WS-DATE-CREDIT-ACTION-I                  
                               WS-AMT-NOTICE-D                          
                               WS-AMT-NOTICE-G                          
                               WS-AMT-NOTICE-H                          
                               WS-AMT-NOTICE-I.                         
      *                                                                         
           MOVE 'PCSCA132'              TO PROGRAM-NAME                 
                                           WS-CPD00068-CALLING-PGM.     
           MOVE SPACES                  TO  ABEND-FUNCTION.             
           CALL SCSCB068  USING  CWS00068-FIELDS,                       
                                 WS-CODES-DATA-PRESENT,                 
                                 DCLCSS-ACCOUNT,                        
                                 ABEND-FILE,                            
                                 RS-RETURN-CODE.                        
           MOVE 'PCSKR210'              TO PROGRAM-NAME.                
           IF  ABEND-FUNCTION  > SPACES                                 
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 4900-GET-WQ-GEN-FL                                             *        
      * 5200-SEARCH-WQ-PGM-CNTL-TBL                                    *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00346                                                  
           END-EXEC.                                                            
      *                                                                         
P00599******************************************************************        
P00599* 5200-CHK-SKIP-ACCTS                                      *              
P00599******************************************************************        
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE CPD00347                                                 
P00599     END-EXEC.                                                            
P00599*                                                                         
      *****************************************************************         
      * 5525-MAINT-TRANS-HIST.                                        *         
      *   CREDIT HISTORY CHANGE                                       *         
      *****************************************************************         
      *                                                                         
       5525-MAINT-TRANS-HIST.                                           
      *                                                                         
           PERFORM 7000-GET-TIMESTAMP            THRU 7000-EXIT.        
           MOVE WS-TIMESTAMP                   TO MH-TRANS-HIST-SEQ-NO  
           MOVE WS-INPUT-DATE                  TO MH-DATE-TRANS         
           MOVE 'F'                            TO MH-CODE-TRAN-TYPE.    
           MOVE SPACES                         TO MH-RESP-AREA-ID.      
           MOVE AT-ACCOUNT-NO                  TO MH-ACCOUNT-NO.        
           MOVE ZEROS                          TO MH-CUSTOMER-NO        
                                                 MH-PREMISE-NO.         
           MOVE 'SYSTEM'                       TO MH-USER-ID.           
           MOVE 'PCSKR210'                     TO MH-APPL-PROGRAM-ID.   
           MOVE WS-DNP-HIST-TRANS-CMNT         TO MH-TRAN-COMMENT-TEXT. 
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT TO MH-TRAN-COMMENT-LEN.  
      *                                                                         
       5525-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  5530-MOVE-HIST-DETAILS                                        *        
      *     CREDIT HISTORY CHANGE DETAILS                              *        
      ******************************************************************        
      *                                                                         
       5530-MOVE-HIST-DETAILS.                                          
      *                                                                         
           ADD 1                        TO WS-TRAN-APPL-NO.             
           MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
           MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
           MOVE SPACES                  TO MI-TABLE-ID.                 
           IF WS-DISCONNECT-FLAG     = 'Y'                              
             MOVE 'N'                   TO WS-DISCONNECT-FLAG           
             MOVE WS-OLD-DISC-HIST      TO MI-PRV-COLUMN-VALUE-TEXT     
             MOVE WS-DISCONNECT-DESC    TO MI-COLUMN-DESC               
             MOVE CZ-DISCONNECT-HIST    TO MI-CHG-COLUMN-VALUE-TEXT     
           END-IF.                                                      
           IF WS-EXCEPTIONAL-FLAG     = 'Y'                             
             MOVE 'N'                   TO WS-EXCEPTIONAL-FLAG          
             MOVE WS-OLD-DISCEX-HIST    TO MI-PRV-COLUMN-VALUE-TEXT     
             MOVE WS-DISC-EXCEPTN-DESC  TO MI-COLUMN-DESC               
             MOVE CZ-DISC-EXCEPTN-HIST  TO MI-CHG-COLUMN-VALUE-TEXT     
           END-IF.                                                      
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                        TO MI-PRV-COLUMN-VALUE-LEN.     
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                         TO MI-CHG-COLUMN-VALUE-LEN.    
      * NEED TO CHANGE COMMENT IF 'E' OR 'B'                                    
      * COMMENT HAS ALREADY BEEN SET IN OTHER PLACES                            
ACT210     EVALUATE WS-REASON-NOT-DNP                                   
               WHEN WS-E                                                
                  MOVE WS-CURRENT-DNP-STATUS-E TO WS-DNP-COMMENT        
                  MOVE WS-DNP-HIST-TRANS-CMNT  TO MH-TRAN-COMMENT-TEXT  
                  MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                   
                                               TO MH-TRAN-COMMENT-LEN   
               WHEN WS-B                                                
                  MOVE WS-CURRENT-DNP-STATUS-B TO WS-DNP-COMMENT        
                  MOVE WS-DNP-HIST-TRANS-CMNT  TO MH-TRAN-COMMENT-TEXT  
                  MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                   
                                               TO MH-TRAN-COMMENT-LEN   
           END-EVALUATE.                                                
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
      *                                                                         
       5530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5540-MAINT-TRANS-HIST.                                        *         
      *   MULTIPLE DNP DELETED                                        *         
      *****************************************************************         
      *                                                                         
       5540-MAINT-TRANS-HIST.                                           
      *                                                                         
           PERFORM 7000-GET-TIMESTAMP            THRU 7000-EXIT.        
           MOVE WS-TIMESTAMP                   TO MH-TRANS-HIST-SEQ-NO  
           MOVE WS-INPUT-DATE                  TO MH-DATE-TRANS         
           MOVE 'F'                            TO MH-CODE-TRAN-TYPE.    
           MOVE SPACES                         TO MH-RESP-AREA-ID.      
           MOVE AT-ACCOUNT-NO                  TO MH-ACCOUNT-NO.        
           MOVE ZEROS                          TO MH-CUSTOMER-NO        
                                                 MH-PREMISE-NO.         
           MOVE 'SYSTEM'                       TO MH-USER-ID.           
           MOVE 'PCSKR210A'                    TO MH-APPL-PROGRAM-ID.   
           MOVE WS-DNP-HIST-TRANS-CMNT2        TO MH-TRAN-COMMENT-TEXT. 
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT TO MH-TRAN-COMMENT-LEN.  
      *                                                                         
       5540-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  5550-MOVE-DNP-DETAILS                                         *        
      *     MULTIPLE DNP TRANS DETAILS                                 *        
      ******************************************************************        
      *                                                                         
       5550-MOVE-DNP-DETAILS.                                           
      *                                                                         
           ADD 1                        TO WS-TRAN-APPL-NO.             
           MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
           MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
           MOVE SPACES                  TO MI-TABLE-ID.                 
           MOVE +11                     TO MI-CHG-COLUMN-VALUE-LEN.     
           MOVE +10                     TO MI-PRV-COLUMN-VALUE-LEN.     
           MOVE '**DELETED**'           TO MI-CHG-COLUMN-VALUE-TEXT.    
           MOVE CL-DATE-CREDIT-ACTION   TO MI-PRV-COLUMN-VALUE-TEXT.    
           MOVE 'DNP DATE'              TO MI-COLUMN-DESC.              
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                        TO WS-TRAN-APPL-NO              
           MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
           MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
           MOVE SPACES                  TO MI-TABLE-ID.                 
           MOVE +11                     TO MI-CHG-COLUMN-VALUE-LEN.     
           MOVE +14                     TO MI-PRV-COLUMN-VALUE-LEN.     
           MOVE '**DELETED**'           TO MI-CHG-COLUMN-VALUE-TEXT.    
           EVALUATE CL-CODE-NOTICE-TYPE                                 
             WHEN 'D'                                                   
                MOVE 'NORMAL'           TO MI-PRV-COLUMN-VALUE-TEXT     
             WHEN 'G'                                                   
                MOVE 'EXCEPTIONAL'      TO MI-PRV-COLUMN-VALUE-TEXT     
             WHEN 'H'                                                   
                MOVE 'RETURNED CHECK'   TO MI-PRV-COLUMN-VALUE-TEXT     
             WHEN 'I'                                                   
                MOVE 'DEPOSIT'          TO MI-PRV-COLUMN-VALUE-TEXT     
           END-EVALUATE.                                                
           MOVE 'DNP TYPE'              TO MI-COLUMN-DESC.              
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
      *                                                                         
       5550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *     5560-NEW-SERV-ORDERS                                       *        
      ******************************************************************        
      *                                                                         
       5560-NEW-SERV-ORDERS.                                            
      *                                                                         
           MOVE 'DNP01'       TO WS-ORDER-TYPE.                         
           MOVE AT-COMPANY-NO TO WS-DNP-CO-NO.                          
           PERFORM 6000-INSERT-NEW-SO        THRU 6000-EXIT.            
           PERFORM 7400-OPEN-MTRD-ENV-CSR    THRU 7400-EXIT.            
           PERFORM 7410-FETCH-MTRD-ENV-CSR   THRU 7410-EXIT.            
           PERFORM 6200-NEW-SO-ORD-INST      THRU 6200-EXIT             
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                
           PERFORM 7420-CLOSE-MTRD-ENV-CSR   THRU 7420-EXIT.            
      *                                                                         
       5560-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   6000-INSERT-NEW-SO.                                          *        
      ******************************************************************        
      *                                                                         
       6000-INSERT-NEW-SO.                                              
      *                                                                         
           INITIALIZE WS-ORDER-PRIORITY1.                               
           IF  ORDER-RSN-TBL-LOADED                                     
               CONTINUE                                                 
           ELSE                                                         
               PERFORM 2010-LOAD-ORDER-RSN-PRTY    THRU 2010-EXIT       
               SET ORDER-RSN-TBL-LOADED TO TRUE                         
           END-IF                                                       
P00718     MOVE 0 TO WS-SECURITIES.                                     
P00718     PERFORM 7320-SELECT-DEP-ON-HAND THRU 7320-EXIT.              
P00718     ADD WS-DEP-ON-HAND TO WS-SECURITIES.                         
P00718     PERFORM 7500-SELECT-GUAR-SECURITIES THRU 7500-EXIT.          
P00718     IF  WS-GU-AMOUNT-GUARANTEED-NULL >= 0                        
P00718        ADD GU-AMOUNT-GUARANTEED TO WS-SECURITIES                 
P00718     END-IF.                                                      
P00718     PERFORM 7510-SELECT-BOND-SECURITIES THRU 7510-EXIT.          
P00718     IF  WS-SB-AMT-BOND-NULL          >= 0                        
P00718        ADD SB-AMT-BOND TO WS-SECURITIES                          
P00718     END-IF.                                                      
P00718     PERFORM 7520-SELECT-AR-CNTL-BAL THRU 7520-EXIT.              
P00718     COMPUTE WS-DNP-RANKING-AMT =                                 
P00718             CL-AMT-NOTICE - WS-SECURITIES + AC-AMT-TRAN-BALANCE  
P00718     IF WS-DNP-RANKING-AMT < 0                                    
P00718        MOVE ZERO TO WS-DNP-RANKING-AMT                           
P00718     END-IF.                                                      
           SET WS-RANGE-INDEX TO 1                                      
           SEARCH WS-ORDER-RSN                                          
               AT END                                                   
                 CONTINUE                                               
               WHEN WS-COMPANY-NO1(WS-RANGE-INDEX)      = WS-DNP-CO-NO  
                AND WS-ORDER-TYPE-CD1(WS-RANGE-INDEX)   = WS-ORDER-TYPE 
                AND WS-ORDER-REASON-CD1(WS-RANGE-INDEX)                 
                                     = CL-CODE-SPECIAL-TYPE             
                AND WS-ORDER-MIN-AM1(WS-RANGE-INDEX)                    
P00718                              <= WS-DNP-RANKING-AMT               
                AND WS-ORDER-MAX-AM1(WS-RANGE-INDEX)                    
P00718                              >= WS-DNP-RANKING-AMT               
                    MOVE WS-ORDER-PRIORITY-CD1(WS-RANGE-INDEX)          
ACT155                                          TO WS-ORDER-PRIORITY1   
ACT155          DISPLAY 'WS-ORDER-PRIORITY1' WS-ORDER-PRIORITY1         
           END-SEARCH                                                   
      *                                                                         
           IF CSR-DATABASE                                              
             IF AT-COMPANY-NO = WS-SCEG                                 
               MOVE WS-SCHEDULE         TO XE-SERV-ORDER-STATUS         
             ELSE                                                       
               IF AT-COMPANY-NO = WS-PSNC                               
                 MOVE WS-ON-SITE        TO XE-SERV-ORDER-STATUS         
               END-IF                                                   
             END-IF                                                     
           ELSE                                                         
             MOVE WS-ON-SITE            TO XE-SERV-ORDER-STATUS         
           END-IF.                                                      
      *                                                                         
ACT155     IF WS-ORDER-PRIORITY1 = ZEROES                               
ACT155       MOVE    7                  TO WS-ORDER-PRIORITY1           
             PERFORM 2300-SEND-ORDER-PRIORITY-WQ   THRU 2300-EXIT       
           END-IF.                                                      
      *                                                                         
           MOVE 'DNP01'                 TO XE-ORDER-TYPE-CD.            
           MOVE WS-SYSTEM               TO XE-ORDER-RECVED-BY           
                                           XE-ORDER-PLACED-BY.          
           MOVE CL-AMT-NOTICE           TO XE-AMT-DNP-AT-BILLING.       
           MOVE CL-CODE-SPECIAL-TYPE    TO XE-ORDER-REASON.             
           MOVE CL-DATE-CREDIT-ACTION   TO XE-DATE-RECVED               
                                           XE-WANTED-BY-DATE            
                                           XE-DATE-FORECAST-DNP.        
           MOVE CL-ACCOUNT-NO           TO XE-ACCOUNT-NO.               
           MOVE AT-COMPANY-NO           TO XE-COMPANY-NO.               
           MOVE AT-LOCAL-OFFICE         TO XE-LOCAL-OFFICE.             
           MOVE AT-PREMISE-NO           TO XE-PREMISE-NO.               
           MOVE SPACES                  TO XE-WORK-INDICATOR.           
           MOVE SPACES                  TO XE-WANTED-BY-AM-PM.          
           MOVE WS-N                    TO XE-BACK-DATED.               
           MOVE SPACES                  TO XE-RESP-AREA-ID.             
           MOVE SPACES                  TO XE-MAKE-ARRANGEMENTS.        
           MOVE SPACES                  TO XE-NOTIFY-CUST-IND.          
           MOVE SPACES                  TO XE-NOTIFY-CSR-IND.           
           MOVE WS-DEP-ON-HAND          TO XE-DEPOSIT-AMT.              
           MOVE SPACES                  TO XE-INIT-BY-CONTRACT.         
           MOVE WS-ORDER-PRIORITY1      TO XE-ORDER-PRIORITY-CD.        
           MOVE ZEROS                   TO XE-ORDER-STAT-REASON-LEN.    
           MOVE SPACES                  TO XE-ORDER-STAT-REASON-TEXT.   
      *                                                                         
           PERFORM 7000-GET-TIMESTAMP       THRU 7000-EXIT.             
           PERFORM 8630-INSERT-SO-DATA-MF   THRU 8630-EXIT.             
      *                                                                         
       6000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *     6200-NEW-SO-ORD-INST.                                      *        
      ******************************************************************        
      *                                                                         
       6200-NEW-SO-ORD-INST.                                            
      *                                                                         
           MOVE AT-ACCOUNT-NO         TO WB-ACCOUNT-NO.                 
           MOVE MN-CODE-METER-LOC     TO WB-CODE-METER-LOC.             
           MOVE MN-CODE-UTIL-TYPE     TO WB-CODE-UTIL-TYPE.             
           MOVE MN-METER-NO           TO WB-METER-NO.                   
           MOVE MN-METER-SUPPLYING    TO WB-METER-SUPPLYING.            
           IF WB-CODE-UTIL-TYPE = 'E'                                   
             MOVE WS-WORK-TYPE-CD TO WB-WORK-TYPE-CD                    
           ELSE                                                         
             IF WB-CODE-UTIL-TYPE = 'G'                                 
               PERFORM 6400-CHECK-FOR-ELEC-ACCT                         
                                      THRU 6400-CHECK-FOR-ELEC-ACCT-EXIT
               IF ELECTRIC-ACCT                                         
                 MOVE SPACE TO WB-WORK-TYPE-CD                          
               ELSE                                                     
                 MOVE WS-WORK-TYPE-CD TO WB-WORK-TYPE-CD                
               END-IF                                                   
             END-IF                                                     
           END-IF.                                                      
                                                                        
           PERFORM 7700-SELECT-MAX-ORD-INST THRU 7700-EXIT.             
           ADD 1                      TO WS-MAX-SO-INST-SEQ-NO.         
           MOVE WS-MAX-SO-INST-SEQ-NO TO WB-SO-INST-SEQ-NO.             
                                                                        
           PERFORM 8620-INSERT-SO-ORD-INST  THRU 8620-EXIT.             
                                                                        
           PERFORM 7410-FETCH-MTRD-ENV-CSR  THRU 7410-EXIT.             
      *                                                                         
       6200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6240-GET-FCA00-COMMON-DATE                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00040                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00037                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *     6400-CHECK-FOR-ELEC-ACCT                                   *        
      ******************************************************************        
      *                                                                         
       6400-CHECK-FOR-ELEC-ACCT.                                        
      *                                                                         
           EXEC SQL                                                     
                SELECT ACCOUNT_NO                                       
                 INTO :WS-ELECTRIC-ACCT-NO                              
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :WB-ACCOUNT-NO                       
                 AND CODE_UTIL_TYPE ='E'                                
                 AND (CODE_METER_STATUS = 'A' OR                        
                      CODE_METER_STATUS = 'B' OR                        
                      CODE_METER_STATUS = 'I')                          
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT ACCOUNT_NO                                               
MFA-TR*          INTO :WS-ELECTRIC-ACCT-NO                                      
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :WB-ACCOUNT-NO                               
MFA-TR*          AND CODE_UTIL_TYPE ='E'                                        
MFA-TR*          AND (CODE_METER_STATUS = 'A' OR                                
MFA-TR*               CODE_METER_STATUS = 'B' OR                                
MFA-TR*               CODE_METER_STATUS = 'I')                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              SET NOT-ELECTRIC-ACCT TO TRUE                             
           ELSE                                                         
              SET ELECTRIC-ACCT TO TRUE                                 
           END-IF                                                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              OR WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND               
              OR WS-ACTIVE-RETURN-CODE EQUAL -811                       
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** 6400-CHECK-FOR-ELEC-ACCT**'                   
              DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE            
              DISPLAY '** ACCOUNT NO  = ' WB-ACCOUNT-NO                 
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       6400-CHECK-FOR-ELEC-ACCT-EXIT.                                   
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    6500-GET-NEXT-BUSINESS-DAY                                **         
      *    COPYBOOK CPD00322 CONTAINS THE LOGIC FOR FINDING          **         
      *    THE NEXT AND PREVIOUS BUSINESS DAY.                       **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00322                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    6500-LOAD-EXCP-LIMITS                                     **         
      *    COPYBOOK TO LOAD THE LIMITS FOR EXCEPTIONS FROM THE       **         
      *    CSS_DELINQUENCY TABLE                                     **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00314                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST                                       *        
      * 6540-INSERT-MNT-TRANS-HIST                                     *        
      * 6550-INSERT-MT-TRN-HST-DET                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00067                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7000-GET-TIMESTAMP.                                            *        
      * GET TIMESTAMP FOR MNT_TRANS_HIST FILE                          *        
      ******************************************************************        
      *                                                                         
       7000-GET-TIMESTAMP.                                              
      *                                                                         
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTAMP                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET: WS-TIMESTAMP = CURRENT TIMESTAMP                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             WS-DISPLAY-SQLCODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             NEXT SENTENCE                                              
           ELSE                                                         
              DISPLAY '********** PCSKR210 ABORT **********************'
              DISPLAY ' 7000-GET-TIMESTAMP '                            
              DISPLAY ' RETURN CODE      = ' WS-DISPLAY-SQLCODE         
              DISPLAY ' PROCESSING TERMINATED                         *'
              DISPLAY '********** PCSKR210 ABORT **********************'
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010-SELECT-DELINQ-VALUE                                       *        
      ******************************************************************        
      *                                                                         
       7010-SELECT-DELINQ-VALUE.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD    = :C8-DELINQ-CD                       
                 AND COMPANY_NO   = :C8-COMPANY-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD    = :C8-DELINQ-CD                               
MFA-TR*          AND COMPANY_NO   = :C8-COMPANY-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             WS-DISPLAY-SQLCODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
             NEXT SENTENCE                                              
           ELSE                                                         
               DISPLAY '********** PCSKR210  ABORT ********************'
               DISPLAY '* 7010-SELECT-DELINQ-VALUE                    *'
               DISPLAY '* SQLCODE IS   ' WS-DISPLAY-SQLCODE             
               DISPLAY '* DELINQ_CD  : ' C8-DELINQ-CD                   
               DISPLAY '* COMPANY_NO : ' C8-COMPANY-NO                  
               DISPLAY '* PROGRAM ABORTING...                         *'
               DISPLAY '********** PCSKR210  ABORT ********************'
               PERFORM 9900-ABEND                   THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   7020-CHECK-METER-STATUS                                      *        
      *   IF ALL METERS HAVE BEEN BLOCKED OR REMOVED THEN THE ACCOUNT  *        
      *   WILL NOT BE WRITTEN TO FA01 FILE.  THE ACCOUNT WILL BE       *        
      *   DISPLAYED ON SYSOUT UNTIL A DECISION IS MADE ABOUT A WQ.     *        
      ******************************************************************        
      *                                                                         
       7020-CHECK-METER-STATUS.                                         
      *                                                                         
           EXEC SQL                                                     
               SELECT ACCOUNT_NO                                        
                 INTO :MN-ACCOUNT-NO                                    
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO = :MN-ACCOUNT-NO                        
                 AND CODE_METER_STATUS NOT IN ('J','K')                 
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :MN-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*        WHERE ACCOUNT_NO = :MN-ACCOUNT-NO                                
MFA-TR*          AND CODE_METER_STATUS NOT IN ('J','K')                         
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -811       
             NEXT SENTENCE                                              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   MOVE 'N' TO WS-DNP-READY-SW                          
                   DISPLAY '*****************PCSKR210*****************' 
                   DISPLAY '** ACCOUNT FORECASTED FOR DNP HOWEVER THE ' 
                   DISPLAY '** METER STATUS IS INACTIVE.              ' 
                   DISPLAY '** ACCOUNT NUMBER: ' MN-ACCOUNT-NO          
                   DISPLAY '*****************PCSKR210*****************' 
               ELSE                                                     
                   DISPLAY '******************************************' 
                   DISPLAY '** CSS_MTRD_ENVRNMT                       ' 
                   DISPLAY '** ACCOUNT NO = ' MN-ACCOUNT-NO             
                   DISPLAY '** 7020 : RETURN CODE ERROR - SELECT      ' 
                   DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE        
                   DISPLAY '******************************************' 
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   7030-CHECK-FOR-CIA-DEBIT                                     *        
      *   IF THE ACCOUNT HAS A CIA DEBIT THEN STOP DNP PROCESSING AND  *        
      *   SEND A WORK QUEUE SUGGESTING A MANUAL DNP.                   *        
      ******************************************************************        
      *                                                                         
       7030-CHECK-FOR-CIA-DEBIT.                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT ACCOUNT_NO                                        
                 INTO :AC-ACCOUNT-NO                                    
                 FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = 70                            
                  AND ITEM_ID           = 3                             
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :AC-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = 70                                    
MFA-TR*           AND ITEM_ID           = 3                                     
MFA-TR*        QUERYNO 7030                                                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             NEXT SENTENCE                                              
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** CSS_AR_CNTL                            '     
               DISPLAY '** ACCOUNT NO = ' AC-ACCOUNT-NO                 
               DISPLAY '** 7030 : RETURN CODE ERROR - SELECT      '     
               DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE            
               DISPLAY '******************************************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   7040-CHECK-REGULATED                                         *        
      ******************************************************************        
      *                                                                         
       7040-CHECK-FOR-REGULATED.                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT REG_GROUP_CD                                      
                     ,SENIOR_FL                                         
                 INTO :LR-REG-GROUP-CD                                  
                     ,:LR-SENIOR-FL                                     
                 FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REG_GROUP_CD                                              
MFA-TR*              ,SENIOR_FL                                                 
MFA-TR*          INTO :LR-REG-GROUP-CD                                          
MFA-TR*              ,:LR-SENIOR-FL                                             
MFA-TR*          FROM CSS_REG_PROFILE                                           
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        QUERYNO 7040                                                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             NEXT SENTENCE                                              
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** CSS_REG_PROFILE                        '     
               DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                 
               DISPLAY '** 7040 : RETURN CODE ERROR - SELECT      '     
               DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE            
               DISPLAY '******************************************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7125 - SELECT  FROM CSS_SO_DATA.                              *        
      ******************************************************************        
      *                                                                         
       7125-SELECT-SO-DATA.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT  ORDER_REASON,                                     
                      ORDER_STATE_CD,                                   
                      SERV_ORDER_NO                                     
                INTO  :VO-ORDER-REASON,                                 
                      :VO-ORDER-STATE-CD,                               
                      :VO-SERV-ORDER-NO                                 
               FROM   CSS_SO_DATA VO WITH(READUNCOMMITTED)                      
              WHERE   VO.ACCOUNT_NO           = :VO-ACCOUNT-NO          
                AND   VO.ORDER_TYPE_CD        = 'DNP01'                 
                AND   VO.DATE_FORECAST_DNP =                            
                          (SELECT MAX(A.DATE_FORECAST_DNP)              
                            FROM CSS_SO_DATA A WITH(READUNCOMMITTED)            
                            WHERE A.ACCOUNT_NO = VO.ACCOUNT_NO          
                            AND A.ORDER_TYPE_CD = 'DNP01')              
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ORDER_REASON,                                             
MFA-TR*               ORDER_STATE_CD,                                           
MFA-TR*               SERV_ORDER_NO                                             
MFA-TR*         INTO  :VO-ORDER-REASON,                                         
MFA-TR*               :VO-ORDER-STATE-CD,                                       
MFA-TR*               :VO-SERV-ORDER-NO                                         
MFA-TR*        FROM   CSS_SO_DATA VO                                            
MFA-TR*       WHERE   VO.ACCOUNT_NO           = :VO-ACCOUNT-NO                  
MFA-TR*         AND   VO.ORDER_TYPE_CD        = 'DNP01'                         
MFA-TR*         AND   VO.DATE_FORECAST_DNP =                                    
MFA-TR*                   (SELECT MAX(A.DATE_FORECAST_DNP)                      
MFA-TR*                     FROM CSS_SO_DATA A                                  
MFA-TR*                     WHERE A.ACCOUNT_NO = VO.ACCOUNT_NO                  
MFA-TR*                     AND A.ORDER_TYPE_CD = 'DNP01')                      
MFA-TR*       QUERYNO 7125                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
              WHEN NOT-FOUND                                            
              WHEN MULTIPLE-ROWS                                        
                 CONTINUE                                               
              WHEN OTHER                                                
                 DISPLAY '******************************************'   
                 DISPLAY '** CSS_SO_DATA TABLE               '          
                 DISPLAY '** ACCOUNT NO = ' VO-ACCOUNT-NO               
                 DISPLAY '** ORDER TYPE CD = ' VO-ORDER-TYPE-CD         
                 DISPLAY '** 7125 :  RETURN CODE ERROR  - SELECT    '   
                 DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE          
                 DISPLAY '******************************************'   
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-EVALUATE.                                                
      *                                                                         
       7125-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7135-SELECT-SO-REMARKS                                        *        
      ******************************************************************        
      *                                                                         
       7135-SELECT-SO-REMARKS.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT  REMARK_TX                                         
                INTO  :EF-REMARK-TX                                     
               FROM   CSS_SO_REMARKS WITH(READUNCOMMITTED)                      
              WHERE   SERV_ORDER_NO        = :VO-SERV-ORDER-NO          
                AND   REMARK_TYPE_CD       = 'A'                        
                AND   REMARK_TX            LIKE 'DNP %'                 
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  REMARK_TX                                                 
MFA-TR*         INTO  :EF-REMARK-TX                                             
MFA-TR*        FROM   CSS_SO_REMARKS                                            
MFA-TR*       WHERE   SERV_ORDER_NO        = :VO-SERV-ORDER-NO                  
MFA-TR*         AND   REMARK_TYPE_CD       = 'A'                                
MFA-TR*         AND   REMARK_TX            LIKE 'DNP %'                         
MFA-TR*       QUERYNO 7135                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
              WHEN NOT-FOUND                                            
              WHEN MULTIPLE-ROWS                                        
                 CONTINUE                                               
              WHEN OTHER                                                
                 DISPLAY '******************************************'   
                 DISPLAY '** CSS_SO_REMARKS                  '          
                 DISPLAY '** ACCOUNT NO = ' VO-ACCOUNT-NO               
                 DISPLAY '** SERV ORDER NO = ' VO-SERV-ORDER-NO         
                 DISPLAY '** 7135 :  RETURN CODE ERROR  - SELECT    '   
                 DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE          
                 DISPLAY '******************************************'   
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-EVALUATE.                                                
      *                                                                         
       7135-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7170-SELECT-CREDIT-PROFILE                                     *        
      ******************************************************************        
      *                                                                         
       7170-SELECT-CREDIT-PROFILE.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                  NON_UTL_ARRER_HIST,                                   
                  DISC_EXCEPTN_HIST,                                    
                  DISCONNECT_HIST,                                      
                  ARREARS_HIST,                                         
                  REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                  CASH_ONLY_FL,                                         
                  NON_UTL_CR_HST,                                       
                  NON_UTL_CR_HST_EX,                                    
                  AUTO_DEP_AM                                           
              INTO                                                      
                  :CZ-NON-UTL-ARRER-HIST,                               
                  :CZ-DISC-EXCEPTN-HIST,                                
                  :CZ-DISCONNECT-HIST,                                  
                  :CZ-ARREARS-HIST,                                     
                  :CZ-LAST-UPDATE-TS,                                   
                  :CZ-CASH-ONLY-FL,                                     
                  :CZ-NON-UTL-CR-HST,                                   
                  :CZ-NON-UTL-CR-HST-EX,                                
                  :CZ-AUTO-DEP-AM                                       
              FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                         
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*           NON_UTL_ARRER_HIST,                                           
MFA-TR*           DISC_EXCEPTN_HIST,                                            
MFA-TR*           DISCONNECT_HIST,                                              
MFA-TR*           ARREARS_HIST,                                                 
MFA-TR*           LAST_UPDATE_TS,                                               
MFA-TR*           CASH_ONLY_FL,                                                 
MFA-TR*           NON_UTL_CR_HST,                                               
MFA-TR*           NON_UTL_CR_HST_EX,                                            
MFA-TR*           AUTO_DEP_AM                                                   
MFA-TR*       INTO                                                              
MFA-TR*           :CZ-NON-UTL-ARRER-HIST,                                       
MFA-TR*           :CZ-DISC-EXCEPTN-HIST,                                        
MFA-TR*           :CZ-DISCONNECT-HIST,                                          
MFA-TR*           :CZ-ARREARS-HIST,                                             
MFA-TR*           :CZ-LAST-UPDATE-TS,                                           
MFA-TR*           :CZ-CASH-ONLY-FL,                                             
MFA-TR*           :CZ-NON-UTL-CR-HST,                                           
MFA-TR*           :CZ-NON-UTL-CR-HST-EX,                                        
MFA-TR*           :CZ-AUTO-DEP-AM                                               
MFA-TR*       FROM CSS_CREDIT_PROFILE                                           
MFA-TR*       WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                                 
MFA-TR*       QUERYNO 7170                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CREDIT_PROFILE TABLE                   '      
              DISPLAY '** ACCOUNT NO = ' CZ-ACCOUNT-NO                  
              DISPLAY '** 7170 :  RETURN CODE ERROR - SELECT     '      
              DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE             
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7200-OPEN-CRED-COLL                                       **          
      **      MURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **          
      **      DNP_CSR CURSOR                                        **          
      ****************************************************************          
      *                                                                         
       7200-OPEN-CRED-COLL.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN DNP_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************PCSKR210******************'     
               DISPLAY '** 7200 :  RETURN CODE ERROR - OPEN '           
               DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE            
               DISPLAY '****************PCSKR210******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7210-FETCH-CRED-COLL                                      **          
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **          
      **      DNP_CSR CURSOR                                        **          
      ****************************************************************          
      *                                                                         
       7210-FETCH-CRED-COLL.                                            
      *                                                                         
           EXEC SQL                                                     
               FETCH DNP_CSR INTO                                       
                   :AT-CUSTOMER-NO,                                     
                   :AT-ACCOUNT-NO,                                      
                   :AT-PREMISE-NO,                                      
                   :AT-COMPANY-NO,                                      
                   :AT-LOCAL-OFFICE,                                    
                   :AT-DATE-BILL-DAY-00,                                
                   :AT-DATE-BILL-DAY-30,                                
                   :AT-DATE-BILL-DAY-60,                                
                   :AT-DATE-BILL-DAY-90,                                
                   :AT-BILL-CYCLE,                                      
                   :AT-TOTAL-AR-BALANCE,                                
                   :AT-CODES-DATA-PRESENT,                              
                   :AT-CODE-ACCT-STAT,                                  
                   :AT-CREDIT-GROUP,                                    
                   :AT-ACCOUNT-TYPE-CODE,                               
                   :AT-CODE-STATUS-REASON,                              
                   :AT-NOTICE-EXEMPT-CD,                                
                   :AT-IVR-EXEMPT-CD,                                   
                   :AT-CODE-DISC-OK,                                    
                   :AT-BANKRUPTCY-IND,                                  
                   :AT-CT-METER-RATED-IND,                              
                   :AT-CODE-CRIT-OUTAGE,                                
                   :CL-DATE-CREDIT-ACTION :WS-DATE-CRED-ACT-NULL,       
                   :CL-CODE-NOTICE-TYPE,                                
                   :CL-ITEM-ID                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               IF WS-DATE-CRED-ACT-NULL < 0                             
                   MOVE SPACES         TO CL-DATE-CREDIT-ACTION         
               END-IF                                                   
           ELSE                                                         
               DISPLAY '**************PCSKR210********************'     
               DISPLAY '** 7210 :  RETURN CODE ERROR - FETCH'           
               DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE            
               DISPLAY '**************PCSKR210********************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7220-CLOSE-CRED-COLL                                      **          
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **          
      **      DNP_CSR CURSOR                                        **          
      ****************************************************************          
      *                                                                         
       7220-CLOSE-CRED-COLL.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE DNP_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '***************PCSKR210*******************'     
               DISPLAY '** 7220 :  RETURN CODE ERROR - CLOSE'           
               DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE            
               DISPLAY '***************PCSKR210*******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *     7240-CHECK-MTRD-ENVRNMT                                    *        
      ******************************************************************        
      *                                                                         
       7240-CHECK-MTRD-ENVRNMT.                                         
      *                                                                         
           MOVE 'N'               TO WS-MTRD-ENVRNMT.                   
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :MN-ACCOUNT-NO                                     
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO  = :MN-ACCOUNT-NO                       
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :MN-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO  = :MN-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
               MOVE 'Y' TO WS-MTRD-ENVRNMT                              
             END-IF                                                     
           ELSE                                                         
               DISPLAY '*****************PCSKR210******************'    
               DISPLAY '* 7240 : FETCH MTRD_ENVRNMT               *'    
               DISPLAY '*        RC = ' WS-DISPLAY-SQLCODE              
               DISPLAY '* ACCOUNT NO ' MN-ACCOUNT-NO                    
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSKR210******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *     7270-CHECK-CUST-PLAN                                       *        
      ******************************************************************        
      *                                                                         
       7270-CHECK-CUST-PLAN.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :CP-ACCOUNT-NO                                     
                FROM CSS_CUST_PLAN WITH(READUNCOMMITTED)                        
               WHERE ACCOUNT_NO  = :CP-ACCOUNT-NO                       
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :CP-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_CUST_PLAN                                              
MFA-TR*        WHERE ACCOUNT_NO  = :CP-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*****************PCSKR210******************'    
               DISPLAY '* 7270 : FETCH CUST_PLAN                  *'    
               DISPLAY '*        RC = ' WS-DISPLAY-SQLCODE              
               DISPLAY '* ACCOUNT NO ' CP-ACCOUNT-NO                    
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSKR210******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *     7320-SELECT-DEP-ON-HAND.                                   *        
      ******************************************************************        
      *                                                                         
       7320-SELECT-DEP-ON-HAND.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                  SUM(AMT_DEPOSIT)                                      
               INTO                                                     
                  :WS-DEP-ON-HAND :WS-DEP-ON-HAND-NULL                  
              FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                        
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
                AND (DEPOSIT_STATUS_CD = 'A'                            
                OR   DEPOSIT_STATUS_CD = 'P')                           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*           SUM(AMT_DEPOSIT)                                              
MFA-TR*        INTO                                                             
MFA-TR*           :WS-DEP-ON-HAND :WS-DEP-ON-HAND-NULL                          
MFA-TR*       FROM CSS_DEP_ON_HAND                                              
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*         AND (DEPOSIT_STATUS_CD = 'A'                                    
MFA-TR*         OR   DEPOSIT_STATUS_CD = 'P')                                   
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-DEP-ON-HAND-NULL = -1                               
                  MOVE ZERO           TO WS-DEP-ON-HAND                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '***************PCSKR210*******************'      
              DISPLAY '** DEP_ON_HAND TABLE                      '      
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7320:   RETURN CODE ERROR        '            
              DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE             
              DISPLAY '***************PCSKR210*******************'      
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *     7400-OPEN-MTRD-ENV-CSR                                     *        
      ******************************************************************        
      *                                                                         
       7400-OPEN-MTRD-ENV-CSR.                                          
      *                                                                         
           EXEC SQL                                                     
               OPEN MTRD_ENV_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '***************PCSKR210*******************'     
               DISPLAY '** 7400-OPEN-MTRD-ENV-CSR **'                   
               DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE           
               DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                 
               DISPLAY '***************PCSKR210*******************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *     7410-FETCH-MTRD-ENV-CSR                                    *        
      ******************************************************************        
      *                                                                         
       7410-FETCH-MTRD-ENV-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
               FETCH MTRD_ENV_CSR                                       
                INTO :MN-CODE-METER-LOC,                                
                     :MN-CODE-UTIL-TYPE,                                
                     :MN-METER-NO,                                      
                     :MN-METER-SUPPLYING                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************PCSKR210******************'     
               DISPLAY '** 7410-FETCH-MTRD-ENV-CSR **'                  
               DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE           
               DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                 
               DISPLAY '****************PCSKR210******************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *     7420-CLOSE-MTRD-ENV-CSR                                    *        
      ******************************************************************        
      *                                                                         
       7420-CLOSE-MTRD-ENV-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
               CLOSE MTRD_ENV_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************PCSKR210******************'     
               DISPLAY '** 7420-CLOSE-MTRD-ENV-CSR **'                  
               DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE           
               DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                 
               DISPLAY '****************PCSKR210******************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7430-OPEN-ORDER-RSN-CURSOR.                                   *         
      *****************************************************************         
      *                                                                         
       7430-OPEN-ORDER-RSN-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
               OPEN ORDER_RSN_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             WS-DISPLAY-SQLCODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*****************PCSKR210*****************'      
              DISPLAY '*** ABEND IN 7430-OPEN-ORDER-RSN-CSR ***'        
              DISPLAY 'RETURN CODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY ' EFFECTIVE_DT ' WS-INPUT-DATE                    
              DISPLAY '*****************PCSKR210*****************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7430-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7440-FETCH-ORDER-RSN-CSR.                                     *         
      *****************************************************************         
      *                                                                         
       7440-FETCH-ORDER-RSN-CSR.                                        

MSQ008     MOVE 600 TO MSQ008-ORDER-RSN-CSR
      *                                                                         
           EXEC SQL                                                     
ACT155         FOR :MSQ008-ORDER-RSN-CSR
              FETCH 
              FROM ORDER_RSN_CSR         
                INTO :WS-COMPANY-NUM                                    
                    ,:WS-ORDER-TYPE-CD                                  
                    ,:WS-ORDER-REASON-CD                                
                    ,:WS-ACCOUNT-TYPE-CD                                
                    ,:WS-ORDER-MIN-AM                                   
                    ,:WS-ORDER-MAX-AM                                   
                    ,:WS-ORDER-PRIORITY-CD                              
                    ,:WS-EFFECTIVE-DT                                   
                    ,:WS-LAST-UPDATE-TS                                 
                    ,:WS-LAST-UPDATE-USERID                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM ORDER_RSN_CSR FOR 600 ROWS                
MFA-TR*         INTO :WS-COMPANY-NUM                                            
MFA-TR*             ,:WS-ORDER-TYPE-CD                                          
MFA-TR*             ,:WS-ORDER-REASON-CD                                        
MFA-TR*             ,:WS-ACCOUNT-TYPE-CD                                        
MFA-TR*             ,:WS-ORDER-MIN-AM                                           
MFA-TR*             ,:WS-ORDER-MAX-AM                                           
MFA-TR*             ,:WS-ORDER-PRIORITY-CD                                      
MFA-TR*             ,:WS-EFFECTIVE-DT                                           
MFA-TR*             ,:WS-LAST-UPDATE-TS                                         
MFA-TR*             ,:WS-LAST-UPDATE-USERID                                     
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-ORDER-RSN-CSR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             WS-DISPLAY-SQLCODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF  SQLERRD(3) >= 1 OR WS-ORDER-ROW-COUNT > 0             
                  MOVE SQLERRD (3)        TO WS-ORDER-ROW-COUNT         
              ELSE                                                      
                  DISPLAY '***************PCSKR210*******************'  
                  DISPLAY '*** ABEND IN 7440-FETCH-ORDER-RSN-CSR ***'   
                  DISPLAY 'RETURN CODE = ' WS-DISPLAY-SQLCODE           
                  DISPLAY ' EFFECTIVE_DT ' WS-INPUT-DATE                
                  DISPLAY 'ROWCOUNT ' SQLERRD(3)                        
                  DISPLAY '***************PCSKR210*******************'  
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = +354                           
                  EXEC SQL                                              
MSQ012                GET DIAGNOSTICS :MFA-GD-ROW-COUNT =             
                             ROW_COUNT                                  
MSQ012                      ,:MFA-GD-NUMBER = NUMBER                      
                  END-EXEC                                              

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*           EXEC SQL                                                      
MFA-TR*               GET DIAGNOSTICS :WS-ORDER-ROW-COUNT =                     
MFA-TR*                      ROW_COUNT                                          
MFA-TR*                     ,:WS-NUM-COND = NUMBER                              
MFA-TR*           END-EXEC                                                      
MSQ012            MOVE MFA-GD-ROW-COUNT TO WS-ORDER-ROW-COUNT
MSQ012            MOVE MFA-GD-NUMBER TO WS-NUM-COND
                  DISPLAY '***************PCSKR210*******************'  
                  DISPLAY '*** ABEND IN 7440-FETCH-ORDER-RSN-CSR ***'   
                  DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
                  DISPLAY ' EFFECTIVE_DT ' WS-INPUT-DATE                
                  DISPLAY 'ROWCOUNT ' SQLERRD(3)                        
                  DISPLAY 'NUM_COND '  WS-NUM-COND                      
                  DISPLAY '***************PCSKR210*******************'  
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
              ELSE                                                      
                  DISPLAY '***************PCSKR210*******************'  
                  DISPLAY '*** ABEND IN 7440-FETCH-ORDER-RSN-CSR ***'   
                  DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
                  DISPLAY ' EFFECTIVE_DT ' WS-INPUT-DATE                
                  DISPLAY '***************PCSKR210*******************'  
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7440-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7450-CLOSE-ORDER-RSN-CSR                                      *         
      *****************************************************************         
      *                                                                         
       7450-CLOSE-ORDER-RSN-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
               CLOSE ORDER_RSN_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             WS-DISPLAY-SQLCODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*****************PCSKR210*****************'      
              DISPLAY '*** ABEND IN 7450-CLOSE-ORDER-RSN-CSR ***    '   
              DISPLAY 'RETURN CODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY ' EFFECTIVE_DT ' WS-INPUT-DATE                    
              DISPLAY '*****************PCSKR210*****************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00718*****************************************************************         
P00718** 7500-SELECT-GUAR-SECURITIES FOR AN ACCOUNT.                **          
P00718*****************************************************************         
P00718 7500-SELECT-GUAR-SECURITIES.                                     
P00718*                                                                         
P00718     MOVE CL-ACCOUNT-NO TO GU-ACCOUNT-NO.                         
P00718     EXEC SQL                                                     
P00718        SELECT                                                    
P00718               SUM(AMOUNT_GUARANTEED)                             
P00718        INTO                                                      
P00718              :GU-AMOUNT-GUARANTEED :WS-GU-AMOUNT-GUARANTEED-NULL 
P00718        FROM                                                      
P00718               CSS_GUARANTOR WITH(READUNCOMMITTED)                        
P00718        WHERE                                                     
P00718               ACCOUNT_NO = :GU-ACCOUNT-NO                        
P00718               AND GUAR_STATUS_CD = 'A'                           
P00718                                                           
P00718                                                      
P00718      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              SUM(AMOUNT_GUARANTEED)                                     
MFA-TR*       INTO                                                              
MFA-TR*             :GU-AMOUNT-GUARANTEED :WS-GU-AMOUNT-GUARANTEED-NULL         
MFA-TR*       FROM                                                              
MFA-TR*              CSS_GUARANTOR                                              
MFA-TR*       WHERE                                                             
MFA-TR*              ACCOUNT_NO = :GU-ACCOUNT-NO                                
MFA-TR*              AND GUAR_STATUS_CD = 'A'                                   
MFA-TR*     WITH UR                                                             
MFA-TR*     QUERYNO 7500                                                        
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718*                                                                         
P00718     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
P00718        NEXT SENTENCE                                             
P00718     ELSE                                                         
P00718        MOVE SQLCODE TO WS-DISPLAY-SQLCODE                        
P00718        DISPLAY '***************PCSKR210**************'           
P00718        DISPLAY '*** ABEND IN 7500-SELECT-GUAR-SECURITIES ***'    
P00718        DISPLAY '* SELECT ERROR CSS_GUARANTOR   TABLE*'           
P00718        DISPLAY '* ACCOUNT NBR IS ', GU-ACCOUNT-NO                
P00718        DISPLAY '* SQLCODE   IS ', WS-DISPLAY-SQLCODE             
P00718        DISPLAY '* PROGRAM ABENDING...               *'           
P00718        DISPLAY '***************PCSKR210**************'           
P00718        PERFORM 9900-ABEND THRU 9900-EXIT                         
P00718     END-IF.                                                      
P00718*                                                                         
P00718 7500-EXIT.                                                       
P00718     EXIT.                                                        
P00718*                                                                         
P00718*****************************************************************         
P00718** 7510-SELECT-BOND-SECURITIES GETS THE SURETY BOND TOTALS FOR **         
P00718** AN ACCOUNT.                                                **          
P00718*****************************************************************         
P00718 7510-SELECT-BOND-SECURITIES.                                     
P00718*                                                                         
P00718     MOVE CL-ACCOUNT-NO TO SB-ACCOUNT-NO.                         
P00718     EXEC SQL                                                     
P00718        SELECT                                                    
P00718                SUM(AMT_BOND)                                     
P00718        INTO                                                      
P00718                :SB-AMT-BOND :WS-SB-AMT-BOND-NULL                 
P00718        FROM                                                      
P00718                CSS_SURETY_BOND WITH(READUNCOMMITTED)                     
P00718        WHERE                                                     
P00718                ACCOUNT_NO = :SB-ACCOUNT-NO                       
P00718                AND CODE_BOND_TYPE IN ('A','B')                   
P00718                AND CODE_STATUS = 'A'                             
P00718                                                           
P00718                                                      
P00718     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*               SUM(AMT_BOND)                                             
MFA-TR*       INTO                                                              
MFA-TR*               :SB-AMT-BOND :WS-SB-AMT-BOND-NULL                         
MFA-TR*       FROM                                                              
MFA-TR*               CSS_SURETY_BOND                                           
MFA-TR*       WHERE                                                             
MFA-TR*               ACCOUNT_NO = :SB-ACCOUNT-NO                               
MFA-TR*               AND CODE_BOND_TYPE IN ('A','B')                           
MFA-TR*               AND CODE_STATUS = 'A'                                     
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7510                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718*                                                                         
P00718     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
P00718        NEXT SENTENCE                                             
P00718     ELSE                                                         
P00718        MOVE SQLCODE TO WS-DISPLAY-SQLCODE                        
P00718        DISPLAY '***************PCSKR210**************'           
P00718        DISPLAY '*** ABEND IN 7510-SELECT-BOND-SECURITIES ***'    
P00718        DISPLAY '* SELECT ERROR CSS_SURETY_BOND TABLE*'           
P00718        DISPLAY '* ACCOUNT NBR IS ', SB-ACCOUNT-NO                
P00718        DISPLAY '* SQLCODE   IS ', WS-DISPLAY-SQLCODE             
P00718        DISPLAY '* PROGRAM ABENDING...               *'           
P00718        DISPLAY '***************PCSKR210**************'           
P00718        PERFORM 9900-ABEND THRU 9900-EXIT                         
P00718     END-IF.                                                      
P00718*                                                                         
P00718 7510-EXIT.                                                       
P00718     EXIT.                                                        
P00718*                                                                         
P00718******************************************************************        
P00718*   7520-SELECT-AR-CNTL-BAL                                      *        
P00718*   IF THE ACCOUNT HAS A BALANCE ON ANY OF THE DEPOSITS THEN THE *        
P00718*   BALANCES ARE SUMMED TOGETHER.                                *        
P00718******************************************************************        
P00718*                                                                         
P00718 7520-SELECT-AR-CNTL-BAL.                                         
P00718*                                                                         
P00718     MOVE CL-ACCOUNT-NO TO AC-ACCOUNT-NO.                         
P00718     EXEC SQL                                                     
P00718         SELECT SUM(AMT_TRAN_BALANCE)                             
P00718           INTO :AC-AMT-TRAN-BALANCE :WS-AC-TRANS-BALANCE-NULL    
P00718           FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
P00718          WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                
P00718            AND PYMT_PRIORITY_LVL = 80                            
P00718            AND ITEM_ID           > 0                             
P00718                                                      
P00718                                                           
P00718     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_TRAN_BALANCE)                                     
MFA-TR*          INTO :AC-AMT-TRAN-BALANCE :WS-AC-TRANS-BALANCE-NULL            
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = 80                                    
MFA-TR*           AND ITEM_ID           > 0                                     
MFA-TR*        QUERYNO 7520                                                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718*                                                                         
P00718     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P00718                     WS-DISPLAY-SQLCODE.                          
P00718*                                                                         
P00718     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00718         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND OR              
P00718           WS-AC-TRANS-BALANCE-NULL < 0                           
P00718             MOVE ZEROES TO AC-AMT-TRAN-BALANCE                   
P00718         ELSE                                                     
P00718             NEXT SENTENCE                                        
P00718         END-IF                                                   
P00718     ELSE                                                         
P00718         DISPLAY '******************************************'     
P00718         DISPLAY '** CSS_AR_CNTL                            '     
P00718         DISPLAY '** ACCOUNT NO = ' AC-ACCOUNT-NO                 
P00718         DISPLAY '** 7520 : RETURN CODE ERROR - SELECT      '     
P00718         DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE            
P00718         DISPLAY '******************************************'     
P00718         PERFORM 9900-ABEND THRU 9900-EXIT                        
P00718     END-IF.                                                      
P00718*                                                                         
P00718 7520-EXIT.                                                       
P00718     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7600-START-FCSJC01                                             *        
      * 7610-READ-FCSJC01                                              *        
      * 7611-CLOSE                                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7620-START-FCSCA00                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00039                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7700-SELECT-MAX-ORD-INST                                       *        
      ******************************************************************        
      *                                                                         
       7700-SELECT-MAX-ORD-INST.                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT MAX(SO_INST_SEQ_NO)                               
                 INTO :WS-MAX-SO-INST-SEQ-NO :WS-NULL-IND                
                 FROM CSS_SO_ORD_INST_MF WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND SO_DATA_SEQ_NO = CIS.CHAR2TIMESTAMP(:WS-TIMESTAMP)        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(SO_INST_SEQ_NO)                                       
MFA-TR*          INTO :WS-MAX-SO-INST-SEQ-NO:WS-NULL-IND                        
MFA-TR*          FROM CSS_SO_ORD_INST_MF                                        
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND SO_DATA_SEQ_NO = :WS-TIMESTAMP                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-NULL-IND = -1                                      
                   MOVE 0 TO WS-MAX-SO-INST-SEQ-NO                      
               END-IF                                                   
           ELSE                                                         
               DISPLAY '*****************PCSKR210*****************'     
               DISPLAY '** 7700-SELECT-MAX-SO-ORD-INST **'              
               DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE           
               DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                 
               DISPLAY '*****************PCSKR210*****************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   8500-WRITE-FCSKR210-FILE                                     *        
      *        WRITES THE RECORD INTO THE REPORT FILE                  *        
      *                                                                *        
      ******************************************************************        
       8500-WRITE-FCSKR210-FILE.                                        
      *                                                                         
           IF WS-FST-TIME = 'Y'                                         
             MOVE 03                          TO RETURN-CODE            
             MOVE 'HELO DOMAIN:     SCANA                         '     
                                              TO E-FCK210-DATA-REC      
             WRITE FCSKR210                                             
             MOVE 'MAIL FROM:   <'            TO E-FCK210-DATA-PARTA    
             MOVE WS-PGRMNAME                 TO WS-PRG-TO              
             MOVE EMAIL-TO-REC                TO E-FCK210-DATA-PARTB    
             MOVE SPACES                      TO E-FCK210-DATA-PARTC    
             WRITE FCSKR210                                             
             MOVE 'RCPT TO:   <ISTCSRCAREPROJECTS@SCANA.COM>'           
                                              TO E-FCK210-DATA-REC      
             WRITE FCSKR210                                             
             MOVE 'RCPT TO:   <ISTCSRAPPLICATIONSUPPORT@SCANA.COM>'     
                                              TO E-FCK210-DATA-REC      
             WRITE FCSKR210                                             
             MOVE 'RCPT TO:   <CSSOCREDIT@SCANA.COM>'                   
                                              TO E-FCK210-DATA-REC      
             WRITE FCSKR210                                             
             MOVE 'DATA                                           '     
                                              TO E-FCK210-DATA-REC      
             WRITE FCSKR210                                             
             MOVE 'DATA                                           '     
                                              TO E-FCK210-DATA-REC      
             WRITE FCSKR210                                             
             MOVE 'FROM: CIS PAGING <'        TO E-FCK210-DATA-PARTAA   
             MOVE EMAIL-TO-REC                TO E-FCK210-DATA-PARTBB   
             MOVE SPACES                      TO E-FCK210-DATA-PARTCC   
             WRITE FCSKR210                                             
             MOVE 'TO:   <ISTCSRCAREPROJECTS@SCANA.COM> '               
                                              TO E-FCK210-DATA-REC      
             WRITE FCSKR210                                             
             MOVE 'TO:   <ISTCSRAPPLICATIONSUPPORT@SCANA.COM> '         
                                              TO E-FCK210-DATA-REC      
             WRITE FCSKR210                                             
             MOVE 'TO:   <CSSOCREDIT@SCANA.COM> '                       
                                              TO E-FCK210-DATA-REC      
             WRITE FCSKR210                                             
             MOVE 'SUBJECT: DAILY JOB '       TO E-FCK210-DATA-PARTAAA  
             MOVE WS-PGRMNAME                 TO E-FCK210-DATA-PARTBBB  
             MOVE SPACES                      TO E-FCK210-DATA-PARTCCC  
             MOVE ' CATEGORY MISSING FROM CSS_WQ_PGM_CNTL'              
                                              TO E-FCK210-DATA-PARTCCC  
             WRITE FCSKR210                                             
             MOVE SPACES                      TO E-FCK210-DATA-REC      
             WRITE FCSKR210                                             
             MOVE WS-PGRMNAME                 TO WS-PRGM                
             MOVE  EMAIL-PRG                  TO E-FCK210-DATA-REC      
             WRITE FCSKR210                                             
             MOVE EMAIL-HDN-REC               TO E-FCK210-DATA-REC      
             WRITE FCSKR210                                             
             MOVE 'N' TO WS-FST-TIME                                    
           END-IF.                                                      
           MOVE  WS-COMP-NO                   TO WS-EMAIL-COMP          
           MOVE  AT-ACCOUNT-NO                TO WS-EMAIL-ACCT          
           MOVE  WS-CATEGORY-ID               TO WS-EMAIL-CAT           
           MOVE  WS-REG-GRP-CD                TO WS-EMAIL-REG-GRP       
           MOVE  WS-SEN-FL                    TO WS-EMAIL-SEN-FL        
           MOVE  EMAIL-DTL-REC                TO E-FCK210-DATA-REC      
           WRITE FCSKR210.                                              
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  8510-GENERATE-SR-WQ                                         **        
      ******************************************************************        
      *                                                                         
       8510-GENERATE-SR-WQ.                                             
      *                                                                         
           INITIALIZE WS-COMMENTS.                                      
           MOVE 241 TO WS-MISC-CATEGORY-ID.                             
P0599A     MOVE 4   TO WS-MISC-WQ-ROUTE.                                
           MOVE +249 TO WS-MISC-MSG-LEN.                                
           MOVE WS-SEB-REG-SENIOR-WQ TO WS-MISC-MSG-TEXT.               
                                                                        
           PERFORM 1360-CHECK-WQ-FL       THRU 1360-EXIT.               
                                                                        
           MOVE 'N'                  TO WS-DNP-READY-SW.                
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET CODE_ACCT_BILLED = 'H'                            
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**  PROCESSING ERROR IN PGM PCSKR210  **'       
               DISPLAY '**  PARA - 8510-GENERATE-SR-WQ        **'       
               DISPLAY '**      ERROR DURING UPDATE OF        **'       
               DISPLAY '**             CSS_ACCOUNT            **'       
               DISPLAY '**  RC = ' WS-DISPLAY-SQLCODE                   
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8520-UPDATE-CREDIT-PROFILE                                     *        
      ******************************************************************        
      *                                                                         
       8520-UPDATE-CREDIT-PROFILE.                                      
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_CREDIT_PROFILE                                
                  SET DISC_EXCEPTN_HIST  = :CZ-DISC-EXCEPTN-HIST,       
                      DISCONNECT_HIST    = :CZ-DISCONNECT-HIST,         
                      LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP(),           
                      AUTO_DEP_AM        = :CZ-AUTO-DEP-AM              
               WHERE ACCOUNT_NO  =  :CZ-ACCOUNT-NO                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CREDIT_PROFILE                                        
MFA-TR*           SET DISC_EXCEPTN_HIST  = :CZ-DISC-EXCEPTN-HIST,               
MFA-TR*               DISCONNECT_HIST    = :CZ-DISCONNECT-HIST,                 
MFA-TR*               LAST_UPDATE_TS     = CURRENT TIMESTAMP,                   
MFA-TR*               AUTO_DEP_AM        = :CZ-AUTO-DEP-AM                      
MFA-TR*        WHERE ACCOUNT_NO  =  :CZ-ACCOUNT-NO                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '** PROCESSING ERROR IN PGM PCSKR210  **'         
              DISPLAY '** CREDIT_PROFILE TABLE                   '      
              DISPLAY '** ACCOUNT NO = ' CZ-ACCOUNT-NO                  
              DISPLAY '** 8520 :  RETURN CODE ERROR - UPDATE'           
              DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE             
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8530-UPDATE-CRED-COLL                                          *        
      ******************************************************************        
      *                                                                         
       8530-UPDATE-CRED-COLL.                                           
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_CRED_COLL                                     
                  SET AMT_NOTICE        = :CL-AMT-NOTICE,               
                      PROCESSED_CD      = 'D'                           
               WHERE ACCOUNT_NO       = :CL-ACCOUNT-NO                  
                AND  ITEM_ID          = :CL-ITEM-ID                     
                AND  CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '** PROCESSING ERROR IN PGM PCSKR210  **'         
              DISPLAY '** CRED_COLL TABLE                   '           
              DISPLAY '** ACCOUNT NO = ' CL-ACCOUNT-NO                  
              DISPLAY '** CODE NOTICE TYPE = ' CL-CODE-NOTICE-TYPE      
              DISPLAY '** AMT NOTICE = ' CL-AMT-NOTICE                  
              DISPLAY '** 8530 :  RETURN CODE ERROR - UPDATE'           
              DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE             
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8530-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *     8620-INSERT-SO-ORD-INST.                                   *        
      ******************************************************************        
      *                                                                         
       8620-INSERT-SO-ORD-INST.                                         
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_SO_ORD_INST_MF                           
                      (ACCOUNT_NO,                                      
                      CODE_METER_LOC,                                   
                      CODE_UTIL_TYPE,                                   
                      METER_NO,                                         
                      METER_SUPPLYING,                                  
                      SO_DATA_SEQ_NO,                                   
                      SO_INST_SEQ_NO,                                   
                      WORK_TYPE_CD)                                     
               VALUES (:WB-ACCOUNT-NO,                                  
                      :WB-CODE-METER-LOC,                               
                      :WB-CODE-UTIL-TYPE,                               
                      :WB-METER-NO,                                     
                      :WB-METER-SUPPLYING,                              
                      CIS.CHAR2TIMESTAMP(:WS-TIMESTAMP),                        
                      :WB-SO-INST-SEQ-NO,                               
                      :WB-WORK-TYPE-CD)                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_ORD_INST_MF                                   
MFA-TR*               (ACCOUNT_NO,                                              
MFA-TR*               CODE_METER_LOC,                                           
MFA-TR*               CODE_UTIL_TYPE,                                           
MFA-TR*               METER_NO,                                                 
MFA-TR*               METER_SUPPLYING,                                          
MFA-TR*               SO_DATA_SEQ_NO,                                           
MFA-TR*               SO_INST_SEQ_NO,                                           
MFA-TR*               WORK_TYPE_CD)                                             
MFA-TR*        VALUES (:WB-ACCOUNT-NO,                                          
MFA-TR*               :WB-CODE-METER-LOC,                                       
MFA-TR*               :WB-CODE-UTIL-TYPE,                                       
MFA-TR*               :WB-METER-NO,                                             
MFA-TR*               :WB-METER-SUPPLYING,                                      
MFA-TR*               :WS-TIMESTAMP,                                            
MFA-TR*               :WB-SO-INST-SEQ-NO,                                       
MFA-TR*               :WB-WORK-TYPE-CD)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*****************PCSKR210*****************'     
               DISPLAY '** PROCESSING ERROR IN PGM PCSKR210  **'        
               DISPLAY '** 8620-INSERT-SO-ORD-INST  **'                 
               DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE           
               DISPLAY '** ACCOUNT NO = ' WB-ACCOUNT-NO                 
               DISPLAY '*****************PCSKR210*****************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   8630-INSERT-SO-DATA-MF                                       *        
      ******************************************************************        
      *                                                                         
       8630-INSERT-SO-DATA-MF.                                          
      *                                                                         
             EXEC SQL                                                   
                  INSERT INTO CSS_SO_DATA_MF                            
                  (PREMISE_NO, ACCOUNT_NO,                              
                   COMPANY_NO,                                          
                   ORDER_TYPE_CD, LOCAL_OFFICE,                         
                   SERV_ORDER_STATUS, WORK_INDICATOR,                   
                   ORDER_PLACED_BY, ORDER_RECVED_BY,                    
                   WANTED_BY_AM_PM, WANTED_BY_DATE,                     
                   DATE_RECVED, ORDER_REASON,                           
                   BACK_DATED, RESP_AREA_ID,                            
                   MAKE_ARRANGEMENTS, NOTIFY_CUST_IND,                  
                   NOTIFY_CSR_IND, DEPOSIT_AMT,                         
                   INIT_BY_CONTRACT,                                    
                   ORDER_PRIORITY_CD, AMT_DNP_AT_BILLING,               
                   SO_DATA_SEQ_NO,                                      
                   DATE_FORECAST_DNP, ORDER_STAT_REASON)                
                  VALUES                                                
                  (:XE-PREMISE-NO,:XE-ACCOUNT-NO,                       
                   :XE-COMPANY-NO,                                      
                   :XE-ORDER-TYPE-CD, :XE-LOCAL-OFFICE,                 
                   :XE-SERV-ORDER-STATUS, :XE-WORK-INDICATOR,           
                   :XE-ORDER-PLACED-BY, :XE-ORDER-RECVED-BY,            
                   :XE-WANTED-BY-AM-PM, IIF(TRY_CONVERT(DATE, 
                                                     :XE-WANTED-BY-DATE
              ) IS NULL OR (PATINDEX('%.%', :XE-WANTED-BY-DATE
              ) <> 0) OR (LEN(:XE-WANTED-BY-DATE
              ) <> 10), CIS.CHAR2DATE(:XE-WANTED-BY-DATE
              ), CONVERT(DATE, :XE-WANTED-BY-DATE) ),             
                   IIF(TRY_CONVERT(DATE, :XE-DATE-RECVED
              ) IS NULL OR (PATINDEX('%.%', :XE-DATE-RECVED
              ) <> 0) OR (LEN(:XE-DATE-RECVED) <> 10), CIS.CHAR2DATE(
                                                        :XE-DATE-RECVED
              ), CONVERT(DATE, :XE-DATE-RECVED) ), :XE-ORDER-REASON,           
                   :XE-BACK-DATED, :XE-RESP-AREA-ID,                    
                   :XE-MAKE-ARRANGEMENTS, :XE-NOTIFY-CUST-IND,          
                   :XE-NOTIFY-CSR-IND, :XE-DEPOSIT-AMT,                 
                   :XE-INIT-BY-CONTRACT,                                
                   :XE-ORDER-PRIORITY-CD, :XE-AMT-DNP-AT-BILLING,       
                   CIS.CHAR2TIMESTAMP(:WS-TIMESTAMP),                           
                   IIF(TRY_CONVERT(DATE, :XE-DATE-FORECAST-DNP
              ) IS NULL OR (PATINDEX('%.%', :XE-DATE-FORECAST-DNP
              ) <> 0) OR (LEN(:XE-DATE-FORECAST-DNP
              ) <> 10), CIS.CHAR2DATE(:XE-DATE-FORECAST-DNP
              ), CONVERT(DATE, :XE-DATE-FORECAST-DNP) ), 
                                                 :XE-ORDER-STAT-REASON)        
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*      EXEC SQL                                                           
MFA-TR*           INSERT INTO CSS_SO_DATA_MF                                    
MFA-TR*           (PREMISE_NO, ACCOUNT_NO,                                      
MFA-TR*            COMPANY_NO,                                                  
MFA-TR*            ORDER_TYPE_CD, LOCAL_OFFICE,                                 
MFA-TR*            SERV_ORDER_STATUS, WORK_INDICATOR,                           
MFA-TR*            ORDER_PLACED_BY, ORDER_RECVED_BY,                            
MFA-TR*            WANTED_BY_AM_PM, WANTED_BY_DATE,                             
MFA-TR*            DATE_RECVED, ORDER_REASON,                                   
MFA-TR*            BACK_DATED, RESP_AREA_ID,                                    
MFA-TR*            MAKE_ARRANGEMENTS, NOTIFY_CUST_IND,                          
MFA-TR*            NOTIFY_CSR_IND, DEPOSIT_AMT,                                 
MFA-TR*            INIT_BY_CONTRACT,                                            
MFA-TR*            ORDER_PRIORITY_CD, AMT_DNP_AT_BILLING,                       
MFA-TR*            SO_DATA_SEQ_NO,                                              
MFA-TR*            DATE_FORECAST_DNP, ORDER_STAT_REASON)                        
MFA-TR*           VALUES                                                        
MFA-TR*           (:XE-PREMISE-NO,:XE-ACCOUNT-NO,                               
MFA-TR*            :XE-COMPANY-NO,                                              
MFA-TR*            :XE-ORDER-TYPE-CD, :XE-LOCAL-OFFICE,                         
MFA-TR*            :XE-SERV-ORDER-STATUS, :XE-WORK-INDICATOR,                   
MFA-TR*            :XE-ORDER-PLACED-BY, :XE-ORDER-RECVED-BY,                    
MFA-TR*            :XE-WANTED-BY-AM-PM, :XE-WANTED-BY-DATE,                     
MFA-TR*            :XE-DATE-RECVED, :XE-ORDER-REASON,                           
MFA-TR*            :XE-BACK-DATED, :XE-RESP-AREA-ID,                            
MFA-TR*            :XE-MAKE-ARRANGEMENTS, :XE-NOTIFY-CUST-IND,                  
MFA-TR*            :XE-NOTIFY-CSR-IND, :XE-DEPOSIT-AMT,                         
MFA-TR*            :XE-INIT-BY-CONTRACT,                                        
MFA-TR*            :XE-ORDER-PRIORITY-CD, :XE-AMT-DNP-AT-BILLING,               
MFA-TR*            :WS-TIMESTAMP,                                               
MFA-TR*            :XE-DATE-FORECAST-DNP, :XE-ORDER-STAT-REASON)                
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*****************PCSKR210*****************'     
               DISPLAY '** 8630-INSERT-SO-DATA-MF  **'                  
               DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE           
               DISPLAY '** ACCOUNT NO = ' XE-ACCOUNT-NO                 
               DISPLAY '*****************PCSKR210*****************'     
               PERFORM 9900-ABEND    THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                         
       8630-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*EJECT                                                                    
      *                                                                         
      ******************************************************************        
      * 8650-DELETE-CRED-COLL                                          *        
      ******************************************************************        
      *                                                                         
       8650-DELETE-CRED-COLL.                                           
      *                                                                         
           EXEC SQL                                                     
              DELETE FROM CSS_CRED_COLL                                 
               WHERE ACCOUNT_NO        = :CL-ACCOUNT-NO                 
                 AND CODE_NOTICE_TYPE  = :CL-CODE-NOTICE-TYPE           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                         WS-DISPLAY-SQLCODE.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**************PCSKR210**************************'
              DISPLAY '* 8650-DELETE-CRED-COLL                        *'
              DISPLAY '* ACCOUNT NO       : ' CL-ACCOUNT-NO             
              DISPLAY '* ITEM ID          : ' CL-ITEM-ID                
              DISPLAY '* CODE NOTICE TYPE : ' CL-CODE-NOTICE-TYPE       
              DISPLAY '* SQLCODE          : ' WS-DISPLAY-SQLCODE        
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '***********PCSKR210*****************************'
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       8650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8890-COMMIT.                                                   *        
      ******************************************************************        
      *                                                                         
       8890-COMMIT.                                                     
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
      *                                                                         
           DISPLAY '**********************************************'     
           DISPLAY '* COMMIT POINT # ' WS-COMMIT-COUNTER ' TAKEN.   *'  
           DISPLAY '* LAST REC PROCESSED  = ' AT-ACCOUNT-NO             
           DISPLAY '**********************************************'.    
      *                                                                         
       8890-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8895-INSERT-WORK-QUEUE.                                        *        
      ******************************************************************        
ACT034*                                                                         
ACT034 8895-INSERT-WORK-QUEUE.                                          
ACT034*                                                                         
ACT034     CALL SCSCB077 USING CWS00077-FIELDS,                         
ACT034                         ABEND-FILE,                              
ACT034                         RS-RETURN-CODE.                          
ACT034                                                                  
ACT034     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE.                
ACT034                                                                  
ACT034     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
ACT034        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
ACT034        DISPLAY '8895-INSERT-WORK-QUEUE'                          
ACT034        DISPLAY 'CALL SCSCB077         '                          
ACT034        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
ACT034        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
ACT034        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
ACT034        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
ACT034        PERFORM 9900-ABEND    THRU 9900-EXIT                      
ACT034     END-IF.                                                      
ACT034*                                                                         
ACT034 8895-EXIT.                                                       
ACT034     EXIT.                                                        
      *                                                                         
      ************************************************************              
      * THE BELOW PARAGRAPH IS NECESSARY TO BE ABLE TO USE THE   *              
      * COPYBOOK FOR WRITING THE MH AND MI.                      *              
      ************************************************************              
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
      *                                                                         
      ******************************************************************        
      * 9000-TERMINATE.                                                *        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSKR210-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  9700-PROCESS-ABEND.                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
      *                                                                         
      ************************************************************              
      * THE BELOW PARAGRAPH IS NECESSARY TO BE ABLE TO USE THE   *              
      * COPYBOOK FOR WRITING THE MH AND MI.                      *              
      ************************************************************              
      *                                                                         
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
