       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSKR205.                                        
       DATE-WRITTEN.   MAY 2012.                                        
      ******************************************************************        
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **        
      **                                                              **        
      *********           CUSTOMER SERVICE SYSTEM              *********        
      *********                     DB2                        *********        
      **                                                              **        
      ******************************************************************        
      **--------------- P R O G R A M  S U M M A R Y -----------------**        
      *************************************************************** **        
      **   THIS PROGRAM WILL PROCESS CREDIT ACTION WORK QUEUES FOR    **        
      **   ACTIVE ACCOUNTS AND INSERTS INTO THE CSS_WQ_ITEMS_MF TABLE.**        
      ******************************************************************        
      **------------- PROGRAM  MODIFICATION  LOG -------------------- **        
      ******************************************************************        
      **      PCSKR205   PROGRAM  MODIFICATION  LOG                   **        
      **                                                              **        
      **   DATE        INITIALS  REASON                               **        
      **   __________  ________  ______________                       **        
P00599**   05/16/2012  RC41079   INITIAL PROGRAM VERSION.             **        
A03967**   11/26/2012  MJ13662   ACTIVITY 135 - WHEN NON UTIL WQ IS   **        
      **                         GENERATED, SET SWITCH SO THAT 'M'/X  **        
      **                         ROWS ARE NOT DELETED ERRONEOUSLY.    **        
ACT033**   04/28/2014  SS7F226   WORK QUEUE CHANGE TO REPLACE THE     **        
ACT033**               A04860    CSS_WQ_ITEMS_MF WITH CSS_WQ_ITEMS.   **        
      **                                                              **        
      ******************************************************************        
      **----------------- BASIC SEQUENCE STRUCTURE -------------------**        
      *************************************************************** **        
      **         0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION **        
      **         1000 - 1999     INPUT PROCESSING CONTROL PATH        **        
      **         2000 - 2999     OUTPUT PROCESSING CONTROL PATH       **        
      **         3000 - 4999     BATCH PROCESSING MODULES - NOT USED  **        
      **         5000 - 5999     COMMON PROGRAM MODULES               **        
      **         6000 - 6999     COMMON SYSTEM MODULES                **        
      **         7000 - 7999     INPUT MODULES                        **        
      **         8000 - 8999     OUTPUT MODULES                       **        
      **         9000 - 9799     TERMINATION MODULES                  **        
      **         9900 - 9999     ABEND/ABORT MODULES                  **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
           SELECT FCSKR205-FILE                                         
               ASSIGN UT-S-FCSKR205                                     
               FILE STATUS IS WS-FKR205-STATUS.                         
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
       FD  FCSKR205-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORD CONTAINS 80 CHARACTERS                                
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01  FCSKR205.                                                    
           05  E-FCK205-DATA-REC.                                       
               10  E-FCK205-DATA-PART1               PIC X(22).         
               10  E-FCK205-DATA-PART2               PIC X(13).         
               10  E-FCK205-DATA-PART3               PIC X(45).         
           05  E-FCK205-DATA-REC1 REDEFINES E-FCK205-DATA-REC.          
               10  E-FCK205-DATA-PARTA               PIC X(14).         
               10  E-FCK205-DATA-PARTB               PIC X(28).         
               10  E-FCK205-DATA-PARTC               PIC X(38).         
           05  E-FCK205-DATA-REC2 REDEFINES E-FCK205-DATA-REC.          
               10  E-FCK205-DATA-PARTAA              PIC X(18).         
               10  E-FCK205-DATA-PARTBB              PIC X(28).         
               10  E-FCK205-DATA-PARTCC              PIC X(34).         
           05  E-FCK205-DATA-REC3 REDEFINES E-FCK205-DATA-REC.          
               10  E-FCK205-DATA-PARTAAA             PIC X(20).         
               10  E-FCK205-DATA-PARTBBB             PIC X(08).         
               10  E-FCK205-DATA-PARTCCC             PIC X(52).         
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSKR205'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)                      
           VALUE 'WORKING STORAGE FOR PCSKR205 STARTS HERE'.            
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME               PIC X(08)    VALUE 'PCSKR205'.
           05  WS-PGRMNAME                PIC X(08)    VALUE 'PCSKR205'.
           05  WS-E                       PIC X(01)    VALUE 'E'.       
           05  WS-J                       PIC X(01)    VALUE 'J'.       
           05  WS-M                       PIC X(01)    VALUE 'M'.       
           05  WS-N                       PIC X(01)    VALUE 'N'.       
           05  WS-U                       PIC X(01)    VALUE 'U'.       
           05  WS-Y                       PIC X(01)    VALUE 'Y'.       
           05  SCSCB068                   PIC X(08)    VALUE 'SCSCB068'.
P00599     05  SCSCA151                   PIC X(08)    VALUE 'SCSCA151'.
ACT033     05  SCSCB077                   PIC X(08)    VALUE 'SCSCB077'.
      *                                                                         
       01  WS-MISC.                                                     
           05  RS-RETURN-CODE             PIC S9(04)    COMP VALUE 0.   
           05  S-RETURN-CODE              PIC S9(04)    COMP VALUE 0.   
           05  RS-RETURN-CODE-DISP        PIC S9(04)    COMP VALUE 0.   
           05  WS-DATE-CRED-ACT-NULL      PIC S9(4)     COMP.           
           05  WS-NON-UTL-CR-HST          PIC X(24)    VALUE SPACES.    
           05  WS-NON-UTL-CR-HST-EX       PIC X(24)    VALUE SPACES.    
           05  WS-DISPLAY-SQLCODE         PIC -ZZZZZZZZ9.               
           05  WS-NEXT-BUSINESS-DAY       PIC X(10)    VALUE SPACES.    
COB305     05 WS-TOT-60PLUS-ARREARS        PIC S9(09)V99 COMP-3 VALUE 0.        
P00599     05  WS-ACCOUNT-NO              PIC S9(13)V  COMP-3 VALUE 0.  
ACT033     05  WS-INPUT-ZERO              PIC X(16)                     
ACT033                                    VALUE '-00.00.00.000000'.     
ACT033     05  WS-INPUT-DATE-26           PIC X(26) VALUE SPACES.       
      *                                                                         
       01  WS-WQ-CATEGORY-ID              PIC S9(04)    COMP VALUE 0.   
      *                                                                         
       01  WS-COMMENTS.                                                 
           05 WS-COMMENTS-LEN             PIC S9(4) USAGE COMP.         
           05 WS-COMMENTS-TEXT            PIC X(250).                   
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-GUARANTOR-EXISTS       PIC X(01).                     
               88  GUARANTOR-EXISTS                   VALUE 'Y'.        
           05  WS-FKR205-STATUS          PIC XX       VALUE '  '.       
               88 FKR205-SUCCESSFUL                   VALUE '00'.       
           05  WS-FST-TIME               PIC X(01)    VALUE 'Y'.        
           05  WS-DATABASE               PIC 9(01)    VALUE ZERO.       
               88  CSR-DATABASE                       VALUE 1.          
               88  SEB-DATABASE                       VALUE 2.          
P00599     05  WS-PROCESS-ACCOUNT        PIC X(01)    VALUE 'Y'.        
P00599         88  PROCESS-ACCT                       VALUE 'Y'.        
P00599         88  SKIP-ACCT                          VALUE 'N'.        
      *                                                                         
       01  WS-COMMIT-VARS.                                              
           05  WS-COMMIT-COUNTER         PIC 9(04)     VALUE ZEROS.     
           05  WS-RECS-TO-COMMIT-COUNTER PIC 9(04)     VALUE ZEROS.     
           05  WS-READY-TO-COMMIT-COUNT  PIC S9(09) COMP VALUE +0.      
      *                                                                         
       01  WS-WORKQUEUE-COMMENTS.                                       
           05  WS-DEL-NONUTL.                                           
               10 FILLER              PIC X(06) VALUE 'DESC. '.         
               10 WS-DEL-NU-WQ-DESC   PIC X(30) VALUE SPACES.           
               10 FILLER              PIC X(09) VALUE ' 90 DAY ='.      
               10 WS-WQ-90DAY         PIC $$$$$$$$9.99.                 
               10 FILLER              PIC X(09) VALUE ' 60 DAY ='.      
               10 WS-WQ-60DAY         PIC $$$$$$$$9.99.                 
               10 FILLER              PIC X(09) VALUE ' 30 DAY ='.      
               10 WS-WQ-30DAY         PIC $$$$$$$$9.99.                 
               10 FILLER              PIC X(09) VALUE ' 00 DAY ='.      
               10 WS-WQ-00DAY         PIC $$$$$$$$9.99.                 
               10 FILLER              PIC X(24) VALUE                   
                      ' TOTAL NON UTIL BILLED ='.                       
               10 WS-WQ-NU-BIL-BAL    PIC $$$$$$$$9.99.                 
               10 FILLER              PIC X(36) VALUE                   
                      ' TOTAL NON UTIL ARREARS > 60 DAYS = '.           
               10 WS-WQ-NU-ARR-P60    PIC $$$$$$$$9.99.                 
      *                                                                         
           05  WS-DEL-NONUTL-EXEMPT   PIC X(97)  VALUE                  
               'EXEMPT CREDIT GROUP, NON UTILITY 60 DAYS PAST DUE, REVIE        
      -        'W FOR FOR POSSIBLE CUSTOMER SERVICE ISSUE'.                     
      *                                                                         
           05  WS-MASTER-90-DAY           PIC X(41)  VALUE              
               'CONSOLIDATED BILL MASTER - 90 DAY ARREARS'.             
      *                                                                         
           05  WS-CREDIT-BUR-NOT-EXEMPT   PIC X(31)  VALUE              
               'CREDIT BUREAU AND NOTICE EXEMPT'.                       
      *                                                                         
           05  WS-CREDIT-BUR-EXEMPT       PIC X(20)  VALUE              
               'CREDIT BUREAU EXEMPT'.                                  
      *                                                                         
           05  WS-NON-UTILITY-GUARANTOR   PIC X(38)  VALUE              
               'NON-UTILITY GUARANTOR - 90 DAY ARREARS'.                
      *                                                                         
           05  WS-AMT-NONUTIL-WQ-MIN-CD   PIC X(20)  VALUE              
                                          'AMT-NONUTIL-WQ-MIN  '.       
      *                                                                         
COB305     05 WS-AMT-NONUTIL-WQ-MIN        PIC S9(11)V9(5) COMP-3 
COB305       VALUE 0.       
      *                                                                         
       01  EMAIL-TO.                                                    
           05  EMAIL-TO-REC.                                            
               10  WS-PRG-TO              PIC X(08) VALUE SPACES.       
               10  FILLER                 PIC X(21) VALUE               
                                           '@SCEGJES2.SCANA.COM> '.     
      *                                                                         
       01  EMAIL-PRG.                                                   
           05  EMAIL-PRG-REC.                                           
               10  FILLER                 PIC X(17) VALUE               
                                                   '*****************'. 
               10  WS-PRGM                PIC X(08) VALUE SPACES.       
               10  FILLER                 PIC X(17) VALUE               
                                                   '*****************'. 
      *                                                                         
       01  EMAIL-HDN.                                                   
           05  EMAIL-HDN-REC.                                           
               10  FILLER                 PIC X(08) VALUE 'COMPANY'.    
               10  FILLER                 PIC X(03) VALUE SPACES.       
               10  FILLER                 PIC X(10) VALUE 'ACCOUNT NO'. 
               10  FILLER                 PIC X(06) VALUE SPACES.       
               10  FILLER                 PIC X(11) VALUE 'CATEGORY ID'.
               10  FILLER                 PIC X(03) VALUE SPACES.       
               10  FILLER                 PIC X(10) VALUE 'REG GRP CD'. 
               10  FILLER                 PIC X(03) VALUE SPACES.       
               10  FILLER                 PIC X(09) VALUE 'SENIOR FL'.  
      *                                                                         
       01  EMAIL-DTL.                                                   
           05  EMAIL-DTL-REC.                                           
               10  WS-EMAIL-COMP          PIC X(02)      VALUE SPACES.  
               10  FILLER                 PIC X(09)      VALUE SPACES.  
               10  WS-EMAIL-ACCT          PIC X(13)      VALUE SPACES.  
               10  FILLER                 PIC X(10)      VALUE SPACES.  
               10  WS-EMAIL-CAT           PIC 9(04)      VALUE 0.       
               10  FILLER                 PIC X(09)      VALUE SPACES.  
               10  WS-EMAIL-REG-GRP       PIC X(03)      VALUE SPACES.  
               10  FILLER                 PIC X(11)      VALUE SPACES.  
               10  WS-EMAIL-SEN-FL        PIC X(01)      VALUE SPACES.  
      *                                                                         
      ******************************************************************        
      * CWS00010 CONTAINS DB2 ABEND VARIABLES                          *        
      ******************************************************************        
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
      ******************************************************************        
      * WS-ABEND-SWITCH                                                *        
      ******************************************************************        
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
      ******************************************************************        
      * CWS00039 JOB PARM ROUTINE                                      *        
      ******************************************************************        
      *                                                                         
       COPY CWS00039.                                                           
      *                                                                         
P00599******************************************************************        
P00599* VARIABLES NEEDED FOR ACCOUNT SKIP PROCESSING.                  *        
P00599******************************************************************        
P00599*                                                                         
P00599 COPY CWSCA151.                                                           
P00599*                                                                         
      ******************************************************************        
      * FIOJC01 WORKING STORAGE                                        *        
      ******************************************************************        
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      ******************************************************************        
      * FCA00-KEY                                                      *        
      ******************************************************************        
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR CODES-DATA-PRESENT                         *        
      ******************************************************************        
      *                                                                         
       COPY CWS00056.                                                           
      *                                                                         
      ******************************************************************        
      * CWS00303 JOB PARM ROUTINE CONTAINS WS-WARNING-DATA-ELEMENTS    *        
      ******************************************************************        
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      ******************************************************************        
      * DB2 COMMUNICATION REQUIREMENT                                  *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CWS00038 JOB PARM ROUTINE                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
       01  WS-INSERT-ROW-COUNT REDEFINES WS-INPUT-DATA-BREAKDOWN.       
           10  WS-PARM-COMMIT-ROW-COUNT-TXT PIC X(09).                  
               88 COMMIT-ROW-CNT         VALUE 'COMMIT = '.             
           10  WS-NO-OF-ROWS-TO-COMMIT   PIC X(05).                     
           10  FILLER                    PIC X(66).                     
      *                                                                         
      *****************************************************************         
      * CWS00068 CONTAINS WS FOR CALC OF ARREARS, DISCONNECT AMT,     *         
      * PASTE DUE, AND NUMEROUS DATES.                                *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CWS00322 CONTAINS WS FOR FINDING NEXT BUSINESS DAY            *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00322                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CWS00346 CONTAINS WS GETTING WQ GENERATION FLAG               *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00346                                                   
           END-EXEC.                                                            
      *                                                                         
ACT033******************************************************************        
ACT033* FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077          *        
ACT033******************************************************************        
ACT033*                                                                         
ACT033     EXEC SQL                                                             
ACT033         INCLUDE CWS00077                                                 
ACT033     END-EXEC.                                                            
ACT033*                                                                         
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSKR205 ENDS HERE  '.            
      *                                                                         
      ******************************************************************        
      * CSS_ACCOUNT        - AT                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_AR_CNTL        - AC                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBARCNTL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_BUSINESS_DAYS  - 1G                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBUSDAY                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CONTRACT - CZ                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCNTRCT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CONTRACT_INFO - K6                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCNTINF                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CRED_COLL - CL                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCRCOLL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CREDIT_PROFILE - CZ                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCRPROF                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_DELINQUENCY    - C8                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_GUARANTOR - GU                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGTNTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_JOB_PARM       - G6                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_REG_PROFILE    - LR                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBREGPRF                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_WQ_PGM_CNTL  - WN                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBWQCNTL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CURSOR DECLARATION                                             *        
      ******************************************************************        
      *****************************************                                 
      * WQ_CSR                                                                  
      *****************************************                                 
           EXEC SQL                                                     
               DECLARE WQ_CSR CURSOR WITH HOLD FOR                      
               SELECT  AT.CUSTOMER_NO,                                  
                       AT.ACCOUNT_NO,                                   
                       AT.PREMISE_NO,                                   
                       AT.COMPANY_NO,                                   
                       AT.LOCAL_OFFICE,                                 
                       AT.DATE_BILL_DAY_00,                             
                       AT.DATE_BILL_DAY_30,                             
                       AT.DATE_BILL_DAY_60,                             
                       AT.DATE_BILL_DAY_90,                             
                       AT.BILL_CYCLE,                                   
                       AT.TOTAL_AR_BALANCE,                             
                       AT.CODES_DATA_PRESENT,                           
                       AT.CODE_ACCT_STAT,                               
                       AT.CREDIT_GROUP,                                 
                       AT.ACCOUNT_TYPE_CODE,                            
                       AT.CODE_STATUS_REASON,                           
                       AT.NOTICE_EXEMPT_CD,                             
                       AT.IVR_EXEMPT_CD,                                
                       AT.CODE_DISC_OK,                                 
                       AT.BANKRUPTCY_IND,                               
                       CL.DATE_CREDIT_ACTION,                           
                       CL.CODE_NOTICE_TYPE,                             
                       CL.ITEM_ID                                       
               FROM    CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                      ,CSS_CRED_COLL CL WITH(READUNCOMMITTED)                   
               WHERE   AT.ACCOUNT_NO         = CL.ACCOUNT_NO            
                 AND   AT.CODE_ACCT_STAT     = 'A'                      
                 AND   CL.DATE_CREDIT_ACTION = IIF(TRY_CONVERT(DATE, 
                                                  :WS-NEXT-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEXT-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEXT-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEXT-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEXT-BUSINESS-DAY) )    
                 AND   CL.CODE_NOTICE_TYPE  IN  ('M','X')               
                 AND   CL.PROCESSED_CD      = ' '                       
               ORDER BY AT.ACCOUNT_NO, CL.CODE_NOTICE_TYPE              
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE WQ_CSR CURSOR WITH HOLD FOR                              
MFA-TR*        SELECT  AT.CUSTOMER_NO,                                          
MFA-TR*                AT.ACCOUNT_NO,                                           
MFA-TR*                AT.PREMISE_NO,                                           
MFA-TR*                AT.COMPANY_NO,                                           
MFA-TR*                AT.LOCAL_OFFICE,                                         
MFA-TR*                AT.DATE_BILL_DAY_00,                                     
MFA-TR*                AT.DATE_BILL_DAY_30,                                     
MFA-TR*                AT.DATE_BILL_DAY_60,                                     
MFA-TR*                AT.DATE_BILL_DAY_90,                                     
MFA-TR*                AT.BILL_CYCLE,                                           
MFA-TR*                AT.TOTAL_AR_BALANCE,                                     
MFA-TR*                AT.CODES_DATA_PRESENT,                                   
MFA-TR*                AT.CODE_ACCT_STAT,                                       
MFA-TR*                AT.CREDIT_GROUP,                                         
MFA-TR*                AT.ACCOUNT_TYPE_CODE,                                    
MFA-TR*                AT.CODE_STATUS_REASON,                                   
MFA-TR*                AT.NOTICE_EXEMPT_CD,                                     
MFA-TR*                AT.IVR_EXEMPT_CD,                                        
MFA-TR*                AT.CODE_DISC_OK,                                         
MFA-TR*                AT.BANKRUPTCY_IND,                                       
MFA-TR*                CL.DATE_CREDIT_ACTION,                                   
MFA-TR*                CL.CODE_NOTICE_TYPE,                                     
MFA-TR*                CL.ITEM_ID                                               
MFA-TR*        FROM    CSS_ACCOUNT AT                                           
MFA-TR*               ,CSS_CRED_COLL CL                                         
MFA-TR*        WHERE   AT.ACCOUNT_NO         = CL.ACCOUNT_NO                    
MFA-TR*          AND   AT.CODE_ACCT_STAT     = 'A'                              
MFA-TR*          AND   CL.DATE_CREDIT_ACTION = :WS-NEXT-BUSINESS-DAY            
MFA-TR*          AND   CL.CODE_NOTICE_TYPE  IN  ('M','X')                       
MFA-TR*          AND   CL.PROCESSED_CD      = ' '                               
MFA-TR*        ORDER BY AT.ACCOUNT_NO, CL.CODE_NOTICE_TYPE                      
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS MAIN PROCESSING OF PROGRAM                            *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION              THRU 0100-EXIT.     
           PERFORM 1000-PROCESS-ACCT                THRU 1000-EXIT.     
           PERFORM 7220-CLOSE-CRED-COLL             THRU 7220-EXIT.     
           PERFORM 9000-TERMINATE                   THRU 9000-EXIT.     
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZATION.                                           *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           PERFORM 0110-GET-JOB-PARM-DATE        THRU 0110-EXIT.        
      *                                                                         
           OPEN OUTPUT FCSKR205-FILE.                                   
           IF NOT FKR205-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSKR205           **'        
               DISPLAY '**  FILE STATUS = ' WS-FKR205-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           PERFORM 0145-GET-DATABASE             THRU 0145-EXIT.        
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0110-GET-JOB-PARM-DATE                                         *        
      ******************************************************************        
      *                                                                         
       0110-GET-JOB-PARM-DATE.                                          
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE              THRU 6251-EXIT.     
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE   THRU 6240-EXIT      
               MOVE WS-FCA00-COMMON-DATE    TO WS-INPUT-DATE            
           END-IF.                                                      
      *                                                                         
           MOVE WS-INPUT-DATE          TO WS-NEW-BUSINESS-DAY           
                                          WS-HOLD-DATE.                 
      *                                                                         
           PERFORM 0115-GET-COMMIT-ROW-COUNT    THRU 0115-EXIT.         
      *                                                                         
           PERFORM 6500-GET-NEXT-BUSINESS-DAY                           
                         THRU 6500-NEXT-BUSINESS-DAY-EXIT.              
           MOVE WS-NEW-BUSINESS-DAY    TO WS-NEXT-BUSINESS-DAY.         
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0115-GET-COMMIT-ROW-COUNT.                                     *        
      * GET THE COMMIT ROW COUNT FROM JOB PARM TABLE                   *        
      ******************************************************************        
       0115-GET-COMMIT-ROW-COUNT.                                       
      *                                                                         
           MOVE  WS-PGRMNAME               TO WS-PROGRAM.               
           MOVE  WS-PARM                   TO WS-COMMAND.               
           MOVE  ZEROS                     TO WS-SEQUENCE.              
           MOVE  SPACES                    TO WS-SYSIPT.                
           MOVE  WS-KEY-AREA               TO E-FJC01-KEY.              
      *                                                                         
           PERFORM 7600-START-FCSJC01      THRU  7600-EXIT.             
           PERFORM 7610-READ-FCSJC01       THRU  7610-EXIT              
              UNTIL (COMMIT-ROW-CNT AND INPUT-ACTIVE)                   
              OR  END-OF-SYSIPT.                                        
      *                                                                         
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '** ' WS-PGRMNAME ' PROCESSING WARNING  **'       
              DISPLAY '**  COMMIT-ROW-CNT PARM NOT ACTIVE     **'       
              DISPLAY '**  DEFAULT OF 1000 WILL BE USED  **'            
              DISPLAY '**  PROCESSING CONTINUING        **'             
              MOVE 1000 TO WS-READY-TO-COMMIT-COUNT                     
           ELSE                                                         
              IF WS-NO-OF-ROWS-TO-COMMIT NUMERIC                        
                 MOVE WS-NO-OF-ROWS-TO-COMMIT                           
                                         TO WS-READY-TO-COMMIT-COUNT    
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY '**  ' WS-PGRMNAME ' PROCESSING WARNING  **'   
                 DISPLAY '**  COMMIT-ROW-CNT PARM NOT NUMERIC  **'      
                 DISPLAY '**  DEFAULT OF 1000 WILL BE USED  **'         
                 DISPLAY '**  PROCESSING CONTINUING        **'          
                 MOVE 1000 TO WS-READY-TO-COMMIT-COUNT                  
              END-IF                                                    
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           END-IF.                                                      
      *                                                                         
       0115-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0145-GET-DATABASE.                                             *        
      ******************************************************************        
      *                                                                         
       0145-GET-DATABASE.                                               
      *                                                                         
           MOVE 'DATABASE'                TO C8-DELINQ-CD.              
           MOVE '01'                      TO C8-COMPANY-NO.             
           PERFORM 7010-SELECT-DELINQ-VALUE              THRU 7010-EXIT.
           MOVE C8-DELINQ-VALUE           TO WS-DATABASE.               
      *                                                                         
       0145-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0200-COMMIT                                                    *        
      * PROCESS COMMIT  AFTER RECORD COUNT HAS BEEN REACH              *        
      ******************************************************************        
      *                                                                         
       0200-COMMIT.                                                     
      *                                                                         
           ADD 1                       TO WS-COMMIT-COUNTER.            
           PERFORM 8890-COMMIT                   THRU 8890-EXIT.        
           MOVE ZEROS                  TO WS-RECS-TO-COMMIT-COUNTER.    
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   1000-PROCESS-ACCT                                            *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-ACCT.                                               
      *                                                                         
           INITIALIZE WS-COMMENTS.                                      
      *                                                                         
           PERFORM 7200-OPEN-CRED-COLL             THRU 7200-EXIT.      
           PERFORM 7210-FETCH-CRED-COLL            THRU 7210-EXIT.      
      *                                                                         
P00599     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
P00599        MOVE AT-ACCOUNT-NO         TO WS-ACCOUNT-NO               
P00599        PERFORM 5200-CHK-SKIP-ACCTS          THRU 5200-CPD347-EXIT
P00599                                                                  
P00599        IF PROCESS-ACCT                                           
P00599           PERFORM 1300-PROCESS-WORK-QUEUES  THRU 1300-EXIT       
P00599        END-IF                                                    
              PERFORM 7210-FETCH-CRED-COLL         THRU 7210-EXIT       
P00599     END-PERFORM.                                                 
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      *                                                                         
      ******************************************************************        
      *   1300-PROCESS-WORK-QUEUES                                     *        
      *                                                                *        
      * MODULE PROCESSES THE 'M' AND 'X'  CREDIT AND COLLECTION ROWS.  *        
      *                                                                *        
      * IF WS-AMT-NOTICE-M IS GREATER THAN ZERO WHEN RETURNED FROM     *        
      * CPD00068, THE APPROPRIATE WORKQUEUE WILL BE PRODUCED WITH      *        
      * APPLICABLE COMMENTS.                                           *        
      * IF WS-AMT-NOTICE-X IS GREATER THAN ZERO WHEN RETURNED FROM     *        
      * CPD00068, THE APPROPRIATE WORKQUEUE WILL BE PRODUCED WITH      *        
      * APPLICABLE COMMENTS.                                           *        
      ******************************************************************        
      *                                                                         
       1300-PROCESS-WORK-QUEUES.                                        
      *                                                                         
           INITIALIZE E-FCK205-DATA-REC                                 
                      E-FCK205-DATA-REC1                                
                      E-FCK205-DATA-REC2                                
                      E-FCK205-DATA-REC3                                
                      EMAIL-TO-REC                                      
                      EMAIL-HDN-REC                                     
                      EMAIL-DTL-REC                                     
                      WS-COMMENTS-TEXT.                                 
      *                                                                         
           MOVE WS-N                            TO WS-GENERATE-WQ-SW.   
           MOVE AT-ACCOUNT-NO                   TO CL-ACCOUNT-NO.       
           MOVE ZEROS                           TO WS-WQ-CATEGORY-ID.   
      *                                                                         
           PERFORM 2000-PROCESS-ACCT-AND-CRED-PRO       THRU 2000-EXIT. 
      *                                                                         
           PERFORM 3200-CALC-AMOUNTS-DATES              THRU 3200-EXIT. 
      *                                                                         
           ADD 1                           TO WS-RECS-TO-COMMIT-COUNTER.
      *                                                                         
           EVALUATE WS-NEXT-BUSINESS-DAY                                
             WHEN WS-DATE-CREDIT-ACTION-M                               
                 IF WS-CODE-SPECIAL-TYPE-M > SPACES                     
                   MOVE 'M'                 TO CL-CODE-NOTICE-TYPE      
                   IF WS-AMT-NOTICE-M > ZERO                            
                     EVALUATE WS-CODE-SPECIAL-TYPE-M                    
                       WHEN WS-N                                        
                       WHEN WS-J                                        
                       WHEN WS-U                                        
                          IF AT-CREDIT-GROUP = 'C'                      
                             PERFORM 1310-EXEMPT       THRU 1310-EXIT   
                          ELSE                                          
                             PERFORM 1320-NON-UTL-DELQ THRU 1320-EXIT   
                          END-IF                                        
      *** MASTER ACCT W/ 90 DAY DELINQUENCY                                     
                       WHEN WS-C                                        
                          PERFORM 1330-MASTER-DELQ     THRU 1330-EXIT   
      *** NON UTILITY ACCOUNT                                                   
                       WHEN WS-E                                        
                          PERFORM 1340-NUTL-ACCT-DELQ   THRU 1340-EXIT  
                     END-EVALUATE                                       
      *                                                                         
                     IF WS-WQ-CATEGORY-ID > 0                           
                        PERFORM 1350-PROCESS-WORK-QUEUE  THRU 1350-EXIT 
                     ELSE                                               
                        PERFORM 8650-DELETE-CRED-COLL    THRU 8650-EXIT 
                     END-IF                                             
                   ELSE                                                 
                     PERFORM 8650-DELETE-CRED-COLL       THRU 8650-EXIT 
                   END-IF                                               
                 END-IF                                                 
      *                                                                         
             WHEN WS-DATE-CREDIT-ACTION-X                               
                 IF WS-CODE-SPECIAL-TYPE-X > SPACES                     
                   MOVE 'X'                  TO CL-CODE-NOTICE-TYPE     
                   IF WS-AMT-NOTICE-X > ZERO                            
      *** MEDICAL CERTIFICATE                                                   
                     IF WS-CODE-SPECIAL-TYPE-X =  WS-M                  
                       PERFORM 1320-NON-UTL-DELQ    THRU 1320-EXIT      
                     END-IF                                             
                     IF WS-WQ-CATEGORY-ID > 0                           
                       PERFORM 1350-PROCESS-WORK-QUEUE  THRU 1350-EXIT  
                     ELSE                                               
                       PERFORM 8650-DELETE-CRED-COLL    THRU 8650-EXIT  
                     END-IF                                             
                   ELSE                                                 
                     PERFORM 8650-DELETE-CRED-COLL      THRU 8650-EXIT  
                   END-IF                                               
                 END-IF                                                 
           END-EVALUATE.                                                
      *                                                                         
           ADD 1                           TO WS-RECS-TO-COMMIT-COUNTER.
           IF WS-RECS-TO-COMMIT-COUNTER > WS-READY-TO-COMMIT-COUNT      
              PERFORM 0200-COMMIT   THRU 0200-EXIT                      
           END-IF.                                                      
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1310-EXEMPT                                                    *        
      ******************************************************************        
      *                                                                         
       1310-EXEMPT.                                                     
      *                                                                         
           MOVE 180                  TO WS-WQ-CATEGORY-ID.              
           MOVE WS-DEL-NONUTL-EXEMPT TO WS-COMMENTS-TEXT.               
           MOVE +97                  TO WS-COMMENTS-LEN.                
      *                                                                         
       1310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1320-NON-UTL-DELQ                                              *        
      ******************************************************************        
      *                                                                         
       1320-NON-UTL-DELQ.                                               
      *                                                                         
           MOVE WS-AMT-NONUTIL-WQ-MIN-CD TO C8-DELINQ-CD                
           MOVE AT-COMPANY-NO            TO C8-COMPANY-NO               
           PERFORM 7010-SELECT-DELINQ-VALUE          THRU 7010-EXIT     
           MOVE C8-DELINQ-VALUE          TO WS-AMT-NONUTIL-WQ-MIN       
           IF (WS-AMT-90-DAY-NONUTL + WS-AMT-60-DAY-NONUTL)             
                      NOT < WS-AMT-NONUTIL-WQ-MIN                       
             MOVE AT-ACCOUNT-NO          TO AC-ACCOUNT-NO               
             PERFORM 7030-GET-MAX-60DAY-REC          THRU 7030-EXIT     
             IF AC-ITEM-ID > 0                                          
               MOVE AC-ACCOUNT-NO        TO CT-ACCOUNT-NO               
               MOVE AC-ITEM-ID           TO CT-CNT-ITEM-ID              
               PERFORM 7035-SELECT-CNT-TYPE          THRU 7035-EXIT     
               PERFORM 3050-FORMAT-NONUTIL-WQ        THRU 3050-EXIT     
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       1320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1330-MASTER-DELQ                                               *        
      ******************************************************************        
      *                                                                         
       1330-MASTER-DELQ.                                                
      *                                                                         
           MOVE 24               TO WS-WQ-CATEGORY-ID.                  
           MOVE WS-MASTER-90-DAY TO WS-COMMENTS-TEXT.                   
           MOVE +41              TO WS-COMMENTS-LEN.                    
      *                                                                         
       1330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1340-NUTL-ACCT-DELQ                                            *        
      ******************************************************************        
      *                                                                         
       1340-NUTL-ACCT-DELQ.                                             
      *                                                                         
           IF AT-NOTICE-EXEMPT-CD > SPACE                               
              MOVE 128                       TO WS-WQ-CATEGORY-ID       
              MOVE WS-CREDIT-BUR-NOT-EXEMPT  TO WS-COMMENTS-TEXT        
              MOVE +31                       TO WS-COMMENTS-LEN         
           ELSE                                                         
              IF AT-CODE-DISC-OK > SPACE                                
                 MOVE 128                    TO WS-WQ-CATEGORY-ID       
                 MOVE WS-CREDIT-BUR-EXEMPT   TO WS-COMMENTS-TEXT        
                 MOVE +20                    TO WS-COMMENTS-LEN         
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE WS-N                         TO WS-GUARANTOR-EXISTS.    
           PERFORM 7446-SELECT-ACT-GUAR-ACCT   THRU 7446-EXIT.          
           IF GUARANTOR-EXISTS                                          
              MOVE 127                       TO WS-WQ-CATEGORY-ID       
              MOVE WS-NON-UTILITY-GUARANTOR  TO WS-COMMENTS-TEXT        
              MOVE +38                       TO WS-COMMENTS-LEN         
           END-IF.                                                      
      *                                                                         
           IF WS-WQ-CATEGORY-ID = 0                                     
             PERFORM 1320-NON-UTL-DELQ         THRU 1320-EXIT           
             IF WS-WQ-CATEGORY-ID = 0                                   
               MOVE 128                        TO WS-WQ-CATEGORY-ID     
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       1340-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1350-PROCESS-WORK-QUEUE                                        *        
      ******************************************************************        
      *                                                                         
       1350-PROCESS-WORK-QUEUE.                                         
      *                                                                         
           PERFORM 1360-CHECK-WQ-FL           THRU 1360-EXIT.           
      *                                                                         
           IF GENERATE-WQ                                               
              PERFORM 1409-CREATE-WORK-QUEUE  THRU 1409-EXIT            
           END-IF.                                                      
      *                                                                         
           IF WQ-GENERATED                                              
              IF CL-CODE-NOTICE-TYPE = 'M'                              
                 MOVE WS-AMT-NOTICE-M        TO CL-AMT-NOTICE           
                 MOVE WS-ITEM-ID-M           TO CL-ITEM-ID              
                 MOVE WS-CODE-MESSAGE-TYPE-M TO CL-CODE-MESSAGE-TYPE    
                 MOVE 'Q'                    TO WS-NON-UTL-CR-HST (1:1) 
                 MOVE WS-NON-UTL-CR-HST      TO CZ-NON-UTL-CR-HST       
              ELSE                                                      
                 MOVE WS-AMT-NOTICE-X        TO CL-AMT-NOTICE           
                 MOVE WS-ITEM-ID-X           TO CL-ITEM-ID              
                 MOVE WS-CODE-MESSAGE-TYPE-X TO CL-CODE-MESSAGE-TYPE    
                 MOVE 'Q'                  TO WS-NON-UTL-CR-HST-EX (1:1)
                 MOVE WS-NON-UTL-CR-HST-EX   TO CZ-NON-UTL-CR-HST-EX    
              END-IF                                                    
              PERFORM 8530-UPDATE-CRED-COLL           THRU 8530-EXIT    
              PERFORM 8520-UPDATE-CREDIT-PROFILE      THRU 8520-EXIT    
           ELSE                                                         
              PERFORM 8650-DELETE-CRED-COLL           THRU 8650-EXIT    
           END-IF.                                                      
      *                                                                         
       1350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1360-CHECK-WQ-FL                                               *        
      ******************************************************************        
      *                                                                         
       1360-CHECK-WQ-FL.                                                
      *                                                                         
           MOVE SPACES                           TO WS-REG-GRP-CD.      
           MOVE SPACE                            TO WS-SEN-FL.          
           MOVE WS-PGRMNAME                      TO WS-SRCE-PGM-ID.     
           MOVE AT-COMPANY-NO                    TO WS-COMP-NO.         
           MOVE WS-WQ-CATEGORY-ID                TO WS-CATEGORY-ID.     
      *                                                                         
           IF SEB-DATABASE                                              
             PERFORM 7000-CHECK-REG-SEN        THRU 7000-EXIT           
           END-IF.                                                      
           PERFORM 4900-GET-WQ-GEN-FL          THRU 4900-CPD346-EXIT    
           IF FL-NOT-FOUND                                              
             PERFORM 8500-WRITE-FCSKR205-FILE  THRU 8500-EXIT           
           END-IF.                                                      
      *                                                                         
           IF WS-WQ-GEN-FL = 'Y'                                        
              MOVE WS-Y                         TO WS-GENERATE-WQ-SW    
           END-IF.                                                      
      *                                                                         
       1360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1409-CREATE-WORK-QUEUE                                         *        
      ******************************************************************        
      *                                                                         
       1409-CREATE-WORK-QUEUE.                                          
      *                                                                         
ACT033     INITIALIZE CWS00077-FIELDS.                                  
ACT033     INITIALIZE WS-77-COMMENTS.                                   
      *                                                                         
      * POPULATE WORK QUEUE VARIABLE FOR INSERT WORK QUEUE                      
ACT033     MOVE AT-ACCOUNT-NO             TO WS-77-ACCOUNT-NO.          
ACT033     MOVE AT-CUSTOMER-NO            TO WS-77-CUSTOMER-NO.         
ACT033     MOVE AT-PREMISE-NO             TO WS-77-PREMISE-NO.          
ACT033     MOVE AT-LOCAL-OFFICE           TO WS-77-LOCAL-OFFICE.        
ACT033     MOVE WS-WQ-CATEGORY-ID         TO WS-77-CATEGORY-ID.         
ACT033     MOVE WS-COMMENTS-TEXT          TO WS-77-COMMENTS-TEXT.       
ACT033     MOVE WS-COMMENTS-LEN           TO WS-77-COMMENTS-LEN.        
ACT033     MOVE 4                         TO WS-77-ROUTE-CATEGORY.      
ACT033     MOVE WS-N                      TO WS-77-PRIORITY.            
ACT033     MOVE WS-INPUT-DATE             TO WS-INPUT-DATE-26(1:10).    
ACT033     MOVE WS-INPUT-ZERO             TO WS-INPUT-DATE-26(11:16).   
ACT033     MOVE WS-INPUT-DATE-26          TO WS-77-DATE-CREATED.        
ACT033     MOVE WS-NEXT-BUSINESS-DAY      TO WS-77-DATE-REQUIRED.       
ACT033     MOVE WS-PGRMNAME               TO WS-77-CREATED-BY.          
ACT033     MOVE 'SYSTEM '                 TO WS-77-USER-ID-ORIG.        
      *                                                                         
           PERFORM 8895-INSERT-WORK-QUEUE           THRU 8895-EXIT.     
      *                                                                         
ACT135     MOVE WS-Y                      TO WS-WQ-GENERATED-SW.        
ACT135*                                                                         
       1409-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   2000-PROCESS-ACCT-AND-CRED-PRO.                              *        
      *     SELECT FROM CSS_ACCOUNT THE DATA THAT THE ACCOUNT WILL BE  *        
      *     PROCESSED.  THE CSS_CREDIT_PROCESS WILL BE USED TO UPDATE  *        
      *     THE CREDIT HISTORY.                                        *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-ACCT-AND-CRED-PRO.                                  
      *                                                                         
           MOVE AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT.      
                                                                        
           MOVE AT-ACCOUNT-NO            TO CZ-ACCOUNT-NO.              
           PERFORM 7170-SELECT-CREDIT-PROFILE THRU 7170-EXIT.           
      *                                                                         
           MOVE CZ-NON-UTL-CR-HST        TO WS-NON-UTL-CR-HST.          
           MOVE CZ-NON-UTL-CR-HST-EX     TO WS-NON-UTL-CR-HST-EX.       
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3050-FORMAT-NONTUIL-WQ                                         *        
      ******************************************************************        
      *                                                                         
       3050-FORMAT-NONUTIL-WQ.                                          
      *                                                                         
           EVALUATE K6-CODE-CONTRACT-TYPE                               
               WHEN 'A'                                                 
                    MOVE 195                   TO WS-WQ-CATEGORY-ID     
               WHEN 'B'                                                 
                    MOVE 196                   TO WS-WQ-CATEGORY-ID     
               WHEN 'C'                                                 
                    MOVE 197                   TO WS-WQ-CATEGORY-ID     
               WHEN 'D'                                                 
                    MOVE 198                   TO WS-WQ-CATEGORY-ID     
               WHEN 'E'                                                 
                    MOVE 199                   TO WS-WQ-CATEGORY-ID     
               WHEN 'F'                                                 
                    MOVE 200                   TO WS-WQ-CATEGORY-ID     
               WHEN 'G'                                                 
                    MOVE 201                   TO WS-WQ-CATEGORY-ID     
               WHEN 'H'                                                 
                    MOVE 202                   TO WS-WQ-CATEGORY-ID     
               WHEN 'I'                                                 
                    MOVE 203                   TO WS-WQ-CATEGORY-ID     
               WHEN 'K'                                                 
                    MOVE 434                   TO WS-WQ-CATEGORY-ID     
               WHEN 'J'                                                 
                    MOVE 435                   TO WS-WQ-CATEGORY-ID     
               WHEN 'L'                                                 
                    MOVE 436                   TO WS-WQ-CATEGORY-ID     
               WHEN 'M'                                                 
                    MOVE 437                   TO WS-WQ-CATEGORY-ID     
               WHEN 'N'                                                 
                    MOVE 438                   TO WS-WQ-CATEGORY-ID     
           END-EVALUATE                                                 
      *                                                                         
           MOVE K6-CNT-NAME-DESC               TO WS-DEL-NU-WQ-DESC     
           MOVE AC-AMT-AR-DAY-00               TO WS-WQ-00DAY           
           MOVE AC-AMT-AR-DAY-30               TO WS-WQ-30DAY           
           MOVE AC-AMT-AR-DAY-60               TO WS-WQ-60DAY           
           MOVE AC-AMT-AR-DAY-90               TO WS-WQ-90DAY           
           MOVE WS-TOTAL-BALANCE-NONUTL        TO WS-WQ-NU-BIL-BAL      
           COMPUTE WS-WQ-NU-ARR-P60 =                                   
                  (WS-AMT-90-DAY-NONUTL + WS-AMT-60-DAY-NONUTL).        
           MOVE WS-DEL-NONUTL                  TO WS-COMMENTS-TEXT      
           MOVE +204                           TO WS-COMMENTS-LEN.      
      *                                                                         
       3050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3200-CALC-AMOUNTS-DATES                                        *        
      * PERFORM ROUTINE THAT CALCULATES DNP-BAL, ARREARS, PAST DUE     *        
      * ETC, AND MOVE VALUES TO CWS10007 FOR USE BY OTHER PROGRAMS     *        
      ******************************************************************        
      *                                                                         
       3200-CALC-AMOUNTS-DATES.                                         
      *                                                                         
      *SET CPD00068 SWITCHES THAT ARE NEEDED                                    
           MOVE 'Y'         TO CALC-ARREARS-SW                          
                               CALC-BALANCE-SW                          
                               CALC-PAST-DUE-SW                         
                               LOAD-DNP-DATE-SW                         
                               LOAD-DUE-DATES-SW                        
                               LOAD-WS-AMOUNTS-SW.                      
      *                                                                         
           INITIALIZE          WS-DATE-CREDIT-ACTION-M                  
                               WS-DATE-CREDIT-ACTION-X                  
                               WS-DATE-NOTICE-DUE-M                     
                               WS-DATE-NOTICE-DUE-X                     
                               WS-DATE-NOTICE-MAIL-M                    
                               WS-DATE-NOTICE-MAIL-X                    
                               WS-DATE-BILL-M                           
                               WS-DATE-BILL-X                           
                               WS-CODE-MESSAGE-TYPE-M                   
                               WS-CODE-MESSAGE-TYPE-X                   
                               WS-CODE-SPECIAL-TYPE-M                   
                               WS-CODE-SPECIAL-TYPE-X                   
                               WS-AMT-NOTICE-M                          
                               WS-AMT-NOTICE-X                          
                               WS-ITEM-ID-M                             
                               WS-ITEM-ID-X                             
                               WS-CODE-FRCST-CR-GRP-M                   
                               WS-CODE-FRCST-CR-GRP-X.                  
                                                                        
           MOVE 'PCSCA132'              TO PROGRAM-NAME                 
                                           WS-CPD00068-CALLING-PGM.     
           MOVE SPACES                  TO ABEND-FUNCTION.              
           CALL SCSCB068  USING  CWS00068-FIELDS,                       
                                 WS-CODES-DATA-PRESENT,                 
                                 DCLCSS-ACCOUNT,                        
                                 ABEND-FILE,                            
                                 RS-RETURN-CODE.                        
           MOVE 'PCSKR205'              TO PROGRAM-NAME.                
           IF  ABEND-FUNCTION  > SPACES                                 
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00599******************************************************************        
P00599* 5200-CHK-SKIP-ACCTS                                      *      11187000
P00599******************************************************************11187100
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE CPD00347                                                 
P00599     END-EXEC.                                                            
P00599*                                                                         
      ******************************************************************        
      * 4900-GET-WQ-PGM-CNTL-TBL                                       *        
      * 5200-SEARCH-WQ-PGM-CNTL-TBL                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00346                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6240-GET-FCA00-COMMON-DATE                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00040                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00037                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    6500-GET-NEXT-BUSINESS-DAY                                **         
      *    COPYBOOK CPD00322 CONTAINS THE LOGIC FOR FINDING          **         
      *    THE NEXT AND PREVIOUS BUSINESS DAY.                       **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00322                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7000-CHECK-REG-SEN                                             *        
      ******************************************************************        
      *                                                                         
       7000-CHECK-REG-SEN.                                              
      *                                                                         
           EXEC SQL                                                     
               SELECT REG_GROUP_CD                                      
                     ,SENIOR_FL                                         
                 INTO :LR-REG-GROUP-CD                                  
                     ,:LR-SENIOR-FL                                     
                 FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REG_GROUP_CD                                              
MFA-TR*              ,SENIOR_FL                                                 
MFA-TR*          INTO :LR-REG-GROUP-CD                                          
MFA-TR*              ,:LR-SENIOR-FL                                             
MFA-TR*          FROM CSS_REG_PROFILE                                           
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                  MOVE LR-REG-GROUP-CD TO WS-REG-GRP-CD                 
                  MOVE LR-SENIOR-FL    TO WS-SEN-FL                     
               END-IF                                                   
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** CSS_REG_PROFILE                        '     
               DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                 
               DISPLAY '** 7000 : RETURN CODE ERROR - SELECT      '     
               DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE            
               DISPLAY '******************************************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010-SELECT-DELINQ-VALUE                                       *        
      ******************************************************************        
      *                                                                         
       7010-SELECT-DELINQ-VALUE.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD    = :C8-DELINQ-CD                       
                 AND COMPANY_NO   = :C8-COMPANY-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD    = :C8-DELINQ-CD                               
MFA-TR*          AND COMPANY_NO   = :C8-COMPANY-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             WS-DISPLAY-SQLCODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '********** PCSKR205  ABORT ********************'
               DISPLAY '* 7010-SELECT-DELINQ-VALUE                    *'
               DISPLAY '* SQLCODE IS   ' WS-DISPLAY-SQLCODE             
               DISPLAY '* DELINQ_CD  : ' C8-DELINQ-CD                   
               DISPLAY '* COMPANY_NO : ' C8-COMPANY-NO                  
               DISPLAY '* PROGRAM ABORTING...                         *'
               DISPLAY '********** PCSKR205  ABORT ********************'
               PERFORM 9900-ABEND                   THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7030-GET-MAX-60DAY-REC                                         *        
      ******************************************************************        
      *                                                                         
       7030-GET-MAX-60DAY-REC.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) ITEM_ID,
              PYMT_PRIORITY_LVL,
              AMT_AR_DAY_00,
              AMT_AR_DAY_30,
              AMT_AR_DAY_60,
              AMT_AR_DAY_90,
              (AMT_AR_DAY_60 + AMT_AR_DAY_90) AS TOT_ARREARS     
                INTO :AC-ITEM-ID,                                       
                     :AC-PYMT-PRIORITY-LVL,                             
                     :AC-AMT-AR-DAY-00,                                 
                     :AC-AMT-AR-DAY-30,                                 
                     :AC-AMT-AR-DAY-60,                                 
                     :AC-AMT-AR-DAY-90,                                 
                     :WS-TOT-60PLUS-ARREARS                             
                FROM CSS_AR_CNTL A WITH(READUNCOMMITTED)                        
               WHERE A.ACCOUNT_NO = :AC-ACCOUNT-NO                      
                 AND ((A.PYMT_PRIORITY_LVL IN (19, 29, 39)              
                 AND A.ITEM_ID = 0)                                     
                  OR (A.PYMT_PRIORITY_LVL = 100                         
                 AND A.ITEM_ID > 0))                                    
                 AND (A.AMT_AR_DAY_60 + A.AMT_AR_DAY_90) =              
                         (SELECT MAX(B.AMT_AR_DAY_60 + B.AMT_AR_DAY_90) 
                            FROM CSS_AR_CNTL B WITH(READUNCOMMITTED)            
                           WHERE B.ACCOUNT_NO = A.ACCOUNT_NO            
                             AND ((B.PYMT_PRIORITY_LVL IN (19, 29, 39)  
                             AND B.ITEM_ID = 0)                         
                              OR (B.PYMT_PRIORITY_LVL = 100             
                             AND B.ITEM_ID > 0)))                       
                                                    
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ITEM_ID,                                                   
MFA-TR*              PYMT_PRIORITY_LVL,                                         
MFA-TR*              AMT_AR_DAY_00,                                             
MFA-TR*              AMT_AR_DAY_30,                                             
MFA-TR*              AMT_AR_DAY_60,                                             
MFA-TR*              AMT_AR_DAY_90,                                             
MFA-TR*              (AMT_AR_DAY_60 + AMT_AR_DAY_90) AS TOT_ARREARS             
MFA-TR*         INTO :AC-ITEM-ID,                                               
MFA-TR*              :AC-PYMT-PRIORITY-LVL,                                     
MFA-TR*              :AC-AMT-AR-DAY-00,                                         
MFA-TR*              :AC-AMT-AR-DAY-30,                                         
MFA-TR*              :AC-AMT-AR-DAY-60,                                         
MFA-TR*              :AC-AMT-AR-DAY-90,                                         
MFA-TR*              :WS-TOT-60PLUS-ARREARS                                     
MFA-TR*         FROM CSS_AR_CNTL A                                              
MFA-TR*        WHERE A.ACCOUNT_NO = :AC-ACCOUNT-NO                              
MFA-TR*          AND ((A.PYMT_PRIORITY_LVL IN (19, 29, 39)                      
MFA-TR*          AND A.ITEM_ID = 0)                                             
MFA-TR*           OR (A.PYMT_PRIORITY_LVL = 100                                 
MFA-TR*          AND A.ITEM_ID > 0))                                            
MFA-TR*          AND (A.AMT_AR_DAY_60 + A.AMT_AR_DAY_90) =                      
MFA-TR*                  (SELECT MAX(B.AMT_AR_DAY_60 + B.AMT_AR_DAY_90)         
MFA-TR*                     FROM CSS_AR_CNTL B                                  
MFA-TR*                    WHERE B.ACCOUNT_NO = A.ACCOUNT_NO                    
MFA-TR*                      AND ((B.PYMT_PRIORITY_LVL IN (19, 29, 39)          
MFA-TR*                      AND B.ITEM_ID = 0)                                 
MFA-TR*                       OR (B.PYMT_PRIORITY_LVL = 100                     
MFA-TR*                      AND B.ITEM_ID > 0)))                               
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** AR_CNTL TABLE                          '      
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7030 :  RETURN CODE ERROR - SELECT     '      
              DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE             
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7035-SELECT-CNT-TYPE                                           *        
      ******************************************************************        
      *                                                                         
       7035-SELECT-CNT-TYPE.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT K6.CNT_NAME_DESC,                                  
                     K6.CODE_CONTRACT_TYPE                              
                INTO :K6-CNT-NAME-DESC,                                 
                     :K6-CODE-CONTRACT-TYPE                             
                FROM CSS_CONTRACT CT WITH(READUNCOMMITTED),                     
                     CSS_CONTRACT_INFO K6 WITH(READUNCOMMITTED)                 
               WHERE CT.ACCOUNT_NO  = :CT-ACCOUNT-NO                    
                 AND CT.CNT_ITEM_ID = :CT-CNT-ITEM-ID                   
                 AND CT.CNT_NAME_CD = K6.CNT_NAME_CD                    
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT K6.CNT_NAME_DESC,                                          
MFA-TR*              K6.CODE_CONTRACT_TYPE                                      
MFA-TR*         INTO :K6-CNT-NAME-DESC,                                         
MFA-TR*              :K6-CODE-CONTRACT-TYPE                                     
MFA-TR*         FROM CSS_CONTRACT CT,                                           
MFA-TR*              CSS_CONTRACT_INFO K6                                       
MFA-TR*        WHERE CT.ACCOUNT_NO  = :CT-ACCOUNT-NO                            
MFA-TR*          AND CT.CNT_ITEM_ID = :CT-CNT-ITEM-ID                           
MFA-TR*          AND CT.CNT_NAME_CD = K6.CNT_NAME_CD                            
MFA-TR*       QUERYNO 7035                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CONTRACT AND CONTRACT_INFO             '      
              DISPLAY '** ACCOUNT NO = ' CT-ACCOUNT-NO                  
              DISPLAY '** CNT ITEM ID =' CT-CNT-ITEM-ID                 
              DISPLAY '** 7035 :  RETURN CODE ERROR - SELECT     '      
              DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE             
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7035-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7170-SELECT-CREDIT-PROFILE                                     *        
      ******************************************************************        
      *                                                                         
       7170-SELECT-CREDIT-PROFILE.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                  REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                  NON_UTL_CR_HST,                                       
                  NON_UTL_CR_HST_EX                                     
              INTO                                                      
                  :CZ-LAST-UPDATE-TS,                                   
                  :CZ-NON-UTL-CR-HST,                                   
                  :CZ-NON-UTL-CR-HST-EX                                 
              FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                         
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*           LAST_UPDATE_TS,                                               
MFA-TR*           NON_UTL_CR_HST,                                               
MFA-TR*           NON_UTL_CR_HST_EX                                             
MFA-TR*       INTO                                                              
MFA-TR*           :CZ-LAST-UPDATE-TS,                                           
MFA-TR*           :CZ-NON-UTL-CR-HST,                                           
MFA-TR*           :CZ-NON-UTL-CR-HST-EX                                         
MFA-TR*       FROM CSS_CREDIT_PROFILE                                           
MFA-TR*       WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                                 
MFA-TR*       QUERYNO 7170                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CREDIT_PROFILE TABLE                   '      
              DISPLAY '** ACCOUNT NO = ' CZ-ACCOUNT-NO                  
              DISPLAY '** 7170 :  RETURN CODE ERROR - SELECT     '      
              DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE             
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7200-OPEN-CRED-COLL                                       **          
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **          
      **      WQ_CSR  CURSOR                                        **          
      ****************************************************************          
       7200-OPEN-CRED-COLL.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN WQ_CSR                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** 7200 :  RETURN CODE ERROR - OPEN '           
               DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE            
               DISPLAY '******************************************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7210-FETCH-CRED-COLL                                      **          
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **          
      **      WQ_CSR  CURSOR                                        **          
      ****************************************************************          
       7210-FETCH-CRED-COLL.                                            
      *                                                                         
           EXEC SQL                                                     
               FETCH WQ_CSR INTO                                        
                   :AT-CUSTOMER-NO,                                     
                   :AT-ACCOUNT-NO,                                      
                   :AT-PREMISE-NO,                                      
                   :AT-COMPANY-NO,                                      
                   :AT-LOCAL-OFFICE,                                    
                   :AT-DATE-BILL-DAY-00,                                
                   :AT-DATE-BILL-DAY-30,                                
                   :AT-DATE-BILL-DAY-60,                                
                   :AT-DATE-BILL-DAY-90,                                
                   :AT-BILL-CYCLE,                                      
                   :AT-TOTAL-AR-BALANCE,                                
                   :AT-CODES-DATA-PRESENT,                              
                   :AT-CODE-ACCT-STAT,                                  
                   :AT-CREDIT-GROUP,                                    
                   :AT-ACCOUNT-TYPE-CODE,                               
                   :AT-CODE-STATUS-REASON,                              
                   :AT-NOTICE-EXEMPT-CD,                                
                   :AT-IVR-EXEMPT-CD,                                   
                   :AT-CODE-DISC-OK,                                    
                   :AT-BANKRUPTCY-IND,                                  
                   :CL-DATE-CREDIT-ACTION :WS-DATE-CRED-ACT-NULL,       
                   :CL-CODE-NOTICE-TYPE,                                
                   :CL-ITEM-ID                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               IF WS-DATE-CRED-ACT-NULL < 0                             
                   MOVE SPACES         TO CL-DATE-CREDIT-ACTION         
               END-IF                                                   
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** 7210 :  RETURN CODE ERROR - FETCH'           
               DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE            
               DISPLAY '******************************************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7220-CLOSE-CRED-COLL                                      **          
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **          
      **      WQ_CSR  CURSOR                                        **          
      ****************************************************************          
       7220-CLOSE-CRED-COLL.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE WQ_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** 7220 :  RETURN CODE ERROR - CLOSE'           
               DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE            
               DISPLAY '******************************************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7446-SELECT-ACT-GUAR-ACCT                                     *        
      ******************************************************************        
      *                                                                         
       7446-SELECT-ACT-GUAR-ACCT.                                       
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                 INTO :WS-GUARANTOR-EXISTS                              
              FROM CSS_GUARANTOR WITH(READUNCOMMITTED)                          
              WHERE GUARNTR_ACCT_NO = :AT-ACCOUNT-NO                    
                AND GUAR_STATUS_CD  = 'A'                               
                                                    
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*          INTO :WS-GUARANTOR-EXISTS                                      
MFA-TR*       FROM CSS_GUARANTOR                                                
MFA-TR*       WHERE GUARNTR_ACCT_NO = :AT-ACCOUNT-NO                            
MFA-TR*         AND GUAR_STATUS_CD  = 'A'                                       
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       QUERYNO 7446                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** GUARANTOR TABLE                   '           
              DISPLAY '** ACCOUNT NO = ' GU-GUARNTR-ACCT-NO             
              DISPLAY '** 7446 : RETURN CODE ERROR - SELECT '           
              DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE             
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7446-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7600-START-FCSJC01                                             *        
      * 7610-READ-FCSJC01                                              *        
      * 7611-CLOSE                                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7620-START-FCSCA00                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00039                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   8500-WRITE-FCSKR205-FILE                                     *        
      *        WRITES THE RECORD INTO THE REPORT FILE                  *        
      *                                                                *        
      ******************************************************************        
       8500-WRITE-FCSKR205-FILE.                                        
      *                                                                         
           IF WS-FST-TIME = 'Y'                                         
             MOVE 03                          TO RETURN-CODE            
             MOVE 'HELO DOMAIN:     SCANA                         '     
                                              TO E-FCK205-DATA-REC      
             WRITE FCSKR205                                             
             MOVE 'MAIL FROM:   <'            TO E-FCK205-DATA-PARTA    
             MOVE WS-PGRMNAME                 TO WS-PRG-TO              
             MOVE EMAIL-TO-REC                TO E-FCK205-DATA-PARTB    
             MOVE SPACES                      TO E-FCK205-DATA-PARTC    
             WRITE FCSKR205                                             
             MOVE 'RCPT TO:   <ISTCSRCAREPROJECTS@SCANA.COM>'           
                                              TO E-FCK205-DATA-REC      
             WRITE FCSKR205                                             
             MOVE 'RCPT TO:   <ISTCSRAPPLICATIONSUPPORT@SCANA.COM>'     
                                              TO E-FCK205-DATA-REC      
             WRITE FCSKR205                                             
             MOVE 'RCPT TO:   <CSSOCREDIT@SCANA.COM>'                   
                                              TO E-FCK205-DATA-REC      
             WRITE FCSKR205                                             
             MOVE 'DATA                                           '     
                                              TO E-FCK205-DATA-REC      
             WRITE FCSKR205                                             
             MOVE 'FROM: CIS PAGING <'        TO E-FCK205-DATA-PARTAA   
             MOVE EMAIL-TO-REC                TO E-FCK205-DATA-PARTBB   
             MOVE SPACES                      TO E-FCK205-DATA-PARTCC   
             WRITE FCSKR205                                             
             MOVE 'TO:   <ISTCSRCAREPROJECTS@SCANA.COM> '               
                                              TO E-FCK205-DATA-REC      
             WRITE FCSKR205                                             
             MOVE 'TO:   <ISTCSRAPPLICATIONSUPPORT@SCANA.COM> '         
                                              TO E-FCK205-DATA-REC      
             WRITE FCSKR205                                             
             MOVE 'TO:   <CSSOCREDIT@SCANA.COM> '                       
                                              TO E-FCK205-DATA-REC      
             WRITE FCSKR205                                             
             MOVE 'SUBJECT: DAILY JOB '       TO E-FCK205-DATA-PARTAAA  
             MOVE WS-PGRMNAME                 TO E-FCK205-DATA-PARTBBB  
             MOVE SPACES                      TO E-FCK205-DATA-PARTCCC  
             MOVE ' CATEGORY MISSING FROM CSS_WQ_PGM_CNTL'              
                                              TO E-FCK205-DATA-PARTCCC  
             WRITE FCSKR205                                             
             MOVE SPACES                      TO E-FCK205-DATA-REC      
             WRITE FCSKR205                                             
             MOVE WS-PGRMNAME                 TO WS-PRGM                
             MOVE  EMAIL-PRG                  TO E-FCK205-DATA-REC      
             WRITE FCSKR205                                             
             MOVE EMAIL-HDN-REC               TO E-FCK205-DATA-REC      
             WRITE FCSKR205                                             
             MOVE 'N' TO WS-FST-TIME                                    
           END-IF.                                                      
           MOVE  WS-COMP-NO                   TO WS-EMAIL-COMP          
           MOVE  AT-ACCOUNT-NO                TO WS-EMAIL-ACCT          
           MOVE  WS-CATEGORY-ID               TO WS-EMAIL-CAT           
           MOVE  WS-REG-GRP-CD                TO WS-EMAIL-REG-GRP       
           MOVE  WS-SEN-FL                    TO WS-EMAIL-SEN-FL        
           MOVE  EMAIL-DTL-REC                TO E-FCK205-DATA-REC      
           WRITE FCSKR205.                                              
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8520-UPDATE-CREDIT-PROFILE                                     *        
      ******************************************************************        
      *                                                                         
       8520-UPDATE-CREDIT-PROFILE.                                      
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_CREDIT_PROFILE                                
                  SET NON_UTL_CR_HST     = :CZ-NON-UTL-CR-HST,          
                      NON_UTL_CR_HST_EX  = :CZ-NON-UTL-CR-HST-EX,       
                      LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()            
               WHERE ACCOUNT_NO  =  :CZ-ACCOUNT-NO                      
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CREDIT_PROFILE                                        
MFA-TR*           SET NON_UTL_CR_HST     = :CZ-NON-UTL-CR-HST,                  
MFA-TR*               NON_UTL_CR_HST_EX  = :CZ-NON-UTL-CR-HST-EX,               
MFA-TR*               LAST_UPDATE_TS     = CURRENT TIMESTAMP                    
MFA-TR*        WHERE ACCOUNT_NO  =  :CZ-ACCOUNT-NO                              
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CREDIT_PROFILE TABLE                   '      
              DISPLAY '** ACCOUNT NO = ' CZ-ACCOUNT-NO                  
              DISPLAY '** 8520 :  RETURN CODE ERROR - UPDATE'           
              DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE             
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8530-UPDATE-CRED-COLL                                          *        
      ******************************************************************        
      *                                                                         
       8530-UPDATE-CRED-COLL.                                           
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_CRED_COLL                                     
                  SET AMT_NOTICE        = :CL-AMT-NOTICE,               
                      PROCESSED_CD      = 'W'                           
               WHERE ACCOUNT_NO       = :CL-ACCOUNT-NO                  
                AND  ITEM_ID          = :CL-ITEM-ID                     
                AND  CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CRED_COLL TABLE                   '           
              DISPLAY '** ACCOUNT NO = ' CL-ACCOUNT-NO                  
              DISPLAY '** CODE NOTICE TYPE = ' CL-CODE-NOTICE-TYPE      
              DISPLAY '** AMT NOTICE = ' CL-AMT-NOTICE                  
              DISPLAY '** 8530 :  RETURN CODE ERROR - UPDATE'           
              DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE             
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8650-DELETE-CRED-COLL                                          *        
      ******************************************************************        
      *                                                                         
       8650-DELETE-CRED-COLL.                                           
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM CSS_CRED_COLL                                
                WHERE ACCOUNT_NO         = :CL-ACCOUNT-NO               
                 AND  CODE_NOTICE_TYPE   = :CL-CODE-NOTICE-TYPE         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CRED_COLL TABLE                   '           
              DISPLAY '** ACCOUNT NO = ' CL-ACCOUNT-NO                  
              DISPLAY '** 8650 :  RETURN CODE ERROR - DELETE'           
              DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE             
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8890-COMMIT.                                                   *        
      ******************************************************************        
      *                                                                         
       8890-COMMIT.                                                     
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
      *                                                                         
           DISPLAY '**********************************************'     
           DISPLAY '* COMMIT POINT # ' WS-COMMIT-COUNTER ' TAKEN.   *'  
           DISPLAY '* LAST REC PROCESSED  = ' AT-ACCOUNT-NO             
           DISPLAY '**********************************************'.    
      *                                                                         
       8890-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8895-INSERT-WORK-QUEUE.                                        *        
      ******************************************************************        
      *                                                                         
ACT033 8895-INSERT-WORK-QUEUE.                                          
ACT033*                                                                         
ACT033     CALL SCSCB077 USING CWS00077-FIELDS,                         
ACT033                         ABEND-FILE,                              
ACT033                         RS-RETURN-CODE.                          
ACT033                                                                  
ACT033     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE.                
ACT033                                                                  
ACT033     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
ACT033        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
ACT033        DISPLAY '8895-INSERT-WORK-QUEUE'                          
ACT033        DISPLAY 'CALL SCSCB077         '                          
ACT033        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
ACT033        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
ACT033        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
ACT033        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
ACT033        PERFORM 9900-ABEND    THRU 9900-EXIT                      
ACT033     END-IF.                                                      
ACT033*                                                                         
ACT033 8895-EXIT.                                                       
ACT033     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK               *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           GO TO 9000-EXIT.                                             
                                                                        
      *                                                                         
      ******************************************************************        
      * 9000-TERMINATE.                                                *        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSKR205-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  9700-PROCESS-ABEND.                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9900-ABEND.                                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
