       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSKR200.                                        
      ***************************************************************** 00030000
      **             SOUTH CAROLINA ELECTRIC & GAS                   ** 00040000
      **                                                             ** 00050000
      **              CUSTOMER INFORMATION SYSTEM                    ** 00060000
      ***************************************************************** 00070000
      *                   PROGRAM NARRATIVE                            *00080000
      *                                                                *00090000
      *   THIS PROGRAM WILL DO THE ACTIVE ACCOUNT NOTICE AND PENDING   *00100000
      *   FINAL BILL RETURN CHECK NOTICE PROCESSING.  THE DATA         *00110000
      *   NECESSARY FOR THE ACCOUNTS TO BE SENT NOTICES WILL ME        *        
      *   MOVED TO THE CSS_CORRESP_HDR, CSS_CORRESP_NOTICE_DTL, AND    *        
      *   CSS_CORRESP_VARIABLES. THE DATA IN THE DB2 TABLES WILL BE    *        
      *   USED IN ANOTHER PROGRAM TO ACTUALLY PRINT THE NOTICES.       *        
      *                                                                *00200000
      *   ADDITIONALLY, THIS PROGRAM USES COPYBOOK CPD00068 TO         *00210000
      *   CALCULATE ARREARS, DISCONNECT AMOUNT, PAST DUE, ETC ALONG    *00220000
      *   WITH NUMEROUS DATES.                                         *00230000
      *                                                                *00240000
      ******************************************************************00280000
      ***************************************************************** 00290000
      **                                                             ** 00300000
      **              PROGRAM  MODIFICATION  LOG                     ** 00310000
      **    DATE    INITIALS     REASON                              ** 00320000
      **    ----    --------     ------                              ** 00330000
P00599**  05/14/12  RB19997     INITIAL PROGRAM WRITTEN              ** 00340000
P0599A**  10/03/12  RB19997     ADDED REQUIRED FIELDS FOR ABENDS     ** 00350000
P0599B**  10/03/12  GOKUL       REMOVE ITEM-ID WHILE UPDATING        ** 00360000
P0599B**                        PROCESSED_CD FOR 'N' ROWS IN CL.     ** 00370000
P0599C**  10/04/12  RB19997     CHANGED THE PROCESSED_CD IN THE WHERE** 00380000
P0599C**                        TO "IN (' ','I')".                   ** 00390000
P0599D**  10/10/12  SS42021     FIX TO POPULATE CORRECT RETURN CHK AMT* 00400000
P0599D**                        FOR MULTIPLE RTC NOTICES.            ** 00410000
P0599E**  10/26/12  RB19997    1) MULTIPLE RETURN CHECK FORECAST ROWS**         
P0599E**                        FOR DIFFERENT DATES.  CHANGE IN 1200.**         
P0599E**                       2) MULTIPLE RETURN CHECKS FOR SAME    **         
P0599E**                        DAY.  CHANGE IN 1527.                **         
P0599E**                       3) RETURN CHECK MERGE WITH CREDIT     **         
P0599E**                        ACTION NO LONGER THERE.  CHANGE IN   **         
P0599E**                        1200 AND ALSO IN 1450.               **         
P0599E**                       4) IN 7220 PARAGRAPH, REMOVED         ** 00400000
P0599E**                        NSF_STATUS_CD CHECK SO THE SUM OF ALL** 00410000
P0599E**                        THE RETURNED CHECKS ARE ADDED.       ** 00410000
P0599E**                       5) IN 1450 PARAGRAPH, IF CHECK        ** 00400000
P0599E**                        PROCESSED, CHANGE 90107 AND 80107    ** 00410000
P0599E**                        TO A 90205.                          ** 00410000
A04460**  11/20/12  MC95456     NOTICES TO BE MAILED TO DEPOSIT BILL **         
A04460**                        IMMEDIATE ACCOUNTS                   **         
P0599F**  12/06/12  RB19997    FIX FORECAST AUTO DEPOSIT ISSUE.      **         
P0599G**  12/07/12  RB19997    USE 'PCSKR200A' AS APPL-PROGRAM-ID    **         
P0599G**                       WHEN IT IS LOADED IN SCSKR125.        **         
P0599H**  12/20/12  RB19997    FINE THE MERGE CHECK PROCESS TO PICK  **         
P0599H**                       UP AMOUNT/S OF PRE-PAID CHECKS.       **         
P0599I**   1/08/13  RB19997    RECHECK TO SEE IF THE N ROW HAS BEEN  **         
P0599I**                       PROCESSED.                            **         
P0599J**   1/10/13  RB19997    FIX 90108 SEB/PSNC ERROR.             **         
P0599K**   2/05/13  RB19997    FIX MULTIPLE RETURN CHECK ISSUE WITH  **         
P0599K**                       COUNTER BEING RESET.                  **         
P0599L**   2/06/13  RB19997    FIX ISSUE WITH CASH ONLY NOTICES HAVIN**         
P0599L**                       WRONG WS-KR125-MNT-APPL-PGM-ID.       **         
A4527A**  07/23/13  RB19957  1)INITIALIZE SEB ONLY VARIABLES TO      ** 00500000
A4527A** A04527-ACT066         SPACES SO SCSKR125 WILL PICK UP       ** 00500000
A4527A**                       DUPLICATES IN OTHER JOBS(PCSKR200).   ** 00500000
A4527B**                     2)CHECK TO SEE IF ANOTHER PROGRAM LIKE  ** 00500000
A4527B**                       PCSCA141 HAS PRODUCED A CASH ONLY     ** 00500000
A4527B**                       LETTER TO PREVENT A -803.             ** 00500000
ACT145**A04527                 CHANGE GUARANTOR CURSOR FOR SELECTING ** 00500000
ACT145**A04527                 ADDRESS.  DELETE UNUSED COPYBOOKS.    ** 00500000
ACT187**  11/01/13  RB19957  1)ADD THE CHECK FOR COUNTING A 90108(3RD** 00500000
ACT187** A04527-ACT187         PARTY) AND 90109 (GUARANTOR) NOTICES/S** 00500000
ACT187**                       AS A PREVIOUS NOTICE SO MULTIPLE CAN  ** 00500000
ACT187**                       SENT OUT IN ONE DAY.                  ** 00500000
ACT187**                     2)FIX ERROR OF SENDING CASH ONLY NOTICE ** 00500000
ACT187**                       (90207) INSTEAD OF DISCONNECT NOTICE  ** 00500000
ACT187**                       TO 3RD PARTY AND GUARANTOR.           ** 00500000
ACT248**  12/31/13  RB19957  FIX ISSUE OF NOTICE BEING SENT ON A     ** 00500000
ACT248**                     DEPOSIT THAT HAS JUST BEEN PARTIALLY    ** 00500000
ACT248**                     OR FULLY PAID WITH THE DUE AMOUNT LESS  ** 00500000
ACT248**                     THAN NOTICE LIMIT.                      ** 00500000
ACT021**  01/28/14  RB19957  FIX ISSUE OF CREATING MULTIPLE 90201    ** 00500000
ACT021**      APPL00004880   NOTICES WHEN THERE IS A 'E' AND 'F' ROW ** 00500000
ACT021**                     IN CSS_CRED_COLL DB2 TABLE.             ** 00500000
ACT030**  04/01/14  SS7F226  WORK QUEUE CHANGE TO REPLACE THE        ** 00500000
ACT030**      APPL00004860   CSS_WQ_ITEMS_MF WITH CSS_WQ_ITEMS.      ** 00500000
ACT239**  08/14/14  RB19957  ADDED CHANGE TO CALL TO CSR03515 TO USE ** 00500000
ACT239**      APPL00004860   INPUT DATE AND ALSO DISPLAY ACCOUNT NO. ** 00500000
A05058**  07/28/15  RB19957  ADDED 90208 TO CASH ONLY LETTER CHECK   ** 00500000
A05058**      APPL00005058   IN PARAGRAPH 1590.                      ** 00500000
A05323**  07/39/15  MJ13662  REMOVED RETURN CHECK MERGE LOGIC.       **         
A05323**                     IF RET CHECK MAIL DATE AND NORMAL OR    **         
A05323**                     EXCEPTIONAL MAIL DATE ARE THE SAME,     **         
A05323**                     PROCESS BOTH NOTICES.                   **         
A05323**  09/25/15  MJ13662  IF DEP MAIL DATE AND NORMAL OR EXCEPTIONAL         
A05323**                     DATE ARE THE SAME, PROCESS NORMAL OR    **         
A05323**                     EXCEPTONAL AND DELETE DEP NOTICE AND DNP**         
A05323**                     ROWS FROM CSS_CRED_COLL.                **         
A05323**                     RET CHECK NOTICE AMOUNT WILL USE        **         
A05323**                     WS-AMT-ARREARS-UTL + 00-DAY-NSA INSTEAD **         
A05323**                     OF PAST-DUE.                            **         
ACT210**                     REMOVE INSERT TO CSS_DNP_NOT_WORKED.    **         
ACT210**                     APPL5136                                **         
P00948**  09/30/16 VENKAT.P  FOR STAA'S, STOP SENDING 90201 SAME DAY **         
P00948**                     90104 BEING MAILED.                     **         
AP5460**  11/22/16 MJ13662   IN PARA 1455 USE CL-DATE-NOTICE-MAIL TO **         
AP5460**                     CALCULATE DAYS.                         **         
AP5660**  03/22/17 MJ13662   WHILE PROCESSING RET CHECK NOTICE 90205/**         
AP5660**                     80205 IF AUTO DEPOSIT EXISTS, MOVE TO   **         
AP5660**                     WS-AUTO-DEP-CHARGED TO DISPLAY ON NOTICE**         
      ***************************************************************** 00420000
      **           ---- BASIC SEQUENCE STRUCTURE ----                ** 00430000
      **            0000 - 0000     MAIN CONTROL PATH                ** 00440000
      **            0100 - 0100     INITIALIZATION                   ** 00450000
      **            1000 - 1000     MAJOR PROCESSING LOOP            ** 00460000
      **            1100 - 4999     PERFORMED PARAGRAPHS OF MAJOR    ** 00470000
      **                            PROCESSING LOOPS                 ** 00480000
      **            5000 - 5999     COMMON PROGRAM MODULES           ** 00490000
      **            6000 - 6999     COMMON SYSTEM MODULES            ** 00500000
      **            7000 - 7999     INPUT MODULES                    ** 00510000
      **            8000 - 8999     OUTPUT MODULES                   ** 00520000
      **            9000 - 9799     TERMINATION MODULES              ** 00530000
      **            9900 - 9999     ABEND/ABORT MODULES              ** 00540000
      **                  ---- PARAGRAPH STRUCTURE ----              ** 00550000
      ***************************************************************** 00560000
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
      *                                                                 00590000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00850000
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSKR200'.
MSQ017     COPY MFASQLM.
       01  WS-MISCELLANEOUS.                                            
           05 WS-START                 PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSKR200 STARTS HERE'.            
      *                                                                 00900000
       01  WS-WORK-AREA.                                                
           05  WS-WQ-CATEGORY              PIC 9(04) VALUE ZERO.        
           05  WS-DATE-RANGE-1             PIC X(10).                   
           05  WS-DATE-RANGE-2             PIC X(10).                   
           05  WS-NEXT-DAY                 PIC X(10).                   
           05  WS-NUMBER-CHKS-PROCESSED    PIC S9(02) COMP VALUE +0.    
           05  WS-DISPLAY-SQLCODE          PIC -ZZZZZZZZ9.              
           05  WS-NON-UTL-CR-HST           PIC X(24) VALUE SPACES.      
           05  WS-NON-UTL-CR-HST-EX        PIC X(24) VALUE SPACES.      
           05  WS-HOLD-COMPANY             PIC X(02) VALUE SPACES.      
           05  WS-DO-DEPOSIT-AMT           PIC S9(09)V99 COMP-3 VALUE 0.
           05  WS-OLD-DISC-HIST            PIC X(24) VALUE SPACES.      
           05  WS-OLD-DISCEX-HIST          PIC X(24) VALUE SPACES.      
           05  WS-NEW-DISC-HIST-X.                                      
               10  WS-NEW-DISC-HIST        PIC X(01)                    
                                        OCCURS 024 TIMES.               
           05  WS-NEW-DISCEX-HIST-X.                                    
               10  WS-NEW-DISCEX-HIST      PIC X(01)                    
                                        OCCURS 024 TIMES.               
           05  WS-READY-TO-COMMIT-COUNT    PIC S9(09) COMP VALUE +0.    
COB305     05 WS-RETURN-CHECK-AMT        PIC S9(07)V99 COMP-3 VALUE 0.        
COB305     05 WS-BALANCE-DUE        PIC S9(09)V99 COMP-3 VALUE 0.        
           05  WS-DATE-NOTICE-MAIL         PIC X(10).                   
           05  WS-DATE-NOTICE-DUE          PIC X(10).                   
COB305     05 WS-AMT-NOTICE        PIC S9(09)V99 COMP-3 VALUE 0.        
           05  WS-ACCOUNT-NO               PIC 9(13) VALUE 0.           
           05  WS-HOLD-ACCT-NO             PIC 9(13) VALUE 0.           
P0599E     05  WS-PREV-ACCT-NO             PIC 9(13) VALUE 0.           
P0599E     05  WS-PREV-ACCT-NO-WRKD        PIC 9(13) VALUE 0.           
P0599E     05  WS-PREV-MESS-TYPE-WRKD      PIC 9(05).                   
ACT187     05  WS-PREV-MESS-TYPE-WRKD2     PIC 9(05).                   
ACT187     05  WS-PREV-MESS-TYPE-WRKD3     PIC 9(05).                   
ACT187     05  WS-CORRESP-SEQ-NO-WRKD      PIC S9(4) COMP VALUE 0.      
ACT187     05  WS-CORRESP-SEQ-NO-WRKD2     PIC S9(4) COMP VALUE 0.      
ACT187     05  WS-CORRESP-SEQ-NO-WRKD3     PIC S9(4) COMP VALUE 0.      
           05  WS-GUAR-MESS-TYPE           PIC 9(05).                   
           05  WS-THIRD-PTY-MESS-TYPE      PIC 9(05).                   
           05  WS-CODE-MESSAGE-TYPE        PIC 9(05).                   
           05  WS-HOLD-AMOUNT              PIC 9(09)V99.                
           05  WS-HOLD-AMOUNT-K  REDEFINES WS-HOLD-AMOUNT.              
               10  WS-DOL-AMOUNT           PIC 9(09).                   
               10  WS-DEC-AMOUNT           PIC 9(02).                   
           05  RS-KR125-RETURN-CODE        PIC S9(04) COMP VALUE 0.     
P0599F     05  WS-FRCSTED-AUTO-DEP         PIC S9(09)V99 COMP-3 VALUE 0.
P0599I     05  WS-PROCESSED-CD             PIC X(1).                    
ACT248     05  WS-NOTICE-LIMIT-CO01        PIC 9(04)V99999.             
ACT248     05  WS-NOTICE-LIMIT-CO26        PIC 9(04)V99999.             
ACT030     05  WS-INPUT-ZERO               PIC X(16)                    
ACT030                                     VALUE '-00.00.00.000000'.    
ACT030     05  WS-INPUT-DATE-26            PIC X(26) VALUE SPACES.      
ACT210     05  WS-REASON-NOT-DNP           PIC X(01) VALUE SPACE.       
      *                                                                 01110000
       01  WS-NULL-DATES.                                               
           05  WS-DATE-NOTICE-MAIL-NULL    PIC S9(04) COMP VALUE +0.    
           05  WS-DATE-NOTICE-DUE-NULL     PIC S9(04) COMP VALUE +0.    
           05  WS-RETURNED-CHECK-AMT-NULL  PIC S9(04) COMP VALUE +0.    
           05  WS-AUTO-DEP-CHRG-NULL       PIC S9(04) COMP VALUE +0.    
           05  WS-LAST-PYMT-DATE-NULL      PIC S9(04) COMP VALUE +0.    
           05  WS-DATE-BILL-DAY-00-NULL    PIC S9(04) COMP VALUE +0.    
           05  WS-DATE-BILL-DAY-30-NULL    PIC S9(04) COMP VALUE +0.    
           05  WS-DATE-BILL-DAY-60-NULL    PIC S9(04) COMP VALUE +0.    
           05  WS-DATE-BILL-DAY-90-NULL    PIC S9(04) COMP VALUE +0.    
           05  WS-FRST-ERNST-DT-NULL       PIC S9(04) COMP VALUE +0.    
           05  WS-FRST-ERNST-AMT-NULL      PIC S9(04) COMP VALUE +0.    
           05  WS-SCND-ERNST-DT-NULL       PIC S9(04) COMP VALUE +0.    
           05  WS-SCND-ERNST-AMT-NULL      PIC S9(04) COMP VALUE +0.    
A04460     05  WS-AMT-00-DAY-DEP-NULL      PIC S9(04) COMP VALUE +0.    
A04460     05  WS-AMT-30-DAY-DEP-NULL      PIC S9(04) COMP VALUE +0.    
A04460     05  WS-AMT-60-DAY-DEP-NULL      PIC S9(04) COMP VALUE +0.    
A04460     05  WS-AMT-90-DAY-DEP-NULL      PIC S9(04) COMP VALUE +0.    
      *                                                                 01270000
       01  WS-LITERALS.                                                 
           05  WS-DISCONNECT-DESC          PIC X(15) VALUE              
               'DISCONNECT HIST'.                                       
           05  WS-ACTIVE-MED-CERT          PIC X(36) VALUE              
               'ACTIVE MEDICAL CERTIFICATE          '.                  
           05  WS-BANKRUPTCY               PIC X(36) VALUE              
               'BANKRUPTCY                          '.                  
           05  WS-JUDGMENT                 PIC X(36) VALUE              
               'JUDGMENT                            '.                  
           05  WS-DNP-EXEMPTION            PIC X(36) VALUE              
               'DNP EXEMPTION SET                   '.                  
           05  WS-DNP-COMMENT-LEN          PIC S9(4) VALUE 36 COMP.     
           05  WS-DNP-HIST-TRANS-CMNT.                                  
               10  FILLER                  PIC X(29)                    
                   VALUE 'CURRENT MONTH DNP EXEMPTED - '.               
               10  WS-DNP-COMMENT          PIC X(36) VALUE SPACES.      
           05  WS-DISC-EXCEPTN-DESC    PIC X(14)  VALUE                 
               'EXCEPTION HIST'.                                        
           05  WS-CURRENT-DNP-STATUS-E PIC X(18)  VALUE                 
               'CURRENT DNP STATUS'.                                    
           05  WS-CURRENT-DNP-STATUS-B PIC X(18)  VALUE                 
               'DNP - SAME BILLING'.                                    
           05  WS-SLASHES-6            PIC X(06)     VALUE '//////'.    
           05  WS-D                    PIC X(01)     VALUE 'D'.         
           05  WS-E                    PIC X(01)     VALUE 'E'.         
           05  WS-F                    PIC X(01)     VALUE 'F'.         
           05  WS-G                    PIC X(01)     VALUE 'G'.         
           05  WS-H                    PIC X(01)     VALUE 'H'.         
           05  WS-I                    PIC X(01)     VALUE 'I'.         
           05  WS-N                    PIC X(01)     VALUE 'N'.         
           05  WS-O                    PIC X(01)     VALUE 'O'.         
           05  WS-S                    PIC X(01)     VALUE 'S'.         
           05  WS-T                    PIC X(01)     VALUE 'T'.         
           05  WS-U                    PIC X(01)     VALUE 'U'.         
           05  WS-V                    PIC X(01)     VALUE 'V'.         
           05  WS-W                    PIC X(01)     VALUE 'W'.         
           05  WS-Y                    PIC X(01)     VALUE 'Y'.         
           05  WS-COMPLETE             PIC X(01)     VALUE 'C'.         
           05  PROGRAM-NAME            PIC X(08) VALUE 'PCSKR200'.      
           05  WS-PGRMNAME             PIC X(08) VALUE 'PCSKR200'.      
           05  SCSCB068                PIC X(08) VALUE 'SCSCB068'.      
           05  SCSCA151                PIC X(08) VALUE 'SCSCA151'.      
           05  SCSKR125                PIC X(08) VALUE 'SCSKR125'.      
ACT030     05  SCSCB077                PIC X(08) VALUE 'SCSCB077'.      
           05  WS-NEW-UPDT-ACTION-FL   PIC X(01) VALUE 'N'.             
           05  WS-HOME-PHONE           PIC X(02) VALUE 'H1'.            
           05  WS-WORK-PHONE           PIC X(02) VALUE 'W1'.            
      *                                                                 01670000
       01  WS-PROGRAM-FLAGS.                                            
           05  WS-NO-MORE-DATA            PIC X(01)  VALUE 'N'.         
               88  NO-MORE-DATA                      VALUE 'Y'.         
           05  WS-GUARANTOR-EXISTS        PIC X(01).                    
               88  GUARANTOR-EXISTS                  VALUE 'Y'.         
           05  WS-CHECK-PROCESSED         PIC X(01)  VALUE 'N'.         
           05  WS-NOTICE-READY            PIC X(01)  VALUE 'N'.         
           05  WS-DATABASES               PIC 9(01)  VALUE ZERO.        
               88  CSR-DATABASE                      VALUE 1.           
               88  SEB-DATABASE                      VALUE 2.           
           05  WS-SCEG                     PIC X(02) VALUE '01'.        
           05  WS-PSNC                     PIC X(02) VALUE '26'.        
           05  WS-SO-DNP-CANCEL-ROW        PIC X(01) VALUE 'N'.         
               88  DNP-CANCEL-ROW-EXISTS             VALUE 'Y'.         
           05  WS-DISCONNECT-FLAG          PIC X(1)  VALUE 'N'.         
           05  WS-EXCEPTIONAL-FLAG         PIC X(1)  VALUE 'N'.         
           05  WS-REG-SENIOR-FLAG          PIC X(01) VALUE 'N'.         
           05  WS-PROCESS-ACCOUNT          PIC X(01) VALUE 'Y'.         
               88  PROCESS-ACCT                      VALUE 'Y'.         
               88  SKIP-ACCT                         VALUE 'N'.         
P0599K     05  WS-DONE-CASH-ONLY-NOTICE    PIC X(01) VALUE 'N'.         
A05323     05  WS-1450-RET-CHECK-PROCESS   PIC X(01) VALUE 'N'.         
A05323         88 1450-RET-CHECK-PROCESSED           VALUE 'Y'.         
      *                                                                 01890000
       01  WS-WORKQUEUE-COMMENTS.                                       
           05  WS-WQ-AUTO-DEP.                                          
               10 WS-WQ-AUTO-DEP1         PIC X(30)  VALUE              
                  'MAX DEPOSIT CALCULATION = $.00'.                     
               10 FILLER                  PIC X(02)  VALUE              
                  '; '.                                                 
               10 WS-WQ-AUTO-DEP2         PIC X(37)  VALUE              
                  'FORECASTED DNP AUTO DEPOSIT AMOUNT = '.              
               10 WS-WQ-FRCSTED-AMT       PIC $$$$$$$$$.99 VALUE SPACES.
               10 FILLER                  PIC X(02)  VALUE              
                  '; '.                                                 
               10 WS-WQ-AUTO-DEP3         PIC X(19)  VALUE              
                  'TOTAL SECURITIES = '.                                
               10 WS-WQ-AMT-SECURED       PIC $$$$$$$$$.99 VALUE SPACES.
               10 FILLER                  PIC X(02)  VALUE              
                  '; '.                                                 
      *                                                                 02060000
           05  WS-NO-DEP-INT.                                           
               10  FILLER                 PIC X(46)  VALUE              
                   'REVENUE DISTRICT NOT FOUND ON DEPOSIT TABLE - '.    
               10  FILLER                 PIC X(9)   VALUE 'COMPANY: '. 
               10  WS-NO-DEP-INT-CO       PIC XX     VALUE SPACES.      
               10  FILLER                 PIC X(9)   VALUE 'LOC OFF: '. 
               10  WS-NO-DEP-INT-LO       PIC XXX    VALUE SPACES.      
               10  FILLER                 PIC X(10)  VALUE 'REV DIST: '.
               10  WS-NO-DEP-INT-REV-DIST PIC XXX    VALUE SPACES.      
      *                                                                 02160000
       01  WS-COMMENTS.                                                 
           05 WS-COMMENTS-LEN             PIC S9(4) USAGE COMP.         
           05 WS-COMMENTS-TEXT            PIC X(250).                   
      *                                                                 02200000
       01  WS-RECORD-COUNTERS.                                          
           05  WS-COMMITS-COUNT        PIC 9(4)   VALUE ZEROES.         
           05  WS-RECS-TO-COMMIT-COUNT PIC 9(3)   VALUE ZEROES.         
      *                                                                 02240000
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
      *                                                                 02280000
      *01  LOC1                        USAGE IS SQL TYPE IS             
      *                                RESULT-SET-LOCATOR VARYING.      
      *                                                                 02310000
      * INPUT PARAMETERS FOR CSR03515                                   02320000
       01  I-ACCOUNT-NO                PIC X(13) VALUE SPACES.          
       01  I-CALLING-PGM               PIC X(09) VALUE 'PCSCA132'.      
       01  I-AUTO-DEP-TYPE             PIC X(01) VALUE 'B'.             
       01  I-DL-AUTO-DEP-AMT           PIC S9(11)V99 COMP-3 VALUE 0.    
       01  I-USER-ID                   PIC X(07) VALUE 'SYSTEM'.        
       01  I-ERROR-SW                  PIC X(01) VALUE 'N'.             
ACT239 01  I-BATCH-DATE                PIC X(10) VALUE SPACES.          
      *                                                                 02390000
      * RETURN FIELDS FOR CSR03515                                      02400000
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE               PIC S9(09) COMP VALUE 0.     
           05  S-AUTO-DEP-AMT              PIC S9(09)V99 COMP-3 VALUE 0.
           05  S-DEP-SUCCESS               PIC X(01)  VALUE SPACES.     
           05  S-DEP-CERT-NO               PIC S9(9)  COMP VALUE 0.     
           05  S-MAX-DEP-ZERO-WQ           PIC X(01)  VALUE SPACES.     
           05  S-AMT-SECURED               PIC S9(09)V99 COMP-3 VALUE 0.
           05  S-ABEND-PROGRAM             PIC X(08)  VALUE SPACES.     
           05  S-ACTIVE-PARAGRAPH          PIC X(04)  VALUE SPACES.     
           05  S-ABEND-FUNCTION            PIC X(08)  VALUE SPACES.     
           05  S-TABLE-1                   PIC X(20)  VALUE SPACES.     
           05  S-TABLE-ELEMENT-1           PIC X(20)  VALUE SPACES.     
           05  S-HOSTVAR-ELEMENT-1         PIC X(20)  VALUE SPACES.     
           05  S-TABLE-ELEMENT-2           PIC X(20)  VALUE SPACES.     
           05  S-HOSTVAR-ELEMENT-2         PIC X(20)  VALUE SPACES.     
           05  S-TABLE-ELEMENT-3           PIC X(20)  VALUE SPACES.     
           05  S-HOSTVAR-ELEMENT-3         PIC X(20)  VALUE SPACES.     
           05  S-TABLE-ELEMENT-4           PIC X(20)  VALUE SPACES.     
           05  S-HOSTVAR-ELEMENT-4         PIC X(20)  VALUE SPACES.     
      *                                                                 02600000
      ***** COPYBOOK SECTION **********************                     02610000
      *                                                                 02620000
      ***************************************************************** 02630000
      *  CWS00006                                                     * 02640000
      *  THIS COPY STATEMENT IS THE CUSTOMER ACCOUNTING TENANT        * 02650000
      *  RECEIVABLE HISTORY SEGMENT DATA BLOCK LAYOUT. IT IS USED     * 02660000
      *  TO FORMAT THE BLOCKS OF DATA ON THE 'TRH' SEGMENT.           * 02670000
      ***************************************************************** 02680000
       COPY CWS00006.                                                   02690000
      *                                                                 02700000
      ***************************************************************** 02710000
      *  CWS00010            WS ABEND WORK AREA                       * 02720000
      ***************************************************************** 02730000
       COPY CWS00010.                                                   02740000
      *                                                                 02750000
      *                                                                 02860000
      ******************************************************************02870000
      *  CWS00056                                                      *02880000
      * WORKING STORAGE LAYOUT FOR CODES_DATA_PRESENT IN CSS_ACCOUNTS  *02890000
      ******************************************************************02900000
       COPY CWS00056.                                                   02910000
      *                                                                 02920000
      ******************************************************************        
      * AR_TRANS_HIST COMMENT BREAKDOWN FORMAT                         *        
      *  USED IN PANEL 156                                             *        
      ******************************************************************        
           COPY CWS00136.                                                       
      *                                                                         
      ***************************************************************** 02930000
      *  CWSCA151     VARIABLES NEEDED FOR ACCOUNT SKIP PROCESSING.   * 02940000
      ***************************************************************** 02950000
       COPY CWSCA151.                                                   02960000
      *                                                                 02970000
      ***************************************************************** 02980000
      *  CWS00303       USED FOR DB2 AND CICS ERROR PROCESSING        * 02990000
      ***************************************************************** 03000000
       COPY CWS00303.                                                   03010000
      *                                                                 03020000
      ***************************************************************** 03030000
      *  CWS09900  ABEND SWITCH COPYBOOK                              * 03040000
      ***************************************************************** 03050000
       COPY CWS09900.                                                   03060000
      *                                                                 03070000
      ******************************************************************03080000
      * FIOCA00 - CONTAINS THE FIOCA00 LAYOUT FOR COMMONDATE LOGIC.    *03090000
      ******************************************************************03100000
       COPY FIOCA00.                                                    03110000
      *                                                                 03120000
      ******************************************************************03130000
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'                 *03140000
      ******************************************************************03150000
       COPY FIOJC01.                                                    03160000
      *                                                                 03170000
      ***** INCLUDE COPYBOOK SECTION **********************             03180000
      *                                                                 03190000
      ******************************************************************03200000
      *    CSS_ACCOUNT   AT                                             03210000
      ******************************************************************03220000
           EXEC SQL                                                     03230000
               INCLUDE TBACCT                                           03240000
           END-EXEC.                                                    03250000
      *                                                                 03260000
A04460******************************************************************        
A04460*    CSS_AR_CNTL    AR                                                    
A04460******************************************************************        
A04460     EXEC SQL                                                             
A04460        INCLUDE TBARCNTL                                                  
A04460     END-EXEC.                                                            
A04460*                                                                         
      ******************************************************************03270000
      *    CSS_CRED_COLL    CL                                          03280000
      ******************************************************************03290000
           EXEC SQL                                                     03300000
               INCLUDE TBCRCOLL                                         03310000
           END-EXEC.                                                    03320000
      *                                                                 03400000
      ******************************************************************03410000
      *    CSS_CREDIT_PROFILE   CZ                                      03420000
      ******************************************************************03430000
           EXEC SQL                                                     03440000
               INCLUDE TBCRPROF                                         03450000
           END-EXEC.                                                    03460000
      *                                                                 03470000
      ******************************************************************03480000
      *    CSS_DELINQUENCY  C8                                          03490000
      ******************************************************************03500000
           EXEC SQL                                                     03510000
              INCLUDE TBDELQ                                            03520000
           END-EXEC.                                                    03530000
      *                                                                 03540000
      ******************************************************************03550000
      *    CSS_DFA_ACCT    DA                                           03560000
      ******************************************************************03570000
           EXEC SQL                                                     03580000
               INCLUDE TBDFAACT                                         03590000
           END-EXEC.                                                    03600000
      *                                                                 03610000
      ******************************************************************03620000
      *    CSS_GUARANTOR    GU                                          03630000
      ******************************************************************03640000
           EXEC SQL                                                     03650000
               INCLUDE TBGTNTR                                          03660000
           END-EXEC.                                                    03670000
      *                                                                 03680000
      ******************************************************************03690000
      *    CSS_JOB_PARM   G6                                            03700000
      ******************************************************************03710000
           EXEC SQL                                                     03720000
              INCLUDE TBJBPARM                                          03730000
           END-EXEC.                                                    03740000
      *                                                                 03750000
      ******************************************************************03760000
      *    CSS_NSF_REASON   NR                                                  
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE TBNSFRSN                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_NSF_HIST     NH                                          03770000
      ******************************************************************03780000
           EXEC SQL                                                     03790000
               INCLUDE TBNSFHST                                         03800000
           END-EXEC.                                                    03810000
      *                                                                 03820000
      ******************************************************************03900000
      *    CSS_REG_PROFILE     LR                                       03910000
      ******************************************************************03920000
           EXEC SQL                                                     03930000
               INCLUDE TBREGPRF                                         03940000
           END-EXEC.                                                    03950000
      *                                                                 03960000
      ***************************************************************** 03970000
      * CSS_MNT_TRANS_HIST     MH                                       03980000
      ***************************************************************** 03990000
                                                                        
           EXEC SQL                                                     04010000
              INCLUDE TBMNHIST                                          04020000
           END-EXEC.                                                    04030000
      *                                                                 04040000
      ***************************************************************** 04050000
      * CSS_MT_TRN_HST_DET     MI                                       04060000
      ***************************************************************** 04070000
      *                                                                 04080000
           EXEC SQL                                                     04090000
              INCLUDE TBMNHDT                                           04100000
           END-EXEC.                                                    04110000
      *                                                                 04120000
      ******************************************************************04130000
      *    CSS_PREMISE     PR                                           04140000
      ******************************************************************04150000
           EXEC SQL                                                     04160000
               INCLUDE TBPREM                                           04170000
           END-EXEC.                                                    04180000
      *                                                                 04190000
      ******************************************************************04200000
      *    CSS_DEP_INT_RATE  P6                                         04210000
      ******************************************************************04220000
           EXEC SQL                                                     04230000
              INCLUDE TBDEPINT                                          04240000
           END-EXEC.                                                    04250000
      *                                                                 04260000
      ******************************************************************        
      *    CSS_WQ_PGM_CNTL    WN                                                
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBWQCNTL                                                 
           END-EXEC.                                                            
      *                                                                 04470000
      ******************************************************************04480000
      *    CSS_SO_DNP_CANCEL    XK                                      04490000
      ******************************************************************04500000
           EXEC SQL                                                     04510000
              INCLUDE TBSODNPC                                          04520000
           END-EXEC.                                                    04530000
      *                                                                 04540000
      ******************************************************************04550000
      *    CSS_THD_PRTY   ZW                                            04560000
      ******************************************************************04570000
           EXEC SQL                                                     04580000
              INCLUDE TBTHDPTY                                          04590000
           END-EXEC.                                                    04600000
      *                                                                 04610000
      ******************************************************************04620000
      *    CSS_THD_PRTY_PHONE  ZY                                               
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBTHDPHO                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SQL COPYBOOK                                                 04630000
      ******************************************************************04640000
           EXEC SQL                                                     04650000
               INCLUDE SQLCA                                            04660000
           END-EXEC.                                                    04670000
      *                                                                 04680000
      ***************************************************************** 02760000
      *  CWS00038         INPUT DATA LAYOUTS                          * 02770000
      ***************************************************************** 02780000
A04460     EXEC SQL                                                             
A04460        INCLUDE CWS00038                                                  
A04460     END-EXEC.                                                            
      *                                                                 02800000
       01  WS-INSERT-ROW-COUNT REDEFINES WS-INPUT-DATA-BREAKDOWN.       
           10  WS-PARM-COMMIT-ROW-COUNT-TXT PIC X(9).                   
               88 COMMIT-ROW-CNT         VALUE 'COMMIT = '.             
           10  WS-NO-OF-ROWS-TO-COMMIT   PIC X(05).                     
           10  FILLER                    PIC X(66).                     
      *                                                                         
      ******************************************************************04690000
      * WORKING STORAGE FOR WS-FCA00-MISC DATA                         *04700000
      ******************************************************************04710000
           EXEC SQL                                                     04720000
              INCLUDE CWS00039                                          04730000
           END-EXEC.                                                    04740000
      *                                                                 04750000
      ******************************************************************04760000
      * WORKING STORAGE FOR SCSCB068                                   *04770000
      ******************************************************************04780000
           EXEC SQL                                                     04790000
              INCLUDE CWS00068                                          04800000
           END-EXEC.                                                    04810000
      *                                                                 04820000
ACT030******************************************************************02870000
ACT030* FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077          *02890000
ACT030******************************************************************02900000
ACT030     EXEC SQL                                                     04790000
ACT030        INCLUDE CWS00077                                          04800000
ACT030     END-EXEC.                                                    04810000
ACT030*                                                                 04820000
      ******************************************************************04830000
      * WORKING STORAGE FOR THE THRESHOLDS VALUES FOR SYSTEM EXCEPTIONS*04840000
      ******************************************************************04850000
           EXEC SQL                                                     04860000
              INCLUDE CWS00314                                          04870000
           END-EXEC.                                                    04880000
      *                                                                 04890000
      ******************************************************************04900000
      * WORKING STORAGE NEXT BUSINESS DAY CPYC CPD00322.               *04910000
      ******************************************************************04920000
           EXEC SQL                                                     04930000
              INCLUDE CWS00322                                          04940000
           END-EXEC.                                                    04950000
      *                                                                 04960000
      ***************************************************************** 04970000
      *  CWS00341  - CORRESP TABLES WS VARIABLES                      *         
      ***************************************************************** 04990000
           EXEC SQL                                                     05000000
               INCLUDE CWS00341                                                 
           END-EXEC.                                                    05020000
      *                                                                 05030000
      ***************************************************************** 05040000
      *  CWS00346     CONTAINS WS GETTING WQ GENERATION FLAG          * 05050000
      ***************************************************************** 05060000
           EXEC SQL                                                     05070000
              INCLUDE CWS00346                                          05080000
           END-EXEC.                                                    05090000
      *                                                                 05100000
      ***************************************************************** 00010000
      *  CWS00350  THIS COPYBOOK CONTAINS THE CSS-CORRESP-COMM VALUES * 00020000
      ***************************************************************** 00080000
           EXEC SQL                                                     05140000
              INCLUDE CWS00350                                                  
           END-EXEC.                                                    05160000
      *                                                                 05170000
      ******************************************************************05180000
      **** 1ST MAIN DRIVING CURSOR TO SELECT ACTIVE ACCTS TO PROCESS ***05190000
      ******************************************************************05200000
           EXEC SQL                                                     
             DECLARE ACTIVE_ACCT_CURSOR CURSOR WITH HOLD FOR            
             SELECT                                                     
                 AT.CUSTOMER_NO                                         
                ,AT.ACCOUNT_NO                                          
                ,AT.PREMISE_NO                                          
                ,AT.COMPANY_NO                                          
                ,AT.LOCAL_OFFICE                                        
                ,AT.DATE_BILL_DAY_00                                    
                ,AT.DATE_BILL_DAY_30                                    
                ,AT.DATE_BILL_DAY_60                                    
                ,AT.DATE_BILL_DAY_90                                    
                ,AT.DATE_LAST_ACTION                                    
                ,AT.CODES_DATA_PRESENT                                  
                ,AT.BILL_CYCLE                                          
                ,AT.ADDRESS_FORMAT                                      
                ,AT.ADDRESS_ID                                          
                ,AT.TOTAL_AR_BALANCE                                    
                ,AT.LAST_PYMT_AMOUNT                                    
                ,AT.LAST_PYMT_DATE                                      
                ,AT.CODE_ACCT_STAT                                      
                ,AT.CODE_STATUS_REASON                                  
                ,AT.CREDIT_GROUP                                        
                ,AT.ACCOUNT_TYPE_CODE                                   
                ,AT.BANKRUPTCY_IND                                      
                ,AT.JUDGEMENT_CASE_NO                                   
                ,AT.NOTICE_EXEMPT_CD                                    
                ,AT.IVR_EXEMPT_CD                                       
                ,AT.CODE_DISC_OK                                        
                ,CL.DATE_NOTICE_MAIL                                    
                ,CL.CODE_NOTICE_TYPE                                    
                ,CL.CODE_MESSAGE_TYPE                                   
P0599I          ,CL.ITEM_ID                                             
              FROM CSS_ACCOUNT AT                                       
                  ,CSS_CRED_COLL CL                                     
             WHERE CL.ACCOUNT_NO = AT.ACCOUNT_NO                        
               AND AT.CODE_ACCT_STAT IN ('A', 'P')                      
               AND CL.CODE_NOTICE_TYPE IN ('C', 'E', 'F', 'N', 'O')     
               AND CL.DATE_NOTICE_MAIL  = IIF(TRY_CONVERT(DATE, 
                                                           :WS-NEXT-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEXT-DAY
              ) <> 0) OR (LEN(:WS-NEXT-DAY) <> 10), CIS.CHAR2DATE(
                                                           :WS-NEXT-DAY
              ), CONVERT(DATE, :WS-NEXT-DAY) )                  
P0599C         AND CL.PROCESSED_CD IN (' ', 'I')                        
             ORDER BY AT.COMPANY_NO, AT.ACCOUNT_NO, CL.CODE_NOTICE_TYPE 
              FOR READ ONLY                                            
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05210000
MFA-TR*      DECLARE ACTIVE_ACCT_CURSOR CURSOR WITH HOLD FOR            05220000
MFA-TR*      SELECT                                                     05230000
MFA-TR*          AT.CUSTOMER_NO                                         05240000
MFA-TR*         ,AT.ACCOUNT_NO                                          05250000
MFA-TR*         ,AT.PREMISE_NO                                          05260000
MFA-TR*         ,AT.COMPANY_NO                                          05270000
MFA-TR*         ,AT.LOCAL_OFFICE                                        05280000
MFA-TR*         ,AT.DATE_BILL_DAY_00                                    05290000
MFA-TR*         ,AT.DATE_BILL_DAY_30                                    05300000
MFA-TR*         ,AT.DATE_BILL_DAY_60                                    05310000
MFA-TR*         ,AT.DATE_BILL_DAY_90                                    05320000
MFA-TR*         ,AT.DATE_LAST_ACTION                                    05330000
MFA-TR*         ,AT.CODES_DATA_PRESENT                                  05340000
MFA-TR*         ,AT.BILL_CYCLE                                          05350000
MFA-TR*         ,AT.ADDRESS_FORMAT                                      05360000
MFA-TR*         ,AT.ADDRESS_ID                                          05370000
MFA-TR*         ,AT.TOTAL_AR_BALANCE                                    05380000
MFA-TR*         ,AT.LAST_PYMT_AMOUNT                                    05390000
MFA-TR*         ,AT.LAST_PYMT_DATE                                      05400000
MFA-TR*         ,AT.CODE_ACCT_STAT                                      05410000
MFA-TR*         ,AT.CODE_STATUS_REASON                                  05420000
MFA-TR*         ,AT.CREDIT_GROUP                                        05430000
MFA-TR*         ,AT.ACCOUNT_TYPE_CODE                                   05440000
MFA-TR*         ,AT.BANKRUPTCY_IND                                      05450000
MFA-TR*         ,AT.JUDGEMENT_CASE_NO                                   05460000
MFA-TR*         ,AT.NOTICE_EXEMPT_CD                                    05470000
MFA-TR*         ,AT.IVR_EXEMPT_CD                                       05480000
MFA-TR*         ,AT.CODE_DISC_OK                                        05490000
MFA-TR*         ,CL.DATE_NOTICE_MAIL                                    05500000
MFA-TR*         ,CL.CODE_NOTICE_TYPE                                    05510000
MFA-TR*         ,CL.CODE_MESSAGE_TYPE                                   05520000
MFA-TR*         ,CL.ITEM_ID                                             05520000
MFA-TR*       FROM CSS_ACCOUNT AT                                       05530000
MFA-TR*           ,CSS_CRED_COLL CL                                     05540000
MFA-TR*      WHERE CL.ACCOUNT_NO = AT.ACCOUNT_NO                        05550000
MFA-TR*        AND AT.CODE_ACCT_STAT IN ('A', 'P')                      05560000
MFA-TR*        AND CL.CODE_NOTICE_TYPE IN ('C', 'E', 'F', 'N', 'O')     05570000
MFA-TR*        AND CL.DATE_NOTICE_MAIL  = :WS-NEXT-DAY                          
MFA-TR*        AND CL.PROCESSED_CD IN (' ', 'I')                        05590000
MFA-TR*      ORDER BY AT.COMPANY_NO, AT.ACCOUNT_NO, CL.CODE_NOTICE_TYPE 05600000
MFA-TR*       FOR FETCH ONLY                                            05610000
MFA-TR*       QUERYNO 7000                                              05620000
MFA-TR*    END-EXEC.                                                    05630000
      *                                                                 05640000
      ******************************************************************05650000
      ** 2ND MAIN DRIVING CURSOR TO SELECT PENDING FB ACCTS TO PROCESS *05660000
      ******************************************************************05670000
           EXEC SQL                                                     
             DECLARE PND_FB_ACCT_CURSOR CURSOR WITH HOLD FOR            
             SELECT                                                     
                 AT.CUSTOMER_NO                                         
                ,AT.ACCOUNT_NO                                          
                ,AT.PREMISE_NO                                          
                ,AT.COMPANY_NO                                          
                ,AT.LOCAL_OFFICE                                        
                ,AT.DATE_BILL_DAY_00                                    
                ,AT.DATE_BILL_DAY_30                                    
                ,AT.DATE_BILL_DAY_60                                    
                ,AT.DATE_BILL_DAY_90                                    
                ,AT.DATE_LAST_ACTION                                    
                ,AT.CODES_DATA_PRESENT                                  
                ,AT.BILL_CYCLE                                          
                ,AT.ADDRESS_FORMAT                                      
                ,AT.ADDRESS_ID                                          
                ,AT.TOTAL_AR_BALANCE                                    
                ,AT.LAST_PYMT_AMOUNT                                    
                ,AT.LAST_PYMT_DATE                                      
                ,AT.CODE_ACCT_STAT                                      
                ,AT.CODE_STATUS_REASON                                  
                ,AT.CREDIT_GROUP                                        
                ,AT.ACCOUNT_TYPE_CODE                                   
                ,AT.BANKRUPTCY_IND                                      
                ,AT.JUDGEMENT_CASE_NO                                   
                ,AT.NOTICE_EXEMPT_CD                                    
                ,AT.IVR_EXEMPT_CD                                       
                ,AT.CODE_DISC_OK                                        
                ,CL.DATE_NOTICE_MAIL                                    
                ,CL.CODE_NOTICE_TYPE                                    
                ,CL.CODE_MESSAGE_TYPE                                   
P0599I          ,CL.ITEM_ID                                             
              FROM CSS_ACCOUNT AT                                       
                  ,CSS_CRED_COLL CL                                     
             WHERE CL.ACCOUNT_NO = AT.ACCOUNT_NO                        
               AND AT.CODE_ACCT_STAT = 'B'                              
               AND CL.CODE_NOTICE_TYPE = 'N'                            
               AND CL.DATE_NOTICE_MAIL  = IIF(TRY_CONVERT(DATE, 
                                                           :WS-NEXT-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEXT-DAY
              ) <> 0) OR (LEN(:WS-NEXT-DAY) <> 10), CIS.CHAR2DATE(
                                                           :WS-NEXT-DAY
              ), CONVERT(DATE, :WS-NEXT-DAY) )                  
P0599C         AND CL.PROCESSED_CD IN (' ', 'I')                        
             ORDER BY AT.COMPANY_NO, AT.ACCOUNT_NO, CL.CODE_NOTICE_TYPE 
              FOR READ ONLY                                            
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05680000
MFA-TR*      DECLARE PND_FB_ACCT_CURSOR CURSOR WITH HOLD FOR            05690000
MFA-TR*      SELECT                                                     05700000
MFA-TR*          AT.CUSTOMER_NO                                         05710000
MFA-TR*         ,AT.ACCOUNT_NO                                          05720000
MFA-TR*         ,AT.PREMISE_NO                                          05730000
MFA-TR*         ,AT.COMPANY_NO                                          05740000
MFA-TR*         ,AT.LOCAL_OFFICE                                        05750000
MFA-TR*         ,AT.DATE_BILL_DAY_00                                    05760000
MFA-TR*         ,AT.DATE_BILL_DAY_30                                    05770000
MFA-TR*         ,AT.DATE_BILL_DAY_60                                    05780000
MFA-TR*         ,AT.DATE_BILL_DAY_90                                    05790000
MFA-TR*         ,AT.DATE_LAST_ACTION                                    05800000
MFA-TR*         ,AT.CODES_DATA_PRESENT                                  05810000
MFA-TR*         ,AT.BILL_CYCLE                                          05820000
MFA-TR*         ,AT.ADDRESS_FORMAT                                      05830000
MFA-TR*         ,AT.ADDRESS_ID                                          05840000
MFA-TR*         ,AT.TOTAL_AR_BALANCE                                    05850000
MFA-TR*         ,AT.LAST_PYMT_AMOUNT                                    05860000
MFA-TR*         ,AT.LAST_PYMT_DATE                                      05870000
MFA-TR*         ,AT.CODE_ACCT_STAT                                      05880000
MFA-TR*         ,AT.CODE_STATUS_REASON                                  05890000
MFA-TR*         ,AT.CREDIT_GROUP                                        05900000
MFA-TR*         ,AT.ACCOUNT_TYPE_CODE                                   05910000
MFA-TR*         ,AT.BANKRUPTCY_IND                                      05920000
MFA-TR*         ,AT.JUDGEMENT_CASE_NO                                   05930000
MFA-TR*         ,AT.NOTICE_EXEMPT_CD                                    05940000
MFA-TR*         ,AT.IVR_EXEMPT_CD                                       05950000
MFA-TR*         ,AT.CODE_DISC_OK                                        05960000
MFA-TR*         ,CL.DATE_NOTICE_MAIL                                    05970000
MFA-TR*         ,CL.CODE_NOTICE_TYPE                                    05980000
MFA-TR*         ,CL.CODE_MESSAGE_TYPE                                   05990000
MFA-TR*         ,CL.ITEM_ID                                             05520000
MFA-TR*       FROM CSS_ACCOUNT AT                                       06000000
MFA-TR*           ,CSS_CRED_COLL CL                                     06010000
MFA-TR*      WHERE CL.ACCOUNT_NO = AT.ACCOUNT_NO                        06020000
MFA-TR*        AND AT.CODE_ACCT_STAT = 'B'                              06030000
MFA-TR*        AND CL.CODE_NOTICE_TYPE = 'N'                            06040000
MFA-TR*        AND CL.DATE_NOTICE_MAIL  = :WS-NEXT-DAY                          
MFA-TR*        AND CL.PROCESSED_CD IN (' ', 'I')                        06060000
MFA-TR*      ORDER BY AT.COMPANY_NO, AT.ACCOUNT_NO, CL.CODE_NOTICE_TYPE 06070000
MFA-TR*       FOR FETCH ONLY                                            06080000
MFA-TR*       QUERYNO 7010                                              06090000
MFA-TR*    END-EXEC.                                                    06100000
      *                                                                 06110000
A04460******************************************************************        
A04460**** 3RD MAIN DRIVING CURSOR TO HANDLE DEPOSIT BILL IMMEDIATE   **        
A04460******************************************************************        
A04460     EXEC SQL                                                     
A04460       DECLARE DEPOSIT_BILL_IMMEDIATE CURSOR WITH HOLD FOR        
A04460       SELECT                                                     
A04460           AT.CUSTOMER_NO                                         
A04460          ,AT.ACCOUNT_NO                                          
A04460          ,AT.PREMISE_NO                                          
A04460          ,AT.COMPANY_NO                                          
A04460          ,AT.LOCAL_OFFICE                                        
A04460          ,AT.DATE_BILL_DAY_00                                    
A04460          ,AT.DATE_BILL_DAY_30                                    
A04460          ,AT.DATE_BILL_DAY_60                                    
A04460          ,AT.DATE_BILL_DAY_90                                    
A04460          ,AT.DATE_LAST_ACTION                                    
A04460          ,AT.CODES_DATA_PRESENT                                  
A04460          ,AT.BILL_CYCLE                                          
A04460          ,AT.ADDRESS_FORMAT                                      
A04460          ,AT.ADDRESS_ID                                          
A04460          ,AT.TOTAL_AR_BALANCE                                    
A04460          ,AT.LAST_PYMT_AMOUNT                                    
A04460          ,AT.LAST_PYMT_DATE                                      
A04460          ,AT.CODE_ACCT_STAT                                      
A04460          ,AT.CODE_STATUS_REASON                                  
A04460          ,AT.CREDIT_GROUP                                        
A04460          ,AT.ACCOUNT_TYPE_CODE                                   
A04460          ,AT.BANKRUPTCY_IND                                      
A04460          ,AT.JUDGEMENT_CASE_NO                                   
A04460          ,AT.NOTICE_EXEMPT_CD                                    
A04460          ,AT.IVR_EXEMPT_CD                                       
A04460          ,AT.CODE_DISC_OK                                        
A04460          ,CL.DATE_NOTICE_MAIL                                    
A04460          ,CL.CODE_SPECIAL_TYPE                                   
A04460          ,CL.CODE_NOTICE_TYPE                                    
A04460          ,CL.CODE_MESSAGE_TYPE                                   
A04460          ,CL.ITEM_ID                                             
A04460          ,CL.DATE_NOTICE_DUE                                     
A04460        FROM CSS_ACCOUNT AT                                       
A04460            ,CSS_CRED_COLL CL                                     
A04460       WHERE CL.ACCOUNT_NO = AT.ACCOUNT_NO                        
A04460         AND AT.CODE_ACCT_STAT IN ('A', 'P')                      
A04460         AND CL.CODE_NOTICE_TYPE = 'O'                            
A04460         AND CL.DATE_NOTICE_MAIL  = IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )                
A04460         AND CL.PROCESSED_CD IN (' ', 'I')                        
A04460       ORDER BY AT.COMPANY_NO, AT.ACCOUNT_NO, CL.CODE_NOTICE_TYPE 
A04460        FOR READ ONLY                                            
A04460                                                      
A04460     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE DEPOSIT_BILL_IMMEDIATE CURSOR WITH HOLD FOR                
MFA-TR*      SELECT                                                             
MFA-TR*          AT.CUSTOMER_NO                                                 
MFA-TR*         ,AT.ACCOUNT_NO                                                  
MFA-TR*         ,AT.PREMISE_NO                                                  
MFA-TR*         ,AT.COMPANY_NO                                                  
MFA-TR*         ,AT.LOCAL_OFFICE                                                
MFA-TR*         ,AT.DATE_BILL_DAY_00                                            
MFA-TR*         ,AT.DATE_BILL_DAY_30                                            
MFA-TR*         ,AT.DATE_BILL_DAY_60                                            
MFA-TR*         ,AT.DATE_BILL_DAY_90                                            
MFA-TR*         ,AT.DATE_LAST_ACTION                                            
MFA-TR*         ,AT.CODES_DATA_PRESENT                                          
MFA-TR*         ,AT.BILL_CYCLE                                                  
MFA-TR*         ,AT.ADDRESS_FORMAT                                              
MFA-TR*         ,AT.ADDRESS_ID                                                  
MFA-TR*         ,AT.TOTAL_AR_BALANCE                                            
MFA-TR*         ,AT.LAST_PYMT_AMOUNT                                            
MFA-TR*         ,AT.LAST_PYMT_DATE                                              
MFA-TR*         ,AT.CODE_ACCT_STAT                                              
MFA-TR*         ,AT.CODE_STATUS_REASON                                          
MFA-TR*         ,AT.CREDIT_GROUP                                                
MFA-TR*         ,AT.ACCOUNT_TYPE_CODE                                           
MFA-TR*         ,AT.BANKRUPTCY_IND                                              
MFA-TR*         ,AT.JUDGEMENT_CASE_NO                                           
MFA-TR*         ,AT.NOTICE_EXEMPT_CD                                            
MFA-TR*         ,AT.IVR_EXEMPT_CD                                               
MFA-TR*         ,AT.CODE_DISC_OK                                                
MFA-TR*         ,CL.DATE_NOTICE_MAIL                                            
MFA-TR*         ,CL.CODE_SPECIAL_TYPE                                           
MFA-TR*         ,CL.CODE_NOTICE_TYPE                                            
MFA-TR*         ,CL.CODE_MESSAGE_TYPE                                           
MFA-TR*         ,CL.ITEM_ID                                                     
MFA-TR*         ,CL.DATE_NOTICE_DUE                                             
MFA-TR*       FROM CSS_ACCOUNT AT                                               
MFA-TR*           ,CSS_CRED_COLL CL                                             
MFA-TR*      WHERE CL.ACCOUNT_NO = AT.ACCOUNT_NO                                
MFA-TR*        AND AT.CODE_ACCT_STAT IN ('A', 'P')                              
MFA-TR*        AND CL.CODE_NOTICE_TYPE = 'O'                                    
MFA-TR*        AND CL.DATE_NOTICE_MAIL  = :WS-INPUT-DATE                        
MFA-TR*        AND CL.PROCESSED_CD IN (' ', 'I')                                
MFA-TR*      ORDER BY AT.COMPANY_NO, AT.ACCOUNT_NO, CL.CODE_NOTICE_TYPE         
MFA-TR*       FOR FETCH ONLY                                                    
MFA-TR*       QUERYNO 7015                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************  06120000
      **  CURSOR TO LOOK FOR ACTIVE GUARANTORS                      **          
      ****************************************************************          
           EXEC SQL                                                     
              DECLARE GUARANTOR_CURSOR CURSOR FOR                       
              SELECT GU.GUARNTR_ACCT_NO                                 
ACT145              ,GU.ADDRESS_ID                                      
ACT145              ,AT.ADDRESS_ID                                      
ACT145              ,AT.ADDRESS_FORMAT                                  
ACT145        FROM CSS_GUARANTOR GU WITH(READUNCOMMITTED),                      
ACT145             CSS_ACCOUNT AT WITH(READUNCOMMITTED)                         
ACT145        WHERE GU.ACCOUNT_NO      = :GU-ACCOUNT-NO                 
                AND GU.GUARNTR_ACCT_NO = AT.ACCOUNT_NO                  
                AND GU.GUAR_STATUS_CD  = 'A'                            
                AND GU.SERVICE_TYPE_CD = 'U'                            
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE GUARANTOR_CURSOR CURSOR FOR                               
MFA-TR*       SELECT GU.GUARNTR_ACCT_NO                                         
MFA-TR*             ,GU.ADDRESS_ID                                              
MFA-TR*             ,AT.ADDRESS_ID                                              
MFA-TR*             ,AT.ADDRESS_FORMAT                                          
MFA-TR*       FROM CSS_GUARANTOR GU,                                            
MFA-TR*            CSS_ACCOUNT AT                                               
MFA-TR*       WHERE GU.ACCOUNT_NO      = :GU-ACCOUNT-NO                         
MFA-TR*         AND GU.GUARNTR_ACCT_NO = AT.ACCOUNT_NO                          
MFA-TR*         AND GU.GUAR_STATUS_CD  = 'A'                                    
MFA-TR*         AND GU.SERVICE_TYPE_CD = 'U'                                    
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  CURSOR TO LOOK FOR NOTICES                                **  06130000
      ****************************************************************  06140000
           EXEC SQL                                                     
              DECLARE CRED_COLL_N_CSR CURSOR FOR                        
               SELECT                                                   
                     DATE_NOTICE_MAIL,                                  
                     DATE_NOTICE_DUE,                                   
                     ITEM_ID                                            
               FROM                                                     
                     CSS_CRED_COLL WITH(READUNCOMMITTED)                        
               WHERE                                                    
                     ACCOUNT_NO       = :CL-ACCOUNT-NO                  
                 AND CODE_NOTICE_TYPE = 'N'                             
               ORDER BY ITEM_ID                                         
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     06150000
MFA-TR*       DECLARE CRED_COLL_N_CSR CURSOR FOR                        06160000
MFA-TR*        SELECT                                                   06170000
MFA-TR*              DATE_NOTICE_MAIL,                                  06180000
MFA-TR*              DATE_NOTICE_DUE,                                   06190000
MFA-TR*              ITEM_ID                                            06200000
MFA-TR*        FROM                                                     06210000
MFA-TR*              CSS_CRED_COLL                                      06220000
MFA-TR*        WHERE                                                    06230000
MFA-TR*              ACCOUNT_NO       = :CL-ACCOUNT-NO                  06240000
MFA-TR*          AND CODE_NOTICE_TYPE = 'N'                             06250000
MFA-TR*        ORDER BY ITEM_ID                                         06260000
MFA-TR*      FOR FETCH ONLY WITH UR                                     06270000
MFA-TR*       QUERYNO 7109                                              06280000
MFA-TR*    END-EXEC.                                                    06290000
      *                                                                 06300000
      ****************************************************************  06310000
      **  CURSOR TO LOOK FOR RETURNED CHECKS                        **  06320000
      ****************************************************************  06330000
           EXEC SQL                                                     
              DECLARE RETURNED_CHK_CSR CURSOR FOR                       
               SELECT                                                   
                     NSF_CHARGE_AMT,                                    
                     RETURN_CHECK_AMT,                                  
                     NSF_REASON_CD,                                     
                     DRAWN_BY_NM,                                       
                     REPLACE(REPLACE(CONVERT(CHAR(26), NSF_TIMESTMP
           , 121), ' ', '-'), ':', '.') NSF_TIMESTMP,                          
                     NSF_STATUS_CD,                                     
                     DEPOSIT_CERT_NO                                    
               FROM CSS_NSF_HIST WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO    = :NH-ACCOUNT-NO                     
                 AND DATE_TRAN     >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-DATE-RANGE-1
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-RANGE-1
              ) <> 0) OR (LEN(:WS-DATE-RANGE-1) <> 10), CIS.CHAR2DATE(
                                                       :WS-DATE-RANGE-1
              ), CONVERT(DATE, :WS-DATE-RANGE-1) )                  
                 AND DATE_TRAN     <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-DATE-RANGE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-RANGE-2
              ) <> 0) OR (LEN(:WS-DATE-RANGE-2) <> 10), CIS.CHAR2DATE(
                                                       :WS-DATE-RANGE-2
              ), CONVERT(DATE, :WS-DATE-RANGE-2) )                  
                 AND SEND_NOTICE_CD = 'Y'                               
                 AND NSF_STATUS_CD IN ('C','F')                         
               ORDER BY NSF_TIMESTMP                                    
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     06340000
MFA-TR*       DECLARE RETURNED_CHK_CSR CURSOR FOR                       06350000
MFA-TR*        SELECT                                                   06360000
MFA-TR*              NSF_CHARGE_AMT,                                    06370000
MFA-TR*              RETURN_CHECK_AMT,                                  06380000
MFA-TR*              NSF_REASON_CD,                                     06390000
MFA-TR*              DRAWN_BY_NM,                                       06400000
MFA-TR*              NSF_TIMESTMP,                                      06420000
MFA-TR*              NSF_STATUS_CD,                                     06430000
MFA-TR*              DEPOSIT_CERT_NO                                    06440000
MFA-TR*        FROM CSS_NSF_HIST                                        06450000
MFA-TR*        WHERE ACCOUNT_NO    = :NH-ACCOUNT-NO                     06460000
MFA-TR*          AND DATE_TRAN     >= :WS-DATE-RANGE-1                  06470000
MFA-TR*          AND DATE_TRAN     <= :WS-DATE-RANGE-2                  06480000
MFA-TR*          AND SEND_NOTICE_CD = 'Y'                               06490000
MFA-TR*          AND NSF_STATUS_CD IN ('C','F')                         06500000
MFA-TR*        ORDER BY NSF_TIMESTMP                                    06510000
MFA-TR*      FOR FETCH ONLY WITH UR                                     06520000
MFA-TR*       QUERYNO 7110                                              06530000
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  CURSOR TO LOOK FOR THIRD PARTY ACCOUNTS                   **          
      ****************************************************************          
           EXEC SQL                                                     
              DECLARE THIRD_PARTY CURSOR FOR                            
               SELECT                                                   
                 ZW.THD_PRTY_ID,                                        
                 ZW.NAME_ID,                                            
                 ZW.ADDRESS_ID                                          
              FROM CSS_THD_PRTY ZW WITH(READUNCOMMITTED)                        
              WHERE                                                     
                  ZW.ACCOUNT_NO = :ZW-ACCOUNT-NO AND                    
                  ZW.THD_PRTY_STATUS = :ZW-THD-PRTY-STATUS              
             FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00062700
MFA-TR*       DECLARE THIRD_PARTY CURSOR FOR                            00062800
MFA-TR*        SELECT                                                   00062900
MFA-TR*          ZW.THD_PRTY_ID,                                        00063000
MFA-TR*          ZW.NAME_ID,                                            00063300
MFA-TR*          ZW.ADDRESS_ID                                                  
MFA-TR*       FROM CSS_THD_PRTY ZW                                      00063500
MFA-TR*       WHERE                                                     00063600
MFA-TR*           ZW.ACCOUNT_NO = :ZW-ACCOUNT-NO AND                            
MFA-TR*           ZW.THD_PRTY_STATUS = :ZW-THD-PRTY-STATUS                      
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                    06540000
      *                                                                 06550000
       01  WS-MISC-END.                                                 
           05 WS-END                   PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSKR200 ENDS HERE'.
MSQ001        EXEC SQL
MSQ001          DECLARE C1 CURSOR
MSQ001          FOR CALL CSR03515                                       
                       ( :I-ACCOUNT-NO
                  , :I-CALLING-PGM
                  , :I-AUTO-DEP-TYPE
                  , :I-DL-AUTO-DEP-AMT
                  , :I-USER-ID
                  , :I-ERROR-SW
                  , :I-BATCH-DATE
                  )
MSQ001        END-EXEC.
              
      ****************************************************************  06590000
      *                                                                 06600000
       PROCEDURE DIVISION.                                              
      ******************************************************************06620000
      *   0000-MAINLINE.                                               *06630000
      *        CONTROLS THE MAIN PROCESS OF PROGRAM                    *06640000
      ******************************************************************06650000
       0000-MAINLINE.                                                   
      *                                                                 06670000
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                 06690000
           PERFORM 7000-OPEN-MAIN1-ACCT-CSR THRU 7000-EXIT.             
           PERFORM 7001-FETCH-MAIN1-ACCT-CSR THRU 7001-EXIT.            
           PERFORM UNTIL NO-MORE-DATA                                   
               PERFORM 1000-PROCESS-SELTD-ACCT THRU 1000-EXIT           
               PERFORM 7001-FETCH-MAIN1-ACCT-CSR THRU 7001-EXIT         
           END-PERFORM.                                                 
           PERFORM 7002-CLOSE-MAIN1-ACCT-CSR THRU 7002-EXIT.            
      *                                                                 06770000
           MOVE 'N' TO WS-NO-MORE-DATA.                                 
           PERFORM 7010-OPEN-MAIN2-ACCT-CSR THRU 7010-EXIT.             
           PERFORM 7011-FETCH-MAIN2-ACCT-CSR THRU 7011-EXIT.            
           PERFORM UNTIL NO-MORE-DATA                                   
               PERFORM 1010-PROCESS-SELTD-FB-ACCT THRU 1010-EXIT        
               PERFORM 7011-FETCH-MAIN2-ACCT-CSR THRU 7011-EXIT         
           END-PERFORM.                                                 
           PERFORM 7012-CLOSE-MAIN2-ACCT-CSR THRU 7012-EXIT.            
      *                                                                 06860000
A04460     IF CSR-DATABASE                                              
A04460        MOVE 'N' TO WS-NO-MORE-DATA                               
A04460        PERFORM 7015-OPEN-MAIN3-ACCT-CSR THRU 7015-EXIT           
A04460        PERFORM 7016-FETCH-MAIN3-ACCT-CSR THRU 7016-EXIT          
A04460        PERFORM UNTIL NO-MORE-DATA                                
A04460           PERFORM 1020-PROCESS-BILL-IMM-DEPOSITS THRU 1020-EXIT  
A04460           PERFORM 7016-FETCH-MAIN3-ACCT-CSR      THRU 7016-EXIT  
A04460        END-PERFORM                                               
A04460        PERFORM 7017-CLOSE-MAIN3-ACCT-CSR THRU 7017-EXIT          
A04460     END-IF.                                                      
      *                                                                 06860000
           STOP RUN.                                                    
      *                                                                 06950000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06980000
      ******************************************************************06990000
      *   0100-INITIALIZATION                                          *07000000
      *        COMMON INITIALIZATION ROUTINE                           *07010000
      ******************************************************************07020000
       0100-INITIALIZATION.                                             
      *                                                                 07040000
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT        
               MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE               
           END-IF.                                                      
      *                                                                 07290000
           MOVE WS-INPUT-DATE TO WS-HOLD-DATE                           
ACT239                           I-BATCH-DATE.                          
      *                                                                 07310000
      ** GET THE NEXT BUSINESS DAY ****************                     07320000
           MOVE WS-INPUT-DATE TO WS-NEW-BUSINESS-DAY.                   
           PERFORM 6500-GET-NEXT-BUSINESS-DAY THRU                      
                                            6500-NEXT-BUSINESS-DAY-EXIT.
           MOVE WS-NEW-BUSINESS-DAY TO WS-NEXT-DAY.                     
      *                                                                 07370000
      ******************************************************************07380000
      *   CHECK CSS_DELINQUENCY TABLE FOR CURRENT DATABASE - CSR/SEB   *07390000
      ******************************************************************07400000
      * TO IDENTIFY THE DATA BASE                                       07410000
           MOVE ZERO       TO WS-DATABASE.                              
           MOVE '01'       TO C8-COMPANY-NO.                            
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 7475-SELECT-DELINQ-VALUE THRU 7475-EXIT.             
           MOVE C8-DELINQ-VALUE TO WS-CWS350-DATABASE                   
                                   WS-DATABASES.                        
      *                                                                 07470000
ACT248* TO GET THE NOTICE LIMIT                                         07410000
ACT248     MOVE ZERO               TO WS-NOTICE-LIMIT-CO01.             
ACT248     MOVE '01'               TO C8-COMPANY-NO.                    
ACT248     MOVE 'AMT-DEPDNPLIM'    TO C8-DELINQ-CD.                     
ACT248     PERFORM 7475-SELECT-DELINQ-VALUE THRU 7475-EXIT.             
ACT248     MOVE C8-DELINQ-VALUE TO WS-NOTICE-LIMIT-CO01                 
ACT248*                                                                 07470000
ACT248     IF CSR-DATABASE                                              
ACT248        MOVE ZERO            TO WS-NOTICE-LIMIT-CO26              
ACT248        MOVE '26'            TO C8-COMPANY-NO                     
ACT248        MOVE 'AMT-DEPDNPLIM' TO C8-DELINQ-CD                      
ACT248        PERFORM 7475-SELECT-DELINQ-VALUE THRU 7475-EXIT           
ACT248        MOVE C8-DELINQ-VALUE TO WS-NOTICE-LIMIT-CO26              
ACT248     END-IF.                                                      
ACT248*                                                                 07470000
           MOVE 1 TO WS-RECS-TO-COMMIT-COUNT.                           
           PERFORM 0115-GET-COMMIT-NBR-COUNT THRU 0115-EXIT.            
      *                                                                 07500000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07530000
      ******************************************************************07540000
      * 0115-GET-COMMIT-NBR-COUNT.                                     *07550000
      * GET THE COMMIT NBR COUNT FROM JOB PARM TABLE                   *07560000
      ******************************************************************07570000
       0115-GET-COMMIT-NBR-COUNT.                                       
      *                                                                 07590000
           MOVE  WS-PGRMNAME               TO WS-PROGRAM.               
           MOVE  WS-PARM                   TO WS-COMMAND.               
           MOVE  ZEROS                     TO WS-SEQUENCE.              
           MOVE  SPACES                    TO WS-SYSIPT.                
           MOVE  WS-KEY-AREA               TO E-FJC01-KEY.              
      *                                                                 07650000
           PERFORM 7600-START-FCSJC01      THRU  7600-EXIT.             
           PERFORM 7610-READ-FCSJC01       THRU  7610-EXIT              
              UNTIL (COMMIT-ROW-CNT AND INPUT-ACTIVE)                   
              OR  END-OF-SYSIPT.                                        
      *                                                                 07700000
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '** ' WS-PGRMNAME ' PROCESSING WARNING  **'       
              DISPLAY '**  COMMIT-ROW-CNT PARM NOT ACTIVE     **'       
              DISPLAY '**  DEFAULT OF 100 WILL BE USED  **'             
              DISPLAY '**  PROCESSING CONTINUING        **'             
              MOVE 100 TO WS-READY-TO-COMMIT-COUNT                      
           ELSE                                                         
              IF WS-NO-OF-ROWS-TO-COMMIT NUMERIC                        
                 MOVE WS-NO-OF-ROWS-TO-COMMIT                           
                                         TO WS-READY-TO-COMMIT-COUNT    
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY '**  ' WS-PGRMNAME ' PROCESSING WARNING  **'   
                 DISPLAY '**  COMMIT-ROW-CNT PARM NOT NUMERIC  **'      
                 DISPLAY '**  DEFAULT OF 100 WILL BE USED  **'          
                 DISPLAY '**  PROCESSING CONTINUING        **'          
                 MOVE 100 TO WS-READY-TO-COMMIT-COUNT                   
              END-IF                                                    
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           END-IF.                                                      
      *                                                                 07920000
       0115-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07950000
      ******************************************************************07960000
      *   1000-PROCESS-SELTD-ACCT                                      *08020000
      ******************************************************************08030000
       1000-PROCESS-SELTD-ACCT.                                         
      *                                                                 08050000
           INITIALIZE WS-BALANCE-DUE                                    
                      WS-RETURN-CHECK-AMT                               
                      CL-AMT-NOTICE                                     
                      WS-COMMENTS                                       
                      WS-AUTO-DEP-CHARGED                               
                      CZ-AUTO-DEP-AM                                    
P0599F                WS-FRCSTED-AUTO-DEP                               
                      WS-DO-DEPOSIT-AMT                                 
ACT210                WS-TRAN-APPL-NO                                   
ACT210                WS-REASON-NOT-DNP.                                
      *                                                                 08200000
           INITIALIZE WS-CORRESP-HDR                                    
                      WS-CORRESP-NOTICE                                 
                      WS-CORRESP-VAR                                    
                      WS-MISC-PROCESSING-VARS                           
                      WS-KR125-COMM-DATA-VARS                           
                      WS-KR125-MNT-TRANS-VARS.                          
      *                                                                         
A05323     IF AT-ACCOUNT-NO  = WS-PREV-ACCT-NO-WRKD                     
A05323        CONTINUE                                                  
A05323     ELSE                                                         
A05323        MOVE 'N' TO WS-1450-RET-CHECK-PROCESS                     
A05323     END-IF.                                                      
                                                                        
           MOVE AT-ACCOUNT-NO TO WS-ACCOUNT-NO.                         
           PERFORM 5200-CHK-SKIP-ACCTS THRU 5200-CPD347-EXIT.           
      *                                                                 08230000
           IF PROCESS-ACCT                                              
              CONTINUE                                                  
           ELSE                                                         
              GO TO 1000-EXIT                                           
           END-IF.                                                      
      *                                                                 08290000
           IF AT-COMPANY-NO NOT = WS-HOLD-COMPANY                       
              MOVE AT-COMPANY-NO TO WS-HOLD-COMPANY                     
           END-IF.                                                      
      *                                                                 08330000
           MOVE AT-ACCOUNT-NO TO CL-ACCOUNT-NO                          
                                 CZ-ACCOUNT-NO                          
                                 GU-ACCOUNT-NO                          
                                 NH-ACCOUNT-NO                          
                                 ZW-ACCOUNT-NO                          
                                 I-ACCOUNT-NO.                          
      *                                                                 08400000
ACT239     DISPLAY ' 1000 PARAGRAPH - ACCOUNT NO: ' AT-ACCOUNT-NO       
ACT239*                                                                 08400000
           MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
           PERFORM 1200-NOTICE-SETUP THRU 1200-EXIT.                    
      *                                                                 08430000
           ADD 1 TO WS-RECS-TO-COMMIT-COUNT.                            
           IF WS-RECS-TO-COMMIT-COUNT = WS-READY-TO-COMMIT-COUNT        
               PERFORM 8850-COMMIT-DB2-UPDATES THRU 8850-EXIT           
           END-IF.                                                      
      *                                                                 08480000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08510000
      ******************************************************************08520000
      *   1010-PROCESS-SELTD-FB-ACCT                                   *08530000
      ******************************************************************08540000
       1010-PROCESS-SELTD-FB-ACCT.                                      
      *                                                                 08560000
           INITIALIZE WS-BALANCE-DUE                                    
                      WS-RETURN-CHECK-AMT                               
                      CL-AMT-NOTICE                                     
                      WS-COMMENTS                                       
                      WS-AUTO-DEP-CHARGED                               
                      CZ-AUTO-DEP-AM                                    
P0599F                WS-FRCSTED-AUTO-DEP                               
                      WS-DO-DEPOSIT-AMT                                 
                      WS-TRAN-APPL-NO                                   
ACT210                WS-REASON-NOT-DNP.                                
      *                                                                         
           INITIALIZE WS-CORRESP-HDR                                    
                      WS-CORRESP-NOTICE                                 
                      WS-CORRESP-VAR                                    
                      WS-MISC-PROCESSING-VARS                           
                      WS-KR125-COMM-DATA-VARS                           
                      WS-KR125-MNT-TRANS-VARS.                          
      *                                                                 08710000
           MOVE AT-ACCOUNT-NO TO WS-ACCOUNT-NO.                         
           PERFORM 5200-CHK-SKIP-ACCTS THRU 5200-CPD347-EXIT.           
      *                                                                 08740000
           IF PROCESS-ACCT                                              
              CONTINUE                                                  
           ELSE                                                         
              GO TO 1010-EXIT                                           
           END-IF.                                                      
      *                                                                 08800000
           IF AT-COMPANY-NO NOT = WS-HOLD-COMPANY                       
              MOVE AT-COMPANY-NO TO WS-HOLD-COMPANY                     
           END-IF.                                                      
      *                                                                 08840000
           MOVE AT-ACCOUNT-NO TO CL-ACCOUNT-NO                          
                                 CZ-ACCOUNT-NO                          
                                 GU-ACCOUNT-NO                          
                                 NH-ACCOUNT-NO                          
                                 ZW-ACCOUNT-NO                          
                                 I-ACCOUNT-NO.                          
      *                                                                 08910000
ACT239     DISPLAY ' 1010 PARAGRAPH - ACCOUNT NO: ' AT-ACCOUNT-NO       
ACT239*                                                                 08400000
           MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
      *                                                                 08930000
           PERFORM 2000-GET-CRED-PROFILE THRU 2000-EXIT.                
           MOVE WS-NEXT-DAY TO WS-CL-DATE-NOTICE-DUE                    
                               WS-CL-DATE-NOTICE-MAIL                   
                               WS-CL-DATE-CREDIT-ACTION.                
           PERFORM 3200-CALC-AMOUNTS-DATES THRU 3200-EXIT.              
           MOVE 'Y' TO WS-NOTICE-READY.                                 
      *                                                                 09000000
           IF AT-BANKRUPTCY-IND = WS-B OR AT-JUDGEMENT-CASE-NO > SPACES 
              PERFORM 1210-PROCESS-BKRPT-JDGMNT THRU 1210-EXIT          
           ELSE                                                         
              IF AT-NOTICE-EXEMPT-CD > SPACES                           
                 PERFORM 1220-CK-EXEMPTNS THRU 1220-EXIT                
              END-IF                                                    
           END-IF.                                                      
      *                                                                 09080000
           IF WS-NOTICE-READY = 'Y' AND SEB-DATABASE                    
              PERFORM 7640-CHECK-REGULATED THRU 7640-EXIT               
           END-IF.                                                      
      *                                                                 09120000
           IF WS-NOTICE-READY = 'Y'                                     
                 PERFORM 1450-RETURNED-CHECK THRU 1450-EXIT             
           END-IF.                                                      
      *                                                                 09170000
           ADD 1 TO WS-RECS-TO-COMMIT-COUNT.                            
           IF WS-RECS-TO-COMMIT-COUNT = WS-READY-TO-COMMIT-COUNT        
               PERFORM 8850-COMMIT-DB2-UPDATES THRU 8850-EXIT           
           END-IF.                                                      
      *                                                                 09220000
       1010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09250000
A04460******************************************************************        
A04460*   1020-PROCESS-BILL-IMMEDIATE-DEPOSITS                         *        
A04460******************************************************************        
A04460 1020-PROCESS-BILL-IMM-DEPOSITS.                                  
A04460*                                                                         
A04460     INITIALIZE WS-BALANCE-DUE                                    
A04460                WS-RETURN-CHECK-AMT                               
A04460                CL-AMT-NOTICE                                     
A04460                WS-COMMENTS                                       
A04460                WS-AUTO-DEP-CHARGED                               
A04460                CZ-AUTO-DEP-AM                                    
P0599F                WS-FRCSTED-AUTO-DEP                               
A04460                WS-DO-DEPOSIT-AMT                                 
                      WS-TRAN-APPL-NO                                   
ACT210                WS-REASON-NOT-DNP.                                
A04460*                                                                         
A04460     INITIALIZE WS-CORRESP-HDR                                    
A04460                WS-CORRESP-NOTICE                                 
A04460                WS-CORRESP-VAR                                    
A04460                WS-MISC-PROCESSING-VARS                           
A04460                WS-KR125-COMM-DATA-VARS                           
A04460                WS-KR125-MNT-TRANS-VARS.                          
A04460*                                                                         
A04460     INITIALIZE WS-AMT-00-DAY-DEP                                 
A04460                WS-AMT-30-DAY-DEP                                 
A04460                WS-AMT-60-DAY-DEP                                 
A04460                WS-AMT-90-DAY-DEP.                                
A04460*                                                                         
A04460     MOVE AT-ACCOUNT-NO TO WS-ACCOUNT-NO.                         
A04460     PERFORM 5200-CHK-SKIP-ACCTS THRU 5200-CPD347-EXIT.           
A04460*                                                                         
A04460     IF PROCESS-ACCT                                              
A04460        CONTINUE                                                  
A04460     ELSE                                                         
A04460        GO TO 1020-EXIT                                           
A04460     END-IF.                                                      
A04460*                                                                         
A04460     IF AT-COMPANY-NO NOT = WS-HOLD-COMPANY                       
A04460        MOVE AT-COMPANY-NO TO WS-HOLD-COMPANY                     
A04460     END-IF.                                                      
A04460*                                                                         
A04460     MOVE AT-ACCOUNT-NO TO CL-ACCOUNT-NO                          
A04460                           CZ-ACCOUNT-NO                          
A04460                           GU-ACCOUNT-NO                          
A04460                           NH-ACCOUNT-NO                          
A04460                           ZW-ACCOUNT-NO                          
A04460                           I-ACCOUNT-NO                           
A04460                           AC-ACCOUNT-NO.                         
A04460*                                                                         
ACT239     DISPLAY ' 1020 PARAGRAPH - ACCOUNT NO: ' AT-ACCOUNT-NO       
ACT239*                                                                 08400000
A04460     MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
A04460*                                                                         
A04460     PERFORM 2000-GET-CRED-PROFILE THRU 2000-EXIT.                
A04460*                                                                         
A04460     IF AT-TOTAL-AR-BALANCE > 0                                   
A04460        MOVE 'Y' TO WS-NOTICE-READY                               
A04460        MOVE CL-CODE-SPECIAL-TYPE TO WS-CODE-SPECIAL-TYPE-O       
A04460        MOVE CL-DATE-NOTICE-MAIL  TO WS-DATE-NOTICE-MAIL-O        
A04460        MOVE CL-DATE-NOTICE-DUE   TO WS-DATE-NOTICE-DUE-O         
A04460        MOVE CL-ITEM-ID           TO WS-ITEM-ID-O                 
A04460                                     AC-ITEM-ID                   
A04460        PERFORM 7500-LOAD-DEPOSIT-AMTS THRU 7500-EXIT             
A04460        PERFORM 1475-BILL-DEP-NOTICE THRU 1475-EXIT               
A04460     ELSE                                                         
A04460        PERFORM 3040-DEL-NOTICE-GET-DNP-TYP THRU 3040-EXIT        
A04460     END-IF.                                                      
A04460*                                                                         
A04460     ADD 1 TO WS-RECS-TO-COMMIT-COUNT.                            
A04460     IF WS-RECS-TO-COMMIT-COUNT = WS-READY-TO-COMMIT-COUNT        
A04460         PERFORM 8850-COMMIT-DB2-UPDATES THRU 8850-EXIT           
A04460     END-IF.                                                      
A04460*                                                                         
A04460 1020-EXIT.                                                       
A04460     EXIT.                                                        
      *                                                                         
      ******************************************************************09260000
      *   1200-NOTICE-SETUP                                            *09270000
      *   PROCESSES NOTICES ON ACTIVE ACCOUNTS.                        *09280000
A05323*   IF DATE-NOTICE-MAIL-C AND DATE-NOTICE-MAIL-N = WS-NEXT-DAY   *        
A05323*   THEY BOTH SHOULD BE PROCESSED.                               *        
A05323*   IF DATE-NOTICE-MAIL-F AND DATE-NOTICE-MAIL-N = WS-NEXT-DAY   *        
A05323*   THEY BOTH SHOULD BE PROCESSED.                               *        
      ******************************************************************09290000
       1200-NOTICE-SETUP.                                               
      *                                                                 09310000
           IF CL-CODE-NOTICE-TYPE = 'N'                                 
P0599I        IF CL-ACCOUNT-NO = WS-PREV-ACCT-NO-WRKD                   
P0599I           PERFORM 7900-SELECT-GET-PROCESSED-CD THRU 7900-EXIT    
P0599I           IF WS-PROCESSED-CD = 'N'                               
P0599I              GO TO 1200-EXIT                                     
P0599I           ELSE                                                   
A05323              IF 1450-RET-CHECK-PROCESSED                         
A05323                 GO TO 1200-EXIT                                  
A05323              END-IF                                              
A05323           END-IF                                                 
P0599K        ELSE                                                      
P0599K           MOVE 'N' TO WS-DONE-CASH-ONLY-NOTICE                   
              END-IF                                                    
           END-IF.                                                      
P0599E     MOVE CL-ACCOUNT-NO TO WS-PREV-ACCT-NO.                       
      *                                                                 09380000
           PERFORM 2000-GET-CRED-PROFILE THRU 2000-EXIT.                
           MOVE WS-NEXT-DAY TO WS-CL-DATE-NOTICE-DUE                    
                               WS-CL-DATE-NOTICE-MAIL                   
                               WS-CL-DATE-CREDIT-ACTION.                
           PERFORM 3200-CALC-AMOUNTS-DATES THRU 3200-EXIT.              
           MOVE 'Y' TO WS-NOTICE-READY.                                 
      *                                                                 09450000
           IF AT-BANKRUPTCY-IND = WS-B OR AT-JUDGEMENT-CASE-NO > SPACES 
              PERFORM 1210-PROCESS-BKRPT-JDGMNT THRU 1210-EXIT          
           ELSE                                                         
              IF AT-NOTICE-EXEMPT-CD > SPACES                           
                 PERFORM 1220-CK-EXEMPTNS THRU 1220-EXIT                
              END-IF                                                    
           END-IF.                                                      
      *                                                                 09530000
           IF WS-NOTICE-READY = 'Y' AND SEB-DATABASE                    
              PERFORM 7640-CHECK-REGULATED THRU 7640-EXIT               
           END-IF.                                                      
      *                                                                 09570000
           IF WS-NOTICE-READY = 'Y'                                     
              EVALUATE WS-NEXT-DAY                                      
                 WHEN WS-DATE-NOTICE-MAIL-C                             
                    PERFORM 1420-2ND-NORMAL-NOTICE THRU 1420-EXIT       
A05323              IF WS-DATE-NOTICE-MAIL-N = WS-NEXT-DAY              
A05323                 PERFORM 1450-RETURNED-CHECK THRU 1450-EXIT       
A05323              END-IF                                              
                 WHEN WS-DATE-NOTICE-MAIL-E                             
                    PERFORM 1430-1ST-SPECIAL-NOTICE THRU 1430-EXIT      
                 WHEN WS-DATE-NOTICE-MAIL-F                             
                    PERFORM 1440-2ND-SPECIAL-NOTICE THRU 1440-EXIT      
A05323              IF WS-DATE-NOTICE-MAIL-N = WS-NEXT-DAY              
A05323                 PERFORM 1450-RETURNED-CHECK THRU 1450-EXIT       
A05323              END-IF                                              
                 WHEN WS-DATE-NOTICE-MAIL-O                             
                    PERFORM 1475-BILL-DEP-NOTICE THRU 1475-EXIT         
                 WHEN WS-DATE-NOTICE-MAIL-N                             
                    PERFORM 1450-RETURNED-CHECK THRU 1450-EXIT          
P0599E           WHEN OTHER                                             
P0599E              IF CL-DATE-NOTICE-MAIL = WS-NEXT-DAY                
P0599E              AND CL-CODE-NOTICE-TYPE = 'N'                       
P0599E                  PERFORM 1450-RETURNED-CHECK THRU 1450-EXIT      
P0599E              END-IF                                              
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                 09730000
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09760000
      ******************************************************************09770000
      *   1210-PROCESS-BKRPT-JDGMNT                                    *09780000
      *   PROCESSES BANKRUPT OR JUDGEMENT ACTIVE ACCOUNTS.             *09790000
      ******************************************************************09800000
       1210-PROCESS-BKRPT-JDGMNT.                                       
      *                                                                 09820000
           MOVE SPACES TO CL-CODE-NOTICE-TYPE.                          
           EVALUATE WS-NEXT-DAY                                         
              WHEN WS-DATE-NOTICE-MAIL-C                                
                 MOVE WS-C TO CL-CODE-NOTICE-TYPE                       
              WHEN WS-DATE-NOTICE-MAIL-F                                
                 MOVE WS-F TO CL-CODE-NOTICE-TYPE                       
              WHEN WS-DATE-NOTICE-MAIL-N                                
                 MOVE WS-N TO CL-CODE-NOTICE-TYPE                       
              WHEN WS-DATE-NOTICE-MAIL-O                                
                 MOVE WS-O TO CL-CODE-NOTICE-TYPE                       
              WHEN WS-DATE-NOTICE-MAIL-E                                
                 MOVE WS-E TO CL-CODE-NOTICE-TYPE                       
           END-EVALUATE.                                                
      *                                                                 09960000
           IF AT-BANKRUPTCY-IND = WS-B                                  
              MOVE WS-BANKRUPTCY TO WS-DNP-COMMENT                      
           ELSE                                                         
              IF AT-JUDGEMENT-CASE-NO > SPACES                          
                 MOVE WS-JUDGMENT TO WS-DNP-COMMENT                     
              END-IF                                                    
           END-IF.                                                      
           PERFORM 2200-PROCESS-DISC-HIST-PLUS THRU 2200-EXIT.          
ACT210     MOVE 'N' TO WS-REASON-NOT-DNP.                               
           PERFORM 3040-DEL-NOTICE-GET-DNP-TYP THRU 3040-EXIT.          
           MOVE 'N' TO WS-NOTICE-READY.                                 
      *                                                                 10080000
       1210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10110000
      ******************************************************************10120000
      *   1220-CK-EXEMPTNS                                             *10130000
      *   CHECKS FOR EXEMTIONS ON ACTIVE ACCOUNT.                      *10140000
      ******************************************************************10150000
       1220-CK-EXEMPTNS.                                                
      *                                                                 10170000
           EVALUATE WS-NEXT-DAY                                         
              WHEN WS-DATE-NOTICE-MAIL-C                                
                 IF AT-NOTICE-EXEMPT-CD NOT EQUAL WS-B                  
                    MOVE WS-DNP-EXEMPTION TO WS-DNP-COMMENT             
                    MOVE 'C' TO CL-CODE-NOTICE-TYPE                     
                    PERFORM 2200-PROCESS-DISC-HIST-PLUS THRU 2200-EXIT  
ACT210              MOVE 'N' TO WS-REASON-NOT-DNP                       
                    PERFORM 3040-DEL-NOTICE-GET-DNP-TYP THRU 3040-EXIT  
                    MOVE 'N' TO WS-NOTICE-READY                         
                 END-IF                                                 
              WHEN WS-DATE-NOTICE-MAIL-E                                
              WHEN WS-DATE-NOTICE-MAIL-F                                
              WHEN WS-DATE-NOTICE-MAIL-N                                
                 IF AT-NOTICE-EXEMPT-CD NOT EQUAL WS-A                  
                    MOVE WS-DNP-EXEMPTION TO WS-DNP-COMMENT             
                    PERFORM 2200-PROCESS-DISC-HIST-PLUS THRU 2200-EXIT  
                    IF WS-DATE-NOTICE-MAIL-E = WS-NEXT-DAY              
                        MOVE 'E' TO CL-CODE-NOTICE-TYPE                 
                    END-IF                                              
                    IF WS-DATE-NOTICE-MAIL-F = WS-NEXT-DAY              
                        MOVE 'F' TO CL-CODE-NOTICE-TYPE                 
                    END-IF                                              
                    IF (WS-DATE-NOTICE-MAIL-N = WS-NEXT-DAY)            
                       AND (WS-DATE-NOTICE-MAIL-F NOT                   
                       EQUAL WS-NEXT-DAY)                               
                       MOVE 'N' TO CL-CODE-NOTICE-TYPE                  
                    END-IF                                              
ACT210              MOVE 'N' TO WS-REASON-NOT-DNP                       
                    PERFORM 3040-DEL-NOTICE-GET-DNP-TYP THRU 3040-EXIT  
                    MOVE 'N' TO WS-NOTICE-READY                         
                 END-IF                                                 
           END-EVALUATE.                                                
      *                                                                 10502005
       1220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10530000
      ******************************************************************10540000
      **  1350-CALL-AUTO-DEP-SP                                       **10550000
      ******************************************************************10560000
       1350-CALL-AUTO-DEP-SP.                                           
      *                                                                 10580000
           MOVE '1350' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 10600000
           IF CL-CODE-NOTICE-TYPE = 'O'                                 
             OR CL-CODE-SPECIAL-TYPE = 'S'                              
             OR CL-CODE-SPECIAL-TYPE = 'D'                              
             OR CL-CODE-SPECIAL-TYPE = 'M'                              
              MOVE 0 TO CZ-AUTO-DEP-AM                                  
P0599F                  WS-FRCSTED-AUTO-DEP                             
              GO TO 1350-EXIT                                           
           END-IF.                                                      
      *                                                                 10690000
           INITIALIZE GTT-RETURN-FIELDS.                                
      *                                                                 10710000
           MOVE 100 TO S-RETURN-CODE.                                   
      *    EXEC SQL CALL CSR03515                                       
      *                ( :I-ACCOUNT-NO                                  
      *                 ,:I-CALLING-PGM                                 
      *                 ,:I-AUTO-DEP-TYPE                               
      *                 ,:I-DL-AUTO-DEP-AMT                             
      *                 ,:I-USER-ID                                     
      *                 ,:I-ERROR-SW                                    
ACT239*                 ,:I-BATCH-DATE                                  
      *                )                                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE C1
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C1
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C1 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
           IF SQLCODE = +466 THEN                                       
      *       EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE         
      *         CSR03515                                                
      *       END-EXEC                                                  
      *       EXEC SQL ALLOCATE C1 CURSOR FOR RESULT SET :LOC1          
      *       END-EXEC                                                  
              EXEC SQL                                                  
              FETCH C1 INTO :S-RETURN-CODE                              
                           ,:S-AUTO-DEP-AMT                             
                           ,:S-DEP-SUCCESS                              
                           ,:S-DEP-CERT-NO                              
                           ,:S-MAX-DEP-ZERO-WQ                          
                           ,:S-AMT-SECURED                              
                           ,:S-ABEND-PROGRAM                            
                           ,:S-ACTIVE-PARAGRAPH                         
                           ,:S-ABEND-FUNCTION                           
                           ,:S-TABLE-1                                  
                           ,:S-TABLE-ELEMENT-1                          
                           ,:S-HOSTVAR-ELEMENT-1                        
                           ,:S-TABLE-ELEMENT-2                          
                           ,:S-HOSTVAR-ELEMENT-2                        
                           ,:S-TABLE-ELEMENT-3                          
                           ,:S-HOSTVAR-ELEMENT-3                        
                           ,:S-TABLE-ELEMENT-4                          
                           ,:S-HOSTVAR-ELEMENT-4                        
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              EXEC SQL                                                  
                  CLOSE C1                                              
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           END-IF.                                                      
      *                                                                 11120000
           IF S-RETURN-CODE NOT EQUAL 0                                 
              IF S-RETURN-CODE EQUAL 100                                
                 MOVE 0                    TO CZ-AUTO-DEP-AM            
P0599F                                        WS-FRCSTED-AUTO-DEP       
              ELSE                                                      
                 MOVE SPACES               TO ABEND-TABLES              
                 MOVE SPACES               TO ABEND-SQL-PREDICATES      
                 MOVE S-RETURN-CODE        TO RS-RETURN-CODE            
                 MOVE WS-ACTIVE-PARAGRAPH  TO ACTIVE-PARAGRAPH          
                 MOVE S-ABEND-PROGRAM      TO ABEND-PROGRAM             
                 MOVE S-ABEND-FUNCTION     TO ABEND-FUNCTION            
                 MOVE S-TABLE-1            TO TABLE-1                   
                 MOVE S-TABLE-ELEMENT-1    TO TABLE-ELEMENT-1           
                 MOVE S-TABLE-ELEMENT-2    TO TABLE-ELEMENT-2           
                 MOVE S-TABLE-ELEMENT-3    TO TABLE-ELEMENT-3           
                 MOVE S-TABLE-ELEMENT-4    TO TABLE-ELEMENT-4           
                 MOVE S-HOSTVAR-ELEMENT-1  TO HOSTVAR-ELEMENT-1         
                 MOVE S-HOSTVAR-ELEMENT-2  TO HOSTVAR-ELEMENT-2         
                 MOVE S-HOSTVAR-ELEMENT-3  TO HOSTVAR-ELEMENT-3         
                 MOVE S-HOSTVAR-ELEMENT-4  TO HOSTVAR-ELEMENT-4         
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           ELSE                                                         
              MOVE S-AUTO-DEP-AMT TO CZ-AUTO-DEP-AM                     
P0599F                               WS-FRCSTED-AUTO-DEP                
           END-IF.                                                      
      *                                                                 11390000
           IF S-MAX-DEP-ZERO-WQ = 'Y'                                   
              MOVE 355                      TO WS-WQ-CATEGORY           
              MOVE S-AUTO-DEP-AMT           TO WS-WQ-FRCSTED-AMT        
              MOVE S-AMT-SECURED            TO WS-WQ-AMT-SECURED        
              MOVE WS-WQ-AUTO-DEP           TO WS-COMMENTS-TEXT         
              MOVE LENGTH OF WS-WQ-AUTO-DEP TO WS-COMMENTS-LEN          
              PERFORM 1408-CHECK-WQ-GEN THRU 1408-EXIT                  
           END-IF.                                                      
      *                                                                 11480000
       1350-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11580000
      ******************************************************************11590000
      * 1408-CHECK-WQ-GEN                                              *11600000
      ******************************************************************11610000
       1408-CHECK-WQ-GEN.                                               
      *                                                                 11630000
           IF SEB-DATABASE                                              
              PERFORM 7640-CHECK-REGULATED THRU 7640-EXIT               
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE LR-REG-GROUP-CD TO WS-REG-GRP-CD                  
                 MOVE LR-SENIOR-FL TO WS-SEN-FL                         
              ELSE                                                      
                 MOVE SPACES TO WS-REG-GRP-CD                           
                 MOVE SPACES TO WS-SEN-FL                               
              END-IF                                                    
           END-IF.                                                      
      *                                                                 11740000
           MOVE AT-COMPANY-NO  TO WS-COMP-NO.                           
           MOVE WS-WQ-CATEGORY TO WS-CATEGORY-ID.                       
           MOVE WS-PGRMNAME    TO WS-SRCE-PGM-ID.                       
           PERFORM 4900-GET-WQ-GEN-FL THRU 4900-CPD346-EXIT.            
           IF FL-NOT-FOUND AND SEB-DATABASE                             
              MOVE SPACES TO WS-REG-GRP-CD                              
              PERFORM 4900-GET-WQ-GEN-FL THRU 4900-CPD346-EXIT          
           END-IF.                                                      
           IF WS-WQ-GEN-FL = 'Y' OR FL-NOT-FOUND                        
              PERFORM 1409-CREATE-WORK-QUEUE THRU 1409-EXIT             
           END-IF.                                                      
      *                                                                 11860000
       1408-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11890000
      ******************************************************************11900000
      * 1409-CREATE-WORK-QUEUE                                         *11910000
      ******************************************************************11920000
       1409-CREATE-WORK-QUEUE.                                          
      *                                                                 11940000
ACT030     INITIALIZE CWS00077-FIELDS.                                  
ACT030     INITIALIZE WS-77-COMMENTS.                                   
      *                                                                 11970000
ACT030     MOVE AT-ACCOUNT-NO    TO WS-77-ACCOUNT-NO.                   
ACT030     MOVE AT-CUSTOMER-NO   TO WS-77-CUSTOMER-NO.                  
ACT030     MOVE AT-PREMISE-NO    TO WS-77-PREMISE-NO.                   
ACT030     MOVE AT-LOCAL-OFFICE  TO WS-77-LOCAL-OFFICE                  
                                    WS-CWS350-LOCAL-OFFICE.             
ACT030     MOVE WS-WQ-CATEGORY   TO WS-77-CATEGORY-ID.                  
ACT030     MOVE WS-COMMENTS-TEXT TO WS-77-COMMENTS-TEXT.                
ACT030     MOVE WS-COMMENTS-LEN  TO WS-77-COMMENTS-LEN.                 
ACT030     MOVE 4                TO WS-77-ROUTE-CATEGORY.               
ACT030     MOVE WS-N             TO WS-77-PRIORITY.                     
ACT030     MOVE WS-INPUT-DATE    TO WS-INPUT-DATE-26(1:10).             
ACT030     MOVE WS-INPUT-ZERO    TO WS-INPUT-DATE-26(11:16).            
ACT030     MOVE WS-INPUT-DATE-26 TO WS-77-DATE-CREATED.                 
ACT030     MOVE WS-NEXT-DAY      TO WS-77-DATE-REQUIRED.                
ACT030     MOVE WS-PGRMNAME      TO WS-77-CREATED-BY.                   
      *                                                                 12100000
           PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.               
                                                                        
       1409-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12150000
      ******************************************************************12160000
      * 1420-2ND-NORMAL-NOTICE                                         *12170000
      * THIS MODULE EVALUATES WHICH NORMAL SECOND NOTICE TO SEND.      *12180000
      * OPTIONS INCLUDE : 90106/80106 (SECOND NORMAL NOTICE),          *12190000
      * 90107/80107 (SECOND NORMAL NOTICE WITH RETURNED CHECK), AND    *12200000
      * 90109 (GUARANTOR NOTICE).                                      *12210000
A05323* REMOVE RETURNED CHECK MERGE LOGIC.                             *        
      ******************************************************************12220000
       1420-2ND-NORMAL-NOTICE.                                          
      *                                                                 12240000
           MOVE WS-C                   TO CL-CODE-NOTICE-TYPE.          
           MOVE WS-AMT-NOTICE-C        TO WS-BALANCE-DUE.               
           MOVE WS-CODE-SPECIAL-TYPE-C TO CL-CODE-SPECIAL-TYPE.         
           IF WS-CODE-MEDICAL = WS-A                                    
               MOVE WS-ACTIVE-MED-CERT TO WS-DNP-COMMENT                
               PERFORM 2200-PROCESS-DISC-HIST-PLUS THRU 2200-EXIT       
ACT210         MOVE 'N' TO WS-REASON-NOT-DNP                            
               PERFORM 3040-DEL-NOTICE-GET-DNP-TYP THRU 3040-EXIT       
               GO TO 1420-EXIT                                          
           END-IF.                                                      
      *                                                                 12350000
           IF WS-BALANCE-DUE EQUAL ZEROES                               
               PERFORM 3040-DEL-NOTICE-GET-DNP-TYP THRU 3040-EXIT       
               GO TO 1420-EXIT                                          
           END-IF.                                                      
      *                                                                 12400000
A05323     IF WS-DATE-NOTICE-MAIL-S > SPACES AND WS-AMT-NOTICE-S > 0    
              MOVE 80106 TO CL-CODE-MESSAGE-TYPE                        
           ELSE                                                         
              MOVE 90106 TO CL-CODE-MESSAGE-TYPE                        
           END-IF.                                                      
      *                                                                 12580000
           MOVE WS-C                     TO CL-CODE-NOTICE-TYPE.        
           MOVE WS-BALANCE-DUE           TO CL-AMT-NOTICE.              
           MOVE WS-BALANCE-DUE           TO WS-AMT-NOTICE.              
           MOVE WS-DATE-NOTICE-MAIL-C    TO WS-DATE-NOTICE-MAIL.        
           MOVE WS-DATE-NOTICE-DUE-C     TO WS-DATE-NOTICE-DUE.         
           MOVE WS-ITEM-ID-C             TO CL-ITEM-ID.                 
           PERFORM 8530-UPDATE-CRED-COLL THRU 8530-EXIT.                
      *                                                                 12660000
           IF WS-DATE-NOTICE-MAIL-S > SPACES AND WS-AMT-NOTICE-S > 0    
              MOVE WS-S TO CL-CODE-NOTICE-TYPE                          
              MOVE WS-AMT-NOTICE-S TO CL-AMT-NOTICE                     
              PERFORM 8530-UPDATE-CRED-COLL THRU 8530-EXIT              
              MOVE '2' TO WS-NON-UTL-CR-HST (1:1)                       
           END-IF.                                                      
      *                                                                 12730000
           MOVE '2' TO WS-NEW-DISC-HIST-X (1:1).                        
           IF CSR-DATABASE AND WS-AUTO-DEP-CHARGED = 0                  
              PERFORM 1350-CALL-AUTO-DEP-SP THRU  1350-EXIT             
           END-IF                                                       
      *                                                                 12780000
           IF CSR-DATABASE                                              
              IF WS-CODE-PENDING-DNP = 'A'                              
                 PERFORM 7850-CHECK-SO-UPDT-ACTION-FL THRU 7850-EXIT    
                 IF DNP-CANCEL-ROW-EXISTS                               
                    IF XK-SO-UPDT-ACTION-FL = 'U'                       
                       PERFORM 8750-UPD-SO-DNP-ACTION-FL THRU 8750-EXIT 
                    END-IF                                              
                    MOVE 'N' TO WS-SO-DNP-CANCEL-ROW                    
                 ELSE                                                   
                    PERFORM 8760-INS-SO-DNP-CANCEL-ROW THRU 8760-EXIT   
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                 12920000
           PERFORM 1500-CREATE-NOTICE THRU 1500-EXIT.                   
      *                                                                 12940000
A05323     IF WS-DATE-NOTICE-MAIL-C = WS-DATE-NOTICE-MAIL-O             
A05323         MOVE 'O'    TO CL-CODE-NOTICE-TYPE                       
A05323         PERFORM 3040-DEL-NOTICE-GET-DNP-TYP THRU 3040-EXIT       
A05323     END-IF.                                                      
A05323                                                                  
       1420-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13100000
      ******************************************************************13110000
      * 1430-1ST-SPECIAL-NOTICE                                        *13120000
      ******************************************************************13130000
       1430-1ST-SPECIAL-NOTICE.                                         
      *                                                                 13150000
           IF WS-CODE-SPECIAL-TYPE-E EQUAL 'A'                          
              OR WS-CODE-SPECIAL-TYPE-E EQUAL 'B'                       
                 GO TO 1430-EXIT                                        
           END-IF.                                                      
           MOVE WS-E            TO CL-CODE-NOTICE-TYPE.                 
           MOVE WS-AMT-NOTICE-E TO WS-BALANCE-DUE.                      
      *                                                                 13220000
           IF WS-BALANCE-DUE EQUAL ZEROES                               
               MOVE WS-ITEM-ID-E TO CL-ITEM-ID                          
               PERFORM 3040-DEL-NOTICE-GET-DNP-TYP THRU 3040-EXIT       
           ELSE                                                         
              IF (WS-DATE-NOTICE-MAIL-E = WS-DATE-NOTICE-MAIL-B AND     
                  WS-CODE-MESSAGE-TYPE-B = '80110' OR '90110' AND       
                  WS-CODE-MEDICAL = WS-A) OR                            
P00948           (WS-DATE-NOTICE-MAIL-E = WS-DATE-NOTICE-MAIL-A AND     
P00948            WS-CODE-STA-ACCT = WS-A AND                           
P00948            WS-CODE-SPECIAL-TYPE-E = 'Q')                         
                 GO TO 1430-EXIT                                        
              ELSE                                                      
                 IF WS-AMT-NOTICE-T > 0                                 
                    MOVE 80201 TO CL-CODE-MESSAGE-TYPE                  
                 ELSE                                                   
                    MOVE 90201 TO CL-CODE-MESSAGE-TYPE                  
                 END-IF                                                 
              END-IF                                                    
      *                                                                 13380000
              MOVE WS-ITEM-ID-E          TO CL-ITEM-ID                  
              MOVE WS-E                  TO CL-CODE-NOTICE-TYPE         
              MOVE WS-BALANCE-DUE        TO CL-AMT-NOTICE               
              MOVE WS-BALANCE-DUE        TO WS-AMT-NOTICE               
              MOVE WS-DATE-NOTICE-MAIL-E TO WS-DATE-NOTICE-MAIL         
              MOVE WS-DATE-NOTICE-DUE-E  TO WS-DATE-NOTICE-DUE          
      *                                                                 13450000
              PERFORM 8530-UPDATE-CRED-COLL  THRU 8530-EXIT             
      *                                                                 13470000
              IF WS-AMT-NOTICE-T > 0                                    
                 MOVE WS-T TO CL-CODE-NOTICE-TYPE                       
                 MOVE WS-AMT-NOTICE-T TO CL-AMT-NOTICE                  
                 PERFORM 8530-UPDATE-CRED-COLL THRU 8530-EXIT           
                 MOVE '1' TO WS-NON-UTL-CR-HST-EX (1:1)                 
              END-IF                                                    
      *                                                                 13540000
              MOVE '1' TO WS-NEW-DISCEX-HIST-X (1:1)                    
              PERFORM 1500-CREATE-NOTICE THRU 1500-EXIT                 
A05323        IF WS-DATE-NOTICE-MAIL-E = WS-DATE-NOTICE-MAIL-O          
A05323            MOVE 'O'    TO CL-CODE-NOTICE-TYPE                    
A05323            PERFORM 3040-DEL-NOTICE-GET-DNP-TYP THRU 3040-EXIT    
A05323        END-IF                                                    
           END-IF.                                                      
                                                                        
       1430-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13610000
      ******************************************************************13620000
      * VALUES FOR CODE-SPECIAL-TYPE                                   *13630000
      * 'A' = ARREARS                                                  *13640000
      * 'M' = MEDICAL CERT                                             *13650000
      * 'D' = DPP EARNEST                                              *13660000
      * 'S' = SPECIAL                                                  *13670000
      * 'Q' = STA                                                      *13680000
      * 'T' = RESCHEDULED W RET CHECK                                  *13690000
      ******************************************************************13700000
      * 1440-2ND-SPECIAL-NOTICE                                        *13710000
A05323* REMOVED RETURNED CHECK MERGE LOGIC.                            *        
      ******************************************************************13720000
       1440-2ND-SPECIAL-NOTICE.                                         
      *                                                                 13740000
           MOVE WS-F                   TO CL-CODE-NOTICE-TYPE.          
           MOVE WS-AMT-NOTICE-F        TO WS-BALANCE-DUE.               
           MOVE WS-CODE-SPECIAL-TYPE-F TO CL-CODE-SPECIAL-TYPE.         
           IF WS-BALANCE-DUE EQUAL ZEROES                               
              MOVE WS-ITEM-ID-F TO CL-ITEM-ID                           
              PERFORM 3040-DEL-NOTICE-GET-DNP-TYP THRU 3040-EXIT        
              GO TO 1440-EXIT                                           
           END-IF.                                                      
      *                                                                 13830000
           IF WS-DATE-NOTICE-MAIL-F > SPACES                            
A05323        IF WS-CODE-SPECIAL-TYPE-F = WS-D                          
                  MOVE 90203 TO CL-CODE-MESSAGE-TYPE                    
              ELSE                                                      
                  IF WS-AMT-NOTICE-U > 0                                
                     MOVE 80202 TO CL-CODE-MESSAGE-TYPE                 
                  ELSE                                                  
                     MOVE 90202 TO CL-CODE-MESSAGE-TYPE                 
                  END-IF                                                
              END-IF                                                    
           ELSE                                                         
              IF WS-CODE-SPECIAL-TYPE-F = WS-D                          
                  MOVE 90203 TO CL-CODE-MESSAGE-TYPE                    
              ELSE                                                      
                  IF WS-AMT-NOTICE-U > 0                                
                     MOVE 80202 TO CL-CODE-MESSAGE-TYPE                 
                  ELSE                                                  
                     MOVE 90202 TO CL-CODE-MESSAGE-TYPE                 
                  END-IF                                                
              END-IF                                                    
           END-IF.                                                      
      *                                                                 14180000
           IF CL-CODE-MESSAGE-TYPE = 90203                              
               MOVE AT-ACCOUNT-NO TO DA-ACCOUNT-NO                      
               PERFORM 7440-GET-EARNEST-PYMT-INFO THRU 7440-EXIT        
           END-IF.                                                      
      *                                                                 14230000
           MOVE WS-F                  TO CL-CODE-NOTICE-TYPE.           
           MOVE WS-ITEM-ID-F          TO CL-ITEM-ID.                    
           MOVE WS-BALANCE-DUE        TO CL-AMT-NOTICE.                 
           MOVE WS-BALANCE-DUE        TO WS-AMT-NOTICE.                 
           MOVE WS-DATE-NOTICE-MAIL-F TO WS-DATE-NOTICE-MAIL.           
           MOVE WS-DATE-NOTICE-DUE-F  TO WS-DATE-NOTICE-DUE.            
           PERFORM 8530-UPDATE-CRED-COLL THRU 8530-EXIT.                
      *                                                                 14360000
           IF WS-AMT-NOTICE-U > 0                                       
              MOVE WS-U TO CL-CODE-NOTICE-TYPE                          
              MOVE WS-AMT-NOTICE-U TO CL-AMT-NOTICE                     
              PERFORM 8530-UPDATE-CRED-COLL THRU 8530-EXIT              
              MOVE '2' TO WS-NON-UTL-CR-HST-EX (1:1)                    
           END-IF                                                       
      *                                                                 14430000
           MOVE '2' TO WS-NEW-DISCEX-HIST-X (1:1).                      
      *                                                                 14450000
           IF CSR-DATABASE AND WS-AUTO-DEP-CHARGED = 0                  
              PERFORM 1350-CALL-AUTO-DEP-SP THRU  1350-EXIT             
           END-IF                                                       
      *                                                                 14490000
           IF CSR-DATABASE                                              
              IF WS-CODE-PENDING-DNP = 'A'                              
                 PERFORM 7850-CHECK-SO-UPDT-ACTION-FL    THRU 7850-EXIT 
                 IF DNP-CANCEL-ROW-EXISTS                               
                    IF XK-SO-UPDT-ACTION-FL = 'U'                       
                       PERFORM 8750-UPD-SO-DNP-ACTION-FL THRU 8750-EXIT 
                    END-IF                                              
                    MOVE 'N' TO WS-SO-DNP-CANCEL-ROW                    
                 ELSE                                                   
                    PERFORM 8760-INS-SO-DNP-CANCEL-ROW   THRU 8760-EXIT 
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                 14630000
           PERFORM 1500-CREATE-NOTICE THRU 1500-EXIT.                   
      *                                                                 14650000
A05323     IF WS-DATE-NOTICE-MAIL-F = WS-DATE-NOTICE-MAIL-O             
A05323         MOVE 'O'    TO CL-CODE-NOTICE-TYPE                       
A05323         PERFORM 3040-DEL-NOTICE-GET-DNP-TYP THRU 3040-EXIT       
A05323     END-IF.                                                      
A05323*                                                                         
       1440-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14680000
      ******************************************************************14690000
      * 1450-RETURNED-CHECK                                            *14700000
      * THIS MODULE PROCESSES RETURNED CHECKS THAT DID NOT MERGE WITH  *14710000
      * A 2ND NOTICE THROUGH THE PANEL.                                *14720000
A05323* REMOVED MERGE LOGIC. CORRECTED LOGIC WHEN MULTIPLE RETURNED    *        
A05323* CHECKS ARE ENTERED THE SAME DAY SO THAT ONLY 1 NOTICE IS SENT. *        
      ******************************************************************14730000
       1450-RETURNED-CHECK.                                             
      *                                                                 14750000
A05323     IF 1450-RET-CHECK-PROCESSED                                  
A05323        GO TO 1450-EXIT                                           
A05323     END-IF                                                       
                                                                        
           MOVE WS-N TO WS-CHECK-PROCESSED.                             
           MOVE ZERO TO WS-NUMBER-CHKS-PROCESSED.                       
      *                                                                 14780000
           PERFORM 7109-OPEN-CRED-COLL-CSR    THRU 7109-EXIT.           
           PERFORM 1455-GET-DATE-RANGE        THRU 1455-EXIT.           
           PERFORM 7120-OPEN-RETURNED-CHK-CSR THRU 7120-EXIT.           
      *                                                                 14820000
           PERFORM UNTIL WS-NUMBER-CHKS-PROCESSED =                     
                         WS-NUMBER-OF-CHECKS                            
              PERFORM 7110-FETCH-CRED-COLL-CSR    THRU 7110-EXIT        
              PERFORM 7121-FETCH-RETURNED-CHK-CSR THRU 7121-EXIT        
              IF CL-DATE-NOTICE-MAIL EQUAL WS-NEXT-DAY                  
                  IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL            
                     MOVE NH-NSF-REASON-CD    TO WS-NSF-REASON-CD       
                     MOVE NH-DRAWN-BY-NM-TEXT TO WS-DRAWN-BY-NM-T       
                     MOVE NH-NSF-CHARGE-AMT   TO WS-NSF-CHARGE-AMT      
                     MOVE NH-RETURN-CHECK-AMT TO WS-RETURN-CHECK-AMT    
                     PERFORM 7300-SELECT-NSF-REASON THRU 7300-EXIT      
                  ELSE                                                  
A05323               MOVE SPACES TO NH-NSF-REASON-CD                    
                                    NH-DRAWN-BY-NM                      
                                    WS-NSF-REASON-CD                    
                                    WS-DRAWN-BY-NM-T                    
                     MOVE ZEROES TO NH-NSF-CHARGE-AMT                   
                                    NH-RETURN-CHECK-AMT                 
                                    WS-NSF-CHARGE-AMT                   
                                    WS-RETURN-CHECK-AMT                 
                  END-IF                                                
                  MOVE 'N' TO CL-CODE-NOTICE-TYPE                       
                  COMPUTE  WS-RET-CHK-PAST-DUE-AMT =                    
                          (WS-AMT-RET-CHECK  -                          
                           WS-AMT-30-DAY-NSC -                          
                           WS-AMT-60-DAY-NSC -                          
                           WS-AMT-90-DAY-NSC)                           
                  MOVE WS-CODE-MESSAGE-TYPE-N TO CL-CODE-MESSAGE-TYPE   
                  MOVE WS-CODE-SPECIAL-TYPE-N TO CL-CODE-SPECIAL-TYPE   
                  MOVE CL-DATE-NOTICE-MAIL    TO WS-DATE-NOTICE-MAIL    
                  MOVE CL-DATE-NOTICE-DUE     TO WS-DATE-NOTICE-DUE     
                  MOVE ZEROS TO WS-GUAR-MESS-TYPE,                      
                                WS-THIRD-PTY-MESS-TYPE                  
AP5660            IF CL-CODE-MESSAGE-TYPE = 90206 OR 80206 OR           
AP5660                                      90205 OR 80205              
                     IF NH-DEPOSIT-CERT-NO > 0 AND CSR-DATABASE         
                       PERFORM 7660-GET-DEPOSIT-AMT THRU 7660-EXIT      
                       MOVE WS-DO-DEPOSIT-AMT TO WS-AUTO-DEP-CHARGED    
                     END-IF                                             
                  END-IF                                                
      *** PSNC WILL MERGE RET CHECKS LIKE SCEG.                         15190000
                  MOVE WS-AMT-PAST-DUE-UTL TO WS-AMT-PAST-DUE           
                       COMPUTE WS-AMT-PAST-DUE-NONUTL =                 
                              (WS-AMT-00-DAY-NSC +                      
                               WS-AMT-00-DAY-NSN +                      
                               WS-AMT-30-DAY-NSN +                      
                               WS-AMT-60-DAY-NSN +                      
                               WS-AMT-90-DAY-NSN)                       
                  MOVE WS-Y TO WS-CHECK-PROCESSED                       
A05323        COMPUTE WS-AMT-NOTICE =                                   
A05323                (WS-AMT-ARREARS-UTL +                             
A05323                 WS-AMT-00-DAY-NSA)                               
              END-IF                                                    
              ADD 1 TO WS-NUMBER-CHKS-PROCESSED                         
P0599D        IF WS-CHECK-PROCESSED = WS-Y                              
P0599D           IF (CL-CODE-MESSAGE-TYPE = 90206 OR 80206)             
P0599D               MOVE '2' TO WS-NEW-DISCEX-HIST-X (1:1)             
P0599D               MOVE '2' TO WS-NON-UTL-CR-HST-EX (1:1)             
P0599D           ELSE                                                   
P0599D               MOVE '1' TO WS-NEW-DISCEX-HIST-X (1:1)             
P0599D               MOVE '1' TO WS-NON-UTL-CR-HST-EX (1:1)             
P0599D           END-IF                                                 
P0599D           PERFORM 8535-UPDATE-CRED-COLL2 THRU 8535-EXIT          
A05323           IF 1450-RET-CHECK-PROCESSED                            
A05323              CONTINUE                                            
A05323           ELSE                                                   
P0599D              PERFORM 1500-CREATE-NOTICE THRU 1500-EXIT           
A05323              MOVE WS-Y TO WS-1450-RET-CHECK-PROCESS              
A05323           END-IF                                                 
P0599D        END-IF                                                    
           END-PERFORM.                                                 
      *                                                                 15490000
           PERFORM 7111-CLOSE-CRED-COLL-CSR    THRU 7111-EXIT.          
           PERFORM 7122-CLOSE-RETURNED-CHK-CSR THRU 7122-EXIT.          
      *                                                                 15520000
       1450-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15550000
      ******************************************************************15560000
      * 1455-GET-DATE-RANGE                                            *15570000
      * THIS MODULE GETS THE DAY RANGE THE CHECK(S) COULD HAVE RETURNED*15580000
      * AGAINST THE ACCOUNT. SO THE DETAILS OF THE CHECK THE NOTICE    *15590000
      * IS BEING SENT FOR CAN BE EXTRACTED FROM CSS_NSF_HIST.          *15600000
      ******************************************************************15610000
       1455-GET-DATE-RANGE.                                             
      *                                                                 15630000
      * GET PREVIOUS BUSINESS DAY FROM CL-DATE-NOTICE-MAIL              15640000
ACT356     MOVE CL-DATE-NOTICE-MAIL   TO WS-NEW-BUSINESS-DAY.           
           PERFORM 6525-PREV-BUSINESS-DAY THRU                          
                                            6525-PREV-BUSINESS-DAY-EXIT.
           MOVE WS-NEW-BUSINESS-DAY TO WS-DATE-RANGE-1.                 
      *                                                                 15690000
      * GET 4 BUSINESS DAYS FROM CL-DATE-NOTICE-MAIL                    15700000
ACT356     MOVE CL-DATE-NOTICE-MAIL   TO WS-NEW-BUSINESS-DAY.           
           MOVE 4 TO WS-NO-OF-DAY.                                      
           PERFORM 6500-GET-NEXT-BUSINESS-DAY THRU                      
                                            6500-NEXT-BUSINESS-DAY-EXIT.
           MOVE WS-NEW-BUSINESS-DAY TO WS-DATE-RANGE-2.                 
      *                                                                 15760000
       1455-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************16050000
      * 1475-BILL-DEP-NOTICE                                           *16060000
      * THIS MODULE CREATES A DEPOSIT NOTICE.                          *16070000
      ******************************************************************16080000
       1475-BILL-DEP-NOTICE.                                            
      *                                                                 16100000
           MOVE WS-O                   TO CL-CODE-NOTICE-TYPE.          
           MOVE WS-CODE-SPECIAL-TYPE-O TO CL-CODE-SPECIAL-TYPE.         
           IF WS-AMT-00-DAY-DEP EQUAL ZEROES                            
               PERFORM 3040-DEL-NOTICE-GET-DNP-TYP THRU 3040-EXIT       
               GO TO 1475-EXIT                                          
           END-IF.                                                      
      *                                                                 16170000
           MOVE WS-ITEM-ID-O          TO CL-ITEM-ID.                    
           MOVE WS-O                  TO CL-CODE-NOTICE-TYPE.           
           MOVE WS-AMT-00-DAY-DEP     TO CL-AMT-NOTICE.                 
           MOVE WS-AMT-00-DAY-DEP     TO WS-AMT-NOTICE.                 
           MOVE WS-DATE-NOTICE-MAIL-O TO WS-DATE-NOTICE-MAIL.           
           MOVE WS-DATE-NOTICE-DUE-O  TO WS-DATE-NOTICE-DUE.            
           MOVE 90204                 TO CL-CODE-MESSAGE-TYPE.          
           MOVE AT-PREMISE-NO         TO PR-PREMISE-NO                  
           PERFORM 7020-SELECT-PREMISE THRU 7020-EXIT.                  
           PERFORM 7496-GET-DEP-INT-RATE THRU 7496-EXIT.                
           COMPUTE WS-DEPOSIT-BAL = WS-AMT-00-DAY-DEP +                 
                                    WS-AMT-30-DAY-DEP +                 
                                    WS-AMT-60-DAY-DEP +                 
                                    WS-AMT-90-DAY-DEP +                 
                                    WS-AMT-UN-CR-DEP.                   
ACT248     IF AT-COMPANY-NO = '01'                                      
ACT248        IF WS-DEPOSIT-BAL LESS THAN WS-NOTICE-LIMIT-CO01          
ACT248            PERFORM 3040-DEL-NOTICE-GET-DNP-TYP THRU 3040-EXIT    
ACT248            GO TO 1475-EXIT                                       
ACT248        END-IF                                                    
ACT248     ELSE                                                         
ACT248        IF WS-DEPOSIT-BAL LESS THAN WS-NOTICE-LIMIT-CO26          
ACT248            PERFORM 3040-DEL-NOTICE-GET-DNP-TYP THRU 3040-EXIT    
ACT248            GO TO 1475-EXIT                                       
ACT248        END-IF                                                    
ACT248     END-IF.                                                      
           MOVE '1' TO WS-NEW-DISCEX-HIST-X (1:1).                      
           PERFORM 8530-UPDATE-CRED-COLL THRU 8530-EXIT.                
           PERFORM 1500-CREATE-NOTICE THRU 1500-EXIT.                   
      *                                                                 16360000
       1475-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16390000
      ******************************************************************16400000
      * 1500-CREATE-NOTICE                                             *16410000
      * THIS MODULE CALLS 1525 TO INSERT NOTICE AFTER CHECKING FOR 3RD *16420000
      * PARTY & GUARANTOR.  IF A GUARANTOR EXISTS ON THE ACCOUNT, THE  *16430000
      * 90109 MESSAGE IS RECORDED FOR THE ACCOUNT.  IF A THIRD PARTY   *16440000
      * EXISTS ON THE ACCOUNT, THE 90108 MESSAGE IS RECORDED FOR THE   *16450000
      * ACCOUNT.                                                       *16460000
      ******************************************************************16470000
       1500-CREATE-NOTICE.                                              
      *                                                                 16490000
           MOVE ZEROS TO WS-GUAR-MESS-TYPE,                             
                         WS-THIRD-PTY-MESS-TYPE.                        
           MOVE WS-N TO WS-GUARANTOR-EXISTS.                            
      *                                                                 16530000
           IF CL-CODE-NOTICE-TYPE = "E" OR "O"                          
              CONTINUE                                                  
           ELSE                                                         
              IF CSR-DATABASE AND AT-COMPANY-NO = WS-SCEG               
                 PERFORM 7445-SELECT-ACT-GUAR THRU 7445-EXIT            
                 IF GUARANTOR-EXISTS                                    
                    MOVE 90109 TO WS-GUAR-MESS-TYPE                     
                 END-IF                                                 
P0599J        END-IF                                                    
P0599J        IF WS-CODE-THIRD-PTY = WS-A                               
P0599J           MOVE 90108 TO WS-THIRD-PTY-MESS-TYPE                   
P0599J        END-IF                                                    
           END-IF.                                                      
      *                                                                 16670000
           MOVE CL-CODE-MESSAGE-TYPE TO WS-CODE-MESSAGE-TYPE.           
           PERFORM 1525-INSERT-NOTICE THRU 1525-EXIT.                   
      *                                                                 16690000
           MOVE WS-NEW-DISC-HIST-X   TO CZ-DISCONNECT-HIST.             
           MOVE WS-NEW-DISCEX-HIST-X TO CZ-DISC-EXCEPTN-HIST.           
           MOVE WS-NON-UTL-CR-HST    TO CZ-NON-UTL-CR-HST.              
           MOVE WS-NON-UTL-CR-HST-EX TO CZ-NON-UTL-CR-HST-EX.           
           PERFORM 8520-UPDATE-CREDIT-PROFILE THRU 8520-EXIT.           
      *                                                                         
           IF WS-GUAR-MESS-TYPE > 0                                     
              PERFORM 1533-PROCESS-GUARANTORS THRU 1533-EXIT            
           END-IF.                                                      
      *                                                                         
           IF WS-THIRD-PTY-MESS-TYPE > 0                                
              PERFORM 1550-GET-THIRD-PRTY-INFO THRU 1550-EXIT           
           END-IF.                                                      
      *                                                                 16750000
ACT187     PERFORM 1590-CHECK-FOR-CASH-ONLY-LTR THRU 1590-EXIT.         
      *                                                                         
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16780000
      ******************************************************************16790000
      * 1525-INSERT-NOTICE                                             *        
      * THIS MODULE WRITES THE ACCOUNT INFORMATION FOR THE NOTICE TO   *        
      * BE LOADED TO THE CORRESP DB2 TABLES VIA SCSKR125 IN 1527.      *        
      ******************************************************************        
       1525-INSERT-NOTICE.                                              
      *                                                                         
           MOVE WS-INPUT-DATE          TO WS-COMMON-DATE.               
           MOVE PROGRAM-NAME           TO WS-CORRESP-LAST-UPDATE-PGM-ID 
                                          WS-CORRESP-CREATED-BY-PGM-ID  
                                          WS-CALLING-PGM-NAME.          
P0599G     MOVE 'PCSKR200A'            TO WS-KR125-MNT-APPL-PGM-ID.     
           MOVE CL-ACCOUNT-NO          TO WS-NOTICE-ACCOUNT-NO.         
           MOVE AT-CUSTOMER-NO         TO WS-NOTICE-CUSTOMER-NO.        
           MOVE WS-CODE-MESSAGE-TYPE   TO WS-CORRESP-MSG-ID.            
           MOVE 0                      TO WS-NOTICE-GUARANTOR-ACCT-NO.  
           MOVE AT-COMPANY-NO          TO WS-CORRESP-COMPANY-NO         
                                          WS-PROCESS-COMPANY-NO.        
A4527A     IF SEB-DATABASE                                              
A4527A        MOVE LR-REG-GROUP-CD        TO WS-NOTICE-REG-GROUP-CD     
A4527A        MOVE WS-REG-SENIOR-FLAG     TO WS-NOTICE-SENIOR-FL        
A4527A     ELSE                                                         
A4527A        MOVE SPACES                 TO WS-NOTICE-REG-GROUP-CD     
A4527A        MOVE SPACES                 TO WS-NOTICE-SENIOR-FL        
A4527A     END-IF.                                                      
           MOVE WS-INPUT-DATE          TO WS-CORRESP-STMT-DT.           
           MOVE +1                     TO WS-NOTICE-CORRESP-ID.         
P0599F     MOVE WS-FRCSTED-AUTO-DEP    TO WS-NOTICE-AUTO-DEP-FCST-AM.   
           MOVE WS-AMT-NOTICE          TO WS-NOTICE-UTIL-PAST-DUE-AM.   
           MOVE WS-AMT-PAST-DUE-NONUTL TO WS-NOTICE-NONUTL-PAST-DUE-AM. 
           MOVE WS-DATE-NOTICE-DUE     TO WS-NOTICE-DUE-DT.             
           MOVE AT-TOTAL-AR-BALANCE    TO WS-NOTICE-DUE-AM.             
           MOVE AT-LAST-PYMT-DATE      TO WS-NOTICE-LAST-PAYMENT-DT.    
           MOVE AT-LAST-PYMT-AMOUNT    TO WS-NOTICE-LAST-PAYMENT-AM.    
           MOVE CZ-CASH-ONLY-FL        TO WS-NOTICE-CASH-ONLY-FL.       
           MOVE WS-RETURN-CHECK-AMT    TO WS-RET-CHK-AMT.               
      *                                                                         
           PERFORM 1526-SELECT-VARIABLE-VALUES THRU 1526-EXIT.          
           PERFORM 1600-INSERT-COMM-DATA THRU 1600-EXIT.                
      *                                                                         
           PERFORM 1700-INSERT-MNT-TRANS-DATA THRU 1700-EXIT.           
      *                                                                         
           PERFORM 1527-CALL-NOTICE-SUB        THRU 1527-EXIT.          
      *                                                                         
       1525-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      *   1526-SELECT-VARIABLE-VALUES                                           
      **************************************************************            
       1526-SELECT-VARIABLE-VALUES.                                     
      *                                                                         
           EVALUATE TRUE                                                
              WHEN WS-CODE-MESSAGE-TYPE = 90204                         
                 MOVE WS-AMT-NOTICE TO WS-NOTICE-UTIL-PAST-DUE-AM       
              WHEN WS-CODE-MESSAGE-TYPE = 90205 OR 90206 OR 80206 OR    
                                          90208 OR 90209                
                 COMPUTE WS-TOTAL-RET-CHK-AMT =                         
                          WS-RETURN-CHECK-AMT + WS-NSF-CHARGE-AMT       
           END-EVALUATE.                                                
      *                                                                         
       1526-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1527-CALL-NOTICE-SUB                                           *        
      * THIS MODULE CALLS SCSKR125 THAT LOADS THE DATA TO THE CORRESP  *        
      * NOTICE DB2 TABLES.                                             *        
      ******************************************************************        
       1527-CALL-NOTICE-SUB.                                            
      *                                                                         
P0599E     IF CL-ACCOUNT-NO = WS-PREV-ACCT-NO-WRKD                      
P0599E        EVALUATE WS-CODE-MESSAGE-TYPE                             
P0599E           WHEN WS-PREV-MESS-TYPE-WRKD                            
P0599E              ADD 1 TO WS-CORRESP-SEQ-NO-WRKD                     
ACT187              MOVE WS-CORRESP-SEQ-NO-WRKD TO WS-CORRESP-SEQ-NO    
ACT187           WHEN WS-PREV-MESS-TYPE-WRKD2                           
ACT187              ADD 1 TO WS-CORRESP-SEQ-NO-WRKD2                    
ACT187              MOVE WS-CORRESP-SEQ-NO-WRKD2 TO WS-CORRESP-SEQ-NO   
ACT187           WHEN WS-PREV-MESS-TYPE-WRKD3                           
ACT187              ADD 1 TO WS-CORRESP-SEQ-NO-WRKD3                    
ACT187              MOVE WS-CORRESP-SEQ-NO-WRKD3 TO WS-CORRESP-SEQ-NO   
ACT187           WHEN OTHER                                             
P0599E              MOVE 0 TO WS-CORRESP-SEQ-NO                         
ACT187        END-EVALUATE                                              
P0599E     ELSE                                                         
P0599E        MOVE 0 TO WS-CORRESP-SEQ-NO                               
ACT187        MOVE 0 TO WS-CORRESP-SEQ-NO-WRKD                          
ACT187        MOVE 0 TO WS-CORRESP-SEQ-NO-WRKD2                         
ACT187        MOVE 0 TO WS-CORRESP-SEQ-NO-WRKD3                         
P0599E     END-IF.                                                      
      *                                                                         
           DISPLAY 'CALLING SCSKR125'.                                  
           CALL SCSKR125 USING WS-CORRESP-HDR                           
                               WS-CORRESP-NOTICE                        
                               WS-CORRESP-VAR                           
                               WS-MISC-PROCESSING-VARS                  
                               WS-KR125-COMM-DATA-VARS                  
                               WS-KR125-MNT-TRANS-VARS                  
                               ABEND-FILE                               
                               WS-CWS350-MISC                           
                               WS-CORRESP-COMM-VAR                      
                               RS-KR125-RETURN-CODE.                    
      *                                                                         
           IF  ABEND-FUNCTION  > SPACES                                 
A4527B        IF  ABEND-SQLCODE = -803                                  
A4527B          AND WS-CODE-MESSAGE-TYPE = '90207'                      
A4527B           NEXT SENTENCE                                          
A4527B        ELSE                                                      
                 DISPLAY '********** PCSKR200 ABORT **************'     
                 DISPLAY '* 1527-CALL-NOTICE-SUB                 *'     
                 DISPLAY '* ERROR CALLING SCSKR125               *'     
                 DISPLAY '* RETURN CODE: ',  ABEND-SQLCODE              
                 DISPLAY '* PROGRAM ABORTING...                  *'     
                 DISPLAY '********** PCSKR200 ABORT **************'     
                 MOVE ABEND-SQLCODE           TO RS-RETURN-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                 PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT      
A4527B        END-IF                                                    
           END-IF.                                                      
      *                                                                         
P0599E     MOVE CL-ACCOUNT-NO        TO WS-PREV-ACCT-NO-WRKD.           
ACT187     EVALUATE WS-CODE-MESSAGE-TYPE                                
ACT187        WHEN '90207'                                              
ACT187         CONTINUE                                                 
ACT187        WHEN '90109'                                              
ACT187            MOVE WS-CODE-MESSAGE-TYPE TO WS-PREV-MESS-TYPE-WRKD2  
ACT187        WHEN '90108'                                              
ACT187            MOVE WS-CODE-MESSAGE-TYPE TO WS-PREV-MESS-TYPE-WRKD3  
P0599K        WHEN OTHER                                                
P0599E            MOVE WS-CODE-MESSAGE-TYPE TO WS-PREV-MESS-TYPE-WRKD   
P0599K     END-EVALUATE.                                                
      *                                                                         
       1527-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  1533-PROCESS-GUARANTORS                                       *        
      *  THIS MODULE PROCESSES GUARANTOR.                              *        
      ******************************************************************        
       1533-PROCESS-GUARANTORS.                                         
      *                                                                         
           PERFORM 7030-OPEN-GUARANTOR  THRU 7030-EXIT.                 
           PERFORM 7035-FETCH-GUARANTOR THRU 7035-EXIT.                 
      *                                                                         
           PERFORM 1534-GUARANTOR-NOTICE THRU 1534-EXIT                 
               UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                 
      *                                                                         
           PERFORM 7040-CLOSE-GUARANTOR THRU 7040-EXIT.                 
      *                                                                         
       1533-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  1534-GUARANTOR-NOTICE                                         *        
      *  THIS MODULE SENDS OUT THE GUARANTOR NOTICE.                   *        
      ******************************************************************        
       1534-GUARANTOR-NOTICE.                                           
      *                                                                         
           MOVE GU-GUARNTR-ACCT-NO TO WS-NOTICE-GUARANTOR-ACCT-NO       
                                      WS-KR125-MNT-ACCOUNT-NO.          
ACT145     IF GU-ADDRESS-ID = 0                                         
ACT145         MOVE AT-ADDRESS-ID        TO WS-CORRESP-GU-ADDR-ID       
ACT145         MOVE AT-ADDRESS-FORMAT    TO WS-GU-ADDRESS-FORMAT        
ACT145     ELSE                                                         
ACT145         MOVE GU-ADDRESS-ID  TO WS-CORRESP-GU-ADDR-ID             
ACT145         MOVE 'B'            TO WS-GU-ADDRESS-FORMAT              
ACT145     END-IF.                                                      
           MOVE WS-GUAR-MESS-TYPE  TO WS-CORRESP-MSG-ID                 
                                      WS-CODE-MESSAGE-TYPE.             
           PERFORM 1750-LOAD-MT-TRANS-COMMENT THRU 1750-EXIT.           
           PERFORM 1527-CALL-NOTICE-SUB THRU 1527-EXIT.                 
           INITIALIZE WS-NOTICE-GUARANTOR-ACCT-NO                       
                      WS-KR125-MNT-ACCOUNT-NO                           
                      WS-CORRESP-GU-ADDR-ID                             
                      WS-GU-ADDRESS-FORMAT.                             
           PERFORM 7035-FETCH-GUARANTOR THRU 7035-EXIT.                 
      *                                                                         
       1534-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************14955310
      *  1550-GET-THIRD-PRTY-INFO.                                     *14955330
      *  THIS MODULE GETS THE THIRD PARTY(S) ASSOCIATED WITH THE       *14955350
      *  ACCOUNT IF THE THIRD PARTY MESSAGE IS '90108'.                *14955360
      ******************************************************************14955380
       1550-GET-THIRD-PRTY-INFO.                                        
      *                                                                         
           INITIALIZE WS-KR125-MNT-TRANS-VARS.                          
           MOVE AT-ACCOUNT-NO TO WS-HOLD-ACCT-NO                        
                                 ZW-ACCOUNT-NO.                         
           MOVE WS-A          TO ZW-THD-PRTY-STATUS.                    
      *                                                                         
           PERFORM 7060-OPEN-THIRD-PTY-CURSOR THRU 7060-EXIT.           
           PERFORM 7061-FETCH-THIRD-PTY       THRU 7061-EXIT.           
           PERFORM 1555-LOAD-THIRD-PARTY THRU 1555-EXIT                 
                 UNTIL SQLCODE = NOT-FOUND.                             
           PERFORM 7062-CLOSE-THIRD-PTY THRU 7062-EXIT.                 
      *                                                                 14956500
           MOVE WS-HOLD-ACCT-NO TO AT-ACCOUNT-NO.                       
      *                                                                 14956700
       1550-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14957010
      ******************************************************************14982610
      * 1555-LOAD-THIRD-PARTY.                                         *14982612
      * MOVE ADDRESS ID, NAME ID, HOME/WORK TELEPHONE NUMBERS          *        
      ******************************************************************14982670
       1555-LOAD-THIRD-PARTY.                                           
      *                                                                 14983500
           MOVE WS-THIRD-PTY-MESS-TYPE TO WS-CORRESP-MSG-ID             
                                          WS-CODE-MESSAGE-TYPE.         
           MOVE ZW-ADDRESS-ID  TO WS-CORRESP-CC-ADDR-ID.                
           MOVE ZW-NAME-ID     TO WS-CORRESP-CC-NAME-ID.                
           MOVE WS-B           TO WS-TP-ADDRESS-FORMAT.                 
           MOVE ZW-THD-PRTY-ID TO WS-CORRESP-THD-PRTY-ID.               
           MOVE ZW-THD-PRTY-ID TO ZY-THD-PRTY-ID.                       
           MOVE WS-HOME-PHONE  TO ZY-PHONE-TYPE.                        
           PERFORM 7200-SELECT-THD-PRTY-PHONE THRU 7200-EXIT.           
           MOVE ZY-PHONE-NO    TO WS-CORRESP-TP-HOME-PHONE.             
           MOVE ZW-THD-PRTY-ID TO ZY-THD-PRTY-ID.                       
           MOVE WS-WORK-PHONE  TO ZY-PHONE-TYPE.                        
           PERFORM 7200-SELECT-THD-PRTY-PHONE THRU 7200-EXIT.           
           MOVE ZY-PHONE-NO    TO WS-CORRESP-TP-WORK-PHONE.             
           PERFORM 1527-CALL-NOTICE-SUB THRU 1527-EXIT.                 
           PERFORM 7061-FETCH-THIRD-PTY THRU 7061-EXIT.                 
      *                                                                 14984600
       1555-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************14851410
      * 1585-NO-DEP-INT-ROW                                            *16800000
      * THIS WQ IS GENERATED WHEN A ROW CANNOT BE FOUND ON THE         *16810000
      * CSS_DEP_INT_RATE TABLE FOR A PARTICULAR ACCOUNT NUMBER.        *16820000
      ******************************************************************16830000
       1585-NO-DEP-INT-WQ.                                              
      *                                                                 16850000
           INITIALIZE WS-COMMENTS.                                      
           MOVE 137                TO WS-WQ-CATEGORY.                   
           MOVE AT-COMPANY-NO      TO WS-NO-DEP-INT-CO.                 
           MOVE AT-LOCAL-OFFICE    TO WS-NO-DEP-INT-LO.                 
           MOVE PR-REV-DISTRICT-CD TO WS-NO-DEP-INT-REV-DIST.           
           MOVE WS-NO-DEP-INT      TO WS-COMMENTS-TEXT.                 
           MOVE 82                 TO WS-COMMENTS-LEN.                  
           PERFORM 1408-CHECK-WQ-GEN THRU 1408-EXIT.                    
      *                                                                 16940000
       1585-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16970000
      ******************************************************************16980000
      **    1590-CHECK-FOR-CASH-ONLY-LTR                              **PCS03320
      ** THIS MODULE WILL WRITE A MAINTENANCE TRANSACTION HISTORY     **        
      ** FOR RETURNED CHECK NOTICES - 90107/80107, 90206/80206, 90207 **        
      ** WHEN THE CASH ONLY FLAG IS SET FOR THE CUSTOMER.             **        
      ******************************************************************PCS03340
       1590-CHECK-FOR-CASH-ONLY-LTR.                                    
      *                                                                         
           IF WS-CODE-MESSAGE-TYPE = '90107' OR                         
              WS-CODE-MESSAGE-TYPE = '90205' OR                         
              WS-CODE-MESSAGE-TYPE = '90206' OR                         
              WS-CODE-MESSAGE-TYPE = '80206' OR                         
              WS-CODE-MESSAGE-TYPE = '80107' OR                         
A05058        WS-CODE-MESSAGE-TYPE = '90208' OR                         
A05058        WS-PREV-MESS-TYPE-WRKD = '90208' OR                       
ACT187        WS-PREV-MESS-TYPE-WRKD = '90107' OR                       
ACT187        WS-PREV-MESS-TYPE-WRKD = '90205' OR                       
ACT187        WS-PREV-MESS-TYPE-WRKD = '90206' OR                       
ACT187        WS-PREV-MESS-TYPE-WRKD = '80206' OR                       
ACT187        WS-PREV-MESS-TYPE-WRKD = '80107'                          
               IF WS-NOTICE-CASH-ONLY-FL = WS-Y                         
P0599K         AND WS-DONE-CASH-ONLY-NOTICE = 'N'                       
                   MOVE ZEROS          TO WS-NOTICE-DUE-AM              
                                          WS-RET-CHK-AMT                
                                          WS-NOTICE-UTIL-PAST-DUE-AM    
                                          WS-NOTICE-NONUTL-PAST-DUE-AM  
                   INITIALIZE WS-KR125-MNT-TRANS-VARS                   
                   MOVE '90207'        TO WS-CODE-MESSAGE-TYPE          
                                          WS-CORRESP-MSG-ID             
                   MOVE ZEROS          TO WS-AMT-NOTICE                 
                   MOVE SPACES         TO WS-DATE-NOTICE-DUE            
P0599L             MOVE 'PCSKR200A'    TO WS-KR125-MNT-APPL-PGM-ID      
                   MOVE CL-ACCOUNT-NO  TO WS-KR125-MNT-ACCOUNT-NO       
                   MOVE ZEROES         TO WS-KR125-MNT-PREMISE-NO       
                   MOVE ZEROES         TO WS-KR125-MNT-CUSTOMER-NO      
                   MOVE WS-INPUT-DATE  TO WS-KR125-MNT-DATE-TRANS       
                   MOVE 'H'            TO WS-KR125-CODE-TRAN-TYP        
                   MOVE SPACES         TO WS-KR125-RESP-AREA-ID         
                   PERFORM 1750-LOAD-MT-TRANS-COMMENT THRU 1750-EXIT    
                   PERFORM 1527-CALL-NOTICE-SUB       THRU 1527-EXIT    
P0599K             MOVE 'Y' TO WS-DONE-CASH-ONLY-NOTICE                 
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       1590-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      *   1600-INSERT-COMM-DATA.                                                
      **************************************************************            
       1600-INSERT-COMM-DATA.                                           
      *                                                                         
           MOVE CL-ACCOUNT-NO          TO WS-KR125-COMM-ACCT-NO.        
           MOVE AT-PREMISE-NO          TO WS-KR125-PREMISE-NO.          
           MOVE AT-CUSTOMER-NO         TO WS-KR125-CUSTOMER-NO.         
           MOVE 'A'                    TO WS-KR125-COMM-ASSOC-CD.       
           MOVE SPACES                 TO WS-KR125-PSC-COMPL-ID.        
           MOVE SPACES                 TO WS-KR125-CONTACT-NAME.        
           MOVE SPACES                 TO WS-KR125-RED-FL-EXP-DT.       
           MOVE SPACES                 TO WS-KR125-CALL-END-TIME.       
           MOVE 0                      TO WS-KR125-COMDAT-CMT-LEN.      
           MOVE SPACES                 TO WS-KR125-COMDAT-CMT-TEXT.     
      *                                                                         
       1600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      *   1700-INSERT-MNT-TRANS-DATA.                                           
      **************************************************************            
       1700-INSERT-MNT-TRANS-DATA.                                      
      *                                                                         
           MOVE CL-ACCOUNT-NO     TO WS-KR125-MNT-ACCOUNT-NO.           
           MOVE ZEROES            TO WS-KR125-MNT-PREMISE-NO.           
           MOVE ZEROES            TO WS-KR125-MNT-CUSTOMER-NO.          
           MOVE WS-INPUT-DATE     TO WS-KR125-MNT-DATE-TRANS.           
           MOVE 'H'               TO WS-KR125-CODE-TRAN-TYP.            
           MOVE SPACES            TO WS-KR125-RESP-AREA-ID.             
      *                                                                         
           PERFORM 1750-LOAD-MT-TRANS-COMMENT THRU 1750-EXIT.           
      *                                                                         
       1700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      *   1750-LOAD-MT-TRANS-COMMENT                                            
      **************************************************************            
       1750-LOAD-MT-TRANS-COMMENT.                                      
      *                                                                         
      * PROVIDE THE COMMENT FOR PANEL 156 - NOTICE TRANSACTION                  
      * HISTORY.                                                                
      *                                                                         
           INITIALIZE     WS-CWS00136-NOTICE-TYPE                       
                          WS-CWS00136-DATE-MAIL                         
                          WS-CWS00136-DATE-NOTICE-DUE                   
                          WS-CWS00136-AMT-NOTICE-DOL                    
                          WS-CWS00136-AMT-NOTICE-DEC                    
                          WS-CWS00136-MESSAGE-NUMBER                    
                          WS-CWS00136-FRCST-AUTO-DEP-DL                 
                          WS-CWS00136-FRCST-AUTO-DEP-DC                 
                          WS-HOLD-AMOUNT.                               
                                                                        
           EVALUATE WS-CODE-MESSAGE-TYPE                                
               WHEN 80106                                               
                  MOVE '2ND NOTICE'      TO WS-CWS00136-NOTICE-TYPE     
               WHEN 90106                                               
                  MOVE '2ND NOTICE'      TO WS-CWS00136-NOTICE-TYPE     
               WHEN 80107                                               
                  MOVE '2ND NOTICE W/ RET CHECK'                        
                                         TO WS-CWS00136-NOTICE-TYPE     
               WHEN 90107                                               
                  MOVE '2ND NOTICE W/ RET CHECK'                        
                                         TO WS-CWS00136-NOTICE-TYPE     
               WHEN 90109                                               
                  MOVE 'GUARANTOR NOTICE'                               
                                         TO WS-CWS00136-NOTICE-TYPE     
               WHEN 80201                                               
                  MOVE 'EXCEPTIONAL 1ST NOTICE'                         
                                         TO WS-CWS00136-NOTICE-TYPE     
               WHEN 90201                                               
                  MOVE 'EXCEPTIONAL 1ST NOTICE'                         
                                         TO WS-CWS00136-NOTICE-TYPE     
               WHEN 80202                                               
                  MOVE 'EXCEPTIONAL 2ND NOTICE'                         
                                         TO WS-CWS00136-NOTICE-TYPE     
               WHEN 90202                                               
                  MOVE 'EXCEPTIONAL 2ND NOTICE'                         
                                         TO WS-CWS00136-NOTICE-TYPE     
               WHEN 90203                                               
                  MOVE 'DPP EARNEST NOTICE'                             
                                         TO WS-CWS00136-NOTICE-TYPE     
               WHEN 90204                                               
                  MOVE 'DEPOSIT NOTICE'                                 
                                         TO WS-CWS00136-NOTICE-TYPE     
               WHEN 90205                                               
                  MOVE 'RETURNED CHECK NOTICE 1'                        
                                         TO WS-CWS00136-NOTICE-TYPE     
               WHEN 80206                                               
                  MOVE 'RETURNED CHECK NOTICE 2'                        
                                         TO WS-CWS00136-NOTICE-TYPE     
               WHEN 90206                                               
                  MOVE 'RETURNED CHECK NOTICE 2'                        
                                         TO WS-CWS00136-NOTICE-TYPE     
               WHEN 90207                                               
                  MOVE 'CASH ONLY NOTICE'                               
                                         TO WS-CWS00136-NOTICE-TYPE     
               WHEN 90208                                               
                  MOVE 'RETURNED DRAFT NOTICE 1'                        
                                         TO WS-CWS00136-NOTICE-TYPE     
               WHEN 90209                                               
                  MOVE 'RETURNED DRAFT NOTICE 2'                        
                                         TO WS-CWS00136-NOTICE-TYPE     
           END-EVALUATE.                                                
      *                                                                         
           MOVE WS-CODE-MESSAGE-TYPE     TO WS-CWS00136-MESSAGE-NUMBER. 
           MOVE SPACES                   TO WS-CWS00136-DATE-MAIL.      
           MOVE WS-SLASHES-6             TO WS-CWS00136-DATE-MAIL.      
           MOVE WS-DATE-NOTICE-MAIL(6:2) TO WS-CWS00136-DATE-MAIL(1:2). 
           MOVE WS-DATE-NOTICE-MAIL(9:2) TO WS-CWS00136-DATE-MAIL(4:2). 
           MOVE WS-DATE-NOTICE-MAIL(1:4) TO WS-CWS00136-DATE-MAIL(7:4). 
      *                                                                         
           IF WS-DATE-NOTICE-DUE = SPACES OR LOW-VALUES                 
              MOVE 'NONE'                TO WS-CWS00136-DATE-NOTICE-DUE 
           ELSE                                                         
              MOVE WS-SLASHES-6          TO WS-CWS00136-DATE-NOTICE-DUE 
              MOVE WS-DATE-NOTICE-DUE(6:2)                              
                 TO WS-CWS00136-DATE-NOTICE-DUE(1:2)                    
              MOVE WS-DATE-NOTICE-DUE(9:2)                              
                 TO WS-CWS00136-DATE-NOTICE-DUE(4:2)                    
              MOVE WS-DATE-NOTICE-DUE(1:4)                              
                 TO WS-CWS00136-DATE-NOTICE-DUE(7:4)                    
           END-IF.                                                      
      *                                                                         
           IF WS-CODE-MESSAGE-TYPE = 90205 OR 90206 OR 80206 OR         
                                     90208 OR 90209                     
               MOVE WS-RET-CHK-PAST-DUE-AMT TO WS-HOLD-AMOUNT           
           ELSE                                                         
               MOVE WS-AMT-NOTICE TO WS-HOLD-AMOUNT                     
           END-IF.                                                      
           MOVE WS-DOL-AMOUNT TO WS-CWS00136-AMT-NOTICE-DOL.            
           MOVE WS-DEC-AMOUNT TO WS-CWS00136-AMT-NOTICE-DEC.            
      *                                                                         
           IF WS-CODE-MESSAGE-TYPE = 90203                              
              AND WS-SCND-ERNST-PAY-DT > SPACES                         
              MOVE WS-SLASHES-6        TO WS-CWS00136-SCND-ERNST-PAY-DT 
              MOVE WS-SCND-ERNST-PAY-DT(6:2)                            
                 TO WS-CWS00136-SCND-ERNST-PAY-DT(1:2)                  
              MOVE WS-SCND-ERNST-PAY-DT(9:2)                            
                 TO WS-CWS00136-SCND-ERNST-PAY-DT(4:2)                  
              MOVE WS-SCND-ERNST-PAY-DT(1:4)                            
                 TO WS-CWS00136-SCND-ERNST-PAY-DT(7:4)                  
              MOVE WS-SCND-ERNST-PAY-AMT TO WS-HOLD-AMOUNT              
              MOVE WS-DOL-AMOUNT TO WS-CWS00136-2ND-ERN-PAY-AMT-DL      
              MOVE WS-DEC-AMOUNT TO WS-CWS00136-2ND-ERN-PAY-AMT-DC      
              MOVE WS-3-LINE-FORMATTED-COMMENT                          
                                         TO WS-KR125-TRAN-CMT-TEXT      
              MOVE +159                  TO WS-KR125-TRAN-CMT-LEN       
           ELSE                                                         
              IF WS-CODE-MESSAGE-TYPE = 90109                           
                  MOVE AT-ACCOUNT-NO      TO WS-CWS00136-GUAR-TP-ACCT-NO
      *                                                                         
                  STRING                                                
                     'GUARANTEE ACCT NO: ' DELIMITED BY SIZE            
                     WS-CWS00136-GUAR-TP-ACCT-NO DELIMITED BY SIZE      
                  INTO                                                  
                     WS-CWS00136-COMMENT-LINE-3B                        
      *                                                                         
                  STRING                                                
                     WS-CWS00136-FORMATTED-COMMENT DELIMITED BY SIZE    
                     WS-CWS00136-COMMENT-LINE-3B   DELIMITED BY SIZE    
                  INTO                                                  
                     WS-KR125-TRAN-CMT-TEXT                             
                  MOVE +173               TO WS-KR125-TRAN-CMT-LEN      
              ELSE                                                      
                IF WS-CODE-MESSAGE-TYPE = (80106 OR 80107 OR 80202 OR   
                     80206 OR 90106 OR 90107 OR 90202 OR 90206)         
                   AND WS-NOTICE-AUTO-DEP-FCST-AM > 0                   
                   MOVE WS-NOTICE-AUTO-DEP-FCST-AM TO WS-HOLD-AMOUNT    
                   MOVE WS-DOL-AMOUNT TO WS-CWS00136-FRCST-AUTO-DEP-DL  
                   MOVE WS-DEC-AMOUNT TO WS-CWS00136-FRCST-AUTO-DEP-DC  
                    STRING                                              
                       WS-CWS00136-FORMATTED-COMMENT DELIMITED BY SIZE  
                       WS-CWS00136-COMMENT-LINE-3C   DELIMITED BY SIZE  
                    INTO                                                
                       WS-KR125-TRAN-CMT-TEXT                           
                    MOVE +153               TO WS-KR125-TRAN-CMT-LEN    
                ELSE                                                    
                    MOVE WS-CWS00136-FORMATTED-COMMENT                  
                                            TO WS-KR125-TRAN-CMT-TEXT   
                    MOVE +107               TO WS-KR125-TRAN-CMT-LEN    
                END-IF                                                  
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   2000-GET-CRED-PROFILE.                                       *16990000
      *     SELECT FROM CSS_CREDIT_PROCESS DATA USED TO UPDATE         *17000000
      *     THE CREDIT HISTORY.                                        *17010000
      ******************************************************************17020000
       2000-GET-CRED-PROFILE.                                           
      *                                                                 17040000
           PERFORM 7170-SELECT-CREDIT-PROFILE THRU 7170-EXIT.           
           MOVE CZ-DISCONNECT-HIST       TO WS-NEW-DISC-HIST-X.         
           MOVE CZ-DISC-EXCEPTN-HIST     TO WS-NEW-DISCEX-HIST-X.       
           MOVE CZ-NON-UTL-CR-HST        TO WS-NON-UTL-CR-HST.          
           MOVE CZ-NON-UTL-CR-HST-EX     TO WS-NON-UTL-CR-HST-EX.       
           MOVE CZ-CASH-ONLY-FL          TO WS-NOTICE-CASH-ONLY-FL.     
      *                                                                 17110000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17140000
      ******************************************************************17150000
      *   2200-PROCESS-DISC-HIST-PLUS                                  *17160000
      *    BEFORE CALLING THIS PARAGRAPH PLEASE MAKE THAT THE FIELD    *17170000
      *    CL-CODE-NOTICE-TYPE HAS BEEN SET CORRECTLY.                 *17180000
      *    MOVE EXEMPT TO THE CREDIT PROFILE FOR A REGULAR ACCOUNT OR  *17190000
      *    MOVE EXEMPT TO THE CREDIT PROFILE FOR A SPECIAL ACCOUNT.    *17200000
      ******************************************************************17210000
       2200-PROCESS-DISC-HIST-PLUS.                                     
      *                                                                 17230000
           IF CL-CODE-NOTICE-TYPE = 'C'                                 
              MOVE CZ-DISCONNECT-HIST TO WS-OLD-DISC-HIST               
              MOVE 'Y'                TO WS-DISCONNECT-FLAG             
              MOVE WS-E               TO WS-NEW-DISC-HIST-X(1:1)        
           ELSE                                                         
              MOVE CZ-DISC-EXCEPTN-HIST TO WS-OLD-DISCEX-HIST           
              MOVE 'Y'                  TO WS-EXCEPTIONAL-FLAG          
              MOVE WS-E                 TO WS-NEW-DISCEX-HIST-X(1:1)    
           END-IF.                                                      
      *                                                                 17330000
           MOVE WS-NEW-DISC-HIST-X     TO CZ-DISCONNECT-HIST.           
           MOVE WS-NEW-DISCEX-HIST-X   TO CZ-DISC-EXCEPTN-HIST.         
           PERFORM 8520-UPDATE-CREDIT-PROFILE       THRU 8520-EXIT.     
           PERFORM 5525-MAINT-TRANS-HIST            THRU 5525-EXIT.     
           PERFORM 5550-MOVE-HIST-DETAILS           THRU 5550-EXIT.     
      *                                                                 17390000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17420000
      ******************************************************************17430000
      * 3040-DEL-NOTICE-GET-DNP-TYP                                    *17440000
      * THIS MODULE (1) DELETES THE NOTICE THAT IS NOT BEING MAILED    *17450000
      * (2) DELETES THE DNP.                                           *17460000
ACT356* IN 1455 USD CL-DATE-NOTICE-MAIL TO CALCULATE DAYS.             *        
      ******************************************************************17480000
       3040-DEL-NOTICE-GET-DNP-TYP.                                     
      *                                                                 17500000
           PERFORM 8650-DELETE-CRED-COLL THRU 8650-EXIT.                
      *                                                                 17520000
           IF CL-CODE-NOTICE-TYPE = WS-C                                
               MOVE WS-D              TO CL-CODE-NOTICE-TYPE            
               PERFORM 7025-SELECT-CODE-DNP-TYPE      THRU 7025-EXIT    
               PERFORM 8650-DELETE-CRED-COLL          THRU 8650-EXIT    
                                                                        
               MOVE WS-S              TO CL-CODE-NOTICE-TYPE            
               PERFORM 8650-DELETE-CRED-COLL          THRU 8650-EXIT    
           END-IF.                                                      
      *                                                                 17610000
           IF CL-CODE-NOTICE-TYPE = WS-E                                
               MOVE WS-F              TO CL-CODE-NOTICE-TYPE            
               PERFORM 7025-SELECT-CODE-DNP-TYPE      THRU 7025-EXIT    
               PERFORM 8650-DELETE-CRED-COLL          THRU 8650-EXIT    
      *                                                                 17660000
               MOVE WS-G              TO CL-CODE-NOTICE-TYPE            
               PERFORM 8650-DELETE-CRED-COLL          THRU 8650-EXIT    
                                                                        
               MOVE WS-T              TO CL-CODE-NOTICE-TYPE            
               PERFORM 8650-DELETE-CRED-COLL          THRU 8650-EXIT    
                                                                        
               MOVE WS-U              TO CL-CODE-NOTICE-TYPE            
               PERFORM 8650-DELETE-CRED-COLL          THRU 8650-EXIT    
           END-IF.                                                      
      *                                                                 17760000
           IF CL-CODE-NOTICE-TYPE = WS-F                                
               MOVE WS-G              TO CL-CODE-NOTICE-TYPE            
               PERFORM 7025-SELECT-CODE-DNP-TYPE      THRU 7025-EXIT    
               PERFORM 8650-DELETE-CRED-COLL          THRU 8650-EXIT    
                                                                        
               MOVE WS-U              TO CL-CODE-NOTICE-TYPE            
               PERFORM 8650-DELETE-CRED-COLL          THRU 8650-EXIT    
           END-IF.                                                      
      *                                                                 17850000
           IF CL-CODE-NOTICE-TYPE = WS-N                                
               MOVE WS-H              TO CL-CODE-NOTICE-TYPE            
               PERFORM 7025-SELECT-CODE-DNP-TYPE      THRU 7025-EXIT    
               PERFORM 8650-DELETE-CRED-COLL          THRU 8650-EXIT    
               MOVE WS-V              TO CL-CODE-NOTICE-TYPE            
               PERFORM 8650-DELETE-CRED-COLL          THRU 8650-EXIT    
               MOVE WS-W              TO CL-CODE-NOTICE-TYPE            
               PERFORM 8650-DELETE-CRED-COLL          THRU 8650-EXIT    
           END-IF.                                                      
      *                                                                 17950000
           IF CL-CODE-NOTICE-TYPE = WS-O                                
               MOVE WS-I              TO CL-CODE-NOTICE-TYPE            
               PERFORM 7025-SELECT-CODE-DNP-TYPE      THRU 7025-EXIT    
               PERFORM 8650-DELETE-CRED-COLL          THRU 8650-EXIT    
           END-IF.                                                      
      *                                                                 18010000
      *                                                                 18110000
       3040-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18140000
      ******************************************************************18150000
      * 3200-CALC-AMOUNTS-DATES                                        *18160000
      * PERFORM ROUTINE THAT CALCULATES DNP-BAL, ARREARS, PAST DUE     *18170000
      * ETC, AND MOVE VALUES TO CWS10007 FOR USE BY OTHER PROGRAMS     *18180000
      ******************************************************************18190000
       3200-CALC-AMOUNTS-DATES.                                         
      *                                                                 18210000
           MOVE 'N' TO WS-NOTICE-READY.                                 
      *SET CPD00068 SWITCHES THAT ARE NEEDED                            18230000
           MOVE 'Y'        TO CALC-ARREARS-SW                           
                              CALC-BALANCE-SW                           
                              CALC-PAST-DUE-SW                          
                              LOAD-DNP-DATE-SW                          
                              LOAD-DUE-DATES-SW                         
                              LOAD-WS-AMOUNTS-SW.                       
           MOVE 'PCSCA132' TO WS-CPD00068-CALLING-PGM.                  
           MOVE SPACES     TO  ABEND-FUNCTION.                          
           CALL SCSCB068  USING  CWS00068-FIELDS,                       
                                 WS-CODES-DATA-PRESENT,                 
                                 DCLCSS-ACCOUNT,                        
                                 ABEND-FILE,                            
                                 RS-RETURN-CODE.                        
           MOVE 'PCSKR200' TO PROGRAM-NAME.                             
           IF  ABEND-FUNCTION  > SPACES                                 
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                 18410000
ACT021*** THE FOLLOWING CODE IS NEEDED TO PREVENT CREATING MULTIPLE     18380000
ACT021*** 90201/80201 NOTICES BECAUSE CPD00068 POPULATES THE            18380000
ACT021*** WS-DATE-NOTICE-MAIL-E FIELD AND WS-DATE-NOTICE-MAIL-E IS      18380000
ACT021*** PROCESSED BEFORE THE WS-DATE-NOTICE-MAIL-F FIELD IN           18380000
ACT021*** 1200-NOTICE-SETUP.                                            18380000
ACT021     IF (WS-PREV-MESS-TYPE-WRKD = '90201'                         
ACT021       OR WS-PREV-MESS-TYPE-WRKD = '80201')                       
ACT021       AND CL-ACCOUNT-NO = WS-PREV-ACCT-NO-WRKD                   
ACT021         INITIALIZE WS-DATE-NOTICE-MAIL-E                         
ACT021     END-IF.                                                      
ACT021*                                                                 18410000
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18470000
      ******************************************************************18480000
      * 4900-GET-WQ-GEN-FL                                             *18490000
      * 5200-SEARCH-WQ-PGM-CNTL-TBL                                    *18500000
      ******************************************************************18510000
           EXEC SQL                                                     18520000
              INCLUDE CPD00346                                          18530000
           END-EXEC.                                                    18540000
      *                                                                 18550000
      ******************************************************************18560000
      * 5200-CHK-SKIP-ACCTS                                      *      18570000
      ******************************************************************18580000
           EXEC SQL                                                     18590000
               INCLUDE CPD00347                                         18600000
           END-EXEC.                                                    18610000
      *                                                                 18620000
      ***************************************************************** 18630000
      * 5525-MAINT-TRANS-HIST.                                        * 18640000
      ***************************************************************** 18650000
       5525-MAINT-TRANS-HIST.                                           
      *                                                                 18670000
           PERFORM 7240-SET-MH-DATE-TIME         THRU 7240-EXIT.        
           MOVE 'F'                           TO MH-CODE-TRAN-TYPE.     
           MOVE SPACES                        TO MH-RESP-AREA-ID.       
           MOVE AT-ACCOUNT-NO                 TO MH-ACCOUNT-NO.         
           MOVE ZEROS                         TO MH-CUSTOMER-NO         
                                                 MH-PREMISE-NO.         
           MOVE 'SYSTEM'                      TO MH-USER-ID.            
           MOVE 'PCSKR200'                    TO MH-APPL-PROGRAM-ID.    
           MOVE WS-DNP-HIST-TRANS-CMNT        TO MH-TRAN-COMMENT-TEXT.  
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                         TO MH-TRAN-COMMENT-LEN.        
       5525-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18810000
      ******************************************************************18820000
      *  5550-MOVE-HIST-DETAILS                                        *18830000
      ******************************************************************18840000
       5550-MOVE-HIST-DETAILS.                                          
      *                                                                 18860000
           ADD 1                         TO WS-TRAN-APPL-NO.            
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
           MOVE SPACES                   TO MI-TABLE-ID.                
           IF WS-DISCONNECT-FLAG     = 'Y'                              
              MOVE 'N'                   TO WS-DISCONNECT-FLAG          
              MOVE WS-OLD-DISC-HIST      TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE WS-DISCONNECT-DESC    TO MI-COLUMN-DESC              
              MOVE CZ-DISCONNECT-HIST    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF WS-OLD-DISC-HIST                           
                                         TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE LENGTH OF CZ-DISCONNECT-HIST                         
                                         TO MI-CHG-COLUMN-VALUE-LEN     
           END-IF.                                                      
           IF WS-EXCEPTIONAL-FLAG     = 'Y'                             
              MOVE 'N'                   TO WS-EXCEPTIONAL-FLAG         
              MOVE WS-OLD-DISCEX-HIST    TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE WS-DISC-EXCEPTN-DESC  TO MI-COLUMN-DESC              
              MOVE CZ-DISC-EXCEPTN-HIST  TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF WS-OLD-DISCEX-HIST                         
                                         TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE LENGTH OF CZ-DISC-EXCEPTN-HIST                       
                                         TO MI-CHG-COLUMN-VALUE-LEN     
           END-IF.                                                      
      * NEED TO CHANGE COMMENT IF 'E' OR 'B'                            19110000
      * COMMENT HAS ALREADY BEEN SET IN OTHER PLACES                    19120000
ACT210     EVALUATE WS-REASON-NOT-DNP                                   
               WHEN WS-E                                                
                    MOVE WS-CURRENT-DNP-STATUS-E TO WS-DNP-COMMENT      
                    MOVE WS-DNP-HIST-TRANS-CMNT                         
                                         TO MH-TRAN-COMMENT-TEXT        
                    MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                 
                                         TO MH-TRAN-COMMENT-LEN         
               WHEN WS-B                                                
                    MOVE WS-CURRENT-DNP-STATUS-B TO WS-DNP-COMMENT      
                    MOVE WS-DNP-HIST-TRANS-CMNT                         
                                         TO MH-TRAN-COMMENT-TEXT        
                    MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                 
                                         TO MH-TRAN-COMMENT-LEN         
           END-EVALUATE.                                                
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
      *                                                                 19280000
       5550-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19370000
      ******************************************************************19380000
      * 6240-GET-FCA00-COMMON-DATE                                     *19390000
      * CPD00040   G E T   F C A 0 0   C O M M O N   D A T E           *19400000
      ******************************************************************19410000
           EXEC SQL                                                     19420000
                INCLUDE CPD00040                                        19430000
           END-EXEC.                                                    19440000
      *                                                                 19450000
      ******************************************************************19460000
      * 6251-GET-FJC01-DATE                                            *19470000
      * CPD00037   COPYBOOK TO READ PARM FILE FOR OVERRIDE DATE        *19480000
      ******************************************************************19490000
           EXEC SQL                                                     19500000
                INCLUDE CPD00037                                        19510000
           END-EXEC.                                                    19520000
      *                                                                 19530000
      ******************************************************************19540000
      *    6500-GET-NEXT-BUSINESS-DAY                                 **19550000
      *    FINDS THE NEXT BUSINESS DAY, FROM THE CSS_BUSINESS_DAYS    **19560000
      *    TABLE                                                      **19570000
      ******************************************************************19580000
           EXEC SQL                                                     19590000
              INCLUDE CPD00322                                          19600000
           END-EXEC.                                                    19610000
      *                                                                 19620000
      ******************************************************************19630000
      * 6530-LOAD-MNT-TRANS-HIST                                      * 19640000
      * 6540-INSERT-MNT-TRANS-HIST                                     *19650000
      * 6550-INSERT-MT-TRN-HST-DET                                     *19660000
      ******************************************************************19670000
           EXEC SQL                                                     19680000
               INCLUDE CPD00067                                         19690000
           END-EXEC.                                                    19700000
      *                                                                 19710000
      ******************************************************************19720000
      *  7000-OPEN-MAIN1-ACCT-CSR                                      *19730000
      ******************************************************************19740000
       7000-OPEN-MAIN1-ACCT-CSR.                                        
      *                                                                 19760000
           EXEC SQL                                                     
              OPEN ACTIVE_ACCT_CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19800000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 19820000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** ACCOUNT AND CRED_COLL TABLES        '         
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7000 OPEN:  RETURN CODE ERROR - OPEN   '      
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                 19930000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19960000
      ******************************************************************19970000
      *  7001-FETCH-MAIN1-ACCT-CSR                                     *19980000
      ******************************************************************19990000
       7001-FETCH-MAIN1-ACCT-CSR.                                       
      *                                                                 20010000
           EXEC SQL                                                     
              FETCH ACTIVE_ACCT_CURSOR INTO                             
                 :AT-CUSTOMER-NO                                        
                ,:AT-ACCOUNT-NO                                         
                ,:AT-PREMISE-NO                                         
                ,:AT-COMPANY-NO                                         
                ,:AT-LOCAL-OFFICE                                       
                ,:AT-DATE-BILL-DAY-00 :WS-DATE-BILL-DAY-00-NULL         
                ,:AT-DATE-BILL-DAY-30 :WS-DATE-BILL-DAY-30-NULL         
                ,:AT-DATE-BILL-DAY-60 :WS-DATE-BILL-DAY-60-NULL         
                ,:AT-DATE-BILL-DAY-90 :WS-DATE-BILL-DAY-90-NULL         
                ,:AT-DATE-LAST-ACTION                                   
                ,:AT-CODES-DATA-PRESENT                                 
                ,:AT-BILL-CYCLE                                         
                ,:AT-ADDRESS-FORMAT                                     
                ,:AT-ADDRESS-ID                                         
                ,:AT-TOTAL-AR-BALANCE                                   
                ,:AT-LAST-PYMT-AMOUNT                                   
                ,:AT-LAST-PYMT-DATE :WS-LAST-PYMT-DATE-NULL             
                ,:AT-CODE-ACCT-STAT                                     
                ,:AT-CODE-STATUS-REASON                                 
                ,:AT-CREDIT-GROUP                                       
                ,:AT-ACCOUNT-TYPE-CODE                                  
                ,:AT-BANKRUPTCY-IND                                     
                ,:AT-JUDGEMENT-CASE-NO                                  
                ,:AT-NOTICE-EXEMPT-CD                                   
                ,:AT-IVR-EXEMPT-CD                                      
                ,:AT-CODE-DISC-OK                                       
                ,:CL-DATE-NOTICE-MAIL :WS-DATE-NOTICE-MAIL-NULL         
                ,:CL-CODE-NOTICE-TYPE                                   
                ,:CL-CODE-MESSAGE-TYPE                                  
P0599I          ,:CL-ITEM-ID                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20340000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 20360000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'Y' TO WS-NO-MORE-DATA                            
                 GO TO 7001-EXIT                                        
              END-IF                                                    
              IF WS-DATE-BILL-DAY-00-NULL < 0                           
                 MOVE SPACES TO AT-DATE-BILL-DAY-00                     
                 MOVE ZEROES TO WS-DATE-BILL-DAY-00-NULL                
              END-IF                                                    
              IF WS-DATE-BILL-DAY-30-NULL < 0                           
                 MOVE SPACES TO AT-DATE-BILL-DAY-30                     
                 MOVE ZEROES TO WS-DATE-BILL-DAY-30-NULL                
              END-IF                                                    
              IF WS-DATE-BILL-DAY-60-NULL < 0                           
                 MOVE SPACES TO AT-DATE-BILL-DAY-60                     
                 MOVE ZEROES TO WS-DATE-BILL-DAY-60-NULL                
              END-IF                                                    
              IF WS-DATE-BILL-DAY-90-NULL < 0                           
                 MOVE SPACES TO AT-DATE-BILL-DAY-90                     
                 MOVE ZEROES TO WS-DATE-BILL-DAY-90-NULL                
              END-IF                                                    
              IF WS-LAST-PYMT-DATE-NULL < 0                             
                 MOVE SPACES TO AT-LAST-PYMT-DATE                       
                 MOVE ZEROES TO WS-LAST-PYMT-DATE-NULL                  
              END-IF                                                    
              IF WS-DATE-NOTICE-MAIL-NULL < 0                           
                 MOVE SPACES TO CL-DATE-NOTICE-MAIL                     
                 MOVE ZEROES TO WS-DATE-NOTICE-MAIL-NULL                
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** ACCOUNT AND CRED_COLL TABLES        '         
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7001 FETCH: RETURN CODE ERROR - FETCH  '      
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                 20740000
       7001-EXIT.                                                       
           EXIT.                                                        
     *                                                                  
      ******************************************************************20780000
      *  7002-CLOSE-MAIN1-ACCT-CSR                                     *20790000
      ******************************************************************20800000
       7002-CLOSE-MAIN1-ACCT-CSR.                                       
      *                                                                 20820000
           EXEC SQL                                                     
              CLOSE ACTIVE_ACCT_CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20860000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 20880000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** ACCOUNT AND CRED_COLL TABLES        '         
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7002 CLOSE:  RETURN CODE ERROR - CLOSE  '     
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                 20990000
       7002-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21020000
      ******************************************************************21030000
      *  7010-OPEN-MAIN2-ACCT-CSR                                      *21040000
      ******************************************************************21050000
       7010-OPEN-MAIN2-ACCT-CSR.                                        
      *                                                                 21070000
           EXEC SQL                                                     
              OPEN PND_FB_ACCT_CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21110000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 21130000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** ACCOUNT AND CRED_COLL TABLES        '         
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7010 OPEN:  RETURN CODE ERROR - OPEN   '      
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                 21240000
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21270000
      ******************************************************************21280000
      *  7011-FETCH-MAIN2-ACCT-CSR                                     *21290000
      ******************************************************************21300000
       7011-FETCH-MAIN2-ACCT-CSR.                                       
      *                                                                 21320000
           EXEC SQL                                                     
              FETCH PND_FB_ACCT_CURSOR INTO                             
                 :AT-CUSTOMER-NO                                        
                ,:AT-ACCOUNT-NO                                         
                ,:AT-PREMISE-NO                                         
                ,:AT-COMPANY-NO                                         
                ,:AT-LOCAL-OFFICE                                       
                ,:AT-DATE-BILL-DAY-00 :WS-DATE-BILL-DAY-00-NULL         
                ,:AT-DATE-BILL-DAY-30 :WS-DATE-BILL-DAY-30-NULL         
                ,:AT-DATE-BILL-DAY-60 :WS-DATE-BILL-DAY-60-NULL         
                ,:AT-DATE-BILL-DAY-90 :WS-DATE-BILL-DAY-90-NULL         
                ,:AT-DATE-LAST-ACTION                                   
                ,:AT-CODES-DATA-PRESENT                                 
                ,:AT-BILL-CYCLE                                         
                ,:AT-ADDRESS-FORMAT                                     
                ,:AT-ADDRESS-ID                                         
                ,:AT-TOTAL-AR-BALANCE                                   
                ,:AT-LAST-PYMT-AMOUNT                                   
                ,:AT-LAST-PYMT-DATE :WS-LAST-PYMT-DATE-NULL             
                ,:AT-CODE-ACCT-STAT                                     
                ,:AT-CODE-STATUS-REASON                                 
                ,:AT-CREDIT-GROUP                                       
                ,:AT-ACCOUNT-TYPE-CODE                                  
                ,:AT-BANKRUPTCY-IND                                     
                ,:AT-JUDGEMENT-CASE-NO                                  
                ,:AT-NOTICE-EXEMPT-CD                                   
                ,:AT-IVR-EXEMPT-CD                                      
                ,:AT-CODE-DISC-OK                                       
                ,:CL-DATE-NOTICE-MAIL :WS-DATE-NOTICE-MAIL-NULL         
                ,:CL-CODE-NOTICE-TYPE                                   
                ,:CL-CODE-MESSAGE-TYPE                                  
P0599I          ,:CL-ITEM-ID                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21650000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 21670000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'Y' TO WS-NO-MORE-DATA                            
                 GO TO 7011-EXIT                                        
              END-IF                                                    
              IF WS-DATE-BILL-DAY-00-NULL < 0                           
                 MOVE SPACES TO AT-DATE-BILL-DAY-00                     
                 MOVE ZEROES TO WS-DATE-BILL-DAY-00-NULL                
              END-IF                                                    
              IF WS-DATE-BILL-DAY-30-NULL < 0                           
                 MOVE SPACES TO AT-DATE-BILL-DAY-30                     
                 MOVE ZEROES TO WS-DATE-BILL-DAY-30-NULL                
              END-IF                                                    
              IF WS-DATE-BILL-DAY-60-NULL < 0                           
                 MOVE SPACES TO AT-DATE-BILL-DAY-60                     
                 MOVE ZEROES TO WS-DATE-BILL-DAY-60-NULL                
              END-IF                                                    
              IF WS-DATE-BILL-DAY-90-NULL < 0                           
                 MOVE SPACES TO AT-DATE-BILL-DAY-90                     
                 MOVE ZEROES TO WS-DATE-BILL-DAY-90-NULL                
              END-IF                                                    
              IF WS-LAST-PYMT-DATE-NULL < 0                             
                 MOVE SPACES TO AT-LAST-PYMT-DATE                       
                 MOVE ZEROES TO WS-LAST-PYMT-DATE-NULL                  
              END-IF                                                    
              IF WS-DATE-NOTICE-MAIL-NULL < 0                           
                 MOVE SPACES TO CL-DATE-NOTICE-MAIL                     
                 MOVE ZEROES TO WS-DATE-NOTICE-MAIL-NULL                
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** ACCOUNT AND CRED_COLL TABLES        '         
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7011 FETCH: RETURN CODE ERROR - FETCH  '      
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                 22050000
       7011-EXIT.                                                       
           EXIT.                                                        
     *                                                                  
      ******************************************************************22090000
      *  7012-CLOSE-MAIN2-ACCT-CSR                                     *22100000
      ******************************************************************22110000
       7012-CLOSE-MAIN2-ACCT-CSR.                                       
      *                                                                 22130000
           EXEC SQL                                                     
              CLOSE PND_FB_ACCT_CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22170000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 22190000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** ACCOUNT AND CRED_COLL TABLES        '         
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7012 CLOSE:  RETURN CODE ERROR - CLOSE  '     
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                 22300000
       7012-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22330000
A04460******************************************************************        
A04460*  7015-OPEN-MAIN3-ACCT-CSR                                      *        
A04460******************************************************************        
A04460 7015-OPEN-MAIN3-ACCT-CSR.                                        
A04460*                                                                         
A04460     EXEC SQL                                                     
A04460        OPEN DEPOSIT_BILL_IMMEDIATE                               
A04460     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04460*                                                                         
A04460     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A04460     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A04460        NEXT SENTENCE                                             
A04460     ELSE                                                         
A04460        DISPLAY '******************************************'      
A04460        DISPLAY '** ACCOUNT AND CRED_COLL TABLES        '         
A04460        DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
A04460        DISPLAY '** 7015 OPEN:  RETURN CODE ERROR - OPEN   '      
A04460        DISPLAY '******************************************'      
A04460        PERFORM 9900-SQL-ERROR-ROUTINE                            
A04460     END-IF.                                                      
      *                                                                         
A04460 7015-EXIT.                                                       
A04460     EXIT.                                                        
A04460*                                                                         
A04460******************************************************************        
A04460*  7016-FETCH-MAIN3-ACCT-CSR                                     *        
A04460******************************************************************        
A04460 7016-FETCH-MAIN3-ACCT-CSR.                                       
A04460*                                                                         
A04460     EXEC SQL                                                     
A04460        FETCH DEPOSIT_BILL_IMMEDIATE INTO                         
A04460           :AT-CUSTOMER-NO                                        
A04460          ,:AT-ACCOUNT-NO                                         
A04460          ,:AT-PREMISE-NO                                         
A04460          ,:AT-COMPANY-NO                                         
A04460          ,:AT-LOCAL-OFFICE                                       
A04460          ,:AT-DATE-BILL-DAY-00 :WS-DATE-BILL-DAY-00-NULL         
A04460          ,:AT-DATE-BILL-DAY-30 :WS-DATE-BILL-DAY-30-NULL         
A04460          ,:AT-DATE-BILL-DAY-60 :WS-DATE-BILL-DAY-60-NULL         
A04460          ,:AT-DATE-BILL-DAY-90 :WS-DATE-BILL-DAY-90-NULL         
A04460          ,:AT-DATE-LAST-ACTION                                   
A04460          ,:AT-CODES-DATA-PRESENT                                 
A04460          ,:AT-BILL-CYCLE                                         
A04460          ,:AT-ADDRESS-FORMAT                                     
A04460          ,:AT-ADDRESS-ID                                         
A04460          ,:AT-TOTAL-AR-BALANCE                                   
A04460          ,:AT-LAST-PYMT-AMOUNT                                   
A04460          ,:AT-LAST-PYMT-DATE :WS-LAST-PYMT-DATE-NULL             
A04460          ,:AT-CODE-ACCT-STAT                                     
A04460          ,:AT-CODE-STATUS-REASON                                 
A04460          ,:AT-CREDIT-GROUP                                       
A04460          ,:AT-ACCOUNT-TYPE-CODE                                  
A04460          ,:AT-BANKRUPTCY-IND                                     
A04460          ,:AT-JUDGEMENT-CASE-NO                                  
A04460          ,:AT-NOTICE-EXEMPT-CD                                   
A04460          ,:AT-IVR-EXEMPT-CD                                      
A04460          ,:AT-CODE-DISC-OK                                       
A04460          ,:CL-DATE-NOTICE-MAIL :WS-DATE-NOTICE-MAIL-NULL         
A04460          ,:CL-CODE-SPECIAL-TYPE                                  
A04460          ,:CL-CODE-NOTICE-TYPE                                   
A04460          ,:CL-CODE-MESSAGE-TYPE                                  
A04460          ,:CL-ITEM-ID                                            
A04460          ,:CL-DATE-NOTICE-DUE :WS-DATE-NOTICE-DUE-NULL           
A04460     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A04460     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A04460     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A04460        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
A04460           MOVE 'Y' TO WS-NO-MORE-DATA                            
A04460           GO TO 7016-EXIT                                        
A04460        END-IF                                                    
A04460        IF WS-DATE-BILL-DAY-00-NULL < 0                           
A04460           MOVE SPACES TO AT-DATE-BILL-DAY-00                     
A04460           MOVE ZEROES TO WS-DATE-BILL-DAY-00-NULL                
A04460        END-IF                                                    
A04460        IF WS-DATE-BILL-DAY-30-NULL < 0                           
A04460           MOVE SPACES TO AT-DATE-BILL-DAY-30                     
A04460           MOVE ZEROES TO WS-DATE-BILL-DAY-30-NULL                
A04460        END-IF                                                    
A04460        IF WS-DATE-BILL-DAY-60-NULL < 0                           
A04460           MOVE SPACES TO AT-DATE-BILL-DAY-60                     
A04460           MOVE ZEROES TO WS-DATE-BILL-DAY-60-NULL                
A04460        END-IF                                                    
A04460        IF WS-DATE-BILL-DAY-90-NULL < 0                           
A04460           MOVE SPACES TO AT-DATE-BILL-DAY-90                     
A04460           MOVE ZEROES TO WS-DATE-BILL-DAY-90-NULL                
A04460        END-IF                                                    
A04460        IF WS-LAST-PYMT-DATE-NULL < 0                             
A04460           MOVE SPACES TO AT-LAST-PYMT-DATE                       
A04460           MOVE ZEROES TO WS-LAST-PYMT-DATE-NULL                  
A04460        END-IF                                                    
A04460        IF WS-DATE-NOTICE-MAIL-NULL < 0                           
A04460           MOVE SPACES TO CL-DATE-NOTICE-MAIL                     
A04460           MOVE ZEROES TO WS-DATE-NOTICE-MAIL-NULL                
A04460        END-IF                                                    
A04460        IF WS-DATE-NOTICE-DUE-NULL < 0                            
A04460           MOVE SPACES TO CL-DATE-NOTICE-DUE                      
A04460           MOVE ZEROES TO WS-DATE-NOTICE-DUE-NULL                 
A04460        END-IF                                                    
A04460     ELSE                                                         
A04460        DISPLAY '******************************************'      
A04460        DISPLAY '** ACCOUNT AND CRED_COLL TABLES        '         
A04460        DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
A04460        DISPLAY '** 7016 FETCH: RETURN CODE ERROR - FETCH  '      
A04460        DISPLAY '******************************************'      
A04460        PERFORM 9900-SQL-ERROR-ROUTINE                            
A04460     END-IF.                                                      
A04460*                                                                         
A04460 7016-EXIT.                                                       
A04460     EXIT.                                                        
      *                                                                         
A04460******************************************************************        
A04460*  7017-CLOSE-MAIN3-ACCT-CSR                                     *        
A04460******************************************************************        
A04460 7017-CLOSE-MAIN3-ACCT-CSR.                                       
A04460*                                                                         
A04460     EXEC SQL                                                     
A04460        CLOSE DEPOSIT_BILL_IMMEDIATE                              
A04460     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04460*                                                                         
A04460     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04460*                                                                         
A04460     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A04460        NEXT SENTENCE                                             
A04460     ELSE                                                         
A04460        DISPLAY '******************************************'      
A04460        DISPLAY '** ACCOUNT AND CRED_COLL TABLES        '         
A04460        DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
A04460        DISPLAY '** 7017 CLOSE:  RETURN CODE ERROR - CLOSE  '     
A04460        DISPLAY '******************************************'      
A04460        PERFORM 9900-SQL-ERROR-ROUTINE                            
A04460     END-IF.                                                      
A04460*                                                                         
A04460 7017-EXIT.                                                       
A04460     EXIT.                                                        
A04460*                                                                         
      ******************************************************************22340000
      *  7020-SELECT-PREMISE                                           *22350000
      ******************************************************************22360000
       7020-SELECT-PREMISE.                                             
      *                                                                 22380000
           EXEC SQL                                                     
              SELECT                                                    
                  PREMISE_NO                                            
                 ,REV_DISTRICT_CD                                       
              INTO                                                      
                  :PR-PREMISE-NO                                        
                 ,:PR-REV-DISTRICT-CD                                   
              FROM CSS_PREMISE WITH(READUNCOMMITTED)                            
              WHERE PREMISE_NO = :PR-PREMISE-NO                         
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     22390000
MFA-TR*       SELECT                                                    22400000
MFA-TR*           PREMISE_NO                                            22410000
MFA-TR*          ,REV_DISTRICT_CD                                       22420000
MFA-TR*       INTO                                                      22430000
MFA-TR*           :PR-PREMISE-NO                                        22440000
MFA-TR*          ,:PR-REV-DISTRICT-CD                                   22450000
MFA-TR*       FROM CSS_PREMISE                                          22460000
MFA-TR*       WHERE PREMISE_NO = :PR-PREMISE-NO                         22470000
MFA-TR*       QUERYNO 7020                                              22480000
MFA-TR*       WITH UR                                                   22490000
MFA-TR*    END-EXEC.                                                    22500000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22510000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** PREMISE TABLE                          '      
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** PREMISE NO = ' PR-PREMISE-NO                  
              DISPLAY '** 7020 :  RETURN CODE ERROR - SELECT     '      
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                 22640000
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22670000
      ******************************************************************22680000
      *  7025-SELECT-CODE-DNP-TYPE                                     *22690000
      ******************************************************************22700000
       7025-SELECT-CODE-DNP-TYPE.                                       
      *                                                                 22720000
           EXEC SQL                                                     
              SELECT                                                    
                  CODE_SPECIAL_TYPE                                     
              INTO                                                      
                  :CL-CODE-SPECIAL-TYPE                                 
              FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO = :CL-ACCOUNT-NO                         
                AND CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE             
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     22730000
MFA-TR*       SELECT                                                    22740000
MFA-TR*           CODE_SPECIAL_TYPE                                     22750000
MFA-TR*       INTO                                                      22760000
MFA-TR*           :CL-CODE-SPECIAL-TYPE                                 22770000
MFA-TR*       FROM CSS_CRED_COLL                                        22780000
MFA-TR*       WHERE ACCOUNT_NO = :CL-ACCOUNT-NO                         22790000
MFA-TR*         AND CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE             22800000
MFA-TR*       QUERYNO 7025                                              22810000
MFA-TR*       WITH UR                                                   22820000
MFA-TR*    END-EXEC.                                                    22830000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22840000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 22860000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CRED_COLL TABLE                        '      
              DISPLAY '** ACCOUNT NO  = ' CL-ACCOUNT-NO                 
              DISPLAY '** NOTICE TYPE = ' CL-CODE-NOTICE-TYPE           
              DISPLAY '** 7025 :  RETURN CODE ERROR - SELECT     '      
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                 22980000
       7025-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23010000
      ******************************************************************23020000
      *  7030-OPEN-GUARANTOR                                           *23030000
      ******************************************************************23040000
       7030-OPEN-GUARANTOR.                                             
      *                                                                 23060000
           EXEC SQL                                                     
              OPEN GUARANTOR_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23100000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 23120000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** GUARANTOR, ACCOUNT TABLE                '     
              DISPLAY '** ACCOUNT NO = ' GU-ACCOUNT-NO                  
              DISPLAY '** 7030 :  RETURN CODE ERROR - OPEN   '          
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                 23230000
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23260000
      ******************************************************************23270000
      *  7035-FETCH-GUARANTOR                                          *23280000
      ******************************************************************23290000
       7035-FETCH-GUARANTOR.                                            
      *                                                                 23310000
           EXEC SQL                                                     
              FETCH GUARANTOR_CURSOR INTO                               
                :GU-GUARNTR-ACCT-NO                                     
ACT145         ,:GU-ADDRESS-ID                                          
ACT145         ,:AT-ADDRESS-ID                                          
ACT145         ,:AT-ADDRESS-FORMAT                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23360000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 23380000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
                NEXT SENTENCE                                           
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** GUARANTOR, ACCOUNT TABLE               '      
              DISPLAY '** ACCOUNT NO = ' GU-ACCOUNT-NO                  
              DISPLAY '** 7035 : RETURN CODE ERROR - FETCH       '      
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                 23490000
       7035-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23520000
      ******************************************************************23530000
      *  7040-CLOSE-GUARANTOR                                          *23540000
      ******************************************************************23550000
       7040-CLOSE-GUARANTOR.                                            
      *                                                                 23570000
           EXEC SQL                                                     
              CLOSE GUARANTOR_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23610000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 23630000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** GUARANTOR, ACCOUNT TABLE               '      
              DISPLAY '** ACCOUNT NO = ' GU-ACCOUNT-NO                  
              DISPLAY '** 7040 :  RETURN CODE ERROR - CLOSE      '      
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                 23740000
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23770000
      ******************************************************************23780000
      *  7060-OPEN-THIRD-PTY-CURSOR                                    *15013300
      ******************************************************************        
       7060-OPEN-THIRD-PTY-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              OPEN THIRD_PARTY                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CSS_THD_PRTY TABLE                     '      
              DISPLAY '** ACCOUNT NO = ' ZW-ACCOUNT-NO                  
              DISPLAY '** THD PRTY STATUS = ' ZW-THD-PRTY-STATUS        
              DISPLAY '** 7060 :  RETURN CODE ERROR - OPEN       '      
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7061-FETCH-THIRD-PTY.                                         *15013300
      ******************************************************************        
       7061-FETCH-THIRD-PTY.                                            
      *                                                                         
           EXEC SQL                                                     
              FETCH THIRD_PARTY INTO                                    
                :ZW-THD-PRTY-ID,                                        
                :ZW-NAME-ID,                                            
                :ZW-ADDRESS-ID                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** 7061 :  RETURN CODE ERROR - FETCH      '      
              DISPLAY '** CSS_THD_PRTY TABLE                     '      
              DISPLAY '** ACCOUNT NO = ' ZW-ACCOUNT-NO                  
              DISPLAY '** THD PRTY STATUS = ' ZW-THD-PRTY-STATUS        
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                         
       7061-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7062-CLOSE-THIRD-PTY                                          *15013300
      ******************************************************************        
       7062-CLOSE-THIRD-PTY.                                            
      *                                                                         
           EXEC SQL                                                     
              CLOSE THIRD_PARTY                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CSS_THD_PRTY TABLE                     '      
              DISPLAY '** ACCOUNT NO = ' ZW-ACCOUNT-NO                  
              DISPLAY '** THD PRTY STATUS = ' ZW-THD-PRTY-STATUS        
              DISPLAY '** 7062 :  RETURN CODE ERROR - CLOSE      '      
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                         
       7062-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7109-OPEN-CRED-COLL-CSR                                       *23790000
      ******************************************************************23800000
       7109-OPEN-CRED-COLL-CSR.                                         
      *                                                                 23820000
           EXEC SQL                                                     
              OPEN CRED_COLL_N_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23860000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 23880000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CRED_COLL TABLE                     '         
              DISPLAY '** ACCOUNT NO = ' CL-ACCOUNT-NO                  
              DISPLAY '** 7109 OPEN:  RETURN CODE ERROR - OPEN   '      
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                 23990000
       7109-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24020000
      ******************************************************************24030000
      *  7110-FETCH-CRED-COLL-CSR                                      *24040000
      ******************************************************************24050000
       7110-FETCH-CRED-COLL-CSR.                                        
      *                                                                 24070000
           EXEC SQL                                                     
              FETCH CRED_COLL_N_CSR INTO                                
                 :CL-DATE-NOTICE-MAIL :WS-DATE-NOTICE-MAIL-NULL,        
                 :CL-DATE-NOTICE-DUE :WS-DATE-NOTICE-DUE-NULL,         
                 :CL-ITEM-ID                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

     *                                                                  
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
     *                                                                  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-DATE-NOTICE-MAIL-NULL < 0                           
                 MOVE SPACES TO CL-DATE-NOTICE-MAIL                     
                 MOVE ZEROES TO WS-DATE-NOTICE-MAIL-NULL                
              END-IF                                                    
              IF WS-DATE-NOTICE-DUE-NULL < 0                            
                 MOVE SPACES TO CL-DATE-NOTICE-DUE                      
                 MOVE ZEROES TO WS-DATE-NOTICE-DUE-NULL                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CRED_COLL TABLE                     '         
              DISPLAY '** ACCOUNT NO = ' CL-ACCOUNT-NO                  
              DISPLAY '** 7110 FETCH: RETURN CODE ERROR - FETCH  '      
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
     *                                                                  
       7110-EXIT.                                                       
           EXIT.                                                        
     *                                                                  
      ******************************************************************24380000
      *  7111-CLOSE-CRED-COLL-CSR                                      *24390000
      ******************************************************************24400000
       7111-CLOSE-CRED-COLL-CSR.                                        
     *                                                                  
           EXEC SQL                                                     
              CLOSE CRED_COLL_N_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

     *                                                                  
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
     *                                                                  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CRED_COLL TABLE                      '        
              DISPLAY '** ACCOUNT NO = ' CL-ACCOUNT-NO                  
              DISPLAY '** 7111 CLOSE:  RETURN CODE ERROR - CLOSE  '     
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
     *                                                                  
       7111-EXIT.                                                       
           EXIT.                                                        
     *                                                                  
      ******************************************************************24630000
      *   7120-OPEN-RETURNED-CHK-CSR                                   *24640000
      ******************************************************************24650000
       7120-OPEN-RETURNED-CHK-CSR.                                      
     *                                                                  
           EXEC SQL                                                     
              OPEN RETURNED_CHK_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

     *                                                                  
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
     *                                                                  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** NSF_HIST TABLE                      '         
              DISPLAY '** ACCOUNT NO = ' NH-ACCOUNT-NO                  
              DISPLAY '** 7120 OPEN:  RETURN CODE ERROR - OPEN   '      
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
     *                                                                  
       7120-EXIT.                                                       
           EXIT.                                                        
     *                                                                  
      ******************************************************************24880000
      *   7121-FETCH-RETURNED-CHK-CSR                                  *24890000
      ******************************************************************24900000
       7121-FETCH-RETURNED-CHK-CSR.                                     
     *                                                                  
           INITIALIZE NH-DRAWN-BY-NM.                                   
     *                                                                  
           EXEC SQL                                                     
              FETCH RETURNED_CHK_CSR INTO                               
                 :NH-NSF-CHARGE-AMT,                                    
                 :NH-RETURN-CHECK-AMT,                                  
                 :NH-NSF-REASON-CD,                                     
                 :NH-DRAWN-BY-NM,                                       
                 :NH-NSF-TIMESTMP,                                      
                 :NH-NSF-STATUS-CD,                                     
                 :NH-DEPOSIT-CERT-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

     *                                                                  
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
     *                                                                  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** NSF_HIST TABLE                      '         
              DISPLAY '** ACCOUNT NO = ' NH-ACCOUNT-NO                  
              DISPLAY '** 7121 FETCH: RETURN CODE ERROR - FETCH  '      
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
     *                                                                  
       7121-EXIT.                                                       
           EXIT.                                                        
     *                                                                  
      ******************************************************************25260000
      *   7122-CLOSE-RETURNED-CHK-CSR                                  *25270000
      ******************************************************************25280000
       7122-CLOSE-RETURNED-CHK-CSR.                                     
     *                                                                  
           EXEC SQL                                                     
              CLOSE RETURNED_CHK_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

     *                                                                  
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
     *                                                                  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** NSF_HIST TABLE                      '         
              DISPLAY '** ACCOUNT NO = ' NH-ACCOUNT-NO                  
              DISPLAY '** 7122 CLOSE:  RETURN CODE ERROR - CLOSE  '     
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
     *                                                                  
       7122-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25500000
      ******************************************************************25510000
      *  7170-SELECT-CREDIT-PROFILE                                    *25520000
      *  GET CREDIT PROFILE INFO                                       *25530000
      ******************************************************************25540000
       7170-SELECT-CREDIT-PROFILE.                                      
      *                                                                 25560000
           EXEC SQL                                                     
              SELECT                                                    
                  NON_UTL_ARRER_HIST,                                   
                  DISC_EXCEPTN_HIST,                                    
                  DISCONNECT_HIST,                                      
                  ARREARS_HIST,                                         
                  REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                  CASH_ONLY_FL,                                         
                  NON_UTL_CR_HST,                                       
                  NON_UTL_CR_HST_EX,                                    
                  AUTO_DEP_AM                                           
              INTO                                                      
                  :CZ-NON-UTL-ARRER-HIST,                               
                  :CZ-DISC-EXCEPTN-HIST,                                
                  :CZ-DISCONNECT-HIST,                                  
                  :CZ-ARREARS-HIST,                                     
                  :CZ-LAST-UPDATE-TS,                                   
                  :CZ-CASH-ONLY-FL,                                     
                  :CZ-NON-UTL-CR-HST,                                   
                  :CZ-NON-UTL-CR-HST-EX,                                
                  :CZ-AUTO-DEP-AM                                       
              FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                         
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     25570000
MFA-TR*       SELECT                                                    25580000
MFA-TR*           NON_UTL_ARRER_HIST,                                   25590000
MFA-TR*           DISC_EXCEPTN_HIST,                                    25600000
MFA-TR*           DISCONNECT_HIST,                                      25610000
MFA-TR*           ARREARS_HIST,                                         25620000
MFA-TR*           LAST_UPDATE_TS,                                       25630000
MFA-TR*           CASH_ONLY_FL,                                         25640000
MFA-TR*           NON_UTL_CR_HST,                                       25650000
MFA-TR*           NON_UTL_CR_HST_EX,                                    25660000
MFA-TR*           AUTO_DEP_AM                                           25660000
MFA-TR*       INTO                                                      25680000
MFA-TR*           :CZ-NON-UTL-ARRER-HIST,                               25690000
MFA-TR*           :CZ-DISC-EXCEPTN-HIST,                                25700000
MFA-TR*           :CZ-DISCONNECT-HIST,                                  25710000
MFA-TR*           :CZ-ARREARS-HIST,                                     25720000
MFA-TR*           :CZ-LAST-UPDATE-TS,                                   25730000
MFA-TR*           :CZ-CASH-ONLY-FL,                                     25740000
MFA-TR*           :CZ-NON-UTL-CR-HST,                                   25750000
MFA-TR*           :CZ-NON-UTL-CR-HST-EX,                                25760000
MFA-TR*           :CZ-AUTO-DEP-AM                                       25760000
MFA-TR*       FROM CSS_CREDIT_PROFILE                                   25780000
MFA-TR*       WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                         25790000
MFA-TR*       QUERYNO 7170                                              25800000
MFA-TR*       WITH UR                                                   25810000
MFA-TR*    END-EXEC.                                                    25820000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 25830000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 25850000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CREDIT_PROFILE TABLE                   '      
              DISPLAY '** ACCOUNT NO = ' CZ-ACCOUNT-NO                  
              DISPLAY '** 7170 :  RETURN CODE ERROR - SELECT     '      
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                 25960000
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25990000
A4527B******************************************************************25510000
      *  7200-SELECT-THD-PRTY-PHONE                                    *        
      *  GET CSS_THD_PRTY_PHONE INFO                                   *        
      ******************************************************************        
       7200-SELECT-THD-PRTY-PHONE.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                  PHONE_NO                                              
              INTO                                                      
                  :ZY-PHONE-NO                                          
              FROM CSS_THD_PRTY_PHONE ZY WITH(READUNCOMMITTED)                  
              WHERE THD_PRTY_ID = :ZY-THD-PRTY-ID                       
                AND PHONE_TYPE  = :ZY-PHONE-TYPE                        
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*           PHONE_NO                                                      
MFA-TR*       INTO                                                              
MFA-TR*           :ZY-PHONE-NO                                                  
MFA-TR*       FROM CSS_THD_PRTY_PHONE ZY                                        
MFA-TR*       WHERE THD_PRTY_ID = :ZY-THD-PRTY-ID                               
MFA-TR*         AND PHONE_TYPE  = :ZY-PHONE-TYPE                                
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   MOVE SPACES TO ZY-PHONE-NO                           
               ELSE                                                     
                   NEXT SENTENCE                                        
               END-IF                                                   
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CREDIT_PROFILE TABLE                   '      
              DISPLAY '** THD PRTY ID = ' ZY-THD-PRTY-ID                
              DISPLAY '** PHONE TYPE = ' ZY-PHONE-TYPE                  
              DISPLAY '** 7200 :  RETURN CODE ERROR - SELECT     '      
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 26400000
      * 7240-SET-MH-DATE-TIME.                                        * 26410000
      ***************************************************************** 26420000
       7240-SET-MH-DATE-TIME.                                           
      *                                                                 26440000
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     26450000
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP             26460000
MFA-TR*          ,:MH-DATE-TRANS        = CURRENT DATE                  26470000
MFA-TR*    END-EXEC.                                                    26480000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 26490000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 26510000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** SET MH-TRANS-HIST-SEQ-NO'                     
              DISPLAY '**     MH-DATE-TRANS'                            
              DISPLAY '** PARA :  7240-SET-MH-DATE-TIME'                
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7300-SELECT-NSF-REASON                                        *         
      *****************************************************************         
       7300-SELECT-NSF-REASON.                                          
      *                                                                         
           EXEC SQL                                                     
             SELECT NSF_REASON_DESC                                     
               INTO :NR-NSF-REASON-DESC                                 
               FROM CSS_NSF_REASON WITH(READUNCOMMITTED)                        
              WHERE COMPANY_NO    = '01'                                
                AND NSF_REASON_CD = :WS-NSF-REASON-CD                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT NSF_REASON_DESC                                             
MFA-TR*        INTO :NR-NSF-REASON-DESC                                         
MFA-TR*        FROM CSS_NSF_REASON                                              
MFA-TR*       WHERE COMPANY_NO    = '01'                                        
MFA-TR*         AND NSF_REASON_CD = :WS-NSF-REASON-CD                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'OTHER'   TO WS-NSF-REASON-DESC                   
              ELSE                                                      
                 MOVE NR-NSF-REASON-DESC TO WS-NSF-REASON-DESC          
              END-IF                                                    
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '** ERROR IN 7300-SELECT-NSF-REASON       **'    
               DISPLAY '** TABLE NAME = CSS_NSF_REASON'                 
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '** NSF_REASON_CD = ' WS-NSF-REASON-CD           
               DISPLAY '*******************************************'    
               PERFORM 9900-SQL-ERROR-ROUTINE                           
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
            EXIT.                                                       
      *                                                                 26650000
      ******************************************************************26660000
      *  7440-GET-EARNEST-PYMT-INFO                                    *26670000
      *  GET EARNEST PYMT INFO                                         *26680000
      ******************************************************************26690000
       7440-GET-EARNEST-PYMT-INFO.                                      
      *                                                                 26710000
           EXEC SQL                                                     
               SELECT FRST_ERNST_PAY_AMT,                               
                      FRST_ERNST_PAY_DT,                                
                      SCND_ERNST_PAY_AMT,                               
                      SCND_ERNST_PAY_DT                                 
                   INTO                                                 
                      :WS-FRST-ERNST-PAY-AMT :WS-FRST-ERNST-AMT-NULL,   
                      :WS-FRST-ERNST-PAY-DT :WS-FRST-ERNST-DT-NULL,     
                      :WS-SCND-ERNST-PAY-AMT :WS-SCND-ERNST-AMT-NULL,   
                      :WS-SCND-ERNST-PAY-DT :WS-SCND-ERNST-DT-NULL      
               FROM CSS_DFA_ACCT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO  = :DA-ACCOUNT-NO                       
                 AND CODE_DFA_TYPE = 'B'                                
                 AND CODE_DFA_STATUS = 'A'                              
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     26720000
MFA-TR*        SELECT FRST_ERNST_PAY_AMT,                               26730000
MFA-TR*               FRST_ERNST_PAY_DT,                                26740000
MFA-TR*               SCND_ERNST_PAY_AMT,                               26750000
MFA-TR*               SCND_ERNST_PAY_DT                                 26760000
MFA-TR*            INTO                                                 26770000
MFA-TR*               :WS-FRST-ERNST-PAY-AMT :WS-FRST-ERNST-AMT-NULL,   26780000
MFA-TR*               :WS-FRST-ERNST-PAY-DT :WS-FRST-ERNST-DT-NULL,     26790000
MFA-TR*               :WS-SCND-ERNST-PAY-AMT :WS-SCND-ERNST-AMT-NULL,   26800000
MFA-TR*               :WS-SCND-ERNST-PAY-DT :WS-SCND-ERNST-DT-NULL      26810000
MFA-TR*        FROM CSS_DFA_ACCT                                        26820000
MFA-TR*        WHERE ACCOUNT_NO  = :DA-ACCOUNT-NO                       26830000
MFA-TR*          AND CODE_DFA_TYPE = 'B'                                26840000
MFA-TR*          AND CODE_DFA_STATUS = 'A'                              26850000
MFA-TR*       QUERYNO 7440                                              26860000
MFA-TR*       WITH UR                                                   26870000
MFA-TR*    END-EXEC.                                                    26880000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 26890000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-FRST-ERNST-DT-NULL  < ZERO                          
                 MOVE SPACES TO WS-FRST-ERNST-PAY-DT                    
                 MOVE ZEROES TO WS-FRST-ERNST-DT-NULL                   
              END-IF                                                    
              IF WS-SCND-ERNST-DT-NULL < ZERO                           
                 MOVE SPACES TO WS-SCND-ERNST-PAY-DT                    
                 MOVE ZEROES TO WS-SCND-ERNST-DT-NULL                   
              END-IF                                                    
              IF WS-FRST-ERNST-AMT-NULL < ZERO                          
                 MOVE ZERO TO WS-FRST-ERNST-PAY-AMT                     
                 MOVE ZERO TO WS-FRST-ERNST-AMT-NULL                    
              END-IF                                                    
              IF WS-SCND-ERNST-AMT-NULL < ZERO                          
                 MOVE ZERO TO WS-SCND-ERNST-PAY-AMT                     
                 MOVE ZERO TO WS-SCND-ERNST-AMT-NULL                    
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** DFA ACCT TABLE                    '           
              DISPLAY '** ACCOUNT NO = ' DA-ACCOUNT-NO                  
              DISPLAY '** 7440 : RETURN CODE ERROR - SELECT '           
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                 27160000
       7440-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27190000
      ******************************************************************27200000
      *  7445-SELECT-ACT-GUAR                                          *27210000
      *  SELECT THE ACTIVE GUARANTOR                                   *27220000
      ******************************************************************27230000
       7445-SELECT-ACT-GUAR.                                            
      *                                                                 27250000
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                 INTO :WS-GUARANTOR-EXISTS                              
              FROM CSS_GUARANTOR WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO      = :GU-ACCOUNT-NO                    
                AND GUAR_STATUS_CD  = 'A'                               
                                                    
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     27260000
MFA-TR*       SELECT 'Y'                                                27270000
MFA-TR*          INTO :WS-GUARANTOR-EXISTS                              27280000
MFA-TR*       FROM CSS_GUARANTOR                                        27290000
MFA-TR*       WHERE ACCOUNT_NO      = :GU-ACCOUNT-NO                    27300000
MFA-TR*         AND GUAR_STATUS_CD  = 'A'                               27310000
MFA-TR*       FETCH FIRST ROW ONLY                                      27320000
MFA-TR*       QUERYNO 7445                                              27330000
MFA-TR*       WITH UR                                                   27340000
MFA-TR*    END-EXEC.                                                    27350000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 27360000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 27380000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** GUARANTOR TABLE                   '           
              DISPLAY '** ACCOUNT NO = ' GU-ACCOUNT-NO                  
              DISPLAY '** 7445 : RETURN CODE ERROR - SELECT '           
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                 27490000
       7445-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27520000
      ******************************************************************27530000
      * 7475-SELECT-DELINQ-VALUE                                       *27540000
      * SELECTS THE DELINQUENCY VALUE FOR THE GIVEN DELINQ CODE        *27550000
      ******************************************************************27560000
       7475-SELECT-DELINQ-VALUE.                                        
      *                                                                 27580000
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY                                    
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     27590000
MFA-TR*       SELECT DELINQ_VALUE                                       27600000
MFA-TR*         INTO :C8-DELINQ-VALUE                                   27610000
MFA-TR*         FROM CSS_DELINQUENCY                                    27620000
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                         27630000
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                        27640000
MFA-TR*      QUERYNO 7000                                               27650000
MFA-TR*    END-EXEC.                                                    27660000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 27670000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 27690000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR100 ABORT **************'        
              DISPLAY '* 7475-SELECT-DELINQ-VALUE             *'        
              DISPLAY '* DELINQ CD ', C8-DELINQ-CD                      
              DISPLAY '* COMPANY NO', C8-COMPANY-NO                     
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSKR100 ABORT **************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 27810000
       7475-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27840000
      ******************************************************************27850000
      *  7496-GET-DEP-INT-RATE                                         *27860000
      ******************************************************************27870000
       7496-GET-DEP-INT-RATE.                                           
      *                                                                 27890000
           MOVE WS-INPUT-DATE TO P6-EFF-DATE-FROM.                      
      *                                                                 27910000
           EXEC SQL                                                     
               SELECT TOP(1) INTRST_RATE,
              EFF_DATE_FROM                                     
                 INTO                                                   
                      :P6-INTRST-RATE                                   
                     ,:P6-EFF-DATE-FROM                                 
                 FROM CSS_DEP_INT_RATE WITH(READUNCOMMITTED)                    
               WHERE COMPANY_NO      = :AT-COMPANY-NO                   
                 AND LOCAL_OFFICE    = :AT-LOCAL-OFFICE                 
                 AND REV_DISTRICT_CD = :PR-REV-DISTRICT-CD              
                 AND EFF_DATE_FROM  <= IIF(TRY_CONVERT(DATE, 
                                                      :P6-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :P6-EFF-DATE-FROM
              ) <> 0) OR (LEN(:P6-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :P6-EFF-DATE-FROM
              ), CONVERT(DATE, :P6-EFF-DATE-FROM) )                
               ORDER BY EFF_DATE_FROM DESC                              
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     27920000
MFA-TR*        SELECT INTRST_RATE                                       27930000
MFA-TR*              ,EFF_DATE_FROM                                     27940000
MFA-TR*          INTO                                                   27950000
MFA-TR*               :P6-INTRST-RATE                                   27960000
MFA-TR*              ,:P6-EFF-DATE-FROM                                 27970000
MFA-TR*          FROM CSS_DEP_INT_RATE                                  27980000
MFA-TR*        WHERE COMPANY_NO      = :AT-COMPANY-NO                   27990000
MFA-TR*          AND LOCAL_OFFICE    = :AT-LOCAL-OFFICE                 28000000
MFA-TR*          AND REV_DISTRICT_CD = :PR-REV-DISTRICT-CD              28010000
MFA-TR*          AND EFF_DATE_FROM  <= :P6-EFF-DATE-FROM                28020000
MFA-TR*        ORDER BY EFF_DATE_FROM DESC                              28030000
MFA-TR*      FETCH FIRST ROW ONLY                                       28040000
MFA-TR*      WITH UR                                                    28050000
MFA-TR*       QUERYNO 7496                                              28060000
MFA-TR*    END-EXEC.                                                    28070000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 28080000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 28100000
      *                                                                 28110000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE P6-INTRST-RATE TO WS-DEP-INT-RATE                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
              AND PR-REV-DISTRICT-CD = '999'                            
                 MOVE ZEROES TO WS-DEP-INT-RATE                         
                                P6-INTRST-RATE                          
              ELSE                                                      
                 IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
                    PERFORM 1585-NO-DEP-INT-WQ THRU 1585-EXIT           
                 ELSE                                                   
                 DISPLAY '******************************************'   
                 DISPLAY '** CSS_DEP_INT_RATE TABLE                 '   
                 DISPLAY '** COMPANY NO        = ' AT-COMPANY-NO        
                 DISPLAY '** LOCAL OFF         = ' AT-LOCAL-OFFICE      
                 DISPLAY '** REV DISTRICT CODE = ' PR-REV-DISTRICT-CD   
                 DISPLAY '** P6-EFF-DATE-FROM  = ' P6-EFF-DATE-FROM     
                 DISPLAY '** ACCOUNT NUMBER    = ' AT-ACCOUNT-NO        
                 DISPLAY '** PREMISE NUMBER    = ' AT-PREMISE-NO        
                 DISPLAY '** PARA :  7496-GET-DEP-INT-RATE        '     
                 DISPLAY '**      :  RETURN CODE ERROR - SELECT   '     
                 DISPLAY '******************************************'   
                 PERFORM 9900-SQL-ERROR-ROUTINE                         
              END-IF                                                    
           END-IF
           END-IF.                                                      
      *                                                                 28360000
       7496-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28390000
A04460******************************************************************        
A04460*  7500-LOAD-DEPOSIT-AMTS.                                       *        
A04460******************************************************************        
A04460 7500-LOAD-DEPOSIT-AMTS.                                          
A04460*                                                                         
A04460*                                                                         
A04460     EXEC SQL                                                     
A04460         SELECT AC.AMT_AR_DAY_00                                  
A04460               ,AC.AMT_AR_DAY_30                                  
A04460               ,AC.AMT_AR_DAY_60                                  
A04460               ,AC.AMT_AR_DAY_90                                  
A04460           INTO                                                   
A04460                :WS-AMT-00-DAY-DEP :WS-AMT-00-DAY-DEP-NULL         
A04460               ,:WS-AMT-30-DAY-DEP :WS-AMT-30-DAY-DEP-NULL         
A04460               ,:WS-AMT-60-DAY-DEP :WS-AMT-60-DAY-DEP-NULL         
A04460               ,:WS-AMT-90-DAY-DEP :WS-AMT-90-DAY-DEP-NULL         
A04460           FROM CSS_AR_CNTL AC WITH(READUNCOMMITTED)                      
A04460         WHERE AC.ACCOUNT_NO = :AC-ACCOUNT-NO                     
A04460           AND AC.ITEM_ID    = :AC-ITEM-ID                        
A04460           AND AC.PYMT_PRIORITY_LVL = 80                          
A04460                                                           
A04460                                                      
A04460     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AC.AMT_AR_DAY_00                                          
MFA-TR*              ,AC.AMT_AR_DAY_30                                          
MFA-TR*              ,AC.AMT_AR_DAY_60                                          
MFA-TR*              ,AC.AMT_AR_DAY_90                                          
MFA-TR*          INTO                                                           
MFA-TR*               :WS-AMT-00-DAY-DEP:WS-AMT-00-DAY-DEP-NULL                 
MFA-TR*              ,:WS-AMT-30-DAY-DEP:WS-AMT-30-DAY-DEP-NULL                 
MFA-TR*              ,:WS-AMT-60-DAY-DEP:WS-AMT-60-DAY-DEP-NULL                 
MFA-TR*              ,:WS-AMT-90-DAY-DEP:WS-AMT-90-DAY-DEP-NULL                 
MFA-TR*          FROM CSS_AR_CNTL AC                                            
MFA-TR*        WHERE AC.ACCOUNT_NO = :AC-ACCOUNT-NO                             
MFA-TR*          AND AC.ITEM_ID    = :AC-ITEM-ID                                
MFA-TR*          AND AC.PYMT_PRIORITY_LVL = 80                                  
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A04460     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A04460     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A04460         IF WS-AMT-00-DAY-DEP-NULL < 0                            
A04460            MOVE  0     TO WS-AMT-00-DAY-DEP                      
A04460            MOVE  0     TO WS-AMT-00-DAY-DEP-NULL                 
A04460         END-IF                                                   
A04460         IF WS-AMT-30-DAY-DEP-NULL < 0                            
A04460            MOVE  0     TO WS-AMT-30-DAY-DEP                      
A04460            MOVE  0     TO WS-AMT-30-DAY-DEP-NULL                 
A04460         END-IF                                                   
A04460         IF WS-AMT-60-DAY-DEP-NULL < 0                            
A04460            MOVE  0     TO WS-AMT-60-DAY-DEP                      
A04460            MOVE  0     TO WS-AMT-60-DAY-DEP-NULL                 
A04460         END-IF                                                   
A04460         IF WS-AMT-90-DAY-DEP-NULL < 0                            
A04460            MOVE  0     TO WS-AMT-90-DAY-DEP                      
A04460            MOVE  0     TO WS-AMT-90-DAY-DEP-NULL                 
A04460         END-IF                                                   
A04460     ELSE                                                         
ACT248         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
ACT248              MOVE 0 TO WS-AMT-00-DAY-DEP                         
ACT248                        WS-AMT-30-DAY-DEP                         
ACT248                        WS-AMT-60-DAY-DEP                         
ACT248                        WS-AMT-90-DAY-DEP                         
ACT248              INITIALIZE WS-AMT-00-DAY-DEP-NULL                   
ACT248                         WS-AMT-30-DAY-DEP-NULL                   
ACT248                         WS-AMT-60-DAY-DEP-NULL                   
ACT248                         WS-AMT-90-DAY-DEP-NULL                   
ACT248         ELSE                                                     
A04460             DISPLAY '******************************************' 
A04460             DISPLAY '** CSS_CSS_AR_CNTL                        ' 
A04460             DISPLAY '** ACCOUNT NUMBER    = ' AC-ACCOUNT-NO      
A04460             DISPLAY '** ITEM ID           = ' AC-ITEM-ID         
A04460             DISPLAY '** PARA :  7500-LOAD-DEPOSIT-AMTS       '   
A04460             DISPLAY '**      :  RETURN CODE ERROR - SELECT   '   
A04460             DISPLAY '******************************************' 
A04460             PERFORM 9900-SQL-ERROR-ROUTINE                       
ACT248         END-IF                                                   
A04460     END-IF.                                                      
A04460*                                                                         
A04460 7500-EXIT.                                                       
A04460     EXIT.                                                        
      *                                                                         
      ******************************************************************28400000
      *  7600-START-FCSJC01                                            *28410000
      *  7610-READ-FCSJC01                                             *28420000
      *  7611-CLOSE                                                    *28430000
      ******************************************************************28440000
           EXEC SQL                                                     28450000
               INCLUDE CPD00038                                         28460000
           END-EXEC.                                                    28470000
      *                                                                 28480000
      ******************************************************************28490000
      *  7620-START-FCSCA00                                            *28500000
      *  7621-READ-FCSCA00                                             *28510000
      *  7622-CLOSE-CA00-CSR                                           *28520000
      ******************************************************************28530000
           EXEC SQL                                                     28540000
               INCLUDE CPD00039                                         28550000
           END-EXEC.                                                    28560000
      *                                                                 28570000
      ******************************************************************28580000
      * GETS REG_PROFILE INFORMATION.                                  *28590000
      ******************************************************************28600000
       7640-CHECK-REGULATED.                                            
      *                                                                 28620000
           EXEC SQL                                                     
               SELECT REG_GROUP_CD                                      
                     ,SENIOR_FL                                         
                 INTO :LR-REG-GROUP-CD                                  
                     ,:LR-SENIOR-FL                                     
                 FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     28630000
MFA-TR*        SELECT REG_GROUP_CD                                      28640000
MFA-TR*              ,SENIOR_FL                                         28650000
MFA-TR*          INTO :LR-REG-GROUP-CD                                  28660000
MFA-TR*              ,:LR-SENIOR-FL                                     28670000
MFA-TR*          FROM CSS_REG_PROFILE                                   28680000
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       28690000
MFA-TR*        QUERYNO 7640                                             28700000
MFA-TR*        WITH UR                                                  28710000
MFA-TR*    END-EXEC.                                                    28720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 28730000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 28750000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   IF LR-SENIOR-FL = 'Y' AND LR-REG-GROUP-CD = '100'    
                       MOVE 'Y' TO WS-REG-SENIOR-FLAG                   
                   ELSE                                                 
                       MOVE 'N' TO WS-REG-SENIOR-FLAG                   
                   END-IF                                               
               ELSE                                                     
                   MOVE SPACES TO LR-REG-GROUP-CD                       
                   MOVE SPACES TO WS-REG-SENIOR-FLAG
               END-IF                    
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** CSS_REG_PROFILE                        '     
               DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                 
               DISPLAY '** 7640 : RETURN CODE ERROR - SELECT      '     
               DISPLAY '******************************************'     
               PERFORM 9900-SQL-ERROR-ROUTINE                           
           END-IF.                                                      
      *                                                                 28990000
       7640-EXIT.                                                       
           EXIT.                                                        
      *                                                                 29020000
      ******************************************************************29030000
      *  7655-CHECK-AUTO-DEP                                            29040000
      ******************************************************************29050000
       7655-CHECK-AUTO-DEP.                                             
      *                                                                 29070000
           MOVE '7655' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 29090000
           EXEC SQL                                                     
           SELECT SUM(DO.AMT_DEPOSIT)                                   
                 INTO :WS-AUTO-DEP-CHARGED :WS-AUTO-DEP-CHRG-NULL       
              FROM CSS_DEP_ON_HAND AS DO WITH(READUNCOMMITTED)                  
                   ,CSS_NSF_HIST AS NH WITH(READUNCOMMITTED)                    
             WHERE DO.ACCOUNT_NO     = :NH-ACCOUNT-NO                   
               AND NH.ACCOUNT_NO     = :NH-ACCOUNT-NO                   
               AND NH.DATE_TRAN     >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-DATE-RANGE-1
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-RANGE-1
              ) <> 0) OR (LEN(:WS-DATE-RANGE-1) <> 10), CIS.CHAR2DATE(
                                                       :WS-DATE-RANGE-1
              ), CONVERT(DATE, :WS-DATE-RANGE-1) )                 
               AND NH.DATE_TRAN     <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-DATE-RANGE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-RANGE-2
              ) <> 0) OR (LEN(:WS-DATE-RANGE-2) <> 10), CIS.CHAR2DATE(
                                                       :WS-DATE-RANGE-2
              ), CONVERT(DATE, :WS-DATE-RANGE-2) )                 
               AND NH.NSF_STATUS_CD  = :WS-COMPLETE                     
               AND NH.SEND_NOTICE_CD = 'Y'                              
               AND NH.DEPOSIT_CERT_NO = DO.DEPOSIT_CERT_NO              
               AND DO.CODE_DEP_TYPE  = 'C'                              
               AND DO.DEPOSIT_STATUS_CD = 'A'                           
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     29100000
MFA-TR*    SELECT SUM(DO.AMT_DEPOSIT)                                   29110000
MFA-TR*          INTO :WS-AUTO-DEP-CHARGED :WS-AUTO-DEP-CHRG-NULL       29120000
MFA-TR*       FROM CSS_DEP_ON_HAND AS DO                                29130000
MFA-TR*            ,CSS_NSF_HIST AS NH                                  29140000
MFA-TR*      WHERE DO.ACCOUNT_NO     = :NH-ACCOUNT-NO                   29150000
MFA-TR*        AND NH.ACCOUNT_NO     = :NH-ACCOUNT-NO                   29160000
MFA-TR*        AND NH.DATE_TRAN     >= :WS-DATE-RANGE-1                 29170000
MFA-TR*        AND NH.DATE_TRAN     <= :WS-DATE-RANGE-2                 29180000
MFA-TR*        AND NH.NSF_STATUS_CD  = :WS-COMPLETE                     29190000
MFA-TR*        AND NH.SEND_NOTICE_CD = 'Y'                              29200000
MFA-TR*        AND NH.DEPOSIT_CERT_NO = DO.DEPOSIT_CERT_NO              29210000
MFA-TR*        AND DO.CODE_DEP_TYPE  = 'C'                              29220000
MFA-TR*        AND DO.DEPOSIT_STATUS_CD = 'A'                           29230000
MFA-TR*       QUERYNO 7655                                              29240000
MFA-TR*       WITH UR                                                   29250000
MFA-TR*    END-EXEC.                                                    29260000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 29270000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 29290000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-AUTO-DEP-CHRG-NULL < 0                              
                 MOVE 0 TO WS-AUTO-DEP-CHARGED                          
                 MOVE 0 TO WS-AUTO-DEP-CHRG-NULL                        
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** NSF_HIST TABLE                         '      
              DISPLAY '** ACCOUNT NO = ' NH-ACCOUNT-NO                  
              DISPLAY '** WS-DATE-RANGE-1 = ' WS-DATE-RANGE-1           
              DISPLAY '** WS-DATE-RANGE-2 = ' WS-DATE-RANGE-2           
              DISPLAY '** 7655:   RETURN CODE ERROR        '            
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                 29450000
       7655-EXIT.                                                       
           EXIT.                                                        
      *                                                                 29480000
      ******************************************************************29490000
      *  7660-GET-DEPOSIT-AMT                                          *29500000
      ******************************************************************29510000
       7660-GET-DEPOSIT-AMT.                                            
      *                                                                 29530000
           EXEC SQL                                                     
               SELECT AMT_DEPOSIT                                       
                 INTO :WS-DO-DEPOSIT-AMT                                
                 FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :NH-ACCOUNT-NO                       
                  AND DEPOSIT_CERT_NO = :NH-DEPOSIT-CERT-NO             
                  AND CODE_DEP_TYPE = 'C'                               
                  AND DEPOSIT_STATUS_CD = 'A'                           
                                                            
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     29540000
MFA-TR*        SELECT AMT_DEPOSIT                                       29550000
MFA-TR*          INTO :WS-DO-DEPOSIT-AMT                                29560000
MFA-TR*          FROM CSS_DEP_ON_HAND                                   29570000
MFA-TR*         WHERE ACCOUNT_NO = :NH-ACCOUNT-NO                       29580000
MFA-TR*           AND DEPOSIT_CERT_NO = :NH-DEPOSIT-CERT-NO             29590000
MFA-TR*           AND CODE_DEP_TYPE = 'C'                               29600000
MFA-TR*           AND DEPOSIT_STATUS_CD = 'A'                           29610000
MFA-TR*       QUERYNO 7660                                              29620000
MFA-TR*       WITH UR                                                   29630000
MFA-TR*    END-EXEC                                                     29640000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 29650000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 29670000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 0 TO WS-DO-DEPOSIT-AMT                            
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** DEP_ON_HAND TABLE                      '      
              DISPLAY '** ACCOUNT NO = ' NH-ACCOUNT-NO                  
              DISPLAY '** NH-DEPOSIT-CERT-NO  = ' NH-DEPOSIT-CERT-NO    
              DISPLAY '** 7660:   RETURN CODE ERROR        '            
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
                                                                        
       7660-EXIT.                                                       
           EXIT.                                                        
      *                                                                 29840000
      ******************************************************************29850000
      *  7850-CHECK-SO-UPDT-ACTION-FL                                  *29860000
      ******************************************************************29870000
       7850-CHECK-SO-UPDT-ACTION-FL.                                    
      *                                                                 29890000
           EXEC SQL                                                     
               SELECT  XK.SO_UPDT_ACTION_FL                             
                 INTO  :XK-SO-UPDT-ACTION-FL                            
                 FROM  CSS_SO_DNP_CANCEL XK WITH(READUNCOMMITTED)               
                WHERE  XK.ACCOUNT_NO = :AT-ACCOUNT-NO                   
                                                            
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     29900000
MFA-TR*        SELECT  XK.SO_UPDT_ACTION_FL                             29910000
MFA-TR*          INTO  :XK-SO-UPDT-ACTION-FL                            29920000
MFA-TR*          FROM  CSS_SO_DNP_CANCEL XK                             29930000
MFA-TR*         WHERE  XK.ACCOUNT_NO = :AT-ACCOUNT-NO                   29940000
MFA-TR*       QUERYNO 7850                                              29950000
MFA-TR*       WITH UR                                                   29960000
MFA-TR*    END-EXEC                                                     29970000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 29980000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 30000000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE 'Y' TO WS-SO-DNP-CANCEL-ROW                       
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES TO XK-SO-UPDT-ACTION-FL                    
                 MOVE 'N'    TO WS-SO-DNP-CANCEL-ROW                    
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CSS_SO_DNP_CANCEL TABLE                '      
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7850:   RETURN CODE ERROR        '            
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                 30170000
       7850-EXIT.                                                       
           EXIT.                                                        
      *                                                                 30200000
P0599I******************************************************************29850000
P0599I*  7900-SELECT-GET-PROCESSED-CD                                  *29860000
P0599I******************************************************************29870000
P0599I 7900-SELECT-GET-PROCESSED-CD.                                    
P0599I*                                                                 29890000
P0599I     EXEC SQL                                                     
P0599I         SELECT CL.PROCESSED_CD                                   
P0599I           INTO :WS-PROCESSED-CD                                  
P0599I           FROM CSS_CRED_COLL CL WITH(READUNCOMMITTED)                    
P0599I          WHERE CL.ACCOUNT_NO = :CL-ACCOUNT-NO                    
P0599I          AND CL.CODE_NOTICE_TYPE = 'N'                           
P0599I          AND CL.ITEM_ID = :CL-ITEM-ID                            
P0599I                                                           
P0599I                                                      
P0599I     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     29900000
MFA-TR*        SELECT CL.PROCESSED_CD                                   29910000
MFA-TR*          INTO :WS-PROCESSED-CD                                  29920000
MFA-TR*          FROM CSS_CRED_COLL CL                                  29930000
MFA-TR*         WHERE CL.ACCOUNT_NO = :CL-ACCOUNT-NO                    29940000
MFA-TR*         AND CL.CODE_NOTICE_TYPE = 'N'                           29940000
MFA-TR*         AND CL.ITEM_ID = :CL-ITEM-ID                            29960000
MFA-TR*       WITH UR                                                   29960000
MFA-TR*       QUERYNO 7900                                              29950000
MFA-TR*    END-EXEC.                                                    29970000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0599I*                                                                 29980000
P0599I     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0599I*                                                                 30000000
P0599I     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P0599I        CONTINUE                                                  
P0599I     ELSE                                                         
P0599I        DISPLAY '******************************************'      
P0599I        DISPLAY '** CSS_CRED_COLL TABLE                    '      
P0599I        DISPLAY '** ACCOUNT NO = ' CL-ACCOUNT-NO                  
P0599I        DISPLAY '** ITEM ID = ' CL-ITEM-ID                        
P0599I        DISPLAY '** 7900:   RETURN CODE ERROR        '            
P0599I        DISPLAY '******************************************'      
P0599I        PERFORM 9900-SQL-ERROR-ROUTINE                            
P0599I     END-IF.                                                      
P0599I*                                                                 30170000
P0599I 7900-EXIT.                                                       
P0599I     EXIT.                                                        
P0599I*                                                                 30200000
      ******************************************************************30210000
      *  8520-UPDATE-CREDIT-PROFILE                                    *30220000
      ******************************************************************30230000
       8520-UPDATE-CREDIT-PROFILE.                                      
      *                                                                 30250000
           EXEC SQL                                                     
               UPDATE CSS_CREDIT_PROFILE                                
                  SET DISC_EXCEPTN_HIST  = :CZ-DISC-EXCEPTN-HIST,       
                      DISCONNECT_HIST    = :CZ-DISCONNECT-HIST,         
                      NON_UTL_CR_HST     = :CZ-NON-UTL-CR-HST,          
                      NON_UTL_CR_HST_EX  = :CZ-NON-UTL-CR-HST-EX,       
                      LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP(),           
                      AUTO_DEP_AM        = :CZ-AUTO-DEP-AM              
               WHERE ACCOUNT_NO  =  :CZ-ACCOUNT-NO                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     30260000
MFA-TR*        UPDATE CSS_CREDIT_PROFILE                                30270000
MFA-TR*           SET DISC_EXCEPTN_HIST  = :CZ-DISC-EXCEPTN-HIST,       30280000
MFA-TR*               DISCONNECT_HIST    = :CZ-DISCONNECT-HIST,         30290000
MFA-TR*               NON_UTL_CR_HST     = :CZ-NON-UTL-CR-HST,          30300000
MFA-TR*               NON_UTL_CR_HST_EX  = :CZ-NON-UTL-CR-HST-EX,       30310000
MFA-TR*               LAST_UPDATE_TS     = CURRENT TIMESTAMP,           30320000
MFA-TR*               AUTO_DEP_AM        = :CZ-AUTO-DEP-AM              30330000
MFA-TR*        WHERE ACCOUNT_NO  =  :CZ-ACCOUNT-NO                      30340000
MFA-TR*    END-EXEC.                                                    30350000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 30360000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 30380000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CREDIT_PROFILE TABLE                   '      
              DISPLAY '** ACCOUNT NO = ' CZ-ACCOUNT-NO                  
              DISPLAY '** 8520 :  RETURN CODE ERROR - UPDATE'           
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
       8520-EXIT.                                                       
           EXIT.                                                        
      *                                                                 30510000
      ****************************************************************  30520000
      *    8530-UPDATE-CRED-COLL                                        30530000
      ****************************************************************  30540000
       8530-UPDATE-CRED-COLL.                                           
      *                                                                 30560000
           EXEC SQL                                                     
               UPDATE CSS_CRED_COLL                                     
                  SET AMT_NOTICE        = :CL-AMT-NOTICE                
                     ,CODE_MESSAGE_TYPE = :CL-CODE-MESSAGE-TYPE         
                     ,PROCESSED_CD      = 'N'                           
               WHERE ACCOUNT_NO       = :CL-ACCOUNT-NO                  
                AND  ITEM_ID          = :CL-ITEM-ID                     
                AND  CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 30660000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 30680000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CRED_COLL TABLE                   '           
              DISPLAY '** ACCOUNT NO = ' CL-ACCOUNT-NO                  
              DISPLAY '** CL-CODE-MESSAGE-TYPE = ' CL-CODE-MESSAGE-TYPE 
              DISPLAY '** CL-ITEM-ID = ' CL-ITEM-ID                     
              DISPLAY '** CODE NOTICE TYPE = ' CL-CODE-NOTICE-TYPE      
              DISPLAY '** AMT NOTICE = ' CL-AMT-NOTICE                  
              DISPLAY '** 8530 :  RETURN CODE ERROR - UPDATE'           
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
       8530-EXIT.                                                       
           EXIT.                                                        
      *                                                                 30850000
      ****************************************************************  30860000
      *    8535-UPDATE-CRED-COLL2                                       30870000
      ****************************************************************  30880000
       8535-UPDATE-CRED-COLL2.                                          
      *                                                                 30900000
           EXEC SQL                                                     
               UPDATE CSS_CRED_COLL                                     
                  SET CODE_MESSAGE_TYPE = :CL-CODE-MESSAGE-TYPE         
                     ,PROCESSED_CD      = 'N'                           
               WHERE ACCOUNT_NO       = :CL-ACCOUNT-NO                  
                AND  ITEM_ID          = :CL-ITEM-ID                     
                AND  CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 30990000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 31010000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CRED_COLL TABLE                   '           
              DISPLAY '** ACCOUNT NO = ' CL-ACCOUNT-NO                  
              DISPLAY '** CL-ITEM-ID = ' CL-ITEM-ID                     
              DISPLAY '** CL-CODE-MESSAGE-TYPE = ' CL-CODE-MESSAGE-TYPE 
              DISPLAY '** CODE NOTICE TYPE = ' CL-CODE-NOTICE-TYPE      
              DISPLAY '** 8535 :  RETURN CODE ERROR - UPDATE'           
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
       8535-EXIT.                                                       
           EXIT.                                                        
      *                                                                 31460000
      ****************************************************************  31910000
      *    8650-DELETE-CRED-COLL                                        31920000
      ****************************************************************  31930000
       8650-DELETE-CRED-COLL.                                           
      *                                                                 31950000
           EXEC SQL                                                     
               DELETE FROM CSS_CRED_COLL                                
                WHERE ACCOUNT_NO       = :CL-ACCOUNT-NO                 
                 AND  CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 32010000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 32030000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CRED_COLL TABLE                   '           
              DISPLAY '** ACCOUNT NO = ' CL-ACCOUNT-NO                  
              DISPLAY '** CL-CODE-NOTICE-TYPE = ' CL-CODE-NOTICE-TYPE   
              DISPLAY '** 8650 :  RETURN CODE ERROR - DELETE'           
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                 32150000
       8650-EXIT.                                                       
           EXIT.                                                        
      *                                                                 32180000
      ******************************************************************32190000
      * 8750-UPD-SO-DNP-ACTION-FL                                      *32200000
      * UPDATES SO-UPDT-ACTION-FL TO 'N'                               *32210000
      ******************************************************************32220000
       8750-UPD-SO-DNP-ACTION-FL.                                       
      *                                                                 32240000
           EXEC SQL                                                     
               UPDATE CSS_SO_DNP_CANCEL                                 
                  SET SO_UPDT_ACTION_FL = :WS-NEW-UPDT-ACTION-FL        
                WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 32300000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 32320000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CSS_SO_DNP_CANCEL TABLE          '            
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 8750 :  RETURN CODE ERROR - UPDATE'           
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                 32430000
       8750-EXIT.                                                       
           EXIT.                                                        
      *                                                                 32460000
      ******************************************************************32470000
      * 8760-INS-SO-DNP-CANCEL-ROW                                     *32480000
      * INSERTS A ROW INTO CSS_SO_DNP_CANCEL TABLE                     *32490000
      ******************************************************************32500000
       8760-INS-SO-DNP-CANCEL-ROW.                                      
      *                                                                 32520000
           EXEC SQL                                                     
             INSERT INTO CSS_SO_DNP_CANCEL                              
               ( ACCOUNT_NO                                             
                ,SO_UPDT_ACTION_FL)                                     
             VALUES                                                     
               ( :AT-ACCOUNT-NO                                         
                ,:WS-NEW-UPDT-ACTION-FL)                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 32610000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 32630000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CSS_SO_DNP_CANCEL TABLE           '           
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** WS-NEW-UPDT-ACTION-FL= ' WS-NEW-UPDT-ACTION-FL
              DISPLAY '** 8760 :  RETURN CODE ERROR - INSERT'           
              DISPLAY '******************************************'      
              PERFORM 9900-SQL-ERROR-ROUTINE                            
           END-IF.                                                      
      *                                                                 32750000
       8760-EXIT.                                                       
           EXIT.                                                        
      *                                                                 32780000
      ******************************************************************32790000
      *   8850-COMMIT-DB2-UPDATES                                      *32800000
      *        UPDATES TO DB2 ARE COMMITED FOR EVERY 100 RECORDS       *32810000
      *   PROCESSED.  ALSO, ONE LAST COMMIT IS DONE AT END OF INPUT    *32820000
      ******************************************************************32830000
       8850-COMMIT-DB2-UPDATES.                                         
      *                                                                 32850000
           ADD 1 TO WS-COMMITS-COUNT.                                   
           EXEC SQL                                                     32880000
               INCLUDE CPD00047                                         32890000
           END-EXEC.                                                    32900000
           DISPLAY '*** COMMIT POINT # ' WS-COMMITS-COUNT ' TAKEN.'     
                   ' ACCT OF LAST REC PROCESSED = ' AT-ACCOUNT-NO       
                    ' ***'.                                             
           MOVE ZEROES TO WS-RECS-TO-COMMIT-COUNT.                      
      *                                                                 32950000
       8850-EXIT.                                                       
           EXIT.                                                        
      *                                                                 32980000
      ******************************************************************32990000
      *  8895-INSERT-WORK-QUEUE                                        *33080000
      ******************************************************************33090000
ACT030 8895-INSERT-WORK-QUEUE.                                          
ACT030*                                                                 32850000
ACT030     CALL SCSCB077  USING   CWS00077-FIELDS,                      
ACT030                            ABEND-FILE,                           
ACT030                            RS-RETURN-CODE.                       
ACT030                                                                  
ACT030      MOVE RS-RETURN-CODE             TO WS-ACTIVE-RETURN-CODE.   
ACT030                                                                  
ACT030      IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0        
ACT030         MOVE PROGRAM-NAME               TO   ABEND-PROGRAM       
ACT030         DISPLAY '8895-INSERT-WORK-QUEUE'                         
ACT030         DISPLAY 'CALL SCSCB077         '                         
ACT030         DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO              
ACT030         DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO              
ACT030         DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO           
ACT030         DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE         
ACT030         PERFORM 9900-ABEND    THRU 9900-EXIT                     
ACT030     END-IF.                                                      
ACT030*                                                                 32950000
ACT030 8895-EXIT.                                                       
ACT030     EXIT.                                                        
      *                                                                 33130000
      ****************************************************************  33140000
      * 9000-SEND-ERROR-RESULT. REQUIRED BY COPYBOOK CPD00067        *  33150000
      ****************************************************************  33160000
       9000-SEND-ERROR-RESULT.                                          
      *                                                                 33180000
           GO TO 9000-EXIT.                                             
      *                                                                 33200000
      ****************************************************************  33210000
      * 9000-TERMINATE          REQUIRED BY COPYBOOK CPD00067        *          
      ****************************************************************  33230000
       9000-TERMINATE.                                                  
      *                                                                 33250000
       9000-EXIT.                                                       
            EXIT.                                                       
      *                                                                 33580000
      ******************************************************************33590000
      *   9600-PROCESS-ABEND                                           *33600000
      *        THIS ROUTINE IS EXECUTED ONLY FROM 9000-TERMINATE WHEN  *33610000
      *   AN ERROR CONDITION OCCURS.  SINCE 9000-TERMINATE IS          *33620000
      *   EXECUTED FROM 9600-PROCESS-ABEND, THIS PARAGRAPH WAS SETUP   *33630000
      *   TO AVOID LOOP.                                               *33640000
      ******************************************************************33650000
       9600-PROCESS-ABEND.                                              
      *                                                                 33670000
           MOVE '9600'                   TO ACTIVE-PARAGRAPH.           
           MOVE RS-RETURN-CODE           TO RS-RETURN-CODE-DISP.        
      *                                                                 33700000
           DISPLAY '*********************************************'      
           DISPLAY '** COMPONENT ABEND   ' ABEND-PROGRAM                
           DISPLAY '** DB2 RETURN CODE   ' RS-RETURN-CODE-DISP          
           DISPLAY '** ABEND FUNCTION    ' ABEND-FUNCTION               
           DISPLAY '** TABLE 1           ' TABLE-1                      
           DISPLAY '** TABLE ELEMENT 1   ' TABLE-ELEMENT-1              
           DISPLAY '** HOSTVAR ELEMENT 1 ' HOSTVAR-ELEMENT-1            
           DISPLAY '** TABLE 2           ' TABLE-2                      
           DISPLAY '** TABLE ELEMENT 2   ' TABLE-ELEMENT-2              
           DISPLAY '** HOSTVAR ELEMENT 2 ' HOSTVAR-ELEMENT-2            
           DISPLAY '** TABLE 3           ' TABLE-3                      
           DISPLAY '** TABLE ELEMENT 3   ' TABLE-ELEMENT-3              
           DISPLAY '** HOSTVAR ELEMENT 3 ' HOSTVAR-ELEMENT-3            
           DISPLAY '** TABLE 4           ' TABLE-4                      
           DISPLAY '** TABLE ELEMENT 4   ' TABLE-ELEMENT-4              
           DISPLAY '** HOSTVAR ELEMENT 4 ' HOSTVAR-ELEMENT-4            
           DISPLAY '*********************************************'      
           DISPLAY 'PERFORMING 9600-PROCESS-ABEND'.                     
      *                                                                 33890000
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

      *                                                                 33940000
           MOVE 12  TO  RETURN-CODE.                                    
           MOVE 'YES' TO WS-ABEND-SWITCH.                               
      *                                                                 33970000
       9600-EXIT.                                                       
            IF WS-ABEND-YES                                             
                STOP RUN
            END-IF.                                               
      *                                                                 34010000
      ******************************************************************34020000
      *  9701-PROCESS-ABEND.                                           *34030000
      ******************************************************************34040000
           EXEC SQL                                                     34050000
               INCLUDE CPD0023B                                         34060000
           END-EXEC.                                                    34070000
      *                                                                 34080000
      ****************************************************************  34090000
      **  9900-SQL-ERROR-ROUTINE                                    **  34100000
      ****************************************************************  34110000
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                 34130000
           MOVE SQLCODE TO WS-DISPLAY-SQLCODE.                          
           DISPLAY '****  9900-SQL-ERROR-ROUTINE  ****************'     
           DISPLAY '***** SQLCODE = ' WS-DISPLAY-SQLCODE                
           DISPLAY '**********************************************'.    
           PERFORM 9900-ABEND THRU 9900-EXIT.                           
      *                                                                 34190000
      ******************************************************************34200000
      * CPD09900   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE       *34210000
      * 9900-ABEND                                                     *34220000
      ******************************************************************34230000
           EXEC SQL                                                     34240000
               INCLUDE CPD09900                                         34250000
           END-EXEC.                                                    34260000
