       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSKR160.                                          
       AUTHOR.       AARON ABRAHAM.                                     
       DATE-WRITTEN. JUN 2013.                                          
       DATE-COMPILED.                                                   
      ******************************************************************        
      **               SOUTH CAROLINA ELECTRIC & GAS                  **        
      **                      COBOL-DB2                               **        
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **                                                              **        
      ** THIS IS A NEW PROGRAM WHICH COMPLETES CREDIT ARRANGEMENT     **        
      ** PROCESS.                                                     **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 3999     OUTPUT PROCESS CONTROL PATH           **        
      **        4000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **              PROGRAM  MODIFICATION  LOG                      **        
      ******************************************************************        
      ** DATE        USERID   REASON                                  **        
      ** -------     -------  ------                                  **        
P00726** 06/12/2013  AA97148  INITIAL IMPLEMENTATION.                 **        
P0726A** 08/19/2013  AA97148  SELECTS DATE-BILL-DAYS FROM CSS_ACCOUNT **        
P0726A**                      TO CORRECT ARREARS AMOUNT.              **        
P0726B** 02/19/2014  AA97148  CREDIT ARRANGEMENTS DCR CHANGES.        **        
P0726C** 02/19/2014  AA97148  CREDIT ARRANGEMENTS - RELEASE 2 CHANGES **        
ACT107*  06/20/2014  RB19957  CHANGE IN PROCESSING ACCOUNT-ANY FB/WO  **        
ACT107*         APPL00004880  ACCOUNT WILL HAVE THE CDD/CDDA COMPLETED**        
P0726D** 08/18/2014  AA97148  CREDIT ARRANGEMENTS - RELEASE 3 CHANGES **        
P0726D**                      ADDED REMAINING AMOUNT CALCULATION FOR  **        
P0726D**                      STA/STAA.                               **        
P0726E** 10/21/2014  AA97148  PROD FIX - USE TOTAL-BALANCE INSTEAD OF **        
P0726E**                      AT-TOTAL-AR-BALANCE WHILE DOING STA     **        
P0726E**                      REMAINING AMOUNT CALCULATION.           **        
P0726F** 11/14/2014  AA97148  PROD FIX - FIX CODES DATA PRESENT IN CDD**        
P0726F**                      REPLACEMENT PROCESS.                    **        
P00948** 06/10/2016  AA97148  LEAST AMOUNT TO PAY CHANGES.            **        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSKR160'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                       PIC X(40)   VALUE              
                        'WORKING STORAGE FOR PCSKR160 STARTS HERE'.     
       01 WS-MISC.                                                      
          05 WS-DISPLAY-SQLCODE          PIC -Z(8)9.                    
          05 RS-RETURN-CODE              PIC S9(04)  COMP VALUE 0.      
          05 S-RETURN-CODE               PIC S9(9)   VALUE +000 COMP.   
          05 RS-RETURN-CODE-DISP         PIC S9(04)  COMP VALUE 0.      
          05 WS-DISP-RETURN-CODE         PIC +Z(04).                    
          05 WS-RUN-DATE                 PIC X(10)   VALUE SPACES.      
          05 WS-COMP-2-CHAR-CONV         PIC ZZZZZZZZ9.99.              
          05 SCSCB068                    PIC X(08)   VALUE 'SCSCB068'.  
          05 WS-ARNG-COMPLIANCE-CD       PIC X(02)   VALUE SPACES.      
          05 WS-TRAN-APPL-NO             PIC S9(04)  COMP VALUE ZERO.   
          05 WS-COMMITS-COUNT            PIC S9(09)  COMP VALUE +0.     
          05 WS-READY-TO-COMMIT-COUNT    PIC S9(09)  COMP VALUE +0.     
          05 WS-DEFAULT-INSERT-COUNT     PIC S9(09)  COMP VALUE +1000.  
          05 WS-RECS-TO-COMMIT-COUNT     PIC S9(09)  COMP VALUE +0.     
P0726A    05 WS-DATE-BILL-00-IND         PIC S9(04)  COMP VALUE +0.     
P0726A    05 WS-DATE-BILL-30-IND         PIC S9(04)  COMP VALUE +0.     
P0726A    05 WS-DATE-BILL-60-IND         PIC S9(04)  COMP VALUE +0.     
P0726A    05 WS-DATE-BILL-90-IND         PIC S9(04)  COMP VALUE +0.     
P0726C    05 WS-TOTAL-ARREARS            PIC S9(9)V99 COMP-3 VALUE 0.   
P0726C    05 WS-REMAINING-AMT            PIC S9(9)V99 COMP-3 VALUE 0.   
P0726D    05 WS-ARNG-HIST-TS             PIC X(26)   VALUE SPACES.      
P00948    05 WS-LEAST-AMT-DUE-CD         PIC X(13)  VALUE               
P00948                                       'LEAST-AMT-DUE'.           
P00948    05 WS-LEAST-AMOUNT-DUE         PIC S9(4)V9(5) USAGE COMP-3    
P00948                                               VALUE 0.           
          05 WS-KR160-CODES-PRESENT      PIC X(32)   VALUE SPACES.      
          05 WS-COMMENTS.                                               
             10 FILLER                   PIC X(40)   VALUE              
P0726D          'PAYMENT ARRANGEMENT COMPLETION PROCESS; '.             
             10 WS-DISP-RUN-DATE         PIC X(10)   VALUE SPACES.      
                                                                        
       01 WS-NULL-INDICATORS.                                           
          05 WS-ARNG-DUE-DT-NULL         PIC S9(04)  COMP VALUE 0.      
          05 WS-ARNG-SCHD-SEQ-NULL       PIC S9(04)  COMP VALUE 0.      
                                                                        
       01 WS-SWITCHES.                                                  
          05 WS-NO-MORE-DATA             PIC X(01)   VALUE 'N'.         
             88 NO-MORE-DATA                         VALUE 'Y'.         
                                                                        
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME                PIC X(08)   VALUE 'PCSKR160'.  
          05 WS-PGRMNAME                 PIC X(08)   VALUE 'PCSKR160'.  
          05 WS-SYSTEM                   PIC X(06)   VALUE 'SYSTEM'.    
          05 WS-N                        PIC X(01)   VALUE 'N'.         
          05 WS-Y                        PIC X(01)   VALUE 'Y'.         
                                                                        
                                                                        
      ******************************************************************        
      *  CWS00038 JOB PARM ROUTINE                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
                                                                        
       01 WS-INSERT-ROW-COUNT REDEFINES WS-INPUT-DATA-BREAKDOWN.        
                                                                        
          10 WS-PARM-COMMIT-ROW-COUNT-TXT PIC X(21).                    
             88 COMMIT-ROW-CNT         VALUE 'NO-OF-ROWS-TO-COMMIT='.   
          10 WS-NO-OF-ROWS-TO-COMMIT   PIC X(05).                       
          10 FILLER                    PIC X(54).                       
                                                                        
      ******************************************************************        
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                        *        
      ******************************************************************        
                                                                        
       COPY CWS00010.                                                           
                                                                        
      ******************************************************************        
      * WORKING STORAGE LAYOUT FOR USE WITH NOTICES AND LETTERS EXTRACT*        
      ******************************************************************        
                                                                        
       COPY CWS00103.                                                           
                                                                        
      ******************************************************************        
      *  FIOCA00 COPYBOOK TO GET JOB_PARM DATA.                        *        
      ******************************************************************        
                                                                        
       COPY FIOCA00.                                                            
                                                                        
      ******************************************************************        
      *  CWS00039 JOB PARM ROUTINE                                     *        
      ******************************************************************        
                                                                        
       COPY CWS00039.                                                           
                                                                        
      ******************************************************************        
      *  COPYBOOK WITH CODES DATA PRESENT VALUES                       *        
      ******************************************************************        
                                                                        
       COPY CWS00056.                                                           
                                                                        
      ******************************************************************        
      *  COPYBOOK WITH VARIABLES USED BY CPD00068                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * WORKING STORAGE FOR CPD09900 CONTAINS ABEND WS VARIABLES       *        
      ******************************************************************        
                                                                        
       COPY CWS09900.                                                           
                                                                        
      ******************************************************************        
      * ERROR MESSAGE COPYBOOK.                                        *        
      ******************************************************************        
                                                                        
       COPY CWS00303.                                                           
       COPY FIOJC01.                                                            
       COPY CWS00050.                                                           
                                                                        
      ******************************************************************        
      *  WORKING STORAGE FOR CPDKR361                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSKR361                                                  
           END-EXEC.                                                            
                                                                        
      *                                                                         
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSKR160 ENDS HERE  '.            
      *                                                                         
      ******************************************************************        
      * DB2 INCLUDES.                                                  *        
      ******************************************************************        
      *    SQLCA                                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ACCOUNT         - AT                                       *06340000
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ARNG_PLAN       - UF                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBARGPLN                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CRED_ARNGMENT   - X1                                       *06340000
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBCRARNG                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CRED_ARNG_SCHD  - WX                                       *06340000
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBCRARSC                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CRED_ARNG_HIST  - WY                                        06340000
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBCRARHS                                                   
           END-EXEC.                                                            
                                                                        
P0726D******************************************************************06330000
P0726D* CSS_CRED_ARNG_ACTN - W4                                        *06340000
P0726D******************************************************************06350000
P0726D                                                                  
P0726D     EXEC SQL                                                             
P0726D        INCLUDE TBCRDACT                                                  
P0726D     END-EXEC.                                                            
P0726D                                                                  
      ******************************************************************        
      *  CSS_ARNG_ATTR      - UY                                       *06340000
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBARGATT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_ARNG_OPTN_ATTR - VH                                       *06340000
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBARGOPA                                                   
           END-EXEC.                                                            
                                                                        
P0726C******************************************************************        
P0726C*  CSS_BILLING_HDR    - BI                                       *        
P0726C******************************************************************        
P0726C                                                                  
P0726C     EXEC SQL                                                             
P0726C        INCLUDE TBBLLHDR                                                  
P0726C     END-EXEC.                                                            
P0726C                                                                  
P00948******************************************************************        
P00948*  CSS_DELINQUENCY    - C8                                                
P00948******************************************************************        
P00948                                                                  
P00948     EXEC SQL                                                             
P00948       INCLUDE TBDELQ                                                     
P00948     END-EXEC.                                                            
P00948                                                                  
      ******************************************************************        
      *  CSS_MNT_TRANS_HIST - MH                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBMNHIST                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_MT_TRN_HST_DET - MI                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBMNHDT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_REG_PROFILE    - LR                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBREGPRF                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_JOB_PARM       - G6                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
                                                                        
      * DB2 CURSORS.                                                            
      *------------*                                                            
      *                                                                         
      ******************************************************************        
      * DECLARE CURSOR TO GET ACTIVE ARRANGEMENT DETAILS               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE ARNG_DTLS CURSOR WITH HOLD FOR                    
               SELECT X1.ACCOUNT_NO                                     
                     ,X1.ARNG_ID                                        
                     ,X1.ARNG_COMPLIANCE_CD                             
                     ,X1.CRED_ARNG_SEQ                                  
                     ,X1.ARNG_CHANNEL_CD                                
                     ,X1.ARNG_TYPE                                      
P0726C               ,X1.ARNG_SETUP_DT                                  
P0726C               ,X1.ARNG_OPTION_ID                                 
                     ,WX.ARNG_SCHD_SEQ                                  
                     ,WX.ARNG_SCHD_DUE_DT                               
                     ,WX.ARNG_SCHD_PYMT_AMT                             
P0726D               ,REPLACE(REPLACE(CONVERT(CHAR(26), WY.ARNG_HIST_TS
           , 121), ' ', '-'), ':', '.') ARNG_HIST_TS                           
                 FROM CSS_CRED_ARNGMENT  X1 WITH(READUNCOMMITTED)               
                     ,CSS_CRED_ARNG_SCHD WX WITH(READUNCOMMITTED)               
P0726D               ,CSS_CRED_ARNG_HIST WY WITH(READUNCOMMITTED)               
                WHERE X1.ACCOUNT_NO        =  WX.ACCOUNT_NO             
P0726D            AND WX.ACCOUNT_NO        =  WY.ACCOUNT_NO             
                  AND X1.ARNG_ID           =  WX.ARNG_ID                
P0726D            AND WX.ARNG_ID           =  WY.ARNG_ID                
                  AND X1.CRED_ARNG_SEQ     =  WX.CRED_ARNG_SEQ          
P0726D            AND WX.CRED_ARNG_SEQ     =  WY.CRED_ARNG_SEQ          
                  AND X1.ARNG_STATUS_CD    =  'A'                       
P0726D            AND WY.ARNG_CHANGE_CD    =  'S'                       
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ARNG_DTLS CURSOR WITH HOLD FOR                            
MFA-TR*        SELECT X1.ACCOUNT_NO                                             
MFA-TR*              ,X1.ARNG_ID                                                
MFA-TR*              ,X1.ARNG_COMPLIANCE_CD                                     
MFA-TR*              ,X1.CRED_ARNG_SEQ                                          
MFA-TR*              ,X1.ARNG_CHANNEL_CD                                        
MFA-TR*              ,X1.ARNG_TYPE                                              
MFA-TR*              ,X1.ARNG_SETUP_DT                                          
MFA-TR*              ,X1.ARNG_OPTION_ID                                         
MFA-TR*              ,WX.ARNG_SCHD_SEQ                                          
MFA-TR*              ,WX.ARNG_SCHD_DUE_DT                                       
MFA-TR*              ,WX.ARNG_SCHD_PYMT_AMT                                     
MFA-TR*              ,WY.ARNG_HIST_TS                                           
MFA-TR*          FROM CSS_CRED_ARNGMENT  X1                                     
MFA-TR*              ,CSS_CRED_ARNG_SCHD WX                                     
MFA-TR*              ,CSS_CRED_ARNG_HIST WY                                     
MFA-TR*         WHERE X1.ACCOUNT_NO        =  WX.ACCOUNT_NO             16400000
MFA-TR*           AND WX.ACCOUNT_NO        =  WY.ACCOUNT_NO                     
MFA-TR*           AND X1.ARNG_ID           =  WX.ARNG_ID                16410000
MFA-TR*           AND WX.ARNG_ID           =  WY.ARNG_ID                        
MFA-TR*           AND X1.CRED_ARNG_SEQ     =  WX.CRED_ARNG_SEQ          16420000
MFA-TR*           AND WX.CRED_ARNG_SEQ     =  WY.CRED_ARNG_SEQ                  
MFA-TR*           AND X1.ARNG_STATUS_CD    =  'A'                       16420000
MFA-TR*           AND WY.ARNG_CHANGE_CD    =  'S'                               
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7510                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       01  WS-END                          PIC X(40)      VALUE         
                       'WORKING STORAGE FOR PCSKR160 ENDS HERE  '.      
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM  0100-INITIALIZATION            THRU  0100-EXIT.     
           PERFORM  1000-PROCESS-INPUT             THRU  1000-EXIT.     
           PERFORM  9000-TERMINATE                 THRU  9000-EXIT.     
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZATION                                            *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
                                                                        
           INITIALIZE WS-SYSIPT                                         
                      DCLCSS-CRED-ARNGMENT                              
                      DCLCSS-CRED-ARNG-SCHD                             
                      DCLCSS-CRED-ARNG-HIST.                            
                                                                        
           PERFORM 6251-GET-FJC01-DATE             THRU 6251-EXIT       
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE   THRU 6240-EXIT       
              MOVE WS-FCA00-COMMON-DATE  TO WS-INPUT-DATE               
              DISPLAY '********************************************'    
              DISPLAY '* COMMON DATE BEING USED                   *'    
              DISPLAY '* DATE = ' WS-INPUT-DATE                         
              DISPLAY '* PROCESSING CONTINUING                    *'    
              DISPLAY '********************************************'    
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE            TO WS-RUN-DATE                 
                                            WS-DISP-RUN-DATE.           
                                                                        
      * GET DB2 INSERT ROW COUNT                                                
           PERFORM 0110-GET-COMMIT-ROW-COUNT      THRU 0110-EXIT.       
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0110-GET-COMMIT-ROW-COUNT.                                     *        
      * GET THE INSERT ROW COUNT FROM JOB PARM TABLE                   *        
      ******************************************************************        
                                                                        
       0110-GET-COMMIT-ROW-COUNT.                                       
                                                                        
           MOVE  WS-PGRMNAME                TO WS-PROGRAM.              
           MOVE  WS-PARM                    TO WS-COMMAND.              
           MOVE  ZEROS                      TO WS-SEQUENCE.             
           MOVE  SPACES                     TO WS-SYSIPT.               
           MOVE  WS-KEY-AREA                TO E-FJC01-KEY.             
                                                                        
           PERFORM 7600-START-FCSJC01       THRU  7600-EXIT.            
           PERFORM 7610-READ-FCSJC01        THRU  7610-EXIT             
             UNTIL (COMMIT-ROW-CNT AND INPUT-ACTIVE) OR                 
                   END-OF-SYSIPT.                                       
                                                                        
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '** ' WS-PGRMNAME ' PROCESSING WARNING  **'       
              DISPLAY '**  COMMIT-ROW-CNT PARM NOT ACTIVE     **'       
              DISPLAY '**  DEFAULT OF ' WS-DEFAULT-INSERT-COUNT         
                          ' WILL BE USED  **'                           
              DISPLAY '**  PROCESSING CONTINUING        **'             
              MOVE WS-DEFAULT-INSERT-COUNT                              
                                            TO WS-READY-TO-COMMIT-COUNT 
           ELSE                                                         
              IF WS-NO-OF-ROWS-TO-COMMIT NUMERIC                        
                 MOVE WS-NO-OF-ROWS-TO-COMMIT                           
                                            TO WS-READY-TO-COMMIT-COUNT 
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY '**  ' WS-PGRMNAME ' PROCESSING WARNING  **'   
                 DISPLAY '**  COMMIT-ROW-CNT PARM NOT NUMERIC  **'      
                 DISPLAY '**  DEFAULT OF ' WS-DEFAULT-INSERT-COUNT      
                         ' WILL BE USED  **'                            
                 DISPLAY '**  PROCESSING CONTINUING        **'          
                 MOVE WS-DEFAULT-INSERT-COUNT                           
                                            TO WS-READY-TO-COMMIT-COUNT 
              END-IF                                                    
              PERFORM 7611-CLOSE            THRU 7611-EXIT              
           END-IF.                                                      
                                                                        
       0110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-ACCOUNT                                           *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE 'N' TO WS-NO-MORE-DATA.                                 
           PERFORM 7500-OPEN-ARNG-DTLS             THRU 7500-EXIT.      
           PERFORM 7510-FETCH-ARNG-DTLS            THRU 7510-EXIT.      
           PERFORM UNTIL NO-MORE-DATA                                   
              PERFORM 2000-PROCESS-ACCOUNT         THRU 2000-EXIT       
           END-PERFORM.                                                 
           PERFORM 7520-CLOSE-ARNG-DTLS            THRU 7520-EXIT.      
                                                                        
           IF WS-RECS-TO-COMMIT-COUNT > 0                               
              PERFORM 8888-COMMIT                  THRU 8888-EXIT       
           END-IF.                                                      
                                                                        
           DISPLAY '** PCSKR160 PROCESSING COMPLETED SUCCESSFULLY **'.  
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-ACCOUNT                                           *        
      ******************************************************************        
                                                                        
       2000-PROCESS-ACCOUNT.                                            
                                                                        
           MOVE SPACES                   TO WS-ARNG-COMPLIANCE-CD.      
P0726C     MOVE ZEROES                   TO WS-REMAINING-AMT            
P0726C                                      WS-TOTAL-ARREARS.           
           MOVE X1-ACCOUNT-NO            TO AT-ACCOUNT-NO               
P0726C                                      BI-ACCOUNT-NO               
                                            WY-ACCOUNT-NO.              
                                                                        
           DISPLAY 'PROCESSING ACCT NO: ' AT-ACCOUNT-NO.                
           PERFORM 7000-SELECT-TIMESTAMP-DATE      THRU 7000-EXIT.      
           PERFORM 7010-SELECT-ACCOUNT             THRU 7010-EXIT.      
           PERFORM 2010-CALL-CPD00068              THRU 2010-EXIT.      
                                                                        
           PERFORM 7040-SELECT-REG-PROFILE         THRU 7040-EXIT.      
           PERFORM 7020-SELECT-ARNG-PLAN-ID        THRU 7020-EXIT.      
           PERFORM 2020-POPULATE-ARNG-HIST-DTLS    THRU 2020-EXIT.      
           PERFORM 2030-POPULATE-CPDKR361-DTLS     THRU 2030-EXIT.      
                                                                        
P0726C     IF WX-ARNG-SCHD-DUE-DT > WS-RUN-DATE AND                     
P0726C        WS-ARNG-COMPLIANCE-CD = 'N'                               
ACT107        AND AT-CODE-ACCT-STAT = 'A'                               
P0726C        CONTINUE                                                  
P0726C     ELSE                                                         
              PERFORM 8400-UPDATE-CRED-ARNG        THRU 8400-EXIT       
              IF SQLCODE = 0                                            
                 PERFORM 8600-INSERT-ARNG-HIST     THRU 8600-EXIT       
                 PERFORM 5000-MNT-TRAN-HEAD        THRU 5000-EXIT       
                 PERFORM 5100-MNT-TRAN-DTLS        THRU 5100-EXIT       
P0726D           IF X1-ARNG-TYPE = 'CDD' OR 'CDDA'                      
                    MOVE SPACES             TO WS-CODE-CRED-ARNG        
P0726D           ELSE                                                   
P00948              IF X1-ARNG-TYPE = 'STA' OR 'STAA' OR 'STF' OR 'STFA'
P0726D                 MOVE SPACES          TO WS-CODE-STA-ACCT         
P0726F              END-IF                                              
P0726D           END-IF                                                 
                 MOVE WS-CODES-DATA-PRESENT TO WS-KR160-CODES-PRESENT   
                 PERFORM 8410-UPDATE-ACCOUNT       THRU 8410-EXIT       
P0726D           PERFORM 5200-DEL-CRED-ARNG-ACTN-ROWS                   
P0726D                                             THRU 5200-CPD137-EXIT
P0726C           ADD 1                      TO WS-RECS-TO-COMMIT-COUNT  
P0726C           IF WS-RECS-TO-COMMIT-COUNT = WS-READY-TO-COMMIT-COUNT  
P0726C              PERFORM 8888-COMMIT            THRU 8888-EXIT       
P0726C           END-IF                                                 
P0726C        END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7510-FETCH-ARNG-DTLS            THRU 7510-EXIT.      
                                                                        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2010-CALL-CPD00068                                             *        
      * UTILIZATION OF CPD00068 FUNCTIONALITY TO CALCULATE ARREARS,    *        
      * BALANCE DUE, PAST DUE AMOUNT AND DNP BALANCE                   *        
      ******************************************************************        
                                                                        
       2010-CALL-CPD00068.                                              
                                                                        
           MOVE 'Y'                   TO CALC-ARREARS-SW                
                                         CALC-BALANCE-SW                
                                         CALC-PAST-DUE-SW               
                                         CALC-DNP-BAL-NO-LIMIT-SW.      
           MOVE 'N'                   TO LOAD-WS-AMOUNTS-SW.            
           MOVE SPACE                 TO WS-HOLD-DNP-TYPE.              
           MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
           MOVE WS-RUN-DATE           TO WS-HOLD-DATE.                  
           MOVE 'PCSKR160'            TO WS-CPD00068-CALLING-PGM.       
                                                                        
           MOVE SPACES                TO  ABEND-FUNCTION.               
           CALL SCSCB068  USING   CWS00068-FIELDS,                      
                                  WS-CODES-DATA-PRESENT,                
                                  DCLCSS-ACCOUNT,                       
                                  ABEND-FILE,                           
                                  RS-RETURN-CODE.                       
           MOVE RS-RETURN-CODE        TO  WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF ABEND-FUNCTION > SPACES                                   
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2020-POPULATE-ARNG-HIST-DTLS                                   *        
      ******************************************************************        
                                                                        
       2020-POPULATE-ARNG-HIST-DTLS.                                    
                                                                        
           MOVE WS-TOTAL-BALANCE         TO WY-TOTAL-AR-BALANCE.        
           MOVE WS-TOTAL-BALANCE-UTL     TO WY-TOTAL-UTL-BAL.           
           MOVE WS-TOTAL-BALANCE-NONUTL  TO WY-TOTAL-NONUTL-BAL.        
           MOVE WS-AMT-ARREARS-UTL       TO WY-UTL-ARREARS-AMT.         
           MOVE WS-AMT-ARREARS-NONUTL    TO WY-NONUTL-ARREARS-AMT.      
           MOVE WX-ARNG-SCHD-DUE-DT      TO WY-ARNG-DUE-DT.             
           MOVE X1-ARNG-ID               TO WY-ARNG-ID.                 
           MOVE X1-CRED-ARNG-SEQ         TO WY-CRED-ARNG-SEQ.           
P0726B     MOVE WX-ARNG-SCHD-SEQ         TO WY-ARNG-SCHD-SEQ.           
           MOVE 'C'                      TO WY-ARNG-CHANGE-CD.          
           MOVE WS-COMMENTS              TO WY-CHANGE-COMMENTS-TEXT.    
           MOVE LENGTH OF WY-CHANGE-COMMENTS-TEXT                       
                                         TO WY-CHANGE-COMMENTS-LEN.     
           MOVE MH-TRANS-HIST-SEQ-NO     TO WY-LAST-UPDATE-TS           
                                            WY-ARNG-HIST-TS             
           MOVE 'SYSTEM'                 TO WY-LAST-UPDATE-USERID.      
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2030-POPULATE-CPDKR361-DTLS                                    *        
      ******************************************************************        
                                                                        
       2030-POPULATE-CPDKR361-DTLS.                                     
                                                                        
P0726C     PERFORM 2040-CALC-REMAINING-AMT  THRU 2040-EXIT.             
           MOVE UF-ARNG-PLAN-ID          TO WS-KR361-ARNG-PLAN-ID.      
P0726C     MOVE X1-ARNG-OPTION-ID        TO WS-KR361-ARNG-OPTION-ID.    
           MOVE X1-ACCOUNT-NO            TO WS-KR361-ACCOUNT-NO.        
           MOVE SPACES                   TO WS-KR361-MAJOR-IND.         
           MOVE AT-ACCOUNT-TYPE-CODE     TO WS-KR361-ACCOUNT-TYPE-CD.   
P0726C     MOVE WS-REMAINING-AMT         TO WS-KR361-TOTAL-AMOUNT.      
           MOVE X1-ARNG-CHANNEL-CD       TO WS-KR361-ARNG-CHANNEL-CD.   
           MOVE 'Y'                      TO WS-KR361-COMPLIANCE-IND.    
                                                                        
           PERFORM 5000-PROCESS-ARNG-ATTRIBUTES                         
                                         THRU 5000-CPDKR361-EXIT.       
                                                                        
           IF WS-KR361-COMPLIANCE-ATTR-FL = 'Y'                         
              MOVE 'Y'                    TO WS-ARNG-COMPLIANCE-CD      
P00948        IF X1-ARNG-TYPE = 'STF' OR 'STFA'                         
P00948           MOVE WS-LEAST-AMT-DUE-CD TO C8-DELINQ-CD               
P00948           MOVE AT-COMPANY-NO       TO C8-COMPANY-NO              
P00948           PERFORM 7060-GET-DEL-VALUES THRU 7060-EXIT             
P00948           MOVE C8-DELINQ-VALUE     TO WS-LEAST-AMOUNT-DUE        
P00948           COMPUTE WS-REMAINING-AMT = WS-REMAINING-AMT -          
P00948                                      WS-LEAST-AMOUNT-DUE         
P00948        END-IF                                                    
P00948        IF WS-REMAINING-AMT < 0                                   
P00948           MOVE ZERO             TO WS-REMAINING-AMT              
P00948        END-IF                                                    
           ELSE                                                         
              MOVE 'N'                    TO WS-ARNG-COMPLIANCE-CD      
           END-IF.                                                      
                                                                        
       2030-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0726C******************************************************************        
P0726C* 2040-CALC-REMAINING-AMT                                        *        
P0726C******************************************************************        
P0726C                                                                  
P0726C 2040-CALC-REMAINING-AMT.                                         
P0726C                                                                  
P0726C     EVALUATE X1-ARNG-TYPE                                        
P0726C      WHEN 'CDD'                                                  
P0726C           MOVE WS-TOTAL-BALANCE       TO WS-REMAINING-AMT        
P0726C      WHEN 'CDDA'                                                 
P0726C           IF AT-DATE-BILL-DAY-00 < X1-ARNG-SETUP-DT              
P0726C              MOVE WS-TOTAL-BALANCE    TO WS-REMAINING-AMT        
P0726C           ELSE                                                   
P0726C              COMPUTE WS-TOTAL-ARREARS  = WS-AMT-ARREARS-UTL +    
P0726C                                          WS-AMT-ARREARS-NONUTL   
P0726C              IF AT-DATE-BILL-DAY-00 = X1-ARNG-SETUP-DT           
P0726C                 PERFORM 7050-SELECT-BILL-DETAILS THRU 7050-EXIT  
P0726D                 IF BI-LAST-UPDATE-TS < WS-ARNG-HIST-TS           
P0726C                    MOVE WS-TOTAL-BALANCE                         
P0726C                                       TO WS-REMAINING-AMT        
P0726C                 ELSE                                             
P0726C                    MOVE WS-TOTAL-ARREARS                         
P0726C                                       TO WS-REMAINING-AMT
                       END-IF        
P0726C              ELSE                                                
P0726C                 MOVE WS-TOTAL-ARREARS TO WS-REMAINING-AMT        
P0726C              END-IF                                              
P0726C           END-IF                                                 
P0726D      WHEN 'STA'                                                  
P00948      WHEN 'STF'                                                  
P0726D           IF AT-CREDIT-GROUP = 'B'                               
P0726E              MOVE WS-TOTAL-BALANCE    TO WS-REMAINING-AMT        
P0726D           ELSE                                                   
P0726D              MOVE WS-AMT-ARREARS-UTL  TO WS-REMAINING-AMT        
P0726D           END-IF                                                 
P0726D      WHEN 'STAA'                                                 
P00948      WHEN 'STFA'                                                 
P0726D           IF AT-DATE-BILL-DAY-00 < X1-ARNG-SETUP-DT              
P0726D              MOVE WS-TOTAL-BALANCE-UTL TO WS-REMAINING-AMT       
P0726D           ELSE                                                   
P0726D              MOVE ZEROES              TO WS-TOTAL-ARREARS        
P0726D              COMPUTE WS-TOTAL-ARREARS  = WS-AMT-ARREARS-UTL +    
P0726D                                          WS-AMT-ARREARS-NONUTL   
P0726D              IF AT-DATE-BILL-DAY-00 = X1-ARNG-SETUP-DT           
P0726D                 PERFORM 7030-SELECT-BILL-DETAILS THRU 7030-EXIT  
P0726D                 IF BI-LAST-UPDATE-TS < WS-ARNG-HIST-TS           
P0726D                    MOVE WS-TOTAL-BALANCE-UTL                     
P0726D                                       TO WS-REMAINING-AMT        
P0726D                 ELSE                                             
P0726D                    MOVE WS-AMT-ARREARS-UTL                       
P0726D                                       TO WS-REMAINING-AMT        
P0726D                 END-IF                                           
P0726D              ELSE                                                
P0726D                 MOVE WS-AMT-ARREARS-UTL                          
P0726D                                       TO WS-REMAINING-AMT        
P0726D              END-IF                                              
P0726D           END-IF                                                 
P0726D     END-EVALUATE.                                                
P0726D                                                                  
P0726D 2040-EXIT.                                                       
P0726D     EXIT.                                                        
P0726D                                                                  
      ******************************************************************        
      * 5200-MNT-TRAN-HEAD                                             *        
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER. THE FIRST   *        
      * TIME THE TRANSACTION DETAILS ROW IS WRITTEN                    *        
      ******************************************************************        
                                                                        
       5000-MNT-TRAN-HEAD.                                              
                                                                        
           MOVE 1                        TO WS-TRAN-APPL-NO             
                                            MI-TRAN-APPL-NO.            
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE SPACE                    TO MH-RESP-AREA-ID.            
           MOVE ZEROES                   TO MH-CUSTOMER-NO              
                                            MH-PREMISE-NO.              
           MOVE X1-ACCOUNT-NO            TO MH-ACCOUNT-NO.              
           MOVE 'SYSTEM'                 TO MH-USER-ID.                 
           MOVE 'PCSKR160'               TO MH-APPL-PROGRAM-ID.         
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5000-PROCESS-ARNG-ATTRIBUTES                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDKR361                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 5200-DEL-CRED-ARNG-ACTN-ROWS                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDKR137                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 5100-MNT-TRAN-DTLS                                             *        
      ******************************************************************        
                                                                        
       5100-MNT-TRAN-DTLS.                                              
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
                                                                        
      *MNT TRANS HIST FOR ARRANGEMENT TYPE                                      
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           ADD 1                         TO WS-TRAN-APPL-NO.            
           MOVE 'ARNG TYPE'              TO MI-COLUMN-DESC.             
           MOVE SPACES                   TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                         TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE X1-ARNG-TYPE             TO MI-CHG-COLUMN-VALUE-TEXT.   
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                         TO MI-CHG-COLUMN-VALUE-LEN.    
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
      *MNT TRANS HIST FOR ARRANGEMENT ID                                        
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           ADD 1                         TO WS-TRAN-APPL-NO.            
           MOVE 'ARNG ID'                TO MI-COLUMN-DESC.             
           MOVE SPACES                   TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                         TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE X1-ARNG-ID               TO MI-CHG-COLUMN-VALUE-TEXT.   
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                         TO MI-CHG-COLUMN-VALUE-LEN.    
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
      *MNT TRANS HIST FOR ARRANGEMENT STATUS                                    
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           ADD 1                         TO WS-TRAN-APPL-NO             
           MOVE 'ARNG STATUS'            TO MI-COLUMN-DESC.             
           MOVE 'ACTIVE'                 TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                         TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE 'COMPLETE'               TO MI-CHG-COLUMN-VALUE-TEXT.   
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                         TO MI-CHG-COLUMN-VALUE-LEN.    
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
      *MNT TRANS HIST FOR REMAINING AMOUNT                                      
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           ADD 1                         TO WS-TRAN-APPL-NO.            
           MOVE 'REMAINING AMT'          TO MI-COLUMN-DESC.             
           MOVE WX-ARNG-SCHD-PYMT-AMT    TO WS-COMP-2-CHAR-CONV         
           MOVE WS-COMP-2-CHAR-CONV      TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                         TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE WS-REMAINING-AMT         TO WS-COMP-2-CHAR-CONV         
           MOVE WS-COMP-2-CHAR-CONV      TO MI-CHG-COLUMN-VALUE-TEXT.   
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                         TO MI-CHG-COLUMN-VALUE-LEN.    
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
      *MNT TRANS HIST FOR ARRANGEMENT COMPLIANCE CODE                           
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE 'COMPLNCE IND'           TO MI-COLUMN-DESC.             
           MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                         TO MI-PRV-COLUMN-VALUE-LEN.    
           IF WS-ARNG-COMPLIANCE-CD = 'Y'                               
              MOVE 'YES'                 TO MI-CHG-COLUMN-VALUE-TEXT    
           ELSE                                                         
              MOVE 'NO'                  TO MI-CHG-COLUMN-VALUE-TEXT    
           END-IF.                                                      
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                         TO MI-CHG-COLUMN-VALUE-LEN.    
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00037                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6240-GET-FCA00-COMMON-DATE                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00040                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6540-INSERT-MNT-TRANS-HIST.                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * COPYBOOK CONTAINING DATE OVERRIDE RETRIEVAL LOGIC              *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 7620-START-FCSCA00                                             *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 7000-SELECT-TIMESTAMP-DATE                                     *        
      ******************************************************************        
                                                                        
       7000-SELECT-TIMESTAMP-DATE.                                      
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET  :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                    
MFA-TR*           ,:MH-DATE-TRANS        = CURRENT DATE                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-DISPLAY-SQLCODE.         
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR160 ABORT **********************'
              DISPLAY '* ABEND IN 7000-SELECT-TIMESTAMP-DATE          *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR160 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  7010-SELECT-ACCOUNT                                           *31850000
      ******************************************************************        
                                                                        
       7010-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT AT.CODES_DATA_PRESENT                              
                    ,AT.COMPANY_NO                                      
                    ,AT.ACCOUNT_TYPE_CODE                               
P0726A              ,AT.NOTICE_EXEMPT_CD                                
P0726A              ,AT.CODE_DISC_OK                                    
P0726A              ,AT.DATE_BILL_DAY_00                                
P0726A              ,AT.DATE_BILL_DAY_30                                
P0726A              ,AT.DATE_BILL_DAY_60                                
P0726A              ,AT.DATE_BILL_DAY_90                                
P0726A              ,AT.LOCAL_OFFICE                                    
P0726A              ,AT.BANKRUPTCY_IND                                  
P0726A              ,AT.CREDIT_GROUP                                    
P0726A              ,AT.CODE_ACCT_STAT                                  
P0726A              ,AT.IVR_EXEMPT_CD                                   
                INTO :AT-CODES-DATA-PRESENT                             
                    ,:AT-COMPANY-NO                                     
                    ,:AT-ACCOUNT-TYPE-CODE                              
P0726A              ,:AT-NOTICE-EXEMPT-CD                               
P0726A              ,:AT-CODE-DISC-OK                                   
P0726A              ,:AT-DATE-BILL-DAY-00 :WS-DATE-BILL-00-IND          
P0726A              ,:AT-DATE-BILL-DAY-30 :WS-DATE-BILL-30-IND          
P0726A              ,:AT-DATE-BILL-DAY-60 :WS-DATE-BILL-60-IND          
P0726A              ,:AT-DATE-BILL-DAY-90 :WS-DATE-BILL-90-IND          
P0726A              ,:AT-LOCAL-OFFICE                                   
P0726A              ,:AT-BANKRUPTCY-IND                                 
P0726A              ,:AT-CREDIT-GROUP                                   
P0726A              ,:AT-CODE-ACCT-STAT                                 
P0726A              ,:AT-IVR-EXEMPT-CD                                  
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     31860000
MFA-TR*       SELECT AT.CODES_DATA_PRESENT                              32000000
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                                       
MFA-TR*             ,AT.NOTICE_EXEMPT_CD                                        
MFA-TR*             ,AT.CODE_DISC_OK                                            
MFA-TR*             ,AT.DATE_BILL_DAY_00                                        
MFA-TR*             ,AT.DATE_BILL_DAY_30                                        
MFA-TR*             ,AT.DATE_BILL_DAY_60                                        
MFA-TR*             ,AT.DATE_BILL_DAY_90                                        
MFA-TR*             ,AT.LOCAL_OFFICE                                            
MFA-TR*             ,AT.BANKRUPTCY_IND                                          
MFA-TR*             ,AT.CREDIT_GROUP                                            
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.IVR_EXEMPT_CD                                           
MFA-TR*         INTO :AT-CODES-DATA-PRESENT                             32260000
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*             ,:AT-NOTICE-EXEMPT-CD                                       
MFA-TR*             ,:AT-CODE-DISC-OK                                           
MFA-TR*             ,:AT-DATE-BILL-DAY-00 :WS-DATE-BILL-00-IND                  
MFA-TR*             ,:AT-DATE-BILL-DAY-30 :WS-DATE-BILL-30-IND                  
MFA-TR*             ,:AT-DATE-BILL-DAY-60 :WS-DATE-BILL-60-IND                  
MFA-TR*             ,:AT-DATE-BILL-DAY-90 :WS-DATE-BILL-90-IND                  
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-BANKRUPTCY-IND                                         
MFA-TR*             ,:AT-CREDIT-GROUP                                           
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-IVR-EXEMPT-CD                                          
MFA-TR*         FROM CSS_ACCOUNT AT                                     32390000
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        32400000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                    32410000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
P0726A     IF WS-DATE-BILL-00-IND < 0                                   
P0726A        MOVE SPACES TO AT-DATE-BILL-DAY-00                        
P0726A        MOVE ZEROES TO WS-DATE-BILL-00-IND                        
P0726A     END-IF                                                       
P0726A     IF WS-DATE-BILL-30-IND < 0                                   
P0726A        MOVE SPACES TO AT-DATE-BILL-DAY-30                        
P0726A        MOVE ZEROES TO WS-DATE-BILL-30-IND                        
P0726A     END-IF                                                       
P0726A     IF WS-DATE-BILL-60-IND < 0                                   
P0726A        MOVE SPACES TO AT-DATE-BILL-DAY-60                        
P0726A        MOVE ZEROES TO WS-DATE-BILL-60-IND                        
P0726A     END-IF                                                       
P0726A     IF WS-DATE-BILL-90-IND < 0                                   
P0726A        MOVE SPACES TO AT-DATE-BILL-DAY-90                        
P0726A        MOVE ZEROES TO WS-DATE-BILL-90-IND                        
P0726A     END-IF                                                       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR160 ABORT **********************'
              DISPLAY '* ABEND IN 7010-SELECT-ACCOUNT                 *'
              DISPLAY '* ACCOUNT NO          = ' AT-ACCOUNT-NO          
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR160 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-SELECT-ARNG-PLAN-ID                                       *31850000
      ******************************************************************        
                                                                        
       7020-SELECT-ARNG-PLAN-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT UF.ARNG_PLAN_ID                                    
                INTO :UF-ARNG-PLAN-ID                                   
                FROM CSS_ARNG_PLAN UF WITH(READUNCOMMITTED)                     
               WHERE UF.ARNG_ID            = :X1-ARNG-ID                
                 AND UF.COMPANY_NO         = :AT-COMPANY-NO             
                 AND UF.REG_GROUP_CD       = :LR-REG-GROUP-CD           
P0726C           AND UF.ARNG_PLAN_EFF_DT  <= IIF(TRY_CONVERT(DATE, 
                                                      :X1-ARNG-SETUP-DT
              ) IS NULL OR (PATINDEX('%.%', :X1-ARNG-SETUP-DT
              ) <> 0) OR (LEN(:X1-ARNG-SETUP-DT) <> 10), CIS.CHAR2DATE(
                                                      :X1-ARNG-SETUP-DT
              ), CONVERT(DATE, :X1-ARNG-SETUP-DT) )          
P0726C           AND UF.ARNG_PLAN_EXP_DT  >= IIF(TRY_CONVERT(DATE, 
                                                      :X1-ARNG-SETUP-DT
              ) IS NULL OR (PATINDEX('%.%', :X1-ARNG-SETUP-DT
              ) <> 0) OR (LEN(:X1-ARNG-SETUP-DT) <> 10), CIS.CHAR2DATE(
                                                      :X1-ARNG-SETUP-DT
              ), CONVERT(DATE, :X1-ARNG-SETUP-DT) )          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     31860000
MFA-TR*       SELECT UF.ARNG_PLAN_ID                                            
MFA-TR*         INTO :UF-ARNG-PLAN-ID                                   32260000
MFA-TR*         FROM CSS_ARNG_PLAN UF                                           
MFA-TR*        WHERE UF.ARNG_ID            = :X1-ARNG-ID                        
MFA-TR*          AND UF.COMPANY_NO         = :AT-COMPANY-NO                     
MFA-TR*          AND UF.REG_GROUP_CD       = :LR-REG-GROUP-CD                   
MFA-TR*          AND UF.ARNG_PLAN_EFF_DT  <= :X1-ARNG-SETUP-DT                  
MFA-TR*          AND UF.ARNG_PLAN_EXP_DT  >= :X1-ARNG-SETUP-DT                  
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7020                                                       
MFA-TR*    END-EXEC.                                                    32410000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR160 ABORT **********************'
              DISPLAY '* ABEND IN 7020-SELECT-ARNG-PLAN-ID            *'
              DISPLAY '* COMPANY NO          = ' AT-COMPANY-NO          
              DISPLAY '* ARNG ID             = ' X1-ARNG-ID             
              DISPLAY '* REG GROUP CD        = ' LR-REG-GROUP-CD        
P0726C        DISPLAY '* ATNG SETUP DT       = ' X1-ARNG-SETUP-DT       
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR160 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0726D******************************************************************        
P0726D* 7030-SELECT-BILL-DETAILS                                       *        
P0726D******************************************************************        
P0726D                                                                  
P0726D 7030-SELECT-BILL-DETAILS.                                        
P0726D                                                                  
P0726D     EXEC SQL                                                     
P0726D        SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS           
P0726D          INTO :BI-LAST-UPDATE-TS                                 
P0726D          FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                      
P0726D         WHERE ACCOUNT_NO  = :BI-ACCOUNT-NO                       
P0726D           AND DATE_BILLED IS NOT NULL                            
P0726D         ORDER BY BILL_NO DESC                                    
P0726D                                                           
P0726D                                           
P0726D                                                      
P0726D     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LAST_UPDATE_TS                                             
MFA-TR*         INTO :BI-LAST-UPDATE-TS                                         
MFA-TR*         FROM CSS_BILLING_HDR                                            
MFA-TR*        WHERE ACCOUNT_NO  = :BI-ACCOUNT-NO                               
MFA-TR*          AND DATE_BILLED IS NOT NULL                                    
MFA-TR*        ORDER BY BILL_NO DESC                                            
MFA-TR*         WITH UR                                                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*      QUERYNO 7030                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726D                                                                  
P0726D     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P0726D                                                                  
P0726D     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726D         WHEN SUCCESSFUL-CALL                                     
P0726D              CONTINUE                                            
P0726D         WHEN NOT-FOUND                                           
P0726D              MOVE SPACES             TO BI-LAST-UPDATE-TS        
P0726D         WHEN OTHER                                               
P0726D              DISPLAY '********** PCSKR160 ABORT ****************'
P0726D              DISPLAY '* ABEND IN 7030-SELECT-BILL-DETAILS      *'
P0726D              DISPLAY '* ACCOUNT NO        = 'BI-ACCOUNT-NO       
P0726D              DISPLAY '* SQL RETURN CODE   = 'WS-DISPLAY-SQLCODE  
P0726D              DISPLAY '* PROCESSING TERMINATED                  *'
P0726D              DISPLAY '********** PCSKR160 ABORT ****************'
P0726D              PERFORM 9900-ABEND      THRU 9900-EXIT              
P0726D     END-EVALUATE.                                                
P0726D                                                                  
P0726D 7030-EXIT.                                                       
P0726D     EXIT.                                                        
P0726D                                                                  
      ******************************************************************        
      * 7040-SELECT-REG-PROFILE                                        *12450000
      ******************************************************************        
                                                                        
       7040-SELECT-REG-PROFILE.                                         
                                                                        
           EXEC SQL                                                     
              SELECT REG_GROUP_CD                                       
                INTO :LR-REG-GROUP-CD                                   
                FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12694000
MFA-TR*       SELECT REG_GROUP_CD                                       12695000
MFA-TR*         INTO :LR-REG-GROUP-CD                                   12696000
MFA-TR*         FROM CSS_REG_PROFILE                                    12697000
MFA-TR*        WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   12698000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*    END-EXEC.                                                    12699100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           EVALUATE SQLCODE                                             
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE SPACES TO LR-REG-GROUP-CD                      
               WHEN OTHER                                               
                    DISPLAY '********** PCSKR160 ABORT ****************'
                    DISPLAY '* ABEND IN 7040-SELECT-REG-PROFIE        *'
                    DISPLAY '* ACCOUNT NO        = 'AT-ACCOUNT-NO       
                    DISPLAY '* SQL RETURN CODE   = 'WS-DISPLAY-SQLCODE  
                    DISPLAY '* PROCESSING TERMINATED                  *'
                    DISPLAY '********** PCSKR160 ABORT ****************'
                    PERFORM 9900-ABEND      THRU 9900-EXIT              
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0726C******************************************************************        
P0726C* 7050-SELECT-BILL-DETAILS                                       *12450000
P0726C******************************************************************        
P0726C                                                                  
P0726C 7050-SELECT-BILL-DETAILS.                                        
P0726C                                                                  
P0726C     EXEC SQL                                                     
P0726C        SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS           
P0726C          INTO :BI-LAST-UPDATE-TS                                 
P0726C          FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                      
P0726C         WHERE ACCOUNT_NO  = :BI-ACCOUNT-NO                       
P0726C           AND DATE_BILLED IS NOT NULL                            
P0726C         ORDER BY BILL_NO DESC                                    
P0726C                                                           
P0726C                                           
P0726C                                                      
P0726C     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LAST_UPDATE_TS                                             
MFA-TR*         INTO :BI-LAST-UPDATE-TS                                         
MFA-TR*         FROM CSS_BILLING_HDR                                            
MFA-TR*        WHERE ACCOUNT_NO  = :BI-ACCOUNT-NO                               
MFA-TR*          AND DATE_BILLED IS NOT NULL                                    
MFA-TR*        ORDER BY BILL_NO DESC                                            
MFA-TR*         WITH UR                                                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726C                                                                  
P0726C     MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
P0726C                                                                  
P0726C     EVALUATE SQLCODE                                             
P0726C         WHEN SUCCESSFUL-CALL                                     
P0726C              CONTINUE                                            
P0726C         WHEN NOT-FOUND                                           
P0726C              MOVE SPACES             TO BI-LAST-UPDATE-TS        
P0726C         WHEN OTHER                                               
P0726C              DISPLAY '********** PCSKR160 ABORT ****************'
P0726C              DISPLAY '* ABEND IN 7050-SELECT-BILL-DETAILS      *'
P0726C              DISPLAY '* ACCOUNT NO        = 'BI-ACCOUNT-NO       
P0726C              DISPLAY '* SQL RETURN CODE   = 'WS-DISPLAY-SQLCODE  
P0726C              DISPLAY '* PROCESSING TERMINATED                  *'
P0726C              DISPLAY '********** PCSKR160 ABORT ****************'
P0726C              PERFORM 9900-ABEND      THRU 9900-EXIT              
P0726C     END-EVALUATE.                                                
P0726C                                                                  
P0726C 7050-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C                                                                  
P00948******************************************************************15740000
P00948* 7060-RETRIEVE-DEL.                                             *15750000
P00948******************************************************************15830000
P00948                                                                  
P00948 7060-GET-DEL-VALUES.                                             
P00948                                                                  
P00948     EXEC SQL                                                     
P00948        SELECT DELINQ_VALUE                                       
P00948          INTO :C8-DELINQ-VALUE                                   
P00948          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
P00948         WHERE DELINQ_CD = :C8-DELINQ-CD                          
P00948           AND COMPANY_NO = :C8-COMPANY-NO                        
P00948                                                           
P00948                                                      
P00948     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15910000
MFA-TR*       SELECT DELINQ_VALUE                                       15920000
MFA-TR*         INTO :C8-DELINQ-VALUE                                   15930000
MFA-TR*         FROM CSS_DELINQUENCY                                    15940000
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                          15950000
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7060                                                    
MFA-TR*    END-EXEC.                                                    15970000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00948                                                                  
P00948     MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
P00948                                         WS-ACTIVE-RETURN-CODE.   
P00948                                                                  
P00948     IF SQLCODE = SUCCESSFUL-CALL                                 
P00948        CONTINUE                                                  
P00948     ELSE                                                         
P00948        DISPLAY '********** PCSKR160 ABORT **********************'
P00948        DISPLAY '* ABEND IN 7060-GET-DEL-VALUES                 *'
P00948        DISPLAY '* COMPANY NO          = ' AT-COMPANY-NO          
P00948        DISPLAY '* DELINQ CODE         = ' C8-DELINQ-CD           
P00948        DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
P00948        DISPLAY '* PROCESSING TERMINATED                        *'
P00948        DISPLAY '********** PCSKR160 ABORT **********************'
P00948        PERFORM 9900-ABEND            THRU 9900-EXIT              
P00948     END-IF.                                                      
P00948                                                                  
P00948 7060-EXIT.                                                       
P00948     EXIT.                                                        
P00948                                                                  
      ******************************************************************        
      * 7500-OPEN-ARNG-DTLS                                            *        
      ******************************************************************        
                                                                        
       7500-OPEN-ARNG-DTLS.                                             
                                                                        
           EXEC SQL                                                     
              OPEN ARNG_DTLS                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR160 ABORT **********************'
              DISPLAY '* ABEND IN 7500-OPEN-ARNG-DTLS                 *'
              DISPLAY '* ARNG_DTLS CSR ERROR                          *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR160 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7510-FETCH-ARNG-DTLS                                           *        
      ******************************************************************        
       7510-FETCH-ARNG-DTLS.                                            
                                                                        
           EXEC SQL                                                     
              FETCH ARNG_DTLS                                           
               INTO :X1-ACCOUNT-NO                                      
                   ,:X1-ARNG-ID                                         
                   ,:X1-ARNG-COMPLIANCE-CD                              
                   ,:X1-CRED-ARNG-SEQ                                   
                   ,:X1-ARNG-CHANNEL-CD                                 
                   ,:X1-ARNG-TYPE                                       
P0726C             ,:X1-ARNG-SETUP-DT                                   
P0726C             ,:X1-ARNG-OPTION-ID                                  
                   ,:WX-ARNG-SCHD-SEQ :WS-ARNG-SCHD-SEQ-NULL       
                   ,:WX-ARNG-SCHD-DUE-DT                                
                   ,:WX-ARNG-SCHD-PYMT-AMT                              
P0726D             ,:WS-ARNG-HIST-TS                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-DISPLAY-SQLCODE.        
                                                                        
           IF WS-ARNG-SCHD-SEQ-NULL  < 0                                
              MOVE ZEROES                 TO WX-ARNG-SCHD-SEQ           
                                             WS-ARNG-SCHD-SEQ-NULL      
           END-IF                                                       
                                                                        
           EVALUATE SQLCODE                                             
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y' TO WS-NO-MORE-DATA                         
               WHEN OTHER                                               
                    DISPLAY '********** PCSKR160 ABORT ****************'
                    DISPLAY '* ABEND IN 7510-FETCH-ARNG-DTLS          *'
                    DISPLAY '* ARNG_DTLS CSR ERROR                    *'
                    DISPLAY '* SQL RETURN CODE   = 'WS-DISPLAY-SQLCODE  
                    DISPLAY '* ARNG SCHD DUE DT  = 'WS-RUN-DATE         
                    DISPLAY '* PROCESSING TERMINATED                  *'
                    DISPLAY '********** PCSKR160 ABORT ****************'
                    PERFORM 9900-ABEND    THRU 9900-EXIT                
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7520-CLOSE-ARNG-DTLS                                           *        
      ******************************************************************        
                                                                        
       7520-CLOSE-ARNG-DTLS.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE ARNG_DTLS                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-DISPLAY-SQLCODE.          
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR160 ABORT **********************'
              DISPLAY '* ABEND IN 7520-CLODE-ARNG-DTLS                *'
              DISPLAY '* ARNG_DTLS CSR ERROR                          *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR160 ABORT **********************'
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8400-UPDATE-CRED-ARNG                                          *        
      ******************************************************************        
                                                                        
       8400-UPDATE-CRED-ARNG.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CRED_ARNGMENT                                  
                 SET ARNG_STATUS_CD     = 'C'                           
                    ,ARNG_COMPLIANCE_CD = :WS-ARNG-COMPLIANCE-CD        
                    ,LAST_UPDATE_USERID = 'SYSTEM'                      
               WHERE ACCOUNT_NO         = :X1-ACCOUNT-NO                
                 AND ARNG_ID            = :X1-ARNG-ID                   
                 AND CRED_ARNG_SEQ      = :X1-CRED-ARNG-SEQ             
                 AND ARNG_STATUS_CD     = 'A'                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-DISPLAY-SQLCODE.         
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL  OR NOT-FOUND                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR160 ABORT **************'        
              DISPLAY '* 8400-UPDATE-CRED-ARNG                *'        
              DISPLAY '* ACCOUNT NO       = ' X1-ACCOUNT-NO             
              DISPLAY '* ARRANGEMENT ID   = ' X1-ARNG-ID                
              DISPLAY '* CRED ARNG SEQ    = ' X1-CRED-ARNG-SEQ          
              DISPLAY '* SQLCODE          = ' WS-DISPLAY-SQLCODE        
              DISPLAY '* PROCESSING TERMINATED                *'        
              DISPLAY '********** PCSKR160 ABORT **************'        
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8410-UPDATE-ACCOUNT                                            *        
      ******************************************************************        
                                                                        
       8410-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET CODES_DATA_PRESENT = :WS-KR160-CODES-PRESENT       
                    ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
               WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*          SET CODES_DATA_PRESENT = :WS-KR160-CODES-PRESENT               
MFA-TR*             ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*        WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE      TO WS-DISPLAY-SQLCODE.                     
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR160 ABORT **************'        
              DISPLAY '* 8410-UPDATE-ACCOUNT                  *'        
              DISPLAY '* ACCOUNT NO         = ' AT-ACCOUNT-NO           
              DISPLAY '* CODES DATA PRESENT = ' WS-KR160-CODES-PRESENT  
              DISPLAY '* SQLCODE            = ' WS-DISPLAY-SQLCODE      
              DISPLAY '* PROCESSING TERMINATED                *'        
              DISPLAY '********** PCSKR160 ABORT **************'        
              PERFORM 9900-ABEND          THRU 9900-EXIT                
           END-IF.                                                      
                                                                        
       8410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8600-INSERT-ARNG-HIST                                          *        
      ******************************************************************        
                                                                        
       8600-INSERT-ARNG-HIST.                                           
                                                                        
           IF WY-ARNG-DUE-DT    = LOW-VALUES OR SPACES                  
              MOVE -1                     TO WS-ARNG-DUE-DT-NULL        
           ELSE                                                         
              MOVE ZERO                   TO WS-ARNG-DUE-DT-NULL        
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CRED_ARNG_HIST                            
                  (ACCOUNT_NO                                           
                 ,ARNG_ID                                               
                 ,CRED_ARNG_SEQ                                         
                 ,ARNG_HIST_TS                                          
                 ,ARNG_CHANGE_CD                                        
                 ,TOTAL_AR_BALANCE                                      
                 ,TOTAL_UTL_BAL                                         
                 ,TOTAL_NONUTL_BAL                                      
                 ,UTL_ARREARS_AMT                                       
                 ,NONUTL_ARREARS_AMT                                    
                 ,ARNG_DUE_DT                                           
P0726B           ,ARNG_SCHD_SEQ                                         
                 ,CHANGE_COMMENTS                                       
                 ,LAST_UPDATE_TS                                        
                 ,LAST_UPDATE_USERID)                                   
              VALUES                                                    
                  (:WY-ACCOUNT-NO                                       
                 ,:WY-ARNG-ID                                           
                 ,:WY-CRED-ARNG-SEQ                                     
                 ,CIS.CHAR2TIMESTAMP(:WY-ARNG-HIST-TS)                          
                 ,:WY-ARNG-CHANGE-CD                                    
                 ,:WY-TOTAL-AR-BALANCE                                  
                 ,:WY-TOTAL-UTL-BAL                                     
                 ,:WY-TOTAL-NONUTL-BAL                                  
                 ,:WY-UTL-ARREARS-AMT                                   
                 ,:WY-NONUTL-ARREARS-AMT                                
                 ,IIF(TRY_CONVERT(DATE, :WY-ARNG-DUE-DT 
                                        :WS-ARNG-DUE-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :WY-ARNG-DUE-DT 
                                                   :WS-ARNG-DUE-DT-NULL
              ) <> 0) OR (LEN(:WY-ARNG-DUE-DT :WS-ARNG-DUE-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:WY-ARNG-DUE-DT 
                                                   :WS-ARNG-DUE-DT-NULL
              ), CONVERT(DATE, :WY-ARNG-DUE-DT :WS-ARNG-DUE-DT-NULL) )         
P0726B           ,:WY-ARNG-SCHD-SEQ                                     
                 ,:WY-CHANGE-COMMENTS                                   
                 ,CIS.CHAR2TIMESTAMP(:WY-LAST-UPDATE-TS)                        
                 ,:WY-LAST-UPDATE-USERID)                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CRED_ARNG_HIST                                    
MFA-TR*           (ACCOUNT_NO                                                   
MFA-TR*          ,ARNG_ID                                                       
MFA-TR*          ,CRED_ARNG_SEQ                                                 
MFA-TR*          ,ARNG_HIST_TS                                                  
MFA-TR*          ,ARNG_CHANGE_CD                                                
MFA-TR*          ,TOTAL_AR_BALANCE                                              
MFA-TR*          ,TOTAL_UTL_BAL                                                 
MFA-TR*          ,TOTAL_NONUTL_BAL                                              
MFA-TR*          ,UTL_ARREARS_AMT                                               
MFA-TR*          ,NONUTL_ARREARS_AMT                                            
MFA-TR*          ,ARNG_DUE_DT                                                   
MFA-TR*          ,ARNG_SCHD_SEQ                                                 
MFA-TR*          ,CHANGE_COMMENTS                                               
MFA-TR*          ,LAST_UPDATE_TS                                                
MFA-TR*          ,LAST_UPDATE_USERID)                                           
MFA-TR*       VALUES                                                            
MFA-TR*           (:WY-ACCOUNT-NO                                               
MFA-TR*          ,:WY-ARNG-ID                                                   
MFA-TR*          ,:WY-CRED-ARNG-SEQ                                             
MFA-TR*          ,:WY-ARNG-HIST-TS                                              
MFA-TR*          ,:WY-ARNG-CHANGE-CD                                            
MFA-TR*          ,:WY-TOTAL-AR-BALANCE                                          
MFA-TR*          ,:WY-TOTAL-UTL-BAL                                             
MFA-TR*          ,:WY-TOTAL-NONUTL-BAL                                          
MFA-TR*          ,:WY-UTL-ARREARS-AMT                                           
MFA-TR*          ,:WY-NONUTL-ARREARS-AMT                                        
MFA-TR*          ,:WY-ARNG-DUE-DT       :WS-ARNG-DUE-DT-NULL                    
MFA-TR*          ,:WY-ARNG-SCHD-SEQ                                             
MFA-TR*          ,:WY-CHANGE-COMMENTS                                           
MFA-TR*          ,:WY-LAST-UPDATE-TS                                            
MFA-TR*          ,:WY-LAST-UPDATE-USERID)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-DISPLAY-SQLCODE.                          
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR160 ABORT **************'        
              DISPLAY '* 8600-INSERT-ARNG-HIST                *'        
              DISPLAY '* ACCOUNT NO         = ' WY-ACCOUNT-NO           
              DISPLAY '* ARNG ID            = ' WY-ARNG-ID              
              DISPLAY '* CRED ARNG SEQ      = ' WY-CRED-ARNG-SEQ        
              DISPLAY '* SQLCODE            = ' WS-DISPLAY-SQLCODE      
              DISPLAY '* PROCESSING TERMINATED                *'        
              DISPLAY '********** PCSKR160 ABORT **************'        
              PERFORM 9900-ABEND          THRU 9900-EXIT                
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8888-COMMIT.                                                   *        
      ******************************************************************        
                                                                        
       8888-COMMIT.                                                     
                                                                        
           ADD 1       TO WS-COMMITS-COUNT                              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
                                                                        
           MOVE ZEROES TO WS-RECS-TO-COMMIT-COUNT.                      
           DISPLAY '*************************************************'  
           DISPLAY '* COMMIT POINT # ' WS-COMMITS-COUNT  ' TAKEN.   *'  
           DISPLAY '* LAST REC PROCESSED  = ' AT-ACCOUNT-NO             
           DISPLAY '*************************************************'. 
                                                                        
       8888-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK               *        
      ******************************************************************        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
                                                                        
      ******************************************************************        
      * 9000-TERMINATE.                                                *        
      ******************************************************************        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-PROCESS-ABEND.                                            *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
             INCLUDE CPD0023B                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * THIS ROUTINE IS NEEDED FOR CPD00067                            *        
      ******************************************************************        
       9900-SQL-ERROR-ROUTINE.                                          
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           RS-RETURN-CODE,                              
                           WS-DISP-RETURN-CODE.                         
           DISPLAY ' '                                                  
           DISPLAY '**********************************************'     
           DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
           DISPLAY '**********************************************'     
           DISPLAY ' '                                                  
           DISPLAY 'SQLCODE = ' WS-DISP-RETURN-CODE                     
           DISPLAY ABEND-RECORD-1-DATA                                  
           DISPLAY ABEND-RECORD-2-DATA                                  
           DISPLAY ABEND-RECORD-3-DATA                                  
           DISPLAY '**********************************************'     
           PERFORM 9900-ABEND             THRU 9900-EXIT.               
      *                                                                         
      ******************************************************************        
      * 9900-ABEND                                                     *        
      * COPYBOOK FOR ABEND/ERROR PROCESSING                            *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD09900                                                
           END-EXEC.                                                            
                                                                        
P0726D******************************************************************11440000
P0726D* 9999-BAIL-OUT                                                  *11740000
P0726D******************************************************************11460000
P0726D                                                                  
P0726D 9999-BAIL-OUT.                                                   
P0726D                                                                  
P0726D 9999-EXIT.                                                       
P0726D     EXIT.                                                        
P0726D                                                                  
