       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSKR150.                                          
       AUTHOR.       AARON ABRAHAM.                                     
       DATE-WRITTEN. OCT 2012.                                          
       DATE-COMPILED.                                                   
      ******************************************************************        
      **               SOUTH CAROLINA ELECTRIC & GAS                  **        
      **                      COBOL-DB2                               **        
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **                                                              **        
      ** THIS IS THE DRIVER PROGRAM TO GET DATA FROM CORRESPONDENCE   **        
      ** TABLES AND PASS THE DATA TO A BILL PRINT SUB PROGRAM, WHICH  **        
      ** WILL CREATE A FILE FOR EXSTREAM.                             **        
      **                                                              **        
      ** THE FOLLOWING MODULES ARE CALLED:                            **        
      **     SCSCA121 - BILL PRINT SUB PROGRAM.                       **        
      **                                                              **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 3999     OUTPUT PROCESS CONTROL PATH           **        
      **        4000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **              PROGRAM  MODIFICATION  LOG                      **        
      ******************************************************************        
      ** DATE     USERID   REASON                                     **        
      ** -------  -------  ------                                     **        
P00599** 08/2012  AA97148  INITIAL IMPLEMENTATION.                    **        
P00599** 02/2013  GOKUL    POPULATE TIER-ACCT-TYPE FOR SEB.           **        
P0599A** 02/2013  AA97148  ADD MAIL AND CREDIT LTR DATE IN UPDATE STMT**        
P0599B** 02/2013  GOKUL    POPULATE THE CORRECT COMPANY-NO TO GET     **        
P0599B**                   CORRESP-CONTACT ADDRESS.                   **        
P0599D** 02/2013  AA97148  USE CR-HIST-TRAN-DT TO POPULATE CK-CR-HIST-**        
P0599D**                   TRAN-DT AND IF NOT PRESENT THEN USE        **        
P0599D**                   CORRESP-STMT-DT.                           **        
A04527** 03/20/13 SS42021  DO NOT CHECK FOR POSID OR CREDIT SCORE     **        
A04527**                   WHEN GETTING MAX CREDIT SCORE DATE AND TIME**        
A04527**                   POSID SCORES WOULD NEVER GENERATE ALOC.    **        
A04527**                   CHANGE WAS MADE IN 7320-MAX-DATE-TIME-SCOR.**        
ACT039** 03/28/13 BD09555  ADD 'FETCH FIRST ROW' TO SELECT IN         **        
ACT039** A04527            PARAGRAPH 7400-SELECT-CIG-ACCT             **        
A04527** 06/07/13 AA97148  IF NO MATCHING ROW FOUND IN CORRESP COMM   **        
A04527**                   TABLE THEN SKIP THE ACCOUNT FROM PROCESS.  **        
A04494** 06/11/13 AA97148  POPULATE CODE_ACCT_STAT TO THE NEWLY ADDED **        
A04494**                   HDR(WS-EXT-ACCT-STAT) VARIABLE - ACT014.   **        
ACT084** 06/26/13 AA97148  REMOVED UNUSED COPYBOOK CWSCB108           **        
ACT023** 01/28/14 RB19957  CHANGE WS-EXT-PRP-FLAG FLAG FROM BEING SET **00500000
ACT023**    APPL00004880   WITH AN 'A' TO 'Y'.                        **00500000
ACT135** 11/05/14 BD09555  PASS REFUND ADDRESS WHEN PRESENT IN        **00500000
ACT135**    A04880         CSS_CORRESP_VAR TABLE                      **00500000
A05198** 11/23/15 MJ13662  SELECT ADDL-CRED-SCORE AND SCORE-MODEL-CD  **        
A05198**                   FROM CSS_CREDIT_HIST. IF SCORE-MODEL-CD = A**        
A05198**                   AND NOT SPACES/ZEROES, MOVE ADDL-CRED-SCORE**        
A05198**                   TO WS-EXT-NUM-VARIABLE(1).                 **        
A05198**                   IF SCORE-MODE-CD NOT = A AND NOT SPACE/ZEROE*        
A05198**                   MOVE BEACON-SCORE TO WS-EXT-NUM-VARIABLE(1)**        
A05198**                   SELECT MIN/MAX SCORES USING SCORE-MODEL-CD.**        
A05198**                   MOVE SCORE-MODEL-CD TO                     **        
A05198**                   WS-EXT-NUM-VARIABLE(6) TO BE USED IN       **        
A05198**                   SCSCA121.                                  **        
A05382**                   ADD LOGIC FOR RISK BASED PRICING LETTER -  **        
A05382**                   90704.                                     **        
A05460** 04/13/16 MJ13662  WHEN PROCESSING ALOC AND ITPA LETTERS      **        
A05460**                   SELECT MOST RECENT ROW ON CSS_CREDIT_HIST  **        
A05460**                   AND CSS_CRED_ITPA_HIST. IF ADV-CREDIT-LTR = *        
A05460**                   N, UPDATE CORRESP-STATUS-CD TO C.          **        
A05460**                   IF MSG-ID = 92061/62 AND LETTER-NOTIFY-CD =**        
A05460**                   NOT = 'A', UPDATE STATUS-CD TO C.          **        
A05460**                   IF MSG-ID = 92063/64 AND LETTER-NOTIFY-CD =**        
A05460**                   NOT = 'U', UPDATE STATUS-CD TO C.          **        
A05460**                   ACT115                                     **        
ACT187** 06/02/16 MC95456  ADD ACCOUNT-TYPE-CODE TO OUTPUT FILE.      **        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSKR150.                                                           
      *RESTART FILE FOR KR150                                                   
       COPY CSSKR150 REPLACING FCSKR150-FILE      BY FCSKR50R-FILE,             
                               UT-S-FCSKR150      BY UT-S-FCSKR50R,             
                               WS-FCSKR150-STATUS BY WS-FCSKR50R-STATUS.        
                                                                        
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *OUTPUT FILE                                                              
       COPY CFDKR150.                                                           
       01   EXTKR150                     PIC X(1375).                   
                                                                        
      *RESTART FILE                                                             
       COPY CFDKR150 REPLACING FCSKR150-FILE      BY FCSKR50R-FILE.             
       01   FIOKR50R                     PIC X(1375).                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSKR150'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                       PIC X(40) VALUE                
                        'WORKING STORAGE FOR PCSKR150 STARTS HERE'.     
       01 WS-MISC.                                                      
          05 WS-DISPLAY-SQLCODE          PIC -Z(8)9.                    
          05 WS-PROCESS-COUNTER          PIC S9(09)  COMP VALUE +0.     
          05 WS-FCSKR150-CNTR            PIC S9(09)  COMP VALUE +0.     
          05 WS-READY-TO-INSERT-COUNT    PIC S9(09)  COMP VALUE +0.     
          05 WS-DEFAULT-INSERT-COUNT     PIC S9(09)  COMP VALUE +100.   
          05 WS-ACCTS-TO-SKIP            PIC S9(09)  COMP VALUE +0.     
          05 WS-DEFAULT-ACCTS-TO-SKIP    PIC S9(09)  COMP VALUE +50.    
          05 WS-SKIP-COUNTER             PIC S9(09)  COMP VALUE +0.     
          05 WS-ACCOUNT-NO               PIC S9(13)V COMP-3 VALUE 0.    
          05 WS-RESTART-ACCT-NO          PIC S9(13)V COMP-3 VALUE 0.    
          05 WS-CORRESP-ID               PIC S9(13)V COMP-3 VALUE 0.    
          05 WS-CA165-RET                PIC S9(04)  COMP VALUE 0.      
P0599A    05 WS-TRAN-APPL-NO             PIC S9(04)  COMP VALUE 0.      
          05 WS-RECORD-CNT               PIC 9(02)   VALUE 0.           
          05 S-RETURN-CODE               PIC S9(04)  COMP VALUE 0.      
          05 RS-RETURN-CODE-DISP         PIC -Z(3)9.                    
          05 WS-DISPLAY-ACCOUNT          PIC 9(13)   VALUE 0.           
          05 WS-COUNT-UNSUCCESSFUL-ROWS  PIC S9(09) COMP VALUE 0.       
          05 WS-FCSKR50R-CNTR            PIC S9(09)  VALUE ZERO COMP-3. 
P0599A    05 WS-PREV-LETTER-NOTIFY-CD    PIC X(01)   VALUE SPACES.      
P0599A    05 WS-HOLD-COMM-INSERT-FL      PIC X(01)   VALUE SPACES.      
P0599A    05 WS-BILL-OPTION-CD           PIC X(01)   VALUE SPACES.      
P0599D    05 WS-CR-HIST-TRAN-DT          PIC X(10)   VALUE SPACES.      
A04527    05 WS-CORR-COMM-ROW-FOUND      PIC X(01)   VALUE 'N'.         
          05 WS-CORRESP-COMPANY-NO       PIC X(02)   VALUE SPACES.      
          05 WS-RUN-DATE                 PIC X(10)   VALUE SPACES.      
          05 WS-TEST-DATE                PIC X(10) VALUE SPACES.        
          05 WS-VALID-DATE               PIC X(10) VALUE SPACES.        
          05 WS-PROCESS-MSG-STATUS       PIC X(01)   VALUE SPACES.      
          05 WS-CUSTOMER-NO              PIC S9(10)V COMP-3 VALUE 0.    
          05 WS-MSG-ID                   PIC X(05)   VALUE SPACES.      
          05 WS-LAST-4-SSN-NO            PIC X(04)   VALUE SPACES.      
P0599A    05 WS-INITIAL-COMMENT-TX.                                     
P0599A       10 WS-INITIAL-COMMENT-TX-LEN   PIC S9(4) USAGE COMP.       
P0599A       10 WS-INITIAL-COMMENT-TX-TEXT  PIC X(255).                 
P0599A    05 WS-DISPLAY-CORRESP.                                        
P0599A       10 FILLER                   PIC X(07) VALUE 'ACCT # '.     
P0599A       10 WS-DISP-ACCT             PIC 9(13).                     
P0599A       10 FILLER                   PIC X(09) VALUE ', CUST # '.   
P0599A       10 WS-DISP-CUST-NO          PIC 9(10).                     
P0599A       10 FILLER                   PIC X(15) VALUE                
P0599A                                             ', CORRESP ID # '.   
P0599A       10 WS-DISP-CORR-ID          PIC 9(13).                     
          05 WS-CORR-PHONE-NO.                                          
             10 WS-CORR-AREA-CD1         PIC X(01) VALUE '1'.           
             10 FILLER                   PIC X(01) VALUE '-'.           
             10 WS-CORR-AREA-CD3         PIC X(03) VALUE SPACES.        
             10 FILLER                   PIC X(01) VALUE '-'.           
             10 WS-CORR-TEL-NO3          PIC X(03) VALUE SPACES.        
             10 FILLER                   PIC X(01) VALUE '-'.           
             10 WS-CORR-TEL-NO4          PIC X(04) VALUE SPACES.        
          05 WS-HOME-PHONE-NBR.                                         
             10 FILLER                   PIC X VALUE '('.               
             10 WS-HOME-PHONE-1          PIC X(3).                      
             10 FILLER                   PIC X VALUE ')'.               
             10 WS-HOME-PHONE-2          PIC X(3).                      
             10 FILLER                   PIC X VALUE '-'.               
             10 WS-HOME-PHONE-3          PIC X(4).                      
             10 FILLER                   PIC X VALUE SPACES.            
          05 WS-WORK-PHONE-NBR.                                         
             10 FILLER                   PIC X VALUE '('.               
             10 WS-WORK-PHONE-1          PIC X(3).                      
             10 FILLER                   PIC X VALUE ')'.               
             10 WS-WORK-PHONE-2          PIC X(3).                      
             10 FILLER                   PIC X VALUE '-'.               
             10 WS-WORK-PHONE-3          PIC X(4).                      
             10 FILLER                   PIC X VALUE SPACES.            
          05 WS-HOME-PHONE-EXT           PIC X(6)    VALUE SPACES.      
          05 WS-WORK-PHONE-EXT           PIC X(6)    VALUE SPACES.      
          05 WS-CHKP-LUW-LIMIT           PIC 9(04)   VALUE 0.           
          05 WS-CHKP-UPD-LIMIT           PIC 9(04)   VALUE 0.           
          05 WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04)   VALUE 5.           
          05 WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04)   VALUE 5.           
          05 WS-ACCOUNT-EXISTS           PIC X(01)   VALUE SPACES.      
          05 WS-CORRESP-STATUS-CD        PIC X(01)   VALUE SPACES.      
          05 MAX-CR-HIST-TRAN-DT         PIC X(10)   VALUE SPACES.      
          05 MAX-CR-HIST-TRAN-TM         PIC X(08)   VALUE SPACES.      
ACT115    05 RECENT-ADV-CREDIT-LTR       PIC X(01)   VALUE SPACE.       
ACT115    05 RECENT-LETTER-NOTIFY-CD     PIC X(01)   VALUE SPACE.       
          05 WS-TIMESTAMP                PIC X(26)   VALUE SPACES.      
          05 WS-SCEG                     PIC X(02) VALUE '01'.          
P0599C    05 WS-PSNC                     PIC X(02) VALUE '26'.          
          05 WS-DENY                     PIC X(01) VALUE 'R'.           
          05 WS-COLLECT                  PIC X(01) VALUE 'C'.           
          05 WS-DEP-WAIVER               PIC X(01) VALUE 'D'.           
          05 WS-DHR-UTILITY              PIC X(01) VALUE 'K'.           
          05 WS-ACN-ACCOUNT              PIC X(01) VALUE 'A'.           
          05 WS-RECONNECT                PIC X(01) VALUE 'R'.           
          05 WS-MERCHANDISE              PIC X(01) VALUE 'M'.           
          05 WS-HVAC                     PIC X(01) VALUE 'H'.           
          05 WS-CK-CR-MIN-MAX-KEY.                                      
             10 WS-CK-CR-CHK-COMPANY-NO     PIC X(02) VALUE SPACE.      
             10 WS-CK-REG-GROUP-CD          PIC X(03) VALUE SPACE.      
             10 WS-CK-CR-RQST-REASON-CD     PIC X(01) VALUE SPACE.      
             10 WS-SCORE-TYPE               PIC X(01) VALUE SPACE.      
          05 WS-FORMAT-ZIP-PLUS.                                        
             10 WS-FORMAT-ZIP-1          PIC X(5).                      
             10 FILLER                   PIC X  VALUE '-'.              
             10 WS-FORMAT-ZIP-2          PIC X(4).                      
ACT115    05 WS-CREATED-BY-PGM-ID.                                      
ACT115       10 WS-CREATED-BY-PGM-7      PIC X(7)     VALUE SPACES.     
ACT115       10 WS-CREATED-RQST-REASON   PIC X(1)     VALUE SPACE.      
                                                                        
       01 WS-NULL-INDICATORS.                                           
          05 WS-NOTICE-DUE-DT-NULL       PIC S9(04)   COMP VALUE 0.     
          05 WS-LAST-PYMT-DT-NULL        PIC S9(04)   COMP VALUE 0.     
          05 WS-ADDR-STREET1-NULL        PIC S9(04)   COMP VALUE 0.     
          05 WS-ADDR-STREET2-NULL        PIC S9(04)   COMP VALUE 0.     
          05 WS-ADDR-ZIP-CODE-NULL       PIC S9(04)   COMP VALUE 0.     
          05 WS-ADDR-COUNTRY-NULL        PIC S9(04)   COMP VALUE 0.     
          05 WS-CORRESP-ACCOUNT-NULL     PIC S9(04)   COMP VALUE 0.     
          05 WS-CORRESP-STMT-DT-NULL     PIC S9(04)   COMP VALUE 0.     
          05 WS-ADDR-CITY-NULL           PIC S9(04)   COMP VALUE 0.     
          05 WS-ADDR-STATE-NULL          PIC S9(04)   COMP VALUE 0.     
          05 WS-CORR-ACCT-NULL           PIC S9(04)   COMP VALUE 0.     
          05 WS-NULL-IND1                PIC S9(04)   COMP VALUE 0.     
          05 WS-END-NULL-IND             PIC S9(04)   COMP VALUE 0.     
          05 WS-RED-FL-NULL-IND          PIC S9(04)   COMP VALUE 0.     
                                                                        
       01 WS-SWITCHES.                                                  
          05 WS-PROCESS-ACCOUNT          PIC X(01)   VALUE 'Y'.         
             88 PROCESS-ACCT                         VALUE 'Y'.         
             88 SKIP-ACCT                            VALUE 'N'.         
                                                                        
          05  WS-END-OF-FILE-SW          PIC X(01)   VALUE 'N'.         
              88 END-OF-FILE                         VALUE 'Y'.         
                                                                        
          05 WS-FCSKR150-STATUS          PIC X(02).                     
             88 FCSKR150-SUCCESSFUL                  VALUE '00'.        
             88 END-OF-FCSKR150                      VALUE '10'.        
                                                                        
          05 WS-FCSKR50R-STATUS          PIC X(02).                     
             88 FCSKR50R-SUCCESSFUL                  VALUE '00'.        
             88 END-OF-FCSKR50R                      VALUE '10'.        
                                                                        
          05 WS-UPDATE-DB-FL             PIC X(01).                     
             88 UPDATE-DB-FL                         VALUE 'Y'.         
                                                                        
          05 WS-DATABASE                 PIC 9(01).                     
             88 CSR-DATABASE                         VALUE 1.           
             88 SEB-DATABASE                         VALUE 2.           
                                                                        
          05 WS-VALID-DATE-FLAG          PIC X(01)   VALUE 'N'.         
             88 INVALID-DATE                         VALUE 'Y'.         
                                                                        
P0599D    05 WS-TRAN-TM-FL               PIC X(01)   VALUE 'N'.         
P0599D       88 TRAN-TM-FOUND                        VALUE 'Y'.         
                                                                        
          05 WS-CORRESP-VAR-NM           PIC X(20)     VALUE SPACES.    
             88 CC-ADDRESS-FORMAT         VALUE 'CC-ADDRESS-FORMAT   '. 
             88 CC-ADDRESS-ID             VALUE 'CC-ADDRESS-ID       '. 
             88 CC-NAME-ID                VALUE 'CC-NAME-ID          '. 
ACT135       88 RN-ADDRESS-ID             VALUE 'RN-ADDRESS-ID       '. 
ACT135       88 RN-ADDRESS-FORMAT         VALUE 'RN-ADDRESS-FORMAT   '. 
             88 ALPHA-VAR-1               VALUE 'ALPHA-VAR-1         '. 
             88 ALPHA-VAR-2               VALUE 'ALPHA-VAR-2         '. 
             88 ALPHA-VAR-3               VALUE 'ALPHA-VAR-3         '. 
             88 ALPHA-VAR-4               VALUE 'ALPHA-VAR-4         '. 
             88 ALPHA-VAR-5               VALUE 'ALPHA-VAR-5         '. 
             88 NUM-VAR-1                 VALUE 'NUM-VAR-1           '. 
             88 NUM-VAR-2                 VALUE 'NUM-VAR-2           '. 
             88 NUM-VAR-3                 VALUE 'NUM-VAR-3           '. 
             88 NUM-VAR-4                 VALUE 'NUM-VAR-4           '. 
             88 NUM-VAR-5                 VALUE 'NUM-VAR-5           '. 
             88 DEP-CERT-NO               VALUE 'DEP-CERT-NO         '. 
             88 ESC-RETURN-DT             VALUE 'ESC-RETURN-DT       '. 
                                                                        
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME                PIC X(08) VALUE 'PCSKR150'.    
          05 WS-PGRMNAME                 PIC X(08) VALUE 'PCSKR150'.    
          05 WS-COMMON-DATE              PIC X(10) VALUE 'COMMONDATE'.  
          05 SCSCA121                    PIC X(08) VALUE 'SCSCA121'.    
          05 SCSCA165                    PIC X(08) VALUE 'SCSCA165'.    
          05 SCSCA151                    PIC X(08) VALUE 'SCSCA151'.    
          05 WS-Y                        PIC X(01) VALUE 'Y'.           
          05 WS-N                        PIC X(01) VALUE 'N'.           
          05 WS-I                        PIC X(01) VALUE 'I'.           
          05 WS-D                        PIC X(01) VALUE 'D'.           
          05 WS-SYSTEM                   PIC X(06) VALUE 'SYSTEM'.      
      *                                                                         
       01 WS-RESTART-MISC.                                              
          05 WS-RESTART-DATA-LENGTH      PIC S9(04) COMP VALUE +45.     
          05 WS-DEFAULT-RESTART-REQ      PIC X(01) VALUE 'N'.           
          05 WS-IS-THIS-A-RESTART        PIC X(01) VALUE 'N'.           
             88 WS-THIS-IS-A-RESTART               VALUE 'Y'.           
             88 WS-THIS-IS-NOT-A-RESTART           VALUE 'N'.           
          05 WS-RESTART-REQ              PIC X(01).                     
          05 WS-CHKP-SEQ-NO              PIC 9(05) COMP VALUE 0.        
          05 WS-SEQ-NO                   PIC S9(04)V COMP-3 VALUE 0.    
          05 WS-RESTART-COMMIT-COUNTER   PIC S9(9) USAGE COMP VALUE +0. 
          05 WS-COMM-COUNTER             PIC S9(09) USAGE COMP VALUE 0. 
          05 WS-CONTCT-COUNTER           PIC S9(09) USAGE COMP VALUE 0. 
          05 WS-C8-COUNT                 PIC S9(09) USAGE COMP VALUE 0. 
          05 WS-BN-COUNT                 PIC S9(09) USAGE COMP VALUE 0. 
          05 WS-ROW-ERRORS               PIC S9(09) USAGE COMP VALUE 0. 
          05 WS-DB2-SQLCODE              PIC S9(09) USAGE COMP VALUE 0. 
          05 WS-DB2-ROW-NUM              PIC S9(09) USAGE COMP VALUE 0. 
          05 WS-DISP-INSERT-COUNT        PIC +Z(9).                     
          05 WS-DISP-ROW-COUNT           PIC +Z(9).                     
          05 WS-DISP-ROW-NUM             PIC +Z(9).                     
          05 WS-DISP-DB2-SQLCODE         PIC +Z(9).                     
          05 WS-DISP-FILE-COUNTER        PIC +Z(9).                     
          05 WS-ROW-NUM                  PIC S9(09) USAGE COMP VALUE 0. 
          05 WS-RECORD-CTR               PIC S9(09) USAGE COMP VALUE +0.
      *                                                                         
       01 WS-RESTART-DATA.                                              
          05 WS-RESTART-PROCESS-TYPE     PIC 9(01).                     
          05 WS-RESTART-JOB-COMPLETE     REDEFINES                      
             WS-RESTART-PROCESS-TYPE     PIC X(01).                     
          05 WS-RESTART-JOB-STATUS       PIC X(01).                     
             88 WS-RUN-COMPLETED-NO-PROBLEMS VALUE 'A'.                 
             88 WS-RERUN-COMPLETED           VALUE 'B'.                 
             88 WS-RERUN-PENDING             VALUE 'C'.                 
          05 WS-RESTART-COMMON-DATE      PIC X(10) VALUE SPACES.        
          05 WS-RESTART-CHKP-SEQ-NO      PIC S9(09) USAGE COMP VALUE +0.
          05 WS-RESTART-ACCOUNT-NO       PIC 9(13) VALUE 0.             
          05 WS-RESTART-FCSKR50R-CTR     PIC S9(09) USAGE COMP VALUE +0.
          05 WS-RESTART-SKIP-COUNTER     PIC S9(09) USAGE COMP VALUE +0.
                                                                        
       01 WS-CORRESP-TABLE.                                             
          05 WS-CORRESP-TABLE-DATA OCCURS 9999 TIMES                    
                                   INDEXED BY WS-COMM-INDX.             
             10  WS-CORR-MSG-ID          PIC X(5).                      
             10  WS-COMM-TYP-CD          PIC X(2).                      
             10  WS-COMM-SUBTYP-CD       PIC X(2).                      
             10  WS-COMM-INSERT-FL       PIC X(1).                      
                                                                        
       01 WS-CORRESP-CONTCT-TAB.                                        
          05 WS-CORRESP-CONTCT-DATA OCCURS 9999 TIMES                   
                                   INDEXED BY WS-CONTCT-INDX.           
             10  WS-CORRESP-MESSAGE-NO   PIC X(05).                     
             10  WS-CONTCT-COMPANY-NO    PIC X(02).                     
             10  WS-CONTCT-ADDR-STREET   PIC X(35).                     
             10  WS-CONTCT-ADDR-OVFL     PIC X(35).                     
             10  WS-CONTCT-CITY-STATE    PIC X(20).                     
             10  WS-CONTCT-ZIP-CODE      PIC X(5).                      
             10  WS-CONTCT-PHONE-NO      PIC X(10).                     
             10  WS-CONTCT-SPCL-PH-NO    PIC X(10).                     
                                                                        
       01 WS-CRED-CODE-TABLE.                                           
          05 WS-CRED-CODE-TABLE-DATA OCCURS 9999 TIMES                  
                                   INDEXED BY WS-CRED-CODE-INDX.        
P0599A       10  WS-CRED-CODE            PIC X(02).                     
             10  WS-CRED-CODE-DESC       PIC X(100).                    
             10  WS-CRED-COMPANY-NO      PIC X(02).                     
                                                                        
       01  WS-MIN-MAX-TABLE.                                            
           05  WS-MIN-MAX-DATA       OCCURS 50 TIMES                    
                                   ASCENDING KEY TAB-MIN-MAX-KEY        
                                   INDEXED BY WS-INDEX1.                
             10  TAB-MIN-MAX-KEY.                                       
                 15  TAB-MM-COMPANY      PIC X(2).                      
                 15  TAB-MM-REG-GRP-CD   PIC X(3).                      
                 15  TAB-MM-RQST-CD      PIC X(1).                      
                 15  TAB-MM-SCORE-TYPE   PIC X(1).                      
             10  TAB-MM-MIN-SCORE        PIC 9(5).                      
             10  TAB-MM-MAX-SCORE        PIC 9(5).                      
                                                                        
      ******************************************************************        
      * DATA LAYOUT FOR NOTICES AND LETTERS EXTRACT                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00019409
              INCLUDE FIOCOINF                                          00019509
           END-EXEC.                                                    00019609
                                                                        
      ******************************************************************        
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                        *        
      ******************************************************************        
                                                                        
       COPY CWS00010.                                                           
                                                                        
      ******************************************************************        
      * WORKING STORAGE LAYOUT FOR USE WITH NOTICES AND LETTERS EXTRACT*        
      ******************************************************************        
                                                                        
       COPY CWS00103.                                                           
                                                                        
      ******************************************************************        
      *  FIOCA00 COPYBOOK TO GET JOB_PARM DATA.                        *        
      ******************************************************************        
       COPY FIOCA00.                                                            
      *                                                                         
      ******************************************************************        
      *  CWS00039 JOB PARM ROUTINE                                     *        
      ******************************************************************        
                                                                        
       COPY CWS00039.                                                           
                                                                        
      ******************************************************************00019009
      * SCSCA165 PARAMETERS                                            *00019109
      ******************************************************************00019209
      *                                                                 00019309
           EXEC SQL                                                     00019409
              INCLUDE CWSCA165                                          00019509
           END-EXEC.                                                    00019609
      *                                                                 00019709
      ******************************************************************        
      * VARIABLES NEEDED FOR ACCOUNT SKIP PROCESSING.                  *        
      ******************************************************************        
                                                                        
       COPY CWSCA151.                                                           
                                                                        
      ******************************************************************        
      * WS FOR 6010-REDUCE-EMBEDDED SPACES                             *        
      ******************************************************************        
                                                                        
       COPY CWS0011A.                                                           
                                                                        
      ******************************************************************        
      * WORKING STORAGE FOR CPD09900 CONTAINS ABEND WS VARIABLES       *        
      ******************************************************************        
                                                                        
       COPY CWS09900.                                                           
                                                                        
      ******************************************************************        
      * ERROR MESSAGE COPYBOOK.                                        *        
      ******************************************************************        
                                                                        
       COPY CWS00303.                                                           
       COPY FIOJC01.                                                            
       COPY CWS00050.                                                           
       COPY CWS00056.                                                           
                                                                        
      ******************************************************************        
      *  CWS00038 JOB PARM ROUTINE                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
                                                                        
       01  WS-INSERT-ROW-COUNT REDEFINES WS-INPUT-DATA-BREAKDOWN.       
           10  WS-PARM-INSERT-ROW-COUNT-TXT PIC X(21).                  
               88 INSERT-ROW-CNT         VALUE 'NO-OF-ROWS-TO-INSERT='. 
           10  WS-NO-OF-ROWS-TO-INSERT   PIC X(05).                     
           10  FILLER                    PIC X(54).                     
                                                                        
       01  WS-SKIP-ROW-COUNT REDEFINES WS-INPUT-DATA-BREAKDOWN.         
           10  WS-PARM-SKIP-ROW-COUNT-TXT PIC X(14).                    
               88 SKIP-ROW-CNT         VALUE 'ACCTS-TO-SKIP='.          
           10  WS-NO-OF-ROWS-TO-SKIP     PIC X(05).                     
           10  FILLER                    PIC X(61).                     
      *                                                                         
      *                                                                         
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSKR150 ENDS HERE  '.            
      *                                                                         
      ******************************************************************        
      * DB2 INCLUDES.                                                  *        
      ******************************************************************        
      *    SQLCA                                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ACCOUNT         - AT                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
                                                                        
P00599******************************************************************00020609
P00599* DD - CSS_ACCT_MKT_TIER                                         *00020709
P00599******************************************************************00020809
P00599*                                                                 00020909
P00599     EXEC SQL                                                     00021009
P00599         INCLUDE TBMKTIER                                         00021109
P00599     END-EXEC.                                                    00021209
P00599*                                                                 00021309
P0599A******************************************************************00020609
P0599A* KO - CSS_COMM_DATA                                             *00020709
P0599A******************************************************************00020809
P0599A*                                                                 00020909
P0599A     EXEC SQL                                                     00021009
P0599A         INCLUDE TBCOMDAT                                         00021109
P0599A     END-EXEC.                                                    00021209
P0599A*                                                                 00021309
      ******************************************************************        
      * CSS_CORRESP_COMM    - 1L                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCORCOM                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CORRESP_NOTICE  - 1M                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCORNOT                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CRED_MSG_REF    - 1I                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCRMSG                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************06330000
      * CSS_CORRESP_HDR     - 1J                                        06340000
      ******************************************************************06350000
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCORHDR                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************06330000
      * CSS_CORRESP_VAR     - 1K                                        06340000
      ******************************************************************06350000
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCORVAR                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************06330000
      * CSS_CORRESP_CONTCT  - HO                                        06340000
      ******************************************************************06350000
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCOCONT                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_CORR_MAIL_STAT - MW                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMAILST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_CREDIT_HIST    - CK                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCRHIST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CRED_CODE_DESC  - KL                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCREDCD                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CUSTOMER        - CU                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_DEP_ON_HAND     - DO                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_DEP_REQUIREMNT  - D6                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDEPRQ                                                   
           END-EXEC.                                                            
                                                                        
P0599A******************************************************************00020609
P0599A* DR - CSS_DEP_REQ                                               *00020709
P0599A******************************************************************00020809
P0599A*                                                                 00020909
P0599A     EXEC SQL                                                     00021009
P0599A         INCLUDE TBDEPREQ                                         00021109
P0599A     END-EXEC.                                                    00021209
P0599A*                                                                 00021309
      ******************************************************************        
      * CSS_CUST_STATS      - CE                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CUST_PHONE      - CB                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_UTIL_ENVRNMT    - UT                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_RATE_COMP_DEF   - RC                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRTCDEF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CRED_HIST_ADDR  - LJ                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCRADDR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_CRED_ITPA_HIST - LF                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBCRITPA                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_DELINQUENCY    - C8                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBDELQ                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_JOB_PARM       - G6                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_MNT_TRANS_HIST - MH                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBMNHIST                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_MT_TRN_HST_DET - MI                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_RESTART        - RF                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRESTRT                                                  
           END-EXEC.                                                            
                                                                        
      * DB2 CURSORS.                                                            
      *------------*                                                            
      *                                                                         
      ******************************************************************        
      * DECLARE CURSOR TO GET CORRESP HDR DTLS BASED ON PARM MSG STATUS*        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE CORRESP_HDR CURSOR WITH HOLD FOR                  
               SELECT  [1J].CORRESP_ID                                    
                      ,[1J].ACCOUNT_NO                                    
                      ,[1J].CUSTOMER_NO                                   
                      ,[1J].CORRESP_MSG_ID                                
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           [1J].CORRESP_CREATE_TS, 121), ' ', '-'), ':', '.') 
           CORRESP_CREATE_TS                             
                      ,[1J].CORRESP_COMPANY_NO                            
                      ,[1J].CORRESP_STMT_DT                               
                      ,[1J].GUARNTR_ACCT_NO                               
                      ,[1J].CORRESP_STATUS_CD                             
                      ,[1J].CORRESP_TYPE_CD                               
                      ,[1J].REG_GROUP_CD                                  
                      ,[1J].SENIOR_FL                                     
                      ,[1J].BARCODE_UNIQUE_ID                             
                      ,[1J].CREATED_BY_PGM_ID                             
                 FROM CSS_CORRESP_HDR [1J] WITH(READUNCOMMITTED)                
                WHERE [1J].CORRESP_STATUS_CD = :WS-PROCESS-MSG-STATUS     
                  AND [1J].CORRESP_STMT_DT  <= IIF(TRY_CONVERT(DATE, 
                                                           :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )               
                ORDER BY [1J].CORRESP_STMT_DT                             
                        ,[1J].ACCOUNT_NO                                  
                        ,[1J].CUSTOMER_NO                                 
                        ,[1J].CORRESP_ID                                  
                  FOR READ ONLY                                 
P0599A                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CORRESP_HDR CURSOR WITH HOLD FOR                          
MFA-TR*        SELECT  1J.CORRESP_ID                                            
MFA-TR*               ,1J.ACCOUNT_NO                                            
MFA-TR*               ,1J.CUSTOMER_NO                                           
MFA-TR*               ,1J.CORRESP_MSG_ID                                        
MFA-TR*               ,1J.CORRESP_CREATE_TS                                     
MFA-TR*               ,1J.CORRESP_COMPANY_NO                                    
MFA-TR*               ,1J.CORRESP_STMT_DT                                       
MFA-TR*               ,1J.GUARNTR_ACCT_NO                                       
MFA-TR*               ,1J.CORRESP_STATUS_CD                                     
MFA-TR*               ,1J.CORRESP_TYPE_CD                                       
MFA-TR*               ,1J.REG_GROUP_CD                                          
MFA-TR*               ,1J.SENIOR_FL                                             
MFA-TR*               ,1J.BARCODE_UNIQUE_ID                                     
MFA-TR*               ,1J.CREATED_BY_PGM_ID                                     
MFA-TR*          FROM CSS_CORRESP_HDR 1J                                        
MFA-TR*         WHERE 1J.CORRESP_STATUS_CD = :WS-PROCESS-MSG-STATUS             
MFA-TR*           AND 1J.CORRESP_STMT_DT  <= :WS-RUN-DATE                       
MFA-TR*         ORDER BY 1J.CORRESP_STMT_DT                                     
MFA-TR*                 ,1J.ACCOUNT_NO                                          
MFA-TR*                 ,1J.CUSTOMER_NO                                         
MFA-TR*                 ,1J.CORRESP_ID                                          
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7510                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * DECLARE CURSOR TO GET CORRESP HDR DTLS BASED ON STATUS CODE    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE CORRESP_STATUS CURSOR WITH HOLD FOR               
               SELECT  [1J].CORRESP_ID                                    
                      ,[1J].ACCOUNT_NO                                    
                      ,[1J].CUSTOMER_NO                                   
                      ,[1J].CORRESP_MSG_ID                                
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           [1J].CORRESP_CREATE_TS, 121), ' ', '-'), ':', '.') 
           CORRESP_CREATE_TS                             
                      ,[1J].CORRESP_COMPANY_NO                            
                      ,[1J].CORRESP_STMT_DT                               
                      ,[1J].GUARNTR_ACCT_NO                               
                      ,[1J].CORRESP_STATUS_CD                             
                      ,[1J].CORRESP_TYPE_CD                               
                      ,[1J].REG_GROUP_CD                                  
                      ,[1J].SENIOR_FL                                     
                      ,[1J].BARCODE_UNIQUE_ID                             
ACT115                ,[1J].CREATED_BY_PGM_ID                             
                 FROM CSS_CORRESP_HDR [1J] WITH(READUNCOMMITTED)                
                WHERE [1J].CORRESP_STATUS_CD IN ('I','O','B')             
                  AND [1J].CORRESP_STMT_DT   <= IIF(TRY_CONVERT(DATE, 
                                                           :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )              
                ORDER BY [1J].CORRESP_STMT_DT                             
                        ,[1J].ACCOUNT_NO                                  
                        ,[1J].CUSTOMER_NO                                 
                        ,[1J].CORRESP_ID                                  
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CORRESP_STATUS CURSOR WITH HOLD FOR                       
MFA-TR*        SELECT  1J.CORRESP_ID                                            
MFA-TR*               ,1J.ACCOUNT_NO                                            
MFA-TR*               ,1J.CUSTOMER_NO                                           
MFA-TR*               ,1J.CORRESP_MSG_ID                                        
MFA-TR*               ,1J.CORRESP_CREATE_TS                                     
MFA-TR*               ,1J.CORRESP_COMPANY_NO                                    
MFA-TR*               ,1J.CORRESP_STMT_DT                                       
MFA-TR*               ,1J.GUARNTR_ACCT_NO                                       
MFA-TR*               ,1J.CORRESP_STATUS_CD                                     
MFA-TR*               ,1J.CORRESP_TYPE_CD                                       
MFA-TR*               ,1J.REG_GROUP_CD                                          
MFA-TR*               ,1J.SENIOR_FL                                             
MFA-TR*               ,1J.BARCODE_UNIQUE_ID                                     
MFA-TR*               ,1J.CREATED_BY_PGM_ID                                     
MFA-TR*          FROM CSS_CORRESP_HDR 1J                                        
MFA-TR*         WHERE 1J.CORRESP_STATUS_CD IN ('I','O','B')                     
MFA-TR*           AND 1J.CORRESP_STMT_DT   <= :WS-RUN-DATE                      
MFA-TR*         ORDER BY 1J.CORRESP_STMT_DT                                     
MFA-TR*                 ,1J.ACCOUNT_NO                                          
MFA-TR*                 ,1J.CUSTOMER_NO                                         
MFA-TR*                 ,1J.CORRESP_ID                                          
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7730                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * DECLARE CURSOR TO GET CORRESP HDR DTLS BASED ON PARM MESSAGE ID*        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE CORRESP_HDR_MSGID CURSOR WITH HOLD FOR            
               SELECT  [1J].CORRESP_ID                                    
                      ,[1J].ACCOUNT_NO                                    
                      ,[1J].CUSTOMER_NO                                   
                      ,[1J].CORRESP_MSG_ID                                
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           [1J].CORRESP_CREATE_TS, 121), ' ', '-'), ':', '.') 
           CORRESP_CREATE_TS                             
                      ,[1J].CORRESP_COMPANY_NO                            
                      ,[1J].CORRESP_STMT_DT                               
                      ,[1J].GUARNTR_ACCT_NO                               
                      ,[1J].CORRESP_STATUS_CD                             
                      ,[1J].CORRESP_TYPE_CD                               
                      ,[1J].REG_GROUP_CD                                  
                      ,[1J].SENIOR_FL                                     
                      ,[1J].BARCODE_UNIQUE_ID                             
ACT115                ,[1J].CREATED_BY_PGM_ID                             
                 FROM CSS_CORRESP_HDR [1J] WITH(READUNCOMMITTED)                
                WHERE [1J].CORRESP_MSG_ID   = :WS-MSG-ID                  
                  AND [1J].CORRESP_STMT_DT <= IIF(TRY_CONVERT(DATE, 
                                                           :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )                
                  AND [1J].CORRESP_STATUS_CD IN ('I','O','B')             
                ORDER BY [1J].CORRESP_STMT_DT                             
                        ,[1J].ACCOUNT_NO                                  
                        ,[1J].CUSTOMER_NO                                 
                        ,[1J].CORRESP_ID                                  
                  FOR READ ONLY                                 
P0599A                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CORRESP_HDR_MSGID CURSOR WITH HOLD FOR                    
MFA-TR*        SELECT  1J.CORRESP_ID                                            
MFA-TR*               ,1J.ACCOUNT_NO                                            
MFA-TR*               ,1J.CUSTOMER_NO                                           
MFA-TR*               ,1J.CORRESP_MSG_ID                                        
MFA-TR*               ,1J.CORRESP_CREATE_TS                                     
MFA-TR*               ,1J.CORRESP_COMPANY_NO                                    
MFA-TR*               ,1J.CORRESP_STMT_DT                                       
MFA-TR*               ,1J.GUARNTR_ACCT_NO                                       
MFA-TR*               ,1J.CORRESP_STATUS_CD                                     
MFA-TR*               ,1J.CORRESP_TYPE_CD                                       
MFA-TR*               ,1J.REG_GROUP_CD                                          
MFA-TR*               ,1J.SENIOR_FL                                             
MFA-TR*               ,1J.BARCODE_UNIQUE_ID                                     
MFA-TR*               ,1J.CREATED_BY_PGM_ID                                     
MFA-TR*          FROM CSS_CORRESP_HDR 1J                                        
MFA-TR*         WHERE 1J.CORRESP_MSG_ID   = :WS-MSG-ID                          
MFA-TR*           AND 1J.CORRESP_STMT_DT <= :WS-RUN-DATE                        
MFA-TR*           AND 1J.CORRESP_STATUS_CD IN ('I','O','B')                     
MFA-TR*         ORDER BY 1J.CORRESP_STMT_DT                                     
MFA-TR*                 ,1J.ACCOUNT_NO                                          
MFA-TR*                 ,1J.CUSTOMER_NO                                         
MFA-TR*                 ,1J.CORRESP_ID                                          
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7540                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * DECLARE CURSOR TO GET CORRESP VAR DTLS FOR EXTRACT PROCESS     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE CORRESP_VAR CURSOR WITH HOLD FOR                  
               SELECT A.CORRESP_VAR_NM                                  
                     ,A.CORRESP_VAR_DATA                                
                     ,A.CORRESP_VAR_NUM                                 
                     ,A.CORRESP_VAR_CHAR                                
                 FROM CSS_CORRESP_VAR    A WITH(READUNCOMMITTED)                
                WHERE A.CORRESP_ID  = :WS-CORRESP-ID                    
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CORRESP_VAR CURSOR WITH HOLD FOR                          
MFA-TR*        SELECT A.CORRESP_VAR_NM                                          
MFA-TR*              ,A.CORRESP_VAR_DATA                                        
MFA-TR*              ,A.CORRESP_VAR_NUM                                         
MFA-TR*              ,A.CORRESP_VAR_CHAR                                        
MFA-TR*          FROM CSS_CORRESP_VAR    A                                      
MFA-TR*         WHERE A.CORRESP_ID  = :WS-CORRESP-ID                            
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7570                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * DECLARE CURSOR TO GET CORRESP COMM DETAILS                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE CORRESP_COMM CURSOR WITH HOLD FOR                 
               SELECT [1L].COMM_TYPE_CODE                                 
                     ,[1L].COMM_SUBTYPE_CODE                              
                     ,[1L].CORRESP_MSG_ID                                 
                     ,[1L].COMM_INSERT_FL                                 
                 FROM CSS_CORRESP_COMM [1L] WITH(READUNCOMMITTED)               
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CORRESP_COMM CURSOR WITH HOLD FOR                         
MFA-TR*        SELECT 1L.COMM_TYPE_CODE                                         
MFA-TR*              ,1L.COMM_SUBTYPE_CODE                                      
MFA-TR*              ,1L.CORRESP_MSG_ID                                         
MFA-TR*              ,1L.COMM_INSERT_FL                                         
MFA-TR*          FROM CSS_CORRESP_COMM 1L                                       
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7640                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * DECLARE CURSOR TO GET CORRESP CONTCT DETAILS                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE CORRESP_CONTCT CURSOR WITH HOLD FOR               
               SELECT HO.CORRESP_MESSAGE_NO                             
                     ,HO.COMPANY_NO                                     
                     ,HO.CONTCT_ADDR_STREET                             
                     ,HO.CONTCT_ADDR_OVFL                               
                     ,HO.CONTCT_CITY_STATE                              
                     ,HO.CONTCT_ZIP_CODE                                
                     ,HO.CONTCT_PHONE_NO                                
                     ,HO.SPCL_PHONE_NO                                  
                 FROM CSS_CORRESP_CONTCT HO WITH(READUNCOMMITTED)               
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CORRESP_CONTCT CURSOR WITH HOLD FOR                       
MFA-TR*        SELECT HO.CORRESP_MESSAGE_NO                                     
MFA-TR*              ,HO.COMPANY_NO                                             
MFA-TR*              ,HO.CONTCT_ADDR_STREET                                     
MFA-TR*              ,HO.CONTCT_ADDR_OVFL                                       
MFA-TR*              ,HO.CONTCT_CITY_STATE                                      
MFA-TR*              ,HO.CONTCT_ZIP_CODE                                        
MFA-TR*              ,HO.CONTCT_PHONE_NO                                        
MFA-TR*              ,HO.SPCL_PHONE_NO                                          
MFA-TR*          FROM CSS_CORRESP_CONTCT HO                                     
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7670                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * DECLARE CURSOR TO GET CRED CODE DESC DETAILS                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE CRED_CODE_DESC CURSOR WITH HOLD FOR               
P0599A         SELECT KL.CRED_CD                                        
P0599A               ,KL.CRED_CD_DESC                                   
                     ,KL.COMPANY_NO                                     
                 FROM CSS_CRED_CODE_DESC KL WITH(READUNCOMMITTED)               
                WHERE KL.COLUMN_NA = 'CORRESP_TYPE_CD'                  
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CRED_CODE_DESC CURSOR WITH HOLD FOR                       
MFA-TR*        SELECT KL.CRED_CD                                                
MFA-TR*              ,KL.CRED_CD_DESC                                           
MFA-TR*              ,KL.COMPANY_NO                                             
MFA-TR*          FROM CSS_CRED_CODE_DESC KL                                     
MFA-TR*         WHERE KL.COLUMN_NA = 'CORRESP_TYPE_CD'                          
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            
      ***************************************************************   03890000
      *  DECLARATION OF CURSOR TO RETRIEVE HOME AND WORK TELEPHONE  *   03900000
      *  NUMBERS FOR A CUSTOMER.                                    *   03910000
      ***************************************************************   03920000
      *                                                                 03921000
           EXEC SQL                                                     
              DECLARE PHONE_CURSOR CURSOR FOR                           
              SELECT CB.PHONE_NO                                        
                    ,CB.PHONE_TYPE                                      
                    ,CB.EXTENSION_NO                                    
              FROM CSS_CUST_PHONE CB WITH(READUNCOMMITTED)                      
              WHERE CB.CUSTOMER_NO   = :CB-CUSTOMER-NO                  
                 AND CB.CUSTOMER_TYPE = 'C'                             
                 AND CB.PHONE_TYPE    IN ('H1','W1')                    
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE PHONE_CURSOR CURSOR FOR                           03940000
MFA-TR*       SELECT CB.PHONE_NO                                                
MFA-TR*             ,CB.PHONE_TYPE                                              
MFA-TR*             ,CB.EXTENSION_NO                                            
MFA-TR*       FROM CSS_CUST_PHONE CB                                            
MFA-TR*       WHERE CB.CUSTOMER_NO   = :CB-CUSTOMER-NO                          
MFA-TR*          AND CB.CUSTOMER_TYPE = 'C'                                     
MFA-TR*          AND CB.PHONE_TYPE    IN ('H1','W1')                            
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*       QUERYNO 7440                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ***************************************************************   03890000
      *  DECLARATION OF CURSOR TO LOAD MIN AND MAX SCORES.          *   03900000
      ***************************************************************   03920000
      *                                                                 03921000
           EXEC SQL                                                     
              DECLARE MIN_MAX_CSR  CURSOR FOR                           
              SELECT DISTINCT CR_RQST_REASON_CD                         
                    ,COMPANY_NO                                         
                    ,REG_GROUP_CD                                       
A05198              ,SCORE_MODEL_CD                                     
              FROM  CSS_DEP_REQUIREMNT D6 WITH(READUNCOMMITTED)                 
              ORDER BY COMPANY_NO ASC,                                  
                       REG_GROUP_CD ASC,                                
                       CR_RQST_REASON_CD ASC,                           
A05198                 SCORE_MODEL_CD ASC                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MIN_MAX_CSR  CURSOR FOR                           03940000
MFA-TR*       SELECT DISTINCT CR_RQST_REASON_CD                                 
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,REG_GROUP_CD                                               
MFA-TR*             ,SCORE_MODEL_CD                                             
MFA-TR*       FROM  CSS_DEP_REQUIREMNT D6                                       
MFA-TR*       ORDER BY COMPANY_NO ASC,                                          
MFA-TR*                REG_GROUP_CD ASC,                                        
MFA-TR*                CR_RQST_REASON_CD ASC,                                   
MFA-TR*                SCORE_MODEL_CD ASC                                       
MFA-TR*                WITH UR                                                  
MFA-TR*                QUERYNO 7140                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
       01  WS-END                          PIC X(40)      VALUE         
                       'WORKING STORAGE FOR PCSKR150 ENDS HERE  '.      
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  PARMIN.                                                      
           05  PARMLENGTH                  PIC S9(04) COMP.             
           05  PARM-RUN-DATE               PIC X(10).                   
           05  PARM-UPDATE-DB-FL           PIC X(02).                   
           05  PARM-MSG-NO                 PIC X(05).                   
           05  PARM-MSG-STATUS             PIC X(01).                   
                                                                        
       PROCEDURE DIVISION USING PARMIN.                                 
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM  0100-INITIALIZATION         THRU  0100-EXIT.        
           PERFORM  1000-PROCESS-INPUT          THRU  1000-EXIT.        
           PERFORM  9000-TERMINATE              THRU  9000-EXIT.        
                                                                        
           IF WS-SKIP-COUNTER  > 0                                      
              MOVE 03                           TO RETURN-CODE          
           END-IF.                                                      
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZATION                                            *        
      * OPEN OUTPUT FILE                                               *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
                                                                        
           INITIALIZE WS-PROCESS-COUNTER                                
                      WS-RESTART-ACCT-NO                                
                      WS-CA165-CALLING-FIELDS                           
                      WS-INTERNAL-VARIABLES                             
                      DCLCSS-CORRESP-HDR                                
                      DCLCSS-CORRESP-NOTICE                             
                      DCLCSS-CORRESP-COMM                               
                      DCLCSS-CORRESP-CONTCT.                            
                                                                        
           MOVE 'N'                             TO WS-VALID-DATE-FLAG.  
           MOVE PARM-RUN-DATE                   TO WS-TEST-DATE.        
           PERFORM 7020-VALIDATE-DATE           THRU 7020-EXIT.         
           IF INVALID-DATE                                              
              MOVE SPACES                       TO PARM-RUN-DATE        
           END-IF.                                                      
                                                                        
           IF PARM-RUN-DATE = SPACES                                    
              PERFORM 0110-GET-JOB-PARM-DETAILS THRU 0110-EXIT          
           ELSE                                                         
              MOVE PARM-RUN-DATE                TO WS-INPUT-DATE        
              DISPLAY '** PCSKR150 PROCESSING MESSAGE  **'              
              DISPLAY '** JCL OVERRIDE DATE BEING USED **'              
              DISPLAY '** DATE = ' WS-INPUT-DATE                        
              DISPLAY '**  PROCESSING CONTINUING       **'              
           END-IF.                                                      
           MOVE WS-INPUT-DATE                   TO WS-RUN-DATE.         
                                                                        
           IF PARM-MSG-STATUS > SPACES                                  
              MOVE PARM-MSG-STATUS TO WS-PROCESS-MSG-STATUS             
           END-IF.                                                      
                                                                        
           MOVE PARM-MSG-NO        TO WS-MSG-ID                         
           IF PARM-UPDATE-DB-FL > SPACES                                
              MOVE 'N'             TO WS-UPDATE-DB-FL                   
           ELSE                                                         
              SET UPDATE-DB-FL     TO TRUE                              
           END-IF.                                                      
                                                                        
           MOVE PROGRAM-NAME       TO 1J-LAST-UPDATE-PGM-ID.            
      * GET DB2 INSERT ROW COUNT                                                
                                                                        
           PERFORM 0115-GET-INSERT-ROW-COUNT    THRU 0115-EXIT.         
                                                                        
      * GET DB2 SKIP ROW COUNT                                                  
                                                                        
           PERFORM 0125-GET-SKIP-ROW-COUNT      THRU 0125-EXIT.         
                                                                        
           PERFORM 0120-OPEN-FILES              THRU 0120-EXIT.         
                                                                        
      * TO IDENTIFY THE DATA BASE                                               
           MOVE ZERO                            TO WS-DATABASE.         
           MOVE '01'                            TO C8-COMPANY-NO.       
           MOVE 'DATABASE'                      TO C8-DELINQ-CD.        
           PERFORM 7000-SELECT-DELINQ-VALUE     THRU 7000-EXIT.         
           MOVE C8-DELINQ-VALUE                 TO WS-DATABASE.         
                                                                        
      *                                                                         
           PERFORM 0300-PROCESS-FOR-RESTART     THRU 0300-EXIT.         
           PERFORM 0130-LOAD-MIN-MAX-TABLE      THRU 0130-EXIT.         
           PERFORM 0200-LOAD-CORRESP-COMM       THRU 0200-EXIT.         
           PERFORM 0250-LOAD-CORRESP-CONTCT     THRU 0250-EXIT.         
           PERFORM 0270-LOAD-CRED-CODE-DESC     THRU 0270-EXIT.         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0110-GET-JOB-PARM-DETAILS.                                     *        
      *    1. SELECT RUN-DATE                                          *        
      *    2. SELECT REVENUE-MONTH                                     *        
      ******************************************************************        
       0110-GET-JOB-PARM-DETAILS.                                       
                                                                        
           PERFORM 6251-GET-FJC01-DATE          THRU 6251-EXIT.         
                                                                        
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                                THRU 6240-EXIT          
               MOVE WS-FCA00-COMMON-DATE        TO WS-INPUT-DATE        
               DISPLAY '** PCSKR150 PROCESSING MESSAGE **'              
               DISPLAY '** COMMON DATE BEING USED      **'              
               DISPLAY '** DATE = ' WS-INPUT-DATE                       
               DISPLAY '**  PROCESSING CONTINUING      **'              
           END-IF.                                                      
                                                                        
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0115-GET-INSERT-ROW-COUNT.                                     *        
      * GET THE INSERT ROW COUNT FROM JOB PARM TABLE                   *        
      ******************************************************************        
       0115-GET-INSERT-ROW-COUNT.                                       
                                                                        
           MOVE  WS-PGRMNAME               TO WS-PROGRAM.               
           MOVE  WS-PARM                   TO WS-COMMAND.               
           MOVE  ZEROS                     TO WS-SEQUENCE.              
           MOVE  SPACES                    TO WS-SYSIPT.                
           MOVE  WS-KEY-AREA               TO E-FJC01-KEY.              
                                                                        
           PERFORM 7600-START-FCSJC01      THRU  7600-EXIT.             
           PERFORM 7610-READ-FCSJC01       THRU  7610-EXIT              
              UNTIL (INSERT-ROW-CNT AND INPUT-ACTIVE)                   
              OR  END-OF-SYSIPT.                                        
                                                                        
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '** ' WS-PGRMNAME ' PROCESSING WARNING  **'       
              DISPLAY '**  INSERT-ROW-CNT PARM NOT ACTIVE     **'       
              DISPLAY '**  DEFAULT OF ' WS-DEFAULT-INSERT-COUNT         
                          ' WILL BE USED  **'                           
              DISPLAY '**  PROCESSING CONTINUING        **'             
              MOVE WS-DEFAULT-INSERT-COUNT                              
                                         TO WS-READY-TO-INSERT-COUNT    
           ELSE                                                         
              IF WS-NO-OF-ROWS-TO-INSERT  NUMERIC                       
                 MOVE WS-NO-OF-ROWS-TO-INSERT                           
                                         TO WS-READY-TO-INSERT-COUNT    
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY '**  ' WS-PGRMNAME ' PROCESSING WARNING  **'   
                 DISPLAY '**  INSERT-ROW-CNT PARM NOT NUMERIC  **'      
                 DISPLAY '**  DEFAULT OF ' WS-DEFAULT-INSERT-COUNT      
                         ' WILL BE USED  **'                            
                 DISPLAY '**  PROCESSING CONTINUING        **'          
                 MOVE WS-DEFAULT-INSERT-COUNT                           
                                         TO WS-READY-TO-INSERT-COUNT    
              END-IF                                                    
              PERFORM 7611-CLOSE                 THRU 7611-EXIT         
           END-IF.                                                      
      *                                                                         
       0115-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0120-OPEN-FILES.                                               *        
      * OPEN INPUT FILE TO BEGIN PROCESSING.                           *        
      ******************************************************************        
       0120-OPEN-FILES.                                                 
                                                                        
           OPEN OUTPUT FCSKR150-FILE.                                   
           IF NOT FCSKR150-SUCCESSFUL                                   
              DISPLAY '********** PCSKR150 ABORT  ************'         
              DISPLAY '**  0120-OPEN-FILES                   *'         
              DISPLAY '**  ERROR OPENING FCSKR150            *'         
              DISPLAY '**  FILE STATUS = ' WS-FCSKR150-STATUS           
              DISPLAY '********** PCSKR150 ABORT  ************'         
              PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
                                                                        
                                                                        
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0125-GET-SKIP-ROW-COUNT.                                     *          
      * GET THE SKIP ROW COUNT FROM JOB PARM TABLE                   *          
      ******************************************************************        
       0125-GET-SKIP-ROW-COUNT.                                         
                                                                        
           MOVE  WS-PGRMNAME               TO WS-PROGRAM.               
           MOVE  WS-PARM                   TO WS-COMMAND.               
           MOVE  ZEROS                     TO WS-SEQUENCE.              
           MOVE  SPACES                    TO WS-SYSIPT.                
           MOVE  WS-KEY-AREA               TO E-FJC01-KEY.              
                                                                        
           PERFORM 7600-START-FCSJC01      THRU  7600-EXIT.             
           PERFORM 7610-READ-FCSJC01       THRU  7610-EXIT              
              UNTIL (SKIP-ROW-CNT AND INPUT-ACTIVE)                     
              OR  END-OF-SYSIPT.                                        
                                                                        
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '** ' WS-PGRMNAME ' PROCESSING WARNING  **'       
              DISPLAY '**  SKIP-ROW-CNT PARM NOT ACTIVE     **'         
              DISPLAY '**  DEFAULT OF ' WS-DEFAULT-ACCTS-TO-SKIP        
                          ' WILL BE USED  **'                           
              DISPLAY '**  PROCESSING CONTINUING        **'             
              MOVE WS-DEFAULT-ACCTS-TO-SKIP                             
                                         TO WS-ACCTS-TO-SKIP            
           ELSE                                                         
              IF WS-NO-OF-ROWS-TO-SKIP    NUMERIC                       
                 MOVE WS-NO-OF-ROWS-TO-SKIP                             
                                         TO WS-ACCTS-TO-SKIP            
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY '**  ' WS-PGRMNAME ' PROCESSING WARNING  **'   
                 DISPLAY '**  SKIP-ROW-CNT PARM NOT NUMERIC  **'        
                 DISPLAY '**  DEFAULT OF ' WS-DEFAULT-ACCTS-TO-SKIP     
                         ' WILL BE USED  **'                            
                 DISPLAY '**  PROCESSING CONTINUING        **'          
                 MOVE WS-DEFAULT-ACCTS-TO-SKIP                          
                                         TO WS-ACCTS-TO-SKIP            
              END-IF                                                    
              PERFORM 7611-CLOSE                 THRU 7611-EXIT         
           END-IF.                                                      
      *                                                                         
       0125-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0110-LOAD-MIN-MAX-TABLE                                        *        
      ******************************************************************        
       0130-LOAD-MIN-MAX-TABLE.                                         
                                                                        
           PERFORM 7130-OPEN-MIN-MAX-CURSOR   THRU 7130-EXIT.           
           PERFORM 7140-FETCH-MIN-MAX-CURSOR  THRU 7140-EXIT.           
           SET WS-INDEX1 TO 1.                                          
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 7035-LOAD-MIN-MAX-BEACON THRU 7035-EXIT           
              PERFORM 7140-FETCH-MIN-MAX-CURSOR  THRU 7140-EXIT         
           END-PERFORM.                                                 
           PERFORM 7150-CLOSE-MIN-MAX-CURSOR  THRU 7150-EXIT.           
                                                                        
       0130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 0200-LOAD-CORRESP-COMM                                        *         
      *****************************************************************         
                                                                        
       0200-LOAD-CORRESP-COMM.                                          
                                                                        
           SET WS-COMM-INDX TO 1.                                       
           PERFORM 7630-OPEN-CORRESP-COMM        THRU 7630-EXIT.        
           PERFORM 7640-FETCH-CORRESP-COMM       THRU 7640-EXIT.        
           PERFORM 0210-LOAD-CORRESP-COMM-TBL    THRU 0210-EXIT         
             UNTIL SQLCODE = NOT-FOUND.                                 
           PERFORM 7650-CLOSE-CORRESP-COMM       THRU 7650-EXIT.        
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0210-LOAD-CORRESP-COMM-TBL                                     *        
      * LOAD THE BILL WINDOW DATA INTO A WS ARRAY                      *        
      ******************************************************************        
       0210-LOAD-CORRESP-COMM-TBL.                                      
                                                                        
           ADD 1                     TO WS-COMM-COUNTER.                
           MOVE 1L-CORRESP-MSG-ID    TO WS-CORR-MSG-ID(WS-COMM-INDX).   
           MOVE 1L-COMM-TYPE-CODE    TO WS-COMM-TYP-CD(WS-COMM-INDX).   
           MOVE 1L-COMM-SUBTYPE-CODE TO WS-COMM-SUBTYP-CD(WS-COMM-INDX).
           MOVE 1L-COMM-INSERT-FL    TO WS-COMM-INSERT-FL(WS-COMM-INDX).
           SET WS-COMM-INDX UP BY 1.                                    
           PERFORM 7640-FETCH-CORRESP-COMM       THRU 7640-EXIT.        
                                                                        
       0210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 0250-LOAD-CORRESP-CONTCT                                     *          
      *****************************************************************         
       0250-LOAD-CORRESP-CONTCT.                                        
                                                                        
           SET WS-CONTCT-INDX TO 1.                                     
           PERFORM 7660-OPEN-CORRESP-CONTCT      THRU 7660-EXIT.        
           PERFORM 7670-FETCH-CORRESP-CONTCT     THRU 7670-EXIT.        
           PERFORM 0260-LOAD-CORRESP-CONTCT-TBL  THRU 0260-EXIT         
             UNTIL SQLCODE = NOT-FOUND.                                 
           PERFORM 7680-CLOSE-CORRESP-CONTCT     THRU 7680-EXIT.        
                                                                        
       0250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0260-LOAD-CORRESP-CONTCT-TBL                                            
      ******************************************************************        
       0260-LOAD-CORRESP-CONTCT-TBL.                                    
                                                                        
           ADD 1                      TO WS-CONTCT-COUNTER.             
           MOVE HO-CORRESP-MESSAGE-NO TO                                
                WS-CORRESP-MESSAGE-NO(WS-CONTCT-INDX).                  
           MOVE HO-COMPANY-NO         TO                                
                WS-CONTCT-COMPANY-NO(WS-CONTCT-INDX).                   
           MOVE HO-CONTCT-ADDR-STREET TO                                
                WS-CONTCT-ADDR-STREET(WS-CONTCT-INDX).                  
           MOVE HO-CONTCT-ADDR-OVFL   TO                                
                WS-CONTCT-ADDR-OVFL(WS-CONTCT-INDX).                    
           MOVE HO-CONTCT-CITY-STATE  TO                                
                WS-CONTCT-CITY-STATE(WS-CONTCT-INDX).                   
           MOVE HO-CONTCT-ZIP-CODE    TO                                
                WS-CONTCT-ZIP-CODE(WS-CONTCT-INDX)                      
           MOVE HO-CONTCT-PHONE-NO    TO                                
                WS-CONTCT-PHONE-NO(WS-CONTCT-INDX)                      
           MOVE HO-SPCL-PHONE-NO      TO                                
                WS-CONTCT-SPCL-PH-NO(WS-CONTCT-INDX)                    
           SET WS-CONTCT-INDX UP BY 1.                                  
           PERFORM 7670-FETCH-CORRESP-CONTCT     THRU 7670-EXIT.        
                                                                        
       0260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0270-LOAD-CRED-CODE-DESC                                     *          
      *****************************************************************         
       0270-LOAD-CRED-CODE-DESC.                                        
                                                                        
           PERFORM 7690-OPEN-CRED-CODE-DESC      THRU 7690-EXIT.        
           PERFORM 7700-FETCH-CRED-CODE-DESC     THRU 7700-EXIT.        
           PERFORM 0280-LOAD-CRED-CODE-DESC-TBL  THRU 0280-EXIT         
             UNTIL SQLCODE = NOT-FOUND.                                 
           PERFORM 7710-CLOSE-CRED-CODE-DESC     THRU 7710-EXIT.        
                                                                        
       0270-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0280-LOAD-CRED-CODE-DESC-TBL                                            
      ******************************************************************        
       0280-LOAD-CRED-CODE-DESC-TBL.                                    
                                                                        
P0599A     MOVE KL-CRED-CD            TO                                
P0599A          WS-CRED-CODE(WS-CRED-CODE-INDX).                        
           MOVE KL-CRED-CD-DESC       TO                                
                WS-CRED-CODE-DESC(WS-CRED-CODE-INDX).                   
           MOVE KL-COMPANY-NO         TO                                
                WS-CRED-COMPANY-NO(WS-CRED-CODE-INDX).                  
           SET WS-CRED-CODE-INDX UP BY 1.                               
           PERFORM 7700-FETCH-CRED-CODE-DESC     THRU 7700-EXIT.        
                                                                        
       0280-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0300-PROCESS-FOR-RESTART.                                      *        
      * PROCESS FOR THE RESTART                                        *        
      ******************************************************************        
      *                                                                         
       0300-PROCESS-FOR-RESTART.                                        
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 6253-GET-FJC01-CHKP-LIMIT    THRU 6253-EXIT.         
                                                                        
           INITIALIZE WS-SYSIPT                                         
           PERFORM 6235-GET-FJC01-RESTART-REQ   THRU 6235-EXIT.         
                                                                        
           PERFORM 0350-CHECK-AND-VALDT-RESTART THRU 0350-EXIT.         
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              PERFORM 0375-PREPARE-RESTART      THRU 0375-EXIT          
           END-IF.                                                      
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0350-CHECK-AND-VALDT-RESTART.                                  *        
      * VALIDATING RESTART                                             *        
      ******************************************************************        
      *                                                                         
       0350-CHECK-AND-VALDT-RESTART.                                    
      *                                                                         
           MOVE PROGRAM-NAME                    TO RF-NAME-PROGRAM.     
           MOVE 1                               TO RF-PARTITION-NO.     
           MOVE 1                               TO RF-DUP-CNTRL-NO.     
                                                                        
           PERFORM 7050-SELECT-RESTART          THRU 7050-EXIT.         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE RF-RESTART-DATA-TEXT         TO WS-RESTART-DATA      
              IF WS-RESTART-PROCESS-TYPE NUMERIC                        
                 MOVE WS-Y                      TO WS-IS-THIS-A-RESTART 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 0605-VALIDATE-RESTART-REQ    THRU 0605-EXIT.         
      *                                                                         
       0350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0375-PREPARE-RESTART.                                          *        
      * PREPARE FOR RESTART                                            *        
      ******************************************************************        
      *                                                                         
       0375-PREPARE-RESTART.                                            
      *                                                                         
           IF WS-THIS-IS-A-RESTART                                      
              DISPLAY '*******************************************'     
              DISPLAY '*****   THIS IS A RESTART OF PCSKR150   ***'     
              DISPLAY '*******************************************'     
              OPEN INPUT FCSKR50R-FILE                                  
              IF FCSKR50R-SUCCESSFUL                                    
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '0375-ERROR ON FCSKR50R OPEN.  STATUS IS '     
                                               WS-FCSKR50R-STATUS       
                 PERFORM 9900-ABEND             THRU 9900-EXIT          
              END-IF                                                    
              PERFORM WS-RESTART-FCSKR50R-CTR TIMES                     
                 READ FCSKR50R-FILE                                     
                   IF FCSKR50R-SUCCESSFUL                               
                      WRITE EXTKR150 FROM  FIOKR50R                     
                      ADD 1                     TO  WS-FCSKR50R-CNTR    
                      IF FCSKR150-SUCCESSFUL                            
                         CONTINUE                                       
                      ELSE                                              
                         DISPLAY 'ERROR ON FCSKR150 REWRITE. STATUS IS '
                                                    WS-FCSKR150-STATUS  
                         PERFORM 9900-ABEND     THRU 9900-EXIT          
                      END-IF                                            
                   ELSE                                                 
                      DISPLAY 'PREMATURE EOF ON FCSKR50R RESTART'       
                      DISPLAY 'PROCESSING TERMINATED'                   
                      PERFORM 9900-ABEND        THRU 9900-EXIT          
                   END-IF                                               
              END-PERFORM                                               
              CLOSE FCSKR50R-FILE                                       
              MOVE 1J-ACCOUNT-NO         TO WS-RESTART-ACCT-NO          
           END-IF.                                                      
      *                                                                         
       0375-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0400-PREPARE-PRECOMMIT.                                        *        
      * MOVE ALL THE REQUIRED RESTART RECORD VALUES PRIOR TO UPDATE    *        
      ******************************************************************        
      *                                                                         
       0400-PREPARE-PRECOMMIT.                                          
      *                                                                         
            MOVE 1                       TO WS-RESTART-PROCESS-TYPE.    
            MOVE WS-C                    TO WS-RESTART-JOB-STATUS.      
            MOVE WS-INPUT-DATE           TO WS-RESTART-COMMON-DATE.     
            MOVE WS-CHKP-SEQ-NO          TO WS-RESTART-CHKP-SEQ-NO.     
            MOVE 1J-ACCOUNT-NO           TO WS-RESTART-ACCOUNT-NO.      
            MOVE WS-FCSKR150-CNTR        TO WS-RESTART-FCSKR50R-CTR.    
            MOVE WS-SKIP-COUNTER         TO WS-RESTART-SKIP-COUNTER.    
      *                                                                         
       0400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *VALIDATES RESTART REQUEST.                                      *        
      ******************************************************************        
       COPY CPD00030.                                                           
                                                                        
      ******************************************************************        
      ** 6235-GET-FJC01-RESTART-REQ                                    *        
      ******************************************************************        
      *                                                                         
       COPY CPD00035.                                                           
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 8887-SAVEPOINT               THRU 8887-EXIT.         
                                                                        
           IF PARM-MSG-NO <= SPACES                                     
              IF PARM-MSG-STATUS > SPACES                               
                 PERFORM 7500-OPEN-CORRESP-HDR        THRU 7500-EXIT    
                 PERFORM 7510-FETCH-CORRESP-HDR       THRU 7510-EXIT    
                 PERFORM UNTIL SQLCODE = NOT-FOUND                      
                    MOVE 1J-ACCOUNT-NO          TO WS-ACCOUNT-NO        
                    PERFORM 5200-CHK-SKIP-ACCTS THRU 5200-CPD347-EXIT   
                    IF PROCESS-ACCT                                     
                       PERFORM 2000-PROCESS-ACCOUNT   THRU 2000-EXIT    
                    END-IF                                              
                    PERFORM 7510-FETCH-CORRESP-HDR    THRU 7510-EXIT    
                 END-PERFORM                                            
                 PERFORM 7520-CLOSE-CORRESP-HDR       THRU 7520-EXIT    
              ELSE                                                      
                 PERFORM 7720-OPEN-CORRESP-STATUS-CD  THRU 7720-EXIT    
                 PERFORM 7730-FETCH-CORRESP-STATUS-CD THRU 7730-EXIT    
                 PERFORM UNTIL SQLCODE = NOT-FOUND                      
                    MOVE 1J-ACCOUNT-NO          TO WS-ACCOUNT-NO        
                    PERFORM 5200-CHK-SKIP-ACCTS THRU 5200-CPD347-EXIT   
                    IF PROCESS-ACCT                                     
                       PERFORM 2000-PROCESS-ACCOUNT   THRU 2000-EXIT    
                    END-IF                                              
                    PERFORM 7730-FETCH-CORRESP-STATUS-CD THRU 7730-EXIT 
                 END-PERFORM                                            
                 PERFORM 7740-CLOSE-CORRESP-STATUS-CD THRU 7740-EXIT    
              END-IF                                                    
           ELSE                                                         
              PERFORM 7530-OPEN-CORRESP-HDR-MSGID     THRU 7530-EXIT    
              PERFORM 7540-FETCH-CORRESP-HDR-MSGID    THRU 7540-EXIT    
              PERFORM UNTIL SQLCODE = NOT-FOUND                         
                 MOVE 1J-ACCOUNT-NO             TO WS-ACCOUNT-NO        
                 PERFORM 5200-CHK-SKIP-ACCTS    THRU 5200-CPD347-EXIT   
                 IF PROCESS-ACCT                                        
                    PERFORM 2000-PROCESS-ACCOUNT      THRU 2000-EXIT    
                 END-IF                                                 
                 PERFORM 7540-FETCH-CORRESP-HDR-MSGID THRU 7540-EXIT    
              END-PERFORM                                               
              PERFORM 7550-CLOSE-CORRESP-HDR-MSGID    THRU 7550-EXIT    
           END-IF.                                                      
                                                                        
      * CHECK IF ATLEAST 1 ACCOUNT WAS PROCESSED SUCCESSFULLY IN THE            
      * ENTIRE RUN WHILE SKIP-COUNTER > 0. IF NOT ABEND THE PROGRAM.            
           IF WS-FCSKR150-CNTR = 0  AND                                 
              WS-SKIP-COUNTER  > 0  AND                                 
              WS-CHKP-SEQ-NO   = 0                                      
              DISPLAY '********** PCSKR150 ABORT **********************'
              DISPLAY '* 1000-PROCESS-INPUT                           *'
              DISPLAY '* ALL THE ACCOUNTS ARE SKIPPED FROM PROCESSING *'
              DISPLAY '* ACCOUNTS PROCESSED : 'WS-PROCESS-COUNTER       
              DISPLAY '* ACCOUNTS SKIPPED   : 'WS-SKIP-COUNTER          
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF                                                       
                                                                        
           PERFORM 0400-PREPARE-PRECOMMIT       THRU 0400-EXIT.         
                                                                        
           MOVE SPACES TO WS-RESTART-JOB-COMPLETE.                      
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-B                         TO WS-RESTART-JOB-STATUS
           ELSE                                                         
              MOVE WS-A                         TO WS-RESTART-JOB-STATUS
           END-IF.                                                      
                                                                        
           IF WS-PROCESS-COUNTER > 0                                    
              PERFORM 8888-COMMIT               THRU 8888-EXIT          
           ELSE                                                         
              PERFORM 8800-WRITE-RESTART        THRU 8800-EXIT          
           END-IF.                                                      
                                                                        
           IF WS-RESTART-REQ EQUAL WS-Y                                 
              PERFORM 8893-RESET-RESTART-REQ-PARM                       
                                                THRU 8893-EXIT          
           END-IF.                                                      
           PERFORM 8840-DELETE-RESTART-ROW      THRU 8840-EXIT.         
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              DISPLAY '** PCSKR150 RERUN COMPLETED **'                  
           ELSE                                                         
              DISPLAY '** PCSKR150 PROCESSING COMPLETED SUCCESSFULLY **'
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-ACCOUNT                                           *        
      * PROCESS FOR EACH ACCOUNT                                       *        
      ******************************************************************        
       2000-PROCESS-ACCOUNT.                                            
                                                                        
P0599A     MOVE 1J-ACCOUNT-NO                   TO WS-DISP-ACCT.        
P0599A     MOVE 1J-CUSTOMER-NO                  TO WS-DISP-CUST-NO.     
P0599A     MOVE 1J-CORRESP-ID                   TO WS-DISP-CORR-ID.     
ACT115     MOVE 1J-CREATED-BY-PGM-ID            TO WS-CREATED-BY-PGM-ID.
P0599A     DISPLAY 'PROCESSING ' WS-DISPLAY-CORRESP.                    
                                                                        
           PERFORM 2010-INITIALIZE-PROCESS-DATA  THRU 2010-EXIT.        
           PERFORM 2020-POPULATE-CORRESP-HDR     THRU 2020-EXIT.        
                                                                        
A04527     MOVE 'N'         TO WS-CORR-COMM-ROW-FOUND.                  
           SET WS-COMM-INDX TO 1.                                       
           SEARCH WS-CORRESP-TABLE-DATA                                 
A04527         AT END                                                   
A04527            MOVE 'N'  TO WS-CORR-COMM-ROW-FOUND                   
             WHEN WS-CORR-MSG-ID(WS-COMM-INDX) = 1J-CORRESP-MSG-ID      
                  MOVE WS-COMM-TYP-CD(WS-COMM-INDX)    TO               
                       WS-EXT-COMM-TYPE-CD                              
                  MOVE WS-COMM-SUBTYP-CD(WS-COMM-INDX) TO               
                       WS-EXT-COMM-SUBTYPE-CD                           
P0599A            MOVE WS-COMM-INSERT-FL(WS-COMM-INDX) TO               
P0599A                 WS-HOLD-COMM-INSERT-FL                           
A04527            MOVE 'Y'  TO WS-CORR-COMM-ROW-FOUND                   
           END-SEARCH.                                                  
                                                                        
A04527     IF WS-CORR-COMM-ROW-FOUND = 'N'                              
A04527        DISPLAY 'CSS_CORRESP_COMM MISSING FOR MSG NO: '           
A04527                1J-CORRESP-MSG-ID '; ACCT NO: ' WS-DISP-ACCT      
A04527                '; CUST NO: ' WS-DISP-CUST-NO                     
A04527        MOVE 12                            TO RS-RETURN-CODE      
A04527        PERFORM 2650-ERROR-CHECK           THRU 2650-EXIT         
A04527        GO TO 2000-EXIT                                           
A04527     END-IF.                                                      
                                                                        
           PERFORM 7560-OPEN-CORRESP-VAR         THRU 7560-EXIT.        
           PERFORM 7570-FETCH-CORRESP-VAR        THRU 7570-EXIT         
           PERFORM 2300-POPULATE-CORRESP-VAR     THRU 2300-EXIT         
             UNTIL SQLCODE = NOT-FOUND.                                 
P0599D     IF TRAN-TM-FOUND                                             
P0599D        PERFORM 2750-IT-CL-LETTER-PROCESS  THRU 2750-EXIT         
P0599D     END-IF.                                                      
           PERFORM 7580-CLOSE-CORRESP-VAR        THRU 7580-EXIT.        
ACT115                                                                  
ACT115     IF SKIP-ACCT                                                 
ACT115        GO TO 2000-EXIT                                           
ACT115     END-IF                                                       
                                                                        
           PERFORM 7010-SELECT-CORRESP-NOTICE    THRU 7010-EXIT.        
           PERFORM 2030-POPULATE-CORRESP-NOTICE  THRU 2030-EXIT.        
           PERFORM 2400-POPULATE-ADDITIONAL-INFO THRU 2400-EXIT.        
                                                                        
           IF 1J-BARCODE-UNIQUE-ID <= SPACES AND                        
              1J-CORRESP-TYPE-CD NOT = 'RC'                             
              MOVE  'N'                  TO WS-CA165IN-UPDATE-SEQ-FL    
              MOVE  'Y'                  TO WS-CA165IN-END-OF-PROG-FL   
              PERFORM 2710-GET-UNIQUE-ID         THRU 2710-EXIT         
           END-IF.                                                      
                                                                        
           EVALUATE 1J-CORRESP-TYPE-CD                                  
               WHEN 'DL'                                                
                    MOVE 'PCSKR150D'     TO MH-APPL-PROGRAM-ID          
               WHEN 'CL'                                                
               WHEN 'IT'                                                
                    MOVE 'PCSKR150C'     TO MH-APPL-PROGRAM-ID          
           END-EVALUATE.                                                
                                                                        
           PERFORM 5000-CALL-SCSCA121            THRU 5000-EXIT.        
           ADD WS-RECORD-CNT                     TO WS-FCSKR150-CNTR.   
           PERFORM 2650-ERROR-CHECK              THRU 2650-EXIT.        
                                                                        
           IF PROCESS-ACCT                                              
              PERFORM 2700-GENERATE-OUTPUT       THRU 2700-EXIT         
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2010-INITIALIZE-PROCESS-DATA                                    *        
      ******************************************************************        
       2010-INITIALIZE-PROCESS-DATA.                                    
                                                                        
           INITIALIZE WS-EXT-HDR                                        
                      WS-EXT-NOTICE                                     
                      WS-EXT-MAILING-DTL                                
                      WS-EXT-ALPHA-VARIABLE-DTL                         
                      WS-EXT-ADDITIONAL-INFO                            
                      WS-EXT-PAYMENT-AGENCY                             
                      WS-EXT-BUS-OFFICE                                 
                      WS-EXT-ALOC-DTL                                   
                      WS-INTERNAL-VARIABLES                             
P0599C                WS-CORRESP-COMPANY-NO                             
P00599                DD-ACCOUNT-NO                                     
P0599D                WS-CR-HIST-TRAN-DT                                
                      WS-CK-CR-MIN-MAX-KEY                              
                      RS-RETURN-CODE                                    
                      WS-RECORD-CNT.                                    
                                                                        
           SET PROCESS-ACCT                      TO TRUE.               
P0599D     MOVE 'N'                              TO WS-TRAN-TM-FL.      
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2020-POPULATE-CORRESP-HDR                                       *        
      ******************************************************************        
       2020-POPULATE-CORRESP-HDR.                                       
                                                                        
           PERFORM 2025-POPULATE-ACCT-DETAILS       THRU 2025-EXIT.     
           IF 1J-GUARNTR-ACCT-NO > 0                                    
              PERFORM 7360-GET-GUARNTR-CUST-NO      THRU 7360-EXIT      
              MOVE WS-CUSTOMER-NO     TO WS-EXT-GUARNTR-CUST-NO         
           END-IF.                                                      
                                                                        
P0599A     IF (1J-CORRESP-TYPE-CD = 'CL' OR 'IT') AND                   
P0599A        (1J-CORRESP-STMT-DT < WS-RUN-DATE)                        
P0599A        MOVE WS-RUN-DATE        TO WS-EXT-STMT-DATE               
P0599A     ELSE                                                         
P0599A        MOVE 1J-CORRESP-STMT-DT TO WS-EXT-STMT-DATE               
P0599A     END-IF.                                                      
                                                                        
           MOVE 1J-CORRESP-ID         TO WS-EXT-HDR-CORR-ID             
                                         WS-CORRESP-ID.                 
           MOVE 1J-ACCOUNT-NO         TO WS-EXT-ACCOUNT-NO              
                                         DO-ACCOUNT-NO.                 
           MOVE 1J-CUSTOMER-NO        TO WS-EXT-CUSTOMER-NO.            
           MOVE 1J-CORRESP-MSG-ID     TO WS-EXT-MESSAGE-ID.             
P0599C     IF 1J-CORRESP-COMPANY-NO NOT = WS-SCEG AND WS-PSNC           
P0599C        MOVE WS-SCEG                   TO WS-CORRESP-COMPANY-NO   
P0599C     ELSE                                                         
P0599C        MOVE 1J-CORRESP-COMPANY-NO     TO WS-CORRESP-COMPANY-NO   
P0599C     END-IF.                                                      
P0599C     MOVE WS-CORRESP-COMPANY-NO TO WS-EXT-COMPANY-NO.             
           MOVE 1J-GUARNTR-ACCT-NO    TO WS-EXT-GUARNTR-ACCT-NO.        
           MOVE 1J-CORRESP-STATUS-CD  TO WS-EXT-STATUS-CD.              
           MOVE 1J-CORRESP-TYPE-CD    TO WS-EXT-TYPE-CD.                
           MOVE 1J-REG-GROUP-CD       TO WS-EXT-REG-GROUP-CD.           
           MOVE 1J-SENIOR-FL          TO WS-EXT-SENIOR-FLAG.            
           MOVE 1J-BARCODE-UNIQUE-ID  TO WS-EXT-UNIQUE-ID.              
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2025-POPULATE-ACCT-DETAILS.                                     *        
      ******************************************************************        
                                                                        
       2025-POPULATE-ACCT-DETAILS.                                      
                                                                        
           IF 1J-ACCOUNT-NO > 0                                         
              PERFORM 7300-GET-ACCT-DETAILS         THRU 7300-EXIT      
              MOVE AT-ADDRESS-ID      TO WS-ADDRESS-ID                  
              MOVE AT-ADDRESS-FORMAT  TO WS-ADDRESS-FORMAT              
              MOVE AT-LOCAL-OFFICE    TO WS-EXT-LOCAL-OFFICE            
A04494        MOVE AT-CODE-ACCT-STAT  TO WS-EXT-ACCT-STAT               
ACT187        MOVE AT-ACCOUNT-TYPE-CODE  TO WS-EXT-ACCOUNT-TYPE-CD      
ACT023        IF AT-CODES-DATA-PRESENT(15:1) = 'A'                      
ACT023           MOVE 'Y'             TO WS-EXT-PRP-FLAG                
ACT023        END-IF                                                    
              IF AT-CODES-DATA-PRESENT(3:1) = 'A'                       
                 MOVE 'Y'             TO WS-EXT-BBP-FLAG                
              END-IF                                                    
              IF AT-CODES-DATA-PRESENT(26:1) = 'A'                      
                 MOVE 'Y'             TO WS-EXT-DPP-FLAG                
              END-IF                                                    
P00599        IF SEB-DATABASE                                           
P00599           MOVE 1J-ACCOUNT-NO   TO DD-ACCOUNT-NO                  
P00599           MOVE SPACES          TO WS-EXT-TIER-ACCT-TYPE          
P00599           PERFORM 7800-GET-ACCT-MKT-TIER     THRU 7800-EXIT      
P00599        END-IF                                                    
           END-IF.                                                      
                                                                        
                                                                        
       2025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2030-POPULATE-CORRESP-NOTICE                                    *        
      ******************************************************************        
                                                                        
       2030-POPULATE-CORRESP-NOTICE.                                    
                                                                        
           IF 1M-NOTICE-DUE-AM  > 0                                     
              MOVE 1J-CORRESP-ID         TO WS-EXT-NOTICE-CORR-ID       
              MOVE 1M-CASH-ONLY-FL       TO WS-EXT-CASH-ONLY-FL         
              MOVE 1M-UTIL-PAST-DUE-AM   TO WS-EXT-UTIL-PAST-DUE-AM     
              MOVE 1M-NOTICE-DUE-DT      TO WS-EXT-NOTICE-DUE-DT        
              MOVE 1M-NOTICE-DUE-AM      TO WS-EXT-NOTICE-DUE-AM        
              MOVE 1M-NONUTL-PAST-DUE-AM TO WS-EXT-NONUTL-PAST-DUE-AM   
              MOVE 1M-AUTO-DEP-FCST-AM   TO WS-EXT-AUTO-DEP-FRCST-AM    
              MOVE 1M-LAST-PAYMENT-AM    TO WS-EXT-LAST-PAYMENT-AM      
              MOVE 1M-LAST-PAYMENT-DT    TO WS-EXT-LAST-PAYMENT-DT      
              COMPUTE WS-EXT-TOT-PAST-DUE-AM =                          
                      1M-UTIL-PAST-DUE-AM + 1M-NONUTL-PAST-DUE-AM       
           END-IF.                                                      
                                                                        
                                                                        
       2030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2300-POPULATE-CORRESP-VAR.                                      *        
      ******************************************************************        
                                                                        
       2300-POPULATE-CORRESP-VAR.                                       
                                                                        
           IF 1K-CORRESP-VAR-NM > SPACES                                
              MOVE 1J-CORRESP-ID          TO WS-EXT-VAR-CORR-ID         
P0599D        IF 1K-CORRESP-VAR-DATA = 'CR-HIST-TRAN-TM' OR             
P0599D                                 'CR-HIST-TRAN-DT'                
P0599D           IF 1K-CORRESP-VAR-DATA = 'CR-HIST-TRAN-DT'             
P0599D              MOVE 1K-CORRESP-VAR-CHAR TO CK-CR-HIST-TRAN-DT      
P0599D                                          LF-CR-HIST-TRAN-DT      
P0599D                                          WS-CR-HIST-TRAN-DT      
P0599D           END-IF                                                 
P0599D           IF 1K-CORRESP-VAR-DATA = 'CR-HIST-TRAN-TM'             
P0599D              SET TRAN-TM-FOUND        TO TRUE                    
P0599D              MOVE 1K-CORRESP-VAR-CHAR TO CK-CR-HIST-TRAN-TM      
P0599D                                          LF-CR-HIST-TRAN-TM      
P0599D           END-IF                                                 
              ELSE                                                      
                 MOVE 1K-CORRESP-VAR-NM            TO WS-CORRESP-VAR-NM 
                 EVALUATE TRUE                                          
                     WHEN CC-NAME-ID                                    
                          MOVE 1K-CORRESP-VAR-NUM  TO WS-CC-NAME-ID     
                     WHEN CC-ADDRESS-ID                                 
                          MOVE 1K-CORRESP-VAR-NUM  TO WS-CC-ADDRESS-ID  
                     WHEN CC-ADDRESS-FORMAT                             
                        MOVE 1K-CORRESP-VAR-CHAR   TO                   
                             WS-CC-ADDRESS-FORMAT                       
ACT135               WHEN RN-ADDRESS-ID                                 
ACT135                    MOVE 1K-CORRESP-VAR-NUM  TO WS-RN-ADDRESS-ID  
ACT135               WHEN RN-ADDRESS-FORMAT                             
ACT135                    MOVE 1K-CORRESP-VAR-CHAR TO                   
ACT135                        WS-RN-ADDRESS-FORMAT                      
                     WHEN ALPHA-VAR-1                                   
                          MOVE 1K-CORRESP-VAR-CHAR TO                   
                               WS-EXT-ALPHA-VARIABLE(1)                 
                     WHEN ALPHA-VAR-2                                   
                          MOVE 1K-CORRESP-VAR-CHAR TO                   
                               WS-EXT-ALPHA-VARIABLE(2)                 
                     WHEN ALPHA-VAR-3                                   
                          MOVE 1K-CORRESP-VAR-CHAR TO                   
                               WS-EXT-ALPHA-VARIABLE(3)                 
                     WHEN ALPHA-VAR-4                                   
                          MOVE 1K-CORRESP-VAR-CHAR TO                   
                               WS-EXT-ALPHA-VARIABLE(4)                 
                     WHEN ALPHA-VAR-5                                   
                          MOVE 1K-CORRESP-VAR-CHAR TO                   
                               WS-EXT-ALPHA-VARIABLE(5)                 
                     WHEN NUM-VAR-1                                     
                          MOVE 1K-CORRESP-VAR-NUM  TO                   
                               WS-EXT-NUM-VARIABLE(1)                   
                     WHEN NUM-VAR-2                                     
                          MOVE 1K-CORRESP-VAR-NUM  TO                   
                               WS-EXT-NUM-VARIABLE(2)                   
                     WHEN NUM-VAR-3                                     
                          MOVE 1K-CORRESP-VAR-NUM  TO                   
                               WS-EXT-NUM-VARIABLE(3)                   
                     WHEN NUM-VAR-4                                     
                          MOVE 1K-CORRESP-VAR-NUM  TO                   
                               WS-EXT-NUM-VARIABLE(4)                   
                     WHEN NUM-VAR-5                                     
                          MOVE 1K-CORRESP-VAR-NUM  TO                   
                               WS-EXT-NUM-VARIABLE(5)                   
                     WHEN DEP-CERT-NO                                   
                          MOVE 1K-CORRESP-VAR-NUM  TO                   
                               DO-DEPOSIT-CERT-NO                       
                     WHEN ESC-RETURN-DT                                 
                          MOVE 1K-CORRESP-VAR-CHAR TO                   
                               WS-EXT-RETURN-BY-DT                      
                 END-EVALUATE                                           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7570-FETCH-CORRESP-VAR               THRU 7570-EXIT. 
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2400-POPULATE-ADDITIONAL-INFO.                                  *        
A05198*IF PROCESSING 90701 (ALOC) OR 90706 (PREPAY ALOC) OR            *        
A05382*90704 (RISK BASED) AND SCORE                                    *        
A05198*MODEL CD = A (AEP) SEND EXCHANGE PHONE NUMBER AND EQUIFAX NUMBER*        
A05198*DECISION WAS MADE TO NOT ADD SCORE-MODEL-CD TO CORRESP CONTACT  *        
A05198*TABLE BECAUSE THIS IS ONLY APPLIES TO ALOC LETTERS.             *        
      ******************************************************************        
                                                                        
       2400-POPULATE-ADDITIONAL-INFO.                                   
                                                                        
           MOVE SPACES                   TO WS-EXT-INDUS-GAS-FLAG       
                                            WS-EXT-CODE-STATE-ID        
                                            WS-EXT-DRIVERS-LICENSE-NO   
                                            WS-EXT-SSN-NO               
                                            WS-EXT-PH-NUMBER1           
                                            WS-EXT-PH-EXT1              
                                            WS-EXT-PH-NUMBER2           
                                            WS-EXT-PH-EXT2.             
           MOVE 1J-CUSTOMER-NO           TO CB-CUSTOMER-NO.             
           MOVE 1J-ACCOUNT-NO            TO AT-ACCOUNT-NO.              
                                                                        
           IF 1J-CORRESP-TYPE-CD= 'GL'                                  
              MOVE WS-EXT-GUARNTR-CUST-NO   TO CE-CUSTOMER-NO           
                                               CB-CUSTOMER-NO           
              PERFORM 7380-GET-GUARNTR-DTLS      THRU 7380-EXIT         
              MOVE CE-CODE-STATE-ID      TO WS-EXT-CODE-STATE-ID        
              MOVE CE-DRIVERS-LICENSE-NO TO WS-EXT-DRIVERS-LICENSE-NO   
              MOVE WS-LAST-4-SSN-NO      TO WS-EXT-SSN-NO               
           END-IF.                                                      
           PERFORM 7400-SELECT-CIG-ACCT          THRU 7400-EXIT.        
           PERFORM 2500-EXTRACT-PHONE-NUMBERS    THRU 2500-EXIT.        
           MOVE WS-HOME-PHONE-NBR        TO     WS-EXT-PH-NUMBER1.      
           MOVE WS-HOME-PHONE-EXT        TO     WS-EXT-PH-EXT1.         
           MOVE WS-WORK-PHONE-NBR        TO     WS-EXT-PH-NUMBER2.      
           MOVE WS-WORK-PHONE-EXT        TO     WS-EXT-PH-EXT2.         
                                                                        
           SET WS-CONTCT-INDX TO 1.                                     
           SEARCH WS-CORRESP-CONTCT-DATA                                
             WHEN WS-CORRESP-MESSAGE-NO(WS-CONTCT-INDX) =               
                  1J-CORRESP-MSG-ID                         AND         
                  WS-CONTCT-COMPANY-NO(WS-CONTCT-INDX) =                
                  WS-CORRESP-COMPANY-NO                                 
                  MOVE WS-CONTCT-ADDR-STREET(WS-CONTCT-INDX) TO         
                       WS-EXT-CONTACT-ADDR-ST                           
                  MOVE WS-CONTCT-ADDR-OVFL(WS-CONTCT-INDX)   TO         
                       WS-EXT-CONTACT-ADDR-OVFLOW                       
                  MOVE WS-CONTCT-CITY-STATE(WS-CONTCT-INDX)  TO         
                       WS-EXT-CONTACT-CITY-STATE                        
                  MOVE WS-CONTCT-ZIP-CODE(WS-CONTCT-INDX)    TO         
                       WS-EXT-CONTACT-ZIP                               
                  MOVE WS-CONTCT-PHONE-NO(WS-CONTCT-INDX)(1:3) TO       
                                   WS-CORR-AREA-CD3                     
                  MOVE WS-CONTCT-PHONE-NO(WS-CONTCT-INDX)(4:3) TO       
                                   WS-CORR-TEL-NO3                      
                  MOVE WS-CONTCT-PHONE-NO(WS-CONTCT-INDX)(7:4) TO       
                                   WS-CORR-TEL-NO4                      
                  MOVE WS-CORR-PHONE-NO                        TO       
                       WS-EXT-CONTACT-PHONE                             
                  MOVE WS-CONTCT-SPCL-PH-NO(WS-CONTCT-INDX)(1:3) TO     
                                   WS-CORR-AREA-CD3                     
                  MOVE WS-CONTCT-SPCL-PH-NO(WS-CONTCT-INDX)(4:3) TO     
                                   WS-CORR-TEL-NO3                      
                  MOVE WS-CONTCT-SPCL-PH-NO(WS-CONTCT-INDX)(7:4) TO     
                                   WS-CORR-TEL-NO4                      
                  MOVE WS-CORR-PHONE-NO                          TO     
                       WS-EXT-CONTACT-SPCL-PHONE                        
A05198            IF CK-SCORE-MODEL-CD = 'A' AND                        
A05198               (1J-CORRESP-MSG-ID = '90701' OR                    
A05198                1J-CORRESP-MSG-ID = '90706')                      
A05198               MOVE '1-866-343-2821'                       TO     
A05198                 WS-EXT-ALPHA-VARIABLE(7)                         
A05198            END-IF                                                
                                                                        
           END-SEARCH.                                                  
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06921000
      * 2450-POPULATE-ALOC-LTR-DTLS                                    *06923000
      ******************************************************************06924000
                                                                        
       2450-POPULATE-ALOC-LTR-DTLS.                                     
                                                                        
      ******************************************************************        
      *  FOR SEB;  REASON = 'D' OR 'A';  CR-ACTION-FL = 'C' OR 'B' ;   *        
      *  MOVE WS-A TO E-RP000-ALPHA-VARIABLE-1.                        *        
      ******************************************************************        
           EVALUATE TRUE                                                
             WHEN SEB-DATABASE                                          
               EVALUATE CK-CR-ACTION-FL                                 
                 WHEN WS-COLLECT                                        
                    MOVE WS-A         TO WS-EXT-ALPHA-VARIABLE(1)       
                 WHEN WS-B                                              
                    MOVE WS-A         TO WS-EXT-ALPHA-VARIABLE(1)       
                 WHEN WS-DENY                                           
                    MOVE WS-C         TO WS-EXT-ALPHA-VARIABLE(1)       
               END-EVALUATE                                             
             WHEN OTHER                                                 
               EVALUATE TRUE                                            
                 WHEN ( CK-CR-RQST-REASON-CD = WS-DEP-WAIVER AND        
                      CK-CR-ACTION-FL      = WS-COLLECT )               
                    MOVE WS-A            TO WS-EXT-ALPHA-VARIABLE(1)    
                 WHEN (CK-CR-RQST-REASON-CD = WS-MERCHANDISE            
                    OR WS-HVAC)                                         
                    MOVE 'H'             TO WS-EXT-ALPHA-VARIABLE(1)    
               END-EVALUATE                                             
           END-EVALUATE.                                                
                                                                        
       2450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06921000
      * 2500-EXTRACT-PHONE-NUMBERS                                     *06923000
      * RETRIEVE HOME AND WORK PHONE NUMBERS FOR CURRENT CUSTOMER      *06923100
      ******************************************************************06924000
      *                                                                 06925000
       2500-EXTRACT-PHONE-NUMBERS.                                      
      *                                                                 06980000
           INITIALIZE  WS-HOME-PHONE-NBR                                
                       WS-WORK-PHONE-NBR                                
                       WS-HOME-PHONE-EXT                                
                       WS-WORK-PHONE-EXT.                               
           MOVE SPACES         TO CB-PHONE-NO                           
                                  CB-EXTENSION-NO                       
           PERFORM 7420-OPEN-PHONE-CURSOR  THRU 7420-EXIT.              
           PERFORM 7440-FETCH-PHONE-CURSOR THRU 7440-EXIT               
              UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.              
           PERFORM 7460-CLOSE-PHONE-CURSOR THRU 7460-EXIT.              
      *                                                                 07050000
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07170000
      ******************************************************************        
      * 2550-POPULATE-ALOC-ITPA-ADDR                                   *        
      ******************************************************************        
                                                                        
       2550-POPULATE-ALOC-ITPA-ADDR.                                    
                                                                        
           INITIALIZE WS-ITPA-ADDR-1                                    
                      WS-ITPA-ADDR-2                                    
                      WS-ITPA-ADDR-3                                    
                      DCLCSS-CRED-HIST-ADDR                             
                      WS-FORMAT-ZIP-1                                   
                      WS-FORMAT-ZIP-2.                                  
                                                                        
           IF 1J-CORRESP-TYPE-CD = 'IT' OR 'CL'                         
              PERFORM 7320-MAX-DATE-TIME-SCOR            THRU 7320-EXIT 
              IF CK-CR-HIST-TRAN-DT = MAX-CR-HIST-TRAN-DT AND           
                 CK-CR-HIST-TRAN-TM = MAX-CR-HIST-TRAN-TM               
                 MOVE CK-CUSTOMER-NO         TO   AT-CUSTOMER-NO        
                 PERFORM 7330-VALIDATE-ACCT-TRAN-DT      THRU 7330-EXIT 
                 IF WS-ACCOUNT-EXISTS = 'N'                             
                    PERFORM 7340-VALIDATE-ACCOUNT        THRU 7340-EXIT 
                    IF WS-ACCOUNT-EXISTS = 'N'                          
                       MOVE ZEROS TO 1J-ACCOUNT-NO                      
                    END-IF                                              
                 END-IF                                                 
                 MOVE 1J-ACCOUNT-NO                      TO             
                                                     WS-EXT-ACCOUNT-NO  
                                                     WS-ACCOUNT-NO      
                 PERFORM 2025-POPULATE-ACCT-DETAILS      THRU 2025-EXIT 
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF 1J-CORRESP-TYPE-CD = 'IT'                                 
              PERFORM 7350-GET-CRED-HIST-ADDR            THRU 7350-EXIT 
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 DISPLAY 'ADDRESS NOT FOUND FOR CUSTOMER # ='           
                          CK-CUSTOMER-NO                                
                 GO TO 2550-EXIT                                        
              END-IF                                                    
                                                                        
              IF LJ-ADDR-STREET1-TEXT  NOT = SPACES                     
                 MOVE LJ-ADDR-STREET1-TEXT   TO WS-ITPA-ADDR-1          
              END-IF                                                    
              IF LJ-ADDR-STREET2-TEXT  NOT = SPACES                     
                 MOVE LJ-ADDR-STREET2-TEXT   TO WS-ITPA-ADDR-2          
              END-IF                                                    
              IF LJ-ADDR-ZIP-CODE(6:4) > 0                              
                 MOVE SPACES TO WS-FORMAT-ZIP-PLUS                      
                 MOVE LJ-ADDR-ZIP-CODE(1:5)  TO WS-FORMAT-ZIP-1         
                 MOVE LJ-ADDR-ZIP-CODE(6:4)  TO WS-FORMAT-ZIP-2         
                 STRING LJ-ADDR-CITY-TEXT    DELIMITED BY SIZE,         
                        LJ-ADDR-STATE        DELIMITED BY SIZE,         
                        ' '                  DELIMITED BY SIZE,         
                        WS-FORMAT-ZIP-PLUS   DELIMITED BY SIZE,         
                        LJ-ADDR-COUNTRY      DELIMITED BY SIZE,         
                        INTO WS-ITPA-ADDR-3                             
              ELSE                                                      
                 STRING LJ-ADDR-CITY-TEXT    DELIMITED BY SIZE,         
                        LJ-ADDR-STATE        DELIMITED BY SIZE,         
                        ' '                  DELIMITED BY SIZE,         
                        LJ-ADDR-ZIP-CODE     DELIMITED BY SIZE,         
                        LJ-ADDR-COUNTRY      DELIMITED BY SIZE,         
                        INTO WS-ITPA-ADDR-3                             
              END-IF                                                    
           END-IF.                                                      
                                                                        
           INSPECT WS-ITPA-ADDR-1 REPLACING ALL LOW-VALUES BY SPACES    
           INSPECT WS-ITPA-ADDR-2 REPLACING ALL LOW-VALUES BY SPACES    
           INSPECT WS-ITPA-ADDR-3 REPLACING ALL LOW-VALUES BY SPACES    
                                                                        
           MOVE SPACES               TO WS-EMB-INPUT,                   
                                        WS-CMP-TABLE.                   
           MOVE 64                   TO WS-EMB-LENG.                    
           MOVE WS-ITPA-ADDR-3       TO WS-EMB-INPUT.                   
           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT.          
           MOVE WS-CMP-TABLE         TO WS-ITPA-ADDR-3.                 
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2600-GET-MIN-MAX-SCORE                                         *        
      ******************************************************************        
      *                                                                         
       2600-GET-MIN-MAX-SCORE.                                          
                                                                        
           SET WS-INDEX1 TO 1.                                          
           MOVE CK-CR-CHK-COMPANY-NO TO WS-CK-CR-CHK-COMPANY-NO.        
           MOVE CK-REG-GROUP-CD      TO WS-CK-REG-GROUP-CD.             
           MOVE CK-CR-RQST-REASON-CD TO WS-CK-CR-RQST-REASON-CD.        
           SEARCH WS-MIN-MAX-DATA                                       
            AT END                                                      
              DISPLAY 'MISSING SCORE RANGE'                             
              DISPLAY 'COMP NO: ' CK-CR-CHK-COMPANY-NO                  
              DISPLAY 'REG GRP: ' CK-REG-GROUP-CD                       
              DISPLAY 'RQST CD: ' CK-CR-RQST-REASON-CD                  
              DISPLAY 'SCORE TYPE:  ' WS-SCORE-TYPE                     
            WHEN  TAB-MIN-MAX-KEY(WS-INDEX1)   = WS-CK-CR-MIN-MAX-KEY   
              MOVE TAB-MM-MIN-SCORE(WS-INDEX1) TO WS-EXT-NUM-VARIABLE(2)
              MOVE TAB-MM-MAX-SCORE(WS-INDEX1) TO WS-EXT-NUM-VARIABLE(3)
                                                                        
           END-SEARCH.                                                  
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07704000
      * 2650-ERROR-CHECK.                                              *        
      * EXCEPTION HANDLING                                             *        
      ******************************************************************07704000
      *                                                                 63240000
       2650-ERROR-CHECK.                                                
      *                                                                 63240000
           IF RS-RETURN-CODE > 0                                        
              PERFORM 8889-ROLLBACK-TO-SAVEPOINT  THRU 8889-EXIT        
              IF WS-UPDATE-DB-FL = 'Y'                                  
                 MOVE 'X'               TO WS-CORRESP-STATUS-CD         
                 IF 1J-ACCOUNT-NO <= 0                                  
                    MOVE -1             TO WS-CORR-ACCT-NULL            
                 ELSE                                                   
                    MOVE ZEROES         TO WS-CORR-ACCT-NULL            
                 END-IF                                                 
                 PERFORM 8500-UPDATE-CORRESP-HDR  THRU 8500-EXIT        
              END-IF                                                    
P0599A        DISPLAY 'SKIPPING ' WS-DISPLAY-CORRESP                    
              SET SKIP-ACCT                       TO TRUE               
              ADD +1                              TO WS-SKIP-COUNTER    
              PERFORM 8887-SAVEPOINT              THRU 8887-EXIT        
              IF WS-SKIP-COUNTER > WS-ACCTS-TO-SKIP                     
                 DISPLAY '********** PCSKR150 ABORT *******************'
                 DISPLAY '* 2650-ERROR-CHECK                          *'
                 DISPLAY '* NO OF ACCOUNTS GREATER THAN SKIP COUNTER  *'
                 DISPLAY '* NO OF ACCTS SKIPPED : 'WS-SKIP-COUNTER      
                 DISPLAY '* DEFAULT SKIP COUNT  : 'WS-ACCTS-TO-SKIP     
                 DISPLAY '* PROCESSING TERMINATED                     *'
                 DISPLAY '********** PCSKR150 ABORT *******************'
                 PERFORM 9900-ABEND               THRU 9900-EXIT        
              END-IF                                                    
                                                                        
           END-IF.                                                      
      *                                                                 63240000
       2650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07704000
      * 2700-GENERATE-OUTPUT.                                          *        
      * PROCESS DB2 UPDATES AND WRITE OUTPUT FILE                      *        
      ******************************************************************07704000
                                                                        
       2700-GENERATE-OUTPUT.                                            
                                                                        
           IF RS-RETURN-CODE = 0 AND WS-UPDATE-DB-FL = 'Y'              
              MOVE 'E'                    TO WS-CORRESP-STATUS-CD       
              IF 1J-ACCOUNT-NO <= 0                                     
                 MOVE -1             TO WS-CORR-ACCT-NULL               
              ELSE                                                      
                 MOVE ZEROES         TO WS-CORR-ACCT-NULL               
              END-IF                                                    
              PERFORM 8500-UPDATE-CORRESP-HDR     THRU 8500-EXIT        
              EVALUATE 1J-CORRESP-TYPE-CD                               
                  WHEN 'CL'                                             
                       PERFORM 8510-UPDATE-CREDIT_HIST  THRU 8510-EXIT  
                  WHEN 'IT'                                             
P0599A                 PERFORM 7355-GET-ITPA-MAIL-DET   THRU 7355-EXIT  
P0599A                 MOVE LF-LETTER-NOTIFY-CD   TO                    
P0599A                                      WS-PREV-LETTER-NOTIFY-CD    
P0599A                 IF  LF-LETTER-NOTIFY-CD = 'A'                    
P0599A                     MOVE 'L'             TO LF-LETTER-NOTIFY-CD  
P0599A                 ELSE                                             
P0599A                     IF  LF-LETTER-NOTIFY-CD = 'U'                
P0599A                         MOVE 'D'         TO LF-LETTER-NOTIFY-CD  
P0599A                     END-IF                                       
P0599A                 END-IF                                           
                       PERFORM 8520-UPDATE-CRED_ITPA-HIST               
                                                        THRU 8520-EXIT  
                  WHEN 'DL'                                             
                       PERFORM 8530-UPDATE-DEP-ON-HAND  THRU 8530-EXIT  
              END-EVALUATE                                              
           END-IF.                                                      
                                                                        
P0599A     IF 1J-CORRESP-TYPE-CD = 'DL' OR 'CL' OR 'IT'                 
P0599A        PERFORM 2720-CREATE-MNT-TRANS-HIST THRU 2720-EXIT         
P0599A        PERFORM 2740-CREATE-COMM-DATA      THRU 2740-EXIT         
P0599A     END-IF.                                                      
                                                                        
           ADD  +1                        TO WS-PROCESS-COUNTER.        
           IF WS-PROCESS-COUNTER = WS-READY-TO-INSERT-COUNT             
              PERFORM 0400-PREPARE-PRECOMMIT      THRU 0400-EXIT        
              PERFORM 8888-COMMIT                 THRU 8888-EXIT        
           END-IF.                                                      
           PERFORM 8887-SAVEPOINT                 THRU 8887-EXIT.       
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00049105
      * 2710-GET-UNIQUE-ID                                           *  00049205
      ******************************************************************00049305
                                                                        
       2710-GET-UNIQUE-ID.                                              
                                                                        
           MOVE 'NONMKT'                  TO WS-CA165IN-CORR-TYPE.      
           MOVE 1J-CUSTOMER-NO            TO WS-CA165IN-CUSTOMER-NO.    
           MOVE 1J-ACCOUNT-NO             TO WS-CA165IN-ACCOUNT-NO      
           MOVE WS-INPUT-DATE             TO WS-CA165IN-PROCESS-DATE.   
           MOVE 1J-CORRESP-COMPANY-NO     TO WS-CA165IN-COMPANY-NO.     
           MOVE WS-UPDATE-DB-FL           TO WS-CA165IN-DATABASE.       
           MOVE SPACES                    TO WS-CA165IN-TP-MEMO-PROCESS.
           MOVE AT-LOCAL-OFFICE           TO WS-CA165IN-LOCAL-OFFICE.   
           MOVE 'SYSTEM'                  TO WS-CA165IN-UPDATE-USERID.  
           MOVE PROGRAM-NAME              TO WS-CA165IN-APPL-PROGRAM-ID.
                                                                        
           IF SEB-DATABASE                                              
              MOVE 1J-REG-GROUP-CD        TO WS-CA165IN-REG-GROUP-CD    
           ELSE                                                         
              MOVE SPACES                 TO WS-CA165IN-REG-GROUP-CD    
           END-IF.                                                      
                                                                        
           PERFORM 5100-CALL-SCSCA165     THRU 5100-EXIT.               
           MOVE WS-CA165OUT-UNIQ-ID       TO WS-EXT-UNIQUE-ID.          
                                                                        
       2710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07704000
      * 2720-CREATE-MNT-TRANS-HIST                                              
      ******************************************************************07704000
                                                                        
       2720-CREATE-MNT-TRANS-HIST.                                      
                                                                        
           PERFORM 7200-GET-TIMESTAMP THRU 7200-EXIT.                   
                                                                        
           MOVE WS-TIMESTAMP          TO MH-TRANS-HIST-SEQ-NO.          
           MOVE WS-INPUT-DATE         TO MH-DATE-TRANS.                 
           MOVE 'F'                   TO MH-CODE-TRAN-TYPE.             
           MOVE ZEROS                 TO MH-PREMISE-NO.                 
           MOVE SPACES                TO MH-RESP-AREA-ID                
P0599A                                   KL-CRED-CD-DESC                
                                         MH-TRAN-COMMENT-TEXT.          
           MOVE 1J-ACCOUNT-NO         TO MH-ACCOUNT-NO.                 
P0599A     MOVE 1J-CUSTOMER-NO        TO MH-CUSTOMER-NO.                
           MOVE WS-SYSTEM             TO MH-USER-ID.                    
P0599A     SET WS-CRED-CODE-INDX      TO 1.                             
P0599A     SEARCH WS-CRED-CODE-TABLE-DATA                               
P0599A       WHEN WS-CRED-CODE(WS-CRED-CODE-INDX) = 1J-CORRESP-TYPE-CD  
P0599A            MOVE WS-CRED-CODE-DESC(WS-CRED-CODE-INDX) TO          
P0599A                 KL-CRED-CD-DESC                                  
P0599A     END-SEARCH.                                                  
                                                                        
           STRING KL-CRED-CD-DESC        DELIMITED BY SIZE,             
                  ';'                    DELIMITED BY SIZE,             
P0599A            1J-CORRESP-MSG-ID      DELIMITED BY SIZE,             
                  ';  MAILED: '          DELIMITED BY SIZE,             
P0599A            WS-EXT-STMT-DATE       DELIMITED BY SIZE,             
                  INTO                         MH-TRAN-COMMENT-TEXT.    
                                                                        
P0599A     IF 1J-CORRESP-TYPE-CD = 'IT'                                 
P0599A        MOVE SPACES                   TO MH-TRAN-COMMENT-TEXT     
P0599A        IF WS-PREV-LETTER-NOTIFY-CD = 'A'                         
P0599A           STRING 'ALERT '               DELIMITED BY SIZE,       
P0599A                  KL-CRED-CD-DESC        DELIMITED BY SIZE,       
P0599A                  ' MAILED: '            DELIMITED BY SIZE,       
P0599A                  WS-EXT-STMT-DATE       DELIMITED BY SIZE,       
P0599A            INTO                         MH-TRAN-COMMENT-TEXT     
P0599A        ELSE                                                      
P0599A           STRING 'UNVERIFIED '          DELIMITED BY SIZE,       
P0599A                  KL-CRED-CD-DESC        DELIMITED BY SIZE,       
P0599A                  ' MAILED: '            DELIMITED BY SIZE,       
P0599A                  WS-EXT-STMT-DATE       DELIMITED BY SIZE,       
P0599A            INTO                         MH-TRAN-COMMENT-TEXT     
P0599A        END-IF                                                    
P0599A     END-IF.                                                      
P0599A                                                                  
P0599D     MOVE LENGTH OF MH-TRAN-COMMENT-TEXT TO MH-TRAN-COMMENT-LEN.  
P0599A     MOVE SPACES               TO WS-EMB-INPUT,                   
P0599A                                  WS-CMP-TABLE.                   
P0599A     MOVE MH-TRAN-COMMENT-LEN  TO WS-EMB-LENG.                    
P0599A     MOVE MH-TRAN-COMMENT-TEXT TO WS-EMB-INPUT.                   
P0599A     PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT.          
P0599A     MOVE SPACES               TO MH-TRAN-COMMENT-TEXT.           
P0599A     MOVE WS-CMP-TABLE         TO MH-TRAN-COMMENT-TEXT.           
                                                                        
P0599A     IF 1J-CORRESP-TYPE-CD = 'DL'                                 
P0599A        MOVE 'H'                   TO MH-CODE-TRAN-TYPE           
P0599A        PERFORM 6540-INSERT-MNT-TRANS-HIST THRU 6540-EXIT         
P0599A     ELSE                                                         
P0599A        PERFORM 2730-BUILD-MNT-HIST-DET    THRU 2730-EXIT         
P0599A     END-IF.                                                      
                                                                        
       2720-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0599A****************************************************************          
P0599A* 2730-BUILD-MNT-HIST-DET.                                     *          
P0599A*                                                              *          
P0599A****************************************************************          
P0599A 2730-BUILD-MNT-HIST-DET.                                         
P0599A                                                                  
P0599A     MOVE 1                        TO WS-TRAN-APPL-NO.            
P0599A     MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
P0599A     MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
P0599A     MOVE SPACES                   TO MI-TABLE-ID.                
P0599A                                                                  
P0599A     IF 1J-CORRESP-TYPE-CD = 'CL'                                 
P0599A        IF CK-ADV-CREDIT-LTR NOT = 'M'                            
P0599A          MOVE 'ADV CREDIT LTR'        TO MI-COLUMN-DESC          
P0599A          MOVE +1                      TO MI-CHG-COLUMN-VALUE-LEN 
P0599A          MOVE 'M'                     TO MI-CHG-COLUMN-VALUE-TEXT
P0599A          IF  CK-ADV-CREDIT-LTR    NOT = SPACES                   
P0599A             MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN 
P0599A             MOVE CK-ADV-CREDIT-LTR    TO MI-PRV-COLUMN-VALUE-TEXT
P0599A          ELSE                                                    
P0599A             MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN 
P0599A             MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT
P0599A          END-IF                                                  
P0599A          PERFORM 6530-LOAD-MNT-TRANS-HIST         THRU 6530-EXIT 
P0599A          ADD  1                       TO WS-TRAN-APPL-NO         
P0599A          MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO         
P0599A        END-IF                                                    
P0599A                                                                  
P0599A        IF CK-ADV-CREDIT-LTR-DT NOT = WS-EXT-STMT-DATE            
P0599A          MOVE 'LETTR MAILED DT'       TO MI-COLUMN-DESC          
P0599A          MOVE +10                     TO MI-CHG-COLUMN-VALUE-LEN 
P0599A          MOVE WS-EXT-STMT-DATE        TO MI-CHG-COLUMN-VALUE-TEXT
P0599A          IF  CK-ADV-CREDIT-LTR-DT NOT = SPACES                   
P0599A             MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN 
P0599A             MOVE CK-ADV-CREDIT-LTR-DT TO MI-PRV-COLUMN-VALUE-TEXT
P0599A          ELSE                                                    
P0599A             MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN 
P0599A             MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT
P0599A          END-IF                                                  
P0599A          PERFORM 6530-LOAD-MNT-TRANS-HIST         THRU 6530-EXIT 
P0599A          ADD  1                       TO WS-TRAN-APPL-NO         
P0599A          MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO         
P0599A        END-IF                                                    
P0599A     END-IF.                                                      
P0599A                                                                  
P0599A     IF 1J-CORRESP-TYPE-CD = 'IT'                                 
P0599A        IF LF-LETTER-NOTIFY-CD NOT = WS-PREV-LETTER-NOTIFY-CD     
P0599A          MOVE 'LETTER NOTIFY'         TO MI-COLUMN-DESC          
P0599A          MOVE +1                      TO MI-CHG-COLUMN-VALUE-LEN 
P0599A          MOVE LF-LETTER-NOTIFY-CD     TO MI-CHG-COLUMN-VALUE-TEXT
P0599A          IF WS-PREV-LETTER-NOTIFY-CD NOT = SPACES                
P0599A             MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN 
P0599A             MOVE WS-PREV-LETTER-NOTIFY-CD                        
P0599A                                       TO MI-PRV-COLUMN-VALUE-TEXT
P0599A          ELSE                                                    
P0599A             MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN 
P0599A             MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT
P0599A          END-IF                                                  
P0599A          PERFORM 6530-LOAD-MNT-TRANS-HIST         THRU 6530-EXIT 
P0599A          ADD  1                       TO WS-TRAN-APPL-NO         
P0599A          MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO         
P0599A        END-IF                                                    
P0599A                                                                  
P0599A        IF LF-LETTER-MAILED-DT  NOT = WS-EXT-STMT-DATE            
P0599A          MOVE 'LETTR MAILED DT'       TO MI-COLUMN-DESC          
P0599A          MOVE +10                     TO MI-CHG-COLUMN-VALUE-LEN 
P0599A          MOVE WS-EXT-STMT-DATE        TO MI-CHG-COLUMN-VALUE-TEXT
P0599A          IF  LF-LETTER-MAILED-DT  NOT = SPACES                   
P0599A             MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN 
P0599A             MOVE LF-LETTER-MAILED-DT  TO MI-PRV-COLUMN-VALUE-TEXT
P0599A          ELSE                                                    
P0599A             MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN 
P0599A             MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT
P0599A          END-IF                                                  
P0599A          PERFORM 6530-LOAD-MNT-TRANS-HIST         THRU 6530-EXIT 
P0599A          ADD  1                       TO WS-TRAN-APPL-NO         
P0599A          MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO         
P0599A        END-IF                                                    
P0599A     END-IF.                                                      
P0599A                                                                  
P0599A 2730-EXIT.                                                       
P0599A     EXIT.                                                        
                                                                        
P0599A******************************************************************07704000
P0599A* 2740-CREATE-COMM-DATA                                                   
P0599A******************************************************************07704000
P0599A                                                                  
P0599A 2740-CREATE-COMM-DATA.                                           
P0599A                                                                  
P0599A     INITIALIZE WS-INITIAL-COMMENT-TX.                            
P0599A                                                                  
P0599A     MOVE 'RECEIVABLES MANAGEMENT' TO KO-CONTACT-NAME.            
P0599A                                                                  
P0599A     IF 1J-CORRESP-TYPE-CD = 'IT'                                 
P0599A                                                                  
P0599A        IF SEB-DATABASE                                           
P0599A           MOVE 'CREDIT DEPARTMENT' TO KO-CONTACT-NAME            
P0599A        END-IF                                                    
P0599A                                                                  
P0599A        STRING 'RESEARCH: '         DELIMITED BY SIZE             
P0599A               1J-CORRESP-MSG-ID    DELIMITED BY SIZE             
P0599A               INTO WS-INITIAL-COMMENT-TX-TEXT                    
P0599A                                                                  
P0599A        IF LF-ITPA-RSLT-CURR-CD = 'V'                             
P0599A           STRING 'ID VERIFIED - UNAUTHORIZED REQUEST: '          
P0599A                                    DELIMITED BY SIZE             
P0599A                  1J-CORRESP-MSG-ID    DELIMITED BY SIZE          
P0599A                  INTO WS-INITIAL-COMMENT-TX-TEXT                 
P0599A        ELSE                                                      
P0599A           IF LF-ITPA-RSLT-CURR-CD = 'U'                          
P0599A              STRING 'UNVERIFIED : ' DELIMITED BY SIZE            
P0599A                     1J-CORRESP-MSG-ID    DELIMITED BY SIZE       
P0599A                     INTO WS-INITIAL-COMMENT-TX-TEXT              
P0599A           END-IF                                                 
P0599A        END-IF                                                    
P0599A        MOVE LENGTH OF WS-INITIAL-COMMENT-TX-TEXT                 
P0599A                                   TO WS-INITIAL-COMMENT-TX-LEN   
P0599A     END-IF.                                                      
P0599A                                                                  
P0599A     IF 1J-CORRESP-TYPE-CD = 'DL'                                 
P0599A        PERFORM 7850-SELECT-BILL-OPTION  THRU 7850-EXIT           
P0599A        IF WS-BILL-OPTION-CD = 'N' OR 'T'                         
P0599A           MOVE 'AUTO DEPOSIT - NEXT BILL'                        
P0599A                        TO WS-INITIAL-COMMENT-TX-TEXT             
P0599A        ELSE                                                      
P0599A           MOVE 'AUTO DEPOSIT - BILL IMMEDIATE'                   
P0599A                        TO WS-INITIAL-COMMENT-TX-TEXT             
P0599A        END-IF                                                    
P0599A        MOVE LENGTH OF WS-INITIAL-COMMENT-TX-TEXT                 
P0599A                                   TO WS-INITIAL-COMMENT-TX-LEN   
P0599A     END-IF.                                                      
P0599A                                                                  
P0599A     PERFORM 8400-INSERT-CUST-COMM-DATA  THRU 8400-EXIT.          
P0599A                                                                  
P0599A 2740-EXIT.                                                       
P0599A     EXIT.                                                        
                                                                        
P0599D******************************************************************07704000
P0599D* 2750-IT-CL-LETTER-PROCESS                                      *        
A05198* IF SCORE-MODEL-CD = SPACES MOVE 'B' (BEACON) TO                *        
A05198* WS-EXT-ALPHA-VARIABLE(6), ELSE MOVE SCORE-MODEL-CD (A OR B) TO *        
A05198* WS-EXT-ALPHA-VARIABLE(6).                                      *        
P0599D******************************************************************07704000
                                                                        
       2750-IT-CL-LETTER-PROCESS.                                       
                                                                        
           MOVE 'N'                 TO WS-ACCOUNT-EXISTS                
           MOVE 1J-CORRESP-STMT-DT  TO WS-EXT-ALPHA-VARIABLE(8)         
           MOVE 1J-CUSTOMER-NO      TO CK-CUSTOMER-NO                   
                                       LF-CUSTOMER-NO                   
                                       CU-CUSTOMER-NO                   
P0599D     IF WS-CR-HIST-TRAN-DT = SPACES OR LOW-VALUES                 
P0599D        MOVE 1J-CORRESP-STMT-DT  TO CK-CR-HIST-TRAN-DT            
P0599D                                    LF-CR-HIST-TRAN-DT            
P0599D     END-IF                                                       
                                                                        
           PERFORM 7310-GET-CREDIT-HIST-DTLS       THRU 7310-EXIT       
ACT115     PERFORM 7365-GET-MOST-RECENT-HIST       THRU 7365-EXIT       
ACT115     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT115        PERFORM 2760-ALOC-ITPA-CHECKS        THRU 2760-EXIT       
ACT115     END-IF                                                       
ACT115     IF SKIP-ACCT                                                 
ACT115        GO TO 2750-EXIT                                           
ACT115     END-IF                                                       
ACT115                                                                  
           IF 1J-ACCOUNT-NO <= 0                                        
              PERFORM 7100-GET-COMPANY-NO          THRU 7100-EXIT       
           END-IF                                                       
           PERFORM 2450-POPULATE-ALOC-LTR-DTLS     THRU 2450-EXIT       
           MOVE CK-CR-RQST-REASON-CD         TO                         
                WS-EXT-ALPHA-VARIABLE(1)(2:1)                           
           MOVE CK-CB-BEACON-AA1-CD          TO                         
                WS-EXT-ALPHA-VARIABLE(2)                                
           MOVE CK-CB-BEACON-AA2-CD          TO                         
                WS-EXT-ALPHA-VARIABLE(3)                                
           MOVE CK-CB-BEACON-AA3-CD          TO                         
                WS-EXT-ALPHA-VARIABLE(4)                                
           MOVE CK-CB-BEACON-AA4-CD          TO                         
                WS-EXT-ALPHA-VARIABLE(5)                                
           MOVE CK-CB-FACT-ACT-CD            TO                         
                WS-EXT-ALPHA-VARIABLE(9)                                
                                                                        
A05198     IF CK-SCORE-MODEL-CD = SPACES                                
A05198        MOVE 'B'                  TO WS-EXT-ALPHA-VARIABLE(6)     
A05198                                     WS-SCORE-TYPE                
A05198     ELSE                                                         
A05198        MOVE CK-SCORE-MODEL-CD    TO WS-EXT-ALPHA-VARIABLE(6)     
A05198                                     WS-SCORE-TYPE                
A05198     END-IF                                                       
A05198                                                                  
A05198     IF CK-SCORE-MODEL-CD = 'A'                                   
A05198        IF CK-ADDL-CRED-SCORE = SPACES OR LOW-VALUES              
A05198           MOVE ZEROS              TO WS-EXT-NUM-VARIABLE(1)      
A05198        ELSE                                                      
A05198           MOVE CK-ADDL-CRED-SCORE TO WS-EXT-NUM-VARIABLE(1)      
A05198        END-IF                                                    
A05198     ELSE                                                         
              IF CK-BEACON-SCORE = SPACES OR LOW-VALUES                 
                 MOVE ZEROS              TO WS-EXT-NUM-VARIABLE(1)      
              ELSE                                                      
                 MOVE CK-BEACON-SCORE    TO WS-EXT-NUM-VARIABLE(1)      
A05198        END-IF                                                    
           END-IF                                                       
                                                                        
           PERFORM 2600-GET-MIN-MAX-SCORE          THRU 2600-EXIT       
           PERFORM 2550-POPULATE-ALOC-ITPA-ADDR    THRU 2550-EXIT.      
                                                                        
P0599D 2750-EXIT.                                                       
P0599D     EXIT.                                                        
P0599D                                                                  
      ******************************************************************07704000
ACT115* 2760-ALOC-ITPA-CHECKS                                                   
      ******************************************************************07704000
ACT115 2760-ALOC-ITPA-CHECKS.                                           
ACT115     IF 1J-CORRESP-TYPE-CD = 'CL'                                 
ACT115        IF RECENT-ADV-CREDIT-LTR = 'N'                            
ACT115           PERFORM 2765-CANCEL-CORRESP    THRU 2765-EXIT          
ACT115        END-IF                                                    
ACT115     ELSE                                                         
ACT115        IF 1J-CORRESP-TYPE-CD = 'IT'                              
ACT115          IF 1J-CORRESP-MSG-ID = '92061' OR '92063'               
ACT115            PERFORM 7370-GET-ITPA-HIST        THRU 7370-EXIT      
ACT115          END-IF                                                  
ACT115            EVALUATE 1J-CORRESP-MSG-ID                            
ACT115               WHEN 92061                                         
ACT115               WHEN 92062                                         
ACT115                   IF RECENT-LETTER-NOTIFY-CD = 'A'               
ACT115                      CONTINUE                                    
ACT115                   ELSE                                           
ACT115                      PERFORM 2765-CANCEL-CORRESP  THRU 2765-EXIT 
ACT115                   END-IF                                         
ACT115               WHEN 92063                                         
ACT115               WHEN 92064                                         
ACT115                   IF RECENT-LETTER-NOTIFY-CD = 'U'               
ACT115                      CONTINUE                                    
ACT115                   ELSE                                           
ACT115                      PERFORM 2765-CANCEL-CORRESP  THRU 2765-EXIT 
ACT115                   END-IF                                         
ACT115            END-EVALUATE                                          
ACT115        END-IF                                                    
ACT115     END-IF.                                                      
ACT115 2760-EXIT.                                                       
ACT115     EXIT.                                                        
ACT115*                                                                         
ACT115 2765-CANCEL-CORRESP.                                             
ACT115     MOVE 'C'             TO WS-CORRESP-STATUS-CD.                
ACT115     IF 1J-ACCOUNT-NO <= 0                                        
ACT115        MOVE -1           TO WS-CORR-ACCT-NULL                    
ACT115     ELSE                                                         
ACT115        MOVE ZEROES       TO WS-CORR-ACCT-NULL                    
ACT115     END-IF.                                                      
ACT115     PERFORM 8500-UPDATE-CORRESP-HDR   THRU 8500-EXIT.            
ACT115                                                                  
ACT115     MOVE 'N'             TO WS-PROCESS-ACCOUNT.                  
ACT115*                                                                         
ACT115 2765-EXIT.                                                       
ACT115     EXIT.                                                        
      ******************************************************************07704000
      * 5000-CALL-SCSCA121                                                      
      ******************************************************************07704000
                                                                        
       5000-CALL-SCSCA121.                                              
                                                                        
           DISPLAY 'CALLING SCSCA121'.                                  
           CALL SCSCA121 USING WS-EXT-HDR                               
                               WS-EXT-NOTICE                            
                               WS-EXT-MAILING-DTL                       
                               WS-EXT-ALPHA-VARIABLE-DTL                
                               WS-EXT-ADDITIONAL-INFO                   
                               WS-EXT-PAYMENT-AGENCY                    
                               WS-EXT-BUS-OFFICE                        
                               WS-EXT-ALOC-DTL                          
                               WS-INTERNAL-VARIABLES                    
                               WS-UPDATE-DB-FL                          
                               RS-RETURN-CODE                           
                               WS-RECORD-CNT.                           
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00052705
      * 5100-CALL-SCSCA165.                                            *00052805
      ******************************************************************00052905
                                                                        
       5100-CALL-SCSCA165.                                              
                                                                        
           MOVE SPACES          TO ABEND-FUNCTION.                      
                                                                        
           CALL SCSCA165  USING    WS-SCSCA165-PARMS                    
                                  ,WS-CA165-MISC                        
                                  ,ABEND-FILE                           
                                  ,WS-CA165-RET.                        
                                                                        
           MOVE WS-CA165-RET    TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************************************'            
              DISPLAY '**        SCSCA165 FAILED         **'            
              DISPLAY '************************************'            
              DISPLAY '*** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '*** ACCOUNT-NO  = ' 1J-ACCOUNT-NO                
              DISPLAY '************************************'            
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5200-CHK-SKIP-ACCTS                                      *      11187000
      ******************************************************************11187100
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00347                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6010-REDUCE-EMBEDDED-SPACES                                    *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00004                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00037                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6253-GET-FJC01-CHKP-LIMIT.                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00034                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6240-GET-FCA00-COMMON-DATE                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00040                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      ** 6540-INSERT-MNT-TRANS-HIST.                                 **         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 7620-START-FCSCA00                                             *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00039                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7000-SELECT-DELINQ-VALUE                                       *        
      * SELECTS THE DELINQUENCY VALUE FOR THE GIVEN DELINQ CODE        *        
      ******************************************************************        
       7000-SELECT-DELINQ-VALUE.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY                                    
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **************'        
              DISPLAY '* 7000-SELECT-DELINQ-VALUE             *'        
              DISPLAY '* DELINQ CD ', C8-DELINQ-CD                      
              DISPLAY '* COMPANY NO', C8-COMPANY-NO                     
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSKR150 ABORT **************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010-SELECT-CORRESP-NOTICE                                              
      ******************************************************************        
                                                                        
       7010-SELECT-CORRESP-NOTICE.                                      
                                                                        
           EXEC SQL                                                     
              SELECT A.CASH_ONLY_FL                                     
                    ,A.AUTO_DEP_FCST_AM                                 
                    ,A.UTIL_PAST_DUE_AM                                 
                    ,A.NONUTL_PAST_DUE_AM                               
                    ,A.NOTICE_DUE_DT                                    
                    ,A.NOTICE_DUE_AM                                    
                    ,A.LAST_PAYMENT_AM                                  
                    ,A.LAST_PAYMENT_DT                                  
                INTO :1M-CASH-ONLY-FL                                   
                    ,:1M-AUTO-DEP-FCST-AM                               
                    ,:1M-UTIL-PAST-DUE-AM                               
                    ,:1M-NONUTL-PAST-DUE-AM                             
                    ,:1M-NOTICE-DUE-DT :WS-NOTICE-DUE-DT-NULL      
                    ,:1M-NOTICE-DUE-AM                                  
                    ,:1M-LAST-PAYMENT-AM                                
                    ,:1M-LAST-PAYMENT-DT :WS-LAST-PYMT-DT-NULL       
                FROM CSS_CORRESP_NOTICE A WITH(READUNCOMMITTED)                 
               WHERE A.CORRESP_ID  = :WS-CORRESP-ID                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT A.CASH_ONLY_FL                                             
MFA-TR*             ,A.AUTO_DEP_FCST_AM                                         
MFA-TR*             ,A.UTIL_PAST_DUE_AM                                         
MFA-TR*             ,A.NONUTL_PAST_DUE_AM                                       
MFA-TR*             ,A.NOTICE_DUE_DT                                            
MFA-TR*             ,A.NOTICE_DUE_AM                                            
MFA-TR*             ,A.LAST_PAYMENT_AM                                          
MFA-TR*             ,A.LAST_PAYMENT_DT                                          
MFA-TR*         INTO :1M-CASH-ONLY-FL                                           
MFA-TR*             ,:1M-AUTO-DEP-FCST-AM                                       
MFA-TR*             ,:1M-UTIL-PAST-DUE-AM                                       
MFA-TR*             ,:1M-NONUTL-PAST-DUE-AM                                     
MFA-TR*             ,:1M-NOTICE-DUE-DT      :WS-NOTICE-DUE-DT-NULL              
MFA-TR*             ,:1M-NOTICE-DUE-AM                                          
MFA-TR*             ,:1M-LAST-PAYMENT-AM                                        
MFA-TR*             ,:1M-LAST-PAYMENT-DT    :WS-LAST-PYMT-DT-NULL               
MFA-TR*         FROM CSS_CORRESP_NOTICE A                                       
MFA-TR*        WHERE A.CORRESP_ID  = :WS-CORRESP-ID                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
P0599A        IF WS-NOTICE-DUE-DT-NULL < 0                              
P0599A           MOVE SPACES                   TO 1M-NOTICE-DUE-DT      
P0599A        END-IF                                                    
P0599A        IF WS-LAST-PYMT-DT-NULL  < 0                              
P0599A           MOVE SPACES                   TO 1M-LAST-PAYMENT-DT    
P0599A        END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
              DISPLAY '* ABEND IN 7010-SELECT-CORRESP-NOTICE          *'
              DISPLAY '* CORRESP_VAR_NOTICE CURSOR ERROR              *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* CORRESP ID          = ' WS-CORRESP-ID          
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************39192800
      * 7020-VALIDATE-DATE                                             *39192900
      * THIS MODULE PERFORMS THE DATE VALIDATION.                      *39193000
      ******************************************************************39193200
                                                                        
       7020-VALIDATE-DATE.                                              
                                                                        
           EXEC SQL                                                     
              SELECT
              IIF(TRY_CONVERT(DATE, :WS-TEST-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-TEST-DATE
              ) <> 0) OR (LEN(:WS-TEST-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-TEST-DATE
              ), CONVERT(DATE, :WS-TEST-DATE) )
            INTO
              :WS-VALID-DATE                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     39193500
MFA-TR*       SET :WS-VALID-DATE =  DATE(:WS-TEST-DATE)                 39193600
MFA-TR*    END-EXEC.                                                    39195000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              SET INVALID-DATE      TO TRUE                             
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7035-LOAD-MIN-MAX-BEACON.                                    *        
      *        GET MIN AND MAX SCORE NUMBER                            *        
A05198*        INCLUDE SCORE-MODEL-CD FROM MIN_MAX CURSOR.             *        
      ******************************************************************        
       7035-LOAD-MIN-MAX-BEACON.                                        
      *                                                                         
           MOVE '7035'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
               SELECT COALESCE (MIN(MIN_SCORE_NO),0),                     
                      COALESCE (MAX(MAX_SCORE_NO),0)                      
                 INTO :D6-MIN-SCORE-NO,                                 
                      :D6-MAX-SCORE-NO                                  
                 FROM CSS_DEP_REQUIREMNT C WITH(READUNCOMMITTED)                
                 WHERE C.COMPANY_NO        = :D6-COMPANY-NO             
                   AND C.REG_GROUP_CD      = :D6-REG-GROUP-CD           
                   AND C.CR_RQST_REASON_CD = :D6-CR-RQST-REASON-CD      
A05198             AND C.SCORE_MODEL_CD    = :D6-SCORE-MODEL-CD         
                   AND C.MIN_SCORE_NO      > 0                          
                   AND C.MAX_SCORE_NO      < 1001                       
                   AND C.EFFECTIVE_DT      =                            
                     (SELECT MAX(C1.EFFECTIVE_DT)                       
                        FROM CSS_DEP_REQUIREMNT C1 WITH(READUNCOMMITTED)        
                       WHERE C1.REG_GROUP_CD      = C.REG_GROUP_CD      
                         AND C1.COMPANY_NO        = C.COMPANY_NO        
                         AND C1.CR_RQST_REASON_CD = C.CR_RQST_REASON_CD 
A05198                   AND C1.SCORE_MODEL_CD    = C.SCORE_MODEL_CD    
                         AND C1.EFFECTIVE_DT     <= 
              IIF(TRY_CONVERT(DATE, :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) ))     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IFNULL (MIN(MIN_SCORE_NO),0),                             
MFA-TR*               IFNULL (MAX(MAX_SCORE_NO),0)                              
MFA-TR*          INTO :D6-MIN-SCORE-NO,                                         
MFA-TR*               :D6-MAX-SCORE-NO                                          
MFA-TR*          FROM CSS_DEP_REQUIREMNT C                                      
MFA-TR*          WHERE C.COMPANY_NO        = :D6-COMPANY-NO                     
MFA-TR*            AND C.REG_GROUP_CD      = :D6-REG-GROUP-CD                   
MFA-TR*            AND C.CR_RQST_REASON_CD = :D6-CR-RQST-REASON-CD              
MFA-TR*            AND C.SCORE_MODEL_CD    = :D6-SCORE-MODEL-CD                 
MFA-TR*            AND C.MIN_SCORE_NO      > 0                                  
MFA-TR*            AND C.MAX_SCORE_NO      < 1001                               
MFA-TR*            AND C.EFFECTIVE_DT      =                                    
MFA-TR*              (SELECT MAX(C1.EFFECTIVE_DT)                               
MFA-TR*                 FROM CSS_DEP_REQUIREMNT C1                              
MFA-TR*                WHERE C1.REG_GROUP_CD      = C.REG_GROUP_CD              
MFA-TR*                  AND C1.COMPANY_NO        = C.COMPANY_NO                
MFA-TR*                  AND C1.CR_RQST_REASON_CD = C.CR_RQST_REASON_CD         
MFA-TR*                  AND C1.SCORE_MODEL_CD    = C.SCORE_MODEL_CD            
MFA-TR*                  AND C1.EFFECTIVE_DT     <= :WS-INPUT-DATE)             
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7035                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A05198        AND D6-MIN-SCORE-NO > 0                                   
              MOVE D6-COMPANY-NO        TO TAB-MM-COMPANY(WS-INDEX1)    
              MOVE D6-REG-GROUP-CD      TO TAB-MM-REG-GRP-CD(WS-INDEX1) 
              MOVE D6-CR-RQST-REASON-CD TO TAB-MM-RQST-CD(WS-INDEX1)    
              MOVE D6-MIN-SCORE-NO      TO TAB-MM-MIN-SCORE(WS-INDEX1)  
              MOVE D6-MAX-SCORE-NO      TO TAB-MM-MAX-SCORE(WS-INDEX1)  
A05198        MOVE D6-SCORE-MODEL-CD    TO TAB-MM-SCORE-TYPE(WS-INDEX1) 
              SET WS-INDEX1 UP BY 1                                     
           ELSE                                                         
A05198        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
A05198           AND D6-MIN-SCORE-NO = 0                                
A05198           CONTINUE                                               
A05198        ELSE                                                      
                 DISPLAY '*******************************************'  
                 DISPLAY '***  PCSCA145 PROCESSING ERROR          ***'  
                 DISPLAY '***  PARA 7035-LOAD-MIN-MAX-BEACON      ***'  
                 DISPLAY '***  RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
                 DISPLAY '***  COMPANY NO = ' D6-COMPANY-NO             
                 DISPLAY '***  REG GROUP CD = ' D6-REG-GROUP-CD         
                 DISPLAY '***  RQST REAS CD = ' D6-CR-RQST-REASON-CD    
                 DISPLAY '***  PROCESSING TERMINATED              ***'  
                 DISPLAY '*******************************************'  
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
A05198        END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7035-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7050-SELECT-RESTART.                                            *        
      * THIS PARAGRAPH SELECTS A RESTART RECORD FROM CSS_RESTART       *        
      ******************************************************************        
       7050-SELECT-RESTART.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT RESTART_DATA                                       
                INTO :RF-RESTART-DATA                                   
                FROM CSS_RESTART                                        
               WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                    
                 AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                    
                 AND PARTITION_NO = :RF-PARTITION-NO                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESTART_DATA                                               
MFA-TR*         INTO :RF-RESTART-DATA                                           
MFA-TR*         FROM CSS_RESTART                                                
MFA-TR*        WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                            
MFA-TR*          AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                            
MFA-TR*          AND PARTITION_NO = :RF-PARTITION-NO                            
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **************'        
              DISPLAY '*    ERROR IN 7050-SELECT-RESTART      *'        
              DISPLAY '* NAME PROGRAM', RF-NAME-PROGRAM                 
              DISPLAY '* DUP CNTRL NO', RF-DUP-CNTRL-NO                 
              DISPLAY '* PARTITION NO', RF-PARTITION-NO                 
              DISPLAY '* SQL CODE IS '  WS-ACTIVE-RETURN-CODE           
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSKR150 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *        GET COMPANY NUMBER IF CUSTOMER DOESN'T HAVE ACCOUNT.    *        
      ******************************************************************        
       7100-GET-COMPANY-NO.                                             
                                                                        
           EXEC SQL                                                     
               SELECT COMPANY_NO_ORIG                                   
                     ,NAME_ID                                           
               INTO   :CU-COMPANY-NO-ORIG                               
                     ,:CU-NAME-ID                                       
               FROM   CSS_CUSTOMER WITH(READUNCOMMITTED)                        
               WHERE  CUSTOMER_NO = :CU-CUSTOMER-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NO_ORIG                                           
MFA-TR*              ,NAME_ID                                                   
MFA-TR*        INTO   :CU-COMPANY-NO-ORIG                                       
MFA-TR*              ,:CU-NAME-ID                                               
MFA-TR*        FROM   CSS_CUSTOMER                                              
MFA-TR*        WHERE  CUSTOMER_NO = :CU-CUSTOMER-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF CU-COMPANY-NO-ORIG NOT = '01' AND '26'                 
                 MOVE '01'             TO CU-COMPANY-NO-ORIG            
              END-IF                                                    
           ELSE                                                         
                DISPLAY '*******************************************'   
                DISPLAY '** ERROR IN 7100-GET-COMPANY-NO          **'   
                DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
                DISPLAY '**        PROCESSING IS TERMINATED       **'   
                DISPLAY '** CUSTOMER NO ' CU-CUSTOMER-NO                
                DISPLAY '*******************************************'   
                PERFORM 9900-ABEND                THRU 9900-EXIT        
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7130-OPEN-MIN-MAX-CURSOR.                                      *        
      *  OPENS THE MIN MAX CURSOR FOR PROCESSING                       *        
      *                                                                *        
      ******************************************************************        
       7130-OPEN-MIN-MAX-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               OPEN MIN_MAX_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7130-OPEN-MIN-MAX-CURSOR'                       
                       ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   7140-FETCH-MIN-MAX-CURSOR.                                   *        
      *        FETCHES THE RECORD FORM THE OPENED CURSOR               *        
      *                                                                *        
      ******************************************************************        
       7140-FETCH-MIN-MAX-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
               FETCH MIN_MAX_CSR                                        
               INTO :D6-CR-RQST-REASON-CD,                              
                    :D6-COMPANY-NO,                                     
                    :D6-REG-GROUP-CD,                                   
A05198              :D6-SCORE-MODEL-CD                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7140-FETCH-MIN-MAX-CURSOR'                       
                      ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   7150-CLOSE-MIN-MAX-CURSOR.                                   *        
      *        CLOSES THE OPENED CURSOR                                *        
      ******************************************************************        
       7150-CLOSE-MIN-MAX-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE MIN_MAX_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7150-CLOSE-MIN-MAX-CURSOR'                      
                       ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GET TIMESTAMP FOR MNT_TRANS_HIST FILE                   *               
      ******************************************************************        
                                                                        
       7200-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTAMP                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET: WS-TIMESTAMP = CURRENT TIMESTAMP                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '** ERROR IN 7200-SELECT-TIMESTAMP        **'     
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '**        PROCESSING IS TERMINATED       **'     
              DISPLAY '** ACCOUNT NO ' AT-ACCOUNT-NO                    
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-GET-ACCT-DETAILS                                          *        
      ******************************************************************        
       7300-GET-ACCT-DETAILS.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT AT.ADDRESS_ID                                      
                    ,AT.ADDRESS_FORMAT                                  
                    ,AT.LOCAL_OFFICE                                    
                    ,AT.CODES_DATA_PRESENT                              
A04494              ,AT.CODE_ACCT_STAT                                  
ACT187              ,AT.ACCOUNT_TYPE_CODE                               
                INTO :AT-ADDRESS-ID                                     
                    ,:AT-ADDRESS-FORMAT                                 
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-CODES-DATA-PRESENT                             
A04494              ,:AT-CODE-ACCT-STAT                                 
ACT187              ,:AT-ACCOUNT-TYPE-CODE                              
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO = :1J-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.ADDRESS_ID                                              
MFA-TR*             ,AT.ADDRESS_FORMAT                                          
MFA-TR*             ,AT.LOCAL_OFFICE                                            
MFA-TR*             ,AT.CODES_DATA_PRESENT                                      
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                                       
MFA-TR*         INTO :AT-ADDRESS-ID                                             
MFA-TR*             ,:AT-ADDRESS-FORMAT                                         
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-CODES-DATA-PRESENT                                     
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO = :1J-ACCOUNT-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **************'        
              DISPLAY '* 7300-GET-ACCT-DETAILS                *'        
              DISPLAY '* ACCOUNT NO = '1J-ACCOUNT-NO                    
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSKR150 ABORT **************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7310-GET-CREDIT-HIST-DTLS                                      *        
      ******************************************************************        
       7310-GET-CREDIT-HIST-DTLS.                                       
      *                                                                         
           EXEC SQL                                                     
              SELECT CK.CB_BEACON_AA1_CD                                
                    ,CK.CB_BEACON_AA2_CD                                
                    ,CK.CB_BEACON_AA3_CD                                
                    ,CK.CB_BEACON_AA4_CD                                
                    ,CK.CR_RQST_REASON_CD                               
                    ,CK.ITPA_EXISTS_CD                                  
                    ,CK.BEACON_SCORE                                    
                    ,CK.REG_GROUP_CD                                    
                    ,CK.CR_ACTION_FL                                    
                    ,CK.CB_HIT_CD                                       
                    ,CK.CR_CHK_COMPANY_NO                               
                    ,CK.CB_FACT_ACT_CD                                  
P0599A              ,CK.ADV_CREDIT_LTR                                  
P0599A              ,CK.ADV_CREDIT_LTR_DT                               
A05198              ,CK.ADDL_CRED_SCORE                                 
A05198              ,CK.SCORE_MODEL_CD                                  
                INTO :CK-CB-BEACON-AA1-CD                               
                    ,:CK-CB-BEACON-AA2-CD                               
                    ,:CK-CB-BEACON-AA3-CD                               
                    ,:CK-CB-BEACON-AA4-CD                               
                    ,:CK-CR-RQST-REASON-CD                              
                    ,:CK-ITPA-EXISTS-CD                                 
                    ,:CK-BEACON-SCORE                                   
                    ,:CK-REG-GROUP-CD                                   
                    ,:CK-CR-ACTION-FL                                   
                    ,:CK-CB-HIT-CD                                      
                    ,:CK-CR-CHK-COMPANY-NO                              
                    ,:CK-CB-FACT-ACT-CD                                 
P0599A              ,:CK-ADV-CREDIT-LTR                                 
P0599A              ,:CK-ADV-CREDIT-LTR-DT :WS-NULL-IND1                 
A05198              ,:CK-ADDL-CRED-SCORE                                
A05198              ,:CK-SCORE-MODEL-CD                                 
                FROM CSS_CREDIT_HIST CK WITH(READUNCOMMITTED)                   
               WHERE CK.CUSTOMER_NO     = :CK-CUSTOMER-NO               
                 AND CK.CR_HIST_TRAN_DT = IIF(TRY_CONVERT(DATE, 
                                                    :CK-CR-HIST-TRAN-DT
              ) IS NULL OR (PATINDEX('%.%', :CK-CR-HIST-TRAN-DT
              ) <> 0) OR (LEN(:CK-CR-HIST-TRAN-DT
              ) <> 10), CIS.CHAR2DATE(:CK-CR-HIST-TRAN-DT
              ), CONVERT(DATE, :CK-CR-HIST-TRAN-DT) )           
                 AND CK.CR_HIST_TRAN_TM = CIS.CHAR2TIME(
                                                    :CK-CR-HIST-TRAN-TM
              )           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CK.CB_BEACON_AA1_CD                                        
MFA-TR*             ,CK.CB_BEACON_AA2_CD                                        
MFA-TR*             ,CK.CB_BEACON_AA3_CD                                        
MFA-TR*             ,CK.CB_BEACON_AA4_CD                                        
MFA-TR*             ,CK.CR_RQST_REASON_CD                                       
MFA-TR*             ,CK.ITPA_EXISTS_CD                                          
MFA-TR*             ,CK.BEACON_SCORE                                            
MFA-TR*             ,CK.REG_GROUP_CD                                            
MFA-TR*             ,CK.CR_ACTION_FL                                            
MFA-TR*             ,CK.CB_HIT_CD                                               
MFA-TR*             ,CK.CR_CHK_COMPANY_NO                                       
MFA-TR*             ,CK.CB_FACT_ACT_CD                                          
MFA-TR*             ,CK.ADV_CREDIT_LTR                                          
MFA-TR*             ,CK.ADV_CREDIT_LTR_DT                                       
MFA-TR*             ,CK.ADDL_CRED_SCORE                                         
MFA-TR*             ,CK.SCORE_MODEL_CD                                          
MFA-TR*         INTO :CK-CB-BEACON-AA1-CD                                       
MFA-TR*             ,:CK-CB-BEACON-AA2-CD                                       
MFA-TR*             ,:CK-CB-BEACON-AA3-CD                                       
MFA-TR*             ,:CK-CB-BEACON-AA4-CD                                       
MFA-TR*             ,:CK-CR-RQST-REASON-CD                                      
MFA-TR*             ,:CK-ITPA-EXISTS-CD                                         
MFA-TR*             ,:CK-BEACON-SCORE                                           
MFA-TR*             ,:CK-REG-GROUP-CD                                           
MFA-TR*             ,:CK-CR-ACTION-FL                                           
MFA-TR*             ,:CK-CB-HIT-CD                                              
MFA-TR*             ,:CK-CR-CHK-COMPANY-NO                                      
MFA-TR*             ,:CK-CB-FACT-ACT-CD                                         
MFA-TR*             ,:CK-ADV-CREDIT-LTR                                         
MFA-TR*             ,:CK-ADV-CREDIT-LTR-DT:WS-NULL-IND1                         
MFA-TR*             ,:CK-ADDL-CRED-SCORE                                        
MFA-TR*             ,:CK-SCORE-MODEL-CD                                         
MFA-TR*         FROM CSS_CREDIT_HIST CK                                         
MFA-TR*        WHERE CK.CUSTOMER_NO     = :CK-CUSTOMER-NO                       
MFA-TR*          AND CK.CR_HIST_TRAN_DT = :CK-CR-HIST-TRAN-DT                   
MFA-TR*          AND CK.CR_HIST_TRAN_TM = :CK-CR-HIST-TRAN-TM                   
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7310                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0599A        IF WS-NULL-IND1 = -1                                      
P0599A           MOVE SPACES            TO CK-ADV-CREDIT-LTR-DT         
P0599A           MOVE 0                 TO WS-NULL-IND1                 
P0599A        END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT ***************'       
              DISPLAY '* 7310-GET-CREDIT-HIST-DTLS             *'       
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* CUSTOMER NO     = 'CK-CUSTOMER-NO              
              DISPLAY '* CR HIST TRAN DT = 'CK-CR-HIST-TRAN-DT          
              DISPLAY '* CR HIST TRAN TM = 'CK-CR-HIST-TRAN-TM          
              DISPLAY '* PROCESSING TERMINATED                 *'       
              DISPLAY '********** PCSKR150 ABORT ***************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7320-MAX-DATE-TIME-SCOR                                        *        
      ******************************************************************        
                                                                        
       7320-MAX-DATE-TIME-SCOR.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CK.CR_HIST_TRAN_DT,
              REPLACE(CONVERT(CHAR(8), CK.CR_HIST_TRAN_TM, 108), ':', 
           '.') CR_HIST_TRAN_TM                                 
                INTO :MAX-CR-HIST-TRAN-DT                               
                    ,:MAX-CR-HIST-TRAN-TM                               
                FROM CSS_CREDIT_HIST CK WITH(READUNCOMMITTED)                   
               WHERE CK.CUSTOMER_NO  = :CK-CUSTOMER-NO                  
                 AND CK.REG_GROUP_CD = :CK-REG-GROUP-CD                 
               ORDER BY  CK.CR_HIST_TRAN_DT DESC                        
                        ,CR_HIST_TRAN_TM DESC                        
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CK.CR_HIST_TRAN_DT                                         
MFA-TR*             ,CK.CR_HIST_TRAN_TM                                         
MFA-TR*         INTO :MAX-CR-HIST-TRAN-DT                                       
MFA-TR*             ,:MAX-CR-HIST-TRAN-TM                                       
MFA-TR*         FROM CSS_CREDIT_HIST CK                                         
MFA-TR*        WHERE CK.CUSTOMER_NO  = :CK-CUSTOMER-NO                          
MFA-TR*          AND CK.REG_GROUP_CD = :CK-REG-GROUP-CD                         
MFA-TR*        ORDER BY  CK.CR_HIST_TRAN_DT DESC                                
MFA-TR*                 ,CK.CR_HIST_TRAN_TM DESC                                
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7320                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT ***************'       
P0599A        DISPLAY '* 7320-MAX-DATE-TIME-SCOR               *'       
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* CUSTOMER NO     = 'CK-CUSTOMER-NO              
              DISPLAY '* REG GROUP CD    = 'CK-REG-GROUP-CD             
              DISPLAY '* PROCESSING TERMINATED                 *'       
              DISPLAY '********** PCSKR150 ABORT ***************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  CHECK TO SEE IF THERE IS A VALID ACCOUNT FOR THE CUSTOMER NO  *        
      ******************************************************************        
                                                                        
       7330-VALIDATE-ACCT-TRAN-DT.                                      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y',
              ACCOUNT_NO                                         
                INTO :WS-ACCOUNT-EXISTS                                 
                    ,:1J-ACCOUNT-NO                                     
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE CUSTOMER_NO           = :AT-CUSTOMER-NO            
                 AND CODE_ACCT_STAT        = 'A'                        
                 AND CAST(ACCT_CREATE_DT AS DATE) >= 
              IIF(TRY_CONVERT(DATE, :MAX-CR-HIST-TRAN-DT
              ) IS NULL OR (PATINDEX('%.%', :MAX-CR-HIST-TRAN-DT
              ) <> 0) OR (LEN(:MAX-CR-HIST-TRAN-DT
              ) <> 10), CIS.CHAR2DATE(:MAX-CR-HIST-TRAN-DT
              ), CONVERT(DATE, :MAX-CR-HIST-TRAN-DT) )       
                 AND LOCAL_OFFICE NOT IN ('301','302','303')            
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*         INTO :WS-ACCOUNT-EXISTS                                         
MFA-TR*             ,:1J-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE CUSTOMER_NO           = :AT-CUSTOMER-NO                    
MFA-TR*          AND CODE_ACCT_STAT        = 'A'                                
MFA-TR*          AND DATE(ACCT_CREATE_DT) >= :MAX-CR-HIST-TRAN-DT               
MFA-TR*          AND LOCAL_OFFICE NOT IN ('301','302','303')                    
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7330                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
           OR NOT-FOUND                                                 
           OR -811                                                      
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **************'        
              DISPLAY '*   ERROR ON 7330-VALIDATE-ACCT-TRAN-DT **'      
              DISPLAY '*   RETURN CODE   = ' SQLCODE                    
              DISPLAY '* CUSTOMER NO     = ' AT-CUSTOMER-NO             
              DISPLAY '* MAX HIST TRAN DT= ' MAX-CR-HIST-TRAN-DT        
              DISPLAY '**  COULD NOT GET INFORMATION NEEDED'            
              PERFORM 9900-ABEND                THRU 9900-EXIT          
              DISPLAY '********** PCSKR150 ABORT **************'        
           END-IF.                                                      
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7340-VALIDATE-ACCOUNT                                                   
      ******************************************************************        
       7340-VALIDATE-ACCOUNT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y',
              ACCOUNT_NO                                         
                INTO :WS-ACCOUNT-EXISTS                                 
                    ,:1J-ACCOUNT-NO                                     
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE CUSTOMER_NO       = :AT-CUSTOMER-NO                
                 AND CODE_ACCT_STAT    = 'A'                            
                 AND LOCAL_OFFICE NOT IN ('301','302','303')            
               ORDER BY ACCT_CREATE_DT DESC                             
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*         INTO :WS-ACCOUNT-EXISTS                                         
MFA-TR*             ,:1J-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE CUSTOMER_NO       = :AT-CUSTOMER-NO                        
MFA-TR*          AND CODE_ACCT_STAT    = 'A'                                    
MFA-TR*          AND LOCAL_OFFICE NOT IN ('301','302','303')                    
MFA-TR*        ORDER BY ACCT_CREATE_DT DESC                                     
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7340                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
           OR NOT-FOUND                                                 
           OR -811                                                      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSKR150 ABORT **************'       
P0599A         DISPLAY '**  ERROR ON 7340-VALIDATE-ACCOUNT    **'       
               DISPLAY '**  RETURN CODE    = ' SQLCODE                  
               DISPLAY '**  CUSTOMER NO    = ' AT-CUSTOMER-NO           
               DISPLAY '**  COULD NOT GET INFORMATION NEEDED'           
               PERFORM 9900-ABEND                THRU 9900-EXIT         
               DISPLAY '********** PCSKR150 ABORT **************'       
           END-IF.                                                      
                                                                        
       7340-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7350-GET-CRED-HIST-ADDR                                                 
      ******************************************************************        
                                                                        
       7350-GET-CRED-HIST-ADDR.                                         
                                                                        
           EXEC SQL                                                     
              SELECT LJ.ADDR_CITY                                       
                    ,LJ.ADDR_STATE                                      
                    ,LJ.ADDR_STREET1                                    
                    ,LJ.ADDR_STREET2                                    
                    ,LJ.ADDR_ZIP_CODE                                   
                    ,LJ.ADDR_COUNTRY                                    
                INTO :LJ-ADDR-CITY :WS-ADDR-CITY-NULL               
                    ,:LJ-ADDR-STATE :WS-ADDR-STATE-NULL              
                    ,:LJ-ADDR-STREET1 :WS-ADDR-STREET1-NULL            
                    ,:LJ-ADDR-STREET2 :WS-ADDR-STREET2-NULL            
                    ,:LJ-ADDR-ZIP-CODE :WS-ADDR-ZIP-CODE-NULL           
                    ,:LJ-ADDR-COUNTRY :WS-ADDR-COUNTRY-NULL            
                FROM CSS_CRED_HIST_ADDR LJ WITH(READUNCOMMITTED)                
               WHERE LJ.CUSTOMER_NO     = :CK-CUSTOMER-NO               
                 AND LJ.CR_HIST_TRAN_DT = IIF(TRY_CONVERT(DATE, 
                                                    :CK-CR-HIST-TRAN-DT
              ) IS NULL OR (PATINDEX('%.%', :CK-CR-HIST-TRAN-DT
              ) <> 0) OR (LEN(:CK-CR-HIST-TRAN-DT
              ) <> 10), CIS.CHAR2DATE(:CK-CR-HIST-TRAN-DT
              ), CONVERT(DATE, :CK-CR-HIST-TRAN-DT) )           
                 AND LJ.CR_HIST_TRAN_TM = CIS.CHAR2TIME(
                                                    :CK-CR-HIST-TRAN-TM
              )           
                 AND LJ.ADDR_TYPE_CD    = 'C'                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LJ.ADDR_CITY                                               
MFA-TR*             ,LJ.ADDR_STATE                                              
MFA-TR*             ,LJ.ADDR_STREET1                                            
MFA-TR*             ,LJ.ADDR_STREET2                                            
MFA-TR*             ,LJ.ADDR_ZIP_CODE                                           
MFA-TR*             ,LJ.ADDR_COUNTRY                                            
MFA-TR*         INTO :LJ-ADDR-CITY     :WS-ADDR-CITY-NULL                       
MFA-TR*             ,:LJ-ADDR-STATE    :WS-ADDR-STATE-NULL                      
MFA-TR*             ,:LJ-ADDR-STREET1  :WS-ADDR-STREET1-NULL                    
MFA-TR*             ,:LJ-ADDR-STREET2  :WS-ADDR-STREET2-NULL                    
MFA-TR*             ,:LJ-ADDR-ZIP-CODE :WS-ADDR-ZIP-CODE-NULL                   
MFA-TR*             ,:LJ-ADDR-COUNTRY  :WS-ADDR-COUNTRY-NULL                    
MFA-TR*         FROM CSS_CRED_HIST_ADDR LJ                                      
MFA-TR*        WHERE LJ.CUSTOMER_NO     = :CK-CUSTOMER-NO                       
MFA-TR*          AND LJ.CR_HIST_TRAN_DT = :CK-CR-HIST-TRAN-DT                   
MFA-TR*          AND LJ.CR_HIST_TRAN_TM = :CK-CR-HIST-TRAN-TM                   
MFA-TR*          AND LJ.ADDR_TYPE_CD    = 'C'                                   
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7350                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ADDR-CITY-NULL     < 0                                 
              MOVE SPACES               TO LJ-ADDR-CITY                 
              MOVE ZEROES               TO WS-ADDR-CITY-NULL            
           END-IF                                                       
           IF WS-ADDR-STATE-NULL    < 0                                 
              MOVE SPACES               TO LJ-ADDR-STATE                
              MOVE ZEROES               TO WS-ADDR-STATE-NULL           
           END-IF                                                       
           IF WS-ADDR-STREET1-NULL  < 0                                 
              MOVE SPACES               TO LJ-ADDR-STREET1              
              MOVE ZEROES               TO WS-ADDR-STREET1-NULL         
           END-IF                                                       
           IF WS-ADDR-STREET2-NULL  < 0                                 
              MOVE SPACES               TO LJ-ADDR-STREET2              
              MOVE ZEROES               TO WS-ADDR-STREET2-NULL         
           END-IF                                                       
           IF WS-ADDR-ZIP-CODE-NULL < 0                                 
              MOVE SPACES               TO LJ-ADDR-ZIP-CODE             
              MOVE ZEROES               TO WS-ADDR-ZIP-CODE-NULL        
           END-IF                                                       
           IF WS-ADDR-COUNTRY-NULL  < 0                                 
              MOVE SPACES               TO LJ-ADDR-COUNTRY              
              MOVE ZEROES               TO WS-ADDR-COUNTRY-NULL         
           END-IF                                                       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **************'        
              DISPLAY '**  ERROR ON 7350-GET-CRED-HIST-ADDR  **'        
              DISPLAY '**  RETURN CODE    = ' SQLCODE                   
              DISPLAY '**  CUSTOMER NO    = ' CK-CUSTOMER-NO            
              DISPLAY '**  HIST TRAN DT   = ' CK-CR-HIST-TRAN-DT        
              DISPLAY '**  HIST TRAN TM   = ' CK-CR-HIST-TRAN-TM        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
              DISPLAY '********** PCSKR150 ABORT **************'        
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0599A******************************************************************        
P0599A* 7355-GET-ITPA-MAIL-DET.                                                 
P0599A******************************************************************        
P0599A                                                                  
P0599A 7355-GET-ITPA-MAIL-DET.                                          
P0599A                                                                  
P0599A     EXEC SQL                                                     
P0599A        SELECT LF.LETTER_NOTIFY_CD                                
P0599A              ,LF.LETTER_MAILED_DT                                
P0599A              ,LF.ITPA_RSLT_CURR_CD                               
P0599A          INTO :LF-LETTER-NOTIFY-CD                               
P0599A              ,:LF-LETTER-MAILED-DT :WS-NULL-IND1                  
P0599A              ,:LF-ITPA-RSLT-CURR-CD                              
P0599A          FROM CSS_CRED_ITPA_HIST LF WITH(READUNCOMMITTED)                
P0599A         WHERE LF.CUSTOMER_NO     = :CK-CUSTOMER-NO               
P0599A           AND LF.CR_HIST_TRAN_DT = IIF(TRY_CONVERT(DATE, 
                                                    :CK-CR-HIST-TRAN-DT
              ) IS NULL OR (PATINDEX('%.%', :CK-CR-HIST-TRAN-DT
              ) <> 0) OR (LEN(:CK-CR-HIST-TRAN-DT
              ) <> 10), CIS.CHAR2DATE(:CK-CR-HIST-TRAN-DT
              ), CONVERT(DATE, :CK-CR-HIST-TRAN-DT) )           
P0599A           AND LF.CR_HIST_TRAN_TM = CIS.CHAR2TIME(
                                                    :CK-CR-HIST-TRAN-TM
              )           
P0599A                                                           
P0599A                                                      
P0599A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LF.LETTER_NOTIFY_CD                                        
MFA-TR*             ,LF.LETTER_MAILED_DT                                        
MFA-TR*             ,LF.ITPA_RSLT_CURR_CD                                       
MFA-TR*         INTO :LF-LETTER-NOTIFY-CD                                       
MFA-TR*             ,:LF-LETTER-MAILED-DT:WS-NULL-IND1                          
MFA-TR*             ,:LF-ITPA-RSLT-CURR-CD                                      
MFA-TR*         FROM CSS_CRED_ITPA_HIST LF                                      
MFA-TR*        WHERE LF.CUSTOMER_NO     = :CK-CUSTOMER-NO                       
MFA-TR*          AND LF.CR_HIST_TRAN_DT = :CK-CR-HIST-TRAN-DT                   
MFA-TR*          AND LF.CR_HIST_TRAN_TM = :CK-CR-HIST-TRAN-TM                   
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7355                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0599A                                                                  
P0599A     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0599A                                                                  
P0599A     IF WS-NULL-IND1          < 0                                 
P0599A        MOVE SPACES               TO LF-LETTER-MAILED-DT          
P0599A        MOVE ZEROES               TO WS-NULL-IND1                 
P0599A     END-IF                                                       
P0599A                                                                  
P0599A     IF SQLCODE = SUCCESSFUL-CALL                                 
P0599A        CONTINUE                                                  
P0599A     ELSE                                                         
P0599A        DISPLAY '********** PCSKR150 ABORT **************'        
P0599A        DISPLAY '**  ERROR ON 7355-GET-ITPA-MAIL-DET   **'        
P0599A        DISPLAY '**  RETURN CODE    = ' SQLCODE                   
P0599A        DISPLAY '**  CUSTOMER NO    = ' CK-CUSTOMER-NO            
P0599A        DISPLAY '**  HIST TRAN DT   = ' CK-CR-HIST-TRAN-DT        
P0599A        DISPLAY '**  HIST TRAN TM   = ' CK-CR-HIST-TRAN-TM        
P0599A        PERFORM 9900-ABEND                THRU 9900-EXIT          
P0599A        DISPLAY '********** PCSKR150 ABORT **************'        
P0599A     END-IF.                                                      
P0599A                                                                  
P0599A 7355-EXIT.                                                       
P0599A     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7360-GET-GUARNTR-CUST-NO                                       *        
      ******************************************************************        
       7360-GET-GUARNTR-CUST-NO.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT AT.CUSTOMER_NO                                     
                INTO :WS-CUSTOMER-NO                                    
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO = :1J-GUARNTR-ACCT-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.CUSTOMER_NO                                             
MFA-TR*         INTO :WS-CUSTOMER-NO                                            
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO = :1J-GUARNTR-ACCT-NO                        
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7360                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **************'        
              DISPLAY '* 7360-GET-GUARNTR-CUST-NO             *'        
              DISPLAY '* ACCOUNT NO = '1J-GUARNTR-ACCT-NO               
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSKR150 ABORT **************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT115******************************************************************        
ACT115* 7365-GET-MOST-RECENT-HIST                                      *        
ACT115******************************************************************        
ACT115 7365-GET-MOST-RECENT-HIST.                                       
ACT115*                                                                         
ACT115     EXEC SQL                                                     
ACT115        SELECT TOP(1) CK.ADV_CREDIT_LTR                                  
ACT115          INTO :RECENT-ADV-CREDIT-LTR                             
ACT115          FROM CSS_CREDIT_HIST CK WITH(READUNCOMMITTED)                   
ACT115         WHERE CK.CUSTOMER_NO       = :CK-CUSTOMER-NO             
ACT115           AND CK.CR_CHK_COMPANY_NO = :CK-CR-CHK-COMPANY-NO       
ACT115           AND CK.REG_GROUP_CD      = :CK-REG-GROUP-CD            
ACT115           AND CK.CR_RQST_REASON_CD = :WS-CREATED-RQST-REASON     
ACT115         ORDER BY  CK.CR_HIST_TRAN_DT DESC                        
ACT115                  ,CK.CR_HIST_TRAN_TM DESC                        
ACT115                                              
ACT115                                                           
ACT115                                                      
ACT115     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CK.ADV_CREDIT_LTR                                          
MFA-TR*         INTO :RECENT-ADV-CREDIT-LTR                                     
MFA-TR*         FROM CSS_CREDIT_HIST CK                                         
MFA-TR*        WHERE CK.CUSTOMER_NO       = :CK-CUSTOMER-NO                     
MFA-TR*          AND CK.CR_CHK_COMPANY_NO = :CK-CR-CHK-COMPANY-NO               
MFA-TR*          AND CK.REG_GROUP_CD      = :CK-REG-GROUP-CD                    
MFA-TR*          AND CK.CR_RQST_REASON_CD = :WS-CREATED-RQST-REASON             
MFA-TR*        ORDER BY  CK.CR_HIST_TRAN_DT DESC                                
MFA-TR*                 ,CK.CR_HIST_TRAN_TM DESC                                
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7365                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT115                                                                  
ACT115     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT115     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT115        CONTINUE                                                  
ACT115     ELSE                                                         
ACT115        DISPLAY '********** PCSKR150 ABORT ***************'       
ACT115        DISPLAY '* 7365-GET-CREDIT-HIST-DTLS             *'       
ACT115        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
ACT115        DISPLAY '* CUSTOMER NO     = 'CK-CUSTOMER-NO              
ACT115        DISPLAY '* CR HIST TRAN DT = 'CK-CR-HIST-TRAN-DT          
ACT115        DISPLAY '* CR HIST TRAN TM = 'CK-CR-HIST-TRAN-TM          
ACT115        DISPLAY '* PROCESSING TERMINATED                 *'       
ACT115        DISPLAY '********** PCSKR150 ABORT ***************'       
ACT115        PERFORM 9900-ABEND THRU 9900-EXIT                         
ACT115     END-IF.                                                      
ACT115*                                                                         
ACT115 7365-EXIT.                                                       
ACT115     EXIT.                                                        
      *                                                                         
ACT115******************************************************************        
ACT115* 7370-GET-ITPA-HIST                                                      
ACT115******************************************************************        
ACT115                                                                  
ACT115 7370-GET-ITPA-HIST.                                              
ACT115                                                                  
ACT115     EXEC SQL                                                     
ACT115        SELECT LF.LETTER_NOTIFY_CD                                
ACT115          INTO :RECENT-LETTER-NOTIFY-CD                           
ACT115          FROM CSS_CRED_ITPA_HIST LF WITH(READUNCOMMITTED)                
ACT115         WHERE LF.CUSTOMER_NO     = :CK-CUSTOMER-NO               
ACT115           AND LF.CR_HIST_TRAN_DT = IIF(TRY_CONVERT(DATE, 
                                                    :CK-CR-HIST-TRAN-DT
              ) IS NULL OR (PATINDEX('%.%', :CK-CR-HIST-TRAN-DT
              ) <> 0) OR (LEN(:CK-CR-HIST-TRAN-DT
              ) <> 10), CIS.CHAR2DATE(:CK-CR-HIST-TRAN-DT
              ), CONVERT(DATE, :CK-CR-HIST-TRAN-DT) )           
ACT115           AND LF.CR_HIST_TRAN_TM = CIS.CHAR2TIME(
                                                    :CK-CR-HIST-TRAN-TM
              )           
ACT115                                                           
ACT115                                                      
ACT115     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LF.LETTER_NOTIFY_CD                                        
MFA-TR*         INTO :RECENT-LETTER-NOTIFY-CD                                   
MFA-TR*         FROM CSS_CRED_ITPA_HIST LF                                      
MFA-TR*        WHERE LF.CUSTOMER_NO     = :CK-CUSTOMER-NO                       
MFA-TR*          AND LF.CR_HIST_TRAN_DT = :CK-CR-HIST-TRAN-DT                   
MFA-TR*          AND LF.CR_HIST_TRAN_TM = :CK-CR-HIST-TRAN-TM                   
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7370                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT115                                                                  
ACT115     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT115                                                                  
ACT115     IF SQLCODE = SUCCESSFUL-CALL                                 
ACT115        CONTINUE                                                  
ACT115     ELSE                                                         
ACT115        DISPLAY '********** PCSKR150 ABORT **************'        
ACT115        DISPLAY '**  ERROR ON 7370-GET-ITPA-HIST       **'        
ACT115        DISPLAY '**  RETURN CODE    = ' SQLCODE                   
ACT115        DISPLAY '**  CUSTOMER NO    = ' CK-CUSTOMER-NO            
ACT115        DISPLAY '**  HIST TRAN DT   = ' CK-CR-HIST-TRAN-DT        
ACT115        DISPLAY '**  HIST TRAN TM   = ' CK-CR-HIST-TRAN-TM        
ACT115        PERFORM 9900-ABEND                THRU 9900-EXIT          
ACT115        DISPLAY '********** PCSKR150 ABORT **************'        
ACT115     END-IF.                                                      
ACT115                                                                  
ACT115 7370-EXIT.                                                       
ACT115     EXIT.                                                        
      ******************************************************************        
      * 7380-GET-GUARNTR-DTLS                                          *        
      ******************************************************************        
       7380-GET-GUARNTR-DTLS.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT CE.CODE_STATE_ID,                                  
                     CE.DRIVERS_LICENSE_NO,                             
                     CIS.SUBSTR3(CE.SSN,6,4)                                 
                INTO :CE-CODE-STATE-ID,                                 
                     :CE-DRIVERS-LICENSE-NO,                            
                     :WS-LAST-4-SSN-NO                                  
                FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED)                    
               WHERE CE.CUSTOMER_NO = :CE-CUSTOMER-NO                   
               AND CE.CUSTOMER_TYPE = 'C'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CE.CODE_STATE_ID,                                          
MFA-TR*              CE.DRIVERS_LICENSE_NO,                                     
MFA-TR*              SUBSTR(CE.SSN,6,4)                                         
MFA-TR*         INTO :CE-CODE-STATE-ID,                                         
MFA-TR*              :CE-DRIVERS-LICENSE-NO,                                    
MFA-TR*              :WS-LAST-4-SSN-NO                                          
MFA-TR*         FROM CSS_CUST_STATS CE                                          
MFA-TR*        WHERE CE.CUSTOMER_NO = :CE-CUSTOMER-NO                           
MFA-TR*        AND CE.CUSTOMER_TYPE = 'C'                                       
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7380                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **************'        
              DISPLAY '* 7380-GET-GUARNTR-DTLS                *'        
              DISPLAY '* CUSTOMER NO = 'CE-CUSTOMER-NO                  
              DISPLAY '* SQLCODE IS  ', WS-ACTIVE-RETURN-CODE           
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSKR150 ABORT **************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7380-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7400-SELECT-CIG-ACCT                                          *         
      ******************************************************************        
       7400-SELECT-CIG-ACCT.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-EXT-INDUS-GAS-FLAG                            
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                     
                      CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                  AND AT.ACCOUNT_NO = UT.ACCOUNT_NO                     
                  AND UT.CODE_UTIL_TYPE = 'G'                           
                  AND UT.RATE_PLAN_NO IN (                              
                         SELECT RC.RATE_PLAN_NO                         
                           FROM CSS_RATE_COMP_DEF RC
                           WITH(READUNCOMMITTED)                    
                          WHERE RC.CODE_UTIL_TYPE = 'G'                 
                            AND RC.REG_TYPE_CD = 'D')                   
ACT039                                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-EXT-INDUS-GAS-FLAG                                    
MFA-TR*          FROM CSS_ACCOUNT AT,                                           
MFA-TR*               CSS_UTIL_ENVRNMT UT                                       
MFA-TR*         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           AND AT.ACCOUNT_NO = UT.ACCOUNT_NO                             
MFA-TR*           AND UT.CODE_UTIL_TYPE = 'G'                                   
MFA-TR*           AND UT.RATE_PLAN_NO IN (                                      
MFA-TR*                  SELECT RC.RATE_PLAN_NO                                 
MFA-TR*                    FROM CSS_RATE_COMP_DEF RC                            
MFA-TR*                   WHERE RC.CODE_UTIL_TYPE = 'G'                         
MFA-TR*                     AND RC.REG_TYPE_CD = 'D')                           
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **************'        
              DISPLAY '* 7400-SELECT-CIG-ACCT                *'         
              DISPLAY '* ACCOUNT NO = 'AT-ACCOUNT-NO                    
              DISPLAY '* SQLCODE IS  ', WS-ACTIVE-RETURN-CODE           
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSKR150 ABORT **************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 07598500
      *    7420-OPEN-PHONE-CURSOR                                     * 07598700
      *   OPEN PHONE CURSOR                                           * 07598800
      ***************************************************************** 07599000
      *                                                                 07599100
       7420-OPEN-PHONE-CURSOR.                                          
      *                                                                 07620000
      *                                                                 07622000
           EXEC SQL                                                     
              OPEN PHONE_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07660000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 07680000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT ***************'       
              DISPLAY '* 7420-OPEN-PHONE-CURSOR                *'       
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* CUSTOMER NO     = 'CB-CUSTOMER-NO              
              DISPLAY '* PROCESSING TERMINATED                 *'       
              DISPLAY '********** PCSKR150 ABORT ***************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 07790000
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07820000
      ***************************************************************** 07821000
      *     7440-FETCH-PHONE-CURSOR                                   * 07823000
      ***************************************************************** 07825000
      *                                                                 07826000
       7440-FETCH-PHONE-CURSOR.                                         
      *                                                                 07880000
           EXEC SQL                                                     
              FETCH PHONE_CURSOR                                        
               INTO :CB-PHONE-NO                                        
                   ,:CB-PHONE-TYPE                                      
                   ,:CB-EXTENSION-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08110000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 08130000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              EVALUATE CB-PHONE-TYPE                                    
                 WHEN 'H1'                                              
                   IF CB-PHONE-NO > SPACES                              
                      MOVE CB-PHONE-NO(1:3)  TO WS-HOME-PHONE-1         
                      MOVE CB-PHONE-NO(4:3)  TO WS-HOME-PHONE-2         
                      MOVE CB-PHONE-NO(7:4)  TO WS-HOME-PHONE-3         
                      MOVE CB-EXTENSION-NO   TO WS-HOME-PHONE-EXT       
                   END-IF                                               
                 WHEN 'W1'                                              
                   IF CB-PHONE-NO > SPACES                              
                      MOVE CB-PHONE-NO(1:3)  TO WS-WORK-PHONE-1         
                      MOVE CB-PHONE-NO(4:3)  TO WS-WORK-PHONE-2         
                      MOVE CB-PHONE-NO(7:4)  TO WS-WORK-PHONE-3         
                      MOVE CB-EXTENSION-NO   TO WS-WORK-PHONE-EXT       
                   END-IF                                               
              END-EVALUATE                                              
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 NEXT SENTENCE                                          
              ELSE                                                      
                 DISPLAY '********** PCSKR150 ABORT ***************'    
                 DISPLAY '* 7440-FETCH-PHONE-CURSOR               *'    
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* CUSTOMER NO     = 'CB-CUSTOMER-NO           
                 DISPLAY '* PROCESSING TERMINATED                 *'    
                 DISPLAY '********** PCSKR150 ABORT ***************'    
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
             END-IF                                                     
           END-IF.                                                      
      *                                                                 08280000
       7440-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08310000
      ***************************************************************** 08311000
      *     7460-CLOSE-PHONE-CURSOR                                   * 08313000
      *   CLOSE PHONE CURSOR                                          * 08313100
      ***************************************************************** 08315000
      *                                                                 08316000
       7460-CLOSE-PHONE-CURSOR.                                         
      *                                                                 08370000
      *                                                                 08372000
           EXEC SQL                                                     
              CLOSE PHONE_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08410000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 08430000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT ***************'       
              DISPLAY '*  7460-CLOSE-PHONE-CURSOR              *'       
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* CUSTOMER NO     = 'CB-CUSTOMER-NO              
              DISPLAY '* PROCESSING TERMINATED                 *'       
              DISPLAY '********** PCSKR150 ABORT ***************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 08540000
       7460-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * CPD00038                                                       *        
      * 7600-START-FCSJC01                                             *        
      * 7610-READ-FCSJC01                                              *        
      * 7611-CLOSE                                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ******************************************************************        
      *      READS FCSKR150 FILE FOR RESTARTS                          *        
      ******************************************************************        
       7750-READ-RESTART-FILE.                                          
                                                                        
           READ FCSKR50R-FILE AT END                                    
               MOVE 'Y' TO WS-END-OF-FILE-SW                            
               GO TO 7750-EXIT.                                         
                                                                        
           IF FCSKR50R-SUCCESSFUL                                       
              ADD 1                             TO WS-FCSKR50R-CNTR     
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **************'        
              DISPLAY '*     READ ERROR : KR10R FILE          *'        
              DISPLAY '* CURRENT PARA   : 7750                *'        
              DISPLAY '* FILE-STATUS    : ' WS-FCSKR50R-STATUS          
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSKR150 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7500-OPEN-CORRESP-HDR                                          *        
      ******************************************************************        
                                                                        
       7500-OPEN-CORRESP-HDR.                                           
                                                                        
           EXEC SQL                                                     
              OPEN CORRESP_HDR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
              DISPLAY '* ABEND IN 7500-OPEN-CORRESP-HDR               *'
              DISPLAY '* CORRESP_HDR CSR ERROR                        *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7510-FETCH-CORRESP-HDR                                         *        
      ******************************************************************        
       7510-FETCH-CORRESP-HDR.                                          
                                                                        
           EXEC SQL                                                     
              FETCH CORRESP_HDR                                         
               INTO :1J-CORRESP-ID                                      
                   ,:1J-ACCOUNT-NO :WS-CORRESP-ACCOUNT-NULL     
                   ,:1J-CUSTOMER-NO                                     
                   ,:1J-CORRESP-MSG-ID                                  
                   ,:1J-CORRESP-CREATE-TS                               
                   ,:1J-CORRESP-COMPANY-NO                              
                   ,:1J-CORRESP-STMT-DT :WS-CORRESP-STMT-DT-NULL     
                   ,:1J-GUARNTR-ACCT-NO                                 
                   ,:1J-CORRESP-STATUS-CD                               
                   ,:1J-CORRESP-TYPE-CD                                 
                   ,:1J-REG-GROUP-CD                                    
                   ,:1J-SENIOR-FL                                       
                   ,:1J-BARCODE-UNIQUE-ID                               
                   ,:1J-CREATED-BY-PGM-ID                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-DISPLAY-SQLCODE.        
                                                                        
           IF WS-CORRESP-ACCOUNT-NULL < 0                               
              MOVE ZEROES                 TO 1J-ACCOUNT-NO              
                                             WS-CORRESP-ACCOUNT-NULL    
           END-IF                                                       
      *                                                                         
           IF WS-CORRESP-STMT-DT-NULL < 0                               
              MOVE ZEROES                 TO WS-CORRESP-STMT-DT-NULL    
              MOVE SPACES                 TO 1J-CORRESP-STMT-DT         
           END-IF                                                       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
              DISPLAY '* ABEND IN 7510-FETCH-CORRESP-HDR              *'
              DISPLAY '* CORRESP_HDR CSR ERROR                        *'
              DISPLAY '* SQL RETURN CODE   = 'WS-DISPLAY-SQLCODE        
              DISPLAY '* CORRESP STATUS CD = 'WS-PROCESS-MSG-STATUS     
              DISPLAY '* NEXT BUSINESS DAY = 'WS-RUN-DATE               
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7520-CLOSE-CORRESP-HDR                                         *        
      ******************************************************************        
                                                                        
       7520-CLOSE-CORRESP-HDR.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE CORRESP_HDR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-DISPLAY-SQLCODE.          
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
              DISPLAY '* ABEND IN 7500-CLODE-CORRESP-HDR              *'
              DISPLAY '* CORRESP_HDR CSR ERROR                        *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7530-OPEN-CORRESP-HDR-MSGID                                    *        
      ******************************************************************        
                                                                        
       7530-OPEN-CORRESP-HDR-MSGID.                                     
                                                                        
           EXEC SQL                                                     
              OPEN CORRESP_HDR_MSGID                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
P0599A        DISPLAY '* ABEND IN 7530-OPEN-CORRESP-HDR-MSGID         *'
              DISPLAY '* CORRESP_HDR_MSGID CSR ERROR                  *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7540-FETCH-CORRESP-HDR-MSGID                                   *        
      ******************************************************************        
                                                                        
       7540-FETCH-CORRESP-HDR-MSGID.                                    
                                                                        
           EXEC SQL                                                     
              FETCH CORRESP_HDR_MSGID                                   
               INTO :1J-CORRESP-ID                                      
                   ,:1J-ACCOUNT-NO :WS-CORRESP-ACCOUNT-NULL     
                   ,:1J-CUSTOMER-NO                                     
                   ,:1J-CORRESP-MSG-ID                                  
                   ,:1J-CORRESP-CREATE-TS                               
                   ,:1J-CORRESP-COMPANY-NO                              
                   ,:1J-CORRESP-STMT-DT :WS-CORRESP-STMT-DT-NULL     
                   ,:1J-GUARNTR-ACCT-NO                                 
                   ,:1J-CORRESP-STATUS-CD                               
                   ,:1J-CORRESP-TYPE-CD                                 
                   ,:1J-REG-GROUP-CD                                    
                   ,:1J-SENIOR-FL                                       
                   ,:1J-BARCODE-UNIQUE-ID                               
ACT115             ,:1J-CREATED-BY-PGM-ID                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-DISPLAY-SQLCODE.          
                                                                        
           IF WS-CORRESP-ACCOUNT-NULL < 0                               
              MOVE ZEROES                 TO 1J-ACCOUNT-NO              
                                             WS-CORRESP-ACCOUNT-NULL    
           END-IF                                                       
      *                                                                         
           IF WS-CORRESP-STMT-DT-NULL < 0                               
              MOVE ZEROES                 TO WS-CORRESP-STMT-DT-NULL    
              MOVE SPACES                 TO 1J-CORRESP-STMT-DT         
           END-IF                                                       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
              DISPLAY '* ABEND IN 7540-FETCH-CORRESP-HDR-MSGID        *'
              DISPLAY '* CORRESP_HDR_MSGID CSR ERROR                  *'
              DISPLAY '* SQL RETURN CODE   = 'WS-DISPLAY-SQLCODE        
              DISPLAY '* CORRESP MSG ID    = 'PARM-MSG-NO               
              DISPLAY '* NEXT BUSINESS DAY = 'WS-RUN-DATE               
              DISPLAY '* PROCESSING TERMINATED             *'           
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
                                                                        
       7540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7550-CLOSE-CORRESP-HDR-MSGID                                   *        
      ******************************************************************        
                                                                        
       7550-CLOSE-CORRESP-HDR-MSGID.                                    
                                                                        
           EXEC SQL                                                     
              CLOSE CORRESP_HDR_MSGID                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-DISPLAY-SQLCODE.          
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
              DISPLAY '* ABEND IN 7550-CLOSE-CORRESP-HDR-MSGID        *'
              DISPLAY '* CORRESP_HDR_MSGID CSR ERROR                  *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7560-OPEN-CORRESP-VAR                                          *        
      ******************************************************************        
                                                                        
       7560-OPEN-CORRESP-VAR.                                           
                                                                        
           EXEC SQL                                                     
              OPEN CORRESP_VAR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
              DISPLAY '* ABEND IN 7560-OPEN-CORRESP-VAR               *'
              DISPLAY '* CORRESP_VAR_NOTICE CURSOR ERROR              *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7560-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7570-FETCH-CORRESP-VAR                                         *        
      ******************************************************************        
                                                                        
       7570-FETCH-CORRESP-VAR.                                          
                                                                        
           EXEC SQL                                                     
              FETCH CORRESP_VAR                                         
               INTO :1K-CORRESP-VAR-NM                                  
                   ,:1K-CORRESP-VAR-DATA                                
                   ,:1K-CORRESP-VAR-NUM                                 
                   ,:1K-CORRESP-VAR-CHAR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-DISPLAY-SQLCODE.        
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
              DISPLAY '* ABEND IN 7570-FETCH-CORRESP-VAR              *'
              DISPLAY '* CORRESP_VAR_NOTICE CURSOR ERROR              *'
P0599A        DISPLAY '* CORRESP ID        = 'WS-CORRESP-ID             
              DISPLAY '* SQL RETURN CODE   = 'WS-DISPLAY-SQLCODE        
              DISPLAY '* PROCESSING TERMINATED             *'           
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
                                                                        
       7570-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7580-CLOSE-CORRESP-VAR                                         *        
      ******************************************************************        
                                                                        
       7580-CLOSE-CORRESP-VAR.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE CORRESP_VAR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-DISPLAY-SQLCODE.          
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
              DISPLAY '* ABEND IN 7580-CLOSE-CORRESP-VAR              *'
              DISPLAY '* CORRESP_VAR_NOTICE CURSOR ERROR              *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7580-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7630-OPEN-CORRESP-COMM                                         *        
      ******************************************************************        
                                                                        
       7630-OPEN-CORRESP-COMM.                                          
                                                                        
           EXEC SQL                                                     
              OPEN CORRESP_COMM                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
              DISPLAY '* ABEND IN 7630-OPEN-CORRESP-COMM              *'
              DISPLAY '* CORRESP_COMM CSR ERROR                       *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7630-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7640-FETCH-CORRESP-COMM                                        *        
      ******************************************************************        
                                                                        
       7640-FETCH-CORRESP-COMM.                                         
                                                                        
           EXEC SQL                                                     
              FETCH CORRESP_COMM                                        
               INTO :1L-COMM-TYPE-CODE                                  
                   ,:1L-COMM-SUBTYPE-CODE                               
                   ,:1L-CORRESP-MSG-ID                                  
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-DISPLAY-SQLCODE.          
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
              DISPLAY '* ABEND IN 7640-FETCH-CORRESP-COMM             *'
              DISPLAY '* CORRESP_COMM CSR ERROR                       *'
              DISPLAY '* SQL RETURN CODE   = 'WS-DISPLAY-SQLCODE        
              DISPLAY '* PROCESSING TERMINATED             *'           
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
                                                                        
       7640-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7650-CLOSE-CORRESP-COMM                                        *        
      ******************************************************************        
                                                                        
       7650-CLOSE-CORRESP-COMM.                                         
                                                                        
           EXEC SQL                                                     
              CLOSE CORRESP_COMM                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-DISPLAY-SQLCODE.          
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
              DISPLAY '* ABEND IN 7650-CLOSE-CORRESP-COMM             *'
              DISPLAY '* CORRESP_COMM CSR ERROR                       *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7660-OPEN-CORRESP-CONTCT                                       *        
      ******************************************************************        
                                                                        
       7660-OPEN-CORRESP-CONTCT.                                        
                                                                        
           EXEC SQL                                                     
              OPEN CORRESP_CONTCT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
              DISPLAY '* ABEND IN 7660-OPEN-CORRESP-CONTCT            *'
              DISPLAY '* CORRESP_COMM CSR ERROR                       *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7660-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7670-FETCH-CORRESP-CONTCT                                      *        
      ******************************************************************        
                                                                        
       7670-FETCH-CORRESP-CONTCT.                                       
                                                                        
           EXEC SQL                                                     
              FETCH CORRESP_CONTCT                                      
               INTO :HO-CORRESP-MESSAGE-NO                              
                   ,:HO-COMPANY-NO                                      
                   ,:HO-CONTCT-ADDR-STREET                              
                   ,:HO-CONTCT-ADDR-OVFL                                
                   ,:HO-CONTCT-CITY-STATE                               
                   ,:HO-CONTCT-ZIP-CODE                                 
                   ,:HO-CONTCT-PHONE-NO                                 
                   ,:HO-SPCL-PHONE-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-DISPLAY-SQLCODE.          
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
              DISPLAY '* ABEND IN 7670-FETCH-CORRESP-CONTCT           *'
              DISPLAY '* CORRESP_CONTCT CSR ERROR                     *'
              DISPLAY '* SQL RETURN CODE   = 'WS-DISPLAY-SQLCODE        
              DISPLAY '* PROCESSING TERMINATED             *'           
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
                                                                        
       7670-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7680-CLOSE-CORRESP-CONTCT                                      *        
      ******************************************************************        
                                                                        
       7680-CLOSE-CORRESP-CONTCT.                                       
                                                                        
           EXEC SQL                                                     
              CLOSE CORRESP_CONTCT                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-DISPLAY-SQLCODE.          
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
              DISPLAY '* ABEND IN 7680-CLOSE-CORRESP-CONTCT           *'
              DISPLAY '* CORRESP_COMM CSR ERROR                       *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7680-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7690-OPEN-CRED-CODE-DESC                                       *        
      ******************************************************************        
                                                                        
       7690-OPEN-CRED-CODE-DESC.                                        
                                                                        
           EXEC SQL                                                     
              OPEN CRED_CODE_DESC                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
              DISPLAY '* ABEND IN 7690-OPEN-CRED-CODE-DESC            *'
              DISPLAY '* CRED_CODE_DESC CSRN ERROR                    *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7690-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7700-FETCH-CRED-CODE-DESC                                      *        
      ******************************************************************        
                                                                        
       7700-FETCH-CRED-CODE-DESC.                                       
                                                                        
           EXEC SQL                                                     
              FETCH CRED_CODE_DESC                                      
P0599A         INTO :KL-CRED-CD                                         
P0599A             ,:KL-CRED-CD-DESC                                    
                   ,:KL-COMPANY-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-DISPLAY-SQLCODE.          
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
              DISPLAY '* ABEND IN 7700-FETCH-CRED-CODE-DESC           *'
              DISPLAY '* CRED_CODE_DESC CSR ERROR                     *'
              DISPLAY '* SQL RETURN CODE   = 'WS-DISPLAY-SQLCODE        
              DISPLAY '* PROCESSING TERMINATED             *'           
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7710-CLOSE-CRED-CODE-DESC                                      *        
      ******************************************************************        
                                                                        
       7710-CLOSE-CRED-CODE-DESC.                                       
                                                                        
           EXEC SQL                                                     
              CLOSE CRED_CODE_DESC                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-DISPLAY-SQLCODE.          
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
              DISPLAY '* ABEND IN 7710-CLOSE-CRED-CODE-DESC           *'
              DISPLAY '* CRED_CODE_DESC CSR ERROR                     *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7720-OPEN-CORRESP-STATUS-CD                                    *        
      ******************************************************************        
                                                                        
       7720-OPEN-CORRESP-STATUS-CD.                                     
                                                                        
           EXEC SQL                                                     
              OPEN CORRESP_STATUS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
              DISPLAY '* ABEND IN 7720-OPEN-CORRESP-STATUS-CD         *'
              DISPLAY '* CORRESP_STATUS    CSR ERROR                  *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7720-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7730-FETCH-CORRESP-STATUS-CD                                   *        
      ******************************************************************        
                                                                        
       7730-FETCH-CORRESP-STATUS-CD.                                    
                                                                        
           EXEC SQL                                                     
              FETCH CORRESP_STATUS                                      
               INTO :1J-CORRESP-ID                                      
                   ,:1J-ACCOUNT-NO :WS-CORRESP-ACCOUNT-NULL      
                   ,:1J-CUSTOMER-NO                                     
                   ,:1J-CORRESP-MSG-ID                                  
                   ,:1J-CORRESP-CREATE-TS                               
                   ,:1J-CORRESP-COMPANY-NO                              
                   ,:1J-CORRESP-STMT-DT :WS-CORRESP-STMT-DT-NULL      
                   ,:1J-GUARNTR-ACCT-NO                                 
                   ,:1J-CORRESP-STATUS-CD                               
                   ,:1J-CORRESP-TYPE-CD                                 
                   ,:1J-REG-GROUP-CD                                    
                   ,:1J-SENIOR-FL                                       
                   ,:1J-BARCODE-UNIQUE-ID                               
ACT115             ,:1J-CREATED-BY-PGM-ID                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-DISPLAY-SQLCODE.          
                                                                        
           IF WS-CORRESP-ACCOUNT-NULL < 0                               
              MOVE ZEROES                 TO 1J-ACCOUNT-NO              
                                             WS-CORRESP-ACCOUNT-NULL    
           END-IF                                                       
      *                                                                         
           IF WS-CORRESP-STMT-DT-NULL < 0                               
              MOVE ZEROES                 TO WS-CORRESP-STMT-DT-NULL    
              MOVE SPACES                 TO 1J-CORRESP-STMT-DT         
           END-IF                                                       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
              DISPLAY '* ABEND IN 7730-FETCH-CORRESP-STATUS-CD        *'
              DISPLAY '* CORRESP_STATUS    CSR ERROR                  *'
              DISPLAY '* SQL RETURN CODE   = 'WS-DISPLAY-SQLCODE        
              DISPLAY '* NEXT BUSINESS DAY = 'WS-RUN-DATE               
              DISPLAY '* PROCESSING TERMINATED             *'           
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
                                                                        
       7730-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7740-CLOSE-CORRESP-STATUS-CD                                   *        
      ******************************************************************        
                                                                        
       7740-CLOSE-CORRESP-STATUS-CD.                                    
                                                                        
           EXEC SQL                                                     
              CLOSE CORRESP_STATUS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-DISPLAY-SQLCODE.          
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **********************'
P0599A        DISPLAY '* ABEND IN 7740-CLOSE-CORRESP-STATUS-CD        *'
              DISPLAY '* CORRESP_STATUS    CSR ERROR                  *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR150 ABORT **********************'
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7740-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00599****************************************************************          
P00599**  7800-GET-ACCT-MKT-TIER.                                   **          
P00599**      SELECT THE ACCOUNT MARKET TIER                        **          
P00599****************************************************************          
P00599*                                                                         
P00599 7800-GET-ACCT-MKT-TIER.                                          
P00599*                                                                         
P00599     EXEC SQL                                                     
P00599        SELECT TOP(1) TIER_ACCT_TYPE_CD                                  
P00599          INTO :WS-EXT-TIER-ACCT-TYPE                             
P00599          FROM CSS_ACCT_MKT_TIER WITH(READUNCOMMITTED)                    
P00599         WHERE ACCOUNT_NO   = :DD-ACCOUNT-NO                      
P00599          ORDER BY EFF_START_DT DESC                              
P00599                                           
P00599                                                           
P00599                                                      
P00599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TIER_ACCT_TYPE_CD                                          
MFA-TR*         INTO :WS-EXT-TIER-ACCT-TYPE                                     
MFA-TR*         FROM CSS_ACCT_MKT_TIER                                          
MFA-TR*        WHERE ACCOUNT_NO   = :DD-ACCOUNT-NO                              
MFA-TR*         ORDER BY EFF_START_DT DESC                                      
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7800                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599                                                                  
P00599     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00599                                                                  
P00599     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00599        CONTINUE                                                  
P00599     ELSE                                                         
P00599        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
P00599        DISPLAY '********** PCSKR150 ABORT **********************'
P00599        DISPLAY '* ABEND IN 7800-GET-ACCT-MKT-TIER              *'
P00599        DISPLAY '* CORRESP_STATUS    CSR ERROR                  *'
P00599        DISPLAY '* ACCOUNT_NO = '  DD-ACCOUNT-NO                  
P00599        DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
P00599        DISPLAY '* PROCESSING TERMINATED                        *'
P00599        DISPLAY '********** PCSKR150 ABORT **********************'
P00599        PERFORM 9900-ABEND  THRU 9900-EXIT                        
P00599     END-IF.                                                      
P00599*                                                                         
P00599 7800-EXIT.                                                       
P00599     EXIT.                                                        
      *                                                                         
P0599A****************************************************************          
P0599A* 7850-SELECT-BILL-OPTION                                      *          
P0599A****************************************************************          
P0599A                                                                  
P0599A 7850-SELECT-BILL-OPTION.                                         
P0599A                                                                  
P0599A     MOVE SPACES                TO WS-BILL-OPTION-CD.             
P0599A                                                                  
P0599A     EXEC SQL                                                     
P0599A         SELECT DEP_BILL_OPTION_CD                                
P0599A         INTO   :WS-BILL-OPTION-CD                                
P0599A           FROM CSS_DEP_REQ WITH(READUNCOMMITTED)                         
P0599A          WHERE ACCOUNT_NO = :DO-ACCOUNT-NO AND                   
P0599A                PYMT_PRIORITY_LVL = 80      AND                   
P0599A                DEP_ITEM_ID = :DO-DEPOSIT-CERT-NO                 
P0599A                                                           
P0599A                                                      
P0599A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DEP_BILL_OPTION_CD                                        
MFA-TR*        INTO   :WS-BILL-OPTION-CD                                        
MFA-TR*          FROM CSS_DEP_REQ                                               
MFA-TR*         WHERE ACCOUNT_NO = :DO-ACCOUNT-NO AND                           
MFA-TR*               PYMT_PRIORITY_LVL = 80      AND                           
MFA-TR*               DEP_ITEM_ID = :DO-DEPOSIT-CERT-NO                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7850                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0599A                                                                  
P0599A     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
P0599A                                                                  
P0599A     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P0599A        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
P0599A           MOVE 'N'               TO WS-BILL-OPTION-CD            
P0599A        END-IF                                                    
P0599A     ELSE                                                         
P0599A        DISPLAY '********** PCSKR150 ABORT **********************'
P0599A        DISPLAY '* ABEND IN 7800-GET-ACCT-MKT-TIER              *'
P0599A        DISPLAY '* CORRESP_STATUS    CSR ERROR                  *'
P0599A        DISPLAY '* ACCOUNT_NO = '  DO-ACCOUNT-NO                  
P0599A        DISPLAY '* DEPOSIT CER # ' DO-DEPOSIT-CERT-NO             
P0599A        DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
P0599A        DISPLAY '* PROCESSING TERMINATED                        *'
P0599A        DISPLAY '********** PCSKR150 ABORT **********************'
P0599A        PERFORM 9900-ABEND        THRU 9900-EXIT                  
P0599A     END-IF.                                                      
P0599A                                                                  
P0599A 7850-EXIT.                                                       
P0599A     EXIT.                                                        
                                                                        
P0599A******************************************************************        
P0599A*                                                                *        
P0599A*   8400-INSERT-CUST-COMM-DATA.                                  *        
P0599A******************************************************************        
P0599A 8400-INSERT-CUST-COMM-DATA.                                      
P0599A                                                                  
P0599A     MOVE 1J-ACCOUNT-NO          TO KO-ACCOUNT-NO.                
P0599A     MOVE WS-CORRESP-COMPANY-NO  TO KO-COMPANY-NO.                
P0599A     MOVE 'N'                    TO KO-RED-FLAG-IND.              
P0599A     MOVE SPACES                 TO KO-RED-FLAG-EXPIRE-DT.        
P0599A     MOVE -1                     TO WS-RED-FL-NULL-IND.           
P0599A     MOVE 'L'                    TO KO-COMM-METHOD.               
P0599A     MOVE 'O'                    TO KO-COMM-DIRECTION.            
P0599A     MOVE WS-EXT-COMM-TYPE-CD    TO KO-COMM-TYPE-CD.              
P0599A     MOVE WS-EXT-COMM-SUBTYPE-CD TO KO-COMM-SUBTYPE-CODE.         
P0599A     MOVE 'SYSTEM'               TO KO-USER-ID-ORIG.              
P0599A     MOVE 1J-CORRESP-MSG-ID      TO KO-PROMOTION-ID.              
P0599A     MOVE SPACES                 TO KO-PSC-COMPLIANCE-IND.        
P0599A     MOVE 0                      TO KO-CALL-ORIGIN-ID.            
P0599A     MOVE SPACES                 TO KO-CALL-END-TIME.             
P0599A     MOVE -1                     TO WS-END-NULL-IND.              
P0599A     MOVE 0                      TO KO-NUMBER-TRANSFERS.          
P0599A     MOVE 0                      TO KO-HOLD-TIME.                 
P0599A     MOVE 0                      TO KO-QUEUE-TIME.                
P0599A     MOVE 'N'                    TO KO-SCREEN-POP-IND.            
P0599A     MOVE 0                      TO KO-TOTAL-CALL-TIME.           
P0599A     MOVE SPACES                 TO KO-RESPONSE-REASON-CD.        
P0599A     MOVE SPACES                 TO KO-RESPONSE-TYPE-CD.          
P0599A     MOVE SPACES                 TO KO-SOLICITATION-CD.           
P0599A     MOVE 'A'                    TO KO-COMM-ASSOC-CD.             
P0599A     MOVE 'N'                    TO KO-COMPLAINT-FL.              
P0599A     MOVE SPACES                 TO KO-DISCOVERY-MTHD-CD.         
P0599A     MOVE SPACES                 TO KO-PREV-MARKETER-CD.          
P0599A     MOVE WS-INITIAL-COMMENT-TX  TO KO-INITIAL-COMMENT-TX.        
P0599A*                                                                         
P0599A     MOVE 1J-CUSTOMER-NO         TO KO-CUSTOMER-NO.               
P0599A     MOVE ZEROS                  TO KO-PREMISE-NO.                
P0599A     MOVE 'SYSTEM'               TO KO-USER-ID-ORIG.              
P0599A                                                                  
P0599A     EXEC SQL                                                     
P0599A          INSERT INTO CSS_COMM_DATA                               
P0599A                  (COMMUNICATION_ID,                              
P0599A                   ACCOUNT_NO,                                    
P0599A                   CUSTOMER_NO,                                   
P0599A                   PREMISE_NO,                                    
P0599A                   COMPANY_NO,                                    
P0599A                   RED_FLAG_IND,                                  
P0599A                   RED_FLAG_EXPIRE_DT,                            
P0599A                   COMM_METHOD,                                   
P0599A                   COMM_DIRECTION,                                
P0599A                   COMM_TYPE_CD,                                  
P0599A                   COMM_SUBTYPE_CODE,                             
P0599A                   USER_ID_ORIG,                                  
P0599A                   CONTACT_NAME,                                  
P0599A                   PROMOTION_ID,                                  
P0599A                   PSC_COMPLIANCE_IND,                            
P0599A                   CALL_ORIGIN_ID,                                
P0599A                   CALL_END_TIME,                                 
P0599A                   NUMBER_TRANSFERS,                              
P0599A                   HOLD_TIME,                                     
P0599A                   QUEUE_TIME,                                    
P0599A                   SCREEN_POP_IND,                                
P0599A                   TOTAL_CALL_TIME,                               
P0599A                   INITIAL_COMMENT_TX,                            
P0599A                   RESPONSE_REASON_CD,                            
P0599A                   RESPONSE_TYPE_CD,                              
P0599A                   SOLICITATION_CD,                               
P0599A                   COMM_ASSOC_CD,                                 
P0599A                   COMPLAINT_FL,                                  
P0599A                   DISCOVERY_MTHD_CD,                             
P0599A                   PREV_MARKETER_CD)                              
P0599A          VALUES   (CIS.CURRENT$TIMESTAMP(),                            
P0599A                   :KO-ACCOUNT-NO,                                
P0599A                   :KO-CUSTOMER-NO,                               
P0599A                   :KO-PREMISE-NO,                                
P0599A                   :KO-COMPANY-NO,                                
P0599A                   :KO-RED-FLAG-IND,                              
P0599A                   CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                            :WS-RED-FL-NULL-IND),     
P0599A                   :KO-COMM-METHOD,                               
P0599A                   :KO-COMM-DIRECTION,                            
P0599A                   :KO-COMM-TYPE-CD,                              
P0599A                   :KO-COMM-SUBTYPE-CODE,                         
P0599A                   :KO-USER-ID-ORIG,                              
P0599A                   :KO-CONTACT-NAME,                              
P0599A                   :KO-PROMOTION-ID,                              
P0599A                   :KO-PSC-COMPLIANCE-IND,                        
P0599A                   :KO-CALL-ORIGIN-ID,                            
P0599A                   CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                            :WS-END-NULL-IND),             
P0599A                   :KO-NUMBER-TRANSFERS,                          
P0599A                   :KO-HOLD-TIME,                                 
P0599A                   :KO-QUEUE-TIME,                                
P0599A                   :KO-SCREEN-POP-IND,                            
P0599A                   :KO-TOTAL-CALL-TIME,                           
P0599A                   :KO-INITIAL-COMMENT-TX,                        
P0599A                   :KO-RESPONSE-REASON-CD,                        
P0599A                   :KO-RESPONSE-TYPE-CD,                          
P0599A                   :KO-SOLICITATION-CD,                           
P0599A                   :KO-COMM-ASSOC-CD,                             
P0599A                   :KO-COMPLAINT-FL,                              
P0599A                   :KO-DISCOVERY-MTHD-CD,                         
P0599A                   :KO-PREV-MARKETER-CD)                          
P0599A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_COMM_DATA                                       
MFA-TR*                 (COMMUNICATION_ID,                                      
MFA-TR*                  ACCOUNT_NO,                                            
MFA-TR*                  CUSTOMER_NO,                                           
MFA-TR*                  PREMISE_NO,                                            
MFA-TR*                  COMPANY_NO,                                            
MFA-TR*                  RED_FLAG_IND,                                          
MFA-TR*                  RED_FLAG_EXPIRE_DT,                                    
MFA-TR*                  COMM_METHOD,                                           
MFA-TR*                  COMM_DIRECTION,                                        
MFA-TR*                  COMM_TYPE_CD,                                          
MFA-TR*                  COMM_SUBTYPE_CODE,                                     
MFA-TR*                  USER_ID_ORIG,                                          
MFA-TR*                  CONTACT_NAME,                                          
MFA-TR*                  PROMOTION_ID,                                          
MFA-TR*                  PSC_COMPLIANCE_IND,                                    
MFA-TR*                  CALL_ORIGIN_ID,                                        
MFA-TR*                  CALL_END_TIME,                                         
MFA-TR*                  NUMBER_TRANSFERS,                                      
MFA-TR*                  HOLD_TIME,                                             
MFA-TR*                  QUEUE_TIME,                                            
MFA-TR*                  SCREEN_POP_IND,                                        
MFA-TR*                  TOTAL_CALL_TIME,                                       
MFA-TR*                  INITIAL_COMMENT_TX,                                    
MFA-TR*                  RESPONSE_REASON_CD,                                    
MFA-TR*                  RESPONSE_TYPE_CD,                                      
MFA-TR*                  SOLICITATION_CD,                                       
MFA-TR*                  COMM_ASSOC_CD,                                         
MFA-TR*                  COMPLAINT_FL,                                          
MFA-TR*                  DISCOVERY_MTHD_CD,                                     
MFA-TR*                  PREV_MARKETER_CD)                                      
MFA-TR*         VALUES   (CURRENT TIMESTAMP,                                    
MFA-TR*                  :KO-ACCOUNT-NO,                                        
MFA-TR*                  :KO-CUSTOMER-NO,                                       
MFA-TR*                  :KO-PREMISE-NO,                                        
MFA-TR*                  :KO-COMPANY-NO,                                        
MFA-TR*                  :KO-RED-FLAG-IND,                                      
MFA-TR*                  :KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND,             
MFA-TR*                  :KO-COMM-METHOD,                                       
MFA-TR*                  :KO-COMM-DIRECTION,                                    
MFA-TR*                  :KO-COMM-TYPE-CD,                                      
MFA-TR*                  :KO-COMM-SUBTYPE-CODE,                                 
MFA-TR*                  :KO-USER-ID-ORIG,                                      
MFA-TR*                  :KO-CONTACT-NAME,                                      
MFA-TR*                  :KO-PROMOTION-ID,                                      
MFA-TR*                  :KO-PSC-COMPLIANCE-IND,                                
MFA-TR*                  :KO-CALL-ORIGIN-ID,                                    
MFA-TR*                  :KO-CALL-END-TIME:WS-END-NULL-IND,                     
MFA-TR*                  :KO-NUMBER-TRANSFERS,                                  
MFA-TR*                  :KO-HOLD-TIME,                                         
MFA-TR*                  :KO-QUEUE-TIME,                                        
MFA-TR*                  :KO-SCREEN-POP-IND,                                    
MFA-TR*                  :KO-TOTAL-CALL-TIME,                                   
MFA-TR*                  :KO-INITIAL-COMMENT-TX,                                
MFA-TR*                  :KO-RESPONSE-REASON-CD,                                
MFA-TR*                  :KO-RESPONSE-TYPE-CD,                                  
MFA-TR*                  :KO-SOLICITATION-CD,                                   
MFA-TR*                  :KO-COMM-ASSOC-CD,                                     
MFA-TR*                  :KO-COMPLAINT-FL,                                      
MFA-TR*                  :KO-DISCOVERY-MTHD-CD,                                 
MFA-TR*                  :KO-PREV-MARKETER-CD)                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0599A*                                                                         
P0599A                                                                  
P0599A     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P0599A                                                                  
P0599A     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P0599A         CONTINUE                                                 
P0599A     ELSE                                                         
P0599A         DISPLAY '*************************************'          
P0599A         DISPLAY '* 8400-INSERT-CUST-COMM-DATA'                   
P0599A         DISPLAY '* CUSTOMER_NO = ' 1J-CUSTOMER-NO                
P0599A         DISPLAY '* ACCOUNT_NO  = ' 1J-ACCOUNT-NO                 
P0599A         DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
P0599A         DISPLAY '*************************************'          
P0599A         PERFORM 9900-ABEND                THRU 9900-EXIT         
P0599A     END-IF.                                                      
P0599A                                                                  
P0599A 8400-EXIT.                                                       
P0599A     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8500-UPDATE-CORRESP-HDR                                                 
      ******************************************************************        
       8500-UPDATE-CORRESP-HDR.                                         
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CORRESP_HDR                                   
                  SET ACCOUNT_NO  = :1J-ACCOUNT-NO :WS-CORR-ACCT-NULL   
                     ,CORRESP_STATUS_CD  = :WS-CORRESP-STATUS-CD        
                     ,LAST_UPDATE_PGM_ID = :1J-LAST-UPDATE-PGM-ID       
                WHERE CORRESP_ID         = :1J-CORRESP-ID               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO  WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT ***************'       
              DISPLAY '* 8500-UPDATE-CORRESP-HDR               *'       
              DISPLAY '* CORRESP ID     : ' 1J-CORRESP-ID               
              DISPLAY '* ACCOUNT NO     : ' 1J-ACCOUNT-NO               
              DISPLAY '* LAST UPD PGM ID: ' 1J-LAST-UPDATE-PGM-ID       
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROCESSING TERMINATED                 *'       
              DISPLAY '********** PCSKR150 ABORT ***************'       
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8510-UPDATE-CREDIT_HIST                                                 
      ******************************************************************        
       8510-UPDATE-CREDIT_HIST.                                         
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CREDIT_HIST                                    
                 SET ADV_CREDIT_LTR    = 'M'                            
P0599A              ,ADV_CREDIT_LTR_DT = IIF(TRY_CONVERT(DATE, 
                                                      :WS-EXT-STMT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-EXT-STMT-DATE
              ) <> 0) OR (LEN(:WS-EXT-STMT-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-EXT-STMT-DATE
              ), CONVERT(DATE, :WS-EXT-STMT-DATE) )              
               WHERE CUSTOMER_NO     = :CK-CUSTOMER-NO                  
                 AND REG_GROUP_CD    = :CK-REG-GROUP-CD                 
                 AND CR_HIST_TRAN_DT = IIF(TRY_CONVERT(DATE, 
                                                    :CK-CR-HIST-TRAN-DT
              ) IS NULL OR (PATINDEX('%.%', :CK-CR-HIST-TRAN-DT
              ) <> 0) OR (LEN(:CK-CR-HIST-TRAN-DT
              ) <> 10), CIS.CHAR2DATE(:CK-CR-HIST-TRAN-DT
              ), CONVERT(DATE, :CK-CR-HIST-TRAN-DT) )              
                 AND CR_HIST_TRAN_TM = CIS.CHAR2TIME(:CK-CR-HIST-TRAN-TM
              )              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CREDIT_HIST                                            
MFA-TR*          SET ADV_CREDIT_LTR    = 'M'                                    
MFA-TR*             ,ADV_CREDIT_LTR_DT = :WS-EXT-STMT-DATE                      
MFA-TR*        WHERE CUSTOMER_NO     = :CK-CUSTOMER-NO                          
MFA-TR*          AND REG_GROUP_CD    = :CK-REG-GROUP-CD                         
MFA-TR*          AND CR_HIST_TRAN_DT = :CK-CR-HIST-TRAN-DT                      
MFA-TR*          AND CR_HIST_TRAN_TM = :CK-CR-HIST-TRAN-TM                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO  WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **************'        
              DISPLAY '* 8510-UPDATE-CREDIT_HIST              *'        
              DISPLAY '* CUSTOMER_NO     = ' CK-CUSTOMER-NO             
              DISPLAY '* REG_GROUP_CD    = ' CK-REG-GROUP-CD            
              DISPLAY '* CR_HIST_TRAN_DT = ' CK-CR-HIST-TRAN-DT         
              DISPLAY '* CR_HIST_TRAN_TM = ' CK-CR-HIST-TRAN-TM         
              DISPLAY '* SQLCODE         : ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '* PROCESSING TERMINATED                *'        
              DISPLAY '********** PCSKR150 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8520-UPDATE-CRED_ITPA-HIST                                              
      ******************************************************************        
       8520-UPDATE-CRED_ITPA-HIST.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CRED_ITPA_HIST                                 
P0599A           SET LETTER_MAILED_DT   = IIF(TRY_CONVERT(DATE, 
                                                      :WS-EXT-STMT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-EXT-STMT-DATE
              ) <> 0) OR (LEN(:WS-EXT-STMT-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-EXT-STMT-DATE
              ), CONVERT(DATE, :WS-EXT-STMT-DATE) )             
P0599A              ,LETTER_NOTIFY_CD   = :LF-LETTER-NOTIFY-CD          
P0599A              ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
P0599A              ,LAST_UPDATE_USERID = 'SYSTEM'                      
               WHERE CUSTOMER_NO       = :LF-CUSTOMER-NO                
                 AND CR_HIST_TRAN_DT   = IIF(TRY_CONVERT(DATE, 
                                                    :LF-CR-HIST-TRAN-DT
              ) IS NULL OR (PATINDEX('%.%', :LF-CR-HIST-TRAN-DT
              ) <> 0) OR (LEN(:LF-CR-HIST-TRAN-DT
              ) <> 10), CIS.CHAR2DATE(:LF-CR-HIST-TRAN-DT
              ), CONVERT(DATE, :LF-CR-HIST-TRAN-DT) )            
                 AND CR_HIST_TRAN_TM   = CIS.CHAR2TIME(
                                                    :LF-CR-HIST-TRAN-TM
              )            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CRED_ITPA_HIST                                         
MFA-TR*          SET LETTER_MAILED_DT   = :WS-EXT-STMT-DATE                     
MFA-TR*             ,LETTER_NOTIFY_CD   = :LF-LETTER-NOTIFY-CD                  
MFA-TR*             ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*             ,LAST_UPDATE_USERID = 'SYSTEM'                              
MFA-TR*        WHERE CUSTOMER_NO       = :LF-CUSTOMER-NO                        
MFA-TR*          AND CR_HIST_TRAN_DT   = :LF-CR-HIST-TRAN-DT                    
MFA-TR*          AND CR_HIST_TRAN_TM   = :LF-CR-HIST-TRAN-TM                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO  WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **************'        
              DISPLAY '* 8520-UPDATE-CRED_ITPA-HIST           *'        
              DISPLAY '* CUSTOMER_NO     = ' LF-CUSTOMER-NO             
              DISPLAY '* CR_HIST_TRAN_DT = ' LF-CR-HIST-TRAN-DT         
              DISPLAY '* CR_HIST_TRAN_TM = ' LF-CR-HIST-TRAN-TM         
              DISPLAY '* SQLCODE         : ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '* PROCESSING TERMINATED                *'        
              DISPLAY '********** PCSKR150 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8530-UPDATE-DEP-ON-HAND                                                 
      ******************************************************************        
       8530-UPDATE-DEP-ON-HAND.                                         
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_DEP_ON_HAND                                    
P0599A           SET AUTO_DEP_LTR_DT  = IIF(TRY_CONVERT(DATE, 
                                                      :WS-EXT-STMT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-EXT-STMT-DATE
              ) <> 0) OR (LEN(:WS-EXT-STMT-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-EXT-STMT-DATE
              ), CONVERT(DATE, :WS-EXT-STMT-DATE) )               
               WHERE ACCOUNT_NO       = :DO-ACCOUNT-NO                  
                 AND DEPOSIT_CERT_NO  = :DO-DEPOSIT-CERT-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_DEP_ON_HAND                                            
MFA-TR*          SET AUTO_DEP_LTR_DT  = :WS-EXT-STMT-DATE                       
MFA-TR*        WHERE ACCOUNT_NO       = :DO-ACCOUNT-NO                          
MFA-TR*          AND DEPOSIT_CERT_NO  = :DO-DEPOSIT-CERT-NO                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO  WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **************'        
              DISPLAY '* 8530-UPDATE-DEP-ON-HAND              *'        
              DISPLAY '* ACCOUNT NO       = ' DO-ACCOUNT-NO             
              DISPLAY '* DEPOSIT CERT NO  = ' DO-DEPOSIT-CERT-NO        
              DISPLAY '* SQLCODE          = ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '* PROCESSING TERMINATED                *'        
              DISPLAY '********** PCSKR150 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ******************************************************************        
      * 8800-WRITE-RESTART                                             *        
      ******************************************************************        
       8800-WRITE-RESTART.                                              
                                                                        
           MOVE WS-PGRMNAME                     TO RF-NAME-PROGRAM.     
           MOVE 1                               TO RF-PARTITION-NO.     
           MOVE 1                               TO RF-DUP-CNTRL-NO.     
           MOVE WS-RESTART-DATA                 TO RF-RESTART-DATA-TEXT.
           MOVE WS-RESTART-DATA-LENGTH          TO RF-RESTART-DATA-LEN. 
                                                                        
           PERFORM 8850-UPDATE-RESTART          THRU 8850-EXIT.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8860-INSERT-RESTART       THRU 8860-EXIT          
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 8840-DELETE-RESTART-ROW.                                      *         
      *****************************************************************         
       8840-DELETE-RESTART-ROW.                                         
      *                                                                         
           MOVE WS-PGRMNAME            TO RF-NAME-PROGRAM.              
           MOVE 1                      TO RF-PARTITION-NO.              
           MOVE 1                      TO RF-DUP-CNTRL-NO.              
           EXEC SQL                                                     
               DELETE FROM CSS_RESTART                                  
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **************'        
              DISPLAY '*** ERROR IN 8840-DELETE-RESTART-ROW ***'        
              DISPLAY '* NAME_PROGRAM   : ' RF-NAME-PROGRAM             
              DISPLAY '* DUP_CNTRL_NO   : ' RF-DUP-CNTRL-NO             
              DISPLAY '* PARTITION_NO   : ' RF-PARTITION-NO             
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '***       PROCESSING TERMINATED      ***'        
              DISPLAY '********** PCSKR150 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
       8840-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8850-UPDATE-RESTART.                                           *        
      ******************************************************************        
       8850-UPDATE-RESTART.                                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO  WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **************'        
              DISPLAY '*        8850-UPDATE-RESTART           *'        
              DISPLAY '* NAME_PROGRAM   : ' RF-NAME-PROGRAM             
              DISPLAY '* DUP_CNTRL_NO   : ' RF-DUP-CNTRL-NO             
              DISPLAY '* PARTITION_NO   : ' RF-PARTITION-NO             
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSKR150 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8860-INSERT-RESTART.                                           *        
      ******************************************************************        
       8860-INSERT-RESTART.                                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                     ( NAME_PROGRAM                                     
                      ,PARTITION_NO                                     
                      ,DUP_CNTRL_NO                                     
                      ,RESTART_DATA)                                    
               VALUES(:RF-NAME-PROGRAM                                  
                     ,:RF-PARTITION-NO                                  
                     ,:RF-DUP-CNTRL-NO                                  
                     ,:RF-RESTART-DATA)                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO  WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR150 ABORT **************'        
              DISPLAY '*       8860-INSERT-RESTART            *'        
              DISPLAY '* NAME_PROGRAM   : ' RF-NAME-PROGRAM             
              DISPLAY '* DUP_CNTRL_NO   : ' RF-DUP-CNTRL-NO             
              DISPLAY '* PARTITION_NO   : ' RF-PARTITION-NO             
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSKR150 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8860-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8887-SAVEPOINT.                                                *        
      ******************************************************************        
       8887-SAVEPOINT.                                                  
                                                                        
           EXEC SQL                                                     
              SAVE TRANSACTION CURRENT_WORK         
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ010
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SAVEPOINT CURRENT_WORK ON ROLLBACK RETAIN CURSORS                 
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
      *                                                                         
       8887-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8888-COMMIT.                                                   *        
      ******************************************************************        
       8888-COMMIT.                                                     
                                                                        
           PERFORM 8800-WRITE-RESTART        THRU 8800-EXIT.            
                                                                        
           MOVE 0                            TO WS-PROCESS-COUNTER.     
           ADD 1                             TO WS-CHKP-SEQ-NO.         
           EXEC SQL                                                     
              COMMIT                                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.'.          
                                                                        
       8888-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8889-ROLLBACK-TO-SAVEPOINT.                                    *        
      ******************************************************************        
                                                                        
       8889-ROLLBACK-TO-SAVEPOINT.                                      
                                                                        
           EXEC SQL                                                     
              CALL CIS.ROLLBACK_SAVEPOINT('CURRENT_WORK')                       
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ010
MFA-TR*    EXEC SQL                                                             
MFA-TR*       ROLLBACK TO SAVEPOINT CURRENT_WORK                                
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
                                                                        
       8889-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8893-RESET-RESTART-REQ-PARM                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00029                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9000-TERMINATE.                                                *        
      ******************************************************************        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSKR150-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK             *          
      ****************************************************************          
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
                                                                        
      ****************************************************************          
      **  9900-SQL-ERROR-ROUTINE                                    **          
      ****************************************************************          
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          
                                                                        
           MOVE SQLCODE                TO WS-DISPLAY-SQLCODE.           
           DISPLAY ' '                                                  
           DISPLAY '**********************************************'     
           DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
           DISPLAY '**********************************************'     
           DISPLAY ' '                                                  
           DISPLAY 'SQLCODE = ' WS-DISPLAY-SQLCODE                      
           DISPLAY ABEND-RECORD-1-DATA                                  
           DISPLAY ABEND-RECORD-2-DATA                                  
           DISPLAY ABEND-RECORD-3-DATA                                  
           DISPLAY '**********************************************'.    
                                                                        
      ******************************************************************        
      * 9900-ABEND                                                     *        
      * COPYBOOK FOR ABEND/ERROR PROCESSING                            *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD09900                                                
           END-EXEC.                                                            
                                                                        
