       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSKR130.                                        
       DATE-WRITTEN.   JAN 2012.                                        
      ******************************************************************        
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **        
      **                                                              **        
      *********           CUSTOMER SERVICE SYSTEM              *********        
      *********                     DB2                        *********        
      **                                                              **        
      ******************************************************************        
      **--------------- P R O G R A M  S U M M A R Y -----------------**        
      *************************************************************** **        
      **   THIS PROGRAM READS BE00 FILE AS INPUT AND FORECAST ACTIONS **        
      **   FOR ACCOUNTS THAT ARE GOING THROUGH FINAL BILL.  THIS PRO- **        
      **   GRAM IS RUN POST BILLING.                                  **        
      ******************************************************************        
      **------------- PROGRAM  MODIFICATION  LOG -------------------- **        
      ******************************************************************        
      **      PCSKR130   PROGRAM  MODIFICATION  LOG                   **        
      **                                                              **        
      **   DATE        INITIALS  REASON                               **        
      **   __________  ________  ______________                       **        
P00599**   02/01/2012  RC41079   INITIAL PROGRAM VERSION.             **        
P00599**   08/08/2012  AA97148   ADDED SKIP ACCT PROCESS.             **        
P00599**   08/13/2012  GOKUL     POPULATE FW-ACCOUNT-NO IN 2000-.     **        
      **                                                              **        
P0599A**   08/27/2012  RC41079   ADDED LOGIC TO GENERATE WQ WHEN A    **        
P0599A**                         GUARANTOR ACCOUNT HAS FINAL BILLED.  **        
P0599A**                         ALSO ADDED LOGIC TO INSERT INTO      **        
P0599A**                         FIN_WO_ACTION WHEN ACCOUNT HAS       **        
P0599A**                         A RETURN CHECK AT FINAL BILL.        **        
      **                                                              **        
A04432**   10/19/2012  MC95456   REMOVE ITEM ID CHECK FROM DELETE OF  **        
A04432**                         CSS_CRED_COLL TABLE.                 **        
ACT048**   05/02/2013  VIJAY     POPULATE DUE-DATE FOR BANKRUPT ACCTS **        
ACT048**    A04527                                                    **        
ACT152**   09/19/2013  RB19957 1)ADD CURSOR SO MULTIPLE RETURN CHECKS **        
ACT152**    A04527   RICK BLACK  CAN BE PROCESSED W/O ABENDING.       **        
ACT152**                       2)CHANGE WS-ACTIVE-RETURN-CODE TO      **        
ACT152**                         WS-DISPLAY-SQLCODE TO SEE SQLCODE.   **        
ACT042**   02/11/2014  RB19957  CHANGE 7100-SELECT-GUARANTOR SO IT CAN**        
ACT042**    A04880  RICK BLACK  HANDLE MULTIPLE GUARANTORS.           **        
I01687**   05/09/2014  VIJAY    DELETE 'LPCASSESSED' ATTRIBUTE        **        
I01687**                                                              **        
ACT051**   12/12/2014  SS7F226  WORK QUEUE CHANGE TO REPLACE THE      **        
ACT051**               A048860  CSS_WQ_ITEMS_MF WITH CSS_WQ_ITEMS.    **        
ACT051**                        AND REMOVED THE UN USED CODE.         **        
ACT320**   10/31/2016  VIJAY    INITIALIZE INDEX TO SUPPORT MFES.     **        
ACT320**   A05460                                                     **        
      ******************************************************************        
      **----------------- BASIC SEQUENCE STRUCTURE -------------------**        
      *************************************************************** **        
      **         0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION **        
      **         1000 - 1999     INPUT PROCESSING CONTROL PATH        **        
      **         2000 - 2999     OUTPUT PROCESSING CONTROL PATH       **        
      **         3000 - 4999     BATCH PROCESSING MODULES - NOT USED  **        
      **         5000 - 5999     COMMON PROGRAM MODULES               **        
      **         6000 - 6999     COMMON SYSTEM MODULES                **        
      **         7000 - 7999     INPUT MODULES                        **        
      **         8000 - 8999     OUTPUT MODULES                       **        
      **         9000 - 9799     TERMINATION MODULES                  **        
      **         9900 - 9999     ABEND/ABORT MODULES                  **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSBE00.                                                            
       COPY CSSKR100.                                                           
P00599*RESTART FILE FOR KR100                                                   
P00599 COPY CSSKR100 REPLACING FCSKR100-FILE      BY FCSKR10R-FILE,             
P00599                         UT-S-FCSKR100      BY UT-S-FCSKR10R,             
P00599                         WS-FCSKR100-STATUS BY WS-FCSKR10R-STATUS.        
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDBE00.                                                            
       COPY FIOBE00.                                                            
       COPY CFDKR100.                                                           
       COPY FIOKR100.                                                           
P00599*RESTART FILE                                                             
P00599 COPY CFDKR100 REPLACING FCSKR100-FILE      BY FCSKR10R-FILE.             
P00599 01 FIOKR10R                       PIC X(547).                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSKR130'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)                      
           VALUE 'WORKING STORAGE FOR PCSKR130 STARTS HERE'.            
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME               PIC X(08)    VALUE 'PCSKR130'.
           05  WS-PGRMNAME                PIC X(10)    VALUE 'PCSKR130'.
ACT051     05  SCSCB077                   PIC X(08)    VALUE 'SCSCB077'.
           05  WS-Y                       PIC X(01)    VALUE 'Y'.       
           05  WS-N                       PIC X(01)    VALUE 'N'.       
           05  WS-SUB                     PIC X(01)    VALUE 'S'.       
           05  WS-1H                      PIC X(04)    VALUE '8000'.    
           05  WS-SYSTEM                  PIC X(06)    VALUE 'SYSTEM'.  
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-DISPLAY-SQLCODE         PIC -Z(8)9.                   
           05  RS-RETURN-CODE             PIC S9(04)   COMP VALUE 0.    
           05  RS-RETURN-CODE-DISP        PIC S9(04)   COMP VALUE 0.    
           05  WS-START-POS               PIC S9(04)   COMP VALUE 0.    
           05  WS-PREVIOUS-ACCT-NO        PIC S9(13)   COMP-3 VALUE 0.  
           05  WS-DISPLAY-ACCOUNT         PIC 9(13)    VALUE 0.         
P00599     05  WS-FKR100-REC-CNTR         PIC S9(09)   COMP-3 VALUE 0.  
P00599     05  WS-FCSKR10R-CNTR           PIC S9(09)  VALUE ZERO COMP-3.
P00599     05  WS-FCSKR100-CNTR           PIC S9(09)   COMP VALUE +0.   
           05  WS-END-REC-PROCESSED       PIC X(01)    VALUE 'N'.       
P00599     05  WS-WQ-INSERT               PIC X(01)    VALUE 'N'.       
           05  WS-DATE-20-DAYS-AGO        PIC X(10)    VALUE SPACES.    
           05  WS-TOTAL-UTILITY-CHARGES   PIC S9(9)V99 VALUE ZERO.      
           05  WS-TOTAL-NONUTIL-CHARGES   PIC S9(9)V99 VALUE ZERO.      
           05  WS-UNBILLED-RECEIVABLES    PIC S9(09)V99 COMP-3 VALUE 0. 
           05  WS-KA-GUARANTEED-IND       PIC X(01)    VALUE SPACES.    
           05  WS-KA-FW-ACCT-TYPE-CD      PIC X(01)    VALUE SPACES.    
           05  WS-ACCT-TYPE-CD            PIC X(01)    VALUE SPACES.    
           05  WS-GUARANTEED-IND          PIC X(01)    VALUE SPACES.    
           05  WS-DATE-NOTICE-MAIL-NULL   PIC S9(4)    COMP.            
           05  WS-ACCOUNT-NO-KD-TEMP      PIC S9(13)V  COMP-3 VALUE 0.  
           05  WS-DATE-NOTICE-DUE-NULL    PIC S9(4)    COMP.            
           05  WS-DATE-CREDIT-ACTION-NULL PIC S9(4)    COMP.            
           05  WS-DATE-BILL-NULL          PIC S9(4)    COMP.            
           05  WS-TOT-DUE-DT-NULL         PIC S9(4)    COMP.            
           05  WS-UTL-NORM-DUE-DT-NULL    PIC S9(4)    COMP.            
           05  WS-UTL-EXCP-DUE-DT-NULL    PIC S9(4)    COMP.            
           05  WS-NONUTL-NORM-DUE-DT-NULL PIC S9(4)    COMP.            
           05  WS-NONUTL-EXCP-DUE-DT-NULL PIC S9(4)    COMP.            
           05  WS-NULL-IND-18             PIC S9(4)    COMP.            
           05  WS-NULL-IND-1              PIC S9(4)    COMP.            
           05  WS-FST-OCCUR               PIC X(01)    VALUE 'N'.       
           05  PRV-WD-INDX                PIC S9(04)   COMP VALUE 0.    
           05  WS-CORRECTED-BILL          PIC X(01)    VALUE 'N'.       
           05  WS-PART-NO                 PIC 9(02)    VALUE 0.         
           05  WS-WORK-DATE               PIC X(10)    VALUE SPACES.    
P0599A     05  WS-RTC-DT-NOTICE-MAIL      PIC X(10)    VALUE SPACES.    
           05  WS-ATTRIBUTE-IND           PIC X(01)    VALUE SPACES.    
           05  WS-CURRENT-COMPANY         PIC X(01)    VALUE SPACES.    
           05  CURRENT-TIMESTAMP          PIC X(26)    VALUE SPACES.    
           05  CURRENT-DATE               PIC X(10)    VALUE SPACES.    
           05  WS-CURR-CHG-DUE-DT         PIC X(10)    VALUE SPACES.    
           05  WS-ADJ-DAY                 PIC S9(9)    COMP.            
           05  WS-DAY-DUE                 PIC S9(5)    COMP-3 VALUE +0. 
           05  WS-HAS-ACTIVE-GUAR         PIC X(01).                    
           05  WS-ACTIVE-GUAR             PIC X(01)    VALUE 'A'.       
           05  WS-AUTO-CARD-PAY-DAYS      PIC S9(05)   COMP-3 VALUE +0. 
           05  WS-ACCTS-TO-SKIP           PIC S9(09)   COMP VALUE +0.   
           05  WS-DEFAULT-ACCTS-TO-SKIP   PIC S9(09)   COMP VALUE +50.  
P00599     05  WS-PROCESS-COUNTER         PIC S9(09)   COMP   VALUE +0. 
P00599     05  WS-SKIP-COUNTER            PIC S9(09)   COMP VALUE 0.    
P00599     05  WS-CURR-WQ-ITEM            PIC S9(09)   COMP VALUE 0.    
P0599A     05  WS-RTC-AMT-NOTICE          PIC S9(9)V99 COMP-3 VALUE 0.  
ACT051     05  WS-INPUT-ZERO              PIC X(16)                     
ACT051                                    VALUE '-00.00.00.000000'.     
ACT051     05  WS-INPUT-DATE-26           PIC X(26) VALUE SPACES.       
      *                                                                         
       01  WS-RESTART-MISC.                                             
           05  WS-RESTART-DATA-LENGTH     PIC S9(04)   COMP VALUE +45.  
           05  WS-IS-THIS-A-RESTART       PIC X(01)    VALUE 'N'.       
               88  WS-THIS-IS-A-RESTART                VALUE 'Y'.       
               88  WS-THIS-IS-NOT-A-RESTART            VALUE 'N'.       
           05  WS-COMMIT-COUNTER         PIC 9(04)     VALUE ZERO.      
           05  WS-CHKP-LUW-LIMIT         PIC 9(04)     VALUE ZERO.      
           05  WS-CHKP-LUW-COUNTER       PIC 9(04)    VALUE ZERO COMP-3.
           05  WS-CHKP-UPD-LIMIT         PIC 9(04)    VALUE ZERO.       
           05  WS-DEFAULT-CHKP-LUW-LIMIT PIC 9(04)    VALUE 100.        
           05  WS-DEFAULT-CHKP-UPD-LIMIT PIC 9(04)    VALUE 100.        
           05  WS-CHKP-UPD-COUNTER       PIC 9(04)    VALUE ZERO COMP-3.
           05  WS-CHKP-ID.                                              
               10  WS-CHKP-PART-NO       PIC 9(01)    VALUE 1.          
               10  WS-CHKP-SEQ-NO        PIC 9(08)    VALUE ZERO.       
P00599     05  WS-FCSBE00-REC-CNTR       PIC S9(09)   VALUE ZERO COMP-3.
P00599     05  WS-DELINQ-COUNT           PIC S9(09)   VALUE ZERO COMP-3.
      *                                                                         
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE   PIC 9(01).                     
           05  WS-RESTART-JOB-COMPLETE   REDEFINES                      
               WS-RESTART-PROCESS-TYPE   PIC X(01).                     
           05  WS-RESTART-JOB-STATUS     PIC X(01).                     
               88  WS-RUN-COMPLETED-NO-PROBLEMS       VALUE 'A'.        
               88  WS-RERUN-COMPLETED                 VALUE 'B'.        
               88  WS-RERUN-PENDING                   VALUE 'C'.        
           05  WS-RESTART-COMMON-DATE    PIC X(10)    VALUE SPACES.     
P00599     05  WS-RESTART-CHKP-SEQ-NO    PIC S9(09) USAGE COMP VALUE +0.
           05  WS-RESTART-ACCOUNT-NO     PIC 9(13)    VALUE 0.          
P00599     05  WS-RESTART-BE00-CNT       PIC S9(09) USAGE COMP VALUE +0.
P00599     05  WS-RESTART-FCSKR10R-CTR   PIC S9(09) USAGE COMP VALUE +0.
           05  WS-RESTART-SKIP-COUNTER   PIC S9(09) USAGE COMP VALUE +0.
      *                                                                         
       01  WS-WQ-MESSAGE-DATA.                                          
           05  WS-DATABASE-EXCEPTION.                                   
               10  FILLER                PIC S9(4)    COMP VALUE +137.  
               10  FILLER                PIC X(1)     VALUE 'N'.        
               10  FILLER                PIC X(1)     VALUE '4'.        
               10  FILLER                PIC S9(4)    COMP VALUE +29.   
               10  FILLER                PIC X(30)    VALUE             
                   'A DATABASE EXCEPTION OCCURRED'.                     
           05  WS-MISCELLANEOUS-MESSAGE.                                
               10  WS-MISC-CATEGORY-ID   PIC S9(04)   COMP VALUE 138.   
               10  FILLER                PIC X(01)    VALUE 'N'.        
               10  FILLER                PIC X(01)    VALUE '4'.        
               10  WS-MISC-MSG-LEN       PIC S9(04)   COMP VALUE +60.   
               10  WS-MISC-MSG-TEXT      PIC X(60).                     
P0599A     05  WS-GUARNTR-MSG.                                          
P0599A         10  WS-GUARNTR-STAT       PIC X(35)    VALUE             
P0599A             'GUARANTOR ACCOUNT HAS FINAL BILLED.'.               
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-ON-OFF-CYCLE-IND       PIC X(01)    VALUE SPACES.     
               88  WS-OFF-CYCLE-REBILL                VALUE 'O'.        
               88  WS-OFF-CYCLE-FINAL                 VALUE 'B'.        
           05  WS-END-OF-BE00-SW         PIC X(01)    VALUE SPACES.     
               88  END-OF-BE00                        VALUE 'Y'.        
           05  WS-BEGIN-REC-SW           PIC X(01)    VALUE SPACES.     
               88  WS-BEGIN-RECS-PROCESSED            VALUE 'Y'.        
               88  WS-BEGIN-REC-NOT-PROCESSED         VALUE 'N'.        
               88  WS-START-INPUT-DATA                VALUE 'X'.        
           05  WS-RECORD-FOUND           PIC X(01)    VALUE 'N'.        
               88  DATA-RECORD-FOUND                  VALUE 'Y'.        
               88  NO-DATA-RECORD-FOUND               VALUE 'N'.        
P0599A     05  WS-NSF-HIST-FOUND         PIC X(01)    VALUE 'N'.        
P0599A         88  NSF-HIST-FOUND                     VALUE 'Y'.        
P0599A         88  NO-NSF-HIST-FOUND                  VALUE 'N'.        
           05  WS-FBE00-STATUS           PIC X(02)    VALUE SPACES.     
               88  FCSBE00-SUCCESSFUL                 VALUE '00'.       
           05  WS-FCSKR100-STATUS        PIC X(02)    VALUE SPACES.     
               88  FCSKR100-SUCCESSFUL                VALUE '00'.       
               88  END-OF-FCSBE00                     VALUE '10'.       
           05  WS-CWS-TABLE-ID           PIC  9(04)   VALUE 0.          
               88  WS-TABLE-AT-BI-BG-AC-DA-CZ         VALUES            
                   0300 1400 1900 1910 2400 2700 2900 3000 5300 6650    
                   6770.                                                
           05  WS-FCSBE00-ACCT-FLAG      PIC  X(01)   VALUE 'N'.        
               88  FCSBE00-ACCT-NO-CHANGED            VALUE 'Y'.        
           05  WS-FW-MATCH-FL            PIC X(01)    VALUE '0'.        
               88  MATCH-FOUND                        VALUE '1'.        
           05  WS-PROCESS-ACCOUNT        PIC X(01)    VALUE 'Y'.        
               88 PROCESS-ACCT                        VALUE 'Y'.        
               88 SKIP-ACCT                           VALUE 'N'.        
P00599     05 WS-FCSKR10R-STATUS         PIC X(02).                     
P00599         88  FCSKR10R-SUCCESSFUL                VALUE '00'.       
P00599         88  END-OF-FCSKR10R                    VALUE '10'.       
      *                                                                         
       01  WS-HOLD-CRED-COLL.                                           
           10 WS-HOLD-DATE-NOTICE-DUE      PIC X(10).                   
      *                                                                         
       01  WS-HOLD-FINAL-WO.                                            
COB305     10 WS-HOLD-FINAL-BILL-AMT        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0. 
      *                                                                         
       01  WS-FIN-WO-PATH-TABLE.                                        
           05  WS-FIN-WO-PATH-TBL                                       
               OCCURS 2000 TIMES                                        
               ASCENDING KEY WS-FW-COMPANY-KA,                          
               ASCENDING KEY WS-FW-REG-GROUP-CD-KA,                     
               ASCENDING KEY WS-FW-CODE-STAT-RSN-KA,                    
               ASCENDING KEY WS-FW-BHV-SCORE-RTNG-KA                    
               INDEXED BY WS-PATH-INDEX.                                
               10 WS-FW-COMPANY-KA          PIC X(02).                  
               10 WS-FW-REG-GROUP-CD-KA     PIC X(03).                  
               10 WS-FW-CODE-STAT-RSN-KA    PIC X(01).                  
               10 WS-FW-BHV-SCORE-RTNG-KA   PIC X(01).                  
               10 WS-FW-PATH-TYPE-CD-KA     PIC X(02).                  
               10 WS-FW-ACCT-TYPE-CD-KA     PIC X(01).                  
               10 WS-GUARANTEED-IND-KA      PIC X(01).                  
COB305         10 WS-FW-ACTION-SEQ-F8        PIC S9(05)V COMP-3 VALUE 0.        
               10 WS-FW-ACTION-TYPE-F8      PIC X(05).                  
COB305         10 WS-FW-ACTION-DAYS-F8        PIC S9(05)V COMP-3 
COB305           VALUE 0.         
               10 WS-FW-FRCST-TIME-CD-F8    PIC X(01).                  
               10 WS-FW-FRCST-SOURCE-CD-F8  PIC X(01).                  
COB305         10 WS-FW-FRCST-ACTN-LMIT-F8        PIC S9(09)V99 COMP-3 
COB305           VALUE 0.       
               10 WS-FW-COLLECTION-FL-F8    PIC X(01).                  
               10 WS-FW-BUS-PROCESS-CD-F8   PIC X(02).                  
      *                                                                         
       01  WS-WORK-DAY-TABLE.                                           
           05  WS-WORK-DAY-LIST                                         
                  OCCURS 100 TIMES                                      
                  ASCENDING KEY WS-WORK-DAY                             
                  INDEXED BY WD-INDX.                                   
               10  WS-WORK-DAY              PIC X(10).                  
      *                                                                         
       01  WS-DELINQUENCY-VALUES-TABLE.                                 
           05  WS-DELINQ-VALUE-ENTRY-TB                                 
               OCCURS 30 TIMES                                          
               INDEXED BY DELQ-INDX.                                    
               15  WS-COMPANY-NO-TB      PIC X(02).                     
               15  WS-DELINQ-CD-TB       PIC X(20).                     
COB305         15 WS-DELINQ-VALUE-TB        PIC S9(4)V9(5) COMP-3 
COB305           VALUE 0.         
      *                                                                         
      ******************************************************************        
      * SINCE CPD0050B IS WRITTEN ON THE BASIS OF BE38 FIELDS WE WILL  *        
      * READ BE00 AND MOVE BE00 RECORD TO BE38 RECORD. BOTH FILES HAVE *        
      * SAME LAYOUT.                                                   *        
      ******************************************************************        
      *                                                                         
       COPY FIOBE38.                                                            
      *                                                                         
      ******************************************************************        
      * CWS00010 CONTAINS DB2 ABEND VARIABLES                          *        
      ******************************************************************        
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
      ******************************************************************        
      * WS-ABEND-SWITCH                                                *        
      ******************************************************************        
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
      ******************************************************************        
      * CWS1000B CONTAINS BE00 RECORD LAYOUTS                          *        
      ******************************************************************        
      *                                                                         
       COPY CWS1000B.                                                           
      *                                                                         
      ******************************************************************        
      * CWS00039 JOB PARM ROUTINE                                      *        
      ******************************************************************        
      *                                                                         
       COPY CWS00039.                                                           
      *                                                                         
      ******************************************************************        
      * FIOJC01 WORKING STORAGE                                        *        
      ******************************************************************        
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      ******************************************************************        
      * FCA00-KEY                                                      *        
      ******************************************************************        
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR CODES-DATA-PRESENT                         *        
      ******************************************************************        
      *                                                                         
       COPY CWS00056.                                                           
      *                                                                         
      ******************************************************************        
      * CWS10009 CONTAINS BE00 AR RECORDS AND MORE                     *        
      ******************************************************************        
      *                                                                         
       COPY CWS10009.                                                           
       COPY CWS1000A.                                                           
       COPY CWS100B5.                                                           
      *                                                                         
      ******************************************************************        
      * CWS00303 JOB PARM ROUTINE CONTAINS WS-WARNING-DATA-ELEMENTS    *        
      ******************************************************************        
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      ******************************************************************        
      * CWS1000K CONTAINS WS STORAGE LAYOUT FOR CSS_BILL_CRED_DET TBL  *        
      ******************************************************************        
      *                                                                         
       COPY CWS1000K.                                                           
      *                                                                         
      ******************************************************************        
      *   CWS10008 KR100 PROCESSING DATA.                              *        
      ******************************************************************        
       COPY CWS10008.                                                           
      *                                                                         
      ******************************************************************        
      * DB2 COMMUNICATION REQUIREMENT                                  *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CWS00038 CONTAINS WORKING STORAGE VARIABLES TO GET JOB PARM    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      *                                                                         
       01  WS-SKIP-ROW-COUNT REDEFINES WS-INPUT-DATA-BREAKDOWN.         
           10  WS-PARM-SKIP-ROW-COUNT-TXT PIC X(14).                    
               88 SKIP-ROW-CNT         VALUE 'ACCTS-TO-SKIP='.          
           10  WS-NO-OF-ROWS-TO-SKIP     PIC X(05).                     
           10  FILLER                    PIC X(61).                     
      *                                                                         
      *                                                                         
      *****************************************************************         
      * CWS00322 CONTAINS WS FOR FINDING NEXT BUSINESS DAY            *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00322                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CWS00338 WORKING STORAGE FOR AUTO PAYMENT DATE(CPD00338)       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00338                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE COPYBOOK FOR COMPUTE UTL & NONUTL DELINQ.      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00339                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE COPYBOOK FOR SURETY BOND EXPIRATION.           *        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE CWS00340                                                   
           END-EXEC.                                                            
      *                                                                         
P0599A*****************************************************************         
P0599A*  CWS00346     CONTAINS WS GETTING WQ GENERATION FLAG          *         
P0599A*****************************************************************         
P0599A     EXEC SQL                                                             
P0599A        INCLUDE CWS00346                                                  
P0599A     END-EXEC.                                                            
      *                                                                         
P00599******************************************************************        
P00599*  WORKING STORAGE COPY BOOKS FOR CPD00348                       *        
P00599******************************************************************        
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE CWS00348                                                 
P00599     END-EXEC.                                                            
P00599*                                                                         
      ******************************************************************        
      * WORKING STORAGE SUPPLEMENTAL WQ TEXT                           *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0070B                                                  
           END-EXEC.                                                            
                                                                        
ACT051******************************************************************        
ACT051* FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077          *        
ACT051******************************************************************        
ACT051*                                                                         
ACT051     EXEC SQL                                                             
ACT051        INCLUDE CWS00077                                                  
ACT051     END-EXEC.                                                            
ACT051*                                                                         
      ******************************************************************        
      * CSS_ACCOUNT        - AT                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_BUSINESS_DAYS  - 1G                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBUSDAY                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_BILL_CRED_DET  - 1H                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCRBLDL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_CORR_MAIL_STAT - MW                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMAILST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CREDIT_PROFILE - CZ                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCRPROF                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_DELINQUENCY    - C8                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_JOB_PARM       - G6                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
P0599A******************************************************************        
P0599A* CSS_NSF_HIST       - NH                                        *        
P0599A******************************************************************        
P0599A*                                                                         
P0599A     EXEC SQL                                                             
P0599A        INCLUDE TBNSFHST                                                  
P0599A     END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_RESTART        - RF                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_REG_PROFILE    - LR                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBREGPRF                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_FW_FCST_OPTION - KA                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPATHAS                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_FW_FCST_ACTION - F8                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBFWPDTL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_GUARANTOR - GU                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGTNTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CRED_COLL - CL                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCRCOLL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_FINAL_WO - FW                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBFINLWO                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_FIN_WO_ACTION - KD                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBFWACTN                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_FIN_WO_COL_HST - FM                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBFWAHST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_FIN_WO_COLLECT - IZ                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBFWCLAG                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_SURETY_BOND - SB                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSTYBND                                                  
           END-EXEC.                                                            
      *                                                                         
P0599A******************************************************************        
P0599A*    CSS_WQ_PGM_CNTL    WN                                                
P0599A******************************************************************        
P0599A     EXEC SQL                                                             
P0599A         INCLUDE TBWQCNTL                                                 
P0599A     END-EXEC.                                                            
      *                                                                         
I01687******************************************************************        
I01687* CSS_ACCT_ATTRIBUTE - YP                                        *        
I01687******************************************************************        
I01687*                                                                         
I01687     EXEC SQL                                                             
I01687         INCLUDE TBACTATT                                                 
I01687     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CURSOR DECLARATION                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE FIN_WO_PATH_CSR CURSOR FOR                        
                 SELECT KA.COMPANY_NO,                                  
                        KA.REG_GROUP_CD,                                
                        KA.CODE_STATUS_REASON,                          
                        KA.BHV_SCORE_RATING,                            
                        KA.FW_PATH_TYPE_CD,                             
                        KA.FW_ACCT_TYPE_CD,                             
                        KA.GUARANTEED_IND,                              
                        F8.FW_ACTION_SEQ_NO,                            
                        F8.FW_ACTION_TYPE_CD,                           
                        F8.FW_FCST_DAYS_NM,                             
                        F8.FW_FCST_TIME_CD,                             
                        F8.FW_FCST_SOURCE_CD,                           
                        F8.FW_FCST_COLL_FL,                             
                        F8.FW_ACTION_LIMIT_AM,                          
                        F8.FW_BUS_PROCESS_CD                            
                   FROM CSS_FW_FCST_OPTION KA WITH(READUNCOMMITTED),            
                        CSS_FW_FCST_ACTION F8 WITH(READUNCOMMITTED)             
               WHERE KA.EFFECTIVE_DT <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )                  
                    AND KA.EXPIRATION_DT >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )              
                    AND F8.EFFECTIVE_DT <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )               
                    AND F8.EXPIRATION_DT >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )              
                    AND F8.FW_FCST_TIME_CD = 'F'                        
                    AND F8.COMPANY_NO = KA.COMPANY_NO                   
                    AND F8.REG_GROUP_CD = KA.REG_GROUP_CD               
                    AND F8.FW_PATH_TYPE_CD = KA.FW_PATH_TYPE_CD         
                  ORDER BY KA.COMPANY_NO,                               
                           KA.REG_GROUP_CD,                             
                           KA.CODE_STATUS_REASON,                       
                           KA.BHV_SCORE_RATING,                         
                           F8.FW_ACTION_SEQ_NO,                         
                           F8.FW_ACTION_TYPE_CD                         
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE FIN_WO_PATH_CSR CURSOR FOR                                
MFA-TR*          SELECT KA.COMPANY_NO,                                          
MFA-TR*                 KA.REG_GROUP_CD,                                        
MFA-TR*                 KA.CODE_STATUS_REASON,                                  
MFA-TR*                 KA.BHV_SCORE_RATING,                                    
MFA-TR*                 KA.FW_PATH_TYPE_CD,                                     
MFA-TR*                 KA.FW_ACCT_TYPE_CD,                                     
MFA-TR*                 KA.GUARANTEED_IND,                                      
MFA-TR*                 F8.FW_ACTION_SEQ_NO,                                    
MFA-TR*                 F8.FW_ACTION_TYPE_CD,                                   
MFA-TR*                 F8.FW_FCST_DAYS_NM,                                     
MFA-TR*                 F8.FW_FCST_TIME_CD,                                     
MFA-TR*                 F8.FW_FCST_SOURCE_CD,                                   
MFA-TR*                 F8.FW_FCST_COLL_FL,                                     
MFA-TR*                 F8.FW_ACTION_LIMIT_AM,                                  
MFA-TR*                 F8.FW_BUS_PROCESS_CD                                    
MFA-TR*            FROM CSS_FW_FCST_OPTION KA,                                  
MFA-TR*                 CSS_FW_FCST_ACTION F8                                   
MFA-TR*        WHERE KA.EFFECTIVE_DT <= :WS-INPUT-DATE                          
MFA-TR*             AND KA.EXPIRATION_DT >= :WS-INPUT-DATE                      
MFA-TR*             AND F8.EFFECTIVE_DT <= :WS-INPUT-DATE                       
MFA-TR*             AND F8.EXPIRATION_DT >= :WS-INPUT-DATE                      
MFA-TR*             AND F8.FW_FCST_TIME_CD = 'F'                                
MFA-TR*             AND F8.COMPANY_NO = KA.COMPANY_NO                           
MFA-TR*             AND F8.REG_GROUP_CD = KA.REG_GROUP_CD                       
MFA-TR*             AND F8.FW_PATH_TYPE_CD = KA.FW_PATH_TYPE_CD                 
MFA-TR*           ORDER BY KA.COMPANY_NO,                                       
MFA-TR*                    KA.REG_GROUP_CD,                                     
MFA-TR*                    KA.CODE_STATUS_REASON,                               
MFA-TR*                    KA.BHV_SCORE_RATING,                                 
MFA-TR*                    F8.FW_ACTION_SEQ_NO,                                 
MFA-TR*                    F8.FW_ACTION_TYPE_CD                                 
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*        QUERYNO 7076                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
              DECLARE OFF_REBILL_ACTION CURSOR FOR                      
                 SELECT KD.ACCOUNT_NO,                                  
                        KD.FW_ACTION_TYPE_CD,                           
                        KD.FW_SEQ_NO,                                   
                        KD.FW_ACTION_DT,                                
                        KD.FW_ACTION_AM,                                
                        IZ.CUSTOMER_NO,                                 
                        IZ.CODE_COLLEC_AGNCY,                           
                        IZ.COLL_AGY_SUB_CD,                             
                        IZ.WITHDRAW_AM,                                 
                        IZ.WITHDRAW_DT,                                 
                        IZ.WITHDRAW_REASON_CD,                          
                        FW.FW_PATH_TYPE_CD                              
                   FROM CSS_FIN_WO_COLLECT IZ WITH(READUNCOMMITTED),            
                        CSS_FIN_WO_ACTION KD WITH(READUNCOMMITTED),             
                        CSS_FINAL_WO FW WITH(READUNCOMMITTED)                   
                  WHERE KD.ACCOUNT_NO = :WS-PREVIOUS-ACCT-NO            
                    AND KD.ACCOUNT_NO = FW.ACCOUNT_NO                   
                    AND KD.ACCOUNT_NO = IZ.ACCOUNT_NO                   
                    AND KD.FW_SEQ_NO  = IZ.FW_COLL_SEQ_NO               
                    AND KD.FW_ACTION_TYPE_CD = IZ.FW_ACTION_TYPE_CD     
                    AND KD.FW_ACTION_DT <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )               
                    AND KD.FW_ACTION_AM > 0                             
                    AND FW.REG_GROUP_CD = IZ.REG_GROUP_CD               
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OFF_REBILL_ACTION CURSOR FOR                              
MFA-TR*          SELECT KD.ACCOUNT_NO,                                          
MFA-TR*                 KD.FW_ACTION_TYPE_CD,                                   
MFA-TR*                 KD.FW_SEQ_NO,                                           
MFA-TR*                 KD.FW_ACTION_DT,                                        
MFA-TR*                 KD.FW_ACTION_AM,                                        
MFA-TR*                 IZ.CUSTOMER_NO,                                         
MFA-TR*                 IZ.CODE_COLLEC_AGNCY,                                   
MFA-TR*                 IZ.COLL_AGY_SUB_CD,                                     
MFA-TR*                 IZ.WITHDRAW_AM,                                         
MFA-TR*                 IZ.WITHDRAW_DT,                                         
MFA-TR*                 IZ.WITHDRAW_REASON_CD,                                  
MFA-TR*                 FW.FW_PATH_TYPE_CD                                      
MFA-TR*            FROM CSS_FIN_WO_COLLECT IZ,                                  
MFA-TR*                 CSS_FIN_WO_ACTION KD,                                   
MFA-TR*                 CSS_FINAL_WO FW                                         
MFA-TR*           WHERE KD.ACCOUNT_NO = :WS-PREVIOUS-ACCT-NO                    
MFA-TR*             AND KD.ACCOUNT_NO = FW.ACCOUNT_NO                           
MFA-TR*             AND KD.ACCOUNT_NO = IZ.ACCOUNT_NO                           
MFA-TR*             AND KD.FW_SEQ_NO  = IZ.FW_COLL_SEQ_NO                       
MFA-TR*             AND KD.FW_ACTION_TYPE_CD = IZ.FW_ACTION_TYPE_CD             
MFA-TR*             AND KD.FW_ACTION_DT <= :WS-INPUT-DATE                       
MFA-TR*             AND KD.FW_ACTION_AM > 0                                     
MFA-TR*             AND FW.REG_GROUP_CD = IZ.REG_GROUP_CD                       
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*        QUERYNO 7079                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DECLARE CURSOR TO GET DELIQUENCY VALUES FOR COMP 01 AND 26     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
             DECLARE DELINQUENCY_CSR CURSOR FOR                         
              SELECT C8.DELINQ_CD                                       
                    ,C8.DELINQ_VALUE                                    
                    ,C8.COMPANY_NO                                      
                FROM CSS_DELINQUENCY C8                                 
               WHERE C8.DELINQ_CD  = 'AUTO-CARD-PAY-DAYS'               
               ORDER BY C8.COMPANY_NO                                   
                       ,C8.DELINQ_VALUE                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE DELINQUENCY_CSR CURSOR FOR                                 
MFA-TR*       SELECT C8.DELINQ_CD                                               
MFA-TR*             ,C8.DELINQ_VALUE                                            
MFA-TR*             ,C8.COMPANY_NO                                              
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD  = 'AUTO-CARD-PAY-DAYS'                       
MFA-TR*        ORDER BY C8.COMPANY_NO                                           
MFA-TR*                ,C8.DELINQ_VALUE                                         
MFA-TR*      QUERYNO 7090                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
ACT152****************************************************************  06310000
ACT152**  CURSOR TO LOOK FOR RETURNED CHECKS                        **  06320000
ACT152****************************************************************  06330000
ACT152     EXEC SQL                                                     
ACT152        DECLARE RETURNED_CHK_CSR CURSOR WITH HOLD FOR             
ACT152         SELECT DATE_NOTICE_MAIL                                  
ACT152               ,ITEM_ID                                           
ACT152               ,AMT_NOTICE                                        
ACT152               ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
ACT152           FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                       
ACT152          WHERE ACCOUNT_NO        = :CL-ACCOUNT-NO                
ACT152            AND CODE_NOTICE_TYPE  = 'N'                           
ACT152            AND DATE_NOTICE_MAIL  > IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )                
ACT152            AND PROCESSED_CD      = ' '                           
ACT152          FOR READ ONLY                                   
ACT152                                                      
ACT152     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RETURNED_CHK_CSR CURSOR WITH HOLD FOR             06350000
MFA-TR*        SELECT DATE_NOTICE_MAIL                                          
MFA-TR*              ,ITEM_ID                                                   
MFA-TR*              ,AMT_NOTICE                                                
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*          FROM CSS_CRED_COLL                                             
MFA-TR*         WHERE ACCOUNT_NO        = :CL-ACCOUNT-NO                        
MFA-TR*           AND CODE_NOTICE_TYPE  = 'N'                                   
MFA-TR*           AND DATE_NOTICE_MAIL  > :WS-INPUT-DATE                        
MFA-TR*           AND PROCESSED_CD      = ' '                                   
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSKR130 ENDS HERE  '.            
      *                                                                         
       LINKAGE SECTION.                                                 
                                                                        
       01  PARMIN.                                                      
           05  PARMLENGTH                  PIC S9(04) COMP.             
           05  PARM-COMMON-DATE            PIC X(10).                   
      *                                                                         
       PROCEDURE DIVISION USING PARMIN.                                 
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS MAIN PROCESSING OF PROGRAM                            *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION              THRU 0100-EXIT.     
           PERFORM 1000-MAIN-PROCESS                THRU 1000-EXIT.     
           PERFORM 9000-TERMINATE                   THRU 9000-EXIT.     
                                                                        
P00599     IF WS-SKIP-COUNTER > 0                                       
P00599        MOVE 03                               TO RETURN-CODE      
P00599     END-IF.                                                      
                                                                        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZATION.                                           *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           INITIALIZE WS-WORK-DAY-TABLE                                 
                      WS-FIN-WO-PATH-TABLE                              
                      WS-CURR-WQ-ITEM                                   
                      WS-SKIP-COUNTER.                                  
           SET PROCESS-ACCT                 TO TRUE.                    
           MOVE 1                           TO WS-WQ-INDX.              
      *                                                                         
           IF PARMLENGTH > 0                                            
               MOVE PARM-COMMON-DATE             TO WS-INPUT-DATE       
               DISPLAY '** PCSKR130 PROCESSING MESSAGE  **'             
               DISPLAY '** JCL OVERRIDE DATE BEING USED **'             
               DISPLAY '** DATE = ' WS-INPUT-DATE                       
               DISPLAY '**  PROCESSING CONTINUING       **'             
           ELSE                                                         
               PERFORM 0110-GET-JOB-PARM-DATE        THRU 0110-EXIT     
           END-IF.                                                      
      *                                                                         
      * GET DB2 SKIP ROW COUNT                                                  
                                                                        
           PERFORM 0150-GET-SKIP-ROW-COUNT      THRU 0150-EXIT.         
      *                                                                         
           MOVE WS-INPUT-DATE               TO WS-NEW-BUSINESS-DAY.     
           PERFORM 0117-LOAD-WORK-DAYS              THRU 0117-EXIT.     
      *                                                                         
           PERFORM 0120-OPEN-FILES                  THRU 0120-EXIT.     
           PERFORM 0130-PROCESS-FOR-RESTART         THRU 0130-EXIT.     
           PERFORM 0145-GET-DATABASE                THRU 0145-EXIT.     
           PERFORM 0125-LOAD-DELINQUENCY-TABLE      THRU 0125-EXIT      
           PERFORM 7000-READ-FCSBE00                THRU 7000-EXIT.     
           MOVE E-FBE00-ACCOUNT-NO          TO WS-PREVIOUS-ACCT-NO.     
           PERFORM 0220-LOAD-FIN-WO-PATH-TABLE      THRU 0220-EXIT.     
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0110-GET-JOB-PARM-DATE                                         *        
      ******************************************************************        
      *                                                                         
       0110-GET-JOB-PARM-DATE.                                          
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE              THRU 6251-EXIT.     
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE   THRU 6240-EXIT      
               MOVE WS-FCA00-COMMON-DATE    TO WS-INPUT-DATE            
               DISPLAY '** PCSKR130 PROCESSING MESSAGE **'              
               DISPLAY '** COMMON DATE BEING USED      **'              
               DISPLAY '** DATE = ' WS-INPUT-DATE                       
               DISPLAY '**  PROCESSING CONTINUING      **'              
           END-IF.                                                      
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0114-LOAD-F8-VARIABLE                                          *        
      ******************************************************************        
      *                                                                         
       0114-LOAD-F8-VARIABLE.                                           
      *                                                                         
           MOVE KA-COMPANY-NO         TO                                
               WS-FW-COMPANY-KA (WS-PATH-INDEX).                        
           MOVE KA-REG-GROUP-CD       TO                                
               WS-FW-REG-GROUP-CD-KA (WS-PATH-INDEX).                   
           MOVE KA-CODE-STATUS-REASON TO                                
               WS-FW-CODE-STAT-RSN-KA (WS-PATH-INDEX).                  
           MOVE KA-BHV-SCORE-RATING   TO                                
               WS-FW-BHV-SCORE-RTNG-KA (WS-PATH-INDEX).                 
           MOVE KA-FW-PATH-TYPE-CD    TO                                
               WS-FW-PATH-TYPE-CD-KA (WS-PATH-INDEX).                   
           MOVE WS-KA-FW-ACCT-TYPE-CD    TO                             
               WS-FW-ACCT-TYPE-CD-KA (WS-PATH-INDEX).                   
           MOVE WS-KA-GUARANTEED-IND     TO                             
               WS-GUARANTEED-IND-KA (WS-PATH-INDEX).                    
           MOVE F8-FW-ACTION-SEQ-NO   TO                                
               WS-FW-ACTION-SEQ-F8 (WS-PATH-INDEX).                     
           MOVE F8-FW-ACTION-TYPE-CD  TO                                
               WS-FW-ACTION-TYPE-F8 (WS-PATH-INDEX).                    
           MOVE F8-FW-FCST-DAYS-NM    TO                                
               WS-FW-ACTION-DAYS-F8 (WS-PATH-INDEX).                    
           MOVE F8-FW-FCST-TIME-CD    TO                                
               WS-FW-FRCST-TIME-CD-F8 (WS-PATH-INDEX).                  
           MOVE F8-FW-FCST-SOURCE-CD  TO                                
               WS-FW-FRCST-SOURCE-CD-F8 (WS-PATH-INDEX).                
           MOVE F8-FW-FCST-COLL-FL    TO                                
               WS-FW-COLLECTION-FL-F8 (WS-PATH-INDEX).                  
           MOVE F8-FW-ACTION-LIMIT-AM TO                                
               WS-FW-FRCST-ACTN-LMIT-F8 (WS-PATH-INDEX).                
           MOVE F8-FW-BUS-PROCESS-CD  TO                                
               WS-FW-BUS-PROCESS-CD-F8  (WS-PATH-INDEX).                
                                                                        
           SET WS-PATH-INDEX UP BY 1.                                   
                                                                        
           PERFORM 7076-FETCH-F8 THRU 7076-EXIT.                        
                                                                        
       0114-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0117-LOAD-WORK-DAYS                                            *        
      ******************************************************************        
      *                                                                         
       0117-LOAD-WORK-DAYS.                                             
      *                                                                         
           MOVE WS-INPUT-DATE TO WS-WORK-DAY (1)                        
           SET WD-INDX TO 2                                             
      *                                                                         
           PERFORM UNTIL WD-INDX > 100                                  
              PERFORM 6500-GET-NEXT-BUSINESS-DAY                        
                 THRU 6500-NEXT-BUSINESS-DAY-EXIT                       
                 MOVE WS-NEW-BUSINESS-DAY  TO WS-WORK-DAY (WD-INDX)     
                 SET WD-INDX UP BY 1                                    
           END-PERFORM.                                                 
      *                                                                         
       0117-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0120-OPEN-FILES.                                               *        
      ******************************************************************        
      *                                                                         
       0120-OPEN-FILES.                                                 
      *                                                                         
           OPEN INPUT FCSBE00-FILE.                                     
           IF FCSBE00-SUCCESSFUL                                        
              PERFORM 0500-PROCESS-BEGIN-REC        THRU  0500-EXIT     
                UNTIL E-FBE00-KEY-BREC NOT EQUAL LOW-VALUES             
           ELSE                                                         
              DISPLAY '********** PCSKR130 ABORT **********************'
              DISPLAY '* 0120-OPEN-FILES                              *'
              DISPLAY '* ERROR OPENING FCSBE00 FILE                   *'
              DISPLAY '* FILE STATUS : ' WS-FBE00-STATUS                
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR130 ABORT **********************'
              PERFORM 9900-ABEND                    THRU  9900-EXIT     
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSKR100-FILE.                                   
           IF FCSKR100-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR130 ABORT **********************'
              DISPLAY '* 0120-OPEN-FILES                              *'
              DISPLAY '* ERROR OPENING FCSKR100 FILE                  *'
              DISPLAY '* FILE STATUS : ' WS-FCSKR100-STATUS             
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR130 ABORT **********************'
              PERFORM 9900-ABEND                         THRU  9900-EXIT
           END-IF.                                                      
      *                                                                         
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0125-LOAD-DELINQUENCY-TABLE FOR AUTO CARD PAY                  *        
      ******************************************************************        
      *                                                                         
       0125-LOAD-DELINQUENCY-TABLE.                                     
      *                                                                         
           SET DELQ-INDX  TO 1.                                         
           PERFORM 7085-OPEN-DELINQUENCY-CSR             THRU 7085-EXIT.
           PERFORM 7090-FETCH-DELINQUENCY-CSR            THRU 7090-EXIT.
           PERFORM 0140-LOAD-DELINQ-VARIABLE             THRU 0140-EXIT 
             UNTIL SQLCODE = NOT-FOUND.                                 
           PERFORM 7095-CLOSE-DELINQUENCY-CSR            THRU 7095-EXIT.
      *                                                                         
       0125-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0130-PROCESS-FOR-RESTART.                                      *        
      ******************************************************************        
      *                                                                         
       0130-PROCESS-FOR-RESTART.                                        
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 6253-GET-FJC01-CHKP-LIMIT        THRU 6253-EXIT.     
      *                                                                         
           PERFORM 0200-CHECK-RESTART               THRU 0200-EXIT.     
      *                                                                         
           IF WS-THIS-IS-A-RESTART                                      
              PERFORM 0300-PREPARE-RESTART          THRU 0300-EXIT      
           END-IF.                                                      
      *                                                                         
       0130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0140-LOAD-DELINQ-VARIABLE FOR AUTO CARD PAY.                   *        
      ******************************************************************        
      *                                                                         
       0140-LOAD-DELINQ-VARIABLE.                                       
      *                                                                         
           ADD +1                TO WS-DELINQ-COUNT                     
           MOVE C8-COMPANY-NO    TO WS-COMPANY-NO-TB(DELQ-INDX).        
           MOVE C8-DELINQ-CD     TO WS-DELINQ-CD-TB(DELQ-INDX).         
           MOVE C8-DELINQ-VALUE  TO WS-DELINQ-VALUE-TB(DELQ-INDX).      
           SET DELQ-INDX UP BY 1                                        
           PERFORM 7090-FETCH-DELINQUENCY-CSR            THRU 7090-EXIT.
      *                                                                         
       0140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0145-GET-DATABASE.                                             *        
      ******************************************************************        
      *                                                                         
       0145-GET-DATABASE.                                               
      *                                                                         
           MOVE 'DATABASE'                TO C8-DELINQ-CD.              
           MOVE '01'                      TO C8-COMPANY-NO.             
           PERFORM 7010-SELECT-DELINQ-VALUE              THRU 7010-EXIT.
           MOVE C8-DELINQ-VALUE           TO WS-KR100-DATABASE.         
      *                                                                         
       0145-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0150-GET-SKIP-ROW-COUNT.                                     *          
      * GET THE SKIP ROW COUNT FROM JOB PARM TABLE                   *          
      ******************************************************************        
       0150-GET-SKIP-ROW-COUNT.                                         
                                                                        
           MOVE  WS-PGRMNAME               TO WS-PROGRAM.               
           MOVE  WS-PARM                   TO WS-COMMAND.               
           MOVE  ZEROS                     TO WS-SEQUENCE.              
           MOVE  SPACES                    TO WS-SYSIPT.                
           MOVE  WS-KEY-AREA               TO E-FJC01-KEY.              
                                                                        
           PERFORM 7600-START-FCSJC01      THRU  7600-EXIT.             
           PERFORM 7610-READ-FCSJC01       THRU  7610-EXIT              
              UNTIL (SKIP-ROW-CNT AND INPUT-ACTIVE)                     
              OR  END-OF-SYSIPT.                                        
                                                                        
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '** ' WS-PGRMNAME ' PROCESSING WARNING  **'       
              DISPLAY '**  SKIP-ROW-CNT PARM NOT ACTIVE     **'         
              DISPLAY '**  DEFAULT OF ' WS-DEFAULT-ACCTS-TO-SKIP        
                          ' WILL BE USED  **'                           
              DISPLAY '**  PROCESSING CONTINUING        **'             
              MOVE WS-DEFAULT-ACCTS-TO-SKIP                             
                                         TO WS-ACCTS-TO-SKIP            
           ELSE                                                         
              IF WS-NO-OF-ROWS-TO-SKIP    NUMERIC                       
                 MOVE WS-NO-OF-ROWS-TO-SKIP                             
                                         TO WS-ACCTS-TO-SKIP            
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY '**  ' WS-PGRMNAME ' PROCESSING WARNING  **'   
                 DISPLAY '**  SKIP-ROW-CNT PARM NOT NUMERIC  **'        
                 DISPLAY '**  DEFAULT OF ' WS-DEFAULT-ACCTS-TO-SKIP     
                         ' WILL BE USED  **'                            
                 DISPLAY '**  PROCESSING CONTINUING        **'          
                 MOVE WS-DEFAULT-ACCTS-TO-SKIP                          
                                         TO WS-ACCTS-TO-SKIP            
              END-IF                                                    
              PERFORM 7611-CLOSE                 THRU 7611-EXIT         
           END-IF.                                                      
      *                                                                         
       0150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0170-READ-ALL-RECS                                             *        
      * THIS IS CALLED WHEN THE PROGRAM NEEDS TO GET THE NEXT RECORD   *        
      * FROM THE BE00 QSAM FILE.                                       *        
      ******************************************************************        
      *                                                                         
       0170-READ-ALL-RECS.                                              
      *                                                                         
           IF WS-END-REC-PROCESSED EQUAL WS-Y                           
              IF E-FBE00-KEY-EREC EQUAL HIGH-VALUES                     
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '********** PCSKR130 ABORT *******************'
                 DISPLAY '* LAST RECORD IS NOT A CONTROL RECORD       *'
                 DISPLAY '* PROCESSING TERMINATED...                  *'
                 DISPLAY '********** PCSKR130 ABORT *******************'
                 PERFORM 9900-ABEND                 THRU 9900-EXIT      
              END-IF                                                    
           ELSE                                                         
              IF E-FBE00-KEY-EREC EQUAL HIGH-VALUES                     
                 MOVE WS-Y                TO WS-END-REC-PROCESSED       
              ELSE                                                      
                 IF E-FBE00-ACCOUNT-NO EQUAL WS-PREVIOUS-ACCT-NO        
                    PERFORM 0175-LOAD-BY-TABLE-ID   THRU 0175-EXIT      
                 ELSE                                                   
                    MOVE WS-Y             TO WS-FCSBE00-ACCT-FLAG       
                    GO TO 0170-EXIT                                     
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 7000-READ-FCSBE00                THRU 7000-EXIT.     
      *                                                                         
           IF END-OF-FCSBE00                                            
              IF E-FBE00-KEY-EREC  EQUAL HIGH-VALUES                    
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '********** PCSKR130 ABORT *******************'
                 DISPLAY '* PCSKR130 PROCESSING ERROR                 *'
                 DISPLAY '* LAST RECORD IS NOT A CONTROL RECORD       *'
                 DISPLAY '* PROCESSING TERMINATED                     *'
                 DISPLAY '********** PCSKR130 ABORT *******************'
                 PERFORM 9900-ABEND                 THRU 9900-EXIT      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0175-LOAD-BY-TABLE-ID.                                         *        
      * THIS PROCESS WILL DECIDE WHICH COPYBOOK AND ROUTINE TO USE TO  *        
      * LOAD THE DATA FROM THE BE00 FILE.                              *        
      ******************************************************************        
      *                                                                         
       0175-LOAD-BY-TABLE-ID.                                           
      *                                                                         
           MOVE E-FBE00-TABLE-ID          TO WS-CWS-TABLE-ID.           
      *                                                                         
      * DONT DO THE ACCOUNT ATTRIBUTE PROCESS IF IT IS NOT EXITS.               
           IF E-FBE00-TABLE-ID = '6650'                                 
              MOVE 'Y'                    TO WS-ATTRIBUTE-IND           
           END-IF.                                                      
      *                                                                         
           IF WS-TABLE-AT-BI-BG-AC-DA-CZ                                
              PERFORM 0800-LOAD-FBE38-WS-AREA       THRU 0800-EXIT      
           END-IF.                                                      
      *                                                                         
       0175-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0200-CHECK-RESTART.                                            *        
      ******************************************************************        
      *                                                                         
       0200-CHECK-RESTART.                                              
      *                                                                         
           MOVE PROGRAM-NAME              TO RF-NAME-PROGRAM.           
           MOVE WS-PART-NO                TO RF-PARTITION-NO            
                                             WS-CHKP-PART-NO.           
           MOVE 1                         TO RF-DUP-CNTRL-NO.           
      *                                                                         
           PERFORM 7900-SELECT-RESTART              THRU 7900-EXIT.     
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              MOVE RF-RESTART-DATA-TEXT   TO WS-RESTART-DATA            
              IF WS-RESTART-PROCESS-TYPE NUMERIC                        
                 MOVE WS-Y                TO WS-IS-THIS-A-RESTART       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0205-LOAD-COMP-DELINQ-1                                        *        
      ******************************************************************        
      *                                                                         
       0205-LOAD-COMP-DELINQ-1.                                         
      *                                                                         
           EVALUATE TRUE                                                
               WHEN WS-COMPANY-NO-TB(DELQ-INDX) = WS-COMPANY-NO-AT      
                AND WS-DELINQ-CD-TB(DELQ-INDX)  = 'AUTO-CARD-PAY-DAYS'  
                    MOVE WS-DELINQ-VALUE-TB(DELQ-INDX) TO               
                         WS-AUTO-CARD-PAY-DAYS                          
           END-EVALUATE.                                                
           SET DELQ-INDX UP BY 1.                                       
           MOVE WS-COMPANY-NO-AT TO  WS-CURRENT-COMPANY.                
      *                                                                         
       0205-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0215-GET-COMPANY-DELINQ                                        *        
      ******************************************************************        
      *                                                                         
       0215-GET-COMPANY-DELINQ.                                         
      *                                                                         
           IF WS-COMPANY-NO-AT NOT EQUAL WS-CURRENT-COMPANY             
              EVALUATE WS-COMPANY-NO-AT                                 
                  WHEN '26'                                             
                       SET DELQ-INDX      TO 1                          
                       PERFORM 0205-LOAD-COMP-DELINQ-1 THRU 0205-EXIT   
                         UNTIL DELQ-INDX > WS-DELINQ-COUNT              
                  WHEN '01'                                             
                       SET DELQ-INDX      TO 1                          
                       PERFORM 0205-LOAD-COMP-DELINQ-1 THRU 0205-EXIT   
                         UNTIL DELQ-INDX > WS-DELINQ-COUNT              
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                         
       0215-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0220-LOAD-FIN-WO-PATH-TABLE                                    *        
      ******************************************************************        
      *                                                                         
       0220-LOAD-FIN-WO-PATH-TABLE.                                     
      *                                                                         
                                                                        
           PERFORM 7075-OPEN-F8  THRU 7075-EXIT.                        
           PERFORM 7076-FETCH-F8 THRU 7076-EXIT.                        
           SET WS-PATH-INDEX TO 1.                                      
           PERFORM 0114-LOAD-F8-VARIABLE THRU 0114-EXIT                 
                   UNTIL SQLCODE = NOT-FOUND.                           
           PERFORM 7077-CLOSE-F8 THRU 7077-EXIT.                        
      *                                                                         
       0220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0300-PREPARE-RESTART.                                          *        
      ******************************************************************        
      *                                                                         
       0300-PREPARE-RESTART.                                            
      *                                                                         
P00599     IF WS-THIS-IS-A-RESTART                                      
P00599        DISPLAY '*******************************************'     
P00599        DISPLAY '*****   THIS IS A RESTART OF PCSKR130   ***'     
P00599        DISPLAY '*******************************************'     
P00599        OPEN INPUT FCSKR10R-FILE                                  
P00599        IF FCSKR10R-SUCCESSFUL                                    
P00599           CONTINUE                                               
P00599        ELSE                                                      
P00599           DISPLAY '0300-ERROR ON FCSKR10R OPEN.  STATUS IS '     
P00599                                         WS-FCSKR10R-STATUS       
P00599           PERFORM 9900-ABEND             THRU 9900-EXIT          
P00599        END-IF                                                    
P00599        PERFORM WS-RESTART-FCSKR10R-CTR TIMES                     
P00599           READ FCSKR10R-FILE                                     
P00599             IF FCSKR10R-SUCCESSFUL                               
P00599                WRITE FIOKR100 FROM  FIOKR10R                     
P00599                ADD 1                     TO  WS-FCSKR10R-CNTR    
P00599                IF FCSKR100-SUCCESSFUL                            
P00599                   CONTINUE                                       
P00599                ELSE                                              
P00599                   DISPLAY 'ERROR ON FCSKR100 REWRITE. STATUS IS '
P00599                                              WS-FCSKR100-STATUS  
P00599                   PERFORM 9900-ABEND     THRU 9900-EXIT          
P00599                END-IF                                            
P00599             ELSE                                                 
P00599                DISPLAY 'PREMATURE EOF ON FCSKR10R RESTART'       
P00599                DISPLAY 'PROCESSING TERMINATED'                   
P00599                PERFORM 9900-ABEND        THRU 9900-EXIT          
P00599             END-IF                                               
P00599        END-PERFORM                                               
P00599        CLOSE FCSKR10R-FILE                                       
P00599        PERFORM 7000-READ-FCSBE00         THRU 7000-EXIT          
P00599          UNTIL WS-FCSBE00-REC-CNTR = WS-RESTART-BE00-CNT         
P00599     END-IF.                                                      
P00599                                                                  
P00599 0300-EXIT.                                                       
P00599     EXIT.                                                        
P00599                                                                  
      ******************************************************************        
      * 0400-PREPARE-PRECOMMIT.                                        *        
      * MOVE ALL THE REQUIRED RESTART RECORD VALUES PRIOR TO UPDATE    *        
      ******************************************************************        
      *                                                                         
       0400-PREPARE-PRECOMMIT.                                          
      *                                                                         
           ADD  1                         TO WS-CHKP-SEQ-NO.            
           MOVE 1                         TO WS-RESTART-PROCESS-TYPE.   
           MOVE WS-C                      TO WS-RESTART-JOB-STATUS.     
           MOVE WS-INPUT-DATE             TO WS-RESTART-COMMON-DATE.    
           MOVE WS-CHKP-SEQ-NO            TO WS-RESTART-CHKP-SEQ-NO.    
           MOVE WS-ACCOUNT-NO-AT          TO WS-RESTART-ACCOUNT-NO.     
           COMPUTE WS-RESTART-BE00-CNT = WS-FCSBE00-REC-CNTR - 1.       
P00599     MOVE WS-FCSKR100-CNTR          TO WS-RESTART-FCSKR10R-CTR.   
           MOVE WS-SKIP-COUNTER           TO WS-RESTART-SKIP-COUNTER.   
      *                                                                         
       0400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0500-PROCESS-BEGIN-REC.                                        *        
      ******************************************************************        
      *                                                                         
       0500-PROCESS-BEGIN-REC.                                          
      *                                                                         
           PERFORM 7000-READ-FCSBE00                THRU 7000-EXIT.     
      *                                                                         
           EVALUATE TRUE                                                
              WHEN END-OF-FCSBE00                                       
                   DISPLAY '********** PCSKR130 ABORT *****************'
                   DISPLAY '* 0500-PROCESS-BEGIN-REC                  *'
                   DISPLAY '* FCSBE00 FILE IS EMPTY                   *'
                   DISPLAY '* PROCESSING TERMINATED                   *'
                   DISPLAY '********** PCSKR130 ABORT *****************'
                   PERFORM 9900-ABEND               THRU  9900-EXIT     
              WHEN E-FBE00-KEY-BREC EQUAL LOW-VALUES                    
                   IF E-FBE00-CREATE-DATE-BREC NOT = WS-INPUT-DATE      
                      DISPLAY '********** PCSKR130 ABORT **************'
                      DISPLAY '* 0500-PROCESS-BEGIN-REC               *'
                      DISPLAY '* FCSBE00 CREATE DATE NOT = RUN DATE   *'
                      DISPLAY '* BE00 CREATE DATE: '                    
                                              E-FBE00-CREATE-DATE-BREC  
                      DISPLAY '* RUN  DATE: ' WS-INPUT-DATE             
                      DISPLAY '* PROCESSING TERMINATED                *'
                      DISPLAY '********** PCSKR130 ABORT **************'
                      PERFORM 9900-ABEND            THRU 9900-EXIT      
                   END-IF                                               
                   IF E-FBE00-DB-PART-BREC GREATER THAN ZERO            
                      MOVE E-FBE00-DB-PART-BREC TO WS-PART-NO           
                   ELSE                                                 
                      DISPLAY '*********** PCSKR130 ABORT *************'
                      DISPLAY '* 0500-PROCESS-BEGIN-REC               *'
                      DISPLAY '* FCSBE00 PART NO NOT GREATER THAN 0   *'
                      DISPLAY '* PROCESSING TERMINATED                *'
                      DISPLAY '*********** PCSKR130 ABORT *************'
                      PERFORM 9900-ABEND            THRU 9900-EXIT      
                   END-IF                                               
                   SET WS-BEGIN-RECS-PROCESSED TO TRUE                  
              WHEN WS-BEGIN-RECS-PROCESSED                              
                   IF E-FBE00-KEY-BREC EQUAL HIGH-VALUES OR LOW-VALUES  
                      IF E-FBE00-KEY-BREC EQUAL HIGH-VALUES AND         
                         NO-DATA-RECORD-FOUND AND                       
                         E-FBE00-RECORD-COUNT-EREC EQUAL ZERO           
                         DISPLAY '******* PCSKR130 MESSAGE*************'
                         DISPLAY '* 0500-PROCESS-BEGIN-REC            *'
                         DISPLAY '* FCSBE00 FILE IS EMPTY             *'
                         DISPLAY '* PROCESSING CONTINUING...          *'
                         DISPLAY '******* PCSKR130 ABORT **************'
                         PERFORM 9900-ABEND         THRU 9900-EXIT      
                      END-IF                                            
                   ELSE                                                 
                      SET DATA-RECORD-FOUND    TO TRUE                  
                      ADD 1                    TO WS-FCSBE00-REC-CNTR   
                      PERFORM 6241-GET-FCA00-BILL-CYCLES  THRU 6241-EXIT
                   END-IF                                               
              WHEN OTHER                                                
                   DISPLAY '********** PCSKR130 ABORT **************'   
                   DISPLAY '* 0500-PROCESS-BEGIN-REC               *'   
                   DISPLAY '* FIRST RECORD IS NOT A CNTL REC       *'   
                   DISPLAY '* PROCESSING TERMINATED                *'   
                   DISPLAY '********** PCSKR130 ABORT **************'   
                   PERFORM 9900-ABEND               THRU  9900-EXIT     
           END-EVALUATE.                                                
      *                                                                         
       0500-EXIT.                                                       
           EXIT.                                                        
      * INITIALIZE BE38 VARIABLES : 0609-                                       
       COPY CPD0052B.                                                           
                                                                        
      * INITIALIZE BE38 BILL PRINT CWS10009 VARIABLES : 0690-                   
       COPY CPD0101C.                                                           
                                                                        
      * LOAD BE38 VARIABLES BY TABLE ID                                         
       COPY CPD0050B.                                                           
                                                                        
      * LOAD BE38 BILL PRINT CWS10009 VARIABLES BY TABLE ID                     
       COPY CPD0102C.                                                           
      *                                                                         
      ******************************************************************        
      * 1000-MAIN-PROCESS.                                             *        
      ******************************************************************        
      *                                                                         
       1000-MAIN-PROCESS.                                               
      *                                                                         
P00599     PERFORM 8887-SAVEPOINT                   THRU 8887-EXIT      
           PERFORM 1100-PROCESS-FCSBE00             THRU 1100-EXIT      
             UNTIL END-OF-BE00.                                         
      *                                                                         
P00599     ADD WS-COMMIT-COUNTER          TO WS-FCSKR100-CNTR.          
                                                                        
           IF WS-PROCESS-COUNTER = 0  AND                               
              WS-SKIP-COUNTER    > 0                                    
              DISPLAY '********** PCSKR130 ABORT **********************'
              DISPLAY '* 1000-MAIN-PROCESS                            *'
              DISPLAY '* ALL THE ACCOUNTS IN THE INPUT FILE ARE       *'
              DISPLAY '* SKIPPED FROM PROCESSING                      *'
              DISPLAY '* ACCOUNTS PROCESSED : ' WS-PROCESS-COUNTER      
              DISPLAY '* ACCOUNTS SKIPPED   : ' WS-SKIP-COUNTER         
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR130 ABORT **********************'
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF                                                       
                                                                        
           PERFORM 0400-PREPARE-PRECOMMIT           THRU 0400-EXIT.     
           MOVE SPACES                    TO WS-RESTART-JOB-COMPLETE.   
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-B                   TO WS-RESTART-JOB-STATUS      
           ELSE                                                         
              MOVE WS-A                   TO WS-RESTART-JOB-STATUS      
           END-IF.                                                      
      *                                                                         
           IF WS-COMMIT-COUNTER > 0                                     
              PERFORM 8890-COMMIT                   THRU 8890-EXIT      
              MOVE ZEROS                  TO WS-COMMIT-COUNTER          
           END-IF                                                       
           PERFORM 8920-DEL-RESTART-REC             THRU 8920-EXIT.     
      *                                                                         
I01687     MOVE WS-ACCOUNT-NO-AT               TO YP-ACCOUNT-NO.        
I01687     MOVE 'LPCASSESSED'                  TO YP-ATTRIBUTE-DESC.    
I01687     PERFORM 8930-DEL-ACCT-ATTRIBUTE THRU 8930-EXIT.              
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              DISPLAY 'PCSKR130 RERUN COMPLETED'                        
           ELSE                                                         
              DISPLAY 'PCSKR130 COMPLETED SUCCESSFULLY'                 
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1100-PROCESS-FCSBE00.                                          *        
      * LOAD ALL BE00 RECORDS OF AN ACCOUNT TO CWS10000 VARIABLES AND  *        
      * READ THROUGH TILL IT FINDS A DIFFERENT ACCOUNT.                *        
      ******************************************************************        
      *                                                                         
       1100-PROCESS-FCSBE00.                                            
      *                                                                         
           IF (E-FBE00-KEY-BREC = HIGH-VALUES OR LOW-VALUES)            
              CONTINUE                                                  
           ELSE                                                         
              PERFORM  0609-INITIALIZE-FBE36-WS-AREA   THRU 0609-EXIT   
              PERFORM  0690-INITIALIZE-FBE38-WS-AREA   THRU 0690-EXIT   
      *                                                                         
              MOVE WS-N                      TO WS-FCSBE00-ACCT-FLAG    
              MOVE WS-N                      TO WS-ATTRIBUTE-IND        
              MOVE E-FBE00-ACCOUNT-NO        TO WS-PREVIOUS-ACCT-NO     
      *                                                                         
      * READ FROM THE BE00 FILE FOR ALL RECORDS FOR THE SAME ACCOUNT.           
              PERFORM 0170-READ-ALL-RECS               THRU 0170-EXIT   
                UNTIL FCSBE00-ACCT-NO-CHANGED OR END-OF-BE00            
      *                                                                         
              MOVE WS-ACCOUNT-NO-AT             TO WS-DISPLAY-ACCOUNT   
              IF WS-CODE-ACCT-STAT-AT = 'B'                             
                 DISPLAY 'PROCESSING ACCT# ' WS-DISPLAY-ACCOUNT         
                 PERFORM 2000-OUTPUT-PROCESS   THRU 2000-EXIT           
              ELSE                                                      
                 DISPLAY WS-DISPLAY-ACCOUNT ' IS NOT A FINAL BILL ACCT,'
                                            ' WILL NOT BE PROCESSED. '  
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P0599A******************************************************************        
P0599A* 1360-CHECK-WQ-FL                                               *        
P0599A******************************************************************        
P0599A*                                                                         
P0599A 1360-CHECK-WQ-FL.                                                
P0599A*                                                                         
P0599A     MOVE WS-PGRMNAME                      TO WS-SRCE-PGM-ID.     
P0599A     MOVE WS-COMPANY-NO-AT                 TO WS-COMP-NO.         
P0599A     MOVE WS-MISC-CATEGORY-ID              TO WS-CATEGORY-ID.     
P0599A*                                                                         
P0599A     PERFORM 4900-GET-WQ-GEN-FL          THRU 4900-CPD346-EXIT.   
P0599A*                                                                         
P0599A     IF WS-WQ-GEN-FL = 'Y' OR FL-NOT-FOUND                        
P0599A       PERFORM 2810-CREATE-WORK-QUEUE    THRU 2810-EXIT           
P0599A     END-IF.                                                      
P0599A*                                                                         
P0599A 1360-EXIT.                                                       
P0599A     EXIT.                                                        
      *                                                                         
P0599A******************************************************************        
P0599A* 1365-CHECK-REG-PROF                                            *        
P0599A******************************************************************        
P0599A*                                                                         
P0599A 1365-CHECK-REG-PROF.                                             
P0599A*                                                                         
P0599A     MOVE SPACES                           TO WS-REG-GRP-CD.      
P0599A     MOVE SPACE                            TO WS-SEN-FL.          
P0599A     IF SEB-DATABASE                                              
P0599A       PERFORM 7040-CHECK-FOR-REGULATED  THRU 7040-EXIT           
P0599A       IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
P0599A         MOVE LR-REG-GROUP-CD TO WS-REG-GRP-CD                    
P0599A         MOVE LR-SENIOR-FL    TO WS-SEN-FL                        
P0599A       END-IF                                                     
P0599A     END-IF.                                                      
P0599A*                                                                         
P0599A 1365-EXIT.                                                       
P0599A     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-OUTPUT-PROCESS.                                           *        
      ******************************************************************        
      *                                                                         
       2000-OUTPUT-PROCESS.                                             
      *                                                                         
      * INITIALIZE WS VARIABLE                                                  
           INITIALIZE  WS-ON-OFF-CYCLE-IND                              
                       WS-AVOID-LPC-DT-1H                               
                       WS-BILL-CRED-MSG-ID-1H                           
                       WS-BILL-CRED-NOT-ID-1H                           
                       WS-WQ-ITEMS-MF                                   
                       WS-CURR-WQ-ITEM                                  
                       1H-BILL-CRED-MSG-ID                              
                       1H-BILL-CRED-NOT-ID                              
P0599A                 WS-NSF-HIST-FOUND                                
P0599A                 WS-RTC-DT-NOTICE-MAIL                            
P0599A                 WS-RTC-AMT-NOTICE                                
ACT048                 WS-HOLD-DATE-NOTICE-DUE                          
P0599A                 KD-FW-ACTION-COMMENTS.                           
      *                                                                         
      *                                                                         
           SET PROCESS-ACCT               TO TRUE                       
P00599     MOVE 'N'                       TO WS-WQ-INSERT.              
           MOVE 1                         TO WS-WQ-INDX.                
           MOVE WS-CODE-OFF-CYCLE-CALC    TO WS-ON-OFF-CYCLE-IND.       
           MOVE WS-ACCOUNT-NO-AT          TO AT-ACCOUNT-NO              
P00599                                       FW-ACCOUNT-NO.             
           PERFORM 7910-GET-AT-CODES-DATA           THRU 7910-EXIT.     
           MOVE AT-CODES-DATA-PRESENT     TO WS-CODES-DATA-PRESENT-AT   
                                             WS-CODES-DATA-PRESENT.     
      *                                                                         
           PERFORM 2100-PROCESS-ACCOUNT             THRU 2100-EXIT.     
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-PROCESS-ACCOUNT.                                          *        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-ACCOUNT.                                            
      *                                                                         
P0599A     PERFORM 1365-CHECK-REG-PROF         THRU 1365-EXIT.          
P0599A*                                                                         
P0599A     IF WS-CODE-GUARANTOR = 'A'                                   
P0599A       MOVE WS-GUARNTR-MSG   TO WS-MISC-MSG-TEXT                  
P0599A       MOVE +35              TO WS-MISC-MSG-LEN                   
P0599A       MOVE 543              TO WS-MISC-CATEGORY-ID               
P0599A       PERFORM 1360-CHECK-WQ-FL         THRU 1360-EXIT            
P0599A     END-IF                                                       
      *                                                                         
           PERFORM 3000-NONUTL-UTL-CHRGS-ARRERS   THRU 3000-EXIT.       
      *                                                                         
           PERFORM 5700-PROCESS-FINAL          THRU 5700-EXIT.          
      *                                                                         
P0599A     MOVE WS-ACCOUNT-NO-AT           TO CL-ACCOUNT-NO.            
ACT152     PERFORM 7020-OPEN-RETURNED-CHK-CSR THRU 7020-EXIT.           
ACT152     PERFORM 7021-FETCH-RETURNED-CHK-CSR THRU 7021-EXIT.          
ACT152     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
P0599A        MOVE WS-ACCOUNT-NO-AT        TO KD-ACCOUNT-NO             
P0599A        MOVE WS-RTC-DT-NOTICE-MAIL   TO KD-FW-ACTION-DT           
P0599A                                        WS-FW-ACTION-DT           
P0599A        PERFORM 6600-PROCESS-CALC-NEW-SEQ-NO THRU                 
P0599A                                              6600-CPD348-EXIT    
P0599A        MOVE '90205'                 TO KD-FW-ACTION-TYPE-CD      
P0599A        MOVE WS-RTC-AMT-NOTICE       TO KD-FW-ACTION-AM           
P0599A        MOVE WS-NEW-SEQ-NO           TO KD-FW-SEQ-NO              
P0599A        MOVE SPACES                  TO KD-FW-MANUAL-FL           
P0599A        PERFORM 7023-RETURN-CHK-AMT          THRU 7023-EXIT       
P0599A        PERFORM 7025-CHECK-NSF-HIST          THRU 7025-EXIT       
P0599A        IF NSF-HIST-FOUND                                         
P0599A           MOVE NH-NSF-TIMESTMP TO KD-FW-ACTION-COMMENTS-TEXT     
P0599A           MOVE 26              TO KD-FW-ACTION-COMMENTS-LEN      
P0599A        ELSE                                                      
P0599A           MOVE SPACES TO KD-FW-ACTION-COMMENTS-TEXT              
P0599A        END-IF                                                    
P0599A        MOVE 'FN'                    TO KD-FW-BUS-PROCESS-CD      
P0599A        MOVE SPACES                  TO KD-FW-PROCESSED-FL        
P0599A        PERFORM 8250-INSERT-FINAL-WO-ACTN THRU 8250-EXIT          
ACT152        PERFORM 7021-FETCH-RETURNED-CHK-CSR THRU 7021-EXIT        
ACT152     END-PERFORM.                                                 
ACT152     PERFORM 7022-CLOSE-RETURNED-CHK-CSR THRU 7022-EXIT.          
      *                                                                         
           IF MATCH-FOUND                                               
             PERFORM 5900-BUILD-COMMON-FINAL   THRU 5900-EXIT           
             PERFORM 8910-DELETE-CRED-COLL     THRU 8910-EXIT           
             PERFORM 5948-LOAD-BILL-CRED-DET   THRU 5948-EXIT           
             IF WS-CREDIT-GROUP-AT NOT EQUAL WS-SUB                     
                PERFORM 5910-BUILD-ROW-A-FINAL THRU 5910-EXIT           
                PERFORM 5920-BUILD-ROW-P-FINAL THRU 5920-EXIT           
                PERFORM 5930-BUILD-ROW-Q-FINAL THRU 5930-EXIT           
             END-IF                                                     
             PERFORM 3500-CHECK-SECURITIES     THRU 3500-CPD340-EXIT    
             IF AT-CODES-DATA-PRESENT NOT = WS-CODES-DATA-PRESENT-AT    
                MOVE WS-ACCOUNT-NO-AT          TO AT-ACCOUNT-NO         
                MOVE WS-CODES-DATA-PRESENT-AT  TO AT-CODES-DATA-PRESENT 
                PERFORM 8215-UPDATE-ACCOUNT    THRU 8215-EXIT           
             END-IF                                                     
           END-IF.                                                      
                                                                        
P00599     IF PROCESS-ACCT                                              
P00599        PERFORM 2800-GENERATE-OUTPUT     THRU 2800-EXIT           
P00599     ELSE                                                         
P00599        PERFORM 2200-ERROR-CHECK         THRU 2200-EXIT           
P00599     END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07704000
      * 2200-ERROR-CHECK.                                              *        
      * EXCEPTION HANDLING AND WQ PROCESS                              *        
      ******************************************************************07704000
      *                                                                 63240000
       2200-ERROR-CHECK.                                                
      *                                                                 63240000
           IF SKIP-ACCT                                                 
              PERFORM 8889-ROLLBACK-TO-SAVEPOINT THRU 8889-EXIT         
              DISPLAY 'SKIPPING ACCOUNT NO: ' WS-DISPLAY-ACCOUNT        
              ADD +1                             TO WS-SKIP-COUNTER     
              IF WS-SKIP-COUNTER = WS-ACCTS-TO-SKIP                     
                 DISPLAY '********** PCSKR130 ABORT *******************'
                 DISPLAY '* 2200-ERROR-CHECK                          *'
                 DISPLAY '* SKIP-COUNTER EQUAL TO DEFAULT SKIP COUNT  *'
                 DISPLAY '* NO OF ACCTS SKIPPED : ' WS-SKIP-COUNTER     
                 DISPLAY '* DEFAULT SKIP COUNT  : ' WS-ACCTS-TO-SKIP    
                 DISPLAY '* PROCESSING TERMINATED                     *'
                 DISPLAY '********** PCSKR130 ABORT *******************'
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
P00599* INSERT WQ'S                                                             
              PERFORM 2900-GENERATE-WQ           THRU 2900-EXIT         
                      VARYING WS-WQ-INDX FROM 1 BY 1                    
                      UNTIL   WS-WQ-INDX  > 50 OR                       
                              WS-WQ-CATEGORY-ID-WF(WS-WQ-INDX) = ZERO   
P00599        PERFORM 8887-SAVEPOINT             THRU 8887-EXIT         
           END-IF.                                                      
      *                                                                 63240000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 2300-UPDATE-CORR-MAIL-DATA                                              
      ***************************************************************           
      *                                                                         
       2300-UPDATE-CORR-MAIL-DATA.                                      
      *                                                                         
           MOVE WS-ACCOUNT-NO-MW               TO MW-ACCOUNT-NO         
           MOVE WS-BARCODE-UNIQUE-ID-MW        TO MW-BARCODE-UNIQUE-ID  
           MOVE WS-TRACKING-STATUS-CD-MW       TO MW-TRACKING-STATUS-CD.
           MOVE 'C'                            TO                       
                                             MW-TRACKING-STATUS-CD(1:1).
           MOVE WS-SYSTEM                      TO MW-USER-ID.           
           MOVE WS-PGRMNAME                    TO MW-APPL-PROGRAM-ID    
           PERFORM 8225-UPDATE-CORR-MAIL-STAT  THRU 8225-EXIT.          
           ADD  +1                             TO WS-PROCESS-COUNTER.   
      *                                                                         
       2300-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
P00599******************************************************************07704000
P00599* 2800-GENERATE-OUTPUT.                                          *        
P00599******************************************************************07704000
P00599                                                                  
P00599 2800-GENERATE-OUTPUT.                                            
P00599                                                                  
P00599     PERFORM 8000-WRITE-BILL-CRED-DET         THRU 8000-EXIT.     
P00599* UPDATE TRACKING STATUS CODE                                             
P00599     IF WS-ACCOUNT-NO-MW > 0                                      
P00599        PERFORM 2300-UPDATE-CORR-MAIL-DATA    THRU 2300-EXIT      
P00599     END-IF.                                                      
P00599                                                                  
P00599     ADD 1                          TO WS-COMMIT-COUNTER          
P00599     IF WS-COMMIT-COUNTER = WS-CHKP-LUW-LIMIT OR                  
P00599        WS-COMMIT-COUNTER = WS-CHKP-UPD-LIMIT                     
P00599        ADD WS-COMMIT-COUNTER       TO WS-FCSKR100-CNTR           
P00599        PERFORM 0400-PREPARE-PRECOMMIT        THRU 0400-EXIT      
P00599        PERFORM 8890-COMMIT                   THRU 8890-EXIT      
P00599        MOVE ZEROS                  TO WS-COMMIT-COUNTER          
P00599     END-IF                                                       
P00599                                                                  
P00599     PERFORM 8887-SAVEPOINT                   THRU 8887-EXIT.     
P00599                                                                  
P00599 2800-EXIT.                                                       
P00599     EXIT.                                                        
P00599                                                                  
      ******************************************************************        
      * 2810-CREATE-WORK-QUEUE                                         *        
      ******************************************************************        
      *                                                                         
       2810-CREATE-WORK-QUEUE.                                          
      *                                                                         
ACT051     INITIALIZE CWS00077-FIELDS.                                  
ACT051     INITIALIZE WS-77-COMMENTS.                                   
      *                                                                         
      * POPULATE WORK QUEUE VARIABLE FOR INSERT WORK QUEUE                      
ACT051     MOVE WS-ACCOUNT-NO-AT          TO WS-77-ACCOUNT-NO.          
ACT051     MOVE WS-CUSTOMER-NO-AT         TO WS-77-CUSTOMER-NO.         
ACT051     MOVE WS-PREMISE-NO-AT          TO WS-77-PREMISE-NO.          
ACT051     MOVE WS-LOCAL-OFFICE-AT        TO WS-77-LOCAL-OFFICE.        
ACT051     MOVE WS-MISC-CATEGORY-ID       TO WS-77-CATEGORY-ID.         
ACT051     MOVE WS-MISC-MSG-TEXT          TO WS-77-COMMENTS-TEXT.       
ACT051     MOVE WS-MISC-MSG-LEN           TO WS-77-COMMENTS-LEN.        
ACT051     IF WS-MISC-CATEGORY-ID = 543                                 
ACT051       MOVE 5                         TO WS-77-ROUTE-CATEGORY     
ACT051       MOVE 'H'                       TO WS-77-PRIORITY           
ACT051     ELSE                                                         
ACT051       MOVE 4                         TO WS-77-ROUTE-CATEGORY     
ACT051       MOVE 'N'                       TO WS-77-PRIORITY           
ACT051     END-IF.                                                      
ACT051                                                                  
ACT051     MOVE WS-INPUT-DATE             TO WS-77-DATE-REQUIRED        
ACT051                                       WS-INPUT-DATE-26(1:10)     
ACT051     MOVE WS-INPUT-ZERO             TO WS-INPUT-DATE-26(11:16)    
ACT051     MOVE WS-INPUT-DATE-26          TO WS-77-DATE-CREATED         
ACT051                                                                  
ACT051     MOVE WS-PGRMNAME               TO WS-77-CREATED-BY           
           DISPLAY ' ' WS-77-COMMENTS                                   
           PERFORM 8895-INSERT-WORK-QUEUE           THRU 8895-EXIT.     
      *                                                                         
       2810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07704000
      * 2900-GENERATE-WQ.                                              *        
      * INSERTS ANY WQ'S TO DB2.                                       *        
      ******************************************************************07704000
      *                                                                 63240000
       2900-GENERATE-WQ.                                                
      *                                                                 63240000
ACT051     INITIALIZE CWS00077-FIELDS.                                  
ACT051     INITIALIZE WS-77-COMMENTS.                                   
      *                                                                         
ACT051     MOVE WS-WQ-CATEGORY-ID-WF (WS-WQ-INDX)                       
ACT051                                           TO WS-77-CATEGORY-ID   
ACT051     MOVE WS-WQ-PRIORITY-WF (WS-WQ-INDX)   TO WS-77-PRIORITY      
ACT051     MOVE WS-WQ-ROUTE-CATEGORY-WF (WS-WQ-INDX)                    
ACT051                                           TO WS-77-ROUTE-CATEGORY
ACT051     MOVE WS-WQ-COMMENTS-WF (WS-WQ-INDX)   TO WS-77-COMMENTS      
ACT051     MOVE ZERO                             TO WS-77-SERV-ORDER-NO 
ACT051     MOVE WS-INPUT-DATE                    TO WS-77-DATE-REQUIRED 
ACT051                                            WS-INPUT-DATE-26(1:10)
ACT051     MOVE WS-INPUT-ZERO                    TO                     
ACT051                                           WS-INPUT-DATE-26(11:16)
ACT051     MOVE WS-INPUT-DATE-26                 TO WS-77-DATE-CREATED  
ACT051     MOVE WS-ACCOUNT-NO-AT                 TO WS-77-ACCOUNT-NO    
ACT051     MOVE WS-PREMISE-NO-AT                 TO WS-77-PREMISE-NO    
ACT051     MOVE WS-CUSTOMER-NO-AT                TO WS-77-CUSTOMER-NO   
ACT051     MOVE SPACES                           TO WS-77-USER-ID-ORIG  
ACT051     MOVE SPACES                           TO WS-77-RESP-AREA-ID  
ACT051     MOVE WS-LOCAL-OFFICE-AT               TO WS-77-LOCAL-OFFICE  
ACT051     MOVE ZERO                             TO                     
ACT051                                           WS-77-FREE-FORM-LEN    
ACT051     MOVE LOW-VALUES                       TO                     
ACT051                                           WS-77-FREE-FORM-TXT    
ACT051     MOVE WS-PGRMNAME                      TO WS-77-CREATED-BY    
ACT051                                                                  
           DISPLAY ' ' WS-WQ-COMMENTS-WF (WS-WQ-INDX).                  
           PERFORM 8895-INSERT-WORK-QUEUE        THRU 8895-EXIT.        
                                                                        
      *                                                                 63240000
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3000-NONUTL-UTL-CHRGS-ARRERS                                   *        
      ******************************************************************        
      *                                                                         
       3000-NONUTL-UTL-CHRGS-ARRERS.                                    
      *                                                                         
           PERFORM 7030-WORK-DATE-20-25-55-80 THRU 7030-EXIT.           
      *                                                                         
           PERFORM VARYING WS-AR-DATA-INDX FROM 1 BY 1                  
             UNTIL WS-AR-DATA-INDX > WS-AC-MAX-ENTRY OR                 
                   WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) = ZERO            
                   PERFORM 4010-CALC-30-60-90            THRU 4010-EXIT 
           END-PERFORM                                                  
      *                                                                         
           COMPUTE WS-TOTAL-UTILITY-CHARGES =                           
                   WS-CURR-UTIL-CHARGES-CALC +                          
                   WS-PAST-UTIL-CHARGES-CALC.                           
      *                                                                         
           COMPUTE WS-TOTAL-NONUTIL-CHARGES =                           
                   WS-CURR-NONUTIL-CHARGES-CALC +                       
                   WS-PAST-NONUTIL-CHARGES-CALC.                        
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  3500-CHECK-SECURITIES.                                       *         
      *  THIS PARAGRAPH WILL CONTROL CHECKING TO SEE IF A SURETY BOND *         
      *  HAS EXPIRED.                                                 *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD00340                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 4010-CALC-30-60-90.                                            *        
      ******************************************************************        
      *                                                                         
       4010-CALC-30-60-90.                                              
      *                                                                         
           EVALUATE WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)           
               WHEN 19                                                  
               WHEN 29                                                  
               WHEN 39                                                  
               WHEN 129                                                 
                    PERFORM 5020-CALC-NON-UTL-DELINQ                    
                                                  THRU 5020-CPD339-EXIT 
               WHEN 20                                                  
               WHEN 30                                                  
               WHEN 40                                                  
               WHEN 45                                                  
               WHEN 60                                                  
               WHEN 110                                                 
                    PERFORM 5010-CALC-UTL-DELINQ  THRU 5010-CPD339-EXIT 
               WHEN 100                                                 
                    SET WS-CNT-INDX TO  1                               
                    SEARCH WS-CONTRACT-DATA                             
                        AT END                                          
                           CONTINUE                                     
                      WHEN WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) =         
                           WS-ACCOUNT-NO-CT (WS-CNT-INDX)      AND      
                           WS-ITEM-ID-AC (WS-AR-DATA-INDX)    =         
                           WS-CNT-ITEM-ID-CT  (WS-CNT-INDX)             
                           PERFORM 5020-CALC-NON-UTL-DELINQ             
                              THRU 5020-CPD339-EXIT                     
                    END-SEARCH                                          
           END-EVALUATE.                                                
      *                                                                         
       4010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P0599A******************************************************************        
P0599A* 4900-GET-WQ-GEN-FL                                             *        
P0599A* 5200-SEARCH-WQ-PGM-CNTL-TBL                                    *        
P0599A******************************************************************        
P0599A     EXEC SQL                                                             
P0599A        INCLUDE CPD00346                                                  
P0599A     END-EXEC.                                                            
P0599A*                                                                         
      ******************************************************************        
      * 5010-CALC-UTL-DELINQ                                           *        
      * 5020-CALC-NON-UTL-DELINQ                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00339                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  5050-GET-AUTO-CARD-PYMT-DATA                                  *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00338                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 5700-PROCESS-FINAL                                             *        
      ******************************************************************        
      *                                                                         
       5700-PROCESS-FINAL.                                              
      *                                                                         
           MOVE WS-ACCOUNT-NO-AT           TO GU-ACCOUNT-NO.            
           MOVE SPACES                     TO WS-HAS-ACTIVE-GUAR.       
           PERFORM 7100-SELECT-GUARANTOR         THRU 7100-EXIT.        
           IF WS-HAS-ACTIVE-GUAR = 'Y'                                  
               MOVE WS-HAS-ACTIVE-GUAR     TO WS-GUARANTEED-IND         
           ELSE                                                         
               MOVE SPACES TO WS-GUARANTEED-IND                         
           END-IF.                                                      
      *                                                                         
           IF WS-TOTAL-AR-BALANCE-AT > 0                                
               MOVE WS-TOTAL-AR-BALANCE-AT TO WS-HOLD-FINAL-BILL-AMT    
           ELSE                                                         
               MOVE 0                      TO WS-HOLD-FINAL-BILL-AMT    
           END-IF.                                                      
      *                                                                         
           EVALUATE WS-CREDIT-GROUP-AT                                  
               WHEN 'D'                                                 
                   MOVE 'N' TO WS-ACCT-TYPE-CD                          
               WHEN OTHER                                               
                   MOVE 'U' TO WS-ACCT-TYPE-CD                          
           END-EVALUATE.                                                
      *                                                                         
           IF WS-OFF-CYCLE-REBILL                                       
               PERFORM 5705-PROCESS-OFF-REBILL       THRU 5705-EXIT     
           END-IF.                                                      
      *                                                                         
           MOVE '0'                      TO WS-FW-MATCH-FL.             
           MOVE 'Y'                      TO WS-FST-OCCUR.               
           PERFORM VARYING WS-PATH-INDEX FROM 1 BY 1                    
                  UNTIL WS-PATH-INDEX > 2000 OR WS-KD-INDEX > 50        
                   OR WS-FW-COMPANY-KA(WS-PATH-INDEX) = SPACES          
                 IF WS-FW-COMPANY-KA(WS-PATH-INDEX)         =           
                     WS-COMPANY-NO-AT           AND                     
                     WS-FW-REG-GROUP-CD-KA(WS-PATH-INDEX)   =           
P0599A               WS-REG-GRP-CD              AND                     
                     WS-FW-CODE-STAT-RSN-KA(WS-PATH-INDEX)  =           
                     WS-CODE-STATUS-REASON-AT   AND                     
                     WS-FW-BHV-SCORE-RTNG-KA(WS-PATH-INDEX) =           
                     WS-BHV-RATING-HIST-CZ(1:1) AND                     
                     WS-FW-ACCT-TYPE-CD-KA(WS-PATH-INDEX)   =           
                     WS-ACCT-TYPE-CD            AND                     
                     WS-GUARANTEED-IND-KA(WS-PATH-INDEX)    =           
                     WS-GUARANTEED-IND                                  
                     SET MATCH-FOUND  TO TRUE                           
                                                                        
                     PERFORM 5720-GET-WO-PATH         THRU 5720-EXIT    
                 END-IF                                                 
           END-PERFORM.                                                 
      *                                                                         
           IF MATCH-FOUND                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ERROR IN FORECASTING NO MATCHING PATH ACTIONS'      
                  TO WS-MISC-MSG-TEXT                                   
              MOVE +45 TO WS-MISC-MSG-LEN                               
              MOVE +17 TO WS-MISC-CATEGORY-ID                           
              PERFORM 2810-CREATE-WORK-QUEUE    THRU 2810-EXIT          
P00599        SET SKIP-ACCT                     TO TRUE                 
           END-IF.                                                      
      *                                                                         
       5700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5705-PROCESS-OFF-REBILL                                        *        
      ******************************************************************        
      *                                                                         
       5705-PROCESS-OFF-REBILL.                                         
      *                                                                         
           PERFORM 7078-OPEN-OFF-REBILL    THRU 7078-EXIT.              
           PERFORM 7079-FETCH-OFF-REBILL   THRU 7079-EXIT.              
           PERFORM 5710-OFF-REBILL-COLLECT THRU 5710-EXIT               
                   UNTIL SQLCODE = NOT-FOUND.                           
      *                                                                         
           MOVE WS-ACCOUNT-NO-AT TO WS-ACCOUNT-NO-KD-TEMP               
                                    CL-ACCOUNT-NO.                      
           PERFORM 8900-DELETE-FINAL-WO    THRU 8900-EXIT.              
           MOVE ZERO             TO CL-ITEM-ID.                         
           PERFORM 8910-DELETE-CRED-COLL       THRU 8910-EXIT.          
      *                                                                         
           PERFORM 7080-CLOSE-OFF-REBILL   THRU 7080-EXIT.              
      *                                                                         
       5705-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5710-OFF-REBILL-COLLECT                                        *        
      ******************************************************************        
      *                                                                         
       5710-OFF-REBILL-COLLECT.                                         
      *                                                                         
                                                                        
           PERFORM 7650-GET-CURR-DATE-STAMP    THRU 7650-EXIT           
           MOVE CURRENT-TIMESTAMP     TO FM-FW-HIST-SEQ-TS              
           MOVE FW-FW-PATH-TYPE-CD    TO FM-FW-PATH-TYPE-CD             
           MOVE KD-ACCOUNT-NO         TO FM-ACCOUNT-NO                  
           MOVE KD-FW-ACTION-TYPE-CD  TO FM-FW-ACTION-TYPE-CD           
           MOVE KD-FW-SEQ-NO          TO FM-FW-COLL-SEQ-NO              
           MOVE KD-FW-ACTION-DT       TO FM-FW-ACTION-DT                
           MOVE KD-FW-ACTION-AM       TO FM-FW-ACTION-AM                
           MOVE IZ-CUSTOMER-NO        TO FM-CUSTOMER-NO                 
           MOVE IZ-CODE-COLLEC-AGNCY  TO FM-CODE-COLLEC-AGNCY           
           MOVE IZ-COLL-AGY-SUB-CD    TO FM-COLL-AGY-SUB-CD             
           MOVE IZ-WITHDRAW-AM        TO FM-WITHDRAW-AM                 
           MOVE IZ-WITHDRAW-DT        TO FM-WITHDRAW-DT                 
           MOVE IZ-WITHDRAW-REASON-CD TO FM-WITHDRAW-REASON-CD          
           PERFORM 8500-INSERT-FIN-WO-COL-HST   THRU 8500-EXIT.         
      *                                                                         
           PERFORM 7079-FETCH-OFF-REBILL   THRU 7079-EXIT.              
      *                                                                         
       5710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5720-GET-WO-PATH                                               *        
      ******************************************************************        
      *                                                                         
       5720-GET-WO-PATH.                                                
      *                                                                         
ACT320     SET WS-KD-INDEX TO 1.                                        
           IF WS-FST-OCCUR = 'Y'                                        
              PERFORM 5800-LOAD-WS-FINAL-WO     THRU 5800-EXIT          
P00599        PERFORM 8900-DELETE-FINAL-WO      THRU 8900-EXIT          
              PERFORM 8600-INSERT-FINAL-WO      THRU 8600-EXIT          
           END-IF.                                                      
      *                                                                         
           MOVE WS-FW-ACTION-TYPE-F8(WS-PATH-INDEX)                     
                                         TO KD-FW-ACTION-TYPE-CD.       
                                                                        
           MOVE WS-FW-PATH-TYPE-CD-KA (WS-PATH-INDEX)                   
                                         TO F8-FW-PATH-TYPE-CD.         
                                                                        
           IF ((WS-FST-OCCUR = 'Y') AND                                 
              (WS-FW-FRCST-SOURCE-CD-F8(WS-PATH-INDEX) = 'F' OR         
               WS-FW-FRCST-SOURCE-CD-F8(WS-PATH-INDEX) = 'P'))          
              SET WD-INDX                TO 1                           
              SET PRV-WD-INDX            TO WD-INDX                     
           END-IF.                                                      
      *                                                                         
           EVALUATE WS-FW-FRCST-SOURCE-CD-F8(WS-PATH-INDEX)             
               WHEN 'F'                                                 
                 SET WD-INDX             TO 1                           
                 SET WD-INDX UP BY                                      
                     WS-FW-ACTION-DAYS-F8(WS-PATH-INDEX)                
               WHEN 'P'                                                 
                 SET WD-INDX             TO PRV-WD-INDX                 
                 SET WD-INDX UP BY                                      
                     WS-FW-ACTION-DAYS-F8(WS-PATH-INDEX)                
           END-EVALUATE.                                                
      *                                                                         
           IF WD-INDX > 100                                             
              MOVE 'ERROR IN FORECASTING INDEX OUT OF BOUNDS'           
                 TO WS-MISC-MSG-TEXT                                    
              MOVE +41                   TO WS-MISC-MSG-LEN             
              MOVE +137                  TO WS-MISC-CATEGORY-ID         
              PERFORM 2810-CREATE-WORK-QUEUE      THRU 2810-EXIT        
P00599        SET SKIP-ACCT              TO TRUE                        
           ELSE                                                         
              SET PRV-WD-INDX            TO WD-INDX                     
              MOVE WS-WORK-DAY (WD-INDX) TO  KD-FW-ACTION-DT            
              MOVE WS-FW-ACTION-SEQ-F8(WS-PATH-INDEX)  TO KD-FW-SEQ-NO  
              MOVE WS-FW-ACTION-TYPE-F8(WS-PATH-INDEX) TO               
                   KD-FW-ACTION-TYPE-CD                                 
              MOVE 0                    TO KD-FW-ACTION-AM              
      *                                                                         
              MOVE WS-ACCOUNT-NO-AT     TO KD-ACCOUNT-NO                
              MOVE SPACES               TO                              
                    WS-FIN-WO-MANUAL-IND-KD(WS-KD-INDEX)                
                    WS-FIN-WO-ACT-CMNTS-TXT(WS-KD-INDEX)                
              MOVE 0 TO WS-FIN-WO-ACT-CMNTS-LEN(WS-KD-INDEX)            
              MOVE WS-FW-BUS-PROCESS-CD-F8(WS-PATH-INDEX) TO            
                    KD-FW-BUS-PROCESS-CD                                
              MOVE SPACE                TO KD-FW-MANUAL-FL              
           END-IF                                                       
      *                                                                         
           IF WS-CREDIT-GROUP-AT EQUAL WS-SUB                           
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 8700-INSERT-FINAL-WO-ACTION  THRU 8700-EXIT       
           END-IF                                                       
      *                                                                         
           IF WS-FST-OCCUR = 'Y' AND                                    
                     ( WS-FW-BUS-PROCESS-CD-F8(WS-PATH-INDEX) = 'FN'    
ACT048                        OR                                        
ACT048                 WS-FW-BUS-PROCESS-CD-F8(WS-PATH-INDEX) = 'WO')   
             MOVE 1                     TO WS-DAY-DUE                   
             SET WD-INDX DOWN BY WS-DAY-DUE                             
             MOVE WS-WORK-DAY (WD-INDX) TO WS-HOLD-DATE-NOTICE-DUE      
             MOVE 'N'                   TO WS-FST-OCCUR                 
           END-IF.                                                      
      *                                                                         
           PERFORM 0215-GET-COMPANY-DELINQ  THRU 0215-EXIT.             
      *                                                                         
       5720-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5800-LOAD-WS-FINAL-WO                                          *        
      ******************************************************************        
      *                                                                         
       5800-LOAD-WS-FINAL-WO.                                           
      *                                                                         
            MOVE WS-ACCOUNT-NO-AT       TO FW-ACCOUNT-NO.               
            MOVE ZEROS                  TO FW-ITEM-ID.                  
            MOVE WS-HOLD-FINAL-BILL-AMT TO FW-FINAL-BILL-AM.            
            MOVE WS-INPUT-DATE          TO FW-FINAL-BILL-DT.            
            MOVE WS-SEN-FL              TO FW-SENIOR-FL.                
            MOVE WS-REG-GRP-CD          TO FW-REG-GROUP-CD.             
            MOVE SPACES                 TO FW-MANUAL-OVRRD-IND.         
            MOVE WS-GUARANTEED-IND-KA(WS-PATH-INDEX) TO                 
                                         FW-GUARANTEED-IND.             
            MOVE WS-FW-PATH-TYPE-CD-KA(WS-PATH-INDEX) TO                
                                       FW-FW-PATH-TYPE-CD.              
      *                                                                         
       5800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5900-BUILD-COMMON-FINAL                                        *        
      * MOVES COMMON DATE FOR BILLED ROWS                              *        
      ******************************************************************        
      *                                                                         
       5900-BUILD-COMMON-FINAL.                                         
      *                                                                         
           MOVE WS-ACCOUNT-NO-AT        TO CL-ACCOUNT-NO.               
           MOVE ZERO                    TO CL-ITEM-ID.                  
           MOVE WS-INPUT-DATE           TO CL-DATE-BILL.                
           MOVE SPACES                  TO CL-CODE-SPECIAL-TYPE.        
           MOVE ZEROS                   TO CL-CODE-MESSAGE-TYPE.        
           MOVE WS-WORK-DAY  (2)        TO CL-DATE-NOTICE-MAIL.         
           MOVE LOW-VALUES              TO CL-DATE-CREDIT-ACTION.       
           MOVE WS-HOLD-DATE-NOTICE-DUE TO CL-DATE-NOTICE-DUE.          
      *                                                                         
       5900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5910-BUILD-ROW-A-FINAL                                         *        
      * CREATES BILLED ROW (FOR FINAL BILLED ACCT) ON CSS_CRED_COLL    *        
      ******************************************************************        
      *                                                                         
       5910-BUILD-ROW-A-FINAL.                                          
      *                                                                         
           MOVE 'A'              TO CL-CODE-NOTICE-TYPE.                
                                                                        
           IF WS-CORRECTED-BILL = 'Y'                                   
              MOVE 91019 TO CL-CODE-MESSAGE-TYPE                        
           END-IF.                                                      
                                                                        
           MOVE WS-HOLD-FINAL-BILL-AMT TO CL-AMT-NOTICE.                
                                                                        
           IF CL-AMT-NOTICE LESS THAN OR EQUAL 0                        
              MOVE LOW-VALUES TO CL-DATE-NOTICE-DUE                     
           END-IF.                                                      
      *                                                                         
           MOVE SPACES           TO CL-CODE-FRCST-CR-GRP.               
      *                                                                         
           PERFORM 8300-INSERT-CRED-COLL     THRU 8300-EXIT.            
                                                                        
       5910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5920-BUILD-ROW-P-FINAL                                         *        
      * CREATES BILLED ROW (FOR FINAL BILLED ACCT) ON CSS_CRED_COLL    *        
      ******************************************************************        
      *                                                                         
       5920-BUILD-ROW-P-FINAL.                                          
      *                                                                         
           MOVE 'P'              TO CL-CODE-NOTICE-TYPE.                
                                                                        
           MOVE WS-TOTAL-UTILITY-CHARGES TO CL-AMT-NOTICE.              
                                                                        
           IF CL-AMT-NOTICE LESS THAN OR EQUAL 0                        
              MOVE LOW-VALUES TO CL-DATE-NOTICE-DUE                     
           END-IF.                                                      
      *                                                                         
           MOVE WS-CODE-FRCST-CR-GRP-CL (WS-CL-INDX) TO                 
                                     CL-CODE-FRCST-CR-GRP.              
      *                                                                         
           PERFORM 8300-INSERT-CRED-COLL     THRU 8300-EXIT.            
      *                                                                         
       5920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5930-BUILD-ROW-Q-FINAL                                         *        
      * CREATES BILLED ROW (FOR FINAL BILLED ACCT) ON CSS_CRED_COLL    *        
      ******************************************************************        
      *                                                                         
       5930-BUILD-ROW-Q-FINAL.                                          
      *                                                                         
           MOVE 'Q'              TO CL-CODE-NOTICE-TYPE.                
                                                                        
                                                                        
           MOVE WS-TOTAL-NONUTIL-CHARGES TO CL-AMT-NOTICE.              
                                                                        
           IF CL-AMT-NOTICE LESS THAN OR EQUAL 0                        
              MOVE LOW-VALUES TO CL-DATE-NOTICE-DUE                     
           END-IF.                                                      
      *                                                                         
           MOVE WS-CODE-FRCST-CR-GRP-CL (WS-CL-INDX) TO                 
                                     CL-CODE-FRCST-CR-GRP.              
      *                                                                         
           PERFORM 8300-INSERT-CRED-COLL     THRU 8300-EXIT.            
      *                                                                         
       5930-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5948-LOAD-BILL-CRED-DET                                        *        
      ******************************************************************        
      *                                                                         
       5948-LOAD-BILL-CRED-DET.                                         
      *                                                                         
           MOVE WS-TOTAL-UTILITY-CHARGES TO 1H-UTL-TOT-DUE-AM.          
           MOVE WS-TOTAL-NONUTIL-CHARGES TO 1H-NONUTL-TOT-DUE-AM.       
           PERFORM 7650-GET-CURR-DATE-STAMP       THRU 7650-EXIT.       
      *                                                                         
           MOVE WS-ACCOUNT-NO-AT          TO 1H-ACCOUNT-NO              
                                             WS-ACCOUNT-NO-1H.          
           MOVE WS-COMPANY-NO-AT          TO 1H-COMPANY-NO              
                                             WS-COMPANY-NO-1H.          
           MOVE WS-BILL-NO-BI             TO 1H-BILL-NO                 
                                             WS-BILL-NO-1H.             
           MOVE WS-REG-GRP-CD             TO 1H-REG-GROUP-CD            
                                             WS-REG-GROUP-CD-1H.        
           MOVE CURRENT-TIMESTAMP         TO 1H-CREATED-TS              
                                             WS-CREATED-TS-1H.          
           MOVE WS-PAST-UTIL-CHARGES-CALC TO 1H-UTL-ARREARS-AM          
                                             WS-UTL-ARREARS-AM-1H.      
           MOVE WS-CURR-UTIL-CHARGES-CALC TO 1H-UTL-CURR-AM             
                                             WS-UTL-CURR-AM-1H.         
P00599     MOVE WS-PAST-NONUTIL-CHARGES-CALC                            
P00599                                    TO 1H-NONUTL-ARREARS-AM       
                                             WS-NONUTL-ARREARS-AM-1H.   
           MOVE WS-PASTDUE-CHARGES-CALC   TO 1H-TOT-ARREARS-AM          
                                             WS-TOT-ARREARS-AM-1H.      
           MOVE WS-TOTAL-AR-BALANCE-AT    TO 1H-TOT-DUE-AM              
                                             WS-TOT-DUE-AM-1H.          
           MOVE CL-DATE-NOTICE-DUE        TO 1H-TOT-DUE-DT              
                                             WS-TOT-DUE-DT-1H.          
           MOVE WS-CURRENT-CHARGES-CALC   TO 1H-TOT-CURR-AM             
                                             WS-TOT-CURR-AM-1H.         
           COMPUTE 1H-UTL-TOT-DUE-AM = WS-CURR-UTIL-CHARGES-CALC +      
                                       WS-PAST-UTIL-CHARGES-CALC.       
           MOVE 0                         TO 1H-UTL-TOT-DUE-AM          
                                             WS-UTL-TOT-DUE-AM-1H.      
           MOVE ZEROS                     TO 1H-UTL-NORM-NOT-AM         
                                             WS-UTL-NORM-NOT-AM-1H.     
           MOVE 0                         TO 1H-UTL-EXCP-NOT-AM         
                                             WS-UTL-EXCP-NOT-AM-1H.     
           MOVE SPACES                    TO 1H-UTL-NORM-DUE-DT         
                                             WS-UTL-NORM-DUE-DT-1H.     
           MOVE SPACES                    TO 1H-UTL-EXCP-DUE-DT         
                                             WS-UTL-EXCP-DUE-DT-1H.     
           MOVE 0                         TO 1H-NONUTL-TOT-DUE-AM       
                                             WS-NONUTL-TOT-DUE-AM-1H.   
P00599     MOVE WS-CURR-NONUTIL-CHARGES-CALC                            
P00599                                    TO 1H-NONUTL-CURR-AM          
                                             WS-NONUTL-CURR-AM-1H.      
           MOVE 0                         TO 1H-NONUTL-NORM-NOT-AM      
                                             WS-NONUTL-NORM-NOT-AM-1H.  
           MOVE 0                         TO 1H-NONUTL-EXCP-NOT-AM      
                                             WS-NONUTL-EXCP-NOT-AM-1H.  
           MOVE SPACES                    TO 1H-NONUTL-NORM-DUE-DT      
                                             WS-NONUTL-NORM-DUE-DT-1H.  
           MOVE SPACE                     TO 1H-NONUTL-EXCP-DUE-DT      
                                             WS-NONUTL-EXCP-DUE-DT-1H.  
           MOVE WS-LPC-UTIL-ASSESSED-CALC TO 1H-LPC-AM                  
                                             WS-LPC-AMT-1H.             
           MOVE WS-LPC-NONUT-ASSESSED-CALC TO 1H-LPN-AM                 
                                              WS-LPN-AMT-1H.            
      * CPD00338 HAS BEEN CALLED TO GET AUTO CARD PAYMENT DATE                  
           IF WS-TOT-DUE-DT-1H > SPACES                                 
              MOVE WS-HOLD-DATE-NOTICE-DUE TO WS-CURR-CHG-DUE-DT        
              PERFORM 5050-GET-AUTO-CARD-PYMT-DATA                      
                                          THRU 5050-CPD338-EXIT         
           END-IF.                                                      
           MOVE WS-AUTO-CARD-PYMT-DT      TO 1H-AUTO-PAYMENT-DT         
                                             WS-AUTO-PAYMENT-DT-1H.     
           MOVE SPACES                    TO 1H-ADDITIONAL-DUE-DT       
                                             WS-ADDITIONAL-DUE-DT-1H.   
           PERFORM 8400-INSERT-BILL-CRED-DET       THRU 8400-EXIT.      
      *                                                                         
       5948-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6240-GET-FCA00-COMMON-DATE                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00040                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6241-GET-FCA00-BILL-CYCLES.                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00041                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00037                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6253-GET-FJC01-CHKP-LIMIT.                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00034                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    6500-GET-NEXT-BUSINESS-DAY                                **         
      *    6525-PREV-BUSINESS-DAY                                    **         
      *    COPYBOOK CPD00322 CONTAINS THE LOGIC FOR FINDING          **         
      *    THE NEXT AND PREVIOUS BUSINESS DAY.                       **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00322                                                 
           END-EXEC.                                                            
      *                                                                         
P00599**************************************************************            
P00599**  6600-PROCESS-CALC-NEW-SEQ-NO.                            *            
P00599**************************************************************            
P00599     EXEC SQL                                                             
P00599         INCLUDE CPD00348                                                 
P00599     END-EXEC.                                                            
P00599*                                                                         
      ******************************************************************        
      * READS FCSBE00 FILE FOR INPUT                                   *        
      ******************************************************************        
      *                                                                         
       7000-READ-FCSBE00.                                               
      *                                                                         
           READ FCSBE00-FILE AT END                                     
                MOVE 'Y'                      TO WS-END-OF-BE00-SW      
                GO TO 7000-EXIT.                                        
                                                                        
           IF FCSBE00-SUCCESSFUL                                        
              IF E-FBE00-KEY-BREC NOT EQUAL HIGH-VALUES OR              
                 E-FBE00-KEY-BREC NOT EQUAL LOW-VALUES                  
                 IF DATA-RECORD-FOUND                                   
                    MOVE E-FBE00-DATA         TO E-FBE38-DATA           
                    MOVE E-FBE00-COMPANY-NO   TO E-FBE38-COMPANY-NO     
                    MOVE E-FBE00-LOCAL-OFFICE TO E-FBE38-LOCAL-OFFICE   
                    MOVE E-FBE00-ACCOUNT-NO   TO E-FBE38-ACCOUNT-NO     
                    MOVE E-FBE00-TABLE-ID     TO E-FBE38-TABLE-ID       
                    MOVE E-FBE00-PREMISE-NO   TO E-FBE38-PREMISE-NO     
                    MOVE E-FBE00-MST-ACCT-NO  TO E-FBE38-MST-ACCT-NO    
                    MOVE E-FBE00-MST-SUB-IND  TO E-FBE38-MST-SUB-IND    
                    MOVE E-FBE00-SORT-KEY     TO E-FBE38-SORT-KEY       
                    ADD 1                     TO WS-FCSBE00-REC-CNTR    
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSKR130 ABORT **********************'
              DISPLAY '* READ ERROR : BE00 FILE                       *'
              DISPLAY '* CURRENT PARA   : 7000                        *'
              DISPLAY '* FILE-STATUS    : ' WS-FBE00-STATUS             
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR130 ABORT **********************'
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010-SELECT-DELINQ-VALUE                                       *        
      ******************************************************************        
      *                                                                         
       7010-SELECT-DELINQ-VALUE.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD    = :C8-DELINQ-CD                       
                 AND COMPANY_NO   = :C8-COMPANY-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD    = :C8-DELINQ-CD                               
MFA-TR*          AND COMPANY_NO   = :C8-COMPANY-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
ACT152                                       WS-DISPLAY-SQLCODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '********** PCSKR130  ABORT ********************'
               DISPLAY '* 7010-SELECT-DELINQ-VALUE                    *'
ACT152         DISPLAY '* SQLCODE IS   ' WS-DISPLAY-SQLCODE             
               DISPLAY '* DELINQ_CD  : ' C8-DELINQ-CD                   
               DISPLAY '* COMPANY_NO : ' C8-COMPANY-NO                  
               DISPLAY '* PROGRAM ABORTING...                         *'
               DISPLAY '********** PCSKR130  ABORT ********************'
               PERFORM 9900-ABEND                   THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT152******************************************************************24630000
ACT152*   7020-OPEN-RETURNED-CHK-CSR                                   *24640000
ACT152******************************************************************24650000
ACT152 7020-OPEN-RETURNED-CHK-CSR.                                      
ACT152*                                                                 24670000
ACT152     EXEC SQL                                                     
ACT152        OPEN RETURNED_CHK_CSR                                     
ACT152     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT152*                                                                 24710000
ACT152     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
ACT152                     WS-DISPLAY-SQLCODE.                          
ACT152*                                                                 24730000
ACT152     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT152        NEXT SENTENCE                                             
ACT152     ELSE                                                         
ACT152        DISPLAY '********** PCSKR130  ABORT ********************' 
ACT152        DISPLAY '* ** 7020 OPEN:  RETURN CODE ERROR - OPEN     *' 
ACT152        DISPLAY '* SQLCODE IS   ' WS-DISPLAY-SQLCODE              
ACT152        DISPLAY '* ACCOUNT NO : ' CL-ACCOUNT-NO                   
ACT152        DISPLAY '* DATE NOTICE MAIL: ' WS-RTC-DT-NOTICE-MAIL      
ACT152        DISPLAY '* PROGRAM ABORTING...                         *' 
ACT152        DISPLAY '********** PCSKR130  ABORT ********************' 
ACT152        PERFORM 9900-ABEND                   THRU 9900-EXIT       
ACT152     END-IF.                                                      
ACT152*                                                                 24840000
ACT152 7020-EXIT.                                                       
ACT152     EXIT.                                                        
ACT152*                                                                 24870000
ACT152******************************************************************24880000
ACT152*   7021-FETCH-RETURNED-CHK-CSR                                  *24890000
ACT152******************************************************************24900000
ACT152 7021-FETCH-RETURNED-CHK-CSR.                                     
ACT152*                                                                 24920000
ACT152     EXEC SQL                                                     
ACT152        FETCH RETURNED_CHK_CSR INTO                               
ACT152           :WS-RTC-DT-NOTICE-MAIL                                 
ACT152          ,:CL-ITEM-ID                                            
ACT152          ,:WS-RTC-AMT-NOTICE                                     
ACT152          ,:CL-LAST-UPDATE-TS                                     
ACT152     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT152*                                                                 25060000
ACT152     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
ACT152                     WS-DISPLAY-SQLCODE.                          
ACT152*                                                                         
ACT152     IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
ACT152        CONTINUE                                                  
ACT152     ELSE                                                         
ACT152        DISPLAY '********** PCSKR130  ABORT ********************' 
ACT152        DISPLAY '* 7021 FETCH: RETURN CODE ERROR - FETCH       *' 
ACT152        DISPLAY '* SQLCODE IS   ' WS-DISPLAY-SQLCODE              
ACT152        DISPLAY '* ACCOUNT NO : ' CL-ACCOUNT-NO                   
ACT152        DISPLAY '* DATE NOTICE MAIL: ' WS-RTC-DT-NOTICE-MAIL      
ACT152        DISPLAY '* PROGRAM ABORTING...                         *' 
ACT152        DISPLAY '********** PCSKR130  ABORT ********************' 
ACT152        PERFORM 9900-ABEND THRU 9900-EXIT                         
ACT152     END-IF.                                                      
ACT152                                                                  
ACT152 7021-EXIT.                                                       
ACT152     EXIT.                                                        
ACT152                                                                  
ACT152******************************************************************25260000
ACT152*   7022-CLOSE-RETURNED-CHK-CSR                                  *25270000
ACT152******************************************************************25280000
ACT152 7022-CLOSE-RETURNED-CHK-CSR.                                     
ACT152                                                                  
ACT152     EXEC SQL                                                     
ACT152        CLOSE RETURNED_CHK_CSR                                    
ACT152     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT152                                                                  
ACT152     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
ACT152                     WS-DISPLAY-SQLCODE.                          
ACT152                                                                  
ACT152     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT152        NEXT SENTENCE                                             
ACT152     ELSE                                                         
ACT152        DISPLAY '********** PCSKR130  ABORT ********************' 
ACT152        DISPLAY '* 7022 CLOSE:  RETURN CODE ERROR - CLOSE      *' 
ACT152        DISPLAY '* SQLCODE IS   ' WS-DISPLAY-SQLCODE              
ACT152        DISPLAY '* ACCOUNT NO : ' CL-ACCOUNT-NO                   
ACT152        DISPLAY '* DATE NOTICE MAIL: ' WS-RTC-DT-NOTICE-MAIL      
ACT152        DISPLAY '* PROGRAM ABORTING...                         *' 
ACT152        DISPLAY '********** PCSKR130  ABORT ********************' 
ACT152        PERFORM 9900-ABEND                   THRU 9900-EXIT       
ACT152     END-IF.                                                      
ACT152                                                                  
ACT152 7022-EXIT.                                                       
ACT152     EXIT.                                                        
ACT152*                                                                         
ACT152******************************************************************        
ACT152* 7023-RETURN-CHK-AMT                                      *              
ACT152******************************************************************        
ACT152 7023-RETURN-CHK-AMT.                                             
ACT152*                                                                         
ACT152     EXEC SQL                                                     
ACT152        SELECT AMT_NOTICE                                         
ACT152          INTO :CL-AMT-NOTICE                                     
ACT152          FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                        
ACT152         WHERE ACCOUNT_NO        = :CL-ACCOUNT-NO                 
ACT152           AND CODE_NOTICE_TYPE  = 'W'                            
ACT152           AND ITEM_ID           = :CL-ITEM-ID                    
ACT152           AND PROCESSED_CD      = ' '                            
ACT152                                                           
ACT152                                                      
ACT152     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AMT_NOTICE                                                 
MFA-TR*         INTO :CL-AMT-NOTICE                                             
MFA-TR*         FROM CSS_CRED_COLL                                              
MFA-TR*        WHERE ACCOUNT_NO        = :CL-ACCOUNT-NO                         
MFA-TR*          AND CODE_NOTICE_TYPE  = 'W'                                    
MFA-TR*          AND ITEM_ID           = :CL-ITEM-ID                            
MFA-TR*          AND PROCESSED_CD      = ' '                                    
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7023                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT152                                                                  
ACT152     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
ACT152                                       WS-DISPLAY-SQLCODE.        
ACT152                                                                  
ACT152     IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
ACT152       CONTINUE                                                   
ACT152     ELSE                                                         
ACT152       DISPLAY '********** PCSKR130  ABORT ********************'  
ACT152       DISPLAY '* 7023-RETURN-CHK-AMT                         *'  
ACT152       DISPLAY '* SQLCODE IS   ' WS-DISPLAY-SQLCODE               
ACT152       DISPLAY '* ACCOUNT NO : ' CL-ACCOUNT-NO                    
ACT152       DISPLAY '* ITEM-ID    : ' CL-ITEM-ID                       
ACT152       DISPLAY '* PROGRAM ABORTING...                         *'  
ACT152       DISPLAY '********** PCSKR130  ABORT ********************'  
ACT152       PERFORM 9900-ABEND                   THRU 9900-EXIT        
ACT152     END-IF.                                                      
ACT152*                                                                         
ACT152 7023-EXIT.                                                       
ACT152     EXIT.                                                        
      *                                                                         
P0599A****************************************************************          
P0599A**  7025-CHECK-NSF-HIST                                       **          
P0599A****************************************************************          
P0599A 7025-CHECK-NSF-HIST.                                             
P0599A*                                                                         
P0599A     EXEC SQL                                                     
P0599A        SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           NSF_TIMESTMP), 121), ' ', '-'), ':', '.')                           
P0599A          INTO  :NH-NSF-TIMESTMP :WS-NULL-IND-1                   
P0599A          FROM  CSS_NSF_HIST                                      
P0599A         WHERE ACCOUNT_NO         =  :AT-ACCOUNT-NO               
P0599A           AND NSF_TIMESTMP       <  CIS.CHAR2TIMESTAMP(
                                                     :CL-LAST-UPDATE-TS
              )           
ACT152           AND RETURN_CHECK_AMT   =  :CL-AMT-NOTICE               
P0599A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  MAX(NSF_TIMESTMP)                                         
MFA-TR*         INTO  :NH-NSF-TIMESTMP :WS-NULL-IND-1                           
MFA-TR*         FROM  CSS_NSF_HIST                                              
MFA-TR*        WHERE ACCOUNT_NO         =  :AT-ACCOUNT-NO                       
MFA-TR*          AND NSF_TIMESTMP       <  :CL-LAST-UPDATE-TS                   
MFA-TR*          AND RETURN_CHECK_AMT   =  :CL-AMT-NOTICE                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0599A*                                                                         
P0599A     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
ACT152                                            WS-DISPLAY-SQLCODE.   
P0599A*                                                                         
P0599A     IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
P0599A       IF WS-NULL-IND-1   < 0                                     
P0599A         MOVE SPACES                  TO NH-NSF-TIMESTMP          
P0599A       ELSE                                                       
P0599A         MOVE 'Y'                     TO WS-NSF-HIST-FOUND        
P0599A       END-IF                                                     
P0599A     ELSE                                                         
P0599A       DISPLAY '********** PCSKR130  ABORT ********************'  
P0599A       DISPLAY '* 7025-CHECK-NSF-HIST                         *'  
ACT152       DISPLAY '* SQLCODE IS   ' WS-DISPLAY-SQLCODE               
P0599A       DISPLAY '* ACCOUNT NO : ' AT-ACCOUNT-NO                    
ACT152       DISPLAY '* RETURN CHECK AMT : ' CL-AMT-NOTICE              
P0599A       DISPLAY '* PROGRAM ABORTING...                         *'  
P0599A       DISPLAY '********** PCSKR130  ABORT ********************'  
P0599A       PERFORM 9900-ABEND                   THRU 9900-EXIT        
P0599A     END-IF.                                                      
      *                                                                         
       7025-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7030-WORK-DATE-20-25-55-80                                     *        
      ******************************************************************        
      *                                                                         
       7030-WORK-DATE-20-25-55-80.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -20, IIF(TRY_CONVERT(DATE, :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) ) )
            INTO
              :WS-WORK-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-WORK-DATE =                                               
MFA-TR*            DATE(:WS-INPUT-DATE) - 20 DAYS                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-WORK-DATE TO WS-DATE-20-DAYS-AGO.                    
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -25, IIF(TRY_CONVERT(DATE, :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) ) )
            INTO
              :WS-WORK-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-WORK-DATE =                                               
MFA-TR*            DATE(:WS-INPUT-DATE) - 25 DAYS                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-WORK-DATE TO WS-DATE-25-DAYS-AGO.                    
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -55, IIF(TRY_CONVERT(DATE, :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) ) )
            INTO
              :WS-WORK-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-WORK-DATE =                                               
MFA-TR*            DATE(:WS-INPUT-DATE) - 55 DAYS                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-WORK-DATE TO WS-DATE-55-DAYS-AGO.                    
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -85, IIF(TRY_CONVERT(DATE, :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) ) )
            INTO
              :WS-WORK-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-WORK-DATE =                                               
MFA-TR*            DATE(:WS-INPUT-DATE) - 85 DAYS                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-WORK-DATE TO WS-DATE-85-DAYS-AGO.                    
                                                                        
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P0599A******************************************************************        
P0599A*   7040-CHECK-REGULATED                                         *        
P0599A******************************************************************        
P0599A*                                                                         
P0599A 7040-CHECK-FOR-REGULATED.                                        
P0599A*                                                                         
P0599A     EXEC SQL                                                     
P0599A         SELECT REG_GROUP_CD                                      
P0599A               ,SENIOR_FL                                         
P0599A           INTO :LR-REG-GROUP-CD                                  
P0599A               ,:LR-SENIOR-FL                                     
P0599A           FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                     
P0599A          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
P0599A                                                      
P0599A                                                           
P0599A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REG_GROUP_CD                                              
MFA-TR*              ,SENIOR_FL                                                 
MFA-TR*          INTO :LR-REG-GROUP-CD                                          
MFA-TR*              ,:LR-SENIOR-FL                                             
MFA-TR*          FROM CSS_REG_PROFILE                                           
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        QUERYNO 7040                                                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0599A*                                                                         
P0599A     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0599A                     WS-DISPLAY-SQLCODE.                          
P0599A*                                                                         
P0599A     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P0599A       NEXT SENTENCE                                              
P0599A     ELSE                                                         
P0599A         DISPLAY '******************************************'     
P0599A         DISPLAY '** CSS_REG_PROFILE                        '     
P0599A         DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                 
P0599A         DISPLAY '** 7040 : RETURN CODE ERROR - SELECT      '     
ACT152         DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE            
P0599A         DISPLAY '******************************************'     
P0599A         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
P0599A     END-IF.                                                      
P0599A*                                                                         
P0599A 7040-EXIT.                                                       
P0599A     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7075-OPEN-F8 FIN_WO_PATH_CSR                                   *        
      ******************************************************************        
      *                                                                         
       7075-OPEN-F8.                                                    
      *                                                                         
           EXEC SQL                                                     
              OPEN FIN_WO_PATH_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'F8'                   TO WS-DB2-TABLE-ID            
              MOVE 'OPEN'                 TO WS-DB2-FUNCTION            
              MOVE SQLCODE                TO WS-DB2-RETURN-CODE         
              MOVE '130'                  TO WS-DB2-MODULE-ID           
              MOVE '7075'                 TO WS-DB2-PARAGRAPH           
              SET SKIP-ACCT               TO TRUE                       
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
      *                                                                         
       7075-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7076-FETCH-F8 FIN_WO_PATH_CSR                                  *        
      ******************************************************************        
      *                                                                         
       7076-FETCH-F8.                                                   
      *                                                                         
           EXEC SQL                                                     
              FETCH FIN_WO_PATH_CSR                                     
                 INTO :KA-COMPANY-NO,                                   
                      :KA-REG-GROUP-CD,                                 
                      :KA-CODE-STATUS-REASON,                           
                      :KA-BHV-SCORE-RATING,                             
                      :KA-FW-PATH-TYPE-CD,                              
                      :WS-KA-FW-ACCT-TYPE-CD,                           
                      :WS-KA-GUARANTEED-IND,                            
                      :F8-FW-ACTION-SEQ-NO,                             
                      :F8-FW-ACTION-TYPE-CD,                            
                      :F8-FW-FCST-DAYS-NM,                              
                      :F8-FW-FCST-TIME-CD,                              
                      :F8-FW-FCST-SOURCE-CD,                            
                      :F8-FW-FCST-COLL-FL,                              
                      :F8-FW-ACTION-LIMIT-AM,                           
                      :F8-FW-BUS-PROCESS-CD                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'F8'                   TO WS-DB2-TABLE-ID            
              MOVE 'FETCH'                TO WS-DB2-FUNCTION            
              MOVE SQLCODE                TO WS-DB2-RETURN-CODE         
              MOVE '130'                  TO WS-DB2-MODULE-ID           
              MOVE '7076'                 TO WS-DB2-PARAGRAPH           
              MOVE WS-INPUT-DATE          TO WS-DB2-KEY-1               
              SET SKIP-ACCT               TO TRUE                       
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
      *                                                                         
       7076-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7077-CLOSE-F8 FIN_WO_PATH_CSR                                  *        
      ******************************************************************        
      *                                                                         
       7077-CLOSE-F8.                                                   
      *                                                                         
           EXEC SQL                                                     
              CLOSE FIN_WO_PATH_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'F8'                   TO WS-DB2-TABLE-ID            
              MOVE 'CLOSE'                TO WS-DB2-FUNCTION            
              MOVE SQLCODE                TO WS-DB2-RETURN-CODE         
              MOVE '130'                  TO WS-DB2-MODULE-ID           
              MOVE '7077'                 TO WS-DB2-PARAGRAPH           
              MOVE WS-INPUT-DATE          TO WS-DB2-KEY-1               
              SET SKIP-ACCT               TO TRUE                       
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
      *                                                                         
       7077-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7078-OPEN-OFF-REBILL                                           *        
      ******************************************************************        
      *                                                                         
       7078-OPEN-OFF-REBILL.                                            
      *                                                                         
           EXEC SQL                                                     
              OPEN OFF_REBILL_ACTION                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'KD'                   TO WS-DB2-TABLE-ID            
              MOVE 'OPEN'                 TO WS-DB2-FUNCTION            
              MOVE SQLCODE                TO WS-DB2-RETURN-CODE         
              MOVE '130'                  TO WS-DB2-MODULE-ID           
              MOVE '7078'                 TO WS-DB2-PARAGRAPH           
              SET SKIP-ACCT               TO TRUE                       
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
      *                                                                         
       7078-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7079-FETCH-OFF-REBILL                                          *        
      ******************************************************************        
      *                                                                         
       7079-FETCH-OFF-REBILL.                                           
      *                                                                         
           EXEC SQL                                                     
              FETCH OFF_REBILL_ACTION                                   
                 INTO :KD-ACCOUNT-NO,                                   
                      :KD-FW-ACTION-TYPE-CD,                            
                      :KD-FW-SEQ-NO,                                    
                      :KD-FW-ACTION-DT,                                 
                      :KD-FW-ACTION-AM,                                 
                      :IZ-CUSTOMER-NO,                                  
                      :IZ-CODE-COLLEC-AGNCY,                            
                      :IZ-COLL-AGY-SUB-CD,                              
                      :IZ-WITHDRAW-AM,                                  
                      :IZ-WITHDRAW-DT,                                  
                      :IZ-WITHDRAW-REASON-CD,                           
                      :FW-FW-PATH-TYPE-CD                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'KD'                   TO WS-DB2-TABLE-ID            
              MOVE 'FETCH'                TO WS-DB2-FUNCTION            
              MOVE SQLCODE                TO WS-DB2-RETURN-CODE         
              MOVE '130'                  TO WS-DB2-MODULE-ID           
              MOVE '7079'                 TO WS-DB2-PARAGRAPH           
              MOVE WS-PREVIOUS-ACCT-NO    TO WS-DB2-KEY-1N              
              SET SKIP-ACCT               TO TRUE                       
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
      *                                                                         
       7079-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7080-CLOSE-OFF-REBILL                                          *        
      ******************************************************************        
      *                                                                         
       7080-CLOSE-OFF-REBILL.                                           
      *                                                                         
           EXEC SQL                                                     
              CLOSE OFF_REBILL_ACTION                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'KD'                   TO WS-DB2-TABLE-ID            
              MOVE 'CLOSE'                TO WS-DB2-FUNCTION            
              MOVE SQLCODE                TO WS-DB2-RETURN-CODE         
              MOVE '130'                  TO WS-DB2-MODULE-ID           
              MOVE '7080'                 TO WS-DB2-PARAGRAPH           
              MOVE WS-PREVIOUS-ACCT-NO    TO WS-DB2-KEY-1N              
              SET SKIP-ACCT               TO TRUE                       
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
      *                                                                         
       7080-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7085-OPEN-DELINQUENCY-CSR                                      *        
      ******************************************************************        
      *                                                                         
       7085-OPEN-DELINQUENCY-CSR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN DELINQUENCY_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
ACT152                                       WS-DISPLAY-SQLCODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR130 ABORT **********************'
              DISPLAY '* ABEND IN 7085-OPEN-DELINQUENCY-CSR           *'
              DISPLAY '* DELINQUENCY-CSR ERROR                        *'
ACT152        DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR130 ABORT **********************'
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       7085-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7090-FETCH-DELINQUENCY-CSR                                     *        
      ******************************************************************        
      *                                                                         
       7090-FETCH-DELINQUENCY-CSR.                                      
      *                                                                         
           EXEC SQL                                                     
              FETCH DELINQUENCY_CSR                                     
               INTO :C8-DELINQ-CD                                       
                   ,:C8-DELINQ-VALUE                                    
                   ,:C8-COMPANY-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
ACT152                                       WS-DISPLAY-SQLCODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR130 ABORT **********************'
              DISPLAY '* ABEND IN 7090-FETCH-DELINQUENCY-CSR          *'
              DISPLAY '* DELINQUENCY-CSR ERROR                        *'
ACT152        DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR130 ABORT **********************'
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7090-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7095-CLOSE-DELINQUENCY-CSR                                     *        
      ******************************************************************        
      *                                                                         
       7095-CLOSE-DELINQUENCY-CSR.                                      
      *                                                                         
           EXEC SQL                                                     
              CLOSE DELINQUENCY_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
ACT152                                       WS-DISPLAY-SQLCODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR130 ABORT **********************'
              DISPLAY '* ABEND IN 7095-CLOSE-DELINQUENCY-CSR          *'
              DISPLAY '* DELINQUENCY-CSR ERROR                        *'
ACT152        DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR130 ABORT **********************'
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7095-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  7100-SELECT-GUARANTOR                                        *         
      *  THIS PARAGRAPH CHECKS TO SEE IF THERE IS AN ACTIVE GUARANTOR *         
      *  ON THE ACCOUNT.                                              *         
      *****************************************************************         
      *                                                                         
       7100-SELECT-GUARANTOR.                                           
      *                                                                         
           MOVE 'N' TO WS-HAS-ACTIVE-GUAR.                              
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-HAS-ACTIVE-GUAR                              
                  FROM CSS_GUARANTOR WITH(READUNCOMMITTED)                      
                 WHERE ACCOUNT_NO     = :GU-ACCOUNT-NO                  
                 AND   GUAR_STATUS_CD = :WS-ACTIVE-GUAR                 
ACT042                                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-HAS-ACTIVE-GUAR                                      
MFA-TR*           FROM CSS_GUARANTOR                                            
MFA-TR*          WHERE ACCOUNT_NO     = :GU-ACCOUNT-NO                          
MFA-TR*          AND   GUAR_STATUS_CD = :WS-ACTIVE-GUAR                         
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7100                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                  OR NOT-FOUND                                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'SELECT'               TO WS-DB2-FUNCTION            
              MOVE SQLCODE                TO WS-DB2-RETURN-CODE         
              MOVE '130'                  TO WS-DB2-MODULE-ID           
              MOVE '7100'                 TO WS-DB2-PARAGRAPH           
              MOVE GU-ACCOUNT-NO          TO WS-DB2-KEY-1N              
              SET SKIP-ACCT               TO TRUE                       
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7600-START-FCSJC01                                             *        
      * 7610-READ-FCSJC01                                              *        
      * 7611-CLOSE                                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7620-START-FCSCA00                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00039                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7650-GET-CURR-DATE-STAMP                                       *        
      ******************************************************************        
      *                                                                         
       7650-GET-CURR-DATE-STAMP.                                        
      *                                                                         
           EXEC SQL                                                     
                 SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :CURRENT-TIMESTAMP,
              :CURRENT-DATE                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SET  :CURRENT-TIMESTAMP =                                      
MFA-TR*                CURRENT TIMESTAMP                                        
MFA-TR*              ,:CURRENT-DATE      =                                      
MFA-TR*                CURRENT DATE                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
ACT152                                       WS-DISPLAY-SQLCODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                  OR NOT-FOUND                                          
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '************** PCSKR130 ******************'      
              DISPLAY '** 7650-GET-CURR-DATE-STAMP '                    
ACT152        DISPLAY '** RETURN CODE      = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED                       *'
              DISPLAY '************** PCSKR130 ******************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7900-SELECT-RESTART.                                           *        
      ******************************************************************        
      *                                                                         
       7900-SELECT-RESTART.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT RF.RESTART_DATA                                    
                INTO :RF-RESTART-DATA                                   
                FROM CSS_RESTART RF WITH(READUNCOMMITTED)                       
               WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                 
                 AND RF.PARTITION_NO = :RF-PARTITION-NO                 
                 AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                 
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RF.RESTART_DATA                                            
MFA-TR*         INTO :RF-RESTART-DATA                                           
MFA-TR*         FROM CSS_RESTART RF                                             
MFA-TR*        WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                         
MFA-TR*          AND RF.PARTITION_NO = :RF-PARTITION-NO                         
MFA-TR*          AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7900                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
ACT152                                       WS-DISPLAY-SQLCODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR130 ABORT **********************'
              DISPLAY '* ERROR ON 7900-SELECT-RESTART                **'
              DISPLAY '* PROGRAM NAME = ' RF-NAME-PROGRAM               
              DISPLAY '* PARTITION NO = ' RF-PARTITION-NO               
              DISPLAY '* DUP CNTRL NO = ' RF-DUP-CNTRL-NO               
ACT152        DISPLAY '* RETURN CODE  = ' WS-DISPLAY-SQLCODE            
              DISPLAY '* PROCESSING TERMINATED                       **'
              DISPLAY '********** PCSKR130 ABORT **********************'
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7910-GET-AT-CODES-DATA                                    **          
      ****************************************************************          
       7910-GET-AT-CODES-DATA.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT  CODES_DATA_PRESENT                                
                INTO  :AT-CODES-DATA-PRESENT                            
                FROM  CSS_ACCOUNT                                       
               WHERE ACCOUNT_NO         =  :AT-ACCOUNT-NO               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
              MOVE 'SELECT'               TO WS-DB2-FUNCTION            
              MOVE SQLCODE                TO WS-DB2-RETURN-CODE         
              MOVE '130'                  TO WS-DB2-MODULE-ID           
              MOVE '7910'                 TO WS-DB2-PARAGRAPH           
              MOVE AT-ACCOUNT-NO          TO WS-DB2-KEY-1N              
              SET SKIP-ACCT               TO TRUE                       
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
      *                                                                         
       7910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000-WRITE-BILL-CRED-DET                                       *        
      ******************************************************************        
      *                                                                         
       8000-WRITE-BILL-CRED-DET.                                        
      *                                                                         
           MOVE WS-COMPANY-NO-AT          TO E-KR100-COMPANY-NO.        
           MOVE WS-ACCOUNT-NO-AT          TO E-KR100-ACCOUNT-NO.        
           MOVE WS-LOCAL-OFFICE-AT        TO E-KR100-LOCAL-OFFICE.      
           MOVE WS-PREMISE-NO-AT          TO E-KR100-PREMISE-NO.        
           MOVE WS-ACCT-XFER-TO-AT        TO E-KR100-MST-ACCT-NO.       
           MOVE WS-MST-SUB-ACCT-IND-AT    TO E-KR100-MST-SUB-IND.       
           MOVE WS-1H                     TO E-KR100-TABLE-ID.          
           MOVE ZERO                      TO E-KR100-SORT-SUM-FLD.      
           MOVE WS-BILL-CRED-DET-1H       TO E-KR100-DATA.              
      *                                                                         
           PERFORM 8100-WRITE-FCSKR100                   THRU 8100-EXIT.
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100-WRITE-FCSKR100                                            *        
      ******************************************************************        
      *                                                                         
       8100-WRITE-FCSKR100.                                             
      *                                                                         
           WRITE FIOKR100.                                              
      *                                                                         
           IF FCSKR100-SUCCESSFUL                                       
              ADD 1                       TO WS-FKR100-REC-CNTR         
              INITIALIZE                     FIOKR100                   
           ELSE                                                         
              DISPLAY '***************************************'         
              DISPLAY '* PCSKR130 PROCESSING ERROR           *'         
              DISPLAY '* ABEND IN 8100-WRITE-FCSKR100        *'         
              DISPLAY '* WHILE WRITTING FCSKR100-FILE        *'         
              DISPLAY '* PROCESSING TERMINATED               *'         
              DISPLAY '***************************************'         
              DISPLAY '*WS-FRP000-STATUS = ' WS-FCSKR100-STATUS         
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND                         THRU 9900-EXIT 
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8200-WRITE-RESTART                                             *        
      ******************************************************************        
      *                                                                         
       8200-WRITE-RESTART.                                              
      *                                                                         
           MOVE WS-PGRMNAME               TO RF-NAME-PROGRAM.           
           MOVE WS-PART-NO                TO RF-PARTITION-NO.           
           MOVE 1                         TO RF-DUP-CNTRL-NO.           
           MOVE WS-RESTART-DATA           TO RF-RESTART-DATA-TEXT.      
           MOVE WS-RESTART-DATA-LENGTH    TO RF-RESTART-DATA-LEN.       
      *                                                                         
           PERFORM 8210-UPDATE-RESTART              THRU 8210-EXIT.     
      *                                                                         
           IF SQLCODE EQUAL NOT-FOUND                                   
              PERFORM 8220-INSERT-RESTART           THRU 8220-EXIT      
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8210-UPDATE-RESTART.                                           *        
      ******************************************************************        
      *                                                                         
       8210-UPDATE-RESTART.                                             
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_RESTART                                               
MFA-TR*           SET RESTART_DATA = :RF-RESTART-DATA                           
MFA-TR*         WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                           
MFA-TR*           AND PARTITION_NO = :RF-PARTITION-NO                           
MFA-TR*           AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                           
MFA-TR*       QUERYNO 8820                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
ACT152                                       WS-DISPLAY-SQLCODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR130 ABORT **********************'
              DISPLAY '* 8210-UPDATE-RESTART                          *'
              DISPLAY '* NAME_PROGRAM   : ' RF-NAME-PROGRAM             
              DISPLAY '* DUP_CNTRL_NO   : ' RF-DUP-CNTRL-NO             
              DISPLAY '* PARTITION_NO   : ' RF-PARTITION-NO             
ACT152        DISPLAY '* SQLCODE        : ' WS-DISPLAY-SQLCODE          
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR130 ABORT **********************'
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  8215-UPDATE-ACCOUNT                                       **          
      ****************************************************************          
       8215-UPDATE-ACCOUNT.                                             
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                 SET CODES_DATA_PRESENT =  :AT-CODES-DATA-PRESENT       
                     ,LAST_UPDATE_TS    =  CIS.CURRENT$TIMESTAMP()            
               WHERE ACCOUNT_NO         =  :AT-ACCOUNT-NO               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*          SET CODES_DATA_PRESENT =  :AT-CODES-DATA-PRESENT               
MFA-TR*              ,LAST_UPDATE_TS    =  CURRENT TIMESTAMP                    
MFA-TR*        WHERE ACCOUNT_NO         =  :AT-ACCOUNT-NO                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               MOVE 'AT'                     TO WS-DB2-TABLE-ID         
               MOVE 'UPDATE'                 TO WS-DB2-FUNCTION         
               MOVE SQLCODE                  TO WS-DB2-RETURN-CODE      
               MOVE '130'                    TO WS-DB2-MODULE-ID        
               MOVE '8215'                   TO WS-DB2-PARAGRAPH        
               MOVE AT-ACCOUNT-NO            TO WS-DB2-KEY-1N           
               SET SKIP-ACCT                 TO TRUE                    
               PERFORM 9910-SQL-ERROR                THRU 9910-EXIT     
           END-IF.                                                      
      *                                                                         
       8215-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8220-INSERT-RESTART.                                           *        
      ******************************************************************        
      *                                                                         
       8220-INSERT-RESTART.                                             
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                     ( NAME_PROGRAM                                     
                      ,PARTITION_NO                                     
                      ,DUP_CNTRL_NO                                     
                      ,RESTART_DATA)                                    
               VALUES(:RF-NAME-PROGRAM                                  
                     ,:RF-PARTITION-NO                                  
                     ,:RF-DUP-CNTRL-NO                                  
                     ,:RF-RESTART-DATA)                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
ACT152                                       WS-DISPLAY-SQLCODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR130 ABORT **********************'
              DISPLAY '* 8220-INSERT-RESTART                          *'
              DISPLAY '* NAME_PROGRAM   : ' RF-NAME-PROGRAM             
              DISPLAY '* DUP_CNTRL_NO   : ' RF-DUP-CNTRL-NO             
              DISPLAY '* PARTITION_NO   : ' RF-PARTITION-NO             
ACT152        DISPLAY '* SQLCODE        : ' WS-DISPLAY-SQLCODE          
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR130 ABORT **********************'
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       8220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8225-UPDATE-CORR-MAIL-STAT.                                 *           
      *****************************************************************         
      *                                                                         
       8225-UPDATE-CORR-MAIL-STAT.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CORR_MAIL_STAT                                 
                 SET TRACKING_STATUS_CD = :MW-TRACKING-STATUS-CD        
                    ,USER_ID            = :MW-USER-ID                   
                    ,APPL_PROGRAM_ID    = :MW-APPL-PROGRAM-ID           
                    ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
               WHERE ACCOUNT_NO         = :MW-ACCOUNT-NO                
                 AND BARCODE_UNIQUE_ID  = :MW-BARCODE-UNIQUE-ID         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CORR_MAIL_STAT                                         
MFA-TR*          SET TRACKING_STATUS_CD = :MW-TRACKING-STATUS-CD                
MFA-TR*             ,USER_ID            = :MW-USER-ID                           
MFA-TR*             ,APPL_PROGRAM_ID    = :MW-APPL-PROGRAM-ID                   
MFA-TR*             ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*        WHERE ACCOUNT_NO         = :MW-ACCOUNT-NO                        
MFA-TR*          AND BARCODE_UNIQUE_ID  = :MW-BARCODE-UNIQUE-ID                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'MW'                   TO WS-DB2-TABLE-ID            
              MOVE 'UPDATE'               TO WS-DB2-FUNCTION            
              MOVE SQLCODE                TO WS-DB2-RETURN-CODE         
              MOVE '130'                  TO WS-DB2-MODULE-ID           
              MOVE '8225'                 TO WS-DB2-PARAGRAPH           
              MOVE MW-ACCOUNT-NO          TO WS-DB2-KEY-1N              
              SET SKIP-ACCT               TO TRUE                       
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
      *                                                                         
       8225-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00599******************************************************************        
P00599* 8250-INSERT-FINAL-WO-ACTN                                      *        
P00599******************************************************************        
P00599*                                                                         
P00599 8250-INSERT-FINAL-WO-ACTN.                                       
P00599*                                                                         
P00599     EXEC SQL                                                     
P00599          INSERT INTO CSS_FIN_WO_ACTION                           
P00599               (ACCOUNT_NO,                                       
P00599                FW_SEQ_NO,                                        
P00599                FW_ACTION_TYPE_CD,                                
P00599                FW_ACTION_DT,                                     
P00599                FW_ACTION_AM,                                     
P00599                FW_MANUAL_FL,                                     
P00599                FW_BUS_PROCESS_CD,                                
P00599                FW_PROCESSED_FL,                                  
P00599                FW_ACTION_COMMENTS)                               
P00599         VALUES                                                   
P00599               (:KD-ACCOUNT-NO,                                   
P00599                :KD-FW-SEQ-NO,                                    
P00599                :KD-FW-ACTION-TYPE-CD,                            
P00599                IIF(TRY_CONVERT(DATE, :KD-FW-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :KD-FW-ACTION-DT
              ) <> 0) OR (LEN(:KD-FW-ACTION-DT) <> 10), CIS.CHAR2DATE(
                                                       :KD-FW-ACTION-DT
              ), CONVERT(DATE, :KD-FW-ACTION-DT) ),                            
P00599                :KD-FW-ACTION-AM,                                 
P00599                :KD-FW-MANUAL-FL,                                 
P00599                :KD-FW-BUS-PROCESS-CD,                            
P00599                :KD-FW-PROCESSED-FL,                              
P00599                :KD-FW-ACTION-COMMENTS)                           
P00599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_FIN_WO_ACTION                                   
MFA-TR*              (ACCOUNT_NO,                                               
MFA-TR*               FW_SEQ_NO,                                                
MFA-TR*               FW_ACTION_TYPE_CD,                                        
MFA-TR*               FW_ACTION_DT,                                             
MFA-TR*               FW_ACTION_AM,                                             
MFA-TR*               FW_MANUAL_FL,                                             
MFA-TR*               FW_BUS_PROCESS_CD,                                        
MFA-TR*               FW_PROCESSED_FL,                                          
MFA-TR*               FW_ACTION_COMMENTS)                                       
MFA-TR*        VALUES                                                           
MFA-TR*              (:KD-ACCOUNT-NO,                                           
MFA-TR*               :KD-FW-SEQ-NO,                                            
MFA-TR*               :KD-FW-ACTION-TYPE-CD,                                    
MFA-TR*               :KD-FW-ACTION-DT,                                         
MFA-TR*               :KD-FW-ACTION-AM,                                         
MFA-TR*               :KD-FW-MANUAL-FL,                                         
MFA-TR*               :KD-FW-BUS-PROCESS-CD,                                    
MFA-TR*               :KD-FW-PROCESSED-FL,                                      
MFA-TR*               :KD-FW-ACTION-COMMENTS)                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599*                                                                         
P00599     IF SQLCODE = SUCCESSFUL-CALL                                 
P00599        CONTINUE                                                  
P00599     ELSE                                                         
P00599        MOVE 'KD'                 TO WS-DB2-TABLE-ID              
P00599        MOVE 'INSERT'             TO WS-DB2-FUNCTION              
P00599        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
P00599        MOVE '115'                TO WS-DB2-MODULE-ID             
P00599        MOVE '8250'               TO WS-DB2-PARAGRAPH             
P00599        MOVE KD-ACCOUNT-NO        TO WS-DB2-KEY-1N                
P00599        MOVE KD-FW-SEQ-NO         TO WS-DB2-KEY-2N                
P00599        MOVE KD-FW-ACTION-TYPE-CD TO WS-DB2-KEY-3N                
P00599        MOVE 12 TO RETURN-CODE                                    
P00599        PERFORM 9910-SQL-ERROR     THRU 9910-EXIT                 
P00599     END-IF.                                                      
P00599*                                                                         
P00599 8250-EXIT.                                                       
P00599     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8300-INSERT-CRED-COLL.                                         *        
      ******************************************************************        
      *                                                                         
       8300-INSERT-CRED-COLL.                                           
      *                                                                         
           IF CL-DATE-NOTICE-MAIL = LOW-VALUES OR SPACES                
              MOVE -1                     TO WS-DATE-NOTICE-MAIL-NULL   
           ELSE                                                         
              MOVE ZERO                   TO WS-DATE-NOTICE-MAIL-NULL   
           END-IF                                                       
           IF CL-DATE-CREDIT-ACTION = LOW-VALUES OR SPACES              
              MOVE -1                     TO WS-DATE-CREDIT-ACTION-NULL 
           ELSE                                                         
              MOVE ZERO                   TO WS-DATE-CREDIT-ACTION-NULL 
           END-IF                                                       
           IF CL-DATE-NOTICE-DUE = LOW-VALUES OR SPACES                 
              MOVE -1                     TO WS-DATE-NOTICE-DUE-NULL    
           ELSE                                                         
              MOVE ZERO                   TO WS-DATE-NOTICE-DUE-NULL    
           END-IF                                                       
           IF CL-DATE-BILL = LOW-VALUES OR SPACES                       
              MOVE -1                     TO WS-DATE-BILL-NULL          
           ELSE                                                         
              MOVE ZERO                   TO WS-DATE-BILL-NULL          
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CRED_COLL                                 
                  (ACCOUNT_NO                                           
                 ,ITEM_ID                                               
                 ,DATE_BILL                                             
                 ,CODE_SPECIAL_TYPE                                     
                 ,DATE_NOTICE_MAIL                                      
                 ,CODE_FRCST_CR_GRP                                     
                 ,CODE_MESSAGE_TYPE                                     
                 ,DATE_CREDIT_ACTION                                    
                 ,DATE_NOTICE_DUE                                       
                 ,AMT_NOTICE                                            
                 ,CODE_NOTICE_TYPE                                      
                 ,LAST_UPDATE_TS)                                       
              VALUES                                                    
                  (:CL-ACCOUNT-NO                                       
                 ,:CL-ITEM-ID                                           
                 ,IIF(TRY_CONVERT(DATE, :CL-DATE-BILL :WS-DATE-BILL-NULL
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-BILL 
                                                     :WS-DATE-BILL-NULL
              ) <> 0) OR (LEN(:CL-DATE-BILL :WS-DATE-BILL-NULL
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-BILL :WS-DATE-BILL-NULL
              ), CONVERT(DATE, :CL-DATE-BILL :WS-DATE-BILL-NULL) )             
                 ,:CL-CODE-SPECIAL-TYPE                                 
                 ,IIF(TRY_CONVERT(DATE, :CL-DATE-NOTICE-MAIL 
                                        :WS-DATE-NOTICE-MAIL-NULL
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-NOTICE-MAIL 
                                              :WS-DATE-NOTICE-MAIL-NULL
              ) <> 0) OR (LEN(:CL-DATE-NOTICE-MAIL 
                                              :WS-DATE-NOTICE-MAIL-NULL
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-NOTICE-MAIL 
                                              :WS-DATE-NOTICE-MAIL-NULL
              ), CONVERT(DATE, :CL-DATE-NOTICE-MAIL 
                                              :WS-DATE-NOTICE-MAIL-NULL
              ) )        
                 ,:CL-CODE-FRCST-CR-GRP                                 
                 ,:CL-CODE-MESSAGE-TYPE                                 
                 ,IIF(TRY_CONVERT(DATE, :CL-DATE-CREDIT-ACTION 
                                        :WS-DATE-CREDIT-ACTION-NULL
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-CREDIT-ACTION 
                                            :WS-DATE-CREDIT-ACTION-NULL
              ) <> 0) OR (LEN(:CL-DATE-CREDIT-ACTION 
                                            :WS-DATE-CREDIT-ACTION-NULL
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-CREDIT-ACTION 
                                            :WS-DATE-CREDIT-ACTION-NULL
              ), CONVERT(DATE, :CL-DATE-CREDIT-ACTION 
                                            :WS-DATE-CREDIT-ACTION-NULL
              ) )    
                 ,IIF(TRY_CONVERT(DATE, :CL-DATE-NOTICE-DUE 
                                        :WS-DATE-NOTICE-DUE-NULL
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-NOTICE-DUE 
                                               :WS-DATE-NOTICE-DUE-NULL
              ) <> 0) OR (LEN(:CL-DATE-NOTICE-DUE 
                                               :WS-DATE-NOTICE-DUE-NULL
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-NOTICE-DUE 
                                               :WS-DATE-NOTICE-DUE-NULL
              ), CONVERT(DATE, :CL-DATE-NOTICE-DUE 
                                               :WS-DATE-NOTICE-DUE-NULL
              ) )          
                 ,:CL-AMT-NOTICE                                        
                 ,:CL-CODE-NOTICE-TYPE                                  
                 ,CIS.CURRENT$TIMESTAMP())                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CRED_COLL                                         
MFA-TR*           (ACCOUNT_NO                                                   
MFA-TR*          ,ITEM_ID                                                       
MFA-TR*          ,DATE_BILL                                                     
MFA-TR*          ,CODE_SPECIAL_TYPE                                             
MFA-TR*          ,DATE_NOTICE_MAIL                                              
MFA-TR*          ,CODE_FRCST_CR_GRP                                             
MFA-TR*          ,CODE_MESSAGE_TYPE                                             
MFA-TR*          ,DATE_CREDIT_ACTION                                            
MFA-TR*          ,DATE_NOTICE_DUE                                               
MFA-TR*          ,AMT_NOTICE                                                    
MFA-TR*          ,CODE_NOTICE_TYPE                                              
MFA-TR*          ,LAST_UPDATE_TS)                                               
MFA-TR*       VALUES                                                            
MFA-TR*           (:CL-ACCOUNT-NO                                               
MFA-TR*          ,:CL-ITEM-ID                                                   
MFA-TR*          ,:CL-DATE-BILL :WS-DATE-BILL-NULL                              
MFA-TR*          ,:CL-CODE-SPECIAL-TYPE                                         
MFA-TR*          ,:CL-DATE-NOTICE-MAIL :WS-DATE-NOTICE-MAIL-NULL                
MFA-TR*          ,:CL-CODE-FRCST-CR-GRP                                         
MFA-TR*          ,:CL-CODE-MESSAGE-TYPE                                         
MFA-TR*          ,:CL-DATE-CREDIT-ACTION :WS-DATE-CREDIT-ACTION-NULL            
MFA-TR*          ,:CL-DATE-NOTICE-DUE :WS-DATE-NOTICE-DUE-NULL                  
MFA-TR*          ,:CL-AMT-NOTICE                                                
MFA-TR*          ,:CL-CODE-NOTICE-TYPE                                          
MFA-TR*          ,CURRENT TIMESTAMP)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CL'                   TO WS-DB2-TABLE-ID            
              MOVE 'INSERT'               TO WS-DB2-FUNCTION            
              MOVE SQLCODE                TO WS-DB2-RETURN-CODE         
              MOVE '130'                  TO WS-DB2-MODULE-ID           
              MOVE '8300'                 TO WS-DB2-PARAGRAPH           
              MOVE CL-ACCOUNT-NO          TO WS-DB2-KEY-1N              
              SET SKIP-ACCT               TO TRUE                       
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8400-INSERT-BILL-CRED-DET                                      *        
      ******************************************************************        
      *                                                                         
       8400-INSERT-BILL-CRED-DET.                                       
      *                                                                         
           IF 1H-TOT-DUE-DT = LOW-VALUES OR SPACES                      
              MOVE -1                     TO WS-TOT-DUE-DT-NULL         
           ELSE                                                         
              MOVE ZERO                   TO WS-TOT-DUE-DT-NULL         
           END-IF                                                       
           IF 1H-UTL-NORM-DUE-DT = LOW-VALUES OR SPACES                 
              MOVE -1                     TO WS-UTL-NORM-DUE-DT-NULL    
           ELSE                                                         
              MOVE ZERO                   TO WS-UTL-NORM-DUE-DT-NULL    
           END-IF                                                       
           IF 1H-UTL-EXCP-DUE-DT = LOW-VALUES OR SPACES                 
              MOVE -1                     TO WS-UTL-EXCP-DUE-DT-NULL    
           ELSE                                                         
              MOVE ZERO                   TO WS-UTL-EXCP-DUE-DT-NULL    
           END-IF                                                       
           IF 1H-NONUTL-NORM-DUE-DT = LOW-VALUES OR SPACES              
              MOVE -1                     TO WS-NONUTL-NORM-DUE-DT-NULL 
           ELSE                                                         
              MOVE ZERO                   TO WS-NONUTL-NORM-DUE-DT-NULL 
           END-IF                                                       
           IF 1H-NONUTL-EXCP-DUE-DT = LOW-VALUES OR SPACES              
              MOVE -1                     TO WS-NONUTL-EXCP-DUE-DT-NULL 
           ELSE                                                         
              MOVE ZERO                   TO WS-NONUTL-EXCP-DUE-DT-NULL 
           END-IF                                                       
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_BILL_CRED_DET                             
                  (ACCOUNT_NO                                           
                 ,BILL_NO                                               
                 ,COMPANY_NO                                            
                 ,REG_GROUP_CD                                          
                 ,TOT_DUE_AM                                            
                 ,TOT_CURR_AM                                           
                 ,TOT_ARREARS_AM                                        
                 ,TOT_DUE_DT                                            
                 ,UTL_TOT_DUE_AM                                        
                 ,UTL_CURR_AM                                           
                 ,UTL_ARREARS_AM                                        
                 ,UTL_NORM_NOT_AM                                       
                 ,UTL_EXCP_NOT_AM                                       
                 ,UTL_NORM_DUE_DT                                       
                 ,UTL_EXCP_DUE_DT                                       
                 ,NONUTL_TOT_DUE_AM                                     
                 ,NONUTL_CURR_AM                                        
                 ,NONUTL_ARREARS_AM                                     
                 ,NONUTL_NORM_NOT_AM                                    
                 ,NONUTL_EXCP_NOT_AM                                    
                 ,NONUTL_NORM_DUE_DT                                    
                 ,NONUTL_EXCP_DUE_DT                                    
                 ,LPC_AM                                                
                 ,LPN_AM                                                
                 ,BILL_CRED_NOT_ID                                      
                 ,BILL_CRED_MSG_ID                                      
                 ,CREATED_TS)                                           
              VALUES                                                    
                  (:1H-ACCOUNT-NO                                       
                 ,:1H-BILL-NO                                           
                 ,:1H-COMPANY-NO                                        
                 ,:1H-REG-GROUP-CD                                      
                 ,:1H-TOT-DUE-AM                                        
                 ,:1H-TOT-CURR-AM                                       
                 ,:1H-TOT-ARREARS-AM                                    
                 ,IIF(TRY_CONVERT(DATE, :1H-TOT-DUE-DT 
                                        :WS-TOT-DUE-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :1H-TOT-DUE-DT 
                                                    :WS-TOT-DUE-DT-NULL
              ) <> 0) OR (LEN(:1H-TOT-DUE-DT :WS-TOT-DUE-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:1H-TOT-DUE-DT 
                                                    :WS-TOT-DUE-DT-NULL
              ), CONVERT(DATE, :1H-TOT-DUE-DT :WS-TOT-DUE-DT-NULL) )           
                 ,:1H-UTL-TOT-DUE-AM                                    
                 ,:1H-UTL-CURR-AM                                       
                 ,:1H-UTL-ARREARS-AM                                    
                 ,:1H-UTL-NORM-NOT-AM                                   
                 ,:1H-UTL-EXCP-NOT-AM                                   
                 ,IIF(TRY_CONVERT(DATE, :1H-UTL-NORM-DUE-DT 
                                        :WS-UTL-NORM-DUE-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :1H-UTL-NORM-DUE-DT 
                                               :WS-UTL-NORM-DUE-DT-NULL
              ) <> 0) OR (LEN(:1H-UTL-NORM-DUE-DT 
                                               :WS-UTL-NORM-DUE-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:1H-UTL-NORM-DUE-DT 
                                               :WS-UTL-NORM-DUE-DT-NULL
              ), CONVERT(DATE, :1H-UTL-NORM-DUE-DT 
                                               :WS-UTL-NORM-DUE-DT-NULL
              ) )          
                 ,IIF(TRY_CONVERT(DATE, :1H-UTL-EXCP-DUE-DT 
                                        :WS-UTL-EXCP-DUE-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :1H-UTL-EXCP-DUE-DT 
                                               :WS-UTL-EXCP-DUE-DT-NULL
              ) <> 0) OR (LEN(:1H-UTL-EXCP-DUE-DT 
                                               :WS-UTL-EXCP-DUE-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:1H-UTL-EXCP-DUE-DT 
                                               :WS-UTL-EXCP-DUE-DT-NULL
              ), CONVERT(DATE, :1H-UTL-EXCP-DUE-DT 
                                               :WS-UTL-EXCP-DUE-DT-NULL
              ) )          
                 ,:1H-NONUTL-TOT-DUE-AM                                 
                 ,:1H-NONUTL-CURR-AM                                    
                 ,:1H-NONUTL-ARREARS-AM                                 
                 ,:1H-NONUTL-NORM-NOT-AM                                
                 ,:1H-NONUTL-EXCP-NOT-AM                                
                 ,IIF(TRY_CONVERT(DATE, :1H-NONUTL-NORM-DUE-DT 
                                        :WS-NONUTL-NORM-DUE-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :1H-NONUTL-NORM-DUE-DT 
                                            :WS-NONUTL-NORM-DUE-DT-NULL
              ) <> 0) OR (LEN(:1H-NONUTL-NORM-DUE-DT 
                                            :WS-NONUTL-NORM-DUE-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:1H-NONUTL-NORM-DUE-DT 
                                            :WS-NONUTL-NORM-DUE-DT-NULL
              ), CONVERT(DATE, :1H-NONUTL-NORM-DUE-DT 
                                            :WS-NONUTL-NORM-DUE-DT-NULL
              ) )    
                 ,IIF(TRY_CONVERT(DATE, :1H-NONUTL-EXCP-DUE-DT 
                                        :WS-NONUTL-EXCP-DUE-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :1H-NONUTL-EXCP-DUE-DT 
                                            :WS-NONUTL-EXCP-DUE-DT-NULL
              ) <> 0) OR (LEN(:1H-NONUTL-EXCP-DUE-DT 
                                            :WS-NONUTL-EXCP-DUE-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:1H-NONUTL-EXCP-DUE-DT 
                                            :WS-NONUTL-EXCP-DUE-DT-NULL
              ), CONVERT(DATE, :1H-NONUTL-EXCP-DUE-DT 
                                            :WS-NONUTL-EXCP-DUE-DT-NULL
              ) )    
                 ,:1H-LPC-AM                                            
                 ,:1H-LPN-AM                                            
                 ,:1H-BILL-CRED-NOT-ID                                  
                 ,:1H-BILL-CRED-MSG-ID                                  
                 ,CIS.CHAR2TIMESTAMP(:1H-CREATED-TS))                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_BILL_CRED_DET                                     
MFA-TR*           (ACCOUNT_NO                                                   
MFA-TR*          ,BILL_NO                                                       
MFA-TR*          ,COMPANY_NO                                                    
MFA-TR*          ,REG_GROUP_CD                                                  
MFA-TR*          ,TOT_DUE_AM                                                    
MFA-TR*          ,TOT_CURR_AM                                                   
MFA-TR*          ,TOT_ARREARS_AM                                                
MFA-TR*          ,TOT_DUE_DT                                                    
MFA-TR*          ,UTL_TOT_DUE_AM                                                
MFA-TR*          ,UTL_CURR_AM                                                   
MFA-TR*          ,UTL_ARREARS_AM                                                
MFA-TR*          ,UTL_NORM_NOT_AM                                               
MFA-TR*          ,UTL_EXCP_NOT_AM                                               
MFA-TR*          ,UTL_NORM_DUE_DT                                               
MFA-TR*          ,UTL_EXCP_DUE_DT                                               
MFA-TR*          ,NONUTL_TOT_DUE_AM                                             
MFA-TR*          ,NONUTL_CURR_AM                                                
MFA-TR*          ,NONUTL_ARREARS_AM                                             
MFA-TR*          ,NONUTL_NORM_NOT_AM                                            
MFA-TR*          ,NONUTL_EXCP_NOT_AM                                            
MFA-TR*          ,NONUTL_NORM_DUE_DT                                            
MFA-TR*          ,NONUTL_EXCP_DUE_DT                                            
MFA-TR*          ,LPC_AM                                                        
MFA-TR*          ,LPN_AM                                                        
MFA-TR*          ,BILL_CRED_NOT_ID                                              
MFA-TR*          ,BILL_CRED_MSG_ID                                              
MFA-TR*          ,CREATED_TS)                                                   
MFA-TR*       VALUES                                                            
MFA-TR*           (:1H-ACCOUNT-NO                                               
MFA-TR*          ,:1H-BILL-NO                                                   
MFA-TR*          ,:1H-COMPANY-NO                                                
MFA-TR*          ,:1H-REG-GROUP-CD                                              
MFA-TR*          ,:1H-TOT-DUE-AM                                                
MFA-TR*          ,:1H-TOT-CURR-AM                                               
MFA-TR*          ,:1H-TOT-ARREARS-AM                                            
MFA-TR*          ,:1H-TOT-DUE-DT :WS-TOT-DUE-DT-NULL                            
MFA-TR*          ,:1H-UTL-TOT-DUE-AM                                            
MFA-TR*          ,:1H-UTL-CURR-AM                                               
MFA-TR*          ,:1H-UTL-ARREARS-AM                                            
MFA-TR*          ,:1H-UTL-NORM-NOT-AM                                           
MFA-TR*          ,:1H-UTL-EXCP-NOT-AM                                           
MFA-TR*          ,:1H-UTL-NORM-DUE-DT :WS-UTL-NORM-DUE-DT-NULL                  
MFA-TR*          ,:1H-UTL-EXCP-DUE-DT :WS-UTL-EXCP-DUE-DT-NULL                  
MFA-TR*          ,:1H-NONUTL-TOT-DUE-AM                                         
MFA-TR*          ,:1H-NONUTL-CURR-AM                                            
MFA-TR*          ,:1H-NONUTL-ARREARS-AM                                         
MFA-TR*          ,:1H-NONUTL-NORM-NOT-AM                                        
MFA-TR*          ,:1H-NONUTL-EXCP-NOT-AM                                        
MFA-TR*          ,:1H-NONUTL-NORM-DUE-DT :WS-NONUTL-NORM-DUE-DT-NULL            
MFA-TR*          ,:1H-NONUTL-EXCP-DUE-DT :WS-NONUTL-EXCP-DUE-DT-NULL            
MFA-TR*          ,:1H-LPC-AM                                                    
MFA-TR*          ,:1H-LPN-AM                                                    
MFA-TR*          ,:1H-BILL-CRED-NOT-ID                                          
MFA-TR*          ,:1H-BILL-CRED-MSG-ID                                          
MFA-TR*          ,:1H-CREATED-TS)                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '1H'                   TO WS-DB2-TABLE-ID            
              MOVE 'INSERT'               TO WS-DB2-FUNCTION            
              MOVE SQLCODE                TO WS-DB2-RETURN-CODE         
              MOVE '130'                  TO WS-DB2-MODULE-ID           
              MOVE '8400'                 TO WS-DB2-PARAGRAPH           
              MOVE 1H-ACCOUNT-NO          TO WS-DB2-KEY-1N              
              SET SKIP-ACCT               TO TRUE                       
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8500-INSERT-FIN-WO-COL-HST                                     *        
      ******************************************************************        
      *                                                                         
       8500-INSERT-FIN-WO-COL-HST.                                      
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_FIN_WO_COL_HST                           
                 ( ACCOUNT_NO                                           
                  ,FW_ACTION_TYPE_CD                                    
                  ,FW_COLL_SEQ_NO                                       
                  ,FW_HIST_SEQ_TS                                       
                  ,FW_ACTION_DT                                         
                  ,FW_ACTION_AM                                         
                  ,FW_PATH_TYPE_CD                                      
                  ,CUSTOMER_NO                                          
                  ,CODE_COLLEC_AGNCY                                    
                  ,COLL_AGY_SUB_CD                                      
                  ,WITHDRAW_AM                                          
                  ,WITHDRAW_DT                                          
                  ,WITHDRAW_REASON_CD )                                 
               VALUES                                                   
                 ( :FM-ACCOUNT-NO                                       
                  ,:FM-FW-ACTION-TYPE-CD                                
                  ,:FM-FW-COLL-SEQ-NO                                   
                  ,CIS.CHAR2TIMESTAMP(:FM-FW-HIST-SEQ-TS)                       
                  ,IIF(TRY_CONVERT(DATE, :FM-FW-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :FM-FW-ACTION-DT
              ) <> 0) OR (LEN(:FM-FW-ACTION-DT) <> 10), CIS.CHAR2DATE(
                                                       :FM-FW-ACTION-DT
              ), CONVERT(DATE, :FM-FW-ACTION-DT) )                             
                  ,:FM-FW-ACTION-AM                                     
                  ,:FM-FW-PATH-TYPE-CD                                  
                  ,:FM-CUSTOMER-NO                                      
                  ,:FM-CODE-COLLEC-AGNCY                                
                  ,:FM-COLL-AGY-SUB-CD                                  
                  ,:FM-WITHDRAW-AM                                      
                  ,IIF(TRY_CONVERT(DATE, :FM-WITHDRAW-DT
              ) IS NULL OR (PATINDEX('%.%', :FM-WITHDRAW-DT
              ) <> 0) OR (LEN(:FM-WITHDRAW-DT) <> 10), CIS.CHAR2DATE(
                                                        :FM-WITHDRAW-DT
              ), CONVERT(DATE, :FM-WITHDRAW-DT) )                              
                  ,:FM-WITHDRAW-REASON-CD)                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_FIN_WO_COL_HST                                   
MFA-TR*          ( ACCOUNT_NO                                                   
MFA-TR*           ,FW_ACTION_TYPE_CD                                            
MFA-TR*           ,FW_COLL_SEQ_NO                                               
MFA-TR*           ,FW_HIST_SEQ_TS                                               
MFA-TR*           ,FW_ACTION_DT                                                 
MFA-TR*           ,FW_ACTION_AM                                                 
MFA-TR*           ,FW_PATH_TYPE_CD                                              
MFA-TR*           ,CUSTOMER_NO                                                  
MFA-TR*           ,CODE_COLLEC_AGNCY                                            
MFA-TR*           ,COLL_AGY_SUB_CD                                              
MFA-TR*           ,WITHDRAW_AM                                                  
MFA-TR*           ,WITHDRAW_DT                                                  
MFA-TR*           ,WITHDRAW_REASON_CD )                                         
MFA-TR*        VALUES                                                           
MFA-TR*          ( :FM-ACCOUNT-NO                                               
MFA-TR*           ,:FM-FW-ACTION-TYPE-CD                                        
MFA-TR*           ,:FM-FW-COLL-SEQ-NO                                           
MFA-TR*           ,:FM-FW-HIST-SEQ-TS                                           
MFA-TR*           ,:FM-FW-ACTION-DT                                             
MFA-TR*           ,:FM-FW-ACTION-AM                                             
MFA-TR*           ,:FM-FW-PATH-TYPE-CD                                          
MFA-TR*           ,:FM-CUSTOMER-NO                                              
MFA-TR*           ,:FM-CODE-COLLEC-AGNCY                                        
MFA-TR*           ,:FM-COLL-AGY-SUB-CD                                          
MFA-TR*           ,:FM-WITHDRAW-AM                                              
MFA-TR*           ,:FM-WITHDRAW-DT                                              
MFA-TR*           ,:FM-WITHDRAW-REASON-CD)                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'FM'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '130'                TO WS-DB2-MODULE-ID             
              MOVE '8500'               TO WS-DB2-PARAGRAPH             
              MOVE FM-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              SET SKIP-ACCT             TO TRUE                         
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8600-INSERT-FINAL-WO                                           *        
      ******************************************************************        
      *                                                                         
       8600-INSERT-FINAL-WO.                                            
      *                                                                         
           IF FW-FINAL-BILL-DT = LOW-VALUES OR SPACES                   
              MOVE -1 TO WS-NULL-IND-18                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-18                               
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_FINAL_WO                                
                     (ACCOUNT_NO,                                       
                      ITEM_ID,                                          
                      FINAL_BILL_AM,                                    
                      MANUAL_OVRRD_IND,                                 
                      GUARANTEED_IND,                                   
                      FINAL_BILL_DT,                                    
                      FW_PATH_TYPE_CD,                                  
                      SENIOR_FL,                                        
                      REG_GROUP_CD)                                     
               VALUES                                                   
                     (:FW-ACCOUNT-NO,                                   
                      :FW-ITEM-ID,                                      
                      :FW-FINAL-BILL-AM,                                
                      :FW-MANUAL-OVRRD-IND,                             
                      :FW-GUARANTEED-IND,                               
                      IIF(TRY_CONVERT(DATE, :FW-FINAL-BILL-DT 
                                            :WS-NULL-IND-18
              ) IS NULL OR (PATINDEX('%.%', :FW-FINAL-BILL-DT 
                                                        :WS-NULL-IND-18
              ) <> 0) OR (LEN(:FW-FINAL-BILL-DT :WS-NULL-IND-18
              ) <> 10), CIS.CHAR2DATE(:FW-FINAL-BILL-DT :WS-NULL-IND-18
              ), CONVERT(DATE, :FW-FINAL-BILL-DT :WS-NULL-IND-18) ),           
                      :FW-FW-PATH-TYPE-CD,                              
                      :FW-SENIOR-FL,                                    
                      :FW-REG-GROUP-CD)                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_FINAL_WO                                        
MFA-TR*              (ACCOUNT_NO,                                               
MFA-TR*               ITEM_ID,                                                  
MFA-TR*               FINAL_BILL_AM,                                            
MFA-TR*               MANUAL_OVRRD_IND,                                         
MFA-TR*               GUARANTEED_IND,                                           
MFA-TR*               FINAL_BILL_DT,                                            
MFA-TR*               FW_PATH_TYPE_CD,                                          
MFA-TR*               SENIOR_FL,                                                
MFA-TR*               REG_GROUP_CD)                                             
MFA-TR*        VALUES                                                           
MFA-TR*              (:FW-ACCOUNT-NO,                                           
MFA-TR*               :FW-ITEM-ID,                                              
MFA-TR*               :FW-FINAL-BILL-AM,                                        
MFA-TR*               :FW-MANUAL-OVRRD-IND,                                     
MFA-TR*               :FW-GUARANTEED-IND,                                       
MFA-TR*               :FW-FINAL-BILL-DT :WS-NULL-IND-18,                        
MFA-TR*               :FW-FW-PATH-TYPE-CD,                                      
MFA-TR*               :FW-SENIOR-FL,                                            
MFA-TR*               :FW-REG-GROUP-CD)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'FW'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '130'                TO WS-DB2-MODULE-ID             
              MOVE '8600'               TO WS-DB2-PARAGRAPH             
              MOVE FW-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              SET SKIP-ACCT             TO TRUE                         
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  8700-INSERT-FINAL-WO-ACTION                                   *        
      ******************************************************************        
      *                                                                         
       8700-INSERT-FINAL-WO-ACTION.                                     
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_FIN_WO_ACTION                            
                      (ACCOUNT_NO                                       
                      ,FW_SEQ_NO                                        
                      ,FW_ACTION_TYPE_CD                                
                      ,FW_ACTION_DT                                     
                      ,FW_ACTION_AM                                     
                      ,FW_MANUAL_FL                                     
                      ,FW_ACTION_COMMENTS                               
                      ,FW_BUS_PROCESS_CD)                               
               VALUES (:KD-ACCOUNT-NO                                   
                      ,:KD-FW-SEQ-NO                                    
                      ,:KD-FW-ACTION-TYPE-CD                            
                      ,IIF(TRY_CONVERT(DATE, :KD-FW-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :KD-FW-ACTION-DT
              ) <> 0) OR (LEN(:KD-FW-ACTION-DT) <> 10), CIS.CHAR2DATE(
                                                       :KD-FW-ACTION-DT
              ), CONVERT(DATE, :KD-FW-ACTION-DT) )                             
                      ,:KD-FW-ACTION-AM                                 
                      ,:KD-FW-MANUAL-FL                                 
                      ,:KD-FW-ACTION-COMMENTS                           
                      ,:KD-FW-BUS-PROCESS-CD)                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_FIN_WO_ACTION                                    
MFA-TR*               (ACCOUNT_NO                                               
MFA-TR*               ,FW_SEQ_NO                                                
MFA-TR*               ,FW_ACTION_TYPE_CD                                        
MFA-TR*               ,FW_ACTION_DT                                             
MFA-TR*               ,FW_ACTION_AM                                             
MFA-TR*               ,FW_MANUAL_FL                                             
MFA-TR*               ,FW_ACTION_COMMENTS                                       
MFA-TR*               ,FW_BUS_PROCESS_CD)                                       
MFA-TR*        VALUES (:KD-ACCOUNT-NO                                           
MFA-TR*               ,:KD-FW-SEQ-NO                                            
MFA-TR*               ,:KD-FW-ACTION-TYPE-CD                                    
MFA-TR*               ,:KD-FW-ACTION-DT                                         
MFA-TR*               ,:KD-FW-ACTION-AM                                         
MFA-TR*               ,:KD-FW-MANUAL-FL                                         
MFA-TR*               ,:KD-FW-ACTION-COMMENTS                                   
MFA-TR*               ,:KD-FW-BUS-PROCESS-CD)                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE 'KD'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '130'                TO WS-DB2-MODULE-ID             
              MOVE '8700'               TO WS-DB2-PARAGRAPH             
              MOVE KD-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              SET SKIP-ACCT             TO TRUE                         
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
      *                                                                         
       8700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8890-COMMIT.                                                   *        
      ******************************************************************        
      *                                                                         
       8890-COMMIT.                                                     
      *                                                                         
           PERFORM 8200-WRITE-RESTART               THRU 8200-EXIT      
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
      *                                                                         
           DISPLAY '**********************************************'     
           DISPLAY '* COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.   *'     
           DISPLAY '* LAST REC PROCESSED  = ' WS-ACCOUNT-NO-AT          
           DISPLAY '**********************************************'.    
      *                                                                         
       8890-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8895-INSERT-WORK-QUEUE.                                        *        
      ******************************************************************        
      *                                                                         
ACT051 8895-INSERT-WORK-QUEUE.                                          
ACT051*                                                                         
ACT051     CALL SCSCB077  USING   CWS00077-FIELDS,                      
ACT051                            ABEND-FILE,                           
ACT051                            RS-RETURN-CODE.                       
ACT051                                                                  
ACT051      MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE.  
ACT051                                                                  
ACT051      IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0        
ACT051         MOVE PROGRAM-NAME             TO   ABEND-PROGRAM         
ACT051         DISPLAY '8895-INSERT-WORK-QUEUE'                         
ACT051         DISPLAY 'CALL SCSCB077         '                         
ACT051         DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO              
ACT051         DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO              
ACT051         DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO           
ACT051         DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE         
ACT051         PERFORM 9900-ABEND             THRU 9900-EXIT            
ACT051     END-IF.                                                      
ACT051*                                                                         
ACT051 8895-EXIT.                                                       
ACT051     EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 8900-DELETE-CSS-FIN-WO-ACTN                                    *        
      ******************************************************************        
      *                                                                         
       8900-DELETE-FINAL-WO.                                            
      *                                                                         
           EXEC SQL                                                     
              DELETE FROM CSS_FINAL_WO                                  
              WHERE ACCOUNT_NO = :FW-ACCOUNT-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'FW'                      TO WS-DB2-TABLE-ID         
              MOVE 'DELETE'                  TO WS-DB2-FUNCTION         
              MOVE SQLCODE                   TO WS-DB2-RETURN-CODE      
              MOVE '130'                     TO WS-DB2-MODULE-ID        
              MOVE '8900'                    TO WS-DB2-PARAGRAPH        
P00599        MOVE FW-ACCOUNT-NO             TO WS-DB2-KEY-1N           
              SET SKIP-ACCT                  TO TRUE                    
              PERFORM 9910-SQL-ERROR                THRU 9910-EXIT      
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8910-DELETE-CRED-COLL                                          *        
      ******************************************************************        
      *                                                                         
       8910-DELETE-CRED-COLL.                                           
      *                                                                         
           EXEC SQL                                                     
              DELETE FROM CSS_CRED_COLL                                 
               WHERE ACCOUNT_NO        = :CL-ACCOUNT-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CL'                      TO WS-DB2-TABLE-ID         
              MOVE 'DELETE'                  TO WS-DB2-FUNCTION         
              MOVE SQLCODE                   TO WS-DB2-RETURN-CODE      
              MOVE '130'                     TO WS-DB2-MODULE-ID        
              MOVE '8910'                    TO WS-DB2-PARAGRAPH        
              MOVE CL-ACCOUNT-NO             TO WS-DB2-KEY-1N           
              SET SKIP-ACCT                  TO TRUE                    
              PERFORM 9910-SQL-ERROR                THRU 9910-EXIT      
           END-IF.                                                      
      *                                                                         
       8910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8920-DEL-RESTART-REC.                                          *        
      ******************************************************************        
      *                                                                         
       8920-DEL-RESTART-REC.                                            
      *                                                                         
           MOVE WS-PGRMNAME               TO RF-NAME-PROGRAM.           
           MOVE WS-PART-NO                TO RF-PARTITION-NO.           
           MOVE 1                         TO RF-DUP-CNTRL-NO.           
      *                                                                         
           EXEC SQL                                                     
              DELETE FROM RF                                 
              FROM CSS_RESTART RF
               WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                 
                 AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                 
                 AND RF.PARTITION_NO = :RF-PARTITION-NO                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_RESTART RF                                        
MFA-TR*        WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                         
MFA-TR*          AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                         
MFA-TR*          AND RF.PARTITION_NO = :RF-PARTITION-NO                         
MFA-TR*      QUERYNO 8920                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
ACT152                                       WS-DISPLAY-SQLCODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR130 ABORT **********************'
              DISPLAY '* 8920-DEL-RESTART-REC                         *'
              DISPLAY '* NAME_PROGRAM = ' RF-NAME-PROGRAM               
              DISPLAY '* DUP_CNTRL_NO = ' RF-DUP-CNTRL-NO               
              DISPLAY '* PARTITION_NO = ' RF-PARTITION-NO               
ACT152        DISPLAY '* SQLCODE      = ' WS-DISPLAY-SQLCODE            
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       8920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
I01687******************************************************************15170000
I01687* DELETE 'LPCASSESSED' ATTRIBUTE                                 *15180000
I01687******************************************************************15190000
I01687*                                                                 15200000
I01687 8930-DEL-ACCT-ATTRIBUTE.                                         
I01687*                                                                         
I01687     EXEC SQL                                                     
I01687         DELETE FROM CSS_ACCT_ATTRIBUTE                           
I01687          WHERE ACCOUNT_NO      = :YP-ACCOUNT-NO                  
I01687            AND ATTRIBUTE_DESC  = :YP-ATTRIBUTE-DESC              
I01687                                                      
I01687     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_ACCT_ATTRIBUTE                                   
MFA-TR*         WHERE ACCOUNT_NO      = :YP-ACCOUNT-NO                          
MFA-TR*           AND ATTRIBUTE_DESC  = :YP-ATTRIBUTE-DESC                      
MFA-TR*       QUERYNO 8930                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I01687                                                                  
I01687     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
I01687        CONTINUE                                                  
I01687     ELSE                                                         
I01687        MOVE 'YP'                      TO WS-DB2-TABLE-ID         
I01687        MOVE 'DELETE'                  TO WS-DB2-FUNCTION         
I01687        MOVE SQLCODE                   TO WS-DB2-RETURN-CODE      
I01687        MOVE '130'                     TO WS-DB2-MODULE-ID        
I01687        MOVE '8930'                    TO WS-DB2-PARAGRAPH        
I01687        MOVE WS-ACCOUNT-NO-AT          TO WS-DB2-KEY-1N           
I01687        PERFORM 9910-SQL-ERROR       THRU 9910-EXIT               
I01687     END-IF.                                                      
I01687                                                                  
I01687 8930-EXIT.                                                       
I01687      EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8887-SAVEPOINT.                                                *        
      ******************************************************************        
       8887-SAVEPOINT.                                                  
                                                                        
           EXEC SQL                                                     
              SAVE TRANSACTION CURRENT_WORK         
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ010
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SAVEPOINT CURRENT_WORK ON ROLLBACK RETAIN CURSORS                 
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
      *                                                                         
       8887-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8889-ROLLBACK-TO-SAVEPOINT.                                    *        
      ******************************************************************        
       8889-ROLLBACK-TO-SAVEPOINT.                                      
                                                                        
           EXEC SQL                                                     
              CALL CIS.ROLLBACK_SAVEPOINT('CURRENT_WORK')                       
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ010
MFA-TR*    EXEC SQL                                                             
MFA-TR*       ROLLBACK TO SAVEPOINT CURRENT_WORK                                
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
      *                                                                         
       8889-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK               *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           GO TO 9000-EXIT.                                             
                                                                        
      *                                                                         
      ******************************************************************        
      * 9000-TERMINATE.                                                *        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSBE00-FILE                                           
P00599           FCSKR100-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************11440000
      * 9910-SQL-ERROR.                                                *11450000
      ******************************************************************11460000
                                                                        
       9910-SQL-ERROR.                                                  
                                                                        
P00599     IF WS-WQ-INSERT = 'N'                                        
              IF WS-CURR-WQ-ITEM = 50                                   
                 DISPLAY 'WS-WQ-INDX GREATER THAN 50'                   
                 DISPLAY 'PROCESSING TERMINATED'                        
                 SET SKIP-ACCT             TO TRUE                      
              ELSE                                                      
                 ADD 1 TO WS-CURR-WQ-ITEM                               
              END-IF                                                    
                                                                        
              MOVE WS-DATABASE-EXCEPTION   TO                           
                   WS-WQ-ITEMS-DATA-WF(WS-WQ-INDX)                      
                                                                        
              COMPUTE WS-START-POS =                                    
                                  WS-WQ-COMMENTS-LEN-WF(WS-WQ-INDX) + 1 
              MOVE WS-SQL-ERROR-TXT-WQ     TO                           
                   WS-WQ-COMMENTS-TEXT-WF (WS-WQ-INDX)(WS-START-POS:)   
              ADD  WS-SQL-ERROR-TXT-LEN-WQ TO                           
                   WS-WQ-COMMENTS-LEN-WF(WS-WQ-INDX)                    
              ADD  1   TO WS-WQ-INDX                                    
P00599        MOVE 'Y' TO WS-WQ-INSERT                                  
P00599     END-IF.                                                      
                                                                        
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  9700-PROCESS-ABEND.                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9900-ABEND.                                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
