       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSKR120.                                           
       DATE-WRITTEN.  19 OCT 2011.                                      
       DATE-COMPILED.                                                   
       AUTHOR.   ROBERTSON.                                             
      ****************************************************************          
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               *  00000501
      **                                                             *          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                   DB2                          ********          
      ****************************************************************          
      *                   PCSKR120   NARRATIVE                       *          
      *                                                              *          
      * THIS PROGRAM CALCULATES LPC FOR MASTER ACCOUNTS AND FINAL    *          
      * BILLED ACCOUNTS.  IN THE FUTURE IT MAY BE USED TO CALCULATE  *          
      * LPC FOR ALL ACCOUNTS*                                                   
      ****************************************************************          
      ****************************************************************          
      **                                                             *          
      **              PROGRAM  MODIFICATION  LOG                     *          
      **                                                             *          
      ** DATE       INITIALS       REASON                            *          
      ** 10/19/11   WR19680        INTITIAL CODING PROJ*599          *          
P00599** 09/04/2012 AA97148        ADDED SKIP PROCESS.               *          
P00599** 09/12/2012 GV7A828        ADDED COMMIT LOGIC.               *          
P00599**                           MODIFIED CODE TO UPDATE PROCESSED_*          
      **                           CD TO 'L' FOR MASTER ACCTS        *          
A04772** 08/24/2013 AS7C117        IF MASTERS AND CONSOLIDATED ACCOUNTS*        
A04772**            ACT01          HAVE ACTIVE DRAFT,DO NOT ACCESS   *          
A04772**                           LPC AND REMOVE UNUSED COPY BOOKS  *          
      **                                                             *          
I01687** 02/19/2014 VIJAY          ASSESS LPC FOR SEB ACCOUNTS       *          
I01687** ACT001                                                      *          
I01687**                                                             *          
F01687** 05/03/2014 VIJAY          WRITE ATTRIBUTE WHEN LPC IS PROCE-*          
F01687** ACT001                    SSED.                             *          
F01687**                                                             *          
F01687** 05/06/2014 VIJAY          DO NOT WRITE WQ FOR FINALED ACCTS.*          
F01687** ACT001                                                      *          
ACT101** 05/13/2014 VIJAY          CHARGE LPC ONLY WHEN BALANCE IS   *          
ACT101** A04880                    >= 30.00 FOR SEB. VALUE IS FROM   *          
ACT101**                           DELINQUENCY 'AMT-LPC-MIN-BALANCE' *          
ACT114** 06/02/2014 VIJAY          DO NOT ASSESS LPC IF DPP EARNEST  *          
ACT114** A04880                    MONERY IS PRESENT.                *          
ACT114** 06/24/2014 VIJAY          INCLUDE CODE_DFA_TYPE TO IDENTIFY *          
ACT114** A04880                    DPP.                              *          
ACT050** 06/24/2014 SS7F226        WORK QUEUE CHANGE TO REPLACE THE  *          
ACT050** A04860                    CSS_WQ_ITEMS_MF WITH CSS_WQ_ITEMS.*          
ACT050** A04860                    AND REMOVED THE UN USED CODE.     *          
ACT039** 02/12/2015 RB19957        FOR SEB, WHEN CHECKING FOR CREDIT *          
ACT039** A05136                    ARRANGEMENT ADD TO CHECK TO SEE IF*          
ACT039** A05136                    CREDIT ARRANGEMENT HAS BEEN PAID  *          
ACT039** A05136                    EARLY.                            *          
ACT055** 03/06/2015 MJ13662        FOR SEB, WHEN CHECKING FOR CREDIT *          
ACT055** A05136                    ARRANGEMENT ADD TO CHECK TO SEE IF*          
ACT055** A05136                    AN ACTIVE CREDIT ARRANGEMENT      *          
ACT055** A05136                    EXISTS.                           *          
A05136** 11/17/2015 RS7M249        ELIMINATE CSS_LPC_RATE AND DEFINE *          
A05136**            ACT234         NEW VALUES IN CSS_DELINQUENCY     *          
A05460** 11/11/2016 BD09555        INITIALIZE INDEX BEFORE ACCESSING *          
A05460**            ACT335         TABLE                             *          
      ****************************************************************          
      ****************************************************************          
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     DATABASE ACCESS / INPUT MODULES         
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9900     TERMINATION MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSKR120'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-ROW-EXISTS                 PIC X(01).                 
               88  ROW-EXISTS                              VALUE 'Y'.   
      *                                                                 01105100
           05  WS-DATE-FOUND                 PIC X(01)     VALUE 'N'.   
               88  DATE-IS-FOUND                           VALUE 'Y'.   
A04772*                                                                 01105100
A04772     05  WS-AUTO-BANK-DRAFT            PIC X(01)     VALUE 'N'.   
A04772         88  AUTO-BANK-DRAFT                         VALUE 'Y'.   
      *                                                                 01105100
           05  WS-UTE-EXISTS-SW        PIC X(01).                       
               88  UTE-EXISTS          VALUE 'Y'.                       
      *                                                                 01109000
           05  WS-UTG-EXISTS-SW        PIC X(01).                       
               88  UTG-EXISTS          VALUE 'Y'.                       
      *                                                                         
           05  WS-LPC-EXISTS-SW        PIC X(01).                       
               88 LPC-EXISTS           VALUE 'Y'.                       
      *                                                                         
           05  WS-LPN-EXISTS-SW        PIC X(01).                       
               88 LPN-EXISTS           VALUE 'Y'.                       
      *                                                                         
           05  WS-NSC-DAYS-SW          PIC X(01).                       
               88 NSC-LT-25-DAYS       VALUE 'Y'.                       
      *                                                                         
           05  WS-DATABASE             PIC 9(01)     VALUE 0.           
                88  CSR-DATABASE                     VALUE 1.           
                88  SEB-DATABASE                     VALUE 2.           
      *                                                                 01110000
P00599     05  WS-PROCESS-ACCOUNT      PIC X(01)     VALUE 'Y'.         
P00599         88  PROCESS-ACCT                      VALUE 'Y'.         
P00599         88  SKIP-ACCT                         VALUE 'N'.         
P00599*                                                                 01110000
ACT055     05  WS-CRED-ARNG-PD-ACTIVE-EXISTS  PIC X(01).                
ACT055         88 CRED-ARNG-PD-ACTIVE-EXISTS  VALUE 'Y'.                
ACT039*                                                                         
                                                                        
       01  WS-VARIABLES.                                                
           05  WS-AR-REC-EXISTS        PIC X(01)     VALUE 'N'.         
           05  WS-AR-LPC               PIC S9(04)    VALUE +30.         
           05  WS-AR-LPN               PIC S9(04)    VALUE +39.         
           05  WS-AR-UTE               PIC S9(04)    VALUE +40.         
           05  WS-AR-UTG               PIC S9(04)    VALUE +45.         
           05  WS-PYMT-PRIORITY-LVL    PIC S9(04) COMP   VALUE ZERO.    
           05  WS-SYSTEM               PIC X(07)     VALUE 'SYSTEM'.    
           05  WS-CASH-COMPANY-NO      PIC X(02)     VALUE '01'.        
           05  WS-CASH-REPORT-NO       PIC X(03)     VALUE '998'.       
           05  WS-CASH-LOCAL-OFFICE    PIC X(03)     VALUE '998'.       
           05  WS-CASH-DRAWER-ID       PIC 9(04)     VALUE 9999.        
           05  PROGRAM-NAME            PIC X(08)     VALUE 'PCSKR120'.  
           05  SCSCB068                PIC X(08)     VALUE 'SCSCB068'.  
           05  SCSCB061                PIC X(08)     VALUE 'SCSCB061'.  
P00599     05  SCSCA151                PIC X(08)     VALUE 'SCSCA151'.  
ACT050     05  SCSCB077                PIC X(08)     VALUE 'SCSCB077'.  
           05  WS-ALLOCATION-FACTOR   PIC S9(3)V9(2) VALUE ZEROS.       
ACT101     05  WS-TOTAL-BALANCE-CALC  PIC S9(09)V99  COMP-3 VALUE +0.   
           05  WS-TOTAL-BALANCE-UTE   PIC S9(09)V99  COMP-3 VALUE +0.   
           05  WS-TOTAL-BALANCE-UTG   PIC S9(09)V99  COMP-3 VALUE +0.   
           05  WS-TOTAL-BALANCE-LPN   PIC S9(09)V99  COMP-3 VALUE +0.   
           05  WS-TOTAL-BALANCE-LPC   PIC S9(09)V99  COMP-3 VALUE +0.   
           05  WS-TOTAL-BAL-GAS-ELEC  PIC S9(09)V99  COMP-3 VALUE +0.   
           05  WS-MIN-LPC-AMT         PIC S9(11)V99  COMP-3 VALUE +0.   
           05  WS-MIN-LPN-AMT         PIC S9(11)V99  COMP-3 VALUE +0.   
           05  WS-NSC-00-DAY-AMT      PIC S9(11)V99  COMP-3 VALUE +0.   
           05  WS-MIN-LPC-BALANCE     PIC S9(11)V99  COMP-3 VALUE +0.   
           05  WS-MIN-LPN-BALANCE     PIC S9(11)V99  COMP-3 VALUE +0.   
           05  WS-REVENUE-MONTH       PIC S9(6)      COMP-3 VALUE +0.   
           05  WS-RATE                PIC S9(1)V9(3) VALUE ZEROS.       
           05  WS-SCEG                PIC X(02)      VALUE '01'.        
           05  WS-PSNC                PIC X(02)      VALUE '26'.        
           05  WS-NEXT-DATE           PIC X(10).                        
           05  WS-LPC-ASSESS-DT       PIC X(10)      VALUE SPACES.      
           05  WS-TIMESTAMP           PIC X(26)      VALUE SPACES.      
           05  WS-CURRENT-RUN-TS      PIC X(26)      VALUE SPACES.      
           05  WS-DAY                 PIC S9(04)     COMP.              
           05  WS-WQ-CATEGORY         PIC 9(4)       VALUE ZERO.        
           05  WS-WQ-PRIORITY         PIC X(1)       VALUE SPACE.       
           05  WS-N                   PIC X(01)     VALUE 'N'.          
           05  WS-DISPLAY-SQLCODE     PIC -Z(8)9.                       
           05  WS-Y                   PIC X(01)     VALUE 'Y'.          
           05  WS-COMMON-DATE         PIC X(10)      VALUE SPACES.      
           05  WS-DATE-ORIG-PYMT-IND  PIC S9(04) COMP VALUE ZERO.       
COB305     05 WS-LPC-RATE-UTIL        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 WS-LPC-RATE-NUTIL        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 WS-01-LPC-RATE-U        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 WS-01-LPC-RATE-NON-U        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 WS-PSNC-LPC-RATE-U        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 WS-PSNC-LPC-RATE-NON-U        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.      
           05  WS-01-COMPANY          PIC X(02)  VALUE '01'.            
           05  WS-PSNC-COMPANY        PIC X(02)  VALUE '26'.            
           05  WS-CURR-DT-25-DAYS-AGO PIC X(10).                        
           05  WS-AC-MAX-ENTRY        PIC 9(4) VALUE 150.               
P00599     05  WS-ACCOUNT-NO          PIC S9(13)V  COMP-3 VALUE 0.      
I01687     05  WS-LPCASSESSED         PIC X(11) VALUE 'LPCASSESSED'.    
I01687     05  WS-CANCEL-REBILL-FL    PIC X(01) VALUE 'N'.              
I01687**** VALUES FROM DELINQUENCY FOR SEB ACCOUNTS                             
COB305     05 WS-AMT-LPC-MIN-CHG        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 WS-AMT-LPC-MIN-BALANCE        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.      
F01687     05  WS-LPC-PROCESSED       PIC X(01) VALUE 'N' .             
ACT114     05  WS-FRST-ERNST-DT-NULL  PIC S9(04) COMP VALUE +0.         
ACT050     05  WS-INPUT-ZERO          PIC X(16)                         
ACT050                                VALUE '-00.00.00.000000'.         
ACT050     05  WS-INPUT-DATE-26       PIC X(26) VALUE SPACES.           
                                                                        
       01  WS-CURRENT-DATE            PIC X(10).                        
      *                                                                 02216800
       01  WS-LPC-SPLIT-TBL.                                            
           05  WS-LPC-SPLIT OCCURS                                      
               3 TIMES INDEXED BY WS-INDX.                              
COB305         10 WS-AMOUNT        PIC S9(11)V99 COMP-3 VALUE 0.          
COB305         10 WS-GL-ACCOUNT-NO-DR        PIC S9(3)V9(4) COMP-3 
COB305           VALUE 0.          
COB305         10 WS-GL-ACCOUNT-NO-CR        PIC S9(3)V9(4) COMP-3 
COB305           VALUE 0.          
      *                                                                 01280700
       01  WS-NULLS.                                                    
           05  WS-DATE-NOTICE-NULL     PIC S9(04)    COMP VALUE +0.     
           05  WS-DATE-NOTICE-DUE-NULL PIC S9(04)    COMP VALUE +0.     
           05  WS-DATE-CRED-ACT-NULL   PIC S9(04)    COMP VALUE +0.     
           05  WS-BILL-DAY-00-NULL     PIC S9(04)    COMP VALUE +0.     
           05  WS-BILL-DAY-30-NULL     PIC S9(04)    COMP VALUE +0.     
           05  WS-BILL-DAY-60-NULL     PIC S9(04)    COMP VALUE +0.     
           05  WS-BILL-DAY-90-NULL     PIC S9(04)    COMP VALUE +0.     
           05  WS-LAST-ACTION-NULL     PIC S9(04)    COMP VALUE +0.     
ACT039     05  WS-REVENUE-MONTH-NULL   PIC S9(04)    COMP VALUE +0.     
      *                                                                 02216800
       01  WS-TOTALS.                                                   
           05  WS-TOTAL-LPN-CHG        PIC S9(09)V99 COMP-3 VALUE ZERO. 
           05  WS-TOTAL-LPC-CHG        PIC S9(09)V99 COMP-3 VALUE ZERO. 
           05  WS-TOTAL-CHARGE         PIC S9(09)V99 COMP-3 VALUE ZERO. 
           05  WS-ELEC-REV             PIC S9(09)V99 COMP-3 VALUE ZERO. 
           05  WS-GAS-REV              PIC S9(09)V99 COMP-3 VALUE ZERO. 
      *                                                                 02217500
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
      *                                                                 01482000
       01  WS-WORKQUEUE-COMMENTS.                                       
           05  WS-TEXT-1                  PIC X(07)  VALUE              
               'LPC OF '.                                               
           05  WS-LPC-AMOUNT              PIC $$$$,$$$.99.              
           05  WS-TEXT-2                  PIC X(20)  VALUE              
               ' ON A BALANCE OF '.                                     
           05  WS-ACCOUNT-BALANCE         PIC $$$$,$$$,$$$.99.          
      *                                                                 01551200
       01  WS-COMMENTS.                                                 
           05 WS-COMMENTS-LEN      PIC S9(4) USAGE COMP.                
           05 WS-COMMENTS-TEXT     PIC X(250).                          
      *                                                                 01553400
       01  WS-WORKQUEUE-COMMENT2.                                       
           05  WS-TEXT-1                  PIC X(50)  VALUE              
               'LPC WILL BE ASSESSED IN 1 BUSINESS DAY.'.               
      *                                                                 01553400
P0059A*                                                                         
P0059A 01  WS-COMMIT-VARS.                                              
P0059A     05  WS-COMMIT-REC-CNTR          PIC S9(07) COMP-3 VALUE 0.   
P0059A     05  WS-COMMIT-COUNTER1          PIC 9(9)   VALUE 0.          
P0059A     05  WS-COMMIT-COUNTER2          PIC 9(9)   VALUE 0.          
P0059A     05  WS-COMMIT-LIMIT             PIC 9(4)   VALUE 0.          
P0059A     05  WS-DEFAULT-COMMIT-LIMIT     PIC 9(4)   VALUE 1000.       
P0059A*                                                                         
      *****************************************************************         
      * CWS00315 CONTAINS WS FOR FINDING NEXT BUSINESS DAY            *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CWS00322                                                   
           END-EXEC.                                                            
      *                                                                         
ACT050******************************************************************        
ACT050* FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077          *        
ACT050******************************************************************        
ACT050     EXEC SQL                                                             
ACT050        INCLUDE CWS00077                                                  
ACT050     END-EXEC.                                                            
ACT050*                                                                         
      *****************************************************************         
      * CWS00337 CONTAINS WS FOR CPD00337 LOAD LPC LIMITS             *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CWS00337                                                   
           END-EXEC.                                                            
P00599******************************************************************        
P00599* VARIABLES NEEDED FOR ACCOUNT SKIP PROCESSING.                  *        
P00599******************************************************************        
P00599*                                                                         
P00599 COPY CWSCA151.                                                           
P00599*                                                                         
      *                                                                         
      ***************************************************************** 01553800
      * COMMON DATE ROUTINES                                          *         
      *****************************************************************         
           EXEC SQL                                                     01553900
               INCLUDE CWS00038                                         01554000
           END-EXEC.                                                    01554100
P0059A 01  WS-COMMIT-COUNT REDEFINES WS-INPUT-DATA-BREAKDOWN.           
P0059A     10  WS-COMMIT-COUNT-TXT         PIC X(09).                   
P0059A         88 COMMIT-PARM            VALUE 'COMMIT = '.             
P0059A     10  WS-COMMIT-NUM               PIC 9(04).                   
P0059A     10  FILLER                      PIC X(67).                   
      *                                                                 01554200
           EXEC SQL                                                     01553900
               INCLUDE CWS00039                                         01554000
           END-EXEC.                                                    01554100
      *                                                                 01554200
      ******************************************************************01554200
      * COPYBOOK FOR CPD00068                                          *        
      ******************************************************************        
           EXEC SQL                                                     01554300
               INCLUDE CWS00068                                         01554400
           END-EXEC.                                                    01554500
                                                                        
      ******************************************************************        
      * GENERAL LEDGER COPYBOOK                                        *        
      ******************************************************************        
       COPY CWS00061.                                                   01555000
                                                                        
      ******************************************************************        
      * ABEND SWITCH COPYBOOK                                          *        
      ******************************************************************        
       COPY CWS09900.                                                   01554900
       COPY CWS00010.                                                   01555200
                                                                        
      ******************************************************************        
      *  CODES DATA PRESENT                                            *        
      ******************************************************************        
       COPY CWS00056.                                                   01555100
                                                                        
      ******************************************************************        
      *  JOURNALLING COPYBOOKS                                         *        
      ******************************************************************        
       COPY CJF00101.                                                   01555400
      *                                                                 01555500
           EXEC SQL                                                     01555900
              INCLUDE CWS00013                                          01556000
           END-EXEC.                                                    01557000
      *                                                                 01558000
       COPY FIOCA01.                                                    01560000
                                                                        
      ******************************************************************        
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'                 *        
      ******************************************************************        
       COPY FIOJC01.                                                    01570000
       COPY FIOCA00.                                                    01580000
       01  WS-PGRMNAME                     PIC X(8)  VALUE 'PCSKR120'.  
      *                                                                         
      ******************************************************************        
      *  DB2 ERROR HANDLING                                            *        
      ******************************************************************        
       COPY CWS00303.                                                   02264200
      ****************************************************************          
      **      APPLICATION  TABLE DCLGENS                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_JOB_PARM  (G6)                                          *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                 02302000
      ******************************************************************        
      * DCLGEN FOR CSS_ACCOUNT  (AT)                                   *02301000
      ******************************************************************        
           EXEC SQL                                                     02310000
               INCLUDE TBACCT                                           02320000
           END-EXEC.                                                    02330000
      *                                                                         
      ******************************************************************        
      * DCLGEN FOR CSS_AR_CNTL  (AC)                                   *02341000
      ******************************************************************02342000
           EXEC SQL                                                     02350000
               INCLUDE TBARCNTL                                         02360000
           END-EXEC.                                                    02370000
      *                                                                 02500000
      ******************************************************************02784000
      * DCLGEN FOR CSS_AR_TRANS_HIST  (AR)                             *02789200
      ******************************************************************02789300
           EXEC SQL                                                     02789400
               INCLUDE TBARHIST                                         02789500
           END-EXEC.                                                    02789600
      *                                                                 02789700
      ******************************************************************        
      * DCLGEN FOR CSS_AR_TRN_HST_DET  (AU)                            *02789800
      ******************************************************************02789900
           EXEC SQL                                                     02790000
               INCLUDE TBARHDT                                          02790100
           END-EXEC.                                                    02790200
      *                                                                 02790400
      *****************************************************************         
      * DCLGEN FOR CSS_FINAL_WO  (FW)                                 * 02701000
      ***************************************************************** 02702000
           EXEC SQL                                                     02710000
               INCLUDE TBFINLWO                                         02720000
           END-EXEC.                                                    02730000
      *                                                                 02744000
      ******************************************************************        
      * DCLGEN FOR CSS_CRED_COLL  (CL)                                 *02581000
      ******************************************************************02582000
           EXEC SQL                                                     02590000
               INCLUDE TBCRCOLL                                         02600000
           END-EXEC.                                                    02610000
      *                                                                 02620000
      ******************************************************************02500000
      * DCLGEN FOR CSS_PREMISE  (PR)                                   *02501000
      ******************************************************************02502000
           EXEC SQL                                                     02510000
               INCLUDE TBPREM                                           02520000
           END-EXEC.                                                    02530000
      *                                                                 02540000
      ******************************************************************02790400
      * DCLGEN FOR CSS_LOCAL_OFFICE  (B1)                              *02791800
      ******************************************************************02791900
           EXEC SQL                                                     02792000
               INCLUDE TBLOCOFC                                         02792100
           END-EXEC.                                                    02792200
      *                                                                 02792300
      ******************************************************************02799400
      * DCLGEN FOR CSS_BATCH_JRNL  (BJ)                                *02799500
      ******************************************************************02799600
           EXEC SQL                                                     02799700
               INCLUDE TBBTJRNL                                         02799800
           END-EXEC.                                                    02799900
      *                                                                 02800000
      ******************************************************************        
      * DCLGEN FOR CSS_BCH_JRNL_CNTL  (BC)                             *02800100
      ******************************************************************02800200
           EXEC SQL                                                     02800300
               INCLUDE TBBJCNTL                                         02800400
           END-EXEC.                                                    02800500
      *                                                                 02800600
      ******************************************************************        
      * DCLGEN FOR CSS_MISC_JRNL  (MJ)                                 *02800700
      ******************************************************************02800800
           EXEC SQL                                                     02800900
               INCLUDE TBMSJRNL                                         02801000
           END-EXEC.                                                    02801100
      *                                                                 02801200
      ******************************************************************        
      * DCLGEN FOR CSS_NSF_HIST   (NH)                                 *02800700
      ******************************************************************02800800
           EXEC SQL                                                     02800900
               INCLUDE TBNSFHST                                         02801000
           END-EXEC.                                                    02801100
      *                                                                 02801200
      ******************************************************************        
      * DCLGEN FOR CSS_FIN_WO_ACTION (KD)                              *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBFWACTN                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DCLGEN FOR CSS_FW_FCST_ACTION (F8)                             *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBFWPDTL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************02794300
      * DCLGEN FOR CSS_GL_ACCT_NO (GO)                                 *02794500
      ******************************************************************02794600
           EXEC SQL                                                     02794700
               INCLUDE TBGLATNO                                         02794800
           END-EXEC.                                                    02794900
      *                                                                 02795000
      ******************************************************************        
      * DCLGEN FOR CSS_DELINQUENCY                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************02794300
      * DCLGEN FOR CSS_BUSINESS_DAYS (1G)                              *02794500
      ******************************************************************02794600
           EXEC SQL                                                     02794700
               INCLUDE TBBUSDAY                                         02794800
           END-EXEC.                                                    02794900
A04772******************************************************************02794300
A04772* DCLGEN FOR CSS_BANK_EFT (BE)                                   *02794500
A04772******************************************************************02794600
A04772     EXEC SQL                                                     02794700
A04772         INCLUDE TBBNKEFT                                         02794800
A04772     END-EXEC.                                                    02794900
      *                                                                 02795000
ACT114******************************************************************02794300
ACT114* DCLGEN FOR CSS_DFA_ACCT (DA)                                   *02794500
ACT114******************************************************************02794600
ACT114     EXEC SQL                                                     02794700
ACT114         INCLUDE TBDFAACT                                         02794800
ACT114     END-EXEC.                                                    02794900
      *                                                                 02795000
ACT039******************************************************************02794300
ACT039* DCLGEN FOR CSS_CRED_ARNGMENT (X1)                              *02794500
ACT039******************************************************************02794600
ACT039     EXEC SQL                                                     02794700
ACT039         INCLUDE TBCRARNG                                         02794800
ACT039     END-EXEC.                                                    02794900
ACT039*                                                                 02795000
ACT039******************************************************************02794300
ACT039* DCLGEN FOR CSS_CRED_ARNG_HIST (WY)                             *02794500
ACT039******************************************************************02794600
ACT039     EXEC SQL                                                     02794700
ACT039         INCLUDE TBCRARHS                                         02794800
ACT039     END-EXEC.                                                    02794900
ACT039*                                                                 02795000
      *****************************************                         04060000
      * MASTER ACCOUNT PAST DUE                                         04193000
      *****************************************                         04194000
      *                                                                 04194100
           EXEC SQL                                                     
P0059A       DECLARE MASTER_ACCT_CRSR CURSOR WITH HOLD FOR              
               SELECT                                                   
                  CL.DATE_NOTICE_DUE,                                   
                  CL.CODE_NOTICE_TYPE,                                  
P0059A            CL.ITEM_ID,                                           
                  AT.ACCOUNT_NO,                                        
                  AT.COMPANY_NO,                                        
                  AT.CODES_DATA_PRESENT,                                
                  AT.CODE_LPC_XMT,                                      
                  AT.CUSTOMER_NO,                                       
                  AT.PREMISE_NO,                                        
                  AT.LOCAL_OFFICE,                                      
                  AT.DATE_LAST_ACTION,                                  
                  AT.CODE_DISC_OK,                                      
                  AT.CREDIT_GROUP,                                      
                  AT.CODE_ACCT_STAT,                                    
                  AT.DATE_BILL_DAY_00,                                  
                  AT.DATE_BILL_DAY_30,                                  
                  AT.DATE_BILL_DAY_60,                                  
                  AT.DATE_BILL_DAY_90,                                  
                  AT.NOTICE_EXEMPT_CD,                                  
                  AT.BANKRUPTCY_IND,                                    
                  AT.ELEC_REV_ALLOC_PCT,                                
                  AT.TOTAL_AR_BALANCE,                                  
                  PR.REV_DISTRICT_CD,                                   
                  B1.ELEC_REV_ALLOC_PCT,                                
                  B1.DISTRICT_NO                                        
               FROM                                                     
                  CSS_CRED_COLL CL,                                     
                  CSS_ACCOUNT AT,                                       
                  CSS_PREMISE PR,                                       
                  CSS_LOCAL_OFFICE B1                                   
               WHERE                                                    
                   CL.ACCOUNT_NO   = AT.ACCOUNT_NO                      
               AND AT.PREMISE_NO   = PR.PREMISE_NO                      
               AND AT.LOCAL_OFFICE = B1.LOCAL_OFFICE                    
               AND CL.CODE_NOTICE_TYPE = 'A'                            
               AND CL.DATE_NOTICE_DUE  = IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )               
               AND AT.CREDIT_GROUP     = 'M'                            
               AND AT.CODE_ACCT_STAT   = 'A'                            
               AND CL.DATE_BILL        = AT.DATE_BILL_DAY_00            
P0059A         AND CL.PROCESSED_CD     = ' '                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     04195000
MFA-TR*      DECLARE MASTER_ACCT_CRSR CURSOR WITH HOLD FOR              04196000
MFA-TR*        SELECT                                                   04197000
MFA-TR*           CL.DATE_NOTICE_DUE,                                   04197100
MFA-TR*           CL.CODE_NOTICE_TYPE,                                  04197200
MFA-TR*           CL.ITEM_ID,                                           04197200
MFA-TR*           AT.ACCOUNT_NO,                                        04199300
MFA-TR*           AT.COMPANY_NO,                                        04199400
MFA-TR*           AT.CODES_DATA_PRESENT,                                04199500
MFA-TR*           AT.CODE_LPC_XMT,                                      04199600
MFA-TR*           AT.CUSTOMER_NO,                                       04199700
MFA-TR*           AT.PREMISE_NO,                                        04199800
MFA-TR*           AT.LOCAL_OFFICE,                                      04199900
MFA-TR*           AT.DATE_LAST_ACTION,                                  04200000
MFA-TR*           AT.CODE_DISC_OK,                                      04200100
MFA-TR*           AT.CREDIT_GROUP,                                      04200200
MFA-TR*           AT.CODE_ACCT_STAT,                                    04200300
MFA-TR*           AT.DATE_BILL_DAY_00,                                  04200400
MFA-TR*           AT.DATE_BILL_DAY_30,                                  04200500
MFA-TR*           AT.DATE_BILL_DAY_60,                                  04200600
MFA-TR*           AT.DATE_BILL_DAY_90,                                  04200700
MFA-TR*           AT.NOTICE_EXEMPT_CD,                                  04200800
MFA-TR*           AT.BANKRUPTCY_IND,                                    04200900
MFA-TR*           AT.ELEC_REV_ALLOC_PCT,                                04201100
MFA-TR*           AT.TOTAL_AR_BALANCE,                                  04201200
MFA-TR*           PR.REV_DISTRICT_CD,                                   04201300
MFA-TR*           B1.ELEC_REV_ALLOC_PCT,                                04201600
MFA-TR*           B1.DISTRICT_NO                                                
MFA-TR*        FROM                                                     04201700
MFA-TR*           CSS_CRED_COLL CL,                                     04201800
MFA-TR*           CSS_ACCOUNT AT,                                       04201900
MFA-TR*           CSS_PREMISE PR,                                       04202000
MFA-TR*           CSS_LOCAL_OFFICE B1                                   04202200
MFA-TR*        WHERE                                                    04202300
MFA-TR*            CL.ACCOUNT_NO   = AT.ACCOUNT_NO                      04202400
MFA-TR*        AND AT.PREMISE_NO   = PR.PREMISE_NO                      04202500
MFA-TR*        AND AT.LOCAL_OFFICE = B1.LOCAL_OFFICE                    04202700
MFA-TR*        AND CL.CODE_NOTICE_TYPE = 'A'                            04202800
MFA-TR*        AND CL.DATE_NOTICE_DUE  = :WS-CURRENT-DATE               04202900
MFA-TR*        AND AT.CREDIT_GROUP     = 'M'                            04203000
MFA-TR*        AND AT.CODE_ACCT_STAT   = 'A'                            04203100
MFA-TR*        AND CL.DATE_BILL        = AT.DATE_BILL_DAY_00                    
MFA-TR*        AND CL.PROCESSED_CD     = ' '                                    
MFA-TR*    END-EXEC.                                                    04203200
      *                                                                         
I01687*****************************************                         04060000
I01687* SEB ACCOUNTS FOR LPC CALCULATION.                               04193000
I01687* PROCESS ACCOUNTS BILLED 201404 ONWARDS                          04193000
I01687*****************************************                         04194000
I01687*                                                                 04194100
I01687     EXEC SQL                                                     
I01687       DECLARE SEB_ACCT_CRSR CURSOR WITH HOLD FOR                 
I01687         SELECT                                                   
I01687            CL.DATE_NOTICE_DUE                                    
I01687          , CL.CODE_NOTICE_TYPE                                   
I01687          , CL.ITEM_ID                                            
I01687          , AT.ACCOUNT_NO                                         
I01687          , AT.COMPANY_NO                                         
I01687          , AT.CODES_DATA_PRESENT                                 
I01687          , AT.CODE_LPC_XMT                                       
I01687          , AT.CUSTOMER_NO                                        
I01687          , AT.PREMISE_NO                                         
I01687          , AT.LOCAL_OFFICE                                       
I01687          , AT.DATE_LAST_ACTION                                   
I01687          , AT.CODE_DISC_OK                                       
I01687          , AT.CREDIT_GROUP                                       
I01687          , AT.CODE_ACCT_STAT                                     
I01687          , AT.DATE_BILL_DAY_00                                   
I01687          , AT.DATE_BILL_DAY_30                                   
I01687          , AT.DATE_BILL_DAY_60                                   
I01687          , AT.DATE_BILL_DAY_90                                   
I01687          , AT.NOTICE_EXEMPT_CD                                   
I01687          , AT.BANKRUPTCY_IND                                     
I01687          , AT.ELEC_REV_ALLOC_PCT                                 
I01687          , AT.TOTAL_AR_BALANCE                                   
ACT039          , AT.REV_MTH_LST_NRML                                   
I01687          , PR.REV_DISTRICT_CD                                    
I01687          , B1.ELEC_REV_ALLOC_PCT                                 
I01687          , B1.DISTRICT_NO                                        
I01687         FROM                                                     
I01687            CSS_CRED_COLL    CL                                   
I01687          , CSS_ACCOUNT      AT                                   
I01687          , CSS_PREMISE      PR                                   
I01687          , CSS_LOCAL_OFFICE B1                                   
I01687         WHERE                                                    
I01687             CL.ACCOUNT_NO   = AT.ACCOUNT_NO                      
I01687         AND AT.PREMISE_NO   = PR.PREMISE_NO                      
I01687         AND AT.LOCAL_OFFICE = B1.LOCAL_OFFICE                    
I01687         AND CL.CODE_NOTICE_TYPE = 'A'                            
I01687         AND CL.DATE_CREDIT_ACTION = IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )             
I01687         AND AT.CODE_ACCT_STAT   = 'A'                            
I01687         AND CL.DATE_BILL        = AT.DATE_BILL_DAY_00            
I01687         AND CL.PROCESSED_CD     = ' '                            
I01687         AND REV_MTH_LST_NRML   >= 201404                         
I01687     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     04195000
MFA-TR*      DECLARE SEB_ACCT_CRSR CURSOR WITH HOLD FOR                 04196000
MFA-TR*        SELECT                                                   04197000
MFA-TR*           CL.DATE_NOTICE_DUE                                    04197100
MFA-TR*         , CL.CODE_NOTICE_TYPE                                   04197200
MFA-TR*         , CL.ITEM_ID                                            04197200
MFA-TR*         , AT.ACCOUNT_NO                                         04199300
MFA-TR*         , AT.COMPANY_NO                                         04199400
MFA-TR*         , AT.CODES_DATA_PRESENT                                 04199500
MFA-TR*         , AT.CODE_LPC_XMT                                       04199600
MFA-TR*         , AT.CUSTOMER_NO                                        04199700
MFA-TR*         , AT.PREMISE_NO                                         04199800
MFA-TR*         , AT.LOCAL_OFFICE                                       04199900
MFA-TR*         , AT.DATE_LAST_ACTION                                   04200000
MFA-TR*         , AT.CODE_DISC_OK                                       04200100
MFA-TR*         , AT.CREDIT_GROUP                                       04200200
MFA-TR*         , AT.CODE_ACCT_STAT                                     04200300
MFA-TR*         , AT.DATE_BILL_DAY_00                                   04200400
MFA-TR*         , AT.DATE_BILL_DAY_30                                   04200500
MFA-TR*         , AT.DATE_BILL_DAY_60                                   04200600
MFA-TR*         , AT.DATE_BILL_DAY_90                                   04200700
MFA-TR*         , AT.NOTICE_EXEMPT_CD                                   04200800
MFA-TR*         , AT.BANKRUPTCY_IND                                     04200900
MFA-TR*         , AT.ELEC_REV_ALLOC_PCT                                 04201100
MFA-TR*         , AT.TOTAL_AR_BALANCE                                   04201200
MFA-TR*         , AT.REV_MTH_LST_NRML                                   04200900
MFA-TR*         , PR.REV_DISTRICT_CD                                    04201300
MFA-TR*         , B1.ELEC_REV_ALLOC_PCT                                 04201600
MFA-TR*         , B1.DISTRICT_NO                                                
MFA-TR*        FROM                                                     04201700
MFA-TR*           CSS_CRED_COLL    CL                                   04201800
MFA-TR*         , CSS_ACCOUNT      AT                                   04201900
MFA-TR*         , CSS_PREMISE      PR                                   04202000
MFA-TR*         , CSS_LOCAL_OFFICE B1                                   04202200
MFA-TR*        WHERE                                                    04202300
MFA-TR*            CL.ACCOUNT_NO   = AT.ACCOUNT_NO                      04202400
MFA-TR*        AND AT.PREMISE_NO   = PR.PREMISE_NO                      04202500
MFA-TR*        AND AT.LOCAL_OFFICE = B1.LOCAL_OFFICE                    04202700
MFA-TR*        AND CL.CODE_NOTICE_TYPE = 'A'                            04202800
MFA-TR*        AND CL.DATE_CREDIT_ACTION = :WS-CURRENT-DATE             04202900
MFA-TR*        AND AT.CODE_ACCT_STAT   = 'A'                            04203100
MFA-TR*        AND CL.DATE_BILL        = AT.DATE_BILL_DAY_00                    
MFA-TR*        AND CL.PROCESSED_CD     = ' '                                    
MFA-TR*        AND REV_MTH_LST_NRML   >= 201404                                 
MFA-TR*    END-EXEC.                                                    04203200
      *                                                                         
      **** CURSOR TO SELECT FB/WO ACTIONS TO BE PROCESSED                       
           EXEC SQL                                                     
P0059A       DECLARE FINAL_WO_ACTN CURSOR WITH HOLD FOR                 
              SELECT                                                    
                      FW.ACCOUNT_NO                                     
                     ,FW.FW_PATH_TYPE_CD                                
                     ,FW.SENIOR_FL                                      
                     ,FW.REG_GROUP_CD                                   
                     ,KD.FW_SEQ_NO                                      
                     ,KD.FW_ACTION_DT                                   
                     ,KD.FW_ACTION_TYPE_CD                              
                     ,KD.FW_ACTION_AM                                   
                     ,KD.FW_PROCESSED_FL                                
                     ,AT.COMPANY_NO                                     
                     ,AT.CUSTOMER_NO                                    
                     ,AT.TOTAL_AR_BALANCE                               
                     ,AT.CODE_ACCT_STAT                                 
                     ,AT.DATE_BILL_DAY_00                               
                     ,AT.DATE_BILL_DAY_30                               
                     ,AT.DATE_BILL_DAY_60                               
                     ,AT.DATE_BILL_DAY_90                               
                     ,AT.CANREB_CODE_00_DAY                             
                     ,AT.CANREB_CODE_30_DAY                             
                     ,AT.CANREB_CODE_60_DAY                             
                     ,AT.CANREB_CODE_90_DAY                             
                     ,AT.BANKRUPTCY_IND                                 
                     ,AT.JUDGEMENT_CASE_NO                              
                     ,AT.PREMISE_NO                                     
                     ,AT.LOCAL_OFFICE                                   
                     ,AT.CODE_LPC_XMT                                   
                     ,AT.CODES_DATA_PRESENT                             
                     ,AT.ELEC_REV_ALLOC_PCT                             
                     ,B1.ELEC_REV_ALLOC_PCT                             
                     ,B1.DISTRICT_NO                                    
                     ,PR.REV_DISTRICT_CD                                
                FROM CSS_ACCOUNT        AT                              
                     ,CSS_FIN_WO_ACTION KD                              
                     ,CSS_FINAL_WO      FW                              
                     ,CSS_LOCAL_OFFICE  B1                              
                     ,CSS_PREMISE       PR                              
                WHERE AT.ACCOUNT_NO   =  FW.ACCOUNT_NO                  
                  AND KD.ACCOUNT_NO   =  FW.ACCOUNT_NO                  
                  AND AT.PREMISE_NO   =  PR.PREMISE_NO                  
                  AND AT.LOCAL_OFFICE =  B1.LOCAL_OFFICE                
                  AND KD.FW_ACTION_DT      <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )          
                  AND AT.CODE_ACCT_STAT    = 'B'                        
                  AND KD.FW_BUS_PROCESS_CD = 'LP'                       
                  AND KD.FW_PROCESSED_FL   = ' '                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE FINAL_WO_ACTN CURSOR WITH HOLD FOR                         
MFA-TR*       SELECT                                                            
MFA-TR*               FW.ACCOUNT_NO                                             
MFA-TR*              ,FW.FW_PATH_TYPE_CD                                        
MFA-TR*              ,FW.SENIOR_FL                                              
MFA-TR*              ,FW.REG_GROUP_CD                                           
MFA-TR*              ,KD.FW_SEQ_NO                                              
MFA-TR*              ,KD.FW_ACTION_DT                                           
MFA-TR*              ,KD.FW_ACTION_TYPE_CD                                      
MFA-TR*              ,KD.FW_ACTION_AM                                           
MFA-TR*              ,KD.FW_PROCESSED_FL                                        
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.TOTAL_AR_BALANCE                                       
MFA-TR*              ,AT.CODE_ACCT_STAT                                         
MFA-TR*              ,AT.DATE_BILL_DAY_00                                       
MFA-TR*              ,AT.DATE_BILL_DAY_30                                       
MFA-TR*              ,AT.DATE_BILL_DAY_60                                       
MFA-TR*              ,AT.DATE_BILL_DAY_90                                       
MFA-TR*              ,AT.CANREB_CODE_00_DAY                                     
MFA-TR*              ,AT.CANREB_CODE_30_DAY                                     
MFA-TR*              ,AT.CANREB_CODE_60_DAY                                     
MFA-TR*              ,AT.CANREB_CODE_90_DAY                                     
MFA-TR*              ,AT.BANKRUPTCY_IND                                         
MFA-TR*              ,AT.JUDGEMENT_CASE_NO                                      
MFA-TR*              ,AT.PREMISE_NO                                             
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,AT.CODE_LPC_XMT                                           
MFA-TR*              ,AT.CODES_DATA_PRESENT                                     
MFA-TR*              ,AT.ELEC_REV_ALLOC_PCT                                     
MFA-TR*              ,B1.ELEC_REV_ALLOC_PCT                                     
MFA-TR*              ,B1.DISTRICT_NO                                            
MFA-TR*              ,PR.REV_DISTRICT_CD                                        
MFA-TR*         FROM CSS_ACCOUNT        AT                                      
MFA-TR*              ,CSS_FIN_WO_ACTION KD                                      
MFA-TR*              ,CSS_FINAL_WO      FW                                      
MFA-TR*              ,CSS_LOCAL_OFFICE  B1                                      
MFA-TR*              ,CSS_PREMISE       PR                                      
MFA-TR*         WHERE AT.ACCOUNT_NO   =  FW.ACCOUNT_NO                          
MFA-TR*           AND KD.ACCOUNT_NO   =  FW.ACCOUNT_NO                          
MFA-TR*           AND AT.PREMISE_NO   =  PR.PREMISE_NO                          
MFA-TR*           AND AT.LOCAL_OFFICE =  B1.LOCAL_OFFICE                        
MFA-TR*           AND KD.FW_ACTION_DT      <= :WS-CURRENT-DATE                  
MFA-TR*           AND AT.CODE_ACCT_STAT    = 'B'                                
MFA-TR*           AND KD.FW_BUS_PROCESS_CD = 'LP'                               
MFA-TR*           AND KD.FW_PROCESSED_FL   = ' '                                
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * AR_CNTL CURSOR                                                *         
      *****************************************************************         
           EXEC SQL                                                     
               DECLARE AR_CNTL_CSR CURSOR FOR                           
                 SELECT ACCOUNT_NO,                                     
                        PYMT_PRIORITY_LVL,                              
                        ITEM_ID,                                        
                        AMT_AR_DAY_00,                                  
                        AMT_AR_DAY_30,                                  
                        AMT_AR_DAY_60,                                  
                        AMT_AR_DAY_90                                   
                   FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                       
                  WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                     
                  FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE AR_CNTL_CSR CURSOR FOR                                   
MFA-TR*          SELECT ACCOUNT_NO,                                             
MFA-TR*                 PYMT_PRIORITY_LVL,                                      
MFA-TR*                 ITEM_ID,                                                
MFA-TR*                 AMT_AR_DAY_00,                                          
MFA-TR*                 AMT_AR_DAY_30,                                          
MFA-TR*                 AMT_AR_DAY_60,                                          
MFA-TR*                 AMT_AR_DAY_90                                           
MFA-TR*            FROM CSS_AR_CNTL                                             
MFA-TR*           WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                             
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              

SCA006        SET WS-GL-SUB TO 1.
      *                                                                         
      ****************************************************************          
      * 0000-MAIN-PARA.                                              *          
      ****************************************************************          
       0000-MAIN-PARA.                                                  
      *                                                                         
           PERFORM 0100-INITIALIZATION          THRU 0100-EXIT.         
           PERFORM 1000-PROCESS-ACCOUNTS        THRU 1000-EXIT.         
           PERFORM 9000-TERMINATE               THRU 9000-EXIT.         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************02390000
      *   0100-INITIALIZATION                                          *02410000
      *        COMMON INITIALIZATION ROUTINE                           *02420000
      ******************************************************************02440000
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           INITIALIZE       WS-MIN-LPC-AMT                              
                            WS-MIN-LPN-AMT                              
                            WS-MIN-LPC-BALANCE                          
                            WS-MIN-LPN-BALANCE                          
                            WS-LPC-RATE-UTIL                            
                            WS-LPC-RATE-NUTIL                           
                            WS-NSC-DAYS-SW                              
                            WS-01-LPC-RATE-U                            
                            WS-01-LPC-RATE-NON-U                        
                            WS-PSNC-LPC-RATE-U                          
                            WS-PSNC-LPC-RATE-NON-U.                     
ACT335     SET WS-GL-SUB TO 1.                                          
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE              THRU 6251-EXIT.     
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE   THRU 6240-EXIT      
               MOVE WS-FCA00-COMMON-DATE    TO WS-INPUT-DATE            
           END-IF.                                                      
      *                                                                 04650000
           MOVE WS-INPUT-DATE          TO WS-HOLD-DATE,                 
                                          WS-NEW-BUSINESS-DAY,          
                                          WS-CURRENT-DATE.              
      *                                                                 04670100
           MOVE 'COMMON'               TO G6-PROGRAM-NAME.              
           MOVE 20                     TO G6-SEQ-NO.                    
           MOVE '01'                   TO G6-COMPANY-NO.                
           MOVE 'A'                    TO G6-STATUS.                    
           MOVE 'DATE'                 TO G6-CMND-CODE.                 
           PERFORM 7000-GET-REVMON-DTBILL THRU 7000-EXIT.               
      *                                                                 04670100
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE G6-PARM-DATA(15:6)  TO WS-REVENUE-MONTH              
           ELSE                                                         
              MOVE ZEROS               TO WS-REVENUE-MONTH              
           END-IF.                                                      
      *                                                                 04680000
           PERFORM 6500-GET-NEXT-BUSINESS-DAY                           
              THRU 6500-NEXT-BUSINESS-DAY-EXIT.                         
      *                                                                 04690100
P0059A     PERFORM 0120-GET-COMMIT-PARM     THRU 0120-EXIT.             
           MOVE 'DATABASE'                  TO C8-DELINQ-CD.            
           MOVE '01'                        TO C8-COMPANY-NO.           
           PERFORM 7200-GET-DLINQ-VAL       THRU 7200-EXIT.             
           MOVE C8-DELINQ-VALUE             TO WS-DATABASE.             
      *                                                                 04680000
I01687     MOVE 'AMT-LPC-MIN-CHG'        TO C8-DELINQ-CD                
I01687     MOVE '01'                     TO C8-COMPANY-NO               
I01687     PERFORM 7200-GET-DLINQ-VAL    THRU 7200-EXIT                 
I01687     MOVE C8-DELINQ-VALUE          TO WS-AMT-LPC-MIN-CHG.         
I01687                                                                  
ACT101***  MINIMUM BALANCE TO CHARGE LPC                                        
ACT101     MOVE 'AMT-LPC-MIN-BALANCE'    TO C8-DELINQ-CD                
ACT101     MOVE '01'                     TO C8-COMPANY-NO               
ACT101     PERFORM 7200-GET-DLINQ-VAL    THRU 7200-EXIT                 
ACT101     MOVE C8-DELINQ-VALUE          TO WS-AMT-LPC-MIN-BALANCE.     
                                                                        
           PERFORM 0150-LOAD-DELINQ-VALUE THRU    0150-EXIT.            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P0059A******************************************************************        
P0059A**  0120-GET-COMMIT-PARM                                        **        
P0059A******************************************************************        
P0059A*                                                                         
P0059A 0120-GET-COMMIT-PARM.                                            
P0059A*                                                                         
P0059A     MOVE SPACES                 TO WS-SYSIPT.                    
P0059A     MOVE WS-PGRMNAME            TO WS-PROGRAM.                   
P0059A     MOVE WS-PARM                TO WS-COMMAND.                   
P0059A     MOVE ZEROS                  TO WS-SEQUENCE.                  
P0059A                                                                  
P0059A     PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
P0059A                                                                  
P0059A     PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
P0059A          UNTIL (COMMIT-PARM AND INPUT-ACTIVE)                    
P0059A            OR  END-OF-SYSIPT.                                    
P0059A                                                                  
P0059A     MOVE G6-PARM-DATA           TO WS-COMMIT-COUNT.              
P0059A                                                                  
P0059A     EVALUATE TRUE                                                
P0059A        WHEN END-OF-SYSIPT                                        
P0059A           DISPLAY ' '                                            
P0059A           DISPLAY '**  PCSKR120 PROCESSING INFO   **'            
P0059A           DISPLAY '**    COMMIT PARM NOT PRESENT'                
P0059A           DISPLAY '**  DEFAULT CHKP LUW 1000 IS USED'            
P0059A           MOVE WS-DEFAULT-COMMIT-LIMIT TO WS-COMMIT-LIMIT        
P0059A        WHEN WS-COMMIT-NUM NOT NUMERIC                            
P0059A           DISPLAY ' '                                            
P0059A           DISPLAY '**  PCSKR120 PROCESSING ERROR  **'            
P0059A           DISPLAY '**    COMMIT PARM NOT NUMERIC'                
P0059A           DISPLAY '**    KEY = ' WS-INPUT-KEY                    
P0059A           DISPLAY '**  PROCESSING TERMINATED  **'                
P0059A           PERFORM 7611-CLOSE THRU 7611-EXIT                      
P0059A           PERFORM 9900-ABEND  THRU  9900-EXIT                    
P0059A        WHEN WS-COMMIT-NUM NUMERIC                                
P0059A           DISPLAY ' '                                            
P0059A           DISPLAY '**  PCSKR120 PROCESSING INFO  **'             
P0059A           MOVE WS-COMMIT-NUM      TO WS-COMMIT-LIMIT             
P0059A           DISPLAY '** COMMIT LIMIT IS ' WS-COMMIT-LIMIT          
P0059A           PERFORM 7611-CLOSE THRU 7611-EXIT                      
P0059A     END-EVALUATE.                                                
P0059A*                                                                         
P0059A 0120-EXIT.                                                       
P0059A     EXIT.                                                        
P0059A*                                                                         
      *****************************************************************         
      *                                                                         
      * 0150-LOAD-DELINQ-VALUE                                                  
      *                                                                         
      * THIS PARAGRAPH LOADS THE VALUES IN THE DELINQUENCY                      
      ******************************************************************        
      *                                                                         
       0150-LOAD-DELINQ-VALUE.                                          
      *                                                                         
ACT234     MOVE 'LPC-RATE-UTIL'          TO C8-DELINQ-CD.               
      *                                                                         
ACT234     MOVE WS-01-COMPANY            TO C8-COMPANY-NO.              
ACT234     PERFORM 7200-GET-DLINQ-VAL    THRU 7200-EXIT.                
ACT234     MOVE C8-DELINQ-VALUE          TO WS-01-LPC-RATE-U.           
      *                                                                         
ACT234     MOVE 'LPC-RATE-NONUTIL'       TO C8-DELINQ-CD.               
      *                                                                         
ACT234     MOVE WS-01-COMPANY            TO C8-COMPANY-NO.              
ACT234     PERFORM 7200-GET-DLINQ-VAL    THRU 7200-EXIT.                
ACT234     MOVE C8-DELINQ-VALUE          TO WS-01-LPC-RATE-NON-U.       
      *                                                                         
           IF CSR-DATABASE                                              
ACT234         MOVE 'LPC-RATE-UTIL'          TO C8-DELINQ-CD            
ACT234         MOVE WS-PSNC-COMPANY          TO C8-COMPANY-NO           
ACT234         PERFORM 7200-GET-DLINQ-VAL    THRU 7200-EXIT             
ACT234         MOVE C8-DELINQ-VALUE          TO WS-PSNC-LPC-RATE-U      
      *                                                                         
ACT234         MOVE 'LPC-RATE-NONUTIL'       TO C8-DELINQ-CD            
ACT234         MOVE WS-PSNC-COMPANY          TO C8-COMPANY-NO           
ACT234         PERFORM 7200-GET-DLINQ-VAL    THRU 7200-EXIT             
ACT234         MOVE C8-DELINQ-VALUE          TO WS-PSNC-LPC-RATE-NON-U  
           END-IF.                                                      
      *                                                                         
       0150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 08610000
      *                                                                 08620000
      * 1000-PROCESS-ACCOUNTS.                                          08630000
      *                                                                 08640000
      * THE PARAGRAPH CONTROLS THE PROCESSING OF THE ACCOUNTS TO        08641000
      * CALCULATE LPC                                                   08642000
      *                                                                 08643000
      ***************************************************************** 08650000
      *                                                                 08660000
       1000-PROCESS-ACCOUNTS.                                           
                                                                        
I01687     IF CSR-DATABASE                                              
               PERFORM 1100-PROCESS-MASTER-ACCT     THRU 1100-EXIT      
I01687     ELSE                                                         
I01687         PERFORM 1150-PROCESS-ALL-SEB-ACCTS   THRU 1150-EXIT      
I01687     END-IF.                                                      
                                                                        
           PERFORM 1200-PROCESS-FB-ACCT         THRU 1200-EXIT.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 08610000
      *                                                                 08620000
      * 1000-PROCESS-MASTER-ACCT                                        08630000
      *                                                                 08640000
      * MODULE ASSESSES LPC ON A MASTER ACCOUNT WHEN THE DUE DATE       08641000
      * OF THE BILL EQUALS RUN DATE OF PROGRAM.                         08642000
      *                                                                 08643000
      ***************************************************************** 08650000
      *                                                                 08660000
       1100-PROCESS-MASTER-ACCT.                                        
      *                                                                 08671000
P0059A     DISPLAY ' MASTER ACCOUNTS PROCESS'                           
           PERFORM 7370-OPEN-MASTER-CRSR              THRU 7370-EXIT.   
           PERFORM 7375-FETCH-MASTER-CRSR             THRU 7375-EXIT.   
      *                                                                 08672200
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               PERFORM 2000-PROCESS-LPC-0061          THRU 2000-EXIT    
           END-IF.                                                      
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
A04772       IF AT-CODES-DATA-PRESENT(14:1) = 'A'                       
A04772          PERFORM 7390-CHECK-BANK-EFT      THRU 7390-EXIT         
A04772       END-IF                                                     
A04772       IF AUTO-BANK-DRAFT                                         
A04772          CONTINUE                                                
A04772       ELSE                                                       
A04772          MOVE AT-ACCOUNT-NO               TO   WS-ACCOUNT-NO     
A04772          PERFORM 5200-CHK-SKIP-ACCTS      THRU 5200-CPD347-EXIT  
A04772          IF PROCESS-ACCT                                         
A04772             PERFORM 2100-PROCESS-LPC-0068 THRU 2100-EXIT         
F01687             IF WS-LPC-PROCESSED = 'Y'                            
A04772               MOVE 'L'                      TO   CL-PROCESSED-CD 
A04772               MOVE AT-ACCOUNT-NO            TO   CL-ACCOUNT-NO   
A04772               PERFORM 8350-UPDATE-CRED-COLL THRU 8350-EXIT       
I01687               PERFORM 8360-INSERT-ACCT-ATTR THRU 8360-EXIT       
F01687               PERFORM 3400-PROCESS-WQ       THRU 3400-EXIT       
F01687             END-IF                                               
A04772          END-IF                                                  
A04772          ADD 1                            TO   WS-COMMIT-REC-CNTR
A04772          IF WS-COMMIT-REC-CNTR  = WS-COMMIT-LIMIT                
A04772             ADD 1                         TO   WS-COMMIT-COUNTER1
A04772             PERFORM 8898-ISSUE-CHKP       THRU 8898-EXIT         
A04772             DISPLAY 'COMMIT # ' WS-COMMIT-COUNTER1' TAKEN SUCCESS        
A04772-            'FULLY.'                                                     
A04772             MOVE ZEROES                   TO   WS-COMMIT-REC-CNTR
A04772          END-IF                                                  
A04772       END-IF                                                     
A04772       MOVE 'N' TO WS-AUTO-BANK-DRAFT                             
F01687                   WS-LPC-PROCESSED                               
A04772       PERFORM 7375-FETCH-MASTER-CRSR      THRU 7375-EXIT         
           END-PERFORM.                                                 
      *                                                                 08731000
           PERFORM 7380-CLOSE-MASTER-CRSR             THRU 7380-EXIT.   
P0059A     PERFORM 8898-ISSUE-CHKP                    THRU 8898-EXIT.   
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
I01687***************************************************************** 08610000
I01687*                                                                 08620000
I01687* PROCESS ALL SEB ACCOUNTS.                                       08641000
I01687*                                                                 08643000
I01687***************************************************************** 08650000
I01687                                                                  
I01687 1150-PROCESS-ALL-SEB-ACCTS.                                      
I01687                                                                  
I01687     PERFORM 7500-OPEN-SEB-ACCT-CRSR                              
I01687        THRU 7500-EXIT                                            
I01687     PERFORM 7510-FETCH-SEB-ACCT-CRSR                             
I01687        THRU 7510-EXIT                                            
I01687                                                                  
I01687     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
I01687        PERFORM 2000-PROCESS-LPC-0061                             
I01687           THRU 2000-EXIT                                         
I01687     END-IF.                                                      
I01687                                                                  
I01687     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
I01687       IF AT-CODES-DATA-PRESENT(14:1) = 'A'                       
I01687          PERFORM 7390-CHECK-BANK-EFT                             
I01687             THRU 7390-EXIT                                       
I01687       END-IF                                                     
I01687       IF AUTO-BANK-DRAFT                                         
I01687          CONTINUE                                                
I01687       ELSE                                                       
I01687          MOVE AT-ACCOUNT-NO  TO   WS-ACCOUNT-NO                  
I01687          PERFORM 5200-CHK-SKIP-ACCTS                             
I01687             THRU 5200-CPD347-EXIT                                
I01687          IF PROCESS-ACCT                                         
I01687             IF AT-CREDIT-GROUP = 'M'                             
I01687                PERFORM 1400-PROCESS-SEB-MASTER-ACCT              
I01687                   THRU 1400-EXIT                                 
I01687             ELSE                                                 
I01687                PERFORM 1350-VALIDATE-ACCT-FOR-LPC                
I01687                   THRU 1350-EXIT                                 
I01687                IF PROCESS-ACCT                                   
I01687                   PERFORM 1500-PROCESS-SEB-ACCT                  
I01687                      THRU 1500-EXIT                              
I01687                END-IF                                            
I01687             END-IF                                               
I01687             ADD 1              TO   WS-COMMIT-REC-CNTR           
I01687             IF WS-COMMIT-REC-CNTR  = WS-COMMIT-LIMIT             
I01687                ADD 1           TO   WS-COMMIT-COUNTER1           
I01687                PERFORM 8898-ISSUE-CHKP       THRU 8898-EXIT      
I01687                DISPLAY 'COMMIT # ' WS-COMMIT-COUNTER1 ' TAKEN SUC        
I01687-                       'CESSFULLY.'                                      
I01687                MOVE ZEROES     TO   WS-COMMIT-REC-CNTR           
I01687             END-IF                                               
I01687          END-IF                                                  
I01687       END-IF                                                     
I01687       MOVE 'N' TO WS-AUTO-BANK-DRAFT                             
F01687                   WS-LPC-PROCESSED                               
I01687       PERFORM 7510-FETCH-SEB-ACCT-CRSR                           
I01687          THRU 7510-EXIT                                          
I01687     END-PERFORM.                                                 
I01687                                                                  
I01687     PERFORM 7520-CLOSE-SEB-ACCT-CRSR                             
I01687        THRU 7520-EXIT.                                           
I01687                                                                  
I01687     PERFORM 8898-ISSUE-CHKP                                      
I01687        THRU 8898-EXIT.                                           
I01687                                                                  
I01687 1150-EXIT.                                                       
I01687      EXIT.                                                       
      *                                                                 10693100
      ***************************************************************** 08610000
      *                                                                 08620000
      * 1200-PROCESS-FB-ACCT.                                           08630000
      *                                                                 08640000
      * MODULE ASSESSES LPC ON A FINAL BILLED ACCOUNT                   08641000
      *                                                                 08643000
      ***************************************************************** 08650000
      *                                                                 08660000
       1200-PROCESS-FB-ACCT.                                            
P0059A     INITIALIZE WS-COMMIT-REC-CNTR.                               
P0059A     DISPLAY ' FINAL BILLED ACCOUNTS PROCESS'                     
           PERFORM 7400-OPEN-FINAL-WO-ACTN          THRU 7400-EXIT.     
           PERFORM 7410-FETCH-FINAL-WO-ACTN         THRU 7410-EXIT.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               PERFORM 2000-PROCESS-LPC-0061        THRU 2000-EXIT      
           END-IF.                                                      
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
P00599      MOVE FW-ACCOUNT-NO          TO WS-ACCOUNT-NO                
P00599      PERFORM 5200-CHK-SKIP-ACCTS      THRU 5200-CPD347-EXIT      
P00599      IF PROCESS-ACCT                                             
               MOVE FW-ACCOUNT-NO                    TO AT-ACCOUNT-NO   
                                                        KD-ACCOUNT-NO   
                                                        AC-ACCOUNT-NO   
               IF (AT-BANKRUPTCY-IND    = SPACES AND                    
                   AT-JUDGEMENT-CASE-NO = SPACES AND                    
                   AT-TOTAL-AR-BALANCE  > 0)                            
                    PERFORM 1250-AGING-PROCESS         THRU 1250-EXIT   
                    PERFORM 2010-LOAD-LPC-VALUES       THRU 2010-EXIT   
                    PERFORM 2100-PROCESS-LPC-0068      THRU 2100-EXIT   
                    PERFORM 8000-UPD-FIN-WO-ACTION     THRU 8000-EXIT   
               ELSE                                                     
                    PERFORM 8020-UPD-PROCESS-FLAG      THRU 8020-EXIT   
               END-IF                                                   
P00599      END-IF                                                      
P0059A      ADD 1                     TO WS-COMMIT-REC-CNTR             
P0059A      IF WS-COMMIT-REC-CNTR  = WS-COMMIT-LIMIT                    
P0059A        ADD 1 TO WS-COMMIT-COUNTER2                               
P0059A        PERFORM 8898-ISSUE-CHKP                  THRU 8898-EXIT   
P0059A        DISPLAY 'COMMIT # ' WS-COMMIT-COUNTER2' TAKEN SUCCESSFULLY        
P0059A-       '.'                                                               
P0059A        MOVE ZEROES             TO  WS-COMMIT-REC-CNTR            
P0059A      END-IF                                                      
               PERFORM 7410-FETCH-FINAL-WO-ACTN        THRU 7410-EXIT   
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7420-CLOSE-FINAL-WO-ACTN            THRU 7420-EXIT.  
P0059A     PERFORM 8898-ISSUE-CHKP                     THRU 8898-EXIT.  
       1200-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 1250-AGING-PROCESS.                                           *         
      *****************************************************************         
      *                                                                         
       1250-AGING-PROCESS.                                              
      *                                                                         
           INITIALIZE                           WS-NSC-DAYS-SW          
                                                WS-NULL-IND-1           
                                                WS-CURR-DT-25-DAYS-AGO  
                                                WS-NSC-00-DAY-AMT.      
           PERFORM 7050-OPEN-AR-CNTL-CSR              THRU 7050-EXIT.   
           PERFORM 7100-FETCH-AR-CNTL                 THRU 7100-EXIT.   
           PERFORM 1300-MOVE-AR-CNTL-VAL              THRU 1300-EXIT    
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
           PERFORM 7150-CLOSE-AR-CNTL                 THRU 7150-EXIT.   
                                                                        
           MOVE AT-DATE-BILL-DAY-60          TO AT-DATE-BILL-DAY-90.    
           MOVE AT-DATE-BILL-DAY-30          TO AT-DATE-BILL-DAY-60.    
           MOVE AT-DATE-BILL-DAY-00          TO AT-DATE-BILL-DAY-30.    
           MOVE WS-INPUT-DATE                TO AT-DATE-BILL-DAY-00.    
           MOVE AT-CANREB-CODE-60-DAY        TO AT-CANREB-CODE-90-DAY.  
           MOVE AT-CANREB-CODE-30-DAY        TO AT-CANREB-CODE-60-DAY.  
           MOVE AT-CANREB-CODE-00-DAY        TO AT-CANREB-CODE-30-DAY.  
           MOVE 'L'                          TO AT-CANREB-CODE-00-DAY.  
                                                                        
      *                                                                         
       1250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 1300-MOVE-AR-CNTL-VAL                                         *         
      *****************************************************************         
       1300-MOVE-AR-CNTL-VAL.                                           
      *                                                                         
           IF AC-PYMT-PRIORITY-LVL = 19                                 
              MOVE AC-AMT-AR-DAY-00           TO WS-NSC-00-DAY-AMT      
              PERFORM 7300-SELECT-LAST-NSF    THRU 7300-EXIT            
              IF NH-DATE-TRAN > WS-CURR-DT-25-DAYS-AGO                  
                 SET NSC-LT-25-DAYS           TO TRUE                   
              END-IF                                                    
           END-IF.                                                      
                                                                        
           ADD  AC-AMT-AR-DAY-60              TO AC-AMT-AR-DAY-90.      
           MOVE AC-AMT-AR-DAY-30              TO AC-AMT-AR-DAY-60.      
           MOVE AC-AMT-AR-DAY-00              TO AC-AMT-AR-DAY-30.      
           MOVE ZEROES                        TO AC-AMT-AR-DAY-00.      
           PERFORM 8300-UPDATE-AR-CNTL    THRU 8300-EXIT.               
           PERFORM 7100-FETCH-AR-CNTL     THRU 7100-EXIT.               
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
                                                                        
I01687******************************************************************        
I01687** VALIDATE ACCOUNT FOR LPC CALCULATION                                   
I01687******************************************************************        
I01687 1350-VALIDATE-ACCT-FOR-LPC.                                      
ACT039                                                                  
ACT039     IF AT-REV-MTH-LST-NRML > 0 AND                               
ACT039                               AT-DATE-BILL-DAY-00 NOT = SPACES   
ACT039        MOVE AT-ACCOUNT-NO TO X1-ACCOUNT-NO                       
ACT055        MOVE 'N' TO WS-CRED-ARNG-PD-ACTIVE-EXISTS                 
ACT039        PERFORM 7800-CK-CRED-ARNG THRU 7800-EXIT                  
ACT055        IF CRED-ARNG-PD-ACTIVE-EXISTS                             
ACT039           SET SKIP-ACCT TO TRUE                                  
ACT039           GO TO 1350-EXIT                                        
ACT039        END-IF                                                    
ACT039     END-IF.                                                      
I01687                                                                  
I01687     SET PROCESS-ACCT TO TRUE                                     
I01687     MOVE 'N'         TO WS-CANCEL-REBILL-FL                      
ACT114     MOVE SPACES      TO DA-FRST-ERNST-PAY-DT.                    
I01687                                                                  
I01687     MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT          
I01687                                                                  
I01687     PERFORM 7320-GET-CANCEL-REBILL THRU 7320-EXIT                
I01687                                                                  
ACT114     IF WS-CODE-DPP-ACCT = 'A'                                    
ACT114        PERFORM 7330-GET-DPP-EARNEST-DATE THRU 7330-EXIT          
ACT114     END-IF.                                                      
ACT114                                                                  
I01687     IF WS-CODE-STA-ACCT    = 'A'  OR                             
I01687        WS-CODE-CRED-ARNG   = 'A'  OR                             
ACT114        WS-CANCEL-REBILL-FL = 'Y'  OR                             
ACT114        DA-FRST-ERNST-PAY-DT > WS-CURRENT-DATE                    
I01687             SET SKIP-ACCT TO TRUE                                
I01687     END-IF                                                       
I01687                                                                  
I01687     .                                                            
I01687 1350-EXIT.                                                       
I01687      EXIT.                                                       
I01687                                                                  
I01687******************************************************************        
I01687** PROCESS SEB MASTER ACCOUNT                                    *        
I01687******************************************************************        
I01687 1400-PROCESS-SEB-MASTER-ACCT .                                   
I01687     PERFORM 2100-PROCESS-LPC-0068 THRU 2100-EXIT                 
F01687     IF WS-LPC-PROCESSED = 'Y'                                    
I01687        MOVE 'L'                      TO   CL-PROCESSED-CD        
I01687        MOVE AT-ACCOUNT-NO            TO   CL-ACCOUNT-NO          
I01687        PERFORM 8350-UPDATE-CRED-COLL THRU 8350-EXIT              
I01687        PERFORM 8360-INSERT-ACCT-ATTR THRU 8360-EXIT              
F01687        PERFORM 3400-PROCESS-WQ       THRU 3400-EXIT              
F01687     END-IF                                                       
I01687     .                                                            
I01687 1400-EXIT.                                                       
I01687      EXIT .                                                      
I01687                                                                  
I01687******************************************************************        
I01687** PROCESS SEB ACCOUNT (NOT MASTER ACCOUNT)                      *        
I01687******************************************************************        
I01687 1500-PROCESS-SEB-ACCT.                                           
I01687     PERFORM 2100-PROCESS-LPC-0068 THRU 2100-EXIT                 
F01687     IF WS-LPC-PROCESSED = 'Y'                                    
I01687       MOVE 'L'                      TO   CL-PROCESSED-CD         
I01687       MOVE AT-ACCOUNT-NO            TO   CL-ACCOUNT-NO           
I01687       PERFORM 8350-UPDATE-CRED-COLL THRU 8350-EXIT               
I01687       PERFORM 8360-INSERT-ACCT-ATTR THRU 8360-EXIT               
F01687     END-IF                                                       
I01687     .                                                            
I01687 1500-EXIT.                                                       
I01687      EXIT .                                                      
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-LPC-0061.                                         *        
      *                                                                *        
      * LOAD GL INFO                                                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-LPC-0061.                                           
           MOVE WS-PGRMNAME                   TO                        
                                          WS-CPD00061-CALLING-PGM       
           MOVE SPACES                        TO  ABEND-FUNCTION        
           CALL SCSCB061 USING  WS-GL-ACCT-NAME,                        
                                WS-GL-ACCT-MAJOR-FIELDS,                
                                WS-VALID-COMPANY-NOS,                   
                                WS-GL-NAME-INFO,                        
                                WS-GL-ACCT-NO-TABLE,                    
                                WS-CPD00061-CALLING-PGM,                
                                ABEND-FILE,                             
                                RS-RETURN-CODE                          
                                                                        
           IF ABEND-FUNCTION  > SPACES                                  
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 2010-LOAD-LPC-VALUES                                           *        
      *                                                                *        
      * LOAD VALUES FOR CALLING CPD00337 TO GET LPC LPN LIMITS         *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       2010-LOAD-LPC-VALUES.                                            
      *                                                                         
           INITIALIZE       WS-MIN-LPC-AMT                              
                            WS-MIN-LPN-AMT                              
                            WS-MIN-LPC-BALANCE                          
                            WS-MIN-LPN-BALANCE.                         
      *                                                                         
           MOVE 'LP'                   TO F8-FW-BUS-PROCESS-CD.         
           MOVE WS-INPUT-DATE          TO WS-CWS337-PROCESS-DATE.       
           MOVE AT-COMPANY-NO          TO WS-FW-COMPANY.                
           MOVE FW-REG-GROUP-CD        TO WS-REG-GROUP-CD.              
           MOVE FW-FW-PATH-TYPE-CD     TO WS-FW-PATH-TYPE-CD.           
           MOVE KD-FW-ACTION-TYPE-CD   TO WS-FW-ACTION-TYPE-CD.         
      *                                                                         
           PERFORM 5100-GET-FCST-ACTN-DATA    THRU 5100-CPD337-EXIT.    
P0059A     PERFORM 2730-VALIDATE-MATHCH-FOUND THRU 2730-EXIT.           
           MOVE WS-FW-ACTION-LIMIT-AM  TO WS-MIN-LPC-BALANCE.           
      *                                                                         
           MOVE 'LPCMN'                TO WS-FW-ACTION-TYPE-CD.         
           PERFORM 5100-GET-FCST-ACTN-DATA    THRU 5100-CPD337-EXIT.    
P0059A     PERFORM 2730-VALIDATE-MATHCH-FOUND THRU 2730-EXIT.           
           MOVE WS-FW-ACTION-LIMIT-AM  TO WS-MIN-LPC-AMT.               
      *                                                                         
           MOVE 'LPNMN'                TO WS-FW-ACTION-TYPE-CD.         
           PERFORM 5100-GET-FCST-ACTN-DATA    THRU 5100-CPD337-EXIT.    
P0059A     PERFORM 2730-VALIDATE-MATHCH-FOUND THRU 2730-EXIT.           
           MOVE WS-FW-ACTION-LIMIT-AM  TO WS-MIN-LPN-AMT.               
      *                                                                         
           MOVE 'LPN'                  TO WS-FW-ACTION-TYPE-CD.         
           PERFORM 5100-GET-FCST-ACTN-DATA    THRU 5100-CPD337-EXIT.    
P0059A     PERFORM 2730-VALIDATE-MATHCH-FOUND THRU 2730-EXIT.           
           MOVE WS-FW-ACTION-LIMIT-AM  TO WS-MIN-LPN-BALANCE.           
      *                                                                         
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 2100-PROCESS-LPC-0068.                                         *        
      *                                                                *        
      * GET BALANCES FROM CPD00068 AND BEGIN LPC LPN PROCESSING        *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-LPC-0068.                                           
                                                                        
           MOVE AT-CODES-DATA-PRESENT                                   
                            TO WS-CODES-DATA-PRESENT                    
           MOVE 'Y'         TO CALC-BALANCE-SW                          
           MOVE 'Y'         TO CALC-BAL-ONLY-SW                         
I01687     MOVE 'Y'         TO CALC-PAST-DUE-SW                         
I01687                         CALC-ARREARS-SW                          
                                                                        
           MOVE SPACES       TO  ABEND-FUNCTION                         
           CALL SCSCB068  USING  CWS00068-FIELDS,                       
                                 WS-CODES-DATA-PRESENT,                 
                                 DCLCSS-ACCOUNT,                        
                                 ABEND-FILE,                            
                                 RS-RETURN-CODE                         
           IF  ABEND-FUNCTION  > SPACES                                 
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF                                                       
                                                                        
      * ALL COLUMNS FROM LPC/LPN RECEIVABLE WILL BE INCLUDED AS         08681700
      * THIS IS BEING USED AS A SWITCH FOR LPC/LPN RECEIVABLES          08681700
                                                                        
           MOVE 'N' TO WS-LPC-EXISTS-SW                                 
                       WS-LPN-EXISTS-SW                                 
                       WS-UTE-EXISTS-SW                                 
                       WS-UTG-EXISTS-SW.                                
                                                                        
           COMPUTE WS-TOTAL-BALANCE-LPC = (WS-AMT-00-DAY-LPC +          
                                           WS-AMT-30-DAY-LPC +          
                                           WS-AMT-60-DAY-LPC +          
                                           WS-AMT-90-DAY-LPC +          
                                           WS-AMT-TRAN-BALANCE-LPC +    
                                           WS-TOT-SUMM-UNBILLED-LPC +   
                                           WS-AMT-UN-CR-LPC).           
           IF WS-TOTAL-BALANCE-LPC > 0                                  
              MOVE 'Y' TO WS-LPC-EXISTS-SW                              
           END-IF.                                                      
      *                                                                         
           COMPUTE WS-TOTAL-BALANCE-LPN = (WS-AMT-00-DAY-LPN +          
                                           WS-AMT-30-DAY-LPN +          
                                           WS-AMT-60-DAY-LPN +          
                                           WS-AMT-90-DAY-LPN +          
                                           WS-AMT-TRAN-BALANCE-LPN +    
                                           WS-TOT-SUMM-UNBILLED-LPN +   
                                           WS-AMT-UN-CR-LPN).           
           IF WS-TOTAL-BALANCE-LPN > 0                                  
              MOVE 'Y' TO WS-LPN-EXISTS-SW                              
           END-IF.                                                      
      *                                                                         
      * FOR UTE/UTG RECEIVABLE, ONLY BILLED AMOUNTS WILL BE USED        08681700
      *                                                                         
           COMPUTE WS-TOTAL-BALANCE-UTE = (WS-AMT-00-DAY-UTE +          
                                           WS-AMT-30-DAY-UTE +          
                                           WS-AMT-60-DAY-UTE +          
                                           WS-AMT-90-DAY-UTE +          
                                           WS-AMT-UN-CR-UTE).           
           IF WS-TOTAL-BALANCE-UTE > 0                                  
              MOVE 'Y' TO WS-UTE-EXISTS-SW                              
           END-IF.                                                      
      *                                                                         
           COMPUTE WS-TOTAL-BALANCE-UTG = (WS-AMT-00-DAY-UTG +          
                                           WS-AMT-30-DAY-UTG +          
                                           WS-AMT-60-DAY-UTG +          
                                           WS-AMT-90-DAY-UTG +          
                                           WS-AMT-UN-CR-UTG).           
           IF WS-TOTAL-BALANCE-UTG > 0                                  
              MOVE 'Y' TO WS-UTG-EXISTS-SW                              
           END-IF.                                                      
      *                                                                         
           COMPUTE WS-TOTAL-BAL-GAS-ELEC  = (WS-TOTAL-BALANCE-UTE +     
                                            WS-TOTAL-BALANCE-UTG).      
      *                                                                         
           IF AT-COMPANY-NO = '26'                                      
              MOVE WS-PSNC-LPC-RATE-U     TO WS-LPC-RATE-UTIL           
              MOVE WS-PSNC-LPC-RATE-NON-U TO WS-LPC-RATE-NUTIL          
           ELSE                                                         
              MOVE WS-01-LPC-RATE-U  TO WS-LPC-RATE-UTIL                
              MOVE WS-01-LPC-RATE-NON-U  TO WS-LPC-RATE-NUTIL           
           END-IF.                                                      
      *                                                                         
I01687     IF AT-CODE-ACCT-STAT = 'B'                                   
              PERFORM 2500-GET-TOTAL-AMT-CHARGE   THRU 2500-EXIT        
I01687     ELSE                                                         
I01687        PERFORM 2550-GET-TOTAL-AMT-CHARGE   THRU 2550-EXIT        
I01687     END-IF.                                                      
      *                                                                 08681900
           IF WS-TOTAL-CHARGE > 0                                       
               PERFORM 2600-PROCESS-LPC-LPN  THRU 2600-EXIT             
F01687         MOVE 'Y' TO WS-LPC-PROCESSED                             
           ELSE                                                         
              IF AT-CODE-ACCT-STAT = 'B'                                
                  PERFORM 8250-UPDATE-FB-ACCOUNT  THRU 8250-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                 08730600
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 10905000
      *                                                                 10905100
      * 2500-GET-TOTAL-AMT-CHARGE                                       10905200
      *                                                                 10905300
      ***************************************************************** 10905400
      *                                                                 10905500
       2500-GET-TOTAL-AMT-CHARGE.                                       
      *                                                                 10905700
           INITIALIZE WS-TOTAL-LPC-CHG,                                 
                      WS-TOTAL-LPN-CHG,                                 
                      WS-TOTAL-CHARGE.                                  
      *                                                                 10906100
           IF NSC-LT-25-DAYS                                            
              COMPUTE WS-TOTAL-BALANCE-NONUTL =                         
                                      WS-TOTAL-BALANCE-NONUTL -         
                                      WS-NSC-00-DAY-AMT                 
           END-IF.                                                      
                                                                        
           IF WS-TOTAL-BALANCE-UTL = (WS-AMT-00-DAY-LPC +               
                                      WS-AMT-30-DAY-LPC +               
                                      WS-AMT-60-DAY-LPC +               
                                      WS-AMT-90-DAY-LPC +               
                                      WS-AMT-UN-CR-LPC)                 
              COMPUTE WS-TOTAL-BALANCE-NONUTL = WS-TOTAL-BALANCE-UTL +  
                                             WS-TOTAL-BALANCE-NONUTL    
                 MOVE 0 TO WS-TOTAL-BALANCE-UTL                         
           END-IF.                                                      
                                                                        
      * NEED TO LOAD LPC RATE TABLE AT THE BEGINNIG OF PGM INTO WS AND          
      * READ FROM WS INSTEAD OF FROM DB2- WILL NEED UTIL/NON UTIL               
      * AND COMPANY- LOGIC BELOW SHOULD CHEC WS                                 
           IF WS-TOTAL-BALANCE-UTL > WS-MIN-LPC-BALANCE                 
               IF (AT-CODE-LPC-XMT = SPACE) OR                          
                  (AT-CODE-LPC-XMT = 'B')                               
                                                                        
                  COMPUTE WS-RATE = WS-LPC-RATE-UTIL / 100              
      *                                                                 10907000
                  COMPUTE WS-TOTAL-LPC-CHG ROUNDED =                    
                      WS-TOTAL-BALANCE-UTL * WS-RATE                    
                  IF WS-TOTAL-LPC-CHG > WS-MIN-LPC-AMT                  
                      CONTINUE                                          
                  ELSE                                                  
                       MOVE WS-MIN-LPC-AMT TO WS-TOTAL-LPC-CHG          
                  END-IF                                                
               END-IF                                                   
           END-IF.                                                      
      *                                                                 10907500
           IF WS-TOTAL-BALANCE-NONUTL > WS-MIN-LPN-BALANCE              
               IF (AT-CODE-LPC-XMT = SPACE) OR                          
                  (AT-CODE-LPC-XMT = 'A')                               
                                                                        
                  COMPUTE WS-RATE = WS-LPC-RATE-NUTIL / 100             
      *                                                                 10908500
                  COMPUTE WS-TOTAL-LPN-CHG ROUNDED =                    
                      WS-TOTAL-BALANCE-NONUTL * WS-RATE                 
                  IF WS-TOTAL-LPN-CHG > WS-MIN-LPN-AMT                  
                      CONTINUE                                          
                  ELSE                                                  
                       MOVE WS-MIN-LPN-AMT TO WS-TOTAL-LPN-CHG          
                  END-IF                                                
               END-IF                                                   
           END-IF.                                                      
      *                                                                 10909000
           COMPUTE WS-TOTAL-CHARGE =                                    
               WS-TOTAL-LPC-CHG + WS-TOTAL-LPN-CHG.                     
      *                                                                 10909300
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
I01687***************************************************************** 10905000
I01687* 2550-GET-TOTAL-AMT-CHARGE FOR ACTIVE/MASTER ACCOUNTS            10905200
I01687*  CSR AND SEB                                                    10905200
I01687***************************************************************** 10905400
I01687                                                                  
I01687 2550-GET-TOTAL-AMT-CHARGE.                                       
I01687                                                                  
I01687     INITIALIZE WS-TOTAL-LPC-CHG,                                 
I01687                WS-TOTAL-LPN-CHG,                                 
I01687                WS-TOTAL-CHARGE.                                  
I01687                                                                  
I01687     MOVE AT-ACCOUNT-NO TO AC-ACCOUNT-NO                          
I01687     PERFORM 7300-SELECT-LAST-NSF    THRU 7300-EXIT.              
I01687     PERFORM 7310-GET-NSC-DAY-00-AMT THRU 7310-EXIT.              
I01687                                                                  
ACT101***--REDUCE RETURN CHECK MONEY                                    10906100
I01687     IF NH-DATE-TRAN > WS-CURR-DT-25-DAYS-AGO                     
I01687        COMPUTE WS-TOTAL-BALANCE-NONUTL =                         
I01687                                WS-TOTAL-BALANCE-NONUTL -         
I01687                                WS-NSC-00-DAY-AMT                 
I01687     END-IF.                                                      
I01687                                                                  
ACT101***--REDUCE PJS MONEY                                             10906100
ACT101     COMPUTE WS-TOTAL-BALANCE-NONUTL =                            
ACT101                                WS-TOTAL-BALANCE-NONUTL -         
ACT101                                WS-AMT-TRAN-BALANCE-PJS           
ACT101     END-COMPUTE.                                                 
I01687                                                                  
ACT101     IF AT-CREDIT-GROUP = 'M'                                     
I01687       IF WS-TOTAL-BALANCE-UTL = (WS-AMT-00-DAY-LPC +             
I01687                                WS-AMT-30-DAY-LPC +               
I01687                                WS-AMT-60-DAY-LPC +               
I01687                                WS-AMT-90-DAY-LPC +               
I01687                                WS-AMT-UN-CR-LPC)                 
I01687        COMPUTE WS-TOTAL-BALANCE-NONUTL = WS-TOTAL-BALANCE-UTL +  
I01687                                       WS-TOTAL-BALANCE-NONUTL    
I01687        MOVE 0 TO WS-TOTAL-BALANCE-UTL                            
I01687       END-IF                                                     
ACT101     END-IF.                                                      
I01687                                                                  
I01687     IF WS-TOTAL-BALANCE-UTL > 0 OR                               
I01687        WS-AMT-ARREARS-UTL   > 0                                  
I01687         IF (AT-CODE-LPC-XMT = SPACE) OR                          
I01687            (AT-CODE-LPC-XMT = 'B')                               
I01687                                                                  
I01687            COMPUTE WS-RATE = WS-LPC-RATE-UTIL / 100              
I01687                                                                  
I01687            IF AT-DATE-BILL-DAY-00 > WS-CURR-DT-25-DAYS-AGO       
ACT101               MOVE WS-AMT-ARREARS-UTL   TO WS-TOTAL-BALANCE-CALC 
I01687            ELSE                                                  
ACT101               MOVE WS-TOTAL-BALANCE-UTL TO WS-TOTAL-BALANCE-CALC 
I01687            END-IF                                                
I01687                                                                  
ACT101******      WS-AMT-LPC-MIN-BALANCE IS FROM DELINQUENCY            10907000
ACT101            IF WS-TOTAL-BALANCE-CALC >= WS-AMT-LPC-MIN-BALANCE    
ACT101               COMPUTE WS-TOTAL-LPC-CHG ROUNDED =                 
ACT101                       WS-TOTAL-BALANCE-CALC  * WS-RATE           
ACT101            END-IF                                                
I01687                                                                  
ACT101******      WS-AMT-LPC-MIN-CHG IS FROM DELINQUENCY                10907000
ACT101            IF WS-TOTAL-LPC-CHG  > 0 AND                          
I01687               WS-TOTAL-LPC-CHG  < WS-AMT-LPC-MIN-CHG             
I01687                 MOVE WS-AMT-LPC-MIN-CHG TO WS-TOTAL-LPC-CHG      
I01687            END-IF                                                
I01687         END-IF                                                   
I01687     END-IF.                                                      
I01687                                                                  
I01687     IF WS-TOTAL-BALANCE-NONUTL > 0 OR                            
I01687        WS-AMT-ARREARS-NONUTL   > 0                               
I01687         IF (AT-CODE-LPC-XMT = SPACE) OR                          
I01687            (AT-CODE-LPC-XMT = 'A')                               
I01687                                                                  
I01687            COMPUTE WS-RATE = WS-LPC-RATE-NUTIL / 100             
I01687                                                                  
I01687            IF AT-DATE-BILL-DAY-00 > WS-CURR-DT-25-DAYS-AGO       
I01687               COMPUTE WS-TOTAL-LPN-CHG ROUNDED =                 
I01687                     WS-AMT-ARREARS-NONUTL   * WS-RATE            
I01687            ELSE                                                  
I01687               COMPUTE WS-TOTAL-LPN-CHG ROUNDED =                 
I01687                       WS-TOTAL-BALANCE-NONUTL * WS-RATE          
I01687            END-IF                                                
I01687         END-IF                                                   
I01687     END-IF.                                                      
I01687                                                                  
I01687     COMPUTE WS-TOTAL-CHARGE =                                    
I01687         WS-TOTAL-LPC-CHG + WS-TOTAL-LPN-CHG.                     
I01687                                                                  
I01687 2550-EXIT.                                                       
I01687     EXIT.                                                        
      *                                                                         
      ******************************************************************10693200
      *                                                                *10693400
      * 2600-PROCESS-LPC-LPN                                           *10693500
      *                                                                *10693600
      * JOURNAL LPC LPN CHARGES                                                 
      *                                                                         
      ******************************************************************10693800
      *                                                                 10693900
       2600-PROCESS-LPC-LPN.                                            
      *                                                                 10694100
           PERFORM 2700-SETUP-JOURNAL-HDR      THRU 2700-EXIT.          
           PERFORM 2705-CREATE-AR-CNTL         THRU 2705-EXIT.          
      *                                                                 10694400
           IF WS-TOTAL-LPC-CHG > 0                                      
               MOVE WS-AR-LPC         TO WS-PYMT-PRIORITY-LVL           
      *                                                                 10695300
               PERFORM 2710-ALLOCATE-LPC       THRU 2710-EXIT           
               PERFORM 2720-JOURNAL-LPC        THRU 2720-EXIT           
           END-IF.                                                      
      *                                                                 10695000
           IF WS-TOTAL-LPN-CHG > 0                                      
               MOVE WS-AR-LPN         TO WS-PYMT-PRIORITY-LVL           
      *                                                                 10695300
               PERFORM 3005-CREATE-AR-TRAN-DET                          
               THRU 3005-EXIT                                           
      *                                                                 10695600
               PERFORM 3025-CREATE-101-JRNL-ENTRY                       
               THRU 3025-EXIT                                           
           END-IF.                                                      
      *                                                                 10696000
           MOVE 'A'                   TO WS-CODE-LPC.                   
      *                                                                 10696200
           MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT.         
           IF AT-CODE-ACCT-STAT = 'B'                                   
               PERFORM 8250-UPDATE-FB-ACCOUNT       THRU 8250-EXIT      
           ELSE                                                         
               PERFORM 8200-UPDATE-ACCOUNT          THRU 8200-EXIT      
           END-IF.                                                      
      *                                                                 10696500
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10698000
      ******************************************************************10698600
      *                                                                 10698800
      *   PERFORM 2700-SETUP-JOURNAL-HDR                                10698900
      *                                                                 10699000
      ******************************************************************10700000
      *                                                                 10701500
       2700-SETUP-JOURNAL-HDR.                                          
      *                                                                 10701700
           MOVE 0           TO AU-TRAN-APPL-NO.                         
      *                                                                 10701900
           PERFORM 3000-FMT-AR-TRANS-HDR          THRU 3000-EXIT.       
      *                                                                 10702100
           PERFORM 3020-SET-100-JRNL-VARS         THRU 3020-EXIT.       
      *                                                                 10702300
      *                                                                 10702500
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10702800
      ******************************************************************10702900
      *                                                                 10703000
      * 2705-CREATE-AR-CNTL                                             10703100
      *                                                                 10703200
      ******************************************************************10703300
      *                                                                 10703400
       2705-CREATE-AR-CNTL.                                             
      *                                                                 10703600
           MOVE AT-ACCOUNT-NO          TO AC-ACCOUNT-NO.                
      *                                                                 10703800
           IF WS-TOTAL-LPC-CHG > 0                                      
                                                                        
               MOVE WS-AR-LPC          TO WS-PYMT-PRIORITY-LVL          
               IF LPC-EXISTS                                            
                   IF AT-CODE-ACCT-STAT = 'B'                           
                       ADD WS-TOTAL-LPC-CHG   TO WS-AMT-00-DAY-LPC      
                       MOVE WS-AMT-00-DAY-LPC TO AC-AMT-AR-DAY-00       
                       PERFORM 8035-UPDATE-FB-AR-CNTL THRU 8035-EXIT    
                   ELSE                                                 
                       ADD WS-TOTAL-LPC-CHG  TO WS-TOT-SUMM-UNBILLED-LPC
                       MOVE WS-TOT-SUMM-UNBILLED-LPC TO                 
                                                AC-TOT-SUMM-UNBILLED    
                       PERFORM 8030-UPDATE-AR-CNTL    THRU 8030-EXIT    
                   END-IF                                               
               ELSE                                                     
                   IF AT-CODE-ACCT-STAT = 'B'                           
                       MOVE WS-TOTAL-LPC-CHG   TO WS-AMT-00-DAY-LPC     
                       MOVE WS-AMT-00-DAY-LPC TO AC-AMT-AR-DAY-00       
                       PERFORM 8045-CREATE-FB-AR-CNTL THRU 8045-EXIT    
                   ELSE                                                 
                       MOVE WS-TOTAL-LPC-CHG TO WS-TOT-SUMM-UNBILLED-LPC
                       MOVE WS-TOT-SUMM-UNBILLED-LPC TO                 
                                                AC-TOT-SUMM-UNBILLED    
                       PERFORM 8040-CREATE-AR-CNTL    THRU 8040-EXIT    
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                 10705400
           IF WS-TOTAL-LPN-CHG > 0                                      
               MOVE WS-AR-LPN          TO WS-PYMT-PRIORITY-LVL          
      *                                                                 10705800
               IF LPN-EXISTS                                            
                   IF AT-CODE-ACCT-STAT = 'B'                           
                       ADD WS-TOTAL-LPN-CHG   TO WS-AMT-00-DAY-LPN      
                       MOVE WS-AMT-00-DAY-LPN TO AC-AMT-AR-DAY-00       
                       PERFORM 8035-UPDATE-FB-AR-CNTL THRU 8035-EXIT    
                   ELSE                                                 
                       ADD WS-TOTAL-LPN-CHG  TO WS-TOT-SUMM-UNBILLED-LPN
                       MOVE WS-TOT-SUMM-UNBILLED-LPN TO                 
                                                AC-TOT-SUMM-UNBILLED    
                       PERFORM 8030-UPDATE-AR-CNTL    THRU 8030-EXIT    
                   END-IF                                               
               ELSE                                                     
                   IF AT-CODE-ACCT-STAT = 'B'                           
                       MOVE WS-TOTAL-LPN-CHG   TO WS-AMT-00-DAY-LPN     
                       MOVE WS-AMT-00-DAY-LPN TO AC-AMT-AR-DAY-00       
                       PERFORM 8045-CREATE-FB-AR-CNTL THRU 8045-EXIT    
                   ELSE                                                 
                       MOVE WS-TOTAL-LPN-CHG TO WS-TOT-SUMM-UNBILLED-LPN
                       MOVE WS-TOT-SUMM-UNBILLED-LPN TO                 
                                                AC-TOT-SUMM-UNBILLED    
                       PERFORM 8040-CREATE-AR-CNTL    THRU 8040-EXIT    
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                 10706900
       2705-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10707200
      *                                                                 10707300
      ******************************************************************10707400
      *                                                                 10707500
      *                                                                 10707600
      * 2710-ALLOCATE-LPC                                               10707700
      *                                                                 10707800
      *                                                                 10707900
      ******************************************************************10708000
      *                                                                 10708100
       2710-ALLOCATE-LPC.                                               
      *                                                                 10709000
           INITIALIZE WS-LPC-SPLIT-TBL.                                 
      *                                                                 10742200
      *  CHECK TO SEE IF IN A GAS DISTRICT AND IF IT IS, ALL LPC TO     10742200
      *  GAS (PSNC AND SEB ARE ALL GAS DISTRICTS)                       10742200
           EVALUATE TRUE                                                
             WHEN B1-DISTRICT-NO = 'GAS'                                
                MOVE WS-TOTAL-LPC-CHG        TO WS-AMOUNT(1)            
      *                                                                 10786800
                MOVE WS-AR-LPC-GL-NO(WS-GL-SUB)                         
                                             TO WS-GL-ACCOUNT-NO-DR(1)  
                MOVE WS-GREV-LPC-GL-NO(WS-GL-SUB)                       
                                             TO WS-GL-ACCOUNT-NO-CR(1)  
             WHEN UTE-EXISTS AND UTG-EXISTS                             
                PERFORM 2715-PROCESS-ELEC-GAS-ACCT    THRU 2715-EXIT    
             WHEN UTE-EXISTS                                            
                 MOVE WS-TOTAL-LPC-CHG   TO WS-AMOUNT(1)                
                 MOVE WS-AR-LPC-GL-NO(WS-GL-SUB)                        
                                         TO WS-GL-ACCOUNT-NO-DR(1)      
                 MOVE WS-EREV-LPC-GL-NO(WS-GL-SUB)                      
                                         TO WS-GL-ACCOUNT-NO-CR(1)      
             WHEN UTG-EXISTS                                            
                 MOVE WS-TOTAL-LPC-CHG   TO WS-AMOUNT(1)                
                 MOVE WS-AR-LPC-GL-NO(WS-GL-SUB)                        
                                         TO WS-GL-ACCOUNT-NO-DR(1)      
                 MOVE WS-GREV-LPC-GL-NO(WS-GL-SUB)                      
                                         TO WS-GL-ACCOUNT-NO-CR(1)      
             WHEN OTHER                                                 
                 MOVE B1-ELEC-REV-ALLOC-PCT TO WS-ALLOCATION-FACTOR     
      *                                                                         
                 COMPUTE WS-ELEC-REV ROUNDED = (WS-ALLOCATION-FACTOR    
                     * WS-TOTAL-LPC-CHG) / 100                          
      *                                                                 10791200
                 MOVE WS-ELEC-REV          TO WS-AMOUNT(1)              
      *                                                                 10791400
                 MOVE WS-AR-LPC-GL-NO(WS-GL-SUB)                        
                                           TO WS-GL-ACCOUNT-NO-DR(1)    
                 MOVE WS-EREV-LPC-GL-NO(WS-GL-SUB)                      
                                           TO WS-GL-ACCOUNT-NO-CR(1)    
      *                                                                 10791900
                 COMPUTE WS-GAS-REV = WS-TOTAL-LPC-CHG - WS-ELEC-REV    
      *                                                                 10792100
                 MOVE WS-GAS-REV           TO WS-AMOUNT(2)              
      *                                                                 10792300
                 MOVE WS-AR-LPC-GL-NO(WS-GL-SUB)                        
                                           TO WS-GL-ACCOUNT-NO-DR(2)    
                 MOVE WS-GREV-LPC-GL-NO(WS-GL-SUB)                      
                                           TO WS-GL-ACCOUNT-NO-CR(2)    
      *                                                                 10792800
           END-EVALUATE.                                                
      *                                                                 10744000
       2710-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10788800
      ******************************************************************10788900
      *                                                                 10789100
      * 2715-PROCESS-ELEC-GAS-ACCT                                      10789200
      *                                                                 10789300
      ******************************************************************10789500
      *                                                                 10789600
       2715-PROCESS-ELEC-GAS-ACCT.                                      
      *                                                                 10789800
           IF WS-TOTAL-BAL-GAS-ELEC = 0                                 
              MOVE 0 TO WS-ALLOCATION-FACTOR                            
              DISPLAY 'ALLOCATION FACTOR SET TO 0 FOR ' AT-ACCOUNT-NO   
           ELSE                                                         
              COMPUTE WS-ALLOCATION-FACTOR ROUNDED                      
               = (WS-TOTAL-BALANCE-UTE / WS-TOTAL-BAL-GAS-ELEC) * 100   
           END-IF.                                                      
                                                                        
      *                                                                 10790900
           COMPUTE WS-ELEC-REV ROUNDED = (WS-ALLOCATION-FACTOR          
               * WS-TOTAL-LPC-CHG) / 100.                               
      *                                                                 10791200
           MOVE WS-ELEC-REV               TO WS-AMOUNT(1).              
      *                                                                 10791400
           MOVE WS-AR-LPC-GL-NO(WS-GL-SUB)                              
                                          TO WS-GL-ACCOUNT-NO-DR(1).    
           MOVE WS-EREV-LPC-GL-NO(WS-GL-SUB)                            
                                          TO WS-GL-ACCOUNT-NO-CR(1).    
      *                                                                 10791900
           COMPUTE WS-GAS-REV = WS-TOTAL-LPC-CHG - WS-ELEC-REV.         
      *                                                                 10792100
           MOVE WS-GAS-REV                TO WS-AMOUNT(2).              
      *                                                                 10792300
           MOVE WS-AR-LPC-GL-NO(WS-GL-SUB)                              
                                          TO WS-GL-ACCOUNT-NO-DR(2).    
           MOVE WS-GREV-LPC-GL-NO(WS-GL-SUB)                            
                                          TO WS-GL-ACCOUNT-NO-CR(2).    
      *                                                                 10792800
           MOVE WS-ALLOCATION-FACTOR    TO    AT-ELEC-REV-ALLOC-PCT.    
           PERFORM 8105-UPDATE-ALLOC-PCT-AT    THRU 8105-EXIT.          
      *                                                                 10792800
       2715-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10793100
      ******************************************************************10793200
      *                                                                 10793300
      *                                                                 10793400
      * 2720-JOURNAL-LPC                                                10793500
      *                                                                 10793600
      *                                                                 10793700
      ******************************************************************10793800
      *                                                                 10793900
       2720-JOURNAL-LPC.                                                
      *                                                                 10794100
           PERFORM VARYING WS-INDX FROM 1 BY 1                          
               UNTIL WS-INDX > 2                                        
      *                                                                 10794500
             IF WS-AMOUNT(WS-INDX) > 0                                  
                 PERFORM 3005-CREATE-AR-TRAN-DET                        
                 THRU 3005-EXIT                                         
      *                                                                 10794800
                 PERFORM 3025-CREATE-101-JRNL-ENTRY                     
                 THRU 3025-EXIT                                         
             END-IF                                                     
      *                                                                 10795100
           END-PERFORM.                                                 
      *                                                                 10796100
       2720-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10796500
P0059A******************************************************************10793200
P0059A* 2730-VALIDATE-MATHCH-FOUND                                     *10793500
P0059A******************************************************************10793200
P0059A                                                                  
P0059A 2730-VALIDATE-MATHCH-FOUND.                                      
P0059A                                                                  
P0059A     IF F8-MATCH-FOUND                                            
P0059A        CONTINUE                                                  
P0059A     ELSE                                                         
P0059A        DISPLAY '**************PCSKR120*************************' 
P0059A        DISPLAY '* NO MATCH FOUND ON CSS_FW_FCST_ACTION TABLE.  ' 
P0059A        DISPLAY '* RETURN CODE = 12'                              
P0059A        DISPLAY '**************PCSKR120*************************' 
P0059A        PERFORM 9900-ABEND   THRU 9900-EXIT                       
P0059A     END-IF.                                                      
P0059A                                                                  
P0059A 2730-EXIT.                                                       
P0059A     EXIT.                                                        
P0059A                                                                  
      ****************************************************************  10796600
      **                                                            **  10796700
      **    3000-FMT-AR-TRANS-HDR.                                  **  10796800
      **        FORMATS COMMON FIELDS FOR AR TRANS HIST             **  10796900
      **                                                            **  10797000
      ****************************************************************  10797100
      *                                                                 10797200
       3000-FMT-AR-TRANS-HDR.                                           
      *                                                                 10797400
           PERFORM 7270-SELECT-TIMESTAMP            THRU 7270-EXIT.     
      *                                                                 10797600
           MOVE AT-ACCOUNT-NO          TO AR-ACCOUNT-NO.                
           MOVE WS-TIMESTAMP           TO AR-TRANS-HIST-SEQ-NO.         
           MOVE WS-CURRENT-DATE        TO AR-DATE-TRANS                 
                                          AR-DATE-CASH-REPORT.          
           MOVE WS-PGRMNAME            TO AR-APPL-PROGRAM-ID.           
           MOVE WS-SYSTEM              TO AR-USER-ID.                   
           MOVE AT-COMPANY-NO          TO AR-COMPANY-NO.                
           MOVE SPACES                 TO AR-RECORD-ONLY-FL.            
           MOVE SPACES                 TO AR-RESP-AREA-ID               
                                          AR-PYMT-FACILITY-CD           
                                          AR-TRAN-COMMENT-TEXT          
                                          AR-DATE-ORIG-PYMT             
                                          AR-PYMT-REFUNDED-IND.         
           MOVE -1                     TO WS-DATE-ORIG-PYMT-IND.        
           MOVE ZEROES                 TO AR-TRAN-COMMENT-LEN.          
           IF AT-CODE-ACCT-STAT = 'B'                                   
               MOVE 'PCSKR120A'    TO AR-APPL-PROGRAM-ID                
               ADD WS-TOTAL-CHARGE TO AT-TOTAL-AR-BALANCE               
           END-IF.                                                      
           MOVE AT-TOTAL-AR-BALANCE    TO AR-AMT-BILLED-UNPAID.         
           MOVE ZERO                   TO AR-AMT-ORIG-ENTERED.          
           MOVE WS-CASH-COMPANY-NO     TO AR-CASH-COMPANY-NO.           
           MOVE AT-LOCAL-OFFICE        TO AR-CASH-LOCAL-OFFICE.         
           MOVE WS-CASH-REPORT-NO      TO AR-CASH-REPORT-NO.            
           MOVE WS-CASH-DRAWER-ID      TO AR-CASH-DRAWER-ID.            
      *    MOVE SPACES                 TO AR-DATE-CASH-REPORT.          10799600
      *                                                                 10799700
           MOVE 'S'                    TO AR-CODE-TRAN-TYPE.            
           MOVE WS-TOTAL-CHARGE        TO AR-AMT-ORIG-ENTERED.          
      *                                                                 10800000
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10800300
      ****************************************************************  10848900
      **                                                            **  10849000
      **    3005-CREATE-AR-TRAN-DET                                 **  10849100
      **                                                            **  10849200
      ****************************************************************  10849300
      *                                                                 10849400
       3005-CREATE-AR-TRAN-DET.                                         
      *                                                                 10849600
           MOVE AT-ACCOUNT-NO            TO AU-ACCOUNT-NO.              
           MOVE WS-TIMESTAMP             TO AU-TRANS-HIST-SEQ-NO.       
      *                                                                 10849900
           ADD +1                        TO AU-TRAN-APPL-NO.            
           IF AT-CODE-ACCT-STAT = 'B'                                   
               MOVE ZEROS                    TO AU-CODE-AR-AGE          
           ELSE                                                         
               MOVE SPACES                   TO AU-CODE-AR-AGE          
           END-IF.                                                      
                                                                        
           MOVE SPACES                   TO AU-CODE-CONTRACT-TYPE.      
                                                                        
           IF (WS-PYMT-PRIORITY-LVL = WS-AR-LPC)                        
               MOVE WS-AMOUNT(WS-INDX) TO AU-AMT-POSTED                 
               MOVE WS-GL-ACCOUNT-NO-DR(WS-INDX)                        
                                       TO AU-GL-ACCT-DEBIT              
               MOVE WS-GL-ACCOUNT-NO-CR(WS-INDX)                        
                                       TO AU-GL-ACCT-CREDIT             
           ELSE                                                         
               MOVE WS-TOTAL-LPN-CHG   TO AU-AMT-POSTED                 
               MOVE WS-AR-LPN-GL-NO(WS-GL-SUB)                          
                                       TO AU-GL-ACCT-DEBIT              
               MOVE WS-REV-LPN-GL-NO(WS-GL-SUB)                         
                                       TO AU-GL-ACCT-CREDIT             
           END-IF.                                                      
      *                                                                 10904000
           MOVE ZERO                 TO AU-ITEM-ID.                     
           MOVE SPACES               TO AU-CURRENCY-TYPE.               
           MOVE ZERO                 TO AU-CURRENCY-AMT.                
      *                                                                 10904400
           PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST THRU 6500-EXIT.        
      *                                                                 10904600
       3005-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10904900
      *                                                                 10909600
      ***************************************************************   10909700
      *                                                             *   10909800
      * 3020-SET-100-JRNL-VARS                                      *   10909900
      *                                                             *   10910000
      * POPULATES THE 100 VARIBLES FOR JOURNALLING.                 *   10910100
      *                                                             *   10910200
      ***************************************************************   10910300
      *                                                                 10910400
       3020-SET-100-JRNL-VARS.                                          
      *                                                                 10910600
      *                                                                 10910700
           MOVE WS-CASH-COMPANY-NO   TO WS-JRNL-BT-BAT-COMPANY.         
           MOVE WS-CASH-LOCAL-OFFICE TO WS-JRNL-BT-BAT-LOC-OFF.         
           MOVE WS-CASH-REPORT-NO    TO WS-JRNL-BT-BAT-REPORT-NO.       
           MOVE WS-CURRENT-DATE      TO WS-JRNL-BT-BAT-REPORT-DT.       
           MOVE WS-CASH-DRAWER-ID    TO WS-JRNL-BT-BAT-CASH-DRWR.       
           MOVE SPACES               TO WS-JRNL-BT-ENTRY-LOC.           
      *                                                                 10911600
           MOVE SPACES               TO WS-JRNL-CURRENCY-TYPE           
                                        WS-JRNL-CODE-PYMT-FACILITY.     
      *                                                                 10912300
           MOVE 'A'                     TO WS-100-JRNL-SORT-ID.         
           MOVE AT-ACCOUNT-NO           TO WS-100-ACCT-NO.              
           MOVE AT-CUSTOMER-NO          TO WS-100-CUSTOMER-NO.          
           MOVE AT-COMPANY-NO           TO WS-100-COMPANY-NO.           
           MOVE AT-PREMISE-NO           TO WS-100-PREMISE-NO.           
           MOVE 'K120'                  TO WS-100-CODE-TERMINAL-TRAN.   
           MOVE AU-TRAN-APPL-NO         TO WS-100-JRNL-TRAN-APPL-NO.    
           MOVE WS-CURRENT-DATE         TO WS-100-DATE-LAST-ACTION.     
           MOVE 'B'                     TO WS-100-CODE-ENTRY-SOURCE.    
           MOVE AT-LOCAL-OFFICE         TO WS-100-LOCAL-OFFICE-CD.      
           MOVE SPACES                  TO WS-100-TRANS-ERRORS.         
      *                                                                 10913700
           MOVE WS-JRNL-SELECT-AND-OR-INS TO WS-JRNL-OPERATION-RQST.    
           PERFORM 6400-BATCH-JRNL-ROUTINE            THRU 6400-EXIT.   
      *                                                                 10914000
           MOVE 'B'                     TO WS-JRNL-SOURCE-CODE.         
           MOVE WS-JRNL-CASH-UPDATE     TO WS-JRNL-BT-AUTH-TYPE.        
      *                                                                 10914300
       3020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10914600
      ***************************************************************   10914700
      *                                                             *   10914800
      * 3025-CREATE-101-JRNL-ENTRY                                  *   10914900
      *                                                             *   10915000
      * POPULATES THE 101 VARIBLES FOR JOURNALLING.                 *   10915100
      *                                                             *   10915200
      ***************************************************************   10915300
      *                                                                 10915400
       3025-CREATE-101-JRNL-ENTRY.                                      
      *                                                                 10915600
           INITIALIZE CJF00101.                                         
      *                                                                 10915800
           MOVE AU-TRAN-APPL-NO        TO WS-100-JRNL-TRAN-APPL-NO.     
      *                                                                 10916100
           MOVE 101                    TO WS-101-JRNL-FORMAT-NO.        
      *                                                                 10916300
           MOVE 'X'                    TO WS-101-CASH-DRAWER-USED.      
      *                                                                 10916500
           MOVE WS-TOTAL-CHARGE        TO WS-101-AMOUNT-ENTERED.        
      *                                                                 10916700
           IF WS-PYMT-PRIORITY-LVL = WS-AR-LPC                          
      *                                                                 10916900
               MOVE WS-AMOUNT(WS-INDX) TO WS-101-AMT-POSTED             
               MOVE WS-GL-ACCOUNT-NO-DR(WS-INDX)                        
                                     TO WS-101-ACCT-GEN-LED-DR          
               MOVE WS-GL-ACCOUNT-NO-CR(WS-INDX)                        
                                     TO WS-101-ACCT-GEN-LED-CR          
           ELSE                                                         
               MOVE WS-TOTAL-LPN-CHG TO WS-101-AMT-POSTED               
               MOVE WS-AR-LPN-GL-NO(WS-GL-SUB)                          
                                     TO WS-101-ACCT-GEN-LED-DR          
               MOVE WS-REV-LPN-GL-NO(WS-GL-SUB)                         
                                     TO WS-101-ACCT-GEN-LED-CR          
           END-IF.                                                      
      *                                                                 10918200
           MOVE WS-101-AMT-POSTED    TO WS-JRNL-CASH-DEBIT-AMT          
                                        WS-JRNL-GEN-LEG-CREDIT-AMT.     
      *                                                                 10918500
           MOVE WS-REVENUE-MONTH     TO WS-101-REVENUE-MONTH.           
      *                                                                 10918700
           MOVE SPACE                TO WS-101-AR-AGE.                  
      *                                                                 10918900
           MOVE WS-CURRENT-DATE      TO WS-101-DATE-AR-BILLED.          
      *                                                                 10919100
           MOVE ZERO                 TO WS-101-ITEM-ID-NO,              
                                        WS-101-DETAIL-END-BAL,          
                                        WS-101-DETAIL-END-AR-BAL.       
      *                                                                 10919500
           MOVE AT-TOTAL-AR-BALANCE  TO WS-101-ACCT-END-AR-BAL.         
      *                                                                 10919700
           MOVE PR-REV-DISTRICT-CD   TO WS-101-CODE-REVENUE-DISTRICT.   
           MOVE 0                    TO WS-101-CODE-EMPL-ACCT.          
           MOVE AT-CODE-COMPANY-ACCT TO WS-101-CODE-COMPANY-ACCT.       
           MOVE WS-A                 TO WS-101-CODE-ACCOUNT-STATUS.     
           MOVE PR-CODE-PREMISE-STAT TO WS-101-CODE-PREMISE-STATUS.     
      *                                                                 10921000
           MOVE WS-N                 TO WS-UPDATE-JRNL-CNTL-NOW.        
      *                                                                 10922000
           MOVE CJF00101             TO WS-100-USER-DEFINED-AREA.       
                                                                        
           MOVE WS-JRNL-ONLY         TO WS-JRNL-OPERATION-RQST.         
      *                                                                 10980300
           PERFORM 6400-BATCH-JRNL-ROUTINE            THRU 6400-EXIT.   
      *                                                                 10980500
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT    
           END-IF.                                                      
      *                                                                 10981100
           MOVE WS-JRNL-CNTRL-ONLY    TO WS-JRNL-OPERATION-RQST         
      *                                                                 10981300
           PERFORM 6400-BATCH-JRNL-ROUTINE            THRU 6400-EXIT.   
      *                                                                 10982000
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT    
           END-IF.                                                      
      *                                                                 10982600
      *                                                                 10982700
       3025-EXIT.                                                       
           EXIT.                                                        
                                                                        
F01687***************************************************************           
F01687* PROCESS WQ FOR MASTER ACCOUNTS                                          
F01687***************************************************************           
F01687                                                                  
F01687 3400-PROCESS-WQ.                                                 
F01687                                                                  
F01687     MOVE +5                    TO WS-WQ-CATEGORY                 
F01687     MOVE WS-TOTAL-CHARGE       TO WS-LPC-AMOUNT                  
F01687     MOVE WS-TOTAL-BALANCE      TO WS-ACCOUNT-BALANCE             
F01687                                                                  
F01687     MOVE WS-WORKQUEUE-COMMENTS TO WS-COMMENTS-TEXT               
F01687     MOVE +53                   TO WS-COMMENTS-LEN                
F01687     PERFORM 3500-CREATE-WORK-QUEUE         THRU 3500-EXIT        
F01687      .                                                           
F01687 3400-EXIT.                                                       
F01687      EXIT.                                                       
      *                                                                         
      *                                                                 10990000
      ****************************************************************  11183800
      *                                                                 11183900
      * 3500-CREATE-WORK-QUEUE                                          11184000
      *                                                                 11184100
      ****************************************************************  11184200
      *                                                                 11184300
       3500-CREATE-WORK-QUEUE.                                          
      *                                                                 11184500
ACT050     INITIALIZE CWS00077-FIELDS.                                  
ACT050     INITIALIZE   WS-77-COMMENTS.                                 
ACT050*                                                                 11184900
ACT050     MOVE AT-ACCOUNT-NO           TO WS-77-ACCOUNT-NO.            
ACT050     MOVE AT-CUSTOMER-NO          TO WS-77-CUSTOMER-NO.           
ACT050     MOVE AT-PREMISE-NO           TO WS-77-PREMISE-NO.            
ACT050     MOVE AT-LOCAL-OFFICE         TO WS-77-LOCAL-OFFICE.          
ACT050     MOVE WS-WQ-CATEGORY          TO WS-77-CATEGORY-ID.           
ACT050*                                                                 11185600
ACT050     MOVE WS-COMMENTS-TEXT        TO WS-77-COMMENTS-TEXT.         
ACT050     MOVE WS-COMMENTS-LEN         TO WS-77-COMMENTS-LEN.          
ACT050*                                                                 11185900
ACT050     MOVE 4                       TO WS-77-ROUTE-CATEGORY.        
ACT050     IF WS-WQ-PRIORITY  = 'H'                                     
ACT050         MOVE 'H'                 TO WS-77-PRIORITY               
ACT050     ELSE                                                         
ACT050         MOVE 'N'                 TO WS-77-PRIORITY               
ACT050     END-IF.                                                      
ACT050                                                                  
ACT050     MOVE WS-INPUT-DATE           TO WS-INPUT-DATE-26(1:10).      
ACT050     MOVE WS-INPUT-ZERO           TO WS-INPUT-DATE-26(11:16).     
ACT050     MOVE WS-INPUT-DATE-26        TO WS-77-DATE-CREATED.          
ACT050                                                                  
ACT050     MOVE WS-NEW-BUSINESS-DAY     TO WS-77-DATE-REQUIRED.         
ACT050     MOVE WS-PGRMNAME             TO WS-77-CREATED-BY.            
      *                                                                 11186400
           PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.               
                                                                        
       3500-EXIT.                                                       
           EXIT.                                                        
      * PARAGRAPH 5100-GET-FCST-ACTN-DATA IS IN CPD00337.               11187000
      *                                                                 11187100
           EXEC SQL                                                     11189600
               INCLUDE CPD00337                                         11189700
           END-EXEC.                                                    11189800
P00599*                                                                         
P00599* PARAGRAPH 5200-CHK-SKIP-ACCTS IS IN CPD00347                    11187000
P00599*                                                                 11187100
P00599                                                                  
P00599     EXEC SQL                                                             
P00599        INCLUDE CPD00347                                                  
P00599     END-EXEC.                                                            
                                                                        
      *                                                                 11187300
      *                                                                 11188500
      * PARAGRAPH 6240-GET-FCA00-COMMON-DATE IS IN CPD00040.            11187000
      *                                                                 11187100
       COPY CPD00040.                                                   11187200
      *                                                                 11188500
      * PARAGRAPH 6251-GET-FJC01-DATE IS IN CPD00037.                   11188600
      *                                                                 11188700
       COPY CPD00037.                                                   11188800
      *                                                                 11188900
      *                                                                 11186900
      ***************************************************************** 11189000
      *                                                                 11189100
      * 6400-BATCH-JRNL-ROUTINE                                         11189200
      *                                                                 11189300
      ***************************************************************** 11189400
      *                                                                 11189500
           EXEC SQL                                                     11189600
               INCLUDE CPD00007                                         11189700
           END-EXEC.                                                    11189800
      *                                                                 11190000
      *****************************************************************         
      *    6500-GET-NEXT-BUSINESS-DAY                                **         
      *    COPYBOOK CPD00322 CONTAINS THE LOGIC FOR FINDING          **         
      *    THE NEXT BUSINESS DAY.                                    **         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD00322                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    6500-ONLINE-LOAD-AR-TRAN-HIST                             **         
      *    COPYBOOK CPD00008 CONTAINS THE LOGIC FOR INSERTING        **         
      *    TO CSS_AR_TRANS_HIST AND CSS_AR_TR_TRN_HST_DET            **         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD00008                                                 
           END-EXEC.                                                            
      *                                                                 10990000
      ************************************************************              
      * SELECT THE REVENUE MONTH FROM CSS_JOB_PARM               *              
      ************************************************************              
      *                                                                         
       7000-GET-REVMON-DTBILL.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT PARM_DATA                                         
                 INTO :G6-PARM-DATA                                     
                 FROM CSS_JOB_PARM                                      
                WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                   
                  AND COMPANY_NO   = :G6-COMPANY-NO                     
                  AND CMND_CODE    = :G6-CMND-CODE                      
                  AND SEQ_NO       = :G6-SEQ-NO                         
                  AND STATUS       = :G6-STATUS                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*********************************'              
               DISPLAY '*** PCSKR120 PROCESSING ERROR ***'              
               DISPLAY '*** 7000-GET-REVMON-DTBILL    ***'              
               DISPLAY '*** PROGRAM NAME ' G6-PROGRAM-NAME              
               DISPLAY '*** CONMANY NO   ' G6-COMPANY-NO                
               DISPLAY '*** CMND_CODE    ' G6-CMND-CODE                 
               DISPLAY '*** SEQ_NO       ' G6-SEQ-NO                    
               DISPLAY '*** STATUS       ' G6-STATUS                    
               DISPLAY '*********************************'              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12941900
      *****************************************************************         
      * 7050-OPEN-AR-CNTL-CSR.                                        *         
      *****************************************************************         
       7050-OPEN-AR-CNTL-CSR.                                           
      *                                                                         
           EXEC SQL                                                     
              OPEN AR_CNTL_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*********************************'              
               DISPLAY '*** PCSKR120 PROCESSING ERROR ***'              
               DISPLAY '*** 7050-OPEN-AR-CNTL-CSR     ***'              
               DISPLAY '*** SQLCODE    = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '*********************************'              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 7100-FETCH-AR-CNTL                                            *         
      *****************************************************************         
       7100-FETCH-AR-CNTL.                                              
      *                                                                         
            EXEC SQL                                                    
                FETCH AR_CNTL_CSR                                       
                INTO                                                    
                   :AC-ACCOUNT-NO,                                      
                   :AC-PYMT-PRIORITY-LVL,                               
                   :AC-ITEM-ID,                                         
                   :AC-AMT-AR-DAY-00,                                   
                   :AC-AMT-AR-DAY-30,                                   
                   :AC-AMT-AR-DAY-60,                                   
                   :AC-AMT-AR-DAY-90                                    
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL (SUCCESSFUL-CALL OR NOT-FOUND)
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*********************************'              
               DISPLAY '*** PCSKR120 PROCESSING ERROR ***'              
               DISPLAY '*** 7100-FETCH-AR-CNTL        ***'              
               DISPLAY '*** ACCOUNT NO   ' AC-ACCOUNT-NO                
               DISPLAY '*** SQLCODE    = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '*********************************'              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
            EXIT.                                                       
      *****************************************************************         
      * 7150-CLOSE-AR-CNTL                                            *         
      *****************************************************************         
       7150-CLOSE-AR-CNTL.                                              
      *                                                                         
            EXEC SQL                                                    
                CLOSE AR_CNTL_CSR                                       
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*********************************'              
               DISPLAY '*** PCSKR120 PROCESSING ERROR ***'              
               DISPLAY '*** 7150-CLOSE-AR-CNTL        ***'              
               DISPLAY '*** SQLCODE    = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '*********************************'              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * 7200-GET-DLINQ-VAL.                                           *         
      *****************************************************************         
      *                                                                         
       7200-GET-DLINQ-VAL.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT C8.DELINQ_VALUE                                    
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
               WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                      
                 AND C8.COMPANY_NO = :C8-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                              
MFA-TR*          AND C8.COMPANY_NO = :C8-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   ERROR ON 7200-GET-DLINQ-VAL      **'        
              DISPLAY '**   DELINQ CD   = ' C8-DELINQ-CD                
              DISPLAY '**   COMPANY NO  = ' C8-COMPANY-NO               
              DISPLAY '**   SQLCODE     = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  12942000
      *                                                             **  12942100
      *   7270-SELECT-TIMESTAMP.                                    **  12942200
      *                                                             **  12942300
      *                                                             **  12942400
      ****************************************************************  12942500
       7270-SELECT-TIMESTAMP.                                           
      *                                                                 12942700
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     12943000
MFA-TR*         SET: WS-TIMESTAMP         = CURRENT TIMESTAMP           12943100
MFA-TR*    END-EXEC.                                                    12943200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12943300
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 12943500
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '** ERROR IN 7270-SELECT-TIMESTAMP        **'    
               DISPLAY '**        RETURN CODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '**        PROCESSING IS TERMINATED       **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 12944400
       7270-EXIT.                                                       
            EXIT.                                                       
      *                                                                 12950000
      ****************************************************************  12942000
      *                                                             **  12942100
      *   7300-SELECT-LAST-NSF.                                     **  12942200
      * GET MAX RETURNED CHECK DATE FROM NSF_HIST.                  **  12942300
      *                                                             **  12942400
      ****************************************************************  12942500
       7300-SELECT-LAST-NSF.                                            
      *                                                                 12942700
           EXEC SQL                                                     
              SELECT MAX(DATE_TRAN),                                    
                     DATEADD( DAY, -25, IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) ) )                     
                INTO  :NH-DATE-TRAN :WS-NULL-IND-1,                     
                      :WS-CURR-DT-25-DAYS-AGO                           
              FROM  CSS_NSF_HIST WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                         
I01687                                                           
I01687                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     23410000
MFA-TR*       SELECT MAX(DATE_TRAN),                                    23420000
MFA-TR*              DATE(:WS-INPUT-DATE) - 25 DAYS                             
MFA-TR*         INTO  :NH-DATE-TRAN :WS-NULL-IND-1,                     23430000
MFA-TR*               :WS-CURR-DT-25-DAYS-AGO                                   
MFA-TR*       FROM  CSS_NSF_HIST                                        23440000
MFA-TR*       WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                         23450000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                    23460000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23470000
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              IF WS-NULL-IND-1 = -1                                     
                 MOVE SPACES              TO NH-DATE-TRAN               
                 MOVE ZEROES              TO WS-NULL-IND-1              
              END-IF                                                    
           ELSE                                                         
               DISPLAY '** ERROR IN 7300-SELECT-LAST-NSF         **'    
               DISPLAY '**        RETURN CODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '**        ACCOUNT NO  = ' AC-ACCOUNT-NO         
               DISPLAY '**        PROCESSING IS TERMINATED       **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23630000
I01687****************************************************************  12942000
I01687* GET AMT_AR_DAY_00 FOR NSC(PPL = 19)                         **  12942300
I01687****************************************************************  12942500
I01687 7310-GET-NSC-DAY-00-AMT.                                         
I01687                                                                  
I01687     EXEC SQL                                                     
I01687        SELECT AMT_AR_DAY_00                                      
I01687          INTO  :AC-AMT-AR-DAY-00                                 
I01687        FROM  CSS_AR_CNTL WITH(READUNCOMMITTED)                           
I01687        WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                  
I01687        AND   PYMT_PRIORITY_LVL = 19                              
I01687                                                           
I01687                                                      
I01687     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     23410000
MFA-TR*       SELECT AMT_AR_DAY_00                                      23420000
MFA-TR*         INTO  :AC-AMT-AR-DAY-00                                 23430000
MFA-TR*       FROM  CSS_AR_CNTL                                         23440000
MFA-TR*       WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                  23450000
MFA-TR*       AND   PYMT_PRIORITY_LVL = 19                              23450000
MFA-TR*       WITH UR                                                   23450000
MFA-TR*       QUERYNO 7310                                              23450000
MFA-TR*    END-EXEC.                                                    23460000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I01687                                                                  
I01687     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
I01687     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL OR         
I01687                                             NOT-FOUND            
I01687        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
I01687           MOVE ZEROES              TO AC-AMT-AR-DAY-00           
I01687        END-IF                                                    
I01687     ELSE                                                         
I01687         DISPLAY '** ERROR IN 7310-GET-NSC-DAY-00-AMT      **'    
I01687         DISPLAY '**        RETURN CODE = ' WS-ACTIVE-RETURN-CODE 
I01687         DISPLAY '**        ACCOUNT NO  = ' AC-ACCOUNT-NO         
I01687         DISPLAY '**        PROCESSING IS TERMINATED       **'    
I01687         PERFORM 9900-ABEND                THRU 9900-EXIT         
I01687     END-IF.                                                      
I01687                                                                  
I01687 7310-EXIT.                                                       
I01687     EXIT.                                                        
                                                                        
I01687****************************************************************  14936600
I01687** LOOK FOR CANCEL REBILL                                      *  14936600
I01687****************************************************************  14936600
I01687 7320-GET-CANCEL-REBILL.                                          
I01687                                                                  
I01687     EXEC SQL                                                     
I01687         SELECT TOP(1) 'Y'                                               
I01687           INTO :WS-CANCEL-REBILL-FL                              
I01687           FROM CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                  
I01687              , CSS_BILLING_DET BG WITH(READUNCOMMITTED)                  
I01687          WHERE BI.ACCOUNT_NO   = :AT-ACCOUNT-NO                  
I01687            AND BI.DATE_BILLED IS NULL                            
I01687            AND BI.ACCOUNT_NO   =  BG.ACCOUNT_NO                  
I01687            AND BI.BILL_NO      =  BG.BILL_NO                     
I01687            AND BG.CODE_BILL_CALC     = 'A'                       
I01687            AND BG.CODE_BILL_ITM_TYPE = 'C'                       
I01687            AND BG.CODE_BILL_ITM_IND  = 'A'                       
I01687            AND BG.DATE_ORIG_BILL    IS NOT NULL                  
I01687                                              
I01687                                                           
I01687                                                      
I01687     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14937700
MFA-TR*        SELECT 'Y'                                               14937700
MFA-TR*          INTO :WS-CANCEL-REBILL-FL                              14937800
MFA-TR*          FROM CSS_BILLING_HDR BI                                14937800
MFA-TR*             , CSS_BILLING_DET BG                                14937800
MFA-TR*         WHERE BI.ACCOUNT_NO   = :AT-ACCOUNT-NO                  14937800
MFA-TR*           AND BI.DATE_BILLED IS NULL                                    
MFA-TR*           AND BI.ACCOUNT_NO   =  BG.ACCOUNT_NO                          
MFA-TR*           AND BI.BILL_NO      =  BG.BILL_NO                             
MFA-TR*           AND BG.CODE_BILL_CALC     = 'A'                               
MFA-TR*           AND BG.CODE_BILL_ITM_TYPE = 'C'                               
MFA-TR*           AND BG.CODE_BILL_ITM_IND  = 'A'                               
MFA-TR*           AND BG.DATE_ORIG_BILL    IS NOT NULL                          
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7320                                                    
MFA-TR*    END-EXEC.                                                    14937900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I01687                                                                  
I01687     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
I01687     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL OR         
I01687                                        NOT-FOUND                 
I01687         CONTINUE                                                 
I01687     ELSE                                                         
I01687         DISPLAY '** ERROR IN 7320-GET-CANCEL-REBILL       **'    
I01687         DISPLAY '**        RETURN CODE = ' WS-ACTIVE-RETURN-CODE 
ACT114         DISPLAY '**        ACCOUNT NO  = ' AT-ACCOUNT-NO         
I01687         DISPLAY '**        PROCESSING IS TERMINATED       **'    
I01687         PERFORM 9900-ABEND                THRU 9900-EXIT         
I01687     END-IF.                                                      
I01687 7320-EXIT.                                                       
I01687     EXIT.                                                        
                                                                        
ACT114****************************************************************  14936600
ACT114** GET DPP EARNEST DATE                                           14936600
ACT114****************************************************************  14936600
ACT114 7330-GET-DPP-EARNEST-DATE.                                       
ACT114                                                                  
ACT114     EXEC SQL                                                     
ACT114         SELECT FRST_ERNST_PAY_DT                                 
ACT114           INTO :DA-FRST-ERNST-PAY-DT :WS-FRST-ERNST-DT-NULL      
ACT114           FROM CSS_DFA_ACCT    DA WITH(READUNCOMMITTED)                  
ACT114          WHERE DA.ACCOUNT_NO      = :AT-ACCOUNT-NO               
ACT114            AND DA.CODE_DFA_STATUS = 'A'                          
ACT114            AND DA.CODE_DFA_TYPE   = 'B'                          
ACT114                                                           
ACT114                                                      
ACT114     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14937700
MFA-TR*        SELECT FRST_ERNST_PAY_DT                                 14937700
MFA-TR*          INTO :DA-FRST-ERNST-PAY-DT :WS-FRST-ERNST-DT-NULL      14937800
MFA-TR*          FROM CSS_DFA_ACCT    DA                                14937800
MFA-TR*         WHERE DA.ACCOUNT_NO      = :AT-ACCOUNT-NO               14937800
MFA-TR*           AND DA.CODE_DFA_STATUS = 'A'                          14937800
MFA-TR*           AND DA.CODE_DFA_TYPE   = 'B'                          14937800
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7330                                                    
MFA-TR*    END-EXEC.                                                    14937900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT114                                                                  
ACT114     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
ACT114     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
ACT114        IF WS-FRST-ERNST-DT-NULL < 0                              
ACT114           MOVE SPACES              TO DA-FRST-ERNST-PAY-DT       
ACT114           MOVE ZEROES              TO WS-FRST-ERNST-DT-NULL      
ACT114        END-IF                                                    
ACT114     ELSE                                                         
ACT114         DISPLAY '** ERROR IN 7330-GET-DPP-EARNEST-DATE    **'    
ACT114         DISPLAY '**        RETURN CODE = ' WS-ACTIVE-RETURN-CODE 
ACT114         DISPLAY '**        ACCOUNT NO  = ' AT-ACCOUNT-NO         
ACT114         DISPLAY '**        PROCESSING IS TERMINATED       **'    
ACT114         PERFORM 9900-ABEND                THRU 9900-EXIT         
ACT114     END-IF.                                                      
ACT114 7330-EXIT.                                                       
ACT114     EXIT.                                                        
                                                                        
      ****************************************************************  14936600
      **                                                            **  14936700
      **  7370-OPEN-MASTER-CRSR                                     **  14936800
      **                                                            **  14936900
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **  14937000
      **      MASTER_ACCT_CRSR CURSOR                               **  14937100
      **                                                            **  14937200
      ****************************************************************  14937300
      *                                                                 14937400
       7370-OPEN-MASTER-CRSR.                                           
      *                                                                 14937600
           EXEC SQL                                                     
               OPEN MASTER_ACCT_CRSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14938000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 14938200
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************** PCSKR120 ******************'     
               DISPLAY '** 7370 :  RETURN CODE ERROR - OPEN '           
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '************** PCSKR120 ******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 14939200
       7370-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14939500
      ****************************************************************  14939600
      **                                                            **  14939700
      **  7375-FETCH-MASTER-CRSR                                    **  14939800
      **                                                            **  14939900
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **  14940000
      **      MASTER_ACCT_CRSR CURSOR                               **  14940100
      **                                                            **  14940200
      ****************************************************************  14940300
      *                                                                 14940400
       7375-FETCH-MASTER-CRSR.                                          
      *                                                                 14940600
           EXEC SQL                                                     
               FETCH MASTER_ACCT_CRSR INTO                              
                  :CL-DATE-NOTICE-DUE :WS-DATE-NOTICE-DUE-NULL,         
                  :CL-CODE-NOTICE-TYPE,                                 
P0059A            :CL-ITEM-ID,                                          
                  :AT-ACCOUNT-NO,                                       
                  :AT-COMPANY-NO,                                       
                  :AT-CODES-DATA-PRESENT,                               
                  :AT-CODE-LPC-XMT,                                     
                  :AT-CUSTOMER-NO,                                      
                  :AT-PREMISE-NO,                                       
                  :AT-LOCAL-OFFICE,                                     
                  :AT-DATE-LAST-ACTION :WS-LAST-ACTION-NULL,            
                  :AT-CODE-DISC-OK,                                     
                  :AT-CREDIT-GROUP,                                     
                  :AT-CODE-ACCT-STAT,                                   
                  :AT-DATE-BILL-DAY-00 :WS-BILL-DAY-00-NULL,            
                  :AT-DATE-BILL-DAY-30 :WS-BILL-DAY-30-NULL,            
                  :AT-DATE-BILL-DAY-60 :WS-BILL-DAY-60-NULL,            
                  :AT-DATE-BILL-DAY-90 :WS-BILL-DAY-90-NULL,            
                  :AT-NOTICE-EXEMPT-CD,                                 
                  :AT-BANKRUPTCY-IND,                                   
                  :AT-ELEC-REV-ALLOC-PCT,                               
                  :AT-TOTAL-AR-BALANCE,                                 
                  :PR-REV-DISTRICT-CD,                                  
                  :B1-ELEC-REV-ALLOC-PCT,                               
                  :B1-DISTRICT-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14944500
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 14944700
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               IF WS-DATE-NOTICE-DUE-NULL < 0                           
                   MOVE SPACES         TO CL-DATE-NOTICE-DUE            
               END-IF                                                   
      *                                                                 14945200
               IF WS-LAST-ACTION-NULL < 0                               
                   MOVE SPACES         TO AT-DATE-LAST-ACTION           
               END-IF                                                   
      *                                                                 14945600
               IF WS-BILL-DAY-00-NULL < 0                               
                   MOVE SPACES         TO AT-DATE-BILL-DAY-00           
               END-IF                                                   
      *                                                                 14946000
               IF WS-BILL-DAY-30-NULL < 0                               
                   MOVE SPACES         TO AT-DATE-BILL-DAY-30           
               END-IF                                                   
      *                                                                 14946400
               IF WS-BILL-DAY-60-NULL < 0                               
                   MOVE SPACES         TO AT-DATE-BILL-DAY-60           
               END-IF                                                   
      *                                                                 14946900
               IF WS-BILL-DAY-90-NULL < 0                               
                   MOVE SPACES         TO AT-DATE-BILL-DAY-90           
               END-IF                                                   
           ELSE                                                         
               DISPLAY '*********** PCSKR120 *********************'     
               DISPLAY '** 7375 :  RETURN CODE ERROR - FETCH'           
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '*********** PCSKR120 *********************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 14948000
       7375-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14948300
      ****************************************************************  14948400
      **                                                            **  14948500
      **  7380-CLOSE-MASTER-CRSR                                    **  14948600
      **                                                            **  14948700
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **  14948800
      **      MASTER_ACCT_CRSR.                                     **  14948900
      **                                                            **  14949000
      ****************************************************************  14949100
      *                                                                 14949200
       7380-CLOSE-MASTER-CRSR.                                          
      *                                                                 14949400
           EXEC SQL                                                     
               CLOSE MASTER_ACCT_CRSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14949800
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 14950000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************* PCSKR120 *******************'     
               DISPLAY '** 7380 :  RETURN CODE ERROR - CLOSE'           
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '************* PCSKR120 *******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 14951000
       7380-EXIT.                                                       
           EXIT.                                                        
A04772*****************************************************************         
A04772*                                                               *         
A04772* 7390-CHECK-BANK-EFT                                           *         
A04772*****************************************************************         
A04772 7390-CHECK-BANK-EFT.                                             
A04772                                                                  
A04772     EXEC SQL                                                     
A04772        SELECT TOP(1) 'Y'                                                
A04772          INTO :WS-AUTO-BANK-DRAFT                                
A04772          FROM CSS_BANK_EFT WITH(READUNCOMMITTED)                         
A04772         WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                       
A04772           AND STATUS_CODE = 'A'                                  
A04772                                              
A04772                                                           
A04772                                                      
A04772     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-AUTO-BANK-DRAFT                                        
MFA-TR*         FROM CSS_BANK_EFT                                               
MFA-TR*        WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                               
MFA-TR*          AND STATUS_CODE = 'A'                                          
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7390                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04772                                                                  
A04772*                                                                 14949800
A04772     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
A04772*                                                                 14950000
A04772     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A04772        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A04772           MOVE 'N'                    TO WS-AUTO-BANK-DRAFT      
A04772        END-IF                                                    
A04772     ELSE                                                         
A04772         DISPLAY '************* PCSKR120 *******************'     
A04772         DISPLAY '** 7390 :  RETURN CODE ERROR - CHECK-BANK-EFT'  
A04772         DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
A04772         DISPLAY '************* PCSKR120 *******************'     
A04772         PERFORM 9900-ABEND                THRU 9900-EXIT         
A04772     END-IF.                                                      
A04772*                                                                 14951000
A04772 7390-EXIT.                                                       
A04772     EXIT.                                                        
      *                                                                 14951300
      ****************************************************************  14951400
      **  7400-OPEN-FINAL-WO-ACTN                                   **  14951500
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **  14952000
      **      FINAL_WO_ACTN CURSOR                                  **  14960000
      ****************************************************************  14970000
       7400-OPEN-FINAL-WO-ACTN.                                         
      *                                                                 14990000
           EXEC SQL                                                     
              OPEN FINAL_WO_ACTN                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************** PCSKR120 ******************'      
              DISPLAY '** 7400 :  RETURN CODE ERROR - OPEN '            
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '************** PCSKR120 ******************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14939500
      ****************************************************************  15190000
      **  7410-FETCH-FINAL-WO-ACTN                                  **  15200000
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **  15210000
      **      FINAL_WO_ACTN CURSOR                                  **  15220000
      ****************************************************************  15230000
       7410-FETCH-FINAL-WO-ACTN.                                        
                                                                        
           EXEC SQL                                                     
               FETCH FINAL_WO_ACTN INTO                                 
                   :FW-ACCOUNT-NO                                       
                  ,:FW-FW-PATH-TYPE-CD                                  
                  ,:FW-SENIOR-FL                                        
                  ,:FW-REG-GROUP-CD                                     
                  ,:KD-FW-SEQ-NO                                        
                  ,:KD-FW-ACTION-DT                                     
                  ,:KD-FW-ACTION-TYPE-CD                                
                  ,:KD-FW-ACTION-AM                                     
                  ,:KD-FW-PROCESSED-FL                                  
                  ,:AT-COMPANY-NO                                       
                  ,:AT-CUSTOMER-NO                                      
                  ,:AT-TOTAL-AR-BALANCE                                 
                  ,:AT-CODE-ACCT-STAT                                   
                  ,:AT-DATE-BILL-DAY-00                                 
                  ,:AT-DATE-BILL-DAY-30                                 
                  ,:AT-DATE-BILL-DAY-60                                 
                  ,:AT-DATE-BILL-DAY-90                                 
                  ,:AT-CANREB-CODE-00-DAY                               
                  ,:AT-CANREB-CODE-30-DAY                               
                  ,:AT-CANREB-CODE-60-DAY                               
                  ,:AT-CANREB-CODE-90-DAY                               
                  ,:AT-BANKRUPTCY-IND                                   
                  ,:AT-JUDGEMENT-CASE-NO                                
                  ,:AT-PREMISE-NO                                       
                  ,:AT-LOCAL-OFFICE                                     
                  ,:AT-CODE-LPC-XMT                                     
                  ,:AT-CODES-DATA-PRESENT                               
                  ,:AT-ELEC-REV-ALLOC-PCT                               
                  ,:B1-ELEC-REV-ALLOC-PCT                               
                  ,:B1-DISTRICT-NO                                      
                  ,:PR-REV-DISTRICT-CD                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*********** PCSKR120 *********************'      
              DISPLAY '** 7410 :  RETURN CODE ERROR - FETCH'            
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '*********** PCSKR120 *********************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 15560000
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  14951400
      **      OPEN SEB ACCOUTNS CURSOR                                  14952000
      ****************************************************************  14970000
       7500-OPEN-SEB-ACCT-CRSR.                                         
                                                                        
           EXEC SQL                                                     
              OPEN SEB_ACCT_CRSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************** PCSKR120 ******************'      
              DISPLAY '** 7500 :  RETURN CODE ERROR - OPEN '            
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '************** PCSKR120 ******************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  14939600
      **      FETCH SEB ACCOUNTS                                    **  14940000
      ****************************************************************  14940300
                                                                        
       7510-FETCH-SEB-ACCT-CRSR.                                        
                                                                        
           EXEC SQL                                                     
               FETCH SEB_ACCT_CRSR INTO                                 
                  :CL-DATE-NOTICE-DUE :WS-DATE-NOTICE-DUE-NULL          
                , :CL-CODE-NOTICE-TYPE                                  
                , :CL-ITEM-ID                                           
                , :AT-ACCOUNT-NO                                        
                , :AT-COMPANY-NO                                        
                , :AT-CODES-DATA-PRESENT                                
                , :AT-CODE-LPC-XMT                                      
                , :AT-CUSTOMER-NO                                       
                , :AT-PREMISE-NO                                        
                , :AT-LOCAL-OFFICE                                      
                , :AT-DATE-LAST-ACTION :WS-LAST-ACTION-NULL             
                , :AT-CODE-DISC-OK                                      
                , :AT-CREDIT-GROUP                                      
                , :AT-CODE-ACCT-STAT                                    
                , :AT-DATE-BILL-DAY-00 :WS-BILL-DAY-00-NULL             
                , :AT-DATE-BILL-DAY-30 :WS-BILL-DAY-30-NULL             
                , :AT-DATE-BILL-DAY-60 :WS-BILL-DAY-60-NULL             
                , :AT-DATE-BILL-DAY-90 :WS-BILL-DAY-90-NULL             
                , :AT-NOTICE-EXEMPT-CD                                  
                , :AT-BANKRUPTCY-IND                                    
                , :AT-ELEC-REV-ALLOC-PCT                                
                , :AT-TOTAL-AR-BALANCE                                  
ACT039          , :AT-REV-MTH-LST-NRML :WS-REVENUE-MONTH-NULL           
                , :PR-REV-DISTRICT-CD                                   
                , :B1-ELEC-REV-ALLOC-PCT                                
                , :B1-DISTRICT-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               IF WS-DATE-NOTICE-DUE-NULL < 0                           
                   MOVE SPACES         TO CL-DATE-NOTICE-DUE            
               END-IF                                                   
                                                                        
               IF WS-LAST-ACTION-NULL < 0                               
                   MOVE SPACES         TO AT-DATE-LAST-ACTION           
               END-IF                                                   
                                                                        
               IF WS-BILL-DAY-00-NULL < 0                               
                   MOVE SPACES         TO AT-DATE-BILL-DAY-00           
               END-IF                                                   
                                                                        
               IF WS-BILL-DAY-30-NULL < 0                               
                   MOVE SPACES         TO AT-DATE-BILL-DAY-30           
               END-IF                                                   
                                                                        
               IF WS-BILL-DAY-60-NULL < 0                               
                   MOVE SPACES         TO AT-DATE-BILL-DAY-60           
               END-IF                                                   
                                                                        
               IF WS-BILL-DAY-90-NULL < 0                               
                   MOVE SPACES         TO AT-DATE-BILL-DAY-90           
               END-IF                                                   
                                                                        
ACT039         IF WS-REVENUE-MONTH-NULL < 0                             
ACT039             MOVE +0             TO AT-REV-MTH-LST-NRML           
ACT039         END-IF                                                   
           ELSE                                                         
               DISPLAY '*********** PCSKR120 *********************'     
               DISPLAY '** 7510 :  RETURN CODE ERROR - FETCH'           
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '*********** PCSKR120 *********************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************  14948400
      **      CLOSE SEB ACCOUNTS CURSOR                             **  14948800
      ****************************************************************  14949100
                                                                        
       7520-CLOSE-SEB-ACCT-CRSR.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE SEB_ACCT_CRSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************* PCSKR120 *******************'     
               DISPLAY '** 7520 :  RETURN CODE ERROR - CLOSE'           
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '************* PCSKR120 *******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  15600000
      **  7420-CLOSE-FINAL-WO-ACTN                                  **  15610000
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **  15620000
      **      FINAL_WO_ACTN CURSOR                                  **  15630000
      ****************************************************************  15640000
       7420-CLOSE-FINAL-WO-ACTN.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE FINAL_WO_ACTN                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************* PCSKR120 *******************'      
              DISPLAY '** 7420 :  RETURN CODE ERROR - CLOSE'            
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '************* PCSKR120 *******************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16660000
ACT039****************************************************************  17790000
ACT039**  7800-CK-CRED-ARNG.                                        **  18574000
ACT039**      CHECKS TO SEE IF CUSTOMER HAS A CREDIT ARRANGEMENT    **  18575000
ACT039**      THAT HAS BEEN PAID SINCE THE PREVIOUS BILL DATE       **  18575100
ACT055**      OR IF AN ACTIVE CREDIT ARRANGEMENT EXISTS.            **  18575100
ACT039****************************************************************  18577000
ACT039*                                                                 18577100
ACT039 7800-CK-CRED-ARNG.                                               
ACT039*                                                                 18579000
ACT039     EXEC SQL                                                     
ACT039       SELECT TOP(1) 'Y'                                                 
ACT055       INTO :WS-CRED-ARNG-PD-ACTIVE-EXISTS                        
ACT039       FROM CSS_CRED_ARNGMENT X1 WITH(READUNCOMMITTED)                    
ACT039           ,CSS_CRED_ARNG_HIST WY WITH(READUNCOMMITTED)                   
ACT039       WHERE X1.ACCOUNT_NO = :X1-ACCOUNT-NO                       
ACT039         AND X1.ACCOUNT_NO = WY.ACCOUNT_NO                        
ACT039         AND X1.ARNG_ID = WY.ARNG_ID                              
ACT039         AND X1.CRED_ARNG_SEQ = WY.CRED_ARNG_SEQ                  
ACT039         AND (WY.ARNG_CHANGE_CD IN ('C','M')                      
ACT055         AND  X1.ARNG_STATUS_CD = 'C'                             
ACT039         AND (X1.ARNG_SETUP_DT > IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-00
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-00
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-00
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-00
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-00) ) OR          
ACT055             (X1.ARNG_SETUP_DT = IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-00
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-00
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-00
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-00
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-00) ) AND         
ACT055             CAST(WY.ARNG_HIST_TS AS DATE) > 
              IIF(TRY_CONVERT(DATE, :AT-DATE-BILL-DAY-00
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-00
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-00
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-00
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-00) )))       
ACT055         OR (X1.ARNG_STATUS_CD = 'A'))                            
ACT039         ORDER BY WY.ARNG_HIST_TS                                 
ACT039                                       
ACT039     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     18579100
MFA-TR*      SELECT 'Y'                                                 18579200
MFA-TR*      INTO :WS-CRED-ARNG-PD-ACTIVE-EXISTS                        18579300
MFA-TR*      FROM CSS_CRED_ARNGMENT X1                                  18579300
MFA-TR*          ,CSS_CRED_ARNG_HIST WY                                 18579400
MFA-TR*      WHERE X1.ACCOUNT_NO = :X1-ACCOUNT-NO                       18579500
MFA-TR*        AND X1.ACCOUNT_NO = WY.ACCOUNT_NO                        18579600
MFA-TR*        AND X1.ARNG_ID = WY.ARNG_ID                              18579700
MFA-TR*        AND X1.CRED_ARNG_SEQ = WY.CRED_ARNG_SEQ                  18579800
MFA-TR*        AND (WY.ARNG_CHANGE_CD IN ('C','M')                      18579900
MFA-TR*        AND  X1.ARNG_STATUS_CD = 'C'                             18580000
MFA-TR*        AND (X1.ARNG_SETUP_DT > :AT-DATE-BILL-DAY-00 OR          18580100
MFA-TR*            (X1.ARNG_SETUP_DT = :AT-DATE-BILL-DAY-00 AND         18580100
MFA-TR*            DATE(WY.ARNG_HIST_TS) > :AT-DATE-BILL-DAY-00))       18580100
MFA-TR*        OR (X1.ARNG_STATUS_CD = 'A'))                                    
MFA-TR*        ORDER BY WY.ARNG_HIST_TS                                 18580100
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             18580100
MFA-TR*    END-EXEC.                                                    18580100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT039*                                                                 18580200
ACT039     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT039*                                                                 18580400
ACT039     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
ACT039         CONTINUE                                                 
ACT039     ELSE                                                         
ACT039         DISPLAY '************** PCSKR120 ******************'     
ACT039         DISPLAY '** 7800 :  RETURN CODE ERROR - SELECT'          
ACT039         DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
ACT039         DISPLAY 'X1-ACCOUNT-NO  = ' X1-ACCOUNT-NO                
ACT039         DISPLAY 'AT-DATE-BILL-DAY-00 = ' AT-DATE-BILL-DAY-00     
ACT039         DISPLAY '************** PCSKR120 ******************'     
ACT039         PERFORM 9900-ABEND THRU 9900-EXIT                        
ACT039     END-IF.                                                      
ACT039*                                                                 18581400
ACT039 7800-EXIT.                                                       
ACT039     EXIT.                                                        
ACT039*                                                                         
      ****************************************************************          
      **    COPYBOOKS NECESSARY FOR CSS_JOB_PARM PROCESSING          *          
      **    7600-START-FCSJC01                                       *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00038                                                   
           END-EXEC.                                                            
      *                                                                 19000000
      * PARAGRAPH 7620-START-FCSCA00 IS IN CPD00039                     19001000
      *                                                                 19002000
            EXEC SQL                                                    19010000
                 INCLUDE CPD00039                                       19020000
            END-EXEC.                                                   19030000
      *                                                                         
      ****************************************************************  18655100
      **                                                            **  18655200
      **    8000-UPD-FIN-WO-ACTION.                                 **  18655300
      **                                                            **  18655400
      **                                                            **  18655500
      ****************************************************************  18655600
      *                                                                 18655700
       8000-UPD-FIN-WO-ACTION.                                          
      *                                                                 18655900
           MOVE '8000'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_FIN_WO_ACTION                                   
               SET FW_ACTION_AM       = :WS-TOTAL-CHARGE                
                  ,FW_PROCESSED_FL    = 'Y'                             
             WHERE ACCOUNT_NO         = :KD-ACCOUNT-NO                  
               AND FW_ACTION_TYPE_CD  = 'LPC'                           
               AND FW_SEQ_NO          = :KD-FW-SEQ-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 18659000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    8000-UPD-FIN-WO-ACTION  **'               
               DISPLAY '**    RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '**    ACCOUNT NO  = ' KD-ACCOUNT-NO             
               DISPLAY '**    SEQUENCE NO = ' KD-FW-SEQ-NO              
               DISPLAY '**    PROCESSING IS TERMINATED     **'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 18659900
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  18655100
      **                                                            **  18655200
      **    8020-UPD-PROCESS-FLAG.                                  **  18655300
      **                                                            **  18655400
      **                                                            **  18655500
      ****************************************************************  18655600
      *                                                                 18655700
       8020-UPD-PROCESS-FLAG.                                           
      *                                                                 18655900
           MOVE '8020'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_FIN_WO_ACTION                                   
               SET FW_PROCESSED_FL    = 'Y'                             
             WHERE ACCOUNT_NO         = :KD-ACCOUNT-NO                  
               AND FW_ACTION_TYPE_CD  = 'LPC'                           
               AND FW_SEQ_NO          = :KD-FW-SEQ-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 18659000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    8020-UPD-PROCESS-FLAG   **'               
               DISPLAY '**    RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '**    ACCOUNT NO  = ' KD-ACCOUNT-NO             
               DISPLAY '**    SEQUENCE NO = ' KD-FW-SEQ-NO              
               DISPLAY '**    PROCESSING IS TERMINATED     **'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 18659900
       8020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  18596700
      **  8030-UPDATE-AR-CNTL                                       **  18596800
      ****************************************************************  18597000
      *                                                                 18597100
       8030-UPDATE-AR-CNTL.                                             
      *                                                                 18597300
           EXEC SQL                                                     
               UPDATE CSS_AR_CNTL                                       
                 SET                                                    
                   TOT_SUMM_UNBILLED = :AC-TOT-SUMM-UNBILLED,           
                   LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(:WS-TIMESTAMP)        
               WHERE                                                    
                   ACCOUNT_NO        = :AC-ACCOUNT-NO                   
               AND PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     18597400
MFA-TR*        UPDATE CSS_AR_CNTL                                       18597500
MFA-TR*          SET                                                    18597600
MFA-TR*            TOT_SUMM_UNBILLED = :AC-TOT-SUMM-UNBILLED,           18597700
MFA-TR*            LAST_UPDATE_TS    = :WS-TIMESTAMP                    18597800
MFA-TR*        WHERE                                                    18597900
MFA-TR*            ACCOUNT_NO        = :AC-ACCOUNT-NO                   18598000
MFA-TR*        AND PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL            18598100
MFA-TR*    END-EXEC.                                                    18598200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18598300
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 18598500
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** 8030 :  RETURN CODE ERROR - UPDATE '         
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '** ACCOUNT NO = ' AC-ACCOUNT-NO                 
               DISPLAY '** PYMT PRIORITY LVL = ' WS-PYMT-PRIORITY-LVL   
               DISPLAY '******************************************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 18599500
       8030-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18599800
      ****************************************************************  18596700
      **  8035-UPDATE-AR-CNTL                                       **  18596800
      ****************************************************************  18597000
      *                                                                 18597100
       8035-UPDATE-FB-AR-CNTL.                                          
      *                                                                 18597300
           EXEC SQL                                                     
               UPDATE CSS_AR_CNTL                                       
                 SET                                                    
                   AMT_AR_DAY_00     = :AC-AMT-AR-DAY-00,               
                   LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(:WS-TIMESTAMP)        
               WHERE                                                    
                   ACCOUNT_NO        = :AC-ACCOUNT-NO                   
               AND PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     18597400
MFA-TR*        UPDATE CSS_AR_CNTL                                       18597500
MFA-TR*          SET                                                    18597600
MFA-TR*            AMT_AR_DAY_00     = :AC-AMT-AR-DAY-00,                       
MFA-TR*            LAST_UPDATE_TS    = :WS-TIMESTAMP                    18597800
MFA-TR*        WHERE                                                    18597900
MFA-TR*            ACCOUNT_NO        = :AC-ACCOUNT-NO                   18598000
MFA-TR*        AND PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL            18598100
MFA-TR*    END-EXEC.                                                    18598200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18598300
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 18598500
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** 8035 :  RETURN CODE ERROR - UPDATE '         
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '** ACCOUNT NO = ' AC-ACCOUNT-NO                 
               DISPLAY '** PYMT PRIORITY LVL = ' WS-PYMT-PRIORITY-LVL   
               DISPLAY '******************************************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 18599500
       8035-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  18586100
      **                                                            **  18586200
      **  8040-CREATE-AR-CNTL                                       **  18586300
      **                                                            **  18586400
      **                                                            **  18586900
      ****************************************************************  18587000
      *                                                                 18587100
       8040-CREATE-AR-CNTL.                                             
      *                                                                 18587300
           EXEC SQL                                                     
             INSERT INTO CSS_AR_CNTL                                    
                 (ACCOUNT_NO,                                           
                 AMT_AR_DAY_00,                                         
                 AMT_AR_DAY_30,                                         
                 AMT_AR_DAY_60,                                         
                 AMT_AR_DAY_90,                                         
                 AMT_TRAN_BALANCE,                                      
                 AMT_UNUSED_CR,                                         
                 ITEM_ID,                                               
                 LAST_UPDATE_TS,                                        
                 PYMT_PRIORITY_LVL,                                     
                 TOT_SUMM_UNBILLED)                                     
             VALUES                                                     
                 (:AC-ACCOUNT-NO,                                       
                 0,                                                     
                 0,                                                     
                 0,                                                     
                 0,                                                     
                 0,                                                     
                 0,                                                     
                 0,                                                     
                 CIS.CHAR2TIMESTAMP(:WS-TIMESTAMP),                             
                 :WS-PYMT-PRIORITY-LVL,                                 
                 :AC-TOT-SUMM-UNBILLED)                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     18587600
MFA-TR*      INSERT INTO CSS_AR_CNTL                                    18587700
MFA-TR*          (ACCOUNT_NO,                                           18587800
MFA-TR*          AMT_AR_DAY_00,                                         18587900
MFA-TR*          AMT_AR_DAY_30,                                         18588000
MFA-TR*          AMT_AR_DAY_60,                                         18588100
MFA-TR*          AMT_AR_DAY_90,                                         18588200
MFA-TR*          AMT_TRAN_BALANCE,                                      18588300
MFA-TR*          AMT_UNUSED_CR,                                         18588400
MFA-TR*          ITEM_ID,                                               18588500
MFA-TR*          LAST_UPDATE_TS,                                        18588600
MFA-TR*          PYMT_PRIORITY_LVL,                                     18588700
MFA-TR*          TOT_SUMM_UNBILLED)                                     18588800
MFA-TR*      VALUES                                                     18588900
MFA-TR*          (:AC-ACCOUNT-NO,                                       18589000
MFA-TR*          0,                                                     18589100
MFA-TR*          0,                                                     18589200
MFA-TR*          0,                                                     18589300
MFA-TR*          0,                                                     18589400
MFA-TR*          0,                                                     18589500
MFA-TR*          0,                                                     18589600
MFA-TR*          0,                                                     18589700
MFA-TR*          :WS-TIMESTAMP,                                         18589800
MFA-TR*          :WS-PYMT-PRIORITY-LVL,                                 18589900
MFA-TR*          :AC-TOT-SUMM-UNBILLED)                                 18590000
MFA-TR*    END-EXEC.                                                    18590700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18590800
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 18591000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************** PCSKR120 ******************'     
               DISPLAY '** 8040 :  RETURN CODE ERROR - INSERT'          
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '** ACCOUNT NO = ' AC-ACCOUNT-NO                 
               DISPLAY '************** PCSKR120 ******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 18592000
       8040-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18592300
      *                                                                 18586000
      ****************************************************************  18586100
      **                                                            **  18586200
      **  8045-CREATE-FB-AR-CNTL                                    **  18586300
      **                                                            **  18586400
      **                                                            **  18586900
      ****************************************************************  18587000
      *                                                                 18587100
       8045-CREATE-FB-AR-CNTL.                                          
      *                                                                 18587300
           EXEC SQL                                                     
             INSERT INTO CSS_AR_CNTL                                    
                 (ACCOUNT_NO,                                           
                 AMT_AR_DAY_00,                                         
                 AMT_AR_DAY_30,                                         
                 AMT_AR_DAY_60,                                         
                 AMT_AR_DAY_90,                                         
                 AMT_TRAN_BALANCE,                                      
                 AMT_UNUSED_CR,                                         
                 ITEM_ID,                                               
                 LAST_UPDATE_TS,                                        
                 PYMT_PRIORITY_LVL,                                     
                 TOT_SUMM_UNBILLED)                                     
             VALUES                                                     
                 (:AC-ACCOUNT-NO,                                       
                  :AC-AMT-AR-DAY-00,                                    
                 0,                                                     
                 0,                                                     
                 0,                                                     
                 0,                                                     
                 0,                                                     
                 0,                                                     
                 CIS.CHAR2TIMESTAMP(:WS-TIMESTAMP),                             
                 :WS-PYMT-PRIORITY-LVL,                                 
                 0)                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     18587600
MFA-TR*      INSERT INTO CSS_AR_CNTL                                    18587700
MFA-TR*          (ACCOUNT_NO,                                           18587800
MFA-TR*          AMT_AR_DAY_00,                                         18587900
MFA-TR*          AMT_AR_DAY_30,                                         18588000
MFA-TR*          AMT_AR_DAY_60,                                         18588100
MFA-TR*          AMT_AR_DAY_90,                                         18588200
MFA-TR*          AMT_TRAN_BALANCE,                                      18588300
MFA-TR*          AMT_UNUSED_CR,                                         18588400
MFA-TR*          ITEM_ID,                                               18588500
MFA-TR*          LAST_UPDATE_TS,                                        18588600
MFA-TR*          PYMT_PRIORITY_LVL,                                     18588700
MFA-TR*          TOT_SUMM_UNBILLED)                                     18588800
MFA-TR*      VALUES                                                     18588900
MFA-TR*          (:AC-ACCOUNT-NO,                                       18589000
MFA-TR*           :AC-AMT-AR-DAY-00,                                    18589100
MFA-TR*          0,                                                     18589200
MFA-TR*          0,                                                     18589300
MFA-TR*          0,                                                     18589400
MFA-TR*          0,                                                     18589500
MFA-TR*          0,                                                     18589600
MFA-TR*          0,                                                     18589700
MFA-TR*          :WS-TIMESTAMP,                                         18589800
MFA-TR*          :WS-PYMT-PRIORITY-LVL,                                 18589900
MFA-TR*          0)                                                     18590000
MFA-TR*    END-EXEC.                                                    18590700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18590800
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 18591000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************** PCSKR120 ******************'     
               DISPLAY '** 8045 :  RETURN CODE ERROR - INSERT'          
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '** ACCOUNT NO = ' AC-ACCOUNT-NO                 
               DISPLAY '************** PCSKR120 ******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 18592000
       8045-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  12090000
      **  8105-UPDATE-ALLOC-PCT-AT                                  **  11820000
      **      CSS_ACCOUNT IS UPDATED WITH NEW VALUE FOR NEW VALUE   **  11830000
      **      FOR ELE-REV-ALLOC-PCT                                 **          
      ****************************************************************  11840000
       8105-UPDATE-ALLOC-PCT-AT.                                        
      *                                                                 11860000
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                 SET ELEC_REV_ALLOC_PCT =  :AT-ELEC-REV-ALLOC-PCT       
               WHERE ACCOUNT_NO         =  :AT-ACCOUNT-NO               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11930000
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 11950000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** 8105 :  RETURN CODE ERROR - UPDATE '         
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                 
               DISPLAY '******************************************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 12050000
       8105-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  11810000
      **  8200-UPDATE-ACCOUNT                                       **  11820000
      **      ACCOUNT TABLE IS UPDATED WITH SPACES                  **  11830000
      ****************************************************************  11840000
       8200-UPDATE-ACCOUNT.                                             
      *                                                                 11860000
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                 SET CODES_DATA_PRESENT =  :AT-CODES-DATA-PRESENT       
                    ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
               WHERE ACCOUNT_NO         =  :AT-ACCOUNT-NO               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     11870000
MFA-TR*        UPDATE CSS_ACCOUNT                                       11880000
MFA-TR*          SET CODES_DATA_PRESENT =  :AT-CODES-DATA-PRESENT       11890000
MFA-TR*             ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*        WHERE ACCOUNT_NO         =  :AT-ACCOUNT-NO               11910000
MFA-TR*    END-EXEC.                                                    11920000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11930000
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 11950000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** 8200 :  RETURN CODE ERROR - UPDATE '         
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '**      :  ACCOUNT NO = ' AT-ACCOUNT-NO         
               DISPLAY '******************************************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 12050000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  11810000
      **  8250-UPDATE-FB-ACCOUNT                                    **  11820000
      **      ACCOUNT TABLE IS UPDATED WITH SPACES                  **  11830000
      **      TOTAL AR BALANCE UPDATED FOR FB ACCOUNTS              **          
      ****************************************************************  11840000
       8250-UPDATE-FB-ACCOUNT.                                          
      *                                                                 11860000
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                 SET  CODES_DATA_PRESENT =  :AT-CODES-DATA-PRESENT      
                     ,TOTAL_AR_BALANCE   =  :AT-TOTAL-AR-BALANCE        
                     ,CANREB_CODE_00_DAY =  :AT-CANREB-CODE-00-DAY      
                     ,CANREB_CODE_30_DAY =  :AT-CANREB-CODE-30-DAY      
                     ,CANREB_CODE_60_DAY =  :AT-CANREB-CODE-60-DAY      
                     ,CANREB_CODE_90_DAY =  :AT-CANREB-CODE-90-DAY      
                     ,DATE_BILL_DAY_90   =  IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-90
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-90
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-90
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-90
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-90) )        
                     ,DATE_BILL_DAY_60   =  IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-60
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-60
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-60
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-60
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-60) )        
                     ,DATE_BILL_DAY_30   =  IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-30
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-30
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-30
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-30
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-30) )        
                     ,DATE_BILL_DAY_00   =  IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-00
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-00
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-00
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-00
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-00) )        
                     ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()            
               WHERE ACCOUNT_NO          =  :AT-ACCOUNT-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11870000
MFA-TR*        UPDATE CSS_ACCOUNT                                       11880000
MFA-TR*          SET  CODES_DATA_PRESENT =  :AT-CODES-DATA-PRESENT      11890000
MFA-TR*              ,TOTAL_AR_BALANCE   =  :AT-TOTAL-AR-BALANCE                
MFA-TR*              ,CANREB_CODE_00_DAY =  :AT-CANREB-CODE-00-DAY              
MFA-TR*              ,CANREB_CODE_30_DAY =  :AT-CANREB-CODE-30-DAY              
MFA-TR*              ,CANREB_CODE_60_DAY =  :AT-CANREB-CODE-60-DAY              
MFA-TR*              ,CANREB_CODE_90_DAY =  :AT-CANREB-CODE-90-DAY              
MFA-TR*              ,DATE_BILL_DAY_90   =  :AT-DATE-BILL-DAY-90                
MFA-TR*              ,DATE_BILL_DAY_60   =  :AT-DATE-BILL-DAY-60                
MFA-TR*              ,DATE_BILL_DAY_30   =  :AT-DATE-BILL-DAY-30                
MFA-TR*              ,DATE_BILL_DAY_00   =  :AT-DATE-BILL-DAY-00                
MFA-TR*              ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                    
MFA-TR*        WHERE ACCOUNT_NO          =  :AT-ACCOUNT-NO              11910000
MFA-TR*    END-EXEC.                                                    11920000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11930000
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 11950000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** 8250 :  RETURN CODE ERROR - UPDATE '         
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '**      :  ACCOUNT NO = ' AT-ACCOUNT-NO         
               DISPLAY '******************************************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 12050000
       8250-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  11810000
      **  8300-UPDATE-AR-CNTL                                    **  1182   0000
      ****************************************************************  11840000
      *                                                                 19171000
       8300-UPDATE-AR-CNTL.                                             
      *                                                                 11860000
           EXEC SQL                                                     
               UPDATE CSS_AR_CNTL                                       
                 SET  AMT_AR_DAY_00      =  :AC-AMT-AR-DAY-00           
                     ,AMT_AR_DAY_30      =  :AC-AMT-AR-DAY-30           
                     ,AMT_AR_DAY_60      =  :AC-AMT-AR-DAY-60           
                     ,AMT_AR_DAY_90      =  :AC-AMT-AR-DAY-90           
                     ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()            
               WHERE ACCOUNT_NO          =  :AC-ACCOUNT-NO              
               AND   PYMT_PRIORITY_LVL   =  :AC-PYMT-PRIORITY-LVL       
               AND   ITEM_ID             =  :AC-ITEM-ID                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     11870000
MFA-TR*        UPDATE CSS_AR_CNTL                                       11880000
MFA-TR*          SET  AMT_AR_DAY_00      =  :AC-AMT-AR-DAY-00               0000
MFA-TR*              ,AMT_AR_DAY_30      =  :AC-AMT-AR-DAY-30                   
MFA-TR*              ,AMT_AR_DAY_60      =  :AC-AMT-AR-DAY-60                   
MFA-TR*              ,AMT_AR_DAY_90      =  :AC-AMT-AR-DAY-90                   
MFA-TR*              ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                    
MFA-TR*        WHERE ACCOUNT_NO          =  :AC-ACCOUNT-NO              11910000
MFA-TR*        AND   PYMT_PRIORITY_LVL   =  :AC-PYMT-PRIORITY-LVL               
MFA-TR*        AND   ITEM_ID             =  :AC-ITEM-ID                         
MFA-TR*    END-EXEC.                                                    11920000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11930000
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 11950000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** 8300 :  RETURN CODE ERROR - UPDATE '         
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '** ACCOUNT NO = ' AC-ACCOUNT-NO                 
               DISPLAY '** PYMT PRIORITY LVL = ' AC-PYMT-PRIORITY-LVL   
               DISPLAY '** ITEM ID           = ' AC-ITEM-ID             
               DISPLAY '******************************************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 12050000
      *                                                                 12050000
       8300-EXIT.                                                       
           EXIT.                                                        
P0059A****************************************************************  11810000
P0059A**  8350-UPDATE-CRED-COLL.                                 **  1182   0000
P0059A****************************************************************  11840000
P0059A*                                                                 19171000
P0059A 8350-UPDATE-CRED-COLL.                                           
P0059A*                                                                 11860000
P0059A     EXEC SQL                                                     
P0059A         UPDATE CSS_CRED_COLL                                     
P0059A           SET  PROCESSED_CD       =  :CL-PROCESSED-CD            
P0059A               ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()            
P0059A         WHERE ACCOUNT_NO          =  :CL-ACCOUNT-NO              
P0059A         AND   ITEM_ID             =  :CL-ITEM-ID                 
P0059A         AND   CODE_NOTICE_TYPE    =  :CL-CODE-NOTICE-TYPE        
P0059A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     11870000
MFA-TR*        UPDATE CSS_CRED_COLL                                     11880000
MFA-TR*          SET  PROCESSED_CD       =  :CL-PROCESSED-CD                0000
MFA-TR*              ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                    
MFA-TR*        WHERE ACCOUNT_NO          =  :CL-ACCOUNT-NO              11910000
MFA-TR*        AND   ITEM_ID             =  :CL-ITEM-ID                         
MFA-TR*        AND   CODE_NOTICE_TYPE    =  :CL-CODE-NOTICE-TYPE                
MFA-TR*    END-EXEC.                                                    11920000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0059A*                                                                 11930000
P0059A     MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
P0059A*                                                                 11950000
P0059A     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P0059A         CONTINUE                                                 
P0059A     ELSE                                                         
P0059A         DISPLAY '******************************************'     
P0059A         DISPLAY '** 8350 :  RETURN CODE ERROR - UPDATE '         
P0059A         DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
P0059A         DISPLAY '** ACCOUNT NO = ' CL-ACCOUNT-NO                 
P0059A         DISPLAY '** CODE NOTICE TYPE  = ' CL-CODE-NOTICE-TYPE    
P0059A         DISPLAY '** ITEM ID           = ' CL-ITEM-ID             
P0059A         DISPLAY '******************************************'     
P0059A         PERFORM 9900-ABEND                THRU 9900-EXIT         
P0059A     END-IF.                                                      
P0059A*                                                                 12050000
P0059A 8350-EXIT.                                                       
P0059A     EXIT.                                                        
                                                                        
I01687****************************************************************  11810000
I01687**  UPDATE CSS_ACCT_ATTRIBUTE FOR 'LPCASSESSED'                   2   0000
I01687****************************************************************  11840000
I01687                                                                  
I01687 8360-INSERT-ACCT-ATTR.                                           
I01687                                                                  
I01687     EXEC SQL                                                     
I01687       INSERT INTO CSS_ACCT_ATTRIBUTE                             
I01687          ( ACCOUNT_NO                                            
I01687          ,ATTRIBUTE_DESC                                         
I01687          ,ATTRIBUTE_VALUE_CD                                     
I01687          ,ATTRIBUTE_VALUE_DT                                     
I01687          ,ATTRIBUTE_VALUE_TX                                     
I01687          ,CREATED_TS                                             
I01687          ,STATUS_CD )                                            
I01687       VALUES                                                     
I01687           (:AT-ACCOUNT-NO                                        
I01687          , :WS-LPCASSESSED                                       
I01687          , ' '                                                   
I01687          , IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                             
I01687          , ''                                                    
I01687          , CIS.CURRENT$TIMESTAMP()                                     
I01687          , 'A' )                                                 
I01687     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11870000
MFA-TR*      INSERT INTO CSS_ACCT_ATTRIBUTE                             18587700
MFA-TR*         ( ACCOUNT_NO                                            18587800
MFA-TR*         ,ATTRIBUTE_DESC                                         18587900
MFA-TR*         ,ATTRIBUTE_VALUE_CD                                     18588000
MFA-TR*         ,ATTRIBUTE_VALUE_DT                                     18588100
MFA-TR*         ,ATTRIBUTE_VALUE_TX                                     18588200
MFA-TR*         ,CREATED_TS                                             18588300
MFA-TR*         ,STATUS_CD )                                            18588400
MFA-TR*      VALUES                                                     18588900
MFA-TR*          (:AT-ACCOUNT-NO                                        18589000
MFA-TR*         , :WS-LPCASSESSED                                       18589100
MFA-TR*         , ' '                                                   18589200
MFA-TR*         , :WS-CURRENT-DATE                                      18589300
MFA-TR*         , ''                                                    18589400
MFA-TR*         , CURRENT TIMESTAMP                                     18589400
MFA-TR*         , 'A' )                                                 18589200
MFA-TR*    END-EXEC.                                                    11920000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I01687                                                                  
I01687     MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
I01687                                                                  
I01687     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
I01687         CONTINUE                                                 
I01687     ELSE                                                         
I01687         DISPLAY '******************************************'     
I01687         DISPLAY '** 8360 :  RETURN CODE ERROR - UPDATE '         
I01687         DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
I01687         DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                 
I01687         DISPLAY '******************************************'     
I01687         PERFORM 9900-ABEND                THRU 9900-EXIT         
I01687     END-IF.                                                      
I01687                                                                  
I01687 8360-EXIT.                                                       
I01687     EXIT.                                                        
      ****************************************************************  19172000
      ** 8895-INSERT-WORK-QUEUE                                         19174000
      ****************************************************************  19177000
      *                                                                 19178000
ACT050 8895-INSERT-WORK-QUEUE.                                          
ACT050*                                                                         
ACT050     CALL SCSCB077  USING   CWS00077-FIELDS,                      
ACT050                            ABEND-FILE,                           
ACT050                            RS-RETURN-CODE.                       
ACT050                                                                  
ACT050      MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE.  
ACT050                                                                  
ACT050      IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0        
ACT050         MOVE PROGRAM-NAME             TO   ABEND-PROGRAM         
ACT050         DISPLAY '8895-INSERT-WORK-QUEUE'                         
ACT050         DISPLAY 'CALL SCSCB077         '                         
ACT050         DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO              
ACT050         DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO              
ACT050         DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO           
ACT050         DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE         
ACT050         PERFORM 9900-ABEND             THRU 9900-EXIT            
ACT050     END-IF.                                                      
ACT050*                                                                         
ACT050 8895-EXIT.                                                       
ACT050     EXIT.                                                        
      *                                                                 19300000
P0059A**************************************************************            
P0059A**  8898-ISSUE-CHKP                                                       
P0059A**************************************************************            
P0059A*                                                                         
P0059A 8898-ISSUE-CHKP.                                                 
P0059A*                                                                         
P0059A       EXEC SQL                                                           
P0059A           INCLUDE CPD00047                                               
P0059A       END-EXEC                                                           
                                                    
P0059A*                                                                         
P0059A 8898-EXIT.                                                       
P0059A     EXIT.                                                        
P0059A*                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK               *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
      *                                                                         
       9000-TERMINATE.                                                  
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               GO TO 9000-EXIT                                          
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-SQLCODE                       
               DISPLAY '                                      '         
               DISPLAY '**************************************'         
               DISPLAY '****  PCSKR120  PROCESSING ERROR  ****'         
               DISPLAY '**************************************'         
               DISPLAY '                                      '         
               DISPLAY 'SQLCODE =  ' WS-DISPLAY-SQLCODE
           END-IF.                
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
      *                                                                         
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                         
      *    MOVE '9900'                      TO ACTIVE-PARAGRAPH.                
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE,   
                                               RS-RETURN-CODE,          
                                               WS-DISPLAY-SQLCODE.      
           DISPLAY ' '                                                  
           DISPLAY '**********************************************'     
           DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
           DISPLAY '**********************************************'     
           DISPLAY ' '                                                  
           DISPLAY 'ACCT NO           = ' AT-ACCOUNT-NO                 
           DISPLAY 'ACTIVE-PARAGRAPH  = ' ACTIVE-PARAGRAPH              
           DISPLAY 'ABEND FUNCTION    = ' ABEND-FUNCTION                
           DISPLAY 'TABLE-1           = ' TABLE-1                       
           DISPLAY 'TABLE-ELEMENT-1   = ' TABLE-ELEMENT-1               
           DISPLAY 'HOSTVAR-ELEMENT-1 = ' HOSTVAR-ELEMENT-1             
           DISPLAY 'TABLE-ELEMENT-2   = ' TABLE-ELEMENT-2               
           DISPLAY 'HOSTVAR-ELEMENT-2 = ' HOSTVAR-ELEMENT-2             
           DISPLAY 'TABLE-ELEMENT-3   = ' TABLE-ELEMENT-3               
           DISPLAY 'HOSTVAR-ELEMENT-3 = ' HOSTVAR-ELEMENT-3             
           DISPLAY 'TABLE-ELEMENT-4   = ' TABLE-ELEMENT-4               
           DISPLAY 'HOSTVAR-ELEMENT-4 = ' HOSTVAR-ELEMENT-4             
           DISPLAY 'SQLCODE = ' WS-DISPLAY-SQLCODE                      
           DISPLAY '**********************************************'     
           PERFORM 9900-ABEND                    THRU 9900-EXIT.        
      *                                                                         
      ****************************************************************  19310900
      *  9700-PROCESS-ABEND.                                         *  19311000
      ****************************************************************  19311100
           EXEC SQL                                                     19311200
               INCLUDE CPD0023B                                         19311300
           END-EXEC.                                                    19311400
                                                                        
HPCCDM*    EJECT                                                        19311600
      *                                                                 19311700
      **************************************************************    19313800
      * CPD09900   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE   *    19313900
      * 9900-ABEND                                                 *    19314000
      **************************************************************    19314100
      *                                                                 19314200
           EXEC SQL                                                     19314300
               INCLUDE CPD09900                                         19314400
           END-EXEC.                                                    19314500
