       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSKR112.                                        
       DATE-WRITTEN.   NOV 2011.                                        
      ******************************************************************        
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **        
      **                                                              **        
      ********            CUSTOMER SERVICE SYSTEM             **********        
      ********                      DB2                       **********        
      ******************************************************************        
      **              PROGRAM  MODIFICATION  LOG                      **        
      **                                                              **        
      **   DATE         INITIALS   REASON                             **        
      **   __________   ________   ______________                     **        
P00453**   11/15/2011   SP95538    INITIAL PROGRAM VERSION.           **        
      **                                                              **        
      ******************************************************************        
      **-------------- P R O G R A M  S U M M A R Y ------------------**        
      ******************************************************************        
      ******************************************************************        
      ** THIS PROGRAM INSERTS A ROW INTO SO_DNP_CANCEL FOR PRP        **        
      ** ACCOUNTS WITH PENDING DNP (SONP),WHEN THE DNP BALANCE IS     **        
      ** LESS THAN THE DNP LIMIT.                                     **        
      ******************************************************************        
      ******************************************************************        
      **                                                              **        
      **            ---- BASIC SEQUENCE STRUCTURE ----                **        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 2999     OUTPUT PROCESSING CONTROL PATH        **        
      **        3000 - 4999     BATCH PROCESSING MODULES - NOT USED   **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9799     TERMINATION MODULES                   **        
      **        9900 - 9999     ABEND/ABORT MODULES                   **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                 00260000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSKR112'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-START                   PIC X(40) VALUE                 
             'WORKING STORAGE FOR PCSKR112 STARTS HERE'.                
          05 WS-PGRMNAME                PIC X(08) VALUE 'PCSKR112'.     
          05 PROGRAM-NAME               PIC X(08) VALUE 'PCSKR112'.     
          05 SCSCB068                   PIC X(08) VALUE 'SCSCB068'.     
          05 WS-DISPLAY-SQLCODE         PIC -Z(8)9.                     
          05 WS-Y                       PIC X(01) VALUE 'Y'.            
          05 WS-N                       PIC X(01) VALUE 'N'.            
          05 WS-NULL-DAY-00             PIC S9(04) COMP VALUE +0.       
          05 WS-NULL-DAY-30             PIC S9(04) COMP VALUE +0.       
          05 WS-NULL-DAY-60             PIC S9(04) COMP VALUE +0.       
          05 WS-NULL-DAY-90             PIC S9(04) COMP VALUE +0.       
      *                                                                         
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE           PIC S9(04) COMP VALUE 0.        
           05  RS-RETURN-CODE-DISP      PIC +Z(04).                     
      *                                                                         
      ******************************************************************        
      * WS FOR DB2 & CICS ERROR PROCESSING                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00303                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * WS-ABEND-SWITCH                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR SCSCB068                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00068                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DB2 TABLES INCLUDED IN PROGRAM                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * FCA00-KEY                                                      *        
      ******************************************************************        
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
      ******************************************************************        
      * FIOJC01 WORKING STORAGE                                        *        
      ******************************************************************        
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE  FOR  ABEND WORK AREA                          *        
      ******************************************************************        
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE  FOR CODES_DATA_PRESENT                        *        
      ******************************************************************        
      *                                                                         
       COPY CWS00056.                                                           
      *                                                                         
      ******************************************************************        
      * COPY BOOK TO READ THE JOB PARM TABLE                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * WS USED FOR CPD00039                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00039                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ACCOUNT - AT                                               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_SO_DNP_CANCEL - XK                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBSODNPC                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_JOB_PARM - G6                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  DECLARE CURSOR                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE PRP-CSR CURSOR FOR                                
                 SELECT ACCOUNT_NO                                      
                       ,CODE_ACCT_STAT                                  
                       ,CODES_DATA_PRESENT                              
                       ,COMPANY_NO                                      
                       ,LOCAL_OFFICE                                    
                       ,CREDIT_GROUP                                    
                       ,DATE_BILL_DAY_00                                
                       ,DATE_BILL_DAY_30                                
                       ,DATE_BILL_DAY_60                                
                       ,DATE_BILL_DAY_90                                
                       ,IVR_EXEMPT_CD                                   
                       ,CODE_DISC_OK                                    
                       ,BANKRUPTCY_IND                                  
                   FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                       
                  WHERE CIS.SUBSTR3(CODES_DATA_PRESENT,15,1) = 'A'           
                    AND CIS.SUBSTR3(CODES_DATA_PRESENT,29,1) = 'A'           
                    AND DATE_BILL_DAY_00                = 
              IIF(TRY_CONVERT(DATE, :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     01872000
MFA-TR*       DECLARE PRP-CSR CURSOR FOR                                01873000
MFA-TR*          SELECT ACCOUNT_NO                                      01874000
MFA-TR*                ,CODE_ACCT_STAT                                          
MFA-TR*                ,CODES_DATA_PRESENT                                      
MFA-TR*                ,COMPANY_NO                                              
MFA-TR*                ,LOCAL_OFFICE                                            
MFA-TR*                ,CREDIT_GROUP                                            
MFA-TR*                ,DATE_BILL_DAY_00                                        
MFA-TR*                ,DATE_BILL_DAY_30                                        
MFA-TR*                ,DATE_BILL_DAY_60                                        
MFA-TR*                ,DATE_BILL_DAY_90                                        
MFA-TR*                ,IVR_EXEMPT_CD                                           
MFA-TR*                ,CODE_DISC_OK                                            
MFA-TR*                ,BANKRUPTCY_IND                                          
MFA-TR*            FROM CSS_ACCOUNT                                     01877000
MFA-TR*           WHERE SUBSTR(CODES_DATA_PRESENT,15,1) = 'A'           01942000
MFA-TR*             AND SUBSTR(CODES_DATA_PRESENT,29,1) = 'A'                   
MFA-TR*             AND DATE_BILL_DAY_00                = :WS-INPUT-DATE        
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7000                                                   
MFA-TR*    END-EXEC.                                                    01880000
      *                                                                         
       01 WS-END                        PIC X(40) VALUE                 
           'WORKING STORAGE FOR PCSKR112 ENDS HERE  '.                  
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION        THRU 0100-EXIT.           
           PERFORM 1000-INPUT-PROCESS         THRU 1000-EXIT.           
           PERFORM 9000-TERMINATE             THRU 9000-EXIT.           
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZATION                                            *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
      * Get common date                                                         
           PERFORM 6251-GET-FJC01-DATE        THRU 6251-EXIT.           
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE                        
                                              THRU 6240-EXIT            
              MOVE WS-FCA00-COMMON-DATE  TO WS-INPUT-DATE               
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-DISPLAY-SQLCODE.                               
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-INPUT-PROCESS                                             *        
      ******************************************************************        
      *                                                                         
       1000-INPUT-PROCESS.                                              
      *                                                                         
           PERFORM 7000-OPEN-PRP-CSR          THRU 7000-EXIT.           
           PERFORM 7100-FETCH-PRP-CSR         THRU 7100-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT            
                   UNTIL SQLCODE = NOT-FOUND                            
           PERFORM 7200-CLOSE-PRP-CSR         THRU 7200-EXIT.           
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE WS-INPUT-DATE            TO WS-HOLD-DATE                
           MOVE  AT-ACCOUNT-NO           TO XK-ACCOUNT-NO               
           MOVE  'B'                     TO XK-SO-UPDT-ACTION-FL        
           PERFORM 2100-CALL-SCSCB068         THRU 2100-EXIT            
           IF WS-AMT-DNP-BAL <= ZEROS OR                                
                                WS-AMT-DNP-BAL <= WS-NOTICE-DNP-LIMIT   
              PERFORM 8100-INSERT-SO-DNP      THRU 8100-EXIT            
              IF SQLCODE  = -803                                        
                 PERFORM 8000-UPDATE-SO-DNP   THRU 8000-EXIT            
              END-IF                                                    
           END-IF                                                       
           PERFORM 7100-FETCH-PRP-CSR         THRU 7100-EXIT.           
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2100-CALL-SCSCB068                                                     
      ******************************************************************        
      *                                                                         
       2100-CALL-SCSCB068.                                              
      *                                                                         
           MOVE SPACES                   TO ABEND-FUNCTION.             
           MOVE SPACES                   TO WS-HOLD-DNP-TYPE.           
           MOVE AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT.      
           MOVE WS-Y                     TO CALC-ARREARS-SW             
                                            CALC-PAST-DUE-SW            
                                            CALC-DNP-BAL-SW             
                                            CALC-BALANCE-SW             
                                            CALC-NOT-BAL-SW             
           MOVE PROGRAM-NAME             TO WS-CPD00068-CALLING-PGM.    
           CALL SCSCB068   USING  CWS00068-FIELDS,                      
                                  WS-CODES-DATA-PRESENT,                
                                  DCLCSS-ACCOUNT,                       
                                  ABEND-FILE,                           
                                  RS-RETURN-CODE.                       
           IF ABEND-FUNCTION  > SPACES                                  
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00037                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6240-GET-FCA00-COMMON-DATE                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00040                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7000-OPEN-PRP-CSR.                                             *        
      ******************************************************************        
      *                                                                         
       7000-OPEN-PRP-CSR.                                               
      *                                                                         
           EXEC SQL                                                     
              OPEN PRP-CSR                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-DISPLAY-SQLCODE.         
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*********************************************'   
              DISPLAY '* PCSKR112 PROCESSING ERROR                 *'   
              DISPLAY '* ABEND IN 7000-OPEN-PRP-CSR                *'   
              DISPLAY '* PRP-CSR  OPEN ERROR                       *'   
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                     *'   
              DISPLAY '*********************************************'   
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-FETCH-PRP-CSR.                                            *        
      ******************************************************************        
      *                                                                         
       7100-FETCH-PRP-CSR.                                              
      *                                                                         
           EXEC SQL                                                     
              FETCH PRP-CSR                                             
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:AT-CODES-DATA-PRESENT                              
                   ,:AT-COMPANY-NO                                      
                   ,:AT-LOCAL-OFFICE                                    
                   ,:AT-CREDIT-GROUP                                    
                   ,:AT-DATE-BILL-DAY-00 :WS-NULL-DAY-00                 
                   ,:AT-DATE-BILL-DAY-30 :WS-NULL-DAY-30                 
                   ,:AT-DATE-BILL-DAY-60 :WS-NULL-DAY-60                 
                   ,:AT-DATE-BILL-DAY-90 :WS-NULL-DAY-90                 
                   ,:AT-IVR-EXEMPT-CD                                   
                   ,:AT-CODE-DISC-OK                                    
                   ,:AT-BANKRUPTCY-IND                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-DISPLAY-SQLCODE.         
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF WS-NULL-DAY-00 = -1                                 
                     MOVE SPACES TO AT-DATE-BILL-DAY-00                 
                     MOVE 0      TO WS-NULL-DAY-00                      
                 END-IF                                                 
                 IF WS-NULL-DAY-30 = -1                                 
                     MOVE SPACES TO AT-DATE-BILL-DAY-30                 
                     MOVE 0      TO WS-NULL-DAY-30                      
                 END-IF                                                 
                 IF WS-NULL-DAY-60 = -1                                 
                     MOVE SPACES TO AT-DATE-BILL-DAY-60                 
                     MOVE 0      TO WS-NULL-DAY-60                      
                 END-IF                                                 
                 IF WS-NULL-DAY-90 = -1                                 
                     MOVE SPACES TO AT-DATE-BILL-DAY-90                 
                     MOVE 0      TO WS-NULL-DAY-90                      
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '*********************************************'   
              DISPLAY '* PCSKR112 PROCESSING ERROR                 *'   
              DISPLAY '* ABEND IN 7100-FETCH-PRP-CSR               *'   
              DISPLAY '* PRP-CSR  FETCH ERROR                      *'   
              DISPLAY '* INPUT DATE          = ' WS-INPUT-DATE          
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                     *'   
              DISPLAY '*********************************************'   
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-CLOSE-PRP-CSR.                                            *        
      ******************************************************************        
      *                                                                         
       7200-CLOSE-PRP-CSR.                                              
      *                                                                         
           EXEC SQL                                                     
              CLOSE PRP-CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-DISPLAY-SQLCODE.         
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*********************************************'   
              DISPLAY '* PCSKR112 PROCESSING ERROR                 *'   
              DISPLAY '* ABEND IN 7200-CLOSE-PRP-CSR               *'   
              DISPLAY '* PRP-CSR  CLOSE ERROR                      *'   
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                     *'   
              DISPLAY '*********************************************'   
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 8000-UPDATE-SO-DNP.                                          *          
      ****************************************************************          
      *                                                                         
       8000-UPDATE-SO-DNP.                                              
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_SO_DNP_CANCEL                                 
               SET    SO_UPDT_ACTION_FL = :XK-SO-UPDT-ACTION-FL         
               WHERE  ACCOUNT_NO        = :XK-ACCOUNT-NO                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     15286500
MFA-TR*        UPDATE CSS_SO_DNP_CANCEL                                 15286600
MFA-TR*        SET    SO_UPDT_ACTION_FL = :XK-SO-UPDT-ACTION-FL         15286700
MFA-TR*        WHERE  ACCOUNT_NO        = :XK-ACCOUNT-NO                15286900
MFA-TR*        QUERYNO 8000                                                     
MFA-TR*    END-EXEC.                                                    15287100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-DISPLAY-SQLCODE.         
      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '*********************************************'   
              DISPLAY '* PCSKR112 PROCESSING ERROR                 *'   
              DISPLAY '* ABEND IN 8000-UPDATE-SO-DNP               *'   
              DISPLAY '* ACCOUNT NO          = 'XK-ACCOUNT-NO           
              DISPLAY '* ACTION FLAG         = 'XK-SO-UPDT-ACTION-FL    
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                     *'   
              DISPLAY '*********************************************'   
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100-INSERT-SO-DNP                                             *        
      ******************************************************************        
      *                                                                         
       8100-INSERT-SO-DNP.                                              
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_SO_DNP_CANCEL                             
                 (ACCOUNT_NO                                            
                 ,SO_UPDT_ACTION_FL)                                    
               VALUES                                                   
                 (:XK-ACCOUNT-NO                                        
                 ,:XK-SO-UPDT-ACTION-FL)                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-DISPLAY-SQLCODE.         
      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR -803                     
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*********************************************'   
              DISPLAY '* PCSKR112 PROCESSING ERROR                 *'   
              DISPLAY '* ABEND IN 8100-INSERT-SO-DNP               *'   
              DISPLAY '* ERROR ON INSERT                           *'   
              DISPLAY '* ACCOUNT NO          = 'XK-ACCOUNT-NO           
              DISPLAY '* SO UPDT ACTION FL   = 'XK-SO-UPDT-ACTION-FL    
              DISPLAY '* SQL RETURN CODE     = 'WS-DISPLAY-SQLCODE      
              DISPLAY '* PROCESSING TERMINATED                     *'   
              DISPLAY '*********************************************'   
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-TERMINATE                                                 *        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CONTINUE.                                                    
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7600-START-FCSJC01                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7620-START-FCSCA00                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9700-PROCESS-ABEND                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD0023B                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9900-ABEND                                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD09900                                                  
           END-EXEC.                                                            
      *                                                                         
