       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSKR100.                                          
       AUTHOR.       GOKUL SATHIYAMOORTHY.                              
       DATE-WRITTEN. FEB 2012.                                          
       DATE-COMPILED.                                                   
      ******************************************************************        
      **               SOUTH CAROLINA ELECTRIC & GAS                  **        
      **                      COBOL-DB2                               **        
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **                                                              **        
      ** THIS IS THE DRIVER PROGRAM FOR THE POST BILLING CREDIT       **        
      ** PROCESS FOR ACTIVE ACCOUNTS.                                 **        
      **                                                              **        
      **    THE FOLLOWING MODULES ARE CALLED:                         **        
      **        1. SCSKR110 - CREDIT HISTORY UPDATES.                 **        
      **        2. SCSKR111 - CREDIT GROUP UPDATES.                   **        
      **        3. SCSKR115 - CREDIT FORECASTING.                     **        
      **                                                              **        
      **    THE FOLLOWING PROCESSES HAPPEN IN THE DRIVER:             **        
      **        1. SURETY BOND EXPIRATION.                            **        
      **        2. MNT TRANSACTION HISTORY UPDATES.                   **        
      **        3. WQ GENERATION.                                     **        
      **        4. O/P FILE GENERATION.                               **        
      **                                                              **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 3999     OUTPUT PROCESS CONTROL PATH           **        
      **        4000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **              PROGRAM  MODIFICATION  LOG                      **        
      ******************************************************************        
      ** DATE     USERID   REASON                                     **        
      ** -------  -------  ------                                     **        
P00599** 02/2012  GOKUL    INITIAL IMPLEMENTATION.                    **        
P00599** 08/2012  AARON    INCREASED COUNTER VARIABLE LENGTH.         **        
P00599** 08/2012  GAYATHRI SET RETURN-CODE TO 3 WHEN ACCOUNTS ARE     **        
P00599**                   SKIPPED FROM THE FILE                      **        
P00599** 08/2012  GOKUL    TAKE SAVEPOINT BEFORE FIRST ACCOUNT.       **        
P00599** 08/2012  GOKUL    DO NOT PROCESS ACCOUNTS WITHOUT BI.        **        
ACT084** 06/2013  VIJAY    REMOVED UNUSED COPYBOOK CWSCB108           **        
ACT052** 12/2014  SS7F226  WORK QUEUE CHANGE TO REPLACE THE           **        
ACT052**          APPL4860 CSS_WQ_ITEMS_MF WITH CSS_WQ_ITEMS          **        
ACT052**                   AND REMOVED THE UNUSED CODE.               **        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSBE00.                                                            
       COPY CSSKR100.                                                           
      *RESTART FILE FOR KR100                                                   
       COPY CSSKR100 REPLACING FCSKR100-FILE      BY FCSKR10R-FILE,             
                               UT-S-FCSKR100      BY UT-S-FCSKR10R,             
                               WS-FCSKR100-STATUS BY WS-FCSKR10R-STATUS.        
                                                                        
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *INPUT FILE                                                               
      *                                                                         
       COPY CFDBE00.                                                            
       COPY FIOBE00.                                                            
      *                                                                         
      *OUTPUT FILE                                                              
       COPY CFDKR100.                                                           
       COPY FIOKR100.                                                           
                                                                        
      *RESTART FILE                                                             
       COPY CFDKR100 REPLACING FCSKR100-FILE      BY FCSKR10R-FILE.             
       01 FIOKR10R                       PIC X(547).                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ012      EXEC SQL INCLUDE MFADIAG END-EXEC
MSQ008  01 MSQ008-BILL-WINDOW  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSKR100'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                       PIC X(40) VALUE                
                        'WORKING STORAGE FOR PCSKR100 STARTS HERE'.     
       01 WS-MISC.                                                      
          05 WS-CURRENT-TIMESTAMP        PIC X(26) VALUE SPACES.        
          05 WS-WORK-DATE                PIC X(10) VALUE SPACES.        
          05 KR100-TABLE-ID              PIC 9(04) VALUE 8000.          
          05 WS-DISPLAY-SQLCODE          PIC -Z(8)9.                    
          05 WS-INDEX                    PIC S9(04) COMP VALUE +0.      
P00599    05 WS-PROCESS-COUNTER          PIC S9(09) COMP VALUE +0.      
P00599    05 WS-FCSKR100-CNTR            PIC S9(09) COMP VALUE +0.      
          05 WS-READY-TO-INSERT-COUNT    PIC S9(09) COMP VALUE +0.      
          05 WS-DEFAULT-INSERT-COUNT     PIC S9(09) COMP VALUE +100.    
          05 WS-ACCTS-TO-SKIP            PIC S9(09) COMP VALUE +0.      
          05 WS-DEFAULT-ACCTS-TO-SKIP    PIC S9(09) COMP VALUE +50.     
P00599    05 WS-SKIP-COUNTER             PIC S9(09) COMP VALUE +0.      
P00599    05 WS-COUNT-UNSUCCESSFUL-ROWS  PIC S9(09) COMP VALUE 0.       
          05 WS-NUM-COND                 PIC S9(09) COMP VALUE 0.       
          05 RS-RETURN-CODE              PIC S9(04) COMP VALUE 0.       
          05 S-RETURN-CODE               PIC S9(04) COMP VALUE 0.       
          05 RS-RETURN-CODE-DISP         PIC -Z(3)9.                    
          05 WS-DISPLAY-ACCOUNT          PIC 9(13) VALUE 0.             
P00599    05 WS-FCSBE00-REC-CNTR         PIC S9(09) VALUE ZERO COMP-3.  
P00599    05 WS-FCSKR10R-CNTR            PIC S9(09) VALUE ZERO COMP-3.  
          05 WS-DATABASE                 PIC 9(01).                     
          05 WS-KR100-SORT-KEY           PIC X(46).                     
          05 WS-RUN-DATE                 PIC X(10).                     
          05 WS-NEXT-BUSINESS-DAY        PIC X(10) VALUE SPACES.        
          05 WS-PREV-BUSINESS-DAY        PIC X(10) VALUE SPACES.        
          05 WS-TEMP-INITIAL-FL          PIC X(01).                     
          05 WS-TEMP-NOT-INITIAL-FL      PIC X(01).                     
          05 WS-CHKP-LUW-LIMIT           PIC 9(04) VALUE 0.             
          05 WS-CHKP-UPD-LIMIT           PIC 9(04) VALUE 0.             
          05 WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 5.             
          05 WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 5.             
          05 WS-ANNIV-DATE               PIC X(10).                     
          05 WS-ANNIV-DATE-NUM REDEFINES WS-ANNIV-DATE.                 
             10 WS-ANNIV-YYYY            PIC 9(4).                      
             10 FILLER                   PIC 9(1).                      
             10 WS-ANNIV-MM              PIC 9(2).                      
             10 FILLER                   PIC 9(1).                      
             10 FILLER                   PIC 9(2).                      
          05 WS-PREV-ANNIV-DATE.                                        
             10 WS-PREV-ANNIV-YYYY       PIC 9(4).                      
             10 WS-PREV-ANNIV-MM         PIC 9(2).                      
          05 WS-REV-MONTH-AT             PIC 9(6).                      
ACT052    05 WS-INPUT-ZERO               PIC X(16)                      
ACT052                                     VALUE '-00.00.00.000000'.    
ACT052    05 WS-INPUT-DATE-26            PIC X(26) VALUE SPACES.        
                                                                        
       01 WS-HOLD-VARIABLES.                                            
          05 WS-PREVIOUS-ACCT-NO         PIC 9(13) VALUE 0.             
                                                                        
       01 WS-MISC-HOST-VARIABLES.                                       
          05 WS-BN-BILL-CYCLE-ARR        PIC X(02) OCCURS 20  TIMES     
                                                VALUE SPACES.           
          05 WS-BN-REVENUE-MNTH-ARR      PIC S9(6)V USAGE COMP-3        
                                                OCCURS 20  TIMES        
                                                VALUE ZEROES.           
                                                                        
       01 WS-BILL-WINDOW-TABLE.                                         
          05 WS-BN-BILL-WDW-DATA     OCCURS 0 TO 50                     
                                     DEPENDING ON WS-BN-COUNT           
                                     INDEXED BY WS-BN-INDX.             
             10 WS-BN-BILL-CYCLE              PIC X(02).                
COB305       10 WS-BN-REVENUE-MNTH        PIC S9(6)V USAGE COMP-3 
COB305          VALUE 0.  
                                                                        
       01 WS-SWITCHES.                                                  
          05 WS-ON-OFF-CYCLE-IND           PIC X(1).                    
             88  OFF-CYCLE-REBILL                    VALUE 'O'.         
             88  ON-CYCLE-BILL                       VALUE 'A'.         
             88  PRP-FIRST-EST-BILL                  VALUE 'P'.         
                                                                        
          05 WS-PROCESS-ACCOUNT            PIC X(01) VALUE 'Y'.         
             88 PROCESS-ACCT                         VALUE 'Y'.         
             88 SKIP-ACCT                            VALUE 'N'.         
                                                                        
          05 WS-END-OF-BE00-SW             PIC X(01).                   
             88 END-OF-BE00                          VALUE 'Y'.         
                                                                        
          05  WS-END-OF-FILE-SW           PIC X(01)  VALUE 'N'.         
              88 END-OF-FILE                         VALUE 'Y'.         
                                                                        
          05 WS-ROW-FOUND-SW               PIC X(01).                   
             88 ROW-FOUND                            VALUE 'Y'.         
             88 ROW-NOT-FOUND                        VALUE 'N'.         
                                                                        
          05 WS-BEGIN-REC-SW               PIC X(01).                   
             88 WS-BEGIN-RECS-PROCESSED              VALUE 'Y'.         
             88 WS-BEGIN-REC-NOT-PROCESSED           VALUE 'N'.         
             88 WS-START-INPUT-DATA                  VALUE 'X'.         
                                                                        
          05 WS-RECORD-FOUND               PIC X(01) VALUE 'N'.         
             88 DATA-RECORD-FOUND                    VALUE 'Y'.         
             88 NO-DATA-RECORD-FOUND                 VALUE 'N'.         
                                                                        
          05 WS-FBE00-STATUS               PIC X(02).                   
             88 FCSBE00-SUCCESSFUL                   VALUE '00'.        
             88 END-OF-FCSBE00                       VALUE '10'.        
                                                                        
          05 WS-FCSKR100-STATUS            PIC X(02).                   
             88 FCSKR100-SUCCESSFUL                  VALUE '00'.        
             88 END-OF-FCSKR100                      VALUE '10'.        
                                                                        
          05 WS-FCSKR10R-STATUS            PIC X(02).                   
             88 FCSKR10R-SUCCESSFUL                  VALUE '00'.        
             88 END-OF-FCSKR10R                      VALUE '10'.        
                                                                        
          05 WS-CWS-TABLE-ID               PIC 9(04).                   
             88 WS-CWS10000-TABLE-ID                 VALUES             
                0300 1400 1900 1910 2400 2500 2700 2900 3000 5300 6650  
                6770 6780 0700.                                         
                                                                        
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME                  PIC X(08) VALUE 'PCSKR100'.  
          05 WS-PGRMNAME                   PIC X(08) VALUE 'PCSKR100'.  
          05 WS-COMMON-DATE                PIC X(10) VALUE 'COMMONDATE'.
          05 SCSKR110                      PIC X(08) VALUE 'SCSKR110'.  
          05 SCSKR111                      PIC X(08) VALUE 'SCSKR111'.  
          05 SCSKR115                      PIC X(08) VALUE 'SCSKR115'.  
ACT052    05 SCSCB077                      PIC X(08) VALUE 'SCSCB077'.  
          05 WS-AUTO-DROP-DPP              PIC X(13) VALUE              
                                                     'AUTO_DROP_DPP'.   
          05 WS-Y                          PIC X(01) VALUE 'Y'.         
          05 WS-N                          PIC X(01) VALUE 'N'.         
          05 WS-I                          PIC X(01) VALUE 'I'.         
          05 WS-SYSTEM                     PIC X(06) VALUE 'SYSTEM'.    
      *                                                                         
       01 WS-RESTART-MISC.                                              
          05 WS-RESTART-DATA-LENGTH     PIC S9(04) COMP VALUE +45.      
          05 WS-DEFAULT-RESTART-REQ     PIC X(01) VALUE 'N'.            
          05 WS-IS-THIS-A-RESTART       PIC X(01) VALUE 'N'.            
             88 WS-THIS-IS-A-RESTART              VALUE 'Y'.            
             88 WS-THIS-IS-NOT-A-RESTART          VALUE 'N'.            
          05 WS-RESTART-REQ             PIC X(01).                      
          05 WS-CHKP-SEQ-NO             PIC 9(05) COMP VALUE 0.         
          05 WS-SEQ-NO                  PIC S9(04)V COMP-3 VALUE 0.     
          05 WS-RESTART-COMMIT-COUNTER  PIC S9(9) USAGE COMP VALUE +0.  
          05 WS-ORDER-ROW-COUNT         PIC S9(09) USAGE COMP VALUE 0.  
          05 WS-C8-COUNT                PIC S9(09) USAGE COMP VALUE 0.  
          05 WS-BN-COUNT                PIC S9(09) USAGE COMP VALUE 0.  
          05 WS-ROW-ERRORS              PIC S9(09) USAGE COMP VALUE 0.  
          05 WS-DB2-SQLCODE             PIC S9(09) USAGE COMP VALUE 0.  
          05 WS-DB2-ROW-NUM             PIC S9(09) USAGE COMP VALUE 0.  
          05 WS-DISP-INSERT-COUNT       PIC +Z(9).                      
          05 WS-DISP-ROW-COUNT          PIC +Z(9).                      
          05 WS-DISP-ROW-NUM            PIC +Z(9).                      
          05 WS-DISP-DB2-SQLCODE        PIC +Z(9).                      
          05 WS-DISP-FILE-COUNTER       PIC +Z(9).                      
          05 WS-ROW-NUM                 PIC S9(09) USAGE COMP VALUE 0.  
          05 WS-RECORD-CTR              PIC S9(09) USAGE COMP VALUE +0. 
      *                                                                         
       01 WS-RESTART-DATA.                                              
          05 WS-RESTART-PROCESS-TYPE    PIC 9(01).                      
          05 WS-RESTART-JOB-COMPLETE    REDEFINES                       
             WS-RESTART-PROCESS-TYPE    PIC X(01).                      
          05 WS-RESTART-JOB-STATUS      PIC X(01).                      
             88 WS-RUN-COMPLETED-NO-PROBLEMS VALUE 'A'.                 
             88 WS-RERUN-COMPLETED           VALUE 'B'.                 
             88 WS-RERUN-PENDING             VALUE 'C'.                 
          05 WS-RESTART-COMMON-DATE     PIC X(10) VALUE SPACES.         
          05 WS-RESTART-CHKP-SEQ-NO     PIC S9(09) USAGE COMP VALUE +0. 
          05 WS-RESTART-ACCOUNT-NO      PIC 9(13) VALUE 0.              
          05 WS-RESTART-BE00-REC-CTR    PIC S9(09) USAGE COMP VALUE +0. 
          05 WS-RESTART-FCSKR10R-CTR    PIC S9(09) USAGE COMP VALUE +0. 
          05 WS-RESTART-SKIP-COUNTER    PIC S9(09) USAGE COMP VALUE +0. 
      *                                                                         
      ******************************************************************        
      *  FIOBE01 CONTAINS CWS10001 VARIABLES USED IN OTHER             *        
      ******************************************************************        
       COPY FIOBE01.                                                            
      *                                                                         
      ******************************************************************        
      *  FIOBE38 CONTAINS CWS10000 VARIABLES USED IN OTHER             *        
      ******************************************************************        
       COPY FIOBE38.                                                            
      *                                                                         
      ******************************************************************        
      *  FIOCA00 COPYBOOK TO GET JOB_PARM DATA.                        *        
      ******************************************************************        
       COPY FIOCA00.                                                            
      *                                                                         
      ******************************************************************        
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                        *        
      ******************************************************************        
       COPY CWS00010.                                                           
      *                                                                         
      ******************************************************************        
      *  CWS1000B & CWS1000K CONTAINS BE00 / KR100 LAYOUTS             *        
      ******************************************************************        
       COPY CWS1000A.                                                           
       COPY CWS1000B.                                                           
       COPY CWS1000K.                                                           
       COPY CWS10009.                                                           
       COPY CWS1001B.                                                           
       COPY CWS1001A.                                                           
       COPY CWS00056.                                                           
      *                                                                         
      ******************************************************************        
      *   CWS100B5 CONTAINS INDEX/TABLE ERROR MESSAGES BE02            *        
      ******************************************************************        
       COPY CWS100B5.                                                           
      *                                                                         
      ******************************************************************        
      *   CWS10006 CONTAINS INDEX/TABLE ERROR MESSAGES BE13            *        
      ******************************************************************        
       COPY CWS10006.                                                           
      *                                                                         
      ******************************************************************        
      *   CWS10008 KR100 PROCESSING DATA.                              *        
      ******************************************************************        
       COPY CWS10008.                                                           
      *                                                                         
      ******************************************************************        
      *  CWS00039 JOB PARM ROUTINE                                     *        
      ******************************************************************        
       COPY CWS00039.                                                           
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR CPD09900 CONTAINS ABEND WS VARIABLES       *        
      ******************************************************************        
       COPY CWS09900.                                                           
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR SURETY BOND PROCESSING                     *        
      ******************************************************************        
       COPY CWS00340.                                                           
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR UTL / NON-UTL BALANCE CALCULATIONS         *        
      ******************************************************************        
       COPY CWS00339.                                                           
      *                                                                         
      ******************************************************************        
      * ERROR MESSAGE COPYBOOK.                                        *        
      ******************************************************************        
       COPY CWS00303.                                                           
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
       COPY CWS00050.                                                           
      *                                                                         
ACT052******************************************************************        
ACT052* FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077          *        
ACT052******************************************************************        
ACT052     EXEC SQL                                                             
ACT052        INCLUDE CWS00077                                                  
ACT052     END-EXEC.                                                            
ACT052*                                                                         
      ******************************************************************        
      *  CWS00038 JOB PARM ROUTINE                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
                                                                        
       01  WS-INSERT-ROW-COUNT REDEFINES WS-INPUT-DATA-BREAKDOWN.       
           10  WS-PARM-INSERT-ROW-COUNT-TXT PIC X(21).                  
               88 INSERT-ROW-CNT         VALUE 'NO-OF-ROWS-TO-INSERT='. 
           10  WS-NO-OF-ROWS-TO-INSERT   PIC X(05).                     
           10  FILLER                    PIC X(54).                     
                                                                        
       01  WS-SKIP-ROW-COUNT REDEFINES WS-INPUT-DATA-BREAKDOWN.         
           10  WS-PARM-SKIP-ROW-COUNT-TXT PIC X(14).                    
               88 SKIP-ROW-CNT         VALUE 'ACCTS-TO-SKIP='.          
           10  WS-NO-OF-ROWS-TO-SKIP     PIC X(05).                     
           10  FILLER                    PIC X(61).                     
      *                                                                         
      *                                                                         
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSKR100 ENDS HERE  '.            
      *                                                                         
      ******************************************************************        
      * DB2 INCLUDES.                                                  *        
      ******************************************************************        
      *    SQLCA                                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ******************************************************************        
      *  CSS_ACCOUNT       - AT                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_BILL_WINDOW   - BN                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBBILWDW                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_BUSINESS_DAYS  - 1G                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBBUSDAY                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_CORR_MAIL_STAT - MW                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBMAILST                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_DELINQUENCY   - C8                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBDELQ                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_GUARANTOR - GU                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGTNTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_JOB_PARM      - G6                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_MNT_TRANS_HIST - MH                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_MT_TRN_HST_DET - MI                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_RESTART       - RF                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRESTRT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_SURETY_BOND   - SB                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSTYBND                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************00165600
      * WORKING STORAGE NEXT BUSINESS DAY CPYC CPD00322.               *00165700
      ******************************************************************00165800
           EXEC SQL                                                             
              INCLUDE CWS00322                                                  
           END-EXEC.                                                            
                                                                        
      *                                                                         
      * DB2 CURSORS.                                                            
      *------------*                                                            
      *                                                                         
      ******************************************************************        
      * DECLARE CURSOR TO GET BILL_CYCLES FOR THE PROCESSING DATE      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE BILL_WINDOW CURSOR WITH ROWSET POSITIONING FOR    
               SELECT BN.BILL_CYCLE                                     
                     ,BN.REVENUE_MONTH                                  
                 FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                  
                WHERE DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )                     
                  FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BILL_WINDOW CURSOR WITH ROWSET POSITIONING FOR            
MFA-TR*        SELECT BN.BILL_CYCLE                                             
MFA-TR*              ,BN.REVENUE_MONTH                                          
MFA-TR*          FROM CSS_BILL_WINDOW BN                                        
MFA-TR*         WHERE DATE_EXTRACT = :WS-INPUT-DATE                             
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
       01  WS-END                          PIC X(40)      VALUE         
                       'WORKING STORAGE FOR PCSKR100 ENDS HERE  '.      
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  PARMIN.                                                      
           05  PARMLENGTH                  PIC S9(04) COMP.             
           05  PARM-COMMON-DATE            PIC X(10).                   
                                                                        
       PROCEDURE DIVISION USING PARMIN.                                 
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM  0100-INITIALIZATION         THRU  0100-EXIT.        
           PERFORM  1000-PROCESS-INPUT          THRU  1000-EXIT.        
           PERFORM  9000-TERMINATE              THRU  9000-EXIT.        
P00599*    IF WS-SKIP-COUNTER  > 0                                              
P00599*       MOVE 03                           TO RETURN-CODE                  
P00599*    END-IF.                                                              
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZATION                                            *        
      * OPEN OUTPUT FILE                                               *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
                                                                        
           INITIALIZE                           WS-MISC-HOST-VARIABLES  
                                                WS-PROCESS-COUNTER.     
           IF PARMLENGTH > 0                                            
              MOVE PARM-COMMON-DATE             TO WS-INPUT-DATE        
               DISPLAY '** PCSKR100 PROCESSING MESSAGE  **'             
               DISPLAY '** JCL OVERRIDE DATE BEING USED **'             
               DISPLAY '** DATE = ' WS-INPUT-DATE                       
               DISPLAY '**  PROCESSING CONTINUING       **'             
           ELSE                                                         
              PERFORM 0110-GET-JOB-PARM-DETAILS THRU 0110-EXIT          
           END-IF.                                                      
                                                                        
      * GET DB2 INSERT ROW COUNT                                                
                                                                        
           PERFORM 0115-GET-INSERT-ROW-COUNT    THRU 0115-EXIT.         
                                                                        
      * GET DB2 SKIP ROW COUNT                                                  
                                                                        
           PERFORM 0125-GET-SKIP-ROW-COUNT      THRU 0125-EXIT.         
                                                                        
      * OPEN THE INPUT FILE BE00 AND OTHER O/P FILES                            
                                                                        
           PERFORM 0120-OPEN-FILES              THRU 0120-EXIT.         
                                                                        
      * TO IDENTIFY THE DATA BASE                                               
           MOVE ZERO                            TO WS-DATABASE.         
           MOVE '01'                            TO C8-COMPANY-NO.       
           MOVE 'DATABASE'                      TO C8-DELINQ-CD.        
           PERFORM 7000-SELECT-DELINQ-VALUE     THRU 7000-EXIT.         
           MOVE C8-DELINQ-VALUE                 TO WS-DATABASE.         
                                                                        
      *                                                                         
           PERFORM 0300-PROCESS-FOR-RESTART     THRU 0300-EXIT.         
      * LOAD BILL_WINDOW DATA TO AN INTERNAL TABLE                              
           PERFORM 0200-LOAD-BILL-WINDOW        THRU 0200-EXIT.         
                                                                        
           PERFORM 0250-COMPUTE-WORK-DATES      THRU 0250-EXIT.         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0110-GET-JOB-PARM-DETAILS.                                     *        
      *    1. SELECT RUN-DATE                                          *        
      *    2. SELECT REVENUE-MONTH                                     *        
      ******************************************************************        
       0110-GET-JOB-PARM-DETAILS.                                       
                                                                        
           PERFORM 6251-GET-FJC01-DATE          THRU 6251-EXIT.         
                                                                        
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                                THRU 6240-EXIT          
               MOVE WS-FCA00-COMMON-DATE        TO WS-INPUT-DATE        
               DISPLAY '** PCSKR100 PROCESSING MESSAGE **'              
               DISPLAY '** COMMON DATE BEING USED      **'              
               DISPLAY '** DATE = ' WS-INPUT-DATE                       
               DISPLAY '**  PROCESSING CONTINUING      **'              
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE                   TO WS-RUN-DATE.         
                                                                        
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0115-GET-INSERT-ROW-COUNT.                                     *        
      * GET THE INSERT ROW COUNT FROM JOB PARM TABLE                   *        
      ******************************************************************        
       0115-GET-INSERT-ROW-COUNT.                                       
                                                                        
           MOVE  WS-PGRMNAME               TO WS-PROGRAM.               
           MOVE  WS-PARM                   TO WS-COMMAND.               
           MOVE  ZEROS                     TO WS-SEQUENCE.              
           MOVE  SPACES                    TO WS-SYSIPT.                
           MOVE  WS-KEY-AREA               TO E-FJC01-KEY.              
                                                                        
           PERFORM 7600-START-FCSJC01      THRU  7600-EXIT.             
           PERFORM 7610-READ-FCSJC01       THRU  7610-EXIT              
              UNTIL (INSERT-ROW-CNT AND INPUT-ACTIVE)                   
              OR  END-OF-SYSIPT.                                        
                                                                        
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '** ' WS-PGRMNAME ' PROCESSING WARNING  **'       
              DISPLAY '**  INSERT-ROW-CNT PARM NOT ACTIVE     **'       
              DISPLAY '**  DEFAULT OF ' WS-DEFAULT-INSERT-COUNT         
                          ' WILL BE USED  **'                           
              DISPLAY '**  PROCESSING CONTINUING        **'             
              MOVE WS-DEFAULT-INSERT-COUNT                              
                                         TO WS-READY-TO-INSERT-COUNT    
           ELSE                                                         
              IF WS-NO-OF-ROWS-TO-INSERT  NUMERIC                       
                 MOVE WS-NO-OF-ROWS-TO-INSERT                           
                                         TO WS-READY-TO-INSERT-COUNT    
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY '**  ' WS-PGRMNAME ' PROCESSING WARNING  **'   
                 DISPLAY '**  INSERT-ROW-CNT PARM NOT NUMERIC  **'      
                 DISPLAY '**  DEFAULT OF ' WS-DEFAULT-INSERT-COUNT      
                         ' WILL BE USED  **'                            
                 DISPLAY '**  PROCESSING CONTINUING        **'          
                 MOVE WS-DEFAULT-INSERT-COUNT                           
                                         TO WS-READY-TO-INSERT-COUNT    
              END-IF                                                    
              PERFORM 7611-CLOSE                 THRU 7611-EXIT         
           END-IF.                                                      
      *                                                                         
       0115-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0120-OPEN-FILES.                                               *        
      * OPEN INPUT FILE TO BEGIN PROCESSING.                           *        
      ******************************************************************        
       0120-OPEN-FILES.                                                 
                                                                        
           OPEN INPUT FCSBE00-FILE.                                     
           IF FCSBE00-SUCCESSFUL                                        
              PERFORM 0500-PROCESS-BEGIN-REC    THRU  0500-EXIT         
                UNTIL E-FBE00-KEY-BREC NOT EQUAL LOW-VALUES             
           ELSE                                                         
              DISPLAY '********** PCSKR100 ABORT **************'        
              DISPLAY '*       0120-OPEN-FILES                *'        
              DISPLAY '*    ERROR OPENING FCSBE00 FILE        *'        
              DISPLAY '* FILE STATUS    : ' WS-FBE00-STATUS             
              DISPLAY '*      PROCESSING TERMINATED           *'        
              DISPLAY '********** PCSKR100 ABORT **************'        
              PERFORM 9900-ABEND                THRU  9900-EXIT         
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSKR100-FILE.                                   
           IF NOT FCSKR100-SUCCESSFUL                                   
               DISPLAY '********** PCSKR100 ABORT  ************'        
               DISPLAY '**  0120-OPEN-FILES                   *'        
               DISPLAY '**  ERROR OPENING FCSKR100            *'        
               DISPLAY '**  FILE STATUS = ' WS-FCSKR100-STATUS          
               DISPLAY '********** PCSKR100 ABORT  ************'        
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
                                                                        
                                                                        
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0125-GET-SKIP-ROW-COUNT.                                     *          
      * GET THE SKIP ROW COUNT FROM JOB PARM TABLE                   *          
      ******************************************************************        
       0125-GET-SKIP-ROW-COUNT.                                         
                                                                        
           MOVE  WS-PGRMNAME               TO WS-PROGRAM.               
           MOVE  WS-PARM                   TO WS-COMMAND.               
           MOVE  ZEROS                     TO WS-SEQUENCE.              
           MOVE  SPACES                    TO WS-SYSIPT.                
           MOVE  WS-KEY-AREA               TO E-FJC01-KEY.              
                                                                        
           PERFORM 7600-START-FCSJC01      THRU  7600-EXIT.             
           PERFORM 7610-READ-FCSJC01       THRU  7610-EXIT              
              UNTIL (SKIP-ROW-CNT AND INPUT-ACTIVE)                     
              OR  END-OF-SYSIPT.                                        
                                                                        
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '** ' WS-PGRMNAME ' PROCESSING WARNING  **'       
              DISPLAY '**  SKIP-ROW-CNT PARM NOT ACTIVE     **'         
              DISPLAY '**  DEFAULT OF ' WS-DEFAULT-ACCTS-TO-SKIP        
                          ' WILL BE USED  **'                           
              DISPLAY '**  PROCESSING CONTINUING        **'             
              MOVE WS-DEFAULT-ACCTS-TO-SKIP                             
                                         TO WS-ACCTS-TO-SKIP            
           ELSE                                                         
              IF WS-NO-OF-ROWS-TO-SKIP    NUMERIC                       
                 MOVE WS-NO-OF-ROWS-TO-SKIP                             
                                         TO WS-ACCTS-TO-SKIP            
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY '**  ' WS-PGRMNAME ' PROCESSING WARNING  **'   
                 DISPLAY '**  SKIP-ROW-CNT PARM NOT NUMERIC  **'        
                 DISPLAY '**  DEFAULT OF ' WS-DEFAULT-ACCTS-TO-SKIP     
                         ' WILL BE USED  **'                            
                 DISPLAY '**  PROCESSING CONTINUING        **'          
                 MOVE WS-DEFAULT-ACCTS-TO-SKIP                          
                                         TO WS-ACCTS-TO-SKIP            
              END-IF                                                    
              PERFORM 7611-CLOSE                 THRU 7611-EXIT         
           END-IF.                                                      
      *                                                                         
       0125-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0200-LOAD-BILL-WINDOW                                          *        
      * PROCESS FOR LOADING DELINQUENCY                                *        
      ******************************************************************        
       0200-LOAD-BILL-WINDOW.                                           
                                                                        
           MOVE 1                               TO WS-INDEX             
           MOVE 0                               TO WS-ORDER-ROW-COUNT   
           SET  WS-BN-INDX                      TO 1                    
                                                                        
           PERFORM 7100-OPEN-BILL-WINDOW        THRU 7100-EXIT.         
           PERFORM 7110-FETCH-BILL-WINDOW       THRU 7110-EXIT.         
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 0210-LOAD-BILL-WINDOW-TBL THRU 0210-EXIT          
                  UNTIL WS-INDEX > WS-ORDER-ROW-COUNT                   
                  OR WS-BN-BILL-CYCLE-ARR(WS-INDEX) = SPACES            
                                                                        
              MOVE 1             TO WS-INDEX                            
                                                                        
              INITIALIZE WS-MISC-HOST-VARIABLES                         
                                                                        
              PERFORM 7110-FETCH-BILL-WINDOW    THRU 7110-EXIT          
           END-PERFORM.                                                 
                                                                        
      * IF NOT-FOUND OCCURS WHEN THERE IS A SUBSET ROW                          
           IF SQLERRD(3) > 0                                            
              PERFORM 0210-LOAD-BILL-WINDOW-TBL THRU 0210-EXIT          
                  UNTIL WS-INDEX > WS-ORDER-ROW-COUNT                   
                  OR WS-BN-BILL-CYCLE-ARR(WS-INDEX) = SPACES            
           END-IF                                                       
                                                                        
           PERFORM 7120-CLOSE-BILL-WINDOW       THRU 7120-EXIT.         
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0210-LOAD-BILL-WINDOW-TBL.                                     *        
      * LOAD THE BILL WINDOW DATA INTO A WS ARRAY                      *        
      ******************************************************************        
       0210-LOAD-BILL-WINDOW-TBL.                                       
      *                                                                         
           MOVE WS-BN-BILL-CYCLE-ARR(WS-INDEX)    TO                    
                               WS-BN-BILL-CYCLE(WS-BN-INDX)             
           MOVE WS-BN-REVENUE-MNTH-ARR(WS-INDEX)  TO                    
                               WS-BN-REVENUE-MNTH(WS-BN-INDX)           
           SET WS-BN-INDX                         UP BY 1.              
           ADD 1                                  TO WS-INDEX.          
      *                                                                         
       0210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0250-COMPUTE-WORK-DATES.                                       *        
      * COMPUTE WORK DATES.                                            *        
      ******************************************************************        
       0250-COMPUTE-WORK-DATES.                                         
      *                                                                         
      * NEXT BUSINESS DAY                                                       
           MOVE WS-INPUT-DATE                   TO WS-NEW-BUSINESS-DAY. 
           PERFORM 6500-GET-NEXT-BUSINESS-DAY   THRU                    
                                            6500-NEXT-BUSINESS-DAY-EXIT.
           MOVE WS-NEW-BUSINESS-DAY             TO WS-NEXT-BUSINESS-DAY.
                                                                        
      * PREV BUSINESS DAY                                                       
           MOVE WS-INPUT-DATE                   TO WS-NEW-BUSINESS-DAY. 
           PERFORM 6525-PREV-BUSINESS-DAY       THRU                    
                                            6525-PREV-BUSINESS-DAY-EXIT.
           MOVE WS-NEW-BUSINESS-DAY             TO WS-PREV-BUSINESS-DAY.
                                                                        
      * 20 DAYS AGO                                                             
           MOVE +20                             TO WS-NO-OF-DAY.        
           PERFORM 7250-COMPUTE-DATES           THRU 7250-EXIT.         
           MOVE WS-WORK-DATE                    TO WS-DT-20-DAYS-AGO.   
                                                                        
      * 25 DAYS AGO                                                             
           MOVE +25                             TO WS-NO-OF-DAY.        
           PERFORM 7250-COMPUTE-DATES           THRU 7250-EXIT.         
           MOVE WS-WORK-DATE                    TO WS-DT-25-DAYS-AGO.   
                                                                        
      * 55 DAYS AGO                                                             
           MOVE +55                             TO WS-NO-OF-DAY.        
           PERFORM 7250-COMPUTE-DATES           THRU 7250-EXIT.         
           MOVE WS-WORK-DATE                    TO WS-DT-55-DAYS-AGO.   
                                                                        
      * 85 DAYS AGO                                                             
           MOVE +85                             TO WS-NO-OF-DAY.        
           PERFORM 7250-COMPUTE-DATES           THRU 7250-EXIT.         
           MOVE WS-WORK-DATE                    TO WS-DT-85-DAYS-AGO.   
           MOVE +1                              TO WS-NO-OF-DAY.        
                                                                        
      *                                                                         
       0250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0300-PROCESS-FOR-RESTART.                                      *        
      * PROCESS FOR THE RESTART                                        *        
      ******************************************************************        
      *                                                                         
       0300-PROCESS-FOR-RESTART.                                        
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 6253-GET-FJC01-CHKP-LIMIT    THRU 6253-EXIT.         
                                                                        
           INITIALIZE WS-SYSIPT                                         
           PERFORM 6235-GET-FJC01-RESTART-REQ   THRU 6235-EXIT.         
                                                                        
           PERFORM 0350-CHECK-AND-VALDT-RESTART THRU 0350-EXIT.         
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              PERFORM 0375-PREPARE-RESTART      THRU 0375-EXIT          
           END-IF.                                                      
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0350-CHECK-AND-VALDT-RESTART.                                  *        
      * VALIDATING RESTART                                             *        
      ******************************************************************        
      *                                                                         
       0350-CHECK-AND-VALDT-RESTART.                                    
      *                                                                         
           MOVE PROGRAM-NAME                    TO RF-NAME-PROGRAM.     
           MOVE 1                               TO RF-PARTITION-NO.     
           MOVE 1                               TO RF-DUP-CNTRL-NO.     
                                                                        
           PERFORM 7050-SELECT-RESTART          THRU 7050-EXIT.         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE RF-RESTART-DATA-TEXT         TO WS-RESTART-DATA      
              IF WS-RESTART-PROCESS-TYPE NUMERIC                        
                 MOVE WS-Y                      TO WS-IS-THIS-A-RESTART 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 0605-VALIDATE-RESTART-REQ    THRU 0605-EXIT.         
      *                                                                         
       0350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0375-PREPARE-RESTART.                                          *        
      * PREPARE FOR RESTART                                            *        
      ******************************************************************        
      *                                                                         
       0375-PREPARE-RESTART.                                            
      *                                                                         
           IF WS-THIS-IS-A-RESTART                                      
              DISPLAY '*******************************************'     
              DISPLAY '*****   THIS IS A RESTART OF PCSKR100   ***'     
              DISPLAY '*******************************************'     
              OPEN INPUT FCSKR10R-FILE                                  
              IF FCSKR10R-SUCCESSFUL                                    
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '0375-ERROR ON FCSKR10R OPEN.  STATUS IS '     
                                               WS-FCSKR10R-STATUS       
                 PERFORM 9900-ABEND             THRU 9900-EXIT          
              END-IF                                                    
              PERFORM WS-RESTART-FCSKR10R-CTR TIMES                     
                 READ FCSKR10R-FILE                                     
                   IF FCSKR10R-SUCCESSFUL                               
                      WRITE FIOKR100 FROM  FIOKR10R                     
                      ADD 1                     TO  WS-FCSKR10R-CNTR    
                      IF FCSKR100-SUCCESSFUL                            
                         CONTINUE                                       
                      ELSE                                              
                         DISPLAY 'ERROR ON FCSKR100 REWRITE. STATUS IS '
                                                    WS-FCSKR100-STATUS  
                         PERFORM 9900-ABEND     THRU 9900-EXIT          
                      END-IF                                            
                   ELSE                                                 
                      DISPLAY 'PREMATURE EOF ON FCSKR10R RESTART'       
                      DISPLAY 'PROCESSING TERMINATED'                   
                      PERFORM 9900-ABEND        THRU 9900-EXIT          
                   END-IF                                               
              END-PERFORM                                               
              CLOSE FCSKR10R-FILE                                       
              PERFORM 7700-READ-INPUT           THRU 7700-EXIT          
                UNTIL WS-FCSBE00-REC-CNTR = WS-RESTART-BE00-REC-CTR     
           END-IF.                                                      
      *                                                                         
       0375-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0400-PREPARE-PRECOMMIT.                                        *        
      * MOVE ALL THE REQUIRED RESTART RECORD VALUES PRIOR TO UPDATE    *        
      ******************************************************************        
      *                                                                         
       0400-PREPARE-PRECOMMIT.                                          
      *                                                                         
            MOVE 1                       TO WS-RESTART-PROCESS-TYPE.    
            MOVE WS-C                    TO WS-RESTART-JOB-STATUS.      
            MOVE WS-INPUT-DATE           TO WS-RESTART-COMMON-DATE.     
            MOVE WS-CHKP-SEQ-NO          TO WS-RESTART-CHKP-SEQ-NO.     
            MOVE WS-ACCOUNT-NO-AT        TO WS-RESTART-ACCOUNT-NO.      
            MOVE WS-FCSBE00-REC-CNTR     TO WS-RESTART-BE00-REC-CTR.    
            MOVE WS-FCSKR100-CNTR        TO WS-RESTART-FCSKR10R-CTR.    
            MOVE WS-SKIP-COUNTER         TO WS-RESTART-SKIP-COUNTER.    
      *                                                                         
       0400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *VALIDATES RESTART REQUEST.                                      *        
      ******************************************************************        
       COPY CPD00030.                                                           
                                                                        
      ******************************************************************        
      ** 6235-GET-FJC01-RESTART-REQ                                    *        
      ******************************************************************        
      *                                                                         
       COPY CPD00035.                                                           
      *                                                                         
      ******************************************************************        
      * 0500-PROCESS-BEGIN-REC.                                        *        
      ******************************************************************        
       0500-PROCESS-BEGIN-REC.                                          
                                                                        
           PERFORM 7700-READ-INPUT              THRU 7700-EXIT.         
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-FCSBE00                                       
                 DISPLAY '********** PCSKR100 ABORT **************'     
                 DISPLAY '*       0500-PROCESS-BEGIN-REC         *'     
                 DISPLAY '*        FCSBE00 FILE IS EMPTY         *'     
                 DISPLAY '*      PROCESSING TERMINATED           *'     
                 DISPLAY '********** PCSKR100 ABORT **************'     
                 PERFORM 9900-ABEND            THRU  9900-EXIT          
              WHEN E-FBE00-KEY-BREC EQUAL LOW-VALUES                    
                 IF E-FBE00-CREATE-DATE-BREC NOT = WS-INPUT-DATE        
                    DISPLAY '********** PCSKR100 ABORT **************'  
                    DISPLAY '*       0500-PROCESS-BEGIN-REC         *'  
                    DISPLAY '* FCSBE00 CREATE DATE NOT = RUN DATE   *'  
                    DISPLAY '* BE00 CREATE DATE: '                      
                                      E-FBE00-CREATE-DATE-BREC          
                    DISPLAY '* RUN  DATE: ' WS-INPUT-DATE               
                    DISPLAY '*      PROCESSING TERMINATED           *'  
                    DISPLAY '********** PCSKR100 ABORT **************'  
                    PERFORM 9900-ABEND         THRU 9900-EXIT           
                 END-IF                                                 
                                                                        
                 SET WS-BEGIN-RECS-PROCESSED TO TRUE                    
              WHEN WS-BEGIN-RECS-PROCESSED                              
                 IF E-FBE00-KEY-BREC EQUAL HIGH-VALUES OR LOW-VALUES    
                    IF E-FBE00-KEY-BREC EQUAL HIGH-VALUES               
                      AND NO-DATA-RECORD-FOUND                          
                      AND E-FBE00-RECORD-COUNT-EREC EQUAL ZERO          
                       DISPLAY '******* PCSKR100 MESSAGE*********'      
                       DISPLAY '*   0500-PROCESS-BEGIN-REC      *'      
                       DISPLAY '*    FCSBE00 FILE IS EMPTY      *'      
                       DISPLAY '*    PROCESSING TERMINATED      *'      
                       DISPLAY '******* PCSKR100 ABORT **********'      
                       PERFORM 9900-ABEND       THRU  9900-EXIT         
                    END-IF                                              
                 ELSE                                                   
                    SET DATA-RECORD-FOUND    TO TRUE                    
                    ADD 1                    TO WS-FCSBE00-REC-CNTR     
                 END-IF                                                 
              WHEN OTHER                                                
                 DISPLAY '********** PCSKR100 ABORT **************'     
                 DISPLAY '*       0500-PROCESS-BEGIN-REC         *'     
                 DISPLAY '*   FIRST RECORD IS NOT A CNTL REC     *'     
                 DISPLAY '*      PROCESSING TERMINATED           *'     
                 DISPLAY '********** PCSKR100 ABORT **************'     
                 PERFORM 9900-ABEND             THRU  9900-EXIT         
           END-EVALUATE.                                                
      *                                                                         
       0500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   0609-INITIALIZE-FBE36-WS-AREA                                *        
      ******************************************************************        
       COPY CPD0052B.                                                           
                                                                        
      ******************************************************************        
      *   0640-INITIALIZE-FBE01-WS-AREA                                *        
      ******************************************************************        
       COPY CPD0049B.                                                           
                                                                        
      ******************************************************************        
      *   0690-INITIALIZE-FBE38-WS-AREA                                *        
      ******************************************************************        
       COPY CPD0101C.                                                           
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      * PROCESS ALL BE00 ACCOUNTS                                      *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
P00599     PERFORM 8887-SAVEPOINT               THRU 8887-EXIT.         
           PERFORM 1010-PROCESS-FCSBE00         THRU 1010-EXIT          
              UNTIL END-OF-BE00.                                        
                                                                        
           ADD WS-PROCESS-COUNTER               TO WS-FCSKR100-CNTR.    
                                                                        
      * CHECK IF ATLEAST 1 ACCOUNT WAS PROCESSED SUCCESSFULLY IN THE            
      * ENTIRE RUN WHILE SKIP-COUNTER > 0. IF NOT ABEND THE PROGRAM.            
                                                                        
           IF WS-FCSKR100-CNTR = 0  AND                                 
              WS-SKIP-COUNTER  > 0  AND                                 
              WS-CHKP-SEQ-NO   = 0                                      
P00599        DISPLAY '********** PCSKR100 ABORT **********************'
P00599        DISPLAY '* 1000-PROCESS-INPUT                           *'
P00599        DISPLAY '* ALL THE ACCOUNTS IN THE INPUT FILE ARE       *'
P00599        DISPLAY '* SKIPPED FROM PROCESSING                      *'
P00599        DISPLAY '* ACCOUNTS PROCESSED : 'WS-PROCESS-COUNTER       
P00599        DISPLAY '* ACCOUNTS SKIPPED   : 'WS-SKIP-COUNTER          
P00599        DISPLAY '* PROCESSING TERMINATED                        *'
P00599        DISPLAY '********** PCSKR100 ABORT **********************'
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF                                                       
                                                                        
           PERFORM 0400-PREPARE-PRECOMMIT       THRU 0400-EXIT.         
                                                                        
           MOVE SPACES TO WS-RESTART-JOB-COMPLETE.                      
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-B                         TO WS-RESTART-JOB-STATUS
           ELSE                                                         
              MOVE WS-A                         TO WS-RESTART-JOB-STATUS
           END-IF.                                                      
                                                                        
           PERFORM 8888-COMMIT                  THRU 8888-EXIT.         
                                                                        
           IF WS-RESTART-REQ EQUAL WS-Y                                 
              PERFORM 8893-RESET-RESTART-REQ-PARM                       
                                                THRU 8893-EXIT          
           END-IF.                                                      
           PERFORM 8840-DELETE-RESTART-ROW      THRU 8840-EXIT.         
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              DISPLAY '** PCSKR100 RERUN COMPLETED **'                  
           ELSE                                                         
              DISPLAY '** PCSKR100 PROCESSING COMPLETED SUCCESSFULLY **'
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1010-PROCESS-FCSBE00.                                          *        
      ******************************************************************        
       1010-PROCESS-FCSBE00.                                            
                                                                        
           IF E-FBE00-KEY-BREC EQUAL HIGH-VALUES OR LOW-VALUES          
              CONTINUE                                                  
           ELSE                                                         
              MOVE E-FBE00-ACCOUNT-NO           TO AT-ACCOUNT-NO        
              PERFORM 1100-LOAD-BE00-ACCT-TO-WS THRU 1100-EXIT          
      * PROCESSING FOR EACH ACCOUNT STARTS HERE                                 
                                                                        
              MOVE WS-ACCOUNT-NO-AT             TO WS-DISPLAY-ACCOUNT   
P00599        IF WS-CODE-ACCT-STAT-AT = 'A' AND                         
P00599           WS-ACCOUNT-NO-BI > 0                                   
                 DISPLAY 'PROCESSING ACCOUNT NO: ' WS-DISPLAY-ACCOUNT   
                 PERFORM 2000-PROCESS-ACCOUNT   THRU 2000-EXIT          
              ELSE                                                      
P00599           DISPLAY WS-DISPLAY-ACCOUNT ' IS NOT AN ACTIVE ACCT  '  
P00599                                      ' OR IS MISSING BI ROW,  '  
P00599                                      ' WILL NOT BE PROCESSED. '  
              END-IF                                                    
                                                                        
           END-IF.                                                      
                                                                        
           IF WS-END-OF-BE00-SW NOT = 'Y'                               
              AND E-FBE00-ACCOUNT-NO IS NOT NUMERIC                     
              PERFORM 7700-READ-INPUT           THRU 7700-EXIT          
           END-IF.                                                      
                                                                        
       1010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1100-LOAD-BE00-ACCT-TO-WS.                                     *        
      *   1. LOAD ALL BE00 RECORDS OF AN ACCOUNT TO CWS10000 VARIABLES *        
      *      AND READ THROUGH TILL IT FINDS A DIFFERENT ACCOUNT        *        
      ******************************************************************        
       1100-LOAD-BE00-ACCT-TO-WS.                                       
                                                                        
           PERFORM 0609-INITIALIZE-FBE36-WS-AREA THRU 0609-EXIT.        
           PERFORM 0640-INITIALIZE-FBE37-WS-AREA THRU 0640-EXIT.        
           PERFORM 0690-INITIALIZE-FBE38-WS-AREA THRU 0690-EXIT.        
           PERFORM 2010-INITIALIZE-PROCESS-DATA  THRU 2010-EXIT.        
                                                                        
           MOVE E-FBE00-ACCOUNT-NO               TO WS-PREVIOUS-ACCT-NO.
                                                                        
           PERFORM 1110-LOAD-ACCT-TO-WS          THRU 1110-EXIT         
             UNTIL END-OF-BE00                                          
                 OR E-FBE00-ACCOUNT-NO NOT = WS-PREVIOUS-ACCT-NO.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1110-LOAD-ACCT-TO-WS.                                          *        
      * LOADS THE DATA INTO WORKING STORAGE TABLES BASED ON TABLE ID   *        
      ******************************************************************        
       1110-LOAD-ACCT-TO-WS.                                            
                                                                        
           MOVE E-FBE00-SORT-KEY                TO E-FBE38-SORT-KEY.    
           MOVE E-FBE00-DATA                    TO E-FBE38-DATA.        
           MOVE E-FBE00-TABLE-ID                TO WS-CWS-TABLE-ID.     
           MOVE SPACES                          TO WS-KR100-SORT-KEY.   
           MOVE E-FBE00-SORT-KEY                TO WS-KR100-SORT-KEY.   
           IF WS-CWS10000-TABLE-ID                                      
              PERFORM 0800-LOAD-FBE38-WS-AREA   THRU 0800-EXIT          
           END-IF.                                                      
           PERFORM 7700-READ-INPUT              THRU 7700-EXIT.         
                                                                        
       1110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-ACCOUNT                                           *        
      * PROCESS FOR EACH ACCOUNT                                       *        
      ******************************************************************        
       2000-PROCESS-ACCOUNT.                                            
                                                                        
           PERFORM 2100-GET-ACCOUNT-DTLS         THRU 2100-EXIT.        
           PERFORM 2450-CALL-SUB-MODULES         THRU 2450-EXIT.        
           IF PROCESS-ACCT                                              
              PERFORM 2700-GENERATE-OUTPUT       THRU 2700-EXIT         
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2010-INITIALIZE-PROCESS-DATA                                    *        
      *INITIALIZE THE VARIABLES                                        *        
      ******************************************************************        
       2010-INITIALIZE-PROCESS-DATA.                                    
                                                                        
           INITIALIZE WS-KR100-CUST-DATA                                
                      WS-ON-OFF-CYCLE-IND                               
                      AT-CODES-DATA-PRESENT                             
                      WS-BILL-CRED-DET-1H                               
                      RS-RETURN-CODE                                    
                      WS-DAY-30-UTL-RELATED-DELINQ                      
                      WS-DAY-60-UTL-RELATED-DELINQ                      
                      WS-DAY-90-UTL-RELATED-DELINQ                      
                      WS-DAY-30-NON-UTL-REL-DELINQ                      
                      WS-DAY-60-NON-UTL-REL-DELINQ                      
                      WS-DAY-90-NON-UTL-REL-DELINQ                      
                      WS-BUDGET-AMOUNT-DELINQ                           
                      WS-CURR-CNT-CHARGES                               
                      WS-CONTRACT-ARREARS                               
                      WS-TEMP-INITIAL-FL                                
                      WS-TEMP-NOT-INITIAL-FL                            
                      WS-TRANS-HIST-MH                                  
                      WS-WQ-ITEMS-MF                                    
                      WS-TRN-HST-DET-MI.                                
                                                                        
           SET PROCESS-ACCT                      TO TRUE.               
           SET NON-UTILITY-ONLY-ACCT             TO TRUE.               
           SET INSIDE-BILL-WINDOW                TO TRUE.               
           SET NOT-PRP-ACCOUNT                   TO TRUE.               
           SET NOT-BBP-ANNIVERSARY               TO TRUE.               
           SET NOT-DPP-DROP                      TO TRUE.               
           SET NOT-CNT-ACCOUNT                   TO TRUE.               
           SET NOT-DFA-ACCOUNT                   TO TRUE.               
           MOVE 'N'                              TO WS-KR100-PYMNT-PLAN.
           MOVE 1                                TO WS-MH-TRN-INDX      
                                                    WS-MI-DET-INDX      
                                                    WS-WQ-INDX.         
                                                                        
      *OUTPUT FILE INITIALIZATION                                               
           INITIALIZE FIOKR100.                                         
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2100-GET-ACCOUNT-DTLS.                                          *        
      *LOADS PROCESSING DATA FOR THE CURRENT ACCOUNT                   *        
      ******************************************************************        
       2100-GET-ACCOUNT-DTLS.                                           
                                                                        
           MOVE WS-DATABASE                      TO WS-KR100-DATABASE.  
           MOVE WS-CODE-OFF-CYCLE-CALC           TO WS-ON-OFF-CYCLE-IND.
           PERFORM 2200-LOAD-PROCESS-DATA        THRU 2200-EXIT.        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2200-LOAD-PROCESS-DATA.                                         *        
      *LOADS GENERAL PROCESSING DATA.                                  *        
      ******************************************************************        
       2200-LOAD-PROCESS-DATA.                                          
                                                                        
           MOVE WS-ACCOUNT-NO-AT                 TO WS-KR100-ACCOUNT-NO 
                                                    AT-ACCOUNT-NO.      
           PERFORM 7300-GET-CODES-DATA-PRESENT   THRU 7300-EXIT.        
           MOVE AT-CODES-DATA-PRESENT            TO                     
                                             WS-CODES-DATA-PRESENT-AT   
                                             WS-CODES-DATA-PRESENT.     
           MOVE WS-COMPANY-NO-AT                 TO WS-KR100-COMPANY-NO.
           MOVE WS-INPUT-DATE                    TO WS-KR100-BE00-DT.   
           MOVE WS-SENIOR-FL-AT                  TO WS-KR100-SENIOR-FL. 
           MOVE WS-REG-GROUP-CD-AT               TO                     
                                             WS-KR100-REG-GROUP-CD.     
           MOVE WS-DATE-EXPIRE-CA                TO                     
                                             WS-KR100-CUST-ALRT-EXP-DT. 
           MOVE WS-NEXT-BUSINESS-DAY             TO                     
                                             WS-KR100-NEXT-BUS-DAY.     
           MOVE WS-PREV-BUSINESS-DAY             TO                     
                                             WS-KR100-PREV-BUS-DAY.     
                                                                        
      * BILL NO FROM BILLING_HDR                                                
                                                                        
           MOVE WS-BILL-NO-BI                    TO WS-KR100-BILL-NO.   
                                                                        
      * BILL DT FROM BILLING_HDR                                                
                                                                        
           MOVE WS-DATE-BILLED-BI                TO WS-KR100-BILL-DT.   
                                                                        
      * SET PRP FLAGS                                                           
                                                                        
           IF SEB-DATABASE                                              
              IF WS-ACCOUNT-NO-PK(1) = WS-ACCOUNT-NO-AT                 
                 SET PRP-ACCOUNT                 TO TRUE                
                 IF PRP-FIRST-EST-BILL                                  
                    SET PRP-FIRST-BILL           TO TRUE                
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
      * SET UTILITY FLAG                                                        
                                                                        
           IF WS-ACCOUNT-NO-BG (1) = WS-ACCOUNT-NO-AT                   
              SET UTILITY-ACCT                   TO TRUE                
           END-IF.                                                      
                                                                        
      * POPULATE LATE PAY CHARGES FOR SCSKR115                                  
                                                                        
           MOVE WS-LPC-UTIL-ASSESSED-CALC        TO WS-LPC-AMT-1H.      
           MOVE WS-LPC-NONUT-ASSESSED-CALC       TO WS-LPN-AMT-1H.      
                                                                        
           PERFORM 2250-GET-BILLING-DATA         THRU 2250-EXIT.        
           PERFORM 2300-GET-ACCOUNT-DATA         THRU 2300-EXIT.        
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2250-GET-BILLING-DATA.                                          *        
      *LOADS PROCESSING DATA FROM BG / BI TABLES.                      *        
      ******************************************************************        
       2250-GET-BILLING-DATA.                                           
                                                                        
           PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1 UNTIL            
              WS-BILLING-INDX  > WS-BG-MAX-ENTRY OR                     
              WS-ACCOUNT-NO-BG (WS-BILLING-INDX) = +0                   
      *                                                                         
              IF WS-CODE-BILL-CALC-BG (WS-BILLING-INDX)     = 'A' AND   
                 WS-CODE-BILL-ITM-TYPE-BG (WS-BILLING-INDX) = 'C' AND   
                 WS-CODE-BILL-ITM-IND-BG (WS-BILLING-INDX)  = 'A'       
                                                                        
      * IDENTIFY INITIAL BILLS                                                  
      * A BILL IS CONSIDERED INITIAL ONLY WHEN PRORATE-CD IS 'I' FOR ALL        
      * SERVICES (BG ROWS)                                                      
                                                                        
                 IF WS-PRORATE-CD-BG (WS-BILLING-INDX) = 'I'            
                    MOVE WS-Y                    TO WS-TEMP-INITIAL-FL  
                 ELSE                                                   
                    MOVE WS-Y                    TO                     
                                                WS-TEMP-NOT-INITIAL-FL  
                 END-IF                                                 
                                                                        
      * FOR OFF-CYCLE-REBILL GET REV-MTH-ORIG-BILL FOR FORECASTING              
                                                                        
                 IF OFF-CYCLE-REBILL AND                                
                    WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX) > 0       
                    MOVE WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX)      
                                         TO WS-KR100-REVENUE-MONTH-ORIG 
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           IF WS-TEMP-INITIAL-FL         = WS-Y AND                     
              WS-TEMP-NOT-INITIAL-FL NOT = WS-Y                         
              SET INITIAL-BILL                   TO TRUE                
           ELSE                                                         
              SET NOT-INITIAL-BILL               TO TRUE                
           END-IF.                                                      
                                                                        
      * COMPUTE ANY REQUIRED UTL / NON-UTL CHARGES                              
                                                                        
           PERFORM 2400-COMPUTE-CHRGS            THRU 2400-EXIT         
                   VARYING WS-AR-DATA-INDX FROM 1 BY 1                  
                   UNTIL WS-AR-DATA-INDX > WS-AC-MAX-ENTRY OR           
                         WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) = ZERO.     
                                                                        
           PERFORM 2425-LOAD-AC-CHRGS            THRU 2425-EXIT.        
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2300-GET-ACCOUNT-DATA.                                          *        
      *LOADS GENERAL ACCT LEVEL DATA.                                  *        
      ******************************************************************        
       2300-GET-ACCOUNT-DATA.                                           
                                                                        
      * IDENTIFY CURRENT PAYMENT PLANS IN THE ACCOUNT.                          
                                                                        
           IF WS-ACCOUNT-NO-CT(1) = WS-ACCOUNT-NO-AT                    
              SET CNT-ACCOUNT                 TO TRUE                   
           END-IF.                                                      
                                                                        
           IF WS-CODE-BUDGET        = 'A'                               
              SET BBP-ACCOUNT                 TO TRUE                   
           END-IF.                                                      
                                                                        
           IF WS-CODE-DPP-ACCT      = 'A'                               
              SET DPP-ACCOUNT                 TO TRUE                   
           END-IF.                                                      
                                                                        
           IF WS-CODE-DFA-ACCT      = 'A'                               
              SET DFA-ACCOUNT                    TO TRUE                
           END-IF.                                                      
                                                                        
      * CHECK FOR BUDGET BILLING ANNIVERSARY                                    
                                                                        
           IF BBP-ACCOUNT                                               
              MOVE WS-ANNIVERSARY-DATE-BU        TO WS-ANNIV-DATE       
              COMPUTE WS-PREV-ANNIV-YYYY = WS-ANNIV-YYYY - 1            
              MOVE WS-ANNIV-MM                   TO WS-PREV-ANNIV-MM    
              MOVE WS-REV-MTH-LST-NRML-AT        TO WS-REV-MONTH-AT     
              IF WS-REV-MONTH-AT  = WS-PREV-ANNIV-DATE                  
                 SET BBP-ANNIVERSARY             TO TRUE                
              ELSE                                                      
                 SET NOT-BBP-ANNIVERSARY         TO TRUE                
              END-IF                                                    
           END-IF.                                                      
                                                                        
      * CHECK FOR DPP DROP                                                      
                                                                        
           PERFORM 2350-CHECK-DPP-DROP           THRU 2350-EXIT.        
                                                                        
      * CHECK IF ACCOUNT BILLED ON-CYCLE                                        
                                                                        
           PERFORM 2375-CHECK-BILL-CYCLE         THRU 2375-EXIT.        
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************       0 
      * 2350-CHECK-DPP-DROP.                                          *       0 
      * CHECKS TO SEE IF THE DPP HAS BEEN DROPPED.                    *       0 
      *****************************************************************       0 
      *                                                                       0 
       2350-CHECK-DPP-DROP.                                             
      *                                                                       0 
           SET WS-ATTR-INDX                      TO 1.                  
           SEARCH WS-ACCT-ATTR-DATA                                     
               AT END                                                   
                  SET NOT-DPP-DROP               TO TRUE                
             WHEN WS-ACCOUNT-NO-YP (WS-ATTR-INDX) = ZERO                
                  SET NOT-DPP-DROP               TO TRUE                
             WHEN WS-ATTRIBUTE-DESC-YP (WS-ATTR-INDX)= WS-AUTO-DROP-DPP 
                  AND WS-ATTRIBUTE-VALUE-CD-YP (WS-ATTR-INDX) = '1'     
                  SET FIRST-BILL-AFT-DPP-DROP    TO TRUE                
           END-SEARCH.                                                  
      *                                                                       0 
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                       0 
      *****************************************************************       0 
      * 2375-CHECK-BILL-CYCLE.                                        *       0 
      * CHECKS TO SEE IF THE ACCOUNT BILLED ON-CYCLE.                 *       0 
      *****************************************************************       0 
      *                                                                       0 
       2375-CHECK-BILL-CYCLE.                                           
      *                                                                       0 
           SET WS-BN-INDX                        TO 1.                  
           SEARCH WS-BN-BILL-WDW-DATA                                   
               AT END                                                   
                  SET OUTSIDE-BILL-WINDOW        TO TRUE                
             WHEN WS-BN-BILL-CYCLE (WS-BN-INDX) = ZERO                  
                  SET OUTSIDE-BILL-WINDOW        TO TRUE                
             WHEN WS-BN-BILL-CYCLE (WS-BN-INDX)= WS-BILL-CYCLE-AT       
                  AND WS-BN-REVENUE-MNTH (WS-BN-INDX) =                 
                                                 WS-REV-MTH-LST-NRML-AT 
                  SET INSIDE-BILL-WINDOW         TO TRUE                
           END-SEARCH.                                                  
      *                                                                       0 
       2375-EXIT.                                                       
           EXIT.                                                        
      *                                                                       0 
      ******************************************************************        
      * 2400-COMPUTE-CHRGS.                                            *        
      * COMPUTE UTL / NON-UTL CHARGES NECESSARY FOR CREDIT PROCESSES   *        
      ******************************************************************        
      *                                                                         
       2400-COMPUTE-CHRGS.                                              
      *                                                                         
           EVALUATE WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)           
               WHEN 19                                                  
               WHEN 29                                                  
               WHEN 39                                                  
               WHEN 129                                                 
                    PERFORM 5020-CALC-NON-UTL-DELINQ                    
                                                 THRU 5020-CPD339-EXIT  
               WHEN 20                                                  
               WHEN 30                                                  
               WHEN 40                                                  
               WHEN 45                                                  
               WHEN 50                                                  
               WHEN 60                                                  
               WHEN 80                                                  
               WHEN 90                                                  
               WHEN 110                                                 
                    PERFORM 5010-CALC-UTL-DELINQ THRU 5010-CPD339-EXIT  
               WHEN 100                                                 
                    SET WS-CNT-INDX TO  1                               
                    SEARCH WS-CONTRACT-DATA                             
                        AT END                                          
                           CONTINUE                                     
                      WHEN WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) =         
                           WS-ACCOUNT-NO-CT (WS-CNT-INDX)      AND      
                           WS-ITEM-ID-AC (WS-AR-DATA-INDX)    =         
                           WS-CNT-ITEM-ID-CT  (WS-CNT-INDX)             
                           PERFORM 5020-CALC-NON-UTL-DELINQ             
                              THRU 5020-CPD339-EXIT                     
                    END-SEARCH                                          
           END-EVALUATE.                                                
      *                                                                         
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************07704000
      * 2425-LOAD-AC-CHRGS.                                            *        
      * LOAD CHARGES TO THE KR100 STRUCTURE                            *        
      ******************************************************************07704000
      *                                                                 63240000
       2425-LOAD-AC-CHRGS.                                              
      *                                                                 63240000
           MOVE WS-DAY-30-UTL-RELATED-DELINQ     TO                     
                                           WS-KR100-UTL-30-DELINQ       
           MOVE WS-DAY-60-UTL-RELATED-DELINQ     TO                     
                                           WS-KR100-UTL-60-DELINQ       
           MOVE WS-DAY-90-UTL-RELATED-DELINQ     TO                     
                                           WS-KR100-UTL-90-DELINQ       
           MOVE WS-DAY-30-NON-UTL-REL-DELINQ     TO                     
                                           WS-KR100-NON-UTL-30-DELINQ   
           MOVE WS-DAY-60-NON-UTL-REL-DELINQ     TO                     
                                           WS-KR100-NON-UTL-60-DELINQ   
           MOVE WS-DAY-90-NON-UTL-REL-DELINQ     TO                     
                                           WS-KR100-NON-UTL-90-DELINQ   
           MOVE WS-BUDGET-AMOUNT-DELINQ          TO                     
                                           WS-KR100-BUDGET-DELINQ       
           MOVE WS-CURR-CNT-CHARGES              TO                     
                                           WS-KR100-CNT-CURR-CHRGS      
           MOVE WS-CONTRACT-ARREARS              TO                     
                                           WS-KR100-CNT-ARREARS         
                                                                        
           COMPUTE WS-KR100-TOTAL-30-DELINQ =  WS-KR100-UTL-30-DELINQ + 
                                           WS-KR100-NON-UTL-30-DELINQ.  
                                                                        
           COMPUTE WS-KR100-TOTAL-60-DELINQ =  WS-KR100-UTL-60-DELINQ + 
                                           WS-KR100-NON-UTL-60-DELINQ.  
                                                                        
           COMPUTE WS-KR100-TOTAL-90-DELINQ =  WS-KR100-UTL-90-DELINQ + 
                                           WS-KR100-NON-UTL-90-DELINQ.  
      *                                                                 63240000
       2425-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07704000
      * 2450-CALL-SUB-MODULES.                                         *        
      * CALLS THE CREDIT SUB-MODULES.                                  *        
      ******************************************************************07704000
      *                                                                 63240000
       2450-CALL-SUB-MODULES.                                           
      *                                                                 63240000
           PERFORM 2500-CREDIT-HISTORY-UPDATES   THRU 2500-EXIT.        
           PERFORM 2550-CREDIT-GROUP-UPDATES     THRU 2550-EXIT.        
           PERFORM 2600-CREDIT-FORECAST          THRU 2600-EXIT.        
      *                                                                 63240000
       2450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07704000
      * 2500-CREDIT-HISTORY-UPDATES.                                   *        
      * CALL CREDIT HISTORY UPDATE MODULE.                             *        
      ******************************************************************07704000
      *                                                                 63240000
       2500-CREDIT-HISTORY-UPDATES.                                     
      *                                                                 63240000
           PERFORM 5000-CALL-CREDIT-HISTORY      THRU 5000-EXIT.        
           PERFORM 2650-ERROR-CHECK              THRU 2650-EXIT.        
      *                                                                 63240000
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07704000
      * 2550-CREDIT-GROUP-UPDATES.                                     *        
      * CALL CREDIT GROUP UPDATE MODULE.                               *        
      ******************************************************************07704000
      *                                                                 63240000
       2550-CREDIT-GROUP-UPDATES.                                       
      *                                                                 63240000
           IF PROCESS-ACCT                                              
              PERFORM 5100-CALL-CREDIT-GROUP-MVMT                       
                                                 THRU 5100-EXIT         
              PERFORM 2650-ERROR-CHECK           THRU 2650-EXIT         
           END-IF.                                                      
      *                                                                 63240000
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07704000
      * 2600-CREDIT-FORECAST.                                          *        
      * CALL CREDIT FORECAST MODULE.                                   *        
      ******************************************************************07704000
      *                                                                 63240000
       2600-CREDIT-FORECAST.                                            
      *                                                                 63240000
           IF PROCESS-ACCT                                              
              PERFORM 5200-CALL-CREDIT-FORECAST  THRU 5200-EXIT         
              PERFORM 2650-ERROR-CHECK           THRU 2650-EXIT         
           END-IF.                                                      
      *                                                                 63240000
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07704000
      * 2650-ERROR-CHECK.                                              *        
      * EXCEPTION HANDLING AND WQ PROCESS                              *        
      ******************************************************************07704000
      *                                                                 63240000
       2650-ERROR-CHECK.                                                
      *                                                                 63240000
           IF RS-RETURN-CODE > 0                                        
              PERFORM 8889-ROLLBACK-TO-SAVEPOINT THRU 8889-EXIT         
              DISPLAY 'SKIPPING ACCOUNT NO: ' WS-DISPLAY-ACCOUNT        
              SET SKIP-ACCT                      TO TRUE                
              ADD +1                             TO WS-SKIP-COUNTER     
              IF WS-SKIP-COUNTER = WS-ACCTS-TO-SKIP                     
P00599           DISPLAY '********** PCSKR100 ABORT *******************'
P00599           DISPLAY '* 2650-ERROR-CHECK                          *'
P00599           DISPLAY '* SKIP-COUNTER EQUAL TO DEFAULT SKIP COUNT  *'
P00599           DISPLAY '* NO OF ACCTS SKIPPED : 'WS-SKIP-COUNTER      
P00599           DISPLAY '* DEFAULT SKIP COUNT  : 'WS-ACCTS-TO-SKIP     
P00599           DISPLAY '* PROCESSING TERMINATED                     *'
P00599           DISPLAY '********** PCSKR100 ABORT *******************'
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
      * INSERT WQ'S                                                             
              PERFORM 2900-GENERATE-WQ           THRU 2900-EXIT         
                      VARYING WS-WQ-INDX FROM 1 BY 1                    
                      UNTIL   WS-WQ-INDX  > 50 OR                       
                              WS-WQ-CATEGORY-ID-WF(WS-WQ-INDX) = ZERO   
              PERFORM 8887-SAVEPOINT             THRU 8887-EXIT         
                                                                        
           END-IF.                                                      
      *                                                                 63240000
       2650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07704000
      * 2700-GENERATE-OUTPUT.                                          *        
      * PROCESS DB2 UPDATES AND WRITE OUTPUT FILE                      *        
      ******************************************************************07704000
      *                                                                 63240000
       2700-GENERATE-OUTPUT.                                            
      *                                                                 63240000
           PERFORM 2750-WRITE-KR100-FILE         THRU 2750-EXIT.        
      * SURETY BOND EXPIRATION                                                  
           PERFORM 3500-CHECK-SECURITIES         THRU 3500-CPD340-EXIT. 
      * UPDATE TRACKING STATUS CODE                                             
           IF WS-ACCOUNT-NO-MW > 0                                      
              PERFORM 2760-UPDATE-CORR-MAIL-DATA THRU 2760-EXIT         
           END-IF.                                                      
      * UPDATE DATA TO CSS_ACCOUNT                                              
           PERFORM 2950-UPDATE-ACCOUNT-DATA      THRU 2950-EXIT.        
      * INSERT MNT TRANS HIST                                                   
           PERFORM 2800-GENERATE-TRANS-HIST      THRU 2800-EXIT.        
      * INSERT WQ'S                                                             
           PERFORM 2900-GENERATE-WQ              THRU 2900-EXIT         
                   VARYING WS-WQ-INDX FROM 1 BY 1                       
                   UNTIL WS-WQ-INDX  > 50 OR                            
                         WS-WQ-CATEGORY-ID-WF(WS-WQ-INDX) = ZERO.       
                                                                        
           ADD  +1                               TO WS-PROCESS-COUNTER. 
           IF WS-PROCESS-COUNTER = WS-READY-TO-INSERT-COUNT             
              ADD WS-PROCESS-COUNTER             TO WS-FCSKR100-CNTR    
              PERFORM 0400-PREPARE-PRECOMMIT     THRU 0400-EXIT         
              PERFORM 8888-COMMIT                THRU 8888-EXIT         
           END-IF.                                                      
           PERFORM 8887-SAVEPOINT                THRU 8887-EXIT.        
      *                                                                 63240000
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07704000
      * 2800-GENERATE-TRANS-HIST.                                      *        
      * GENERATES TRANSACTION HISTORY ROWS.                            *        
      ******************************************************************07704000
      *                                                                 63240000
       2800-GENERATE-TRANS-HIST.                                        
      *                                                                 63240000
      * INSERT MH ROWS                                                          
           PERFORM 2850-WRITE-MNT-TRANS-HIST     THRU 2850-EXIT         
                   VARYING WS-MH-TRN-INDX FROM 1 BY 1                   
                   UNTIL WS-MH-TRN-INDX  > 50 OR                        
                       WS-TRANS-HIST-SEQ-NO-MH(WS-MH-TRN-INDX) = SPACES.
                                                                        
      * INSERT MI ROWS                                                          
           PERFORM 2875-WRITE-MNT-TRANS-HIST-DET THRU 2875-EXIT         
                   VARYING WS-MI-DET-INDX FROM 1 BY 1                   
                   UNTIL WS-MI-DET-INDX  > 50 OR                        
                       WS-TRANS-HIST-SEQ-NO-MI(WS-MI-DET-INDX) = SPACES.
                                                                        
      *                                                                 63240000
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07704000
      * 2750-WRITE-KR100-FILE.                                         *        
      * LOAD DATA INTO OUTPUT FILE LAYOUT.                             *        
      ******************************************************************07704000
      *                                                                 63240000
       2750-WRITE-KR100-FILE.                                           
      *                                                                 63240000
           MOVE WS-KR100-SORT-KEY                TO E-KR100-SORT-KEY.   
           MOVE KR100-TABLE-ID                   TO E-KR100-TABLE-ID.   
           MOVE WS-BILL-CRED-DET-1H              TO E-KR100-DATA.       
           MOVE ZERO                             TO E-KR100-SORT-SUM-FLD
           PERFORM 8000-WRITE-FCSKR100           THRU 8000-EXIT.        
      *                                                                 63240000
       2750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 2760-UPDATE-CORR-MAIL-DATA                                              
      ***************************************************************           
      *                                                                         
       2760-UPDATE-CORR-MAIL-DATA.                                      
      *                                                                         
           MOVE WS-ACCOUNT-NO-MW               TO MW-ACCOUNT-NO         
           MOVE WS-BARCODE-UNIQUE-ID-MW        TO MW-BARCODE-UNIQUE-ID  
           MOVE WS-TRACKING-STATUS-CD-MW       TO MW-TRACKING-STATUS-CD.
           MOVE 'C'                            TO                       
                                             MW-TRACKING-STATUS-CD(1:1).
           MOVE WS-SYSTEM                      TO MW-USER-ID.           
           MOVE WS-PGRMNAME                    TO MW-APPL-PROGRAM-ID    
           PERFORM 8200-UPDATE-CORR-MAIL-STAT  THRU 8200-EXIT.          
      *                                                                         
       2760-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************07704000
      * 2850-WRITE-MNT-TRANS-HIST.                                     *        
      * INSERTS ANY MNT TRANS HIST TO DB2                              *        
      ******************************************************************07704000
      *                                                                 63240000
       2850-WRITE-MNT-TRANS-HIST.                                       
      *                                                                 63240000
           MOVE WS-TRANS-HIST-SEQ-NO-MH(WS-MH-TRN-INDX)                 
                                                 TO                     
                                                MH-TRANS-HIST-SEQ-NO.   
           MOVE WS-DATE-TRANS-MH(WS-MH-TRN-INDX) TO MH-DATE-TRANS.      
           MOVE WS-CODE-TRAN-TYPE-MH(WS-MH-TRN-INDX)                    
                                                 TO                     
                                                MH-CODE-TRAN-TYPE.      
           MOVE ZEROS                            TO MH-PREMISE-NO       
                                                    MH-CUSTOMER-NO.     
           MOVE SPACES                           TO MH-RESP-AREA-ID     
                                                MH-TRAN-COMMENT-TEXT.   
           MOVE WS-ACCOUNT-NO-AT                 TO MH-ACCOUNT-NO.      
           MOVE WS-USER-ID-MH(WS-MH-TRN-INDX)    TO MH-USER-ID.         
           MOVE WS-APPL-PROGRAM-ID-MH(WS-MH-TRN-INDX)                   
                                                 TO                     
                                                MH-APPL-PROGRAM-ID.     
           MOVE WS-TRAN-COMMENT-LEN-MH(WS-MH-TRN-INDX)                  
                                                 TO                     
                                                MH-TRAN-COMMENT-LEN.    
           MOVE WS-TRAN-COMMENT-TEXT-MH(WS-MH-TRN-INDX)                 
                                                 TO                     
                                                MH-TRAN-COMMENT-TEXT.   
           PERFORM 6540-INSERT-MNT-TRANS-HIST    THRU 6540-EXIT.        
                                                                        
      *                                                                 63240000
       2850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07704000
      * 2875-WRITE-MNT-TRANS-HIST-DET.                                 *        
      * INSERTS ANY MNT TRANS HIST DET TO DB2                          *        
      ******************************************************************07704000
      *                                                                 63240000
       2875-WRITE-MNT-TRANS-HIST-DET.                                   
      *                                                                 63240000
           MOVE WS-TRANS-HIST-SEQ-NO-MI(WS-MI-DET-INDX)                 
                                                 TO                     
                                                MI-TRANS-HIST-SEQ-NO.   
           MOVE WS-TRAN-APPL-NO-MI(WS-MI-DET-INDX)                      
                                                 TO                     
                                                MI-TRAN-APPL-NO.        
           MOVE WS-TABLE-ID-MI(WS-MI-DET-INDX)   TO MI-TABLE-ID.        
           MOVE WS-COLUMN-DESC-MI(WS-MI-DET-INDX)                       
                                                 TO                     
                                                MI-COLUMN-DESC.         
           MOVE WS-CHG-COLUMN-LEN-MI(WS-MI-DET-INDX)                    
                                                 TO                     
                                                MI-CHG-COLUMN-VALUE-LEN.
           MOVE WS-CHG-COLUMN-TEXT-MI(WS-MI-DET-INDX)                   
                                                 TO                     
                                                MI-CHG-COLUMN-VALUE-TEXT
           MOVE WS-PRV-COLUMN-LEN-MI(WS-MI-DET-INDX)                    
                                                 TO                     
                                                MI-PRV-COLUMN-VALUE-LEN.
           MOVE WS-PRV-COLUMN-TEXT-MI(WS-MI-DET-INDX)                   
                                                 TO                     
                                                MI-PRV-COLUMN-VALUE-TEXT
           PERFORM 6550-INSERT-MT-TRN-HST-DET    THRU 6550-EXIT.        
                                                                        
      *                                                                 63240000
       2875-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07704000
      * 2900-GENERATE-WQ.                                              *        
      * INSERTS ANY WQ'S TO DB2.                                       *        
      ******************************************************************07704000
      *                                                                 63240000
       2900-GENERATE-WQ.                                                
      *                                                                 63240000
ACT052     INITIALIZE CWS00077-FIELDS.                                  
ACT052     INITIALIZE WS-77-COMMENTS.                                   
ACT052                                                                  
           MOVE WS-WQ-CATEGORY-ID-WF (WS-WQ-INDX)                       
ACT052                                           TO WS-77-CATEGORY-ID   
ACT052     MOVE WS-WQ-PRIORITY-WF (WS-WQ-INDX)   TO WS-77-PRIORITY      
           MOVE WS-WQ-ROUTE-CATEGORY-WF (WS-WQ-INDX)                    
ACT052                                           TO WS-77-ROUTE-CATEGORY
ACT052     MOVE WS-WQ-COMMENTS-WF (WS-WQ-INDX)   TO WS-77-COMMENTS      
ACT052     MOVE ZERO                             TO WS-77-SERV-ORDER-NO 
ACT052     MOVE WS-INPUT-DATE                    TO WS-77-DATE-REQUIRED 
ACT052                                           WS-INPUT-DATE-26(1:10) 
ACT052     MOVE WS-INPUT-ZERO                    TO                     
ACT052                                           WS-INPUT-DATE-26(11:16)
ACT052     MOVE WS-INPUT-DATE-26                 TO WS-77-DATE-CREATED  
ACT052     MOVE WS-ACCOUNT-NO-AT                 TO WS-77-ACCOUNT-NO    
ACT052     MOVE WS-PREMISE-NO-AT                 TO WS-77-PREMISE-NO    
ACT052     MOVE WS-CUSTOMER-NO-AT                TO WS-77-CUSTOMER-NO   
ACT052     MOVE SPACES                           TO WS-77-USER-ID-ORIG  
ACT052     MOVE SPACES                           TO WS-77-RESP-AREA-ID  
ACT052     MOVE WS-LOCAL-OFFICE-AT               TO WS-77-LOCAL-OFFICE  
           MOVE ZERO                             TO                     
ACT052                                          WS-77-FREE-FORM-LEN     
           MOVE LOW-VALUES                       TO                     
ACT052                                          WS-77-FREE-FORM-TXT     
ACT052     IF WS-WQ-CREATED-BY-WF (WS-WQ-INDX) > SPACES                 
ACT052        MOVE WS-WQ-CREATED-BY-WF (WS-WQ-INDX)                     
ACT052                                TO WS-77-CREATED-BY               
ACT052     ELSE                                                         
ACT052          MOVE WS-PGRMNAME      TO WS-77-CREATED-BY               
ACT052     END-IF                                                       
           DISPLAY '   ' WS-WQ-COMMENTS-WF (WS-WQ-INDX)                 
           PERFORM 8895-INSERT-WORK-QUEUE        THRU 8895-EXIT.        
                                                                        
      *                                                                 63240000
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07704000
      * 2950-UPDATE-ACCOUNT-DATA.                                      *        
      * UPDATES DATA IN CSS_ACCOUNT                                    *        
      ******************************************************************07704000
      *                                                                 63240000
       2950-UPDATE-ACCOUNT-DATA.                                        
      *                                                                 63240000
           MOVE WS-ACCOUNT-NO-AT                 TO AT-ACCOUNT-NO       
           MOVE WS-CODE-ACCT-STAT-AT             TO AT-CODE-ACCT-STAT.  
           MOVE WS-CODE-LPC-XMT-AT               TO AT-CODE-LPC-XMT.    
           MOVE WS-CODE-DISC-OK-AT               TO AT-CODE-DISC-OK.    
           MOVE WS-NOTICE-EXEMPT-CD-AT           TO AT-NOTICE-EXEMPT-CD.
           MOVE WS-IVR-EXEMPT-CD-AT              TO AT-IVR-EXEMPT-CD.   
           MOVE WS-CREDIT-GROUP-AT               TO AT-CREDIT-GROUP.    
           MOVE WS-CREDIT-STATUS-CODE-AT         TO                     
                                                 AT-CREDIT-STATUS-CODE. 
           MOVE WS-CODES-DATA-PRESENT-AT         TO                     
                                                 AT-CODES-DATA-PRESENT. 
           PERFORM 8100-UPDATE-ACCOUNT           THRU 8100-EXIT.        
      *                                                                 63240000
       2950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *5000-CALL-CREDIT-HISTORY.                                      *         
      *CALL SCSKR110 FOR CREDIT HISTORY UPDATES                       *         
      *****************************************************************         
       5000-CALL-CREDIT-HISTORY.                                        
                                                                        
           DISPLAY 'CALLING SCSKR110'.                                  
           CALL SCSKR110 USING   WS-KR100-CUST-DATA                     
                                 WS-ACCOUNT-AT                          
                                 WS-CREDIT-PROFILE-CZ                   
                                 WS-ACCT-ATTRIBUTE-YP                   
                                 WS-CONTRACT-CT                         
                                 WS-AR-CNTRL-AC                         
                                 WS-DFA-ACCT-DA                         
                                 WS-TRANS-HIST-MH                       
                                 WS-TRN-HST-DET-MI                      
                                 WS-WQ-ITEMS-MF                         
                                 WS-CWS1000B-MAX-TBL-LIMITS             
                                 RS-RETURN-CODE.                        
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *5100-CALL-CREDIT-GROUP-MVMT.                                   *         
      *CALL SCSKR111 FOR CREDIT GROUP MOVEMENTS                       *         
      *****************************************************************         
       5100-CALL-CREDIT-GROUP-MVMT.                                     
                                                                        
           DISPLAY 'CALLING SCSKR111'.                                  
           CALL SCSKR111 USING   WS-KR100-CUST-DATA                     
                                 WS-ACCOUNT-AT                          
                                 WS-CREDIT-PROFILE-CZ                   
                                 WS-TRANS-HIST-MH                       
                                 WS-TRN-HST-DET-MI                      
                                 WS-WQ-ITEMS-MF                         
                                 WS-CWS1000B-MAX-TBL-LIMITS             
                                 RS-RETURN-CODE.                        
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *****************************************************************         
      *5200-CALL-CREDIT-FORECAST.                                     *         
      *CALL SCSKR115 FOR CREDIT FORECASTING.                          *         
      *****************************************************************         
       5200-CALL-CREDIT-FORECAST.                                       
                                                                        
           DISPLAY 'CALLING SCSKR115'.                                  
           CALL SCSKR115 USING   WS-KR100-CUST-DATA                     
                                 WS-ACCOUNT-AT                          
                                 WS-AR-CNTRL-AC                         
                                 WS-CREDIT-PROFILE-CZ                   
                                 WS-ACCT-ATTRIBUTE-YP                   
                                 WS-TRANS-HIST-MH                       
                                 WS-TRN-HST-DET-MI                      
                                 WS-WQ-ITEMS-MF                         
                                 WS-BILL-CRED-DET-1H                    
                                 WS-CWS1000B-MAX-TBL-LIMITS             
                                 RS-RETURN-CODE.                        
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3505-CHECK-SURETY-BOND                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00340                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 5010-CALC-UTL-DELINQ                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00339                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00037                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6253-GET-FJC01-CHKP-LIMIT.                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00034                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6240-GET-FCA00-COMMON-DATE                                     *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00040                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6540-INSERT-MNT-TRANS-HIST.                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6500-GET-NEXT-BUSINESS-DAY                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00322                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7620-START-FCSCA00                                             *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00039                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 8895-INSERT-WORK-QUEUE                                         *        
      ******************************************************************        
      *                                                                         
ACT052 8895-INSERT-WORK-QUEUE.                                          
ACT052*                                                                         
ACT052     MOVE SPACES                       TO ABEND-FUNCTION.         
ACT052     CALL SCSCB077  USING   CWS00077-FIELDS,                      
ACT052                            ABEND-FILE,                           
ACT052                            RS-RETURN-CODE.                       
ACT052                                                                  
ACT052      MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE.  
ACT052                                                                  
ACT052      IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0        
ACT052         MOVE PROGRAM-NAME             TO   ABEND-PROGRAM         
ACT052         DISPLAY '8895-INSERT-WORK-QUEUE'                         
ACT052         DISPLAY 'CALL SCSCB077         '                         
ACT052         DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO              
ACT052         DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO              
ACT052         DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO           
ACT052         DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE         
ACT052         PERFORM 9900-ABEND             THRU 9900-EXIT            
ACT052     END-IF.                                                      
ACT052*                                                                         
ACT052 8895-EXIT.                                                       
ACT052     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7000-SELECT-DELINQ-VALUE                                       *        
      * SELECTS THE DELINQUENCY VALUE FOR THE GIVEN DELINQ CODE        *        
      ******************************************************************        
       7000-SELECT-DELINQ-VALUE.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY                                    
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR100 ABORT **************'        
              DISPLAY '* 7000-SELECT-DELINQ-VALUE             *'        
              DISPLAY '* DELINQ CD ', C8-DELINQ-CD                      
              DISPLAY '* COMPANY NO', C8-COMPANY-NO                     
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSKR100 ABORT **************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7050-SELECT-RESTART.                                            *        
      * THIS PARAGRAPH SELECTS A RESTART RECORD FROM CSS_RESTART       *        
      ******************************************************************        
       7050-SELECT-RESTART.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT RESTART_DATA                                       
                INTO :RF-RESTART-DATA                                   
                FROM CSS_RESTART                                        
               WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                    
                 AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                    
                 AND PARTITION_NO = :RF-PARTITION-NO                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESTART_DATA                                               
MFA-TR*         INTO :RF-RESTART-DATA                                           
MFA-TR*         FROM CSS_RESTART                                                
MFA-TR*        WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                            
MFA-TR*          AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                            
MFA-TR*          AND PARTITION_NO = :RF-PARTITION-NO                            
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '********** PCSKR100 ABORT **************'        
              DISPLAY '*    ERROR IN 7050-SELECT-RESTART      *'        
              DISPLAY '* NAME PROGRAM', RF-NAME-PROGRAM                 
              DISPLAY '* DUP CNTRL NO', RF-DUP-CNTRL-NO                 
              DISPLAY '* PARTITION NO', RF-PARTITION-NO                 
              DISPLAY '* SQL CODE IS '  WS-ACTIVE-RETURN-CODE           
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSKR100 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-OPEN-BILL-WINDOW                                          *        
      * OPENS BILL WINDOW CURSOR                                       *        
      ******************************************************************        
       7100-OPEN-BILL-WINDOW.                                           
                                                                        
           EXEC SQL                                                     
              OPEN BILL_WINDOW                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSKR100 ABORT  ************'         
              DISPLAY '* 7100-OPEN-BILL-WINDOW               *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSKR100 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7110-FETCH-BILL-WINDOW                                         *        
      * FETCH BILL_WINDOW CURSOR                                       *        
      ******************************************************************        
       7110-FETCH-BILL-WINDOW.                                          

MSQ008     MOVE 20 TO MSQ008-BILL-WINDOW
                                                                        
           EXEC SQL                                                     
              FOR :MSQ008-BILL-WINDOW
              FETCH 
              FROM BILL_WINDOW                        
                                                             
               INTO  :WS-BN-BILL-CYCLE-ARR                              
                    ,:WS-BN-REVENUE-MNTH-ARR                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH NEXT ROWSET FROM BILL_WINDOW                                
MFA-TR*         FOR 20 ROWS                                                     
MFA-TR*        INTO  :WS-BN-BILL-CYCLE-ARR                                      
MFA-TR*             ,:WS-BN-REVENUE-MNTH-ARR                                    
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-BILL-WINDOW
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF SQLERRD (3) > 0                                        
                 MOVE SQLERRD (3)         TO WS-ORDER-ROW-COUNT         
              ELSE                                                      
                 MOVE 0                   TO WS-ORDER-ROW-COUNT         
              END-IF                                                    
              ADD WS-ORDER-ROW-COUNT      TO WS-C8-COUNT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = +354                           
                                                                        
                 EXEC SQL                                               
MSQ012              GET DIAGNOSTICS :MFA-GD-ROW-COUNT = ROW_COUNT     
MSQ012                              ,:MFA-GD-NUMBER        = NUMBER       
                 END-EXEC                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*          EXEC SQL                                                       
MFA-TR*             GET DIAGNOSTICS :WS-ORDER-ROW-COUNT = ROW_COUNT             
MFA-TR*                             ,:WS-NUM-COND        = NUMBER               
MFA-TR*          END-EXEC                                                       
MSQ012           MOVE MFA-GD-ROW-COUNT TO WS-ORDER-ROW-COUNT
MSQ012           MOVE MFA-GD-NUMBER TO WS-NUM-COND
                                                                        
                 DISPLAY '********** PCSKR100 ABORT  ************'      
                 DISPLAY '* 7110-FETCH-BILL-WINDOW              *'      
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* ROWCOUNT ' SQLERRD(3)                       
                 DISPLAY '* NUM_COND '  WS-NUM-COND                     
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSKR100 ABORT  ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              ELSE                                                      
                 DISPLAY '********** PCSKR100 ABORT  ************'      
                 DISPLAY '* 7110-FETCH-BILL-WINDOW              *'      
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSKR100 ABORT  ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7120-CLOSE-BILL-WINDOW.                                        *        
      * CLOSE BILL_WINDOW CURSOR                                       *        
      ******************************************************************        
       7120-CLOSE-BILL-WINDOW.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE BILL_WINDOW                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSKR100 ABORT  ************'         
              DISPLAY '* 7120-CLOSE-BILL-WINDOW              *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSKR100 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7250-COMPUTE-DATES                                             *        
      * COMPUTES PROCESSING DATES                                      *        
      ******************************************************************        
       7250-COMPUTE-DATES.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -(:WS-NO-OF-DAY), IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) ) )
            INTO
              :WS-WORK-DATE                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-WORK-DATE = DATE(:WS-INPUT-DATE) -                        
MFA-TR*                           (:WS-NO-OF-DAY) DAYS                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR100 ABORT **************'        
              DISPLAY '* 7250-COMPUTE-DATES                   *'        
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSKR100 ABORT **************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-GET-CODES-DATA-PRESENT.                                   *        
      * GETS CODES DATA PRESENT FROM AT                                *        
      ******************************************************************        
       7300-GET-CODES-DATA-PRESENT.                                     
      *                                                                         
           EXEC SQL                                                     
              SELECT AT.CODES_DATA_PRESENT                              
                     INTO :AT-CODES-DATA-PRESENT                        
                FROM CSS_ACCOUNT AT                                     
               WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.CODES_DATA_PRESENT                                      
MFA-TR*              INTO :AT-CODES-DATA-PRESENT                                
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR100 ABORT **************'        
              DISPLAY '* 7300-GET-CODES-DATA-PRESENT          *'        
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSKR100 ABORT **************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CPD00038                                                       *        
      * 7600-START-FCSJC01                                             *        
      * 7610-READ-FCSJC01                                              *        
      * 7611-CLOSE                                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ******************************************************************        
      *      READS FCSBE00 FILE FOR INPUT                              *        
      ******************************************************************        
       7700-READ-INPUT.                                                 
                                                                        
           READ FCSBE00-FILE AT END                                     
               MOVE 'Y' TO WS-END-OF-BE00-SW                            
               GO TO 7700-EXIT.                                         
                                                                        
           IF FCSBE00-SUCCESSFUL                                        
              IF E-FBE00-KEY-BREC NOT EQUAL HIGH-VALUES                 
               OR E-FBE00-KEY-BREC NOT EQUAL LOW-VALUES                 
                 IF DATA-RECORD-FOUND                                   
                    ADD 1 TO WS-FCSBE00-REC-CNTR                        
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSKR100 ABORT **************'        
              DISPLAY '*     READ ERROR : BE00 FILE           *'        
              DISPLAY '* CURRENT PARA   : 7700                *'        
              DISPLAY '* FILE-STATUS    : ' WS-FBE00-STATUS             
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSKR100 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *      READS FCSKR100 FILE FOR RESTARTS                          *        
      ******************************************************************        
       7750-READ-RESTART-FILE.                                          
                                                                        
           READ FCSKR10R-FILE AT END                                    
               MOVE 'Y' TO WS-END-OF-FILE-SW                            
               GO TO 7750-EXIT.                                         
                                                                        
           IF FCSKR10R-SUCCESSFUL                                       
              ADD 1                             TO WS-FCSKR10R-CNTR     
           ELSE                                                         
              DISPLAY '********** PCSKR100 ABORT **************'        
              DISPLAY '*     READ ERROR : KR10R FILE          *'        
              DISPLAY '* CURRENT PARA   : 7750                *'        
              DISPLAY '* FILE-STATUS    : ' WS-FCSKR10R-STATUS          
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSKR100 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   0800-LOAD-FBE38-WS-AREA                                      *        
      ******************************************************************        
        COPY CPD0050B.                                                          
                                                                        
      ******************************************************************        
      * 8000-WRITE-FCSKR100                                            *        
      * WRITES OUTPUT FILE - FCSKR100                                  *        
      ******************************************************************        
       8000-WRITE-FCSKR100.                                             
                                                                        
           WRITE FIOKR100.                                              
                                                                        
           IF FCSKR100-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR100 ABORT **************'        
              DISPLAY '*     WRITE ERROR : FCSKR100-FILE      *'        
              DISPLAY '* CURRENT PARA   : 8000                *'        
              DISPLAY '* FILE-STATUS    : ' WS-FCSKR100-STATUS          
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSKR100 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100-UPDATE-ACCOUNT.                                           *        
      * UPDATE CSS_ACCOUNT                                             *        
      ******************************************************************        
       8100-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET CODE_LPC_XMT       = :AT-CODE-LPC-XMT              
                    ,CODE_DISC_OK       = :AT-CODE-DISC-OK              
                    ,NOTICE_EXEMPT_CD   = :AT-NOTICE-EXEMPT-CD          
                    ,IVR_EXEMPT_CD      = :AT-IVR-EXEMPT-CD             
                    ,CREDIT_GROUP       = :AT-CREDIT-GROUP              
                    ,CREDIT_STATUS_CODE = :AT-CREDIT-STATUS-CODE        
                    ,CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT        
                    ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
               WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*          SET CODE_LPC_XMT       = :AT-CODE-LPC-XMT                      
MFA-TR*             ,CODE_DISC_OK       = :AT-CODE-DISC-OK                      
MFA-TR*             ,NOTICE_EXEMPT_CD   = :AT-NOTICE-EXEMPT-CD                  
MFA-TR*             ,IVR_EXEMPT_CD      = :AT-IVR-EXEMPT-CD                     
MFA-TR*             ,CREDIT_GROUP       = :AT-CREDIT-GROUP                      
MFA-TR*             ,CREDIT_STATUS_CODE = :AT-CREDIT-STATUS-CODE                
MFA-TR*             ,CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT                
MFA-TR*             ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*        WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                        
MFA-TR*        QUERYNO 8100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR100 ABORT **********************'
              DISPLAY '* 8100-UPDATE-ACCOUNT                          *'
              DISPLAY '* ACCOUNT NO        : ' AT-ACCOUNT-NO            
              DISPLAY '* COMPANY NO        : ' AT-COMPANY-NO            
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR100 ABORT **********************'
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8200-UPDATE-CORR-MAIL-STAT.                                 *           
      *****************************************************************         
      *                                                                         
       8200-UPDATE-CORR-MAIL-STAT.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CORR_MAIL_STAT                                 
                 SET TRACKING_STATUS_CD = :MW-TRACKING-STATUS-CD        
                    ,USER_ID            = :MW-USER-ID                   
                    ,APPL_PROGRAM_ID    = :MW-APPL-PROGRAM-ID           
                    ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
               WHERE ACCOUNT_NO         = :MW-ACCOUNT-NO                
                 AND BARCODE_UNIQUE_ID  = :MW-BARCODE-UNIQUE-ID         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CORR_MAIL_STAT                                         
MFA-TR*          SET TRACKING_STATUS_CD = :MW-TRACKING-STATUS-CD                
MFA-TR*             ,USER_ID            = :MW-USER-ID                           
MFA-TR*             ,APPL_PROGRAM_ID    = :MW-APPL-PROGRAM-ID                   
MFA-TR*             ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*        WHERE ACCOUNT_NO         = :MW-ACCOUNT-NO                        
MFA-TR*          AND BARCODE_UNIQUE_ID  = :MW-BARCODE-UNIQUE-ID                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR100 ABORT **********************'
              DISPLAY '* 8200-UPDATE-CORR-MAIL-STAT                   *'
              DISPLAY '* ACCOUNT NO        : ' MW-ACCOUNT-NO            
              DISPLAY '* BARCODE UNIQUE ID : ' MW-BARCODE-UNIQUE-ID     
              DISPLAY '* TRACKING STATUS CD: ' MW-TRACKING-STATUS-CD    
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** PCSKR100 ABORT **********************'
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ******************************************************************        
      * 8800-WRITE-RESTART                                             *        
      ******************************************************************        
       8800-WRITE-RESTART.                                              
                                                                        
           MOVE WS-PGRMNAME                     TO RF-NAME-PROGRAM.     
           MOVE 1                               TO RF-PARTITION-NO.     
           MOVE 1                               TO RF-DUP-CNTRL-NO.     
           MOVE WS-RESTART-DATA                 TO RF-RESTART-DATA-TEXT.
           MOVE WS-RESTART-DATA-LENGTH          TO RF-RESTART-DATA-LEN. 
                                                                        
           PERFORM 8850-UPDATE-RESTART          THRU 8850-EXIT.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8860-INSERT-RESTART       THRU 8860-EXIT          
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 8840-DELETE-RESTART-ROW.                                      *         
      *****************************************************************         
       8840-DELETE-RESTART-ROW.                                         
      *                                                                         
           MOVE WS-PGRMNAME            TO RF-NAME-PROGRAM.              
           MOVE 1                      TO RF-PARTITION-NO.              
           MOVE 1                      TO RF-DUP-CNTRL-NO.              
           EXEC SQL                                                     
               DELETE FROM CSS_RESTART                                  
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR100 ABORT **************'        
              DISPLAY '*** ERROR IN 8840-DELETE-RESTART-ROW ***'        
              DISPLAY '* NAME_PROGRAM   : ' RF-NAME-PROGRAM             
              DISPLAY '* DUP_CNTRL_NO   : ' RF-DUP-CNTRL-NO             
              DISPLAY '* PARTITION_NO   : ' RF-PARTITION-NO             
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '***       PROCESSING TERMINATED      ***'        
              DISPLAY '********** PCSKR100 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
       8840-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8850-UPDATE-RESTART.                                           *        
      ******************************************************************        
       8850-UPDATE-RESTART.                                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO  WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR100 ABORT **************'        
              DISPLAY '*        8850-UPDATE-RESTART           *'        
              DISPLAY '* NAME_PROGRAM   : ' RF-NAME-PROGRAM             
              DISPLAY '* DUP_CNTRL_NO   : ' RF-DUP-CNTRL-NO             
              DISPLAY '* PARTITION_NO   : ' RF-PARTITION-NO             
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSKR100 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8860-INSERT-RESTART.                                           *        
      ******************************************************************        
       8860-INSERT-RESTART.                                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                     ( NAME_PROGRAM                                     
                      ,PARTITION_NO                                     
                      ,DUP_CNTRL_NO                                     
                      ,RESTART_DATA)                                    
               VALUES(:RF-NAME-PROGRAM                                  
                     ,:RF-PARTITION-NO                                  
                     ,:RF-DUP-CNTRL-NO                                  
                     ,:RF-RESTART-DATA)                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO  WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSKR100 ABORT **************'        
              DISPLAY '*       8860-INSERT-RESTART            *'        
              DISPLAY '* NAME_PROGRAM   : ' RF-NAME-PROGRAM             
              DISPLAY '* DUP_CNTRL_NO   : ' RF-DUP-CNTRL-NO             
              DISPLAY '* PARTITION_NO   : ' RF-PARTITION-NO             
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSKR100 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8860-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8887-SAVEPOINT.                                                *        
      ******************************************************************        
       8887-SAVEPOINT.                                                  
                                                                        
           EXEC SQL                                                     
              SAVE TRANSACTION CURRENT_WORK         
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ010
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SAVEPOINT CURRENT_WORK ON ROLLBACK RETAIN CURSORS                 
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
      *                                                                         
       8887-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8888-COMMIT.                                                   *        
      ******************************************************************        
       8888-COMMIT.                                                     
                                                                        
           PERFORM 8800-WRITE-RESTART        THRU 8800-EXIT.            
                                                                        
           MOVE 0                            TO WS-PROCESS-COUNTER.     
           ADD 1                             TO WS-CHKP-SEQ-NO.         
           EXEC SQL                                                     
              COMMIT                                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.'.          
      *                                                                         
       8888-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8889-ROLLBACK-TO-SAVEPOINT.                                    *        
      ******************************************************************        
       8889-ROLLBACK-TO-SAVEPOINT.                                      
                                                                        
           EXEC SQL                                                     
              CALL CIS.ROLLBACK_SAVEPOINT('CURRENT_WORK')                       
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ010
MFA-TR*    EXEC SQL                                                             
MFA-TR*       ROLLBACK TO SAVEPOINT CURRENT_WORK                                
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
      *                                                                         
       8889-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8893-RESET-RESTART-REQ-PARM                                    *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00029                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK             *          
      ****************************************************************          
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
      *                                                                         
      ******************************************************************        
      * 9000-TERMINATE.                                                *        
      ******************************************************************        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSBE00-FILE                                           
                 FCSKR100-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *************************                                                 
      *  9700-PROCESS-ABEND  **                                                 
      *************************                                                 
      *                                                                         
       COPY CPD0023B.                                                           
      *                                                                         
      ****************************************************************          
      *   9900-SQL-ERROR-ROUTINE                                     *          
      ****************************************************************          
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                         
           MOVE SQLCODE                TO WS-DISPLAY-SQLCODE.           
           DISPLAY ' '                                                  
           DISPLAY '**********************************************'     
           DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
           DISPLAY '**********************************************'     
           DISPLAY ' '                                                  
           DISPLAY 'SQLCODE = ' WS-DISPLAY-SQLCODE                      
           DISPLAY ABEND-RECORD-1-DATA                                  
           DISPLAY ABEND-RECORD-2-DATA                                  
           DISPLAY ABEND-RECORD-3-DATA                                  
           DISPLAY '* PROCESSING TERMINATED                           *'
           PERFORM 9900-ABEND                       THRU 9900-EXIT.     
                                                                        
      ******************************************************************        
      * 9900-ABEND                                                     *        
      * COPYBOOK FOR ABEND/ERROR PROCESSING                            *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD09900                                                
           END-EXEC.                                                            
                                                                        
      *                                                                         
