       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSKR095.                                            
       AUTHOR. RB19957.                                                 
       DATE-WRITTEN. AUG 2012.                                          
      ******************************************************************        
      **               SOUTH CAROLINA ELECTRIC & GAS                  **        
      **                      COBOL-DB2                               **        
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      **                     ---------------                          **        
      ** AS A PART OF THE CREDIT SIMPLIFICATION PROJECT, THE FINAL    **        
      ** BILL GUARANTEED PROCESS HAS BEEN TAKEN FROM PCSCA130 AND     **        
      ** PUT INTO A SINGLE PROGRAM WITH ALL THE LOGIC NEEDED TO PUT   **        
      ** DATA IN THE OFF-CYCLE-ACCT TABLE AND ALSO FOR PCSKR300 TO    **        
      ** PRINT THE NOTICES.                                           **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 2999     OUTPUT PROCESS CONTROL PATH           **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **              PROGRAM  MODIFICATION  LOG                      **        
      ******************************************************************        
      ** DATE     USERID   REASON                                     **        
      ** -------- -------  ------                                     **        
P00599** 08/10/12 RB19957  INITIAL IMPLEMENTATION.                    **        
A04860** 09/22/14 AS7C117  REPLACE CSS_WQ_ITEMS_MF WITH               **        
A04860**          ACT044   CSS_WQ_ITEMS.                              **        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSKR095'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                      PIC X(40)  VALUE                
                           'WORKING STORAGE FOR PCSKR095 STARTS HERE'.  
      *                                                                         
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME               PIC X(08)  VALUE 'PCSKR095'.    
A04860    05 SCSCB077                   PIC X(08)  VALUE 'SCSCB077'.    
          05 WS-PGRMNAME                PIC X(10)  VALUE 'PCSKR095'.    
          05 WS-Y                       PIC X(01)  VALUE 'Y'.           
          05 WS-N                       PIC X(01)  VALUE 'N'.           
          05 WS-E                       PIC X(01)  VALUE 'E'.           
          05 WS-FINAL-BILL              PIC X(1)   VALUE 'B'.           
          05 WS-WRITE-OFF               PIC X(1)   VALUE 'S'.           
          05 WS-G                       PIC X(01)  VALUE 'G'.           
          05 WS-CANCELLED               PIC X      VALUE 'C'.           
          05 WS-GUAR-FB-AMT-PAID-MSG    PIC X(20) VALUE                 
                           'FINAL BILL AMT PAID.'.                      
          05  WS-GUAR-MSG-FB            PIC X(19) VALUE                 
                           'GUARANTOR FINALLED('.                       
          05  WS-GUAR-MSG-WO            PIC X(19) VALUE                 
                           'GUARANTOR WRITEOFF('.                       
      *                                                                         
       01 WS-MISC.                                                      
          05  WS-DISPLAY-SQLCODE        PIC -ZZZZZZZZ9.                 
          05  WS-GUAR-XFER-MIN-LIMIT    PIC S9(05)     COMP-3 VALUE +0. 
          05  WS-WQ-CATEGORY            PIC 9(04)      VALUE ZERO.      
          05  WS-PROGRAM-DATE           PIC X(10).                      
          05  WS-FW-ACTION-AM           PIC S9(9)V9(2) COMP-3 VALUE +0. 
COB305    05 WS-GUAR-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.    
          05  WS-GUARANTOR-XFER-DT      PIC X(10)      VALUE SPACES.    
          05  WS-GUARANTOR-XFER-AM      PIC S9(9)V9(2) COMP-3 VALUE +0. 
A04860    05  WS-DATE-CREATED-TS.                                       
A04860        10  WS-CRE-DATE-PR          PIC X(10).                    
A04860        10  WS-CRE-TIME-PR  PIC X(16) VALUE '-00.00.00.000000'.   
A04860    05  WS-DATE-REQUIRED-TS.                                      
A04860        10  WS-REQ-DATE-PR          PIC X(10).                    
A04860        10  WS-REQ-TIME-PR  PIC X(16) VALUE '-00.00.00.000000'.   
      *                                                                         
       01 WS-SWITCHES.                                                  
          05  WS-ACCT-PASSED-FB-WO-CHKS  PIC X(01)  VALUE 'N'.          
          05  WS-GUARANTOR-ROW-EXISTS    PIC X(01)  VALUE 'N'.          
          05  WS-DATABASES               PIC 9(01)  VALUE ZERO.         
              88  CSR-DATABASE                      VALUE 1.            
              88  SEB-DATABASE                      VALUE 2.            
           05  WS-FIRST-GUARANTOR-SW         PIC X(01)     VALUE 'N'.   
               88  WS-FIRST-GUARANTOR                      VALUE 'Y'.   
           05  WS-ACCT-PULLED-FOR-GUAR-XFER  PIC X(01)     VALUE 'N'.   
      *                                                                         
       01  WS-GUAR-MSG.                                                 
           05  WS-GUAR-GUARNTR-STAT            PIC X(19) VALUE SPACES.  
           05  WS-GUAR-GUARNTR-ACCT-NO         PIC 9(13) VALUE 0.       
           05  WS-GUAR-MSG-FILLER              PIC X(30) VALUE          
               '), NO TRANSFER FROM GUARANTEE '.                        
      *                                                                         
       01  WS-COMMENTS.                                                 
           05 WS-COMMENTS-LEN             PIC S9(4) USAGE COMP.         
           05 WS-COMMENTS-TEXT            PIC X(250).                   
      *                                                                         
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
      *                                                                         
      ******************************************************************        
      *  ABEND SWITCH                                                  *        
      ******************************************************************        
      *  CWS00303 JOB PARM ROUTINE CONTAINS WS-WARNING-DATA-ELEMENTS   *        
      ******************************************************************        
       COPY CWS00303.                                                           
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR CPD09900 CONTAINS ABEND WS VARIABLES       *        
      ******************************************************************        
       COPY CWS09900.                                                           
      *                                                                         
      ******************************************************************        
      * WS-ABEND WORK AREA                                             *        
      ******************************************************************        
       COPY CWS00010.                                                           
      *                                                                         
      ******************************************************************        
      * CONTAINS WORKING STORAGE VARIABLES TO GET JOB PARM             *        
      ******************************************************************        
       COPY CWS00038.                                                           
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      *****************************************************************         
      * CWS00337 CONTAINS WS FOR CPD00337 LOAD LIMITS                 *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CWS00337                                                   
           END-EXEC.                                                            
      *                                                                         
       01 WS-END                         PIC X(40) VALUE                
                       'WORKING STORAGE FOR PCSKR095 ENDS HERE  '.      
      *                                                                         
      *****************************************************************         
      * DB2 INCLUDES.                                                 *         
      *****************************************************************         
      *                                                                         
      *****************************************************************         
      *    SQLCA                                                      *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_JOB_PARM  - G6                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ACCOUNT - AT                                                        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_FINAL_WO - FW                                                       
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBFINLWO                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_FIN_WO_ACTION - KD                                                  
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBFWACTN                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_FW_FCST_ACTION - F8                                                 
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBFWPDTL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_GUARANTOR - GU                                                      
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBGTNTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_OFF_CYCL_ACCT - OC                                                  
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBOFFCYL                                                 
           END-EXEC.                                                            
A04860*                                                                         
A04860******* FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077             
A04860      EXEC SQL                                                            
A04860           INCLUDE CWS00077                                               
A04860      END-EXEC.                                                           
      *                                                                         
      ******************************************************************        
      *   CURSOR TO SELECT FB ACTIONS TO BE PROCESSED                  *        
      ******************************************************************        
           EXEC SQL                                                     
             DECLARE FINAL_WO_ACTN CURSOR WITH HOLD FOR                 
              SELECT                                                    
                      AT.COMPANY_NO                                     
                     ,FW.ACCOUNT_NO                                     
                     ,FW.REG_GROUP_CD                                   
                     ,FW.SENIOR_FL                                      
                     ,FW.GUARANTEED_IND                                 
                     ,FW.FW_PATH_TYPE_CD                                
                     ,KD.FW_SEQ_NO                                      
                     ,KD.FW_ACTION_TYPE_CD                              
                     ,KD.FW_ACTION_DT                                   
                     ,KD.FW_ACTION_AM                                   
                     ,KD.FW_PROCESSED_FL                                
                     ,AT.CUSTOMER_NO                                    
                     ,AT.TOTAL_AR_BALANCE                               
                     ,AT.BANKRUPTCY_IND                                 
                     ,AT.JUDGEMENT_CASE_NO                              
                     ,AT.PREMISE_NO                                     
                     ,AT.LOCAL_OFFICE                                   
                FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                     ,CSS_FIN_WO_ACTION KD WITH(READUNCOMMITTED)                
                     ,CSS_FINAL_WO FW WITH(READUNCOMMITTED)                     
               WHERE FW.ACCOUNT_NO        = AT.ACCOUNT_NO               
                 AND FW.ACCOUNT_NO        = KD.ACCOUNT_NO               
                 AND KD.FW_ACTION_DT     <= IIF(TRY_CONVERT(DATE, 
                                                       :KD-FW-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :KD-FW-ACTION-DT
              ) <> 0) OR (LEN(:KD-FW-ACTION-DT) <> 10), CIS.CHAR2DATE(
                                                       :KD-FW-ACTION-DT
              ), CONVERT(DATE, :KD-FW-ACTION-DT) )            
                 AND AT.CODE_ACCT_STAT    = 'B'                         
                 AND KD.FW_BUS_PROCESS_CD = 'XG'                        
                 AND KD.FW_PROCESSED_FL   = ''                          
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE FINAL_WO_ACTN CURSOR WITH HOLD FOR                         
MFA-TR*       SELECT                                                            
MFA-TR*               AT.COMPANY_NO                                             
MFA-TR*              ,FW.ACCOUNT_NO                                             
MFA-TR*              ,FW.REG_GROUP_CD                                           
MFA-TR*              ,FW.SENIOR_FL                                              
MFA-TR*              ,FW.GUARANTEED_IND                                         
MFA-TR*              ,FW.FW_PATH_TYPE_CD                                        
MFA-TR*              ,KD.FW_SEQ_NO                                              
MFA-TR*              ,KD.FW_ACTION_TYPE_CD                                      
MFA-TR*              ,KD.FW_ACTION_DT                                           
MFA-TR*              ,KD.FW_ACTION_AM                                           
MFA-TR*              ,KD.FW_PROCESSED_FL                                        
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.TOTAL_AR_BALANCE                                       
MFA-TR*              ,AT.BANKRUPTCY_IND                                         
MFA-TR*              ,AT.JUDGEMENT_CASE_NO                                      
MFA-TR*              ,AT.PREMISE_NO                                             
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*         FROM  CSS_ACCOUNT AT                                            
MFA-TR*              ,CSS_FIN_WO_ACTION KD                                      
MFA-TR*              ,CSS_FINAL_WO FW                                           
MFA-TR*        WHERE FW.ACCOUNT_NO        = AT.ACCOUNT_NO                       
MFA-TR*          AND FW.ACCOUNT_NO        = KD.ACCOUNT_NO                       
MFA-TR*          AND KD.FW_ACTION_DT     <= :KD-FW-ACTION-DT                    
MFA-TR*          AND AT.CODE_ACCT_STAT    = 'B'                                 
MFA-TR*          AND KD.FW_BUS_PROCESS_CD = 'XG'                                
MFA-TR*          AND KD.FW_PROCESSED_FL   = ''                                  
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * GUARANTOR_CRSR                                               *          
      * TO GET ALL OF THE GUARANTOR'S FOR A GUARANTEE TRANSFER.      *          
      ****************************************************************          
           EXEC SQL                                                     
               DECLARE GUARANTOR_CRSR CURSOR FOR                        
               SELECT  GU.GUARNTR_ACCT_NO                               
                      ,AT.CUSTOMER_NO                                   
                      ,AT.CODE_ACCT_STAT                                
               FROM   CSS_GUARANTOR GU,                                 
                      CSS_ACCOUNT AT                                    
               WHERE  GU.ACCOUNT_NO     = :GU-ACCOUNT-NO                
                 AND  GU.GUAR_STATUS_CD = 'A'                           
                 AND  AT.ACCOUNT_NO     =  GU.GUARNTR_ACCT_NO           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE GUARANTOR_CRSR CURSOR FOR                                
MFA-TR*        SELECT  GU.GUARNTR_ACCT_NO                                       
MFA-TR*               ,AT.CUSTOMER_NO                                           
MFA-TR*               ,AT.CODE_ACCT_STAT                                        
MFA-TR*        FROM   CSS_GUARANTOR GU,                                         
MFA-TR*               CSS_ACCOUNT AT                                            
MFA-TR*        WHERE  GU.ACCOUNT_NO     = :GU-ACCOUNT-NO                        
MFA-TR*          AND  GU.GUAR_STATUS_CD = 'A'                                   
MFA-TR*          AND  AT.ACCOUNT_NO     =  GU.GUARNTR_ACCT_NO                   
MFA-TR*       QUERYNO 7351                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM  0100-INITIALIZATION          THRU  0100-EXIT.       
           PERFORM  1000-MAIN-PROCESS            THRU  1000-EXIT.       
           PERFORM  9000-TERMINATE               THRU  9000-EXIT.       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZATION                                            *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  ' TO WS-PGRMNAME                            
              MOVE SPACES     TO WS-INPUT-AREA                          
              MOVE SPACES     TO WS-INPUT-DATA-BREAKDOWN                
              PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                
           END-IF.                                                      
      *                                                                         
           MOVE WS-INPUT-DATE TO KD-FW-ACTION-DT.                       
      *                                                                         
           INITIALIZE  WS-FW-COMPANY                                    
                       WS-REG-GROUP-CD                                  
                       WS-FW-PATH-TYPE-CD                               
                       WS-FW-ACTION-TYPE-CD                             
                       WS-FW-ACTION-LIMIT-AM.                           
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  1000-MAIN-PROCESS                                                      
      ******************************************************************        
       1000-MAIN-PROCESS.                                               
      *                                                                         
           PERFORM 7000-OPEN-FINAL-WO-ACTN THRU 7000-EXIT.              
      *                                                                         
           PERFORM 7010-FETCH-FINAL-WO-ACTN THRU 7010-EXIT.             
      *                                                                         
           PERFORM 2000-PROCESS-FB-GUARANTEED THRU 2000-EXIT            
                UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.            
      *                                                                         
           PERFORM 7020-CLOSE-FINAL-WO-ACTN THRU 7020-EXIT.             
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   2000-PROCESS-FB-GUARANTEED                                   *        
      *     PROCESS FB GUARANTEED ACCOUNTS.                            *        
      *     FINAL BILL GUARANTEED ACCOUNTS ARE FIRST EDITED AND THEN   *        
      *     IF THE GUARANTOR ACCOUNT IS ACTIVE ROWS ARE WRITTEN TO THE *        
      *     CSS_OFF_CYCL_ACCT TABLE.                                   *        
      ******************************************************************        
       2000-PROCESS-FB-GUARANTEED.                                      
      *                                                                         
           MOVE FW-ACCOUNT-NO   TO GU-ACCOUNT-NO                        
                                   KD-ACCOUNT-NO.                       
           MOVE KD-FW-ACTION-DT TO WS-GUARANTOR-XFER-DT.                
           MOVE KD-FW-ACTION-AM TO WS-GUARANTOR-XFER-AM.                
      *                                                                         
           IF AT-BANKRUPTCY-IND > ' ' OR                                
              AT-JUDGEMENT-CASE-NO > ' '                                
               PERFORM 8100-UPDATE-FW-ACTION-FLAG THRU 8100-EXIT        
               GO TO 2000-NEXT                                          
           END-IF.                                                      
      *                                                                         
           MOVE 'XG'                 TO F8-FW-BUS-PROCESS-CD.           
           MOVE WS-INPUT-DATE        TO WS-CWS337-PROCESS-DATE.         
           MOVE AT-COMPANY-NO        TO WS-FW-COMPANY.                  
           MOVE FW-REG-GROUP-CD      TO WS-REG-GROUP-CD.                
           MOVE FW-FW-PATH-TYPE-CD   TO WS-FW-PATH-TYPE-CD.             
           MOVE KD-FW-ACTION-TYPE-CD TO WS-FW-ACTION-TYPE-CD.           
           PERFORM 5100-GET-FCST-ACTN-DATA THRU 5100-CPD337-EXIT.       
           PERFORM 3300-VERIFY-DW-VARIABLES THRU 3300-EXIT.             
           MOVE WS-FW-ACTION-LIMIT-AM TO WS-GUAR-XFER-MIN-LIMIT.        
      *                                                                         
           MOVE 'N' TO WS-GUARANTOR-ROW-EXISTS.                         
           PERFORM 7500-CK-GUARANTOR-ROW THRU 7500-EXIT.                
           IF WS-GUARANTOR-ROW-EXISTS = 'N'                             
               MOVE ZEROS TO WS-FW-ACTION-AM                            
               PERFORM 8000-UPDATE-FW-ACTION-AM THRU 8000-EXIT          
               GO TO 2000-NEXT                                          
           END-IF.                                                      
      *                                                                         
           MOVE WS-Y TO WS-FIRST-GUARANTOR-SW.                          
           PERFORM 7350-OPEN-GUARANTOR-CRSR    THRU 7350-EXIT.          
           PERFORM 7351-FETCH-GUARANTOR-CRSR   THRU 7351-EXIT.          
           PERFORM 2600-PROCESS-EACH-GUARANTOR THRU 2600-EXIT           
              UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.              
           PERFORM 7352-CLOSE-GUARANTOR-CRSR THRU 7352-EXIT.            
           MOVE 'Y' TO WS-ACCT-PULLED-FOR-GUAR-XFER.                    
      *                                                                         
           INITIALIZE   WS-COMMENTS-TEXT                                
                        WS-COMMENTS-LEN.                                
           MOVE WS-N TO WS-ACCT-PASSED-FB-WO-CHKS.                      
      *                                                                         
       2000-NEXT.                                                       
           PERFORM 7010-FETCH-FINAL-WO-ACTN THRU 7010-EXIT.             
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 2600-PROCESS-EACH-GUARANTOR                                  *          
      * THIS PROCESSES ALL OF THE GUARANTORS FOR THE GUARANTEED ACCT *          
      * THAT HAS A TRANSFER AND CREATES A ROW ON THE OFF CYCLE DB2   *          
      * TABLE SO THAT THE GUARANTEED ACCT WILL GO THROUGH A NORMAL   *          
      * BILLING PARTITION AND THE GUARANTOR ACCOUNTS WILL GO THROUGH *          
      * A PARTITION 9 BILLING PROCESS.                               *          
      ****************************************************************          
       2600-PROCESS-EACH-GUARANTOR.                                     
      *                                                                         
           IF AT-TOTAL-AR-BALANCE <= WS-GUAR-XFER-MIN-LIMIT             
               PERFORM 8100-UPDATE-FW-ACTION-FLAG THRU 8100-EXIT        
               MOVE WS-CANCELLED            TO GU-GUAR-STATUS-CD        
               MOVE WS-GUAR-FB-AMT-PAID-MSG TO GU-GUAR-STATUS-REASON    
               PERFORM 8300-UPDATE-GUARANTOR-STATUS THRU 8300-EXIT      
               GO TO 2600-NEXT                                          
           END-IF.                                                      
           IF AT-CODE-ACCT-STAT = WS-FINAL-BILL OR WS-WRITE-OFF         
               PERFORM 2700-GUARNTR-ACCT-STAT-WQ THRU 2700-EXIT         
               GO TO 2600-NEXT                                          
           END-IF.                                                      
           IF FW-GUARANTEED-IND = ' ' OR 'N'                            
               PERFORM 8300-UPDATE-GUARANTOR-STATUS THRU 8300-EXIT      
               GO TO 2600-NEXT                                          
           END-IF.                                                      
      *                                                                         
           IF WS-FIRST-GUARANTOR                                        
               MOVE WS-N           TO WS-FIRST-GUARANTOR-SW             
               MOVE FW-ACCOUNT-NO  TO OC-ACCOUNT-NO                     
               MOVE AT-CUSTOMER-NO TO OC-CUSTOMER-NO                    
               MOVE ZEROES         TO FW-ITEM-ID                        
               MOVE WS-E           TO OC-CODE-BILL-OFF-CYCL             
               MOVE WS-Y           TO OC-CREDIT-LETTER-IND              
               PERFORM 8500-INSERT-OFF-CYCLE THRU 8500-EXIT             
           END-IF.                                                      
      *                                                                         
           MOVE GU-GUARNTR-ACCT-NO  TO OC-ACCOUNT-NO.                   
           MOVE WS-GUAR-CUSTOMER-NO TO OC-CUSTOMER-NO.                  
           MOVE ZEROES              TO FW-ITEM-ID.                      
           MOVE WS-G                TO OC-CODE-BILL-OFF-CYCL.           
           MOVE WS-Y                TO OC-CREDIT-LETTER-IND.            
      *                                                                         
           PERFORM 8500-INSERT-OFF-CYCLE THRU 8500-EXIT.                
      *                                                                         
       2600-NEXT.                                                       
           PERFORM 7351-FETCH-GUARANTOR-CRSR THRU 7351-EXIT.            
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * IF A GUARANTOR ACCOUNT IS NOT ACTIVE THEN WQ WILL BE GENERATED *        
      * FOR THE GUARANTOR TO BE ADDRESS MANUALLY, UPDATE PROCESSED_FL  *        
      * TO 'Y' IN GUARANTOR TRANSFER 'GAXF' ROW IN CSS_FIN_WO_ACTION,  *        
      * AND GUARANTOR STATUS ON CSS_GUARANTOR WILL NOT BE UPDATED AS   *        
      * THE GUARANTOR IS STILL LIABLE FOR THE GUARANTEED AMOUNT.       *        
      ******************************************************************        
       2700-GUARNTR-ACCT-STAT-WQ.                                       
      *                                                                         
           IF AT-CODE-ACCT-STAT = WS-FINAL-BILL                         
              MOVE WS-GUAR-MSG-FB TO WS-GUAR-GUARNTR-STAT               
           ELSE                                                         
              MOVE WS-GUAR-MSG-WO TO WS-GUAR-GUARNTR-STAT               
           END-IF.                                                      
           MOVE GU-GUARNTR-ACCT-NO  TO WS-GUAR-GUARNTR-ACCT-NO.         
           MOVE WS-GUAR-MSG TO WS-COMMENTS-TEXT.                        
           MOVE +62 TO  WS-COMMENTS-LEN.                                
           MOVE 117 TO WS-WQ-CATEGORY.                                  
      *                                                                         
           PERFORM 2750-CREATE-WORK-QUEUE THRU 2750-EXIT.               
           PERFORM 8100-UPDATE-FW-ACTION-FLAG THRU 8100-EXIT.           
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2750-CREATE-WORK-QUEUE.                                                 
      ******************************************************************        
       2750-CREATE-WORK-QUEUE.                                          
      *                                                                         
A04860     INITIALIZE CWS00077-FIELDS.                                  
      *                                                                         
A04860     INITIALIZE WS-77-COMMENTS.                                   
      *                                                                         
A04860     MOVE FW-ACCOUNT-NO       TO WS-77-ACCOUNT-NO.                
A04860     MOVE AT-CUSTOMER-NO      TO WS-77-CUSTOMER-NO.               
A04860     MOVE AT-PREMISE-NO       TO WS-77-PREMISE-NO.                
A04860     MOVE AT-LOCAL-OFFICE     TO WS-77-LOCAL-OFFICE.              
A04860     MOVE WS-WQ-CATEGORY      TO WS-77-CATEGORY-ID.               
           MOVE WS-INPUT-DATE       TO WS-PROGRAM-DATE.                 
A04860     MOVE WS-COMMENTS-TEXT    TO WS-77-COMMENTS-TEXT.             
A04860     MOVE WS-COMMENTS-LEN     TO WS-77-COMMENTS-LEN.              
A04860     MOVE '4'                 TO WS-77-ROUTE-CATEGORY.            
A04860     MOVE WS-N                TO WS-77-PRIORITY.                  
A04860     MOVE WS-PROGRAM-DATE     TO WS-CRE-DATE-PR.                  
A04860     MOVE WS-INPUT-DATE       TO WS-REQ-DATE-PR.                  
A04860     MOVE WS-DATE-CREATED-TS  TO WS-77-DATE-CREATED.              
A04860     MOVE WS-DATE-REQUIRED-TS TO WS-77-DATE-REQUIRED.             
A04860     MOVE PROGRAM-NAME        TO WS-77-CREATED-BY.                
      *                                                                         
           PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.               
      *                                                                         
       2750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  THIS PARA CHECKS WHETHER ALL VALUES ARE POSITIVE                       
      *  IN THE TABLE ITSELF.                                                   
      *****************************************************************         
       3300-VERIFY-DW-VARIABLES.                                        
      *                                                                         
           IF F8-MATCH-FOUND                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**************PCSKR095***************'          
               DISPLAY '* 3300-VERIFY-DW-VARIABLES'                     
               DISPLAY '* RETURN CODE = 12'                             
               DISPLAY '**************PCSKR095***************'          
               PERFORM 9900-ABEND   THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       3300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5100-GET-FCST-ACTN-DATA                                        *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00337                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00037                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  7000-OPEN-FINAL-WO-ACTN                                   **          
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **          
      **      FINAL_WO_ACTN CURSOR                                  **          
      ****************************************************************          
       7000-OPEN-FINAL-WO-ACTN.                                         
      *                                                                         
           EXEC SQL                                                     
               OPEN FINAL_WO_ACTN                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-SQLCODE                       
               DISPLAY '**************PCSKR095***************'          
               DISPLAY '** 7000-OPEN-FINAL-WO-ACTN '                    
               DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE           
               DISPLAY '**************PCSKR095***************'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7010-FETCH-FINAL-WO-ACTN                                  **          
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **          
      **      FINAL_WO_ACTN CURSOR                                  **          
      ****************************************************************          
       7010-FETCH-FINAL-WO-ACTN.                                        
      *                                                                         
           EXEC SQL                                                     
               FETCH FINAL_WO_ACTN INTO                                 
                    :AT-COMPANY-NO                                      
                   ,:FW-ACCOUNT-NO                                      
                   ,:FW-REG-GROUP-CD                                    
                   ,:FW-SENIOR-FL                                       
                   ,:FW-GUARANTEED-IND                                  
                   ,:FW-FW-PATH-TYPE-CD                                 
                   ,:KD-FW-SEQ-NO                                       
                   ,:KD-FW-ACTION-TYPE-CD                               
                   ,:KD-FW-ACTION-DT                                    
                   ,:KD-FW-ACTION-AM                                    
                   ,:KD-FW-PROCESSED-FL                                 
                   ,:AT-CUSTOMER-NO                                     
                   ,:AT-TOTAL-AR-BALANCE                                
                   ,:AT-BANKRUPTCY-IND                                  
                   ,:AT-JUDGEMENT-CASE-NO                               
                   ,:AT-PREMISE-NO                                      
                   ,:AT-LOCAL-OFFICE                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-SQLCODE                       
               DISPLAY '**************PCSKR095***************'          
               DISPLAY '** 7010-FETCH-FINAL-WO-ACTN'                    
               DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE           
               DISPLAY '** ACCOUNT NO ' FW-ACCOUNT-NO                   
               DISPLAY '**************PCSKR095***************'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7020-CLOSE-FINAL-WO-ACTN                                  **          
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **          
      **      FINAL_WO_ACTN CURSOR                                  **          
      ****************************************************************          
       7020-CLOSE-FINAL-WO-ACTN.                                        
      *                                                                         
           EXEC SQL                                                     
               CLOSE FINAL_WO_ACTN                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-SQLCODE                       
               DISPLAY '**************PCSKR095***************'          
               DISPLAY '** 7020-CLOSE-FINAL-WO-ACTN'                    
               DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE           
               DISPLAY '**************PCSKR095***************'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 735X-CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **          
      **      GUARANTOR_CRSR CURSOR                                 **          
      ****************************************************************          
       7350-OPEN-GUARANTOR-CRSR.                                        
      *                                                                         
           EXEC SQL                                                     
               OPEN GUARANTOR_CRSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-SQLCODE                       
               DISPLAY '************** PCSKR095 ******************'     
               DISPLAY '** 7350 :  RETURN CODE ERROR - OPEN '           
               DISPLAY '** ACCOUNT NO ' GU-ACCOUNT-NO                   
               DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE            
               DISPLAY '************** PCSKR095 ******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **          
      **      GUARANTOR_CRSR CURSOR                                 **          
      ****************************************************************          
       7351-FETCH-GUARANTOR-CRSR.                                       
      *                                                                         
           EXEC SQL                                                     
               FETCH GUARANTOR_CRSR INTO                                
                    :GU-GUARNTR-ACCT-NO                                 
                   ,:WS-GUAR-CUSTOMER-NO                                
                   ,:AT-CODE-ACCT-STAT                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-SQLCODE                       
               DISPLAY '*********** PCSKR095 *********************'     
               DISPLAY '** 7351 :  RETURN CODE ERROR - FETCH'           
               DISPLAY '** ACCOUNT NO ' GU-ACCOUNT-NO                   
               DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE            
               DISPLAY '*********** PCSKR095 *********************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7351-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **          
      **      GUARANTOR_CRSR CURSOR                                 **          
      ****************************************************************          
       7352-CLOSE-GUARANTOR-CRSR.                                       
      *                                                                         
           EXEC SQL                                                     
               CLOSE GUARANTOR_CRSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-SQLCODE                       
               DISPLAY '************* PCSKR095 *******************'     
               DISPLAY '** 7352 :  RETURN CODE ERROR - CLOSE'           
               DISPLAY '** ACCOUNT NO ' GU-ACCOUNT-NO                   
               DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE            
               DISPLAY '************* PCSKR095 *******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7352-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7500-CK-GUARANTOR-ROW                                         *        
      *  SELECT THE ACTIVE GUARANTOR                                   *        
      ******************************************************************        
       7500-CK-GUARANTOR-ROW.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                 INTO :WS-GUARANTOR-ROW-EXISTS                          
              FROM CSS_GUARANTOR WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO      = :GU-ACCOUNT-NO                    
                AND GUAR_STATUS_CD  = 'A'                               
                AND SERVICE_TYPE_CD  = 'U'                              
                                                    
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*          INTO :WS-GUARANTOR-ROW-EXISTS                                  
MFA-TR*       FROM CSS_GUARANTOR                                                
MFA-TR*       WHERE ACCOUNT_NO      = :GU-ACCOUNT-NO                            
MFA-TR*         AND GUAR_STATUS_CD  = 'A'                                       
MFA-TR*         AND SERVICE_TYPE_CD  = 'U'                                      
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-SQLCODE                       
               DISPLAY '************* PCSKR095 *******************'     
               DISPLAY '** 7500 :  RETURN CODE ERROR - SELECT'          
               DISPLAY '** ACCOUNT NO ' GU-ACCOUNT-NO                   
               DISPLAY '**      :  RC = ' WS-DISPLAY-SQLCODE            
               DISPLAY '************* PCSKR095 *******************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    7600-START-FCSJC01.                                                  
      *    7610-READ-FCSJC01.                                                   
      *    7611-CLOSE.                                                          
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CPD00038                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 8000-UPDATE-FW-ACTION-AM                                                
      ******************************************************************        
       8000-UPDATE-FW-ACTION-AM.                                        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_FIN_WO_ACTION                                 
                  SET FW_ACTION_AM     = :WS-FW-ACTION-AM               
                     ,FW_PROCESSED_FL  = 'Y'                            
               WHERE ACCOUNT_NO        = :KD-ACCOUNT-NO                 
                 AND FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD          
                 AND FW_SEQ_NO         = :KD-FW-SEQ-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
              CONTINUE                                                  
           WHEN OTHER                                                   
              MOVE SQLCODE TO WS-DISPLAY-SQLCODE                        
              DISPLAY '**************PCSKR095***************'           
              DISPLAY '** 8000-UPDATE-FW-ACTION-AM'                     
              DISPLAY '** CSS_FIN_WO_ACTION        '                    
              DISPLAY '** ACCOUNT NO = ' KD-ACCOUNT-NO                  
              DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE            
              DISPLAY '**************PCSKR095***************'           
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100-UPDATE-FW-ACTION-FLAG                                              
      ******************************************************************        
       8100-UPDATE-FW-ACTION-FLAG.                                      
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_FIN_WO_ACTION                                 
                  SET FW_PROCESSED_FL  = 'Y'                            
               WHERE ACCOUNT_NO        = :KD-ACCOUNT-NO                 
                 AND FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD          
                 AND FW_SEQ_NO         = :KD-FW-SEQ-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
              CONTINUE                                                  
           WHEN OTHER                                                   
              MOVE SQLCODE TO WS-DISPLAY-SQLCODE                        
              DISPLAY '**************PCSKR095***************'           
              DISPLAY '** 8100-UPDATE-FW-ACTION-FLAG'                   
              DISPLAY '** CSS_FIN_WO_ACTION        '                    
              DISPLAY '** ACCOUNT NO = ' KD-ACCOUNT-NO                  
              DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE            
              DISPLAY '**************PCSKR095***************'           
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8300-UPDATE-GUARANTOR-STATUS                                            
      *    UPDATE GUARANTOR STATUS AND THE STATUS REASON.                       
      ******************************************************************        
       8300-UPDATE-GUARANTOR-STATUS.                                    
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_GUARANTOR                                      
                 SET GUAR_STATUS_CD     = :GU-GUAR-STATUS-CD,           
                     GUAR_STATUS_REASON = :GU-GUAR-STATUS-REASON,       
                     LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
               WHERE ACCOUNT_NO         = :GU-ACCOUNT-NO                
                 AND GUARNTR_ACCT_NO    = :GU-GUARNTR-ACCT-NO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_GUARANTOR                                              
MFA-TR*          SET GUAR_STATUS_CD     = :GU-GUAR-STATUS-CD,                   
MFA-TR*              GUAR_STATUS_REASON = :GU-GUAR-STATUS-REASON,               
MFA-TR*              LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*        WHERE ACCOUNT_NO         = :GU-ACCOUNT-NO                        
MFA-TR*          AND GUARNTR_ACCT_NO    = :GU-GUARNTR-ACCT-NO                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-SQLCODE                       
               DISPLAY '**************** PCSKR095 *****************'    
               DISPLAY '* 8300 : RETURN CODE ERROR - UPDATE'            
               DISPLAY '*        RC = ' WS-DISPLAY-SQLCODE              
               DISPLAY 'ACCOUNT NO = ' GU-ACCOUNT-NO                    
               DISPLAY 'GUARNTR_ACCT_NO = ' GU-GUARNTR-ACCT-NO          
               DISPLAY '**************** PCSKR095 *****************'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  8500-INSERT-OFF-CYCLE                                     **          
      ****************************************************************          
       8500-INSERT-OFF-CYCLE.                                           
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_OFF_CYCL_ACCT                            
                   (ACCOUNT_NO,                                         
                    CODE_BILL_OFF_CYCL,                                 
                    CUSTOMER_NO,                                        
                    LAST_UPDATE_TS,                                     
                    ITEM_ID,                                            
                    CREDIT_LETTER_IND)                                  
               VALUES                                                   
                   (:OC-ACCOUNT-NO,                                     
                    :OC-CODE-BILL-OFF-CYCL,                             
                    :OC-CUSTOMER-NO,                                    
                    CIS.CURRENT$TIMESTAMP(),                                  
                    :FW-ITEM-ID,                                        
                    :OC-CREDIT-LETTER-IND)                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_OFF_CYCL_ACCT                                    
MFA-TR*            (ACCOUNT_NO,                                                 
MFA-TR*             CODE_BILL_OFF_CYCL,                                         
MFA-TR*             CUSTOMER_NO,                                                
MFA-TR*             LAST_UPDATE_TS,                                             
MFA-TR*             ITEM_ID,                                                    
MFA-TR*             CREDIT_LETTER_IND)                                          
MFA-TR*        VALUES                                                           
MFA-TR*            (:OC-ACCOUNT-NO,                                             
MFA-TR*             :OC-CODE-BILL-OFF-CYCL,                                     
MFA-TR*             :OC-CUSTOMER-NO,                                            
MFA-TR*             CURRENT TIMESTAMP,                                          
MFA-TR*             :FW-ITEM-ID,                                                
MFA-TR*             :OC-CREDIT-LETTER-IND)                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
           OR ALREADY-EXISTS                                            
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-SQLCODE                       
               DISPLAY '**************** PCSKR095 *****************'    
               DISPLAY '* 8500 : RETURN CODE ERROR - INSERT'            
               DISPLAY '*        RC = ' WS-DISPLAY-SQLCODE              
               DISPLAY 'ACCOUNT NO ' OC-ACCOUNT-NO                      
               DISPLAY 'ACCOUNT NO ' OC-CODE-BILL-OFF-CYCL              
               DISPLAY 'ITEM ID    ' FW-ITEM-ID                         
               DISPLAY '**************** PCSKR095 *****************'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  8895-INSERT-WORK-QUEUE                                        *        
      ******************************************************************        
A04860*                                                                         
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860*                                                                         
A04860     CALL SCSCB077 USING CWS00077-FIELDS,                         
A04860                         ABEND-FILE,                              
A04860                         RS-RETURN-CODE                           
A04860     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     END-IF.                                                      
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
      *                                                                         
      ************************************************************              
      * CLOSES                                                                  
      ************************************************************              
       9000-TERMINATE.                                                  
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      * CPD09900   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE   *            
      * 9900-ABEND                                                 *            
      **************************************************************            
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
