       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSIN101.                                        
       DATE-WRITTEN.   MAR.1999.                                        
           DATE-COMPILED.                                               
      ****************************************************************  00052000
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL              **  00060000
      **                     PRICEWATERHOUSECOOPERS                **   00070000
      ********            CUSTOMER SERVICE SYSTEM             ********  00120000
      ********                      DB2                       ********  00130000
      ****************************************************************  00140000
      **                                                            **  00150000
      **              PROGRAM  MODIFICATION  LOG                    **  00160000
      **                                                            **  00170000
      ** NEW     3/17/99  CDS    COMPONENT ORIGINALLY WRITTEN.      **  00180000
      **         6/23/99  WMG    MODIFIED TO DELETE ROWS FROM       **          
      **                         CSS_MKT_TRAN_INFO AFTER THEY ARE   **          
      **                         PROCESSED, AND INCLUDE THE ZIP CODE**          
      **                         TOKEN IN THE PREDICATE IN 7200.    **          
AMG   **         09/15/99 AMG    GRAB ORIG_DIST_ACCT_NO FOR MKSW    **          
      **         02/02/00 DHR    ADDED LAST_UPDATED_BY TO INSERT ON **          
      **                         CSS_MKT_TRAN_OUTMF                 **          
T21832**       03/13/2000 SK     ADDED WHERE CE.CUSTOMER_TYPE = 'C' **          
T21832**                         TO 7500-SELECT-CUST-STATS          **          
      **                                                            **          
      **       10/03/2002 MLF    ADDED CODE TO SET RONP TO H STATUS **          
T35434**      06/07/2007 PC97415 REPLACED MODEL_SQL TO SET COMMANDS **          
T35434**                         AND ADDED FETCH ONLY WITH UR FOR   **          
T35434**                         AVOIDING -911 ABENDS.              **          
A04876**      01/07/2014 DB18339 REMOVED CALL TO CUST_STATS FOR SSN.**          
      **                         SSN WILL NOW BE SPACES.            **          
A04576**      12/04/2014 SS19371 ADD CUST TYPE TO CUST_PHONE QUERY  **          
      ****************************************************************  00445000
           REMARKS.                                                     
      * ------------------------------------------------------------ *  00460000
      *  THIS COMPONENT WILL READ RECORDS FROM TABLE CSS_TRANS_INFO. *          
      *  FOR EACH RECORD, THE ACCOUNTS NAME AND ADDRESS INFORMATION  *          
      *  WILL BE SELECTED FROM THE DATABASE.  ALL OF THE INFORMATION *          
      *  WILL BE FORMATED.  THEN A RECORD WILL BE INSERTED INTO TABLE*          
      *  CSS_MARKETER_TRANS_OUT AND THE RECORD WILL BE DELETED FROM  *          
      *  TABLE CSS_TRANS_INFO.                                       *          
      *                                                              *  00580000
      * ------------------------------------------------------------ *  00590000
      *                                                                 00600000
                     ---- BASIC BATCH SEQUENCE STRUCTURE ----           
                    0000 - 0000     MAIN CONTROL PATH                   
                    0100 - 0100     INITIALIZATION                      
                    1000 - 1000     MAJOR PROCESSING LOOP               
                    1100 - 4999     PERFORMED PARAGRAPHS OF MAJOR       
                                    PROCESSING LOOPS                    
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                          ---- PARAGRAPH STRUCTURE ----                 
      *                                                                 00740000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00810000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSIN101'.
MSQ017     COPY MFASQLM.
      *                                                                 00960000
       01 WS-START                     PIC X(40)     VALUE              
             'WORKING STORAGE FOR PCSIN101 STARTS HERE'.                
      *                                                                 01010000
       01  WS-MISCELLANEOUS.                                            
           05  WS-TIMESTAMP           PIC X(26)      VALUE SPACES.      
           05  WS-CURRENT-TIMESTAMP   PIC X(26)      VALUE SPACES.      
AMG        05  WS-MARKET-SWITCH       PIC X(04)      VALUE 'MKSW'.      
           05  WS-SERV-ADDR.                                            
               10 WS-HOUSE-NO          PIC X(05)      VALUE SPACES.     
               10 FILLER               PIC X(01)      VALUE '-'.        
               10 WS-ADDR-PREFIX       PIC X(03)      VALUE SPACES.     
               10 FILLER               PIC X(06)      VALUE SPACES.     
           05  WS-SERV-ADDR-STRUCT.                                     
               10 WS-STREET-LOCATION-1 PIC X(04)      VALUE SPACES.     
               10 FILLER               PIC X(01)      VALUE SPACE.      
               10 WS-STREET-LOCATION-2 PIC X(06)      VALUE SPACES.     
               10 FILLER               PIC X(04)      VALUE SPACES.     
           05  WS-PHONE-NO.                                             
               10 WS-AREA-CD           PIC X(03).                       
               10 WS-PHONE-4-6         PIC X(03).                       
               10 WS-PHONE-7-10        PIC X(04).                       
           05  WS-PHONE-HOLD.                                           
               10 WS-PHONE-HOLD-1      PIC X(03).                       
               10 FILLER               PIC X(01)      VALUE '-'.        
               10 WS-PHONE-HOLD-2      PIC X(04).                       
      *                                                                 01234000
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
      *                                                                 01553400
      *                                                                 01554600
       COPY CWS09900.                                                   01554900
      *                                                                 01554600
       COPY CWS00010.                                                   01555200
      *                                                                 01555300
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME             PIC X(08)     VALUE 'PCSIN101'.  
           05  PROGRAM-NAME            PIC X(08)     VALUE 'PCSIN101'.  
           05  WS-AVAILABLE            PIC X(01)     VALUE 'A'.         
           05  WS-HOLD                 PIC X(01)     VALUE 'H'.         
           05  WS-RONP                 PIC X(04)     VALUE 'RONP'.      
           05  WS-INDIVIDUAL           PIC X(01)     VALUE 'I'.         
           05  WS-BUSINESS             PIC X(01)     VALUE 'B'.         
           05  WS-HOME-1               PIC X(02)     VALUE 'H1'.        
           05  WS-BUSINESS-1           PIC X(02)     VALUE 'B1'.        
      *                                                                 02217500
       COPY CWS00303.                                                   02264200
      *                                                                 02265000
           EXEC SQL                                                     02270000
               INCLUDE SQLCA                                            02280000
           END-EXEC.                                                    02290000
      *                                                                 02300000
      * DCLGEN FOR CSS_ACCOUNT                                          02301000
      *                                                                 02302000
           EXEC SQL                                                     02310000
               INCLUDE TBACCT                                           02320000
           END-EXEC.                                                    02330000
      *                                                                 02340000
      * DCLGEN FOR CSS_PREMISE                                          02501000
      *                                                                 02502000
           EXEC SQL                                                     02510000
               INCLUDE TBPREM                                           02520000
           END-EXEC.                                                    02530000
      *                                                                 02660000
      * DCLGEN FOR CSS_CUSTOMER                                         02798000
      *                                                                 02799000
           EXEC SQL                                                     02799100
               INCLUDE TBCUST                                           02799200
           END-EXEC.                                                    02799300
      *                                                                 02799400
      * DCLGEN FOR CSS_ADDR_FORMATTED                                   02798000
      *                                                                 02799000
           EXEC SQL                                                     02799100
               INCLUDE TBADRFMT                                         02799200
           END-EXEC.                                                    02799300
      *                                                                 02799400
      * DCLGEN FOR CSS_ZIP_CODE                                         02798000
      *                                                                 02799000
           EXEC SQL                                                     02799100
               INCLUDE TBZIPCD                                          02799200
           END-EXEC.                                                    02799300
      *                                                                 02799400
      * DCLGEN FOR CSS_NAME                                             02798000
      *                                                                 02799000
           EXEC SQL                                                     02799100
               INCLUDE TBNAME                                           02799200
           END-EXEC.                                                    02799300
      *                                                                 02799400
      * DCLGEN FOR CSS_CUST_PHONE                                       02798000
      *                                                                 02799000
           EXEC SQL                                                     02799100
               INCLUDE TBCSTPHN                                         02799200
           END-EXEC.                                                    02799300
      *                                                                 02799400
      * DCLGEN FOR CSS_CUST_STATS                                       02798000
      *                                                                 02799000
           EXEC SQL                                                     02799100
               INCLUDE TBCSTSTS                                         02799200
           END-EXEC.                                                    02799300
      *                                                                 02801800
      * DCLGEN FOR CSS_MKT_TRAN_INFO                                    02798000
      *                                                                 02799000
           EXEC SQL                                                     02799100
               INCLUDE TBMRKINF                                         02799200
           END-EXEC.                                                    02799300
      *                                                                 02801800
      * DCLGEN FOR CSS_MKT_TRAN_OUTMF                                   02798000
      *                                                                 02799000
           EXEC SQL                                                     02799100
               INCLUDE TBMRKOMF                                         02799200
           END-EXEC.                                                    02799300
      *                                                                 02801800
      * DCLGEN FOR CSS_MKT_XREF_ACCT                                    02798000
      *                                                                 02799000
           EXEC SQL                                                     02799100
               INCLUDE TBMRKXR                                          02799200
           END-EXEC.                                                    02799300
      *                                                                 02801800
      *****************************************                         02802000
      * TRANS_INFO_CSR                                                  02810000
      *****************************************                         02820000
           EXEC SQL                                                     
               DECLARE TRANS_INFO_CSR CURSOR FOR                        
               SELECT  TL.TRANS_ID_CD,                                  
                       REPLACE(REPLACE(CONVERT(CHAR(26), TL.RECEIVED_TS
           , 121), ' ', '-'), ':', '.') RECEIVED_TS,                           
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           TL.TRANS_OCCURS_TS, 121), ' ', '-'), ':', '.') 
           TRANS_OCCURS_TS,                              
                       TL.ACCOUNT_NO,                                   
                       TL.COMPANY_NO,                                   
                       TL.TRANS_DATA_1,                                 
                       TL.TRANS_DATA_2,                                 
                       TL.TRANS_DATA_3,                                 
                       TL.TRANS_DATA_4                                  
               FROM    CSS_MKT_TRAN_INFO TL WITH(READUNCOMMITTED)               
               ORDER BY RECEIVED_TS                                  
T35434         FOR READ ONLY                                    
A04876                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     02830000
MFA-TR*        DECLARE TRANS_INFO_CSR CURSOR FOR                        02840000
MFA-TR*        SELECT  TL.TRANS_ID_CD,                                  02850000
MFA-TR*                TL.RECEIVED_TS,                                          
MFA-TR*                TL.TRANS_OCCURS_TS,                              02870000
MFA-TR*                TL.ACCOUNT_NO,                                   02890000
MFA-TR*                TL.COMPANY_NO,                                           
MFA-TR*                TL.TRANS_DATA_1,                                 02900000
MFA-TR*                TL.TRANS_DATA_2,                                 02910000
MFA-TR*                TL.TRANS_DATA_3,                                 02920000
MFA-TR*                TL.TRANS_DATA_4                                  02920000
MFA-TR*        FROM    CSS_MKT_TRAN_INFO TL                             02930000
MFA-TR*        ORDER BY TL.RECEIVED_TS                                  03001000
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                    03010000
      *                                                                 04203300
       01 WS-END                       PIC X(40)     VALUE              
             'WORKING STORAGE FOR PCSIN101 ENDS HERE'.                  
      *                                                                 04220000
       PROCEDURE DIVISION.                                              
      ****************************************************************  04240000
      **                                                            **  04250000
      **  0000-MAINLINE                                             **  04260000
      **       CONTROLS THE MAIN PROCESS OF PROGRAM                 **  04270000
      **                                                            **  04280000
      ****************************************************************  04290000
           EXIT.                                                        
       0000-MAINLINE.                                                   
      *                                                                 04320000
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
      *                                                                 04350000
           PERFORM 1000-MAIN-PROCESS             THRU 1000-EXIT         
              UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.              
      *                                                                 04390000
           PERFORM 7020-CLOSE-TRANS-INFO         THRU 7020-EXIT.        
      *                                                                 04390000
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                 04430000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04460000
      ****************************************************************  04470000
      **                                                            **  04480000
      **  0100-INITIALIZATION                                       **  04490000
      **       COMMON INITIALIZATION ROUTINE                        **  04500000
      **                                                            **  04510000
      ****************************************************************  04520000
       0100-INITIALIZATION.                                             
      *                                                                         
           PERFORM 7700-SELECT-CURRENT-DATE         THRU 7700-EXIT.     
           MOVE 0                     TO TJ-TRANS-SEQ-NO.               
           MOVE WS-CURRENT-TIMESTAMP  TO TJ-RECEIVED-TS.                
      *                                                                         
           PERFORM 7000-OPEN-TRANS-INFO             THRU 7000-EXIT.     
      *                                                                 04560000
           PERFORM 7010-FETCH-TRANS-INFO            THRU 7010-EXIT.     
      *                                                                 04680000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04811000
      ****************************************************************  05210000
      **  1000-MAIN-PROCESS                                         **  05220000
      ****************************************************************  05290000
       1000-MAIN-PROCESS.                                               
      *                                                                 05310000
           MOVE TL-TRANS-ID-CD       TO TJ-TRANS-ID-CD.                 
           MOVE 1                    TO TJ-TRANS-PRIORITY.              
           ADD  1                    TO TJ-TRANS-SEQ-NO.                
           IF TL-TRANS-ID-CD = WS-RONP                                  
               MOVE WS-HOLD          TO TJ-TRANS-STATUS-CD              
           ELSE                                                         
               MOVE WS-AVAILABLE     TO TJ-TRANS-STATUS-CD
           END-IF.             
           MOVE TL-TRANS-OCCURS-TS   TO TJ-TRANS-OCCURS-TS.             
           MOVE TL-ACCOUNT-NO        TO AT-ACCOUNT-NO                   
                                        XM-ACCOUNT-NO                   
                                        TJ-SEB-ACCT-NO.                 
           MOVE TL-TRANS-DATA-1-LEN  TO TJ-TRAN-DATA1-LEN.              
           MOVE TL-TRANS-DATA-1-TEXT TO TJ-TRAN-DATA1-TEXT.             
           MOVE TL-TRANS-DATA-2-LEN  TO TJ-TRAN-DATA2-LEN.              
           MOVE TL-TRANS-DATA-2-TEXT TO TJ-TRAN-DATA2-TEXT.             
           MOVE TL-TRANS-DATA-3-LEN  TO TJ-TRAN-DATA3-LEN.              
           MOVE TL-TRANS-DATA-3-TEXT TO TJ-TRAN-DATA3-TEXT.             
           MOVE TL-TRANS-DATA-4-LEN  TO TJ-TRAN-DATA4-LEN.              
           MOVE TL-TRANS-DATA-4-TEXT TO TJ-TRAN-DATA4-TEXT.             
      *                                                                 05460000
           IF TL-TRANS-ID-CD = WS-RONP                                  
               MOVE 'RONP SET TO HOLD - NOT SENDING TO AGL'             
                                     TO TJ-ERROR-TX-TEXT                
               MOVE 37               TO TJ-ERROR-TX-LEN                 
           ELSE                                                         
               MOVE SPACE            TO TJ-ERROR-TX-TEXT                
               MOVE 0                TO TJ-ERROR-TX-LEN
           END-IF.                
      *                                                                 05460000
           PERFORM 1100-SELECT-AGLC-ACCOUNT-INFO    THRU 1100-EXIT.     
      *                                                                 05460000
           PERFORM 1200-SELECT-ACCOUNT-LOC-DATA     THRU 1200-EXIT.     
      *                                                                 05460000
           MOVE SPACES               TO TL-TRANS-DATA-1-TEXT            
                                        TL-TRANS-DATA-2-TEXT            
                                        TL-TRANS-DATA-3-TEXT            
                                        TL-TRANS-DATA-4-TEXT.           
      *                                                                         
           PERFORM 8000-INSERT-TRANS-OUT            THRU 8000-EXIT.     
      *                                                                         
           PERFORM 8100-DELETE-TRANS-INFO           THRU 8100-EXIT.     
      *                                                                         
           PERFORM 7010-FETCH-TRANS-INFO            THRU 7010-EXIT.     
      *                                                                 05460000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05490000
      ****************************************************************  05500000
      **                                                            **  05510000
      **  1100-SELECT-AGLC-ACCOUNT-INFO                             **  05520000
      **                                                            **  05540000
      ****************************************************************  05550000
       1100-SELECT-AGLC-ACCOUNT-INFO.                                   
      *                                                                 05640000
           PERFORM 7600-SELECT-AGLC-ACCOUNT-NO      THRU 7600-EXIT.     
                                                                        
AMG        IF TL-TRANS-ID-CD = WS-MARKET-SWITCH                         
AMG           MOVE XM-ORIG-DIST-ACCT-NO             TO TJ-DIST-ACCT-NO  
AMG        ELSE                                                         
AMG           MOVE XM-DIST-ACCT-NO                  TO TJ-DIST-ACCT-NO  
AMG        END-IF.                                                      
      *                                                                 05640000
       1100-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  05500000
      **                                                            **  05510000
      **  1200-SELECT-ACCOUNT-LOC-DATA                              **  05520000
      **                                                            **  05540000
      ****************************************************************  05550000
       1200-SELECT-ACCOUNT-LOC-DATA.                                    
      *                                                                 05640000
           PERFORM 7100-SELECT-ADDRESS-INFO         THRU 7100-EXIT.     
      *                                                                 05680000
           IF DY-ADDR-PREFIX-1 > SPACES                                 
              MOVE DY-HOUSE-NO       TO WS-HOUSE-NO                     
              MOVE DY-ADDR-PREFIX-1  TO WS-ADDR-PREFIX                  
              MOVE WS-SERV-ADDR      TO TJ-SERV-ADDR-ST-NO              
           ELSE                                                         
              MOVE DY-HOUSE-NO       TO TJ-SERV-ADDR-ST-NO              
           END-IF                                                       
      *                                                                         
           MOVE DY-ADDR-PREFIX-2     TO TJ-SERV-ADDR-ST-CARD            
           MOVE DY-STREET-NAME       TO TJ-SERV-ADDR-ST-NAME            
           MOVE DY-STREET-SUFFIX     TO TJ-SERV-ADDR-ST-THOR            
           MOVE DY-ADDR-SUFFIX       TO TJ-SERV-ADDR-ST-DIR             
                                                                        
           MOVE DY-STREET-LOCATION-1 TO WS-STREET-LOCATION-1.           
           MOVE DY-STREET-LOCATION-2 TO WS-STREET-LOCATION-2.           
           MOVE WS-SERV-ADDR-STRUCT  TO TJ-SERV-ADDR-STRUCT.            
      *                                                                 05680000
           MOVE DY-ZIP-CODE          TO TJ-SERV-ADDR-ZIP-CD             
                                        A4-ZIP-CODE.                    
           MOVE DY-ZIP-CODE-TOKEN    TO A4-ZIP-CODE-TOKEN.              
                                                                        
           PERFORM 7200-SELECT-CITY-STATE           THRU 7200-EXIT.     
      *                                                                 05820000
           MOVE A4-TOWN              TO TJ-SERV-ADDR-CITY.              
           MOVE A4-STATE             TO TJ-SERV-ADDR-STATE.             
      *                                                                 05820000
           PERFORM 7300-SELECT-NAME-INFO            THRU 7300-EXIT.     
      *                                                                 05820000
           EVALUATE DQ-NAME-FORMAT                                      
             WHEN WS-INDIVIDUAL                                         
                MOVE DQ-FIRST-NAME     TO TJ-CUST-NAME-FIRST            
                MOVE DQ-MIDDLE-NAME    TO TJ-CUST-NAME-MID              
                MOVE DQ-LAST-NAME      TO TJ-CUST-NAME-LAST             
                MOVE DQ-TITLE-SUFFIX-1 TO TJ-CUST-NAME-SFX              
                MOVE WS-HOME-1         TO CB-PHONE-TYPE                 
             WHEN WS-BUSINESS                                           
                MOVE SPACES            TO TJ-CUST-NAME-FIRST            
                MOVE SPACES            TO TJ-CUST-NAME-MID              
                MOVE SPACES            TO TJ-CUST-NAME-SFX              
                MOVE DQ-FULL-NAME      TO TJ-CUST-NAME-LAST             
                MOVE WS-BUSINESS-1     TO CB-PHONE-TYPE                 
             WHEN OTHER                                                 
                MOVE SPACES            TO TJ-CUST-NAME-FIRST            
                                          TJ-CUST-NAME-MID              
                                          TJ-CUST-NAME-SFX              
                                          TJ-CUST-NAME-LAST             
                                          CB-PHONE-TYPE                 
                                                                        
           END-EVALUATE.                                                
           MOVE DQ-NAME-FORMAT       TO TJ-CUST-NAME-IND.               
      *                                                                 05930000
           PERFORM 7400-SELECT-CUST-PHONE           THRU 7400-EXIT.     
      *                                                                 05820000
           MOVE CB-PHONE-NO          TO WS-PHONE-NO.                    
           MOVE WS-PHONE-4-6         TO WS-PHONE-HOLD-1.                
           MOVE WS-PHONE-7-10        TO WS-PHONE-HOLD-2.                
           MOVE WS-PHONE-HOLD        TO TJ-CUST-PHONE-NO.               
           MOVE WS-AREA-CD           TO TJ-CUST-AREA-CD.                
           MOVE CB-EXTENSION-NO      TO TJ-CUST-EXT-NO.                 
      *                                                                 05930000
A04876*    PERFORM 7500-SELECT-CUST-STATS           THRU 7500-EXIT.     05920000
      *                                                                 05930000
A04876     MOVE SPACES               TO TJ-CUST-SSN-NO.                 
           MOVE TL-COMPANY-NO        TO TJ-SEB-COMPANY-NO.              
      *                                                                 06112000
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06140000
      ****************************************************************  12090000
      **  7000-OPEN-TRANS-INFO                                      **  12100000
      **      CURSOR DECLARATION OPEN TRANS_INFO_CSR               **   12110000
      ****************************************************************  12130000
       7000-OPEN-TRANS-INFO.                                            
      *                                                                 12150000
           EXEC SQL                                                     
               OPEN TRANS_INFO_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12190000
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                 12210000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
               MOVE SQLCODE             TO RS-RETURN-CODE               
               MOVE 'OPEN'              TO ABEND-FUNCTION               
               MOVE 'CSS_MKT_TRAN_INFO' TO TABLE-1                      
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                 12310000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12340000
      ****************************************************************  12350000
      **  7010-FETCH-TRANS_INFO                                     **  12360000
      **      CURSOR DECLARATION, FETCH TRANS_INFO_CSR              **  12370000
      ****************************************************************  12390000
       7010-FETCH-TRANS-INFO.                                           
      *                                                                 12410000
           EXEC SQL                                                     
               FETCH TRANS_INFO_CSR INTO                                
                   :TL-TRANS-ID-CD,                                     
                   :TL-RECEIVED-TS,                                     
                   :TL-TRANS-OCCURS-TS,                                 
                   :TL-ACCOUNT-NO,                                      
                   :TL-COMPANY-NO,                                      
                   :TL-TRANS-DATA-1,                                    
                   :TL-TRANS-DATA-2,                                    
                   :TL-TRANS-DATA-3,                                    
                   :TL-TRANS-DATA-4                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12530000
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                 12550000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
               MOVE SQLCODE             TO RS-RETURN-CODE               
               MOVE 'FETCH'             TO ABEND-FUNCTION               
               MOVE 'CSS_MKT_TRAN_INFO' TO TABLE-1                      
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                 12650000
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12680000
      ****************************************************************  12690000
      **  7020-CLOSE-TRANS-INFO                                     **  12700000
      **      CURSOR DECLARATION CLOSE TRANS_INFO_CSR               **  12710000
      ****************************************************************  12730000
       7020-CLOSE-TRANS-INFO.                                           
      *                                                                 12750000
           EXEC SQL                                                     
               CLOSE TRANS_INFO_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12790000
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                 12810000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
               MOVE SQLCODE             TO RS-RETURN-CODE               
               MOVE 'CLOSE'             TO ABEND-FUNCTION               
               MOVE 'CSS_MKT_TRAN_INFO' TO TABLE-1                      
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                 12910000
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12941900
      ****************************************************************  11810000
      **  7100-SELECT-ADDRESS-INFO                                  **  11820000
      **      SELECT ADDRESS INFO                                   **  11830000
      ****************************************************************  11840000
       7100-SELECT-ADDRESS-INFO.                                        
      *                                                                 11860000
           EXEC SQL                                                     
               SELECT DY.HOUSE_NO,                                      
                      DY.ADDR_PREFIX_1,                                 
                      DY.ADDR_PREFIX_2,                                 
                      DY.STREET_NAME,                                   
                      DY.STREET_SUFFIX,                                 
                      DY.ADDR_SUFFIX,                                   
                      DY.STREET_LOCATION_1,                             
                      DY.STREET_LOCATION_2,                             
                      DY.ZIP_CODE,                                      
                      DY.ZIP_CODE_TOKEN                                 
               INTO  :DY-HOUSE-NO,                                      
                     :DY-ADDR-PREFIX-1,                                 
                     :DY-ADDR-PREFIX-2,                                 
                     :DY-STREET-NAME,                                   
                     :DY-STREET-SUFFIX,                                 
                     :DY-ADDR-SUFFIX,                                   
                     :DY-STREET-LOCATION-1,                             
                     :DY-STREET-LOCATION-2,                             
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-TOKEN                                 
               FROM   CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_ACCOUNT        AT WITH(READUNCOMMITTED),              
                      CSS_PREMISE        PR WITH(READUNCOMMITTED)               
               WHERE  AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
               AND    PR.PREMISE_NO =  AT.PREMISE_NO                    
               AND    DY.ADDRESS_ID =  PR.ADDRESS_ID                    
T35434                                                           
A04876                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11870000
MFA-TR*        SELECT DY.HOUSE_NO,                                      11880000
MFA-TR*               DY.ADDR_PREFIX_1,                                 11890000
MFA-TR*               DY.ADDR_PREFIX_2,                                 11890000
MFA-TR*               DY.STREET_NAME,                                           
MFA-TR*               DY.STREET_SUFFIX,                                         
MFA-TR*               DY.ADDR_SUFFIX,                                           
MFA-TR*               DY.STREET_LOCATION_1,                                     
MFA-TR*               DY.STREET_LOCATION_2,                                     
MFA-TR*               DY.ZIP_CODE,                                              
MFA-TR*               DY.ZIP_CODE_TOKEN                                         
MFA-TR*        INTO  :DY-HOUSE-NO,                                      11880000
MFA-TR*              :DY-ADDR-PREFIX-1,                                 11890000
MFA-TR*              :DY-ADDR-PREFIX-2,                                 11890000
MFA-TR*              :DY-STREET-NAME,                                           
MFA-TR*              :DY-STREET-SUFFIX,                                         
MFA-TR*              :DY-ADDR-SUFFIX,                                           
MFA-TR*              :DY-STREET-LOCATION-1,                                     
MFA-TR*              :DY-STREET-LOCATION-2,                                     
MFA-TR*              :DY-ZIP-CODE,                                              
MFA-TR*              :DY-ZIP-CODE-TOKEN                                         
MFA-TR*        FROM   CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_ACCOUNT        AT,                                    
MFA-TR*               CSS_PREMISE        PR                                     
MFA-TR*        WHERE  AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    11910000
MFA-TR*        AND    PR.PREMISE_NO =  AT.PREMISE_NO                            
MFA-TR*        AND    DY.ADDRESS_ID =  PR.ADDRESS_ID                            
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                    11920000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11930000
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 11950000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 INITIALIZE DCLCSS-ADDR-FORMATTED                       
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO RS-RETURN-CODE            
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE 'CSS_ACCOUNT'        TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
                 MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
                 MOVE 'CSS_PREMISE'        TO TABLE-2                   
                 MOVE 'CSS_ADDR_FORMATTED' TO TABLE-3                   
                 PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                 12050000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12080000
      ****************************************************************  11810000
      **  7200-SELECT-CITY-STATE                                    **  11820000
      **      SELECT CITY AND STATE FOR A ZIP CODE                  **  11830000
      ****************************************************************  11840000
       7200-SELECT-CITY-STATE.                                          
      *                                                                 11860000
           EXEC SQL                                                     
               SELECT A4.TOWN,                                          
                      A4.STATE                                          
               INTO  :A4-TOWN,                                          
                     :A4-STATE                                          
               FROM   CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                     
               WHERE  A4.ZIP_CODE       = :A4-ZIP-CODE                  
                 AND  A4.ZIP_CODE_TOKEN = :A4-ZIP-CODE-TOKEN            
T35434                                                           
A04876                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11870000
MFA-TR*        SELECT A4.TOWN,                                          11880000
MFA-TR*               A4.STATE                                          11890000
MFA-TR*        INTO  :A4-TOWN,                                          11880000
MFA-TR*              :A4-STATE                                          11890000
MFA-TR*        FROM   CSS_ZIP_CODE A4                                           
MFA-TR*        WHERE  A4.ZIP_CODE       = :A4-ZIP-CODE                  11910000
MFA-TR*          AND  A4.ZIP_CODE_TOKEN = :A4-ZIP-CODE-TOKEN                    
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                    11920000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11930000
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 11950000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 INITIALIZE DCLCSS-ZIP-CODE                             
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO RS-RETURN-CODE            
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE 'CSS_ZIP_CODE'       TO TABLE-1                   
                 MOVE 'ZIP_CODE'           TO TABLE-ELEMENT-1           
                 MOVE A4-ZIP-CODE          TO HOSTVAR-ELEMENT-1         
                 MOVE 'ZIP_CODE_TOKEN'     TO TABLE-ELEMENT-2           
                 MOVE A4-ZIP-CODE-TOKEN    TO HOSTVAR-ELEMENT-2         
                 PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                 12050000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12080000
      ****************************************************************  11810000
      **  7300-SELECT-NAME-INFO                                     **  11820000
      **      SELECT NAME INFORMATION                               **  11830000
      ****************************************************************  11840000
       7300-SELECT-NAME-INFO.                                           
      *                                                                 11860000
           EXEC SQL                                                     
               SELECT DQ.NAME_TYPE,                                     
                      DQ.FIRST_NAME,                                    
                      DQ.MIDDLE_NAME,                                   
                      DQ.LAST_NAME,                                     
                      DQ.TITLE_SUFFIX_1,                                
                      DQ.FULL_NAME,                                     
                      DQ.NAME_FORMAT                                    
               INTO  :DQ-NAME-TYPE,                                     
                     :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-TITLE-SUFFIX-1,                                
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-FORMAT                                    
               FROM   CSS_NAME     DQ WITH(READUNCOMMITTED),                    
                      CSS_ACCOUNT  AT WITH(READUNCOMMITTED),                    
                      CSS_CUSTOMER CU WITH(READUNCOMMITTED)                     
               WHERE  AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                   
               AND    CU.CUSTOMER_NO =  AT.CUSTOMER_NO                  
               AND    DQ.NAME_ID     =  CU.NAME_ID                      
T35434                                                           
A04876                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11870000
MFA-TR*        SELECT DQ.NAME_TYPE,                                     11880000
MFA-TR*               DQ.FIRST_NAME,                                    11890000
MFA-TR*               DQ.MIDDLE_NAME,                                   11890000
MFA-TR*               DQ.LAST_NAME,                                     11890000
MFA-TR*               DQ.TITLE_SUFFIX_1,                                11890000
MFA-TR*               DQ.FULL_NAME,                                             
MFA-TR*               DQ.NAME_FORMAT                                            
MFA-TR*        INTO  :DQ-NAME-TYPE,                                     11880000
MFA-TR*              :DQ-FIRST-NAME,                                    11890000
MFA-TR*              :DQ-MIDDLE-NAME,                                   11890000
MFA-TR*              :DQ-LAST-NAME,                                     11890000
MFA-TR*              :DQ-TITLE-SUFFIX-1,                                11890000
MFA-TR*              :DQ-FULL-NAME,                                             
MFA-TR*              :DQ-NAME-FORMAT                                            
MFA-TR*        FROM   CSS_NAME     DQ,                                          
MFA-TR*               CSS_ACCOUNT  AT,                                          
MFA-TR*               CSS_CUSTOMER CU                                           
MFA-TR*        WHERE  AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                   11910000
MFA-TR*        AND    CU.CUSTOMER_NO =  AT.CUSTOMER_NO                          
MFA-TR*        AND    DQ.NAME_ID     =  CU.NAME_ID                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                    11920000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11930000
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 11950000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 INITIALIZE DCLCSS-NAME                                 
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO RS-RETURN-CODE            
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE 'CSS_ACCOUNT'        TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
                 MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
                 MOVE 'CSS_CUSTOMER'       TO TABLE-2                   
                 MOVE 'CSS_NAME'           TO TABLE-3                   
                 PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                 12050000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12080000
      ****************************************************************  11810000
      **  7400-SELECT-CUST-PHONE                                    **  11820000
      **      SELECT A CUSTOMERS PHONE NUMBER                       **  11830000
      ****************************************************************  11840000
       7400-SELECT-CUST-PHONE.                                          
      *                                                                 11860000
           EXEC SQL                                                     
               SELECT CB.PHONE_NO,                                      
                      CB.EXTENSION_NO                                   
               INTO   :CB-PHONE-NO,                                     
                      :CB-EXTENSION-NO                                  
               FROM   CSS_CUST_PHONE    CB WITH(READUNCOMMITTED),               
                      CSS_ACCOUNT       AT WITH(READUNCOMMITTED)                
               WHERE  AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                   
               AND    CB.CUSTOMER_NO =  AT.CUSTOMER_NO                  
               AND    CB.PHONE_TYPE  = :CB-PHONE-TYPE                   
A04576         AND    CB.CUSTOMER_TYPE = 'C'                            
T35434                                                           
A04876                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11870000
MFA-TR*        SELECT CB.PHONE_NO,                                      11880000
MFA-TR*               CB.EXTENSION_NO                                           
MFA-TR*        INTO   :CB-PHONE-NO,                                     11880000
MFA-TR*               :CB-EXTENSION-NO                                          
MFA-TR*        FROM   CSS_CUST_PHONE    CB,                                     
MFA-TR*               CSS_ACCOUNT       AT                                      
MFA-TR*        WHERE  AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                   11910000
MFA-TR*        AND    CB.CUSTOMER_NO =  AT.CUSTOMER_NO                          
MFA-TR*        AND    CB.PHONE_TYPE  = :CB-PHONE-TYPE                           
MFA-TR*        AND    CB.CUSTOMER_TYPE = 'C'                                    
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                    11920000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11930000
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 11950000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 INITIALIZE DCLCSS-CUST-PHONE                           
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO RS-RETURN-CODE            
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE 'CSS_ACCOUNT'        TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
                 MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
                 MOVE 'CSS_CUST_PHONE'     TO TABLE-2                   
                 MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-2           
                 MOVE CB-PHONE-TYPE        TO HOSTVAR-ELEMENT-2         
                 MOVE 'CSS_CUSTOMER'       TO TABLE-3                   
                 PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                 12050000
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12080000
      ****************************************************************  11810000
      **  7500-SELECT-CUST-STATS                                    **  11820000
      **      SELECT SOCIAL SECURITY NUMBER                         **  11830000
      ****************************************************************  11840000
       7500-SELECT-CUST-STATS.                                          
      *                                                                 11860000
           EXEC SQL                                                     
               SELECT CE.SSN                                            
               INTO  :CE-SSN                                            
               FROM   CSS_CUST_STATS CE WITH(READUNCOMMITTED),                  
                      CSS_ACCOUNT    AT WITH(READUNCOMMITTED)                   
               WHERE  AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                 
                 AND  CE.CUSTOMER_NO   =  AT.CUSTOMER_NO                
T21832           AND  CE.CUSTOMER_TYPE = 'C'                            
T35434                                                           
A04876                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11870000
MFA-TR*        SELECT CE.SSN                                            11880000
MFA-TR*        INTO  :CE-SSN                                            11880000
MFA-TR*        FROM   CSS_CUST_STATS CE,                                        
MFA-TR*               CSS_ACCOUNT    AT                                         
MFA-TR*        WHERE  AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                 11910000
MFA-TR*          AND  CE.CUSTOMER_NO   =  AT.CUSTOMER_NO                        
MFA-TR*          AND  CE.CUSTOMER_TYPE = 'C'                                    
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                    11920000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11930000
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 11950000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 INITIALIZE DCLCSS-CUST-STATS                           
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO RS-RETURN-CODE            
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE 'CSS_ACCOUNT'        TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
                 MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
                 MOVE 'CSS_CUST_STATS'     TO TABLE-2                   
                 PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                 12050000
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12080000
      ****************************************************************  11810000
      **  7600-SELECT-AGLC-ACCOUNT-NO                               **  11820000
      **      SELECT THE AGLC ACCOUNT NUMBER                        **  11830000
      ****************************************************************  11840000
       7600-SELECT-AGLC-ACCOUNT-NO.                                     
      *                                                                 11860000
           EXEC SQL                                                     
               SELECT XM.DIST_ACCT_NO     ,                             
AMG                   XM.ORIG_DIST_ACCT_NO                              
               INTO  :XM-DIST-ACCT-NO     ,                             
AMG                  :XM-ORIG-DIST-ACCT-NO                              
               FROM   CSS_MKT_XREF_ACCT XM WITH(READUNCOMMITTED)                
               WHERE  XM.ACCOUNT_NO  = :XM-ACCOUNT-NO                   
T35434                                                           
A04876                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11870000
MFA-TR*        SELECT XM.DIST_ACCT_NO     ,                             11880000
MFA-TR*               XM.ORIG_DIST_ACCT_NO                                      
MFA-TR*        INTO  :XM-DIST-ACCT-NO     ,                             11880000
MFA-TR*              :XM-ORIG-DIST-ACCT-NO                                      
MFA-TR*        FROM   CSS_MKT_XREF_ACCT XM                                      
MFA-TR*        WHERE  XM.ACCOUNT_NO  = :XM-ACCOUNT-NO                   11910000
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7600                                                     
MFA-TR*    END-EXEC.                                                    11920000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11930000
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 11950000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 INITIALIZE DCLCSS-MKT-XREF-ACCT                        
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO RS-RETURN-CODE            
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE 'CSS_MKT_XREF_ACCT'  TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
                 MOVE XM-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
                 PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                 12050000
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12080000
      ****************************************************************  11810000
      **  7700-SELECT-CURRENT-DATE                                  **  11820000
      **      SELECT ADDRESS INFO                                   **  11830000
      ****************************************************************  11840000
       7700-SELECT-CURRENT-DATE.                                        
      *                                                                 11860000
           EXEC SQL                                                     
T35434         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     11870000
MFA-TR*        SET  :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP           11880000
MFA-TR*    END-EXEC.                                                    11920000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11930000
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 11950000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO RS-RETURN-CODE              
T35434        MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE 'CURRENT TIMESTAMP'   TO TABLE-ELEMENT-1             
              MOVE WS-CURRENT-TIMESTAMP  TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                 12050000
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12080000
      ****************************************************************  12942000
      *                                                             **  12942100
      *   8000-INSERT-TRANS-OUT.                                    **  12942200
      *                                                             **  12942400
      ****************************************************************  12942500
       8000-INSERT-TRANS-OUT.                                           
      *                                                                 12942700
           EXEC SQL                                                     
                INSERT INTO CSS_MKT_TRAN_OUTMF                          
                       (TRANS_ID_CD,                                    
                        TRANS_PRIORITY,                                 
                        RECEIVED_TS,                                    
                        TRANS_SEQ_NO,                                   
                        TRANS_STATUS_CD,                                
                        TRANS_OCCURS_TS,                                
                        DIST_ACCT_NO,                                   
                        SERV_ADDR_ST_NO,                                
                        SERV_ADDR_ST_CARD,                              
                        SERV_ADDR_ST_NAME,                              
                        SERV_ADDR_ST_THOR,                              
                        SERV_ADDR_ST_DIR,                               
                        SERV_ADDR_STRUCT,                               
                        SERV_ADDR_CITY,                                 
                        SERV_ADDR_STATE,                                
                        SERV_ADDR_ZIP_CD,                               
                        CUST_NAME_IND,                                  
                        CUST_NAME_FIRST,                                
                        CUST_NAME_MID,                                  
                        CUST_NAME_LAST,                                 
                        CUST_NAME_SFX,                                  
                        CUST_SSN_NO,                                    
                        CUST_AREA_CD,                                   
                        CUST_PHONE_NO,                                  
                        CUST_EXT_NO,                                    
                        TRAN_DATA1,                                     
                        TRAN_DATA2,                                     
                        TRAN_DATA3,                                     
                        TRAN_DATA4,                                     
                        PROCESS_TS,                                     
                        RETURN_CD,                                      
                        ERROR_TX,                                       
                        SEB_ACCT_NO,                                    
                        SEB_COMPANY_NO,                                 
                        LAST_UPDATED_BY)                                
                VALUES (:TJ-TRANS-ID-CD,                                
                        :TJ-TRANS-PRIORITY,                             
                        CIS.CHAR2TIMESTAMP(:TJ-RECEIVED-TS),                    
                        :TJ-TRANS-SEQ-NO,                               
                        :TJ-TRANS-STATUS-CD,                            
                        CIS.CHAR2TIMESTAMP(:TJ-TRANS-OCCURS-TS),                
                        :TJ-DIST-ACCT-NO,                               
                        :TJ-SERV-ADDR-ST-NO,                            
                        :TJ-SERV-ADDR-ST-CARD,                          
                        :TJ-SERV-ADDR-ST-NAME,                          
                        :TJ-SERV-ADDR-ST-THOR,                          
                        :TJ-SERV-ADDR-ST-DIR,                           
                        :TJ-SERV-ADDR-STRUCT,                           
                        :TJ-SERV-ADDR-CITY,                             
                        :TJ-SERV-ADDR-STATE,                            
                        :TJ-SERV-ADDR-ZIP-CD,                           
                        :TJ-CUST-NAME-IND,                              
                        :TJ-CUST-NAME-FIRST,                            
                        :TJ-CUST-NAME-MID,                              
                        :TJ-CUST-NAME-LAST,                             
                        :TJ-CUST-NAME-SFX,                              
                        :TJ-CUST-SSN-NO,                                
                        :TJ-CUST-AREA-CD,                               
                        :TJ-CUST-PHONE-NO,                              
                        :TJ-CUST-EXT-NO,                                
                        :TJ-TRAN-DATA1,                                 
                        :TJ-TRAN-DATA2,                                 
                        :TJ-TRAN-DATA3,                                 
                        :TJ-TRAN-DATA4,                                 
                        NULL,                                           
                        NULL,                                           
                        :TJ-ERROR-TX,                                   
                        :TJ-SEB-ACCT-NO,                                
                        :TJ-SEB-COMPANY-NO,                             
                        'SYSTEM')                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     12943000
MFA-TR*         INSERT INTO CSS_MKT_TRAN_OUTMF                          12943100
MFA-TR*                (TRANS_ID_CD,                                            
MFA-TR*                 TRANS_PRIORITY,                                         
MFA-TR*                 RECEIVED_TS,                                            
MFA-TR*                 TRANS_SEQ_NO,                                           
MFA-TR*                 TRANS_STATUS_CD,                                        
MFA-TR*                 TRANS_OCCURS_TS,                                        
MFA-TR*                 DIST_ACCT_NO,                                           
MFA-TR*                 SERV_ADDR_ST_NO,                                        
MFA-TR*                 SERV_ADDR_ST_CARD,                                      
MFA-TR*                 SERV_ADDR_ST_NAME,                                      
MFA-TR*                 SERV_ADDR_ST_THOR,                                      
MFA-TR*                 SERV_ADDR_ST_DIR,                                       
MFA-TR*                 SERV_ADDR_STRUCT,                                       
MFA-TR*                 SERV_ADDR_CITY,                                         
MFA-TR*                 SERV_ADDR_STATE,                                        
MFA-TR*                 SERV_ADDR_ZIP_CD,                                       
MFA-TR*                 CUST_NAME_IND,                                          
MFA-TR*                 CUST_NAME_FIRST,                                        
MFA-TR*                 CUST_NAME_MID,                                          
MFA-TR*                 CUST_NAME_LAST,                                         
MFA-TR*                 CUST_NAME_SFX,                                          
MFA-TR*                 CUST_SSN_NO,                                            
MFA-TR*                 CUST_AREA_CD,                                           
MFA-TR*                 CUST_PHONE_NO,                                          
MFA-TR*                 CUST_EXT_NO,                                            
MFA-TR*                 TRAN_DATA1,                                             
MFA-TR*                 TRAN_DATA2,                                             
MFA-TR*                 TRAN_DATA3,                                             
MFA-TR*                 TRAN_DATA4,                                             
MFA-TR*                 PROCESS_TS,                                             
MFA-TR*                 RETURN_CD,                                              
MFA-TR*                 ERROR_TX,                                               
MFA-TR*                 SEB_ACCT_NO,                                            
MFA-TR*                 SEB_COMPANY_NO,                                         
MFA-TR*                 LAST_UPDATED_BY)                                        
MFA-TR*         VALUES (:TJ-TRANS-ID-CD,                                        
MFA-TR*                 :TJ-TRANS-PRIORITY,                                     
MFA-TR*                 :TJ-RECEIVED-TS,                                        
MFA-TR*                 :TJ-TRANS-SEQ-NO,                                       
MFA-TR*                 :TJ-TRANS-STATUS-CD,                                    
MFA-TR*                 :TJ-TRANS-OCCURS-TS,                                    
MFA-TR*                 :TJ-DIST-ACCT-NO,                                       
MFA-TR*                 :TJ-SERV-ADDR-ST-NO,                                    
MFA-TR*                 :TJ-SERV-ADDR-ST-CARD,                                  
MFA-TR*                 :TJ-SERV-ADDR-ST-NAME,                                  
MFA-TR*                 :TJ-SERV-ADDR-ST-THOR,                                  
MFA-TR*                 :TJ-SERV-ADDR-ST-DIR,                                   
MFA-TR*                 :TJ-SERV-ADDR-STRUCT,                                   
MFA-TR*                 :TJ-SERV-ADDR-CITY,                                     
MFA-TR*                 :TJ-SERV-ADDR-STATE,                                    
MFA-TR*                 :TJ-SERV-ADDR-ZIP-CD,                                   
MFA-TR*                 :TJ-CUST-NAME-IND,                                      
MFA-TR*                 :TJ-CUST-NAME-FIRST,                                    
MFA-TR*                 :TJ-CUST-NAME-MID,                                      
MFA-TR*                 :TJ-CUST-NAME-LAST,                                     
MFA-TR*                 :TJ-CUST-NAME-SFX,                                      
MFA-TR*                 :TJ-CUST-SSN-NO,                                        
MFA-TR*                 :TJ-CUST-AREA-CD,                                       
MFA-TR*                 :TJ-CUST-PHONE-NO,                                      
MFA-TR*                 :TJ-CUST-EXT-NO,                                        
MFA-TR*                 :TJ-TRAN-DATA1,                                         
MFA-TR*                 :TJ-TRAN-DATA2,                                         
MFA-TR*                 :TJ-TRAN-DATA3,                                         
MFA-TR*                 :TJ-TRAN-DATA4,                                         
MFA-TR*                 NULL,                                                   
MFA-TR*                 NULL,                                                   
MFA-TR*                 :TJ-ERROR-TX,                                           
MFA-TR*                 :TJ-SEB-ACCT-NO,                                        
MFA-TR*                 :TJ-SEB-COMPANY-NO,                                     
MFA-TR*                 'SYSTEM')                                               
MFA-TR*    END-EXEC.                                                    12943200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12943300
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 12943500
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO RS-RETURN-CODE              
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE 'CSS_MKT_TRANS_OUT'  TO TABLE-1                     
               MOVE 'SEB_ACCOUNT_NO'     TO TABLE-ELEMENT-1             
               MOVE TJ-SEB-ACCT-NO       TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                 12944400
       8000-EXIT.                                                       
            EXIT.                                                       
      *                                                                 19040000
      ****************************************************************  12942000
      *                                                             **  12942100
      *   8100-DELETE-TRANS-INFO.                                   **  12942200
      *                                                             **  12942400
      ****************************************************************  12942500
       8100-DELETE-TRANS-INFO.                                          
      *                                                                 12942700
           EXEC SQL                                                     
                DELETE FROM CSS_MKT_TRAN_INFO                           
                 WHERE TRANS_ID_CD = :TL-TRANS-ID-CD                    
                   AND RECEIVED_TS = CIS.CHAR2TIMESTAMP(:TL-RECEIVED-TS)        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     12943000
MFA-TR*         DELETE FROM CSS_MKT_TRAN_INFO                           12943100
MFA-TR*          WHERE TRANS_ID_CD = :TL-TRANS-ID-CD                            
MFA-TR*            AND RECEIVED_TS = :TL-RECEIVED-TS                            
MFA-TR*    END-EXEC.                                                    12943200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12943300
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 12943500
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO RS-RETURN-CODE              
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE 'CSS_MKT_TRANS_INFO' TO TABLE-1                     
               MOVE 'TRANS_ID_CD'        TO TABLE-ELEMENT-1             
               MOVE TL-TRANS-ID-CD       TO HOSTVAR-ELEMENT-1           
               MOVE 'RECEIVED_TS'        TO TABLE-ELEMENT-2             
               MOVE TL-RECEIVED-TS       TO HOSTVAR-ELEMENT-2           
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                 12944400
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                 12944400
      ****************************************************************  19190000
      **                                                            **  19200000
      **  9000-TERMINATE                                            **  19210000
      **                                                            **  19220000
      ****************************************************************  19230000
      *                                                                 19231000
       9000-TERMINATE.                                                  
      *                                                                 19250000
      *                                                                 19270000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19300000
      ****************************************************************  19310900
      *  9700-PROCESS-ABEND.                                         *  19311000
      ****************************************************************  19311100
           EXEC SQL                                                     19311200
               INCLUDE CPD0023B                                         19311300
           END-EXEC.                                                    19311400
                                                                        
HPCCDM*    EJECT                                                        19311600
      *                                                                 19311700
      **************************************************************    19313800
      * CPD09900   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE   *    19313900
      * 9900-ABEND                                                 *    19314000
      **************************************************************    19314100
      *                                                                 19314200
           EXEC SQL                                                     19314300
               INCLUDE CPD09900                                         19314400
           END-EXEC.                                                    19314500
