       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSGA317.                                        
       DATE-WRITTEN.   03/26/01.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC AND GAS                **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      ********            CUSTOMER INFORMATION SYSTEM         *********         
      *****************************************************************         
      **                  P R O G R A M S U M M A R Y                **         
      **                                                             **         
      **                                                             **         
      **           F U N C T I O N A L    D E S C R I P T I O N      **         
      **                           O F    M O D U L E                **         
      **                                                             **         
      **                                                             **         
      **  PURPOSE :                                                  **         
      **                                                             **         
      **  BREAKOUT TAX GLS INTO LOCAL OFFICE AND COUNTY FOR PSNC.    **         
      **  ALSO REPORT SOME CONTRACT INFO BY OFFICE FOR PSNC.         **         
      **  TAXES:                                                                
      **  GL 241.1000 NEEDS TO BE REPORTED BY LOCAL OFFICE.          **         
      **  GL 241.0213 NEEDS TO BE REPORTED BY COUNTY.                **         
      **                                                             **         
      **  OTHER CONTRACT INFO:                                       **         
      ** -WHITE GOOD DISPOSAL FEE 241.0910                           **         
      ** -INTEREST CHARGES AKA FINANCE CHARGES - THESE ARE OBTAINED  **         
      **    FROM THE 2 INTEREST GLS IN THE CSS_CONTRACT_INFO TABLE.  **         
      ** -REVENUE CHARGES AKA CONTRACT AMT - THESE ARE OBTAINED FROM **         
      **    THE GL_ACCT_NO FIELD IN THE CSS_CONTRACT_INFO TABLE.     **         
      **                                                             **         
      **  THE 241.1000 IS USED BY BOTH COMPANIES AND REPRESENTS STATE**         
      **  TAX ON NON-ENERGY CHARGES.                                 **         
      **  THE 241.0213 IS USED ONLY BY PSNC AND REPRESENTS THE 2%    **         
      **  COUNTY TAX.  ANY 241.0213 ROWS IN THE GL_ENTRY_CRNT TABLE  **         
      **  SHOULD HAVE A REVENUE DISTRICT CODE POPULATED.             **         
      **                                                             **         
      **  LOGIC:                                                     **         
      **  THE PROGRAM USES WS-CURSOR-FLAG TO DETERMINE WHICH GL WE   **         
      **  ARE PROCESSING. A VALUE OF '1' REPRESENTS WHEN WE ONLY HAVE**         
      **  ONE GL NUMBER TO PROCESS, EG, 241.1000 IS THE ONLY GL USED **         
      **  FOR STATE CONTRACT TAX. INTEREST CHARGES USE SEVERAL GLS SO**         
      **  THEY ARE ASSIGNED A DIFFERENT VALUE TO WS-CURSOR-FLAG.     **         
      **  WE USE MULTIPLE GL NUMBERS TO REPORT THE FINANCE CHARGES   **         
      **  AND REVENUE.  A TABLE IS BUILD WHOSE MAIN KEY IS LOCAL     **         
      **  OFFICE, SO WE CAN TRACK ALL OF THE GLS BEFORE PRINTING.    **         
      **                                                             **         
      **  THE PROGRAM CREATES A MONTHLY.                             **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  _________    __________________________________  **         
      **  03/26/01  CHANELLE K.  ORIGINAL CODE.                      **         
      **  09/11/01  CHANELLE K.  ALSO DISPLAY WHITE GOODS DISPOSAL,  **         
      **                         CONTRACT REVENUE AND INTEREST.      **         
      **  10/17/01  CHANELLE K.  25432. REMOVE 3RD PARTY CONTRACTS   **         
      **                         WHEN REPORTING CONTRACT REVENUE.    **         
      **                                                             **         
C37783**  7 OCT 2008 RF10596     PUT TOTALS ON REPORTS AND CORRECTED **         
      **                         HEADER LINES.   REMOVED CWS00079    **         
      **                         ADD WITH UR TO CURSORS              **         
      **                                                             **         
A04527**  1 FEB 2014 RF10596     ADD GLS 241.0123 / 241.0207         **         
      **                                                             **         
      *****************************************************************         
           REMARKS.                                                     
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSGA317'.
MSQ017     COPY MFASQLM.
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBGLENT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBRVDST                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBSTCNTY                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCNTINF                                                 
           END-EXEC.                                                            
      *                                                                         
       01  WS-MISC.                                                     
T20122     05  WS-RUN-FREQ                      PIC X(01) VALUE 'M'.    
T20122         88 DAILY-RUN VALUE 'D'.                                  
T20122         88 MTHLY-RUN VALUE ' ' 'M'.                              
      *                                                                         
           05  WS-MULTI-GL-TABLE OCCURS 100 TIMES                       
               INDEXED BY WS-GL-INDX.                                   
               15  WS-CODE-TABLE                PIC X(03).              
               15  WS-DESC-TABLE                PIC X(22).              
               15  WS-BALANCE-TABLE             PIC S9(09)V99 COMP-3    
                                                    VALUE ZEROES.       
      *                                                                         
           05  WS-CURRENT-TIME.                                         
               10  WS-HH               PIC X(02)    VALUE SPACES.       
               10  WS-MM               PIC X(02)    VALUE SPACES.       
               10  WS-SS               PIC X(02)    VALUE SPACES.       
               10  WS-TT               PIC X(02)    VALUE SPACES.       
      *                                                                         
           05  WS-CURRENT-DATE.                                         
               10  WS-CY               PIC 9(02)    VALUE ZEROES.       
               10  WS-CM               PIC 9(02)    VALUE ZEROES.       
               10  WS-CD               PIC X(02)    VALUE SPACES.       
      *                                                                         
C37783 01 WS-QUARTERLY-HEADER.                                          
C37783    05 WS-QRT-1                  PIC X(14)                        
C37783       VALUE '  QUARTERLY RE'.                                    
C37783    05 WS-QRT-2                  PIC X(8)                         
C37783       VALUE 'PORT    '.                                          
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CC               PIC X(02).                       
           05  WS-D10-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-DD               PIC X(02).                       
      *                                                                         
       01  WS-DATE-TEMP.                                                
           05  WS-DAT-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-DAT-DD               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-DAT-YY               PIC X(02).                       
      *                                                                         
       01  WS-DATE-8.                                                   
           05  WS-D8-MM                PIC 9(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
T15599     05  WS-D8-CCYY              PIC 9(04).                       
      *                                                                         
       01  WS-RP-DATE.                                                  
           05  WS-RP-CCYY              PIC 9(04).                       
           05  WS-RP-MM                PIC 9(02).                       
      *                                                                         
       01  WS-DATE-CAS.                                                 
           05  WS-DCA-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-DCA-DD               PIC X(02)    VALUE '01'.         
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-DCA-YY               PIC X(02).                       
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      /****** JOBS FILE/TABLE DEFINITIONS                                       
           COPY FIOCA00.                                                        
           COPY FIOJC01.                                                        
      /****** CWS00038 IS JC01 WORK DATA                                        
       COPY CWS00038.                                                           
T15599 COPY CWS00114.                                                           
      /****** CWS00039 IS CA00 WORK DATA                                        
       COPY CWS00039.                                                           
      *                                                                 04520000
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
       01  WS-RPT1-LINE-NO             PIC 9(02)    VALUE 0.            
       01  WS-RPT1-PAGE-NO             PIC 9(02)    VALUE ZERO COMP-3.  
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-FLAG                 PIC X(01)    VALUE 'Y'.          
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSGA317'.   
           05  WS-51                   PIC 9(02)    VALUE 51.           
       01 WS-MISC.                                                      
A04527     05  WS-CLEAR-GL             PIC S9(3)V9(4) COMP-3            
                                          VALUE 888.8888.               
A04527     05  WS-CURSOR-GL            PIC S9(3)V9(4) COMP-3 VALUE 0.   
A04527     05  WS-SVCCARE-SALES        PIC S9(3)V9(4) COMP-3            
                                          VALUE 241.0123.               
A04527     05  WS-COUNTY-LOST          PIC S9(3)V9(4) COMP-3            
                                          VALUE 241.0207.               
C37783     05  WS-TOTAL                PIC S9(9)V99 COMP-3 VALUE 0.     
           05  WS-SUM                  PIC S9(09)V99 COMP-3             
                                                    VALUE ZEROES.       
           05  WS-GE-SUM               PIC S9(09)V99 COMP-3             
                                                    VALUE ZEROES.       
           05  WS-PARM-REV-MTH         PIC S9(09) COMP                  
                                                    VALUE ZEROES.       
           05  WS-PARM-REV-MTH-PREV1   PIC S9(09) COMP                  
                                                    VALUE ZEROES.       
           05  WS-PARM-REV-MTH-PREV2   PIC S9(09) COMP                  
                                                    VALUE ZEROES.       
           05  WS-PREV-OFFICE          PIC X(03)    VALUE SPACES.       
           05  WS-PREV-COUNTY          PIC X(03)    VALUE SPACES.       
           05  WS-RP-DATE-NUM          PIC 9(06)    VALUE ZEROES.       
           05  WS-CURSOR-FLAG          PIC X(01)    VALUE SPACES.       
           05  WS-HOLD-INDEX           PIC S9(04) COMP VALUE ZEROES.    
      *                                                                 03200000
C37783 01 WS-TITLE-1                   PIC X(17)                        
           VALUE '     DISPOSAL FEE'.                                   
C37783 01 WS-TITLE-2                   PIC X(19)                        
           VALUE '    FINANCE CHARGES'.                                 
C37783 01 WS-TITLE-3                   PIC X(19)                        
           VALUE '    CONTRACT AMOUNT'.                                 
C37783 01 WS-TITLE-4                   PIC X(16)                        
           VALUE '      COUNTY TAX'.                                    
C37783 01 WS-TITLE-5                   PIC X(23)                        
           VALUE 'NC STATE TAX BY LOC OFF'.                             
      *                                                                 03200000
C37783 01 WS-RUN-TIME.                                                  
C37783    05 WS-RT-HH                PIC XX    VALUE SPACES.            
C37783    05 FILLER                  PIC X     VALUE ':'.               
C37783    05 WS-RT-MM                PIC XX    VALUE SPACES.            
C37783    05 FILLER                  PIC X     VALUE ':'.               
C37783    05 WS-RT-SS                PIC XX    VALUE SPACES.            
      *                                                                         
C37783 01 WS-RUN-DATE.                                                  
C37783    05 WS-RD-MM                PIC XX    VALUE SPACES.            
C37783    05 FILLER                  PIC X     VALUE '/'.               
C37783    05 WS-RD-DD                PIC XX    VALUE SPACES.            
C37783    05 FILLER                  PIC X     VALUE '/'.               
C37783    05 WS-RD-YY                PIC XX    VALUE SPACES.            
      *                                                                         
C37783 01 WS-RPT1-TITLE.                                                
C37783    05 P-RPT1-PGRMNAME         PIC X(8)  VALUE SPACES.            
C37783    05 FILLER                  PIC X(52) VALUE SPACES.            
C37783    05 P-RPT1-COMPANY-NAME     PIC X(26) VALUE SPACES.            
C37783    05 FILLER                  PIC X(27) VALUE SPACES.            
C37783    05 FILLER                  PIC X(11) VALUE 'RUN DATE:  '.     
C37783    05 P-RPT1-RUN-DATE         PIC X(8)  VALUE SPACES.            
      *                                                                         
C37783 01 WS-RPT1-HEADER-2.                                             
C37783    05 FILLER                  PIC X(55) VALUE SPACES.            
C37783    05 P-RPT1-CURRENT          PIC X(14) VALUE 'CURRENT AS OF '.  
C37783    05 P-RPT1-REPORT-DATE      PIC X(8)  VALUE SPACES.            
C37783    05 FILLER                  PIC X(38) VALUE SPACES.            
C37783    05 FILLER                  PIC X(9)  VALUE 'PAGE:    '.       
C37783    05 P-RPT1-PAGE-NO          PIC ZZ,ZZZ.                        
C37783    05 FILLER                  PIC XX    VALUE SPACES.            
      *                                                                         
C37783 01 WS-RPT1-HDR-1.                                                
C37783    05 FILLER                  PIC X(16)                          
C37783       VALUE 'REVENUE MONTH : '.                                  
C37783    05 P-RPT1-REPT-MNTH        PIC X(7)  VALUE SPACES.            
C37783    05 FILLER                  PIC X(31) VALUE SPACES.            
C37783    05 P-RPT1-HDR              PIC X(50) VALUE SPACES.            
C37783    05 FILLER                  PIC X(9)  VALUE SPACES.            
C37783    05 FILLER                  PIC X(11) VALUE 'RUN TIME: '.      
C37783    05 P-RPT1-RUN-TM           PIC X(8)  VALUE SPACES.            
      *                                                                         
C37783 01 WS-RPT1-HDR-3.                                                
C37783    05 FILLER                  PIC XX    VALUE SPACES.            
C37783    05 P-HDR-DESC              PIC X(12) VALUE SPACES.            
C37783    05 FILLER                  PIC X(25) VALUE SPACES.            
C37783    05 FILLER                  PIC X(7)  VALUE 'BALANCE'.         
C37783    05 FILLER                  PIC X(86) VALUE SPACES.            
      *                                                                         
C37783 01 WS-DTL-LINE.                                                  
C37783    05 FILLER                  PIC XX    VALUE SPACES.            
C37783    05 P-CODE                  PIC X(3)  VALUE SPACES.            
C37783    05 FILLER                  PIC X     VALUE SPACES.            
C37783    05 P-DESC                  PIC X(20) VALUE SPACES.            
C37783    05 FILLER                  PIC X(5)  VALUE SPACES.            
C37783    05 P-BALANCE               PIC -ZZZ,ZZZ,ZZZ.99.               
C37783    05 FILLER                  PIC X(86) VALUE SPACES.            
      *                                                                         
C37783 01 WS-NO-DATA-LINE.                                              
C37783    05 FILLER                  PIC X(55) VALUE SPACES.            
C37783    05 FILLER                  PIC X(22)                          
C37783       VALUE '** NO DATA THIS RUN **'.                            
C37783    05 FILLER                  PIC X(55) VALUE SPACES.            
      *                                                                         
C37783 01 WS-END-DATA-LINE.                                             
C37783    05 FILLER                  PIC X(55) VALUE SPACES.            
C37783    05 FILLER                  PIC X(22)                          
C37783       VALUE '*** END OF REPORT ***'.                             
C37783    05 FILLER                  PIC X(55) VALUE SPACES.            
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS     **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
               DECLARE STATE_CURSOR CURSOR FOR                          
                   SELECT SUM(AMT_TRAN_ENTRY),                          
                          GE.LOCAL_OFFICE,                              
                          GE.GL_CNTRL_DR_CR                             
                   FROM   CSS_GL_ENTRY_CRNT GE WITH(READUNCOMMITTED),           
                          CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)             
                   WHERE  GE.LOCAL_OFFICE       = B1.LOCAL_OFFICE       
                   AND    B1.COMPANY_NO         = '26'                  
                   AND    GE.COMPANY_NO         = '01'                  
                   AND    GE.ACCT_PERIOD_AFFCTD = :WS-PARM-REV-MTH      
A04527             AND    ((GE.GL_ACCT_NO = :GE-GL-ACCT-NO)             
A04527                   OR  (GE.GL_ACCT_NO = :WS-CURSOR-GL))           
                   GROUP BY GE.LOCAL_OFFICE, GE.GL_CNTRL_DR_CR          
                   ORDER BY GE.LOCAL_OFFICE                             
C37783             FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE STATE_CURSOR CURSOR FOR                                  
MFA-TR*            SELECT SUM(AMT_TRAN_ENTRY),                                  
MFA-TR*                   GE.LOCAL_OFFICE,                                      
MFA-TR*                   GE.GL_CNTRL_DR_CR                                     
MFA-TR*            FROM   CSS_GL_ENTRY_CRNT GE,                                 
MFA-TR*                   CSS_LOCAL_OFFICE B1                                   
MFA-TR*            WHERE  GE.LOCAL_OFFICE       = B1.LOCAL_OFFICE               
MFA-TR*            AND    B1.COMPANY_NO         = '26'                          
MFA-TR*            AND    GE.COMPANY_NO         = '01'                          
MFA-TR*            AND    GE.ACCT_PERIOD_AFFCTD = :WS-PARM-REV-MTH              
MFA-TR*            AND    ((GE.GL_ACCT_NO = :GE-GL-ACCT-NO)                     
MFA-TR*                  OR  (GE.GL_ACCT_NO = :WS-CURSOR-GL))                   
MFA-TR*            GROUP BY GE.LOCAL_OFFICE, GE.GL_CNTRL_DR_CR                  
MFA-TR*            ORDER BY GE.LOCAL_OFFICE                                     
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE QTRSTATE_CURSOR CURSOR FOR                       
                   SELECT SUM(AMT_TRAN_ENTRY),                          
                          GE.LOCAL_OFFICE,                              
                          GE.GL_CNTRL_DR_CR                             
                   FROM   CSS_GL_ENTRY_CRNT GE WITH(READUNCOMMITTED),           
                          CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)             
                   WHERE  GE.LOCAL_OFFICE       = B1.LOCAL_OFFICE       
                   AND    B1.COMPANY_NO         = '26'                  
                   AND    GE.COMPANY_NO         = '01'                  
                   AND     GE.ACCT_PERIOD_AFFCTD IN (:WS-PARM-REV-MTH,  
                                               :WS-PARM-REV-MTH-PREV1,  
                                               :WS-PARM-REV-MTH-PREV2)  
A04527             AND    ((GE.GL_ACCT_NO = :GE-GL-ACCT-NO)             
A04527                   OR  (GE.GL_ACCT_NO = :WS-CURSOR-GL))           
                   GROUP BY GE.LOCAL_OFFICE, GE.GL_CNTRL_DR_CR          
                   ORDER BY GE.LOCAL_OFFICE                             
C37783             FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE QTRSTATE_CURSOR CURSOR FOR                               
MFA-TR*            SELECT SUM(AMT_TRAN_ENTRY),                                  
MFA-TR*                   GE.LOCAL_OFFICE,                                      
MFA-TR*                   GE.GL_CNTRL_DR_CR                                     
MFA-TR*            FROM   CSS_GL_ENTRY_CRNT GE,                                 
MFA-TR*                   CSS_LOCAL_OFFICE B1                                   
MFA-TR*            WHERE  GE.LOCAL_OFFICE       = B1.LOCAL_OFFICE               
MFA-TR*            AND    B1.COMPANY_NO         = '26'                          
MFA-TR*            AND    GE.COMPANY_NO         = '01'                          
MFA-TR*            AND     GE.ACCT_PERIOD_AFFCTD IN (:WS-PARM-REV-MTH,          
MFA-TR*                                        :WS-PARM-REV-MTH-PREV1,          
MFA-TR*                                        :WS-PARM-REV-MTH-PREV2)          
MFA-TR*            AND    ((GE.GL_ACCT_NO = :GE-GL-ACCT-NO)                     
MFA-TR*                  OR  (GE.GL_ACCT_NO = :WS-CURSOR-GL))                   
MFA-TR*            GROUP BY GE.LOCAL_OFFICE, GE.GL_CNTRL_DR_CR                  
MFA-TR*            ORDER BY GE.LOCAL_OFFICE                                     
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
25432 ***  3RD PARTY CONTRACTS SHOULD NOT BE INCLUDED WHEN                      
25432 ***  REPORTING CONTRACT REVENUE. KAY OTTINGER AND GEORGE                  
25432 ***  KAST GAVE ME THIS LIST OF CONTRACTS TO EXCLUDE                       
25432 ***  1080 3RD PARTY FINANCING                                             
25432 ***  1083 NEW CONSTRUCTION NO SALE                                        
25432 ***  1511 INTERIOR PIPE PROTECTION PLAN                                   
25432 ***  1515 SEASONAL RECONNECT FEE                                          
25432 ***  1516 AFTER HOURS SERVICE CHARGE                                      
25432 ***  1518 PSNC SERVICE CHARGE                                             
25432 ***  1600 DISTRIBUTION MAIN DAMAGE                                        
25432 ***  1601 DISTRIBUTION SERVICE DAMAGE                                     
25432 ***  1602 FARM TAP DAMAGE                                                 
25432 ***  1603 METER SITE DAMAGE                                               
25432 ***  1604 DISTRICT REGULATOR DAMAGE                                       
25432 ***  1605 TRANSMISSION LINE DAMAGE                                        
25432 ***  1606 FACILITIES DAMAGE GAS LOSS                                      
           EXEC SQL                                                     
               DECLARE REV_CURSOR CURSOR FOR                            
                  SELECT DISTINCT(K6.GL_ACCT_NO)                        
                    FROM CSS_CONTRACT_INFO K6 WITH(READUNCOMMITTED)             
                   WHERE K6.COMPANY_NO = '26'                           
25432                AND K6.CNT_NAME_CD NOT IN (1080, 1083,             
25432                    1511, 1515, 1516, 1518, 1600,                  
25432                    1601, 1602, 1603, 1604, 1605, 1606)            
                     AND K6.GL_ACCT_NO <> 999.9999                      
C37783             FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE REV_CURSOR CURSOR FOR                                    
MFA-TR*           SELECT DISTINCT(K6.GL_ACCT_NO)                                
MFA-TR*             FROM CSS_CONTRACT_INFO K6                                   
MFA-TR*            WHERE K6.COMPANY_NO = '26'                                   
MFA-TR*              AND K6.CNT_NAME_CD NOT IN (1080, 1083,                     
MFA-TR*                  1511, 1515, 1516, 1518, 1600,                          
MFA-TR*                  1601, 1602, 1603, 1604, 1605, 1606)                    
MFA-TR*              AND K6.GL_ACCT_NO <> 999.9999                              
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
     *                                                                  
           EXEC SQL                                                     
               DECLARE FINANCE_CURSOR CURSOR FOR                        
                  SELECT DISTINCT(GL_ACCT_NO_ERN_INT)                   
                    FROM CSS_CONTRACT_INFO K6 WITH(READUNCOMMITTED)             
                   WHERE K6.COMPANY_NO = '26'                           
                     AND GL_ACCT_NO_ERN_INT <> 999.9999                 
                 UNION                                                  
                  SELECT DISTINCT(K6.GL_ACCT_NO_DEF_INT)                
                    FROM CSS_CONTRACT_INFO K6 WITH(READUNCOMMITTED)             
                   WHERE K6.COMPANY_NO = '26'                           
                     AND GL_ACCT_NO_DEF_INT <> 999.9999                 
                   ORDER BY 1                                           
C37783             FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE FINANCE_CURSOR CURSOR FOR                                
MFA-TR*           SELECT DISTINCT(GL_ACCT_NO_ERN_INT)                           
MFA-TR*             FROM CSS_CONTRACT_INFO K6                                   
MFA-TR*            WHERE K6.COMPANY_NO = '26'                                   
MFA-TR*              AND GL_ACCT_NO_ERN_INT <> 999.9999                         
MFA-TR*          UNION                                                          
MFA-TR*           SELECT DISTINCT(K6.GL_ACCT_NO_DEF_INT)                        
MFA-TR*             FROM CSS_CONTRACT_INFO K6                                   
MFA-TR*            WHERE K6.COMPANY_NO = '26'                                   
MFA-TR*              AND GL_ACCT_NO_DEF_INT <> 999.9999                         
MFA-TR*            ORDER BY 1                                                   
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
     *                                                                  
           EXEC SQL                                                     
               DECLARE COUNTY_CURSOR CURSOR FOR                         
                   SELECT SUM(AMT_TRAN_ENTRY),                          
                          COUNTY,                                       
                          GL_CNTRL_DR_CR                                
                   FROM   CSS_GL_ENTRY_CRNT GE WITH(READUNCOMMITTED),           
                          CSS_REV_DISTRICT A9 WITH(READUNCOMMITTED),            
                          CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)             
A04527             WHERE  GE.GL_ACCT_NO IN (241.0213, 241.0207)         
                   AND    GE.ACCT_PERIOD_AFFCTD = :WS-PARM-REV-MTH      
                   AND    GE.COMPANY_NO         = '01'                  
                   AND    B1.COMPANY_NO         = '26'                  
                   AND    GE.REV_DISTRICT_CD = A9.REV_DISTRICT_CD       
                   AND    GE.LOCAL_OFFICE    = B1.LOCAL_OFFICE          
                   GROUP BY COUNTY, GL_CNTRL_DR_CR                      
                   ORDER BY COUNTY                                      
C37783             FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE COUNTY_CURSOR CURSOR FOR                                 
MFA-TR*            SELECT SUM(AMT_TRAN_ENTRY),                                  
MFA-TR*                   COUNTY,                                               
MFA-TR*                   GL_CNTRL_DR_CR                                        
MFA-TR*            FROM   CSS_GL_ENTRY_CRNT GE,                                 
MFA-TR*                   CSS_REV_DISTRICT A9,                                  
MFA-TR*                   CSS_LOCAL_OFFICE B1                                   
MFA-TR*            WHERE  GE.GL_ACCT_NO IN (241.0213, 241.0207)                 
MFA-TR*            AND    GE.ACCT_PERIOD_AFFCTD = :WS-PARM-REV-MTH              
MFA-TR*            AND    GE.COMPANY_NO         = '01'                          
MFA-TR*            AND    B1.COMPANY_NO         = '26'                          
MFA-TR*            AND    GE.REV_DISTRICT_CD = A9.REV_DISTRICT_CD               
MFA-TR*            AND    GE.LOCAL_OFFICE    = B1.LOCAL_OFFICE                  
MFA-TR*            GROUP BY COUNTY, GL_CNTRL_DR_CR                              
MFA-TR*            ORDER BY COUNTY                                              
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
     *                                                                  
           EXEC SQL                                                     
               DECLARE QTRCOUNTY_CURSOR CURSOR FOR                      
                   SELECT SUM(AMT_TRAN_ENTRY),                          
                          COUNTY,                                       
                          GL_CNTRL_DR_CR                                
                   FROM   CSS_GL_ENTRY_CRNT GE WITH(READUNCOMMITTED),           
                          CSS_REV_DISTRICT A9 WITH(READUNCOMMITTED),            
                          CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)             
A04527             WHERE  GE.GL_ACCT_NO IN (241.0213, 241.0207)         
                   AND     GE.ACCT_PERIOD_AFFCTD IN (:WS-PARM-REV-MTH,  
                                               :WS-PARM-REV-MTH-PREV1,  
                                               :WS-PARM-REV-MTH-PREV2)  
                   AND    GE.COMPANY_NO         = '01'                  
                   AND    B1.COMPANY_NO         = '26'                  
                   AND    GE.REV_DISTRICT_CD = A9.REV_DISTRICT_CD       
                   AND    GE.LOCAL_OFFICE    = B1.LOCAL_OFFICE          
                   GROUP BY COUNTY, GL_CNTRL_DR_CR                      
                   ORDER BY COUNTY                                      
C37783             FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE QTRCOUNTY_CURSOR CURSOR FOR                              
MFA-TR*            SELECT SUM(AMT_TRAN_ENTRY),                                  
MFA-TR*                   COUNTY,                                               
MFA-TR*                   GL_CNTRL_DR_CR                                        
MFA-TR*            FROM   CSS_GL_ENTRY_CRNT GE,                                 
MFA-TR*                   CSS_REV_DISTRICT A9,                                  
MFA-TR*                   CSS_LOCAL_OFFICE B1                                   
MFA-TR*            WHERE  GE.GL_ACCT_NO IN (241.0213, 241.0207)                 
MFA-TR*            AND     GE.ACCT_PERIOD_AFFCTD IN (:WS-PARM-REV-MTH,          
MFA-TR*                                        :WS-PARM-REV-MTH-PREV1,          
MFA-TR*                                        :WS-PARM-REV-MTH-PREV2)          
MFA-TR*            AND    GE.COMPANY_NO         = '01'                          
MFA-TR*            AND    B1.COMPANY_NO         = '26'                          
MFA-TR*            AND    GE.REV_DISTRICT_CD = A9.REV_DISTRICT_CD               
MFA-TR*            AND    GE.LOCAL_OFFICE    = B1.LOCAL_OFFICE                  
MFA-TR*            GROUP BY COUNTY, GL_CNTRL_DR_CR                              
MFA-TR*            ORDER BY COUNTY                                              
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
T25531 LINKAGE SECTION.                                                 
T33606 01  PARM-CODE.                                                   
T25531     02  LINK-PARM               PIC S9999 COMP.                  
T25531     02  PARM-VAL                PIC XXX.                         
      *                                                                         
T25531 PROCEDURE DIVISION USING PARM-CODE.                              
      *                                                                         
      *PROCEDURE DIVISION.                                                      
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
                                                                        
      ***  REPORT 4% STATE TAX BY LOCAL OFFICE                                  
           MOVE '1'                              TO WS-CURSOR-FLAG.     
           MOVE 241.1000                         TO GE-GL-ACCT-NO.      
A04527     MOVE WS-SVCCARE-SALES                 TO WS-CURSOR-GL.       
           PERFORM 2000-PROCESS-GL               THRU 2000-EXIT.        
C37783     PERFORM 2888-TOTALS                   THRU 2888-EXIT.        
A04527     MOVE WS-CLEAR-GL                      TO WS-CURSOR-GL.       
                                                                        
      ***  REPORT WHITE GOODS DISPOSAL FEE BY LOCAL OFFICE                      
           MOVE '1'                              TO WS-CURSOR-FLAG.     
           MOVE 241.0910                         TO GE-GL-ACCT-NO.      
C37783     MOVE WS-TITLE-1                       TO P-RPT1-HDR.         
           PERFORM 8100-PRINT-HEADERS            THRU 8100-EXIT.        
           PERFORM 2000-PROCESS-GL               THRU 2000-EXIT.        
C37783     PERFORM 2888-TOTALS                   THRU 2888-EXIT.        
                                                                        
      ***  REPORT FINANCE CHARGES BY LOCAL OFFICE                               
      ***  THESE CHARGES ARE THE INTEREST                                       
           MOVE '2'                              TO WS-CURSOR-FLAG.     
C37783     MOVE WS-TITLE-2                       TO P-RPT1-HDR.         
           PERFORM 8100-PRINT-HEADERS            THRU 8100-EXIT.        
           PERFORM 0500-INIT-TABLE               THRU 0500-EXIT.        
           PERFORM 7010-OPEN-FINANCE-CURSOR      THRU 7010-EXIT.        
           PERFORM 7011-FETCH-FINANCE-CURSOR     THRU 7011-EXIT.        
           IF SQLCODE EQUAL NOT-FOUND                                   
               WRITE PRT33-RECORD FROM WS-NO-DATA-LINE AFTER            
                   ADVANCING 2 LINES                                    
           ELSE                                                         
               PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL                
                 NOT-FOUND                                              
                 MOVE K6-GL-ACCT-NO              TO GE-GL-ACCT-NO       
                 PERFORM 2000-PROCESS-GL           THRU 2000-EXIT       
                 PERFORM 7011-FETCH-FINANCE-CURSOR THRU 7011-EXIT       
               END-PERFORM                                              
               PERFORM 7012-CLOSE-FINANCE-CURSOR THRU 7012-EXIT         
               PERFORM 2250-PRINT-TABLE          THRU 2250-EXIT         
           END-IF.                                                      
C37783     PERFORM 2888-TOTALS                   THRU 2888-EXIT.        
                                                                        
      ***  REPORT MERCHANDISE AMT BY LOCAL OFFICE                               
      ***  THIS IS ALSO KNOWN AS THE CONTRACT REVENUE                           
           MOVE '3'                              TO WS-CURSOR-FLAG.     
C37783     MOVE WS-TITLE-3                       TO P-RPT1-HDR.         
           PERFORM 8100-PRINT-HEADERS            THRU 8100-EXIT.        
           PERFORM 0500-INIT-TABLE               THRU 0500-EXIT.        
           PERFORM 7015-OPEN-REV-CURSOR          THRU 7015-EXIT.        
           PERFORM 7016-FETCH-REV-CURSOR         THRU 7016-EXIT.        
           IF SQLCODE EQUAL NOT-FOUND                                   
               WRITE PRT33-RECORD FROM WS-NO-DATA-LINE AFTER            
                   ADVANCING 2 LINES                                    
           ELSE                                                         
               PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL                
                 NOT-FOUND                                              
                 MOVE K6-GL-ACCT-NO              TO GE-GL-ACCT-NO       
                 PERFORM 2000-PROCESS-GL         THRU 2000-EXIT         
                 PERFORM 7016-FETCH-REV-CURSOR   THRU 7016-EXIT         
               END-PERFORM                                              
               PERFORM 7017-CLOSE-REV-CURSOR     THRU 7017-EXIT         
               PERFORM 2250-PRINT-TABLE          THRU 2250-EXIT         
           END-IF.                                                      
C37783     PERFORM 2888-TOTALS                   THRU 2888-EXIT.        
                                                                        
      ***  REPORT 2% COUNTY TAX BY COUNTY                                       
C37783     MOVE WS-TITLE-4                       TO P-RPT1-HDR.         
           MOVE 'COUNTY     '                    TO P-HDR-DESC.         
           PERFORM 8100-PRINT-HEADERS            THRU 8100-EXIT.        
           IF PARM-VAL = 'QTR'                                          
               PERFORM 7730-OPEN-QTRCOUNTY-CURSOR THRU 7730-EXIT        
           ELSE                                                         
               PERFORM 7050-OPEN-COUNTY-CURSOR       THRU 7050-EXIT
           END-IF.    
                                                                        
           IF PARM-VAL = 'QTR'                                          
               PERFORM 7740-FETCH-QTRCOUNTY-CURSOR THRU 7740-EXIT       
           ELSE                                                         
               PERFORM 7051-FETCH-COUNTY-CURSOR      THRU 7051-EXIT
           END-IF.    
           IF SQLCODE EQUAL NOT-FOUND                                   
               WRITE PRT33-RECORD FROM WS-NO-DATA-LINE AFTER            
                   ADVANCING 2 LINES                                    
               WRITE PRT33-RECORD FROM WS-END-DATA-LINE                 
                   AFTER ADVANCING 3 LINES                              
           ELSE                                                         
               MOVE A9-COUNTY TO WS-PREV-COUNTY                         
               PERFORM 1100-PROCESS-COUNTY THRU 1100-EXIT               
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
               PERFORM 1150-WRITE-COUNTY THRU 1150-EXIT                 
C37783         PERFORM 2888-TOTALS THRU 2888-EXIT                       
               WRITE PRT33-RECORD FROM WS-END-DATA-LINE                 
                   AFTER ADVANCING 3 LINES                              
           END-IF.                                                      
      *                                                                         
           IF PARM-VAL = 'QTR'                                          
               PERFORM 7750-CLOSE-QTRCOUNTY-CURSOR    THRU 7750-EXIT    
           ELSE                                                         
               PERFORM 7052-CLOSE-COUNTY-CURSOR       THRU 7052-EXIT
           END-IF.   
      *                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0100-INITIALIZATION                                      **          
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
T20122*     ACCEPT WS-RUN-FREQ.                                                 
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                  TO WS-RT-HH.                     
           MOVE WS-MM                  TO WS-RT-MM.                     
           MOVE WS-SS                  TO WS-RT-SS.                     
           MOVE WS-RUN-TIME            TO P-RPT1-RUN-TM.                
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY                  TO WS-RD-YY.                     
           MOVE WS-CM                  TO WS-RD-MM.                     
           MOVE WS-CD                  TO WS-RD-DD.                     
           MOVE WS-RUN-DATE            TO P-RPT1-RUN-DATE.              
           MOVE WS-PGRMNAME            TO P-RPT1-PGRMNAME.              
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
                                                                        
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT        
               DISPLAY ' '                                              
               DISPLAY '************PCSCA301**************'             
               DISPLAY '* COMMON DATE BEING USED         *'             
               DISPLAY '* DATE IS ', WS-FCA00-COMMON-DATE               
               DISPLAY '* PROCESSING CONTINUES...        *'             
               DISPLAY '************PCSCA301**************'             
               DISPLAY ' '                                              
               MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE               
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE            TO WS-DATE-10                  
           MOVE WS-D10-YY                TO WS-DAT-YY                   
           MOVE WS-D10-MM                TO WS-DAT-MM                   
           MOVE WS-D10-DD                TO WS-DAT-DD                   
           MOVE WS-DATE-TEMP             TO P-RPT1-REPORT-DATE.         
                                                                        
T15599     INITIALIZE WS-SYSIPT                                         
                      WS-INPUT-DATA-BREAKDOWN.                          
      *                                                                         
T15599     PERFORM 6200-GET-PARAMETER-DATE    THRU 6200-EXIT.           
                                                                        
T15599     MOVE WS-PARM-MONTH   TO WS-D8-MM.                            
T15599     MOVE WS-PARM-YR      TO WS-D8-CCYY.                          
           MOVE WS-D8-CCYY      TO WS-RP-CCYY.                          
           MOVE WS-D8-MM        TO WS-RP-MM.                            
           MOVE WS-DATE-8       TO P-RPT1-REPT-MNTH.                    
           MOVE WS-RP-DATE      TO WS-RP-DATE-NUM.                      
           MOVE WS-RP-DATE-NUM  TO WS-PARM-REV-MTH.                     
           DISPLAY 'PARM REV ' WS-PARM-REV-MTH.                         
T25531     IF PARM-VAL = 'QTR'                                          
T25531         MOVE 'QUARTER' TO P-RPT1-REPT-MNTH                       
C37783         MOVE WS-QRT-1  TO P-RPT1-CURRENT                         
C37783         MOVE WS-QRT-2  TO P-RPT1-REPORT-DATE                     
T25531         COMPUTE WS-PARM-REV-MTH-PREV1 = WS-PARM-REV-MTH - 1      
T25531         COMPUTE WS-PARM-REV-MTH-PREV2 = WS-PARM-REV-MTH - 2      
T25531      END-IF.                                                     
                                                                        
                                                                        
T15599     IF NOT END-OF-SYSIPT                                         
               PERFORM 7611-CLOSE             THRU 7611-EXIT            
           END-IF.                                                      
                                                                        
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
                                                                        
           MOVE 'PSNC ENERGY'   TO P-RPT1-COMPANY-NAME.                 
C37783     MOVE WS-TITLE-5      TO P-RPT1-HDR.                          
           MOVE 'LOCAL OFFICE'  TO P-HDR-DESC.                          
           PERFORM 8100-PRINT-HEADERS THRU 8100-EXIT.                   
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0500-INIT-TABLE                                          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0500-INIT-TABLE.                                                 
           PERFORM VARYING WS-GL-INDX FROM 1 BY 1 UNTIL                 
             WS-GL-INDX GREATER THAN 100                                
               MOVE SPACES       TO WS-CODE-TABLE(WS-GL-INDX)           
               MOVE SPACES       TO WS-DESC-TABLE(WS-GL-INDX)           
               MOVE ZEROES       TO WS-BALANCE-TABLE(WS-GL-INDX)        
           END-PERFORM.                                                 
           MOVE ZEROES           TO WS-HOLD-INDEX.                      
       0500-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **                                                            **          
      **   1000-PROCESS-STATE                                       **          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-STATE.                                              
      *                                                                         
           IF GE-LOCAL-OFFICE NOT EQUAL WS-PREV-OFFICE                  
               PERFORM 1050-WRITE-OFFICE      THRU 1050-EXIT            
           END-IF.                                                      
                                                                        
           IF GE-GL-CNTRL-DR-CR EQUAL 'C'                               
               COMPUTE WS-SUM = WS-SUM + WS-GE-SUM                      
           ELSE                                                         
               COMPUTE WS-SUM = WS-SUM - WS-GE-SUM                      
           END-IF.                                                      
                                                                        
           IF PARM-VAL = 'QTR'                                          
               PERFORM 7710-FETCH-QTRSTATE-CURSOR THRU 7710-EXIT        
           ELSE                                                         
               PERFORM 7001-FETCH-STATE-CURSOR     THRU 7001-EXIT
           END-IF.      
                                                                        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1050-WRITE-OFFICE                                        **          
      ****************************************************************          
       1050-WRITE-OFFICE.                                               
      ***  FOR FINANCE CHARGES AND REVENUE UPDATE TABLE RATHER                  
      ***  THAN PRINTING TO REPORT. WE HAVE MULTIPLE GL NUMBERS                 
      ***  TO PROCESS FOR THESE 2.                                              
           IF WS-CURSOR-FLAG EQUAL '2' OR                               
              WS-CURSOR-FLAG EQUAL '3'                                  
             PERFORM 2200-SEARCH-GL-TABLE THRU 2200-EXIT                
           ELSE                                                         
             MOVE WS-SUM                    TO P-BALANCE                
C37783       ADD WS-SUM TO WS-TOTAL                                     
             MOVE WS-PREV-OFFICE            TO P-CODE                   
             PERFORM 7500-GET-LOC-OFF-DESC  THRU 7500-EXIT              
             MOVE B1-LOCAL-OFFICE-DESC      TO P-DESC                   
             IF WS-RPT1-LINE-NO > 58                                    
                 PERFORM 8100-PRINT-HEADERS  THRU 8100-EXIT             
             END-IF                                                     
             WRITE PRT33-RECORD FROM WS-DTL-LINE                        
                 AFTER ADVANCING 1 LINE                                 
             ADD +1                         TO WS-RPT1-LINE-NO          
           END-IF.                                                      
           MOVE ZEROES                      TO WS-SUM.                  
           MOVE GE-LOCAL-OFFICE             TO WS-PREV-OFFICE.          
       1050-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **                                                            **          
      **   1100-PROCESS-COUNTY                                      **          
      ****************************************************************          
      *                                                                         
       1100-PROCESS-COUNTY.                                             
      *                                                                         
           IF A9-COUNTY NOT EQUAL WS-PREV-COUNTY                        
               PERFORM 1150-WRITE-COUNTY      THRU 1150-EXIT            
           END-IF.                                                      
                                                                        
           IF GE-GL-CNTRL-DR-CR EQUAL 'C'                               
               COMPUTE WS-SUM = WS-GE-SUM + WS-SUM                      
           ELSE                                                         
               COMPUTE WS-SUM = WS-SUM - WS-GE-SUM                      
           END-IF.                                                      
                                                                        
           IF PARM-VAL = 'QTR'                                          
               PERFORM 7740-FETCH-QTRCOUNTY-CURSOR THRU 7740-EXIT       
           ELSE                                                         
               PERFORM 7051-FETCH-COUNTY-CURSOR     THRU 7051-EXIT
           END-IF.     
                                                                        
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      **********************************************************                
      ** 1150-WRITE-COUNTY                                    **                
      **********************************************************                
       1150-WRITE-COUNTY.                                               
           MOVE WS-PREV-COUNTY            TO P-CODE.                    
           PERFORM 7520-GET-COUNTY-DESC   THRU 7520-EXIT.               
           MOVE SC-COUNTY-DESC            TO P-DESC.                    
           MOVE WS-SUM                    TO P-BALANCE.                 
C37783     ADD WS-SUM TO WS-TOTAL.                                      
           IF WS-RPT1-LINE-NO > 58                                      
               PERFORM 8100-PRINT-HEADERS  THRU 8100-EXIT               
           END-IF.                                                      
           WRITE PRT33-RECORD FROM WS-DTL-LINE                          
               AFTER ADVANCING 1 LINE.                                  
           ADD +1                         TO WS-RPT1-LINE-NO.           
           MOVE ZEROES                    TO WS-SUM.                    
           MOVE A9-COUNTY                 TO WS-PREV-COUNTY.            
       1150-EXIT.                                                       
           EXIT.                                                        
      **********************************************************                
      ** 2000-PROCESS-GL.                                     **                
      **********************************************************                
       2000-PROCESS-GL.                                                 
      ***  OPEN APPROPRIATE CURSOR                                              
           IF PARM-VAL = 'QTR'                                          
               PERFORM 7700-OPEN-QTRSTATE-CURSOR THRU 7700-EXIT         
           ELSE                                                         
               PERFORM 7000-OPEN-STATE-CURSOR    THRU 7000-EXIT
           END-IF.        
                                                                        
      ***  FETCH APPROPRIATE CURSOR INITIALLY                                   
           IF PARM-VAL = 'QTR'                                          
               PERFORM 7710-FETCH-QTRSTATE-CURSOR THRU 7710-EXIT        
           ELSE                                                         
               PERFORM 7001-FETCH-STATE-CURSOR   THRU 7001-EXIT
           END-IF.        
      ***                                                                       
           IF SQLCODE EQUAL NOT-FOUND                                   
             IF WS-CURSOR-FLAG EQUAL '1'                                
               WRITE PRT33-RECORD FROM WS-NO-DATA-LINE AFTER            
                   ADVANCING 2 LINES                                    
             END-IF                                                     
           ELSE                                                         
               MOVE GE-LOCAL-OFFICE              TO WS-PREV-OFFICE      
               PERFORM 1000-PROCESS-STATE THRU 1000-EXIT                
                   UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
               PERFORM 1050-WRITE-OFFICE            THRU 1050-EXIT      
           END-IF.                                                      
                                                                        
      ***  CLOSE CURSOR                                                         
           IF PARM-VAL = 'QTR'                                          
               PERFORM 7720-CLOSE-QTRSTATE-CURSOR THRU 7720-EXIT        
           ELSE                                                         
               PERFORM 7002-CLOSE-STATE-CURSOR    THRU 7002-EXIT
           END-IF.       
       2000-EXIT.                                                       
           EXIT.                                                        
      **********************************************************                
      ** 2200-SEARCH-GL-TABLE.                                **                
      **********************************************************                
       2200-SEARCH-GL-TABLE.                                            
             SET WS-GL-INDX           TO 1                              
             SEARCH WS-MULTI-GL-TABLE                                   
               AT END                                                   
                 ADD +1               TO WS-HOLD-INDEX                  
                 SET WS-GL-INDX       TO WS-HOLD-INDEX                  
                 MOVE WS-PREV-OFFICE  TO                                
                      WS-CODE-TABLE(WS-GL-INDX)                         
                 MOVE WS-SUM          TO                                
                      WS-BALANCE-TABLE(WS-GL-INDX)                      
                                                                        
                 PERFORM 7500-GET-LOC-OFF-DESC  THRU 7500-EXIT          
                 MOVE B1-LOCAL-OFFICE-DESC TO                           
                      WS-DESC-TABLE(WS-GL-INDX)                         
                                                                        
               WHEN WS-PREV-OFFICE EQUAL WS-CODE-TABLE(WS-GL-INDX)      
                 ADD WS-SUM     TO WS-BALANCE-TABLE(WS-GL-INDX)         
               END-SEARCH.                                              
       2200-EXIT.                                                       
           EXIT.                                                        
      **********************************************************                
      ** 2250-PRINT-TABLE.                                    **                
      **********************************************************                
       2250-PRINT-TABLE.                                                
           PERFORM VARYING WS-GL-INDX FROM 1 BY 1 UNTIL                 
             WS-GL-INDX > 100 OR                                        
             WS-CODE-TABLE(WS-GL-INDX) EQUAL SPACES                     
               MOVE WS-CODE-TABLE(WS-GL-INDX)    TO P-CODE              
               MOVE WS-BALANCE-TABLE(WS-GL-INDX) TO P-BALANCE           
C37783         ADD  WS-BALANCE-TABLE(WS-GL-INDX) TO WS-TOTAL            
               MOVE WS-DESC-TABLE(WS-GL-INDX)    TO P-DESC              
               IF WS-RPT1-LINE-NO > 58                                  
                   PERFORM 8100-PRINT-HEADERS  THRU 8100-EXIT           
               END-IF                                                   
               WRITE PRT33-RECORD FROM WS-DTL-LINE                      
                   AFTER ADVANCING 1 LINE                               
               ADD +1                         TO WS-RPT1-LINE-NO        
           END-PERFORM.                                                 
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **********************************************************                
C37783** PUT TOTALS ON ALL REPORTS                            **                
      **********************************************************                
      *                                                                         
C37783 2888-TOTALS.                                                     
C37783      MOVE SPACES TO P-CODE.                                      
C37783      MOVE WS-TOTAL TO P-BALANCE.                                 
C37783      MOVE 'TOTAL = ' TO P-DESC.                                  
C37783      WRITE PRT33-RECORD FROM WS-DTL-LINE                         
C37783          AFTER ADVANCING 1 LINE.                                 
C37783      MOVE ZEROS TO WS-TOTAL.                                     
      *                                                                         
C37783 2888-EXIT.                                                       
C37783     EXIT.                                                        
      *                                                                         
      **********************************************************                
      ** 6200-GET-PARAMETER-DATE                              **                
      **********************************************************                
T15599     EXEC SQL                                                             
T15599           INCLUDE CPD00114                                               
T15599     END-EXEC.                                                            
      *                                                                         
      *                                                                         
      *****************************************************************         
      ** 7000-OPEN-STATE-CURSOR                                                 
      *****************************************************************         
       7000-OPEN-STATE-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN STATE_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7000-OPEN-STATE-CURSOR *'     
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*        PROCESSING TERMINATED          *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7001-FETCH-STATE-CURSOR                                     **         
      *****************************************************************         
       7001-FETCH-STATE-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH STATE_CURSOR                                       
               INTO  :WS-GE-SUM,                                        
                     :GE-LOCAL-OFFICE,                                  
                     :GE-GL-CNTRL-DR-CR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7001-FETCH-STATE-CURSOR *'    
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*        PROCESSING TERMINATED          *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7002-CLOSE-STATE-CURSOR                                     **         
      *****************************************************************         
       7002-CLOSE-STATE-CURSOR.                                         
           EXEC SQL                                                     
               CLOSE STATE_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7002-CLOSE-STATE-CURSOR *'    
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*        PROCESSING TERMINATED          *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7002-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7010-OPEN-FINANCE-CURSOR                                               
      *****************************************************************         
       7010-OPEN-FINANCE-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               OPEN FINANCE_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7010-OPEN-FINANCE-CURSOR *'   
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*        PROCESSING TERMINATED          *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7011-FETCH-FINANCE-CURSOR                                              
      *****************************************************************         
       7011-FETCH-FINANCE-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
               FETCH FINANCE_CURSOR                                     
               INTO  :K6-GL-ACCT-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7011-FETCH-FINANCE-CURSOR *'  
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*        PROCESSING TERMINATED          *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7011-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7012-CLOSE-FINANCE-CURSOR                                              
      *****************************************************************         
       7012-CLOSE-FINANCE-CURSOR.                                       
           EXEC SQL                                                     
               CLOSE FINANCE_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7012-CLOSE-FINANCE-CURSOR *'  
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*        PROCESSING TERMINATED          *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7012-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7015-OPEN-REV-CURSOR                                                   
      *****************************************************************         
       7015-OPEN-REV-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               OPEN REV_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7015-OPEN-REV-CURSOR *'       
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*        PROCESSING TERMINATED          *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7016-FETCH-REV-CURSOR                                       **         
      *****************************************************************         
       7016-FETCH-REV-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               FETCH REV_CURSOR                                         
               INTO  :K6-GL-ACCT-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7016-FETCH-REV-CURSOR *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*        PROCESSING TERMINATED          *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7016-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7017-CLOSE-REV-CURSOR                                     **           
      *****************************************************************         
       7017-CLOSE-REV-CURSOR.                                           
           EXEC SQL                                                     
               CLOSE REV_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7017-CLOSE-REV-CURSOR *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*        PROCESSING TERMINATED          *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7017-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7050-OPEN-COUNTY-CURSOR                                                
      *****************************************************************         
       7050-OPEN-COUNTY-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               OPEN COUNTY_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7050-OPEN-COUNTY-CURSOR *'    
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*        PROCESSING TERMINATED          *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7051-FETCH-COUNTY-CURSOR                                     **        
      *****************************************************************         
       7051-FETCH-COUNTY-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               FETCH COUNTY_CURSOR                                      
               INTO  :WS-GE-SUM,                                        
                     :A9-COUNTY,                                        
                     :GE-GL-CNTRL-DR-CR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7051-FETCH-COUNTY-CURSOR *'   
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*        PROCESSING TERMINATED          *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7051-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7052-CLOSE-COUNTY-CURSOR                                    **         
      *****************************************************************         
       7052-CLOSE-COUNTY-CURSOR.                                        
           EXEC SQL                                                     
               CLOSE COUNTY_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7052-CLOSE-COUNTY-CURSOR *'   
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*        PROCESSING TERMINATED          *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7052-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7500-GET-LOC-OFF-DESC                                       **         
      *****************************************************************         
       7500-GET-LOC-OFF-DESC.                                           
           EXEC SQL                                                     
               SELECT LOCAL_OFFICE_DESC                                 
               INTO   :B1-LOCAL-OFFICE-DESC                             
               FROM   CSS_LOCAL_OFFICE                                  
               WHERE  LOCAL_OFFICE = :WS-PREV-OFFICE                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7500-GET-LOC-OFF-DESC *'      
               DISPLAY '* RETURN CODE  = ' SQLCODE                      
               DISPLAY '* LOCAL OFFICE = ' WS-PREV-OFFICE               
               DISPLAY '*        PROCESSING TERMINATED          *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7520-GET-COUNTY-DESC                                       **          
      *****************************************************************         
       7520-GET-COUNTY-DESC.                                            
           EXEC SQL                                                     
               SELECT COUNTY_DESC                                       
               INTO   :SC-COUNTY-DESC                                   
               FROM   CSS_STATE_COUNTY                                  
               WHERE  STATE = 'NC'                                      
               AND    COUNTY = :WS-PREV-COUNTY                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7520-GET-COUNTY-DESC *'       
               DISPLAY '* RETURN CODE  = ' SQLCODE                      
               DISPLAY '* COUNTY       = ' WS-PREV-COUNTY               
               DISPLAY '*        PROCESSING TERMINATED          *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7700-OPEN-QTRSTATE-CURSOR                                              
      *****************************************************************         
       7700-OPEN-QTRSTATE-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
               OPEN QTRSTATE_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7700-OPEN-QTRSTATE-CURSOR *'  
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*        PROCESSING TERMINATED          *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7710-FETCH-QTRSTATE-CURSOR                                  **         
      *****************************************************************         
       7710-FETCH-QTRSTATE-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
               FETCH QTRSTATE_CURSOR                                    
               INTO  :WS-GE-SUM,                                        
                     :GE-LOCAL-OFFICE,                                  
                     :GE-GL-CNTRL-DR-CR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7710-FETCH-QTRSTATE-CURSOR *' 
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*        PROCESSING TERMINATED          *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7002-CLOSE-QTRSTATE-CURSOR                                  **         
      *****************************************************************         
       7720-CLOSE-QTRSTATE-CURSOR.                                      
           EXEC SQL                                                     
               CLOSE QTRSTATE_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7720-CLOSE-STATE-CURSOR *'    
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*        PROCESSING TERMINATED          *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7720-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7730-OPEN-QTRCOUNTY-CURSOR                                             
      *****************************************************************         
       7730-OPEN-QTRCOUNTY-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
               OPEN QTRCOUNTY_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7730-OPEN-QTRCOUNTY-CURSOR *' 
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*        PROCESSING TERMINATED          *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7730-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7740-FETCH-QTRCOUNTY-CURSOR                                 **         
      *****************************************************************         
       7740-FETCH-QTRCOUNTY-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
               FETCH QTRCOUNTY_CURSOR                                   
               INTO  :WS-GE-SUM,                                        
                     :A9-COUNTY,                                        
                     :GE-GL-CNTRL-DR-CR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7740-FETCH-QTRCOUNTY-CURSOR *'
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*        PROCESSING TERMINATED          *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7740-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7750-CLOSE-QTRCOUNTY-CURSOR                                 **         
      *****************************************************************         
       7750-CLOSE-QTRCOUNTY-CURSOR.                                     
           EXEC SQL                                                     
               CLOSE QTRCOUNTY_CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7750-CLOSE-QTRCOUNTY-CURSOR *'
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*        PROCESSING TERMINATED          *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 15310000
      ** 7600-START-FCJ01                                            ** 15320000
      ***************************************************************** 15330000
      *                                                                 15340000
           EXEC SQL                                                     15350000
               INCLUDE CPD00038                                         15360000
           END-EXEC.                                                    15370000
      *                                                                 15380000
      ***************************************************************** 15390000
      ** 7600-START-FCJ01                                            ** 15400000
      ***************************************************************** 15410000
      *                                                                 15420000
           EXEC SQL                                                     15430000
               INCLUDE CPD00039                                         15440000
           END-EXEC.                                                    15450000
      *                                                                 15460000
      ***************************************************************** 11210000
      ** 6251-GET-FJC01-DATE                                         ** 11220000
      ***************************************************************** 11230000
      *                                                                 11240000
       COPY CPD00037.                                                   11250000
      *                                                                 11260000
       COPY CPD00040.                                                   11270000
      *                                                                 11280000
      ****************************************************************          
      **                                                            **          
      **       8100-PRINT-HEADERS.                                  **          
      **       PRINTS HEADERS FOR REPORT.                           **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8100-PRINT-HEADERS.                                              
      *                                                                         
           ADD 1 TO WS-RPT1-PAGE-NO.                                    
           WRITE PRT33-RECORD FROM WS-RPT1-TITLE                        
                 AFTER ADVANCING TOP-OF-PAGE.                           
           WRITE PRT33-RECORD FROM WS-RPT1-HDR-1                        
                 AFTER ADVANCING 1 LINE.                                
           MOVE WS-RPT1-PAGE-NO TO P-RPT1-PAGE-NO.                      
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-2                     
                 AFTER ADVANCING 1 LINE.                                
           WRITE PRT33-RECORD FROM WS-RPT1-HDR-3                        
                 AFTER ADVANCING 3 LINES.                               
           MOVE 6 TO WS-RPT1-LINE-NO.                                   
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
           EXIT.                                                        
                                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-ABEND                                                **          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *                                                                 01740000
