       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSGA304.                                        
       DATE-WRITTEN.   06/15/98.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC AND GAS                **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      ********            CUSTOMER INFORMATION SYSTEM         *********         
      *****************************************************************         
      **                  P R O G R A M S U M M A R Y                **         
      **                                                             **         
      **                                                             **         
      **           F U N C T I O N A L    D E S C R I P T I O N      **         
      **                           O F    M O D U L E                **         
      **                                                             **         
      **                                                             **         
      **  PURPOSE :                                                  **         
      **                                                             **         
      **  PROVIDE SUMMARY CONTROL REPORTS.                           **         
      **                                                             **         
      **  LOGIC :                                                    **         
      **                                                             **         
      **  COMPONENTS MAIN FUNCTION IS TO PROVIDE THE SUMMARY CONTROL **         
      **  REPORTS THAT ACCOMPANY THE 8300 MRS INTERFACE FILES EACH   **         
      **  INTERFACE FILE MUST BE BALANCED, MEANING THAT TOTAL DEBITS **         
      **  & TOTAL CREDITS MUST BE EQUAL. THESE FILES MUST BE BALANCED**         
      **  PRIOR TO RELEASE TO MRS PROCESSING.                        **         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  _________    __________________________________  **         
      **  06/15/98    CBSI       INITIAL VERSION.                    **         
      **              CHENNAI                                        **         
T20750**  09/09/99    CBSI       SENDING RETURN CODE 9 WHEN CREDIT   **         
T20750**              CHENNAI    TOTALS ARE NOT EQUAL TO DEBIT TOTALS**         
T21414**  01/13/2K    CBSI       CHANGED THE HARD CODED PROGRAM NAME **         
T21414**              CHENNAI    FROM PCSGA308 TO PCSGA304 IN THE    **         
T21414**                         HEADER AND ALSO CUSTOMISED PROGRAM  **         
T21414**                         TO TAKE THE COMPANY NAME FROM       **         
T21414**                         CSS_COMPANY.                        **         
T26989**  08/20/02    R. SPIRES  MADE REPORT CHANGES REQUIRED FOR    **         
T26989**                         SEB REGULATED.                      **         
C37101**  01/21/09    DM94438    MADE CHANGES FOR SEB PEOPLESOFT     **         
C37101**                         INTERFACE PROJECT                   **         
      *****************************************************************         
           REMARKS.                                                     
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT MRSCRR03-FILE                                         
               ASSIGN TO UT-S-MRSCRR03                                  
               FILE STATUS IS WS-CRR03-STATUS.                          
      *                                                                         
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       FD  MRSCRR03-FILE                                                
           RECORD CONTAINS 222 CHARACTERS                               
           RECORDING MODE IS F.                                         
       01  MRSCRR03-REC                PIC X(222).                      
      *                                                                         
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSGA304'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSGA308 STARTS HERE'.                  
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
T21414*                                                                         
T21414     EXEC SQL                                                             
T21414         INCLUDE TBCOMPNY                                                 
T21414     END-EXEC.                                                            
T21414*                                                                         
T26989     EXEC SQL                                                             
T26989         INCLUDE TBDELQ                                                   
T26989     END-EXEC.                                                            
T26989*                                                                         
       01  WS-REF-ITEMS.                                                
           02  MRSCRR03-REC-SPLIT      PIC X(222).                      
           02  ZIKRT8300                                                
               REDEFINES MRSCRR03-REC-SPLIT.                            
           COPY MRSCRR03.                                                       
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-DEFAULT-RPT1-HEAD1   PIC X(34)    VALUE               
               '           MRS 8300 CONTROL REPORT'.                    
      *                                                                         
           05  WS-MORE-DATA-RR03       PIC X(01)    VALUE 'Y'.          
               88  NO-MORE-DATA-RR03                VALUE 'N'.          
T21414     05  WS-PRINT-HEADER         PIC X(01)    VALUE 'Y'.          
T21414         88  PRINT-HEADER                     VALUE 'Y'.          
           05  WS-PREV-COMP-NO         PIC X(02)    VALUE SPACES.       
           05  WS-CRR03-STATUS         PIC X(02).                       
               88  CRR03-SUCCESSFUL                  VALUE '00'.        
           05  WS-TOT-DEBTS            PIC 9(15)V99  VALUE ZEROES.      
           05  WS-DEBTS                PIC 9(15)V99  VALUE ZEROES.      
           05  WS-TOT-CREDITS          PIC S9(15)V99 VALUE ZEROES.      
           05  WS-CREDITS              PIC S9(15)V99 VALUE ZEROES.      
           05  WS-8300-DEB-TOT         PIC 9(15)V99  VALUE ZEROES.      
           05  WS-8300-CRE-TOT         PIC S9(15)V99 VALUE ZEROES.      
           05  WS-PREV-ACCT-NUM        PIC X(13)     VALUE ZEROS.       
           05  WS-REC-READ-FIRST       PIC X(01)     VALUE 'Y'.         
           05  WS-LINE-SPACE           PIC 9(01)     VALUE ZERO.        
           05  WS-ONE                  PIC 9(01)     VALUE 1.           
           05  WS-TWO                  PIC 9(01)     VALUE 2.           
           05  WS-THREE                PIC 9(01)     VALUE 3.           
T20750     05  WS-NINE                 PIC 9(01)     VALUE 9.           
T26989     05  WS-DATABASE             PIC 9(01)     VALUE ZERO.        
T26989         88  CSR-DATABASE                      VALUE 1.           
T26989         88  SEB-DATABASE                      VALUE 2.           
T26989     05  WS-MULTIPLE-ROWS-FOUND  PIC S9(4) COMP VALUE -811.       
      *                                                                         
           05  WS-CURRENT-TIME.                                         
               10  WS-HH               PIC X(02)    VALUE SPACES.       
               10  WS-MM               PIC X(02)    VALUE SPACES.       
               10  WS-SS               PIC X(02)    VALUE SPACES.       
               10  WS-TT               PIC X(02)    VALUE SPACES.       
      *                                                                         
           05  WS-CURRENT-DATE.                                         
               10  WS-CY               PIC 9(02)    VALUE ZEROES.       
               10  WS-CM               PIC 9(02)    VALUE ZEROES.       
               10  WS-CD               PIC X(02)    VALUE SPACES.       
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CC               PIC X(02).                       
           05  WS-D10-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-DD               PIC X(02).                       
      *                                                                         
       01  WS-DATE-TEMP.                                                
           05  WS-DAT-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-DAT-DD               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-DAT-YY               PIC X(02).                       
      *                                                                         
       01  WS-DATE-8.                                                   
           05  WS-D8-MM                PIC 9(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
T15599     05  WS-D8-CCYY              PIC 9(04).                       
      *                                                                         
       01  WS-DATE-CAS.                                                 
           05  WS-DCA-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-DCA-DD               PIC X(02)    VALUE '01'.         
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-DCA-YY               PIC X(02).                       
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
      /****** WORKING STORAGE FOR REPORT HEADER                                 
       COPY CWS00079.                                                           
      *                                                                         
      /****** JOBS FILE/TABLE DEFINITIONS                                       
           COPY FIOCA00.                                                        
           COPY FIOJC01.                                                        
      /****** CWS00038 IS JC01 WORK DATA                                        
       COPY CWS00038.                                                           
T15599 COPY CWS00114.                                                           
      /****** CWS00039 IS CA00 WORK DATA                                        
       COPY CWS00039.                                                           
      *                                                                 04520000
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
       01  WS-RPT1-LINE-NO             PIC 9(02)    VALUE 60   COMP-3.  
      *01  WS-RPT1-PAGE-NO             PIC 9(02)    VALUE ZERO COMP-3.          
       01  WS-RPT1-PAGE-NO             PIC 9(03)    VALUE ZERO COMP-3.  
       01  WS-LIT.                                                      
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
T21414*    05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSGA308'.           
T21414     05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSGA304'.   
           05  WS-51                   PIC 9(02)    VALUE 51.           
T26989     05  WS-60                   PIC 9(02)    VALUE 60.           
           05  WS-TOT-BEF-TAX-BRK-DWN  PIC X(30)    VALUE               
               'TOTALS BEFORE TAX BREAK DOWN '.                         
           05  WS-TOT-AFT-TAX-BRK-DWN  PIC X(30)    VALUE               
               'TOTALS AFTER TAX BREAK DOWN  '.                         
           05  WS-TOTAL-FLAG           PIC X(01)    VALUE SPACES.       
      *                                                                         
      ***************** PCSGA308 REPORT HEADERS **********************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
           05  WS-RPT1-HDR-1.                                           
               10  FILLER              PIC X        VALUE SPACE.        
               10  FILLER              PIC X(16)                        
                   VALUE 'REVENUE MONTH : '.                            
T15599         10  P-RPT1-REPT-MNTH    PIC X(07)    VALUE SPACES.       
               10  FILLER              PIC X(20)    VALUE SPACES.       
               10  P-RPT1-HDR          PIC X(50).                       
               10  FILLER              PIC X(20)    VALUE SPACES.       
               10  FILLER              PIC X(11)    VALUE 'RUN TIME: '. 
               10  P-RPT1-RUN-TM       PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS     **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT-HDR-8300.                                         
               10  FILLER              PIC X        VALUE SPACE.        
               10  FILLER              PIC X(29)                        
                   VALUE 'GENERAL LEDGER ACCOUNT NUMBER'.               
               10  FILLER              PIC X(29)    VALUE SPACES.       
               10  FILLER              PIC X(06)                        
                   VALUE 'DEBITS'.                                      
               10  FILLER              PIC X(33)    VALUE SPACES.       
               10  FILLER              PIC X(07)                        
                   VALUE 'CREDITS'.                                     
      *                                                                         
           05  WS-SCT-HDR-8300.                                         
               10  FILLER              PIC X        VALUE SPACE.        
               10  FILLER              PIC X(15)                        
                   VALUE '8300 SECTION : '.                             
           05  WS-SCT-HDR-8300-1.                                       
               10  FILLER              PIC X        VALUE SPACE.        
               10  FILLER              PIC X(17)                        
                   VALUE 'COMPANY NUMBER : '.                           
               10  M-COMP-NO           PIC X(02)     VALUE SPACES.      
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT DETAIL LINES       **          
      ****************************************************************          
      *                                                                         
       01  WS-8300-LINE.                                                
           05  FILLER                  PIC X(01)     VALUE SPACES.      
           05  P-GL-ACCT-NO-8300       PIC X(13)     VALUE ZEROES.      
           05  FILLER                  PIC X(32)     VALUE SPACES.      
           05  P-DEBITS-8300           PIC Z(14)9.99 VALUE ZEROES.      
           05  FILLER                  PIC X(22)     VALUE SPACES.      
           05  P-CREDITS-8300          PIC -(14)9.99 VALUE ZEROES.      
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT TOTALS             **          
      ****************************************************************          
      *                                                                         
       01  WS-8300-TOTAL.                                               
           05  FILLER                  PIC X        VALUE SPACE.        
           05  P-TOT                   PIC X(30)     VALUE SPACES.      
           05  FILLER                  PIC X(16)     VALUE SPACES.      
           05  P-DEBITS-8300-TOT       PIC Z(14)9.99 VALUE ZEROES.      
           05  FILLER                  PIC X(22)     VALUE SPACES.      
           05  P-CREDITS-8300-TOT      PIC -(14)9.99 VALUE ZEROES.      
      *                                                                         
       01  WS-BLANK-LINE               PIC X(132)    VALUE SPACES.      
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)        VALUE SPACES.   
           05  FILLER                  PIC X(22)    VALUE               
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END                      PIC X(38)    VALUE               
           'WORKING STORAGE FOR PCSGA308 ENDS HERE'.                    
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
           IF NO-MORE-DATA-RR03                                         
T21414         MOVE WS-ONE                     TO C7-COMPANY-NO         
               PERFORM 8100-PRINT-HEADERS      THRU 8100-EXIT           
               MOVE WS-SCT-HDR-8300            TO PRT33-DATA            
               MOVE WS-THREE                   TO WS-LINE-SPACE         
               PERFORM 8300-WRITE-REPORT       THRU 8300-EXIT           
      *                                                                         
               MOVE WS-RPT-HDR-8300            TO PRT33-DATA            
               MOVE WS-TWO                     TO WS-LINE-SPACE         
               PERFORM 8300-WRITE-REPORT       THRU 8300-EXIT           
      *                                                                         
               MOVE ZEROES                     TO WS-RPT1-LINE-NO       
               MOVE SPACES                     TO PRT33-RECORD          
               MOVE WS-ONE                     TO WS-LINE-SPACE         
               PERFORM 8300-WRITE-REPORT       THRU 8300-EXIT           
      *                                                                         
               MOVE WS-NO-DATA-LINE            TO PRT33-RECORD          
               MOVE WS-TWO                     TO WS-LINE-SPACE         
               PERFORM 8300-WRITE-REPORT       THRU 8300-EXIT           
           ELSE                                                         
               INITIALIZE P-DEBITS-8300 P-CREDITS-8300                  
               PERFORM 1100-PRODUCE-SECT-8300  THRU 1100-EXIT           
                       UNTIL NO-MORE-DATA-RR03                          
               IF  WS-TOTAL-FLAG = 'B'                                  
                   MOVE WS-TOT-BEF-TAX-BRK-DWN TO P-TOT                 
               ELSE                                                     
                   MOVE WS-TOT-AFT-TAX-BRK-DWN TO P-TOT                 
               END-IF                                                   
                                                                        
               MOVE WS-8300-DEB-TOT            TO P-DEBITS-8300-TOT     
               MOVE WS-8300-CRE-TOT            TO P-CREDITS-8300-TOT    
               MOVE WS-8300-TOTAL              TO PRT33-RECORD          
               MOVE WS-TWO                     TO WS-LINE-SPACE         
               PERFORM 8300-WRITE-REPORT       THRU 8300-EXIT           
           END-IF.                                                      
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
T20750     MULTIPLY -1 BY WS-8300-CRE-TOT                               
T20750     IF  WS-8300-DEB-TOT NOT EQUAL TO WS-8300-CRE-TOT             
T20750         DISPLAY ' TOTAL DEBITS NOT = TOTAL CREDITS '             
T20750         DISPLAY ' DEBITS  =  ', P-DEBITS-8300-TOT                
T20750         DISPLAY ' CREDITS =  ', P-CREDITS-8300-TOT               
T20750         MOVE WS-NINE                    TO RETURN-CODE           
T20750     END-IF.                                                      
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0100-INITIALIZATION                                      **          
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                          TO WS-RT-HH.             
           MOVE WS-MM                          TO WS-RT-MM.             
           MOVE WS-SS                          TO WS-RT-SS.             
           MOVE WS-RUN-TIME                    TO P-RPT1-RUN-TM.        
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY                          TO WS-RD-YY.             
           MOVE WS-CM                          TO WS-RD-MM.             
           MOVE WS-CD                          TO WS-RD-DD.             
           MOVE WS-RUN-DATE                    TO P-RPT1-RUN-DATE.      
           MOVE WS-PGRMNAME                    TO P-RPT1-PGRMNAME.      
           MOVE WS-DEFAULT-RPT1-HEAD1          TO P-RPT1-HEADER.        
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
                                                                        
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE        TO WS-INPUT-DATE         
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE                  TO WS-DATE-10.           
           MOVE WS-D10-YY                      TO WS-DAT-YY.            
           MOVE WS-D10-MM                      TO WS-DAT-MM.            
           MOVE WS-D10-DD                      TO WS-DAT-DD.            
           MOVE WS-DATE-TEMP                   TO P-RPT1-REPORT-DATE.   
                                                                        
T15599     INITIALIZE WS-SYSIPT                                         
                      WS-INPUT-DATA-BREAKDOWN.                          
      *                                                                         
           PERFORM 6200-GET-PARAMETER-DATE     THRU 6200-EXIT.          
                                                                        
           MOVE WS-PARM-MONTH                  TO WS-D8-MM.             
           MOVE WS-PARM-YR                     TO WS-D8-CCYY.           
                                                                        
           MOVE WS-DATE-8                      TO P-RPT1-REPT-MNTH.     
                                                                        
T15599     IF NOT END-OF-SYSIPT                                         
               PERFORM 7611-CLOSE              THRU 7611-EXIT           
           END-IF.                                                      
                                                                        
      *                                                                         
           ACCEPT WS-TOTAL-FLAG FROM SYSIN.                             
      *                                                                         
           PERFORM 0110-OPEN-PARA              THRU 0110-EXIT.          
      *                                                                         
           PERFORM 7200-READ-MRSCRR03          THRU 7200-EXIT.          
           MOVE MRSCRR03-REC                   TO MRSCRR03-REC-SPLIT.   
      *                                                                         
           IF WS-REC-READ-FIRST = WS-Y                                  
              MOVE ZIKRT8300-ACCOUNT-NUMBER    TO WS-PREV-ACCT-NUM      
              MOVE WS-N                        TO WS-REC-READ-FIRST     
           END-IF.                                                      
      *                                                                         
           MOVE ZIKRT8300-COMPANY-CODE         TO WS-PREV-COMP-NO       
T21414                                            C7-COMPANY-NO.        
           MOVE ZEROES                   TO WS-TOT-DEBTS WS-TOT-CREDITS.
      *                                                                         
T26989                                                                  
T26989     MOVE ZERO                           TO WS-DATABASE.          
T26989     MOVE '01'                           TO C8-COMPANY-NO.        
T26989     MOVE 'DATABASE'                     TO C8-DELINQ-CD.         
T26989     PERFORM 7900-SELECT-DELINQ-VALUE    THRU 7900-EXIT.          
T26989     MOVE C8-DELINQ-VALUE                TO WS-DATABASE.          
T26989                                                                  
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0110-OPEN-PARA.                                                         
      *  THIS PARA OPENS THE FILE FCSPT33-FILE AND MRSCRR03-FILE.               
      ******************************************************************        
       0110-OPEN-PARA.                                                  
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           OPEN INPUT MRSCRR03-FILE.                                    
           IF CRR03-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**      PCSGA308 PROCESSING ERROR      **'      
               DISPLAY '**  OPEN ERROR OF MRSCRR03 - INPUT FILE'        
               DISPLAY '**  FILE STATUS = ' WS-CRR03-STATUS             
               DISPLAY '**        PROCESSING TERMINATED        **'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1100-PRODUCE-SECT-8300                                   **          
      **       TO ADD DEBIT & CREDIT ITEMS PRINT A COMPANY TOTAL    **          
      **       LINE WHENEVER THERE IS A CHANGE IN THE COMPANY NUMBER**          
      **       IN 8300 SECTION.                                     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1100-PRODUCE-SECT-8300.                                          
      *                                                                         
           PERFORM UNTIL ZIKRT8300-COMPANY-CODE NOT = WS-PREV-COMP-NO   
               OR NO-MORE-DATA-RR03                                     
               IF ZIKRT8300-CONTROL-AMOUNT IS POSITIVE                  
                  MOVE ZIKRT8300-CONTROL-AMOUNT TO WS-DEBTS             
                  MOVE ZEROS                    TO WS-CREDITS           
               ELSE                                                     
                  MOVE ZIKRT8300-CONTROL-AMOUNT TO WS-CREDITS           
                  MOVE ZEROS                    TO WS-DEBTS             
               END-IF                                                   
               MOVE ZIKRT8300-ACCOUNT-NUMBER   TO P-GL-ACCT-NO-8300     
               IF ZIKRT8300-ACCOUNT-NUMBER EQUAL WS-PREV-ACCT-NUM       
                  ADD WS-DEBTS                 TO WS-TOT-DEBTS          
                  ADD WS-CREDITS               TO WS-TOT-CREDITS        
               ELSE                                                     
                  PERFORM 1200-ACCT-BRK-REPORT THRU 1200-EXIT           
               END-IF                                                   
               PERFORM 7200-READ-MRSCRR03      THRU 7200-EXIT           
               MOVE MRSCRR03-REC               TO MRSCRR03-REC-SPLIT    
T21414         MOVE ZIKRT8300-COMPANY-CODE     TO C7-COMPANY-NO         
           END-PERFORM.                                                 
                                                                        
T26989     PERFORM 1200-ACCT-BRK-REPORT        THRU 1200-EXIT.          
T26989     MOVE ZIKRT8300-COMPANY-CODE         TO WS-PREV-COMP-NO.      
T21414     MOVE WS-Y                           TO WS-PRINT-HEADER.      
           PERFORM 1250-COMP-BRK-REPORT        THRU 1250-EXIT.          
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      * 1200-ACCT-BRK-REPORT.                                                   
      *  WRITE THE DETAIL LINE WHEN THERE IS A BREAK IN ACCOUNT NUMBER.         
      *****************************************************************         
       1200-ACCT-BRK-REPORT.                                            
            PERFORM 8200-WRITE-DETAIL          THRU  8200-EXIT.         
            MOVE WS-PREV-ACCT-NUM              TO P-GL-ACCT-NO-8300.    
            MOVE WS-TOT-DEBTS                  TO P-DEBITS-8300.        
            MOVE WS-TOT-CREDITS                TO P-CREDITS-8300.       
            MOVE WS-8300-LINE                  TO PRT33-RECORD.         
            MOVE WS-ONE                        TO WS-LINE-SPACE.        
            PERFORM 8300-WRITE-REPORT          THRU 8300-EXIT.          
            ADD 1                              TO WS-RPT1-LINE-NO.      
            INITIALIZE WS-8300-LINE.                                    
            ADD WS-TOT-DEBTS                   TO WS-8300-DEB-TOT.      
            ADD WS-TOT-CREDITS                 TO WS-8300-CRE-TOT.      
            MOVE WS-DEBTS                      TO WS-TOT-DEBTS.         
            MOVE WS-CREDITS                    TO WS-TOT-CREDITS.       
            MOVE ZIKRT8300-ACCOUNT-NUMBER      TO WS-PREV-ACCT-NUM.     
       1200-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************          
      * 1250-COMP-BRK-REPORT. *                                                 
      * PRINTS THE DETAILS AND THE TOTALS WHEN THERE IS A BREAK IN *            
      * COMPANY NUMBER.                                              *          
      ****************************************************************          
       1250-COMP-BRK-REPORT.                                            
T26989     MOVE WS-60                          TO WS-RPT1-LINE-NO.      
           PERFORM 8200-WRITE-DETAIL           THRU 8200-EXIT.          
T26989                                                                  
T26989*    MOVE ZIKRT8300-ACCOUNT-NUMBER       TO P-GL-ACCT-NO-8300.            
T26989*    MOVE WS-TOT-DEBTS                   TO P-DEBITS-8300.                
T26989*    MOVE WS-TOT-CREDITS                 TO P-CREDITS-8300.               
T26989*    MOVE WS-8300-LINE                   TO PRT33-RECORD.                 
T26989*    MOVE WS-ONE                         TO WS-LINE-SPACE.                
T26989*    PERFORM 8300-WRITE-REPORT           THRU 8300-EXIT.                  
T26989*    ADD 1                               TO WS-RPT1-LINE-NO.              
T26989*    ADD WS-TOT-DEBTS                    TO WS-8300-DEB-TOT.              
T26989*    ADD WS-TOT-CREDITS                  TO WS-8300-CRE-TOT.              
T26989                                                                  
           MOVE ZEROES                         TO WS-TOT-DEBTS,         
                                                  WS-TOT-CREDITS.       
           MOVE ZIKRT8300-COMPANY-CODE         TO WS-PREV-COMP-NO       
T21414                                            C7-COMPANY-NO.        
       1250-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      ** 6200-GET-PARAMETER-DATE                                    **          
      ****************************************************************          
T15599     EXEC SQL                                                             
T15599           INCLUDE CPD00114                                               
T15599     END-EXEC.                                                            
                                                                        
      ****************************************************************          
      **                                                            **          
      **   7200-READ-MRSCRR03                                       **          
      **       READS THE INPUT FILE MRSCRR03 FOR 8300 SECTION.      **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7200-READ-MRSCRR03.                                              
      *                                                                         
           READ MRSCRR03-FILE                                           
               AT END                                                   
                   MOVE WS-N                   TO WS-MORE-DATA-RR03     
                   GO                          TO 7200-EXIT.            
      *                                                                         
           IF CRR03-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7200-ERROR ON MRSCRR03 READ.  STATUS IS '       
                        WS-CRR03-STATUS                                 
               PERFORM 9900-ABEND             THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T21414******************************************************************        
T21414*                                                                *        
T21414*    GET COMPANY NAME FROM CSS_COMPANY USING COMPANY NUMBER      *        
T21414*                                                                *        
T21414******************************************************************        
T21414 7300-GET-COMPANY-NAME.                                           
T21414     EXEC SQL                                                     
T21414          SELECT COMPANY_NAME                                     
T21414            INTO :C7-COMPANY-NAME                                 
T21414            FROM CSS_COMPANY                                      
T21414           WHERE COMPANY_NO = :C7-COMPANY-NO                      
T21414     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21414                                                                  
T21414     IF  SQLCODE = SUCCESSFUL-CALL                                
T21414         NEXT SENTENCE                                            
T21414     ELSE                                                         
T21414         DISPLAY '**       PCSGA304 PROCESSING ERROR       **'    
T21414         DISPLAY '**     ERROR IN 7300-GET-COMPANY NAME    **'    
T21414         DISPLAY '**     SQL CODE IS   **' SQLCODE                
T21414         DISPLAY '**         PROCESSING TERMINATED         **'    
T21414         PERFORM 9900-ABEND THRU 9900-EXIT                        
T21414     END-IF.                                                      
T21414                                                                  
T21414 7300-EXIT.                                                       
T21414     EXIT.                                                        
T21414*                                                                         
      ***************************************************************** 15310000
      ** 7600-START-FCJ01                                            ** 15320000
      ***************************************************************** 15330000
      *                                                                 15340000
           EXEC SQL                                                     15350000
               INCLUDE CPD00038                                         15360000
           END-EXEC.                                                    15370000
      *                                                                 15380000
      ***************************************************************** 15390000
      ** 7600-START-FCJ01                                            ** 15400000
      ***************************************************************** 15410000
      *                                                                 15420000
           EXEC SQL                                                     15430000
               INCLUDE CPD00039                                         15440000
           END-EXEC.                                                    15450000
      *                                                                 15460000
      ***************************************************************** 11210000
      ** 6251-GET-FJC01-DATE                                         ** 11220000
      ***************************************************************** 11230000
      *                                                                 11240000
       COPY CPD00037.                                                   11250000
      *                                                                 11260000
       COPY CPD00040.                                                   11270000
      *                                                                 11280000
T26989****************************************************************          
T26989**                                                            **          
T26989**  7900-SELECT-DELINQ-VALUE                                  **          
T26989**     READS THE DATABASE FROM THE DELINQUENCY TABLE          **          
T26989**                                                            **          
T26989****************************************************************          
T26989*                                                                         
T26989 7900-SELECT-DELINQ-VALUE.                                        
T26989*                                                                         
T26989     MOVE '7900' TO WS-ACTIVE-PARAGRAPH.                          
T26989                                                                  
T26989     EXEC SQL                                                     
T26989        SELECT DELINQ_VALUE                                       
T26989          INTO :C8-DELINQ-VALUE                                   
T26989          FROM CSS_DELINQUENCY                                    
T26989         WHERE DELINQ_CD  = :C8-DELINQ-CD                         
T26989           AND COMPANY_NO = :C8-COMPANY-NO                        
T26989     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26989                                                                  
T26989     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
T26989                                                                  
T26989     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR               
T26989         WS-MULTIPLE-ROWS-FOUND                                   
T26989         CONTINUE                                                 
T26989     ELSE                                                         
T26989         DISPLAY '**************************************'         
T26989         DISPLAY '**     PCSGA304 PROCESSING ERROR    **'         
T26989         DISPLAY '**       ERROR SELECTING DELINQUENCY**'         
T26989         DISPLAY '**       PROCESSING TERMINATED IN 7900'         
T26989         DISPLAY '**************************************'         
T26989         PERFORM 9900-ABEND         THRU 9900-EXIT                
T26989     END-IF.                                                      
T26989*                                                                         
T26989 7900-EXIT.                                                       
T26989     EXIT.                                                        
T26989*                                                                         
      ****************************************************************          
      **                                                            **          
      **       8100-PRINT-HEADERS.                                  **          
      **       PRINTS HEADERS FOR REPORT.                           **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8100-PRINT-HEADERS.                                              
      *                                                                         
           ADD 1                               TO WS-RPT1-PAGE-NO.      
T21414*    MOVE 'SOUTH CAROLINA ELECT & GAS'   TO                               
T21414*        P-RPT1-COMPANY-NAME.                                             
T21414     IF  PRINT-HEADER                                             
T26989         IF SEB-DATABASE                                          
C37101           IF WS-PREV-COMP-NO EQUAL '91'                          
T26989              MOVE 'SCANA ENERGY - REGULATED '                    
T26989                                     TO P-RPT1-COMPANY-NAME       
T26989           ELSE                                                   
T26989              MOVE 'SCANA ENERGY - DEREGULATED'                   
T26989                                     TO P-RPT1-COMPANY-NAME       
T26989           END-IF                                                 
T26989         ELSE                                                     
T21414         PERFORM 7300-GET-COMPANY-NAME   THRU 7300-EXIT           
T21414         MOVE C7-COMPANY-NAME            TO P-RPT1-COMPANY-NAME   
T21414         MOVE WS-N                       TO WS-PRINT-HEADER       
T26989         END-IF                                                   
T21414     END-IF.                                                      
                                                                        
           MOVE WS-RPT1-TITLE                  TO PRT33-RECORD.         
           WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
           MOVE WS-DEFAULT-RPT1-HEAD1          TO P-RPT1-HDR.           
           MOVE WS-RPT1-HDR-1                  TO PRT33-RECORD.         
           MOVE WS-ONE                         TO WS-LINE-SPACE.        
           PERFORM 8300-WRITE-REPORT           THRU 8300-EXIT.          
           MOVE WS-RPT1-PAGE-NO                TO P-RPT1-PAGE-NO.       
           MOVE WS-RPT1-HEADER-2               TO PRT33-RECORD.         
           MOVE WS-ONE                         TO WS-LINE-SPACE.        
           PERFORM 8300-WRITE-REPORT           THRU 8300-EXIT.          
      *                                                                         
           MOVE  8                             TO WS-RPT1-LINE-NO.      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8200-WRITE-DETAIL.                                               
           IF  WS-RPT1-LINE-NO > 52                                     
               PERFORM 8100-PRINT-HEADERS      THRU 8100-EXIT           
               MOVE WS-SCT-HDR-8300            TO PRT33-RECORD          
               MOVE WS-THREE                   TO WS-LINE-SPACE         
               PERFORM 8300-WRITE-REPORT       THRU 8300-EXIT           
               MOVE WS-PREV-COMP-NO            TO M-COMP-NO             
               MOVE WS-SCT-HDR-8300-1          TO PRT33-RECORD          
               MOVE WS-ONE                     TO WS-LINE-SPACE         
               PERFORM 8300-WRITE-REPORT       THRU 8300-EXIT           
               MOVE WS-RPT-HDR-8300            TO PRT33-RECORD          
               MOVE WS-TWO                     TO WS-LINE-SPACE         
               PERFORM 8300-WRITE-REPORT       THRU 8300-EXIT           
               MOVE ZEROES                     TO WS-RPT1-LINE-NO       
               MOVE SPACES                     TO PRT33-RECORD          
               MOVE WS-ONE                     TO WS-LINE-SPACE         
               PERFORM 8300-WRITE-REPORT       THRU 8300-EXIT           
           END-IF.                                                      
       8200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       8300-WRITE-REPORT.                                               
            WRITE PRT33-RECORD AFTER ADVANCING WS-LINE-SPACE.           
      *                                                                         
       8300-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           MOVE WS-END-DATA-LINE               TO PRT33-RECORD          
           MOVE WS-THREE                       TO WS-LINE-SPACE         
           WRITE PRT33-RECORD FROM WS-END-DATA-LINE AFTER ADVANCING     
               3 LINES.                                                 
      *                                                                         
           CLOSE MRSCRR03-FILE.                                         
           IF CRR03-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**        PCSGA308 PROCESSING ERROR        **'  
               DISPLAY '**  CLOSE ERROR FOR MRSCRR03 - INPUT FILE  **'  
               DISPLAY '**        FILE STATUS = ' WS-CRR03-STATUS       
           END-IF.                                                      
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-ABEND                                                **          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *                                                                 01740000
