       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSDP001.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **   PROGRAM SPLITS ADDRESS ID SHARING (EXCEPT FOR LANDLORD    **         
      **   SITUATIONS).  ALL BILLING ADDRESSES USED AS SERVICE       **         
      **   ADDRESSES ARE FETCHED.  NEW BILLING ADDRESS IDS ARE       **         
      **   CREATED AND ALL ACCOUNTS FOR A CUSTOMER ARE UPDATED.      **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS  REASON                                 **         
      *    ----     --------  ------                                 **         
      *    04/05    DD        ORIGINAL VERSION                       **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSDP001'.
MSQ017     COPY MFASQLM.
                                                                        
       01  MISC.                                                        
           05  PROGRAM-NAME           PIC X(08) VALUE 'PCSDP001'.       
           05  WS-DISPLAY-SQLCODE     PIC -(8)9.                        
           05  WS-DISPLAY-COUNT       PIC 9(09).                        
           05  WS-DISPLAY-ACCOUNT     PIC 9(13).                        
           05  WS-DISPLAY-CUSTOMER    PIC 9(10).                        
           05  WS-DISPLAY-PREMISE     PIC 9(10).                        
           05  WS-DISPLAY-ADDRESS     PIC 9(13).                        
           05  RS-RETURN-CODE         PIC S9(4) COMP.                   
           05  RS-RETURN-CODE-DISP    PIC +Z(4).                        
           05  WS-COUNT-ROWS-1        PIC 9(9) VALUE 0.                 
           05  WS-COUNT-ROWS-2        PIC 9(9) VALUE 0.                 
           05  WS-COMMIT-COUNT        PIC S9(9) COMP VALUE 0.           
           05  WS-ROW-COUNT           PIC S9(9) COMP VALUE 0.           
           05  WS-CURRENT-TIMESTAMP   PIC X(26) VALUE SPACES.           
           05  WS-CURRENT-DATE        PIC X(10) VALUE SPACES.           
           05  WS-TRAN-APPL-NO        PIC S9(04) COMP VALUE 1.          
           05  WS-OLD-ADDRESS-ID      PIC 9(13) VALUE ZEROES.           
           05  WS-NEW-ADDRESS-ID      PIC 9(13) VALUE ZEROES.           
           05  WS-HOLD-CUSTOMER       PIC S9(10) COMP-3 VALUE 0.        
           05  WS-MULTIPLE-ACCOUNTS   PIC X(01) VALUE 'N'.              
           05  WS-LANDLORD-UPDATED    PIC X(01) VALUE 'N'.              
                                                                        
       COPY CWS00010.                                                           
       COPY CWS00071.                                                           
       COPY CWS00303.                                                           
            EXEC SQL                                                            
                INCLUDE CWS0090A                                                
            END-EXEC.                                                           
                                                                        
            EXEC SQL                                                            
                INCLUDE SQLCA                                                   
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBMODEL                                                 
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBPREM                                                  
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBACCT                                                  
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBADRFMT                                                
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBMNHIST                                                
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBMNHDT                                                 
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBADDRID                                                
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBMSTSUB                                                
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBLNDLRD                                                
            END-EXEC.                                                           
                                                                        
            EXEC SQL                                                    
                DECLARE BILL-ADDR-CURSOR CURSOR WITH HOLD FOR           
                    SELECT DISTINCT AT.ADDRESS_ID                       
                      FROM CSS_ACCOUNT AT                               
                    LEFT OUTER JOIN CSS_PREMISE PR                      
                      ON AT.ADDRESS_ID = PR.ADDRESS_ID                  
                    WHERE PR.PREMISE_NO IS NOT NULL                     
                      AND AT.ADDRESS_ID > 0                             
      *               AND AT.ADDRESS_ID NOT IN                                  
      *                   (SELECT DISTINCT ADDRESS_ID                           
      *                      FROM CSS_LANDLORD                                  
      *                     WHERE ADDRESS_FORMAT = 'A'                          
      *                       AND ADDRESS_ID > 0)                               
      *               AND AT.ACCOUNT_NO NOT IN                                  
      *                   (SELECT DISTINCT MST_ACCT_NO                          
      *                      FROM CSS_MSTSUB_ACCT)                              
      *               AND AT.ACCOUNT_NO NOT IN                                  
      *                   (SELECT DISTINCT SUB_ACCT_NO                          
      *                      FROM CSS_MSTSUB_ACCT)                              
                    ORDER BY AT.ADDRESS_ID                              
            END-EXEC.                                                   
                                                                        
            EXEC SQL                                                    
                DECLARE CUST-ADDR-CURSOR CURSOR FOR                     
                    SELECT AT.ACCOUNT_NO,                               
                           AT.CUSTOMER_NO,                              
                           AT.ADDRESS_ID                                
                      FROM CSS_ACCOUNT AT                               
                     WHERE ADDRESS_ID = :AT-ADDRESS-ID                  
                  ORDER BY AT.CUSTOMER_NO                               
            END-EXEC.                                                   
                                                                        
            EXEC SQL                                                    
                DECLARE LANDLORD-CURSOR CURSOR WITH HOLD FOR            
                    SELECT DISTINCT SI.ADDRESS_ID,                      
                                    SI.CUSTOMER_NO                      
                      FROM CSS_LANDLORD SI                              
                    WHERE SI.ADDRESS_ID > 0                             
                      AND SI.ADDRESS_FORMAT = 'A'                       
                      AND EXISTS                                        
                          (SELECT '1'                                   
                             FROM CSS_PREMISE                           
                            WHERE ADDRESS_ID = SI.ADDRESS_ID)           
                      AND NOT EXISTS                                    
                          (SELECT '2'                                   
                             FROM CSS_ACCOUNT                           
                            WHERE ADDRESS_ID = SI.ADDRESS_ID)           
                    ORDER BY SI.ADDRESS_ID                              
            END-EXEC.                                                   
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT CAST(SYSDATETIMEOFFSET() AS DATE)                         
               INTO  :WS-CURRENT-DATE                                   
               FROM   CSS_MODEL_SQL                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CURRENT DATE                                              
MFA-TR*        INTO  :WS-CURRENT-DATE                                           
MFA-TR*        FROM   CSS_MODEL_SQL                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 1000-PROCESSING THRU 1000-EXIT.                      
                                                                        
           DISPLAY WS-COUNT-ROWS-1.                                     
           DISPLAY WS-COUNT-ROWS-2.                                     
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESSING.                                                 
                                                                        
           EXEC SQL                                                     
               OPEN BILL-ADDR-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR OPENING BILL-ADDR-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 1100-FETCH-ROWS  THRU 1100-EXIT.                     
                                                                        
           EXEC SQL                                                     
               CLOSE BILL-ADDR-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CLOSING BILL-ADDR-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               OPEN LANDLORD-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR OPENING LANDLORD-CURSOR     **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 3100-FETCH-ROWS  THRU 3100-EXIT.                     
                                                                        
           EXEC SQL                                                     
               CLOSE LANDLORD-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CLOSING LANDLORD-CURSOR     **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH BILL-ADDR-CURSOR                                   
                INTO :AT-ADDRESS-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-ADDRESS-ID TO WS-DISPLAY-ADDRESS             
      *            DISPLAY 'BEGINNING ADDRESS ID ' WS-DISPLAY-ADDRESS           
                   PERFORM 1200-ADDRESS-PROCESSING THRU 1200-EXIT       
               WHEN NOT-FOUND                                           
                   GO TO 1100-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING BILL-ADDR-CURSOR   **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           ADD 1 TO WS-COMMIT-COUNT                                     
                    WS-COUNT-ROWS-1.                                    
                                                                        
           IF WS-COMMIT-COUNT > 200                                     
               EXEC SQL                                                 
                   COMMIT                                               
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                               
                                                                        
           GO TO 1100-FETCH-ROWS.                                       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1200-ADDRESS-PROCESSING.                                         
                                                                        
           MOVE 'N' TO WS-LANDLORD-UPDATED.                             
           MOVE ZEROES TO WS-HOLD-CUSTOMER.                             
           EXEC SQL                                                     
               SELECT ADDRESS_ID,                                       
                      HOUSE_NO,                                         
                      ADDR_PREFIX_1,                                    
                      ADDR_PREFIX_2,                                    
                      STREET_NAME,                                      
                      STREET_LOCATION_1,                                
                      STREET_LOCATION_2,                                
                      STREET_SUFFIX,                                    
                      ADDRESS_OVERFLOW,                                 
                      CARRIER_ROUTE,                                    
                      ZIP_CODE,                                         
                      ZIP_CODE_PLUS_FOUR,                               
                      ZIP_CODE_TOKEN,                                   
                      ADDR_USAGE_CD,                                    
                      ADDR_SUFFIX,                                      
                      USPS_DELIV_PT_CD                                  
                 INTO :DY-ADDRESS-ID,                                   
                      :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-STREET-SUFFIX,                                
                      :DY-ADDRESS-OVERFLOW,                             
                      :DY-CARRIER-ROUTE,                                
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-PLUS-FOUR,                           
                      :DY-ZIP-CODE-TOKEN,                               
                      :DY-ADDR-USAGE-CD,                                
                      :DY-ADDR-SUFFIX,                                  
                      :DY-USPS-DELIV-PT-CD                              
                 FROM CSS_ADDR_FORMATTED                                
                WHERE ADDRESS_ID = :AT-ADDRESS-ID                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE AT-ADDRESS-ID TO WS-DISPLAY-ADDRESS             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_ADDR_FORMATTED**'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ADDRESS = ' WS-DISPLAY-ADDRESS          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               OPEN CUST-ADDR-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR OPENING CUST-ADDR-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 1250-FETCH-ROWS  THRU 1250-EXIT.                     
                                                                        
           EXEC SQL                                                     
               CLOSE CUST-ADDR-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CLOSING CUST-ADDR-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1200-EXIT.                                                       
            EXIT.                                                       
                                                                        
       1250-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH CUST-ADDR-CURSOR                                   
                INTO :AT-ACCOUNT-NO,                                    
                     :AT-CUSTOMER-NO,                                   
                     :AT-ADDRESS-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
                   MOVE AT-CUSTOMER-NO TO WS-DISPLAY-CUSTOMER           
      *            DISPLAY 'ACCT/CUST ' WS-DISPLAY-ACCOUNT                      
      *                    ' ' WS-DISPLAY-CUSTOMER                              
               WHEN NOT-FOUND                                           
                   GO TO 1250-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING CUST-ADDR-CURSOR   **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           MOVE AT-ADDRESS-ID TO WS-OLD-ADDRESS-ID.                     
                                                                        
           IF AT-CUSTOMER-NO = WS-HOLD-CUSTOMER                         
               MOVE 'Y' TO WS-MULTIPLE-ACCOUNTS                         
               MOVE DY-ADDRESS-ID TO AT-ADDRESS-ID                      
               PERFORM 2000-UPDATE-ACCOUNT THRU 2000-EXIT               
           ELSE                                                         
               PERFORM 2100-GET-ADDRESS-ID THRU 2100-EXIT               
               PERFORM 2200-INSERT-ADDRESS THRU 2200-EXIT               
               MOVE DY-ADDRESS-ID TO AT-ADDRESS-ID                      
               PERFORM 2000-UPDATE-ACCOUNT THRU 2000-EXIT               
               PERFORM 2300-UPDATE-LANDLORD THRU 2300-EXIT              
      *        DISPLAY ' '                                                      
               MOVE AT-CUSTOMER-NO TO WS-HOLD-CUSTOMER
           END-IF.                 
                                                                        
           GO TO 1250-FETCH-ROWS.                                       
                                                                        
       1250-EXIT.                                                       
            EXIT.                                                       
                                                                        
       2000-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET ADDRESS_ID     = :AT-ADDRESS-ID                   
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR UPDATING CSS_ACCOUNT        **'   
                   DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
                   DISPLAY '**  ACCOUNT  = ' WS-DISPLAY-ACCOUNT         
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           MOVE AT-ADDRESS-ID TO WS-NEW-ADDRESS-ID.                     
           PERFORM 2400-JRNL-TRAN-HEAD THRU 2400-EXIT.                  
           PERFORM 2450-JRNL-UPDATE THRU 2450-EXIT.                     
      *    DISPLAY 'OLD = ' WS-OLD-ADDRESS-ID.                                  
      *    DISPLAY 'NEW = ' WS-NEW-ADDRESS-ID.                                  
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-GET-ADDRESS-ID.                                             
                                                                        
           MOVE SPACES                        TO WS-90-PANEL-NO.        
           MOVE SPACES                        TO WS-90-USERID.          
           MOVE ZEROES                        TO WS-90-ACCOUNT-NO.      
           MOVE ZEROES                        TO WS-90-CUSTOMER-NO.     
           MOVE ZEROES                        TO WS-90-PREMISE-NO.      
                                                                        
           PERFORM 6202-GET-NEW-ADDRESS-ID    THRU 6202-EXIT.           
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-INSERT-ADDRESS.                                             
                                                                        
           MOVE WS-90-NEW-ADDRESS-ID          TO DY-ADDRESS-ID.         
           EXEC SQL                                                     
              INSERT INTO CSS_ADDR_FORMATTED                            
                    (ADDRESS_ID        ,                                
                     HOUSE_NO          ,                                
                     ADDR_PREFIX_1     ,                                
                     ADDR_PREFIX_2     ,                                
                     STREET_NAME       ,                                
                     STREET_LOCATION_1 ,                                
                     STREET_LOCATION_2 ,                                
                     STREET_SUFFIX     ,                                
                     ADDR_SUFFIX       ,                                
                     ADDRESS_OVERFLOW  ,                                
                     CARRIER_ROUTE     ,                                
                     ZIP_CODE          ,                                
                     ZIP_CODE_PLUS_FOUR,                                
                     ZIP_CODE_TOKEN    ,                                
                     USPS_DELIV_PT_CD  ,                                
                     ADDR_USAGE_CD)                                     
               VALUES                                                   
                   (:DY-ADDRESS-ID        ,                             
                    :DY-HOUSE-NO          ,                             
                    :DY-ADDR-PREFIX-1     ,                             
                    :DY-ADDR-PREFIX-2     ,                             
                    :DY-STREET-NAME       ,                             
                    :DY-STREET-LOCATION-1 ,                             
                    :DY-STREET-LOCATION-2 ,                             
                    :DY-STREET-SUFFIX     ,                             
                    :DY-ADDR-SUFFIX       ,                             
                    :DY-ADDRESS-OVERFLOW  ,                             
                    :DY-CARRIER-ROUTE     ,                             
                    :DY-ZIP-CODE          ,                             
                    :DY-ZIP-CODE-PLUS-FOUR,                             
                    :DY-ZIP-CODE-TOKEN    ,                             
                    :DY-USPS-DELIV-PT-CD  ,                             
                    :DY-ADDR-USAGE-CD)                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE DY-ADDRESS-ID TO WS-DISPLAY-ADDRESS             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR INSERTING CSS_ADDR_FORMATTED**'   
                   DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
                   DISPLAY '**  ADDRESS  = ' WS-DISPLAY-ADDRESS         
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-UPDATE-LANDLORD.                                            
                                                                        
           MOVE WS-OLD-ADDRESS-ID TO SI-ADDRESS-ID.                     
           MOVE 'Y' TO WS-LANDLORD-UPDATED.                             
           EXEC SQL                                                     
               UPDATE CSS_LANDLORD                                      
                  SET ADDRESS_ID     = :AT-ADDRESS-ID                   
                WHERE ADDRESS_ID     = :SI-ADDRESS-ID                   
                  AND ADDRESS_FORMAT = 'A'                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
                   MOVE SI-ADDRESS-ID TO WS-DISPLAY-ADDRESS             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR UPDATING CSS_LANDLORD       **'   
                   DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
                   DISPLAY '**  ACCOUNT  = ' WS-DISPLAY-ACCOUNT         
                   DISPLAY '**  ADDRESS  = ' WS-DISPLAY-ADDRESS         
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-JRNL-TRAN-HEAD.                                             
                                                                        
           EXEC SQL                                                     
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
               INTO  :WS-CURRENT-TIMESTAMP                              
               FROM   CSS_MODEL_SQL                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CURRENT TIMESTAMP                                         
MFA-TR*        INTO  :WS-CURRENT-TIMESTAMP                                      
MFA-TR*        FROM   CSS_MODEL_SQL                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE 1                        TO WS-TRAN-APPL-NO             
                                            MI-TRAN-APPL-NO.            
                                                                        
           MOVE SPACES                   TO MH-RESP-AREA-ID.            
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE ZEROES                   TO MH-CUSTOMER-NO.             
           MOVE ZEROES                   TO MH-PREMISE-NO.              
           MOVE AT-ACCOUNT-NO            TO MH-ACCOUNT-NO.              
           MOVE 'SYSTEM'                 TO MH-USER-ID.                 
           MOVE 'PANEL086'               TO MH-APPL-PROGRAM-ID.         
           MOVE ZERO                     TO MH-TRAN-COMMENT-LEN.        
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2450-JRNL-UPDATE.                                                
                                                                        
           MOVE WS-CURRENT-TIMESTAMP    TO MH-TRANS-HIST-SEQ-NO.        
           MOVE WS-CURRENT-DATE         TO MH-DATE-TRANS.               
           MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
                                                                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +13                   TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE WS-OLD-ADDRESS-ID     TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE +13                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE WS-NEW-ADDRESS-ID     TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE 'ADDRESS ID'          TO MI-COLUMN-DESC.                
           MOVE '  '                  TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       2450-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH LANDLORD-CURSOR                                    
                INTO :SI-ADDRESS-ID,                                    
                     :SI-CUSTOMER-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE SI-ADDRESS-ID TO WS-DISPLAY-ADDRESS             
      *            DISPLAY 'BEGINNING ADDRESS ID ' WS-DISPLAY-ADDRESS           
                   PERFORM 3200-ADDRESS-PROCESSING THRU 3200-EXIT       
               WHEN NOT-FOUND                                           
                   GO TO 3100-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING LANDLORD-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           ADD 1 TO WS-COMMIT-COUNT                                     
                    WS-COUNT-ROWS-2.                                    
                                                                        
           IF WS-COMMIT-COUNT > 200                                     
               EXEC SQL                                                 
                   COMMIT                                               
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                               
                                                                        
           GO TO 3100-FETCH-ROWS.                                       
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3200-ADDRESS-PROCESSING.                                         
                                                                        
           EXEC SQL                                                     
               SELECT ADDRESS_ID,                                       
                      HOUSE_NO,                                         
                      ADDR_PREFIX_1,                                    
                      ADDR_PREFIX_2,                                    
                      STREET_NAME,                                      
                      STREET_LOCATION_1,                                
                      STREET_LOCATION_2,                                
                      STREET_SUFFIX,                                    
                      ADDRESS_OVERFLOW,                                 
                      CARRIER_ROUTE,                                    
                      ZIP_CODE,                                         
                      ZIP_CODE_PLUS_FOUR,                               
                      ZIP_CODE_TOKEN,                                   
                      ADDR_USAGE_CD,                                    
                      ADDR_SUFFIX,                                      
                      USPS_DELIV_PT_CD                                  
                 INTO :DY-ADDRESS-ID,                                   
                      :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-STREET-SUFFIX,                                
                      :DY-ADDRESS-OVERFLOW,                             
                      :DY-CARRIER-ROUTE,                                
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-PLUS-FOUR,                           
                      :DY-ZIP-CODE-TOKEN,                               
                      :DY-ADDR-USAGE-CD,                                
                      :DY-ADDR-SUFFIX,                                  
                      :DY-USPS-DELIV-PT-CD                              
                 FROM CSS_ADDR_FORMATTED                                
                WHERE ADDRESS_ID = :SI-ADDRESS-ID                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE SI-ADDRESS-ID TO WS-DISPLAY-ADDRESS             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_ADDR_FORMATTED**'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ADDRESS = ' WS-DISPLAY-ADDRESS          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 2100-GET-ADDRESS-ID THRU 2100-EXIT.                  
           PERFORM 2200-INSERT-ADDRESS THRU 2200-EXIT.                  
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_LANDLORD                                      
                  SET ADDRESS_ID     = :DY-ADDRESS-ID                   
                WHERE ADDRESS_ID     = :SI-ADDRESS-ID                   
                  AND CUSTOMER_NO    = :SI-CUSTOMER-NO                  
                  AND ADDRESS_FORMAT = 'A'                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE SI-ADDRESS-ID TO WS-DISPLAY-ADDRESS             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR UPDATING CSS_LANDLORD 3200  **'   
                   DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
                   DISPLAY '**  ADDRESS  = ' WS-DISPLAY-ADDRESS         
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       3200-EXIT.                                                       
            EXIT.                                                       
                                                                        
       6530-LOAD-MNT-TRANS-HIST.                                        
                                                                        
           IF MI-TRAN-APPL-NO = 1                                       
              PERFORM 6540-INSERT-MNT-TRANS-HIST THRU 6540-EXIT         
              PERFORM 6550-INSERT-MT-TRN-HST-DET THRU 6550-EXIT         
           ELSE                                                         
              PERFORM 6550-INSERT-MT-TRN-HST-DET THRU 6550-EXIT
           END-IF.        
                                                                        
       6530-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6540-INSERT-MNT-TRANS-HIST.                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MNT_TRANS_HIST                           
                 ( TRANS_HIST_SEQ_NO,                                   
                   DATE_TRANS,                                          
                   CODE_TRAN_TYPE,                                      
                   RESP_AREA_ID,                                        
                   ACCOUNT_NO,                                          
                   CUSTOMER_NO,                                         
                   PREMISE_NO,                                          
                   USER_ID,                                             
                   APPL_PROGRAM_ID,                                     
                   TRAN_COMMENT)                                        
               VALUES                                                   
                 ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO),                   
                   IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),                              
                   :MH-CODE-TRAN-TYPE,                                  
                   :MH-RESP-AREA-ID,                                    
                   :MH-ACCOUNT-NO,                                      
                   :MH-CUSTOMER-NO,                                     
                   :MH-PREMISE-NO,                                      
                   :MH-USER-ID,                                         
                   :MH-APPL-PROGRAM-ID,                                 
                   :MH-TRAN-COMMENT)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST                                   
MFA-TR*          ( TRANS_HIST_SEQ_NO,                                           
MFA-TR*            DATE_TRANS,                                                  
MFA-TR*            CODE_TRAN_TYPE,                                              
MFA-TR*            RESP_AREA_ID,                                                
MFA-TR*            ACCOUNT_NO,                                                  
MFA-TR*            CUSTOMER_NO,                                                 
MFA-TR*            PREMISE_NO,                                                  
MFA-TR*            USER_ID,                                                     
MFA-TR*            APPL_PROGRAM_ID,                                             
MFA-TR*            TRAN_COMMENT)                                                
MFA-TR*        VALUES                                                           
MFA-TR*          ( :MH-TRANS-HIST-SEQ-NO,                                       
MFA-TR*            :MH-DATE-TRANS,                                              
MFA-TR*            :MH-CODE-TRAN-TYPE,                                          
MFA-TR*            :MH-RESP-AREA-ID,                                            
MFA-TR*            :MH-ACCOUNT-NO,                                              
MFA-TR*            :MH-CUSTOMER-NO,                                             
MFA-TR*            :MH-PREMISE-NO,                                              
MFA-TR*            :MH-USER-ID,                                                 
MFA-TR*            :MH-APPL-PROGRAM-ID,                                         
MFA-TR*            :MH-TRAN-COMMENT)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '** ERROR INSERTING CSS_MNT_TRN_HIST   **'       
               DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE               
               DISPLAY '** PROCESSING TERMINATED              **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
       6540-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6550-INSERT-MT-TRN-HST-DET.                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MT_TRN_HST_DET                           
               ( TRANS_HIST_SEQ_NO,                                     
                 TRAN_APPL_NO,                                          
                 COLUMN_DESC,                                           
                 PRV_COLUMN_VALUE,                                      
                 CHG_COLUMN_VALUE,                                      
                 TABLE_ID)                                              
               VALUES                                                   
               ( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO),                     
                 :MI-TRAN-APPL-NO,                                      
                 :MI-COLUMN-DESC,                                       
                 :MI-PRV-COLUMN-VALUE,                                  
                 :MI-CHG-COLUMN-VALUE,                                  
                 :MI-TABLE-ID)                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MT_TRN_HST_DET                                   
MFA-TR*        ( TRANS_HIST_SEQ_NO,                                             
MFA-TR*          TRAN_APPL_NO,                                                  
MFA-TR*          COLUMN_DESC,                                                   
MFA-TR*          PRV_COLUMN_VALUE,                                              
MFA-TR*          CHG_COLUMN_VALUE,                                              
MFA-TR*          TABLE_ID)                                                      
MFA-TR*        VALUES                                                           
MFA-TR*        ( :MI-TRANS-HIST-SEQ-NO,                                         
MFA-TR*          :MI-TRAN-APPL-NO,                                              
MFA-TR*          :MI-COLUMN-DESC,                                               
MFA-TR*          :MI-PRV-COLUMN-VALUE,                                          
MFA-TR*          :MI-CHG-COLUMN-VALUE,                                          
MFA-TR*          :MI-TABLE-ID)                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '** ERROR INSERTING CSS_MT_TRN_HST_DET **'       
               DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE               
               DISPLAY '** PROCESSING TERMINATED              **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
       6550-EXIT.                                                       
           EXIT.                                                        
                                                                        
       COPY CPD0023B.                                                           
            EXEC SQL                                                            
                INCLUDE CPD00090                                                
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE CPD00071                                                
            END-EXEC.                                                           
                                                                        
      ********************************************************                  
      **  SET THE RETURN CODE AND END.                      **                  
      ********************************************************                  
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE             
           DISPLAY '****************************************'           
           DISPLAY '** ERROR GETTING NEXT ADDRESS ID      **'           
           DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                   
           DISPLAY '** ' ABEND-FUNCTION ' ** ' TABLE-1                  
           DISPLAY '** PROCESSING TERMINATED              **'           
           DISPLAY '****************************************'.          
                                                                        
                                                                        
       9000-EXIT.                                                       
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          
                                                                        
           PERFORM 9900-ABEND THRU 9900-ABEND-EXIT.                     
                                                                        
       9900-EXIT.                                                       
                                                                        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSDP001 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-ABEND-EXIT.                                                 
           EXIT.                                                        
