       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCC003.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **   COMMUNICATION DELETE                                      **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS  REASON                                 **         
      *    ----     --------  ------                                 **         
      *    10/02    FB        ORIGINAL VERSION                       **         
T35434**   06/07    PC97415   REPLACED MODEL_SQL TO SET COMMANDS     **         
T35434**                      AND ADDED FETCH ONLY WITH UR FOR       **         
T35434**                      AVOIDING -911 ABENDS.                  **         
A501E *    02/09    FB        REPLACE DISTINCT WITH FETCH FIRST 1    **         
A501E *                       ROWS ONLY.  REMOVE DELETE FROM         **         
A501E *                       CSS_COMM_COMMENT AND LET IT CASCADE.   **         
A04527*    06/13    AS7C117   REMOVE UNUSED COPYBOOK CWS00056        **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCC003'.
MSQ017     COPY MFASQLM.
                                                                        
       01  MISC.                                                        
           05  WS-DISPLAY-SQLCODE     PIC -(8)9.                        
           05  WS-DISPLAY-COUNT       PIC 9(09).                        
           05  RS-RETURN-CODE         PIC S9(4) COMP.                   
           05  RS-RETURN-CODE-DISP    PIC +Z(4).                        
           05  WS-RED-FL-NULL-IND     PIC S9(4) COMP VALUE 0.           
           05  WS-COMMIT-COUNT        PIC S9(9) COMP VALUE 0.           
           05  WS-DELETE-COUNT        PIC S9(9) COMP VALUE 0.           
           05  WS-DELETE-COMM         PIC X VALUE 'N'.                  
           05  WS-NEW-COMMENTS        PIC X VALUE 'N'.                  
           05  WS-TWO-YEARS-AGO-TS    PIC X(26).                        
           05  WS-OLD-TIMESTAMP.                                        
               10  WS-TWO-YEARS-AGO-DT    PIC X(10) VALUE SPACES.       
               10  FILLER                 PIC X(16)                     
                                          VALUE '-00.00.00.000000'.     
                                                                        
       COPY CWS00010.                                                           
       COPY CWS00303.                                                           
                                                                        
            EXEC SQL                                                            
                INCLUDE SQLCA                                                   
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBCOMDAT                                                
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBCOMCMT                                                
            END-EXEC.                                                           
                                                                        
            EXEC SQL                                                    
                DECLARE COMM-CURSOR CURSOR WITH HOLD FOR                
                    SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           COMMUNICATION_ID, 121), ' ', '-'), ':', '.') 
           COMMUNICATION_ID,                            
                           RED_FLAG_IND,                                
                           REPLACE(REPLACE(CONVERT(CHAR(26), 
           RED_FLAG_EXPIRE_DT, 121), ' ', '-'), ':', '.') 
           RED_FLAG_EXPIRE_DT                           
                      FROM CSS_COMM_DATA WITH(READUNCOMMITTED)                  
                     WHERE COMMUNICATION_ID < CIS.CHAR2TIMESTAMP(
                                                   :KO-COMMUNICATION-ID
              )      
T35434               FOR READ ONLY                              
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE COMM-CURSOR CURSOR WITH HOLD FOR                        
MFA-TR*             SELECT COMMUNICATION_ID,                                    
MFA-TR*                    RED_FLAG_IND,                                        
MFA-TR*                    RED_FLAG_EXPIRE_DT                                   
MFA-TR*               FROM CSS_COMM_DATA                                        
MFA-TR*              WHERE COMMUNICATION_ID < :KO-COMMUNICATION-ID              
MFA-TR*              FOR FETCH ONLY WITH UR                                     
MFA-TR*     END-EXEC.                                                           
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           EXEC SQL                                                     
T35434         SELECT
              DATEADD( YEAR, -2, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-TWO-YEARS-AGO-DT        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-TWO-YEARS-AGO-DT = CURRENT DATE - 2 YEARS                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35434     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T35434     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T35434         NEXT SENTENCE                                            
T35434     ELSE                                                         
T35434         MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
T35434         DISPLAY '****************************************'       
T35434         DISPLAY '**  ERROR SETTING WS-TWO-YEARS-AGO-DT **'       
T35434         DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
T35434         DISPLAY '**  PROCESSING TERMINATED             **'       
T35434         DISPLAY '****************************************'       
T35434         PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
           PERFORM 1000-DELETE-COMM    THRU 1000-EXIT.                  
           MOVE WS-DELETE-COUNT TO WS-DISPLAY-COUNT.                    
           DISPLAY 'COMMUNICATIONS DELETED: ' WS-DISPLAY-COUNT.         
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-DELETE-COMM.                                                
                                                                        
           MOVE WS-OLD-TIMESTAMP    TO WS-TWO-YEARS-AGO-TS.             
           MOVE WS-TWO-YEARS-AGO-TS TO KO-COMMUNICATION-ID.             
           EXEC SQL                                                     
               OPEN COMM-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR OPENING COMM-CURSOR         **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
           MOVE 0 TO WS-COMMIT-COUNT.                                   
           PERFORM 1100-FETCH-COMM THRU 1100-EXIT.                      
                                                                        
           EXEC SQL                                                     
               CLOSE COMM-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CLOSING COMM-CURSOR         **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-FETCH-COMM.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH COMM-CURSOR                                        
                INTO :KO-COMMUNICATION-ID,                              
                     :KO-RED-FLAG-IND,                                  
                     :KO-RED-FLAG-EXPIRE-DT :WS-RED-FL-NULL-IND          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-RED-FL-NULL-IND < 0                            
                       MOVE SPACES TO KO-RED-FLAG-EXPIRE-DT             
                   END-IF                                               
                   MOVE 'N' TO WS-DELETE-COMM                           
                   IF KO-RED-FLAG-IND = 'Y' AND                         
                     (KO-RED-FLAG-EXPIRE-DT < WS-TWO-YEARS-AGO-TS AND   
                      KO-RED-FLAG-EXPIRE-DT > SPACES)                   
                          MOVE 'Y' TO WS-DELETE-COMM                    
                   END-IF                                               
                   IF KO-RED-FLAG-IND = 'N' OR ' '                      
                       MOVE 'Y' TO WS-DELETE-COMM                       
                   END-IF                                               
                   IF WS-DELETE-COMM = 'Y'                              
                       PERFORM 1200-LOOK-AT-COMMENTS THRU 1200-EXIT     
                   END-IF                                               
                   IF WS-DELETE-COMM = 'Y'                              
                       PERFORM 1300-DELETE-COMMS     THRU 1300-EXIT     
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   GO TO 1100-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING COMM-CURSOR        **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
           GO TO 1100-FETCH-COMM.                                       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1200-LOOK-AT-COMMENTS.                                           
                                                                        
           EXEC SQL                                                     
A501E          SELECT TOP(1) 'Y'                                               
                 INTO :WS-NEW-COMMENTS                                  
                 FROM CSS_COMM_COMMENT WITH(READUNCOMMITTED)                    
                WHERE COMMUNICATION_ID = CIS.CHAR2TIMESTAMP(
                                                   :KO-COMMUNICATION-ID
              )           
                  AND UPDATE_TS > CIS.CHAR2TIMESTAMP(
                                                   :WS-TWO-YEARS-AGO-TS
              )                  
A501E                                            
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-NEW-COMMENTS                                          
MFA-TR*          FROM CSS_COMM_COMMENT                                          
MFA-TR*         WHERE COMMUNICATION_ID = :KO-COMMUNICATION-ID                   
MFA-TR*           AND UPDATE_TS > :WS-TWO-YEARS-AGO-TS                          
MFA-TR*           FETCH FIRST 1 ROWS ONLY                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NEW-COMMENTS = 'Y'                             
                       MOVE 'N' TO WS-DELETE-COMM                       
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING COMM-CURSOR        **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1300-DELETE-COMMS.                                               
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_COMM_DATA                                
                WHERE COMMUNICATION_ID = CIS.CHAR2TIMESTAMP(
                                                   :KO-COMMUNICATION-ID
              )           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_COMM_DATA                                        
MFA-TR*         WHERE COMMUNICATION_ID = :KO-COMMUNICATION-ID                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR DELETING COMM DATA          **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
           ADD 1 TO WS-COMMIT-COUNT                                     
                    WS-DELETE-COUNT.                                    
           IF WS-COMMIT-COUNT > 250                                     
               EXEC SQL                                                 
                   COMMIT                                               
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                               
                                                                        
       1300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       COPY CPD0023B.                                                           
                                                                        
      ********************************************************                  
      **  SET THE RETURN CODE AND END.                      **                  
      ********************************************************                  
                                                                        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSCC003 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
