       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSCB754.                                            
       AUTHOR.     RICK BLACK.                                          
       DATE-WRITTEN. DEC-2002.                                          
      *****************************************************************         
      **               SOUTH CAROLINA ELECTRIC & GAS                 **         
      **                                                             **         
      **                                                             **         
      *****************************************************************         
      ********             CREDITS AND COLLECTIONS            *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **   05/12/16     DB41297   WRITE TO DB2 TABLE INSTEAD OF FILE.**         
      *                                                                         
      *****************************************************************         
      *      REMARKS.                                                           
      *****************************************************************         
      *****************************************************************         
      *        REPORT GENERATOR FOR PCSCB754 REPORTS                  *         
      *        THIS IS A NEW PROGRAM WRITTEN FOR GENERATING           *         
      *        DAILY COLLECTORS SUMMARY AND DETAIL REPORT FOR         *         
      *        CREDITS AND COLLECTIONS                                *         
      *****************************************************************         
                         ---- BASIC SEQUENCE STRUCTURE ----             
                    0000 - 0999     MAIN CONTROL PATH                   
                    1000 - 1999     INITIALIZATION                      
                    1000 - 1999     INPUT PROCESSING CONTROL PATH       
                    2000 - 2999     OUTPUT PROCESSING CONTROL PATH      
                    3000 - 4999     BATCH PROCESSING MODULES - NOT USED 
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCB754'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40) VALUE                
           'WORKING STORAGE FOR PCSCB754 STARTS HERE'.                  
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-PTP-AMT-TOTAL          PIC S9(09)V99 COMP-3 VALUE 0.  
           05  WS-PTP-ARREARS            PIC 99V99 VALUE 0.             
           05  WS-TOTAL-ARREARS          PIC S9(09)V99 COMP-3 VALUE 0.  
           05  WS-PTP-COUNT              PIC 9(09) COMP-3 VALUE 0.      
           05  WS-PK-COUNT               PIC 9(09) COMP-3 VALUE 0.      
           05  WS-DAILY-PROM-KEPT        PIC S9(09)V99 COMP-3 VALUE 0.  
           05  WS-DAILY-PROM-BRKN        PIC S9(09)V99 COMP-3 VALUE 0.  
           05  WS-PB-COUNT               PIC 9(09) COMP-3 VALUE 0.      
           05  WS-ACCTS-WRKD-COUNT       PIC 9(09) COMP-3 VALUE 0.      
           05  WS-MONTH-BEG-DATE         PIC X(10).                     
           05  WS-CURRENT-DAY            PIC X(10).                     
           05  WS-REPORT-DATE            PIC X(10).                     
           05  WS-YESTERDAY              PIC X(10).                     
           05  WS-DET-DATE               PIC X(10).                     
           05  WS-AMT-COLLECTED          PIC S9(09)V99 COMP-3 VALUE 0.  
           05  WS-USER-ID.                                              
               49 WS-USER-ID-LEN         PIC S9(4) USAGE COMP.          
               49 WS-USER-ID-TEXT        PIC X(18).                     
           05  WS-COLL-AGENT-ID          PIC X(7).                      
           05  WS-NULL-IND               PIC S9(04) COMP.               
           05  WS-TEMP-REG-GROUP-CD      PIC X(03).                     
           05  WS-PTP-HOUR               PIC 9(01)V9 VALUE 0.           
           05  WS-WORK-DATE              PIC X(10).                     
           05  WS-TEST-DATE              PIC X(10).                     
           05  WS-ADJ-DAY                PIC S9(9) COMP.                
           05  WS-LOGOFF-HRS             PIC S9(2).                     
COB305     05 WS-DURATION-TIME        PIC S9(6)V COMP-3 VALUE 0.             
           05  WS-HOURS                  PIC 9(6).                      
           05  WS-MINS                   PIC 9(6).                      
           05  WS-SECS                   PIC 9(9).                      
           05  WS-MINS-TO-HRS            PIC S9(3)V9.                   
           05  WS-SECS-TO-HRS            PIC S9(3)V9.                   
           05  WS-TOTAL-HRS              PIC S9(4)V9.                   
           05  WS-DURATION-NUM           PIC 9(06).                     
           05  WS-DURATION-NUM-BKP REDEFINES WS-DURATION-NUM.           
               10 WS-DURATION-NUM-R.                                    
                  15 WS-DURATION-NUM-HH          PIC 9(02).             
                  15 WS-DURATION-NUM-MM          PIC 9(02).             
                  15 WS-DURATION-NUM-SS          PIC 9(02).             
           05  WS-NO-OF-BUS-DAYS         PIC S9(9) COMP.                
           05  WS-DAY-OF-MONTH           PIC S9(9) COMP.                
           05  WS-DELINQ-CD.                                            
               10  WS-CQ                 PIC X(07) VALUE 'CQ-HRS-'.     
               10  WS-ID                 PIC X(07).                     
           05  WS-COLL-RESULT-CD         PIC X(04).                     
           05  WS-NAME.                                                 
               10 WS-FIRST                PIC X(01).                    
               10 WS-FILLER               PIC X(01) VALUE ' '.          
               10 WS-LAST                 PIC X(14).                    
           05  WS-LOGOFF-TIME.                                          
               10 WS-HRS                  PIC X(02).                    
               10 WS-FILLER               PIC X(01) VALUE '.'.          
               10 WS-MIN                  PIC X(02) VALUE '00'.         
               10 WS-FILLER               PIC X(01) VALUE '.'.          
               10 WS-SEC                  PIC X(02) VALUE '00'.         
      *                                                                         
           05  WS-DISP-RC                PIC -ZZZZZZZZ9.9.              
           05  WS-ERR-MSG                PIC X(40) VALUE SPACES.        
           05  WS-PGRMNAME               PIC X(08) VALUE 'PCSCB754'.    
           05  WS-PGRNAME                PIC X(08) VALUE 'PCSCB754'.    
           05  WS-NO-COMP-RECORDS        PIC 9(07) VALUE ZEROES.        
           05  WS-NO-TOT-RECORDS         PIC 9(07) VALUE ZEROES.        
           05  WS-PREV-COMP-NO           PIC X(02) VALUE SPACES.        
           05  WS-PREV-ACCT-NO           PIC S9(13) COMP-3 VALUE 0.     
           05  WS-MULTIPLE-ROWS          PIC S9(9) VALUE -811.          
           05  WS-DISP-OFFICE            PIC X(3)  VALUE SPACES.        
      *                                                                         
       01  WS-SWITCHES.                                                 
           05 WS-FIRST-TIME-FLAG         PIC X(01) VALUE 'N'.           
              88 FIRST-TIME              VALUE 'Y'.                     
              88 NOT-FIRST-TIME          VALUE 'N'.                     
           05 WS-FIRST-TIME-FLAG2        PIC X(01) VALUE 'N'.           
              88 FIRST-TIME2             VALUE 'Y'.                     
              88 NOT-FIRST-TIME2         VALUE 'N'.                     
           05 WS-MORE-ROWS-FLAG          PIC X(01)  VALUE 'Y'.          
              88 END-OF-ROWS             VALUE 'N'.                     
              88 MORE-ROWS               VALUE 'Y'.                     
           05 WS-MORE-ACTIVITY           PIC X(01)  VALUE 'Y'.          
              88 END-ACTIVITY            VALUE 'N'.                     
              88 MORE-ACTIVITY           VALUE 'Y'.                     
           05 WS-MORE-USER               PIC X(01)  VALUE 'Y'.          
              88 END-OF-USERS            VALUE 'N'.                     
              88 MORE-USERS              VALUE 'Y'.                     
           05 WS-RECORD-FOUND            PIC X(01)  VALUE 'N'.          
              88 RECORD-FOUND            VALUE 'Y'.                     
              88 NO-RECORD-FOUND         VALUE 'N'.                     
           05 WS-TODAY                   PIC X(01)  VALUE 'N'.          
              88 BUSDAY-TODAY            VALUE 'Y'.                     
              88 NOT-BUSDAY-TODAY        VALUE 'N'.                     
           05 WS-YEST-DAY                PIC X(01)  VALUE 'N'.          
              88 BUSDAY-YEST             VALUE 'Y'.                     
              88 NOT-BUSDAY-YEST         VALUE 'N'.                     
           05 WS-DATABASE                PIC 9(01) VALUE 0.             
              88  CSR-DATABASE                     VALUE 1.             
              88  SEB-DATABASE                     VALUE 2.             
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CURRENT-YY             PIC 9(02).                     
           05  WS-CURRENT-MM             PIC 9(02).                     
           05  WS-CURRENT-DD             PIC 9(02).                     
      *                                                                         
       01  WS-CURRENT-TIME               PIC 9(08).                     
       01  WS-CURRENT-TIMESTAMP          PIC X(26).                     
      *                                                                         
       01  WS-FLAGS.                                                    
           05 WS-Y                      PIC X(01)     VALUE 'Y'.        
           05 WS-N                      PIC X(01)     VALUE 'N'.        
      *                                                                         
      *************************************************                         
      *  COMMON COPYBOOK FOR WS-VARIABLES             *                         
      *************************************************                         
       COPY CWS00038.                                                           
       COPY CWS00039.                                                           
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
      *COPY CJF00101.                                                           
       COPY FIOCA01.                                                            
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
       COPY FIORP754.                                                           
      *                                                                         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * SQL COMMUNICATION AREA                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_JOB_PARM                                                  *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
      *                                                                         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_COLLECT_HIST                                              *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBCOLHST                                                
           END-EXEC.                                                            
      *                                                                         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_COLL_HIST_DET                                             *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBCOLDET                                                
           END-EXEC.                                                            
      *                                                                         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_MODEL_SQL                                                 *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBMODEL                                                 
           END-EXEC.                                                            
      *                                                                         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_COMPANY                                                   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_DELINQUENCY                                               *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_HOLIDAY                                                   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
              INCLUDE TBHLDAY                                                   
           END-EXEC.                                                            
      *                                                                         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_ACCOUNT                                                   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_REG_PROFILE                                               *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_USER_PROFILE                                               *        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_RESP_AREA                                                  *        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
              INCLUDE TBRSAREA                                                  
           END-EXEC.                                                            
      *                                                                         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_COLL_ACTIVITY                                             *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
              INCLUDE TBCOLACT                                                  
           END-EXEC.                                                            
      *                                                                         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_CATEGORY                     *                                      
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
              INCLUDE  TBCAT                                                    
           END-EXEC.                                                            
      *                                                                         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_RPT_PCSCA754                 *                                      
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
              INCLUDE TBRPT754                                                  
           END-EXEC.                                                            
      *                                                                         
       01 WS-TIME-FIELDS.                                               
           05  WS-LOG-IN-TIME             PIC X(08) VALUE SPACES.       
           05  WS-LOG-OFF-TIME            PIC X(08) VALUE SPACES.       
      *                                                                         
      *---------------------------------------------------------------*         
      * BATCH_ACTIVE CURSOR FOR FETCHING FROM CSS_COLL_HIST_DET       *         
      *---------------------------------------------------------------*         
      *                                                                         
           EXEC SQL                                                     
                DECLARE COLLECT-DET CURSOR FOR                          
                   SELECT LH.ACCOUNT_NO                                 
                         ,LH.PTP_AMT                                    
                         ,LH.COLL_RESULT_CD                             
                         ,LH.COLL_AGENT_ID                              
                         ,RECORD_CREATION_DT                            
                         ,AT.COMPANY_NO                                 
                         ,AT.LOCAL_OFFICE                               
                         ,AT.CODE_ACCT_STAT                             
                         ,LH.PTP_STATUS_CD                              
                    FROM  CSS_COLL_HIST_DET LH WITH(READUNCOMMITTED)            
                         ,CSS_ACCOUNT       AT WITH(READUNCOMMITTED)            
                   WHERE  RECORD_CREATION_DT  = IIF(TRY_CONVERT(DATE, 
                                                        :WS-REPORT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-REPORT-DATE
              ) <> 0) OR (LEN(:WS-REPORT-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-REPORT-DATE
              ), CONVERT(DATE, :WS-REPORT-DATE) )         
                     AND  LH.COLL_AGENT_ID    = :WS-COLL-AGENT-ID       
                     AND  LH.LAST_UPDATE_USERID = LH.COLL_AGENT_ID      
                     AND  LH.COLL_AGENT_ID > ' '                        
                     AND  LH.COLL_AGENT_ID <> 'GENESYS'                 
                     AND  LH.ACCOUNT_NO = AT.ACCOUNT_NO                 
                   ORDER BY AT.COMPANY_NO, AT.LOCAL_OFFICE,             
                            LH.COLL_AGENT_ID, LH.ACCOUNT_NO,            
                            LH.TRANS_ID                                 
                     FOR READ ONLY                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE COLLECT-DET CURSOR FOR                                  
MFA-TR*            SELECT LH.ACCOUNT_NO                                         
MFA-TR*                  ,LH.PTP_AMT                                            
MFA-TR*                  ,LH.COLL_RESULT_CD                                     
MFA-TR*                  ,LH.COLL_AGENT_ID                                      
MFA-TR*                  ,RECORD_CREATION_DT                                    
MFA-TR*                  ,AT.COMPANY_NO                                         
MFA-TR*                  ,AT.LOCAL_OFFICE                                       
MFA-TR*                  ,AT.CODE_ACCT_STAT                                     
MFA-TR*                  ,LH.PTP_STATUS_CD                                      
MFA-TR*             FROM  CSS_COLL_HIST_DET LH                                  
MFA-TR*                  ,CSS_ACCOUNT       AT                                  
MFA-TR*            WHERE  RECORD_CREATION_DT  = :WS-REPORT-DATE                 
MFA-TR*              AND  LH.COLL_AGENT_ID    = :WS-COLL-AGENT-ID               
MFA-TR*              AND  LH.LAST_UPDATE_USERID = LH.COLL_AGENT_ID              
MFA-TR*              AND  LH.COLL_AGENT_ID > ' '                                
MFA-TR*              AND  LH.COLL_AGENT_ID <> 'GENESYS'                         
MFA-TR*              AND  LH.ACCOUNT_NO = AT.ACCOUNT_NO                         
MFA-TR*            ORDER BY AT.COMPANY_NO, AT.LOCAL_OFFICE,                     
MFA-TR*                     LH.COLL_AGENT_ID, LH.ACCOUNT_NO,                    
MFA-TR*                     LH.TRANS_ID                                         
MFA-TR*              FOR FETCH ONLY WITH UR                                     
MFA-TR*          QUERYNO 7100                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CURSOR FOR FETCHING COLLECTORS FROM CSS_CATEGORY              *         
      *---------------------------------------------------------------*         
      *                                                                         
           EXEC SQL                                                     
                DECLARE COLL-USERS  CURSOR FOR                          
                   SELECT DISTINCT(F5.USER_ID),                         
                          PF.COMPANY_NO                                 
                     FROM CSS_CATEGORY F5 WITH(READUNCOMMITTED),                
                          CSS_USER_PROFILE PF WITH(READUNCOMMITTED)             
                    WHERE F5.CATEGORY_ID IN (261,262)                   
                      AND F5.USER_ID   = PF.USER_ID                     
                      AND PF.RESP_AREA_ID NOT IN ('571','999','437'     
                    ,'293','331','003','P43','337','466','G46','G49')   
                   ORDER BY PF.COMPANY_NO, F5.USER_ID                   
                     FOR READ ONLY                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE COLL-USERS  CURSOR FOR                                  
MFA-TR*            SELECT DISTINCT(F5.USER_ID),                                 
MFA-TR*                   PF.COMPANY_NO                                         
MFA-TR*              FROM CSS_CATEGORY F5,                                      
MFA-TR*                   CSS_USER_PROFILE PF                                   
MFA-TR*             WHERE F5.CATEGORY_ID IN (261,262)                           
MFA-TR*               AND F5.USER_ID   = PF.USER_ID                             
MFA-TR*               AND PF.RESP_AREA_ID NOT IN ('571','999','437'             
MFA-TR*             ,'293','331','003','P43','337','466','G46','G49')           
MFA-TR*            ORDER BY PF.COMPANY_NO, F5.USER_ID                           
MFA-TR*              FOR FETCH ONLY WITH UR                                     
MFA-TR*          QUERYNO 7150                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
      *---------------------------------------------------------------*         
      * CURSOR FOR FETCHING COLLECTORS ACTIVITY TIME FROM             *         
      * CSS_ACTIVITY TABLE                                            *         
      *---------------------------------------------------------------*         
      *                                                                         
           EXEC SQL                                                     
                DECLARE COLL-TIME   CURSOR FOR                          
                   SELECT REPLACE(CONVERT(CHAR(8), YO.ACTIVITY_TIME
           , 108), ':', '.') ACTIVITY_TIME,                             
                          YO.ACTIVITY_ACTION_CD                         
                     FROM CSS_COLL_ACTIVITY YO WITH(READUNCOMMITTED)            
                    WHERE YO.USER_ID     = :YO-USER-ID                  
                      AND YO.ACTIVITY_DT = IIF(TRY_CONVERT(DATE, 
                                                        :WS-REPORT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-REPORT-DATE
              ) <> 0) OR (LEN(:WS-REPORT-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-REPORT-DATE
              ), CONVERT(DATE, :WS-REPORT-DATE) )              
                   ORDER BY ACTIVITY_TIME DESC                       
                     FOR READ ONLY                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE COLL-TIME   CURSOR FOR                                  
MFA-TR*            SELECT YO.ACTIVITY_TIME,                                     
MFA-TR*                   YO.ACTIVITY_ACTION_CD                                 
MFA-TR*              FROM CSS_COLL_ACTIVITY YO                                  
MFA-TR*             WHERE YO.USER_ID     = :YO-USER-ID                          
MFA-TR*               AND YO.ACTIVITY_DT = :WS-REPORT-DATE                      
MFA-TR*            ORDER BY YO.ACTIVITY_TIME DESC                               
MFA-TR*              FOR FETCH ONLY WITH UR                                     
MFA-TR*          QUERYNO 7160                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                              PIC X(40) VALUE          
             'WORKING STORAGE FOR PCSCB754 ENDS HERE  '.                
      ************************************************************              
       PROCEDURE DIVISION.                                              
      ************************************************************              
      ************************************************************              
       0000-MAINLINE.                                                   
      *                                                                         
           MOVE '0000' TO  WS-ACTIVE-PARAGRAPH.                         
      *                                                                         
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT.                                           
      *                                                                         
           PERFORM 7150-OPEN-COLLUSERS-CURSOR                           
              THRU 7150-EXIT.                                           
      *                                                                         
           PERFORM 1000-MAIN-PROCESS-PARA                               
              THRU 1000-EXIT UNTIL END-OF-USERS.                        
      *                                                                         
           PERFORM 7350-CLOSE-COLLUSERS-CURSOR                          
              THRU 7350-EXIT.                                           
      *                                                                         
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT.                                           
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***********************************************************               
      **                                                       **               
      **    0100-INITIALIZATION.                               **               
      **        INITIALIZATION ROUTINE                         **               
      **                                                       **               
      ***********************************************************               
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE '0100'                     TO   WS-ACTIVE-PARAGRAPH.    
      *                                                                         
      * GET CURRENT DATABASE                                                    
           MOVE '01'                     TO C8-COMPANY-NO.              
           MOVE 'DATABASE'               TO C8-DELINQ-CD.               
           PERFORM 7500-GET-DATABASE     THRU 7500-EXIT.                
           MOVE C8-DELINQ-VALUE          TO WS-DATABASE.                
      *                                                                         
           ACCEPT WS-CURRENT-DATE          FROM DATE.                   
           ACCEPT WS-CURRENT-TIME          FROM TIME.                   
      *                                                                         
      * SET UP DATE                                                             
           PERFORM 6251-GET-FJC01-DATE     THRU 6251-EXIT.              
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  '              TO WS-PGRMNAME               
              MOVE SPACES                  TO WS-INPUT-AREA             
              MOVE SPACES                  TO WS-INPUT-DATA-BREAKDOWN   
              PERFORM 6251-GET-FJC01-DATE  THRU 6251-EXIT               
              MOVE WS-PGRNAME              TO WS-PGRMNAME               
           END-IF                                                       
      *                                                                         
           PERFORM 7000-GET-CURRENT-DATE THRU 7000-EXIT.                
      *                                                                 03069001
           MOVE LOW-VALUES    TO E-FRP754-BEGIN-REC.                    
           MOVE WS-INPUT-DATE TO E-FRP754-CREATE-DATE-BREC.             
      *                                                                         
           SET FIRST-TIME2 TO TRUE.                                     
           INITIALIZE                  WS-PTP-AMT-TOTAL                 
                                       WS-TOTAL-ARREARS                 
                                       WS-PTP-COUNT                     
                                       WS-ACCTS-WRKD-COUNT              
                                       WS-AMT-COLLECTED                 
                                       WS-NO-COMP-RECORDS               
                                       WS-DAILY-PROM-KEPT               
                                       WS-DAILY-PROM-BRKN               
                                       WS-NO-TOT-RECORDS                
                                       DCLCSS-RPT-PCSCA754.             
      *                                                                         
           PERFORM 0110-CHECK-USE-DATE THRU 0110-EXIT                   
      *                                                                         
           DISPLAY 'REPORT DATE :' WS-REPORT-DATE.                      
      *                                                                         
           MOVE WS-REPORT-DATE           TO WS-MONTH-BEG-DATE           
                                            E-FRP754-CREATE-DATE-BREC.  
                                                                        
           PERFORM 7985-DELETE-RPT754 THRU 7985-EXIT.                   
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      **      0110-CHECK-USE-DATE                                **             
      **           DETERMINE WHICH DATE TO USE FOR REPORT RUN DATE*             
      *************************************************************             
      *                                                                         
       0110-CHECK-USE-DATE.                                             
      *                                                                         
           MOVE '0110' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           IF WS-CURRENT-TIME > 13000000 AND                            
              WS-CURRENT-TIME < 24000000                                
              MOVE 0                         TO WS-ADJ-DAY              
              PERFORM 0120-CHK-FOR-BUSDAY    THRU 0120-EXIT             
              EVALUATE SQLCODE                                          
                 WHEN SUCCESSFUL-CALL                                   
                    SET BUSDAY-TODAY         TO TRUE                    
                 WHEN NOT-FOUND                                         
                    SET NOT-BUSDAY-TODAY     TO TRUE                    
                 WHEN OTHER                                             
                    DISPLAY 'WORK-DATE ERROR'                           
                    MOVE WS-MONTH-BEG-DATE   TO WS-WORK-DATE            
              END-EVALUATE                                              
              IF BUSDAY-TODAY                                           
                 MOVE WS-INPUT-DATE   TO WS-REPORT-DATE                 
              ELSE                                                      
                 MOVE WS-CURRENT-DAY  TO WS-REPORT-DATE                 
              END-IF                                                    
           ELSE                                                         
              MOVE 1                         TO WS-ADJ-DAY              
              PERFORM 0120-CHK-FOR-BUSDAY    THRU 0120-EXIT             
              EVALUATE SQLCODE                                          
                 WHEN SUCCESSFUL-CALL                                   
                    SET BUSDAY-YEST          TO TRUE                    
                 WHEN NOT-FOUND                                         
                    SET NOT-BUSDAY-YEST      TO TRUE                    
                 WHEN OTHER                                             
                    DISPLAY 'WORK-DATE ERROR'                           
                    MOVE WS-MONTH-BEG-DATE   TO WS-WORK-DATE            
              END-EVALUATE                                              
              IF BUSDAY-YEST                                            
                 MOVE WS-INPUT-DATE   TO WS-REPORT-DATE                 
              ELSE                                                      
                 PERFORM 0130-GET-YESTERDAY     THRU 0130-EXIT          
                 MOVE WS-YESTERDAY            TO WS-REPORT-DATE         
              END-IF                                                    
           END-IF.                                                      
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      **      0120-CHK-FOR-BUSDAY                                **             
      **           CHECK IF THE DAY IS A BUSINESS DAY            **             
      *************************************************************             
      *                                                                         
       0120-CHK-FOR-BUSDAY.                                             
      *                                                                         
           MOVE '0120' TO WS-ACTIVE-PARAGRAPH.                          
           EXEC SQL                                                     
              SELECT DATEADD( DAY, -:WS-ADJ-DAY, IIF(TRY_CONVERT(DATE, 
                                                        :WS-CURRENT-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DAY
              ) <> 0) OR (LEN(:WS-CURRENT-DAY) <> 10), CIS.CHAR2DATE(
                                                        :WS-CURRENT-DAY
              ), CONVERT(DATE, :WS-CURRENT-DAY) ) )           
                INTO :WS-TEST-DATE                                      
                FROM CSS_MODEL_SQL WITH(READUNCOMMITTED)                        
                WHERE CIS.DAYS(DATEADD( DAY, -:WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DAY
              ) <> 0) OR (LEN(:WS-CURRENT-DAY) <> 10), CIS.CHAR2DATE(
                                                        :WS-CURRENT-DAY
              ), CONVERT(DATE, :WS-CURRENT-DAY) ) )) -                
                        (CIS.DAYS(DATEADD( DAY, -:WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DAY
              ) <> 0) OR (LEN(:WS-CURRENT-DAY) <> 10), CIS.CHAR2DATE(
                                                        :WS-CURRENT-DAY
              ), CONVERT(DATE, :WS-CURRENT-DAY) )
               )) / 7 * 7) BETWEEN 1 AND 5 
                  AND NOT EXISTS                                        
                       (SELECT HOLIDAY_DT                               
                          FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                
                          WHERE COMPANY_NO IN('01','26')                
                            AND HOLIDAY_DT =                            
                                DATEADD( DAY, -:WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DAY
              ) <> 0) OR (LEN(:WS-CURRENT-DAY) <> 10), CIS.CHAR2DATE(
                                                        :WS-CURRENT-DAY
              ), CONVERT(DATE, :WS-CURRENT-DAY) ) ))                
                                                                 
                                                            
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE(:WS-CURRENT-DAY) - :WS-ADJ-DAY DAYS                   
MFA-TR*         INTO :WS-TEST-DATE                                              
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*         WHERE DAYS(DATE(:WS-CURRENT-DAY)                                
MFA-TR*                            - :WS-ADJ-DAY DAYS) -                        
MFA-TR*                 (INTEGER(DAYS(DATE(:WS-CURRENT-DAY)                     
MFA-TR*                   - :WS-ADJ-DAY DAYS) / 7) * 7) BETWEEN 1 AND 5         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*                (SELECT HOLIDAY_DT                                       
MFA-TR*                   FROM CSS_HOLIDAY                                      
MFA-TR*                   WHERE COMPANY_NO IN('01','26')                        
MFA-TR*                     AND HOLIDAY_DT =                                    
MFA-TR*                         DATE(:WS-CURRENT-DAY) -                         
MFA-TR*                                :WS-ADJ-DAY DAYS)                        
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 0120                                                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                         
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      **      0130-GET-YESTERDAY                                 **             
      **           GET YESTERDAY'S DATE                          **             
      *************************************************************             
      *                                                                         
       0130-GET-YESTERDAY.                                              
      *                                                                         
           MOVE '0130' TO WS-ACTIVE-PARAGRAPH.                          
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DAY
              ) <> 0) OR (LEN(:WS-CURRENT-DAY) <> 10), CIS.CHAR2DATE(
                                                        :WS-CURRENT-DAY
              ), CONVERT(DATE, :WS-CURRENT-DAY) ) )
            INTO
              :WS-YESTERDAY         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-YESTERDAY = DATE(:WS-CURRENT-DAY) - 1 DAY                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
                   MOVE 'ERROR IN SETTING DATE '                        
                                         TO WS-ERR-MSG                  
                   MOVE SQLCODE          TO WS-DISP-RC                  
                   PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT            
           END-IF.                                                      
      *                                                                         
       0130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      **                                                         **             
      ** 1000-MAIN-PROCESS-PARA                                  **             
      ** MAIN PROCESS - RETRIEVES ALL COLLECTORS IN THE SYSTEM   **             
      **                                                         **             
      *************************************************************             
      *                                                                         
       1000-MAIN-PROCESS-PARA.                                          
      *                                                                         
           MOVE '1000' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           PERFORM 7250-FETCH-COLLUSERS-CURSOR                          
              THRU 7250-EXIT                                            
      *                                                                         
           IF MORE-USERS                                                
              MOVE F5-USER-ID        TO YO-USER-ID                      
                                        WS-COLL-AGENT-ID                
                                        WS-USER-ID-TEXT                 
              PERFORM 7980-GET-LAST-ACTIVITY THRU 7980-EXIT             
              IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                 IF  YO-ACTIVITY-ACTION-CD = 'LO'                       
                     CONTINUE                                           
                 ELSE                                                   
                     MOVE 'CQ-LOGOFF-TIME'       TO C8-DELINQ-CD        
                     PERFORM 7900-GET-HOURS-WRKD THRU 7900-EXIT         
                     MOVE C8-DELINQ-VALUE        TO WS-LOGOFF-HRS       
                     MOVE WS-LOGOFF-HRS          TO WS-HRS              
                     MOVE WS-LOGOFF-TIME         TO YO-ACTIVITY-TIME    
                     MOVE F5-USER-ID             TO YO-USER-ID          
                     MOVE 'LO'                   TO                     
                                                 YO-ACTIVITY-ACTION-CD  
                     MOVE WS-REPORT-DATE         TO YO-ACTIVITY-DT      
                     MOVE YO-COMPANY-NO          TO YO-COMPANY-NO       
                     MOVE 'SYSTEM'               TO                     
                                                 YO-LAST-UPDATE-USERID  
                     PERFORM 7010-GET-CURRENT-TIMESTAMP THRU 7010-EXIT  
                     MOVE WS-CURRENT-TIMESTAMP   TO YO-LAST-UPDATE-TS   
                     PERFORM 7990-INSERT-COLL-ACT THRU 7990-EXIT        
                 END-IF                                                 
                 SET  MORE-ACTIVITY TO TRUE                             
                 MOVE ZEROS  TO WS-DURATION-TIME                        
                                WS-HOURS                                
                                WS-MINS                                 
                                WS-SECS                                 
                                WS-SECS-TO-HRS                          
                                WS-MINS-TO-HRS                          
                                WS-TOTAL-HRS                            
                 PERFORM 7160-OPEN-COLLTIME-CURSOR                      
                                  THRU 7160-EXIT                        
      *                                                                         
                 PERFORM 7260-FETCH-COLLTIME-CURSOR                     
                                  THRU 7260-EXIT                        
                                UNTIL END-ACTIVITY                      
      *                                                                         
                 COMPUTE WS-MINS-TO-HRS ROUNDED =  (WS-MINS / 60)       
                 COMPUTE WS-SECS-TO-HRS ROUNDED =  (WS-SECS / 3600)     
                 COMPUTE WS-TOTAL-HRS = WS-HOURS + WS-MINS-TO-HRS       
                                                 + WS-SECS-TO-HRS       
      *                                                                         
                 PERFORM 7360-CLOSE-COLLTIME-CURSOR                     
                                          THRU 7360-EXIT                
               MOVE WS-TOTAL-HRS        TO E-FRP754-HOURS-ON-SYSTEM     
              ELSE                                                      
                MOVE ZEROS                    TO                        
                                             E-FRP754-HOURS-ON-SYSTEM   
                                             WS-TOTAL-HRS               
           END-IF                                                       
      *                                                                         
             SET MORE-ROWS           TO TRUE                            
             SET FIRST-TIME          TO TRUE                            
             SET NO-RECORD-FOUND     TO TRUE                            
      *                                                                         
              PERFORM 1050-MAIN-PROCESS-PARA                            
                   THRU 1050-EXIT                                       
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04700000
      *************************************************************             
      **                                                         **             
      **      1050-MAIN-PROCESS-PARA                            **              
      **           MAIN PROCESS                                  **             
      **                                                         **             
      *************************************************************             
      *                                                                         
       1050-MAIN-PROCESS-PARA.                                          
      *                                                                         
           MOVE '1050' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           PERFORM 7100-OPEN-COLLDET-CURSOR                             
              THRU 7100-EXIT.                                           
      *                                                                         
           PERFORM 7200-FETCH-COLLDET-CURSOR                            
              THRU 7200-EXIT                                            
              UNTIL END-OF-ROWS                                         
      *                                                                         
           PERFORM 7300-CLOSE-COLLDET-CURSOR                            
              THRU 7300-EXIT.                                           
      *                                                                         
       1050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **     2100-PROCESS-DETAILS-PARA                             **           
      **          FECTHES THE TRAN DATA FROM  CSS_CSH_DRWR_JRNL    **           
      **          TABLE.                                           **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       2100-PROCESS-DETAILS-PARA.                                       
      *                                                                         
           MOVE '2100'                          TO WS-ACTIVE-PARAGRAPH. 
      *                                                                         
           IF LH-COLL-AGENT-ID = WS-USER-ID AND                         
              LH-ACCOUNT-NO    = WS-PREV-ACCT-NO                        
               CONTINUE                                                 
           ELSE                                                         
               PERFORM 2150-POPULATE-DETAIL      THRU 2150-EXIT         
               PERFORM 7995-INSERT-RPT754 THRU 7995-EXIT                
               ADD 1 TO WS-NO-COMP-RECORDS                              
               MOVE LH-COLL-AGENT-ID-TEXT        TO WS-USER-ID-TEXT     
               MOVE LH-COLL-AGENT-ID-LEN         TO WS-USER-ID-LEN      
               PERFORM 2160-INITIALIZE-COUNTS    THRU 2160-EXIT         
           END-IF.                                                      
           PERFORM 2105-ACCM-SAME-USERID        THRU 2105-EXIT.         
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **     2105-ACCM-SAME-USERID                                 **           
      **          ACCUMULATE THE TOTALS FOR THE SAME USERID        **           
      ***************************************************************           
      *                                                                         
       2105-ACCM-SAME-USERID.                                           
      *                                                                         
           MOVE '2105'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           ADD +1                           TO WS-ACCTS-WRKD-COUNT      
           IF LH-COLL-RESULT-CD = ('PP' OR 'PM' OR 'PW' OR 'SP')        
              AND LH-PTP-STATUS-CD = ('A' OR 'P' OR 'K')                
              ADD +1                            TO WS-PTP-COUNT         
              COMPUTE WS-PTP-AMT-TOTAL = WS-PTP-AMT-TOTAL     +         
                                                 LH-PTP-AMT             
           END-IF                                                       
           IF LH-COLL-RESULT-CD = 'PK'                                  
              ADD +1                            TO WS-PK-COUNT          
              COMPUTE WS-DAILY-PROM-KEPT = WS-DAILY-PROM-KEPT +         
                                                 LH-PTP-AMT             
           END-IF                                                       
           IF LH-COLL-RESULT-CD = 'PB'                                  
              ADD +1                            TO WS-PB-COUNT          
              COMPUTE WS-DAILY-PROM-BRKN = WS-DAILY-PROM-BRKN +         
                                                 LH-PTP-AMT             
           END-IF                                                       
           PERFORM 2110-GET-TOTAL-ARREARS.                              
      *                                                                         
       2105-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **     2110-GET-TOTAL-ARREARS.                               **           
      **          GET THE TOTAL ARREARS ON AN ACCOUNT FOR WHICH    **           
      **          PTP WAS ACTIONED BY THE COLLECTOR                **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       2110-GET-TOTAL-ARREARS.                                          
      *                                                                         
           MOVE '2110'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE LH-ACCOUNT-NO                 TO HC-ACCOUNT-NO          
           PERFORM 7400-GET-TOTAL-ARREARS     THRU 7400-EXIT            
           COMPUTE WS-TOTAL-ARREARS = WS-TOTAL-ARREARS +                
                                              HC-TOTAL-ARREARS.         
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **     2150-POPULATE-DETAIL**                                             
      **          POPULATE THE DETAIL ROW WITH THE TOTALS FOR THAT **           
      **          COLL_AGENT_ID                                    **           
      ***************************************************************           
      *                                                                         
       2150-POPULATE-DETAIL.                                            
      *                                                                         
           MOVE '2150'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE '   ' TO LR-REG-GROUP-CD.                               
                                                                        
           IF PF-COMPANY-NO NOT = WS-PREV-COMP-NO                       
              IF FIRST-TIME2                                            
                 SET NOT-FIRST-TIME2 TO TRUE                            
                 MOVE PF-COMPANY-NO TO WS-PREV-COMP-NO                  
              ELSE                                                      
                 MOVE HIGH-VALUES TO E-FRP754-CO-KEY-EREC               
                 MOVE WS-PREV-COMP-NO TO E-FRP754-CO-NO-KEY-EREC        
                 MOVE WS-NO-COMP-RECORDS TO                             
                                           E-FRP754-RECORD-COUNT-EREC   
                 ADD WS-NO-COMP-RECORDS TO WS-NO-TOT-RECORDS            
                 MOVE ZEROES TO WS-NO-COMP-RECORDS                      
                 MOVE PF-COMPANY-NO TO WS-PREV-COMP-NO                  
             END-IF                                                     
           END-IF.                                                      
                                                                        
           IF RECORD-FOUND                                              
              IF SEB-DATABASE                                           
                 PERFORM 7640-GET-REG-PROFILE-INFO THRU 7640-EXIT       
                 MOVE LR-REG-GROUP-CD     TO E-FRP754-REG-GROUP-CD      
                 MOVE '01'                TO E-FRP754-COMPANY-NO        
              ELSE                                                      
                 MOVE WS-DISP-OFFICE      TO E-FRP754-REG-GROUP-CD      
                 MOVE PF-COMPANY-NO       TO E-FRP754-COMPANY-NO        
              END-IF                                                    
      *                                                                         
           ELSE                                                         
              IF CSR-DATABASE                                           
                 MOVE '01'                TO E-FRP754-COMPANY-NO        
                 EVALUATE PF-COMPANY-NO                                 
                 WHEN '01'                                              
                    MOVE '001'            TO E-FRP754-REG-GROUP-CD      
                 WHEN '26'                                              
                    MOVE '026'            TO E-FRP754-REG-GROUP-CD      
                 END-EVALUATE                                           
              ELSE                                                      
                 MOVE '01'                TO E-FRP754-COMPANY-NO        
                 MOVE LR-REG-GROUP-CD     TO E-FRP754-REG-GROUP-CD      
              END-IF                                                    
           END-IF                                                       
      *                                                                         
           MOVE WS-TOTAL-HRS           TO E-FRP754-HOURS-ON-SYSTEM.     
           IF RECORD-FOUND                                              
             MOVE WS-DET-DATE            TO E-FRP754-DATE               
           ELSE                                                         
             MOVE WS-REPORT-DATE       TO E-FRP754-DATE                 
           END-IF                                                       
           MOVE WS-USER-ID-TEXT        TO E-FRP754-COLLECTOR-ID.        
           MOVE WS-USER-ID-TEXT        TO PF-USER-ID                    
           PERFORM 7960-GET-RESP-AREA  THRU 7960-EXIT                   
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE PF-LAST-NAME       TO WS-LAST                       
               MOVE PF-FIRST-NAME      TO WS-FIRST                      
               MOVE WS-NAME            TO E-FRP754-COLLECTOR-NAME       
               MOVE PF-RESP-AREA-ID    TO E-FRP754-RESP-AREA-ID         
                                          C1-RESP-AREA-ID               
               MOVE PF-COMPANY-NO      TO C1-COMPANY-NO                 
               PERFORM 7970-GET-RESP-AREA-DESC THRU 7970-EXIT           
               IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
                   MOVE C1-RESP-AREA-DESC  TO E-FRP754-RESP-AREA-DESC   
               ELSE                                                     
                   MOVE '(NOT DEFINED IN CIS)'                          
                                           TO E-FRP754-RESP-AREA-DESC   
               END-IF                                                   
           ELSE                                                         
               MOVE SPACES             TO E-FRP754-RESP-AREA-ID         
               MOVE '(NOT DEFINED IN CIS)'                              
                                       TO E-FRP754-RESP-AREA-DESC       
           END-IF                                                       
           MOVE WS-ACCTS-WRKD-COUNT    TO E-FRP754-ACCOUNTS-WORKED.     
           MOVE WS-TOTAL-ARREARS       TO E-FRP754-ARREAR-ACTIONED.     
           MOVE WS-PTP-COUNT           TO E-FRP754-NO-OF-PTPS.          
           MOVE WS-PTP-AMT-TOTAL       TO E-FRP754-PTP-AMOUNT-TOTAL.    
           MOVE WS-PK-COUNT            TO E-FRP754-NO-KEPT.             
           MOVE WS-PB-COUNT            TO E-FRP754-NO-BROKEN.           
           COMPUTE WS-AMT-COLLECTED = WS-DAILY-PROM-KEPT +              
                                          WS-DAILY-PROM-BRKN.           
           MOVE WS-DAILY-PROM-BRKN     TO E-FRP754-AMT-BRKN.            
           MOVE WS-DAILY-PROM-KEPT     TO E-FRP754-AMT-KEPT.            
           MOVE WS-AMT-COLLECTED       TO E-FRP754-AMT-COLLECTED.       
           IF CSR-DATABASE                                              
               MOVE 'CSR' TO E-FRP754-DATABASE                          
           ELSE                                                         
               MOVE 'SEB' TO E-FRP754-DATABASE                          
           END-IF.                                                      
           MOVE HC-CALL-QUEUE-ID       TO E-FRP754-CALL-QUEUE-ID.       
           MOVE SPACES                 TO HC-CALL-QUEUE-ID.             
           MOVE AT-CODE-ACCT-STAT      TO E-FRP754-CODE-ACCT-STAT.      
                                                                        
       2150-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ***************************************************************           
      **     2160-INITIALIZE-COUNTS                                **           
      **          INITIALIZE THE INDIVIDUAL COUNTS WHEN THE AGENT  **           
      **          ID CHANGES                                       **           
      ***************************************************************           
      *                                                                         
       2160-INITIALIZE-COUNTS.                                          
      *                                                                         
           MOVE '2160'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           IF RECORD-FOUND                                              
              MOVE LH-ACCOUNT-NO          TO WS-PREV-ACCT-NO            
           END-IF                                                       
           INITIALIZE                     WS-ACCTS-WRKD-COUNT           
                                          WS-PTP-AMT-TOTAL              
                                          WS-DAILY-PROM-KEPT            
                                          WS-DAILY-PROM-BRKN            
                                          WS-TOTAL-ARREARS              
                                          WS-PTP-COUNT                  
                                          WS-AMT-COLLECTED              
                                          WS-PK-COUNT                   
                                          WS-PB-COUNT.                  
       2160-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ***************************************************************           
      **    7000-GET-CURRENT-DATE                                  **           
      **         GET THE CURRENT DATE                              **           
      ***************************************************************           
      *                                                                         
       7000-GET-CURRENT-DATE.                                           
      *                                                                         
           MOVE '7000'  TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DAY                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DAY = CURRENT DATE                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
                   MOVE 'ERROR IN SETTING DATE '                        
                                         TO WS-ERR-MSG                  
                   MOVE SQLCODE          TO WS-DISP-RC                  
                   PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT            
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **    7010-GET-CURRENT-TIMESTAMP                             **           
      **         GET THE CURRENT TIME STAMP                        **           
      ***************************************************************           
      *                                                                         
       7010-GET-CURRENT-TIMESTAMP.                                      
      *                                                                         
           MOVE '7010'  TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                         
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
                   MOVE 'ERROR IN SETTING TIMESTAMP '                   
                                         TO WS-ERR-MSG                  
                   MOVE SQLCODE          TO WS-DISP-RC                  
                   PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT            
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **    7100-OPEN-COLLDET-CURSOR                               **           
      **         OPENS THE CURSOR TO FETCH ROWS                    **           
      **          FROM CSS_COLL_HIST_DET                           **           
      **                                                           **           
      ***************************************************************           
                                                                        
       7100-OPEN-COLLDET-CURSOR.                                        
      *                                                                         
           MOVE '7100'  TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                         
           EXEC SQL                                                     
                OPEN COLLECT-DET                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE 'OPEN COLLECT-DET  ERROR'                            
                                           TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      ** 7150-OPEN-COLLUSERS-CURSOR                                **           
      ** OPENS THE CURSOR TO FETCH ROWS FROM CSS_CATEGORY          **           
      **                                                           **           
      ***************************************************************           
                                                                        
       7150-OPEN-COLLUSERS-CURSOR.                                      
      *                                                                         
           MOVE '7150'  TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                         
           EXEC SQL                                                     
                OPEN COLL-USERS                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE 'OPEN COLL-USERS  ERROR'                             
                                           TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      ** 7160-OPEN-COLLTIME-CURSOR                                 **           
      ** OPENS THE CURSOR TO FETCH ROWS FROM CSS_ACTIVITY          **           
      **                                                           **           
      ***************************************************************           
                                                                        
       7160-OPEN-COLLTIME-CURSOR.                                       
      *                                                                         
           MOVE '7160'  TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                         
           EXEC SQL                                                     
                OPEN COLL-TIME                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE 'OPEN COLL-TIME   ERROR'                             
                                           TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **    7200-FETCH-COLLDET-CURSOR                              **           
      **         FETCH ROWS FROM CSS_COLL_HIST_DET TABLE TO CREATE **           
      **         A REPORT OF COLLECTOR STATS                       **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       7200-FETCH-COLLDET-CURSOR.                                       
      *                                                                         
           MOVE '7200'  TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                         
           EXEC SQL                                                     
                FETCH COLLECT-DET INTO                                  
                  :LH-ACCOUNT-NO,                                       
                  :LH-PTP-AMT,                                          
                  :LH-COLL-RESULT-CD,                                   
                  :LH-COLL-AGENT-ID,                                    
                  :WS-DET-DATE,                                         
                  :AT-COMPANY-NO,                                       
                  :AT-LOCAL-OFFICE,                                     
                  :AT-CODE-ACCT-STAT,                                   
                  :LH-PTP-STATUS-CD                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                     
           MOVE '001' TO WS-DISP-OFFICE.                                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               SET RECORD-FOUND              TO TRUE                    
               IF AT-LOCAL-OFFICE < 200                                 
                  MOVE '001' TO WS-DISP-OFFICE                          
               ELSE                                                     
                  MOVE '026' TO WS-DISP-OFFICE                          
               END-IF                                                   
               IF FIRST-TIME                                            
                   SET NOT-FIRST-TIME TO TRUE                           
                   MOVE LH-ACCOUNT-NO         TO WS-PREV-ACCT-NO        
                   MOVE LH-COLL-AGENT-ID-TEXT TO WS-USER-ID-TEXT        
                   MOVE LH-COLL-AGENT-ID-LEN  TO WS-USER-ID-LEN         
               END-IF                                                   
               PERFORM 2100-PROCESS-DETAILS-PARA THRU 2100-EXIT         
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                       PERFORM 2150-POPULATE-DETAIL      THRU 2150-EXIT 
                       PERFORM 7995-INSERT-RPT754 THRU 7995-EXIT        
                       ADD 1 TO WS-NO-COMP-RECORDS                      
                       PERFORM 2160-INITIALIZE-COUNTS    THRU 2160-EXIT 
                   SET END-OF-ROWS TO TRUE                              
               ELSE                                                     
                   MOVE 'ERROR IN FETCHING COLLECT-DET  CURSOR'         
                                         TO WS-ERR-MSG                  
                   MOVE SQLCODE          TO WS-DISP-RC                  
                   PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT            
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **    7250-FETCH-COLLUSERS-CURSOR                            **           
      **    FETCH ROWS FROM CSS_CATEGORY TABLE                     **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       7250-FETCH-COLLUSERS-CURSOR.                                     
      *                                                                         
           MOVE '7250'  TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                         
           EXEC SQL                                                     
                FETCH COLL-USERS INTO                                   
                  :F5-USER-ID                                           
                 ,:PF-COMPANY-NO                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   SET END-OF-USERS TO TRUE                             
               ELSE                                                     
                   MOVE 'ERROR IN FETCHING COLL-USERS   CURSOR'         
                                         TO WS-ERR-MSG                  
                   MOVE SQLCODE          TO WS-DISP-RC                  
                   PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT            
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **    7260-FETCH-COLLTIME-CURSOR                             **           
      **    FETCH ROWS FROM CSS_ACTIVITY TABLE                     **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       7260-FETCH-COLLTIME-CURSOR.                                      
      *                                                                         
           MOVE '7260'  TO WS-ACTIVE-PARAGRAPH.                         
           MOVE SPACES  TO WS-LOG-OFF-TIME                              
                           WS-LOG-IN-TIME.                              
      *                                                                         
           EXEC SQL                                                     
                FETCH COLL-TIME  INTO                                   
                  :YO-ACTIVITY-TIME,                                    
                  :YO-ACTIVITY-ACTION-CD                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF YO-ACTIVITY-ACTION-CD = 'LO'                           
                 MOVE YO-ACTIVITY-TIME TO WS-LOG-OFF-TIME               
              ELSE                                                      
                 MOVE 'ERROR IN ORDER - EXPECTING LO ROW'               
                                         TO WS-ERR-MSG                  
                 MOVE SQLCODE          TO WS-DISP-RC                    
                 PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT              
              END-IF                                                    
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   SET END-ACTIVITY TO TRUE                             
                   GO TO 7260-EXIT                                      
               ELSE                                                     
                   MOVE 'ERROR IN FETCHING COLL-TIME(LO)CURSOR'         
                                         TO WS-ERR-MSG                  
                   MOVE SQLCODE          TO WS-DISP-RC                  
                   PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT            
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
                FETCH COLL-TIME  INTO                                   
                  :YO-ACTIVITY-TIME,                                    
                  :YO-ACTIVITY-ACTION-CD                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF YO-ACTIVITY-ACTION-CD = 'LI'                           
                 MOVE YO-ACTIVITY-TIME TO WS-LOG-IN-TIME                
              ELSE                                                      
                 MOVE 'ERROR IN ORDER - EXPECTING LI ROW'               
                                         TO WS-ERR-MSG                  
                 MOVE SQLCODE          TO WS-DISP-RC                    
                 PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT              
              END-IF                                                    
           ELSE                                                         
              MOVE 'ERROR IN FETCHING COLL-TIME(LI)CURSOR'              
                                        TO WS-ERR-MSG                   
              MOVE SQLCODE          TO WS-DISP-RC                       
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
            EXEC SQL                                                    
               SELECT
              CIS.DIFFTIME( CIS.CHAR2TIME(:WS-LOG-OFF-TIME), 
           CIS.CHAR2TIME(:WS-LOG-IN-TIME) )
            INTO
              :WS-DURATION-TIME     
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SET :WS-DURATION-TIME = TIME(:WS-LOG-OFF-TIME) -                 
MFA-TR*                                       TIME(:WS-LOG-IN-TIME)             
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-DURATION-TIME     TO WS-DURATION-NUM              
              ADD WS-DURATION-NUM-HH    TO WS-HOURS                     
              ADD  WS-DURATION-NUM-MM   TO WS-MINS                      
              ADD  WS-DURATION-NUM-SS   TO WS-SECS                      
           ELSE                                                         
              MOVE 'ERROR IN CALCULATING TIME DIFFERENCE'               
                                        TO WS-ERR-MSG                   
              MOVE SQLCODE          TO WS-DISP-RC                       
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **    7300-CLOSE-COLLDET-CURSOR                              **           
      **         CLOSES CURSOR ON CSS_COLL_HIST_DET TABLE          **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       7300-CLOSE-COLLDET-CURSOR.                                       
      *                                                                         
           MOVE '7300'  TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                         
           EXEC SQL                                                     
                CLOSE COLLECT-DET                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE 'CLOSE COLLECT-DET  CURSOR ERROR'                    
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **    7350-CLOSE-COLLUSERS-CURSOR                            **           
      **    CLOSES CURSOR ON CSS_CATEGORY TABLE                    **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       7350-CLOSE-COLLUSERS-CURSOR.                                     
      *                                                                         
           MOVE '7350'  TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                         
           EXEC SQL                                                     
                CLOSE COLL-USERS                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE 'CLOSE COLL-USERS   CURSOR ERROR'                    
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **    7360-CLOSE-COLLTIME-CURSOR                             **           
      **    CLOSES CURSOR ON CSS_ACTIVITY TABLE                    **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       7360-CLOSE-COLLTIME-CURSOR.                                      
      *                                                                         
           MOVE '7360'  TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                         
           EXEC SQL                                                     
                CLOSE COLL-TIME                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE 'CLOSE COLL-TIME CURSOR ERROR'                       
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7400-GET-TOTAL-ARREARS                                   **          
      **      READS THE COLLECT HIST TABLE TO GET THE TOTAL ARREARS **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7400-GET-TOTAL-ARREARS.                                          
      *                                                                         
           MOVE '7400' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
               DECLARE ARREARS CURSOR FOR                               
             SELECT LH.RECORD_CREATION_DT,                              
                    HC.CALL_QUEUE_ID,                                   
                    HC.TOTAL_ARREARS                                    
               FROM CSS_COLL_HIST_DET LH WITH(READUNCOMMITTED),                 
                    CSS_COLLECT_HIST HC WITH(READUNCOMMITTED)                   
              WHERE HC.ACCOUNT_NO = :HC-ACCOUNT-NO                      
                AND HC.ACCOUNT_NO = LH.ACCOUNT_NO                       
                AND HC.COLL_HIST_SEQ_TS = LH.COLL_HIST_SEQ_TS           
                AND LH.COLL_AGENT_ID = LH.LAST_UPDATE_USERID            
                AND LH.RECORD_CREATION_DT BETWEEN IIF(TRY_CONVERT(DATE, 
                                                     :WS-MONTH-BEG-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-MONTH-BEG-DATE
              ) <> 0) OR (LEN(:WS-MONTH-BEG-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-MONTH-BEG-DATE
              ), CONVERT(DATE, :WS-MONTH-BEG-DATE) )    
                AND IIF(TRY_CONVERT(DATE, :WS-REPORT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-REPORT-DATE
              ) <> 0) OR (LEN(:WS-REPORT-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-REPORT-DATE
              ), CONVERT(DATE, :WS-REPORT-DATE) )                              
              ORDER BY LH.RECORD_CREATION_DT DESC                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ARREARS CURSOR FOR                                       
MFA-TR*      SELECT LH.RECORD_CREATION_DT,                                      
MFA-TR*             HC.CALL_QUEUE_ID,                                           
MFA-TR*             HC.TOTAL_ARREARS                                            
MFA-TR*        FROM CSS_COLL_HIST_DET LH,                                       
MFA-TR*             CSS_COLLECT_HIST HC                                         
MFA-TR*       WHERE HC.ACCOUNT_NO = :HC-ACCOUNT-NO                              
MFA-TR*         AND HC.ACCOUNT_NO = LH.ACCOUNT_NO                               
MFA-TR*         AND HC.COLL_HIST_SEQ_TS = LH.COLL_HIST_SEQ_TS                   
MFA-TR*         AND LH.COLL_AGENT_ID = LH.LAST_UPDATE_USERID                    
MFA-TR*         AND LH.RECORD_CREATION_DT BETWEEN :WS-MONTH-BEG-DATE            
MFA-TR*         AND :WS-REPORT-DATE                                             
MFA-TR*       ORDER BY LH.RECORD_CREATION_DT DESC                               
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7400                                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               OPEN ARREARS                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY 'ACCOUNT NO IS : ' HC-ACCOUNT-NO                  
              MOVE '** OPEN ERROR IN 7400-GET-TOTAL-ARREARS**'          
                                          TO WS-ERR-MSG                 
              MOVE SQLCODE                TO WS-DISP-RC                 
              PERFORM 9100-DISPLAY-ERROR  THRU 9100-EXIT                
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
             FETCH ARREARS                                              
               INTO :LH-RECORD-CREATION-DT,                             
                    :HC-CALL-QUEUE-ID,                                  
                    :HC-TOTAL-ARREARS                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                    OR WS-ACTIVE-RETURN-CODE EQUAL WS-MULTIPLE-ROWS     
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 INITIALIZE                   HC-TOTAL-ARREARS          
              ELSE                                                      
                 DISPLAY 'ACCOUNT NO IS : ' HC-ACCOUNT-NO               
                 MOVE '** FETCH ERROR IN 7400-GET-TOTAL-ARREARS**'      
                                                TO WS-ERR-MSG           
                 MOVE SQLCODE                TO WS-DISP-RC              
                 PERFORM 9100-DISPLAY-ERROR  THRU 9100-EXIT             
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               CLOSE ARREARS                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY 'ACCOUNT NO IS : ' HC-ACCOUNT-NO                  
              MOVE '** CLOSE ERROR IN 7400-GET-TOTAL-ARREARS**'         
                                          TO WS-ERR-MSG                 
              MOVE SQLCODE                TO WS-DISP-RC                 
              PERFORM 9100-DISPLAY-ERROR  THRU 9100-EXIT                
           END-IF.                                                      
      *                                                                         
        7400-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ****************************************************************  04850000
      **                                                            **          
      ** 7500-GET-DATABASE.                                         **          
      ** DETERMINE WHETHER WE'RE IN SEB OR CSR.                     **  04880000
      **                                                            **          
      ****************************************************************  04900000
      *                                                                         
       7500-GET-DATABASE.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
              INTO    :C8-DELINQ-VALUE                                  
              FROM    CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
              WHERE   DELINQ_CD  = :C8-DELINQ-CD                        
              AND     COMPANY_NO = :C8-COMPANY-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*       INTO    :C8-DELINQ-VALUE                                          
MFA-TR*       FROM    CSS_DELINQUENCY                                           
MFA-TR*       WHERE   DELINQ_CD  = :C8-DELINQ-CD                                
MFA-TR*       AND     COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '* 7500-GET-DATABASE'                            
               DISPLAY '* DELINQ_CD  = ' C8-DELINQ-CD                   
               DISPLAY '* COMPANY_NO = ' C8-COMPANY-NO                  
               DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
               DISPLAY '*************************************'          
               PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04470000
      ******************************************************************04480000
      *                                                                *04490000
      *   7640-GET-REG-PROFILE-INFO.                                   *04500000
      *        FETCHES LR_REG_GROUP_CD                                 *04510000
      *                                                                *04520000
      ******************************************************************04530000
       7640-GET-REG-PROFILE-INFO.                                       
      *                                                                 04550000
           EXEC SQL                                                     
               SELECT REG_GROUP_CD                                      
                 INTO :LR-REG-GROUP-CD                                  
                 FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :WS-PREV-ACCT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REG_GROUP_CD                                              
MFA-TR*          INTO :LR-REG-GROUP-CD                                          
MFA-TR*          FROM CSS_REG_PROFILE                                           
MFA-TR*         WHERE ACCOUNT_NO = :WS-PREV-ACCT-NO                             
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7640                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04688000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                  MOVE '   ' TO LR-REG-GROUP-CD                         
              END-IF                                                    
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '***  PCSCB754 PROCESSING ERROR          ***'     
              DISPLAY '***  PARA 7640-GET-REG-PROFILE-INFO     ***'     
              DISPLAY '***  RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '***  ACCOUNT NO = ' WS-PREV-ACCT-NO              
              DISPLAY '***  PROCESSING TERMINATED              ***'     
              DISPLAY '*******************************************'     
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 04810000
       7640-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04470000
      ******************************************************************04480000
      *                                                                *04490000
      *   7650-GET-COMPANY-NO.                                         *04500000
      *        FETCHES AT_COMPANY_NO                                   *04510000
      *                                                                *04520000
      ******************************************************************04530000
       7650-GET-COMPANY-NO.                                             
      *                                                                 04550000
           EXEC SQL                                                     
               SELECT COMPANY_NO                                        
                 INTO :AT-COMPANY-NO                                    
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :WS-PREV-ACCT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NO                                                
MFA-TR*          INTO :AT-COMPANY-NO                                            
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :WS-PREV-ACCT-NO                             
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7650                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04688000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              DISPLAY '*******************************************'     
              DISPLAY '***  PCSCB754 PROCESSING ERROR          ***'     
              DISPLAY '***  PARA 7650-GET-COMPANY-NO           ***'     
              DISPLAY '***  RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '***  ACCOUNT NO = ' WS-PREV-ACCT-NO              
              DISPLAY '***  PROCESSING TERMINATED              ***'     
              DISPLAY '*******************************************'     
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 04810000
       7650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
        7900-GET-HOURS-WRKD.                                            
      *                                                                         
           MOVE '7900'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
              INTO  :C8-DELINQ-VALUE                                    
              FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                        
              WHERE DELINQ_CD  = :C8-DELINQ-CD                          
                AND COMPANY_NO = :C8-COMPANY-NO                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*       INTO  :C8-DELINQ-VALUE                                            
MFA-TR*       FROM CSS_DELINQUENCY                                              
MFA-TR*       WHERE DELINQ_CD  = :C8-DELINQ-CD                                  
MFA-TR*         AND COMPANY_NO = :C8-COMPANY-NO                                 
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7900                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
                  MOVE '** SELECT ERROR IN 7900-GET-HOURS-WRKD   **'    
                                          TO WS-ERR-MSG                 
                  MOVE SQLCODE                   TO WS-DISP-RC          
                  PERFORM 9100-DISPLAY-ERROR     THRU 9100-EXIT         
           END-IF.                                                      
      *                                                                         
        7900-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      *                                                                         
      ***************************************************************           
      **     7960-GET-RESP-AREA                                    **           
      **          GET THE RESP AREA FOR THE COLLECTOR              **           
      ***************************************************************           
      *                                                                         
       7960-GET-RESP-AREA.                                              
      *                                                                         
           MOVE '7960'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
              SELECT PF.RESP_AREA_ID                                    
                    ,PF.COMPANY_NO                                      
                    ,RTRIM(PF.LAST_NAME)                                
                    ,RTRIM(PF.FIRST_NAME)                               
                INTO :PF-RESP-AREA-ID                                   
                     ,:PF-COMPANY-NO                                    
                     ,:PF-LAST-NAME                                     
                     ,:PF-FIRST-NAME                                    
                FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                  
                WHERE USER_ID = :PF-USER-ID                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PF.RESP_AREA_ID                                            
MFA-TR*             ,PF.COMPANY_NO                                              
MFA-TR*             ,RTRIM(PF.LAST_NAME)                                        
MFA-TR*             ,RTRIM(PF.FIRST_NAME)                                       
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*              ,:PF-COMPANY-NO                                            
MFA-TR*              ,:PF-LAST-NAME                                             
MFA-TR*              ,:PF-FIRST-NAME                                            
MFA-TR*         FROM CSS_USER_PROFILE PF                                        
MFA-TR*         WHERE USER_ID = :PF-USER-ID                                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7960                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND                                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE '** SELECT ERROR IN  7960-GET-RESP-AREA     **'      
                                             TO WS-ERR-MSG              
              MOVE SQLCODE                   TO WS-DISP-RC              
              PERFORM 9100-DISPLAY-ERROR     THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
       7960-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ***************************************************************           
      **     7970-GET-RESP-AREA-DESC                               **           
      **          GET THE RESP AREA DESC FOR THE COLLECTOR         **           
      ***************************************************************           
      *                                                                         
       7970-GET-RESP-AREA-DESC.                                         
      *                                                                         
           MOVE '7970'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
              SELECT RESP_AREA_DESC                                     
                INTO :C1-RESP-AREA-DESC                                 
                FROM CSS_RESP_AREA WITH(READUNCOMMITTED)                        
                WHERE RESP_AREA_ID = :C1-RESP-AREA-ID                   
                  AND COMPANY_NO   = :C1-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_DESC                                             
MFA-TR*         INTO :C1-RESP-AREA-DESC                                         
MFA-TR*         FROM CSS_RESP_AREA                                              
MFA-TR*         WHERE RESP_AREA_ID = :C1-RESP-AREA-ID                           
MFA-TR*           AND COMPANY_NO   = :C1-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7970                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND                                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE '** SELECT ERROR IN  7970-GET-RESP-AREA-DESC   **'   
                                             TO WS-ERR-MSG              
              MOVE SQLCODE                   TO WS-DISP-RC              
              PERFORM 9100-DISPLAY-ERROR     THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
       7970-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ***************************************************************           
      ** 7980-GET-LAST-ACTIVITY                                   **            
      ** GET THE LAST ACTIVITY FOR THE COLLECTOR FOR THAT DAY     **            
      ***************************************************************           
      *                                                                         
       7980-GET-LAST-ACTIVITY.                                          
      *                                                                         
           MOVE '7980'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
              SELECT YO.ACTIVITY_ACTION_CD                              
                    ,YO.COMPANY_NO                                      
                INTO :YO-ACTIVITY-ACTION-CD                             
                    ,:YO-COMPANY-NO                                     
                FROM CSS_COLL_ACTIVITY YO WITH(READUNCOMMITTED)                 
                WHERE YO.USER_ID     = :YO-USER-ID                      
                  AND YO.ACTIVITY_DT = IIF(TRY_CONVERT(DATE, 
                                                        :WS-REPORT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-REPORT-DATE
              ) <> 0) OR (LEN(:WS-REPORT-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-REPORT-DATE
              ), CONVERT(DATE, :WS-REPORT-DATE) )                  
                  AND YO.ACTIVITY_TIME =                                
                      (SELECT MAX(Y1.ACTIVITY_TIME)                     
                              FROM CSS_COLL_ACTIVITY Y1
                           WITH(READUNCOMMITTED)                 
                              WHERE Y1.USER_ID     = :YO-USER-ID        
                                AND Y1.ACTIVITY_DT = 
              IIF(TRY_CONVERT(DATE, :WS-REPORT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-REPORT-DATE
              ) <> 0) OR (LEN(:WS-REPORT-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-REPORT-DATE
              ), CONVERT(DATE, :WS-REPORT-DATE) ))   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT YO.ACTIVITY_ACTION_CD                                      
MFA-TR*             ,YO.COMPANY_NO                                              
MFA-TR*         INTO :YO-ACTIVITY-ACTION-CD                                     
MFA-TR*             ,:YO-COMPANY-NO                                             
MFA-TR*         FROM CSS_COLL_ACTIVITY YO                                       
MFA-TR*         WHERE YO.USER_ID     = :YO-USER-ID                              
MFA-TR*           AND YO.ACTIVITY_DT = :WS-REPORT-DATE                          
MFA-TR*           AND YO.ACTIVITY_TIME =                                        
MFA-TR*               (SELECT MAX(Y1.ACTIVITY_TIME)                             
MFA-TR*                       FROM CSS_COLL_ACTIVITY Y1                         
MFA-TR*                       WHERE Y1.USER_ID     = :YO-USER-ID                
MFA-TR*                         AND Y1.ACTIVITY_DT = :WS-REPORT-DATE)           
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7980                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND                                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE '** SELECT ERROR IN  7980-GET-LAST-ACTIVITY    **'   
                                             TO WS-ERR-MSG              
              MOVE SQLCODE                   TO WS-DISP-RC              
              PERFORM 9100-DISPLAY-ERROR     THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
       7980-EXIT.                                                       
            EXIT.                                                       
      ***************************************************************           
      **                                                           **           
      **     7985-DELETE-RPT754                                    **           
      **     DELETE DB2 TABLE BEFORE ANY INSERTS                   **           
      ***************************************************************           
      *                                                                         
       7985-DELETE-RPT754.                                              
      *                                                                         
           MOVE '7985'                     TO WS-ACTIVE-PARAGRAPH       
      *                                                                         
           EXEC SQL                                                     
              SELECT MAX(COLL_DATE)                                     
              INTO :4Z-COLL-DATE                                        
              FROM CSS_RPT_PCSCA754 WITH(READUNCOMMITTED)                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(COLL_DATE)                                             
MFA-TR*       INTO :4Z-COLL-DATE                                                
MFA-TR*       FROM CSS_RPT_PCSCA754                                             
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = -305                                            
              GO TO 7985-EXIT                                           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
           DELETE FROM CSS_RPT_PCSCA754                                 
             WHERE  JOB_NAME > ' '                                      
             AND    COLL_DATE <= DATEADD( DAY, -45, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DELETE FROM CSS_RPT_PCSCA754                                         
MFA-TR*      WHERE  JOB_NAME > ' '                                              
MFA-TR*      AND    COLL_DATE <= CURRENT DATE - 45 DAYS                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCB754 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7985       **'        
              DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
           .                                                            
       7985-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      ** 7990-INSERT-COLL-ACT                                     **            
      ** INSERTS A ROW  IN CSS_COLL_ACTIVITY , WITH LAST ACTIVITY **            
      ** ROW AS LO                                                **            
      ***************************************************************           
      *                                                                         
       7990-INSERT-COLL-ACT.                                            
      *                                                                         
           MOVE '7990'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_COLL_ACTIVITY                             
                       (USER_ID                                         
                       ,ACTIVITY_DT                                     
                       ,ACTIVITY_TIME                                   
                       ,ACTIVITY_ACTION_CD                              
                       ,COMPANY_NO                                      
                       ,LAST_UPDATE_TS                                  
                       ,LAST_UPDATE_USERID)                             
               VALUES (:YO-USER-ID                                      
                      ,IIF(TRY_CONVERT(DATE, :YO-ACTIVITY-DT
              ) IS NULL OR (PATINDEX('%.%', :YO-ACTIVITY-DT
              ) <> 0) OR (LEN(:YO-ACTIVITY-DT) <> 10), CIS.CHAR2DATE(
                                                        :YO-ACTIVITY-DT
              ), CONVERT(DATE, :YO-ACTIVITY-DT) )                              
                      ,CIS.CHAR2TIME(:YO-ACTIVITY-TIME)                         
                      ,:YO-ACTIVITY-ACTION-CD                           
                      ,:YO-COMPANY-NO                                   
                      ,CIS.CHAR2TIMESTAMP(:YO-LAST-UPDATE-TS)                   
                      ,:YO-LAST-UPDATE-USERID)                          
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_COLL_ACTIVITY                                     
MFA-TR*                (USER_ID                                                 
MFA-TR*                ,ACTIVITY_DT                                             
MFA-TR*                ,ACTIVITY_TIME                                           
MFA-TR*                ,ACTIVITY_ACTION_CD                                      
MFA-TR*                ,COMPANY_NO                                              
MFA-TR*                ,LAST_UPDATE_TS                                          
MFA-TR*                ,LAST_UPDATE_USERID)                                     
MFA-TR*        VALUES (:YO-USER-ID                                              
MFA-TR*               ,:YO-ACTIVITY-DT                                          
MFA-TR*               ,:YO-ACTIVITY-TIME                                        
MFA-TR*               ,:YO-ACTIVITY-ACTION-CD                                   
MFA-TR*               ,:YO-COMPANY-NO                                           
MFA-TR*               ,:YO-LAST-UPDATE-TS                                       
MFA-TR*               ,:YO-LAST-UPDATE-USERID)                                  
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE '** INSERT ERROR IN  7990-INSERT-COLL-ACT      **'   
                                             TO WS-ERR-MSG              
              MOVE SQLCODE                   TO WS-DISP-RC              
              PERFORM 9100-DISPLAY-ERROR     THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
       7990-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **     7995-INSERT-RPT754                                    **           
      **     INSERT FILE INTO REPORT DATABASE.                     **           
      ***************************************************************           
      *                                                                         
       7995-INSERT-RPT754.                                              
                                                                        
           MOVE '7995'                     TO WS-ACTIVE-PARAGRAPH       
                                                                        
           IF E-FRP754-HOURS-ON-SYSTEM  = 0 AND                         
              E-FRP754-ACCOUNTS-WORKED  = 0 AND                         
              E-FRP754-ARREAR-ACTIONED  = 0 AND                         
              E-FRP754-NO-OF-PTPS       = 0 AND                         
              E-FRP754-PTP-AMOUNT-TOTAL = 0 AND                         
              E-FRP754-NO-KEPT          = 0 AND                         
              E-FRP754-NO-BROKEN        = 0 AND                         
              E-FRP754-AMT-KEPT         = 0 AND                         
              E-FRP754-AMT-BRKN         = 0 AND                         
              E-FRP754-AMT-COLLECTED = 0                                
              DISPLAY ' RECORD BYPASSED, NO VALUES ' E-FRP754-DATA-REC  
              GO TO 7995-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE 'PCSCB754'                TO 4Z-JOB-NAME                
           MOVE 1                         TO 4Z-VERSION-NO              
           MOVE PF-COMPANY-NO             TO 4Z-COMPANY-NO              
           ADD  1                         TO 4Z-ROW-ID                  
           MOVE E-FRP754-REG-GROUP-CD     TO 4Z-REG-GROUP-CD            
           MOVE E-FRP754-COLLECTOR-ID     TO 4Z-COLLECTOR-ID            
           MOVE E-FRP754-RESP-AREA-ID     TO 4Z-RESP-AREA-ID            
           MOVE E-FRP754-DATE             TO 4Z-COLL-DATE               
           MOVE E-FRP754-HOURS-ON-SYSTEM  TO 4Z-COLL-HRS-ON-SYSTEM      
           MOVE E-FRP754-ACCOUNTS-WORKED  TO 4Z-COLL-ACCTS-WORKED       
           MOVE E-FRP754-ARREAR-ACTIONED  TO 4Z-COLL-ARREARS-ACTND      
           MOVE E-FRP754-NO-OF-PTPS       TO 4Z-COLL-NO-OF-PTPS         
           MOVE E-FRP754-PTP-AMOUNT-TOTAL TO 4Z-COLL-PTP-TOTAL-AMT      
           MOVE E-FRP754-NO-KEPT          TO 4Z-COLL-NO-KEPT            
           MOVE E-FRP754-NO-BROKEN        TO 4Z-COLL-NO-BROKEN          
           MOVE E-FRP754-AMT-KEPT         TO 4Z-COLL-AMT-KEPT           
           MOVE E-FRP754-AMT-BRKN         TO 4Z-COLL-AMT-BROKEN         
           MOVE E-FRP754-AMT-COLLECTED    TO 4Z-COLL-AMT-COLLECTED      
           MOVE E-FRP754-DATABASE         TO 4Z-COLL-DATABASE           
           MOVE E-FRP754-RESP-AREA-DESC   TO 4Z-RESP-AREA-DESC          
           MOVE E-FRP754-COLLECTOR-NAME   TO 4Z-COLLECTOR-NAME          
           MOVE E-FRP754-CALL-QUEUE-ID    TO 4Z-COLL-CALL-QUEUE-ID      
           MOVE E-FRP754-CODE-ACCT-STAT   TO 4Z-ACCT-STAT-CD            
      *                                                                         
           EXEC SQL                                                     
           INSERT INTO CSS_RPT_PCSCA754                                 
                  ( JOB_NAME                                            
                   ,VERSION_NO                                          
                   ,CREATE_TS                                           
                   ,ROW_ID                                              
                   ,COMPANY_NO                                          
                   ,REG_GROUP_CD                                        
                   ,COLLECTOR_ID                                        
                   ,RESP_AREA_ID                                        
                   ,COLL_DATE                                           
                   ,COLL_HRS_ON_SYSTEM                                  
                   ,COLL_ACCTS_WORKED                                   
                   ,COLL_ARREARS_ACTND                                  
                   ,COLL_NO_OF_PTPS                                     
                   ,COLL_PTP_TOTAL_AMT                                  
                   ,COLL_NO_KEPT                                        
                   ,COLL_NO_BROKEN                                      
                   ,COLL_AMT_BROKEN                                     
                   ,COLL_AMT_KEPT                                       
                   ,COLL_AMT_COLLECTED                                  
                   ,COLL_DATABASE                                       
                   ,RESP_AREA_DESC                                      
                   ,COLLECTOR_NAME                                      
                   ,COLL_CALL_QUEUE_ID                                  
                   ,ACCT_STAT_CD                                        
                   ,LAST_UPDATE_TS    )                                 
           VALUES (:4Z-JOB-NAME                                         
                  ,:4Z-VERSION-NO                                       
                  ,CIS.CURRENT$TIMESTAMP()                                    
                  ,:4Z-ROW-ID                                           
                  ,:4Z-COMPANY-NO                                       
                  ,:4Z-REG-GROUP-CD                                     
                  ,:4Z-COLLECTOR-ID                                     
                  ,:4Z-RESP-AREA-ID                                     
                  ,IIF(TRY_CONVERT(DATE, :4Z-COLL-DATE
              ) IS NULL OR (PATINDEX('%.%', :4Z-COLL-DATE
              ) <> 0) OR (LEN(:4Z-COLL-DATE) <> 10), CIS.CHAR2DATE(
                                                          :4Z-COLL-DATE
              ), CONVERT(DATE, :4Z-COLL-DATE) )                                
                  ,:4Z-COLL-HRS-ON-SYSTEM                               
                  ,:4Z-COLL-ACCTS-WORKED                                
                  ,:4Z-COLL-ARREARS-ACTND                               
                  ,:4Z-COLL-NO-OF-PTPS                                  
                  ,:4Z-COLL-PTP-TOTAL-AMT                               
                  ,:4Z-COLL-NO-KEPT                                     
                  ,:4Z-COLL-NO-BROKEN                                   
                  ,:4Z-COLL-AMT-BROKEN                                  
                  ,:4Z-COLL-AMT-KEPT                                    
                  ,:4Z-COLL-AMT-COLLECTED                               
                  ,:4Z-COLL-DATABASE                                    
                  ,:4Z-RESP-AREA-DESC                                   
                  ,:4Z-COLLECTOR-NAME                                   
                  ,:4Z-COLL-CALL-QUEUE-ID                               
                  ,:4Z-ACCT-STAT-CD                                     
                  ,CIS.CURRENT$TIMESTAMP()    )                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    INSERT INTO CSS_RPT_PCSCA754                                         
MFA-TR*           ( JOB_NAME                                                    
MFA-TR*            ,VERSION_NO                                                  
MFA-TR*            ,CREATE_TS                                                   
MFA-TR*            ,ROW_ID                                                      
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,REG_GROUP_CD                                                
MFA-TR*            ,COLLECTOR_ID                                                
MFA-TR*            ,RESP_AREA_ID                                                
MFA-TR*            ,COLL_DATE                                                   
MFA-TR*            ,COLL_HRS_ON_SYSTEM                                          
MFA-TR*            ,COLL_ACCTS_WORKED                                           
MFA-TR*            ,COLL_ARREARS_ACTND                                          
MFA-TR*            ,COLL_NO_OF_PTPS                                             
MFA-TR*            ,COLL_PTP_TOTAL_AMT                                          
MFA-TR*            ,COLL_NO_KEPT                                                
MFA-TR*            ,COLL_NO_BROKEN                                              
MFA-TR*            ,COLL_AMT_BROKEN                                             
MFA-TR*            ,COLL_AMT_KEPT                                               
MFA-TR*            ,COLL_AMT_COLLECTED                                          
MFA-TR*            ,COLL_DATABASE                                               
MFA-TR*            ,RESP_AREA_DESC                                              
MFA-TR*            ,COLLECTOR_NAME                                              
MFA-TR*            ,COLL_CALL_QUEUE_ID                                          
MFA-TR*            ,ACCT_STAT_CD                                                
MFA-TR*            ,LAST_UPDATE_TS    )                                         
MFA-TR*    VALUES (:4Z-JOB-NAME                                                 
MFA-TR*           ,:4Z-VERSION-NO                                               
MFA-TR*           ,CURRENT TIMESTAMP                                            
MFA-TR*           ,:4Z-ROW-ID                                                   
MFA-TR*           ,:4Z-COMPANY-NO                                               
MFA-TR*           ,:4Z-REG-GROUP-CD                                             
MFA-TR*           ,:4Z-COLLECTOR-ID                                             
MFA-TR*           ,:4Z-RESP-AREA-ID                                             
MFA-TR*           ,:4Z-COLL-DATE                                                
MFA-TR*           ,:4Z-COLL-HRS-ON-SYSTEM                                       
MFA-TR*           ,:4Z-COLL-ACCTS-WORKED                                        
MFA-TR*           ,:4Z-COLL-ARREARS-ACTND                                       
MFA-TR*           ,:4Z-COLL-NO-OF-PTPS                                          
MFA-TR*           ,:4Z-COLL-PTP-TOTAL-AMT                                       
MFA-TR*           ,:4Z-COLL-NO-KEPT                                             
MFA-TR*           ,:4Z-COLL-NO-BROKEN                                           
MFA-TR*           ,:4Z-COLL-AMT-BROKEN                                          
MFA-TR*           ,:4Z-COLL-AMT-KEPT                                            
MFA-TR*           ,:4Z-COLL-AMT-COLLECTED                                       
MFA-TR*           ,:4Z-COLL-DATABASE                                            
MFA-TR*           ,:4Z-RESP-AREA-DESC                                           
MFA-TR*           ,:4Z-COLLECTOR-NAME                                           
MFA-TR*           ,:4Z-COLL-CALL-QUEUE-ID                                       
MFA-TR*           ,:4Z-ACCT-STAT-CD                                             
MFA-TR*           ,CURRENT TIMESTAMP    )                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -803       
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCB754 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7995       **'        
              DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**      JOBNAME   = ' 4Z-JOB-NAME                
              DISPLAY '**      VERS NO   = ' 4Z-VERSION-NO              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
           .                                                            
       7995-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **                                                              **        
      **  9000-TERMINATE.                                             **        
      **       TERMINATION ROUTINE                                    **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           DISPLAY 'PCSCB754 COMPLETED SUCCESSFULLY'.                   
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                              **         
      *  9100-DISPLAY-ERROR.                                         **         
      *       DISPLAY ERROR PARA                                     **         
      *                                                              **         
      *****************************************************************         
      *                                                                         
       9100-DISPLAY-ERROR.                                              
           DISPLAY '**   PROCESSING ERROR IN PCSCB754  **'.             
           DISPLAY '**  ', WS-ERR-MSG.                                  
           DISPLAY '**   ERROR AT ', WS-ACTIVE-PARAGRAPH.               
           DISPLAY '**   SQLCODE = ', WS-DISP-RC.                       
           DISPLAY '**   ABENDING PROGRAM              **'.             
           PERFORM 9900-ABEND              THRU 9900-EXIT.              
       9100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *  6240-GET-FCA00-COMMON-DATE                              *              
      ************************************************************              
      *                                                                         
      *COPY CPD00040.                                                           
      *                                                                         
      ************************************************************              
      *                                                          *              
      *  6251-GET-FJC01-DATE                                     *              
      *                                                          *              
      ************************************************************              
      *                                                                         
       COPY CPD00037.                                                           
      *                                                                         
      ************************************************************              
      *                                                          *              
      *  7600-START-FCSJC01                                      *              
      *                                                          *              
      ************************************************************              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ************************************************************              
      *                                                          *              
      *  7620-START-FCSCA00                                      *              
      *                                                          *              
      ************************************************************              
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
